---
title: "ASP0020: Complex types referenced by route parameters must be parsable"
description: "Learn about analysis rule ASP0020: Complex types referenced by route parameters must be parsable."
author: tdykstra
monikerRange: '>= aspnetcore-8.0'
ms.author: tdykstra
ms.date: 03/24/2023
uid: diagnostics/asp0020
---
# ASP0020: Complex types referenced by route parameters must be parsable

| | Value |
|-|-|
| **Rule ID** |ASP0020|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

A route parameter is a complex type that isn't parsable.

## Rule description

This diagnostic is emitted when a route parameter is a complex type that isn't parsable.

## How to fix violations

To fix a violation of this rule, define a `bool TryParse(string, IFormatProvider, out T)` method, where `T` is the complex type identified in the error message. As an alternative, implement <xref:System.IParsable%601>.

## When to suppress warnings

Do not suppress a warning from this rule.
