---
title: "ASP0018: Unused route parameter"
description: "Learn about analysis rule ASP0018: Unused route parameter"
author: tdykstra
monikerRange: '>= aspnetcore-8.0'
ms.author: tdykstra
ms.date: 4/1/2024
uid: diagnostics/asp0018
---
# ASP0018: Unused route parameter

| | Value |
|-|-|
| **Rule ID** |ASP0018|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

A route parameter is specified but not used.

## Rule description

A route parameter is specified but not used. In the example below, the `id` parameter is defined in the route but not in the route handler.

```csharp
var app = WebApplication.Create();

app.MapGet("/{id}", () => ...);
```

## How to fix violations

To fix a violation of this rule, remove the route parameter or add code that uses the parameter.
```csharp
var app = WebApplication.Create();

app.MapGet("/{id}", (string id) => ...);
```

## When to suppress warnings

In general, do ***not*** suppress a warning from this rule without validating the route parameter is used. Currently properties within the bound model for [FromRoute](xref:Microsoft.AspNetCore.Mvc.FromRouteAttribute) attributes may not be analyzed. For more information, see [GitHub issue `#54212`](https://github.com/dotnet/aspnetcore/issues/54212).
