---
title: "ASP0016: Do not return a value from RequestDelegate"
description: "Learn about analysis rule ASP0016: Do not return a value from RequestDelegate"
author: tdykstra
monikerRange: '>= aspnetcore-8.0'
ms.author: tdykstra
ms.date: 11/22/2022
uid: diagnostics/asp0016
---
# ASP0016: Do not return a value from RequestDelegate

| | Value |
|-|-|
| **Rule ID** |ASP0016|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

A method used to create a <xref:Microsoft.AspNetCore.Http.RequestDelegate> returns `Task<T>`. `RequestDelegate` discards this value.

## Rule description

Do not return a value `Delegate`s provided to APIs that expect `RequestDelegate`. For example, the following sample returns a `Task<string>` where the `string` value of the `Task` will be discarded.

```csharp
var app = WebApplication.Create();
app.Use(next =>
{
    return new RequestDelegate((HttpContext context) =>
    {
        return Task.FromResult(""hello world"");
    });
});
```

## How to fix violations

To fix a violation of this rule, change the return type to non-generic `Task` or, if the delegate is a route handler, cast it to `Delegate` so the return value is written to the response.

## When to suppress warnings

Do not suppress a warning from this rule.
