---
title: "ASP0015: Suggest using IHeaderDictionary properties"
description: "Learn about analysis rule ASP0015: Suggest using IHeaderDictionary properties"
author: tdykstra
monikerRange: '>= aspnetcore-8.0'
ms.author: tdykstra
ms.date: 11/23/2022
uid: diagnostics/asp0015
---
# ASP0015: Suggest using IHeaderDictionary properties

| | Value |
|-|-|
| **Rule ID** |ASP0015|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

[IHeaderDictionary](xref:System.Collections.IDictionary) properties are the recommended strategy for accessing headers.

## Rule description

`IHeaderDictionary` properties are recommended for accessing headers. Accessing headers using an indexer as in the example below is not recommended.

```csharp
var app = WebApplication.Create();

app.MapGet("/", (HttpContext context) => context.Request.Headers[""content-type""]);

app.Run();
```

## How to fix violations

To fix a violation of this rule, use the property specified in the analyzer message to access the header specified in the message or apply the associated codefix.

```csharp
var app = WebApplication.Create();
app.MapGet("/", (HttpContext context) => context.Request.Headers.ContentType);
app.Run();
```

## When to suppress warnings

Do not suppress a warning from this rule.
