---
title: "ASP0014: Suggest using top level route registrations"
description: "Learn about analysis rule ASP0014: Suggest using top level route registrations"
author: captainsafia
monikerRange: '>= aspnetcore-7.0'
ms.author: safia
ms.date: 09/27/2022
uid: diagnostics/asp0014
---
# ASP0014: Suggest using top level route registrations
| | Value |
|-|-|
| **Rule ID** |ASP0014|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

Routes can be registered directly at the top-level of a minimal API application.

## Rule description

Routes can be registered directly at the top-level of a minimal API application and don't need to be nested within a `UseEndpoints` call.

```csharp
var builder = WebApplication.CreateBuilder(args);

var app = builder.Build();

app.UseEndpoints(endpoints =>
{
    endpoints.MapGet("/", () => "Hello World!");
});

app.Run();
```

## How to fix violations

To fix a violation of this rule, register the endpoints directly on the `WebApplication`.

```csharp
var builder = WebApplication.CreateBuilder(args);

var app = builder.Build();

app.MapGet("/", () => "Hello World!");

app.Run();
```

## When to suppress warnings

Warnings from this rule can be suppressed if the target `UseEndpoints` invocation is invoked without any mappings as a strategy to organize middleware ordering.

```csharp
var builder = WebApplication.CreateBuilder(args);

var app = builder.Build();

#pragma warning disable ASP0014
app.UseEndpoints(e => {});
#pragma warning restore ASP0014

app.Run();
```

