---
title: "ASP0013: Suggest switching from using Configure methods to WebApplicationBuilder.Configuration"
description: "Learn about analysis rule ASP0013: Suggest switching from using Configure methods to WebApplicationBuilder.Configuration"
author: rick-anderson
monikerRange: '>= aspnetcore-7.0'
ms.author: riande
ms.date: 09/27/2022
uid: diagnostics/asp0013
---
# ASP0013: Suggest switching from using Configure methods to WebApplicationBuilder.Configuration

| | Value |
|-|-|
| **Rule ID** |ASP0013|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

<xref:Microsoft.AspNetCore.Hosting.StartupBase.Configure%2A> isn't the recommended strategy for reading and writing to configuration in a minimal API app. `Configure` was designed to be used with [Web Host](/dotnet/api/microsoft.aspnetcore.hosting.iwebhostbuilder) or [.NET Generic Host](/dotnet/core/extensions/generic-host). In a minimal API app, [WebApplicationBuilder.Configuration](xref:Microsoft.AspNetCore.Builder.WebApplicationBuilder.Configuration) should be used to modify configuration directly.

## Rule description

`Configure` isn't the recommended strategy for configuring logging in a minimal API app.

```csharp
var builder = WebApplication.CreateBuilder(args);

builder.Host.ConfigureAppConfiguration(builder =>
{
    builder.AddJsonFile("customAppSettings.json");
})

var app = builder.Build();

app.Run();
```

## How to fix violations

To fix a violation of this rule, use [WebApplicationBuilder.Configuration](xref:Microsoft.AspNetCore.Builder.WebApplicationBuilder.Configuration) to modify application configuration directly without the need for an additional <xref:Microsoft.Extensions.Hosting.HostBuilder.ConfigureAppConfiguration%2A> call.

```csharp
var builder = WebApplication.CreateBuilder(args);

builder.Configuration.AddJsonFile("customAppSettings.json");

var app = builder.Build();

app.Run();
```

## When to suppress warnings

Do ***not*** suppress a warning from this rule.
