---
title: "ASP0012: Suggest using builder.Services over Host.ConfigureServices or WebHost.ConfigureServices"
description: "Learn about analysis rule ASP0012: Suggest using builder.Services over Host.ConfigureServices or WebHost.ConfigureServices"
author: safia
monikerRange: '>= aspnetcore-7.0'
ms.author: safia
ms.date: 09/27/2022
uid: diagnostics/asp0012
---
# ASP0012: Suggest using builder.Services over Host.ConfigureServices or WebHost.ConfigureServices

| | Value |
|-|-|
| **Rule ID** |ASP0012|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

`ConfigureServices` isn't the recommended strategy for registering services in DI in a minimal API application.

## Rule description

`ConfigureServices` isn't the recommended strategy for configuring logging in a minimal API application.

```csharp
var builder = WebApplication.CreateBuilder(args);

builder.Host.ConfigureServices(services =>
{
    services.AddAntiforgery();
})

var app = builder.Build();

app.Run();
```

## How to fix violations

To fix a violation of this rule, use the `Services` property on the `WebApplicationBuilder` to modify the DI container directly without the need for an additional `ConfigureServices` call.

```csharp
var builder = WebApplication.CreateBuilder(args);

builder.Services.AddAntiforgery();

var app = builder.Build();

app.Run();
```

## When to suppress warnings

Do ***not*** suppress a warning from this rule.
