---
title: "ASP0011: Suggest using builder.Logging over Host.ConfigureLogging or WebHost.ConfigureLogging"
description: "Learn about analysis rule ASP0011: Suggest using builder.Logging over Host.ConfigureLogging or WebHost.ConfigureLogging"
author: safia
monikerRange: '>= aspnetcore-7.0'
ms.author: safia
ms.date: 09/27/2022
uid: diagnostics/asp0011
---
# ASP0011: Suggest using builder.Logging over Host.ConfigureLogging or WebHost.ConfigureLogging

| | Value |
|-|-|
| **Rule ID** |ASP0011|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

`ConfigureLogging` isn't the recommended strategy for configuring logging in a minimal API application.

## Rule description

`ConfigureLogging` isn't the recommended strategy for configuring logging in a minimal API application.

```csharp
var builder = WebApplication.CreateBuilder(args);

builder.Host.ConfigureLogging(logging =>
{
    logging.AddJsonConsole();
})

var app = builder.Build();

app.Run();
```

## How to fix violations

To fix a violation of this rule, use the `Logging` property on the `WebApplicationBuilder` to modify the logging configuration directly without the need for an additional `ConfigureLogging` call.

```csharp
var builder = WebApplication.CreateBuilder(args);

builder.Logging.AddJsonConsole();

var app = builder.Build();

app.Run();
```

## When to suppress warnings

Do ***not*** suppress a warning from this rule.
