---
title: "ASP0010: Do not use UseStartup with WebApplicationBuilder.WebHost"
description: "Learn about analysis rule ASP0010: Do not use UseStartup with WebApplicationBuilder.WebHost"
author: safia
monikerRange: '>= aspnetcore-7.0'
ms.author: wpickett
ms.date: 09/23/2022
uid: diagnostics/asp0010
---
# ASP0010: Do not use UseStartup with WebApplicationBuilder.WebHost

| | Value |
|-|-|
| **Rule ID** |ASP0010|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

`UseStartup` can't be used with `WebApplicationBuilder.WebHost`.

## Rule description

The `WebApplicationBuilder` doesn't support configuration via a `Startup` class.

```csharp
var builder = WebApplication.CreateBuilder(args);

builder.WebHost.UseStartup<Startup>();

var app = builder.Build();

app.Run();
```

## How to fix violations

To fix a violation of this rule, leverage the `Configuration` and `Services` properties on the `WebApplicationBuilder` to modify configuration and DI directly, without the need for a startup class.

```csharp
var builder = WebApplication.CreateBuilder(args);

builder.Services.AddAuthentication();

var app = builder.Build();

app.Run();
```

## When to suppress warnings

Do ***not*** suppress a warning from this rule. A misconfigured application can result in unexpected behavior at runtime.
