---
title: "ASP0009: Do not use Configure with WebApplicationBuilder.WebHost"
description: "Learn about analysis rule ASP0009: Do not use Configure with WebApplicationBuilder.WebHost"
author: safia
monikerRange: '>= aspnetcore-7.0'
ms.author: safia
ms.date: 09/23/2022
uid: diagnostics/asp0009
---
# ASP0009: Do not use Configure with WebApplicationBuilder.WebHost

| | Value |
|-|-|
| **Rule ID** |ASP0009|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

`Configure` can't be used with the `WebHost` property on `WebApplicationBuilder`.

## Rule description

The `WebApplicationBuilder` doesn't support configuring the `WebHost` before build using the `Configure` extension method.

```csharp
var builder = WebApplication.CreateBuilder(args);

builder.WebHost.Configure(webHostBuilder => {
    webHostBuilder.UseContentRootPath(Path.Combine(Directory.GetCurrentDirectory(), "myContentRoot"));
});

var app = builder.Build();

app.Run();
```

## How to fix violations

To fix a violation of this rule, configure the `WebHost` directly on the `WebApplicationBuilder`. For example, instead of setting the content root path via `Configure`.

```csharp
var builder = WebApplication.CreateBuilder(args);

builder.WebHost.Configure(webHostBuilder =>
{
    webHostBuilder.UseContentRoot(Path.Combine(Directory.GetCurrentDirectory(), "myContentRoot"));
});

var app = builder.Build();

app.Run();
```

Configure the content root path directly on the `WebApplicationBuilder`.

```csharp
var builder = WebApplication.CreateBuilder(args);

builder.WebHost.UseContentRoot(Path.Combine(Directory.GetCurrentDirectory(), "myContentRoot"));

var app = builder.Build();

app.Run();
```

## When to suppress warnings

Do ***not*** suppress a warning from this rule. A misconfigured application can result in unexpected behavior at runtime.
