---
title: "ASP0008: Do not use ConfigureWebHost with WebApplicationBuilder.Host"
description: "Learn about analysis rule ASP0008: Do not use ConfigureWebHost with WebApplicationBuilder.Host"
author: safia
monikerRange: '>= aspnetcore-7.0'
ms.author: safia
ms.date: 09/23/2022
uid: diagnostics/asp0008
---
# ASP0008: Do not use ConfigureWebHost with WebApplicationBuilder.Host

| | Value |
|-|-|
| **Rule ID** |ASP0008|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

`ConfigureWebHost` can't be used with the `Host` property on `WebApplicationBuilder`.

## Rule description

The `WebApplicationBuilder` doesn't support configuring the `WebHost` before build using the `ConfigureWebHost` extension method.

```csharp
var builder = WebApplication.CreateBuilder(args);

builder.Host.ConfigureWebHost(webHostBuilder => {
    webHostBuilder.UseContentRoot(Path.Combine(Directory.GetCurrentDirectory(), "myContentRoot"));
});

var app = builder.Build();

app.Run();
```

## How to fix violations

To fix a violation of this rule, configure the `WebHost` directly on the `WebApplicationBuilder`. For example, instead of setting the content root path via `ConfigureWebHost`.

```csharp
var builder = WebApplication.CreateBuilder(args);

builder.Host.ConfigureWebHost(webHostBuilder =>
{
    webHostBuilder.UseContentRoot(Path.Combine(Directory.GetCurrentDirectory(), "myContentRoot"));
});

var app = builder.Build();

app.Run();
```

Configure the content root path directly on the `WebApplicationBuilder.WebHost`.

```csharp
var builder = WebApplication.CreateBuilder(args);

builder.WebHost.UseContentRoot(Path.Combine(Directory.GetCurrentDirectory(), "foobar"));

var app = builder.Build();

app.Run();
```

## When to suppress warnings

Do ***not*** suppress a warning from this rule. A misconfigured application can result in unexpected behavior at runtime.
