---
title: "ASP0006: Do not use non-literal sequence numbers"
description: "Learn about analysis rule ASP0006: Do not use non-literal sequence numbers"
author: safia
monikerRange: '>= aspnetcore-6.0'
ms.author: riande
ms.date: 10/21/2021
uid: diagnostics/asp0006
---
# ASP0006: Do not use non-literal sequence numbers

| | Value |
|-|-|
| **Rule ID** |ASP0006|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

An invocation on a method in <xref:Microsoft.AspNetCore.Components.Rendering.RenderTreeBuilder> containing a sequence number that isn't a literal as a parameter.

## Rule description

Blazor's UI diffing algorithm relies on sequence numbers to determine which elements have changed. Computing the sequence number dynamically or using a counter can result in poor diffing performance. Instead, use a literal sequence number that maps to the source code line for the element. For example, the following code produces an error:

```csharp
using Microsoft.AspNetCore.Components.Rendering;
var builder = new RenderTreeBuilder();
var seqNum = 1;
builder.OpenElement(seqNum, "div");
builder.CloseElement();
```

## How to fix violations

To fix a violation of this rule, make sure that calls to methods on the <xref:Microsoft.AspNetCore.Components.Rendering.RenderTreeBuilder> class that take a sequence number as a parameter use a literal sequence number.

```csharp
using Microsoft.AspNetCore.Components.Rendering;
var builder = new RenderTreeBuilder();
builder.OpenElement(0, "div");
builder.CloseElement();
```

## When to suppress warnings

Do ***not*** suppress a warning from this rule. Using a non-literal sequence number can result in performance degradation.
