---
title: "ASP0003: Do not use action results with route handlers"
description: "Learn about analysis rule ASP0003: Do not use action results with route handlers"
author: safia
monikerRange: '>= aspnetcore-6.0'
ms.author: riande
ms.date: 10/21/2021
uid: diagnostics/asp0003
---
# ASP0003: Do not use model binding attributes with route handlers

| | Value |
|-|-|
| **Rule ID** |ASP0003|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

A route handler delegate includes a parameter that has a [`[Bind]`](xref:Microsoft.AspNetCore.Mvc.BindAttribute) attribute.

## Rule description

Route handler endpoints only support a subset of MVC attributes such as [`[FromRoute]`](xref:Microsoft.AspNetCore.Mvc.FromRouteAttribute), [`[FromBody]`](xref:Microsoft.AspNetCore.Mvc.FromBodyAttribute), etc. Unsupported attributes are ignored and result in unexpected binding behavior. For example, the following code results in an analyzer warning:

```csharp
app.MapGet("/todos/{id}", ([Bind] int id) => new Todo { Id = id });
```

## How to fix violations

To fix a violation of this rule, make sure that the endpoint uses one of the allowed model binding attributes.

```csharp
app.MapGet("/todos/{id}", ([FromRoute] int id) => new Todo { Id = id });
```

## When to suppress warnings

Do ***not*** suppress a warning from this rule. An incorrect model binding setup can result in unexpected behavior when resolving parameters at runtime.
