---
title: "ASP0000: Do not call 'IServiceCollection.BuildServiceProvider' in 'ConfigureServices'"
description: "Learn about analysis rule ASP0000: Do not call 'IServiceCollection.BuildServiceProvider' in 'ConfigureServices'"
author: pranavkm
monikerRange: '>= aspnetcore-5.0'
ms.author: wpickett
ms.date: 10/21/2021
uid: diagnostics/asp0000
---
# ASP0000: Do not call 'IServiceCollection.BuildServiceProvider' in 'ConfigureServices'

| | Value |
|-|-|
| **Rule ID** |ASP0000|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

A call to <xref:Microsoft.Extensions.DependencyInjection.ServiceCollectionContainerBuilderExtensions.BuildServiceProvider%2A> was detected in the application start up code.

## Rule description

Calling 'BuildServiceProvider' from application code results in more than one copy of singleton services being created which might result in incorrect application behavior. Consider alternatives such as dependency injecting services as parameters to 'Configure'.

## How to fix violations

Remove the call to `BuildServiceProvider` from the application startup code.

## When to suppress warnings

It is safe to suppress this rule if updating the application to remove the call to `BuildServiceProvider` is non-trivial and you have thoroughly tested the application to ensure multiple singleton services are not added.
