---
title: Build a Blazor movie database app (Overview)
author: guardrex
description: This tutorial explains the basics of building a Blazor Web App with a database, Entity Framework (EF) Core, and user interactivity.
ms.author: riande
ms.date: 11/12/2024
monikerRange: '>= aspnetcore-8.0'
ms.custom: mvc
uid: blazor/tutorials/movie-database-app/index
---
# Build a Blazor movie database app (Overview)

[!INCLUDE[](~/includes/not-latest-version-without-not-supported-content.md)]

This tutorial explains the basics of building a Blazor Web App with a database, Entity Framework (EF) Core, and user interactivity.

Parts of this series include:

1. [Create a Blazor Web App](xref:blazor/tutorials/movie-database-app/part-1)
1. [Add and scaffold a model](xref:blazor/tutorials/movie-database-app/part-2)
1. [Learn about Razor components](xref:blazor/tutorials/movie-database-app/part-3)
1. [Work with a database](xref:blazor/tutorials/movie-database-app/part-4)
1. [Add validation](xref:blazor/tutorials/movie-database-app/part-5)
1. [Add search](xref:blazor/tutorials/movie-database-app/part-6)
1. [Add a new field](xref:blazor/tutorials/movie-database-app/part-7)
1. [Add interactivity](xref:blazor/tutorials/movie-database-app/part-8)

At the end of the tutorial, you'll have a Blazor Web App that can display and manage movies in a movie database.

## Secure authentication flow required for production apps

This tutorial uses a local database that doesn't require user authentication. Production apps should use the most secure authentication flow available. For more information on authentication for deployed test and production Blazor Web Apps, see the following resources:

* <xref:blazor/security/index>
* <xref:blazor/security/index> and the following articles in the *Server* security node
* <xref:blazor/security/blazor-web-app-oidc>
* <xref:blazor/security/blazor-web-app-entra>

For Microsoft Azure services, we recommend using *managed identities*. Managed identities securely authenticate to Azure services without storing credentials in app code. For more information, see the following resources:

* [What are managed identities for Azure resources? (Microsoft Entra documentation)](/entra/identity/managed-identities-azure-resources/overview)
* Azure services documentation
  * [Managed identities in Microsoft Entra for Azure SQL](/azure/azure-sql/database/authentication-azure-ad-user-assigned-managed-identity)
  * [How to use managed identities for App Service and Azure Functions](/azure/app-service/overview-managed-identity)

## Sample app

If you don't intend to create the demonstration app while reading the article, you can refer to the completed sample app in the [Blazor samples GitHub repository (`dotnet/blazor-samples`)](https://github.com/dotnet/blazor-samples). Select the latest version folder in the repository. The sample folder for this tutorial's project is named `BlazorWebAppMovies`.

## Article code examples

The line breaks of code examples shown in the ASP.NET Core documentation often don't match line breaks in scaffolded code generated by tooling for an app. This is due to an article publishing limitation. Lines of code in articles are generally limited to 85 characters in length, and we manually adjust the line length using line breaks to satisfy our publishing guidelines.

As you work through this tutorial or use any other ASP.NET Core article's code examples, you never need to adjust scaffolded code in your app to match the line breaks displayed in article code examples.

## Report a tutorial issue

To open a documentation GitHub issue for an article of the series, use the **Open a documentation issue** link at the bottom of the article. Using the link to create your issue adds important tracking metadata to the issue and automatically pings the author of the article.

## Support requests

We welcome feedback on the tutorial's articles, such as bug reports and comments on the article's text, but we're often unable to provide product support. If you run into a problem while following the tutorial, don't immediately open a documentation issue. Check the steps that you've taken against the article and compare your code to the [sample app](#sample-app) before opening an issue because many problems can be traced to missing a step or not following a step correctly.

For general questions about .NET and Blazor beyond the tutorial and reference documentation or to obtain assistance from the .NET community, converse with developers in [public forums](xref:blazor/fundamentals/index#support-requests).

## Next steps

> [!div class="step-by-step"]
> [Next: Create a Blazor Web App](xref:blazor/tutorials/movie-database-app/part-1)
