---
title: Use browser developer tools with ASP.NET Core Blazor Hybrid
author: guardrex
description: Learn how to use browser developer tools with ASP.NET Core Blazor Hybrid apps.
monikerRange: '>= aspnetcore-6.0'
ms.author: riande
ms.custom: "mvc"
ms.date: 11/12/2024
uid: blazor/hybrid/developer-tools
zone_pivot_groups: blazor-hybrid-operating-systems
---
# Use browser developer tools with ASP.NET Core Blazor Hybrid

[!INCLUDE[](~/includes/not-latest-version.md)]

<!-- This topic drops loc for "Mac Catalyst" -->

This article explains how to use [browser developer tools](https://developer.mozilla.org/docs/Glossary/Developer_Tools) with Blazor Hybrid apps.

## Browser developer tools with .NET MAUI Blazor

Ensure the Blazor Hybrid project is configured to support browser developer tools. You can confirm developer tools support by searching the app for `AddBlazorWebViewDeveloperTools`.

If the project isn't already configured for browser developer tools, add support by:

1. Locating where the call to <xref:Microsoft.Extensions.DependencyInjection.BlazorWebViewServiceCollectionExtensions.AddMauiBlazorWebView%2A> is made, likely within the app's `MauiProgram.cs` file.
1. At the top of the `MauiProgram.cs` file, confirm the presence of a `using` statement for <xref:Microsoft.Extensions.Logging?displayProperty=fullName>. If the `using` statement isn't present, add it to the top of the file:

   ```csharp
   using Microsoft.Extensions.Logging;
   ```

1. After the call to <xref:Microsoft.Extensions.DependencyInjection.BlazorWebViewServiceCollectionExtensions.AddMauiBlazorWebView%2A>, add the following code:

   ```csharp
   #if DEBUG
       builder.Services.AddBlazorWebViewDeveloperTools();
       builder.Logging.AddDebug();
   #endif
   ```

:::zone pivot="windows"

To use browser developer tools with a Windows app:

1. Run the .NET MAUI Blazor Hybrid app for Windows and navigate to an app page that uses a <xref:Microsoft.AspNetCore.Components.WebView.Maui.BlazorWebView>. The developer tools console is unavailable from <xref:Microsoft.Maui.Controls.ContentPage>s without a Blazor :::no-loc text="Web View":::.
1. Use the keyboard shortcut <kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>I</kbd> to open browser developer tools.
1. Developer tools provide a variety of features for working with apps, including which assets the page requested, how long assets took to load, and the content of loaded assets. The following example shows the **Console** tab to see the console messages, which includes any exception messages generated by the framework or developer code:

   ![Microsoft Edge DevTools window for a Blazor Hybrid app running on Windows](~/blazor/hybrid/developer-tools/_static/edge2.png)

:::zone-end

:::zone pivot="android"

To use browser developer tools with an Android app:

1. Start the Android emulator and navigate to an app page that uses a <xref:Microsoft.AspNetCore.Components.WebView.Maui.BlazorWebView>. The developer tools console is unavailable from <xref:Microsoft.Maui.Controls.ContentPage>s without a Blazor :::no-loc text="Web View":::.
1. Open Google Chrome or Microsoft Edge.
1. Navigate to `chrome://inspect/#devices` (Google Chrome) or `edge://inspect/#devices` (Microsoft Edge).
1. Select the **`inspect`** link button to open developer tools. The following example shows the **DevTools** page in Microsoft Edge:

   ![Microsoft Edge Devices showing the BlazorWebView's "inspect" link button to open developer tools.](~/blazor/hybrid/developer-tools/_static/android.png)

1. Developer tools provide a variety of features for working with apps, including which assets the page requested, how long assets took to load, and the content of loaded assets. The following example shows the **Console** tab to see the console messages, which includes any exception messages generated by the framework or developer code:

   ![Microsoft Edge DevTools window for a Blazor Hybrid app running on an emulated Pixel 5](~/blazor/hybrid/developer-tools/_static/edge1.png)

:::zone-end

:::zone pivot="ios"

To use Safari developer tools with an iOS app:

1. Open desktop Safari.
1. Select the **Safari** > **Preferences** > **Advanced** > **Show Develop menu in the menu bar** checkbox.
1. Run the .NET MAUI Blazor Hybrid app in the iOS simulator and navigate to an app page that uses a <xref:Microsoft.AspNetCore.Components.WebView.Maui.BlazorWebView>. The developer tools console is unavailable from <xref:Microsoft.Maui.Controls.ContentPage>s without a Blazor :::no-loc text="Web View":::.
1. Return to Safari. Select **Develop** > **{REMOTE INSPECTION TARGET}** > **0.0.0.0**, where the `{REMOTE INSPECTION TARGET}` placeholder is either the devices's plain name (for example, `MacBook Pro`) or the device's serial number (for example `XMVM7VFF10`). If multiple entries for **0.0.0.0** are present, select the entry that highlights the <xref:Microsoft.AspNetCore.Components.WebView.Maui.BlazorWebView>. The <xref:Microsoft.AspNetCore.Components.WebView.Maui.BlazorWebView> is highlighted in blue in the iOS simulator when the correct **0.0.0.0** entry is selected.

   ![Safari Develop Simulator open showing two entries for "0.0.0.0" with the second entry selected because it highlights the BlazorWebView in the Visual Studio emulator UI.](~/blazor/hybrid/developer-tools/_static/ios.png)

1. The **Web Inspector** window appears for the <xref:Microsoft.AspNetCore.Components.WebView.Maui.BlazorWebView>.
1. Developer tools provide a variety of features for working with apps, including which assets the page requested, how long assets took to load, and the content of loaded assets. The following example shows the **Console** tab, which includes any exception messages generated by the framework or developer code:

   ![Safari Web Inspector and Simulator windows for a Blazor Hybrid app running on an emulated iPad mini](~/blazor/hybrid/developer-tools/_static/safari1.png)

:::zone-end

:::zone pivot="macos"

<!-- On macOS, XML files use 4-space indents. Also, the PU uses 4-space indents in the .NET MAUI template file. -->

:::moniker range="< aspnetcore-8.0"

Add the `com.apple.security.get-task-allow` key, of type `Boolean`, to the [entitlements file](/dotnet/maui/ios/entitlements) of the app for its debug build.

To add an entitlements file with the `com.apple.security.get-task-allow` key, add the following XML file named `Entitlements.Debug.plist` to the `Platforms/MacCatalyst` folder of the project.

`Platforms/MacCatalyst/Entitlements.Debug.plist`:

```xml
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
<plist version="1.0">
<dict>
    <key>com.apple.security.get-task-allow</key>
    <true/>
</dict>
</plist>
```

To consume the entitlements file for debug builds on :::no-loc text="Mac Catalyst":::, add the following `<PropertyGroup>` node to the app's project file as a child of the `<Project>` node:

```xml
<PropertyGroup Condition="$([MSBuild]::GetTargetPlatformIdentifier('$(TargetFramework)')) == 'maccatalyst' and '$(Configuration)' == 'Debug'">
    <CodeSignEntitlements>Platforms/MacCatalyst/Entitlements.Debug.plist</CodeSignEntitlements>
</PropertyGroup>
```

:::moniker-end

To use Safari developer tools with a macOS app:

1. Open desktop Safari.
1. Select the **Safari** > **Preferences** > **Advanced** > **Show Develop menu in the menu bar** checkbox.
1. Run the .NET MAUI Blazor Hybrid app in macOS.
1. Return to Safari. Select **Develop** > **{REMOTE INSPECTION TARGET}** > **0.0.0.0**, where the `{REMOTE INSPECTION TARGET}` placeholder is either the devices's plain name (for example, `MacBook Pro`) or the device's serial number (for example `XMVM7VFF10`). If multiple entries for **0.0.0.0** are present, select the entry that highlights the <xref:Microsoft.AspNetCore.Components.WebView.Maui.BlazorWebView>. The <xref:Microsoft.AspNetCore.Components.WebView.Maui.BlazorWebView> is highlighted in blue in macOS when the correct **0.0.0.0** entry is selected.
1. The **Web Inspector** window appears for the <xref:Microsoft.AspNetCore.Components.WebView.Maui.BlazorWebView>.
1. Developer tools provide a variety of features for working with apps, including which assets the page requested, how long assets took to load, and the content of loaded assets. The following example shows the **Console** tab, which includes any exception messages generated by the framework or developer code:

   ![Safari Web Inspector for a Blazor Hybrid app](~/blazor/hybrid/developer-tools/_static/safari2.png)

:::zone-end

## Additional resources

* [Chrome DevTools](https://developer.chrome.com/docs/devtools/)
* [Microsoft Edge Developer Tools overview](/microsoft-edge/devtools-guide-chromium/)
* [Safari Developer Help](https://support.apple.com/guide/safari-developer/welcome/mac)
