# `swift:5.10.1-amazonlinux2`

## Docker Metadata

- Image ID: `sha256:a2bec77806a9247e267d55f612d9c1b6c93ec78680d7bd40bba833629492719b`
- Created: `2024-06-06T15:11:32Z`
- Virtual Size: ~ 2.96 Gb  
  (total size of all layers on-disk)
- Arch: `linux`/`amd64`
- Command: `["/bin/bash"]`
- Environment:
  - `PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin`
  - `SWIFT_SIGNING_KEY=A62AE125BBBFBB96A6E042EC925CC1CCED3D1561`
  - `SWIFT_PLATFORM=amazonlinux2`
  - `SWIFT_BRANCH=swift-5.10.1-release`
  - `SWIFT_VERSION=swift-5.10.1-RELEASE`
  - `SWIFT_WEBROOT=https://download.swift.org`
- Labels:
  - `description=Docker Container for the Swift programming language`
  - `maintainer=Swift Infrastructure <swift-infrastructure@forums.swift.org>`

## `rpm` (`.rpm`-based packages)

### `rpm` package: `acl-2.2.51-14.amzn2.x86_64`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url acl-2.2.51-14.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/d21969f8fbccf539fa601961f20352b7c95b4cf593c9fa5dad2ac4896c7ca6c9/acl-2.2.51-14.amzn2.src.rpm
```

### `rpm` package: `amazon-linux-extras-2.0.3-1.amzn2.noarch`

Licenses (from `rpm --query`): GPLv2

Source:

```console
$ dnf --quiet download --source --url amazon-linux-extras-2.0.3-1.amzn2.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/c8391609150db76aac95144697183fcaff68c7b05fb74b19e1b4f42af0bf158a/amazon-linux-extras-2.0.3-1.amzn2.src.rpm
```

### `rpm` package: `audit-libs-2.8.1-3.amzn2.1.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url audit-libs-2.8.1-3.amzn2.1
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/6af950cd493703410c3c041e3343bf1618b94f4f5a2e72976d8ab1d31f625871/audit-2.8.1-3.amzn2.1.src.rpm
```

### `rpm` package: `basesystem-10.0-7.amzn2.0.1.noarch`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url basesystem-10.0-7.amzn2.0.1.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/303ffc769b33bd06f7d3c5d0a1999079ad5afb6d205448dd607a8b6a5cbc3551/basesystem-10.0-7.amzn2.0.1.src.rpm
```

### `rpm` package: `bash-4.2.46-34.amzn2.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url bash-4.2.46-34.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/088b4acd2aa66aac9479237b6c06724ef38173941734da6a81fb28add6418143/bash-4.2.46-34.amzn2.src.rpm
```

### `rpm` package: `binutils-2.29.1-31.amzn2.0.1.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url binutils-2.29.1-31.amzn2.0.1
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/a33436c7c61b515913fd383db5451104b67b501fd3d0c5292121f0196cd61070/binutils-2.29.1-31.amzn2.0.1.src.rpm
```

### `rpm` package: `bzip2-libs-1.0.6-13.amzn2.0.3.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url bzip2-libs-1.0.6-13.amzn2.0.3
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/5eb7c8b4ed1b326f5e640d655f92f498451c8013b223ad5702abb108358ef0dc/bzip2-1.0.6-13.amzn2.0.3.src.rpm
```

### `rpm` package: `ca-certificates-2023.2.68-1.amzn2.0.1.noarch`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url ca-certificates-2023.2.68-1.amzn2.0.1.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/e878865cbe45198bb2380a20d6016ecee2c8f9593e03c89eb8bcd037c54b53b4/ca-certificates-2023.2.68-1.amzn2.0.1.src.rpm
```

### `rpm` package: `chkconfig-1.7.4-1.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPLv2

Source:

```console
$ dnf --quiet download --source --url chkconfig-1.7.4-1.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/227e42c03e4cdcc55a1851cfe633f2a280cb53eea907a581d95422575f584465/chkconfig-1.7.4-1.amzn2.0.2.src.rpm
```

### `rpm` package: `coreutils-8.22-24.amzn2.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url coreutils-8.22-24.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/7785c3a49bafaa745c01233429d6dab66539416864de241fb29aea434a29dcb2/coreutils-8.22-24.amzn2.src.rpm
```

### `rpm` package: `cpio-2.12-11.amzn2.0.1.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url cpio-2.12-11.amzn2.0.1
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/bb095c4c518e2c72a241855ea49e34dc5a9972ff7cecfcbdd3e1975a346843de/cpio-2.12-11.amzn2.0.1.src.rpm
```

### `rpm` package: `cpp-7.3.1-17.amzn2.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD

Source:

```console
$ dnf --quiet download --source --url cpp-7.3.1-17.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/a2b874b1e83eb065848df3e26205c7e903eb46b4c4f40adf7a6a68a1af38698f/gcc-7.3.1-17.amzn2.src.rpm
```

### `rpm` package: `cracklib-2.9.0-11.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url cracklib-2.9.0-11.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/5f4d78fd25c6fbf6525699de780220c4adcfdd9c4a4247e94b4a22c84c678574/cracklib-2.9.0-11.amzn2.0.2.src.rpm
```

### `rpm` package: `cracklib-dicts-2.9.0-11.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url cracklib-dicts-2.9.0-11.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/5f4d78fd25c6fbf6525699de780220c4adcfdd9c4a4247e94b4a22c84c678574/cracklib-2.9.0-11.amzn2.0.2.src.rpm
```

### `rpm` package: `cryptsetup-libs-1.7.4-4.amzn2.x86_64`

Licenses (from `rpm --query`): GPLv2+ and LGPLv2+

Source:

```console
$ dnf --quiet download --source --url cryptsetup-libs-1.7.4-4.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/ad16b6f4596e77afa5ae62a92ff619786518ab11b2a6644d0ee53a146b10b021/cryptsetup-1.7.4-4.amzn2.src.rpm
```

### `rpm` package: `curl-8.3.0-1.amzn2.0.7.x86_64`

Licenses (from `rpm --query`): curl

Source:

```console
$ dnf --quiet download --source --url curl-8.3.0-1.amzn2.0.7
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/6960e828bd1d1b84705b13d60d95d6fcfa38f4a169c1b8463981c6169c49699d/curl-8.3.0-1.amzn2.0.7.src.rpm
```

### `rpm` package: `cyrus-sasl-lib-2.1.26-24.amzn2.0.1.x86_64`

Licenses (from `rpm --query`): BSD with advertising

Source:

```console
$ dnf --quiet download --source --url cyrus-sasl-lib-2.1.26-24.amzn2.0.1
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/35e086928aa7cd621793f2157824668862228d873c714508e5bbc13979cfe2f3/cyrus-sasl-2.1.26-24.amzn2.0.1.src.rpm
```

### `rpm` package: `dbus-1.10.24-7.amzn2.0.4.x86_64`

Licenses (from `rpm --query`): (GPLv2+ or AFL) and GPLv2+

Source:

```console
$ dnf --quiet download --source --url dbus-1.10.24-7.amzn2.0.4
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/e6b2be75080c6f12426c6bf3db19e700b1d40421810d21832cf6fc0fd5dcd868/dbus-1.10.24-7.amzn2.0.4.src.rpm
```

### `rpm` package: `dbus-libs-1.10.24-7.amzn2.0.4.x86_64`

Licenses (from `rpm --query`): (GPLv2+ or AFL) and GPLv2+

Source:

```console
$ dnf --quiet download --source --url dbus-libs-1.10.24-7.amzn2.0.4
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/e6b2be75080c6f12426c6bf3db19e700b1d40421810d21832cf6fc0fd5dcd868/dbus-1.10.24-7.amzn2.0.4.src.rpm
```

### `rpm` package: `device-mapper-1.02.170-6.amzn2.5.x86_64`

Licenses (from `rpm --query`): GPLv2

Source:

```console
$ dnf --quiet download --source --url device-mapper-1.02.170-6.amzn2.5
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/aea93855268245d78188bb7ba2dcffe4283f8a4b8d9c73468ae06a8c5a23abe6/lvm2-2.02.187-6.amzn2.5.src.rpm
```

### `rpm` package: `device-mapper-libs-1.02.170-6.amzn2.5.x86_64`

Licenses (from `rpm --query`): LGPLv2

Source:

```console
$ dnf --quiet download --source --url device-mapper-libs-1.02.170-6.amzn2.5
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/aea93855268245d78188bb7ba2dcffe4283f8a4b8d9c73468ae06a8c5a23abe6/lvm2-2.02.187-6.amzn2.5.src.rpm
```

### `rpm` package: `diffutils-3.3-5.amzn2.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url diffutils-3.3-5.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/3b94189bd4a0bbb334c887b5a7306f5cbe927e45ca9a9c1e68e6466570b7a4e1/diffutils-3.3-5.amzn2.src.rpm
```

### `rpm` package: `elfutils-default-yama-scope-0.176-2.amzn2.0.2.noarch`

Licenses (from `rpm --query`): GPLv2+ or LGPLv3+

Source:

```console
$ dnf --quiet download --source --url elfutils-default-yama-scope-0.176-2.amzn2.0.2.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/1c91483c986f8c6728684f387c271636212f24068e329c1b81b7502fdeeadddc/elfutils-0.176-2.amzn2.0.2.src.rpm
```

### `rpm` package: `elfutils-libelf-0.176-2.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPLv2+ or LGPLv3+

Source:

```console
$ dnf --quiet download --source --url elfutils-libelf-0.176-2.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/1c91483c986f8c6728684f387c271636212f24068e329c1b81b7502fdeeadddc/elfutils-0.176-2.amzn2.0.2.src.rpm
```

### `rpm` package: `elfutils-libs-0.176-2.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPLv2+ or LGPLv3+

Source:

```console
$ dnf --quiet download --source --url elfutils-libs-0.176-2.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/1c91483c986f8c6728684f387c271636212f24068e329c1b81b7502fdeeadddc/elfutils-0.176-2.amzn2.0.2.src.rpm
```

### `rpm` package: `expat-2.1.0-15.amzn2.0.3.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url expat-2.1.0-15.amzn2.0.3
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/f9f984ab3675d0250695e8a67360d02f8a0182b40281dd92bf16e8add1919080/expat-2.1.0-15.amzn2.0.3.src.rpm
```

### `rpm` package: `file-libs-5.11-36.amzn2.0.1.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url file-libs-5.11-36.amzn2.0.1
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/6826885873bb4ef8f4d7479ffbfbceb96807ae298e2f0a9a083022200ca7caab/file-5.11-36.amzn2.0.1.src.rpm
```

### `rpm` package: `filesystem-3.2-25.amzn2.0.4.x86_64`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url filesystem-3.2-25.amzn2.0.4
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/c1bdb520a838326c15c1c86b0a1314c9e44f7689de956010d7a8e4bfda7d34e4/filesystem-3.2-25.amzn2.0.4.src.rpm
```

### `rpm` package: `findutils-4.5.11-6.amzn2.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url findutils-4.5.11-6.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/8cb38ddd3353da1ca38e2748e4affeb61a422044bf26c05f93cd0e20d83b125d/findutils-4.5.11-6.amzn2.src.rpm
```

### `rpm` package: `fipscheck-1.4.1-6.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url fipscheck-1.4.1-6.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/d3d3a7ed94ccdfccdf7b2224bc0ce03a347ef1595c31ac863a164547f27d713f/fipscheck-1.4.1-6.amzn2.0.2.src.rpm
```

### `rpm` package: `fipscheck-lib-1.4.1-6.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url fipscheck-lib-1.4.1-6.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/d3d3a7ed94ccdfccdf7b2224bc0ce03a347ef1595c31ac863a164547f27d713f/fipscheck-1.4.1-6.amzn2.0.2.src.rpm
```

### `rpm` package: `gawk-4.0.2-4.amzn2.1.3.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GPL and LGPLv3+ and LGPL and BSD

Source:

```console
$ dnf --quiet download --source --url gawk-4.0.2-4.amzn2.1.3
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/bbc0c319663725c78b8dd3a8b04d0274e6ed7058b25b0f2117f26f42846677b3/gawk-4.0.2-4.amzn2.1.3.src.rpm
```

### `rpm` package: `gcc-7.3.1-17.amzn2.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD

Source:

```console
$ dnf --quiet download --source --url gcc-7.3.1-17.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/a2b874b1e83eb065848df3e26205c7e903eb46b4c4f40adf7a6a68a1af38698f/gcc-7.3.1-17.amzn2.src.rpm
```

### `rpm` package: `gcc-c++-7.3.1-17.amzn2.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD

Source:

```console
$ dnf --quiet download --source --url gcc-c++-7.3.1-17.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/a2b874b1e83eb065848df3e26205c7e903eb46b4c4f40adf7a6a68a1af38698f/gcc-7.3.1-17.amzn2.src.rpm
```

### `rpm` package: `gdbm-1.13-6.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url gdbm-1.13-6.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/e2866f1817e24bcd350768bf85c8bbddde135513ced29ce315df75f311cf77cf/gdbm-1.13-6.amzn2.0.2.src.rpm
```

### `rpm` package: `git-2.40.1-1.amzn2.0.3.x86_64`

Licenses (from `rpm --query`): BSD-3-Clause AND GPL-2.0-only AND GPL-2.0-or-later AND LGPL-2.1-or-later AND MIT

Source:

```console
$ dnf --quiet download --source --url git-2.40.1-1.amzn2.0.3
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/c0b305cbb5a36c0d517dc2b3dda6582afe9dd30dd77412345631f96119740f46/git-2.40.1-1.amzn2.0.3.src.rpm
```

### `rpm` package: `git-core-2.40.1-1.amzn2.0.3.x86_64`

Licenses (from `rpm --query`): BSD-3-Clause AND GPL-2.0-only AND GPL-2.0-or-later AND LGPL-2.1-or-later AND MIT

Source:

```console
$ dnf --quiet download --source --url git-core-2.40.1-1.amzn2.0.3
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/c0b305cbb5a36c0d517dc2b3dda6582afe9dd30dd77412345631f96119740f46/git-2.40.1-1.amzn2.0.3.src.rpm
```

### `rpm` package: `git-core-doc-2.40.1-1.amzn2.0.3.noarch`

Licenses (from `rpm --query`): BSD-3-Clause AND GPL-2.0-only AND GPL-2.0-or-later AND LGPL-2.1-or-later AND MIT

Source:

```console
$ dnf --quiet download --source --url git-core-doc-2.40.1-1.amzn2.0.3.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/c0b305cbb5a36c0d517dc2b3dda6582afe9dd30dd77412345631f96119740f46/git-2.40.1-1.amzn2.0.3.src.rpm
```

### `rpm` package: `glib2-2.56.1-9.amzn2.0.8.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url glib2-2.56.1-9.amzn2.0.8
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/ad63e8fcb326654adf7b006023caaa4c68cdcb9028307b1583e96e87e7c5232b/glib2-2.56.1-9.amzn2.0.8.src.rpm
```

### `rpm` package: `glibc-2.26-64.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and LGPLv2+ with exceptions and GPLv2+

Source:

```console
$ dnf --quiet download --source --url glibc-2.26-64.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/80957882f8844aec423e96191b92eaee1bf079ff1d07f2c2dd3bb9a859b21199/glibc-2.26-64.amzn2.0.2.src.rpm
```

### `rpm` package: `glibc-common-2.26-64.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and LGPLv2+ with exceptions and GPLv2+

Source:

```console
$ dnf --quiet download --source --url glibc-common-2.26-64.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/80957882f8844aec423e96191b92eaee1bf079ff1d07f2c2dd3bb9a859b21199/glibc-2.26-64.amzn2.0.2.src.rpm
```

### `rpm` package: `glibc-devel-2.26-64.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and LGPLv2+ with exceptions and GPLv2+

Source:

```console
$ dnf --quiet download --source --url glibc-devel-2.26-64.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/80957882f8844aec423e96191b92eaee1bf079ff1d07f2c2dd3bb9a859b21199/glibc-2.26-64.amzn2.0.2.src.rpm
```

### `rpm` package: `glibc-headers-2.26-64.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and LGPLv2+ with exceptions and GPLv2+

Source:

```console
$ dnf --quiet download --source --url glibc-headers-2.26-64.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/80957882f8844aec423e96191b92eaee1bf079ff1d07f2c2dd3bb9a859b21199/glibc-2.26-64.amzn2.0.2.src.rpm
```

### `rpm` package: `glibc-langpack-en-2.26-64.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and LGPLv2+ with exceptions and GPLv2+

Source:

```console
$ dnf --quiet download --source --url glibc-langpack-en-2.26-64.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/80957882f8844aec423e96191b92eaee1bf079ff1d07f2c2dd3bb9a859b21199/glibc-2.26-64.amzn2.0.2.src.rpm
```

### `rpm` package: `glibc-minimal-langpack-2.26-64.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and LGPLv2+ with exceptions and GPLv2+

Source:

```console
$ dnf --quiet download --source --url glibc-minimal-langpack-2.26-64.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/80957882f8844aec423e96191b92eaee1bf079ff1d07f2c2dd3bb9a859b21199/glibc-2.26-64.amzn2.0.2.src.rpm
```

### `rpm` package: `glibc-static-2.26-64.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and LGPLv2+ with exceptions and GPLv2+

Source:

```console
$ dnf --quiet download --source --url glibc-static-2.26-64.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/80957882f8844aec423e96191b92eaee1bf079ff1d07f2c2dd3bb9a859b21199/glibc-2.26-64.amzn2.0.2.src.rpm
```

### `rpm` package: `gmp-6.0.0-15.amzn2.0.3.x86_64`

Licenses (from `rpm --query`): LGPLv3+ or GPLv2+

Source:

```console
$ dnf --quiet download --source --url gmp-6.0.0-15.amzn2.0.3
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/e3c168f21582900e205e5ff29724e4ba70b5b375a7731825f32d0e9e2bb29026/gmp-6.0.0-15.amzn2.0.3.src.rpm
```

### `rpm` package: `gnupg2-2.0.22-5.amzn2.0.5.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url gnupg2-2.0.22-5.amzn2.0.5
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/189e1bdc950a8e13918173d73835981842c90ee3b3cef07c116152a00b8b8a59/gnupg2-2.0.22-5.amzn2.0.5.src.rpm
```

### `rpm` package: `gpg-pubkey-c87f5b1a-593863f8`

Licenses (from `rpm --query`): pubkey

**WARNING:** unable to find source (`dnf download` failed or returned no results)!

### `rpm` package: `gpgme-1.3.2-5.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url gpgme-1.3.2-5.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/81074517b77553b2abbdc13fb0637c599a4c32f25ff85e6e00a9761fbd961d9f/gpgme-1.3.2-5.amzn2.0.2.src.rpm
```

### `rpm` package: `grep-2.20-3.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url grep-2.20-3.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/6a1fd83c54bc7f4701e6b979d8f5dcc9950e2b5116cbb1c27057f412bed54390/grep-2.20-3.amzn2.0.2.src.rpm
```

### `rpm` package: `groff-base-1.22.2-8.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GFDL and BSD and MIT

Source:

```console
$ dnf --quiet download --source --url groff-base-1.22.2-8.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/d9b7c639e499dcfa1d6d3445d365bc1a51d7085ec185d0bd35e37e657e5ddad3/groff-1.22.2-8.amzn2.0.2.src.rpm
```

### `rpm` package: `gzip-1.5-10.amzn2.0.1.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GFDL

Source:

```console
$ dnf --quiet download --source --url gzip-1.5-10.amzn2.0.1
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/073c2dbe9b6abb1bfeb13882372463c92385805502ccf659e093c5d4b2c3d62e/gzip-1.5-10.amzn2.0.1.src.rpm
```

### `rpm` package: `info-5.1-5.amzn2.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url info-5.1-5.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/968c079ef8a8a2efee76ff59cd99e06dd242b8813960171d0f5c23f4a6eb0bb2/texinfo-5.1-5.amzn2.src.rpm
```

### `rpm` package: `kernel-headers-4.14.352-268.569.amzn2.x86_64`

Licenses (from `rpm --query`): GPLv2 and Redistributable, no modification permitted

Source:

```console
$ dnf --quiet download --source --url kernel-headers-4.14.352-268.569.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/c0b0f25021b3d1b7c6a51e07b0320c45dd970454628b816be26aa4b1498f6a96/kernel-4.14.352-268.569.amzn2.src.rpm
```

### `rpm` package: `keyutils-libs-1.5.8-3.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPLv2+ and LGPLv2+

Source:

```console
$ dnf --quiet download --source --url keyutils-libs-1.5.8-3.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/1579dc52bd90d64e68d663da4dfa4462afa9df1cfbef30d47b64add0dd12210e/keyutils-1.5.8-3.amzn2.0.2.src.rpm
```

### `rpm` package: `keyutils-libs-devel-1.5.8-3.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPLv2+ and LGPLv2+

Source:

```console
$ dnf --quiet download --source --url keyutils-libs-devel-1.5.8-3.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/1579dc52bd90d64e68d663da4dfa4462afa9df1cfbef30d47b64add0dd12210e/keyutils-1.5.8-3.amzn2.0.2.src.rpm
```

### `rpm` package: `kmod-25-3.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url kmod-25-3.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/690f912ad75fa60f2abd7ca91f023009aee784746cce582f74578c80d73059c7/kmod-25-3.amzn2.0.2.src.rpm
```

### `rpm` package: `kmod-libs-25-3.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url kmod-libs-25-3.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/690f912ad75fa60f2abd7ca91f023009aee784746cce582f74578c80d73059c7/kmod-25-3.amzn2.0.2.src.rpm
```

### `rpm` package: `krb5-devel-1.15.1-55.amzn2.2.8.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url krb5-devel-1.15.1-55.amzn2.2.8
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/1b2848f3a8c5ec186828477807bbd118989420cd7329f560e749c340c26350e0/krb5-1.15.1-55.amzn2.2.8.src.rpm
```

### `rpm` package: `krb5-libs-1.15.1-55.amzn2.2.8.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url krb5-libs-1.15.1-55.amzn2.2.8
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/1b2848f3a8c5ec186828477807bbd118989420cd7329f560e749c340c26350e0/krb5-1.15.1-55.amzn2.2.8.src.rpm
```

### `rpm` package: `less-458-9.amzn2.0.4.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url less-458-9.amzn2.0.4
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/12330ef8f826049fa7a30296fda4dbbeeab0bfc247d7a484d9285cd55bd74017/less-458-9.amzn2.0.4.src.rpm
```

### `rpm` package: `libacl-2.2.51-14.amzn2.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libacl-2.2.51-14.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/d21969f8fbccf539fa601961f20352b7c95b4cf593c9fa5dad2ac4896c7ca6c9/acl-2.2.51-14.amzn2.src.rpm
```

### `rpm` package: `libassuan-2.1.0-3.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and GPLv3+

Source:

```console
$ dnf --quiet download --source --url libassuan-2.1.0-3.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/27b0138d028a9ba30c43384ce6b2d1314d0ac3a6284c6793655c5589893d47ee/libassuan-2.1.0-3.amzn2.0.2.src.rpm
```

### `rpm` package: `libatomic-7.3.1-17.amzn2.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD

Source:

```console
$ dnf --quiet download --source --url libatomic-7.3.1-17.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/a2b874b1e83eb065848df3e26205c7e903eb46b4c4f40adf7a6a68a1af38698f/gcc-7.3.1-17.amzn2.src.rpm
```

### `rpm` package: `libattr-2.4.46-12.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libattr-2.4.46-12.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/370b7813e0e86fadc241a9fb590451372429f0fe3ab17d62a4378b49089f8158/attr-2.4.46-12.amzn2.0.2.src.rpm
```

### `rpm` package: `libblkid-2.30.2-2.amzn2.0.11.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libblkid-2.30.2-2.amzn2.0.11
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/c3d8b01e2190e686623eb8551a13a4a33cc08e086036e951fe5ed1b99c7b2b8e/util-linux-2.30.2-2.amzn2.0.11.src.rpm
```

### `rpm` package: `libcap-2.54-1.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): BSD or GPLv2

Source:

```console
$ dnf --quiet download --source --url libcap-2.54-1.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/ab5e39e42f4b1dd512a49eb9ca2c71cebf3647d3f63d147f5b20e7229596ba54/libcap-2.54-1.amzn2.0.2.src.rpm
```

### `rpm` package: `libcap-ng-0.7.5-4.amzn2.0.4.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libcap-ng-0.7.5-4.amzn2.0.4
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/b9685dfd18da9e00613cda24f60b48a09e3b4695dd6131e5e4ce4de70b90e95c/libcap-ng-0.7.5-4.amzn2.0.4.src.rpm
```

### `rpm` package: `libcilkrts-7.3.1-17.amzn2.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD

Source:

```console
$ dnf --quiet download --source --url libcilkrts-7.3.1-17.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/a2b874b1e83eb065848df3e26205c7e903eb46b4c4f40adf7a6a68a1af38698f/gcc-7.3.1-17.amzn2.src.rpm
```

### `rpm` package: `libcom_err-1.42.9-19.amzn2.0.1.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libcom_err-1.42.9-19.amzn2.0.1
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/cdaf4c4c0124e55017cfd1c72a24450c9b0652ba3dab8a3dc9b49c120d634f76/e2fsprogs-1.42.9-19.amzn2.0.1.src.rpm
```

### `rpm` package: `libcom_err-devel-1.42.9-19.amzn2.0.1.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libcom_err-devel-1.42.9-19.amzn2.0.1
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/cdaf4c4c0124e55017cfd1c72a24450c9b0652ba3dab8a3dc9b49c120d634f76/e2fsprogs-1.42.9-19.amzn2.0.1.src.rpm
```

### `rpm` package: `libcrypt-2.26-64.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and LGPLv2+ with exceptions and GPLv2+

Source:

```console
$ dnf --quiet download --source --url libcrypt-2.26-64.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/80957882f8844aec423e96191b92eaee1bf079ff1d07f2c2dd3bb9a859b21199/glibc-2.26-64.amzn2.0.2.src.rpm
```

### `rpm` package: `libcurl-8.3.0-1.amzn2.0.7.x86_64`

Licenses (from `rpm --query`): curl

Source:

```console
$ dnf --quiet download --source --url libcurl-8.3.0-1.amzn2.0.7
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/6960e828bd1d1b84705b13d60d95d6fcfa38f4a169c1b8463981c6169c49699d/curl-8.3.0-1.amzn2.0.7.src.rpm
```

### `rpm` package: `libcurl-devel-8.3.0-1.amzn2.0.7.x86_64`

Licenses (from `rpm --query`): curl

Source:

```console
$ dnf --quiet download --source --url libcurl-devel-8.3.0-1.amzn2.0.7
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/6960e828bd1d1b84705b13d60d95d6fcfa38f4a169c1b8463981c6169c49699d/curl-8.3.0-1.amzn2.0.7.src.rpm
```

### `rpm` package: `libdb-5.3.21-24.amzn2.0.5.x86_64`

Licenses (from `rpm --query`): BSD and LGPLv2 and Sleepycat

Source:

```console
$ dnf --quiet download --source --url libdb-5.3.21-24.amzn2.0.5
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/7cda0e45f738206ef4164867431a01a3ef32975ae8d5fdafc2dccb761bbf3b82/libdb-5.3.21-24.amzn2.0.5.src.rpm
```

### `rpm` package: `libdb-utils-5.3.21-24.amzn2.0.5.x86_64`

Licenses (from `rpm --query`): BSD and LGPLv2 and Sleepycat

Source:

```console
$ dnf --quiet download --source --url libdb-utils-5.3.21-24.amzn2.0.5
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/7cda0e45f738206ef4164867431a01a3ef32975ae8d5fdafc2dccb761bbf3b82/libdb-5.3.21-24.amzn2.0.5.src.rpm
```

### `rpm` package: `libedit-3.0-12.20121213cvs.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url libedit-3.0-12.20121213cvs.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/c190ef5d80c1a487cb6ec096b5ab37200c77f5ef70708d3c7b7f25494c8b89ab/libedit-3.0-12.20121213cvs.amzn2.0.2.src.rpm
```

### `rpm` package: `libfdisk-2.30.2-2.amzn2.0.11.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libfdisk-2.30.2-2.amzn2.0.11
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/c3d8b01e2190e686623eb8551a13a4a33cc08e086036e951fe5ed1b99c7b2b8e/util-linux-2.30.2-2.amzn2.0.11.src.rpm
```

### `rpm` package: `libffi-3.0.13-18.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): MIT and Public Domain

Source:

```console
$ dnf --quiet download --source --url libffi-3.0.13-18.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/6d795273d9b8725efa8069ecb46398043d7100cfd4979b9c31489e35504e31f7/libffi-3.0.13-18.amzn2.0.2.src.rpm
```

### `rpm` package: `libgcc-7.3.1-17.amzn2.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD

Source:

```console
$ dnf --quiet download --source --url libgcc-7.3.1-17.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/a2b874b1e83eb065848df3e26205c7e903eb46b4c4f40adf7a6a68a1af38698f/gcc-7.3.1-17.amzn2.src.rpm
```

### `rpm` package: `libgcrypt-1.5.3-14.amzn2.0.3.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libgcrypt-1.5.3-14.amzn2.0.3
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/86f0a2bd76acd4f1460e1e52a2d34502480808da4e76a2a1bf835dba805b5d21/libgcrypt-1.5.3-14.amzn2.0.3.src.rpm
```

### `rpm` package: `libgomp-7.3.1-17.amzn2.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD

Source:

```console
$ dnf --quiet download --source --url libgomp-7.3.1-17.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/a2b874b1e83eb065848df3e26205c7e903eb46b4c4f40adf7a6a68a1af38698f/gcc-7.3.1-17.amzn2.src.rpm
```

### `rpm` package: `libgpg-error-1.12-3.amzn2.0.3.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libgpg-error-1.12-3.amzn2.0.3
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/997de9d51396f20df5b00b7f41a4bc110b88c5243225ff5941026174850a6e6e/libgpg-error-1.12-3.amzn2.0.3.src.rpm
```

### `rpm` package: `libicu-50.2-4.amzn2.0.1.x86_64`

Licenses (from `rpm --query`): MIT and UCD and Public Domain

Source:

```console
$ dnf --quiet download --source --url libicu-50.2-4.amzn2.0.1
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/1d44b747f5690a4e2bb683572a3858ee2e10e1f9080912cec13151c807d188a2/icu-50.2-4.amzn2.0.1.src.rpm
```

### `rpm` package: `libidn2-2.3.0-1.amzn2.0.3.x86_64`

Licenses (from `rpm --query`): (GPLv2+ or LGPLv3+) and GPLv3+

Source:

```console
$ dnf --quiet download --source --url libidn2-2.3.0-1.amzn2.0.3
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/779c0a9f244a8c91e46933aab7ba4a6215a2c33ec8c856de02dbf17d02b6337b/libidn2-2.3.0-1.amzn2.0.3.src.rpm
```

### `rpm` package: `libitm-7.3.1-17.amzn2.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD

Source:

```console
$ dnf --quiet download --source --url libitm-7.3.1-17.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/a2b874b1e83eb065848df3e26205c7e903eb46b4c4f40adf7a6a68a1af38698f/gcc-7.3.1-17.amzn2.src.rpm
```

### `rpm` package: `libkadm5-1.15.1-55.amzn2.2.8.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libkadm5-1.15.1-55.amzn2.2.8
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/1b2848f3a8c5ec186828477807bbd118989420cd7329f560e749c340c26350e0/krb5-1.15.1-55.amzn2.2.8.src.rpm
```

### `rpm` package: `libmetalink-0.1.3-13.amzn2.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libmetalink-0.1.3-13.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/af0aec2e615d0ff03b96fd674c80f28b00f2d198951b2e418ec80956b87aa389/libmetalink-0.1.3-13.amzn2.src.rpm
```

### `rpm` package: `libmount-2.30.2-2.amzn2.0.11.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libmount-2.30.2-2.amzn2.0.11
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/c3d8b01e2190e686623eb8551a13a4a33cc08e086036e951fe5ed1b99c7b2b8e/util-linux-2.30.2-2.amzn2.0.11.src.rpm
```

### `rpm` package: `libmpc-1.0.1-3.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): LGPLv3+ and GFDL

Source:

```console
$ dnf --quiet download --source --url libmpc-1.0.1-3.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/4f356896e09a493e3f54698ff6bfc918674ec0b5e07b6c81f3fb76acbcc72229/libmpc-1.0.1-3.amzn2.0.2.src.rpm
```

### `rpm` package: `libmpx-7.3.1-17.amzn2.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD

Source:

```console
$ dnf --quiet download --source --url libmpx-7.3.1-17.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/a2b874b1e83eb065848df3e26205c7e903eb46b4c4f40adf7a6a68a1af38698f/gcc-7.3.1-17.amzn2.src.rpm
```

### `rpm` package: `libnghttp2-1.41.0-1.amzn2.0.5.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libnghttp2-1.41.0-1.amzn2.0.5
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/8da0fd7d90c15a804a1e65d334a29814cd39273a449891f46ad90771e6e35261/nghttp2-1.41.0-1.amzn2.0.5.src.rpm
```

### `rpm` package: `libpsl-0.21.5-1.amzn2.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libpsl-0.21.5-1.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/be96ca923e9feef0fec59a6ef17775df424f573136544a9de3ebd4a7ba263c17/libpsl-0.21.5-1.amzn2.src.rpm
```

### `rpm` package: `libpwquality-1.2.3-5.amzn2.x86_64`

Licenses (from `rpm --query`): BSD or GPLv2+

Source:

```console
$ dnf --quiet download --source --url libpwquality-1.2.3-5.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/95fb45d0f90b6fc30168c24a1132bb19745b85d60d02f51ecd288a0ed5802ee3/libpwquality-1.2.3-5.amzn2.src.rpm
```

### `rpm` package: `libquadmath-7.3.1-17.amzn2.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD

Source:

```console
$ dnf --quiet download --source --url libquadmath-7.3.1-17.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/a2b874b1e83eb065848df3e26205c7e903eb46b4c4f40adf7a6a68a1af38698f/gcc-7.3.1-17.amzn2.src.rpm
```

### `rpm` package: `libsanitizer-7.3.1-17.amzn2.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD

Source:

```console
$ dnf --quiet download --source --url libsanitizer-7.3.1-17.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/a2b874b1e83eb065848df3e26205c7e903eb46b4c4f40adf7a6a68a1af38698f/gcc-7.3.1-17.amzn2.src.rpm
```

### `rpm` package: `libselinux-2.5-12.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url libselinux-2.5-12.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/0be2744b0f89765b31cecb119ca520449eb8cf48cd7355824f7ca4e0873deec3/libselinux-2.5-12.amzn2.0.2.src.rpm
```

### `rpm` package: `libselinux-devel-2.5-12.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url libselinux-devel-2.5-12.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/0be2744b0f89765b31cecb119ca520449eb8cf48cd7355824f7ca4e0873deec3/libselinux-2.5-12.amzn2.0.2.src.rpm
```

### `rpm` package: `libsemanage-2.5-11.amzn2.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libsemanage-2.5-11.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/eb5fb285756eced1c16757805bfe608a70a745fe4e3c61cd1fc230f2c4786ae8/libsemanage-2.5-11.amzn2.src.rpm
```

### `rpm` package: `libsepol-2.5-10.amzn2.0.1.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libsepol-2.5-10.amzn2.0.1
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/2b2a8764b4294026c35f8247282865f2631c8ec45d35349bb2bfc1017a97b958/libsepol-2.5-10.amzn2.0.1.src.rpm
```

### `rpm` package: `libsepol-devel-2.5-10.amzn2.0.1.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libsepol-devel-2.5-10.amzn2.0.1
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/2b2a8764b4294026c35f8247282865f2631c8ec45d35349bb2bfc1017a97b958/libsepol-2.5-10.amzn2.0.1.src.rpm
```

### `rpm` package: `libsmartcols-2.30.2-2.amzn2.0.11.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libsmartcols-2.30.2-2.amzn2.0.11
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/c3d8b01e2190e686623eb8551a13a4a33cc08e086036e951fe5ed1b99c7b2b8e/util-linux-2.30.2-2.amzn2.0.11.src.rpm
```

### `rpm` package: `libssh2-1.4.3-12.amzn2.2.6.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url libssh2-1.4.3-12.amzn2.2.6
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/d9a9fc99ac24238ed884d06fcfcc22ff7b2403783bf4bc31cc92108135e6899e/libssh2-1.4.3-12.amzn2.2.6.src.rpm
```

### `rpm` package: `libstdc++-7.3.1-17.amzn2.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD

Source:

```console
$ dnf --quiet download --source --url libstdc++-7.3.1-17.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/a2b874b1e83eb065848df3e26205c7e903eb46b4c4f40adf7a6a68a1af38698f/gcc-7.3.1-17.amzn2.src.rpm
```

### `rpm` package: `libtasn1-4.10-1.amzn2.0.6.x86_64`

Licenses (from `rpm --query`): GPLv3+ and LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libtasn1-4.10-1.amzn2.0.6
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/8c467da4eca42a4eea65011bf811e97d898b4230c0bdf70ea982d6d5f41c1491/libtasn1-4.10-1.amzn2.0.6.src.rpm
```

### `rpm` package: `libunistring-0.9.3-9.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): LGPLv3+

Source:

```console
$ dnf --quiet download --source --url libunistring-0.9.3-9.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/a679646faec5cf08ced31c6b0eb872e88e1267b76b4d3a43c1e553d4446732dd/libunistring-0.9.3-9.amzn2.0.2.src.rpm
```

### `rpm` package: `libutempter-1.1.6-4.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libutempter-1.1.6-4.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/ad96256471b3ac8fdbba612b8ee7393d1e754e7b5fa7c2340b0aa0690554161f/libutempter-1.1.6-4.amzn2.0.2.src.rpm
```

### `rpm` package: `libuuid-2.30.2-2.amzn2.0.11.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url libuuid-2.30.2-2.amzn2.0.11
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/c3d8b01e2190e686623eb8551a13a4a33cc08e086036e951fe5ed1b99c7b2b8e/util-linux-2.30.2-2.amzn2.0.11.src.rpm
```

### `rpm` package: `libverto-0.2.5-4.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libverto-0.2.5-4.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/23eb8faf40e93c9ecbfeccc868d2e42b65bde82f92e1af0b0e9e17c387f1b049/libverto-0.2.5-4.amzn2.0.2.src.rpm
```

### `rpm` package: `libverto-devel-0.2.5-4.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libverto-devel-0.2.5-4.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/23eb8faf40e93c9ecbfeccc868d2e42b65bde82f92e1af0b0e9e17c387f1b049/libverto-0.2.5-4.amzn2.0.2.src.rpm
```

### `rpm` package: `libxml2-2.9.1-6.amzn2.5.13.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libxml2-2.9.1-6.amzn2.5.13
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/66be4d50d3b853dc0d36ac1222f7db448f3bf2e19a27604054c3f82c2ae6b7a8/libxml2-2.9.1-6.amzn2.5.13.src.rpm
```

### `rpm` package: `libxml2-devel-2.9.1-6.amzn2.5.13.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libxml2-devel-2.9.1-6.amzn2.5.13
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/66be4d50d3b853dc0d36ac1222f7db448f3bf2e19a27604054c3f82c2ae6b7a8/libxml2-2.9.1-6.amzn2.5.13.src.rpm
```

### `rpm` package: `lua-5.1.4-15.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url lua-5.1.4-15.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/4f245b1212afa57d45d2ef83997a92d3346a2aa315de8d54c4f93aceb71c2c97/lua-5.1.4-15.amzn2.0.2.src.rpm
```

### `rpm` package: `lz4-1.7.5-2.amzn2.0.1.x86_64`

Licenses (from `rpm --query`): GPLv2+ and BSD

Source:

```console
$ dnf --quiet download --source --url lz4-1.7.5-2.amzn2.0.1
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/cc7ff37476502126faa384dc7700905c0721f94e9ef7dd606fc5f405a8b1ff7c/lz4-1.7.5-2.amzn2.0.1.src.rpm
```

### `rpm` package: `mpfr-3.1.1-4.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): LGPLv3+ and GPLv3+ and GFDL

Source:

```console
$ dnf --quiet download --source --url mpfr-3.1.1-4.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/2557af4f1b194aecfe2cbe896608848a24afffc5526f326d518bd29c15c507b2/mpfr-3.1.1-4.amzn2.0.2.src.rpm
```

### `rpm` package: `ncurses-6.0-8.20170212.amzn2.1.8.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url ncurses-6.0-8.20170212.amzn2.1.8
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/dd9fa9aac19a7717f82d1cfb5a53b11e441294d8081c56b4e9aab3102590e691/ncurses-6.0-8.20170212.amzn2.1.8.src.rpm
```

### `rpm` package: `ncurses-base-6.0-8.20170212.amzn2.1.8.noarch`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url ncurses-base-6.0-8.20170212.amzn2.1.8.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/dd9fa9aac19a7717f82d1cfb5a53b11e441294d8081c56b4e9aab3102590e691/ncurses-6.0-8.20170212.amzn2.1.8.src.rpm
```

### `rpm` package: `ncurses-libs-6.0-8.20170212.amzn2.1.8.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url ncurses-libs-6.0-8.20170212.amzn2.1.8
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/dd9fa9aac19a7717f82d1cfb5a53b11e441294d8081c56b4e9aab3102590e691/ncurses-6.0-8.20170212.amzn2.1.8.src.rpm
```

### `rpm` package: `nspr-4.35.0-1.amzn2.x86_64`

Licenses (from `rpm --query`): MPLv2.0

Source:

```console
$ dnf --quiet download --source --url nspr-4.35.0-1.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/ff6f819d94da64b15bbf33ec914529f7010def8329f177e8534293d072901b92/nspr-4.35.0-1.amzn2.src.rpm
```

### `rpm` package: `nss-3.90.0-2.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): MPLv2.0

Source:

```console
$ dnf --quiet download --source --url nss-3.90.0-2.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/c0937ce110ab46441ff9c8c24084c5f69b9f52904ddef90de0daaf0827e2ea65/nss-3.90.0-2.amzn2.0.2.src.rpm
```

### `rpm` package: `nss-pem-1.0.3-5.amzn2.x86_64`

Licenses (from `rpm --query`): MPLv1.1

Source:

```console
$ dnf --quiet download --source --url nss-pem-1.0.3-5.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/704279710518c94532cf67062b10877693d651e1b652fb60ed1ce1fa0cb49d7a/nss-pem-1.0.3-5.amzn2.src.rpm
```

### `rpm` package: `nss-softokn-3.90.0-6.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): MPLv2.0

Source:

```console
$ dnf --quiet download --source --url nss-softokn-3.90.0-6.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/6b744a951b86205fbff055c8d9e2ae9cc8c0a90b9a1e733d555f7b38c5cb1ec0/nss-softokn-3.90.0-6.amzn2.0.2.src.rpm
```

### `rpm` package: `nss-softokn-freebl-3.90.0-6.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): MPLv2.0

Source:

```console
$ dnf --quiet download --source --url nss-softokn-freebl-3.90.0-6.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/6b744a951b86205fbff055c8d9e2ae9cc8c0a90b9a1e733d555f7b38c5cb1ec0/nss-softokn-3.90.0-6.amzn2.0.2.src.rpm
```

### `rpm` package: `nss-sysinit-3.90.0-2.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): MPLv2.0

Source:

```console
$ dnf --quiet download --source --url nss-sysinit-3.90.0-2.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/c0937ce110ab46441ff9c8c24084c5f69b9f52904ddef90de0daaf0827e2ea65/nss-3.90.0-2.amzn2.0.2.src.rpm
```

### `rpm` package: `nss-tools-3.90.0-2.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): MPLv2.0

Source:

```console
$ dnf --quiet download --source --url nss-tools-3.90.0-2.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/c0937ce110ab46441ff9c8c24084c5f69b9f52904ddef90de0daaf0827e2ea65/nss-3.90.0-2.amzn2.0.2.src.rpm
```

### `rpm` package: `nss-util-3.90.0-1.amzn2.x86_64`

Licenses (from `rpm --query`): MPLv2.0

Source:

```console
$ dnf --quiet download --source --url nss-util-3.90.0-1.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/68b37d43f23fa6b6234f0fe2d106b09fbd801696d98d7aa10982e0cb621419a8/nss-util-3.90.0-1.amzn2.src.rpm
```

### `rpm` package: `openldap-2.4.44-25.amzn2.0.7.x86_64`

Licenses (from `rpm --query`): OpenLDAP

Source:

```console
$ dnf --quiet download --source --url openldap-2.4.44-25.amzn2.0.7
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/db7da8ae89a175ef6835a375dec2b69b3eaecc676cb58b8dd9c1f8e769fb0fc2/openldap-2.4.44-25.amzn2.0.7.src.rpm
```

### `rpm` package: `openssh-7.4p1-22.amzn2.0.8.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url openssh-7.4p1-22.amzn2.0.8
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/f472552ddf1b53fac41e9119e5da2fcb74388a6911b353a13f1639fa6c5450b5/openssh-7.4p1-22.amzn2.0.8.src.rpm
```

### `rpm` package: `openssh-clients-7.4p1-22.amzn2.0.8.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url openssh-clients-7.4p1-22.amzn2.0.8
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/f472552ddf1b53fac41e9119e5da2fcb74388a6911b353a13f1639fa6c5450b5/openssh-7.4p1-22.amzn2.0.8.src.rpm
```

### `rpm` package: `openssl-devel-1.0.2k-24.amzn2.0.13.x86_64`

Licenses (from `rpm --query`): OpenSSL

Source:

```console
$ dnf --quiet download --source --url openssl-devel-1.0.2k-24.amzn2.0.13
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/85fb30af6480d6f939251b037e055e34e05a3d4759c2e118e576cfc23308c0cc/openssl-1.0.2k-24.amzn2.0.13.src.rpm
```

### `rpm` package: `openssl-libs-1.0.2k-24.amzn2.0.13.x86_64`

Licenses (from `rpm --query`): OpenSSL

Source:

```console
$ dnf --quiet download --source --url openssl-libs-1.0.2k-24.amzn2.0.13
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/85fb30af6480d6f939251b037e055e34e05a3d4759c2e118e576cfc23308c0cc/openssl-1.0.2k-24.amzn2.0.13.src.rpm
```

### `rpm` package: `p11-kit-0.23.22-1.amzn2.0.1.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url p11-kit-0.23.22-1.amzn2.0.1
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/79c2f1cc336aa17382372c2c5577054870d1d123e5ce606f33bc2443e9c91347/p11-kit-0.23.22-1.amzn2.0.1.src.rpm
```

### `rpm` package: `p11-kit-trust-0.23.22-1.amzn2.0.1.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url p11-kit-trust-0.23.22-1.amzn2.0.1
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/79c2f1cc336aa17382372c2c5577054870d1d123e5ce606f33bc2443e9c91347/p11-kit-0.23.22-1.amzn2.0.1.src.rpm
```

### `rpm` package: `pam-1.1.8-23.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): BSD and GPLv2+

Source:

```console
$ dnf --quiet download --source --url pam-1.1.8-23.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/5e5c7ebfb8401c77cbd43f72e15dc1535d84d151108447934025bad6e5398355/pam-1.1.8-23.amzn2.0.2.src.rpm
```

### `rpm` package: `pcre-8.32-17.amzn2.0.3.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url pcre-8.32-17.amzn2.0.3
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/b2470976412c846cbcbb44775d2a4ec2e44564585fd3b25c125432f0befabc30/pcre-8.32-17.amzn2.0.3.src.rpm
```

### `rpm` package: `pcre-devel-8.32-17.amzn2.0.3.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url pcre-devel-8.32-17.amzn2.0.3
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/b2470976412c846cbcbb44775d2a4ec2e44564585fd3b25c125432f0befabc30/pcre-8.32-17.amzn2.0.3.src.rpm
```

### `rpm` package: `pcre2-10.23-11.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url pcre2-10.23-11.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/e6e4f19b4c91472d7ef32c3ea750b52c0bb3ec1da900bb1ba8cb05c28a4ac7cb/pcre2-10.23-11.amzn2.0.2.src.rpm
```

### `rpm` package: `perl-5.16.3-299.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): (GPL+ or Artistic) and (GPLv2+ or Artistic) and Copyright Only and MIT and Public Domain and UCD

Source:

```console
$ dnf --quiet download --source --url perl-5.16.3-299.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/a5f079e57ed58ef2c70424f8d5999dbef4ce79f60692443c42fd013d131c6f71/perl-5.16.3-299.amzn2.0.2.src.rpm
```

### `rpm` package: `perl-Carp-1.26-244.amzn2.noarch`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-Carp-1.26-244.amzn2.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/0297546087e8dc525e67d43b3e2c8c0f84aff7b9c100fa574d3e1d6cc84a91f1/perl-Carp-1.26-244.amzn2.src.rpm
```

### `rpm` package: `perl-Encode-2.51-7.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-Encode-2.51-7.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/7f3163cab46d307a4915c73c1aa3e02129fa1ffcaaefba46c0bcbaee634b5fa4/perl-Encode-2.51-7.amzn2.0.2.src.rpm
```

### `rpm` package: `perl-Error-0.17020-2.amzn2.noarch`

Licenses (from `rpm --query`): (GPL+ or Artistic) and MIT

Source:

```console
$ dnf --quiet download --source --url perl-Error-0.17020-2.amzn2.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/266699d7c03402365b35479b44d7ac11efc0cca6a6add6bdf841f5347d160b11/perl-Error-0.17020-2.amzn2.src.rpm
```

### `rpm` package: `perl-Exporter-5.68-3.amzn2.noarch`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-Exporter-5.68-3.amzn2.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/b0a090790a45d44be40291a13244bfd0536ebcabbd935a792c8076cab6be8d21/perl-Exporter-5.68-3.amzn2.src.rpm
```

### `rpm` package: `perl-File-Path-2.09-2.amzn2.noarch`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-File-Path-2.09-2.amzn2.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/44598eb7d03a0812077a8c1e9df2086027cf65720d9778028e028ea8dee3e409/perl-File-Path-2.09-2.amzn2.src.rpm
```

### `rpm` package: `perl-File-Temp-0.23.01-3.amzn2.noarch`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-File-Temp-0.23.01-3.amzn2.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/da0b5ae04e90a6bf319028ce2931cdb50a626b1931b38b4305a6a41863e7fc94/perl-File-Temp-0.23.01-3.amzn2.src.rpm
```

### `rpm` package: `perl-Filter-1.49-3.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-Filter-1.49-3.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/28dcdff6fd786a3e7c8ef73981282dc6ec7de0d0e167c8f326ce51dc46f3485a/perl-Filter-1.49-3.amzn2.0.2.src.rpm
```

### `rpm` package: `perl-Getopt-Long-2.40-3.amzn2.noarch`

Licenses (from `rpm --query`): GPLv2+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-Getopt-Long-2.40-3.amzn2.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/6ec100098b7293d10a4d3bd1ee9eda2b86980f35dc01bd021c56e403ed5b3be6/perl-Getopt-Long-2.40-3.amzn2.src.rpm
```

### `rpm` package: `perl-Git-2.40.1-1.amzn2.0.3.noarch`

Licenses (from `rpm --query`): BSD-3-Clause AND GPL-2.0-only AND GPL-2.0-or-later AND LGPL-2.1-or-later AND MIT

Source:

```console
$ dnf --quiet download --source --url perl-Git-2.40.1-1.amzn2.0.3.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/c0b305cbb5a36c0d517dc2b3dda6582afe9dd30dd77412345631f96119740f46/git-2.40.1-1.amzn2.0.3.src.rpm
```

### `rpm` package: `perl-HTTP-Tiny-0.033-3.amzn2.0.1.noarch`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-HTTP-Tiny-0.033-3.amzn2.0.1.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/1acddd45a59ed66f4f5c662f8e0e48924ba83117c55f489793f8f718b00492e3/perl-HTTP-Tiny-0.033-3.amzn2.0.1.src.rpm
```

### `rpm` package: `perl-PathTools-3.40-5.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): (GPL+ or Artistic) and BSD

Source:

```console
$ dnf --quiet download --source --url perl-PathTools-3.40-5.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/aa02cb6a837f27da8549b69b4b66a09e6f2f1c7ebcf7678a7d372983427b4987/perl-PathTools-3.40-5.amzn2.0.2.src.rpm
```

### `rpm` package: `perl-Pod-Escapes-1.04-299.amzn2.0.2.noarch`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-Pod-Escapes-1.04-299.amzn2.0.2.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/a5f079e57ed58ef2c70424f8d5999dbef4ce79f60692443c42fd013d131c6f71/perl-5.16.3-299.amzn2.0.2.src.rpm
```

### `rpm` package: `perl-Pod-Perldoc-3.20-4.amzn2.0.1.noarch`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-Pod-Perldoc-3.20-4.amzn2.0.1.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/e4f4cab5eb140eb314d63c9407e5cb5affe4425990b745182e545a7124efd56f/perl-Pod-Perldoc-3.20-4.amzn2.0.1.src.rpm
```

### `rpm` package: `perl-Pod-Simple-3.28-4.amzn2.noarch`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-Pod-Simple-3.28-4.amzn2.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/bcb63066441032bcca42bfb53de90b05882a96213a57a230fdff95709d2a0b60/perl-Pod-Simple-3.28-4.amzn2.src.rpm
```

### `rpm` package: `perl-Pod-Usage-1.63-3.amzn2.noarch`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-Pod-Usage-1.63-3.amzn2.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/4c457a3263982d0ef201abc908e3cb3d931728c331a0e63259edbdcf3f9b4afb/perl-Pod-Usage-1.63-3.amzn2.src.rpm
```

### `rpm` package: `perl-Scalar-List-Utils-1.27-248.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-Scalar-List-Utils-1.27-248.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/d3699d6b111db2d3323f93fc90afffaad7f6aa4328abc59a888d9ffdcfe2182b/perl-Scalar-List-Utils-1.27-248.amzn2.0.2.src.rpm
```

### `rpm` package: `perl-Socket-2.010-4.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-Socket-2.010-4.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/55c36b75f39d325cfc52dd6f991ad4535e64e543febe31b4c20a648ed78d099a/perl-Socket-2.010-4.amzn2.0.2.src.rpm
```

### `rpm` package: `perl-Storable-2.45-3.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-Storable-2.45-3.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/6c213f8561d991d03c89e24776c930f9c27fb82ce79b72c6ddec4efa58b7d246/perl-Storable-2.45-3.amzn2.0.2.src.rpm
```

### `rpm` package: `perl-TermReadKey-2.30-20.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): (Copyright only) and (Artistic or GPL+)

Source:

```console
$ dnf --quiet download --source --url perl-TermReadKey-2.30-20.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/e0674142d223058676d1bddf802073e9b547ca4dd7ee52b80d13c86136bdd41b/perl-TermReadKey-2.30-20.amzn2.0.2.src.rpm
```

### `rpm` package: `perl-Text-ParseWords-3.29-4.amzn2.noarch`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-Text-ParseWords-3.29-4.amzn2.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/8fe7bb07d03d40d593956118d69592a0ef4ddb94edc52b8445bde44ea2e09497/perl-Text-ParseWords-3.29-4.amzn2.src.rpm
```

### `rpm` package: `perl-Time-HiRes-1.9725-3.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-Time-HiRes-1.9725-3.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/44d7b16eaa4278950a34f5e1c2331502f9bee3226c33bb8aefa3a06a01b4706b/perl-Time-HiRes-1.9725-3.amzn2.0.2.src.rpm
```

### `rpm` package: `perl-Time-Local-1.2300-2.amzn2.noarch`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-Time-Local-1.2300-2.amzn2.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/438306e7101ed9319951d0944520b6b8b4e32dc4c62a22b41c33452424251be1/perl-Time-Local-1.2300-2.amzn2.src.rpm
```

### `rpm` package: `perl-constant-1.27-2.amzn2.0.1.noarch`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-constant-1.27-2.amzn2.0.1.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/c3f791d5e6e12a054558b26393ea628ef3db58ff237f9d38e66b0c865d97dd7a/perl-constant-1.27-2.amzn2.0.1.src.rpm
```

### `rpm` package: `perl-libs-5.16.3-299.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-libs-5.16.3-299.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/a5f079e57ed58ef2c70424f8d5999dbef4ce79f60692443c42fd013d131c6f71/perl-5.16.3-299.amzn2.0.2.src.rpm
```

### `rpm` package: `perl-macros-5.16.3-299.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-macros-5.16.3-299.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/a5f079e57ed58ef2c70424f8d5999dbef4ce79f60692443c42fd013d131c6f71/perl-5.16.3-299.amzn2.0.2.src.rpm
```

### `rpm` package: `perl-parent-0.225-244.amzn2.0.1.noarch`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-parent-0.225-244.amzn2.0.1.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/c1ec8eb69643373f6bff2c62d0d245bf5e9cff655aabb0ba95a215564ba5e213/perl-parent-0.225-244.amzn2.0.1.src.rpm
```

### `rpm` package: `perl-podlators-2.5.1-3.amzn2.0.1.noarch`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-podlators-2.5.1-3.amzn2.0.1.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/a1d47c3bbcffb00df0b739c2b3886a32ee31ebbcceeaf0eff97c4c5983d76946/perl-podlators-2.5.1-3.amzn2.0.1.src.rpm
```

### `rpm` package: `perl-threads-1.87-4.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-threads-1.87-4.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/122a9e1dd2193651581b02990448cac527e261b266ce53afbdc2bd0e4f94a95e/perl-threads-1.87-4.amzn2.0.2.src.rpm
```

### `rpm` package: `perl-threads-shared-1.43-6.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPL+ or Artistic

Source:

```console
$ dnf --quiet download --source --url perl-threads-shared-1.43-6.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/ef1b53f0f61ec6593743fcac0f6cb40288848523a31c4bc611d4925a96e7dd95/perl-threads-shared-1.43-6.amzn2.0.2.src.rpm
```

### `rpm` package: `pinentry-0.8.1-17.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url pinentry-0.8.1-17.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/30819f9f22382344ac3af9a69db748efdb80c7dd77ff73f80d77579fd6409209/pinentry-0.8.1-17.amzn2.0.2.src.rpm
```

### `rpm` package: `pkgconfig-0.27.1-4.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url pkgconfig-0.27.1-4.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/70a23bcbb65ffafe97954c4067be0dbcc9fd4132393d4714005a8ea23750670c/pkgconfig-0.27.1-4.amzn2.0.2.src.rpm
```

### `rpm` package: `popt-1.13-16.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url popt-1.13-16.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/849bd178ea42fbff69e6c5e765042ab80fb56a96bcadc7218926b13765282945/popt-1.13-16.amzn2.0.2.src.rpm
```

### `rpm` package: `pth-2.0.7-23.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url pth-2.0.7-23.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/b168e67224ed78f4c9d2430cad3950ad4e8bb373f8c183347b44f80a4f35e069/pth-2.0.7-23.amzn2.0.2.src.rpm
```

### `rpm` package: `publicsuffix-list-dafsa-20240208-1.amzn2.0.1.noarch`

Licenses (from `rpm --query`): MPLv2.0

Source:

```console
$ dnf --quiet download --source --url publicsuffix-list-dafsa-20240208-1.amzn2.0.1.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/9423832ebddbbb24fba961c53a1c8a646f15fd643eba63b1bf85f7abd8b2a2af/publicsuffix-list-20240208-1.amzn2.0.1.src.rpm
```

### `rpm` package: `pygpgme-0.3-9.amzn2.0.3.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url pygpgme-0.3-9.amzn2.0.3
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/59142d6d866bcc463e322e6bc8ee0dd7155379ba96d2b6d142c28d1e63e2fa2d/pygpgme-0.3-9.amzn2.0.3.src.rpm
```

### `rpm` package: `pyliblzma-0.5.3-25.amzn2.x86_64`

Licenses (from `rpm --query`): LGPLv3+

Source:

```console
$ dnf --quiet download --source --url pyliblzma-0.5.3-25.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/860af43ebf61fc4b2c6c02ec914630e76e68197a77f6b7318b92f5059c7673d1/pyliblzma-0.5.3-25.amzn2.src.rpm
```

### `rpm` package: `python-2.7.18-1.amzn2.0.8.x86_64`

Licenses (from `rpm --query`): Python

Source:

```console
$ dnf --quiet download --source --url python-2.7.18-1.amzn2.0.8
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/11b5c0cf1d5c44bcea2087305fa270e90335775160cf54bb95d03961a4932fb5/python-2.7.18-1.amzn2.0.8.src.rpm
```

### `rpm` package: `python-iniparse-0.4-9.amzn2.noarch`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url python-iniparse-0.4-9.amzn2.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/c44ed4bc8040ce8e74624bd74404387f1c5320ee6b6d975a81e358ab7919b11a/python-iniparse-0.4-9.amzn2.src.rpm
```

### `rpm` package: `python-libs-2.7.18-1.amzn2.0.8.x86_64`

Licenses (from `rpm --query`): Python

Source:

```console
$ dnf --quiet download --source --url python-libs-2.7.18-1.amzn2.0.8
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/11b5c0cf1d5c44bcea2087305fa270e90335775160cf54bb95d03961a4932fb5/python-2.7.18-1.amzn2.0.8.src.rpm
```

### `rpm` package: `python-pycurl-7.19.0-19.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): LGPLv2+ or MIT

Source:

```console
$ dnf --quiet download --source --url python-pycurl-7.19.0-19.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/c498524c54f789da1b967318c6a41d5f28c5b95f66ba831e6de30e246039cf55/python-pycurl-7.19.0-19.amzn2.0.2.src.rpm
```

### `rpm` package: `python-urlgrabber-3.10-9.amzn2.0.1.noarch`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url python-urlgrabber-3.10-9.amzn2.0.1.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/059ccd33bf7223a26eedc0f289477c6c86fa24807e51a00dfbb3b8589ffd60be/python-urlgrabber-3.10-9.amzn2.0.1.src.rpm
```

### `rpm` package: `python2-rpm-4.11.3-48.amzn2.0.4.x86_64`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url python2-rpm-4.11.3-48.amzn2.0.4
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/371e245661fb226af8dbccdc1217fc0532c5a658b790e9ebab060f0e793ba20c/rpm-4.11.3-48.amzn2.0.4.src.rpm
```

### `rpm` package: `pyxattr-0.5.1-5.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url pyxattr-0.5.1-5.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/42d7abe323c155cadf4d22f9c13669b38caddd38a8c6bc8841985e1eec52cb43/pyxattr-0.5.1-5.amzn2.0.2.src.rpm
```

### `rpm` package: `qrencode-libs-3.4.1-3.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url qrencode-libs-3.4.1-3.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/eb3ea431ff21ed04fc3f84c15743285f0c68107fa7630fa8ea9eb8f018de24ca/qrencode-3.4.1-3.amzn2.0.2.src.rpm
```

### `rpm` package: `readline-6.2-10.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url readline-6.2-10.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/e2b36f4a9d20e84ecb267c1a1b7ac1695a02175ffc08876957103338c6c358a7/readline-6.2-10.amzn2.0.2.src.rpm
```

### `rpm` package: `rpm-4.11.3-48.amzn2.0.4.x86_64`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url rpm-4.11.3-48.amzn2.0.4
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/371e245661fb226af8dbccdc1217fc0532c5a658b790e9ebab060f0e793ba20c/rpm-4.11.3-48.amzn2.0.4.src.rpm
```

### `rpm` package: `rpm-build-libs-4.11.3-48.amzn2.0.4.x86_64`

Licenses (from `rpm --query`): GPLv2+ and LGPLv2+ with exceptions

Source:

```console
$ dnf --quiet download --source --url rpm-build-libs-4.11.3-48.amzn2.0.4
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/371e245661fb226af8dbccdc1217fc0532c5a658b790e9ebab060f0e793ba20c/rpm-4.11.3-48.amzn2.0.4.src.rpm
```

### `rpm` package: `rpm-libs-4.11.3-48.amzn2.0.4.x86_64`

Licenses (from `rpm --query`): GPLv2+ and LGPLv2+ with exceptions

Source:

```console
$ dnf --quiet download --source --url rpm-libs-4.11.3-48.amzn2.0.4
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/371e245661fb226af8dbccdc1217fc0532c5a658b790e9ebab060f0e793ba20c/rpm-4.11.3-48.amzn2.0.4.src.rpm
```

### `rpm` package: `sed-4.2.2-5.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url sed-4.2.2-5.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/6536ece4c46bf2ed9823a7e298728310689e54d535226819a7d7fe4b9eeadafd/sed-4.2.2-5.amzn2.0.2.src.rpm
```

### `rpm` package: `setup-2.8.71-10.amzn2.0.1.noarch`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url setup-2.8.71-10.amzn2.0.1.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/a048edcb5e7a6552e092a3fd74a073fdd49e7269dd6f7b982088dc71a32cf631/setup-2.8.71-10.amzn2.0.1.src.rpm
```

### `rpm` package: `shadow-utils-4.1.5.1-24.amzn2.0.3.x86_64`

Licenses (from `rpm --query`): BSD and GPLv2+

Source:

```console
$ dnf --quiet download --source --url shadow-utils-4.1.5.1-24.amzn2.0.3
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/574175b4d80e173235170c0519c72c1fd30597f99fb0602742b9ee686d06ea1d/shadow-utils-4.1.5.1-24.amzn2.0.3.src.rpm
```

### `rpm` package: `shared-mime-info-1.8-4.amzn2.x86_64`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url shared-mime-info-1.8-4.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/9e51e9ed398518c869e22c71a6cf809d331622958224ced40e8ebf31bf5e810f/shared-mime-info-1.8-4.amzn2.src.rpm
```

### `rpm` package: `sqlite-3.7.17-8.amzn2.1.2.x86_64`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url sqlite-3.7.17-8.amzn2.1.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/5ada8c006d0e919d9a1fcdc513c897787b875dcd0143ca89aae582983119f1d6/sqlite-3.7.17-8.amzn2.1.2.src.rpm
```

### `rpm` package: `system-release-2-16.amzn2.x86_64`

Licenses (from `rpm --query`): GPLv2

Source:

```console
$ dnf --quiet download --source --url system-release-2-16.amzn2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/1d86dd37090418630254dc852c55859e9033e342f87091b94c9448bcacdb7b2a/system-release-2-16.amzn2.src.rpm
```

### `rpm` package: `systemd-219-78.amzn2.0.24.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and MIT and GPLv2+

Source:

```console
$ dnf --quiet download --source --url systemd-219-78.amzn2.0.24
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/1ab99585ddae4996705d3779918ad45f13b2a43cd594628a1a2cc2cd0f665861/systemd-219-78.amzn2.0.24.src.rpm
```

### `rpm` package: `systemd-libs-219-78.amzn2.0.24.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and MIT

Source:

```console
$ dnf --quiet download --source --url systemd-libs-219-78.amzn2.0.24
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/1ab99585ddae4996705d3779918ad45f13b2a43cd594628a1a2cc2cd0f665861/systemd-219-78.amzn2.0.24.src.rpm
```

### `rpm` package: `tar-1.26-35.amzn2.0.4.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url tar-1.26-35.amzn2.0.4
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/3b8c768a35cd5e74262981801949409fe7f858b60551129dc34dd70ba7a6c92c/tar-1.26-35.amzn2.0.4.src.rpm
```

### `rpm` package: `tzdata-2024a-1.amzn2.0.1.noarch`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url tzdata-2024a-1.amzn2.0.1.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/9d158b03fd666bbcf8477fcb2ce9ba8545361d7ecc708eba9c90921ddfee8f25/tzdata-2024a-1.amzn2.0.1.src.rpm
```

### `rpm` package: `unzip-6.0-57.amzn2.0.1.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url unzip-6.0-57.amzn2.0.1
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/aff71d0672c160cc7a9273c246ff8adeaf995164ed69f1c2392ef92b168683ce/unzip-6.0-57.amzn2.0.1.src.rpm
```

### `rpm` package: `ustr-1.0.4-16.amzn2.0.3.x86_64`

Licenses (from `rpm --query`): MIT or LGPLv2+ or BSD

Source:

```console
$ dnf --quiet download --source --url ustr-1.0.4-16.amzn2.0.3
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/7477de946dfcd9c18a323e3fbf55abf8fe1137be0adb7d0c114c610963e4210e/ustr-1.0.4-16.amzn2.0.3.src.rpm
```

### `rpm` package: `util-linux-2.30.2-2.amzn2.0.11.x86_64`

Licenses (from `rpm --query`): GPLv2 and GPLv2+ and LGPLv2+ and BSD with advertising and Public Domain

Source:

```console
$ dnf --quiet download --source --url util-linux-2.30.2-2.amzn2.0.11
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/c3d8b01e2190e686623eb8551a13a4a33cc08e086036e951fe5ed1b99c7b2b8e/util-linux-2.30.2-2.amzn2.0.11.src.rpm
```

### `rpm` package: `vim-data-9.0.2153-1.amzn2.0.1.noarch`

Licenses (from `rpm --query`): Vim AND LGPL-2.1-or-later AND MIT AND GPL-1.0-only AND (GPL-2.0-only OR Vim) AND Apache-2.0 AND BSD-2-Clause AND BSD-3-Clause AND GPL-2.0-or-later AND GPL-3.0-or-later AND OPUBL-1.0

Source:

```console
$ dnf --quiet download --source --url vim-data-9.0.2153-1.amzn2.0.1.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/928d719f6dff2671e2d73f21a7445f177d046b892e8c9fcc4fcac965e8d334f5/vim-9.0.2153-1.amzn2.0.1.src.rpm
```

### `rpm` package: `vim-minimal-9.0.2153-1.amzn2.0.1.x86_64`

Licenses (from `rpm --query`): Vim AND LGPL-2.1-or-later AND MIT AND GPL-1.0-only AND (GPL-2.0-only OR Vim) AND Apache-2.0 AND BSD-2-Clause AND BSD-3-Clause AND GPL-2.0-or-later AND GPL-3.0-or-later AND OPUBL-1.0

Source:

```console
$ dnf --quiet download --source --url vim-minimal-9.0.2153-1.amzn2.0.1
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/928d719f6dff2671e2d73f21a7445f177d046b892e8c9fcc4fcac965e8d334f5/vim-9.0.2153-1.amzn2.0.1.src.rpm
```

### `rpm` package: `xz-devel-5.2.2-1.amzn2.0.3.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url xz-devel-5.2.2-1.amzn2.0.3
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/e2158e7ac9785d1ff7288d90ddb7ac041ba54804e86b9a604ea0717444a17a76/xz-5.2.2-1.amzn2.0.3.src.rpm
```

### `rpm` package: `xz-libs-5.2.2-1.amzn2.0.3.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url xz-libs-5.2.2-1.amzn2.0.3
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/e2158e7ac9785d1ff7288d90ddb7ac041ba54804e86b9a604ea0717444a17a76/xz-5.2.2-1.amzn2.0.3.src.rpm
```

### `rpm` package: `yum-3.4.3-158.amzn2.0.7.noarch`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url yum-3.4.3-158.amzn2.0.7.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/20b76b7827c4831d4cb21e9901970ecfbc6f9215182ce9a40b6c4e96acf51561/yum-3.4.3-158.amzn2.0.7.src.rpm
```

### `rpm` package: `yum-metadata-parser-1.1.4-10.amzn2.0.2.x86_64`

Licenses (from `rpm --query`): GPLv2

Source:

```console
$ dnf --quiet download --source --url yum-metadata-parser-1.1.4-10.amzn2.0.2
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/b710ba0dd68993f774c5fe5325edfec71935fa2f0dba7cd548692b84f31b7988/yum-metadata-parser-1.1.4-10.amzn2.0.2.src.rpm
```

### `rpm` package: `yum-plugin-ovl-1.1.31-46.amzn2.0.1.noarch`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url yum-plugin-ovl-1.1.31-46.amzn2.0.1.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/74e03e38d661b26d57dc3fcbd58a66e736b5e8979ccf0493149d0add45dd0416/yum-utils-1.1.31-46.amzn2.0.1.src.rpm
```

### `rpm` package: `yum-plugin-priorities-1.1.31-46.amzn2.0.1.noarch`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url yum-plugin-priorities-1.1.31-46.amzn2.0.1.noarch
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/74e03e38d661b26d57dc3fcbd58a66e736b5e8979ccf0493149d0add45dd0416/yum-utils-1.1.31-46.amzn2.0.1.src.rpm
```

### `rpm` package: `zlib-1.2.7-19.amzn2.0.3.x86_64`

Licenses (from `rpm --query`): zlib and Boost

Source:

```console
$ dnf --quiet download --source --url zlib-1.2.7-19.amzn2.0.3
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/a4d3572abd43bc021bfe5c83e87d4394ca6f5fb879109d4cdb152a0e1b10dbc4/zlib-1.2.7-19.amzn2.0.3.src.rpm
```

### `rpm` package: `zlib-devel-1.2.7-19.amzn2.0.3.x86_64`

Licenses (from `rpm --query`): zlib and Boost

Source:

```console
$ dnf --quiet download --source --url zlib-devel-1.2.7-19.amzn2.0.3
https://cdn.amazonlinux.com/2/core/2.0/SRPMS/630b6d20aa6cde93eb91c1ba0861b108f89e6ad0d26f1abe0f87c9ec8ac465b9/../../../../../blobstore/a4d3572abd43bc021bfe5c83e87d4394ca6f5fb879109d4cdb152a0e1b10dbc4/zlib-1.2.7-19.amzn2.0.3.src.rpm
```
