# `spark:4.0.0-preview2-scala2.13-java17-r-ubuntu`

## Docker Metadata

- Image ID: `sha256:439d5ea1cd4f878a10877b7c27645d7b874482fc8b76ec75e6b8d875e4816b8d`
- Created: `2024-10-08T09:12:28Z`
- Virtual Size: ~ 1.81 Gb  
  (total size of all layers on-disk)
- Arch: `linux`/`amd64`
- Entrypoint: `["/opt/entrypoint.sh"]`
- Environment:
  - `PATH=/opt/java/openjdk/bin:/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin`
  - `JAVA_HOME=/opt/java/openjdk`
  - `LANG=en_US.UTF-8`
  - `LANGUAGE=en_US:en`
  - `LC_ALL=en_US.UTF-8`
  - `JAVA_VERSION=jdk-17.0.13+11`
  - `SPARK_TGZ_URL=https://archive.apache.org/dist/spark/spark-4.0.0-preview2/spark-4.0.0-preview2-bin-hadoop3.tgz`
  - `SPARK_TGZ_ASC_URL=https://archive.apache.org/dist/spark/spark-4.0.0-preview2/spark-4.0.0-preview2-bin-hadoop3.tgz.asc`
  - `GPG_KEY=F28C9C925C188C35E345614DEDA00CE834F0FC5C`
  - `SPARK_HOME=/opt/spark`
  - `R_HOME=/usr/lib/R`
- Labels:
  - `org.opencontainers.image.ref.name=ubuntu`
  - `org.opencontainers.image.version=22.04`

## `dpkg` (`.deb`-based packages)

### `dpkg` source package: `acl=2.3.1-1`

Binary Packages:

- `libacl1:amd64=2.3.1-1`

Licenses: (parsed from: `/usr/share/doc/libacl1/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2+`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris acl=2.3.1-1
'http://archive.ubuntu.com/ubuntu/pool/main/a/acl/acl_2.3.1-1.dsc' acl_2.3.1-1.dsc 2486 SHA512:8eb7f71030d7c4d355886390f12ffd7f66605bb2082a9a9de2eea0918aefe7b7cf1c26a3f8872681f5b3074df1cf07c4d01ae564bcba5b400b048b0e34b233c2
'http://archive.ubuntu.com/ubuntu/pool/main/a/acl/acl_2.3.1.orig.tar.xz' acl_2.3.1.orig.tar.xz 355676 SHA512:7d02f05d17305f8587ab485395b00c7fdb8e44c1906d0d04b70a43a3020803e8b2b8c707abb6147f794867dfa87bd51769c2d3e11a3db55ecbd2006a6e6231dc
'http://archive.ubuntu.com/ubuntu/pool/main/a/acl/acl_2.3.1.orig.tar.xz.asc' acl_2.3.1.orig.tar.xz.asc 833 SHA512:be046f3bf1ac7e21d2a07bf6ea87c1fedeed2f9d370d8bf3de1aa0c448de5484b1523697415849b6b7ca23e48e3df5353f6aebe850eb20fc2044d2681c71f298
'http://archive.ubuntu.com/ubuntu/pool/main/a/acl/acl_2.3.1-1.debian.tar.xz' acl_2.3.1-1.debian.tar.xz 27732 SHA512:2fdfcd8daa1919e850cd3ed634b4141d65bbf7847eaf0a7899b6e8ae52fe2fa15de3378f6487a9224d00eb530cf5b285cc3b6272af66fcdcf1f29f2838648083
```

### `dpkg` source package: `adduser=3.118ubuntu5`

Binary Packages:

- `adduser=3.118ubuntu5`

Licenses: (parsed from: `/usr/share/doc/adduser/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris adduser=3.118ubuntu5
'http://archive.ubuntu.com/ubuntu/pool/main/a/adduser/adduser_3.118ubuntu5.dsc' adduser_3.118ubuntu5.dsc 1766 SHA512:8d6e9894549dc9dd53db8480cb18ee9b012bc70ea7b53d72b0ad8ad713a1672d2e94750e1cde44d2b8f9fd7e66b1ea7c2ad20202fc7bcd90e2fba5cee63d5b5d
'http://archive.ubuntu.com/ubuntu/pool/main/a/adduser/adduser_3.118ubuntu5.tar.xz' adduser_3.118ubuntu5.tar.xz 222904 SHA512:ded568a5a3f5a5ac1acc2098e37160194f8c4622e90c7044d599286a321fe8fd701c8554a4517e4d72a6089b8e3b5592b92d46668032bda81de64cc736bf0a75
```

### `dpkg` source package: `adwaita-icon-theme=41.0-1ubuntu1`

Binary Packages:

- `adwaita-icon-theme=41.0-1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/adwaita-icon-theme/copyright`)

- `CC-BY-3.0-US`
- `CC-BY-SA-2.0-IT`
- `CC-BY-SA-2.0-IT,`
- `CC-BY-SA-3.0`
- `CC-BY-SA-3.0-US`
- `CC-BY-SA-3.0-Unported`
- `CC-BY-SA-4.0`
- `GFDL-1.2`
- `GFDL-1.2+`
- `GPL`
- `GPL-unspecified`
- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris adwaita-icon-theme=41.0-1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/a/adwaita-icon-theme/adwaita-icon-theme_41.0-1ubuntu1.dsc' adwaita-icon-theme_41.0-1ubuntu1.dsc 1930 SHA512:24721ff34c56a80da2954c366049cfe61398a6728c2003502992611b0c60905c96eb1eca9a815e4e63114fd906d5dcb366c15457fcd05dd886dd694575c37fb9
'http://archive.ubuntu.com/ubuntu/pool/main/a/adwaita-icon-theme/adwaita-icon-theme_41.0.orig.tar.xz' adwaita-icon-theme_41.0.orig.tar.xz 17086916 SHA512:2a540f2b53cb64433780029ea70c2cfe8417ae7e619d8eefa59825e3ebcb8585acd4ccae25344c8e146a0ee0705ccbb39a2cb729a162534fd86a4ff24e505c86
'http://archive.ubuntu.com/ubuntu/pool/main/a/adwaita-icon-theme/adwaita-icon-theme_41.0-1ubuntu1.debian.tar.xz' adwaita-icon-theme_41.0-1ubuntu1.debian.tar.xz 36476 SHA512:cacae2351ac5897a186c393a9e073283eaaaa238349145ab1a64a4fad48cded5944c7bb9925583258414f13fb7e95cd14fdc10131685bc8bf635808349c33016
```

### `dpkg` source package: `apparmor=3.0.4-2ubuntu2.4`

Binary Packages:

- `libapparmor1:amd64=3.0.4-2ubuntu2.4`

Licenses: (parsed from: `/usr/share/doc/libapparmor1/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris apparmor=3.0.4-2ubuntu2.4
'http://archive.ubuntu.com/ubuntu/pool/main/a/apparmor/apparmor_3.0.4-2ubuntu2.4.dsc' apparmor_3.0.4-2ubuntu2.4.dsc 3263 SHA512:fd0eb724b2d43077a3708bd51729e884c972e361a36952f0f7ba2a686f76630ab38478b3906843943d0515997ecdd8a8807f702b1a73a0b12667433ad9a50306
'http://archive.ubuntu.com/ubuntu/pool/main/a/apparmor/apparmor_3.0.4.orig.tar.gz' apparmor_3.0.4.orig.tar.gz 7796852 SHA512:1edd800771f46fab9bc5274842e64482b7fd4a5ba4de9855d621baf1d08c8236bfa7752dd9ab3dee095f8e0798129241a9aebf68ed1c994ae5597086a4a1a8ca
'http://archive.ubuntu.com/ubuntu/pool/main/a/apparmor/apparmor_3.0.4.orig.tar.gz.asc' apparmor_3.0.4.orig.tar.gz.asc 870 SHA512:870d3037562ae003e642adcd244b74191e9108cebd18e6a925959e595b5a375e2dbfda686349e4cc980981cdd38239a099d3e32f1e824b4a9b477584c8d311a9
'http://archive.ubuntu.com/ubuntu/pool/main/a/apparmor/apparmor_3.0.4-2ubuntu2.4.debian.tar.xz' apparmor_3.0.4-2ubuntu2.4.debian.tar.xz 136888 SHA512:da616c757022828f738e09e0a04ab9a93b1575acc30318abd2e60ef193c8ef7e3acac4d3d545ee5f3b0310347187d09db8fe0c4ec8422893a6375b9f46c424f0
```

### `dpkg` source package: `apt=2.4.13`

Binary Packages:

- `apt=2.4.13`
- `libapt-pkg6.0:amd64=2.4.13`

Licenses: (parsed from: `/usr/share/doc/apt/copyright`, `/usr/share/doc/libapt-pkg6.0/copyright`)

- `GPL-2`
- `GPLv2+`

Source:

```console
$ apt-get source -qq --print-uris apt=2.4.13
'http://archive.ubuntu.com/ubuntu/pool/main/a/apt/apt_2.4.13.dsc' apt_2.4.13.dsc 2801 SHA512:a3b478fc618f6d5cb69e7489543ce3ef89b9f604162adb9540a45f45845c31081647ba6c08fea7d1d125c30daa09d718f88493d850546aa0edb409e1840a79d1
'http://archive.ubuntu.com/ubuntu/pool/main/a/apt/apt_2.4.13.tar.xz' apt_2.4.13.tar.xz 2323800 SHA512:8b085133f1d4416698182374a6b5df2f5d1509500d6c6ebfd7b47c2288f176f0c332703af1a8de0b79ea5fceb2bbd2a0470bd86d584ea36927bc87f406c2d570
```

### `dpkg` source package: `argon2=0~20171227-0.3`

Binary Packages:

- `libargon2-1:amd64=0~20171227-0.3`

Licenses: (parsed from: `/usr/share/doc/libargon2-1/copyright`)

- `Apache-2.0`
- `CC0`

Source:

```console
$ apt-get source -qq --print-uris argon2=0~20171227-0.3
'http://archive.ubuntu.com/ubuntu/pool/main/a/argon2/argon2_0%7e20171227-0.3.dsc' argon2_0~20171227-0.3.dsc 1787 SHA512:e863a45ac718218f9d3f37b4f3f6918c4b09d6b3a972444b3f751025785c41843480ab15141f0dc69e7f8cc71ddb4856cb16ca0d4b02f1838f6c264eef900db8
'http://archive.ubuntu.com/ubuntu/pool/main/a/argon2/argon2_0%7e20171227.orig.tar.gz' argon2_0~20171227.orig.tar.gz 1503745 SHA512:9c9e1a3905e61ac6913d1e073c104477e419ddd0506adc4487e88e98d19165ed8901fe8bb11246ed0cc71b3523c190da9692d5926642f86be09c3e67510afe4d
'http://archive.ubuntu.com/ubuntu/pool/main/a/argon2/argon2_0%7e20171227-0.3.debian.tar.xz' argon2_0~20171227-0.3.debian.tar.xz 7024 SHA512:01629e85a51d2826ff04fa5f446c1bcd8d87699591b6228316dc654f863ea8434bd4e5619922fd985a11d051fdb3a3a8ce1ba2eb06b1cbc0e4b554b533930e16
```

### `dpkg` source package: `at-spi2-atk=2.38.0-3`

Binary Packages:

- `libatk-bridge2.0-0:amd64=2.38.0-3`

Licenses: (parsed from: `/usr/share/doc/libatk-bridge2.0-0/copyright`)

- `GPL-2`
- `LGPL-2`
- `LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris at-spi2-atk=2.38.0-3
'http://archive.ubuntu.com/ubuntu/pool/main/a/at-spi2-atk/at-spi2-atk_2.38.0-3.dsc' at-spi2-atk_2.38.0-3.dsc 2632 SHA512:829df547290263658099b4f003a001fe159c4b40cf3b7a1fa030a951d5b2fdb5cee658756e8aba1e54a0cb5d427372c67d0ff9025a0deac8617734cde0c7e9ff
'http://archive.ubuntu.com/ubuntu/pool/main/a/at-spi2-atk/at-spi2-atk_2.38.0.orig.tar.xz' at-spi2-atk_2.38.0.orig.tar.xz 97464 SHA512:2f40ecbc55b0fbaa57ade952a75583bc8fbfde234cce9248489e9ae06e0597d98c2f4c77d8279758dec29da97e06cde5708d30a1238d91bebd023b2320f38528
'http://archive.ubuntu.com/ubuntu/pool/main/a/at-spi2-atk/at-spi2-atk_2.38.0-3.debian.tar.xz' at-spi2-atk_2.38.0-3.debian.tar.xz 10740 SHA512:e06373ea6d0a09cce7875427397841073b135a3a0c29cef6b52bf5d10b2049a0856eb0933f51be4dc1a1efe2a82ea9548c5801273b9b41bc03c86aface303f6b
```

### `dpkg` source package: `at-spi2-core=2.44.0-3`

Binary Packages:

- `at-spi2-core=2.44.0-3`
- `libatspi2.0-0:amd64=2.44.0-3`

Licenses: (parsed from: `/usr/share/doc/at-spi2-core/copyright`, `/usr/share/doc/libatspi2.0-0/copyright`)

- `AFL-2.1`
- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris at-spi2-core=2.44.0-3
'http://archive.ubuntu.com/ubuntu/pool/main/a/at-spi2-core/at-spi2-core_2.44.0-3.dsc' at-spi2-core_2.44.0-3.dsc 2743 SHA512:e9cdb1f0ecd1cce934761d0bc6eae0b9d6078ff379c36215185227fb570333ef2cb5224460a67f8ca30dca7ba332f6a7952b68bc1d1162332f634a98ea8481bf
'http://archive.ubuntu.com/ubuntu/pool/main/a/at-spi2-core/at-spi2-core_2.44.0.orig.tar.xz' at-spi2-core_2.44.0.orig.tar.xz 209692 SHA512:6d74a56d7ad6c643985e98aebbbf0cdaad69c03b8030f8968bd9cce9357805cd846d71d35d2cc4a193770cd6d4a83cbfb98ef082e17719f3dee7b839c48bda44
'http://archive.ubuntu.com/ubuntu/pool/main/a/at-spi2-core/at-spi2-core_2.44.0-3.debian.tar.xz' at-spi2-core_2.44.0-3.debian.tar.xz 11896 SHA512:52b3ec9265a7a5f0f2301ae7b6fa3ef9a8c89f80ba37ba5381b33a02208005ec5aca86bc9522db46ed6e77ddfa8b634cd806e9540e55f505490e767a7434e31a
```

### `dpkg` source package: `atk1.0=2.36.0-3build1`

Binary Packages:

- `libatk1.0-0:amd64=2.36.0-3build1`
- `libatk1.0-data=2.36.0-3build1`

Licenses: (parsed from: `/usr/share/doc/libatk1.0-0/copyright`, `/usr/share/doc/libatk1.0-data/copyright`)

- `LGPL-2`

Source:

```console
$ apt-get source -qq --print-uris atk1.0=2.36.0-3build1
'http://archive.ubuntu.com/ubuntu/pool/main/a/atk1.0/atk1.0_2.36.0-3build1.dsc' atk1.0_2.36.0-3build1.dsc 2310 SHA512:8b3383878c33b50ac0a2c2888c1ea4ee61a21734547a2daf8f5982c97cf6508ef67cd531c41f728e510fab9df1a5ed07c034f06f1d8a900018c7d9c4a0ddb559
'http://archive.ubuntu.com/ubuntu/pool/main/a/atk1.0/atk1.0_2.36.0.orig.tar.xz' atk1.0_2.36.0.orig.tar.xz 299100 SHA512:d0f18204eaf96511e8448e3dfbc4b6953a7cf8b816151fb7caf5592cf578572b1cdb16836fe2157b11e3ad018ef171f1ca1bfdf255bb31bb455716d7519fd634
'http://archive.ubuntu.com/ubuntu/pool/main/a/atk1.0/atk1.0_2.36.0-3build1.debian.tar.xz' atk1.0_2.36.0-3build1.debian.tar.xz 12228 SHA512:5029866aae4cc5b0eabe2a9f9faade83c2229c2d30d09ce4cdef35145eca7c2f4b7bae3695907503b92bb953449d6318450d5e3cba6fba43694e5f24f7f64941
```

### `dpkg` source package: `attr=1:2.5.1-1build1`

Binary Packages:

- `libattr1:amd64=1:2.5.1-1build1`

Licenses: (parsed from: `/usr/share/doc/libattr1/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2+`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris attr=1:2.5.1-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/a/attr/attr_2.5.1-1build1.dsc' attr_2.5.1-1build1.dsc 2134 SHA512:4beeec510cf7976a3b2c0de3b90974ef03886b3a98ccb2b74f6278ed988727af3a0fa432d86aefd3bdb4bc50e29b3351f11fd892512407203f3e61636290ae15
'http://archive.ubuntu.com/ubuntu/pool/main/a/attr/attr_2.5.1.orig.tar.xz' attr_2.5.1.orig.tar.xz 318188 SHA512:9e5555260189bb6ef2440c76700ebb813ff70582eb63d446823874977307d13dfa3a347dfae619f8866943dfa4b24ccf67dadd7e3ea2637239fdb219be5d2932
'http://archive.ubuntu.com/ubuntu/pool/main/a/attr/attr_2.5.1.orig.tar.xz.asc' attr_2.5.1.orig.tar.xz.asc 833 SHA512:be4f3629ef66bd400bcdeaf8b6b1564dc729472a514d59fb4909a30f3269711dedea16002283e9aabbf83c374e0a3d70bc00f1136da0fed66a8184acdfd7e78f
'http://archive.ubuntu.com/ubuntu/pool/main/a/attr/attr_2.5.1-1build1.debian.tar.xz' attr_2.5.1-1build1.debian.tar.xz 28032 SHA512:c9d0869a3bb9f8019e6764fee3a78d8b1b9a3cdb37968aac19a9a7e7bbeeaadcbad86d5363ce3b0e26b5a178a4d446e4097d095e17b7a6d7f3e595d07176675c
```

### `dpkg` source package: `audit=1:3.0.7-1build1`

Binary Packages:

- `libaudit-common=1:3.0.7-1build1`
- `libaudit1:amd64=1:3.0.7-1build1`

Licenses: (parsed from: `/usr/share/doc/libaudit-common/copyright`, `/usr/share/doc/libaudit1/copyright`)

- `GPL-1`
- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris audit=1:3.0.7-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/a/audit/audit_3.0.7-1build1.dsc' audit_3.0.7-1build1.dsc 2771 SHA512:beb14e23239ab9c87dd4a57821d7d557a14a3e67f66306110ef87cd77cd2c07426f3bc8413d757618f886c5059e9bf624347753170708e0ad39b90f96fd51053
'http://archive.ubuntu.com/ubuntu/pool/main/a/audit/audit_3.0.7.orig.tar.gz' audit_3.0.7.orig.tar.gz 1180226 SHA512:b5662b32082fc2ac54e247aa0db5442d76afa30134ebba1d624a17004e9ccf6856bb75344af4ce9d9a0a66c03e1c6f18b7d45658d7df13ea71af0c8362e08d70
'http://archive.ubuntu.com/ubuntu/pool/main/a/audit/audit_3.0.7-1build1.debian.tar.xz' audit_3.0.7-1build1.debian.tar.xz 17772 SHA512:cdf346fc7dc04e42b44a9089fb7c01e68ea54ccd20d3eef8100d0cd8eed8ebd0764d8fd6ceab133faa0bfeee18e3cfe7625d230600b0e34ed0c19a7b739ec783
```

### `dpkg` source package: `avahi=0.8-5ubuntu5.2`

Binary Packages:

- `libavahi-client3:amd64=0.8-5ubuntu5.2`
- `libavahi-common-data:amd64=0.8-5ubuntu5.2`
- `libavahi-common3:amd64=0.8-5ubuntu5.2`

Licenses: (parsed from: `/usr/share/doc/libavahi-client3/copyright`, `/usr/share/doc/libavahi-common-data/copyright`, `/usr/share/doc/libavahi-common3/copyright`)

- `GPL`
- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris avahi=0.8-5ubuntu5.2
'http://archive.ubuntu.com/ubuntu/pool/main/a/avahi/avahi_0.8-5ubuntu5.2.dsc' avahi_0.8-5ubuntu5.2.dsc 3756 SHA512:f0bb10a4442b9d37cdfd5bb2ec2cd5d40d8a94e5219b6c132de61800b8337f2a08d89bdc393b7e790a4afb5de08f262190f04c578903a090197fb5ce06281e53
'http://archive.ubuntu.com/ubuntu/pool/main/a/avahi/avahi_0.8.orig.tar.gz' avahi_0.8.orig.tar.gz 1591458 SHA512:c6ba76feb6e92f70289f94b3bf12e5f5c66c11628ce0aeb3cadfb72c13a5d1a9bd56d71bdf3072627a76cd103b9b056d9131aa49ffe11fa334c24ab3b596c7de
'http://archive.ubuntu.com/ubuntu/pool/main/a/avahi/avahi_0.8-5ubuntu5.2.debian.tar.xz' avahi_0.8-5ubuntu5.2.debian.tar.xz 45172 SHA512:7953ba54ebe1c44a501825ce2b19112850b7c0854a229633ebe3d89bfb3d9bfbbabe5030d5a22f24d65d70af5fdab52d3153f803ec321853368a36e3347cc9f0
```

### `dpkg` source package: `base-files=12ubuntu4.7`

Binary Packages:

- `base-files=12ubuntu4.7`

Licenses: (parsed from: `/usr/share/doc/base-files/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris base-files=12ubuntu4.7
'http://archive.ubuntu.com/ubuntu/pool/main/b/base-files/base-files_12ubuntu4.7.dsc' base-files_12ubuntu4.7.dsc 1277 SHA512:9421fa1b62eb1c09d8aa93bb7c96ceaa077aaa4841ed5e516a682cfcc7cefdb7a7fd87976ba9e2718791fda2583141710968c4ce7357e089f5e5c3f7a0683ccf
'http://archive.ubuntu.com/ubuntu/pool/main/b/base-files/base-files_12ubuntu4.7.tar.xz' base-files_12ubuntu4.7.tar.xz 81888 SHA512:e3a9f3188f6f43a53818200ac110f504f81b2819e301d69931a18fb34673541c11b2fc43af256e0c52f4a6daa6bd4b408b99ba432fa1b2b6624658bf312b0db5
```

### `dpkg` source package: `base-passwd=3.5.52build1`

Binary Packages:

- `base-passwd=3.5.52build1`

Licenses: (parsed from: `/usr/share/doc/base-passwd/copyright`)

- `GPL-2`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris base-passwd=3.5.52build1
'http://archive.ubuntu.com/ubuntu/pool/main/b/base-passwd/base-passwd_3.5.52build1.dsc' base-passwd_3.5.52build1.dsc 1320 SHA512:2071171adf14d276664526662fab08d34a45a259ebcdbee7ae57bb004d3d12793e629006a37b649f16c0f04856e9f7bb79fb92fe304525167f48e73dec0cc4fd
'http://archive.ubuntu.com/ubuntu/pool/main/b/base-passwd/base-passwd_3.5.52build1.tar.xz' base-passwd_3.5.52build1.tar.xz 54252 SHA512:699ffe50f4a7fbdea2c0b25d3b2452d538598870cf39b84668d9b7efa20ec41284c331513e89c966e7248732b1ec1abdfdb871e31f8e9efa026c691e89236ffe
```

### `dpkg` source package: `bash=5.1-6ubuntu1.1`

Binary Packages:

- `bash=5.1-6ubuntu1.1`

Licenses: (parsed from: `/usr/share/doc/bash/copyright`)

- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris bash=5.1-6ubuntu1.1
'http://archive.ubuntu.com/ubuntu/pool/main/b/bash/bash_5.1-6ubuntu1.1.dsc' bash_5.1-6ubuntu1.1.dsc 2409 SHA512:8adffecbfd9ffe55500fb70616e4b441bccb95fda13762dc2cccc3605a25f34851b142d2c633f17a5a7e426f0c5010ad76b0a70d375f923e25f6c9f4c893c8e4
'http://archive.ubuntu.com/ubuntu/pool/main/b/bash/bash_5.1.orig.tar.xz' bash_5.1.orig.tar.xz 5802740 SHA512:95d3acc542231cb893e1347c7d9dd66687f68cd347a0e9e126fde2d14e68c5b5530d1a5866eafa781e88aa013fcf72b4ad56d2e484c2ac7a69bd90bb149a9b86
'http://archive.ubuntu.com/ubuntu/pool/main/b/bash/bash_5.1-6ubuntu1.1.debian.tar.xz' bash_5.1-6ubuntu1.1.debian.tar.xz 99944 SHA512:d7fb6110df70232bd3280c1140a812a1903968792f6608481c184bd28760d03323ada75ed3ca4da4eb6c56a84781d6e2f441e0ee83dd9364a9e37fd0fa2211e9
```

### `dpkg` source package: `bind9=1:9.18.28-0ubuntu0.22.04.1`

Binary Packages:

- `bind9-host=1:9.18.28-0ubuntu0.22.04.1`
- `bind9-libs:amd64=1:9.18.28-0ubuntu0.22.04.1`

Licenses: (parsed from: `/usr/share/doc/bind9-host/copyright`, `/usr/share/doc/bind9-libs/copyright`)

- `BSD-2-clause`
- `BSD-3-clause`
- `CC0-1.0`
- `ISC`
- `MPL-2.0`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris bind9=1:9.18.28-0ubuntu0.22.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/b/bind9/bind9_9.18.28-0ubuntu0.22.04.1.dsc' bind9_9.18.28-0ubuntu0.22.04.1.dsc 3292 SHA512:2a452df1d8a66f4ac0a06d91403111a318071cfb43884fe80a8b95c4292ef8c48435e9ad05a5c0621ed47ecc36fa227589301e3c1f8d17e0cc420ecc35e33b87
'http://archive.ubuntu.com/ubuntu/pool/main/b/bind9/bind9_9.18.28.orig.tar.xz' bind9_9.18.28.orig.tar.xz 5533340 SHA512:19ba625f155c60dd821e3afe52adf3897b3e81289320282b3f43d604af1e7d4e67fafb98a9849782684935008bcd148f190e05234d501aa056daa6724e0119bb
'http://archive.ubuntu.com/ubuntu/pool/main/b/bind9/bind9_9.18.28.orig.tar.xz.asc' bind9_9.18.28.orig.tar.xz.asc 833 SHA512:e6efe2a9995cabd70c1d2e8e4cb97a9a146e3289d75cfdc81ff8052329db3dd920b9f8f6ad0f1552a0e4e776b01fb077edd5f3d4ea3461952f71dda64574d640
'http://archive.ubuntu.com/ubuntu/pool/main/b/bind9/bind9_9.18.28-0ubuntu0.22.04.1.debian.tar.xz' bind9_9.18.28-0ubuntu0.22.04.1.debian.tar.xz 92720 SHA512:b2fc0cc7f6c77caf360d8762b04aa5bcc454d1f20cd5aa2e054997a03fd8ed5c4deaf1b67dc929e38f081d57667d88e51941d85a7e3518d76c99324b586cdd8c
```

### `dpkg` source package: `binutils=2.38-4ubuntu2.6`

Binary Packages:

- `binutils=2.38-4ubuntu2.6`
- `binutils-common:amd64=2.38-4ubuntu2.6`
- `binutils-x86-64-linux-gnu=2.38-4ubuntu2.6`
- `libbinutils:amd64=2.38-4ubuntu2.6`
- `libctf-nobfd0:amd64=2.38-4ubuntu2.6`
- `libctf0:amd64=2.38-4ubuntu2.6`

Licenses: (parsed from: `/usr/share/doc/binutils/copyright`, `/usr/share/doc/binutils-common/copyright`, `/usr/share/doc/binutils-x86-64-linux-gnu/copyright`, `/usr/share/doc/libbinutils/copyright`, `/usr/share/doc/libctf-nobfd0/copyright`, `/usr/share/doc/libctf0/copyright`)

- `GFDL`
- `GPL`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris binutils=2.38-4ubuntu2.6
'http://archive.ubuntu.com/ubuntu/pool/main/b/binutils/binutils_2.38-4ubuntu2.6.dsc' binutils_2.38-4ubuntu2.6.dsc 8553 SHA512:cae942aebf4eb0391feb581df7c4a4806975c7236049c135746a65f6a78076354797891d948f77d2815acba0437aad801c71597e236f8d42b0c25b68f75b2839
'http://archive.ubuntu.com/ubuntu/pool/main/b/binutils/binutils_2.38.orig.tar.xz' binutils_2.38.orig.tar.xz 23651408 SHA512:8bf0b0d193c9c010e0518ee2b2e5a830898af206510992483b427477ed178396cd210235e85fd7bd99a96fc6d5eedbeccbd48317a10f752b7336ada8b2bb826d
'http://archive.ubuntu.com/ubuntu/pool/main/b/binutils/binutils_2.38-4ubuntu2.6.debian.tar.xz' binutils_2.38-4ubuntu2.6.debian.tar.xz 300788 SHA512:6106e9d7056ae9468677545d11118041028286b1963d06d174f3d673f3801fefaf6863f1912220ec7619952ff745322b5d567e323533a11e5f226e2cc28e9662
```

### `dpkg` source package: `boot=1.3-28-2`

Binary Packages:

- `r-cran-boot=1.3-28-2`

Licenses: (parsed from: `/usr/share/doc/r-cran-boot/copyright`)

- `'unlimited distribution'`

Source:

```console
$ apt-get source -qq --print-uris boot=1.3-28-2
'http://archive.ubuntu.com/ubuntu/pool/universe/b/boot/boot_1.3-28-2.dsc' boot_1.3-28-2.dsc 1802 SHA512:7aa0d0b19e66326650e598b28380d78087482bdced616386f7b2d0d8da1ab87ff0f5926f091ab045d8cc0e792136d105d4cbef113bd3b06ef5a02114cb52ec1e
'http://archive.ubuntu.com/ubuntu/pool/universe/b/boot/boot_1.3-28.orig.tar.gz' boot_1.3-28.orig.tar.gz 236842 SHA512:e274f3de208cf4f9f74102a82ff34a32e92928328353d77ac9a99e1e34d66a65e941a66656367668bd7fe5633484eff8dcfa42a9e5957db72368c604e2a16007
'http://archive.ubuntu.com/ubuntu/pool/universe/b/boot/boot_1.3-28-2.debian.tar.xz' boot_1.3-28-2.debian.tar.xz 5316 SHA512:f5f8e71b6c2d577c03e013f2daf540a3b534f1a42f48658066432030ac8099dd1352eb2992ffa8c3b1d8bdad9659996248f6407345967a6fd3d6cea1f14554a7
```

### `dpkg` source package: `brotli=1.0.9-2build6`

Binary Packages:

- `libbrotli1:amd64=1.0.9-2build6`

Licenses: (parsed from: `/usr/share/doc/libbrotli1/copyright`)

- `MIT`

Source:

```console
$ apt-get source -qq --print-uris brotli=1.0.9-2build6
'http://archive.ubuntu.com/ubuntu/pool/main/b/brotli/brotli_1.0.9-2build6.dsc' brotli_1.0.9-2build6.dsc 1940 SHA512:9294702945cdaadad51f8690e7454d06b3281f94429123a4353cfdcce9eac598e9ad827f97f74798a7e958147aafec059022214b3bb7fe1db6337bebec2774b4
'http://archive.ubuntu.com/ubuntu/pool/main/b/brotli/brotli_1.0.9.orig.tar.gz' brotli_1.0.9.orig.tar.gz 486984 SHA512:b8e2df955e8796ac1f022eb4ebad29532cb7e3aa6a4b6aee91dbd2c7d637eee84d9a144d3e878895bb5e62800875c2c01c8f737a1261020c54feacf9f676b5f5
'http://archive.ubuntu.com/ubuntu/pool/main/b/brotli/brotli_1.0.9-2build6.debian.tar.xz' brotli_1.0.9-2build6.debian.tar.xz 5812 SHA512:a50a2e8ce37aa228c3074f657d5591cd509f6b34e78b3b16b044072886c184623994a6420e5c0759a2bab1df26ba69462692c7d2c59bdc72f9683b7df884771c
```

### `dpkg` source package: `build-essential=12.9ubuntu3`

Binary Packages:

- `build-essential=12.9ubuntu3`

Licenses: (parsed from: `/usr/share/doc/build-essential/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris build-essential=12.9ubuntu3
'http://archive.ubuntu.com/ubuntu/pool/main/b/build-essential/build-essential_12.9ubuntu3.dsc' build-essential_12.9ubuntu3.dsc 2045 SHA512:32429bbff9796c9a989ed68575620a9a4239857bdee5ee2d56573c9622c1df3984e63b13ab9abbae29795cc3ca43852b3b61706b5e01f07fa00d368ba29ddbc9
'http://archive.ubuntu.com/ubuntu/pool/main/b/build-essential/build-essential_12.9ubuntu3.tar.xz' build-essential_12.9ubuntu3.tar.xz 51580 SHA512:01a7e6c120b492a4223e25195a1c6d74a2a8abf4b0bc496e094509227f30824b953d64d3f2ca31493613afe17843a1c58c553998d4c491ae9244f703fe578455
```

### `dpkg` source package: `bzip2=1.0.8-5build1`

Binary Packages:

- `bzip2=1.0.8-5build1`
- `bzip2-doc=1.0.8-5build1`
- `libbz2-1.0:amd64=1.0.8-5build1`
- `libbz2-dev:amd64=1.0.8-5build1`

Licenses: (parsed from: `/usr/share/doc/bzip2/copyright`, `/usr/share/doc/bzip2-doc/copyright`, `/usr/share/doc/libbz2-1.0/copyright`, `/usr/share/doc/libbz2-dev/copyright`)

- `BSD-variant`
- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris bzip2=1.0.8-5build1
'http://archive.ubuntu.com/ubuntu/pool/main/b/bzip2/bzip2_1.0.8-5build1.dsc' bzip2_1.0.8-5build1.dsc 1860 SHA512:dfb9cd3a99f8c80a27e088b6ba7f06f50bc2bdbc61f574ed8f77d0fa58ff07fa1c34a060351fd4b601537181143dd934caadd7a00eb97aea5933febb7b61743d
'http://archive.ubuntu.com/ubuntu/pool/main/b/bzip2/bzip2_1.0.8.orig.tar.gz' bzip2_1.0.8.orig.tar.gz 810029 SHA512:083f5e675d73f3233c7930ebe20425a533feedeaaa9d8cc86831312a6581cefbe6ed0d08d2fa89be81082f2a5abdabca8b3c080bf97218a1bd59dc118a30b9f3
'http://archive.ubuntu.com/ubuntu/pool/main/b/bzip2/bzip2_1.0.8-5build1.debian.tar.bz2' bzip2_1.0.8-5build1.debian.tar.bz2 26870 SHA512:e030c257c3458d780fd0ffc6f328efd69d0e875e81acd7441a7c6651194ebded61017c96aad7c99061f93d50dfc33056abe98c9a599abc900f49d51c4a1eed6f
```

### `dpkg` source package: `ca-certificates=20240203~22.04.1`

Binary Packages:

- `ca-certificates=20240203~22.04.1`

Licenses: (parsed from: `/usr/share/doc/ca-certificates/copyright`)

- `GPL-2`
- `GPL-2+`
- `MPL-2.0`

Source:

```console
$ apt-get source -qq --print-uris ca-certificates=20240203~22.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/c/ca-certificates/ca-certificates_20240203%7e22.04.1.dsc' ca-certificates_20240203~22.04.1.dsc 1850 SHA512:af1c4a4a202eead02abba4808ce5e7b731f7e2db6b194e74ff9f5331b515213490ba63181f7ffc59f01f5bd13b7fe80519694c7ff21502cd7e2e095075896696
'http://archive.ubuntu.com/ubuntu/pool/main/c/ca-certificates/ca-certificates_20240203%7e22.04.1.tar.xz' ca-certificates_20240203~22.04.1.tar.xz 263132 SHA512:64e97c5b258dfede258dd9b447d2a1f5a43db0e70309bb4e0259b8ed9d103e1a751fb563bb4902460667385d38325945e806726aa6db8876920dff670034f3f1
```

### `dpkg` source package: `cairo=1.16.0-5ubuntu2`

Binary Packages:

- `libcairo-gobject2:amd64=1.16.0-5ubuntu2`
- `libcairo2:amd64=1.16.0-5ubuntu2`

Licenses: (parsed from: `/usr/share/doc/libcairo-gobject2/copyright`, `/usr/share/doc/libcairo2/copyright`)

- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris cairo=1.16.0-5ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/c/cairo/cairo_1.16.0-5ubuntu2.dsc' cairo_1.16.0-5ubuntu2.dsc 2880 SHA512:e9415592136e7f42794f20d8c74fed895347a95d3ffd89621440c1e12212f65083926613e87fc6ad6df8f669058dc20ad12b2e1bdee2d7a7f85ec0b7c0dd4e26
'http://archive.ubuntu.com/ubuntu/pool/main/c/cairo/cairo_1.16.0.orig.tar.xz' cairo_1.16.0.orig.tar.xz 41997432 SHA512:9eb27c4cf01c0b8b56f2e15e651f6d4e52c99d0005875546405b64f1132aed12fbf84727273f493d84056a13105e065009d89e94a8bfaf2be2649e232b82377f
'http://archive.ubuntu.com/ubuntu/pool/main/c/cairo/cairo_1.16.0-5ubuntu2.debian.tar.xz' cairo_1.16.0-5ubuntu2.debian.tar.xz 33368 SHA512:d51b6655b5ea60420bb80252fbcfe2e31cbef6242043457195eab60716b84dc9ae68eb4de95214b10a5ec6d5675891067a4940b58c2249602f0f355b9d31d8d4
```

### `dpkg` source package: `cdebconf=0.261ubuntu1`

Binary Packages:

- `libdebconfclient0:amd64=0.261ubuntu1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris cdebconf=0.261ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/c/cdebconf/cdebconf_0.261ubuntu1.dsc' cdebconf_0.261ubuntu1.dsc 2941 SHA512:18554e0d66831166d01e199612aa1cd43ed56e00995d62329f2c951143860bc413870acf71f4d0e72e228ce70e6a09c97d87750e5ada1a48beaf4b39d675084c
'http://archive.ubuntu.com/ubuntu/pool/main/c/cdebconf/cdebconf_0.261ubuntu1.tar.xz' cdebconf_0.261ubuntu1.tar.xz 297016 SHA512:6c2c8e2dccdb923ae6dc6a6b3873e6a56f6bdc4a6298c0576f60cb8d5c63bd06c4b9dac4ada4abd0d672a4e54509ad558fc9d1424a8029568d8d86cb54926390
```

### `dpkg` source package: `cluster=2.1.2-2`

Binary Packages:

- `r-cran-cluster=2.1.2-2`

Licenses: (parsed from: `/usr/share/doc/r-cran-cluster/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris cluster=2.1.2-2
'http://archive.ubuntu.com/ubuntu/pool/universe/c/cluster/cluster_2.1.2-2.dsc' cluster_2.1.2-2.dsc 1831 SHA512:e76e93465e2c79ba8ae7c245e7855b7797188f73f266be10b4889439fd55ec761726c61d8820d5844698f5ff6773fd1cf8f5cfbbfa577d4402c96cd24833d55f
'http://archive.ubuntu.com/ubuntu/pool/universe/c/cluster/cluster_2.1.2.orig.tar.gz' cluster_2.1.2.orig.tar.gz 402667 SHA512:54f4e4768106035ba0566254393bc392af66cdf9309d117a57d18ee29b93207740d38eac2a4c4db761db65a7300abdbcd2a5915a115d5b81e7f523dd7d583301
'http://archive.ubuntu.com/ubuntu/pool/universe/c/cluster/cluster_2.1.2-2.debian.tar.xz' cluster_2.1.2-2.debian.tar.xz 4300 SHA512:b6c7a8cbedd0db1ee1b316b3a1201f0a36e00d2a450f1ccaca1b86098cbdff804489649d2a81cd5044cc8ffad64b37051b4337b2bb945b7a5538ca189b82cc1a
```

### `dpkg` source package: `codetools=0.2-18-1`

Binary Packages:

- `r-cran-codetools=0.2-18-1`

Licenses: (parsed from: `/usr/share/doc/r-cran-codetools/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris codetools=0.2-18-1
'http://archive.ubuntu.com/ubuntu/pool/universe/c/codetools/codetools_0.2-18-1.dsc' codetools_0.2-18-1.dsc 1859 SHA512:ae505db73f6145756aecf3347992ae621085b9894d6bf41997d16cc5c46a21712221d4e66c447b4e538ec0f56223b73872daee81e157de6bfba4ea223bc646cc
'http://archive.ubuntu.com/ubuntu/pool/universe/c/codetools/codetools_0.2-18.orig.tar.gz' codetools_0.2-18.orig.tar.gz 38175 SHA512:daad0f377d8ae2be5dac5d3edbc8c89db1fd87c7431a60a9e4dcc07c9f60ffd4eb8f2ba12d9da9b44fb90c23eb744904f81d715996ee97fa595957b81839ee44
'http://archive.ubuntu.com/ubuntu/pool/universe/c/codetools/codetools_0.2-18-1.debian.tar.xz' codetools_0.2-18-1.debian.tar.xz 2868 SHA512:b6f61db8fe4f4d8568dba3b16dbb924a10698a43fa42459f5640f6baaa1d6fb09dd2f55e0980080e9d3b2e9d486ddb79fafcca6ca2a63df9c0609aa34f979dec
```

### `dpkg` source package: `colord=1.4.6-1`

Binary Packages:

- `libcolord2:amd64=1.4.6-1`

Licenses: (parsed from: `/usr/share/doc/libcolord2/copyright`)

- `CC0`
- `GFDL-NIV`
- `GPL-2`
- `GPL-2+`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris colord=1.4.6-1
'http://archive.ubuntu.com/ubuntu/pool/main/c/colord/colord_1.4.6-1.dsc' colord_1.4.6-1.dsc 3154 SHA512:7c50838c66bd6b681315657f2d0793cb647c3527a3bbab17838d1b6f7ee46954177d068c08fe5afb91444eb49c46f36080c626da30a87896352bd80abbcb72d4
'http://archive.ubuntu.com/ubuntu/pool/main/c/colord/colord_1.4.6.orig.tar.xz' colord_1.4.6.orig.tar.xz 1872528 SHA512:d55d3322199d0bfee74eee9e183c9246ec33e755f0144d96087acb3c43ab5a3d872086fcef9f29cdd2295be71daac703cdf90ad10bf183622fdd84347e7af123
'http://archive.ubuntu.com/ubuntu/pool/main/c/colord/colord_1.4.6.orig.tar.xz.asc' colord_1.4.6.orig.tar.xz.asc 488 SHA512:7694ba7867239f5bf4f86c74a04b5de4df171ae5642614911fab54dfec54e783af24d46b8a915d4ead4cda80bbd82d3a538a72ab45cd7ef8507c8288f3681940
'http://archive.ubuntu.com/ubuntu/pool/main/c/colord/colord_1.4.6-1.debian.tar.xz' colord_1.4.6-1.debian.tar.xz 30032 SHA512:27b3e5f4c503319d5a322cd2c7e255bbd677f71ab0c987f7241ccdc46354af7ef2706ef8f4382e32ce89a42604d69c52d40111c361fa2f28e0aeb8a0f59097b4
```

### `dpkg` source package: `coreutils=8.32-4.1ubuntu1.2`

Binary Packages:

- `coreutils=8.32-4.1ubuntu1.2`

Licenses: (parsed from: `/usr/share/doc/coreutils/copyright`)

- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris coreutils=8.32-4.1ubuntu1.2
'http://archive.ubuntu.com/ubuntu/pool/main/c/coreutils/coreutils_8.32-4.1ubuntu1.2.dsc' coreutils_8.32-4.1ubuntu1.2.dsc 2299 SHA512:e6de4621a13517800b91a5990f4506c9d3287ee94346694a1844c4dff113288a2f8eb1bc6531b74096a4125f8a69c76ee59fd300cfe3a44867c8307ce878187f
'http://archive.ubuntu.com/ubuntu/pool/main/c/coreutils/coreutils_8.32.orig.tar.xz' coreutils_8.32.orig.tar.xz 5547836 SHA512:1c8f3584efd61b4b02e7ac5db8e103b63cfb2063432caaf1e64cb2dcc56d8c657d1133bbf10bd41468d6a1f31142e6caa81d16ae68fa3e6e84075c253613a145
'http://archive.ubuntu.com/ubuntu/pool/main/c/coreutils/coreutils_8.32.orig.tar.xz.asc' coreutils_8.32.orig.tar.xz.asc 833 SHA512:9c73b35c9e8f7c2b8eff317afcb5aa3234c5f41c80d1882f3c2342906f3fdc876ae45d1256dd1b8fd3cb58c50925f3c13f93de5018626634fdca3c72c14a9acb
'http://archive.ubuntu.com/ubuntu/pool/main/c/coreutils/coreutils_8.32-4.1ubuntu1.2.debian.tar.xz' coreutils_8.32-4.1ubuntu1.2.debian.tar.xz 44868 SHA512:7718e917f8f2c5c5574e73a079ea8fd3b32bc898f2e12168dc3711dfdd896e4727283011050b80f65e60994fca49da031d70901d453612132764dca7dec99543
```

### `dpkg` source package: `cryptsetup=2:2.4.3-1ubuntu1.2`

Binary Packages:

- `libcryptsetup12:amd64=2:2.4.3-1ubuntu1.2`

Licenses: (parsed from: `/usr/share/doc/libcryptsetup12/copyright`)

- `Apache-2.0`
- `CC0`
- `CC0-1.0`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with OpenSSL exception`
- `LGPL-2.1`
- `LGPL-2.1+`
- `LGPL-2.1+ with OpenSSL exception`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris cryptsetup=2:2.4.3-1ubuntu1.2
'http://archive.ubuntu.com/ubuntu/pool/main/c/cryptsetup/cryptsetup_2.4.3-1ubuntu1.2.dsc' cryptsetup_2.4.3-1ubuntu1.2.dsc 3185 SHA512:e987bdb56425df45cd62e11e781bc2eb66ddf49c34f3aaecd7a240ebf351eb137806ab9f45b6cb5621483402f46f20626010b05874b34bdeab77f9f017b59682
'http://archive.ubuntu.com/ubuntu/pool/main/c/cryptsetup/cryptsetup_2.4.3.orig.tar.gz' cryptsetup_2.4.3.orig.tar.gz 11434956 SHA512:346893db2d0857953470c614e5808c514edd58f0c7c3fb127ce389128a69ca3821ec53d63e19131616a3598b9a373652da74fbf93de2a2662e6c9001fb486f65
'http://archive.ubuntu.com/ubuntu/pool/main/c/cryptsetup/cryptsetup_2.4.3-1ubuntu1.2.debian.tar.xz' cryptsetup_2.4.3-1ubuntu1.2.debian.tar.xz 142616 SHA512:e465388c68b8d3b8058e1a8c7ae66b878be3e75ec1ff020a0501a0cead878ef1cce058b22438f33f5fcd76843e13fc84439a3f5cb0f7adf525cab760cfe48e46
```

### `dpkg` source package: `cups=2.4.1op1-1ubuntu4.11`

Binary Packages:

- `libcups2:amd64=2.4.1op1-1ubuntu4.11`

Licenses: (parsed from: `/usr/share/doc/libcups2/copyright`)

- `Apache-2.0`
- `Apache-2.0-with-GPL2-LGPL2-Exception`
- `BSD-2-Clause`
- `BSD-2-clause`
- `FSFUL`
- `Zlib`

Source:

```console
$ apt-get source -qq --print-uris cups=2.4.1op1-1ubuntu4.11
'http://archive.ubuntu.com/ubuntu/pool/main/c/cups/cups_2.4.1op1-1ubuntu4.11.dsc' cups_2.4.1op1-1ubuntu4.11.dsc 3139 SHA512:522f95c4254ac2fed5acbefda59eaf966ef037d699088e58831f7c1774363eb7b48c741cb81bc32072cc645096404ef1432bd2f6a480813124c38c9a77960179
'http://archive.ubuntu.com/ubuntu/pool/main/c/cups/cups_2.4.1op1.orig.tar.gz' cups_2.4.1op1.orig.tar.gz 8113914 SHA512:74e83728fcc3baf709176442b26711250fd4d4ede1e81e35b02a5607711067e28cd5a05d5bc3337953f6b2236c5a429b13f3a7f1218a08a2d3c30a8c9b0d96fd
'http://archive.ubuntu.com/ubuntu/pool/main/c/cups/cups_2.4.1op1-1ubuntu4.11.debian.tar.xz' cups_2.4.1op1-1ubuntu4.11.debian.tar.xz 363868 SHA512:a1cb3a5eb8643271c7dbab6da8210135ab00a0581c2b1ac4c21fb7d6c421ce5e74a466b74af5f4adb036cbc6dac7fcb3ea6a909fb054a0dfa5ce13142c066212
```

### `dpkg` source package: `curl=7.81.0-1ubuntu1.18`

Binary Packages:

- `curl=7.81.0-1ubuntu1.18`
- `libcurl4:amd64=7.81.0-1ubuntu1.18`

Licenses: (parsed from: `/usr/share/doc/curl/copyright`, `/usr/share/doc/libcurl4/copyright`)

- `BSD-3-Clause`
- `BSD-4-Clause`
- `ISC`
- `curl`
- `other`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris curl=7.81.0-1ubuntu1.18
'http://archive.ubuntu.com/ubuntu/pool/main/c/curl/curl_7.81.0-1ubuntu1.18.dsc' curl_7.81.0-1ubuntu1.18.dsc 3143 SHA512:036207144cf45829dae73369b911b032410774d290b3dc758a685f9b1706ea03719f41a13216f2e4c7c2f4f375bc3493b34579fc2aea9a2341c35d167bf368f7
'http://archive.ubuntu.com/ubuntu/pool/main/c/curl/curl_7.81.0.orig.tar.gz' curl_7.81.0.orig.tar.gz 4188040 SHA512:e3084f0fa083f7f93eac923edbfdddb5fd0a372b94673ba9d4427a2b95508898c15ecdf63b99a1c1f6cf3215e27b06cbaa2b7073df038d43b362e586f92495d3
'http://archive.ubuntu.com/ubuntu/pool/main/c/curl/curl_7.81.0.orig.tar.gz.asc' curl_7.81.0.orig.tar.gz.asc 488 SHA512:92bc5ede831551285d67b03abe8400c609ad31c9d33e324ee5c41b92dd5c2a0245a09a396bd76807b3e44bcfef944b1e16ac266264f7b85d27cc1c072a6e82bd
'http://archive.ubuntu.com/ubuntu/pool/main/c/curl/curl_7.81.0-1ubuntu1.18.debian.tar.xz' curl_7.81.0-1ubuntu1.18.debian.tar.xz 77396 SHA512:50ca7954a46b6f3c2212d0a517ddb1d5a7d470c502a716242bcd1a85c577462695da55ba5b477fcb71d9cb410dd279b9627bf04ba054c04640d04da572625437
```

### `dpkg` source package: `cyrus-sasl2=2.1.27+dfsg2-3ubuntu1.2`

Binary Packages:

- `libsasl2-2:amd64=2.1.27+dfsg2-3ubuntu1.2`
- `libsasl2-modules-db:amd64=2.1.27+dfsg2-3ubuntu1.2`

Licenses: (parsed from: `/usr/share/doc/libsasl2-2/copyright`, `/usr/share/doc/libsasl2-modules-db/copyright`)

- `BSD-2-clause`
- `BSD-2.2-clause`
- `BSD-3-clause`
- `BSD-3-clause-JANET`
- `BSD-3-clause-PADL`
- `BSD-4-clause`
- `BSD-4-clause-UC`
- `FSFULLR`
- `GPL-3`
- `GPL-3+`
- `IBM-as-is`
- `MIT-CMU`
- `MIT-Export`
- `MIT-OpenVision`
- `OpenLDAP`
- `OpenSSL`
- `RSA-MD`
- `SSLeay`

Source:

```console
$ apt-get source -qq --print-uris cyrus-sasl2=2.1.27+dfsg2-3ubuntu1.2
'http://archive.ubuntu.com/ubuntu/pool/main/c/cyrus-sasl2/cyrus-sasl2_2.1.27%2bdfsg2-3ubuntu1.2.dsc' cyrus-sasl2_2.1.27+dfsg2-3ubuntu1.2.dsc 3626 SHA512:fc67304c71b6bf7e5097bdb080ef0973ab873ff7558d91153066820c2f7d5983260586564760d6abd04c3e3fe7b076b474ae44bc97907cc2fb2757d4ca3cfe56
'http://archive.ubuntu.com/ubuntu/pool/main/c/cyrus-sasl2/cyrus-sasl2_2.1.27%2bdfsg2.orig.tar.xz' cyrus-sasl2_2.1.27+dfsg2.orig.tar.xz 829892 SHA512:13337dfcc57ea8fec471ee0f2a0f6b58fb92907ad0899a4a8afaba957c5da302924e71c9fc4a61bbc913a4ee2ea74b05772cb26ed58d5724a312bb20a8b6a4cb
'http://archive.ubuntu.com/ubuntu/pool/main/c/cyrus-sasl2/cyrus-sasl2_2.1.27%2bdfsg2-3ubuntu1.2.debian.tar.xz' cyrus-sasl2_2.1.27+dfsg2-3ubuntu1.2.debian.tar.xz 98836 SHA512:91457b1c476fae1b407f82304e6f651053ceaa923059e185b59e2be680038c2a38aab7749004b640ba604f7fdf51eb87a45e91671077207b8b8b4319e1bf24fb
```

### `dpkg` source package: `dash=0.5.11+git20210903+057cd650a4ed-3build1`

Binary Packages:

- `dash=0.5.11+git20210903+057cd650a4ed-3build1`

Licenses: (parsed from: `/usr/share/doc/dash/copyright`)

- `BSD-3-Clause`
- `BSD-3-clause`
- `Expat`
- `FSFUL`
- `FSFULLR`
- `GPL-2`
- `GPL-2+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris dash=0.5.11+git20210903+057cd650a4ed-3build1
'http://archive.ubuntu.com/ubuntu/pool/main/d/dash/dash_0.5.11%2bgit20210903%2b057cd650a4ed-3build1.dsc' dash_0.5.11+git20210903+057cd650a4ed-3build1.dsc 1834 SHA512:380a677ef7fcd2060f7806e4e552891393adb43bfba82498d143cd2ed4fa0cc7681e573a27bcb0991025a8323f6eb8b113aa1519cf455645556fad968cd26232
'http://archive.ubuntu.com/ubuntu/pool/main/d/dash/dash_0.5.11%2bgit20210903%2b057cd650a4ed.orig.tar.xz' dash_0.5.11+git20210903+057cd650a4ed.orig.tar.xz 133320 SHA512:eced6bc60ca6ba4394a2ee65d8c6b88eca729c43e47053fc01dec5500ebe002a12f536c128c3fd821a2eb61b97e92c8a0be6d4532926479ce4b7d986be109cb7
'http://archive.ubuntu.com/ubuntu/pool/main/d/dash/dash_0.5.11%2bgit20210903%2b057cd650a4ed-3build1.debian.tar.xz' dash_0.5.11+git20210903+057cd650a4ed-3build1.debian.tar.xz 42744 SHA512:7dd5b1bcaf76d8de19ad1647862e1140de59822c25d9ab1b42423f16de1e4c606ea393adac12f16a2ce9498d8f9553b8787fc31e5f93feefe36ab84b83402e1e
```

### `dpkg` source package: `db5.3=5.3.28+dfsg1-0.8ubuntu3`

Binary Packages:

- `libdb5.3:amd64=5.3.28+dfsg1-0.8ubuntu3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris db5.3=5.3.28+dfsg1-0.8ubuntu3
'http://archive.ubuntu.com/ubuntu/pool/main/d/db5.3/db5.3_5.3.28%2bdfsg1-0.8ubuntu3.dsc' db5.3_5.3.28+dfsg1-0.8ubuntu3.dsc 2875 SHA512:8743931f44f980d7be9ae77f5ce4b14ea260b780f33c8c6da66eb2fe4dba45a9c6b93237e91e2898ae0a76754ee789d67dd4efba7111f1360cb073ba633e1389
'http://archive.ubuntu.com/ubuntu/pool/main/d/db5.3/db5.3_5.3.28%2bdfsg1.orig.tar.xz' db5.3_5.3.28+dfsg1.orig.tar.xz 19723860 SHA512:50cb87bc3f24065839ee2932e82af032b236b290ebe89983076f503c6c62c5f36ff93d7847a3f68b2b19f35088fbab5d3ac6a34553d07e8148e68e9a3f079a12
'http://archive.ubuntu.com/ubuntu/pool/main/d/db5.3/db5.3_5.3.28%2bdfsg1-0.8ubuntu3.debian.tar.xz' db5.3_5.3.28+dfsg1-0.8ubuntu3.debian.tar.xz 32028 SHA512:9034be98df6c753b5f3faee9cbd1886e3e3c3d15c5840bc1c269a5034f6bfe9c4926c20591150b543618816051be218e6f00c3602b8b4325b0fcb193ddba804c
```

### `dpkg` source package: `dbus-python=1.2.18-3build1`

Binary Packages:

- `python3-dbus=1.2.18-3build1`

Licenses: (parsed from: `/usr/share/doc/python3-dbus/copyright`)

- `AFL-2.1`
- `Expat`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris dbus-python=1.2.18-3build1
'http://archive.ubuntu.com/ubuntu/pool/main/d/dbus-python/dbus-python_1.2.18-3build1.dsc' dbus-python_1.2.18-3build1.dsc 3044 SHA512:70a184492fe13f2c11c65949a01a8d1887b1193361945a12e76c3d89cdb3dac6f3e0e3c02805af3043584d8f7c841dca6a60d8b43361de6995773fef1c12ac83
'http://archive.ubuntu.com/ubuntu/pool/main/d/dbus-python/dbus-python_1.2.18.orig.tar.gz' dbus-python_1.2.18.orig.tar.gz 578204 SHA512:72f422c59637392bd78b741b66dff2afadcc706452c3e82fdc14b1dc052a0c5cb8a85e2758d18c5cbdc08004419a0b3c16b67b99688d96307084403e72585900
'http://archive.ubuntu.com/ubuntu/pool/main/d/dbus-python/dbus-python_1.2.18.orig.tar.gz.asc' dbus-python_1.2.18.orig.tar.gz.asc 833 SHA512:5f8b0c8c1771f4e8ace9168c02f04d0e065cfa8dfdaf7e7d991232e42e0f77bef9d72c565a053ed0cee1ac75b5ab7b929fcdb88d34b21f1489107ea4847ada0a
'http://archive.ubuntu.com/ubuntu/pool/main/d/dbus-python/dbus-python_1.2.18-3build1.debian.tar.xz' dbus-python_1.2.18-3build1.debian.tar.xz 34244 SHA512:729f1f29a8b922df2b27342b6a648f161bcbfde50f3f76aa2767bf7a4344ab5b8f2d82636cf4a51b8d509719c19e78be3daaf488cc9bb97fd55447c50aa1a874
```

### `dpkg` source package: `dbus=1.12.20-2ubuntu4.1`

Binary Packages:

- `dbus=1.12.20-2ubuntu4.1`
- `dbus-user-session=1.12.20-2ubuntu4.1`
- `libdbus-1-3:amd64=1.12.20-2ubuntu4.1`

Licenses: (parsed from: `/usr/share/doc/dbus/copyright`, `/usr/share/doc/dbus-user-session/copyright`, `/usr/share/doc/libdbus-1-3/copyright`)

- `AFL-2.1`
- `AFL-2.1,`
- `BSD-3-clause`
- `BSD-3-clause-generic`
- `Expat`
- `GPL-2`
- `GPL-2+`
- `Tcl-BSDish`
- `g10-permissive`

Source:

```console
$ apt-get source -qq --print-uris dbus=1.12.20-2ubuntu4.1
'http://archive.ubuntu.com/ubuntu/pool/main/d/dbus/dbus_1.12.20-2ubuntu4.1.dsc' dbus_1.12.20-2ubuntu4.1.dsc 3271 SHA512:161aca34132f46355d230c9acfe4860a5a05b6c881dfedae682f6553ce6e48e9a1cffd38c2097e4e320afbc6594de3ef391caaa5e94eaec64a28cfa69c7b8798
'http://archive.ubuntu.com/ubuntu/pool/main/d/dbus/dbus_1.12.20.orig.tar.gz' dbus_1.12.20.orig.tar.gz 2095511 SHA512:0964683bc6859374cc94e42e1ec0cdb542cca67971c205fcba4352500b6c0891665b0718e7d85eb060c81cb82e3346c313892bc02384da300ddd306c7eef0056
'http://archive.ubuntu.com/ubuntu/pool/main/d/dbus/dbus_1.12.20-2ubuntu4.1.debian.tar.xz' dbus_1.12.20-2ubuntu4.1.debian.tar.xz 65220 SHA512:2875cc688bc37a8b5c6a4e0bbb28a0a153709d70ddf8ee264d78ba44efdd0346776df86be493e9b68526387ae97a02abc76da7672abb5ca3537891fc455d1c2f
```

### `dpkg` source package: `dconf=0.40.0-3`

Binary Packages:

- `dconf-gsettings-backend:amd64=0.40.0-3`
- `dconf-service=0.40.0-3`
- `libdconf1:amd64=0.40.0-3`

Licenses: (parsed from: `/usr/share/doc/dconf-gsettings-backend/copyright`, `/usr/share/doc/dconf-service/copyright`, `/usr/share/doc/libdconf1/copyright`)

- `GPL-3`
- `LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris dconf=0.40.0-3
'http://archive.ubuntu.com/ubuntu/pool/main/d/dconf/dconf_0.40.0-3.dsc' dconf_0.40.0-3.dsc 2630 SHA512:73b1a8c6c206a9fd09746c3403fac5005c148fd3c077d3682022331971a7c6a5deae88f4bbfa3bd95036d7e90954483f79e58c98ec4914bbc6e40fa1aa9871ed
'http://archive.ubuntu.com/ubuntu/pool/main/d/dconf/dconf_0.40.0.orig.tar.xz' dconf_0.40.0.orig.tar.xz 117764 SHA512:71396d71f24f47653181482b052fdfc63795c50c373de34e2fb93e16101745daa7e81192b79a102d5389911cea34138eedf3ac32bc80562018e8a7f31963559a
'http://archive.ubuntu.com/ubuntu/pool/main/d/dconf/dconf_0.40.0-3.debian.tar.xz' dconf_0.40.0-3.debian.tar.xz 11056 SHA512:19f9410dc62d6f68702d8ab82b8f36794c098dc7b03d0a76ae281bdac7557a77c7fdec3713b88bcca2f30bfecb306a67c30515c48b498aaa145e46822183ff0f
```

### `dpkg` source package: `debconf=1.5.79ubuntu1`

Binary Packages:

- `debconf=1.5.79ubuntu1`

Licenses: (parsed from: `/usr/share/doc/debconf/copyright`)

- `BSD-2-clause`

Source:

```console
$ apt-get source -qq --print-uris debconf=1.5.79ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/d/debconf/debconf_1.5.79ubuntu1.dsc' debconf_1.5.79ubuntu1.dsc 2077 SHA512:0aac451b347a5f6758ab2e468c25ea8061840519412210861a13ced479d5e6bb2a3abd469cb0cf68d80f1f9c4debba28501141055eb2eb1ac1701f800cdd83ba
'http://archive.ubuntu.com/ubuntu/pool/main/d/debconf/debconf_1.5.79ubuntu1.tar.xz' debconf_1.5.79ubuntu1.tar.xz 570660 SHA512:1bf6de4d1cec7475f64d9bdaa47ef6dcb3d1181bcb3b97076ec60213534aa344ca49d552fdcb5c6fde4d42c364b8242bb4880de0a787493868383e6db36f9e5f
```

### `dpkg` source package: `debianutils=5.5-1ubuntu2`

Binary Packages:

- `debianutils=5.5-1ubuntu2`

Licenses: (parsed from: `/usr/share/doc/debianutils/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris debianutils=5.5-1ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/d/debianutils/debianutils_5.5-1ubuntu2.dsc' debianutils_5.5-1ubuntu2.dsc 1667 SHA512:333b9087e56e8f9a9ab95db556783a582b2855042e3dee292767decc4e4ad366bf32b4a30e60f5000a3ccced20ec613649fcd84563dae8e552a31273b42a170b
'http://archive.ubuntu.com/ubuntu/pool/main/d/debianutils/debianutils_5.5.orig.tar.xz' debianutils_5.5.orig.tar.xz 104448 SHA512:230310428ee7c145c74bb666ae729754352295230f38ef4e22f7566970c5186d607cd827a5603a678815bd48d4a1eb2716f55c32494ec75eb665651da6a56e6a
'http://archive.ubuntu.com/ubuntu/pool/main/d/debianutils/debianutils_5.5-1ubuntu2.debian.tar.xz' debianutils_5.5-1ubuntu2.debian.tar.xz 68420 SHA512:62fca780251fdb3b434abe840683385d3187699cf0466333fc1894a225f256ab1f912e818bbb4b564b1083c2e05a7a199bb9cdcc56307e60ba68cacef72644cf
```

### `dpkg` source package: `diffutils=1:3.8-0ubuntu2`

Binary Packages:

- `diffutils=1:3.8-0ubuntu2`

Licenses: (parsed from: `/usr/share/doc/diffutils/copyright`)

- `GFDL`
- `GPL`

Source:

```console
$ apt-get source -qq --print-uris diffutils=1:3.8-0ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/d/diffutils/diffutils_3.8-0ubuntu2.dsc' diffutils_3.8-0ubuntu2.dsc 1821 SHA512:645b14680e3669261eb372ce523d8258ee65b010b4e290650f8a0a4c922a26f80ee381e3711b2bf01249d64e248c184f8898abc6e0e50cb9f64cbd647ab1f684
'http://archive.ubuntu.com/ubuntu/pool/main/d/diffutils/diffutils_3.8.orig.tar.xz' diffutils_3.8.orig.tar.xz 1585120 SHA512:279441270987e70d5ecfaf84b6285a4866929c43ec877e50f154a788858d548a8a316f2fc26ad62f7348c8d289cb29a09d06dfadce1806e3d8b4ea88c8b1aa7c
'http://archive.ubuntu.com/ubuntu/pool/main/d/diffutils/diffutils_3.8.orig.tar.xz.asc' diffutils_3.8.orig.tar.xz.asc 833 SHA512:0464ac89209411993800666b45ff90243d22fbda53bf1d71c6870d565b39cc8d9c54c141b9d297a181ce74ad8fb5313953f416bced179ff7728a52a3e9a4f5a5
'http://archive.ubuntu.com/ubuntu/pool/main/d/diffutils/diffutils_3.8-0ubuntu2.debian.tar.xz' diffutils_3.8-0ubuntu2.debian.tar.xz 11692 SHA512:fab99ca407c3b1bbc427ebf14595d540e6ad2957e9b43065005efd9d5b423e6a4d6d460cccd05faf5786193a5bf1cf46721743e580161d5004167eca15fc405b
```

### `dpkg` source package: `dpkg=1.21.1ubuntu2.3`

Binary Packages:

- `dpkg=1.21.1ubuntu2.3`
- `dpkg-dev=1.21.1ubuntu2.3`
- `libdpkg-perl=1.21.1ubuntu2.3`

Licenses: (parsed from: `/usr/share/doc/dpkg/copyright`, `/usr/share/doc/dpkg-dev/copyright`, `/usr/share/doc/libdpkg-perl/copyright`)

- `BSD-2-clause`
- `GPL-2`
- `GPL-2+`
- `public-domain-md5`
- `public-domain-s-s-d`

Source:

```console
$ apt-get source -qq --print-uris dpkg=1.21.1ubuntu2.3
'http://archive.ubuntu.com/ubuntu/pool/main/d/dpkg/dpkg_1.21.1ubuntu2.3.dsc' dpkg_1.21.1ubuntu2.3.dsc 2254 SHA512:1cbd80001036fd25817149fe11875dff0b9244cac328fdaccff12e33cd608e89c3572a8c044592e80eb8b4b29ce83a25bb9468d791e7f5a53e2f0d327d913d78
'http://archive.ubuntu.com/ubuntu/pool/main/d/dpkg/dpkg_1.21.1ubuntu2.3.tar.xz' dpkg_1.21.1ubuntu2.3.tar.xz 5017216 SHA512:c81a729a5bc7f73440eeb8c427f42691384dff7d0bd11edeaecead95b3931dd82d4ed70cac3f90befecc6ba6d3116c7a1782e455eee91fa4fe485fa625c04be7
```

### `dpkg` source package: `e2fsprogs=1.46.5-2ubuntu1.2`

Binary Packages:

- `e2fsprogs=1.46.5-2ubuntu1.2`
- `libcom-err2:amd64=1.46.5-2ubuntu1.2`
- `libext2fs2:amd64=1.46.5-2ubuntu1.2`
- `libss2:amd64=1.46.5-2ubuntu1.2`
- `logsave=1.46.5-2ubuntu1.2`

Licenses: (parsed from: `/usr/share/doc/e2fsprogs/copyright`, `/usr/share/doc/libcom-err2/copyright`, `/usr/share/doc/libext2fs2/copyright`, `/usr/share/doc/libss2/copyright`, `/usr/share/doc/logsave/copyright`)

- `GPL-2`
- `LGPL-2`

Source:

```console
$ apt-get source -qq --print-uris e2fsprogs=1.46.5-2ubuntu1.2
'http://archive.ubuntu.com/ubuntu/pool/main/e/e2fsprogs/e2fsprogs_1.46.5-2ubuntu1.2.dsc' e2fsprogs_1.46.5-2ubuntu1.2.dsc 3190 SHA512:8bf3cf7816ff7a774b03e846fcd90083083c1cd9072635d1eb45ba76c87ea8a1d9f7c5bf99f9a80ad1fed2c294425835ff801ada260b3417258d94cee3dc3758
'http://archive.ubuntu.com/ubuntu/pool/main/e/e2fsprogs/e2fsprogs_1.46.5.orig.tar.gz' e2fsprogs_1.46.5.orig.tar.gz 9530158 SHA512:1a3496cb6ac575c7a5c523cc4eede39bc77c313a6d1fea2d303fc967792d75d94e42d7821e1a61b7513509320aae4a7170506decf5753ddbd1dda9d304cc392e
'http://archive.ubuntu.com/ubuntu/pool/main/e/e2fsprogs/e2fsprogs_1.46.5.orig.tar.gz.asc' e2fsprogs_1.46.5.orig.tar.gz.asc 488 SHA512:b288fa2418a85750673743cb58faf10537e2c79a5c2ec8b0d59435316f00006424195556ccf78fa023b67b05a29cd85bf9d96c14c166847d71a1d79b189c1d05
'http://archive.ubuntu.com/ubuntu/pool/main/e/e2fsprogs/e2fsprogs_1.46.5-2ubuntu1.2.debian.tar.xz' e2fsprogs_1.46.5-2ubuntu1.2.debian.tar.xz 86604 SHA512:acb7f22a63d9c0e58d626af655cdcb6e6cfcedafdd7edbc6b7b757d1b388ee04c416db98c577a8cdf2259c46ea16a679f9be770374515b21d93bd0af66bd2a1d
```

### `dpkg` source package: `elfutils=0.186-1build1`

Binary Packages:

- `libelf1:amd64=0.186-1build1`

Licenses: (parsed from: `/usr/share/doc/libelf1/copyright`)

- `GPL-2`
- `GPL-3`
- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris elfutils=0.186-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/e/elfutils/elfutils_0.186-1build1.dsc' elfutils_0.186-1build1.dsc 2872 SHA512:a360ee37fe65b0070b700939f812892861e8e31ed610a15ea0968cbd50d4f1501feabf983793c4b533fff1448a3424c518d65ed4628f9f3f8df9b1cd14b6ee6b
'http://archive.ubuntu.com/ubuntu/pool/main/e/elfutils/elfutils_0.186.orig.tar.bz2' elfutils_0.186.orig.tar.bz2 9230491 SHA512:c9180b27ec62935f18b9431268d176f6023d1bb938731d2af6e7626ae460af6608a70ba68483aa1ec7e6cb0fa0528b661ca8b68bc4f58ea8e18af527c5950c78
'http://archive.ubuntu.com/ubuntu/pool/main/e/elfutils/elfutils_0.186-1build1.debian.tar.xz' elfutils_0.186-1build1.debian.tar.xz 37944 SHA512:679969eb0b9cf4821c580b2e320e6bfa6f01329808ecd3cde4fa3beea2d07d05cc699bb314f3ab87943742c3363016f4a6cf0236629d9d144e474275d33e32d1
```

### `dpkg` source package: `expat=2.4.7-1ubuntu0.4`

Binary Packages:

- `libexpat1:amd64=2.4.7-1ubuntu0.4`

Licenses: (parsed from: `/usr/share/doc/libexpat1/copyright`)

- `MIT`

Source:

```console
$ apt-get source -qq --print-uris expat=2.4.7-1ubuntu0.4
'http://archive.ubuntu.com/ubuntu/pool/main/e/expat/expat_2.4.7-1ubuntu0.4.dsc' expat_2.4.7-1ubuntu0.4.dsc 1962 SHA512:e6cdab825e628b38ecb908535f1cec5ac2289c53255e645b57b3269cf5deec21e3d64a802e288b0dda75dad0408c1fa8e64c921e611dcef5553e55f5fe2ddf44
'http://archive.ubuntu.com/ubuntu/pool/main/e/expat/expat_2.4.7.orig.tar.gz' expat_2.4.7.orig.tar.gz 8316374 SHA512:91bc9792c4ba1d0ad835f633d8cfa62130692f48308eea8932ec5e13a01542120561b0f255b4adc58b1adae6f83632cbabf428b5b5c0d2ac6de542478a951232
'http://archive.ubuntu.com/ubuntu/pool/main/e/expat/expat_2.4.7-1ubuntu0.4.debian.tar.xz' expat_2.4.7-1ubuntu0.4.debian.tar.xz 23076 SHA512:64348f4a3a8306c765c0cd3d1de57d484780d081d747889ff590309c8e0c30c229557d504528e29d3b48ad81bf534b7605c38e11da469c69ce48526af9b55078
```

### `dpkg` source package: `fakeroot=1.28-1ubuntu1`

Binary Packages:

- `fakeroot=1.28-1ubuntu1`
- `libfakeroot:amd64=1.28-1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/fakeroot/copyright`, `/usr/share/doc/libfakeroot/copyright`)

- `Artistic`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris fakeroot=1.28-1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/f/fakeroot/fakeroot_1.28-1ubuntu1.dsc' fakeroot_1.28-1ubuntu1.dsc 1952 SHA512:f0f4f0537e156707a1384bf2a5826a6cfb0cddcef5e1920a8a358a66b317ddfa5db78c5bd64eba89884c4391ac8f4496a2d04a9c50b9766187d0c6b9faee5a37
'http://archive.ubuntu.com/ubuntu/pool/main/f/fakeroot/fakeroot_1.28.orig.tar.gz' fakeroot_1.28.orig.tar.gz 546234 SHA512:cd55007014da5741ff336d005a80633a2f1ed856e075162acb9a4a1edd5c6d17ec74457c8a1e31edb02ae70920904c53e69365d55bd9beb7e8c6211aa8cfca8b
'http://archive.ubuntu.com/ubuntu/pool/main/f/fakeroot/fakeroot_1.28-1ubuntu1.debian.tar.xz' fakeroot_1.28-1ubuntu1.debian.tar.xz 24732 SHA512:f66a01dd4ea131f1fb6c466b57a76196c8648fd5038663a5c6dacc592d1468eb339d205e5a7f51c3d3e916864a2f7b5433c51b9f0ba620d6811ec28da5b91189
```

### `dpkg` source package: `findutils=4.8.0-1ubuntu3`

Binary Packages:

- `findutils=4.8.0-1ubuntu3`

Licenses: (parsed from: `/usr/share/doc/findutils/copyright`)

- `GFDL-1.3`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris findutils=4.8.0-1ubuntu3
'http://archive.ubuntu.com/ubuntu/pool/main/f/findutils/findutils_4.8.0-1ubuntu3.dsc' findutils_4.8.0-1ubuntu3.dsc 2064 SHA512:3f0f5195138342ce515ff83f5e653457d78158c8b871ef04002adb4cc69cab6023c71f7d1032db7032d25806c22a8ad33dbf3007018d382968863521a33af2cd
'http://archive.ubuntu.com/ubuntu/pool/main/f/findutils/findutils_4.8.0.orig.tar.xz' findutils_4.8.0.orig.tar.xz 1983096 SHA512:eaa2da304dbeb2cd659b9210ac37da1bde4cd665c12a818eca98541c5ed5cba1050641fc0c39c0a446a5a7a87a8d654df0e0e6b0cee21752ea485188c9f1071e
'http://archive.ubuntu.com/ubuntu/pool/main/f/findutils/findutils_4.8.0.orig.tar.xz.asc' findutils_4.8.0.orig.tar.xz.asc 488 SHA512:e6ea8bd9a58ac4f787a9cc7dad9f75fab9e0623e7cda463bef60651c9319574ac7c8ba06f7d33cbead0ecb8788db71eb39f50550deb066d6d6baa625b0374a45
'http://archive.ubuntu.com/ubuntu/pool/main/f/findutils/findutils_4.8.0-1ubuntu3.debian.tar.xz' findutils_4.8.0-1ubuntu3.debian.tar.xz 27716 SHA512:f0ce8b61f4e0beabad3178424c804468dc4c57f37794887954df28c36227ce77f00383903274a1995a104f9def44270070b9e033eb46d52f5aaaedb1f5883587
```

### `dpkg` source package: `fontconfig=2.13.1-4.2ubuntu5`

Binary Packages:

- `fontconfig=2.13.1-4.2ubuntu5`
- `fontconfig-config=2.13.1-4.2ubuntu5`
- `libfontconfig1:amd64=2.13.1-4.2ubuntu5`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris fontconfig=2.13.1-4.2ubuntu5
'http://archive.ubuntu.com/ubuntu/pool/main/f/fontconfig/fontconfig_2.13.1-4.2ubuntu5.dsc' fontconfig_2.13.1-4.2ubuntu5.dsc 2449 SHA512:7d56f8d3b7f211ad464d20ed07b02cf38b0c10df1aa00ca8e899a734908b3342b1d67e32107231f983e473f64366444f06adb3b9c72cc2c2693aed427dda5114
'http://archive.ubuntu.com/ubuntu/pool/main/f/fontconfig/fontconfig_2.13.1.orig.tar.bz2' fontconfig_2.13.1.orig.tar.bz2 1723639 SHA512:f97f2a9db294fd72d416a7d76dd7db5934ade2cf76903764b09e7decc33e0e2eed1a1d35c5f1c7fd9ea39e2c7653b9e65365f0c6205e047e95e38ba5000dd100
'http://archive.ubuntu.com/ubuntu/pool/main/f/fontconfig/fontconfig_2.13.1-4.2ubuntu5.debian.tar.xz' fontconfig_2.13.1-4.2ubuntu5.debian.tar.xz 28084 SHA512:6321dd705cc0adb9330778675f4ee3545d7f22f1ec63439dab45592dda121c2c5f1b4aa8ae444db1151906c5e1f363f13f38075733649b543e4d5bf5222c0eed
```

### `dpkg` source package: `fonts-dejavu=2.37-2build1`

Binary Packages:

- `fonts-dejavu-core=2.37-2build1`

Licenses: (parsed from: `/usr/share/doc/fonts-dejavu-core/copyright`)

- `GPL-2`
- `GPL-2+`
- `bitstream-vera`

Source:

```console
$ apt-get source -qq --print-uris fonts-dejavu=2.37-2build1
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-dejavu/fonts-dejavu_2.37-2build1.dsc' fonts-dejavu_2.37-2build1.dsc 2411 SHA512:7821679b0f3cabaa4929b11a1a02fff21c05cef965efc399bf8a89b8549b1ac20cdd173c2cb31c397a345683b197623b97998b412c8458a135141ccd733b50d9
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-dejavu/fonts-dejavu_2.37.orig.tar.bz2' fonts-dejavu_2.37.orig.tar.bz2 12050109 SHA512:e61fc8c675ef76edb49dd9a8caee62087280929bb8144b52aca2f8def30025c56246589ad8a6a806b9574e6876eedd16d57c70a6ce9c86817a2dfe39d8a2bb2b
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-dejavu/fonts-dejavu_2.37-2build1.debian.tar.xz' fonts-dejavu_2.37-2build1.debian.tar.xz 11468 SHA512:b3c0cb3c81b3e4e9d76eefab010f447be973fa9e310960d2e3a1a2e845f4388e0508f8d18d519c7374c68c96c2e05a75f29ccf24135f6250a82181a77d8e9741
```

### `dpkg` source package: `foreign=0.8.82-1`

Binary Packages:

- `r-cran-foreign=0.8.82-1`

Licenses: (parsed from: `/usr/share/doc/r-cran-foreign/copyright`)

- `GPL`
- `GPL `

Source:

```console
$ apt-get source -qq --print-uris foreign=0.8.82-1
'http://archive.ubuntu.com/ubuntu/pool/universe/f/foreign/foreign_0.8.82-1.dsc' foreign_0.8.82-1.dsc 1838 SHA512:97315da4e3ab42a2ab3b70776e83542e303111902b6a1dd122542884b1b6a13c5b4682d2faaad6bbf508da6a8f592584e77ce7cfc7580a726bf9288a567fe035
'http://archive.ubuntu.com/ubuntu/pool/universe/f/foreign/foreign_0.8.82.orig.tar.gz' foreign_0.8.82.orig.tar.gz 361598 SHA512:515484cc4d4825bac829b802d21617313196c674406dd0b6cc91d26f26a34fafbac52514a9a17b127ad9abc19918afe9c3152b7266acee52d1c93922c6f4f35b
'http://archive.ubuntu.com/ubuntu/pool/universe/f/foreign/foreign_0.8.82-1.debian.tar.xz' foreign_0.8.82-1.debian.tar.xz 4288 SHA512:19707b812dbe25c66488b291e4273f0ce9ee04b727836346219c8397a9a673c2f6f4a8451eaa284bb4ef594d461a8d210df8baae551a12c95132874f65f6ae9e
```

### `dpkg` source package: `freetype=2.11.1+dfsg-1ubuntu0.2`

Binary Packages:

- `libfreetype6:amd64=2.11.1+dfsg-1ubuntu0.2`

Licenses: (parsed from: `/usr/share/doc/libfreetype6/copyright`)

- `BSD-3-Clause`
- `BSL-1.0`
- `FSFAP`
- `FTL`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `MIT`
- `OpenGroup-BSD-like`
- `Public-Domain`
- `Zlib`

Source:

```console
$ apt-get source -qq --print-uris freetype=2.11.1+dfsg-1ubuntu0.2
'http://archive.ubuntu.com/ubuntu/pool/main/f/freetype/freetype_2.11.1%2bdfsg-1ubuntu0.2.dsc' freetype_2.11.1+dfsg-1ubuntu0.2.dsc 3791 SHA512:643a9c86c6d1d8e9b41dc168688516dfe57bc365298e5b42c52f10cbbbf1d3372c9648f8b207bd211fd5ee69e7cb946bf5f6c804c5d8fbc3a428a0d96f178929
'http://archive.ubuntu.com/ubuntu/pool/main/f/freetype/freetype_2.11.1%2bdfsg.orig-ft2demos.tar.xz' freetype_2.11.1+dfsg.orig-ft2demos.tar.xz 257240 SHA512:93d68daefa8a49b4fc987a7356133299fe2a8e012415ea09ad7616ececcfd978fdf9fc7a2d855f7488f51a497d019acb89ef5774484babae66357b3083a883c5
'http://archive.ubuntu.com/ubuntu/pool/main/f/freetype/freetype_2.11.1%2bdfsg.orig-ft2demos.tar.xz.asc' freetype_2.11.1+dfsg.orig-ft2demos.tar.xz.asc 195 SHA512:407ffade07cc62c8838d26670dffc7c26b9baf4984c42b2b2467279dabda855536b403f5a7e9dc64a787163657ca81019fef6d1879973faf180d6230ab17cd05
'http://archive.ubuntu.com/ubuntu/pool/main/f/freetype/freetype_2.11.1%2bdfsg.orig-ft2docs.tar.xz' freetype_2.11.1+dfsg.orig-ft2docs.tar.xz 2038348 SHA512:c5e19d98425491682edc58230c48390925cc4b466169f655cf3b8575ba787a70feecdeb7a16224b132dcc32f17b041483d84056cda8e3132d98b531e46a26c36
'http://archive.ubuntu.com/ubuntu/pool/main/f/freetype/freetype_2.11.1%2bdfsg.orig-ft2docs.tar.xz.asc' freetype_2.11.1+dfsg.orig-ft2docs.tar.xz.asc 195 SHA512:df946695a1fbaa71009f48a8f0860177984728ec1c73385d1e55c07be027dd6a5e634c9dcbb49c51f8143b0d56a6cbf06393403341fb28cea7a8a2cc9a9c5592
'http://archive.ubuntu.com/ubuntu/pool/main/f/freetype/freetype_2.11.1%2bdfsg.orig.tar.xz' freetype_2.11.1+dfsg.orig.tar.xz 1988020 SHA512:6a9a0379679abf127761cabb2da39b8faf2ca4c322075da9b86d93363ac81ce909b9544377a784118ba91ca008baa680b9da474bd2da1bfe928d5a4c9114cb08
'http://archive.ubuntu.com/ubuntu/pool/main/f/freetype/freetype_2.11.1%2bdfsg-1ubuntu0.2.debian.tar.xz' freetype_2.11.1+dfsg-1ubuntu0.2.debian.tar.xz 41920 SHA512:5ebb72c4c47997c74da26fe13b796a558f7b4e2075743a55ba6a0079cd30c713aac3499ddbb05f6cbf408d383028743b41d9839531c906bf41d5ad725c9d5b04
```

### `dpkg` source package: `fribidi=1.0.8-2ubuntu3.1`

Binary Packages:

- `libfribidi0:amd64=1.0.8-2ubuntu3.1`

Licenses: (parsed from: `/usr/share/doc/libfribidi0/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris fribidi=1.0.8-2ubuntu3.1
'http://archive.ubuntu.com/ubuntu/pool/main/f/fribidi/fribidi_1.0.8-2ubuntu3.1.dsc' fribidi_1.0.8-2ubuntu3.1.dsc 2442 SHA512:977cb7df4e1877f0f6d5f58620cfacbb1e25090c2bfd70c71576ada3c9f11f260ed11fb0fd64a5f5bf8cfc8c419a865e0e9b9084f224deb9dfadf1b2e3bd17e9
'http://archive.ubuntu.com/ubuntu/pool/main/f/fribidi/fribidi_1.0.8.orig.tar.bz2' fribidi_1.0.8.orig.tar.bz2 2077095 SHA512:d66b1524b26d227fd6a628f438efb875c023ae3be708acaaad11f1f62d0902de0a5f57124458291ef2b0fcd89356c52ab8ae5559b0b5a93fa435b92f1d098ba2
'http://archive.ubuntu.com/ubuntu/pool/main/f/fribidi/fribidi_1.0.8-2ubuntu3.1.debian.tar.xz' fribidi_1.0.8-2ubuntu3.1.debian.tar.xz 10888 SHA512:16e448db2038b60b3a086117774e734b1d3ed08ae09cfa1b591f5a95c6372778705ba8940dd464537d5a6e932528c1c1e01376670992580529090f20142d171a
```

### `dpkg` source package: `gcc-11=11.4.0-1ubuntu1~22.04`

Binary Packages:

- `cpp-11=11.4.0-1ubuntu1~22.04`
- `g++-11=11.4.0-1ubuntu1~22.04`
- `gcc-11=11.4.0-1ubuntu1~22.04`
- `gcc-11-base:amd64=11.4.0-1ubuntu1~22.04`
- `gfortran-11=11.4.0-1ubuntu1~22.04`
- `libasan6:amd64=11.4.0-1ubuntu1~22.04`
- `libgcc-11-dev:amd64=11.4.0-1ubuntu1~22.04`
- `libgfortran-11-dev:amd64=11.4.0-1ubuntu1~22.04`
- `libstdc++-11-dev:amd64=11.4.0-1ubuntu1~22.04`
- `libtsan0:amd64=11.4.0-1ubuntu1~22.04`

Licenses: (parsed from: `/usr/share/doc/cpp-11/copyright`, `/usr/share/doc/g++-11/copyright`, `/usr/share/doc/gcc-11/copyright`, `/usr/share/doc/gcc-11-base/copyright`, `/usr/share/doc/gfortran-11/copyright`, `/usr/share/doc/libasan6/copyright`, `/usr/share/doc/libgcc-11-dev/copyright`, `/usr/share/doc/libgfortran-11-dev/copyright`, `/usr/share/doc/libstdc++-11-dev/copyright`, `/usr/share/doc/libtsan0/copyright`)

- `Artistic`
- `GFDL-1.2`
- `GPL`
- `GPL-2`
- `GPL-3`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris gcc-11=11.4.0-1ubuntu1~22.04
'http://archive.ubuntu.com/ubuntu/pool/main/g/gcc-11/gcc-11_11.4.0-1ubuntu1%7e22.04.dsc' gcc-11_11.4.0-1ubuntu1~22.04.dsc 22841 SHA512:c463147bafb00dad7d46fcf92a732be9c278e8ffc8e8bc4eca42f5e6f4f1cae3cfd710693315a60f3cd0215e65522a0dfb278099bfeb3f53faf7663a19c50e1f
'http://archive.ubuntu.com/ubuntu/pool/main/g/gcc-11/gcc-11_11.4.0.orig.tar.gz' gcc-11_11.4.0.orig.tar.gz 86949353 SHA512:c6fd2066dd230c7b4d4db75bb414dca062eb7f0565c8ea531183a51abd75c229ac0badeb5a959a09fc1a35de4ce5282cdb8142fe356f567da1fa50b1525983a5
'http://archive.ubuntu.com/ubuntu/pool/main/g/gcc-11/gcc-11_11.4.0-1ubuntu1%7e22.04.debian.tar.xz' gcc-11_11.4.0-1ubuntu1~22.04.debian.tar.xz 543736 SHA512:b9b308246cfa23294c3d65968e505e9d6cc74a428dbd37e761051ec2005388b226e4719ecfb21f9e74c90e29d95afce40c5b750832cb95f43ce8aa60bd6990c6
```

### `dpkg` source package: `gcc-12=12.3.0-1ubuntu1~22.04`

Binary Packages:

- `gcc-12-base:amd64=12.3.0-1ubuntu1~22.04`
- `libatomic1:amd64=12.3.0-1ubuntu1~22.04`
- `libcc1-0:amd64=12.3.0-1ubuntu1~22.04`
- `libgcc-s1:amd64=12.3.0-1ubuntu1~22.04`
- `libgfortran5:amd64=12.3.0-1ubuntu1~22.04`
- `libgomp1:amd64=12.3.0-1ubuntu1~22.04`
- `libitm1:amd64=12.3.0-1ubuntu1~22.04`
- `liblsan0:amd64=12.3.0-1ubuntu1~22.04`
- `libquadmath0:amd64=12.3.0-1ubuntu1~22.04`
- `libstdc++6:amd64=12.3.0-1ubuntu1~22.04`
- `libubsan1:amd64=12.3.0-1ubuntu1~22.04`

Licenses: (parsed from: `/usr/share/doc/gcc-12-base/copyright`, `/usr/share/doc/libatomic1/copyright`, `/usr/share/doc/libcc1-0/copyright`, `/usr/share/doc/libgcc-s1/copyright`, `/usr/share/doc/libgfortran5/copyright`, `/usr/share/doc/libgomp1/copyright`, `/usr/share/doc/libitm1/copyright`, `/usr/share/doc/liblsan0/copyright`, `/usr/share/doc/libquadmath0/copyright`, `/usr/share/doc/libstdc++6/copyright`, `/usr/share/doc/libubsan1/copyright`)

- `Artistic`
- `GFDL-1.2`
- `GPL`
- `GPL-2`
- `GPL-3`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris gcc-12=12.3.0-1ubuntu1~22.04
'http://archive.ubuntu.com/ubuntu/pool/main/g/gcc-12/gcc-12_12.3.0-1ubuntu1%7e22.04.dsc' gcc-12_12.3.0-1ubuntu1~22.04.dsc 27867 SHA512:68c0860bb1f453ad06334504034c575bed05512ef2a94599e8bbf57a25ed51dc9a429f4646848c8d98e0d4695f1319fac5d5ebbee3a0f8eecdb279b75936a875
'http://archive.ubuntu.com/ubuntu/pool/main/g/gcc-12/gcc-12_12.3.0.orig.tar.gz' gcc-12_12.3.0.orig.tar.gz 91555468 SHA512:a33ce506594e13cf96f0419e6d62b71f8906c87c69426218bf8679d281865f1b170bc2f7379216ae1d6ad9f6bdbf5819c34c65c7537fdb74179c27b0d4ab7b48
'http://archive.ubuntu.com/ubuntu/pool/main/g/gcc-12/gcc-12_12.3.0-1ubuntu1%7e22.04.debian.tar.xz' gcc-12_12.3.0-1ubuntu1~22.04.debian.tar.xz 575908 SHA512:d1bf37d9af699430d3b107d0966194b20aef22654337efdb99971b270609785020dd1f04ce6a0f3f3eb0dbad704b46e9d9e5dfa6a497e98c78a867f5bc290038
```

### `dpkg` source package: `gcc-defaults=1.193ubuntu1`

Binary Packages:

- `cpp=4:11.2.0-1ubuntu1`
- `g++=4:11.2.0-1ubuntu1`
- `gcc=4:11.2.0-1ubuntu1`
- `gfortran=4:11.2.0-1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/cpp/copyright`, `/usr/share/doc/g++/copyright`, `/usr/share/doc/gcc/copyright`, `/usr/share/doc/gfortran/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris gcc-defaults=1.193ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/g/gcc-defaults/gcc-defaults_1.193ubuntu1.dsc' gcc-defaults_1.193ubuntu1.dsc 14438 SHA512:ac90c126ec51cce73c134d24517c1dfe378d214ad6ee5c3edc119fec33c52485dd880994b29e7b787b2eea1cf761564b721044c903bea7deae2edc9031d3d8ed
'http://archive.ubuntu.com/ubuntu/pool/main/g/gcc-defaults/gcc-defaults_1.193ubuntu1.tar.xz' gcc-defaults_1.193ubuntu1.tar.xz 48128 SHA512:62cf8f5b9aa4b2200cb037d18556c532178e9698f8502b53dd5a71bc9dfdab7314bda56d5384974fa4f9c23c16567c26ee966b5c3562d819507579932fb983a3
```

### `dpkg` source package: `gdbm=1.23-1`

Binary Packages:

- `libgdbm-compat4:amd64=1.23-1`
- `libgdbm6:amd64=1.23-1`

Licenses: (parsed from: `/usr/share/doc/libgdbm-compat4/copyright`, `/usr/share/doc/libgdbm6/copyright`)

- `GFDL-NIV-1.3+`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris gdbm=1.23-1
'http://archive.ubuntu.com/ubuntu/pool/main/g/gdbm/gdbm_1.23-1.dsc' gdbm_1.23-1.dsc 2583 SHA512:f931348ff659e5f9485fe92734b02c426b6428e41e2abc180b131183e8ca437c5287a7f88854f788e5111efbed114b5eda2b66c24318b39e88661ddbbb39ce15
'http://archive.ubuntu.com/ubuntu/pool/main/g/gdbm/gdbm_1.23.orig.tar.gz' gdbm_1.23.orig.tar.gz 1115854 SHA512:918080cb0225b221c11eb7339634a95e00c526072395f7a3d46ccf42ef020dea7c4c5bec34aff2c4f16033e1fff6583252b7e978f68b8d7f8736b0e025838e10
'http://archive.ubuntu.com/ubuntu/pool/main/g/gdbm/gdbm_1.23.orig.tar.gz.asc' gdbm_1.23.orig.tar.gz.asc 181 SHA512:6653751c04584f10aa3325bd1cb5b9f7970a786dd2a99602ea620c11a86a9ba5c342aa52627bd06c03da822e9e1600dc034d9a8f42856a287fd67f6b9f161c71
'http://archive.ubuntu.com/ubuntu/pool/main/g/gdbm/gdbm_1.23-1.debian.tar.xz' gdbm_1.23-1.debian.tar.xz 18484 SHA512:e7ca0a608da94e5b5bc5949e27b794c87e032202eb09359ad55f6c1a7a6e895f01126781a4e0fbfdb8fef3de7c4a312b9d5a653aaf55ce8c5afbceb945945253
```

### `dpkg` source package: `gdk-pixbuf=2.42.8+dfsg-1ubuntu0.3`

Binary Packages:

- `libgdk-pixbuf-2.0-0:amd64=2.42.8+dfsg-1ubuntu0.3`
- `libgdk-pixbuf2.0-bin=2.42.8+dfsg-1ubuntu0.3`
- `libgdk-pixbuf2.0-common=2.42.8+dfsg-1ubuntu0.3`

Licenses: (parsed from: `/usr/share/doc/libgdk-pixbuf-2.0-0/copyright`, `/usr/share/doc/libgdk-pixbuf2.0-bin/copyright`, `/usr/share/doc/libgdk-pixbuf2.0-common/copyright`)

- `CC0-1.0`
- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris gdk-pixbuf=2.42.8+dfsg-1ubuntu0.3
'http://archive.ubuntu.com/ubuntu/pool/main/g/gdk-pixbuf/gdk-pixbuf_2.42.8%2bdfsg-1ubuntu0.3.dsc' gdk-pixbuf_2.42.8+dfsg-1ubuntu0.3.dsc 3104 SHA512:996a28f2032a3859e55ae4dbd03efa8fdebf25d0c38b69c45ddb7ad2763b53695dfa3b14e7e32d6764d726fe287e153914311f7102a32e860a582b6376e021a3
'http://archive.ubuntu.com/ubuntu/pool/main/g/gdk-pixbuf/gdk-pixbuf_2.42.8%2bdfsg.orig.tar.xz' gdk-pixbuf_2.42.8+dfsg.orig.tar.xz 6439548 SHA512:d77093ac4bd5c8f9a5267e67958dd99db009e16f94c44be95a547cd291b6d03fcc35c4a02327dd9f4341af1ae2ecdaa6a1bec02dcf1116ec5a440d22b3f68924
'http://archive.ubuntu.com/ubuntu/pool/main/g/gdk-pixbuf/gdk-pixbuf_2.42.8%2bdfsg-1ubuntu0.3.debian.tar.xz' gdk-pixbuf_2.42.8+dfsg-1ubuntu0.3.debian.tar.xz 28780 SHA512:8b8235c8de2334db8a0304c1e949970359bab2d95562ba7bb1fcf78ce058d51c225a3f96b69802dcbe84c3f01daacf8ee58c0f0b060a91da42e844ff891fec23
```

### `dpkg` source package: `glib2.0=2.72.4-0ubuntu2.3`

Binary Packages:

- `libglib2.0-0:amd64=2.72.4-0ubuntu2.3`
- `libglib2.0-data=2.72.4-0ubuntu2.3`

Licenses: (parsed from: `/usr/share/doc/libglib2.0-0/copyright`, `/usr/share/doc/libglib2.0-data/copyright`)

- `Expat`
- `GPL-2+`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris glib2.0=2.72.4-0ubuntu2.3
'http://archive.ubuntu.com/ubuntu/pool/main/g/glib2.0/glib2.0_2.72.4-0ubuntu2.3.dsc' glib2.0_2.72.4-0ubuntu2.3.dsc 3670 SHA512:bea1f5359cdfc0cf6403812b87263221523a54e50726fa7a2232e08f0eda35e3e23c6b98d1a978bfe141fc9a50732a335e5f7570489dafd042038f4ed2534f1e
'http://archive.ubuntu.com/ubuntu/pool/main/g/glib2.0/glib2.0_2.72.4.orig.tar.xz' glib2.0_2.72.4.orig.tar.xz 4884256 SHA512:b4e2e0985e2184ee9656c4f1b4e15d8d1264f3d23d31349bc43d92e8432cffa48e1685c40517efb08dc5b57b8285acf65f2747deeb50e50d9cacec7160e7edf8
'http://archive.ubuntu.com/ubuntu/pool/main/g/glib2.0/glib2.0_2.72.4-0ubuntu2.3.debian.tar.xz' glib2.0_2.72.4-0ubuntu2.3.debian.tar.xz 146736 SHA512:0c94042cdadf2ead450f5bc97e06fd503e4954488d423f08280a050098d3a7a4203640f7e677d2d567d5d44b73ec94d297d77ffb8d3452bb947b78c87c9d8221
```

### `dpkg` source package: `glibc=2.35-0ubuntu3.8`

Binary Packages:

- `libc-bin=2.35-0ubuntu3.8`
- `libc-dev-bin=2.35-0ubuntu3.8`
- `libc-devtools=2.35-0ubuntu3.8`
- `libc6:amd64=2.35-0ubuntu3.8`
- `libc6-dev:amd64=2.35-0ubuntu3.8`
- `locales=2.35-0ubuntu3.8`

Licenses: (parsed from: `/usr/share/doc/libc-bin/copyright`, `/usr/share/doc/libc-dev-bin/copyright`, `/usr/share/doc/libc-devtools/copyright`, `/usr/share/doc/libc6/copyright`, `/usr/share/doc/libc6-dev/copyright`, `/usr/share/doc/locales/copyright`)

- `GFDL-1.3`
- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris glibc=2.35-0ubuntu3.8
'http://archive.ubuntu.com/ubuntu/pool/main/g/glibc/glibc_2.35-0ubuntu3.8.dsc' glibc_2.35-0ubuntu3.8.dsc 8917 SHA512:65d4e9f4ff2556677cf3b723560d89d889754f7c49af563e25e7bd1e7e1b211c4008e149d1b889a626d19b0a001050fd84ffe05f3ede4a6b03fd759e2c60c3b9
'http://archive.ubuntu.com/ubuntu/pool/main/g/glibc/glibc_2.35.orig.tar.xz' glibc_2.35.orig.tar.xz 18165952 SHA512:e7336ce27561be5d7c217832a1136fb327e057bd8d3f92925b35c97e3e9f9e486948b5a1e03e5e4090772ef06437a074d10b82e68f17f1ad8f22077ee39e1b66
'http://archive.ubuntu.com/ubuntu/pool/main/g/glibc/glibc_2.35.orig.tar.xz.asc' glibc_2.35.orig.tar.xz.asc 833 SHA512:2a1c152511dac05f9b4e48f7e7a6b59dbf2d8b71fea54f128173113357be26e86216e13c9865f617049e6858396a221a5abc704f65a786b22453945fd80265e9
'http://archive.ubuntu.com/ubuntu/pool/main/g/glibc/glibc_2.35-0ubuntu3.8.debian.tar.xz' glibc_2.35-0ubuntu3.8.debian.tar.xz 937424 SHA512:4bd814571a66097dd9bf9c87c62ca9ea9e29b3a9c193be6b7a1dc25cf672641addce7c100e95e86d6fb4e4ee6f88eb847e6766285b60c6953587789d05f48abd
```

### `dpkg` source package: `gmp=2:6.2.1+dfsg-3ubuntu1`

Binary Packages:

- `libgmp10:amd64=2:6.2.1+dfsg-3ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libgmp10/copyright`)

- `GPL`
- `GPL-2`
- `GPL-3`
- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris gmp=2:6.2.1+dfsg-3ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/g/gmp/gmp_6.2.1%2bdfsg-3ubuntu1.dsc' gmp_6.2.1+dfsg-3ubuntu1.dsc 2355 SHA512:b41211a64cba1afee1ea7924d38581b26b36f0495ad42be6d25b7175d5fa1e000378a5d36dd80087b0e7d4495620edb1e7e1b32d6c1085a8cdf0a4cb460a0558
'http://archive.ubuntu.com/ubuntu/pool/main/g/gmp/gmp_6.2.1%2bdfsg.orig.tar.xz' gmp_6.2.1+dfsg.orig.tar.xz 1853476 SHA512:801948b7dcf592959ea387a86bee34dfb4e02c5e93815a785fc46174899ba22129853a3e34109a6df86048a144765c5f39e65fddfcecba879cc60da62f32fea0
'http://archive.ubuntu.com/ubuntu/pool/main/g/gmp/gmp_6.2.1%2bdfsg-3ubuntu1.debian.tar.xz' gmp_6.2.1+dfsg-3ubuntu1.debian.tar.xz 40996 SHA512:d7e0a1165a42b11a26a0f9232193db41ce2e7b1f5ea50d258e156fc9d80f9a74b6739491ec73cc1e909a3d09e029f90c3be1460c993690c5081ef8c6a169a4c3
```

### `dpkg` source package: `gnupg2=2.2.27-3ubuntu2.1`

Binary Packages:

- `dirmngr=2.2.27-3ubuntu2.1`
- `gnupg=2.2.27-3ubuntu2.1`
- `gnupg-l10n=2.2.27-3ubuntu2.1`
- `gnupg-utils=2.2.27-3ubuntu2.1`
- `gnupg2=2.2.27-3ubuntu2.1`
- `gpg=2.2.27-3ubuntu2.1`
- `gpg-agent=2.2.27-3ubuntu2.1`
- `gpg-wks-client=2.2.27-3ubuntu2.1`
- `gpg-wks-server=2.2.27-3ubuntu2.1`
- `gpgconf=2.2.27-3ubuntu2.1`
- `gpgsm=2.2.27-3ubuntu2.1`
- `gpgv=2.2.27-3ubuntu2.1`

Licenses: (parsed from: `/usr/share/doc/dirmngr/copyright`, `/usr/share/doc/gnupg/copyright`, `/usr/share/doc/gnupg-l10n/copyright`, `/usr/share/doc/gnupg-utils/copyright`, `/usr/share/doc/gnupg2/copyright`, `/usr/share/doc/gpg/copyright`, `/usr/share/doc/gpg-agent/copyright`, `/usr/share/doc/gpg-wks-client/copyright`, `/usr/share/doc/gpg-wks-server/copyright`, `/usr/share/doc/gpgconf/copyright`, `/usr/share/doc/gpgsm/copyright`, `/usr/share/doc/gpgv/copyright`)

- `BSD-3-clause`
- `CC0-1.0`
- `Expat`
- `GPL-3`
- `GPL-3+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `LGPL-3`
- `LGPL-3+`
- `RFC-Reference`
- `TinySCHEME`
- `permissive`

Source:

```console
$ apt-get source -qq --print-uris gnupg2=2.2.27-3ubuntu2.1
'http://archive.ubuntu.com/ubuntu/pool/main/g/gnupg2/gnupg2_2.2.27-3ubuntu2.1.dsc' gnupg2_2.2.27-3ubuntu2.1.dsc 3726 SHA512:ed001ea6507654af663bfb1bfc051cd8a2deb9b8bb5b16273f7c3aa82141bdbc1cb2e85bf0cb61a26ea474f0df43e9a34c687722f757ed99bbd86b9a08866744
'http://archive.ubuntu.com/ubuntu/pool/main/g/gnupg2/gnupg2_2.2.27.orig.tar.bz2' gnupg2_2.2.27.orig.tar.bz2 7191555 SHA512:cf336962116c9c08ac80b1299654b94948033ef51d6d5e7f54c2f07bbf7d92c7b0bddb606ceee2cdd837063f519b8d59af5a82816b840a0fc47d90c07b0e95ab
'http://archive.ubuntu.com/ubuntu/pool/main/g/gnupg2/gnupg2_2.2.27-3ubuntu2.1.debian.tar.xz' gnupg2_2.2.27-3ubuntu2.1.debian.tar.xz 66676 SHA512:6f8aea12b515ef1b8558ac925bb84ae6f1743739c0edfc64e02952479d4a1271f8f6ee8fc23461164116f3f8396376009ed1ea609c55a59e4936f7d02b1f828a
```

### `dpkg` source package: `gnutls28=3.7.3-4ubuntu1.5`

Binary Packages:

- `libgnutls30:amd64=3.7.3-4ubuntu1.5`

Licenses: (parsed from: `/usr/share/doc/libgnutls30/copyright`)

- `Apache-2.0`
- `BSD-3-Clause`
- `CC0 license`
- `Expat`
- `GFDL-1.3`
- `GPL`
- `GPL-3`
- `GPLv3+`
- `LGPL`
- `LGPL-3`
- `LGPLv2.1+`
- `LGPLv3+_or_GPLv2+`
- `The main library is licensed under GNU Lesser`

Source:

```console
$ apt-get source -qq --print-uris gnutls28=3.7.3-4ubuntu1.5
'http://archive.ubuntu.com/ubuntu/pool/main/g/gnutls28/gnutls28_3.7.3-4ubuntu1.5.dsc' gnutls28_3.7.3-4ubuntu1.5.dsc 3572 SHA512:0a38fab364da93670bcdcdca4638301cf7bf9ec3f6a2969ceb07c3bdd9483c1898fc75c9a0c30087dfa4507266327c18240ce2448d866ca47ede6d2d944a4581
'http://archive.ubuntu.com/ubuntu/pool/main/g/gnutls28/gnutls28_3.7.3.orig.tar.xz' gnutls28_3.7.3.orig.tar.xz 6119292 SHA512:3ace744affe23e284342658d6d2d2de49dd50065489cbc8be18fc7d38187253e5268ca54027ce5cd517056c249ac039a7481e4548cec04325de37ae85617d077
'http://archive.ubuntu.com/ubuntu/pool/main/g/gnutls28/gnutls28_3.7.3.orig.tar.xz.asc' gnutls28_3.7.3.orig.tar.xz.asc 833 SHA512:cd0d30298377deddf20a835863b71e3f119588061f659906ad2684004758943179531508b1c77c730e930e2131148095e60ad9be365353cce772472d5f5345df
'http://archive.ubuntu.com/ubuntu/pool/main/g/gnutls28/gnutls28_3.7.3-4ubuntu1.5.debian.tar.xz' gnutls28_3.7.3-4ubuntu1.5.debian.tar.xz 88576 SHA512:aab7435e49efb1d7b8e4dd84c9fec9a9e68d56b6b78e95de9accfc7d3ec390ed397014374e22a86d0a193f01e8eba5bf46c85ef37c1794b51c673f3582fe2e35
```

### `dpkg` source package: `gobject-introspection=1.72.0-1`

Binary Packages:

- `gir1.2-glib-2.0:amd64=1.72.0-1`
- `libgirepository-1.0-1:amd64=1.72.0-1`

Licenses: (parsed from: `/usr/share/doc/gir1.2-glib-2.0/copyright`, `/usr/share/doc/libgirepository-1.0-1/copyright`)

- `BSD-2-clause`
- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2+`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris gobject-introspection=1.72.0-1
'http://archive.ubuntu.com/ubuntu/pool/main/g/gobject-introspection/gobject-introspection_1.72.0-1.dsc' gobject-introspection_1.72.0-1.dsc 3197 SHA512:5ab663d2ffbd50e238c970808f8893c5d9de42b47d9b56c46e424135f85e6bbb43aab7a1e3a8737bea71e38c946cea469c482f148e96c236a6a784bcf76626a7
'http://archive.ubuntu.com/ubuntu/pool/main/g/gobject-introspection/gobject-introspection_1.72.0.orig.tar.xz' gobject-introspection_1.72.0.orig.tar.xz 1040936 SHA512:b8fba2bd12e93776c55228acf3487bef36ee40b1abdc7f681b827780ac94a8bfa1f59b0c30d60fa5a1fea2f610de78b9e52029f411128067808f17eb6374cdc5
'http://archive.ubuntu.com/ubuntu/pool/main/g/gobject-introspection/gobject-introspection_1.72.0-1.debian.tar.xz' gobject-introspection_1.72.0-1.debian.tar.xz 25752 SHA512:ea95a4876d73e31b87ebd869b7a1a12029f6c7205448b46b6452a0731338a1b5fe5adc724675dad8e57bca94e4b04a9a497b0a4ebe49dc9686ed1ab02c4a33ec
```

### `dpkg` source package: `gosu=1.14-1`

Binary Packages:

- `gosu=1.14-1`

Licenses: (parsed from: `/usr/share/doc/gosu/copyright`)

- `Apache-2.0`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris gosu=1.14-1
'http://archive.ubuntu.com/ubuntu/pool/universe/g/gosu/gosu_1.14-1.dsc' gosu_1.14-1.dsc 2021 SHA512:a0ab08dd928b4ff4239862ab728284e3549fa0b5dc30ed6c68269d606165deb1a64a4472f96277cf87ab33f67e17633b5deb9195f9d313e5878784267bff512e
'http://archive.ubuntu.com/ubuntu/pool/universe/g/gosu/gosu_1.14.orig.tar.gz' gosu_1.14.orig.tar.gz 16791 SHA512:258bc33bf7150f4520e8b5cd0497ccfe3ee83d39c866565ec5e0cfe3ccd28ef1a5694075b301936c94a45cd44621c44e28c3e0fcd0acd465a3a4fe5cff85adf2
'http://archive.ubuntu.com/ubuntu/pool/universe/g/gosu/gosu_1.14-1.debian.tar.xz' gosu_1.14-1.debian.tar.xz 3084 SHA512:bde4bc8b376cd0b663cc92ac3b54ed67848f590e3f2a41b73fdd2095ccc4d635d48ee45e0fbe7ae6667485f5f013525f65b185a9775e7dbea435bded3cb39d9f
```

### `dpkg` source package: `graphite2=1.3.14-1build2`

Binary Packages:

- `libgraphite2-3:amd64=1.3.14-1build2`

Licenses: (parsed from: `/usr/share/doc/libgraphite2-3/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`
- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `MPL-1.1`
- `custom-sil-open-font-license`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris graphite2=1.3.14-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/g/graphite2/graphite2_1.3.14-1build2.dsc' graphite2_1.3.14-1build2.dsc 2262 SHA512:c1c167d90602a7f072189d046304af17a2a3e61509405c3623a56231f7c8341091bb2da2c73bfc41c1a3fc60a1f1b585476aec2a932767e3c31a400d37f50966
'http://archive.ubuntu.com/ubuntu/pool/main/g/graphite2/graphite2_1.3.14.orig.tar.gz' graphite2_1.3.14.orig.tar.gz 6629829 SHA512:49d127964d3f5c9403c7aecbfb5b18f32f25fe4919a81c49e0534e7123fe845423e16b0b8c8baaae21162b1150ab3e0f1c22c344e07d4364b6b8473c40a0822c
'http://archive.ubuntu.com/ubuntu/pool/main/g/graphite2/graphite2_1.3.14-1build2.debian.tar.xz' graphite2_1.3.14-1build2.debian.tar.xz 12224 SHA512:7c69742dc115a123eaba93092ad67c06e43e8538c04269e05fa06cb12802b9f331f52161c3ff0ddd0520ccad6993c30102f149ac1694552594a3db5f1c07a209
```

### `dpkg` source package: `grep=3.7-1build1`

Binary Packages:

- `grep=3.7-1build1`

Licenses: (parsed from: `/usr/share/doc/grep/copyright`)

- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris grep=3.7-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/g/grep/grep_3.7-1build1.dsc' grep_3.7-1build1.dsc 1900 SHA512:3345c289bc163924615d3bc9ac3138e35870715d38223ef9d38a90ab17160fc415f8c0c9a5da1939143e2701e46fc854b27b45c280c4af686db2208f2becbe4f
'http://archive.ubuntu.com/ubuntu/pool/main/g/grep/grep_3.7.orig.tar.xz' grep_3.7.orig.tar.xz 1641196 SHA512:e9e45dcd40af8367f819f2b93c5e1b4e98a251a9aa251841fa67a875380fae52cfa27c68c6dbdd6a4dde1b1017ee0f6b9833ef6dd6e419d32d71b6df5e972b82
'http://archive.ubuntu.com/ubuntu/pool/main/g/grep/grep_3.7.orig.tar.xz.asc' grep_3.7.orig.tar.xz.asc 833 SHA512:9db28883b696fbbb0fad32f4ecd168954dc475d5f0a8f2b4f960ff615ef7dd8348a7caaee85a96287824472a29485ff921af121c582083ca5ad5c30960f99cf4
'http://archive.ubuntu.com/ubuntu/pool/main/g/grep/grep_3.7-1build1.debian.tar.xz' grep_3.7-1build1.debian.tar.xz 18184 SHA512:cbefc3635a0b0acc33d8a052d3ca7d583adbd1bcfc384559076b5e4f5508b4a8301b0dd54a029aecbab925a6f916c99a2d5bebe0a6936fe5ffeb5a07a0d9a917
```

### `dpkg` source package: `gsettings-desktop-schemas=42.0-1ubuntu1`

Binary Packages:

- `gsettings-desktop-schemas=42.0-1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/gsettings-desktop-schemas/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris gsettings-desktop-schemas=42.0-1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/g/gsettings-desktop-schemas/gsettings-desktop-schemas_42.0-1ubuntu1.dsc' gsettings-desktop-schemas_42.0-1ubuntu1.dsc 2825 SHA512:816878a16c8c9477a156556aba9c405ad9c49f6520f1eb296139fb776643520b0bf0dfddd6aad5ec2957731f769979154ba409766e3a9c25f2a6442ab901ecf6
'http://archive.ubuntu.com/ubuntu/pool/main/g/gsettings-desktop-schemas/gsettings-desktop-schemas_42.0.orig.tar.xz' gsettings-desktop-schemas_42.0.orig.tar.xz 709372 SHA512:db73988a6b38857d1aa6588ccac42099c57dcc187ef01776567cc7c28aff67dc06d6a8a067e0c69167d03cd865f0c1d58e75469a40f969084bb2537b088f8664
'http://archive.ubuntu.com/ubuntu/pool/main/g/gsettings-desktop-schemas/gsettings-desktop-schemas_42.0-1ubuntu1.debian.tar.xz' gsettings-desktop-schemas_42.0-1ubuntu1.debian.tar.xz 8700 SHA512:c5b7c095b252419313ec151d68f6e41a3ca59b68d5c43f27ecff5230b90517305166b432cc20b3ab9dd013cde6230423cd1353c588029a7b866c0bc3a38964cd
```

### `dpkg` source package: `gtk+3.0=3.24.33-1ubuntu2.2`

Binary Packages:

- `gtk-update-icon-cache=3.24.33-1ubuntu2.2`
- `libgtk-3-0:amd64=3.24.33-1ubuntu2.2`
- `libgtk-3-bin=3.24.33-1ubuntu2.2`
- `libgtk-3-common=3.24.33-1ubuntu2.2`

Licenses: (parsed from: `/usr/share/doc/gtk-update-icon-cache/copyright`, `/usr/share/doc/libgtk-3-0/copyright`, `/usr/share/doc/libgtk-3-bin/copyright`, `/usr/share/doc/libgtk-3-common/copyright`)

- `Apache-2.0`
- `Expat`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `SWL`
- `X11R5-permissive`
- `ZPL-2.1`
- `check-gdk-cairo-permissive`
- `other`

Source:

```console
$ apt-get source -qq --print-uris gtk+3.0=3.24.33-1ubuntu2.2
'http://archive.ubuntu.com/ubuntu/pool/main/g/gtk%2b3.0/gtk%2b3.0_3.24.33-1ubuntu2.2.dsc' gtk+3.0_3.24.33-1ubuntu2.2.dsc 4492 SHA512:9364e53a587aca76d84d023536853c8804ca2c68d52c9d6eb38a3125aee79468df400173b2fad4c0df67d76c4d9c3651c255ebf821259535721162d231904437
'http://archive.ubuntu.com/ubuntu/pool/main/g/gtk%2b3.0/gtk%2b3.0_3.24.33.orig.tar.xz' gtk+3.0_3.24.33.orig.tar.xz 22449472 SHA512:35c844af67d442a9d55197028c6b660668c701ad8f83a64791669fca2930ada15194452b59b2ee11f8068098986218744fe9fc4742897af5a6b3eba23c98395e
'http://archive.ubuntu.com/ubuntu/pool/main/g/gtk%2b3.0/gtk%2b3.0_3.24.33-1ubuntu2.2.debian.tar.xz' gtk+3.0_3.24.33-1ubuntu2.2.debian.tar.xz 431240 SHA512:76b5424cffe1423026b3a0a72c5d795ec08ed08d61aad588289e36629a0ff98adebe1a1121c4f9b6b284a65e62e91d8ee8ca004eb52b8e68f64173496b66b3b7
```

### `dpkg` source package: `gtk-d=3.10.0-1ubuntu1`

Binary Packages:

- `libgtkd-3-0:amd64=3.10.0-1ubuntu1`
- `libvted-3-0:amd64=3.10.0-1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libgtkd-3-0/copyright`, `/usr/share/doc/libvted-3-0/copyright`)

- `Expat`
- `LGPL-2.1`
- `LGPL-2.1+`
- `LGPL-3`
- `LGPL-3+`

Source:

```console
$ apt-get source -qq --print-uris gtk-d=3.10.0-1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/universe/g/gtk-d/gtk-d_3.10.0-1ubuntu1.dsc' gtk-d_3.10.0-1ubuntu1.dsc 2792 SHA512:b319feadde91180c03b31d753ff74c3a1d57ad8085bbb4359eb2acf65984005bc5b4fd2ff871e79124633e0982aa047d2cf2bdd9abf2d0a1d6c172a36cc6b883
'http://archive.ubuntu.com/ubuntu/pool/universe/g/gtk-d/gtk-d_3.10.0.orig.tar.gz' gtk-d_3.10.0.orig.tar.gz 3214521 SHA512:1e75d6cbd278a065ce26b33320fe06cc7a30af8bd884c3c87abe799afaf9da8339d3c4470163b62ec8b70e8c540285b8c2c409c7b77423142a301f23ba37ff2e
'http://archive.ubuntu.com/ubuntu/pool/universe/g/gtk-d/gtk-d_3.10.0-1ubuntu1.debian.tar.xz' gtk-d_3.10.0-1ubuntu1.debian.tar.xz 5852 SHA512:b6d75388ce553b348a4d1a4052eac8f0b05e9f42ea6e36f9299efa816edce76f4c0bb137912e82269b72dbef6934391cf32ca26d375f6aaf6995d2b058a2c3d1
```

### `dpkg` source package: `gzip=1.10-4ubuntu4.1`

Binary Packages:

- `gzip=1.10-4ubuntu4.1`

Licenses: (parsed from: `/usr/share/doc/gzip/copyright`)

- `FSF-manpages`
- `GFDL-1.3+-no-invariant`
- `GFDL-3`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris gzip=1.10-4ubuntu4.1
'http://archive.ubuntu.com/ubuntu/pool/main/g/gzip/gzip_1.10-4ubuntu4.1.dsc' gzip_1.10-4ubuntu4.1.dsc 2277 SHA512:62008eba2ed83c6b8636541acb1930a0282248c153b9f1c5dc6209673cc77bdc50af8ec028aaa82fcbbe5cb6b9c142b8026f737c1eeb3bf01e11b4a39ffa4e23
'http://archive.ubuntu.com/ubuntu/pool/main/g/gzip/gzip_1.10.orig.tar.gz' gzip_1.10.orig.tar.gz 1201421 SHA512:7939043e74554ced0c1c05d354ab4eb36cd6dce89ad79d02ccdc5ed6b7ee390759689b2d47c07227b9b44a62851afe7c76c4cae9f92527d999f3f1b4df1cccff
'http://archive.ubuntu.com/ubuntu/pool/main/g/gzip/gzip_1.10.orig.tar.gz.asc' gzip_1.10.orig.tar.gz.asc 833 SHA512:74727fb3a8b64f81b4dd2d941fa750a789c482d7ae604d0ecfbe5ec623780efc7c5f0e51d65e7b99c2f097c5cd6585cc3a0f1b31abb03306156e0d410d9f0186
'http://archive.ubuntu.com/ubuntu/pool/main/g/gzip/gzip_1.10-4ubuntu4.1.debian.tar.xz' gzip_1.10-4ubuntu4.1.debian.tar.xz 39520 SHA512:4cecf676d0c9c55b5ec266f2ffa731cf618d7f4b571768dd3ad16ac8dcf966b80dabf1cbe3939edea96ca9743d710e365c444086946c03bdc3871410e5b4da76
```

### `dpkg` source package: `harfbuzz=2.7.4-1ubuntu3.1`

Binary Packages:

- `libharfbuzz0b:amd64=2.7.4-1ubuntu3.1`

Licenses: (parsed from: `/usr/share/doc/libharfbuzz0b/copyright`)

- `MIT`

Source:

```console
$ apt-get source -qq --print-uris harfbuzz=2.7.4-1ubuntu3.1
'http://archive.ubuntu.com/ubuntu/pool/main/h/harfbuzz/harfbuzz_2.7.4-1ubuntu3.1.dsc' harfbuzz_2.7.4-1ubuntu3.1.dsc 2855 SHA512:3e636c8c6cfd750636149c893fa2d91c9343a9bc61d09a650d9771b15635954c91ef0a5783c61136835c0fe668ea4d7c08037d83db709b2c83524f3ed3f9a38a
'http://archive.ubuntu.com/ubuntu/pool/main/h/harfbuzz/harfbuzz_2.7.4.orig.tar.xz' harfbuzz_2.7.4.orig.tar.xz 9532468 SHA512:d2af6a768c397c664f654cf36140e7b5696b3b983f637454604570c348247f7ffea135048d9b02cf6593cbde728567e31bf82a39df5ff38d680c78dff24d4cf0
'http://archive.ubuntu.com/ubuntu/pool/main/h/harfbuzz/harfbuzz_2.7.4-1ubuntu3.1.debian.tar.xz' harfbuzz_2.7.4-1ubuntu3.1.debian.tar.xz 11756 SHA512:e3f9211be2c2b5250b1e7db03627485ae8a6d09eec960fa5a0b6103887aa06bfba59007cc851bdbf291ba956fc4756fd8497ea68e996babeed2d6b0fcd2865d0
```

### `dpkg` source package: `hicolor-icon-theme=0.17-2`

Binary Packages:

- `hicolor-icon-theme=0.17-2`

Licenses: (parsed from: `/usr/share/doc/hicolor-icon-theme/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris hicolor-icon-theme=0.17-2
'http://archive.ubuntu.com/ubuntu/pool/main/h/hicolor-icon-theme/hicolor-icon-theme_0.17-2.dsc' hicolor-icon-theme_0.17-2.dsc 2053 SHA512:5b8b3088f8d9469076d5d2a3448e1115a910958a4ba4b3bbeae287ae3e91fa3a26b87f544a1f92925230e33f6f20e96df51bc5ec01b2735e07bb3f9be2e06c3c
'http://archive.ubuntu.com/ubuntu/pool/main/h/hicolor-icon-theme/hicolor-icon-theme_0.17.orig.tar.xz' hicolor-icon-theme_0.17.orig.tar.xz 53016 SHA512:eca8655930aa7e234f42630041c0053fde067b970fad1f81c55fcd4c5046c03edfdf2ede72a3e78fba2908e7da53e9463d3c5ae12ab9f5ef261e29a49f9c7a8d
'http://archive.ubuntu.com/ubuntu/pool/main/h/hicolor-icon-theme/hicolor-icon-theme_0.17-2.debian.tar.xz' hicolor-icon-theme_0.17-2.debian.tar.xz 3536 SHA512:74b8de58f18f861f0f724419514b787495cf67b39abcfdbdc7be6923e44112b86710c015ea5e4c83301d201b503a1014fca335c6dadc522d7f7edca80f638489
```

### `dpkg` source package: `hostname=3.23ubuntu2`

Binary Packages:

- `hostname=3.23ubuntu2`

Licenses: (parsed from: `/usr/share/doc/hostname/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris hostname=3.23ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/h/hostname/hostname_3.23ubuntu2.dsc' hostname_3.23ubuntu2.dsc 1085 SHA512:5e7f690bb67fcbc7521df55b69ce899ff005d24fb511c017d60ff5e4c9d9fc51271422bb81fc4998d90149cb814d2a209dc61db4d5073f72a37fb22af59827a0
'http://archive.ubuntu.com/ubuntu/pool/main/h/hostname/hostname_3.23ubuntu2.tar.gz' hostname_3.23ubuntu2.tar.gz 13854 SHA512:28b80ea23cbde63af91912aef2773ce83d7f4d1c2c82beb59a86c0e6b11e276019c610a0a60e69947af2b9bc5f86e4f8f6d13c1cb1a9ce35f1e5cfb03e0dd582
```

### `dpkg` source package: `humanity-icon-theme=0.6.16`

Binary Packages:

- `humanity-icon-theme=0.6.16`

Licenses: (parsed from: `/usr/share/doc/humanity-icon-theme/copyright`)

- `GPL-2`
- `GPL-3`
- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris humanity-icon-theme=0.6.16
'http://archive.ubuntu.com/ubuntu/pool/main/h/humanity-icon-theme/humanity-icon-theme_0.6.16.dsc' humanity-icon-theme_0.6.16.dsc 1016 SHA512:7be743cae212530aee19c8952a28298c856a37194bdbc175c4ccea96c947516b75330dc8f99e57c68565fb9fac2e05c50828a50dfae17e7aa2e3cdc0c532041d
'http://archive.ubuntu.com/ubuntu/pool/main/h/humanity-icon-theme/humanity-icon-theme_0.6.16.tar.xz' humanity-icon-theme_0.6.16.tar.xz 1757060 SHA512:a2a5dd4b03a3f81ae1f42aaaba76e1982978ec9a936fb61b38a53e20dfe5298bd47bac29b6ea4fbeb73fa878d48fe68b414d4179615526c81a8fbc7a5535d017
```

### `dpkg` source package: `icu=70.1-2`

Binary Packages:

- `icu-devtools=70.1-2`
- `libicu-dev:amd64=70.1-2`
- `libicu70:amd64=70.1-2`

Licenses: (parsed from: `/usr/share/doc/icu-devtools/copyright`, `/usr/share/doc/libicu-dev/copyright`, `/usr/share/doc/libicu70/copyright`)

- `GPL-3`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris icu=70.1-2
'http://archive.ubuntu.com/ubuntu/pool/main/i/icu/icu_70.1-2.dsc' icu_70.1-2.dsc 2252 SHA512:e1bad285bb7f66be62b8b9d595b289095621a88b0c5a2141b7317473ac25ab30a4b83de38ce215d6b7e0e135b2101ed7ab7bcf6d9b3666b4a554095b0ed6d1de
'http://archive.ubuntu.com/ubuntu/pool/main/i/icu/icu_70.1.orig.tar.gz' icu_70.1.orig.tar.gz 25449582 SHA512:0b26ae7207155cb65a8fdb25f7b2fa4431e74b12bccbed0884a17feaae3c96833d12451064dd152197fd6ea5fd3adfd95594284a463e66c82e0d860f645880c9
'http://archive.ubuntu.com/ubuntu/pool/main/i/icu/icu_70.1.orig.tar.gz.asc' icu_70.1.orig.tar.gz.asc 659 SHA512:17f65641de023b81f18588c5b1be6f88a8d308565343b09241ecfdc6250caeeb785e666d0772b668d5cb0fb243abc88766f02d27b273946e946e8c339cbca942
'http://archive.ubuntu.com/ubuntu/pool/main/i/icu/icu_70.1-2.debian.tar.xz' icu_70.1-2.debian.tar.xz 62440 SHA512:ca6771b09b9f232e69b3f6fd6c3445c9b27d86c918a6b52c903a2ebe658b273ea5181fcc3030aaad90450f9d86e620fdd42e710ed81c90c29d889ecfd44c6700
```

### `dpkg` source package: `init-system-helpers=1.62`

Binary Packages:

- `init-system-helpers=1.62`

Licenses: (parsed from: `/usr/share/doc/init-system-helpers/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris init-system-helpers=1.62
'http://archive.ubuntu.com/ubuntu/pool/main/i/init-system-helpers/init-system-helpers_1.62.dsc' init-system-helpers_1.62.dsc 1993 SHA512:f706cf5841877ccabe6f5a8e62d44ce5b312c09776d7fb7fd841f39c2d841b3f7f19bcb63cf94073f853165ae44def8f171a0abce658d05c76a48bf1e91697eb
'http://archive.ubuntu.com/ubuntu/pool/main/i/init-system-helpers/init-system-helpers_1.62.tar.xz' init-system-helpers_1.62.tar.xz 42144 SHA512:d90f12e642d086bd0d560ece87d119079c164b90ddbb77b2f804979540095b655715febbc2a5b0d50d7f94434d1ff7c0f4044d5d5411916fbca8300f3f88da7f
```

### `dpkg` source package: `io-stringy=2.111-3`

Binary Packages:

- `libio-stringy-perl=2.111-3`

Licenses: (parsed from: `/usr/share/doc/libio-stringy-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris io-stringy=2.111-3
'http://archive.ubuntu.com/ubuntu/pool/main/i/io-stringy/io-stringy_2.111-3.dsc' io-stringy_2.111-3.dsc 2166 SHA512:ca9b6b24449376d912fb24ecc8f111164fabde7c6df62df103a235a1f872c5fbfb0fb2ae609ca3f4ecbc82d50ec5b735e2296fd1682c5d46f1c14f62916cbbca
'http://archive.ubuntu.com/ubuntu/pool/main/i/io-stringy/io-stringy_2.111.orig.tar.gz' io-stringy_2.111.orig.tar.gz 41515 SHA512:9da8fb03945bc4a59cea3b3b2e22b15d56b133470e581d1cb03920bda2b4953e3c9e4a25d095ed8a384efb5a4c58db437c92cca6a81d583791191f1a37691a4a
'http://archive.ubuntu.com/ubuntu/pool/main/i/io-stringy/io-stringy_2.111-3.debian.tar.xz' io-stringy_2.111-3.debian.tar.xz 4328 SHA512:1aeb1a7adcdcf36caa237cea5f1834434f1518ed4c231500d3eb0b8b2b6b8580743dcdbc545e5ce9ef187a0ce85034f632e96f61657f520575b52d783e79ee11
```

### `dpkg` source package: `iptables=1.8.7-1ubuntu5.2`

Binary Packages:

- `libip4tc2:amd64=1.8.7-1ubuntu5.2`

Licenses: (parsed from: `/usr/share/doc/libip4tc2/copyright`)

- `Artistic`
- `GPL-2`
- `GPL-2+`
- `custom`

Source:

```console
$ apt-get source -qq --print-uris iptables=1.8.7-1ubuntu5.2
'http://archive.ubuntu.com/ubuntu/pool/main/i/iptables/iptables_1.8.7-1ubuntu5.2.dsc' iptables_1.8.7-1ubuntu5.2.dsc 2850 SHA512:b07f7e5e7056bcff264bbd7cf770b40462f6c5984582b175fc86f22c6435f4b3e138074db97851c92739dc32e80a6f9fc29d990e7efebdeabd8532440c4a500a
'http://archive.ubuntu.com/ubuntu/pool/main/i/iptables/iptables_1.8.7.orig.tar.bz2' iptables_1.8.7.orig.tar.bz2 717862 SHA512:c0a33fafbf1139157a9f52860938ebedc282a1394a68dcbd58981159379eb525919f999b25925f2cb4d6b18089bd99a94b00b3e73cff5cb0a0e47bdff174ed75
'http://archive.ubuntu.com/ubuntu/pool/main/i/iptables/iptables_1.8.7-1ubuntu5.2.debian.tar.xz' iptables_1.8.7-1ubuntu5.2.debian.tar.xz 88180 SHA512:c9f01e0fbfd22f5961f17da4edc3c15902959cb031067b4872d2e8d20ca3a96f56bb260f3d51fefd0c17177bbc1753dd7e3b23e1836e7b9eae252db313e4b402
```

### `dpkg` source package: `isl=0.24-2build1`

Binary Packages:

- `libisl23:amd64=0.24-2build1`

Licenses: (parsed from: `/usr/share/doc/libisl23/copyright`)

- `BSD-2-clause`
- `LGPL-2`
- `LGPL-2.1+`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris isl=0.24-2build1
'http://archive.ubuntu.com/ubuntu/pool/main/i/isl/isl_0.24-2build1.dsc' isl_0.24-2build1.dsc 1939 SHA512:508aaf010116caea8b9c61bb9c40a3979ed73cd09369b07747b43bed169988c415771c13395e46213f4c95f363f46e055e864723a3fb775fe9d2b5bb5bf45404
'http://archive.ubuntu.com/ubuntu/pool/main/i/isl/isl_0.24.orig.tar.xz' isl_0.24.orig.tar.xz 1930956 SHA512:ff6bdcff839e1cd473f2a0c1e4dd4a3612ec6fee4544ccbc62b530a7248db2cf93b4b99bf493a86ddf2aba00e768927265d5d411f92061ea85fd7929073428e8
'http://archive.ubuntu.com/ubuntu/pool/main/i/isl/isl_0.24-2build1.debian.tar.xz' isl_0.24-2build1.debian.tar.xz 26628 SHA512:8aafdd03adbe32b3eb6cb9468b676c20c02377c3b45947619258cfc1c682f4e9689945f9dbc6b42fd4c1289c563e7a7bba0af4f0a58b2c7ab94c7fdb3c6c9f5f
```

### `dpkg` source package: `jbigkit=2.1-3.1ubuntu0.22.04.1`

Binary Packages:

- `libjbig0:amd64=2.1-3.1ubuntu0.22.04.1`

Licenses: (parsed from: `/usr/share/doc/libjbig0/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris jbigkit=2.1-3.1ubuntu0.22.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/j/jbigkit/jbigkit_2.1-3.1ubuntu0.22.04.1.dsc' jbigkit_2.1-3.1ubuntu0.22.04.1.dsc 1796 SHA512:c7c726bcac2266327e373a30ec3d97f2197bc6f0f0859ffcc7d6930b94553f482f8693da95cb37ea2e8dc3ff4fdfd2a012e554b81afee0d336dab63d7869c570
'http://archive.ubuntu.com/ubuntu/pool/main/j/jbigkit/jbigkit_2.1.orig.tar.gz' jbigkit_2.1.orig.tar.gz 438710 SHA512:c4127480470ef90db1ef3bd2caa444df10b50ed8df0bc9997db7612cb48b49278baf44965028f1807a21028eb965d677e015466306b44683c4ec75a23e1922cf
'http://archive.ubuntu.com/ubuntu/pool/main/j/jbigkit/jbigkit_2.1-3.1ubuntu0.22.04.1.debian.tar.xz' jbigkit_2.1-3.1ubuntu0.22.04.1.debian.tar.xz 9912 SHA512:4c473125d8781d2b0192a8af40095e7c6e52225815a8dc7c87fe3bbb50aaeec4295438134be302fa57698d97fccd3f7d2240c74dbc57ef1089cab2ca3fc63475
```

### `dpkg` source package: `json-c=0.15-3~ubuntu1.22.04.2`

Binary Packages:

- `libjson-c5:amd64=0.15-3~ubuntu1.22.04.2`

Licenses: (parsed from: `/usr/share/doc/libjson-c5/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris json-c=0.15-3~ubuntu1.22.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/j/json-c/json-c_0.15-3%7eubuntu1.22.04.2.dsc' json-c_0.15-3~ubuntu1.22.04.2.dsc 2227 SHA512:a58e206925a375475780abd1b5db3884b60263d5805bc74374b86a7ec6c4a70e9636923193b6d1410cea6d81ba6fd2863800aab87081347df3ffcebc279f5e6f
'http://archive.ubuntu.com/ubuntu/pool/main/j/json-c/json-c_0.15.orig.tar.gz' json-c_0.15.orig.tar.gz 348261 SHA512:35cb3ef403ff5e8905144978ea0a22c9151b63e6bf749a50ca63b3d9320e5018be18aef236490295388d1be2ead7fcf8946d248b28b7ca109a057daaaada2162
'http://archive.ubuntu.com/ubuntu/pool/main/j/json-c/json-c_0.15-3%7eubuntu1.22.04.2.debian.tar.xz' json-c_0.15-3~ubuntu1.22.04.2.debian.tar.xz 11764 SHA512:e91bab2a87c4136f4d50c7d2508ec69e28cc35506814a13d318791ddbcc8a3dd14c5e39bb1be687677e870a9b15fc74e8043a6c962f11d81906007c92fbbc22f
```

### `dpkg` source package: `kerberos-configs=2.6+nmu1ubuntu1`

Binary Packages:

- `krb5-config=2.6+nmu1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/krb5-config/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris kerberos-configs=2.6+nmu1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/k/kerberos-configs/kerberos-configs_2.6%2bnmu1ubuntu1.dsc' kerberos-configs_2.6+nmu1ubuntu1.dsc 1740 SHA512:3a9c33fba93471d97b5b2fdcaa8da22f49fe918fb3f9c6a3cfdbb553d00acfc3470be614771ded72d5307f388dcb4b3eeecf5fd84a8084e1a3e22b03c6f35bb8
'http://archive.ubuntu.com/ubuntu/pool/main/k/kerberos-configs/kerberos-configs_2.6%2bnmu1ubuntu1.tar.xz' kerberos-configs_2.6+nmu1ubuntu1.tar.xz 27412 SHA512:b57a1d17ed3eb21c558503db21cfadae71fabe82252efc8cbd33a51254f80233acd8a1566332c3ac72f7311a64a4d7646e0cd5ed07c0b4435d3ec0b7b336bb5d
```

### `dpkg` source package: `kernsmooth=2.23-20-1`

Binary Packages:

- `r-cran-kernsmooth=2.23-20-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris kernsmooth=2.23-20-1
'http://archive.ubuntu.com/ubuntu/pool/universe/k/kernsmooth/kernsmooth_2.23-20-1.dsc' kernsmooth_2.23-20-1.dsc 1891 SHA512:25bd0fa5a9abcf8499247ff1e5104102ff665af0465af36200adee8afac242dfc54b9d400f743d53893f0af52b12eff52ab9b9aac6afce67ccd2f59b1bb9a06d
'http://archive.ubuntu.com/ubuntu/pool/universe/k/kernsmooth/kernsmooth_2.23-20.orig.tar.gz' kernsmooth_2.23-20.orig.tar.gz 25946 SHA512:a373ae0f17cfb780a1c241be3aafef11c55ed18e10c7e7eff5cd2cd11f1c53a6f9f784b5f82fe77d869f3a75b3d93dc1406a69fec3155d33da9dab3132f87c21
'http://archive.ubuntu.com/ubuntu/pool/universe/k/kernsmooth/kernsmooth_2.23-20-1.debian.tar.xz' kernsmooth_2.23-20-1.debian.tar.xz 3356 SHA512:0607ce067fbfbc342781c53a2abf0d4ca11ce4404dd736525689355b2d09997ae98faea1473e0297af67c8c994da18d8d801c592678c36b9da1cac4210aa8b32
```

### `dpkg` source package: `keyutils=1.6.1-2ubuntu3`

Binary Packages:

- `libkeyutils1:amd64=1.6.1-2ubuntu3`

Licenses: (parsed from: `/usr/share/doc/libkeyutils1/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris keyutils=1.6.1-2ubuntu3
'http://archive.ubuntu.com/ubuntu/pool/main/k/keyutils/keyutils_1.6.1-2ubuntu3.dsc' keyutils_1.6.1-2ubuntu3.dsc 2203 SHA512:7e9c3266bf707b3553758ab89f815542edca6d7ed0ca069986bee3dda75b534f5b275b786e246232b3234c6ccbaf4c67ff60f68bba73b0a3e2ec1bbfa00b295e
'http://archive.ubuntu.com/ubuntu/pool/main/k/keyutils/keyutils_1.6.1.orig.tar.bz2' keyutils_1.6.1.orig.tar.bz2 97232 SHA512:ea6e20b2594234c7f51581eef2b8fd19c109fa9eacaaef8dfbb4f237bd1d6fdf071ec23b4ff334cb22a46461d09d17cf499987fd1f00e66f27506888876961e1
'http://archive.ubuntu.com/ubuntu/pool/main/k/keyutils/keyutils_1.6.1-2ubuntu3.debian.tar.xz' keyutils_1.6.1-2ubuntu3.debian.tar.xz 18936 SHA512:16f390f0fc3154a77c8ca3666d44881a6ca2f0d11cfe0398cd82b57b6f552af85c156de358d0b87e39f301331897d72de058050e3cb53720a76b5b5ebf07aa3d
```

### `dpkg` source package: `kmod=29-1ubuntu1`

Binary Packages:

- `libkmod2:amd64=29-1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libkmod2/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris kmod=29-1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/k/kmod/kmod_29-1ubuntu1.dsc' kmod_29-1ubuntu1.dsc 2182 SHA512:fc9efc6a77cafbb410a6512b1295f4dae31062726087e76399b6f59bdd58837200276daa9ecbd6cd50ec3c1937a9b848b62a469ffacc59e5553fc758f1c06df4
'http://archive.ubuntu.com/ubuntu/pool/main/k/kmod/kmod_29.orig.tar.xz' kmod_29.orig.tar.xz 252492 SHA512:98f9662294326ace03fe36e35a3dc5473e59acf8d3f42f5c3c243601471e3c121c1a84e57094ba6439f71eed75b27ee759de4f9e014f73dee74c5c7baeeeb82c
'http://archive.ubuntu.com/ubuntu/pool/main/k/kmod/kmod_29-1ubuntu1.debian.tar.xz' kmod_29-1ubuntu1.debian.tar.xz 13544 SHA512:c5f867e01479a75ee7da2400f39aa8bead6a745b59f98241db834edc2730ac2316bfb165ec42638cfcb855e7a424f35a0bb7947868ef2f3affb36d56465a3c70
```

### `dpkg` source package: `krb5=1.19.2-2ubuntu0.4`

Binary Packages:

- `krb5-user=1.19.2-2ubuntu0.4`
- `libgssapi-krb5-2:amd64=1.19.2-2ubuntu0.4`
- `libgssrpc4:amd64=1.19.2-2ubuntu0.4`
- `libk5crypto3:amd64=1.19.2-2ubuntu0.4`
- `libkadm5clnt-mit12:amd64=1.19.2-2ubuntu0.4`
- `libkadm5srv-mit12:amd64=1.19.2-2ubuntu0.4`
- `libkdb5-10:amd64=1.19.2-2ubuntu0.4`
- `libkrb5-3:amd64=1.19.2-2ubuntu0.4`
- `libkrb5support0:amd64=1.19.2-2ubuntu0.4`

Licenses: (parsed from: `/usr/share/doc/krb5-user/copyright`, `/usr/share/doc/libgssapi-krb5-2/copyright`, `/usr/share/doc/libgssrpc4/copyright`, `/usr/share/doc/libk5crypto3/copyright`, `/usr/share/doc/libkadm5clnt-mit12/copyright`, `/usr/share/doc/libkadm5srv-mit12/copyright`, `/usr/share/doc/libkdb5-10/copyright`, `/usr/share/doc/libkrb5-3/copyright`, `/usr/share/doc/libkrb5support0/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris krb5=1.19.2-2ubuntu0.4
'http://archive.ubuntu.com/ubuntu/pool/main/k/krb5/krb5_1.19.2-2ubuntu0.4.dsc' krb5_1.19.2-2ubuntu0.4.dsc 3478 SHA512:6537e7171563d984f8197a71d9248e9c8b5077180f29cbff530379fa09e7040df50b869597669e57709449b0104f84dde0c406de2d00e1bb5f435b909468b43c
'http://archive.ubuntu.com/ubuntu/pool/main/k/krb5/krb5_1.19.2.orig.tar.gz' krb5_1.19.2.orig.tar.gz 8741053 SHA512:b90d6ed0e1e8a87eb5cb2c36d88b823a6a6caabf85e5d419adb8a930f7eea09a5f8491464e7e454cca7ba88be09d19415962fe0036ad2e31fc584f9fc0bbd470
'http://archive.ubuntu.com/ubuntu/pool/main/k/krb5/krb5_1.19.2-2ubuntu0.4.debian.tar.xz' krb5_1.19.2-2ubuntu0.4.debian.tar.xz 114184 SHA512:8e78309ffb2ab3c388cf70539de538b61ea70dc51252600200394f628554f504c3750d6bcffe9f9ec0321d9ecd58ff71849a346e741daaaad9a8aeb68336634e
```

### `dpkg` source package: `lapack=3.10.0-2ubuntu1`

Binary Packages:

- `libblas-dev:amd64=3.10.0-2ubuntu1`
- `libblas3:amd64=3.10.0-2ubuntu1`
- `liblapack-dev:amd64=3.10.0-2ubuntu1`
- `liblapack3:amd64=3.10.0-2ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libblas-dev/copyright`, `/usr/share/doc/libblas3/copyright`, `/usr/share/doc/liblapack-dev/copyright`, `/usr/share/doc/liblapack3/copyright`)

- `BSD-3-clause`
- `BSD-3-clause-intel`

Source:

```console
$ apt-get source -qq --print-uris lapack=3.10.0-2ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/l/lapack/lapack_3.10.0-2ubuntu1.dsc' lapack_3.10.0-2ubuntu1.dsc 3474 SHA512:2bdbf698a2ae59dc09b752a20e7b4dfe1c25bd6dc255a36e7fa763d38cb2555eb56a51317867c3a99c09438d038822eeaa933b03b37b836c63fa602a5893b8ae
'http://archive.ubuntu.com/ubuntu/pool/main/l/lapack/lapack_3.10.0.orig.tar.gz' lapack_3.10.0.orig.tar.gz 7630775 SHA512:56055000c241bab8f318ebd79249ea012c33be0c4c3eca6a78e247f35ad9e8088f46605a0ba52fd5ad3e7898be3b7bc6c50ceb3af327c4986a266b06fe768cbf
'http://archive.ubuntu.com/ubuntu/pool/main/l/lapack/lapack_3.10.0-2ubuntu1.debian.tar.xz' lapack_3.10.0-2ubuntu1.debian.tar.xz 29040 SHA512:192a9ec75107c5427bd6f2d35e4785034666ba635eb6129f926aaa1663939b625f2800b6acaf686faf69cf21fb8f4201733e5515511e203895300e25675afb78
```

### `dpkg` source package: `lattice=0.20-45-1`

Binary Packages:

- `r-cran-lattice=0.20-45-1`

Licenses: (parsed from: `/usr/share/doc/r-cran-lattice/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris lattice=0.20-45-1
'http://archive.ubuntu.com/ubuntu/pool/universe/l/lattice/lattice_0.20-45-1.dsc' lattice_0.20-45-1.dsc 1845 SHA512:fc1de81d7770496a2e27740bfdca69ab4bf51e4ad719d64bc9ea331b29c813ae839950744c5ea1d21547ff7d811f3be8492711b15aead5a613ac8ab805ffb405
'http://archive.ubuntu.com/ubuntu/pool/universe/l/lattice/lattice_0.20-45.orig.tar.gz' lattice_0.20-45.orig.tar.gz 399470 SHA512:b27975007c86e05653ddf1b9f0188e1fdbf4497965279928b71bc7b39df5a42c05e3fcee2dbd4284dbc6f3af4e32730c259b1abb29c6632ac90571ba15e65391
'http://archive.ubuntu.com/ubuntu/pool/universe/l/lattice/lattice_0.20-45-1.debian.tar.xz' lattice_0.20-45-1.debian.tar.xz 5248 SHA512:578633470bdc9a4a2720c0d8fe4b1d2d8d3a730f9335e490a901c6f52228d1b20cbcccc9444dc4d258aaeece7a06fdbe1d5e1d28e38f846727e329ce056123ae
```

### `dpkg` source package: `lcms2=2.12~rc1-2build2`

Binary Packages:

- `liblcms2-2:amd64=2.12~rc1-2build2`

Licenses: (parsed from: `/usr/share/doc/liblcms2-2/copyright`)

- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3 (GPL-3 for the fast_float plugin only)`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris lcms2=2.12~rc1-2build2
'http://archive.ubuntu.com/ubuntu/pool/main/l/lcms2/lcms2_2.12%7erc1-2build2.dsc' lcms2_2.12~rc1-2build2.dsc 2120 SHA512:589b8926590d9158a85ad4641920e1f9700fb864b13ec0f2e44292bd0530cc639ecbcbe216405b7a528ecc512902a79456b30985b5c5a278a5c4692f8fc4bc9f
'http://archive.ubuntu.com/ubuntu/pool/main/l/lcms2/lcms2_2.12%7erc1.orig.tar.gz' lcms2_2.12~rc1.orig.tar.gz 7417767 SHA512:1d27e6f91911053b79f2a46c6c16943e25fce2f0501bb7d97f49507522a8a0f911d60f20726fc31727fee5242c6d452c86cdc28735f8f88c3aa9676fd35fdec6
'http://archive.ubuntu.com/ubuntu/pool/main/l/lcms2/lcms2_2.12%7erc1-2build2.debian.tar.xz' lcms2_2.12~rc1-2build2.debian.tar.xz 10616 SHA512:250e0245e300fff7be06a43a30621bff920cbb606e51197177d3d43acc1b50ad0db8988f7c05b6b4365073bf0c952d93dcb79364228698fcd8fbc6b093d4f843
```

### `dpkg` source package: `ldc=1:1.28.0-1ubuntu1`

Binary Packages:

- `libphobos2-ldc-shared98:amd64=1:1.28.0-1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libphobos2-ldc-shared98/copyright`)

- `Artistic`
- `Artistic-1`
- `BSD-3-Clause`
- `BSL-1.0`
- `Expat`
- `GFDL-1.3`
- `GPL-2`
- `GPL-2.0`
- `GPL-3`
- `GPL-3.0+`
- `LLVM`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris ldc=1:1.28.0-1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/universe/l/ldc/ldc_1.28.0-1ubuntu1.dsc' ldc_1.28.0-1ubuntu1.dsc 2438 SHA512:f9bf3b12258042c9a2fc2ec468825e0a714ee38569c77fd8201a92493e81b63e586a717248d426a4ffc52bb16fb55a9733449da40128ba740df3db43e11f038a
'http://archive.ubuntu.com/ubuntu/pool/universe/l/ldc/ldc_1.28.0.orig.tar.gz' ldc_1.28.0.orig.tar.gz 8053512 SHA512:30606d28584142a864a5c9d01188d89f97b3f73c79044bb7a5d0ce96cb9e4a57fcbdbe197adcdb1260b9082468adfb14d12c7572dcf22335a8b12432b9a3fdbc
'http://archive.ubuntu.com/ubuntu/pool/universe/l/ldc/ldc_1.28.0-1ubuntu1.debian.tar.xz' ldc_1.28.0-1ubuntu1.debian.tar.xz 17788 SHA512:37336fea021e077d313f872e4bb9beb14dd91833442067c7459f462bdce9c4b4bfd6b47404bf5a476d61f49322aff635bba0b357470a93947b965bfacef032f0
```

### `dpkg` source package: `libalgorithm-diff-perl=1.201-1`

Binary Packages:

- `libalgorithm-diff-perl=1.201-1`

Licenses: (parsed from: `/usr/share/doc/libalgorithm-diff-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libalgorithm-diff-perl=1.201-1
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libalgorithm-diff-perl/libalgorithm-diff-perl_1.201-1.dsc' libalgorithm-diff-perl_1.201-1.dsc 2491 SHA512:35ab71d64c66166f8099b15096db536c16f765f532ca57e769ede46078e7cd7ad4d46b60b4725a115836421387cd62cef9f760fd89594c0277f4851eb4e4fb8c
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libalgorithm-diff-perl/libalgorithm-diff-perl_1.201.orig.tar.gz' libalgorithm-diff-perl_1.201.orig.tar.gz 30047 SHA512:b22b55f4e45748da0e8aca556dc2155ef2dbcfe42ac5cbe4aa59e4cc13c95a141e6324a9ab0acd7fbc3d97e761e0778176df0f7e726af837a7b7d075106ad8d0
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libalgorithm-diff-perl/libalgorithm-diff-perl_1.201-1.debian.tar.xz' libalgorithm-diff-perl_1.201-1.debian.tar.xz 4460 SHA512:e2f8134ff3bafc91130f11a799c6bdab72adcaf7e4db5fcd1e0b0cc0769723bc3a91fc056370104cce6cb4d9712199c9995fea46d0cf728fbb84e9a5122d3b01
```

### `dpkg` source package: `libalgorithm-diff-xs-perl=0.04-6build3`

Binary Packages:

- `libalgorithm-diff-xs-perl=0.04-6build3`

Licenses: (parsed from: `/usr/share/doc/libalgorithm-diff-xs-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libalgorithm-diff-xs-perl=0.04-6build3
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libalgorithm-diff-xs-perl/libalgorithm-diff-xs-perl_0.04-6build3.dsc' libalgorithm-diff-xs-perl_0.04-6build3.dsc 2270 SHA512:09e5c7d7b71b9dd464709564c4c3249d5e4b1afb72f844f5225e69b6e6f520e0d0ca328485d1ccc6686ad7d7317f6ce224e7dcbc936595f35c0c8013c659b417
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libalgorithm-diff-xs-perl/libalgorithm-diff-xs-perl_0.04.orig.tar.gz' libalgorithm-diff-xs-perl_0.04.orig.tar.gz 47699 SHA512:65f2e08129b90e61c3e90156ee3a7683268d86896599b68ca401ed6a93685933f88a40442b7328b47b4ad0f0c4a407e472175586a5497cd7026e4448d4f116f1
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libalgorithm-diff-xs-perl/libalgorithm-diff-xs-perl_0.04-6build3.debian.tar.xz' libalgorithm-diff-xs-perl_0.04-6build3.debian.tar.xz 2820 SHA512:b9c12c165b5042d07ff8b33cdb1cbf519069e889818f4a68ce5a13d027b4912008a821c8387453064601ef2e275b3214c255f47b4ccf93b8b83b7a3dc9ae4c55
```

### `dpkg` source package: `libalgorithm-merge-perl=0.08-3`

Binary Packages:

- `libalgorithm-merge-perl=0.08-3`

Licenses: (parsed from: `/usr/share/doc/libalgorithm-merge-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libalgorithm-merge-perl=0.08-3
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libalgorithm-merge-perl/libalgorithm-merge-perl_0.08-3.dsc' libalgorithm-merge-perl_0.08-3.dsc 2191 SHA512:2c7a7a5e1ac40fc47a518c649c763ac34828e0a8dffab3b395f18f018f184d9a25b0400afbcb104c1bcded70ba7b59591b5b4002c1795e2dfe96e66df7f31f07
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libalgorithm-merge-perl/libalgorithm-merge-perl_0.08.orig.tar.gz' libalgorithm-merge-perl_0.08.orig.tar.gz 9915 SHA512:5670eaabbf0336de368160de96523af7d7f81fa8f6c826829748742fd075c8f321b3735903148ab53c73cad6a78f173d75c9eb0658a5081535f61465a8c614a1
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libalgorithm-merge-perl/libalgorithm-merge-perl_0.08-3.debian.tar.xz' libalgorithm-merge-perl_0.08-3.debian.tar.xz 2436 SHA512:e96f061d6a83da065f5d57f47ded8fe75d29c3c55a7a881f27d7d0515f8a6ec4cca84a9ff32e982e632ed900601e784040042873c685df5b9dcd907af5ced611
```

### `dpkg` source package: `libassuan=2.5.5-1build1`

Binary Packages:

- `libassuan0:amd64=2.5.5-1build1`

Licenses: (parsed from: `/usr/share/doc/libassuan0/copyright`)

- `GAP`
- `GAP~FSF`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with libtool exception`
- `GPL-3`
- `GPL-3+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `LGPL-3`
- `LGPL-3+`

Source:

```console
$ apt-get source -qq --print-uris libassuan=2.5.5-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libassuan/libassuan_2.5.5-1build1.dsc' libassuan_2.5.5-1build1.dsc 2753 SHA512:6aa8147a85858f8e0c6ce17083c605fa92c65bcc810a0c1c5c8c5ef08332d359795ad77129bead9f7b216d7893c305e34f653ab29941b008f2bd1178e81587f5
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libassuan/libassuan_2.5.5.orig.tar.bz2' libassuan_2.5.5.orig.tar.bz2 572263 SHA512:70117f77aa43bbbe0ed28da5ef23834c026780a74076a92ec775e30f851badb423e9a2cb9e8d142c94e4f6f8a794988c1b788fd4bd2271e562071adf0ab16403
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libassuan/libassuan_2.5.5.orig.tar.bz2.asc' libassuan_2.5.5.orig.tar.bz2.asc 228 SHA512:343336ea5dffa113cd934167f548faf4e85d31bf64a46541ee6828b4d0995a8cc9d0668995812d9c4d3ab73347d5b1bbfff0d6ed586fbf4bbc57ac42e828e8d5
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libassuan/libassuan_2.5.5-1build1.debian.tar.xz' libassuan_2.5.5-1build1.debian.tar.xz 14448 SHA512:590d52fa0d3e7fde9747cb164b08a60ae3372eff60ac80f4de809289f86a83c2b7361e65bbb20e1b68a27960e7478a78031b57d7e9784d6d2dc407f1c8530217
```

### `dpkg` source package: `libauthen-sasl-perl=2.1600-1.1`

Binary Packages:

- `libauthen-sasl-perl=2.1600-1.1`

Licenses: (parsed from: `/usr/share/doc/libauthen-sasl-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libauthen-sasl-perl=2.1600-1.1
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libauthen-sasl-perl/libauthen-sasl-perl_2.1600-1.1.dsc' libauthen-sasl-perl_2.1600-1.1.dsc 2231 SHA512:5da8d2b3917bebfaac503bc1cf16e5c501a3fdd2a2875b54499ba18709849f2cba492c992bd5c5bf199a965bcecbcb5f51086b795a3a38212802323c5ca2c1b0
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libauthen-sasl-perl/libauthen-sasl-perl_2.1600.orig.tar.gz' libauthen-sasl-perl_2.1600.orig.tar.gz 45129 SHA512:d472b8b07b8915e65a219c0a40a7b6f25ca4fb767df301f426224b8f6ebf24d66fcb4422a1f421c39631e84585af06f6c64e41abe11e1e505d03e43a9f86bd6f
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libauthen-sasl-perl/libauthen-sasl-perl_2.1600-1.1.debian.tar.xz' libauthen-sasl-perl_2.1600-1.1.debian.tar.xz 4080 SHA512:d46aa415cf1f1ff1f2be85c6996a1d1cda7814820c8498a80cf5711dd768c5168490c6204e8c5c8691507fd9f9a6cef986351b7ac8b714016c9184ee036e14a1
```

### `dpkg` source package: `libbsd=0.11.5-1`

Binary Packages:

- `libbsd0:amd64=0.11.5-1`

Licenses: (parsed from: `/usr/share/doc/libbsd0/copyright`)

- `BSD-2-clause`
- `BSD-2-clause-NetBSD`
- `BSD-2-clause-author`
- `BSD-2-clause-verbatim`
- `BSD-3-clause`
- `BSD-3-clause-John-Birrell`
- `BSD-3-clause-Regents`
- `BSD-3-clause-author`
- `BSD-4-clause-Christopher-G-Demetriou`
- `BSD-4-clause-Niels-Provos`
- `BSD-5-clause-Peter-Wemm`
- `Beerware`
- `Expat`
- `ISC`
- `ISC-Original`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris libbsd=0.11.5-1
'http://archive.ubuntu.com/ubuntu/pool/main/libb/libbsd/libbsd_0.11.5-1.dsc' libbsd_0.11.5-1.dsc 2292 SHA512:635f85618e9bcf22abbe73a6864b87d34c4e9d75bc619cab4e487d0ccbb52e1c006258cb47c8b892869adb5d645303fbff3eb57618f2dc862120f741cfbe175c
'http://archive.ubuntu.com/ubuntu/pool/main/libb/libbsd/libbsd_0.11.5.orig.tar.xz' libbsd_0.11.5.orig.tar.xz 409972 SHA512:c52c19eddd53630aca14f9f6221f7b84aa9cc798b4bb91e867822b161793313aab872ac1c0350d29312a72fee6e2061f3910ff918b724ec171d8c9de5837c841
'http://archive.ubuntu.com/ubuntu/pool/main/libb/libbsd/libbsd_0.11.5.orig.tar.xz.asc' libbsd_0.11.5.orig.tar.xz.asc 833 SHA512:24a3fb414a3a354284c76724d65225619820f3f6b597ed8d163ed99f19ec433465f909fe047758f83a7cd6fc8ee2676478420c77cb2f0b8b69ffa7a690c8c17f
'http://archive.ubuntu.com/ubuntu/pool/main/libb/libbsd/libbsd_0.11.5-1.debian.tar.xz' libbsd_0.11.5-1.debian.tar.xz 17604 SHA512:438911ae479952b00aa81cdf2f12863b82a01bc2abf3acb4bf22223f4c851504a77217087b2e2edabf6cf61187314f1c3061f2794de7a38abd953451e2f0d931
```

### `dpkg` source package: `libcap-ng=0.7.9-2.2build3`

Binary Packages:

- `libcap-ng0:amd64=0.7.9-2.2build3`

Licenses: (parsed from: `/usr/share/doc/libcap-ng0/copyright`)

- `GPL-2`
- `GPL-3`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libcap-ng=0.7.9-2.2build3
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcap-ng/libcap-ng_0.7.9-2.2build3.dsc' libcap-ng_0.7.9-2.2build3.dsc 2105 SHA512:50d7c66eea7dbadcd2314f3eb5ae9f4464e9a2a82a36004efd841bc092f6c4787dd9856aa14bef85035ae9db115b3a9aee78436b790a373e935d98f7fd761cd5
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcap-ng/libcap-ng_0.7.9.orig.tar.gz' libcap-ng_0.7.9.orig.tar.gz 449038 SHA512:095edabaf76a943aab0645b843b14e20b1733ba1d47a8e34d82f6586ca9a1512ba2677d232b13dd3900b913837401bb58bf74481970e967ba19041959dc43259
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcap-ng/libcap-ng_0.7.9-2.2build3.debian.tar.xz' libcap-ng_0.7.9-2.2build3.debian.tar.xz 6432 SHA512:9ce3f52dc0c89739f0117ba7c1b8fdfcdb51ceb7cea7c00aa55522ba733efdb7a37a7f21a9bfd106e453a8477a759af0aaf4688e4b18c3c9cc659657aeb2c0bb
```

### `dpkg` source package: `libcap2=1:2.44-1ubuntu0.22.04.1`

Binary Packages:

- `libcap2:amd64=1:2.44-1ubuntu0.22.04.1`

Licenses: (parsed from: `/usr/share/doc/libcap2/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris libcap2=1:2.44-1ubuntu0.22.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcap2/libcap2_2.44-1ubuntu0.22.04.1.dsc' libcap2_2.44-1ubuntu0.22.04.1.dsc 2318 SHA512:89673cbc25652c33df4477e5624827c55f6799cf8ee73248c8ec58a647aa66aca02d6342edcb18d9d5e4892b5c2f1e011157c854dbfe2d5f6b916f27346518c1
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcap2/libcap2_2.44.orig.tar.xz' libcap2_2.44.orig.tar.xz 125568 SHA512:1bb323ca362923bd6bd0e2e4639cf8726975165a620a243b31e797056439eb7efb2bfbc8e5521636783a86c7415b2037b1638c98747b79183ca7d3d42a04ff20
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcap2/libcap2_2.44-1ubuntu0.22.04.1.debian.tar.xz' libcap2_2.44-1ubuntu0.22.04.1.debian.tar.xz 22564 SHA512:a526e48fe585b06d42bd2d1d241e16de4f9151c502ad1d54a1a07e73aee8e4c41009160c9b5fedadf9873b7eb9bf07b9a0c3ec56f854da59360aaf94589c1af8
```

### `dpkg` source package: `libclone-perl=0.45-1build3`

Binary Packages:

- `libclone-perl=0.45-1build3`

Licenses: (parsed from: `/usr/share/doc/libclone-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libclone-perl=0.45-1build3
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libclone-perl/libclone-perl_0.45-1build3.dsc' libclone-perl_0.45-1build3.dsc 2234 SHA512:c331bdd9013a2dadd563244a2f6ab7829bc1c46fc14cfbfd0d83d4fb79e76be8f00e9840c27015af24b2fa93f163383a4928460ae26756fbbb60f17cb8619d28
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libclone-perl/libclone-perl_0.45.orig.tar.gz' libclone-perl_0.45.orig.tar.gz 16130 SHA512:4d91580fb60876cca7670411748e42e6af0eaba8fac25d60e7a50685ae7b1e697e12c8a2835693e3e4abf3c13c060a2740344eb804ec26ed274b895f599340af
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libclone-perl/libclone-perl_0.45-1build3.debian.tar.xz' libclone-perl_0.45-1build3.debian.tar.xz 4036 SHA512:34eecfbadb60a4b2bcb27bb9d67ec8fcb7b0d5773652bdb38612cde4bbe868f246031747f78a11c3247a734bb456e9e3efa57a7b56619ddf7e70555cac9aafd6
```

### `dpkg` source package: `libdata-dump-perl=1.25-1`

Binary Packages:

- `libdata-dump-perl=1.25-1`

Licenses: (parsed from: `/usr/share/doc/libdata-dump-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libdata-dump-perl=1.25-1
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdata-dump-perl/libdata-dump-perl_1.25-1.dsc' libdata-dump-perl_1.25-1.dsc 2385 SHA512:8961d13f3136dcfcb852b29c9c2feb81d4e6f0f584ce5f35ebbfc9239c3f72a3c039104a4c136b5acd1c141a482d5cf41d23ea7d8da9f3195aa2fbb61d82e2d7
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdata-dump-perl/libdata-dump-perl_1.25.orig.tar.gz' libdata-dump-perl_1.25.orig.tar.gz 20912 SHA512:fc859b0f02a44a959da3e162606c8fbaefececf8dbd0aa357d68a5a3143b818ae423dd7862063f2f77161ea000fcaa6841c96a2c4a268b889da9588292b157fe
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdata-dump-perl/libdata-dump-perl_1.25-1.debian.tar.xz' libdata-dump-perl_1.25-1.debian.tar.xz 3912 SHA512:d3c31f6c7d5b68d52d9024c91855d455caff31be1b79e7118832a6e03dc8757c25579d56976ac372ce5eb172170dc4addee9a24823b4409464c4e8733e82fcf0
```

### `dpkg` source package: `libdatrie=0.2.13-2`

Binary Packages:

- `libdatrie1:amd64=0.2.13-2`

Licenses: (parsed from: `/usr/share/doc/libdatrie1/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris libdatrie=0.2.13-2
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdatrie/libdatrie_0.2.13-2.dsc' libdatrie_0.2.13-2.dsc 2239 SHA512:86ebcb0343ca62b1e832210de6ca74e71786cf7c4c63eb5d1e944dc1bf900c986107c1120e798412fd9780902056fda1403c6124baef044778d479b53aeabb6d
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdatrie/libdatrie_0.2.13.orig.tar.xz' libdatrie_0.2.13.orig.tar.xz 314072 SHA512:db3c879d825ead5871c12ef3a06bb093cb1708a6e7e20775eaf82356af9dd6ad54c6b5cabbe1773f2494d3dfa2426528fdd49441038b6294b70ccb1a3d90099a
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdatrie/libdatrie_0.2.13-2.debian.tar.xz' libdatrie_0.2.13-2.debian.tar.xz 9604 SHA512:032040b6f9da493b7bbc4437eb16dce9dbbf10d0d9381fbc4ec6c636e5cccaf52b14e77739d227b58fc5ba54911c2cea7f679bada7ed93acb048bd996d4ce3d9
```

### `dpkg` source package: `libdeflate=1.10-2`

Binary Packages:

- `libdeflate0:amd64=1.10-2`

Licenses: (parsed from: `/usr/share/doc/libdeflate0/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris libdeflate=1.10-2
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdeflate/libdeflate_1.10-2.dsc' libdeflate_1.10-2.dsc 2206 SHA512:5c2fd7116bd061a5940481924c3a35e632e178050319c5e29aab2833a2ec27378444a6db767cff1bdd7b9bada10332a975e082ce02eab1fc43f8408a54dfcf52
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdeflate/libdeflate_1.10.orig.tar.gz' libdeflate_1.10.orig.tar.gz 158379 SHA512:2b59cc170c7fb3bb13bd3c6853070ea24fb9e6844dde4d08e43a8a5f8745ecbf844952390ff758070c6fc4f17d9eec8c4d2a729922bf84e2eaa9e74f1424e241
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdeflate/libdeflate_1.10-2.debian.tar.xz' libdeflate_1.10-2.debian.tar.xz 4584 SHA512:faa6fad75528e1f7fa02dd5464bf88d7921563103aee922feade71323229e0c6758cb788545ca6b627aabae58bb7f524d775431fc821f4611713dec6069571c8
```

### `dpkg` source package: `libdrm=2.4.113-2~ubuntu0.22.04.1`

Binary Packages:

- `libdrm-amdgpu1:amd64=2.4.113-2~ubuntu0.22.04.1`
- `libdrm-common=2.4.113-2~ubuntu0.22.04.1`
- `libdrm-intel1:amd64=2.4.113-2~ubuntu0.22.04.1`
- `libdrm-nouveau2:amd64=2.4.113-2~ubuntu0.22.04.1`
- `libdrm-radeon1:amd64=2.4.113-2~ubuntu0.22.04.1`
- `libdrm2:amd64=2.4.113-2~ubuntu0.22.04.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libdrm=2.4.113-2~ubuntu0.22.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdrm/libdrm_2.4.113-2%7eubuntu0.22.04.1.dsc' libdrm_2.4.113-2~ubuntu0.22.04.1.dsc 3360 SHA512:85bf8290d7c3ed97803bf71c9eb640098ada36bc542849a71afca5328076c14cd6a2831b7c336c47a4433dbd256b4c3a9571dcfe5bf396d97621c2c836cf116d
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdrm/libdrm_2.4.113.orig.tar.xz' libdrm_2.4.113.orig.tar.xz 457064 SHA512:fca9834ce090f63ce6dc6d04491a2c5e86162fdddfc8ea70d55a6cdeb401be656388aae1577e58f463a78d8dc502be0a641908784819874e20bbec9a39a057e0
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdrm/libdrm_2.4.113.orig.tar.xz.asc' libdrm_2.4.113.orig.tar.xz.asc 833 SHA512:07807ad5fefd36f58400877bdb0c7cbde445888bd88e8f852b177b88f0c4c3d2bb53e334341ae5b0441c148f219cf841e45d4ae5c06415fc9044c6ff1aa9e596
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdrm/libdrm_2.4.113-2%7eubuntu0.22.04.1.debian.tar.xz' libdrm_2.4.113-2~ubuntu0.22.04.1.debian.tar.xz 60984 SHA512:ab34c74ef4cc56990c078f7d5206037516ebb364e5a0e4dc2ab67ef43452f70eb83b5d5c06e2de4d23233ef26bfefe4cb210574008f7ab7f796434d008bda931
```

### `dpkg` source package: `libedit=3.1-20210910-1build1`

Binary Packages:

- `libedit2:amd64=3.1-20210910-1build1`

Licenses: (parsed from: `/usr/share/doc/libedit2/copyright`)

- `BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris libedit=3.1-20210910-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libedit/libedit_3.1-20210910-1build1.dsc' libedit_3.1-20210910-1build1.dsc 2340 SHA512:67cfd7c36cfb575a49a919968710841a19a9f523c6138c3f8bc56de3e546a90adad72f25c1bb4753d83a6d09634c873b3c636613f6d223041f00c7d18ecb7790
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libedit/libedit_3.1-20210910.orig.tar.gz' libedit_3.1-20210910.orig.tar.gz 524722 SHA512:b7361c277f971ebe87e0e539e5e1fb01a4ca1bbab61e199eb97774d8b60dddeb9e35796faf9cc68eb86d1890e8aac11db13b44b57ccc8302d559741fbe9d979e
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libedit/libedit_3.1-20210910-1build1.debian.tar.xz' libedit_3.1-20210910-1build1.debian.tar.xz 15200 SHA512:23ca0f62bf73e9fd1537c599b689807834db6b657c8f0dc448947db49fa3fe0de498ad96ea3d24515f0875fb3f50c4839f1bba25bf9bc48fe23de5fc780f3542
```

### `dpkg` source package: `libencode-locale-perl=1.05-1.1`

Binary Packages:

- `libencode-locale-perl=1.05-1.1`

Licenses: (parsed from: `/usr/share/doc/libencode-locale-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libencode-locale-perl=1.05-1.1
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libencode-locale-perl/libencode-locale-perl_1.05-1.1.dsc' libencode-locale-perl_1.05-1.1.dsc 2129 SHA512:5be62a5dae50e96125ac2df6598a2e864a5a9d87b038562cc17135d71c049558e9cdd4248edd221e8dda74a3011590e68df9e42e7e28883a5bc071dff8b91449
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libencode-locale-perl/libencode-locale-perl_1.05.orig.tar.gz' libencode-locale-perl_1.05.orig.tar.gz 8355 SHA512:68ed5732fd3645eca2ea54080067677a48f90fc5a594a1b453a322f3127e67a984d539cb5fd41ac63a03b9dab693c070b65e3c70a2a677dc61b4634f3e212d06
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libencode-locale-perl/libencode-locale-perl_1.05-1.1.debian.tar.xz' libencode-locale-perl_1.05-1.1.debian.tar.xz 2652 SHA512:18e205682333fa552ec0711fdd59a153f8fd75d937fe690ee6c8c4c31d773e4eff2dfa2f3e44fbf3f09bcee9db1fb2674ec0aeab22c39fb17715e520d2514bb9
```

### `dpkg` source package: `libepoxy=1.5.10-1`

Binary Packages:

- `libepoxy0:amd64=1.5.10-1`

Licenses: (parsed from: `/usr/share/doc/libepoxy0/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris libepoxy=1.5.10-1
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libepoxy/libepoxy_1.5.10-1.dsc' libepoxy_1.5.10-1.dsc 2095 SHA512:26f4ba03a47589eae9a0413c5a24be2cb4a8e25df50839aa494c270650ecb1994a2623399ece529321736eb4d367642221044d105e2b05418e964d4023a72f27
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libepoxy/libepoxy_1.5.10.orig.tar.gz' libepoxy_1.5.10.orig.tar.gz 332078 SHA512:6786f31c6e2865e68a90eb912900a86bf56fd3df4d78a477356886ac3b6ef52ac887b9c7a77aa027525f868ae9e88b12e5927ba56069c2e115acd631fca3abee
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libepoxy/libepoxy_1.5.10-1.debian.tar.xz' libepoxy_1.5.10-1.debian.tar.xz 17484 SHA512:5c0312814d6ced38f2b3fa804776e3d94d884fcfb8c887a672aa7a51cb03066334652cf581a85e77f02576c8d2232cd7b5e98e50aaa1810d32702f6a794ff7e3
```

### `dpkg` source package: `libffi=3.4.2-4`

Binary Packages:

- `libffi8:amd64=3.4.2-4`

Licenses: (parsed from: `/usr/share/doc/libffi8/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris libffi=3.4.2-4
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libffi/libffi_3.4.2-4.dsc' libffi_3.4.2-4.dsc 1948 SHA512:a3a3ada71f82d244f8cb54f1cac30ae6be7c4305696700fb6ffb96783f4f9f788c943bc8ba0d7474c9fd31f04453875e1da341240707711e4eff10cd8023e8d1
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libffi/libffi_3.4.2.orig.tar.gz' libffi_3.4.2.orig.tar.gz 1351355 SHA512:31bad35251bf5c0adb998c88ff065085ca6105cf22071b9bd4b5d5d69db4fadf16cadeec9baca944c4bb97b619b035bb8279de8794b922531fddeb0779eb7fb1
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libffi/libffi_3.4.2-4.debian.tar.xz' libffi_3.4.2-4.debian.tar.xz 8164 SHA512:eecf83971847b78aae0c2cfe3b546a858c93462b7d1d2473c96f5b43de47e1d5fc4663b524e4c5792630d7a6d1796e8bdf83f55addc669d0ce3810643924a07f
```

### `dpkg` source package: `libfile-basedir-perl=0.09-1`

Binary Packages:

- `libfile-basedir-perl=0.09-1`

Licenses: (parsed from: `/usr/share/doc/libfile-basedir-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libfile-basedir-perl=0.09-1
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-basedir-perl/libfile-basedir-perl_0.09-1.dsc' libfile-basedir-perl_0.09-1.dsc 2477 SHA512:29e051217d3bfc1b5422fdc26d949eeb24cc32117f995360a1e65aa9c1287ff93d33aa7651b8b9c357789495addb3c9c7e9f686cf09547e3f40c9c053b646cc2
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-basedir-perl/libfile-basedir-perl_0.09.orig.tar.gz' libfile-basedir-perl_0.09.orig.tar.gz 21508 SHA512:07b07f43bce392beda6ac10729925c3b6ad850f0af5485c3f540b72353a1e877e7e9b76580057197cf68864086f1a3d1f9459cfcf142f16772f48125426d72db
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-basedir-perl/libfile-basedir-perl_0.09-1.debian.tar.xz' libfile-basedir-perl_0.09-1.debian.tar.xz 3128 SHA512:c49bfeab740c57c07a0955ee896bc15ba3d10f3d486c50e9cbd9390c83f9aba5d0d407a13b8fc202b73f26ee26bac2ea0a2693a35e50255636459cdd62b89878
```

### `dpkg` source package: `libfile-desktopentry-perl=0.22-2`

Binary Packages:

- `libfile-desktopentry-perl=0.22-2`

Licenses: (parsed from: `/usr/share/doc/libfile-desktopentry-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libfile-desktopentry-perl=0.22-2
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-desktopentry-perl/libfile-desktopentry-perl_0.22-2.dsc' libfile-desktopentry-perl_0.22-2.dsc 2602 SHA512:624d10a0e9f6738b4a946a1542152f72080cb489e1875796e1b3a37169ee0861f7b148bef76ada9ede2d480bb83644865d1b87a0913e2357e35403aa6d8dce4f
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-desktopentry-perl/libfile-desktopentry-perl_0.22.orig.tar.gz' libfile-desktopentry-perl_0.22.orig.tar.gz 18366 SHA512:f6a0f2a91c66ea3e5ebac1e66f82317c4109d8d3e2211b4e84cd870b9df07320c03ee0d026e89f788338a1c02152c77e36402684da4f5a7093eb3ac21ff584a7
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-desktopentry-perl/libfile-desktopentry-perl_0.22-2.debian.tar.xz' libfile-desktopentry-perl_0.22-2.debian.tar.xz 4108 SHA512:f3f18248b03b8486427cbda8b55cf2cd9abc12e7acdd07ded6b8f5a294b8ee98a219f84ffcd3758e99e445526b1668f422743000701caec484c551492a05a1c3
```

### `dpkg` source package: `libfile-fcntllock-perl=0.22-3build7`

Binary Packages:

- `libfile-fcntllock-perl=0.22-3build7`

Licenses: (parsed from: `/usr/share/doc/libfile-fcntllock-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libfile-fcntllock-perl=0.22-3build7
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-fcntllock-perl/libfile-fcntllock-perl_0.22-3build7.dsc' libfile-fcntllock-perl_0.22-3build7.dsc 2182 SHA512:22364b9c4bb8d408db4a6e19c3dadca39fbc3523cf1eb2dfcaeb8174cda5e6cb10554486b83301b9be0c8f51aa3007ac13ba08a765f954705454025780cd0741
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-fcntllock-perl/libfile-fcntllock-perl_0.22.orig.tar.gz' libfile-fcntllock-perl_0.22.orig.tar.gz 16994 SHA512:c57bc73ce220fc3379dd88e6f1c422ce05dbf659e4ac676614b4fc6967d2ea5e27b476c0a1e29caf1e469a4ace7d23a1b0e86284403b2443d19df7fc52b308db
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-fcntllock-perl/libfile-fcntllock-perl_0.22-3build7.debian.tar.xz' libfile-fcntllock-perl_0.22-3build7.debian.tar.xz 2704 SHA512:9f123415134022e0cd7cd39fa640d220c1121a5f2eb6ab33d4d92df734cc0f6128db724ff344cb55f68ee79d6c2706ff754fadc6fe5037ff48351479fc8708d1
```

### `dpkg` source package: `libfile-listing-perl=6.14-1`

Binary Packages:

- `libfile-listing-perl=6.14-1`

Licenses: (parsed from: `/usr/share/doc/libfile-listing-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libfile-listing-perl=6.14-1
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-listing-perl/libfile-listing-perl_6.14-1.dsc' libfile-listing-perl_6.14-1.dsc 2405 SHA512:9f20080f035258b420e6a2bd24cbdfcfe2d56326711ead9db966efa1bc3818f1a91278530cee05cfe413ac894525976dec4b69033ab85431f7b0ad5c839b42aa
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-listing-perl/libfile-listing-perl_6.14.orig.tar.gz' libfile-listing-perl_6.14.orig.tar.gz 80562 SHA512:858339b15a455db570d15b02e801ab0e0afd47da71685002083cbcc1a0f89783fcad4e840e0381f186046ab2f355dc0f593dc8c9c0a2da0fc6f17a35265924ab
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-listing-perl/libfile-listing-perl_6.14-1.debian.tar.xz' libfile-listing-perl_6.14-1.debian.tar.xz 2724 SHA512:c98de30ed07550880c759ee9b3b3f6bc67f378218754a75b220cf2b8847abd7463a5db3522643dc809c514071be105c709026763cff9c7a69953a11ea729b424
```

### `dpkg` source package: `libfile-mimeinfo-perl=0.31-1`

Binary Packages:

- `libfile-mimeinfo-perl=0.31-1`

Licenses: (parsed from: `/usr/share/doc/libfile-mimeinfo-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libfile-mimeinfo-perl=0.31-1
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-mimeinfo-perl/libfile-mimeinfo-perl_0.31-1.dsc' libfile-mimeinfo-perl_0.31-1.dsc 2710 SHA512:53d487839e22e52c7c8cad190d1530d4e1f1e963e7f2bfb8fc9a5480d98aa44cb3dfbe06b36305ca5dcc3453813bdf776db9e4ab5c6a267f526067c2d203c5cc
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-mimeinfo-perl/libfile-mimeinfo-perl_0.31.orig.tar.gz' libfile-mimeinfo-perl_0.31.orig.tar.gz 35636 SHA512:982664aad66dcec54164845c8287d0815659d9dfa3aa54c4a555b87fae175cec4094e92149f0d7028fd987d7a223415fe7cb25456d593bcc54b48eef407d25bf
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-mimeinfo-perl/libfile-mimeinfo-perl_0.31-1.debian.tar.xz' libfile-mimeinfo-perl_0.31-1.debian.tar.xz 4876 SHA512:e6c29480f9061e3a8ba47e8b7bcca99c460e8a16c2439eb59bf57be5bd7c2b7782c9accb5f83b9a35c87683cd188dbf9952d4d519f01da53c8dd39786f211a55
```

### `dpkg` source package: `libfont-afm-perl=1.20-3`

Binary Packages:

- `libfont-afm-perl=1.20-3`

Licenses: (parsed from: `/usr/share/doc/libfont-afm-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libfont-afm-perl=1.20-3
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfont-afm-perl/libfont-afm-perl_1.20-3.dsc' libfont-afm-perl_1.20-3.dsc 2358 SHA512:869fda75996e86d88ced94a299be723067962cb2c59dc0647a2d4ab132353d763b6eed287ae0d21c8300689668ebdad3f2adc3729b83e7685a4b172a4f5bd1ee
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfont-afm-perl/libfont-afm-perl_1.20.orig.tar.gz' libfont-afm-perl_1.20.orig.tar.gz 10421 SHA512:1fc74f0dbbed52937d512465a021148e93b2e0698189a6fc17eb1aa8951c934b0060a0256883118dc2a3a9086025468e0a851706306876568466bf4638fdb618
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfont-afm-perl/libfont-afm-perl_1.20-3.debian.tar.xz' libfont-afm-perl_1.20-3.debian.tar.xz 3812 SHA512:d85f1c4b299ce974b5a03cc77dd867b0a7876bde2b49c6c8886d9ff06e9c4c06bc66f97e75e06e3b1532868cff312c723e6292a4e3b450d1b499383691eeb0f0
```

### `dpkg` source package: `libfontenc=1:1.1.4-1build3`

Binary Packages:

- `libfontenc1:amd64=1:1.1.4-1build3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libfontenc=1:1.1.4-1build3
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfontenc/libfontenc_1.1.4-1build3.dsc' libfontenc_1.1.4-1build3.dsc 2420 SHA512:f115921a7fb6e6d3bef1327ebb2e9348896934e236bec023a56f1c2bc8c4aceaf31e4a1f69cdf7d2ecc1935b6f2c929156ce7900e8c1789b1b686eb1ad7b984f
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfontenc/libfontenc_1.1.4.orig.tar.gz' libfontenc_1.1.4.orig.tar.gz 389706 SHA512:ffa9d3c2f17bad76fe5034f5939127db4636140bbf939ef42e052cfe86bd1e825ef2455b3c2efa743a56aa44607aa7e31cfb16d7fb8a4d4ed52c059d3bf33547
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfontenc/libfontenc_1.1.4.orig.tar.gz.asc' libfontenc_1.1.4.orig.tar.gz.asc 801 SHA512:147c3fda4f198843badbad71cf66f101b772cf083ded4df0b8e8c77b6b5f77094dc5882b3570635eeda6160163557d63b0bf6930e5353210091a6a1774a10de3
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfontenc/libfontenc_1.1.4-1build3.diff.gz' libfontenc_1.1.4-1build3.diff.gz 9377 SHA512:d25103813918619452fd038d9f356e9bc700811801ba235bed4665acd0309593fa4ba482946a85fd9931414a56a8c715654ed11c9cb95afa89e593e62e472ad0
```

### `dpkg` source package: `libgcrypt20=1.9.4-3ubuntu3`

Binary Packages:

- `libgcrypt20:amd64=1.9.4-3ubuntu3`

Licenses: (parsed from: `/usr/share/doc/libgcrypt20/copyright`)

- `GPL-2`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris libgcrypt20=1.9.4-3ubuntu3
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgcrypt20/libgcrypt20_1.9.4-3ubuntu3.dsc' libgcrypt20_1.9.4-3ubuntu3.dsc 2936 SHA512:1f68c37290d1ccdaa60cf6543c52f7dca084b49ebffd5d4fd7700304a4f8d133e694084ed69ff4b33ba2c2e25947c9ac595997a20dfb6627285d0ca2477c7809
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgcrypt20/libgcrypt20_1.9.4.orig.tar.bz2' libgcrypt20_1.9.4.orig.tar.bz2 3239704 SHA512:d0e117ac73c94d70e9521ee1e6328691498cc8328f8c4e21338096908f5c04c7b838966eb63d59494565f4e19f506c07dab4f4d922150d75610d9f7b57abbf60
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgcrypt20/libgcrypt20_1.9.4.orig.tar.bz2.asc' libgcrypt20_1.9.4.orig.tar.bz2.asc 228 SHA512:5fbc2f52ff8a9f2b254791a0d127b012a3648a03d26e043af2ab63d05f69045492581462ba485ecf005a171ea391175bdc73350aa0e76f8b5f75c64a4d685d49
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgcrypt20/libgcrypt20_1.9.4-3ubuntu3.debian.tar.xz' libgcrypt20_1.9.4-3ubuntu3.debian.tar.xz 35172 SHA512:fec6751987d91e0234a9da212456763045eabf52166fb30f4832db0460b0a250caff879ac9c80dddf5697945e3a5b1effa036206b96fbf047f2bb705d74a5245
```

### `dpkg` source package: `libgd2=2.3.0-2ubuntu2`

Binary Packages:

- `libgd3:amd64=2.3.0-2ubuntu2`

Licenses: (parsed from: `/usr/share/doc/libgd3/copyright`)

- `BSD-3-clause`
- `GAP~Makefile.in`
- `GAP~configure`
- `GD`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with Autoconf exception`
- `HPND`
- `MIT`
- `WEBP`
- `XFIG`

Source:

```console
$ apt-get source -qq --print-uris libgd2=2.3.0-2ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgd2/libgd2_2.3.0-2ubuntu2.dsc' libgd2_2.3.0-2ubuntu2.dsc 2318 SHA512:96c030bf2491b412fa423cbac1b2f2d3ace638a99c66ea8e7f55cd1c409d1fa5999a7fd02968949eb56fb8b28dc03d61e4464d0de13a5ef7428051b133ccc235
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgd2/libgd2_2.3.0.orig.tar.gz' libgd2_2.3.0.orig.tar.gz 3102749 SHA512:1ffdbe41f24fcdb22f5b195b8f1a22650a3dc30a798c23a7ee1a93acfdb70c2608d97ff908a01246ad44e1cfc13dbd20cc006d7a25b882907489daa1880db30b
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgd2/libgd2_2.3.0-2ubuntu2.debian.tar.xz' libgd2_2.3.0-2ubuntu2.debian.tar.xz 34548 SHA512:992da1a98982cca39cd6df17c963b4f4e169d99a9331c74ad5f02eb80371c909b51d83c7362df96ed41cc2206ff478bd705f2d983de90456c8560601aaa25732
```

### `dpkg` source package: `libglvnd=1.4.0-1`

Binary Packages:

- `libgl1:amd64=1.4.0-1`
- `libglvnd0:amd64=1.4.0-1`
- `libglx0:amd64=1.4.0-1`

Licenses: (parsed from: `/usr/share/doc/libgl1/copyright`, `/usr/share/doc/libglvnd0/copyright`, `/usr/share/doc/libglx0/copyright`)

- `Apache-2.0`
- `BSD-1-clause`
- `GPL`
- `GPL-3`
- `GPL-3+`
- `MIT`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris libglvnd=1.4.0-1
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libglvnd/libglvnd_1.4.0-1.dsc' libglvnd_1.4.0-1.dsc 2690 SHA512:38868f25aecb76b9a42b09a994e9c1ecd1a3e8606c632da894522a4b640658280ff91988e3442d45b7f5d30fdfd5b4e9560fd3a1376e88c1a0c2f5555dc430d8
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libglvnd/libglvnd_1.4.0.orig.tar.gz' libglvnd_1.4.0.orig.tar.gz 838573 SHA512:2a1cf975a0453c4e3777e4380b1084d9d5ddfaf7fd96d97f7e503c1a3b46b2234245939626d5c816da8ad41b88dbf67ee0a8dbb7cc755852ed0b75a67caea8b0
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libglvnd/libglvnd_1.4.0-1.debian.tar.xz' libglvnd_1.4.0-1.debian.tar.xz 22264 SHA512:23cbdc9c0f9e960a5912ab4b9854da4b50f6dfdad9a233d0743bfd92f38b0d224ee02af3bfda1930e0315c912cd245acece4889d236be55e200e9346734d1aa6
```

### `dpkg` source package: `libgpg-error=1.43-3`

Binary Packages:

- `libgpg-error0:amd64=1.43-3`

Licenses: (parsed from: `/usr/share/doc/libgpg-error0/copyright`)

- `BSD-3-clause`
- `GPL-3`
- `GPL-3+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `g10-permissive`

Source:

```console
$ apt-get source -qq --print-uris libgpg-error=1.43-3
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgpg-error/libgpg-error_1.43-3.dsc' libgpg-error_1.43-3.dsc 2270 SHA512:c0cf8b16d720d89b69b5eb5cf22bf7bb0605892ba110100d3b30370fc93c167bda2f501e53e70a2599024bc40c1e509d06e39f68f3be63312967e4308249f0b8
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgpg-error/libgpg-error_1.43.orig.tar.bz2' libgpg-error_1.43.orig.tar.bz2 999006 SHA512:36769a62d0b4b219a6d58195bed692e34d3b0313f628b1036055ca34b69332edbe6bcdace9855a60d06e7be5998dc13bf1305d0b2bb211a4d8f701e85040961c
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgpg-error/libgpg-error_1.43.orig.tar.bz2.asc' libgpg-error_1.43.orig.tar.bz2.asc 238 SHA512:1bd12acc57bb394947dec51b70fe067f717e591484be164cafff3ac47a6bacc101f7ac64fbae350233bc76a0002981fb3fbe53db73dc914db52694b8588cecc1
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgpg-error/libgpg-error_1.43-3.debian.tar.xz' libgpg-error_1.43-3.debian.tar.xz 19264 SHA512:bbd7615b02707405efddd4bb1dee355024bb7089770453a2addf7e722c15c2cfbebc3012c9db848f3f55eb4c66f5b9487877e8d94322d8dc1d2731876b4d8281
```

### `dpkg` source package: `libhtml-form-perl=6.07-1`

Binary Packages:

- `libhtml-form-perl=6.07-1`

Licenses: (parsed from: `/usr/share/doc/libhtml-form-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libhtml-form-perl=6.07-1
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-form-perl/libhtml-form-perl_6.07-1.dsc' libhtml-form-perl_6.07-1.dsc 2425 SHA512:0e92a952677e5bbb7798baaf6f4fca6b7daa669dd818e9ceb31ae6107a5bdb006c256401387f244690ae6a7708762c042d6c3918f42cecdc2916e97c9b8201f3
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-form-perl/libhtml-form-perl_6.07.orig.tar.gz' libhtml-form-perl_6.07.orig.tar.gz 41503 SHA512:32aac4bb85609c2c596e771678bd4d36f3e34deaa3de7333f089c8f887045780db949b5a1573254557eb0247713232cca5e90f89a80e0d53049840660ad3017e
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-form-perl/libhtml-form-perl_6.07-1.debian.tar.xz' libhtml-form-perl_6.07-1.debian.tar.xz 2568 SHA512:e5f2da34a1254941d17905ae4016210e43d2fa2f6bd6c29096fe24ca4e6e72c2959ba3e675b905b07afe8741a96a03b9687b901308c4fea58ba375db8d871818
```

### `dpkg` source package: `libhtml-format-perl=2.12-1.1`

Binary Packages:

- `libhtml-format-perl=2.12-1.1`

Licenses: (parsed from: `/usr/share/doc/libhtml-format-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libhtml-format-perl=2.12-1.1
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-format-perl/libhtml-format-perl_2.12-1.1.dsc' libhtml-format-perl_2.12-1.1.dsc 2261 SHA512:262b2409834a38e711a1fcb9ecdacae0f7f2bccf349e663c68c41f9177086349af4cfc3b64ad40e42aa10b5208a712a534cbc3c9a0635db34c25e68a9ec9c18e
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-format-perl/libhtml-format-perl_2.12.orig.tar.gz' libhtml-format-perl_2.12.orig.tar.gz 50248 SHA512:38571caaa118e13d5d730e6c32e74a756b47d4d498918d7a844402a606285024a78f372d7ea534aee9a383bf94a83be376e1b143b54565bcace940be56f60802
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-format-perl/libhtml-format-perl_2.12-1.1.debian.tar.xz' libhtml-format-perl_2.12-1.1.debian.tar.xz 4032 SHA512:91d691f68344676e9c24eb5597dbf143d833e16530268559d0ec05cb3817700715ca0908c834617a52bc09542dd18bcf9879480d024303a9fb4cff9e1b78ba81
```

### `dpkg` source package: `libhtml-parser-perl=3.76-1build2`

Binary Packages:

- `libhtml-parser-perl:amd64=3.76-1build2`

Licenses: (parsed from: `/usr/share/doc/libhtml-parser-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libhtml-parser-perl=3.76-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-parser-perl/libhtml-parser-perl_3.76-1build2.dsc' libhtml-parser-perl_3.76-1build2.dsc 2327 SHA512:c9519e6402de3bdb3b60be587b66a1e4ef537b41885cc0cd0512ddde221bbc35a43a9b3e5fb73c6398d95e00f14f1ad7d0d4b462372bbc25e685ffc41d709e49
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-parser-perl/libhtml-parser-perl_3.76.orig.tar.gz' libhtml-parser-perl_3.76.orig.tar.gz 120473 SHA512:50f9dc01997afdef33b58b48bfabd596b09cc11086773dcb4707086b7d7f54d2234d508e11a0b17e5d62849bf6acbc16aa8cd53080329ad3dacdbbe877c2c88b
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-parser-perl/libhtml-parser-perl_3.76-1build2.debian.tar.xz' libhtml-parser-perl_3.76-1build2.debian.tar.xz 8252 SHA512:07107600769f443cc2889b0c13b80fd712b0a946faa40d556347adaa1ca6f9a5e1f9cdf37db79d4d071a85f1a5a582d7f830a32fd568b4fa71b43d1044851862
```

### `dpkg` source package: `libhtml-tagset-perl=3.20-4`

Binary Packages:

- `libhtml-tagset-perl=3.20-4`

Licenses: (parsed from: `/usr/share/doc/libhtml-tagset-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libhtml-tagset-perl=3.20-4
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-tagset-perl/libhtml-tagset-perl_3.20-4.dsc' libhtml-tagset-perl_3.20-4.dsc 2394 SHA512:c8fa8901454621f2e88abccdcdfd5702b2e956bd4f777e0e8a3b8575a739d1fdac8a626eeea3abc75362204bda61842fafe30d7dc45e7790630c374e12a34374
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-tagset-perl/libhtml-tagset-perl_3.20.orig.tar.gz' libhtml-tagset-perl_3.20.orig.tar.gz 8150 SHA512:b53c099a96b493c3d03c51fcf3d58dd3b830069583f2d07477175ea234c43e91a0b380c82a71126f971faf2768e832af34967d08d899db7653d65613d6530072
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-tagset-perl/libhtml-tagset-perl_3.20-4.debian.tar.xz' libhtml-tagset-perl_3.20-4.debian.tar.xz 3288 SHA512:1525bc428150c3503a2a78f4ace395e16abe2c024e799ae9dcc80c3aad7168b2c7b66f69e12a18632295002668fb2d97846db4c3958ef01061c7708f4ea447b4
```

### `dpkg` source package: `libhtml-tree-perl=5.07-2`

Binary Packages:

- `libhtml-tree-perl=5.07-2`

Licenses: (parsed from: `/usr/share/doc/libhtml-tree-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libhtml-tree-perl=5.07-2
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-tree-perl/libhtml-tree-perl_5.07-2.dsc' libhtml-tree-perl_5.07-2.dsc 2363 SHA512:049503efe3c2620823a842c2f28ef1ef8ce915753e011ae8968fd388ff8628c1a5104c7153909e8d98675314b439fb082d8ba835c075ce4c08a203a9000b9ae6
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-tree-perl/libhtml-tree-perl_5.07.orig.tar.gz' libhtml-tree-perl_5.07.orig.tar.gz 150477 SHA512:a1faaf547d7db323388d5f6b289ab96887de5a80add55aefd380e4b540948514550a86785bdccf0776dfff38085b6bd3e98228f96231264217adcfc2f132c5de
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-tree-perl/libhtml-tree-perl_5.07-2.debian.tar.xz' libhtml-tree-perl_5.07-2.debian.tar.xz 6184 SHA512:58b15a7f63b46dd497fcb76e197171164df89f30fe3cbd62cf95eb7491284e741904943398f73876e358998c78950b7bc05c0653f6300c3a99231817859979d2
```

### `dpkg` source package: `libhttp-cookies-perl=6.10-1`

Binary Packages:

- `libhttp-cookies-perl=6.10-1`

Licenses: (parsed from: `/usr/share/doc/libhttp-cookies-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libhttp-cookies-perl=6.10-1
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-cookies-perl/libhttp-cookies-perl_6.10-1.dsc' libhttp-cookies-perl_6.10-1.dsc 2444 SHA512:e3c7760a957bb072f9736ad4d705a3bd90d0fb330727a601de08efdbbfcb96e0a7129575f5a6ab40c734656dbad313206d77bddc343da93efcc4df27c92565e6
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-cookies-perl/libhttp-cookies-perl_6.10.orig.tar.gz' libhttp-cookies-perl_6.10.orig.tar.gz 42448 SHA512:c24a986e524ebf5d8b13b4580c3ee6aed018e79c203fd62208bfe970744482832fe9c41bb3195a596af1e11058053ed7615a09a26fbcef4433e270f0f5d38658
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-cookies-perl/libhttp-cookies-perl_6.10-1.debian.tar.xz' libhttp-cookies-perl_6.10-1.debian.tar.xz 2976 SHA512:f25be7a9c30c60d840f2ab88ded7bc72bbe919aec8978ecf5073e11b828ff58407e11da58a86cccb644baab77d711f1005c98451023e0a686b108310568bb521
```

### `dpkg` source package: `libhttp-daemon-perl=6.13-1ubuntu0.1`

Binary Packages:

- `libhttp-daemon-perl=6.13-1ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libhttp-daemon-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libhttp-daemon-perl=6.13-1ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-daemon-perl/libhttp-daemon-perl_6.13-1ubuntu0.1.dsc' libhttp-daemon-perl_6.13-1ubuntu0.1.dsc 2537 SHA512:f87a33d583b228b10f21b2de2b7cde8144c402972e6e1b6b84f3ff0a857eeb272b6809b6efeef43cfbd7f713659db9bdc4e27ddab2d1ca366294e656633280e0
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-daemon-perl/libhttp-daemon-perl_6.13.orig.tar.gz' libhttp-daemon-perl_6.13.orig.tar.gz 46828 SHA512:8f13d2aab9d6372a7c9af78aa114de487b6f5b99892adf6cc4d47901dd2c31efdd0b68c34995d42b30de35a130be9babb44789ce7725402460926f964b59fc17
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-daemon-perl/libhttp-daemon-perl_6.13-1ubuntu0.1.debian.tar.xz' libhttp-daemon-perl_6.13-1ubuntu0.1.debian.tar.xz 7300 SHA512:e7e8b5c4fa7375092bc54edf4893d3433ec341bb71e5e8683bf2978a535cd5fdd7bec19e5685ca8b088b79f89caf4e758c4a06edf3f04e18b18793a733c64a11
```

### `dpkg` source package: `libhttp-date-perl=6.05-1`

Binary Packages:

- `libhttp-date-perl=6.05-1`

Licenses: (parsed from: `/usr/share/doc/libhttp-date-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libhttp-date-perl=6.05-1
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-date-perl/libhttp-date-perl_6.05-1.dsc' libhttp-date-perl_6.05-1.dsc 2156 SHA512:d624fcd2a0bbec575b733491b3aa763e641391d1a53b03a8a71505768afb73db98a8a1cf2d9f7c744419e58b069de0945de9c0b873f5b7148bc46e2a81a1ed76
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-date-perl/libhttp-date-perl_6.05.orig.tar.gz' libhttp-date-perl_6.05.orig.tar.gz 29234 SHA512:28be8751a36782e78492889b5aa8bde89bb251db2a695456216841e2297c8ab9e977e9562840c5a2f4a59d19b5e5fb6ac907baa559b1239adcc9e36c5020f801
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-date-perl/libhttp-date-perl_6.05-1.debian.tar.xz' libhttp-date-perl_6.05-1.debian.tar.xz 2196 SHA512:cfb6a23f101fec14e4fdc8b9c0b0f5ed7c1bd46b8b9fc8df66311f0600168d40049d11e26800eed8e5c7faec82586e0d61c4611a71a2b0738214e6dcfb5e2297
```

### `dpkg` source package: `libhttp-message-perl=6.36-1`

Binary Packages:

- `libhttp-message-perl=6.36-1`

Licenses: (parsed from: `/usr/share/doc/libhttp-message-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libhttp-message-perl=6.36-1
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-message-perl/libhttp-message-perl_6.36-1.dsc' libhttp-message-perl_6.36-1.dsc 2621 SHA512:2e8840765b4c61e05766528b816374f038f60b979f104d515785356c1b7935c02e8d6bf51715b0b1a28e96321f2163ca73a61206845f3bbce2b487928e2cf222
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-message-perl/libhttp-message-perl_6.36.orig.tar.gz' libhttp-message-perl_6.36.orig.tar.gz 89937 SHA512:60b753395829027b52b78ce638e17650e17792c5b1427f34a0b4a71bacb127145da90a20f9e126b8dcd86ae8d555725e01f2baea76c52ddb8702455badf51055
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-message-perl/libhttp-message-perl_6.36-1.debian.tar.xz' libhttp-message-perl_6.36-1.debian.tar.xz 3464 SHA512:7b4dd703883e82847bf716d3236b52e2a5079ee83a40ebc893fe47cf5788cf3925685b93ea584667d1ec75b84f5aad11fbb4a2d32de536b8e7ae814aab83e71d
```

### `dpkg` source package: `libhttp-negotiate-perl=6.01-1`

Binary Packages:

- `libhttp-negotiate-perl=6.01-1`

Licenses: (parsed from: `/usr/share/doc/libhttp-negotiate-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libhttp-negotiate-perl=6.01-1
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-negotiate-perl/libhttp-negotiate-perl_6.01-1.dsc' libhttp-negotiate-perl_6.01-1.dsc 2293 SHA512:6fb38aefe18a0f47493014519e5b061d3976741ecc6596930ca49608b393f6611f34c9fcdef965b6c4744471a322d6a235b1fd66e0e416cd67650893f71d22f2
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-negotiate-perl/libhttp-negotiate-perl_6.01.orig.tar.gz' libhttp-negotiate-perl_6.01.orig.tar.gz 8596 SHA512:2651010f0d989fb255d37a0e4585de4779edcccd59fcad7d7f5ccc7d2c2ec420060324beebc880664d6c0d29193ce62f2d21cb6332bbfa0a3adacfa632876617
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-negotiate-perl/libhttp-negotiate-perl_6.01-1.debian.tar.xz' libhttp-negotiate-perl_6.01-1.debian.tar.xz 2116 SHA512:7a21e8eb4fbec3a949cbd6a74f3d58129619991a7686f1f1ff3bcc9899b444169754afac54d7f3757daaf57a0a324dbb2c406305509583cb921ad9882f7ec644
```

### `dpkg` source package: `libice=2:1.0.10-1build2`

Binary Packages:

- `libice6:amd64=2:1.0.10-1build2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libice=2:1.0.10-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libice/libice_1.0.10-1build2.dsc' libice_1.0.10-1build2.dsc 2181 SHA512:ab928645b15c679673d1adcc53f23b126f4ca90accbef677c15a1bb8bd428e642db5e45ef77b255d9b0351c2501dd01eafb9108875fff7c98f4543432d7e6fbf
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libice/libice_1.0.10.orig.tar.gz' libice_1.0.10.orig.tar.gz 481960 SHA512:2d4757f7325eb01180b5d7433cc350eb9606bd3afe82dabc8aa164feda75ef03a0624d74786e655c536c24a80d0ccb2f1e3ecbb04d3459b23f85455006ca8a91
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libice/libice_1.0.10-1build2.diff.gz' libice_1.0.10-1build2.diff.gz 11679 SHA512:dc850d9603ac04ffee3e2de1d2f9786520f6d9829f210649756fac705b6fe2797eda307d45283533342dd425317928fbb5f61d94bfe0fcadbc8f1c0c2cb02d6c
```

### `dpkg` source package: `libidn2=2.3.2-2build1`

Binary Packages:

- `libidn2-0:amd64=2.3.2-2build1`

Licenses: (parsed from: `/usr/share/doc/libidn2-0/copyright`)

- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `LGPL-3`
- `LGPL-3+`
- `Unicode`

Source:

```console
$ apt-get source -qq --print-uris libidn2=2.3.2-2build1
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libidn2/libidn2_2.3.2-2build1.dsc' libidn2_2.3.2-2build1.dsc 2655 SHA512:bc84158420d526a0f9bca79ca2a8291c55588e2773ded66d7c4b86ad33b370f9d8723cfc3a2b278660de7060687fff5448912e802d7fb63a8ff7876b38440f32
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libidn2/libidn2_2.3.2.orig.tar.gz' libidn2_2.3.2.orig.tar.gz 2169556 SHA512:958dbf49a47a84c7627ac182f4cc8ea452696cec3f0d1ff102a6c48e89893e772b2aa81f75da8223dfc6326515cca3ae085268fbf997828de9330c3a351152f1
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libidn2/libidn2_2.3.2.orig.tar.gz.asc' libidn2_2.3.2.orig.tar.gz.asc 488 SHA512:0559b51b37c7937f3e1f8bf9de9b193f137f16b79d6673f85691a4f4a12ec132568e913848a70136f8522118817f7ecaa8432d353a5eff6b99a7be8719421fe0
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libidn2/libidn2_2.3.2-2build1.debian.tar.xz' libidn2_2.3.2-2build1.debian.tar.xz 15972 SHA512:d5af028cc405d326c31e67e577ef16d9b8b81e433171220fda2c2a6f8fc982a63b6d1d85c6595f5ce01a5005768d935aeeaa5de8a552990f4e070bc541e78570
```

### `dpkg` source package: `libio-html-perl=1.004-2`

Binary Packages:

- `libio-html-perl=1.004-2`

Licenses: (parsed from: `/usr/share/doc/libio-html-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris libio-html-perl=1.004-2
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libio-html-perl/libio-html-perl_1.004-2.dsc' libio-html-perl_1.004-2.dsc 2299 SHA512:df99a2245e1fb8560e4cd002e45d4e3defbf8830d1b58e8eb324493bf0e6ee02967fa347f17752261ddea90655d972ab0a5b2e4fc146cb579a9eb21bb863c8ec
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libio-html-perl/libio-html-perl_1.004.orig.tar.gz' libio-html-perl_1.004.orig.tar.gz 20927 SHA512:564fba7cfb50ef1cc78fa9e2b2200a20e305d098b8ceeb6f8478f0275cc48e4fb069386f5c318bc9deb43a5d590a78a995c04100bd440340f5c990eadc76a70f
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libio-html-perl/libio-html-perl_1.004-2.debian.tar.xz' libio-html-perl_1.004-2.debian.tar.xz 3500 SHA512:8c18360169ec3db0b763d841f1800a170ba8b4f20157d7fd7dcf11b8b5102a512828c8e704c233f83bc789b7b7de5fe6e147352abf8f00e43207c2a3c5237163
```

### `dpkg` source package: `libio-socket-ssl-perl=2.074-2`

Binary Packages:

- `libio-socket-ssl-perl=2.074-2`

Licenses: (parsed from: `/usr/share/doc/libio-socket-ssl-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libio-socket-ssl-perl=2.074-2
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libio-socket-ssl-perl/libio-socket-ssl-perl_2.074-2.dsc' libio-socket-ssl-perl_2.074-2.dsc 2865 SHA512:864c982b8315f365382d463d0786130a5870f654ef5c97fcd9b33164d382b84cbf86c257d7e76685f1b81ed15cc7bb31f47970e56749f68ce2baefe5856ad30c
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libio-socket-ssl-perl/libio-socket-ssl-perl_2.074.orig.tar.gz' libio-socket-ssl-perl_2.074.orig.tar.gz 252821 SHA512:cafbf11a986b8fb5ce06bdf1e7a83741e2eef74d4bf054f0e0cd490959eddf54d32d3d4e786de52750dccc07139d8a1b5d5979080d0f1c1464e0004ccf98a6b0
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libio-socket-ssl-perl/libio-socket-ssl-perl_2.074-2.debian.tar.xz' libio-socket-ssl-perl_2.074-2.debian.tar.xz 10748 SHA512:65546d839685a7a54278e568e775122ae6f639cccfd9f6d197c21ce5a82c371f710dc6537737f4a7423e5b962f0ce6b3be1ff1c528f02f6a509b4d39a5b9b78f
```

### `dpkg` source package: `libipc-system-simple-perl=1.30-1`

Binary Packages:

- `libipc-system-simple-perl=1.30-1`

Licenses: (parsed from: `/usr/share/doc/libipc-system-simple-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libipc-system-simple-perl=1.30-1
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libipc-system-simple-perl/libipc-system-simple-perl_1.30-1.dsc' libipc-system-simple-perl_1.30-1.dsc 2515 SHA512:3bf7b23bc08dcea1c736a1ae58c376721a1c1d548679853604c2dba2f67c520afbdf69db9e6e9475e9468461b52689bb7d52f22ff33b385d769fc3bcf97b46c5
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libipc-system-simple-perl/libipc-system-simple-perl_1.30.orig.tar.gz' libipc-system-simple-perl_1.30.orig.tar.gz 31902 SHA512:82937df80ae38a9c21e43e256a21cdac1482d4a069eae282043d676ece06251a7139b752cd2b379a0f69ea9209ddd075607da86c6cb9b25f19cf90d91c28d72f
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libipc-system-simple-perl/libipc-system-simple-perl_1.30-1.debian.tar.xz' libipc-system-simple-perl_1.30-1.debian.tar.xz 3340 SHA512:4d72f15713e0a8ac1265e1f60cccf8fdf2d25a6583a38bffe4f0c7c3ef297f5ad91011678f10a1cc10a87e9679f6c7eeeba7347d193b14064d086229cdc6d648
```

### `dpkg` source package: `libjpeg-turbo=2.1.2-0ubuntu1`

Binary Packages:

- `libjpeg-turbo8:amd64=2.1.2-0ubuntu1`
- `libjpeg-turbo8-dev:amd64=2.1.2-0ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libjpeg-turbo8/copyright`, `/usr/share/doc/libjpeg-turbo8-dev/copyright`)

- `JPEG`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libjpeg-turbo=2.1.2-0ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/libj/libjpeg-turbo/libjpeg-turbo_2.1.2-0ubuntu1.dsc' libjpeg-turbo_2.1.2-0ubuntu1.dsc 1690 SHA512:401a75e62575352db079bd268f00f94c8ea1e8e6c38bda852628729e6dfd3135804e3c9ee5b18b1254fed827e6073b0078553bcbc2c1df30d628bbb717a5ed47
'http://archive.ubuntu.com/ubuntu/pool/main/libj/libjpeg-turbo/libjpeg-turbo_2.1.2.orig.tar.gz' libjpeg-turbo_2.1.2.orig.tar.gz 2257645 SHA512:172c3d8bdad62c32c4560754422fb36f0e80c8316e44d08708f0cba8ee9fd0830f5295d380de34d0f90ec07df6ab4dbe2f0c8451bc60553371c022c9077447c2
'http://archive.ubuntu.com/ubuntu/pool/main/libj/libjpeg-turbo/libjpeg-turbo_2.1.2-0ubuntu1.debian.tar.xz' libjpeg-turbo_2.1.2-0ubuntu1.debian.tar.xz 17240 SHA512:5cfc1e73012f3251e385f0288dece2e3862977fb3975c61c344afc464a2fd329c3fa027fc07edc40097afaad052bdf6f0dad55c665c20ccdde9f2231ec191410
```

### `dpkg` source package: `libjpeg8-empty=8c-2ubuntu10`

Binary Packages:

- `libjpeg-dev:amd64=8c-2ubuntu10`
- `libjpeg8:amd64=8c-2ubuntu10`
- `libjpeg8-dev:amd64=8c-2ubuntu10`

Licenses: (parsed from: `/usr/share/doc/libjpeg-dev/copyright`, `/usr/share/doc/libjpeg8/copyright`, `/usr/share/doc/libjpeg8-dev/copyright`)

- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libjpeg8-empty=8c-2ubuntu10
'http://archive.ubuntu.com/ubuntu/pool/main/libj/libjpeg8-empty/libjpeg8-empty_8c-2ubuntu10.dsc' libjpeg8-empty_8c-2ubuntu10.dsc 1655 SHA512:1085be8a159c716c4ca89e6bfb2b1a5ce7b66ad8bc8f4cf3796c2c4ac3dad5169ac5be045f2a9ce103858b42585b1ce52d6dc6986995d073785170d45fe4d29d
'http://archive.ubuntu.com/ubuntu/pool/main/libj/libjpeg8-empty/libjpeg8-empty_8c-2ubuntu10.tar.gz' libjpeg8-empty_8c-2ubuntu10.tar.gz 1912 SHA512:1c21044013df62225f861ec6f88b2a43e0f6254522ed379ad081b92f4f89b64686d4e68d70e8384289cd8222df2288400c2d0e8b8ccae87dd079164bdc3f3cf3
```

### `dpkg` source package: `libksba=1.6.0-2ubuntu0.2`

Binary Packages:

- `libksba8:amd64=1.6.0-2ubuntu0.2`

Licenses: (parsed from: `/usr/share/doc/libksba8/copyright`)

- `FSFUL`
- `GPL-3`
- `LGPL-2.1-or-later`

Source:

```console
$ apt-get source -qq --print-uris libksba=1.6.0-2ubuntu0.2
'http://archive.ubuntu.com/ubuntu/pool/main/libk/libksba/libksba_1.6.0-2ubuntu0.2.dsc' libksba_1.6.0-2ubuntu0.2.dsc 2585 SHA512:ef96729e570627b7cf38ed0dcc3338097a81f690dde041fd9ea63b3c4b55c11ccf35ab7b2bbd196af3ca7834f8e5017cbb14436a7718034608f3276ca3db9f3f
'http://archive.ubuntu.com/ubuntu/pool/main/libk/libksba/libksba_1.6.0.orig.tar.bz2' libksba_1.6.0.orig.tar.bz2 662120 SHA512:a7c76d41dfd8ec6383ac2de3c53848cd9f066b538f6f3cd43175e3c8095df51b96d0a24a573481c0c4856b09b7c224e2b562d88f5c0801e7acfb582ea2739c2b
'http://archive.ubuntu.com/ubuntu/pool/main/libk/libksba/libksba_1.6.0.orig.tar.bz2.asc' libksba_1.6.0.orig.tar.bz2.asc 228 SHA512:fc381ea66eefdb431a5248fa3ac0751d7343d7f99cc7ebf7621b0763e6e31a80b45c5e17b09bbc7c1c1154e6a0152af1f13798f64959ac63f50b789ec046d7a3
'http://archive.ubuntu.com/ubuntu/pool/main/libk/libksba/libksba_1.6.0-2ubuntu0.2.debian.tar.xz' libksba_1.6.0-2ubuntu0.2.debian.tar.xz 16004 SHA512:24a609ca522b5e3a1402ff5a97ce451869bdf0960902d171a89f2190d4de7c8442403d21f938cebeeafd0ae082bf03d76c0521b26a2c153257df784cf7894b43
```

### `dpkg` source package: `liblocale-gettext-perl=1.07-4build3`

Binary Packages:

- `liblocale-gettext-perl=1.07-4build3`

Licenses: (parsed from: `/usr/share/doc/liblocale-gettext-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris liblocale-gettext-perl=1.07-4build3
'http://archive.ubuntu.com/ubuntu/pool/main/libl/liblocale-gettext-perl/liblocale-gettext-perl_1.07-4build3.dsc' liblocale-gettext-perl_1.07-4build3.dsc 2219 SHA512:7b4b2123105bd31a79dbc615180e8fb3c91dd690588ee58b971534ef1482bfd427042b6ddad00fedcee6de63052234d335266a81671ee4e7a7e3178241c4395f
'http://archive.ubuntu.com/ubuntu/pool/main/libl/liblocale-gettext-perl/liblocale-gettext-perl_1.07.orig.tar.gz' liblocale-gettext-perl_1.07.orig.tar.gz 8651 SHA512:d3716a597d586ee2ff29472ca7b13aaf67770299de31e5f12abafebc879bbe4a1e1dbc0025cf4f3dc29992955f26cffc3be387d974c3911af095d5b49e67a1c6
'http://archive.ubuntu.com/ubuntu/pool/main/libl/liblocale-gettext-perl/liblocale-gettext-perl_1.07-4build3.debian.tar.xz' liblocale-gettext-perl_1.07-4build3.debian.tar.xz 5488 SHA512:8a29b03413ec33bf916c4777a13fb7e74c8988a4b29f59fcddc41057d761436e82f980e3ae00432b4f50db878748544deb92eedf226d42b773a64afd732aded7
```

### `dpkg` source package: `liblwp-mediatypes-perl=6.04-1`

Binary Packages:

- `liblwp-mediatypes-perl=6.04-1`

Licenses: (parsed from: `/usr/share/doc/liblwp-mediatypes-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris liblwp-mediatypes-perl=6.04-1
'http://archive.ubuntu.com/ubuntu/pool/main/libl/liblwp-mediatypes-perl/liblwp-mediatypes-perl_6.04-1.dsc' liblwp-mediatypes-perl_6.04-1.dsc 2167 SHA512:11e5f8447d2b0cbc00c1563a6d0228592dabafb0dbbc8a59acd85a865a068eba65f78dcbfc2772023ea9f1c7fd163298a8e0c984800921a552e8f79008db25a1
'http://archive.ubuntu.com/ubuntu/pool/main/libl/liblwp-mediatypes-perl/liblwp-mediatypes-perl_6.04.orig.tar.gz' liblwp-mediatypes-perl_6.04.orig.tar.gz 40000 SHA512:0610627ef3efdfde3c89bad273931c9cbde5c6da0bd782d59ce26dc4445cd538be9041d722f08206d96d69d5e3643b15150ef29b9e92e3968833f2ae1b6dc53f
'http://archive.ubuntu.com/ubuntu/pool/main/libl/liblwp-mediatypes-perl/liblwp-mediatypes-perl_6.04-1.debian.tar.xz' liblwp-mediatypes-perl_6.04-1.debian.tar.xz 2244 SHA512:b7b30ce6f5434340ea69b513aca9ac51cb7f4be909a2413a77635b8a8ffccd78f23b789076bf4664ae6f1c464237e9c102190e5496799a234a28261eaf8c5562
```

### `dpkg` source package: `liblwp-protocol-https-perl=6.10-1`

Binary Packages:

- `liblwp-protocol-https-perl=6.10-1`

Licenses: (parsed from: `/usr/share/doc/liblwp-protocol-https-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris liblwp-protocol-https-perl=6.10-1
'http://archive.ubuntu.com/ubuntu/pool/main/libl/liblwp-protocol-https-perl/liblwp-protocol-https-perl_6.10-1.dsc' liblwp-protocol-https-perl_6.10-1.dsc 2625 SHA512:c13ba859039eefd70b59dab4f3a6e67f252d96e10405e94abcb67775acee99bd17d9d28f010a54911434df0ce42dc7ed406a8298fc079d0c47f8a649c394595e
'http://archive.ubuntu.com/ubuntu/pool/main/libl/liblwp-protocol-https-perl/liblwp-protocol-https-perl_6.10.orig.tar.gz' liblwp-protocol-https-perl_6.10.orig.tar.gz 33691 SHA512:4d3c89dab6fadcb574c176977ca6debba177ee3f817e87319d9cd81e0a0b09214e271c2e97edc456dad2f4a1ebf8c6266a4ae52c3a93144880a5b32db97e7a31
'http://archive.ubuntu.com/ubuntu/pool/main/libl/liblwp-protocol-https-perl/liblwp-protocol-https-perl_6.10-1.debian.tar.xz' liblwp-protocol-https-perl_6.10-1.debian.tar.xz 4800 SHA512:9f69e374230279f3e202308b375292c5c75ce06326c37fbd5cb3132859b09651f32806f0961ed0439ef1ca6a40f8bdd119713540178a7dca50a4f5d20c1649e7
```

### `dpkg` source package: `libmailtools-perl=2.21-1`

Binary Packages:

- `libmailtools-perl=2.21-1`

Licenses: (parsed from: `/usr/share/doc/libmailtools-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libmailtools-perl=2.21-1
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmailtools-perl/libmailtools-perl_2.21-1.dsc' libmailtools-perl_2.21-1.dsc 2326 SHA512:18c3d02b53f4589620784431396499e5d3c65b0ca0a0377f6bceb2659dc7a958da7f5215a343639503af61498863544ac72cd9b3c3d643d91a1a28a2666a3d29
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmailtools-perl/libmailtools-perl_2.21.orig.tar.gz' libmailtools-perl_2.21.orig.tar.gz 58013 SHA512:70c7e5760691a1fc0a2812c48a632896db9bf719d3cb07a63c3a4456c5a365855c7f71c7436c84e5085374628f26ad31fcf13e74b3b7242911da59b7916065a0
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmailtools-perl/libmailtools-perl_2.21-1.debian.tar.xz' libmailtools-perl_2.21-1.debian.tar.xz 6808 SHA512:b29a897bcd7982945f8f08f1469f223ed406464b97952134fd969c8f02167a111f021e3b35384a7ad8aa3ab1d33e7bd83e96a2548e8a69abd4fb4450573f1da6
```

### `dpkg` source package: `libmaxminddb=1.5.2-1build2`

Binary Packages:

- `libmaxminddb0:amd64=1.5.2-1build2`

Licenses: (parsed from: `/usr/share/doc/libmaxminddb0/copyright`)

- `Apache-2.0`
- `BSD-2-clause`
- `BSD-3-clause`
- `BSD-4-clause`
- `CC-BY-SA-3.0`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris libmaxminddb=1.5.2-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmaxminddb/libmaxminddb_1.5.2-1build2.dsc' libmaxminddb_1.5.2-1build2.dsc 2454 SHA512:7e7166e405d886d2f8f4a29c0e4c4920d86d1cce2e453cc97e8185a67a7baeadf51a77c313a0bb896342ecb9b77c80733e3ca1641c8bdf0a8f234d49addb69fd
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmaxminddb/libmaxminddb_1.5.2.orig.tar.gz' libmaxminddb_1.5.2.orig.tar.gz 249507 SHA512:2f053028e28dc4f1d94039e52193ab71f8dc278f1fafa14bca1af0251d239351acadb5d540e63c250232d0fd1b8f2dd45289f0eae5c55d9b4430acbabbcd11a9
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmaxminddb/libmaxminddb_1.5.2-1build2.debian.tar.xz' libmaxminddb_1.5.2-1build2.debian.tar.xz 12488 SHA512:1017b70ee85f22eed14258a4d594d77e5bf6fbe5dcb0a23e635f0dcb26d09eb173dd777063f695f9610350dab91b8717ae4d701c3b1eb282358d6450394a0889
```

### `dpkg` source package: `libmd=1.0.4-1build1`

Binary Packages:

- `libmd0:amd64=1.0.4-1build1`

Licenses: (parsed from: `/usr/share/doc/libmd0/copyright`)

- `BSD-2-clause`
- `BSD-2-clause-NetBSD`
- `BSD-3-clause`
- `BSD-3-clause-Aaron-D-Gifford`
- `Beerware`
- `ISC`
- `public-domain-md4`
- `public-domain-md5`
- `public-domain-sha1`

Source:

```console
$ apt-get source -qq --print-uris libmd=1.0.4-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmd/libmd_1.0.4-1build1.dsc' libmd_1.0.4-1build1.dsc 2380 SHA512:778b562e6b3860fe6a6d5ddf4d7cce381126be77d151ac7c2a619d57737080f2adc07ff8e01fcafd98b3ace157fc72ab77a572362b56e79e5abb79a99fdacd6c
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmd/libmd_1.0.4.orig.tar.xz' libmd_1.0.4.orig.tar.xz 264472 SHA512:731553ecc5e0e1eb228cced8fccd531fe31fb5c7627ca30013d287e1aeb8222959cf7498fbb7414bbabb967b25d4e8b0edd54fc47f6ccf55fc91087db0725ce3
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmd/libmd_1.0.4.orig.tar.xz.asc' libmd_1.0.4.orig.tar.xz.asc 833 SHA512:ec4b60a721da1f315fad73daa8ee620f44a53f17a30506c4d63b154b3abde19bb248b2ce6b83b989589e2a9184ebbe1b870e83181e18a4147d75617579d10504
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmd/libmd_1.0.4-1build1.debian.tar.xz' libmd_1.0.4-1build1.debian.tar.xz 10264 SHA512:0e287498326a5aa3bc95cb0c576df7d0bb289bfb9db3a1f812d0e202c61af9dc78ecfa4b6b26c2dee3c5ccbefad877919f44ec849b3300f0f30878080eb5cb13
```

### `dpkg` source package: `libnet-dbus-perl=1.2.0-1build3`

Binary Packages:

- `libnet-dbus-perl=1.2.0-1build3`

Licenses: (parsed from: `/usr/share/doc/libnet-dbus-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libnet-dbus-perl=1.2.0-1build3
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-dbus-perl/libnet-dbus-perl_1.2.0-1build3.dsc' libnet-dbus-perl_1.2.0-1build3.dsc 2279 SHA512:5c6f90fa4dc68d9fc66973ba2ff18d6fb08f68d9e6e0576956e74f1a1c9b60ebffb1f6ce69474017155f4148c3e86c18138eacf097e9417c0d2ce3736b727ca8
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-dbus-perl/libnet-dbus-perl_1.2.0.orig.tar.gz' libnet-dbus-perl_1.2.0.orig.tar.gz 108296 SHA512:9dc95288ae81037985020e18db33331de6908b1280fc3b0ca898c183a5b577d21d240f4f1045393f9459a9be6e3425feffa9ea581e6af2bcf165cdf48348b255
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-dbus-perl/libnet-dbus-perl_1.2.0-1build3.debian.tar.xz' libnet-dbus-perl_1.2.0-1build3.debian.tar.xz 3924 SHA512:d26129fc80a6418d07a25c773cf320e3dc318a65d622dd95df356e52225a42466c2a751bd00dc386af563663bf116d90eb8e81bb9bcd9aee1d1fefe670fa1b54
```

### `dpkg` source package: `libnet-http-perl=6.22-1`

Binary Packages:

- `libnet-http-perl=6.22-1`

Licenses: (parsed from: `/usr/share/doc/libnet-http-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libnet-http-perl=6.22-1
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-http-perl/libnet-http-perl_6.22-1.dsc' libnet-http-perl_6.22-1.dsc 2418 SHA512:a77af7dfbe193d9f852c73ba8872381ba07031e5ec81cb90854a0ee947651b4bcf7bc5000c2bf4f685077a7278ae901365e84895dfe9d932b5e31713cf4d726c
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-http-perl/libnet-http-perl_6.22.orig.tar.gz' libnet-http-perl_6.22.orig.tar.gz 39087 SHA512:8d0af85baee8a3b257995c6dd277c2eb578d1feeec89f3e4be0548959d2cf07934764d9d16a542a50f72a4611e3f4b6335ff7e969a28cd74fbb0ec3961588131
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-http-perl/libnet-http-perl_6.22-1.debian.tar.xz' libnet-http-perl_6.22-1.debian.tar.xz 3712 SHA512:1dcc4cd914d2e4ac7533d101627fbf23bf0c7e2728f9766da15db4cc2a9f9b39edbbcc766e90aa039ed36d508bebbfb51ba0217e952a0f8c7f9c21fc1daf6662
```

### `dpkg` source package: `libnet-smtp-ssl-perl=1.04-1`

Binary Packages:

- `libnet-smtp-ssl-perl=1.04-1`

Licenses: (parsed from: `/usr/share/doc/libnet-smtp-ssl-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libnet-smtp-ssl-perl=1.04-1
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-smtp-ssl-perl/libnet-smtp-ssl-perl_1.04-1.dsc' libnet-smtp-ssl-perl_1.04-1.dsc 2268 SHA512:fc4af92d9d9a3dd6dabaef2a4b163d434912eb7a603e0cf3fb767b388cb17c6e17aa134612882a60f599d1bdcc35c1de6883d1c29e6304832e189dd982889a93
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-smtp-ssl-perl/libnet-smtp-ssl-perl_1.04.orig.tar.gz' libnet-smtp-ssl-perl_1.04.orig.tar.gz 2457 SHA512:dfbf59e5d895add19f5684c999c941ab56a58be39492a02e5a9bdac47039bf388279eda734c6b0422d228ac14efed899b3572561e6a34cfd9582423252efb509
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-smtp-ssl-perl/libnet-smtp-ssl-perl_1.04-1.debian.tar.xz' libnet-smtp-ssl-perl_1.04-1.debian.tar.xz 2696 SHA512:255f08ceaec608380ba711f35f40f8e86f25ad60c0c2e1f768233310ac80851625c33c2bb345351da26eb665e57ee854ee5d76d5516cc1c6f893effadd5e5e15
```

### `dpkg` source package: `libnet-ssleay-perl=1.92-1build2`

Binary Packages:

- `libnet-ssleay-perl:amd64=1.92-1build2`

Licenses: (parsed from: `/usr/share/doc/libnet-ssleay-perl/copyright`)

- `Artistic`
- `Artistic-2.0`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libnet-ssleay-perl=1.92-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-ssleay-perl/libnet-ssleay-perl_1.92-1build2.dsc' libnet-ssleay-perl_1.92-1build2.dsc 2360 SHA512:6961856d64d74a9e821b4b8202946806a348061e20739afa8600ef6d072929cd21122766d74525a7103577ace739a0a129708d15f226fda3c31c6902b8577a19
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-ssleay-perl/libnet-ssleay-perl_1.92.orig.tar.gz' libnet-ssleay-perl_1.92.orig.tar.gz 555930 SHA512:e9d9161ebeb7be90f4c7a0ea98f1034892ce6d33aa72872683177b19daa1f4c5819f85ea9a052a076ec8d7c21705f6c344aef64680bc881bf3218d38e8b7b173
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-ssleay-perl/libnet-ssleay-perl_1.92-1build2.debian.tar.xz' libnet-ssleay-perl_1.92-1build2.debian.tar.xz 11608 SHA512:537555515697aa40ada7e9df328e3acefb9c55434bc49c4ffd297f32dd0062c2d27d62131fc29f34e02e7f456bc18a57ee81ac711d88c4efa7354a7855d26f85
```

### `dpkg` source package: `libnsl=1.3.0-2build2`

Binary Packages:

- `libnsl-dev:amd64=1.3.0-2build2`
- `libnsl2:amd64=1.3.0-2build2`

Licenses: (parsed from: `/usr/share/doc/libnsl-dev/copyright`, `/usr/share/doc/libnsl2/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2+-autoconf-exception`
- `GPL-2+-libtool-exception`
- `GPL-3`
- `GPL-3+-autoconf-exception`
- `LGPL-2.1`
- `LGPL-2.1+`
- `MIT`
- `permissive-autoconf-m4`
- `permissive-autoconf-m4-no-warranty`
- `permissive-configure`
- `permissive-fsf`
- `permissive-makefile-in`

Source:

```console
$ apt-get source -qq --print-uris libnsl=1.3.0-2build2
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnsl/libnsl_1.3.0-2build2.dsc' libnsl_1.3.0-2build2.dsc 2087 SHA512:f13d28f34b0e71b04b5a0313b1cc79cdbe7d5e7f910d649af63b42824654e3cf01c02caa0e68309cb03350a17506e034800af1b1e3ab9af99fb64121c119215c
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnsl/libnsl_1.3.0.orig.tar.xz' libnsl_1.3.0.orig.tar.xz 321488 SHA512:a5a6c3ccb2d1e724c8c1f65e55dcd09383eb1ae019c55f4c09441eadf23ffbc2196cfad259805b0ac40ddf3a10af0da453e4d739d67d46829c64d0995dab4e55
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnsl/libnsl_1.3.0-2build2.debian.tar.xz' libnsl_1.3.0-2build2.debian.tar.xz 4868 SHA512:367904106ba925eaa667cc273b37afd052ba795b7ed004cdb501c13dd26b469df971ac10acec2bf57d91fa4839f356c7dcbcd4969914891152588365844ced9a
```

### `dpkg` source package: `libpaper=1.1.28build2`

Binary Packages:

- `libpaper-utils=1.1.28build2`
- `libpaper1:amd64=1.1.28build2`

Licenses: (parsed from: `/usr/share/doc/libpaper-utils/copyright`, `/usr/share/doc/libpaper1/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris libpaper=1.1.28build2
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpaper/libpaper_1.1.28build2.dsc' libpaper_1.1.28build2.dsc 1736 SHA512:a0d06d6a23524e976ba8943c808c65dfbb137ce9235cc66ec9a439ff7ef3215b9ca1381846e81b79fc07706db909d0d9cc599bed0ca656930cba100fc4928576
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpaper/libpaper_1.1.28build2.tar.gz' libpaper_1.1.28build2.tar.gz 43246 SHA512:e8bb01c06ec6e9da24dbf142c22c7afd87cc9746a9a63408fed11d3815a2c13912fd7633ccd4479af12a74712d2998372ad02e38964411f15b4142e907b5e455
```

### `dpkg` source package: `libpciaccess=0.16-3`

Binary Packages:

- `libpciaccess0:amd64=0.16-3`

Licenses: (parsed from: `/usr/share/doc/libpciaccess0/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris libpciaccess=0.16-3
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpciaccess/libpciaccess_0.16-3.dsc' libpciaccess_0.16-3.dsc 2291 SHA512:02fff14cb7c21619998bc5f6a67e20866ddd7f7e06ca6e328abb224368b23bc4fc60c18a646eb4d91b70d389354d20a0ca7799cb331eb51fdb77c4d654bc772d
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpciaccess/libpciaccess_0.16.orig.tar.gz' libpciaccess_0.16.orig.tar.gz 470061 SHA512:ed5fe0d8bf59155f5f06ed39793179549d6f604280a93019623109c8bc0d19409e15dad51277ac7711d8e1f0aa37eee0d6a029b084160dca2e6e03874bc07590
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpciaccess/libpciaccess_0.16.orig.tar.gz.asc' libpciaccess_0.16.orig.tar.gz.asc 659 SHA512:2ce1e5c092e26d8d6da8f32b20e51c28f87583b2cc821248d9fd4183890b1ac5bef171dce30a5c8612dd75cf10e7070a02ed117c67bd04f9a3659a27a3774e1a
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpciaccess/libpciaccess_0.16-3.diff.gz' libpciaccess_0.16-3.diff.gz 28681 SHA512:31f4791421ef020d283c419ca5c8829250ba8d365d2176c18652495601bb87d8be7c530f72b3c7cf9527168081cb77355e6e94348e41c609ddb396f5e691af8c
```

### `dpkg` source package: `libpng1.6=1.6.37-3build5`

Binary Packages:

- `libpng-dev:amd64=1.6.37-3build5`
- `libpng-tools=1.6.37-3build5`
- `libpng16-16:amd64=1.6.37-3build5`

Licenses: (parsed from: `/usr/share/doc/libpng-dev/copyright`, `/usr/share/doc/libpng-tools/copyright`, `/usr/share/doc/libpng16-16/copyright`)

- `Apache-2.0`
- `BSD-3-clause`
- `BSD-like-with-advertising-clause`
- `GPL-2`
- `GPL-2+`
- `expat`
- `libpng`
- `libpng OR Apache-2.0 OR BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris libpng1.6=1.6.37-3build5
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpng1.6/libpng1.6_1.6.37-3build5.dsc' libpng1.6_1.6.37-3build5.dsc 2357 SHA512:8628c50bf667f1b7134192cbaf7b9c7fc00d6c264027092ea3aaee089497ed7e417a63c824245945a5169000dd56d0787f4538f5563ef312b1be381766cadea0
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpng1.6/libpng1.6_1.6.37.orig.tar.gz' libpng1.6_1.6.37.orig.tar.gz 1508805 SHA512:ccb3705c23b2724e86d072e2ac8cfc380f41fadfd6977a248d588a8ad57b6abe0e4155e525243011f245e98d9b7afbe2e8cc7fd4ff7d82fcefb40c0f48f88918
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpng1.6/libpng1.6_1.6.37-3build5.debian.tar.xz' libpng1.6_1.6.37-3build5.debian.tar.xz 32492 SHA512:58be3d57602b2c6d6d2788e16de69505cf54a381b51fbd3a1338b9708ed576965975b3994c5946231fe75055a323649667edf8971b3d4d3d736457609fca0770
```

### `dpkg` source package: `libpsl=0.21.0-1.2build2`

Binary Packages:

- `libpsl5:amd64=0.21.0-1.2build2`

Licenses: (parsed from: `/usr/share/doc/libpsl5/copyright`)

- `Chromium`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris libpsl=0.21.0-1.2build2
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpsl/libpsl_0.21.0-1.2build2.dsc' libpsl_0.21.0-1.2build2.dsc 2348 SHA512:28ff7399af2290fd447f781b1f799ba5cb8c0cb794833c40d8f16cc81b0abd4f77bd9dc990c7925e8be8832555f07cc6ede80f971b68ac5fc6e644d601e582b6
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpsl/libpsl_0.21.0.orig.tar.gz' libpsl_0.21.0.orig.tar.gz 8598583 SHA512:b7466edb9763f94a65330dbb3c19586f9c7b01e20ddedb38ca2fd4c9ee5764a4f9b3291dc4b76659b45425d954f15973345f917b2cd2de72ea731e8c41f2a265
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpsl/libpsl_0.21.0-1.2build2.debian.tar.xz' libpsl_0.21.0-1.2build2.debian.tar.xz 12896 SHA512:9d8c7130bee8c521e4f1ab1e13edfe2ed2fec538bda9133662d4120e8f5303595e6f27f466f30b07e61b94e138dd2787e17af91b8cc29275b5b4d2e098133eee
```

### `dpkg` source package: `librsvg=2.52.5+dfsg-3ubuntu0.2`

Binary Packages:

- `librsvg2-2:amd64=2.52.5+dfsg-3ubuntu0.2`
- `librsvg2-common:amd64=2.52.5+dfsg-3ubuntu0.2`

Licenses: (parsed from: `/usr/share/doc/librsvg2-2/copyright`, `/usr/share/doc/librsvg2-common/copyright`)

- `0BSD`
- `0BSD,`
- `Apache-2.0`
- `Apache-2.0,`
- `BSD-2-clause`
- `BSD-2-clause,`
- `BSD-3-clause`
- `BSD-3-clause,`
- `Boost-1.0`
- `Boost-1.0,`
- `CC-BY-3.0`
- `CC-zero-waive-1.0-us`
- `Expat`
- `Expat,`
- `FSFAP`
- `LGPL-2`
- `LGPL-2+`
- `MPL-2.0`
- `MPL-2.0,`
- `OFL-1.1`
- `Sun-permissive`
- `Sun-permissive,`
- `Unlicense`
- `Unlicense,`
- `zlib`

Source:

```console
$ apt-get source -qq --print-uris librsvg=2.52.5+dfsg-3ubuntu0.2
'http://archive.ubuntu.com/ubuntu/pool/main/libr/librsvg/librsvg_2.52.5%2bdfsg-3ubuntu0.2.dsc' librsvg_2.52.5+dfsg-3ubuntu0.2.dsc 3126 SHA512:de08f845fd7b27d57369a01ec7a6d15063af5fbc39d35d306c40354b2254dca4e2721f98bec5ed64a1e2d1772a2df7436ef32a55cde8850b09ecfb1b637f1734
'http://archive.ubuntu.com/ubuntu/pool/main/libr/librsvg/librsvg_2.52.5%2bdfsg.orig.tar.xz' librsvg_2.52.5+dfsg.orig.tar.xz 20813024 SHA512:641dcd149ce0d5117947e3fcb04efd41591812953ec4b12ba350ce9950ed4bcb26726a78df9d317e6bd557e6fd463867476205b5e6720a9a15bd1bcfcb6f7ffe
'http://archive.ubuntu.com/ubuntu/pool/main/libr/librsvg/librsvg_2.52.5%2bdfsg-3ubuntu0.2.debian.tar.xz' librsvg_2.52.5+dfsg-3ubuntu0.2.debian.tar.xz 37684 SHA512:171868ea6d28e98afb6af4c75eb05de3b85a7adb21ae5ac36d8720fb86fa30769795a2487a2979e735662a6da9fcc4ce41a2caa128aa5044892904885e9c7e0a
```

### `dpkg` source package: `libseccomp=2.5.3-2ubuntu2`

Binary Packages:

- `libseccomp2:amd64=2.5.3-2ubuntu2`

Licenses: (parsed from: `/usr/share/doc/libseccomp2/copyright`)

- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libseccomp=2.5.3-2ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libseccomp/libseccomp_2.5.3-2ubuntu2.dsc' libseccomp_2.5.3-2ubuntu2.dsc 2799 SHA512:401672fbf5fc3d5ae529522bd94e5e5f8f158722d8ecebf1a1bc0569f652e8df182f18e647526b6434663b35736fe7c0536fcf19b99b060626cee91212b50c84
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libseccomp/libseccomp_2.5.3.orig.tar.gz' libseccomp_2.5.3.orig.tar.gz 637572 SHA512:00170fe2360f0c0b33293dccfcc33e98fabb99619f34ecefbcc92bfdaa249ba91e7433226545b842b71542a3b224b6e980ea2ae656c4addf07e84a0def1870a0
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libseccomp/libseccomp_2.5.3.orig.tar.gz.asc' libseccomp_2.5.3.orig.tar.gz.asc 833 SHA512:c879872448471fb1e01617145473254a0536ade1ff1e12871793631c3c63199cd46cb48317b4d596294d5cb187ff1fe9b58dc20ce52a89bfc9234a566bf8eb85
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libseccomp/libseccomp_2.5.3-2ubuntu2.debian.tar.xz' libseccomp_2.5.3-2ubuntu2.debian.tar.xz 23580 SHA512:c0333edd1130b8e0f90c9da61e5ce30aa0878eb27bf5862ae2d15f0e9728d792285a6d22e48d7f6681eaba5eb578958a15fdc6474036b0ee657a571f5a15f134
```

### `dpkg` source package: `libselinux=3.3-1build2`

Binary Packages:

- `libselinux1:amd64=3.3-1build2`

Licenses: (parsed from: `/usr/share/doc/libselinux1/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libselinux=3.3-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libselinux/libselinux_3.3-1build2.dsc' libselinux_3.3-1build2.dsc 2644 SHA512:e6f6744aeef21f3acf9c36fc6251515e6be8caf1b4953ed20d2346897c72bc919ae7e26ab8dfd0c2cf24029bd39da073e57ea19df15af106ce86ab4537c691aa
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libselinux/libselinux_3.3.orig.tar.gz' libselinux_3.3.orig.tar.gz 206826 SHA512:9a89c05ea4b17453168a985ece93ba6d6c4127916e657c46d4135eb59a1f6408faa0802cc2e49187defbde5247d659037beee089877affbab3eab6af3433696c
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libselinux/libselinux_3.3-1build2.debian.tar.xz' libselinux_3.3-1build2.debian.tar.xz 24052 SHA512:75e344ef0d123659105774a0fe941f5821d230bd3f4db0453918407325f6c08246db2cd609ec0ba51090b2942cd1a9a1865245a18834fa1b234d730103799c0c
```

### `dpkg` source package: `libsemanage=3.3-1build2`

Binary Packages:

- `libsemanage-common=3.3-1build2`
- `libsemanage2:amd64=3.3-1build2`

Licenses: (parsed from: `/usr/share/doc/libsemanage-common/copyright`, `/usr/share/doc/libsemanage2/copyright`)

- `GPL`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris libsemanage=3.3-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsemanage/libsemanage_3.3-1build2.dsc' libsemanage_3.3-1build2.dsc 2690 SHA512:6337e23938be6ebe18321ce9e67802ceaa2637e37bdc0940c4a4501e73f25235c662de1ec85807062327d2d5c5e7078ad0fb20d660e075710726cd0ede51e2fc
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsemanage/libsemanage_3.3.orig.tar.gz' libsemanage_3.3.orig.tar.gz 178890 SHA512:6026d9773c0886436ad801bc0c8beac888b6fb62034edeb863192dea4b6ef34a88e080758820fe635a20e048ac666beee505a0f946258f18571709cca5228aad
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsemanage/libsemanage_3.3-1build2.debian.tar.xz' libsemanage_3.3-1build2.debian.tar.xz 17920 SHA512:b23e000956a6fc96c7609a749d1974874834b6a463b0f5b42b3e4bde75f560789f7ef7f385a3a7297e97f7c610cd0c2899986b3a228671a57e051310441b0c90
```

### `dpkg` source package: `libsepol=3.3-1build1`

Binary Packages:

- `libsepol2:amd64=3.3-1build1`

Licenses: (parsed from: `/usr/share/doc/libsepol2/copyright`)

- `GPL`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris libsepol=3.3-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsepol/libsepol_3.3-1build1.dsc' libsepol_3.3-1build1.dsc 2217 SHA512:91f9c8436df88aa898f2e3ea4a8bbb0cb21de84153bc88b9fff30b2aa3f0e6b11d5b9f506b81d0266e8a4881ea86d6590abe64b8eacc2d8cdeaf1a0f5f2784bf
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsepol/libsepol_3.3.orig.tar.gz' libsepol_3.3.orig.tar.gz 482546 SHA512:fb6bb69f8e43a911a1a9cbd791593215386e93cb9292e003f5d8efe6e86e0ce5d0287e95d52fe2fbce518a618beaf9b1135aea0d04eaebcdbd8c6d07ee67b500
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsepol/libsepol_3.3-1build1.debian.tar.xz' libsepol_3.3-1build1.debian.tar.xz 15068 SHA512:adb210e2dab83baa49cee624dc5ae44e9f2dff6eb4a0a7bee4b958e99871580df159d0ca339feca31d9c4cdd92d0022a841c35d615436278046379eeb766f1f2
```

### `dpkg` source package: `libsm=2:1.2.3-1build2`

Binary Packages:

- `libsm6:amd64=2:1.2.3-1build2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libsm=2:1.2.3-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsm/libsm_1.2.3-1build2.dsc' libsm_1.2.3-1build2.dsc 2170 SHA512:4dc5d9445614801154fb411ae2089c80c55adaea90a9d78a958724d70fc8ea8d36c9a898a478f18a9669f3448d9d9a948c632f2a4869287d1e1f88403e304096
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsm/libsm_1.2.3.orig.tar.gz' libsm_1.2.3.orig.tar.gz 445362 SHA512:03b77d86b33cdb3df4f9d65131a0025182f3cb0c17b33a90d236e8563b3011d225b9d006186302d07850edafa5b899aec6a086b8d437d357cd69fedd5f22d94b
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsm/libsm_1.2.3-1build2.diff.gz' libsm_1.2.3-1build2.diff.gz 9062 SHA512:c5ddeb48fe7c846b31382a5da42a2970ae12995afb322c6291977b7ffd2251d4d9e9dc163ecb008902ae8ee3c3a44526115bddc92b402c8f4a9ea0f29f1cb037
```

### `dpkg` source package: `libssh=0.9.6-2ubuntu0.22.04.3`

Binary Packages:

- `libssh-4:amd64=0.9.6-2ubuntu0.22.04.3`

Licenses: (parsed from: `/usr/share/doc/libssh-4/copyright`)

- `BSD-2-clause`
- `BSD-3-clause`
- `LGPL-2.1`
- `LGPL-2.1+~OpenSSL`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris libssh=0.9.6-2ubuntu0.22.04.3
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libssh/libssh_0.9.6-2ubuntu0.22.04.3.dsc' libssh_0.9.6-2ubuntu0.22.04.3.dsc 2884 SHA512:d118e2881416d2a4e4d07fb7056c42651e8c5b80a9bc6dccb996559351847bfe7fa28a07926b0027484f091ccd6ae0436c40f82ca9bdf8c8286c191d8f9b723c
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libssh/libssh_0.9.6.orig.tar.xz' libssh_0.9.6.orig.tar.xz 1053056 SHA512:4040ec4af937e95be2e41313ef6d4db60b46b8d4dea10c09402398127c1d1ca8843392d207088aeee3c7ef631c6ae7b66861327dcebf78ed3af0723777619fd1
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libssh/libssh_0.9.6.orig.tar.xz.asc' libssh_0.9.6.orig.tar.xz.asc 833 SHA512:1b6223efe9e4ce864cd8d97d517f9f0d38c1cd502b5874fdc6a58731038c2830a72ce753f02fc062d9d4d5922107ec9a2e62fe24a704bb5dec0dcfecdb569fe6
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libssh/libssh_0.9.6-2ubuntu0.22.04.3.debian.tar.xz' libssh_0.9.6-2ubuntu0.22.04.3.debian.tar.xz 52472 SHA512:26a7a01afe7e6d6d7da87e2afb76fe8972e1aa471ea6cd763ff2ff0508ae560f7b7ca110577ca4f6bcc071100eeb0653862203bc47b7f91e9ca5b628647c7c4b
```

### `dpkg` source package: `libtasn1-6=4.18.0-4build1`

Binary Packages:

- `libtasn1-6:amd64=4.18.0-4build1`

Licenses: (parsed from: `/usr/share/doc/libtasn1-6/copyright`)

- `GFDL-1.3`
- `GPL-3`
- `LGPL`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libtasn1-6=4.18.0-4build1
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtasn1-6/libtasn1-6_4.18.0-4build1.dsc' libtasn1-6_4.18.0-4build1.dsc 2794 SHA512:cb0f727f9935cdb7784451234c676f0e3544789cc01dd6786006d4662807937722437de6450f4bd24b698b621b7dfa7eaf28d607402ecbb8167315791739d570
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtasn1-6/libtasn1-6_4.18.0.orig.tar.gz' libtasn1-6_4.18.0.orig.tar.gz 1724441 SHA512:4f2f4afc7561fda7a1f1c6c525c3c3b08228a1a4aa8c3d3d5e02e993d8f83ccee1dd0f1b201cec0fbfc97043d4b1d7a95ffd34d65422a38b85b931ac7a015831
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtasn1-6/libtasn1-6_4.18.0.orig.tar.gz.asc' libtasn1-6_4.18.0.orig.tar.gz.asc 228 SHA512:8ef3918a3130f695d2d5b26dd945084b931005eff8914c50a0ac9795d4cc6ec9e9645e2941ff4235cba3b4b2987ab1c7da65225e24ce16aaab844352ecdafbf6
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtasn1-6/libtasn1-6_4.18.0-4build1.debian.tar.xz' libtasn1-6_4.18.0-4build1.debian.tar.xz 22112 SHA512:4c363cfa12bd27c22a32ced69ca560ed6d3af2404158dcb0c1be472c6af411931f5d807f77b9966a1fb6bc9089d3d354fc85c3144d8beaabe36036694898a82e
```

### `dpkg` source package: `libtext-iconv-perl=1.7-7build3`

Binary Packages:

- `libtext-iconv-perl=1.7-7build3`

Licenses: (parsed from: `/usr/share/doc/libtext-iconv-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libtext-iconv-perl=1.7-7build3
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtext-iconv-perl/libtext-iconv-perl_1.7-7build3.dsc' libtext-iconv-perl_1.7-7build3.dsc 2144 SHA512:ac922bf72f0d6bfd7717e5c90654ecc5b21a7511fa231895fe3b73bfd090160faa76081cc42c47c68496f7735470bdbc90a7308e619ad70559f123f05af0e782
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtext-iconv-perl/libtext-iconv-perl_1.7.orig.tar.bz2' libtext-iconv-perl_1.7.orig.tar.bz2 9977 SHA512:c1524cfe75abd6ec9e2934cc690ba9c082f6e07e20ed051d7186863613cfd455d5b1c466a3e2efa36967f7a913d976678eeeaaf0c48a45ae8aa0dc7e9f4def7c
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtext-iconv-perl/libtext-iconv-perl_1.7-7build3.debian.tar.xz' libtext-iconv-perl_1.7-7build3.debian.tar.xz 3500 SHA512:2b2f2087090750f27d80abe26df21a35fa3a35ca7e8ccf2e7f91e246a7b5aaab04f273021aa61032d072830a2c78c041c26a113c1b684a3f7377fdbc6d9b6af9
```

### `dpkg` source package: `libthai=0.1.29-1build1`

Binary Packages:

- `libthai-data=0.1.29-1build1`
- `libthai0:amd64=0.1.29-1build1`

Licenses: (parsed from: `/usr/share/doc/libthai-data/copyright`, `/usr/share/doc/libthai0/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris libthai=0.1.29-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libthai/libthai_0.1.29-1build1.dsc' libthai_0.1.29-1build1.dsc 2457 SHA512:d4181f56ccec5cddf5e65a01386d30b51a1e9cea2fd671577fa5cf14435ea3e9b0a6e6668f1f008a0d4180067d4498b163309f5a7a51b2f4ef64ab868439bb0c
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libthai/libthai_0.1.29.orig.tar.xz' libthai_0.1.29.orig.tar.xz 417728 SHA512:0ba1261581a1705a2a2546a3071acb3c63892dbf111f0dad415667165a6b9542a5e4549061c67b11ec53de7c9e70fceb3c04d794fd12a22d991a539dbacebda1
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libthai/libthai_0.1.29-1build1.debian.tar.xz' libthai_0.1.29-1build1.debian.tar.xz 12676 SHA512:fd2032f66f172ee3e2646099205474c2bbe6a0dd0f0fd685b9e8add66017a160946d5708b4bac4ae9aa5da3062eafdc34c0228c99910b1c013aaee29b9ab9d07
```

### `dpkg` source package: `libtie-ixhash-perl=1.23-2.1`

Binary Packages:

- `libtie-ixhash-perl=1.23-2.1`

Licenses: (parsed from: `/usr/share/doc/libtie-ixhash-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libtie-ixhash-perl=1.23-2.1
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtie-ixhash-perl/libtie-ixhash-perl_1.23-2.1.dsc' libtie-ixhash-perl_1.23-2.1.dsc 2166 SHA512:9539c8dd1fc5a066d48ef28676b0c152f1800002205e009f50f5e1b3d8a401e1c61084620c6ef87de13445fcaf1ed9a251ed2746b70d18d7dfb3e61a99a59fea
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtie-ixhash-perl/libtie-ixhash-perl_1.23.orig.tar.gz' libtie-ixhash-perl_1.23.orig.tar.gz 9352 SHA512:13e5015cf4e11e3ba828279a5090704b8e4bed26a04e1f486a9d3a63c41eaf38d54d233b20ef5d1886b56e857208c229fd145c4c676b681e3e9c1ed3c252f195
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtie-ixhash-perl/libtie-ixhash-perl_1.23-2.1.debian.tar.xz' libtie-ixhash-perl_1.23-2.1.debian.tar.xz 2116 SHA512:3d966b7df9df1dd31f21808b0bf3e1dd370e03e34cb19ae231f73de7fe2367d88222e75f390f815498d16cbd15794328b69149f814d3f8ca023949c51830ec2d
```

### `dpkg` source package: `libtimedate-perl=2.3300-2`

Binary Packages:

- `libtimedate-perl=2.3300-2`

Licenses: (parsed from: `/usr/share/doc/libtimedate-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libtimedate-perl=2.3300-2
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtimedate-perl/libtimedate-perl_2.3300-2.dsc' libtimedate-perl_2.3300-2.dsc 2384 SHA512:0caf347617ccf5bef157632d240764d30cf4e5dc1d26b14c1e3b55e461e1408affffb0a6cdac1668ec7feefeb2f9428e3c82dbf0962e22283b4b2247cd04e867
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtimedate-perl/libtimedate-perl_2.3300.orig.tar.gz' libtimedate-perl_2.3300.orig.tar.gz 29997 SHA512:a3a20a0d9439e68bf621c66fad0598e6257345727be79c87c7cc99994b3a58eb738787fedb720beb069e9758ad1347c15313f64411806dd0f4dfbcca5061c820
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtimedate-perl/libtimedate-perl_2.3300-2.debian.tar.xz' libtimedate-perl_2.3300-2.debian.tar.xz 4832 SHA512:11c5a8c5c264089e213f740ac7b85b213f4f7955734eec0003a450f50887e54b028d9ab42ad853eab656985fdaa6a07717989c94e264f6c769747c42e64cca8f
```

### `dpkg` source package: `libtirpc=1.3.2-2ubuntu0.1`

Binary Packages:

- `libtirpc-common=1.3.2-2ubuntu0.1`
- `libtirpc-dev:amd64=1.3.2-2ubuntu0.1`
- `libtirpc3:amd64=1.3.2-2ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libtirpc-common/copyright`, `/usr/share/doc/libtirpc-dev/copyright`, `/usr/share/doc/libtirpc3/copyright`)

- `BSD-2-Clause`
- `BSD-3-Clause`
- `BSD-4-Clause`
- `GPL-2`
- `LGPL-2.1`
- `LGPL-2.1+`
- `PERMISSIVE`
- `__AUTO_PERMISSIVE__`

Source:

```console
$ apt-get source -qq --print-uris libtirpc=1.3.2-2ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtirpc/libtirpc_1.3.2-2ubuntu0.1.dsc' libtirpc_1.3.2-2ubuntu0.1.dsc 2201 SHA512:da9e64904445de59217c2bfa55ca9739e0b08ac4693a45a813b7fc67273e106a11e7076d39d24e5f62d242af4e2eaac9e5503072b57f4cf7bdfa579a82920e77
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtirpc/libtirpc_1.3.2.orig.tar.bz2' libtirpc_1.3.2.orig.tar.bz2 513151 SHA512:8664d5c4f842ee5acf83b9c1cadb7871f17b8157a7c4500e2236dcfb3a25768cab39f7c5123758dcd7381e30eb028ddfa26a28f458283f2dcea3426c9878c255
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtirpc/libtirpc_1.3.2-2ubuntu0.1.debian.tar.xz' libtirpc_1.3.2-2ubuntu0.1.debian.tar.xz 18364 SHA512:5440c46e49837b176b8087d82762002766e48a7d487e101049079637ebb93c21fbb1dccd63a319f72ee11d7964873c00dc98a7b5b320355d640df7f9e16ab1c7
```

### `dpkg` source package: `libtry-tiny-perl=0.31-1`

Binary Packages:

- `libtry-tiny-perl=0.31-1`

Licenses: (parsed from: `/usr/share/doc/libtry-tiny-perl/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris libtry-tiny-perl=0.31-1
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtry-tiny-perl/libtry-tiny-perl_0.31-1.dsc' libtry-tiny-perl_0.31-1.dsc 2471 SHA512:1b781aabb6dd618fbdb2a2366abd8f23fa2c8dd651f4fe26af24fe19733702dc3331342097deca523419c2380b03713de5ba9d30e0bdef693d255b4cb37cdb87
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtry-tiny-perl/libtry-tiny-perl_0.31.orig.tar.gz' libtry-tiny-perl_0.31.orig.tar.gz 35784 SHA512:1a3c852e56797d81da60a4f4887cb70fc575eca83d10b8cd12fe5d5d0008a967801218f3a5277a2f1347ade95b9515c1f237333e491742d06614c0beecf44768
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtry-tiny-perl/libtry-tiny-perl_0.31-1.debian.tar.xz' libtry-tiny-perl_0.31-1.debian.tar.xz 3820 SHA512:956360f35c3018fac9a7602767963abbf6e0c5d3c88c2d159725cf6328a4c3a68daca47a456e569f9bc2cb7ddee463984ac117e3da9beb2557f8b4ef5bc414b4
```

### `dpkg` source package: `libunistring=1.0-1`

Binary Packages:

- `libunistring2:amd64=1.0-1`

Licenses: (parsed from: `/usr/share/doc/libunistring2/copyright`)

- `FreeSoftware`
- `GFDL-1.2`
- `GFDL-1.2+`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with distribution exception`
- `GPL-3`
- `GPL-3+`
- `LGPL-3`
- `LGPL-3+`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris libunistring=1.0-1
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libunistring/libunistring_1.0-1.dsc' libunistring_1.0-1.dsc 1928 SHA512:630d20ef6dd19be991147131d38acae2db15d1df34403264a15a373fcd4b661efffc1ae3916c52448f05cafb93bf1266527efa6630a02def88b86495d688a0c3
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libunistring/libunistring_1.0.orig.tar.xz' libunistring_1.0.orig.tar.xz 2367800 SHA512:70d5ad82722844dbeacdfcb4d7593358e4a00a9222a98537add4b7f0bf4a2bb503dfb3cd627e52e2a5ca1d3da9e5daf38a6bd521197f92002e11e715fb1662d1
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libunistring/libunistring_1.0-1.debian.tar.xz' libunistring_1.0-1.debian.tar.xz 42004 SHA512:f9208e7ab38cc742bb46dc1a871ddb03847b99b6169e20e8d8660dd9cdf22bffb27f9b329dcbd025ad9b26aee5a2aab01337f36d8ab3020d2e752f9c2d4368ce
```

### `dpkg` source package: `libunwind=1.3.2-2build2.1`

Binary Packages:

- `libunwind8:amd64=1.3.2-2build2.1`

Licenses: (parsed from: `/usr/share/doc/libunwind8/copyright`)

- `Expat`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris libunwind=1.3.2-2build2.1
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libunwind/libunwind_1.3.2-2build2.1.dsc' libunwind_1.3.2-2build2.1.dsc 2929 SHA512:2c7543dbb427b461b2f0f106a42e97e18ad6477e7d73a4ef094e7013d450823503e2f9164477932b8d44aa727fea020968de8e09498057c04749ee8277f93d07
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libunwind/libunwind_1.3.2.orig.tar.gz' libunwind_1.3.2.orig.tar.gz 854114 SHA512:221864eae6bf0fde281d9551662af1e539ce919fbb7050947e60dbcc09efed4f5d34574dbce11792513e63151e0af72f02801b7bcd37a6a519e6d868abb8b509
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libunwind/libunwind_1.3.2.orig.tar.gz.asc' libunwind_1.3.2.orig.tar.gz.asc 659 SHA512:3ee5c16592a8c1c1ea62070d764ed09816e4441c724c2ea188fb368f2413e29f3a20e7cd241ab65753b28c77f589c92de4f7afbae058d4384e4dbbb441ef007d
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libunwind/libunwind_1.3.2-2build2.1.debian.tar.xz' libunwind_1.3.2-2build2.1.debian.tar.xz 20156 SHA512:1296e9f4659bf9f345498f869f481b0f42c6cdf64249c4b0161b246e72994072290aada8ec9a4df86d4c9afaa61358620c6b4022585efa21d977ca09cc26de35
```

### `dpkg` source package: `liburi-perl=5.10-1`

Binary Packages:

- `liburi-perl=5.10-1`

Licenses: (parsed from: `/usr/share/doc/liburi-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris liburi-perl=5.10-1
'http://archive.ubuntu.com/ubuntu/pool/main/libu/liburi-perl/liburi-perl_5.10-1.dsc' liburi-perl_5.10-1.dsc 2374 SHA512:977dc0de441271d97e21366286608e2cb6e50bba6fe1cb12779a95deb46a89e95a5aa84c5755dcaf086eebe8f9b75415c7fc86436164bd19e00401b482932229
'http://archive.ubuntu.com/ubuntu/pool/main/libu/liburi-perl/liburi-perl_5.10.orig.tar.gz' liburi-perl_5.10.orig.tar.gz 109471 SHA512:6ce53b258c2f1115e58ca858beec0c055452993b83abf3ebf23784e00fcbe636f3b7a460a2016923f9fab0e0bbd112475048eb9671d6d1e1c3b4db33a503efb5
'http://archive.ubuntu.com/ubuntu/pool/main/libu/liburi-perl/liburi-perl_5.10-1.debian.tar.xz' liburi-perl_5.10-1.debian.tar.xz 5856 SHA512:aa8cf49866730833d0493a65f5b252bd0738367ada1e86ae28098433fd14f120b2c56f822afc0b890b4d2decc383155a017c838f80ffc1643340d57113afad0e
```

### `dpkg` source package: `libuv1=1.43.0-1ubuntu0.1`

Binary Packages:

- `libuv1:amd64=1.43.0-1ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libuv1/copyright`)

- `Apache-2.0`
- `BSD-1-clause`
- `BSD-2-clause`
- `BSD-3-clause`
- `CC-BY-4.0`
- `Expat`
- `GPL3+ with autoconf exception`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris libuv1=1.43.0-1ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libuv1/libuv1_1.43.0-1ubuntu0.1.dsc' libuv1_1.43.0-1ubuntu0.1.dsc 2112 SHA512:ed025d990a1285fcfdfeafdbac651571f7eb3dd0eda17261378d93ef635563922247c2c2a87a62b4f426531a4508730d9c7ba1a8130c58fb5bf9aebf0e8e2f48
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libuv1/libuv1_1.43.0.orig.tar.gz' libuv1_1.43.0.orig.tar.gz 1296029 SHA512:5a000b5a57efa03218cb8cc8deac91a8371f472452f48fef7d15c8d03ea0d98a966feba1ad9f2bf00f03635563663562dbd6d0cd2018e4d6c9783e64c2b3cd92
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libuv1/libuv1_1.43.0-1ubuntu0.1.debian.tar.xz' libuv1_1.43.0-1ubuntu0.1.debian.tar.xz 21876 SHA512:c37c2cb3d4be67220482be266dbc08243c8412714a0da039eebd03ec1bc7ecf3ccf91d49005545d4361dcc33012a48a6045c400611eb9887785f10284ab6c8da
```

### `dpkg` source package: `libwebp=1.2.2-2ubuntu0.22.04.2`

Binary Packages:

- `libwebp7:amd64=1.2.2-2ubuntu0.22.04.2`

Licenses: (parsed from: `/usr/share/doc/libwebp7/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris libwebp=1.2.2-2ubuntu0.22.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwebp/libwebp_1.2.2-2ubuntu0.22.04.2.dsc' libwebp_1.2.2-2ubuntu0.22.04.2.dsc 2186 SHA512:b81aa127277d4927b79d4ea5c8b63369f0b63e4944cc70bd98b277a1ae890169d91f4a0f30502830975bd2e34faa7a861b82d61f19ef660be1b7cf1d86010668
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwebp/libwebp_1.2.2.orig.tar.gz' libwebp_1.2.2.orig.tar.gz 4117468 SHA512:0dd0a721352b513a218d55383bcd0cc45b786df8089f70f87257b5dcc0c4e2f1798e20f1ca98b8fe51710abb667f9c4c14f20f980a11c484c8832f0dc66e3bff
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwebp/libwebp_1.2.2-2ubuntu0.22.04.2.debian.tar.xz' libwebp_1.2.2-2ubuntu0.22.04.2.debian.tar.xz 10468 SHA512:3c524505239652dbd3252aaaeee9161b0bb4c2ad146849341e87370760554de17d748d9b6f03c5e35db2d3f3dfedcf5e62b165502d207d2a114bda907483a830
```

### `dpkg` source package: `libwww-perl=6.61-1`

Binary Packages:

- `libwww-perl=6.61-1`

Licenses: (parsed from: `/usr/share/doc/libwww-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libwww-perl=6.61-1
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwww-perl/libwww-perl_6.61-1.dsc' libwww-perl_6.61-1.dsc 2971 SHA512:a9fa304db2203b6bda292bf22d107434f6f1a69bf3fa7b855ca2baef0490f685696b45a5d211464b959d6ed56c2305ad6d65c9f1eb2b473b72dcda131202e69d
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwww-perl/libwww-perl_6.61.orig.tar.gz' libwww-perl_6.61.orig.tar.gz 179453 SHA512:1c75546737c3e1db55f9bdf414062802450e5cced1c4e24840d8e214b2a10c5bac81cc70479d276f0123a3b34bd9025712cebf256036b472e5fad5a629db8c70
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwww-perl/libwww-perl_6.61-1.debian.tar.xz' libwww-perl_6.61-1.debian.tar.xz 11008 SHA512:d876baabee7dc424e39c25102dfb9e3a19e6d77f43d457bf4142d41e90d61798c55bbb3d35ceff6384d2589e64c54abb257d069d2b109ba6ed63065a2f293374
```

### `dpkg` source package: `libwww-robotrules-perl=6.02-1`

Binary Packages:

- `libwww-robotrules-perl=6.02-1`

Licenses: (parsed from: `/usr/share/doc/libwww-robotrules-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libwww-robotrules-perl=6.02-1
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwww-robotrules-perl/libwww-robotrules-perl_6.02-1.dsc' libwww-robotrules-perl_6.02-1.dsc 2284 SHA512:82f1ad7edd108346e448ace4d558d9d4a2a95451fc454f635efd09d08118bb969762e53021bb21184ee24a0603379b3bb2859f8a920a7fe9778768b0705e4985
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwww-robotrules-perl/libwww-robotrules-perl_6.02.orig.tar.gz' libwww-robotrules-perl_6.02.orig.tar.gz 9059 SHA512:781a2fc90e4efed901a91ecf4f2aaac2684409c6a75a8434ff140654838bb05d11f8fa760642e20eee96450d3ced6815a4dab11a4245bc8120c69ca68ab49e44
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwww-robotrules-perl/libwww-robotrules-perl_6.02-1.debian.tar.xz' libwww-robotrules-perl_6.02-1.debian.tar.xz 2220 SHA512:46a1ba7503ae7d41834de4c166c95cee902090a6d076d29c1267a12533362b7303a7faba8a35d602dd213096563cf3e1983d5b1aa2b981f451c0b1945b3d0bec
```

### `dpkg` source package: `libx11-protocol-perl=0.56-7.1`

Binary Packages:

- `libx11-protocol-perl=0.56-7.1`

Licenses: (parsed from: `/usr/share/doc/libx11-protocol-perl/copyright`)

- `Artistic`
- `Expat`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libx11-protocol-perl=0.56-7.1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libx11-protocol-perl/libx11-protocol-perl_0.56-7.1.dsc' libx11-protocol-perl_0.56-7.1.dsc 2159 SHA512:6260bc71fcf93512fc04c89b8d80cbae9a3ab21033f1b2c42d414f72732e139b814a152ec568368a2f3f46b93e7ab022bbdf5a325d5a2ea6abb82905e07530a9
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libx11-protocol-perl/libx11-protocol-perl_0.56.orig.tar.gz' libx11-protocol-perl_0.56.orig.tar.gz 101227 SHA512:1c1a6ed15ceff77e8be29ac32a0e72aa2d0a1e62b5e19af2e34055aa001ee281ab584d993ace82f46f00d4da2e7bd4c60e4e31876a43c6c64c3e216beb13fe5f
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libx11-protocol-perl/libx11-protocol-perl_0.56-7.1.debian.tar.xz' libx11-protocol-perl_0.56-7.1.debian.tar.xz 4416 SHA512:47dee15389d49df3eaa1ef5b857bdb4a8647ca6c4617479b48d46e17ff774e828d7cc5a5107a80cb3a297bcbbf61f44c81d13c09a0db386150c531787b12ab73
```

### `dpkg` source package: `libx11=2:1.7.5-1ubuntu0.3`

Binary Packages:

- `libx11-6:amd64=2:1.7.5-1ubuntu0.3`
- `libx11-data=2:1.7.5-1ubuntu0.3`
- `libx11-xcb1:amd64=2:1.7.5-1ubuntu0.3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libx11=2:1.7.5-1ubuntu0.3
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libx11/libx11_1.7.5-1ubuntu0.3.dsc' libx11_1.7.5-1ubuntu0.3.dsc 2654 SHA512:97c9c7e8096cdb264d45a08f0333025ded9b74296689809d687de62b60b5d5ef7d2dc8b592b8155dbe12aa18129f97a12b978234b52ba2ed553568d207c62fce
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libx11/libx11_1.7.5.orig.tar.gz' libx11_1.7.5.orig.tar.gz 3170022 SHA512:90474f5f95c3498a02100aeeb6b5ad7ae9076bc40a70cdd828bd881adac0bf278002186142f2760e5504cf82120f4869798831e0e2332ecbc6903e8f7c9114ab
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libx11/libx11_1.7.5.orig.tar.gz.asc' libx11_1.7.5.orig.tar.gz.asc 358 SHA512:75139b9f7b2f19aed3d3a66ea8b883480db2fa56d713bb0160ea8a0faba208da4c241768f9f2703f723f13906438eda3117f489d7d5d17fbe1cbb75b13c9935d
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libx11/libx11_1.7.5-1ubuntu0.3.diff.gz' libx11_1.7.5-1ubuntu0.3.diff.gz 98716 SHA512:54531c960c2252c99e2f32f0d051eb1e764f181aaa68fc20a053384f70b14f32872e9ca05ed45affd2e97ea2821cdd8c3e3ebacf8c81c3088386a7d95214f64b
```

### `dpkg` source package: `libxau=1:1.0.9-1build5`

Binary Packages:

- `libxau6:amd64=1:1.0.9-1build5`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxau=1:1.0.9-1build5
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxau/libxau_1.0.9-1build5.dsc' libxau_1.0.9-1build5.dsc 2315 SHA512:b9a9d6888a70e8c7e8161a322a425316ed181d00ad3881caea788aeda9c4346122a70c57d30b91e7692f5c0b468da9d784c228ead5487cfb2474f4fc42b83ada
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxau/libxau_1.0.9.orig.tar.gz' libxau_1.0.9.orig.tar.gz 394068 SHA512:3b22f34a4e35d17421189df8ce3f858b0914aef0cea0b12689dd8576f14eb811e39d6e32384251573daa7e3daba400deea98e7c0e29b4105138cf82195d7f875
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxau/libxau_1.0.9.orig.tar.gz.asc' libxau_1.0.9.orig.tar.gz.asc 801 SHA512:e59b2944591499d0c0291a8d80ad8ee2cb13ee00c32b0d26c6af12a2bb96c947d4d15924ef15b377b8d7640b75b50f9b8127ba53c582090b3f73b7bcf9e00b01
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxau/libxau_1.0.9-1build5.diff.gz' libxau_1.0.9-1build5.diff.gz 10579 SHA512:9485f97bc34a7b348a7bd276001ff5e455a17c8d6b6d6e4382496c38f470f1650f7177103d2b123f25f21ce62899ceb3112909ee92e9a604d302d3c63cb59e8f
```

### `dpkg` source package: `libxaw=2:1.0.14-1`

Binary Packages:

- `libxaw7:amd64=2:1.0.14-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxaw=2:1.0.14-1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxaw/libxaw_1.0.14-1.dsc' libxaw_1.0.14-1.dsc 2352 SHA512:86716dd1d303d27b00dc9a5d4023e669c45a5bd3b212d3f5d02460a2deafcb7f2a048d07b47d092353935f56fce836a7931f357278ff2906f18dafc86792acbc
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxaw/libxaw_1.0.14.orig.tar.gz' libxaw_1.0.14.orig.tar.gz 886122 SHA512:1205481443627b428f6c447a3926a060af30440badc401ca8d209849faef21ce967cf7f26ab452b47a64071980f9892cce83b2d70db0c2b7d6cabf838ab93884
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxaw/libxaw_1.0.14.orig.tar.gz.asc' libxaw_1.0.14.orig.tar.gz.asc 618 SHA512:87db1130f7b69b75ec9ce91f7b3a2e8519da597c4faefb36c191555aaa35af9ac3576ae040ba4c7e74aefd8fb6bcdabd9ed1aacff13c40d1158f6003df4bf53b
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxaw/libxaw_1.0.14-1.diff.gz' libxaw_1.0.14-1.diff.gz 28936 SHA512:5545c68a10e47bfa42fcaeafe285f9cea3e68d43bc5a6d1a926052cba8f008bc2e7dda047e22c31c4bff79b008d3fe3726e6af6d96c9c8dbe1a854abcd5a385a
```

### `dpkg` source package: `libxcb=1.14-3ubuntu3`

Binary Packages:

- `libxcb-dri2-0:amd64=1.14-3ubuntu3`
- `libxcb-dri3-0:amd64=1.14-3ubuntu3`
- `libxcb-glx0:amd64=1.14-3ubuntu3`
- `libxcb-present0:amd64=1.14-3ubuntu3`
- `libxcb-randr0:amd64=1.14-3ubuntu3`
- `libxcb-render0:amd64=1.14-3ubuntu3`
- `libxcb-shape0:amd64=1.14-3ubuntu3`
- `libxcb-shm0:amd64=1.14-3ubuntu3`
- `libxcb-sync1:amd64=1.14-3ubuntu3`
- `libxcb-xfixes0:amd64=1.14-3ubuntu3`
- `libxcb1:amd64=1.14-3ubuntu3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxcb=1.14-3ubuntu3
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcb/libxcb_1.14-3ubuntu3.dsc' libxcb_1.14-3ubuntu3.dsc 5480 SHA512:cc563eae53e92b3f5cf700f0a61ee036fe0df9a109453dd4cd6a8107dac4a7f6d85e28810011ef74ca69ca36853a8d20e877480b94344ad5262f8fd6da299d5c
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcb/libxcb_1.14.orig.tar.gz' libxcb_1.14.orig.tar.gz 640322 SHA512:6114d8c233b42b56604787a0475e924143aa13f1d382e6029b2150a4360c12ce78073409f754fbb1e5d9f99fc26900c0a4c59e9cfbd4c3d0a3af0c1306e62da1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcb/libxcb_1.14-3ubuntu3.diff.gz' libxcb_1.14-3ubuntu3.diff.gz 27588 SHA512:228c6da2cf94e02b249ccb04f2668f45b2ab117a4c6670ac6f7ab449582e459df4fc7e1ce5ae5cd945acea6fd00b935ed6394c800ee3d92ce9a0fb6913460f86
```

### `dpkg` source package: `libxcomposite=1:0.4.5-1build2`

Binary Packages:

- `libxcomposite1:amd64=1:0.4.5-1build2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxcomposite=1:0.4.5-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcomposite/libxcomposite_0.4.5-1build2.dsc' libxcomposite_0.4.5-1build2.dsc 2199 SHA512:7cf1effb19bf6bb35f8d008c2c0f254edda66ba22b04e0a582ee35946061afd06382f177e24c74bb3ada5e2a87a26b568fb895472b34d49c176a0b79b5fdd0c7
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcomposite/libxcomposite_0.4.5.orig.tar.gz' libxcomposite_0.4.5.orig.tar.gz 386513 SHA512:3878cc68813b83067e400840f0f6d2e3638c9fdb48aa2b39f3295cf89604c29eb9522ba26b5f1248b35178fbf220ab74ad59e90c353314442b90120de1a5650b
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcomposite/libxcomposite_0.4.5-1build2.diff.gz' libxcomposite_0.4.5-1build2.diff.gz 7794 SHA512:974d2773dc2d39d2cd62ee5b1ea776142872f90ffed0bc98de5de95f25fb1ab28d2935197ab367bd413bfd776b8f94b54908be27d6bcaa73020563e7f4d418c2
```

### `dpkg` source package: `libxcrypt=1:4.4.27-1`

Binary Packages:

- `libcrypt-dev:amd64=1:4.4.27-1`
- `libcrypt1:amd64=1:4.4.27-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxcrypt=1:4.4.27-1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcrypt/libxcrypt_4.4.27-1.dsc' libxcrypt_4.4.27-1.dsc 1525 SHA512:1335a2ab3f7b519022af13c18dca9ea1c2de3007c07f120d53fbb7eb834ac7e0ece120681c1ee1dd92771469104dccedef3a7e85ec51fc1ca64b52c9447558c0
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcrypt/libxcrypt_4.4.27.orig.tar.xz' libxcrypt_4.4.27.orig.tar.xz 391772 SHA512:9d194066ab7eefd3e568b2478d58aa378da8571abf4c37ddcde2c01114a4aa69f0edfb4e3d13d951feac5955336f9b02046d9b1fd1b9fbfbc556aad31cf64d7e
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcrypt/libxcrypt_4.4.27-1.debian.tar.xz' libxcrypt_4.4.27-1.debian.tar.xz 7764 SHA512:02e38ba06f3555dd930fc7ed44602dc816ce48f4c29fdc085249948596d5e7e96600cb81c8c9fb2e1dc33574d5136d08feeff3eb1dd3522aa8e5cdc9037c1ae0
```

### `dpkg` source package: `libxcursor=1:1.2.0-2build4`

Binary Packages:

- `libxcursor1:amd64=1:1.2.0-2build4`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxcursor=1:1.2.0-2build4
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcursor/libxcursor_1.2.0-2build4.dsc' libxcursor_1.2.0-2build4.dsc 2392 SHA512:83ee6e8f9cd858bd7281682250789e13c9bff3cc4409c25bbdb0d8f616c3bc78c43017986afda1ec3853721c25b19649f75344033cc26c884b18b99bee93df39
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcursor/libxcursor_1.2.0.orig.tar.gz' libxcursor_1.2.0.orig.tar.gz 408135 SHA512:7a6638cb41be2db8141845efe5e0c701e4c67004264a04d9072e2f8ae98d466de199f3565bd14f9b7e6cfda83cfc1debaa16721985f51c00ccd69904b7074c83
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcursor/libxcursor_1.2.0-2build4.debian.tar.xz' libxcursor_1.2.0-2build4.debian.tar.xz 9232 SHA512:e83598e76d9a41e02bec74fe35b96db1ba0de3a3f0fe7a3afe0343cc28149a10a9d004dfe4c9fc5f9a21ada271991723f37c6d34e14b6bab2d0c436f54fde290
```

### `dpkg` source package: `libxdamage=1:1.1.5-2build2`

Binary Packages:

- `libxdamage1:amd64=1:1.1.5-2build2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxdamage=1:1.1.5-2build2
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxdamage/libxdamage_1.1.5-2build2.dsc' libxdamage_1.1.5-2build2.dsc 2256 SHA512:1fb9c44f9dfdcda4c11f02bc20ef09333465872d3f0586c053601a607aa998bfde4deec60fc257a96182dca41d245c06bd039b857ecaa624f53121fcaaff96b8
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxdamage/libxdamage_1.1.5.orig.tar.gz' libxdamage_1.1.5.orig.tar.gz 370586 SHA512:fe0bdf86f2bddd3dddd4362e9c83c6cbb894f9384cab41b76a9e6a7e1da1d1187dcb4339868b429dc7ddbf69df86c880b4e2ce6b0fe2f9124ad43dfbde45ed59
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxdamage/libxdamage_1.1.5-2build2.debian.tar.xz' libxdamage_1.1.5-2build2.debian.tar.xz 6144 SHA512:10385990c7dd9f48e8720271ca85f21f31f2884dc541ac5d841072de5b5b2c13f943bee6d843bd4eb1c45d8f209c340bc09329adabe4ae41e7b0a25739e492c9
```

### `dpkg` source package: `libxdmcp=1:1.1.3-0ubuntu5`

Binary Packages:

- `libxdmcp6:amd64=1:1.1.3-0ubuntu5`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxdmcp=1:1.1.3-0ubuntu5
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxdmcp/libxdmcp_1.1.3-0ubuntu5.dsc' libxdmcp_1.1.3-0ubuntu5.dsc 2252 SHA512:5b6df4dd48380acff08dbe1fe40258d33a2f431e27da076ce54e0a1714dacb1e031aa49e2ace3863dc2131de4df42aa76b423f44f520fd8b2dbb18c4bddcada1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxdmcp/libxdmcp_1.1.3.orig.tar.gz' libxdmcp_1.1.3.orig.tar.gz 429668 SHA512:edd05654ad9ea893e9e08269e25ea050d10eaf9f997a08494e24127d1ba0c896cd5338b4595b155c8cbf576e1d910b76e6ad7820fee62d74644f1f276551e2f2
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxdmcp/libxdmcp_1.1.3-0ubuntu5.diff.gz' libxdmcp_1.1.3-0ubuntu5.diff.gz 18395 SHA512:552a04477a7852b2a68ba268dcd19cee9dd89c2774b6c86ca8f11180f6b179cc7853348653cf3b7d3e89a0079bef91308e8da2dfd34d0f42104f352e47ea07bd
```

### `dpkg` source package: `libxext=2:1.3.4-1build1`

Binary Packages:

- `libxext6:amd64=2:1.3.4-1build1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxext=2:1.3.4-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxext/libxext_1.3.4-1build1.dsc' libxext_1.3.4-1build1.dsc 2250 SHA512:d7a857fa82374d6b0f1435f55c697f82f5f17e9492d74eea29e04679eb6a5dd49aeb88abb048e904de207c57d16d5ad487067e6fb45696834ac5c934040d7e90
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxext/libxext_1.3.4.orig.tar.gz' libxext_1.3.4.orig.tar.gz 494434 SHA512:4eebd639fd57cb9b84a1e17e368f82fbf3d9f021eef5ad3fe31dd128500db57862a82c1e0d214d447cb7641b2be3fd7e949ee1196f2a482793c6628fb1e5cd70
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxext/libxext_1.3.4-1build1.diff.gz' libxext_1.3.4-1build1.diff.gz 12588 SHA512:bfcebe8e6e277dc1ea81063a4a4663e24b78f2b69439e3b8ed2209168016876f55e8e95c6a1828ab5bf7a1936ec795e14f4391b24ec8801e0102e00e953d46e4
```

### `dpkg` source package: `libxfixes=1:6.0.0-1`

Binary Packages:

- `libxfixes3:amd64=1:6.0.0-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxfixes=1:6.0.0-1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxfixes/libxfixes_6.0.0-1.dsc' libxfixes_6.0.0-1.dsc 2264 SHA512:2fec8bc79729c9f2a58a8db7705002671e33faeaa5a2dee764c3b4fef3ad536ba555545fd9593a0362d37cf838e8f723cc5fcb84bf49feeb456ee2e814245e8c
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxfixes/libxfixes_6.0.0.orig.tar.gz' libxfixes_6.0.0.orig.tar.gz 387810 SHA512:422ff6aa6dddbb5d790ddf351b12556d37312d67b3adc8c276fb507b8278703b30841f81e526f119b9ab53a3bb8c7c5a742a43826287110ef5417dd84f01348a
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxfixes/libxfixes_6.0.0.orig.tar.gz.asc' libxfixes_6.0.0.orig.tar.gz.asc 195 SHA512:3f00205ee9c67956d1e06ba5f8b0271d7015b31b6b21f782fcbeac25d9494ecee5303a3900abb72e2480c5a98abf3739aa30117c8384f568e1ea05b9dd020714
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxfixes/libxfixes_6.0.0-1.diff.gz' libxfixes_6.0.0-1.diff.gz 16999 SHA512:fc7c885d20d865f9c9aff81e7a7a8cf4189b7e05c6161d120e127109f7e8def8261713564fe5fb2468f45041fef25d5d55a696bce3470f1ae8595ef5d15abb5f
```

### `dpkg` source package: `libxi=2:1.8-1build1`

Binary Packages:

- `libxi6:amd64=2:1.8-1build1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxi=2:1.8-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxi/libxi_1.8-1build1.dsc' libxi_1.8-1build1.dsc 2242 SHA512:43c30bba60a74e48d2ab240b5982ac305a6df6e3a4ac23902616ac103b3354c9171a3561bdd85b7c66ff75ad923b8b8604e6e46e75d81bc631e87f72562a81be
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxi/libxi_1.8.orig.tar.gz' libxi_1.8.orig.tar.gz 616977 SHA512:98b65084065cb28395cbd75213d7b52ac857840237d544714cf3cbddba6f940f93dd5846546365613da02fd5b4cd8c5be01ef2ac34b2503e500ea189e3c81005
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxi/libxi_1.8-1build1.diff.gz' libxi_1.8-1build1.diff.gz 24823 SHA512:ea75bc9b8ee93f4068cad75ff6cb3f7de5592a7f151241fb32dbbffd02aed7a89887df93c862c8de901e61ec7531aeb7ad5c3ff3ffc46d487fda89f98a9fec21
```

### `dpkg` source package: `libxinerama=2:1.1.4-3`

Binary Packages:

- `libxinerama1:amd64=2:1.1.4-3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxinerama=2:1.1.4-3
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxinerama/libxinerama_1.1.4-3.dsc' libxinerama_1.1.4-3.dsc 2088 SHA512:2c020448cf9f882be2c282c780d636ee814954f30b3874a770c570018bc9840791194debd28ae9e27a51bcdb6c8ef7917557a2f2f4cf6125e6dc4ff9860319ba
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxinerama/libxinerama_1.1.4.orig.tar.gz' libxinerama_1.1.4.orig.tar.gz 380740 SHA512:fa2cc45214cc591da8867dcd7e332312e8d224c390912dc8580f8b15c3c9d8ffc797eee97c20263faf129fbfc6b0d931b6bf10dc04b8ec439b852451886eba75
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxinerama/libxinerama_1.1.4-3.diff.gz' libxinerama_1.1.4-3.diff.gz 8436 SHA512:614e9deb0cee3578f57315bd06d27bd6df3f5e29b4aaaeaf677b75a136f53f1598451964a59261e430f5ec2dab3177fa9b27e3055801812fce29d2e32ce7ff22
```

### `dpkg` source package: `libxkbcommon=1.4.0-1`

Binary Packages:

- `libxkbcommon0:amd64=1.4.0-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxkbcommon=1.4.0-1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxkbcommon/libxkbcommon_1.4.0-1.dsc' libxkbcommon_1.4.0-1.dsc 2734 SHA512:1ad8ab8c6ec3a03472d6b87201af7ea0269bc59ec98cb46ec971ed6602fa34978bc4d7f1dbc95470226d0bbd4f70f1889c393706dbea48a2bc1d0e66fc0e03c7
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxkbcommon/libxkbcommon_1.4.0.orig.tar.xz' libxkbcommon_1.4.0.orig.tar.xz 471948 SHA512:7dd86952c036a6a78455b1ba05b53fcff9d6f133bb01c83fa860b4eaec3fc26bb0b5535948bcc2dafbd27204c3c91d01404ca9fc52896cc36af509384797d4f1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxkbcommon/libxkbcommon_1.4.0-1.debian.tar.xz' libxkbcommon_1.4.0-1.debian.tar.xz 8028 SHA512:d49087f93cd0cdbd56a7756a9895f97eaffdbf5aba8dfb65896337890cf732818373cb5cccee1dcbe99e119b5eff32380f3840c2f3ee2bcaec064632cd26c0a2
```

### `dpkg` source package: `libxkbfile=1:1.1.0-1build3`

Binary Packages:

- `libxkbfile1:amd64=1:1.1.0-1build3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxkbfile=1:1.1.0-1build3
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxkbfile/libxkbfile_1.1.0-1build3.dsc' libxkbfile_1.1.0-1build3.dsc 2411 SHA512:6da1a4c195dee99d11afeb61dcaf9202b8e0fb5e5f866907070cc7321a75c1ada5ea3b28d7835ac7226ce2d62352b941c597552622c154628f451b1758a1fdf0
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxkbfile/libxkbfile_1.1.0.orig.tar.gz' libxkbfile_1.1.0.orig.tar.gz 441021 SHA512:6936586df469419a8faa4db2dac37fff6bef95f796e8e02f3c3262c4d7c118ca72abf20929bd200a5ad94d599f56f81fbbecf52679fea05fb734af1516576aac
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxkbfile/libxkbfile_1.1.0.orig.tar.gz.asc' libxkbfile_1.1.0.orig.tar.gz.asc 801 SHA512:6adf091df299db2a84ed7da3776f0c1e767cb47a9b2f970d3489e9c88889da85e5427930261fd5ac3f60aa100cfd35ff793e09e074071ed8ee07f8cba572af2b
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxkbfile/libxkbfile_1.1.0-1build3.diff.gz' libxkbfile_1.1.0-1build3.diff.gz 10311 SHA512:df81593c8bbaba54883489fe91b9a0fa220717754eae5930b82ef604287f9666f25c582d42bce42798e089df7961192359a0bc3dcf2c1ae377391add8105445e
```

### `dpkg` source package: `libxml-parser-perl=2.46-3build1`

Binary Packages:

- `libxml-parser-perl:amd64=2.46-3build1`

Licenses: (parsed from: `/usr/share/doc/libxml-parser-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libxml-parser-perl=2.46-3build1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml-parser-perl/libxml-parser-perl_2.46-3build1.dsc' libxml-parser-perl_2.46-3build1.dsc 2244 SHA512:317aa7a55a75d2fe75c350dc37257d6658fa2a9f1fc807d2ec403821bafc797f8c2205618a92128cc09bc6d3c8b081380c95f88f5b270faccd5aed90933853a1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml-parser-perl/libxml-parser-perl_2.46.orig.tar.gz' libxml-parser-perl_2.46.orig.tar.gz 254763 SHA512:c4609495cc5ca34952f61876a690ef76d42eee6689d1bedb8036c9eab918525ec5213f1639c7178c029ee0f8765a2ca5eb0197f6e39b8be6d5dbc3f3c1d0b389
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml-parser-perl/libxml-parser-perl_2.46-3build1.debian.tar.xz' libxml-parser-perl_2.46-3build1.debian.tar.xz 58432 SHA512:44240ff2bbc4c97e760ce7dabc85d7d36e015760bdc8bfcaa13e818d53c2b102121f8ac6f24bb7dccd108c6eeeb446f6b47585aad3fb250e69e82188646ecf88
```

### `dpkg` source package: `libxml-twig-perl=1:3.52-1`

Binary Packages:

- `libxml-twig-perl=1:3.52-1`

Licenses: (parsed from: `/usr/share/doc/libxml-twig-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris libxml-twig-perl=1:3.52-1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml-twig-perl/libxml-twig-perl_3.52-1.dsc' libxml-twig-perl_3.52-1.dsc 2824 SHA512:79f62254d14f218150b27c95af8c5ec72f4290cdfa093bf6ba0317a65de57f7238eb025c95ff12f03f49ae0a50ca9cf267d8c006e6ddb58fdd0aceb6fb9d09a9
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml-twig-perl/libxml-twig-perl_3.52.orig.tar.gz' libxml-twig-perl_3.52.orig.tar.gz 407769 SHA512:1594e127fb76c0e53d0bd1f0a12fe3874c9523dd2bc55675d5a6cf44d5682ddea481671f786d3a65e6b69f5307c4da1701529f318453a1f8a22685b2dae793a6
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml-twig-perl/libxml-twig-perl_3.52-1.debian.tar.xz' libxml-twig-perl_3.52-1.debian.tar.xz 8252 SHA512:b6a07692e70aa3c3766b2b2d527f070ca0c832894513f3c441ac536a78106855f6915f07144ed2192b7b80e395e74f5da7478c9be7c278b6ec8d334b69770113
```

### `dpkg` source package: `libxml-xpathengine-perl=0.14-1`

Binary Packages:

- `libxml-xpathengine-perl=0.14-1`

Licenses: (parsed from: `/usr/share/doc/libxml-xpathengine-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libxml-xpathengine-perl=0.14-1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml-xpathengine-perl/libxml-xpathengine-perl_0.14-1.dsc' libxml-xpathengine-perl_0.14-1.dsc 2232 SHA512:7f1ffceea7fbc8d5a7f190cdfa01852c26e9ac276d95757107b7e07d9a45b25323bd8af35cc4dbf9f8e7e611361b16266315f1c8da645bcc4979bd78b73b8b41
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml-xpathengine-perl/libxml-xpathengine-perl_0.14.orig.tar.gz' libxml-xpathengine-perl_0.14.orig.tar.gz 26118 SHA512:2af1733ab3c7601543558b363109385b8fff93da2ac7c502966fee9df5d6c7dd7efe34cc671fa56e68dc2804365229731abd1880812f6f7064b28a9096842ec9
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml-xpathengine-perl/libxml-xpathengine-perl_0.14-1.debian.tar.xz' libxml-xpathengine-perl_0.14-1.debian.tar.xz 4680 SHA512:2a84268e320a7cf208cbb8988b16fa05d4ff39bffb0081998f51d685a83323dc5805f73e3c9d96ca5aeed04c9c51ce49b709a6432bbd41e67effcdc11f1b33ce
```

### `dpkg` source package: `libxml2=2.9.13+dfsg-1ubuntu0.4`

Binary Packages:

- `libxml2:amd64=2.9.13+dfsg-1ubuntu0.4`

Licenses: (parsed from: `/usr/share/doc/libxml2/copyright`)

- `ISC`
- `MIT-1`

Source:

```console
$ apt-get source -qq --print-uris libxml2=2.9.13+dfsg-1ubuntu0.4
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml2/libxml2_2.9.13%2bdfsg-1ubuntu0.4.dsc' libxml2_2.9.13+dfsg-1ubuntu0.4.dsc 3030 SHA512:766e6ac92f700f594da935dec46aef15bd51269241715e279082947d2f0ce5a9209e5928ef513ee4f382539b63a51ba633fc7e896eacfa911f398332e58af718
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml2/libxml2_2.9.13%2bdfsg.orig.tar.xz' libxml2_2.9.13+dfsg.orig.tar.xz 2351356 SHA512:6283071de4934c856c7ff5202ac1a2ed5892d7fcde82a364d40c8bc2bf3d3201fbcbb5f6983d8bf6b962026bc216b8182d71efe280f1dcef2931b277314e6e89
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml2/libxml2_2.9.13%2bdfsg-1ubuntu0.4.debian.tar.xz' libxml2_2.9.13+dfsg-1ubuntu0.4.debian.tar.xz 37288 SHA512:fd4b62393aaaef05df66dd1fb2c3ff2ead7eb40127a443bc9ee0ff96ae335f508801a933bf986eab0ed45758b47afa8bf93bfb5a83ae5ac9e5de12f1ddde8749
```

### `dpkg` source package: `libxmu=2:1.1.3-3`

Binary Packages:

- `libxmu6:amd64=2:1.1.3-3`
- `libxmuu1:amd64=2:1.1.3-3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxmu=2:1.1.3-3
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxmu/libxmu_1.1.3-3.dsc' libxmu_1.1.3-3.dsc 2165 SHA512:7868975bb24189125a57910121c07bfd40fcb57af86a61665d7480f34339c566f4684e1db849d4d589a0e01bb59925ee8de0089bff4df436502e714c3bcc1dec
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxmu/libxmu_1.1.3.orig.tar.gz' libxmu_1.1.3.orig.tar.gz 497343 SHA512:b92fb2e96519880e9f057ae4149bd1bd95584383c6224891f3d832d98ace9292269815fe51d06a4dfc257f51021c2f7367e2f529a7ebcc3dfc64f037720a1cb8
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxmu/libxmu_1.1.3-3.diff.gz' libxmu_1.1.3-3.diff.gz 8085 SHA512:afefb6de2e65cfd1174b58a25f4598966adc375378d6525b2ddac98dce20276ae9ce03b1eb14b3a3a186e2ce00b7d68133a2578048f2582c5bb7b6be42a16fa6
```

### `dpkg` source package: `libxpm=1:3.5.12-1ubuntu0.22.04.2`

Binary Packages:

- `libxpm4:amd64=1:3.5.12-1ubuntu0.22.04.2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxpm=1:3.5.12-1ubuntu0.22.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxpm/libxpm_3.5.12-1ubuntu0.22.04.2.dsc' libxpm_3.5.12-1ubuntu0.22.04.2.dsc 2203 SHA512:4989c9092997e6ed7b8ff6f79e29a49b4e5b7b0e501e063545cee478d18126f5a5f9d6d4f6774af669f8512e9fe93d050117f45b58612a4c896bca03a023c8fb
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxpm/libxpm_3.5.12.orig.tar.gz' libxpm_3.5.12.orig.tar.gz 529302 SHA512:17169016efc1e139f079290b2369fd62df8617867d97d2f50940521951a50f173118143109f0d7c552de92913cefc5ccaeb52225ccdd9abc89b3b85d9b5669f7
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxpm/libxpm_3.5.12-1ubuntu0.22.04.2.diff.gz' libxpm_3.5.12-1ubuntu0.22.04.2.diff.gz 21876 SHA512:6f61d1f62db0fd63ce98cce2864ae0d96594433d9da28178453f46ef9ec0b110f8cb6f2c5c8fa6fd79aa86c0813bac5a8d3ddc98e73fb49b3f391e1a03f9c150
```

### `dpkg` source package: `libxrandr=2:1.5.2-1build1`

Binary Packages:

- `libxrandr2:amd64=2:1.5.2-1build1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxrandr=2:1.5.2-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxrandr/libxrandr_1.5.2-1build1.dsc' libxrandr_1.5.2-1build1.dsc 2148 SHA512:6ff4378e649324dd71e77bcefa6943c24e00ec5338bb11d3bb1f3cb76fb19311ee66498d7a0d33855fab0f72e82fbab4a53109a0ccf246d537fa220111145d7f
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxrandr/libxrandr_1.5.2.orig.tar.gz' libxrandr_1.5.2.orig.tar.gz 411714 SHA512:309df91127ae17d8bb5a4382b22d1cf788733775dfddcb7932b3edb6f4121728daa7bba1e95ee5e250b2f8b03907a2564dcb3d645d7a5ef6314d0d7b09bac75d
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxrandr/libxrandr_1.5.2-1build1.diff.gz' libxrandr_1.5.2-1build1.diff.gz 17189 SHA512:d832be368bd3efc077acc1353f05c2c09aa5f3df6855a49e128c9eeb4a1a3f1f88559cfa9d1add772a30975eb07339e6b3165a8bdd4998c1dbfe3202c597c2b8
```

### `dpkg` source package: `libxrender=1:0.9.10-1build4`

Binary Packages:

- `libxrender1:amd64=1:0.9.10-1build4`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxrender=1:0.9.10-1build4
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxrender/libxrender_0.9.10-1build4.dsc' libxrender_0.9.10-1build4.dsc 2196 SHA512:4e5f32bd1ea1a7c78bd3f186fff28ead08e814f25029e6d955b323998c1a64ee53e6862b89aa73a9d2f84207cef9da28127bc2a40ce74f55cff37b198979b76d
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxrender/libxrender_0.9.10.orig.tar.gz' libxrender_0.9.10.orig.tar.gz 373717 SHA512:7768e62b500f468460f88f27bc1130170b204b478573d9e4406867e557b5638b7c1e21d88d51f9e774ce2344780a384e3c3be51421275d2ee880f9a978a3a232
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxrender/libxrender_0.9.10-1build4.diff.gz' libxrender_0.9.10-1build4.diff.gz 15809 SHA512:8c0fe7e340497564286087bc95c6fac4ac9130723bc7389dfc88cf4172dc77ae657e8bcb8c6a99ff53ee8aca1072ad5279e4b7588499209851059948eb2869a0
```

### `dpkg` source package: `libxshmfence=1.3-1build4`

Binary Packages:

- `libxshmfence1:amd64=1.3-1build4`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxshmfence=1.3-1build4
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxshmfence/libxshmfence_1.3-1build4.dsc' libxshmfence_1.3-1build4.dsc 2228 SHA512:5fcc75d7ae2e9349eed698a7b1da475280edc0e5037951b67fe57f21b0373bafd036d26169158836ddd90f3d2e6afa5a7e3b4c17446acdee21a38ce23cc3591c
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxshmfence/libxshmfence_1.3.orig.tar.gz' libxshmfence_1.3.orig.tar.gz 378960 SHA512:2303924c907f920462e773c82052b03e6c2cc7762b6e2ae4fa25bf9ccd7e0fd979f22f0448ba79a90d03491d311a59fa93a2b7c49590cd14b441fb4508c8e730
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxshmfence/libxshmfence_1.3-1build4.diff.gz' libxshmfence_1.3-1build4.diff.gz 17897 SHA512:a0ba8f59d00f3ecfea17bab46cffc54786c000f0561378a4028bf5d286de31867ac90c5f529306635c505b038d47d63b5d6827026a11f25a94fcb78c914f6d68
```

### `dpkg` source package: `libxss=1:1.2.3-1build2`

Binary Packages:

- `libxss1:amd64=1:1.2.3-1build2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxss=1:1.2.3-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxss/libxss_1.2.3-1build2.dsc' libxss_1.2.3-1build2.dsc 2335 SHA512:373a3a74c44be2758bd2c313f10e93514ac8d4a63918318073772b7b96b0c89901d06c048c9b975042971f89d95ac94abae2118efe912542800f26a5c53153f3
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxss/libxss_1.2.3.orig.tar.gz' libxss_1.2.3.orig.tar.gz 385215 SHA512:8f0d1d460027acfd50a312bf3b10407959d5ccbd9e76b319563535ba9038e1195cf0493664f80fd86e61ed037593d43e7b9a4f8f5d1f0c719d42935bf74ad68f
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxss/libxss_1.2.3.orig.tar.gz.asc' libxss_1.2.3.orig.tar.gz.asc 705 SHA512:678529385a502d93119ea4b3d4a94a19b79ee1b41e54c9526277cfa20e47bef04bb007fa089edcc9722f748dd27b7f58db5c732fe94c09112cec74425dbcc5d9
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxss/libxss_1.2.3-1build2.diff.gz' libxss_1.2.3-1build2.diff.gz 7348 SHA512:88a947717b203870b8dad3751bc993fa652319181046d7d99801678c55206c384b09828bb851008fd210c3a62437209d341f57fe21174cb593e5a3584f8c21b9
```

### `dpkg` source package: `libxt=1:1.2.1-1`

Binary Packages:

- `libxt6:amd64=1:1.2.1-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxt=1:1.2.1-1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxt/libxt_1.2.1-1.dsc' libxt_1.2.1-1.dsc 2312 SHA512:6176a90a0e929b22b0b2cc9e34844e904353ecac42fec4498005fb16a1c614051ad7d5dc407489316bdc7a7a7db19800ef43b06bb450961171b86200a2044b9c
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxt/libxt_1.2.1.orig.tar.gz' libxt_1.2.1.orig.tar.gz 1024473 SHA512:73c2fd8a6590ab5ee93cf646e4f41fb71d424961ecbf9bc13c68abdf539c63ab0c59a4d3b22195ba21859523f4cf0e937648424532794a1350a5891061096503
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxt/libxt_1.2.1.orig.tar.gz.asc' libxt_1.2.1.orig.tar.gz.asc 358 SHA512:135e01b8a79beac9530087dee1a5458c359b4f1ae8346e2502f72f4fc24be400477fda90944315c585e3416e80cb74d1a140d5dfec81e854a4996199a8b221dc
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxt/libxt_1.2.1-1.diff.gz' libxt_1.2.1-1.diff.gz 45419 SHA512:432a4911d7c6a15f87a093104c1e91df9b122410394ad242d8d5e219fe6c4d65c4ae99b82aafece96dea706f43601dab365557af18c7f332a812012eff0dabf1
```

### `dpkg` source package: `libxtst=2:1.2.3-1build4`

Binary Packages:

- `libxtst6:amd64=2:1.2.3-1build4`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxtst=2:1.2.3-1build4
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxtst/libxtst_1.2.3-1build4.dsc' libxtst_1.2.3-1build4.dsc 2375 SHA512:68c25cb4f05b2668bed5181b7065508fdf89e83c3f4d57cd3307c295cc301c4cd9e4787f13c97758e9bfcfeb4c30b83396c01d725fc68b917ba094f22b51bde1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxtst/libxtst_1.2.3.orig.tar.gz' libxtst_1.2.3.orig.tar.gz 400197 SHA512:a6ab344984bb24ae6a82050c3f5ae4ee3daac4f027a9564a52591b9acfe84e4d8be3dd1a8c5e5a0715bed16dc8f2ab43cf62b5a6b39407072ba18d707b680ce9
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxtst/libxtst_1.2.3-1build4.diff.gz' libxtst_1.2.3-1build4.diff.gz 10352 SHA512:58006963636cb070d80416ea2255f4cafd7f11c6577c8dc89260dbe07cacdeeacb36cfaf22a83d901752add35e1e1e4a11294b96cb476ed96692149535760bf3
```

### `dpkg` source package: `libxv=2:1.0.11-1build2`

Binary Packages:

- `libxv1:amd64=2:1.0.11-1build2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxv=2:1.0.11-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxv/libxv_1.0.11-1build2.dsc' libxv_1.0.11-1build2.dsc 2091 SHA512:b63598e3795fcf4f644e5770d14e6c70c0f9a7ac6fb77be67aa084e59a4f56326165fdfc8c4f477f8a47816db3856d327d06b27a5645d75a0ffeb03a2091e8df
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxv/libxv_1.0.11.orig.tar.gz' libxv_1.0.11.orig.tar.gz 387057 SHA512:2e755324afd5d153aa2439b8570d4e97f11eaa75412e85b078d4c525aa73f189e0ee7ff865e1cf28de671545a72a95679e7ba09073d95d4c0792ed38f9f5375f
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxv/libxv_1.0.11-1build2.diff.gz' libxv_1.0.11-1build2.diff.gz 8537 SHA512:b7854d67a0e3f004f94bc32bcacd3ab290a512fcf1e02cc9f3b73425eed415aaeeedafd412316cdf0406160477089b8a8579748eca1bd812703b975eddcf88de
```

### `dpkg` source package: `libxxf86dga=2:1.1.5-0ubuntu3`

Binary Packages:

- `libxxf86dga1:amd64=2:1.1.5-0ubuntu3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxxf86dga=2:1.1.5-0ubuntu3
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxxf86dga/libxxf86dga_1.1.5-0ubuntu3.dsc' libxxf86dga_1.1.5-0ubuntu3.dsc 2296 SHA512:10ac993a375e070e6a15bd4599a3936d13d3143aa96f5bdf204ef9387cf85b679020d5691d0215a96eb57b9c37297d1484f0d99a456609620c8418146cf2b1e1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxxf86dga/libxxf86dga_1.1.5.orig.tar.gz' libxxf86dga_1.1.5.orig.tar.gz 389388 SHA512:a94ac403e0827204ed9aa7e768a433f290da00979b3b48828d653f0405b870b5c3ab22097f568b22fa2026cc36b8239b130998cee7eb1e7ec4973534d7b42e45
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxxf86dga/libxxf86dga_1.1.5-0ubuntu3.diff.gz' libxxf86dga_1.1.5-0ubuntu3.diff.gz 15475 SHA512:7334e52112fa048be3c8248dcdcca438d32ad970a260785505ba4d8dba23892e88772e5d9c6a9a849fceb7fcb387ca77555bccdb3a1db19622c16b71dafbda3d
```

### `dpkg` source package: `libxxf86vm=1:1.1.4-1build3`

Binary Packages:

- `libxxf86vm1:amd64=1:1.1.4-1build3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxxf86vm=1:1.1.4-1build3
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxxf86vm/libxxf86vm_1.1.4-1build3.dsc' libxxf86vm_1.1.4-1build3.dsc 2224 SHA512:3dbc258a766eca26c75e2aa21a7b6f66966f00b810c2a595b63413f26d52b7a862615c5cf57a52ae72476a4834106491b942b6cecb5ab15154b6c81ef6d75642
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxxf86vm/libxxf86vm_1.1.4.orig.tar.gz' libxxf86vm_1.1.4.orig.tar.gz 363146 SHA512:ba9335b45c1466508c6fc8eefaf5785d47b21e10742775c15eb5166d99350fb5827a4b7c8a2fa41248d1f71a69fc321bc3527b2c0658854e21279c7428f30611
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxxf86vm/libxxf86vm_1.1.4-1build3.diff.gz' libxxf86vm_1.1.4-1build3.diff.gz 8418 SHA512:e157bbc7975541dcd114b7af28e6674cdd63ce8f97964acdb165f447079f587fd512b3d36f0316cd072f6380200b995287b1957e8bbd2bc8a436fd52341a9ebb
```

### `dpkg` source package: `libzstd=1.4.8+dfsg-3build1`

Binary Packages:

- `libzstd1:amd64=1.4.8+dfsg-3build1`

Licenses: (parsed from: `/usr/share/doc/libzstd1/copyright`)

- `BSD-3-clause`
- `Expat`
- `GPL-2`
- `zlib`

Source:

```console
$ apt-get source -qq --print-uris libzstd=1.4.8+dfsg-3build1
'http://archive.ubuntu.com/ubuntu/pool/main/libz/libzstd/libzstd_1.4.8%2bdfsg-3build1.dsc' libzstd_1.4.8+dfsg-3build1.dsc 2398 SHA512:cdd444b0258f1effd998781dd058c8ab37fb8aabb10b94cc5741b0fd2c4c948085cd1b919533ded2f30c5a871c68a81dacef3c3d0640b8514d5d3a9d375647f6
'http://archive.ubuntu.com/ubuntu/pool/main/libz/libzstd/libzstd_1.4.8%2bdfsg.orig.tar.xz' libzstd_1.4.8+dfsg.orig.tar.xz 1331996 SHA512:07fabe431367eea4badae7b1e46ac73e0b33aad5b67361bc7b67d5f9aef249c51db5b560f1cf59233255cc49db341a8d8440fed87745026fca7a7c5c14448cd8
'http://archive.ubuntu.com/ubuntu/pool/main/libz/libzstd/libzstd_1.4.8%2bdfsg-3build1.debian.tar.xz' libzstd_1.4.8+dfsg-3build1.debian.tar.xz 12316 SHA512:8123965a6e73c5ddd8d535e78ed1074e2eabd7f8ed090d215a89feedffae9391cf472d2395242d3cb0351cbf76603448dae93ad70d0989806b42b03c65b22db0
```

### `dpkg` source package: `linux=5.15.0-124.134`

Binary Packages:

- `linux-libc-dev:amd64=5.15.0-124.134`

Licenses: (parsed from: `/usr/share/doc/linux-libc-dev/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris linux=5.15.0-124.134
'http://archive.ubuntu.com/ubuntu/pool/main/l/linux/linux_5.15.0-124.134.dsc' linux_5.15.0-124.134.dsc 7799 SHA512:2102ac558feb5f9062f8fbe520e88e8a0a37a80077a068a36b78b5454300d13be66b1ff0789fdde92a7d244f57a4d11f811f949a1ef79e72a40db13a07da90d5
'http://archive.ubuntu.com/ubuntu/pool/main/l/linux/linux_5.15.0.orig.tar.gz' linux_5.15.0.orig.tar.gz 194969557 SHA512:ae9a32132d5988441c189157703b0f8fa4e232d8d24f7104f944c06827db740beafae55eb37a51eb99b4ac513927cd372321fa1e84afff4d450b786e44414861
'http://archive.ubuntu.com/ubuntu/pool/main/l/linux/linux_5.15.0-124.134.diff.gz' linux_5.15.0-124.134.diff.gz 10541149 SHA512:f84744b755d94df0c2bf28f0469979e4825d7c48cc9f732a21717d50d5369cc8c6a48b919c1a62cd21ed3663ffb1c8ac11560fdc72a2b30d0fafd62e15e112ef
```

### `dpkg` source package: `llvm-toolchain-11=1:11.1.0-6`

Binary Packages:

- `libllvm11:amd64=1:11.1.0-6`

Licenses: (parsed from: `/usr/share/doc/libllvm11/copyright`)

- `APACHE-2-LLVM-EXCEPTIONS`
- `Apache-2.0`
- `BSD-3-Clause`
- `BSD-3-clause`
- `MIT`
- `Python`
- `solar-public-domain`

Source:

```console
$ apt-get source -qq --print-uris llvm-toolchain-11=1:11.1.0-6
'http://archive.ubuntu.com/ubuntu/pool/universe/l/llvm-toolchain-11/llvm-toolchain-11_11.1.0-6.dsc' llvm-toolchain-11_11.1.0-6.dsc 6113 SHA512:a2ca961182050078193bb2258ccc6bfe9c26731d3583bfd42202af57fd80d54237aa83f3f90a2b332d4fab0c5faa75eed9877028a19cb587fa1e9f1e3063e2e7
'http://archive.ubuntu.com/ubuntu/pool/universe/l/llvm-toolchain-11/llvm-toolchain-11_11.1.0.orig.tar.xz' llvm-toolchain-11_11.1.0.orig.tar.xz 78762924 SHA512:1847b63589b6963e95bfb6560f7a54ff38587fbeb39a8b39e9bbce9b9517a8c5173c2bf15b6cbcd81c0cde4e6aa76e70cc94deffc94def3e33750e1dbac4b82f
'http://archive.ubuntu.com/ubuntu/pool/universe/l/llvm-toolchain-11/llvm-toolchain-11_11.1.0-6.debian.tar.xz' llvm-toolchain-11_11.1.0-6.debian.tar.xz 154416 SHA512:5200b3f16739720ba80e14d5c28882880fef8d65e09d6374296c288c8aacaee0d55f9c125d0e302a2b87cdf0a13a3325974fd6f0c6984b22c7453b91fd983262
```

### `dpkg` source package: `llvm-toolchain-15=1:15.0.7-0ubuntu0.22.04.3`

Binary Packages:

- `libllvm15:amd64=1:15.0.7-0ubuntu0.22.04.3`

Licenses: (parsed from: `/usr/share/doc/libllvm15/copyright`)

- `APACHE-2-LLVM-EXCEPTIONS`
- `Apache-2.0`
- `BSD-3-Clause`
- `BSD-3-clause`
- `MIT`
- `Python`
- `solar-public-domain`

Source:

```console
$ apt-get source -qq --print-uris llvm-toolchain-15=1:15.0.7-0ubuntu0.22.04.3
'http://archive.ubuntu.com/ubuntu/pool/main/l/llvm-toolchain-15/llvm-toolchain-15_15.0.7-0ubuntu0.22.04.3.dsc' llvm-toolchain-15_15.0.7-0ubuntu0.22.04.3.dsc 7322 SHA512:a0012dd718a164ac489dfe1d059a1cded384c0b7cc172b2f0048e38dceedbe1fd8833fc366b5cf72570a63d12d304d15117ceee4f92ade1c21d35b1ea2c75208
'http://archive.ubuntu.com/ubuntu/pool/main/l/llvm-toolchain-15/llvm-toolchain-15_15.0.7.orig.tar.xz' llvm-toolchain-15_15.0.7.orig.tar.xz 138500556 SHA512:d4e2c3be6bb5f6f780b07839c5398d0d976f392b64b18288578e77f01ec8f4f7bee28ff71250d0fe740b07bc1f47a2178f6b1371e4ba13a76cd7b3e393db9b6e
'http://archive.ubuntu.com/ubuntu/pool/main/l/llvm-toolchain-15/llvm-toolchain-15_15.0.7-0ubuntu0.22.04.3.debian.tar.xz' llvm-toolchain-15_15.0.7-0ubuntu0.22.04.3.debian.tar.xz 166524 SHA512:a13f07064b8a1d608a63b4dc5049ec8216f195273c502609d3b8c0ce3e61c3d873a84cbdcb7460661334e7d5823b614449ec9c91674a5f4c87ba114a37281146
```

### `dpkg` source package: `lm-sensors=1:3.6.0-7ubuntu1`

Binary Packages:

- `libsensors-config=1:3.6.0-7ubuntu1`
- `libsensors5:amd64=1:3.6.0-7ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libsensors-config/copyright`, `/usr/share/doc/libsensors5/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris lm-sensors=1:3.6.0-7ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/l/lm-sensors/lm-sensors_3.6.0-7ubuntu1.dsc' lm-sensors_3.6.0-7ubuntu1.dsc 2174 SHA512:98941ecb3fbe53980337c19da0548aebf2a1b705faa23ab7a9b3e4c2c1bcd449fbb8f4cb97fb51d67d63430a52fea78db19351ded44157680457b1b9d4793d71
'http://archive.ubuntu.com/ubuntu/pool/main/l/lm-sensors/lm-sensors_3.6.0.orig.tar.gz' lm-sensors_3.6.0.orig.tar.gz 273209 SHA512:4e80361913aff5403f1f0737fd4f42cffe43cc170ef48fff3914c9952f71990739d723f7b0b8120d9a01bcbbc829e964cfbd0a5cf18508af8f8dc825b49860bf
'http://archive.ubuntu.com/ubuntu/pool/main/l/lm-sensors/lm-sensors_3.6.0-7ubuntu1.debian.tar.xz' lm-sensors_3.6.0-7ubuntu1.debian.tar.xz 26368 SHA512:b9a64c91755dd1266fa7edb6d743987ffc2fb26f728bd90fa2934f0f8f34cdee381c0df37d6c4447169c732e33dd81ff1ab3ed37ee2971975bebfc2677853c9b
```

### `dpkg` source package: `lmdb=0.9.24-1build2`

Binary Packages:

- `liblmdb0:amd64=0.9.24-1build2`

Licenses: (parsed from: `/usr/share/doc/liblmdb0/copyright`)

- `OpenLDAP-2.8`

Source:

```console
$ apt-get source -qq --print-uris lmdb=0.9.24-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/l/lmdb/lmdb_0.9.24-1build2.dsc' lmdb_0.9.24-1build2.dsc 2121 SHA512:5eece0b68ced0cc47f9af21d602d368011d2438413ef0f604cc277bac3f688a484508ae82f6c7eb1b1df504a7998d23ef0922df20eb8f342232a2908dadff65f
'http://archive.ubuntu.com/ubuntu/pool/main/l/lmdb/lmdb_0.9.24.orig.tar.gz' lmdb_0.9.24.orig.tar.gz 143901 SHA512:dcd64ef297ccfd4366f379d5fb09eb15a2d9b24bdbaad5b4f81dcaba044f19b0617c3c908828b3afc39d889b7eceb489c0d964d3bbc74d21595801f1414b2a6d
'http://archive.ubuntu.com/ubuntu/pool/main/l/lmdb/lmdb_0.9.24-1build2.debian.tar.xz' lmdb_0.9.24-1build2.debian.tar.xz 6252 SHA512:c6f146b88b976108a8b79aaa14dd433977f8905b55b328c8ec0d16c9150c055e2c939213d879927bfe4131393974d54fe59768a8c5301384187c3300280f448d
```

### `dpkg` source package: `lsb=11.1.0ubuntu4`

Binary Packages:

- `lsb-base=11.1.0ubuntu4`

Licenses: (parsed from: `/usr/share/doc/lsb-base/copyright`)

- `BSD-3-clause`
- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris lsb=11.1.0ubuntu4
'http://archive.ubuntu.com/ubuntu/pool/main/l/lsb/lsb_11.1.0ubuntu4.dsc' lsb_11.1.0ubuntu4.dsc 2222 SHA512:2b5375ca5938f497f9211d9b85eaf60858c2d59c80ec40a3a04bec6ef47e6685661589f22514f8b2e4a325038feb0375d99e1f905aa93b4a13c3d474e3b86677
'http://archive.ubuntu.com/ubuntu/pool/main/l/lsb/lsb_11.1.0ubuntu4.tar.xz' lsb_11.1.0ubuntu4.tar.xz 46152 SHA512:03469c3b85facd88fb4c24b85eb42d6aeab171aa6e5860147ad947e2bbc2f2fe5f78ebd4a457f6af194d33173dccec4f672d1b9d460c070765377d9456bc73da
```

### `dpkg` source package: `lto-disabled-list=24`

Binary Packages:

- `lto-disabled-list=24`

Licenses: (parsed from: `/usr/share/doc/lto-disabled-list/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris lto-disabled-list=24
'http://archive.ubuntu.com/ubuntu/pool/main/l/lto-disabled-list/lto-disabled-list_24.dsc' lto-disabled-list_24.dsc 1435 SHA512:14d46d1b6da858d12f43aa6a5d8483512de13e0f4ead44d8a15f04b5b8ebe251ccf30e1828dd23802446cf0d9ace41e3a888ccb330e46de113ebb4bca5f6b52f
'http://archive.ubuntu.com/ubuntu/pool/main/l/lto-disabled-list/lto-disabled-list_24.tar.xz' lto-disabled-list_24.tar.xz 12472 SHA512:c43407072716e18605ed0a032e40f88d8c4f3d5982bfb9cd88820713a08cff8dc1a7461a602cbcfb23362ab6904b63afe5320cfa9438494ab1e932c8e77b1471
```

### `dpkg` source package: `lvm2=2.03.11-2.1ubuntu4`

Binary Packages:

- `dmsetup=2:1.02.175-2.1ubuntu4`
- `libdevmapper1.02.1:amd64=2:1.02.175-2.1ubuntu4`

Licenses: (parsed from: `/usr/share/doc/dmsetup/copyright`, `/usr/share/doc/libdevmapper1.02.1/copyright`)

- `BSD-2-Clause`
- `GPL-2`
- `GPL-2.0`
- `GPL-2.0+`
- `LGPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris lvm2=2.03.11-2.1ubuntu4
'http://archive.ubuntu.com/ubuntu/pool/main/l/lvm2/lvm2_2.03.11-2.1ubuntu4.dsc' lvm2_2.03.11-2.1ubuntu4.dsc 3224 SHA512:aa53f045a72e57b336f2c361b61c584e45c678b84f559d50613c0e6474edc749496652f375bc2521ee1f268c0c49199bb74a855996330babb15c41458161a72e
'http://archive.ubuntu.com/ubuntu/pool/main/l/lvm2/lvm2_2.03.11.orig.tar.xz' lvm2_2.03.11.orig.tar.xz 1699012 SHA512:80befad86e93dea1d3eeb299d864ac5c48880bf196a80898199bf09dc6bc1a30b3c8acc86efed43e8ff62a20280b60b853a0c5772eadf6aa2fbcfd79aad0372d
'http://archive.ubuntu.com/ubuntu/pool/main/l/lvm2/lvm2_2.03.11-2.1ubuntu4.debian.tar.xz' lvm2_2.03.11-2.1ubuntu4.debian.tar.xz 44492 SHA512:7ca2793830b186df73b404768a394b56281832bef5eb7de03244ccff5ef2c0b26f6a44e76929deb3bbcc0a1abc73a861c592812f8cb892d11cb02f8f52ba2612
```

### `dpkg` source package: `lz4=1.9.3-2build2`

Binary Packages:

- `liblz4-1:amd64=1.9.3-2build2`

Licenses: (parsed from: `/usr/share/doc/liblz4-1/copyright`)

- `BSD-2-clause`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris lz4=1.9.3-2build2
'http://archive.ubuntu.com/ubuntu/pool/main/l/lz4/lz4_1.9.3-2build2.dsc' lz4_1.9.3-2build2.dsc 2091 SHA512:a8f802737139536f8a9c0a3483635ff4dd8a3eba2e0d9d0d27f4f91c17592d1797929d491183dc25de4100a7aa924edefa8ca45eed4968c0e1b7e817f1ae9e1c
'http://archive.ubuntu.com/ubuntu/pool/main/l/lz4/lz4_1.9.3.orig.tar.gz' lz4_1.9.3.orig.tar.gz 320958 SHA512:c246b0bda881ee9399fa1be490fa39f43b291bb1d9db72dba8a85db1a50aad416a97e9b300eee3d2a4203c2bd88bda2762e81bc229c3aa409ad217eb306a454c
'http://archive.ubuntu.com/ubuntu/pool/main/l/lz4/lz4_1.9.3-2build2.debian.tar.xz' lz4_1.9.3-2build2.debian.tar.xz 14088 SHA512:9f61516a672186299a96aee5b7a71d9cb1ad3db2697fa10b802fef14a63587bb3459281f7300726711a116893c10858914f558aece1d224876e287020a23dde6
```

### `dpkg` source package: `make-dfsg=4.3-4.1build1`

Binary Packages:

- `make=4.3-4.1build1`

Licenses: (parsed from: `/usr/share/doc/make/copyright`)

- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris make-dfsg=4.3-4.1build1
'http://archive.ubuntu.com/ubuntu/pool/main/m/make-dfsg/make-dfsg_4.3-4.1build1.dsc' make-dfsg_4.3-4.1build1.dsc 2072 SHA512:f5580f5dc9e7d4ee3a7bfcd82a42c0615a4828cac1f84db3c720260209cee3334d0a23ea78113cd2b26eaf233d46ec59743d14a8bd05cfd225f111ff739ad57d
'http://archive.ubuntu.com/ubuntu/pool/main/m/make-dfsg/make-dfsg_4.3.orig.tar.gz' make-dfsg_4.3.orig.tar.gz 1845906 SHA512:bdc150f9d256145923380d6e7058ab9b2b4e43fcb1d75ab2984fa8f859eab6852a68e4ea5f626633e0bec76fbebf1477378e268e8ffdb5cb2a53b29cbc439bc1
'http://archive.ubuntu.com/ubuntu/pool/main/m/make-dfsg/make-dfsg_4.3-4.1build1.diff.gz' make-dfsg_4.3-4.1build1.diff.gz 50780 SHA512:258dc63a0cea09995adfe4091599664e2ef0d5f81c990f980b0ddf9e02212177c4a23fa8d82e886ecbae33c84816c61530e97fd82c5347ff25a434a3aa6732ae
```

### `dpkg` source package: `manpages=5.10-1ubuntu1`

Binary Packages:

- `manpages=5.10-1ubuntu1`
- `manpages-dev=5.10-1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/manpages/copyright`, `/usr/share/doc/manpages-dev/copyright`)

- `BSD-3-clause`
- `BSD-4-clause`
- `Expat`
- `GPL-2`
- `GPL-2+`
- `LDPv1`
- `freely-redistributable`
- `henry-spencer-regex`
- `public-domain`
- `verbatim`

Source:

```console
$ apt-get source -qq --print-uris manpages=5.10-1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/m/manpages/manpages_5.10-1ubuntu1.dsc' manpages_5.10-1ubuntu1.dsc 2014 SHA512:b8c7fc25e53c38979b9536bed6fcaf1daaab297e6e844ec23e2e31b92a6890d60806af277580bebfa8f644a8135eff7a88d08313f5add373fea0fa3f86438802
'http://archive.ubuntu.com/ubuntu/pool/main/m/manpages/manpages_5.10.orig.tar.xz' manpages_5.10.orig.tar.xz 1747688 SHA512:a23f90136b0bf471f5ae3917ae0e558fec0671cace8ccdd8e244f41f11fefa4ac0df84cf972cc20a1792d7b930db5e2c451881c0937edabf7d5e1ec46c4760ed
'http://archive.ubuntu.com/ubuntu/pool/main/m/manpages/manpages_5.10-1ubuntu1.debian.tar.xz' manpages_5.10-1ubuntu1.debian.tar.xz 78452 SHA512:331e058a205e42268316e834db91d036fb16bb4b46463d138f10bb9527ff96cdbcfa9c06155fa150d6258398ffa135e18dfffce708a97ebc7b494b4bab6d8b18
```

### `dpkg` source package: `mawk=1.3.4.20200120-3`

Binary Packages:

- `mawk=1.3.4.20200120-3`

Licenses: (parsed from: `/usr/share/doc/mawk/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris mawk=1.3.4.20200120-3
'http://archive.ubuntu.com/ubuntu/pool/main/m/mawk/mawk_1.3.4.20200120-3.dsc' mawk_1.3.4.20200120-3.dsc 1915 SHA512:f51dae1f342769e4fc0b8d5faf4e988433a0e74912ba0777fbafdf058900c973087c267756f5c2b74298bfc31a36c8bbc99c6c0edcc850710b646d0d24fa1305
'http://archive.ubuntu.com/ubuntu/pool/main/m/mawk/mawk_1.3.4.20200120.orig.tar.gz' mawk_1.3.4.20200120.orig.tar.gz 468855 SHA512:14d9a6642ce931bf6457d248fc2d6da4f0ea7541976ca282ea708b26df048f86fdf92c27f72d497501ccd43a244d1d1a606f1a2f266a7558306fea35dcc3041b
'http://archive.ubuntu.com/ubuntu/pool/main/m/mawk/mawk_1.3.4.20200120-3.debian.tar.xz' mawk_1.3.4.20200120-3.debian.tar.xz 7520 SHA512:bc4f5401de313108595ba91b17f44b5c67d7650b5557eef8a6c63c75e2ccee5dfd8900576d7e81f0ab1ac2e570f64fa75f38f56f6d4535437c803029216501af
```

### `dpkg` source package: `media-types=7.0.0`

Binary Packages:

- `media-types=7.0.0`

Licenses: (parsed from: `/usr/share/doc/media-types/copyright`)

- `ad-hoc`

Source:

```console
$ apt-get source -qq --print-uris media-types=7.0.0
'http://archive.ubuntu.com/ubuntu/pool/main/m/media-types/media-types_7.0.0.dsc' media-types_7.0.0.dsc 1620 SHA512:f5159688820b267f4349dce11a3427bb70d8185494386ec37076885c36c4dfda8de9daf82a92cd84442604b33dfb7835ae2121bead8151ae5e14ed375a9d9659
'http://archive.ubuntu.com/ubuntu/pool/main/m/media-types/media-types_7.0.0.tar.xz' media-types_7.0.0.tar.xz 55660 SHA512:ce4b07388c490c7e3e1bdd1dcdd28c685eee81cb9d167cc903f427a28bf972210b8d5ad3d33af06530b4dba0ac7f2a2b6e914c1d88bc1e88db589de6b4490071
```

### `dpkg` source package: `mesa-amber=21.3.9-0ubuntu1~22.04.1`

Binary Packages:

- `libgl1-amber-dri:amd64=21.3.9-0ubuntu1~22.04.1`

Licenses: (parsed from: `/usr/share/doc/libgl1-amber-dri/copyright`)

- `Apache-2.0`
- `BSD-2-clause`
- `BSD-3-google`
- `BSL`
- `GPL-1`
- `GPL-1+`
- `GPL-2`
- `Khronos`
- `MIT`
- `MLAA`
- `SGI`

Source:

```console
$ apt-get source -qq --print-uris mesa-amber=21.3.9-0ubuntu1~22.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/m/mesa-amber/mesa-amber_21.3.9-0ubuntu1%7e22.04.1.dsc' mesa-amber_21.3.9-0ubuntu1~22.04.1.dsc 2754 SHA512:364a60bb760a15a848ae647a82c60ee2aa745ce6de99905f558b8d14d685ee956d7feb346ab5d540199556420548d7ad961f43ee360380c70a7de211c95b2984
'http://archive.ubuntu.com/ubuntu/pool/main/m/mesa-amber/mesa-amber_21.3.9.orig.tar.gz' mesa-amber_21.3.9.orig.tar.gz 25269804 SHA512:693eb0b845e4b4708e9c81542041cc45f6240e31f101ba6dcd1b14f3c765f7b5424e7c9cfbb94878f7679dd305cf0daf122fe539a76c8d32861e30f7a07e62f8
'http://archive.ubuntu.com/ubuntu/pool/main/m/mesa-amber/mesa-amber_21.3.9-0ubuntu1%7e22.04.1.diff.gz' mesa-amber_21.3.9-0ubuntu1~22.04.1.diff.gz 50883 SHA512:0b7566ab01772aa4a5cd8ed4cafe85ebfebc0e5c409c456aae82709f15d5902227bb5b4644477735a0e78efc0c78010d76635aec25364eae35202b17830eb413
```

### `dpkg` source package: `mesa=23.2.1-1ubuntu3.1~22.04.2`

Binary Packages:

- `libgl1-mesa-dri:amd64=23.2.1-1ubuntu3.1~22.04.2`
- `libglapi-mesa:amd64=23.2.1-1ubuntu3.1~22.04.2`
- `libglx-mesa0:amd64=23.2.1-1ubuntu3.1~22.04.2`

Licenses: (parsed from: `/usr/share/doc/libgl1-mesa-dri/copyright`, `/usr/share/doc/libglapi-mesa/copyright`, `/usr/share/doc/libglx-mesa0/copyright`)

- `Apache-2.0`
- `BSD-2-clause`
- `BSD-3-google`
- `BSL`
- `GPL`
- `GPL-1`
- `GPL-1+`
- `GPL-2`
- `Khronos`
- `MIT`
- `MLAA`
- `SGI`

Source:

```console
$ apt-get source -qq --print-uris mesa=23.2.1-1ubuntu3.1~22.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/m/mesa/mesa_23.2.1-1ubuntu3.1%7e22.04.2.dsc' mesa_23.2.1-1ubuntu3.1~22.04.2.dsc 5839 SHA512:ae25aa67baa03fffb712aaaefc72cd11863fae479dff7b8ae24102b606f9defc67286752996e94c8b0a8fba5aebcaacdad75fba1c1075d27966ffc4ab3508327
'http://archive.ubuntu.com/ubuntu/pool/main/m/mesa/mesa_23.2.1.orig.tar.gz' mesa_23.2.1.orig.tar.gz 30631591 SHA512:9836624a9731fb5046ef7a08357f8e0c342fbc88b2911e65cdb0f99064991a913c9b976325945b30169d554f9cc879e931dff34da357cd27330e4460eda58e9a
'http://archive.ubuntu.com/ubuntu/pool/main/m/mesa/mesa_23.2.1-1ubuntu3.1%7e22.04.2.diff.gz' mesa_23.2.1-1ubuntu3.1~22.04.2.diff.gz 218750 SHA512:2356962572d10a19ea05d4588f2b2e341245ee583d55425d05c8c2273263311833283ed7a90c18427038c919e03a19a6015cebbad80c897d8872de8ee390b3b0
```

### `dpkg` source package: `mgcv=1.8-39-1`

Binary Packages:

- `r-cran-mgcv=1.8-39-1`

Licenses: (parsed from: `/usr/share/doc/r-cran-mgcv/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris mgcv=1.8-39-1
'http://archive.ubuntu.com/ubuntu/pool/universe/m/mgcv/mgcv_1.8-39-1.dsc' mgcv_1.8-39-1.dsc 1833 SHA512:c9d534e8ba1cbc9d9583c61ea430d025f0254fce8f380bf708c23d207543c03307fa1936cd8963e199944f3bfb0e4ce66de5524b7565b099153b98ef9c61ea20
'http://archive.ubuntu.com/ubuntu/pool/universe/m/mgcv/mgcv_1.8-39.orig.tar.gz' mgcv_1.8-39.orig.tar.gz 1208343 SHA512:f664dceaa3680ec9a5a89781bef1d8206f2874f8397c0e9d639634cc7df044ccd738c950504418cbe82158432a92eb4e5911b1500434e820098eecfb1a58988a
'http://archive.ubuntu.com/ubuntu/pool/universe/m/mgcv/mgcv_1.8-39-1.debian.tar.xz' mgcv_1.8-39-1.debian.tar.xz 5428 SHA512:9b6676b5bb1f9d0a00d45974cfbb2a0bb9882cc4a17bda39970ac05c2f52c60b23b89594a4793191e88af7e1083655b18a52dbef4a02472dfc76a239b077c353
```

### `dpkg` source package: `mpclib3=1.2.1-2build1`

Binary Packages:

- `libmpc3:amd64=1.2.1-2build1`

Licenses: (parsed from: `/usr/share/doc/libmpc3/copyright`)

- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris mpclib3=1.2.1-2build1
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpclib3/mpclib3_1.2.1-2build1.dsc' mpclib3_1.2.1-2build1.dsc 1984 SHA512:5aa91f39d40bebc1f9ae03506c17687b75ea88d8129baf3a47b6d3d4fe3aba7b1aec499e219b7357747069ea40b8f593b33165c62687a4cb2fcc5e8a21428ffc
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpclib3/mpclib3_1.2.1.orig.tar.gz' mpclib3_1.2.1.orig.tar.gz 838731 SHA512:3279f813ab37f47fdcc800e4ac5f306417d07f539593ca715876e43e04896e1d5bceccfb288ef2908a3f24b760747d0dbd0392a24b9b341bc3e12082e5c836ee
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpclib3/mpclib3_1.2.1-2build1.debian.tar.xz' mpclib3_1.2.1-2build1.debian.tar.xz 4576 SHA512:0317f40da1ee5a7ad5733760226ec6ba4cddf7c4fae32b91e771f40bdb1b8a116854cb1cde85566072ef0199d7fbf046ff20fd67ef2ddb655038cb2e19e58662
```

### `dpkg` source package: `mpdecimal=2.5.1-2build2`

Binary Packages:

- `libmpdec3:amd64=2.5.1-2build2`

Licenses: (parsed from: `/usr/share/doc/libmpdec3/copyright`)

- `BSD`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris mpdecimal=2.5.1-2build2
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpdecimal/mpdecimal_2.5.1-2build2.dsc' mpdecimal_2.5.1-2build2.dsc 2026 SHA512:2f930154a94b9b4090f18e848ea94d115304827e351abc9141ef8646b9937a0f93eb2517790b661b0569e22bb498497c03972233e1ace6bdd85c9fc6922e7e70
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpdecimal/mpdecimal_2.5.1.orig.tar.gz' mpdecimal_2.5.1.orig.tar.gz 2584021 SHA512:710cb5cb71dbcf3e170ca15869c148df0547b848400c6b6dd70c67d9961dbe1190af8fb4d1623bfb0ca2afe44f369a42e311ab5225ed89d4031cb49a3bd70f30
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpdecimal/mpdecimal_2.5.1-2build2.debian.tar.xz' mpdecimal_2.5.1-2build2.debian.tar.xz 6860 SHA512:261ab28a609fbcff2b9561f1b1e484500c5652e48bd0abc4f8c5df73b7e00333b80f1fe416c84800690d13d52d2af72d97503dcd0afa61073ee5610d62a52a02
```

### `dpkg` source package: `mpfr4=4.1.0-3build3`

Binary Packages:

- `libmpfr6:amd64=4.1.0-3build3`

Licenses: (parsed from: `/usr/share/doc/libmpfr6/copyright`)

- `GFDL-1.2`
- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris mpfr4=4.1.0-3build3
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpfr4/mpfr4_4.1.0-3build3.dsc' mpfr4_4.1.0-3build3.dsc 2066 SHA512:60ea156f6c4a56320ecfb2fefb226b5083363710eacbdec48f36f77bd5265c91548ef28ba775a88c7e927314e5dd757de851001bc7697f863195510047eaf0a3
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpfr4/mpfr4_4.1.0.orig.tar.xz' mpfr4_4.1.0.orig.tar.xz 1525476 SHA512:1bd1c349741a6529dfa53af4f0da8d49254b164ece8a46928cdb13a99460285622d57fe6f68cef19c6727b3f9daa25ddb3d7d65c201c8f387e421c7f7bee6273
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpfr4/mpfr4_4.1.0-3build3.debian.tar.xz' mpfr4_4.1.0-3build3.debian.tar.xz 12580 SHA512:1126a59104a9556f7ebd622b050b52899bd92442673e6ecbb04e80bc873107b4b61a356373d14b1fff5681090b177e0d3a9a4f212b0f38c347d01ac408222bd0
```

### `dpkg` source package: `ncurses=6.3-2ubuntu0.1`

Binary Packages:

- `libncurses-dev:amd64=6.3-2ubuntu0.1`
- `libncurses5-dev:amd64=6.3-2ubuntu0.1`
- `libncurses6:amd64=6.3-2ubuntu0.1`
- `libncursesw6:amd64=6.3-2ubuntu0.1`
- `libtinfo6:amd64=6.3-2ubuntu0.1`
- `ncurses-base=6.3-2ubuntu0.1`
- `ncurses-bin=6.3-2ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libncurses-dev/copyright`, `/usr/share/doc/libncurses5-dev/copyright`, `/usr/share/doc/libncurses6/copyright`, `/usr/share/doc/libncursesw6/copyright`, `/usr/share/doc/libtinfo6/copyright`, `/usr/share/doc/ncurses-base/copyright`, `/usr/share/doc/ncurses-bin/copyright`)

- `BSD-3-clause`
- `MIT/X11`
- `X11`

Source:

```console
$ apt-get source -qq --print-uris ncurses=6.3-2ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/n/ncurses/ncurses_6.3-2ubuntu0.1.dsc' ncurses_6.3-2ubuntu0.1.dsc 3955 SHA512:e018fe9a8a641efddfcac0e92ce46dbba3067ddc6850e7223b3abc668f1620c1ea1564d80a63b94ff1c37705630eb2116d5c4449f1115315def4d4008e5f5926
'http://archive.ubuntu.com/ubuntu/pool/main/n/ncurses/ncurses_6.3.orig.tar.gz' ncurses_6.3.orig.tar.gz 3583550 SHA512:5373f228cba6b7869210384a607a2d7faecfcbfef6dbfcd7c513f4e84fbd8bcad53ac7db2e7e84b95582248c1039dcfc7c4db205a618f7da22a166db482f0105
'http://archive.ubuntu.com/ubuntu/pool/main/n/ncurses/ncurses_6.3.orig.tar.gz.asc' ncurses_6.3.orig.tar.gz.asc 729 SHA512:5673088e7d6af580e8f1e163687146adb51261cd3c75be9ea61368c7590efc0e5e4bc1c2ae76d717f289ff6609089c5ca1f7e4a572266d7b6c5daba98eabed2e
'http://archive.ubuntu.com/ubuntu/pool/main/n/ncurses/ncurses_6.3-2ubuntu0.1.debian.tar.xz' ncurses_6.3-2ubuntu0.1.debian.tar.xz 56080 SHA512:d37d4fc956ad1410d0338ee4f5b465e58f35056e33d909a4871d738ef83d9002200d5c31f35ee23e6817db950fd2e227a87e5e01bde8df221dfa2650edb7583a
```

### `dpkg` source package: `net-tools=1.60+git20181103.0eebece-1ubuntu5`

Binary Packages:

- `net-tools=1.60+git20181103.0eebece-1ubuntu5`

Licenses: (parsed from: `/usr/share/doc/net-tools/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris net-tools=1.60+git20181103.0eebece-1ubuntu5
'http://archive.ubuntu.com/ubuntu/pool/main/n/net-tools/net-tools_1.60%2bgit20181103.0eebece-1ubuntu5.dsc' net-tools_1.60+git20181103.0eebece-1ubuntu5.dsc 2272 SHA512:80c54bcf808ff44d21202ca74522f5ff7473dedf9eca6a82bc580295305ed8c43fd5da3d8162dba667104d892c7504f3aa246ee7efa09475d5eb1c3eaa71fc46
'http://archive.ubuntu.com/ubuntu/pool/main/n/net-tools/net-tools_1.60%2bgit20181103.0eebece.orig.tar.xz' net-tools_1.60+git20181103.0eebece.orig.tar.xz 197516 SHA512:2ae46a478eecbdc42b5233505329fd296137e1f7d603304f55afcc8ed1f0c89877305f2f47ff0794126e5dab063a380992fb4a57ee12f4803f26ef30ae164345
'http://archive.ubuntu.com/ubuntu/pool/main/n/net-tools/net-tools_1.60%2bgit20181103.0eebece-1ubuntu5.debian.tar.xz' net-tools_1.60+git20181103.0eebece-1ubuntu5.debian.tar.xz 60436 SHA512:17428ca68c38be73955ec58d03bf3862ae2a14dff93956bd26fefe2883a0d0bcb67c7c108cf89443cf8f344c450b3c442b45496647fdd43cb262cfb4835aec47
```

### `dpkg` source package: `netbase=6.3`

Binary Packages:

- `netbase=6.3`

Licenses: (parsed from: `/usr/share/doc/netbase/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris netbase=6.3
'http://archive.ubuntu.com/ubuntu/pool/main/n/netbase/netbase_6.3.dsc' netbase_6.3.dsc 875 SHA512:e21e2c228f5963f34636c646d92280c6307527c1796f3da89a5ec9d26d4a10c08730d68f337f43ebbcd6cc22c4f8fd804673336fbcc9fd41eb1d4f0e687b2a7d
'http://archive.ubuntu.com/ubuntu/pool/main/n/netbase/netbase_6.3.tar.xz' netbase_6.3.tar.xz 31968 SHA512:3ba7f8b28a9b6ffd89bef62a3c2629cf6ad6b0522319ae7eae46d579aac6f86079930da3b3dd55c76ae48cf6c842f8f162b24324e2f8427e3664fd0db69ed138
```

### `dpkg` source package: `nettle=3.7.3-1build2`

Binary Packages:

- `libhogweed6:amd64=3.7.3-1build2`
- `libnettle8:amd64=3.7.3-1build2`

Licenses: (parsed from: `/usr/share/doc/libhogweed6/copyright`, `/usr/share/doc/libnettle8/copyright`)

- `Expat`
- `GAP`
- `GPL`
- `GPL-2`
- `GPL-2+`
- `GPL-3+`
- `GPL-3+ with Autoconf exception`
- `LGPL`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-3+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris nettle=3.7.3-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/n/nettle/nettle_3.7.3-1build2.dsc' nettle_3.7.3-1build2.dsc 2165 SHA512:3f774011dd48205720ac7e6aa9a44b5afa64c24fce825d6583b58c02f3c8f500ecafa265d18d5deb1ab65d6e938dd76a7917f1d5c3dab0aea28148d531fa26cd
'http://archive.ubuntu.com/ubuntu/pool/main/n/nettle/nettle_3.7.3.orig.tar.gz' nettle_3.7.3.orig.tar.gz 2383985 SHA512:9901eba305421adff6d551ac7f478dff3f68a339d444c776724ab0b977fe6be792b1d2950c8705acbe76bd924fd6d898a65eded546777884be3b436d0e052437
'http://archive.ubuntu.com/ubuntu/pool/main/n/nettle/nettle_3.7.3-1build2.debian.tar.xz' nettle_3.7.3-1build2.debian.tar.xz 22100 SHA512:c1935d35e9f04798273053ab92c7405ec225a5d72ba6c2869b0f2bf54b459ac428e113bc149796e91834a8b56082f8bbfbb906a6cd6787142b8932bd1dd83cec
```

### `dpkg` source package: `networkd-dispatcher=2.1-2ubuntu0.22.04.2`

Binary Packages:

- `networkd-dispatcher=2.1-2ubuntu0.22.04.2`

Licenses: (parsed from: `/usr/share/doc/networkd-dispatcher/copyright`)

- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris networkd-dispatcher=2.1-2ubuntu0.22.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/n/networkd-dispatcher/networkd-dispatcher_2.1-2ubuntu0.22.04.2.dsc' networkd-dispatcher_2.1-2ubuntu0.22.04.2.dsc 1936 SHA512:2d41953df86cdd9674a79cb5b71399a21532c74ca5507e913fe4f12fef272da296b0584e538b5add78588a0b9808942fa58fa9b3cbf77121e6d3695dcba983a9
'http://archive.ubuntu.com/ubuntu/pool/main/n/networkd-dispatcher/networkd-dispatcher_2.1.orig.tar.gz' networkd-dispatcher_2.1.orig.tar.gz 29650 SHA512:99c456bbb82158dd0dd18a24825d7303f14c650851f9848ad288dcd00af3ec4c4c175c2d54945e1670d4eb5288612f0ec6fb37ec7b9cbca3fd1cc66231cd634d
'http://archive.ubuntu.com/ubuntu/pool/main/n/networkd-dispatcher/networkd-dispatcher_2.1-2ubuntu0.22.04.2.debian.tar.xz' networkd-dispatcher_2.1-2ubuntu0.22.04.2.debian.tar.xz 9080 SHA512:58170798339971f04df40c297b867873b3e921ab71924011b55ff736c86eae346159f6f5a85cb70dc1cfcb1badd39a151f5fb9d57c5aec15fab75848c682c450
```

### `dpkg` source package: `nghttp2=1.43.0-1ubuntu0.2`

Binary Packages:

- `libnghttp2-14:amd64=1.43.0-1ubuntu0.2`

Licenses: (parsed from: `/usr/share/doc/libnghttp2-14/copyright`)

- `BSD-2-clause`
- `Expat`
- `GPL-3`
- `GPL-3+ with autoconf exception`
- `MIT`
- `SIL-OFL-1.1`
- `all-permissive`

Source:

```console
$ apt-get source -qq --print-uris nghttp2=1.43.0-1ubuntu0.2
'http://archive.ubuntu.com/ubuntu/pool/main/n/nghttp2/nghttp2_1.43.0-1ubuntu0.2.dsc' nghttp2_1.43.0-1ubuntu0.2.dsc 2679 SHA512:2ad7840a04e95d55fa98b6693be289fcc86330c2b9ea06b08cdf9f1bd2c3e0bffe2f312433f243ea8b7fd8ffeeba9c840581b3eb1bef662f487d075a8428ad2a
'http://archive.ubuntu.com/ubuntu/pool/main/n/nghttp2/nghttp2_1.43.0.orig.tar.bz2' nghttp2_1.43.0.orig.tar.bz2 4521786 SHA512:f2e6665ad6c73f0a1a8c7b34ca821a905868d41dafca913e6a054eb5afb534a85ae91618c1a4b098e43f350ca3703fd1ece7848f0a771e8393a3eb0581ceaf59
'http://archive.ubuntu.com/ubuntu/pool/main/n/nghttp2/nghttp2_1.43.0-1ubuntu0.2.debian.tar.xz' nghttp2_1.43.0-1ubuntu0.2.debian.tar.xz 23788 SHA512:ebbbd0c00089e2b48feef151b00b952cfec456662f35d8dd68e886008cdb61bec788c5fa8bbd63614c18a2e06f187bf3112417e759a4f55a9c0db27511aa461a
```

### `dpkg` source package: `nlme=3.1.155-1`

Binary Packages:

- `r-cran-nlme=3.1.155-1`

Licenses: (parsed from: `/usr/share/doc/r-cran-nlme/copyright`)

- `GPL`
- `GPL `

Source:

```console
$ apt-get source -qq --print-uris nlme=3.1.155-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/nlme/nlme_3.1.155-1.dsc' nlme_3.1.155-1.dsc 1840 SHA512:a803b6667b58d25c361cda88f6b03a80095e7b57e4ca87f3a4aa685219d75042d0aa4a9eea6787a1a577c52d02979178c07a0f5704c009108348a7c4eab773e9
'http://archive.ubuntu.com/ubuntu/pool/universe/n/nlme/nlme_3.1.155.orig.tar.gz' nlme_3.1.155.orig.tar.gz 806854 SHA512:1dcb7b1bffd75e2907237143eb31c46f30da0248be4f3731cbe2e3c85d42f1074db8be47f94fb98bc3b0a5cd2dbc5292627c457677d4c5565cdc676428c21656
'http://archive.ubuntu.com/ubuntu/pool/universe/n/nlme/nlme_3.1.155-1.debian.tar.xz' nlme_3.1.155-1.debian.tar.xz 7188 SHA512:273b4ab01f6a2cac566ebab0c7ad1b7dfce1392a97489be7c153d7a95e00b15362885c6588d0c4afaf1039b2c1580430c218ed8b7801a78c72d6bac49b55bf72
```

### `dpkg` source package: `npth=1.6-3build2`

Binary Packages:

- `libnpth0:amd64=1.6-3build2`

Licenses: (parsed from: `/usr/share/doc/libnpth0/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris npth=1.6-3build2
'http://archive.ubuntu.com/ubuntu/pool/main/n/npth/npth_1.6-3build2.dsc' npth_1.6-3build2.dsc 2063 SHA512:19ea7bd0ffc2b0aff06c52298c9a25c2f30619239bea09b571feb4a3d162f461a4529136e351da42b16ab3eaef5add24234f644e822e859ccb32de5bfd658ec0
'http://archive.ubuntu.com/ubuntu/pool/main/n/npth/npth_1.6.orig.tar.bz2' npth_1.6.orig.tar.bz2 300486 SHA512:2ed1012e14a9d10665420b9a23628be7e206fd9348111ec751349b93557ee69f1176bcf7e6b195b35b1c44a5e0e81ee33b713f03d79a33d1ecd9037035afeda2
'http://archive.ubuntu.com/ubuntu/pool/main/n/npth/npth_1.6-3build2.debian.tar.xz' npth_1.6-3build2.debian.tar.xz 10904 SHA512:426ab3ab9e27b3701d67cde0a4c4040aa9ccac22a0266321824487fe80a118ccd6860b6fa0fb5ca3c46dfa3c20053889fbb51a2e74618065b3aff059a0216c4c
```

### `dpkg` source package: `nspr=2:4.35-0ubuntu0.22.04.1`

Binary Packages:

- `libnspr4:amd64=2:4.35-0ubuntu0.22.04.1`

Licenses: (parsed from: `/usr/share/doc/libnspr4/copyright`)

- `MPL-2.0`

Source:

```console
$ apt-get source -qq --print-uris nspr=2:4.35-0ubuntu0.22.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/n/nspr/nspr_4.35-0ubuntu0.22.04.1.dsc' nspr_4.35-0ubuntu0.22.04.1.dsc 2110 SHA512:ace773b6a831b5fc42989f5f2fe7f9facb26e4796fbdc5e28353dd3b37e72820fa0ac93b120fc277c19ca49d99db481a3dd0311f2b9b2fe6afd18864726b9380
'http://archive.ubuntu.com/ubuntu/pool/main/n/nspr/nspr_4.35.orig.tar.gz' nspr_4.35.orig.tar.gz 1096974 SHA512:502815833116e25f79ddf71d1526484908aa92fbc55f8a892729cb404a4daafcc0470a89854cd080d2d20299fdb7d9662507c5362c7ae661cbacf308ac56ef7f
'http://archive.ubuntu.com/ubuntu/pool/main/n/nspr/nspr_4.35-0ubuntu0.22.04.1.debian.tar.xz' nspr_4.35-0ubuntu0.22.04.1.debian.tar.xz 11384 SHA512:70aafc40c11aa995ce9fb3a2182f90c84011beaa3bcf8e33b19e0d1c398979833326cf891d45f27308f64f242ea3b14a2304e31fed4bdfd0f9555db754b6b6f5
```

### `dpkg` source package: `nss-wrapper=1.1.11-1ubuntu2`

Binary Packages:

- `libnss-wrapper:amd64=1.1.11-1ubuntu2`

Licenses: (parsed from: `/usr/share/doc/libnss-wrapper/copyright`)

- `BSD-3-clauses`

Source:

```console
$ apt-get source -qq --print-uris nss-wrapper=1.1.11-1ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/nss-wrapper/nss-wrapper_1.1.11-1ubuntu2.dsc' nss-wrapper_1.1.11-1ubuntu2.dsc 2309 SHA512:eab901edad2c86ed3f5ec0e198b7878f394902937c832cdec8529adcb3ec0817549c86ed6f1f3aba2244e520705d8d793696fb36a12ca7b093c3eedcfed9d911
'http://archive.ubuntu.com/ubuntu/pool/universe/n/nss-wrapper/nss-wrapper_1.1.11.orig.tar.gz' nss-wrapper_1.1.11.orig.tar.gz 93431 SHA512:8a0dfa6ccf865640f86168f0dc2915675b5815cacc36bdacbfc1163ec4b38a28be5a160d1c9e6d3785890bc5e12e32b8c070dcabb52c6dd6235ebeed51d51857
'http://archive.ubuntu.com/ubuntu/pool/universe/n/nss-wrapper/nss-wrapper_1.1.11-1ubuntu2.debian.tar.gz' nss-wrapper_1.1.11-1ubuntu2.debian.tar.gz 5651 SHA512:76da297a0c8cc828cac95b8310fc0006d9730eae851ba47afd5fb1d2a80e19ce149d712b42634539966d6b07d022952928fe428f3f366c9a0f71e62a21c97b48
```

### `dpkg` source package: `nss=2:3.98-0ubuntu0.22.04.2`

Binary Packages:

- `libnss3:amd64=2:3.98-0ubuntu0.22.04.2`

Licenses: (parsed from: `/usr/share/doc/libnss3/copyright`)

- `BSD-3`
- `MIT`
- `MPL-2.0`
- `Zlib`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris nss=2:3.98-0ubuntu0.22.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/n/nss/nss_3.98-0ubuntu0.22.04.2.dsc' nss_3.98-0ubuntu0.22.04.2.dsc 2294 SHA512:20d109133d756e1fa15ce04303443d99b6105a73595dece3b6eaad781df15dc89102ed92c4291dc1142cee27244cc3a32914af97acbd69d5904c367e5a116899
'http://archive.ubuntu.com/ubuntu/pool/main/n/nss/nss_3.98.orig.tar.gz' nss_3.98.orig.tar.gz 76685475 SHA512:4f335c5c284eff6424745cc15e32037715a915f6f61687ec36a8ffaef0e45d152602a1be275bbb2f14650c7d258d6488430cdcf512b18ba7cb73cd43ac625681
'http://archive.ubuntu.com/ubuntu/pool/main/n/nss/nss_3.98-0ubuntu0.22.04.2.debian.tar.xz' nss_3.98-0ubuntu0.22.04.2.debian.tar.xz 26096 SHA512:20bebf5fee2d03d7078a0ac7558ecd764abf6124f2259f7283db0d397322a35dd12bdb007518cc8e9b9ef5c8fec8f0466d594ffd6d1d3bc1ecc24e1aa75393e3
```

### `dpkg` source package: `openldap=2.5.18+dfsg-0ubuntu0.22.04.2`

Binary Packages:

- `libldap-2.5-0:amd64=2.5.18+dfsg-0ubuntu0.22.04.2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris openldap=2.5.18+dfsg-0ubuntu0.22.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/o/openldap/openldap_2.5.18%2bdfsg-0ubuntu0.22.04.2.dsc' openldap_2.5.18+dfsg-0ubuntu0.22.04.2.dsc 3319 SHA512:b487516e28201e7d879487ad9b6dab1eb1d5eb6a241394e5fc518fdbc1e0b29062d15df3b393dd7bf72113c389d482d26c6937a22e40a7d78c7c6f73bc19944c
'http://archive.ubuntu.com/ubuntu/pool/main/o/openldap/openldap_2.5.18%2bdfsg.orig.tar.gz' openldap_2.5.18+dfsg.orig.tar.gz 5623023 SHA512:5f0f71c6711bc8e4b463832d2073d41d92886cdbe3c7a20bca54579c4df30d25de5f388165d975ace600073593502d73a5009ad00f135adc9f1270515fb4ff21
'http://archive.ubuntu.com/ubuntu/pool/main/o/openldap/openldap_2.5.18%2bdfsg-0ubuntu0.22.04.2.debian.tar.xz' openldap_2.5.18+dfsg-0ubuntu0.22.04.2.debian.tar.xz 172632 SHA512:f40e948a37ad373187b6007c033e6cbbd63775b1b424f62f9446a9f35b9b354d0c8a8ae3efe470d63e444af984bb2f28947ebc0521923cb50adc4ea2eba21843
```

### `dpkg` source package: `openssl=3.0.2-0ubuntu1.18`

Binary Packages:

- `libssl3:amd64=3.0.2-0ubuntu1.18`
- `openssl=3.0.2-0ubuntu1.18`

Licenses: (parsed from: `/usr/share/doc/libssl3/copyright`, `/usr/share/doc/openssl/copyright`)

- `Apache-2.0`
- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris openssl=3.0.2-0ubuntu1.18
'http://archive.ubuntu.com/ubuntu/pool/main/o/openssl/openssl_3.0.2-0ubuntu1.18.dsc' openssl_3.0.2-0ubuntu1.18.dsc 2730 SHA512:063002f9a86d0ab1c1932ded24a4e3624294a560a937a3234d3f0523d19acb8f56be2fe4c452a10aa659250d6026a06ecc4988101e27b79a733833170ba2f651
'http://archive.ubuntu.com/ubuntu/pool/main/o/openssl/openssl_3.0.2.orig.tar.gz' openssl_3.0.2.orig.tar.gz 15038141 SHA512:f986850d5be908b4d6b5fd7091bc4652d7378c9bccebfbc5becd7753843c04c1eb61a1749c432139d263dfac33df0b1f6c773664b485cad47542266823a4eb03
'http://archive.ubuntu.com/ubuntu/pool/main/o/openssl/openssl_3.0.2.orig.tar.gz.asc' openssl_3.0.2.orig.tar.gz.asc 488 SHA512:4303391a58107c76ad9b05510f5bfc95f687f4cb2f9ff5b03fb262ba99b573423ab83f0437471199954496799b343191b889ad9ef8fabdd7ee4ec3ec9b5f1d81
'http://archive.ubuntu.com/ubuntu/pool/main/o/openssl/openssl_3.0.2-0ubuntu1.18.debian.tar.xz' openssl_3.0.2-0ubuntu1.18.debian.tar.xz 263268 SHA512:67e7d3d71428c12fccfeb354ffdbedacb867df025bd222cd4d3796ff37a630ba3adb541f03180aa57511c8c9e4330260f89141bced621dcafc89736c3d33f0b5
```

### `dpkg` source package: `p11-kit=0.24.0-6build1`

Binary Packages:

- `libp11-kit0:amd64=0.24.0-6build1`
- `p11-kit=0.24.0-6build1`
- `p11-kit-modules:amd64=0.24.0-6build1`

Licenses: (parsed from: `/usr/share/doc/libp11-kit0/copyright`, `/usr/share/doc/p11-kit/copyright`, `/usr/share/doc/p11-kit-modules/copyright`)

- `Apache-2.0`
- `BSD-3-Clause`
- `ISC`
- `ISC+IBM`
- `LGPL-2.1`
- `LGPL-2.1+`
- `permissive-like-automake-output`
- `same-as-rest-of-p11kit`

Source:

```console
$ apt-get source -qq --print-uris p11-kit=0.24.0-6build1
'http://archive.ubuntu.com/ubuntu/pool/main/p/p11-kit/p11-kit_0.24.0-6build1.dsc' p11-kit_0.24.0-6build1.dsc 2633 SHA512:510edf53bc83deef34737f3607995e814695930eacb2257013262023d0c21c3180ac782595bbdc530ea89e8dba567d2f44748a9c6713befb3a3e98245896f179
'http://archive.ubuntu.com/ubuntu/pool/main/p/p11-kit/p11-kit_0.24.0.orig.tar.xz' p11-kit_0.24.0.orig.tar.xz 834392 SHA512:48369d6fdae79b8c5a255c821fbdb982f0c649cce07c0d92f0ff0c16322fea8919faa94067cae2efede2da3646c0e69a71a3e399b769dc2327f247bcb113eb3c
'http://archive.ubuntu.com/ubuntu/pool/main/p/p11-kit/p11-kit_0.24.0.orig.tar.xz.asc' p11-kit_0.24.0.orig.tar.xz.asc 833 SHA512:f802c6f42f437d466b008d0c62aedc2f466bcf5bec93a5fbeec183057d22eacd28184198f624972d9df684a663820e77ebdc8d8c0d14533707691b9d69cb9f69
'http://archive.ubuntu.com/ubuntu/pool/main/p/p11-kit/p11-kit_0.24.0-6build1.debian.tar.xz' p11-kit_0.24.0-6build1.debian.tar.xz 23264 SHA512:a858251688a0655411907d5ac2d122efab057c7bc28dcb3970c68412ca699b00234b74373cbd44472e21cd3f43eab239ddd8411f188e4c214c587052bebedd4c
```

### `dpkg` source package: `pam=1.4.0-11ubuntu2.4`

Binary Packages:

- `libpam-modules:amd64=1.4.0-11ubuntu2.4`
- `libpam-modules-bin=1.4.0-11ubuntu2.4`
- `libpam-runtime=1.4.0-11ubuntu2.4`
- `libpam0g:amd64=1.4.0-11ubuntu2.4`

Licenses: (parsed from: `/usr/share/doc/libpam-modules/copyright`, `/usr/share/doc/libpam-modules-bin/copyright`, `/usr/share/doc/libpam-runtime/copyright`, `/usr/share/doc/libpam0g/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris pam=1.4.0-11ubuntu2.4
'http://archive.ubuntu.com/ubuntu/pool/main/p/pam/pam_1.4.0-11ubuntu2.4.dsc' pam_1.4.0-11ubuntu2.4.dsc 2728 SHA512:6f0a003b6b3032683e02e6441bd2d9bcd4e9d9e36d2909bccda271dfdfc09bc0932f54f910c3fefebef49d31a2d95315b9d2cd31ea9793ce67fcb00052dec8d1
'http://archive.ubuntu.com/ubuntu/pool/main/p/pam/pam_1.4.0.orig.tar.xz' pam_1.4.0.orig.tar.xz 988908 SHA512:26eda95c45598a500bc142da4d1abf93d03b3bbb0f2390fa87c72dcbffa208dbfa115c0b411095c31ee9955e36422ccf3e2df3bd486818fafffef8c4310798c4
'http://archive.ubuntu.com/ubuntu/pool/main/p/pam/pam_1.4.0-11ubuntu2.4.debian.tar.xz' pam_1.4.0-11ubuntu2.4.debian.tar.xz 169452 SHA512:b5e0a07d9bc19ea43e9f209ad4a4971de32cee61784477b90162d81f387070efa877462002a51e0806f7d49bcdd6c9a25cdbcc84716f3d75ed8194c9bce642b0
```

### `dpkg` source package: `pango1.0=1.50.6+ds-2ubuntu1`

Binary Packages:

- `libpango-1.0-0:amd64=1.50.6+ds-2ubuntu1`
- `libpangocairo-1.0-0:amd64=1.50.6+ds-2ubuntu1`
- `libpangoft2-1.0-0:amd64=1.50.6+ds-2ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libpango-1.0-0/copyright`, `/usr/share/doc/libpangocairo-1.0-0/copyright`, `/usr/share/doc/libpangoft2-1.0-0/copyright`)

- `Apache-2`
- `Apache-2.0`
- `Bitstream-Vera`
- `CC-BY-SA-3.0`
- `CC-BY-SA-3.0,`
- `CC0-1.0`
- `CC0-1.0,`
- `Chromium-BSD-style`
- `Example`
- `Expat`
- `GPL-2+`
- `GPL-2+,`
- `GPL-2.0`
- `GPL-3.0`
- `GPL-3.0+`
- `GPL-3.0+,`
- `ICU`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2+,`
- `LGPL-2.1`
- `LGPL-2.1+`
- `MPL-1.1`
- `OFL-1.1`
- `TCL`
- `Unicode`

Source:

```console
$ apt-get source -qq --print-uris pango1.0=1.50.6+ds-2ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/p/pango1.0/pango1.0_1.50.6%2bds-2ubuntu1.dsc' pango1.0_1.50.6+ds-2ubuntu1.dsc 3878 SHA512:9fc410945facf39d80ce6db1be2f34776cf0fed318fe1057eaaf23e4077458650bafd48673b4e69fdce2f37c9b53c4a7d0e1b89692c4147198071432c0b67b36
'http://archive.ubuntu.com/ubuntu/pool/main/p/pango1.0/pango1.0_1.50.6%2bds.orig.tar.xz' pango1.0_1.50.6+ds.orig.tar.xz 2673480 SHA512:d7cca72ffe9e0d4b2e85cff5f372177444466e8b794f74bbe3dbd1a3ddce1eecfc0645dd003eb319308131266ed0e484d3212166401abe189eaa462d3f872a41
'http://archive.ubuntu.com/ubuntu/pool/main/p/pango1.0/pango1.0_1.50.6%2bds-2ubuntu1.debian.tar.xz' pango1.0_1.50.6+ds-2ubuntu1.debian.tar.xz 51196 SHA512:6b66a168f4e922ca6dedecfb4dcb9b17fd61bfa0613f386eccbb93e0f1e6f6100711c0732fb4575cfebedfa40f8939de87aab27e3858d8efccadfd48052955fe
```

### `dpkg` source package: `patch=2.7.6-7build2`

Binary Packages:

- `patch=2.7.6-7build2`

Licenses: (parsed from: `/usr/share/doc/patch/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris patch=2.7.6-7build2
'http://archive.ubuntu.com/ubuntu/pool/main/p/patch/patch_2.7.6-7build2.dsc' patch_2.7.6-7build2.dsc 1838 SHA512:35ea8fc554a359197cc5ca13dcc3926499563e73e03d8e316d1433d01bc8066e0a138cdab0548d40ec73ee08fe719166c1959793219e798817d69afc94be7665
'http://archive.ubuntu.com/ubuntu/pool/main/p/patch/patch_2.7.6.orig.tar.xz' patch_2.7.6.orig.tar.xz 783756 SHA512:fcca87bdb67a88685a8a25597f9e015f5e60197b9a269fa350ae35a7991ed8da553939b4bbc7f7d3cfd863c67142af403b04165633acbce4339056a905e87fbd
'http://archive.ubuntu.com/ubuntu/pool/main/p/patch/patch_2.7.6-7build2.debian.tar.xz' patch_2.7.6-7build2.debian.tar.xz 15248 SHA512:fb482b8f4980bca77a7060aa54cbae01aec9536a72b1e009e9a0cb8f9a35979bf14dcd356b93a2227f18248e81a7e53aac09b7b0d4bd39021681826a9b3ba38f
```

### `dpkg` source package: `pcre2=10.39-3ubuntu0.1`

Binary Packages:

- `libpcre2-16-0:amd64=10.39-3ubuntu0.1`
- `libpcre2-32-0:amd64=10.39-3ubuntu0.1`
- `libpcre2-8-0:amd64=10.39-3ubuntu0.1`
- `libpcre2-dev:amd64=10.39-3ubuntu0.1`
- `libpcre2-posix3:amd64=10.39-3ubuntu0.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris pcre2=10.39-3ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/p/pcre2/pcre2_10.39-3ubuntu0.1.dsc' pcre2_10.39-3ubuntu0.1.dsc 2142 SHA512:8f062a4ba129491e0ec755f945b84e6e6d252e4d87b87ae0dc46156320095557093f7c3305a31cbca9252a2cbc172d701606030ebdae147eef3fbd5616b4ed99
'http://archive.ubuntu.com/ubuntu/pool/main/p/pcre2/pcre2_10.39.orig.tar.gz' pcre2_10.39.orig.tar.gz 2309964 SHA512:fe17ea0191a91d4e4fe88a44a07883db594941376a6e38556e03ff3b594820596fd3e43be2d73b700ca68cd0c44e38c33cc891a57b8ed65e34cd832196bc09b2
'http://archive.ubuntu.com/ubuntu/pool/main/p/pcre2/pcre2_10.39-3ubuntu0.1.diff.gz' pcre2_10.39-3ubuntu0.1.diff.gz 11214 SHA512:7b8848adbd237351d14e68cf13d26fe0330718d2e807c69b091d2eefdd4c5f4ebde9e3b403d898b52ffcff674eb6bd0ff6995190c1fc42668e4bf8173ded7f14
```

### `dpkg` source package: `pcre3=2:8.39-13ubuntu0.22.04.1`

Binary Packages:

- `libpcre16-3:amd64=2:8.39-13ubuntu0.22.04.1`
- `libpcre3:amd64=2:8.39-13ubuntu0.22.04.1`
- `libpcre3-dev:amd64=2:8.39-13ubuntu0.22.04.1`
- `libpcre32-3:amd64=2:8.39-13ubuntu0.22.04.1`
- `libpcrecpp0v5:amd64=2:8.39-13ubuntu0.22.04.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris pcre3=2:8.39-13ubuntu0.22.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/p/pcre3/pcre3_8.39-13ubuntu0.22.04.1.dsc' pcre3_8.39-13ubuntu0.22.04.1.dsc 2101 SHA512:c2b619e559192c367485fec01cf65dbc49a67ec8f2fb9d5785fdf7dba052540d70c16b4316afc83f4765ef9b57f3e2c0e6f245500866476df8a8a90310584f62
'http://archive.ubuntu.com/ubuntu/pool/main/p/pcre3/pcre3_8.39.orig.tar.bz2' pcre3_8.39.orig.tar.bz2 1560758 SHA512:8b0f14ae5947c4b2d74876a795b04e532fd71c2479a64dbe0ed817e7c7894ea3cae533413de8c17322d305cb7f4e275d72b43e4e828eaca77dc4bcaf04529cf6
'http://archive.ubuntu.com/ubuntu/pool/main/p/pcre3/pcre3_8.39-13ubuntu0.22.04.1.debian.tar.gz' pcre3_8.39-13ubuntu0.22.04.1.debian.tar.gz 28251 SHA512:50aa437187fd45632213fe7b09a69dfbe2a58ad568a7f71c47ddab204db49850b732f17c8295788afd0c58d8134620a11aaa9fa259a980a0ab85ce043098a659
```

### `dpkg` source package: `perl-openssl-defaults=5build2`

Binary Packages:

- `perl-openssl-defaults:amd64=5build2`

Licenses: (parsed from: `/usr/share/doc/perl-openssl-defaults/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris perl-openssl-defaults=5build2
'http://archive.ubuntu.com/ubuntu/pool/main/p/perl-openssl-defaults/perl-openssl-defaults_5build2.dsc' perl-openssl-defaults_5build2.dsc 1765 SHA512:b250e467db938e109653591f0eef0b7012988c96c326bc80ec30d35d47934fee1b9063840024e1365b7d5c516eb7da34ffdc0f497cacdeff405cb1819295c9f4
'http://archive.ubuntu.com/ubuntu/pool/main/p/perl-openssl-defaults/perl-openssl-defaults_5build2.tar.xz' perl-openssl-defaults_5build2.tar.xz 4672 SHA512:d67eb9bd12306516f01a1d964428b1a1223fad016da1b82825c704858928c02afe07a86c2db488c70a94da40c7ebf15020b8e6092f9f8a908a2f4a98439c2cc2
```

### `dpkg` source package: `perl=5.34.0-3ubuntu1.3`

Binary Packages:

- `libperl5.34:amd64=5.34.0-3ubuntu1.3`
- `perl=5.34.0-3ubuntu1.3`
- `perl-base=5.34.0-3ubuntu1.3`
- `perl-modules-5.34=5.34.0-3ubuntu1.3`

Licenses: (parsed from: `/usr/share/doc/libperl5.34/copyright`, `/usr/share/doc/perl/copyright`, `/usr/share/doc/perl-base/copyright`, `/usr/share/doc/perl-modules-5.34/copyright`)

- `Artistic`
- `Artistic,`
- `Artistic-2`
- `Artistic-dist`
- `BSD-3-clause`
- `BSD-3-clause-GENERIC`
- `BSD-3-clause-with-weird-numbering`
- `BSD-4-clause-POWERDOG`
- `BZIP`
- `CC0-1.0`
- `DONT-CHANGE-THE-GPL`
- `Expat`
- `GPL-1`
- `GPL-1+`
- `GPL-2`
- `GPL-2+`
- `GPL-3+-WITH-BISON-EXCEPTION`
- `HSIEH-BSD`
- `HSIEH-DERIVATIVE`
- `LGPL-2.1`
- `REGCOMP`
- `REGCOMP,`
- `RRA-KEEP-THIS-NOTICE`
- `SDBM-PUBLIC-DOMAIN`
- `TEXT-TABS`
- `Unicode`
- `ZLIB`

Source:

```console
$ apt-get source -qq --print-uris perl=5.34.0-3ubuntu1.3
'http://archive.ubuntu.com/ubuntu/pool/main/p/perl/perl_5.34.0-3ubuntu1.3.dsc' perl_5.34.0-3ubuntu1.3.dsc 2976 SHA512:789ad2abeb08f1ce1e29734ff6b017ec310edf415efe1728654ff1b904ea623d03d4d46afe5cb9ea98302e241ae6fe0ecaaa6e0aae66550bdf93e35ea02c9f31
'http://archive.ubuntu.com/ubuntu/pool/main/p/perl/perl_5.34.0.orig-regen-configure.tar.xz' perl_5.34.0.orig-regen-configure.tar.xz 415412 SHA512:2581152e0747105314c4fa4167f1f97d286436b996341b9b75e4099ba18f15eb0d2b42888622fbe9b5499d3fe304bc8aa9ad207a945f590135beccfb68ea28b0
'http://archive.ubuntu.com/ubuntu/pool/main/p/perl/perl_5.34.0.orig.tar.xz' perl_5.34.0.orig.tar.xz 12881416 SHA512:691b4b31eacec357191fba777612b4e3eae59e946a22998a50766697c0d61db1d42a9b3bc1e41abf0d1ca1893e4a7c06d7bf3290480cf03d7f79befd7a8a3267
'http://archive.ubuntu.com/ubuntu/pool/main/p/perl/perl_5.34.0-3ubuntu1.3.debian.tar.xz' perl_5.34.0-3ubuntu1.3.debian.tar.xz 194972 SHA512:2e59cdae22e90953cd91fd2c3f1c5b30ed92afc3b696d577719a8919d475fe52152fa2c7090d9a5f889e0816e847124e9457e0cd0dba206551303bd82297cad1
```

### `dpkg` source package: `pinentry=1.1.1-1build2`

Binary Packages:

- `pinentry-curses=1.1.1-1build2`

Licenses: (parsed from: `/usr/share/doc/pinentry-curses/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-3`
- `LGPL-3+`
- `X11`

Source:

```console
$ apt-get source -qq --print-uris pinentry=1.1.1-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/p/pinentry/pinentry_1.1.1-1build2.dsc' pinentry_1.1.1-1build2.dsc 2953 SHA512:d66ea2b52226887f18bab9f7ebfa65f5da95225c57362ec3be1792c261a60d7c74bb0b60d82e556f977246ef615add3d89e7137a16d73248a044e0ea752246ca
'http://archive.ubuntu.com/ubuntu/pool/main/p/pinentry/pinentry_1.1.1.orig.tar.bz2' pinentry_1.1.1.orig.tar.bz2 515723 SHA512:d6ab5af8ac2f3c9c05e09703e95d8e2676f9b2b7ceb97f6a31d101d0e9da7a1e106a6d3eabe86cab1bb35a4b119a7cba1380ac64bf13c61af0b3c48803116c12
'http://archive.ubuntu.com/ubuntu/pool/main/p/pinentry/pinentry_1.1.1.orig.tar.bz2.asc' pinentry_1.1.1.orig.tar.bz2.asc 390 SHA512:2b696e5a59219c6fca719d5f948d508279c483d1d2b2c99221522648fe3098da4a195aca2527fbb5b777fa2905dbda642edb5f6ac4038ed9720a5291ce282cff
'http://archive.ubuntu.com/ubuntu/pool/main/p/pinentry/pinentry_1.1.1-1build2.debian.tar.xz' pinentry_1.1.1-1build2.debian.tar.xz 20060 SHA512:34adaf10856d36e7294fbc9841f6c1b2c9fc1d507fcff6d4c9c3f4e11d5aed9ce744d091f25e013084d56ce8ed3245fff67a7b5d799081def0c68345e921241e
```

### `dpkg` source package: `pixman=0.40.0-1ubuntu0.22.04.1`

Binary Packages:

- `libpixman-1-0:amd64=0.40.0-1ubuntu0.22.04.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris pixman=0.40.0-1ubuntu0.22.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/p/pixman/pixman_0.40.0-1ubuntu0.22.04.1.dsc' pixman_0.40.0-1ubuntu0.22.04.1.dsc 2160 SHA512:8065633dbf5f1d29da28dc2b97cdd6cb3f01a2904ecac623a8dc7d4fec0c1b15fe973edcc9d3ccc69362ce8da209325c6b522da021bf51b3a27fb10ce280b095
'http://archive.ubuntu.com/ubuntu/pool/main/p/pixman/pixman_0.40.0.orig.tar.gz' pixman_0.40.0.orig.tar.gz 913976 SHA512:063776e132f5d59a6d3f94497da41d6fc1c7dca0d269149c78247f0e0d7f520a25208d908cf5e421d1564889a91da44267b12d61c0bd7934cd54261729a7de5f
'http://archive.ubuntu.com/ubuntu/pool/main/p/pixman/pixman_0.40.0-1ubuntu0.22.04.1.diff.gz' pixman_0.40.0-1ubuntu0.22.04.1.diff.gz 327740 SHA512:68949ad2589a7ae9fbe217a3d7fc58894d5a1b4bc6e219840b8620141fa2240b44e6a393bf847bfd18f5fcab2c6c6f143273936b076c29e1f979052b1275cb8e
```

### `dpkg` source package: `pkg-config=0.29.2-1ubuntu3`

Binary Packages:

- `pkg-config=0.29.2-1ubuntu3`

Licenses: (parsed from: `/usr/share/doc/pkg-config/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris pkg-config=0.29.2-1ubuntu3
'http://archive.ubuntu.com/ubuntu/pool/main/p/pkg-config/pkg-config_0.29.2-1ubuntu3.dsc' pkg-config_0.29.2-1ubuntu3.dsc 1910 SHA512:ebeb396389e63ec008928941d0b9b71c55e04c96dccfa799fcbc1eaf0f14003a71c96dd8a54c6e8dca9aa0072c329c1af76d1fed385e11e6c380649c2bf968a3
'http://archive.ubuntu.com/ubuntu/pool/main/p/pkg-config/pkg-config_0.29.2.orig.tar.gz' pkg-config_0.29.2.orig.tar.gz 2016830 SHA512:4861ec6428fead416f5cbbbb0bbad10b9152967e481d4b0ff2eb396a9f297f552984c9bb72f6864a37dcd8fca1d9ccceda3ef18d8f121938dbe4fdf2b870fe75
'http://archive.ubuntu.com/ubuntu/pool/main/p/pkg-config/pkg-config_0.29.2-1ubuntu3.diff.gz' pkg-config_0.29.2-1ubuntu3.diff.gz 10134 SHA512:881ecd107c06f14b6e42a1c3e85a1233f9c92b0666dc5ad1a5fac21d4a64423dcff40c67bdff88311babde5465be82bd5eea8d863bce088468fdff828d8b98ab
```

### `dpkg` source package: `procps=2:3.3.17-6ubuntu2.1`

Binary Packages:

- `libprocps8:amd64=2:3.3.17-6ubuntu2.1`
- `procps=2:3.3.17-6ubuntu2.1`

Licenses: (parsed from: `/usr/share/doc/libprocps8/copyright`, `/usr/share/doc/procps/copyright`)

- `GPL-2`
- `GPL-2.0+`
- `LGPL-2`
- `LGPL-2.0+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris procps=2:3.3.17-6ubuntu2.1
'http://archive.ubuntu.com/ubuntu/pool/main/p/procps/procps_3.3.17-6ubuntu2.1.dsc' procps_3.3.17-6ubuntu2.1.dsc 2111 SHA512:585933efef8d8e93b4187c65b678d146960480386ac3172097c790723ffadbf1d5347e05cc6de2682adcb96dd5b45ec1f98a3e00cff33ad2b30f729939896aca
'http://archive.ubuntu.com/ubuntu/pool/main/p/procps/procps_3.3.17.orig.tar.xz' procps_3.3.17.orig.tar.xz 1008428 SHA512:59e9a5013430fd9da508c4655d58375dc32e025bb502bb28fb9a92a48e4f2838b3355e92b4648f7384b2050064d17079bf4595d889822ebb5030006bc154a1a7
'http://archive.ubuntu.com/ubuntu/pool/main/p/procps/procps_3.3.17-6ubuntu2.1.debian.tar.xz' procps_3.3.17-6ubuntu2.1.debian.tar.xz 35488 SHA512:720a52d14be82aecd59e2456fbb19574c99cc5281660a36994ef4aa619c14bbec43fd30b5e949446e5db6b6bebf8003a5f173298fe8bf56ac949d61ad0225a79
```

### `dpkg` source package: `pygobject=3.42.1-0ubuntu1`

Binary Packages:

- `python3-gi=3.42.1-0ubuntu1`

Licenses: (parsed from: `/usr/share/doc/python3-gi/copyright`)

- `Expat`
- `LGPL-2`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris pygobject=3.42.1-0ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/p/pygobject/pygobject_3.42.1-0ubuntu1.dsc' pygobject_3.42.1-0ubuntu1.dsc 2328 SHA512:67e3a6d787a245e4ec2f02fd9a46bce451dc720482623ca60d93f052fbb8c3c342394a1482d16da8d417d2d3593ef036146b8c658d1b55031516cbaa974cc051
'http://archive.ubuntu.com/ubuntu/pool/main/p/pygobject/pygobject_3.42.1.orig.tar.xz' pygobject_3.42.1.orig.tar.xz 557904 SHA512:b044d395f8334057be632fd56f670ae8405d9fc375bcbd7a0a3b2dcfb8efb06bad45e62e92d2ee5432e503642dba11d6f9bf91f26bf135fa5f9a871657105a18
'http://archive.ubuntu.com/ubuntu/pool/main/p/pygobject/pygobject_3.42.1-0ubuntu1.debian.tar.xz' pygobject_3.42.1-0ubuntu1.debian.tar.xz 22816 SHA512:f2d42805a46f88d4f82e21608a24b174be9c0eb8c471a2f2c2e3c104402678c97dad32280380770bac62611c1007989cac47405a53998764516f97bcaef3a06c
```

### `dpkg` source package: `python3-defaults=3.10.6-1~22.04.1`

Binary Packages:

- `libpython3-stdlib:amd64=3.10.6-1~22.04.1`
- `python3=3.10.6-1~22.04.1`
- `python3-minimal=3.10.6-1~22.04.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris python3-defaults=3.10.6-1~22.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/p/python3-defaults/python3-defaults_3.10.6-1%7e22.04.1.dsc' python3-defaults_3.10.6-1~22.04.1.dsc 2951 SHA512:ce4c67568f3b0fd6c8f8d2daa74351825f1595b69998dce13f82caa077729cdb83fc472a636a466e27dd1ae681035e2b11bd82f73fa33c10b400c017afd54c90
'http://archive.ubuntu.com/ubuntu/pool/main/p/python3-defaults/python3-defaults_3.10.6-1%7e22.04.1.tar.gz' python3-defaults_3.10.6-1~22.04.1.tar.gz 145962 SHA512:c509a2a887e4b758fbfcb6173ff046a6f73bdfdde3bd89f77102a4d99c7219d8e1805b41541c6cf658fe9dd44da188e6af450d87236d863d29f06147fea26ea1
```

### `dpkg` source package: `python3.10=3.10.12-1~22.04.6`

Binary Packages:

- `libpython3.10-minimal:amd64=3.10.12-1~22.04.6`
- `libpython3.10-stdlib:amd64=3.10.12-1~22.04.6`
- `python3.10=3.10.12-1~22.04.6`
- `python3.10-minimal=3.10.12-1~22.04.6`

Licenses: (parsed from: `/usr/share/doc/libpython3.10-minimal/copyright`, `/usr/share/doc/libpython3.10-stdlib/copyright`, `/usr/share/doc/python3.10/copyright`, `/usr/share/doc/python3.10-minimal/copyright`)

- `* Permission to use this software in any way is granted without`
- `By obtaining, using, and/or copying this software and/or its`
- `GPL-2`
- `Permission  is  hereby granted,  free  of charge,  to  any person`
- `Permission is hereby granted, free of charge, to any person obtaining`
- `Permission to use, copy, modify,`
- `Redistribution`
- `This software is provided 'as-is', without any express`
- `This software is provided as-is, without express`
- `binary forms, with`
- `distribute this software`
- `distribute this software and`
- `distribute this software for any`
- `implied`
- `its`
- `use in source`
- `without`

Source:

```console
$ apt-get source -qq --print-uris python3.10=3.10.12-1~22.04.6
'http://archive.ubuntu.com/ubuntu/pool/main/p/python3.10/python3.10_3.10.12-1%7e22.04.6.dsc' python3.10_3.10.12-1~22.04.6.dsc 3674 SHA512:5019349e8e95a79503aa5b2719e47addcc5c2df7b180ac978fe5313ae51509ce041f2bc492a6d0cc52fdf1683491b4ec31906702e8f1116cbd55f024afd9733d
'http://archive.ubuntu.com/ubuntu/pool/main/p/python3.10/python3.10_3.10.12.orig.tar.xz' python3.10_3.10.12.orig.tar.xz 19654836 SHA512:5ea018e71bfe7872e02eaf8aef56d5583c0880e4ce5fbbdf8ea76da20c2e94ac6a3ba8badb4b7d1bc21853402a3b63541b04181737417b1626e786b696595cf5
'http://archive.ubuntu.com/ubuntu/pool/main/p/python3.10/python3.10_3.10.12-1%7e22.04.6.debian.tar.xz' python3.10_3.10.12-1~22.04.6.debian.tar.xz 243264 SHA512:0c93b8fe785b0b7137e922436782c5e9bf183794d9c8cfeaea6f3a56673136ff4c228f4831ef380048e28a550f276f7034d615df40d884f2c2a4be25aad0a9d8
```

### `dpkg` source package: `r-base=4.1.2-1ubuntu2`

Binary Packages:

- `r-base=4.1.2-1ubuntu2`
- `r-base-core=4.1.2-1ubuntu2`
- `r-base-dev=4.1.2-1ubuntu2`
- `r-base-html=4.1.2-1ubuntu2`
- `r-doc-html=4.1.2-1ubuntu2`
- `r-recommended=4.1.2-1ubuntu2`

Licenses: (parsed from: `/usr/share/doc/r-base/copyright`, `/usr/share/doc/r-base-core/copyright`, `/usr/share/doc/r-base-dev/copyright`, `/usr/share/doc/r-base-html/copyright`, `/usr/share/doc/r-doc-html/copyright`, `/usr/share/doc/r-recommended/copyright`)

- `Artistic`
- `GPL-2`
- `GPL-3`
- `LGPL-2`
- `LGPL-2.1`
- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris r-base=4.1.2-1ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/universe/r/r-base/r-base_4.1.2-1ubuntu2.dsc' r-base_4.1.2-1ubuntu2.dsc 3186 SHA512:1f2cc04b8df4142f7d9f98ff98b9b779a7ebc2aa8eb667f21e17e956197fff3e8e5f3147a85c364645ab94ec98ca099132b66f8fdb1fa92b2d34e4a5286cf4ba
'http://archive.ubuntu.com/ubuntu/pool/universe/r/r-base/r-base_4.1.2.orig.tar.gz' r-base_4.1.2.orig.tar.gz 34009074 SHA512:657c7950a88f632f1bbb08dbd0b3fb485732a25d8bbcb8a7939a40b23c7a235fdb9b46c296acaa9f72eabebe96e270ecbdcd7970fc9d3a299e6687bea45f2d3f
'http://archive.ubuntu.com/ubuntu/pool/universe/r/r-base/r-base_4.1.2-1ubuntu2.debian.tar.xz' r-base_4.1.2-1ubuntu2.debian.tar.xz 97692 SHA512:b096e09fceff363008a08a48370b2202ca6d6bafcbba9747182293708eb1e9a7c039f020798a39ecd4d944d3823ed92d52a5f30df90c4848acc58dc8e8c4d533
```

### `dpkg` source package: `r-cran-class=7.3-20-1`

Binary Packages:

- `r-cran-class=7.3-20-1`

Licenses: (parsed from: `/usr/share/doc/r-cran-class/copyright`)

- `GPL-2`
- `GPL-2 | GPL-3`

Source:

```console
$ apt-get source -qq --print-uris r-cran-class=7.3-20-1
'http://archive.ubuntu.com/ubuntu/pool/universe/r/r-cran-class/r-cran-class_7.3-20-1.dsc' r-cran-class_7.3-20-1.dsc 1873 SHA512:0ba0d0a28a161da31948f5f13296fc2f666e96b4572ad184385c096ab136f3865be2228a45b988b5ba7a714e54afedab2b8c1c9c5603bd08b709089e30210922
'http://archive.ubuntu.com/ubuntu/pool/universe/r/r-cran-class/r-cran-class_7.3-20.orig.tar.gz' r-cran-class_7.3-20.orig.tar.gz 20769 SHA512:bd50d9acbda6b6e2c11ac36612f0811c95b627141d8856ca184af790ba4d73cc2c49adc3552860d1c9527c08aa790543468686b9f1c37a51756aced5723bc34f
'http://archive.ubuntu.com/ubuntu/pool/universe/r/r-cran-class/r-cran-class_7.3-20-1.debian.tar.xz' r-cran-class_7.3-20-1.debian.tar.xz 3220 SHA512:4a5683f582e68f6d8d586e4602be2e451ffc9a332ead876eeb234aad871645f3ecb1f0da94f627a6c7388c5906f5d891cd846539453b6873590a505e97d10360
```

### `dpkg` source package: `r-cran-mass=7.3-55-1`

Binary Packages:

- `r-cran-mass=7.3-55-1`

Licenses: (parsed from: `/usr/share/doc/r-cran-mass/copyright`)

- `GPL-2`
- `GPL-2 | GPL-3`

Source:

```console
$ apt-get source -qq --print-uris r-cran-mass=7.3-55-1
'http://archive.ubuntu.com/ubuntu/pool/universe/r/r-cran-mass/r-cran-mass_7.3-55-1.dsc' r-cran-mass_7.3-55-1.dsc 1851 SHA512:0a2c9840e3489ea45d8ddd6cdf8706db700b411261bf707fbab1fc5f997de7f8bcc0c906f4c59b55affaf0a28d8fd4052fe43a02a7b360fb34a551a0cf711022
'http://archive.ubuntu.com/ubuntu/pool/universe/r/r-cran-mass/r-cran-mass_7.3-55.orig.tar.gz' r-cran-mass_7.3-55.orig.tar.gz 508478 SHA512:8eec5dd1f6baf5991eab1567033593e240835378c8e83c474bacea0f66766798f188b5a2f76ecc1c571efb58e0c4cdc9977994d4c3768a4270802dffdc9c83a4
'http://archive.ubuntu.com/ubuntu/pool/universe/r/r-cran-mass/r-cran-mass_7.3-55-1.debian.tar.xz' r-cran-mass_7.3-55-1.debian.tar.xz 6400 SHA512:729654182c07224fc854adcefa2e09ff923b2ce3667cf599abfa7206a3cd1649c788ff84c4d412cbf838fac34fb994f7655c1b7d053e30ecd25848eda44e16d4
```

### `dpkg` source package: `r-cran-nnet=7.3-17-1`

Binary Packages:

- `r-cran-nnet=7.3-17-1`

Licenses: (parsed from: `/usr/share/doc/r-cran-nnet/copyright`)

- `GPL-2`
- `GPL-2 | GPL-3`

Source:

```console
$ apt-get source -qq --print-uris r-cran-nnet=7.3-17-1
'http://archive.ubuntu.com/ubuntu/pool/universe/r/r-cran-nnet/r-cran-nnet_7.3-17-1.dsc' r-cran-nnet_7.3-17-1.dsc 1848 SHA512:23906627ad75e34254ba9f3d5bf96111a9a301cc94f0ee7ae2362a6955f19490184ce23bba8a83502d0a3358e097429d79cb22d18f5326c09539edad828f21cc
'http://archive.ubuntu.com/ubuntu/pool/universe/r/r-cran-nnet/r-cran-nnet_7.3-17.orig.tar.gz' r-cran-nnet_7.3-17.orig.tar.gz 29099 SHA512:6d85a68fc88cc8c3f6200b40491618691619a1e00985edb6190bdacef935c77151d77e0757a899807c1ddf84e78a57c7482e87b4e892cf269ecc623eff7fbcdc
'http://archive.ubuntu.com/ubuntu/pool/universe/r/r-cran-nnet/r-cran-nnet_7.3-17-1.debian.tar.xz' r-cran-nnet_7.3-17-1.debian.tar.xz 3256 SHA512:7388825dcd438d44ff5f8815db66ced775678579a2fa3830791509c9bde6c11677f7a07e9cd8d5feec39c65b6c9a2f0f78ecdbe29008a3e6fd14bcbb07a4bef3
```

### `dpkg` source package: `r-cran-spatial=7.3-15-1`

Binary Packages:

- `r-cran-spatial=7.3-15-1`

Licenses: (parsed from: `/usr/share/doc/r-cran-spatial/copyright`)

- `GPL-2`
- `GPL-2 | GPL-3`

Source:

```console
$ apt-get source -qq --print-uris r-cran-spatial=7.3-15-1
'http://archive.ubuntu.com/ubuntu/pool/universe/r/r-cran-spatial/r-cran-spatial_7.3-15-1.dsc' r-cran-spatial_7.3-15-1.dsc 1884 SHA512:40cfdb528412989f08a17de03de6cf340eb49b1177639f33faab73c575915c8f644d7d3a4f0a6b0646d5a72033c98f5860878a2bc32cef76e44ac430a5be0e91
'http://archive.ubuntu.com/ubuntu/pool/universe/r/r-cran-spatial/r-cran-spatial_7.3-15.orig.tar.gz' r-cran-spatial_7.3-15.orig.tar.gz 44618 SHA512:51764141b384d2ab87d9f78ae4d230b06056afdc6dac84a51f4f8db50b1c394748b16ab95d8b32c94fb50b89206758e7ff2d0d9abb35b6f6cdce3abc0582606d
'http://archive.ubuntu.com/ubuntu/pool/universe/r/r-cran-spatial/r-cran-spatial_7.3-15-1.debian.tar.xz' r-cran-spatial_7.3-15-1.debian.tar.xz 3184 SHA512:e819c0685becfa34f1f3ca25ea8d95ac61ceb428f87e88b6928a1db59c6fc67e3142060d9f041cd3e48b7ead64bc77800a7523cf3c18f7b0e64625bb181a0485
```

### `dpkg` source package: `readline=8.1.2-1`

Binary Packages:

- `libreadline-dev:amd64=8.1.2-1`
- `libreadline8:amd64=8.1.2-1`
- `readline-common=8.1.2-1`

Licenses: (parsed from: `/usr/share/doc/libreadline-dev/copyright`, `/usr/share/doc/libreadline8/copyright`, `/usr/share/doc/readline-common/copyright`)

- `GFDL`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris readline=8.1.2-1
'http://archive.ubuntu.com/ubuntu/pool/main/r/readline/readline_8.1.2-1.dsc' readline_8.1.2-1.dsc 2432 SHA512:3166229d2ac183a46455c7d8cf17ef1d509ca8651ffa7887f654d87bbe1d00a08f9a9f73f14e652ac067d89e5d1128998f8f09f6a1128c56049338ace65ed773
'http://archive.ubuntu.com/ubuntu/pool/main/r/readline/readline_8.1.2.orig.tar.gz' readline_8.1.2.orig.tar.gz 2993073 SHA512:b512275c8aa8b3b3178366c6d681f867676fc1c881e375134a88e9c860a448535e04ca43df727817fd0048261e48203e88bd1c086e86572022d1d65fb0350e4d
'http://archive.ubuntu.com/ubuntu/pool/main/r/readline/readline_8.1.2-1.debian.tar.xz' readline_8.1.2-1.debian.tar.xz 29292 SHA512:a64621c93975bc42ba171c9298c932f9515025513911e744183092e0ef9873db474c4ec27a21f310f40e7b970ba6300edb057552f7e90fc469897ffa2eb706f0
```

### `dpkg` source package: `rmatrix=1.4-0-1`

Binary Packages:

- `r-cran-matrix=1.4-0-1`

Licenses: (parsed from: `/usr/share/doc/r-cran-matrix/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris rmatrix=1.4-0-1
'http://archive.ubuntu.com/ubuntu/pool/universe/r/rmatrix/rmatrix_1.4-0-1.dsc' rmatrix_1.4-0-1.dsc 1860 SHA512:aa6818704361ef9449a9fe7899b1caf1796f8113177a15a96e9445b8c810110e5f8317e6a68fa2a89848a40468db65b9f5c9e8a56594bc4ca674dd6609c4219c
'http://archive.ubuntu.com/ubuntu/pool/universe/r/rmatrix/rmatrix_1.4-0.orig.tar.gz' rmatrix_1.4-0.orig.tar.gz 2849865 SHA512:931f0532a617577056b3b1d6b88ffd89d85eac15e539fb4367f11940ab7a48cdf6e791c81f67ff4a40b0803e5f2c6798b2a5985afe365d8b03a33297c690c287
'http://archive.ubuntu.com/ubuntu/pool/universe/r/rmatrix/rmatrix_1.4-0-1.debian.tar.xz' rmatrix_1.4-0-1.debian.tar.xz 5704 SHA512:2d35a932a44ecee54ecfc8eceb1ebb3c433e67c5af993e3094eae2cb5a7376b63339d9d2b21130a53dd9cf86273fc177c54012d08bda32000afee2638b71ab2f
```

### `dpkg` source package: `rpart=4.1.16-1`

Binary Packages:

- `r-cran-rpart=4.1.16-1`

Licenses: (parsed from: `/usr/share/doc/r-cran-rpart/copyright`)

- `GPL-2`
- `GPL-2+ | license included below`

Source:

```console
$ apt-get source -qq --print-uris rpart=4.1.16-1
'http://archive.ubuntu.com/ubuntu/pool/universe/r/rpart/rpart_4.1.16-1.dsc' rpart_4.1.16-1.dsc 1843 SHA512:11d00d610efcb04adbc6b8f85fa7f662509d91703b2c9f27da5d0972a5db65658abde385e30ea871f319881ebbc0ab17e48cd79ff450565f70381c5a3011f7bd
'http://archive.ubuntu.com/ubuntu/pool/universe/r/rpart/rpart_4.1.16.orig.tar.gz' rpart_4.1.16.orig.tar.gz 859107 SHA512:057e9b65973066e069000c69afa11a8a3877061b98b392deb93d1d93f6ef11b0c0370c28ed50f7d32c99564e44d2502ab8183ae67ee42fc0672a7171c4bac34b
'http://archive.ubuntu.com/ubuntu/pool/universe/r/rpart/rpart_4.1.16-1.debian.tar.xz' rpart_4.1.16-1.debian.tar.xz 4352 SHA512:e413cf8ddd1322469b8f417e5a9e7f765a09576660f21543f82f45bc5fd96586fa40d2bce1506cde9484ac74614c8822c382ce1afc5f05a807b00ab3bb8564b7
```

### `dpkg` source package: `rpcsvc-proto=1.4.2-0ubuntu6`

Binary Packages:

- `rpcsvc-proto=1.4.2-0ubuntu6`

Licenses: (parsed from: `/usr/share/doc/rpcsvc-proto/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2+-autoconf-exception`
- `GPL-3`
- `GPL-3+-autoconf-exception`
- `MIT`
- `permissive-autoconf-m4`
- `permissive-autoconf-m4-no-warranty`
- `permissive-configure`
- `permissive-fsf`
- `permissive-makefile-in`

Source:

```console
$ apt-get source -qq --print-uris rpcsvc-proto=1.4.2-0ubuntu6
'http://archive.ubuntu.com/ubuntu/pool/main/r/rpcsvc-proto/rpcsvc-proto_1.4.2-0ubuntu6.dsc' rpcsvc-proto_1.4.2-0ubuntu6.dsc 2113 SHA512:df8458b423e2d3f8d6da5c6fc19be2ad4ae50d7513e3fa98656b05a734fdc26b2403984ea7da8a0cb5c270f63feae7c258e1f817a3f4a27ffb25107e25f43525
'http://archive.ubuntu.com/ubuntu/pool/main/r/rpcsvc-proto/rpcsvc-proto_1.4.2.orig.tar.xz' rpcsvc-proto_1.4.2.orig.tar.xz 171620 SHA512:631fbfc00af94c5d7def0759f27e97dc14d400b4468c906719ae18ecef74815730798c882d1aaa4f90359224e7b829019b786baddc3097905b54f940ca85a714
'http://archive.ubuntu.com/ubuntu/pool/main/r/rpcsvc-proto/rpcsvc-proto_1.4.2-0ubuntu6.debian.tar.xz' rpcsvc-proto_1.4.2-0ubuntu6.debian.tar.xz 4268 SHA512:b7ee77b3714b10471fa5be73655f6ce37bd8ca4bfdb07011ac3621723616e69a2323dea9c93ee9ac5d2e9fd0230347224eaa8ae556ec2f2d4b399ec250a5008c
```

### `dpkg` source package: `rtmpdump=2.4+20151223.gitfa8646d.1-2build4`

Binary Packages:

- `librtmp1:amd64=2.4+20151223.gitfa8646d.1-2build4`

Licenses: (parsed from: `/usr/share/doc/librtmp1/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris rtmpdump=2.4+20151223.gitfa8646d.1-2build4
'http://archive.ubuntu.com/ubuntu/pool/main/r/rtmpdump/rtmpdump_2.4%2b20151223.gitfa8646d.1-2build4.dsc' rtmpdump_2.4+20151223.gitfa8646d.1-2build4.dsc 2431 SHA512:7536b21c9c8be02e06171db49bf0b653e4b7738e6c01f74b0b7433c2986c731eafd1743f87836e7250a744d0e34dc700685bbe7128956a274e9a9832d32c891e
'http://archive.ubuntu.com/ubuntu/pool/main/r/rtmpdump/rtmpdump_2.4%2b20151223.gitfa8646d.1.orig.tar.gz' rtmpdump_2.4+20151223.gitfa8646d.1.orig.tar.gz 142213 SHA512:bdfcbab73179d614a295a7b136ea4c9d0ce4620883b493f298362784d245608cd6ad4b0ad30f94ed73a086b4555399521ae9e95b6375fce75e455ae68c055e7b
'http://archive.ubuntu.com/ubuntu/pool/main/r/rtmpdump/rtmpdump_2.4%2b20151223.gitfa8646d.1-2build4.debian.tar.xz' rtmpdump_2.4+20151223.gitfa8646d.1-2build4.debian.tar.xz 8376 SHA512:b01ac33a7251e3c0fad21897d31710766136027b656cb29903cf8f695893648631037a96fa18aa40eae7ad363394344aad4f2fae152622618b88f22133c03578
```

### `dpkg` source package: `sed=4.8-1ubuntu2`

Binary Packages:

- `sed=4.8-1ubuntu2`

Licenses: (parsed from: `/usr/share/doc/sed/copyright`)

- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris sed=4.8-1ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/s/sed/sed_4.8-1ubuntu2.dsc' sed_4.8-1ubuntu2.dsc 2217 SHA512:310ccdf0bac73d16c8898fd600acbeceb534a1be53c795fc6f6059eccb431b45ef9ebcde147c150f9fd5e0d33161269f53e191bb26a095b45339a28b1c3381b2
'http://archive.ubuntu.com/ubuntu/pool/main/s/sed/sed_4.8.orig.tar.xz' sed_4.8.orig.tar.xz 1348048 SHA512:7de25d9bc2981c63321c2223f3fbcab61d7b0df4fcf7d4394b72400b91993e1288d8bf53948ed5fffcf5a98c75265726a68ad4fb98e1d571bf768603a108c1c8
'http://archive.ubuntu.com/ubuntu/pool/main/s/sed/sed_4.8.orig.tar.xz.asc' sed_4.8.orig.tar.xz.asc 833 SHA512:9b886bdbd18ee2d60608cee3fd2b4193a1b6c3309d887ee05828c14b89b7b515dbf042a9e0ebdd13e6ccfa42e3cd217a408c796d68c4ebedaaa64f795000f095
'http://archive.ubuntu.com/ubuntu/pool/main/s/sed/sed_4.8-1ubuntu2.debian.tar.xz' sed_4.8-1ubuntu2.debian.tar.xz 60936 SHA512:c4f0c5b3f75acbcb213e78f5696129e83bc721031be3c756150e84b7aa7e725ac0d5afacbe18e91d39bc2b7892986d92e1e21db89601ccf2bccb8ac088482180
```

### `dpkg` source package: `sensible-utils=0.0.17`

Binary Packages:

- `sensible-utils=0.0.17`

Licenses: (parsed from: `/usr/share/doc/sensible-utils/copyright`)

- `All-permissive`
- `GPL-2`
- `GPL-2+`
- `configure`
- `installsh`

Source:

```console
$ apt-get source -qq --print-uris sensible-utils=0.0.17
'http://archive.ubuntu.com/ubuntu/pool/main/s/sensible-utils/sensible-utils_0.0.17.dsc' sensible-utils_0.0.17.dsc 1733 SHA512:33e94cbe40fbcb083564b4e4f5947f7c4dc0da0724245d19290667cf8a56eb60ba5b94c0c85e8eee2ae7c988a25a094e7edff3159bbe4339dcf9136a6336f2f7
'http://archive.ubuntu.com/ubuntu/pool/main/s/sensible-utils/sensible-utils_0.0.17.tar.xz' sensible-utils_0.0.17.tar.xz 66648 SHA512:fb7803cacc4222f232f64850e5559aca0b56ad98b6fd31f36c89740d72f7a235e7f2934ebce1d788882bff7196d59a2ed6cc3584f31e1c1c9e3593cedca2382b
```

### `dpkg` source package: `session-migration=0.3.6`

Binary Packages:

- `session-migration=0.3.6`

Licenses: (parsed from: `/usr/share/doc/session-migration/copyright`)

- `LGPL-3`
- `LGPL-3+`

Source:

```console
$ apt-get source -qq --print-uris session-migration=0.3.6
'http://archive.ubuntu.com/ubuntu/pool/main/s/session-migration/session-migration_0.3.6.dsc' session-migration_0.3.6.dsc 1707 SHA512:63be63b4368eaef738df8f732889585a9037f2cda304627b5f7257b7d87c9cd9ca165f9a178d36037cc9216109f70563e0a65eb3f6d4dafc2dddabfb77855962
'http://archive.ubuntu.com/ubuntu/pool/main/s/session-migration/session-migration_0.3.6.tar.xz' session-migration_0.3.6.tar.xz 13280 SHA512:517b851cce4a1c600789bc272fb5b90649d435c8949d6c6571ce2b5fdf2e1187e5496f3a31f49c78dc5584e9960d6406a5b8441b355cf44ae44ddd9989e18dab
```

### `dpkg` source package: `shadow=1:4.8.1-2ubuntu2.2`

Binary Packages:

- `login=1:4.8.1-2ubuntu2.2`
- `passwd=1:4.8.1-2ubuntu2.2`

Licenses: (parsed from: `/usr/share/doc/login/copyright`, `/usr/share/doc/passwd/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris shadow=1:4.8.1-2ubuntu2.2
'http://archive.ubuntu.com/ubuntu/pool/main/s/shadow/shadow_4.8.1-2ubuntu2.2.dsc' shadow_4.8.1-2ubuntu2.2.dsc 2060 SHA512:765de71da656f0fd36b0872e05c1f736b167faf3af9a52247e0810d260606fe440a541c5558a882f8a5d150d91f76f01303cada28ba5febe4d16042eda3da7c8
'http://archive.ubuntu.com/ubuntu/pool/main/s/shadow/shadow_4.8.1.orig.tar.xz' shadow_4.8.1.orig.tar.xz 1611196 SHA512:780a983483d847ed3c91c82064a0fa902b6f4185225978241bc3bc03fcc3aa143975b46aee43151c6ba43efcfdb1819516b76ba7ad3d1d3c34fcc38ea42e917b
'http://archive.ubuntu.com/ubuntu/pool/main/s/shadow/shadow_4.8.1-2ubuntu2.2.debian.tar.xz' shadow_4.8.1-2ubuntu2.2.debian.tar.xz 98488 SHA512:dfa83a48e365f57c4881e77307bdea56db3e1b78e28ae687e5346daf1e71fe8df3388329ef6e7c90377555367267719e42e9c7f752da5b897e731bd9ca50a581
```

### `dpkg` source package: `shared-mime-info=2.1-2`

Binary Packages:

- `shared-mime-info=2.1-2`

Licenses: (parsed from: `/usr/share/doc/shared-mime-info/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris shared-mime-info=2.1-2
'http://archive.ubuntu.com/ubuntu/pool/main/s/shared-mime-info/shared-mime-info_2.1-2.dsc' shared-mime-info_2.1-2.dsc 2223 SHA512:292d45d7847f5b6de7583f6c24c5ef019169e1bc6b54e5415d2dc0df203136624b7eb3e20040019608fe392468967c31e15d100f9eaa75e052d342d2aa1465c9
'http://archive.ubuntu.com/ubuntu/pool/main/s/shared-mime-info/shared-mime-info_2.1.orig.tar.xz' shared-mime-info_2.1.orig.tar.xz 5202496 SHA512:87e308281e83c4cf889594f7c2e8dcb4d0d0d3910124c3816fdb886ba7d6113b2581711adcb17032b47f9b8d8b7001fab58daa52b7da7c0ef87915e341d6f1b0
'http://archive.ubuntu.com/ubuntu/pool/main/s/shared-mime-info/shared-mime-info_2.1-2.debian.tar.xz' shared-mime-info_2.1-2.debian.tar.xz 11304 SHA512:833518eb333d0bb03018299db5e21b5e9f38d9c89680f86aab9e03289ef7d056ff74b3bdb5f7fb364f990b61bc8f264f2b4113edf59ecb1ef7c72f83970f1a25
```

### `dpkg` source package: `sqlite3=3.37.2-2ubuntu0.3`

Binary Packages:

- `libsqlite3-0:amd64=3.37.2-2ubuntu0.3`

Licenses: (parsed from: `/usr/share/doc/libsqlite3-0/copyright`)

- `GPL-2`
- `GPL-2+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris sqlite3=3.37.2-2ubuntu0.3
'http://archive.ubuntu.com/ubuntu/pool/main/s/sqlite3/sqlite3_3.37.2-2ubuntu0.3.dsc' sqlite3_3.37.2-2ubuntu0.3.dsc 2602 SHA512:086e45082a9d83001d2c97407d1c2ce0869add89f27594ed412ce930d45d16318e644ac4e6deb571ddedb17d76a38af6c12ab39b6c1f1001f9423498cc045508
'http://archive.ubuntu.com/ubuntu/pool/main/s/sqlite3/sqlite3_3.37.2.orig-www.tar.xz' sqlite3_3.37.2.orig-www.tar.xz 5694016 SHA512:577e34b4ae18a3c73be6d955a2e2321e993f61decefbcca5112170072ea556eca93dcf55f3059fbcd96147124442b368150de7f68c603e84b80cbe0228ae78f8
'http://archive.ubuntu.com/ubuntu/pool/main/s/sqlite3/sqlite3_3.37.2.orig.tar.xz' sqlite3_3.37.2.orig.tar.xz 7623768 SHA512:dfa51b0a32ab0597cd00ae7abdb53bb255102f397ff8409f3fdbefaad17bc7d5a25f53db90bed47feb1bf4a9a1a4707bc40440c6c5303f3ef5c49ded61558fed
'http://archive.ubuntu.com/ubuntu/pool/main/s/sqlite3/sqlite3_3.37.2-2ubuntu0.3.debian.tar.xz' sqlite3_3.37.2-2ubuntu0.3.debian.tar.xz 30176 SHA512:6c8f4b6d233a566bdc7291a3135e0d748ef972cccbbdb50d145df1c3cae9f2fb3216e120e58e123e5234040865e69eb7e4c3720b24d655500d6514aff27056b7
```

### `dpkg` source package: `survival=3.2-13-1`

Binary Packages:

- `r-cran-survival=3.2-13-1`

Licenses: (parsed from: `/usr/share/doc/r-cran-survival/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris survival=3.2-13-1
'http://archive.ubuntu.com/ubuntu/pool/universe/s/survival/survival_3.2-13-1.dsc' survival_3.2-13-1.dsc 1868 SHA512:8be6d50d45227146c348c33f5614733888963af3e46ab8eb401e7cd9fb7abc8843ea4a46d2ca7dbf68866ca72fbd27a4422d75a2572b06556bbdaba72d982f2f
'http://archive.ubuntu.com/ubuntu/pool/universe/s/survival/survival_3.2-13.orig.tar.gz' survival_3.2-13.orig.tar.gz 6545339 SHA512:3fdce34e6c856faf18879d37d3d0b8a500bcfc38b2efba5a3f964f35affa13cb7f379e68963820db27a761686396c90b177730cb941b715f85e25967f20e7a8b
'http://archive.ubuntu.com/ubuntu/pool/universe/s/survival/survival_3.2-13-1.debian.tar.xz' survival_3.2-13-1.debian.tar.xz 6164 SHA512:3ed00fef21ed8688d46c62d657381c90be2ed2c1a26001105bc7e1666cd3dbaa9448bee43014e3edcdff3fdc58aef6ed11903a208009ddf4c2489a59c027ab5e
```

### `dpkg` source package: `systemd=249.11-0ubuntu3.12`

Binary Packages:

- `libnss-systemd:amd64=249.11-0ubuntu3.12`
- `libpam-systemd:amd64=249.11-0ubuntu3.12`
- `libsystemd0:amd64=249.11-0ubuntu3.12`
- `libudev1:amd64=249.11-0ubuntu3.12`
- `systemd=249.11-0ubuntu3.12`
- `systemd-sysv=249.11-0ubuntu3.12`
- `systemd-timesyncd=249.11-0ubuntu3.12`

Licenses: (parsed from: `/usr/share/doc/libnss-systemd/copyright`, `/usr/share/doc/libpam-systemd/copyright`, `/usr/share/doc/libsystemd0/copyright`, `/usr/share/doc/libudev1/copyright`, `/usr/share/doc/systemd/copyright`, `/usr/share/doc/systemd-sysv/copyright`, `/usr/share/doc/systemd-timesyncd/copyright`)

- `CC0-1.0`
- `Expat`
- `GPL-2`
- `GPL-2 with Linux-syscall-note exception`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris systemd=249.11-0ubuntu3.12
'http://archive.ubuntu.com/ubuntu/pool/main/s/systemd/systemd_249.11-0ubuntu3.12.dsc' systemd_249.11-0ubuntu3.12.dsc 5907 SHA512:1dc21b48d93811597f96c6b5dadba42e7d1f6ea5408f2a4aaab8d5bbf3fdd480d50ce1d51647fc833dafa9a672830c11c0770801a5bcd111cd432f95477a0943
'http://archive.ubuntu.com/ubuntu/pool/main/s/systemd/systemd_249.11.orig.tar.gz' systemd_249.11.orig.tar.gz 10622702 SHA512:fed7f81933648945a4bfac9fb12150ecd84d32181f79be0e14e0b3a789343a87569f868670e0b8dfc2801fab39f7490f95ee8c29ba831d7611f78c14ace5ddd8
'http://archive.ubuntu.com/ubuntu/pool/main/s/systemd/systemd_249.11-0ubuntu3.12.debian.tar.xz' systemd_249.11-0ubuntu3.12.debian.tar.xz 253852 SHA512:76220a7cffbd1300a6a4ccebceeef05b65b25c51d9037a183afbb4b2b744da87b8fbab0195c168a55e71beef1cff8352d36a109f5d099ca6947a90d85584f572
```

### `dpkg` source package: `sysvinit=3.01-1ubuntu1`

Binary Packages:

- `sysvinit-utils=3.01-1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/sysvinit-utils/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris sysvinit=3.01-1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/s/sysvinit/sysvinit_3.01-1ubuntu1.dsc' sysvinit_3.01-1ubuntu1.dsc 2138 SHA512:650c939b7af5189cddf6509dd2b6a995c7b389ab4ee33bdad267d8c2b5b5506716b03e512563ed3e3265b32d2d1a9119ee0193f3dc82354896029ae124d2a276
'http://archive.ubuntu.com/ubuntu/pool/main/s/sysvinit/sysvinit_3.01.orig.tar.xz' sysvinit_3.01.orig.tar.xz 126400 SHA512:d3b197fcfccfbc2ad95fe208fb37ed1fcc8173a7a0254528c0d8c6800b054d96e20b48274c55137f19305c105700c35974d454b4bbf5e51fbbf5c082d562167b
'http://archive.ubuntu.com/ubuntu/pool/main/s/sysvinit/sysvinit_3.01-1ubuntu1.debian.tar.xz' sysvinit_3.01-1ubuntu1.debian.tar.xz 131304 SHA512:4c835855b58742480284b17959d54b8ac734466fc87321ddf021b61bb3e38b58aab6d07a7f27f09c0b109b4e442c0dce4d797feccce2884f5b401e13abf73554
```

### `dpkg` source package: `tar=1.34+dfsg-1ubuntu0.1.22.04.2`

Binary Packages:

- `tar=1.34+dfsg-1ubuntu0.1.22.04.2`

Licenses: (parsed from: `/usr/share/doc/tar/copyright`)

- `GPL-2`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris tar=1.34+dfsg-1ubuntu0.1.22.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/t/tar/tar_1.34%2bdfsg-1ubuntu0.1.22.04.2.dsc' tar_1.34+dfsg-1ubuntu0.1.22.04.2.dsc 1829 SHA512:e716a22f84cf0ebc0250a4ebb5d7c1fb5f055470a376c20d37a9378e85535aba8d547b6fe64df17bdedd5130d47647613dd5f2083f93cae934961b1b5ba37077
'http://archive.ubuntu.com/ubuntu/pool/main/t/tar/tar_1.34%2bdfsg.orig.tar.xz' tar_1.34+dfsg.orig.tar.xz 1981736 SHA512:ec5553c53c4a5f523f872a8095f699c17bf41400fbe2f0f8b45291ccbaf9ac51dea8445c81bd95697f8853c95dcad3250071d23dbbcab857a428ee92e647bde9
'http://archive.ubuntu.com/ubuntu/pool/main/t/tar/tar_1.34%2bdfsg-1ubuntu0.1.22.04.2.debian.tar.xz' tar_1.34+dfsg-1ubuntu0.1.22.04.2.debian.tar.xz 20544 SHA512:9840407a1364154c831665c3f1739c80a84806567fe5ad27ee3ac70f4c18e27d7f2f9e0557b6e2a634ab39449a8fc95b96f1813f5c203df8ece5226a6afe8c7c
```

### `dpkg` source package: `tcl8.6=8.6.12+dfsg-1build1`

Binary Packages:

- `libtcl8.6:amd64=8.6.12+dfsg-1build1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris tcl8.6=8.6.12+dfsg-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/t/tcl8.6/tcl8.6_8.6.12%2bdfsg-1build1.dsc' tcl8.6_8.6.12+dfsg-1build1.dsc 2250 SHA512:f997c3ad9955f27d98f658468c91db98b2bfe9ad6d6ccbe15bdc192d25ae6adbb4bf032827f32d22072dc0d3519d81eed8cd3c28c62d88aa8870b4addfd73dcb
'http://archive.ubuntu.com/ubuntu/pool/main/t/tcl8.6/tcl8.6_8.6.12%2bdfsg.orig.tar.gz' tcl8.6_8.6.12+dfsg.orig.tar.gz 6075478 SHA512:327adcae9479de8eeb123d25e11fd1181ba5f973dc86585694a28912d084662446630b3f6b66149c600a78d47364ddf3cf50c9fcbc169538181d344f6c050761
'http://archive.ubuntu.com/ubuntu/pool/main/t/tcl8.6/tcl8.6_8.6.12%2bdfsg-1build1.debian.tar.xz' tcl8.6_8.6.12+dfsg-1build1.debian.tar.xz 14520 SHA512:3cf3b7c8d8865e73d5f5526a65872b659bd3dbd77aef238d7462a360f2145ab44119ae90dd98eb4b1b1d3896ee36f7b5faa2accfdb846287f2e54a49acdfece4
```

### `dpkg` source package: `tiff=4.3.0-6ubuntu0.10`

Binary Packages:

- `libtiff5:amd64=4.3.0-6ubuntu0.10`

Licenses: (parsed from: `/usr/share/doc/libtiff5/copyright`)

- `Hylafax`

Source:

```console
$ apt-get source -qq --print-uris tiff=4.3.0-6ubuntu0.10
'http://archive.ubuntu.com/ubuntu/pool/main/t/tiff/tiff_4.3.0-6ubuntu0.10.dsc' tiff_4.3.0-6ubuntu0.10.dsc 2402 SHA512:57c9cd8b73231e2f8d6f4377242e5bfb5d2401275db8216623a4dab98078d753525bb50131b34179ce30b0e29ad81a1ed21d17dc536f9926d005aa04a2fdcf77
'http://archive.ubuntu.com/ubuntu/pool/main/t/tiff/tiff_4.3.0.orig.tar.gz' tiff_4.3.0.orig.tar.gz 2808254 SHA512:e04a4a6c542e58a174c1e9516af3908acf1d3d3e1096648c5514f4963f73e7af27387a76b0fbabe43cf867a18874088f963796a7cd6e45deb998692e3e235493
'http://archive.ubuntu.com/ubuntu/pool/main/t/tiff/tiff_4.3.0.orig.tar.gz.asc' tiff_4.3.0.orig.tar.gz.asc 488 SHA512:115a4c5714b52d0fbea800c494d83c8a96b70b2c9ce84a8df03205d9afc517faa17963f5f9508c013d7d3e2be6675b84b594a771a829406473234c4bd85e469e
'http://archive.ubuntu.com/ubuntu/pool/main/t/tiff/tiff_4.3.0-6ubuntu0.10.debian.tar.xz' tiff_4.3.0-6ubuntu0.10.debian.tar.xz 50900 SHA512:77306a746064a74f326c232bbb7017cae9374b7596effae40234d1fef52fd6383a705b8ef0e76ca9c09795e54fc8a4a85ac1171324b535c3c4e28fee30153264
```

### `dpkg` source package: `tilix=1.9.4-2build1`

Binary Packages:

- `tilix=1.9.4-2build1`
- `tilix-common=1.9.4-2build1`

Licenses: (parsed from: `/usr/share/doc/tilix/copyright`, `/usr/share/doc/tilix-common/copyright`)

- `CC-BY-SA-3.0`
- `GPL-3`
- `GPL-3+`
- `MPL-2.0`

Source:

```console
$ apt-get source -qq --print-uris tilix=1.9.4-2build1
'http://archive.ubuntu.com/ubuntu/pool/universe/t/tilix/tilix_1.9.4-2build1.dsc' tilix_1.9.4-2build1.dsc 2275 SHA512:489cd8a45ba29bd6af013e608d33bde87406159efaf690390f97ba0f1022c716ba910cf75a24ae6e06d568890dbc050270a9c4e95a74454bf1560dd49265375e
'http://archive.ubuntu.com/ubuntu/pool/universe/t/tilix/tilix_1.9.4.orig.tar.gz' tilix_1.9.4.orig.tar.gz 968142 SHA512:fe73cfca691317af575c37730179732b7b53a0197e9b813c918626094bff7499239c6d48d4a03204896f4f261bdb52d9ceaaf2ba3a2c100b57a0fe05abe5980f
'http://archive.ubuntu.com/ubuntu/pool/universe/t/tilix/tilix_1.9.4-2build1.debian.tar.xz' tilix_1.9.4-2build1.debian.tar.xz 19444 SHA512:85586cca5dcd9e6b4df9b3942df98304539844365d968249642cf91dc78b5c24f43e889f7fcaae88c09d2aaa1926039b1457a4d001e306439071988dbbb61851
```

### `dpkg` source package: `tini=0.19.0-1`

Binary Packages:

- `tini=0.19.0-1`

Licenses: (parsed from: `/usr/share/doc/tini/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris tini=0.19.0-1
'http://archive.ubuntu.com/ubuntu/pool/universe/t/tini/tini_0.19.0-1.dsc' tini_0.19.0-1.dsc 1810 SHA512:eaaed0056836aba6a3245c7b23e0b82b72a7df1957b24fae7d8718fc63082889c939f3a0e97dea11ae994250a4c83d804c79625469b4e0ef8e053225ff72a8d2
'http://archive.ubuntu.com/ubuntu/pool/universe/t/tini/tini_0.19.0.orig.tar.gz' tini_0.19.0.orig.tar.gz 32369 SHA512:1fa85b56e2c6085ea474f251928e7a40510d92aeef60b3c145b0496969c1b5df86835d143cb91ef5b4bf4da63fa8a56947cc39a4276e4b72faa57276d432b292
'http://archive.ubuntu.com/ubuntu/pool/universe/t/tini/tini_0.19.0-1.debian.tar.xz' tini_0.19.0-1.debian.tar.xz 1832 SHA512:7435354105667f316d9015c3873d7faf42c8fb3e172f3b14af456db5a66ef6cec7190ad2c09477d9b7a0f56aa6cf9f1bcdda5bd59f24956ef1850656d71cb902
```

### `dpkg` source package: `tk8.6=8.6.12-1build1`

Binary Packages:

- `libtk8.6:amd64=8.6.12-1build1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris tk8.6=8.6.12-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/t/tk8.6/tk8.6_8.6.12-1build1.dsc' tk8.6_8.6.12-1build1.dsc 2285 SHA512:161ecd2535385ebdad7e92bbe18124c320cd3c5e2f116f3401342c3aa52956455d44a7fc4933b035f3542092aae49a064f1af81223c003c3241cb4a40a63cd78
'http://archive.ubuntu.com/ubuntu/pool/main/t/tk8.6/tk8.6_8.6.12.orig.tar.gz' tk8.6_8.6.12.orig.tar.gz 4515393 SHA512:afe51eb3e2071640ebc57f9ee6979fe91ee7856df8d3c9d55ae70c470cdae2306d2feeb791f46258f529a5c4a07b53974a7574cf3594818cd4e99077b30c697b
'http://archive.ubuntu.com/ubuntu/pool/main/t/tk8.6/tk8.6_8.6.12-1build1.debian.tar.xz' tk8.6_8.6.12-1build1.debian.tar.xz 10872 SHA512:b9eea910f20478873d63677cbe117f0eb242df874bca18df5dc26939d5afb8c3c27dc88d83b02a085bdfe3880a133e90379589bf906782336b62107719c8edbb
```

### `dpkg` source package: `tzdata=2024a-0ubuntu0.22.04.1`

Binary Packages:

- `tzdata=2024a-0ubuntu0.22.04.1`

Licenses: (parsed from: `/usr/share/doc/tzdata/copyright`)

- `ICU`

Source:

```console
$ apt-get source -qq --print-uris tzdata=2024a-0ubuntu0.22.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/t/tzdata/tzdata_2024a-0ubuntu0.22.04.1.dsc' tzdata_2024a-0ubuntu0.22.04.1.dsc 2541 SHA512:c0cda33e23d340414e2cd079ec35caa8986601f9f97bcb055ccfaee154fb8667588a18d6e21f1719090799aa034960548df63a046669287e15af281aaba2b151
'http://archive.ubuntu.com/ubuntu/pool/main/t/tzdata/tzdata_2024a.orig.tar.gz' tzdata_2024a.orig.tar.gz 451270 SHA512:1f09f1b2327cc9e1afc7e9045e83ee3377918dafe1bee2f282b6991828d03b3c70a4d3a17f9207dfb1361bb25bc214a8922a756e84fa114e9ba476226db57236
'http://archive.ubuntu.com/ubuntu/pool/main/t/tzdata/tzdata_2024a.orig.tar.gz.asc' tzdata_2024a.orig.tar.gz.asc 833 SHA512:a06ddc95002f2dcd3c071d020a74bc98aae2cbf56a502718f9bc08e90e0075b17aaaa653ceecd49a1133cdadfc43134365043f827b19c7dad68050dbda6ba77e
'http://archive.ubuntu.com/ubuntu/pool/main/t/tzdata/tzdata_2024a-0ubuntu0.22.04.1.debian.tar.xz' tzdata_2024a-0ubuntu0.22.04.1.debian.tar.xz 178960 SHA512:98899e7a78ddfce0f3af0c1239422b9547b3c33ca08ab5e82266e51cc69e1169e012f3ad78b1fc84ca491847ea2bcda25619f7b06df410d0f02c9e7ef746a2ec
```

### `dpkg` source package: `ubuntu-keyring=2021.03.26`

Binary Packages:

- `ubuntu-keyring=2021.03.26`

Licenses: (parsed from: `/usr/share/doc/ubuntu-keyring/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris ubuntu-keyring=2021.03.26
'http://archive.ubuntu.com/ubuntu/pool/main/u/ubuntu-keyring/ubuntu-keyring_2021.03.26.dsc' ubuntu-keyring_2021.03.26.dsc 1855 SHA512:7502f4f4d9a288fab9fb84b6ae5f8500cb3f14c68ed586b489dee95f12087b232bcecd9369e98258bb710afda50e5672dfbc6422b1436e896fb529dec8832252
'http://archive.ubuntu.com/ubuntu/pool/main/u/ubuntu-keyring/ubuntu-keyring_2021.03.26.tar.gz' ubuntu-keyring_2021.03.26.tar.gz 34529 SHA512:04a76e2bfa88fb428face9e01976ff98a3a26fe2b555340c14200fc6099ee3b474a6733486cedfe933933c0a6826ee3550660499d7b26bda8a27a620b1d6a35f
```

### `dpkg` source package: `ubuntu-themes=20.10-0ubuntu2`

Binary Packages:

- `ubuntu-mono=20.10-0ubuntu2`

Licenses: (parsed from: `/usr/share/doc/ubuntu-mono/copyright`)

- `CC-BY-SA-3.0`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris ubuntu-themes=20.10-0ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/u/ubuntu-themes/ubuntu-themes_20.10-0ubuntu2.dsc' ubuntu-themes_20.10-0ubuntu2.dsc 1640 SHA512:76a21792e4b61d71598dad022314b3644a20d279d75b140f83643708682e523361d311ef00b3f66751f5255d8c6fd873642eed176fa0dbd987daf076b6f89bea
'http://archive.ubuntu.com/ubuntu/pool/main/u/ubuntu-themes/ubuntu-themes_20.10.orig.tar.gz' ubuntu-themes_20.10.orig.tar.gz 15679746 SHA512:0118f7c2404856216ff2df0246ea2fa98d0d5b25973abc3df13a998f7a41f2eeb32ca08281ba41399a91fa16ab046e3b3292f504503958983a6488c1e3001ac4
'http://archive.ubuntu.com/ubuntu/pool/main/u/ubuntu-themes/ubuntu-themes_20.10-0ubuntu2.diff.gz' ubuntu-themes_20.10-0ubuntu2.diff.gz 34394 SHA512:9bd5d4efb6619aee085c882b738fb09e5f1a1e3e8f8a06a3fc197efc7c70d13b8d6401706c1479a4dc081363a6253a35c64d18919f60c800e9b8a944123a6b81
```

### `dpkg` source package: `ucf=3.0043`

Binary Packages:

- `ucf=3.0043`

Licenses: (parsed from: `/usr/share/doc/ucf/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris ucf=3.0043
'http://archive.ubuntu.com/ubuntu/pool/main/u/ucf/ucf_3.0043.dsc' ucf_3.0043.dsc 1423 SHA512:666851d1df82352f8b2be8b8760250cfa1f7635718f0f1598a3d9e9f11a9d687ec4cfb7f6bf950b194d771db039508b6d62c288f53078e2712580bda7b5befa7
'http://archive.ubuntu.com/ubuntu/pool/main/u/ucf/ucf_3.0043.tar.xz' ucf_3.0043.tar.xz 70560 SHA512:693209ea06a63279278ac8f63e70fe151880f7c51d54c91ad5e846449f883d5893658d8c6932553d70da4e56ebae3ef67c0eda8593b0768f5979849c79f89f27
```

### `dpkg` source package: `unzip=6.0-26ubuntu3.2`

Binary Packages:

- `unzip=6.0-26ubuntu3.2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris unzip=6.0-26ubuntu3.2
'http://archive.ubuntu.com/ubuntu/pool/main/u/unzip/unzip_6.0-26ubuntu3.2.dsc' unzip_6.0-26ubuntu3.2.dsc 1811 SHA512:9339b501ce82f43a9b04655a0ee1534332972b4b42365245812aeeaf1258417695a82db6446dc5c4d630c8df7119fbc9026bd4a91dc3bd5829596075c19fdf10
'http://archive.ubuntu.com/ubuntu/pool/main/u/unzip/unzip_6.0.orig.tar.gz' unzip_6.0.orig.tar.gz 1376845 SHA512:0694e403ebc57b37218e00ec1a406cae5cc9c5b52b6798e0d4590840b6cdbf9ddc0d9471f67af783e960f8fa2e620394d51384257dca23d06bcd90224a80ce5d
'http://archive.ubuntu.com/ubuntu/pool/main/u/unzip/unzip_6.0-26ubuntu3.2.debian.tar.xz' unzip_6.0-26ubuntu3.2.debian.tar.xz 28676 SHA512:996f43dcb28f8b3cd4b16ecb35d19c1bb568f249320a70c07dc1b02bad6657646904683751bfce9d4dbad89241d25924424322f95e48a345acb181fd7577bffb
```

### `dpkg` source package: `usrmerge=25ubuntu2`

Binary Packages:

- `usrmerge=25ubuntu2`

Licenses: (parsed from: `/usr/share/doc/usrmerge/copyright`)

- `GPL v2`
- `GPL-2`
- `later (please see /usr/share/common-licenses/GPL-2)`

Source:

```console
$ apt-get source -qq --print-uris usrmerge=25ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/u/usrmerge/usrmerge_25ubuntu2.dsc' usrmerge_25ubuntu2.dsc 1614 SHA512:2f0ea8dbed8277d1fef2f2c70c0075ce509579161fe2dc3a161919d3015c67caff01aa14ba3df7fa7d6b45ce63dbad48389c418781334d83e308ee16988fa9bc
'http://archive.ubuntu.com/ubuntu/pool/main/u/usrmerge/usrmerge_25ubuntu2.tar.xz' usrmerge_25ubuntu2.tar.xz 12812 SHA512:dac8ccc7e2b75c424990713869f80d62d22e1cd86cb35c1784c7e76a12096b8c3f3000cefb406456f6f5c459d14858e710d426ee11714d1a5e342e04186f8353
```

### `dpkg` source package: `util-linux=2.37.2-4ubuntu3.4`

Binary Packages:

- `bsdutils=1:2.37.2-4ubuntu3.4`
- `libblkid1:amd64=2.37.2-4ubuntu3.4`
- `libmount1:amd64=2.37.2-4ubuntu3.4`
- `libsmartcols1:amd64=2.37.2-4ubuntu3.4`
- `libuuid1:amd64=2.37.2-4ubuntu3.4`
- `mount=2.37.2-4ubuntu3.4`
- `util-linux=2.37.2-4ubuntu3.4`

Licenses: (parsed from: `/usr/share/doc/bsdutils/copyright`, `/usr/share/doc/libblkid1/copyright`, `/usr/share/doc/libmount1/copyright`, `/usr/share/doc/libsmartcols1/copyright`, `/usr/share/doc/libuuid1/copyright`, `/usr/share/doc/mount/copyright`, `/usr/share/doc/util-linux/copyright`)

- `BSD-2-clause`
- `BSD-3-clause`
- `BSD-4-clause`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `LGPL`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `LGPL-3`
- `LGPL-3+`
- `MIT`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris util-linux=2.37.2-4ubuntu3.4
'http://archive.ubuntu.com/ubuntu/pool/main/u/util-linux/util-linux_2.37.2-4ubuntu3.4.dsc' util-linux_2.37.2-4ubuntu3.4.dsc 4550 SHA512:b0d37cbcd57000cf45ad6c6769e51bc0cc81a4ad9f3906e09b7f814a3638db0013c7213847c9c90f519f21896fdb5592a8ea839a1277d4e7629a01f84a535957
'http://archive.ubuntu.com/ubuntu/pool/main/u/util-linux/util-linux_2.37.2.orig.tar.xz' util-linux_2.37.2.orig.tar.xz 5621624 SHA512:38f0fe820445e3bfa79550e6581c230f98c7661566ccc4daa51c7208a5f972c61b4e57dfc86bed074fdbc7c40bc79f856be8f6a05a8860c1c0cecc4208e8b81d
'http://archive.ubuntu.com/ubuntu/pool/main/u/util-linux/util-linux_2.37.2-4ubuntu3.4.debian.tar.xz' util-linux_2.37.2-4ubuntu3.4.debian.tar.xz 114096 SHA512:8e1a3832d116062881d7823baafcf574cc252490e7e25144efa34cfd65a35b590b454298507940399568716c0ccb9533b01f2c9665f92aa2082d91e5ca8e9c9c
```

### `dpkg` source package: `vte2.91=0.68.0-1ubuntu0.1`

Binary Packages:

- `libvte-2.91-0:amd64=0.68.0-1ubuntu0.1`
- `libvte-2.91-common=0.68.0-1ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libvte-2.91-0/copyright`, `/usr/share/doc/libvte-2.91-common/copyright`)

- `Expat`
- `GPL-3`
- `GPL-3+`
- `LGPL-3`
- `LGPL-3+`

Source:

```console
$ apt-get source -qq --print-uris vte2.91=0.68.0-1ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/v/vte2.91/vte2.91_0.68.0-1ubuntu0.1.dsc' vte2.91_0.68.0-1ubuntu0.1.dsc 3006 SHA512:4ec401c94112dd01727e3fa5183567677269205de53fc680ed05c67746ec1637462a0caa19de2fdb7598a798be2b08592854fc254c24365e63618ae8294bc20f
'http://archive.ubuntu.com/ubuntu/pool/main/v/vte2.91/vte2.91_0.68.0.orig.tar.xz' vte2.91_0.68.0.orig.tar.xz 901856 SHA512:c5bd53cc449bf7296f2288f788770d439254c4b220d51dc136f0660f932fff84b1c2a288febf0040b9630f15dea34ab2fdf6b2696283cb8bc7285840eb91fe63
'http://archive.ubuntu.com/ubuntu/pool/main/v/vte2.91/vte2.91_0.68.0-1ubuntu0.1.debian.tar.xz' vte2.91_0.68.0-1ubuntu0.1.debian.tar.xz 25308 SHA512:1cba6bfc5a08199834717c57d72cb22baf3b89082e52709fdc5f36b8931ad7dba20cfed093ae6a5b1f0179676a5877d2fccee3e8dc367514a6a4b7119180d81b
```

### `dpkg` source package: `wayland=1.20.0-1ubuntu0.1`

Binary Packages:

- `libwayland-client0:amd64=1.20.0-1ubuntu0.1`
- `libwayland-cursor0:amd64=1.20.0-1ubuntu0.1`
- `libwayland-egl1:amd64=1.20.0-1ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libwayland-client0/copyright`, `/usr/share/doc/libwayland-cursor0/copyright`, `/usr/share/doc/libwayland-egl1/copyright`)

- `X11`

Source:

```console
$ apt-get source -qq --print-uris wayland=1.20.0-1ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/w/wayland/wayland_1.20.0-1ubuntu0.1.dsc' wayland_1.20.0-1ubuntu0.1.dsc 2687 SHA512:37074c6f0092329291687b6f8b2f63ec8330fa705a641693814b934a9fa29dab47312ca6d347d322d8d2183cc555cca74097b45b274cc4864e2beb79960fe95a
'http://archive.ubuntu.com/ubuntu/pool/main/w/wayland/wayland_1.20.0.orig.tar.gz' wayland_1.20.0.orig.tar.gz 349593 SHA512:2881fe23a80732e4b660ff6e1b01711212d3463d20e3442c381bf7ea34c866c3dbab0b39354f5fb8e29649c4530e74aedb6df668a8b54530593257b8e68be541
'http://archive.ubuntu.com/ubuntu/pool/main/w/wayland/wayland_1.20.0-1ubuntu0.1.diff.gz' wayland_1.20.0-1ubuntu0.1.diff.gz 14532 SHA512:73ecb5c916c30e61352cd6d4a3839d46003fd94c73daadd13cbe2a4f43ada37817c97a74ed73fd614cade863ee0e417d1a8cb8db7cef4a768e56f24424125bd9
```

### `dpkg` source package: `wget=1.21.2-2ubuntu1.1`

Binary Packages:

- `wget=1.21.2-2ubuntu1.1`

Licenses: (parsed from: `/usr/share/doc/wget/copyright`)

- `GFDL-1.2`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris wget=1.21.2-2ubuntu1.1
'http://archive.ubuntu.com/ubuntu/pool/main/w/wget/wget_1.21.2-2ubuntu1.1.dsc' wget_1.21.2-2ubuntu1.1.dsc 2251 SHA512:66aa1cecef80eacb8780fdec1ba9a237e36796a22cfc3fcf4b1b095d2dbd98852c4557e3084dd45022154b4c01d8c9e980dac9239a2e27c717a75413513f8171
'http://archive.ubuntu.com/ubuntu/pool/main/w/wget/wget_1.21.2.orig.tar.gz' wget_1.21.2.orig.tar.gz 5004576 SHA512:3e35f92604486ca459f26df97d392579f1d83a9254519e8ce249b410bacf70dddf716d6caa3b29fd4865163f60410b2b8ad1ca1f7bb3dbb2456386b7647b988d
'http://archive.ubuntu.com/ubuntu/pool/main/w/wget/wget_1.21.2.orig.tar.gz.asc' wget_1.21.2.orig.tar.gz.asc 833 SHA512:c5349ed20902d4e4d76e681b9e14370d5c1f07d1ba9e600a82af67ac24fe79051b3beabbe563e6967c429cc344ee1bc46aff57c1ab0eb2db8d70e907df49c953
'http://archive.ubuntu.com/ubuntu/pool/main/w/wget/wget_1.21.2-2ubuntu1.1.debian.tar.xz' wget_1.21.2-2ubuntu1.1.debian.tar.xz 65124 SHA512:1351dc5b7271f9e5cbf85bc0bbfe36b1645b0dfa4de20940e1dc20c297b43b540c958e4908c54f6e3663fc0d1e6094c1dffb7609ca8baebb842659886f1bdf97
```

### `dpkg` source package: `x11-utils=7.7+5build2`

Binary Packages:

- `x11-utils=7.7+5build2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris x11-utils=7.7+5build2
'http://archive.ubuntu.com/ubuntu/pool/main/x/x11-utils/x11-utils_7.7%2b5build2.dsc' x11-utils_7.7+5build2.dsc 2268 SHA512:e68c1af663661b76c7b9de8bde848b7c54d94d8470075f4413219c6fa58edb72174eec0eeef972faca590b3829627f3e8684f4993fd7fa11cd540349debffbc8
'http://archive.ubuntu.com/ubuntu/pool/main/x/x11-utils/x11-utils_7.7%2b5build2.tar.gz' x11-utils_7.7+5build2.tar.gz 3125956 SHA512:7057a73fbd9b1e8ce3769069b3d332cd78c688c0f8129719fb3029cd210c9b0f5eabe7fdd3a5f34ce73b0d65ba9b147f905cff34c724d105487b4be69ea18d9d
```

### `dpkg` source package: `x11-xserver-utils=7.7+9build1`

Binary Packages:

- `x11-xserver-utils=7.7+9build1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris x11-xserver-utils=7.7+9build1
'http://archive.ubuntu.com/ubuntu/pool/main/x/x11-xserver-utils/x11-xserver-utils_7.7%2b9build1.dsc' x11-xserver-utils_7.7+9build1.dsc 2073 SHA512:ba11551fd8c685d2d44e31985648e89e9114ea992a1dbe60bb5a687ccd37a0d0537131ddb132764fb0ca392c4237bd6013de980b178e0e5ad82f5c9f89af00f0
'http://archive.ubuntu.com/ubuntu/pool/main/x/x11-xserver-utils/x11-xserver-utils_7.7%2b9build1.tar.gz' x11-xserver-utils_7.7+9build1.tar.gz 2706607 SHA512:bd3451973b75f555d87522a64187eb518e02f238293b6e2d61cfc064d5721665aeda50372604cc81f4f640a234b717c10d6c9d6f2a6c0b767a62630d3c490143
```

### `dpkg` source package: `xauth=1:1.1-1build2`

Binary Packages:

- `xauth=1:1.1-1build2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris xauth=1:1.1-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/x/xauth/xauth_1.1-1build2.dsc' xauth_1.1-1build2.dsc 2010 SHA512:870344b38df9dbb768a5fb9a9a215e2fe9edb4fe127d1d2714fef1c04aece0e0627da8c1685aed2280eca7bdba23e60baf37fba6f4b07570c69021aee781db5c
'http://archive.ubuntu.com/ubuntu/pool/main/x/xauth/xauth_1.1.orig.tar.gz' xauth_1.1.orig.tar.gz 204146 SHA512:8f26c2a0c5ed74cadf8135004ec1716ba87083ee3b71cc59dfbf82f703f663781a8da9cba09655d4abf61fd2acb48f812ee8edc5ac52eeaaaf74a825678e8c60
'http://archive.ubuntu.com/ubuntu/pool/main/x/xauth/xauth_1.1-1build2.diff.gz' xauth_1.1-1build2.diff.gz 14166 SHA512:530e02e88e9db9a7996110725b7f3bfad423eb303b734b6685b426c15d2aabcff1ad74b04743f0978d90c313332f955ed3919e13f55f5e0944471deee61f3309
```

### `dpkg` source package: `xdg-user-dirs=0.17-2ubuntu4`

Binary Packages:

- `xdg-user-dirs=0.17-2ubuntu4`

Licenses: (parsed from: `/usr/share/doc/xdg-user-dirs/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris xdg-user-dirs=0.17-2ubuntu4
'http://archive.ubuntu.com/ubuntu/pool/main/x/xdg-user-dirs/xdg-user-dirs_0.17-2ubuntu4.dsc' xdg-user-dirs_0.17-2ubuntu4.dsc 2354 SHA512:f0308556175ca16f6569a99f55648cc8c0bdb5d528f96c75632ec076e79ff644a2572c324eb77313e94d7aabfc3971a2116e006f44f89ffbba3393b6a1040121
'http://archive.ubuntu.com/ubuntu/pool/main/x/xdg-user-dirs/xdg-user-dirs_0.17.orig.tar.gz' xdg-user-dirs_0.17.orig.tar.gz 257291 SHA512:a02cc251f2d0a8bd0dad498901c8c6fbe8dae0e0e156abcaf27b1ded376a1ed369c2e59201d56ab4e38c9d521026fa39199177f3868c30e5c50cc03665dc335f
'http://archive.ubuntu.com/ubuntu/pool/main/x/xdg-user-dirs/xdg-user-dirs_0.17-2ubuntu4.debian.tar.xz' xdg-user-dirs_0.17-2ubuntu4.debian.tar.xz 28892 SHA512:1577d27f824d27aa8f5cb83b860ab1c29cb0a215c033ed30c12c4463a440d86c736467f87c645b4b97a3dc87bf9c2d790b94dc5ebcbf510a82bfb7d1c81e705c
```

### `dpkg` source package: `xdg-utils=1.1.3-4.1ubuntu3~22.04.1`

Binary Packages:

- `xdg-utils=1.1.3-4.1ubuntu3~22.04.1`

Licenses: (parsed from: `/usr/share/doc/xdg-utils/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris xdg-utils=1.1.3-4.1ubuntu3~22.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/x/xdg-utils/xdg-utils_1.1.3-4.1ubuntu3%7e22.04.1.dsc' xdg-utils_1.1.3-4.1ubuntu3~22.04.1.dsc 1930 SHA512:658c0e07ecf32ef5db2c4c955633a939fb3065f02011406fe315bc251c1822fad995b0a31c96d07bccd05e84ec138d733db04af2fcd2649bef733b105926e0b2
'http://archive.ubuntu.com/ubuntu/pool/main/x/xdg-utils/xdg-utils_1.1.3.orig.tar.gz' xdg-utils_1.1.3.orig.tar.gz 297170 SHA512:d1f819a211eb4104a90dfdc6fedcb640fd46b15ccfc8762266f8f538c49d74cb00027b8c1af991fb2a200acb4379986ae375700e06a2aa08fb41a38f883acb3e
'http://archive.ubuntu.com/ubuntu/pool/main/x/xdg-utils/xdg-utils_1.1.3-4.1ubuntu3%7e22.04.1.debian.tar.xz' xdg-utils_1.1.3-4.1ubuntu3~22.04.1.debian.tar.xz 17140 SHA512:bfc740bc7486f9886677f65200eebba7272cced34c8d998a55a78221cba9f8dc71e4f02d247688d958670807c2716936fed5f8069f7bc7a161b39a07c7e0a14f
```

### `dpkg` source package: `xft=2.3.4-1`

Binary Packages:

- `libxft2:amd64=2.3.4-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris xft=2.3.4-1
'http://archive.ubuntu.com/ubuntu/pool/main/x/xft/xft_2.3.4-1.dsc' xft_2.3.4-1.dsc 2006 SHA512:0bc19bae56d76240703e643bbcbdd61062ca6fffae29db390ea19c9511b15f5109567bee3efa03e4b9d401b9160a16a5853f25a9db0bb13f7a05843bd47c13b3
'http://archive.ubuntu.com/ubuntu/pool/main/x/xft/xft_2.3.4.orig.tar.gz' xft_2.3.4.orig.tar.gz 429711 SHA512:d8618cb2eab150f6177dd3a3a370b3d916300d75c811b020fd58f4a9f4c021908abffb988596c5d613d5801ac27d6dee707869aa906f880ca769032584390b37
'http://archive.ubuntu.com/ubuntu/pool/main/x/xft/xft_2.3.4-1.diff.gz' xft_2.3.4-1.diff.gz 12527 SHA512:ad22e3ea5a2f676c938f6bca28e710e9f1d4399d5d039614db63fc33eb2d66a3e9c21973b324697a8698ade77e9b514a224bbf22ab96c5e8cfb4f1e91d81e9d6
```

### `dpkg` source package: `xkeyboard-config=2.33-1`

Binary Packages:

- `xkb-data=2.33-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris xkeyboard-config=2.33-1
'http://archive.ubuntu.com/ubuntu/pool/main/x/xkeyboard-config/xkeyboard-config_2.33-1.dsc' xkeyboard-config_2.33-1.dsc 2390 SHA512:9f9fb54462501e260423c39db1c4d1a90ab307b78d71f01fefca7fb71e4e686af4f5cd043a6b9dee3cf84e31812162e2477e05743c66a65e942fd3b224049f87
'http://archive.ubuntu.com/ubuntu/pool/main/x/xkeyboard-config/xkeyboard-config_2.33.orig.tar.gz' xkeyboard-config_2.33.orig.tar.gz 2733864 SHA512:b2a7aa974cfbbdae9b0d9dce63553fcbc25327d28ac8542ffdf1bfa2dc2725f893d85c4d6868f9d45233827e01e43244c928ae9f2ace68007c8e1b54636127d6
'http://archive.ubuntu.com/ubuntu/pool/main/x/xkeyboard-config/xkeyboard-config_2.33.orig.tar.gz.asc' xkeyboard-config_2.33.orig.tar.gz.asc 488 SHA512:21274c621e1d4973b2c3dd2d42eb5b2defbfbba662089ebb7be4b5c9c1ef1db420e2e0ecafd18d139c7bf4ec8620e47793f1bb623bb8bbb46f7eea9ef6cee554
'http://archive.ubuntu.com/ubuntu/pool/main/x/xkeyboard-config/xkeyboard-config_2.33-1.diff.gz' xkeyboard-config_2.33-1.diff.gz 913399 SHA512:2bc7672993704c56db74db7d1729e003401d49aa67e13996920f12e9beaf0a3726dc831e64c28a3c885a3df6db07704b5d53f899ec625eb9a5ef063145fac597
```

### `dpkg` source package: `xorg=1:7.7+23ubuntu2`

Binary Packages:

- `x11-common=1:7.7+23ubuntu2`

Licenses: (parsed from: `/usr/share/doc/x11-common/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris xorg=1:7.7+23ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/x/xorg/xorg_7.7%2b23ubuntu2.dsc' xorg_7.7+23ubuntu2.dsc 2095 SHA512:f4befc0dd73c66f56856f16c4dc4051f58af50bd8819469df4bb309817952e00f2f4e29776282f85eeaef18a77fdd42cb1cfcb9a69432c4680b216039b37e480
'http://archive.ubuntu.com/ubuntu/pool/main/x/xorg/xorg_7.7%2b23ubuntu2.tar.gz' xorg_7.7+23ubuntu2.tar.gz 301762 SHA512:379e60ab57cc4f9adbf1f59295fca3930bbd638f4100d08c9f1f78bd6ef063e3396385b841e66389771c4ba5825875d738b9aa4b4dc2e3f79d0537415ac0852a
```

### `dpkg` source package: `xxhash=0.8.1-1`

Binary Packages:

- `libxxhash0:amd64=0.8.1-1`

Licenses: (parsed from: `/usr/share/doc/libxxhash0/copyright`)

- `BSD-2-clause`
- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris xxhash=0.8.1-1
'http://archive.ubuntu.com/ubuntu/pool/main/x/xxhash/xxhash_0.8.1-1.dsc' xxhash_0.8.1-1.dsc 1966 SHA512:645799311fdf21568b23134cdf586a54bb32b58639adb8ebc1f5ad26fdfdc485506c87d763133163fde705b2f904d6f01f50e4d13ebec2b476d38e66ded2bf22
'http://archive.ubuntu.com/ubuntu/pool/main/x/xxhash/xxhash_0.8.1.orig.tar.gz' xxhash_0.8.1.orig.tar.gz 171552 SHA512:12feedd6a1859ef55e27218dbd6dcceccbb5a4da34cd80240d2f7d44cd246c7afdeb59830c2d5b90189bb5159293532208bf5bb622250102e12d6e1bad14a193
'http://archive.ubuntu.com/ubuntu/pool/main/x/xxhash/xxhash_0.8.1-1.debian.tar.xz' xxhash_0.8.1-1.debian.tar.xz 4572 SHA512:e59d4fc6f736d3af6f7be3ec64fc1ee4382e917a942e4000159652082e2f73f52ae0f72adb98505ac9bd8894a89800e21c0913ba4b511959f07a2bc84c341920
```

### `dpkg` source package: `xz-utils=5.2.5-2ubuntu1`

Binary Packages:

- `liblzma-dev:amd64=5.2.5-2ubuntu1`
- `liblzma5:amd64=5.2.5-2ubuntu1`
- `xz-utils=5.2.5-2ubuntu1`

Licenses: (parsed from: `/usr/share/doc/liblzma-dev/copyright`, `/usr/share/doc/liblzma5/copyright`, `/usr/share/doc/xz-utils/copyright`)

- `Autoconf`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `LGPL-2`
- `LGPL-2.1`
- `LGPL-2.1+`
- `PD`
- `PD-debian`
- `config-h`
- `noderivs`
- `none`
- `permissive-fsf`
- `permissive-nowarranty`
- `probably-PD`

Source:

```console
$ apt-get source -qq --print-uris xz-utils=5.2.5-2ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/x/xz-utils/xz-utils_5.2.5-2ubuntu1.dsc' xz-utils_5.2.5-2ubuntu1.dsc 2593 SHA512:832f11d78286b4838d53b789e70b00462d255ca31c9ba059c0a018e13e546b4407889b8d1efd079bcdd8eb1e9247a970bb6811ec50a19a5af83cec3880b6c5f3
'http://archive.ubuntu.com/ubuntu/pool/main/x/xz-utils/xz-utils_5.2.5.orig.tar.xz' xz-utils_5.2.5.orig.tar.xz 1148824 SHA512:59266068a51cb616eb31b67cd8f07ffeb2288d1391c61665ae2ec6814465afac80fec69248f6a2f2db45b44475af001296a99af6a32287226a9c41419173ccbb
'http://archive.ubuntu.com/ubuntu/pool/main/x/xz-utils/xz-utils_5.2.5.orig.tar.xz.asc' xz-utils_5.2.5.orig.tar.xz.asc 833 SHA512:582864ae306861ede34074ebfd23ab161ad3340ab4a068f727583de2bd2058da70dfe73019f4e70b8267e0e0c62f275da1e23f47d40c0b80038449b0ac335020
'http://archive.ubuntu.com/ubuntu/pool/main/x/xz-utils/xz-utils_5.2.5-2ubuntu1.debian.tar.xz' xz-utils_5.2.5-2ubuntu1.debian.tar.xz 35108 SHA512:c50c36fe82204f79be5f409c633aae52ae7b5d36fc64f404308372c80c862455c26455ad0dba93877e80db576d80e672314f757a1ed080f200702d47247e9d6e
```

### `dpkg` source package: `zip=3.0-12build2`

Binary Packages:

- `zip=3.0-12build2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris zip=3.0-12build2
'http://archive.ubuntu.com/ubuntu/pool/main/z/zip/zip_3.0-12build2.dsc' zip_3.0-12build2.dsc 1805 SHA512:7823e01e09d57d53aed5b4514137ab95610c8de27c8006795a7d6368a81febd7e6b2ce00b004bce9c1ce6525a85cdea654acd489f97a98caa8eb9a4dc0297fd0
'http://archive.ubuntu.com/ubuntu/pool/main/z/zip/zip_3.0.orig.tar.gz' zip_3.0.orig.tar.gz 1118845 SHA512:c1c3d62bf1426476c0f9919b568013d6d7b03514912035f09ee283226d94c978791ad2af5310021e96c4c2bf320bfc9d0b8f4045c48e4667e034d98197e1a9b3
'http://archive.ubuntu.com/ubuntu/pool/main/z/zip/zip_3.0-12build2.debian.tar.xz' zip_3.0-12build2.debian.tar.xz 8808 SHA512:255c1e91c3c54656b42f8baa027239302de178382f7f3e6eb9d5c2ca5ffd46d35872f7d3bb6d9133c192e068338c1a7ea7f0d62de3c583a4f884cadb58a44818
```

### `dpkg` source package: `zlib=1:1.2.11.dfsg-2ubuntu9.2`

Binary Packages:

- `zlib1g:amd64=1:1.2.11.dfsg-2ubuntu9.2`
- `zlib1g-dev:amd64=1:1.2.11.dfsg-2ubuntu9.2`

Licenses: (parsed from: `/usr/share/doc/zlib1g/copyright`, `/usr/share/doc/zlib1g-dev/copyright`)

- `Zlib`

Source:

```console
$ apt-get source -qq --print-uris zlib=1:1.2.11.dfsg-2ubuntu9.2
'http://archive.ubuntu.com/ubuntu/pool/main/z/zlib/zlib_1.2.11.dfsg-2ubuntu9.2.dsc' zlib_1.2.11.dfsg-2ubuntu9.2.dsc 2649 SHA512:08f3ca4c6680ddec9532de5e937c39aa891e1c2062e6da65a96aaa060c8111bbb63de6d5c36efd34f4d3892e6e334b50fa2947fde68b3ba276e6645027dd8715
'http://archive.ubuntu.com/ubuntu/pool/main/z/zlib/zlib_1.2.11.dfsg.orig.tar.gz' zlib_1.2.11.dfsg.orig.tar.gz 370248 SHA512:92819807c0b8de655021bb2d5d182f9b6b381d3072d8c8dc1df34bbaa25d36bcba140c85f754a43cc466aac65850b7a7366aa0c93e804180e5b255e61d5748de
'http://archive.ubuntu.com/ubuntu/pool/main/z/zlib/zlib_1.2.11.dfsg-2ubuntu9.2.debian.tar.xz' zlib_1.2.11.dfsg-2ubuntu9.2.debian.tar.xz 60140 SHA512:5e86b01c08d5027fab6682849e6065b750d2aecafe8bd6ca85fd729c1cca88031e46f869e20d0b0483d2a6128eab9754f530d0b25f009b684b18bd6f0e8c4ae8
```
