# `silverpeas:6.3.5`

## Docker Metadata

- Image ID: `sha256:a2ded0d1ebd1c9efe00d0b87b7e75b52491ff29c28b0c9d4ae23af17caaee420`
- Created: `2024-05-28T07:33:18Z`
- Virtual Size: ~ 3.13 Gb  
  (total size of all layers on-disk)
- Arch: `linux`/`amd64`
- Command: `["/opt/run.sh"]`
- Environment:
  - `PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin`
  - `TERM=xterm`
  - `LANG=en_US.UTF-8`
  - `LANGUAGE=en_US.UTF-8`
  - `LC_ALL=en_US.UTF-8`
  - `PING_ON=1`
  - `JAVA_HOME=/docker-java-home`
  - `SILVERPEAS_HOME=/opt/silverpeas`
  - `JBOSS_HOME=/opt/wildfly`
  - `SILVERPEAS_VERSION=6.3.5`
  - `WILDFLY_VERSION=26.1.1`
- Labels:
  - `build=1`
  - `description=Image to install and to run Silverpeas 6.3.5`
  - `name=Silverpeas 6.3.5`
  - `org.opencontainers.image.ref.name=ubuntu`
  - `org.opencontainers.image.version=20.04`
  - `vendor=Silverpeas`
  - `version=6.3.5`

## `dpkg` (`.deb`-based packages)

### `dpkg` source package: `acl=2.2.53-6`

Binary Packages:

- `libacl1:amd64=2.2.53-6`

Licenses: (parsed from: `/usr/share/doc/libacl1/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2+`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris acl=2.2.53-6
'http://archive.ubuntu.com/ubuntu/pool/main/a/acl/acl_2.2.53-6.dsc' acl_2.2.53-6.dsc 2336 SHA256:02dad794aa09133e557552d75568324ed3e84fb56e93626e67993cf54a97df34
'http://archive.ubuntu.com/ubuntu/pool/main/a/acl/acl_2.2.53.orig.tar.gz' acl_2.2.53.orig.tar.gz 524300 SHA256:06be9865c6f418d851ff4494e12406568353b891ffe1f596b34693c387af26c7
'http://archive.ubuntu.com/ubuntu/pool/main/a/acl/acl_2.2.53.orig.tar.gz.asc' acl_2.2.53.orig.tar.gz.asc 833 SHA256:06849bece0b56a6a7269173abe101cff223bb9346d74027a3cd5ff80914abf4b
'http://archive.ubuntu.com/ubuntu/pool/main/a/acl/acl_2.2.53-6.debian.tar.xz' acl_2.2.53-6.debian.tar.xz 25108 SHA256:c80e6150d9b213e52f5e65ff78d4ee95a71b5a258c1f8b980365d20ed1753a5c
```

### `dpkg` source package: `adduser=3.118ubuntu2`

Binary Packages:

- `adduser=3.118ubuntu2`

Licenses: (parsed from: `/usr/share/doc/adduser/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris adduser=3.118ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/a/adduser/adduser_3.118ubuntu2.dsc' adduser_3.118ubuntu2.dsc 1131 SHA256:785f99d8c75c972cd42d3fab3afa07f97299bb1d70013fe5d295f045224774bb
'http://archive.ubuntu.com/ubuntu/pool/main/a/adduser/adduser_3.118ubuntu2.tar.xz' adduser_3.118ubuntu2.tar.xz 222364 SHA256:9429124c39c381b541005da6f0ae29831bd6533dd65c923e06ca2a7c310db382
```

### `dpkg` source package: `adwaita-icon-theme=3.36.1-2ubuntu0.20.04.2`

Binary Packages:

- `adwaita-icon-theme=3.36.1-2ubuntu0.20.04.2`

Licenses: (parsed from: `/usr/share/doc/adwaita-icon-theme/copyright`)

- `CC-BY-3.0-US`
- `CC-BY-SA-2.0-IT`
- `CC-BY-SA-2.0-IT,`
- `CC-BY-SA-3.0`
- `CC-BY-SA-3.0-US`
- `CC-BY-SA-3.0-Unported`
- `GFDL-1.2`
- `GFDL-1.2+`
- `GPL`
- `GPL-unspecified`
- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris adwaita-icon-theme=3.36.1-2ubuntu0.20.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/a/adwaita-icon-theme/adwaita-icon-theme_3.36.1-2ubuntu0.20.04.2.dsc' adwaita-icon-theme_3.36.1-2ubuntu0.20.04.2.dsc 1937 SHA512:ab41a7dd8e8b727b904b3abb5e3eabb24ed2da109f0a0bad0eccb5237525bedc52718a53a95d2c2142e06d50c63747846a9ea0f2c57e5de99c0922e48d62a45c
'http://archive.ubuntu.com/ubuntu/pool/main/a/adwaita-icon-theme/adwaita-icon-theme_3.36.1.orig.tar.xz' adwaita-icon-theme_3.36.1.orig.tar.xz 17247020 SHA512:5df33c8592ebd17e05fb36590423177fa3e07345565302a5b7ef58fb7d7a9b2b3a1789907a81f5ca0abc7446f7e83af059ca9d6432e8182d5274394c79a24fb9
'http://archive.ubuntu.com/ubuntu/pool/main/a/adwaita-icon-theme/adwaita-icon-theme_3.36.1-2ubuntu0.20.04.2.debian.tar.xz' adwaita-icon-theme_3.36.1-2ubuntu0.20.04.2.debian.tar.xz 30356 SHA512:dbd6542afe35e09d3f91405d07b464fee3aa1cd9c8ba2498e16d17365002409c07c120b452e873e60c51a914273828617824864f1abffad17526f379872e4dfc
```

### `dpkg` source package: `alsa-lib=1.2.2-2.1ubuntu2.5`

Binary Packages:

- `libasound2:amd64=1.2.2-2.1ubuntu2.5`
- `libasound2-data=1.2.2-2.1ubuntu2.5`

Licenses: (parsed from: `/usr/share/doc/libasound2/copyright`, `/usr/share/doc/libasound2-data/copyright`)

- `LGPL-2.1`
- `LPGL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris alsa-lib=1.2.2-2.1ubuntu2.5
'http://archive.ubuntu.com/ubuntu/pool/main/a/alsa-lib/alsa-lib_1.2.2-2.1ubuntu2.5.dsc' alsa-lib_1.2.2-2.1ubuntu2.5.dsc 2029 SHA512:f8fae60a22600c57d7129b9f7e2cf6368b075a611f63330fcfd4e4eac2c9b6b2f1e75679d3258ad4cc090cd6b92dd31e25f32d467360fe821940b5135bfa2eae
'http://archive.ubuntu.com/ubuntu/pool/main/a/alsa-lib/alsa-lib_1.2.2.orig.tar.bz2' alsa-lib_1.2.2.orig.tar.bz2 1030747 SHA512:d21adb3ff998918c7d1820f9ce2aaf4202dd45ccb87cb092d49da8b2402b6ddaad06325be0fd59f17393a5d9958e3743bfccb4b14bdb947a42e7d791d73c7033
'http://archive.ubuntu.com/ubuntu/pool/main/a/alsa-lib/alsa-lib_1.2.2-2.1ubuntu2.5.debian.tar.xz' alsa-lib_1.2.2-2.1ubuntu2.5.debian.tar.xz 59256 SHA512:96f74ee7aa3198267ee228d76088b5f8b9ee5b5a1519ec35e11bf608b5bfaa389857c79fc78800ad21ee09b3709678928f0134de2647102200895aaefd8b0cf6
```

### `dpkg` source package: `alsa-topology-conf=1.2.2-1`

Binary Packages:

- `alsa-topology-conf=1.2.2-1`

Licenses: (parsed from: `/usr/share/doc/alsa-topology-conf/copyright`)

- `BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris alsa-topology-conf=1.2.2-1
'http://archive.ubuntu.com/ubuntu/pool/main/a/alsa-topology-conf/alsa-topology-conf_1.2.2-1.dsc' alsa-topology-conf_1.2.2-1.dsc 2080 SHA256:944e4d481742a09e6c120e532f69c400c88860815297efa8b461befe531b121a
'http://archive.ubuntu.com/ubuntu/pool/main/a/alsa-topology-conf/alsa-topology-conf_1.2.2.orig.tar.bz2' alsa-topology-conf_1.2.2.orig.tar.bz2 6346 SHA256:b472d6b567c78173bd69543d9cffc9e379c80eb763c3afc8d5b24d5610d19425
'http://archive.ubuntu.com/ubuntu/pool/main/a/alsa-topology-conf/alsa-topology-conf_1.2.2-1.debian.tar.xz' alsa-topology-conf_1.2.2-1.debian.tar.xz 2212 SHA256:66e874f2d845434f0f37619bcac2ff51f954219779539f3cceb5b5ef1570a66f
```

### `dpkg` source package: `alsa-ucm-conf=1.2.2-1ubuntu0.13`

Binary Packages:

- `alsa-ucm-conf=1.2.2-1ubuntu0.13`

Licenses: (parsed from: `/usr/share/doc/alsa-ucm-conf/copyright`)

- `BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris alsa-ucm-conf=1.2.2-1ubuntu0.13
'http://archive.ubuntu.com/ubuntu/pool/main/a/alsa-ucm-conf/alsa-ucm-conf_1.2.2-1ubuntu0.13.dsc' alsa-ucm-conf_1.2.2-1ubuntu0.13.dsc 1431 SHA512:edac4b976a0200344731e92ed890719db698f2ca48aad17c7310f57de0149ec2519664720c01c78674f7b5de23e0a34a9af493df6ccb6b5e4df689937035e9cb
'http://archive.ubuntu.com/ubuntu/pool/main/a/alsa-ucm-conf/alsa-ucm-conf_1.2.2.orig.tar.bz2' alsa-ucm-conf_1.2.2.orig.tar.bz2 14608 SHA512:25e3f341c110772c7cffc8c7745b320f2ddd12fe6460380c088939b5dc67b99ae4ad92e69375179574e0e1c40d14ff49961e86494e223fde009e51590f00ca8f
'http://archive.ubuntu.com/ubuntu/pool/main/a/alsa-ucm-conf/alsa-ucm-conf_1.2.2-1ubuntu0.13.debian.tar.xz' alsa-ucm-conf_1.2.2-1ubuntu0.13.debian.tar.xz 20396 SHA512:d9a0130f3e684fbc6e04b72eb083164fe774005b1402c0b95c981285427c95e9d2558892d7f29b9fdcde298960fe90ec179306b8016001f43385f247b2ddd553
```

### `dpkg` source package: `aom=1.0.0.errata1-3+deb11u1build0.20.04.1`

Binary Packages:

- `libaom0:amd64=1.0.0.errata1-3+deb11u1build0.20.04.1`

Licenses: (parsed from: `/usr/share/doc/libaom0/copyright`)

- `BSD-2-Clause`
- `BSD-2-clause`
- `BSD-3-clause`
- `Expat`
- `ISC`
- `public-domain-md5`

Source:

```console
$ apt-get source -qq --print-uris aom=1.0.0.errata1-3+deb11u1build0.20.04.1
'http://archive.ubuntu.com/ubuntu/pool/universe/a/aom/aom_1.0.0.errata1-3%2bdeb11u1build0.20.04.1.dsc' aom_1.0.0.errata1-3+deb11u1build0.20.04.1.dsc 2182 SHA512:7d4f9600ee64ee3cecff8706f4c1520f9d26f43b87e0f153321618980ee8200e49e1fcfce5f8a80ea08199f06d1b1a0559d3d2a45673fb3ff3ff3b189afc2e07
'http://archive.ubuntu.com/ubuntu/pool/universe/a/aom/aom_1.0.0.errata1.orig.tar.xz' aom_1.0.0.errata1.orig.tar.xz 1898808 SHA512:d6b97ce39d0ed37ff3a11293548a454682b56d02afc8ae9669dca57083e2dcec8491f5a3dcb714b8cd03e902c4f6e059a175fcade461ac09a13fc746ba812826
'http://archive.ubuntu.com/ubuntu/pool/universe/a/aom/aom_1.0.0.errata1-3%2bdeb11u1build0.20.04.1.debian.tar.xz' aom_1.0.0.errata1-3+deb11u1build0.20.04.1.debian.tar.xz 24836 SHA512:08e5c4e3c87a8313337f4b6ed8a5eef71747f1037a4b58b212d9f8f8b42a4e1f44cb415f12edfba21f3acce7dd2046523d0ced0176c461b6bd276e3e11d41639
```

### `dpkg` source package: `apache-pom=18-1`

Binary Packages:

- `libapache-pom-java=18-1`

Licenses: (parsed from: `/usr/share/doc/libapache-pom-java/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris apache-pom=18-1
'http://archive.ubuntu.com/ubuntu/pool/universe/a/apache-pom/apache-pom_18-1.dsc' apache-pom_18-1.dsc 2045 SHA256:85ae428afdba43d01fe7d7f942322ceb725781fe3e42f2f4915b5e55e165a633
'http://archive.ubuntu.com/ubuntu/pool/universe/a/apache-pom/apache-pom_18.orig.tar.gz' apache-pom_18.orig.tar.gz 8107 SHA256:5a7e2a1ea9767998929722bbd6c2f34f5a2b3c1cbd14e5210c5465c937acbc36
'http://archive.ubuntu.com/ubuntu/pool/universe/a/apache-pom/apache-pom_18-1.debian.tar.xz' apache-pom_18-1.debian.tar.xz 2804 SHA256:93ea901e12006f057982e7b79dcc5cb205c1fbd886350a3115c8d9c2d8fec593
```

### `dpkg` source package: `apparmor=2.13.3-7ubuntu5.4`

Binary Packages:

- `apparmor=2.13.3-7ubuntu5.4`
- `libapparmor1:amd64=2.13.3-7ubuntu5.4`

Licenses: (parsed from: `/usr/share/doc/apparmor/copyright`, `/usr/share/doc/libapparmor1/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris apparmor=2.13.3-7ubuntu5.4
'http://archive.ubuntu.com/ubuntu/pool/main/a/apparmor/apparmor_2.13.3-7ubuntu5.4.dsc' apparmor_2.13.3-7ubuntu5.4.dsc 3018 SHA512:06af89eb296432b5556172d8002188112e032ff2129b5e0b9bcdac9406f5385b582f3e93943ca2d34c5e137ab8b8e11cb7d1c13b953a0a2cca3e3ef1ea0e37ba
'http://archive.ubuntu.com/ubuntu/pool/main/a/apparmor/apparmor_2.13.3.orig.tar.gz' apparmor_2.13.3.orig.tar.gz 7384974 SHA512:137b2bf026ec655b662e9c264d7d48d878db474a3f1cc5a38bfd7df2f85b682bddb77b091ab5595178231a0a262c9ae9cdd61409461cd889bdee156906ef1141
'http://archive.ubuntu.com/ubuntu/pool/main/a/apparmor/apparmor_2.13.3-7ubuntu5.4.debian.tar.xz' apparmor_2.13.3-7ubuntu5.4.debian.tar.xz 165276 SHA512:7bfc0e4eb42f06779b2b2fa33f89c4a700c62c22fe04d7dea79581eb71171dfc0f7392dea327d7bbd3917e52e2392fe5ee98caa7a30f65958428c2b3f4c4cabf
```

### `dpkg` source package: `apt=2.0.10`

Binary Packages:

- `apt=2.0.10`
- `apt-utils=2.0.10`
- `libapt-pkg6.0:amd64=2.0.10`

Licenses: (parsed from: `/usr/share/doc/apt/copyright`, `/usr/share/doc/apt-utils/copyright`, `/usr/share/doc/libapt-pkg6.0/copyright`)

- `GPL-2`
- `GPLv2+`

Source:

```console
$ apt-get source -qq --print-uris apt=2.0.10
'http://archive.ubuntu.com/ubuntu/pool/main/a/apt/apt_2.0.10.dsc' apt_2.0.10.dsc 2839 SHA512:46d7630f08f46848b7372f1f0790ebb7c22b6122b80ca254978e774d98cacded26ee9a76ea9274f8c4e33e7eb93a0f92bfe3f0e916d750b17ce8c9ce76143d7b
'http://archive.ubuntu.com/ubuntu/pool/main/a/apt/apt_2.0.10.tar.xz' apt_2.0.10.tar.xz 2180704 SHA512:0bc0bdea92026faec3aa2d220db9edbe812fc000dc16a0c22fc508f3ddfceeb95011717dfa67f7efeb29b7f954975ed32c7c947587fd37aa651097bfe586fc63
```

### `dpkg` source package: `argon2=0~20171227-0.2`

Binary Packages:

- `libargon2-1:amd64=0~20171227-0.2`

Licenses: (parsed from: `/usr/share/doc/libargon2-1/copyright`)

- `Apache-2.0`
- `CC0`

Source:

```console
$ apt-get source -qq --print-uris argon2=0~20171227-0.2
'http://archive.ubuntu.com/ubuntu/pool/main/a/argon2/argon2_0%7e20171227-0.2.dsc' argon2_0~20171227-0.2.dsc 2108 SHA256:357d1e93318d7dd3bee401ee9cd92bd0f3ecaab3990013580a12306efda4ebf7
'http://archive.ubuntu.com/ubuntu/pool/main/a/argon2/argon2_0%7e20171227.orig.tar.gz' argon2_0~20171227.orig.tar.gz 1503745 SHA256:eaea0172c1f4ee4550d1b6c9ce01aab8d1ab66b4207776aa67991eb5872fdcd8
'http://archive.ubuntu.com/ubuntu/pool/main/a/argon2/argon2_0%7e20171227-0.2.debian.tar.xz' argon2_0~20171227-0.2.debian.tar.xz 6932 SHA256:49e630c0027ebbe0b53e3e692ce99da750e9bdfeddcebf303e595b4af5a2142f
```

### `dpkg` source package: `at-spi2-atk=2.34.2-0ubuntu2~20.04.1`

Binary Packages:

- `libatk-bridge2.0-0:amd64=2.34.2-0ubuntu2~20.04.1`

Licenses: (parsed from: `/usr/share/doc/libatk-bridge2.0-0/copyright`)

- `GPL-2`
- `LGPL-2`
- `LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris at-spi2-atk=2.34.2-0ubuntu2~20.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/a/at-spi2-atk/at-spi2-atk_2.34.2-0ubuntu2%7e20.04.1.dsc' at-spi2-atk_2.34.2-0ubuntu2~20.04.1.dsc 2704 SHA512:cc98a20c9161f3cbd3e3650fffc2e6267f73eb6b4b39489ae97ed20add1a46288d3752e01e87d3dd9e2338a6892585ca6cee6917cf21cf3dbeee329687bfee5b
'http://archive.ubuntu.com/ubuntu/pool/main/a/at-spi2-atk/at-spi2-atk_2.34.2.orig.tar.xz' at-spi2-atk_2.34.2.orig.tar.xz 96608 SHA512:59e7ad5c944748ca00af8b0a9df03c9ffbc6afae6e65c25a2566a9e2a30e66724c4492076be1730c2894c636f82c795c533669572584d8d5675f68b349ad16c4
'http://archive.ubuntu.com/ubuntu/pool/main/a/at-spi2-atk/at-spi2-atk_2.34.2-0ubuntu2%7e20.04.1.debian.tar.xz' at-spi2-atk_2.34.2-0ubuntu2~20.04.1.debian.tar.xz 10508 SHA512:de0c529ab7f33f6542ff02e17343874f3b3e4254133fd561adf007317913d2ca697d9ac5f2ff1d13cc02d4d1ebf80ff5ea3ab98ebc230a55710e302be3759235
```

### `dpkg` source package: `at-spi2-core=2.36.0-2`

Binary Packages:

- `at-spi2-core=2.36.0-2`
- `libatspi2.0-0:amd64=2.36.0-2`

Licenses: (parsed from: `/usr/share/doc/at-spi2-core/copyright`, `/usr/share/doc/libatspi2.0-0/copyright`)

- `AFL-2.1`
- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris at-spi2-core=2.36.0-2
'http://archive.ubuntu.com/ubuntu/pool/main/a/at-spi2-core/at-spi2-core_2.36.0-2.dsc' at-spi2-core_2.36.0-2.dsc 2675 SHA256:a1eba0f65d0de5c43f9964413fa1e71725c5a75ff18c119dfa8f1ca1d768e9a9
'http://archive.ubuntu.com/ubuntu/pool/main/a/at-spi2-core/at-spi2-core_2.36.0.orig.tar.xz' at-spi2-core_2.36.0.orig.tar.xz 186824 SHA256:88da57de0a7e3c60bc341a974a80fdba091612db3547c410d6deab039ca5c05a
'http://archive.ubuntu.com/ubuntu/pool/main/a/at-spi2-core/at-spi2-core_2.36.0-2.debian.tar.xz' at-spi2-core_2.36.0-2.debian.tar.xz 11036 SHA256:a220220faef2e1363e8a7de035891ab9c81ac19b208eb0e13fc7a19555c582a4
```

### `dpkg` source package: `atk1.0=2.35.1-1ubuntu2`

Binary Packages:

- `libatk1.0-0:amd64=2.35.1-1ubuntu2`
- `libatk1.0-data=2.35.1-1ubuntu2`

Licenses: (parsed from: `/usr/share/doc/libatk1.0-0/copyright`, `/usr/share/doc/libatk1.0-data/copyright`)

- `LGPL-2`

Source:

```console
$ apt-get source -qq --print-uris atk1.0=2.35.1-1ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/a/atk1.0/atk1.0_2.35.1-1ubuntu2.dsc' atk1.0_2.35.1-1ubuntu2.dsc 2892 SHA256:0fc79edbda262b81f27a21f4f410e45d66db6d293f21f69acaadbce49f7cf680
'http://archive.ubuntu.com/ubuntu/pool/main/a/atk1.0/atk1.0_2.35.1.orig.tar.xz' atk1.0_2.35.1.orig.tar.xz 294224 SHA256:be9360fa3f845e91f001c20e73b3a0315b38983411b1dc008195f779ac543884
'http://archive.ubuntu.com/ubuntu/pool/main/a/atk1.0/atk1.0_2.35.1-1ubuntu2.debian.tar.xz' atk1.0_2.35.1-1ubuntu2.debian.tar.xz 13096 SHA256:25821c5a7b675170c9014474c6703deca57074fead11077a5fe2149aefd32a53
```

### `dpkg` source package: `attr=1:2.4.48-5`

Binary Packages:

- `libattr1:amd64=1:2.4.48-5`

Licenses: (parsed from: `/usr/share/doc/libattr1/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2+`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris attr=1:2.4.48-5
'http://archive.ubuntu.com/ubuntu/pool/main/a/attr/attr_2.4.48-5.dsc' attr_2.4.48-5.dsc 2433 SHA256:0b20a285b758083e2e202ffdd2930cef1bf84fee498791fc3e26b69a3bced01d
'http://archive.ubuntu.com/ubuntu/pool/main/a/attr/attr_2.4.48.orig.tar.gz' attr_2.4.48.orig.tar.gz 467840 SHA256:5ead72b358ec709ed00bbf7a9eaef1654baad937c001c044fe8b74c57f5324e7
'http://archive.ubuntu.com/ubuntu/pool/main/a/attr/attr_2.4.48.orig.tar.gz.asc' attr_2.4.48.orig.tar.gz.asc 833 SHA256:5d23c2c83cc13d170f1c209f48d0efa1fc46d16487b790e9996c5206dcfe0395
'http://archive.ubuntu.com/ubuntu/pool/main/a/attr/attr_2.4.48-5.debian.tar.xz' attr_2.4.48-5.debian.tar.xz 25560 SHA256:02238253d324250dabdc0434f7de045d85df93458995a465ac434f2a3978a312
```

### `dpkg` source package: `audit=1:2.8.5-2ubuntu6`

Binary Packages:

- `libaudit-common=1:2.8.5-2ubuntu6`
- `libaudit1:amd64=1:2.8.5-2ubuntu6`

Licenses: (parsed from: `/usr/share/doc/libaudit-common/copyright`, `/usr/share/doc/libaudit1/copyright`)

- `GPL-1`
- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris audit=1:2.8.5-2ubuntu6
'http://archive.ubuntu.com/ubuntu/pool/main/a/audit/audit_2.8.5-2ubuntu6.dsc' audit_2.8.5-2ubuntu6.dsc 2764 SHA256:b149fad8217d68a80299c1ef72539ee7d756146d692b7e51eade7341e60ac528
'http://archive.ubuntu.com/ubuntu/pool/main/a/audit/audit_2.8.5.orig.tar.gz' audit_2.8.5.orig.tar.gz 1140694 SHA256:0e5d4103646e00f8d1981e1cd2faea7a2ae28e854c31a803e907a383c5e2ecb7
'http://archive.ubuntu.com/ubuntu/pool/main/a/audit/audit_2.8.5-2ubuntu6.debian.tar.xz' audit_2.8.5-2ubuntu6.debian.tar.xz 18712 SHA256:d85ecf206bfe256a86e6d39602cd2744beda264a28e413f31c4da227e6542ea7
```

### `dpkg` source package: `avahi=0.7-4ubuntu7.3`

Binary Packages:

- `libavahi-client3:amd64=0.7-4ubuntu7.3`
- `libavahi-common-data:amd64=0.7-4ubuntu7.3`
- `libavahi-common3:amd64=0.7-4ubuntu7.3`

Licenses: (parsed from: `/usr/share/doc/libavahi-client3/copyright`, `/usr/share/doc/libavahi-common-data/copyright`, `/usr/share/doc/libavahi-common3/copyright`)

- `GPL`
- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris avahi=0.7-4ubuntu7.3
'http://archive.ubuntu.com/ubuntu/pool/main/a/avahi/avahi_0.7-4ubuntu7.3.dsc' avahi_0.7-4ubuntu7.3.dsc 3863 SHA512:1ded2340740c27639008930f80c5694c43679619d6186f2c1efb6f04af8efcbab171c1ab7f827bc5c81ca16d2cddd4c69ec14e0e41b564c24551fadd50976e6d
'http://archive.ubuntu.com/ubuntu/pool/main/a/avahi/avahi_0.7.orig.tar.gz' avahi_0.7.orig.tar.gz 1333400 SHA512:bae5a1e9204aca90b90e7fd223d19e809e3514d03ba5fa2da1e55bf1d72d3d3b98567f357900c36393613dc17dc98e15ff3ebf0f226f2f6b9766e592452a6ce7
'http://archive.ubuntu.com/ubuntu/pool/main/a/avahi/avahi_0.7-4ubuntu7.3.debian.tar.xz' avahi_0.7-4ubuntu7.3.debian.tar.xz 41716 SHA512:f224dc3434b9b43f089c7b6f955624d66f4d32e34f53bf3ecc983c446b53ce75666414bb95a03f28e32042a7da1e3107dceedb31361bef95b7365887d7b89579
```

### `dpkg` source package: `base-files=11ubuntu5.8`

Binary Packages:

- `base-files=11ubuntu5.8`

Licenses: (parsed from: `/usr/share/doc/base-files/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris base-files=11ubuntu5.8
'http://archive.ubuntu.com/ubuntu/pool/main/b/base-files/base-files_11ubuntu5.8.dsc' base-files_11ubuntu5.8.dsc 1717 SHA512:65c5f40d4b01ba1cf93520637a3be8ecfa4b32231cdb9888ad261447559de95ac58a33213c3d6d0cefb811f0d9fb9607a3f9cb017301bd25e6424fe9161538bf
'http://archive.ubuntu.com/ubuntu/pool/main/b/base-files/base-files_11ubuntu5.8.tar.xz' base-files_11ubuntu5.8.tar.xz 80736 SHA512:7206dd2a3fb5da4e2901a8ad8cd710c525c9a404ce1364ad7f13816053c3fdaf06f720ac7531f653da2c875752b069200ba278683af4d7a559bba87fca104b5d
```

### `dpkg` source package: `base-passwd=3.5.47`

Binary Packages:

- `base-passwd=3.5.47`

Licenses: (parsed from: `/usr/share/doc/base-passwd/copyright`)

- `GPL-2`
- `PD`

Source:

```console
$ apt-get source -qq --print-uris base-passwd=3.5.47
'http://archive.ubuntu.com/ubuntu/pool/main/b/base-passwd/base-passwd_3.5.47.dsc' base-passwd_3.5.47.dsc 1757 SHA256:5a77a4cce51d1eb72e9d96d4083c641435c05888922c7bd3fa6b4395bf9afad3
'http://archive.ubuntu.com/ubuntu/pool/main/b/base-passwd/base-passwd_3.5.47.tar.xz' base-passwd_3.5.47.tar.xz 53024 SHA256:9810ae0216e96bf9fc7ca6163d47ef8ec7d1677f533451af5911d8202a490a23
```

### `dpkg` source package: `bash=5.0-6ubuntu1.2`

Binary Packages:

- `bash=5.0-6ubuntu1.2`

Licenses: (parsed from: `/usr/share/doc/bash/copyright`)

- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris bash=5.0-6ubuntu1.2
'http://archive.ubuntu.com/ubuntu/pool/main/b/bash/bash_5.0-6ubuntu1.2.dsc' bash_5.0-6ubuntu1.2.dsc 2296 SHA512:d93b919ae7b8e67e3b4e31d205e13006a37aa2a42378744599c3214ecab6544084856a739b38aaeb06742524e2ea302c8147f7a88dbc738e1e7ac0a29be0c0b8
'http://archive.ubuntu.com/ubuntu/pool/main/b/bash/bash_5.0.orig.tar.xz' bash_5.0.orig.tar.xz 5554808 SHA512:f3a719997a8515bae7e84701afafc9b2cdd23c95d29533adb678000b08eba968450b93d5576c3cffbeccbdcd95b713db830e8efeda689258dcfe6f15f0c5dec4
'http://archive.ubuntu.com/ubuntu/pool/main/b/bash/bash_5.0-6ubuntu1.2.debian.tar.xz' bash_5.0-6ubuntu1.2.debian.tar.xz 75200 SHA512:50de22a6cd140fcb95eca9172e9927a4eeddd90bfbd23072d5e209db1675f331716dfd54ef3281caa7020e3fa1aef9ca7caafc6a8d3067741b1ae41f7dff7724
```

### `dpkg` source package: `boost1.71=1.71.0-6ubuntu6`

Binary Packages:

- `libboost-date-time1.71.0:amd64=1.71.0-6ubuntu6`
- `libboost-filesystem1.71.0:amd64=1.71.0-6ubuntu6`
- `libboost-iostreams1.71.0:amd64=1.71.0-6ubuntu6`
- `libboost-locale1.71.0:amd64=1.71.0-6ubuntu6`
- `libboost-thread1.71.0:amd64=1.71.0-6ubuntu6`

Licenses: (parsed from: `/usr/share/doc/libboost-date-time1.71.0/copyright`, `/usr/share/doc/libboost-filesystem1.71.0/copyright`, `/usr/share/doc/libboost-iostreams1.71.0/copyright`, `/usr/share/doc/libboost-locale1.71.0/copyright`, `/usr/share/doc/libboost-thread1.71.0/copyright`)

- `Apache-2.0`
- `BSD2`
- `BSD3_DEShaw`
- `BSD3_Google`
- `BSL-1.0`
- `Caramel`
- `CrystalClear`
- `HP`
- `Jam`
- `Kempf`
- `MIT`
- `NIST`
- `OldBoost1`
- `OldBoost2`
- `OldBoost3`
- `Python`
- `SGI`
- `Spencer`
- `Zlib`

Source:

```console
$ apt-get source -qq --print-uris boost1.71=1.71.0-6ubuntu6
'http://archive.ubuntu.com/ubuntu/pool/main/b/boost1.71/boost1.71_1.71.0-6ubuntu6.dsc' boost1.71_1.71.0-6ubuntu6.dsc 8517 SHA256:e05b5d8de7633e2bf353e9c75d999eafd93bdf47c993023d38f4e5ef5311557b
'http://archive.ubuntu.com/ubuntu/pool/main/b/boost1.71/boost1.71_1.71.0.orig.tar.xz' boost1.71_1.71.0.orig.tar.xz 56601144 SHA256:e30fb3f666df75fc2ba23403ccbd8bcb0ee5595dc099412b4abde7a9fdde3918
'http://archive.ubuntu.com/ubuntu/pool/main/b/boost1.71/boost1.71_1.71.0-6ubuntu6.debian.tar.xz' boost1.71_1.71.0-6ubuntu6.debian.tar.xz 362348 SHA256:56031ade12bf8ca7c196f11f4afd5d2cc30ab840d2a1f1cec5e7ad87b68addeb
```

### `dpkg` source package: `brotli=1.0.7-6ubuntu0.1`

Binary Packages:

- `libbrotli1:amd64=1.0.7-6ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libbrotli1/copyright`)

- `MIT`

Source:

```console
$ apt-get source -qq --print-uris brotli=1.0.7-6ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/b/brotli/brotli_1.0.7-6ubuntu0.1.dsc' brotli_1.0.7-6ubuntu0.1.dsc 2385 SHA512:139a93e110c6cf50531bdfee5ec4a8751ca81d1e02d2f38b21c1a9a478064286ddeb6bfdf20af488f7e2f53219cf460a00e68b77ef1b860fbf0df67f300d303b
'http://archive.ubuntu.com/ubuntu/pool/main/b/brotli/brotli_1.0.7.orig.tar.gz' brotli_1.0.7.orig.tar.gz 23827908 SHA512:a82362aa36d2f2094bca0b2808d9de0d57291fb3a4c29d7c0ca0a37e73087ec5ac4df299c8c363e61106fccf2fe7f58b5cf76eb97729e2696058ef43b1d3930a
'http://archive.ubuntu.com/ubuntu/pool/main/b/brotli/brotli_1.0.7-6ubuntu0.1.debian.tar.xz' brotli_1.0.7-6ubuntu0.1.debian.tar.xz 13672 SHA512:eb24ee68d0a699bb8f382c7f80c313e0bb26bea6b22f74bf01af236eafe345cf602f7544da4a74eb8c8f70defcd6b867018df97a96e5e894535cf731400edaa8
```

### `dpkg` source package: `bsh=2.0b4-20`

Binary Packages:

- `libbsh-java=2.0b4-20`

Licenses: (parsed from: `/usr/share/doc/libbsh-java/copyright`)

- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris bsh=2.0b4-20
'http://archive.ubuntu.com/ubuntu/pool/universe/b/bsh/bsh_2.0b4-20.dsc' bsh_2.0b4-20.dsc 2153 SHA256:4e0280e91b744734e566ab802956af3f8fcccb4681d6b1349831d81569d6b81f
'http://archive.ubuntu.com/ubuntu/pool/universe/b/bsh/bsh_2.0b4.orig.tar.gz' bsh_2.0b4.orig.tar.gz 826645 SHA256:776a64db4967af4fdfa13e3801eaf4249afbb7ffa1ced13f525fdf44e6e340f7
'http://archive.ubuntu.com/ubuntu/pool/universe/b/bsh/bsh_2.0b4-20.debian.tar.xz' bsh_2.0b4-20.debian.tar.xz 9776 SHA256:ce84129dd92e1fb13ea688930c2042b1fa16f8a1a4c1dd5632b13d227df9befe
```

### `dpkg` source package: `bzip2=1.0.8-2`

Binary Packages:

- `bzip2=1.0.8-2`
- `libbz2-1.0:amd64=1.0.8-2`

Licenses: (parsed from: `/usr/share/doc/bzip2/copyright`, `/usr/share/doc/libbz2-1.0/copyright`)

- `BSD-variant`
- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris bzip2=1.0.8-2
'http://archive.ubuntu.com/ubuntu/pool/main/b/bzip2/bzip2_1.0.8-2.dsc' bzip2_1.0.8-2.dsc 2180 SHA256:646cdcbb786a89a647cfafb280ef467143c06c445c4bf6fe69ec4a7882943064
'http://archive.ubuntu.com/ubuntu/pool/main/b/bzip2/bzip2_1.0.8.orig.tar.gz' bzip2_1.0.8.orig.tar.gz 810029 SHA256:ab5a03176ee106d3f0fa90e381da478ddae405918153cca248e682cd0c4a2269
'http://archive.ubuntu.com/ubuntu/pool/main/b/bzip2/bzip2_1.0.8-2.debian.tar.bz2' bzip2_1.0.8-2.debian.tar.bz2 26032 SHA256:237c8619bc9bc16f357b1077064a3e58aa1a230dadb4b9bb3bd8dc8f454afc0b
```

### `dpkg` source package: `ca-certificates-java=20190405ubuntu1.1`

Binary Packages:

- `ca-certificates-java=20190405ubuntu1.1`

Licenses: (parsed from: `/usr/share/doc/ca-certificates-java/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris ca-certificates-java=20190405ubuntu1.1
'http://archive.ubuntu.com/ubuntu/pool/main/c/ca-certificates-java/ca-certificates-java_20190405ubuntu1.1.dsc' ca-certificates-java_20190405ubuntu1.1.dsc 1920 SHA512:18e9985f6617d388c48d5281adfa67bd5f1f6905f495fd6f455a73dda1b9507d1652603cc149dea37b0b674497ca59767afdedbde75e27fd7b839249de3d74b0
'http://archive.ubuntu.com/ubuntu/pool/main/c/ca-certificates-java/ca-certificates-java_20190405ubuntu1.1.tar.xz' ca-certificates-java_20190405ubuntu1.1.tar.xz 18212 SHA512:cf37f61c89c93fb34d9d5262106ad1e94d4ca8d52298540a9b1db3ac30c2ab09b4a6235461b52a3c4ddc153fe8e531c88268781add294e85f82e6626ebdaab79
```

### `dpkg` source package: `ca-certificates=20240203~20.04.1`

Binary Packages:

- `ca-certificates=20240203~20.04.1`

Licenses: (parsed from: `/usr/share/doc/ca-certificates/copyright`)

- `GPL-2`
- `GPL-2+`
- `MPL-2.0`

Source:

```console
$ apt-get source -qq --print-uris ca-certificates=20240203~20.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/c/ca-certificates/ca-certificates_20240203%7e20.04.1.dsc' ca-certificates_20240203~20.04.1.dsc 1850 SHA512:a5824851813f0c9994a26fa02c88f7c027e4ba6d2391274b11b5b12951460564d422595b386baa59ed0d81c4028089cd5ebfc6a1ab19874c0dbcc87e3aea26a2
'http://archive.ubuntu.com/ubuntu/pool/main/c/ca-certificates/ca-certificates_20240203%7e20.04.1.tar.xz' ca-certificates_20240203~20.04.1.tar.xz 263352 SHA512:a0d2af75999aa73500f34f7f36e3dbdc0a5dedf56713727531afd67f9c680ff28510fc2427056c9f7291afd9f17cccbb1ee906512e2955824a97b4c65b7889b9
```

### `dpkg` source package: `cairo=1.16.0-4ubuntu1`

Binary Packages:

- `libcairo-gobject2:amd64=1.16.0-4ubuntu1`
- `libcairo2:amd64=1.16.0-4ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libcairo-gobject2/copyright`, `/usr/share/doc/libcairo2/copyright`)

- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris cairo=1.16.0-4ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/c/cairo/cairo_1.16.0-4ubuntu1.dsc' cairo_1.16.0-4ubuntu1.dsc 2950 SHA256:f53596e412c2e1799d5e7e1c414d7db2cade33ba85fd912d39f60525b5a2e23b
'http://archive.ubuntu.com/ubuntu/pool/main/c/cairo/cairo_1.16.0.orig.tar.xz' cairo_1.16.0.orig.tar.xz 41997432 SHA256:5e7b29b3f113ef870d1e3ecf8adf21f923396401604bda16d44be45e66052331
'http://archive.ubuntu.com/ubuntu/pool/main/c/cairo/cairo_1.16.0-4ubuntu1.debian.tar.xz' cairo_1.16.0-4ubuntu1.debian.tar.xz 30416 SHA256:3725774f0a3f244a8b910e5a5e46bc731ee87372c6effb6c5af2d0db65c64426
```

### `dpkg` source package: `cdebconf=0.251ubuntu1`

Binary Packages:

- `libdebconfclient0:amd64=0.251ubuntu1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris cdebconf=0.251ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/c/cdebconf/cdebconf_0.251ubuntu1.dsc' cdebconf_0.251ubuntu1.dsc 2858 SHA256:0753b98ec773e743de19d393f444a8b88915ad75340cc58007eb7c309031121d
'http://archive.ubuntu.com/ubuntu/pool/main/c/cdebconf/cdebconf_0.251ubuntu1.tar.xz' cdebconf_0.251ubuntu1.tar.xz 276744 SHA256:d07848e52aecb70e82d8bafd082ecee3cccd7a8229b59527e07cc49023aa22d0
```

### `dpkg` source package: `cdparanoia=3.10.2+debian-13`

Binary Packages:

- `libcdparanoia0:amd64=3.10.2+debian-13`

Licenses: (parsed from: `/usr/share/doc/libcdparanoia0/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris cdparanoia=3.10.2+debian-13
'http://archive.ubuntu.com/ubuntu/pool/main/c/cdparanoia/cdparanoia_3.10.2%2bdebian-13.dsc' cdparanoia_3.10.2+debian-13.dsc 2195 SHA256:7ddf0ba8b09821d50a4b226c19ad008df8285cbd86d5148e035067092c544551
'http://archive.ubuntu.com/ubuntu/pool/main/c/cdparanoia/cdparanoia_3.10.2%2bdebian.orig.tar.gz' cdparanoia_3.10.2+debian.orig.tar.gz 178436 SHA256:402f8b8b4370dbdc276dfd624f768956d212893542a91ecbaa6b4206b2afef03
'http://archive.ubuntu.com/ubuntu/pool/main/c/cdparanoia/cdparanoia_3.10.2%2bdebian-13.debian.tar.xz' cdparanoia_3.10.2+debian-13.debian.tar.xz 61152 SHA256:cff55e4394f6da0fb226b9d36cf773dbd022d8ac689a01419375d88708da2614
```

### `dpkg` source package: `chromaprint=1.4.3-3build1`

Binary Packages:

- `libchromaprint1:amd64=1.4.3-3build1`

Licenses: (parsed from: `/usr/share/doc/libchromaprint1/copyright`)

- `BSD-3-clause`
- `Expat`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris chromaprint=1.4.3-3build1
'http://archive.ubuntu.com/ubuntu/pool/universe/c/chromaprint/chromaprint_1.4.3-3build1.dsc' chromaprint_1.4.3-3build1.dsc 2291 SHA256:aeb17ca7aa2e65624469f15940af23bd030fc49835b3aeb5965d3decad695aed
'http://archive.ubuntu.com/ubuntu/pool/universe/c/chromaprint/chromaprint_1.4.3.orig.tar.gz' chromaprint_1.4.3.orig.tar.gz 613718 SHA256:d4ae6596283aad7a015a5b0445012054c634a4b9329ecb23000cd354b40a283b
'http://archive.ubuntu.com/ubuntu/pool/universe/c/chromaprint/chromaprint_1.4.3-3build1.debian.tar.xz' chromaprint_1.4.3-3build1.debian.tar.xz 6736 SHA256:4f0e18ba5a56ae9d294064c6c44b844518c233eae30d4abe462c316ef8746ec7
```

### `dpkg` source package: `clucene-core=2.3.3.4+dfsg-1build1`

Binary Packages:

- `libclucene-contribs1v5:amd64=2.3.3.4+dfsg-1build1`
- `libclucene-core1v5:amd64=2.3.3.4+dfsg-1build1`

Licenses: (parsed from: `/usr/share/doc/libclucene-contribs1v5/copyright`, `/usr/share/doc/libclucene-core1v5/copyright`)

- `Apache-2.0`
- `LGPL-2.1`
- `Reuters-21578 - Distribution 1.0`

Source:

```console
$ apt-get source -qq --print-uris clucene-core=2.3.3.4+dfsg-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/c/clucene-core/clucene-core_2.3.3.4%2bdfsg-1build1.dsc' clucene-core_2.3.3.4+dfsg-1build1.dsc 2068 SHA256:57a6ebed26d5ede7b7e1ebecb2fa5f637c847f88f069b527ed904837b3472e74
'http://archive.ubuntu.com/ubuntu/pool/main/c/clucene-core/clucene-core_2.3.3.4%2bdfsg.orig.tar.xz' clucene-core_2.3.3.4+dfsg.orig.tar.xz 826688 SHA256:c70b8202c0afca27f9fa2f1a5d09a41bc4cc57a8f68c854379891ea2e24f1490
'http://archive.ubuntu.com/ubuntu/pool/main/c/clucene-core/clucene-core_2.3.3.4%2bdfsg-1build1.debian.tar.xz' clucene-core_2.3.3.4+dfsg-1build1.debian.tar.xz 8808 SHA256:e2756237df734de432fa539eafcc54f43a27e632760ed94f84448117aee56bbd
```

### `dpkg` source package: `codec2=0.9.2-2`

Binary Packages:

- `libcodec2-0.9:amd64=0.9.2-2`

Licenses: (parsed from: `/usr/share/doc/libcodec2-0.9/copyright`)

- `COPYING`
- `JMVBSD`
- `KISSFFTBSD`
- `LGPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris codec2=0.9.2-2
'http://archive.ubuntu.com/ubuntu/pool/universe/c/codec2/codec2_0.9.2-2.dsc' codec2_0.9.2-2.dsc 2601 SHA256:926a56d8bbb0b0f57d382f010234b6b281abfa9be44b7508bef91939f89fea3e
'http://archive.ubuntu.com/ubuntu/pool/universe/c/codec2/codec2_0.9.2.orig-lpcnet.tar.gz' codec2_0.9.2.orig-lpcnet.tar.gz 33010724 SHA256:50150390610ac13d2101d65a8d1c6983ca1c2189887bea503e4bffcce6463aaf
'http://archive.ubuntu.com/ubuntu/pool/universe/c/codec2/codec2_0.9.2.orig-lpcnet191005.tar.gz' codec2_0.9.2.orig-lpcnet191005.tar.gz 18396516 SHA256:509440924751fdd87ffaa5683ee3dddd937af5c833b9104ccce65d51614926c8
'http://archive.ubuntu.com/ubuntu/pool/universe/c/codec2/codec2_0.9.2.orig.tar.gz' codec2_0.9.2.orig.tar.gz 12244006 SHA256:19181a446f4df3e6d616b50cabdac4485abb9cd3242cf312a0785f892ed4c76c
'http://archive.ubuntu.com/ubuntu/pool/universe/c/codec2/codec2_0.9.2-2.debian.tar.xz' codec2_0.9.2-2.debian.tar.xz 52172 SHA256:18777f5340680fa0abae55124ecf2d09924a6e5eec96041baa19f442b72a08ac
```

### `dpkg` source package: `colord=1.4.4-2`

Binary Packages:

- `libcolord2:amd64=1.4.4-2`

Licenses: (parsed from: `/usr/share/doc/libcolord2/copyright`)

- `CC0`
- `GFDL-NIV`
- `GPL-2`
- `GPL-2+`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris colord=1.4.4-2
'http://archive.ubuntu.com/ubuntu/pool/main/c/colord/colord_1.4.4-2.dsc' colord_1.4.4-2.dsc 2914 SHA256:9a8a37cb3215a62580ef793916e5685096cf5717a3cce56d2b255dd26a6cc312
'http://archive.ubuntu.com/ubuntu/pool/main/c/colord/colord_1.4.4.orig.tar.xz' colord_1.4.4.orig.tar.xz 1855696 SHA256:9a0fe80160bf88efddb582a9fc0169f56065276dc3882c47dddb9eecd048c0a5
'http://archive.ubuntu.com/ubuntu/pool/main/c/colord/colord_1.4.4.orig.tar.xz.asc' colord_1.4.4.orig.tar.xz.asc 488 SHA256:6346d37bb24d626001a2ceb9eaa41c810a0207695d4e5493d6a91cc3c2c71bd2
'http://archive.ubuntu.com/ubuntu/pool/main/c/colord/colord_1.4.4-2.debian.tar.xz' colord_1.4.4-2.debian.tar.xz 31408 SHA256:9570a9511d0769c3b407c123af0f39e3e62285119db646e3b730305c85016dfe
```

### `dpkg` source package: `commons-parent=43-1`

Binary Packages:

- `libcommons-parent-java=43-1`

Licenses: (parsed from: `/usr/share/doc/libcommons-parent-java/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris commons-parent=43-1
'http://archive.ubuntu.com/ubuntu/pool/universe/c/commons-parent/commons-parent_43-1.dsc' commons-parent_43-1.dsc 2231 SHA256:872bdd6878193c4bf1a8117bc3b61615d674e287e1ebcca98e6320950de553b4
'http://archive.ubuntu.com/ubuntu/pool/universe/c/commons-parent/commons-parent_43.orig.tar.xz' commons-parent_43.orig.tar.xz 28364 SHA256:ec67c89ccd15b59dc6b7c295af57bea9975a2482aad150499940587e58fd1986
'http://archive.ubuntu.com/ubuntu/pool/universe/c/commons-parent/commons-parent_43-1.debian.tar.xz' commons-parent_43-1.debian.tar.xz 3404 SHA256:b60aa8fb108431fd15277de8762eeec678733489a7977240c87619eb2fa674ab
```

### `dpkg` source package: `coreutils=8.30-3ubuntu2`

Binary Packages:

- `coreutils=8.30-3ubuntu2`

Licenses: (parsed from: `/usr/share/doc/coreutils/copyright`)

- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris coreutils=8.30-3ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/c/coreutils/coreutils_8.30-3ubuntu2.dsc' coreutils_8.30-3ubuntu2.dsc 2048 SHA256:f36fe0ac14978b240a750b79d2bbd737d6b1939296c3a287899933aa2a1906ea
'http://archive.ubuntu.com/ubuntu/pool/main/c/coreutils/coreutils_8.30.orig.tar.xz' coreutils_8.30.orig.tar.xz 5359532 SHA256:e831b3a86091496cdba720411f9748de81507798f6130adeaef872d206e1b057
'http://archive.ubuntu.com/ubuntu/pool/main/c/coreutils/coreutils_8.30-3ubuntu2.debian.tar.xz' coreutils_8.30-3ubuntu2.debian.tar.xz 39636 SHA256:98204ef9d94e5c567880cd0245fdb7940eaf7592d6c6830c300ad117628b351f
```

### `dpkg` source package: `cryptsetup=2:2.2.2-3ubuntu2.4`

Binary Packages:

- `libcryptsetup12:amd64=2:2.2.2-3ubuntu2.4`

Licenses: (parsed from: `/usr/share/doc/libcryptsetup12/copyright`)

- `Apache-2.0`
- `CC0`
- `CC0-1.0`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with OpenSSL exception`
- `LGPL-2.1`
- `LGPL-2.1+`
- `LGPL-2.1+ with OpenSSL exception`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris cryptsetup=2:2.2.2-3ubuntu2.4
'http://archive.ubuntu.com/ubuntu/pool/main/c/cryptsetup/cryptsetup_2.2.2-3ubuntu2.4.dsc' cryptsetup_2.2.2-3ubuntu2.4.dsc 2968 SHA512:10212eb04e0463bfea7a41d4198ff0b7c5f01067e9a11e24bc1dc5955e0e0e4a384c928bba0c58926c56f6206486f6fecd0e8381bddb84638fdfb8acec25767c
'http://archive.ubuntu.com/ubuntu/pool/main/c/cryptsetup/cryptsetup_2.2.2.orig.tar.gz' cryptsetup_2.2.2.orig.tar.gz 10912347 SHA512:e7a19c12a0959fbaf75caf033d9737e3505a3f97da12a544959a435e10aa5c4499376b66309bd94db2b9acc13a9515ba6359145f950614487b8f35914819e9eb
'http://archive.ubuntu.com/ubuntu/pool/main/c/cryptsetup/cryptsetup_2.2.2-3ubuntu2.4.debian.tar.xz' cryptsetup_2.2.2-3ubuntu2.4.debian.tar.xz 128480 SHA512:8c5c73b3c7d08bb73d2662c782159921c2b75a541a2549512e5a03f881352cc05abe5c9f86c2ec8d3d752aa16ceff56fca357e47fc7994412eeb5dd0203c88ef
```

### `dpkg` source package: `cups=2.3.1-9ubuntu1.9`

Binary Packages:

- `libcups2:amd64=2.3.1-9ubuntu1.9`

Licenses: (parsed from: `/usr/share/doc/libcups2/copyright`)

- `Apache-2.0`
- `Apache-2.0-with-GPL2-LGPL2-Exception`
- `BSD-2-clause`
- `BSD-3-clause`
- `FSFUL`
- `Zlib`

Source:

```console
$ apt-get source -qq --print-uris cups=2.3.1-9ubuntu1.9
'http://archive.ubuntu.com/ubuntu/pool/main/c/cups/cups_2.3.1-9ubuntu1.9.dsc' cups_2.3.1-9ubuntu1.9.dsc 3415 SHA512:964eb2ba8f6cfa4b19dda82979316fc8315ce79430516c17995f3c349eeece8788b6aef9acf5a2a60d9cbaa9cff13a233708b1cb7ef8ac9a30c5071e194d756e
'http://archive.ubuntu.com/ubuntu/pool/main/c/cups/cups_2.3.1.orig.tar.gz' cups_2.3.1.orig.tar.gz 8135891 SHA512:e3f3ad9e78c1c723d46cc2276957ac67495483882f639421203d9dad227eacbb1259717a92489e710995fdc89e2d575202e4b43117aff08ff1230dcf06674376
'http://archive.ubuntu.com/ubuntu/pool/main/c/cups/cups_2.3.1.orig.tar.gz.asc' cups_2.3.1.orig.tar.gz.asc 858 SHA512:a9770f3346229c687b6ec1a5b42231e68ec547339f7d5b29467014d13a2706daf6f5aa9cdc0dd24efd386bdf966890e927cbab61d7a461612f075127c24a2b28
'http://archive.ubuntu.com/ubuntu/pool/main/c/cups/cups_2.3.1-9ubuntu1.9.debian.tar.xz' cups_2.3.1-9ubuntu1.9.debian.tar.xz 365168 SHA512:9f96f1ba21b655c2a3ccb9ca63154d77d7bfc19466b97bcae528dc9c843fe224d05c69c29606d5e0de9d2e9c96c889dd85237f4d759e864540d868545de77832
```

### `dpkg` source package: `curl=7.68.0-1ubuntu2.24`

Binary Packages:

- `curl=7.68.0-1ubuntu2.24`
- `libcurl3-gnutls:amd64=7.68.0-1ubuntu2.24`
- `libcurl4:amd64=7.68.0-1ubuntu2.24`

Licenses: (parsed from: `/usr/share/doc/curl/copyright`, `/usr/share/doc/libcurl3-gnutls/copyright`, `/usr/share/doc/libcurl4/copyright`)

- `BSD-3-Clause`
- `BSD-4-Clause`
- `ISC`
- `curl`
- `other`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris curl=7.68.0-1ubuntu2.24
'http://archive.ubuntu.com/ubuntu/pool/main/c/curl/curl_7.68.0-1ubuntu2.24.dsc' curl_7.68.0-1ubuntu2.24.dsc 2737 SHA512:ab420767f8de267830f3cb12008ac4182d080487ec4a291ae9918f3b836e97ff2df12e5d00d77e1039bb080496d05871fe9462414a6bc95864217a0da7cb9d84
'http://archive.ubuntu.com/ubuntu/pool/main/c/curl/curl_7.68.0.orig.tar.gz' curl_7.68.0.orig.tar.gz 4096350 SHA512:58b42c08b1cf4cb6e68f8e469d5b5f6298eebe286ba2677ad29e1a7eefd15b8609af54544f4c5a7dadebbd3b23bd77700830f2f60fbea7ae3f2f306e640010b0
'http://archive.ubuntu.com/ubuntu/pool/main/c/curl/curl_7.68.0-1ubuntu2.24.debian.tar.xz' curl_7.68.0-1ubuntu2.24.debian.tar.xz 74136 SHA512:aa10f5fd69b94ad79f47d6c7deb7b1290b561e57cd88b65cdd035868b56c1d71408fddf486bf52a132c00f4d12bc44ce4e9c4d97937f9263b57375b6060e825c
```

### `dpkg` source package: `cyrus-sasl2=2.1.27+dfsg-2ubuntu0.1`

Binary Packages:

- `libsasl2-2:amd64=2.1.27+dfsg-2ubuntu0.1`
- `libsasl2-modules:amd64=2.1.27+dfsg-2ubuntu0.1`
- `libsasl2-modules-db:amd64=2.1.27+dfsg-2ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libsasl2-2/copyright`, `/usr/share/doc/libsasl2-modules/copyright`, `/usr/share/doc/libsasl2-modules-db/copyright`)

- `BSD-4-clause`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris cyrus-sasl2=2.1.27+dfsg-2ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/c/cyrus-sasl2/cyrus-sasl2_2.1.27%2bdfsg-2ubuntu0.1.dsc' cyrus-sasl2_2.1.27+dfsg-2ubuntu0.1.dsc 3511 SHA512:70d73c119ef8986adbb0b8f52be7459f756ea8f8e2bf836b2c57e5230f63052999cd716d6585d4b1d65f854a471afbc0f344e88759e99c5ea129b82216400903
'http://archive.ubuntu.com/ubuntu/pool/main/c/cyrus-sasl2/cyrus-sasl2_2.1.27%2bdfsg.orig.tar.xz' cyrus-sasl2_2.1.27+dfsg.orig.tar.xz 2058596 SHA512:a795e4362f85a50e223c5456d03526832eb29fdbc9e17a767045f8542638e3f987d382b79b072bcd694bd1a12cbb818cff6c326063ca2bbe05453c1acf7fb8ad
'http://archive.ubuntu.com/ubuntu/pool/main/c/cyrus-sasl2/cyrus-sasl2_2.1.27%2bdfsg-2ubuntu0.1.debian.tar.xz' cyrus-sasl2_2.1.27+dfsg-2ubuntu0.1.debian.tar.xz 100804 SHA512:391bfecc0859839514a320739b93555f44e1101042d262c9c3c3623a5e1a73ca304f9509bd8bc2d62e691dc4c15570e8af5a52c97483fff8600d48eeb13ca518
```

### `dpkg` source package: `dash=0.5.10.2-6`

Binary Packages:

- `dash=0.5.10.2-6`

Licenses: (parsed from: `/usr/share/doc/dash/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris dash=0.5.10.2-6
'http://archive.ubuntu.com/ubuntu/pool/main/d/dash/dash_0.5.10.2-6.dsc' dash_0.5.10.2-6.dsc 1756 SHA256:d509a23ebdc4f107c911914590c1400e5a24383f35c5d6904e48d2afeff168ac
'http://archive.ubuntu.com/ubuntu/pool/main/d/dash/dash_0.5.10.2.orig.tar.gz' dash_0.5.10.2.orig.tar.gz 225196 SHA256:3c663919dc5c66ec991da14c7cf7e0be8ad00f3db73986a987c118862b5f6071
'http://archive.ubuntu.com/ubuntu/pool/main/d/dash/dash_0.5.10.2-6.debian.tar.xz' dash_0.5.10.2-6.debian.tar.xz 44232 SHA256:1448fbfc2541be52787da81ce03bb81ad6b1f380cba1b7e747abefdcd44f6c86
```

### `dpkg` source package: `db5.3=5.3.28+dfsg1-0.6ubuntu2`

Binary Packages:

- `libdb5.3:amd64=5.3.28+dfsg1-0.6ubuntu2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris db5.3=5.3.28+dfsg1-0.6ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/d/db5.3/db5.3_5.3.28%2bdfsg1-0.6ubuntu2.dsc' db5.3_5.3.28+dfsg1-0.6ubuntu2.dsc 3245 SHA256:d879f4921a2f573132031d9371f0eb020005bdce48d6e12b436bf3515dda8663
'http://archive.ubuntu.com/ubuntu/pool/main/d/db5.3/db5.3_5.3.28%2bdfsg1.orig.tar.xz' db5.3_5.3.28+dfsg1.orig.tar.xz 19723860 SHA256:b19bf3dd8ce74b95a7b215be9a7c8489e8e8f18da60d64d6340a06e75f497749
'http://archive.ubuntu.com/ubuntu/pool/main/d/db5.3/db5.3_5.3.28%2bdfsg1-0.6ubuntu2.debian.tar.xz' db5.3_5.3.28+dfsg1-0.6ubuntu2.debian.tar.xz 30172 SHA256:e606e7827f077efc92afc6f0d43c921fab4577d619eab06fab23182aefab7506
```

### `dpkg` source package: `dbus-python=1.2.16-1build1`

Binary Packages:

- `python3-dbus=1.2.16-1build1`

Licenses: (parsed from: `/usr/share/doc/python3-dbus/copyright`)

- `AFL-2.1`
- `Expat`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris dbus-python=1.2.16-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/d/dbus-python/dbus-python_1.2.16-1build1.dsc' dbus-python_1.2.16-1build1.dsc 3641 SHA256:8ecda77e26175c8f2fa6b8960e89161cd2571e3aa4f9d1580f1f1a3136b35a97
'http://archive.ubuntu.com/ubuntu/pool/main/d/dbus-python/dbus-python_1.2.16.orig.tar.gz' dbus-python_1.2.16.orig.tar.gz 576701 SHA256:11238f1d86c995d8aed2e22f04a1e3779f0d70e587caffeab4857f3c662ed5a4
'http://archive.ubuntu.com/ubuntu/pool/main/d/dbus-python/dbus-python_1.2.16.orig.tar.gz.asc' dbus-python_1.2.16.orig.tar.gz.asc 833 SHA256:0fcfcb9844226c5cde1690b74b3c094d802ea735392d3a8829f1b5993837e86c
'http://archive.ubuntu.com/ubuntu/pool/main/d/dbus-python/dbus-python_1.2.16-1build1.debian.tar.xz' dbus-python_1.2.16-1build1.debian.tar.xz 34532 SHA256:691fd294a727e96250e084ba3ee388d9e226b2808ce1edf58d1782000dbe1425
```

### `dpkg` source package: `dbus=1.12.16-2ubuntu2.3`

Binary Packages:

- `dbus=1.12.16-2ubuntu2.3`
- `dbus-user-session=1.12.16-2ubuntu2.3`
- `libdbus-1-3:amd64=1.12.16-2ubuntu2.3`

Licenses: (parsed from: `/usr/share/doc/dbus/copyright`, `/usr/share/doc/dbus-user-session/copyright`, `/usr/share/doc/libdbus-1-3/copyright`)

- `AFL-2.1`
- `AFL-2.1,`
- `BSD-3-clause`
- `BSD-3-clause-generic`
- `Expat`
- `GPL-2`
- `GPL-2+`
- `Tcl-BSDish`
- `g10-permissive`

Source:

```console
$ apt-get source -qq --print-uris dbus=1.12.16-2ubuntu2.3
'http://archive.ubuntu.com/ubuntu/pool/main/d/dbus/dbus_1.12.16-2ubuntu2.3.dsc' dbus_1.12.16-2ubuntu2.3.dsc 3737 SHA512:cfdecfc26b17ae7a5e8f4e68ba3fe21109dcb93886e65187606be2f37f9d43ce76b677cfca438805165feab4b8d8db6d981b6dc3d1c04263e391bda18a90784c
'http://archive.ubuntu.com/ubuntu/pool/main/d/dbus/dbus_1.12.16.orig.tar.gz' dbus_1.12.16.orig.tar.gz 2093296 SHA512:27ae805170e9515a8bb0fba5f29d414edc70e3b6b28b7b65bbea47035b8eafa9ac4820cdc92645be6035f6748f8aa45679e1ffc84ba74a64859a3056d318b9bb
'http://archive.ubuntu.com/ubuntu/pool/main/d/dbus/dbus_1.12.16.orig.tar.gz.asc' dbus_1.12.16.orig.tar.gz.asc 833 SHA512:6d19bf7be86ae1dc70550ba472e5761f3ed1a71007c00679e3a586d567776e82cf9869c9a7021c1324990615657a054b949dc5bbd8e60b0a8843ef6d977eda24
'http://archive.ubuntu.com/ubuntu/pool/main/d/dbus/dbus_1.12.16-2ubuntu2.3.debian.tar.xz' dbus_1.12.16-2ubuntu2.3.debian.tar.xz 73812 SHA512:21319e8a84d5206522a9b65ee81878cecb73cbfda839758987c2a96c7f2c258efe8165d0980f293d5be22ac1659afafb5cd727b09408d4da4057569f7a42ef39
```

### `dpkg` source package: `dconf=0.36.0-1`

Binary Packages:

- `dconf-gsettings-backend:amd64=0.36.0-1`
- `dconf-service=0.36.0-1`
- `libdconf1:amd64=0.36.0-1`

Licenses: (parsed from: `/usr/share/doc/dconf-gsettings-backend/copyright`, `/usr/share/doc/dconf-service/copyright`, `/usr/share/doc/libdconf1/copyright`)

- `GPL-3`
- `LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris dconf=0.36.0-1
'http://archive.ubuntu.com/ubuntu/pool/main/d/dconf/dconf_0.36.0-1.dsc' dconf_0.36.0-1.dsc 2320 SHA256:b5ac5d2b3075705f5922c1da479e0c2faeb4adf696d70ae07e3604143899e608
'http://archive.ubuntu.com/ubuntu/pool/main/d/dconf/dconf_0.36.0.orig.tar.xz' dconf_0.36.0.orig.tar.xz 114828 SHA256:9fe6bb22191fc2a036ad86fd8e7d165e9983c687b9fedccf85d46c799301da2d
'http://archive.ubuntu.com/ubuntu/pool/main/d/dconf/dconf_0.36.0-1.debian.tar.xz' dconf_0.36.0-1.debian.tar.xz 10472 SHA256:bb0d86cbef3d5faffa00fa11b66d17b858974c28ef2fcbaf1d50c8ea2fb54e09
```

### `dpkg` source package: `debconf=1.5.73`

Binary Packages:

- `debconf=1.5.73`

Licenses: (parsed from: `/usr/share/doc/debconf/copyright`)

- `BSD-2-clause`

Source:

```console
$ apt-get source -qq --print-uris debconf=1.5.73
'http://archive.ubuntu.com/ubuntu/pool/main/d/debconf/debconf_1.5.73.dsc' debconf_1.5.73.dsc 2081 SHA256:cdd4c049414cd167a4a9479d883e205bf5cebb19fc4bb6f132000a56291eb670
'http://archive.ubuntu.com/ubuntu/pool/main/d/debconf/debconf_1.5.73.tar.xz' debconf_1.5.73.tar.xz 570780 SHA256:513895b2b77d9fb72542152390e7d4c67fe1e08de75fdad44d54ce1e7d83ecef
```

### `dpkg` source package: `debianutils=4.9.1`

Binary Packages:

- `debianutils=4.9.1`

Licenses: (parsed from: `/usr/share/doc/debianutils/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris debianutils=4.9.1
'http://archive.ubuntu.com/ubuntu/pool/main/d/debianutils/debianutils_4.9.1.dsc' debianutils_4.9.1.dsc 1592 SHA256:d30866ea0352263fa7756010e8743ade350024b2fd491bc5befcbaa9a97626b7
'http://archive.ubuntu.com/ubuntu/pool/main/d/debianutils/debianutils_4.9.1.tar.xz' debianutils_4.9.1.tar.xz 157516 SHA256:af826685d9c56abfa873e84cd392539cd363cb0ba04a09d21187377e1b764091
```

### `dpkg` source package: `dictionaries-common=1.28.1`

Binary Packages:

- `dictionaries-common=1.28.1`

Licenses: (parsed from: `/usr/share/doc/dictionaries-common/copyright`)

- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris dictionaries-common=1.28.1
'http://archive.ubuntu.com/ubuntu/pool/main/d/dictionaries-common/dictionaries-common_1.28.1.dsc' dictionaries-common_1.28.1.dsc 1887 SHA256:cc458494d42ee3a6e4ba0d1733db86b83b58710d98b135c02600851248c9b970
'http://archive.ubuntu.com/ubuntu/pool/main/d/dictionaries-common/dictionaries-common_1.28.1.tar.gz' dictionaries-common_1.28.1.tar.gz 361303 SHA256:b30233ec4df23d3728807fd836c9e20c5b6756a87c8c7520beafdea5e09faffa
```

### `dpkg` source package: `diffutils=1:3.7-3`

Binary Packages:

- `diffutils=1:3.7-3`

Licenses: (parsed from: `/usr/share/doc/diffutils/copyright`)

- `GFDL`
- `GPL`

Source:

```console
$ apt-get source -qq --print-uris diffutils=1:3.7-3
'http://archive.ubuntu.com/ubuntu/pool/main/d/diffutils/diffutils_3.7-3.dsc' diffutils_3.7-3.dsc 1453 SHA256:99dee94cec05454a65a9cb542bea1720dbd4c511d13f9784c9e3741e76a9b9ba
'http://archive.ubuntu.com/ubuntu/pool/main/d/diffutils/diffutils_3.7.orig.tar.xz' diffutils_3.7.orig.tar.xz 1448828 SHA256:b3a7a6221c3dc916085f0d205abf6b8e1ba443d4dd965118da364a1dc1cb3a26
'http://archive.ubuntu.com/ubuntu/pool/main/d/diffutils/diffutils_3.7-3.debian.tar.xz' diffutils_3.7-3.debian.tar.xz 11116 SHA256:a455228f12283b5f3c0165db4ab9b12071adc37fb9dd50dcb5e1b8851c524f1f
```

### `dpkg` source package: `djvulibre=3.5.27.1-14ubuntu0.1`

Binary Packages:

- `libdjvulibre-text=3.5.27.1-14ubuntu0.1`
- `libdjvulibre21:amd64=3.5.27.1-14ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libdjvulibre-text/copyright`, `/usr/share/doc/libdjvulibre21/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris djvulibre=3.5.27.1-14ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/d/djvulibre/djvulibre_3.5.27.1-14ubuntu0.1.dsc' djvulibre_3.5.27.1-14ubuntu0.1.dsc 2500 SHA512:46ea7723d3d6fbffeb7af94c0391ae12eb2521da72d1d437462df92cbc51632022b7ee0e11b0160f69e8ed9f699cf22a4a19538920999e1211c2e527c08f04ac
'http://archive.ubuntu.com/ubuntu/pool/main/d/djvulibre/djvulibre_3.5.27.1.orig.tar.gz' djvulibre_3.5.27.1.orig.tar.gz 3231662 SHA512:2ed11daa05995db7bf52113e2f75456c3c804988d2c17d0183b24ab379e52a4ef1871189e8bb132fec6cbc9d629b4d67a4d89ef7df7a995044cb25ff3dcc5de8
'http://archive.ubuntu.com/ubuntu/pool/main/d/djvulibre/djvulibre_3.5.27.1-14ubuntu0.1.debian.tar.xz' djvulibre_3.5.27.1-14ubuntu0.1.debian.tar.xz 78008 SHA512:9b293e1f90432f7a9851efe46d2f199ffe65cbd53e90acaff608bdc21b77b983b0f653a206aa09687f8e68564ae0103a07038466be54730bbedf94a16928c1cf
```

### `dpkg` source package: `dpkg=1.19.7ubuntu3.2`

Binary Packages:

- `dpkg=1.19.7ubuntu3.2`

Licenses: (parsed from: `/usr/share/doc/dpkg/copyright`)

- `BSD-2-clause`
- `GPL-2`
- `GPL-2+`
- `public-domain-md5`
- `public-domain-s-s-d`

Source:

```console
$ apt-get source -qq --print-uris dpkg=1.19.7ubuntu3.2
'http://archive.ubuntu.com/ubuntu/pool/main/d/dpkg/dpkg_1.19.7ubuntu3.2.dsc' dpkg_1.19.7ubuntu3.2.dsc 2237 SHA512:7784d9d17a2bd5d85a776a2d744bd496630dcd8bb83e2986ff76adef2596e8e1ab1ad809c282049c44b25cebb90b5d2ef59c2cafbad4dd5f8ffbcc475b263f3b
'http://archive.ubuntu.com/ubuntu/pool/main/d/dpkg/dpkg_1.19.7ubuntu3.2.tar.xz' dpkg_1.19.7ubuntu3.2.tar.xz 4732068 SHA512:a69c51b04fe52ca5ca44111baf83eeaff4cf5167f5322a4c1a7671dc4a6ce5e25095bad73ff4d9c197427d21f3bf1a246f99007dde8890f33c79bb572f7f95fc
```

### `dpkg` source package: `e2fsprogs=1.45.5-2ubuntu1.2`

Binary Packages:

- `e2fsprogs=1.45.5-2ubuntu1.2`
- `libcom-err2:amd64=1.45.5-2ubuntu1.2`
- `libext2fs2:amd64=1.45.5-2ubuntu1.2`
- `libss2:amd64=1.45.5-2ubuntu1.2`
- `logsave=1.45.5-2ubuntu1.2`

Licenses: (parsed from: `/usr/share/doc/e2fsprogs/copyright`, `/usr/share/doc/libcom-err2/copyright`, `/usr/share/doc/libext2fs2/copyright`, `/usr/share/doc/libss2/copyright`, `/usr/share/doc/logsave/copyright`)

- `GPL-2`
- `LGPL-2`

Source:

```console
$ apt-get source -qq --print-uris e2fsprogs=1.45.5-2ubuntu1.2
'http://archive.ubuntu.com/ubuntu/pool/main/e/e2fsprogs/e2fsprogs_1.45.5-2ubuntu1.2.dsc' e2fsprogs_1.45.5-2ubuntu1.2.dsc 3313 SHA512:b2637335d3247a54443d0967e994929adb52954277b1029a15292bc6fdc8db1ea00d5e2a6089c0b7a8419bfcff58cb60a6a7281d286265b4868d921d8daa0858
'http://archive.ubuntu.com/ubuntu/pool/main/e/e2fsprogs/e2fsprogs_1.45.5.orig.tar.gz' e2fsprogs_1.45.5.orig.tar.gz 7938826 SHA512:3ddb8d8aedfa68e1684d77e2bdd3cbbc16b2fbc633945a72ba617bea76c13253f3afa50655216a4071d787382272381b992cd6e7e3747780a5c3a64343158c98
'http://archive.ubuntu.com/ubuntu/pool/main/e/e2fsprogs/e2fsprogs_1.45.5.orig.tar.gz.asc' e2fsprogs_1.45.5.orig.tar.gz.asc 488 SHA512:1e3a19cf7943927c5e12ef3963a50af177e5627d9aa1c3eb081adb8e4671e46df3b6d512f6fcac002204d59b68716d94b04286d2cd85142a336c06bf28eaf3e1
'http://archive.ubuntu.com/ubuntu/pool/main/e/e2fsprogs/e2fsprogs_1.45.5-2ubuntu1.2.debian.tar.xz' e2fsprogs_1.45.5-2ubuntu1.2.debian.tar.xz 82932 SHA512:e038c9aa3af0593a6240840145b53742dbb2718dd58975e507b625eef3e341e5989ae0c7f02805a30ad213066af1cbfe8138f6baf500eedf66301dcb0966cb29
```

### `dpkg` source package: `el-api=3.0.0-2`

Binary Packages:

- `libel-api-java=3.0.0-2`

Licenses: (parsed from: `/usr/share/doc/libel-api-java/copyright`)

- `Apache-2.0`
- `CDDL-1.1`
- `GPL-2`
- `GPL-2 with Classpath exception`

Source:

```console
$ apt-get source -qq --print-uris el-api=3.0.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/e/el-api/el-api_3.0.0-2.dsc' el-api_3.0.0-2.dsc 2003 SHA256:4ffcf93fe27f152a0ff3f0cb5d2ea62bde4066cfe808d285fcd0a3a9e20a1a63
'http://archive.ubuntu.com/ubuntu/pool/universe/e/el-api/el-api_3.0.0.orig.tar.xz' el-api_3.0.0.orig.tar.xz 41460 SHA256:3af49a2a357102216ea6a0f2e58596d07509cb1ac92fea2b22b89d0a066785d5
'http://archive.ubuntu.com/ubuntu/pool/universe/e/el-api/el-api_3.0.0-2.debian.tar.xz' el-api_3.0.0-2.debian.tar.xz 8536 SHA256:f84e529f024dc992a2a9045aefb78aeec1329da033ca37a3f8319ccf2d9a621f
```

### `dpkg` source package: `elfutils=0.176-1.1ubuntu0.1`

Binary Packages:

- `libelf1:amd64=0.176-1.1ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libelf1/copyright`)

- `GPL-2`
- `GPL-3`
- `LGPL-`

Source:

```console
$ apt-get source -qq --print-uris elfutils=0.176-1.1ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/e/elfutils/elfutils_0.176-1.1ubuntu0.1.dsc' elfutils_0.176-1.1ubuntu0.1.dsc 2403 SHA512:45772c75e933aa73e323c9ccdc3423e9fe5b4da79715255edc26831ca74bf2e1e7f29c36786afd64c98f328157ddf12f0e38fb8c6f0a0f042156d028ef4f0330
'http://archive.ubuntu.com/ubuntu/pool/main/e/elfutils/elfutils_0.176.orig.tar.bz2' elfutils_0.176.orig.tar.bz2 8646075 SHA512:7f032913be363a43229ded85d495dcf7542b3c85974aaaba0d984228dc9ac1721da3dc388d3fa02325a80940161db7e9ad2c9e4521a424ad8a7d050c0902915b
'http://archive.ubuntu.com/ubuntu/pool/main/e/elfutils/elfutils_0.176.orig.tar.bz2.asc' elfutils_0.176.orig.tar.bz2.asc 455 SHA512:e123135d18dc9aa96b295200bd1c184d13bc94252417eb2d5e9e3f318892642d78ff19e17fa71947df955b1d3f56fdbd5ec4150c12de54d811c07b5ba3ff5a38
'http://archive.ubuntu.com/ubuntu/pool/main/e/elfutils/elfutils_0.176-1.1ubuntu0.1.debian.tar.xz' elfutils_0.176-1.1ubuntu0.1.debian.tar.xz 33216 SHA512:4c1bb3baf2b1b32cb7be3f5369d310d76b8e331118fac6c9b367e18994fd6ee3aae684691dd1287019a7e35c35b6e9e5f45f8176762266ccd5e98de0e618531a
```

### `dpkg` source package: `emacsen-common=3.0.4`

Binary Packages:

- `emacsen-common=3.0.4`

Licenses: (parsed from: `/usr/share/doc/emacsen-common/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris emacsen-common=3.0.4
'http://archive.ubuntu.com/ubuntu/pool/main/e/emacsen-common/emacsen-common_3.0.4.dsc' emacsen-common_3.0.4.dsc 1463 SHA256:4c8ee0308972bb43213f1efa68bcca1a90766a836b85f394c9e73fef4de9e83d
'http://archive.ubuntu.com/ubuntu/pool/main/e/emacsen-common/emacsen-common_3.0.4.tar.xz' emacsen-common_3.0.4.tar.xz 16292 SHA256:b20c7202b3553bbbe03290a61087ed10afa52edf407334ca8a7787ef0a876600
```

### `dpkg` source package: `expat=2.2.9-1ubuntu0.7`

Binary Packages:

- `libexpat1:amd64=2.2.9-1ubuntu0.7`

Licenses: (parsed from: `/usr/share/doc/libexpat1/copyright`)

- `MIT`

Source:

```console
$ apt-get source -qq --print-uris expat=2.2.9-1ubuntu0.7
'http://archive.ubuntu.com/ubuntu/pool/main/e/expat/expat_2.2.9-1ubuntu0.7.dsc' expat_2.2.9-1ubuntu0.7.dsc 1930 SHA512:ec51e762e3414d30e4b069b44e80297ef9fc5b1873356be296658ae3afe18cecf35105af5a44be2fe7cb878882c25a0b3cb6fe7dd1feee7ffe397c6c010fb69c
'http://archive.ubuntu.com/ubuntu/pool/main/e/expat/expat_2.2.9.orig.tar.gz' expat_2.2.9.orig.tar.gz 8273174 SHA512:e274fa7f30630450cb3ca681b266d765dbb7f5d00d1275ff9d9b2e2f6e1095893b8af4e3f4172ae6297c7a8a831a0a6becd484fe4bcdca09c37922f630780ef0
'http://archive.ubuntu.com/ubuntu/pool/main/e/expat/expat_2.2.9-1ubuntu0.7.debian.tar.xz' expat_2.2.9-1ubuntu0.7.debian.tar.xz 28840 SHA512:889eaabbb8fcfceaa3b1ee66c49d49388216bf10a4dc6be51bc2384bcdf1bd1c1bba7fb5b3d0a48192097fdb4275b8e3a01ec981d834398205fc3d5778c285c9
```

### `dpkg` source package: `ffmpeg=7:4.2.7-0ubuntu0.1`

Binary Packages:

- `ffmpeg=7:4.2.7-0ubuntu0.1`
- `libavcodec58:amd64=7:4.2.7-0ubuntu0.1`
- `libavdevice58:amd64=7:4.2.7-0ubuntu0.1`
- `libavfilter7:amd64=7:4.2.7-0ubuntu0.1`
- `libavformat58:amd64=7:4.2.7-0ubuntu0.1`
- `libavresample4:amd64=7:4.2.7-0ubuntu0.1`
- `libavutil56:amd64=7:4.2.7-0ubuntu0.1`
- `libpostproc55:amd64=7:4.2.7-0ubuntu0.1`
- `libswresample3:amd64=7:4.2.7-0ubuntu0.1`
- `libswscale5:amd64=7:4.2.7-0ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/ffmpeg/copyright`, `/usr/share/doc/libavcodec58/copyright`, `/usr/share/doc/libavdevice58/copyright`, `/usr/share/doc/libavfilter7/copyright`, `/usr/share/doc/libavformat58/copyright`, `/usr/share/doc/libavresample4/copyright`, `/usr/share/doc/libavutil56/copyright`, `/usr/share/doc/libpostproc55/copyright`, `/usr/share/doc/libswresample3/copyright`, `/usr/share/doc/libswscale5/copyright`)

- `BSD-1-clause`
- `BSD-2-clause`
- `BSD-3-clause`
- `BSL`
- `Expat`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with Avisynth exception`
- `GPL-3`
- `GPL-3+`
- `IJG`
- `ISC`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `Sundry`
- `Zlib`
- `man-page`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris ffmpeg=7:4.2.7-0ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/universe/f/ffmpeg/ffmpeg_4.2.7-0ubuntu0.1.dsc' ffmpeg_4.2.7-0ubuntu0.1.dsc 5344 SHA512:6229fa67e3d9daafc068647c02043e4f64c6d6bf486b69e1abd38c16c3c46b49aa535a4fb058bbc19856b19ab7c113d40ca3ea5948e72212258f2d7c6dedb0aa
'http://archive.ubuntu.com/ubuntu/pool/universe/f/ffmpeg/ffmpeg_4.2.7.orig.tar.xz' ffmpeg_4.2.7.orig.tar.xz 9114140 SHA512:54f57b26527ee55a5315dbd7955d73ee7d66ddc51ed19d2a22a3dda0f46de5333b25749deb172b7bed79920e25df34e1df1d058ffaead9d0cc9cd173f423ecea
'http://archive.ubuntu.com/ubuntu/pool/universe/f/ffmpeg/ffmpeg_4.2.7.orig.tar.xz.asc' ffmpeg_4.2.7.orig.tar.xz.asc 520 SHA512:6d0b81f7e77f830a694741cc1e110dc935ff3a6eb2b50d46e83723daea626ce404c3ce40b9379370a1aefab968a248f097c5c7c9091a080d6f1f989c3524661b
'http://archive.ubuntu.com/ubuntu/pool/universe/f/ffmpeg/ffmpeg_4.2.7-0ubuntu0.1.debian.tar.xz' ffmpeg_4.2.7-0ubuntu0.1.debian.tar.xz 51332 SHA512:2ea913e3450d878f99ed8a0d24b491a0fd73f9a898245caedec55140ae707b4e759d76550f98ed6d4ff18cfb8d79e316ee40d7c9ce6569219e24b5e16b62f90e
```

### `dpkg` source package: `fftw3=3.3.8-2ubuntu1`

Binary Packages:

- `libfftw3-double3:amd64=3.3.8-2ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libfftw3-double3/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris fftw3=3.3.8-2ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/f/fftw3/fftw3_3.3.8-2ubuntu1.dsc' fftw3_3.3.8-2ubuntu1.dsc 2240 SHA256:f33b0cba612104281fa3de2cdd38e8cedf8aa52a6e28146d9b162a2df11aff8e
'http://archive.ubuntu.com/ubuntu/pool/main/f/fftw3/fftw3_3.3.8.orig.tar.gz' fftw3_3.3.8.orig.tar.gz 4110137 SHA256:6113262f6e92c5bd474f2875fa1b01054c4ad5040f6b0da7c03c98821d9ae303
'http://archive.ubuntu.com/ubuntu/pool/main/f/fftw3/fftw3_3.3.8-2ubuntu1.debian.tar.xz' fftw3_3.3.8-2ubuntu1.debian.tar.xz 14028 SHA256:8bc469ad07cef4ebb1c512feecc061ba58eb851d83f67f732d42bc7db0a4f89b
```

### `dpkg` source package: `file=1:5.38-4`

Binary Packages:

- `file=1:5.38-4`
- `libmagic-mgc=1:5.38-4`
- `libmagic1:amd64=1:5.38-4`

Licenses: (parsed from: `/usr/share/doc/file/copyright`, `/usr/share/doc/libmagic-mgc/copyright`, `/usr/share/doc/libmagic1/copyright`)

- `BSD-2-Clause-alike`
- `BSD-2-Clause-netbsd`
- `BSD-2-Clause-regents`
- `MIT-Old-Style-with-legal-disclaimer-2`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris file=1:5.38-4
'http://archive.ubuntu.com/ubuntu/pool/main/f/file/file_5.38-4.dsc' file_5.38-4.dsc 2237 SHA256:d84b2734b112384230e3678beb1c8c5d3a17d4cdec8b6ef21304f2c0b72fda26
'http://archive.ubuntu.com/ubuntu/pool/main/f/file/file_5.38.orig.tar.gz' file_5.38.orig.tar.gz 932528 SHA256:593c2ffc2ab349c5aea0f55fedfe4d681737b6b62376a9b3ad1e77b2cc19fa34
'http://archive.ubuntu.com/ubuntu/pool/main/f/file/file_5.38.orig.tar.gz.asc' file_5.38.orig.tar.gz.asc 169 SHA256:b9c78e39970abda091ec8752401f5241349cef4709a2e1267a378f7ab25115d8
'http://archive.ubuntu.com/ubuntu/pool/main/f/file/file_5.38-4.debian.tar.xz' file_5.38-4.debian.tar.xz 34488 SHA256:b9dfd0dd070ee17a6cc69ecf4d61c329b3f567ca16fdc121f3b31d0111df9381
```

### `dpkg` source package: `findutils=4.7.0-1ubuntu1`

Binary Packages:

- `findutils=4.7.0-1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/findutils/copyright`)

- `GFDL-1.3`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris findutils=4.7.0-1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/f/findutils/findutils_4.7.0-1ubuntu1.dsc' findutils_4.7.0-1ubuntu1.dsc 2446 SHA256:3d157948919082e66cb74e0f927efa3dd240d9fa9814973874d0fa77f3023ead
'http://archive.ubuntu.com/ubuntu/pool/main/f/findutils/findutils_4.7.0.orig.tar.xz' findutils_4.7.0.orig.tar.xz 1895048 SHA256:c5fefbdf9858f7e4feb86f036e1247a54c79fc2d8e4b7064d5aaa1f47dfa789a
'http://archive.ubuntu.com/ubuntu/pool/main/f/findutils/findutils_4.7.0.orig.tar.xz.asc' findutils_4.7.0.orig.tar.xz.asc 488 SHA256:2f620e6d941e241fac52344a89149ab1ffeefb0fb9e42174e17a508d59a31d0f
'http://archive.ubuntu.com/ubuntu/pool/main/f/findutils/findutils_4.7.0-1ubuntu1.debian.tar.xz' findutils_4.7.0-1ubuntu1.debian.tar.xz 27700 SHA256:dfb2329fd141384c2d76409c2e99f164cc25954115529245d80d5d41e3167731
```

### `dpkg` source package: `firebird3.0=3.0.5.33220.ds4-1build2`

Binary Packages:

- `firebird3.0-common=3.0.5.33220.ds4-1build2`
- `firebird3.0-common-doc=3.0.5.33220.ds4-1build2`
- `firebird3.0-server-core:amd64=3.0.5.33220.ds4-1build2`
- `firebird3.0-utils=3.0.5.33220.ds4-1build2`
- `libfbclient2:amd64=3.0.5.33220.ds4-1build2`
- `libib-util:amd64=3.0.5.33220.ds4-1build2`

Licenses: (parsed from: `/usr/share/doc/firebird3.0-common/copyright`, `/usr/share/doc/firebird3.0-common-doc/copyright`, `/usr/share/doc/firebird3.0-server-core/copyright`, `/usr/share/doc/firebird3.0-utils/copyright`, `/usr/share/doc/libfbclient2/copyright`, `/usr/share/doc/libib-util/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-3`
- `GPL-3+ with autoconf exception`
- `IDPL-1.0`
- `IPL-1.0`
- `LGPL-2.1`
- `LGPL-2.1 with OSI exception`
- `MPL-1.1`
- `MPL-1.1-or-GPL-2+`
- `bsd-like`
- `other`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris firebird3.0=3.0.5.33220.ds4-1build2
'http://archive.ubuntu.com/ubuntu/pool/universe/f/firebird3.0/firebird3.0_3.0.5.33220.ds4-1build2.dsc' firebird3.0_3.0.5.33220.ds4-1build2.dsc 2794 SHA256:598181e8bebc7140fe7848b0f08404c41aae59fd47db3e1e94ef4f5f2f659d59
'http://archive.ubuntu.com/ubuntu/pool/universe/f/firebird3.0/firebird3.0_3.0.5.33220.ds4.orig.tar.xz' firebird3.0_3.0.5.33220.ds4.orig.tar.xz 3386476 SHA256:14327890beed418d910ee46d093b584458179adf4ad2f423871dda7261ae65c3
'http://archive.ubuntu.com/ubuntu/pool/universe/f/firebird3.0/firebird3.0_3.0.5.33220.ds4-1build2.debian.tar.xz' firebird3.0_3.0.5.33220.ds4-1build2.debian.tar.xz 101156 SHA256:1bf076e2274fd105109bf6d24a949981c76b4b11c2541596c6a919e9ef71f68f
```

### `dpkg` source package: `flac=1.3.3-1ubuntu0.2`

Binary Packages:

- `libflac8:amd64=1.3.3-1ubuntu0.2`

Licenses: (parsed from: `/usr/share/doc/libflac8/copyright`)

- `BSD-3-clause`
- `GFDL-1.1+`
- `GFDL-1.2`
- `GPL-2`
- `GPL-2+`
- `ISC`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `Public-domain`

Source:

```console
$ apt-get source -qq --print-uris flac=1.3.3-1ubuntu0.2
'http://archive.ubuntu.com/ubuntu/pool/main/f/flac/flac_1.3.3-1ubuntu0.2.dsc' flac_1.3.3-1ubuntu0.2.dsc 2355 SHA512:3dc5b2b62e5e5d69a9b18ad458816ab7e798d2b36a7d56430c618e2c04f135bcba9b2ce8f59802c01a97f19d6eb3fdbf704782b60fa1bbe3518cdf39e1c93801
'http://archive.ubuntu.com/ubuntu/pool/main/f/flac/flac_1.3.3.orig.tar.xz' flac_1.3.3.orig.tar.xz 1044472 SHA512:d6417e14fab0c41b2df369e5e39ce62a5f588e491af4d465b0162f74e171e5549b2f061867f344bfbf8aaccd246bf5f2acd697e532a2c7901c920c69429b1a28
'http://archive.ubuntu.com/ubuntu/pool/main/f/flac/flac_1.3.3-1ubuntu0.2.debian.tar.xz' flac_1.3.3-1ubuntu0.2.debian.tar.xz 19952 SHA512:008d4af23c3e0da880f705be0920ef0602311d062b6de4d4a211908bad2c5c99e0f415ac225c33d8283b350eaf214855584ddc1ca03264e6b76a9f93e4180a4c
```

### `dpkg` source package: `flite=2.1-release-3`

Binary Packages:

- `libflite1:amd64=2.1-release-3`

Licenses: (parsed from: `/usr/share/doc/libflite1/copyright`)

- `GPL-2`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris flite=2.1-release-3
'http://archive.ubuntu.com/ubuntu/pool/universe/f/flite/flite_2.1-release-3.dsc' flite_2.1-release-3.dsc 2246 SHA256:3b5c97f6b3c8ff983d1fa76cb9e31e32179c4acc82a8b104a859f69348200489
'http://archive.ubuntu.com/ubuntu/pool/universe/f/flite/flite_2.1-release.orig.tar.bz2' flite_2.1-release.orig.tar.bz2 14816327 SHA256:c73c3f6a2ea764977d6eaf0a287722d1e2066b4697088c552e342c790f3d2b85
'http://archive.ubuntu.com/ubuntu/pool/universe/f/flite/flite_2.1-release-3.debian.tar.xz' flite_2.1-release-3.debian.tar.xz 48480 SHA256:c6dc054e21a06453026e3c9a80a20317eed206f5a055a38e853c32e666961f5c
```

### `dpkg` source package: `fontconfig=2.13.1-2ubuntu3`

Binary Packages:

- `fontconfig=2.13.1-2ubuntu3`
- `fontconfig-config=2.13.1-2ubuntu3`
- `libfontconfig1:amd64=2.13.1-2ubuntu3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris fontconfig=2.13.1-2ubuntu3
'http://archive.ubuntu.com/ubuntu/pool/main/f/fontconfig/fontconfig_2.13.1-2ubuntu3.dsc' fontconfig_2.13.1-2ubuntu3.dsc 1959 SHA256:a9eebf6e6e88aa64d33fb3852c97718c212579f9714afd67cb6a9b8b116dd7aa
'http://archive.ubuntu.com/ubuntu/pool/main/f/fontconfig/fontconfig_2.13.1.orig.tar.bz2' fontconfig_2.13.1.orig.tar.bz2 1723639 SHA256:f655dd2a986d7aa97e052261b36aa67b0a64989496361eca8d604e6414006741
'http://archive.ubuntu.com/ubuntu/pool/main/f/fontconfig/fontconfig_2.13.1-2ubuntu3.debian.tar.xz' fontconfig_2.13.1-2ubuntu3.debian.tar.xz 26344 SHA256:342671f6a1e6d392958a6eec27541c6bdffc6498b469dcc46eca66c9d23a863a
```

### `dpkg` source package: `fonts-android=1:6.0.1r16-1.1`

Binary Packages:

- `fonts-droid-fallback=1:6.0.1r16-1.1`

Licenses: (parsed from: `/usr/share/doc/fonts-droid-fallback/copyright`)

- `Apache-2`
- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris fonts-android=1:6.0.1r16-1.1
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-android/fonts-android_6.0.1r16-1.1.dsc' fonts-android_6.0.1r16-1.1.dsc 2182 SHA256:17cf1a74074c63cd5d0cc03d81d780ecd0fcb1d8d2ab1bdafb0b6dd30c278500
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-android/fonts-android_6.0.1r16.orig.tar.gz' fonts-android_6.0.1r16.orig.tar.gz 6759063 SHA256:7f14d7b3f3ab0c7258aa7edac4ea1071cb2f22c5820c4eb617095de2ef90d4d8
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-android/fonts-android_6.0.1r16-1.1.debian.tar.xz' fonts-android_6.0.1r16-1.1.debian.tar.xz 6880 SHA256:6beeb5dfb083b73753382d2ca46faaa976c39ca6365dd33f08106d077c525b29
```

### `dpkg` source package: `fonts-crosextra-caladea=20130214-2`

Binary Packages:

- `fonts-crosextra-caladea=20130214-2`

Licenses: (parsed from: `/usr/share/doc/fonts-crosextra-caladea/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris fonts-crosextra-caladea=20130214-2
'http://archive.ubuntu.com/ubuntu/pool/universe/f/fonts-crosextra-caladea/fonts-crosextra-caladea_20130214-2.dsc' fonts-crosextra-caladea_20130214-2.dsc 2159 SHA256:199586f82712aa579daa428e049d3f4a747712a34ce9d8ebcf22c27072ce3252
'http://archive.ubuntu.com/ubuntu/pool/universe/f/fonts-crosextra-caladea/fonts-crosextra-caladea_20130214.orig.tar.gz' fonts-crosextra-caladea_20130214.orig.tar.gz 112756 SHA256:c48d1c2fd613c9c06c959c34da7b8388059e2408d2bb19845dc3ed35f76e4d09
'http://archive.ubuntu.com/ubuntu/pool/universe/f/fonts-crosextra-caladea/fonts-crosextra-caladea_20130214-2.debian.tar.xz' fonts-crosextra-caladea_20130214-2.debian.tar.xz 2504 SHA256:df38b095635456c3979c19e81e28c656e56675b138e4b989c25bb08b2e2eac11
```

### `dpkg` source package: `fonts-crosextra-carlito=20130920-1`

Binary Packages:

- `fonts-crosextra-carlito=20130920-1`

Licenses: (parsed from: `/usr/share/doc/fonts-crosextra-carlito/copyright`)

- `GPL-2`
- `GPL-2+`
- `OFL-1.1`

Source:

```console
$ apt-get source -qq --print-uris fonts-crosextra-carlito=20130920-1
'http://archive.ubuntu.com/ubuntu/pool/universe/f/fonts-crosextra-carlito/fonts-crosextra-carlito_20130920-1.dsc' fonts-crosextra-carlito_20130920-1.dsc 2137 SHA256:53be1d931294feafcee69fb3b4dd47b62d80d1cc3d42057e007dc4c681ef9e06
'http://archive.ubuntu.com/ubuntu/pool/universe/f/fonts-crosextra-carlito/fonts-crosextra-carlito_20130920.orig.tar.gz' fonts-crosextra-carlito_20130920.orig.tar.gz 1169488 SHA256:4bd12b6cbc321c1cf16da76e2c585c925ce956a08067ae6f6c64eff6ccfdaf5a
'http://archive.ubuntu.com/ubuntu/pool/universe/f/fonts-crosextra-carlito/fonts-crosextra-carlito_20130920-1.debian.tar.gz' fonts-crosextra-carlito_20130920-1.debian.tar.gz 4426 SHA256:cd2dcd85536b873a7f3e5c034efa55b93ed5e1c2e102951ce067042ac7863b38
```

### `dpkg` source package: `fonts-dejavu=2.37-1`

Binary Packages:

- `fonts-dejavu=2.37-1`
- `fonts-dejavu-core=2.37-1`
- `fonts-dejavu-extra=2.37-1`

Licenses: (parsed from: `/usr/share/doc/fonts-dejavu/copyright`, `/usr/share/doc/fonts-dejavu-core/copyright`, `/usr/share/doc/fonts-dejavu-extra/copyright`)

- `GPL-2`
- `GPL-2+`
- `bitstream-vera`

Source:

```console
$ apt-get source -qq --print-uris fonts-dejavu=2.37-1
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-dejavu/fonts-dejavu_2.37-1.dsc' fonts-dejavu_2.37-1.dsc 2575 SHA256:f35ff7b2c8dbfda6564c9dedf088ba06cc6d279fdd8e7cccbd1ae08ded1bb71c
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-dejavu/fonts-dejavu_2.37.orig.tar.bz2' fonts-dejavu_2.37.orig.tar.bz2 12050109 SHA256:4b21c5203f792343d5e90ab1cb0cf07e99887218abe3d83cd9a98cea9085e799
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-dejavu/fonts-dejavu_2.37-1.debian.tar.xz' fonts-dejavu_2.37-1.debian.tar.xz 10424 SHA256:5105cdbfc086f4a83ab6871eb39cc904bf02aa52762402b7cacf33d0938122f7
```

### `dpkg` source package: `fonts-liberation2=2.1.0-1`

Binary Packages:

- `fonts-liberation2=2.1.0-1`

Licenses: (parsed from: `/usr/share/doc/fonts-liberation2/copyright`)

- `GPL-2`
- `GPL-2+`
- `SIL-OFL-1.1`

Source:

```console
$ apt-get source -qq --print-uris fonts-liberation2=2.1.0-1
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-liberation2/fonts-liberation2_2.1.0-1.dsc' fonts-liberation2_2.1.0-1.dsc 2222 SHA256:ebfe5d369f83f6bf22edb3d8d4907450e2366509a8966ecb84303fe78690eb3e
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-liberation2/fonts-liberation2_2.1.0.orig.tar.gz' fonts-liberation2_2.1.0.orig.tar.gz 4986277 SHA256:a7761e42b43dfd0b4580f411829062ef98a6de6c2bafe0bfaf3041eb057d9107
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-liberation2/fonts-liberation2_2.1.0-1.debian.tar.xz' fonts-liberation2_2.1.0-1.debian.tar.xz 7456 SHA256:57291e9eb7ad8c579e80f9da502ca9b3a21d518f85b9ad1fc24959b45b487cad
```

### `dpkg` source package: `fonts-liberation=1:1.07.4-11`

Binary Packages:

- `fonts-liberation=1:1.07.4-11`

Licenses: (parsed from: `/usr/share/doc/fonts-liberation/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris fonts-liberation=1:1.07.4-11
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-liberation/fonts-liberation_1.07.4-11.dsc' fonts-liberation_1.07.4-11.dsc 2176 SHA256:c9cb6abc8b8ab1887d78f5fc1aef1fc06a220efbfa3424ca7e8bc379242654ba
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-liberation/fonts-liberation_1.07.4.orig.tar.gz' fonts-liberation_1.07.4.orig.tar.gz 2937949 SHA256:ad98b7498dc2992f7f0868f79b65ce4a720a3acdb63ab3f1f1cb6881117a5406
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-liberation/fonts-liberation_1.07.4-11.debian.tar.xz' fonts-liberation_1.07.4-11.debian.tar.xz 17248 SHA256:45ea32aab7eed82061493edbf5ef621d6fd7f074cb79ae45206014913ca5f313
```

### `dpkg` source package: `fonts-linuxlibertine=5.3.0-4`

Binary Packages:

- `fonts-linuxlibertine=5.3.0-4`

Licenses: (parsed from: `/usr/share/doc/fonts-linuxlibertine/copyright`)

- `GPL-2`
- `GPL-2+`
- `GPL-2+ with Font exception`
- `OFL-1.1`

Source:

```console
$ apt-get source -qq --print-uris fonts-linuxlibertine=5.3.0-4
'http://archive.ubuntu.com/ubuntu/pool/universe/f/fonts-linuxlibertine/fonts-linuxlibertine_5.3.0-4.dsc' fonts-linuxlibertine_5.3.0-4.dsc 2113 SHA256:127569684fe5ab96f2294dedb7425097a410abd31aac3e2e58b54b6fdcc9abab
'http://archive.ubuntu.com/ubuntu/pool/universe/f/fonts-linuxlibertine/fonts-linuxlibertine_5.3.0.orig.tar.xz' fonts-linuxlibertine_5.3.0.orig.tar.xz 3748996 SHA256:9226823829273175c38ab84c4991d61ceaeded7c6ce50a2bab061d14e441a2a7
'http://archive.ubuntu.com/ubuntu/pool/universe/f/fonts-linuxlibertine/fonts-linuxlibertine_5.3.0-4.debian.tar.xz' fonts-linuxlibertine_5.3.0-4.debian.tar.xz 8764 SHA256:d7eb3eac6641411f55578ec8ca02f0da6c76f03dadf3a7cbe1784448ccce2d6f
```

### `dpkg` source package: `fonts-noto=20200323-1build1~ubuntu20.04.1`

Binary Packages:

- `fonts-noto-core=20200323-1build1~ubuntu20.04.1`
- `fonts-noto-extra=20200323-1build1~ubuntu20.04.1`
- `fonts-noto-mono=20200323-1build1~ubuntu20.04.1`
- `fonts-noto-ui-core=20200323-1build1~ubuntu20.04.1`

Licenses: (parsed from: `/usr/share/doc/fonts-noto-core/copyright`, `/usr/share/doc/fonts-noto-extra/copyright`, `/usr/share/doc/fonts-noto-mono/copyright`, `/usr/share/doc/fonts-noto-ui-core/copyright`)

- `Apache-2.0`
- `GPL-3`
- `GPL-3+`
- `OFL-1.1`

Source:

```console
$ apt-get source -qq --print-uris fonts-noto=20200323-1build1~ubuntu20.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-noto/fonts-noto_20200323-1build1%7eubuntu20.04.1.dsc' fonts-noto_20200323-1build1~ubuntu20.04.1.dsc 2564 SHA512:f5b486186a324f0ce24564ef7853a475f6bc431b7bd6bb6ae9d699f22442cf16cfb64e0cd81caa134ceef25e4ea16276597c480cffa8f1a3a6792b7441c9257a
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-noto/fonts-noto_20200323.orig.tar.gz' fonts-noto_20200323.orig.tar.gz 854165462 SHA512:1611fb2e93cf2227a3270c323ecb99fb87135fdfbd27dbb8595465279cdae8744f57774f9804cd01b064d63e7bcfbfe986212084dae546739b8f341442056ef6
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-noto/fonts-noto_20200323-1build1%7eubuntu20.04.1.debian.tar.xz' fonts-noto_20200323-1build1~ubuntu20.04.1.debian.tar.xz 110420 SHA512:320c3f90724958a09defa7da4dc399976ad0b98c795328166c3198d8e37a9e570169befc83561a7636a9284a9cb87a0b319ae215929c82c991559b88cfa77e31
```

### `dpkg` source package: `fonts-sil-gentium-basic=1.102-1`

Binary Packages:

- `fonts-sil-gentium-basic=1.102-1`

Licenses: (parsed from: `/usr/share/doc/fonts-sil-gentium-basic/copyright`)

- `OFL-1.1`

Source:

```console
$ apt-get source -qq --print-uris fonts-sil-gentium-basic=1.102-1
'http://archive.ubuntu.com/ubuntu/pool/universe/f/fonts-sil-gentium-basic/fonts-sil-gentium-basic_1.102-1.dsc' fonts-sil-gentium-basic_1.102-1.dsc 2160 SHA256:246df276386d08b62316341e820787a45d2e796f150221f3ddc623633c71b304
'http://archive.ubuntu.com/ubuntu/pool/universe/f/fonts-sil-gentium-basic/fonts-sil-gentium-basic_1.102.orig.tar.xz' fonts-sil-gentium-basic_1.102.orig.tar.xz 380396 SHA256:a7c89371d71ee45a7c12072df75c0ef790674e39fdde747b46d6e4cfb2219f7d
'http://archive.ubuntu.com/ubuntu/pool/universe/f/fonts-sil-gentium-basic/fonts-sil-gentium-basic_1.102-1.debian.tar.xz' fonts-sil-gentium-basic_1.102-1.debian.tar.xz 5184 SHA256:ff836606909f0cc9afc06efde1e7657770f13a779e890b06897b2f599eb00d3b
```

### `dpkg` source package: `fonts-sil-gentium=20081126:1.03-2`

Binary Packages:

- `fonts-sil-gentium=20081126:1.03-2`

Licenses: (parsed from: `/usr/share/doc/fonts-sil-gentium/copyright`)

- `OFL-1.1`

Source:

```console
$ apt-get source -qq --print-uris fonts-sil-gentium=20081126:1.03-2
'http://archive.ubuntu.com/ubuntu/pool/universe/f/fonts-sil-gentium/fonts-sil-gentium_1.03-2.dsc' fonts-sil-gentium_1.03-2.dsc 2107 SHA256:d75b0fded4ab6aa63bd7adec8accdcf78e117274d251709f58ed6b2b3b60f301
'http://archive.ubuntu.com/ubuntu/pool/universe/f/fonts-sil-gentium/fonts-sil-gentium_1.03.orig.tar.xz' fonts-sil-gentium_1.03.orig.tar.xz 428764 SHA256:0754edaec5837f899caf9248496438cf5adc5f2795ee36ac19e49f08bdfd751c
'http://archive.ubuntu.com/ubuntu/pool/universe/f/fonts-sil-gentium/fonts-sil-gentium_1.03-2.debian.tar.xz' fonts-sil-gentium_1.03-2.debian.tar.xz 6528 SHA256:e1b49eb3e9c2a210309b7a6177d83e99b851ed1d1cd60ccd5c9af329b880dbf9
```

### `dpkg` source package: `fonts-urw-base35=20170801.1-3`

Binary Packages:

- `fonts-urw-base35=20170801.1-3`

Licenses: (parsed from: `/usr/share/doc/fonts-urw-base35/copyright`)

- `AGPL-3`
- `AGPL-3 with Font exception`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris fonts-urw-base35=20170801.1-3
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-urw-base35/fonts-urw-base35_20170801.1-3.dsc' fonts-urw-base35_20170801.1-3.dsc 2075 SHA256:6022f3e2e1e1c2504ee7b7565ed2f2682441db90cd15653abbfa8b963de05949
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-urw-base35/fonts-urw-base35_20170801.1.orig.tar.gz' fonts-urw-base35_20170801.1.orig.tar.gz 11147338 SHA256:874da009413a9a69175e3a42eb707352e7a1a66ed77868139761f6face220c41
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-urw-base35/fonts-urw-base35_20170801.1-3.debian.tar.xz' fonts-urw-base35_20170801.1-3.debian.tar.xz 17728 SHA256:d96fed0783c169f44c57e9c8b0e10f3846deae3a130b580664880172244c9c76
```

### `dpkg` source package: `freetype=2.10.1-2ubuntu0.3`

Binary Packages:

- `libfreetype6:amd64=2.10.1-2ubuntu0.3`

Licenses: (parsed from: `/usr/share/doc/libfreetype6/copyright`)

- `Apache-2.0`
- `BSD-3-Clause`
- `FSFUL`
- `FSFULLR`
- `FTL`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `MIT`
- `MPL-1.1`
- `OFL-1.1`
- `OpenGroup-BSD-like`
- `Permissive`
- `Public-Domain`
- `Zlib`

Source:

```console
$ apt-get source -qq --print-uris freetype=2.10.1-2ubuntu0.3
'http://archive.ubuntu.com/ubuntu/pool/main/f/freetype/freetype_2.10.1-2ubuntu0.3.dsc' freetype_2.10.1-2ubuntu0.3.dsc 3864 SHA512:5f173384e4b9cc98ebd357bf87499c5435cdb59c0890f20bc2b0c4f72eece0977e68f20c2596426658ab6ea01762e91ea1dee14af1e781ddd0f3b668f01a88ac
'http://archive.ubuntu.com/ubuntu/pool/main/f/freetype/freetype_2.10.1.orig-ft2demos.tar.gz' freetype_2.10.1.orig-ft2demos.tar.gz 305328 SHA512:67b9dc1c03ca5588a53edd8b9cb7f27e5b52a5730add6887e6af776176ab66099bfe4a9e69d036511d32ae2f96e822a71a3c9213f1adfcc6fa45be81adf56f77
'http://archive.ubuntu.com/ubuntu/pool/main/f/freetype/freetype_2.10.1.orig-ft2demos.tar.gz.asc' freetype_2.10.1.orig-ft2demos.tar.gz.asc 195 SHA512:8279e9e7ea4da030db388ac5960808d652553b97dc65bc517ebcae90834188d75101fbe29d334a0e2b0a17a723c7121ac28b1f14bab0bf29ec4c9c6df6575a67
'http://archive.ubuntu.com/ubuntu/pool/main/f/freetype/freetype_2.10.1.orig-ft2docs.tar.gz' freetype_2.10.1.orig-ft2docs.tar.gz 2123885 SHA512:05dbe26c291d3fa39c167f3aa5d8da0f3d3992f8e7ec74e936547b3feb17c1a59753a111fc33b2edce12ed991c61161c0ef7084b91c770d73c4679b62edd5b2f
'http://archive.ubuntu.com/ubuntu/pool/main/f/freetype/freetype_2.10.1.orig-ft2docs.tar.gz.asc' freetype_2.10.1.orig-ft2docs.tar.gz.asc 195 SHA512:48e283c72d808901b9754bb20242d493628610326f3492c6d1aa35fcdffffd4ec320f589d18442735cfc6cda7238399f4f339d58e4a536da46e2b5a13864972e
'http://archive.ubuntu.com/ubuntu/pool/main/f/freetype/freetype_2.10.1.orig.tar.gz' freetype_2.10.1.orig.tar.gz 3478158 SHA512:346c682744bcf06ca9d71265c108a242ad7d78443eff20142454b72eef47ba6d76671a6e931ed4c4c9091dd8f8515ebdd71202d94b073d77931345ff93cfeaa7
'http://archive.ubuntu.com/ubuntu/pool/main/f/freetype/freetype_2.10.1.orig.tar.gz.asc' freetype_2.10.1.orig.tar.gz.asc 195 SHA512:2a2750605d0fd11fbfe4f76d47ccd8e300473c3043b28a5c46f4f628e1da2c2f2308ee4f1b1b585daaf2c4b408718ee68eab6c5411e993ad9f95b08c35248178
'http://archive.ubuntu.com/ubuntu/pool/main/f/freetype/freetype_2.10.1-2ubuntu0.3.debian.tar.xz' freetype_2.10.1-2ubuntu0.3.debian.tar.xz 116976 SHA512:204fc0955f3b65aa2dd372e9b408b92e22cf50e30c39e52cb031bebab0fc286630338c14769e42a5b6a3a9552a67e044ca9e9b1b43fee1c1eb0e6e86836f9ebd
```

### `dpkg` source package: `fribidi=1.0.8-2ubuntu0.1`

Binary Packages:

- `libfribidi0:amd64=1.0.8-2ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libfribidi0/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris fribidi=1.0.8-2ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/f/fribidi/fribidi_1.0.8-2ubuntu0.1.dsc' fribidi_1.0.8-2ubuntu0.1.dsc 2442 SHA512:f9047bc07f608d08ed75aa3a548a15123340b97b4841a1e5904dce11e713aef3df5b3399817d8fcfd77e342b0afe6e99dfe64bb86acd5b7eedd633da347ef869
'http://archive.ubuntu.com/ubuntu/pool/main/f/fribidi/fribidi_1.0.8.orig.tar.bz2' fribidi_1.0.8.orig.tar.bz2 2077095 SHA512:d66b1524b26d227fd6a628f438efb875c023ae3be708acaaad11f1f62d0902de0a5f57124458291ef2b0fcd89356c52ab8ae5559b0b5a93fa435b92f1d098ba2
'http://archive.ubuntu.com/ubuntu/pool/main/f/fribidi/fribidi_1.0.8-2ubuntu0.1.debian.tar.xz' fribidi_1.0.8-2ubuntu0.1.debian.tar.xz 10612 SHA512:2ad4f0c140d303f5d79ec5bba1b7211fac398768f0a07f47e0ad8d9844d61cc38c31daafaa9378a1dae9bec66917d7d46b15d1aaab34d3b15a738632fdf15feb
```

### `dpkg` source package: `game-music-emu=0.6.2-1build1`

Binary Packages:

- `libgme0:amd64=0.6.2-1build1`

Licenses: (parsed from: `/usr/share/doc/libgme0/copyright`)

- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris game-music-emu=0.6.2-1build1
'http://archive.ubuntu.com/ubuntu/pool/universe/g/game-music-emu/game-music-emu_0.6.2-1build1.dsc' game-music-emu_0.6.2-1build1.dsc 1900 SHA256:f1e2f34b75e67c2fbe6412441d8d34ba7999cdbda2cbf9410d741c0e85bb3e93
'http://archive.ubuntu.com/ubuntu/pool/universe/g/game-music-emu/game-music-emu_0.6.2.orig.tar.xz' game-music-emu_0.6.2.orig.tar.xz 163052 SHA256:5046cb471d422dbe948b5f5dd4e5552aaef52a0899c4b2688e5a68a556af7342
'http://archive.ubuntu.com/ubuntu/pool/universe/g/game-music-emu/game-music-emu_0.6.2-1build1.debian.tar.xz' game-music-emu_0.6.2-1build1.debian.tar.xz 4496 SHA256:e338369a1656f0ade5b014f714fd5bac196489ac937cf8c5276a005953b92aa8
```

### `dpkg` source package: `gcc-10=10.5.0-1ubuntu1~20.04`

Binary Packages:

- `gcc-10-base:amd64=10.5.0-1ubuntu1~20.04`
- `libgcc-s1:amd64=10.5.0-1ubuntu1~20.04`
- `libgomp1:amd64=10.5.0-1ubuntu1~20.04`
- `libstdc++6:amd64=10.5.0-1ubuntu1~20.04`

Licenses: (parsed from: `/usr/share/doc/gcc-10-base/copyright`, `/usr/share/doc/libgcc-s1/copyright`, `/usr/share/doc/libgomp1/copyright`, `/usr/share/doc/libstdc++6/copyright`)

- `Artistic`
- `GFDL-1.2`
- `GPL`
- `GPL-2`
- `GPL-3`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris gcc-10=10.5.0-1ubuntu1~20.04
'http://archive.ubuntu.com/ubuntu/pool/main/g/gcc-10/gcc-10_10.5.0-1ubuntu1%7e20.04.dsc' gcc-10_10.5.0-1ubuntu1~20.04.dsc 31130 SHA512:0adfb92474d09348ce0ef4a4a3edd143a054d2bcba01dbdf29f925066ecc6e4874a02d7ced1501d39c1e966a1b0f3b9bef6ddcc8181df9b77206cefedcef6f15
'http://archive.ubuntu.com/ubuntu/pool/main/g/gcc-10/gcc-10_10.5.0.orig.tar.gz' gcc-10_10.5.0.orig.tar.gz 84203753 SHA512:0617b7353e3da37e30abecb3527a987bb444a57e2f18a1265f9b727b5f43a40068d7242f8ce92fe47810e883778c13a0c54c5126071a5c6abd786c02919f5c81
'http://archive.ubuntu.com/ubuntu/pool/main/g/gcc-10/gcc-10_10.5.0-1ubuntu1%7e20.04.debian.tar.xz' gcc-10_10.5.0-1ubuntu1~20.04.debian.tar.xz 5953836 SHA512:d68b8b10628bec39c370c9af1baa39bd76f3fb885d765b2d449435981ab772443187cba3bcb629e69a4a7c4b1e890babc4ea9ed8a3a3eb9a8e7e1e76abb8b526
```

### `dpkg` source package: `gcc-9=9.4.0-1ubuntu1~20.04.2`

Binary Packages:

- `cpp-9=9.4.0-1ubuntu1~20.04.2`
- `gcc-9-base:amd64=9.4.0-1ubuntu1~20.04.2`

Licenses: (parsed from: `/usr/share/doc/cpp-9/copyright`, `/usr/share/doc/gcc-9-base/copyright`)

- `Artistic`
- `GFDL-1.2`
- `GPL`
- `GPL-2`
- `GPL-3`
- `LGPL`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris gcc-9=9.4.0-1ubuntu1~20.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/g/gcc-9/gcc-9_9.4.0-1ubuntu1%7e20.04.2.dsc' gcc-9_9.4.0-1ubuntu1~20.04.2.dsc 23760 SHA512:76d09db3de4bf585143b73bbfe9f46c66f9e00da33b08cb62cf95b70d21a704f95df61725527edb514c87356cc13ee4a2e2bb21b66f468469ace0d4893da0c34
'http://archive.ubuntu.com/ubuntu/pool/main/g/gcc-9/gcc-9_9.4.0.orig.tar.gz' gcc-9_9.4.0.orig.tar.gz 92368536 SHA512:c10390524e900d3f0afd4516af097f536304fb2946ecf73eaba0472b953609ce8fbb5c7f0c20af9e54fe38fc8f45ec3b6ebd2051fa67225c73efa8362150c1c6
'http://archive.ubuntu.com/ubuntu/pool/main/g/gcc-9/gcc-9_9.4.0-1ubuntu1%7e20.04.2.debian.tar.xz' gcc-9_9.4.0-1ubuntu1~20.04.2.debian.tar.xz 579772 SHA512:4f23eb26adf795d2794c7ef083caa0a0f73dd9d8e3e809139df9595f4ef29012a6c7a5b158441900d1a55f7bb6d80ea68d0bc422f0a18d9573df9db04b30945f
```

### `dpkg` source package: `gcc-defaults=1.185.1ubuntu2`

Binary Packages:

- `cpp=4:9.3.0-1ubuntu2`

Licenses: (parsed from: `/usr/share/doc/cpp/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris gcc-defaults=1.185.1ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/g/gcc-defaults/gcc-defaults_1.185.1ubuntu2.dsc' gcc-defaults_1.185.1ubuntu2.dsc 16544 SHA256:32c0331bc75ecbc0d013b9e11401d1fc64cbd7b0198274cb25a183a27b5c407f
'http://archive.ubuntu.com/ubuntu/pool/main/g/gcc-defaults/gcc-defaults_1.185.1ubuntu2.tar.gz' gcc-defaults_1.185.1ubuntu2.tar.gz 58807 SHA256:342b5842c03073717bc98d6d9de7eb79027a1239735637743006933e5d44bb05
```

### `dpkg` source package: `gdbm=1.18.1-5`

Binary Packages:

- `libgdbm-compat4:amd64=1.18.1-5`
- `libgdbm6:amd64=1.18.1-5`

Licenses: (parsed from: `/usr/share/doc/libgdbm-compat4/copyright`, `/usr/share/doc/libgdbm6/copyright`)

- `GFDL-NIV-1.3+`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris gdbm=1.18.1-5
'http://archive.ubuntu.com/ubuntu/pool/main/g/gdbm/gdbm_1.18.1-5.dsc' gdbm_1.18.1-5.dsc 2635 SHA256:4c0c4498378c673c9d2d8dfb5b319a4830d2dd21e65faaaa8e0f09cb7f71606b
'http://archive.ubuntu.com/ubuntu/pool/main/g/gdbm/gdbm_1.18.1.orig.tar.gz' gdbm_1.18.1.orig.tar.gz 941863 SHA256:86e613527e5dba544e73208f42b78b7c022d4fa5a6d5498bf18c8d6f745b91dc
'http://archive.ubuntu.com/ubuntu/pool/main/g/gdbm/gdbm_1.18.1.orig.tar.gz.asc' gdbm_1.18.1.orig.tar.gz.asc 412 SHA256:3254738e7689e44ac65e78a766806828b8282e6bb1c0e5bb6156a99e567889a5
'http://archive.ubuntu.com/ubuntu/pool/main/g/gdbm/gdbm_1.18.1-5.debian.tar.xz' gdbm_1.18.1-5.debian.tar.xz 16348 SHA256:3c1a0e05b40a97ee51ce77c736c72c37738ba31b2720111d3bc99175a2c3a3ed
```

### `dpkg` source package: `gdk-pixbuf=2.40.0+dfsg-3ubuntu0.5`

Binary Packages:

- `libgdk-pixbuf2.0-0:amd64=2.40.0+dfsg-3ubuntu0.5`
- `libgdk-pixbuf2.0-bin=2.40.0+dfsg-3ubuntu0.5`
- `libgdk-pixbuf2.0-common=2.40.0+dfsg-3ubuntu0.5`

Licenses: (parsed from: `/usr/share/doc/libgdk-pixbuf2.0-0/copyright`, `/usr/share/doc/libgdk-pixbuf2.0-bin/copyright`, `/usr/share/doc/libgdk-pixbuf2.0-common/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2+`
- `MPL-1.1-or-LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris gdk-pixbuf=2.40.0+dfsg-3ubuntu0.5
'http://archive.ubuntu.com/ubuntu/pool/main/g/gdk-pixbuf/gdk-pixbuf_2.40.0%2bdfsg-3ubuntu0.5.dsc' gdk-pixbuf_2.40.0+dfsg-3ubuntu0.5.dsc 2928 SHA512:728a489b0769b2ee0fa3c297c196959cc9040c7303c2e646d248a3b9858cf8a4fbc101eba59104c43ab040e4ba435b3b459c8d36683fd6b4871e9c97edfdb5e2
'http://archive.ubuntu.com/ubuntu/pool/main/g/gdk-pixbuf/gdk-pixbuf_2.40.0%2bdfsg.orig.tar.xz' gdk-pixbuf_2.40.0+dfsg.orig.tar.xz 5626144 SHA512:bb8a9d1837bffdc5f50307dba1a1e6f1ac015e6e670ea6cae6d0bc997afa106ff0d928cb847d76848c480a06e1ad3945274b4913eaa4d9a8074797fc82bb7c1f
'http://archive.ubuntu.com/ubuntu/pool/main/g/gdk-pixbuf/gdk-pixbuf_2.40.0%2bdfsg-3ubuntu0.5.debian.tar.xz' gdk-pixbuf_2.40.0+dfsg-3ubuntu0.5.debian.tar.xz 27840 SHA512:0fb8d7a5e229d246d57545f2b0621c070994cd1f3c12a6d90502cada6c6f8bf24e6d9461ba5dcfa95d7ba0a24a81d1996d9348348bda5d344ae78f9ea9c82e3e
```

### `dpkg` source package: `ghostscript=9.50~dfsg-5ubuntu4.13`

Binary Packages:

- `ghostscript=9.50~dfsg-5ubuntu4.13`
- `libgs9:amd64=9.50~dfsg-5ubuntu4.13`
- `libgs9-common=9.50~dfsg-5ubuntu4.13`

Licenses: (parsed from: `/usr/share/doc/ghostscript/copyright`, `/usr/share/doc/libgs9/copyright`, `/usr/share/doc/libgs9-common/copyright`)

- `AGPL-3`
- `AGPL-3+`
- `AGPL-3+ with font exception`
- `Apache-2.0`
- `BSD-3-Clause`
- `BSD-3-Clause~Adobe`
- `Expat`
- `Expat~Ghostgum`
- `Expat~SunSoft`
- `Expat~SunSoft with SunSoft exception`
- `FTL`
- `GAP~configure`
- `GPL`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `ISC`
- `LGPL-2.1`
- `NTP~Lucent`
- `NTP~Open`
- `NTP~WSU`
- `ZLIB`
- `other`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris ghostscript=9.50~dfsg-5ubuntu4.13
'http://archive.ubuntu.com/ubuntu/pool/main/g/ghostscript/ghostscript_9.50%7edfsg-5ubuntu4.13.dsc' ghostscript_9.50~dfsg-5ubuntu4.13.dsc 2918 SHA512:8f21557c06bf11205011d6d10bf01d6eab8de07b97cdb9a8e19834840df9d462f6a2d4b021e72109aa11d5e0f01acc83131f167132a47b08502d44bbf869d580
'http://archive.ubuntu.com/ubuntu/pool/main/g/ghostscript/ghostscript_9.50%7edfsg.orig.tar.xz' ghostscript_9.50~dfsg.orig.tar.xz 19139148 SHA512:75730872b02fe7341bf6c84fc4b53002f88d2c4c538dee62f749816a4963740f2a369e3a3760175e0f5b73547d5df805a152f5f0120db79ffecc871f5f14be86
'http://archive.ubuntu.com/ubuntu/pool/main/g/ghostscript/ghostscript_9.50%7edfsg-5ubuntu4.13.debian.tar.xz' ghostscript_9.50~dfsg-5ubuntu4.13.debian.tar.xz 144264 SHA512:f04afade59740ad0e0a26d60aca5e79911205c2f256c00122bf88da18f6061d0e1e4786317a92a782d682196c8394beae4d89bc2a79fdad47e56fa406e973461
```

### `dpkg` source package: `giflib=5.1.9-1ubuntu0.1`

Binary Packages:

- `libgif7:amd64=5.1.9-1ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libgif7/copyright`)

- `ISC`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris giflib=5.1.9-1ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/g/giflib/giflib_5.1.9-1ubuntu0.1.dsc' giflib_5.1.9-1ubuntu0.1.dsc 1926 SHA512:3e0eb50effe60d220e65817ff095cf2afec1213e5afdec1c5e327106ad95c2e2de236b1d69b1d0a84e28912d8fb16ec78d62436663e4a18bd3d19e6079e4a885
'http://archive.ubuntu.com/ubuntu/pool/main/g/giflib/giflib_5.1.9.orig.tar.bz2' giflib_5.1.9.orig.tar.bz2 336304 SHA512:f1e0c91fb90c7bf3f2b073f79b1bd4041df5178ff2e5b93975158fc2c6dd6c8ac888f8ff95c3a1804f988ce09154539c20a3196a40704b4d42a0f5846155e0ea
'http://archive.ubuntu.com/ubuntu/pool/main/g/giflib/giflib_5.1.9-1ubuntu0.1.debian.tar.xz' giflib_5.1.9-1ubuntu0.1.debian.tar.xz 9692 SHA512:322f8ae74dba9d6ca206faa6c6c685bb5ec5f2ce5976730d44bc7243e006567240e8ba9f9e87cc5c307f8a15547b72cc04242f4a6b0a26ca9d101b0e7b056af8
```

### `dpkg` source package: `glib-networking=2.64.2-1ubuntu0.1`

Binary Packages:

- `glib-networking:amd64=2.64.2-1ubuntu0.1`
- `glib-networking-common=2.64.2-1ubuntu0.1`
- `glib-networking-services=2.64.2-1ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/glib-networking/copyright`, `/usr/share/doc/glib-networking-common/copyright`, `/usr/share/doc/glib-networking-services/copyright`)

- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `OpenSSL`

Source:

```console
$ apt-get source -qq --print-uris glib-networking=2.64.2-1ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/g/glib-networking/glib-networking_2.64.2-1ubuntu0.1.dsc' glib-networking_2.64.2-1ubuntu0.1.dsc 2271 SHA512:d1110b603099ec5caceae3faa114e50a8b740f6ec9b551541c2785d1b05e8555d6c251bd66c18fba72428906128dc63cbdee53fbcd391e5cb77ca80fce254266
'http://archive.ubuntu.com/ubuntu/pool/main/g/glib-networking/glib-networking_2.64.2.orig.tar.xz' glib-networking_2.64.2.orig.tar.xz 189680 SHA512:b796d3ef82f7ceea1c69a1d4ef7cf09e88ff8e702e93abd37cca4ea2f09650c1bdfdf8d8c57360a4bbafdd8d3cf5f88f0aad668b5ce77b92b60c08b7456ffa12
'http://archive.ubuntu.com/ubuntu/pool/main/g/glib-networking/glib-networking_2.64.2-1ubuntu0.1.debian.tar.xz' glib-networking_2.64.2-1ubuntu0.1.debian.tar.xz 13028 SHA512:b1c2c41667ce96d3823f1d327ea75d23623a043b6bf200322094b5eaf7aa988f8075c170582d94fb5fcdc86266801b0e229c60a631bc869b6a97796da88c7906
```

### `dpkg` source package: `glib2.0=2.64.6-1~ubuntu20.04.7`

Binary Packages:

- `libglib2.0-0:amd64=2.64.6-1~ubuntu20.04.7`
- `libglib2.0-data=2.64.6-1~ubuntu20.04.7`

Licenses: (parsed from: `/usr/share/doc/libglib2.0-0/copyright`, `/usr/share/doc/libglib2.0-data/copyright`)

- `Expat`
- `GPL-2+`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris glib2.0=2.64.6-1~ubuntu20.04.7
'http://archive.ubuntu.com/ubuntu/pool/main/g/glib2.0/glib2.0_2.64.6-1%7eubuntu20.04.7.dsc' glib2.0_2.64.6-1~ubuntu20.04.7.dsc 3338 SHA512:6696868a96d4adb41cd7b7016677d757958e23af6406fe5d63a4baad557716b906f1bad19190bf6addde67edd1d58163faa4db883e7f1b6350a62b3aee1f5985
'http://archive.ubuntu.com/ubuntu/pool/main/g/glib2.0/glib2.0_2.64.6.orig.tar.xz' glib2.0_2.64.6.orig.tar.xz 4781576 SHA512:5cd82c4d9b143e7aa130c24e25fb9def06dd915ef8ad8ed3883931bf5cddecf69c2e669ef6aa1d910484ede75b671e7c48a4f3fe50aa78955bff57b04f0cf958
'http://archive.ubuntu.com/ubuntu/pool/main/g/glib2.0/glib2.0_2.64.6-1%7eubuntu20.04.7.debian.tar.xz' glib2.0_2.64.6-1~ubuntu20.04.7.debian.tar.xz 148828 SHA512:8359a21721d202c294ab0f2eb94e3971231b80546982d25f47850afe7a0cd1c6632b3aa736adb66ce5a9af08e4f8d3da768f44695659577bbcbd42526601bd7e
```

### `dpkg` source package: `glibc=2.31-0ubuntu9.16`

Binary Packages:

- `libc-bin=2.31-0ubuntu9.16`
- `libc6:amd64=2.31-0ubuntu9.16`
- `locales=2.31-0ubuntu9.16`

Licenses: (parsed from: `/usr/share/doc/libc-bin/copyright`, `/usr/share/doc/libc6/copyright`, `/usr/share/doc/locales/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris glibc=2.31-0ubuntu9.16
'http://archive.ubuntu.com/ubuntu/pool/main/g/glibc/glibc_2.31-0ubuntu9.16.dsc' glibc_2.31-0ubuntu9.16.dsc 9585 SHA512:30e3507d4fe12a3fbd7c00b8ba3f051288f06502c204e9fe6a027be38587a61be8344d4875685cdf7920e54f811a945605aa1a8c11a068c2c71dba8892832d75
'http://archive.ubuntu.com/ubuntu/pool/main/g/glibc/glibc_2.31.orig.tar.xz' glibc_2.31.orig.tar.xz 17317924 SHA512:2ff56628fe935cacbdf1825534f15d45cb87a159cbdb2e6a981590eeb6174ed4b3ff7041519cdecbd4f624ac20b745e2dd9614c420dd3ea186b8f36bc4c2453c
'http://archive.ubuntu.com/ubuntu/pool/main/g/glibc/glibc_2.31-0ubuntu9.16.debian.tar.xz' glibc_2.31-0ubuntu9.16.debian.tar.xz 890412 SHA512:663f45bed9dd4829df3ff958c0daf0acf367270c39efa039694c18d17d459e02c4cb5ed1bbd2a290545d7ea29f2ac24ad9a7af3ef9537fa4901879b8899d70bb
```

### `dpkg` source package: `gmp=2:6.2.0+dfsg-4ubuntu0.1`

Binary Packages:

- `libgmp10:amd64=2:6.2.0+dfsg-4ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libgmp10/copyright`)

- `GPL`
- `GPL-2`
- `GPL-3`
- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris gmp=2:6.2.0+dfsg-4ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/g/gmp/gmp_6.2.0%2bdfsg-4ubuntu0.1.dsc' gmp_6.2.0+dfsg-4ubuntu0.1.dsc 2279 SHA512:6171e0fa69e6ddb3332a9fa4a23ca6006a451d19f0df717b1db8ed67c97104b247c9c711db4ea879318b2fd17345c2b63ae4e960613884f34ce0da85dc8f78ea
'http://archive.ubuntu.com/ubuntu/pool/main/g/gmp/gmp_6.2.0%2bdfsg.orig.tar.xz' gmp_6.2.0+dfsg.orig.tar.xz 1842912 SHA512:6ed6df69ced53b13e3e2d64d94f8a34c3257abd4c0967f16d48b064956e260a3d8fb424c84d47dca6d1308bd16b347af3740fce68ebd2d45f1d7f752422c2496
'http://archive.ubuntu.com/ubuntu/pool/main/g/gmp/gmp_6.2.0%2bdfsg-4ubuntu0.1.debian.tar.xz' gmp_6.2.0+dfsg-4ubuntu0.1.debian.tar.xz 21644 SHA512:b89b351bd9648108a15aa4db193610a36d59a9f75ddcbad2ea85004dbdf39553a6e611552351d2f37836eed3d99f152cba22fdbaa71b92f94635797b06404a27
```

### `dpkg` source package: `gnupg2=2.2.19-3ubuntu2.2`

Binary Packages:

- `dirmngr=2.2.19-3ubuntu2.2`
- `gnupg=2.2.19-3ubuntu2.2`
- `gnupg-l10n=2.2.19-3ubuntu2.2`
- `gnupg-utils=2.2.19-3ubuntu2.2`
- `gpg=2.2.19-3ubuntu2.2`
- `gpg-agent=2.2.19-3ubuntu2.2`
- `gpg-wks-client=2.2.19-3ubuntu2.2`
- `gpg-wks-server=2.2.19-3ubuntu2.2`
- `gpgconf=2.2.19-3ubuntu2.2`
- `gpgsm=2.2.19-3ubuntu2.2`
- `gpgv=2.2.19-3ubuntu2.2`

Licenses: (parsed from: `/usr/share/doc/dirmngr/copyright`, `/usr/share/doc/gnupg/copyright`, `/usr/share/doc/gnupg-l10n/copyright`, `/usr/share/doc/gnupg-utils/copyright`, `/usr/share/doc/gpg/copyright`, `/usr/share/doc/gpg-agent/copyright`, `/usr/share/doc/gpg-wks-client/copyright`, `/usr/share/doc/gpg-wks-server/copyright`, `/usr/share/doc/gpgconf/copyright`, `/usr/share/doc/gpgsm/copyright`, `/usr/share/doc/gpgv/copyright`)

- `BSD-3-clause`
- `CC0-1.0`
- `Expat`
- `GPL-3`
- `GPL-3+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `LGPL-3`
- `LGPL-3+`
- `RFC-Reference`
- `TinySCHEME`
- `permissive`

Source:

```console
$ apt-get source -qq --print-uris gnupg2=2.2.19-3ubuntu2.2
'http://archive.ubuntu.com/ubuntu/pool/main/g/gnupg2/gnupg2_2.2.19-3ubuntu2.2.dsc' gnupg2_2.2.19-3ubuntu2.2.dsc 3939 SHA512:13469e7c2042d5b7df6908e73e3e74d57a014340beb599991f16249822fb7e38f6e33415c2e9c27e6f818a609a1e9ebfdff69b7def49347eb5be0e8f249401e0
'http://archive.ubuntu.com/ubuntu/pool/main/g/gnupg2/gnupg2_2.2.19.orig.tar.bz2' gnupg2_2.2.19.orig.tar.bz2 6754972 SHA512:d7700136ac9f0a8cf04b33da4023a42427fced648c2f90d76250c92904353b85fe728bdd89a713d847e8d38e5900c98d46075614492fdc3d1421f927a92f49dd
'http://archive.ubuntu.com/ubuntu/pool/main/g/gnupg2/gnupg2_2.2.19.orig.tar.bz2.asc' gnupg2_2.2.19.orig.tar.bz2.asc 906 SHA512:8b02ce09a50d2aa0c263f7042424ea815386fac56a8d8cea102d1aea2e75802f91bb2ebc7dc2d7a3157126d748ece554e0693d3bf355f908586cbadbe80c68fb
'http://archive.ubuntu.com/ubuntu/pool/main/g/gnupg2/gnupg2_2.2.19-3ubuntu2.2.debian.tar.xz' gnupg2_2.2.19-3ubuntu2.2.debian.tar.xz 66132 SHA512:799684fb92e2c3c1016f0f0df6b4febb1e23b4c448768657358e2203120957d1329a5b4f0b417c659fe3bec414473e59f43ab6c0976b25439121d2b33a1ffe00
```

### `dpkg` source package: `gnutls28=3.6.13-2ubuntu1.11`

Binary Packages:

- `libgnutls30:amd64=3.6.13-2ubuntu1.11`

Licenses: (parsed from: `/usr/share/doc/libgnutls30/copyright`)

- `Apache-2.0`
- `BSD-3-Clause`
- `CC0 license`
- `Expat`
- `GFDL-1.3`
- `GPL`
- `GPL-3`
- `GPLv3+`
- `LGPL`
- `LGPL-3`
- `LGPLv2.1+`
- `LGPLv3+_or_GPLv2+`
- `The main library is licensed under GNU Lesser`

Source:

```console
$ apt-get source -qq --print-uris gnutls28=3.6.13-2ubuntu1.11
'http://archive.ubuntu.com/ubuntu/pool/main/g/gnutls28/gnutls28_3.6.13-2ubuntu1.11.dsc' gnutls28_3.6.13-2ubuntu1.11.dsc 3598 SHA512:b89f65658e49d01f08ec1a062bf15489c8d4b4ff9dc46aa079afefbbfa514a13edbb81eb4d22d224d5b64663290fa49dfad1af3da0829f918551b542ad8d2a58
'http://archive.ubuntu.com/ubuntu/pool/main/g/gnutls28/gnutls28_3.6.13.orig.tar.xz' gnutls28_3.6.13.orig.tar.xz 5958956 SHA512:23581952cb72c9a34f378c002bb62413d5a1243b74b48ad8dc49eaea4020d33c550f8dc1dd374cf7fbfa4187b0ca1c5698c8a0430398268a8b8a863f8633305c
'http://archive.ubuntu.com/ubuntu/pool/main/g/gnutls28/gnutls28_3.6.13.orig.tar.xz.asc' gnutls28_3.6.13.orig.tar.xz.asc 667 SHA512:b343a8ace6a5c81c0c44b2cb65d8e83dfe5963c9bab04d9131fa8fd03cdf0c6f990d720af8767084e01bf5f7a7dbd0f048aefe68c3b6f1dc1ea1899d567a72f7
'http://archive.ubuntu.com/ubuntu/pool/main/g/gnutls28/gnutls28_3.6.13-2ubuntu1.11.debian.tar.xz' gnutls28_3.6.13-2ubuntu1.11.debian.tar.xz 79324 SHA512:b626c9fe40fa6edd9b98925519db26bfb1cb63dd384ac1013d00412dd11ab42466b83ad2a852a96554ac2b29260cf808e2d4f747e0c959714dfd1435063526e7
```

### `dpkg` source package: `gobject-introspection=1.64.1-1~ubuntu20.04.1`

Binary Packages:

- `gir1.2-glib-2.0:amd64=1.64.1-1~ubuntu20.04.1`
- `libgirepository-1.0-1:amd64=1.64.1-1~ubuntu20.04.1`

Licenses: (parsed from: `/usr/share/doc/gir1.2-glib-2.0/copyright`, `/usr/share/doc/libgirepository-1.0-1/copyright`)

- `BSD-2-clause`
- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2+`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris gobject-introspection=1.64.1-1~ubuntu20.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/g/gobject-introspection/gobject-introspection_1.64.1-1%7eubuntu20.04.1.dsc' gobject-introspection_1.64.1-1~ubuntu20.04.1.dsc 3183 SHA512:93ad02366de092d2aac580d03947df4533e687bf77860e5faae26155253daf28da32cd8af52bbea69c4ba24380862ae13bd459edeb55f02730c1ebaec1135063
'http://archive.ubuntu.com/ubuntu/pool/main/g/gobject-introspection/gobject-introspection_1.64.1.orig.tar.xz' gobject-introspection_1.64.1.orig.tar.xz 1000280 SHA512:7610871f7ed5778ea9813062ed6465d131af58c00bdea1bb51dde7f98f459f44ae453eb6d0c5bdc6f7dcd92d639816f4e0773ccd5673cd065d22dabc6448647c
'http://archive.ubuntu.com/ubuntu/pool/main/g/gobject-introspection/gobject-introspection_1.64.1-1%7eubuntu20.04.1.debian.tar.xz' gobject-introspection_1.64.1-1~ubuntu20.04.1.debian.tar.xz 23412 SHA512:9b0e1f889c14d7e883d536fddb6872290c50bb97863d94dab5e74eeda4adb6b31d2f9b5f17d16e46e1188f1511888ab11e9e7afba76fbcbcb5e465f59ac564ee
```

### `dpkg` source package: `gpgme1.0=1.13.1-7ubuntu2.2`

Binary Packages:

- `libgpgme11:amd64=1.13.1-7ubuntu2.2`
- `libgpgmepp6:amd64=1.13.1-7ubuntu2.2`

Licenses: (parsed from: `/usr/share/doc/libgpgme11/copyright`, `/usr/share/doc/libgpgmepp6/copyright`)

- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `LGPL-3`
- `LGPL-3+`

Source:

```console
$ apt-get source -qq --print-uris gpgme1.0=1.13.1-7ubuntu2.2
'http://archive.ubuntu.com/ubuntu/pool/main/g/gpgme1.0/gpgme1.0_1.13.1-7ubuntu2.2.dsc' gpgme1.0_1.13.1-7ubuntu2.2.dsc 2923 SHA512:742bc573d9ddc73bb58ae9a44b4f7d100742d07442bbc07371730b0e3df9aa369210eee91af08a74851bd377d9af36fa67eafe94e3f3424d516837d0ca3fa840
'http://archive.ubuntu.com/ubuntu/pool/main/g/gpgme1.0/gpgme1.0_1.13.1.orig.tar.bz2' gpgme1.0_1.13.1.orig.tar.bz2 1759616 SHA512:11de670c6cf512508103fe67af56d9fbb2a9dda6fc6fa3cd321371bbe337c7c2c81913ca557d07187adb2a63d37ea1a44da97ab22345bbe6022c405d0cb083b8
'http://archive.ubuntu.com/ubuntu/pool/main/g/gpgme1.0/gpgme1.0_1.13.1.orig.tar.bz2.asc' gpgme1.0_1.13.1.orig.tar.bz2.asc 488 SHA512:c5a32aa69dd4d5dca95cdd1d9f51da8751a9d7bdc8ec77ff5cb0cdb0a1512a5ef0d4bbdb33b192eb7f14c928911426992fe497314eff65cc875e31a79eb7485c
'http://archive.ubuntu.com/ubuntu/pool/main/g/gpgme1.0/gpgme1.0_1.13.1-7ubuntu2.2.debian.tar.xz' gpgme1.0_1.13.1-7ubuntu2.2.debian.tar.xz 25348 SHA512:4dd72718213b20ac569859f9637773bf061f39b06e975f53d0f9f2a4d0e1a9dd0260844c28e1b2842df5323e38f398d613f0a079a6f77b8393a77b48aa84f002
```

### `dpkg` source package: `gpm=1.20.7-5`

Binary Packages:

- `libgpm2:amd64=1.20.7-5`

Licenses: (parsed from: `/usr/share/doc/libgpm2/copyright`)

- `GPL-2`
- `GPL-2.0+`
- `GPL-3`
- `GPL-3.0+`

Source:

```console
$ apt-get source -qq --print-uris gpm=1.20.7-5
'http://archive.ubuntu.com/ubuntu/pool/main/g/gpm/gpm_1.20.7-5.dsc' gpm_1.20.7-5.dsc 1986 SHA256:d5925ddcecd217ece2790c1c81993c6e32d86914865d90cb9bfabbe1bb6595a8
'http://archive.ubuntu.com/ubuntu/pool/main/g/gpm/gpm_1.20.7.orig.tar.gz' gpm_1.20.7.orig.tar.gz 855027 SHA256:c7e4661c24e05ae13547176b649bac8e3a0db2575f7dd57559f9e0b509f90f49
'http://archive.ubuntu.com/ubuntu/pool/main/g/gpm/gpm_1.20.7-5.debian.tar.xz' gpm_1.20.7-5.debian.tar.xz 82740 SHA256:4adbf1434c4975cffe8ce7b180a1bf7047d79b0e4f0e1a8bf68297170df6fdf0
```

### `dpkg` source package: `graphene=1.10.0-1build2`

Binary Packages:

- `libgraphene-1.0-0:amd64=1.10.0-1build2`

Licenses: (parsed from: `/usr/share/doc/libgraphene-1.0-0/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris graphene=1.10.0-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/g/graphene/graphene_1.10.0-1build2.dsc' graphene_1.10.0-1build2.dsc 1788 SHA256:002d8be9883f122cc7f7ba23f8dc99c112cdc305ef6942ac9b65279e9cb8cfb4
'http://archive.ubuntu.com/ubuntu/pool/main/g/graphene/graphene_1.10.0.orig.tar.xz' graphene_1.10.0.orig.tar.xz 243748 SHA256:da85afb87e0366b0785307010a6823bbc3b5f53fd11b234de56a2dbdb6ac8745
'http://archive.ubuntu.com/ubuntu/pool/main/g/graphene/graphene_1.10.0-1build2.debian.tar.xz' graphene_1.10.0-1build2.debian.tar.xz 6484 SHA256:85023ca5e6c0ae377bacf65d7bf52fae363546bb091174db4f9e5b0bb73dcb90
```

### `dpkg` source package: `graphite2=1.3.13-11build1`

Binary Packages:

- `libgraphite2-3:amd64=1.3.13-11build1`

Licenses: (parsed from: `/usr/share/doc/libgraphite2-3/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`
- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `MPL-1.1`
- `custom-sil-open-font-license`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris graphite2=1.3.13-11build1
'http://archive.ubuntu.com/ubuntu/pool/main/g/graphite2/graphite2_1.3.13-11build1.dsc' graphite2_1.3.13-11build1.dsc 2636 SHA256:c0553cdbffa6ec465063753058007acdf956a1d3fda7336c356b663d4b73bd18
'http://archive.ubuntu.com/ubuntu/pool/main/g/graphite2/graphite2_1.3.13.orig.tar.gz' graphite2_1.3.13.orig.tar.gz 6664941 SHA256:2f9f609deeddfe2b193502adc8df3b0396694b799a433c36e85fd1242e654cd9
'http://archive.ubuntu.com/ubuntu/pool/main/g/graphite2/graphite2_1.3.13-11build1.debian.tar.xz' graphite2_1.3.13-11build1.debian.tar.xz 12132 SHA256:b25e456d2810c2965e968403e2e2fdaf159327f3db5f37c87adae905b40efa49
```

### `dpkg` source package: `grep=3.4-1`

Binary Packages:

- `grep=3.4-1`

Licenses: (parsed from: `/usr/share/doc/grep/copyright`)

- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris grep=3.4-1
'http://archive.ubuntu.com/ubuntu/pool/main/g/grep/grep_3.4-1.dsc' grep_3.4-1.dsc 1674 SHA256:785f527cede9631f075bdd6c7f35e65e6b82897d009682766cf35839a393277d
'http://archive.ubuntu.com/ubuntu/pool/main/g/grep/grep_3.4.orig.tar.xz' grep_3.4.orig.tar.xz 1555820 SHA256:58e6751c41a7c25bfc6e9363a41786cff3ba5709cf11d5ad903cf7cce31cc3fb
'http://archive.ubuntu.com/ubuntu/pool/main/g/grep/grep_3.4.orig.tar.xz.asc' grep_3.4.orig.tar.xz.asc 833 SHA256:4c1871ff6b79c5e5ce0a192272c171d06ec20762b4b258688b1ca2e47d94b23e
'http://archive.ubuntu.com/ubuntu/pool/main/g/grep/grep_3.4-1.debian.tar.xz' grep_3.4-1.debian.tar.xz 104364 SHA256:582d181804ce72fcfc4c6a9f13ea1dd73ad04c2723b5da346b69ee5cd24a7d08
```

### `dpkg` source package: `gsettings-desktop-schemas=3.36.0-1ubuntu1`

Binary Packages:

- `gsettings-desktop-schemas=3.36.0-1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/gsettings-desktop-schemas/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris gsettings-desktop-schemas=3.36.0-1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/g/gsettings-desktop-schemas/gsettings-desktop-schemas_3.36.0-1ubuntu1.dsc' gsettings-desktop-schemas_3.36.0-1ubuntu1.dsc 2460 SHA256:a7a43bbbcbb3cb32997a5a68b1474b5154ee6db06691bce2c35b43bfafb08181
'http://archive.ubuntu.com/ubuntu/pool/main/g/gsettings-desktop-schemas/gsettings-desktop-schemas_3.36.0.orig.tar.xz' gsettings-desktop-schemas_3.36.0.orig.tar.xz 664992 SHA256:764ab683286536324533a58d4e95fc57f81adaba7d880dd0ebbbced63e960ea6
'http://archive.ubuntu.com/ubuntu/pool/main/g/gsettings-desktop-schemas/gsettings-desktop-schemas_3.36.0-1ubuntu1.debian.tar.xz' gsettings-desktop-schemas_3.36.0-1ubuntu1.debian.tar.xz 8952 SHA256:96de13d6d4f5c6a4935be307cabdc0b0c6e895538a1a980166d0b5d2b4341391
```

### `dpkg` source package: `gsfonts=1:8.11+urwcyr1.0.7~pre44-4.4`

Binary Packages:

- `gsfonts=1:8.11+urwcyr1.0.7~pre44-4.4`

Licenses: (parsed from: `/usr/share/doc/gsfonts/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris gsfonts=1:8.11+urwcyr1.0.7~pre44-4.4
'http://archive.ubuntu.com/ubuntu/pool/universe/g/gsfonts/gsfonts_8.11%2burwcyr1.0.7%7epre44-4.4.dsc' gsfonts_8.11+urwcyr1.0.7~pre44-4.4.dsc 2011 SHA256:c532a13a9ca87a19d5e1470e94bf9fe7b822c0c1745d8f758f993d2ed4b2c329
'http://archive.ubuntu.com/ubuntu/pool/universe/g/gsfonts/gsfonts_8.11%2burwcyr1.0.7%7epre44.orig.tar.gz' gsfonts_8.11+urwcyr1.0.7~pre44.orig.tar.gz 3390551 SHA256:9f2a598998bf05e023546ac981aa2a857aa1635d2e0e3020a3c3004ad564dc00
'http://archive.ubuntu.com/ubuntu/pool/universe/g/gsfonts/gsfonts_8.11%2burwcyr1.0.7%7epre44-4.4.diff.gz' gsfonts_8.11+urwcyr1.0.7~pre44-4.4.diff.gz 6940 SHA256:b3343e4a90dbf5c7bb59df4a335f76d7877e2e6814d3f68f9988343f227db626
```

### `dpkg` source package: `gst-plugins-base1.0=1.16.3-0ubuntu1.3`

Binary Packages:

- `gstreamer1.0-gl:amd64=1.16.3-0ubuntu1.3`
- `gstreamer1.0-plugins-base:amd64=1.16.3-0ubuntu1.3`
- `libgstreamer-gl1.0-0:amd64=1.16.3-0ubuntu1.3`
- `libgstreamer-plugins-base1.0-0:amd64=1.16.3-0ubuntu1.3`

Licenses: (parsed from: `/usr/share/doc/gstreamer1.0-gl/copyright`, `/usr/share/doc/gstreamer1.0-plugins-base/copyright`, `/usr/share/doc/libgstreamer-gl1.0-0/copyright`, `/usr/share/doc/libgstreamer-plugins-base1.0-0/copyright`)

- `BSD (2 clause)`
- `BSD (3 clause)`
- `GPL-2+`
- `LGPL`
- `LGPL-2+`
- `MIT/X11 (BSD like) LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris gst-plugins-base1.0=1.16.3-0ubuntu1.3
'http://archive.ubuntu.com/ubuntu/pool/main/g/gst-plugins-base1.0/gst-plugins-base1.0_1.16.3-0ubuntu1.3.dsc' gst-plugins-base1.0_1.16.3-0ubuntu1.3.dsc 4152 SHA512:6a59f06cd293e211a298ba9f173f11564f97150d513eb76dd2b0bb80f4d9b01923e499a37f234917600da0c041428277ff57ec07fc3b586625e8664c472a3b9f
'http://archive.ubuntu.com/ubuntu/pool/main/g/gst-plugins-base1.0/gst-plugins-base1.0_1.16.3.orig.tar.xz' gst-plugins-base1.0_1.16.3.orig.tar.xz 3953616 SHA512:d44d4da9cb27a6b8e59cb3f0714cc71809c0f14b42ef8d4a2dddbb940efbcb9634a40596d3cdc7391016f6e758005c14aabe1f8f30bb597a57d85c2d94045e75
'http://archive.ubuntu.com/ubuntu/pool/main/g/gst-plugins-base1.0/gst-plugins-base1.0_1.16.3-0ubuntu1.3.debian.tar.xz' gst-plugins-base1.0_1.16.3-0ubuntu1.3.debian.tar.xz 48408 SHA512:27c8382c06e3ed313531cd2c588d03a0641f46eae25040fd49ab94a43027a5d9e245cb0662e0f65d4d58ed2c83f7800bdddab690b8b88b768b81dc1e91812aba
```

### `dpkg` source package: `gst-plugins-good1.0=1.16.3-0ubuntu1.2`

Binary Packages:

- `gstreamer1.0-gtk3:amd64=1.16.3-0ubuntu1.2`

Licenses: (parsed from: `/usr/share/doc/gstreamer1.0-gtk3/copyright`)

- `BSD`
- `BSD (3 clause)`
- `GPL-2+`
- `LGPL`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1+`
- `MIT/X11 (BSD like) LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris gst-plugins-good1.0=1.16.3-0ubuntu1.2
'http://archive.ubuntu.com/ubuntu/pool/main/g/gst-plugins-good1.0/gst-plugins-good1.0_1.16.3-0ubuntu1.2.dsc' gst-plugins-good1.0_1.16.3-0ubuntu1.2.dsc 4133 SHA512:d45c41b46acb403cf9be8961b41594ed9fc61a6b67185932cbba1da1cfaa8c743f812c37df6b9d7b65586c41350d05782de48b96c8f41baa5ae2e7474c9697a3
'http://archive.ubuntu.com/ubuntu/pool/main/g/gst-plugins-good1.0/gst-plugins-good1.0_1.16.3.orig.tar.xz' gst-plugins-good1.0_1.16.3.orig.tar.xz 3914676 SHA512:3e0da4a4defc0ddea1c26dfc767fed732548654f4155452649777109a17d5b65b2fde895483a3e35dc1646de5a16e913cd2408f826251d46a99b7751b88dcb65
'http://archive.ubuntu.com/ubuntu/pool/main/g/gst-plugins-good1.0/gst-plugins-good1.0_1.16.3-0ubuntu1.2.debian.tar.xz' gst-plugins-good1.0_1.16.3-0ubuntu1.2.debian.tar.xz 131056 SHA512:a742b550337fa7a008bea5af385543fecb09792f741af2b9d5020095fade0ffb25dea00ba990037009c006261f14c63dba0a57bf30c34c1bc7a9ace7a1f4cc78
```

### `dpkg` source package: `gstreamer1.0=1.16.3-0ubuntu1.1`

Binary Packages:

- `libgstreamer1.0-0:amd64=1.16.3-0ubuntu1.1`

Licenses: (parsed from: `/usr/share/doc/libgstreamer1.0-0/copyright`)

- `GPL-2+`
- `GPL-3+`
- `LGPL`
- `LGPL-2+`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris gstreamer1.0=1.16.3-0ubuntu1.1
'http://archive.ubuntu.com/ubuntu/pool/main/g/gstreamer1.0/gstreamer1.0_1.16.3-0ubuntu1.1.dsc' gstreamer1.0_1.16.3-0ubuntu1.1.dsc 3037 SHA512:1950d9430627a6a23905589d1219273e79c6be25b65b7dedda793e349b10345a288b5c5858019d0815993b40c801bec927a0a53f167b140660df062e35d4e9db
'http://archive.ubuntu.com/ubuntu/pool/main/g/gstreamer1.0/gstreamer1.0_1.16.3.orig.tar.xz' gstreamer1.0_1.16.3.orig.tar.xz 3338692 SHA512:4a879e71f65c89609c2e106dc79222853e6f37830638d5b9624c436fc9d8974cc6474d399eff02cdc13ff7189fcd13e9450450d36c3a6092aa53cb97056f5854
'http://archive.ubuntu.com/ubuntu/pool/main/g/gstreamer1.0/gstreamer1.0_1.16.3-0ubuntu1.1.debian.tar.xz' gstreamer1.0_1.16.3-0ubuntu1.1.debian.tar.xz 44712 SHA512:d5069b909b06ad7db9988ec472f20db0625ca0101c3f4f1c622e3f4218fe16a3d9bbdbb6773185c2d15b1d2931b8fbd8829f6bf2049df169dfe4f201aecbdbae
```

### `dpkg` source package: `gtk+3.0=3.24.20-0ubuntu1.2`

Binary Packages:

- `gtk-update-icon-cache=3.24.20-0ubuntu1.2`
- `libgtk-3-0:amd64=3.24.20-0ubuntu1.2`
- `libgtk-3-bin=3.24.20-0ubuntu1.2`
- `libgtk-3-common=3.24.20-0ubuntu1.2`

Licenses: (parsed from: `/usr/share/doc/gtk-update-icon-cache/copyright`, `/usr/share/doc/libgtk-3-0/copyright`, `/usr/share/doc/libgtk-3-bin/copyright`, `/usr/share/doc/libgtk-3-common/copyright`)

- `Apache-2.0`
- `Expat`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `SWL`
- `X11R5-permissive`
- `check-gdk-cairo-permissive`
- `other`

Source:

```console
$ apt-get source -qq --print-uris gtk+3.0=3.24.20-0ubuntu1.2
'http://archive.ubuntu.com/ubuntu/pool/main/g/gtk%2b3.0/gtk%2b3.0_3.24.20-0ubuntu1.2.dsc' gtk+3.0_3.24.20-0ubuntu1.2.dsc 4301 SHA512:e64b921a5a212a2127b69ac9c0dc156d48e55a589b0666480a0f902882fd85c4624b9e5eaf86d4643996980818ae702ac4bcc05f45f1cc4321dbf40d00f052e3
'http://archive.ubuntu.com/ubuntu/pool/main/g/gtk%2b3.0/gtk%2b3.0_3.24.20.orig.tar.xz' gtk+3.0_3.24.20.orig.tar.xz 22726768 SHA512:bda8eeacf721afcff4565756fe45857cbf8b053494d1d747ca9b97c899e9fe21fddef6871ecd5ec9a7a0f87b0a3ede2f9d6b5e5712de10a845100d82464a4556
'http://archive.ubuntu.com/ubuntu/pool/main/g/gtk%2b3.0/gtk%2b3.0_3.24.20-0ubuntu1.2.debian.tar.xz' gtk+3.0_3.24.20-0ubuntu1.2.debian.tar.xz 172360 SHA512:d011eae6d920a2657b63d648f22141f74b25aad73a0bee985f28910ceda102e459fdde71fa5c838da8bda8155d33985f0b571a35874789c453fdbc28636581e3
```

### `dpkg` source package: `gzip=1.10-0ubuntu4.1`

Binary Packages:

- `gzip=1.10-0ubuntu4.1`

Licenses: (parsed from: `/usr/share/doc/gzip/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris gzip=1.10-0ubuntu4.1
'http://archive.ubuntu.com/ubuntu/pool/main/g/gzip/gzip_1.10-0ubuntu4.1.dsc' gzip_1.10-0ubuntu4.1.dsc 2113 SHA512:27a7c1871b33b62f6cada63d43f43eae1f3a9a3d92b10a28a28ef7f85893aba3a9513ac031c96a0dedbdaa0507aafe8922631460ff2890ab663fb732283ba073
'http://archive.ubuntu.com/ubuntu/pool/main/g/gzip/gzip_1.10.orig.tar.gz' gzip_1.10.orig.tar.gz 1201421 SHA512:7939043e74554ced0c1c05d354ab4eb36cd6dce89ad79d02ccdc5ed6b7ee390759689b2d47c07227b9b44a62851afe7c76c4cae9f92527d999f3f1b4df1cccff
'http://archive.ubuntu.com/ubuntu/pool/main/g/gzip/gzip_1.10-0ubuntu4.1.debian.tar.xz' gzip_1.10-0ubuntu4.1.debian.tar.xz 31144 SHA512:26096584c400dc78d892f1721ad28778aa1a0c0476337bd37589c6d985f8636aad9c7fde55385c25ce1c8420a40c6ca33c06887f18b855ba8a5f45b980fe6c99
```

### `dpkg` source package: `harfbuzz=2.6.4-1ubuntu4.2`

Binary Packages:

- `libharfbuzz-icu0:amd64=2.6.4-1ubuntu4.2`
- `libharfbuzz0b:amd64=2.6.4-1ubuntu4.2`

Licenses: (parsed from: `/usr/share/doc/libharfbuzz-icu0/copyright`, `/usr/share/doc/libharfbuzz0b/copyright`)

- `MIT`

Source:

```console
$ apt-get source -qq --print-uris harfbuzz=2.6.4-1ubuntu4.2
'http://archive.ubuntu.com/ubuntu/pool/main/h/harfbuzz/harfbuzz_2.6.4-1ubuntu4.2.dsc' harfbuzz_2.6.4-1ubuntu4.2.dsc 2849 SHA512:c07f75420e4712cd0d7a98e9add327426b1aa77abde4a79c83ee60c78bc94e5f9f88256b8c64a9ad13afdbcf0d1d077e331b84913d12bcad12326da47530d471
'http://archive.ubuntu.com/ubuntu/pool/main/h/harfbuzz/harfbuzz_2.6.4.orig.tar.xz' harfbuzz_2.6.4.orig.tar.xz 5967468 SHA512:d8664bb64fda11ff7646693070637e3827f8b3d1de50e11ecf108ce4d19c878b26b2ba4cff278da6e6cc0cb431e1630d9eaa7c32a9bebb9655a7aa8dabf7114f
'http://archive.ubuntu.com/ubuntu/pool/main/h/harfbuzz/harfbuzz_2.6.4-1ubuntu4.2.debian.tar.xz' harfbuzz_2.6.4-1ubuntu4.2.debian.tar.xz 12000 SHA512:a82f88147e34b830bb0eda78313aff32f079fc902e79eeb8b270d1513b4fe07f60c927d1b4204a593baab929c1285302ae02edda147b3a45fa453938aa0525b6
```

### `dpkg` source package: `heimdal=7.7.0+dfsg-1ubuntu1.4`

Binary Packages:

- `libasn1-8-heimdal:amd64=7.7.0+dfsg-1ubuntu1.4`
- `libgssapi3-heimdal:amd64=7.7.0+dfsg-1ubuntu1.4`
- `libhcrypto4-heimdal:amd64=7.7.0+dfsg-1ubuntu1.4`
- `libheimbase1-heimdal:amd64=7.7.0+dfsg-1ubuntu1.4`
- `libheimntlm0-heimdal:amd64=7.7.0+dfsg-1ubuntu1.4`
- `libhx509-5-heimdal:amd64=7.7.0+dfsg-1ubuntu1.4`
- `libkrb5-26-heimdal:amd64=7.7.0+dfsg-1ubuntu1.4`
- `libroken18-heimdal:amd64=7.7.0+dfsg-1ubuntu1.4`
- `libwind0-heimdal:amd64=7.7.0+dfsg-1ubuntu1.4`

Licenses: (parsed from: `/usr/share/doc/libasn1-8-heimdal/copyright`, `/usr/share/doc/libgssapi3-heimdal/copyright`, `/usr/share/doc/libhcrypto4-heimdal/copyright`, `/usr/share/doc/libheimbase1-heimdal/copyright`, `/usr/share/doc/libheimntlm0-heimdal/copyright`, `/usr/share/doc/libhx509-5-heimdal/copyright`, `/usr/share/doc/libkrb5-26-heimdal/copyright`, `/usr/share/doc/libroken18-heimdal/copyright`, `/usr/share/doc/libwind0-heimdal/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2+`
- `custom`
- `none`

Source:

```console
$ apt-get source -qq --print-uris heimdal=7.7.0+dfsg-1ubuntu1.4
'http://archive.ubuntu.com/ubuntu/pool/main/h/heimdal/heimdal_7.7.0%2bdfsg-1ubuntu1.4.dsc' heimdal_7.7.0+dfsg-1ubuntu1.4.dsc 3391 SHA512:c28429267b0b1afbe9dd661cff51cf21109d6b2d56a148067c3b26aa1bb10644b43ad71fe4b2bebc5cde11ac1142e0275680206c2fa5244854a990046940d5cc
'http://archive.ubuntu.com/ubuntu/pool/main/h/heimdal/heimdal_7.7.0%2bdfsg.orig.tar.xz' heimdal_7.7.0+dfsg.orig.tar.xz 5945252 SHA512:14141f3fff264c9516f736bcc51c998df69cfaa7108d2387921299efd7e82d79b918dee4029905dc221c204d3340ffc17da9472baf80029372d7c13de328ec0a
'http://archive.ubuntu.com/ubuntu/pool/main/h/heimdal/heimdal_7.7.0%2bdfsg-1ubuntu1.4.debian.tar.xz' heimdal_7.7.0+dfsg-1ubuntu1.4.debian.tar.xz 138444 SHA512:4fd1d529d0a05c415cd5f729a0ed4401c8f590c142425718fa61a3e636be6d4b3efddbad218cb6f8b9583f47fa62335f838491f47c6e04af42f3706b4cbbbec9
```

### `dpkg` source package: `hicolor-icon-theme=0.17-2`

Binary Packages:

- `hicolor-icon-theme=0.17-2`

Licenses: (parsed from: `/usr/share/doc/hicolor-icon-theme/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris hicolor-icon-theme=0.17-2
'http://archive.ubuntu.com/ubuntu/pool/main/h/hicolor-icon-theme/hicolor-icon-theme_0.17-2.dsc' hicolor-icon-theme_0.17-2.dsc 2053 SHA256:9df02b466f82cd6fa13930bc197d001ed8ddac1abc7f8dde3db45ed1708336bd
'http://archive.ubuntu.com/ubuntu/pool/main/h/hicolor-icon-theme/hicolor-icon-theme_0.17.orig.tar.xz' hicolor-icon-theme_0.17.orig.tar.xz 53016 SHA256:317484352271d18cbbcfac3868eab798d67fff1b8402e740baa6ff41d588a9d8
'http://archive.ubuntu.com/ubuntu/pool/main/h/hicolor-icon-theme/hicolor-icon-theme_0.17-2.debian.tar.xz' hicolor-icon-theme_0.17-2.debian.tar.xz 3536 SHA256:97eec9852a2923b95bd13fc59c30fb1b9063ffd1f8a04748544d4975a84e98f2
```

### `dpkg` source package: `hostname=3.23`

Binary Packages:

- `hostname=3.23`

Licenses: (parsed from: `/usr/share/doc/hostname/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris hostname=3.23
'http://archive.ubuntu.com/ubuntu/pool/main/h/hostname/hostname_3.23.dsc' hostname_3.23.dsc 1402 SHA256:0694c083fad82da1fd33204557a30bfc745a689a64030ba360062daafe03ede0
'http://archive.ubuntu.com/ubuntu/pool/main/h/hostname/hostname_3.23.tar.gz' hostname_3.23.tar.gz 13672 SHA256:bc6d1954b22849869ff8b2a602e39f08b1702f686d4b58dd7927cdeb5b4876ef
```

### `dpkg` source package: `hsqldb1.8.0=1.8.0.10+dfsg-10`

Binary Packages:

- `libhsqldb1.8.0-java=1.8.0.10+dfsg-10`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris hsqldb1.8.0=1.8.0.10+dfsg-10
'http://archive.ubuntu.com/ubuntu/pool/universe/h/hsqldb1.8.0/hsqldb1.8.0_1.8.0.10%2bdfsg-10.dsc' hsqldb1.8.0_1.8.0.10+dfsg-10.dsc 1921 SHA256:040581531f55714968f4099f7830106f9267fd9f72ac636658030adb46537cf6
'http://archive.ubuntu.com/ubuntu/pool/universe/h/hsqldb1.8.0/hsqldb1.8.0_1.8.0.10%2bdfsg.orig.tar.gz' hsqldb1.8.0_1.8.0.10+dfsg.orig.tar.gz 2917677 SHA256:e555da47b3c1c3f364de2297b2c2b76113fbbd903604d6a0a6f782b060a16f48
'http://archive.ubuntu.com/ubuntu/pool/universe/h/hsqldb1.8.0/hsqldb1.8.0_1.8.0.10%2bdfsg-10.diff.gz' hsqldb1.8.0_1.8.0.10+dfsg-10.diff.gz 29604 SHA256:148a71dd48b7c3176090bb30e79f24a022b0f4ce18cfce5c0131ff16202ffa6d
```

### `dpkg` source package: `humanity-icon-theme=0.6.15`

Binary Packages:

- `humanity-icon-theme=0.6.15`

Licenses: (parsed from: `/usr/share/doc/humanity-icon-theme/copyright`)

- `GPL-2`
- `GPL-3`
- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris humanity-icon-theme=0.6.15
'http://archive.ubuntu.com/ubuntu/pool/main/h/humanity-icon-theme/humanity-icon-theme_0.6.15.dsc' humanity-icon-theme_0.6.15.dsc 1631 SHA256:cc3387acdf0e27443d7d3ec65dd07ad691421f46134493279a5f92d0a7706d1a
'http://archive.ubuntu.com/ubuntu/pool/main/h/humanity-icon-theme/humanity-icon-theme_0.6.15.tar.xz' humanity-icon-theme_0.6.15.tar.xz 1755216 SHA256:9dbcb425c2ee2a58c70da1eda4c2c88e32e7ede4094fb59772726864c8214aa6
```

### `dpkg` source package: `hunspell=1.7.0-2build2`

Binary Packages:

- `libhunspell-1.7-0:amd64=1.7.0-2build2`

Licenses: (parsed from: `/usr/share/doc/libhunspell-1.7-0/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris hunspell=1.7.0-2build2
'http://archive.ubuntu.com/ubuntu/pool/main/h/hunspell/hunspell_1.7.0-2build2.dsc' hunspell_1.7.0-2build2.dsc 2287 SHA256:8e5c9450c4b45a7e96c4479777fb9d70263d182456dd01ffea797c16b78a0468
'http://archive.ubuntu.com/ubuntu/pool/main/h/hunspell/hunspell_1.7.0.orig.tar.gz' hunspell_1.7.0.orig.tar.gz 482156 SHA256:bb27b86eb910a8285407cf3ca33b62643a02798cf2eef468c0a74f6c3ee6bc8a
'http://archive.ubuntu.com/ubuntu/pool/main/h/hunspell/hunspell_1.7.0-2build2.debian.tar.xz' hunspell_1.7.0-2build2.debian.tar.xz 21696 SHA256:df8fa19414139746b4fb96b344f4ddcc4e7ad928ed402956d1a4b91883a5df7f
```

### `dpkg` source package: `hyphen=2.8.8-7`

Binary Packages:

- `libhyphen0:amd64=2.8.8-7`

Licenses: (parsed from: `/usr/share/doc/libhyphen0/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `MPL-1.1+`

Source:

```console
$ apt-get source -qq --print-uris hyphen=2.8.8-7
'http://archive.ubuntu.com/ubuntu/pool/main/h/hyphen/hyphen_2.8.8-7.dsc' hyphen_2.8.8-7.dsc 2086 SHA256:f77f10861124cb0a9ac701cac314d037244d1bc362bac113efdf643573120ffe
'http://archive.ubuntu.com/ubuntu/pool/main/h/hyphen/hyphen_2.8.8.orig.tar.gz' hyphen_2.8.8.orig.tar.gz 638369 SHA256:304636d4eccd81a14b6914d07b84c79ebb815288c76fe027b9ebff6ff24d5705
'http://archive.ubuntu.com/ubuntu/pool/main/h/hyphen/hyphen_2.8.8-7.debian.tar.xz' hyphen_2.8.8-7.debian.tar.xz 12540 SHA256:085a0168906304c9033154923e269ae70b64881dcbe6e52854afd4bd2be60aec
```

### `dpkg` source package: `icu=66.1-2ubuntu2.1`

Binary Packages:

- `libicu66:amd64=66.1-2ubuntu2.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris icu=66.1-2ubuntu2.1
'http://archive.ubuntu.com/ubuntu/pool/main/i/icu/icu_66.1-2ubuntu2.1.dsc' icu_66.1-2ubuntu2.1.dsc 2047 SHA512:202bb201876d0167afede5fcf4abc3cb55faf75059edac64d50e3560064fe2482608e2b2476669767fa7f80aaf845a3d1c6b619e737358eb726c5de03059a8c6
'http://archive.ubuntu.com/ubuntu/pool/main/i/icu/icu_66.1.orig.tar.gz' icu_66.1.orig.tar.gz 24361305 SHA512:78d87bce65a7bdf7e9a19bda13e353c60846816ff34025f829d1ff15f9ac49aa6061eb192173742be0eca105684ce0e39e95656147afe848520bf60274c8d246
'http://archive.ubuntu.com/ubuntu/pool/main/i/icu/icu_66.1.orig.tar.gz.asc' icu_66.1.orig.tar.gz.asc 833 SHA512:5e624e8a1f210e8671f683efa203b96eebb9a311ca9945705d77e05fc182291c064157660b094ec5a073088a70892fd74e977b57fdd0abddc48ac73a4ab8781c
'http://archive.ubuntu.com/ubuntu/pool/main/i/icu/icu_66.1-2ubuntu2.1.debian.tar.xz' icu_66.1-2ubuntu2.1.debian.tar.xz 29700 SHA512:f7a9e5f49e157ede3e5dbc1a03b1521fed15dedfbdd6d8e98672f36e9b643c93e0e6407a26b66d2677bc38a5fe0ee090d9e5931d106ee1cbac4eb969db451ace
```

### `dpkg` source package: `ijs=0.35-15`

Binary Packages:

- `libijs-0.35:amd64=0.35-15`

Licenses: (parsed from: `/usr/share/doc/libijs-0.35/copyright`)

- `Expat`
- `Expat~X`
- `Expat~X with X exception`
- `GAP`
- `GAP~Makefile.in`
- `GAP~configure`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with Autoconf exception`

Source:

```console
$ apt-get source -qq --print-uris ijs=0.35-15
'http://archive.ubuntu.com/ubuntu/pool/main/i/ijs/ijs_0.35-15.dsc' ijs_0.35-15.dsc 2073 SHA256:24ca5cfd3aa05fb20281c81afd81b006d2fad058683d7ef43d51a860614cd18c
'http://archive.ubuntu.com/ubuntu/pool/main/i/ijs/ijs_0.35.orig.tar.gz' ijs_0.35.orig.tar.gz 344262 SHA256:901fffb73e42dae343a8285a31d9c4e82dc3856d36be30adbdb564bdd27161d6
'http://archive.ubuntu.com/ubuntu/pool/main/i/ijs/ijs_0.35-15.debian.tar.xz' ijs_0.35-15.debian.tar.xz 10340 SHA256:5a9e755fb15f822a002308ae20b28b66926f77a352b6e73a57169cd61a4b1e4d
```

### `dpkg` source package: `ilmbase=2.3.0-6build1`

Binary Packages:

- `libilmbase24:amd64=2.3.0-6build1`

Licenses: (parsed from: `/usr/share/doc/libilmbase24/copyright`)

- `boost`
- `ilmbase`

Source:

```console
$ apt-get source -qq --print-uris ilmbase=2.3.0-6build1
'http://archive.ubuntu.com/ubuntu/pool/universe/i/ilmbase/ilmbase_2.3.0-6build1.dsc' ilmbase_2.3.0-6build1.dsc 2367 SHA256:2164e2cff01f17f030b456c2d0920d09461ae76229507459a73cf7c618d4f7f6
'http://archive.ubuntu.com/ubuntu/pool/universe/i/ilmbase/ilmbase_2.3.0.orig.tar.gz' ilmbase_2.3.0.orig.tar.gz 596749 SHA256:0ea21166799bbdd920e7a38a7026236566aafdd6e8638f54c9da1af2219fae82
'http://archive.ubuntu.com/ubuntu/pool/universe/i/ilmbase/ilmbase_2.3.0.orig.tar.gz.asc' ilmbase_2.3.0.orig.tar.gz.asc 566 SHA256:c7ee3f4432322d4f7c63dd1b0ca2188a8d1c4a018821c3c12a3d9db746b54bee
'http://archive.ubuntu.com/ubuntu/pool/universe/i/ilmbase/ilmbase_2.3.0-6build1.debian.tar.xz' ilmbase_2.3.0-6build1.debian.tar.xz 14252 SHA256:1039258f50fda2e94e4dac23e1e8aa702d8e3e83d0e1f12f13a652eadf2ebbf3
```

### `dpkg` source package: `imagemagick=8:6.9.10.23+dfsg-2.1ubuntu11.10`

Binary Packages:

- `imagemagick=8:6.9.10.23+dfsg-2.1ubuntu11.10`
- `imagemagick-6-common=8:6.9.10.23+dfsg-2.1ubuntu11.10`
- `imagemagick-6.q16=8:6.9.10.23+dfsg-2.1ubuntu11.10`
- `libmagickcore-6.q16-6:amd64=8:6.9.10.23+dfsg-2.1ubuntu11.10`
- `libmagickcore-6.q16-6-extra:amd64=8:6.9.10.23+dfsg-2.1ubuntu11.10`
- `libmagickwand-6.q16-6:amd64=8:6.9.10.23+dfsg-2.1ubuntu11.10`

Licenses: (parsed from: `/usr/share/doc/imagemagick/copyright`, `/usr/share/doc/imagemagick-6-common/copyright`, `/usr/share/doc/imagemagick-6.q16/copyright`, `/usr/share/doc/libmagickcore-6.q16-6/copyright`, `/usr/share/doc/libmagickcore-6.q16-6-extra/copyright`, `/usr/share/doc/libmagickwand-6.q16-6/copyright`)

- `Artistic`
- `BSD-with-FSF-change-public-domain`
- `GNU-All-Permissive-License`
- `GPL-1`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL2+-with-Autoconf-Macros-exception`
- `GPL3+-with-Autoconf-Macros-exception`
- `GPL3+-with-Autoconf-Macros-exception-GNU`
- `ImageMagick`
- `ImageMagickLicensePartEZXML`
- `ImageMagickLicensePartFIG`
- `ImageMagickLicensePartGsview`
- `ImageMagickLicensePartOpenSSH`
- `ImageMagickPartGraphicsMagick`
- `ImageMagickPartlibjpeg`
- `ImageMagickPartlibsquish`
- `Imagemagick`
- `LGPL-3`
- `LGPL-3+`
- `Magick++`
- `Makefile-in`
- `Perllikelicence`
- `TatcherUlrichPublicDomain`
- `aclocal`

Source:

```console
$ apt-get source -qq --print-uris imagemagick=8:6.9.10.23+dfsg-2.1ubuntu11.10
'http://archive.ubuntu.com/ubuntu/pool/universe/i/imagemagick/imagemagick_6.9.10.23%2bdfsg-2.1ubuntu11.10.dsc' imagemagick_6.9.10.23+dfsg-2.1ubuntu11.10.dsc 5255 SHA512:6d17078d258fb223f971b40f92cccaf3827f8e071153c505a54879d657ce5ec0344b4885b27ba296d59b0a26f7d43bb1e1dbbf9139fb6e0e9b9ecd4502411dfd
'http://archive.ubuntu.com/ubuntu/pool/universe/i/imagemagick/imagemagick_6.9.10.23%2bdfsg.orig.tar.xz' imagemagick_6.9.10.23+dfsg.orig.tar.xz 9081188 SHA512:0c5fdfb82d12fef09d79c3a3d03167a57732e566980ca89e977d04502779506eae34e6bc4260c35558db63c572c64fe80d69f6627e180ffc8e8679ebe8574972
'http://archive.ubuntu.com/ubuntu/pool/universe/i/imagemagick/imagemagick_6.9.10.23%2bdfsg-2.1ubuntu11.10.debian.tar.xz' imagemagick_6.9.10.23+dfsg-2.1ubuntu11.10.debian.tar.xz 267804 SHA512:425a38dda2c6af4058357b618ec3e36a83c3796306c954843a221ebb29ac387d71286c14e4a91699959e06a768461aaa142e1aab9a1d57cd410d184dacd3dcbb
```

### `dpkg` source package: `init-system-helpers=1.57`

Binary Packages:

- `init-system-helpers=1.57`

Licenses: (parsed from: `/usr/share/doc/init-system-helpers/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris init-system-helpers=1.57
'http://archive.ubuntu.com/ubuntu/pool/main/i/init-system-helpers/init-system-helpers_1.57.dsc' init-system-helpers_1.57.dsc 1896 SHA256:88bb5af040c99f010b6d6947ff5c80ae4863ff787e0eeae91e99dcd15a10dbb8
'http://archive.ubuntu.com/ubuntu/pool/main/i/init-system-helpers/init-system-helpers_1.57.tar.xz' init-system-helpers_1.57.tar.xz 40460 SHA256:e9d83fd8756a42666fb5d19a8835813823295846659b4e58f138bb9b54e9f5dd
```

### `dpkg` source package: `intel-gmmlib=20.1.1+ds1-1`

Binary Packages:

- `libigdgmm11:amd64=20.1.1+ds1-1`

Licenses: (parsed from: `/usr/share/doc/libigdgmm11/copyright`)

- `BSD-3-clause`
- `Expat`

Source:

```console
$ apt-get source -qq --print-uris intel-gmmlib=20.1.1+ds1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/i/intel-gmmlib/intel-gmmlib_20.1.1%2bds1-1.dsc' intel-gmmlib_20.1.1+ds1-1.dsc 2153 SHA256:dc57cded19c175f37d156440f558fe770d88bddbe89c8add5414a06a2d77698e
'http://archive.ubuntu.com/ubuntu/pool/universe/i/intel-gmmlib/intel-gmmlib_20.1.1%2bds1.orig.tar.xz' intel-gmmlib_20.1.1+ds1.orig.tar.xz 400648 SHA256:f794d7be92395e018267208d1b95944269dee6348b2e6a8c54373429c42c768b
'http://archive.ubuntu.com/ubuntu/pool/universe/i/intel-gmmlib/intel-gmmlib_20.1.1%2bds1-1.debian.tar.xz' intel-gmmlib_20.1.1+ds1-1.debian.tar.xz 3988 SHA256:e018d6a5d43b1415900064cac740032b7e56769c6ab5f3224d761ecfcc111c3a
```

### `dpkg` source package: `intel-media-driver=20.1.1+dfsg1-1`

Binary Packages:

- `intel-media-va-driver:amd64=20.1.1+dfsg1-1`

Licenses: (parsed from: `/usr/share/doc/intel-media-va-driver/copyright`)

- `BSD-3-clause`
- `Expat`

Source:

```console
$ apt-get source -qq --print-uris intel-media-driver=20.1.1+dfsg1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/i/intel-media-driver/intel-media-driver_20.1.1%2bdfsg1-1.dsc' intel-media-driver_20.1.1+dfsg1-1.dsc 2377 SHA256:6614cc4c3208d17376ddab528abd0f6fdc7d43554ac25cb889cc247bf6d016a7
'http://archive.ubuntu.com/ubuntu/pool/universe/i/intel-media-driver/intel-media-driver_20.1.1%2bdfsg1.orig.tar.xz' intel-media-driver_20.1.1+dfsg1.orig.tar.xz 6060444 SHA256:859d5429fe18e198ecc9f296b116491909f40b6d2e684fbc8109e3851e4d2414
'http://archive.ubuntu.com/ubuntu/pool/universe/i/intel-media-driver/intel-media-driver_20.1.1%2bdfsg1-1.debian.tar.xz' intel-media-driver_20.1.1+dfsg1-1.debian.tar.xz 5560 SHA256:40b2d1c8bcf3810f1504a252247f08211f7bcd781121639371bf0bd9383fab76
```

### `dpkg` source package: `intel-vaapi-driver=2.4.0-0ubuntu1`

Binary Packages:

- `i965-va-driver:amd64=2.4.0-0ubuntu1`

Licenses: (parsed from: `/usr/share/doc/i965-va-driver/copyright`)

- `Apache-2.0`
- `EPL-1.0`
- `Expat`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris intel-vaapi-driver=2.4.0-0ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/universe/i/intel-vaapi-driver/intel-vaapi-driver_2.4.0-0ubuntu1.dsc' intel-vaapi-driver_2.4.0-0ubuntu1.dsc 2363 SHA256:9bcc4b4b0213e1c22b8752cd06cf30ee6927b9c6b75b5c89b0f18a8b15e67a7d
'http://archive.ubuntu.com/ubuntu/pool/universe/i/intel-vaapi-driver/intel-vaapi-driver_2.4.0.orig.tar.gz' intel-vaapi-driver_2.4.0.orig.tar.gz 3962269 SHA256:58567dac882167021f031489062cbbab76bc646214be0ee44d5f724d960b3d76
'http://archive.ubuntu.com/ubuntu/pool/universe/i/intel-vaapi-driver/intel-vaapi-driver_2.4.0-0ubuntu1.debian.tar.xz' intel-vaapi-driver_2.4.0-0ubuntu1.debian.tar.xz 13220 SHA256:8f3501542b23caaa9214a9089e0df242fd3d4233f2eb36c51269bcc0fb881a8f
```

### `dpkg` source package: `io-stringy=2.111-3`

Binary Packages:

- `libio-stringy-perl=2.111-3`

Licenses: (parsed from: `/usr/share/doc/libio-stringy-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris io-stringy=2.111-3
'http://archive.ubuntu.com/ubuntu/pool/main/i/io-stringy/io-stringy_2.111-3.dsc' io-stringy_2.111-3.dsc 2166 SHA256:b21b87e84a62a9c6fe2b5f421d5937b0af35dca29844c435f8104586c0d0f8c6
'http://archive.ubuntu.com/ubuntu/pool/main/i/io-stringy/io-stringy_2.111.orig.tar.gz' io-stringy_2.111.orig.tar.gz 41515 SHA256:8c67fd6608c3c4e74f7324f1404a856c331dbf48d9deda6aaa8296ea41bf199d
'http://archive.ubuntu.com/ubuntu/pool/main/i/io-stringy/io-stringy_2.111-3.debian.tar.xz' io-stringy_2.111-3.debian.tar.xz 4328 SHA256:e093b904edd3832986d87d0e0f7995b9962aae2b78cdf6da65c4408b0ed38413
```

### `dpkg` source package: `iptables=1.8.4-3ubuntu2.1`

Binary Packages:

- `libip4tc2:amd64=1.8.4-3ubuntu2.1`

Licenses: (parsed from: `/usr/share/doc/libip4tc2/copyright`)

- `Artistic`
- `GPL-2`
- `GPL-2+`
- `custom`

Source:

```console
$ apt-get source -qq --print-uris iptables=1.8.4-3ubuntu2.1
'http://archive.ubuntu.com/ubuntu/pool/main/i/iptables/iptables_1.8.4-3ubuntu2.1.dsc' iptables_1.8.4-3ubuntu2.1.dsc 2853 SHA512:7fa4e772007227de449a1e067ec0ffee3012b3eea16de5336f8ca92198f8bc0d54b605146ea7579dbf0f2e457aa39d6ae71454a8dbcec0c4fbddee007551d7c6
'http://archive.ubuntu.com/ubuntu/pool/main/i/iptables/iptables_1.8.4.orig.tar.bz2' iptables_1.8.4.orig.tar.bz2 704312 SHA512:a7faaab58608ffaa51e26e8056551c0e91a49187439d30fcf5cce2800274cc3c0515db6cfba0f4c85613fb80779cf96089b8915db0e89161e9980a6384faebdb
'http://archive.ubuntu.com/ubuntu/pool/main/i/iptables/iptables_1.8.4-3ubuntu2.1.debian.tar.xz' iptables_1.8.4-3ubuntu2.1.debian.tar.xz 126568 SHA512:ed4061c8a59d12ba993a047254d3426a1bd11e09cbaba68e9e2850feef8e5a2f2efa3050e99ec7e50074ccd82337966e90387c5b5ac43663c78f3209e0c6a762
```

### `dpkg` source package: `iputils=3:20190709-3ubuntu1`

Binary Packages:

- `iputils-ping=3:20190709-3ubuntu1`

Licenses: (parsed from: `/usr/share/doc/iputils-ping/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris iputils=3:20190709-3ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/i/iputils/iputils_20190709-3ubuntu1.dsc' iputils_20190709-3ubuntu1.dsc 1573 SHA512:d8c62f0cfebf3b2dfd44fced68a2cf63500c85594798f13ec7dafc8781e4404f0d2b362b3cd4dd1a2878d1a3b8cdb2dcbf52a2e5e542ad41e39301e6d99ceeaf
'http://archive.ubuntu.com/ubuntu/pool/main/i/iputils/iputils_20190709.orig.tar.xz' iputils_20190709.orig.tar.xz 361144 SHA512:51c21b8eaab716b4c878465588645330d38576bb7cef47cd7ba3dbbab8f0054be2bcb6b4a0fc56e80c8e29100603472c36641f8fc5bd95316afb940117a16976
'http://archive.ubuntu.com/ubuntu/pool/main/i/iputils/iputils_20190709-3ubuntu1.debian.tar.xz' iputils_20190709-3ubuntu1.debian.tar.xz 15336 SHA512:ae6e105347177897d11123c7c17288002dfdebc164b8c48038fb7418f680fa74af3ff507e79189403a2cfde925c7cdd246cf5ed4967bdf0bdc950a311e25bcaa
```

### `dpkg` source package: `isl=0.22.1-1`

Binary Packages:

- `libisl22:amd64=0.22.1-1`

Licenses: (parsed from: `/usr/share/doc/libisl22/copyright`)

- `BSD-2-clause`
- `LGPL-2`
- `LGPL-2.1+`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris isl=0.22.1-1
'http://archive.ubuntu.com/ubuntu/pool/main/i/isl/isl_0.22.1-1.dsc' isl_0.22.1-1.dsc 1860 SHA256:9e9925317ef448cf679040edb6572a2874d497f758b613d9fc633bdafab197cb
'http://archive.ubuntu.com/ubuntu/pool/main/i/isl/isl_0.22.1.orig.tar.xz' isl_0.22.1.orig.tar.xz 1676948 SHA256:28658ce0f0bdb95b51fd2eb15df24211c53284f6ca2ac5e897acc3169e55b60f
'http://archive.ubuntu.com/ubuntu/pool/main/i/isl/isl_0.22.1-1.debian.tar.xz' isl_0.22.1-1.debian.tar.xz 25252 SHA256:bbeb62cfc95e51c25448e127c29fa8ac8009a6f471861de28f326bab2404a406
```

### `dpkg` source package: `iso-codes=4.4-1`

Binary Packages:

- `iso-codes=4.4-1`

Licenses: (parsed from: `/usr/share/doc/iso-codes/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris iso-codes=4.4-1
'http://archive.ubuntu.com/ubuntu/pool/main/i/iso-codes/iso-codes_4.4-1.dsc' iso-codes_4.4-1.dsc 1936 SHA256:c5a23261ccd11f56cf398377e1f6590df7ea84586dc5ca966cd2a2421880814b
'http://archive.ubuntu.com/ubuntu/pool/main/i/iso-codes/iso-codes_4.4.orig.tar.xz' iso-codes_4.4.orig.tar.xz 3627156 SHA256:5124ba64e5ce6e1a73c24d1a1cdc42f6a2d0db038791b28ac77aafeb07654e86
'http://archive.ubuntu.com/ubuntu/pool/main/i/iso-codes/iso-codes_4.4-1.debian.tar.xz' iso-codes_4.4-1.debian.tar.xz 23912 SHA256:da078ff222fd3e3d09f00defa33c7941587dd756ad0846d3afef198300769566
```

### `dpkg` source package: `jackd2=1.9.12~dfsg-2ubuntu2`

Binary Packages:

- `libjack-jackd2-0:amd64=1.9.12~dfsg-2ubuntu2`

Licenses: (parsed from: `/usr/share/doc/libjack-jackd2-0/copyright`)

- `BSD-3-clause`
- `Expat`
- `Expat~modrequest`
- `GPL-2`
- `GPL-2+`
- `GPL-2~either`
- `GPL-2~jack-audio-connection-kit`
- `GPL-2~jackd2`
- `GPL-2~or`
- `GPL-3`
- `GPL-3+`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `None`
- `public-domain~Kroon`

Source:

```console
$ apt-get source -qq --print-uris jackd2=1.9.12~dfsg-2ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/j/jackd2/jackd2_1.9.12%7edfsg-2ubuntu2.dsc' jackd2_1.9.12~dfsg-2ubuntu2.dsc 1899 SHA256:be67da27ea2f189af515b489aca05c8a593c4818c0c97860949288ea929cb24f
'http://archive.ubuntu.com/ubuntu/pool/main/j/jackd2/jackd2_1.9.12%7edfsg.orig.tar.gz' jackd2_1.9.12~dfsg.orig.tar.gz 1147874 SHA256:059741090d548d1888d34c90647e3ac1650bbee84990dceffcb5144b8f8cd539
'http://archive.ubuntu.com/ubuntu/pool/main/j/jackd2/jackd2_1.9.12%7edfsg-2ubuntu2.debian.tar.xz' jackd2_1.9.12~dfsg-2ubuntu2.debian.tar.xz 45228 SHA256:d1f1677e94c34d342463cbe1d04e16d32f44915e773cf45ca4037482302100a7
```

### `dpkg` source package: `java-atk-wrapper=0.37.1-1`

Binary Packages:

- `libatk-wrapper-java=0.37.1-1`
- `libatk-wrapper-java-jni:amd64=0.37.1-1`

Licenses: (parsed from: `/usr/share/doc/libatk-wrapper-java/copyright`, `/usr/share/doc/libatk-wrapper-java-jni/copyright`)

- `GPL-3`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris java-atk-wrapper=0.37.1-1
'http://archive.ubuntu.com/ubuntu/pool/main/j/java-atk-wrapper/java-atk-wrapper_0.37.1-1.dsc' java-atk-wrapper_0.37.1-1.dsc 2370 SHA256:89876805ad0ee9b1e8d00bf5c6c94af831f9e690e233c9a9301a52abc0be179f
'http://archive.ubuntu.com/ubuntu/pool/main/j/java-atk-wrapper/java-atk-wrapper_0.37.1.orig.tar.xz' java-atk-wrapper_0.37.1.orig.tar.xz 310920 SHA256:5462c1e2b04f87290cb391f2d56c4a8c587a754587338ddbe9706afeed97c807
'http://archive.ubuntu.com/ubuntu/pool/main/j/java-atk-wrapper/java-atk-wrapper_0.37.1-1.debian.tar.xz' java-atk-wrapper_0.37.1-1.debian.tar.xz 5356 SHA256:bfd928e3a6badc4be8697e3b24d533ee4ecdc4ad773038ba09e4dc43cab81da5
```

### `dpkg` source package: `java-common=0.72`

Binary Packages:

- `java-common=0.72`

Licenses: (parsed from: `/usr/share/doc/java-common/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris java-common=0.72
'http://archive.ubuntu.com/ubuntu/pool/main/j/java-common/java-common_0.72.dsc' java-common_0.72.dsc 1985 SHA256:ee412fc8f12e61de5ed18f740277fcc45a7ef7ba83d783d57514775122fe3cd7
'http://archive.ubuntu.com/ubuntu/pool/main/j/java-common/java-common_0.72.tar.xz' java-common_0.72.tar.xz 13180 SHA256:ef8687995572fc889d16de4c0bb29436b4c117ae1b2c9768437e790ed4d4f28f
```

### `dpkg` source package: `jbig2dec=0.18-1ubuntu1`

Binary Packages:

- `libjbig2dec0:amd64=0.18-1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libjbig2dec0/copyright`)

- `AGPL-3+`
- `BSD-2-clause`
- `GPL-3`
- `GPL-3+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `pubic-domain`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris jbig2dec=0.18-1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/j/jbig2dec/jbig2dec_0.18-1ubuntu1.dsc' jbig2dec_0.18-1ubuntu1.dsc 2128 SHA256:9c5188df694edf5b9523e67cfafca4f6130cb9210184cc170fbd0fc28dd771fe
'http://archive.ubuntu.com/ubuntu/pool/main/j/jbig2dec/jbig2dec_0.18.orig.tar.gz' jbig2dec_0.18.orig.tar.gz 148563 SHA256:3be6eb8105f6dcc8a7d29d6f2b4dc9205c164a412ad940294cedf0d7cc530487
'http://archive.ubuntu.com/ubuntu/pool/main/j/jbig2dec/jbig2dec_0.18-1ubuntu1.debian.tar.xz' jbig2dec_0.18-1ubuntu1.debian.tar.xz 20812 SHA256:9aecb1caaf256a9d1194db01dd1f10006c83420150f204855bf23ec4a80a4836
```

### `dpkg` source package: `jbigkit=2.1-3.1ubuntu0.20.04.1`

Binary Packages:

- `libjbig0:amd64=2.1-3.1ubuntu0.20.04.1`

Licenses: (parsed from: `/usr/share/doc/libjbig0/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris jbigkit=2.1-3.1ubuntu0.20.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/j/jbigkit/jbigkit_2.1-3.1ubuntu0.20.04.1.dsc' jbigkit_2.1-3.1ubuntu0.20.04.1.dsc 1796 SHA512:c7c24dd450b988659ccfc7fb08be2a316b49cc9ff789137759d3eca38186e3212d1821aa65d4e1d98a8c20efd9bbcedf79a4b097fdeb72c275d4e80577d8a573
'http://archive.ubuntu.com/ubuntu/pool/main/j/jbigkit/jbigkit_2.1.orig.tar.gz' jbigkit_2.1.orig.tar.gz 438710 SHA512:c4127480470ef90db1ef3bd2caa444df10b50ed8df0bc9997db7612cb48b49278baf44965028f1807a21028eb965d677e015466306b44683c4ec75a23e1922cf
'http://archive.ubuntu.com/ubuntu/pool/main/j/jbigkit/jbigkit_2.1-3.1ubuntu0.20.04.1.debian.tar.xz' jbigkit_2.1-3.1ubuntu0.20.04.1.debian.tar.xz 9804 SHA512:68f3c71ce89212aaa28a83721d5e1ede41aab92a4e066779db5c8f512ad569e565a8b9d2e8e65e36e71d4d19e85c07cc0e9d28762c002d1185963b01493fc593
```

### `dpkg` source package: `json-c=0.13.1+dfsg-7ubuntu0.3`

Binary Packages:

- `libjson-c4:amd64=0.13.1+dfsg-7ubuntu0.3`

Licenses: (parsed from: `/usr/share/doc/libjson-c4/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris json-c=0.13.1+dfsg-7ubuntu0.3
'http://archive.ubuntu.com/ubuntu/pool/main/j/json-c/json-c_0.13.1%2bdfsg-7ubuntu0.3.dsc' json-c_0.13.1+dfsg-7ubuntu0.3.dsc 2174 SHA512:7c10b379d1783a8d1b529cec0a6d59ec3ae12f50867afeff468afe9de5b7c0053e8e9c8e19f18f74bcc5eba9cb201e674de31ef438bb05c36ccff0b20c1afb3e
'http://archive.ubuntu.com/ubuntu/pool/main/j/json-c/json-c_0.13.1%2bdfsg.orig.tar.gz' json-c_0.13.1+dfsg.orig.tar.gz 564147 SHA512:4b30602a71181319aa1156e39706ca1693484ee4efc9e20c630381a1219882ea62b458fbd473c1d8bfc96d950b8b91787f522886b1f28dcde4bc4d0a876413cf
'http://archive.ubuntu.com/ubuntu/pool/main/j/json-c/json-c_0.13.1%2bdfsg-7ubuntu0.3.debian.tar.xz' json-c_0.13.1+dfsg-7ubuntu0.3.debian.tar.xz 10036 SHA512:cc6e4a5567d697ed684ce0ced78819ffb9dd2d899673e977dcc640e1e19f577e1a6860b712c78071368fa3cf8e0fb601214a65926d5ac449df47afb1b7a2b500
```

### `dpkg` source package: `json-glib=1.4.4-2ubuntu2`

Binary Packages:

- `libjson-glib-1.0-0:amd64=1.4.4-2ubuntu2`
- `libjson-glib-1.0-common=1.4.4-2ubuntu2`

Licenses: (parsed from: `/usr/share/doc/libjson-glib-1.0-0/copyright`, `/usr/share/doc/libjson-glib-1.0-common/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris json-glib=1.4.4-2ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/j/json-glib/json-glib_1.4.4-2ubuntu2.dsc' json-glib_1.4.4-2ubuntu2.dsc 2170 SHA256:32dd5c725a34ed66e4f92bfc6a01b825c1f64bb80783cd3704c4d5811177680c
'http://archive.ubuntu.com/ubuntu/pool/main/j/json-glib/json-glib_1.4.4.orig.tar.xz' json-glib_1.4.4.orig.tar.xz 150440 SHA256:d37052132c7fd2f12bda8f2a4d6829b6de36378772195920cccfdda2e0ef5ad7
'http://archive.ubuntu.com/ubuntu/pool/main/j/json-glib/json-glib_1.4.4-2ubuntu2.debian.tar.xz' json-glib_1.4.4-2ubuntu2.debian.tar.xz 8256 SHA256:4b1cb46ffd17ac84d670e66e1865e6e33ded45a9ec31b3198cc72949b639c1a4
```

### `dpkg` source package: `jsp-api=2.3.4-2`

Binary Packages:

- `libjsp-api-java=2.3.4-2`

Licenses: (parsed from: `/usr/share/doc/libjsp-api-java/copyright`)

- `Apache-2.0`
- `CDDL-1.1`
- `GPL-2`
- `GPL-2 with Classpath exception`

Source:

```console
$ apt-get source -qq --print-uris jsp-api=2.3.4-2
'http://archive.ubuntu.com/ubuntu/pool/universe/j/jsp-api/jsp-api_2.3.4-2.dsc' jsp-api_2.3.4-2.dsc 2065 SHA256:12fe7e32d736c8e45c00333d1455161ef5ae1d025a82e909bdfa89fce6ec8081
'http://archive.ubuntu.com/ubuntu/pool/universe/j/jsp-api/jsp-api_2.3.4.orig.tar.xz' jsp-api_2.3.4.orig.tar.xz 85592 SHA256:2fab7216496da3e0d87937786ab67af8168bd73bac1ad52b074881dea717509d
'http://archive.ubuntu.com/ubuntu/pool/universe/j/jsp-api/jsp-api_2.3.4-2.debian.tar.xz' jsp-api_2.3.4-2.debian.tar.xz 8544 SHA256:32acce00a4005115e05af125d6a70a90ebbad9fc18491e4c8ec8e2b71029eeb0
```

### `dpkg` source package: `keyutils=1.6-6ubuntu1.1`

Binary Packages:

- `libkeyutils1:amd64=1.6-6ubuntu1.1`

Licenses: (parsed from: `/usr/share/doc/libkeyutils1/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris keyutils=1.6-6ubuntu1.1
'http://archive.ubuntu.com/ubuntu/pool/main/k/keyutils/keyutils_1.6-6ubuntu1.1.dsc' keyutils_1.6-6ubuntu1.1.dsc 2185 SHA512:268bf05775176fd5550b4e66a4b9132e0be3f54ab02b77b4995f3b053191ea5d157bc38bf53d067008b311751ba3bad02b463538b6ce209403b629480c42fc38
'http://archive.ubuntu.com/ubuntu/pool/main/k/keyutils/keyutils_1.6.orig.tar.bz2' keyutils_1.6.orig.tar.bz2 93973 SHA512:ee50da165099ea26904066d24b27c5165cb1eb78df6768cba3a534aa318a5c8d926ec6e5322a38c8cedaa768cd79bdcb26ef918aa8447df2e5dfbbe7b8f200ff
'http://archive.ubuntu.com/ubuntu/pool/main/k/keyutils/keyutils_1.6-6ubuntu1.1.debian.tar.xz' keyutils_1.6-6ubuntu1.1.debian.tar.xz 14556 SHA512:300ed4c9626de95616a7c799f14d4f8bf7dc0b765d1751d3c9d60f86b7c60801bfbb97bf26c5d0ab39e5e41d5f3021ca870748f9555433b0e6c4ba261f475c3b
```

### `dpkg` source package: `kmod=27-1ubuntu2.1`

Binary Packages:

- `libkmod2:amd64=27-1ubuntu2.1`

Licenses: (parsed from: `/usr/share/doc/libkmod2/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris kmod=27-1ubuntu2.1
'http://archive.ubuntu.com/ubuntu/pool/main/k/kmod/kmod_27-1ubuntu2.1.dsc' kmod_27-1ubuntu2.1.dsc 1776 SHA512:ea48d8b35ad95bd8d12be6d8b2fb1c268bf6bede9a4ac4dca75404b5fa976718f940f01a1ed7c28a18617011a009139e36dfb51d81fa52bf748917cae3f3973a
'http://archive.ubuntu.com/ubuntu/pool/main/k/kmod/kmod_27.orig.tar.xz' kmod_27.orig.tar.xz 249572 SHA512:4f6f1fe3cb617c2f36f8162149718fef71005f4e8164dcdaa3c91f4c1360596ea519913dad0c8884dd22120905e42c3b251ceee1a80ea147887decff6a6b117c
'http://archive.ubuntu.com/ubuntu/pool/main/k/kmod/kmod_27-1ubuntu2.1.debian.tar.xz' kmod_27-1ubuntu2.1.debian.tar.xz 17028 SHA512:2b3a7b6e79653b260844acaba9fe27bbda68f9306fc89fd9c2ff80ae4f49fc4f93a60144298fbbc18df27f1e489934af3faa65c461ad5053b6d07cc34cca7cdd
```

### `dpkg` source package: `krb5=1.17-6ubuntu4.7`

Binary Packages:

- `krb5-locales=1.17-6ubuntu4.7`
- `libgssapi-krb5-2:amd64=1.17-6ubuntu4.7`
- `libk5crypto3:amd64=1.17-6ubuntu4.7`
- `libkrb5-3:amd64=1.17-6ubuntu4.7`
- `libkrb5support0:amd64=1.17-6ubuntu4.7`

Licenses: (parsed from: `/usr/share/doc/krb5-locales/copyright`, `/usr/share/doc/libgssapi-krb5-2/copyright`, `/usr/share/doc/libk5crypto3/copyright`, `/usr/share/doc/libkrb5-3/copyright`, `/usr/share/doc/libkrb5support0/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris krb5=1.17-6ubuntu4.7
'http://archive.ubuntu.com/ubuntu/pool/main/k/krb5/krb5_1.17-6ubuntu4.7.dsc' krb5_1.17-6ubuntu4.7.dsc 3666 SHA512:5777de193825a997ecddb9058cb9e628d61797a7c2fd5d57c5daca99b016c710c6529a6e4c137f55b37252f75cb335cea719f7bfa19482fe5fed4672d2159150
'http://archive.ubuntu.com/ubuntu/pool/main/k/krb5/krb5_1.17.orig.tar.gz' krb5_1.17.orig.tar.gz 8761763 SHA512:7462a578b936bd17f155a362dbb5d388e157a80a096549028be6c55400b11361c7f8a28e424fd5674801873651df4e694d536cae66728b7ae5e840e532358c52
'http://archive.ubuntu.com/ubuntu/pool/main/k/krb5/krb5_1.17-6ubuntu4.7.debian.tar.xz' krb5_1.17-6ubuntu4.7.debian.tar.xz 154240 SHA512:56524aa9f761809e1176de35be94cb5888afecb0a91e463cca7aafc880aff79850e22ff4360d691bf479d7e28f1a7dce9fc796bc45248c07af3e0c420e810d0a
```

### `dpkg` source package: `lame=3.100-3`

Binary Packages:

- `libmp3lame0:amd64=3.100-3`

Licenses: (parsed from: `/usr/share/doc/libmp3lame0/copyright`)

- `BSD-3-clause`
- `GPL-1`
- `GPL-1+`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `zlib/libpng`

Source:

```console
$ apt-get source -qq --print-uris lame=3.100-3
'http://archive.ubuntu.com/ubuntu/pool/main/l/lame/lame_3.100-3.dsc' lame_3.100-3.dsc 2143 SHA256:5dec57a62002607b803b8eb659f0ed1079350de4ac9f8f8e52faa3d1e8fca08b
'http://archive.ubuntu.com/ubuntu/pool/main/l/lame/lame_3.100.orig.tar.gz' lame_3.100.orig.tar.gz 1524133 SHA256:ddfe36cab873794038ae2c1210557ad34857a4b6bdc515785d1da9e175b1da1e
'http://archive.ubuntu.com/ubuntu/pool/main/l/lame/lame_3.100-3.debian.tar.xz' lame_3.100-3.debian.tar.xz 12236 SHA256:85b6685d3c3c86a1331fa63e3efbd229acfcee360cd530dbdb6ea42b830d50d3
```

### `dpkg` source package: `language-pack-en-base=1:20.04+20220818`

Binary Packages:

- `language-pack-en-base=1:20.04+20220818`

Licenses: (parsed from: `/usr/share/doc/language-pack-en-base/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris language-pack-en-base=1:20.04+20220818
'http://archive.ubuntu.com/ubuntu/pool/main/l/language-pack-en-base/language-pack-en-base_20.04%2b20220818.dsc' language-pack-en-base_20.04+20220818.dsc 1555 SHA512:6b1e24fdc5c81a66bf9ec0073a6bdf772ea4dc55794408f12721955660c76061900b44f35242998bbff61e67f51ffb3dc7449ab8e242d50e7855b979d4c453ef
'http://archive.ubuntu.com/ubuntu/pool/main/l/language-pack-en-base/language-pack-en-base_20.04%2b20220818.tar.xz' language-pack-en-base_20.04+20220818.tar.xz 1617316 SHA512:cb2bc0059e14a6f6bdb79d199f0c0e89487433ddaaff085c8f1d4ba17fe554ee04cd307561320fba2942ab2642bf780d4ddfa5301e1fbf52b2f5460afd9b7ad2
```

### `dpkg` source package: `language-pack-en=1:20.04+20220818`

Binary Packages:

- `language-pack-en=1:20.04+20220818`

Licenses: (parsed from: `/usr/share/doc/language-pack-en/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris language-pack-en=1:20.04+20220818
'http://archive.ubuntu.com/ubuntu/pool/main/l/language-pack-en/language-pack-en_20.04%2b20220818.dsc' language-pack-en_20.04+20220818.dsc 1516 SHA512:1cd9b050905297ce6d03e2e97295bac25c3926a4ba675067c4661f3c30836fbc640baea86212b75874580dc802b835ac638278d556b689baf00b3acddc68da2e
'http://archive.ubuntu.com/ubuntu/pool/main/l/language-pack-en/language-pack-en_20.04%2b20220818.tar.xz' language-pack-en_20.04+20220818.tar.xz 8096 SHA512:b2c8be682eb36312928bc142415816b16d075727c3aefb56f536c95f79dad1459dae1b5139d943ef5f8eec0e2525de8e484f10ef2a4ba2ca374f92fc6eaaa5fd
```

### `dpkg` source package: `language-pack-fr-base=1:20.04+20220818`

Binary Packages:

- `language-pack-fr-base=1:20.04+20220818`

Licenses: (parsed from: `/usr/share/doc/language-pack-fr-base/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris language-pack-fr-base=1:20.04+20220818
'http://archive.ubuntu.com/ubuntu/pool/main/l/language-pack-fr-base/language-pack-fr-base_20.04%2b20220818.dsc' language-pack-fr-base_20.04+20220818.dsc 1555 SHA512:9553fad5afb217c7ff3a9807d4d4c30ede1f7853978a22297c0934fe21efea0101daca5d387cb01fbad53e53ced3198f3f919da13618cb93df53fe631097d8c5
'http://archive.ubuntu.com/ubuntu/pool/main/l/language-pack-fr-base/language-pack-fr-base_20.04%2b20220818.tar.xz' language-pack-fr-base_20.04+20220818.tar.xz 3716512 SHA512:d8b46bd5d816ed394a53a1247ed2bebfbc6ba727e0e12a725a99df0124df2ffe58f02c6631d8f8da18a80c48b94afc3fb63fab47be94dea1a99952ffe86d2f18
```

### `dpkg` source package: `language-pack-fr=1:20.04+20220818`

Binary Packages:

- `language-pack-fr=1:20.04+20220818`

Licenses: (parsed from: `/usr/share/doc/language-pack-fr/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris language-pack-fr=1:20.04+20220818
'http://archive.ubuntu.com/ubuntu/pool/main/l/language-pack-fr/language-pack-fr_20.04%2b20220818.dsc' language-pack-fr_20.04+20220818.dsc 1516 SHA512:d8341349cac0827e85378f416cd739000faeb161f26e9c043032c79cd6a12fa6e42446f2f8ada3167051268da70134ea53336ef5df262286b39fb84e72e8eb0a
'http://archive.ubuntu.com/ubuntu/pool/main/l/language-pack-fr/language-pack-fr_20.04%2b20220818.tar.xz' language-pack-fr_20.04+20220818.tar.xz 8092 SHA512:cc39be407dea3d17d3547d21ff7f1689e9e7e1485725d2ac770907b443fa9671bcacf99d6db8f512172f16ba20829981a6557d4981ae4dbad0e27a6bcb02e678
```

### `dpkg` source package: `lcms2=2.9-4`

Binary Packages:

- `liblcms2-2:amd64=2.9-4`

Licenses: (parsed from: `/usr/share/doc/liblcms2-2/copyright`)

- `GPL-2`
- `GPL-2+`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris lcms2=2.9-4
'http://archive.ubuntu.com/ubuntu/pool/main/l/lcms2/lcms2_2.9-4.dsc' lcms2_2.9-4.dsc 1956 SHA256:6db871353515693e8813911a8f81668b92e8c09fa9e6752e701fa8b14247775d
'http://archive.ubuntu.com/ubuntu/pool/main/l/lcms2/lcms2_2.9.orig.tar.gz' lcms2_2.9.orig.tar.gz 10974649 SHA256:48c6fdf98396fa245ed86e622028caf49b96fa22f3e5734f853f806fbc8e7d20
'http://archive.ubuntu.com/ubuntu/pool/main/l/lcms2/lcms2_2.9-4.debian.tar.xz' lcms2_2.9-4.debian.tar.xz 10748 SHA256:3dd811c431bed101269937299d28708dfe91f32070cf9786680bec26f408b65b
```

### `dpkg` source package: `libaacs=0.9.0-2`

Binary Packages:

- `libaacs0:amd64=0.9.0-2`

Licenses: (parsed from: `/usr/share/doc/libaacs0/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris libaacs=0.9.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/liba/libaacs/libaacs_0.9.0-2.dsc' libaacs_0.9.0-2.dsc 2063 SHA256:06e778d7802214f87a5fcc695593b557e8acdc6989fb9b0988670c41e38ace49
'http://archive.ubuntu.com/ubuntu/pool/universe/liba/libaacs/libaacs_0.9.0.orig.tar.bz2' libaacs_0.9.0.orig.tar.bz2 316323 SHA256:47e0bdc9c9f0f6146ed7b4cc78ed1527a04a537012cf540cf5211e06a248bace
'http://archive.ubuntu.com/ubuntu/pool/universe/liba/libaacs/libaacs_0.9.0-2.debian.tar.xz' libaacs_0.9.0-2.debian.tar.xz 4080 SHA256:3171c13388e0ce79711c6c71e493e7fbcdcc2fb0a66e8428bf9a45ebebfd4857
```

### `dpkg` source package: `libabw=0.1.3-1build1`

Binary Packages:

- `libabw-0.1-1:amd64=0.1.3-1build1`

Licenses: (parsed from: `/usr/share/doc/libabw-0.1-1/copyright`)

- `GPL-3`
- `LGPL-3`
- `MPL-1.1 | GPL-3 | LGPL-3`
- `MPL-2.0`

Source:

```console
$ apt-get source -qq --print-uris libabw=0.1.3-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libabw/libabw_0.1.3-1build1.dsc' libabw_0.1.3-1build1.dsc 2012 SHA256:ee42e1648eb8b4a22460611551458ff5c005bed8626a86f4451a8afa248547be
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libabw/libabw_0.1.3.orig.tar.xz' libabw_0.1.3.orig.tar.xz 318808 SHA256:e763a9dc21c3d2667402d66e202e3f8ef4db51b34b79ef41f56cacb86dcd6eed
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libabw/libabw_0.1.3-1build1.debian.tar.xz' libabw_0.1.3-1build1.debian.tar.xz 13068 SHA256:9f55446b08384504959248994336c27bb799b0b0af01641cab60e115fbdf0449
```

### `dpkg` source package: `libass=1:0.14.0-2`

Binary Packages:

- `libass9:amd64=1:0.14.0-2`

Licenses: (parsed from: `/usr/share/doc/libass9/copyright`)

- `GPL-2`
- `GPL-2+`
- `ISC`
- `other-1`

Source:

```console
$ apt-get source -qq --print-uris libass=1:0.14.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/liba/libass/libass_0.14.0-2.dsc' libass_0.14.0-2.dsc 2093 SHA256:efa8465d4acb8352fdb53b503b90076704b1930286ec1f339aaf5b2045316479
'http://archive.ubuntu.com/ubuntu/pool/universe/liba/libass/libass_0.14.0.orig.tar.xz' libass_0.14.0.orig.tar.xz 356256 SHA256:881f2382af48aead75b7a0e02e65d88c5ebd369fe46bc77d9270a94aa8fd38a2
'http://archive.ubuntu.com/ubuntu/pool/universe/liba/libass/libass_0.14.0-2.debian.tar.xz' libass_0.14.0-2.debian.tar.xz 5804 SHA256:f585191f54caf8ddf1608458b4146e62472e4f5713416eea7a48ae1c5647abed
```

### `dpkg` source package: `libassuan=2.5.3-7ubuntu2`

Binary Packages:

- `libassuan0:amd64=2.5.3-7ubuntu2`

Licenses: (parsed from: `/usr/share/doc/libassuan0/copyright`)

- `GAP`
- `GAP~FSF`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with libtool exception`
- `GPL-3`
- `GPL-3+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `LGPL-3`
- `LGPL-3+`

Source:

```console
$ apt-get source -qq --print-uris libassuan=2.5.3-7ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libassuan/libassuan_2.5.3-7ubuntu2.dsc' libassuan_2.5.3-7ubuntu2.dsc 2647 SHA256:014fbd728fc1d0e954ade2a8d975539fc00d455261ca14a88d78b9e29625ee41
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libassuan/libassuan_2.5.3.orig.tar.bz2' libassuan_2.5.3.orig.tar.bz2 572348 SHA256:91bcb0403866b4e7c4bc1cc52ed4c364a9b5414b3994f718c70303f7f765e702
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libassuan/libassuan_2.5.3.orig.tar.bz2.asc' libassuan_2.5.3.orig.tar.bz2.asc 952 SHA256:53b16a6619a2690b4f22da645a1d0c14b5664825c87b165ca5bd0de32607888a
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libassuan/libassuan_2.5.3-7ubuntu2.debian.tar.xz' libassuan_2.5.3-7ubuntu2.debian.tar.xz 13936 SHA256:586836fdfffdc58b4d47548d0f6e54593daa78098c6276a788d8b66c3616e233
```

### `dpkg` source package: `libasyncns=0.8-6`

Binary Packages:

- `libasyncns0:amd64=0.8-6`

Licenses: (parsed from: `/usr/share/doc/libasyncns0/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris libasyncns=0.8-6
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libasyncns/libasyncns_0.8-6.dsc' libasyncns_0.8-6.dsc 1921 SHA256:d6a3cccafadceda0bd1542c6325c6238ec34a8ff85276d6f2e5914e282c67dc6
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libasyncns/libasyncns_0.8.orig.tar.gz' libasyncns_0.8.orig.tar.gz 341591 SHA256:4f1a66e746cbe54ff3c2fbada5843df4fbbbe7481d80be003e8d11161935ab74
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libasyncns/libasyncns_0.8-6.debian.tar.xz' libasyncns_0.8-6.debian.tar.xz 4564 SHA256:69b23a155b8a3da3bf68b1e440283e117c55e92bd3b4aa308605fe3f1164485e
```

### `dpkg` source package: `libauthen-sasl-perl=2.1600-1`

Binary Packages:

- `libauthen-sasl-perl=2.1600-1`

Licenses: (parsed from: `/usr/share/doc/libauthen-sasl-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libauthen-sasl-perl=2.1600-1
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libauthen-sasl-perl/libauthen-sasl-perl_2.1600-1.dsc' libauthen-sasl-perl_2.1600-1.dsc 2313 SHA256:ddb85abf950c2e63d2403876f1dabb5c00c2390dc7e95e3b6124330c25ca02a2
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libauthen-sasl-perl/libauthen-sasl-perl_2.1600.orig.tar.gz' libauthen-sasl-perl_2.1600.orig.tar.gz 45129 SHA256:6614fa7518f094f853741b63c73f3627168c5d3aca89b1d02b1016dc32854e09
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libauthen-sasl-perl/libauthen-sasl-perl_2.1600-1.debian.tar.xz' libauthen-sasl-perl_2.1600-1.debian.tar.xz 3976 SHA256:edc85675ad2b6c97e4b6df5b4305d1f7afcd6b0af6407c3a4dea5ac58f9750e4
```

### `dpkg` source package: `libavc1394=0.5.4-5`

Binary Packages:

- `libavc1394-0:amd64=0.5.4-5`

Licenses: (parsed from: `/usr/share/doc/libavc1394-0/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris libavc1394=0.5.4-5
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libavc1394/libavc1394_0.5.4-5.dsc' libavc1394_0.5.4-5.dsc 2122 SHA256:9faa03aa953eecfa46bc4fc98f7c8c2265a1d8cf0b26f04137e196e68b5f2176
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libavc1394/libavc1394_0.5.4.orig.tar.gz' libavc1394_0.5.4.orig.tar.gz 341679 SHA256:7cb1ff09506ae911ca9860bef4af08c2403f3e131f6c913a2cbd6ddca4215b53
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libavc1394/libavc1394_0.5.4-5.debian.tar.xz' libavc1394_0.5.4-5.debian.tar.xz 6600 SHA256:783dde153ec5287c8ca278e0911163ecf4c568f95ac0a9c49307fdd941659ff1
```

### `dpkg` source package: `libbdplus=0.1.2-3`

Binary Packages:

- `libbdplus0:amd64=0.1.2-3`

Licenses: (parsed from: `/usr/share/doc/libbdplus0/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris libbdplus=0.1.2-3
'http://archive.ubuntu.com/ubuntu/pool/universe/libb/libbdplus/libbdplus_0.1.2-3.dsc' libbdplus_0.1.2-3.dsc 2084 SHA256:18cc7b1a72e60b7d6bc39a39ea3908ae2973ee7d221f73596a120b9052ad3b22
'http://archive.ubuntu.com/ubuntu/pool/universe/libb/libbdplus/libbdplus_0.1.2.orig.tar.bz2' libbdplus_0.1.2.orig.tar.bz2 319828 SHA256:a631cae3cd34bf054db040b64edbfc8430936e762eb433b1789358ac3d3dc80a
'http://archive.ubuntu.com/ubuntu/pool/universe/libb/libbdplus/libbdplus_0.1.2-3.debian.tar.xz' libbdplus_0.1.2-3.debian.tar.xz 2780 SHA256:a7b93a8a9920911dcd81609aa7ddfeea0b115a296c065be9e17be4797dffa87c
```

### `dpkg` source package: `libbluray=1:1.2.0-1`

Binary Packages:

- `libbluray2:amd64=1:1.2.0-1`

Licenses: (parsed from: `/usr/share/doc/libbluray2/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `MPL-1.0`
- `custom`

Source:

```console
$ apt-get source -qq --print-uris libbluray=1:1.2.0-1
'http://archive.ubuntu.com/ubuntu/pool/universe/libb/libbluray/libbluray_1.2.0-1.dsc' libbluray_1.2.0-1.dsc 2420 SHA256:535f4c30f3f8eea2f4e4b0d998e8900c26bad5e6285ac9ef616c433f92470ab9
'http://archive.ubuntu.com/ubuntu/pool/universe/libb/libbluray/libbluray_1.2.0.orig.tar.bz2' libbluray_1.2.0.orig.tar.bz2 747265 SHA256:cd41ea06fd2512a77ebf63872873641908ef81ce2fe4e4c842f6035a47696c11
'http://archive.ubuntu.com/ubuntu/pool/universe/libb/libbluray/libbluray_1.2.0-1.debian.tar.xz' libbluray_1.2.0-1.debian.tar.xz 17240 SHA256:a94a021ae1fe508488334c20f1172e4df6b9e76e7ffba47f6ed2d2b9893b2498
```

### `dpkg` source package: `libbs2b=3.1.0+dfsg-2.2build1`

Binary Packages:

- `libbs2b0:amd64=3.1.0+dfsg-2.2build1`

Licenses: (parsed from: `/usr/share/doc/libbs2b0/copyright`)

- `FSF-unlimited`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `MIT`
- `MIT+FSF-public`

Source:

```console
$ apt-get source -qq --print-uris libbs2b=3.1.0+dfsg-2.2build1
'http://archive.ubuntu.com/ubuntu/pool/universe/libb/libbs2b/libbs2b_3.1.0%2bdfsg-2.2build1.dsc' libbs2b_3.1.0+dfsg-2.2build1.dsc 2002 SHA256:9daaaa41db6f1b1f45e89e1dfc0ce41a0c11bee56d1a271d653e8063852ad0d3
'http://archive.ubuntu.com/ubuntu/pool/universe/libb/libbs2b/libbs2b_3.1.0%2bdfsg.orig.tar.gz' libbs2b_3.1.0+dfsg.orig.tar.gz 330675 SHA256:c23faf614f787342c1a1a40f83064f2e5a49391733c029dc31d09fba759cee0a
'http://archive.ubuntu.com/ubuntu/pool/universe/libb/libbs2b/libbs2b_3.1.0%2bdfsg-2.2build1.debian.tar.xz' libbs2b_3.1.0+dfsg-2.2build1.debian.tar.xz 4672 SHA256:05f690783170f7920717ce1548107d38490e48bcca8237997735550bca472f03
```

### `dpkg` source package: `libbsd=0.10.0-1`

Binary Packages:

- `libbsd0:amd64=0.10.0-1`

Licenses: (parsed from: `/usr/share/doc/libbsd0/copyright`)

- `BSD-2-clause`
- `BSD-2-clause-NetBSD`
- `BSD-2-clause-author`
- `BSD-2-clause-verbatim`
- `BSD-3-clause`
- `BSD-3-clause-John-Birrell`
- `BSD-3-clause-Regents`
- `BSD-3-clause-author`
- `BSD-4-clause-Christopher-G-Demetriou`
- `BSD-4-clause-Niels-Provos`
- `BSD-5-clause-Peter-Wemm`
- `Beerware`
- `Expat`
- `ISC`
- `ISC-Original`
- `public-domain`
- `public-domain-Colin-Plumb`

Source:

```console
$ apt-get source -qq --print-uris libbsd=0.10.0-1
'http://archive.ubuntu.com/ubuntu/pool/main/libb/libbsd/libbsd_0.10.0-1.dsc' libbsd_0.10.0-1.dsc 2197 SHA256:7c05e2c73658f64cbd4e1762b716cc7c4c1d68391191e82c7d266a351430edd6
'http://archive.ubuntu.com/ubuntu/pool/main/libb/libbsd/libbsd_0.10.0.orig.tar.xz' libbsd_0.10.0.orig.tar.xz 393576 SHA256:34b8adc726883d0e85b3118fa13605e179a62b31ba51f676136ecb2d0bc1a887
'http://archive.ubuntu.com/ubuntu/pool/main/libb/libbsd/libbsd_0.10.0.orig.tar.xz.asc' libbsd_0.10.0.orig.tar.xz.asc 833 SHA256:4362f6d811ffc06659ac5cf777d8d01157bedfc28720b41fb485afb0a5acc0c7
'http://archive.ubuntu.com/ubuntu/pool/main/libb/libbsd/libbsd_0.10.0-1.debian.tar.xz' libbsd_0.10.0-1.debian.tar.xz 16660 SHA256:4cf37d6d5b72702b31b07384612e07173e94e081feef71fec206f86ab38f2411
```

### `dpkg` source package: `libcaca=0.99.beta19-2.1ubuntu1.20.04.2`

Binary Packages:

- `libcaca0:amd64=0.99.beta19-2.1ubuntu1.20.04.2`

Licenses: (parsed from: `/usr/share/doc/libcaca0/copyright`)

- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris libcaca=0.99.beta19-2.1ubuntu1.20.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcaca/libcaca_0.99.beta19-2.1ubuntu1.20.04.2.dsc' libcaca_0.99.beta19-2.1ubuntu1.20.04.2.dsc 2363 SHA512:844c7f18d2e731c2c1a78bdb7461fa5bd4abde7476264a7767f67fedce6cac36a53027166e56da9518a51ffea0637d86f7da6ba406558a4b897d33742922ca20
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcaca/libcaca_0.99.beta19.orig.tar.gz' libcaca_0.99.beta19.orig.tar.gz 1203495 SHA512:780fc7684d40207cc10df3f87d6d8f1d47ddfffa0e76e41a5ce671b82d5c7f090facb054c3d49ca7c4ea1a619625bb9085ce52f837f50792b4a2d776a4c68e15
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcaca/libcaca_0.99.beta19-2.1ubuntu1.20.04.2.debian.tar.xz' libcaca_0.99.beta19-2.1ubuntu1.20.04.2.debian.tar.xz 16176 SHA512:423c5e26004c64f3ae3840e890ef46560638ae83d61af7ec42732d692f4d9b6e397bb2ad60d6bfa7da0f613767e9ec5b2d287eb35bf0f029a38905639e52cce8
```

### `dpkg` source package: `libcanberra=0.30-7ubuntu1`

Binary Packages:

- `libcanberra0:amd64=0.30-7ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libcanberra0/copyright`)

- `LGPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libcanberra=0.30-7ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcanberra/libcanberra_0.30-7ubuntu1.dsc' libcanberra_0.30-7ubuntu1.dsc 2618 SHA256:a5d220335e3449fdeea8a2083116dc68a95a9119fbfa99352312666319217bc5
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcanberra/libcanberra_0.30.orig.tar.xz' libcanberra_0.30.orig.tar.xz 318960 SHA256:c2b671e67e0c288a69fc33dc1b6f1b534d07882c2aceed37004bf48c601afa72
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcanberra/libcanberra_0.30-7ubuntu1.debian.tar.xz' libcanberra_0.30-7ubuntu1.debian.tar.xz 11080 SHA256:e9e5902961fe438ce422ff9f54d4a9d9437013c6282145fd9e2a0ed2fca2aa43
```

### `dpkg` source package: `libcap-ng=0.7.9-2.1build1`

Binary Packages:

- `libcap-ng0:amd64=0.7.9-2.1build1`

Licenses: (parsed from: `/usr/share/doc/libcap-ng0/copyright`)

- `GPL-2`
- `GPL-3`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libcap-ng=0.7.9-2.1build1
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcap-ng/libcap-ng_0.7.9-2.1build1.dsc' libcap-ng_0.7.9-2.1build1.dsc 2158 SHA256:6d74cf5c418659d70bce8e9a4bf6f0ef0210dbcadac15e0c4d4471c4671230a1
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcap-ng/libcap-ng_0.7.9.orig.tar.gz' libcap-ng_0.7.9.orig.tar.gz 449038 SHA256:4a1532bcf3731aade40936f6d6a586ed5a66ca4c7455e1338d1f6c3e09221328
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcap-ng/libcap-ng_0.7.9-2.1build1.debian.tar.xz' libcap-ng_0.7.9-2.1build1.debian.tar.xz 6256 SHA256:b73a0a36bb0c1c8144828552dedb7b3493f4a08b1c31a0f1d7046cf1682eac7d
```

### `dpkg` source package: `libcap2=1:2.32-1ubuntu0.1`

Binary Packages:

- `libcap2:amd64=1:2.32-1ubuntu0.1`
- `libcap2-bin=1:2.32-1ubuntu0.1`
- `libpam-cap:amd64=1:2.32-1ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libcap2/copyright`, `/usr/share/doc/libcap2-bin/copyright`, `/usr/share/doc/libpam-cap/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris libcap2=1:2.32-1ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcap2/libcap2_2.32-1ubuntu0.1.dsc' libcap2_2.32-1ubuntu0.1.dsc 2291 SHA512:446ed75e7670e7d8f7c57d1e7bba07bf69a2f5a45a3e9925257d0089df55cab6051519e2ef866654f698776680f8f9d1456c4c22fa48721a388b61af21dcac09
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcap2/libcap2_2.32.orig.tar.xz' libcap2_2.32.orig.tar.xz 99708 SHA512:e2325cf0a1d0509c49336f7e5760e5b339c889cdde8d6c359197aed711423f951ad390a2a3dd4943b03afe152ad8502ea1db9d7ef247148b93e93a3c4895a019
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcap2/libcap2_2.32-1ubuntu0.1.debian.tar.xz' libcap2_2.32-1ubuntu0.1.debian.tar.xz 29192 SHA512:d8b60b83d620900f558a44cb326255e06f0451bbf95cc39342f8ada880e43e1588bfc9377f6c46868fa99ded2079472f853af4dceee81a31f1001206f28af41d
```

### `dpkg` source package: `libcdio-paranoia=10.2+2.0.0-1`

Binary Packages:

- `libcdio-cdda2:amd64=10.2+2.0.0-1`
- `libcdio-paranoia2:amd64=10.2+2.0.0-1`

Licenses: (parsed from: `/usr/share/doc/libcdio-cdda2/copyright`, `/usr/share/doc/libcdio-paranoia2/copyright`)

- `GFDL-1.2`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris libcdio-paranoia=10.2+2.0.0-1
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcdio-paranoia/libcdio-paranoia_10.2%2b2.0.0-1.dsc' libcdio-paranoia_10.2+2.0.0-1.dsc 2217 SHA256:5791ebe76ea978a9ab93cd080b448762731757ec02cf68842a62f0e5f17f121a
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcdio-paranoia/libcdio-paranoia_10.2%2b2.0.0.orig.tar.gz' libcdio-paranoia_10.2+2.0.0.orig.tar.gz 2095577 SHA256:69f513a563506f691f782d0f55f4816448852964688321398f196a200153ec95
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcdio-paranoia/libcdio-paranoia_10.2%2b2.0.0-1.debian.tar.xz' libcdio-paranoia_10.2+2.0.0-1.debian.tar.xz 7616 SHA256:2592f77a636682be3f2e8edb39d44e7db20b41c4dc9c1ed9199f1c8ce50505c8
```

### `dpkg` source package: `libcdio=2.0.0-2ubuntu0.2`

Binary Packages:

- `libcdio18:amd64=2.0.0-2ubuntu0.2`

Licenses: (parsed from: `/usr/share/doc/libcdio18/copyright`)

- `GFDL`
- `GPL`

Source:

```console
$ apt-get source -qq --print-uris libcdio=2.0.0-2ubuntu0.2
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcdio/libcdio_2.0.0-2ubuntu0.2.dsc' libcdio_2.0.0-2ubuntu0.2.dsc 2095 SHA512:d8cb764d0bbd141e8536fbacf85a32c8f19cd5fc69d533182418a3e11d197d83218a69fcec6f0daa4678d671a0f05680a6c839affcdbc09249d65ea59d115d3f
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcdio/libcdio_2.0.0.orig.tar.gz' libcdio_2.0.0.orig.tar.gz 2354813 SHA512:8f48cc71d28b427b16f48e50bcaf0aea171055c72a9aeee383ac4374eee1d3d288323814c3a3f308a9ba097aa815319429c1931072897985a3b02b814766fd4f
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcdio/libcdio_2.0.0-2ubuntu0.2.debian.tar.xz' libcdio_2.0.0-2ubuntu0.2.debian.tar.xz 13208 SHA512:0e5c4f9cf32996f87169883fc1bb8dc7932aaa550c59c47fb3a8e607be0215381fcb99cf87594bfd833b1045a05fc15564363acc5eb72583ef982b1bcdfc9684
```

### `dpkg` source package: `libcdr=0.1.6-1build2`

Binary Packages:

- `libcdr-0.1-1:amd64=0.1.6-1build2`

Licenses: (parsed from: `/usr/share/doc/libcdr-0.1-1/copyright`)

- `MPL-2.0`

Source:

```console
$ apt-get source -qq --print-uris libcdr=0.1.6-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcdr/libcdr_0.1.6-1build2.dsc' libcdr_0.1.6-1build2.dsc 2157 SHA256:9b9a1f0d9865fb2ec328d9eae9c0ac812a8584c0919e30d44f3a23ab07fbef4e
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcdr/libcdr_0.1.6.orig.tar.xz' libcdr_0.1.6.orig.tar.xz 612068 SHA256:01cd00b04a030977e544433c2d127c997205332cd9b8e35ec0ee17110da7f861
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcdr/libcdr_0.1.6-1build2.debian.tar.xz' libcdr_0.1.6-1build2.debian.tar.xz 8016 SHA256:8c7cdd454e7d315ebc44374f8704c8ea5f6e08f55c080d21a62d538100a87c79
```

### `dpkg` source package: `libcmis=0.5.2-1ubuntu1`

Binary Packages:

- `libcmis-0.5-5v5=0.5.2-1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libcmis-0.5-5v5/copyright`)

- `GPL`
- `LGPL`
- `MPL | GPL2+ | LGPL2+`

Source:

```console
$ apt-get source -qq --print-uris libcmis=0.5.2-1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcmis/libcmis_0.5.2-1ubuntu1.dsc' libcmis_0.5.2-1ubuntu1.dsc 2239 SHA256:8c05bb632a72d0fbf44410587052adc3c86d1cb8afb07427838cf0b739262bcc
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcmis/libcmis_0.5.2.orig.tar.gz' libcmis_0.5.2.orig.tar.gz 808619 SHA256:ed6f681a48abbf3c2324564b17a180d21fa9503230e8708825e1ad80daee4f81
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcmis/libcmis_0.5.2-1ubuntu1.debian.tar.xz' libcmis_0.5.2-1ubuntu1.debian.tar.xz 4856 SHA256:971d98194205f1620dbe145194295665ee672eced8a59959237cdc422dcb1cff
```

### `dpkg` source package: `libcommons-logging-java=1.2-2`

Binary Packages:

- `libcommons-logging-java=1.2-2`

Licenses: (parsed from: `/usr/share/doc/libcommons-logging-java/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris libcommons-logging-java=1.2-2
'http://archive.ubuntu.com/ubuntu/pool/universe/libc/libcommons-logging-java/libcommons-logging-java_1.2-2.dsc' libcommons-logging-java_1.2-2.dsc 2416 SHA256:98de13c4e77e3cb89291b32d54aecdfbb6e27a6c74698a405da573bf5700b90e
'http://archive.ubuntu.com/ubuntu/pool/universe/libc/libcommons-logging-java/libcommons-logging-java_1.2.orig.tar.xz' libcommons-logging-java_1.2.orig.tar.xz 134940 SHA256:10dda2b5647087c3478083ab8bc5ef4bcb95d4515b4aed79dcc59b524072b3cd
'http://archive.ubuntu.com/ubuntu/pool/universe/libc/libcommons-logging-java/libcommons-logging-java_1.2-2.debian.tar.xz' libcommons-logging-java_1.2-2.debian.tar.xz 7764 SHA256:d76e48eebb08c6cbc3fb3fe8c1d357ae2f18d03b1c04c57d0a65d0349cc552cb
```

### `dpkg` source package: `libdata-dump-perl=1.23-1`

Binary Packages:

- `libdata-dump-perl=1.23-1`

Licenses: (parsed from: `/usr/share/doc/libdata-dump-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libdata-dump-perl=1.23-1
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdata-dump-perl/libdata-dump-perl_1.23-1.dsc' libdata-dump-perl_1.23-1.dsc 2261 SHA256:5362c6e5f931eeac87ea8347c77bd08b2fc61919f8a1d3e0f93468dadeca8f53
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdata-dump-perl/libdata-dump-perl_1.23.orig.tar.gz' libdata-dump-perl_1.23.orig.tar.gz 20771 SHA256:af53b05ef1387b4cab4427e6789179283e4f0da8cf036e8db516ddb344512b65
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdata-dump-perl/libdata-dump-perl_1.23-1.debian.tar.xz' libdata-dump-perl_1.23-1.debian.tar.xz 3456 SHA256:8f4a0f41e4ca3c3bfd5b94585910ade663cfc32972e5a52d6bf031a26648a48e
```

### `dpkg` source package: `libdatrie=0.2.12-3`

Binary Packages:

- `libdatrie1:amd64=0.2.12-3`

Licenses: (parsed from: `/usr/share/doc/libdatrie1/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris libdatrie=0.2.12-3
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdatrie/libdatrie_0.2.12-3.dsc' libdatrie_0.2.12-3.dsc 2260 SHA256:631b3aa1b0cf12bcb04df8a19a8370445801a176edce830e74c01f6a55f778aa
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdatrie/libdatrie_0.2.12.orig.tar.xz' libdatrie_0.2.12.orig.tar.xz 310236 SHA256:452dcc4d3a96c01f80f7c291b42be11863cd1554ff78b93e110becce6e00b149
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdatrie/libdatrie_0.2.12-3.debian.tar.xz' libdatrie_0.2.12-3.debian.tar.xz 9188 SHA256:10409d93b3762b8ac8e0851bb2b71f76c2c5b57df8999bf8b9686d951c8b7476
```

### `dpkg` source package: `libdc1394-22=2.2.5-2.1`

Binary Packages:

- `libdc1394-22:amd64=2.2.5-2.1`

Licenses: (parsed from: `/usr/share/doc/libdc1394-22/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libdc1394-22=2.2.5-2.1
'http://archive.ubuntu.com/ubuntu/pool/universe/libd/libdc1394-22/libdc1394-22_2.2.5-2.1.dsc' libdc1394-22_2.2.5-2.1.dsc 2194 SHA256:0d4a9bf10f1e555e7afa0f957f7f08e9ef9ec26ffa3a0b35449786a2cad15521
'http://archive.ubuntu.com/ubuntu/pool/universe/libd/libdc1394-22/libdc1394-22_2.2.5.orig.tar.gz' libdc1394-22_2.2.5.orig.tar.gz 611918 SHA256:350cc8d08aee5ffc4e1f3049e2e1c2bc6660642d424595157da97ab5b1263337
'http://archive.ubuntu.com/ubuntu/pool/universe/libd/libdc1394-22/libdc1394-22_2.2.5-2.1.debian.tar.xz' libdc1394-22_2.2.5-2.1.debian.tar.xz 6668 SHA256:cf8c6566d08a011a084ca157e984414f849077ff3c6f6659dbf246302fc5d53b
```

### `dpkg` source package: `libdrm=2.4.107-8ubuntu1~20.04.2`

Binary Packages:

- `libdrm-amdgpu1:amd64=2.4.107-8ubuntu1~20.04.2`
- `libdrm-common=2.4.107-8ubuntu1~20.04.2`
- `libdrm-intel1:amd64=2.4.107-8ubuntu1~20.04.2`
- `libdrm-nouveau2:amd64=2.4.107-8ubuntu1~20.04.2`
- `libdrm-radeon1:amd64=2.4.107-8ubuntu1~20.04.2`
- `libdrm2:amd64=2.4.107-8ubuntu1~20.04.2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libdrm=2.4.107-8ubuntu1~20.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdrm/libdrm_2.4.107-8ubuntu1%7e20.04.2.dsc' libdrm_2.4.107-8ubuntu1~20.04.2.dsc 3188 SHA512:3a87eb87b862de04786233912517a1607cbd9878466f8c445b265d3cb01aa8a98c04a4611e6df4daa776a9afd65d2a5b2d4c021329545be05a7d83cac76e7321
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdrm/libdrm_2.4.107.orig.tar.xz' libdrm_2.4.107.orig.tar.xz 425612 SHA512:c7542ba15c4c934519a6a1f3cb1ec21effa820a805a030d0175313bb1cc796cd311f39596ead883f9f251679d701e262894c5a297d5cf45093c80a6cd818def0
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdrm/libdrm_2.4.107-8ubuntu1%7e20.04.2.debian.tar.xz' libdrm_2.4.107-8ubuntu1~20.04.2.debian.tar.xz 59064 SHA512:016b3f921121f1165c54e1f22011aebb551dbd954de4505c2c0c4287dd329aace5abcaf196b8c2ba36988cb28fcb6156b89bf4fc7ab5e9be1c9df5c20fb66f17
```

### `dpkg` source package: `libe-book=0.1.3-1build3`

Binary Packages:

- `libe-book-0.1-1:amd64=0.1.3-1build3`

Licenses: (parsed from: `/usr/share/doc/libe-book-0.1-1/copyright`)

- `MPL-2.0`

Source:

```console
$ apt-get source -qq --print-uris libe-book=0.1.3-1build3
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libe-book/libe-book_0.1.3-1build3.dsc' libe-book_0.1.3-1build3.dsc 2090 SHA256:8cd9cb5a86596cbd22558970e40de2ec181f22b44f093898124e45c90403d1ce
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libe-book/libe-book_0.1.3.orig.tar.xz' libe-book_0.1.3.orig.tar.xz 416268 SHA256:7e8d8ff34f27831aca3bc6f9cc532c2f90d2057c778963b884ff3d1e34dfe1f9
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libe-book/libe-book_0.1.3-1build3.debian.tar.xz' libe-book_0.1.3-1build3.debian.tar.xz 7292 SHA256:c002d8e33ac542498de7a437e67422977514a0c1cb7ca6bfe1f8430aac1206ca
```

### `dpkg` source package: `libedit=3.1-20191231-1`

Binary Packages:

- `libedit2:amd64=3.1-20191231-1`

Licenses: (parsed from: `/usr/share/doc/libedit2/copyright`)

- `BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris libedit=3.1-20191231-1
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libedit/libedit_3.1-20191231-1.dsc' libedit_3.1-20191231-1.dsc 2129 SHA256:1be31eebf9cf3b38a9e7c3c4d4b37f002e3f89df48f00dec32506cbe9337ae38
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libedit/libedit_3.1-20191231.orig.tar.gz' libedit_3.1-20191231.orig.tar.gz 516801 SHA256:dbb82cb7e116a5f8025d35ef5b4f7d4a3cdd0a3909a146a39112095a2d229071
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libedit/libedit_3.1-20191231-1.debian.tar.xz' libedit_3.1-20191231-1.debian.tar.xz 14168 SHA256:f815baa1932f9df5d4cdb316a85ebd3cc91441c4d83ba2c8454f342573ed0eab
```

### `dpkg` source package: `libencode-locale-perl=1.05-1`

Binary Packages:

- `libencode-locale-perl=1.05-1`

Licenses: (parsed from: `/usr/share/doc/libencode-locale-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libencode-locale-perl=1.05-1
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libencode-locale-perl/libencode-locale-perl_1.05-1.dsc' libencode-locale-perl_1.05-1.dsc 2107 SHA256:2a91183e11732070009fa8b01febde8509e00b69585f8eb56a5c8dce61a5df51
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libencode-locale-perl/libencode-locale-perl_1.05.orig.tar.gz' libencode-locale-perl_1.05.orig.tar.gz 8355 SHA256:176fa02771f542a4efb1dbc2a4c928e8f4391bf4078473bd6040d8f11adb0ec1
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libencode-locale-perl/libencode-locale-perl_1.05-1.debian.tar.xz' libencode-locale-perl_1.05-1.debian.tar.xz 2528 SHA256:e722122fa3c8cf0d6d5fead77184d791c341c54985f171a3bb9ece3688d94e48
```

### `dpkg` source package: `libeot=0.01-5`

Binary Packages:

- `libeot0:amd64=0.01-5`

Licenses: (parsed from: `/usr/share/doc/libeot0/copyright`)

- `GPL-2`
- `GPL-2+`
- `MPL-2.0`
- `other`

Source:

```console
$ apt-get source -qq --print-uris libeot=0.01-5
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libeot/libeot_0.01-5.dsc' libeot_0.01-5.dsc 1949 SHA256:71933404d061aeffe2c0e5da353ef7c5146fd061131b0a8c31257b16b080cab6
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libeot/libeot_0.01.orig.tar.bz2' libeot_0.01.orig.tar.bz2 260288 SHA256:cf5091fa8e7dcdbe667335eb90a2cfdd0a3fe8f8c7c8d1ece44d9d055736a06a
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libeot/libeot_0.01-5.debian.tar.xz' libeot_0.01-5.debian.tar.xz 7492 SHA256:e6f5685fee36d82d31e1d2b2334314098b8bac7b87de59ee89809795f85b87c5
```

### `dpkg` source package: `libepoxy=1.5.4-1`

Binary Packages:

- `libepoxy0:amd64=1.5.4-1`

Licenses: (parsed from: `/usr/share/doc/libepoxy0/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris libepoxy=1.5.4-1
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libepoxy/libepoxy_1.5.4-1.dsc' libepoxy_1.5.4-1.dsc 2106 SHA256:fb88cb692c384973c4bab06dee97225e434a3abc921f4218e4c9770663d3455a
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libepoxy/libepoxy_1.5.4.orig.tar.gz' libepoxy_1.5.4.orig.tar.gz 337615 SHA256:c926fcc606901f3e03e371027056fd478da43e01ce2da7ffc48b5a0de0ca107c
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libepoxy/libepoxy_1.5.4-1.debian.tar.xz' libepoxy_1.5.4-1.debian.tar.xz 17136 SHA256:b34513260555063a2750affe4694bf528a806d3c1ff9d858bfc9588abd434a63
```

### `dpkg` source package: `libepubgen=0.1.1-1ubuntu2`

Binary Packages:

- `libepubgen-0.1-1:amd64=0.1.1-1ubuntu2`

Licenses: (parsed from: `/usr/share/doc/libepubgen-0.1-1/copyright`)

- `MPL-2.0`
- `other`

Source:

```console
$ apt-get source -qq --print-uris libepubgen=0.1.1-1ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libepubgen/libepubgen_0.1.1-1ubuntu2.dsc' libepubgen_0.1.1-1ubuntu2.dsc 2173 SHA256:f9632e1a51ca9dcd7a9f2317e2f20e9530ee6f46656c11bcf5768ecb020d190c
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libepubgen/libepubgen_0.1.1.orig.tar.xz' libepubgen_0.1.1.orig.tar.xz 324380 SHA256:03e084b994cbeffc8c3dd13303b2cb805f44d8f2c3b79f7690d7e3fc7f6215ad
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libepubgen/libepubgen_0.1.1-1ubuntu2.debian.tar.xz' libepubgen_0.1.1-1ubuntu2.debian.tar.xz 6168 SHA256:157fe0ff0667dc01acef3fb86227cd4f36e62115048a6f3d8c37d984cc4fe5a9
```

### `dpkg` source package: `libetonyek=0.1.9-3`

Binary Packages:

- `libetonyek-0.1-1:amd64=0.1.9-3`

Licenses: (parsed from: `/usr/share/doc/libetonyek-0.1-1/copyright`)

- `MPL 2.0`

Source:

```console
$ apt-get source -qq --print-uris libetonyek=0.1.9-3
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libetonyek/libetonyek_0.1.9-3.dsc' libetonyek_0.1.9-3.dsc 2169 SHA256:4c4ce9bc275bba6ac1bc2910250b7f587f3372aca5022302679c943a7ffd4237
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libetonyek/libetonyek_0.1.9.orig.tar.xz' libetonyek_0.1.9.orig.tar.xz 1477064 SHA256:e61677e8799ce6e55b25afc11aa5339113f6a49cff031f336e32fa58635b1a4a
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libetonyek/libetonyek_0.1.9-3.debian.tar.xz' libetonyek_0.1.9-3.debian.tar.xz 42780 SHA256:4e090ef31b156cd7a073912007987acdd7b6ffc4e31d7f275ea73bccd4ab3b9b
```

### `dpkg` source package: `libexttextcat=3.4.5-1`

Binary Packages:

- `libexttextcat-2.0-0:amd64=3.4.5-1`
- `libexttextcat-data=3.4.5-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libexttextcat=3.4.5-1
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libexttextcat/libexttextcat_3.4.5-1.dsc' libexttextcat_3.4.5-1.dsc 2099 SHA256:9a5f988e773efec298260e0464df6b4d77b01d82d2a989d317c5529f9c3ac586
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libexttextcat/libexttextcat_3.4.5.orig.tar.xz' libexttextcat_3.4.5.orig.tar.xz 1041268 SHA256:13fdbc9d4c489a4d0519e51933a1aa21fe3fb9eb7da191b87f7a63e82797dac8
'http://archive.ubuntu.com/ubuntu/pool/main/libe/libexttextcat/libexttextcat_3.4.5-1.debian.tar.xz' libexttextcat_3.4.5-1.debian.tar.xz 7224 SHA256:bf214f4c725d236a8e77b4f7199316255de431eb48638b78f5346890fb3c0849
```

### `dpkg` source package: `libffi=3.3-4`

Binary Packages:

- `libffi7:amd64=3.3-4`

Licenses: (parsed from: `/usr/share/doc/libffi7/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris libffi=3.3-4
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libffi/libffi_3.3-4.dsc' libffi_3.3-4.dsc 1932 SHA256:4190ad8e7ae9167a0c67c5926bc3705acb191745cca93ef845dbc06fc097f380
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libffi/libffi_3.3.orig.tar.gz' libffi_3.3.orig.tar.gz 1305466 SHA256:72fba7922703ddfa7a028d513ac15a85c8d54c8d67f55fa5a4802885dc652056
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libffi/libffi_3.3-4.debian.tar.xz' libffi_3.3-4.debian.tar.xz 9016 SHA256:0e8a6d9d87202d04d7646178479c3d365a845f9723da26625d533a169b378100
```

### `dpkg` source package: `libfile-basedir-perl=0.08-1`

Binary Packages:

- `libfile-basedir-perl=0.08-1`

Licenses: (parsed from: `/usr/share/doc/libfile-basedir-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libfile-basedir-perl=0.08-1
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-basedir-perl/libfile-basedir-perl_0.08-1.dsc' libfile-basedir-perl_0.08-1.dsc 2365 SHA256:5e143ea7b74c6c96e3b0e5b1c7e88914f4bc4e0c5a70074f77f0e8f07cb6e5d1
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-basedir-perl/libfile-basedir-perl_0.08.orig.tar.gz' libfile-basedir-perl_0.08.orig.tar.gz 10052 SHA256:c065fcd3e2f22ae769937bcc971b91f80294d5009fac140bfba83bf7d35305e3
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-basedir-perl/libfile-basedir-perl_0.08-1.debian.tar.xz' libfile-basedir-perl_0.08-1.debian.tar.xz 2800 SHA256:337925c540899e9313fa79907557d24fb2dbbdb9c013390b42da4943edfc1718
```

### `dpkg` source package: `libfile-desktopentry-perl=0.22-1`

Binary Packages:

- `libfile-desktopentry-perl=0.22-1`

Licenses: (parsed from: `/usr/share/doc/libfile-desktopentry-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libfile-desktopentry-perl=0.22-1
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-desktopentry-perl/libfile-desktopentry-perl_0.22-1.dsc' libfile-desktopentry-perl_0.22-1.dsc 2400 SHA256:94d12f074e00b4c024af2a83691b96971a6fea19de5f18f0caf2675f9028031a
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-desktopentry-perl/libfile-desktopentry-perl_0.22.orig.tar.gz' libfile-desktopentry-perl_0.22.orig.tar.gz 18366 SHA256:169c01e3dae2f629767bec1a9f1cdbd6ec6d713d1501e0b2786e4dd1235635b8
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-desktopentry-perl/libfile-desktopentry-perl_0.22-1.debian.tar.xz' libfile-desktopentry-perl_0.22-1.debian.tar.xz 3244 SHA256:43ce8359412c3d1a01580c3f128e2071a33808f8bccd9d0a2ebc499d53bb49f2
```

### `dpkg` source package: `libfile-listing-perl=6.04-1`

Binary Packages:

- `libfile-listing-perl=6.04-1`

Licenses: (parsed from: `/usr/share/doc/libfile-listing-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libfile-listing-perl=6.04-1
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-listing-perl/libfile-listing-perl_6.04-1.dsc' libfile-listing-perl_6.04-1.dsc 1493 SHA256:b431527f181f34682315d62422ceac52db806bbeabfecae4cd877714d7dca2f4
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-listing-perl/libfile-listing-perl_6.04.orig.tar.gz' libfile-listing-perl_6.04.orig.tar.gz 51536 SHA256:1e0050fcd6789a2179ec0db282bf1e90fb92be35d1171588bd9c47d52d959cf5
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-listing-perl/libfile-listing-perl_6.04-1.debian.tar.gz' libfile-listing-perl_6.04-1.debian.tar.gz 1972 SHA256:f14177c3171bd6d09912ecb82e0b3a7e10fa2d17f56d8964750aefa16b5a6b7b
```

### `dpkg` source package: `libfile-mimeinfo-perl=0.29-1`

Binary Packages:

- `libfile-mimeinfo-perl=0.29-1`

Licenses: (parsed from: `/usr/share/doc/libfile-mimeinfo-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libfile-mimeinfo-perl=0.29-1
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-mimeinfo-perl/libfile-mimeinfo-perl_0.29-1.dsc' libfile-mimeinfo-perl_0.29-1.dsc 2492 SHA256:c9a1a72f3057b4cbe47993b063f84a4ddae34d9073875c2e5b858fb35f7f2928
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-mimeinfo-perl/libfile-mimeinfo-perl_0.29.orig.tar.gz' libfile-mimeinfo-perl_0.29.orig.tar.gz 33113 SHA256:f1962779652eae1d5a6e722a5220e3c50465deac52bb8dea47e0fbcfb6c908ea
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfile-mimeinfo-perl/libfile-mimeinfo-perl_0.29-1.debian.tar.xz' libfile-mimeinfo-perl_0.29-1.debian.tar.xz 4320 SHA256:3d1e9a1750f184ab982aa0107cc173ee758cb133db48089cc824183e68b74ac8
```

### `dpkg` source package: `libfont-afm-perl=1.20-2`

Binary Packages:

- `libfont-afm-perl=1.20-2`

Licenses: (parsed from: `/usr/share/doc/libfont-afm-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libfont-afm-perl=1.20-2
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfont-afm-perl/libfont-afm-perl_1.20-2.dsc' libfont-afm-perl_1.20-2.dsc 2070 SHA256:1b9c82ec407e56149f1d2d61d21d81fcaea0ee0292bd1b57bf8b415943b27735
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfont-afm-perl/libfont-afm-perl_1.20.orig.tar.gz' libfont-afm-perl_1.20.orig.tar.gz 10421 SHA256:32671166da32596a0f6baacd0c1233825a60acaf25805d79c81a3f18d6088bc1
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfont-afm-perl/libfont-afm-perl_1.20-2.debian.tar.xz' libfont-afm-perl_1.20-2.debian.tar.xz 2732 SHA256:981bb81a767cb822668840259fd349f19bc71ef0a27f22dfe87590dbc2f2f674
```

### `dpkg` source package: `libfontenc=1:1.1.4-0ubuntu1`

Binary Packages:

- `libfontenc1:amd64=1:1.1.4-0ubuntu1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libfontenc=1:1.1.4-0ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfontenc/libfontenc_1.1.4-0ubuntu1.dsc' libfontenc_1.1.4-0ubuntu1.dsc 1666 SHA256:55b5ac947569e2926da53b0c0d9b88f838f5f0a89fed10ef186bb1a42c12b589
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfontenc/libfontenc_1.1.4.orig.tar.gz' libfontenc_1.1.4.orig.tar.gz 389706 SHA256:895ee0986b32fbfcda7f4f25ef6cbacfa760e1690bf59f02085ce0e7d1eebb41
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfontenc/libfontenc_1.1.4-0ubuntu1.diff.gz' libfontenc_1.1.4-0ubuntu1.diff.gz 8442 SHA256:89d129587ce4abaf5ac28706b6687cbf72f80abcf05313dbe58cab8eb9fb80ab
```

### `dpkg` source package: `libfreehand=0.1.2-2ubuntu1`

Binary Packages:

- `libfreehand-0.1-1=0.1.2-2ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libfreehand-0.1-1/copyright`)

- `GPL-3`
- `LGPL-3`
- `MPL-1.1 | GPL-3+ | LGPL-3+`
- `MPL-2.0`

Source:

```console
$ apt-get source -qq --print-uris libfreehand=0.1.2-2ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfreehand/libfreehand_0.1.2-2ubuntu1.dsc' libfreehand_0.1.2-2ubuntu1.dsc 1413 SHA256:3c886aed0e0df76fbea8c8c6ee884ba14e2e0f1f56c68c0c186344c546d0a6b7
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfreehand/libfreehand_0.1.2.orig.tar.xz' libfreehand_0.1.2.orig.tar.xz 516132 SHA256:0e422d1564a6dbf22a9af598535425271e583514c0f7ba7d9091676420de34ac
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfreehand/libfreehand_0.1.2-2ubuntu1.debian.tar.xz' libfreehand_0.1.2-2ubuntu1.debian.tar.xz 13824 SHA256:030f0ca11865f309acfc9ac0e856294eb0287ed7f2a089354274b20740da399f
```

### `dpkg` source package: `libgcrypt20=1.8.5-5ubuntu1.1`

Binary Packages:

- `libgcrypt20:amd64=1.8.5-5ubuntu1.1`

Licenses: (parsed from: `/usr/share/doc/libgcrypt20/copyright`)

- `GPL-2`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris libgcrypt20=1.8.5-5ubuntu1.1
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgcrypt20/libgcrypt20_1.8.5-5ubuntu1.1.dsc' libgcrypt20_1.8.5-5ubuntu1.1.dsc 2915 SHA512:7b1cdda11632962e872b5d70b351851d95a3d5ed896f19650da618ef8ec835ed3aee54905b33f507ed16a7bae7d1ba0d5df8546712a1ee851bbed61d008250f9
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgcrypt20/libgcrypt20_1.8.5.orig.tar.bz2' libgcrypt20_1.8.5.orig.tar.bz2 2991291 SHA512:b55e16e838d1b1208e7673366971ae7c0f9c1c79e042f41c03d14ed74c5e387fa69ea81d5414ffda3d2b4f82ea5467fe13b00115727e257db22808cf351bde89
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgcrypt20/libgcrypt20_1.8.5.orig.tar.bz2.asc' libgcrypt20_1.8.5.orig.tar.bz2.asc 488 SHA512:3993c5e3f2f1714f40a9ad1a19782362c5b80c070ed8d76feacc503d8719f6775465f478098a092730e02683c665c5c91cf30e7700215aae2322be6230f207d6
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgcrypt20/libgcrypt20_1.8.5-5ubuntu1.1.debian.tar.xz' libgcrypt20_1.8.5-5ubuntu1.1.debian.tar.xz 34660 SHA512:ffcb506488147ceefe4c67c65de91f9d736d7e6a49d5ff3f04e8ec91a017a7c112c5bc46f6c71f07ff3dd565b494783cbd5b4f017f05c2a5b59f2955933d664b
```

### `dpkg` source package: `libglvnd=1.3.2-1~ubuntu0.20.04.2`

Binary Packages:

- `libegl1:amd64=1.3.2-1~ubuntu0.20.04.2`
- `libgl1:amd64=1.3.2-1~ubuntu0.20.04.2`
- `libglvnd0:amd64=1.3.2-1~ubuntu0.20.04.2`
- `libglx0:amd64=1.3.2-1~ubuntu0.20.04.2`

Licenses: (parsed from: `/usr/share/doc/libegl1/copyright`, `/usr/share/doc/libgl1/copyright`, `/usr/share/doc/libglvnd0/copyright`, `/usr/share/doc/libglx0/copyright`)

- `Apache-2.0`
- `BSD-1-clause`
- `GPL`
- `GPL-3`
- `GPL-3+`
- `MIT`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris libglvnd=1.3.2-1~ubuntu0.20.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libglvnd/libglvnd_1.3.2-1%7eubuntu0.20.04.2.dsc' libglvnd_1.3.2-1~ubuntu0.20.04.2.dsc 2852 SHA512:d50c68230d11b57a3bcbfb6c55e5f486914d43fcb5d446fcba15a4d3e7751c6b747ec80b76aa1b790d144181602a4fbd5b8f8a049404c6362c11f6d22be7ef18
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libglvnd/libglvnd_1.3.2.orig.tar.gz' libglvnd_1.3.2.orig.tar.gz 1032413 SHA512:96bdf7adb62a4d20846830e5e0791885afb6ee0748e6345801d645f695eeb58cd7793f53b753f6d44dc630741eb864523dcf0393f3696c5d9774cc3ffa3b9c5b
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libglvnd/libglvnd_1.3.2-1%7eubuntu0.20.04.2.debian.tar.xz' libglvnd_1.3.2-1~ubuntu0.20.04.2.debian.tar.xz 22040 SHA512:36a762a2bf3a33d9ce82f250dc6071d2500bb4a1ea24b4969c3f3dfe3e72f12a07821a13f2bebf44e6de81122a81170176b4d02200d8b2e7634a16419791d093
```

### `dpkg` source package: `libgpg-error=1.37-1`

Binary Packages:

- `libgpg-error0:amd64=1.37-1`

Licenses: (parsed from: `/usr/share/doc/libgpg-error0/copyright`)

- `BSD-3-clause`
- `GPL-3`
- `GPL-3+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `g10-permissive`

Source:

```console
$ apt-get source -qq --print-uris libgpg-error=1.37-1
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgpg-error/libgpg-error_1.37-1.dsc' libgpg-error_1.37-1.dsc 2220 SHA256:e789ed6bf791c90e9ba28dc3923f54379862ca65bd286495942176dcfad5d8a7
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgpg-error/libgpg-error_1.37.orig.tar.bz2' libgpg-error_1.37.orig.tar.bz2 937282 SHA256:b32d6ff72a73cf79797f7f2d039e95e9c6f92f0c1450215410840ab62aea9763
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgpg-error/libgpg-error_1.37.orig.tar.bz2.asc' libgpg-error_1.37.orig.tar.bz2.asc 488 SHA256:394f0904c386f88e2b2db5042880a2a302cbc6e4ab902bacf3d338ded038066b
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgpg-error/libgpg-error_1.37-1.debian.tar.xz' libgpg-error_1.37-1.debian.tar.xz 17332 SHA256:09843b599726c1ab7b1fcd86ce617bd91d6378ff754c6da0b7e536ed1c3b6c16
```

### `dpkg` source package: `libgsm=1.0.18-2`

Binary Packages:

- `libgsm1:amd64=1.0.18-2`

Licenses: (parsed from: `/usr/share/doc/libgsm1/copyright`)

- `TU-Berlin-2.0`

Source:

```console
$ apt-get source -qq --print-uris libgsm=1.0.18-2
'http://archive.ubuntu.com/ubuntu/pool/universe/libg/libgsm/libgsm_1.0.18-2.dsc' libgsm_1.0.18-2.dsc 1831 SHA256:8b189db3805aaaf49073971af2e1a0dad13fdd0efd6b60c0aae687f78fd76a0a
'http://archive.ubuntu.com/ubuntu/pool/universe/libg/libgsm/libgsm_1.0.18.orig.tar.gz' libgsm_1.0.18.orig.tar.gz 64549 SHA256:04f68087c3348bf156b78d59f4d8aff545da7f6e14f33be8f47d33f4efae2a10
'http://archive.ubuntu.com/ubuntu/pool/universe/libg/libgsm/libgsm_1.0.18-2.debian.tar.xz' libgsm_1.0.18-2.debian.tar.xz 10276 SHA256:3655a18243e6e3d5706dd069347919c26edd3387d63ecf728fc6ecb242b36b43
```

### `dpkg` source package: `libgudev=233-1`

Binary Packages:

- `libgudev-1.0-0:amd64=1:233-1`

Licenses: (parsed from: `/usr/share/doc/libgudev-1.0-0/copyright`)

- `LGPL-2`
- `LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris libgudev=233-1
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgudev/libgudev_233-1.dsc' libgudev_233-1.dsc 2366 SHA256:d9d9c196a3a296cd69a5b8c091c9d78e6139afce3d374858e82c567a585bcdbf
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgudev/libgudev_233.orig.tar.xz' libgudev_233.orig.tar.xz 271292 SHA256:587c4970eb23f4e2deee2cb1fb7838c94a78c578f41ce12cac0a3f4a80dabb03
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgudev/libgudev_233-1.debian.tar.xz' libgudev_233-1.debian.tar.xz 4060 SHA256:f83ce6babcab7cfc7d7f7d850581005803006e2baaf005e05ad5490a8f661a52
```

### `dpkg` source package: `libhtml-form-perl=6.07-1`

Binary Packages:

- `libhtml-form-perl=6.07-1`

Licenses: (parsed from: `/usr/share/doc/libhtml-form-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libhtml-form-perl=6.07-1
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-form-perl/libhtml-form-perl_6.07-1.dsc' libhtml-form-perl_6.07-1.dsc 2425 SHA256:7b27fc89d147d47cac5defa1f4325686d1145b5836fcc3999bf210639d6952a4
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-form-perl/libhtml-form-perl_6.07.orig.tar.gz' libhtml-form-perl_6.07.orig.tar.gz 41503 SHA256:7daa8c7eaff4005501c3431c8bf478d58bbee7b836f863581aa14afe1b4b6227
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-form-perl/libhtml-form-perl_6.07-1.debian.tar.xz' libhtml-form-perl_6.07-1.debian.tar.xz 2568 SHA256:388eed6ed7cb39dcb2f48eb60e0baa2c1c0e5ce9d66e82631cdd605c942a510d
```

### `dpkg` source package: `libhtml-format-perl=2.12-1`

Binary Packages:

- `libhtml-format-perl=2.12-1`

Licenses: (parsed from: `/usr/share/doc/libhtml-format-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libhtml-format-perl=2.12-1
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-format-perl/libhtml-format-perl_2.12-1.dsc' libhtml-format-perl_2.12-1.dsc 2253 SHA256:85d329b257604bbbde77073ae1e8e6995a58ffa36f2db9819d880daabd03f3c6
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-format-perl/libhtml-format-perl_2.12.orig.tar.gz' libhtml-format-perl_2.12.orig.tar.gz 50248 SHA256:a8f76839e46a22c64b8635b82072799caf77393d2102fba81041db6348c66899
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-format-perl/libhtml-format-perl_2.12-1.debian.tar.xz' libhtml-format-perl_2.12-1.debian.tar.xz 3944 SHA256:42539c9cb4796a7cb1d68151b7573dbc3d591ab60799e236eee3f5889047b931
```

### `dpkg` source package: `libhtml-parser-perl=3.72-5`

Binary Packages:

- `libhtml-parser-perl=3.72-5`

Licenses: (parsed from: `/usr/share/doc/libhtml-parser-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libhtml-parser-perl=3.72-5
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-parser-perl/libhtml-parser-perl_3.72-5.dsc' libhtml-parser-perl_3.72-5.dsc 2558 SHA256:7fe41195a16dbaefa10b583875340a72a33f60272af3cccc2154f1092f7fa4de
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-parser-perl/libhtml-parser-perl_3.72.orig.tar.gz' libhtml-parser-perl_3.72.orig.tar.gz 90680 SHA256:ec28c7e1d9e67c45eca197077f7cdc41ead1bb4c538c7f02a3296a4bb92f608b
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-parser-perl/libhtml-parser-perl_3.72-5.debian.tar.xz' libhtml-parser-perl_3.72-5.debian.tar.xz 9140 SHA256:81c1bb70cc5ce5ce36238d84eefa4c70d7ea787909364a559bea261c412521bd
```

### `dpkg` source package: `libhtml-tagset-perl=3.20-4`

Binary Packages:

- `libhtml-tagset-perl=3.20-4`

Licenses: (parsed from: `/usr/share/doc/libhtml-tagset-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libhtml-tagset-perl=3.20-4
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-tagset-perl/libhtml-tagset-perl_3.20-4.dsc' libhtml-tagset-perl_3.20-4.dsc 2394 SHA256:b985a802342e9aeba142f1789f6502bb0c04336165ca08ef721985bcc7fb0015
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-tagset-perl/libhtml-tagset-perl_3.20.orig.tar.gz' libhtml-tagset-perl_3.20.orig.tar.gz 8150 SHA256:adb17dac9e36cd011f5243881c9739417fd102fce760f8de4e9be4c7131108e2
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-tagset-perl/libhtml-tagset-perl_3.20-4.debian.tar.xz' libhtml-tagset-perl_3.20-4.debian.tar.xz 3288 SHA256:f68fc45bdb0df7f8864806a98f43aa92e75533d37530ddf1c2084fd027655434
```

### `dpkg` source package: `libhtml-tree-perl=5.07-2`

Binary Packages:

- `libhtml-tree-perl=5.07-2`

Licenses: (parsed from: `/usr/share/doc/libhtml-tree-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libhtml-tree-perl=5.07-2
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-tree-perl/libhtml-tree-perl_5.07-2.dsc' libhtml-tree-perl_5.07-2.dsc 2363 SHA256:ba57fd6f95628dc731a32be5d2308f0c5dca855a16a187e9191202f2dc9cb94c
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-tree-perl/libhtml-tree-perl_5.07.orig.tar.gz' libhtml-tree-perl_5.07.orig.tar.gz 150477 SHA256:f0374db84731c204b86c1d5b90975fef0d30a86bd9def919343e554e31a9dbbf
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhtml-tree-perl/libhtml-tree-perl_5.07-2.debian.tar.xz' libhtml-tree-perl_5.07-2.debian.tar.xz 6184 SHA256:9c28e370d84b932ef9c978281c017d24bbd8e25ba3ee5a03cf9c9e29efd1e1ef
```

### `dpkg` source package: `libhttp-cookies-perl=6.08-1`

Binary Packages:

- `libhttp-cookies-perl=6.08-1`

Licenses: (parsed from: `/usr/share/doc/libhttp-cookies-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libhttp-cookies-perl=6.08-1
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-cookies-perl/libhttp-cookies-perl_6.08-1.dsc' libhttp-cookies-perl_6.08-1.dsc 2444 SHA256:b9c4888c264a10b490e62ce9979b8f3d32684896c139cb81952b88eb29cd9eb9
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-cookies-perl/libhttp-cookies-perl_6.08.orig.tar.gz' libhttp-cookies-perl_6.08.orig.tar.gz 41482 SHA256:49ebb73576eb41063c04bc079477df094496deec805ae033f3be338c23c3af59
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-cookies-perl/libhttp-cookies-perl_6.08-1.debian.tar.xz' libhttp-cookies-perl_6.08-1.debian.tar.xz 2876 SHA256:2c311bcb4b8b5c196914dc1828734c151e60e03579147de434b0e6b67446e9fd
```

### `dpkg` source package: `libhttp-daemon-perl=6.06-1ubuntu0.1`

Binary Packages:

- `libhttp-daemon-perl=6.06-1ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libhttp-daemon-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libhttp-daemon-perl=6.06-1ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-daemon-perl/libhttp-daemon-perl_6.06-1ubuntu0.1.dsc' libhttp-daemon-perl_6.06-1ubuntu0.1.dsc 2537 SHA512:8c91cd52cdf6c2a6cb8c1bf4b1f128d06e7a2635b780313b495ca91d7ede31ba1c463325bcc72f3ec5ebce61390d605c1428828251d4c3c2f84cc4c57cf792f9
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-daemon-perl/libhttp-daemon-perl_6.06.orig.tar.gz' libhttp-daemon-perl_6.06.orig.tar.gz 45576 SHA512:8e6dcf4451aaa6bd5f38508a087e5bb9b7f5105e8e243d09bdd3f4be3d7009222b3d9f8e494f049b48f0caebf36f239b8bbc7b8edc805f7d32b1bbeb38431732
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-daemon-perl/libhttp-daemon-perl_6.06-1ubuntu0.1.debian.tar.xz' libhttp-daemon-perl_6.06-1ubuntu0.1.debian.tar.xz 7040 SHA512:c780762318e677841c6c8d0e3836bc47f0f28c206462c66a6baefb73e33e5cdacdc7a67b0d3022fe7cdaeb2408a3d62da246809f2dfe34acd721c8bf94a10985
```

### `dpkg` source package: `libhttp-date-perl=6.05-1`

Binary Packages:

- `libhttp-date-perl=6.05-1`

Licenses: (parsed from: `/usr/share/doc/libhttp-date-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libhttp-date-perl=6.05-1
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-date-perl/libhttp-date-perl_6.05-1.dsc' libhttp-date-perl_6.05-1.dsc 2156 SHA256:7276bab3333e6e2df17f43e0033f1ec5a3501a45a53b381e29e39238151c274d
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-date-perl/libhttp-date-perl_6.05.orig.tar.gz' libhttp-date-perl_6.05.orig.tar.gz 29234 SHA256:cb0894bf15a27c69971da50818f87cbb505990b5a0d844597cd0edd13cc90d8e
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-date-perl/libhttp-date-perl_6.05-1.debian.tar.xz' libhttp-date-perl_6.05-1.debian.tar.xz 2196 SHA256:ec511e437cb61f33c1ea3a74ee8cbe3e6a0d00b3f6894bcb0ca72568e17cf42b
```

### `dpkg` source package: `libhttp-message-perl=6.22-1`

Binary Packages:

- `libhttp-message-perl=6.22-1`

Licenses: (parsed from: `/usr/share/doc/libhttp-message-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libhttp-message-perl=6.22-1
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-message-perl/libhttp-message-perl_6.22-1.dsc' libhttp-message-perl_6.22-1.dsc 2595 SHA256:3290d1c67414b127f62fef5f9c0f16fa450ad8ab349eba12f793c283de0b51ea
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-message-perl/libhttp-message-perl_6.22.orig.tar.gz' libhttp-message-perl_6.22.orig.tar.gz 86328 SHA256:970efd151b81c95831d2a5f9e117f8032b63a1768cd2cd3f092ad634c85175c3
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-message-perl/libhttp-message-perl_6.22-1.debian.tar.xz' libhttp-message-perl_6.22-1.debian.tar.xz 3264 SHA256:cc91ee4318feaed31fdc92e7dd6d27d96df4d66540598d79b389672fa3a4a444
```

### `dpkg` source package: `libhttp-negotiate-perl=6.01-1`

Binary Packages:

- `libhttp-negotiate-perl=6.01-1`

Licenses: (parsed from: `/usr/share/doc/libhttp-negotiate-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libhttp-negotiate-perl=6.01-1
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-negotiate-perl/libhttp-negotiate-perl_6.01-1.dsc' libhttp-negotiate-perl_6.01-1.dsc 2293 SHA256:e59589c57f9f641d7d5d4f3cb843b8cb2be5979e3e00b8e6a80a0f3b2f3b1015
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-negotiate-perl/libhttp-negotiate-perl_6.01.orig.tar.gz' libhttp-negotiate-perl_6.01.orig.tar.gz 8596 SHA256:1c729c1ea63100e878405cda7d66f9adfd3ed4f1d6cacaca0ee9152df728e016
'http://archive.ubuntu.com/ubuntu/pool/main/libh/libhttp-negotiate-perl/libhttp-negotiate-perl_6.01-1.debian.tar.xz' libhttp-negotiate-perl_6.01-1.debian.tar.xz 2116 SHA256:75032f80856028754228213b1453a5673367a74382c28b541ed7fd63de9d13e4
```

### `dpkg` source package: `libice=2:1.0.10-0ubuntu1`

Binary Packages:

- `libice-dev:amd64=2:1.0.10-0ubuntu1`
- `libice6:amd64=2:1.0.10-0ubuntu1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libice=2:1.0.10-0ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libice/libice_1.0.10-0ubuntu1.dsc' libice_1.0.10-0ubuntu1.dsc 1629 SHA256:51f58a0e5a5c5ea780baa3a057b61a921001831a4817da8825dbf592afccbdd6
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libice/libice_1.0.10.orig.tar.gz' libice_1.0.10.orig.tar.gz 481960 SHA256:1116bc64c772fd127a0d0c0ffa2833479905e3d3d8197740b3abd5f292f22d2d
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libice/libice_1.0.10-0ubuntu1.diff.gz' libice_1.0.10-0ubuntu1.diff.gz 6470 SHA256:a9187c11c1b372b0f4cb58c2fb21f780e9236fd7011bb32c4188c7b37112e8de
```

### `dpkg` source package: `libidn2=2.2.0-2`

Binary Packages:

- `libidn2-0:amd64=2.2.0-2`

Licenses: (parsed from: `/usr/share/doc/libidn2-0/copyright`)

- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `LGPL-3`
- `LGPL-3+`
- `Unicode`

Source:

```console
$ apt-get source -qq --print-uris libidn2=2.2.0-2
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libidn2/libidn2_2.2.0-2.dsc' libidn2_2.2.0-2.dsc 2436 SHA256:a5c5ece3748beaba9ce0a0b29cdab2fe9d861a965a7a96101a49f194acf759d6
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libidn2/libidn2_2.2.0.orig.tar.gz' libidn2_2.2.0.orig.tar.gz 2110743 SHA256:fc734732b506d878753ec6606982bf7b936e868c25c30ddb0d83f7d7056381fe
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libidn2/libidn2_2.2.0-2.debian.tar.xz' libidn2_2.2.0-2.debian.tar.xz 11184 SHA256:b38ce002d7eb1abbf2c870ac9570cd06a5087693f359b133defbf44b06f8784d
```

### `dpkg` source package: `libidn=1.33-2.2ubuntu2`

Binary Packages:

- `libidn11:amd64=1.33-2.2ubuntu2`

Licenses: (parsed from: `/usr/share/doc/libidn11/copyright`)

- `GAP`
- `GFDL-1.3`
- `GFDL-1.3+`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `LGPL-2`
- `LGPL-2.1`
- `LGPL-2.1+`
- `LGPL-3`
- `LGPL-3+`

Source:

```console
$ apt-get source -qq --print-uris libidn=1.33-2.2ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libidn/libidn_1.33-2.2ubuntu2.dsc' libidn_1.33-2.2ubuntu2.dsc 2200 SHA256:0f77a95ae991742de8989d439a518b025bd4415312559711ca3e447df8abd9ec
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libidn/libidn_1.33.orig.tar.gz' libidn_1.33.orig.tar.gz 3501056 SHA256:44a7aab635bb721ceef6beecc4d49dfd19478325e1b47f3196f7d2acc4930e19
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libidn/libidn_1.33-2.2ubuntu2.debian.tar.xz' libidn_1.33-2.2ubuntu2.debian.tar.xz 65936 SHA256:b856b815814396183eb80493a04caa008e96e112516cabda0716c80d5d1c11f8
```

### `dpkg` source package: `libiec61883=1.2.0-3`

Binary Packages:

- `libiec61883-0:amd64=1.2.0-3`

Licenses: (parsed from: `/usr/share/doc/libiec61883-0/copyright`)

- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libiec61883=1.2.0-3
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libiec61883/libiec61883_1.2.0-3.dsc' libiec61883_1.2.0-3.dsc 1984 SHA256:1e6c7729cd431e53c8516ae49b4c0ebc0ee255ebeccc7eb629262c7901da6a5a
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libiec61883/libiec61883_1.2.0.orig.tar.gz' libiec61883_1.2.0.orig.tar.gz 339064 SHA256:7c7879c6b9add3148baea697dfbfdcefffbc8ac74e8e6bcf46125ec1d21b373a
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libiec61883/libiec61883_1.2.0-3.debian.tar.xz' libiec61883_1.2.0-3.debian.tar.xz 12800 SHA256:baf4b8031737c2030a1291e1197adff98215b85d830aecb36153034d758d4c39
```

### `dpkg` source package: `libio-html-perl=1.001-1`

Binary Packages:

- `libio-html-perl=1.001-1`

Licenses: (parsed from: `/usr/share/doc/libio-html-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris libio-html-perl=1.001-1
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libio-html-perl/libio-html-perl_1.001-1.dsc' libio-html-perl_1.001-1.dsc 2143 SHA256:d9065afdd12b5e0c534938f17a846e9fec028457053d4a064f7f95ebb68f2e5c
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libio-html-perl/libio-html-perl_1.001.orig.tar.gz' libio-html-perl_1.001.orig.tar.gz 19375 SHA256:ea78d2d743794adc028bc9589538eb867174b4e165d7d8b5f63486e6b828e7e0
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libio-html-perl/libio-html-perl_1.001-1.debian.tar.xz' libio-html-perl_1.001-1.debian.tar.xz 3124 SHA256:89c86132e54f7f967b4f31eb42ff922eb4017c60e45ba2264e42ba620146f844
```

### `dpkg` source package: `libio-socket-ssl-perl=2.067-1`

Binary Packages:

- `libio-socket-ssl-perl=2.067-1`

Licenses: (parsed from: `/usr/share/doc/libio-socket-ssl-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libio-socket-ssl-perl=2.067-1
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libio-socket-ssl-perl/libio-socket-ssl-perl_2.067-1.dsc' libio-socket-ssl-perl_2.067-1.dsc 2725 SHA256:a62a2f38550c94f216e4520b37c0875b6c06a125a95ea2c09e168b1c548880ef
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libio-socket-ssl-perl/libio-socket-ssl-perl_2.067.orig.tar.gz' libio-socket-ssl-perl_2.067.orig.tar.gz 244899 SHA256:ef8842806d047cf56e2af64add4ed30b24547bcbb50e8df33cee0c54609af1c1
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libio-socket-ssl-perl/libio-socket-ssl-perl_2.067-1.debian.tar.xz' libio-socket-ssl-perl_2.067-1.debian.tar.xz 10268 SHA256:b8f2ece82be07235eb4347a86c41f0bfe1c37385648611658bde5863cd18ced5
```

### `dpkg` source package: `libipc-system-simple-perl=1.26-1`

Binary Packages:

- `libipc-system-simple-perl=1.26-1`

Licenses: (parsed from: `/usr/share/doc/libipc-system-simple-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libipc-system-simple-perl=1.26-1
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libipc-system-simple-perl/libipc-system-simple-perl_1.26-1.dsc' libipc-system-simple-perl_1.26-1.dsc 2515 SHA256:d817622b20f8ce7c4cb9ebfd7b6069989c73bc83cfa04a9906c0f4a401cbe3e3
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libipc-system-simple-perl/libipc-system-simple-perl_1.26.orig.tar.gz' libipc-system-simple-perl_1.26.orig.tar.gz 29989 SHA256:57177f21d8e8625bba32ea454f10a1fda16f93c1baf1aa80d106ab1951b465fd
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libipc-system-simple-perl/libipc-system-simple-perl_1.26-1.debian.tar.xz' libipc-system-simple-perl_1.26-1.debian.tar.xz 3304 SHA256:057db1c853f431de5ce244131cd46043b8409e703baef9568ddb978fd2f84674
```

### `dpkg` source package: `libjpeg-turbo=2.0.3-0ubuntu1.20.04.3`

Binary Packages:

- `libjpeg-turbo8:amd64=2.0.3-0ubuntu1.20.04.3`

Licenses: (parsed from: `/usr/share/doc/libjpeg-turbo8/copyright`)

- `JPEG`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libjpeg-turbo=2.0.3-0ubuntu1.20.04.3
'http://archive.ubuntu.com/ubuntu/pool/main/libj/libjpeg-turbo/libjpeg-turbo_2.0.3-0ubuntu1.20.04.3.dsc' libjpeg-turbo_2.0.3-0ubuntu1.20.04.3.dsc 2337 SHA512:0855a6f5af33892e285752fc44766d902424b8390777b2432dbdff56a6e8275832010018012a54b395c64c0233cbd35f080000cc6780a4546549215638e4abc6
'http://archive.ubuntu.com/ubuntu/pool/main/libj/libjpeg-turbo/libjpeg-turbo_2.0.3.orig.tar.gz' libjpeg-turbo_2.0.3.orig.tar.gz 2161279 SHA512:745cc3d50b43dd84721bc3c341d561ffd7f54eda5bbe2d56cad62f4b51ea76da3b18aba9ca694a9db79379aba7a9971cb146387979e96ca6ece950871276cf2f
'http://archive.ubuntu.com/ubuntu/pool/main/libj/libjpeg-turbo/libjpeg-turbo_2.0.3-0ubuntu1.20.04.3.debian.tar.xz' libjpeg-turbo_2.0.3-0ubuntu1.20.04.3.debian.tar.xz 26328 SHA512:ce0f3f9e924cb24d114bccc65bada8f3f767e2a04f33d89f53cbbb59f884c87519e1d07d1610fa40af8dde5231a7d392e5483a30f563433fc41eef61fab32267
```

### `dpkg` source package: `libjpeg8-empty=8c-2ubuntu8`

Binary Packages:

- `libjpeg8:amd64=8c-2ubuntu8`

Licenses: (parsed from: `/usr/share/doc/libjpeg8/copyright`)

- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libjpeg8-empty=8c-2ubuntu8
'http://archive.ubuntu.com/ubuntu/pool/main/libj/libjpeg8-empty/libjpeg8-empty_8c-2ubuntu8.dsc' libjpeg8-empty_8c-2ubuntu8.dsc 1637 SHA256:e7f575dcb3e0d462513b6f928179baa0ff1d145273934b1041b714515096b407
'http://archive.ubuntu.com/ubuntu/pool/main/libj/libjpeg8-empty/libjpeg8-empty_8c-2ubuntu8.tar.gz' libjpeg8-empty_8c-2ubuntu8.tar.gz 1770 SHA256:48a4227e9fc70851a4f304b10624e02875bf6f4e2debfcbe4ba0dd85a3ec05c6
```

### `dpkg` source package: `libksba=1.3.5-2ubuntu0.20.04.2`

Binary Packages:

- `libksba8:amd64=1.3.5-2ubuntu0.20.04.2`

Licenses: (parsed from: `/usr/share/doc/libksba8/copyright`)

- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris libksba=1.3.5-2ubuntu0.20.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/libk/libksba/libksba_1.3.5-2ubuntu0.20.04.2.dsc' libksba_1.3.5-2ubuntu0.20.04.2.dsc 2697 SHA512:d0c165b3bdfbc90459056b2758bc46e3f392ca660ab25e7661adf9a0325cdddef11ba6aa0a6411e737e0ea6490e28e94e6575e11cd893bc93b21ed90ed256fff
'http://archive.ubuntu.com/ubuntu/pool/main/libk/libksba/libksba_1.3.5.orig.tar.bz2' libksba_1.3.5.orig.tar.bz2 620649 SHA512:60179bfd109b7b4fd8d2b30a3216540f03f5a13620d9a5b63f1f95788028708a420911619f172ba57e945a6a2fcd2ef7eaafc5585a0eb2b9652cfadf47bf39a2
'http://archive.ubuntu.com/ubuntu/pool/main/libk/libksba/libksba_1.3.5.orig.tar.bz2.asc' libksba_1.3.5.orig.tar.bz2.asc 287 SHA512:6b58b1c6ee924230e4f3b040836e85cb3b3f527f667bcb370c28d8ec702c884bcceab374688e02d0356dede81f9fcf975d726c1958d4d87e5c41757a6b2ba39e
'http://archive.ubuntu.com/ubuntu/pool/main/libk/libksba/libksba_1.3.5-2ubuntu0.20.04.2.debian.tar.xz' libksba_1.3.5-2ubuntu0.20.04.2.debian.tar.xz 15308 SHA512:a2289eb5c73dcef41bf8b66c70ddb216ebabf1912b81ad79af6db32c3b6c351a5c5dab703cabdbbc11026c6f7cc4433ca6a3ff6a031ee500cab625ba7ea30fc9
```

### `dpkg` source package: `liblangtag=0.6.3-1`

Binary Packages:

- `liblangtag-common=0.6.3-1`
- `liblangtag1:amd64=0.6.3-1`

Licenses: (parsed from: `/usr/share/doc/liblangtag-common/copyright`, `/usr/share/doc/liblangtag1/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL | MPL`

Source:

```console
$ apt-get source -qq --print-uris liblangtag=0.6.3-1
'http://archive.ubuntu.com/ubuntu/pool/main/libl/liblangtag/liblangtag_0.6.3-1.dsc' liblangtag_0.6.3-1.dsc 2409 SHA256:c0dca4af195dd5972990b3689172fb0c5565b2ebd69083e25bbe0be3250ea331
'http://archive.ubuntu.com/ubuntu/pool/main/libl/liblangtag/liblangtag_0.6.3.orig.tar.bz2' liblangtag_0.6.3.orig.tar.bz2 755492 SHA256:1f12a20a02ec3a8d22e54dedb8b683a43c9c160bda1ba337bf1060607ae733bd
'http://archive.ubuntu.com/ubuntu/pool/main/libl/liblangtag/liblangtag_0.6.3-1.debian.tar.xz' liblangtag_0.6.3-1.debian.tar.xz 6352 SHA256:8e71e75220bb7a4006ac8e8c3c1413871a29a87afcd006d45ddcd5acd79a5d9e
```

### `dpkg` source package: `liblqr=0.4.2-2.1`

Binary Packages:

- `liblqr-1-0:amd64=0.4.2-2.1`

Licenses: (parsed from: `/usr/share/doc/liblqr-1-0/copyright`)

- `GPL-3`
- `GPLv3`
- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris liblqr=0.4.2-2.1
'http://archive.ubuntu.com/ubuntu/pool/universe/libl/liblqr/liblqr_0.4.2-2.1.dsc' liblqr_0.4.2-2.1.dsc 2095 SHA256:c54c34cd2f7470a29366eeacde2ca4859a97d684a406fb81a918b970c01d617c
'http://archive.ubuntu.com/ubuntu/pool/universe/libl/liblqr/liblqr_0.4.2.orig.tar.gz' liblqr_0.4.2.orig.tar.gz 439884 SHA256:d4c22373432cca749e4326cd41fce365e6ff857c0bfd7a5302b8eb34b69f0336
'http://archive.ubuntu.com/ubuntu/pool/universe/libl/liblqr/liblqr_0.4.2-2.1.debian.tar.xz' liblqr_0.4.2-2.1.debian.tar.xz 5300 SHA256:284a002f1ecac63ac17b1aafbb230da9ce7bd9efe2d5b94e8cad49b607eb2564
```

### `dpkg` source package: `liblwp-mediatypes-perl=6.04-1`

Binary Packages:

- `liblwp-mediatypes-perl=6.04-1`

Licenses: (parsed from: `/usr/share/doc/liblwp-mediatypes-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris liblwp-mediatypes-perl=6.04-1
'http://archive.ubuntu.com/ubuntu/pool/main/libl/liblwp-mediatypes-perl/liblwp-mediatypes-perl_6.04-1.dsc' liblwp-mediatypes-perl_6.04-1.dsc 2167 SHA256:3bd2934d4bbb99bfa80c666711f484d15cd4266a67339f26f5056eb23669c55a
'http://archive.ubuntu.com/ubuntu/pool/main/libl/liblwp-mediatypes-perl/liblwp-mediatypes-perl_6.04.orig.tar.gz' liblwp-mediatypes-perl_6.04.orig.tar.gz 40000 SHA256:8f1bca12dab16a1c2a7c03a49c5e58cce41a6fec9519f0aadfba8dad997919d9
'http://archive.ubuntu.com/ubuntu/pool/main/libl/liblwp-mediatypes-perl/liblwp-mediatypes-perl_6.04-1.debian.tar.xz' liblwp-mediatypes-perl_6.04-1.debian.tar.xz 2244 SHA256:48590b8cf59c79d9ac1f7a735a725ae1099c4f9cf43a3817e994bb18d811ac48
```

### `dpkg` source package: `liblwp-protocol-https-perl=6.07-2ubuntu2`

Binary Packages:

- `liblwp-protocol-https-perl=6.07-2ubuntu2`

Licenses: (parsed from: `/usr/share/doc/liblwp-protocol-https-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris liblwp-protocol-https-perl=6.07-2ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/libl/liblwp-protocol-https-perl/liblwp-protocol-https-perl_6.07-2ubuntu2.dsc' liblwp-protocol-https-perl_6.07-2ubuntu2.dsc 2497 SHA256:a8dd64d7b93b338ca28e1079ecc2f3f51e23447a86372fb934d2ee4084dd15b2
'http://archive.ubuntu.com/ubuntu/pool/main/libl/liblwp-protocol-https-perl/liblwp-protocol-https-perl_6.07.orig.tar.gz' liblwp-protocol-https-perl_6.07.orig.tar.gz 9184 SHA256:522cc946cf84a1776304a5737a54b8822ec9e79b264d0ba0722a70473dbfb9e7
'http://archive.ubuntu.com/ubuntu/pool/main/libl/liblwp-protocol-https-perl/liblwp-protocol-https-perl_6.07-2ubuntu2.debian.tar.xz' liblwp-protocol-https-perl_6.07-2ubuntu2.debian.tar.xz 4416 SHA256:f59cde43caa5667c21df86a9572ed6d3e9f0e5b007f4803173f3b8a60937c1a4
```

### `dpkg` source package: `libmailtools-perl=2.21-1`

Binary Packages:

- `libmailtools-perl=2.21-1`

Licenses: (parsed from: `/usr/share/doc/libmailtools-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libmailtools-perl=2.21-1
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmailtools-perl/libmailtools-perl_2.21-1.dsc' libmailtools-perl_2.21-1.dsc 2326 SHA256:ff030ed490005c751f275d9af4e1ad98d509ab7bfe573efa32f6db1006483bf0
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmailtools-perl/libmailtools-perl_2.21.orig.tar.gz' libmailtools-perl_2.21.orig.tar.gz 58013 SHA256:4ad9bd6826b6f03a2727332466b1b7d29890c8d99a32b4b3b0a8d926ee1a44cb
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmailtools-perl/libmailtools-perl_2.21-1.debian.tar.xz' libmailtools-perl_2.21-1.debian.tar.xz 6808 SHA256:6023c5ba5e1b7d304f2f42d0d6381d842662e6a11ff37f06e5ff88456aae22d3
```

### `dpkg` source package: `libmspub=0.1.4-1build3`

Binary Packages:

- `libmspub-0.1-1:amd64=0.1.4-1build3`

Licenses: (parsed from: `/usr/share/doc/libmspub-0.1-1/copyright`)

- `MPL-2.0`

Source:

```console
$ apt-get source -qq --print-uris libmspub=0.1.4-1build3
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmspub/libmspub_0.1.4-1build3.dsc' libmspub_0.1.4-1build3.dsc 2154 SHA256:17cc3b067d0b16e292c267caf3610f95a9751aaaafb998d9f5311f573ebcd67d
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmspub/libmspub_0.1.4.orig.tar.xz' libmspub_0.1.4.orig.tar.xz 377472 SHA256:ef36c1a1aabb2ba3b0bedaaafe717bf4480be2ba8de6f3894be5fd3702b013ba
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmspub/libmspub_0.1.4-1build3.debian.tar.xz' libmspub_0.1.4-1build3.debian.tar.xz 7264 SHA256:64ab5ad15ebb9366290cff2704362535bce85336344ec8e936f41f3b17390f1d
```

### `dpkg` source package: `libmwaw=0.3.15-2build1`

Binary Packages:

- `libmwaw-0.3-3:amd64=0.3.15-2build1`

Licenses: (parsed from: `/usr/share/doc/libmwaw-0.3-3/copyright`)

- `BSD`
- `LGPL`
- `MPL2.0 | LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris libmwaw=0.3.15-2build1
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmwaw/libmwaw_0.3.15-2build1.dsc' libmwaw_0.3.15-2build1.dsc 2121 SHA256:776f7aab6ff69fdf322857af187a4912843395e8a3bfde7b64cc7ee8b2a0133b
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmwaw/libmwaw_0.3.15.orig.tar.xz' libmwaw_0.3.15.orig.tar.xz 1289744 SHA256:0440bb09f05e3419423d8dfa36ee847056ebfd837f9cbc091fdb5b057daab0b1
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmwaw/libmwaw_0.3.15-2build1.debian.tar.xz' libmwaw_0.3.15-2build1.debian.tar.xz 8276 SHA256:3b190346318d6296a9c9974109edc5d4036e3356be5ecfc59bfaa9372d701699
```

### `dpkg` source package: `libmysofa=1.0~dfsg0-1`

Binary Packages:

- `libmysofa1:amd64=1.0~dfsg0-1`

Licenses: (parsed from: `/usr/share/doc/libmysofa1/copyright`)

- `BSD-3-clause`
- `CC-BY-4.0`
- `CC-BY-SA-3.0`
- `cipic`
- `listen-ircam`
- `mit-kemar`

Source:

```console
$ apt-get source -qq --print-uris libmysofa=1.0~dfsg0-1
'http://archive.ubuntu.com/ubuntu/pool/universe/libm/libmysofa/libmysofa_1.0%7edfsg0-1.dsc' libmysofa_1.0~dfsg0-1.dsc 2318 SHA256:2e4ae110a3ecb90ddb34224345ee5ddfc890649ffb42027dc4470090a7a58d83
'http://archive.ubuntu.com/ubuntu/pool/universe/libm/libmysofa/libmysofa_1.0%7edfsg0.orig.tar.xz' libmysofa_1.0~dfsg0.orig.tar.xz 44282004 SHA256:7728b958826f36ee4b17a505426881d6ef2ecc1e79a8feaefb2ead309e90f63c
'http://archive.ubuntu.com/ubuntu/pool/universe/libm/libmysofa/libmysofa_1.0%7edfsg0-1.debian.tar.xz' libmysofa_1.0~dfsg0-1.debian.tar.xz 15292 SHA256:9871ba69864f753e5ad2c69cef1236c6043213a24fc8e6259819c0d46c16d6fe
```

### `dpkg` source package: `libnet-dbus-perl=1.2.0-1`

Binary Packages:

- `libnet-dbus-perl=1.2.0-1`

Licenses: (parsed from: `/usr/share/doc/libnet-dbus-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libnet-dbus-perl=1.2.0-1
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-dbus-perl/libnet-dbus-perl_1.2.0-1.dsc' libnet-dbus-perl_1.2.0-1.dsc 2482 SHA256:fa8060493e2efc732582e8606c96e142eb41eb01f212d09721002021441a9fce
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-dbus-perl/libnet-dbus-perl_1.2.0.orig.tar.gz' libnet-dbus-perl_1.2.0.orig.tar.gz 108296 SHA256:e7a1ac9ef4a1235b3fdbd5888f86c347182306467bd79abc9b0756a64b441cbc
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-dbus-perl/libnet-dbus-perl_1.2.0-1.debian.tar.xz' libnet-dbus-perl_1.2.0-1.debian.tar.xz 3792 SHA256:2ee97c31b9b9ea8013fb44ccd88edf70940555d7aac696e1011201841a39071a
```

### `dpkg` source package: `libnet-http-perl=6.19-1`

Binary Packages:

- `libnet-http-perl=6.19-1`

Licenses: (parsed from: `/usr/share/doc/libnet-http-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libnet-http-perl=6.19-1
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-http-perl/libnet-http-perl_6.19-1.dsc' libnet-http-perl_6.19-1.dsc 2134 SHA256:216a35aeb08df6bf856d622fa7596e17ad38aa2c3ed468db6fcce56d46c509b6
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-http-perl/libnet-http-perl_6.19.orig.tar.gz' libnet-http-perl_6.19.orig.tar.gz 36937 SHA256:52b76ec13959522cae64d965f15da3d99dcb445eddd85d2ce4e4f4df385b2fc4
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-http-perl/libnet-http-perl_6.19-1.debian.tar.xz' libnet-http-perl_6.19-1.debian.tar.xz 3468 SHA256:e54277bfa8e102b2fea9e3f39ff64748d4877813269da864a5978339a136f446
```

### `dpkg` source package: `libnet-smtp-ssl-perl=1.04-1`

Binary Packages:

- `libnet-smtp-ssl-perl=1.04-1`

Licenses: (parsed from: `/usr/share/doc/libnet-smtp-ssl-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libnet-smtp-ssl-perl=1.04-1
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-smtp-ssl-perl/libnet-smtp-ssl-perl_1.04-1.dsc' libnet-smtp-ssl-perl_1.04-1.dsc 2268 SHA256:9429f4671338f756fc68b344cbf3a92a8624e71af68471c841c284ae32907b70
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-smtp-ssl-perl/libnet-smtp-ssl-perl_1.04.orig.tar.gz' libnet-smtp-ssl-perl_1.04.orig.tar.gz 2457 SHA256:7b29c45add19d3d5084b751f7ba89a8e40479a446ce21cfd9cc741e558332a00
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-smtp-ssl-perl/libnet-smtp-ssl-perl_1.04-1.debian.tar.xz' libnet-smtp-ssl-perl_1.04-1.debian.tar.xz 2696 SHA256:5826b6569145f52a575084a6f8da3601b361e4a2940218149b1591146f9499c6
```

### `dpkg` source package: `libnet-ssleay-perl=1.88-2ubuntu1`

Binary Packages:

- `libnet-ssleay-perl=1.88-2ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libnet-ssleay-perl/copyright`)

- `Artistic`
- `Artistic-2.0`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libnet-ssleay-perl=1.88-2ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-ssleay-perl/libnet-ssleay-perl_1.88-2ubuntu1.dsc' libnet-ssleay-perl_1.88-2ubuntu1.dsc 2421 SHA256:6f5ba55727facfc4256296757444b53340112c85e92d5a0c83f4db606b939e7b
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-ssleay-perl/libnet-ssleay-perl_1.88.orig.tar.xz' libnet-ssleay-perl_1.88.orig.tar.xz 343508 SHA256:43db8c0c60b5ecd5dd7cb40cc6dcfe57de18ce246734e24d86b21436661983f3
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnet-ssleay-perl/libnet-ssleay-perl_1.88-2ubuntu1.debian.tar.xz' libnet-ssleay-perl_1.88-2ubuntu1.debian.tar.xz 12072 SHA256:45d729b9497ff46fa6ac3cd744377bc38809f75e00043d0dea804ec7faeaae06
```

### `dpkg` source package: `libodfgen=0.1.7-1ubuntu2`

Binary Packages:

- `libodfgen-0.1-1:amd64=0.1.7-1ubuntu2`

Licenses: (parsed from: `/usr/share/doc/libodfgen-0.1-1/copyright`)

- `LGPL`
- `MPL-2.0 | LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris libodfgen=0.1.7-1ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/libo/libodfgen/libodfgen_0.1.7-1ubuntu2.dsc' libodfgen_0.1.7-1ubuntu2.dsc 1989 SHA256:ff0e105c47b9d653ce72e5e351dcb3899c733eca62afa7e4b188ea8ffda6451e
'http://archive.ubuntu.com/ubuntu/pool/main/libo/libodfgen/libodfgen_0.1.7.orig.tar.xz' libodfgen_0.1.7.orig.tar.xz 384760 SHA256:323e491f956c8ca2abb12c998e350670930a32317bf9662b0615dd4b3922b831
'http://archive.ubuntu.com/ubuntu/pool/main/libo/libodfgen/libodfgen_0.1.7-1ubuntu2.debian.tar.xz' libodfgen_0.1.7-1ubuntu2.debian.tar.xz 7044 SHA256:5a8615a9def13ee730ecbf7d887c2152275ef5f1a685723928b48bfd9b328421
```

### `dpkg` source package: `libogg=1.3.4-0ubuntu1`

Binary Packages:

- `libogg0:amd64=1.3.4-0ubuntu1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libogg=1.3.4-0ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/libo/libogg/libogg_1.3.4-0ubuntu1.dsc' libogg_1.3.4-0ubuntu1.dsc 1089 SHA256:e223bf149636be0a870768c0e1ecdb178d144dd424a9ebe1899f3ac8979f321f
'http://archive.ubuntu.com/ubuntu/pool/main/libo/libogg/libogg_1.3.4-0ubuntu1.tar.gz' libogg_1.3.4-0ubuntu1.tar.gz 601888 SHA256:4edf841124d651c65fbacf38507d5b7001481b3c084d5d9050f19c2d35b1ee81
```

### `dpkg` source package: `libopenmpt=0.4.11-1build1`

Binary Packages:

- `libopenmpt0:amd64=0.4.11-1build1`

Licenses: (parsed from: `/usr/share/doc/libopenmpt0/copyright`)

- `BSD-3-clause`
- `GNU-All-Permissive-License`
- `GNU-All-Permissive-License-FSF`
- `GPL-2`
- `GPL-2+ with Autoconf exception`
- `GPL-2+ with LibTool exception`
- `GPL-3`
- `GPL-3+ with AutoConf exception`
- `GPL-3+ with Autoconf Macros exception`
- `X11`

Source:

```console
$ apt-get source -qq --print-uris libopenmpt=0.4.11-1build1
'http://archive.ubuntu.com/ubuntu/pool/universe/libo/libopenmpt/libopenmpt_0.4.11-1build1.dsc' libopenmpt_0.4.11-1build1.dsc 2619 SHA256:c7a9925957127f8d63bc06f7a19dd6095d687340ebad20b421aa259dbafb7c36
'http://archive.ubuntu.com/ubuntu/pool/universe/libo/libopenmpt/libopenmpt_0.4.11.orig.tar.gz' libopenmpt_0.4.11.orig.tar.gz 1471760 SHA256:260e92cc2f6af37113442bff2c75a3c36a09eba4078dc593203a0502f95d26bd
'http://archive.ubuntu.com/ubuntu/pool/universe/libo/libopenmpt/libopenmpt_0.4.11-1build1.debian.tar.xz' libopenmpt_0.4.11-1build1.debian.tar.xz 13116 SHA256:cd4ea753ecc9890cc2ce36bf3d6d5ca4323162275af7623909b8390f4d8f973c
```

### `dpkg` source package: `liborcus=0.15.3-3build2`

Binary Packages:

- `liborcus-0.15-0:amd64=0.15.3-3build2`

Licenses: (parsed from: `/usr/share/doc/liborcus-0.15-0/copyright`)

- `Expat`
- `GPL-2`
- `GPL-2+`
- `GPL-3+`
- `MIT`
- `MPL-2.0`
- `other`

Source:

```console
$ apt-get source -qq --print-uris liborcus=0.15.3-3build2
'http://archive.ubuntu.com/ubuntu/pool/main/libo/liborcus/liborcus_0.15.3-3build2.dsc' liborcus_0.15.3-3build2.dsc 2842 SHA256:ad4431a8fa578bbdcfaf13808cef1518b04f5e81ef5392cbe756f20b1fe16dbe
'http://archive.ubuntu.com/ubuntu/pool/main/libo/liborcus/liborcus_0.15.3.orig.tar.xz' liborcus_0.15.3.orig.tar.xz 1988748 SHA256:3a6d50127937f2347b145c5ca3e9cf9401421c09e004d535a94ed8b235b6eb91
'http://archive.ubuntu.com/ubuntu/pool/main/libo/liborcus/liborcus_0.15.3-3build2.debian.tar.xz' liborcus_0.15.3-3build2.debian.tar.xz 12524 SHA256:5ce82f625fdedd325e5465ba6b4b488144093ed716662b1f3a8375eb85da5034
```

### `dpkg` source package: `libpagemaker=0.0.4-1build1`

Binary Packages:

- `libpagemaker-0.0-0:amd64=0.0.4-1build1`

Licenses: (parsed from: `/usr/share/doc/libpagemaker-0.0-0/copyright`)

- `MPL-2.0`

Source:

```console
$ apt-get source -qq --print-uris libpagemaker=0.0.4-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpagemaker/libpagemaker_0.0.4-1build1.dsc' libpagemaker_0.0.4-1build1.dsc 2057 SHA256:47e960e567fca3a8514d3e3c543faa13d5633f55003ee69c7410559b32c827e0
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpagemaker/libpagemaker_0.0.4.orig.tar.xz' libpagemaker_0.0.4.orig.tar.xz 306496 SHA256:66adacd705a7d19895e08eac46d1e851332adf2e736c566bef1164e7a442519d
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpagemaker/libpagemaker_0.0.4-1build1.debian.tar.xz' libpagemaker_0.0.4-1build1.debian.tar.xz 6708 SHA256:b60d1571012ead641b4589f6d50f4c175647e74db6da31ed2a2791b7fd06db45
```

### `dpkg` source package: `libpaper=1.1.28`

Binary Packages:

- `libpaper-utils=1.1.28`
- `libpaper1:amd64=1.1.28`

Licenses: (parsed from: `/usr/share/doc/libpaper-utils/copyright`, `/usr/share/doc/libpaper1/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris libpaper=1.1.28
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpaper/libpaper_1.1.28.dsc' libpaper_1.1.28.dsc 1633 SHA256:298d6347d84ece2f55088e371facc13362c8f4731d80f94c6ad84190309de8b4
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpaper/libpaper_1.1.28.tar.gz' libpaper_1.1.28.tar.gz 42356 SHA256:c8bb946ec93d3c2c72bbb1d7257e90172a22a44a07a07fb6b802a5bb2c95fddc
```

### `dpkg` source package: `libpciaccess=0.16-0ubuntu1`

Binary Packages:

- `libpciaccess0:amd64=0.16-0ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libpciaccess0/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris libpciaccess=0.16-0ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpciaccess/libpciaccess_0.16-0ubuntu1.dsc' libpciaccess_0.16-0ubuntu1.dsc 1554 SHA256:7a69bc588b31fddaced85ec551fa75b92a8654c1da090326fba0571ca74c9129
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpciaccess/libpciaccess_0.16.orig.tar.gz' libpciaccess_0.16.orig.tar.gz 470061 SHA256:84413553994aef0070cf420050aa5c0a51b1956b404920e21b81e96db6a61a27
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpciaccess/libpciaccess_0.16-0ubuntu1.diff.gz' libpciaccess_0.16-0ubuntu1.diff.gz 25561 SHA256:d5beb9c0d60fa77c3c9ec90d188bb14875d64e0be5644716d1e615caa93d9461
```

### `dpkg` source package: `libpgm=5.2.122~dfsg-3ubuntu1`

Binary Packages:

- `libpgm-5.2-0:amd64=5.2.122~dfsg-3ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libpgm-5.2-0/copyright`)

- `BSD-3-clause`
- `ISC`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libpgm=5.2.122~dfsg-3ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/universe/libp/libpgm/libpgm_5.2.122%7edfsg-3ubuntu1.dsc' libpgm_5.2.122~dfsg-3ubuntu1.dsc 1875 SHA256:148f9d50cdd3c60c237face64cf6a6697e7a8f475a468227175320f025256654
'http://archive.ubuntu.com/ubuntu/pool/universe/libp/libpgm/libpgm_5.2.122%7edfsg.orig.tar.xz' libpgm_5.2.122~dfsg.orig.tar.xz 550996 SHA256:d6e5ec0918216d4e9b14459f5742f6f8416df965f03ac4d854bd5d111709b507
'http://archive.ubuntu.com/ubuntu/pool/universe/libp/libpgm/libpgm_5.2.122%7edfsg-3ubuntu1.debian.tar.xz' libpgm_5.2.122~dfsg-3ubuntu1.debian.tar.xz 7420 SHA256:fcb1ace182328e64ba48ca2086b5a9f5bd23a515d9c79174346b27d6fc8fd363
```

### `dpkg` source package: `libpng1.6=1.6.37-2`

Binary Packages:

- `libpng16-16:amd64=1.6.37-2`

Licenses: (parsed from: `/usr/share/doc/libpng16-16/copyright`)

- `Apache-2.0`
- `BSD-3-clause`
- `BSD-like-with-advertising-clause`
- `GPL-2`
- `GPL-2+`
- `expat`
- `libpng`
- `libpng OR Apache-2.0 OR BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris libpng1.6=1.6.37-2
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpng1.6/libpng1.6_1.6.37-2.dsc' libpng1.6_1.6.37-2.dsc 2225 SHA256:4567a54b5804e068e61477e9cd78346557b85b72add10ef10f130a5be169662e
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpng1.6/libpng1.6_1.6.37.orig.tar.gz' libpng1.6_1.6.37.orig.tar.gz 1508805 SHA256:ca74a0dace179a8422187671aee97dd3892b53e168627145271cad5b5ac81307
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpng1.6/libpng1.6_1.6.37-2.debian.tar.xz' libpng1.6_1.6.37-2.debian.tar.xz 31844 SHA256:097cee0f0da4013d0231d37e090204ab3fa592b4fecdaaed3fca8d13affcaae8
```

### `dpkg` source package: `libproxy=0.4.15-10ubuntu1.2`

Binary Packages:

- `libproxy1v5:amd64=0.4.15-10ubuntu1.2`

Licenses: (parsed from: `/usr/share/doc/libproxy1v5/copyright`)

- `GPL`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libproxy=0.4.15-10ubuntu1.2
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libproxy/libproxy_0.4.15-10ubuntu1.2.dsc' libproxy_0.4.15-10ubuntu1.2.dsc 3613 SHA512:6774a3833b3f78c63f9d7b9e26b9c467070f8c2ae7b531fef4d64a639fb851df69449a46cc2dc6d9a76583063dfc7383868824d1c554cec629ca74e3babc5f58
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libproxy/libproxy_0.4.15.orig.tar.gz' libproxy_0.4.15.orig.tar.gz 93084 SHA512:8f68bd56e44aeb3f553f4657bef82a5d14302780508dafa32454d6f724b724c884ceed6042f8df53a081d26ea0b05598cf35eab44823257c47c5ef8afb36442b
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libproxy/libproxy_0.4.15-10ubuntu1.2.debian.tar.xz' libproxy_0.4.15-10ubuntu1.2.debian.tar.xz 15888 SHA512:e667a569e7db42c8f812d51d26354cf57dd5ee8796b657c7f648722f58788032e1ba199a8684b167ffbc41e53449997efe7e4e3e582db1fcd1fa8355eabe1a69
```

### `dpkg` source package: `libpsl=0.21.0-1ubuntu1`

Binary Packages:

- `libpsl5:amd64=0.21.0-1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libpsl5/copyright`)

- `Chromium`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris libpsl=0.21.0-1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpsl/libpsl_0.21.0-1ubuntu1.dsc' libpsl_0.21.0-1ubuntu1.dsc 2383 SHA256:38d6cf06b8ac1929efe109ac3d5f37ea6e89ea82f7a5125db4dc7a7b5f3faf94
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpsl/libpsl_0.21.0.orig.tar.gz' libpsl_0.21.0.orig.tar.gz 8598583 SHA256:055aa87ec166c7afb985d0816c07ff440e1eb899881a318c51c69a0aeea8e279
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpsl/libpsl_0.21.0-1ubuntu1.debian.tar.xz' libpsl_0.21.0-1ubuntu1.debian.tar.xz 12476 SHA256:efd6c7ae8c244b582d6af943b5925d95a31a183abf695301f2fa49de9f694671
```

### `dpkg` source package: `libpthread-stubs=0.4-1`

Binary Packages:

- `libpthread-stubs0-dev:amd64=0.4-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libpthread-stubs=0.4-1
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpthread-stubs/libpthread-stubs_0.4-1.dsc' libpthread-stubs_0.4-1.dsc 1927 SHA256:8923683ac365475d2cc515e5f16f4adc8bd8e37453e1a2a6bedeb9246922829f
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpthread-stubs/libpthread-stubs_0.4.orig.tar.gz' libpthread-stubs_0.4.orig.tar.gz 71252 SHA256:50d5686b79019ccea08bcbd7b02fe5a40634abcfd4146b6e75c6420cc170e9d9
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpthread-stubs/libpthread-stubs_0.4-1.diff.gz' libpthread-stubs_0.4-1.diff.gz 2346 SHA256:ec435ba2852ad4b0522010943a5b7d39fc7e088067367879778cf10e57f5cc3f
```

### `dpkg` source package: `libraw1394=2.1.2-1`

Binary Packages:

- `libraw1394-11:amd64=2.1.2-1`

Licenses: (parsed from: `/usr/share/doc/libraw1394-11/copyright`)

- `GPL`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris libraw1394=2.1.2-1
'http://archive.ubuntu.com/ubuntu/pool/main/libr/libraw1394/libraw1394_2.1.2-1.dsc' libraw1394_2.1.2-1.dsc 2080 SHA256:d8b7cb13f4a73fa0dae8d61d5b4ded82b3f02d6b3584ac77c671432d250988f4
'http://archive.ubuntu.com/ubuntu/pool/main/libr/libraw1394/libraw1394_2.1.2.orig.tar.gz' libraw1394_2.1.2.orig.tar.gz 458134 SHA256:ddc4e32721cdfe680d964aaede68ac606a20cd17dd2ba70e2d7e0692086ab57c
'http://archive.ubuntu.com/ubuntu/pool/main/libr/libraw1394/libraw1394_2.1.2-1.debian.tar.xz' libraw1394_2.1.2-1.debian.tar.xz 8760 SHA256:5cee0e0049d820a8e4e5d3dbd94fb2c3d7b782ec09134c6c714ed523829dc1c3
```

### `dpkg` source package: `libreoffice=1:6.4.7-0ubuntu0.20.04.12`

Binary Packages:

- `fonts-opensymbol=2:102.11+LibO6.4.7-0ubuntu0.20.04.12`
- `libjuh-java=1:6.4.7-0ubuntu0.20.04.12`
- `libjurt-java=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-base=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-base-core=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-base-drivers=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-calc=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-common=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-core=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-draw=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-gnome=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-gtk3=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-impress=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-java-common=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-math=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-nlpsolver=0.9+LibO6.4.7-0ubuntu0.20.04.12`
- `libreoffice-report-builder=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-report-builder-bin=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-script-provider-bsh=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-script-provider-js=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-script-provider-python=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-sdbc-firebird=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-sdbc-hsqldb=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-sdbc-mysql=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-sdbc-postgresql=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-style-colibre=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-style-elementary=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-style-tango=1:6.4.7-0ubuntu0.20.04.12`
- `libreoffice-wiki-publisher=1.2.0+LibO6.4.7-0ubuntu0.20.04.12`
- `libreoffice-writer=1:6.4.7-0ubuntu0.20.04.12`
- `libridl-java=1:6.4.7-0ubuntu0.20.04.12`
- `libuno-cppu3=1:6.4.7-0ubuntu0.20.04.12`
- `libuno-cppuhelpergcc3-3=1:6.4.7-0ubuntu0.20.04.12`
- `libuno-purpenvhelpergcc3-3=1:6.4.7-0ubuntu0.20.04.12`
- `libuno-sal3=1:6.4.7-0ubuntu0.20.04.12`
- `libuno-salhelpergcc3-3=1:6.4.7-0ubuntu0.20.04.12`
- `libunoil-java=1:6.4.7-0ubuntu0.20.04.12`
- `libunoloader-java=1:6.4.7-0ubuntu0.20.04.12`
- `python3-uno=1:6.4.7-0ubuntu0.20.04.12`
- `uno-libs-private=1:6.4.7-0ubuntu0.20.04.12`
- `ure=1:6.4.7-0ubuntu0.20.04.12`

Licenses: (parsed from: `/usr/share/doc/fonts-opensymbol/copyright`, `/usr/share/doc/libjuh-java/copyright`, `/usr/share/doc/libjurt-java/copyright`, `/usr/share/doc/libreoffice/copyright`, `/usr/share/doc/libreoffice-base/copyright`, `/usr/share/doc/libreoffice-base-core/copyright`, `/usr/share/doc/libreoffice-base-drivers/copyright`, `/usr/share/doc/libreoffice-calc/copyright`, `/usr/share/doc/libreoffice-common/copyright`, `/usr/share/doc/libreoffice-core/copyright`, `/usr/share/doc/libreoffice-draw/copyright`, `/usr/share/doc/libreoffice-gnome/copyright`, `/usr/share/doc/libreoffice-gtk3/copyright`, `/usr/share/doc/libreoffice-impress/copyright`, `/usr/share/doc/libreoffice-java-common/copyright`, `/usr/share/doc/libreoffice-math/copyright`, `/usr/share/doc/libreoffice-nlpsolver/copyright`, `/usr/share/doc/libreoffice-report-builder/copyright`, `/usr/share/doc/libreoffice-report-builder-bin/copyright`, `/usr/share/doc/libreoffice-script-provider-bsh/copyright`, `/usr/share/doc/libreoffice-script-provider-js/copyright`, `/usr/share/doc/libreoffice-script-provider-python/copyright`, `/usr/share/doc/libreoffice-sdbc-firebird/copyright`, `/usr/share/doc/libreoffice-sdbc-hsqldb/copyright`, `/usr/share/doc/libreoffice-sdbc-mysql/copyright`, `/usr/share/doc/libreoffice-sdbc-postgresql/copyright`, `/usr/share/doc/libreoffice-style-colibre/copyright`, `/usr/share/doc/libreoffice-style-elementary/copyright`, `/usr/share/doc/libreoffice-style-tango/copyright`, `/usr/share/doc/libreoffice-wiki-publisher/copyright`, `/usr/share/doc/libreoffice-writer/copyright`, `/usr/share/doc/libridl-java/copyright`, `/usr/share/doc/libuno-cppu3/copyright`, `/usr/share/doc/libuno-cppuhelpergcc3-3/copyright`, `/usr/share/doc/libuno-purpenvhelpergcc3-3/copyright`, `/usr/share/doc/libuno-sal3/copyright`, `/usr/share/doc/libuno-salhelpergcc3-3/copyright`, `/usr/share/doc/libunoil-java/copyright`, `/usr/share/doc/libunoloader-java/copyright`, `/usr/share/doc/python3-uno/copyright`, `/usr/share/doc/uno-libs-private/copyright`, `/usr/share/doc/ure/copyright`)

- `Apache-2.0`
- `CC-BY-SA-3.0`
- `CC-BY-SA-3.0 `
- `CC0-1.0`
- `Expat`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `LGPL-2`
- `LGPL-3`
- `LGPL-3+`
- `MPL-1.1`
- `MPL-2.0`
- `other`

Source:

```console
$ apt-get source -qq --print-uris libreoffice=1:6.4.7-0ubuntu0.20.04.12
'http://archive.ubuntu.com/ubuntu/pool/main/libr/libreoffice/libreoffice_6.4.7-0ubuntu0.20.04.12.dsc' libreoffice_6.4.7-0ubuntu0.20.04.12.dsc 30513 SHA512:3f41e6a82bca798b48306511279175a826e99855040aff1c08ba96ce9a6d0453ee68fc7aa6fb51b07d098e207a98452b74f95e57c6ac9b6e9f301448134e0721
'http://archive.ubuntu.com/ubuntu/pool/main/libr/libreoffice/libreoffice_6.4.7.orig-helpcontent2.tar.xz' libreoffice_6.4.7.orig-helpcontent2.tar.xz 88073752 SHA512:3d6459cd4eab764d1fc15eb6edd6c1b16272f51869de1e9379328e81e03adb146d73c2acaf147d13b8ccc9a99721e023d404a0cf2f99a05264cc5536604828da
'http://archive.ubuntu.com/ubuntu/pool/main/libr/libreoffice/libreoffice_6.4.7.orig-tarballs.tar.xz' libreoffice_6.4.7.orig-tarballs.tar.xz 200916520 SHA512:10dc6e7b0521dff9aea57859312bb9802e1671f52d97f0f3fb7e030e779f778842088160ee14f446a8cc457d67b21b683c90c94bf0aa797ff890b2dea344f5ab
'http://archive.ubuntu.com/ubuntu/pool/main/libr/libreoffice/libreoffice_6.4.7.orig-translations.tar.xz' libreoffice_6.4.7.orig-translations.tar.xz 179847328 SHA512:6496ce816b136504c9511aeac5e881f329360e144ea48f28e9b56720ed727719339703431e0e0cee931d721c0e2b308366f0a3af771ebc980952c410f400c1cd
'http://archive.ubuntu.com/ubuntu/pool/main/libr/libreoffice/libreoffice_6.4.7.orig.tar.xz' libreoffice_6.4.7.orig.tar.xz 211530416 SHA512:a0ee0c0e617b33655dce0fbb14e2af12c3d810a3a9631d4b2204a75c8ac64c8797ab52735b799d078e1fff5a14d188ee850c239dab7bce4035a7ca704d6caa97
'http://archive.ubuntu.com/ubuntu/pool/main/libr/libreoffice/libreoffice_6.4.7-0ubuntu0.20.04.12.debian.tar.xz' libreoffice_6.4.7-0ubuntu0.20.04.12.debian.tar.xz 2438248 SHA512:3f39a18601ec24fa3ba4ec785bfa865aabdce85143245d5417d904a107ced24c4079e6e965ba15f681b69c290121c56cac4570f892506206513dd250cf142f5f
```

### `dpkg` source package: `librest=0.8.1-1`

Binary Packages:

- `librest-0.7-0:amd64=0.8.1-1`

Licenses: (parsed from: `/usr/share/doc/librest-0.7-0/copyright`)

- `FSF-INSTALL`
- `FSF-aclocal`
- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `MIT with XConsortium exception `

Source:

```console
$ apt-get source -qq --print-uris librest=0.8.1-1
'http://archive.ubuntu.com/ubuntu/pool/main/libr/librest/librest_0.8.1-1.dsc' librest_0.8.1-1.dsc 2418 SHA256:0ec122ae048847cc8203b72a7377da475b614ee91c37654163e0622194f122bb
'http://archive.ubuntu.com/ubuntu/pool/main/libr/librest/librest_0.8.1.orig.tar.bz2' librest_0.8.1.orig.tar.bz2 68249 SHA256:9063b9906c3a4684bef6ccaad9462e8409e1025fe37b7c9596fcf2f5f7507904
'http://archive.ubuntu.com/ubuntu/pool/main/libr/librest/librest_0.8.1-1.debian.tar.xz' librest_0.8.1-1.debian.tar.xz 6696 SHA256:9bfb3d85e7904cf8d740932a3bba10b5baf7f2ca371887d9fe0b16af8d34fc32
```

### `dpkg` source package: `librevenge=0.0.4-6ubuntu5`

Binary Packages:

- `librevenge-0.0-0:amd64=0.0.4-6ubuntu5`

Licenses: (parsed from: `/usr/share/doc/librevenge-0.0-0/copyright`)

- `LGPL-2.1`
- `MPL-1.1 | GPL-3+ | LGPL-3+`
- `MPL-2.0`

Source:

```console
$ apt-get source -qq --print-uris librevenge=0.0.4-6ubuntu5
'http://archive.ubuntu.com/ubuntu/pool/main/libr/librevenge/librevenge_0.0.4-6ubuntu5.dsc' librevenge_0.0.4-6ubuntu5.dsc 2147 SHA256:98bfa1d8acc54dcbcff288d539990bc308bc63547d6352b27e9c60a57c98b778
'http://archive.ubuntu.com/ubuntu/pool/main/libr/librevenge/librevenge_0.0.4.orig.tar.bz2' librevenge_0.0.4.orig.tar.bz2 529833 SHA256:c51601cd08320b75702812c64aae0653409164da7825fd0f451ac2c5dbe77cbf
'http://archive.ubuntu.com/ubuntu/pool/main/libr/librevenge/librevenge_0.0.4-6ubuntu5.debian.tar.xz' librevenge_0.0.4-6ubuntu5.debian.tar.xz 13916 SHA256:5676593079a965cf7121aef78ff5a030e4160ca8c100082e0e1d9ec34c84e8e9
```

### `dpkg` source package: `librsvg=2.48.9-1ubuntu0.20.04.4`

Binary Packages:

- `librsvg2-2:amd64=2.48.9-1ubuntu0.20.04.4`
- `librsvg2-common:amd64=2.48.9-1ubuntu0.20.04.4`

Licenses: (parsed from: `/usr/share/doc/librsvg2-2/copyright`, `/usr/share/doc/librsvg2-common/copyright`)

- `Apache-2.0`
- `BSD-2-clause`
- `BSD-3-clause`
- `Boost-1.0`
- `Expat`
- `LGPL-2`
- `LGPL-2+`
- `MPL-2.0`
- `Sun-permissive`
- `Unlicense`

Source:

```console
$ apt-get source -qq --print-uris librsvg=2.48.9-1ubuntu0.20.04.4
'http://archive.ubuntu.com/ubuntu/pool/main/libr/librsvg/librsvg_2.48.9-1ubuntu0.20.04.4.dsc' librsvg_2.48.9-1ubuntu0.20.04.4.dsc 3067 SHA512:1210df38cd3a71a6a48a2ff0fd5d87d8bb39ac880ea0c697210734e286d2d7f32d4242ff56bc2e8ef1e1e0469607c88ca8ad8c1017ca887aa82084664695e2c2
'http://archive.ubuntu.com/ubuntu/pool/main/libr/librsvg/librsvg_2.48.9.orig.tar.xz' librsvg_2.48.9.orig.tar.xz 12661188 SHA512:4edfba4d667536ef921e72da53e4a357e56cae6db5e7e93c23d6792241b31b2397e68633dbb0df465129ce68f0ef1ba55cc51f2321adc6f4874fe7089715bb5c
'http://archive.ubuntu.com/ubuntu/pool/main/libr/librsvg/librsvg_2.48.9-1ubuntu0.20.04.4.debian.tar.xz' librsvg_2.48.9-1ubuntu0.20.04.4.debian.tar.xz 28056 SHA512:35fff922ea1efe4ae5b9aecad9120fd46c706712d6886de95d14049788c01a383a9f354161b4e23ff9c137968755dafddfe1924de20c3e389d56bdbe7fa69b1b
```

### `dpkg` source package: `libsamplerate=0.1.9-2`

Binary Packages:

- `libsamplerate0:amd64=0.1.9-2`

Licenses: (parsed from: `/usr/share/doc/libsamplerate0/copyright`)

- `BSD-2-clause`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris libsamplerate=0.1.9-2
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsamplerate/libsamplerate_0.1.9-2.dsc' libsamplerate_0.1.9-2.dsc 2159 SHA256:a424910e1cdcfc8596a086c3256af8b63af450f4d0bc244fab3163cbb8e1707a
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsamplerate/libsamplerate_0.1.9.orig.tar.gz' libsamplerate_0.1.9.orig.tar.gz 4336641 SHA256:0a7eb168e2f21353fb6d84da152e4512126f7dc48ccb0be80578c565413444c1
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsamplerate/libsamplerate_0.1.9-2.debian.tar.xz' libsamplerate_0.1.9-2.debian.tar.xz 7496 SHA256:9fb3e5e7724f327272b7228ea267bfbb53be214db35778d85e3a9ce5e618634b
```

### `dpkg` source package: `libsdl2=2.0.10+dfsg1-3`

Binary Packages:

- `libsdl2-2.0-0:amd64=2.0.10+dfsg1-3`

Licenses: (parsed from: `/usr/share/doc/libsdl2-2.0-0/copyright`)

- `BSD-3-clause`
- `BSD-3-clause-chromium`
- `BSD-3-clause-kitware`
- `BrownUn_UnCalifornia_ErikCorry`
- `Expat-like`
- `Gareth_McCaughan`
- `LGPL-2.1`
- `LGPL-2.1+`
- `MIT/X11`
- `PublicDomain_David_Ludwig`
- `PublicDomain_Edgar_Simo`
- `PublicDomain_Sam_Lantinga`
- `RSA_Data_Security`
- `SGI-Free-Software-License-B`
- `SunPro`
- `zlib/libpng`

Source:

```console
$ apt-get source -qq --print-uris libsdl2=2.0.10+dfsg1-3
'http://archive.ubuntu.com/ubuntu/pool/universe/libs/libsdl2/libsdl2_2.0.10%2bdfsg1-3.dsc' libsdl2_2.0.10+dfsg1-3.dsc 2827 SHA256:e91f04119fdf20cbb28c7cdc437a97dd8910d1c0c29c6a526345acf5a5236c01
'http://archive.ubuntu.com/ubuntu/pool/universe/libs/libsdl2/libsdl2_2.0.10%2bdfsg1.orig.tar.xz' libsdl2_2.0.10+dfsg1.orig.tar.xz 2550516 SHA256:8a425d050c492cd0c352b522beea2c379938c4be0d47607db5b1b68f2ddc7fee
'http://archive.ubuntu.com/ubuntu/pool/universe/libs/libsdl2/libsdl2_2.0.10%2bdfsg1-3.debian.tar.xz' libsdl2_2.0.10+dfsg1-3.debian.tar.xz 22512 SHA256:fb6b7a079c7f50df6f205952b95d6d1897b1fee4b2ca85c0ffbc7ff683f794e6
```

### `dpkg` source package: `libseccomp=2.5.1-1ubuntu1~20.04.2`

Binary Packages:

- `libseccomp2:amd64=2.5.1-1ubuntu1~20.04.2`

Licenses: (parsed from: `/usr/share/doc/libseccomp2/copyright`)

- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libseccomp=2.5.1-1ubuntu1~20.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libseccomp/libseccomp_2.5.1-1ubuntu1%7e20.04.2.dsc' libseccomp_2.5.1-1ubuntu1~20.04.2.dsc 2578 SHA512:ea3e505f936011ea2d37eb5c9c10fb0f7ead4f699180679940c1e27936c1b28fc96b40f98d4e25e1e058466244d08d29c2d538fff85d726808c2cec45f914509
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libseccomp/libseccomp_2.5.1.orig.tar.gz' libseccomp_2.5.1.orig.tar.gz 638811 SHA512:2be80a6323f9282dbeae8791724e5778b32e2382b2a3d1b0f77366371ec4072ea28128204f675cce101c091c0420d12c497e1a9ccbb7dc5bcbf61bfd777160af
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libseccomp/libseccomp_2.5.1-1ubuntu1%7e20.04.2.debian.tar.xz' libseccomp_2.5.1-1ubuntu1~20.04.2.debian.tar.xz 21168 SHA512:77187efe846d46f3cff589b048cd446f13f1d0d60274b54fa464e337288b9fd3979e1f3b6f4999af00e12738232b9397e485e977a732f74cb89cfa5bf90a21be
```

### `dpkg` source package: `libselinux=3.0-1build2`

Binary Packages:

- `libselinux1:amd64=3.0-1build2`

Licenses: (parsed from: `/usr/share/doc/libselinux1/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libselinux=3.0-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libselinux/libselinux_3.0-1build2.dsc' libselinux_3.0-1build2.dsc 2565 SHA256:9a8d6c354ed06350606c009d899d117e71fda20887792b2c25b38222d0190d93
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libselinux/libselinux_3.0.orig.tar.gz' libselinux_3.0.orig.tar.gz 212096 SHA256:2ea2b30f671dae9d6b1391cbe8fb2ce5d36a3ee4fb1cd3c32f0d933c31b82433
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libselinux/libselinux_3.0-1build2.debian.tar.xz' libselinux_3.0-1build2.debian.tar.xz 23720 SHA256:ed85da0fe5561205c95f0f622562425dc7d8dd61ffd213a7fa914d778fe8da71
```

### `dpkg` source package: `libsemanage=3.0-1build2`

Binary Packages:

- `libsemanage-common=3.0-1build2`
- `libsemanage1:amd64=3.0-1build2`

Licenses: (parsed from: `/usr/share/doc/libsemanage-common/copyright`, `/usr/share/doc/libsemanage1/copyright`)

- `GPL`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris libsemanage=3.0-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsemanage/libsemanage_3.0-1build2.dsc' libsemanage_3.0-1build2.dsc 2678 SHA256:6231f4b00991657fafef2595eb571b2bcbe437de4ec9dc9929c0e69187db5f33
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsemanage/libsemanage_3.0.orig.tar.gz' libsemanage_3.0.orig.tar.gz 180745 SHA256:a497b0720d54eac427f1f3f618eed417e50ed8f4e47ed0f7a1d391bd416e84cf
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsemanage/libsemanage_3.0-1build2.debian.tar.xz' libsemanage_3.0-1build2.debian.tar.xz 17176 SHA256:38a646f91532c920c8c15a695c3585397ddbf032ecf49c52eb89d53c8eac48fb
```

### `dpkg` source package: `libsepol=3.0-1ubuntu0.1`

Binary Packages:

- `libsepol1:amd64=3.0-1ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libsepol1/copyright`)

- `GPL`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris libsepol=3.0-1ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsepol/libsepol_3.0-1ubuntu0.1.dsc' libsepol_3.0-1ubuntu0.1.dsc 2084 SHA512:4fa31e95c4f00cdac984d0cd7ffdd4ca6d3a9be529723cc227316e9f4bb76b5910102f136aab505de422f9794c4641912720c8dffb10e6ae0523058fa96850d8
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsepol/libsepol_3.0.orig.tar.gz' libsepol_3.0.orig.tar.gz 473864 SHA512:82a5bae0afd9ae53b55ddcfc9f6dd61724a55e45aef1d9cd0122d1814adf2abe63c816a7ac63b64b401f5c67acb910dd8e0574eec546bed04da7842ab6c3bb55
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsepol/libsepol_3.0-1ubuntu0.1.debian.tar.xz' libsepol_3.0-1ubuntu0.1.debian.tar.xz 16980 SHA512:eeade6f2ad6eb2aa2846e850516f56da34bdf6dab2e6024c94799c273e6815976a09509b999306337107e3e21cbb5243c29dc515b4c48bfb51d2dfe9c3ed0da6
```

### `dpkg` source package: `libsm=2:1.2.3-1`

Binary Packages:

- `libsm-dev:amd64=2:1.2.3-1`
- `libsm6:amd64=2:1.2.3-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libsm=2:1.2.3-1
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsm/libsm_1.2.3-1.dsc' libsm_1.2.3-1.dsc 2063 SHA256:5488f8de81d53c32cbb5f062b6a6f262cd067283b8082041392dc60f0d04002c
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsm/libsm_1.2.3.orig.tar.gz' libsm_1.2.3.orig.tar.gz 445362 SHA256:1e92408417cb6c6c477a8a6104291001a40b3bb56a4a60608fdd9cd2c5a0f320
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsm/libsm_1.2.3-1.diff.gz' libsm_1.2.3-1.diff.gz 8929 SHA256:7eb99ab50b19f26d1470f89e4b46891f6a697cb1794a58ed0d1376cceaf1b6a9
```

### `dpkg` source package: `libsndfile=1.0.28-7ubuntu0.2`

Binary Packages:

- `libsndfile1:amd64=1.0.28-7ubuntu0.2`

Licenses: (parsed from: `/usr/share/doc/libsndfile1/copyright`)

- `Apache-2.0`
- `BSD-3-clause`
- `FSFAP`
- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `gsm`
- `sun`

Source:

```console
$ apt-get source -qq --print-uris libsndfile=1.0.28-7ubuntu0.2
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsndfile/libsndfile_1.0.28-7ubuntu0.2.dsc' libsndfile_1.0.28-7ubuntu0.2.dsc 2356 SHA512:bcf43d51d729f28a524e4e7b426312f05f1c18edb0eeaf7de1fc767ca016a0f2f9e75237cbaf7f5266e8d7fe2950432a1d1cd8d7b8c8e434f26bb5af14c7f3a2
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsndfile/libsndfile_1.0.28.orig.tar.gz' libsndfile_1.0.28.orig.tar.gz 1202833 SHA512:890731a6b8173f714155ce05eaf6d991b31632c8ab207fbae860968861a107552df26fcf85602df2e7f65502c7256c1b41735e1122485a3a07ddb580aa83b57f
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsndfile/libsndfile_1.0.28-7ubuntu0.2.debian.tar.xz' libsndfile_1.0.28-7ubuntu0.2.debian.tar.xz 22304 SHA512:672c63c1edbd25ca996110dd3c53ddf905284e35945b975e67c25914fd8a7b3207deb3cdf8693e3d0bd9b211c59ac89755fb519dc9ee45477d01c7fe75e57867
```

### `dpkg` source package: `libsodium=1.0.18-1`

Binary Packages:

- `libsodium23:amd64=1.0.18-1`

Licenses: (parsed from: `/usr/share/doc/libsodium23/copyright`)

- `BSD-2-clause`
- `CC0`
- `CC0-1.0`
- `GPL-2`
- `GPL-2+`
- `ISC`
- `MIT`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris libsodium=1.0.18-1
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsodium/libsodium_1.0.18-1.dsc' libsodium_1.0.18-1.dsc 1913 SHA256:037b3ac05a50409cb462e2c21c7a67f983d193a22d2486f4ab3fdc793f5a731c
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsodium/libsodium_1.0.18.orig.tar.gz' libsodium_1.0.18.orig.tar.gz 1619527 SHA256:d59323c6b712a1519a5daf710b68f5e7fde57040845ffec53850911f10a5d4f4
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsodium/libsodium_1.0.18-1.debian.tar.xz' libsodium_1.0.18-1.debian.tar.xz 7440 SHA256:50863d8fc4f0a2a86f7b69745514455f0b9d74cf45906523c675ffe5b8db0377
```

### `dpkg` source package: `libsoup2.4=2.70.0-1`

Binary Packages:

- `libsoup-gnome2.4-1:amd64=2.70.0-1`
- `libsoup2.4-1:amd64=2.70.0-1`

Licenses: (parsed from: `/usr/share/doc/libsoup-gnome2.4-1/copyright`, `/usr/share/doc/libsoup2.4-1/copyright`)

- `Expat`
- `LGPL-2`
- `LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris libsoup2.4=2.70.0-1
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsoup2.4/libsoup2.4_2.70.0-1.dsc' libsoup2.4_2.70.0-1.dsc 3318 SHA256:f9912c8963b6f38c8f60c530a22f47089eeedc68d748716be5c9777a5170c114
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsoup2.4/libsoup2.4_2.70.0.orig.tar.xz' libsoup2.4_2.70.0.orig.tar.xz 1494220 SHA256:54b020f74aefa438918d8e53cff62e2b1e59efe2de53e06b19a4b07b1f4d5342
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsoup2.4/libsoup2.4_2.70.0-1.debian.tar.xz' libsoup2.4_2.70.0-1.debian.tar.xz 24272 SHA256:108bcfc24d745bfd7e5204cfc12e1f4d894634481da222c11118ef065cac99b9
```

### `dpkg` source package: `libsoxr=0.1.3-2build1`

Binary Packages:

- `libsoxr0:amd64=0.1.3-2build1`

Licenses: (parsed from: `/usr/share/doc/libsoxr0/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`
- `Spherepack`
- `permissive1`
- `permissive2`

Source:

```console
$ apt-get source -qq --print-uris libsoxr=0.1.3-2build1
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsoxr/libsoxr_0.1.3-2build1.dsc' libsoxr_0.1.3-2build1.dsc 1468 SHA256:9efa85a763a8620252d222771a14978659557d4310c87554752208ffa20909cf
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsoxr/libsoxr_0.1.3.orig.tar.xz' libsoxr_0.1.3.orig.tar.xz 94384 SHA256:b111c15fdc8c029989330ff559184198c161100a59312f5dc19ddeb9b5a15889
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsoxr/libsoxr_0.1.3-2build1.debian.tar.xz' libsoxr_0.1.3-2build1.debian.tar.xz 5144 SHA256:a4babd7b0e752627846e7e7c9b2bba98a30b2f75a89b1dd9b242343dbaff5a70
```

### `dpkg` source package: `libssh=0.9.3-2ubuntu2.5`

Binary Packages:

- `libssh-4:amd64=0.9.3-2ubuntu2.5`
- `libssh-gcrypt-4:amd64=0.9.3-2ubuntu2.5`

Licenses: (parsed from: `/usr/share/doc/libssh-4/copyright`, `/usr/share/doc/libssh-gcrypt-4/copyright`)

- `BSD-2-clause`
- `BSD-3-clause`
- `LGPL-2.1`
- `LGPL-2.1+~OpenSSL`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris libssh=0.9.3-2ubuntu2.5
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libssh/libssh_0.9.3-2ubuntu2.5.dsc' libssh_0.9.3-2ubuntu2.5.dsc 2538 SHA512:dd905eeaa75320e90a03c9dd37bfc462bbaadd022d68c07b1224227cca57a71eed215c017e23df82a37821f87f32e608c4f6e3cabffdf175190e6ed0cf3e5140
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libssh/libssh_0.9.3.orig.tar.xz' libssh_0.9.3.orig.tar.xz 500068 SHA512:6e59718565daeca6d224426cc1095a112deff9af8e0b021917e04f08bb7409263c35724de95f591f38e26f0fb3bbbbc69b679b6775edc21dec158d241b076c6f
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libssh/libssh_0.9.3-2ubuntu2.5.debian.tar.xz' libssh_0.9.3-2ubuntu2.5.debian.tar.xz 54112 SHA512:784e6ec20522eb9526cb4f3981c9c4d3b80879a3d06f80617fb26fd604ab8459e425ac7482fe5a7f0e2ab7f408edab578b66ea0beda4abb6b1e5e0cc1cc9b1cf
```

### `dpkg` source package: `libtasn1-6=4.16.0-2`

Binary Packages:

- `libtasn1-6:amd64=4.16.0-2`

Licenses: (parsed from: `/usr/share/doc/libtasn1-6/copyright`)

- `GFDL-1.3`
- `GPL-3`
- `LGPL`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libtasn1-6=4.16.0-2
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtasn1-6/libtasn1-6_4.16.0-2.dsc' libtasn1-6_4.16.0-2.dsc 2586 SHA256:fd4a387c71f95c3eceb1072a3f42c7021d73128027ea41a18d6efc6cbfdd764a
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtasn1-6/libtasn1-6_4.16.0.orig.tar.gz' libtasn1-6_4.16.0.orig.tar.gz 1812442 SHA256:0e0fb0903839117cb6e3b56e68222771bebf22ad7fc2295a0ed7d576e8d4329d
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtasn1-6/libtasn1-6_4.16.0.orig.tar.gz.asc' libtasn1-6_4.16.0.orig.tar.gz.asc 488 SHA256:06c201e8c3b43c27465ed79294d4c4ec8dcd3e95e4a6176ecbf273229ee3e2d0
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtasn1-6/libtasn1-6_4.16.0-2.debian.tar.xz' libtasn1-6_4.16.0-2.debian.tar.xz 17740 SHA256:c1a89b0bac0fb7c83ebac4eafbca0475c24350ade6ccaef31266424725610624
```

### `dpkg` source package: `libtext-iconv-perl=1.7-7`

Binary Packages:

- `libtext-iconv-perl=1.7-7`

Licenses: (parsed from: `/usr/share/doc/libtext-iconv-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libtext-iconv-perl=1.7-7
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtext-iconv-perl/libtext-iconv-perl_1.7-7.dsc' libtext-iconv-perl_1.7-7.dsc 2242 SHA256:7fd0b1d78c4d461acbc397469f2f712c3eb2b47f1ba0b7c7369c6b394b61a3df
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtext-iconv-perl/libtext-iconv-perl_1.7.orig.tar.bz2' libtext-iconv-perl_1.7.orig.tar.bz2 9977 SHA256:815c5169b7afc40bc6f681b4c615ff8fb0e073d87422280c8c759a4666567490
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtext-iconv-perl/libtext-iconv-perl_1.7-7.debian.tar.xz' libtext-iconv-perl_1.7-7.debian.tar.xz 3388 SHA256:7a190875bc60395d81ae36d73290694cd8f0158abbe6ea6759b038a65d838286
```

### `dpkg` source package: `libthai=0.1.28-3`

Binary Packages:

- `libthai-data=0.1.28-3`
- `libthai0:amd64=0.1.28-3`

Licenses: (parsed from: `/usr/share/doc/libthai-data/copyright`, `/usr/share/doc/libthai0/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris libthai=0.1.28-3
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libthai/libthai_0.1.28-3.dsc' libthai_0.1.28-3.dsc 2346 SHA256:a6317b6a8e4ba40cedb10a9a659fc23885bfbe5eb8cf3a8b325a86064b0a542d
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libthai/libthai_0.1.28.orig.tar.xz' libthai_0.1.28.orig.tar.xz 413592 SHA256:ffe0a17b4b5aa11b153c15986800eca19f6c93a4025ffa5cf2cab2dcdf1ae911
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libthai/libthai_0.1.28-3.debian.tar.xz' libthai_0.1.28-3.debian.tar.xz 12128 SHA256:bca48abd9d040e844ebcb1f91a6ab4bcdfad66e36c1143f79d60461e933fddf9
```

### `dpkg` source package: `libtheora=1.1.1+dfsg.1-15ubuntu2`

Binary Packages:

- `libtheora0:amd64=1.1.1+dfsg.1-15ubuntu2`

Licenses: (parsed from: `/usr/share/doc/libtheora0/copyright`)

- `BSD-3-Clause`

Source:

```console
$ apt-get source -qq --print-uris libtheora=1.1.1+dfsg.1-15ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtheora/libtheora_1.1.1%2bdfsg.1-15ubuntu2.dsc' libtheora_1.1.1+dfsg.1-15ubuntu2.dsc 2747 SHA256:55ca08c02cd83b9921afa0a2d009b578d4efea97b02f6a881102104c842a5a52
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtheora/libtheora_1.1.1%2bdfsg.1.orig.tar.gz' libtheora_1.1.1+dfsg.1.orig.tar.gz 2100495 SHA256:c59b0f07a7314dfe2ade15c41bc9f637f8a450fc6b340af61b81760629f28f90
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtheora/libtheora_1.1.1%2bdfsg.1-15ubuntu2.debian.tar.xz' libtheora_1.1.1+dfsg.1-15ubuntu2.debian.tar.xz 10964 SHA256:17ec83d759a100abb448e94dd4f3ffc81665f02972e02e19fdb1c2abb76183ff
```

### `dpkg` source package: `libtie-ixhash-perl=1.23-2`

Binary Packages:

- `libtie-ixhash-perl=1.23-2`

Licenses: (parsed from: `/usr/share/doc/libtie-ixhash-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libtie-ixhash-perl=1.23-2
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtie-ixhash-perl/libtie-ixhash-perl_1.23-2.dsc' libtie-ixhash-perl_1.23-2.dsc 2144 SHA256:01c7243e392562381da974596b60bbcdacb3afb663ef3757593e8f96df45c113
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtie-ixhash-perl/libtie-ixhash-perl_1.23.orig.tar.gz' libtie-ixhash-perl_1.23.orig.tar.gz 9352 SHA256:fabb0b8c97e67c9b34b6cc18ed66f6c5e01c55b257dcf007555e0b027d4caf56
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtie-ixhash-perl/libtie-ixhash-perl_1.23-2.debian.tar.xz' libtie-ixhash-perl_1.23-2.debian.tar.xz 2036 SHA256:2a80c08ef174e7797b1f32feac55169b9579d6401392703c7989de287234720b
```

### `dpkg` source package: `libtimedate-perl=2.3200-1`

Binary Packages:

- `libtimedate-perl=2.3200-1`

Licenses: (parsed from: `/usr/share/doc/libtimedate-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libtimedate-perl=2.3200-1
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtimedate-perl/libtimedate-perl_2.3200-1.dsc' libtimedate-perl_2.3200-1.dsc 2384 SHA256:8855e2b3f28dd8f5c556ab138489735b44364dc1bcff313257e97566508e5889
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtimedate-perl/libtimedate-perl_2.3200.orig.tar.gz' libtimedate-perl_2.3200.orig.tar.gz 29973 SHA256:34eca099e375e2d142ea6cc935922c4980dc21c65ce7c24823ca08457c4bb3d6
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtimedate-perl/libtimedate-perl_2.3200-1.debian.tar.xz' libtimedate-perl_2.3200-1.debian.tar.xz 5048 SHA256:ae2c40149b7cb28f6ab7b422876b3a16e5f7c91efbaa9715393f67bf264d9bec
```

### `dpkg` source package: `libtommath=1.2.0-3ubuntu0.1`

Binary Packages:

- `libtommath1:amd64=1.2.0-3ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libtommath1/copyright`)

- `Unlicense`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris libtommath=1.2.0-3ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtommath/libtommath_1.2.0-3ubuntu0.1.dsc' libtommath_1.2.0-3ubuntu0.1.dsc 2572 SHA512:9647ee6ffc98c60bd11d1937a0d76078bb49d8c62b16880e60005432557de369fdd35a725e0baabe6f37eb8cb8486fec238cfc6b72fe2410c661edba16b8c2df
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtommath/libtommath_1.2.0.orig.tar.xz' libtommath_1.2.0.orig.tar.xz 622120 SHA512:6f9ccd0691831f07f86ddc81cb6145504b3d5da66dd3e92312c64cce0ea986fa4e08ba65ca8991aaebe56702c2d7c15f309696785b813dffb4c112a4ad04b203
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtommath/libtommath_1.2.0.orig.tar.xz.asc' libtommath_1.2.0.orig.tar.xz.asc 240 SHA512:b651ca98575eb885ca7498feb79a3bf11db081fe81d29d66cbd250c6d196e3629e5e2c82a3c56ebb4d972f6c0c67e1df53eb086afeac6ff0db09e96c65a10e38
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtommath/libtommath_1.2.0-3ubuntu0.1.debian.tar.xz' libtommath_1.2.0-3ubuntu0.1.debian.tar.xz 20692 SHA512:278b59bd451606b138f1f857b2515e6ba6cb490dc9f2cfaf9d249e461a44a645936fc7088dc26d7427b828037ce1131e91a26c7b285300ce68d4c3de63d0a99e
```

### `dpkg` source package: `libtool=2.4.6-14`

Binary Packages:

- `libltdl7:amd64=2.4.6-14`

Licenses: (parsed from: `/usr/share/doc/libltdl7/copyright`)

- `GFDL`
- `GPL`

Source:

```console
$ apt-get source -qq --print-uris libtool=2.4.6-14
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtool/libtool_2.4.6-14.dsc' libtool_2.4.6-14.dsc 2500 SHA256:939797b7ce62f69641d319e5d38e53b1608cee649355046eec74271e9fcfb9df
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtool/libtool_2.4.6.orig.tar.xz' libtool_2.4.6.orig.tar.xz 973080 SHA256:7c87a8c2c8c0fc9cd5019e402bed4292462d00a718a7cd5f11218153bf28b26f
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtool/libtool_2.4.6.orig.tar.xz.asc' libtool_2.4.6.orig.tar.xz.asc 380 SHA256:ab68ebc45d60128a71fc36167cd29dcf3c3d6d639fd28663905ebaf3e2f43d6a
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtool/libtool_2.4.6-14.debian.tar.xz' libtool_2.4.6-14.debian.tar.xz 50832 SHA256:3ef693ea30def97a19fd94ffb2fa5421d5dc35cf7ad897a7161bd647eb4f2415
```

### `dpkg` source package: `libtry-tiny-perl=0.30-1`

Binary Packages:

- `libtry-tiny-perl=0.30-1`

Licenses: (parsed from: `/usr/share/doc/libtry-tiny-perl/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris libtry-tiny-perl=0.30-1
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtry-tiny-perl/libtry-tiny-perl_0.30-1.dsc' libtry-tiny-perl_0.30-1.dsc 2364 SHA256:8739ddcb041194c8a22ba8fdbcf84ccc7faeb414819a608062d19ec4dc4aa998
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtry-tiny-perl/libtry-tiny-perl_0.30.orig.tar.gz' libtry-tiny-perl_0.30.orig.tar.gz 34395 SHA256:da5bd0d5c903519bbf10bb9ba0cb7bcac0563882bcfe4503aee3fb143eddef6b
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtry-tiny-perl/libtry-tiny-perl_0.30-1.debian.tar.xz' libtry-tiny-perl_0.30-1.debian.tar.xz 3532 SHA256:ace34ed42919a033206b51570b96b763f76cff1225685c9da275b57cbf29a9a4
```

### `dpkg` source package: `libunistring=0.9.10-2`

Binary Packages:

- `libunistring2:amd64=0.9.10-2`

Licenses: (parsed from: `/usr/share/doc/libunistring2/copyright`)

- `FreeSoftware`
- `GFDL-1.2`
- `GFDL-1.2+`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with distribution exception`
- `GPL-3`
- `GPL-3+`
- `LGPL-3`
- `LGPL-3+`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris libunistring=0.9.10-2
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libunistring/libunistring_0.9.10-2.dsc' libunistring_0.9.10-2.dsc 2206 SHA256:c6faf64e2d978ec074ebf88264730121dfd03cc1639df94b5dc3eb05b1678532
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libunistring/libunistring_0.9.10.orig.tar.xz' libunistring_0.9.10.orig.tar.xz 2051320 SHA256:eb8fb2c3e4b6e2d336608377050892b54c3c983b646c561836550863003c05d7
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libunistring/libunistring_0.9.10.orig.tar.xz.asc' libunistring_0.9.10.orig.tar.xz.asc 1310 SHA256:e1606f691034fa21b00e08269622743547c16d21cca6c8a64156b4774a49e78e
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libunistring/libunistring_0.9.10-2.debian.tar.xz' libunistring_0.9.10-2.debian.tar.xz 40708 SHA256:5e291a1a15549d12c64575c72868a8c94586715d35062b5efb48fe9a9d09924e
```

### `dpkg` source package: `liburi-perl=1.76-2`

Binary Packages:

- `liburi-perl=1.76-2`

Licenses: (parsed from: `/usr/share/doc/liburi-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris liburi-perl=1.76-2
'http://archive.ubuntu.com/ubuntu/pool/main/libu/liburi-perl/liburi-perl_1.76-2.dsc' liburi-perl_1.76-2.dsc 2363 SHA256:d46dde698ea5739137e74ee105f62e78d123d271b609a6bbe3c4ccb4e8919bff
'http://archive.ubuntu.com/ubuntu/pool/main/libu/liburi-perl/liburi-perl_1.76.orig.tar.gz' liburi-perl_1.76.orig.tar.gz 107578 SHA256:b2c98e1d50d6f572483ee538a6f4ccc8d9185f91f0073fd8af7390898254413e
'http://archive.ubuntu.com/ubuntu/pool/main/libu/liburi-perl/liburi-perl_1.76-2.debian.tar.xz' liburi-perl_1.76-2.debian.tar.xz 5612 SHA256:0dd6cb2219f583b52037291f023622ae06894cccbcff76107ad3ca3863372a62
```

### `dpkg` source package: `libusb-1.0=2:1.0.23-2build1`

Binary Packages:

- `libusb-1.0-0:amd64=2:1.0.23-2build1`

Licenses: (parsed from: `/usr/share/doc/libusb-1.0-0/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libusb-1.0=2:1.0.23-2build1
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libusb-1.0/libusb-1.0_1.0.23-2build1.dsc' libusb-1.0_1.0.23-2build1.dsc 1462 SHA256:2f68c34daad14a3bef624787ed907debf613ed31bde3705d703d7c70b7c7d1d8
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libusb-1.0/libusb-1.0_1.0.23.orig.tar.bz2' libusb-1.0_1.0.23.orig.tar.bz2 602860 SHA256:db11c06e958a82dac52cf3c65cb4dd2c3f339c8a988665110e0d24d19312ad8d
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libusb-1.0/libusb-1.0_1.0.23-2build1.debian.tar.xz' libusb-1.0_1.0.23-2build1.debian.tar.xz 13768 SHA256:070f5b921f16ada6deeff9bb20405ec7653653c5e79284d1fe2b73c05adb9db6
```

### `dpkg` source package: `libva=2.7.0-2`

Binary Packages:

- `libva-drm2:amd64=2.7.0-2`
- `libva-x11-2:amd64=2.7.0-2`
- `libva2:amd64=2.7.0-2`
- `va-driver-all:amd64=2.7.0-2`

Licenses: (parsed from: `/usr/share/doc/libva-drm2/copyright`, `/usr/share/doc/libva-x11-2/copyright`, `/usr/share/doc/libva2/copyright`, `/usr/share/doc/va-driver-all/copyright`)

- `Expat`
- `Expat-advertising`
- `GPL-2`
- `GPL-2+`
- `other`

Source:

```console
$ apt-get source -qq --print-uris libva=2.7.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/libv/libva/libva_2.7.0-2.dsc' libva_2.7.0-2.dsc 2408 SHA256:abc15533ab9ca10c58572bbcbf99e681939461de8f2ea1ede38e575419ef41b1
'http://archive.ubuntu.com/ubuntu/pool/universe/libv/libva/libva_2.7.0.orig.tar.gz' libva_2.7.0.orig.tar.gz 236349 SHA256:0952ee21069c560f48ebafcba91e1ffb72e5a8736dbab3559af959221b51598f
'http://archive.ubuntu.com/ubuntu/pool/universe/libv/libva/libva_2.7.0-2.debian.tar.xz' libva_2.7.0-2.debian.tar.xz 13232 SHA256:9f8006b4d1577aa488eaa8e2843a8686e2053bf566acab6932d436b8bab4f3b3
```

### `dpkg` source package: `libvdpau=1.3-1ubuntu2`

Binary Packages:

- `libvdpau1:amd64=1.3-1ubuntu2`
- `vdpau-driver-all:amd64=1.3-1ubuntu2`

Licenses: (parsed from: `/usr/share/doc/libvdpau1/copyright`, `/usr/share/doc/vdpau-driver-all/copyright`)

- `Expat`
- `other`

Source:

```console
$ apt-get source -qq --print-uris libvdpau=1.3-1ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/libv/libvdpau/libvdpau_1.3-1ubuntu2.dsc' libvdpau_1.3-1ubuntu2.dsc 2394 SHA256:48e42640618fca592d58792939f199f9736bc872302b25645a699380de82cde4
'http://archive.ubuntu.com/ubuntu/pool/main/libv/libvdpau/libvdpau_1.3.orig.tar.bz2' libvdpau_1.3.orig.tar.bz2 139009 SHA256:b5a52eeac9417edbc396f26c40591ba5df0cd18285f68d84614ef8f06196e50e
'http://archive.ubuntu.com/ubuntu/pool/main/libv/libvdpau/libvdpau_1.3-1ubuntu2.debian.tar.xz' libvdpau_1.3-1ubuntu2.debian.tar.xz 11608 SHA256:2a77de4f403898c37030360a716f2a56035271760e9522e3e5e2d9f5a6eecbc2
```

### `dpkg` source package: `libvidstab=1.1.0-2`

Binary Packages:

- `libvidstab1.1:amd64=1.1.0-2`

Licenses: (parsed from: `/usr/share/doc/libvidstab1.1/copyright`)

- `GPL-2`
- `GPL-2.0+`

Source:

```console
$ apt-get source -qq --print-uris libvidstab=1.1.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/libv/libvidstab/libvidstab_1.1.0-2.dsc' libvidstab_1.1.0-2.dsc 1826 SHA256:fe500228434c80b7dc3798552a3c4023b1d086eeb18ce8d111f460e608972526
'http://archive.ubuntu.com/ubuntu/pool/universe/libv/libvidstab/libvidstab_1.1.0.orig.tar.gz' libvidstab_1.1.0.orig.tar.gz 77736 SHA256:14d2a053e56edad4f397be0cb3ef8eb1ec3150404ce99a426c4eb641861dc0bb
'http://archive.ubuntu.com/ubuntu/pool/universe/libv/libvidstab/libvidstab_1.1.0-2.debian.tar.xz' libvidstab_1.1.0-2.debian.tar.xz 3876 SHA256:c7a8ff87c37d68666c69f589929de5d25383f4932b6629af674c60e94f7e2ea6
```

### `dpkg` source package: `libvisio=0.1.7-1build2`

Binary Packages:

- `libvisio-0.1-1:amd64=0.1.7-1build2`

Licenses: (parsed from: `/usr/share/doc/libvisio-0.1-1/copyright`)

- `MIT | GPL-2`
- `MPL-2.0`

Source:

```console
$ apt-get source -qq --print-uris libvisio=0.1.7-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/libv/libvisio/libvisio_0.1.7-1build2.dsc' libvisio_0.1.7-1build2.dsc 2237 SHA256:b2471036513e4d718c6998be27e0df47a642cd220093e87cd80af5d8c2f07fe2
'http://archive.ubuntu.com/ubuntu/pool/main/libv/libvisio/libvisio_0.1.7.orig.tar.xz' libvisio_0.1.7.orig.tar.xz 854296 SHA256:8faf8df870cb27b09a787a1959d6c646faa44d0d8ab151883df408b7166bea4c
'http://archive.ubuntu.com/ubuntu/pool/main/libv/libvisio/libvisio_0.1.7-1build2.debian.tar.xz' libvisio_0.1.7-1build2.debian.tar.xz 8196 SHA256:504d6acf5c330a1d3315e4413bfd22b76f07ccc0b9a6a14d9022585d1d34537c
```

### `dpkg` source package: `libvisual=0.4.0-17`

Binary Packages:

- `libvisual-0.4-0:amd64=0.4.0-17`

Licenses: (parsed from: `/usr/share/doc/libvisual-0.4-0/copyright`)

- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris libvisual=0.4.0-17
'http://archive.ubuntu.com/ubuntu/pool/main/libv/libvisual/libvisual_0.4.0-17.dsc' libvisual_0.4.0-17.dsc 1945 SHA256:34f2ae4274167adfb6ad8d2c9bac55ca38f35c911581b50fbda8cbfdb89bebdc
'http://archive.ubuntu.com/ubuntu/pool/main/libv/libvisual/libvisual_0.4.0.orig.tar.gz' libvisual_0.4.0.orig.tar.gz 583386 SHA256:0b4dfdb87125e129567752089e3c8b54cefed601eef169d2533d8659da8dc1d7
'http://archive.ubuntu.com/ubuntu/pool/main/libv/libvisual/libvisual_0.4.0-17.debian.tar.xz' libvisual_0.4.0-17.debian.tar.xz 19984 SHA256:c91628df87d5826586bf9d350a37e4f9ef60ec24571da5749e7260b350d76681
```

### `dpkg` source package: `libvorbis=1.3.6-2ubuntu1`

Binary Packages:

- `libvorbis0a:amd64=1.3.6-2ubuntu1`
- `libvorbisenc2:amd64=1.3.6-2ubuntu1`
- `libvorbisfile3:amd64=1.3.6-2ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libvorbis0a/copyright`, `/usr/share/doc/libvorbisenc2/copyright`, `/usr/share/doc/libvorbisfile3/copyright`)

- `BSD-3-Clause`
- `RFC-special`

Source:

```console
$ apt-get source -qq --print-uris libvorbis=1.3.6-2ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/libv/libvorbis/libvorbis_1.3.6-2ubuntu1.dsc' libvorbis_1.3.6-2ubuntu1.dsc 2365 SHA256:9328f0bb009c3e1e546b34a0de7c12da45d2747ea8478163702171f820c5b6b7
'http://archive.ubuntu.com/ubuntu/pool/main/libv/libvorbis/libvorbis_1.3.6.orig.tar.gz' libvorbis_1.3.6.orig.tar.gz 1634357 SHA256:6ed40e0241089a42c48604dc00e362beee00036af2d8b3f46338031c9e0351cb
'http://archive.ubuntu.com/ubuntu/pool/main/libv/libvorbis/libvorbis_1.3.6-2ubuntu1.debian.tar.xz' libvorbis_1.3.6-2ubuntu1.debian.tar.xz 12236 SHA256:fec088a9ea864bb22d964bea6fbdeb49e5517f3501ffc9428524c27a09d04128
```

### `dpkg` source package: `libvpx=1.8.2-1ubuntu0.3`

Binary Packages:

- `libvpx6:amd64=1.8.2-1ubuntu0.3`

Licenses: (parsed from: `/usr/share/doc/libvpx6/copyright`)

- `BSD-3-Clause`
- `ISC`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris libvpx=1.8.2-1ubuntu0.3
'http://archive.ubuntu.com/ubuntu/pool/main/libv/libvpx/libvpx_1.8.2-1ubuntu0.3.dsc' libvpx_1.8.2-1ubuntu0.3.dsc 2362 SHA512:8eec4edb4fa49c4c8d51e382befe0d11538db49d93e56f6979ad7f67f977c81c8c540c8c361c46c24a47e51d5ac2c6d97b1e379df2137eef69e73b83b31f371a
'http://archive.ubuntu.com/ubuntu/pool/main/libv/libvpx/libvpx_1.8.2.orig.tar.gz' libvpx_1.8.2.orig.tar.gz 5312988 SHA512:da2ab0775a28ddd78654bbe46886e833d4ef7ba91867fc1427dceced735b6177eff06b24f204c075c50c3a5cadc5be6a1fb213c44df189218a543b52554f3a38
'http://archive.ubuntu.com/ubuntu/pool/main/libv/libvpx/libvpx_1.8.2-1ubuntu0.3.debian.tar.xz' libvpx_1.8.2-1ubuntu0.3.debian.tar.xz 17204 SHA512:6d716c7538f644ff5d82efe83d9055b0794e1513d82032c2b0cb1ecfa1a25434eec14c5c334ce9b52456bbea03f98dea5d171e926440fe1369f5b08b2fe4bada
```

### `dpkg` source package: `libwebp=0.6.1-2ubuntu0.20.04.3`

Binary Packages:

- `libwebp6:amd64=0.6.1-2ubuntu0.20.04.3`
- `libwebpmux3:amd64=0.6.1-2ubuntu0.20.04.3`

Licenses: (parsed from: `/usr/share/doc/libwebp6/copyright`, `/usr/share/doc/libwebpmux3/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris libwebp=0.6.1-2ubuntu0.20.04.3
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwebp/libwebp_0.6.1-2ubuntu0.20.04.3.dsc' libwebp_0.6.1-2ubuntu0.20.04.3.dsc 2185 SHA512:33627b740e59b83196c414f859d31c037e12cf4ec92ac2db7e60356141422cd6c7bfcc41bb07cc08095a8797d35ea0e3d869bc195e7a010754f5ac3acbcd10b0
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwebp/libwebp_0.6.1.orig.tar.gz' libwebp_0.6.1.orig.tar.gz 3554290 SHA512:313b345a01c91eb07c2e4d46b93fcda9c50dca9e05e39f757238a679355514a2e9bc9bc220f3d3eb6d6a55148957cb2be14dac330203953337759841af1a32bf
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwebp/libwebp_0.6.1-2ubuntu0.20.04.3.debian.tar.xz' libwebp_0.6.1-2ubuntu0.20.04.3.debian.tar.xz 21132 SHA512:f9bbf3f92f5c1cebae08828e475d84bd854870a02d65ac9373a7c10a09e445f032b4bf4becd69b81a609e76f96f12b2d087c6065b1e8427cee2effcbf28377b8
```

### `dpkg` source package: `libwmf=0.2.8.4-17ubuntu1`

Binary Packages:

- `libwmf0.2-7:amd64=0.2.8.4-17ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libwmf0.2-7/copyright`)

- `LGPL-2`

Source:

```console
$ apt-get source -qq --print-uris libwmf=0.2.8.4-17ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwmf/libwmf_0.2.8.4-17ubuntu1.dsc' libwmf_0.2.8.4-17ubuntu1.dsc 1642 SHA256:31f409e280954b2388e28305ac1c39b85eb141e7823b6fc5eff89194196c4e2a
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwmf/libwmf_0.2.8.4.orig.tar.gz' libwmf_0.2.8.4.orig.tar.gz 2169375 SHA256:5b345c69220545d003ad52bfd035d5d6f4f075e65204114a9e875e84895a7cf8
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwmf/libwmf_0.2.8.4-17ubuntu1.debian.tar.xz' libwmf_0.2.8.4-17ubuntu1.debian.tar.xz 12968 SHA256:3d78073cbb035aa87d780d617f647a3e42f4cf5e9c1ada5899f7d80ac306f318
```

### `dpkg` source package: `libwpd=0.10.3-1build1`

Binary Packages:

- `libwpd-0.10-10:amd64=0.10.3-1build1`

Licenses: (parsed from: `/usr/share/doc/libwpd-0.10-10/copyright`)

- `LGPL`
- `MPL-2.0 | LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris libwpd=0.10.3-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwpd/libwpd_0.10.3-1build1.dsc' libwpd_0.10.3-1build1.dsc 2098 SHA256:140519dab91f32bc5e25e054b26788090519ac8d1df63f81e412334fa4f08cb3
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwpd/libwpd_0.10.3.orig.tar.xz' libwpd_0.10.3.orig.tar.xz 534712 SHA256:2465b0b662fdc5d4e3bebcdc9a79027713fb629ca2bff04a3c9251fdec42dd09
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwpd/libwpd_0.10.3-1build1.debian.tar.xz' libwpd_0.10.3-1build1.debian.tar.xz 11628 SHA256:9d56c0452e4095d73c277b2f62a112c00ff96b66d82ac1aa6a001a93c0690ee5
```

### `dpkg` source package: `libwpg=0.3.3-1build1`

Binary Packages:

- `libwpg-0.3-3:amd64=0.3.3-1build1`

Licenses: (parsed from: `/usr/share/doc/libwpg-0.3-3/copyright`)

- `GPL`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris libwpg=0.3.3-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwpg/libwpg_0.3.3-1build1.dsc' libwpg_0.3.3-1build1.dsc 2070 SHA256:a4d91aa6d74fd56f02c637369f268d8c9de406355f64173f58f2b57240ab3d67
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwpg/libwpg_0.3.3.orig.tar.xz' libwpg_0.3.3.orig.tar.xz 328664 SHA256:99b3f7f8832385748582ab8130fbb9e5607bd5179bebf9751ac1d51a53099d1c
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwpg/libwpg_0.3.3-1build1.debian.tar.xz' libwpg_0.3.3-1build1.debian.tar.xz 9304 SHA256:221682e3c280bd4362aafc442991833e78b186d3432cf51cae43c1b41133f1e4
```

### `dpkg` source package: `libwps=0.4.10-1build1`

Binary Packages:

- `libwps-0.4-4:amd64=0.4.10-1build1`

Licenses: (parsed from: `/usr/share/doc/libwps-0.4-4/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`
- `MPL-2.0`

Source:

```console
$ apt-get source -qq --print-uris libwps=0.4.10-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwps/libwps_0.4.10-1build1.dsc' libwps_0.4.10-1build1.dsc 2287 SHA256:c78004bb7f820762d483ffdf2f8ba14a5a652d88cbce34a07eb972d8281873b2
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwps/libwps_0.4.10.orig.tar.xz' libwps_0.4.10.orig.tar.xz 695448 SHA256:1421e034286a9f96d3168a1c54ea570ee7aa008ca07b89de005ad5ce49fb29ca
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwps/libwps_0.4.10-1build1.debian.tar.xz' libwps_0.4.10-1build1.debian.tar.xz 9080 SHA256:da0d2e3637c899432e2f53234aa1d29b790700445af24aa9ea18d1c9d46c62e6
```

### `dpkg` source package: `libwww-perl=6.43-1`

Binary Packages:

- `libwww-perl=6.43-1`

Licenses: (parsed from: `/usr/share/doc/libwww-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libwww-perl=6.43-1
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwww-perl/libwww-perl_6.43-1.dsc' libwww-perl_6.43-1.dsc 2981 SHA256:695a90408de415a15e64aa7349c2309e4aab021a6addee2ca65107b14a5cdfbc
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwww-perl/libwww-perl_6.43.orig.tar.gz' libwww-perl_6.43.orig.tar.gz 174966 SHA256:e9849d7ee6fd0e89cc999e63d7612c951afd6aeea6bc721b767870d9df4ac40d
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwww-perl/libwww-perl_6.43-1.debian.tar.xz' libwww-perl_6.43-1.debian.tar.xz 10496 SHA256:42f7d52af4f9d3d656f07375d849b6ac7b6295e0b60fef1ad7518b8c3d43e347
```

### `dpkg` source package: `libwww-robotrules-perl=6.02-1`

Binary Packages:

- `libwww-robotrules-perl=6.02-1`

Licenses: (parsed from: `/usr/share/doc/libwww-robotrules-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libwww-robotrules-perl=6.02-1
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwww-robotrules-perl/libwww-robotrules-perl_6.02-1.dsc' libwww-robotrules-perl_6.02-1.dsc 2284 SHA256:8419a4bac65737229e54cf2356e2f0ab90a8738d7fefb82a1883480a5747b469
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwww-robotrules-perl/libwww-robotrules-perl_6.02.orig.tar.gz' libwww-robotrules-perl_6.02.orig.tar.gz 9059 SHA256:46b502e7a288d559429891eeb5d979461dd3ecc6a5c491ead85d165b6e03a51e
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwww-robotrules-perl/libwww-robotrules-perl_6.02-1.debian.tar.xz' libwww-robotrules-perl_6.02-1.debian.tar.xz 2220 SHA256:d9a0bde5423038c69616c5099a8c03158bfa8bdb6ae99eba3edbe76b8018ceeb
```

### `dpkg` source package: `libx11-protocol-perl=0.56-7`

Binary Packages:

- `libx11-protocol-perl=0.56-7`

Licenses: (parsed from: `/usr/share/doc/libx11-protocol-perl/copyright`)

- `Artistic`
- `Expat`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libx11-protocol-perl=0.56-7
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libx11-protocol-perl/libx11-protocol-perl_0.56-7.dsc' libx11-protocol-perl_0.56-7.dsc 2267 SHA256:49322d7a9aa54245b10c96daebeebd16924edc4459526637b4d809335876b3b3
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libx11-protocol-perl/libx11-protocol-perl_0.56.orig.tar.gz' libx11-protocol-perl_0.56.orig.tar.gz 101227 SHA256:de96dd6c7c1f25f3287aa7af64902bf84acaaa8e0c3bb76aa1676367e04a08b7
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libx11-protocol-perl/libx11-protocol-perl_0.56-7.debian.tar.xz' libx11-protocol-perl_0.56-7.debian.tar.xz 4348 SHA256:07a1bc718bc433d858c8b997300c41dfec7c0a4ba458977761a1e3549a75674f
```

### `dpkg` source package: `libx11=2:1.6.9-2ubuntu1.6`

Binary Packages:

- `libx11-6:amd64=2:1.6.9-2ubuntu1.6`
- `libx11-data=2:1.6.9-2ubuntu1.6`
- `libx11-dev:amd64=2:1.6.9-2ubuntu1.6`
- `libx11-xcb1:amd64=2:1.6.9-2ubuntu1.6`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libx11=2:1.6.9-2ubuntu1.6
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libx11/libx11_1.6.9-2ubuntu1.6.dsc' libx11_1.6.9-2ubuntu1.6.dsc 2671 SHA512:46674410511381909f8f29ee70138e3158098c0937784783574bbccca9ce43e319f49663df5d8fb6e5ee57e33bccaaf7b8c9590183bfda4c80a8b9ac7173594a
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libx11/libx11_1.6.9.orig.tar.gz' libx11_1.6.9.orig.tar.gz 2994329 SHA512:c79cf0924e920a2e8d2e9af45e73ed42b565dea79ac68d4c3889033738274694b29cedb62c057fec1aa7f7ad7dcf843334fccb43470bbae7922d42373c1c6045
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libx11/libx11_1.6.9.orig.tar.gz.asc' libx11_1.6.9.orig.tar.gz.asc 659 SHA512:56e53d1481be4e12f89af2fbcd297a3612996f5ca1eae39d6fe336f9b52832ea430ac0568e556b9e57291562c56590086871c08ec7ac046f15af4211f680adee
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libx11/libx11_1.6.9-2ubuntu1.6.diff.gz' libx11_1.6.9-2ubuntu1.6.diff.gz 71964 SHA512:61bbb0b65991c46fb5f63d4698abf3ac484cf156bbcc665583a549e729975e9b45adf41a865dd59ed719426da9c703bf733626dd829450ffc58e02139af9808f
```

### `dpkg` source package: `libxau=1:1.0.9-0ubuntu1`

Binary Packages:

- `libxau-dev:amd64=1:1.0.9-0ubuntu1`
- `libxau6:amd64=1:1.0.9-0ubuntu1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxau=1:1.0.9-0ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxau/libxau_1.0.9-0ubuntu1.dsc' libxau_1.0.9-0ubuntu1.dsc 1563 SHA256:b59509d1f8f6c0e21b8bbd46ac1dffcd7a21a635ff3ce9c0acf68ba60fcb5e11
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxau/libxau_1.0.9.orig.tar.gz' libxau_1.0.9.orig.tar.gz 394068 SHA256:1f123d8304b082ad63a9e89376400a3b1d4c29e67e3ea07b3f659cccca690eea
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxau/libxau_1.0.9-0ubuntu1.diff.gz' libxau_1.0.9-0ubuntu1.diff.gz 15142 SHA256:cf7e9d50c3b3b8dde3486ee6fcf9bb96585e2af32924e91c10c8612e48b5dce5
```

### `dpkg` source package: `libxaw=2:1.0.13-1`

Binary Packages:

- `libxaw7:amd64=2:1.0.13-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxaw=2:1.0.13-1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxaw/libxaw_1.0.13-1.dsc' libxaw_1.0.13-1.dsc 2196 SHA256:9fdf48f9ff66c0889cda5030997fe919e5320e7988f32e20bb96602daa37e7f7
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxaw/libxaw_1.0.13.orig.tar.gz' libxaw_1.0.13.orig.tar.gz 848997 SHA256:7e74ac3e5f67def549722ff0333d6e6276b8becd9d89615cda011e71238ab694
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxaw/libxaw_1.0.13-1.diff.gz' libxaw_1.0.13-1.diff.gz 12643 SHA256:241f21ba0810d9d859a98ab60f100a366bc9e98cd946c736566a8ed1353a1bcc
```

### `dpkg` source package: `libxcb=1.14-2`

Binary Packages:

- `libxcb-dri2-0:amd64=1.14-2`
- `libxcb-dri3-0:amd64=1.14-2`
- `libxcb-glx0:amd64=1.14-2`
- `libxcb-present0:amd64=1.14-2`
- `libxcb-randr0:amd64=1.14-2`
- `libxcb-render0:amd64=1.14-2`
- `libxcb-shape0:amd64=1.14-2`
- `libxcb-shm0:amd64=1.14-2`
- `libxcb-sync1:amd64=1.14-2`
- `libxcb-xfixes0:amd64=1.14-2`
- `libxcb1:amd64=1.14-2`
- `libxcb1-dev:amd64=1.14-2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxcb=1.14-2
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcb/libxcb_1.14-2.dsc' libxcb_1.14-2.dsc 5344 SHA256:997dfadefa35a243a7160b62d628bb25e45439f61687459d581502905bcf1fb2
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcb/libxcb_1.14.orig.tar.gz' libxcb_1.14.orig.tar.gz 640322 SHA256:2c7fcddd1da34d9b238c9caeda20d3bd7486456fc50b3cc6567185dbd5b0ad02
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcb/libxcb_1.14-2.diff.gz' libxcb_1.14-2.diff.gz 25716 SHA256:92d7e0a80c3c7f2a5b5afd0c0702183f1c483338d678d67d8d0e61fd8989ba85
```

### `dpkg` source package: `libxcomposite=1:0.4.5-1`

Binary Packages:

- `libxcomposite1:amd64=1:0.4.5-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxcomposite=1:0.4.5-1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcomposite/libxcomposite_0.4.5-1.dsc' libxcomposite_0.4.5-1.dsc 2067 SHA256:41b93952b43dfac6b0acde3ea9b6330d44fd7c96b6a38eba6d82094b88e436e8
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcomposite/libxcomposite_0.4.5.orig.tar.gz' libxcomposite_0.4.5.orig.tar.gz 386513 SHA256:581c7fc0f41a99af38b1c36b9be64bc13ef3f60091cd3f01105bbc7c01617d6c
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcomposite/libxcomposite_0.4.5-1.diff.gz' libxcomposite_0.4.5-1.diff.gz 7547 SHA256:b5e99d78f5260a7c27ac4c166f981e8c2eab44cff08f9ab64da3ee7150854410
```

### `dpkg` source package: `libxcrypt=1:4.4.10-10ubuntu4`

Binary Packages:

- `libcrypt1:amd64=1:4.4.10-10ubuntu4`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxcrypt=1:4.4.10-10ubuntu4
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcrypt/libxcrypt_4.4.10-10ubuntu4.dsc' libxcrypt_4.4.10-10ubuntu4.dsc 2216 SHA256:457576b36eaa34dcf28b19e942908221d0618e9e4a2c0b9e11ba9693770756a2
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcrypt/libxcrypt_4.4.10.orig.tar.xz' libxcrypt_4.4.10.orig.tar.xz 372652 SHA256:f790a8eac4e4af3124d2844a24a7afb3a972368e4dff63d701599c2f2d065fd3
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcrypt/libxcrypt_4.4.10-10ubuntu4.debian.tar.xz' libxcrypt_4.4.10-10ubuntu4.debian.tar.xz 5760 SHA256:b2e665b5224911d24dbcbddfc61b7a27428c3ecb744f29ceea1b2984496f2ffa
```

### `dpkg` source package: `libxcursor=1:1.2.0-2`

Binary Packages:

- `libxcursor1:amd64=1:1.2.0-2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxcursor=1:1.2.0-2
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcursor/libxcursor_1.2.0-2.dsc' libxcursor_1.2.0-2.dsc 2260 SHA256:27a4e948a79d0caf2d5d8bcd2f036c1b14b9abb933fd7c3f12f933885c0124ed
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcursor/libxcursor_1.2.0.orig.tar.gz' libxcursor_1.2.0.orig.tar.gz 408135 SHA256:ad5b2574fccaa4c3fa67b9874fbed863d29ad230c784e9a08b20692418f6a1f8
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcursor/libxcursor_1.2.0-2.debian.tar.xz' libxcursor_1.2.0-2.debian.tar.xz 8988 SHA256:3fd5d8bf9c47d43e416ec6533b63796616c689eecfdbfb28bb9adefdaa079e51
```

### `dpkg` source package: `libxdamage=1:1.1.5-2`

Binary Packages:

- `libxdamage1:amd64=1:1.1.5-2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxdamage=1:1.1.5-2
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxdamage/libxdamage_1.1.5-2.dsc' libxdamage_1.1.5-2.dsc 2124 SHA256:c2ef651aa7dad2f3f1e57a9ef8e12c72eb5f23c9e507473dccd3996a54ae229a
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxdamage/libxdamage_1.1.5.orig.tar.gz' libxdamage_1.1.5.orig.tar.gz 370586 SHA256:630ec53abb8c2d6dac5cd9f06c1f73ffb4a3167f8118fdebd77afd639dbc2019
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxdamage/libxdamage_1.1.5-2.debian.tar.xz' libxdamage_1.1.5-2.debian.tar.xz 5996 SHA256:c6333b68d2e109ea44a6031bc79e23c433b580c7ae69a9cd5cf40729896913fc
```

### `dpkg` source package: `libxdmcp=1:1.1.3-0ubuntu1`

Binary Packages:

- `libxdmcp-dev:amd64=1:1.1.3-0ubuntu1`
- `libxdmcp6:amd64=1:1.1.3-0ubuntu1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxdmcp=1:1.1.3-0ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxdmcp/libxdmcp_1.1.3-0ubuntu1.dsc' libxdmcp_1.1.3-0ubuntu1.dsc 1608 SHA256:3f98e3917b5de252eb517c55743bcc5682b43c9f70ead33231ac4318bbc816e1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxdmcp/libxdmcp_1.1.3.orig.tar.gz' libxdmcp_1.1.3.orig.tar.gz 429668 SHA256:2ef9653d32e09d1bf1b837d0e0311024979653fe755ad3aaada8db1aa6ea180c
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxdmcp/libxdmcp_1.1.3-0ubuntu1.diff.gz' libxdmcp_1.1.3-0ubuntu1.diff.gz 18079 SHA256:3037a57202b724ecd7db70c21a601f58277c02ba89e7e5d999973e5baf6d05ca
```

### `dpkg` source package: `libxext=2:1.3.4-0ubuntu1`

Binary Packages:

- `libxext6:amd64=2:1.3.4-0ubuntu1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxext=2:1.3.4-0ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxext/libxext_1.3.4-0ubuntu1.dsc' libxext_1.3.4-0ubuntu1.dsc 1727 SHA256:8319de2750f28c78e01267a5593776f10afd3f863d4820abe72dbf855a3a77ae
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxext/libxext_1.3.4.orig.tar.gz' libxext_1.3.4.orig.tar.gz 494434 SHA256:8ef0789f282826661ff40a8eef22430378516ac580167da35cc948be9041aac1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxext/libxext_1.3.4-0ubuntu1.diff.gz' libxext_1.3.4-0ubuntu1.diff.gz 20663 SHA256:87a4d23f1f9ff53f3a6cd7cc35252a1249dc63d274c566ea7e23b23585a86170
```

### `dpkg` source package: `libxfixes=1:5.0.3-2`

Binary Packages:

- `libxfixes3:amd64=1:5.0.3-2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxfixes=1:5.0.3-2
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxfixes/libxfixes_5.0.3-2.dsc' libxfixes_5.0.3-2.dsc 2014 SHA256:f47f131ee1d1ce791daa514fd43fe45e099f3a83462247bc75fc7ba0c8be42a6
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxfixes/libxfixes_5.0.3.orig.tar.gz' libxfixes_5.0.3.orig.tar.gz 360412 SHA256:9ab6c13590658501ce4bd965a8a5d32ba4d8b3bb39a5a5bc9901edffc5666570
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxfixes/libxfixes_5.0.3-2.diff.gz' libxfixes_5.0.3-2.diff.gz 14717 SHA256:aeb108219d65550e107d6f81dc2dac11e06363a55306f2505234190f96f1e961
```

### `dpkg` source package: `libxi=2:1.7.10-0ubuntu1`

Binary Packages:

- `libxi6:amd64=2:1.7.10-0ubuntu1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxi=2:1.7.10-0ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxi/libxi_1.7.10-0ubuntu1.dsc' libxi_1.7.10-0ubuntu1.dsc 1701 SHA256:a02526779438726cb073d08123e03bd656a8fc514fc4df1c74b2e5e006cb8a92
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxi/libxi_1.7.10.orig.tar.gz' libxi_1.7.10.orig.tar.gz 606701 SHA256:b51e106c445a49409f3da877aa2f9129839001b24697d75a54e5c60507e9a5e3
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxi/libxi_1.7.10-0ubuntu1.diff.gz' libxi_1.7.10-0ubuntu1.diff.gz 53514 SHA256:ec42321e719d6059c1803260d6fae076d777430c4caecebea6229fe1cfa47eeb
```

### `dpkg` source package: `libxinerama=2:1.1.4-2`

Binary Packages:

- `libxinerama1:amd64=2:1.1.4-2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxinerama=2:1.1.4-2
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxinerama/libxinerama_1.1.4-2.dsc' libxinerama_1.1.4-2.dsc 2100 SHA256:02e4c8406fd1eae8abfe356894d95d610e2e612a761688ef5afe5e7c60d162e9
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxinerama/libxinerama_1.1.4.orig.tar.gz' libxinerama_1.1.4.orig.tar.gz 380740 SHA256:64de45e18cc76b8e703cb09b3c9d28bd16e3d05d5cd99f2d630de2d62c3acc18
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxinerama/libxinerama_1.1.4-2.diff.gz' libxinerama_1.1.4-2.diff.gz 8732 SHA256:06ce6602862839ded43d914d7dd5e5bcd7d7a1477c775f5f47a6c20b1c9b52b6
```

### `dpkg` source package: `libxkbcommon=0.10.0-1`

Binary Packages:

- `libxkbcommon0:amd64=0.10.0-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxkbcommon=0.10.0-1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxkbcommon/libxkbcommon_0.10.0-1.dsc' libxkbcommon_0.10.0-1.dsc 2451 SHA256:5f60bd2c91196acba229e2d5a932798c64a18efd83577512b4fd8cd4bcdf4afa
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxkbcommon/libxkbcommon_0.10.0.orig.tar.gz' libxkbcommon_0.10.0.orig.tar.gz 600904 SHA256:54b6f38a4ce77052d343e881aafece8e993f9bfc3db35a107e9bdca9b5b1a055
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxkbcommon/libxkbcommon_0.10.0-1.diff.gz' libxkbcommon_0.10.0-1.diff.gz 29199 SHA256:8fd8e43b53ff47c240505bb0b44dbb11456a0234f69a4ae28975ed6fec6bdfd3
```

### `dpkg` source package: `libxkbfile=1:1.1.0-1`

Binary Packages:

- `libxkbfile1:amd64=1:1.1.0-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxkbfile=1:1.1.0-1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxkbfile/libxkbfile_1.1.0-1.dsc' libxkbfile_1.1.0-1.dsc 2279 SHA256:d389523e40c07beb98d214e9aa417dac4c89a285b3a9873b1e7fa88d6c60857a
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxkbfile/libxkbfile_1.1.0.orig.tar.gz' libxkbfile_1.1.0.orig.tar.gz 441021 SHA256:2a92adda3992aa7cbad758ef0b8dfeaedebb49338b772c64ddf369d78c1c51d3
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxkbfile/libxkbfile_1.1.0.orig.tar.gz.asc' libxkbfile_1.1.0.orig.tar.gz.asc 801 SHA256:998e90cb1bf5cff3386ea0c1715370fd9753c4bfdb49e81c9131de6ba60aa1fa
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxkbfile/libxkbfile_1.1.0-1.diff.gz' libxkbfile_1.1.0-1.diff.gz 10049 SHA256:5d8fee55b59aba5e585a9b3b13d5b9ff93a174b2d460fef278736a589283a078
```

### `dpkg` source package: `libxml-parser-perl=2.46-1`

Binary Packages:

- `libxml-parser-perl=2.46-1`

Licenses: (parsed from: `/usr/share/doc/libxml-parser-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libxml-parser-perl=2.46-1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml-parser-perl/libxml-parser-perl_2.46-1.dsc' libxml-parser-perl_2.46-1.dsc 2138 SHA256:f48ca44284563a17ef4854c3d2df33d576b67e94ec92e0d8d4b2c4e388f4253c
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml-parser-perl/libxml-parser-perl_2.46.orig.tar.gz' libxml-parser-perl_2.46.orig.tar.gz 254763 SHA256:d331332491c51cccfb4cb94ffc44f9cd73378e618498d4a37df9e043661c515d
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml-parser-perl/libxml-parser-perl_2.46-1.debian.tar.xz' libxml-parser-perl_2.46-1.debian.tar.xz 57924 SHA256:c2cb81c489434ca33a9233b6bb30bb72bf5382bc2aa73c070c60adc18439a262
```

### `dpkg` source package: `libxml-twig-perl=1:3.50-2`

Binary Packages:

- `libxml-twig-perl=1:3.50-2`

Licenses: (parsed from: `/usr/share/doc/libxml-twig-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris libxml-twig-perl=1:3.50-2
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml-twig-perl/libxml-twig-perl_3.50-2.dsc' libxml-twig-perl_3.50-2.dsc 3077 SHA256:6e777ffe6a4f5c93d39223a6bc6a9826be88e87701e67589b94b722edd1524c7
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml-twig-perl/libxml-twig-perl_3.50.orig.tar.gz' libxml-twig-perl_3.50.orig.tar.gz 403387 SHA256:62005aced4e844651d75c2a54c2dcd8df5e32447d0b8e449c40cf6f83f382b80
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml-twig-perl/libxml-twig-perl_3.50-2.debian.tar.xz' libxml-twig-perl_3.50-2.debian.tar.xz 7944 SHA256:a63ef53333ddfe0dd2ee224e27176328a7c5da4e98f114550a57f0464ff3c48d
```

### `dpkg` source package: `libxml-xpathengine-perl=0.14-1`

Binary Packages:

- `libxml-xpathengine-perl=0.14-1`

Licenses: (parsed from: `/usr/share/doc/libxml-xpathengine-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libxml-xpathengine-perl=0.14-1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml-xpathengine-perl/libxml-xpathengine-perl_0.14-1.dsc' libxml-xpathengine-perl_0.14-1.dsc 2232 SHA256:f5e132c7f5f1f8bd2616ba48f03bb12826ca3b8a6223c72237a815b207394d47
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml-xpathengine-perl/libxml-xpathengine-perl_0.14.orig.tar.gz' libxml-xpathengine-perl_0.14.orig.tar.gz 26118 SHA256:d2fe7bcbbd0beba1444f4a733401e7b8aa5282fad4266d42735dd74582b2e264
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml-xpathengine-perl/libxml-xpathengine-perl_0.14-1.debian.tar.xz' libxml-xpathengine-perl_0.14-1.debian.tar.xz 4680 SHA256:2e66d2548a546d97963344a04a4b8ffedc3a5206f04ca7900eba0ee49760401e
```

### `dpkg` source package: `libxml2=2.9.10+dfsg-5ubuntu0.20.04.7`

Binary Packages:

- `libxml2:amd64=2.9.10+dfsg-5ubuntu0.20.04.7`

Licenses: (parsed from: `/usr/share/doc/libxml2/copyright`)

- `ISC`
- `MIT-1`

Source:

```console
$ apt-get source -qq --print-uris libxml2=2.9.10+dfsg-5ubuntu0.20.04.7
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml2/libxml2_2.9.10%2bdfsg-5ubuntu0.20.04.7.dsc' libxml2_2.9.10+dfsg-5ubuntu0.20.04.7.dsc 3121 SHA512:d07e225802fe50a08122b61e1a686cc71ca654ee4567971daafca504cfb39ca30767e3b6cdbc920dc9dd52468432adf9ce29b807e19128975c6cd824ada22ae4
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml2/libxml2_2.9.10%2bdfsg.orig.tar.xz' libxml2_2.9.10+dfsg.orig.tar.xz 2503560 SHA512:605c6c0f8bf2c53208d0a036ff09a4025843f45139b711c90dc83066feda2f285a5578d55d4a58d33eedbe7485a5c1ec5608ba6c6beed1fb55649f87dca0cec3
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml2/libxml2_2.9.10%2bdfsg-5ubuntu0.20.04.7.debian.tar.xz' libxml2_2.9.10+dfsg-5ubuntu0.20.04.7.debian.tar.xz 42356 SHA512:b80547274edb845127eaf712a7c5e4ef6a0fede845c0dd27a8eef2eee0e7b535b8d127f1aef4dfba0cb00e6e3a80cdcaee421ce35d094464ea2c10c9e8ff05f1
```

### `dpkg` source package: `libxmu=2:1.1.3-0ubuntu1`

Binary Packages:

- `libxmu6:amd64=2:1.1.3-0ubuntu1`
- `libxmuu1:amd64=2:1.1.3-0ubuntu1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxmu=2:1.1.3-0ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxmu/libxmu_1.1.3-0ubuntu1.dsc' libxmu_1.1.3-0ubuntu1.dsc 1797 SHA256:ba64fdbc1b602eac436ae7ea58f57d72a45ee23b016eba542ce8b704508f717c
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxmu/libxmu_1.1.3.orig.tar.gz' libxmu_1.1.3.orig.tar.gz 497343 SHA256:5bd9d4ed1ceaac9ea023d86bf1c1632cd3b172dce4a193a72a94e1d9df87a62e
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxmu/libxmu_1.1.3-0ubuntu1.diff.gz' libxmu_1.1.3-0ubuntu1.diff.gz 6373 SHA256:7519cc7be957da29adc420426b57e1366228448c6205c5e4b89d04bfa948ffa7
```

### `dpkg` source package: `libxpm=1:3.5.12-1ubuntu0.20.04.2`

Binary Packages:

- `libxpm4:amd64=1:3.5.12-1ubuntu0.20.04.2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxpm=1:3.5.12-1ubuntu0.20.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxpm/libxpm_3.5.12-1ubuntu0.20.04.2.dsc' libxpm_3.5.12-1ubuntu0.20.04.2.dsc 2203 SHA512:034d036c884169883acaad3095e1749726f92125ecb24c0205f5fd584bcd9b38447b16f1f6e3b8189c37e93f62f151da3766918bed8c3caf4f158c17e09b2181
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxpm/libxpm_3.5.12.orig.tar.gz' libxpm_3.5.12.orig.tar.gz 529302 SHA512:17169016efc1e139f079290b2369fd62df8617867d97d2f50940521951a50f173118143109f0d7c552de92913cefc5ccaeb52225ccdd9abc89b3b85d9b5669f7
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxpm/libxpm_3.5.12-1ubuntu0.20.04.2.diff.gz' libxpm_3.5.12-1ubuntu0.20.04.2.diff.gz 19063 SHA512:1b2b6dc8bdd2ebcdd183dbfc85703ea811a4e6066be76e5b4954cf6d1bcb4dfbc82fe3a744ab432bb0adba063425152532bce448d08ec8eeffda8b3230e1892a
```

### `dpkg` source package: `libxrandr=2:1.5.2-0ubuntu1`

Binary Packages:

- `libxrandr2:amd64=2:1.5.2-0ubuntu1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxrandr=2:1.5.2-0ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxrandr/libxrandr_1.5.2-0ubuntu1.dsc' libxrandr_1.5.2-0ubuntu1.dsc 1538 SHA256:6e7f5ee8e853de4b13196a222dc004db7d521563444500dbb0c82fb4edf98877
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxrandr/libxrandr_1.5.2.orig.tar.gz' libxrandr_1.5.2.orig.tar.gz 411714 SHA256:3f10813ab355e7a09f17e147d61b0ce090d898a5ea5b5519acd0ef68675dcf8e
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxrandr/libxrandr_1.5.2-0ubuntu1.diff.gz' libxrandr_1.5.2-0ubuntu1.diff.gz 16450 SHA256:86d5c529dde1b4d9424c58957b817f78c891fe6d202a05e579e696ccbe0fce17
```

### `dpkg` source package: `libxrender=1:0.9.10-1`

Binary Packages:

- `libxrender1:amd64=1:0.9.10-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxrender=1:0.9.10-1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxrender/libxrender_0.9.10-1.dsc' libxrender_0.9.10-1.dsc 2064 SHA256:95d6471218b44f4e60c48cea60cfb4865bbe861530add23f6c859515bee92dbd
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxrender/libxrender_0.9.10.orig.tar.gz' libxrender_0.9.10.orig.tar.gz 373717 SHA256:770527cce42500790433df84ec3521e8bf095dfe5079454a92236494ab296adf
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxrender/libxrender_0.9.10-1.diff.gz' libxrender_0.9.10-1.diff.gz 15399 SHA256:ff56a0a00119383adc5f1731e86155ae5c2de069e1d059a9da1d777917430588
```

### `dpkg` source package: `libxshmfence=1.3-1`

Binary Packages:

- `libxshmfence1:amd64=1.3-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxshmfence=1.3-1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxshmfence/libxshmfence_1.3-1.dsc' libxshmfence_1.3-1.dsc 2096 SHA256:7da3e1195622ab34427bd5d09167b1f44ed1a3e828782fa8e618f1181c56194a
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxshmfence/libxshmfence_1.3.orig.tar.gz' libxshmfence_1.3.orig.tar.gz 378960 SHA256:7eb3d46ad91bab444f121d475b11b39273142d090f7e9ac43e6a87f4ff5f902c
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxshmfence/libxshmfence_1.3-1.diff.gz' libxshmfence_1.3-1.diff.gz 17456 SHA256:85422af90300523b8fb27e697b59418f18bd7cd5c849161fd0be64c91ce94698
```

### `dpkg` source package: `libxslt=1.1.34-4ubuntu0.20.04.1`

Binary Packages:

- `libxslt1.1:amd64=1.1.34-4ubuntu0.20.04.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxslt=1.1.34-4ubuntu0.20.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxslt/libxslt_1.1.34-4ubuntu0.20.04.1.dsc' libxslt_1.1.34-4ubuntu0.20.04.1.dsc 2514 SHA512:ebd0f5b195405ebee6a1011ddeba7b22f3e22c376afe57036910c7a3c23a728967620ee757a3af703f00dd04b4b8709a066115b12f6a7cb905746b43ae089339
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxslt/libxslt_1.1.34.orig.tar.gz' libxslt_1.1.34.orig.tar.gz 3552258 SHA512:1516a11ad608b04740674060d2c5d733b88889de5e413b9a4e8bf8d1a90d712149df6d2b1345b615f529d7c7d3fa6dae12e544da828b39c7d415e54c0ee0776b
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxslt/libxslt_1.1.34.orig.tar.gz.asc' libxslt_1.1.34.orig.tar.gz.asc 488 SHA512:9b155d4571daede99cdbf2813a85fb04812737b5e23d3f7c9840225b38f3dbf171623a21645daaee190e7ff9ba38bde932922e96a2a2312c203ffa9917c3baea
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxslt/libxslt_1.1.34-4ubuntu0.20.04.1.debian.tar.xz' libxslt_1.1.34-4ubuntu0.20.04.1.debian.tar.xz 23260 SHA512:addb79137cbdee10ebf15efecddee266e52a8043399cd166882061923038f6ee4ebb55aaa4152432b6d21a4b2ac514eed81cded4593d09754514ab7056b1326d
```

### `dpkg` source package: `libxss=1:1.2.3-1`

Binary Packages:

- `libxss1:amd64=1:1.2.3-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxss=1:1.2.3-1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxss/libxss_1.2.3-1.dsc' libxss_1.2.3-1.dsc 2203 SHA256:783dbcd49a0934d994693af676ee98734dad070ab2434a6afe831c2de0ecca1d
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxss/libxss_1.2.3.orig.tar.gz' libxss_1.2.3.orig.tar.gz 385215 SHA256:4f74e7e412144591d8e0616db27f433cfc9f45aae6669c6c4bb03e6bf9be809a
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxss/libxss_1.2.3.orig.tar.gz.asc' libxss_1.2.3.orig.tar.gz.asc 705 SHA256:4e900524d56c8e7263365267efa91bb3671110c9eb28ccab58f70e2188f0b91b
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxss/libxss_1.2.3-1.diff.gz' libxss_1.2.3-1.diff.gz 7145 SHA256:9d381b48f1377f27c506113e1f9b7d6ee286b856421f7f2b27017f01dccfef04
```

### `dpkg` source package: `libxt=1:1.1.5-1`

Binary Packages:

- `libxt-dev:amd64=1:1.1.5-1`
- `libxt6:amd64=1:1.1.5-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxt=1:1.1.5-1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxt/libxt_1.1.5-1.dsc' libxt_1.1.5-1.dsc 2109 SHA256:f44ae1393c9fd02c0b3dd03576c7b26e6c7b09de3271a87e018efadeed311639
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxt/libxt_1.1.5.orig.tar.gz' libxt_1.1.5.orig.tar.gz 962169 SHA256:b59bee38a9935565fa49dc1bfe84cb30173e2e07e1dcdf801430d4b54eb0caa3
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxt/libxt_1.1.5-1.diff.gz' libxt_1.1.5-1.diff.gz 14462 SHA256:822fe813d1ea9213e6fde91cbb607c0b6874341dc19b77b0f6649b8be8472d82
```

### `dpkg` source package: `libxtst=2:1.2.3-1`

Binary Packages:

- `libxtst6:amd64=2:1.2.3-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxtst=2:1.2.3-1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxtst/libxtst_1.2.3-1.dsc' libxtst_1.2.3-1.dsc 2243 SHA256:979f05e505ea319c3f75955e10345338f77a512f5a6a0a887d6f4633d6bd4633
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxtst/libxtst_1.2.3.orig.tar.gz' libxtst_1.2.3.orig.tar.gz 400197 SHA256:a0c83acce02d4923018c744662cb28eb0dbbc33b4adc027726879ccf68fbc2c2
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxtst/libxtst_1.2.3-1.diff.gz' libxtst_1.2.3-1.diff.gz 10177 SHA256:c4739fc7ccda7caaffcf36f934b7c33463390e71d567c7d62f635db1946b74ed
```

### `dpkg` source package: `libxv=2:1.0.11-1`

Binary Packages:

- `libxv1:amd64=2:1.0.11-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxv=2:1.0.11-1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxv/libxv_1.0.11-1.dsc' libxv_1.0.11-1.dsc 1959 SHA256:7753e8d4496ec0d3f32417b03cfc8b344e2dff486e46f630158a6a52e4bd8542
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxv/libxv_1.0.11.orig.tar.gz' libxv_1.0.11.orig.tar.gz 387057 SHA256:c4112532889b210e21cf05f46f0f2f8354ff7e1b58061e12d7a76c95c0d47bb1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxv/libxv_1.0.11-1.diff.gz' libxv_1.0.11-1.diff.gz 8235 SHA256:529ed2bcbccc9340c9c7987e8c5ed933a0fa41d6e4e67ef71ce3925ac83d93b6
```

### `dpkg` source package: `libxxf86dga=2:1.1.5-0ubuntu1`

Binary Packages:

- `libxxf86dga1:amd64=2:1.1.5-0ubuntu1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxxf86dga=2:1.1.5-0ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxxf86dga/libxxf86dga_1.1.5-0ubuntu1.dsc' libxxf86dga_1.1.5-0ubuntu1.dsc 1652 SHA256:08734d98453a31f345a208d3a1bdcd8a714d2655ab4984902b93317a20370f7c
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxxf86dga/libxxf86dga_1.1.5.orig.tar.gz' libxxf86dga_1.1.5.orig.tar.gz 389388 SHA256:715e2bf5caf6276f0858eb4b11a1aef1a26beeb40dce2942387339da395bef69
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxxf86dga/libxxf86dga_1.1.5-0ubuntu1.diff.gz' libxxf86dga_1.1.5-0ubuntu1.diff.gz 14977 SHA256:4e9d6ac475ff331dc634f71755eac415cdaab57545810f3835019470422a0e9d
```

### `dpkg` source package: `libxxf86vm=1:1.1.4-1build1`

Binary Packages:

- `libxxf86vm1:amd64=1:1.1.4-1build1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxxf86vm=1:1.1.4-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxxf86vm/libxxf86vm_1.1.4-1build1.dsc' libxxf86vm_1.1.4-1build1.dsc 2141 SHA256:ce09c08963029e55668fc69ec2ae963aa6301841968ebd544cbf8f74769988be
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxxf86vm/libxxf86vm_1.1.4.orig.tar.gz' libxxf86vm_1.1.4.orig.tar.gz 363146 SHA256:5108553c378a25688dcb57dca383664c36e293d60b1505815f67980ba9318a99
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxxf86vm/libxxf86vm_1.1.4-1build1.diff.gz' libxxf86vm_1.1.4-1build1.diff.gz 8101 SHA256:8bfdacf91f781ddad0b2cc13cb00c3135383cbe07682571be09575d968b8bb95
```

### `dpkg` source package: `libzstd=1.4.4+dfsg-3ubuntu0.1`

Binary Packages:

- `libzstd1:amd64=1.4.4+dfsg-3ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libzstd1/copyright`)

- `BSD-3-clause`
- `Expat`
- `GPL-2`
- `GPL-2+`
- `zlib`

Source:

```console
$ apt-get source -qq --print-uris libzstd=1.4.4+dfsg-3ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/libz/libzstd/libzstd_1.4.4%2bdfsg-3ubuntu0.1.dsc' libzstd_1.4.4+dfsg-3ubuntu0.1.dsc 2381 SHA512:a135412be4afdea573f991d8e4822f9885dbd607c87fb22e72d2defa160cf64f85a6047a9c9120b6eda3b8927306407278779f9e7a6976d7b15fb08750f32f74
'http://archive.ubuntu.com/ubuntu/pool/main/libz/libzstd/libzstd_1.4.4%2bdfsg.orig.tar.xz' libzstd_1.4.4+dfsg.orig.tar.xz 1357144 SHA512:85c64662303dda72d61fcbe41dfc6b310e63b20b043f41d4fb5a5ebc38ea83986c8c217fb259dfc2c024538ee8a519bb944914542a0b3a5c4dd988d5fdb248b7
'http://archive.ubuntu.com/ubuntu/pool/main/libz/libzstd/libzstd_1.4.4%2bdfsg-3ubuntu0.1.debian.tar.xz' libzstd_1.4.4+dfsg-3ubuntu0.1.debian.tar.xz 17300 SHA512:0484891be5603d00bd57b799c708b9395fccbaa8c6c44f535377f6fa2c7ac22c01c8a3c1b45e1c1f3c30f19dc74d510626bf82067fcbfb53c39f1bcc2249affe
```

### `dpkg` source package: `lilv=0.24.6-1ubuntu0.1`

Binary Packages:

- `liblilv-0-0:amd64=0.24.6-1ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/liblilv-0-0/copyright`)

- `BSD-3-clause`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris lilv=0.24.6-1ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/universe/l/lilv/lilv_0.24.6-1ubuntu0.1.dsc' lilv_0.24.6-1ubuntu0.1.dsc 1929 SHA512:785f89c0055bd1cfd7788f43c1e0657c187aebd6bb1da7effd695e511369a031b572a0519493040a7a87702a3b23c6fabe1ea0ceeaf3362f9fbf6ebc9ae103a4
'http://archive.ubuntu.com/ubuntu/pool/universe/l/lilv/lilv_0.24.6.orig.tar.bz2' lilv_0.24.6.orig.tar.bz2 541765 SHA512:0cf89d7dac97727e744579d3f4f4b330f56cf72f1a30bd03abfd645233aaf04e9bbf2abf460a0e4b963ed40e1ae78ed5f36127553bdab16e3e7dd3e93b70cdad
'http://archive.ubuntu.com/ubuntu/pool/universe/l/lilv/lilv_0.24.6-1ubuntu0.1.debian.tar.xz' lilv_0.24.6-1ubuntu0.1.debian.tar.xz 18808 SHA512:c7145aebd247bc912107aed05ea5ae4a660cc02971272d3177bdfe7ff98e079ea35fd60c6d88f1e9c95ebb8ecf41fe463112a5c703db0bf6b23fadc279f43bff
```

### `dpkg` source package: `llvm-toolchain-12=1:12.0.0-3ubuntu1~20.04.5`

Binary Packages:

- `libllvm12:amd64=1:12.0.0-3ubuntu1~20.04.5`

Licenses: (parsed from: `/usr/share/doc/libllvm12/copyright`)

- `APACHE-2-LLVM-EXCEPTIONS`
- `Apache-2.0`
- `BSD-3-Clause`
- `BSD-3-clause`
- `MIT`
- `Python`
- `solar-public-domain`

Source:

```console
$ apt-get source -qq --print-uris llvm-toolchain-12=1:12.0.0-3ubuntu1~20.04.5
'http://archive.ubuntu.com/ubuntu/pool/main/l/llvm-toolchain-12/llvm-toolchain-12_12.0.0-3ubuntu1%7e20.04.5.dsc' llvm-toolchain-12_12.0.0-3ubuntu1~20.04.5.dsc 6386 SHA512:d8d1a94293f02406eb3001fb22a20d0b9bdd4385796f0454656a2303e8d806e973c8ba3f9b1d84c14fd3edb3538c2c2647b4471218a84d5fb22d68faa1111beb
'http://archive.ubuntu.com/ubuntu/pool/main/l/llvm-toolchain-12/llvm-toolchain-12_12.0.0.orig.tar.xz' llvm-toolchain-12_12.0.0.orig.tar.xz 86089384 SHA512:34083aa8541f03c7a6408b3ac1a9305f5fad5da6c843396521652271f653c78a86a798e501ee17226c133cc3690d054aa086d9b371266afc4859072f6afc4dd6
'http://archive.ubuntu.com/ubuntu/pool/main/l/llvm-toolchain-12/llvm-toolchain-12_12.0.0-3ubuntu1%7e20.04.5.debian.tar.xz' llvm-toolchain-12_12.0.0-3ubuntu1~20.04.5.debian.tar.xz 127664 SHA512:e17c905ea623f9a6b87fe9e6ab95c8e29cc3e2da6480c175693c41b8b80d0894f5ac63b9d15b68f5e2f59e6923635c29d4e5e84698da2b4472c352b99cb0cd9b
```

### `dpkg` source package: `lm-sensors=1:3.6.0-2ubuntu1.1`

Binary Packages:

- `libsensors-config=1:3.6.0-2ubuntu1.1`
- `libsensors5:amd64=1:3.6.0-2ubuntu1.1`

Licenses: (parsed from: `/usr/share/doc/libsensors-config/copyright`, `/usr/share/doc/libsensors5/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris lm-sensors=1:3.6.0-2ubuntu1.1
'http://archive.ubuntu.com/ubuntu/pool/main/l/lm-sensors/lm-sensors_3.6.0-2ubuntu1.1.dsc' lm-sensors_3.6.0-2ubuntu1.1.dsc 2119 SHA512:558a706d16ed5ce85cdb1039759fd9c67f355e026e9154c07a03cb07d90dabf4c745a686674bf1ad4ba70ed102a68616c5c9feb649f98c4de4ddb9033473f4fb
'http://archive.ubuntu.com/ubuntu/pool/main/l/lm-sensors/lm-sensors_3.6.0.orig.tar.gz' lm-sensors_3.6.0.orig.tar.gz 273209 SHA512:4e80361913aff5403f1f0737fd4f42cffe43cc170ef48fff3914c9952f71990739d723f7b0b8120d9a01bcbbc829e964cfbd0a5cf18508af8f8dc825b49860bf
'http://archive.ubuntu.com/ubuntu/pool/main/l/lm-sensors/lm-sensors_3.6.0-2ubuntu1.1.debian.tar.xz' lm-sensors_3.6.0-2ubuntu1.1.debian.tar.xz 25992 SHA512:1b0e623a9a64f742b615d2782b4899f125e60b601bb0cd2167129f4fdbbd8b4a9153520b79d013db268f0739597c0e8584751efabf2f7a4efabb8a90fd02e24f
```

### `dpkg` source package: `lp-solve=5.5.0.15-4build1`

Binary Packages:

- `lp-solve=5.5.0.15-4build1`

Licenses: (parsed from: `/usr/share/doc/lp-solve/copyright`)

- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris lp-solve=5.5.0.15-4build1
'http://archive.ubuntu.com/ubuntu/pool/main/l/lp-solve/lp-solve_5.5.0.15-4build1.dsc' lp-solve_5.5.0.15-4build1.dsc 2242 SHA256:54793e62079b91ae7e47a7a282650ec46740ed9881284efe0e5b39090ac7a267
'http://archive.ubuntu.com/ubuntu/pool/main/l/lp-solve/lp-solve_5.5.0.15.orig-doc.tar.gz' lp-solve_5.5.0.15.orig-doc.tar.gz 1484929 SHA256:a9dcfa62148a283a6e11c0bb9524f4d5a4a4ecf06511e32cbd2faec04f791e17
'http://archive.ubuntu.com/ubuntu/pool/main/l/lp-solve/lp-solve_5.5.0.15.orig.tar.gz' lp-solve_5.5.0.15.orig.tar.gz 802881 SHA256:ea1243e8aa2f0d52172dc0a90d1c2a8d2a4f696a39fc9cf07321810363d18985
'http://archive.ubuntu.com/ubuntu/pool/main/l/lp-solve/lp-solve_5.5.0.15-4build1.debian.tar.xz' lp-solve_5.5.0.15-4build1.debian.tar.xz 9716 SHA256:c8d47e23c925e601669624e6b90f577596f4a5d534b71f31b5093621f6315469
```

### `dpkg` source package: `lsb=11.1.0ubuntu2`

Binary Packages:

- `lsb-base=11.1.0ubuntu2`

Licenses: (parsed from: `/usr/share/doc/lsb-base/copyright`)

- `BSD-3-clause`
- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris lsb=11.1.0ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/l/lsb/lsb_11.1.0ubuntu2.dsc' lsb_11.1.0ubuntu2.dsc 2230 SHA256:983ff4ab1ab2b39af974e4b8f4373ab4028d0ee5a409e7cd40401fa8e6ecabde
'http://archive.ubuntu.com/ubuntu/pool/main/l/lsb/lsb_11.1.0ubuntu2.tar.xz' lsb_11.1.0ubuntu2.tar.xz 46024 SHA256:c6ab63b6702dc633988690aacde8ece3e460f8acd8f1af8e6a67ab2fe0798f41
```

### `dpkg` source package: `lvm2=2.03.07-1ubuntu1`

Binary Packages:

- `dmsetup=2:1.02.167-1ubuntu1`
- `libdevmapper1.02.1:amd64=2:1.02.167-1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/dmsetup/copyright`, `/usr/share/doc/libdevmapper1.02.1/copyright`)

- `BSD-2-Clause`
- `GPL-2`
- `GPL-2.0`
- `GPL-2.0+`
- `LGPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris lvm2=2.03.07-1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/l/lvm2/lvm2_2.03.07-1ubuntu1.dsc' lvm2_2.03.07-1ubuntu1.dsc 3169 SHA256:61da0e6fe82073f75bbc864ab999369bf864155eb0e80f7051d3172093862e19
'http://archive.ubuntu.com/ubuntu/pool/main/l/lvm2/lvm2_2.03.07.orig.tar.xz' lvm2_2.03.07.orig.tar.xz 1658348 SHA256:c25bbe5c30c96e48f24bc0de645022c306acbb3ab0b44553d25e816befca7c32
'http://archive.ubuntu.com/ubuntu/pool/main/l/lvm2/lvm2_2.03.07-1ubuntu1.debian.tar.xz' lvm2_2.03.07-1ubuntu1.debian.tar.xz 42924 SHA256:fc89edc32f4ce3e71dc97dc4fa8ba72e8b848d952718094519bcff603b81bb9f
```

### `dpkg` source package: `lz4=1.9.2-2ubuntu0.20.04.1`

Binary Packages:

- `liblz4-1:amd64=1.9.2-2ubuntu0.20.04.1`

Licenses: (parsed from: `/usr/share/doc/liblz4-1/copyright`)

- `BSD-2-clause`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris lz4=1.9.2-2ubuntu0.20.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/l/lz4/lz4_1.9.2-2ubuntu0.20.04.1.dsc' lz4_1.9.2-2ubuntu0.20.04.1.dsc 2095 SHA512:249c1370a5e277575429a778fe2be185a997eb82eb77e88f83da38ddb271956ff1d2ae96403c599d430ed13a0f37e125b4410d21e3d42fe2d47a1a376bff70ad
'http://archive.ubuntu.com/ubuntu/pool/main/l/lz4/lz4_1.9.2.orig.tar.gz' lz4_1.9.2.orig.tar.gz 305796 SHA512:ae714c61ec8e33ed91359b63f2896cfa102d66b730dce112b74696ec5850e59d88bd5527173e01e354a70fbe8f036557a47c767ee0766bc5f9c257978116c3c1
'http://archive.ubuntu.com/ubuntu/pool/main/l/lz4/lz4_1.9.2-2ubuntu0.20.04.1.debian.tar.xz' lz4_1.9.2-2ubuntu0.20.04.1.debian.tar.xz 13228 SHA512:330f522c3afd0c9a36c6d8b882cfd59aa32258906ad6bbcab3a5bcd4a530ce226905d8108f384615dedd749dc5faaa45f320b0eda98effabee433e97124fabc0
```

### `dpkg` source package: `mawk=1.3.4.20200120-2`

Binary Packages:

- `mawk=1.3.4.20200120-2`

Licenses: (parsed from: `/usr/share/doc/mawk/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris mawk=1.3.4.20200120-2
'http://archive.ubuntu.com/ubuntu/pool/main/m/mawk/mawk_1.3.4.20200120-2.dsc' mawk_1.3.4.20200120-2.dsc 1915 SHA256:5069c46872ac74f5221250dfb88b31b1f2dbb8a2617c1e013f8f80cc34638c6d
'http://archive.ubuntu.com/ubuntu/pool/main/m/mawk/mawk_1.3.4.20200120.orig.tar.gz' mawk_1.3.4.20200120.orig.tar.gz 468855 SHA256:7fd4cd1e1fae9290fe089171181bbc6291dfd9bca939ca804f0ddb851c8b8237
'http://archive.ubuntu.com/ubuntu/pool/main/m/mawk/mawk_1.3.4.20200120-2.debian.tar.xz' mawk_1.3.4.20200120-2.debian.tar.xz 7504 SHA256:b772ed2f016b0286980c46cbc1f1f4ae62887ef2aa3dff6ef10cae638f923f26
```

### `dpkg` source package: `mesa=21.2.6-0ubuntu0.1~20.04.2`

Binary Packages:

- `libegl-mesa0:amd64=21.2.6-0ubuntu0.1~20.04.2`
- `libgbm1:amd64=21.2.6-0ubuntu0.1~20.04.2`
- `libgl1-mesa-dri:amd64=21.2.6-0ubuntu0.1~20.04.2`
- `libglapi-mesa:amd64=21.2.6-0ubuntu0.1~20.04.2`
- `libglx-mesa0:amd64=21.2.6-0ubuntu0.1~20.04.2`
- `mesa-va-drivers:amd64=21.2.6-0ubuntu0.1~20.04.2`
- `mesa-vdpau-drivers:amd64=21.2.6-0ubuntu0.1~20.04.2`
- `mesa-vulkan-drivers:amd64=21.2.6-0ubuntu0.1~20.04.2`

Licenses: (parsed from: `/usr/share/doc/libegl-mesa0/copyright`, `/usr/share/doc/libgbm1/copyright`, `/usr/share/doc/libgl1-mesa-dri/copyright`, `/usr/share/doc/libglapi-mesa/copyright`, `/usr/share/doc/libglx-mesa0/copyright`, `/usr/share/doc/mesa-va-drivers/copyright`, `/usr/share/doc/mesa-vdpau-drivers/copyright`, `/usr/share/doc/mesa-vulkan-drivers/copyright`)

- `Apache-2.0`
- `BSD-2-clause`
- `BSD-3-google`
- `BSL`
- `GPL`
- `Khronos`
- `MIT`
- `MLAA`
- `SGI`

Source:

```console
$ apt-get source -qq --print-uris mesa=21.2.6-0ubuntu0.1~20.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/m/mesa/mesa_21.2.6-0ubuntu0.1%7e20.04.2.dsc' mesa_21.2.6-0ubuntu0.1~20.04.2.dsc 5543 SHA512:e508302276fd187bc94d4b896bc70725930febf844bf87436585496e40a3d62ff0532ea6d96a251d87a33a729247165b0ef573e153467a17726ba4c46fc265ca
'http://archive.ubuntu.com/ubuntu/pool/main/m/mesa/mesa_21.2.6.orig.tar.gz' mesa_21.2.6.orig.tar.gz 24561701 SHA512:d5769a370439ecd401ef4bb24613aa0c529e968035c4b44cdfc286e73214f898b5e0c1db569d956c7bcfb02bd660bf60498d5f8abc86e523c241f06faf2a4f59
'http://archive.ubuntu.com/ubuntu/pool/main/m/mesa/mesa_21.2.6-0ubuntu0.1%7e20.04.2.diff.gz' mesa_21.2.6-0ubuntu0.1~20.04.2.diff.gz 110576 SHA512:2f5b4d5e3e6d73fceafceee771a170b466b5c0ac8b6dfcc28197f0d8867f20e2468b59a27de6611aeb36c1429b4bde36537d5073bb5c84923bffd173198eea67
```

### `dpkg` source package: `mhash=0.9.9.9-8`

Binary Packages:

- `libmhash2:amd64=0.9.9.9-8`

Licenses: (parsed from: `/usr/share/doc/libmhash2/copyright`)

- `LGPL-2`

Source:

```console
$ apt-get source -qq --print-uris mhash=0.9.9.9-8
'http://archive.ubuntu.com/ubuntu/pool/main/m/mhash/mhash_0.9.9.9-8.dsc' mhash_0.9.9.9-8.dsc 1904 SHA256:26474c432fffc2827b04f78e2e47e55222fd610911f8718eff4dbf24190bc987
'http://archive.ubuntu.com/ubuntu/pool/main/m/mhash/mhash_0.9.9.9.orig.tar.gz' mhash_0.9.9.9.orig.tar.gz 577533 SHA256:73991e9e54bb392484a510943d4c5d395462181cc4abe53f863edec13c335403
'http://archive.ubuntu.com/ubuntu/pool/main/m/mhash/mhash_0.9.9.9-8.debian.tar.xz' mhash_0.9.9.9-8.debian.tar.xz 11996 SHA256:28b964a9b978ab4c5784aca2381cab6f6efaf37a295cf048265614963840e839
```

### `dpkg` source package: `mime-support=3.64ubuntu1`

Binary Packages:

- `mime-support=3.64ubuntu1`

Licenses: (parsed from: `/usr/share/doc/mime-support/copyright`)

- `Bellcore`
- `ad-hoc`

Source:

```console
$ apt-get source -qq --print-uris mime-support=3.64ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/m/mime-support/mime-support_3.64ubuntu1.dsc' mime-support_3.64ubuntu1.dsc 1729 SHA256:669ba4f3fd7594f1c32731b5636b499f44f21c7667148f6f0d16043708743fdc
'http://archive.ubuntu.com/ubuntu/pool/main/m/mime-support/mime-support_3.64ubuntu1.tar.xz' mime-support_3.64ubuntu1.tar.xz 33980 SHA256:5007d2ebc25935bfca6d4bdac0efdfc089a38c1be49d19f0422559f666e4f2c4
```

### `dpkg` source package: `mpclib3=1.1.0-1`

Binary Packages:

- `libmpc3:amd64=1.1.0-1`

Licenses: (parsed from: `/usr/share/doc/libmpc3/copyright`)

- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris mpclib3=1.1.0-1
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpclib3/mpclib3_1.1.0-1.dsc' mpclib3_1.1.0-1.dsc 1990 SHA256:bb57824015b735bf72399a53f8c6a241e6a8bd402753b0fdcdaa5b99d0aef790
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpclib3/mpclib3_1.1.0.orig.tar.gz' mpclib3_1.1.0.orig.tar.gz 701263 SHA256:6985c538143c1208dcb1ac42cedad6ff52e267b47e5f970183a3e75125b43c2e
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpclib3/mpclib3_1.1.0-1.diff.gz' mpclib3_1.1.0-1.diff.gz 3794 SHA256:84b10a4ae958b3015e136b75be5fee22961255d19be655f7d0adae8d4f3bc977
```

### `dpkg` source package: `mpdecimal=2.4.2-3`

Binary Packages:

- `libmpdec2:amd64=2.4.2-3`

Licenses: (parsed from: `/usr/share/doc/libmpdec2/copyright`)

- `BSD`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris mpdecimal=2.4.2-3
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpdecimal/mpdecimal_2.4.2-3.dsc' mpdecimal_2.4.2-3.dsc 1932 SHA256:4cdd04de9915af3c9d787f4922affc1993d76c25cd0715ffdd2658da37c86753
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpdecimal/mpdecimal_2.4.2.orig.tar.gz' mpdecimal_2.4.2.orig.tar.gz 2271529 SHA256:83c628b90f009470981cf084c5418329c88b19835d8af3691b930afccb7d79c7
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpdecimal/mpdecimal_2.4.2-3.debian.tar.xz' mpdecimal_2.4.2-3.debian.tar.xz 6352 SHA256:1baf12776a911bc77f76e16aa7600d4ace21a27817f4a56373093065205a9292
```

### `dpkg` source package: `mpfr4=4.0.2-1`

Binary Packages:

- `libmpfr6:amd64=4.0.2-1`

Licenses: (parsed from: `/usr/share/doc/libmpfr6/copyright`)

- `GFDL-1.2`
- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris mpfr4=4.0.2-1
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpfr4/mpfr4_4.0.2-1.dsc' mpfr4_4.0.2-1.dsc 1972 SHA256:9021ec2462ed0e73ea1379266740473abf5f826be819226497729f6c6b02e672
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpfr4/mpfr4_4.0.2.orig.tar.xz' mpfr4_4.0.2.orig.tar.xz 1441996 SHA256:1d3be708604eae0e42d578ba93b390c2a145f17743a744d8f3f8c2ad5855a38a
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpfr4/mpfr4_4.0.2-1.debian.tar.xz' mpfr4_4.0.2-1.debian.tar.xz 10544 SHA256:99c4d35654f33340f0efdec67142a34753157b20334cadad9018f5eab29738da
```

### `dpkg` source package: `mpg123=1.25.13-1`

Binary Packages:

- `libmpg123-0:amd64=1.25.13-1`

Licenses: (parsed from: `/usr/share/doc/libmpg123-0/copyright`)

- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris mpg123=1.25.13-1
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpg123/mpg123_1.25.13-1.dsc' mpg123_1.25.13-1.dsc 2533 SHA256:68479f2f2aabd87af24f55b12f3f40691c24bd567b5fa9594e90f5430ea62ed1
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpg123/mpg123_1.25.13.orig.tar.bz2' mpg123_1.25.13.orig.tar.bz2 910176 SHA256:90306848359c793fd43b9906e52201df18775742dc3c81c06ab67a806509890a
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpg123/mpg123_1.25.13.orig.tar.bz2.asc' mpg123_1.25.13.orig.tar.bz2.asc 833 SHA256:86621d3e6f9c792d3d6f288175f284f20662520669c1faa308064416cb90465b
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpg123/mpg123_1.25.13-1.debian.tar.xz' mpg123_1.25.13-1.debian.tar.xz 23768 SHA256:34a93a2afcbd3c7529a7c9c3c7f24b310a6f2921ce21e7b3325d497a18601fdb
```

### `dpkg` source package: `mysql-8.0=8.0.39-0ubuntu0.20.04.1`

Binary Packages:

- `libmysqlclient21:amd64=8.0.39-0ubuntu0.20.04.1`

Licenses: (parsed from: `/usr/share/doc/libmysqlclient21/copyright`)

- `Artistic`
- `BSD-2-clause`
- `BSD-3-clause`
- `BSD-like`
- `Boost-1.0`
- `GPL-2`
- `GPL-2+`
- `ISC`
- `LGPL`
- `LGPL-2`
- `public-domain`
- `zlib/libpng`

Source:

```console
$ apt-get source -qq --print-uris mysql-8.0=8.0.39-0ubuntu0.20.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/m/mysql-8.0/mysql-8.0_8.0.39-0ubuntu0.20.04.1.dsc' mysql-8.0_8.0.39-0ubuntu0.20.04.1.dsc 3750 SHA512:c0ba30a8fdb01c2d8c85e19c1d71af10d02ec0c29904eb93625dc4ae915d58c7184e385cc0ebd6a7b3906c90929a3a7f1a74a460ce74530dc7cf99233906dc95
'http://archive.ubuntu.com/ubuntu/pool/main/m/mysql-8.0/mysql-8.0_8.0.39.orig.tar.gz' mysql-8.0_8.0.39.orig.tar.gz 449265424 SHA512:2a2785c89b59cb198d1cf383584d453d058352f0d42e485e5315163fd03e404ea4c6281ab9eb0eb7103768057af52a99dd93cb1890b61edada0d27e0ba32ed44
'http://archive.ubuntu.com/ubuntu/pool/main/m/mysql-8.0/mysql-8.0_8.0.39.orig.tar.gz.asc' mysql-8.0_8.0.39.orig.tar.gz.asc 833 SHA512:fbe5a5248a89a6316f0bf54cd66ef11c86d7445ffcd69819cbe6dde5f59a6662f773592837cfa58f7b06d0f6a92b85b5646f25ddad84b9f492b07a9e2db81414
'http://archive.ubuntu.com/ubuntu/pool/main/m/mysql-8.0/mysql-8.0_8.0.39-0ubuntu0.20.04.1.debian.tar.xz' mysql-8.0_8.0.39-0ubuntu0.20.04.1.debian.tar.xz 164120 SHA512:e2d8edbf18cddc56403bb2ff030b215db6982d42ebdbdeb0e7faa727ed501714d97d473af317af437dc9de9380855f161435067e4786e9597506d29fb6c2545d
```

### `dpkg` source package: `mysql-defaults=1.0.5ubuntu2`

Binary Packages:

- `mysql-common=5.8+1.0.5ubuntu2`

Licenses: (parsed from: `/usr/share/doc/mysql-common/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris mysql-defaults=1.0.5ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/m/mysql-defaults/mysql-defaults_1.0.5ubuntu2.dsc' mysql-defaults_1.0.5ubuntu2.dsc 2251 SHA256:788762eca77d2718a5ecc8e5fc49f90b32e81639a4a06169789e8f34fc35d379
'http://archive.ubuntu.com/ubuntu/pool/main/m/mysql-defaults/mysql-defaults_1.0.5ubuntu2.tar.xz' mysql-defaults_1.0.5ubuntu2.tar.xz 7168 SHA256:d1b17de186bf8afba5cfc0041ab3c3646dbbed653e72010e2222bb52396e54c0
```

### `dpkg` source package: `mythes=2:1.2.4-3build1`

Binary Packages:

- `libmythes-1.2-0:amd64=2:1.2.4-3build1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris mythes=2:1.2.4-3build1
'http://archive.ubuntu.com/ubuntu/pool/main/m/mythes/mythes_1.2.4-3build1.dsc' mythes_1.2.4-3build1.dsc 1909 SHA256:6da8cdbbc943c304c3599fb438b5fc73b4bd56655df06af7580ef13b665b9f2f
'http://archive.ubuntu.com/ubuntu/pool/main/m/mythes/mythes_1.2.4.orig.tar.gz' mythes_1.2.4.orig.tar.gz 4910303 SHA256:1e81f395d8c851c3e4e75b568e20fa2fa549354e75ab397f9de4b0e0790a305f
'http://archive.ubuntu.com/ubuntu/pool/main/m/mythes/mythes_1.2.4-3build1.debian.tar.xz' mythes_1.2.4-3build1.debian.tar.xz 5128 SHA256:dbf1f93698963e8924803fe85fc3baaeb958b2641c8e65cd8d64997a861c67b6
```

### `dpkg` source package: `ncurses=6.2-0ubuntu2.1`

Binary Packages:

- `libncurses6:amd64=6.2-0ubuntu2.1`
- `libncursesw6:amd64=6.2-0ubuntu2.1`
- `libtinfo6:amd64=6.2-0ubuntu2.1`
- `ncurses-base=6.2-0ubuntu2.1`
- `ncurses-bin=6.2-0ubuntu2.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris ncurses=6.2-0ubuntu2.1
'http://archive.ubuntu.com/ubuntu/pool/main/n/ncurses/ncurses_6.2-0ubuntu2.1.dsc' ncurses_6.2-0ubuntu2.1.dsc 3597 SHA512:24d67535dba8750018bbfd33347fc8e702e1e47ef7cc80a452acb5dc8031a13c7a05a000e1b7b5f1a43e9a4c370e881ebf75124bfbe181c18370f56284371f64
'http://archive.ubuntu.com/ubuntu/pool/main/n/ncurses/ncurses_6.2.orig.tar.gz' ncurses_6.2.orig.tar.gz 3425862 SHA512:4c1333dcc30e858e8a9525d4b9aefb60000cfc727bc4a1062bace06ffc4639ad9f6e54f6bdda0e3a0e5ea14de995f96b52b3327d9ec633608792c99a1e8d840d
'http://archive.ubuntu.com/ubuntu/pool/main/n/ncurses/ncurses_6.2-0ubuntu2.1.debian.tar.xz' ncurses_6.2-0ubuntu2.1.debian.tar.xz 63588 SHA512:c30de5afa3ca85e34d5834d71efb6a01453be1ca7f7356ea39b7475dd287c2800e4219d4f497efc49bf0553065f8d727028908f631f1b756d43b825d16c5a16c
```

### `dpkg` source package: `neon27=0.30.2-4`

Binary Packages:

- `libneon27-gnutls:amd64=0.30.2-4`

Licenses: (parsed from: `/usr/share/doc/libneon27-gnutls/copyright`)

- `GPL-2`
- `LGPL-2`

Source:

```console
$ apt-get source -qq --print-uris neon27=0.30.2-4
'http://archive.ubuntu.com/ubuntu/pool/main/n/neon27/neon27_0.30.2-4.dsc' neon27_0.30.2-4.dsc 2158 SHA256:b6b52513403a28e68ceb801425bc938b3fcc6fcbecddc2a0d51ba2433a9798e0
'http://archive.ubuntu.com/ubuntu/pool/main/n/neon27/neon27_0.30.2.orig.tar.gz' neon27_0.30.2.orig.tar.gz 932779 SHA256:db0bd8cdec329b48f53a6f00199c92d5ba40b0f015b153718d1b15d3d967fbca
'http://archive.ubuntu.com/ubuntu/pool/main/n/neon27/neon27_0.30.2-4.debian.tar.xz' neon27_0.30.2-4.debian.tar.xz 13848 SHA256:1e13ba75874a8c8187cae1bf739a8662dce5d4e587e899f56195a5aa78780c34
```

### `dpkg` source package: `net-tools=1.60+git20180626.aebd88e-1ubuntu1`

Binary Packages:

- `net-tools=1.60+git20180626.aebd88e-1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/net-tools/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris net-tools=1.60+git20180626.aebd88e-1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/n/net-tools/net-tools_1.60%2bgit20180626.aebd88e-1ubuntu1.dsc' net-tools_1.60+git20180626.aebd88e-1ubuntu1.dsc 2218 SHA256:63cacbc58a0a2fa6f6f9866df17a94b052ce7236def1007fbac5de16af6e90ad
'http://archive.ubuntu.com/ubuntu/pool/main/n/net-tools/net-tools_1.60%2bgit20180626.aebd88e.orig.tar.gz' net-tools_1.60+git20180626.aebd88e.orig.tar.gz 288458 SHA256:ac85b0381922ad8ecbd004192a0f7b0b22ec11834862182f18e21aa3007d9d8e
'http://archive.ubuntu.com/ubuntu/pool/main/n/net-tools/net-tools_1.60%2bgit20180626.aebd88e-1ubuntu1.debian.tar.xz' net-tools_1.60+git20180626.aebd88e-1ubuntu1.debian.tar.xz 58808 SHA256:d7e6188b66c988df26bd1e29747eb49e7e65fd0392e4d129156617f2b5365c47
```

### `dpkg` source package: `netbase=6.1`

Binary Packages:

- `netbase=6.1`

Licenses: (parsed from: `/usr/share/doc/netbase/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris netbase=6.1
'http://archive.ubuntu.com/ubuntu/pool/main/n/netbase/netbase_6.1.dsc' netbase_6.1.dsc 1480 SHA256:d3d24cf00001259d3311c0509b4e23ac150cffea27b546e3a204864f52824556
'http://archive.ubuntu.com/ubuntu/pool/main/n/netbase/netbase_6.1.tar.xz' netbase_6.1.tar.xz 31984 SHA256:084d743bd84d4d9380bac4c71c51e57406dce44f5a69289bb823c903e9b035d8
```

### `dpkg` source package: `netpbm-free=2:10.0-15.3build1`

Binary Packages:

- `libnetpbm10=2:10.0-15.3build1`
- `netpbm=2:10.0-15.3build1`

Licenses: (parsed from: `/usr/share/doc/libnetpbm10/copyright`, `/usr/share/doc/netpbm/copyright`)

- `BSD`
- `GPL`

Source:

```console
$ apt-get source -qq --print-uris netpbm-free=2:10.0-15.3build1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/netpbm-free/netpbm-free_10.0-15.3build1.dsc' netpbm-free_10.0-15.3build1.dsc 2184 SHA256:57100bdb3b2fc0c357d966979ff9b677a0d772ef5db67368076ec0118ebf8981
'http://archive.ubuntu.com/ubuntu/pool/universe/n/netpbm-free/netpbm-free_10.0.orig.tar.gz' netpbm-free_10.0.orig.tar.gz 1926538 SHA256:ea3a653f3e5a32e09cea903c5861138f6a597670dff79e2b54e902f140cff2f3
'http://archive.ubuntu.com/ubuntu/pool/universe/n/netpbm-free/netpbm-free_10.0-15.3build1.diff.gz' netpbm-free_10.0-15.3build1.diff.gz 72115 SHA256:fb187f41d676e9ec20d1f48c32738726bc13826ce068de47666fd3b3098eef9f
```

### `dpkg` source package: `nettle=3.5.1+really3.5.1-2ubuntu0.2`

Binary Packages:

- `libhogweed5:amd64=3.5.1+really3.5.1-2ubuntu0.2`
- `libnettle7:amd64=3.5.1+really3.5.1-2ubuntu0.2`

Licenses: (parsed from: `/usr/share/doc/libhogweed5/copyright`, `/usr/share/doc/libnettle7/copyright`)

- `GAP`
- `GPL`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with Autoconf exception`
- `LGPL`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1+`
- `other`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris nettle=3.5.1+really3.5.1-2ubuntu0.2
'http://archive.ubuntu.com/ubuntu/pool/main/n/nettle/nettle_3.5.1%2breally3.5.1-2ubuntu0.2.dsc' nettle_3.5.1+really3.5.1-2ubuntu0.2.dsc 2490 SHA512:a5b45f1154e48fd7d6c48c57ae17cdcb7cd4a352d6b97bb408a49f5f4f3b40388d23bc12b09602fc9d0d6e91e8bc5525b12f98568ec64c18c4d6ca9fe5048c36
'http://archive.ubuntu.com/ubuntu/pool/main/n/nettle/nettle_3.5.1%2breally3.5.1.orig.tar.gz' nettle_3.5.1+really3.5.1.orig.tar.gz 1989593 SHA512:f738121b9091cbe79435fb5d46b45cf6f10912320c233829356908127bab1cac6946ca56e022a832380c44f2c10f21d2feef64cb0f4f41e3da4a681dc0131784
'http://archive.ubuntu.com/ubuntu/pool/main/n/nettle/nettle_3.5.1%2breally3.5.1.orig.tar.gz.asc' nettle_3.5.1+really3.5.1.orig.tar.gz.asc 573 SHA512:d8921622f2165fb4a05e7e75f75d82c0eabb816f265bae3f3267def20d81386b1da1a29ebfc52bbe26875b94b2050dd5493119d0efcb5143bc21e2f69b8449dd
'http://archive.ubuntu.com/ubuntu/pool/main/n/nettle/nettle_3.5.1%2breally3.5.1-2ubuntu0.2.debian.tar.xz' nettle_3.5.1+really3.5.1-2ubuntu0.2.debian.tar.xz 27228 SHA512:389c303e679b6b6714f824f22bc8675c1ea4bdab0108b69e9514613109573d01592e3f80bf9a144866a159a9a09fa0f3218d62b9f6978bdfe5e95a18bcfe3a88
```

### `dpkg` source package: `networkd-dispatcher=2.1-2~ubuntu20.04.3`

Binary Packages:

- `networkd-dispatcher=2.1-2~ubuntu20.04.3`

Licenses: (parsed from: `/usr/share/doc/networkd-dispatcher/copyright`)

- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris networkd-dispatcher=2.1-2~ubuntu20.04.3
'http://archive.ubuntu.com/ubuntu/pool/main/n/networkd-dispatcher/networkd-dispatcher_2.1-2%7eubuntu20.04.3.dsc' networkd-dispatcher_2.1-2~ubuntu20.04.3.dsc 1932 SHA512:3d2de04ef8e20bd291979395625d582633730c34eddbab493fa6fdee966bfb4849ad3a8a32950e7e2b6da7fb83995b76c1b10eb30c5ce358867fb0eff83b64a6
'http://archive.ubuntu.com/ubuntu/pool/main/n/networkd-dispatcher/networkd-dispatcher_2.1.orig.tar.gz' networkd-dispatcher_2.1.orig.tar.gz 29650 SHA512:99c456bbb82158dd0dd18a24825d7303f14c650851f9848ad288dcd00af3ec4c4c175c2d54945e1670d4eb5288612f0ec6fb37ec7b9cbca3fd1cc66231cd634d
'http://archive.ubuntu.com/ubuntu/pool/main/n/networkd-dispatcher/networkd-dispatcher_2.1-2%7eubuntu20.04.3.debian.tar.xz' networkd-dispatcher_2.1-2~ubuntu20.04.3.debian.tar.xz 9120 SHA512:b1faa79a79e52f601e72cb141ad3296917bebd51208d600918947edecdbc0c9cb9bfaa5059639c8022771f8c3bdcbead63f77fa5c1f7716345f710c768701b9b
```

### `dpkg` source package: `nghttp2=1.40.0-1ubuntu0.3`

Binary Packages:

- `libnghttp2-14:amd64=1.40.0-1ubuntu0.3`

Licenses: (parsed from: `/usr/share/doc/libnghttp2-14/copyright`)

- `BSD-2-clause`
- `Expat`
- `GPL-3`
- `GPL-3+ with autoconf exception`
- `MIT`
- `SIL-OFL-1.1`
- `all-permissive`

Source:

```console
$ apt-get source -qq --print-uris nghttp2=1.40.0-1ubuntu0.3
'http://archive.ubuntu.com/ubuntu/pool/main/n/nghttp2/nghttp2_1.40.0-1ubuntu0.3.dsc' nghttp2_1.40.0-1ubuntu0.3.dsc 2679 SHA512:23dc554f410fa4a99a06515040490c3e2cf1200dc0ccea05499ff10eecf5434899732b6f9344a6090e7c48b0b29771acb63745b44e11a76def1e2cc2c939efc0
'http://archive.ubuntu.com/ubuntu/pool/main/n/nghttp2/nghttp2_1.40.0.orig.tar.bz2' nghttp2_1.40.0.orig.tar.bz2 1937537 SHA512:bc3f6dd8ccc3c6891b61206eeb2a74019b2559b4d75409e022c1a9ad0745d50cf8db7ca8e076993ab04a17f87455dc38159bf085bd844366dac82506e44656a0
'http://archive.ubuntu.com/ubuntu/pool/main/n/nghttp2/nghttp2_1.40.0-1ubuntu0.3.debian.tar.xz' nghttp2_1.40.0-1ubuntu0.3.debian.tar.xz 22112 SHA512:d7c1a1efdf9e7413475ba156b3ed21bf931bd494a1a404003a31ddd104ad403d9935b7655c8d650ff2ce67e4d8b6598ab9f8e757993d72dd6dbd776bac40d9af
```

### `dpkg` source package: `norm=1.5.8+dfsg2-2build1`

Binary Packages:

- `libnorm1:amd64=1.5.8+dfsg2-2build1`

Licenses: (parsed from: `/usr/share/doc/libnorm1/copyright`)

- `BSD-2-clause`
- `BSD-3-clause`
- `BSD-4-clause-UC`
- `NRL-2-clause`
- `NRL-3-clause`

Source:

```console
$ apt-get source -qq --print-uris norm=1.5.8+dfsg2-2build1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/norm/norm_1.5.8%2bdfsg2-2build1.dsc' norm_1.5.8+dfsg2-2build1.dsc 1933 SHA256:e15736f0e68b1561c717a29428febc28bae6aac8f703d722138d0c79f518c7e3
'http://archive.ubuntu.com/ubuntu/pool/universe/n/norm/norm_1.5.8%2bdfsg2.orig.tar.gz' norm_1.5.8+dfsg2.orig.tar.gz 2320548 SHA256:31cde2ef09da189c8ad168cd68c53119ce9e0e56e0de7e37c2e37c81f4c6347d
'http://archive.ubuntu.com/ubuntu/pool/universe/n/norm/norm_1.5.8%2bdfsg2-2build1.debian.tar.xz' norm_1.5.8+dfsg2-2build1.debian.tar.xz 11536 SHA256:11b7bb0f5cde86eebe8cc6fb00ab32710c911e332267b6d992bff506654cb1a9
```

### `dpkg` source package: `npth=1.6-1`

Binary Packages:

- `libnpth0:amd64=1.6-1`

Licenses: (parsed from: `/usr/share/doc/libnpth0/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris npth=1.6-1
'http://archive.ubuntu.com/ubuntu/pool/main/n/npth/npth_1.6-1.dsc' npth_1.6-1.dsc 1925 SHA256:2c327ce494f702482e79ed620445cba303c4449dd0768fecee3ee7d5ade2544a
'http://archive.ubuntu.com/ubuntu/pool/main/n/npth/npth_1.6.orig.tar.bz2' npth_1.6.orig.tar.bz2 300486 SHA256:1393abd9adcf0762d34798dc34fdcf4d0d22a8410721e76f1e3afcd1daa4e2d1
'http://archive.ubuntu.com/ubuntu/pool/main/n/npth/npth_1.6-1.debian.tar.xz' npth_1.6-1.debian.tar.xz 10532 SHA256:d312d4a3cf1d082e2f2cf3ea752c41d34f7e120f77a941c6c1680e6093834353
```

### `dpkg` source package: `nspr=2:4.35-0ubuntu0.20.04.1`

Binary Packages:

- `libnspr4:amd64=2:4.35-0ubuntu0.20.04.1`

Licenses: (parsed from: `/usr/share/doc/libnspr4/copyright`)

- `MPL-2.0`

Source:

```console
$ apt-get source -qq --print-uris nspr=2:4.35-0ubuntu0.20.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/n/nspr/nspr_4.35-0ubuntu0.20.04.1.dsc' nspr_4.35-0ubuntu0.20.04.1.dsc 2127 SHA512:1ee94034eb483adb88469c73c645116fbafc2f01f42753024e110ebd8ac7cc04093b03051786efc53735e09104695d0a6b35027d001ad41ce8d917eb73d109f8
'http://archive.ubuntu.com/ubuntu/pool/main/n/nspr/nspr_4.35.orig.tar.gz' nspr_4.35.orig.tar.gz 1096974 SHA512:502815833116e25f79ddf71d1526484908aa92fbc55f8a892729cb404a4daafcc0470a89854cd080d2d20299fdb7d9662507c5362c7ae661cbacf308ac56ef7f
'http://archive.ubuntu.com/ubuntu/pool/main/n/nspr/nspr_4.35-0ubuntu0.20.04.1.debian.tar.xz' nspr_4.35-0ubuntu0.20.04.1.debian.tar.xz 10840 SHA512:61fa5b7f9036f1ec48470e79746089146e61fb1f14436a045b7080b38e9a1974e7e29469e6b53aa3af6fa69df404ade7475b6003dcc365b498456b455399ddc7
```

### `dpkg` source package: `nss=2:3.98-0ubuntu0.20.04.2`

Binary Packages:

- `libnss3:amd64=2:3.98-0ubuntu0.20.04.2`

Licenses: (parsed from: `/usr/share/doc/libnss3/copyright`)

- `BSD-3`
- `MIT`
- `MPL-2.0`
- `Zlib`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris nss=2:3.98-0ubuntu0.20.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/n/nss/nss_3.98-0ubuntu0.20.04.2.dsc' nss_3.98-0ubuntu0.20.04.2.dsc 2294 SHA512:ba1a702a72890711a1d5348f63931f899b61558c4c80fa384231629e8c387ffe3312ac3622a2ddb15dbbf5ffd3fd006cf15f88492583639e17547602e1d077c7
'http://archive.ubuntu.com/ubuntu/pool/main/n/nss/nss_3.98.orig.tar.gz' nss_3.98.orig.tar.gz 76685475 SHA512:4f335c5c284eff6424745cc15e32037715a915f6f61687ec36a8ffaef0e45d152602a1be275bbb2f14650c7d258d6488430cdcf512b18ba7cb73cd43ac625681
'http://archive.ubuntu.com/ubuntu/pool/main/n/nss/nss_3.98-0ubuntu0.20.04.2.debian.tar.xz' nss_3.98-0ubuntu0.20.04.2.debian.tar.xz 23996 SHA512:a154f31c8bb558b752f315a9d5ca86528d700e0df47a6ab9acefbc1c99443a3212d7100e9aa75dac2246e6230a2dcc6ae68dbde1bc2a8df16423013d70cdb4cc
```

### `dpkg` source package: `numactl=2.0.12-1`

Binary Packages:

- `libnuma1:amd64=2.0.12-1`

Licenses: (parsed from: `/usr/share/doc/libnuma1/copyright`)

- `GPL`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris numactl=2.0.12-1
'http://archive.ubuntu.com/ubuntu/pool/main/n/numactl/numactl_2.0.12-1.dsc' numactl_2.0.12-1.dsc 2033 SHA256:3b308b110de0728c5524b3135d871e55ebb6e4b93cdc583e93c4222219fe4d08
'http://archive.ubuntu.com/ubuntu/pool/main/n/numactl/numactl_2.0.12.orig.tar.gz' numactl_2.0.12.orig.tar.gz 421425 SHA256:2e67513a62168de4777da20d89cdab66d75bcd3badc4256f6b190a8111cd93f8
'http://archive.ubuntu.com/ubuntu/pool/main/n/numactl/numactl_2.0.12-1.debian.tar.xz' numactl_2.0.12-1.debian.tar.xz 6756 SHA256:966724cac8f309b33959ae9922b3e5ab58ea821e2e802d96425e1eaada639a33
```

### `dpkg` source package: `ocl-icd=2.2.11-1ubuntu1`

Binary Packages:

- `ocl-icd-libopencl1:amd64=2.2.11-1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/ocl-icd-libopencl1/copyright`)

- `BSD-2-Clause`

Source:

```console
$ apt-get source -qq --print-uris ocl-icd=2.2.11-1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/o/ocl-icd/ocl-icd_2.2.11-1ubuntu1.dsc' ocl-icd_2.2.11-1ubuntu1.dsc 2101 SHA256:e786ea5edf5223f3ad32fa4b8d9a4455507b376e45342954ec5b36b21cb4904d
'http://archive.ubuntu.com/ubuntu/pool/main/o/ocl-icd/ocl-icd_2.2.11.orig.tar.gz' ocl-icd_2.2.11.orig.tar.gz 455800 SHA256:02fa41da98ae2807e92742196831d320e3fc2f4cb1118d0061d9f51dda867730
'http://archive.ubuntu.com/ubuntu/pool/main/o/ocl-icd/ocl-icd_2.2.11-1ubuntu1.debian.tar.xz' ocl-icd_2.2.11-1ubuntu1.debian.tar.xz 11204 SHA256:2baece01c46beada400992cfcbe5b0facb822bae07bda5d98f1a7ad4d474415c
```

### `dpkg` source package: `openal-soft=1:1.19.1-1`

Binary Packages:

- `libopenal-data=1:1.19.1-1`
- `libopenal1:amd64=1:1.19.1-1`

Licenses: (parsed from: `/usr/share/doc/libopenal-data/copyright`, `/usr/share/doc/libopenal1/copyright`)

- `Apache`
- `BSD-3-clause-cmake`
- `Expat`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `LGPL-2+`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris openal-soft=1:1.19.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/o/openal-soft/openal-soft_1.19.1-1.dsc' openal-soft_1.19.1-1.dsc 2524 SHA256:1ba42d3f53a4b394d1c7077b1281dfd4c8d10b1435c889d7033cd90e468468f4
'http://archive.ubuntu.com/ubuntu/pool/universe/o/openal-soft/openal-soft_1.19.1.orig.tar.gz' openal-soft_1.19.1.orig.tar.gz 683061 SHA256:9f3536ab2bb7781dbafabc6a61e0b34b17edd16bd6c2eaf2ae71bc63078f98c7
'http://archive.ubuntu.com/ubuntu/pool/universe/o/openal-soft/openal-soft_1.19.1-1.debian.tar.xz' openal-soft_1.19.1-1.debian.tar.xz 12768 SHA256:6bb1a5c6dbfdc02e5ff1d0eca00c7f2af43ca1be532424513cea20726ad48646
```

### `dpkg` source package: `openexr=2.3.0-6ubuntu0.5`

Binary Packages:

- `libopenexr24:amd64=2.3.0-6ubuntu0.5`

Licenses: (parsed from: `/usr/share/doc/libopenexr24/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2+`
- `openexr`

Source:

```console
$ apt-get source -qq --print-uris openexr=2.3.0-6ubuntu0.5
'http://archive.ubuntu.com/ubuntu/pool/universe/o/openexr/openexr_2.3.0-6ubuntu0.5.dsc' openexr_2.3.0-6ubuntu0.5.dsc 2638 SHA512:b77e6d69deaf92ca2a3990578aaf21bfc4ec5c6fab9e42b93819dce0fe4c5432feeeae4abaf2cdbc160ff9ac5099b1622a36fbcd41845c4c1355bc76a28a6dcc
'http://archive.ubuntu.com/ubuntu/pool/universe/o/openexr/openexr_2.3.0.orig.tar.gz' openexr_2.3.0.orig.tar.gz 18416222 SHA512:f6810505428674451627ef09e5dfbf13d7413e118f9defec4d160d9f1327b47699fe770a96b61da7820d2a357ccb722ad909ba4ba0924703fa5fd532cdf0da69
'http://archive.ubuntu.com/ubuntu/pool/universe/o/openexr/openexr_2.3.0.orig.tar.gz.asc' openexr_2.3.0.orig.tar.gz.asc 566 SHA512:7110ddb22b2be7b570dcb1df278b2f7f39f2c5afd470094fd2a41c2f376d3991f756cbc5bef76dfc5bd7e1f55442bc8dff468d47224a495838083ef7de0c2a40
'http://archive.ubuntu.com/ubuntu/pool/universe/o/openexr/openexr_2.3.0-6ubuntu0.5.debian.tar.xz' openexr_2.3.0-6ubuntu0.5.debian.tar.xz 40348 SHA512:a7454052906c5b683ab905a80933a323de29dfbbbe9ed2b5160e7c5fe6db4197c03d6bb463b428c7e706702a2f0c9112debbfdc5f9a430225e81b57f949c9200
```

### `dpkg` source package: `openjdk-lts=11.0.24+8-1ubuntu3~20.04`

Binary Packages:

- `openjdk-11-jdk:amd64=11.0.24+8-1ubuntu3~20.04`
- `openjdk-11-jdk-headless:amd64=11.0.24+8-1ubuntu3~20.04`
- `openjdk-11-jre:amd64=11.0.24+8-1ubuntu3~20.04`
- `openjdk-11-jre-headless:amd64=11.0.24+8-1ubuntu3~20.04`

Licenses: (parsed from: `/usr/share/doc/openjdk-11-jdk/copyright`, `/usr/share/doc/openjdk-11-jdk-headless/copyright`, `/usr/share/doc/openjdk-11-jre/copyright`, `/usr/share/doc/openjdk-11-jre-headless/copyright`)

- `GPL with Classpath exception`
- `GPL-2`
- `LGPL`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris openjdk-lts=11.0.24+8-1ubuntu3~20.04
'http://archive.ubuntu.com/ubuntu/pool/main/o/openjdk-lts/openjdk-lts_11.0.24%2b8-1ubuntu3%7e20.04.dsc' openjdk-lts_11.0.24+8-1ubuntu3~20.04.dsc 4664 SHA512:13cb31e6c4b6a157ad7197152f56f6e520d5e0e067d5a7b003741de908494184a4054b5dd3a78561d37414435c582e5a60c5a381d59fd35851e81a91cee6962f
'http://archive.ubuntu.com/ubuntu/pool/main/o/openjdk-lts/openjdk-lts_11.0.24%2b8.orig.tar.xz' openjdk-lts_11.0.24+8.orig.tar.xz 69220884 SHA512:7c7fdecf4d8a9c052922d7804fa0c2537b76bdc0cae7cf9bc0c15ed5bdb53a4a26e7a8bf42627c02c2de71cf556402e65dfd3ce956064cbc65f24ca85a47bb84
'http://archive.ubuntu.com/ubuntu/pool/main/o/openjdk-lts/openjdk-lts_11.0.24%2b8-1ubuntu3%7e20.04.debian.tar.xz' openjdk-lts_11.0.24+8-1ubuntu3~20.04.debian.tar.xz 175556 SHA512:334977becdd4a328f1292c04ab794334f4472cd69b85abb8a4818636f7aa05ba244e9d05f104b51674e8188ae7d745d2198be93f3a5b6112c47e606a767f06be
```

### `dpkg` source package: `openjpeg2=2.3.1-1ubuntu4.20.04.2`

Binary Packages:

- `libopenjp2-7:amd64=2.3.1-1ubuntu4.20.04.2`

Licenses: (parsed from: `/usr/share/doc/libopenjp2-7/copyright`)

- `BSD-2`
- `BSD-3`
- `LIBPNG`
- `LIBTIFF`
- `LIBTIFF-GLARSON`
- `LIBTIFF-PIXAR`
- `MIT`
- `ZLIB`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris openjpeg2=2.3.1-1ubuntu4.20.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/o/openjpeg2/openjpeg2_2.3.1-1ubuntu4.20.04.2.dsc' openjpeg2_2.3.1-1ubuntu4.20.04.2.dsc 2700 SHA512:77fd7d108e06fd030226fe56d6dfe21e3104cc5d080f42f6c9926b73d6674324b9f2c6734ec1366093853d0b6d7942942fc3684c3110ce3eea24b24bf201e4e8
'http://archive.ubuntu.com/ubuntu/pool/main/o/openjpeg2/openjpeg2_2.3.1.orig.tar.xz' openjpeg2_2.3.1.orig.tar.xz 1381768 SHA512:1346fae5f554102c46ad26e59888c693bf57b3ffaccfb5040b6c177f2ca510dd0915966d6bfd252b4293c0c098290c8e6cd923c265ca288e95e1fb7522b66b32
'http://archive.ubuntu.com/ubuntu/pool/main/o/openjpeg2/openjpeg2_2.3.1-1ubuntu4.20.04.2.debian.tar.xz' openjpeg2_2.3.1-1ubuntu4.20.04.2.debian.tar.xz 26028 SHA512:1607028664878f7b16754851e330064f00c1a89f5ed1677f8380170d0a583e6f5d5d28924ec8055c7cb132351a25d9e2f1b4ac45ea12cd578490c3f447f1a15e
```

### `dpkg` source package: `openldap=2.4.49+dfsg-2ubuntu1.10`

Binary Packages:

- `libldap-2.4-2:amd64=2.4.49+dfsg-2ubuntu1.10`
- `libldap-common=2.4.49+dfsg-2ubuntu1.10`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris openldap=2.4.49+dfsg-2ubuntu1.10
'http://archive.ubuntu.com/ubuntu/pool/main/o/openldap/openldap_2.4.49%2bdfsg-2ubuntu1.10.dsc' openldap_2.4.49+dfsg-2ubuntu1.10.dsc 3140 SHA512:091caf80949f3c45dd7eb17b0a94b7315c5964673590bcce5f4cc7a916054db73bd29eade6513bfee9dc9972d32aa214731e935a5a18a857f3971198d5878545
'http://archive.ubuntu.com/ubuntu/pool/main/o/openldap/openldap_2.4.49%2bdfsg.orig.tar.gz' openldap_2.4.49+dfsg.orig.tar.gz 4844726 SHA512:c2096f6e37bae8e4d4dcc5cc8dad783996bc8677e7e62a06b9f55857f8950726ca3e3b0d8368563c8985123175f63625354ad5ac271db8b55d3ac62e8906d4c7
'http://archive.ubuntu.com/ubuntu/pool/main/o/openldap/openldap_2.4.49%2bdfsg-2ubuntu1.10.debian.tar.xz' openldap_2.4.49+dfsg-2ubuntu1.10.debian.tar.xz 190520 SHA512:6782b86834c3643acd64ecf68643af47e030fded12ed90bf84c40072c63bdcd01ada54bdf0eb8ef54123c70d5b96dd447b498ed1a0e0c88efcd56126e2c9e646
```

### `dpkg` source package: `openssl=1.1.1f-1ubuntu2.23`

Binary Packages:

- `libssl1.1:amd64=1.1.1f-1ubuntu2.23`
- `openssl=1.1.1f-1ubuntu2.23`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris openssl=1.1.1f-1ubuntu2.23
'http://archive.ubuntu.com/ubuntu/pool/main/o/openssl/openssl_1.1.1f-1ubuntu2.23.dsc' openssl_1.1.1f-1ubuntu2.23.dsc 2470 SHA512:1bfd51d22c5a2459f620e57999f3a5a086b8fe34992547f97956dcd9eb319853663063f5db573aa1a2e6b4a0d5e04a4a8315154ceb9e7bbd929e5cd0c50adf1b
'http://archive.ubuntu.com/ubuntu/pool/main/o/openssl/openssl_1.1.1f.orig.tar.gz' openssl_1.1.1f.orig.tar.gz 9792828 SHA512:b00bd9b5ad5298fbceeec6bb19c1ab0c106ca5cfb31178497c58bf7e0e0cf30fcc19c20f84e23af31cc126bf2447d3e4f8461db97bafa7bd78f69561932f000c
'http://archive.ubuntu.com/ubuntu/pool/main/o/openssl/openssl_1.1.1f-1ubuntu2.23.debian.tar.xz' openssl_1.1.1f-1ubuntu2.23.debian.tar.xz 263656 SHA512:a72d090f60df822e49987abd06d70011b71e18d22bdf5553252ee9151af85aa6c35409992259c3df3003cd356f60edf9529584cb194f8c085264e868109f0dae
```

### `dpkg` source package: `opus=1.3.1-0ubuntu1`

Binary Packages:

- `libopus0:amd64=1.3.1-0ubuntu1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris opus=1.3.1-0ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/o/opus/opus_1.3.1-0ubuntu1.dsc' opus_1.3.1-0ubuntu1.dsc 1389 SHA256:b95a1010640a307e474cc4229055682ef268b700895fd305170a118e66d04353
'http://archive.ubuntu.com/ubuntu/pool/main/o/opus/opus_1.3.1.orig.tar.gz' opus_1.3.1.orig.tar.gz 1040054 SHA256:65b58e1e25b2a114157014736a3d9dfeaad8d41be1c8179866f144a2fb44ff9d
'http://archive.ubuntu.com/ubuntu/pool/main/o/opus/opus_1.3.1-0ubuntu1.diff.gz' opus_1.3.1-0ubuntu1.diff.gz 8936 SHA256:292df4c7a83b25becb54792ba71be6bbe1bd0fb232e16ac4e69d39b6c6c26ca3
```

### `dpkg` source package: `orc=1:0.4.31-1ubuntu0.1`

Binary Packages:

- `liborc-0.4-0:amd64=1:0.4.31-1ubuntu0.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris orc=1:0.4.31-1ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/o/orc/orc_0.4.31-1ubuntu0.1.dsc' orc_0.4.31-1ubuntu0.1.dsc 2340 SHA512:997b2bb71d4843b1fda94e690417a8d560cf241451e69fb0d2895ac7e739bb053317add4b3b341a99679e9902ee57f08d959c40f79fc284c1335aa7e5a728614
'http://archive.ubuntu.com/ubuntu/pool/main/o/orc/orc_0.4.31.orig.tar.xz' orc_0.4.31.orig.tar.xz 177768 SHA512:4e97597e70982dbfc239d1ef9a8913b0155e5aaac15d91162d7f73a1095bd944e27fbe6d6194b9f74af07b985a44b1d9dddbe917425e1ad9e8da17ce86495696
'http://archive.ubuntu.com/ubuntu/pool/main/o/orc/orc_0.4.31-1ubuntu0.1.debian.tar.xz' orc_0.4.31-1ubuntu0.1.debian.tar.xz 7028 SHA512:4c272dc837aace25b888103a03eb7fddec004c69a78ea96dc76f0aa2b17bfa508ee420bdd536f135ab0d4f9e59bd4b319a6806251eb6eba4f6e90d472be06d35
```

### `dpkg` source package: `p11-kit=0.23.20-1ubuntu0.1`

Binary Packages:

- `libp11-kit0:amd64=0.23.20-1ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libp11-kit0/copyright`)

- `BSD-3-Clause`
- `ISC`
- `ISC+IBM`
- `permissive-like-automake-output`
- `same-as-rest-of-p11kit`

Source:

```console
$ apt-get source -qq --print-uris p11-kit=0.23.20-1ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/p/p11-kit/p11-kit_0.23.20-1ubuntu0.1.dsc' p11-kit_0.23.20-1ubuntu0.1.dsc 2532 SHA512:8b315f15df7cd3a09d11046030baa864a0f61a3dfba80d97d708590f54a5fc5c31c81428ccc40bf04e9e769abda1204ef5cd4753a24e743e2728d38cdfe14803
'http://archive.ubuntu.com/ubuntu/pool/main/p/p11-kit/p11-kit_0.23.20.orig.tar.xz' p11-kit_0.23.20.orig.tar.xz 822588 SHA512:1eb88773fdd49dd48c7e089744e9dbbf6c1033a4863f3bfe75a68d842804baa3c373cb1b28ee625dd69a6e16c89df4ac755e0928495dccf38c007c530f6cfa57
'http://archive.ubuntu.com/ubuntu/pool/main/p/p11-kit/p11-kit_0.23.20.orig.tar.xz.asc' p11-kit_0.23.20.orig.tar.xz.asc 854 SHA512:9f0e0e690698637269b7d020aafd92ab3d487770196e13357ce0e5425fa02d5e279f9524b3858bce8bdb925e1e4d9fa2219a68e5888c06e48c3b085a77d329e9
'http://archive.ubuntu.com/ubuntu/pool/main/p/p11-kit/p11-kit_0.23.20-1ubuntu0.1.debian.tar.xz' p11-kit_0.23.20-1ubuntu0.1.debian.tar.xz 24592 SHA512:b30c6640bb02f0651955447da65911942cd2e302bc5af0ab96787646e776486e317420682dd644079a47ac48d4e2732218545af56da7ec3d3af5fd0c7e55fb21
```

### `dpkg` source package: `pam=1.3.1-5ubuntu4.7`

Binary Packages:

- `libpam-modules:amd64=1.3.1-5ubuntu4.7`
- `libpam-modules-bin=1.3.1-5ubuntu4.7`
- `libpam-runtime=1.3.1-5ubuntu4.7`
- `libpam0g:amd64=1.3.1-5ubuntu4.7`

Licenses: (parsed from: `/usr/share/doc/libpam-modules/copyright`, `/usr/share/doc/libpam-modules-bin/copyright`, `/usr/share/doc/libpam-runtime/copyright`, `/usr/share/doc/libpam0g/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris pam=1.3.1-5ubuntu4.7
'http://archive.ubuntu.com/ubuntu/pool/main/p/pam/pam_1.3.1-5ubuntu4.7.dsc' pam_1.3.1-5ubuntu4.7.dsc 2724 SHA512:8a5b76e1928b1a568358349807188e5f367790531087a1116a10071ac11daaa25aa73ea95cf1d9197c7052fbbf993122ac9f257270b1b70dc98be29d1a989a81
'http://archive.ubuntu.com/ubuntu/pool/main/p/pam/pam_1.3.1.orig.tar.xz' pam_1.3.1.orig.tar.xz 912332 SHA512:6bc8e2a5b64686f0a23846221c5228c88418ba485b17c53b3a12f91262b5bb73566d6b6a5daa1f63bbae54310aee918b987e44a72ce809b4e7c668f0fadfe08e
'http://archive.ubuntu.com/ubuntu/pool/main/p/pam/pam_1.3.1-5ubuntu4.7.debian.tar.xz' pam_1.3.1-5ubuntu4.7.debian.tar.xz 172868 SHA512:85b8c3aadb9f2d88a887b7e91f73a533a55ab2a78a0c1999b1928c3e0a3601e5a5249d0b248d7a69734fb22bb9fc270a34370279466f65efc32af2c2425abb23
```

### `dpkg` source package: `pango1.0=1.44.7-2ubuntu4`

Binary Packages:

- `libpango-1.0-0:amd64=1.44.7-2ubuntu4`
- `libpangocairo-1.0-0:amd64=1.44.7-2ubuntu4`
- `libpangoft2-1.0-0:amd64=1.44.7-2ubuntu4`

Licenses: (parsed from: `/usr/share/doc/libpango-1.0-0/copyright`, `/usr/share/doc/libpangocairo-1.0-0/copyright`, `/usr/share/doc/libpangoft2-1.0-0/copyright`)

- `Chromium-BSD-style`
- `Example`
- `ICU`
- `LGPL-2`
- `LGPL-2+`
- `TCL`
- `Unicode`

Source:

```console
$ apt-get source -qq --print-uris pango1.0=1.44.7-2ubuntu4
'http://archive.ubuntu.com/ubuntu/pool/main/p/pango1.0/pango1.0_1.44.7-2ubuntu4.dsc' pango1.0_1.44.7-2ubuntu4.dsc 2915 SHA256:e7d7027628a38d12ee9e6f29f4f6d275757d9b1fdc9e55948194f233c55251fc
'http://archive.ubuntu.com/ubuntu/pool/main/p/pango1.0/pango1.0_1.44.7.orig.tar.xz' pango1.0_1.44.7.orig.tar.xz 521384 SHA256:66a5b6cc13db73efed67b8e933584509f8ddb7b10a8a40c3850ca4a985ea1b1f
'http://archive.ubuntu.com/ubuntu/pool/main/p/pango1.0/pango1.0_1.44.7-2ubuntu4.debian.tar.xz' pango1.0_1.44.7-2ubuntu4.debian.tar.xz 33516 SHA256:6f5f8c66299af90a94c4dbdfa146e840eec8bc2d183cd1fb42e8e7de6f335df5
```

### `dpkg` source package: `pcre2=10.34-7ubuntu0.1`

Binary Packages:

- `libpcre2-8-0:amd64=10.34-7ubuntu0.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris pcre2=10.34-7ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/p/pcre2/pcre2_10.34-7ubuntu0.1.dsc' pcre2_10.34-7ubuntu0.1.dsc 2142 SHA512:f37aadf191246ca9e4605a57e9a15e3bac768649c19970259b03b5792b52ca848206866be5b5b79fec659c6b2defa50dd263d2e0ff41d706e613c707cb5540fc
'http://archive.ubuntu.com/ubuntu/pool/main/p/pcre2/pcre2_10.34.orig.tar.gz' pcre2_10.34.orig.tar.gz 2271533 SHA512:820b3805fc7fcf3a80dfd42ff570efc8518fe3c50f3feb720319b95316619e5b8f6601b3c9522606315aecd5558ccfc8a04a89fab9921fdfc3400dc2caf17c22
'http://archive.ubuntu.com/ubuntu/pool/main/p/pcre2/pcre2_10.34-7ubuntu0.1.diff.gz' pcre2_10.34-7ubuntu0.1.diff.gz 10945 SHA512:92f25dddec9ca30dc7221ee09e5b401c59fbf86acd3612451f6c64e55f7a9f96fd9752ac7398f05aa59214d9649f63324ec0f6ede2f178653f361ae9adeb7e70
```

### `dpkg` source package: `pcre3=2:8.39-12ubuntu0.1`

Binary Packages:

- `libpcre3:amd64=2:8.39-12ubuntu0.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris pcre3=2:8.39-12ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/p/pcre3/pcre3_8.39-12ubuntu0.1.dsc' pcre3_8.39-12ubuntu0.1.dsc 2077 SHA512:8c8d2c065a5cfbc912747f44365b9d3c7dee77e2d5f1ff4049e1c505dfc792d2e44cf42dd108bb63fe23806d869927acfe52ae9e75160fbec9aa3ac6297ac8d1
'http://archive.ubuntu.com/ubuntu/pool/main/p/pcre3/pcre3_8.39.orig.tar.bz2' pcre3_8.39.orig.tar.bz2 1560758 SHA512:8b0f14ae5947c4b2d74876a795b04e532fd71c2479a64dbe0ed817e7c7894ea3cae533413de8c17322d305cb7f4e275d72b43e4e828eaca77dc4bcaf04529cf6
'http://archive.ubuntu.com/ubuntu/pool/main/p/pcre3/pcre3_8.39-12ubuntu0.1.debian.tar.gz' pcre3_8.39-12ubuntu0.1.debian.tar.gz 27476 SHA512:a6ca841c38badb86d9cf6170f24fe627688ebda39304f6adf6666c580fe64bb451c1ea4d3ed96d09b70d11a4c88cc05f38d45d72b985b3efaf1934d47acb0431
```

### `dpkg` source package: `pcsc-lite=1.8.26-3`

Binary Packages:

- `libpcsclite1:amd64=1.8.26-3`

Licenses: (parsed from: `/usr/share/doc/libpcsclite1/copyright`)

- `BSD-3-clause`
- `Expat`
- `GPL-3`
- `GPL-3+`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris pcsc-lite=1.8.26-3
'http://archive.ubuntu.com/ubuntu/pool/main/p/pcsc-lite/pcsc-lite_1.8.26-3.dsc' pcsc-lite_1.8.26-3.dsc 2092 SHA256:e48f0831f3e3b44bed686438a59bc659082ebd8d18f1f79e04db4f24a0947c17
'http://archive.ubuntu.com/ubuntu/pool/main/p/pcsc-lite/pcsc-lite_1.8.26.orig.tar.bz2' pcsc-lite_1.8.26.orig.tar.bz2 754838 SHA256:3eb7be7d6ef618c0a444316cf5c1f2f9d7227aedba7a192f389fe3e7c0dfbbd9
'http://archive.ubuntu.com/ubuntu/pool/main/p/pcsc-lite/pcsc-lite_1.8.26-3.debian.tar.xz' pcsc-lite_1.8.26-3.debian.tar.xz 18812 SHA256:d341855fcaeb4bd28bba502ece78e18c01d0e63d7bba01c6489b6ce1705db8f4
```

### `dpkg` source package: `perl-openssl-defaults=4`

Binary Packages:

- `perl-openssl-defaults:amd64=4`

Licenses: (parsed from: `/usr/share/doc/perl-openssl-defaults/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris perl-openssl-defaults=4
'http://archive.ubuntu.com/ubuntu/pool/main/p/perl-openssl-defaults/perl-openssl-defaults_4.dsc' perl-openssl-defaults_4.dsc 1861 SHA256:3b766d088375a30c5985bdfce3147150ba747c812ce1d87fcd4cb3cb6ef42703
'http://archive.ubuntu.com/ubuntu/pool/main/p/perl-openssl-defaults/perl-openssl-defaults_4.tar.xz' perl-openssl-defaults_4.tar.xz 4392 SHA256:81653b03e48f9f8d638dd5a2bcd82dd5738d02ed66cdffa56c6f2882f08faa1e
```

### `dpkg` source package: `perl=5.30.0-9ubuntu0.5`

Binary Packages:

- `libperl5.30:amd64=5.30.0-9ubuntu0.5`
- `perl=5.30.0-9ubuntu0.5`
- `perl-base=5.30.0-9ubuntu0.5`
- `perl-modules-5.30=5.30.0-9ubuntu0.5`

Licenses: (parsed from: `/usr/share/doc/libperl5.30/copyright`, `/usr/share/doc/perl/copyright`, `/usr/share/doc/perl-base/copyright`, `/usr/share/doc/perl-modules-5.30/copyright`)

- `Artistic`
- `Artistic,`
- `Artistic-2`
- `Artistic-dist`
- `BSD-3-clause`
- `BSD-3-clause-GENERIC`
- `BSD-3-clause-with-weird-numbering`
- `BSD-4-clause-POWERDOG`
- `BZIP`
- `CC0-1.0`
- `DONT-CHANGE-THE-GPL`
- `Expat`
- `GPL-1`
- `GPL-1+`
- `GPL-2`
- `GPL-2+`
- `GPL-3+-WITH-BISON-EXCEPTION`
- `HSIEH-BSD`
- `HSIEH-DERIVATIVE`
- `LGPL-2.1`
- `REGCOMP`
- `REGCOMP,`
- `RRA-KEEP-THIS-NOTICE`
- `SDBM-PUBLIC-DOMAIN`
- `TEXT-TABS`
- `Unicode`
- `ZLIB`

Source:

```console
$ apt-get source -qq --print-uris perl=5.30.0-9ubuntu0.5
'http://archive.ubuntu.com/ubuntu/pool/main/p/perl/perl_5.30.0-9ubuntu0.5.dsc' perl_5.30.0-9ubuntu0.5.dsc 2962 SHA512:465120e571e4dc71b167a67cd945ba92476d3ce41fd8b39483e8058a6bddf534149d0fc1a0bfb0e6c83c5ec35b0720ab50ec035d3030978844b8965db9de5459
'http://archive.ubuntu.com/ubuntu/pool/main/p/perl/perl_5.30.0.orig-regen-configure.tar.gz' perl_5.30.0.orig-regen-configure.tar.gz 833235 SHA512:ab977887b53249a2423708aa38ecbb8bdbfdb7ba533a795eaa20bac427b2eb326756b076ca11088036550a4db24418903c0565d168fe9641e18077a76d04274a
'http://archive.ubuntu.com/ubuntu/pool/main/p/perl/perl_5.30.0.orig.tar.xz' perl_5.30.0.orig.tar.xz 12419868 SHA512:68a295eccd64debd9d6a10f0d5577f872a19ad8c2d702798f6b0f45b8c3af6ab3230768056e2131e9e2e2506d1035b27cfd627c845e32263fe448649c4b98ae9
'http://archive.ubuntu.com/ubuntu/pool/main/p/perl/perl_5.30.0-9ubuntu0.5.debian.tar.xz' perl_5.30.0-9ubuntu0.5.debian.tar.xz 172444 SHA512:a7adf38eaa3c23d538c8c051ea0803a8c787e812d21e9d2a79b2e90475746699cc7dd4d4b914f2a79d7178db8fb9dd90b8e92d1c522b8db05467bbee9c8be678
```

### `dpkg` source package: `pinentry=1.1.0-3build1`

Binary Packages:

- `pinentry-curses=1.1.0-3build1`

Licenses: (parsed from: `/usr/share/doc/pinentry-curses/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-3`
- `LGPL-3+`
- `X11`

Source:

```console
$ apt-get source -qq --print-uris pinentry=1.1.0-3build1
'http://archive.ubuntu.com/ubuntu/pool/main/p/pinentry/pinentry_1.1.0-3build1.dsc' pinentry_1.1.0-3build1.dsc 2714 SHA256:69f7f343287886eebadb94177767d9aa74890d9f8420e3ab254803fcd21852bf
'http://archive.ubuntu.com/ubuntu/pool/main/p/pinentry/pinentry_1.1.0.orig.tar.bz2' pinentry_1.1.0.orig.tar.bz2 467702 SHA256:68076686fa724a290ea49cdf0d1c0c1500907d1b759a3bcbfbec0293e8f56570
'http://archive.ubuntu.com/ubuntu/pool/main/p/pinentry/pinentry_1.1.0-3build1.debian.tar.xz' pinentry_1.1.0-3build1.debian.tar.xz 17224 SHA256:2a11ee552389ba0499d6a9e1bfc38ee65a28bb97758832b982bbede68d2cb1b9
```

### `dpkg` source package: `pixman=0.38.4-0ubuntu2.1`

Binary Packages:

- `libpixman-1-0:amd64=0.38.4-0ubuntu2.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris pixman=0.38.4-0ubuntu2.1
'http://archive.ubuntu.com/ubuntu/pool/main/p/pixman/pixman_0.38.4-0ubuntu2.1.dsc' pixman_0.38.4-0ubuntu2.1.dsc 2130 SHA512:9ec381b420c176be4e90baccddeff31e78bcfe97fa1f9008cac4eb7f93a2c3626ff25bf76765863dee92b48a8251b162d47b53b887d316b27617c246c1809c1d
'http://archive.ubuntu.com/ubuntu/pool/main/p/pixman/pixman_0.38.4.orig.tar.gz' pixman_0.38.4.orig.tar.gz 897926 SHA512:b66dc23c0bc7327cb90085cbc14ccf96ad58001a927f23af24e0258ca13f32d4255535862f1efcf00e9e723410aa9f51edf26fb01c8cde49379d1225acf7b5af
'http://archive.ubuntu.com/ubuntu/pool/main/p/pixman/pixman_0.38.4-0ubuntu2.1.diff.gz' pixman_0.38.4-0ubuntu2.1.diff.gz 320623 SHA512:457ad061efc8bb96fb74e0c3bd1cb811be2db56a315ed4634e8f94355a0ef0e96b42d32721c9778299960eca143c1165f52dbfd8fb25906e500eedd2267b8b89
```

### `dpkg` source package: `poppler-data=0.4.9-2`

Binary Packages:

- `poppler-data=0.4.9-2`

Licenses: (parsed from: `/usr/share/doc/poppler-data/copyright`)

- `AGPL-3+`
- `BSD-3-cluase`
- `GPL-2`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris poppler-data=0.4.9-2
'http://archive.ubuntu.com/ubuntu/pool/main/p/poppler-data/poppler-data_0.4.9-2.dsc' poppler-data_0.4.9-2.dsc 2456 SHA256:da4b19cc39f2b0d767dfd500c04949db7aa2139324c4e0d3278ed86d3edcfde5
'http://archive.ubuntu.com/ubuntu/pool/main/p/poppler-data/poppler-data_0.4.9.orig-ai0.tar.gz' poppler-data_0.4.9.orig-ai0.tar.gz 3515 SHA256:755a3a7cec6019b7cb6a7ac89828820e90d5105e66ebc2a7aacecacfb3ed4f1d
'http://archive.ubuntu.com/ubuntu/pool/main/p/poppler-data/poppler-data_0.4.9.orig-from-ghostscript.tar.xz' poppler-data_0.4.9.orig-from-ghostscript.tar.xz 2320 SHA256:5070e1f3645080c809d80c42ee2e736648fe37bc2a68c3f54d1f9fce01086215
'http://archive.ubuntu.com/ubuntu/pool/main/p/poppler-data/poppler-data_0.4.9.orig.tar.gz' poppler-data_0.4.9.orig.tar.gz 4196919 SHA256:1f9c7e7de9ecd0db6ab287349e31bf815ca108a5a175cf906a90163bdbe32012
'http://archive.ubuntu.com/ubuntu/pool/main/p/poppler-data/poppler-data_0.4.9-2.debian.tar.xz' poppler-data_0.4.9-2.debian.tar.xz 19504 SHA256:300792a153c1bfcf2413807875e333c7ba31a30a71f64d97bca58de307589d70
```

### `dpkg` source package: `poppler=0.86.1-0ubuntu1.4`

Binary Packages:

- `libpoppler97:amd64=0.86.1-0ubuntu1.4`

Licenses: (parsed from: `/usr/share/doc/libpoppler97/copyright`)

- `Apache-2.0`
- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris poppler=0.86.1-0ubuntu1.4
'http://archive.ubuntu.com/ubuntu/pool/main/p/poppler/poppler_0.86.1-0ubuntu1.4.dsc' poppler_0.86.1-0ubuntu1.4.dsc 3190 SHA512:2fbd95a69dfe61ed1934cd3cfc8f145d6f046c575a6c377690957d3eb876fc2ba903237082f1491d1bbbd883c7ff69d13b9409ccddc07626e5df01e23fe12ae0
'http://archive.ubuntu.com/ubuntu/pool/main/p/poppler/poppler_0.86.1.orig.tar.xz' poppler_0.86.1.orig.tar.xz 1593856 SHA512:435fc1e7f3e8123e0adde9aa60c0d7dc17db367cde8908932abfef913cee6f27efeb1c4f2d6f316019a69a87f1fa5251be4216d0a81a681a24f24a70ac571670
'http://archive.ubuntu.com/ubuntu/pool/main/p/poppler/poppler_0.86.1-0ubuntu1.4.debian.tar.xz' poppler_0.86.1-0ubuntu1.4.debian.tar.xz 40712 SHA512:38dd125da56578dd58cfc22a6cad1076158f6dd4723d5bb9bb30213ba1cd2a0c5b80dc6d0d58c38bf9422556571a6d8c47b8f7faf94be85dd0fce7929fe0852a
```

### `dpkg` source package: `postgresql-12=12.20-0ubuntu0.20.04.1`

Binary Packages:

- `libpq5:amd64=12.20-0ubuntu0.20.04.1`

Licenses: (parsed from: `/usr/share/doc/libpq5/copyright`)

- `Artistic`
- `BSD-2-clause`
- `BSD-3-Clause`
- `BSD-3-clause`
- `Custom-Unicode`
- `Custom-pg_dump`
- `Custom-regex`
- `GPL-1`
- `PostgreSQL`
- `Tcl`
- `blf`
- `double-metaphone`
- `imath`
- `nagaysau-ishii`
- `rijndael`

Source:

```console
$ apt-get source -qq --print-uris postgresql-12=12.20-0ubuntu0.20.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/p/postgresql-12/postgresql-12_12.20-0ubuntu0.20.04.1.dsc' postgresql-12_12.20-0ubuntu0.20.04.1.dsc 3764 SHA512:181987a026c8e9cef3776c3303b4fbb2517600e649f760e778e1263619cd565ec547dc6723c130a8eef536c72dc2de75000c373666c9e07110faeda565567213
'http://archive.ubuntu.com/ubuntu/pool/main/p/postgresql-12/postgresql-12_12.20.orig.tar.gz' postgresql-12_12.20.orig.tar.gz 27882894 SHA512:1dfe60aae446aa7a110f5dd0cbb43bf5db9df886c9ce1189010a384aad1a098246476a48742c3763ec469098235c78c3995b501a94f61b42402ae7cf7e87693a
'http://archive.ubuntu.com/ubuntu/pool/main/p/postgresql-12/postgresql-12_12.20-0ubuntu0.20.04.1.debian.tar.xz' postgresql-12_12.20-0ubuntu0.20.04.1.debian.tar.xz 29892 SHA512:beeb05cdecdaa41f55d366b11579962533e7e0108ed62aaa13f347972182812985bf767a9fa621c4f95f26ed4c1cfa6557d5098c60a1cbb7b07252a67374405f
```

### `dpkg` source package: `procps=2:3.3.16-1ubuntu2.4`

Binary Packages:

- `libprocps8:amd64=2:3.3.16-1ubuntu2.4`
- `procps=2:3.3.16-1ubuntu2.4`

Licenses: (parsed from: `/usr/share/doc/libprocps8/copyright`, `/usr/share/doc/procps/copyright`)

- `GPL-2`
- `GPL-2.0+`
- `LGPL-2`
- `LGPL-2.0+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris procps=2:3.3.16-1ubuntu2.4
'http://archive.ubuntu.com/ubuntu/pool/main/p/procps/procps_3.3.16-1ubuntu2.4.dsc' procps_3.3.16-1ubuntu2.4.dsc 2108 SHA512:334d57eaf7ff4792b1222cc7bdb4230dc41aafad26f9320461b9bea42e025e4531fcd2f5cdfdffad7c42cbab2467dbca08fa73b8760cce77eb8f2d3902a1afc1
'http://archive.ubuntu.com/ubuntu/pool/main/p/procps/procps_3.3.16.orig.tar.xz' procps_3.3.16.orig.tar.xz 621892 SHA512:38db4f72fe40c2f027b23b18bbc8c29cfcdf6bcdb029199fe4bebede153943aa884157f56e792c399f9a4949cc514687500bb99a75a5e7ad7b9e878f52090304
'http://archive.ubuntu.com/ubuntu/pool/main/p/procps/procps_3.3.16-1ubuntu2.4.debian.tar.xz' procps_3.3.16-1ubuntu2.4.debian.tar.xz 35232 SHA512:cb4310496951e74a13ec439dbff8c655d0fdcd82bb96d58c0954002d24ed474bf028f4ff6606274ab301de2184b441517809019776b497415487020ebaa05d0f
```

### `dpkg` source package: `publicsuffix=20200303.0012-1`

Binary Packages:

- `publicsuffix=20200303.0012-1`

Licenses: (parsed from: `/usr/share/doc/publicsuffix/copyright`)

- `CC0`
- `MPL-2.0`

Source:

```console
$ apt-get source -qq --print-uris publicsuffix=20200303.0012-1
'http://archive.ubuntu.com/ubuntu/pool/main/p/publicsuffix/publicsuffix_20200303.0012-1.dsc' publicsuffix_20200303.0012-1.dsc 1406 SHA256:ada2841021e758d6ebb15063d3caf243f545b01b5edf6adf65ecdf187fa2493c
'http://archive.ubuntu.com/ubuntu/pool/main/p/publicsuffix/publicsuffix_20200303.0012.orig.tar.gz' publicsuffix_20200303.0012.orig.tar.gz 94164 SHA256:048bf6efaf055c4cfed1c79b204f4c1f8f2d1f66ad0424979a227f43ef8df243
'http://archive.ubuntu.com/ubuntu/pool/main/p/publicsuffix/publicsuffix_20200303.0012-1.debian.tar.xz' publicsuffix_20200303.0012-1.debian.tar.xz 15328 SHA256:3dbbd7b1e20bafc3e5ad73732cb026a4b8e6e5dafa25a9047151e9a28b251647
```

### `dpkg` source package: `pulseaudio=1:13.99.1-1ubuntu3.13`

Binary Packages:

- `libpulse0:amd64=1:13.99.1-1ubuntu3.13`

Licenses: (parsed from: `/usr/share/doc/libpulse0/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris pulseaudio=1:13.99.1-1ubuntu3.13
'http://archive.ubuntu.com/ubuntu/pool/main/p/pulseaudio/pulseaudio_13.99.1-1ubuntu3.13.dsc' pulseaudio_13.99.1-1ubuntu3.13.dsc 3223 SHA512:8f6e4e45d65051c402d0c2ac44fd21db752ec5301568d0a8cd6c238b33abe09486f9b89e5459f1652f5e673ab7b6bab9014aece2104384a737e1b5a5ad8b05ad
'http://archive.ubuntu.com/ubuntu/pool/main/p/pulseaudio/pulseaudio_13.99.1.orig.tar.xz' pulseaudio_13.99.1.orig.tar.xz 1955840 SHA512:426530b6b9dd94dcc848067376857faae42e86878a82784c5bafa615a68dcc7e22702e0cb5835f91160f19fc9934fe3d53b7d387e3f42b6595fa934b172fe2aa
'http://archive.ubuntu.com/ubuntu/pool/main/p/pulseaudio/pulseaudio_13.99.1-1ubuntu3.13.debian.tar.xz' pulseaudio_13.99.1-1ubuntu3.13.debian.tar.xz 159176 SHA512:94d1e774f4dfbbbe5c9b44fc8e7135e9a3dbcf367194d41e65438d175269120b7ba45d0c9bf970b8e1dc280f3c8bb71875af4a1b18e472e280335968dc17fd64
```

### `dpkg` source package: `pygobject=3.36.0-1`

Binary Packages:

- `python3-gi=3.36.0-1`

Licenses: (parsed from: `/usr/share/doc/python3-gi/copyright`)

- `Expat`
- `LGPL-2`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris pygobject=3.36.0-1
'http://archive.ubuntu.com/ubuntu/pool/main/p/pygobject/pygobject_3.36.0-1.dsc' pygobject_3.36.0-1.dsc 2829 SHA256:dece737c3e4fe1119fe8b97f9a33ee26af55deea9e91a7fb83e1430fb8444496
'http://archive.ubuntu.com/ubuntu/pool/main/p/pygobject/pygobject_3.36.0.orig.tar.xz' pygobject_3.36.0.orig.tar.xz 555592 SHA256:8683d2dfb5baa9e501a9a64eeba5c2c1117eadb781ab1cd7a9d255834af6daef
'http://archive.ubuntu.com/ubuntu/pool/main/p/pygobject/pygobject_3.36.0-1.debian.tar.xz' pygobject_3.36.0-1.debian.tar.xz 21904 SHA256:3758d828c276e893b95e2280dd254d1984eb0ef7413fc317431037adea5384a9
```

### `dpkg` source package: `python3-defaults=3.8.2-0ubuntu2`

Binary Packages:

- `libpython3-stdlib:amd64=3.8.2-0ubuntu2`
- `python3=3.8.2-0ubuntu2`
- `python3-minimal=3.8.2-0ubuntu2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris python3-defaults=3.8.2-0ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/p/python3-defaults/python3-defaults_3.8.2-0ubuntu2.dsc' python3-defaults_3.8.2-0ubuntu2.dsc 2879 SHA256:3fa296ea2cd52738ebc44a1b83a8df500bf654356336d9bf057144171fe9ee7d
'http://archive.ubuntu.com/ubuntu/pool/main/p/python3-defaults/python3-defaults_3.8.2-0ubuntu2.tar.gz' python3-defaults_3.8.2-0ubuntu2.tar.gz 138226 SHA256:e4969a54306421ebfd195d0c064935db7c53f9f152d8abaae63da33819235e9a
```

### `dpkg` source package: `python3.8=3.8.10-0ubuntu1~20.04.12`

Binary Packages:

- `libpython3.8:amd64=3.8.10-0ubuntu1~20.04.12`
- `libpython3.8-minimal:amd64=3.8.10-0ubuntu1~20.04.12`
- `libpython3.8-stdlib:amd64=3.8.10-0ubuntu1~20.04.12`
- `python3.8=3.8.10-0ubuntu1~20.04.12`
- `python3.8-minimal=3.8.10-0ubuntu1~20.04.12`

Licenses: (parsed from: `/usr/share/doc/libpython3.8/copyright`, `/usr/share/doc/libpython3.8-minimal/copyright`, `/usr/share/doc/libpython3.8-stdlib/copyright`, `/usr/share/doc/python3.8/copyright`, `/usr/share/doc/python3.8-minimal/copyright`)

- `* Permission to use this software in any way is granted without`
- `By obtaining, using, and/or copying this software and/or its`
- `GPL-2`
- `Permission  is  hereby granted,  free  of charge,  to  any person`
- `Permission is hereby granted, free of charge, to any person obtaining`
- `Permission to use, copy, modify,`
- `Redistribution`
- `This software is provided 'as-is', without any express`
- `This software is provided as-is, without express`
- `binary forms, with`
- `distribute this software`
- `distribute this software and`
- `distribute this software for any`
- `implied`
- `its`
- `use in source`
- `without`

Source:

```console
$ apt-get source -qq --print-uris python3.8=3.8.10-0ubuntu1~20.04.12
'http://archive.ubuntu.com/ubuntu/pool/main/p/python3.8/python3.8_3.8.10-0ubuntu1%7e20.04.12.dsc' python3.8_3.8.10-0ubuntu1~20.04.12.dsc 3508 SHA512:ee99133c5be3e582eb27e6f5c85c815aa7464b56fb5d6028b605ee543b542ea88d54af19e474c08b0b848557c8474f9a8ff4667d53f9419b22ba7e373fbe8d70
'http://archive.ubuntu.com/ubuntu/pool/main/p/python3.8/python3.8_3.8.10.orig.tar.xz' python3.8_3.8.10.orig.tar.xz 18433456 SHA512:0be69705483ff9692e12048a96180e586f9d84c8d53066629f7fb2389585eb75c0f3506bb8182936e322508f58b71f4d8c6dfebbab9049b31b49da11d3b98e80
'http://archive.ubuntu.com/ubuntu/pool/main/p/python3.8/python3.8_3.8.10-0ubuntu1%7e20.04.12.debian.tar.xz' python3.8_3.8.10-0ubuntu1~20.04.12.debian.tar.xz 246352 SHA512:94895fe559180cd3f2f8018b96d69f06d85f3e19a48e762e4523ec529e2dbbfcda015c2bd374517e63ca9e2725ca240838b9bafdccbf3e8fadbe70bf61a1d223
```

### `dpkg` source package: `raptor2=2.0.15-0ubuntu1.20.04.1`

Binary Packages:

- `libraptor2-0:amd64=2.0.15-0ubuntu1.20.04.1`

Licenses: (parsed from: `/usr/share/doc/libraptor2-0/copyright`)

- `Apache-2.0`
- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris raptor2=2.0.15-0ubuntu1.20.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/r/raptor2/raptor2_2.0.15-0ubuntu1.20.04.1.dsc' raptor2_2.0.15-0ubuntu1.20.04.1.dsc 2252 SHA512:9c68ad686bda3453efaabd80cc47fb4ecb8d5b8598b72716e6873a25f5b0f9d863755be680204310f27f2299336c11595c1a8a782c34559f6711a2ce9bb6944c
'http://archive.ubuntu.com/ubuntu/pool/main/r/raptor2/raptor2_2.0.15.orig.tar.gz' raptor2_2.0.15.orig.tar.gz 1886657 SHA512:563dd01869eb4df8524ec12e2c0a541653874dcd834bd1eb265bc2943bb616968f624121d4688579cdce11b4f00a8ab53b7099f1a0850e256bb0a2c16ba048ee
'http://archive.ubuntu.com/ubuntu/pool/main/r/raptor2/raptor2_2.0.15-0ubuntu1.20.04.1.debian.tar.xz' raptor2_2.0.15-0ubuntu1.20.04.1.debian.tar.xz 8496 SHA512:a18a37d2749d893871555c1c3e980eb5ab480060a33c11de9339c024eb924e50f0716923dd0749c59ab765eaff419ff5d50aeae5c2fd6ee2bf25103328279426
```

### `dpkg` source package: `rasqal=0.9.33-0.1`

Binary Packages:

- `librasqal3:amd64=0.9.33-0.1`

Licenses: (parsed from: `/usr/share/doc/librasqal3/copyright`)

- `Apache-2.0`
- `Apache-2.0+`
- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris rasqal=0.9.33-0.1
'http://archive.ubuntu.com/ubuntu/pool/main/r/rasqal/rasqal_0.9.33-0.1.dsc' rasqal_0.9.33-0.1.dsc 2071 SHA256:8eec59c6f2c1d9492e625b8e1b0f76a77eb4bbce04395285dffb062eb778087a
'http://archive.ubuntu.com/ubuntu/pool/main/r/rasqal/rasqal_0.9.33.orig.tar.gz' rasqal_0.9.33.orig.tar.gz 1595647 SHA256:6924c9ac6570bd241a9669f83b467c728a322470bf34f4b2da4f69492ccfd97c
'http://archive.ubuntu.com/ubuntu/pool/main/r/rasqal/rasqal_0.9.33-0.1.debian.tar.xz' rasqal_0.9.33-0.1.debian.tar.xz 5980 SHA256:28916ca977362ff9edf41432faa33c5db25595719d34ede560c15318b970c9b1
```

### `dpkg` source package: `readline=8.0-4`

Binary Packages:

- `libreadline8:amd64=8.0-4`
- `readline-common=8.0-4`

Licenses: (parsed from: `/usr/share/doc/libreadline8/copyright`, `/usr/share/doc/readline-common/copyright`)

- `GFDL`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris readline=8.0-4
'http://archive.ubuntu.com/ubuntu/pool/main/r/readline/readline_8.0-4.dsc' readline_8.0-4.dsc 2434 SHA256:ac9c7bb7380fe740aef09f54becf482eb81032a33dc11f1a8f00e933c5f168f4
'http://archive.ubuntu.com/ubuntu/pool/main/r/readline/readline_8.0.orig.tar.gz' readline_8.0.orig.tar.gz 2975937 SHA256:e339f51971478d369f8a053a330a190781acb9864cf4c541060f12078948e461
'http://archive.ubuntu.com/ubuntu/pool/main/r/readline/readline_8.0-4.debian.tar.xz' readline_8.0-4.debian.tar.xz 30408 SHA256:60ed18dab6d6b7fc998a263d917f06d9cce6e1ccd19cd8bf4a9d33c5350cf8d6
```

### `dpkg` source package: `redland=1.0.17-1.1ubuntu1`

Binary Packages:

- `librdf0:amd64=1.0.17-1.1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/librdf0/copyright`)

- `Apache-2.0`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris redland=1.0.17-1.1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/r/redland/redland_1.0.17-1.1ubuntu1.dsc' redland_1.0.17-1.1ubuntu1.dsc 2460 SHA256:ec639fe72a9fb3d9973c20a1f73edf5c9507a1ff89c1d9c7095a6a6752de3fbb
'http://archive.ubuntu.com/ubuntu/pool/main/r/redland/redland_1.0.17.orig.tar.gz' redland_1.0.17.orig.tar.gz 1621566 SHA256:de1847f7b59021c16bdc72abb4d8e2d9187cd6124d69156f3326dd34ee043681
'http://archive.ubuntu.com/ubuntu/pool/main/r/redland/redland_1.0.17-1.1ubuntu1.debian.tar.xz' redland_1.0.17-1.1ubuntu1.debian.tar.xz 8696 SHA256:234374b8c10a7c226a91e5765a25abd54481baf09bc07836d536d2eb26f0f421
```

### `dpkg` source package: `rtmpdump=2.4+20151223.gitfa8646d.1-2build1`

Binary Packages:

- `librtmp1:amd64=2.4+20151223.gitfa8646d.1-2build1`

Licenses: (parsed from: `/usr/share/doc/librtmp1/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris rtmpdump=2.4+20151223.gitfa8646d.1-2build1
'http://archive.ubuntu.com/ubuntu/pool/main/r/rtmpdump/rtmpdump_2.4%2b20151223.gitfa8646d.1-2build1.dsc' rtmpdump_2.4+20151223.gitfa8646d.1-2build1.dsc 2439 SHA256:fd89213f2d41b00c212a411a945146c6b2e00fce1d1819a9ec380b0d91bd1077
'http://archive.ubuntu.com/ubuntu/pool/main/r/rtmpdump/rtmpdump_2.4%2b20151223.gitfa8646d.1.orig.tar.gz' rtmpdump_2.4+20151223.gitfa8646d.1.orig.tar.gz 142213 SHA256:5c032f5c8cc2937eb55a81a94effdfed3b0a0304b6376147b86f951e225e3ab5
'http://archive.ubuntu.com/ubuntu/pool/main/r/rtmpdump/rtmpdump_2.4%2b20151223.gitfa8646d.1-2build1.debian.tar.xz' rtmpdump_2.4+20151223.gitfa8646d.1-2build1.debian.tar.xz 8216 SHA256:b256cc2aa96c9b99918052c4badfab0339ba95a852eab5ae37aa8b53c259efd2
```

### `dpkg` source package: `rubberband=1.8.2-1build1`

Binary Packages:

- `librubberband2:amd64=1.8.2-1build1`

Licenses: (parsed from: `/usr/share/doc/librubberband2/copyright`)

- `GPL-2`
- `GPL-2+`
- `other-1`
- `other-bsd-3-clause-kissft`
- `other-bsd-3-clause-speex`
- `other-bsd-4-clause-1`
- `other-bsd-4-clause-2`
- `zlib`

Source:

```console
$ apt-get source -qq --print-uris rubberband=1.8.2-1build1
'http://archive.ubuntu.com/ubuntu/pool/universe/r/rubberband/rubberband_1.8.2-1build1.dsc' rubberband_1.8.2-1build1.dsc 2376 SHA256:078ea7ff612d1cc20135d4b2229e5845dc7ff2ce92555a34cbe0d8531cb3b10e
'http://archive.ubuntu.com/ubuntu/pool/universe/r/rubberband/rubberband_1.8.2.orig.tar.bz2' rubberband_1.8.2.orig.tar.bz2 182232 SHA256:86bed06b7115b64441d32ae53634fcc0539a50b9b648ef87443f936782f6c3ca
'http://archive.ubuntu.com/ubuntu/pool/universe/r/rubberband/rubberband_1.8.2-1build1.debian.tar.xz' rubberband_1.8.2-1build1.debian.tar.xz 9484 SHA256:d1c232d14fb6ceac8804d0de74e93b142d2e60b8c25949131f95ff5270885a41
```

### `dpkg` source package: `scowl=2018.04.16-1`

Binary Packages:

- `hunspell-en-us=1:2018.04.16-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris scowl=2018.04.16-1
'http://archive.ubuntu.com/ubuntu/pool/main/s/scowl/scowl_2018.04.16-1.dsc' scowl_2018.04.16-1.dsc 2935 SHA256:b2ad55853fbad895df408a380edfd23661195e0b5ce2fd47fd2db5a295c3192a
'http://archive.ubuntu.com/ubuntu/pool/main/s/scowl/scowl_2018.04.16.orig.tar.gz' scowl_2018.04.16.orig.tar.gz 2545797 SHA256:3a97d5a92a8705a35611ac21a61ed72ad9a19baa64168273deb5b8cca1cd9386
'http://archive.ubuntu.com/ubuntu/pool/main/s/scowl/scowl_2018.04.16-1.debian.tar.xz' scowl_2018.04.16-1.debian.tar.xz 16316 SHA256:2b8b879377cd470a242003abf138a2fc6a1b4e3e232bdd67ca507470d858d034
```

### `dpkg` source package: `sed=4.7-1`

Binary Packages:

- `sed=4.7-1`

Licenses: (parsed from: `/usr/share/doc/sed/copyright`)

- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris sed=4.7-1
'http://archive.ubuntu.com/ubuntu/pool/main/s/sed/sed_4.7-1.dsc' sed_4.7-1.dsc 1880 SHA256:dd0e8daed987929920f7729771f9c7a5b48d094923aaf686efd2ab19db776108
'http://archive.ubuntu.com/ubuntu/pool/main/s/sed/sed_4.7.orig.tar.xz' sed_4.7.orig.tar.xz 1298316 SHA256:2885768cd0a29ff8d58a6280a270ff161f6a3deb5690b2be6c49f46d4c67bd6a
'http://archive.ubuntu.com/ubuntu/pool/main/s/sed/sed_4.7-1.debian.tar.xz' sed_4.7-1.debian.tar.xz 59824 SHA256:a2ab8d50807fd2242f86d6c6257399e790445ab6f8932f7f487d34361b4fc483
```

### `dpkg` source package: `sensible-utils=0.0.12+nmu1`

Binary Packages:

- `sensible-utils=0.0.12+nmu1`

Licenses: (parsed from: `/usr/share/doc/sensible-utils/copyright`)

- `All-permissive`
- `GPL-2`
- `GPL-2+`
- `configure`
- `installsh`

Source:

```console
$ apt-get source -qq --print-uris sensible-utils=0.0.12+nmu1
'http://archive.ubuntu.com/ubuntu/pool/main/s/sensible-utils/sensible-utils_0.0.12%2bnmu1.dsc' sensible-utils_0.0.12+nmu1.dsc 1753 SHA256:68bcb3e542e29a8a0bf281d9145d0e4cd9def529af2ba0cfe0afee3c5af958bc
'http://archive.ubuntu.com/ubuntu/pool/main/s/sensible-utils/sensible-utils_0.0.12%2bnmu1.tar.xz' sensible-utils_0.0.12+nmu1.tar.xz 61988 SHA256:53c6606facf083adbbf0da04e6d774b31ff3f46c7ba36a82d3f182779f4c3f5b
```

### `dpkg` source package: `serd=0.30.2-1`

Binary Packages:

- `libserd-0-0:amd64=0.30.2-1`

Licenses: (parsed from: `/usr/share/doc/libserd-0-0/copyright`)

- `BSD-3-clause`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris serd=0.30.2-1
'http://archive.ubuntu.com/ubuntu/pool/universe/s/serd/serd_0.30.2-1.dsc' serd_0.30.2-1.dsc 2160 SHA256:389ecebd3ca416d9f16645a31d9d1e69ae7b7288b5dd132027fc9768f3dd85b1
'http://archive.ubuntu.com/ubuntu/pool/universe/s/serd/serd_0.30.2.orig.tar.bz2' serd_0.30.2.orig.tar.bz2 590337 SHA256:9d3102701172804f823f2215ca3147c50eba992641f9fbe014272355f4937202
'http://archive.ubuntu.com/ubuntu/pool/universe/s/serd/serd_0.30.2-1.debian.tar.xz' serd_0.30.2-1.debian.tar.xz 6440 SHA256:4382463bb2e194966868d16b6839e63dfe6c424fbe8edfdb246bf8c0afe14e6b
```

### `dpkg` source package: `servlet-api=4.0.1-2`

Binary Packages:

- `libservlet-api-java=4.0.1-2`
- `libservlet3.1-java=1:4.0.1-2`

Licenses: (parsed from: `/usr/share/doc/libservlet-api-java/copyright`, `/usr/share/doc/libservlet3.1-java/copyright`)

- `Apache-2.0`
- `CDDL-1.1`
- `GPL-2`
- `GPL-2 with Classpath exception`

Source:

```console
$ apt-get source -qq --print-uris servlet-api=4.0.1-2
'http://archive.ubuntu.com/ubuntu/pool/universe/s/servlet-api/servlet-api_4.0.1-2.dsc' servlet-api_4.0.1-2.dsc 2258 SHA256:9659543651f44d13bf137ac61f2ea4e6d33f21bed3deb0ad8bf6c9ab3e8837f8
'http://archive.ubuntu.com/ubuntu/pool/universe/s/servlet-api/servlet-api_4.0.1.orig.tar.xz' servlet-api_4.0.1.orig.tar.xz 94792 SHA256:26328ec380389cf60b9968ede81bab261409f6a2976635a826d3c39dbd8bacc4
'http://archive.ubuntu.com/ubuntu/pool/universe/s/servlet-api/servlet-api_4.0.1-2.debian.tar.xz' servlet-api_4.0.1-2.debian.tar.xz 10856 SHA256:5505b670fa2a3cba350b5cc98c2276948804e35a9d9edb15dbc0f786f595a9ef
```

### `dpkg` source package: `shadow=1:4.8.1-1ubuntu5.20.04.5`

Binary Packages:

- `login=1:4.8.1-1ubuntu5.20.04.5`
- `passwd=1:4.8.1-1ubuntu5.20.04.5`

Licenses: (parsed from: `/usr/share/doc/login/copyright`, `/usr/share/doc/passwd/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris shadow=1:4.8.1-1ubuntu5.20.04.5
'http://archive.ubuntu.com/ubuntu/pool/main/s/shadow/shadow_4.8.1-1ubuntu5.20.04.5.dsc' shadow_4.8.1-1ubuntu5.20.04.5.dsc 2081 SHA512:882dbe402de8ac195152445d0d1ff48a4eb925cb440d3c3d956739295527e81ec9c8631ad8dd09cfccb2b8054600698cfe49db718e9e8d725e0a57d99b9d75c6
'http://archive.ubuntu.com/ubuntu/pool/main/s/shadow/shadow_4.8.1.orig.tar.xz' shadow_4.8.1.orig.tar.xz 1611196 SHA512:780a983483d847ed3c91c82064a0fa902b6f4185225978241bc3bc03fcc3aa143975b46aee43151c6ba43efcfdb1819516b76ba7ad3d1d3c34fcc38ea42e917b
'http://archive.ubuntu.com/ubuntu/pool/main/s/shadow/shadow_4.8.1-1ubuntu5.20.04.5.debian.tar.xz' shadow_4.8.1-1ubuntu5.20.04.5.debian.tar.xz 88744 SHA512:b12978fe6b7f0de302a6070f245aba6abc97ee3cefe7ea4925c16d45547d850f4cfd7ab5e7eb7940176d7afe37d16feda3b3bd458a0151a3ffe6a330f0197db9
```

### `dpkg` source package: `shared-mime-info=1.15-1`

Binary Packages:

- `shared-mime-info=1.15-1`

Licenses: (parsed from: `/usr/share/doc/shared-mime-info/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris shared-mime-info=1.15-1
'http://archive.ubuntu.com/ubuntu/pool/main/s/shared-mime-info/shared-mime-info_1.15-1.dsc' shared-mime-info_1.15-1.dsc 2198 SHA256:dca6ea0156110b4a2694dd96a721d34ad4f42b51f3d3a20d0d711b77bde5115d
'http://archive.ubuntu.com/ubuntu/pool/main/s/shared-mime-info/shared-mime-info_1.15.orig.tar.xz' shared-mime-info_1.15.orig.tar.xz 772708 SHA256:f482b027437c99e53b81037a9843fccd549243fd52145d016e9c7174a4f5db90
'http://archive.ubuntu.com/ubuntu/pool/main/s/shared-mime-info/shared-mime-info_1.15-1.debian.tar.xz' shared-mime-info_1.15-1.debian.tar.xz 9728 SHA256:02c4fa8b2b3073c745287dd0e00c69c9f1ba028c7c6496105e3ecdcc02d9f1dd
```

### `dpkg` source package: `shine=3.1.1-2`

Binary Packages:

- `libshine3:amd64=3.1.1-2`

Licenses: (parsed from: `/usr/share/doc/libshine3/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2`

Source:

```console
$ apt-get source -qq --print-uris shine=3.1.1-2
'http://archive.ubuntu.com/ubuntu/pool/universe/s/shine/shine_3.1.1-2.dsc' shine_3.1.1-2.dsc 1999 SHA256:57792862005a2482a7c1ee94544dd30bdeeacbf8b4cad842ad741b65545e8a16
'http://archive.ubuntu.com/ubuntu/pool/universe/s/shine/shine_3.1.1.orig.tar.gz' shine_3.1.1.orig.tar.gz 940443 SHA256:565b87867d6f8e6616a236445d194e36f4daa9b4e7af823fcf5010af7610c49e
'http://archive.ubuntu.com/ubuntu/pool/universe/s/shine/shine_3.1.1-2.debian.tar.xz' shine_3.1.1-2.debian.tar.xz 3624 SHA256:a9f669c5af27f11c0cca98c736decc49b056ccfe32893f85a6064161f36b1b5b
```

### `dpkg` source package: `slang2=2.3.2-4`

Binary Packages:

- `libslang2:amd64=2.3.2-4`

Licenses: (parsed from: `/usr/share/doc/libslang2/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris slang2=2.3.2-4
'http://archive.ubuntu.com/ubuntu/pool/main/s/slang2/slang2_2.3.2-4.dsc' slang2_2.3.2-4.dsc 2294 SHA256:ea599dbb3a16618acdc2c11b7e7d140477478c9ebfd1d15f359daf623815eec9
'http://archive.ubuntu.com/ubuntu/pool/main/s/slang2/slang2_2.3.2.orig.tar.xz' slang2_2.3.2.orig.tar.xz 1309848 SHA256:18c99f4c5ad9710eb0fcd4c82f7c32427f94c9c93a5ba04a88318e521db2cadf
'http://archive.ubuntu.com/ubuntu/pool/main/s/slang2/slang2_2.3.2-4.debian.tar.xz' slang2_2.3.2-4.debian.tar.xz 22136 SHA256:6c9f670b8a0000e6960aff0a6c817acb9dea31ac7ae356e9d841626fede518e4
```

### `dpkg` source package: `snappy=1.1.8-1build1`

Binary Packages:

- `libsnappy1v5:amd64=1.1.8-1build1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris snappy=1.1.8-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/s/snappy/snappy_1.1.8-1build1.dsc' snappy_1.1.8-1build1.dsc 1845 SHA256:7fcb2d9b6b28da43d3db8e4f3b5907cdce080f3e05881bb8e55a3d0d07cd39fb
'http://archive.ubuntu.com/ubuntu/pool/main/s/snappy/snappy_1.1.8.orig.tar.gz' snappy_1.1.8.orig.tar.gz 1096137 SHA256:16b677f07832a612b0836178db7f374e414f94657c138e6993cbfc5dcc58651f
'http://archive.ubuntu.com/ubuntu/pool/main/s/snappy/snappy_1.1.8-1build1.debian.tar.xz' snappy_1.1.8-1build1.debian.tar.xz 5680 SHA256:715185588364cd9625bff4a0d3f508054ee04f88573e3adce55167ee6baf9fd2
```

### `dpkg` source package: `sndio=1.5.0-3`

Binary Packages:

- `libsndio7.0:amd64=1.5.0-3`

Licenses: (parsed from: `/usr/share/doc/libsndio7.0/copyright`)

- `ISC`
- `ISC-packaging`

Source:

```console
$ apt-get source -qq --print-uris sndio=1.5.0-3
'http://archive.ubuntu.com/ubuntu/pool/universe/s/sndio/sndio_1.5.0-3.dsc' sndio_1.5.0-3.dsc 1942 SHA256:e024ba6ddd4bcc81bf955689a55c454a8a031b729addaed6aa0bb05afc2ad3b1
'http://archive.ubuntu.com/ubuntu/pool/universe/s/sndio/sndio_1.5.0.orig.tar.gz' sndio_1.5.0.orig.tar.gz 125661 SHA256:12c70044749ad9cb7eaeb26c936816aa6b314fe4be71ef479d12272e4c5ad253
'http://archive.ubuntu.com/ubuntu/pool/universe/s/sndio/sndio_1.5.0-3.debian.tar.xz' sndio_1.5.0-3.debian.tar.xz 5780 SHA256:325417b7a391a106ede0d1f30cbc0e1bbbda56ef2713c7598a1436c1d92c7d03
```

### `dpkg` source package: `sord=0.16.4-1`

Binary Packages:

- `libsord-0-0:amd64=0.16.4-1`

Licenses: (parsed from: `/usr/share/doc/libsord-0-0/copyright`)

- `BSD-3-clause`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris sord=0.16.4-1
'http://archive.ubuntu.com/ubuntu/pool/universe/s/sord/sord_0.16.4-1.dsc' sord_0.16.4-1.dsc 2180 SHA256:17eeeb1e265fe490ccd1f35437424644ff6e55a315f97d56b1252bddb68fc532
'http://archive.ubuntu.com/ubuntu/pool/universe/s/sord/sord_0.16.4.orig.tar.bz2' sord_0.16.4.orig.tar.bz2 510920 SHA256:b15998f4e7ad958201346009477d6696e90ee5d3e9aff25e7e9be074372690d7
'http://archive.ubuntu.com/ubuntu/pool/universe/s/sord/sord_0.16.4-1.debian.tar.xz' sord_0.16.4-1.debian.tar.xz 5080 SHA256:0f9e5903950cd3010e8d0c3311a4c19413b49b43862f1264a57a4cd08e39d277
```

### `dpkg` source package: `sound-theme-freedesktop=0.8-2ubuntu1`

Binary Packages:

- `sound-theme-freedesktop=0.8-2ubuntu1`

Licenses: (parsed from: `/usr/share/doc/sound-theme-freedesktop/copyright`)

- `CC-BY-3.0`
- `CC-BY-SA-3.0`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris sound-theme-freedesktop=0.8-2ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/s/sound-theme-freedesktop/sound-theme-freedesktop_0.8-2ubuntu1.dsc' sound-theme-freedesktop_0.8-2ubuntu1.dsc 2335 SHA256:41ad1232719c5bb49c98c370c5386a4285ab130627a39a7405a12f1e97471474
'http://archive.ubuntu.com/ubuntu/pool/main/s/sound-theme-freedesktop/sound-theme-freedesktop_0.8.orig.tar.bz2' sound-theme-freedesktop_0.8.orig.tar.bz2 478237 SHA256:cb518b20eef05ec2e82dda1fa89a292c1760dc023aba91b8aa69bafac85e8a14
'http://archive.ubuntu.com/ubuntu/pool/main/s/sound-theme-freedesktop/sound-theme-freedesktop_0.8-2ubuntu1.debian.tar.xz' sound-theme-freedesktop_0.8-2ubuntu1.debian.tar.xz 10120 SHA256:74a5b6a722c7f48e70e7e36312adf5526c20337f914fcbf32282a387cf06f8b3
```

### `dpkg` source package: `speex=1.2~rc1.2-1.1ubuntu1.20.04.1`

Binary Packages:

- `libspeex1:amd64=1.2~rc1.2-1.1ubuntu1.20.04.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris speex=1.2~rc1.2-1.1ubuntu1.20.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/s/speex/speex_1.2%7erc1.2-1.1ubuntu1.20.04.1.dsc' speex_1.2~rc1.2-1.1ubuntu1.20.04.1.dsc 2355 SHA512:137d7a4f9135403d0de24d3c687299f1acd60febf1d49ab342f6de60d8ede29d5ecf2842c3dbc71c429c6863cfab5a5e7659c4007534da5beb555cb10c25982d
'http://archive.ubuntu.com/ubuntu/pool/main/s/speex/speex_1.2%7erc1.2.orig.tar.gz' speex_1.2~rc1.2.orig.tar.gz 1069339 SHA512:b523803dd2c024c20f992e8410421719c53981df3ff1c1d96bc030baddaf4729ee6a5172b8501f4c9a3194e4dafab8b79814d90624e8226bf869605505cc0bce
'http://archive.ubuntu.com/ubuntu/pool/main/s/speex/speex_1.2%7erc1.2-1.1ubuntu1.20.04.1.diff.gz' speex_1.2~rc1.2-1.1ubuntu1.20.04.1.diff.gz 10743 SHA512:1d1c91ae387186538dde92a21a65ac4b429039b24c5dae9cedfbae42cc631919e6416b6100d116e142beea89eb56559afa551f76f0a32c82bc8193e03033360c
```

### `dpkg` source package: `sqlite3=3.31.1-4ubuntu0.6`

Binary Packages:

- `libsqlite3-0:amd64=3.31.1-4ubuntu0.6`

Licenses: (parsed from: `/usr/share/doc/libsqlite3-0/copyright`)

- `GPL-2`
- `GPL-2+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris sqlite3=3.31.1-4ubuntu0.6
'http://archive.ubuntu.com/ubuntu/pool/main/s/sqlite3/sqlite3_3.31.1-4ubuntu0.6.dsc' sqlite3_3.31.1-4ubuntu0.6.dsc 2519 SHA512:caa3e8fd9404fccdcedbf61702f7247c4699ef04c5cba205410639bd73de9afebab79ed40b0c5ca4e2302d6bd184441fc3faf02d46d10ab6508ea495c24addf8
'http://archive.ubuntu.com/ubuntu/pool/main/s/sqlite3/sqlite3_3.31.1.orig-www.tar.xz' sqlite3_3.31.1.orig-www.tar.xz 5764424 SHA512:a47adacd46c673cfd674cb64fb54b054e69560aed8c8c429773f0eccdcdbce4be538397506eca8e2d169f4b46d0d47442b273e12d82f8c87e1aadf3ade458db6
'http://archive.ubuntu.com/ubuntu/pool/main/s/sqlite3/sqlite3_3.31.1.orig.tar.xz' sqlite3_3.31.1.orig.tar.xz 7108036 SHA512:67e1050efe2988fa3d0d7e4a87e147a8114c6ff9b6ca5307a068befb38e861930eaee0135048ff1abb1e6323b507cbc68a0aac3a8fe5f095d6fcea1547a7efaf
'http://archive.ubuntu.com/ubuntu/pool/main/s/sqlite3/sqlite3_3.31.1-4ubuntu0.6.debian.tar.xz' sqlite3_3.31.1-4ubuntu0.6.debian.tar.xz 36192 SHA512:12d6a58cbff3ceacfc5c51824f264993bbd9d50116d76c11a9b8ecc7ce417403174f637d8af34bdfe46e1f2555eca19d5da3c4875fb332b1aa268ca9fb81c238
```

### `dpkg` source package: `sratom=0.6.4-1`

Binary Packages:

- `libsratom-0-0:amd64=0.6.4-1`

Licenses: (parsed from: `/usr/share/doc/libsratom-0-0/copyright`)

- `BSD-3-clause`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris sratom=0.6.4-1
'http://archive.ubuntu.com/ubuntu/pool/universe/s/sratom/sratom_0.6.4-1.dsc' sratom_0.6.4-1.dsc 2211 SHA256:62a58eec187f9878db7da6b9da7ec2ed2dcb29b34f8f983c415637c82416bd64
'http://archive.ubuntu.com/ubuntu/pool/universe/s/sratom/sratom_0.6.4.orig.tar.bz2' sratom_0.6.4.orig.tar.bz2 339707 SHA256:146c8f14b8902ac3c8fa8c2e0a014eb8a38fab60090c5adbfbff3e3b7c5c006e
'http://archive.ubuntu.com/ubuntu/pool/universe/s/sratom/sratom_0.6.4-1.debian.tar.xz' sratom_0.6.4-1.debian.tar.xz 4420 SHA256:7c2aa9b8abc9ceb6343f86143526e6e405dc198f64e11a8196cdbbadc42833f7
```

### `dpkg` source package: `suitesparse=1:5.7.1+dfsg-2`

Binary Packages:

- `libcolamd2:amd64=1:5.7.1+dfsg-2`
- `libsuitesparseconfig5:amd64=1:5.7.1+dfsg-2`

Licenses: (parsed from: `/usr/share/doc/libcolamd2/copyright`, `/usr/share/doc/libsuitesparseconfig5/copyright`)

- `Apache-2.0`
- `BSD-2-clause`
- `BSD-2-clause-lagraph`
- `BSD-3-clause`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `permissive`
- `permissive-2`

Source:

```console
$ apt-get source -qq --print-uris suitesparse=1:5.7.1+dfsg-2
'http://archive.ubuntu.com/ubuntu/pool/main/s/suitesparse/suitesparse_5.7.1%2bdfsg-2.dsc' suitesparse_5.7.1+dfsg-2.dsc 3094 SHA256:4da625fc62ec35bfe9a91c62ff8d508407ebe69364e15c8819508d32ea4d8110
'http://archive.ubuntu.com/ubuntu/pool/main/s/suitesparse/suitesparse_5.7.1%2bdfsg.orig.tar.xz' suitesparse_5.7.1+dfsg.orig.tar.xz 36676832 SHA256:47edbe6d1ed2ed00a0d08ecdbad0a57712d87efd3968c7d362cdf475ad597af7
'http://archive.ubuntu.com/ubuntu/pool/main/s/suitesparse/suitesparse_5.7.1%2bdfsg-2.debian.tar.xz' suitesparse_5.7.1+dfsg-2.debian.tar.xz 42744 SHA256:c8c1681fa3a2518795c31f482ebd15160d33f0f9edff81558a09f84c701516f9
```

### `dpkg` source package: `systemd=245.4-4ubuntu3.24`

Binary Packages:

- `libnss-systemd:amd64=245.4-4ubuntu3.24`
- `libpam-systemd:amd64=245.4-4ubuntu3.24`
- `libsystemd0:amd64=245.4-4ubuntu3.24`
- `libudev1:amd64=245.4-4ubuntu3.24`
- `systemd=245.4-4ubuntu3.24`
- `systemd-sysv=245.4-4ubuntu3.24`
- `systemd-timesyncd=245.4-4ubuntu3.24`

Licenses: (parsed from: `/usr/share/doc/libnss-systemd/copyright`, `/usr/share/doc/libpam-systemd/copyright`, `/usr/share/doc/libsystemd0/copyright`, `/usr/share/doc/libudev1/copyright`, `/usr/share/doc/systemd/copyright`, `/usr/share/doc/systemd-sysv/copyright`, `/usr/share/doc/systemd-timesyncd/copyright`)

- `CC0-1.0`
- `Expat`
- `GPL-2`
- `GPL-2 with Linux-syscall-note exception`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris systemd=245.4-4ubuntu3.24
'http://archive.ubuntu.com/ubuntu/pool/main/s/systemd/systemd_245.4-4ubuntu3.24.dsc' systemd_245.4-4ubuntu3.24.dsc 5262 SHA512:a7368dff1d7ce06bde4459dd635d2f25d9085f7c2cb0a5c3cbc30f63d24bea8145ff22c29709e67414b5ebd63fdd834b9552644b4adfbeb2b03c4db7a19e6ffe
'http://archive.ubuntu.com/ubuntu/pool/main/s/systemd/systemd_245.4.orig.tar.gz' systemd_245.4.orig.tar.gz 9000780 SHA512:02036bb1ab05301a9d0dfdd4b9c9376e90134474482531e6e292122380be2f24f99177493dd3af6f8af1a8ed2599ee0996da91a3b1b7872bbfaf26a1c3e61b4c
'http://archive.ubuntu.com/ubuntu/pool/main/s/systemd/systemd_245.4-4ubuntu3.24.debian.tar.xz' systemd_245.4-4ubuntu3.24.debian.tar.xz 294744 SHA512:97dd99ebc167edaa5d32157039a9af54c1747a43ef7625f67a697c971f5755e6038e496d04cce45d77055894b7d84d5bfb86c47a037e911c41a297ddb092dec8
```

### `dpkg` source package: `sysvinit=2.96-2.1ubuntu1`

Binary Packages:

- `sysvinit-utils=2.96-2.1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/sysvinit-utils/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris sysvinit=2.96-2.1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/s/sysvinit/sysvinit_2.96-2.1ubuntu1.dsc' sysvinit_2.96-2.1ubuntu1.dsc 2751 SHA256:c8b5f2ef86c4c1b8bf6b8a48408a4aa0815b0cf416df51dc0a9b6b8134f7e42c
'http://archive.ubuntu.com/ubuntu/pool/main/s/sysvinit/sysvinit_2.96.orig.tar.xz' sysvinit_2.96.orig.tar.xz 122164 SHA256:2a2e26b72aa235a23ab1c8471005f890309ce1196c83fbc9413c57b9ab62b587
'http://archive.ubuntu.com/ubuntu/pool/main/s/sysvinit/sysvinit_2.96.orig.tar.xz.asc' sysvinit_2.96.orig.tar.xz.asc 313 SHA256:dfc184b95da12c8c888c8ae6b0f26fe8a23b07fbcdd240f6600a8a78b9439fa0
'http://archive.ubuntu.com/ubuntu/pool/main/s/sysvinit/sysvinit_2.96-2.1ubuntu1.debian.tar.xz' sysvinit_2.96-2.1ubuntu1.debian.tar.xz 128840 SHA256:528041e261c90a957d9794bddb07217c89484d9c76a0279da508baec9684c4e6
```

### `dpkg` source package: `tar=1.30+dfsg-7ubuntu0.20.04.4`

Binary Packages:

- `tar=1.30+dfsg-7ubuntu0.20.04.4`

Licenses: (parsed from: `/usr/share/doc/tar/copyright`)

- `GPL-2`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris tar=1.30+dfsg-7ubuntu0.20.04.4
'http://archive.ubuntu.com/ubuntu/pool/main/t/tar/tar_1.30%2bdfsg-7ubuntu0.20.04.4.dsc' tar_1.30+dfsg-7ubuntu0.20.04.4.dsc 1812 SHA512:a771e996dad6c7b2d75336bae73a0c9e52f030a7474bdebe519a9c072819530541ff3200046ddc5277b0204e1eac056ff3679062c182cb28404bdac73da768fa
'http://archive.ubuntu.com/ubuntu/pool/main/t/tar/tar_1.30%2bdfsg.orig.tar.xz' tar_1.30+dfsg.orig.tar.xz 1883220 SHA512:f9b3843bd4da03f58d6f88de70ecb36b8ac29312714fd2120ff00f17c99e6d77cc82a8f9de348f4c2bdba9a6cc8e8c6c78039b6c14cdee15d68f2517000c36f2
'http://archive.ubuntu.com/ubuntu/pool/main/t/tar/tar_1.30%2bdfsg-7ubuntu0.20.04.4.debian.tar.xz' tar_1.30+dfsg-7ubuntu0.20.04.4.debian.tar.xz 24572 SHA512:942a7fb6e2edb7e50b26b1588219d0a99caf17ff1dfa1748449c3fa84ab8cf3e3e94bafb8334cc3b8397562d6a3ecd57bc0df2ddb2b90644a361fa63426d2982
```

### `dpkg` source package: `tcp-wrappers=7.6.q-30`

Binary Packages:

- `libwrap0:amd64=7.6.q-30`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris tcp-wrappers=7.6.q-30
'http://archive.ubuntu.com/ubuntu/pool/main/t/tcp-wrappers/tcp-wrappers_7.6.q-30.dsc' tcp-wrappers_7.6.q-30.dsc 1900 SHA256:b3096434ab68ae8a48cc78a1553e461867c8c29840053554b64fcce0e83c82e2
'http://archive.ubuntu.com/ubuntu/pool/main/t/tcp-wrappers/tcp-wrappers_7.6.q.orig.tar.gz' tcp-wrappers_7.6.q.orig.tar.gz 99438 SHA256:9543d7adedf78a6de0b221ccbbd1952e08b5138717f4ade814039bb489a4315d
'http://archive.ubuntu.com/ubuntu/pool/main/t/tcp-wrappers/tcp-wrappers_7.6.q-30.debian.tar.xz' tcp-wrappers_7.6.q-30.debian.tar.xz 36204 SHA256:71661be900202a909144ba1f49f7dceb83a619b88a11aca3b9d867934c0dbb36
```

### `dpkg` source package: `tdb=1.4.5-0ubuntu0.20.04.1`

Binary Packages:

- `libtdb1:amd64=1.4.5-0ubuntu0.20.04.1`

Licenses: (parsed from: `/usr/share/doc/libtdb1/copyright`)

- `BSD-3`
- `GPL-3`
- `GPL-3.0+`
- `ISC`
- `LGPL-3`
- `LGPL-3.0+`
- `PostgreSQL`

Source:

```console
$ apt-get source -qq --print-uris tdb=1.4.5-0ubuntu0.20.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/t/tdb/tdb_1.4.5-0ubuntu0.20.04.1.dsc' tdb_1.4.5-0ubuntu0.20.04.1.dsc 2300 SHA512:d6544fb0444d1d1b4c8a42513cb7a70599e9d9eaf396c08094ed049f72ce7eefa46a1b4ea1e8414a7b4a3b6f1fd3fc41dcd15d193c3d8e2ad79711ae2db83244
'http://archive.ubuntu.com/ubuntu/pool/main/t/tdb/tdb_1.4.5.orig.tar.gz' tdb_1.4.5.orig.tar.gz 729650 SHA512:373b2ce5b2c68fbc28b7679f0e7531115b91ddc6a68b27acada39b995f66b508b19f24d712fc4388654199abd69857e53ebd435d1ed47e3a69ba85ff667fed56
'http://archive.ubuntu.com/ubuntu/pool/main/t/tdb/tdb_1.4.5-0ubuntu0.20.04.1.debian.tar.xz' tdb_1.4.5-0ubuntu0.20.04.1.debian.tar.xz 18104 SHA512:6ec44e6984293bcc6c30b728495c9c0e28477816e0156aa028aef5acf7eedc6a0e6f35c6ab7898ca68e4efe0e8709fa3b737c94f9bd5c980df29a84f322cfd06
```

### `dpkg` source package: `tiff=4.1.0+git191117-2ubuntu0.20.04.14`

Binary Packages:

- `libtiff5:amd64=4.1.0+git191117-2ubuntu0.20.04.14`

Licenses: (parsed from: `/usr/share/doc/libtiff5/copyright`)

- `Hylafax`

Source:

```console
$ apt-get source -qq --print-uris tiff=4.1.0+git191117-2ubuntu0.20.04.14
'http://archive.ubuntu.com/ubuntu/pool/main/t/tiff/tiff_4.1.0%2bgit191117-2ubuntu0.20.04.14.dsc' tiff_4.1.0+git191117-2ubuntu0.20.04.14.dsc 2251 SHA512:c6d2d754172a3a27555e5a3014428a19659e201eee6053708e8f3326948ffd747d31fa8856b7b11e52c37f743689ea9fcad0788e6cfc146e74bff1dcbe46a2bb
'http://archive.ubuntu.com/ubuntu/pool/main/t/tiff/tiff_4.1.0%2bgit191117.orig.tar.xz' tiff_4.1.0+git191117.orig.tar.xz 1533524 SHA512:25b4bc4522fc2e7f3ca6857b87acd4481d8643566b1120c755020afc8b48949238ee2078bc43dd3ba7407eaa4e36b1b712d7056f101ddaf60f94dab8607870b8
'http://archive.ubuntu.com/ubuntu/pool/main/t/tiff/tiff_4.1.0%2bgit191117-2ubuntu0.20.04.14.debian.tar.xz' tiff_4.1.0+git191117-2ubuntu0.20.04.14.debian.tar.xz 53440 SHA512:94dff2dcc41465107620975a9117611f86664118c8cd911898425726ccba5905c0d74c919c9c19724b321dca5f178ca65ddc6585c5b2b87a59567f8ef4fc2e76
```

### `dpkg` source package: `twolame=0.4.0-2`

Binary Packages:

- `libtwolame0:amd64=0.4.0-2`

Licenses: (parsed from: `/usr/share/doc/libtwolame0/copyright`)

- `LGPL-2`
- `LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris twolame=0.4.0-2
'http://archive.ubuntu.com/ubuntu/pool/main/t/twolame/twolame_0.4.0-2.dsc' twolame_0.4.0-2.dsc 2048 SHA256:b5e662bbb076be28d1de5004ba6325b2df340eb7812d5071ba9d7f5d64faf7cc
'http://archive.ubuntu.com/ubuntu/pool/main/t/twolame/twolame_0.4.0.orig.tar.gz' twolame_0.4.0.orig.tar.gz 890908 SHA256:cc35424f6019a88c6f52570b63e1baf50f62963a3eac52a03a800bb070d7c87d
'http://archive.ubuntu.com/ubuntu/pool/main/t/twolame/twolame_0.4.0-2.debian.tar.xz' twolame_0.4.0-2.debian.tar.xz 4740 SHA256:c11737831db6c13b0346b5d23d39ab40235ad09373d57356dd8b23263499d67a
```

### `dpkg` source package: `tzdata=2024a-0ubuntu0.20.04.1`

Binary Packages:

- `tzdata=2024a-0ubuntu0.20.04.1`

Licenses: (parsed from: `/usr/share/doc/tzdata/copyright`)

- `ICU`

Source:

```console
$ apt-get source -qq --print-uris tzdata=2024a-0ubuntu0.20.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/t/tzdata/tzdata_2024a-0ubuntu0.20.04.1.dsc' tzdata_2024a-0ubuntu0.20.04.1.dsc 2556 SHA512:9f71acf380cf4076da623666f5fd75a346a7ebc5c2cfe367dde2eb98454c8b8d14056bcbcd29d64ab3f51168f76243fc305cf55202a93ba791cdb1cf40802343
'http://archive.ubuntu.com/ubuntu/pool/main/t/tzdata/tzdata_2024a.orig.tar.gz' tzdata_2024a.orig.tar.gz 451270 SHA512:1f09f1b2327cc9e1afc7e9045e83ee3377918dafe1bee2f282b6991828d03b3c70a4d3a17f9207dfb1361bb25bc214a8922a756e84fa114e9ba476226db57236
'http://archive.ubuntu.com/ubuntu/pool/main/t/tzdata/tzdata_2024a.orig.tar.gz.asc' tzdata_2024a.orig.tar.gz.asc 833 SHA512:a06ddc95002f2dcd3c071d020a74bc98aae2cbf56a502718f9bc08e90e0075b17aaaa653ceecd49a1133cdadfc43134365043f827b19c7dad68050dbda6ba77e
'http://archive.ubuntu.com/ubuntu/pool/main/t/tzdata/tzdata_2024a-0ubuntu0.20.04.1.debian.tar.xz' tzdata_2024a-0ubuntu0.20.04.1.debian.tar.xz 174204 SHA512:9a999fc4e28c0f18b2f095876b17316c7f8f2ce23eb83f6f0d0c082270075ec7184a0e5c217576eac14ef49251a5e3536490777175b70146fab72a4b30a25aa8
```

### `dpkg` source package: `ubuntu-keyring=2020.02.11.4`

Binary Packages:

- `ubuntu-keyring=2020.02.11.4`

Licenses: (parsed from: `/usr/share/doc/ubuntu-keyring/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris ubuntu-keyring=2020.02.11.4
'http://archive.ubuntu.com/ubuntu/pool/main/u/ubuntu-keyring/ubuntu-keyring_2020.02.11.4.dsc' ubuntu-keyring_2020.02.11.4.dsc 1863 SHA512:1232fc109f9afe7f4245f841cb992aeb7329ec1c3d310a174b837c0584005a7c46ce73f6d49a52a3e6c0eea03369ea5f308093c1a849e8f6597f6df792a87fb1
'http://archive.ubuntu.com/ubuntu/pool/main/u/ubuntu-keyring/ubuntu-keyring_2020.02.11.4.tar.gz' ubuntu-keyring_2020.02.11.4.tar.gz 39250 SHA512:318562b6892dad995e334ec44f08f065b4c6abed2d29c1f96f6ee0fa4d91a5cedc9b62a152c56cdf26a30c3ea97a58c1d037e892d155af5593a4e26b9a25a1ae
```

### `dpkg` source package: `ubuntu-themes=19.04-0ubuntu3`

Binary Packages:

- `ubuntu-mono=19.04-0ubuntu3`

Licenses: (parsed from: `/usr/share/doc/ubuntu-mono/copyright`)

- `CC-BY-SA-3.0`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris ubuntu-themes=19.04-0ubuntu3
'http://archive.ubuntu.com/ubuntu/pool/main/u/ubuntu-themes/ubuntu-themes_19.04-0ubuntu3.dsc' ubuntu-themes_19.04-0ubuntu3.dsc 1601 SHA256:9a1c1911b35fba5beaa6f248e89fc37f32dd84b11ed27c25d94a3f0b34abfcad
'http://archive.ubuntu.com/ubuntu/pool/main/u/ubuntu-themes/ubuntu-themes_19.04.orig.tar.gz' ubuntu-themes_19.04.orig.tar.gz 16081764 SHA256:30be3e9fd04371ebb3d89f1731afad151f06f424ae122fa805483681636dc2b7
'http://archive.ubuntu.com/ubuntu/pool/main/u/ubuntu-themes/ubuntu-themes_19.04-0ubuntu3.diff.gz' ubuntu-themes_19.04-0ubuntu3.diff.gz 29445 SHA256:1e878b82db0d2d1e1269c6e071e0549ee7f69bbc7c8d61302b3a2984893ae9fa
```

### `dpkg` source package: `ucf=3.0038+nmu1`

Binary Packages:

- `ucf=3.0038+nmu1`

Licenses: (parsed from: `/usr/share/doc/ucf/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris ucf=3.0038+nmu1
'http://archive.ubuntu.com/ubuntu/pool/main/u/ucf/ucf_3.0038%2bnmu1.dsc' ucf_3.0038+nmu1.dsc 1420 SHA256:89b6f921a30e04a946f62e6996be7c16f2f7c383d20783cd4704b502c6d5b125
'http://archive.ubuntu.com/ubuntu/pool/main/u/ucf/ucf_3.0038%2bnmu1.tar.xz' ucf_3.0038+nmu1.tar.xz 65860 SHA256:d00bc3dd8d2f91317f52b5352fe129023c72babad55bc0dd4ece7b34183c7436
```

### `dpkg` source package: `unzip=6.0-25ubuntu1.2`

Binary Packages:

- `unzip=6.0-25ubuntu1.2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris unzip=6.0-25ubuntu1.2
'http://archive.ubuntu.com/ubuntu/pool/main/u/unzip/unzip_6.0-25ubuntu1.2.dsc' unzip_6.0-25ubuntu1.2.dsc 1804 SHA512:d1af9e6e9b12e61b3868a3a88dd70a768f7731482dbe42e58c0e2df7ac273d61da10a7d1709bbe3b26af5029c7182b6e2a853f8e35e1fcf8e0275e2b0bd952eb
'http://archive.ubuntu.com/ubuntu/pool/main/u/unzip/unzip_6.0.orig.tar.gz' unzip_6.0.orig.tar.gz 1376845 SHA512:0694e403ebc57b37218e00ec1a406cae5cc9c5b52b6798e0d4590840b6cdbf9ddc0d9471f67af783e960f8fa2e620394d51384257dca23d06bcd90224a80ce5d
'http://archive.ubuntu.com/ubuntu/pool/main/u/unzip/unzip_6.0-25ubuntu1.2.debian.tar.xz' unzip_6.0-25ubuntu1.2.debian.tar.xz 27880 SHA512:17d1a82338b688c0364786bfa2edb26a6243cb278f65b4b34a6bda997f4b9aa204bdeb1c7b7eb6f7a183859ab30182f4f21eacdd6b089c19c9aee6b99419495c
```

### `dpkg` source package: `util-linux=2.34-0.1ubuntu9.6`

Binary Packages:

- `bsdutils=1:2.34-0.1ubuntu9.6`
- `fdisk=2.34-0.1ubuntu9.6`
- `libblkid1:amd64=2.34-0.1ubuntu9.6`
- `libfdisk1:amd64=2.34-0.1ubuntu9.6`
- `libmount1:amd64=2.34-0.1ubuntu9.6`
- `libsmartcols1:amd64=2.34-0.1ubuntu9.6`
- `libuuid1:amd64=2.34-0.1ubuntu9.6`
- `mount=2.34-0.1ubuntu9.6`
- `util-linux=2.34-0.1ubuntu9.6`

Licenses: (parsed from: `/usr/share/doc/bsdutils/copyright`, `/usr/share/doc/fdisk/copyright`, `/usr/share/doc/libblkid1/copyright`, `/usr/share/doc/libfdisk1/copyright`, `/usr/share/doc/libmount1/copyright`, `/usr/share/doc/libsmartcols1/copyright`, `/usr/share/doc/libuuid1/copyright`, `/usr/share/doc/mount/copyright`, `/usr/share/doc/util-linux/copyright`)

- `BSD-2-clause`
- `BSD-3-clause`
- `BSD-4-clause`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `LGPL`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `LGPL-3`
- `LGPL-3+`
- `MIT`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris util-linux=2.34-0.1ubuntu9.6
'http://archive.ubuntu.com/ubuntu/pool/main/u/util-linux/util-linux_2.34-0.1ubuntu9.6.dsc' util-linux_2.34-0.1ubuntu9.6.dsc 4045 SHA512:5576ac13d0333300fc8224d775ce446030facfaf39201bd8ea55f2ebd74375e8e53be6cfd93b997cd1f99d026ade4e2dfba4bb504efada60fbb901b2ca0868bd
'http://archive.ubuntu.com/ubuntu/pool/main/u/util-linux/util-linux_2.34.orig.tar.xz' util-linux_2.34.orig.tar.xz 4974812 SHA512:2d0b76f63d32e7afb7acf61a83fabbfd58baa34ab78b3a331ce87f9c676a5fd71c56a493ded95039540d2c46b6048caaa38d7fb4491eb3d52d7b09dc54655cd7
'http://archive.ubuntu.com/ubuntu/pool/main/u/util-linux/util-linux_2.34-0.1ubuntu9.6.debian.tar.xz' util-linux_2.34-0.1ubuntu9.6.debian.tar.xz 102952 SHA512:94a75311c3aa74a62d76c372b8d15285c6e574f65d8de668d430a658f6ebc1d171683a40d855140e62901776b8de306a88790396a4c8ac8bfb81128f0ef2d198
```

### `dpkg` source package: `vim=2:8.1.2269-1ubuntu5.25`

Binary Packages:

- `vim=2:8.1.2269-1ubuntu5.25`
- `vim-common=2:8.1.2269-1ubuntu5.25`
- `vim-runtime=2:8.1.2269-1ubuntu5.25`
- `xxd=2:8.1.2269-1ubuntu5.25`

Licenses: (parsed from: `/usr/share/doc/vim/copyright`, `/usr/share/doc/vim-common/copyright`, `/usr/share/doc/vim-runtime/copyright`, `/usr/share/doc/xxd/copyright`)

- `Apache`
- `Apache-2.0`
- `Artistic`
- `Artistic-1`
- `BSD-2-clause`
- `BSD-3-clause`
- `Compaq`
- `EDL-1`
- `Expat`
- `GPL-1`
- `GPL-1+`
- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `OPL-1+`
- `SRA`
- `UC`
- `Vim`
- `Vim-Regexp`
- `X11`
- `XPM`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris vim=2:8.1.2269-1ubuntu5.25
'http://archive.ubuntu.com/ubuntu/pool/main/v/vim/vim_8.1.2269-1ubuntu5.25.dsc' vim_8.1.2269-1ubuntu5.25.dsc 2298 SHA512:c1c47c500d818acc8565b389b56bb022130c343c822fe821aba93c22d1fe4fc8ddf69079419fde7340529e66cc44c18de9b5ced8c5fda1c4da68bff214be9b84
'http://archive.ubuntu.com/ubuntu/pool/main/v/vim/vim_8.1.2269.orig.tar.gz' vim_8.1.2269.orig.tar.gz 14590233 SHA512:5194817a5665e08816e87e3b10219e19510ca87c5c377ddc0a50aa84ffd4d7391badad3e993f83802d6da5e9da8834635c1acbdd4a909e75b4947f99f13c1746
'http://archive.ubuntu.com/ubuntu/pool/main/v/vim/vim_8.1.2269-1ubuntu5.25.debian.tar.xz' vim_8.1.2269-1ubuntu5.25.debian.tar.xz 266184 SHA512:b781b868ec2bbb4066e774bd97825a49edf01cff78fc11ba00d74ae617b4b7cd4677b30634b027cf89b6fe042b5813f5ba22797a29450ccc86c04d21d799620b
```

### `dpkg` source package: `vulkan-loader=1.2.131.2-1`

Binary Packages:

- `libvulkan1:amd64=1.2.131.2-1`

Licenses: (parsed from: `/usr/share/doc/libvulkan1/copyright`)

- `Apache-2.0`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris vulkan-loader=1.2.131.2-1
'http://archive.ubuntu.com/ubuntu/pool/main/v/vulkan-loader/vulkan-loader_1.2.131.2-1.dsc' vulkan-loader_1.2.131.2-1.dsc 2181 SHA256:fce11e5d9ce1df38cfca46ac461b22f1c97a9429b51732b4a7957b810a91f765
'http://archive.ubuntu.com/ubuntu/pool/main/v/vulkan-loader/vulkan-loader_1.2.131.2.orig.tar.xz' vulkan-loader_1.2.131.2.orig.tar.xz 1733244 SHA256:942893eeb963a49cec5aad17fcbdee685f18b5a7ab50544e665c77607fd7d7e7
'http://archive.ubuntu.com/ubuntu/pool/main/v/vulkan-loader/vulkan-loader_1.2.131.2-1.debian.tar.xz' vulkan-loader_1.2.131.2-1.debian.tar.xz 5888 SHA256:e95414f98551a1ae58707bfcea7bf11c30009d3d58649dd32a556c02e759d221
```

### `dpkg` source package: `wavpack=5.2.0-1ubuntu0.1`

Binary Packages:

- `libwavpack1:amd64=5.2.0-1ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libwavpack1/copyright`)

- `BSD-2-clause`
- `BSD-3-clause`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris wavpack=5.2.0-1ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/w/wavpack/wavpack_5.2.0-1ubuntu0.1.dsc' wavpack_5.2.0-1ubuntu0.1.dsc 2174 SHA512:006e5de760ccd12e29423b9a3cd5d3b1e4b0020e9b9a21acd5daa67f38f00363e5408d0c1cdf2b4dcef76090175d7bfb622eb4de979b9a95301b3fa51179d81f
'http://archive.ubuntu.com/ubuntu/pool/main/w/wavpack/wavpack_5.2.0.orig.tar.bz2' wavpack_5.2.0.orig.tar.bz2 849348 SHA512:456da78fb5d01b33a8ed71b43cb6809a25ca0d54e53858b93bbb3eb26923bfa6de4c6a3c01caca947c0852aea74d1b14667205dae344148a01619e67eb2c7e71
'http://archive.ubuntu.com/ubuntu/pool/main/w/wavpack/wavpack_5.2.0-1ubuntu0.1.debian.tar.xz' wavpack_5.2.0-1ubuntu0.1.debian.tar.xz 7076 SHA512:9e0ae292c78f9697eac6217f613c7f0cf89ed7b6305683f0be0573e42c35e5582686bd35e2637d73a07ead3c68473cfa0082ef1ef1a905bdfaebf808c83a6280
```

### `dpkg` source package: `wayland=1.18.0-1ubuntu0.1`

Binary Packages:

- `libwayland-client0:amd64=1.18.0-1ubuntu0.1`
- `libwayland-cursor0:amd64=1.18.0-1ubuntu0.1`
- `libwayland-egl1:amd64=1.18.0-1ubuntu0.1`
- `libwayland-server0:amd64=1.18.0-1ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libwayland-client0/copyright`, `/usr/share/doc/libwayland-cursor0/copyright`, `/usr/share/doc/libwayland-egl1/copyright`, `/usr/share/doc/libwayland-server0/copyright`)

- `X11`

Source:

```console
$ apt-get source -qq --print-uris wayland=1.18.0-1ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/w/wayland/wayland_1.18.0-1ubuntu0.1.dsc' wayland_1.18.0-1ubuntu0.1.dsc 2680 SHA512:1487bb25e04324a952064d06460f319d206a0dfc9d87a483b7a91cb964ee6c89b3d026d9682b8a2af7c15f0ec58bb0d431fcd15ed27c346b199c07a89ca2d6bf
'http://archive.ubuntu.com/ubuntu/pool/main/w/wayland/wayland_1.18.0.orig.tar.gz' wayland_1.18.0.orig.tar.gz 736301 SHA512:365b7065d71ee6f30dea3a68cafadf95f13480e80424481fec6027d041a9d20e1c645ee7c114500bb0767c2a79b8cabd9fd51c3f54ebca7fe577b9c8b98c08be
'http://archive.ubuntu.com/ubuntu/pool/main/w/wayland/wayland_1.18.0-1ubuntu0.1.diff.gz' wayland_1.18.0-1ubuntu0.1.diff.gz 17774 SHA512:66abab279133ab9d7d669025b497b9261056ee5380d9d8c40334d822dd416076fcdb2a400b83f800f7f2fa0caf91981d2a71c8aa26e6c7c3973e13125727bd01
```

### `dpkg` source package: `websocket-api=1.1-1`

Binary Packages:

- `libwebsocket-api-java=1.1-1`

Licenses: (parsed from: `/usr/share/doc/libwebsocket-api-java/copyright`)

- `Apache-2.0`
- `CDDL-1.1`
- `GPL-2`
- `GPL-2 with Classpath exception`

Source:

```console
$ apt-get source -qq --print-uris websocket-api=1.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/w/websocket-api/websocket-api_1.1-1.dsc' websocket-api_1.1-1.dsc 2026 SHA256:f39064f78befb06483c8134a989dc83dc986cf2baef77eae1cc85b12e83d8096
'http://archive.ubuntu.com/ubuntu/pool/universe/w/websocket-api/websocket-api_1.1.orig.tar.xz' websocket-api_1.1.orig.tar.xz 28884 SHA256:53c0c1eff9d4bda5abb28ac47f874407c019e546e40c061541b4b4a096e9fa7b
'http://archive.ubuntu.com/ubuntu/pool/universe/w/websocket-api/websocket-api_1.1-1.debian.tar.xz' websocket-api_1.1-1.debian.tar.xz 8436 SHA256:c6d79e97ed8f2d6836dcbd2bc30777a12d3ab4f5bdd95cc4a37fb6d77ec35653
```

### `dpkg` source package: `wget=1.20.3-1ubuntu2.1`

Binary Packages:

- `wget=1.20.3-1ubuntu2.1`

Licenses: (parsed from: `/usr/share/doc/wget/copyright`)

- `GFDL-1.2`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris wget=1.20.3-1ubuntu2.1
'http://archive.ubuntu.com/ubuntu/pool/main/w/wget/wget_1.20.3-1ubuntu2.1.dsc' wget_1.20.3-1ubuntu2.1.dsc 2251 SHA512:2efc1de95f08b69307c87dcc10cd2c986b2095c88b04b31cad3602a8379484e44157a1aa6037584dfee350fd888d9b05f377b980d78494f735e4bb664c4e16c9
'http://archive.ubuntu.com/ubuntu/pool/main/w/wget/wget_1.20.3.orig.tar.gz' wget_1.20.3.orig.tar.gz 4489249 SHA512:e8b82b40e270296228094a78d47f81580bdbdea9e6b93fd61b37dccb39430aeb9bda5397dc53a31c952a61629383c7e2a8c8abf414c8a4dd369af6ecf2717e6c
'http://archive.ubuntu.com/ubuntu/pool/main/w/wget/wget_1.20.3.orig.tar.gz.asc' wget_1.20.3.orig.tar.gz.asc 833 SHA512:40e1bb87dba49e9b8a1e3a6e9ffb95e97933508cd8fef4aac9545b74073800e2945b80bab749e57d4ddc8260a612d784160bec45a6c9c057954d22960c8dd170
'http://archive.ubuntu.com/ubuntu/pool/main/w/wget/wget_1.20.3-1ubuntu2.1.debian.tar.xz' wget_1.20.3-1ubuntu2.1.debian.tar.xz 65168 SHA512:9ac2dc2c1b74d31384f46f95d9ac92b3b59b7ca56338eb0ed6162f7011ff9d595f26965cb7111918175261624883cdb6d00377f6b44ae870f36d764a03c15586
```

### `dpkg` source package: `x11-utils=7.7+5`

Binary Packages:

- `x11-utils=7.7+5`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris x11-utils=7.7+5
'http://archive.ubuntu.com/ubuntu/pool/main/x/x11-utils/x11-utils_7.7%2b5.dsc' x11-utils_7.7+5.dsc 2136 SHA256:080991680b95466c8f124356d443483ab7c44c383f3cc029f3deb66ddccfbe72
'http://archive.ubuntu.com/ubuntu/pool/main/x/x11-utils/x11-utils_7.7%2b5.tar.gz' x11-utils_7.7+5.tar.gz 3056692 SHA256:10801f586876ee483510b4a2c5c837ddd0858475860f9a72600f38cb3553722b
```

### `dpkg` source package: `x11-xserver-utils=7.7+8`

Binary Packages:

- `x11-xserver-utils=7.7+8`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris x11-xserver-utils=7.7+8
'http://archive.ubuntu.com/ubuntu/pool/main/x/x11-xserver-utils/x11-xserver-utils_7.7%2b8.dsc' x11-xserver-utils_7.7+8.dsc 1949 SHA256:e9f3fe561444bac31e40fe9405ab64a1d10e3cca3d0a7dfed870cb8921a8a95d
'http://archive.ubuntu.com/ubuntu/pool/main/x/x11-xserver-utils/x11-xserver-utils_7.7%2b8.tar.gz' x11-xserver-utils_7.7+8.tar.gz 2645046 SHA256:2f571846006d7671777dbcac2e89e48f780f97506b75b7c871744637125a29d8
```

### `dpkg` source package: `x264=2:0.155.2917+git0a84d98-2`

Binary Packages:

- `libx264-155:amd64=2:0.155.2917+git0a84d98-2`

Licenses: (parsed from: `/usr/share/doc/libx264-155/copyright`)

- `BSD-3-clause`
- `Expat`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with other exception`
- `ISC`
- `LGPL-2.1+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris x264=2:0.155.2917+git0a84d98-2
'http://archive.ubuntu.com/ubuntu/pool/universe/x/x264/x264_0.155.2917%2bgit0a84d98-2.dsc' x264_0.155.2917+git0a84d98-2.dsc 2407 SHA256:b296d3069efcbbf6a7a9c3a6bfd1ec99fa559ece8c5959158859e47e0092a393
'http://archive.ubuntu.com/ubuntu/pool/universe/x/x264/x264_0.155.2917%2bgit0a84d98.orig.tar.gz' x264_0.155.2917+git0a84d98.orig.tar.gz 934501 SHA256:814e8d233a7a98a66b4c592bec60c531369bac453d679ba6c006bdcd2677e7e8
'http://archive.ubuntu.com/ubuntu/pool/universe/x/x264/x264_0.155.2917%2bgit0a84d98-2.debian.tar.xz' x264_0.155.2917+git0a84d98-2.debian.tar.xz 23260 SHA256:9058a14889abcb6e28e1219ba3b5a78c00125f91877a1ecf3ac7d3aa352b19c3
```

### `dpkg` source package: `x265=3.2.1-1build1`

Binary Packages:

- `libx265-179:amd64=3.2.1-1build1`

Licenses: (parsed from: `/usr/share/doc/libx265-179/copyright`)

- `Expat`
- `GPL-2`
- `GPL-2+`
- `ISC`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris x265=3.2.1-1build1
'http://archive.ubuntu.com/ubuntu/pool/universe/x/x265/x265_3.2.1-1build1.dsc' x265_3.2.1-1build1.dsc 2292 SHA256:4dc61864d62248c3f5d9d404ad5127434310b31f38c1cac9432150363a9e8d9f
'http://archive.ubuntu.com/ubuntu/pool/universe/x/x265/x265_3.2.1.orig.tar.gz' x265_3.2.1.orig.tar.gz 1426255 SHA256:fb9badcf92364fd3567f8b5aa0e5e952aeea7a39a2b864387cec31e3b58cbbcc
'http://archive.ubuntu.com/ubuntu/pool/universe/x/x265/x265_3.2.1-1build1.debian.tar.xz' x265_3.2.1-1build1.debian.tar.xz 13172 SHA256:cffcaac1a8202c9021e3999dc617d115fc5d4a8fb7810a3aff6d9e122dea2942
```

### `dpkg` source package: `xdg-user-dirs=0.17-2ubuntu1`

Binary Packages:

- `xdg-user-dirs=0.17-2ubuntu1`

Licenses: (parsed from: `/usr/share/doc/xdg-user-dirs/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris xdg-user-dirs=0.17-2ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/x/xdg-user-dirs/xdg-user-dirs_0.17-2ubuntu1.dsc' xdg-user-dirs_0.17-2ubuntu1.dsc 1671 SHA256:47a6d5715554995558197b0a79735a3335d9ff248cef3db1e34cb8be286ffa23
'http://archive.ubuntu.com/ubuntu/pool/main/x/xdg-user-dirs/xdg-user-dirs_0.17.orig.tar.gz' xdg-user-dirs_0.17.orig.tar.gz 257291 SHA256:2a07052823788e8614925c5a19ef5b968d8db734fdee656699ea4f97d132418c
'http://archive.ubuntu.com/ubuntu/pool/main/x/xdg-user-dirs/xdg-user-dirs_0.17-2ubuntu1.debian.tar.xz' xdg-user-dirs_0.17-2ubuntu1.debian.tar.xz 28704 SHA256:4883d7162a09f35c2640c25103c3a9914b916f13170ee63f873213823d6550fc
```

### `dpkg` source package: `xdg-utils=1.1.3-2ubuntu1.20.04.2`

Binary Packages:

- `xdg-utils=1.1.3-2ubuntu1.20.04.2`

Licenses: (parsed from: `/usr/share/doc/xdg-utils/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris xdg-utils=1.1.3-2ubuntu1.20.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/x/xdg-utils/xdg-utils_1.1.3-2ubuntu1.20.04.2.dsc' xdg-utils_1.1.3-2ubuntu1.20.04.2.dsc 2207 SHA512:fffbe67c440328294b789c895cd54185e456ad26d0f7a953993f27413ed9b5028e13ac2e37981521da66391bf16b51e62c8f1a3c089d6b5502abdafa5d74a865
'http://archive.ubuntu.com/ubuntu/pool/main/x/xdg-utils/xdg-utils_1.1.3.orig.tar.gz' xdg-utils_1.1.3.orig.tar.gz 297170 SHA512:d1f819a211eb4104a90dfdc6fedcb640fd46b15ccfc8762266f8f538c49d74cb00027b8c1af991fb2a200acb4379986ae375700e06a2aa08fb41a38f883acb3e
'http://archive.ubuntu.com/ubuntu/pool/main/x/xdg-utils/xdg-utils_1.1.3-2ubuntu1.20.04.2.debian.tar.xz' xdg-utils_1.1.3-2ubuntu1.20.04.2.debian.tar.xz 12048 SHA512:1484b5a938bf740058af70d9f697ab92d1d86359f9e6cac707046a0438df6753ea493e92a59ccba4a0ceebd3f375055b5520cef4d8ec1cde30d73ed44db56b26
```

### `dpkg` source package: `xft=2.3.3-0ubuntu1`

Binary Packages:

- `libxft2:amd64=2.3.3-0ubuntu1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris xft=2.3.3-0ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/x/xft/xft_2.3.3-0ubuntu1.dsc' xft_2.3.3-0ubuntu1.dsc 1492 SHA256:5919894493ea8ebf6ec9775ed576beaf012a3094f7b77782515ccd8a12bce9f2
'http://archive.ubuntu.com/ubuntu/pool/main/x/xft/xft_2.3.3.orig.tar.gz' xft_2.3.3.orig.tar.gz 425784 SHA256:3c3cf88b1a96e49a3d87d67d9452d34b6e25e96ae83959b8d0a980935014d701
'http://archive.ubuntu.com/ubuntu/pool/main/x/xft/xft_2.3.3-0ubuntu1.diff.gz' xft_2.3.3-0ubuntu1.diff.gz 10421 SHA256:4b081e5a4e86189fe74c35873793b01a623bd198481411a17e42c454f9d5d2eb
```

### `dpkg` source package: `xkeyboard-config=2.29-2`

Binary Packages:

- `xkb-data=2.29-2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris xkeyboard-config=2.29-2
'http://archive.ubuntu.com/ubuntu/pool/main/x/xkeyboard-config/xkeyboard-config_2.29-2.dsc' xkeyboard-config_2.29-2.dsc 2367 SHA256:dca40afb9a196907a2f1c80b147d574329f126f01b8834f7886fbe8448162971
'http://archive.ubuntu.com/ubuntu/pool/main/x/xkeyboard-config/xkeyboard-config_2.29.orig.tar.gz' xkeyboard-config_2.29.orig.tar.gz 2701654 SHA256:d8034c8b771b51140409039f8e3351e90a0092238b81af04239794e8d3dc0813
'http://archive.ubuntu.com/ubuntu/pool/main/x/xkeyboard-config/xkeyboard-config_2.29.orig.tar.gz.asc' xkeyboard-config_2.29.orig.tar.gz.asc 488 SHA256:30b9b0fd406caf048a74627f29dca01868b87a6c6d722003a6c0a8834165c08d
'http://archive.ubuntu.com/ubuntu/pool/main/x/xkeyboard-config/xkeyboard-config_2.29-2.diff.gz' xkeyboard-config_2.29-2.diff.gz 987137 SHA256:8dc241399c899e7c4d2ae41e442ec310b45e70b7935aaffec66c2d1d0c065bf4
```

### `dpkg` source package: `xmlsec1=1.2.28-2`

Binary Packages:

- `libxmlsec1:amd64=1.2.28-2`
- `libxmlsec1-nss:amd64=1.2.28-2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris xmlsec1=1.2.28-2
'http://archive.ubuntu.com/ubuntu/pool/main/x/xmlsec1/xmlsec1_1.2.28-2.dsc' xmlsec1_1.2.28-2.dsc 2616 SHA256:2dc2ce5fec43ae103263f8d11ec05e57499b4d0a96d5d5de660b57925b5a86d7
'http://archive.ubuntu.com/ubuntu/pool/main/x/xmlsec1/xmlsec1_1.2.28.orig.tar.gz' xmlsec1_1.2.28.orig.tar.gz 2014642 SHA256:162125da1425f9ab786bab6c69e04679828cb8566c7566a51d32a4ce993669c4
'http://archive.ubuntu.com/ubuntu/pool/main/x/xmlsec1/xmlsec1_1.2.28-2.debian.tar.xz' xmlsec1_1.2.28-2.debian.tar.xz 8732 SHA256:854821664d3e19a6fb15f85394635271aa245a395bccdc1dca8eb9e63b8ecd68
```

### `dpkg` source package: `xorg-sgml-doctools=1:1.11-1`

Binary Packages:

- `xorg-sgml-doctools=1:1.11-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris xorg-sgml-doctools=1:1.11-1
'http://archive.ubuntu.com/ubuntu/pool/main/x/xorg-sgml-doctools/xorg-sgml-doctools_1.11-1.dsc' xorg-sgml-doctools_1.11-1.dsc 1975 SHA256:1f4a12a38420b0ddab35553b9588fdf43ab39577958aed70fca435c9a747141a
'http://archive.ubuntu.com/ubuntu/pool/main/x/xorg-sgml-doctools/xorg-sgml-doctools_1.11.orig.tar.gz' xorg-sgml-doctools_1.11.orig.tar.gz 150367 SHA256:986326d7b4dd2ad298f61d8d41fe3929ac6191c6000d6d7e47a8ffc0c34e7426
'http://archive.ubuntu.com/ubuntu/pool/main/x/xorg-sgml-doctools/xorg-sgml-doctools_1.11-1.diff.gz' xorg-sgml-doctools_1.11-1.diff.gz 3194 SHA256:18eeb355cb0efff9f47f8ed8e852eee322d9733a427419f4b39f43bc4df630c1
```

### `dpkg` source package: `xorg=1:7.7+19ubuntu14`

Binary Packages:

- `x11-common=1:7.7+19ubuntu14`

Licenses: (parsed from: `/usr/share/doc/x11-common/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris xorg=1:7.7+19ubuntu14
'http://archive.ubuntu.com/ubuntu/pool/main/x/xorg/xorg_7.7%2b19ubuntu14.dsc' xorg_7.7+19ubuntu14.dsc 2107 SHA256:d9d6449510066c3b34216cf08f797f00f64df3494567b5478a60d0feb50b9d95
'http://archive.ubuntu.com/ubuntu/pool/main/x/xorg/xorg_7.7%2b19ubuntu14.tar.gz' xorg_7.7+19ubuntu14.tar.gz 299269 SHA256:b8a1c0f7b24ae5565f6f22ccf01cd0c8e46c4f5dad6c14bce4f3495e82138213
```

### `dpkg` source package: `xorgproto=2019.2-1ubuntu1`

Binary Packages:

- `x11proto-core-dev=2019.2-1ubuntu1`
- `x11proto-dev=2019.2-1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/x11proto-core-dev/copyright`, `/usr/share/doc/x11proto-dev/copyright`)

- `MIT`
- `SGI`

Source:

```console
$ apt-get source -qq --print-uris xorgproto=2019.2-1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/x/xorgproto/xorgproto_2019.2-1ubuntu1.dsc' xorgproto_2019.2-1ubuntu1.dsc 4096 SHA256:1b0fede1501745c7cfed22b86ea951ba6792ae6eda404fafae9533b01fbb2ee2
'http://archive.ubuntu.com/ubuntu/pool/main/x/xorgproto/xorgproto_2019.2.orig.tar.gz' xorgproto_2019.2.orig.tar.gz 1080686 SHA256:ebfcfce48b66bec25d5dff0e9510e04053ef78e51a8eabeeee4c00e399226d61
'http://archive.ubuntu.com/ubuntu/pool/main/x/xorgproto/xorgproto_2019.2.orig.tar.gz.asc' xorgproto_2019.2.orig.tar.gz.asc 659 SHA256:75da45caac1d85fe37a5e7f33a087d456cad1dc38f2743b7f7df63d7ca583293
'http://archive.ubuntu.com/ubuntu/pool/main/x/xorgproto/xorgproto_2019.2-1ubuntu1.diff.gz' xorgproto_2019.2-1ubuntu1.diff.gz 21111 SHA256:9162224ecb85b35b37a51fbb2a1c53fc8262339fd3208ded60e141607aa835e8
```

### `dpkg` source package: `xtrans=1.4.0-1`

Binary Packages:

- `xtrans-dev=1.4.0-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris xtrans=1.4.0-1
'http://archive.ubuntu.com/ubuntu/pool/main/x/xtrans/xtrans_1.4.0-1.dsc' xtrans_1.4.0-1.dsc 1919 SHA256:dd74ab9199e8f45215b566a9317cac7953bf063ce6893c185eccaf0fb4d84d8f
'http://archive.ubuntu.com/ubuntu/pool/main/x/xtrans/xtrans_1.4.0.orig.tar.gz' xtrans_1.4.0.orig.tar.gz 225941 SHA256:48ed850ce772fef1b44ca23639b0a57e38884045ed2cbb18ab137ef33ec713f9
'http://archive.ubuntu.com/ubuntu/pool/main/x/xtrans/xtrans_1.4.0-1.diff.gz' xtrans_1.4.0-1.diff.gz 9522 SHA256:0dac18165654d79e0796b80fab4c1104998d29e6d0b098af0426a1d72399521e
```

### `dpkg` source package: `xvidcore=2:1.3.7-1`

Binary Packages:

- `libxvidcore4:amd64=2:1.3.7-1`

Licenses: (parsed from: `/usr/share/doc/libxvidcore4/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris xvidcore=2:1.3.7-1
'http://archive.ubuntu.com/ubuntu/pool/universe/x/xvidcore/xvidcore_1.3.7-1.dsc' xvidcore_1.3.7-1.dsc 2129 SHA256:163919a59468677ed948011371e93b7183d83d3b0e77bc84ac02fe27b1510548
'http://archive.ubuntu.com/ubuntu/pool/universe/x/xvidcore/xvidcore_1.3.7.orig.tar.bz2' xvidcore_1.3.7.orig.tar.bz2 698615 SHA256:aeeaae952d4db395249839a3bd03841d6844843f5a4f84c271ff88f7aa1acff7
'http://archive.ubuntu.com/ubuntu/pool/universe/x/xvidcore/xvidcore_1.3.7-1.debian.tar.xz' xvidcore_1.3.7-1.debian.tar.xz 6464 SHA256:0293cfb7f9c9036ffc40647ae81e98f12c880372eafbe58e22810032f9227338
```

### `dpkg` source package: `xz-utils=5.2.4-1ubuntu1.1`

Binary Packages:

- `liblzma5:amd64=5.2.4-1ubuntu1.1`
- `xz-utils=5.2.4-1ubuntu1.1`

Licenses: (parsed from: `/usr/share/doc/liblzma5/copyright`, `/usr/share/doc/xz-utils/copyright`)

- `Autoconf`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `LGPL-2`
- `LGPL-2.1`
- `LGPL-2.1+`
- `PD`
- `PD-debian`
- `config-h`
- `noderivs`
- `none`
- `permissive-fsf`
- `permissive-nowarranty`
- `probably-PD`

Source:

```console
$ apt-get source -qq --print-uris xz-utils=5.2.4-1ubuntu1.1
'http://archive.ubuntu.com/ubuntu/pool/main/x/xz-utils/xz-utils_5.2.4-1ubuntu1.1.dsc' xz-utils_5.2.4-1ubuntu1.1.dsc 2604 SHA512:458e4bd7a0823dc7e5f1dcf11bd4d0653b5c3f2474835a8422918faa25ab5b5ad005aa42af70bb9a993480ae1fe4e787965b19bd2ba4bee2ddedcaa24c10376c
'http://archive.ubuntu.com/ubuntu/pool/main/x/xz-utils/xz-utils_5.2.4.orig.tar.xz' xz-utils_5.2.4.orig.tar.xz 1053868 SHA512:00db7dd31a61541b1ce6946e0f21106f418dd1ac3f27cdb8682979cbc3bd777cd6dd1f04f9ba257a0a7e24041e15ca40d0dd5c130380dce62280af67a0beb97f
'http://archive.ubuntu.com/ubuntu/pool/main/x/xz-utils/xz-utils_5.2.4.orig.tar.xz.asc' xz-utils_5.2.4.orig.tar.xz.asc 879 SHA512:dbfce0556bc85545ce3566a01c25e4876f560409fc2d48f2dc382b10fbd2538c61d8f2c3667d86fc7313aec86c05e53926015000320f19615e97875adae42450
'http://archive.ubuntu.com/ubuntu/pool/main/x/xz-utils/xz-utils_5.2.4-1ubuntu1.1.debian.tar.xz' xz-utils_5.2.4-1ubuntu1.1.debian.tar.xz 136944 SHA512:627df70d2ff3b0227d6dd74137a660c5d722cce059ee36c1db8a50105ba6c236910bba5687290a7d88c9a53ead2a3b3ab00216f279f26a57d7e4020c6db23a24
```

### `dpkg` source package: `yajl=2.1.0-3ubuntu0.20.04.1`

Binary Packages:

- `libyajl2:amd64=2.1.0-3ubuntu0.20.04.1`

Licenses: (parsed from: `/usr/share/doc/libyajl2/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris yajl=2.1.0-3ubuntu0.20.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/y/yajl/yajl_2.1.0-3ubuntu0.20.04.1.dsc' yajl_2.1.0-3ubuntu0.20.04.1.dsc 2128 SHA512:58ed79827f68bc9330e108e2f3b44106545fc2d2d781e8987d0dac549364de930538f6b48c5eea30dd24c4be8bcce9d38c6a9dbc2384fe5626c98fae98994fb9
'http://archive.ubuntu.com/ubuntu/pool/main/y/yajl/yajl_2.1.0.orig.tar.gz' yajl_2.1.0.orig.tar.gz 83997 SHA512:9e786d080803df80ec03a9c2f447501e6e8e433a6baf636824bc1d50ecf4f5f80d7dfb1d47958aeb0a30fe459bd0ef033d41bc6a79e1dc6e6b5eade930b19b02
'http://archive.ubuntu.com/ubuntu/pool/main/y/yajl/yajl_2.1.0-3ubuntu0.20.04.1.debian.tar.xz' yajl_2.1.0-3ubuntu0.20.04.1.debian.tar.xz 7092 SHA512:255a4dbd809b145f44906c82ae51bff5c53db6211fd9d0110cbf30c2fb894adb44419befe60d875f5c494249ddfc69db3205c9d687b4b1304330937a3bc0dd2f
```

### `dpkg` source package: `zeromq3=4.3.2-2ubuntu1`

Binary Packages:

- `libzmq5:amd64=4.3.2-2ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libzmq5/copyright`)

- `LGPL-2`
- `LGPL-2.0+`
- `LGPL-3`
- `LGPL-3.0+`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris zeromq3=4.3.2-2ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/universe/z/zeromq3/zeromq3_4.3.2-2ubuntu1.dsc' zeromq3_4.3.2-2ubuntu1.dsc 1968 SHA256:72f40e07d61a6733aefa8ad58f12ad9382bd355c7b3c58054a20595eac2f15c5
'http://archive.ubuntu.com/ubuntu/pool/universe/z/zeromq3/zeromq3_4.3.2.orig.tar.gz' zeromq3_4.3.2.orig.tar.gz 836655 SHA256:02ecc88466ae38cf2c8d79f09cfd2675ba299a439680b64ade733e26a349edeb
'http://archive.ubuntu.com/ubuntu/pool/universe/z/zeromq3/zeromq3_4.3.2-2ubuntu1.debian.tar.xz' zeromq3_4.3.2-2ubuntu1.debian.tar.xz 22828 SHA256:70cd7c1c1a83fd60405f30317c3416992fe1dfd39b26e2cfc61372cbf70f267c
```

### `dpkg` source package: `zip=3.0-11build1`

Binary Packages:

- `zip=3.0-11build1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris zip=3.0-11build1
'http://archive.ubuntu.com/ubuntu/pool/main/z/zip/zip_3.0-11build1.dsc' zip_3.0-11build1.dsc 1658 SHA256:47bc14d9970340a3469117770adca913c1c1803547f847366f37562d78979904
'http://archive.ubuntu.com/ubuntu/pool/main/z/zip/zip_3.0.orig.tar.gz' zip_3.0.orig.tar.gz 1118845 SHA256:f0e8bb1f9b7eb0b01285495a2699df3a4b766784c1765a8f1aeedf63c0806369
'http://archive.ubuntu.com/ubuntu/pool/main/z/zip/zip_3.0-11build1.debian.tar.xz' zip_3.0-11build1.debian.tar.xz 8308 SHA256:3011af4bcde82439198f97af23220e6ba4837de9aaa68811688bd48a990c7981
```

### `dpkg` source package: `zlib=1:1.2.11.dfsg-2ubuntu1.5`

Binary Packages:

- `zlib1g:amd64=1:1.2.11.dfsg-2ubuntu1.5`

Licenses: (parsed from: `/usr/share/doc/zlib1g/copyright`)

- `Zlib`

Source:

```console
$ apt-get source -qq --print-uris zlib=1:1.2.11.dfsg-2ubuntu1.5
'http://archive.ubuntu.com/ubuntu/pool/main/z/zlib/zlib_1.2.11.dfsg-2ubuntu1.5.dsc' zlib_1.2.11.dfsg-2ubuntu1.5.dsc 2649 SHA512:f28659c4389c08be0023850921a9a7fb29d5c1d79429fe2a4a754209102aa48e84835006bd79dfa5943ef8319969fa549a50668db10d22c37c46082cc58969d4
'http://archive.ubuntu.com/ubuntu/pool/main/z/zlib/zlib_1.2.11.dfsg.orig.tar.gz' zlib_1.2.11.dfsg.orig.tar.gz 370248 SHA512:92819807c0b8de655021bb2d5d182f9b6b381d3072d8c8dc1df34bbaa25d36bcba140c85f754a43cc466aac65850b7a7366aa0c93e804180e5b255e61d5748de
'http://archive.ubuntu.com/ubuntu/pool/main/z/zlib/zlib_1.2.11.dfsg-2ubuntu1.5.debian.tar.xz' zlib_1.2.11.dfsg-2ubuntu1.5.debian.tar.xz 56436 SHA512:f6e3a370612f2a836c36f674e7647dc6cf339bf698648a3630c9b71515d317f846345c9d0db6e1c73e627ce239245a24083e705b8dfe3baece638bb3f5c0b195
```

### `dpkg` source package: `zvbi=0.2.35-17`

Binary Packages:

- `libzvbi-common=0.2.35-17`
- `libzvbi0:amd64=0.2.35-17`

Licenses: (parsed from: `/usr/share/doc/libzvbi-common/copyright`, `/usr/share/doc/libzvbi0/copyright`)

- `BSD-2-Clause`
- `BSD-3-Clause`
- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris zvbi=0.2.35-17
'http://archive.ubuntu.com/ubuntu/pool/universe/z/zvbi/zvbi_0.2.35-17.dsc' zvbi_0.2.35-17.dsc 2119 SHA256:0f7b46b509461ca37b8ee53fa69aa6cf8f14c0f3120e6d5a48ce89f7ae953470
'http://archive.ubuntu.com/ubuntu/pool/universe/z/zvbi/zvbi_0.2.35.orig.tar.bz2' zvbi_0.2.35.orig.tar.bz2 1047761 SHA256:fc883c34111a487c4a783f91b1b2bb5610d8d8e58dcba80c7ab31e67e4765318
'http://archive.ubuntu.com/ubuntu/pool/universe/z/zvbi/zvbi_0.2.35-17.debian.tar.xz' zvbi_0.2.35-17.debian.tar.xz 15868 SHA256:92e3aecc9ca185f82772223b2bdf6458f7cce288910c1ebb698d23bde28a828d
```
