# `oraclelinux:7-slim-fips`

## Docker Metadata

- Image ID: `sha256:a42be9644aab75e85059f55cb79122b829ea5601acaa08b829eb7628682db7bb`
- Created: `2024-10-15T23:44:17Z`
- Virtual Size: ~ 208.04 Mb  
  (total size of all layers on-disk)
- Arch: `linux`/`amd64`
- Command: `["/bin/bash"]`
- Environment:
  - `PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin`

## `rpm` (`.rpm`-based packages)

### `rpm` package: `acl-2.2.51-15.el7.x86_64`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url acl-2.2.51-15.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/acl-2.2.51-15.el7.src.rpm
```

### `rpm` package: `audit-libs-2.8.5-4.el7.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url audit-libs-2.8.5-4.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/audit-2.8.5-4.el7.src.rpm
```

### `rpm` package: `basesystem-10.0-7.0.1.el7.noarch`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url basesystem-10.0-7.0.1.el7.noarch
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/basesystem-10.0-7.0.1.el7.src.rpm
```

### `rpm` package: `bash-4.2.46-35.el7_9.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url bash-4.2.46-35.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/bash-4.2.46-35.el7_9.src.rpm
```

### `rpm` package: `binutils-2.27-44.base.0.3.el7_9.1.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url binutils-2.27-44.base.0.3.el7_9.1
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/binutils-2.27-44.base.0.3.el7_9.1.src.rpm
```

### `rpm` package: `bzip2-libs-1.0.6-13.el7.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url bzip2-libs-1.0.6-13.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/bzip2-1.0.6-13.el7.src.rpm
```

### `rpm` package: `ca-certificates-2024.2.69_v8.0.303-71.0.1.el7_9.noarch`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url ca-certificates-2024.2.69_v8.0.303-71.0.1.el7_9.noarch
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/ca-certificates-2024.2.69_v8.0.303-71.0.1.el7_9.src.rpm
```

### `rpm` package: `chkconfig-1.7.6-1.0.3.el7.x86_64`

Licenses (from `rpm --query`): GPLv2

Source:

```console
$ dnf --quiet download --source --url chkconfig-1.7.6-1.0.3.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/chkconfig-1.7.6-1.0.3.el7.src.rpm
```

### `rpm` package: `coreutils-8.22-24.0.1.el7_9.2.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url coreutils-8.22-24.0.1.el7_9.2
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/coreutils-8.22-24.0.1.el7_9.2.src.rpm
```

### `rpm` package: `cpio-2.11-28.el7.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url cpio-2.11-28.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/cpio-2.11-28.el7.src.rpm
```

### `rpm` package: `cracklib-2.9.0-11.el7.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url cracklib-2.9.0-11.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/cracklib-2.9.0-11.el7.src.rpm
```

### `rpm` package: `cracklib-dicts-2.9.0-11.el7.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url cracklib-dicts-2.9.0-11.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/cracklib-2.9.0-11.el7.src.rpm
```

### `rpm` package: `cryptsetup-libs-2.0.3-6.el7.x86_64`

Licenses (from `rpm --query`): GPLv2+ and LGPLv2+

Source:

```console
$ dnf --quiet download --source --url cryptsetup-libs-2.0.3-6.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/cryptsetup-2.0.3-6.el7.src.rpm
```

### `rpm` package: `curl-7.29.0-59.0.3.el7_9.2.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url curl-7.29.0-59.0.3.el7_9.2
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/curl-7.29.0-59.0.3.el7_9.2.src.rpm
```

### `rpm` package: `cyrus-sasl-lib-2.1.26-24.0.1.el7_9.x86_64`

Licenses (from `rpm --query`): BSD with advertising

Source:

```console
$ dnf --quiet download --source --url cyrus-sasl-lib-2.1.26-24.0.1.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/cyrus-sasl-2.1.26-24.0.1.el7_9.src.rpm
```

### `rpm` package: `dbus-1.10.24-15.0.1.el7.x86_64`

Licenses (from `rpm --query`): (GPLv2+ or AFL) and GPLv2+

Source:

```console
$ dnf --quiet download --source --url dbus-1.10.24-15.0.1.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/dbus-1.10.24-15.0.1.el7.src.rpm
```

### `rpm` package: `dbus-libs-1.10.24-15.0.1.el7.x86_64`

Licenses (from `rpm --query`): (GPLv2+ or AFL) and GPLv2+

Source:

```console
$ dnf --quiet download --source --url dbus-libs-1.10.24-15.0.1.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/dbus-1.10.24-15.0.1.el7.src.rpm
```

### `rpm` package: `device-mapper-1.02.170-6.0.5.el7_9.5.x86_64`

Licenses (from `rpm --query`): GPLv2

Source:

```console
$ dnf --quiet download --source --url device-mapper-1.02.170-6.0.5.el7_9.5
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/lvm2-2.02.187-6.0.5.el7_9.5.src.rpm
```

### `rpm` package: `device-mapper-libs-1.02.170-6.0.5.el7_9.5.x86_64`

Licenses (from `rpm --query`): LGPLv2

Source:

```console
$ dnf --quiet download --source --url device-mapper-libs-1.02.170-6.0.5.el7_9.5
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/lvm2-2.02.187-6.0.5.el7_9.5.src.rpm
```

### `rpm` package: `diffutils-3.3-6.el7_9.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url diffutils-3.3-6.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/diffutils-3.3-6.el7_9.src.rpm
```

### `rpm` package: `dracut-033-572.0.13.el7.x86_64`

Licenses (from `rpm --query`): GPLv2+ and LGPLv2+

Source:

```console
$ dnf --quiet download --source --url dracut-033-572.0.13.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/dracut-033-572.0.13.el7.src.rpm
```

### `rpm` package: `dracut-fips-033-572.0.13.el7.x86_64`

Licenses (from `rpm --query`): GPLv2+ and LGPLv2+

Source:

```console
$ dnf --quiet download --source --url dracut-fips-033-572.0.13.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/dracut-033-572.0.13.el7.src.rpm
```

### `rpm` package: `elfutils-default-yama-scope-0.176-5.el7.noarch`

Licenses (from `rpm --query`): GPLv2+ or LGPLv3+

Source:

```console
$ dnf --quiet download --source --url elfutils-default-yama-scope-0.176-5.el7.noarch
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/elfutils-0.176-5.el7.src.rpm
```

### `rpm` package: `elfutils-libelf-0.176-5.el7.x86_64`

Licenses (from `rpm --query`): GPLv2+ or LGPLv3+

Source:

```console
$ dnf --quiet download --source --url elfutils-libelf-0.176-5.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/elfutils-0.176-5.el7.src.rpm
```

### `rpm` package: `elfutils-libs-0.176-5.el7.x86_64`

Licenses (from `rpm --query`): GPLv2+ or LGPLv3+

Source:

```console
$ dnf --quiet download --source --url elfutils-libs-0.176-5.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/elfutils-0.176-5.el7.src.rpm
```

### `rpm` package: `expat-2.1.0-15.0.1.el7_9.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url expat-2.1.0-15.0.1.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/expat-2.1.0-15.0.1.el7_9.src.rpm
```

### `rpm` package: `file-libs-5.11-37.el7.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url file-libs-5.11-37.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/file-5.11-37.el7.src.rpm
```

### `rpm` package: `filesystem-3.2-25.el7.x86_64`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url filesystem-3.2-25.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/filesystem-3.2-25.el7.src.rpm
```

### `rpm` package: `findutils-4.5.11-6.el7.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url findutils-4.5.11-6.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/findutils-4.5.11-6.el7.src.rpm
```

### `rpm` package: `gawk-4.0.2-4.el7_3.1.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GPL and LGPLv3+ and LGPL and BSD

Source:

```console
$ dnf --quiet download --source --url gawk-4.0.2-4.el7_3.1
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/gawk-4.0.2-4.el7_3.1.src.rpm
```

### `rpm` package: `gdbm-1.10-8.el7.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url gdbm-1.10-8.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/gdbm-1.10-8.el7.src.rpm
```

### `rpm` package: `glib2-2.56.1-9.el7_9.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url glib2-2.56.1-9.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/glib2-2.56.1-9.el7_9.src.rpm
```

### `rpm` package: `glibc-2.17-326.0.9.el7_9.3.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and LGPLv2+ with exceptions and GPLv2+

Source:

```console
$ dnf --quiet download --source --url glibc-2.17-326.0.9.el7_9.3
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/glibc-2.17-326.0.9.el7_9.3.src.rpm
```

### `rpm` package: `glibc-common-2.17-326.0.9.el7_9.3.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and LGPLv2+ with exceptions and GPLv2+

Source:

```console
$ dnf --quiet download --source --url glibc-common-2.17-326.0.9.el7_9.3
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/glibc-2.17-326.0.9.el7_9.3.src.rpm
```

### `rpm` package: `gmp-6.0.0-15.el7.x86_64`

Licenses (from `rpm --query`): LGPLv3+ or GPLv2+

Source:

```console
$ dnf --quiet download --source --url gmp-6.0.0-15.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/gmp-6.0.0-15.el7.src.rpm
https://yum.oracle.com/repo/OracleLinux/OL7/8/security/validation/x86_64/getPackageSource/gmp-6.0.0-15.el7.src.rpm
```

### `rpm` package: `gnupg2-2.0.22-5.el7_5.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url gnupg2-2.0.22-5.el7_5
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/gnupg2-2.0.22-5.el7_5.src.rpm
```

### `rpm` package: `gpg-pubkey-ec551f03-53619141`

Licenses (from `rpm --query`): pubkey

**WARNING:** unable to find source (`dnf download` failed or returned no results)!

### `rpm` package: `gpgme-1.3.2-5.el7.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url gpgme-1.3.2-5.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/gpgme-1.3.2-5.el7.src.rpm
```

### `rpm` package: `grep-2.20-3.el7.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url grep-2.20-3.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/grep-2.20-3.el7.src.rpm
```

### `rpm` package: `gzip-1.5-11.el7_9.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GFDL

Source:

```console
$ dnf --quiet download --source --url gzip-1.5-11.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/gzip-1.5-11.el7_9.src.rpm
```

### `rpm` package: `hardlink-1.0-19.el7.x86_64`

Licenses (from `rpm --query`): GPL+

Source:

```console
$ dnf --quiet download --source --url hardlink-1.0-19.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/hardlink-1.0-19.el7.src.rpm
```

### `rpm` package: `info-5.1-5.el7.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url info-5.1-5.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/texinfo-5.1-5.el7.src.rpm
```

### `rpm` package: `json-c-0.11-4.el7_0.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url json-c-0.11-4.el7_0
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/json-c-0.11-4.el7_0.src.rpm
```

### `rpm` package: `kernel-container-3.10.0-0.0.0.2.el7.x86_64`

Licenses (from `rpm --query`): GPLv2

**WARNING:** unable to find source (`dnf download` failed or returned no results)!

### `rpm` package: `keyutils-libs-1.5.8-3.el7.x86_64`

Licenses (from `rpm --query`): GPLv2+ and LGPLv2+

Source:

```console
$ dnf --quiet download --source --url keyutils-libs-1.5.8-3.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/keyutils-1.5.8-3.el7.src.rpm
```

### `rpm` package: `kmod-20-28.0.3.el7.x86_64`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url kmod-20-28.0.3.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/kmod-20-28.0.3.el7.src.rpm
```

### `rpm` package: `kmod-libs-20-28.0.3.el7.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url kmod-libs-20-28.0.3.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/kmod-20-28.0.3.el7.src.rpm
```

### `rpm` package: `kpartx-0.4.9-136.0.5.el7_9.x86_64`

Licenses (from `rpm --query`): GPL+

Source:

```console
$ dnf --quiet download --source --url kpartx-0.4.9-136.0.5.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/device-mapper-multipath-0.4.9-136.0.5.el7_9.src.rpm
```

### `rpm` package: `krb5-libs-1.15.1-55.0.3.el7_9.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url krb5-libs-1.15.1-55.0.3.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/krb5-1.15.1-55.0.3.el7_9.src.rpm
```

### `rpm` package: `libacl-2.2.51-15.el7.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libacl-2.2.51-15.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/acl-2.2.51-15.el7.src.rpm
```

### `rpm` package: `libassuan-2.1.0-3.el7.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and GPLv3+

Source:

```console
$ dnf --quiet download --source --url libassuan-2.1.0-3.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/libassuan-2.1.0-3.el7.src.rpm
```

### `rpm` package: `libattr-2.4.46-13.el7.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libattr-2.4.46-13.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/attr-2.4.46-13.el7.src.rpm
```

### `rpm` package: `libblkid-2.23.2-65.0.4.el7_9.1.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libblkid-2.23.2-65.0.4.el7_9.1
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/util-linux-2.23.2-65.0.4.el7_9.1.src.rpm
```

### `rpm` package: `libcap-2.22-11.el7.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libcap-2.22-11.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/libcap-2.22-11.el7.src.rpm
```

### `rpm` package: `libcap-ng-0.7.5-4.el7.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libcap-ng-0.7.5-4.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/libcap-ng-0.7.5-4.el7.src.rpm
```

### `rpm` package: `libcom_err-1.45.4-3.0.7.el7.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libcom_err-1.45.4-3.0.7.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/e2fsprogs-1.45.4-3.0.7.el7.src.rpm
```

### `rpm` package: `libcurl-7.29.0-59.0.3.el7_9.2.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libcurl-7.29.0-59.0.3.el7_9.2
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/curl-7.29.0-59.0.3.el7_9.2.src.rpm
```

### `rpm` package: `libdb-5.3.21-25.el7.x86_64`

Licenses (from `rpm --query`): BSD and LGPLv2 and Sleepycat

Source:

```console
$ dnf --quiet download --source --url libdb-5.3.21-25.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/libdb-5.3.21-25.el7.src.rpm
```

### `rpm` package: `libdb-utils-5.3.21-25.el7.x86_64`

Licenses (from `rpm --query`): BSD and LGPLv2 and Sleepycat

Source:

```console
$ dnf --quiet download --source --url libdb-utils-5.3.21-25.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/libdb-5.3.21-25.el7.src.rpm
```

### `rpm` package: `libffi-3.0.13-19.el7.x86_64`

Licenses (from `rpm --query`): MIT and Public Domain

Source:

```console
$ dnf --quiet download --source --url libffi-3.0.13-19.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/libffi-3.0.13-19.el7.src.rpm
```

### `rpm` package: `libgcc-4.8.5-44.0.3.el7.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD

Source:

```console
$ dnf --quiet download --source --url libgcc-4.8.5-44.0.3.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/gcc-4.8.5-44.0.3.el7.src.rpm
```

### `rpm` package: `libgcrypt-1.5.3-14.el7.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libgcrypt-1.5.3-14.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/libgcrypt-1.5.3-14.el7.src.rpm
https://yum.oracle.com/repo/OracleLinux/OL7/8/security/validation/x86_64/getPackageSource/libgcrypt-1.5.3-14.el7.src.rpm
```

### `rpm` package: `libgpg-error-1.12-3.el7.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libgpg-error-1.12-3.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/libgpg-error-1.12-3.el7.src.rpm
```

### `rpm` package: `libidn-1.28-4.el7.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and GPLv3+ and GFDL

Source:

```console
$ dnf --quiet download --source --url libidn-1.28-4.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/libidn-1.28-4.el7.src.rpm
```

### `rpm` package: `libkcapi-1.2.0-2.0.1.el7.x86_64`

Licenses (from `rpm --query`): BSD or GPLv2

Source:

```console
$ dnf --quiet download --source --url libkcapi-1.2.0-2.0.1.el7
https://yum.oracle.com/repo/OracleLinux/OL7/8/security/validation/x86_64/getPackageSource/libkcapi-1.2.0-2.0.1.el7.src.rpm
```

### `rpm` package: `libkcapi-hmaccalc-1.2.0-2.0.1.el7.x86_64`

Licenses (from `rpm --query`): BSD or GPLv2

Source:

```console
$ dnf --quiet download --source --url libkcapi-hmaccalc-1.2.0-2.0.1.el7
https://yum.oracle.com/repo/OracleLinux/OL7/8/security/validation/x86_64/getPackageSource/libkcapi-1.2.0-2.0.1.el7.src.rpm
```

### `rpm` package: `libmount-2.23.2-65.0.4.el7_9.1.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libmount-2.23.2-65.0.4.el7_9.1
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/util-linux-2.23.2-65.0.4.el7_9.1.src.rpm
```

### `rpm` package: `libpwquality-1.2.3-5.el7.x86_64`

Licenses (from `rpm --query`): BSD or GPLv2+

Source:

```console
$ dnf --quiet download --source --url libpwquality-1.2.3-5.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/libpwquality-1.2.3-5.el7.src.rpm
```

### `rpm` package: `libselinux-2.5-15.el7.x86_64`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url libselinux-2.5-15.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/libselinux-2.5-15.el7.src.rpm
```

### `rpm` package: `libsemanage-2.5-14.el7.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libsemanage-2.5-14.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/libsemanage-2.5-14.el7.src.rpm
```

### `rpm` package: `libsepol-2.5-10.el7.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libsepol-2.5-10.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/libsepol-2.5-10.el7.src.rpm
```

### `rpm` package: `libsmartcols-2.23.2-65.0.4.el7_9.1.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libsmartcols-2.23.2-65.0.4.el7_9.1
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/util-linux-2.23.2-65.0.4.el7_9.1.src.rpm
```

### `rpm` package: `libssh2-1.8.0-4.el7_9.1.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url libssh2-1.8.0-4.el7_9.1
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/libssh2-1.8.0-4.el7_9.1.src.rpm
```

### `rpm` package: `libstdc++-4.8.5-44.0.3.el7.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD

Source:

```console
$ dnf --quiet download --source --url libstdc++-4.8.5-44.0.3.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/gcc-4.8.5-44.0.3.el7.src.rpm
```

### `rpm` package: `libtasn1-4.10-1.el7.x86_64`

Licenses (from `rpm --query`): GPLv3+ and LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libtasn1-4.10-1.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/libtasn1-4.10-1.el7.src.rpm
```

### `rpm` package: `libuser-0.60-9.el7.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libuser-0.60-9.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/libuser-0.60-9.el7.src.rpm
```

### `rpm` package: `libutempter-1.1.6-4.el7.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libutempter-1.1.6-4.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/libutempter-1.1.6-4.el7.src.rpm
```

### `rpm` package: `libuuid-2.23.2-65.0.4.el7_9.1.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url libuuid-2.23.2-65.0.4.el7_9.1
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/util-linux-2.23.2-65.0.4.el7_9.1.src.rpm
```

### `rpm` package: `libverto-0.2.5-4.el7.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libverto-0.2.5-4.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/libverto-0.2.5-4.el7.src.rpm
```

### `rpm` package: `libxml2-2.9.1-6.0.3.el7_9.6.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libxml2-2.9.1-6.0.3.el7_9.6
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/libxml2-2.9.1-6.0.3.el7_9.6.src.rpm
```

### `rpm` package: `libxml2-python-2.9.1-6.0.3.el7_9.6.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libxml2-python-2.9.1-6.0.3.el7_9.6
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/libxml2-2.9.1-6.0.3.el7_9.6.src.rpm
```

### `rpm` package: `lua-5.1.4-15.el7.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url lua-5.1.4-15.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/lua-5.1.4-15.el7.src.rpm
```

### `rpm` package: `lz4-1.8.3-1.el7.x86_64`

Licenses (from `rpm --query`): GPLv2+ and BSD

Source:

```console
$ dnf --quiet download --source --url lz4-1.8.3-1.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/lz4-1.8.3-1.el7.src.rpm
```

### `rpm` package: `ncurses-5.9-14.20130511.el7_4.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url ncurses-5.9-14.20130511.el7_4
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/ncurses-5.9-14.20130511.el7_4.src.rpm
```

### `rpm` package: `ncurses-base-5.9-14.20130511.el7_4.noarch`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url ncurses-base-5.9-14.20130511.el7_4.noarch
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/ncurses-5.9-14.20130511.el7_4.src.rpm
```

### `rpm` package: `ncurses-libs-5.9-14.20130511.el7_4.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url ncurses-libs-5.9-14.20130511.el7_4
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/ncurses-5.9-14.20130511.el7_4.src.rpm
```

### `rpm` package: `nspr-4.35.0-1.el7_9.x86_64`

Licenses (from `rpm --query`): MPLv2.0

Source:

```console
$ dnf --quiet download --source --url nspr-4.35.0-1.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/nspr-4.35.0-1.el7_9.src.rpm
```

### `rpm` package: `nss-3.90.0-2.el7_9.x86_64`

Licenses (from `rpm --query`): MPLv2.0

Source:

```console
$ dnf --quiet download --source --url nss-3.90.0-2.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/nss-3.90.0-2.el7_9.src.rpm
```

### `rpm` package: `nss-pem-1.0.3-7.el7_9.1.x86_64`

Licenses (from `rpm --query`): MPLv1.1

Source:

```console
$ dnf --quiet download --source --url nss-pem-1.0.3-7.el7_9.1
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/nss-pem-1.0.3-7.el7_9.1.src.rpm
```

### `rpm` package: `nss-softokn-3.90.0-6.0.1.el7_9.x86_64`

Licenses (from `rpm --query`): MPLv2.0

Source:

```console
$ dnf --quiet download --source --url nss-softokn-3.90.0-6.0.1.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/nss-softokn-3.90.0-6.0.1.el7_9.src.rpm
```

### `rpm` package: `nss-softokn-freebl-3.90.0-6.0.1.el7_9.x86_64`

Licenses (from `rpm --query`): MPLv2.0

Source:

```console
$ dnf --quiet download --source --url nss-softokn-freebl-3.90.0-6.0.1.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/nss-softokn-3.90.0-6.0.1.el7_9.src.rpm
```

### `rpm` package: `nss-sysinit-3.90.0-2.el7_9.x86_64`

Licenses (from `rpm --query`): MPLv2.0

Source:

```console
$ dnf --quiet download --source --url nss-sysinit-3.90.0-2.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/nss-3.90.0-2.el7_9.src.rpm
```

### `rpm` package: `nss-tools-3.90.0-2.el7_9.x86_64`

Licenses (from `rpm --query`): MPLv2.0

Source:

```console
$ dnf --quiet download --source --url nss-tools-3.90.0-2.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/nss-3.90.0-2.el7_9.src.rpm
```

### `rpm` package: `nss-util-3.90.0-1.el7_9.x86_64`

Licenses (from `rpm --query`): MPLv2.0

Source:

```console
$ dnf --quiet download --source --url nss-util-3.90.0-1.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/nss-util-3.90.0-1.el7_9.src.rpm
```

### `rpm` package: `openldap-2.4.44-25.el7_9.x86_64`

Licenses (from `rpm --query`): OpenLDAP

Source:

```console
$ dnf --quiet download --source --url openldap-2.4.44-25.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/openldap-2.4.44-25.el7_9.src.rpm
```

### `rpm` package: `openssl-libs-1.0.2k-26.el7_9_fips.x86_64`

Licenses (from `rpm --query`): OpenSSL

Source:

```console
$ dnf --quiet download --source --url openssl-libs-1.0.2k-26.el7_9_fips
https://yum.oracle.com/repo/OracleLinux/OL7/8/security/validation/x86_64/getPackageSource/openssl-1.0.2k-26.el7_9_fips.src.rpm
```

### `rpm` package: `oraclelinux-release-7.9-1.0.13.el7.x86_64`

Licenses (from `rpm --query`): GPL

Source:

```console
$ dnf --quiet download --source --url oraclelinux-release-7.9-1.0.13.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/oraclelinux-release-7.9-1.0.13.el7.src.rpm
```

### `rpm` package: `oraclelinux-release-el7-1.0-17.el7.x86_64`

Licenses (from `rpm --query`): GPLv2

Source:

```console
$ dnf --quiet download --source --url oraclelinux-release-el7-1.0-17.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/oraclelinux-release-el7-1.0-17.el7.src.rpm
```

### `rpm` package: `p11-kit-0.23.5-3.el7.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url p11-kit-0.23.5-3.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/p11-kit-0.23.5-3.el7.src.rpm
```

### `rpm` package: `p11-kit-trust-0.23.5-3.el7.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url p11-kit-trust-0.23.5-3.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/p11-kit-0.23.5-3.el7.src.rpm
```

### `rpm` package: `pam-1.1.8-23.0.1.el7.x86_64`

Licenses (from `rpm --query`): BSD and GPLv2+

Source:

```console
$ dnf --quiet download --source --url pam-1.1.8-23.0.1.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/pam-1.1.8-23.0.1.el7.src.rpm
```

### `rpm` package: `pcre-8.32-17.el7.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url pcre-8.32-17.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/pcre-8.32-17.el7.src.rpm
```

### `rpm` package: `pinentry-0.8.1-17.el7.x86_64`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url pinentry-0.8.1-17.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/pinentry-0.8.1-17.el7.src.rpm
```

### `rpm` package: `pkgconfig-0.27.1-4.el7.x86_64`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url pkgconfig-0.27.1-4.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/pkgconfig-0.27.1-4.el7.src.rpm
```

### `rpm` package: `popt-1.13-16.el7.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url popt-1.13-16.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/popt-1.13-16.el7.src.rpm
```

### `rpm` package: `procps-ng-3.3.10-28.0.1.el7.x86_64`

Licenses (from `rpm --query`): GPL+ and GPLv2 and GPLv2+ and GPLv3+ and LGPLv2+

Source:

```console
$ dnf --quiet download --source --url procps-ng-3.3.10-28.0.1.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/procps-ng-3.3.10-28.0.1.el7.src.rpm
```

### `rpm` package: `pth-2.0.7-23.el7.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url pth-2.0.7-23.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/pth-2.0.7-23.el7.src.rpm
```

### `rpm` package: `pygpgme-0.3-9.el7.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url pygpgme-0.3-9.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/pygpgme-0.3-9.el7.src.rpm
```

### `rpm` package: `pyliblzma-0.5.3-11.el7.x86_64`

Licenses (from `rpm --query`): LGPLv3+

Source:

```console
$ dnf --quiet download --source --url pyliblzma-0.5.3-11.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/pyliblzma-0.5.3-11.el7.src.rpm
```

### `rpm` package: `python-2.7.5-94.0.1.el7_9.x86_64`

Licenses (from `rpm --query`): Python

Source:

```console
$ dnf --quiet download --source --url python-2.7.5-94.0.1.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/python-2.7.5-94.0.1.el7_9.src.rpm
```

### `rpm` package: `python-chardet-2.2.1-3.el7.noarch`

Licenses (from `rpm --query`): LGPLv2

Source:

```console
$ dnf --quiet download --source --url python-chardet-2.2.1-3.el7.noarch
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/python-chardet-2.2.1-3.el7.src.rpm
```

### `rpm` package: `python-iniparse-0.4-9.el7.noarch`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url python-iniparse-0.4-9.el7.noarch
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/python-iniparse-0.4-9.el7.src.rpm
```

### `rpm` package: `python-kitchen-1.1.1-5.el7.noarch`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url python-kitchen-1.1.1-5.el7.noarch
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/python-kitchen-1.1.1-5.el7.src.rpm
```

### `rpm` package: `python-libs-2.7.5-94.0.1.el7_9.x86_64`

Licenses (from `rpm --query`): Python

Source:

```console
$ dnf --quiet download --source --url python-libs-2.7.5-94.0.1.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/python-2.7.5-94.0.1.el7_9.src.rpm
```

### `rpm` package: `python-pycurl-7.19.0-19.el7.x86_64`

Licenses (from `rpm --query`): LGPLv2+ or MIT

Source:

```console
$ dnf --quiet download --source --url python-pycurl-7.19.0-19.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/python-pycurl-7.19.0-19.el7.src.rpm
```

### `rpm` package: `python-urlgrabber-3.10-10.el7.noarch`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url python-urlgrabber-3.10-10.el7.noarch
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/python-urlgrabber-3.10-10.el7.src.rpm
```

### `rpm` package: `pyxattr-0.5.1-5.el7.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url pyxattr-0.5.1-5.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/pyxattr-0.5.1-5.el7.src.rpm
```

### `rpm` package: `qrencode-libs-3.4.1-3.el7.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url qrencode-libs-3.4.1-3.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/qrencode-3.4.1-3.el7.src.rpm
```

### `rpm` package: `readline-6.2-11.el7.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url readline-6.2-11.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/readline-6.2-11.el7.src.rpm
```

### `rpm` package: `redhat-release-server-7.9-6.0.1.el7_9.x86_64`

Licenses (from `rpm --query`): GPLv2

Source:

```console
$ dnf --quiet download --source --url redhat-release-server-7.9-6.0.1.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/redhat-release-server-7.9-6.0.1.el7_9.src.rpm
```

### `rpm` package: `rpm-4.11.3-48.0.3.el7_9.x86_64`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url rpm-4.11.3-48.0.3.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/rpm-4.11.3-48.0.3.el7_9.src.rpm
```

### `rpm` package: `rpm-build-libs-4.11.3-48.0.3.el7_9.x86_64`

Licenses (from `rpm --query`): GPLv2+ and LGPLv2+ with exceptions

Source:

```console
$ dnf --quiet download --source --url rpm-build-libs-4.11.3-48.0.3.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/rpm-4.11.3-48.0.3.el7_9.src.rpm
```

### `rpm` package: `rpm-libs-4.11.3-48.0.3.el7_9.x86_64`

Licenses (from `rpm --query`): GPLv2+ and LGPLv2+ with exceptions

Source:

```console
$ dnf --quiet download --source --url rpm-libs-4.11.3-48.0.3.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/rpm-4.11.3-48.0.3.el7_9.src.rpm
```

### `rpm` package: `rpm-python-4.11.3-48.0.3.el7_9.x86_64`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url rpm-python-4.11.3-48.0.3.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/rpm-4.11.3-48.0.3.el7_9.src.rpm
```

### `rpm` package: `sed-4.2.2-7.el7.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url sed-4.2.2-7.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/sed-4.2.2-7.el7.src.rpm
```

### `rpm` package: `setup-2.8.71-11.el7.noarch`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url setup-2.8.71-11.el7.noarch
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/setup-2.8.71-11.el7.src.rpm
```

### `rpm` package: `shadow-utils-4.6-5.0.1.el7.x86_64`

Licenses (from `rpm --query`): BSD and GPLv2+

Source:

```console
$ dnf --quiet download --source --url shadow-utils-4.6-5.0.1.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/shadow-utils-4.6-5.0.1.el7.src.rpm
```

### `rpm` package: `shared-mime-info-1.8-5.el7.x86_64`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url shared-mime-info-1.8-5.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/shared-mime-info-1.8-5.el7.src.rpm
```

### `rpm` package: `sqlite-3.7.17-8.el7_7.1.x86_64`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url sqlite-3.7.17-8.el7_7.1
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/sqlite-3.7.17-8.el7_7.1.src.rpm
```

### `rpm` package: `systemd-219-78.0.17.el7_9.9.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and MIT and GPLv2+

Source:

```console
$ dnf --quiet download --source --url systemd-219-78.0.17.el7_9.9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/systemd-219-78.0.17.el7_9.9.src.rpm
```

### `rpm` package: `systemd-libs-219-78.0.17.el7_9.9.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and MIT

Source:

```console
$ dnf --quiet download --source --url systemd-libs-219-78.0.17.el7_9.9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/systemd-219-78.0.17.el7_9.9.src.rpm
```

### `rpm` package: `tar-1.26-35.el7.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url tar-1.26-35.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/tar-1.26-35.el7.src.rpm
```

### `rpm` package: `tzdata-2024a-1.el7.noarch`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url tzdata-2024a-1.el7.noarch
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/tzdata-2024a-1.el7.src.rpm
```

### `rpm` package: `ustr-1.0.4-16.el7.x86_64`

Licenses (from `rpm --query`): MIT or LGPLv2+ or BSD

Source:

```console
$ dnf --quiet download --source --url ustr-1.0.4-16.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/ustr-1.0.4-16.el7.src.rpm
```

### `rpm` package: `util-linux-2.23.2-65.0.4.el7_9.1.x86_64`

Licenses (from `rpm --query`): GPLv2 and GPLv2+ and LGPLv2+ and BSD with advertising and Public Domain

Source:

```console
$ dnf --quiet download --source --url util-linux-2.23.2-65.0.4.el7_9.1
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/util-linux-2.23.2-65.0.4.el7_9.1.src.rpm
```

### `rpm` package: `xz-5.2.2-2.el7_9.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url xz-5.2.2-2.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/xz-5.2.2-2.el7_9.src.rpm
```

### `rpm` package: `xz-libs-5.2.2-2.el7_9.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url xz-libs-5.2.2-2.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/xz-5.2.2-2.el7_9.src.rpm
```

### `rpm` package: `yum-3.4.3-168.0.5.el7.noarch`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url yum-3.4.3-168.0.5.el7.noarch
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/yum-3.4.3-168.0.5.el7.src.rpm
```

### `rpm` package: `yum-metadata-parser-1.1.4-10.el7.x86_64`

Licenses (from `rpm --query`): GPLv2

Source:

```console
$ dnf --quiet download --source --url yum-metadata-parser-1.1.4-10.el7
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/yum-metadata-parser-1.1.4-10.el7.src.rpm
```

### `rpm` package: `yum-plugin-ovl-1.1.31-54.0.1.el7_8.noarch`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url yum-plugin-ovl-1.1.31-54.0.1.el7_8.noarch
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/yum-utils-1.1.31-54.0.1.el7_8.src.rpm
```

### `rpm` package: `yum-utils-1.1.31-54.0.1.el7_8.noarch`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url yum-utils-1.1.31-54.0.1.el7_8.noarch
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/yum-utils-1.1.31-54.0.1.el7_8.src.rpm
```

### `rpm` package: `zlib-1.2.7-21.el7_9.x86_64`

Licenses (from `rpm --query`): zlib and Boost

Source:

```console
$ dnf --quiet download --source --url zlib-1.2.7-21.el7_9
https://yum.oracle.com/repo/OracleLinux/OL7/latest/x86_64/getPackageSource/zlib-1.2.7-21.el7_9.src.rpm
```
