# `odoo:17.0-20241029`

## Docker Metadata

- Image ID: `sha256:32778f5a8fc88f2e90e7f4b4f51612279f0495497b403809a3e6bb622f9635a4`
- Created: `2024-10-29T13:56:14Z`
- Virtual Size: ~ 1.80 Gb  
  (total size of all layers on-disk)
- Arch: `linux`/`amd64`
- Entrypoint: `["/entrypoint.sh"]`
- Command: `["odoo"]`
- Environment:
  - `PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin`
  - `LANG=en_US.UTF-8`
  - `ODOO_VERSION=17.0`
  - `ODOO_RC=/etc/odoo/odoo.conf`
- Labels:
  - `org.opencontainers.image.ref.name=ubuntu`
  - `org.opencontainers.image.version=22.04`

## `dpkg` (`.deb`-based packages)

### `dpkg` source package: `acl=2.3.1-1`

Binary Packages:

- `libacl1:amd64=2.3.1-1`

Licenses: (parsed from: `/usr/share/doc/libacl1/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2+`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris acl=2.3.1-1
'http://archive.ubuntu.com/ubuntu/pool/main/a/acl/acl_2.3.1-1.dsc' acl_2.3.1-1.dsc 2486 SHA512:8eb7f71030d7c4d355886390f12ffd7f66605bb2082a9a9de2eea0918aefe7b7cf1c26a3f8872681f5b3074df1cf07c4d01ae564bcba5b400b048b0e34b233c2
'http://archive.ubuntu.com/ubuntu/pool/main/a/acl/acl_2.3.1.orig.tar.xz' acl_2.3.1.orig.tar.xz 355676 SHA512:7d02f05d17305f8587ab485395b00c7fdb8e44c1906d0d04b70a43a3020803e8b2b8c707abb6147f794867dfa87bd51769c2d3e11a3db55ecbd2006a6e6231dc
'http://archive.ubuntu.com/ubuntu/pool/main/a/acl/acl_2.3.1.orig.tar.xz.asc' acl_2.3.1.orig.tar.xz.asc 833 SHA512:be046f3bf1ac7e21d2a07bf6ea87c1fedeed2f9d370d8bf3de1aa0c448de5484b1523697415849b6b7ca23e48e3df5353f6aebe850eb20fc2044d2681c71f298
'http://archive.ubuntu.com/ubuntu/pool/main/a/acl/acl_2.3.1-1.debian.tar.xz' acl_2.3.1-1.debian.tar.xz 27732 SHA512:2fdfcd8daa1919e850cd3ed634b4141d65bbf7847eaf0a7899b6e8ae52fe2fa15de3378f6487a9224d00eb530cf5b285cc3b6272af66fcdcf1f29f2838648083
```

### `dpkg` source package: `adduser=3.118ubuntu5`

Binary Packages:

- `adduser=3.118ubuntu5`

Licenses: (parsed from: `/usr/share/doc/adduser/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris adduser=3.118ubuntu5
'http://archive.ubuntu.com/ubuntu/pool/main/a/adduser/adduser_3.118ubuntu5.dsc' adduser_3.118ubuntu5.dsc 1766 SHA512:8d6e9894549dc9dd53db8480cb18ee9b012bc70ea7b53d72b0ad8ad713a1672d2e94750e1cde44d2b8f9fd7e66b1ea7c2ad20202fc7bcd90e2fba5cee63d5b5d
'http://archive.ubuntu.com/ubuntu/pool/main/a/adduser/adduser_3.118ubuntu5.tar.xz' adduser_3.118ubuntu5.tar.xz 222904 SHA512:ded568a5a3f5a5ac1acc2098e37160194f8c4622e90c7044d599286a321fe8fd701c8554a4517e4d72a6089b8e3b5592b92d46668032bda81de64cc736bf0a75
```

### `dpkg` source package: `ann=1.1.2+doc-7build1`

Binary Packages:

- `libann0=1.1.2+doc-7build1`

Licenses: (parsed from: `/usr/share/doc/libann0/copyright`)

- `GPL-3`
- `GPL-3.0+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris ann=1.1.2+doc-7build1
'http://archive.ubuntu.com/ubuntu/pool/universe/a/ann/ann_1.1.2%2bdoc-7build1.dsc' ann_1.1.2+doc-7build1.dsc 2164 SHA512:e2613d5270ab40f9139f2cfb912c466a485237ad645c0cb7075429886a351a53cc1e4c6dbdddd5ccc8397240fff17d28885675564010d7a4da0e5a9f2e0d8096
'http://archive.ubuntu.com/ubuntu/pool/universe/a/ann/ann_1.1.2%2bdoc.orig.tar.gz' ann_1.1.2+doc.orig.tar.gz 693957 SHA512:fb004a014add109d0b0949443c4c599795363d20ee65386421f898f5276b5df08714a3cd8d371d5a03417e7c3f7f3451335f90df2ca274ce95c658b958a253ae
'http://archive.ubuntu.com/ubuntu/pool/universe/a/ann/ann_1.1.2%2bdoc-7build1.debian.tar.xz' ann_1.1.2+doc-7build1.debian.tar.xz 172220 SHA512:bdea0ce4e76fe53714922c2cd33488818ad20d1f8cb5eb97c064bb9ceac10899aad2d88a0590c977cbdc698854149b715815f054efadb88b0d018be8fbe06aee
```

### `dpkg` source package: `appdirs=1.4.4-2`

Binary Packages:

- `python3-appdirs=1.4.4-2`

Licenses: (parsed from: `/usr/share/doc/python3-appdirs/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris appdirs=1.4.4-2
'http://archive.ubuntu.com/ubuntu/pool/main/a/appdirs/appdirs_1.4.4-2.dsc' appdirs_1.4.4-2.dsc 2145 SHA512:607f9e757f59cf7a173e206bb60741c9978babc286b22d1d5e8db8bc7547f1ab23ac2e5ac0ec90a8bfde9f3e4f6c53532e07992b63624c9652f9e83899d2bf94
'http://archive.ubuntu.com/ubuntu/pool/main/a/appdirs/appdirs_1.4.4.orig.tar.gz' appdirs_1.4.4.orig.tar.gz 13470 SHA512:8b0cdd9fd471d45b186aa47607691cf378dabd3edc7b7026a57bd6d6f57698e86f440818a5e23ba4288b35d6bb8cb6eb0106eae8aab09d8863ee15025d300883
'http://archive.ubuntu.com/ubuntu/pool/main/a/appdirs/appdirs_1.4.4-2.debian.tar.xz' appdirs_1.4.4-2.debian.tar.xz 3520 SHA512:f264fb567f29e38bba575b40f9d86496745063a042a82d420e120b766c89963d0d9efd3819cc8e133975f4b51667e009a77fbb61751ab2908cd410272e5a1006
```

### `dpkg` source package: `apt=2.4.13`

Binary Packages:

- `apt=2.4.13`
- `libapt-pkg6.0:amd64=2.4.13`

Licenses: (parsed from: `/usr/share/doc/apt/copyright`, `/usr/share/doc/libapt-pkg6.0/copyright`)

- `GPL-2`
- `GPLv2+`

Source:

```console
$ apt-get source -qq --print-uris apt=2.4.13
'http://archive.ubuntu.com/ubuntu/pool/main/a/apt/apt_2.4.13.dsc' apt_2.4.13.dsc 2801 SHA512:a3b478fc618f6d5cb69e7489543ce3ef89b9f604162adb9540a45f45845c31081647ba6c08fea7d1d125c30daa09d718f88493d850546aa0edb409e1840a79d1
'http://archive.ubuntu.com/ubuntu/pool/main/a/apt/apt_2.4.13.tar.xz' apt_2.4.13.tar.xz 2323800 SHA512:8b085133f1d4416698182374a6b5df2f5d1509500d6c6ebfd7b47c2288f176f0c332703af1a8de0b79ea5fceb2bbd2a0470bd86d584ea36927bc87f406c2d570
```

### `dpkg` source package: `attr=1:2.5.1-1build1`

Binary Packages:

- `libattr1:amd64=1:2.5.1-1build1`

Licenses: (parsed from: `/usr/share/doc/libattr1/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2+`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris attr=1:2.5.1-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/a/attr/attr_2.5.1-1build1.dsc' attr_2.5.1-1build1.dsc 2134 SHA512:4beeec510cf7976a3b2c0de3b90974ef03886b3a98ccb2b74f6278ed988727af3a0fa432d86aefd3bdb4bc50e29b3351f11fd892512407203f3e61636290ae15
'http://archive.ubuntu.com/ubuntu/pool/main/a/attr/attr_2.5.1.orig.tar.xz' attr_2.5.1.orig.tar.xz 318188 SHA512:9e5555260189bb6ef2440c76700ebb813ff70582eb63d446823874977307d13dfa3a347dfae619f8866943dfa4b24ccf67dadd7e3ea2637239fdb219be5d2932
'http://archive.ubuntu.com/ubuntu/pool/main/a/attr/attr_2.5.1.orig.tar.xz.asc' attr_2.5.1.orig.tar.xz.asc 833 SHA512:be4f3629ef66bd400bcdeaf8b6b1564dc729472a514d59fb4909a30f3269711dedea16002283e9aabbf83c374e0a3d70bc00f1136da0fed66a8184acdfd7e78f
'http://archive.ubuntu.com/ubuntu/pool/main/a/attr/attr_2.5.1-1build1.debian.tar.xz' attr_2.5.1-1build1.debian.tar.xz 28032 SHA512:c9d0869a3bb9f8019e6764fee3a78d8b1b9a3cdb37968aac19a9a7e7bbeeaadcbad86d5363ce3b0e26b5a178a4d446e4097d095e17b7a6d7f3e595d07176675c
```

### `dpkg` source package: `audit=1:3.0.7-1build1`

Binary Packages:

- `libaudit-common=1:3.0.7-1build1`
- `libaudit1:amd64=1:3.0.7-1build1`

Licenses: (parsed from: `/usr/share/doc/libaudit-common/copyright`, `/usr/share/doc/libaudit1/copyright`)

- `GPL-1`
- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris audit=1:3.0.7-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/a/audit/audit_3.0.7-1build1.dsc' audit_3.0.7-1build1.dsc 2771 SHA512:beb14e23239ab9c87dd4a57821d7d557a14a3e67f66306110ef87cd77cd2c07426f3bc8413d757618f886c5059e9bf624347753170708e0ad39b90f96fd51053
'http://archive.ubuntu.com/ubuntu/pool/main/a/audit/audit_3.0.7.orig.tar.gz' audit_3.0.7.orig.tar.gz 1180226 SHA512:b5662b32082fc2ac54e247aa0db5442d76afa30134ebba1d624a17004e9ccf6856bb75344af4ce9d9a0a66c03e1c6f18b7d45658d7df13ea71af0c8362e08d70
'http://archive.ubuntu.com/ubuntu/pool/main/a/audit/audit_3.0.7-1build1.debian.tar.xz' audit_3.0.7-1build1.debian.tar.xz 17772 SHA512:cdf346fc7dc04e42b44a9089fb7c01e68ea54ccd20d3eef8100d0cd8eed8ebd0764d8fd6ceab133faa0bfeee18e3cfe7625d230600b0e34ed0c19a7b739ec783
```

### `dpkg` source package: `base-files=12ubuntu4.7`

Binary Packages:

- `base-files=12ubuntu4.7`

Licenses: (parsed from: `/usr/share/doc/base-files/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris base-files=12ubuntu4.7
'http://archive.ubuntu.com/ubuntu/pool/main/b/base-files/base-files_12ubuntu4.7.dsc' base-files_12ubuntu4.7.dsc 1277 SHA512:9421fa1b62eb1c09d8aa93bb7c96ceaa077aaa4841ed5e516a682cfcc7cefdb7a7fd87976ba9e2718791fda2583141710968c4ce7357e089f5e5c3f7a0683ccf
'http://archive.ubuntu.com/ubuntu/pool/main/b/base-files/base-files_12ubuntu4.7.tar.xz' base-files_12ubuntu4.7.tar.xz 81888 SHA512:e3a9f3188f6f43a53818200ac110f504f81b2819e301d69931a18fb34673541c11b2fc43af256e0c52f4a6daa6bd4b408b99ba432fa1b2b6624658bf312b0db5
```

### `dpkg` source package: `base-passwd=3.5.52build1`

Binary Packages:

- `base-passwd=3.5.52build1`

Licenses: (parsed from: `/usr/share/doc/base-passwd/copyright`)

- `GPL-2`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris base-passwd=3.5.52build1
'http://archive.ubuntu.com/ubuntu/pool/main/b/base-passwd/base-passwd_3.5.52build1.dsc' base-passwd_3.5.52build1.dsc 1320 SHA512:2071171adf14d276664526662fab08d34a45a259ebcdbee7ae57bb004d3d12793e629006a37b649f16c0f04856e9f7bb79fb92fe304525167f48e73dec0cc4fd
'http://archive.ubuntu.com/ubuntu/pool/main/b/base-passwd/base-passwd_3.5.52build1.tar.xz' base-passwd_3.5.52build1.tar.xz 54252 SHA512:699ffe50f4a7fbdea2c0b25d3b2452d538598870cf39b84668d9b7efa20ec41284c331513e89c966e7248732b1ec1abdfdb871e31f8e9efa026c691e89236ffe
```

### `dpkg` source package: `bash=5.1-6ubuntu1.1`

Binary Packages:

- `bash=5.1-6ubuntu1.1`

Licenses: (parsed from: `/usr/share/doc/bash/copyright`)

- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris bash=5.1-6ubuntu1.1
'http://archive.ubuntu.com/ubuntu/pool/main/b/bash/bash_5.1-6ubuntu1.1.dsc' bash_5.1-6ubuntu1.1.dsc 2409 SHA512:8adffecbfd9ffe55500fb70616e4b441bccb95fda13762dc2cccc3605a25f34851b142d2c633f17a5a7e426f0c5010ad76b0a70d375f923e25f6c9f4c893c8e4
'http://archive.ubuntu.com/ubuntu/pool/main/b/bash/bash_5.1.orig.tar.xz' bash_5.1.orig.tar.xz 5802740 SHA512:95d3acc542231cb893e1347c7d9dd66687f68cd347a0e9e126fde2d14e68c5b5530d1a5866eafa781e88aa013fcf72b4ad56d2e484c2ac7a69bd90bb149a9b86
'http://archive.ubuntu.com/ubuntu/pool/main/b/bash/bash_5.1-6ubuntu1.1.debian.tar.xz' bash_5.1-6ubuntu1.1.debian.tar.xz 99944 SHA512:d7fb6110df70232bd3280c1140a812a1903968792f6608481c184bd28760d03323ada75ed3ca4da4eb6c56a84781d6e2f441e0ee83dd9364a9e37fd0fa2211e9
```

### `dpkg` source package: `beautifulsoup4=4.10.0-2`

Binary Packages:

- `python3-bs4=4.10.0-2`

Licenses: (parsed from: `/usr/share/doc/python3-bs4/copyright`)

- `Expat`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris beautifulsoup4=4.10.0-2
'http://archive.ubuntu.com/ubuntu/pool/main/b/beautifulsoup4/beautifulsoup4_4.10.0-2.dsc' beautifulsoup4_4.10.0-2.dsc 1751 SHA512:18baed01a7bfed0e106968cef0e39ee248d6c0e94a140b79b96d894fd20e75bb90e1026a12e9de41d409ddabd08ab813da7eea56feb742c8d9ad91fda236e616
'http://archive.ubuntu.com/ubuntu/pool/main/b/beautifulsoup4/beautifulsoup4_4.10.0.orig.tar.gz' beautifulsoup4_4.10.0.orig.tar.gz 399890 SHA512:92be99ed0fd479b86519395143516e28f7b80f54a8251223d6e7b88dc98f8dfca9585079f5f1d89bfe68f577de3dff433711642486303203f46bc76754959a18
'http://archive.ubuntu.com/ubuntu/pool/main/b/beautifulsoup4/beautifulsoup4_4.10.0-2.debian.tar.xz' beautifulsoup4_4.10.0-2.debian.tar.xz 6856 SHA512:4a9447bded479c5a1b9fcfbd0caddc77b6ddfdc7a0a582e1d82a6cd8bbc004c988ef9df5241c8995ac159a26c8510affd1850efd3b1c8f53ab6b048eef16c6be
```

### `dpkg` source package: `brotli=1.0.9-2build6`

Binary Packages:

- `libbrotli1:amd64=1.0.9-2build6`

Licenses: (parsed from: `/usr/share/doc/libbrotli1/copyright`)

- `MIT`

Source:

```console
$ apt-get source -qq --print-uris brotli=1.0.9-2build6
'http://archive.ubuntu.com/ubuntu/pool/main/b/brotli/brotli_1.0.9-2build6.dsc' brotli_1.0.9-2build6.dsc 1940 SHA512:9294702945cdaadad51f8690e7454d06b3281f94429123a4353cfdcce9eac598e9ad827f97f74798a7e958147aafec059022214b3bb7fe1db6337bebec2774b4
'http://archive.ubuntu.com/ubuntu/pool/main/b/brotli/brotli_1.0.9.orig.tar.gz' brotli_1.0.9.orig.tar.gz 486984 SHA512:b8e2df955e8796ac1f022eb4ebad29532cb7e3aa6a4b6aee91dbd2c7d637eee84d9a144d3e878895bb5e62800875c2c01c8f737a1261020c54feacf9f676b5f5
'http://archive.ubuntu.com/ubuntu/pool/main/b/brotli/brotli_1.0.9-2build6.debian.tar.xz' brotli_1.0.9-2build6.debian.tar.xz 5812 SHA512:a50a2e8ce37aa228c3074f657d5591cd509f6b34e78b3b16b044072886c184623994a6420e5c0759a2bab1df26ba69462692c7d2c59bdc72f9683b7df884771c
```

### `dpkg` source package: `bzip2=1.0.8-5build1`

Binary Packages:

- `libbz2-1.0:amd64=1.0.8-5build1`

Licenses: (parsed from: `/usr/share/doc/libbz2-1.0/copyright`)

- `BSD-variant`
- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris bzip2=1.0.8-5build1
'http://archive.ubuntu.com/ubuntu/pool/main/b/bzip2/bzip2_1.0.8-5build1.dsc' bzip2_1.0.8-5build1.dsc 1860 SHA512:dfb9cd3a99f8c80a27e088b6ba7f06f50bc2bdbc61f574ed8f77d0fa58ff07fa1c34a060351fd4b601537181143dd934caadd7a00eb97aea5933febb7b61743d
'http://archive.ubuntu.com/ubuntu/pool/main/b/bzip2/bzip2_1.0.8.orig.tar.gz' bzip2_1.0.8.orig.tar.gz 810029 SHA512:083f5e675d73f3233c7930ebe20425a533feedeaaa9d8cc86831312a6581cefbe6ed0d08d2fa89be81082f2a5abdabca8b3c080bf97218a1bd59dc118a30b9f3
'http://archive.ubuntu.com/ubuntu/pool/main/b/bzip2/bzip2_1.0.8-5build1.debian.tar.bz2' bzip2_1.0.8-5build1.debian.tar.bz2 26870 SHA512:e030c257c3458d780fd0ffc6f328efd69d0e875e81acd7441a7c6651194ebded61017c96aad7c99061f93d50dfc33056abe98c9a599abc900f49d51c4a1eed6f
```

### `dpkg` source package: `c-ares=1.18.1-1ubuntu0.22.04.3`

Binary Packages:

- `libc-ares2:amd64=1.18.1-1ubuntu0.22.04.3`

Licenses: (parsed from: `/usr/share/doc/libc-ares2/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris c-ares=1.18.1-1ubuntu0.22.04.3
'http://archive.ubuntu.com/ubuntu/pool/main/c/c-ares/c-ares_1.18.1-1ubuntu0.22.04.3.dsc' c-ares_1.18.1-1ubuntu0.22.04.3.dsc 1944 SHA512:26717150b48c799458f189534337cf21980159f06697a99365416038196b5d6beacc9696d0676679f0937f5a8126b1ec73b63246a99018f74d6e171fe3a2ebfe
'http://archive.ubuntu.com/ubuntu/pool/main/c/c-ares/c-ares_1.18.1.orig.tar.gz' c-ares_1.18.1.orig.tar.gz 1560165 SHA512:1276ec0799916019f8c0af6b55a139701bd15e0ca4a00811d07963893978bc96c107b980f0fd49f81aa70bc8b3b8cd671195ba357c390772d4c2c5643c50c5a5
'http://archive.ubuntu.com/ubuntu/pool/main/c/c-ares/c-ares_1.18.1.orig.tar.gz.asc' c-ares_1.18.1.orig.tar.gz.asc 488 SHA512:c5d5b2477148ad179ca02d1fb101905d2042b469be0cd1ce8f45f16c8760c6e0d29316972e6e0e2c489aa43e4a9d779422fdd1f8c7c316b58bd406bce84ed0e0
'http://archive.ubuntu.com/ubuntu/pool/main/c/c-ares/c-ares_1.18.1-1ubuntu0.22.04.3.debian.tar.xz' c-ares_1.18.1-1ubuntu0.22.04.3.debian.tar.xz 13640 SHA512:b66dc2c8e4eed7666da50e7fc86e0301b1d5816692951d938c6604effe444dc01f4eab1fd50b867d2dc775cf8e1ae15562d3c2ec3865f24d817353e0c4b9fd3c
```

### `dpkg` source package: `ca-certificates=20240203~22.04.1`

Binary Packages:

- `ca-certificates=20240203~22.04.1`

Licenses: (parsed from: `/usr/share/doc/ca-certificates/copyright`)

- `GPL-2`
- `GPL-2+`
- `MPL-2.0`

Source:

```console
$ apt-get source -qq --print-uris ca-certificates=20240203~22.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/c/ca-certificates/ca-certificates_20240203%7e22.04.1.dsc' ca-certificates_20240203~22.04.1.dsc 1850 SHA512:af1c4a4a202eead02abba4808ce5e7b731f7e2db6b194e74ff9f5331b515213490ba63181f7ffc59f01f5bd13b7fe80519694c7ff21502cd7e2e095075896696
'http://archive.ubuntu.com/ubuntu/pool/main/c/ca-certificates/ca-certificates_20240203%7e22.04.1.tar.xz' ca-certificates_20240203~22.04.1.tar.xz 263132 SHA512:64e97c5b258dfede258dd9b447d2a1f5a43db0e70309bb4e0259b8ed9d103e1a751fb563bb4902460667385d38325945e806726aa6db8876920dff670034f3f1
```

### `dpkg` source package: `cached-property=1.5.2-1`

Binary Packages:

- `python3-cached-property=1.5.2-1`

Licenses: (parsed from: `/usr/share/doc/python3-cached-property/copyright`)

- `BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris cached-property=1.5.2-1
'http://archive.ubuntu.com/ubuntu/pool/universe/c/cached-property/cached-property_1.5.2-1.dsc' cached-property_1.5.2-1.dsc 2166 SHA512:a04f2e8563a3ef7cfe846488aa49ee4c2f1636aa74cc7c94464b1091b2280cb86c4cbff69fe54fd30d291c4e059e067353f42442b4da02fe6163436029b07b2a
'http://archive.ubuntu.com/ubuntu/pool/universe/c/cached-property/cached-property_1.5.2.orig.tar.gz' cached-property_1.5.2.orig.tar.gz 12244 SHA512:626d98a8891a70d858269859cf4e49416464c836d073c1331c21033a4cd9e0e47dc89b53bf393375439992f4993972517dc3cdcbb2cc6f8286f282d3c973e600
'http://archive.ubuntu.com/ubuntu/pool/universe/c/cached-property/cached-property_1.5.2-1.debian.tar.xz' cached-property_1.5.2-1.debian.tar.xz 3780 SHA512:d945388b1120b49007b91655d1976adb544b4a66f79e7f6dee10ec8c8969b6310476f3a73533f981fc3bc7687bf995996d72683779e7a15cfdc5a21a6b38003c
```

### `dpkg` source package: `cairo=1.16.0-5ubuntu2`

Binary Packages:

- `libcairo2:amd64=1.16.0-5ubuntu2`

Licenses: (parsed from: `/usr/share/doc/libcairo2/copyright`)

- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris cairo=1.16.0-5ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/c/cairo/cairo_1.16.0-5ubuntu2.dsc' cairo_1.16.0-5ubuntu2.dsc 2880 SHA512:e9415592136e7f42794f20d8c74fed895347a95d3ffd89621440c1e12212f65083926613e87fc6ad6df8f669058dc20ad12b2e1bdee2d7a7f85ec0b7c0dd4e26
'http://archive.ubuntu.com/ubuntu/pool/main/c/cairo/cairo_1.16.0.orig.tar.xz' cairo_1.16.0.orig.tar.xz 41997432 SHA512:9eb27c4cf01c0b8b56f2e15e651f6d4e52c99d0005875546405b64f1132aed12fbf84727273f493d84056a13105e065009d89e94a8bfaf2be2649e232b82377f
'http://archive.ubuntu.com/ubuntu/pool/main/c/cairo/cairo_1.16.0-5ubuntu2.debian.tar.xz' cairo_1.16.0-5ubuntu2.debian.tar.xz 33368 SHA512:d51b6655b5ea60420bb80252fbcfe2e31cbef6242043457195eab60716b84dc9ae68eb4de95214b10a5ec6d5675891067a4940b58c2249602f0f355b9d31d8d4
```

### `dpkg` source package: `cdebconf=0.261ubuntu1`

Binary Packages:

- `libdebconfclient0:amd64=0.261ubuntu1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris cdebconf=0.261ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/c/cdebconf/cdebconf_0.261ubuntu1.dsc' cdebconf_0.261ubuntu1.dsc 2941 SHA512:18554e0d66831166d01e199612aa1cd43ed56e00995d62329f2c951143860bc413870acf71f4d0e72e228ce70e6a09c97d87750e5ada1a48beaf4b39d675084c
'http://archive.ubuntu.com/ubuntu/pool/main/c/cdebconf/cdebconf_0.261ubuntu1.tar.xz' cdebconf_0.261ubuntu1.tar.xz 297016 SHA512:6c2c8e2dccdb923ae6dc6a6b3873e6a56f6bdc4a6298c0576f60cb8d5c63bd06c4b9dac4ada4abd0d672a4e54509ad558fc9d1424a8029568d8d86cb54926390
```

### `dpkg` source package: `chardet=4.0.0-1`

Binary Packages:

- `python3-chardet=4.0.0-1`

Licenses: (parsed from: `/usr/share/doc/python3-chardet/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris chardet=4.0.0-1
'http://archive.ubuntu.com/ubuntu/pool/main/c/chardet/chardet_4.0.0-1.dsc' chardet_4.0.0-1.dsc 2191 SHA512:83356bd151518f6542510c1349ef11f4f6616f8b3a795f5e6a37414668029e77e4cfd2b4ba650bc707ad1f0ddece0d76af0d865e76b78d399630c8497ce0b0e5
'http://archive.ubuntu.com/ubuntu/pool/main/c/chardet/chardet_4.0.0.orig.tar.gz' chardet_4.0.0.orig.tar.gz 1907771 SHA512:ebd7f420e1094445270db993f6373ffe7370419e002b0bb13299dc6c9b0f7c4e77b0f44f871fba6371e6869e7c86728514367db377e3137487a3acf50cb81e96
'http://archive.ubuntu.com/ubuntu/pool/main/c/chardet/chardet_4.0.0-1.debian.tar.xz' chardet_4.0.0-1.debian.tar.xz 4868 SHA512:3db3e0e2994461ab157f339ac2d29f8c9384ed5cb4b37782183896cce17d4c3b97c7a45dce9e103f21d73297247bde4b9ddb8fb561c6e33d198b528ef2df20f2
```

### `dpkg` source package: `colors.js=1.4.0-3`

Binary Packages:

- `node-colors=1.4.0-3`

Licenses: (parsed from: `/usr/share/doc/node-colors/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris colors.js=1.4.0-3
'http://archive.ubuntu.com/ubuntu/pool/universe/c/colors.js/colors.js_1.4.0-3.dsc' colors.js_1.4.0-3.dsc 2020 SHA512:5ffebe79145fae5f185535dda20b12556ce5126738f93283686ff94b1fabbbdb9a9bc973be189fdf87a4ecc96bf3acff2b5e70a47146b707172650ecc87fdfed
'http://archive.ubuntu.com/ubuntu/pool/universe/c/colors.js/colors.js_1.4.0.orig.tar.gz' colors.js_1.4.0.orig.tar.gz 46271 SHA512:2d7ff188250ec48734ec82cdb59c1f955651947712318af20c227a38cdc30d76bf8ba4634db779705a4bad3732499105938620ca548c56ff7095f1392eed6b2a
'http://archive.ubuntu.com/ubuntu/pool/universe/c/colors.js/colors.js_1.4.0-3.debian.tar.xz' colors.js_1.4.0-3.debian.tar.xz 2756 SHA512:6e6913bff0d0055ac7a1a87a88007a804bc6641f8d30bfa50a1438cdb21ba1d1ea7f61e35a9a4f143de2ff6e6a6ee1cd438d0185281b913f14e7714cc8a293c7
```

### `dpkg` source package: `coreutils=8.32-4.1ubuntu1.2`

Binary Packages:

- `coreutils=8.32-4.1ubuntu1.2`

Licenses: (parsed from: `/usr/share/doc/coreutils/copyright`)

- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris coreutils=8.32-4.1ubuntu1.2
'http://archive.ubuntu.com/ubuntu/pool/main/c/coreutils/coreutils_8.32-4.1ubuntu1.2.dsc' coreutils_8.32-4.1ubuntu1.2.dsc 2299 SHA512:e6de4621a13517800b91a5990f4506c9d3287ee94346694a1844c4dff113288a2f8eb1bc6531b74096a4125f8a69c76ee59fd300cfe3a44867c8307ce878187f
'http://archive.ubuntu.com/ubuntu/pool/main/c/coreutils/coreutils_8.32.orig.tar.xz' coreutils_8.32.orig.tar.xz 5547836 SHA512:1c8f3584efd61b4b02e7ac5db8e103b63cfb2063432caaf1e64cb2dcc56d8c657d1133bbf10bd41468d6a1f31142e6caa81d16ae68fa3e6e84075c253613a145
'http://archive.ubuntu.com/ubuntu/pool/main/c/coreutils/coreutils_8.32.orig.tar.xz.asc' coreutils_8.32.orig.tar.xz.asc 833 SHA512:9c73b35c9e8f7c2b8eff317afcb5aa3234c5f41c80d1882f3c2342906f3fdc876ae45d1256dd1b8fd3cb58c50925f3c13f93de5018626634fdca3c72c14a9acb
'http://archive.ubuntu.com/ubuntu/pool/main/c/coreutils/coreutils_8.32-4.1ubuntu1.2.debian.tar.xz' coreutils_8.32-4.1ubuntu1.2.debian.tar.xz 44868 SHA512:7718e917f8f2c5c5574e73a079ea8fd3b32bc898f2e12168dc3711dfdd896e4727283011050b80f65e60994fca49da031d70901d453612132764dca7dec99543
```

### `dpkg` source package: `curl=7.81.0-1ubuntu1.18`

Binary Packages:

- `curl=7.81.0-1ubuntu1.18`
- `libcurl4:amd64=7.81.0-1ubuntu1.18`

Licenses: (parsed from: `/usr/share/doc/curl/copyright`, `/usr/share/doc/libcurl4/copyright`)

- `BSD-3-Clause`
- `BSD-4-Clause`
- `ISC`
- `curl`
- `other`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris curl=7.81.0-1ubuntu1.18
'http://archive.ubuntu.com/ubuntu/pool/main/c/curl/curl_7.81.0-1ubuntu1.18.dsc' curl_7.81.0-1ubuntu1.18.dsc 3143 SHA512:036207144cf45829dae73369b911b032410774d290b3dc758a685f9b1706ea03719f41a13216f2e4c7c2f4f375bc3493b34579fc2aea9a2341c35d167bf368f7
'http://archive.ubuntu.com/ubuntu/pool/main/c/curl/curl_7.81.0.orig.tar.gz' curl_7.81.0.orig.tar.gz 4188040 SHA512:e3084f0fa083f7f93eac923edbfdddb5fd0a372b94673ba9d4427a2b95508898c15ecdf63b99a1c1f6cf3215e27b06cbaa2b7073df038d43b362e586f92495d3
'http://archive.ubuntu.com/ubuntu/pool/main/c/curl/curl_7.81.0.orig.tar.gz.asc' curl_7.81.0.orig.tar.gz.asc 488 SHA512:92bc5ede831551285d67b03abe8400c609ad31c9d33e324ee5c41b92dd5c2a0245a09a396bd76807b3e44bcfef944b1e16ac266264f7b85d27cc1c072a6e82bd
'http://archive.ubuntu.com/ubuntu/pool/main/c/curl/curl_7.81.0-1ubuntu1.18.debian.tar.xz' curl_7.81.0-1ubuntu1.18.debian.tar.xz 77396 SHA512:50ca7954a46b6f3c2212d0a517ddb1d5a7d470c502a716242bcd1a85c577462695da55ba5b477fcb71d9cb410dd279b9627bf04ba054c04640d04da572625437
```

### `dpkg` source package: `cyrus-sasl2=2.1.27+dfsg2-3ubuntu1.2`

Binary Packages:

- `libsasl2-2:amd64=2.1.27+dfsg2-3ubuntu1.2`
- `libsasl2-modules-db:amd64=2.1.27+dfsg2-3ubuntu1.2`

Licenses: (parsed from: `/usr/share/doc/libsasl2-2/copyright`, `/usr/share/doc/libsasl2-modules-db/copyright`)

- `BSD-2-clause`
- `BSD-2.2-clause`
- `BSD-3-clause`
- `BSD-3-clause-JANET`
- `BSD-3-clause-PADL`
- `BSD-4-clause`
- `BSD-4-clause-UC`
- `FSFULLR`
- `GPL-3`
- `GPL-3+`
- `IBM-as-is`
- `MIT-CMU`
- `MIT-Export`
- `MIT-OpenVision`
- `OpenLDAP`
- `OpenSSL`
- `RSA-MD`
- `SSLeay`

Source:

```console
$ apt-get source -qq --print-uris cyrus-sasl2=2.1.27+dfsg2-3ubuntu1.2
'http://archive.ubuntu.com/ubuntu/pool/main/c/cyrus-sasl2/cyrus-sasl2_2.1.27%2bdfsg2-3ubuntu1.2.dsc' cyrus-sasl2_2.1.27+dfsg2-3ubuntu1.2.dsc 3626 SHA512:fc67304c71b6bf7e5097bdb080ef0973ab873ff7558d91153066820c2f7d5983260586564760d6abd04c3e3fe7b076b474ae44bc97907cc2fb2757d4ca3cfe56
'http://archive.ubuntu.com/ubuntu/pool/main/c/cyrus-sasl2/cyrus-sasl2_2.1.27%2bdfsg2.orig.tar.xz' cyrus-sasl2_2.1.27+dfsg2.orig.tar.xz 829892 SHA512:13337dfcc57ea8fec471ee0f2a0f6b58fb92907ad0899a4a8afaba957c5da302924e71c9fc4a61bbc913a4ee2ea74b05772cb26ed58d5724a312bb20a8b6a4cb
'http://archive.ubuntu.com/ubuntu/pool/main/c/cyrus-sasl2/cyrus-sasl2_2.1.27%2bdfsg2-3ubuntu1.2.debian.tar.xz' cyrus-sasl2_2.1.27+dfsg2-3ubuntu1.2.debian.tar.xz 98836 SHA512:91457b1c476fae1b407f82304e6f651053ceaa923059e185b59e2be680038c2a38aab7749004b640ba604f7fdf51eb87a45e91671077207b8b8b4319e1bf24fb
```

### `dpkg` source package: `dash=0.5.11+git20210903+057cd650a4ed-3build1`

Binary Packages:

- `dash=0.5.11+git20210903+057cd650a4ed-3build1`

Licenses: (parsed from: `/usr/share/doc/dash/copyright`)

- `BSD-3-Clause`
- `BSD-3-clause`
- `Expat`
- `FSFUL`
- `FSFULLR`
- `GPL-2`
- `GPL-2+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris dash=0.5.11+git20210903+057cd650a4ed-3build1
'http://archive.ubuntu.com/ubuntu/pool/main/d/dash/dash_0.5.11%2bgit20210903%2b057cd650a4ed-3build1.dsc' dash_0.5.11+git20210903+057cd650a4ed-3build1.dsc 1834 SHA512:380a677ef7fcd2060f7806e4e552891393adb43bfba82498d143cd2ed4fa0cc7681e573a27bcb0991025a8323f6eb8b113aa1519cf455645556fad968cd26232
'http://archive.ubuntu.com/ubuntu/pool/main/d/dash/dash_0.5.11%2bgit20210903%2b057cd650a4ed.orig.tar.xz' dash_0.5.11+git20210903+057cd650a4ed.orig.tar.xz 133320 SHA512:eced6bc60ca6ba4394a2ee65d8c6b88eca729c43e47053fc01dec5500ebe002a12f536c128c3fd821a2eb61b97e92c8a0be6d4532926479ce4b7d986be109cb7
'http://archive.ubuntu.com/ubuntu/pool/main/d/dash/dash_0.5.11%2bgit20210903%2b057cd650a4ed-3build1.debian.tar.xz' dash_0.5.11+git20210903+057cd650a4ed-3build1.debian.tar.xz 42744 SHA512:7dd5b1bcaf76d8de19ad1647862e1140de59822c25d9ab1b42423f16de1e4c606ea393adac12f16a2ce9498d8f9553b8787fc31e5f93feefe36ab84b83402e1e
```

### `dpkg` source package: `db5.3=5.3.28+dfsg1-0.8ubuntu3`

Binary Packages:

- `libdb5.3:amd64=5.3.28+dfsg1-0.8ubuntu3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris db5.3=5.3.28+dfsg1-0.8ubuntu3
'http://archive.ubuntu.com/ubuntu/pool/main/d/db5.3/db5.3_5.3.28%2bdfsg1-0.8ubuntu3.dsc' db5.3_5.3.28+dfsg1-0.8ubuntu3.dsc 2875 SHA512:8743931f44f980d7be9ae77f5ce4b14ea260b780f33c8c6da66eb2fe4dba45a9c6b93237e91e2898ae0a76754ee789d67dd4efba7111f1360cb073ba633e1389
'http://archive.ubuntu.com/ubuntu/pool/main/d/db5.3/db5.3_5.3.28%2bdfsg1.orig.tar.xz' db5.3_5.3.28+dfsg1.orig.tar.xz 19723860 SHA512:50cb87bc3f24065839ee2932e82af032b236b290ebe89983076f503c6c62c5f36ff93d7847a3f68b2b19f35088fbab5d3ac6a34553d07e8148e68e9a3f079a12
'http://archive.ubuntu.com/ubuntu/pool/main/d/db5.3/db5.3_5.3.28%2bdfsg1-0.8ubuntu3.debian.tar.xz' db5.3_5.3.28+dfsg1-0.8ubuntu3.debian.tar.xz 32028 SHA512:9034be98df6c753b5f3faee9cbd1886e3e3c3d15c5840bc1c269a5034f6bfe9c4926c20591150b543618816051be218e6f00c3602b8b4325b0fcb193ddba804c
```

### `dpkg` source package: `debconf=1.5.79ubuntu1`

Binary Packages:

- `debconf=1.5.79ubuntu1`

Licenses: (parsed from: `/usr/share/doc/debconf/copyright`)

- `BSD-2-clause`

Source:

```console
$ apt-get source -qq --print-uris debconf=1.5.79ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/d/debconf/debconf_1.5.79ubuntu1.dsc' debconf_1.5.79ubuntu1.dsc 2077 SHA512:0aac451b347a5f6758ab2e468c25ea8061840519412210861a13ced479d5e6bb2a3abd469cb0cf68d80f1f9c4debba28501141055eb2eb1ac1701f800cdd83ba
'http://archive.ubuntu.com/ubuntu/pool/main/d/debconf/debconf_1.5.79ubuntu1.tar.xz' debconf_1.5.79ubuntu1.tar.xz 570660 SHA512:1bf6de4d1cec7475f64d9bdaa47ef6dcb3d1181bcb3b97076ec60213534aa344ca49d552fdcb5c6fde4d42c364b8242bb4880de0a787493868383e6db36f9e5f
```

### `dpkg` source package: `debianutils=5.5-1ubuntu2`

Binary Packages:

- `debianutils=5.5-1ubuntu2`

Licenses: (parsed from: `/usr/share/doc/debianutils/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris debianutils=5.5-1ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/d/debianutils/debianutils_5.5-1ubuntu2.dsc' debianutils_5.5-1ubuntu2.dsc 1667 SHA512:333b9087e56e8f9a9ab95db556783a582b2855042e3dee292767decc4e4ad366bf32b4a30e60f5000a3ccced20ec613649fcd84563dae8e552a31273b42a170b
'http://archive.ubuntu.com/ubuntu/pool/main/d/debianutils/debianutils_5.5.orig.tar.xz' debianutils_5.5.orig.tar.xz 104448 SHA512:230310428ee7c145c74bb666ae729754352295230f38ef4e22f7566970c5186d607cd827a5603a678815bd48d4a1eb2716f55c32494ec75eb665651da6a56e6a
'http://archive.ubuntu.com/ubuntu/pool/main/d/debianutils/debianutils_5.5-1ubuntu2.debian.tar.xz' debianutils_5.5-1ubuntu2.debian.tar.xz 68420 SHA512:62fca780251fdb3b434abe840683385d3187699cf0466333fc1894a225f256ab1f912e818bbb4b564b1083c2e05a7a199bb9cdcc56307e60ba68cacef72644cf
```

### `dpkg` source package: `defusedxml=0.7.1-1`

Binary Packages:

- `python3-defusedxml=0.7.1-1`

Licenses: (parsed from: `/usr/share/doc/python3-defusedxml/copyright`)

- `Python`

Source:

```console
$ apt-get source -qq --print-uris defusedxml=0.7.1-1
'http://archive.ubuntu.com/ubuntu/pool/main/d/defusedxml/defusedxml_0.7.1-1.dsc' defusedxml_0.7.1-1.dsc 2111 SHA512:0b931aa09bdfc912ceabf28d8cf00ae9d56b610c4f9ed46cd8a2cf7633f0d85c8b4d2303730a21b2033cf513695e94863887e6130156f78a99bcb0debe84065a
'http://archive.ubuntu.com/ubuntu/pool/main/d/defusedxml/defusedxml_0.7.1.orig.tar.gz' defusedxml_0.7.1.orig.tar.gz 34709 SHA512:4f536794b814291520c7db27765014c57f415554cff569cddab596b33e1aa03799aae9448fdaf07417d1a9f4d8782aa827d1b68aac6881ffe5c2ca9b8a40d864
'http://archive.ubuntu.com/ubuntu/pool/main/d/defusedxml/defusedxml_0.7.1-1.debian.tar.xz' defusedxml_0.7.1-1.debian.tar.xz 3936 SHA512:9495719eda83b13675a880519b2fb9f2f03beb3887c14a28eea918f6561289de5d0f5e514e5349f71cc50ecd6de84faf6301c9de1aedcb7c5ff5e789a7f1edbf
```

### `dpkg` source package: `diffutils=1:3.8-0ubuntu2`

Binary Packages:

- `diffutils=1:3.8-0ubuntu2`

Licenses: (parsed from: `/usr/share/doc/diffutils/copyright`)

- `GFDL`
- `GPL`

Source:

```console
$ apt-get source -qq --print-uris diffutils=1:3.8-0ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/d/diffutils/diffutils_3.8-0ubuntu2.dsc' diffutils_3.8-0ubuntu2.dsc 1821 SHA512:645b14680e3669261eb372ce523d8258ee65b010b4e290650f8a0a4c922a26f80ee381e3711b2bf01249d64e248c184f8898abc6e0e50cb9f64cbd647ab1f684
'http://archive.ubuntu.com/ubuntu/pool/main/d/diffutils/diffutils_3.8.orig.tar.xz' diffutils_3.8.orig.tar.xz 1585120 SHA512:279441270987e70d5ecfaf84b6285a4866929c43ec877e50f154a788858d548a8a316f2fc26ad62f7348c8d289cb29a09d06dfadce1806e3d8b4ea88c8b1aa7c
'http://archive.ubuntu.com/ubuntu/pool/main/d/diffutils/diffutils_3.8.orig.tar.xz.asc' diffutils_3.8.orig.tar.xz.asc 833 SHA512:0464ac89209411993800666b45ff90243d22fbda53bf1d71c6870d565b39cc8d9c54c141b9d297a181ce74ad8fb5313953f416bced179ff7728a52a3e9a4f5a5
'http://archive.ubuntu.com/ubuntu/pool/main/d/diffutils/diffutils_3.8-0ubuntu2.debian.tar.xz' diffutils_3.8-0ubuntu2.debian.tar.xz 11692 SHA512:fab99ca407c3b1bbc427ebf14595d540e6ad2957e9b43065005efd9d5b423e6a4d6d460cccd05faf5786193a5bf1cf46721743e580161d5004167eca15fc405b
```

### `dpkg` source package: `docopt=0.6.2-4`

Binary Packages:

- `python3-docopt=0.6.2-4`

Licenses: (parsed from: `/usr/share/doc/python3-docopt/copyright`)

- `GPL-3`
- `MIT/X11`

Source:

```console
$ apt-get source -qq --print-uris docopt=0.6.2-4
'http://archive.ubuntu.com/ubuntu/pool/universe/d/docopt/docopt_0.6.2-4.dsc' docopt_0.6.2-4.dsc 1954 SHA512:329587e671f6eb6b3b6e19e23e8cfe9f8dff7aa4c4c53c1d3fce88ccbb36ecf2548ac35f337cf38573ff42ec04a2fdd87ccfa6887a1b2fbff1d1fc2a9a0efa8c
'http://archive.ubuntu.com/ubuntu/pool/universe/d/docopt/docopt_0.6.2.orig.tar.gz' docopt_0.6.2.orig.tar.gz 26345 SHA512:228661924329682786b143f414c9df911016963cdc91ae6eba833285144e71744df507321a476b51f779e3ea270af6dc4e50edb8b0ee99674c19acccaab57a03
'http://archive.ubuntu.com/ubuntu/pool/universe/d/docopt/docopt_0.6.2-4.debian.tar.xz' docopt_0.6.2-4.debian.tar.xz 3888 SHA512:96051ef8ba014ac4fd76567a02bd7ad1e1e31adcad1fff1799f0665ef3bc1d87c1f7f86fe17e169eec33f4d83c87fee4b89f44e9c49882e872b579944299545b
```

### `dpkg` source package: `dpkg=1.21.1ubuntu2.3`

Binary Packages:

- `dpkg=1.21.1ubuntu2.3`

Licenses: (parsed from: `/usr/share/doc/dpkg/copyright`)

- `BSD-2-clause`
- `GPL-2`
- `GPL-2+`
- `public-domain-md5`
- `public-domain-s-s-d`

Source:

```console
$ apt-get source -qq --print-uris dpkg=1.21.1ubuntu2.3
'http://archive.ubuntu.com/ubuntu/pool/main/d/dpkg/dpkg_1.21.1ubuntu2.3.dsc' dpkg_1.21.1ubuntu2.3.dsc 2254 SHA512:1cbd80001036fd25817149fe11875dff0b9244cac328fdaccff12e33cd608e89c3572a8c044592e80eb8b4b29ce83a25bb9468d791e7f5a53e2f0d327d913d78
'http://archive.ubuntu.com/ubuntu/pool/main/d/dpkg/dpkg_1.21.1ubuntu2.3.tar.xz' dpkg_1.21.1ubuntu2.3.tar.xz 5017216 SHA512:c81a729a5bc7f73440eeb8c427f42691384dff7d0bd11edeaecead95b3931dd82d4ed70cac3f90befecc6ba6d3116c7a1782e455eee91fa4fe485fa625c04be7
```

### `dpkg` source package: `e2fsprogs=1.46.5-2ubuntu1.2`

Binary Packages:

- `e2fsprogs=1.46.5-2ubuntu1.2`
- `libcom-err2:amd64=1.46.5-2ubuntu1.2`
- `libext2fs2:amd64=1.46.5-2ubuntu1.2`
- `libss2:amd64=1.46.5-2ubuntu1.2`
- `logsave=1.46.5-2ubuntu1.2`

Licenses: (parsed from: `/usr/share/doc/e2fsprogs/copyright`, `/usr/share/doc/libcom-err2/copyright`, `/usr/share/doc/libext2fs2/copyright`, `/usr/share/doc/libss2/copyright`, `/usr/share/doc/logsave/copyright`)

- `GPL-2`
- `LGPL-2`

Source:

```console
$ apt-get source -qq --print-uris e2fsprogs=1.46.5-2ubuntu1.2
'http://archive.ubuntu.com/ubuntu/pool/main/e/e2fsprogs/e2fsprogs_1.46.5-2ubuntu1.2.dsc' e2fsprogs_1.46.5-2ubuntu1.2.dsc 3190 SHA512:8bf3cf7816ff7a774b03e846fcd90083083c1cd9072635d1eb45ba76c87ea8a1d9f7c5bf99f9a80ad1fed2c294425835ff801ada260b3417258d94cee3dc3758
'http://archive.ubuntu.com/ubuntu/pool/main/e/e2fsprogs/e2fsprogs_1.46.5.orig.tar.gz' e2fsprogs_1.46.5.orig.tar.gz 9530158 SHA512:1a3496cb6ac575c7a5c523cc4eede39bc77c313a6d1fea2d303fc967792d75d94e42d7821e1a61b7513509320aae4a7170506decf5753ddbd1dda9d304cc392e
'http://archive.ubuntu.com/ubuntu/pool/main/e/e2fsprogs/e2fsprogs_1.46.5.orig.tar.gz.asc' e2fsprogs_1.46.5.orig.tar.gz.asc 488 SHA512:b288fa2418a85750673743cb58faf10537e2c79a5c2ec8b0d59435316f00006424195556ccf78fa023b67b05a29cd85bf9d96c14c166847d71a1d79b189c1d05
'http://archive.ubuntu.com/ubuntu/pool/main/e/e2fsprogs/e2fsprogs_1.46.5-2ubuntu1.2.debian.tar.xz' e2fsprogs_1.46.5-2ubuntu1.2.debian.tar.xz 86604 SHA512:acb7f22a63d9c0e58d626af655cdcb6e6cfcedafdd7edbc6b7b757d1b388ee04c416db98c577a8cdf2259c46ea16a679f9be770374515b21d93bd0af66bd2a1d
```

### `dpkg` source package: `expat=2.4.7-1ubuntu0.4`

Binary Packages:

- `libexpat1:amd64=2.4.7-1ubuntu0.4`

Licenses: (parsed from: `/usr/share/doc/libexpat1/copyright`)

- `MIT`

Source:

```console
$ apt-get source -qq --print-uris expat=2.4.7-1ubuntu0.4
'http://archive.ubuntu.com/ubuntu/pool/main/e/expat/expat_2.4.7-1ubuntu0.4.dsc' expat_2.4.7-1ubuntu0.4.dsc 1962 SHA512:e6cdab825e628b38ecb908535f1cec5ac2289c53255e645b57b3269cf5deec21e3d64a802e288b0dda75dad0408c1fa8e64c921e611dcef5553e55f5fe2ddf44
'http://archive.ubuntu.com/ubuntu/pool/main/e/expat/expat_2.4.7.orig.tar.gz' expat_2.4.7.orig.tar.gz 8316374 SHA512:91bc9792c4ba1d0ad835f633d8cfa62130692f48308eea8932ec5e13a01542120561b0f255b4adc58b1adae6f83632cbabf428b5b5c0d2ac6de542478a951232
'http://archive.ubuntu.com/ubuntu/pool/main/e/expat/expat_2.4.7-1ubuntu0.4.debian.tar.xz' expat_2.4.7-1ubuntu0.4.debian.tar.xz 23076 SHA512:64348f4a3a8306c765c0cd3d1de57d484780d081d747889ff590309c8e0c30c229557d504528e29d3b48ad81bf534b7605c38e11da469c69ce48526af9b55078
```

### `dpkg` source package: `file=1:5.41-3ubuntu0.1`

Binary Packages:

- `libmagic-mgc=1:5.41-3ubuntu0.1`
- `libmagic1:amd64=1:5.41-3ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libmagic-mgc/copyright`, `/usr/share/doc/libmagic1/copyright`)

- `BSD-2-Clause-alike`
- `BSD-2-Clause-netbsd`
- `BSD-2-Clause-regents`
- `MIT-Old-Style-with-legal-disclaimer-2`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris file=1:5.41-3ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/f/file/file_5.41-3ubuntu0.1.dsc' file_5.41-3ubuntu0.1.dsc 2355 SHA512:6ef760d4a36e86233097281dfe3abd7d288459d4aae1b4e4d03754c614f7f76e329f3687f3d205e2c811a3cf7aa66be81bb6a723eec3a1f802b8b2637d3e39aa
'http://archive.ubuntu.com/ubuntu/pool/main/f/file/file_5.41.orig.tar.gz' file_5.41.orig.tar.gz 1064097 SHA512:bbf2d8e39450b31d0ba8d76d202790fea953775657f942f06e6dc9091798d4a395f7205e542388e4a25b6a4506d07f36c5c4da37cfce0734133e9203a3b00654
'http://archive.ubuntu.com/ubuntu/pool/main/f/file/file_5.41.orig.tar.gz.asc' file_5.41.orig.tar.gz.asc 169 SHA512:ce9c2b1ccb5900cd2e16f0a77b2e727cd472436355b846784d36b97c7239430eceb6101a2364f2dabeb6723bec38e8fa69ed09bfd859839b76701363fe88b590
'http://archive.ubuntu.com/ubuntu/pool/main/f/file/file_5.41-3ubuntu0.1.debian.tar.xz' file_5.41-3ubuntu0.1.debian.tar.xz 34768 SHA512:4fed522e15c3d7708b3e92a3e9b08b2294500ba71e72aa451643940696749d6a444c32b577687dd02ee94154e233703630237a803fddb723f9e93e453d2d77fe
```

### `dpkg` source package: `findutils=4.8.0-1ubuntu3`

Binary Packages:

- `findutils=4.8.0-1ubuntu3`

Licenses: (parsed from: `/usr/share/doc/findutils/copyright`)

- `GFDL-1.3`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris findutils=4.8.0-1ubuntu3
'http://archive.ubuntu.com/ubuntu/pool/main/f/findutils/findutils_4.8.0-1ubuntu3.dsc' findutils_4.8.0-1ubuntu3.dsc 2064 SHA512:3f0f5195138342ce515ff83f5e653457d78158c8b871ef04002adb4cc69cab6023c71f7d1032db7032d25806c22a8ad33dbf3007018d382968863521a33af2cd
'http://archive.ubuntu.com/ubuntu/pool/main/f/findutils/findutils_4.8.0.orig.tar.xz' findutils_4.8.0.orig.tar.xz 1983096 SHA512:eaa2da304dbeb2cd659b9210ac37da1bde4cd665c12a818eca98541c5ed5cba1050641fc0c39c0a446a5a7a87a8d654df0e0e6b0cee21752ea485188c9f1071e
'http://archive.ubuntu.com/ubuntu/pool/main/f/findutils/findutils_4.8.0.orig.tar.xz.asc' findutils_4.8.0.orig.tar.xz.asc 488 SHA512:e6ea8bd9a58ac4f787a9cc7dad9f75fab9e0623e7cda463bef60651c9319574ac7c8ba06f7d33cbead0ecb8788db71eb39f50550deb066d6d6baa625b0374a45
'http://archive.ubuntu.com/ubuntu/pool/main/f/findutils/findutils_4.8.0-1ubuntu3.debian.tar.xz' findutils_4.8.0-1ubuntu3.debian.tar.xz 27716 SHA512:f0ce8b61f4e0beabad3178424c804468dc4c57f37794887954df28c36227ce77f00383903274a1995a104f9def44270070b9e033eb46d52f5aaaedb1f5883587
```

### `dpkg` source package: `fontconfig=2.13.1-4.2ubuntu5`

Binary Packages:

- `fontconfig=2.13.1-4.2ubuntu5`
- `fontconfig-config=2.13.1-4.2ubuntu5`
- `libfontconfig1:amd64=2.13.1-4.2ubuntu5`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris fontconfig=2.13.1-4.2ubuntu5
'http://archive.ubuntu.com/ubuntu/pool/main/f/fontconfig/fontconfig_2.13.1-4.2ubuntu5.dsc' fontconfig_2.13.1-4.2ubuntu5.dsc 2449 SHA512:7d56f8d3b7f211ad464d20ed07b02cf38b0c10df1aa00ca8e899a734908b3342b1d67e32107231f983e473f64366444f06adb3b9c72cc2c2693aed427dda5114
'http://archive.ubuntu.com/ubuntu/pool/main/f/fontconfig/fontconfig_2.13.1.orig.tar.bz2' fontconfig_2.13.1.orig.tar.bz2 1723639 SHA512:f97f2a9db294fd72d416a7d76dd7db5934ade2cf76903764b09e7decc33e0e2eed1a1d35c5f1c7fd9ea39e2c7653b9e65365f0c6205e047e95e38ba5000dd100
'http://archive.ubuntu.com/ubuntu/pool/main/f/fontconfig/fontconfig_2.13.1-4.2ubuntu5.debian.tar.xz' fontconfig_2.13.1-4.2ubuntu5.debian.tar.xz 28084 SHA512:6321dd705cc0adb9330778675f4ee3545d7f22f1ec63439dab45592dda121c2c5f1b4aa8ae444db1151906c5e1f363f13f38075733649b543e4d5bf5222c0eed
```

### `dpkg` source package: `fonts-dejavu=2.37-2build1`

Binary Packages:

- `fonts-dejavu-core=2.37-2build1`

Licenses: (parsed from: `/usr/share/doc/fonts-dejavu-core/copyright`)

- `GPL-2`
- `GPL-2+`
- `bitstream-vera`

Source:

```console
$ apt-get source -qq --print-uris fonts-dejavu=2.37-2build1
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-dejavu/fonts-dejavu_2.37-2build1.dsc' fonts-dejavu_2.37-2build1.dsc 2411 SHA512:7821679b0f3cabaa4929b11a1a02fff21c05cef965efc399bf8a89b8549b1ac20cdd173c2cb31c397a345683b197623b97998b412c8458a135141ccd733b50d9
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-dejavu/fonts-dejavu_2.37.orig.tar.bz2' fonts-dejavu_2.37.orig.tar.bz2 12050109 SHA512:e61fc8c675ef76edb49dd9a8caee62087280929bb8144b52aca2f8def30025c56246589ad8a6a806b9574e6876eedd16d57c70a6ce9c86817a2dfe39d8a2bb2b
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-dejavu/fonts-dejavu_2.37-2build1.debian.tar.xz' fonts-dejavu_2.37-2build1.debian.tar.xz 11468 SHA512:b3c0cb3c81b3e4e9d76eefab010f447be973fa9e310960d2e3a1a2e845f4388e0508f8d18d519c7374c68c96c2e05a75f29ccf24135f6250a82181a77d8e9741
```

### `dpkg` source package: `fonts-font-awesome=5.0.10+really4.7.0~dfsg-4.1`

Binary Packages:

- `fonts-font-awesome=5.0.10+really4.7.0~dfsg-4.1`

Licenses: (parsed from: `/usr/share/doc/fonts-font-awesome/copyright`)

- `Expat`
- `GPL-3`
- `GPL-3+`
- `OFL-1.1`

Source:

```console
$ apt-get source -qq --print-uris fonts-font-awesome=5.0.10+really4.7.0~dfsg-4.1
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-font-awesome/fonts-font-awesome_5.0.10%2breally4.7.0%7edfsg-4.1.dsc' fonts-font-awesome_5.0.10+really4.7.0~dfsg-4.1.dsc 2322 SHA512:ddc4d0d9aee6c07212e3d791d37c723dd3abb6aecb5ce38fa4f23150c8a1201785e56b4363cb50e6eba8dfee01a68b91441f15d43371609977768b1db4d4d599
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-font-awesome/fonts-font-awesome_5.0.10%2breally4.7.0%7edfsg.orig.tar.gz' fonts-font-awesome_5.0.10+really4.7.0~dfsg.orig.tar.gz 675665 SHA512:92a85741928f1e192c98b34d27ccee97c35810ed8eecff7fabd5dd7e7c8bef6e989ef47bc08de135b7baaa9d9f48c2d7d223b0b183f6cb0db18f2b1146a30b27
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-font-awesome/fonts-font-awesome_5.0.10%2breally4.7.0%7edfsg-4.1.debian.tar.xz' fonts-font-awesome_5.0.10+really4.7.0~dfsg-4.1.debian.tar.xz 11068 SHA512:256ce9fc1ffa7246826f76fbf43e8e54df7533337c0ce6c0d08c9efa05cc4c8d731f1967651add793eb77b7877d26aa2fc80ac470f3966d9abe7db9f4c5dd405
```

### `dpkg` source package: `fonts-inconsolata=001.010-6build1`

Binary Packages:

- `fonts-inconsolata=001.010-6build1`

Licenses: (parsed from: `/usr/share/doc/fonts-inconsolata/copyright`)

- `Open Font License 1.0`
- `The packaging is released under the same license as the Font Software`

Source:

```console
$ apt-get source -qq --print-uris fonts-inconsolata=001.010-6build1
'http://archive.ubuntu.com/ubuntu/pool/universe/f/fonts-inconsolata/fonts-inconsolata_001.010-6build1.dsc' fonts-inconsolata_001.010-6build1.dsc 2183 SHA512:a62fdb71084acc94776b2fbb325c9dc787e04d878657436ea4c5905244546df1aeef3a74e3c3282f12624cb477465e6bb8538916f972d090257916f958018211
'http://archive.ubuntu.com/ubuntu/pool/universe/f/fonts-inconsolata/fonts-inconsolata_001.010.orig.tar.bz2' fonts-inconsolata_001.010.orig.tar.bz2 146357 SHA512:5fe71b028c5a22b6bced07ee7b237b2b420dc654d26d2b4582b4056ca5efeef256a401fa71e0706dc6d075ad23097678a2f3ab8ad543451ffebe364d45ffc8dd
'http://archive.ubuntu.com/ubuntu/pool/universe/f/fonts-inconsolata/fonts-inconsolata_001.010-6build1.debian.tar.xz' fonts-inconsolata_001.010-6build1.debian.tar.xz 5308 SHA512:c6b7e811e3d62e73877d093e914de20a3b3f816b18d8bd7aeca5db2738fdd88f8f94f3856017c3c4232092f57ecca8113487a59bc50639f070cc11e4ac5ac120
```

### `dpkg` source package: `fonts-noto-cjk=1:20220127+repack1-1`

Binary Packages:

- `fonts-noto-cjk=1:20220127+repack1-1`

Licenses: (parsed from: `/usr/share/doc/fonts-noto-cjk/copyright`)

- `GPL-3`
- `GPL-3+`
- `SIL-1.1`

Source:

```console
$ apt-get source -qq --print-uris fonts-noto-cjk=1:20220127+repack1-1
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-noto-cjk/fonts-noto-cjk_20220127%2brepack1-1.dsc' fonts-noto-cjk_20220127+repack1-1.dsc 2144 SHA512:ef64a017be251569abea9246e3dd780f49fa950d0a8203d696a9f4f2099df85aee48ad935e9a244d66b780fc159eea2a3ea5faf96fae56d68d09c1b1abb1289d
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-noto-cjk/fonts-noto-cjk_20220127%2brepack1.orig.tar.xz' fonts-noto-cjk_20220127+repack1.orig.tar.xz 233161132 SHA512:5a6bb98f1ab7053d182fa968a92dd67282437a11ceefa09c0544e0cde12b2ec37999326c449e751418ab48772e2f2e49720fde9617a287662a1ea7339bdd6910
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-noto-cjk/fonts-noto-cjk_20220127%2brepack1-1.debian.tar.xz' fonts-noto-cjk_20220127+repack1-1.debian.tar.xz 6320 SHA512:7c3e41475e99c4df71b60a18c81735067263fdd6ffda8f72688d70fcecbb3002dd5d69d1a19168b79dbab94f1257ccf8711cdbb7b79add125418def68cc52b9a
```

### `dpkg` source package: `fonts-roboto=2:0~20170802-3`

Binary Packages:

- `fonts-roboto-unhinted=2:0~20170802-3`

Licenses: (parsed from: `/usr/share/doc/fonts-roboto-unhinted/copyright`)

- `Apache-2.0`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris fonts-roboto=2:0~20170802-3
'http://archive.ubuntu.com/ubuntu/pool/universe/f/fonts-roboto/fonts-roboto_0%7e20170802-3.dsc' fonts-roboto_0~20170802-3.dsc 2043 SHA512:77add66bb6218c0c6b8e9c9f4bc0d739c0745627248707d3ca1532b242c954e4dc6a289b43e73b012066459c7bdb38baac910b848a24af2106249f1b7992f6d5
'http://archive.ubuntu.com/ubuntu/pool/universe/f/fonts-roboto/fonts-roboto_0%7e20170802.orig.tar.xz' fonts-roboto_0~20170802.orig.tar.xz 5960112 SHA512:a61189628869acac05551617acc882ec950e9dd6236f51762a71144f74e89bb3861320640e41743d34973b2555ac6522fb58fc23dad3c23a2675e4ab44b9c2cb
'http://archive.ubuntu.com/ubuntu/pool/universe/f/fonts-roboto/fonts-roboto_0%7e20170802-3.debian.tar.xz' fonts-roboto_0~20170802-3.debian.tar.xz 20488 SHA512:084c73517868dc59378e56062f954dc5c267c2c68c59022a7675f1712da1b81e64c32d49f2e3f78a0059bb7c792739e6f448564d465cfc42e2077bacfca8b255
```

### `dpkg` source package: `fonts-urw-base35=20200910-1`

Binary Packages:

- `fonts-urw-base35=20200910-1`

Licenses: (parsed from: `/usr/share/doc/fonts-urw-base35/copyright`)

- `AGPL-3`
- `AGPL-3 with Font exception`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris fonts-urw-base35=20200910-1
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-urw-base35/fonts-urw-base35_20200910-1.dsc' fonts-urw-base35_20200910-1.dsc 2061 SHA512:c49491d4a4cf3ffcceab733e64de6bcd460273d884b9db9cd74bb861cec5a01981e946f05b065351c631e376239f94cb2c8927675f8d95a82efd469bb82a4794
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-urw-base35/fonts-urw-base35_20200910.orig.tar.gz' fonts-urw-base35_20200910.orig.tar.gz 11190093 SHA512:71fb27baadf5abc4ff624cdede02038681acd5fffdc728a5b2e7808713b80cb2f2174f90a1862e69d390c4434c49d5167ab095100032fa3ba80b586eb8ae51d1
'http://archive.ubuntu.com/ubuntu/pool/main/f/fonts-urw-base35/fonts-urw-base35_20200910-1.debian.tar.xz' fonts-urw-base35_20200910-1.debian.tar.xz 17772 SHA512:ca14ee4917425f04197c481139831dbc07e5cd0dca316b464ca6f67639077fd39d5d17dea4d00b6bce02a6338ba43b40b520cb8210cec9951255a4ab7093f7dd
```

### `dpkg` source package: `freetype=2.11.1+dfsg-1ubuntu0.2`

Binary Packages:

- `libfreetype6:amd64=2.11.1+dfsg-1ubuntu0.2`

Licenses: (parsed from: `/usr/share/doc/libfreetype6/copyright`)

- `BSD-3-Clause`
- `BSL-1.0`
- `FSFAP`
- `FTL`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `MIT`
- `OpenGroup-BSD-like`
- `Public-Domain`
- `Zlib`

Source:

```console
$ apt-get source -qq --print-uris freetype=2.11.1+dfsg-1ubuntu0.2
'http://archive.ubuntu.com/ubuntu/pool/main/f/freetype/freetype_2.11.1%2bdfsg-1ubuntu0.2.dsc' freetype_2.11.1+dfsg-1ubuntu0.2.dsc 3791 SHA512:643a9c86c6d1d8e9b41dc168688516dfe57bc365298e5b42c52f10cbbbf1d3372c9648f8b207bd211fd5ee69e7cb946bf5f6c804c5d8fbc3a428a0d96f178929
'http://archive.ubuntu.com/ubuntu/pool/main/f/freetype/freetype_2.11.1%2bdfsg.orig-ft2demos.tar.xz' freetype_2.11.1+dfsg.orig-ft2demos.tar.xz 257240 SHA512:93d68daefa8a49b4fc987a7356133299fe2a8e012415ea09ad7616ececcfd978fdf9fc7a2d855f7488f51a497d019acb89ef5774484babae66357b3083a883c5
'http://archive.ubuntu.com/ubuntu/pool/main/f/freetype/freetype_2.11.1%2bdfsg.orig-ft2demos.tar.xz.asc' freetype_2.11.1+dfsg.orig-ft2demos.tar.xz.asc 195 SHA512:407ffade07cc62c8838d26670dffc7c26b9baf4984c42b2b2467279dabda855536b403f5a7e9dc64a787163657ca81019fef6d1879973faf180d6230ab17cd05
'http://archive.ubuntu.com/ubuntu/pool/main/f/freetype/freetype_2.11.1%2bdfsg.orig-ft2docs.tar.xz' freetype_2.11.1+dfsg.orig-ft2docs.tar.xz 2038348 SHA512:c5e19d98425491682edc58230c48390925cc4b466169f655cf3b8575ba787a70feecdeb7a16224b132dcc32f17b041483d84056cda8e3132d98b531e46a26c36
'http://archive.ubuntu.com/ubuntu/pool/main/f/freetype/freetype_2.11.1%2bdfsg.orig-ft2docs.tar.xz.asc' freetype_2.11.1+dfsg.orig-ft2docs.tar.xz.asc 195 SHA512:df946695a1fbaa71009f48a8f0860177984728ec1c73385d1e55c07be027dd6a5e634c9dcbb49c51f8143b0d56a6cbf06393403341fb28cea7a8a2cc9a9c5592
'http://archive.ubuntu.com/ubuntu/pool/main/f/freetype/freetype_2.11.1%2bdfsg.orig.tar.xz' freetype_2.11.1+dfsg.orig.tar.xz 1988020 SHA512:6a9a0379679abf127761cabb2da39b8faf2ca4c322075da9b86d93363ac81ce909b9544377a784118ba91ca008baa680b9da474bd2da1bfe928d5a4c9114cb08
'http://archive.ubuntu.com/ubuntu/pool/main/f/freetype/freetype_2.11.1%2bdfsg-1ubuntu0.2.debian.tar.xz' freetype_2.11.1+dfsg-1ubuntu0.2.debian.tar.xz 41920 SHA512:5ebb72c4c47997c74da26fe13b796a558f7b4e2075743a55ba6a0079cd30c713aac3499ddbb05f6cbf408d383028743b41d9839531c906bf41d5ad725c9d5b04
```

### `dpkg` source package: `freezegun=1.1.0-1`

Binary Packages:

- `python3-freezegun=1.1.0-1`

Licenses: (parsed from: `/usr/share/doc/python3-freezegun/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris freezegun=1.1.0-1
'http://archive.ubuntu.com/ubuntu/pool/universe/f/freezegun/freezegun_1.1.0-1.dsc' freezegun_1.1.0-1.dsc 2069 SHA512:00a7220da238dea219621519266d9fbd272c5767c6102d4bf2e5be8478ba5385f138d5e253a7943496f868536f7cba1c3402c2920b4cae37f05e9800a99577f6
'http://archive.ubuntu.com/ubuntu/pool/universe/f/freezegun/freezegun_1.1.0.orig.tar.gz' freezegun_1.1.0.orig.tar.gz 25891 SHA512:eb3ddc01bd04ab3ee66f50e8b5fc73aaedaca2111e770bd941b6e13c497fff4c1eb0da930e3922829980e587c6e65ba7326909becd0233f5b6124ab3726218f2
'http://archive.ubuntu.com/ubuntu/pool/universe/f/freezegun/freezegun_1.1.0-1.debian.tar.xz' freezegun_1.1.0-1.debian.tar.xz 2664 SHA512:fa20561b6bae197a42badbf494f8d2d22585be4dd726ae5679e2ef4175eb115ec57cf54f5162a204453d244bf205af0afc7792cb8f4e18332d8ebb923802bd0a
```

### `dpkg` source package: `fribidi=1.0.8-2ubuntu3.1`

Binary Packages:

- `libfribidi0:amd64=1.0.8-2ubuntu3.1`

Licenses: (parsed from: `/usr/share/doc/libfribidi0/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris fribidi=1.0.8-2ubuntu3.1
'http://archive.ubuntu.com/ubuntu/pool/main/f/fribidi/fribidi_1.0.8-2ubuntu3.1.dsc' fribidi_1.0.8-2ubuntu3.1.dsc 2442 SHA512:977cb7df4e1877f0f6d5f58620cfacbb1e25090c2bfd70c71576ada3c9f11f260ed11fb0fd64a5f5bf8cfc8c419a865e0e9b9084f224deb9dfadf1b2e3bd17e9
'http://archive.ubuntu.com/ubuntu/pool/main/f/fribidi/fribidi_1.0.8.orig.tar.bz2' fribidi_1.0.8.orig.tar.bz2 2077095 SHA512:d66b1524b26d227fd6a628f438efb875c023ae3be708acaaad11f1f62d0902de0a5f57124458291ef2b0fcd89356c52ab8ae5559b0b5a93fa435b92f1d098ba2
'http://archive.ubuntu.com/ubuntu/pool/main/f/fribidi/fribidi_1.0.8-2ubuntu3.1.debian.tar.xz' fribidi_1.0.8-2ubuntu3.1.debian.tar.xz 10888 SHA512:16e448db2038b60b3a086117774e734b1d3ed08ae09cfa1b591f5a95c6372778705ba8940dd464537d5a6e932528c1c1e01376670992580529090f20142d171a
```

### `dpkg` source package: `gcc-12=12.3.0-1ubuntu1~22.04`

Binary Packages:

- `gcc-12-base:amd64=12.3.0-1ubuntu1~22.04`
- `libgcc-s1:amd64=12.3.0-1ubuntu1~22.04`
- `libgomp1:amd64=12.3.0-1ubuntu1~22.04`
- `libstdc++6:amd64=12.3.0-1ubuntu1~22.04`

Licenses: (parsed from: `/usr/share/doc/gcc-12-base/copyright`, `/usr/share/doc/libgcc-s1/copyright`, `/usr/share/doc/libgomp1/copyright`, `/usr/share/doc/libstdc++6/copyright`)

- `Artistic`
- `GFDL-1.2`
- `GPL`
- `GPL-2`
- `GPL-3`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris gcc-12=12.3.0-1ubuntu1~22.04
'http://archive.ubuntu.com/ubuntu/pool/main/g/gcc-12/gcc-12_12.3.0-1ubuntu1%7e22.04.dsc' gcc-12_12.3.0-1ubuntu1~22.04.dsc 27867 SHA512:68c0860bb1f453ad06334504034c575bed05512ef2a94599e8bbf57a25ed51dc9a429f4646848c8d98e0d4695f1319fac5d5ebbee3a0f8eecdb279b75936a875
'http://archive.ubuntu.com/ubuntu/pool/main/g/gcc-12/gcc-12_12.3.0.orig.tar.gz' gcc-12_12.3.0.orig.tar.gz 91555468 SHA512:a33ce506594e13cf96f0419e6d62b71f8906c87c69426218bf8679d281865f1b170bc2f7379216ae1d6ad9f6bdbf5819c34c65c7537fdb74179c27b0d4ab7b48
'http://archive.ubuntu.com/ubuntu/pool/main/g/gcc-12/gcc-12_12.3.0-1ubuntu1%7e22.04.debian.tar.xz' gcc-12_12.3.0-1ubuntu1~22.04.debian.tar.xz 575908 SHA512:d1bf37d9af699430d3b107d0966194b20aef22654337efdb99971b270609785020dd1f04ce6a0f3f3eb0dbad704b46e9d9e5dfa6a497e98c78a867f5bc290038
```

### `dpkg` source package: `gdbm=1.23-1`

Binary Packages:

- `libgdbm-compat4:amd64=1.23-1`
- `libgdbm6:amd64=1.23-1`

Licenses: (parsed from: `/usr/share/doc/libgdbm-compat4/copyright`, `/usr/share/doc/libgdbm6/copyright`)

- `GFDL-NIV-1.3+`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris gdbm=1.23-1
'http://archive.ubuntu.com/ubuntu/pool/main/g/gdbm/gdbm_1.23-1.dsc' gdbm_1.23-1.dsc 2583 SHA512:f931348ff659e5f9485fe92734b02c426b6428e41e2abc180b131183e8ca437c5287a7f88854f788e5111efbed114b5eda2b66c24318b39e88661ddbbb39ce15
'http://archive.ubuntu.com/ubuntu/pool/main/g/gdbm/gdbm_1.23.orig.tar.gz' gdbm_1.23.orig.tar.gz 1115854 SHA512:918080cb0225b221c11eb7339634a95e00c526072395f7a3d46ccf42ef020dea7c4c5bec34aff2c4f16033e1fff6583252b7e978f68b8d7f8736b0e025838e10
'http://archive.ubuntu.com/ubuntu/pool/main/g/gdbm/gdbm_1.23.orig.tar.gz.asc' gdbm_1.23.orig.tar.gz.asc 181 SHA512:6653751c04584f10aa3325bd1cb5b9f7970a786dd2a99602ea620c11a86a9ba5c342aa52627bd06c03da822e9e1600dc034d9a8f42856a287fd67f6b9f161c71
'http://archive.ubuntu.com/ubuntu/pool/main/g/gdbm/gdbm_1.23-1.debian.tar.xz' gdbm_1.23-1.debian.tar.xz 18484 SHA512:e7ca0a608da94e5b5bc5949e27b794c87e032202eb09359ad55f6c1a7a6e895f01126781a4e0fbfdb8fef3de7c4a312b9d5a653aaf55ce8c5afbceb945945253
```

### `dpkg` source package: `glib2.0=2.72.4-0ubuntu2.3`

Binary Packages:

- `libglib2.0-0:amd64=2.72.4-0ubuntu2.3`

Licenses: (parsed from: `/usr/share/doc/libglib2.0-0/copyright`)

- `Expat`
- `GPL-2+`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris glib2.0=2.72.4-0ubuntu2.3
'http://archive.ubuntu.com/ubuntu/pool/main/g/glib2.0/glib2.0_2.72.4-0ubuntu2.3.dsc' glib2.0_2.72.4-0ubuntu2.3.dsc 3670 SHA512:bea1f5359cdfc0cf6403812b87263221523a54e50726fa7a2232e08f0eda35e3e23c6b98d1a978bfe141fc9a50732a335e5f7570489dafd042038f4ed2534f1e
'http://archive.ubuntu.com/ubuntu/pool/main/g/glib2.0/glib2.0_2.72.4.orig.tar.xz' glib2.0_2.72.4.orig.tar.xz 4884256 SHA512:b4e2e0985e2184ee9656c4f1b4e15d8d1264f3d23d31349bc43d92e8432cffa48e1685c40517efb08dc5b57b8285acf65f2747deeb50e50d9cacec7160e7edf8
'http://archive.ubuntu.com/ubuntu/pool/main/g/glib2.0/glib2.0_2.72.4-0ubuntu2.3.debian.tar.xz' glib2.0_2.72.4-0ubuntu2.3.debian.tar.xz 146736 SHA512:0c94042cdadf2ead450f5bc97e06fd503e4954488d423f08280a050098d3a7a4203640f7e677d2d567d5d44b73ec94d297d77ffb8d3452bb947b78c87c9d8221
```

### `dpkg` source package: `glibc=2.35-0ubuntu3.8`

Binary Packages:

- `libc-bin=2.35-0ubuntu3.8`
- `libc6:amd64=2.35-0ubuntu3.8`

Licenses: (parsed from: `/usr/share/doc/libc-bin/copyright`, `/usr/share/doc/libc6/copyright`)

- `GFDL-1.3`
- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris glibc=2.35-0ubuntu3.8
'http://archive.ubuntu.com/ubuntu/pool/main/g/glibc/glibc_2.35-0ubuntu3.8.dsc' glibc_2.35-0ubuntu3.8.dsc 8917 SHA512:65d4e9f4ff2556677cf3b723560d89d889754f7c49af563e25e7bd1e7e1b211c4008e149d1b889a626d19b0a001050fd84ffe05f3ede4a6b03fd759e2c60c3b9
'http://archive.ubuntu.com/ubuntu/pool/main/g/glibc/glibc_2.35.orig.tar.xz' glibc_2.35.orig.tar.xz 18165952 SHA512:e7336ce27561be5d7c217832a1136fb327e057bd8d3f92925b35c97e3e9f9e486948b5a1e03e5e4090772ef06437a074d10b82e68f17f1ad8f22077ee39e1b66
'http://archive.ubuntu.com/ubuntu/pool/main/g/glibc/glibc_2.35.orig.tar.xz.asc' glibc_2.35.orig.tar.xz.asc 833 SHA512:2a1c152511dac05f9b4e48f7e7a6b59dbf2d8b71fea54f128173113357be26e86216e13c9865f617049e6858396a221a5abc704f65a786b22453945fd80265e9
'http://archive.ubuntu.com/ubuntu/pool/main/g/glibc/glibc_2.35-0ubuntu3.8.debian.tar.xz' glibc_2.35-0ubuntu3.8.debian.tar.xz 937424 SHA512:4bd814571a66097dd9bf9c87c62ca9ea9e29b3a9c193be6b7a1dc25cf672641addce7c100e95e86d6fb4e4ee6f88eb847e6766285b60c6953587789d05f48abd
```

### `dpkg` source package: `gmp=2:6.2.1+dfsg-3ubuntu1`

Binary Packages:

- `libgmp10:amd64=2:6.2.1+dfsg-3ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libgmp10/copyright`)

- `GPL`
- `GPL-2`
- `GPL-3`
- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris gmp=2:6.2.1+dfsg-3ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/g/gmp/gmp_6.2.1%2bdfsg-3ubuntu1.dsc' gmp_6.2.1+dfsg-3ubuntu1.dsc 2355 SHA512:b41211a64cba1afee1ea7924d38581b26b36f0495ad42be6d25b7175d5fa1e000378a5d36dd80087b0e7d4495620edb1e7e1b32d6c1085a8cdf0a4cb460a0558
'http://archive.ubuntu.com/ubuntu/pool/main/g/gmp/gmp_6.2.1%2bdfsg.orig.tar.xz' gmp_6.2.1+dfsg.orig.tar.xz 1853476 SHA512:801948b7dcf592959ea387a86bee34dfb4e02c5e93815a785fc46174899ba22129853a3e34109a6df86048a144765c5f39e65fddfcecba879cc60da62f32fea0
'http://archive.ubuntu.com/ubuntu/pool/main/g/gmp/gmp_6.2.1%2bdfsg-3ubuntu1.debian.tar.xz' gmp_6.2.1+dfsg-3ubuntu1.debian.tar.xz 40996 SHA512:d7e0a1165a42b11a26a0f9232193db41ce2e7b1f5ea50d258e156fc9d80f9a74b6739491ec73cc1e909a3d09e029f90c3be1460c993690c5081ef8c6a169a4c3
```

### `dpkg` source package: `gnupg2=2.2.27-3ubuntu2.1`

Binary Packages:

- `dirmngr=2.2.27-3ubuntu2.1`
- `gnupg=2.2.27-3ubuntu2.1`
- `gnupg-l10n=2.2.27-3ubuntu2.1`
- `gnupg-utils=2.2.27-3ubuntu2.1`
- `gpg=2.2.27-3ubuntu2.1`
- `gpg-agent=2.2.27-3ubuntu2.1`
- `gpg-wks-client=2.2.27-3ubuntu2.1`
- `gpg-wks-server=2.2.27-3ubuntu2.1`
- `gpgconf=2.2.27-3ubuntu2.1`
- `gpgsm=2.2.27-3ubuntu2.1`
- `gpgv=2.2.27-3ubuntu2.1`

Licenses: (parsed from: `/usr/share/doc/dirmngr/copyright`, `/usr/share/doc/gnupg/copyright`, `/usr/share/doc/gnupg-l10n/copyright`, `/usr/share/doc/gnupg-utils/copyright`, `/usr/share/doc/gpg/copyright`, `/usr/share/doc/gpg-agent/copyright`, `/usr/share/doc/gpg-wks-client/copyright`, `/usr/share/doc/gpg-wks-server/copyright`, `/usr/share/doc/gpgconf/copyright`, `/usr/share/doc/gpgsm/copyright`, `/usr/share/doc/gpgv/copyright`)

- `BSD-3-clause`
- `CC0-1.0`
- `Expat`
- `GPL-3`
- `GPL-3+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `LGPL-3`
- `LGPL-3+`
- `RFC-Reference`
- `TinySCHEME`
- `permissive`

Source:

```console
$ apt-get source -qq --print-uris gnupg2=2.2.27-3ubuntu2.1
'http://archive.ubuntu.com/ubuntu/pool/main/g/gnupg2/gnupg2_2.2.27-3ubuntu2.1.dsc' gnupg2_2.2.27-3ubuntu2.1.dsc 3726 SHA512:ed001ea6507654af663bfb1bfc051cd8a2deb9b8bb5b16273f7c3aa82141bdbc1cb2e85bf0cb61a26ea474f0df43e9a34c687722f757ed99bbd86b9a08866744
'http://archive.ubuntu.com/ubuntu/pool/main/g/gnupg2/gnupg2_2.2.27.orig.tar.bz2' gnupg2_2.2.27.orig.tar.bz2 7191555 SHA512:cf336962116c9c08ac80b1299654b94948033ef51d6d5e7f54c2f07bbf7d92c7b0bddb606ceee2cdd837063f519b8d59af5a82816b840a0fc47d90c07b0e95ab
'http://archive.ubuntu.com/ubuntu/pool/main/g/gnupg2/gnupg2_2.2.27-3ubuntu2.1.debian.tar.xz' gnupg2_2.2.27-3ubuntu2.1.debian.tar.xz 66676 SHA512:6f8aea12b515ef1b8558ac925bb84ae6f1743739c0edfc64e02952479d4a1271f8f6ee8fc23461164116f3f8396376009ed1ea609c55a59e4936f7d02b1f828a
```

### `dpkg` source package: `gnutls28=3.7.3-4ubuntu1.5`

Binary Packages:

- `libgnutls30:amd64=3.7.3-4ubuntu1.5`

Licenses: (parsed from: `/usr/share/doc/libgnutls30/copyright`)

- `Apache-2.0`
- `BSD-3-Clause`
- `CC0 license`
- `Expat`
- `GFDL-1.3`
- `GPL`
- `GPL-3`
- `GPLv3+`
- `LGPL`
- `LGPL-3`
- `LGPLv2.1+`
- `LGPLv3+_or_GPLv2+`
- `The main library is licensed under GNU Lesser`

Source:

```console
$ apt-get source -qq --print-uris gnutls28=3.7.3-4ubuntu1.5
'http://archive.ubuntu.com/ubuntu/pool/main/g/gnutls28/gnutls28_3.7.3-4ubuntu1.5.dsc' gnutls28_3.7.3-4ubuntu1.5.dsc 3572 SHA512:0a38fab364da93670bcdcdca4638301cf7bf9ec3f6a2969ceb07c3bdd9483c1898fc75c9a0c30087dfa4507266327c18240ce2448d866ca47ede6d2d944a4581
'http://archive.ubuntu.com/ubuntu/pool/main/g/gnutls28/gnutls28_3.7.3.orig.tar.xz' gnutls28_3.7.3.orig.tar.xz 6119292 SHA512:3ace744affe23e284342658d6d2d2de49dd50065489cbc8be18fc7d38187253e5268ca54027ce5cd517056c249ac039a7481e4548cec04325de37ae85617d077
'http://archive.ubuntu.com/ubuntu/pool/main/g/gnutls28/gnutls28_3.7.3.orig.tar.xz.asc' gnutls28_3.7.3.orig.tar.xz.asc 833 SHA512:cd0d30298377deddf20a835863b71e3f119588061f659906ad2684004758943179531508b1c77c730e930e2131148095e60ad9be365353cce772472d5f5345df
'http://archive.ubuntu.com/ubuntu/pool/main/g/gnutls28/gnutls28_3.7.3-4ubuntu1.5.debian.tar.xz' gnutls28_3.7.3-4ubuntu1.5.debian.tar.xz 88576 SHA512:aab7435e49efb1d7b8e4dd84c9fec9a9e68d56b6b78e95de9accfc7d3ec390ed397014374e22a86d0a193f01e8eba5bf46c85ef37c1794b51c673f3582fe2e35
```

### `dpkg` source package: `graphite2=1.3.14-1build2`

Binary Packages:

- `libgraphite2-3:amd64=1.3.14-1build2`

Licenses: (parsed from: `/usr/share/doc/libgraphite2-3/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`
- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `MPL-1.1`
- `custom-sil-open-font-license`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris graphite2=1.3.14-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/g/graphite2/graphite2_1.3.14-1build2.dsc' graphite2_1.3.14-1build2.dsc 2262 SHA512:c1c167d90602a7f072189d046304af17a2a3e61509405c3623a56231f7c8341091bb2da2c73bfc41c1a3fc60a1f1b585476aec2a932767e3c31a400d37f50966
'http://archive.ubuntu.com/ubuntu/pool/main/g/graphite2/graphite2_1.3.14.orig.tar.gz' graphite2_1.3.14.orig.tar.gz 6629829 SHA512:49d127964d3f5c9403c7aecbfb5b18f32f25fe4919a81c49e0534e7123fe845423e16b0b8c8baaae21162b1150ab3e0f1c22c344e07d4364b6b8473c40a0822c
'http://archive.ubuntu.com/ubuntu/pool/main/g/graphite2/graphite2_1.3.14-1build2.debian.tar.xz' graphite2_1.3.14-1build2.debian.tar.xz 12224 SHA512:7c69742dc115a123eaba93092ad67c06e43e8538c04269e05fa06cb12802b9f331f52161c3ff0ddd0520ccad6993c30102f149ac1694552594a3db5f1c07a209
```

### `dpkg` source package: `graphviz=2.42.2-6ubuntu0.1`

Binary Packages:

- `graphviz=2.42.2-6ubuntu0.1`
- `libcdt5:amd64=2.42.2-6ubuntu0.1`
- `libcgraph6:amd64=2.42.2-6ubuntu0.1`
- `libgvc6=2.42.2-6ubuntu0.1`
- `libgvpr2:amd64=2.42.2-6ubuntu0.1`
- `liblab-gamut1:amd64=2.42.2-6ubuntu0.1`
- `libpathplan4:amd64=2.42.2-6ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/graphviz/copyright`, `/usr/share/doc/libcdt5/copyright`, `/usr/share/doc/libcgraph6/copyright`, `/usr/share/doc/libgvc6/copyright`, `/usr/share/doc/libgvpr2/copyright`, `/usr/share/doc/liblab-gamut1/copyright`, `/usr/share/doc/libpathplan4/copyright`)

- `EPL-1.0`
- `MIT`
- `X/MIT`
- `zlib-style`

Source:

```console
$ apt-get source -qq --print-uris graphviz=2.42.2-6ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/universe/g/graphviz/graphviz_2.42.2-6ubuntu0.1.dsc' graphviz_2.42.2-6ubuntu0.1.dsc 3293 SHA512:15bdab56f043b81ffd0a6d6547b40ab9b09c10d392079b1a65c2fa5f16391fa2e3626d215293a7c9b126ce798faabc5b95a9eea5a1b7cc15a4ab6fb9e11c5675
'http://archive.ubuntu.com/ubuntu/pool/universe/g/graphviz/graphviz_2.42.2.orig.tar.bz2' graphviz_2.42.2.orig.tar.bz2 30740923 SHA512:7dab159539179df1febf4396d6bea2c071e0f311745941a07861d54b1db96a52f1328bee08148e099fa06ce5f1c9a9b6272ba60bb6147bf51b55de881a431fb3
'http://archive.ubuntu.com/ubuntu/pool/universe/g/graphviz/graphviz_2.42.2-6ubuntu0.1.debian.tar.xz' graphviz_2.42.2-6ubuntu0.1.debian.tar.xz 38988 SHA512:937c0a00e72b9a7be4d1690f5aa406bf36ddf9bb848dade4a130c012278a95520614f01103971be226ed7ac4a4100b8d6f1c2489e09403fc8578f8e026ef928e
```

### `dpkg` source package: `grep=3.7-1build1`

Binary Packages:

- `grep=3.7-1build1`

Licenses: (parsed from: `/usr/share/doc/grep/copyright`)

- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris grep=3.7-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/g/grep/grep_3.7-1build1.dsc' grep_3.7-1build1.dsc 1900 SHA512:3345c289bc163924615d3bc9ac3138e35870715d38223ef9d38a90ab17160fc415f8c0c9a5da1939143e2701e46fc854b27b45c280c4af686db2208f2becbe4f
'http://archive.ubuntu.com/ubuntu/pool/main/g/grep/grep_3.7.orig.tar.xz' grep_3.7.orig.tar.xz 1641196 SHA512:e9e45dcd40af8367f819f2b93c5e1b4e98a251a9aa251841fa67a875380fae52cfa27c68c6dbdd6a4dde1b1017ee0f6b9833ef6dd6e419d32d71b6df5e972b82
'http://archive.ubuntu.com/ubuntu/pool/main/g/grep/grep_3.7.orig.tar.xz.asc' grep_3.7.orig.tar.xz.asc 833 SHA512:9db28883b696fbbb0fad32f4ecd168954dc475d5f0a8f2b4f960ff615ef7dd8348a7caaee85a96287824472a29485ff921af121c582083ca5ad5c30960f99cf4
'http://archive.ubuntu.com/ubuntu/pool/main/g/grep/grep_3.7-1build1.debian.tar.xz' grep_3.7-1build1.debian.tar.xz 18184 SHA512:cbefc3635a0b0acc33d8a052d3ca7d583adbd1bcfc384559076b5e4f5508b4a8301b0dd54a029aecbab925a6f916c99a2d5bebe0a6936fe5ffeb5a07a0d9a917
```

### `dpkg` source package: `gsfonts=1:8.11+urwcyr1.0.7~pre44-4.5`

Binary Packages:

- `gsfonts=1:8.11+urwcyr1.0.7~pre44-4.5`

Licenses: (parsed from: `/usr/share/doc/gsfonts/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris gsfonts=1:8.11+urwcyr1.0.7~pre44-4.5
'http://archive.ubuntu.com/ubuntu/pool/universe/g/gsfonts/gsfonts_8.11%2burwcyr1.0.7%7epre44-4.5.dsc' gsfonts_8.11+urwcyr1.0.7~pre44-4.5.dsc 1986 SHA512:3e6072e0cb823d8152630a2d9c4e82afa03f1e1ab2a0a6a190194ae2a732decfcdce823d00e4949dddee3ce96b754a5717841024d04b62eb736431af45c7d5ff
'http://archive.ubuntu.com/ubuntu/pool/universe/g/gsfonts/gsfonts_8.11%2burwcyr1.0.7%7epre44.orig.tar.gz' gsfonts_8.11+urwcyr1.0.7~pre44.orig.tar.gz 3390551 SHA512:04c41aa9052ee666205acb1cdcaaeec211038da9c09ba20ba513cf1f8900ffb44a56776b837c0031355b0cee6aae1ed63e40e0febe5f96c1c7fd95831ecd388b
'http://archive.ubuntu.com/ubuntu/pool/universe/g/gsfonts/gsfonts_8.11%2burwcyr1.0.7%7epre44-4.5.diff.gz' gsfonts_8.11+urwcyr1.0.7~pre44-4.5.diff.gz 7023 SHA512:d712a83ef9356083fc33fac15209736e9bb73af21e598d495a7fa7d53d067e743fd5d97ee69bc7d6e631cd62b1bcd915cad4b9dd8ad7dd5cf820bb28046fca7b
```

### `dpkg` source package: `gts=0.7.6+darcs121130-5`

Binary Packages:

- `libgts-0.7-5:amd64=0.7.6+darcs121130-5`

Licenses: (parsed from: `/usr/share/doc/libgts-0.7-5/copyright`)

- `LGPL-2`
- `LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris gts=0.7.6+darcs121130-5
'http://archive.ubuntu.com/ubuntu/pool/universe/g/gts/gts_0.7.6%2bdarcs121130-5.dsc' gts_0.7.6+darcs121130-5.dsc 2109 SHA512:f21c97dde3e495778bc0a2794f5db0fba90796fbe33ba9e71326e39894a14fa6a86822e7ea690165379bbe244586eb03326d4a474e3d9adcbca12d4a4000bb8b
'http://archive.ubuntu.com/ubuntu/pool/universe/g/gts/gts_0.7.6%2bdarcs121130.orig.tar.gz' gts_0.7.6+darcs121130.orig.tar.gz 880569 SHA512:84c38dc345830eea75755d9d55235b6d76786a84c3b9c3b7e057437bf395a9f2687596bbf037afd601b9f31a485d425a371ca5e60680265f10cb414400db4142
'http://archive.ubuntu.com/ubuntu/pool/universe/g/gts/gts_0.7.6%2bdarcs121130-5.debian.tar.xz' gts_0.7.6+darcs121130-5.debian.tar.xz 13344 SHA512:d1c066ff5ee677e976b9e3cbc4f68cba78a61035b562cdc6fd41ea798a069a26bffc1fa1ccd6e015df59b1a28abbe09e8bdb16529835bd7c5af30f81a7ee83a0
```

### `dpkg` source package: `gyp=0.1+20210831gitd6c5dd5-5`

Binary Packages:

- `gyp=0.1+20210831gitd6c5dd5-5`

Licenses: (parsed from: `/usr/share/doc/gyp/copyright`)

- `BSD-3-clause~Google`

Source:

```console
$ apt-get source -qq --print-uris gyp=0.1+20210831gitd6c5dd5-5
'http://archive.ubuntu.com/ubuntu/pool/universe/g/gyp/gyp_0.1%2b20210831gitd6c5dd5-5.dsc' gyp_0.1+20210831gitd6c5dd5-5.dsc 2270 SHA512:ba22598e82e3c240abe6e72a1cbbaf69cb77776cbda8708e364280d49e49e72847cf0b892b5f748bd7a3f1e811f58eda9d6ab852877f9c1a2ca86222b76b443f
'http://archive.ubuntu.com/ubuntu/pool/universe/g/gyp/gyp_0.1%2b20210831gitd6c5dd5.orig.tar.xz' gyp_0.1+20210831gitd6c5dd5.orig.tar.xz 443512 SHA512:dc5406ae33c1d8cf7b988d2cf563950329bb5eac6b1a6f60b57f56d30ab2add927eb361f2128e3246fb364a8e30f2d17c4890ef01853546fda72d979e02e5ae2
'http://archive.ubuntu.com/ubuntu/pool/universe/g/gyp/gyp_0.1%2b20210831gitd6c5dd5-5.debian.tar.xz' gyp_0.1+20210831gitd6c5dd5-5.debian.tar.xz 13928 SHA512:1896be7fd2fe55dab36deff83858997b6da71a4a4100d4a210532dd7b57d5f31ac20ad8c6eb5c5cf35570cf3cbb24907b50232deb2931f3e1a4334a8a79e41f4
```

### `dpkg` source package: `gzip=1.10-4ubuntu4.1`

Binary Packages:

- `gzip=1.10-4ubuntu4.1`

Licenses: (parsed from: `/usr/share/doc/gzip/copyright`)

- `FSF-manpages`
- `GFDL-1.3+-no-invariant`
- `GFDL-3`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris gzip=1.10-4ubuntu4.1
'http://archive.ubuntu.com/ubuntu/pool/main/g/gzip/gzip_1.10-4ubuntu4.1.dsc' gzip_1.10-4ubuntu4.1.dsc 2277 SHA512:62008eba2ed83c6b8636541acb1930a0282248c153b9f1c5dc6209673cc77bdc50af8ec028aaa82fcbbe5cb6b9c142b8026f737c1eeb3bf01e11b4a39ffa4e23
'http://archive.ubuntu.com/ubuntu/pool/main/g/gzip/gzip_1.10.orig.tar.gz' gzip_1.10.orig.tar.gz 1201421 SHA512:7939043e74554ced0c1c05d354ab4eb36cd6dce89ad79d02ccdc5ed6b7ee390759689b2d47c07227b9b44a62851afe7c76c4cae9f92527d999f3f1b4df1cccff
'http://archive.ubuntu.com/ubuntu/pool/main/g/gzip/gzip_1.10.orig.tar.gz.asc' gzip_1.10.orig.tar.gz.asc 833 SHA512:74727fb3a8b64f81b4dd2d941fa750a789c482d7ae604d0ecfbe5ec623780efc7c5f0e51d65e7b99c2f097c5cd6585cc3a0f1b31abb03306156e0d410d9f0186
'http://archive.ubuntu.com/ubuntu/pool/main/g/gzip/gzip_1.10-4ubuntu4.1.debian.tar.xz' gzip_1.10-4ubuntu4.1.debian.tar.xz 39520 SHA512:4cecf676d0c9c55b5ec266f2ffa731cf618d7f4b571768dd3ad16ac8dcf966b80dabf1cbe3939edea96ca9743d710e365c444086946c03bdc3871410e5b4da76
```

### `dpkg` source package: `harfbuzz=2.7.4-1ubuntu3.1`

Binary Packages:

- `libharfbuzz0b:amd64=2.7.4-1ubuntu3.1`

Licenses: (parsed from: `/usr/share/doc/libharfbuzz0b/copyright`)

- `MIT`

Source:

```console
$ apt-get source -qq --print-uris harfbuzz=2.7.4-1ubuntu3.1
'http://archive.ubuntu.com/ubuntu/pool/main/h/harfbuzz/harfbuzz_2.7.4-1ubuntu3.1.dsc' harfbuzz_2.7.4-1ubuntu3.1.dsc 2855 SHA512:3e636c8c6cfd750636149c893fa2d91c9343a9bc61d09a650d9771b15635954c91ef0a5783c61136835c0fe668ea4d7c08037d83db709b2c83524f3ed3f9a38a
'http://archive.ubuntu.com/ubuntu/pool/main/h/harfbuzz/harfbuzz_2.7.4.orig.tar.xz' harfbuzz_2.7.4.orig.tar.xz 9532468 SHA512:d2af6a768c397c664f654cf36140e7b5696b3b983f637454604570c348247f7ffea135048d9b02cf6593cbde728567e31bf82a39df5ff38d680c78dff24d4cf0
'http://archive.ubuntu.com/ubuntu/pool/main/h/harfbuzz/harfbuzz_2.7.4-1ubuntu3.1.debian.tar.xz' harfbuzz_2.7.4-1ubuntu3.1.debian.tar.xz 11756 SHA512:e3f9211be2c2b5250b1e7db03627485ae8a6d09eec960fa5a0b6103887aa06bfba59007cc851bdbf291ba956fc4756fd8497ea68e996babeed2d6b0fcd2865d0
```

### `dpkg` source package: `hostname=3.23ubuntu2`

Binary Packages:

- `hostname=3.23ubuntu2`

Licenses: (parsed from: `/usr/share/doc/hostname/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris hostname=3.23ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/h/hostname/hostname_3.23ubuntu2.dsc' hostname_3.23ubuntu2.dsc 1085 SHA512:5e7f690bb67fcbc7521df55b69ce899ff005d24fb511c017d60ff5e4c9d9fc51271422bb81fc4998d90149cb814d2a209dc61db4d5073f72a37fb22af59827a0
'http://archive.ubuntu.com/ubuntu/pool/main/h/hostname/hostname_3.23ubuntu2.tar.gz' hostname_3.23ubuntu2.tar.gz 13854 SHA512:28b80ea23cbde63af91912aef2773ce83d7f4d1c2c82beb59a86c0e6b11e276019c610a0a60e69947af2b9bc5f86e4f8f6d13c1cb1a9ce35f1e5cfb03e0dd582
```

### `dpkg` source package: `icu=70.1-2`

Binary Packages:

- `libicu70:amd64=70.1-2`

Licenses: (parsed from: `/usr/share/doc/libicu70/copyright`)

- `GPL-3`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris icu=70.1-2
'http://archive.ubuntu.com/ubuntu/pool/main/i/icu/icu_70.1-2.dsc' icu_70.1-2.dsc 2252 SHA512:e1bad285bb7f66be62b8b9d595b289095621a88b0c5a2141b7317473ac25ab30a4b83de38ce215d6b7e0e135b2101ed7ab7bcf6d9b3666b4a554095b0ed6d1de
'http://archive.ubuntu.com/ubuntu/pool/main/i/icu/icu_70.1.orig.tar.gz' icu_70.1.orig.tar.gz 25449582 SHA512:0b26ae7207155cb65a8fdb25f7b2fa4431e74b12bccbed0884a17feaae3c96833d12451064dd152197fd6ea5fd3adfd95594284a463e66c82e0d860f645880c9
'http://archive.ubuntu.com/ubuntu/pool/main/i/icu/icu_70.1.orig.tar.gz.asc' icu_70.1.orig.tar.gz.asc 659 SHA512:17f65641de023b81f18588c5b1be6f88a8d308565343b09241ecfdc6250caeeb785e666d0772b668d5cb0fb243abc88766f02d27b273946e946e8c339cbca942
'http://archive.ubuntu.com/ubuntu/pool/main/i/icu/icu_70.1-2.debian.tar.xz' icu_70.1-2.debian.tar.xz 62440 SHA512:ca6771b09b9f232e69b3f6fd6c3445c9b27d86c918a6b52c903a2ebe658b273ea5181fcc3030aaad90450f9d86e620fdd42e710ed81c90c29d889ecfd44c6700
```

### `dpkg` source package: `init-system-helpers=1.62`

Binary Packages:

- `init-system-helpers=1.62`

Licenses: (parsed from: `/usr/share/doc/init-system-helpers/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris init-system-helpers=1.62
'http://archive.ubuntu.com/ubuntu/pool/main/i/init-system-helpers/init-system-helpers_1.62.dsc' init-system-helpers_1.62.dsc 1993 SHA512:f706cf5841877ccabe6f5a8e62d44ce5b312c09776d7fb7fd841f39c2d841b3f7f19bcb63cf94073f853165ae44def8f171a0abce658d05c76a48bf1e91697eb
'http://archive.ubuntu.com/ubuntu/pool/main/i/init-system-helpers/init-system-helpers_1.62.tar.xz' init-system-helpers_1.62.tar.xz 42144 SHA512:d90f12e642d086bd0d560ece87d119079c164b90ddbb77b2f804979540095b655715febbc2a5b0d50d7f94434d1ff7c0f4044d5d5411916fbca8300f3f88da7f
```

### `dpkg` source package: `isodate=0.6.1-1`

Binary Packages:

- `python3-isodate=0.6.1-1`

Licenses: (parsed from: `/usr/share/doc/python3-isodate/copyright`)

- `BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris isodate=0.6.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/i/isodate/isodate_0.6.1-1.dsc' isodate_0.6.1-1.dsc 2047 SHA512:a9147aa139f4688ac5f7e830d1088b047ed746e03abe97cd787ea9dec5154c8d5e354c6131ad40357e26b46ddf803b916639b8573dd2e7e75d1f83d76e1300c6
'http://archive.ubuntu.com/ubuntu/pool/universe/i/isodate/isodate_0.6.1.orig.tar.gz' isodate_0.6.1.orig.tar.gz 28443 SHA512:437e420ec7ee68dedded825f30d3289eeb0da526208443e5a8e50fe70f12309515e1285b21132d26e6d4c1683f90dfa1d401582042b5e4381fe7ab0e34af26b6
'http://archive.ubuntu.com/ubuntu/pool/universe/i/isodate/isodate_0.6.1-1.debian.tar.xz' isodate_0.6.1-1.debian.tar.xz 3040 SHA512:57febbd115092ba6b926c4d4a7c9b5a4e813a7929255fbd755356ed54db7a125c06ba48b69a5663f37dc298c5781fda2da736e97e966652e109af2362c2cec56
```

### `dpkg` source package: `jbigkit=2.1-3.1ubuntu0.22.04.1`

Binary Packages:

- `libjbig0:amd64=2.1-3.1ubuntu0.22.04.1`

Licenses: (parsed from: `/usr/share/doc/libjbig0/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris jbigkit=2.1-3.1ubuntu0.22.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/j/jbigkit/jbigkit_2.1-3.1ubuntu0.22.04.1.dsc' jbigkit_2.1-3.1ubuntu0.22.04.1.dsc 1796 SHA512:c7c726bcac2266327e373a30ec3d97f2197bc6f0f0859ffcc7d6930b94553f482f8693da95cb37ea2e8dc3ff4fdfd2a012e554b81afee0d336dab63d7869c570
'http://archive.ubuntu.com/ubuntu/pool/main/j/jbigkit/jbigkit_2.1.orig.tar.gz' jbigkit_2.1.orig.tar.gz 438710 SHA512:c4127480470ef90db1ef3bd2caa444df10b50ed8df0bc9997db7612cb48b49278baf44965028f1807a21028eb965d677e015466306b44683c4ec75a23e1922cf
'http://archive.ubuntu.com/ubuntu/pool/main/j/jbigkit/jbigkit_2.1-3.1ubuntu0.22.04.1.debian.tar.xz' jbigkit_2.1-3.1ubuntu0.22.04.1.debian.tar.xz 9912 SHA512:4c473125d8781d2b0192a8af40095e7c6e52225815a8dc7c87fe3bbb50aaeec4295438134be302fa57698d97fccd3f7d2240c74dbc57ef1089cab2ca3fc63475
```

### `dpkg` source package: `jinja2=3.0.3-1ubuntu0.2`

Binary Packages:

- `python3-jinja2=3.0.3-1ubuntu0.2`

Licenses: (parsed from: `/usr/share/doc/python3-jinja2/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris jinja2=3.0.3-1ubuntu0.2
'http://archive.ubuntu.com/ubuntu/pool/main/j/jinja2/jinja2_3.0.3-1ubuntu0.2.dsc' jinja2_3.0.3-1ubuntu0.2.dsc 1951 SHA512:54367731c0617c2ccd0a4b6b9f2e4154a1c4c7a5b974ef76872b1c74db972b7b03d37aedeb2a9226762e4d88a11e058907425aa19581bc49db4b34acc9b9c7ec
'http://archive.ubuntu.com/ubuntu/pool/main/j/jinja2/jinja2_3.0.3.orig.tar.gz' jinja2_3.0.3.orig.tar.gz 269196 SHA512:51703d396ffe35155ed216922294441e20d44cd1ab69674140146375d4964654cdb32b38945f22916e0de917bbc0cf406cb680c2e569f9225dbe1fe4063be0b0
'http://archive.ubuntu.com/ubuntu/pool/main/j/jinja2/jinja2_3.0.3-1ubuntu0.2.debian.tar.xz' jinja2_3.0.3-1ubuntu0.2.debian.tar.xz 11820 SHA512:af0606d86864a795d3451e4e6784755abfeb84300191034981d5c90dc710cf6a149b6533c2fd5d3832976979168ee4152ea06304422085739e38da8daa4d6aad
```

### `dpkg` source package: `keyutils=1.6.1-2ubuntu3`

Binary Packages:

- `libkeyutils1:amd64=1.6.1-2ubuntu3`

Licenses: (parsed from: `/usr/share/doc/libkeyutils1/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris keyutils=1.6.1-2ubuntu3
'http://archive.ubuntu.com/ubuntu/pool/main/k/keyutils/keyutils_1.6.1-2ubuntu3.dsc' keyutils_1.6.1-2ubuntu3.dsc 2203 SHA512:7e9c3266bf707b3553758ab89f815542edca6d7ed0ca069986bee3dda75b534f5b275b786e246232b3234c6ccbaf4c67ff60f68bba73b0a3e2ec1bbfa00b295e
'http://archive.ubuntu.com/ubuntu/pool/main/k/keyutils/keyutils_1.6.1.orig.tar.bz2' keyutils_1.6.1.orig.tar.bz2 97232 SHA512:ea6e20b2594234c7f51581eef2b8fd19c109fa9eacaaef8dfbb4f237bd1d6fdf071ec23b4ff334cb22a46461d09d17cf499987fd1f00e66f27506888876961e1
'http://archive.ubuntu.com/ubuntu/pool/main/k/keyutils/keyutils_1.6.1-2ubuntu3.debian.tar.xz' keyutils_1.6.1-2ubuntu3.debian.tar.xz 18936 SHA512:16f390f0fc3154a77c8ca3666d44881a6ca2f0d11cfe0398cd82b57b6f552af85c156de358d0b87e39f301331897d72de058050e3cb53720a76b5b5ebf07aa3d
```

### `dpkg` source package: `krb5=1.19.2-2ubuntu0.4`

Binary Packages:

- `libgssapi-krb5-2:amd64=1.19.2-2ubuntu0.4`
- `libk5crypto3:amd64=1.19.2-2ubuntu0.4`
- `libkrb5-3:amd64=1.19.2-2ubuntu0.4`
- `libkrb5support0:amd64=1.19.2-2ubuntu0.4`

Licenses: (parsed from: `/usr/share/doc/libgssapi-krb5-2/copyright`, `/usr/share/doc/libk5crypto3/copyright`, `/usr/share/doc/libkrb5-3/copyright`, `/usr/share/doc/libkrb5support0/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris krb5=1.19.2-2ubuntu0.4
'http://archive.ubuntu.com/ubuntu/pool/main/k/krb5/krb5_1.19.2-2ubuntu0.4.dsc' krb5_1.19.2-2ubuntu0.4.dsc 3478 SHA512:6537e7171563d984f8197a71d9248e9c8b5077180f29cbff530379fa09e7040df50b869597669e57709449b0104f84dde0c406de2d00e1bb5f435b909468b43c
'http://archive.ubuntu.com/ubuntu/pool/main/k/krb5/krb5_1.19.2.orig.tar.gz' krb5_1.19.2.orig.tar.gz 8741053 SHA512:b90d6ed0e1e8a87eb5cb2c36d88b823a6a6caabf85e5d419adb8a930f7eea09a5f8491464e7e454cca7ba88be09d19415962fe0036ad2e31fc584f9fc0bbd470
'http://archive.ubuntu.com/ubuntu/pool/main/k/krb5/krb5_1.19.2-2ubuntu0.4.debian.tar.xz' krb5_1.19.2-2ubuntu0.4.debian.tar.xz 114184 SHA512:8e78309ffb2ab3c388cf70539de538b61ea70dc51252600200394f628554f504c3750d6bcffe9f9ec0321d9ecd58ff71849a346e741daaaad9a8aeb68336634e
```

### `dpkg` source package: `lcms2=2.12~rc1-2build2`

Binary Packages:

- `liblcms2-2:amd64=2.12~rc1-2build2`

Licenses: (parsed from: `/usr/share/doc/liblcms2-2/copyright`)

- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3 (GPL-3 for the fast_float plugin only)`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris lcms2=2.12~rc1-2build2
'http://archive.ubuntu.com/ubuntu/pool/main/l/lcms2/lcms2_2.12%7erc1-2build2.dsc' lcms2_2.12~rc1-2build2.dsc 2120 SHA512:589b8926590d9158a85ad4641920e1f9700fb864b13ec0f2e44292bd0530cc639ecbcbe216405b7a528ecc512902a79456b30985b5c5a278a5c4692f8fc4bc9f
'http://archive.ubuntu.com/ubuntu/pool/main/l/lcms2/lcms2_2.12%7erc1.orig.tar.gz' lcms2_2.12~rc1.orig.tar.gz 7417767 SHA512:1d27e6f91911053b79f2a46c6c16943e25fce2f0501bb7d97f49507522a8a0f911d60f20726fc31727fee5242c6d452c86cdc28735f8f88c3aa9676fd35fdec6
'http://archive.ubuntu.com/ubuntu/pool/main/l/lcms2/lcms2_2.12%7erc1-2build2.debian.tar.xz' lcms2_2.12~rc1-2build2.debian.tar.xz 10616 SHA512:250e0245e300fff7be06a43a30621bff920cbb606e51197177d3d43acc1b50ad0db8988f7c05b6b4365073bf0c952d93dcb79364228698fcd8fbc6b093d4f843
```

### `dpkg` source package: `less.js=3.13.0+dfsg-7`

Binary Packages:

- `node-less=3.13.0+dfsg-7`

Licenses: (parsed from: `/usr/share/doc/node-less/copyright`)

- `Apache-2.0`
- `Expat`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris less.js=3.13.0+dfsg-7
'http://archive.ubuntu.com/ubuntu/pool/universe/l/less.js/less.js_3.13.0%2bdfsg-7.dsc' less.js_3.13.0+dfsg-7.dsc 2680 SHA512:6af68e6640e1a5e16b864bc038a8475239c9f8853f56e6e1a434d4640333e55621552cb1b853c5ccf1a2c66a9df1a539dc06f19a53501fad074b26215624b2fa
'http://archive.ubuntu.com/ubuntu/pool/universe/l/less.js/less.js_3.13.0%2bdfsg.orig-image-size.tar.xz' less.js_3.13.0+dfsg.orig-image-size.tar.xz 6580 SHA512:1975b3a200e834e7579b012ccafa9288bf26801185a9dcae28b49f78eddd9a3471ed6aaaddcc42771007340b8840a3402137ddf389743a8f2359f763773d969a
'http://archive.ubuntu.com/ubuntu/pool/universe/l/less.js/less.js_3.13.0%2bdfsg.orig.tar.xz' less.js_3.13.0+dfsg.orig.tar.xz 576576 SHA512:f6c11681c47a793b41736467b1861a2dc929ed6bdf6b6ffef1c9cdfc40eab2eec3dabdf46242f6a350d09f40f9b49735d5ddfa99c2c3f6dda26658846eb32936
'http://archive.ubuntu.com/ubuntu/pool/universe/l/less.js/less.js_3.13.0%2bdfsg-7.debian.tar.xz' less.js_3.13.0+dfsg-7.debian.tar.xz 12236 SHA512:0634688ef50b7e01b6d1c7716fa215da487f207e5511a84aba1c869c8d54b795a098b191e649af5647c3d0f7d3c3b39c7afd02a2bf71094ce4264f847cb8d5d6
```

### `dpkg` source package: `libassuan=2.5.5-1build1`

Binary Packages:

- `libassuan0:amd64=2.5.5-1build1`

Licenses: (parsed from: `/usr/share/doc/libassuan0/copyright`)

- `GAP`
- `GAP~FSF`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with libtool exception`
- `GPL-3`
- `GPL-3+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `LGPL-3`
- `LGPL-3+`

Source:

```console
$ apt-get source -qq --print-uris libassuan=2.5.5-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libassuan/libassuan_2.5.5-1build1.dsc' libassuan_2.5.5-1build1.dsc 2753 SHA512:6aa8147a85858f8e0c6ce17083c605fa92c65bcc810a0c1c5c8c5ef08332d359795ad77129bead9f7b216d7893c305e34f653ab29941b008f2bd1178e81587f5
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libassuan/libassuan_2.5.5.orig.tar.bz2' libassuan_2.5.5.orig.tar.bz2 572263 SHA512:70117f77aa43bbbe0ed28da5ef23834c026780a74076a92ec775e30f851badb423e9a2cb9e8d142c94e4f6f8a794988c1b788fd4bd2271e562071adf0ab16403
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libassuan/libassuan_2.5.5.orig.tar.bz2.asc' libassuan_2.5.5.orig.tar.bz2.asc 228 SHA512:343336ea5dffa113cd934167f548faf4e85d31bf64a46541ee6828b4d0995a8cc9d0668995812d9c4d3ab73347d5b1bbfff0d6ed586fbf4bbc57ac42e828e8d5
'http://archive.ubuntu.com/ubuntu/pool/main/liba/libassuan/libassuan_2.5.5-1build1.debian.tar.xz' libassuan_2.5.5-1build1.debian.tar.xz 14448 SHA512:590d52fa0d3e7fde9747cb164b08a60ae3372eff60ac80f4de809289f86a83c2b7361e65bbb20e1b68a27960e7478a78031b57d7e9784d6d2dc407f1c8530217
```

### `dpkg` source package: `libbsd=0.11.5-1`

Binary Packages:

- `libbsd0:amd64=0.11.5-1`

Licenses: (parsed from: `/usr/share/doc/libbsd0/copyright`)

- `BSD-2-clause`
- `BSD-2-clause-NetBSD`
- `BSD-2-clause-author`
- `BSD-2-clause-verbatim`
- `BSD-3-clause`
- `BSD-3-clause-John-Birrell`
- `BSD-3-clause-Regents`
- `BSD-3-clause-author`
- `BSD-4-clause-Christopher-G-Demetriou`
- `BSD-4-clause-Niels-Provos`
- `BSD-5-clause-Peter-Wemm`
- `Beerware`
- `Expat`
- `ISC`
- `ISC-Original`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris libbsd=0.11.5-1
'http://archive.ubuntu.com/ubuntu/pool/main/libb/libbsd/libbsd_0.11.5-1.dsc' libbsd_0.11.5-1.dsc 2292 SHA512:635f85618e9bcf22abbe73a6864b87d34c4e9d75bc619cab4e487d0ccbb52e1c006258cb47c8b892869adb5d645303fbff3eb57618f2dc862120f741cfbe175c
'http://archive.ubuntu.com/ubuntu/pool/main/libb/libbsd/libbsd_0.11.5.orig.tar.xz' libbsd_0.11.5.orig.tar.xz 409972 SHA512:c52c19eddd53630aca14f9f6221f7b84aa9cc798b4bb91e867822b161793313aab872ac1c0350d29312a72fee6e2061f3910ff918b724ec171d8c9de5837c841
'http://archive.ubuntu.com/ubuntu/pool/main/libb/libbsd/libbsd_0.11.5.orig.tar.xz.asc' libbsd_0.11.5.orig.tar.xz.asc 833 SHA512:24a3fb414a3a354284c76724d65225619820f3f6b597ed8d163ed99f19ec433465f909fe047758f83a7cd6fc8ee2676478420c77cb2f0b8b69ffa7a690c8c17f
'http://archive.ubuntu.com/ubuntu/pool/main/libb/libbsd/libbsd_0.11.5-1.debian.tar.xz' libbsd_0.11.5-1.debian.tar.xz 17604 SHA512:438911ae479952b00aa81cdf2f12863b82a01bc2abf3acb4bf22223f4c851504a77217087b2e2edabf6cf61187314f1c3061f2794de7a38abd953451e2f0d931
```

### `dpkg` source package: `libcap-ng=0.7.9-2.2build3`

Binary Packages:

- `libcap-ng0:amd64=0.7.9-2.2build3`

Licenses: (parsed from: `/usr/share/doc/libcap-ng0/copyright`)

- `GPL-2`
- `GPL-3`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libcap-ng=0.7.9-2.2build3
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcap-ng/libcap-ng_0.7.9-2.2build3.dsc' libcap-ng_0.7.9-2.2build3.dsc 2105 SHA512:50d7c66eea7dbadcd2314f3eb5ae9f4464e9a2a82a36004efd841bc092f6c4787dd9856aa14bef85035ae9db115b3a9aee78436b790a373e935d98f7fd761cd5
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcap-ng/libcap-ng_0.7.9.orig.tar.gz' libcap-ng_0.7.9.orig.tar.gz 449038 SHA512:095edabaf76a943aab0645b843b14e20b1733ba1d47a8e34d82f6586ca9a1512ba2677d232b13dd3900b913837401bb58bf74481970e967ba19041959dc43259
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcap-ng/libcap-ng_0.7.9-2.2build3.debian.tar.xz' libcap-ng_0.7.9-2.2build3.debian.tar.xz 6432 SHA512:9ce3f52dc0c89739f0117ba7c1b8fdfcdb51ceb7cea7c00aa55522ba733efdb7a37a7f21a9bfd106e453a8477a759af0aaf4688e4b18c3c9cc659657aeb2c0bb
```

### `dpkg` source package: `libcap2=1:2.44-1ubuntu0.22.04.1`

Binary Packages:

- `libcap2:amd64=1:2.44-1ubuntu0.22.04.1`

Licenses: (parsed from: `/usr/share/doc/libcap2/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris libcap2=1:2.44-1ubuntu0.22.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcap2/libcap2_2.44-1ubuntu0.22.04.1.dsc' libcap2_2.44-1ubuntu0.22.04.1.dsc 2318 SHA512:89673cbc25652c33df4477e5624827c55f6799cf8ee73248c8ec58a647aa66aca02d6342edcb18d9d5e4892b5c2f1e011157c854dbfe2d5f6b916f27346518c1
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcap2/libcap2_2.44.orig.tar.xz' libcap2_2.44.orig.tar.xz 125568 SHA512:1bb323ca362923bd6bd0e2e4639cf8726975165a620a243b31e797056439eb7efb2bfbc8e5521636783a86c7415b2037b1638c98747b79183ca7d3d42a04ff20
'http://archive.ubuntu.com/ubuntu/pool/main/libc/libcap2/libcap2_2.44-1ubuntu0.22.04.1.debian.tar.xz' libcap2_2.44-1ubuntu0.22.04.1.debian.tar.xz 22564 SHA512:a526e48fe585b06d42bd2d1d241e16de4f9151c502ad1d54a1a07e73aee8e4c41009160c9b5fedadf9873b7eb9bf07b9a0c3ec56f854da59360aaf94589c1af8
```

### `dpkg` source package: `libdatrie=0.2.13-2`

Binary Packages:

- `libdatrie1:amd64=0.2.13-2`

Licenses: (parsed from: `/usr/share/doc/libdatrie1/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris libdatrie=0.2.13-2
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdatrie/libdatrie_0.2.13-2.dsc' libdatrie_0.2.13-2.dsc 2239 SHA512:86ebcb0343ca62b1e832210de6ca74e71786cf7c4c63eb5d1e944dc1bf900c986107c1120e798412fd9780902056fda1403c6124baef044778d479b53aeabb6d
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdatrie/libdatrie_0.2.13.orig.tar.xz' libdatrie_0.2.13.orig.tar.xz 314072 SHA512:db3c879d825ead5871c12ef3a06bb093cb1708a6e7e20775eaf82356af9dd6ad54c6b5cabbe1773f2494d3dfa2426528fdd49441038b6294b70ccb1a3d90099a
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdatrie/libdatrie_0.2.13-2.debian.tar.xz' libdatrie_0.2.13-2.debian.tar.xz 9604 SHA512:032040b6f9da493b7bbc4437eb16dce9dbbf10d0d9381fbc4ec6c636e5cccaf52b14e77739d227b58fc5ba54911c2cea7f679bada7ed93acb048bd996d4ce3d9
```

### `dpkg` source package: `libdeflate=1.10-2`

Binary Packages:

- `libdeflate0:amd64=1.10-2`

Licenses: (parsed from: `/usr/share/doc/libdeflate0/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris libdeflate=1.10-2
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdeflate/libdeflate_1.10-2.dsc' libdeflate_1.10-2.dsc 2206 SHA512:5c2fd7116bd061a5940481924c3a35e632e178050319c5e29aab2833a2ec27378444a6db767cff1bdd7b9bada10332a975e082ce02eab1fc43f8408a54dfcf52
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdeflate/libdeflate_1.10.orig.tar.gz' libdeflate_1.10.orig.tar.gz 158379 SHA512:2b59cc170c7fb3bb13bd3c6853070ea24fb9e6844dde4d08e43a8a5f8745ecbf844952390ff758070c6fc4f17d9eec8c4d2a729922bf84e2eaa9e74f1424e241
'http://archive.ubuntu.com/ubuntu/pool/main/libd/libdeflate/libdeflate_1.10-2.debian.tar.xz' libdeflate_1.10-2.debian.tar.xz 4584 SHA512:faa6fad75528e1f7fa02dd5464bf88d7921563103aee922feade71323229e0c6758cb788545ca6b627aabae58bb7f524d775431fc821f4611713dec6069571c8
```

### `dpkg` source package: `libev=1:4.33-1`

Binary Packages:

- `libev4:amd64=1:4.33-1`

Licenses: (parsed from: `/usr/share/doc/libev4/copyright`)

- `BSD-2-clause`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris libev=1:4.33-1
'http://archive.ubuntu.com/ubuntu/pool/universe/libe/libev/libev_4.33-1.dsc' libev_4.33-1.dsc 1963 SHA512:78c6bf3ad4829db67452a3c409ce6ddc7b04c53c078474773dc060c33b52d66f964713605d8ab5a935584e72c207bc9a699e3380e91a9fc340d594504863f2bf
'http://archive.ubuntu.com/ubuntu/pool/universe/libe/libev/libev_4.33.orig.tar.gz' libev_4.33.orig.tar.gz 569527 SHA512:c662a65360115e0b2598e3e8824cf7b33360c43a96ac9233f6b6ea2873a10102551773cad0e89e738541e75af9fd4f3e3c11cd2f251c5703aa24f193128b896b
'http://archive.ubuntu.com/ubuntu/pool/universe/libe/libev/libev_4.33-1.debian.tar.xz' libev_4.33-1.debian.tar.xz 5140 SHA512:794e18a51ee49bdd596478e2db2f1cb2f33e063d38a46c0ef301024c73285e58826675df8b83e9daa5d3be213365e24a11af834a594c82a30262f4301be8e910
```

### `dpkg` source package: `libffi=3.4.2-4`

Binary Packages:

- `libffi8:amd64=3.4.2-4`

Licenses: (parsed from: `/usr/share/doc/libffi8/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris libffi=3.4.2-4
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libffi/libffi_3.4.2-4.dsc' libffi_3.4.2-4.dsc 1948 SHA512:a3a3ada71f82d244f8cb54f1cac30ae6be7c4305696700fb6ffb96783f4f9f788c943bc8ba0d7474c9fd31f04453875e1da341240707711e4eff10cd8023e8d1
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libffi/libffi_3.4.2.orig.tar.gz' libffi_3.4.2.orig.tar.gz 1351355 SHA512:31bad35251bf5c0adb998c88ff065085ca6105cf22071b9bd4b5d5d69db4fadf16cadeec9baca944c4bb97b619b035bb8279de8794b922531fddeb0779eb7fb1
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libffi/libffi_3.4.2-4.debian.tar.xz' libffi_3.4.2-4.debian.tar.xz 8164 SHA512:eecf83971847b78aae0c2cfe3b546a858c93462b7d1d2473c96f5b43de47e1d5fc4663b524e4c5792630d7a6d1796e8bdf83f55addc669d0ce3810643924a07f
```

### `dpkg` source package: `libfontenc=1:1.1.4-1build3`

Binary Packages:

- `libfontenc1:amd64=1:1.1.4-1build3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libfontenc=1:1.1.4-1build3
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfontenc/libfontenc_1.1.4-1build3.dsc' libfontenc_1.1.4-1build3.dsc 2420 SHA512:f115921a7fb6e6d3bef1327ebb2e9348896934e236bec023a56f1c2bc8c4aceaf31e4a1f69cdf7d2ecc1935b6f2c929156ce7900e8c1789b1b686eb1ad7b984f
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfontenc/libfontenc_1.1.4.orig.tar.gz' libfontenc_1.1.4.orig.tar.gz 389706 SHA512:ffa9d3c2f17bad76fe5034f5939127db4636140bbf939ef42e052cfe86bd1e825ef2455b3c2efa743a56aa44607aa7e31cfb16d7fb8a4d4ed52c059d3bf33547
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfontenc/libfontenc_1.1.4.orig.tar.gz.asc' libfontenc_1.1.4.orig.tar.gz.asc 801 SHA512:147c3fda4f198843badbad71cf66f101b772cf083ded4df0b8e8c77b6b5f77094dc5882b3570635eeda6160163557d63b0bf6930e5353210091a6a1774a10de3
'http://archive.ubuntu.com/ubuntu/pool/main/libf/libfontenc/libfontenc_1.1.4-1build3.diff.gz' libfontenc_1.1.4-1build3.diff.gz 9377 SHA512:d25103813918619452fd038d9f356e9bc700811801ba235bed4665acd0309593fa4ba482946a85fd9931414a56a8c715654ed11c9cb95afa89e593e62e472ad0
```

### `dpkg` source package: `libgcrypt20=1.9.4-3ubuntu3`

Binary Packages:

- `libgcrypt20:amd64=1.9.4-3ubuntu3`

Licenses: (parsed from: `/usr/share/doc/libgcrypt20/copyright`)

- `GPL-2`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris libgcrypt20=1.9.4-3ubuntu3
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgcrypt20/libgcrypt20_1.9.4-3ubuntu3.dsc' libgcrypt20_1.9.4-3ubuntu3.dsc 2936 SHA512:1f68c37290d1ccdaa60cf6543c52f7dca084b49ebffd5d4fd7700304a4f8d133e694084ed69ff4b33ba2c2e25947c9ac595997a20dfb6627285d0ca2477c7809
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgcrypt20/libgcrypt20_1.9.4.orig.tar.bz2' libgcrypt20_1.9.4.orig.tar.bz2 3239704 SHA512:d0e117ac73c94d70e9521ee1e6328691498cc8328f8c4e21338096908f5c04c7b838966eb63d59494565f4e19f506c07dab4f4d922150d75610d9f7b57abbf60
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgcrypt20/libgcrypt20_1.9.4.orig.tar.bz2.asc' libgcrypt20_1.9.4.orig.tar.bz2.asc 228 SHA512:5fbc2f52ff8a9f2b254791a0d127b012a3648a03d26e043af2ab63d05f69045492581462ba485ecf005a171ea391175bdc73350aa0e76f8b5f75c64a4d685d49
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgcrypt20/libgcrypt20_1.9.4-3ubuntu3.debian.tar.xz' libgcrypt20_1.9.4-3ubuntu3.debian.tar.xz 35172 SHA512:fec6751987d91e0234a9da212456763045eabf52166fb30f4832db0460b0a250caff879ac9c80dddf5697945e3a5b1effa036206b96fbf047f2bb705d74a5245
```

### `dpkg` source package: `libgd2=2.3.0-2ubuntu2`

Binary Packages:

- `libgd3:amd64=2.3.0-2ubuntu2`

Licenses: (parsed from: `/usr/share/doc/libgd3/copyright`)

- `BSD-3-clause`
- `GAP~Makefile.in`
- `GAP~configure`
- `GD`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with Autoconf exception`
- `HPND`
- `MIT`
- `WEBP`
- `XFIG`

Source:

```console
$ apt-get source -qq --print-uris libgd2=2.3.0-2ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgd2/libgd2_2.3.0-2ubuntu2.dsc' libgd2_2.3.0-2ubuntu2.dsc 2318 SHA512:96c030bf2491b412fa423cbac1b2f2d3ace638a99c66ea8e7f55cd1c409d1fa5999a7fd02968949eb56fb8b28dc03d61e4464d0de13a5ef7428051b133ccc235
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgd2/libgd2_2.3.0.orig.tar.gz' libgd2_2.3.0.orig.tar.gz 3102749 SHA512:1ffdbe41f24fcdb22f5b195b8f1a22650a3dc30a798c23a7ee1a93acfdb70c2608d97ff908a01246ad44e1cfc13dbd20cc006d7a25b882907489daa1880db30b
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgd2/libgd2_2.3.0-2ubuntu2.debian.tar.xz' libgd2_2.3.0-2ubuntu2.debian.tar.xz 34548 SHA512:992da1a98982cca39cd6df17c963b4f4e169d99a9331c74ad5f02eb80371c909b51d83c7362df96ed41cc2206ff478bd705f2d983de90456c8560601aaa25732
```

### `dpkg` source package: `libgpg-error=1.43-3`

Binary Packages:

- `libgpg-error0:amd64=1.43-3`

Licenses: (parsed from: `/usr/share/doc/libgpg-error0/copyright`)

- `BSD-3-clause`
- `GPL-3`
- `GPL-3+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `g10-permissive`

Source:

```console
$ apt-get source -qq --print-uris libgpg-error=1.43-3
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgpg-error/libgpg-error_1.43-3.dsc' libgpg-error_1.43-3.dsc 2270 SHA512:c0cf8b16d720d89b69b5eb5cf22bf7bb0605892ba110100d3b30370fc93c167bda2f501e53e70a2599024bc40c1e509d06e39f68f3be63312967e4308249f0b8
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgpg-error/libgpg-error_1.43.orig.tar.bz2' libgpg-error_1.43.orig.tar.bz2 999006 SHA512:36769a62d0b4b219a6d58195bed692e34d3b0313f628b1036055ca34b69332edbe6bcdace9855a60d06e7be5998dc13bf1305d0b2bb211a4d8f701e85040961c
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgpg-error/libgpg-error_1.43.orig.tar.bz2.asc' libgpg-error_1.43.orig.tar.bz2.asc 238 SHA512:1bd12acc57bb394947dec51b70fe067f717e591484be164cafff3ac47a6bacc101f7ac64fbae350233bc76a0002981fb3fbe53db73dc914db52694b8588cecc1
'http://archive.ubuntu.com/ubuntu/pool/main/libg/libgpg-error/libgpg-error_1.43-3.debian.tar.xz' libgpg-error_1.43-3.debian.tar.xz 19264 SHA512:bbd7615b02707405efddd4bb1dee355024bb7089770453a2addf7e722c15c2cfbebc3012c9db848f3f55eb4c66f5b9487877e8d94322d8dc1d2731876b4d8281
```

### `dpkg` source package: `libice=2:1.0.10-1build2`

Binary Packages:

- `libice6:amd64=2:1.0.10-1build2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libice=2:1.0.10-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libice/libice_1.0.10-1build2.dsc' libice_1.0.10-1build2.dsc 2181 SHA512:ab928645b15c679673d1adcc53f23b126f4ca90accbef677c15a1bb8bd428e642db5e45ef77b255d9b0351c2501dd01eafb9108875fff7c98f4543432d7e6fbf
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libice/libice_1.0.10.orig.tar.gz' libice_1.0.10.orig.tar.gz 481960 SHA512:2d4757f7325eb01180b5d7433cc350eb9606bd3afe82dabc8aa164feda75ef03a0624d74786e655c536c24a80d0ccb2f1e3ecbb04d3459b23f85455006ca8a91
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libice/libice_1.0.10-1build2.diff.gz' libice_1.0.10-1build2.diff.gz 11679 SHA512:dc850d9603ac04ffee3e2de1d2f9786520f6d9829f210649756fac705b6fe2797eda307d45283533342dd425317928fbb5f61d94bfe0fcadbc8f1c0c2cb02d6c
```

### `dpkg` source package: `libidn2=2.3.2-2build1`

Binary Packages:

- `libidn2-0:amd64=2.3.2-2build1`

Licenses: (parsed from: `/usr/share/doc/libidn2-0/copyright`)

- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `LGPL-3`
- `LGPL-3+`
- `Unicode`

Source:

```console
$ apt-get source -qq --print-uris libidn2=2.3.2-2build1
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libidn2/libidn2_2.3.2-2build1.dsc' libidn2_2.3.2-2build1.dsc 2655 SHA512:bc84158420d526a0f9bca79ca2a8291c55588e2773ded66d7c4b86ad33b370f9d8723cfc3a2b278660de7060687fff5448912e802d7fb63a8ff7876b38440f32
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libidn2/libidn2_2.3.2.orig.tar.gz' libidn2_2.3.2.orig.tar.gz 2169556 SHA512:958dbf49a47a84c7627ac182f4cc8ea452696cec3f0d1ff102a6c48e89893e772b2aa81f75da8223dfc6326515cca3ae085268fbf997828de9330c3a351152f1
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libidn2/libidn2_2.3.2.orig.tar.gz.asc' libidn2_2.3.2.orig.tar.gz.asc 488 SHA512:0559b51b37c7937f3e1f8bf9de9b193f137f16b79d6673f85691a4f4a12ec132568e913848a70136f8522118817f7ecaa8432d353a5eff6b99a7be8719421fe0
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libidn2/libidn2_2.3.2-2build1.debian.tar.xz' libidn2_2.3.2-2build1.debian.tar.xz 15972 SHA512:d5af028cc405d326c31e67e577ef16d9b8b81e433171220fda2c2a6f8fc982a63b6d1d85c6595f5ce01a5005768d935aeeaa5de8a552990f4e070bc541e78570
```

### `dpkg` source package: `libimagequant=2.17.0-1`

Binary Packages:

- `libimagequant0:amd64=2.17.0-1`

Licenses: (parsed from: `/usr/share/doc/libimagequant0/copyright`)

- `CC0`
- `GPL-3`
- `GPL-3.0+`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris libimagequant=2.17.0-1
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libimagequant/libimagequant_2.17.0-1.dsc' libimagequant_2.17.0-1.dsc 2164 SHA512:64de3d5a7fb52b60e15b6731f8fe431043ade5a60094a53286934400f86b68bd881c7280fb8751f9d7f163aed7b81dee2b69a660adf756e3a0eb26410d8eb765
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libimagequant/libimagequant_2.17.0.orig.tar.gz' libimagequant_2.17.0.orig.tar.gz 99343 SHA512:12b111f8293c0e37bd75481457b6c96b547a1e3bc1d33bc7a6bbbde6ada284d835c7f5958ef41af7a5a8d3e6fb2d1aa2f641b7d6f2fe2782202f3c760792f394
'http://archive.ubuntu.com/ubuntu/pool/main/libi/libimagequant/libimagequant_2.17.0-1.debian.tar.xz' libimagequant_2.17.0-1.debian.tar.xz 3388 SHA512:49fc7ebf926eeae9c0f80eaace067f348110d8ab5fcb546e153838ce5bcf7eeddea856658caa748d9e4e80e9d86ad17050145c9454026794f2eb16bbc18c02d1
```

### `dpkg` source package: `libjpeg-turbo=2.1.2-0ubuntu1`

Binary Packages:

- `libjpeg-turbo8:amd64=2.1.2-0ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libjpeg-turbo8/copyright`)

- `JPEG`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libjpeg-turbo=2.1.2-0ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/libj/libjpeg-turbo/libjpeg-turbo_2.1.2-0ubuntu1.dsc' libjpeg-turbo_2.1.2-0ubuntu1.dsc 1690 SHA512:401a75e62575352db079bd268f00f94c8ea1e8e6c38bda852628729e6dfd3135804e3c9ee5b18b1254fed827e6073b0078553bcbc2c1df30d628bbb717a5ed47
'http://archive.ubuntu.com/ubuntu/pool/main/libj/libjpeg-turbo/libjpeg-turbo_2.1.2.orig.tar.gz' libjpeg-turbo_2.1.2.orig.tar.gz 2257645 SHA512:172c3d8bdad62c32c4560754422fb36f0e80c8316e44d08708f0cba8ee9fd0830f5295d380de34d0f90ec07df6ab4dbe2f0c8451bc60553371c022c9077447c2
'http://archive.ubuntu.com/ubuntu/pool/main/libj/libjpeg-turbo/libjpeg-turbo_2.1.2-0ubuntu1.debian.tar.xz' libjpeg-turbo_2.1.2-0ubuntu1.debian.tar.xz 17240 SHA512:5cfc1e73012f3251e385f0288dece2e3862977fb3975c61c344afc464a2fd329c3fa027fc07edc40097afaad052bdf6f0dad55c665c20ccdde9f2231ec191410
```

### `dpkg` source package: `libjpeg8-empty=8c-2ubuntu10`

Binary Packages:

- `libjpeg8:amd64=8c-2ubuntu10`

Licenses: (parsed from: `/usr/share/doc/libjpeg8/copyright`)

- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libjpeg8-empty=8c-2ubuntu10
'http://archive.ubuntu.com/ubuntu/pool/main/libj/libjpeg8-empty/libjpeg8-empty_8c-2ubuntu10.dsc' libjpeg8-empty_8c-2ubuntu10.dsc 1655 SHA512:1085be8a159c716c4ca89e6bfb2b1a5ce7b66ad8bc8f4cf3796c2c4ac3dad5169ac5be045f2a9ce103858b42585b1ce52d6dc6986995d073785170d45fe4d29d
'http://archive.ubuntu.com/ubuntu/pool/main/libj/libjpeg8-empty/libjpeg8-empty_8c-2ubuntu10.tar.gz' libjpeg8-empty_8c-2ubuntu10.tar.gz 1912 SHA512:1c21044013df62225f861ec6f88b2a43e0f6254522ed379ad081b92f4f89b64686d4e68d70e8384289cd8222df2288400c2d0e8b8ccae87dd079164bdc3f3cf3
```

### `dpkg` source package: `libksba=1.6.0-2ubuntu0.2`

Binary Packages:

- `libksba8:amd64=1.6.0-2ubuntu0.2`

Licenses: (parsed from: `/usr/share/doc/libksba8/copyright`)

- `FSFUL`
- `GPL-3`
- `LGPL-2.1-or-later`

Source:

```console
$ apt-get source -qq --print-uris libksba=1.6.0-2ubuntu0.2
'http://archive.ubuntu.com/ubuntu/pool/main/libk/libksba/libksba_1.6.0-2ubuntu0.2.dsc' libksba_1.6.0-2ubuntu0.2.dsc 2585 SHA512:ef96729e570627b7cf38ed0dcc3338097a81f690dde041fd9ea63b3c4b55c11ccf35ab7b2bbd196af3ca7834f8e5017cbb14436a7718034608f3276ca3db9f3f
'http://archive.ubuntu.com/ubuntu/pool/main/libk/libksba/libksba_1.6.0.orig.tar.bz2' libksba_1.6.0.orig.tar.bz2 662120 SHA512:a7c76d41dfd8ec6383ac2de3c53848cd9f066b538f6f3cd43175e3c8095df51b96d0a24a573481c0c4856b09b7c224e2b562d88f5c0801e7acfb582ea2739c2b
'http://archive.ubuntu.com/ubuntu/pool/main/libk/libksba/libksba_1.6.0.orig.tar.bz2.asc' libksba_1.6.0.orig.tar.bz2.asc 228 SHA512:fc381ea66eefdb431a5248fa3ac0751d7343d7f99cc7ebf7621b0763e6e31a80b45c5e17b09bbc7c1c1154e6a0152af1f13798f64959ac63f50b789ec046d7a3
'http://archive.ubuntu.com/ubuntu/pool/main/libk/libksba/libksba_1.6.0-2ubuntu0.2.debian.tar.xz' libksba_1.6.0-2ubuntu0.2.debian.tar.xz 16004 SHA512:24a609ca522b5e3a1402ff5a97ce451869bdf0960902d171a89f2190d4de7c8442403d21f938cebeeafd0ae082bf03d76c0521b26a2c153257df784cf7894b43
```

### `dpkg` source package: `libmaxminddb=1.5.2-1build2`

Binary Packages:

- `libmaxminddb0:amd64=1.5.2-1build2`

Licenses: (parsed from: `/usr/share/doc/libmaxminddb0/copyright`)

- `Apache-2.0`
- `BSD-2-clause`
- `BSD-3-clause`
- `BSD-4-clause`
- `CC-BY-SA-3.0`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris libmaxminddb=1.5.2-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmaxminddb/libmaxminddb_1.5.2-1build2.dsc' libmaxminddb_1.5.2-1build2.dsc 2454 SHA512:7e7166e405d886d2f8f4a29c0e4c4920d86d1cce2e453cc97e8185a67a7baeadf51a77c313a0bb896342ecb9b77c80733e3ca1641c8bdf0a8f234d49addb69fd
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmaxminddb/libmaxminddb_1.5.2.orig.tar.gz' libmaxminddb_1.5.2.orig.tar.gz 249507 SHA512:2f053028e28dc4f1d94039e52193ab71f8dc278f1fafa14bca1af0251d239351acadb5d540e63c250232d0fd1b8f2dd45289f0eae5c55d9b4430acbabbcd11a9
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmaxminddb/libmaxminddb_1.5.2-1build2.debian.tar.xz' libmaxminddb_1.5.2-1build2.debian.tar.xz 12488 SHA512:1017b70ee85f22eed14258a4d594d77e5bf6fbe5dcb0a23e635f0dcb26d09eb173dd777063f695f9610350dab91b8717ae4d701c3b1eb282358d6450394a0889
```

### `dpkg` source package: `libmd=1.0.4-1build1`

Binary Packages:

- `libmd0:amd64=1.0.4-1build1`

Licenses: (parsed from: `/usr/share/doc/libmd0/copyright`)

- `BSD-2-clause`
- `BSD-2-clause-NetBSD`
- `BSD-3-clause`
- `BSD-3-clause-Aaron-D-Gifford`
- `Beerware`
- `ISC`
- `public-domain-md4`
- `public-domain-md5`
- `public-domain-sha1`

Source:

```console
$ apt-get source -qq --print-uris libmd=1.0.4-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmd/libmd_1.0.4-1build1.dsc' libmd_1.0.4-1build1.dsc 2380 SHA512:778b562e6b3860fe6a6d5ddf4d7cce381126be77d151ac7c2a619d57737080f2adc07ff8e01fcafd98b3ace157fc72ab77a572362b56e79e5abb79a99fdacd6c
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmd/libmd_1.0.4.orig.tar.xz' libmd_1.0.4.orig.tar.xz 264472 SHA512:731553ecc5e0e1eb228cced8fccd531fe31fb5c7627ca30013d287e1aeb8222959cf7498fbb7414bbabb967b25d4e8b0edd54fc47f6ccf55fc91087db0725ce3
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmd/libmd_1.0.4.orig.tar.xz.asc' libmd_1.0.4.orig.tar.xz.asc 833 SHA512:ec4b60a721da1f315fad73daa8ee620f44a53f17a30506c4d63b154b3abde19bb248b2ce6b83b989589e2a9184ebbe1b870e83181e18a4147d75617579d10504
'http://archive.ubuntu.com/ubuntu/pool/main/libm/libmd/libmd_1.0.4-1build1.debian.tar.xz' libmd_1.0.4-1build1.debian.tar.xz 10264 SHA512:0e287498326a5aa3bc95cb0c576df7d0bb289bfb9db3a1f812d0e202c61af9dc78ecfa4b6b26c2dee3c5ccbefad877919f44ec849b3300f0f30878080eb5cb13
```

### `dpkg` source package: `libnsl=1.3.0-2build2`

Binary Packages:

- `libnsl2:amd64=1.3.0-2build2`

Licenses: (parsed from: `/usr/share/doc/libnsl2/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2+-autoconf-exception`
- `GPL-2+-libtool-exception`
- `GPL-3`
- `GPL-3+-autoconf-exception`
- `LGPL-2.1`
- `LGPL-2.1+`
- `MIT`
- `permissive-autoconf-m4`
- `permissive-autoconf-m4-no-warranty`
- `permissive-configure`
- `permissive-fsf`
- `permissive-makefile-in`

Source:

```console
$ apt-get source -qq --print-uris libnsl=1.3.0-2build2
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnsl/libnsl_1.3.0-2build2.dsc' libnsl_1.3.0-2build2.dsc 2087 SHA512:f13d28f34b0e71b04b5a0313b1cc79cdbe7d5e7f910d649af63b42824654e3cf01c02caa0e68309cb03350a17506e034800af1b1e3ab9af99fb64121c119215c
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnsl/libnsl_1.3.0.orig.tar.xz' libnsl_1.3.0.orig.tar.xz 321488 SHA512:a5a6c3ccb2d1e724c8c1f65e55dcd09383eb1ae019c55f4c09441eadf23ffbc2196cfad259805b0ac40ddf3a10af0da453e4d739d67d46829c64d0995dab4e55
'http://archive.ubuntu.com/ubuntu/pool/main/libn/libnsl/libnsl_1.3.0-2build2.debian.tar.xz' libnsl_1.3.0-2build2.debian.tar.xz 4868 SHA512:367904106ba925eaa667cc273b37afd052ba795b7ed004cdb501c13dd26b469df971ac10acec2bf57d91fa4839f356c7dcbcd4969914891152588365844ced9a
```

### `dpkg` source package: `libpng1.6=1.6.37-3build5`

Binary Packages:

- `libpng16-16:amd64=1.6.37-3build5`

Licenses: (parsed from: `/usr/share/doc/libpng16-16/copyright`)

- `Apache-2.0`
- `BSD-3-clause`
- `BSD-like-with-advertising-clause`
- `GPL-2`
- `GPL-2+`
- `expat`
- `libpng`
- `libpng OR Apache-2.0 OR BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris libpng1.6=1.6.37-3build5
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpng1.6/libpng1.6_1.6.37-3build5.dsc' libpng1.6_1.6.37-3build5.dsc 2357 SHA512:8628c50bf667f1b7134192cbaf7b9c7fc00d6c264027092ea3aaee089497ed7e417a63c824245945a5169000dd56d0787f4538f5563ef312b1be381766cadea0
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpng1.6/libpng1.6_1.6.37.orig.tar.gz' libpng1.6_1.6.37.orig.tar.gz 1508805 SHA512:ccb3705c23b2724e86d072e2ac8cfc380f41fadfd6977a248d588a8ad57b6abe0e4155e525243011f245e98d9b7afbe2e8cc7fd4ff7d82fcefb40c0f48f88918
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpng1.6/libpng1.6_1.6.37-3build5.debian.tar.xz' libpng1.6_1.6.37-3build5.debian.tar.xz 32492 SHA512:58be3d57602b2c6d6d2788e16de69505cf54a381b51fbd3a1338b9708ed576965975b3994c5946231fe75055a323649667edf8971b3d4d3d736457609fca0770
```

### `dpkg` source package: `libpsl=0.21.0-1.2build2`

Binary Packages:

- `libpsl5:amd64=0.21.0-1.2build2`

Licenses: (parsed from: `/usr/share/doc/libpsl5/copyright`)

- `Chromium`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris libpsl=0.21.0-1.2build2
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpsl/libpsl_0.21.0-1.2build2.dsc' libpsl_0.21.0-1.2build2.dsc 2348 SHA512:28ff7399af2290fd447f781b1f799ba5cb8c0cb794833c40d8f16cc81b0abd4f77bd9dc990c7925e8be8832555f07cc6ede80f971b68ac5fc6e644d601e582b6
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpsl/libpsl_0.21.0.orig.tar.gz' libpsl_0.21.0.orig.tar.gz 8598583 SHA512:b7466edb9763f94a65330dbb3c19586f9c7b01e20ddedb38ca2fd4c9ee5764a4f9b3291dc4b76659b45425d954f15973345f917b2cd2de72ea731e8c41f2a265
'http://archive.ubuntu.com/ubuntu/pool/main/libp/libpsl/libpsl_0.21.0-1.2build2.debian.tar.xz' libpsl_0.21.0-1.2build2.debian.tar.xz 12896 SHA512:9d8c7130bee8c521e4f1ab1e13edfe2ed2fec538bda9133662d4120e8f5303595e6f27f466f30b07e61b94e138dd2787e17af91b8cc29275b5b4d2e098133eee
```

### `dpkg` source package: `libsass-python=0.20.1-3build1`

Binary Packages:

- `python3-libsass=0.20.1-3build1`

Licenses: (parsed from: `/usr/share/doc/python3-libsass/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris libsass-python=0.20.1-3build1
'http://archive.ubuntu.com/ubuntu/pool/universe/libs/libsass-python/libsass-python_0.20.1-3build1.dsc' libsass-python_0.20.1-3build1.dsc 2206 SHA512:557b553f44aa1051edd43eda68174af1ea16f9602b2cf4b45ecb88696f17d59c606c14d58e977178d23cf12f0b8e4a241bb26aa511d292d342a8e8fb74f48938
'http://archive.ubuntu.com/ubuntu/pool/universe/libs/libsass-python/libsass-python_0.20.1.orig.tar.gz' libsass-python_0.20.1.orig.tar.gz 55649 SHA512:c30cc15797e145aeb969654c3be868a148e1ae28de91cb48583fe3030ee26dbc4b18eab27f0d7796acd6b3c77fed093cd9dec64df560c8486d87841a42d9cf19
'http://archive.ubuntu.com/ubuntu/pool/universe/libs/libsass-python/libsass-python_0.20.1-3build1.debian.tar.xz' libsass-python_0.20.1-3build1.debian.tar.xz 5524 SHA512:9c09e2d752d2b2c446c803f3616109271a759adfb630bbedba89568e0c5ead417cb6d20f052d51c1ceb53426d7f6fb16e1599c1cbaa260fde1caa31b0435b5d7
```

### `dpkg` source package: `libsass=3.6.5-1ubuntu1`

Binary Packages:

- `libsass1:amd64=3.6.5-1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libsass1/copyright`)

- `BSL-1.0`
- `Expat`
- `FSFUL~Boost`
- `GPL-2`
- `GPL-2+ with Autoconf exception`
- `GPL-3`
- `GPL-3+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris libsass=3.6.5-1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/universe/libs/libsass/libsass_3.6.5-1ubuntu1.dsc' libsass_3.6.5-1ubuntu1.dsc 2155 SHA512:060bbc44fd6e94395899277d2fe242b333c6248b410f01a9b006b9e5aa86efae815f82605c303ed44534c30f05b7794dc22325e90895eabfab402bd96a26f1a7
'http://archive.ubuntu.com/ubuntu/pool/universe/libs/libsass/libsass_3.6.5.orig.tar.xz' libsass_3.6.5.orig.tar.xz 265972 SHA512:2a2f545e72a281ab7e3cfbc31024cfd04700d369b13737e317cc6bec5f2ff0aeaef680a0d5616d7246a46635351b7abe481e5250973edad6ab2ceaba03c1b0fc
'http://archive.ubuntu.com/ubuntu/pool/universe/libs/libsass/libsass_3.6.5-1ubuntu1.debian.tar.xz' libsass_3.6.5-1ubuntu1.debian.tar.xz 43864 SHA512:776a35ac36e0ea51efe68893c8af8bfcfc4004b503c67a422facb00941dacc4dfbbf896e9bae3f412a66f223f56dbf7d6568077e0b4ec8e7582394cc2881b895
```

### `dpkg` source package: `libseccomp=2.5.3-2ubuntu2`

Binary Packages:

- `libseccomp2:amd64=2.5.3-2ubuntu2`

Licenses: (parsed from: `/usr/share/doc/libseccomp2/copyright`)

- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libseccomp=2.5.3-2ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libseccomp/libseccomp_2.5.3-2ubuntu2.dsc' libseccomp_2.5.3-2ubuntu2.dsc 2799 SHA512:401672fbf5fc3d5ae529522bd94e5e5f8f158722d8ecebf1a1bc0569f652e8df182f18e647526b6434663b35736fe7c0536fcf19b99b060626cee91212b50c84
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libseccomp/libseccomp_2.5.3.orig.tar.gz' libseccomp_2.5.3.orig.tar.gz 637572 SHA512:00170fe2360f0c0b33293dccfcc33e98fabb99619f34ecefbcc92bfdaa249ba91e7433226545b842b71542a3b224b6e980ea2ae656c4addf07e84a0def1870a0
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libseccomp/libseccomp_2.5.3.orig.tar.gz.asc' libseccomp_2.5.3.orig.tar.gz.asc 833 SHA512:c879872448471fb1e01617145473254a0536ade1ff1e12871793631c3c63199cd46cb48317b4d596294d5cb187ff1fe9b58dc20ce52a89bfc9234a566bf8eb85
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libseccomp/libseccomp_2.5.3-2ubuntu2.debian.tar.xz' libseccomp_2.5.3-2ubuntu2.debian.tar.xz 23580 SHA512:c0333edd1130b8e0f90c9da61e5ce30aa0878eb27bf5862ae2d15f0e9728d792285a6d22e48d7f6681eaba5eb578958a15fdc6474036b0ee657a571f5a15f134
```

### `dpkg` source package: `libselinux=3.3-1build2`

Binary Packages:

- `libselinux1:amd64=3.3-1build2`

Licenses: (parsed from: `/usr/share/doc/libselinux1/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libselinux=3.3-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libselinux/libselinux_3.3-1build2.dsc' libselinux_3.3-1build2.dsc 2644 SHA512:e6f6744aeef21f3acf9c36fc6251515e6be8caf1b4953ed20d2346897c72bc919ae7e26ab8dfd0c2cf24029bd39da073e57ea19df15af106ce86ab4537c691aa
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libselinux/libselinux_3.3.orig.tar.gz' libselinux_3.3.orig.tar.gz 206826 SHA512:9a89c05ea4b17453168a985ece93ba6d6c4127916e657c46d4135eb59a1f6408faa0802cc2e49187defbde5247d659037beee089877affbab3eab6af3433696c
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libselinux/libselinux_3.3-1build2.debian.tar.xz' libselinux_3.3-1build2.debian.tar.xz 24052 SHA512:75e344ef0d123659105774a0fe941f5821d230bd3f4db0453918407325f6c08246db2cd609ec0ba51090b2942cd1a9a1865245a18834fa1b234d730103799c0c
```

### `dpkg` source package: `libsemanage=3.3-1build2`

Binary Packages:

- `libsemanage-common=3.3-1build2`
- `libsemanage2:amd64=3.3-1build2`

Licenses: (parsed from: `/usr/share/doc/libsemanage-common/copyright`, `/usr/share/doc/libsemanage2/copyright`)

- `GPL`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris libsemanage=3.3-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsemanage/libsemanage_3.3-1build2.dsc' libsemanage_3.3-1build2.dsc 2690 SHA512:6337e23938be6ebe18321ce9e67802ceaa2637e37bdc0940c4a4501e73f25235c662de1ec85807062327d2d5c5e7078ad0fb20d660e075710726cd0ede51e2fc
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsemanage/libsemanage_3.3.orig.tar.gz' libsemanage_3.3.orig.tar.gz 178890 SHA512:6026d9773c0886436ad801bc0c8beac888b6fb62034edeb863192dea4b6ef34a88e080758820fe635a20e048ac666beee505a0f946258f18571709cca5228aad
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsemanage/libsemanage_3.3-1build2.debian.tar.xz' libsemanage_3.3-1build2.debian.tar.xz 17920 SHA512:b23e000956a6fc96c7609a749d1974874834b6a463b0f5b42b3e4bde75f560789f7ef7f385a3a7297e97f7c610cd0c2899986b3a228671a57e051310441b0c90
```

### `dpkg` source package: `libsepol=3.3-1build1`

Binary Packages:

- `libsepol2:amd64=3.3-1build1`

Licenses: (parsed from: `/usr/share/doc/libsepol2/copyright`)

- `GPL`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris libsepol=3.3-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsepol/libsepol_3.3-1build1.dsc' libsepol_3.3-1build1.dsc 2217 SHA512:91f9c8436df88aa898f2e3ea4a8bbb0cb21de84153bc88b9fff30b2aa3f0e6b11d5b9f506b81d0266e8a4881ea86d6590abe64b8eacc2d8cdeaf1a0f5f2784bf
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsepol/libsepol_3.3.orig.tar.gz' libsepol_3.3.orig.tar.gz 482546 SHA512:fb6bb69f8e43a911a1a9cbd791593215386e93cb9292e003f5d8efe6e86e0ce5d0287e95d52fe2fbce518a618beaf9b1135aea0d04eaebcdbd8c6d07ee67b500
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsepol/libsepol_3.3-1build1.debian.tar.xz' libsepol_3.3-1build1.debian.tar.xz 15068 SHA512:adb210e2dab83baa49cee624dc5ae44e9f2dff6eb4a0a7bee4b958e99871580df159d0ca339feca31d9c4cdd92d0022a841c35d615436278046379eeb766f1f2
```

### `dpkg` source package: `libsm=2:1.2.3-1build2`

Binary Packages:

- `libsm6:amd64=2:1.2.3-1build2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libsm=2:1.2.3-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsm/libsm_1.2.3-1build2.dsc' libsm_1.2.3-1build2.dsc 2170 SHA512:4dc5d9445614801154fb411ae2089c80c55adaea90a9d78a958724d70fc8ea8d36c9a898a478f18a9669f3448d9d9a948c632f2a4869287d1e1f88403e304096
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsm/libsm_1.2.3.orig.tar.gz' libsm_1.2.3.orig.tar.gz 445362 SHA512:03b77d86b33cdb3df4f9d65131a0025182f3cb0c17b33a90d236e8563b3011d225b9d006186302d07850edafa5b899aec6a086b8d437d357cd69fedd5f22d94b
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libsm/libsm_1.2.3-1build2.diff.gz' libsm_1.2.3-1build2.diff.gz 9062 SHA512:c5ddeb48fe7c846b31382a5da42a2970ae12995afb322c6291977b7ffd2251d4d9e9dc163ecb008902ae8ee3c3a44526115bddc92b402c8f4a9ea0f29f1cb037
```

### `dpkg` source package: `libssh=0.9.6-2ubuntu0.22.04.3`

Binary Packages:

- `libssh-4:amd64=0.9.6-2ubuntu0.22.04.3`

Licenses: (parsed from: `/usr/share/doc/libssh-4/copyright`)

- `BSD-2-clause`
- `BSD-3-clause`
- `LGPL-2.1`
- `LGPL-2.1+~OpenSSL`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris libssh=0.9.6-2ubuntu0.22.04.3
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libssh/libssh_0.9.6-2ubuntu0.22.04.3.dsc' libssh_0.9.6-2ubuntu0.22.04.3.dsc 2884 SHA512:d118e2881416d2a4e4d07fb7056c42651e8c5b80a9bc6dccb996559351847bfe7fa28a07926b0027484f091ccd6ae0436c40f82ca9bdf8c8286c191d8f9b723c
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libssh/libssh_0.9.6.orig.tar.xz' libssh_0.9.6.orig.tar.xz 1053056 SHA512:4040ec4af937e95be2e41313ef6d4db60b46b8d4dea10c09402398127c1d1ca8843392d207088aeee3c7ef631c6ae7b66861327dcebf78ed3af0723777619fd1
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libssh/libssh_0.9.6.orig.tar.xz.asc' libssh_0.9.6.orig.tar.xz.asc 833 SHA512:1b6223efe9e4ce864cd8d97d517f9f0d38c1cd502b5874fdc6a58731038c2830a72ce753f02fc062d9d4d5922107ec9a2e62fe24a704bb5dec0dcfecdb569fe6
'http://archive.ubuntu.com/ubuntu/pool/main/libs/libssh/libssh_0.9.6-2ubuntu0.22.04.3.debian.tar.xz' libssh_0.9.6-2ubuntu0.22.04.3.debian.tar.xz 52472 SHA512:26a7a01afe7e6d6d7da87e2afb76fe8972e1aa471ea6cd763ff2ff0508ae560f7b7ca110577ca4f6bcc071100eeb0653862203bc47b7f91e9ca5b628647c7c4b
```

### `dpkg` source package: `libtasn1-6=4.18.0-4build1`

Binary Packages:

- `libtasn1-6:amd64=4.18.0-4build1`

Licenses: (parsed from: `/usr/share/doc/libtasn1-6/copyright`)

- `GFDL-1.3`
- `GPL-3`
- `LGPL`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libtasn1-6=4.18.0-4build1
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtasn1-6/libtasn1-6_4.18.0-4build1.dsc' libtasn1-6_4.18.0-4build1.dsc 2794 SHA512:cb0f727f9935cdb7784451234c676f0e3544789cc01dd6786006d4662807937722437de6450f4bd24b698b621b7dfa7eaf28d607402ecbb8167315791739d570
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtasn1-6/libtasn1-6_4.18.0.orig.tar.gz' libtasn1-6_4.18.0.orig.tar.gz 1724441 SHA512:4f2f4afc7561fda7a1f1c6c525c3c3b08228a1a4aa8c3d3d5e02e993d8f83ccee1dd0f1b201cec0fbfc97043d4b1d7a95ffd34d65422a38b85b931ac7a015831
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtasn1-6/libtasn1-6_4.18.0.orig.tar.gz.asc' libtasn1-6_4.18.0.orig.tar.gz.asc 228 SHA512:8ef3918a3130f695d2d5b26dd945084b931005eff8914c50a0ac9795d4cc6ec9e9645e2941ff4235cba3b4b2987ab1c7da65225e24ce16aaab844352ecdafbf6
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtasn1-6/libtasn1-6_4.18.0-4build1.debian.tar.xz' libtasn1-6_4.18.0-4build1.debian.tar.xz 22112 SHA512:4c363cfa12bd27c22a32ced69ca560ed6d3af2404158dcb0c1be472c6af411931f5d807f77b9966a1fb6bc9089d3d354fc85c3144d8beaabe36036694898a82e
```

### `dpkg` source package: `libthai=0.1.29-1build1`

Binary Packages:

- `libthai-data=0.1.29-1build1`
- `libthai0:amd64=0.1.29-1build1`

Licenses: (parsed from: `/usr/share/doc/libthai-data/copyright`, `/usr/share/doc/libthai0/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris libthai=0.1.29-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libthai/libthai_0.1.29-1build1.dsc' libthai_0.1.29-1build1.dsc 2457 SHA512:d4181f56ccec5cddf5e65a01386d30b51a1e9cea2fd671577fa5cf14435ea3e9b0a6e6668f1f008a0d4180067d4498b163309f5a7a51b2f4ef64ab868439bb0c
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libthai/libthai_0.1.29.orig.tar.xz' libthai_0.1.29.orig.tar.xz 417728 SHA512:0ba1261581a1705a2a2546a3071acb3c63892dbf111f0dad415667165a6b9542a5e4549061c67b11ec53de7c9e70fceb3c04d794fd12a22d991a539dbacebda1
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libthai/libthai_0.1.29-1build1.debian.tar.xz' libthai_0.1.29-1build1.debian.tar.xz 12676 SHA512:fd2032f66f172ee3e2646099205474c2bbe6a0dd0f0fd685b9e8add66017a160946d5708b4bac4ae9aa5da3062eafdc34c0228c99910b1c013aaee29b9ab9d07
```

### `dpkg` source package: `libtirpc=1.3.2-2ubuntu0.1`

Binary Packages:

- `libtirpc-common=1.3.2-2ubuntu0.1`
- `libtirpc3:amd64=1.3.2-2ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libtirpc-common/copyright`, `/usr/share/doc/libtirpc3/copyright`)

- `BSD-2-Clause`
- `BSD-3-Clause`
- `BSD-4-Clause`
- `GPL-2`
- `LGPL-2.1`
- `LGPL-2.1+`
- `PERMISSIVE`
- `__AUTO_PERMISSIVE__`

Source:

```console
$ apt-get source -qq --print-uris libtirpc=1.3.2-2ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtirpc/libtirpc_1.3.2-2ubuntu0.1.dsc' libtirpc_1.3.2-2ubuntu0.1.dsc 2201 SHA512:da9e64904445de59217c2bfa55ca9739e0b08ac4693a45a813b7fc67273e106a11e7076d39d24e5f62d242af4e2eaac9e5503072b57f4cf7bdfa579a82920e77
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtirpc/libtirpc_1.3.2.orig.tar.bz2' libtirpc_1.3.2.orig.tar.bz2 513151 SHA512:8664d5c4f842ee5acf83b9c1cadb7871f17b8157a7c4500e2236dcfb3a25768cab39f7c5123758dcd7381e30eb028ddfa26a28f458283f2dcea3426c9878c255
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtirpc/libtirpc_1.3.2-2ubuntu0.1.debian.tar.xz' libtirpc_1.3.2-2ubuntu0.1.debian.tar.xz 18364 SHA512:5440c46e49837b176b8087d82762002766e48a7d487e101049079637ebb93c21fbb1dccd63a319f72ee11d7964873c00dc98a7b5b320355d640df7f9e16ab1c7
```

### `dpkg` source package: `libtool=2.4.6-15build2`

Binary Packages:

- `libltdl7:amd64=2.4.6-15build2`

Licenses: (parsed from: `/usr/share/doc/libltdl7/copyright`)

- `GFDL`
- `GPL`

Source:

```console
$ apt-get source -qq --print-uris libtool=2.4.6-15build2
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtool/libtool_2.4.6-15build2.dsc' libtool_2.4.6-15build2.dsc 2634 SHA512:a7cdb710cae727fdb1948326fc7af9faef0634b1ebfebfcdfb94407cc2242af45e408c48bff07d075fa7f608c2f06f9257c64ec7d21341b771bf4b55f04ed5c9
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtool/libtool_2.4.6.orig.tar.xz' libtool_2.4.6.orig.tar.xz 973080 SHA512:a6eef35f3cbccf2c9e2667f44a476ebc80ab888725eb768e91a3a6c33b8c931afc46eb23efaee76c8696d3e4eed74ab1c71157bcb924f38ee912c8a90a6521a4
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtool/libtool_2.4.6.orig.tar.xz.asc' libtool_2.4.6.orig.tar.xz.asc 380 SHA512:2f26447a837e3242b8f8f38fbab22d89df0949ee62fd966af3b5bae3aa939ba53bc4621174ee58d1c6722d569d7fe5f90097ddccffed28c3067fe5fa996fcb89
'http://archive.ubuntu.com/ubuntu/pool/main/libt/libtool/libtool_2.4.6-15build2.debian.tar.xz' libtool_2.4.6-15build2.debian.tar.xz 54076 SHA512:324a79af930a793b3b0031a1bb727b5ed16016b8e55294f24410ee9cfe2a2db75aab2d1ace8901fdaba610069f00e246d4d552faa23d583c741da0de438377cb
```

### `dpkg` source package: `libunistring=1.0-1`

Binary Packages:

- `libunistring2:amd64=1.0-1`

Licenses: (parsed from: `/usr/share/doc/libunistring2/copyright`)

- `FreeSoftware`
- `GFDL-1.2`
- `GFDL-1.2+`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with distribution exception`
- `GPL-3`
- `GPL-3+`
- `LGPL-3`
- `LGPL-3+`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris libunistring=1.0-1
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libunistring/libunistring_1.0-1.dsc' libunistring_1.0-1.dsc 1928 SHA512:630d20ef6dd19be991147131d38acae2db15d1df34403264a15a373fcd4b661efffc1ae3916c52448f05cafb93bf1266527efa6630a02def88b86495d688a0c3
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libunistring/libunistring_1.0.orig.tar.xz' libunistring_1.0.orig.tar.xz 2367800 SHA512:70d5ad82722844dbeacdfcb4d7593358e4a00a9222a98537add4b7f0bf4a2bb503dfb3cd627e52e2a5ca1d3da9e5daf38a6bd521197f92002e11e715fb1662d1
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libunistring/libunistring_1.0-1.debian.tar.xz' libunistring_1.0-1.debian.tar.xz 42004 SHA512:f9208e7ab38cc742bb46dc1a871ddb03847b99b6169e20e8d8660dd9cdf22bffb27f9b329dcbd025ad9b26aee5a2aab01337f36d8ab3020d2e752f9c2d4368ce
```

### `dpkg` source package: `libusb-1.0=2:1.0.25-1ubuntu2`

Binary Packages:

- `libusb-1.0-0:amd64=2:1.0.25-1ubuntu2`

Licenses: (parsed from: `/usr/share/doc/libusb-1.0-0/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libusb-1.0=2:1.0.25-1ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libusb-1.0/libusb-1.0_1.0.25-1ubuntu2.dsc' libusb-1.0_1.0.25-1ubuntu2.dsc 1636 SHA512:a57172dd5247ad5a7e0492a129f27c4cdb6662c5ef6a886433c383ae95f38f2e1a85ed5f8c00f91f893118eb37e7b9a4acd6ae18367f5c9eba03743db356ee45
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libusb-1.0/libusb-1.0_1.0.25.orig.tar.bz2' libusb-1.0_1.0.25.orig.tar.bz2 609127 SHA512:f1e6e5577d4bd1ff136927dc66c615014a06ac332ddd797b1d1ad5f7b68e2405e66068dcb210e2f0ae3e31681603ef72efbd88bf7fbe0eb41ce700fdc3f92f9d
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libusb-1.0/libusb-1.0_1.0.25-1ubuntu2.debian.tar.xz' libusb-1.0_1.0.25-1ubuntu2.debian.tar.xz 15544 SHA512:ab2c50ce52dfb5bc47265506db8c7bbffe9b88bfc7cb947b195d3b46e6203cadcbab5005cc168c178c3b3c6134b71b75a600dc967a1e2392fb2e55157e91b767
```

### `dpkg` source package: `libuv1=1.43.0-1ubuntu0.1`

Binary Packages:

- `libuv1:amd64=1.43.0-1ubuntu0.1`
- `libuv1-dev:amd64=1.43.0-1ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libuv1/copyright`, `/usr/share/doc/libuv1-dev/copyright`)

- `Apache-2.0`
- `BSD-1-clause`
- `BSD-2-clause`
- `BSD-3-clause`
- `CC-BY-4.0`
- `Expat`
- `GPL3+ with autoconf exception`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris libuv1=1.43.0-1ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libuv1/libuv1_1.43.0-1ubuntu0.1.dsc' libuv1_1.43.0-1ubuntu0.1.dsc 2112 SHA512:ed025d990a1285fcfdfeafdbac651571f7eb3dd0eda17261378d93ef635563922247c2c2a87a62b4f426531a4508730d9c7ba1a8130c58fb5bf9aebf0e8e2f48
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libuv1/libuv1_1.43.0.orig.tar.gz' libuv1_1.43.0.orig.tar.gz 1296029 SHA512:5a000b5a57efa03218cb8cc8deac91a8371f472452f48fef7d15c8d03ea0d98a966feba1ad9f2bf00f03635563663562dbd6d0cd2018e4d6c9783e64c2b3cd92
'http://archive.ubuntu.com/ubuntu/pool/main/libu/libuv1/libuv1_1.43.0-1ubuntu0.1.debian.tar.xz' libuv1_1.43.0-1ubuntu0.1.debian.tar.xz 21876 SHA512:c37c2cb3d4be67220482be266dbc08243c8412714a0da039eebd03ec1bc7ecf3ccf91d49005545d4361dcc33012a48a6045c400611eb9887785f10284ab6c8da
```

### `dpkg` source package: `libwebp=1.2.2-2ubuntu0.22.04.2`

Binary Packages:

- `libwebp7:amd64=1.2.2-2ubuntu0.22.04.2`
- `libwebpdemux2:amd64=1.2.2-2ubuntu0.22.04.2`
- `libwebpmux3:amd64=1.2.2-2ubuntu0.22.04.2`

Licenses: (parsed from: `/usr/share/doc/libwebp7/copyright`, `/usr/share/doc/libwebpdemux2/copyright`, `/usr/share/doc/libwebpmux3/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris libwebp=1.2.2-2ubuntu0.22.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwebp/libwebp_1.2.2-2ubuntu0.22.04.2.dsc' libwebp_1.2.2-2ubuntu0.22.04.2.dsc 2186 SHA512:b81aa127277d4927b79d4ea5c8b63369f0b63e4944cc70bd98b277a1ae890169d91f4a0f30502830975bd2e34faa7a861b82d61f19ef660be1b7cf1d86010668
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwebp/libwebp_1.2.2.orig.tar.gz' libwebp_1.2.2.orig.tar.gz 4117468 SHA512:0dd0a721352b513a218d55383bcd0cc45b786df8089f70f87257b5dcc0c4e2f1798e20f1ca98b8fe51710abb667f9c4c14f20f980a11c484c8832f0dc66e3bff
'http://archive.ubuntu.com/ubuntu/pool/main/libw/libwebp/libwebp_1.2.2-2ubuntu0.22.04.2.debian.tar.xz' libwebp_1.2.2-2ubuntu0.22.04.2.debian.tar.xz 10468 SHA512:3c524505239652dbd3252aaaeee9161b0bb4c2ad146849341e87370760554de17d748d9b6f03c5e35db2d3f3dfedcf5e62b165502d207d2a114bda907483a830
```

### `dpkg` source package: `libx11=2:1.7.5-1ubuntu0.3`

Binary Packages:

- `libx11-6:amd64=2:1.7.5-1ubuntu0.3`
- `libx11-data=2:1.7.5-1ubuntu0.3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libx11=2:1.7.5-1ubuntu0.3
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libx11/libx11_1.7.5-1ubuntu0.3.dsc' libx11_1.7.5-1ubuntu0.3.dsc 2654 SHA512:97c9c7e8096cdb264d45a08f0333025ded9b74296689809d687de62b60b5d5ef7d2dc8b592b8155dbe12aa18129f97a12b978234b52ba2ed553568d207c62fce
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libx11/libx11_1.7.5.orig.tar.gz' libx11_1.7.5.orig.tar.gz 3170022 SHA512:90474f5f95c3498a02100aeeb6b5ad7ae9076bc40a70cdd828bd881adac0bf278002186142f2760e5504cf82120f4869798831e0e2332ecbc6903e8f7c9114ab
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libx11/libx11_1.7.5.orig.tar.gz.asc' libx11_1.7.5.orig.tar.gz.asc 358 SHA512:75139b9f7b2f19aed3d3a66ea8b883480db2fa56d713bb0160ea8a0faba208da4c241768f9f2703f723f13906438eda3117f489d7d5d17fbe1cbb75b13c9935d
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libx11/libx11_1.7.5-1ubuntu0.3.diff.gz' libx11_1.7.5-1ubuntu0.3.diff.gz 98716 SHA512:54531c960c2252c99e2f32f0d051eb1e764f181aaa68fc20a053384f70b14f32872e9ca05ed45affd2e97ea2821cdd8c3e3ebacf8c81c3088386a7d95214f64b
```

### `dpkg` source package: `libxau=1:1.0.9-1build5`

Binary Packages:

- `libxau6:amd64=1:1.0.9-1build5`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxau=1:1.0.9-1build5
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxau/libxau_1.0.9-1build5.dsc' libxau_1.0.9-1build5.dsc 2315 SHA512:b9a9d6888a70e8c7e8161a322a425316ed181d00ad3881caea788aeda9c4346122a70c57d30b91e7692f5c0b468da9d784c228ead5487cfb2474f4fc42b83ada
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxau/libxau_1.0.9.orig.tar.gz' libxau_1.0.9.orig.tar.gz 394068 SHA512:3b22f34a4e35d17421189df8ce3f858b0914aef0cea0b12689dd8576f14eb811e39d6e32384251573daa7e3daba400deea98e7c0e29b4105138cf82195d7f875
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxau/libxau_1.0.9.orig.tar.gz.asc' libxau_1.0.9.orig.tar.gz.asc 801 SHA512:e59b2944591499d0c0291a8d80ad8ee2cb13ee00c32b0d26c6af12a2bb96c947d4d15924ef15b377b8d7640b75b50f9b8127ba53c582090b3f73b7bcf9e00b01
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxau/libxau_1.0.9-1build5.diff.gz' libxau_1.0.9-1build5.diff.gz 10579 SHA512:9485f97bc34a7b348a7bd276001ff5e455a17c8d6b6d6e4382496c38f470f1650f7177103d2b123f25f21ce62899ceb3112909ee92e9a604d302d3c63cb59e8f
```

### `dpkg` source package: `libxaw=2:1.0.14-1`

Binary Packages:

- `libxaw7:amd64=2:1.0.14-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxaw=2:1.0.14-1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxaw/libxaw_1.0.14-1.dsc' libxaw_1.0.14-1.dsc 2352 SHA512:86716dd1d303d27b00dc9a5d4023e669c45a5bd3b212d3f5d02460a2deafcb7f2a048d07b47d092353935f56fce836a7931f357278ff2906f18dafc86792acbc
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxaw/libxaw_1.0.14.orig.tar.gz' libxaw_1.0.14.orig.tar.gz 886122 SHA512:1205481443627b428f6c447a3926a060af30440badc401ca8d209849faef21ce967cf7f26ab452b47a64071980f9892cce83b2d70db0c2b7d6cabf838ab93884
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxaw/libxaw_1.0.14.orig.tar.gz.asc' libxaw_1.0.14.orig.tar.gz.asc 618 SHA512:87db1130f7b69b75ec9ce91f7b3a2e8519da597c4faefb36c191555aaa35af9ac3576ae040ba4c7e74aefd8fb6bcdabd9ed1aacff13c40d1158f6003df4bf53b
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxaw/libxaw_1.0.14-1.diff.gz' libxaw_1.0.14-1.diff.gz 28936 SHA512:5545c68a10e47bfa42fcaeafe285f9cea3e68d43bc5a6d1a926052cba8f008bc2e7dda047e22c31c4bff79b008d3fe3726e6af6d96c9c8dbe1a854abcd5a385a
```

### `dpkg` source package: `libxcb=1.14-3ubuntu3`

Binary Packages:

- `libxcb-render0:amd64=1.14-3ubuntu3`
- `libxcb-shm0:amd64=1.14-3ubuntu3`
- `libxcb1:amd64=1.14-3ubuntu3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxcb=1.14-3ubuntu3
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcb/libxcb_1.14-3ubuntu3.dsc' libxcb_1.14-3ubuntu3.dsc 5480 SHA512:cc563eae53e92b3f5cf700f0a61ee036fe0df9a109453dd4cd6a8107dac4a7f6d85e28810011ef74ca69ca36853a8d20e877480b94344ad5262f8fd6da299d5c
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcb/libxcb_1.14.orig.tar.gz' libxcb_1.14.orig.tar.gz 640322 SHA512:6114d8c233b42b56604787a0475e924143aa13f1d382e6029b2150a4360c12ce78073409f754fbb1e5d9f99fc26900c0a4c59e9cfbd4c3d0a3af0c1306e62da1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcb/libxcb_1.14-3ubuntu3.diff.gz' libxcb_1.14-3ubuntu3.diff.gz 27588 SHA512:228c6da2cf94e02b249ccb04f2668f45b2ab117a4c6670ac6f7ab449582e459df4fc7e1ce5ae5cd945acea6fd00b935ed6394c800ee3d92ce9a0fb6913460f86
```

### `dpkg` source package: `libxcrypt=1:4.4.27-1`

Binary Packages:

- `libcrypt1:amd64=1:4.4.27-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxcrypt=1:4.4.27-1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcrypt/libxcrypt_4.4.27-1.dsc' libxcrypt_4.4.27-1.dsc 1525 SHA512:1335a2ab3f7b519022af13c18dca9ea1c2de3007c07f120d53fbb7eb834ac7e0ece120681c1ee1dd92771469104dccedef3a7e85ec51fc1ca64b52c9447558c0
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcrypt/libxcrypt_4.4.27.orig.tar.xz' libxcrypt_4.4.27.orig.tar.xz 391772 SHA512:9d194066ab7eefd3e568b2478d58aa378da8571abf4c37ddcde2c01114a4aa69f0edfb4e3d13d951feac5955336f9b02046d9b1fd1b9fbfbc556aad31cf64d7e
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxcrypt/libxcrypt_4.4.27-1.debian.tar.xz' libxcrypt_4.4.27-1.debian.tar.xz 7764 SHA512:02e38ba06f3555dd930fc7ed44602dc816ce48f4c29fdc085249948596d5e7e96600cb81c8c9fb2e1dc33574d5136d08feeff3eb1dd3522aa8e5cdc9037c1ae0
```

### `dpkg` source package: `libxdmcp=1:1.1.3-0ubuntu5`

Binary Packages:

- `libxdmcp6:amd64=1:1.1.3-0ubuntu5`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxdmcp=1:1.1.3-0ubuntu5
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxdmcp/libxdmcp_1.1.3-0ubuntu5.dsc' libxdmcp_1.1.3-0ubuntu5.dsc 2252 SHA512:5b6df4dd48380acff08dbe1fe40258d33a2f431e27da076ce54e0a1714dacb1e031aa49e2ace3863dc2131de4df42aa76b423f44f520fd8b2dbb18c4bddcada1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxdmcp/libxdmcp_1.1.3.orig.tar.gz' libxdmcp_1.1.3.orig.tar.gz 429668 SHA512:edd05654ad9ea893e9e08269e25ea050d10eaf9f997a08494e24127d1ba0c896cd5338b4595b155c8cbf576e1d910b76e6ad7820fee62d74644f1f276551e2f2
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxdmcp/libxdmcp_1.1.3-0ubuntu5.diff.gz' libxdmcp_1.1.3-0ubuntu5.diff.gz 18395 SHA512:552a04477a7852b2a68ba268dcd19cee9dd89c2774b6c86ca8f11180f6b179cc7853348653cf3b7d3e89a0079bef91308e8da2dfd34d0f42104f352e47ea07bd
```

### `dpkg` source package: `libxext=2:1.3.4-1build1`

Binary Packages:

- `libxext6:amd64=2:1.3.4-1build1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxext=2:1.3.4-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxext/libxext_1.3.4-1build1.dsc' libxext_1.3.4-1build1.dsc 2250 SHA512:d7a857fa82374d6b0f1435f55c697f82f5f17e9492d74eea29e04679eb6a5dd49aeb88abb048e904de207c57d16d5ad487067e6fb45696834ac5c934040d7e90
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxext/libxext_1.3.4.orig.tar.gz' libxext_1.3.4.orig.tar.gz 494434 SHA512:4eebd639fd57cb9b84a1e17e368f82fbf3d9f021eef5ad3fe31dd128500db57862a82c1e0d214d447cb7641b2be3fd7e949ee1196f2a482793c6628fb1e5cd70
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxext/libxext_1.3.4-1build1.diff.gz' libxext_1.3.4-1build1.diff.gz 12588 SHA512:bfcebe8e6e277dc1ea81063a4a4663e24b78f2b69439e3b8ed2209168016876f55e8e95c6a1828ab5bf7a1936ec795e14f4391b24ec8801e0102e00e953d46e4
```

### `dpkg` source package: `libxml2=2.9.13+dfsg-1ubuntu0.4`

Binary Packages:

- `libxml2:amd64=2.9.13+dfsg-1ubuntu0.4`

Licenses: (parsed from: `/usr/share/doc/libxml2/copyright`)

- `ISC`
- `MIT-1`

Source:

```console
$ apt-get source -qq --print-uris libxml2=2.9.13+dfsg-1ubuntu0.4
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml2/libxml2_2.9.13%2bdfsg-1ubuntu0.4.dsc' libxml2_2.9.13+dfsg-1ubuntu0.4.dsc 3030 SHA512:766e6ac92f700f594da935dec46aef15bd51269241715e279082947d2f0ce5a9209e5928ef513ee4f382539b63a51ba633fc7e896eacfa911f398332e58af718
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml2/libxml2_2.9.13%2bdfsg.orig.tar.xz' libxml2_2.9.13+dfsg.orig.tar.xz 2351356 SHA512:6283071de4934c856c7ff5202ac1a2ed5892d7fcde82a364d40c8bc2bf3d3201fbcbb5f6983d8bf6b962026bc216b8182d71efe280f1dcef2931b277314e6e89
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxml2/libxml2_2.9.13%2bdfsg-1ubuntu0.4.debian.tar.xz' libxml2_2.9.13+dfsg-1ubuntu0.4.debian.tar.xz 37288 SHA512:fd4b62393aaaef05df66dd1fb2c3ff2ead7eb40127a443bc9ee0ff96ae335f508801a933bf986eab0ed45758b47afa8bf93bfb5a83ae5ac9e5de12f1ddde8749
```

### `dpkg` source package: `libxmu=2:1.1.3-3`

Binary Packages:

- `libxmu6:amd64=2:1.1.3-3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxmu=2:1.1.3-3
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxmu/libxmu_1.1.3-3.dsc' libxmu_1.1.3-3.dsc 2165 SHA512:7868975bb24189125a57910121c07bfd40fcb57af86a61665d7480f34339c566f4684e1db849d4d589a0e01bb59925ee8de0089bff4df436502e714c3bcc1dec
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxmu/libxmu_1.1.3.orig.tar.gz' libxmu_1.1.3.orig.tar.gz 497343 SHA512:b92fb2e96519880e9f057ae4149bd1bd95584383c6224891f3d832d98ace9292269815fe51d06a4dfc257f51021c2f7367e2f529a7ebcc3dfc64f037720a1cb8
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxmu/libxmu_1.1.3-3.diff.gz' libxmu_1.1.3-3.diff.gz 8085 SHA512:afefb6de2e65cfd1174b58a25f4598966adc375378d6525b2ddac98dce20276ae9ce03b1eb14b3a3a186e2ce00b7d68133a2578048f2582c5bb7b6be42a16fa6
```

### `dpkg` source package: `libxpm=1:3.5.12-1ubuntu0.22.04.2`

Binary Packages:

- `libxpm4:amd64=1:3.5.12-1ubuntu0.22.04.2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxpm=1:3.5.12-1ubuntu0.22.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxpm/libxpm_3.5.12-1ubuntu0.22.04.2.dsc' libxpm_3.5.12-1ubuntu0.22.04.2.dsc 2203 SHA512:4989c9092997e6ed7b8ff6f79e29a49b4e5b7b0e501e063545cee478d18126f5a5f9d6d4f6774af669f8512e9fe93d050117f45b58612a4c896bca03a023c8fb
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxpm/libxpm_3.5.12.orig.tar.gz' libxpm_3.5.12.orig.tar.gz 529302 SHA512:17169016efc1e139f079290b2369fd62df8617867d97d2f50940521951a50f173118143109f0d7c552de92913cefc5ccaeb52225ccdd9abc89b3b85d9b5669f7
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxpm/libxpm_3.5.12-1ubuntu0.22.04.2.diff.gz' libxpm_3.5.12-1ubuntu0.22.04.2.diff.gz 21876 SHA512:6f61d1f62db0fd63ce98cce2864ae0d96594433d9da28178453f46ef9ec0b110f8cb6f2c5c8fa6fd79aa86c0813bac5a8d3ddc98e73fb49b3f391e1a03f9c150
```

### `dpkg` source package: `libxrender=1:0.9.10-1build4`

Binary Packages:

- `libxrender1:amd64=1:0.9.10-1build4`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxrender=1:0.9.10-1build4
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxrender/libxrender_0.9.10-1build4.dsc' libxrender_0.9.10-1build4.dsc 2196 SHA512:4e5f32bd1ea1a7c78bd3f186fff28ead08e814f25029e6d955b323998c1a64ee53e6862b89aa73a9d2f84207cef9da28127bc2a40ce74f55cff37b198979b76d
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxrender/libxrender_0.9.10.orig.tar.gz' libxrender_0.9.10.orig.tar.gz 373717 SHA512:7768e62b500f468460f88f27bc1130170b204b478573d9e4406867e557b5638b7c1e21d88d51f9e774ce2344780a384e3c3be51421275d2ee880f9a978a3a232
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxrender/libxrender_0.9.10-1build4.diff.gz' libxrender_0.9.10-1build4.diff.gz 15809 SHA512:8c0fe7e340497564286087bc95c6fac4ac9130723bc7389dfc88cf4172dc77ae657e8bcb8c6a99ff53ee8aca1072ad5279e4b7588499209851059948eb2869a0
```

### `dpkg` source package: `libxslt=1.1.34-4ubuntu0.22.04.1`

Binary Packages:

- `libxslt1.1:amd64=1.1.34-4ubuntu0.22.04.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxslt=1.1.34-4ubuntu0.22.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxslt/libxslt_1.1.34-4ubuntu0.22.04.1.dsc' libxslt_1.1.34-4ubuntu0.22.04.1.dsc 2514 SHA512:c4e9c1afd99865a611bf6b8212f6dfa49291e4eedb83044916afe3cc6518eaab64afddd9c31e2c03e11670ad6af21d422c3570f37708cb025c32bba5c47741a6
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxslt/libxslt_1.1.34.orig.tar.gz' libxslt_1.1.34.orig.tar.gz 3552258 SHA512:1516a11ad608b04740674060d2c5d733b88889de5e413b9a4e8bf8d1a90d712149df6d2b1345b615f529d7c7d3fa6dae12e544da828b39c7d415e54c0ee0776b
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxslt/libxslt_1.1.34.orig.tar.gz.asc' libxslt_1.1.34.orig.tar.gz.asc 488 SHA512:9b155d4571daede99cdbf2813a85fb04812737b5e23d3f7c9840225b38f3dbf171623a21645daaee190e7ff9ba38bde932922e96a2a2312c203ffa9917c3baea
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxslt/libxslt_1.1.34-4ubuntu0.22.04.1.debian.tar.xz' libxslt_1.1.34-4ubuntu0.22.04.1.debian.tar.xz 23376 SHA512:20c348766fd3688aab280bfe400bb99bc684e8af9aba3b5ba8a067dd32b6a8e4f1d21819f9f0ec8f74e72c63b18e8c4b75b0b4075bb041fd5e35ad5d20e40c74
```

### `dpkg` source package: `libxt=1:1.2.1-1`

Binary Packages:

- `libxt6:amd64=1:1.2.1-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxt=1:1.2.1-1
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxt/libxt_1.2.1-1.dsc' libxt_1.2.1-1.dsc 2312 SHA512:6176a90a0e929b22b0b2cc9e34844e904353ecac42fec4498005fb16a1c614051ad7d5dc407489316bdc7a7a7db19800ef43b06bb450961171b86200a2044b9c
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxt/libxt_1.2.1.orig.tar.gz' libxt_1.2.1.orig.tar.gz 1024473 SHA512:73c2fd8a6590ab5ee93cf646e4f41fb71d424961ecbf9bc13c68abdf539c63ab0c59a4d3b22195ba21859523f4cf0e937648424532794a1350a5891061096503
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxt/libxt_1.2.1.orig.tar.gz.asc' libxt_1.2.1.orig.tar.gz.asc 358 SHA512:135e01b8a79beac9530087dee1a5458c359b4f1ae8346e2502f72f4fc24be400477fda90944315c585e3416e80cb74d1a140d5dfec81e854a4996199a8b221dc
'http://archive.ubuntu.com/ubuntu/pool/main/libx/libxt/libxt_1.2.1-1.diff.gz' libxt_1.2.1-1.diff.gz 45419 SHA512:432a4911d7c6a15f87a093104c1e91df9b122410394ad242d8d5e219fe6c4d65c4ae99b82aafece96dea706f43601dab365557af18c7f332a812012eff0dabf1
```

### `dpkg` source package: `libyaml=0.2.2-1build2`

Binary Packages:

- `libyaml-0-2:amd64=0.2.2-1build2`

Licenses: (parsed from: `/usr/share/doc/libyaml-0-2/copyright`)

- `Expat`
- `permissive`

Source:

```console
$ apt-get source -qq --print-uris libyaml=0.2.2-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/liby/libyaml/libyaml_0.2.2-1build2.dsc' libyaml_0.2.2-1build2.dsc 2139 SHA512:41b3ce50b076da1118a639496dcda225ed8d7534079f61a470d6d6f80b34c7f0df8e1850024e78a73b25e695c4b10049ce50b09acaca6a2c8145adbf3f41cdad
'http://archive.ubuntu.com/ubuntu/pool/main/liby/libyaml/libyaml_0.2.2.orig.tar.gz' libyaml_0.2.2.orig.tar.gz 602509 SHA512:0728c89ba43af3cdec22bccaf18c9ad7b07e13cdebed9d8919e2c62cf90bb5e23d2c746fd250320b2827dfcd9f1ce442d3bf8a3fe18b61f9a8d1d7770561e610
'http://archive.ubuntu.com/ubuntu/pool/main/liby/libyaml/libyaml_0.2.2-1build2.debian.tar.xz' libyaml_0.2.2-1build2.debian.tar.xz 4284 SHA512:50eb5194764d06438ef0f1a4690a400f1d61ab311a1e72e1c004e1ad15f85de02822012936d7a3f5fc741a325fad490135f3bc14ccf6948e44faa75cabf2d70f
```

### `dpkg` source package: `libzstd=1.4.8+dfsg-3build1`

Binary Packages:

- `libzstd1:amd64=1.4.8+dfsg-3build1`

Licenses: (parsed from: `/usr/share/doc/libzstd1/copyright`)

- `BSD-3-clause`
- `Expat`
- `GPL-2`
- `zlib`

Source:

```console
$ apt-get source -qq --print-uris libzstd=1.4.8+dfsg-3build1
'http://archive.ubuntu.com/ubuntu/pool/main/libz/libzstd/libzstd_1.4.8%2bdfsg-3build1.dsc' libzstd_1.4.8+dfsg-3build1.dsc 2398 SHA512:cdd444b0258f1effd998781dd058c8ab37fb8aabb10b94cc5741b0fd2c4c948085cd1b919533ded2f30c5a871c68a81dacef3c3d0640b8514d5d3a9d375647f6
'http://archive.ubuntu.com/ubuntu/pool/main/libz/libzstd/libzstd_1.4.8%2bdfsg.orig.tar.xz' libzstd_1.4.8+dfsg.orig.tar.xz 1331996 SHA512:07fabe431367eea4badae7b1e46ac73e0b33aad5b67361bc7b67d5f9aef249c51db5b560f1cf59233255cc49db341a8d8440fed87745026fca7a7c5c14448cd8
'http://archive.ubuntu.com/ubuntu/pool/main/libz/libzstd/libzstd_1.4.8%2bdfsg-3build1.debian.tar.xz' libzstd_1.4.8+dfsg-3build1.debian.tar.xz 12316 SHA512:8123965a6e73c5ddd8d535e78ed1074e2eabd7f8ed090d215a89feedffae9391cf472d2395242d3cb0351cbf76603448dae93ad70d0989806b42b03c65b22db0
```

### `dpkg` source package: `lsb=11.1.0ubuntu4`

Binary Packages:

- `lsb-base=11.1.0ubuntu4`

Licenses: (parsed from: `/usr/share/doc/lsb-base/copyright`)

- `BSD-3-clause`
- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris lsb=11.1.0ubuntu4
'http://archive.ubuntu.com/ubuntu/pool/main/l/lsb/lsb_11.1.0ubuntu4.dsc' lsb_11.1.0ubuntu4.dsc 2222 SHA512:2b5375ca5938f497f9211d9b85eaf60858c2d59c80ec40a3a04bec6ef47e6685661589f22514f8b2e4a325038feb0375d99e1f905aa93b4a13c3d474e3b86677
'http://archive.ubuntu.com/ubuntu/pool/main/l/lsb/lsb_11.1.0ubuntu4.tar.xz' lsb_11.1.0ubuntu4.tar.xz 46152 SHA512:03469c3b85facd88fb4c24b85eb42d6aeab171aa6e5860147ad947e2bbc2f2fe5f78ebd4a457f6af194d33173dccec4f672d1b9d460c070765377d9456bc73da
```

### `dpkg` source package: `lxml=4.8.0-1build1`

Binary Packages:

- `python3-lxml:amd64=4.8.0-1build1`

Licenses: (parsed from: `/usr/share/doc/python3-lxml/copyright`)

- `GPL`
- `GPL2`
- `later`

Source:

```console
$ apt-get source -qq --print-uris lxml=4.8.0-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/l/lxml/lxml_4.8.0-1build1.dsc' lxml_4.8.0-1build1.dsc 1934 SHA512:413769a1479a778a2baf475316cfdbedacec58ab7cd6d20fcbd8a6294383825eb0540138adaf418626aa0d3879f6f7f464d7b1a5d50d9d6e182f76b500e28c4c
'http://archive.ubuntu.com/ubuntu/pool/main/l/lxml/lxml_4.8.0.orig.tar.gz' lxml_4.8.0.orig.tar.gz 3209187 SHA512:f39e1a6194eb00045002ef830da18ad1be6307004f29e5266db4fbaecdb14be9142462a39bd55a2753c5e20a59cc104a09aa40ca18b0382ee421c2e67907a154
'http://archive.ubuntu.com/ubuntu/pool/main/l/lxml/lxml_4.8.0-1build1.debian.tar.xz' lxml_4.8.0-1build1.debian.tar.xz 8264 SHA512:5da040933decb50f1cf2b8dc4a7887c99963c4fdd71c768e6d674a47d7b39c7dd51e8ab81d60265682e55197312ffeec615c7436581b02fc6a0aad0968aafff0
```

### `dpkg` source package: `lz4=1.9.3-2build2`

Binary Packages:

- `liblz4-1:amd64=1.9.3-2build2`

Licenses: (parsed from: `/usr/share/doc/liblz4-1/copyright`)

- `BSD-2-clause`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris lz4=1.9.3-2build2
'http://archive.ubuntu.com/ubuntu/pool/main/l/lz4/lz4_1.9.3-2build2.dsc' lz4_1.9.3-2build2.dsc 2091 SHA512:a8f802737139536f8a9c0a3483635ff4dd8a3eba2e0d9d0d27f4f91c17592d1797929d491183dc25de4100a7aa924edefa8ca45eed4968c0e1b7e817f1ae9e1c
'http://archive.ubuntu.com/ubuntu/pool/main/l/lz4/lz4_1.9.3.orig.tar.gz' lz4_1.9.3.orig.tar.gz 320958 SHA512:c246b0bda881ee9399fa1be490fa39f43b291bb1d9db72dba8a85db1a50aad416a97e9b300eee3d2a4203c2bd88bda2762e81bc229c3aa409ad217eb306a454c
'http://archive.ubuntu.com/ubuntu/pool/main/l/lz4/lz4_1.9.3-2build2.debian.tar.xz' lz4_1.9.3-2build2.debian.tar.xz 14088 SHA512:9f61516a672186299a96aee5b7a71d9cb1ad3db2697fa10b802fef14a63587bb3459281f7300726711a116893c10858914f558aece1d224876e287020a23dde6
```

### `dpkg` source package: `mailcap=3.70+nmu1ubuntu1`

Binary Packages:

- `mailcap=3.70+nmu1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/mailcap/copyright`)

- `Bellcore`
- `ad-hoc`

Source:

```console
$ apt-get source -qq --print-uris mailcap=3.70+nmu1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/m/mailcap/mailcap_3.70%2bnmu1ubuntu1.dsc' mailcap_3.70+nmu1ubuntu1.dsc 1711 SHA512:73e01ba145b3eef6caf04fcb93f1358146915688ebb61ffa8b0029dc8488228109ed8034b7c86729b59d2e7d508b8735b46f0f863c09b8e6016c2961f5d34aa1
'http://archive.ubuntu.com/ubuntu/pool/main/m/mailcap/mailcap_3.70%2bnmu1ubuntu1.tar.xz' mailcap_3.70+nmu1ubuntu1.tar.xz 27476 SHA512:4db43118244f95024d39b1501c47b3ae79d9f657079f4aa7fb20a24c4de986784d19802b914ace9d2a992becd29e758a722f762ef51bfa0637ffa0b8cd4565e0
```

### `dpkg` source package: `markupsafe=2.0.1-2build1`

Binary Packages:

- `python3-markupsafe=2.0.1-2build1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris markupsafe=2.0.1-2build1
'http://archive.ubuntu.com/ubuntu/pool/main/m/markupsafe/markupsafe_2.0.1-2build1.dsc' markupsafe_2.0.1-2build1.dsc 2032 SHA512:c2b962c5f741f2b5c8820c71c084fdcdb1b5bfe99d2a8045ea99c5fce5c1f521195df4ab671f984d8bcbb885052f7afc0a0ac0ebc39087e30953e26672997f09
'http://archive.ubuntu.com/ubuntu/pool/main/m/markupsafe/markupsafe_2.0.1.orig.tar.gz' markupsafe_2.0.1.orig.tar.gz 18596 SHA512:77249bda784111ece15d59eb3de1cbb37a58fb9f22902fe6b73fea9eb0f23857ccbe53dc55463278e3b91f78dc35e2b027fd823ca50d88d8985d5a98ce2327f1
'http://archive.ubuntu.com/ubuntu/pool/main/m/markupsafe/markupsafe_2.0.1-2build1.debian.tar.xz' markupsafe_2.0.1-2build1.debian.tar.xz 3728 SHA512:82b5b528bb04768cbb102cd1d12426337ab40312f5ee67493f5b2f6d5db8e2ec7267ca2d8fead7a219da991929c469a83b993d30cab5b002bc3c0759d5f873df
```

### `dpkg` source package: `mawk=1.3.4.20200120-3`

Binary Packages:

- `mawk=1.3.4.20200120-3`

Licenses: (parsed from: `/usr/share/doc/mawk/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris mawk=1.3.4.20200120-3
'http://archive.ubuntu.com/ubuntu/pool/main/m/mawk/mawk_1.3.4.20200120-3.dsc' mawk_1.3.4.20200120-3.dsc 1915 SHA512:f51dae1f342769e4fc0b8d5faf4e988433a0e74912ba0777fbafdf058900c973087c267756f5c2b74298bfc31a36c8bbc99c6c0edcc850710b646d0d24fa1305
'http://archive.ubuntu.com/ubuntu/pool/main/m/mawk/mawk_1.3.4.20200120.orig.tar.gz' mawk_1.3.4.20200120.orig.tar.gz 468855 SHA512:14d9a6642ce931bf6457d248fc2d6da4f0ea7541976ca282ea708b26df048f86fdf92c27f72d497501ccd43a244d1d1a606f1a2f266a7558306fea35dcc3041b
'http://archive.ubuntu.com/ubuntu/pool/main/m/mawk/mawk_1.3.4.20200120-3.debian.tar.xz' mawk_1.3.4.20200120-3.debian.tar.xz 7520 SHA512:bc4f5401de313108595ba91b17f44b5c67d7650b5557eef8a6c63c75e2ccee5dfd8900576d7e81f0ab1ac2e570f64fa75f38f56f6d4535437c803029216501af
```

### `dpkg` source package: `media-types=7.0.0`

Binary Packages:

- `media-types=7.0.0`

Licenses: (parsed from: `/usr/share/doc/media-types/copyright`)

- `ad-hoc`

Source:

```console
$ apt-get source -qq --print-uris media-types=7.0.0
'http://archive.ubuntu.com/ubuntu/pool/main/m/media-types/media-types_7.0.0.dsc' media-types_7.0.0.dsc 1620 SHA512:f5159688820b267f4349dce11a3427bb70d8185494386ec37076885c36c4dfda8de9daf82a92cd84442604b33dfb7835ae2121bead8151ae5e14ed375a9d9659
'http://archive.ubuntu.com/ubuntu/pool/main/m/media-types/media-types_7.0.0.tar.xz' media-types_7.0.0.tar.xz 55660 SHA512:ce4b07388c490c7e3e1bdd1dcdd28c685eee81cb9d167cc903f427a28bf972210b8d5ad3d33af06530b4dba0ac7f2a2b6e914c1d88bc1e88db589de6b4490071
```

### `dpkg` source package: `mime-support=3.66`

Binary Packages:

- `mime-support=3.66`

Licenses: (parsed from: `/usr/share/doc/mime-support/copyright`)

- `ad-hoc`

Source:

```console
$ apt-get source -qq --print-uris mime-support=3.66
'http://archive.ubuntu.com/ubuntu/pool/main/m/mime-support/mime-support_3.66.dsc' mime-support_3.66.dsc 1625 SHA512:f3ed0e0c9274b4dc1dcc7c4f7b6c1e6d350cf1df2507572f326fec51b126012d1c8f54a0a61dd6e0647bc435eaca3d6addda79173b129522f7f1fcbedf2c67bb
'http://archive.ubuntu.com/ubuntu/pool/main/m/mime-support/mime-support_3.66.tar.xz' mime-support_3.66.tar.xz 9568 SHA512:d41b074cf38dbe738b74367c456f28309fd3d00b67b2926db96523eba8ccaf534a11399bc5083d5875e439882159054a75e001d060863684611e20a26ed73bb1
```

### `dpkg` source package: `mpdecimal=2.5.1-2build2`

Binary Packages:

- `libmpdec3:amd64=2.5.1-2build2`

Licenses: (parsed from: `/usr/share/doc/libmpdec3/copyright`)

- `BSD`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris mpdecimal=2.5.1-2build2
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpdecimal/mpdecimal_2.5.1-2build2.dsc' mpdecimal_2.5.1-2build2.dsc 2026 SHA512:2f930154a94b9b4090f18e848ea94d115304827e351abc9141ef8646b9937a0f93eb2517790b661b0569e22bb498497c03972233e1ace6bdd85c9fc6922e7e70
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpdecimal/mpdecimal_2.5.1.orig.tar.gz' mpdecimal_2.5.1.orig.tar.gz 2584021 SHA512:710cb5cb71dbcf3e170ca15869c148df0547b848400c6b6dd70c67d9961dbe1190af8fb4d1623bfb0ca2afe44f369a42e311ab5225ed89d4031cb49a3bd70f30
'http://archive.ubuntu.com/ubuntu/pool/main/m/mpdecimal/mpdecimal_2.5.1-2build2.debian.tar.xz' mpdecimal_2.5.1-2build2.debian.tar.xz 6860 SHA512:261ab28a609fbcff2b9561f1b1e484500c5652e48bd0abc4f8c5df73b7e00333b80f1fe416c84800690d13d52d2af72d97503dcd0afa61073ee5610d62a52a02
```

### `dpkg` source package: `ncurses=6.3-2ubuntu0.1`

Binary Packages:

- `libncurses6:amd64=6.3-2ubuntu0.1`
- `libncursesw6:amd64=6.3-2ubuntu0.1`
- `libtinfo6:amd64=6.3-2ubuntu0.1`
- `ncurses-base=6.3-2ubuntu0.1`
- `ncurses-bin=6.3-2ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libncurses6/copyright`, `/usr/share/doc/libncursesw6/copyright`, `/usr/share/doc/libtinfo6/copyright`, `/usr/share/doc/ncurses-base/copyright`, `/usr/share/doc/ncurses-bin/copyright`)

- `BSD-3-clause`
- `MIT/X11`
- `X11`

Source:

```console
$ apt-get source -qq --print-uris ncurses=6.3-2ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/n/ncurses/ncurses_6.3-2ubuntu0.1.dsc' ncurses_6.3-2ubuntu0.1.dsc 3955 SHA512:e018fe9a8a641efddfcac0e92ce46dbba3067ddc6850e7223b3abc668f1620c1ea1564d80a63b94ff1c37705630eb2116d5c4449f1115315def4d4008e5f5926
'http://archive.ubuntu.com/ubuntu/pool/main/n/ncurses/ncurses_6.3.orig.tar.gz' ncurses_6.3.orig.tar.gz 3583550 SHA512:5373f228cba6b7869210384a607a2d7faecfcbfef6dbfcd7c513f4e84fbd8bcad53ac7db2e7e84b95582248c1039dcfc7c4db205a618f7da22a166db482f0105
'http://archive.ubuntu.com/ubuntu/pool/main/n/ncurses/ncurses_6.3.orig.tar.gz.asc' ncurses_6.3.orig.tar.gz.asc 729 SHA512:5673088e7d6af580e8f1e163687146adb51261cd3c75be9ea61368c7590efc0e5e4bc1c2ae76d717f289ff6609089c5ca1f7e4a572266d7b6c5daba98eabed2e
'http://archive.ubuntu.com/ubuntu/pool/main/n/ncurses/ncurses_6.3-2ubuntu0.1.debian.tar.xz' ncurses_6.3-2ubuntu0.1.debian.tar.xz 56080 SHA512:d37d4fc956ad1410d0338ee4f5b465e58f35056e33d909a4871d738ef83d9002200d5c31f35ee23e6817db950fd2e227a87e5e01bde8df221dfa2650edb7583a
```

### `dpkg` source package: `netbase=6.3`

Binary Packages:

- `netbase=6.3`

Licenses: (parsed from: `/usr/share/doc/netbase/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris netbase=6.3
'http://archive.ubuntu.com/ubuntu/pool/main/n/netbase/netbase_6.3.dsc' netbase_6.3.dsc 875 SHA512:e21e2c228f5963f34636c646d92280c6307527c1796f3da89a5ec9d26d4a10c08730d68f337f43ebbcd6cc22c4f8fd804673336fbcc9fd41eb1d4f0e687b2a7d
'http://archive.ubuntu.com/ubuntu/pool/main/n/netbase/netbase_6.3.tar.xz' netbase_6.3.tar.xz 31968 SHA512:3ba7f8b28a9b6ffd89bef62a3c2629cf6ad6b0522319ae7eae46d579aac6f86079930da3b3dd55c76ae48cf6c842f8f162b24324e2f8427e3664fd0db69ed138
```

### `dpkg` source package: `nettle=3.7.3-1build2`

Binary Packages:

- `libhogweed6:amd64=3.7.3-1build2`
- `libnettle8:amd64=3.7.3-1build2`

Licenses: (parsed from: `/usr/share/doc/libhogweed6/copyright`, `/usr/share/doc/libnettle8/copyright`)

- `Expat`
- `GAP`
- `GPL`
- `GPL-2`
- `GPL-2+`
- `GPL-3+`
- `GPL-3+ with Autoconf exception`
- `LGPL`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-3+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris nettle=3.7.3-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/n/nettle/nettle_3.7.3-1build2.dsc' nettle_3.7.3-1build2.dsc 2165 SHA512:3f774011dd48205720ac7e6aa9a44b5afa64c24fce825d6583b58c02f3c8f500ecafa265d18d5deb1ab65d6e938dd76a7917f1d5c3dab0aea28148d531fa26cd
'http://archive.ubuntu.com/ubuntu/pool/main/n/nettle/nettle_3.7.3.orig.tar.gz' nettle_3.7.3.orig.tar.gz 2383985 SHA512:9901eba305421adff6d551ac7f478dff3f68a339d444c776724ab0b977fe6be792b1d2950c8705acbe76bd924fd6d898a65eded546777884be3b436d0e052437
'http://archive.ubuntu.com/ubuntu/pool/main/n/nettle/nettle_3.7.3-1build2.debian.tar.xz' nettle_3.7.3-1build2.debian.tar.xz 22100 SHA512:c1935d35e9f04798273053ab92c7405ec225a5d72ba6c2869b0f2bf54b459ac428e113bc149796e91834a8b56082f8bbfbb906a6cd6787142b8932bd1dd83cec
```

### `dpkg` source package: `nghttp2=1.43.0-1ubuntu0.2`

Binary Packages:

- `libnghttp2-14:amd64=1.43.0-1ubuntu0.2`

Licenses: (parsed from: `/usr/share/doc/libnghttp2-14/copyright`)

- `BSD-2-clause`
- `Expat`
- `GPL-3`
- `GPL-3+ with autoconf exception`
- `MIT`
- `SIL-OFL-1.1`
- `all-permissive`

Source:

```console
$ apt-get source -qq --print-uris nghttp2=1.43.0-1ubuntu0.2
'http://archive.ubuntu.com/ubuntu/pool/main/n/nghttp2/nghttp2_1.43.0-1ubuntu0.2.dsc' nghttp2_1.43.0-1ubuntu0.2.dsc 2679 SHA512:2ad7840a04e95d55fa98b6693be289fcc86330c2b9ea06b08cdf9f1bd2c3e0bffe2f312433f243ea8b7fd8ffeeba9c840581b3eb1bef662f487d075a8428ad2a
'http://archive.ubuntu.com/ubuntu/pool/main/n/nghttp2/nghttp2_1.43.0.orig.tar.bz2' nghttp2_1.43.0.orig.tar.bz2 4521786 SHA512:f2e6665ad6c73f0a1a8c7b34ca821a905868d41dafca913e6a054eb5afb534a85ae91618c1a4b098e43f350ca3703fd1ece7848f0a771e8393a3eb0581ceaf59
'http://archive.ubuntu.com/ubuntu/pool/main/n/nghttp2/nghttp2_1.43.0-1ubuntu0.2.debian.tar.xz' nghttp2_1.43.0-1ubuntu0.2.debian.tar.xz 23788 SHA512:ebbbd0c00089e2b48feef151b00b952cfec456662f35d8dd68e886008cdb61bec788c5fa8bbd63614c18a2e06f187bf3112417e759a4f55a9c0db27511aa461a
```

### `dpkg` source package: `node-abbrev=1.1.1+~1.1.2-1`

Binary Packages:

- `node-abbrev=1.1.1+~1.1.2-1`

Licenses: (parsed from: `/usr/share/doc/node-abbrev/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-abbrev=1.1.1+~1.1.2-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-abbrev/node-abbrev_1.1.1%2b%7e1.1.2-1.dsc' node-abbrev_1.1.1+~1.1.2-1.dsc 2375 SHA512:e2cd61643641314007750b6ada370741d3e593528d0550bd9f261044d7660cbb74af43848f5e161b0a00c8740f00a3a00eb99f12cd874f78b391a880d2418876
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-abbrev/node-abbrev_1.1.1%2b%7e1.1.2.orig-types-abbrev.tar.gz' node-abbrev_1.1.1+~1.1.2.orig-types-abbrev.tar.gz 1672 SHA512:1a52461e401b4300551c726d15c8d9ccbf6af9c289bf23f02945decfcb3ed3b55d1942a9c8eb8cdad8873ea13681b538f8d227db0a2ed28dcf5a14846b661b7a
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-abbrev/node-abbrev_1.1.1%2b%7e1.1.2.orig.tar.gz' node-abbrev_1.1.1+~1.1.2.orig.tar.gz 3156 SHA512:c86a868b59debac10b851d8f1956785b74da030634b279ae5aa303878bef8e8d6a552e4c1e0870dd746190fcc37be327b4b8b69422b7c2b9f478647d985a51f7
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-abbrev/node-abbrev_1.1.1%2b%7e1.1.2-1.debian.tar.xz' node-abbrev_1.1.1+~1.1.2-1.debian.tar.xz 3736 SHA512:9f32218cca0a97de6b6b9660cb46bf8572b1f10fdedbcb1e1b674998d987ac6b16c1b3c47fdcf5f656af42f9f5eec1fae6d0e66d1d5feef37da5423553bb2435
```

### `dpkg` source package: `node-agent-base=6.0.2+~cs5.4.2-1`

Binary Packages:

- `node-agent-base=6.0.2+~cs5.4.2-1`

Licenses: (parsed from: `/usr/share/doc/node-agent-base/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-agent-base=6.0.2+~cs5.4.2-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-agent-base/node-agent-base_6.0.2%2b%7ecs5.4.2-1.dsc' node-agent-base_6.0.2+~cs5.4.2-1.dsc 2977 SHA512:512ec84dd20f255b80cd127ae3bd7b26399670d763fbc731232843d28246892b8f9828f3d4ccc0cb09c7296c32dd7058f4c83ba394417829a93d938cf3a650a0
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-agent-base/node-agent-base_6.0.2%2b%7ecs5.4.2.orig-async-listen.tar.gz' node-agent-base_6.0.2+~cs5.4.2.orig-async-listen.tar.gz 1649 SHA512:09c12d461fe873d25ce2e59e5307691bff8c6f66141ca99d6937f4814afb59af9b7e9e31c7bd0739bdd1b924c932fa8a341d5391d4df8cb76b733d97e2b92464
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-agent-base/node-agent-base_6.0.2%2b%7ecs5.4.2.orig-types-agent-base.tar.gz' node-agent-base_6.0.2+~cs5.4.2.orig-types-agent-base.tar.gz 1953 SHA512:eb5ef89a6e2a34a94c67afdf0a7ce20fe90c83477908bd3985e4a19878a3461c10b4ba46e2ab6a0bbb366afe4b3450d876298a9c5cec603d2ddcd3cc066fa36a
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-agent-base/node-agent-base_6.0.2%2b%7ecs5.4.2.orig.tar.gz' node-agent-base_6.0.2+~cs5.4.2.orig.tar.gz 13251 SHA512:789fdcb3f254931ba76c0d729b0404983cfbe50fc011eae3e94064cf97cb9de36f7349859c39870414d51329e0844f13ce76e5d80b48e8e5ab13a97593deb027
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-agent-base/node-agent-base_6.0.2%2b%7ecs5.4.2-1.debian.tar.xz' node-agent-base_6.0.2+~cs5.4.2-1.debian.tar.xz 4156 SHA512:225e10aa33350f7d388b5a1e64e3c23836efa3d042a88642a72d39385d1c3b52bde98caaf1fec0d0a924d8f3856b00a2762808d9dc5ec2291b371baef03c63f9
```

### `dpkg` source package: `node-ansi-regex=5.0.1-1`

Binary Packages:

- `node-ansi-regex=5.0.1-1`

Licenses: (parsed from: `/usr/share/doc/node-ansi-regex/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-ansi-regex=5.0.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ansi-regex/node-ansi-regex_5.0.1-1.dsc' node-ansi-regex_5.0.1-1.dsc 2077 SHA512:1ce88f720fecda1c711eb8733024ecb0116127a1db555edbb3af77048a666f71e9d682c75b9ddcbc91ea111c6e460b3a0add09fc826945d135088ddc7febbf35
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ansi-regex/node-ansi-regex_5.0.1.orig.tar.gz' node-ansi-regex_5.0.1.orig.tar.gz 7638 SHA512:6ae31e12507c63a93b07b1fb3fd9921a63663691abec7b468c2e3138a022569b85e6685236e356c6ad5422391dc3b293f40528afb2847534d69ff0d6ebdf6240
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ansi-regex/node-ansi-regex_5.0.1-1.debian.tar.xz' node-ansi-regex_5.0.1-1.debian.tar.xz 3964 SHA512:88af63637609ab8febf3f282248a80f1651a5816f4f6cbc5287810be9c5947d71c2bf9847234fbd4936266414c630788c48b4e7c4e2f5104d33efdc7983a3ca6
```

### `dpkg` source package: `node-ansi-styles=4.3.0+~4.2.0-1`

Binary Packages:

- `node-ansi-styles=4.3.0+~4.2.0-1`

Licenses: (parsed from: `/usr/share/doc/node-ansi-styles/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-ansi-styles=4.3.0+~4.2.0-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ansi-styles/node-ansi-styles_4.3.0%2b%7e4.2.0-1.dsc' node-ansi-styles_4.3.0+~4.2.0-1.dsc 2503 SHA512:7eb2e360e96f40334480892119f085d97b46fcfc88e460929f5fbe52db73e20288741e958278383072e64b3b35a82973c3030e3c97805637eedda6211f468f2a
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ansi-styles/node-ansi-styles_4.3.0%2b%7e4.2.0.orig-types-ansi-styles.tar.gz' node-ansi-styles_4.3.0+~4.2.0.orig-types-ansi-styles.tar.gz 1085 SHA512:18e160c4bd5b1b4aecb944ea058cc44c72d5de48982bf75515e33197f363b0cd8d05eda413ea0738bd7a68b1eb677da80afce1d08ca8a7a4cd70a68b9e532e47
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ansi-styles/node-ansi-styles_4.3.0%2b%7e4.2.0.orig.tar.gz' node-ansi-styles_4.3.0+~4.2.0.orig.tar.gz 9205 SHA512:dc2bfa2e35437946ddbb326c4d43bdfb7b4e077d6912bc60aa0739bea1e5ad0c87fc28713ad0ff1d50ebf030ed60792262f0bbaaa9ab47f0df72ad8aa8fbc8d9
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ansi-styles/node-ansi-styles_4.3.0%2b%7e4.2.0-1.debian.tar.xz' node-ansi-styles_4.3.0+~4.2.0-1.debian.tar.xz 4364 SHA512:ff7e82b966ba0db5d84f592552453d15c4449835232381c996f02454419d228d289dd0bb42dc24f61605e79d459a68ecdc477553bddfe8b0a4d085dbac8d226b
```

### `dpkg` source package: `node-ansistyles=0.1.3-5`

Binary Packages:

- `node-ansistyles=0.1.3-5`

Licenses: (parsed from: `/usr/share/doc/node-ansistyles/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-ansistyles=0.1.3-5
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ansistyles/node-ansistyles_0.1.3-5.dsc' node-ansistyles_0.1.3-5.dsc 2054 SHA512:bacff41c421f168177dbfb81c9acb6d89720f6374d59a0b2a9654df80b7cb5ec48e17ef2dfe0cc21d644f7a0fd2906cb6f4a7d252a3d7b3dcd7f557e74b6dfd7
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ansistyles/node-ansistyles_0.1.3.orig.tar.gz' node-ansistyles_0.1.3.orig.tar.gz 2964 SHA512:055d4e4e77e509482310a581403d36582f80fe677aa103cef19e8ea716e7909bc2b8e7b0b35d95908fc32aab411ca104ab0ea74c4ea365a82eadfbb6585aad78
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ansistyles/node-ansistyles_0.1.3-5.debian.tar.xz' node-ansistyles_0.1.3-5.debian.tar.xz 2696 SHA512:67630fb693431990bd02efa2832816bd2ff98f68d68b1564340a4e8a1d58a0eea24d8d23501415b3a752d8d05b7e66958f7a9e0dc69367511d10a8eec95bddf9
```

### `dpkg` source package: `node-aproba=2.0.0-2`

Binary Packages:

- `node-aproba=2.0.0-2`

Licenses: (parsed from: `/usr/share/doc/node-aproba/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-aproba=2.0.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-aproba/node-aproba_2.0.0-2.dsc' node-aproba_2.0.0-2.dsc 2022 SHA512:6f8aa06df6a50f46e64aba0b148a766d702654ac775f9a55011ede500c8e99a4210855f086bef95d0550690eb3cdafb6945d31ceb84e1963968f89ec066f53d3
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-aproba/node-aproba_2.0.0.orig.tar.gz' node-aproba_2.0.0.orig.tar.gz 33506 SHA512:a6a73a944828ce6314fd7e51d2c53359daccc50c2162ebc8a7a27204837a3650e6e5073a009a5ea1fb8e0a287f0fd504f2b510624fd061b5f9d3f18efd3354cd
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-aproba/node-aproba_2.0.0-2.debian.tar.xz' node-aproba_2.0.0-2.debian.tar.xz 2556 SHA512:75b6562437ff185b7102feefc79dae581e25472cada61c43f52b3a72cfd37d082eb0f8536ebdd61525f97174e09dfce5ea996bc04c5c33534b50c640b3715c7b
```

### `dpkg` source package: `node-archy=1.0.0-4`

Binary Packages:

- `node-archy=1.0.0-4`

Licenses: (parsed from: `/usr/share/doc/node-archy/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-archy=1.0.0-4
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-archy/node-archy_1.0.0-4.dsc' node-archy_1.0.0-4.dsc 2014 SHA512:cfb88901392416736b994c262f2979ad14b5202fbc97df8d2734e918374e297a9668272155ac974f82c8fa3c8ff80b37a0f06dc2f101561e2e5dcfd273b94dad
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-archy/node-archy_1.0.0.orig.tar.gz' node-archy_1.0.0.orig.tar.gz 2989 SHA512:bc0f16d8c2dc09bf553fadd055b097e05b60d0d4d36558078317de7ab1f1c8023508f62febac20dae5d74f10aa6dc35a7548499fffe92e16bdbab9393927c99a
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-archy/node-archy_1.0.0-4.debian.tar.xz' node-archy_1.0.0-4.debian.tar.xz 3000 SHA512:337fe59b29a4a287ee1b8356277a4fd3603c576617a6096a272ae33c8c48c06ac0b1a88dc919f82ae2d7ab0237e780936af267d08aa0007b9d42cbdb72524dbe
```

### `dpkg` source package: `node-are-we-there-yet=3.0.0+~1.1.0-1`

Binary Packages:

- `node-are-we-there-yet=3.0.0+~1.1.0-1`

Licenses: (parsed from: `/usr/share/doc/node-are-we-there-yet/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-are-we-there-yet=3.0.0+~1.1.0-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-are-we-there-yet/node-are-we-there-yet_3.0.0%2b%7e1.1.0-1.dsc' node-are-we-there-yet_3.0.0+~1.1.0-1.dsc 2617 SHA512:1403a90d06c9993b737e0f3fa398ac54bfde182dbefb6e6be151ba9280d12764a0b7ff9995d9cb888601ff389d74881c625dde56cfe321c150f98f73277356aa
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-are-we-there-yet/node-are-we-there-yet_3.0.0%2b%7e1.1.0.orig-types-are-we-there-yet.tar.gz' node-are-we-there-yet_3.0.0+~1.1.0.orig-types-are-we-there-yet.tar.gz 2109 SHA512:5f0921f5765eaf53098900c15632fc5f1ba3201db8cd25541312901cb17885ad8697c23c2ef133a8ee6d44e3f00a56f0bd24c02adbd1bb3af1a094d10da3d34e
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-are-we-there-yet/node-are-we-there-yet_3.0.0%2b%7e1.1.0.orig.tar.gz' node-are-we-there-yet_3.0.0+~1.1.0.orig.tar.gz 10917 SHA512:69e5e34d0328cbab9f1034662e638d85561c15f824987302731b41c98c639863c2e31ca3d8baef8c18fba0c880bd94c4a827fba90fe38ddf08acb891c7ef5a0d
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-are-we-there-yet/node-are-we-there-yet_3.0.0%2b%7e1.1.0-1.debian.tar.xz' node-are-we-there-yet_3.0.0+~1.1.0-1.debian.tar.xz 3320 SHA512:ac457c1f9892511ed7b631b646335bff6f229ef2522fbe7781f11cfc8d893d5b61fb321b0ca4cad1c3106022bb4920b3ba6b1f4f83eea51a7f9d5f15ee62efa0
```

### `dpkg` source package: `node-asap=2.0.6+~2.0.0-1`

Binary Packages:

- `node-asap=2.0.6+~2.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-asap/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-asap=2.0.6+~2.0.0-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-asap/node-asap_2.0.6%2b%7e2.0.0-1.dsc' node-asap_2.0.6+~2.0.0-1.dsc 2331 SHA512:22d9e6101f5d4a673aa60067846229767fdca4eb19f4cff746b1d17cfc84a0b85f0acaf87b7918ad19471a5e7f5ae4e3f6b0a453b96a6aa504bbdd6e65367696
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-asap/node-asap_2.0.6%2b%7e2.0.0.orig-types-asap.tar.gz' node-asap_2.0.6+~2.0.0.orig-types-asap.tar.gz 1648 SHA512:ba9212d06b7d31cf1e12909b60c6752bcae1368b1f294b6298d70835c7beccbc0917952933756fef2cf74b997fd485fe0f14daf254e4523ab29ef8d15f2273b2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-asap/node-asap_2.0.6%2b%7e2.0.0.orig.tar.gz' node-asap_2.0.6+~2.0.0.orig.tar.gz 39620 SHA512:540f8e48ebb19f539ddb1a068362d77933595361e314afec501019e2e5e38262e1f44fd3809eddf38e8af263f20ac520c388442ae35874401951e342d97d13d6
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-asap/node-asap_2.0.6%2b%7e2.0.0-1.debian.tar.xz' node-asap_2.0.6+~2.0.0-1.debian.tar.xz 3232 SHA512:322a1b2016f2adb718510c600e3e69adfc3411bed24510ffcb55ea92dfc46f100bf6c1474610d78bfc8c67bc0c9daefe130d1d4b9928b1f56b93e142b4e7e0c4
```

### `dpkg` source package: `node-balanced-match=2.0.0-1`

Binary Packages:

- `node-balanced-match=2.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-balanced-match/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-balanced-match=2.0.0-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-balanced-match/node-balanced-match_2.0.0-1.dsc' node-balanced-match_2.0.0-1.dsc 2128 SHA512:c118ae6fb5dd52513587ddde30d95ea8dcde21983a233880ef0dd231d113914db0db1b6df478a6d49cd2ee337462ab86b297fba2d58ba39cb6eb657b90997f16
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-balanced-match/node-balanced-match_2.0.0.orig.tar.gz' node-balanced-match_2.0.0.orig.tar.gz 152519 SHA512:bd176c2a27357d9d5e616cb3a3ace79f001e156cd1a5ea00eb76ae6adfa529dea616787efd3f6dc4645abd419465a9c0edbeb1e5a1efdf76200ea3a1381d6479
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-balanced-match/node-balanced-match_2.0.0-1.debian.tar.xz' node-balanced-match_2.0.0-1.debian.tar.xz 3116 SHA512:c06bcddc5f43d59ba547ef895287434c5e983667ebe278d216f4a6c8bbf4eee8451896c25d84ff1f0b796d61e39ab27adfb6991a8efbc1d3572cceccac5fc091
```

### `dpkg` source package: `node-brace-expansion=2.0.1-1`

Binary Packages:

- `node-brace-expansion=2.0.1-1`

Licenses: (parsed from: `/usr/share/doc/node-brace-expansion/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-brace-expansion=2.0.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-brace-expansion/node-brace-expansion_2.0.1-1.dsc' node-brace-expansion_2.0.1-1.dsc 2168 SHA512:7787fd6df8308fcc1d8b1f5062ee7836c2c2c826b843d58b641f23bc7bbec0a4e1629cdcd90c5e8a3fb905290b5041f0c67172cd9388657bbae15274db45f835
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-brace-expansion/node-brace-expansion_2.0.1.orig.tar.gz' node-brace-expansion_2.0.1.orig.tar.gz 15979 SHA512:7f5c99a910415275676323b36a1b1aabdd6528337d9b441558fc6a2ebfb737e12febb8572eac53d66ce50425dc2092fcdfa38706457264f1f737ddc5e6ceeacf
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-brace-expansion/node-brace-expansion_2.0.1-1.debian.tar.xz' node-brace-expansion_2.0.1-1.debian.tar.xz 2900 SHA512:0193961385c1d3b2766439533d0df800e20419e1c0fe63f51c055792c716d08d09b374dee2e8d83f21c2664888f5fcf1033c96d5b203dbad14c4f51927779951
```

### `dpkg` source package: `node-builtins=4.0.0-1`

Binary Packages:

- `node-builtins=4.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-builtins/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-builtins=4.0.0-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-builtins/node-builtins_4.0.0-1.dsc' node-builtins_4.0.0-1.dsc 2077 SHA512:3b8ff25d2c05e46ce486466046cb6095fb15184eddd66e8e384277e921490b25e85f57a0cac793643ee249bb0116f47e722a539eceb21719e4fc9d4fa586533f
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-builtins/node-builtins_4.0.0.orig.tar.gz' node-builtins_4.0.0.orig.tar.gz 106430 SHA512:2419358a6a19441acf6b7e823f871a2ba7a392d4eeb872acf4a595fac8729770c90c7c75b0ee49e9865f986a7902e0f26302c9cb178997083c3db074b2b0f1ec
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-builtins/node-builtins_4.0.0-1.debian.tar.xz' node-builtins_4.0.0-1.debian.tar.xz 2656 SHA512:31c1306ec3ed3918ee5b5dab6df10e7d8d69dbfcb1cb11f00dbc68bc502e4b2ae29de1deeb0070bfdd8a8d28b03c9ff345eb9ce3c476d220828afa24048d2d7f
```

### `dpkg` source package: `node-cacache=15.0.5+~cs13.9.21-3`

Binary Packages:

- `node-cacache=15.0.5+~cs13.9.21-3`

Licenses: (parsed from: `/usr/share/doc/node-cacache/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-cacache=15.0.5+~cs13.9.21-3
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-cacache/node-cacache_15.0.5%2b%7ecs13.9.21-3.dsc' node-cacache_15.0.5+~cs13.9.21-3.dsc 5325 SHA512:e3c75d3012959ac9674d5ccd66667263679e6853d1f4dd050f21be603eee100bf5e66412427ca6152b8e1b2a602d24d9959c8c90cd9af66fc43597663472afb4
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-cacache/node-cacache_15.0.5%2b%7ecs13.9.21.orig-figgy-pudding.tar.gz' node-cacache_15.0.5+~cs13.9.21.orig-figgy-pudding.tar.gz 6414 SHA512:d1bb6723f1fc7f6a5abc630df30e349a548a39f4cad925499817c1795223de4370d2cc30833c91ab47794c954ec287459adbe93de58f37f30271fb961741336f
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-cacache/node-cacache_15.0.5%2b%7ecs13.9.21.orig-fs-minipass.tar.gz' node-cacache_15.0.5+~cs13.9.21.orig-fs-minipass.tar.gz 35270 SHA512:a3c18244a6996fc9e9d3fc8a7212babf035795a2b27f1d4428f62b508bfe642e1960baec52566801a6546f139f6d3eab61451eb12076e0aae483df710927d20d
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-cacache/node-cacache_15.0.5%2b%7ecs13.9.21.orig-infer-owner.tar.gz' node-cacache_15.0.5+~cs13.9.21.orig-infer-owner.tar.gz 24073 SHA512:6309d9b4a07fd2ca50cfccf0b1379ffdc8c1c76197d36d711b2aeb123cc7f0e5d2f1c86338d911dd027533dcc37a1ed049662b5dfa09ce8ac5f6152df7a2f4c2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-cacache/node-cacache_15.0.5%2b%7ecs13.9.21.orig-minipass-collect.tar.gz' node-cacache_15.0.5+~cs13.9.21.orig-minipass-collect.tar.gz 2057 SHA512:e93ea51f41fc386f642139bf266ead768a086e8806f5ed2d2e0a58ea6a615d29bf03dbbc36ad6bc811be42ca62b9bf4b8d69413ec3d2ded590fc1a2dab815dc4
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-cacache/node-cacache_15.0.5%2b%7ecs13.9.21.orig-minipass-flush.tar.gz' node-cacache_15.0.5+~cs13.9.21.orig-minipass-flush.tar.gz 30652 SHA512:32fa3a692bd0cbc9ef2d0828e66cefb9f1b326ac891ca98945622fd5e95368d0bb67316eebd80b2f3a6ca6b0ae85531d546e488ce49498f37ee2af4eabc34ee8
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-cacache/node-cacache_15.0.5%2b%7ecs13.9.21.orig-minipass-pipeline.tar.gz' node-cacache_15.0.5+~cs13.9.21.orig-minipass-pipeline.tar.gz 3001 SHA512:c6e22aedc20eb74f513d1275f60762e1bf9188dbc31587b9247fa080dbc1a86aa941772bbb73dc466399b8704a58ad53c5ff7e710f8731537877acf8e8b64fec
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-cacache/node-cacache_15.0.5%2b%7ecs13.9.21.orig-minipass.tar.gz' node-cacache_15.0.5+~cs13.9.21.orig-minipass.tar.gz 50240 SHA512:c1241ebd0bd079631c1931c7a5ac3dd7201634e348bfc02354e8360b04c43f4d6d4923a4d7844072a116986ca6a4572945c049131cb29327f6f80ff47a2eaa70
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-cacache/node-cacache_15.0.5%2b%7ecs13.9.21.orig-npmcli-move-file.tar.gz' node-cacache_15.0.5+~cs13.9.21.orig-npmcli-move-file.tar.gz 31436 SHA512:ddfd3ae36806bc4e9e44e451a18f83a9e357c11d5f4fd4a1916993598026a7d94816335b578b5fc2863e8ac0ce32a8b1c1f5a34dd75c2a4578a3138a1f6c7667
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-cacache/node-cacache_15.0.5%2b%7ecs13.9.21.orig.tar.gz' node-cacache_15.0.5+~cs13.9.21.orig.tar.gz 121287 SHA512:e256f83182f8a0107e8d19488966276a044ba692b57ebd203a52088becd7f24e6428870d38bb2997b637cd7d1ece3f09e6a2d303f95bb399a4da97cc28b9a69c
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-cacache/node-cacache_15.0.5%2b%7ecs13.9.21-3.debian.tar.xz' node-cacache_15.0.5+~cs13.9.21-3.debian.tar.xz 4616 SHA512:e0c14e87027bd200425dfda4aebcec8a54c850a7d9c47b9295c47e61609a51b56b3fee936c7d5d657d6cad79cd942067c6b7701ac35d7cbc05f67fdc2f2aa5c9
```

### `dpkg` source package: `node-chalk=4.1.2-1`

Binary Packages:

- `node-chalk=4.1.2-1`

Licenses: (parsed from: `/usr/share/doc/node-chalk/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-chalk=4.1.2-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-chalk/node-chalk_4.1.2-1.dsc' node-chalk_4.1.2-1.dsc 2223 SHA512:97626aaa52fc7ec812b29a148d88d239615e1567363023213ebf96e52821ca256e7a186ec52353c04032cba6a10aa399f16468a7a9596662fb1897f1c33d0826
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-chalk/node-chalk_4.1.2.orig.tar.gz' node-chalk_4.1.2.orig.tar.gz 75387 SHA512:63289ab8fa4b024349bb3383027f66f6779eeff799cde91c96af0ea6d0aa8944a966cf2ecaf547b71a95813a31bf6825faced40af05fcf02ada9f142dd19cc66
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-chalk/node-chalk_4.1.2-1.debian.tar.xz' node-chalk_4.1.2-1.debian.tar.xz 7344 SHA512:cdf8eb81d2de5c6e6f57c6d0957e84c7ce7a3eee646a1085cf6617206478d6aed6c33e985b12642a8189f527f10e67a2586eaeedca690755f410d2336ba43c74
```

### `dpkg` source package: `node-chownr=2.0.0-1`

Binary Packages:

- `node-chownr=2.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-chownr/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-chownr=2.0.0-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-chownr/node-chownr_2.0.0-1.dsc' node-chownr_2.0.0-1.dsc 2084 SHA512:a89cfcbac21b262021b7df291215b2b01be0ace438b23378dd0dd09f22346981540884d015ac6c9facf26ed448a6f605e55000651ef60534ca0fc3480a11f583
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-chownr/node-chownr_2.0.0.orig.tar.gz' node-chownr_2.0.0.orig.tar.gz 31530 SHA512:bb2fefee0a4481db1084cca4f2fbd4ac1d39fa713b0104e211673bba6cf7793b21c11681901da1d3ea4f17c76db684ea76ce089e9ecaa9ece445eb7140aa8349
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-chownr/node-chownr_2.0.0-1.debian.tar.xz' node-chownr_2.0.0-1.debian.tar.xz 3072 SHA512:d7b4b24fdb68943266c980da0f6e3f520c7da23e12e5114240c73ecb4f4c48465da941f48d3a07ad7458f0943dd40444b93386b1a8822681d0b5384eaf224c89
```

### `dpkg` source package: `node-cli-table=0.3.11+~cs0.13.3-1`

Binary Packages:

- `node-cli-table=0.3.11+~cs0.13.3-1`

Licenses: (parsed from: `/usr/share/doc/node-cli-table/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-cli-table=0.3.11+~cs0.13.3-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-cli-table/node-cli-table_0.3.11%2b%7ecs0.13.3-1.dsc' node-cli-table_0.3.11+~cs0.13.3-1.dsc 3649 SHA512:8961ac924928852771342c39e1ec01cf01da848a94a1185f8b31511920e86d208ccf4916f928b1b43e7f2b464682fc557cb08b500564b1ccd23d47caff42d823
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-cli-table/node-cli-table_0.3.11%2b%7ecs0.13.3.orig-cli-table2.tar.gz' node-cli-table_0.3.11+~cs0.13.3.orig-cli-table2.tar.gz 47643 SHA512:1dbe0952dfa9f231a5c07d129a5ffe3768350e22727545adb63a9090a27f27703b59a31e60afac011937d851fd49999971a223a5a7a3b04f432376abf98e125d
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-cli-table/node-cli-table_0.3.11%2b%7ecs0.13.3.orig-cli-table3.tar.gz' node-cli-table_0.3.11+~cs0.13.3.orig-cli-table3.tar.gz 128550 SHA512:0cbb1c0a43aeb6d4fd89eb85557041db13465622e3ea7ba85d2155abbb2fb4f31bd7bb7c6729d401200e884134bd93440b90fcf83a41fe6cda61dcec9f733216
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-cli-table/node-cli-table_0.3.11%2b%7ecs0.13.3.orig-types-cli-table.tar.gz' node-cli-table_0.3.11+~cs0.13.3.orig-types-cli-table.tar.gz 1751 SHA512:4276542122495f28720fa2f57b94305c357f0398b65b5fe097a0fa60c73cbb49dc3dea5bbff078c374be8b356fb4083ad26ea1f893f4f7e63fd331769a88e515
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-cli-table/node-cli-table_0.3.11%2b%7ecs0.13.3.orig-types-cli-table2.tar.gz' node-cli-table_0.3.11+~cs0.13.3.orig-types-cli-table2.tar.gz 2165 SHA512:0f80eab00d06729aafadadf53aede91220fe11c1f4aedc5adbb5521f468e4ddce90ea0d4f927a74f1b0bdc1652dbd2a83fc08f8daf4bab653b1c20f96a6b870b
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-cli-table/node-cli-table_0.3.11%2b%7ecs0.13.3.orig.tar.gz' node-cli-table_0.3.11+~cs0.13.3.orig.tar.gz 10684 SHA512:c4ee0c6da774c0a2983d1f48258ba0b77f84ba3dd04313d5e57b99ef39436e97aa300a22b0270e950754490b9cf428589db4590b38e000da09ef1616e6159ea7
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-cli-table/node-cli-table_0.3.11%2b%7ecs0.13.3-1.debian.tar.xz' node-cli-table_0.3.11+~cs0.13.3-1.debian.tar.xz 5552 SHA512:d1c014cc3b331acbfc4fc4074b93e53858482ccc44df3f6e587f2b09e9c89e9d52391ef398d2af692814a9c1c178eeec06ee7b9a9d2ad8be5bc41359f0e2215c
```

### `dpkg` source package: `node-clone=2.1.2-3`

Binary Packages:

- `node-clone=2.1.2-3`

Licenses: (parsed from: `/usr/share/doc/node-clone/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-clone=2.1.2-3
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-clone/node-clone_2.1.2-3.dsc' node-clone_2.1.2-3.dsc 2036 SHA512:9784246d6bb01bfe7703a0cb1c815a092ca76944af5e5e97757c9b618be256e769f92449465e1759d362d68f3d77cbb93f7e8d81e14a9ca44dc3cf68c474f183
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-clone/node-clone_2.1.2.orig.tar.gz' node-clone_2.1.2.orig.tar.gz 10348 SHA512:da8b032d7895512e9684a7d798bcf1d727b3a8c0ab7a9b85e261a17c641cd7f6bbed971ed0e6cdc6fb43fc4b3c312109d9092e6b6650b1df430f049034cee5b2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-clone/node-clone_2.1.2-3.debian.tar.xz' node-clone_2.1.2-3.debian.tar.xz 2480 SHA512:c392711d54ecd08b6ce1148b3bf8a24664f68b4fca6a71abc01a196ace47cd50200a870ab8061e6b4f478b7e99fd64b3c2f2b758db8611ff67affbeacdc1f4d3
```

### `dpkg` source package: `node-color-convert=2.0.1-1`

Binary Packages:

- `node-color-convert=2.0.1-1`

Licenses: (parsed from: `/usr/share/doc/node-color-convert/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-color-convert=2.0.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-color-convert/node-color-convert_2.0.1-1.dsc' node-color-convert_2.0.1-1.dsc 2149 SHA512:3676177a7c064ea86c7bda8a786f0d960ef4f8818d142f4b34ad39c209762e5755a7f9b44db1d8f8b12b4b17e659c7536e0d2e741fc755b53550d261b4c598f5
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-color-convert/node-color-convert_2.0.1.orig.tar.gz' node-color-convert_2.0.1.orig.tar.gz 11791 SHA512:e97f2c78384a60bac6c58484bcdb0143318c5479a66c5a1976379a98700d0e7486c0bc102cb7e5700f2a11fc5f07496e129c154aa29174273fd08d8ce398a23f
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-color-convert/node-color-convert_2.0.1-1.debian.tar.xz' node-color-convert_2.0.1-1.debian.tar.xz 2620 SHA512:3c7e20bdc1208e2e04be6723d5adc29880cc09bbe342edfb71de5492abae7a2084df1ac60ef39a10cd50b56f23901c2181673967d2ce654edfbb950bb6d30394
```

### `dpkg` source package: `node-color-name=1.1.4+~1.1.1-2`

Binary Packages:

- `node-color-name=1.1.4+~1.1.1-2`

Licenses: (parsed from: `/usr/share/doc/node-color-name/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-color-name=1.1.4+~1.1.1-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-color-name/node-color-name_1.1.4%2b%7e1.1.1-2.dsc' node-color-name_1.1.4+~1.1.1-2.dsc 2447 SHA512:75360cee320d7ea2c3a9a940eddda9d5edfd1a922556d84cbec761da80016ac4e0a478bdd6fc4212cc524819bfa6943bc7feb8d3459c692fe639fbe2d91ad2c6
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-color-name/node-color-name_1.1.4%2b%7e1.1.1.orig-types-color-name.tar.gz' node-color-name_1.1.4+~1.1.1.orig-types-color-name.tar.gz 2296 SHA512:aebf8e432023c737bb1a05ab49a270c9d1d2b48847ab696f63704e0b6323eca9f323b5cad14c354ce39d23d943a1a8c46d258b898828a387f5479d5ead07e13d
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-color-name/node-color-name_1.1.4%2b%7e1.1.1.orig.tar.gz' node-color-name_1.1.4+~1.1.1.orig.tar.gz 4137 SHA512:269fdeb1e4104781edec3551871d17ec70c6d61d82f70f70e5553be9e471da1bdb7233f03c6bac6eb8556cf0bfa4cddf6a23f2138a5d019f3684c796c6ceb095
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-color-name/node-color-name_1.1.4%2b%7e1.1.1-2.debian.tar.xz' node-color-name_1.1.4+~1.1.1-2.debian.tar.xz 2960 SHA512:e7a1883782a49dd65331f4426a686038ab87ab6bb7c7daac797e2c5c45ce4928c0ed4b2c4cd6cf115cafcecdee5ae95b911774a39111ae804ab9a25ccaa39860
```

### `dpkg` source package: `node-columnify=1.5.4+~1.5.1-1`

Binary Packages:

- `node-columnify=1.5.4+~1.5.1-1`

Licenses: (parsed from: `/usr/share/doc/node-columnify/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-columnify=1.5.4+~1.5.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-columnify/node-columnify_1.5.4%2b%7e1.5.1-1.dsc' node-columnify_1.5.4+~1.5.1-1.dsc 2510 SHA512:18dea323d2283e854fa318b8543ed497efcc04dd52a07d5e732cf758e5fa80e746a9fd960ecbe4fa7effd31231fe6ad541df0263f260adf1dbf4acc4e52ec8e0
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-columnify/node-columnify_1.5.4%2b%7e1.5.1.orig-types-columnify.tar.gz' node-columnify_1.5.4+~1.5.1.orig-types-columnify.tar.gz 1856 SHA512:a575904c4bf070eec603016f4af68c38892d2dc2766a3200532311f772836595563761bbba27840c13c9b241265dbd10bfc24c3c785a440e766b308f7e216640
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-columnify/node-columnify_1.5.4%2b%7e1.5.1.orig.tar.gz' node-columnify_1.5.4+~1.5.1.orig.tar.gz 6140513 SHA512:50c8a37657ad9de4a358b35d4c34e55c5162b3bbc894297a481144d773a63063e098dacc20df0934c8798a4fe0d59e418fc3823b61ff23e3fa56f18ce44a6e01
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-columnify/node-columnify_1.5.4%2b%7e1.5.1-1.debian.tar.xz' node-columnify_1.5.4+~1.5.1-1.debian.tar.xz 3768 SHA512:55be826f4fae3ba2ed031e6c1a08c00b9148222eaadde082a7817f63971180708dea5303459e4e2188e50551c182d24c2ee246f389ca0c426000ef6688258eb4
```

### `dpkg` source package: `node-console-control-strings=1.1.0-2`

Binary Packages:

- `node-console-control-strings=1.1.0-2`

Licenses: (parsed from: `/usr/share/doc/node-console-control-strings/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-console-control-strings=1.1.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-console-control-strings/node-console-control-strings_1.1.0-2.dsc' node-console-control-strings_1.1.0-2.dsc 2220 SHA512:e3cf81b3b2f779feed1185bbf906a5b44cc4ee49bd00e5787f4030ca0b390871d234a2f23831d2ccdf17cc2c10530a835d6de20f190555e8bf1a74cd4fa6c56c
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-console-control-strings/node-console-control-strings_1.1.0.orig.tar.gz' node-console-control-strings_1.1.0.orig.tar.gz 4885 SHA512:3422b401b69f0ffc1925fba11372d728746a660802d07621682bcc433af04282cc933f98da68a2fb661eba0c9a23d88d2de0c7a06bf93c1f3af23250ba8f412d
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-console-control-strings/node-console-control-strings_1.1.0-2.debian.tar.xz' node-console-control-strings_1.1.0-2.debian.tar.xz 2364 SHA512:8357e39392d6e2e4a84d01a3e9f28bb887436e0610c856234a9c9d0e16cf4b095dda729155bad7fe06ab20355f6743ff54fb9f1da8e74cbd53798cc43e4752d4
```

### `dpkg` source package: `node-copy-concurrently=1.0.5-8`

Binary Packages:

- `node-copy-concurrently=1.0.5-8`

Licenses: (parsed from: `/usr/share/doc/node-copy-concurrently/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-copy-concurrently=1.0.5-8
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-copy-concurrently/node-copy-concurrently_1.0.5-8.dsc' node-copy-concurrently_1.0.5-8.dsc 2259 SHA512:86f0d4b2dd63d3c9322959a7321c86626fe00029aa6b28935adccd534811bcefae9bc77714078f8d5c6bc2ec9fbd4062264f1c73c0385cb6e13103899ff989ca
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-copy-concurrently/node-copy-concurrently_1.0.5.orig.tar.gz' node-copy-concurrently_1.0.5.orig.tar.gz 7636 SHA512:bb1bbed405de77a4d0b0cfa66bceb3eee073c1da6803dfe5b2c7c105cf78208307c3cc6030befcff590b88080684e1b958126d6337388a6c56883f9a0b61e79b
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-copy-concurrently/node-copy-concurrently_1.0.5-8.debian.tar.xz' node-copy-concurrently_1.0.5-8.debian.tar.xz 3164 SHA512:50b144e1850b1b2ede789c59c6e394964cbec554e2f73224fe3d9856af1e2757801342aada2c49eaf1765fcb0b1620a8dd46574133d23ff5789fa30f26df841f
```

### `dpkg` source package: `node-core-util-is=1.0.3-1`

Binary Packages:

- `node-core-util-is=1.0.3-1`

Licenses: (parsed from: `/usr/share/doc/node-core-util-is/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-core-util-is=1.0.3-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-core-util-is/node-core-util-is_1.0.3-1.dsc' node-core-util-is_1.0.3-1.dsc 2116 SHA512:00591be2b257bed7bffb73a865231b4e17c2d9707e097f4f7dc86a85201b07d5316a3ac8638cf37351fd438bb1ae99725e479e37a29e28f13453b8498ce4e365
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-core-util-is/node-core-util-is_1.0.3.orig.tar.gz' node-core-util-is_1.0.3.orig.tar.gz 64378 SHA512:12a0e723bf6c27f57b03f894d432b4845798bb5bb5c3c4fcb56ade074ea50a02fd835d435deceb8b0c8cc2b31ba3e926ec3234d7f7e93a404c1d6e6b1f9735a3
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-core-util-is/node-core-util-is_1.0.3-1.debian.tar.xz' node-core-util-is_1.0.3-1.debian.tar.xz 3420 SHA512:51482edf8091faf4a8067f064b701a10ed65678ee223a48bcaee004e23c01006b00f512f040318bbaf0a4cf4a768614a62d0dbe770e01dc301e07f80896deb8a
```

### `dpkg` source package: `node-debug=4.3.2+~cs4.1.7-1`

Binary Packages:

- `node-debug=4.3.2+~cs4.1.7-1`

Licenses: (parsed from: `/usr/share/doc/node-debug/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-debug=4.3.2+~cs4.1.7-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-debug/node-debug_4.3.2%2b%7ecs4.1.7-1.dsc' node-debug_4.3.2+~cs4.1.7-1.dsc 2527 SHA512:4db60110730500ca2adc2fc17f8f7ae16f5f8715b6b45b714e8124a1fc1a8147c1dbf665558c2a43bf41a4a74e31edc75889d5cc6014758c8a61dafcaae2a634
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-debug/node-debug_4.3.2%2b%7ecs4.1.7.orig-typesdebug.tar.gz' node-debug_4.3.2+~cs4.1.7.orig-typesdebug.tar.gz 2187 SHA512:f40a27533c938d75e110e6b40e7aa9cd98ba54796a28cb3081af445e3a579e7ab1c0bb5dbcf3ed94ef1ebeb2390fd4ba6ac151090eaffb0a6250a6f0faf2aaca
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-debug/node-debug_4.3.2%2b%7ecs4.1.7.orig.tar.gz' node-debug_4.3.2+~cs4.1.7.orig.tar.gz 15043 SHA512:4a5fb1cc3727f734ca19a4f8573bdeac9f72ea9e77339f1ed416a63c6e08efc0a35ba7f97bc4f9163ad062a3c81d9532bcd75cd7ee23bb5ca533ba1a48150515
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-debug/node-debug_4.3.2%2b%7ecs4.1.7-1.debian.tar.xz' node-debug_4.3.2+~cs4.1.7-1.debian.tar.xz 4616 SHA512:a7ea626b24eef4017f49ac77e7b44f9c7d5a89ce7c3c4d0aed99e0399c48d794bda3d1f0467bbfb43c258af62da355c72108634ad265b5794120c7222c5816fa
```

### `dpkg` source package: `node-decompress-response=6.0.0-2`

Binary Packages:

- `node-decompress-response=6.0.0-2`

Licenses: (parsed from: `/usr/share/doc/node-decompress-response/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-decompress-response=6.0.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-decompress-response/node-decompress-response_6.0.0-2.dsc' node-decompress-response_6.0.0-2.dsc 2268 SHA512:13b0a3acd388e340c3a3f694e29f4f24479335bd74510fe843a158bc6cfbf9f1fa72aa1f28ed3db428c7cc753bb7c45f4a516c135f4451fac7e9df622271f5dd
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-decompress-response/node-decompress-response_6.0.0.orig.tar.gz' node-decompress-response_6.0.0.orig.tar.gz 4300 SHA512:627c52c907255a7a231c32896554d8ee8045ac61c4f455152f9c64ff8c901a6c5971bf75bc5e8595b6e2e5862223d35178cafd3b58354936447679a695479e80
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-decompress-response/node-decompress-response_6.0.0-2.debian.tar.xz' node-decompress-response_6.0.0-2.debian.tar.xz 3888 SHA512:d1d85f762deb018968c7954a2c5ed27c9d8ec9168463bb9dd52694c25c159bfb171f1391c7b47b69e3651c509a942386c7faae2203867e1dcdbf53adb24e1b55
```

### `dpkg` source package: `node-defaults=1.0.3+~1.0.3-1`

Binary Packages:

- `node-defaults=1.0.3+~1.0.3-1`

Licenses: (parsed from: `/usr/share/doc/node-defaults/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-defaults=1.0.3+~1.0.3-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-defaults/node-defaults_1.0.3%2b%7e1.0.3-1.dsc' node-defaults_1.0.3+~1.0.3-1.dsc 2428 SHA512:0d175d403368faad5eda5aed0990c630697b9225b2a41944065bcc948fd9b6ed7e9fea2e8e3ebba8b2496d880067b6b8e52c08c90718c4d5eb02feef3f3de714
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-defaults/node-defaults_1.0.3%2b%7e1.0.3.orig-types-defaults.tar.gz' node-defaults_1.0.3+~1.0.3.orig-types-defaults.tar.gz 1513 SHA512:97fbe0e775906a9193981f04464631f3ff34feed98021152e8eae85357778ed3e9496f6f1dc939b173166362423e1960656ab73df0dbbb56276be10ab091cf51
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-defaults/node-defaults_1.0.3%2b%7e1.0.3.orig.tar.gz' node-defaults_1.0.3+~1.0.3.orig.tar.gz 2129 SHA512:764e0a626dab497c15ba0a2aa566908239d427d4502e70e04ef9e3f1a3bee9d05cc25ae409a6275f43cf2ea880c066e4631836403c7c6ce1dd00f6f4a3a80ef7
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-defaults/node-defaults_1.0.3%2b%7e1.0.3-1.debian.tar.xz' node-defaults_1.0.3+~1.0.3-1.debian.tar.xz 2988 SHA512:c75a72ba701270370d0e82c68267bf555e63f449512815f03b76a03c37613c830f563df421264f3c4da6989b7974a030c5d02650fb5b47788722d314d62f89a3
```

### `dpkg` source package: `node-delegates=1.0.0-3`

Binary Packages:

- `node-delegates=1.0.0-3`

Licenses: (parsed from: `/usr/share/doc/node-delegates/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-delegates=1.0.0-3
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-delegates/node-delegates_1.0.0-3.dsc' node-delegates_1.0.0-3.dsc 2086 SHA512:f3efcdfe1c0ec69d1dd0b78aff65fca802760d674ab3b0b42f5a82f1565c7b76c0a4ab3c123cdb9b1faef2d5147c898cba095e71645941697dfad2f5cedad8aa
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-delegates/node-delegates_1.0.0.orig.tar.gz' node-delegates_1.0.0.orig.tar.gz 2986 SHA512:27f7bcb1dc25331f201b05035045bf70e0baa94651559392a4e15054c5f551a7242766039be5089146061954e1917f1e430977750f91d1d5d85007dc61348ec7
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-delegates/node-delegates_1.0.0-3.debian.tar.xz' node-delegates_1.0.0-3.debian.tar.xz 3300 SHA512:2b9e8aed9cd20c4e7c3ff0ec6f2a0ba50d64fe9d893875be84a3d41a3413fc2a1cf5c8e4401f9b4795cbd4e14be861070e02c9fca26bdd96fba143ac26e1dfbb
```

### `dpkg` source package: `node-depd=2.0.0-2`

Binary Packages:

- `node-depd=2.0.0-2`

Licenses: (parsed from: `/usr/share/doc/node-depd/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-depd=2.0.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-depd/node-depd_2.0.0-2.dsc' node-depd_2.0.0-2.dsc 2050 SHA512:ade8bb27898faade315170eeb45eeee679ec51f704302cb97bd47b42828cc9719771e3209e55a261b7991db9607194fff8f2aa19ef0493150540f50a3ce06590
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-depd/node-depd_2.0.0.orig.tar.gz' node-depd_2.0.0.orig.tar.gz 18669 SHA512:c4e4adba8a3b0c0cead34290dc88cff9262c1f03a418f725fc4a41e58bb4ad2b30dde694751cbb80532706b8fa0913628b90f0073d5c2ddc8a2cd07e9ec5b6f4
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-depd/node-depd_2.0.0-2.debian.tar.xz' node-depd_2.0.0-2.debian.tar.xz 3092 SHA512:f96cbb4770798071d7ddb0df6b41cfd635797afe024b4317290e9ed2fe3e5055437ce49e7c4bbb61961a600600019e7c5ade65a3b1720fdadbcb1b43050d5b90
```

### `dpkg` source package: `node-encoding=0.1.13-2`

Binary Packages:

- `node-encoding=0.1.13-2`

Licenses: (parsed from: `/usr/share/doc/node-encoding/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-encoding=0.1.13-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-encoding/node-encoding_0.1.13-2.dsc' node-encoding_0.1.13-2.dsc 2105 SHA512:cd6f996498c4c0483977d26052c529e8bce5f653af865aeb0c664bc9eb3571a9bac03dc9b3b02b6af4249651ec3ef68e4fd4f1539d8b814cbd74a03b599c875c
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-encoding/node-encoding_0.1.13.orig.tar.gz' node-encoding_0.1.13.orig.tar.gz 24239 SHA512:fe528ca8565a91fc82d0d076db33f8f398b298a1da93ac3a6b8783fe9302e44917cfb1d8beb9143d89c133dcbca4baadbd3cb0ea25dbdcb9922e5c8951374ee5
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-encoding/node-encoding_0.1.13-2.debian.tar.xz' node-encoding_0.1.13-2.debian.tar.xz 2720 SHA512:3c448e49b2f240ae3a3111b0b70285c238e8524d3e3ef398156f1aaca3dc166cb76c855ac30febe5bbcefc717eb57dfea5523075f4f4f993d62e78d03d7e97a1
```

### `dpkg` source package: `node-end-of-stream=1.4.4+~1.4.1-1`

Binary Packages:

- `node-end-of-stream=1.4.4+~1.4.1-1`

Licenses: (parsed from: `/usr/share/doc/node-end-of-stream/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-end-of-stream=1.4.4+~1.4.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-end-of-stream/node-end-of-stream_1.4.4%2b%7e1.4.1-1.dsc' node-end-of-stream_1.4.4+~1.4.1-1.dsc 2529 SHA512:dbcbcd6c1977eb1eb23688d83597a156521a01b03e2e6b8264214802823e278148ba1403c709f052fca7d50b974e639b220a2179a0f878064d7f095454907809
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-end-of-stream/node-end-of-stream_1.4.4%2b%7e1.4.1.orig-types-end-of-stream.tar.gz' node-end-of-stream_1.4.4+~1.4.1.orig-types-end-of-stream.tar.gz 1730 SHA512:758092954b42197b8fd9ac5e283e65d6f8ffd3888d5d6f132d7af20dad2e03cbbc12c344ebc8e7dbb64b83b8c03d5faa240964d700b85ad45d228657bee525d0
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-end-of-stream/node-end-of-stream_1.4.4%2b%7e1.4.1.orig.tar.gz' node-end-of-stream_1.4.4+~1.4.1.orig.tar.gz 3353 SHA512:816a08d282c381f30c3b477b5192232e645d5f92e3cb2fde84d8383d4f5f7eb5d20178f88558985842fb636d2e62689ea1f6b7608c08cc31a295ddbbfeef4c18
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-end-of-stream/node-end-of-stream_1.4.4%2b%7e1.4.1-1.debian.tar.xz' node-end-of-stream_1.4.4+~1.4.1-1.debian.tar.xz 3124 SHA512:9674a461cf13c105cd2399d4e0c96ccacffad6f8ba7edbb985ab6dfe1c13d89e3fd4884d584d3fc8ab650a85a8a9d16da42ef18cd0fe5bfa82bb7fc0b1cd2a81
```

### `dpkg` source package: `node-err-code=2.0.3+dfsg-3`

Binary Packages:

- `node-err-code=2.0.3+dfsg-3`

Licenses: (parsed from: `/usr/share/doc/node-err-code/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-err-code=2.0.3+dfsg-3
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-err-code/node-err-code_2.0.3%2bdfsg-3.dsc' node-err-code_2.0.3+dfsg-3.dsc 2142 SHA512:ad0c67782e005194f7850d28c2ff65e6fea9539435f741f6e56d4ddee5f5c6156594cd79707e3b230bf113f6f07a78138d79e2035daecf4bdbb964cbbbf16774
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-err-code/node-err-code_2.0.3%2bdfsg.orig.tar.xz' node-err-code_2.0.3+dfsg.orig.tar.xz 31692 SHA512:f490d5524174d77f922bbaf4c320e8f00db14d0fd90eab0c31b5f92efcf40e1a1807ef5444d31cc834dab0b9fb7d6c53315165bf75f7ab8b43d938c7f215cade
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-err-code/node-err-code_2.0.3%2bdfsg-3.debian.tar.xz' node-err-code_2.0.3+dfsg-3.debian.tar.xz 2760 SHA512:1668552b8a30f1eda592f9ecbe238823841389a0c250526b82b08a0ebfa0b7a067fe9e7d5de90e946fc51ee0408738d61608c8537a18641cde0ba8bb92b3ae5c
```

### `dpkg` source package: `node-escape-string-regexp=4.0.0-2`

Binary Packages:

- `node-escape-string-regexp=4.0.0-2`

Licenses: (parsed from: `/usr/share/doc/node-escape-string-regexp/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-escape-string-regexp=4.0.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-escape-string-regexp/node-escape-string-regexp_4.0.0-2.dsc' node-escape-string-regexp_4.0.0-2.dsc 2194 SHA512:27b72144c8ad362c33a5ec3a7a96c2c37d3578eab2536cf7c63205d84a9051f8f8cd71af7354e50926a15d32cc331773754ab23910664665187760ff27d7a488
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-escape-string-regexp/node-escape-string-regexp_4.0.0.orig.tar.gz' node-escape-string-regexp_4.0.0.orig.tar.gz 2982 SHA512:18ab5f5383060901386fd60c503443314562e9dfae166541256410a6f18a7a43ebcb442c74a31c02f2902a5c608847e603b931d216f15e1144cddc506476f51e
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-escape-string-regexp/node-escape-string-regexp_4.0.0-2.debian.tar.xz' node-escape-string-regexp_4.0.0-2.debian.tar.xz 3460 SHA512:3c7cae8a24793a77a281fb7ee274260c508d5f13532df0e69089b251d7f702f9a1b34629ca238b8b048f8c9f2a34515ed1a20b5a15177fae09680bd576c7aa30
```

### `dpkg` source package: `node-events=3.3.0+~3.0.0-2`

Binary Packages:

- `libjs-events=3.3.0+~3.0.0-2`
- `node-events=3.3.0+~3.0.0-2`

Licenses: (parsed from: `/usr/share/doc/libjs-events/copyright`, `/usr/share/doc/node-events/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-events=3.3.0+~3.0.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-events/node-events_3.3.0%2b%7e3.0.0-2.dsc' node-events_3.3.0+~3.0.0-2.dsc 2478 SHA512:9d5ff4461fa0aba14e53913eaab900cd64e74d930a4d272026e502412b62bd7ca85c88d73e0a69fb5697893fb7378fe9fe895e900a3928658635ddb808aa890a
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-events/node-events_3.3.0%2b%7e3.0.0.orig-types-events.tar.gz' node-events_3.3.0+~3.0.0.orig-types-events.tar.gz 1735 SHA512:11a39bab022f6b22396bc742ce116b8cacd5c0a2f18e81bd4fa3e9779084a34ecb44a7d0f18a24c39e2be7e5aaec568143ec9746f40060fac7c326b5fd416df6
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-events/node-events_3.3.0%2b%7e3.0.0.orig.tar.gz' node-events_3.3.0+~3.0.0.orig.tar.gz 16654 SHA512:c55f29040db57c35be78248ee29b90a1ecee216cd22efc05ced074dddc3f0c40dfbc98d3d00e3617b83de967711edbce03a0e19ba199de1b697ca9c225ac3caa
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-events/node-events_3.3.0%2b%7e3.0.0-2.debian.tar.xz' node-events_3.3.0+~3.0.0-2.debian.tar.xz 4896 SHA512:de8311aad95bda5b47ee428eb406383ca203913d7a97dbf5226ab891db829b3cf616711963987a9664f4d5be223bad135be50be11724511f5055fca06b7b2e2d
```

### `dpkg` source package: `node-fancy-log=1.3.3+~cs1.3.1-2`

Binary Packages:

- `node-fancy-log=1.3.3+~cs1.3.1-2`

Licenses: (parsed from: `/usr/share/doc/node-fancy-log/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-fancy-log=1.3.3+~cs1.3.1-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-fancy-log/node-fancy-log_1.3.3%2b%7ecs1.3.1-2.dsc' node-fancy-log_1.3.3+~cs1.3.1-2.dsc 3746 SHA512:a9d46f8efcf26e43306d18584815744a5dcc6be21a1fb2d5d4c026a396f8ea5c6adcdc54bc90423032693a43223f2ac8c85fce1a0d1ede19297d80ddb2f3fb42
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-fancy-log/node-fancy-log_1.3.3%2b%7ecs1.3.1.orig-ansi-gray.tar.gz' node-fancy-log_1.3.3+~cs1.3.1.orig-ansi-gray.tar.gz 1959 SHA512:1eb806219525f21d841ee65a53d85347f714e6784ac69544d55ea4746b10f1ee338ab1252797efb5f73c37b435a2ad5a6ad3b6ef98bca541540a93560809d55b
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-fancy-log/node-fancy-log_1.3.3%2b%7ecs1.3.1.orig-ansi-wrap.tar.gz' node-fancy-log_1.3.3+~cs1.3.1.orig-ansi-wrap.tar.gz 2088 SHA512:672ce7bcbf24fc565e407af64fa2f3709ffebc10290e730d66f7d5172dc0b74927b3059deab277ff41e19a9bbca2a6ba0bdda7a66a33b3cf74b17f4397aabe43
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-fancy-log/node-fancy-log_1.3.3%2b%7ecs1.3.1.orig-color-support.tar.gz' node-fancy-log_1.3.3+~cs1.3.1.orig-color-support.tar.gz 13907 SHA512:c3c5d35baa3adb9614d925facf540e42fcc4b1064ce3d78a3eeaef027ff182d8b583b302575c6b335ee091a3f422f7e194dae24595e57f95db3a91e32985ab00
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-fancy-log/node-fancy-log_1.3.3%2b%7ecs1.3.1.orig-parse-node-version.tar.gz' node-fancy-log_1.3.3+~cs1.3.1.orig-parse-node-version.tar.gz 3921 SHA512:af8919dd0197be75fce1170e65c1707afedccf06baa99796cd66368bb63e91a162398279c0713562ec788526057e5b52357263a2e5c3e58347281287f8dfc193
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-fancy-log/node-fancy-log_1.3.3%2b%7ecs1.3.1.orig-types-fancy-log.tar.gz' node-fancy-log_1.3.3+~cs1.3.1.orig-types-fancy-log.tar.gz 1525 SHA512:df50edf496867c7adeb6fc15c4206b0852f9882f4c437cce5e9bbef02e2acd6d1cc5ce6b249546c41e5cfef67ec2679393f2633f3fc3d20bfc059f88a7a882a9
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-fancy-log/node-fancy-log_1.3.3%2b%7ecs1.3.1.orig.tar.gz' node-fancy-log_1.3.3+~cs1.3.1.orig.tar.gz 4458 SHA512:d7e5f45a30635e2814d95fd012673be6217b4bbd3b0c2f1f48d92f01408aa7c06984d1c5612ce44effeea49b4b59b508b1385b00f2a527b77f6bf524db5a549a
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-fancy-log/node-fancy-log_1.3.3%2b%7ecs1.3.1-2.debian.tar.xz' node-fancy-log_1.3.3+~cs1.3.1-2.debian.tar.xz 3364 SHA512:bb2c203c99a792f12b261959a94c37fd0f6d477d241b58d11dbe52b79ccf71da16951f266b5a2d1dd3ae074a57f6965e0d397ee109ae26ebef498658a26b720c
```

### `dpkg` source package: `node-fs-write-stream-atomic=1.0.10-5`

Binary Packages:

- `node-fs-write-stream-atomic=1.0.10-5`

Licenses: (parsed from: `/usr/share/doc/node-fs-write-stream-atomic/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-fs-write-stream-atomic=1.0.10-5
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-fs-write-stream-atomic/node-fs-write-stream-atomic_1.0.10-5.dsc' node-fs-write-stream-atomic_1.0.10-5.dsc 2320 SHA512:6d4f6dc8d4b324bbcec2ea9e4cb9e36bb33b2ebef331a60ab7b4911de8251d8b1f596a94f1a561d50d025c6eee19407d13ae8d4f29d771f3fba1e12f27892469
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-fs-write-stream-atomic/node-fs-write-stream-atomic_1.0.10.orig.tar.gz' node-fs-write-stream-atomic_1.0.10.orig.tar.gz 5770 SHA512:e8b5c49fe46580eca1be393b85661fc928344cd936d9ff990beec9d124dd3c597cc0c67c2324e90afcdd7a478e0d5c90dd8043cc267585c212826becd536e48a
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-fs-write-stream-atomic/node-fs-write-stream-atomic_1.0.10-5.debian.tar.xz' node-fs-write-stream-atomic_1.0.10-5.debian.tar.xz 2972 SHA512:4d0088bf1248c816f0beff790357ae49d3ed062833faa971f2608a346cd2b05b1d612d45ddf16f77e54af8c379701db61ea69bc47096d48586c843c56682ed25
```

### `dpkg` source package: `node-fs.realpath=1.0.0-2`

Binary Packages:

- `node-fs.realpath=1.0.0-2`

Licenses: (parsed from: `/usr/share/doc/node-fs.realpath/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-fs.realpath=1.0.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-fs.realpath/node-fs.realpath_1.0.0-2.dsc' node-fs.realpath_1.0.0-2.dsc 2078 SHA512:eb00a4f07eac29ce390f82ea501735de8e7627d727b0851e5bba2662ee2a794e71775ff32243057097cd510a67d8e00eef36eaae2311ddaff894524287f609c8
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-fs.realpath/node-fs.realpath_1.0.0.orig.tar.gz' node-fs.realpath_1.0.0.orig.tar.gz 5149 SHA512:d305f9a642c1113529c5a66928ed10ccd66996fa89fb35c1f619bcfd27738e0e6014ab37074c8cad22aead8878401574d39fb357028430ad66c73677cf58dcfa
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-fs.realpath/node-fs.realpath_1.0.0-2.debian.tar.xz' node-fs.realpath_1.0.0-2.debian.tar.xz 2792 SHA512:871a78b5083fb2ab7d752b9d870cfdd99889064618fdd9646a5ac8356542ce1beb37428cd6c0c2f84ce70d11946fd22a17ac28900b7bd9b740cc0ce9e688f18b
```

### `dpkg` source package: `node-function-bind=1.1.1+repacked+~1.0.3-1`

Binary Packages:

- `node-function-bind=1.1.1+repacked+~1.0.3-1`

Licenses: (parsed from: `/usr/share/doc/node-function-bind/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-function-bind=1.1.1+repacked+~1.0.3-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-function-bind/node-function-bind_1.1.1%2brepacked%2b%7e1.0.3-1.dsc' node-function-bind_1.1.1+repacked+~1.0.3-1.dsc 2634 SHA512:63ffbb0a671329021215e9112e7c74afcdf67417857ffacb223070b40b1c468d5b7647febabfb71b38e984882a2839e90c3f058e3cb8756bab5eed3d9b3be84a
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-function-bind/node-function-bind_1.1.1%2brepacked%2b%7e1.0.3.orig-has.tar.gz' node-function-bind_1.1.1+repacked+~1.0.3.orig-has.tar.gz 1998 SHA512:eadcbb3c4417a59b7429a132811db553fd84b2b3569d3ce4054c423e01385b8bcccdac0b1ad94ff93a2b3f9f955d454a62f9d36221ac32cd2e0ba2abb6f0c43c
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-function-bind/node-function-bind_1.1.1%2brepacked%2b%7e1.0.3.orig.tar.gz' node-function-bind_1.1.1+repacked+~1.0.3.orig.tar.gz 6306 SHA512:570cd9eb86ceb7c9121e00c09ac39071eebd24272fe14276807ee3219495a83a7c4619ceea73aa5b54ced9d5b30abc1444de19e02f637ff543846cfe03e92eb4
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-function-bind/node-function-bind_1.1.1%2brepacked%2b%7e1.0.3-1.debian.tar.xz' node-function-bind_1.1.1+repacked+~1.0.3-1.debian.tar.xz 3364 SHA512:4c04eea32e9a7978198dafe90077b247c02ce029b2b169dec64c77bc9af2ca8e2f01a2e3914b3ecdbd9461df9e91bcec17c231e68f8ac53678a87838f7ea4db8
```

### `dpkg` source package: `node-gauge=4.0.2-1`

Binary Packages:

- `node-gauge=4.0.2-1`

Licenses: (parsed from: `/usr/share/doc/node-gauge/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-gauge=4.0.2-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-gauge/node-gauge_4.0.2-1.dsc' node-gauge_4.0.2-1.dsc 2311 SHA512:60a133559ad18668486abab1a4a0aa551c2dc33d3c06f0ac0df5fc24f1978cbf589256c281a127f0c9db5c79ba9453c15a0f950a9c6a88f4530c7bb0f914d2b7
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-gauge/node-gauge_4.0.2.orig.tar.gz' node-gauge_4.0.2.orig.tar.gz 229813 SHA512:00399c737e254327b2f3e4c8dc170b72597363ca226363de92d103e839ca11c3eb0cb2dad3c4a89491a23ce04ab3590ea6e6c9eaa52633ac72463909607180cc
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-gauge/node-gauge_4.0.2-1.debian.tar.xz' node-gauge_4.0.2-1.debian.tar.xz 2700 SHA512:77aacd8955da59f5517e8b8cec5d8b4231094de7b28b992cb2a43732494090297ce02298a46a25ed7547104d230f64ac8ec524cbcd547ba4a1d266392bd24de4
```

### `dpkg` source package: `node-get-stream=6.0.1-1`

Binary Packages:

- `node-get-stream=6.0.1-1`

Licenses: (parsed from: `/usr/share/doc/node-get-stream/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-get-stream=6.0.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-get-stream/node-get-stream_6.0.1-1.dsc' node-get-stream_6.0.1-1.dsc 2149 SHA512:5fd66b243b10f09823521a0833424497c026a2fd2e69861e957ae9058b51e1541d2566a5623c780d54e6dc8fe983d7f5059fdeea77a71245bfc8eac86fc79e36
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-get-stream/node-get-stream_6.0.1.orig.tar.gz' node-get-stream_6.0.1.orig.tar.gz 6406 SHA512:bc0e0eaabb7473e7eeec05537ffcee8665e3b602ece80a3572a708565c65c8de6e2a3d0cc9a99d61119a1907ee0ffc56489582083ad2415bea95eee8d1ca730b
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-get-stream/node-get-stream_6.0.1-1.debian.tar.xz' node-get-stream_6.0.1-1.debian.tar.xz 5504 SHA512:862c799872933781093434c3ec59b680cb1912ba665f6821fbe79ba4ad2d1587aea81f07c3462dc9d0768a49fd73d97c8ae5a483e9f0b616bfacb3e65ad12c69
```

### `dpkg` source package: `node-glob=7.2.1+~cs7.6.15-1`

Binary Packages:

- `node-glob=7.2.1+~cs7.6.15-1`

Licenses: (parsed from: `/usr/share/doc/node-glob/copyright`)

- `CC-BY-SA-4.0`
- `Expat`
- `GPL-2`
- `GPL-2+`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-glob=7.2.1+~cs7.6.15-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-glob/node-glob_7.2.1%2b%7ecs7.6.15-1.dsc' node-glob_7.2.1+~cs7.6.15-1.dsc 3626 SHA512:fb39163a5508b4b397b92140b8bb32ff48a9c73dcac0148bba78278a03a676e5a0956677c9b3151542c7855e1aa603f2c4bbbf48584204199f8e3e6ed217c5c1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-glob/node-glob_7.2.1%2b%7ecs7.6.15.orig-globalyzer.tar.gz' node-glob_7.2.1+~cs7.6.15.orig-globalyzer.tar.gz 10130 SHA512:3902f7bc5d27b0b0389010540aeb525a476d870a6b61cf7f6b0e4375a94a802248e8443fb080892d5c16bd9e989990bbee171b5f5635ed7a71814e737f14114b
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-glob/node-glob_7.2.1%2b%7ecs7.6.15.orig-globrex.tar.gz' node-glob_7.2.1+~cs7.6.15.orig-globrex.tar.gz 30336 SHA512:fc7c3ff252265b3a525cad0aa35ada122a3a6d4d494d5251fea97d1af83c6ce86d4bc10e0e44fbeecca6cb0ecbe8d1abdd03d65a8e3db232f63914ec91928256
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-glob/node-glob_7.2.1%2b%7ecs7.6.15.orig-tiny-glob.tar.gz' node-glob_7.2.1+~cs7.6.15.orig-tiny-glob.tar.gz 29512 SHA512:4809f5fa86058a909c6beccc9077dbaf1059398c29161c31bdf570673085ce0c4711624895e1aa1699c12b7d21184b7cf43b021e08c004c502c9796ec3c861d7
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-glob/node-glob_7.2.1%2b%7ecs7.6.15.orig-types-glob.tar.gz' node-glob_7.2.1+~cs7.6.15.orig-types-glob.tar.gz 2359 SHA512:654c5bcca97421f2482d34bab7b8a9e5f41033f2774c962e6c39b79cc6e0b9b34d612eb6797794a682d40bcffb7c93621581d3ac63d09fb86ca435332075f750
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-glob/node-glob_7.2.1%2b%7ecs7.6.15.orig.tar.gz' node-glob_7.2.1+~cs7.6.15.orig.tar.gz 986298 SHA512:6c879b0a2f3cc0ec51130df4ebe208ca6c63e7d0d4f83a0c2b4cc1e6c81bd0661a8a5ba3da3318723b9ab94f4450954eaa8197dd1b6fd72315d17ada2c05d5f7
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-glob/node-glob_7.2.1%2b%7ecs7.6.15-1.debian.tar.xz' node-glob_7.2.1+~cs7.6.15-1.debian.tar.xz 11360 SHA512:b1b6f1d3af9beecee4a615420c8df4f0d982c60313d6988afe19d1c327ad61a1f8006c7b042099f22e65ba448eac9ee4f11a46a153de52e7b6e4ea5428a6eac9
```

### `dpkg` source package: `node-got=11.8.3+~cs58.7.37-1`

Binary Packages:

- `node-got=11.8.3+~cs58.7.37-1`

Licenses: (parsed from: `/usr/share/doc/node-got/copyright`)

- `Apache-2.0`
- `BSD-2-Clause`
- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-got=11.8.3+~cs58.7.37-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-got/node-got_11.8.3%2b%7ecs58.7.37-1.dsc' node-got_11.8.3+~cs58.7.37-1.dsc 7488 SHA512:1fc55638e124974abdfecbc6384a6c3064179f6f6bbe956601d5dd3d842954c15d9010bc3b4792c00788fe7f51427a939659b3916837445174ab74a463c03f8a
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-got/node-got_11.8.3%2b%7ecs58.7.37.orig-cacheable-lookup.tar.gz' node-got_11.8.3+~cs58.7.37.orig-cacheable-lookup.tar.gz 12992 SHA512:8bec829ea3aa79f6fde3e77ec6ed069769bd84f7522a7832cf31d246b249693349bb01efb3a45c7ecdc4f4de1a38869e8e740737bdb711edbc185289af686ca4
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-got/node-got_11.8.3%2b%7ecs58.7.37.orig-cacheable-request.tar.gz' node-got_11.8.3+~cs58.7.37.orig-cacheable-request.tar.gz 11085 SHA512:46b54d1402d6d60caaa71fab8eab96c87d6ffe7ffcf5fae41735623280d410f2c09e06f111c3ae026f7463168ffffc891eb30fb126b3f3ee5fc77e4a55892f1a
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-got/node-got_11.8.3%2b%7ecs58.7.37.orig-clone-response.tar.gz' node-got_11.8.3+~cs58.7.37.orig-clone-response.tar.gz 3699 SHA512:f0f2740fc85ee5f9f78f4da091deb05431ce26817a86b7c5b7cbfac61c9befcc212d3ccccc5f3f76cf04b8d0d60cce3c89eef2d21521adc9555f32bbb9812aa2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-got/node-got_11.8.3%2b%7ecs58.7.37.orig-defer-to-connect.tar.gz' node-got_11.8.3+~cs58.7.37.orig-defer-to-connect.tar.gz 3601 SHA512:5b7c8cf15f2325f4a889c867c90a1173805890a342e0b83b943d873bd60ff84679b880dda06778675190b258360020622736c5b4d9eb24aa09680ae55220b64b
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-got/node-got_11.8.3%2b%7ecs58.7.37.orig-http-cache-semantics.tar.gz' node-got_11.8.3+~cs58.7.37.orig-http-cache-semantics.tar.gz 59487 SHA512:52c476d2bef0ffa337acde8eb8bbb12975030135c74eead7f4eefd057279fb7ee3bcc358accd835d9258dc33ed29ea945689c7d30ae56ebee3f240a3394071ed
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-got/node-got_11.8.3%2b%7ecs58.7.37.orig-http2-wrapper.tar.gz' node-got_11.8.3+~cs58.7.37.orig-http2-wrapper.tar.gz 20994 SHA512:cf98cf2e40d71ec40cefad97168e17a6ba074d74f494c42c70a09030f19c7070f363490dc665315b21a45baeb307644602bf6917d4f37390e69aff1487c1d6dd
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-got/node-got_11.8.3%2b%7ecs58.7.37.orig-keyv.tar.gz' node-got_11.8.3+~cs58.7.37.orig-keyv.tar.gz 9291 SHA512:b8f5d2cd8bf461302d60b5a6856a2c859b01f4bf070e37f4ed827b55ac8171cfee5e05d9cafde8224e5f1b9abb16e8901d72e074c0091337c33244d4493c5d25
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-got/node-got_11.8.3%2b%7ecs58.7.37.orig-normalize-url.tar.gz' node-got_11.8.3+~cs58.7.37.orig-normalize-url.tar.gz 9957 SHA512:40d71d2310b3a04b62a52284c42366e9fcc7129b7e2941babdc4af2eadaf2a9f882773c6682bc531edc736692087a1e30283b85dcaf86dc371643874da8e9984
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-got/node-got_11.8.3%2b%7ecs58.7.37.orig-resolve-alpn.tar.gz' node-got_11.8.3+~cs58.7.37.orig-resolve-alpn.tar.gz 3879 SHA512:66b6d7a1177d4f46445732ec1c3b4996e6cb926789369299a1ee541a2ed54d22a6d22f80551c9698976efbb2479ef9fe30d1b99405f45f89f4b2a89a79f66262
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-got/node-got_11.8.3%2b%7ecs58.7.37.orig-responselike.tar.gz' node-got_11.8.3+~cs58.7.37.orig-responselike.tar.gz 3649 SHA512:87484b8cb2e9ac08f697bff47b3cf6e4b830eb32a8aa57d1a4d46b0c12a998ee0d6d3d09ceda4ce586b9f303de8b0bb96b46e1ff2c65e112b1c568a423db4f85
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-got/node-got_11.8.3%2b%7ecs58.7.37.orig-sindresorhus-is.tar.gz' node-got_11.8.3+~cs58.7.37.orig-sindresorhus-is.tar.gz 958500 SHA512:7456637c6945401a55344c10b0d67b5f4ab1f46209b831c0bb5a6e1eb033642fb53e7107284fe0ce0f275c165907d9f9ae654948981f9cc9e0053a78df049c3b
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-got/node-got_11.8.3%2b%7ecs58.7.37.orig-szmarczak-http-timer.tar.gz' node-got_11.8.3+~cs58.7.37.orig-szmarczak-http-timer.tar.gz 6769 SHA512:b75d0031dae93afebc904cb52fc8ca1cb8137fd37d86aaa71936b3a7969babe494c4189cc795a5863237bff729f76e2d42bc54a6f21c5092eeaa19ac7fb6bec3
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-got/node-got_11.8.3%2b%7ecs58.7.37.orig-types-cacheable-request.tar.gz' node-got_11.8.3+~cs58.7.37.orig-types-cacheable-request.tar.gz 2899 SHA512:077c55a3e76528cea79ca4dc9a6e59b58fce2fc6ce00e7763a579ef4cd737edeb9a31e743b38c41d6f75b03894f63e9cbd6f048e0d7f4247f8c5dda4ba002950
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-got/node-got_11.8.3%2b%7ecs58.7.37.orig-types-http-cache-semantics.tar.gz' node-got_11.8.3+~cs58.7.37.orig-types-http-cache-semantics.tar.gz 3727 SHA512:499b3b7a46cff02374b71546db15511fa1202a6126df504ec40d3bbe415a113cd9cf5c61f9c6edf01708d2c969ca6bf0871e5d9459d01b6ad394f5509fe8913d
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-got/node-got_11.8.3%2b%7ecs58.7.37.orig-types-keyv.tar.gz' node-got_11.8.3+~cs58.7.37.orig-types-keyv.tar.gz 2417 SHA512:157089832c8dde2bd5811a2697887de06fe9de463ebbf07ce8b6be429b5ca89696b415ad99ce93b6435f4b8d27f5b22fc8bb5e1e1ef35ceb606e86ce44a3db0e
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-got/node-got_11.8.3%2b%7ecs58.7.37.orig-types-responselike.tar.gz' node-got_11.8.3+~cs58.7.37.orig-types-responselike.tar.gz 1877 SHA512:f396360638ae7c5cda30896f243bd34c1f05c65db17cba381e0987cd5073d3cc38c0378f0938d8c3ae8f76ba253b4933962df26a6fd80a046e7f2a350dd4154c
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-got/node-got_11.8.3%2b%7ecs58.7.37.orig.tar.gz' node-got_11.8.3+~cs58.7.37.orig.tar.gz 462974 SHA512:2216aa1d3657c0f9b11937a5f8e1ebb2eb85d1c448679b1504a1c1fcd43131924fa2c7833c6f6955304e8eae527c2b794249dc07b07546b7533ae4d5fe5b8680
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-got/node-got_11.8.3%2b%7ecs58.7.37-1.debian.tar.xz' node-got_11.8.3+~cs58.7.37-1.debian.tar.xz 8064 SHA512:5ccdde2a0c1cf496f8837426b8b79df127ac21f9cf603ffb7e0d092456eb593b20f0daac780910b93997fdeeaf0766f9bce5a830d507322fc10bd6200cd9de98
```

### `dpkg` source package: `node-graceful-fs=4.2.4+repack-1`

Binary Packages:

- `node-graceful-fs=4.2.4+repack-1`

Licenses: (parsed from: `/usr/share/doc/node-graceful-fs/copyright`)

- `BSD-2-clause`
- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-graceful-fs=4.2.4+repack-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-graceful-fs/node-graceful-fs_4.2.4%2brepack-1.dsc' node-graceful-fs_4.2.4+repack-1.dsc 2505 SHA512:d91dff13d6ad96410de27f00487ba01f4d5b434547e7932fe195497159017a70b2b5aa5968ef557695b31643c4833360febf01451dfa3897011cc93e5e69754c
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-graceful-fs/node-graceful-fs_4.2.4%2brepack.orig-types-graceful-fs.tar.gz' node-graceful-fs_4.2.4+repack.orig-types-graceful-fs.tar.gz 1832 SHA512:99603fe3315085fbce03ccd6917a1bc09bc10fbbf373182b390d09e421f5be8b46a9dabd9bbf85c2d19aab2099a82dcdcb206473dcf89be8abcb82e5a9c31626
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-graceful-fs/node-graceful-fs_4.2.4%2brepack.orig.tar.gz' node-graceful-fs_4.2.4+repack.orig.tar.gz 35345 SHA512:5cc381c84d31e3b055b37c93b063d767690de4e73d909c66d1a9893652ed83f182a0102543084ee66ff33280426b681d3af8bb1245581cb4ef56e4202e97c25a
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-graceful-fs/node-graceful-fs_4.2.4%2brepack-1.debian.tar.xz' node-graceful-fs_4.2.4+repack-1.debian.tar.xz 4348 SHA512:b937020fd81e9c2a6194c2c3d0a3996896d9aa862580be6e5dd04a608fa1e7e881d49f2ba43782a9655d2c3dc5a3b1ec36b6243e6a63070a225adeb495d2bd79
```

### `dpkg` source package: `node-gyp=8.4.1-1`

Binary Packages:

- `node-gyp=8.4.1-1`

Licenses: (parsed from: `/usr/share/doc/node-gyp/copyright`)

- `BSD-3-clause~Google`
- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-gyp=8.4.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-gyp/node-gyp_8.4.1-1.dsc' node-gyp_8.4.1-1.dsc 1970 SHA512:9eb060d7777015ae20585b1c09681fa723c6a28b1f0a93c0225c5cb6ad0af409a925f8c03bec8faa4d2d94e9a0b66d5dbbfed389c79f6ac014a8360e1ad85626
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-gyp/node-gyp_8.4.1.orig.tar.gz' node-gyp_8.4.1.orig.tar.gz 453855 SHA512:5fbd417ca9427e0d00dce3a25aa49ac336e117ebbc86e70866fe47eee6a2078fbe98ab9fc16a34848164732998d7a6a1aaf65d199045e5f032b04a542aa10f37
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-gyp/node-gyp_8.4.1-1.debian.tar.xz' node-gyp_8.4.1-1.debian.tar.xz 9748 SHA512:dfd8c5a11b7c1fc18a3084935453c1fa8c28bf6773db1632acb6580d13b2d678d900e5814e4ffce68bf94268c6aae8127e29668ff8abf05e0077d9ccc0e54f7c
```

### `dpkg` source package: `node-has-flag=4.0.0-2`

Binary Packages:

- `node-has-flag=4.0.0-2`

Licenses: (parsed from: `/usr/share/doc/node-has-flag/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-has-flag=4.0.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-has-flag/node-has-flag_4.0.0-2.dsc' node-has-flag_4.0.0-2.dsc 2053 SHA512:a7558126fc2d04e7d1d65db7ebbbe80d6e37e0f9fffbdac8c72cd43bea91d25daa1091783e514b5b8991d96429c46323b9306f8aa0aa2be4c87d39e1c7a94e63
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-has-flag/node-has-flag_4.0.0.orig.tar.gz' node-has-flag_4.0.0.orig.tar.gz 2921 SHA512:50bc442195a8c0117df16a6dbb2e47c13124dad9733c9ba5b4435d72ca4a9c0ffb39cfb1c5b689f21b30a2855f53135df1473e6a69179fbc28ffc8648e59dd92
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-has-flag/node-has-flag_4.0.0-2.debian.tar.xz' node-has-flag_4.0.0-2.debian.tar.xz 2916 SHA512:3da180007e38d9f5cc5706099571edde7f40dbad3b1a9baca99d8e0244a93220e545acb4ca03dc499c7ca2c1b47c0eec1f7836a3071153934dd350ee2ef11b29
```

### `dpkg` source package: `node-has-unicode=2.0.1-4`

Binary Packages:

- `node-has-unicode=2.0.1-4`

Licenses: (parsed from: `/usr/share/doc/node-has-unicode/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-has-unicode=2.0.1-4
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-has-unicode/node-has-unicode_2.0.1-4.dsc' node-has-unicode_2.0.1-4.dsc 2123 SHA512:1bbe025e10da22fc856e7983233d7348d4cbc800d83d514bfb367a37e3174a52cdc3dad7e2b880067906dba4fbc089da58e27a1650c8bf07d6383122590e2726
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-has-unicode/node-has-unicode_2.0.1.orig.tar.gz' node-has-unicode_2.0.1.orig.tar.gz 2967 SHA512:10ca02b64710bda66d852a66d6ad3468b5fb422310c73819fc293d2a56f725c1f0899d55d11ce874929f5a9c8f6b83f767029ca9e086124e40239c67f24fd110
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-has-unicode/node-has-unicode_2.0.1-4.debian.tar.xz' node-has-unicode_2.0.1-4.debian.tar.xz 2456 SHA512:ab90af60db2ac8fa5fe50c0d5a47fee9102a20f6055764621c75cc36f0609d824b388b3227a1927ad157ca4222d68488d2f067aef7a105fd0a42ea33f99d073a
```

### `dpkg` source package: `node-hosted-git-info=4.0.2-1`

Binary Packages:

- `node-hosted-git-info=4.0.2-1`

Licenses: (parsed from: `/usr/share/doc/node-hosted-git-info/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-hosted-git-info=4.0.2-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-hosted-git-info/node-hosted-git-info_4.0.2-1.dsc' node-hosted-git-info_4.0.2-1.dsc 2193 SHA512:a105ff0cc9a6f405e339dd03a674c5e21b4b89c962a686920047a7ec1862f7bd804ed640bd96eb12ffe0dc21c5b8dca1f3f45b270316e67993c135d517dbd1ea
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-hosted-git-info/node-hosted-git-info_4.0.2.orig.tar.gz' node-hosted-git-info_4.0.2.orig.tar.gz 133812 SHA512:19dd370bd9a26ec2166e88a0a3e55ea4b403c36db7881a6d93d6162338e48aaf73df663bf79d6ea1bf8f1cbda0d75d485c00790e392c163238669b47b619bc14
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-hosted-git-info/node-hosted-git-info_4.0.2-1.debian.tar.xz' node-hosted-git-info_4.0.2-1.debian.tar.xz 3092 SHA512:8125ad02e05112cdb13678a4050a5045cb929623238941b9e2177bb03a3a010348c844268c3fee7ee67995a9930b57ae819a24c8b60ad7afdb60f526490eeb55
```

### `dpkg` source package: `node-https-proxy-agent=5.0.0+~cs8.0.0-3`

Binary Packages:

- `node-https-proxy-agent=5.0.0+~cs8.0.0-3`

Licenses: (parsed from: `/usr/share/doc/node-https-proxy-agent/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-https-proxy-agent=5.0.0+~cs8.0.0-3
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-https-proxy-agent/node-https-proxy-agent_5.0.0%2b%7ecs8.0.0-3.dsc' node-https-proxy-agent_5.0.0+~cs8.0.0-3.dsc 3088 SHA512:53483bc61459c415c8680388f97417cf532fc326e33c188f91844b612f874c82433555d59087994d897ad70288e8e0d0816b7e9eb3c6fac388d6f67f4410ff4b
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-https-proxy-agent/node-https-proxy-agent_5.0.0%2b%7ecs8.0.0.orig-http-proxy-agent.tar.gz' node-https-proxy-agent_5.0.0+~cs8.0.0.orig-http-proxy-agent.tar.gz 9304 SHA512:ccf60dd265523d246bbc5bdfe36971460fe5c4d1642bdc326ea8e6066a781779c9071343ce3a57c28c70f0245a86f14ee79695633520a45410f37800be41c118
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-https-proxy-agent/node-https-proxy-agent_5.0.0%2b%7ecs8.0.0.orig-tootallnate-once.tar.gz' node-https-proxy-agent_5.0.0+~cs8.0.0.orig-tootallnate-once.tar.gz 5737 SHA512:64835fa332ca65ec095f0cd57613b13e67a922716b06ff28be1eed5db62e8f2ccc8f0f18be5954a2efd48706b5aaf875c552dd3f8524216e89aa82f5426717ae
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-https-proxy-agent/node-https-proxy-agent_5.0.0%2b%7ecs8.0.0.orig.tar.gz' node-https-proxy-agent_5.0.0+~cs8.0.0.orig.tar.gz 11010 SHA512:9da990cada75fd7b2acee5f563fd566d7a6e25ef221edf7663aa72fa5f1556f30085cec2c3f8cc49adbbc8e693f3977227d07ade73db897b08a0f87a0f1ea763
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-https-proxy-agent/node-https-proxy-agent_5.0.0%2b%7ecs8.0.0-3.debian.tar.xz' node-https-proxy-agent_5.0.0+~cs8.0.0-3.debian.tar.xz 3932 SHA512:585d5b588d3385019ace67c8c53cb1035266fde39ef53f8fdfb98e2bc34e98f4915c7d21be61b68042ab0f894d7c5d2d870650e5528e2176556e5912d6dc9914
```

### `dpkg` source package: `node-iconv-lite=0.6.3-2`

Binary Packages:

- `node-iconv-lite=0.6.3-2`

Licenses: (parsed from: `/usr/share/doc/node-iconv-lite/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-iconv-lite=0.6.3-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-iconv-lite/node-iconv-lite_0.6.3-2.dsc' node-iconv-lite_0.6.3-2.dsc 2192 SHA512:0ea9f24e02fa754de21522a0ec2579ac41038500db1058d98a5ec7ba996c96b59f645c6f659fce7554870c6d1961ed4b27b39e6e1cb8b9c5de69475d7e673b03
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-iconv-lite/node-iconv-lite_0.6.3.orig.tar.gz' node-iconv-lite_0.6.3.orig.tar.gz 231007 SHA512:1406164ed01833d20c7de54a4bf04cda8b513946522f6e8ac83d1e581470ca5441477355e21339247b2da28315997c7af219d3f7ecccd30ee707bcce44b86d31
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-iconv-lite/node-iconv-lite_0.6.3-2.debian.tar.xz' node-iconv-lite_0.6.3-2.debian.tar.xz 3820 SHA512:11fe137879de82ee8743c09998e46b70a0f19805daab67abbf5406cced6c5037ce23e08c21a73941f9cff0ce353392b300fd55d4ecc90ecf5e9460bb8e1de42a
```

### `dpkg` source package: `node-iferr=1.0.2+~1.0.2-1`

Binary Packages:

- `node-iferr=1.0.2+~1.0.2-1`

Licenses: (parsed from: `/usr/share/doc/node-iferr/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-iferr=1.0.2+~1.0.2-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-iferr/node-iferr_1.0.2%2b%7e1.0.2-1.dsc' node-iferr_1.0.2+~1.0.2-1.dsc 2402 SHA512:63f17009d391ea38b2085727845e78a39adcb9318a6831c3afc865efde88ef160aca2d56d42591d8fc0467ddeaddb7a7401a9987c4bceffa724f96e1d79b8c38
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-iferr/node-iferr_1.0.2%2b%7e1.0.2.orig-types-iferr.tar.gz' node-iferr_1.0.2+~1.0.2.orig-types-iferr.tar.gz 1764 SHA512:a9f7bdb0b2a66bca3a56055771302c2bab0e4dfddd0639357bfa69cdd8865e3b1853b995bf56e9bf561f2ae5befe5ac991a85268f80e433c6eed396da6717afe
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-iferr/node-iferr_1.0.2%2b%7e1.0.2.orig.tar.gz' node-iferr_1.0.2+~1.0.2.orig.tar.gz 4407 SHA512:789d7bd3554ea4fd5e399b87b768cf5c17cf641528183b57455ccae22a5a7bf9717aa1971b21b07d27fdb52f5fb1649c969943c8427c0f586beda45f781dfce5
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-iferr/node-iferr_1.0.2%2b%7e1.0.2-1.debian.tar.xz' node-iferr_1.0.2+~1.0.2-1.debian.tar.xz 3316 SHA512:36d37baec8435b0e6299d6b2ee3d3ad30ae57b5a4cc7cca18b9d05e5026d7ea721a949bf8599d37b47714d18ba8fcc55ec0848a054943038b6c00579d376a25c
```

### `dpkg` source package: `node-imurmurhash=0.1.4+dfsg+~0.1.1-1`

Binary Packages:

- `node-imurmurhash=0.1.4+dfsg+~0.1.1-1`

Licenses: (parsed from: `/usr/share/doc/node-imurmurhash/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-imurmurhash=0.1.4+dfsg+~0.1.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-imurmurhash/node-imurmurhash_0.1.4%2bdfsg%2b%7e0.1.1-1.dsc' node-imurmurhash_0.1.4+dfsg+~0.1.1-1.dsc 2510 SHA512:3a12a77621788e0bc2032b06687f5cdd2b1b9e3d72340fc284666fbfe7895e524c527c78bfa81fd64f40ae7c3caad4b2a4b79b87d92b52557055fde9b84f2462
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-imurmurhash/node-imurmurhash_0.1.4%2bdfsg%2b%7e0.1.1.orig-types-imurmurhash.tar.xz' node-imurmurhash_0.1.4+dfsg+~0.1.1.orig-types-imurmurhash.tar.xz 2152 SHA512:556c198f61bc87ebc1fd0e783216211cdd9f32319444b49d96bf6e230c524a9fcd01863ca72df0af63631c537f29a6581a884506481855a5dcf1b11cff95cee6
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-imurmurhash/node-imurmurhash_0.1.4%2bdfsg%2b%7e0.1.1.orig.tar.xz' node-imurmurhash_0.1.4+dfsg+~0.1.1.orig.tar.xz 4324 SHA512:f8c9a0123d147f586e24111ea06bfd738026d46662da8cf40627a71f96933ff131e0617c93a392f408a38b54161ca862d4d97dcb8057d717f85a64007babc48d
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-imurmurhash/node-imurmurhash_0.1.4%2bdfsg%2b%7e0.1.1-1.debian.tar.xz' node-imurmurhash_0.1.4+dfsg+~0.1.1-1.debian.tar.xz 3020 SHA512:eef8ba7fa3228afeb26cbdef3260c9e548e1f7ba86a91ea43d772ff97485c16265561f965ecda63030f3b1395cbe35b97294de4a804dcf4bcf1c75ba7dac4be1
```

### `dpkg` source package: `node-indent-string=4.0.0-2`

Binary Packages:

- `node-indent-string=4.0.0-2`

Licenses: (parsed from: `/usr/share/doc/node-indent-string/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-indent-string=4.0.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-indent-string/node-indent-string_4.0.0-2.dsc' node-indent-string_4.0.0-2.dsc 2106 SHA512:bbcf46a996b8d51d5e7ab470a2cdd52b9a7e37d42b1ccae31401b2032f7ddbf1021e64a28f6b7336473cf1daeae31084f69d6cc176689d57df37353b632c7114
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-indent-string/node-indent-string_4.0.0.orig.tar.gz' node-indent-string_4.0.0.orig.tar.gz 2966 SHA512:43b250374104aec75de4042aa3e9ec58342d7aaa4c39239b3e0884cfa9bc86240a9ad8772ab52ac8f6b06ca7a699078832a626094c7cd1c22d0395ac9034dcfd
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-indent-string/node-indent-string_4.0.0-2.debian.tar.xz' node-indent-string_4.0.0-2.debian.tar.xz 3272 SHA512:0fef7ce669e3c551ccea6ee56168b3123fcba00271433ab241eea1314c34ebc64d10d0cbf8e7c7b9bfcd6317da301b3717f5cd117c23de210a8e26b617d3be60
```

### `dpkg` source package: `node-inflight=1.0.6-2`

Binary Packages:

- `node-inflight=1.0.6-2`

Licenses: (parsed from: `/usr/share/doc/node-inflight/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-inflight=1.0.6-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-inflight/node-inflight_1.0.6-2.dsc' node-inflight_1.0.6-2.dsc 2089 SHA512:00066c0e5cc3b5a4f44b177bbebd44ec6c9ca46a85a42ed08e28fd4f60446b43a648c996991c58ef933182e13ec499b0aaf7c85f9b19c1a323893ef0ff376684
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-inflight/node-inflight_1.0.6.orig.tar.gz' node-inflight_1.0.6.orig.tar.gz 3019 SHA512:7252d4f1b452ac107ae1fa26ee9c144b8c519a7d64c8b81d81ba5273eaa78b108f8860048a199168061098a8c2838d21d441a811562301c92ae72b0a517645a7
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-inflight/node-inflight_1.0.6-2.debian.tar.xz' node-inflight_1.0.6-2.debian.tar.xz 2420 SHA512:1f43151c2498d92b4e5f589ecf136f1ae437e8367556f278f220c2ff8fcae0a4158f58367e1de024aea3252af110b447a241701786cd4fb083de7eaff32a9c0d
```

### `dpkg` source package: `node-inherits=2.0.4-4`

Binary Packages:

- `libjs-inherits=2.0.4-4`
- `node-inherits=2.0.4-4`

Licenses: (parsed from: `/usr/share/doc/libjs-inherits/copyright`, `/usr/share/doc/node-inherits/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-inherits=2.0.4-4
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-inherits/node-inherits_2.0.4-4.dsc' node-inherits_2.0.4-4.dsc 2175 SHA512:fdb1adf82f0f598c0210073c9996a4fe44bd07905322b1cf2ae6634f33a03d99b222f2d731acff7210af6216dbde854d9ca98c3aa319328147a5e1549a69463a
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-inherits/node-inherits_2.0.4.orig.tar.gz' node-inherits_2.0.4.orig.tar.gz 31453 SHA512:3c3cd7666f9f60d01c2e07d5ba19852787334126b7bfcd6e9aa6beef52d18e3838fb8423c44599d582eb38d836e427f8ccb2d61a0b8615ae799ffa2ae2ee7c76
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-inherits/node-inherits_2.0.4-4.debian.tar.xz' node-inherits_2.0.4-4.debian.tar.xz 3120 SHA512:071b5a1122d965341e669b45b09c8143e0e1b27d9c95c7cfb39b64c18edd899b92b467e4bd3e8b330f81bf92be7d5ffab4546bc752dafd895f4dffd3ff73882f
```

### `dpkg` source package: `node-ini=2.0.1-1`

Binary Packages:

- `node-ini=2.0.1-1`

Licenses: (parsed from: `/usr/share/doc/node-ini/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-ini=2.0.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ini/node-ini_2.0.1-1.dsc' node-ini_2.0.1-1.dsc 1983 SHA512:919f32a53c085e8d34656a1dd31f4056c87899df0e0da1a03c68ccb87bae87030a59fc50fe83a44238bd268da644dc4b35983e923f9d3a5b35f375872ae5b4e5
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ini/node-ini_2.0.1.orig.tar.gz' node-ini_2.0.1.orig.tar.gz 96731 SHA512:1667faac42fe53029723f611ff8ecf934a4cde9e9e508a5e8bf94a9407f68fa3b30115f0a588b405916b3aab4a94929cbfed64131e258ea6fee6ed8faf98616e
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ini/node-ini_2.0.1-1.debian.tar.xz' node-ini_2.0.1-1.debian.tar.xz 2844 SHA512:0483d9ecd130e05ba1330f7268b458930a05231b6e4abeff0f7bc074928f25fa1a04bc41313234b804d68c2adea32eb9ec4f0d8bf9cd4cbf31f0c4e1b227dc6e
```

### `dpkg` source package: `node-ip-regex=4.3.0+~4.1.1-1`

Binary Packages:

- `node-ip-regex=4.3.0+~4.1.1-1`

Licenses: (parsed from: `/usr/share/doc/node-ip-regex/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-ip-regex=4.3.0+~4.1.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ip-regex/node-ip-regex_4.3.0%2b%7e4.1.1-1.dsc' node-ip-regex_4.3.0+~4.1.1-1.dsc 2425 SHA512:d48cec92c344d2812ece9440bd68dea116898c6ff77cdd3a6c5160e3792875b9e6f9ac5975eefe6c6a014f9932e9f53c8f350137c8faffad6f05b2c4c0e1c8f5
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ip-regex/node-ip-regex_4.3.0%2b%7e4.1.1.orig-types-ip-regex.tar.gz' node-ip-regex_4.3.0+~4.1.1.orig-types-ip-regex.tar.gz 1105 SHA512:454115dfda7e5e82b5acee270d06176f54c04e9c952b37c8afbe47811d34ef81bfb80f51ce33ec20ae13325c61eca6785b170ce75da3d377ac3f4ead1cc64d2c
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ip-regex/node-ip-regex_4.3.0%2b%7e4.1.1.orig.tar.gz' node-ip-regex_4.3.0+~4.1.1.orig.tar.gz 5429 SHA512:fa309b4e266760fa55bd56303ddfb30d22a84fa9e63a0788a5d52bd049d076dffe90bb1586fbaf25b32f8cf35d181c0ce2f3d8981be1586ef6d0bb40287a9764
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ip-regex/node-ip-regex_4.3.0%2b%7e4.1.1-1.debian.tar.xz' node-ip-regex_4.3.0+~4.1.1-1.debian.tar.xz 3436 SHA512:ecd3e46d0e293c57e488789ddd458105b7d3f71d07f349fa750ece53ebcd2bc4dc3330880c47ce354da1fca3a9f559dcbc3901382030316beead182cebd6a911
```

### `dpkg` source package: `node-ip=1.1.5+~1.1.0-1`

Binary Packages:

- `node-ip=1.1.5+~1.1.0-1`

Licenses: (parsed from: `/usr/share/doc/node-ip/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-ip=1.1.5+~1.1.0-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ip/node-ip_1.1.5%2b%7e1.1.0-1.dsc' node-ip_1.1.5+~1.1.0-1.dsc 2299 SHA512:f2922ffde8cf78434b23b68b685a4ba2e719346d182f6ecd68e638b980f2d75e4f462e9f9a056fcf835f631a2c36a4e852d86e28a893d87a232f906e77657be4
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ip/node-ip_1.1.5%2b%7e1.1.0.orig-types-ip.tar.gz' node-ip_1.1.5+~1.1.0.orig-types-ip.tar.gz 2354 SHA512:77035ef203a817bd1574be96241c151ed426017e1131deb633e98007d1d01631b5fea8822ccfe6791cbde4f775e056016c40f00aaee3809b3cf5c1e92c1bb81d
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ip/node-ip_1.1.5%2b%7e1.1.0.orig.tar.gz' node-ip_1.1.5+~1.1.0.orig.tar.gz 9149 SHA512:c0676f35a49ba2447287b19be1fe388cbd981f1b77fd9dd9eecb964cba1bc4ac083be8267bcf3520716d814e75e6b7d13ff7443492537f6340ca11c662a5c1e5
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ip/node-ip_1.1.5%2b%7e1.1.0-1.debian.tar.xz' node-ip_1.1.5+~1.1.0-1.debian.tar.xz 4808 SHA512:a5d52417f1eec9bfc63fa16030aaf593094c4758a6ca43a4633ec025fa96b6d0ce92622884d5802f21d5b5840b1baf96d1029b8fb07b40584878527742de60d0
```

### `dpkg` source package: `node-is-typedarray=1.0.0-4`

Binary Packages:

- `libjs-is-typedarray=1.0.0-4`
- `node-is-typedarray=1.0.0-4`

Licenses: (parsed from: `/usr/share/doc/libjs-is-typedarray/copyright`, `/usr/share/doc/node-is-typedarray/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-is-typedarray=1.0.0-4
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-is-typedarray/node-is-typedarray_1.0.0-4.dsc' node-is-typedarray_1.0.0-4.dsc 2176 SHA512:c14dc2f08ebe95b56a09faab595cd12880844987953fa4cccf078d002f63671f0a0b0ccbf26ea724c00634ae1a799ccb065aadac5d00496c9df176663e4bcce6
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-is-typedarray/node-is-typedarray_1.0.0.orig.tar.gz' node-is-typedarray_1.0.0.orig.tar.gz 2019 SHA512:22d2968491824feb65fbeb43e3336958c322eccfb266c21dd282284ede7fc2c92126dfbd9ee48b7699d1afab001ab0c97795b3d8885fc104a28c3f4b79f23efe
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-is-typedarray/node-is-typedarray_1.0.0-4.debian.tar.xz' node-is-typedarray_1.0.0-4.debian.tar.xz 3352 SHA512:bd39a9710f65bf65345418e1c4ebf805d38e4fc81a5909efbbc8260857b22629f61c66678d22c0d5f8103be8d25ccd242104c910857009f7654bab0fb26be933
```

### `dpkg` source package: `node-isarray=2.0.5-3`

Binary Packages:

- `node-isarray=2.0.5-3`

Licenses: (parsed from: `/usr/share/doc/node-isarray/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-isarray=2.0.5-3
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-isarray/node-isarray_2.0.5-3.dsc' node-isarray_2.0.5-3.dsc 2086 SHA512:c2879f7b676f90d82ca1ef199323e596ef20d1cbc4f386f838d03d937e42b3535bf7bc641c8627168386bc6b7749d164e087231c87c0dac5225914b190f3fe32
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-isarray/node-isarray_2.0.5.orig.tar.gz' node-isarray_2.0.5.orig.tar.gz 3366 SHA512:0a85f3e65b1435e63c02d9bd4258eb46d7b39dfdd98822e67a3bffd775fa2eb91035c47c03c5c0963d5990707a33d6c87f8bfd6c6e4be64bfa99f0702bfa2026
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-isarray/node-isarray_2.0.5-3.debian.tar.xz' node-isarray_2.0.5-3.debian.tar.xz 2784 SHA512:7c275ad1799542660733e19894264d824a62036ec9a92078408ab03a932bf567ea996c4d26e00afe553554d5d9547b73ce1cc9677a63bba1b4dce48dd757c934
```

### `dpkg` source package: `node-isexe=2.0.0+~2.0.1-4`

Binary Packages:

- `node-isexe=2.0.0+~2.0.1-4`

Licenses: (parsed from: `/usr/share/doc/node-isexe/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-isexe=2.0.0+~2.0.1-4
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-isexe/node-isexe_2.0.0%2b%7e2.0.1-4.dsc' node-isexe_2.0.0+~2.0.1-4.dsc 2405 SHA512:8a1ac55f3acf66a09ec53b6e1a094e9085475d97abc322998124fabf47305f1d315c0bfd05941340ba4523a7b7ea8a371d608080062d4591d8b93f247b0dd53e
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-isexe/node-isexe_2.0.0%2b%7e2.0.1.orig-types-isexe.tar.gz' node-isexe_2.0.0+~2.0.1.orig-types-isexe.tar.gz 1765 SHA512:95e31bf9bd9f3a8d6cecdb0254642bd3bff35c8fc236876f84713720c8b3856573a0dffcfa049dcaa968fd25b12ffcc4a15718755e85f3f4591e0e479bec2b7f
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-isexe/node-isexe_2.0.0%2b%7e2.0.1.orig.tar.gz' node-isexe_2.0.0+~2.0.1.orig.tar.gz 3862 SHA512:f158d27b1ad72f4b01fe2b8a22dc4295d0c65303ce2590652e016606dd30b6e0643374afa08372b0e4ff7c22fd33198ede7179e981229bfc3fa0045e99570a15
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-isexe/node-isexe_2.0.0%2b%7e2.0.1-4.debian.tar.xz' node-isexe_2.0.0+~2.0.1-4.debian.tar.xz 3716 SHA512:ad518072da3b5ba6b522d918829e46f9071a7c28ca507bd60ffd8eabddff024def22ce1bc1590f00b83d04ee518a14b4058b6d9885c073fd48c86acae7c0f2c1
```

### `dpkg` source package: `node-jquery=3.6.0+dfsg+~3.5.13-1`

Binary Packages:

- `libjs-jquery=3.6.0+dfsg+~3.5.13-1`

Licenses: (parsed from: `/usr/share/doc/libjs-jquery/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-jquery=3.6.0+dfsg+~3.5.13-1
'http://archive.ubuntu.com/ubuntu/pool/main/n/node-jquery/node-jquery_3.6.0%2bdfsg%2b%7e3.5.13-1.dsc' node-jquery_3.6.0+dfsg+~3.5.13-1.dsc 2699 SHA512:44656f0d8cc8a3bc6ea06bbf8d55bf2a2fc4220ba39e170f4a80af49ee93910a5cc03fb355303c4f537d08bbcad857e5fb6e7946bffc684c2d5d5e63f23d1a70
'http://archive.ubuntu.com/ubuntu/pool/main/n/node-jquery/node-jquery_3.6.0%2bdfsg%2b%7e3.5.13.orig-types-jquery.tar.xz' node-jquery_3.6.0+dfsg+~3.5.13.orig-types-jquery.tar.xz 84372 SHA512:4abd8cc14201ec607cc7af01147944ea18c8b125e01efa34d4ca817ed0232b2eaf6a8edb8a1a511e4d8c447d75bb566dad005391cfdc963b903143906e42388c
'http://archive.ubuntu.com/ubuntu/pool/main/n/node-jquery/node-jquery_3.6.0%2bdfsg%2b%7e3.5.13.orig.tar.xz' node-jquery_3.6.0+dfsg+~3.5.13.orig.tar.xz 296988 SHA512:9ae8e2e726d88915de2e33530e60af4e33a9a48e9bc584fd490d8898af8260c13ba058d28375163fcbd46b96caa3e1f9bca8e4404c5b70166daed3afd440afc7
'http://archive.ubuntu.com/ubuntu/pool/main/n/node-jquery/node-jquery_3.6.0%2bdfsg%2b%7e3.5.13-1.debian.tar.xz' node-jquery_3.6.0+dfsg+~3.5.13-1.debian.tar.xz 6328 SHA512:48c5c5c31f6dbf6e20d3ac0b1c7d7ff2e63a2396d7288806b1c698261e7173219173ec410d34883c63ec17fe48c71872633bb6f9d50cf408a0cbaf3d8a5d54db
```

### `dpkg` source package: `node-json-buffer=3.0.1-1`

Binary Packages:

- `node-json-buffer=3.0.1-1`

Licenses: (parsed from: `/usr/share/doc/node-json-buffer/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-json-buffer=3.0.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-json-buffer/node-json-buffer_3.0.1-1.dsc' node-json-buffer_3.0.1-1.dsc 2088 SHA512:1d3d02fb9fced79c0e62ae2678f16c8c96b82f3d9244be0bd59d7eda341ac08a38745cdba0833ed38d972c008aece72667d5021483d1614acce064fd98bcfd8d
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-json-buffer/node-json-buffer_3.0.1.orig.tar.gz' node-json-buffer_3.0.1.orig.tar.gz 2774 SHA512:fba5ddb1c1c4cfc49d20c35d846c3d9f806965351dfdc7b1ee749d817fef85c44c752f2f8ac966b33205369c05b8bceb0b1ad90d07d4b4f6ae2764d4598b1d9e
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-json-buffer/node-json-buffer_3.0.1-1.debian.tar.xz' node-json-buffer_3.0.1-1.debian.tar.xz 2376 SHA512:0eaae988c8e0ec9363597eaf9e46b5f5e5c9d3918ec7037ecfa231489725b7a889c63b8659816a81b990a1e7719d93b1f4bfc54b235242ffee15cd56087b90d7
```

### `dpkg` source package: `node-json-parse-better-errors=1.0.2+~cs3.3.1-1`

Binary Packages:

- `node-json-parse-better-errors=1.0.2+~cs3.3.1-1`

Licenses: (parsed from: `/usr/share/doc/node-json-parse-better-errors/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-json-parse-better-errors=1.0.2+~cs3.3.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-json-parse-better-errors/node-json-parse-better-errors_1.0.2%2b%7ecs3.3.1-1.dsc' node-json-parse-better-errors_1.0.2+~cs3.3.1-1.dsc 3145 SHA512:5b5682c08d066c27643d207c1d7a33377c622cbf05efde423173c212ffc75051f3931dfde448b0d866337cbfd3fb267c71d46844eefdd6d56c29d1b5dbb0f9b8
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-json-parse-better-errors/node-json-parse-better-errors_1.0.2%2b%7ecs3.3.1.orig-json-parse-even-better-errors.tar.gz' node-json-parse-better-errors_1.0.2+~cs3.3.1.orig-json-parse-even-better-errors.tar.gz 34553 SHA512:e56a16751bdc10d7fb10cb2e30ceb13e73c26a630fab4158ef98abbce4d42a77ef1223d613ea13816d508ee2348b4271f68cf1bb0f23f25d26a9c93febd7095a
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-json-parse-better-errors/node-json-parse-better-errors_1.0.2%2b%7ecs3.3.1.orig-types-json-parse-better-errors.tar.gz' node-json-parse-better-errors_1.0.2+~cs3.3.1.orig-types-json-parse-better-errors.tar.gz 1766 SHA512:240b065c432c8b0dadb4dae569dcbf67ccedad2125d72f08a06f607bb869050e08fa294ac5e94e3c62a7566b7d4d7ebd9645dd262a03582933924b5671d02c84
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-json-parse-better-errors/node-json-parse-better-errors_1.0.2%2b%7ecs3.3.1.orig.tar.gz' node-json-parse-better-errors_1.0.2+~cs3.3.1.orig.tar.gz 38358 SHA512:4e073e386ad74954d6c41642ac91093230c929f11ae7e3b874e2ab00b59a26aa67b417f1d3a3aaf74b213f30b43320a1d3140f8f89d17de62cc835c7e3f191ca
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-json-parse-better-errors/node-json-parse-better-errors_1.0.2%2b%7ecs3.3.1-1.debian.tar.xz' node-json-parse-better-errors_1.0.2+~cs3.3.1-1.debian.tar.xz 3260 SHA512:a0da81ae0a4eadaf8e60ccc5fec012e9660a0fff4a195beb7d589d9fd27023ea54a79885e029b268504d67bf7013febff359b5c2d48ee5938a48087bd4bcaa05
```

### `dpkg` source package: `node-jsonparse=1.3.1-10`

Binary Packages:

- `node-jsonparse=1.3.1-10`

Licenses: (parsed from: `/usr/share/doc/node-jsonparse/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-jsonparse=1.3.1-10
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-jsonparse/node-jsonparse_1.3.1-10.dsc' node-jsonparse_1.3.1-10.dsc 2066 SHA512:2a92069b1487e76bdc0c2c0f422dddfa7aab8d76f448add589ca9b8e6a4684b7fbb802a3180985a2070c02a4c444efaf39b5dbf2194cdca96f3c70cdfa304dc0
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-jsonparse/node-jsonparse_1.3.1.orig.tar.gz' node-jsonparse_1.3.1.orig.tar.gz 8721 SHA512:48c3fec3a2471c439d3bc9941f7a4b32a2110791eb550c166e8af5d122eedb04a1f606da31df9cc8f4cd985b771b450fff26ddedad47ddad3cf02242e3df1bd0
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-jsonparse/node-jsonparse_1.3.1-10.debian.tar.xz' node-jsonparse_1.3.1-10.debian.tar.xz 4756 SHA512:ef44cd46a71fbd907d8a96d1beade2c8289fb1cf035ed5101e884cc91e379b72d9fdd7a2d23265aff062d5f1888b47e2acf7578cba794325f8fd0644021907e7
```

### `dpkg` source package: `node-lowercase-keys=2.0.0-2`

Binary Packages:

- `node-lowercase-keys=2.0.0-2`

Licenses: (parsed from: `/usr/share/doc/node-lowercase-keys/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-lowercase-keys=2.0.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-lowercase-keys/node-lowercase-keys_2.0.0-2.dsc' node-lowercase-keys_2.0.0-2.dsc 2132 SHA512:b5f0f936f4b7dfad2a5200c9e43b7ba9268b7901f36668ec8281714f54d15f24fd2d5cf17a9b985f11d1b7f696bb6951410d07252c139cbf8a34b49abfed83a6
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-lowercase-keys/node-lowercase-keys_2.0.0.orig.tar.gz' node-lowercase-keys_2.0.0.orig.tar.gz 2233 SHA512:d46a481dd2cb80383decb856afe1303d183b8a9c4322f6f87ce185942e3510f5c6b901afebb346037fa96b2cd1db8b6fbe65cd9c31d82c24adc802b58ba94e7a
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-lowercase-keys/node-lowercase-keys_2.0.0-2.debian.tar.xz' node-lowercase-keys_2.0.0-2.debian.tar.xz 3012 SHA512:2a8898a981665bc4896ceb964663afbc998a9cf33820f18db4a70dab781a5c8f486129677e9b30e37851f822be92940546c0470501d13932937555de9f22c847
```

### `dpkg` source package: `node-lru-cache=6.0.0+~5.1.1-1`

Binary Packages:

- `node-lru-cache=6.0.0+~5.1.1-1`

Licenses: (parsed from: `/usr/share/doc/node-lru-cache/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-lru-cache=6.0.0+~5.1.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-lru-cache/node-lru-cache_6.0.0%2b%7e5.1.1-1.dsc' node-lru-cache_6.0.0+~5.1.1-1.dsc 2459 SHA512:257ae1cb4bb034c606f85460f0680aca725519c3688957eae138f04ad0c551fc5e1a2c027c2de25e7c67bea89d67c5254fceae4c2023a1798f10e07915ac7762
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-lru-cache/node-lru-cache_6.0.0%2b%7e5.1.1.orig-types-lru-cache.tar.gz' node-lru-cache_6.0.0+~5.1.1.orig-types-lru-cache.tar.gz 3688 SHA512:b2c137565af2b3bb1d233b392cec42cd354cb14ee2f686bf21a5bddb0177d8915bdc255ccea3a4aeedb1b29b8a7331c46c6de7be63d8ec816a5661861dd35b63
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-lru-cache/node-lru-cache_6.0.0%2b%7e5.1.1.orig.tar.gz' node-lru-cache_6.0.0+~5.1.1.orig.tar.gz 37579 SHA512:9fd0b36058aadec81c84e473edf2238599b882bdab626f5f88ac2497dbc2c4aa0e93600a4b28b1ec8907147dc3d8c717e3fce6970f1fbee217065ef8cc66b959
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-lru-cache/node-lru-cache_6.0.0%2b%7e5.1.1-1.debian.tar.xz' node-lru-cache_6.0.0+~5.1.1-1.debian.tar.xz 4560 SHA512:33bde10438574d32d69a42e17dce43d262df4848afcf712408aaa487aa61ef7a3c2ffb5a518a3aee3c1f5ffc9b1a283c95a26989dd9f92a63466cb73edeafe49
```

### `dpkg` source package: `node-mimic-response=3.1.0-7`

Binary Packages:

- `node-mimic-response=3.1.0-7`

Licenses: (parsed from: `/usr/share/doc/node-mimic-response/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-mimic-response=3.1.0-7
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-mimic-response/node-mimic-response_3.1.0-7.dsc' node-mimic-response_3.1.0-7.dsc 2223 SHA512:ebfd180f530a4e260765fc70b9249a7cdf975b27384da78833ddfd366f5cf22a20e7b189bb0d46f3401aa2dbab273629c150da678ce0212c56801bc527fbe8de
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-mimic-response/node-mimic-response_3.1.0.orig.tar.gz' node-mimic-response_3.1.0.orig.tar.gz 4393 SHA512:8e44643fbad22e4a8a148efed91755256e16a2d6bee84d8334cd05ce1150ab34acadbd02531d753ea80c5b16cde24dd19857c5435c5611ae850fa123407ba2cb
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-mimic-response/node-mimic-response_3.1.0-7.debian.tar.xz' node-mimic-response_3.1.0-7.debian.tar.xz 26632 SHA512:aa3313870a1e34f1d1f0d81bdd38bedad8353ce285e221eab51f27f0a1c4f7aa6fd0483df5cea07f45112f625987e0c8d2958d3845b6d3858738a728c3217d29
```

### `dpkg` source package: `node-minimatch=3.1.1+~3.0.5-1`

Binary Packages:

- `node-minimatch=3.1.1+~3.0.5-1`

Licenses: (parsed from: `/usr/share/doc/node-minimatch/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-minimatch=3.1.1+~3.0.5-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-minimatch/node-minimatch_3.1.1%2b%7e3.0.5-1.dsc' node-minimatch_3.1.1+~3.0.5-1.dsc 2462 SHA512:5c9919f1ff8b272bc9e1e15fc55e00052a40b63ed95b3065c97c165667c70f3fd483e0cc7f0dea3f34a2f167b58020d5c103c10c4fca71a39b2290444ccc20db
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-minimatch/node-minimatch_3.1.1%2b%7e3.0.5.orig-types-minimatch.tar.gz' node-minimatch_3.1.1+~3.0.5.orig-types-minimatch.tar.gz 2945 SHA512:2a5cfde3d874d86cf6b9908c1b00d44834b56019537430e06d61e2fbcd65dbdb5000b52dbf3e2b0188b9ba85611392da828aba0dea805256eb1ef5bf9970e075
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-minimatch/node-minimatch_3.1.1%2b%7e3.0.5.orig.tar.gz' node-minimatch_3.1.1+~3.0.5.orig.tar.gz 76456 SHA512:2c6cfbedd82723c2d20f8edc950c68b9c0b402bc267a9c5639b3122cd1f62d51dbf7b3e01fe68883424beb934daee182ab3865bea1f3f29ab638658a7ece9d9f
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-minimatch/node-minimatch_3.1.1%2b%7e3.0.5-1.debian.tar.xz' node-minimatch_3.1.1+~3.0.5-1.debian.tar.xz 4120 SHA512:a6ee89c4d1e0df2ef8c8ebc36de04a517945330b6ac9c440d980d61f06e7a4d739a9d0859ef8995cdd9a4164b933bdb26ea54cf3a87408322160057c2e83b236
```

### `dpkg` source package: `node-minipass=3.1.6+~cs8.7.18-1`

Binary Packages:

- `node-minipass=3.1.6+~cs8.7.18-1`

Licenses: (parsed from: `/usr/share/doc/node-minipass/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-minipass=3.1.6+~cs8.7.18-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-minipass/node-minipass_3.1.6%2b%7ecs8.7.18-1.dsc' node-minipass_3.1.6+~cs8.7.18-1.dsc 4585 SHA512:d53a975a9125e205cd03154730a75b5b990006f59009ec143332c67a2c26df738b17e574ced678cc001698863574a148d847f42806b4f5ce5a3f8855a0937589
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-minipass/node-minipass_3.1.6%2b%7ecs8.7.18.orig-minipass-collect.tar.gz' node-minipass_3.1.6+~cs8.7.18.orig-minipass-collect.tar.gz 2057 SHA512:e93ea51f41fc386f642139bf266ead768a086e8806f5ed2d2e0a58ea6a615d29bf03dbbc36ad6bc811be42ca62b9bf4b8d69413ec3d2ded590fc1a2dab815dc4
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-minipass/node-minipass_3.1.6%2b%7ecs8.7.18.orig-minipass-fetch.tar.gz' node-minipass_3.1.6+~cs8.7.18.orig-minipass-fetch.tar.gz 102265 SHA512:b1fa3e6a5fda5999928f4e0b1bbd58d6e5328a75fd455eed181e4cf59b4458ab211e3a77914ba759850c4282fd7e7e7142ae0226f50fb577977e0b3a63742e95
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-minipass/node-minipass_3.1.6%2b%7ecs8.7.18.orig-minipass-flush.tar.gz' node-minipass_3.1.6+~cs8.7.18.orig-minipass-flush.tar.gz 30652 SHA512:32fa3a692bd0cbc9ef2d0828e66cefb9f1b326ac891ca98945622fd5e95368d0bb67316eebd80b2f3a6ca6b0ae85531d546e488ce49498f37ee2af4eabc34ee8
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-minipass/node-minipass_3.1.6%2b%7ecs8.7.18.orig-minipass-json-stream.tar.gz' node-minipass_3.1.6+~cs8.7.18.orig-minipass-json-stream.tar.gz 4944 SHA512:383a98d7c519b7f23c93e6fbae5d8010d81b584f080d86a6fae9dd20938dbe2800cfc291e4659b96c15311f42cd16383b236d25d6966f891c4bfc1abe937dd6e
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-minipass/node-minipass_3.1.6%2b%7ecs8.7.18.orig-minipass-pipeline.tar.gz' node-minipass_3.1.6+~cs8.7.18.orig-minipass-pipeline.tar.gz 3001 SHA512:c6e22aedc20eb74f513d1275f60762e1bf9188dbc31587b9247fa080dbc1a86aa941772bbb73dc466399b8704a58ad53c5ff7e710f8731537877acf8e8b64fec
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-minipass/node-minipass_3.1.6%2b%7ecs8.7.18.orig-minipass-sized.tar.gz' node-minipass_3.1.6+~cs8.7.18.orig-minipass-sized.tar.gz 30885 SHA512:9e6447f3b7b37de94d17a8a805527ba46f85af9c80c7340f0044db9fe5c8f1123ebb88a23f3632ac2853358a717fb0d2a75dfc6e6459d33713b983ea47ad0272
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-minipass/node-minipass_3.1.6%2b%7ecs8.7.18.orig-minizlib.tar.gz' node-minipass_3.1.6+~cs8.7.18.orig-minizlib.tar.gz 187148 SHA512:ee0938cd24c8090f9e9df9a4ba7f4ab48c16b2507923824b8b803bbb74cc64ce4ceb8fc326f9760edebedf900e58f3ce614d727a51b66ec405f342fe2342fb4d
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-minipass/node-minipass_3.1.6%2b%7ecs8.7.18.orig.tar.gz' node-minipass_3.1.6+~cs8.7.18.orig.tar.gz 85094 SHA512:1ef237d5d9fbf23ef68f4644ecf39a5d49ae78cf8af36543c6bf1f98c5d98438b768b910874334a6526d06b4845c330516f4a178ef8deb4d3678fad9b5815248
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-minipass/node-minipass_3.1.6%2b%7ecs8.7.18-1.debian.tar.xz' node-minipass_3.1.6+~cs8.7.18-1.debian.tar.xz 3660 SHA512:17e227d190db11ca4da44e08c90fad6bd9242d3d271aab55b07a6ffd0add6b84934ef6769b08c9754a591f46d29bdcec7546a8b64833157cbddd63f0373b72d1
```

### `dpkg` source package: `node-mkdirp=1.0.4+~1.0.2-1`

Binary Packages:

- `node-mkdirp=1.0.4+~1.0.2-1`

Licenses: (parsed from: `/usr/share/doc/node-mkdirp/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-mkdirp=1.0.4+~1.0.2-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-mkdirp/node-mkdirp_1.0.4%2b%7e1.0.2-1.dsc' node-mkdirp_1.0.4+~1.0.2-1.dsc 2446 SHA512:750696107ef46384553e7b2f0be5efe691d34365f7ac6f80dde7916771a9c61921e83069980c506a21ea95685e34f161ae04f1dd803ef79545ef2615f05bebd8
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-mkdirp/node-mkdirp_1.0.4%2b%7e1.0.2.orig-types-mkdirp.tar.gz' node-mkdirp_1.0.4+~1.0.2.orig-types-mkdirp.tar.gz 2531 SHA512:a342b5b523b40f1e57eb1954e45d43ebadb915ac210b7754de2aabdb9965b8dbfffbf408547f112cd122568920219a3e9b3fbcef0ff732483f56f412f89e757d
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-mkdirp/node-mkdirp_1.0.4%2b%7e1.0.2.orig.tar.gz' node-mkdirp_1.0.4+~1.0.2.orig.tar.gz 38981 SHA512:236203c95283dbe333d74e9522cde5af2c0c49fef207d23a80ef8b83f00c57ecb0a67bcc06c57f164e3d147293d7741df896d41d90f01a88bfb559d3dcbbff4c
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-mkdirp/node-mkdirp_1.0.4%2b%7e1.0.2-1.debian.tar.xz' node-mkdirp_1.0.4+~1.0.2-1.debian.tar.xz 4760 SHA512:4a06f9c6b3fa62d5bb05fe0abc6996ed09873badaf8ed43311a492e7fc8f690ee20a00c8bc523f40334ffd5de81507c9a99ada36943f8588c7f6b8a166f0b9ab
```

### `dpkg` source package: `node-move-concurrently=1.0.1-4`

Binary Packages:

- `node-move-concurrently=1.0.1-4`

Licenses: (parsed from: `/usr/share/doc/node-move-concurrently/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-move-concurrently=1.0.1-4
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-move-concurrently/node-move-concurrently_1.0.1-4.dsc' node-move-concurrently_1.0.1-4.dsc 2352 SHA512:aa75735182e7d82b0a5fd2a415fd6bbacd58c8cc2117170aa15616ccfb0f041586c4137511b0c4f88c13fecee35edac99d10aa3b6b9f788ee2408d7f45573077
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-move-concurrently/node-move-concurrently_1.0.1.orig.tar.gz' node-move-concurrently_1.0.1.orig.tar.gz 4843 SHA512:6579f6db1ebb09b55a8a3ed673264b5da987022d9b6a690ce89a6a67b2c8e0a836e4074a02b2450dec0f1c7acd87e398882cecebba20160e9208427293c1dfe6
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-move-concurrently/node-move-concurrently_1.0.1-4.debian.tar.xz' node-move-concurrently_1.0.1-4.debian.tar.xz 2744 SHA512:2e78118c33e76288a2cf14a03875bf05e2dd9568159433fe65f4171c36661ecb3d988f8a9eeb86fe530ee7cbba1bb8ceaea26d308e32b28ae87a710005120f97
```

### `dpkg` source package: `node-ms=2.1.3+~cs0.7.31-2`

Binary Packages:

- `node-ms=2.1.3+~cs0.7.31-2`

Licenses: (parsed from: `/usr/share/doc/node-ms/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-ms=2.1.3+~cs0.7.31-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ms/node-ms_2.1.3%2b%7ecs0.7.31-2.dsc' node-ms_2.1.3+~cs0.7.31-2.dsc 2378 SHA512:116764e365070425746d6502164133243d8e5926074c49053fab88e0e04451dad4bc168dab7317c5dc4c348f4b751579aeb0de5e9f9339930fce67e1f5b96558
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ms/node-ms_2.1.3%2b%7ecs0.7.31.orig-typesms.tar.gz' node-ms_2.1.3+~cs0.7.31.orig-typesms.tar.gz 1612 SHA512:8a25202b357d02e684919aa438b0c8be54222fa96db9977db46716de0c299d7f096ee8ae8459441a69855c45e4379d02beaeceb3cf08636bf47640ea5d859580
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ms/node-ms_2.1.3%2b%7ecs0.7.31.orig.tar.gz' node-ms_2.1.3+~cs0.7.31.orig.tar.gz 20310 SHA512:372daa086c6f3afe8cefef52e04b50eddb95d4510ae4bad074f32870344bcf488242cc0e2dd9b38b955fbeaf40f252fbc9e3950bb37b29767ec5b8504d7041c8
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ms/node-ms_2.1.3%2b%7ecs0.7.31-2.debian.tar.xz' node-ms_2.1.3+~cs0.7.31-2.debian.tar.xz 3004 SHA512:9ceb2ebe209973aba682caef9c88bbccfba6081e9e62b14bef887cedd19651d4ab117d6d38b8912c1f22cf45dd713940b87f240a9b082f082c968a58c2008d85
```

### `dpkg` source package: `node-mute-stream=0.0.8+~0.0.1-1`

Binary Packages:

- `node-mute-stream=0.0.8+~0.0.1-1`

Licenses: (parsed from: `/usr/share/doc/node-mute-stream/copyright`)

- `Expat`
- `GPL-3`
- `GPL-3.0+`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-mute-stream=0.0.8+~0.0.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-mute-stream/node-mute-stream_0.0.8%2b%7e0.0.1-1.dsc' node-mute-stream_0.0.8+~0.0.1-1.dsc 2465 SHA512:aebdc3558206ee107b0a8fc4fd73581a46c14441dfe210bfa31463c8189c0584ec697446ac5f524d4e5893eb8361a847347b169fc64db1f996cdc907036f87ff
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-mute-stream/node-mute-stream_0.0.8%2b%7e0.0.1.orig-types-mute-stream.tar.gz' node-mute-stream_0.0.8+~0.0.1.orig-types-mute-stream.tar.gz 1968 SHA512:d3240bcd8842a86cfb0903c4de20e662385beca30114e3feb41932c3efd8d98c83239c294bb8ad5d7c6778dd734ac5305b1dc98ba622558ae1027a50192fef93
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-mute-stream/node-mute-stream_0.0.8%2b%7e0.0.1.orig.tar.gz' node-mute-stream_0.0.8+~0.0.1.orig.tar.gz 20686 SHA512:7fc0d467f166f7bb44e19e92858f8afbcd11d457ef48ebac6cf72388858908e2f605fa2c668374e87d3b4316f33379dc92e7fe974d9390b5036202faab1764fc
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-mute-stream/node-mute-stream_0.0.8%2b%7e0.0.1-1.debian.tar.xz' node-mute-stream_0.0.8+~0.0.1-1.debian.tar.xz 3628 SHA512:e843464aa5b012b744baaa241f2605a4b248141beebb3f4b7141b584bf26fc8cabc0b4114f8f51d6c8eb03a4447046daed80dd4e3df24548e282cf9b84289742
```

### `dpkg` source package: `node-negotiator=0.6.2+~0.6.1-1`

Binary Packages:

- `node-negotiator=0.6.2+~0.6.1-1`

Licenses: (parsed from: `/usr/share/doc/node-negotiator/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-negotiator=0.6.2+~0.6.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-negotiator/node-negotiator_0.6.2%2b%7e0.6.1-1.dsc' node-negotiator_0.6.2+~0.6.1-1.dsc 2448 SHA512:b3f9e0603ceac9b6de3fc77353c8158c9bb4b65ab29ca5354b9ac9632708423fd48769b97f363a6b6f459577365c41f2bcaaec9da455f281c833b64f491d081c
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-negotiator/node-negotiator_0.6.2%2b%7e0.6.1.orig-types-negotiator.tar.gz' node-negotiator_0.6.2+~0.6.1.orig-types-negotiator.tar.gz 1908 SHA512:7389af5c50728217b343f79518de47bc7fe323adef9b707b16213cd415330c05a6ba2a2145e7023ba75d53ad1d7eadbda0a50c890ba3b280768742500bb24728
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-negotiator/node-negotiator_0.6.2%2b%7e0.6.1.orig.tar.gz' node-negotiator_0.6.2+~0.6.1.orig.tar.gz 13485 SHA512:c72b7a42cd1d3f8e9586f6a28f9827b872858af4959f2f6cc4a99657013be00155566f45c013d4da11a28011ccf4ff64f3c01416499754837745c18b9e3a506a
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-negotiator/node-negotiator_0.6.2%2b%7e0.6.1-1.debian.tar.xz' node-negotiator_0.6.2+~0.6.1-1.debian.tar.xz 3156 SHA512:c9bedc0db83e31fb2b5e1797e29bba143193d24d37fb7f9905341221ad0374381f9ac8d1c9f70ca78194178b4ce064cde90792dc7f2b1b6d88670f39434348c5
```

### `dpkg` source package: `node-nopt=5.0.0-2`

Binary Packages:

- `node-nopt=5.0.0-2`

Licenses: (parsed from: `/usr/share/doc/node-nopt/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-nopt=5.0.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-nopt/node-nopt_5.0.0-2.dsc' node-nopt_5.0.0-2.dsc 2019 SHA512:e86b6c370a8f6fd28e612e1177f303e6dda9adcbd0830e4aa275fe15dae2542c0470a16dfe176193d446e89f604c43f171af38460a86d0061552e1faa3e1a61a
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-nopt/node-nopt_5.0.0.orig.tar.gz' node-nopt_5.0.0.orig.tar.gz 51293 SHA512:8c7ab02c22f389b4e3a0c8025e27dd6d63e8d54285e958b39fe35700390fd59b7f5d3dc7b863b703662197a0ab3d667fc6cb78b5e8d4ed12dfa77dc16c985d15
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-nopt/node-nopt_5.0.0-2.debian.tar.xz' node-nopt_5.0.0-2.debian.tar.xz 2968 SHA512:9c95ad55f80ebb8c5d254ea94580ce05640d5d9d94a6a1fd2a20fa0ee42c4d0495bf8807466322476d3f1ddbe77e8be633a477d3b51a7387f9d39188ac42e322
```

### `dpkg` source package: `node-normalize-package-data=3.0.3+~2.4.1-1`

Binary Packages:

- `node-normalize-package-data=3.0.3+~2.4.1-1`

Licenses: (parsed from: `/usr/share/doc/node-normalize-package-data/copyright`)

- `BSD-2-clause`
- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-normalize-package-data=3.0.3+~2.4.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-normalize-package-data/node-normalize-package-data_3.0.3%2b%7e2.4.1-1.dsc' node-normalize-package-data_3.0.3+~2.4.1-1.dsc 2864 SHA512:c75d5607fc923ce5448af92b279113b48f0b75919c512db029264c28b76c222a459e01d9770dbe0d2e6b04e6a74996e547e941ae90fccc2d02fb770f92de5a99
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-normalize-package-data/node-normalize-package-data_3.0.3%2b%7e2.4.1.orig-types-normalize-package-data.tar.gz' node-normalize-package-data_3.0.3+~2.4.1.orig-types-normalize-package-data.tar.gz 1872 SHA512:1a3edc23bcfef7c336f364ea9a9d8ae4422ca28b941336c1261410cc31378d221193aafd82ccf4a14a24a88511e2ed51ddd307a34a431cceec34e1f286e972a7
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-normalize-package-data/node-normalize-package-data_3.0.3%2b%7e2.4.1.orig.tar.gz' node-normalize-package-data_3.0.3+~2.4.1.orig.tar.gz 106306 SHA512:db81cf72e930ff95e8d7235e3bac1ea16fddc492f4b017f012d3ee1c5176cf6b6a813268ffaedb94e18038c957571506973bb8c92dc319626bbcd4cdc576c149
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-normalize-package-data/node-normalize-package-data_3.0.3%2b%7e2.4.1-1.debian.tar.xz' node-normalize-package-data_3.0.3+~2.4.1-1.debian.tar.xz 3772 SHA512:5a80b9e4999d96356e0ab31edad085e8a5487144f2682ac9040bd32f27cc43692217fbdb0879d452c42d34cb41921e5b0bc635104c99c983032a2060456b4936
```

### `dpkg` source package: `node-npm-bundled=1.1.2-1`

Binary Packages:

- `node-npm-bundled=1.1.2-1`

Licenses: (parsed from: `/usr/share/doc/node-npm-bundled/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-npm-bundled=1.1.2-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-npm-bundled/node-npm-bundled_1.1.2-1.dsc' node-npm-bundled_1.1.2-1.dsc 2442 SHA512:4ff5f19a120e168c24e2f79f23cdb9b3c9b134e39d18a68bbc3cddcf4b5d0b2af66f89a993551b22773b0fd49b829167b5cc77efacd9b46d290902308c6c6882
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-npm-bundled/node-npm-bundled_1.1.2.orig-npm-normalize-package-bin.tar.gz' node-npm-bundled_1.1.2.orig-npm-normalize-package-bin.tar.gz 31250 SHA512:3ccb0e3b006e00ae464b65e497d73772628f3a87340da7f46d7bdb144cb765f99d3fc9faa2912daf0b60cd209b7041e7cab6cdc973d642bbecb5e4556c2badc9
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-npm-bundled/node-npm-bundled_1.1.2.orig.tar.gz' node-npm-bundled_1.1.2.orig.tar.gz 22037 SHA512:b7cabe191b2c485618c12aacf6facbce0c3164b0cdbd72bb09d308eaf5924714f6818a8b1fcf34094e433efb6ab13913491981db0f0e36a8dc235b5c72317200
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-npm-bundled/node-npm-bundled_1.1.2-1.debian.tar.xz' node-npm-bundled_1.1.2-1.debian.tar.xz 2424 SHA512:71b9438943cb1e12b08d1f682232d1463db9dbb86e10dbad405ee6ce61ed45e083ae9f17f5da59af38a297e4afa24d34342160a56151d5f580f0b330dc187ece
```

### `dpkg` source package: `node-npm-package-arg=8.1.5-1`

Binary Packages:

- `node-npm-package-arg=8.1.5-1`

Licenses: (parsed from: `/usr/share/doc/node-npm-package-arg/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-npm-package-arg=8.1.5-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-npm-package-arg/node-npm-package-arg_8.1.5-1.dsc' node-npm-package-arg_8.1.5-1.dsc 2265 SHA512:427e324389a9052d3b3c37ea7c32ea67df1456992786b94287bb11999cc5cc6dd334a2cd300803386161085ac8e0877a22d9af9a2a16c80897ff84cd52e57e57
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-npm-package-arg/node-npm-package-arg_8.1.5.orig.tar.gz' node-npm-package-arg_8.1.5.orig.tar.gz 103149 SHA512:4e773e6d2396ed498942739a079031f929d0ac8625d80544533e55d42b495b736d6e3316bde53c6a1041deb545ac52ee0ebc741aab5968906db380542c0c13d4
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-npm-package-arg/node-npm-package-arg_8.1.5-1.debian.tar.xz' node-npm-package-arg_8.1.5-1.debian.tar.xz 2576 SHA512:2bd5f43e5ccd76df151f04f1c72e287275ddbf1e898d6f355538f78e017676aceee7382d91ae06a49789f757f42e357dc278e476ec0fb3468f815d22fd2df286
```

### `dpkg` source package: `node-npmlog=6.0.1+~4.1.4-1`

Binary Packages:

- `node-npmlog=6.0.1+~4.1.4-1`

Licenses: (parsed from: `/usr/share/doc/node-npmlog/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-npmlog=6.0.1+~4.1.4-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-npmlog/node-npmlog_6.0.1%2b%7e4.1.4-1.dsc' node-npmlog_6.0.1+~4.1.4-1.dsc 2507 SHA512:6884768992f6d30670677bc64490d852f4914fd4aa75a8e4fda564d9e01d5d891570214731e1fa98bc2ede6346e8f4f80c739974a9e9d9a5d0b53fa40693d734
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-npmlog/node-npmlog_6.0.1%2b%7e4.1.4.orig-types-npmlog.tar.gz' node-npmlog_6.0.1+~4.1.4.orig-types-npmlog.tar.gz 2157 SHA512:58a1b8813afca6bcc4641889e6bdecf19200a0c5cd6ce810fa3fdde4ee17df1ea464944b36fc9426e50afcaa06dfef0168e1cf869da6ed60ba24a29ea2f0d2cd
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-npmlog/node-npmlog_6.0.1%2b%7e4.1.4.orig.tar.gz' node-npmlog_6.0.1+~4.1.4.orig.tar.gz 14156 SHA512:ce51fe0a1c9a38a760f6fa14418592f8beb5d7683c4834ccbb285f7a73e609c58bda8ab8404e04f2c08950f7c9befc54b219232868da4520e60e5d0c3bf82e91
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-npmlog/node-npmlog_6.0.1%2b%7e4.1.4-1.debian.tar.xz' node-npmlog_6.0.1+~4.1.4-1.debian.tar.xz 3252 SHA512:151effcffb66cd0500f7a833645e4c7f0d3dc2ef6d2a915997806e2511abef750794a45bd58f43f78107eb61a5f4b3a98e9a7641f737ffdf8210b8e15248382a
```

### `dpkg` source package: `node-object-assign=4.1.1-6`

Binary Packages:

- `node-object-assign=4.1.1-6`

Licenses: (parsed from: `/usr/share/doc/node-object-assign/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-object-assign=4.1.1-6
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-object-assign/node-object-assign_4.1.1-6.dsc' node-object-assign_4.1.1-6.dsc 2129 SHA512:c47e72d2b6caddb3dfed82e59feddfac1c6fac8e37a090e6f966ea60133cc9a2b6bd2360973661de84913f0ec451022dbbb1379310303e768b7db6d0477a006b
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-object-assign/node-object-assign_4.1.1.orig.tar.gz' node-object-assign_4.1.1.orig.tar.gz 4122 SHA512:c2ba723bfc293d087b98a8e028dda8f38293e692835d45def8b94d5b942a5925c94fbbbf23474ac9006e5b1eea431cb94fe3c23e3da0f6635ec67961bfd6e8ae
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-object-assign/node-object-assign_4.1.1-6.debian.tar.xz' node-object-assign_4.1.1-6.debian.tar.xz 3480 SHA512:cf7d862b71eeb83444aed5c5612db031e7aa7d7e8e40a4a1e3f5c9c0d638b4caf4de1c6a641c70a4fee91ac4638f1361025cba4acbd806dce53f8bea46ea320a
```

### `dpkg` source package: `node-once=1.4.0-4`

Binary Packages:

- `node-once=1.4.0-4`

Licenses: (parsed from: `/usr/share/doc/node-once/copyright`)

- `BSD-2-clause`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-once=1.4.0-4
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-once/node-once_1.4.0-4.dsc' node-once_1.4.0-4.dsc 2053 SHA512:2868a932ebfb1af43d5819cc375f46da858ba280eb1e832bcaa62d5d11cca1ab404cfbf2015473995a11d0990c2823f62cd06efd5e78f0420a0b5bd6c3038396
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-once/node-once_1.4.0.orig.tar.gz' node-once_1.4.0.orig.tar.gz 2629 SHA512:f9fbdde6226e80b9e45cd400b5e251e4c14b75a9b201859eafa01bde59fadee13c98eeeee8008509132b4c1ee2127cc7adabfdcdeda6552b1aaa96216cd6a272
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-once/node-once_1.4.0-4.debian.tar.xz' node-once_1.4.0-4.debian.tar.xz 3080 SHA512:dcf718110939283b74047c97b5b70b2ace243d81af14d4c348c21413e0ffbe3d3113fcfdbbc55cf1b8f08b6743d285a530c8cc3cb021a251f34324d5ddb099ae
```

### `dpkg` source package: `node-osenv=0.1.5+~0.1.0-1`

Binary Packages:

- `node-osenv=0.1.5+~0.1.0-1`

Licenses: (parsed from: `/usr/share/doc/node-osenv/copyright`)

- `BSD-2-clause`
- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-osenv=0.1.5+~0.1.0-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-osenv/node-osenv_0.1.5%2b%7e0.1.0-1.dsc' node-osenv_0.1.5+~0.1.0-1.dsc 2357 SHA512:76b2f837104eda685afaaf4b86dee721bb8e78398b94da0ac50265efe6794d68ba1be4e46b7be44a133b1996662efa947108c4d773ebde22fb100a74ba614620
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-osenv/node-osenv_0.1.5%2b%7e0.1.0.orig-types-osenv.tar.gz' node-osenv_0.1.5+~0.1.0.orig-types-osenv.tar.gz 1880 SHA512:1c672947fa1504b64165b3e58e0d64f1fc2632c1ac1f7a68842c6452589b2550bd68297ed53e8b58dfab40c7e067dcd8ede217eeef5d262e4d8e92601f5a665e
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-osenv/node-osenv_0.1.5%2b%7e0.1.0.orig.tar.gz' node-osenv_0.1.5+~0.1.0.orig.tar.gz 17594 SHA512:72d74819c59f497efddfc707099f5ac0570277b510417b2b6af3308762084219148e5e81985dfadd264248fefe9d3829912e629172605ca6f7a2363d73c66a81
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-osenv/node-osenv_0.1.5%2b%7e0.1.0-1.debian.tar.xz' node-osenv_0.1.5+~0.1.0-1.debian.tar.xz 3872 SHA512:c65fefa3fdd0e10aaa5415f8afebc886992723b444882d4b5e3100fcb6bf613a16b4c6d81493045e5aebfe644b2992f81790b0fbc745ccc54bd50e53992d6b1c
```

### `dpkg` source package: `node-p-cancelable=2.1.1-1`

Binary Packages:

- `node-p-cancelable=2.1.1-1`

Licenses: (parsed from: `/usr/share/doc/node-p-cancelable/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-p-cancelable=2.1.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-p-cancelable/node-p-cancelable_2.1.1-1.dsc' node-p-cancelable_2.1.1-1.dsc 2162 SHA512:edf4f623f9ba4b71786e5b9f007217af39874c0818a9fe3f0b8b3e6e33c5598ec66d8adc8fea9f8d692bb125ce750f1baad563954090c226f13c2aeb95f0638f
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-p-cancelable/node-p-cancelable_2.1.1.orig.tar.gz' node-p-cancelable_2.1.1.orig.tar.gz 6609 SHA512:4a76cab2237fca620a453a0cccd0440b3f43dc895f960aa61342aeab0b5bd70a245221e5507ed4f4fc5f76346a00a8e96f2184bdc261b504ae5bb95b658f7a48
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-p-cancelable/node-p-cancelable_2.1.1-1.debian.tar.xz' node-p-cancelable_2.1.1-1.debian.tar.xz 7388 SHA512:6c0de9ef9ca562c8e326942b0a10f01ea2d27d791a88e29dca94ebf4d13a8c2c790a7cb08fc462dbf1e492057b262b3b2ed09a2685a29a4536e6d15f6d39377a
```

### `dpkg` source package: `node-p-map=4.0.0+~3.1.0+~3.0.1-1`

Binary Packages:

- `node-p-map=4.0.0+~3.1.0+~3.0.1-1`

Licenses: (parsed from: `/usr/share/doc/node-p-map/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-p-map=4.0.0+~3.1.0+~3.0.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-p-map/node-p-map_4.0.0%2b%7e3.1.0%2b%7e3.0.1-1.dsc' node-p-map_4.0.0+~3.1.0+~3.0.1-1.dsc 2844 SHA512:305029afca040c55c670d86892ed3a58f796a8dc0ae96ba4f8a4460c7a7d95ad1340b6174df78708e7f56cfc9c2d4d5d5f5c2bc2cea8861a631d2c72767609f9
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-p-map/node-p-map_4.0.0%2b%7e3.1.0%2b%7e3.0.1.orig-aggregate-error.tar.gz' node-p-map_4.0.0+~3.1.0+~3.0.1.orig-aggregate-error.tar.gz 3758 SHA512:6e27af292e17f7562ddf2294009599211bf9cf7720453e9343d5eea1ca222be6ba76240d55658ff8dfc5ad0d4e5b487a1cfde42b6056ca7513dfee3a909b306f
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-p-map/node-p-map_4.0.0%2b%7e3.1.0%2b%7e3.0.1.orig-clean-stack.tar.gz' node-p-map_4.0.0+~3.1.0+~3.0.1.orig-clean-stack.tar.gz 4414 SHA512:6173f6894c9e27dad33041c46a400a69399dd9f27825581f8c7923daa01c31f0eacb61c6f674588e72b078800412b9a5a5fd4a266cd045139c15b643365539fb
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-p-map/node-p-map_4.0.0%2b%7e3.1.0%2b%7e3.0.1.orig.tar.gz' node-p-map_4.0.0+~3.1.0+~3.0.1.orig.tar.gz 5208 SHA512:ebcec30af23fdf5877279f8d760967b05034ec2a60dc3e9876f800370c072664862329f58a22dc0e426399e34a6a87a08dbf76c4a4feff9051216cf396ac67d0
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-p-map/node-p-map_4.0.0%2b%7e3.1.0%2b%7e3.0.1-1.debian.tar.xz' node-p-map_4.0.0+~3.1.0+~3.0.1-1.debian.tar.xz 7968 SHA512:57fdffbcbef2c7e087e6fb5582a91e45d866e70122fc61d724b8958babc0c89cff1b6ad9dea7b655a2eaadb140fcd7d1a720aeffe50cb1dc59203c2f4f5f02c1
```

### `dpkg` source package: `node-path-is-absolute=2.0.0-2`

Binary Packages:

- `node-path-is-absolute=2.0.0-2`

Licenses: (parsed from: `/usr/share/doc/node-path-is-absolute/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-path-is-absolute=2.0.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-path-is-absolute/node-path-is-absolute_2.0.0-2.dsc' node-path-is-absolute_2.0.0-2.dsc 2123 SHA512:3ea14e53f8bf23dcb39d9cbf399fee022193eb78389a6d893a086911729a2632db765c064672184da6a7c64b4f1a9932f6c5792f8822636e203d673551094477
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-path-is-absolute/node-path-is-absolute_2.0.0.orig.tar.gz' node-path-is-absolute_2.0.0.orig.tar.gz 2589 SHA512:da00a5d62cd44853c2bec96097e1a526a11f9eef200bd6f3b043cc77d8ee1374a45d790a45ef24b672ba33d825df9d595b1751bdc90d1354deb5a4ba9ada2a28
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-path-is-absolute/node-path-is-absolute_2.0.0-2.debian.tar.xz' node-path-is-absolute_2.0.0-2.debian.tar.xz 2752 SHA512:e87d38e0eea5468ee250ab9d1a5ab54dbf7bb1489333b8f633f1c0094901efea3f9b262da34dd619568cca1dd23841568c9a87c809b308d3384f6ec40ce664d3
```

### `dpkg` source package: `node-process-nextick-args=2.0.1-2`

Binary Packages:

- `node-process-nextick-args=2.0.1-2`

Licenses: (parsed from: `/usr/share/doc/node-process-nextick-args/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-process-nextick-args=2.0.1-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-process-nextick-args/node-process-nextick-args_2.0.1-2.dsc' node-process-nextick-args_2.0.1-2.dsc 2191 SHA512:528b25203e10953c10e19aedb132adefe91ffe3a1406f4085fc677476185e97cd35b1dd8fc98746b1752491f007e5fe39f213e4aae76b1b2a534302bf9f3f64f
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-process-nextick-args/node-process-nextick-args_2.0.1.orig.tar.gz' node-process-nextick-args_2.0.1.orig.tar.gz 2180 SHA512:e95b7f1032d87a0dae373ce090d32382e187960cf12ff4676add6013883fefb44cc5753429b04ab479eb2fc5c2bbd56f63c8fadda1708386bdb04782fe6b5152
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-process-nextick-args/node-process-nextick-args_2.0.1-2.debian.tar.xz' node-process-nextick-args_2.0.1-2.debian.tar.xz 2828 SHA512:22e34418a56168e091d48cef2bed975aab23353ba8b546551185888bcf83363d290237d4e39f5dfacf07b100d0c928e8665f584fb63f62a28f5a393e9976aa24
```

### `dpkg` source package: `node-promise-inflight=1.0.1+~1.0.0-1`

Binary Packages:

- `node-promise-inflight=1.0.1+~1.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-promise-inflight/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-promise-inflight=1.0.1+~1.0.0-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-promise-inflight/node-promise-inflight_1.0.1%2b%7e1.0.0-1.dsc' node-promise-inflight_1.0.1+~1.0.0-1.dsc 2528 SHA512:ba568572d20bd975c2d615d02e1dd1e13f8d9ccd5320941b1779a69f9d9d5be9a80bdf027d6f1af81e409c5d849e0e611e059dfdfa0b65a63958960b152be777
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-promise-inflight/node-promise-inflight_1.0.1%2b%7e1.0.0.orig-types-promise-inflight.tar.gz' node-promise-inflight_1.0.1+~1.0.0.orig-types-promise-inflight.tar.gz 1863 SHA512:476970c3216f4be0d09abd29e8106623bf4add5bf072e9d75a7fb92d3ac43469e6c4c1d5d61e4b290bf7462a759537e554f87d6639b8be29d67c6ab7ea846ebb
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-promise-inflight/node-promise-inflight_1.0.1%2b%7e1.0.0.orig.tar.gz' node-promise-inflight_1.0.1+~1.0.0.orig.tar.gz 1830 SHA512:8272202089ef2f104497135b5a194aa12de5804ff69be537c5857fbad29d75220b302d627731db25fc4c56a501a2dfeb995575073d715ac3aba87ffa40775ed6
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-promise-inflight/node-promise-inflight_1.0.1%2b%7e1.0.0-1.debian.tar.xz' node-promise-inflight_1.0.1+~1.0.0-1.debian.tar.xz 3084 SHA512:cb12e8de21cd676b29a666d079fd8cced87472de91745b6099ee187e142159cf09f8dd5382afd099bae3f16c0fd6e60b41919739cabdc7b72bbcec2b74a3d292
```

### `dpkg` source package: `node-promise-retry=2.0.1-2`

Binary Packages:

- `node-promise-retry=2.0.1-2`

Licenses: (parsed from: `/usr/share/doc/node-promise-retry/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-promise-retry=2.0.1-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-promise-retry/node-promise-retry_2.0.1-2.dsc' node-promise-retry_2.0.1-2.dsc 2219 SHA512:8c0fdff5365ce3567982fd1b6a59bc7ef1e21fa98c530172a36809b47048b5b9881de84d2735878987ffec80e1606aa840d32ac9d1da18d885c083c0d585ce2e
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-promise-retry/node-promise-retry_2.0.1.orig.tar.gz' node-promise-retry_2.0.1.orig.tar.gz 16029 SHA512:bcc889e2f07d6ae24a53e9ad3f21296c0166893dd10cda48b95092e650bda586cce4f5097dc3c52aeaa5d3c81be101e5681a8c40a3ec9872ceacc9ce7635d91c
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-promise-retry/node-promise-retry_2.0.1-2.debian.tar.xz' node-promise-retry_2.0.1-2.debian.tar.xz 3360 SHA512:3556c9a38fda39ced7fd453a3e82b95a7b5baf5dbe6f05397a7a9fee5219a09a073998d08654bbc2e9e07e02c677118b46ff930f033552ee0415644297280687
```

### `dpkg` source package: `node-promzard=0.3.0-2`

Binary Packages:

- `node-promzard=0.3.0-2`

Licenses: (parsed from: `/usr/share/doc/node-promzard/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-promzard=0.3.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-promzard/node-promzard_0.3.0-2.dsc' node-promzard_0.3.0-2.dsc 2075 SHA512:bb6fe7373b7592abb2b49c4bfb341b68e7c8bac6e93cc5b9cfde8f040cdcbcb3f8d56196b8423f0915b6cd70971e3f26875368f6364396cffc300537fb0ea0bf
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-promzard/node-promzard_0.3.0.orig.tar.gz' node-promzard_0.3.0.orig.tar.gz 9245 SHA512:0a447299ca42aade655cbc6312c81fb0b199c46816cd805fb6536d050bd88292636bcbb761b03ff74fb85e60d7ff15bedd471580722f279c729b2b6a5fcb4b35
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-promzard/node-promzard_0.3.0-2.debian.tar.xz' node-promzard_0.3.0-2.debian.tar.xz 3480 SHA512:9629b15645b98934a41dfab050f3766fecaec48039676d65b02d09cc6a5c17adca9d3a8723b0513d30ff97f2d2a2d9e5eda0f796a03b3615bb3fba6a530c0bee
```

### `dpkg` source package: `node-pump=3.0.0-5`

Binary Packages:

- `node-pump=3.0.0-5`

Licenses: (parsed from: `/usr/share/doc/node-pump/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-pump=3.0.0-5
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-pump/node-pump_3.0.0-5.dsc' node-pump_3.0.0-5.dsc 2039 SHA512:4cf457d18628da51ad7f119b38829c3c68c25a843ccb48c9cfc1c2f99750b6ec2d7c7b1b60ad758cbb1bae3fa02e3593ec9ff4584db4051920a8c824f0463d83
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-pump/node-pump_3.0.0.orig.tar.gz' node-pump_3.0.0.orig.tar.gz 3394 SHA512:04452ef61e49a317dc896172fc07802b5f70af31b52ca7dbff9c7ac51211bc5c1badf125ac8e2fd40ef5a4badf5eea70a8c1f0e2d65288b53f9f256a77862aeb
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-pump/node-pump_3.0.0-5.debian.tar.xz' node-pump_3.0.0-5.debian.tar.xz 3656 SHA512:e6d24d3830bdda4bd0ff3b72a0ee1cc8d6bc19135db6ab8e9368e619840910a0e15d202889942ea8f84b01143fa076c1a64c18172dc4052ded0d6bba69e568bd
```

### `dpkg` source package: `node-quick-lru=5.1.1-1`

Binary Packages:

- `node-quick-lru=5.1.1-1`

Licenses: (parsed from: `/usr/share/doc/node-quick-lru/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-quick-lru=5.1.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-quick-lru/node-quick-lru_5.1.1-1.dsc' node-quick-lru_5.1.1-1.dsc 2061 SHA512:735ef8aff789a0be49aa70d2db8d00bf5ec6cd5b2780db110ec38fa5284b63eb7edec5f73426e502ef2a26601cbd890361f9f23a7f47ba821018adef149a2e8d
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-quick-lru/node-quick-lru_5.1.1.orig.tar.gz' node-quick-lru_5.1.1.orig.tar.gz 5113 SHA512:5510fdaede6424a10ab90a2690fca62334aedc5812e285bb1f9e88fdf5c3b17443f67314687624b566d33419279bd4e1725dcd9595ee8af8245b9deda0e1e55f
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-quick-lru/node-quick-lru_5.1.1-1.debian.tar.xz' node-quick-lru_5.1.1-1.debian.tar.xz 3656 SHA512:7ec4d9cd86b614e2a99d50da4a693d5c25842526eba50547cb3865b67d000242e6b95177e3133e937a12501fd11af3ba03f26c5442de038b448b04294c84d78d
```

### `dpkg` source package: `node-read-package-json=4.1.1-1`

Binary Packages:

- `node-read-package-json=4.1.1-1`

Licenses: (parsed from: `/usr/share/doc/node-read-package-json/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-read-package-json=4.1.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-read-package-json/node-read-package-json_4.1.1-1.dsc' node-read-package-json_4.1.1-1.dsc 2654 SHA512:7c1caeae3e2670c156842c116ae4c5225ba50fee659e878aaf69663f73e3afc7ce633280a464aa0acfa1bcb2dc7a8f15a754e50f9cd3a7a649636778f66f0f31
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-read-package-json/node-read-package-json_4.1.1.orig-npm-normalize-package-bin.tar.gz' node-read-package-json_4.1.1.orig-npm-normalize-package-bin.tar.gz 31250 SHA512:3ccb0e3b006e00ae464b65e497d73772628f3a87340da7f46d7bdb144cb765f99d3fc9faa2912daf0b60cd209b7041e7cab6cdc973d642bbecb5e4556c2badc9
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-read-package-json/node-read-package-json_4.1.1.orig.tar.gz' node-read-package-json_4.1.1.orig.tar.gz 129250 SHA512:4e8c35000ce44f0f8f7891a588c0104ffe788dd3f8acfc580aeb8526f306c52f9c6a3d784fbf9e1e52022173963eb91602e70454796e61d3f58f1a8c282788dd
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-read-package-json/node-read-package-json_4.1.1-1.debian.tar.xz' node-read-package-json_4.1.1-1.debian.tar.xz 3448 SHA512:d1ca5afa230b49aba19cd281b36fdb7f2e90d13e9a9e8c1cb4902e41499c96a3cacf1e4a2db7af03cfee2428586d2ba9e54ddeceaf4c2fb2dc1089474fac3e9a
```

### `dpkg` source package: `node-read=1.0.7-3`

Binary Packages:

- `node-read=1.0.7-3`

Licenses: (parsed from: `/usr/share/doc/node-read/copyright`)

- `GPL-3`
- `GPL-3.0+`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-read=1.0.7-3
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-read/node-read_1.0.7-3.dsc' node-read_1.0.7-3.dsc 2021 SHA512:6ead2a824836f37e5babda56b4e83e884116ff81e8c4a91e7c2a800e812f02d4506537e07ebb984ebda4b24807fac4c591efb0f12ad1999e806a43d8056741ca
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-read/node-read_1.0.7.orig.tar.gz' node-read_1.0.7.orig.tar.gz 4246 SHA512:49b66ac0561dfd1c3daf215f95866e762f9782f8fb71a48db6365851c1eb2892b9f9c80ae9a396adea8af3b2e57a53f5dd0f27777cd2f6811b16f3df0699aaf6
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-read/node-read_1.0.7-3.debian.tar.xz' node-read_1.0.7-3.debian.tar.xz 2956 SHA512:185fae8d56acb4cbfa42602e83d997ffa60baadc03ec279f8a971320d27a4321824c9efc962c62632409be034d7a91b541fa623ab4f4f3bbf60908df7a09a133
```

### `dpkg` source package: `node-readable-stream=3.6.0+~cs3.0.0-1`

Binary Packages:

- `node-readable-stream=3.6.0+~cs3.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-readable-stream/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-readable-stream=3.6.0+~cs3.0.0-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-readable-stream/node-readable-stream_3.6.0%2b%7ecs3.0.0-1.dsc' node-readable-stream_3.6.0+~cs3.0.0-1.dsc 3176 SHA512:9bc5fd73de350b08e04903c2aa6e75f2823dde9e4778ce8757ab95db93f0d6b41dedfac2d713cf310396bc32cbd113f249c78d6c62d3c737fcac7b92f10ec0c0
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-readable-stream/node-readable-stream_3.6.0%2b%7ecs3.0.0.orig-bufferstreams.tar.gz' node-readable-stream_3.6.0+~cs3.0.0.orig-bufferstreams.tar.gz 64145 SHA512:b3ce1cc4566241d3880610ccfd219db9a0351c35a0604c538bfb61ca9bbaf1ebe48f4d51f0ef98a49fa7cd49f1be08b4fb7bc5e1b023878cc40d82eeaa6854ba
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-readable-stream/node-readable-stream_3.6.0%2b%7ecs3.0.0.orig.tar.gz' node-readable-stream_3.6.0+~cs3.0.0.orig.tar.gz 158296 SHA512:47bbb90e2afeaed0833f29d4c2e3886463b055601ec46aa1da6038651d566a00ddb0fe171198a71f97c3ea5de1336cc4d8320511c32bb7be6476ead1a4a4f0ae
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-readable-stream/node-readable-stream_3.6.0%2b%7ecs3.0.0-1.debian.tar.xz' node-readable-stream_3.6.0+~cs3.0.0-1.debian.tar.xz 16900 SHA512:78f4328c883eeae433961afe6ff2364de673d95aefaa1ddfe50ca708c614809c4a262fdf0843ea68bc1859e7cbd3b67a93c85fe29d3c38db02f9429f26ccbf4e
```

### `dpkg` source package: `node-resolve=1.20.0+~cs5.27.9-1`

Binary Packages:

- `node-resolve=1.20.0+~cs5.27.9-1`

Licenses: (parsed from: `/usr/share/doc/node-resolve/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-resolve=1.20.0+~cs5.27.9-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-resolve/node-resolve_1.20.0%2b%7ecs5.27.9-1.dsc' node-resolve_1.20.0+~cs5.27.9-1.dsc 3556 SHA512:c6b7648e489a774d73bde89d63fce4b492bd245207205ae3c97661c7560fe2cc7b517ad64cf3d524e4968532b3b1b90c33c35524a631bcbb97543e96f164a433
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-resolve/node-resolve_1.20.0%2b%7ecs5.27.9.orig-is-core-module.tar.gz' node-resolve_1.20.0+~cs5.27.9.orig-is-core-module.tar.gz 9562 SHA512:1a6cec5ba744a72294b2e06f474201eebed976b63b668c6ec0aec7519083e5cc5d185a4671ee8ae1db846d55f983d8e4ac784f4db8f8c1ad9102f91068b67ae9
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-resolve/node-resolve_1.20.0%2b%7ecs5.27.9.orig-object-keys.tar.gz' node-resolve_1.20.0+~cs5.27.9.orig-object-keys.tar.gz 9968 SHA512:e92282dcdaf31a86a232a3eb46de9a0fc686539ae6061feb18d8fb5a5f6f0a6d7902726d7e8e14919267ca56387e973457fb995a792244d32486c85f4b832cff
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-resolve/node-resolve_1.20.0%2b%7ecs5.27.9.orig-path-parse.tar.gz' node-resolve_1.20.0+~cs5.27.9.orig-path-parse.tar.gz 3428 SHA512:538b4fb6fa507a214f4e9be19d9e68b4b4cbd850211c1cda07432f740f6c761781390699d50fd0b1ad17d3bdb2c6512cf2480a44d47dcc0b643c71c0aa90caec
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-resolve/node-resolve_1.20.0%2b%7ecs5.27.9.orig-types-resolve.tar.gz' node-resolve_1.20.0+~cs5.27.9.orig-types-resolve.tar.gz 3182 SHA512:2aee7e18f15ad764b75b6e94c2dc3ec72aed229699b066071facf135b665b2d9a5bcc612651ccec33c2c5dbc655546c7c94b9c72d4b2b85b6ee9b371c18a2623
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-resolve/node-resolve_1.20.0%2b%7ecs5.27.9.orig.tar.gz' node-resolve_1.20.0+~cs5.27.9.orig.tar.gz 26637 SHA512:dd6ca95c64ab2c83be79f32bfc085b913e6e2cd0e4fbda98ad36b1927ce0366543802b0911fc580c06c813aa37e8912be9f56e971d146527853bb5657131e411
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-resolve/node-resolve_1.20.0%2b%7ecs5.27.9-1.debian.tar.xz' node-resolve_1.20.0+~cs5.27.9-1.debian.tar.xz 5332 SHA512:c98e7677ce88d1f40fab33ecf184140e7fb53052549f9c354c2a60f61a237587697e090b878ac6cd87bb36f0c6480a520a3c212dbca60d2e1172b48652bd21bf
```

### `dpkg` source package: `node-retry=0.13.1+~0.12.1-1`

Binary Packages:

- `node-retry=0.13.1+~0.12.1-1`

Licenses: (parsed from: `/usr/share/doc/node-retry/copyright`)

- `Expat`
- `GPL-3`
- `GPL-3.0+`

Source:

```console
$ apt-get source -qq --print-uris node-retry=0.13.1+~0.12.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-retry/node-retry_0.13.1%2b%7e0.12.1-1.dsc' node-retry_0.13.1+~0.12.1-1.dsc 2401 SHA512:0c37e3e19df0d2c9a19d217147b90fa2e6611467893a72e1aada251cf667c3e95de722f6774b154a1de8ce5721cd4b053e8b009dfc11debba72a9cdaaea57458
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-retry/node-retry_0.13.1%2b%7e0.12.1.orig-types-retry.tar.gz' node-retry_0.13.1+~0.12.1.orig-types-retry.tar.gz 3009 SHA512:c680e53364b8a2bb5ac1258e458aac754fb6af1761e0b456f72b5cdf3993dfb44829087a207c8ac30b4a84a8acf5a87ca25d3b0c2919c4fb7c041bcf8c2eafe2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-retry/node-retry_0.13.1%2b%7e0.12.1.orig.tar.gz' node-retry_0.13.1+~0.12.1.orig.tar.gz 10704 SHA512:ab6a558b34272b11dcf75f41e95fd4001f1250d9c26e7090016a9a9d41eb9a5f8dd519de64a522554b19b4f4874cfd442c7ce82624d90de486636f5eb0605351
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-retry/node-retry_0.13.1%2b%7e0.12.1-1.debian.tar.xz' node-retry_0.13.1+~0.12.1-1.debian.tar.xz 4100 SHA512:5ba3e3bfa7e855c2ae10a59addb922ab2043805e426f940aa5754d023349d32a10e5d60cf81ba980e9293113e858f410772ffb2787935c4fc120df7439c27224
```

### `dpkg` source package: `node-rimraf=3.0.2-1`

Binary Packages:

- `node-rimraf=3.0.2-1`

Licenses: (parsed from: `/usr/share/doc/node-rimraf/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-rimraf=3.0.2-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-rimraf/node-rimraf_3.0.2-1.dsc' node-rimraf_3.0.2-1.dsc 2318 SHA512:7ab6a8d97f14e45af98b6438ae232cd271ca2cffa626ef3664913457087a42530ba73388a727d1a29bba9e0bc1346fafab65d1c42766859ecc0ed1fcb97a5955
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-rimraf/node-rimraf_3.0.2.orig-types-rimraf.tar.gz' node-rimraf_3.0.2.orig-types-rimraf.tar.gz 2183 SHA512:ed6849d0c7691606103d7945e03c7e0e182f94f09fcffc7998769e0d000a85c7a7bd03f5282a4b435f0992502a7863184804f63f12e9cddd20dbf1c4edf8fb85
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-rimraf/node-rimraf_3.0.2.orig.tar.gz' node-rimraf_3.0.2.orig.tar.gz 26331 SHA512:a157a18706d8bc2978546a065b1eaa25c66e520d280765db9f90d1cee4a00d382f80a954094d8d404af268987df3f455ad70934ecf1fe961e96ea061dd8d10a3
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-rimraf/node-rimraf_3.0.2-1.debian.tar.xz' node-rimraf_3.0.2-1.debian.tar.xz 4100 SHA512:b1e5d4775a37e0f6c099df6792afb3812bd290ccc4396ea0b9141701d438e2cb76268090b3cb8c1a2ed51d9667410fd58134d7daefb700929fe3a466dda7bcc1
```

### `dpkg` source package: `node-run-queue=2.0.0-2`

Binary Packages:

- `node-run-queue=2.0.0-2`

Licenses: (parsed from: `/usr/share/doc/node-run-queue/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-run-queue=2.0.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-run-queue/node-run-queue_2.0.0-2.dsc' node-run-queue_2.0.0-2.dsc 2080 SHA512:7d298404a6593dbbb6359d9068e24fb4c50250d5da58d431b53764b063f56631a0dfd20352866ccee969a251119b4812b9f6a69f2a4a3ffa42b513541867948c
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-run-queue/node-run-queue_2.0.0.orig.tar.gz' node-run-queue_2.0.0.orig.tar.gz 4039 SHA512:aab0690cb12806b8197c2f79387523261bea53c01850a36f666a00082b0c38299331859dc884d517a2779e19cfc22cbce571b9059df13c1d61ebfd3dda65a4fd
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-run-queue/node-run-queue_2.0.0-2.debian.tar.xz' node-run-queue_2.0.0-2.debian.tar.xz 2588 SHA512:1cd4ca0f379676962c05648cab2cf2cf0c545e767a6d83c249cc64562bfd5b8353f80d0a76833a0684834e6771ab5f982887dd3cb63110063f922248ecdb297a
```

### `dpkg` source package: `node-safe-buffer=5.2.1+~cs2.1.2-2`

Binary Packages:

- `node-safe-buffer=5.2.1+~cs2.1.2-2`

Licenses: (parsed from: `/usr/share/doc/node-safe-buffer/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-safe-buffer=5.2.1+~cs2.1.2-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-safe-buffer/node-safe-buffer_5.2.1%2b%7ecs2.1.2-2.dsc' node-safe-buffer_5.2.1+~cs2.1.2-2.dsc 2541 SHA512:c9130788abc969c759e269ae4c416434c88bfa495e707ee12ee1277bc7781a0fce998b27d7a3cb491703fdabf692102b0ddd8c7df76646c4e225736f664a8a32
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-safe-buffer/node-safe-buffer_5.2.1%2b%7ecs2.1.2.orig-safer-buffer.tar.gz' node-safe-buffer_5.2.1+~cs2.1.2.orig-safer-buffer.tar.gz 12452 SHA512:145b4054f8340afc91fa42613511bc5750e269fd9aa645a7158882ca03721ca59240cabffc6c2b27c562b95fa51d70288e11c959fab1b7f52ca2b14db205882c
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-safe-buffer/node-safe-buffer_5.2.1%2b%7ecs2.1.2.orig.tar.gz' node-safe-buffer_5.2.1+~cs2.1.2.orig.tar.gz 10701 SHA512:3e7204ffb782f413991b6f305b71bfe57399c9ed941dd665ced0c6dfd251f96bf996d926676b092ff6d7eb5947b249449f0eaab2adcd43f6625f981c2d4d0a56
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-safe-buffer/node-safe-buffer_5.2.1%2b%7ecs2.1.2-2.debian.tar.xz' node-safe-buffer_5.2.1+~cs2.1.2-2.debian.tar.xz 3608 SHA512:2502b54cac8da8dcf9ea19ecc0087df3f22ec9fe603daa861d33f57b62458eebae35f378e2ca780a178a6407087c8617398b9c2870d7249d59f31262bfd2467a
```

### `dpkg` source package: `node-semver=7.3.5+~7.3.8-1`

Binary Packages:

- `node-semver=7.3.5+~7.3.8-1`

Licenses: (parsed from: `/usr/share/doc/node-semver/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-semver=7.3.5+~7.3.8-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-semver/node-semver_7.3.5%2b%7e7.3.8-1.dsc' node-semver_7.3.5+~7.3.8-1.dsc 2454 SHA512:e5f2090e9514978724a583dd5925b631a7f4d977182a61703fc459b283836831c6ddad4797f1bfe2de18f59d42b833e4413c9f46d12d6ee646552a7b54b10c9e
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-semver/node-semver_7.3.5%2b%7e7.3.8.orig-types-semver.tar.gz' node-semver_7.3.5+~7.3.8.orig-types-semver.tar.gz 6442 SHA512:0ffd8426f025084b581446269a51b06c65ee2bcf3a1f3c827379d95ffb6415341d114f236430208afd3c3f5eb6c81d7bcb8657668abbc850275b818305bf4da3
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-semver/node-semver_7.3.5%2b%7e7.3.8.orig.tar.gz' node-semver_7.3.5+~7.3.8.orig.tar.gz 118020 SHA512:9ef7caf08f6968bd9d00ee332df948ddd8a491a882d867a875ef94ebc2d054a56d5fea42b30d46a6a7fd205c4562a6d3840710f39ee6f5dc935b54879c77a02a
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-semver/node-semver_7.3.5%2b%7e7.3.8-1.debian.tar.xz' node-semver_7.3.5+~7.3.8-1.debian.tar.xz 4512 SHA512:f948439704307b8678d863452d0677dd9e10e1f29d38ff380c404eabda1b0a40623367b3225e743ccbd681167aea75c67e303d3a8f5204b1118331a7e682595c
```

### `dpkg` source package: `node-set-blocking=2.0.0-2`

Binary Packages:

- `node-set-blocking=2.0.0-2`

Licenses: (parsed from: `/usr/share/doc/node-set-blocking/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-set-blocking=2.0.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-set-blocking/node-set-blocking_2.0.0-2.dsc' node-set-blocking_2.0.0-2.dsc 2104 SHA512:41dc9b678eb2c16fa39b35105e75f513124a759205c5721e07bad7f863ef23a9ab18895801ca67781a3e473951823368e3af36c7b167f5e87818d53ff4874522
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-set-blocking/node-set-blocking_2.0.0.orig.tar.gz' node-set-blocking_2.0.0.orig.tar.gz 2994 SHA512:a6d2bccf649a7a50c758286fc718beeed9b9b930b6bdbd3c35b9a260ffa528197e71f51b0a8be1a52e493e43745c457c221d7a88b807d33f848d8397fd740087
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-set-blocking/node-set-blocking_2.0.0-2.debian.tar.xz' node-set-blocking_2.0.0-2.debian.tar.xz 2540 SHA512:779f10a72a9abc6ad5df1941ac61f0855da12a10f798f5061097010acd239103c7c69a335a7394569d6429599487529bc087fd23eb0022730f9bd8df610a7ed3
```

### `dpkg` source package: `node-signal-exit=3.0.6+~3.0.1-1`

Binary Packages:

- `node-signal-exit=3.0.6+~3.0.1-1`

Licenses: (parsed from: `/usr/share/doc/node-signal-exit/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-signal-exit=3.0.6+~3.0.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-signal-exit/node-signal-exit_3.0.6%2b%7e3.0.1-1.dsc' node-signal-exit_3.0.6+~3.0.1-1.dsc 2445 SHA512:7f829522d0a892fa2f620fa82259cf4ce18760d6901489bda4726eb8cf93ea91b177227fec3c53b848da786cd3bca82c3f63258a651160455c5365ee4536a301
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-signal-exit/node-signal-exit_3.0.6%2b%7e3.0.1.orig-types-signal-exit.tar.gz' node-signal-exit_3.0.6+~3.0.1.orig-types-signal-exit.tar.gz 1707 SHA512:3928ad37d3cff44fdce2d96dd50763dc2033e6e1c3f436b9ae152a95a2b2411097d53ed97696e4e9875e65b4767a213671ef8d3018159ccc46aa968f48d40351
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-signal-exit/node-signal-exit_3.0.6%2b%7e3.0.1.orig.tar.gz' node-signal-exit_3.0.6+~3.0.1.orig.tar.gz 99002 SHA512:4482e59e736e9dbc64f92411802466c1ed429caa4daf73f110422ce76b5c78af794062d35291f73528375028d46fa8fc4207470b0991e97007c39ba5bb30a383
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-signal-exit/node-signal-exit_3.0.6%2b%7e3.0.1-1.debian.tar.xz' node-signal-exit_3.0.6+~3.0.1-1.debian.tar.xz 3144 SHA512:cec16838e628a515ac332797c326c44f7136b3cd495f12ba0b87b97e2852954a21b713dc7d306ab1958327a03d918b0bc0355fd2d56c547a55ebf3b7055de34a
```

### `dpkg` source package: `node-slash=3.0.0-2`

Binary Packages:

- `node-slash=3.0.0-2`

Licenses: (parsed from: `/usr/share/doc/node-slash/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-slash=3.0.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-slash/node-slash_3.0.0-2.dsc' node-slash_3.0.0-2.dsc 2014 SHA512:913a51324b1f4e700d4a5db6ec4ad40cbb4e3dac2a2f23059f24006d85028ef4161e154bb2aa8b69c33f876a3f3459dd799726832d1416e8a23a811cc6d30cc7
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-slash/node-slash_3.0.0.orig.tar.gz' node-slash_3.0.0.orig.tar.gz 2529 SHA512:8b14c01c5011faa624a3a4061579ab0e5d32f0aa7d7ffcc2461cb7e449f4646198be5c528941b4b6fd3a293d60861b0ead29b31a7880aff917ed4bdbada9e3d4
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-slash/node-slash_3.0.0-2.debian.tar.xz' node-slash_3.0.0-2.debian.tar.xz 3008 SHA512:3ee038e4b235e7aae02b6c69b139e7e65550cfcaa7932f9ef95874a281155db6b730a0bbf8d5dcfcbb453bc27c2cb129b478cb2eefeacf3f25942aa3fd982baf
```

### `dpkg` source package: `node-slice-ansi=5.0.0+~cs9.0.0-4`

Binary Packages:

- `node-slice-ansi=5.0.0+~cs9.0.0-4`

Licenses: (parsed from: `/usr/share/doc/node-slice-ansi/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-slice-ansi=5.0.0+~cs9.0.0-4
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-slice-ansi/node-slice-ansi_5.0.0%2b%7ecs9.0.0-4.dsc' node-slice-ansi_5.0.0+~cs9.0.0-4.dsc 2871 SHA512:af57e8fecfa9117715717cd3a7fe56323bb475aebc864b5f685f18eca9d35187d9fe2c683819fc7d5a7d24ceeee2c9c798be9c9b92b3812ea90e65a5624c4447
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-slice-ansi/node-slice-ansi_5.0.0%2b%7ecs9.0.0.orig-is-fullwidth-code-point.tar.gz' node-slice-ansi_5.0.0+~cs9.0.0.orig-is-fullwidth-code-point.tar.gz 3376 SHA512:79c4e86e3998e6cc0192d383ca670224e4326dc7cca839f712319dfa8b3ee12d81258287761e6f4b13d1727dc49912e801a2454c3ada80ade7c78b13bd6d5635
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-slice-ansi/node-slice-ansi_5.0.0%2b%7ecs9.0.0.orig-types-slice-ansi.tar.gz' node-slice-ansi_5.0.0+~cs9.0.0.orig-types-slice-ansi.tar.gz 1690 SHA512:06df7077034e6f20fd11030d3761927aeb569a9b19502d7f6e2a7a5ca6b027e7002bd5617f61309d2820ec6f5977b289bf47d3bc46e01c58eb1e72267a6c9842
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-slice-ansi/node-slice-ansi_5.0.0%2b%7ecs9.0.0.orig.tar.gz' node-slice-ansi_5.0.0+~cs9.0.0.orig.tar.gz 5125 SHA512:a8fc8351e79316fc83e0a4cb17532afc2cdb80b4caacf3677cc4491b265142651648066f7cd3cd51b27ae6d3334df16bba6bcf19ac774fc95e4997ca6b03163a
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-slice-ansi/node-slice-ansi_5.0.0%2b%7ecs9.0.0-4.debian.tar.xz' node-slice-ansi_5.0.0+~cs9.0.0-4.debian.tar.xz 3804 SHA512:65616b53c39ed31c0e88d82606c4c661a16fc0a54f51f874adda812f695897cedebb33aebb683b06a7e03fa97fb90f23d3b3166557c13158d8bbe054ede82a70
```

### `dpkg` source package: `node-spdx-correct=3.1.1-2`

Binary Packages:

- `node-spdx-correct=3.1.1-2`

Licenses: (parsed from: `/usr/share/doc/node-spdx-correct/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris node-spdx-correct=3.1.1-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-spdx-correct/node-spdx-correct_3.1.1-2.dsc' node-spdx-correct_3.1.1-2.dsc 2193 SHA512:f3797702c526f0c19e86f9c05de509dbb7cd9eb216ad53ecc537a109e6c79b386d43eb41d0364886e99b7ac6d86a13e706b66aab983ba717fb3121652b0a1a1b
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-spdx-correct/node-spdx-correct_3.1.1.orig.tar.gz' node-spdx-correct_3.1.1.orig.tar.gz 9724 SHA512:d7bbfe0f915d7203943372f13499f6743f64066b719c30ab42d9acc53b3576e050d33a959155a711df6831d4a25cafeca80cfdc5bf7f96f3e805bebe40e63893
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-spdx-correct/node-spdx-correct_3.1.1-2.debian.tar.xz' node-spdx-correct_3.1.1-2.debian.tar.xz 2404 SHA512:88df8414df0ef4ee5fa92221b0f7925fa1240529dd4c4dab0a8bfd8327788cf0b1ef824463dca7dee8ba21532781bfe6247e118f8aa80783526dfc2292d00ceb
```

### `dpkg` source package: `node-spdx-exceptions=2.3.0-2`

Binary Packages:

- `node-spdx-exceptions=2.3.0-2`

Licenses: (parsed from: `/usr/share/doc/node-spdx-exceptions/copyright`)

- `CC-BY-3.0`

Source:

```console
$ apt-get source -qq --print-uris node-spdx-exceptions=2.3.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-spdx-exceptions/node-spdx-exceptions_2.3.0-2.dsc' node-spdx-exceptions_2.3.0-2.dsc 2115 SHA512:58cbcbf2037818fba9617ef13511fe786be576f88ed4e28791886f3f75563ad24adb3ea790cf9117094c16b73aab7c32755a0336ee05ce01dba0b8d1520444e2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-spdx-exceptions/node-spdx-exceptions_2.3.0.orig.tar.gz' node-spdx-exceptions_2.3.0.orig.tar.gz 1930 SHA512:f25d4aa5abeae9818f179e348bc716d3b71d1124395679cf0f89cbf1ede307c9a0e278d8c3c1606a4a29e9958a12515bca8f855dcdc12eb2d5fefd8a85b00255
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-spdx-exceptions/node-spdx-exceptions_2.3.0-2.debian.tar.xz' node-spdx-exceptions_2.3.0-2.debian.tar.xz 2500 SHA512:086c48536013908bd91f602b0686ac3364e559287ddbf2581dafbb04e31a5ef740b35f7cafd2369e1ebe27f029985bfe99dd6c3e763c65a1c86f42ee567e8e32
```

### `dpkg` source package: `node-spdx-expression-parse=3.0.1+~3.0.1-1`

Binary Packages:

- `node-spdx-expression-parse=3.0.1+~3.0.1-1`

Licenses: (parsed from: `/usr/share/doc/node-spdx-expression-parse/copyright`)

- `CC-BY-3.0`
- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-spdx-expression-parse=3.0.1+~3.0.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-spdx-expression-parse/node-spdx-expression-parse_3.0.1%2b%7e3.0.1-1.dsc' node-spdx-expression-parse_3.0.1+~3.0.1-1.dsc 2744 SHA512:850da235531a5adfd40bb99ee4f15bcff7cb52ec464e85f4b0460749e2bff87e1f2912dab7f70e64868361adb0725e3399450d858931619285949d790793a3ca
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-spdx-expression-parse/node-spdx-expression-parse_3.0.1%2b%7e3.0.1.orig-types-spdx-expression-parse.tar.gz' node-spdx-expression-parse_3.0.1+~3.0.1.orig-types-spdx-expression-parse.tar.gz 1906 SHA512:54c96a68198ec143b67ae25fa3c3f2bafb3bd6c854435c15e1e1666484f9d6d9641d15a79a0ec1a7977e04d91b6d0385115cb27bf3bad326b709177f5507bc6d
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-spdx-expression-parse/node-spdx-expression-parse_3.0.1%2b%7e3.0.1.orig.tar.gz' node-spdx-expression-parse_3.0.1+~3.0.1.orig.tar.gz 5510 SHA512:6b8e344f0ed202d37a1d08fdf7e6dfd86ba997680721251ae0b83683d6d13ea28e87a942be9381b86a5f705db24bdedd853f78d7efba21b482429aadf16f0d37
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-spdx-expression-parse/node-spdx-expression-parse_3.0.1%2b%7e3.0.1-1.debian.tar.xz' node-spdx-expression-parse_3.0.1+~3.0.1-1.debian.tar.xz 4064 SHA512:bd15f6d445655a29e877a804ac239d4e88b26873011d4e3060c8948b388d7d5fbe626ac9ca1c0a70771f868c815526c4fcab5b75bd5c5853f8bd74876cc79eda
```

### `dpkg` source package: `node-spdx-license-ids=3.0.11-1`

Binary Packages:

- `node-spdx-license-ids=3.0.11-1`

Licenses: (parsed from: `/usr/share/doc/node-spdx-license-ids/copyright`)

- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris node-spdx-license-ids=3.0.11-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-spdx-license-ids/node-spdx-license-ids_3.0.11-1.dsc' node-spdx-license-ids_3.0.11-1.dsc 2495 SHA512:c13d9d8b536bb836f1a8265765f4394076849acb7599adf47fca00d063da2475bdb9d076058a1198e106bf290467ad6dbc6f3a06a774bed5bb4eedc3f2abc100
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-spdx-license-ids/node-spdx-license-ids_3.0.11.orig-get-spdx-license-ids.tar.gz' node-spdx-license-ids_3.0.11.orig-get-spdx-license-ids.tar.gz 21186 SHA512:2f8a986ca358a83932bbc83b97646c997c4e69fb657d81fc7bc41edcd8041e3b9136d745f2989f49741277fdc0d183bc091bded77ca57c37314681dd3d3f2368
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-spdx-license-ids/node-spdx-license-ids_3.0.11.orig.tar.gz' node-spdx-license-ids_3.0.11.orig.tar.gz 43763 SHA512:91f4c2f6d981f7fce4ad2046334e273b50414595712328c4c074d5d87716718f9daafb8c1b9f913ac514ded45c7457d6644252c1efbabb5b71ecccf85cbfb34f
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-spdx-license-ids/node-spdx-license-ids_3.0.11-1.debian.tar.xz' node-spdx-license-ids_3.0.11-1.debian.tar.xz 3240 SHA512:5c43a797e204e8967cefdca0e1be31aecb3f6bd86b034314bc4987dfa4891e984e23d2de04f1bf1fa29bd0f641f19682e19e3003963a3f868a43506f73eb763a
```

### `dpkg` source package: `node-ssri=8.0.1-2`

Binary Packages:

- `node-ssri=8.0.1-2`

Licenses: (parsed from: `/usr/share/doc/node-ssri/copyright`)

- `CC0-1.0`
- `ISC`
- `ISC `

Source:

```console
$ apt-get source -qq --print-uris node-ssri=8.0.1-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ssri/node-ssri_8.0.1-2.dsc' node-ssri_8.0.1-2.dsc 2654 SHA512:105cc924b6728de4f1e26769d2e1d244ef4f9e6f85b23a88573ede21ea21a55dcfcab058b77ac32e23c2c93b8a70799fee3d90b7afffa4e80e4d4027fbf76028
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ssri/node-ssri_8.0.1.orig-figgy-pudding.tar.gz' node-ssri_8.0.1.orig-figgy-pudding.tar.gz 52503 SHA512:781b419bd4b0c33774bae14eb6715c1190f23a2ae35dc7e735116848c3576f033c636d6483a0d1af78d506bd70939953d53e68f9f3134fdcec8a2bab03eca5f3
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ssri/node-ssri_8.0.1.orig-minipass.tar.gz' node-ssri_8.0.1.orig-minipass.tar.gz 50240 SHA512:c1241ebd0bd079631c1931c7a5ac3dd7201634e348bfc02354e8360b04c43f4d6d4923a4d7844072a116986ca6a4572945c049131cb29327f6f80ff47a2eaa70
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ssri/node-ssri_8.0.1.orig.tar.gz' node-ssri_8.0.1.orig.tar.gz 162365 SHA512:0d0a79d4bf37e4f7704a2f7b6a0d00286da884cae294e3a53e81b0bf348583111482908f9f5ecf2e881b8faeb742573fee890dedaeb1d747c9c96407991f5717
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-ssri/node-ssri_8.0.1-2.debian.tar.xz' node-ssri_8.0.1-2.debian.tar.xz 3536 SHA512:0532f391df8d99e197f83903410a0cb37067bc762f28ad60c3c5382a539c9e0f3324cde0f78dac8fbea803e9b009e044ade8a351cc0a039705c650ede1f1edd5
```

### `dpkg` source package: `node-string-decoder=1.3.0-5`

Binary Packages:

- `node-string-decoder=1.3.0-5`

Licenses: (parsed from: `/usr/share/doc/node-string-decoder/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-string-decoder=1.3.0-5
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-string-decoder/node-string-decoder_1.3.0-5.dsc' node-string-decoder_1.3.0-5.dsc 2302 SHA512:8c98084a864eee4a83ffb93cf60d0f3092094d295a19e2e7c40868cb4860df407c20ccd569d00a0aa6b24aa881344e2992e9e678921e226d741030bc811da46c
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-string-decoder/node-string-decoder_1.3.0.orig.tar.gz' node-string-decoder_1.3.0.orig.tar.gz 35409 SHA512:07906e0673dd5e1e2c10bd2f6c0e0eba8d8f774155793fee23af1550a037a6f128a7cb56a8b4d256d6bd678e19964eb108df79751c3366fa453d7f8285053db2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-string-decoder/node-string-decoder_1.3.0-5.debian.tar.xz' node-string-decoder_1.3.0-5.debian.tar.xz 5028 SHA512:3355ae2e4536c1ab85fc24ae79d5622618337bafb6616bc28f49eb224801a324442b73b0e0cbfe70f62ecbe77eea88e383fa2fff3458399716e83a42831f86b4
```

### `dpkg` source package: `node-string-width=4.2.3+~cs13.2.3-1`

Binary Packages:

- `node-string-width=4.2.3+~cs13.2.3-1`

Licenses: (parsed from: `/usr/share/doc/node-string-width/copyright`)

- `Expat`
- `GPL-3`
- `GPL-3.0+`

Source:

```console
$ apt-get source -qq --print-uris node-string-width=4.2.3+~cs13.2.3-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-string-width/node-string-width_4.2.3%2b%7ecs13.2.3-1.dsc' node-string-width_4.2.3+~cs13.2.3-1.dsc 3004 SHA512:c6b8a92d4a152bb51e531a209d5a66609d874d82bd61c462a9963f9e59fabcd6ffc263fb07306f6ed176f36da228859416e91d5d5d22710a76b15ad96e63f6d6
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-string-width/node-string-width_4.2.3%2b%7ecs13.2.3.orig-emoji-regex.tar.gz' node-string-width_4.2.3+~cs13.2.3.orig-emoji-regex.tar.gz 16352 SHA512:62fea5ea6493a1c087d9057986bea3fdf7ba2687a33dea748daba931bac0a813bbc14d99be17e1f34fe4206245387c083007ca4c23316627cf5478043b337671
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-string-width/node-string-width_4.2.3%2b%7ecs13.2.3.orig-types-string-width.tar.gz' node-string-width_4.2.3+~cs13.2.3.orig-types-string-width.tar.gz 1108 SHA512:cec6573f84529b0dd33977f67aeb75c716fb1ada3b23e06b0745b1c1d45a11d0819d46c041ae7bc997ff3967007e8a7d9bbb7a65dd29c3db55da086925724f66
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-string-width/node-string-width_4.2.3%2b%7ecs13.2.3.orig.tar.gz' node-string-width_4.2.3+~cs13.2.3.orig.tar.gz 3830 SHA512:d86ce7e816b726584a90ff0d9cc75fa0b7d9e3df151926d13d4e2a6d664e3d0a6fd7778275960c6bf72efff9aad5bac3bf00bdc5a38a12b89fcfa63ca829a768
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-string-width/node-string-width_4.2.3%2b%7ecs13.2.3-1.debian.tar.xz' node-string-width_4.2.3+~cs13.2.3-1.debian.tar.xz 4436 SHA512:9dd146d8950414f08e455e9fe93c9118d6a0d998ca66862149a2ad7b05f8b1fb37905c8b4746ddce92d789e9c270cf0e39c89edd8737a34cedbd2924af3b7d01
```

### `dpkg` source package: `node-strip-ansi=6.0.1-1`

Binary Packages:

- `node-strip-ansi=6.0.1-1`

Licenses: (parsed from: `/usr/share/doc/node-strip-ansi/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-strip-ansi=6.0.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-strip-ansi/node-strip-ansi_6.0.1-1.dsc' node-strip-ansi_6.0.1-1.dsc 2124 SHA512:e1792c91fdccbb7dcb98453af2c3e783b139bb50c4a77db90811d08057d7dc62ee650912a4740131480e2842f98e9dccb3a75dbb362c39aa0c99e5379df57364
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-strip-ansi/node-strip-ansi_6.0.1.orig.tar.gz' node-strip-ansi_6.0.1.orig.tar.gz 3026 SHA512:c4fb7143dd3f51e83bfa210d4bff75976ccd640ca38954ed832c85defa98e215e992faf4db25aa4243b3ba227cf4443959c13e9d1b8e6c04d5b815d34f6eb76c
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-strip-ansi/node-strip-ansi_6.0.1-1.debian.tar.xz' node-strip-ansi_6.0.1-1.debian.tar.xz 3200 SHA512:5e9ac2f369652b346afb71fe2a89bd9cbaf6423b42858c8df5eb809ddd3dadfbaee52e5bcfad62f6c3f9e60b531c465c98eaf7db11e0e0c897b3f90e7a073d1d
```

### `dpkg` source package: `node-supports-color=8.1.1+~8.1.1-1`

Binary Packages:

- `node-supports-color=8.1.1+~8.1.1-1`

Licenses: (parsed from: `/usr/share/doc/node-supports-color/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-supports-color=8.1.1+~8.1.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-supports-color/node-supports-color_8.1.1%2b%7e8.1.1-1.dsc' node-supports-color_8.1.1+~8.1.1-1.dsc 2574 SHA512:b8552836c5ab83b92335b1b703bbdda4655dbd7ac2c99497df5aaa60ae6a2a114c83d0f31ba6b18031b4af4b86e16a14db6bfbb43363e083cca130404133559d
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-supports-color/node-supports-color_8.1.1%2b%7e8.1.1.orig-types-supports-color.tar.gz' node-supports-color_8.1.1+~8.1.1.orig-types-supports-color.tar.gz 1962 SHA512:74f5a75ac7fe933206d78d01f33db0ddfaf90f4dd32d66ce005425e39c54a48def722cde5eb88d47955891667e59332c507a99f5796dde1af118d00d1723507f
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-supports-color/node-supports-color_8.1.1%2b%7e8.1.1.orig.tar.gz' node-supports-color_8.1.1+~8.1.1.orig.tar.gz 6066 SHA512:2ae59dfbac6e6ce0214172fa8a0f8425bb4a2a7d090c81c3ad68efebe4f1cfdaa371dc6cd9566e5accf0f26c4d610947f5fcafb666be011371f41c662a338a3c
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-supports-color/node-supports-color_8.1.1%2b%7e8.1.1-1.debian.tar.xz' node-supports-color_8.1.1+~8.1.1-1.debian.tar.xz 3284 SHA512:a759e50d7cdb7845fc1917d88d1d400c8bc9175e2fa8f9afc3f03e06498887fe5eaa5a556e09999372616130bf9df349bc14d3d452842831a9bb0fd6f3c2d235
```

### `dpkg` source package: `node-tar=6.1.11+ds1+~cs6.0.6-1`

Binary Packages:

- `node-tar=6.1.11+ds1+~cs6.0.6-1`

Licenses: (parsed from: `/usr/share/doc/node-tar/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-tar=6.1.11+ds1+~cs6.0.6-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-tar/node-tar_6.1.11%2bds1%2b%7ecs6.0.6-1.dsc' node-tar_6.1.11+ds1+~cs6.0.6-1.dsc 2930 SHA512:5354fd59390d722e8178aa8073e434c8dd798099181ce4f3c6252dffc99e44dce2af83dcdf021d440af682405942ff3d8d8e035e6f5521b48038df078d3335e9
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-tar/node-tar_6.1.11%2bds1%2b%7ecs6.0.6.orig-fs-minipass.tar.gz' node-tar_6.1.11+ds1+~cs6.0.6.orig-fs-minipass.tar.gz 34966 SHA512:f8743bce8fc8324476f543b949853695d16adc738565407bcb8978a3f35ada7de77e1804ed95e901d2d5e1de81669c3f306121294e7165a5d8d80473a1bde459
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-tar/node-tar_6.1.11%2bds1%2b%7ecs6.0.6.orig-types-tar.tar.gz' node-tar_6.1.11+ds1+~cs6.0.6.orig-types-tar.tar.gz 6515 SHA512:720c0f84d11a6c7699718232e7178cb6ec761266018ad7ea11c781522dade7e113cb8756ea4b30b7a597e3e1ea2de8a228ea38d845db1a20e6549db1faf8b7ed
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-tar/node-tar_6.1.11%2bds1%2b%7ecs6.0.6.orig.tar.gz' node-tar_6.1.11+ds1+~cs6.0.6.orig.tar.gz 225903 SHA512:addc05132e913b5777bb9052ee01773f1d1c6eb19f77026c2eeeb881829566e50aae205b1770ff9b88b41863bcb7c866526119ca2ea8640b0d3667e724e34b9a
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-tar/node-tar_6.1.11%2bds1%2b%7ecs6.0.6-1.debian.tar.xz' node-tar_6.1.11+ds1+~cs6.0.6-1.debian.tar.xz 7640 SHA512:177be0e7415de31611fcc2a85f7f3711c1a2410f3c32977b88043b783a6d1a88a2d515abe7db47b9e98289ffeb4edcde1c89f6bf0a923cf452af113b4a8af0bf
```

### `dpkg` source package: `node-text-table=0.2.0-4`

Binary Packages:

- `node-text-table=0.2.0-4`

Licenses: (parsed from: `/usr/share/doc/node-text-table/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-text-table=0.2.0-4
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-text-table/node-text-table_0.2.0-4.dsc' node-text-table_0.2.0-4.dsc 2064 SHA512:2949a396c8ac04ea44d159d32362ce14d9c1e90fb8eadf2362bcb153aad1fce17bee46a99c678127aba336f846e90cc44fb46264bb65f5f7fe9c4b99181db794
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-text-table/node-text-table_0.2.0.orig.tar.gz' node-text-table_0.2.0.orig.tar.gz 3937 SHA512:c60261026eb1c393279bc03c167d8fd9f04ee32510ccd9fef87ae99ecff2541278dbf3ccd84582c901d579e9cb2d3e5ed22fd439d487cff1f58fa51aef5bb765
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-text-table/node-text-table_0.2.0-4.debian.tar.xz' node-text-table_0.2.0-4.debian.tar.xz 2616 SHA512:092a74772f9db3b40f19bbb3e85227bb5f56f8f8ecb63cc7a2d40f923b65b1786d4d7dc999995adf02284253de62906a525aa1419a43ce0f07178a17b91eba33
```

### `dpkg` source package: `node-time-stamp=2.2.0-1`

Binary Packages:

- `node-time-stamp=2.2.0-1`

Licenses: (parsed from: `/usr/share/doc/node-time-stamp/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-time-stamp=2.2.0-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-time-stamp/node-time-stamp_2.2.0-1.dsc' node-time-stamp_2.2.0-1.dsc 2053 SHA512:963e814b6d304b45590b6023c6056eb057245e3fd2a9c5f46860519f6f94b569782b51d096218a830b2f031d9cd4df6f5f9305d68ecf94cd985430c06a6a0d1e
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-time-stamp/node-time-stamp_2.2.0.orig.tar.gz' node-time-stamp_2.2.0.orig.tar.gz 3880 SHA512:cf191ef20a0942905e1200fcd825c005e321d0b489723ec25c47743873a0e391e07287c5ee9c4dc199bdf91927a71a43870378805a724a402929f1587d142750
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-time-stamp/node-time-stamp_2.2.0-1.debian.tar.xz' node-time-stamp_2.2.0-1.debian.tar.xz 2484 SHA512:d02f89b3699a4bebb953b7f165b33fc53f36b58590dcc9f6b42795c322d4b62fb90bb5ef891c608fcb6b7f8744d42067737aca912e7362aba3d08c297610592b
```

### `dpkg` source package: `node-tslib=2.3.1-2`

Binary Packages:

- `node-tslib=2.3.1-2`

Licenses: (parsed from: `/usr/share/doc/node-tslib/copyright`)

- `Apache-2.0`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-tslib=2.3.1-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-tslib/node-tslib_2.3.1-2.dsc' node-tslib_2.3.1-2.dsc 2026 SHA512:889ca10d1ab29580382db7259783d7151252698b73a2da46f2a57362507e123364747d872e085050eb7ecab5d8b4e64c7bcc93a73351f64d5dce6934b7d5764d
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-tslib/node-tslib_2.3.1.orig.tar.gz' node-tslib_2.3.1.orig.tar.gz 17080 SHA512:2f05904bcf38c1112340de2e1dfa7341d084d67124bd13cc63779d38b3748d532f4c95f2845d55b58312ddb56be2828bc712105255fd9a25054dd8628dc01ca2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-tslib/node-tslib_2.3.1-2.debian.tar.xz' node-tslib_2.3.1-2.debian.tar.xz 2992 SHA512:0600c2443d63a16f34e440845528bb25ed0d69608b7d55a06b74590d09884b3825a04970f23e5b636ef37e555031255667b3ef61e5c269f486c5c0c0669841ab
```

### `dpkg` source package: `node-typedarray-to-buffer=4.0.0-2`

Binary Packages:

- `libjs-typedarray-to-buffer=4.0.0-2`
- `node-typedarray-to-buffer=4.0.0-2`

Licenses: (parsed from: `/usr/share/doc/libjs-typedarray-to-buffer/copyright`, `/usr/share/doc/node-typedarray-to-buffer/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-typedarray-to-buffer=4.0.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-typedarray-to-buffer/node-typedarray-to-buffer_4.0.0-2.dsc' node-typedarray-to-buffer_4.0.0-2.dsc 2284 SHA512:fd89f9c1fa6d0f5e704e3b91984624efdb262c027e1bff302058df19c0dcf9c69d188be2dce71dfeccaa7c2084655813aa370cbc5fff80be148dbbe9de215566
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-typedarray-to-buffer/node-typedarray-to-buffer_4.0.0.orig.tar.gz' node-typedarray-to-buffer_4.0.0.orig.tar.gz 3817 SHA512:092ad411ed2a0508ae667676a3ee350be958ec009d6f4cc355093dddb1fbd5f3ccf75558f0882105b5ab25001c707b4682ac62a0bae0e4943d6c1df6bc354e94
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-typedarray-to-buffer/node-typedarray-to-buffer_4.0.0-2.debian.tar.xz' node-typedarray-to-buffer_4.0.0-2.debian.tar.xz 3292 SHA512:a3138107ca7a366328de00c170c569e9bf1682a54284d7e25bc7d57daf13619b9418a69dd8aab7133a6356c8a81c1b7edf1e021fdddfc624c82590c08525821a
```

### `dpkg` source package: `node-unique-filename=1.1.1+ds-1`

Binary Packages:

- `node-unique-filename=1.1.1+ds-1`

Licenses: (parsed from: `/usr/share/doc/node-unique-filename/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-unique-filename=1.1.1+ds-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-unique-filename/node-unique-filename_1.1.1%2bds-1.dsc' node-unique-filename_1.1.1+ds-1.dsc 2500 SHA512:4f3b6e27e49c308b96ab0ea438b80e31f1f102f35f7daff58b056baf3dc9c2a1ac8094ef115251cbaed8274b582999b9385dc9b324b16ac305d263f92c84b4f1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-unique-filename/node-unique-filename_1.1.1%2bds.orig-unique-slug.tar.xz' node-unique-filename_1.1.1+ds.orig-unique-slug.tar.xz 30716 SHA512:422ec6dc22bbbc0e59bdde4f4fa748a3bb5be77fdd02911313dc936fffec62b3487e590459d9ff79770655b4ed2168db34cc9576fe5b65388e20d440b0a4b945
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-unique-filename/node-unique-filename_1.1.1%2bds.orig.tar.xz' node-unique-filename_1.1.1+ds.orig.tar.xz 2116 SHA512:7ac88f733d11926e865cc254969e1ed474a4bbbfe13dc2a26d389539a6d73aa2d2703374f2e8d54991cb69945b8acb20ca387a466b5ae15c347a9aa8ebbdf28c
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-unique-filename/node-unique-filename_1.1.1%2bds-1.debian.tar.xz' node-unique-filename_1.1.1+ds-1.debian.tar.xz 2428 SHA512:b56ed46abc0763403b6079dc60fe070d99fd65b6eeea512cf63466e7c3372384f6cc33b6eab736e4971130f634936fa153d42628f5ddd8b4251ecd4295ec5086
```

### `dpkg` source package: `node-util-deprecate=1.0.2-3`

Binary Packages:

- `node-util-deprecate=1.0.2-3`

Licenses: (parsed from: `/usr/share/doc/node-util-deprecate/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-util-deprecate=1.0.2-3
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-util-deprecate/node-util-deprecate_1.0.2-3.dsc' node-util-deprecate_1.0.2-3.dsc 2144 SHA512:4e8dcc16d386fb464f30041132e3b8d2f1fbddd3429bce39db0f2b6e06b6a13b7c8b040aa6f68467fb4bc6635523bcd4dc4ff4243d90db2554606a4bbb8a2332
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-util-deprecate/node-util-deprecate_1.0.2.orig.tar.gz' node-util-deprecate_1.0.2.orig.tar.gz 2391 SHA512:999658328c63a4ae965d3f6f580b2bcca96dc725b1feb70f0e8d4350abf78c9752f55c4b9e24e093ab7533d50bd1541eea52b45a227ec40ed4e70576851ad56d
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-util-deprecate/node-util-deprecate_1.0.2-3.debian.tar.xz' node-util-deprecate_1.0.2-3.debian.tar.xz 2760 SHA512:103460d3aa4103eb4f1c37d1f0cc317118ea425d02e123e41c1ca3ac938abe3448e323c72ffa2021652fe755691259205427c16cad6d0f5a62b03098134e1127
```

### `dpkg` source package: `node-validate-npm-package-license=3.0.4-2`

Binary Packages:

- `node-validate-npm-package-license=3.0.4-2`

Licenses: (parsed from: `/usr/share/doc/node-validate-npm-package-license/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris node-validate-npm-package-license=3.0.4-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-validate-npm-package-license/node-validate-npm-package-license_3.0.4-2.dsc' node-validate-npm-package-license_3.0.4-2.dsc 2337 SHA512:1ad4491505fc87e59a27c48d50ab5ea57f0068c7e1538d2fa3bb318a588b2f8ea6fabd70687ee60914ba6f676f3adcdb394d9c63e351e492f34f5362bdeb57e5
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-validate-npm-package-license/node-validate-npm-package-license_3.0.4.orig.tar.gz' node-validate-npm-package-license_3.0.4.orig.tar.gz 7045 SHA512:81745b35d9fc874af59f6a38d476a8223a838cb43375fa32ec9e53a504809f69afdc16611b4d0f4b447bc8dc4d7d13e6e27a1412c496078cb1fea83fe39f7757
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-validate-npm-package-license/node-validate-npm-package-license_3.0.4-2.debian.tar.xz' node-validate-npm-package-license_3.0.4-2.debian.tar.xz 2460 SHA512:35bec344fe5428f3dc018dee0e4159a1e207ee878b065cb90445802e31e67e09fa2f818ba5903ea036a13890a435d40e14cd5f72c5a8ff218b6c1f4cc06c9b71
```

### `dpkg` source package: `node-validate-npm-package-name=3.0.0-4`

Binary Packages:

- `node-validate-npm-package-name=3.0.0-4`

Licenses: (parsed from: `/usr/share/doc/node-validate-npm-package-name/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-validate-npm-package-name=3.0.0-4
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-validate-npm-package-name/node-validate-npm-package-name_3.0.0-4.dsc' node-validate-npm-package-name_3.0.0-4.dsc 2276 SHA512:1b52e4b749a4bc370c277ffbbe874182bbea9d9d3b761ccd76498d0c72619b7b603cd50dca3982531db9ebdd7a5d4b05d2d2237e583d79dd095f9af7adb9542c
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-validate-npm-package-name/node-validate-npm-package-name_3.0.0.orig.tar.gz' node-validate-npm-package-name_3.0.0.orig.tar.gz 3795 SHA512:b9803f36a9718bfe8c7ee2a22c04ac19792109a03f4a35605027ebde1357b06b99b4a1c315c0ea3042a99b06b546915a06e39da69b8f4c1211b5d3f4d992a18e
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-validate-npm-package-name/node-validate-npm-package-name_3.0.0-4.debian.tar.xz' node-validate-npm-package-name_3.0.0-4.debian.tar.xz 2788 SHA512:27912caddabe58a541dd7084b29978e782a286be1724fa63f6658efe53bce0a67b0daae186c75252971656a7ec3d643effb189155516647a8ee0dd8090937fc5
```

### `dpkg` source package: `node-wcwidth.js=1.0.2-1`

Binary Packages:

- `node-wcwidth.js=1.0.2-1`

Licenses: (parsed from: `/usr/share/doc/node-wcwidth.js/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-wcwidth.js=1.0.2-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-wcwidth.js/node-wcwidth.js_1.0.2-1.dsc' node-wcwidth.js_1.0.2-1.dsc 2087 SHA512:77f1cd2042f844ef773b95809e0f28eb3e433466cff41646108bb98e81f758fc20095b890d136814b186af66b10d327d8d6173459688a5f002dae2b93b64cea9
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-wcwidth.js/node-wcwidth.js_1.0.2.orig.tar.gz' node-wcwidth.js_1.0.2.orig.tar.gz 10522 SHA512:c0332b899b84a9c7fde0afc60f3dbfbb82175cc8c1aa0a687010203d9bd956307b97722008e276ef5e97ac203ff7a0d671da3278bada8684a7044fceac27ff76
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-wcwidth.js/node-wcwidth.js_1.0.2-1.debian.tar.xz' node-wcwidth.js_1.0.2-1.debian.tar.xz 2836 SHA512:2dd88261d0a18e15cff71d70ebe44327726e35457a5f8823ddc2da79e937bdc331fa32869cafd430ff780116f9f6e91524995ae7e1d4e9039827c1576b894ba1
```

### `dpkg` source package: `node-whatwg-fetch=3.6.2-5`

Binary Packages:

- `node-whatwg-fetch=3.6.2-5`

Licenses: (parsed from: `/usr/share/doc/node-whatwg-fetch/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-whatwg-fetch=3.6.2-5
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-whatwg-fetch/node-whatwg-fetch_3.6.2-5.dsc' node-whatwg-fetch_3.6.2-5.dsc 2082 SHA512:b1b3da6986d0a6a5fd06ee92667d435a2977d135ee10e8f112f3b850d7aa68e3a82f2584a635be5c263d21d0ae5494249ab22411991bf6027d084a39015fdca3
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-whatwg-fetch/node-whatwg-fetch_3.6.2.orig.tar.gz' node-whatwg-fetch_3.6.2.orig.tar.gz 23112 SHA512:ee2db300d7da0916e47c8660f44704b9be9322af988a51e6ba04023e318310da924e4e84feb03b8ba1acdf1244a2c0f8fc2631e2380e9bc9146dda7d8edc456a
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-whatwg-fetch/node-whatwg-fetch_3.6.2-5.debian.tar.xz' node-whatwg-fetch_3.6.2-5.debian.tar.xz 2716 SHA512:4f6d6913ddf97bb2f7f0610dc3c49e6c33df5f3603b9a4dd1c6bbc21f31fb5f1712fa1c1692f08cd20f7abf9afca6ec26c62bc639ed24c25201b03967be6a6a8
```

### `dpkg` source package: `node-which=2.0.2+~cs1.3.2-2`

Binary Packages:

- `node-which=2.0.2+~cs1.3.2-2`

Licenses: (parsed from: `/usr/share/doc/node-which/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-which=2.0.2+~cs1.3.2-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-which/node-which_2.0.2%2b%7ecs1.3.2-2.dsc' node-which_2.0.2+~cs1.3.2-2.dsc 2453 SHA512:d2ee55bb3e0dd925251d10682109cfea6b1a5426ba0e7156f71004636b6ddd26da8bd183f6d84ccb7718f7fbf0c884bce29349867f9843f2f676b3b48a3ad6e9
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-which/node-which_2.0.2%2b%7ecs1.3.2.orig-types-which.tar.gz' node-which_2.0.2+~cs1.3.2.orig-types-which.tar.gz 2099 SHA512:f280eac8b0bb783e07337d3b6e87b64162b2bb37735818f9eb123f8a64a5d9ca4bf94ded08c693024309e1e7b924167f16c38996f4467884a18990c0975a8444
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-which/node-which_2.0.2%2b%7ecs1.3.2.orig.tar.gz' node-which_2.0.2+~cs1.3.2.orig.tar.gz 35404 SHA512:69ea43103fffaf1e732bb8214a9d7d36e32a60b6af4be85e02231350bc028ab3a0a8a410e61b191e98363a8dffc9d1772c605d814bee050659a77b3347659bd6
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-which/node-which_2.0.2%2b%7ecs1.3.2-2.debian.tar.xz' node-which_2.0.2+~cs1.3.2-2.debian.tar.xz 3928 SHA512:3f4048ba89fac900baab385838754c7dcdbd34d264701a7b7ffb5ccca6b2faa3a7ed34b82bdb51ff90a639ece172263ba55416133f8942cf8b22b1abf0d0f2c3
```

### `dpkg` source package: `node-wide-align=1.1.3-4`

Binary Packages:

- `node-wide-align=1.1.3-4`

Licenses: (parsed from: `/usr/share/doc/node-wide-align/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-wide-align=1.1.3-4
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-wide-align/node-wide-align_1.1.3-4.dsc' node-wide-align_1.1.3-4.dsc 2106 SHA512:9701b5c9e5e3bd1ee6a479cf2e1fec99d82423cc2e8baef325dae435ea61a83b8dc8ba89daf51b8395652da4803816f764a8a9251b38af2b0480ddf26e583132
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-wide-align/node-wide-align_1.1.3.orig.tar.gz' node-wide-align_1.1.3.orig.tar.gz 18294 SHA512:b367867a18aeb657e2897d78227557b554bada4cd712ef96a3b6b4dca8797757b8743a7d48265f7899bbb8674e953c0d7161273b4120886e9047ffd97f4ccba4
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-wide-align/node-wide-align_1.1.3-4.debian.tar.xz' node-wide-align_1.1.3-4.debian.tar.xz 2632 SHA512:098262e132fe2a1f10bd0a2208657490129c7daa433130d13bc54356ef59f3fe8c5415a3f0dda1dcb1db18dafd2641aa213c9d618ee327704799c7ab8a15e335
```

### `dpkg` source package: `node-wrappy=1.0.2-2`

Binary Packages:

- `node-wrappy=1.0.2-2`

Licenses: (parsed from: `/usr/share/doc/node-wrappy/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-wrappy=1.0.2-2
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-wrappy/node-wrappy_1.0.2-2.dsc' node-wrappy_1.0.2-2.dsc 2019 SHA512:f279f9e58d650cccf2ab4c12847aa502682c064422c253bd3ab03956170ac8ae18a65e55c99563f5dc7d9ffa01c24657ae533c7d977e057d528bac3d0b24f3dd
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-wrappy/node-wrappy_1.0.2.orig.tar.gz' node-wrappy_1.0.2.orig.tar.gz 2338 SHA512:d7c4f7de526398f941d4c5ee3dfa112f35746abae242b9ae46069d2784d38b2f28b7e3a86acdae7738db2a81d9d39ef582707c0012de660cc264e89d9bd3ada7
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-wrappy/node-wrappy_1.0.2-2.debian.tar.xz' node-wrappy_1.0.2-2.debian.tar.xz 2500 SHA512:0ddc34ba2dd31935a13fe8c844aadbb4ca0468d05d7a346c39c783fd6d154bc85ca6990e5fe5daf157b0f7a5a4710ef09d40b38c58900874b2e0ab3fc3187cca
```

### `dpkg` source package: `node-write-file-atomic=3.0.3+~3.0.2-1`

Binary Packages:

- `node-write-file-atomic=3.0.3+~3.0.2-1`

Licenses: (parsed from: `/usr/share/doc/node-write-file-atomic/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-write-file-atomic=3.0.3+~3.0.2-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-write-file-atomic/node-write-file-atomic_3.0.3%2b%7e3.0.2-1.dsc' node-write-file-atomic_3.0.3+~3.0.2-1.dsc 2782 SHA512:7729f948ab09a522d75869b4e2a3db47da86824441e1ab11afe579c2810ffe6aba0b620eddecb7bc9c3babdc0882844ecbea2828a194ae8fc7aa67268ab7abcb
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-write-file-atomic/node-write-file-atomic_3.0.3%2b%7e3.0.2.orig-types-write-file-atomic.tar.gz' node-write-file-atomic_3.0.3+~3.0.2.orig-types-write-file-atomic.tar.gz 1929 SHA512:7533fc2f749aa9b7264046de0dc3439efe2f51707b762d76e42d96b39c355213c8802e217dae7868ec441ce49491d4d258d278725a462db37d2c75f8a9a036ae
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-write-file-atomic/node-write-file-atomic_3.0.3%2b%7e3.0.2.orig.tar.gz' node-write-file-atomic_3.0.3+~3.0.2.orig.tar.gz 50641 SHA512:f9d2db690d29b832b36e92a20b2c687d6ae45c843043676a7182f36718919014e73159961efd43400232148123ee86a13c8a9b5a838f606f46c4d4435a68e0dc
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-write-file-atomic/node-write-file-atomic_3.0.3%2b%7e3.0.2-1.debian.tar.xz' node-write-file-atomic_3.0.3+~3.0.2-1.debian.tar.xz 3276 SHA512:65792ba42a1eb3048b7242293e218d4996a0738018a035d51d3e63529ca2654e330da47babcd2d55d3625c61a3816183469bf768bc8d3e7e6c2b61461bdb21f1
```

### `dpkg` source package: `node-yallist=4.0.0+~4.0.1-1`

Binary Packages:

- `node-yallist=4.0.0+~4.0.1-1`

Licenses: (parsed from: `/usr/share/doc/node-yallist/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-yallist=4.0.0+~4.0.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-yallist/node-yallist_4.0.0%2b%7e4.0.1-1.dsc' node-yallist_4.0.0+~4.0.1-1.dsc 2410 SHA512:8baa89172e1706314384bc5875c5928b54b2d23b000bb73909406d0b4d548ec8185226f74906296a767edc0c4fb2c5484b41e4aca7b694dba3544b690130d1a6
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-yallist/node-yallist_4.0.0%2b%7e4.0.1.orig-types-yallist.tar.gz' node-yallist_4.0.0+~4.0.1.orig-types-yallist.tar.gz 2108 SHA512:1b714d25f698b4df14454eb077afaec0523ad8a3bbf63ee7dd74d87307059dc3fc8247e88b46fcdb51a8555b74a2a2959c2a8a60e30d2881a96a43e8161cc018
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-yallist/node-yallist_4.0.0%2b%7e4.0.1.orig.tar.gz' node-yallist_4.0.0+~4.0.1.orig.tar.gz 22636 SHA512:204189d2176cd569d1d7902c8bcfda5f7d5591d658693e0ccd794b05ce82691610f8d32d7a76e0a4148d9ed155cc98b9dddd5ce089b48d9d74799797efb79b0f
'http://archive.ubuntu.com/ubuntu/pool/universe/n/node-yallist/node-yallist_4.0.0%2b%7e4.0.1-1.debian.tar.xz' node-yallist_4.0.0+~4.0.1-1.debian.tar.xz 3392 SHA512:4471e895fe38898f3aa0168457053cc28247d05b37b919543d2ebe46b41d640bb6869ad2e3e276ba4111366d88aa237b352ad9b37c73cca6a2bbc0b57d950003
```

### `dpkg` source package: `nodejs=12.22.9~dfsg-1ubuntu3.6`

Binary Packages:

- `libnode-dev=12.22.9~dfsg-1ubuntu3.6`
- `libnode72:amd64=12.22.9~dfsg-1ubuntu3.6`
- `nodejs=12.22.9~dfsg-1ubuntu3.6`

Licenses: (parsed from: `/usr/share/doc/libnode-dev/copyright`, `/usr/share/doc/libnode72/copyright`, `/usr/share/doc/nodejs/copyright`)

- `Apache-2.0`
- `BSD-1-clause`
- `BSD-2-clause~author`
- `BSD-2-clause~holders`
- `BSD-3-clause~Google`
- `BSD-3-clause~Intel`
- `BSD-3-clause~Sun`
- `BSD-3-clause~author`
- `BSD-3-clause~contributors`
- `BSD-3-clause~holders`
- `BSD-4-clause~author`
- `CC0`
- `CC0-1.0`
- `Expat`
- `Expat~Wu`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `ISC`
- `ISC-no-disclaim`
- `MIT/X11`
- `MIT~Prototype`
- `MPL-2.0`
- `NTP~MIT`
- `OpenSSL`
- `Python`
- `SSLeay`
- `W3C-Test-Suite`
- `curl`
- `zlib`

Source:

```console
$ apt-get source -qq --print-uris nodejs=12.22.9~dfsg-1ubuntu3.6
'http://archive.ubuntu.com/ubuntu/pool/universe/n/nodejs/nodejs_12.22.9%7edfsg-1ubuntu3.6.dsc' nodejs_12.22.9~dfsg-1ubuntu3.6.dsc 3545 SHA512:28deffd24685e3e5272c5b4f33e50803511df1639ee2744b5dbe15a1e513bef545676d1f9535c673e21542287eb850a59bffff56cf9355d5823dbb7fa7415a51
'http://archive.ubuntu.com/ubuntu/pool/universe/n/nodejs/nodejs_12.22.9%7edfsg.orig-types-node.tar.xz' nodejs_12.22.9~dfsg.orig-types-node.tar.xz 86416 SHA512:ff967a05831a1a43c3bcf96744007713b51c279ee1b2b77075f8476b5791e28cc212511dc64c34e6c7d516865fd7f3cd7150c1664e664ada4e7c64f8b40fbcfc
'http://archive.ubuntu.com/ubuntu/pool/universe/n/nodejs/nodejs_12.22.9%7edfsg.orig.tar.xz' nodejs_12.22.9~dfsg.orig.tar.xz 19022540 SHA512:83002dbabb3228fd9b1b9777246b2b8aebb6ba7ead005c1c65124a5809fdde7d9d9aa47d907e9a6fdf452e0febfa4c6e521c5d62ae8d6100454ba57f16110eb7
'http://archive.ubuntu.com/ubuntu/pool/universe/n/nodejs/nodejs_12.22.9%7edfsg-1ubuntu3.6.debian.tar.xz' nodejs_12.22.9~dfsg-1ubuntu3.6.debian.tar.xz 169660 SHA512:aa96bacab25f631b6f8c0b7a93fea90e81873a23249b18962b257f0187478b8e34be4aaccea082b0a53b6ae37d1538df80f1e68def8aa4a4159f74c7bfba4273
```

### `dpkg` source package: `npm=8.5.1~ds-1`

Binary Packages:

- `npm=8.5.1~ds-1`

Licenses: (parsed from: `/usr/share/doc/npm/copyright`)

- `Apache-2.0`
- `Artistic-2.0`
- `BSD-2-Clause`
- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris npm=8.5.1~ds-1
'http://archive.ubuntu.com/ubuntu/pool/universe/n/npm/npm_8.5.1%7eds-1.dsc' npm_8.5.1~ds-1.dsc 3551 SHA512:c80d2ef72f6adbb6b72c00e4d5d16dd6f4d60d52c25d2b545d8c7ca51db0a6d72419b742f971950474eb7e53f053bdcc3066a59959717b0a53b99cf542794110
'http://archive.ubuntu.com/ubuntu/pool/universe/n/npm/npm_8.5.1%7eds.orig.tar.xz' npm_8.5.1~ds.orig.tar.xz 67752696 SHA512:8e92f6ccd9a4011b42bef4fe59ee9eeb0f44f27bfe84f3d8cd8118a77afb395b31099bdf0f60be5d69b8e7ef291b12b429b452dfa7a8d10cfe96475db976cbf7
'http://archive.ubuntu.com/ubuntu/pool/universe/n/npm/npm_8.5.1%7eds-1.debian.tar.xz' npm_8.5.1~ds-1.debian.tar.xz 27640 SHA512:539175b4568b0d4c0491d4f81f9cdb44a61fa898efd7f8a9397a746cfed178c60a3d893abbcd018b49e665a0c05bd26010c8e3dc724c520527f4e05c2999ba0e
```

### `dpkg` source package: `npth=1.6-3build2`

Binary Packages:

- `libnpth0:amd64=1.6-3build2`

Licenses: (parsed from: `/usr/share/doc/libnpth0/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris npth=1.6-3build2
'http://archive.ubuntu.com/ubuntu/pool/main/n/npth/npth_1.6-3build2.dsc' npth_1.6-3build2.dsc 2063 SHA512:19ea7bd0ffc2b0aff06c52298c9a25c2f30619239bea09b571feb4a3d162f461a4529136e351da42b16ab3eaef5add24234f644e822e859ccb32de5bfd658ec0
'http://archive.ubuntu.com/ubuntu/pool/main/n/npth/npth_1.6.orig.tar.bz2' npth_1.6.orig.tar.bz2 300486 SHA512:2ed1012e14a9d10665420b9a23628be7e206fd9348111ec751349b93557ee69f1176bcf7e6b195b35b1c44a5e0e81ee33b713f03d79a33d1ecd9037035afeda2
'http://archive.ubuntu.com/ubuntu/pool/main/n/npth/npth_1.6-3build2.debian.tar.xz' npth_1.6-3build2.debian.tar.xz 10904 SHA512:426ab3ab9e27b3701d67cde0a4c4040aa9ccac22a0266321824487fe80a118ccd6860b6fa0fb5ca3c46dfa3c20053889fbb51a2e74618065b3aff059a0216c4c
```

### `dpkg` source package: `odoo=17.0.20241029`

Binary Packages:

- `odoo=17.0.20241029`

Licenses: (parsed from: `/usr/share/doc/odoo/copyright`)

- `Apache-2.0`
- `BSD-2`
- `BSD-3`
- `DWTFYW`
- `LGPL-3`
- `LGPL-3+`
- `MIT`
- `OFL-1.1`
- `PSF`
- `SIL-Open-Font-License`
- `SIL-Open-Font-License `

**WARNING:** unable to find source (`apt-get source` failed or returned no results)!  
This is *usually* due to a new package version being released and the old version being removed.


### `dpkg` source package: `openjpeg2=2.4.0-6ubuntu0.1`

Binary Packages:

- `libopenjp2-7:amd64=2.4.0-6ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/libopenjp2-7/copyright`)

- `BSD-2`
- `BSD-3`
- `LIBPNG`
- `LIBTIFF`
- `LIBTIFF-GLARSON`
- `LIBTIFF-PIXAR`
- `MIT`
- `ZLIB`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris openjpeg2=2.4.0-6ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/o/openjpeg2/openjpeg2_2.4.0-6ubuntu0.1.dsc' openjpeg2_2.4.0-6ubuntu0.1.dsc 2738 SHA512:23e7192fa6fb7db5e499d635b76ba941c6e12abdec502e38b610c35b1f04219363bb289a3bb0f4251b94933d2a1ae8fd1baaad9b7a9bc0e859253224c11d2cc1
'http://archive.ubuntu.com/ubuntu/pool/main/o/openjpeg2/openjpeg2_2.4.0.orig.tar.xz' openjpeg2_2.4.0.orig.tar.xz 1396964 SHA512:717ead13e0805d52138bedef1a77d51b676c5a2b882ca7f2206b665b3ba5ea2b435fd81c09780e6c1f14400a49c82fcd1eb2cbea1e1d207b541e98797ecd684f
'http://archive.ubuntu.com/ubuntu/pool/main/o/openjpeg2/openjpeg2_2.4.0-6ubuntu0.1.debian.tar.xz' openjpeg2_2.4.0-6ubuntu0.1.debian.tar.xz 22060 SHA512:68fd0bb87e131036e5263f81d2d12faf3507c7776faf99f3703b270cdc7d18cc7f8b27c6ed5a06948dbbe1084457badee8b1c9d745a3c1ac2f1a04ca6a906be4
```

### `dpkg` source package: `openldap=2.5.18+dfsg-0ubuntu0.22.04.2`

Binary Packages:

- `libldap-2.5-0:amd64=2.5.18+dfsg-0ubuntu0.22.04.2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris openldap=2.5.18+dfsg-0ubuntu0.22.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/o/openldap/openldap_2.5.18%2bdfsg-0ubuntu0.22.04.2.dsc' openldap_2.5.18+dfsg-0ubuntu0.22.04.2.dsc 3319 SHA512:b487516e28201e7d879487ad9b6dab1eb1d5eb6a241394e5fc518fdbc1e0b29062d15df3b393dd7bf72113c389d482d26c6937a22e40a7d78c7c6f73bc19944c
'http://archive.ubuntu.com/ubuntu/pool/main/o/openldap/openldap_2.5.18%2bdfsg.orig.tar.gz' openldap_2.5.18+dfsg.orig.tar.gz 5623023 SHA512:5f0f71c6711bc8e4b463832d2073d41d92886cdbe3c7a20bca54579c4df30d25de5f388165d975ace600073593502d73a5009ad00f135adc9f1270515fb4ff21
'http://archive.ubuntu.com/ubuntu/pool/main/o/openldap/openldap_2.5.18%2bdfsg-0ubuntu0.22.04.2.debian.tar.xz' openldap_2.5.18+dfsg-0ubuntu0.22.04.2.debian.tar.xz 172632 SHA512:f40e948a37ad373187b6007c033e6cbbd63775b1b424f62f9446a9f35b9b354d0c8a8ae3efe470d63e444af984bb2f28947ebc0521923cb50adc4ea2eba21843
```

### `dpkg` source package: `openssl=3.0.2-0ubuntu1.18`

Binary Packages:

- `libssl-dev:amd64=3.0.2-0ubuntu1.18`
- `libssl3:amd64=3.0.2-0ubuntu1.18`
- `openssl=3.0.2-0ubuntu1.18`

Licenses: (parsed from: `/usr/share/doc/libssl-dev/copyright`, `/usr/share/doc/libssl3/copyright`, `/usr/share/doc/openssl/copyright`)

- `Apache-2.0`
- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris openssl=3.0.2-0ubuntu1.18
'http://archive.ubuntu.com/ubuntu/pool/main/o/openssl/openssl_3.0.2-0ubuntu1.18.dsc' openssl_3.0.2-0ubuntu1.18.dsc 2730 SHA512:063002f9a86d0ab1c1932ded24a4e3624294a560a937a3234d3f0523d19acb8f56be2fe4c452a10aa659250d6026a06ecc4988101e27b79a733833170ba2f651
'http://archive.ubuntu.com/ubuntu/pool/main/o/openssl/openssl_3.0.2.orig.tar.gz' openssl_3.0.2.orig.tar.gz 15038141 SHA512:f986850d5be908b4d6b5fd7091bc4652d7378c9bccebfbc5becd7753843c04c1eb61a1749c432139d263dfac33df0b1f6c773664b485cad47542266823a4eb03
'http://archive.ubuntu.com/ubuntu/pool/main/o/openssl/openssl_3.0.2.orig.tar.gz.asc' openssl_3.0.2.orig.tar.gz.asc 488 SHA512:4303391a58107c76ad9b05510f5bfc95f687f4cb2f9ff5b03fb262ba99b573423ab83f0437471199954496799b343191b889ad9ef8fabdd7ee4ec3ec9b5f1d81
'http://archive.ubuntu.com/ubuntu/pool/main/o/openssl/openssl_3.0.2-0ubuntu1.18.debian.tar.xz' openssl_3.0.2-0ubuntu1.18.debian.tar.xz 263268 SHA512:67e7d3d71428c12fccfeb354ffdbedacb867df025bd222cd4d3796ff37a630ba3adb541f03180aa57511c8c9e4330260f89141bced621dcafc89736c3d33f0b5
```

### `dpkg` source package: `p11-kit=0.24.0-6build1`

Binary Packages:

- `libp11-kit0:amd64=0.24.0-6build1`

Licenses: (parsed from: `/usr/share/doc/libp11-kit0/copyright`)

- `Apache-2.0`
- `BSD-3-Clause`
- `ISC`
- `ISC+IBM`
- `LGPL-2.1`
- `LGPL-2.1+`
- `permissive-like-automake-output`
- `same-as-rest-of-p11kit`

Source:

```console
$ apt-get source -qq --print-uris p11-kit=0.24.0-6build1
'http://archive.ubuntu.com/ubuntu/pool/main/p/p11-kit/p11-kit_0.24.0-6build1.dsc' p11-kit_0.24.0-6build1.dsc 2633 SHA512:510edf53bc83deef34737f3607995e814695930eacb2257013262023d0c21c3180ac782595bbdc530ea89e8dba567d2f44748a9c6713befb3a3e98245896f179
'http://archive.ubuntu.com/ubuntu/pool/main/p/p11-kit/p11-kit_0.24.0.orig.tar.xz' p11-kit_0.24.0.orig.tar.xz 834392 SHA512:48369d6fdae79b8c5a255c821fbdb982f0c649cce07c0d92f0ff0c16322fea8919faa94067cae2efede2da3646c0e69a71a3e399b769dc2327f247bcb113eb3c
'http://archive.ubuntu.com/ubuntu/pool/main/p/p11-kit/p11-kit_0.24.0.orig.tar.xz.asc' p11-kit_0.24.0.orig.tar.xz.asc 833 SHA512:f802c6f42f437d466b008d0c62aedc2f466bcf5bec93a5fbeec183057d22eacd28184198f624972d9df684a663820e77ebdc8d8c0d14533707691b9d69cb9f69
'http://archive.ubuntu.com/ubuntu/pool/main/p/p11-kit/p11-kit_0.24.0-6build1.debian.tar.xz' p11-kit_0.24.0-6build1.debian.tar.xz 23264 SHA512:a858251688a0655411907d5ac2d122efab057c7bc28dcb3970c68412ca699b00234b74373cbd44472e21cd3f43eab239ddd8411f188e4c214c587052bebedd4c
```

### `dpkg` source package: `pam=1.4.0-11ubuntu2.4`

Binary Packages:

- `libpam-modules:amd64=1.4.0-11ubuntu2.4`
- `libpam-modules-bin=1.4.0-11ubuntu2.4`
- `libpam-runtime=1.4.0-11ubuntu2.4`
- `libpam0g:amd64=1.4.0-11ubuntu2.4`

Licenses: (parsed from: `/usr/share/doc/libpam-modules/copyright`, `/usr/share/doc/libpam-modules-bin/copyright`, `/usr/share/doc/libpam-runtime/copyright`, `/usr/share/doc/libpam0g/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris pam=1.4.0-11ubuntu2.4
'http://archive.ubuntu.com/ubuntu/pool/main/p/pam/pam_1.4.0-11ubuntu2.4.dsc' pam_1.4.0-11ubuntu2.4.dsc 2728 SHA512:6f0a003b6b3032683e02e6441bd2d9bcd4e9d9e36d2909bccda271dfdfc09bc0932f54f910c3fefebef49d31a2d95315b9d2cd31ea9793ce67fcb00052dec8d1
'http://archive.ubuntu.com/ubuntu/pool/main/p/pam/pam_1.4.0.orig.tar.xz' pam_1.4.0.orig.tar.xz 988908 SHA512:26eda95c45598a500bc142da4d1abf93d03b3bbb0f2390fa87c72dcbffa208dbfa115c0b411095c31ee9955e36422ccf3e2df3bd486818fafffef8c4310798c4
'http://archive.ubuntu.com/ubuntu/pool/main/p/pam/pam_1.4.0-11ubuntu2.4.debian.tar.xz' pam_1.4.0-11ubuntu2.4.debian.tar.xz 169452 SHA512:b5e0a07d9bc19ea43e9f209ad4a4971de32cee61784477b90162d81f387070efa877462002a51e0806f7d49bcdd6c9a25cdbcc84716f3d75ed8194c9bce642b0
```

### `dpkg` source package: `pango1.0=1.50.6+ds-2ubuntu1`

Binary Packages:

- `libpango-1.0-0:amd64=1.50.6+ds-2ubuntu1`
- `libpangocairo-1.0-0:amd64=1.50.6+ds-2ubuntu1`
- `libpangoft2-1.0-0:amd64=1.50.6+ds-2ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libpango-1.0-0/copyright`, `/usr/share/doc/libpangocairo-1.0-0/copyright`, `/usr/share/doc/libpangoft2-1.0-0/copyright`)

- `Apache-2`
- `Apache-2.0`
- `Bitstream-Vera`
- `CC-BY-SA-3.0`
- `CC-BY-SA-3.0,`
- `CC0-1.0`
- `CC0-1.0,`
- `Chromium-BSD-style`
- `Example`
- `Expat`
- `GPL-2+`
- `GPL-2+,`
- `GPL-2.0`
- `GPL-3.0`
- `GPL-3.0+`
- `GPL-3.0+,`
- `ICU`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2+,`
- `LGPL-2.1`
- `LGPL-2.1+`
- `MPL-1.1`
- `OFL-1.1`
- `TCL`
- `Unicode`

Source:

```console
$ apt-get source -qq --print-uris pango1.0=1.50.6+ds-2ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/p/pango1.0/pango1.0_1.50.6%2bds-2ubuntu1.dsc' pango1.0_1.50.6+ds-2ubuntu1.dsc 3878 SHA512:9fc410945facf39d80ce6db1be2f34776cf0fed318fe1057eaaf23e4077458650bafd48673b4e69fdce2f37c9b53c4a7d0e1b89692c4147198071432c0b67b36
'http://archive.ubuntu.com/ubuntu/pool/main/p/pango1.0/pango1.0_1.50.6%2bds.orig.tar.xz' pango1.0_1.50.6+ds.orig.tar.xz 2673480 SHA512:d7cca72ffe9e0d4b2e85cff5f372177444466e8b794f74bbe3dbd1a3ddce1eecfc0645dd003eb319308131266ed0e484d3212166401abe189eaa462d3f872a41
'http://archive.ubuntu.com/ubuntu/pool/main/p/pango1.0/pango1.0_1.50.6%2bds-2ubuntu1.debian.tar.xz' pango1.0_1.50.6+ds-2ubuntu1.debian.tar.xz 51196 SHA512:6b66a168f4e922ca6dedecfb4dcb9b17fd61bfa0613f386eccbb93e0f1e6f6100711c0732fb4575cfebedfa40f8939de87aab27e3858d8efccadfd48052955fe
```

### `dpkg` source package: `pcre2=10.39-3ubuntu0.1`

Binary Packages:

- `libpcre2-8-0:amd64=10.39-3ubuntu0.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris pcre2=10.39-3ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/p/pcre2/pcre2_10.39-3ubuntu0.1.dsc' pcre2_10.39-3ubuntu0.1.dsc 2142 SHA512:8f062a4ba129491e0ec755f945b84e6e6d252e4d87b87ae0dc46156320095557093f7c3305a31cbca9252a2cbc172d701606030ebdae147eef3fbd5616b4ed99
'http://archive.ubuntu.com/ubuntu/pool/main/p/pcre2/pcre2_10.39.orig.tar.gz' pcre2_10.39.orig.tar.gz 2309964 SHA512:fe17ea0191a91d4e4fe88a44a07883db594941376a6e38556e03ff3b594820596fd3e43be2d73b700ca68cd0c44e38c33cc891a57b8ed65e34cd832196bc09b2
'http://archive.ubuntu.com/ubuntu/pool/main/p/pcre2/pcre2_10.39-3ubuntu0.1.diff.gz' pcre2_10.39-3ubuntu0.1.diff.gz 11214 SHA512:7b8848adbd237351d14e68cf13d26fe0330718d2e807c69b091d2eefdd4c5f4ebde9e3b403d898b52ffcff674eb6bd0ff6995190c1fc42668e4bf8173ded7f14
```

### `dpkg` source package: `pcre3=2:8.39-13ubuntu0.22.04.1`

Binary Packages:

- `libpcre3:amd64=2:8.39-13ubuntu0.22.04.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris pcre3=2:8.39-13ubuntu0.22.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/p/pcre3/pcre3_8.39-13ubuntu0.22.04.1.dsc' pcre3_8.39-13ubuntu0.22.04.1.dsc 2101 SHA512:c2b619e559192c367485fec01cf65dbc49a67ec8f2fb9d5785fdf7dba052540d70c16b4316afc83f4765ef9b57f3e2c0e6f245500866476df8a8a90310584f62
'http://archive.ubuntu.com/ubuntu/pool/main/p/pcre3/pcre3_8.39.orig.tar.bz2' pcre3_8.39.orig.tar.bz2 1560758 SHA512:8b0f14ae5947c4b2d74876a795b04e532fd71c2479a64dbe0ed817e7c7894ea3cae533413de8c17322d305cb7f4e275d72b43e4e828eaca77dc4bcaf04529cf6
'http://archive.ubuntu.com/ubuntu/pool/main/p/pcre3/pcre3_8.39-13ubuntu0.22.04.1.debian.tar.gz' pcre3_8.39-13ubuntu0.22.04.1.debian.tar.gz 28251 SHA512:50aa437187fd45632213fe7b09a69dfbe2a58ad568a7f71c47ddab204db49850b732f17c8295788afd0c58d8134620a11aaa9fa259a980a0ab85ce043098a659
```

### `dpkg` source package: `pdfminer=20220319+dfsg-1`

Binary Packages:

- `python3-pdfminer=20220319+dfsg-1`

Licenses: (parsed from: `/usr/share/doc/python3-pdfminer/copyright`)

- `BSD-Adobe`
- `Expat`
- `other-1`
- `other-2`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris pdfminer=20220319+dfsg-1
'http://archive.ubuntu.com/ubuntu/pool/universe/p/pdfminer/pdfminer_20220319%2bdfsg-1.dsc' pdfminer_20220319+dfsg-1.dsc 2379 SHA512:28d5142e69204d789a47c12d6f84071225c724de189db3e3a4bddef8d2ecca08525f889883ac1a788c5e390c7a24d0ce07e8f1da7aedb6dbe34c9c8131a8ee92
'http://archive.ubuntu.com/ubuntu/pool/universe/p/pdfminer/pdfminer_20220319%2bdfsg.orig.tar.xz' pdfminer_20220319+dfsg.orig.tar.xz 5698852 SHA512:90e543bcf9469a294b3b1a36e27d4fa9c48bc649f3781e8acc0857908db6134e4dadb4404ad9298e6356f3bbe4b3c34e260a5f24c02fccb6daae0a30b57c4fcc
'http://archive.ubuntu.com/ubuntu/pool/universe/p/pdfminer/pdfminer_20220319%2bdfsg-1.debian.tar.xz' pdfminer_20220319+dfsg-1.debian.tar.xz 11588 SHA512:b45bc893aa8fcd6b57b84aefb4a4eeb4e6b5a80153c039b518730403406c7bae06aa4fdd9b5945ced286b02b1ba4aef7234f1c0eeb8d6e749cb1b1a11ce8aaf1
```

### `dpkg` source package: `perl=5.34.0-3ubuntu1.3`

Binary Packages:

- `libperl5.34:amd64=5.34.0-3ubuntu1.3`
- `perl=5.34.0-3ubuntu1.3`
- `perl-base=5.34.0-3ubuntu1.3`
- `perl-modules-5.34=5.34.0-3ubuntu1.3`

Licenses: (parsed from: `/usr/share/doc/libperl5.34/copyright`, `/usr/share/doc/perl/copyright`, `/usr/share/doc/perl-base/copyright`, `/usr/share/doc/perl-modules-5.34/copyright`)

- `Artistic`
- `Artistic,`
- `Artistic-2`
- `Artistic-dist`
- `BSD-3-clause`
- `BSD-3-clause-GENERIC`
- `BSD-3-clause-with-weird-numbering`
- `BSD-4-clause-POWERDOG`
- `BZIP`
- `CC0-1.0`
- `DONT-CHANGE-THE-GPL`
- `Expat`
- `GPL-1`
- `GPL-1+`
- `GPL-2`
- `GPL-2+`
- `GPL-3+-WITH-BISON-EXCEPTION`
- `HSIEH-BSD`
- `HSIEH-DERIVATIVE`
- `LGPL-2.1`
- `REGCOMP`
- `REGCOMP,`
- `RRA-KEEP-THIS-NOTICE`
- `SDBM-PUBLIC-DOMAIN`
- `TEXT-TABS`
- `Unicode`
- `ZLIB`

Source:

```console
$ apt-get source -qq --print-uris perl=5.34.0-3ubuntu1.3
'http://archive.ubuntu.com/ubuntu/pool/main/p/perl/perl_5.34.0-3ubuntu1.3.dsc' perl_5.34.0-3ubuntu1.3.dsc 2976 SHA512:789ad2abeb08f1ce1e29734ff6b017ec310edf415efe1728654ff1b904ea623d03d4d46afe5cb9ea98302e241ae6fe0ecaaa6e0aae66550bdf93e35ea02c9f31
'http://archive.ubuntu.com/ubuntu/pool/main/p/perl/perl_5.34.0.orig-regen-configure.tar.xz' perl_5.34.0.orig-regen-configure.tar.xz 415412 SHA512:2581152e0747105314c4fa4167f1f97d286436b996341b9b75e4099ba18f15eb0d2b42888622fbe9b5499d3fe304bc8aa9ad207a945f590135beccfb68ea28b0
'http://archive.ubuntu.com/ubuntu/pool/main/p/perl/perl_5.34.0.orig.tar.xz' perl_5.34.0.orig.tar.xz 12881416 SHA512:691b4b31eacec357191fba777612b4e3eae59e946a22998a50766697c0d61db1d42a9b3bc1e41abf0d1ca1893e4a7c06d7bf3290480cf03d7f79befd7a8a3267
'http://archive.ubuntu.com/ubuntu/pool/main/p/perl/perl_5.34.0-3ubuntu1.3.debian.tar.xz' perl_5.34.0-3ubuntu1.3.debian.tar.xz 194972 SHA512:2e59cdae22e90953cd91fd2c3f1c5b30ed92afc3b696d577719a8919d475fe52152fa2c7090d9a5f889e0816e847124e9457e0cd0dba206551303bd82297cad1
```

### `dpkg` source package: `pillow=9.0.1-1ubuntu0.3`

Binary Packages:

- `python3-pil:amd64=9.0.1-1ubuntu0.3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris pillow=9.0.1-1ubuntu0.3
'http://archive.ubuntu.com/ubuntu/pool/main/p/pillow/pillow_9.0.1-1ubuntu0.3.dsc' pillow_9.0.1-1ubuntu0.3.dsc 2067 SHA512:ca3598242bc007df8d045f537161ae72ff07189bc6d4f4b4b4a0a747e0bd6588a83074f85d8c154d932bcc8121ee218161eabc40d86734a81b62aecc34b229b6
'http://archive.ubuntu.com/ubuntu/pool/main/p/pillow/pillow_9.0.1.orig.tar.xz' pillow_9.0.1.orig.tar.xz 42523172 SHA512:d5acf89118af26c19485075daa0f900a740fcc23efeaae902b67e5deeb2714af345b14537a903a0f667b41ffb0d1033f5a92869ad89de3d020d590c54496500f
'http://archive.ubuntu.com/ubuntu/pool/main/p/pillow/pillow_9.0.1-1ubuntu0.3.debian.tar.xz' pillow_9.0.1-1ubuntu0.3.debian.tar.xz 21168 SHA512:60d4be0bf091521bdcea63f8dd5ca500cd3d3405f48b4c1f5677911d9551d15651be3cc98e3d63473638397aee83f0f0f190496fdda749240a9bec2f38f1fbea
```

### `dpkg` source package: `pinentry=1.1.1-1build2`

Binary Packages:

- `pinentry-curses=1.1.1-1build2`

Licenses: (parsed from: `/usr/share/doc/pinentry-curses/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-3`
- `LGPL-3+`
- `X11`

Source:

```console
$ apt-get source -qq --print-uris pinentry=1.1.1-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/p/pinentry/pinentry_1.1.1-1build2.dsc' pinentry_1.1.1-1build2.dsc 2953 SHA512:d66ea2b52226887f18bab9f7ebfa65f5da95225c57362ec3be1792c261a60d7c74bb0b60d82e556f977246ef615add3d89e7137a16d73248a044e0ea752246ca
'http://archive.ubuntu.com/ubuntu/pool/main/p/pinentry/pinentry_1.1.1.orig.tar.bz2' pinentry_1.1.1.orig.tar.bz2 515723 SHA512:d6ab5af8ac2f3c9c05e09703e95d8e2676f9b2b7ceb97f6a31d101d0e9da7a1e106a6d3eabe86cab1bb35a4b119a7cba1380ac64bf13c61af0b3c48803116c12
'http://archive.ubuntu.com/ubuntu/pool/main/p/pinentry/pinentry_1.1.1.orig.tar.bz2.asc' pinentry_1.1.1.orig.tar.bz2.asc 390 SHA512:2b696e5a59219c6fca719d5f948d508279c483d1d2b2c99221522648fe3098da4a195aca2527fbb5b777fa2905dbda642edb5f6ac4038ed9720a5291ce282cff
'http://archive.ubuntu.com/ubuntu/pool/main/p/pinentry/pinentry_1.1.1-1build2.debian.tar.xz' pinentry_1.1.1-1build2.debian.tar.xz 20060 SHA512:34adaf10856d36e7294fbc9841f6c1b2c9fc1d507fcff6d4c9c3f4e11d5aed9ce744d091f25e013084d56ce8ed3245fff67a7b5d799081def0c68345e921241e
```

### `dpkg` source package: `pixman=0.40.0-1ubuntu0.22.04.1`

Binary Packages:

- `libpixman-1-0:amd64=0.40.0-1ubuntu0.22.04.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris pixman=0.40.0-1ubuntu0.22.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/p/pixman/pixman_0.40.0-1ubuntu0.22.04.1.dsc' pixman_0.40.0-1ubuntu0.22.04.1.dsc 2160 SHA512:8065633dbf5f1d29da28dc2b97cdd6cb3f01a2904ecac623a8dc7d4fec0c1b15fe973edcc9d3ccc69362ce8da209325c6b522da021bf51b3a27fb10ce280b095
'http://archive.ubuntu.com/ubuntu/pool/main/p/pixman/pixman_0.40.0.orig.tar.gz' pixman_0.40.0.orig.tar.gz 913976 SHA512:063776e132f5d59a6d3f94497da41d6fc1c7dca0d269149c78247f0e0d7f520a25208d908cf5e421d1564889a91da44267b12d61c0bd7934cd54261729a7de5f
'http://archive.ubuntu.com/ubuntu/pool/main/p/pixman/pixman_0.40.0-1ubuntu0.22.04.1.diff.gz' pixman_0.40.0-1ubuntu0.22.04.1.diff.gz 327740 SHA512:68949ad2589a7ae9fbe217a3d7fc58894d5a1b4bc6e219840b8620141fa2240b44e6a393bf847bfd18f5fcab2c6c6f143273936b076c29e1f979052b1275cb8e
```

### `dpkg` source package: `polib=1.1.1-1`

Binary Packages:

- `python3-polib=1.1.1-1`

Licenses: (parsed from: `/usr/share/doc/python3-polib/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris polib=1.1.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/p/polib/polib_1.1.1-1.dsc' polib_1.1.1-1.dsc 2049 SHA512:6d51c53f5d7a2ad4dcea4ee0b8b3a4a5747b9542e5bb07d3cabe2767487bafd71f1504f27ada8425957cf0769b9e34e2ba79e0dc8ff284e232e758bd38f5b91d
'http://archive.ubuntu.com/ubuntu/pool/universe/p/polib/polib_1.1.1.orig.tar.gz' polib_1.1.1.orig.tar.gz 154644 SHA512:38de5fbdbc9ef879a4d55b9fe4f86a3aca3fb90dbb671745bd2b126be443598b8b18fe53afd116c3a4d3efc7a42b5ed05d75569bb5b2ef0bd2ced6e13eda95ad
'http://archive.ubuntu.com/ubuntu/pool/universe/p/polib/polib_1.1.1-1.debian.tar.xz' polib_1.1.1-1.debian.tar.xz 4592 SHA512:d3f45b5e76ee03bf707b537f6e59d90d824498de415ebf04b42817d680c482fa7febae9156c88438b825528deac7af54ab9f559dfad802909e45ee352d227c74
```

### `dpkg` source package: `postgresql-17=17.0-1.pgdg22.04+1`

Binary Packages:

- `libpq5:amd64=17.0-1.pgdg22.04+1`
- `postgresql-client-17=17.0-1.pgdg22.04+1`

Licenses: (parsed from: `/usr/share/doc/libpq5/copyright`, `/usr/share/doc/postgresql-client-17/copyright`)

- `Artistic`
- `BSD-2-clause`
- `BSD-3-Clause`
- `BSD-3-clause`
- `Custom-Unicode`
- `Custom-pg_dump`
- `Custom-regex`
- `GPL-1`
- `PostgreSQL`
- `Tcl`
- `double-metaphone`
- `nagaysau-ishii`

**WARNING:** unable to find source (`apt-get source` failed or returned no results)!  
This is *usually* due to a new package version being released and the old version being removed.


### `dpkg` source package: `postgresql-common=264.pgdg22.04+1`

Binary Packages:

- `postgresql-client=17+264.pgdg22.04+1`
- `postgresql-client-common=264.pgdg22.04+1`

Licenses: (parsed from: `/usr/share/doc/postgresql-client/copyright`, `/usr/share/doc/postgresql-client-common/copyright`)

- `GPL-2`
- `GPL-2+`

**WARNING:** unable to find source (`apt-get source` failed or returned no results)!  
This is *usually* due to a new package version being released and the old version being removed.


### `dpkg` source package: `procps=2:3.3.17-6ubuntu2.1`

Binary Packages:

- `libprocps8:amd64=2:3.3.17-6ubuntu2.1`
- `procps=2:3.3.17-6ubuntu2.1`

Licenses: (parsed from: `/usr/share/doc/libprocps8/copyright`, `/usr/share/doc/procps/copyright`)

- `GPL-2`
- `GPL-2.0+`
- `LGPL-2`
- `LGPL-2.0+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris procps=2:3.3.17-6ubuntu2.1
'http://archive.ubuntu.com/ubuntu/pool/main/p/procps/procps_3.3.17-6ubuntu2.1.dsc' procps_3.3.17-6ubuntu2.1.dsc 2111 SHA512:585933efef8d8e93b4187c65b678d146960480386ac3172097c790723ffadbf1d5347e05cc6de2682adcb96dd5b45ec1f98a3e00cff33ad2b30f729939896aca
'http://archive.ubuntu.com/ubuntu/pool/main/p/procps/procps_3.3.17.orig.tar.xz' procps_3.3.17.orig.tar.xz 1008428 SHA512:59e9a5013430fd9da508c4655d58375dc32e025bb502bb28fb9a92a48e4f2838b3355e92b4648f7384b2050064d17079bf4595d889822ebb5030006bc154a1a7
'http://archive.ubuntu.com/ubuntu/pool/main/p/procps/procps_3.3.17-6ubuntu2.1.debian.tar.xz' procps_3.3.17-6ubuntu2.1.debian.tar.xz 35488 SHA512:720a52d14be82aecd59e2456fbb19574c99cc5281660a36994ef4aa619c14bbec43fd30b5e949446e5db6b6bebf8003a5f173298fe8bf56ac949d61ad0225a79
```

### `dpkg` source package: `psycopg2=2.9.2-1build2`

Binary Packages:

- `python3-psycopg2=2.9.2-1build2`

Licenses: (parsed from: `/usr/share/doc/python3-psycopg2/copyright`)

- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris psycopg2=2.9.2-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/p/psycopg2/psycopg2_2.9.2-1build2.dsc' psycopg2_2.9.2-1build2.dsc 2729 SHA512:bde8f06a7da4ee5d1f07c560ceea4f13858953d1f066d964d01a2d2ea33b83a85698255ac554f0fb363d7adca8998dbb039acb05d8e6094c67d26d455f72d52b
'http://archive.ubuntu.com/ubuntu/pool/main/p/psycopg2/psycopg2_2.9.2.orig.tar.gz' psycopg2_2.9.2.orig.tar.gz 380253 SHA512:96b15db1a8c597dc7b6a725aa67952bcbac8e0e3d4f1cea97c7ffa14b272d21b4c16fd567edbbb4a01aa2c4b01c0bba562cdeea1f678aebf2139aa171dacd0a8
'http://archive.ubuntu.com/ubuntu/pool/main/p/psycopg2/psycopg2_2.9.2.orig.tar.gz.asc' psycopg2_2.9.2.orig.tar.gz.asc 488 SHA512:49a11c080dc9146462c57fe21955b1342284e125fd873552de13aa8606d8f75c34d3f10615d03401d5aa1899208c9347ec9cc6ccd8a12f54690cbc611c0dcabb
'http://archive.ubuntu.com/ubuntu/pool/main/p/psycopg2/psycopg2_2.9.2-1build2.debian.tar.xz' psycopg2_2.9.2-1build2.debian.tar.xz 15996 SHA512:d069aa869c5aced6a9dd2e585ba76fe101a6d49c16898febac649d7329113de309409790f2f77b52f04f856d64060bdfb80c8f7ec495d4e395ac911f5d07cc2b
```

### `dpkg` source package: `pyasn1=0.4.8-1`

Binary Packages:

- `python3-pyasn1=0.4.8-1`

Licenses: (parsed from: `/usr/share/doc/python3-pyasn1/copyright`)

- `BSD-2-clause`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris pyasn1=0.4.8-1
'http://archive.ubuntu.com/ubuntu/pool/main/p/pyasn1/pyasn1_0.4.8-1.dsc' pyasn1_0.4.8-1.dsc 2120 SHA512:77702bb07c82f6267a645b729c6972f4692cb03598f3a6cf8ccdeccfdafd191268de7c28407484299847ab5fdf5cc7cdf9bae27aa5463be0799b2111f82fcbdd
'http://archive.ubuntu.com/ubuntu/pool/main/p/pyasn1/pyasn1_0.4.8.orig.tar.gz' pyasn1_0.4.8.orig.tar.gz 146820 SHA512:e64e70b325c8067f87ace7c0673149e82fe564aa4b0fa146d29b43cb588ecd6e81b1b82803b8cfa7a17d3d0489b6d88b4af5afb3aa0052bf92e8a1769fe8f7b0
'http://archive.ubuntu.com/ubuntu/pool/main/p/pyasn1/pyasn1_0.4.8-1.debian.tar.xz' pyasn1_0.4.8-1.debian.tar.xz 5380 SHA512:cb84a0a2df1efc68473f5ee226a432b60f47021ed93b306f95dfb655c8db6c7f58ace16515502e4f7f6212fb51ec5e5c730b3ef1ea0b245067e8627b3caee29d
```

### `dpkg` source package: `pydot=1.4.2-1build1`

Binary Packages:

- `python3-pydot=1.4.2-1build1`

Licenses: (parsed from: `/usr/share/doc/python3-pydot/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris pydot=1.4.2-1build1
'http://archive.ubuntu.com/ubuntu/pool/universe/p/pydot/pydot_1.4.2-1build1.dsc' pydot_1.4.2-1build1.dsc 2121 SHA512:24095e1e04d84569a6cb535cdedae8d3a4969c3920c9b36c637ab4aa0773fddd2734926545bc99f9d35cb6104fb8fb0d64617dadce686400b5865a4c9ee477c6
'http://archive.ubuntu.com/ubuntu/pool/universe/p/pydot/pydot_1.4.2.orig.tar.xz' pydot_1.4.2.orig.tar.xz 231120 SHA512:0e0babe954cd0bea31f369b9b7f1a81d67400917cdb6ca922d121c557b7c66fbfbf799342870e507bcf107a05a57e0d080ed6fac7c574d13cfbf74cfa05c567d
'http://archive.ubuntu.com/ubuntu/pool/universe/p/pydot/pydot_1.4.2-1build1.debian.tar.xz' pydot_1.4.2-1build1.debian.tar.xz 4656 SHA512:705c790c8fd4415f67cdc0c3a1b3eae84d15a3dc2a4c0e40891532b461e861758d89a4b5cb8b474986e0a048fa3d21c7d143539628ac8e1d14c5c877a8215b72
```

### `dpkg` source package: `pyopenssl=21.0.0-1`

Binary Packages:

- `python3-openssl=21.0.0-1`

Licenses: (parsed from: `/usr/share/doc/python3-openssl/copyright`)

- `Apache-2.0`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris pyopenssl=21.0.0-1
'http://archive.ubuntu.com/ubuntu/pool/main/p/pyopenssl/pyopenssl_21.0.0-1.dsc' pyopenssl_21.0.0-1.dsc 2235 SHA512:d5589caf7bc3042c38543fed8b15f2f1faffa250baa2a1071764891cd985a4d35bcbc183f0fd190b6142a7a0c0c79fd6fa4105c093e774572cf5ced2b5fe0a88
'http://archive.ubuntu.com/ubuntu/pool/main/p/pyopenssl/pyopenssl_21.0.0.orig.tar.xz' pyopenssl_21.0.0.orig.tar.xz 141804 SHA512:dbcd139f59df0d6455e757892e2ee25c318bdba1075c249f8ff4ef34f236391a1e7244dbc5703212c08b75495415983b5f85bf1591dada9869bb75880e489bba
'http://archive.ubuntu.com/ubuntu/pool/main/p/pyopenssl/pyopenssl_21.0.0-1.debian.tar.xz' pyopenssl_21.0.0-1.debian.tar.xz 9344 SHA512:bf3c5672797f0e2628d8967a6121e25227bd509d803b372ec939de22e9d189ff8f8c5bdad5dd84a516b7377c88702554722d705c20e133f1e680a427f76638c6
```

### `dpkg` source package: `pyparsing=2.4.7-1`

Binary Packages:

- `python3-pyparsing=2.4.7-1`

Licenses: (parsed from: `/usr/share/doc/python3-pyparsing/copyright`)

- `BSD-2-clause`
- `BSD-3-clause`
- `Expat`
- `GPL-2`
- `GPL-3`
- `ellis-and-grant`
- `salvolainen`

Source:

```console
$ apt-get source -qq --print-uris pyparsing=2.4.7-1
'http://archive.ubuntu.com/ubuntu/pool/main/p/pyparsing/pyparsing_2.4.7-1.dsc' pyparsing_2.4.7-1.dsc 2340 SHA512:6d06384fcf48257fafbaa9681faee68ba044f117fd86f2ad6c57ef8fa7186066376c5b25fc525f057cdd8fa2830289f77780c9a8f9647164596cd490b3c8014e
'http://archive.ubuntu.com/ubuntu/pool/main/p/pyparsing/pyparsing_2.4.7.orig.tar.gz' pyparsing_2.4.7.orig.tar.gz 649718 SHA512:0b9f8f18907f65cb3af1b48ed57989e183f28d71646f2b2f820e772476f596ca15ee1a689f3042f18458206457f4683d10daa6e73dfd3ae82d5e4405882f9dd2
'http://archive.ubuntu.com/ubuntu/pool/main/p/pyparsing/pyparsing_2.4.7-1.debian.tar.xz' pyparsing_2.4.7-1.debian.tar.xz 7764 SHA512:185911863111ba7c956fb1e7229046ae1516554bc253f342f070afe82c20cfd4c3e098d233c7b341f6518875e47ddcf76ded2528534a959574beebcdf531b846
```

### `dpkg` source package: `pypdf2=1.26.0-4ubuntu0.22.04.2`

Binary Packages:

- `python3-pypdf2=1.26.0-4ubuntu0.22.04.2`

Licenses: (parsed from: `/usr/share/doc/python3-pypdf2/copyright`)

- `BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris pypdf2=1.26.0-4ubuntu0.22.04.2
'http://archive.ubuntu.com/ubuntu/pool/universe/p/pypdf2/pypdf2_1.26.0-4ubuntu0.22.04.2.dsc' pypdf2_1.26.0-4ubuntu0.22.04.2.dsc 1889 SHA512:43ded166ec5f0f3a4fae0679ca587c384069727274c7bb19dc581d36b7b24d91fb1a0381e3ef4509562fde0957b888d829c7fbb80cca74d9dfeba68ab5f59981
'http://archive.ubuntu.com/ubuntu/pool/universe/p/pypdf2/pypdf2_1.26.0.orig.tar.gz' pypdf2_1.26.0.orig.tar.gz 199539 SHA512:fe29c1e24be765c43fed47185dc69cfe959d36c693f6ac9fed9a33c48035c651eed8f2f6eb674697f923b769fcfdd275624b128ab99992477bfc0e854b90fa5c
'http://archive.ubuntu.com/ubuntu/pool/universe/p/pypdf2/pypdf2_1.26.0-4ubuntu0.22.04.2.debian.tar.xz' pypdf2_1.26.0-4ubuntu0.22.04.2.debian.tar.xz 5260 SHA512:8c32f0748bb861c822cbfc1efec8b1f54acb034f46cc72c2d161707512c615cab7a341e776d695716e26fb77ba14c5df6cc076879b9ebe3b0d4eba073f76fd3a
```

### `dpkg` source package: `pyserial=3.5-1`

Binary Packages:

- `python3-serial=3.5-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris pyserial=3.5-1
'http://archive.ubuntu.com/ubuntu/pool/main/p/pyserial/pyserial_3.5-1.dsc' pyserial_3.5-1.dsc 1793 SHA512:6ad7f783eddb4087ba5711af245cc718b65ff5bb6520c8b18d27f330d744f730c85321c93b415d5861b67f2d2db90419d9f8c2f8f1a116ec4699224158884863
'http://archive.ubuntu.com/ubuntu/pool/main/p/pyserial/pyserial_3.5.orig.tar.gz' pyserial_3.5.orig.tar.gz 159125 SHA512:c8df5e50d952d5a6dcf1d9253a6ba953e9763c545a867da66c22c90dfa015aba0194f2a8f29a229d0a5f4dc8bfeeaaab8bcfda4066ed78a18b151bc05e6ae327
'http://archive.ubuntu.com/ubuntu/pool/main/p/pyserial/pyserial_3.5-1.debian.tar.xz' pyserial_3.5-1.debian.tar.xz 4056 SHA512:af3f2ac8ef856df46d7567a2feeb24db3471971a467943db3f6b3c864d233b0034dfa6b5317c66390fd029456911bc7eb2fedeaf045b422e13be39287b759ad7
```

### `dpkg` source package: `python-attrs=21.2.0-1`

Binary Packages:

- `python3-attr=21.2.0-1`

Licenses: (parsed from: `/usr/share/doc/python3-attr/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris python-attrs=21.2.0-1
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-attrs/python-attrs_21.2.0-1.dsc' python-attrs_21.2.0-1.dsc 2361 SHA512:eec9a65c4e9518cf9b124a70409a3be0c40e5404ffee18b8a99dc541c9ce9e9699cef3f4bf2e6cf803e060aba208d176d1e0207784687382dd9ee50aa4cf324c
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-attrs/python-attrs_21.2.0.orig.tar.gz' python-attrs_21.2.0.orig.tar.gz 177524 SHA512:fa6569f3bdcc74a735b31dc67ce5ca3535eab8a5eb30f6b91ebf1149609294c0ef0d0910b8e41205d31c4745354c2262c18db901bae0af82c8b8cefc46f8a0a9
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-attrs/python-attrs_21.2.0-1.debian.tar.xz' python-attrs_21.2.0-1.debian.tar.xz 5328 SHA512:7abb633a1fc485bcf527f30a48be404eb34314ff3fad66ac00ccdae92e46e4524c3fcccc153c7adcbb48a8b9f4784d89629101c9309185bbed788a2af7d6c6a1
```

### `dpkg` source package: `python-babel=2.8.0+dfsg.1-7`

Binary Packages:

- `python-babel-localedata=2.8.0+dfsg.1-7`
- `python3-babel=2.8.0+dfsg.1-7`

Licenses: (parsed from: `/usr/share/doc/python-babel-localedata/copyright`, `/usr/share/doc/python3-babel/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2+`
- `Unicode`

Source:

```console
$ apt-get source -qq --print-uris python-babel=2.8.0+dfsg.1-7
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-babel/python-babel_2.8.0%2bdfsg.1-7.dsc' python-babel_2.8.0+dfsg.1-7.dsc 2343 SHA512:4babb8cc7c45679dc7ca68be9cdc95f592e5b0fbe880d2b83592b6727e75378f1b44728086779f4c49e99d49dffa0ebfde1500bd0d46e5d23f127c4677f69931
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-babel/python-babel_2.8.0%2bdfsg.1.orig.tar.xz' python-babel_2.8.0+dfsg.1.orig.tar.xz 14029964 SHA512:021e923b961feae4dfa66695731c6240928bcecad997805c676cfca1c35c64fcf9e3376f8c9f59a26cc465f2652a5a737c10cdf7f96b0e755f04be24d1f781bc
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-babel/python-babel_2.8.0%2bdfsg.1-7.debian.tar.xz' python-babel_2.8.0+dfsg.1-7.debian.tar.xz 13700 SHA512:2d5fb5b14fdc43a7ae52aa9fdaf13ed4c6829030fac74c32a5e988a1c79c17c2817627fc2127cd8d426a57250e3cbc4df9d957d659ff339974c5ba5a34aaf3e7
```

### `dpkg` source package: `python-certifi=2020.6.20-1`

Binary Packages:

- `python3-certifi=2020.6.20-1`

Licenses: (parsed from: `/usr/share/doc/python3-certifi/copyright`)

- `GPL-2`
- `MPL-2`

Source:

```console
$ apt-get source -qq --print-uris python-certifi=2020.6.20-1
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-certifi/python-certifi_2020.6.20-1.dsc' python-certifi_2020.6.20-1.dsc 1627 SHA512:87e5eb3577d2d80bb2117a949b50f0972ba1bc066894d856f46c70925501f0a1e6840d2b4abcb0ab827cabc81ca06e86c99a453ec5e04a20dc095560e0122f19
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-certifi/python-certifi_2020.6.20.orig.tar.xz' python-certifi_2020.6.20.orig.tar.xz 144184 SHA512:82ff2e3daf5c7ea896cbeb34bfd6cc9330c2e262e8c385c9c79ff4fa7bbaf10fe9b4b198c03ac72b6639b78f618bc0eebbb7b47faaf2c69438ff9cef326bb6bc
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-certifi/python-certifi_2020.6.20-1.debian.tar.xz' python-certifi_2020.6.20-1.debian.tar.xz 8104 SHA512:884fabb3d16fd77e96597850260e161566dc1e7a47dbfe444eca55c15cdd1e793fe5515a75a2244740abaf9be5ad42ea865d84ae8a2c810388639bfdf0c82756
```

### `dpkg` source package: `python-cffi=1.15.0-1build2`

Binary Packages:

- `python3-cffi-backend:amd64=1.15.0-1build2`

Licenses: (parsed from: `/usr/share/doc/python3-cffi-backend/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris python-cffi=1.15.0-1build2
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-cffi/python-cffi_1.15.0-1build2.dsc' python-cffi_1.15.0-1build2.dsc 2511 SHA512:71db35ef88149d65f2fb4259a93479c0ab701de18a6ceece12398079794496e4a41cef6fca24cc8f1f854e7f6ab4d2b48218d5844ca01fe200738e3664157f19
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-cffi/python-cffi_1.15.0.orig.tar.gz' python-cffi_1.15.0.orig.tar.gz 484058 SHA512:ee83efde6f77f4a0c5889088c4c208ed7b9071fe06dfc16a8d2396de07f78fe859e1e39866760198a9d700f3b7359e8715e8a3e4907feb81d3fc4b8dd0dbaca1
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-cffi/python-cffi_1.15.0-1build2.debian.tar.xz' python-cffi_1.15.0-1build2.debian.tar.xz 7228 SHA512:3b41fb0bc166cb1c278f7961c6959078012dee521ffe3c73f77a2f52c0c0a5e3114a2cdbd3e724cd8a5a88266bf527358b821ce7994bb5485659abb5d767406f
```

### `dpkg` source package: `python-cryptography=3.4.8-1ubuntu2.2`

Binary Packages:

- `python3-cryptography=3.4.8-1ubuntu2.2`

Licenses: (parsed from: `/usr/share/doc/python3-cryptography/copyright`)

- `Apache`
- `Apache-2.0`
- `Expat`

Source:

```console
$ apt-get source -qq --print-uris python-cryptography=3.4.8-1ubuntu2.2
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-cryptography/python-cryptography_3.4.8-1ubuntu2.2.dsc' python-cryptography_3.4.8-1ubuntu2.2.dsc 3173 SHA512:9d28dafcb11f1d4361bfe7cca107ebb8df103d81df5e52a12a923d3ba5d24d2641b93d85d8f0de5d65312a61ec18be1274ef7e6bc674ca185d5506e334ea2b46
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-cryptography/python-cryptography_3.4.8.orig.tar.gz' python-cryptography_3.4.8.orig.tar.gz 546907 SHA512:b0d64a573b488af3e453fc1885bbafb65f8a2260e81cf64830f981589afca0bd7be052a5f5b8ed83dd78d9638da37c680f3705cbf2d47d5b28fb5a5454f1cea5
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-cryptography/python-cryptography_3.4.8-1ubuntu2.2.debian.tar.xz' python-cryptography_3.4.8-1ubuntu2.2.debian.tar.xz 25452 SHA512:579005955a9af9bc0dd3abfc0064968ac42c85e632101d543f01aefb11c5e54b614ad50587c68cba31d2fde7295d7f4068487f1bf2f86e12931e1a565dcc4bea
```

### `dpkg` source package: `python-dateutil=2.8.1-6`

Binary Packages:

- `python3-dateutil=2.8.1-6`

Licenses: (parsed from: `/usr/share/doc/python3-dateutil/copyright`)

- `BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris python-dateutil=2.8.1-6
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-dateutil/python-dateutil_2.8.1-6.dsc' python-dateutil_2.8.1-6.dsc 2129 SHA512:defe085f213b14dcb2b1bf568b092cf539fad2690f4ad1895d153c8011a4c8744f25a8710b2eea2aa9de7516f0eda06e2aade979f1c489a5bd936bdf220a0d63
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-dateutil/python-dateutil_2.8.1.orig.tar.gz' python-dateutil_2.8.1.orig.tar.gz 331745 SHA512:337000216e0f8ce32d6363768444144183ab9268f69082f20858f2b3322b1c449e53b2f2b5dcb3645be22294659ce7838f74ace2fd7a7c4f2adc6cf806a9fa2c
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-dateutil/python-dateutil_2.8.1-6.debian.tar.xz' python-dateutil_2.8.1-6.debian.tar.xz 11508 SHA512:f376c089d6f43f21d4cf602e251ba4537a23fb995d47b200b00158ff4c2396230fc36983e8bde1a2c5af97c1f69e769252467273a6552506832ccfcac80ffb55
```

### `dpkg` source package: `python-decorator=4.4.2-0ubuntu1`

Binary Packages:

- `python3-decorator=4.4.2-0ubuntu1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris python-decorator=4.4.2-0ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-decorator/python-decorator_4.4.2-0ubuntu1.dsc' python-decorator_4.4.2-0ubuntu1.dsc 2355 SHA512:bd8b20e0a710a7958e11fe35adc01ca4266c9bb5bea5f0d16604d45e76201b6264334b8ad17cedb9ca40a2b4fa6e883281ec4aa8ff92177b73df17031d650a99
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-decorator/python-decorator_4.4.2.orig.tar.gz' python-decorator_4.4.2.orig.tar.gz 33629 SHA512:c068efd4e70764ac447b772c9c29625c2180dad256b2b4e46a50a8479fc1d7de09b114c2ba11bb37dd58774ed9460d2e0ea9fa76061833a2d3c2676ac91a0db1
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-decorator/python-decorator_4.4.2-0ubuntu1.debian.tar.xz' python-decorator_4.4.2-0ubuntu1.debian.tar.xz 4304 SHA512:a163469241171cefc78b9b5061ffa60adb07028f79d4b35accc22d1a36c792ee1b3c7413aa4de9f0de38d311ea3f14dcc3c64855b02818c8475612d0cca97189
```

### `dpkg` source package: `python-docutils=0.17.1+dfsg-2`

Binary Packages:

- `docutils-common=0.17.1+dfsg-2`
- `python3-docutils=0.17.1+dfsg-2`

Licenses: (parsed from: `/usr/share/doc/docutils-common/copyright`, `/usr/share/doc/python3-docutils/copyright`)

- `BSD-2-clause`
- `BSD-3-clause`
- `GPL-3`
- `GPL-3+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `Python-2.1.1`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris python-docutils=0.17.1+dfsg-2
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-docutils/python-docutils_0.17.1%2bdfsg-2.dsc' python-docutils_0.17.1+dfsg-2.dsc 2399 SHA512:ed63823b3b46e5c374bbc5044a5760ce53dffeadec65ef8a99fc72030d85ba186744acc7a70cc2cac3ba1159f3826d67e9a8747016f994011c79ac9639b80d1a
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-docutils/python-docutils_0.17.1%2bdfsg.orig.tar.xz' python-docutils_0.17.1+dfsg.orig.tar.xz 1504140 SHA512:90a3af02e6cd11edf07f3fe5dae06042138bf80b54bd88b22b866fa69e0ed6b3babc6bc9ba30bf2452d09fd155720c2c9ceb3e2cfe42e0a1cf10637ba09404ea
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-docutils/python-docutils_0.17.1%2bdfsg-2.debian.tar.xz' python-docutils_0.17.1+dfsg-2.debian.tar.xz 30924 SHA512:eaf37bc33b90bbd34c5e6a54ac0360442e5c3bb356f5b9546aa4bcfc6514740610674eb9d9b470b4c48e330e2d3380047b6979813f5a337974ae0b564d892253
```

### `dpkg` source package: `python-geoip2=2.9.0+dfsg1-2`

Binary Packages:

- `python3-geoip2=2.9.0+dfsg1-2`

Licenses: (parsed from: `/usr/share/doc/python3-geoip2/copyright`)

- `Apache-2`
- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris python-geoip2=2.9.0+dfsg1-2
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-geoip2/python-geoip2_2.9.0%2bdfsg1-2.dsc' python-geoip2_2.9.0+dfsg1-2.dsc 2428 SHA512:54138510a5308d3bd80248359a39aa363a3c2d8f0bef074a1618326f0d170ea177ad7419579a001bcd40141168395ca3315c859c0987286bac07412d6e64ef0d
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-geoip2/python-geoip2_2.9.0%2bdfsg1.orig.tar.gz' python-geoip2_2.9.0+dfsg1.orig.tar.gz 126237 SHA512:d0769d1a4575e56ac90fe569c44a102f82180bddf78c6947c76a5a0ce8d35d50a28fa59ef67687040ec36c2faa580e6f7003501e1af519ad33d580eaf5b07fd9
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-geoip2/python-geoip2_2.9.0%2bdfsg1-2.debian.tar.xz' python-geoip2_2.9.0+dfsg1-2.debian.tar.xz 2644 SHA512:59cb3a2d75477aaa9b8628e75c61743931158396f605900bbd89c8be597297b3b4796044bd5126cf6d3d6cf6f19ceaf574c8863729cc08736184e95aa268bb61
```

### `dpkg` source package: `python-gevent=21.8.0-1build1`

Binary Packages:

- `python3-gevent=21.8.0-1build1`

Licenses: (parsed from: `/usr/share/doc/python3-gevent/copyright`)

- `Apachae-2.0`
- `BSD-2-Clause`
- `BSD-3-Clause`
- `GPL-2+`
- `GPL-3`
- `MIT`
- `PSFL`

Source:

```console
$ apt-get source -qq --print-uris python-gevent=21.8.0-1build1
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-gevent/python-gevent_21.8.0-1build1.dsc' python-gevent_21.8.0-1build1.dsc 2526 SHA512:2225cbf027ad6530ca660c0fb7a74411cf6e17c89262ded59bd34fdc298b873d9dde7c32845caad38a6a8eccbeb4ad517faa23e33e6f8e299eec17bf4f7bb47c
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-gevent/python-gevent_21.8.0.orig.tar.xz' python-gevent_21.8.0.orig.tar.xz 2002728 SHA512:2f46349cc8c7ed0b0796ccebb808b904f7d3c808eae9be9711cf0c4a24fa693c1adcd594c70f968287b23155d28258230122f84c929399cabb6d55ae517c4412
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-gevent/python-gevent_21.8.0-1build1.debian.tar.xz' python-gevent_21.8.0-1build1.debian.tar.xz 72316 SHA512:d2c372f184a30382bbfa33959d88e15d1933564642a4dc282515355c65c8f29e552cd21dce08b1760eacb0f20661337e9722ae71a117f0cc48d03d92c47a6cf0
```

### `dpkg` source package: `python-greenlet=1.1.2-3build1`

Binary Packages:

- `python3-greenlet=1.1.2-3build1`

Licenses: (parsed from: `/usr/share/doc/python3-greenlet/copyright`)

- `CC0-1.0-Universal`
- `GPL-3`
- `MIT`
- `PSFL-2`

Source:

```console
$ apt-get source -qq --print-uris python-greenlet=1.1.2-3build1
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-greenlet/python-greenlet_1.1.2-3build1.dsc' python-greenlet_1.1.2-3build1.dsc 2283 SHA512:fcaaeb41e5a56cdbf844335281be2f983ea5bd33dfe40e51886603f929da3c4708b6cc97d2967167bdfcf0a454692720351d1e351910c2265ed6527bf35410f9
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-greenlet/python-greenlet_1.1.2.orig.tar.gz' python-greenlet_1.1.2.orig.tar.gz 86279 SHA512:c927b71c5df09863f6f81f0f89ee43ec8d08f6e229a88d5c9321e9f50dcc349cc79c3165842c0371fd584fb0cbbf870bfad52b94ad3137aa37a018a5b2236d03
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-greenlet/python-greenlet_1.1.2-3build1.debian.tar.xz' python-greenlet_1.1.2-3build1.debian.tar.xz 9672 SHA512:d5b62d4b448e086bef6ab5137a75c9aaae3166752bb004edf90ab98bae965d84c6306b0a9e8049231bc384a34d2f52588da1c4a3327a951259f9e238a568bca4
```

### `dpkg` source package: `python-idna=3.3-1ubuntu0.1`

Binary Packages:

- `python3-idna=3.3-1ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/python3-idna/copyright`)

- `BSD-3-clause`
- `PSF-2`
- `Unicode`

Source:

```console
$ apt-get source -qq --print-uris python-idna=3.3-1ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-idna/python-idna_3.3-1ubuntu0.1.dsc' python-idna_3.3-1ubuntu0.1.dsc 2258 SHA512:2c3308bf7cc3c761e4145edec74083dec1575064e35593afff0ca5a1d99431e5b8a42220269c6c86ae1f2e69298dfd3c2331728c39b7d4732dc2aafca8115e6f
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-idna/python-idna_3.3.orig.tar.gz' python-idna_3.3.orig.tar.gz 286689 SHA512:70b7cc8718e7d7899c75cfe476f044eae5a2fa03801fc9c12e3a092627ca943ffc4a578f9b8a55e181a11564835e125cfaaa577c02a6461dbb97366e620e53ad
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-idna/python-idna_3.3-1ubuntu0.1.debian.tar.xz' python-idna_3.3-1ubuntu0.1.debian.tar.xz 8848 SHA512:67859c244e63442af3270e7f16531aad57aff7aecf99446d4dd2090cc860c4973db1644e3836089e4a3258a6bac82a70e59a3da03bf9ddfe112c38c1c4807059
```

### `dpkg` source package: `python-ldap=3.2.0-4ubuntu7.1`

Binary Packages:

- `python3-ldap:amd64=3.2.0-4ubuntu7.1`
- `python3-pyldap:amd64=3.2.0-4ubuntu7.1`

Licenses: (parsed from: `/usr/share/doc/python3-ldap/copyright`, `/usr/share/doc/python3-pyldap/copyright`)

- `GPL-2`
- `GPL-2+`
- `Python`

Source:

```console
$ apt-get source -qq --print-uris python-ldap=3.2.0-4ubuntu7.1
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-ldap/python-ldap_3.2.0-4ubuntu7.1.dsc' python-ldap_3.2.0-4ubuntu7.1.dsc 2365 SHA512:82aa317652e2b9bb2b79ec48131f244afdb6f54ea5a290230ac58e211d3fcf466d91b78886f8f9183cb619f850efab1d97a07e440e201468d179f5783173d020
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-ldap/python-ldap_3.2.0.orig.tar.gz' python-ldap_3.2.0.orig.tar.gz 367645 SHA512:ef2833739fd57ad26d97ae5dba3bca8a47e770ff3f113d06a5bed0841f8fcbbe6cd102e75c753dfff48f5f6041f46a91c6166f3bb9ca44ef9bd643c0666c6b23
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-ldap/python-ldap_3.2.0-4ubuntu7.1.debian.tar.xz' python-ldap_3.2.0-4ubuntu7.1.debian.tar.xz 10004 SHA512:411a121fbfa15221b73f75f070244035c2bd5098aec2e0da9cb0c3c4ff75d6e70d143b141b956eb963902d9a255dc215060dd43d712d73465557c5728b859e4d
```

### `dpkg` source package: `python-magic=2:0.4.24-2`

Binary Packages:

- `python3-magic=2:0.4.24-2`

Licenses: (parsed from: `/usr/share/doc/python3-magic/copyright`)

- `BSD-2-Clause-alike`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris python-magic=2:0.4.24-2
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-magic/python-magic_0.4.24-2.dsc' python-magic_0.4.24-2.dsc 2005 SHA512:01866641fd666a1e677ce6df5b0e9f346fee715f78980a7d2d24120c313db3453d30d76a791a9a1ace58fc15ef9d2675c26859de477b9a57f4364ee38cd6f454
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-magic/python-magic_0.4.24.orig.tar.gz' python-magic_0.4.24.orig.tar.gz 863700 SHA512:b3ec148da398293465299938fabf691b56c4b3876f6abbb7a734a9c0a5180cc758a15f7085bbf1bf40ec6031697ec84d98c161db1fd04301133af09928c611fc
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-magic/python-magic_0.4.24-2.debian.tar.xz' python-magic_0.4.24-2.debian.tar.xz 3872 SHA512:25e9ec86b779526e1f0541da4e4de7744c4f34cf1d690a7951550b59d05c484ba0d7e398a12daa86f4918482e1e0163d26eb578a78e2791d2f44357eff2477a5
```

### `dpkg` source package: `python-maxminddb=2.0.3-1build3`

Binary Packages:

- `python3-maxminddb=2.0.3-1build3`

Licenses: (parsed from: `/usr/share/doc/python3-maxminddb/copyright`)

- `Apache-2.0`
- `CC-BY-SA-3.0-Unported`

Source:

```console
$ apt-get source -qq --print-uris python-maxminddb=2.0.3-1build3
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-maxminddb/python-maxminddb_2.0.3-1build3.dsc' python-maxminddb_2.0.3-1build3.dsc 2288 SHA512:a270ee50fb44c5700b77ac51a0eb258ebc1a17b485830bb3c3839afe6908d4c0f5ca2127a0b2695ff2bd020c799cb0da6e2624e7f3a98dbd101c358e0c960ba9
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-maxminddb/python-maxminddb_2.0.3.orig.tar.gz' python-maxminddb_2.0.3.orig.tar.gz 222857 SHA512:de4f508222cade80701724f348a9fc64ddefd5813cf5492cd7ebb03fd67e640913313a076ba193df040a4b6cdf0620229027773d2214292c7ba2e4b67733a084
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-maxminddb/python-maxminddb_2.0.3-1build3.debian.tar.xz' python-maxminddb_2.0.3-1build3.debian.tar.xz 10020 SHA512:ab7951232e238da3a17b90959628b2950b4d56a5a894c7de905cf62211bcdeeee696fbfb361490964c0bf72752032081b9308bebdd74cccbebc8d6e1cfbaced9
```

### `dpkg` source package: `python-num2words=0.5.10-1`

Binary Packages:

- `python3-num2words=0.5.10-1`

Licenses: (parsed from: `/usr/share/doc/python3-num2words/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris python-num2words=0.5.10-1
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-num2words/python-num2words_0.5.10-1.dsc' python-num2words_0.5.10-1.dsc 2116 SHA512:81573e57916359e02080509c2ef5fc957b021ed9881f4e5f823011727992d8f586c27637e65e1cc66884945439cbab561d0831098925419f14d222bbbc91ec6c
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-num2words/python-num2words_0.5.10.orig.tar.gz' python-num2words_0.5.10.orig.tar.gz 110623 SHA512:004e171717d6dd058ee3f905bb240198bcfe9b7d3aa0743f6abeda4145d0a3b00d6ee6e0b266bbad1d539dba58b7721f4d13b011aaec4869c170b965b4c2de3c
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-num2words/python-num2words_0.5.10-1.debian.tar.xz' python-num2words_0.5.10-1.debian.tar.xz 3580 SHA512:1a0df6781f68b036663b04aa1e3140562a82e90076555a2d539c787cd574034b6ab429beca59229e8c9effd36a59fc23a996bc3d8d4a022976b557cfa1b8b466
```

### `dpkg` source package: `python-odf=1.4.2-1`

Binary Packages:

- `python3-odf=1.4.2-1`

Licenses: (parsed from: `/usr/share/doc/python3-odf/copyright`)

- `Apache-2`
- `Apache-2.0`
- `CC-BY-SA-3.0`
- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris python-odf=1.4.2-1
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-odf/python-odf_1.4.2-1.dsc' python-odf_1.4.2-1.dsc 2229 SHA512:cb37d4e3e694c8514ae8e24da979189194ec3724c5c9627907f2c00a5015993e56874d0dbb85bff8e9fb82a0960f27aa6f5fd87200a623b114619928f704c898
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-odf/python-odf_1.4.2.orig.tar.gz' python-odf_1.4.2.orig.tar.gz 10065808 SHA512:75368010c015e13302d2b43228ef9ed1f6c9307da60cf199098609729b008c69836511c953dbc730f3097124878b1fa6de7e8d5f49e20716062ada747698f84d
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-odf/python-odf_1.4.2-1.debian.tar.xz' python-odf_1.4.2-1.debian.tar.xz 15856 SHA512:96fb1633b57af3d6af92484bab378f76589786e266341057f4f7be803e98491382bc5d0bf902f60853441d38ebacacd180ee79104de224e14247465993ff0087
```

### `dpkg` source package: `python-ofxparse=0.21-2`

Binary Packages:

- `python3-ofxparse=0.21-2`

Licenses: (parsed from: `/usr/share/doc/python3-ofxparse/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris python-ofxparse=0.21-2
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-ofxparse/python-ofxparse_0.21-2.dsc' python-ofxparse_0.21-2.dsc 2013 SHA512:5652c074e858b75fa49cb50f58a2a657f07759ba6c56497e881e3353a9997a80200394e00760b7dac4c5863ce87cff335bb7cc0d5199c48a5375166204ed1769
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-ofxparse/python-ofxparse_0.21.orig.tar.gz' python-ofxparse_0.21.orig.tar.gz 53837 SHA512:0654709413a05754799bbb289d1d43aeec91313b5d12010e5bf26a31da03e8b332f85266c924a8d4c9a614bf068de2311459a808890f0206b126e9ad0cf944b9
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-ofxparse/python-ofxparse_0.21-2.debian.tar.xz' python-ofxparse_0.21-2.debian.tar.xz 2560 SHA512:9f376ad082446dcb03bb8e3b4fbee604baf4494758690446a1018a9c85f42a1a3ba1862b6d5f76ef79cd9d95244a03e3bd2e68c81e9b23c92fe8668307a7b71c
```

### `dpkg` source package: `python-passlib=1.7.4-1`

Binary Packages:

- `python3-passlib=1.7.4-1`

Licenses: (parsed from: `/usr/share/doc/python3-passlib/copyright`)

- `Aki-Yoshida`
- `BEER-WARE`
- `BSD-3-Clause`
- `Damien-Miller`

Source:

```console
$ apt-get source -qq --print-uris python-passlib=1.7.4-1
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-passlib/python-passlib_1.7.4-1.dsc' python-passlib_1.7.4-1.dsc 2031 SHA512:80049da552111ff27c5db40089bacf0989672bbf9dce811c774655835164738ffff208cdeec4af258b59d297b32db8718f9c3dda063e294e88119bba6e0e0f1e
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-passlib/python-passlib_1.7.4.orig.tar.xz' python-passlib_1.7.4.orig.tar.xz 532384 SHA512:ee1919ddb603ebb6ad181de436ee8e97e1137b21167abc2f37f2d2eb3263ad375ee7759206ba1ec730fed60976cf8b30790b2f7933b451275eea0e2f792a192e
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-passlib/python-passlib_1.7.4-1.debian.tar.xz' python-passlib_1.7.4-1.debian.tar.xz 13888 SHA512:04750ff6d258dd5cf036dafae63f6635028dbd5e8eb569ac47cc36f0d632cc471ab4137dde395444c0afb9f3bcf55aa41381694bf53abd795141eb17780f4b18
```

### `dpkg` source package: `python-phonenumbers=8.12.1-1`

Binary Packages:

- `python3-phonenumbers=8.12.1-1`

Licenses: (parsed from: `/usr/share/doc/python3-phonenumbers/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris python-phonenumbers=8.12.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-phonenumbers/python-phonenumbers_8.12.1-1.dsc' python-phonenumbers_8.12.1-1.dsc 1959 SHA512:fee32bf03b73a0d1187e1759085d1f5c236f21f03a466ece9de222748045e00de4c4cbb2c219fdfd533736e24321240bb0f9c7bb31824fc08dfec3aef2bff72a
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-phonenumbers/python-phonenumbers_8.12.1.orig.tar.gz' python-phonenumbers_8.12.1.orig.tar.gz 4864316 SHA512:2df487e9b3aff3f4e27b2b82c1e2f836d3abe4268f036a615c6d65572c252738a7bae415a2d2bc517c947775600a60fad24c117d7f44863ffe16b60de245f5c2
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-phonenumbers/python-phonenumbers_8.12.1-1.debian.tar.xz' python-phonenumbers_8.12.1-1.debian.tar.xz 2224 SHA512:5d85021d91ae66e58ff33b856c7a1d44c9b24bfa9955b57e3edbd31a946b543ebe0f1ce426923f803da31b429cfa03c0737b3f7955ef4d115b828cfcb065b39e
```

### `dpkg` source package: `python-pip=22.0.2+dfsg-1ubuntu0.4`

Binary Packages:

- `python3-pip=22.0.2+dfsg-1ubuntu0.4`

Licenses: (parsed from: `/usr/share/doc/python3-pip/copyright`)

- `Apache-2.0`
- `Apache-2.0 OR BSD-2`
- `BSD-2`
- `BSD-3`
- `Expat`
- `ISC`
- `LGPL-2.1`
- `LGPL-2.1+`
- `MPL-2`
- `MPL-2.0`
- `Python`

**WARNING:** unable to find source (`apt-get source` failed or returned no results)!  
This is *usually* due to a new package version being released and the old version being removed.


### `dpkg` source package: `python-psutil=5.9.0-1build1`

Binary Packages:

- `python3-psutil=5.9.0-1build1`

Licenses: (parsed from: `/usr/share/doc/python3-psutil/copyright`)

- `BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris python-psutil=5.9.0-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-psutil/python-psutil_5.9.0-1build1.dsc' python-psutil_5.9.0-1build1.dsc 2196 SHA512:f8b1f9231aeae762da5344fc4d1b2a57ccdd92e0ebd6c231468bbf79f80e15c0ce9832a05e5dfa510d9b986c03b1d343446f07c1f7117cd94f7a90e8f69f560d
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-psutil/python-psutil_5.9.0.orig.tar.xz' python-psutil_5.9.0.orig.tar.xz 331792 SHA512:2d5ee8fd620175f05b2f3b1e8098d85ef1861c07a4ca59ac24c9cb2892c44b0ce008d3dd914e566435592255437b22cf22bbc60e9e67ca470ddb780e037ce7ac
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-psutil/python-psutil_5.9.0-1build1.debian.tar.xz' python-psutil_5.9.0-1build1.debian.tar.xz 6420 SHA512:ec22f855afa2bdd58ffffccd54a549e30332e4fee1f8713cc216bd04524a6a1756a8775bad1e08cd6dc2943b30fd43e8f9476c85e20673605b8c4d32b5c1ea16
```

### `dpkg` source package: `python-pyasn1-modules=0.2.1-1`

Binary Packages:

- `python3-pyasn1-modules=0.2.1-1`

Licenses: (parsed from: `/usr/share/doc/python3-pyasn1-modules/copyright`)

- `BSD-2-Clause`
- `BSD-3-Clause`

Source:

```console
$ apt-get source -qq --print-uris python-pyasn1-modules=0.2.1-1
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-pyasn1-modules/python-pyasn1-modules_0.2.1-1.dsc' python-pyasn1-modules_0.2.1-1.dsc 2140 SHA512:c55b3d07731f775db55863ddd40ecbe8167a35735d1b092ab8f484988d4140aa7a8dd77a8557e8e0e532bf3ca4573f232d52a1e43960da83d78b4a7d5baa9036
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-pyasn1-modules/python-pyasn1-modules_0.2.1.orig.tar.gz' python-pyasn1-modules_0.2.1.orig.tar.gz 65808 SHA512:2d8b6bee59434fee41747625236c1d7eb5081a1cef66aa0a0e9e75869c3641a418d21544edafe65f1808ad0dacd9cf1047dd036ff5ce668bb3bf1f6e662e4a5e
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-pyasn1-modules/python-pyasn1-modules_0.2.1-1.debian.tar.xz' python-pyasn1-modules_0.2.1-1.debian.tar.xz 2336 SHA512:763e4c9af242a14609fe285acb23cdff1436691173623fcdacdffcbc52e773dbb7e18ac4039e4a024721d1d48ad2d9280254572d9336aedc1a3827b03b3c6d3d
```

### `dpkg` source package: `python-qrcode=7.3.1-1`

Binary Packages:

- `python3-qrcode=7.3.1-1`

Licenses: (parsed from: `/usr/share/doc/python3-qrcode/copyright`)

- `BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris python-qrcode=7.3.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-qrcode/python-qrcode_7.3.1-1.dsc' python-qrcode_7.3.1-1.dsc 2225 SHA512:8efbc3a0e896a0cd1a009ee26189cdd9d4f5b3c3cb49b91009c9d07dafedde781a26232b85d987f9bd11724cffcc5bc267cbb4adc4e3e83a77c1884ae529f2d0
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-qrcode/python-qrcode_7.3.1.orig.tar.gz' python-qrcode_7.3.1.orig.tar.gz 523681 SHA512:e08498e73281d850c2cf64b3371b669605dc523420180b48c4bfc5a464f6184fc36f78741358699c450937066514f21ae0e76b0b3bbbcb40a0dedf116b31838d
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-qrcode/python-qrcode_7.3.1-1.debian.tar.xz' python-qrcode_7.3.1-1.debian.tar.xz 4640 SHA512:b23501c69f2c2c311b908c440a8fd2a6adc0245f59f8e6d208c5ebaff94f85f8102c3feb47e8fd087975073e25eae289384f6d3e94ccc83ce3b42aa82b4b1dd1
```

### `dpkg` source package: `python-reportlab=3.6.8-1ubuntu0.1`

Binary Packages:

- `python3-renderpm:amd64=3.6.8-1ubuntu0.1`
- `python3-reportlab=3.6.8-1ubuntu0.1`
- `python3-reportlab-accel:amd64=3.6.8-1ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/python3-renderpm/copyright`, `/usr/share/doc/python3-reportlab/copyright`, `/usr/share/doc/python3-reportlab-accel/copyright`)

- `GPL`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris python-reportlab=3.6.8-1ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-reportlab/python-reportlab_3.6.8-1ubuntu0.1.dsc' python-reportlab_3.6.8-1ubuntu0.1.dsc 2250 SHA512:ffa16d87609f8e25b9b4d8a39dadb2e7762848a04ae11940836b5ec5d28b8f3d12a7a448e4ecba8417f2c0ac019ee443670ebbf6c63b7657e9a3119a1bf8c89f
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-reportlab/python-reportlab_3.6.8.orig.tar.gz' python-reportlab_3.6.8.orig.tar.gz 4503191 SHA512:7eb2381a8020f751f03008bb8dc1eb07f954a97c0c3d38646602a22ed7f69dd73e11bbd1251a471da141c98492be7f3867cf120e489c58911ae6e9f29c926507
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-reportlab/python-reportlab_3.6.8-1ubuntu0.1.debian.tar.xz' python-reportlab_3.6.8-1ubuntu0.1.debian.tar.xz 17408 SHA512:fb49ab49b2150d984df4fa2f80b23caddbb128bd944bab17ab0bc02378e32af0f2bbeeaab28caa9779ef5f6cfe1fe6aa757a4b6b0dcd7ca12a7c05111053e3cb
```

### `dpkg` source package: `python-requests-toolbelt=0.9.1-1`

Binary Packages:

- `python3-requests-toolbelt=0.9.1-1`

Licenses: (parsed from: `/usr/share/doc/python3-requests-toolbelt/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris python-requests-toolbelt=0.9.1-1
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-requests-toolbelt/python-requests-toolbelt_0.9.1-1.dsc' python-requests-toolbelt_0.9.1-1.dsc 2384 SHA512:ec4e9c88d0d152da9528f018fc13cf01ecfb83e66b92ee234b61803f2a4b2c80f00ac19fbd74b909255636a10017f4d322db1d02e66a55766602e3d80f3c3be9
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-requests-toolbelt/python-requests-toolbelt_0.9.1.orig.tar.gz' python-requests-toolbelt_0.9.1.orig.tar.gz 207286 SHA512:12229928df5df71cb57bc65ef453dc0e4a2bbe190c1579811b2c2823673bd81aeba856b00000fa20b253d0f0fa4fff55ea1e750794ca3785f71c376b1df7fd93
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-requests-toolbelt/python-requests-toolbelt_0.9.1-1.debian.tar.xz' python-requests-toolbelt_0.9.1-1.debian.tar.xz 3412 SHA512:b240ba6cb092a47e9252a9e9b86ac94240f1519c8cbf1294b42f8370f8229766251d028ed18417c535295a8cf4da2fcd0f62ae16411f691c70b1252e0dc7ea45
```

### `dpkg` source package: `python-rjsmin=1.1.0+dfsg1-3build6`

Binary Packages:

- `python3-rjsmin=1.1.0+dfsg1-3build6`

Licenses: (parsed from: `/usr/share/doc/python3-rjsmin/copyright`)

- `Apache-2`
- `Apache-2.0`
- `BSD-3-clause`
- `Expat`
- `LGPL-2`

Source:

```console
$ apt-get source -qq --print-uris python-rjsmin=1.1.0+dfsg1-3build6
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-rjsmin/python-rjsmin_1.1.0%2bdfsg1-3build6.dsc' python-rjsmin_1.1.0+dfsg1-3build6.dsc 2187 SHA512:30dccf2de5d41e9d41064c4253dbf69c89ae07d0e06d018eca9e206219796c5a84210ed69156414a4857c2f6e4400c9e3a24bcfa4071ecd7815e32acc11ef9dd
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-rjsmin/python-rjsmin_1.1.0%2bdfsg1.orig.tar.xz' python-rjsmin_1.1.0+dfsg1.orig.tar.xz 348312 SHA512:22d757ffcd5a4e5df686fadc8d50387a27807a78ccf9172ee57beccf752dda3577955f178ced441ddb590c5a892baa6786381c9ec2f89a329f50e7cd7738cbed
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-rjsmin/python-rjsmin_1.1.0%2bdfsg1-3build6.debian.tar.xz' python-rjsmin_1.1.0+dfsg1-3build6.debian.tar.xz 5560 SHA512:0e398d660710beb4e0e2e64ef8554e9b8b41d342457bbd15bdda6c54113a5655b288728d9b61dfc5c7eb4a6a9d282130a814f8fbda5f240543ced1546d019fab
```

### `dpkg` source package: `python-roman=3.3-1`

Binary Packages:

- `python3-roman=3.3-1`

Licenses: (parsed from: `/usr/share/doc/python3-roman/copyright`)

- `Python-2.1.1`
- `ZPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris python-roman=3.3-1
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-roman/python-roman_3.3-1.dsc' python-roman_3.3-1.dsc 2100 SHA512:1d32743ab9a2408caf26a52b37263c7f6d7895f911ed2e8eefbc07cec275430aee3a17ea0dccb55ca39cdccb37fd2a312cec650ca9f5e5fdd4ce6aa8c74ff8f3
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-roman/python-roman_3.3.orig.tar.gz' python-roman_3.3.orig.tar.gz 7174 SHA512:90aab322e4135f221f8278c61ee6ebf2c15f3e35c9eabea19af01c08b95fe01e32faf77da479f80897c7fea6d175dc004b4c72a3cf4105db9e9665c3a30d28ed
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-roman/python-roman_3.3-1.debian.tar.xz' python-roman_3.3-1.debian.tar.xz 6820 SHA512:346b0233f997b09df68a7cc13d0e00288ce69013eebff26e46ce0435f885ed2083e3ec99a2f2fb4bccc6d4749a8bd8ad1b8e9c75ce008e4e5773ff8722999463
```

### `dpkg` source package: `python-slugify=4.0.0-1`

Binary Packages:

- `python3-slugify=4.0.0-1`

Licenses: (parsed from: `/usr/share/doc/python3-slugify/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris python-slugify=4.0.0-1
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-slugify/python-slugify_4.0.0-1.dsc' python-slugify_4.0.0-1.dsc 2000 SHA512:cec98793dc9cc409929165c95c565ad11ecfd3277f3f2a86fa4a8d14592e88cd164e702932aafe77b1224e9c21b32653c95b55b3b0dba6be74098f720a456028
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-slugify/python-slugify_4.0.0.orig.tar.gz' python-slugify_4.0.0.orig.tar.gz 9260 SHA512:a0d1a987553627b24b800290317e441d699d6a1b5eb3bf7c68bc44d27f0349a643a23926985278d6d5224b6fabef52d02d0a0a3ccdb639545442fa5a78db925c
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-slugify/python-slugify_4.0.0-1.debian.tar.xz' python-slugify_4.0.0-1.debian.tar.xz 3284 SHA512:f7cb400f57ee2acd0ea973a42bda15e13b46cf916adbae4455d0ec5065f664fffb047dfa5d0b074e7763b71a0851d4ab32f0db08188de36512b4510bac94bec7
```

### `dpkg` source package: `python-stdnum=1.17-1`

Binary Packages:

- `python3-stdnum=1.17-1`

Licenses: (parsed from: `/usr/share/doc/python3-stdnum/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris python-stdnum=1.17-1
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-stdnum/python-stdnum_1.17-1.dsc' python-stdnum_1.17-1.dsc 2416 SHA512:80dd2a8285315621228f3016bedd1dc84ea5cb9683c7d3eac1b8067648153c2e0911a006faa9b646d9e1ddd31685264b521006e714f3d9551a9533cb39239b54
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-stdnum/python-stdnum_1.17.orig.tar.gz' python-stdnum_1.17.orig.tar.gz 1068804 SHA512:9ddec525ea153e3066f205ee70602a59821e793f9ffde66a4b01511daf9a559a3a42082a99bddf69c1159a27b2d9e64d91f8a65ee283a2d7da473d766ce0e711
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-stdnum/python-stdnum_1.17.orig.tar.gz.asc' python-stdnum_1.17.orig.tar.gz.asc 866 SHA512:a046a201e8e1834a37a72807d84d2c19933371b30cce7eac6fec6c46ca00707829a3a57b5a2e5fc959eed730074ec023ab801ff041a486f9eaed081e578350d3
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-stdnum/python-stdnum_1.17-1.debian.tar.xz' python-stdnum_1.17-1.debian.tar.xz 22492 SHA512:bcbd786a7d75f1d86d791787b4009d1d5c64208bb0e33bcd5afb75445dd474340f52c5fea48223db8413de0442ca22beef0474ca81da0fe52d4d35769d81671c
```

### `dpkg` source package: `python-tz=2022.1-1ubuntu0.22.04.1`

Binary Packages:

- `python3-tz=2022.1-1ubuntu0.22.04.1`

Licenses: (parsed from: `/usr/share/doc/python3-tz/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris python-tz=2022.1-1ubuntu0.22.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-tz/python-tz_2022.1-1ubuntu0.22.04.1.dsc' python-tz_2022.1-1ubuntu0.22.04.1.dsc 2353 SHA512:cc45c79b8f6a19a1eecd6a698aca5315541d319135ec19928e175f182f681d2ca3870768541669d4523a5934e0e08f988e1df1dd2780e7845313d4091d81212d
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-tz/python-tz_2022.1.orig.tar.xz' python-tz_2022.1.orig.tar.xz 136808 SHA512:4f6b93340a22fac3000febb9922052db8adea6e835aa71018f833c157df9e21fff0dd30faeb6275eebe97f91555d9014a26a2c477034dffcfadb2d2bf29f019a
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-tz/python-tz_2022.1-1ubuntu0.22.04.1.debian.tar.xz' python-tz_2022.1-1ubuntu0.22.04.1.debian.tar.xz 14004 SHA512:b6303140a7818beb39ab6297edf7ff75d1bd2a6e6d613bb41165d9761f8b75df31a4d4379f419ce0688c6dea2e7f34a058ce28681d03d176e36e0d56fbab25a8
```

### `dpkg` source package: `python-urllib3=1.26.5-1~exp1ubuntu0.2`

Binary Packages:

- `python3-urllib3=1.26.5-1~exp1ubuntu0.2`

Licenses: (parsed from: `/usr/share/doc/python3-urllib3/copyright`)

- `Expat`
- `PSF-2`

Source:

```console
$ apt-get source -qq --print-uris python-urllib3=1.26.5-1~exp1ubuntu0.2
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-urllib3/python-urllib3_1.26.5-1%7eexp1ubuntu0.2.dsc' python-urllib3_1.26.5-1~exp1ubuntu0.2.dsc 2378 SHA512:f6eb7387a8ecdbd976f8cf8a6a4c4990eba0061d052ae27c17fdecf360835396c23b102c0aada5f7f5a3d6d916c5b046c764c20f9be40989e82e56d7e8f0ee91
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-urllib3/python-urllib3_1.26.5.orig.tar.gz' python-urllib3_1.26.5.orig.tar.gz 292865 SHA512:4a1899b223b00894d49f6dff5fc95d410e5b0ab28c11f7e3cd82d03e50438b0c5b0adf693a33fd80f1586312dc0012836713998674da15531bf82d52645881f6
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-urllib3/python-urllib3_1.26.5-1%7eexp1ubuntu0.2.debian.tar.xz' python-urllib3_1.26.5-1~exp1ubuntu0.2.debian.tar.xz 15604 SHA512:b4d78f88e447f739c7378ffff98146e239df1f662c8f99e0708df6538e579450502dc6fbfcdd4ba6845ec957a3bf33a77e269153c491a36069a01a357e02f36b
```

### `dpkg` source package: `python-vobject=0.9.6.1-0.2`

Binary Packages:

- `python3-vobject=0.9.6.1-0.2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris python-vobject=0.9.6.1-0.2
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-vobject/python-vobject_0.9.6.1-0.2.dsc' python-vobject_0.9.6.1-0.2.dsc 2146 SHA512:d88539a62099de520f0024b8016620b64cbe8da7203c8647421ec4a5fd6b48554c2d437c3ea8608606aa4db63a03dd6df011c48eb36a2243cd90606159145989
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-vobject/python-vobject_0.9.6.1.orig.tar.gz' python-vobject_0.9.6.1.orig.tar.gz 216565 SHA512:499f22a1a9e60398a89d3d6fa472a0b4c9dd00b98440a4ce873da824f83cef1b0a5eb9e5051267931707a3eef00a1d3fb83ff63ffe857b403c4ac3a131f18dff
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-vobject/python-vobject_0.9.6.1-0.2.debian.tar.xz' python-vobject_0.9.6.1-0.2.debian.tar.xz 6020 SHA512:c422992afb8337411eb6853fe50d3ae3534dd47425ee1b7911be30490faee9d1672fa6b36a9ed95705c7fd5e2077204d01007c078bf4c31ad3423da770e3452b
```

### `dpkg` source package: `python-watchdog=2.1.6-1`

Binary Packages:

- `python3-watchdog=2.1.6-1`

Licenses: (parsed from: `/usr/share/doc/python3-watchdog/copyright`)

- `Apache-2`
- `Apache-2.0`
- `BSD-3`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris python-watchdog=2.1.6-1
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-watchdog/python-watchdog_2.1.6-1.dsc' python-watchdog_2.1.6-1.dsc 2399 SHA512:c6004d3e9f3aa23a09b1a8b8fca3eb7a9790791b121e1545a96ef06309fb97444e2ebeb4e074eb840753608c37b878a1dbd79cca94ffb29081d1f3f673dbc072
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-watchdog/python-watchdog_2.1.6.orig.tar.gz' python-watchdog_2.1.6.orig.tar.gz 107292 SHA512:818aa46df3f1dbab027f6c7884b3ddf622b946df0c65e456e66939128d3e7cf44096feaec5c86bceb4c2d6dfa3ce9b7c363085c35b59d433cd0c1ec1e3ae8fb1
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-watchdog/python-watchdog_2.1.6-1.debian.tar.xz' python-watchdog_2.1.6-1.debian.tar.xz 5972 SHA512:f3b9c4f0756fb40f5eb2d7a30f8286ff5df8ca0e50d1fca3325daabe4cfcc40602ed466802012408eb792cad9e5f47aa8cdc2a8d282bc7da4fee287dd9b333bc
```

### `dpkg` source package: `python-werkzeug=2.0.2+dfsg1-1ubuntu0.22.04.2`

Binary Packages:

- `python3-werkzeug=2.0.2+dfsg1-1ubuntu0.22.04.2`

Licenses: (parsed from: `/usr/share/doc/python3-werkzeug/copyright`)

- `BSD-3-clause`
- `GAP`

Source:

```console
$ apt-get source -qq --print-uris python-werkzeug=2.0.2+dfsg1-1ubuntu0.22.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-werkzeug/python-werkzeug_2.0.2%2bdfsg1-1ubuntu0.22.04.2.dsc' python-werkzeug_2.0.2+dfsg1-1ubuntu0.22.04.2.dsc 2686 SHA512:3db55709af190ce788ae5bc6a499d78996c0b64163941577a8c30892488286d2cd919c426cae1e2adcb813ed3859e026d81205c29d01387b1a72629066ce52ba
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-werkzeug/python-werkzeug_2.0.2%2bdfsg1.orig.tar.xz' python-werkzeug_2.0.2+dfsg1.orig.tar.xz 744452 SHA512:daba31c47a4e96b0f7161ced5069c8c5fd99310af2b41afae768d29a00bc37403f994373e1a7555e78614db4e03f9045886bc9b202e32943f01093668fecbd05
'http://archive.ubuntu.com/ubuntu/pool/main/p/python-werkzeug/python-werkzeug_2.0.2%2bdfsg1-1ubuntu0.22.04.2.debian.tar.xz' python-werkzeug_2.0.2+dfsg1-1ubuntu0.22.04.2.debian.tar.xz 13696 SHA512:40a430598cdf064c943595d1de3ec28c693c330aba8aa82fa3b4d295da2cd83b4d478fb14f8f083fc3d19ac4d2f55d7b99374abbc6b44f7653387fe209d50798
```

### `dpkg` source package: `python-xlrd=1.2.0-2`

Binary Packages:

- `python3-xlrd=1.2.0-2`

Licenses: (parsed from: `/usr/share/doc/python3-xlrd/copyright`)

- `BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris python-xlrd=1.2.0-2
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-xlrd/python-xlrd_1.2.0-2.dsc' python-xlrd_1.2.0-2.dsc 2143 SHA512:4018232045e6ac2e4557b8f8c0c1bdf5152544ab0edd40b77ba2279e3968d4342fae4493f2c0ab3f9dce356e10d3bf39380c4d6be5927a114eb7300261752b04
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-xlrd/python-xlrd_1.2.0.orig.tar.gz' python-xlrd_1.2.0.orig.tar.gz 554079 SHA512:eea14845701b86a2679f140c9730e8ee2722b4f859cdd870f86bf54df522d54fc3c78dc4354aeb958c72596a6349995e9d79935efc734de096f6e007945fc1b3
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-xlrd/python-xlrd_1.2.0-2.debian.tar.xz' python-xlrd_1.2.0-2.debian.tar.xz 7420 SHA512:3b1ccbe76995209c53e63ab67da8fa100b5899b12bcdd7c5a3d99a0f3f7af8c5254bb9734b220080836ea53154bfd6d38104bcba664739366d0768370a5971d2
```

### `dpkg` source package: `python-zeep=4.1.0-1`

Binary Packages:

- `python3-zeep=4.1.0-1`

Licenses: (parsed from: `/usr/share/doc/python3-zeep/copyright`)

- `Apache`
- `BSD-3-clause`
- `Expat`
- `W3C`

Source:

```console
$ apt-get source -qq --print-uris python-zeep=4.1.0-1
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-zeep/python-zeep_4.1.0-1.dsc' python-zeep_4.1.0-1.dsc 2479 SHA512:d2041b6544e043cef9490de39603a0b69c98c9828cbb91fc7199c10892e1a3c631208ae413d26405c0974468a20d4e20cddebe218a2c6182da0315b5137515d0
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-zeep/python-zeep_4.1.0.orig.tar.gz' python-zeep_4.1.0.orig.tar.gz 160333 SHA512:acc54f99d21fe401e06418223591bcf8e7f8819e225f892beb0f6e2a1ee359a0da6f9d0aa4212899197c084af37cc56126879b93a22cdad2458e57674bf66ed5
'http://archive.ubuntu.com/ubuntu/pool/universe/p/python-zeep/python-zeep_4.1.0-1.debian.tar.xz' python-zeep_4.1.0-1.debian.tar.xz 11836 SHA512:0523bbcd686e6eab2eb0cdb29ba1b9403c33a9a8a48a7c17528ca6010c53e9fa4c8b5e236e449b1a4d17fc037fc3ac269676906b7bac11ab937cc4a37de65604
```

### `dpkg` source package: `python3-defaults=3.10.6-1~22.04.1`

Binary Packages:

- `libpython3-stdlib:amd64=3.10.6-1~22.04.1`
- `python3=3.10.6-1~22.04.1`
- `python3-minimal=3.10.6-1~22.04.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris python3-defaults=3.10.6-1~22.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/p/python3-defaults/python3-defaults_3.10.6-1%7e22.04.1.dsc' python3-defaults_3.10.6-1~22.04.1.dsc 2951 SHA512:ce4c67568f3b0fd6c8f8d2daa74351825f1595b69998dce13f82caa077729cdb83fc472a636a466e27dd1ae681035e2b11bd82f73fa33c10b400c017afd54c90
'http://archive.ubuntu.com/ubuntu/pool/main/p/python3-defaults/python3-defaults_3.10.6-1%7e22.04.1.tar.gz' python3-defaults_3.10.6-1~22.04.1.tar.gz 145962 SHA512:c509a2a887e4b758fbfcb6173ff046a6f73bdfdde3bd89f77102a4d99c7219d8e1805b41541c6cf658fe9dd44da188e6af450d87236d863d29f06147fea26ea1
```

### `dpkg` source package: `python3-stdlib-extensions=3.10.8-1~22.04`

Binary Packages:

- `python3-distutils=3.10.8-1~22.04`
- `python3-lib2to3=3.10.8-1~22.04`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris python3-stdlib-extensions=3.10.8-1~22.04
'http://archive.ubuntu.com/ubuntu/pool/main/p/python3-stdlib-extensions/python3-stdlib-extensions_3.10.8-1%7e22.04.dsc' python3-stdlib-extensions_3.10.8-1~22.04.dsc 2599 SHA512:4ff10912289f2bb26884c865c18aed3b19c310dda74d75b838575aaecb3cdc256bea1e14dad5c079bb5a3c5ec3553e136e461d0bf39af956a4e287caae8e2aa6
'http://archive.ubuntu.com/ubuntu/pool/main/p/python3-stdlib-extensions/python3-stdlib-extensions_3.10.8.orig.tar.xz' python3-stdlib-extensions_3.10.8.orig.tar.xz 1118220 SHA512:0583a86aad9ce78df7c175c82fe09611a72e7d60567f5269843781711702c6f3ae0c209a1a8b71eb35d9c9a5e210e8fbac1c7e6302e106cde48a2db0d29dc2ad
'http://archive.ubuntu.com/ubuntu/pool/main/p/python3-stdlib-extensions/python3-stdlib-extensions_3.10.8-1%7e22.04.debian.tar.xz' python3-stdlib-extensions_3.10.8-1~22.04.debian.tar.xz 25884 SHA512:214b4a62091181291a22ce1a2016e5b3d8f24f62f245494f82bd3a527b46886f1537f1e33fcde5261c81cb50d6d177cdeb899955d7da7c367511594ed99825ce
```

### `dpkg` source package: `python3.10=3.10.12-1~22.04.6`

Binary Packages:

- `libpython3.10-minimal:amd64=3.10.12-1~22.04.6`
- `libpython3.10-stdlib:amd64=3.10.12-1~22.04.6`
- `python3.10=3.10.12-1~22.04.6`
- `python3.10-minimal=3.10.12-1~22.04.6`

Licenses: (parsed from: `/usr/share/doc/libpython3.10-minimal/copyright`, `/usr/share/doc/libpython3.10-stdlib/copyright`, `/usr/share/doc/python3.10/copyright`, `/usr/share/doc/python3.10-minimal/copyright`)

- `* Permission to use this software in any way is granted without`
- `By obtaining, using, and/or copying this software and/or its`
- `GPL-2`
- `Permission  is  hereby granted,  free  of charge,  to  any person`
- `Permission is hereby granted, free of charge, to any person obtaining`
- `Permission to use, copy, modify,`
- `Redistribution`
- `This software is provided 'as-is', without any express`
- `This software is provided as-is, without express`
- `binary forms, with`
- `distribute this software`
- `distribute this software and`
- `distribute this software for any`
- `implied`
- `its`
- `use in source`
- `without`

Source:

```console
$ apt-get source -qq --print-uris python3.10=3.10.12-1~22.04.6
'http://archive.ubuntu.com/ubuntu/pool/main/p/python3.10/python3.10_3.10.12-1%7e22.04.6.dsc' python3.10_3.10.12-1~22.04.6.dsc 3674 SHA512:5019349e8e95a79503aa5b2719e47addcc5c2df7b180ac978fe5313ae51509ce041f2bc492a6d0cc52fdf1683491b4ec31906702e8f1116cbd55f024afd9733d
'http://archive.ubuntu.com/ubuntu/pool/main/p/python3.10/python3.10_3.10.12.orig.tar.xz' python3.10_3.10.12.orig.tar.xz 19654836 SHA512:5ea018e71bfe7872e02eaf8aef56d5583c0880e4ce5fbbdf8ea76da20c2e94ac6a3ba8badb4b7d1bc21853402a3b63541b04181737417b1626e786b696595cf5
'http://archive.ubuntu.com/ubuntu/pool/main/p/python3.10/python3.10_3.10.12-1%7e22.04.6.debian.tar.xz' python3.10_3.10.12-1~22.04.6.debian.tar.xz 243264 SHA512:0c93b8fe785b0b7137e922436782c5e9bf183794d9c8cfeaea6f3a56673136ff4c228f4831ef380048e28a550f276f7034d615df40d884f2c2a4be25aad0a9d8
```

### `dpkg` source package: `pyusb=1.2.1-1`

Binary Packages:

- `python3-usb=1.2.1-1`

Licenses: (parsed from: `/usr/share/doc/python3-usb/copyright`)

- `BSD-3`

Source:

```console
$ apt-get source -qq --print-uris pyusb=1.2.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/p/pyusb/pyusb_1.2.1-1.dsc' pyusb_1.2.1-1.dsc 1456 SHA512:510ca21a366d0182f8da38e1f0a0ff4a24dc74f574d599199b8a21e15302daf1459f33fb425c5c4d32f9cf575b494fc2b6519b5f435c2093fb2a8a9927aeed5e
'http://archive.ubuntu.com/ubuntu/pool/universe/p/pyusb/pyusb_1.2.1.orig.tar.gz' pyusb_1.2.1.orig.tar.gz 71549 SHA512:1cfde4f816dd3a4a8b8bdc2612c80b8b7e7e3c29b1e90e75dc32b0a40c21a5912cdbfe539e79ab82542dad324b922a97b343f0cb1eb13507be3ce16b896dd190
'http://archive.ubuntu.com/ubuntu/pool/universe/p/pyusb/pyusb_1.2.1-1.debian.tar.xz' pyusb_1.2.1-1.debian.tar.xz 5252 SHA512:68674c8e75b9ce80796d0779afd8c696e1626b64b58810d8a1bed48f0817482abc70cc617a1a445e19c98ce78fd56175ca3f02f2289174435697f1988708251d
```

### `dpkg` source package: `pyyaml=5.4.1-1ubuntu1`

Binary Packages:

- `python3-yaml=5.4.1-1ubuntu1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris pyyaml=5.4.1-1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/p/pyyaml/pyyaml_5.4.1-1ubuntu1.dsc' pyyaml_5.4.1-1ubuntu1.dsc 2146 SHA512:1ac92a9ab02d920f47e29ae5ef2b83b62b757d7371945c16f581e0e8500b581229b6a6b3c17a49012d3e3e366e15065c8a51c7a9dfa228197a9cd00e17764a31
'http://archive.ubuntu.com/ubuntu/pool/main/p/pyyaml/pyyaml_5.4.1.orig.tar.gz' pyyaml_5.4.1.orig.tar.gz 175147 SHA512:359c45d843fd839797572efeab121f17b1947647960dfb062f3618f25f71e1a6bc4bab14a1720b6b67f256089d5d48c452ec5419e3130222765c7ca41db11dad
'http://archive.ubuntu.com/ubuntu/pool/main/p/pyyaml/pyyaml_5.4.1-1ubuntu1.debian.tar.xz' pyyaml_5.4.1-1ubuntu1.debian.tar.xz 7548 SHA512:401ea5fc96980189e681e5a096ed5bb14d02f5ee4688db424544a30c4fe3ca132264e50cd61af1bdda05576005e8b369f11f6f173e6bad1d612c77c3a2c32ecc
```

### `dpkg` source package: `raqm=0.7.0-4ubuntu1`

Binary Packages:

- `libraqm0:amd64=0.7.0-4ubuntu1`

Licenses: (parsed from: `/usr/share/doc/libraqm0/copyright`)

- `MIT`

Source:

```console
$ apt-get source -qq --print-uris raqm=0.7.0-4ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/r/raqm/raqm_0.7.0-4ubuntu1.dsc' raqm_0.7.0-4ubuntu1.dsc 2238 SHA512:4afaa05bbbc286313f9e6714827dc67938e2d593feb3b96c69d279e292527608b34e491d8f2df6272ed5ef17995714602e9ea275ed1b5ab09039fb7f931d6d38
'http://archive.ubuntu.com/ubuntu/pool/main/r/raqm/raqm_0.7.0.orig.tar.gz' raqm_0.7.0.orig.tar.gz 683634 SHA512:4aed401df0b53cc95423afa5980164b54102776eca675119fc483c410334a635ca95ef6564ee9b54666c13c916eb52a0a1cd24f288230946c53825fb10451161
'http://archive.ubuntu.com/ubuntu/pool/main/r/raqm/raqm_0.7.0-4ubuntu1.debian.tar.xz' raqm_0.7.0-4ubuntu1.debian.tar.xz 4248 SHA512:d254641786f14db821e96c62c3993bf31463b19b612d093c72fc612fd297dd6393b49fabcb78dcf72cb2056725773a5c19c26968e16ec18f6dc2d6506970b523
```

### `dpkg` source package: `readline=8.1.2-1`

Binary Packages:

- `libreadline8:amd64=8.1.2-1`
- `readline-common=8.1.2-1`

Licenses: (parsed from: `/usr/share/doc/libreadline8/copyright`, `/usr/share/doc/readline-common/copyright`)

- `GFDL`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris readline=8.1.2-1
'http://archive.ubuntu.com/ubuntu/pool/main/r/readline/readline_8.1.2-1.dsc' readline_8.1.2-1.dsc 2432 SHA512:3166229d2ac183a46455c7d8cf17ef1d509ca8651ffa7887f654d87bbe1d00a08f9a9f73f14e652ac067d89e5d1128998f8f09f6a1128c56049338ace65ed773
'http://archive.ubuntu.com/ubuntu/pool/main/r/readline/readline_8.1.2.orig.tar.gz' readline_8.1.2.orig.tar.gz 2993073 SHA512:b512275c8aa8b3b3178366c6d681f867676fc1c881e375134a88e9c860a448535e04ca43df727817fd0048261e48203e88bd1c086e86572022d1d65fb0350e4d
'http://archive.ubuntu.com/ubuntu/pool/main/r/readline/readline_8.1.2-1.debian.tar.xz' readline_8.1.2-1.debian.tar.xz 29292 SHA512:a64621c93975bc42ba171c9298c932f9515025513911e744183092e0ef9873db474c4ec27a21f310f40e7b970ba6300edb057552f7e90fc469897ffa2eb706f0
```

### `dpkg` source package: `requests-file=1.5.1-1`

Binary Packages:

- `python3-requests-file=1.5.1-1`

Licenses: (parsed from: `/usr/share/doc/python3-requests-file/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris requests-file=1.5.1-1
'http://archive.ubuntu.com/ubuntu/pool/universe/r/requests-file/requests-file_1.5.1-1.dsc' requests-file_1.5.1-1.dsc 1636 SHA512:e2b8ec2a0fe3c40baae21e34532503c8b62cae561cca9ea93bdf2263d28be240b5aa4e69aca133b0b48a024bad06004433fbd65e66d17437e39617b475c62fe3
'http://archive.ubuntu.com/ubuntu/pool/universe/r/requests-file/requests-file_1.5.1.orig.tar.gz' requests-file_1.5.1.orig.tar.gz 5994 SHA512:821d2c8092b035308d2723b28d0780cb0ae52b1a2856c3399d57357fbc0da4dc3568af67a5910163e86e90bfd6dc8e7195dce3a2adee7a74b228d6dd4b10ae5a
'http://archive.ubuntu.com/ubuntu/pool/universe/r/requests-file/requests-file_1.5.1-1.debian.tar.xz' requests-file_1.5.1-1.debian.tar.xz 3648 SHA512:bf1046a40f9492eaa470f7b731ac6d38fd6155284848b5a432da1f6d239fb05d20733333d5f614e09dc22fb9891544d934ab2c00d429d9ae5dc971d38e106406
```

### `dpkg` source package: `requests=2.25.1+dfsg-2ubuntu0.1`

Binary Packages:

- `python3-requests=2.25.1+dfsg-2ubuntu0.1`

Licenses: (parsed from: `/usr/share/doc/python3-requests/copyright`)

- `Apache`
- `Apache-2.0`
- `other`

Source:

```console
$ apt-get source -qq --print-uris requests=2.25.1+dfsg-2ubuntu0.1
'http://archive.ubuntu.com/ubuntu/pool/main/r/requests/requests_2.25.1%2bdfsg-2ubuntu0.1.dsc' requests_2.25.1+dfsg-2ubuntu0.1.dsc 2346 SHA512:c14a19a00ec7e5044226756e40be833a9d36fb07be58821963cee24eb32d2b75f74656ee20044566838a34ff700aa2b14bd85ed5d0161633104c735324bc961a
'http://archive.ubuntu.com/ubuntu/pool/main/r/requests/requests_2.25.1%2bdfsg.orig.tar.xz' requests_2.25.1+dfsg.orig.tar.xz 127452 SHA512:24cf3c520628927bc2473e2d4107950e485e8ba15f875642e09a1749f845e838a65f0d10647c67d59dca06040418166bdcb08b19d2c545a5ef0f32114a6b3dbd
'http://archive.ubuntu.com/ubuntu/pool/main/r/requests/requests_2.25.1%2bdfsg-2ubuntu0.1.debian.tar.xz' requests_2.25.1+dfsg-2ubuntu0.1.debian.tar.xz 11840 SHA512:83b9b2684921fe26fb20d08c5457d32d265500983317aa5c0fac1d05c5e4aee9b4b3b552aa32aa4120b85327e52be2956a6cd38064d91684372d31b1fd99c1ac
```

### `dpkg` source package: `rtmpdump=2.4+20151223.gitfa8646d.1-2build4`

Binary Packages:

- `librtmp1:amd64=2.4+20151223.gitfa8646d.1-2build4`

Licenses: (parsed from: `/usr/share/doc/librtmp1/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris rtmpdump=2.4+20151223.gitfa8646d.1-2build4
'http://archive.ubuntu.com/ubuntu/pool/main/r/rtmpdump/rtmpdump_2.4%2b20151223.gitfa8646d.1-2build4.dsc' rtmpdump_2.4+20151223.gitfa8646d.1-2build4.dsc 2431 SHA512:7536b21c9c8be02e06171db49bf0b653e4b7738e6c01f74b0b7433c2986c731eafd1743f87836e7250a744d0e34dc700685bbe7128956a274e9a9832d32c891e
'http://archive.ubuntu.com/ubuntu/pool/main/r/rtmpdump/rtmpdump_2.4%2b20151223.gitfa8646d.1.orig.tar.gz' rtmpdump_2.4+20151223.gitfa8646d.1.orig.tar.gz 142213 SHA512:bdfcbab73179d614a295a7b136ea4c9d0ce4620883b493f298362784d245608cd6ad4b0ad30f94ed73a086b4555399521ae9e95b6375fce75e455ae68c055e7b
'http://archive.ubuntu.com/ubuntu/pool/main/r/rtmpdump/rtmpdump_2.4%2b20151223.gitfa8646d.1-2build4.debian.tar.xz' rtmpdump_2.4+20151223.gitfa8646d.1-2build4.debian.tar.xz 8376 SHA512:b01ac33a7251e3c0fad21897d31710766136027b656cb29903cf8f695893648631037a96fa18aa40eae7ad363394344aad4f2fae152622618b88f22133c03578
```

### `dpkg` source package: `sed=4.8-1ubuntu2`

Binary Packages:

- `sed=4.8-1ubuntu2`

Licenses: (parsed from: `/usr/share/doc/sed/copyright`)

- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris sed=4.8-1ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/s/sed/sed_4.8-1ubuntu2.dsc' sed_4.8-1ubuntu2.dsc 2217 SHA512:310ccdf0bac73d16c8898fd600acbeceb534a1be53c795fc6f6059eccb431b45ef9ebcde147c150f9fd5e0d33161269f53e191bb26a095b45339a28b1c3381b2
'http://archive.ubuntu.com/ubuntu/pool/main/s/sed/sed_4.8.orig.tar.xz' sed_4.8.orig.tar.xz 1348048 SHA512:7de25d9bc2981c63321c2223f3fbcab61d7b0df4fcf7d4394b72400b91993e1288d8bf53948ed5fffcf5a98c75265726a68ad4fb98e1d571bf768603a108c1c8
'http://archive.ubuntu.com/ubuntu/pool/main/s/sed/sed_4.8.orig.tar.xz.asc' sed_4.8.orig.tar.xz.asc 833 SHA512:9b886bdbd18ee2d60608cee3fd2b4193a1b6c3309d887ee05828c14b89b7b515dbf042a9e0ebdd13e6ccfa42e3cd217a408c796d68c4ebedaaa64f795000f095
'http://archive.ubuntu.com/ubuntu/pool/main/s/sed/sed_4.8-1ubuntu2.debian.tar.xz' sed_4.8-1ubuntu2.debian.tar.xz 60936 SHA512:c4f0c5b3f75acbcb213e78f5696129e83bc721031be3c756150e84b7aa7e725ac0d5afacbe18e91d39bc2b7892986d92e1e21db89601ccf2bccb8ac088482180
```

### `dpkg` source package: `sensible-utils=0.0.17`

Binary Packages:

- `sensible-utils=0.0.17`

Licenses: (parsed from: `/usr/share/doc/sensible-utils/copyright`)

- `All-permissive`
- `GPL-2`
- `GPL-2+`
- `configure`
- `installsh`

Source:

```console
$ apt-get source -qq --print-uris sensible-utils=0.0.17
'http://archive.ubuntu.com/ubuntu/pool/main/s/sensible-utils/sensible-utils_0.0.17.dsc' sensible-utils_0.0.17.dsc 1733 SHA512:33e94cbe40fbcb083564b4e4f5947f7c4dc0da0724245d19290667cf8a56eb60ba5b94c0c85e8eee2ae7c988a25a094e7edff3159bbe4339dcf9136a6336f2f7
'http://archive.ubuntu.com/ubuntu/pool/main/s/sensible-utils/sensible-utils_0.0.17.tar.xz' sensible-utils_0.0.17.tar.xz 66648 SHA512:fb7803cacc4222f232f64850e5559aca0b56ad98b6fd31f36c89740d72f7a235e7f2934ebce1d788882bff7196d59a2ed6cc3584f31e1c1c9e3593cedca2382b
```

### `dpkg` source package: `setuptools=59.6.0-1.2ubuntu0.22.04.2`

Binary Packages:

- `python3-pkg-resources=59.6.0-1.2ubuntu0.22.04.2`
- `python3-setuptools=59.6.0-1.2ubuntu0.22.04.2`

Licenses: (parsed from: `/usr/share/doc/python3-pkg-resources/copyright`, `/usr/share/doc/python3-setuptools/copyright`)

- `Apache-2.0`
- `BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris setuptools=59.6.0-1.2ubuntu0.22.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/s/setuptools/setuptools_59.6.0-1.2ubuntu0.22.04.2.dsc' setuptools_59.6.0-1.2ubuntu0.22.04.2.dsc 1672 SHA512:597929bb7376ecdb2e50a0fa1245864a199065ab69c1c68294259a9f96833a62f272beee809401d9c8adbcd10dd4023e90a7e65ac10c1fc4053a741afc8ff03a
'http://archive.ubuntu.com/ubuntu/pool/main/s/setuptools/setuptools_59.6.0.orig.tar.gz' setuptools_59.6.0.orig.tar.gz 2281973 SHA512:25472ec7c167e07113c6645880952458969b146766b64224ec8f40dfc2a29b23e47104b63e806292ec81ee4e9dbbdc4663228f39b4412b586cba644f69b52309
'http://archive.ubuntu.com/ubuntu/pool/main/s/setuptools/setuptools_59.6.0-1.2ubuntu0.22.04.2.debian.tar.xz' setuptools_59.6.0-1.2ubuntu0.22.04.2.debian.tar.xz 16896 SHA512:2655514b92ce474f85a60c3a593d2bd89febd94a02d09297d0007f3b9fe421fbcd6b63a0145226135db85720d3e020eb1c6ef4501e8cdf0e77d4c2b8aeb513b8
```

### `dpkg` source package: `sgml-base=1.30`

Binary Packages:

- `sgml-base=1.30`

Licenses: (parsed from: `/usr/share/doc/sgml-base/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris sgml-base=1.30
'http://archive.ubuntu.com/ubuntu/pool/main/s/sgml-base/sgml-base_1.30.dsc' sgml-base_1.30.dsc 1541 SHA512:6477c8b39b10f41b2059efe28c019fb89c9b2bdd3483a15784affa15bc08fffbd0237fadfab89ea588bee43e9c22ff3898f6c5b15ddb2325478acd2ea3f66bb6
'http://archive.ubuntu.com/ubuntu/pool/main/s/sgml-base/sgml-base_1.30.tar.xz' sgml-base_1.30.tar.xz 12536 SHA512:d1453cdad1791f83b29262dd496b23d6b1a468822ae6d28afced7961a56accc5e703123fcef9b6031118623cbb3a71556bc7e56b59322773ba473bc7ba228e9f
```

### `dpkg` source package: `shadow=1:4.8.1-2ubuntu2.2`

Binary Packages:

- `login=1:4.8.1-2ubuntu2.2`
- `passwd=1:4.8.1-2ubuntu2.2`

Licenses: (parsed from: `/usr/share/doc/login/copyright`, `/usr/share/doc/passwd/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris shadow=1:4.8.1-2ubuntu2.2
'http://archive.ubuntu.com/ubuntu/pool/main/s/shadow/shadow_4.8.1-2ubuntu2.2.dsc' shadow_4.8.1-2ubuntu2.2.dsc 2060 SHA512:765de71da656f0fd36b0872e05c1f736b167faf3af9a52247e0810d260606fe440a541c5558a882f8a5d150d91f76f01303cada28ba5febe4d16042eda3da7c8
'http://archive.ubuntu.com/ubuntu/pool/main/s/shadow/shadow_4.8.1.orig.tar.xz' shadow_4.8.1.orig.tar.xz 1611196 SHA512:780a983483d847ed3c91c82064a0fa902b6f4185225978241bc3bc03fcc3aa143975b46aee43151c6ba43efcfdb1819516b76ba7ad3d1d3c34fcc38ea42e917b
'http://archive.ubuntu.com/ubuntu/pool/main/s/shadow/shadow_4.8.1-2ubuntu2.2.debian.tar.xz' shadow_4.8.1-2ubuntu2.2.debian.tar.xz 98488 SHA512:dfa83a48e365f57c4881e77307bdea56db3e1b78e28ae687e5346daf1e71fe8df3388329ef6e7c90377555367267719e42e9c7f752da5b897e731bd9ca50a581
```

### `dpkg` source package: `six=1.16.0-3ubuntu1`

Binary Packages:

- `python3-six=1.16.0-3ubuntu1`

Licenses: (parsed from: `/usr/share/doc/python3-six/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris six=1.16.0-3ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/s/six/six_1.16.0-3ubuntu1.dsc' six_1.16.0-3ubuntu1.dsc 2341 SHA512:d1d67c99780bba0c6fea7346b8ce47223cdd68a531b1f8e1d639617cf48b8c6dd6eaf7c860cf0036ca2892a7853fa809527b060dec90aa509fa00cbb1050bad2
'http://archive.ubuntu.com/ubuntu/pool/main/s/six/six_1.16.0.orig.tar.gz' six_1.16.0.orig.tar.gz 34041 SHA512:076fe31c8f03b0b52ff44346759c7dc8317da0972403b84dfe5898179f55acdba6c78827e0f8a53ff20afe8b76432c6fe0d655a75c24259d9acbaa4d9e8015c0
'http://archive.ubuntu.com/ubuntu/pool/main/s/six/six_1.16.0-3ubuntu1.debian.tar.xz' six_1.16.0-3ubuntu1.debian.tar.xz 5072 SHA512:790dfd825c173fbfe6d54bc0e6bf8f6161b065ba1da561cb4e1fc8050e629f8d344a2e84e895855b7da696cf62acb2daf92aca8548a00f12e6eb239f30057e1c
```

### `dpkg` source package: `soupsieve=2.3.1-1`

Binary Packages:

- `python3-soupsieve=2.3.1-1`

Licenses: (parsed from: `/usr/share/doc/python3-soupsieve/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris soupsieve=2.3.1-1
'http://archive.ubuntu.com/ubuntu/pool/main/s/soupsieve/soupsieve_2.3.1-1.dsc' soupsieve_2.3.1-1.dsc 1667 SHA512:be640bdb8457b51644b267b5d7c3f12a5b19e6227911cda2f5528014b0dc41ad347c75eef9f9a74e543d7d391000b1545f6b1d22482f14f8eb6163e8597db013
'http://archive.ubuntu.com/ubuntu/pool/main/s/soupsieve/soupsieve_2.3.1.orig.tar.gz' soupsieve_2.3.1.orig.tar.gz 107520 SHA512:cbaa82f671a9bcb22e98fbea55e1c8042a759110eeddf2af6c37ae0592a79231bfe74211fce16a3331a1df5bf73a11a575da98a3bde0b281a1e238a361bff96c
'http://archive.ubuntu.com/ubuntu/pool/main/s/soupsieve/soupsieve_2.3.1-1.debian.tar.xz' soupsieve_2.3.1-1.debian.tar.xz 4424 SHA512:d6102f7571156fc091a421d064bb802b302f82282cbb8525f7cc5964fd092256a2dd060ca2f0b7934f109d8826ce8e18ee9b08fa5e33edcaea55f7ba085b94f1
```

### `dpkg` source package: `sphinx=4.3.2-1`

Binary Packages:

- `libjs-sphinxdoc=4.3.2-1`

Licenses: (parsed from: `/usr/share/doc/libjs-sphinxdoc/copyright`)

- `BSD-2-clause`
- `BSD-3-clause`
- `Expat`
- `PSF-2`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris sphinx=4.3.2-1
'http://archive.ubuntu.com/ubuntu/pool/main/s/sphinx/sphinx_4.3.2-1.dsc' sphinx_4.3.2-1.dsc 3502 SHA512:a8b619e88c4d587ca37efe962bbac451ef6d7e3c5724a29eb54dd01dd72281af775c64c7be9943e3ec6b5a35d61a3b51d8eafbbf4b2b29408b637802f8cdc6fd
'http://archive.ubuntu.com/ubuntu/pool/main/s/sphinx/sphinx_4.3.2.orig.tar.gz' sphinx_4.3.2.orig.tar.gz 6657148 SHA512:2045e1964aef54826a2cde30e6c09b7ec35d49a45b7e449c07ee107c41304435eb51e2be307af77bed4ec50534e6e4009501d58187baa1a129134b69cdc56dff
'http://archive.ubuntu.com/ubuntu/pool/main/s/sphinx/sphinx_4.3.2.orig.tar.gz.asc' sphinx_4.3.2.orig.tar.gz.asc 833 SHA512:3d91964c5fa07ca928f40b4c871e9e0ba08c39c47ff81b4d6a3c9fecaae703e1ec2e5d597f5a29d1dcfaca58ac6d9303b6e074de5ac8c834ed8be22d7764bb9f
'http://archive.ubuntu.com/ubuntu/pool/main/s/sphinx/sphinx_4.3.2-1.debian.tar.xz' sphinx_4.3.2-1.debian.tar.xz 40616 SHA512:1822779642dcf9297878082abae43fd751c7a7f34f4135516f3ff4a2d970f1d7222a5006cebd2b2c726990feee4a59badee2aee71e7643b12c6f15c636185f19
```

### `dpkg` source package: `sqlite3=3.37.2-2ubuntu0.3`

Binary Packages:

- `libsqlite3-0:amd64=3.37.2-2ubuntu0.3`

Licenses: (parsed from: `/usr/share/doc/libsqlite3-0/copyright`)

- `GPL-2`
- `GPL-2+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris sqlite3=3.37.2-2ubuntu0.3
'http://archive.ubuntu.com/ubuntu/pool/main/s/sqlite3/sqlite3_3.37.2-2ubuntu0.3.dsc' sqlite3_3.37.2-2ubuntu0.3.dsc 2602 SHA512:086e45082a9d83001d2c97407d1c2ce0869add89f27594ed412ce930d45d16318e644ac4e6deb571ddedb17d76a38af6c12ab39b6c1f1001f9423498cc045508
'http://archive.ubuntu.com/ubuntu/pool/main/s/sqlite3/sqlite3_3.37.2.orig-www.tar.xz' sqlite3_3.37.2.orig-www.tar.xz 5694016 SHA512:577e34b4ae18a3c73be6d955a2e2321e993f61decefbcca5112170072ea556eca93dcf55f3059fbcd96147124442b368150de7f68c603e84b80cbe0228ae78f8
'http://archive.ubuntu.com/ubuntu/pool/main/s/sqlite3/sqlite3_3.37.2.orig.tar.xz' sqlite3_3.37.2.orig.tar.xz 7623768 SHA512:dfa51b0a32ab0597cd00ae7abdb53bb255102f397ff8409f3fdbefaad17bc7d5a25f53db90bed47feb1bf4a9a1a4707bc40440c6c5303f3ef5c49ded61558fed
'http://archive.ubuntu.com/ubuntu/pool/main/s/sqlite3/sqlite3_3.37.2-2ubuntu0.3.debian.tar.xz' sqlite3_3.37.2-2ubuntu0.3.debian.tar.xz 30176 SHA512:6c8f4b6d233a566bdc7291a3135e0d748ef972cccbbdb50d145df1c3cae9f2fb3216e120e58e123e5234040865e69eb7e4c3720b24d655500d6514aff27056b7
```

### `dpkg` source package: `systemd=249.11-0ubuntu3.12`

Binary Packages:

- `libsystemd0:amd64=249.11-0ubuntu3.12`
- `libudev1:amd64=249.11-0ubuntu3.12`

Licenses: (parsed from: `/usr/share/doc/libsystemd0/copyright`, `/usr/share/doc/libudev1/copyright`)

- `CC0-1.0`
- `Expat`
- `GPL-2`
- `GPL-2 with Linux-syscall-note exception`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris systemd=249.11-0ubuntu3.12
'http://archive.ubuntu.com/ubuntu/pool/main/s/systemd/systemd_249.11-0ubuntu3.12.dsc' systemd_249.11-0ubuntu3.12.dsc 5907 SHA512:1dc21b48d93811597f96c6b5dadba42e7d1f6ea5408f2a4aaab8d5bbf3fdd480d50ce1d51647fc833dafa9a672830c11c0770801a5bcd111cd432f95477a0943
'http://archive.ubuntu.com/ubuntu/pool/main/s/systemd/systemd_249.11.orig.tar.gz' systemd_249.11.orig.tar.gz 10622702 SHA512:fed7f81933648945a4bfac9fb12150ecd84d32181f79be0e14e0b3a789343a87569f868670e0b8dfc2801fab39f7490f95ee8c29ba831d7611f78c14ace5ddd8
'http://archive.ubuntu.com/ubuntu/pool/main/s/systemd/systemd_249.11-0ubuntu3.12.debian.tar.xz' systemd_249.11-0ubuntu3.12.debian.tar.xz 253852 SHA512:76220a7cffbd1300a6a4ccebceeef05b65b25c51d9037a183afbb4b2b744da87b8fbab0195c168a55e71beef1cff8352d36a109f5d099ca6947a90d85584f572
```

### `dpkg` source package: `sysvinit=3.01-1ubuntu1`

Binary Packages:

- `sysvinit-utils=3.01-1ubuntu1`

Licenses: (parsed from: `/usr/share/doc/sysvinit-utils/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris sysvinit=3.01-1ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/s/sysvinit/sysvinit_3.01-1ubuntu1.dsc' sysvinit_3.01-1ubuntu1.dsc 2138 SHA512:650c939b7af5189cddf6509dd2b6a995c7b389ab4ee33bdad267d8c2b5b5506716b03e512563ed3e3265b32d2d1a9119ee0193f3dc82354896029ae124d2a276
'http://archive.ubuntu.com/ubuntu/pool/main/s/sysvinit/sysvinit_3.01.orig.tar.xz' sysvinit_3.01.orig.tar.xz 126400 SHA512:d3b197fcfccfbc2ad95fe208fb37ed1fcc8173a7a0254528c0d8c6800b054d96e20b48274c55137f19305c105700c35974d454b4bbf5e51fbbf5c082d562167b
'http://archive.ubuntu.com/ubuntu/pool/main/s/sysvinit/sysvinit_3.01-1ubuntu1.debian.tar.xz' sysvinit_3.01-1ubuntu1.debian.tar.xz 131304 SHA512:4c835855b58742480284b17959d54b8ac734466fc87321ddf021b61bb3e38b58aab6d07a7f27f09c0b109b4e442c0dce4d797feccce2884f5b401e13abf73554
```

### `dpkg` source package: `tar=1.34+dfsg-1ubuntu0.1.22.04.2`

Binary Packages:

- `tar=1.34+dfsg-1ubuntu0.1.22.04.2`

Licenses: (parsed from: `/usr/share/doc/tar/copyright`)

- `GPL-2`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris tar=1.34+dfsg-1ubuntu0.1.22.04.2
'http://archive.ubuntu.com/ubuntu/pool/main/t/tar/tar_1.34%2bdfsg-1ubuntu0.1.22.04.2.dsc' tar_1.34+dfsg-1ubuntu0.1.22.04.2.dsc 1829 SHA512:e716a22f84cf0ebc0250a4ebb5d7c1fb5f055470a376c20d37a9378e85535aba8d547b6fe64df17bdedd5130d47647613dd5f2083f93cae934961b1b5ba37077
'http://archive.ubuntu.com/ubuntu/pool/main/t/tar/tar_1.34%2bdfsg.orig.tar.xz' tar_1.34+dfsg.orig.tar.xz 1981736 SHA512:ec5553c53c4a5f523f872a8095f699c17bf41400fbe2f0f8b45291ccbaf9ac51dea8445c81bd95697f8853c95dcad3250071d23dbbcab857a428ee92e647bde9
'http://archive.ubuntu.com/ubuntu/pool/main/t/tar/tar_1.34%2bdfsg-1ubuntu0.1.22.04.2.debian.tar.xz' tar_1.34+dfsg-1ubuntu0.1.22.04.2.debian.tar.xz 20544 SHA512:9840407a1364154c831665c3f1739c80a84806567fe5ad27ee3ac70f4c18e27d7f2f9e0557b6e2a634ab39449a8fc95b96f1813f5c203df8ece5226a6afe8c7c
```

### `dpkg` source package: `tiff=4.3.0-6ubuntu0.10`

Binary Packages:

- `libtiff5:amd64=4.3.0-6ubuntu0.10`

Licenses: (parsed from: `/usr/share/doc/libtiff5/copyright`)

- `Hylafax`

Source:

```console
$ apt-get source -qq --print-uris tiff=4.3.0-6ubuntu0.10
'http://archive.ubuntu.com/ubuntu/pool/main/t/tiff/tiff_4.3.0-6ubuntu0.10.dsc' tiff_4.3.0-6ubuntu0.10.dsc 2402 SHA512:57c9cd8b73231e2f8d6f4377242e5bfb5d2401275db8216623a4dab98078d753525bb50131b34179ce30b0e29ad81a1ed21d17dc536f9926d005aa04a2fdcf77
'http://archive.ubuntu.com/ubuntu/pool/main/t/tiff/tiff_4.3.0.orig.tar.gz' tiff_4.3.0.orig.tar.gz 2808254 SHA512:e04a4a6c542e58a174c1e9516af3908acf1d3d3e1096648c5514f4963f73e7af27387a76b0fbabe43cf867a18874088f963796a7cd6e45deb998692e3e235493
'http://archive.ubuntu.com/ubuntu/pool/main/t/tiff/tiff_4.3.0.orig.tar.gz.asc' tiff_4.3.0.orig.tar.gz.asc 488 SHA512:115a4c5714b52d0fbea800c494d83c8a96b70b2c9ce84a8df03205d9afc517faa17963f5f9508c013d7d3e2be6675b84b594a771a829406473234c4bd85e469e
'http://archive.ubuntu.com/ubuntu/pool/main/t/tiff/tiff_4.3.0-6ubuntu0.10.debian.tar.xz' tiff_4.3.0-6ubuntu0.10.debian.tar.xz 50900 SHA512:77306a746064a74f326c232bbb7017cae9374b7596effae40234d1fef52fd6383a705b8ef0e76ca9c09795e54fc8a4a85ac1171324b535c3c4e28fee30153264
```

### `dpkg` source package: `tzdata=2024a-0ubuntu0.22.04.1`

Binary Packages:

- `tzdata=2024a-0ubuntu0.22.04.1`

Licenses: (parsed from: `/usr/share/doc/tzdata/copyright`)

- `ICU`

Source:

```console
$ apt-get source -qq --print-uris tzdata=2024a-0ubuntu0.22.04.1
'http://archive.ubuntu.com/ubuntu/pool/main/t/tzdata/tzdata_2024a-0ubuntu0.22.04.1.dsc' tzdata_2024a-0ubuntu0.22.04.1.dsc 2541 SHA512:c0cda33e23d340414e2cd079ec35caa8986601f9f97bcb055ccfaee154fb8667588a18d6e21f1719090799aa034960548df63a046669287e15af281aaba2b151
'http://archive.ubuntu.com/ubuntu/pool/main/t/tzdata/tzdata_2024a.orig.tar.gz' tzdata_2024a.orig.tar.gz 451270 SHA512:1f09f1b2327cc9e1afc7e9045e83ee3377918dafe1bee2f282b6991828d03b3c70a4d3a17f9207dfb1361bb25bc214a8922a756e84fa114e9ba476226db57236
'http://archive.ubuntu.com/ubuntu/pool/main/t/tzdata/tzdata_2024a.orig.tar.gz.asc' tzdata_2024a.orig.tar.gz.asc 833 SHA512:a06ddc95002f2dcd3c071d020a74bc98aae2cbf56a502718f9bc08e90e0075b17aaaa653ceecd49a1133cdadfc43134365043f827b19c7dad68050dbda6ba77e
'http://archive.ubuntu.com/ubuntu/pool/main/t/tzdata/tzdata_2024a-0ubuntu0.22.04.1.debian.tar.xz' tzdata_2024a-0ubuntu0.22.04.1.debian.tar.xz 178960 SHA512:98899e7a78ddfce0f3af0c1239422b9547b3c33ca08ab5e82266e51cc69e1169e012f3ad78b1fc84ca491847ea2bcda25619f7b06df410d0f02c9e7ef746a2ec
```

### `dpkg` source package: `ubuntu-keyring=2021.03.26`

Binary Packages:

- `ubuntu-keyring=2021.03.26`

Licenses: (parsed from: `/usr/share/doc/ubuntu-keyring/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris ubuntu-keyring=2021.03.26
'http://archive.ubuntu.com/ubuntu/pool/main/u/ubuntu-keyring/ubuntu-keyring_2021.03.26.dsc' ubuntu-keyring_2021.03.26.dsc 1855 SHA512:7502f4f4d9a288fab9fb84b6ae5f8500cb3f14c68ed586b489dee95f12087b232bcecd9369e98258bb710afda50e5672dfbc6422b1436e896fb529dec8832252
'http://archive.ubuntu.com/ubuntu/pool/main/u/ubuntu-keyring/ubuntu-keyring_2021.03.26.tar.gz' ubuntu-keyring_2021.03.26.tar.gz 34529 SHA512:04a76e2bfa88fb428face9e01976ff98a3a26fe2b555340c14200fc6099ee3b474a6733486cedfe933933c0a6826ee3550660499d7b26bda8a27a620b1d6a35f
```

### `dpkg` source package: `ucf=3.0043`

Binary Packages:

- `ucf=3.0043`

Licenses: (parsed from: `/usr/share/doc/ucf/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris ucf=3.0043
'http://archive.ubuntu.com/ubuntu/pool/main/u/ucf/ucf_3.0043.dsc' ucf_3.0043.dsc 1423 SHA512:666851d1df82352f8b2be8b8760250cfa1f7635718f0f1598a3d9e9f11a9d687ec4cfb7f6bf950b194d771db039508b6d62c288f53078e2712580bda7b5befa7
'http://archive.ubuntu.com/ubuntu/pool/main/u/ucf/ucf_3.0043.tar.xz' ucf_3.0043.tar.xz 70560 SHA512:693209ea06a63279278ac8f63e70fe151880f7c51d54c91ad5e846449f883d5893658d8c6932553d70da4e56ebae3ef67c0eda8593b0768f5979849c79f89f27
```

### `dpkg` source package: `underscore=1.13.2~dfsg-2`

Binary Packages:

- `libjs-underscore=1.13.2~dfsg-2`

Licenses: (parsed from: `/usr/share/doc/libjs-underscore/copyright`)

- `BSD-3-clause`
- `Expat`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris underscore=1.13.2~dfsg-2
'http://archive.ubuntu.com/ubuntu/pool/main/u/underscore/underscore_1.13.2%7edfsg-2.dsc' underscore_1.13.2~dfsg-2.dsc 2200 SHA512:452ea2d91ddbdd394c44fd18b8cab3a82ef4816787fa9a89c9f3059591d8e7c623e3ef983e26fabadf5918705ea99ef4ee6ea1a6b6f8a456590a7cc38ec85764
'http://archive.ubuntu.com/ubuntu/pool/main/u/underscore/underscore_1.13.2%7edfsg.orig.tar.xz' underscore_1.13.2~dfsg.orig.tar.xz 215248 SHA512:f13d496724e2418f177dd44ec119b5124729168aaf92b8a284ff8481a3603540f90b0e33a02d481c65225cff2972a41e671f4feb2be33e92e741caaf84c57295
'http://archive.ubuntu.com/ubuntu/pool/main/u/underscore/underscore_1.13.2%7edfsg-2.debian.tar.xz' underscore_1.13.2~dfsg-2.debian.tar.xz 8988 SHA512:4840dbbd2c73cdc284b7afe2da85dd0b14b5cc64bf7b4eeef18706c7ca6fdddc2feb0912ca5872855df07fc3981ea0720af93bbd5f85723ee1c291304a2d7fab
```

### `dpkg` source package: `unidecode=1.3.3-1`

Binary Packages:

- `python3-unidecode=1.3.3-1`

Licenses: (parsed from: `/usr/share/doc/python3-unidecode/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris unidecode=1.3.3-1
'http://archive.ubuntu.com/ubuntu/pool/universe/u/unidecode/unidecode_1.3.3-1.dsc' unidecode_1.3.3-1.dsc 1467 SHA512:2afc166e59d049055cbc71c7d1ce55ae8c4aa30152a0c2be941082961f0629b2a49c28a07e6dc506158948b7b1c9e5c327aa17309fb8bcf9a3e5ee3df8b82471
'http://archive.ubuntu.com/ubuntu/pool/universe/u/unidecode/unidecode_1.3.3.orig.tar.gz' unidecode_1.3.3.orig.tar.gz 192050 SHA512:1c42f2530fa68c56ded097a92b580a3b1c223c957711778b81dd92c8543068a76a87379db7fbe4d2dcb6a9a6c2fc2aef28ed950e0c07d411ae2891c00a8ffea7
'http://archive.ubuntu.com/ubuntu/pool/universe/u/unidecode/unidecode_1.3.3-1.debian.tar.xz' unidecode_1.3.3-1.debian.tar.xz 3872 SHA512:edeb21f4d646e8293318ff986e126f51949e250b5203217568e71cf44c5d47b46044a84c16b4128feab41bd6ef698b640d6fa68fde4b441c06e0fc5fe23b37b2
```

### `dpkg` source package: `usrmerge=25ubuntu2`

Binary Packages:

- `usrmerge=25ubuntu2`

Licenses: (parsed from: `/usr/share/doc/usrmerge/copyright`)

- `GPL v2`
- `GPL-2`
- `later (please see /usr/share/common-licenses/GPL-2)`

Source:

```console
$ apt-get source -qq --print-uris usrmerge=25ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/u/usrmerge/usrmerge_25ubuntu2.dsc' usrmerge_25ubuntu2.dsc 1614 SHA512:2f0ea8dbed8277d1fef2f2c70c0075ce509579161fe2dc3a161919d3015c67caff01aa14ba3df7fa7d6b45ce63dbad48389c418781334d83e308ee16988fa9bc
'http://archive.ubuntu.com/ubuntu/pool/main/u/usrmerge/usrmerge_25ubuntu2.tar.xz' usrmerge_25ubuntu2.tar.xz 12812 SHA512:dac8ccc7e2b75c424990713869f80d62d22e1cd86cb35c1784c7e76a12096b8c3f3000cefb406456f6f5c459d14858e710d426ee11714d1a5e342e04186f8353
```

### `dpkg` source package: `util-linux=2.37.2-4ubuntu3.4`

Binary Packages:

- `bsdutils=1:2.37.2-4ubuntu3.4`
- `libblkid1:amd64=2.37.2-4ubuntu3.4`
- `libmount1:amd64=2.37.2-4ubuntu3.4`
- `libsmartcols1:amd64=2.37.2-4ubuntu3.4`
- `libuuid1:amd64=2.37.2-4ubuntu3.4`
- `mount=2.37.2-4ubuntu3.4`
- `util-linux=2.37.2-4ubuntu3.4`

Licenses: (parsed from: `/usr/share/doc/bsdutils/copyright`, `/usr/share/doc/libblkid1/copyright`, `/usr/share/doc/libmount1/copyright`, `/usr/share/doc/libsmartcols1/copyright`, `/usr/share/doc/libuuid1/copyright`, `/usr/share/doc/mount/copyright`, `/usr/share/doc/util-linux/copyright`)

- `BSD-2-clause`
- `BSD-3-clause`
- `BSD-4-clause`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `LGPL`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `LGPL-3`
- `LGPL-3+`
- `MIT`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris util-linux=2.37.2-4ubuntu3.4
'http://archive.ubuntu.com/ubuntu/pool/main/u/util-linux/util-linux_2.37.2-4ubuntu3.4.dsc' util-linux_2.37.2-4ubuntu3.4.dsc 4550 SHA512:b0d37cbcd57000cf45ad6c6769e51bc0cc81a4ad9f3906e09b7f814a3638db0013c7213847c9c90f519f21896fdb5592a8ea839a1277d4e7629a01f84a535957
'http://archive.ubuntu.com/ubuntu/pool/main/u/util-linux/util-linux_2.37.2.orig.tar.xz' util-linux_2.37.2.orig.tar.xz 5621624 SHA512:38f0fe820445e3bfa79550e6581c230f98c7661566ccc4daa51c7208a5f972c61b4e57dfc86bed074fdbc7c40bc79f856be8f6a05a8860c1c0cecc4208e8b81d
'http://archive.ubuntu.com/ubuntu/pool/main/u/util-linux/util-linux_2.37.2-4ubuntu3.4.debian.tar.xz' util-linux_2.37.2-4ubuntu3.4.debian.tar.xz 114096 SHA512:8e1a3832d116062881d7823baafcf574cc252490e7e25144efa34cfd65a35b590b454298507940399568716c0ccb9533b01f2c9665f92aa2082d91e5ca8e9c9c
```

### `dpkg` source package: `wheel=0.37.1-2ubuntu0.22.04.1`

Binary Packages:

- `python3-wheel=0.37.1-2ubuntu0.22.04.1`

Licenses: (parsed from: `/usr/share/doc/python3-wheel/copyright`)

- `Expat`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris wheel=0.37.1-2ubuntu0.22.04.1
'http://archive.ubuntu.com/ubuntu/pool/universe/w/wheel/wheel_0.37.1-2ubuntu0.22.04.1.dsc' wheel_0.37.1-2ubuntu0.22.04.1.dsc 2477 SHA512:8717c85b10e1f159f06e4df62eda78e5cb280be6872dc88cdf9aac546ede007f5eaa1c6a6554c8296be2cca75060883ad644410b2564267102b1bbe2827ab71d
'http://archive.ubuntu.com/ubuntu/pool/universe/w/wheel/wheel_0.37.1.orig.tar.xz' wheel_0.37.1.orig.tar.xz 55972 SHA512:21a9f655107415d14725d36261112172817c9867da4325f8c1c8d491a2aacfa2fbd27badd42e8836aeb81fe2a22ee2d8fe26ba9f6fb3829c7be86a771fdf9430
'http://archive.ubuntu.com/ubuntu/pool/universe/w/wheel/wheel_0.37.1-2ubuntu0.22.04.1.debian.tar.xz' wheel_0.37.1-2ubuntu0.22.04.1.debian.tar.xz 7468 SHA512:56900e07dc1d95ff1db5e6ef41fdd8401263e9bc09a2887b412266da2f4b48d42afa1dc22e76da4c81abc455c0b74d43d1720cc708dcd336b417490ff00569e3
```

### `dpkg` source package: `wkhtmltox=1:0.12.6.1-3.jammy`

Binary Packages:

- `wkhtmltox=1:0.12.6.1-3.jammy`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


**WARNING:** unable to find source (`apt-get source` failed or returned no results)!  
This is *usually* due to a new package version being released and the old version being removed.


### `dpkg` source package: `xfonts-75dpi=1:1.0.4+nmu1.1`

Binary Packages:

- `xfonts-75dpi=1:1.0.4+nmu1.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris xfonts-75dpi=1:1.0.4+nmu1.1
'http://archive.ubuntu.com/ubuntu/pool/universe/x/xfonts-75dpi/xfonts-75dpi_1.0.4%2bnmu1.1.dsc' xfonts-75dpi_1.0.4+nmu1.1.dsc 1712 SHA512:f5e0cb5e56386d12d4a20623a54ce5f05f653152a60142bce0ed7cc54e26b951a9c35bddf55f76f11bd5fdd5fee0623d089399dbe4236fe3039f92c8622182e7
'http://archive.ubuntu.com/ubuntu/pool/universe/x/xfonts-75dpi/xfonts-75dpi_1.0.4%2bnmu1.1.tar.gz' xfonts-75dpi_1.0.4+nmu1.1.tar.gz 2909174 SHA512:bb36b94b897941e31e4dacafcb4dae902fc018e8cf1a2a21854e2dcd1aab098d35d2f6a51a56e37a37fa2a7df56f20ae8f776c25709114921119259500caedea
```

### `dpkg` source package: `xfonts-base=1:1.0.5`

Binary Packages:

- `xfonts-base=1:1.0.5`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris xfonts-base=1:1.0.5
'http://archive.ubuntu.com/ubuntu/pool/main/x/xfonts-base/xfonts-base_1.0.5.dsc' xfonts-base_1.0.5.dsc 1667 SHA512:f8d39291b76014fdd61fb68ac2090097a0e3a8c0c32edb40e3032be718da22ac176ad264d4decc3d38502e97afeb497733c54c8e0b724a89a797f2508d6879ad
'http://archive.ubuntu.com/ubuntu/pool/main/x/xfonts-base/xfonts-base_1.0.5.tar.gz' xfonts-base_1.0.5.tar.gz 6540582 SHA512:e0f2fc5e2c39afce91ac009cceac38109a52f65df1b9fc7f2cd1eb11d165dd57d8027842e6be75928cff8fa4084c6c91dd6d956cae1ac9672d1101a70b4e94ea
```

### `dpkg` source package: `xfonts-encodings=1:1.0.5-0ubuntu2`

Binary Packages:

- `xfonts-encodings=1:1.0.5-0ubuntu2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris xfonts-encodings=1:1.0.5-0ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/x/xfonts-encodings/xfonts-encodings_1.0.5-0ubuntu2.dsc' xfonts-encodings_1.0.5-0ubuntu2.dsc 1464 SHA512:f4fad2eae6113ed446e02e3ad150a3a6ae12ceda3deca509099732991654d9b24cc5923ecd31db01620fc77699ed264e103827d37651bcdc527a38288e52b675
'http://archive.ubuntu.com/ubuntu/pool/main/x/xfonts-encodings/xfonts-encodings_1.0.5.orig.tar.gz' xfonts-encodings_1.0.5.orig.tar.gz 790741 SHA512:9e444ebeed0f667eb1a50d226c9953d1b3b55cb15415c4cb32ec33fd081cc62ae7df5e2925cff51d5dd14cdd82c212ba655e81ea5f83a6bf30b3031d38ccc602
'http://archive.ubuntu.com/ubuntu/pool/main/x/xfonts-encodings/xfonts-encodings_1.0.5-0ubuntu2.diff.gz' xfonts-encodings_1.0.5-0ubuntu2.diff.gz 14293 SHA512:e8ab10530deea9bca07c98cce0ae8b6bee759902b03ff3bd16f84e9c2b324e1782d1e0bccbfecc1d7302944d15f632748b77dec53e6e9bc803485e7a3508e197
```

### `dpkg` source package: `xfonts-utils=1:7.7+6build2`

Binary Packages:

- `xfonts-utils=1:7.7+6build2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris xfonts-utils=1:7.7+6build2
'http://archive.ubuntu.com/ubuntu/pool/main/x/xfonts-utils/xfonts-utils_7.7%2b6build2.dsc' xfonts-utils_7.7+6build2.dsc 1856 SHA512:28fb48af69f33401a5665c2a5891d49dca1cb1706a251f1b4dd0585bba4b366d280cd6412164318ae61b1b7cb9fbe1386e0ffee657aa7cf50baceb75f760a6ee
'http://archive.ubuntu.com/ubuntu/pool/main/x/xfonts-utils/xfonts-utils_7.7%2b6build2.tar.gz' xfonts-utils_7.7+6build2.tar.gz 846921 SHA512:fc382af3b2432edd786e022882cae5391bf770def2ed2e4723de8623f572807d7ad99c49911fe90ddd5a1bc792033df985c694b29d5b940ffc830df30cf5f704
```

### `dpkg` source package: `xlsxwriter=3.0.2-2`

Binary Packages:

- `python3-xlsxwriter=3.0.2-2`

Licenses: (parsed from: `/usr/share/doc/python3-xlsxwriter/copyright`)

- `BSD-2-clause`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris xlsxwriter=3.0.2-2
'http://archive.ubuntu.com/ubuntu/pool/universe/x/xlsxwriter/xlsxwriter_3.0.2-2.dsc' xlsxwriter_3.0.2-2.dsc 2042 SHA512:832c43f49cd71b60d744ef4ae42e4c2122426d8589f48907745953c8024936be1dc919833df401047f8f0c82c495c55d6f55c8ba55c76c461ba92b9d81bd5260
'http://archive.ubuntu.com/ubuntu/pool/universe/x/xlsxwriter/xlsxwriter_3.0.2.orig.tar.gz' xlsxwriter_3.0.2.orig.tar.gz 34433041 SHA512:790eb7fb93d25987adf5d30bfa28e0fa137f809dc9a293edfe86105e0a948263759df85b5a0f9fb19b89c256a33b5b68179d95a210964b6f82345972ee9e6108
'http://archive.ubuntu.com/ubuntu/pool/universe/x/xlsxwriter/xlsxwriter_3.0.2-2.debian.tar.xz' xlsxwriter_3.0.2-2.debian.tar.xz 4252 SHA512:7e11ddf36432fd701b07a9a9eba8feb7bff3544fe8dda735fe16b647e365183859349b94bf3bf74f4a87ba35e5f9598d52ba93e21d561064da6f4a6acb36928a
```

### `dpkg` source package: `xlwt=1.3.0-3`

Binary Packages:

- `python3-xlwt=1.3.0-3`

Licenses: (parsed from: `/usr/share/doc/python3-xlwt/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris xlwt=1.3.0-3
'http://archive.ubuntu.com/ubuntu/pool/universe/x/xlwt/xlwt_1.3.0-3.dsc' xlwt_1.3.0-3.dsc 2124 SHA512:c91a5e392b03e0d5e2c84aa55d3a7bdea56ee0ec188b791ea4554fa75970a9d7bbf782f175315c66d6f25728da888b940797110a8bd6350c84fde766a8a327a8
'http://archive.ubuntu.com/ubuntu/pool/universe/x/xlwt/xlwt_1.3.0.orig.tar.gz' xlwt_1.3.0.orig.tar.gz 153929 SHA512:e09c515bda7edadb9624b842796a537316c1e2e06f3e74aca5440a5797dbc259036539fd64ea61648a30894f4091d3be829411d36e6170894980728c798c5963
'http://archive.ubuntu.com/ubuntu/pool/universe/x/xlwt/xlwt_1.3.0-3.debian.tar.xz' xlwt_1.3.0-3.debian.tar.xz 6744 SHA512:12de14a1bec59ebb062247be2a0922bfb0369947e6c2b5164c6cdc5fc1f696afbe869ab5156b9e087176d9e2cbce6594aa42a45da579e246c2a7d342e3874a7e
```

### `dpkg` source package: `xml-core=0.18+nmu1`

Binary Packages:

- `xml-core=0.18+nmu1`

Licenses: (parsed from: `/usr/share/doc/xml-core/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris xml-core=0.18+nmu1
'http://archive.ubuntu.com/ubuntu/pool/main/x/xml-core/xml-core_0.18%2bnmu1.dsc' xml-core_0.18+nmu1.dsc 1632 SHA512:1c3a335850618902a71478ee26136848e7de12f1ec090cca0598d1a2e4810f3fa5b97d65fd058752e904c1073a36785bef3b088ce34623de290e3c80c971b69b
'http://archive.ubuntu.com/ubuntu/pool/main/x/xml-core/xml-core_0.18%2bnmu1.tar.xz' xml-core_0.18+nmu1.tar.xz 21312 SHA512:568a3e73acb64db8074e88813a6f64c9839a92e9afba6bbb90e5852e2cc6565636e380ba87fec6d29aa6b4eaa896131ef2d404ed3811443a4df1c6bdb3d1545b
```

### `dpkg` source package: `xorg=1:7.7+23ubuntu2`

Binary Packages:

- `x11-common=1:7.7+23ubuntu2`

Licenses: (parsed from: `/usr/share/doc/x11-common/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris xorg=1:7.7+23ubuntu2
'http://archive.ubuntu.com/ubuntu/pool/main/x/xorg/xorg_7.7%2b23ubuntu2.dsc' xorg_7.7+23ubuntu2.dsc 2095 SHA512:f4befc0dd73c66f56856f16c4dc4051f58af50bd8819469df4bb309817952e00f2f4e29776282f85eeaef18a77fdd42cb1cfcb9a69432c4680b216039b37e480
'http://archive.ubuntu.com/ubuntu/pool/main/x/xorg/xorg_7.7%2b23ubuntu2.tar.gz' xorg_7.7+23ubuntu2.tar.gz 301762 SHA512:379e60ab57cc4f9adbf1f59295fca3930bbd638f4100d08c9f1f78bd6ef063e3396385b841e66389771c4ba5825875d738b9aa4b4dc2e3f79d0537415ac0852a
```

### `dpkg` source package: `xxhash=0.8.1-1`

Binary Packages:

- `libxxhash0:amd64=0.8.1-1`

Licenses: (parsed from: `/usr/share/doc/libxxhash0/copyright`)

- `BSD-2-clause`
- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris xxhash=0.8.1-1
'http://archive.ubuntu.com/ubuntu/pool/main/x/xxhash/xxhash_0.8.1-1.dsc' xxhash_0.8.1-1.dsc 1966 SHA512:645799311fdf21568b23134cdf586a54bb32b58639adb8ebc1f5ad26fdfdc485506c87d763133163fde705b2f904d6f01f50e4d13ebec2b476d38e66ded2bf22
'http://archive.ubuntu.com/ubuntu/pool/main/x/xxhash/xxhash_0.8.1.orig.tar.gz' xxhash_0.8.1.orig.tar.gz 171552 SHA512:12feedd6a1859ef55e27218dbd6dcceccbb5a4da34cd80240d2f7d44cd246c7afdeb59830c2d5b90189bb5159293532208bf5bb622250102e12d6e1bad14a193
'http://archive.ubuntu.com/ubuntu/pool/main/x/xxhash/xxhash_0.8.1-1.debian.tar.xz' xxhash_0.8.1-1.debian.tar.xz 4572 SHA512:e59d4fc6f736d3af6f7be3ec64fc1ee4382e917a942e4000159652082e2f73f52ae0f72adb98505ac9bd8894a89800e21c0913ba4b511959f07a2bc84c341920
```

### `dpkg` source package: `xz-utils=5.2.5-2ubuntu1`

Binary Packages:

- `liblzma5:amd64=5.2.5-2ubuntu1`
- `xz-utils=5.2.5-2ubuntu1`

Licenses: (parsed from: `/usr/share/doc/liblzma5/copyright`, `/usr/share/doc/xz-utils/copyright`)

- `Autoconf`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `LGPL-2`
- `LGPL-2.1`
- `LGPL-2.1+`
- `PD`
- `PD-debian`
- `config-h`
- `noderivs`
- `none`
- `permissive-fsf`
- `permissive-nowarranty`
- `probably-PD`

Source:

```console
$ apt-get source -qq --print-uris xz-utils=5.2.5-2ubuntu1
'http://archive.ubuntu.com/ubuntu/pool/main/x/xz-utils/xz-utils_5.2.5-2ubuntu1.dsc' xz-utils_5.2.5-2ubuntu1.dsc 2593 SHA512:832f11d78286b4838d53b789e70b00462d255ca31c9ba059c0a018e13e546b4407889b8d1efd079bcdd8eb1e9247a970bb6811ec50a19a5af83cec3880b6c5f3
'http://archive.ubuntu.com/ubuntu/pool/main/x/xz-utils/xz-utils_5.2.5.orig.tar.xz' xz-utils_5.2.5.orig.tar.xz 1148824 SHA512:59266068a51cb616eb31b67cd8f07ffeb2288d1391c61665ae2ec6814465afac80fec69248f6a2f2db45b44475af001296a99af6a32287226a9c41419173ccbb
'http://archive.ubuntu.com/ubuntu/pool/main/x/xz-utils/xz-utils_5.2.5.orig.tar.xz.asc' xz-utils_5.2.5.orig.tar.xz.asc 833 SHA512:582864ae306861ede34074ebfd23ab161ad3340ab4a068f727583de2bd2058da70dfe73019f4e70b8267e0e0c62f275da1e23f47d40c0b80038449b0ac335020
'http://archive.ubuntu.com/ubuntu/pool/main/x/xz-utils/xz-utils_5.2.5-2ubuntu1.debian.tar.xz' xz-utils_5.2.5-2ubuntu1.debian.tar.xz 35108 SHA512:c50c36fe82204f79be5f409c633aae52ae7b5d36fc64f404308372c80c862455c26455ad0dba93877e80db576d80e672314f757a1ed080f200702d47247e9d6e
```

### `dpkg` source package: `zlib=1:1.2.11.dfsg-2ubuntu9.2`

Binary Packages:

- `zlib1g:amd64=1:1.2.11.dfsg-2ubuntu9.2`

Licenses: (parsed from: `/usr/share/doc/zlib1g/copyright`)

- `Zlib`

Source:

```console
$ apt-get source -qq --print-uris zlib=1:1.2.11.dfsg-2ubuntu9.2
'http://archive.ubuntu.com/ubuntu/pool/main/z/zlib/zlib_1.2.11.dfsg-2ubuntu9.2.dsc' zlib_1.2.11.dfsg-2ubuntu9.2.dsc 2649 SHA512:08f3ca4c6680ddec9532de5e937c39aa891e1c2062e6da65a96aaa060c8111bbb63de6d5c36efd34f4d3892e6e334b50fa2947fde68b3ba276e6645027dd8715
'http://archive.ubuntu.com/ubuntu/pool/main/z/zlib/zlib_1.2.11.dfsg.orig.tar.gz' zlib_1.2.11.dfsg.orig.tar.gz 370248 SHA512:92819807c0b8de655021bb2d5d182f9b6b381d3072d8c8dc1df34bbaa25d36bcba140c85f754a43cc466aac65850b7a7366aa0c93e804180e5b255e61d5748de
'http://archive.ubuntu.com/ubuntu/pool/main/z/zlib/zlib_1.2.11.dfsg-2ubuntu9.2.debian.tar.xz' zlib_1.2.11.dfsg-2ubuntu9.2.debian.tar.xz 60140 SHA512:5e86b01c08d5027fab6682849e6065b750d2aecafe8bd6ca85fd729c1cca88031e46f869e20d0b0483d2a6128eab9754f530d0b25f009b684b18bd6f0e8c4ae8
```

### `dpkg` source package: `zope.event=4.4-3`

Binary Packages:

- `python3-zope.event=4.4-3`

Licenses: (parsed from: `/usr/share/doc/python3-zope.event/copyright`)

- `Zope-2.1`

Source:

```console
$ apt-get source -qq --print-uris zope.event=4.4-3
'http://archive.ubuntu.com/ubuntu/pool/universe/z/zope.event/zope.event_4.4-3.dsc' zope.event_4.4-3.dsc 1937 SHA512:ae8edb70a2ffb410660b23520e3db149fb74641d584d16b5c5061de6201a468aceb83222f9fe4b498ecc58957f68cca882252f575f42b120a8b199c472d2eaf6
'http://archive.ubuntu.com/ubuntu/pool/universe/z/zope.event/zope.event_4.4.orig.tar.gz' zope.event_4.4.orig.tar.gz 18818 SHA512:34dac7ce2e8faf464bdb3861217beb1dd0976b1cc047d45a79f1640dd256bf33162da6e105c00135217fcdb888fc3ac7a4b0b4b047f64ce310c4d11cff71a985
'http://archive.ubuntu.com/ubuntu/pool/universe/z/zope.event/zope.event_4.4-3.debian.tar.xz' zope.event_4.4-3.debian.tar.xz 4264 SHA512:8547486e33acf14bb8fde36cbf10f0f3bbb8b0ed738b8488bddf550cd2bc61a58b49c998dd9165c0602b90ac9013de37e922ab4a8534aa8b4ad38d723f63a513
```

### `dpkg` source package: `zope.interface=5.4.0-1build1`

Binary Packages:

- `python3-zope.interface=5.4.0-1build1`

Licenses: (parsed from: `/usr/share/doc/python3-zope.interface/copyright`)

- `BSD-2-Clause`
- `Zope-2.1`

Source:

```console
$ apt-get source -qq --print-uris zope.interface=5.4.0-1build1
'http://archive.ubuntu.com/ubuntu/pool/main/z/zope.interface/zope.interface_5.4.0-1build1.dsc' zope.interface_5.4.0-1build1.dsc 2376 SHA512:7c4b8e7a3f76844137aff0c00476748cf6e175c0636e0c658fa424f588666dd8b8f5df8fbaf6ee7a1904f69048c5db431fa5608ac0001d0bbcfb8a97537a3407
'http://archive.ubuntu.com/ubuntu/pool/main/z/zope.interface/zope.interface_5.4.0.orig.tar.gz' zope.interface_5.4.0.orig.tar.gz 227259 SHA512:d0109f127e2122f6818ad09b5a287a2ec4c2afda7ea7421d7d41eeea9e6248e4f08d31193b217d91c1634ca007be61750149a9f95ce7420e0f62184950bb0599
'http://archive.ubuntu.com/ubuntu/pool/main/z/zope.interface/zope.interface_5.4.0-1build1.debian.tar.xz' zope.interface_5.4.0-1build1.debian.tar.xz 6920 SHA512:2c51970ca82939b20770eef098101fa4792dcbf00a2da101509d619883bb494502f5f3cf340b0503b03e2af867be5ae99d8555401487f1bcab6757c3a37034c0
```
