# `odoo:16.0-20241029`

## Docker Metadata

- Image ID: `sha256:9c6820bcff8b8c5ac578478be0eb60d79ed1327dd1ba0bc9db33122e164083ab`
- Created: `2024-10-29T13:56:14Z`
- Virtual Size: ~ 1.75 Gb  
  (total size of all layers on-disk)
- Arch: `linux`/`amd64`
- Entrypoint: `["/entrypoint.sh"]`
- Command: `["odoo"]`
- Environment:
  - `PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin`
  - `LANG=C.UTF-8`
  - `ODOO_VERSION=16.0`
  - `ODOO_RC=/etc/odoo/odoo.conf`

## `dpkg` (`.deb`-based packages)

### `dpkg` source package: `acl=2.2.53-10`

Binary Packages:

- `libacl1:amd64=2.2.53-10`

Licenses: (parsed from: `/usr/share/doc/libacl1/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2+`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris acl=2.2.53-10
'http://deb.debian.org/debian/pool/main/a/acl/acl_2.2.53-10.dsc' acl_2.2.53-10.dsc 2468 SHA256:09204a89156b17a3603b2ce34b3c7b1a9fd7345086c787962188d95347918c59
'http://deb.debian.org/debian/pool/main/a/acl/acl_2.2.53.orig.tar.gz' acl_2.2.53.orig.tar.gz 524300 SHA256:06be9865c6f418d851ff4494e12406568353b891ffe1f596b34693c387af26c7
'http://deb.debian.org/debian/pool/main/a/acl/acl_2.2.53.orig.tar.gz.asc' acl_2.2.53.orig.tar.gz.asc 833 SHA256:06849bece0b56a6a7269173abe101cff223bb9346d74027a3cd5ff80914abf4b
'http://deb.debian.org/debian/pool/main/a/acl/acl_2.2.53-10.debian.tar.xz' acl_2.2.53-10.debian.tar.xz 25536 SHA256:6b83a626aa383334b64666181642c7c13e44a6fe65486d0aaa34bd8de6d58b20
```

Other potentially useful URLs:

- https://sources.debian.net/src/acl/2.2.53-10/ (for browsing the source)
- https://sources.debian.net/src/acl/2.2.53-10/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/acl/2.2.53-10/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `adduser=3.118+deb11u1`

Binary Packages:

- `adduser=3.118+deb11u1`

Licenses: (parsed from: `/usr/share/doc/adduser/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris adduser=3.118+deb11u1
'http://deb.debian.org/debian/pool/main/a/adduser/adduser_3.118%2bdeb11u1.dsc' adduser_3.118+deb11u1.dsc 1677 SHA256:8e114d444fe24474b51a40931c3778d9cc0e35cbbed802088e390695d8020a0a
'http://deb.debian.org/debian/pool/main/a/adduser/adduser_3.118%2bdeb11u1.tar.xz' adduser_3.118+deb11u1.tar.xz 212260 SHA256:ef0c058ae23857665cea7d527fdf9f270f5cb47b15391f108082dd709d09fa93
```

Other potentially useful URLs:

- https://sources.debian.net/src/adduser/3.118+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/adduser/3.118+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/adduser/3.118+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `ann=1.1.2+doc-7`

Binary Packages:

- `libann0=1.1.2+doc-7`

Licenses: (parsed from: `/usr/share/doc/libann0/copyright`)

- `GPL-3`
- `GPL-3.0+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris ann=1.1.2+doc-7
'http://deb.debian.org/debian/pool/main/a/ann/ann_1.1.2%2bdoc-7.dsc' ann_1.1.2+doc-7.dsc 2115 SHA256:57aa9dc58345ec05897a7eb53cf6b4249261ef09465e8eb0458070c829e22027
'http://deb.debian.org/debian/pool/main/a/ann/ann_1.1.2%2bdoc.orig.tar.gz' ann_1.1.2+doc.orig.tar.gz 693957 SHA256:1a8053e4f1ee284430758a2d864e567d9b4b08c0f6562460c9913497fafc78c1
'http://deb.debian.org/debian/pool/main/a/ann/ann_1.1.2%2bdoc-7.debian.tar.xz' ann_1.1.2+doc-7.debian.tar.xz 172056 SHA256:a556b60a34bcae258268d9de6e5b19d0b273515dd928d40bcdbe7f4bfdc38652
```

Other potentially useful URLs:

- https://sources.debian.net/src/ann/1.1.2+doc-7/ (for browsing the source)
- https://sources.debian.net/src/ann/1.1.2+doc-7/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/ann/1.1.2+doc-7/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `appdirs=1.4.4-1`

Binary Packages:

- `python3-appdirs=1.4.4-1`

Licenses: (parsed from: `/usr/share/doc/python3-appdirs/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris appdirs=1.4.4-1
'http://deb.debian.org/debian/pool/main/a/appdirs/appdirs_1.4.4-1.dsc' appdirs_1.4.4-1.dsc 2213 SHA256:816a38b989f30c61fe7d6002e415d018f3566a8e9e17f80d06630b38687616bb
'http://deb.debian.org/debian/pool/main/a/appdirs/appdirs_1.4.4.orig.tar.gz' appdirs_1.4.4.orig.tar.gz 13470 SHA256:7d5d0167b2b1ba821647616af46a749d1c653740dd0d2415100fe26e27afdf41
'http://deb.debian.org/debian/pool/main/a/appdirs/appdirs_1.4.4-1.debian.tar.xz' appdirs_1.4.4-1.debian.tar.xz 3224 SHA256:cc1489fcb682a83bb87999f65bc0407ca52ebebf21767fc9f2ab587de25645af
```

Other potentially useful URLs:

- https://sources.debian.net/src/appdirs/1.4.4-1/ (for browsing the source)
- https://sources.debian.net/src/appdirs/1.4.4-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/appdirs/1.4.4-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `apt=2.2.4`

Binary Packages:

- `apt=2.2.4`
- `libapt-pkg6.0:amd64=2.2.4`

Licenses: (parsed from: `/usr/share/doc/apt/copyright`, `/usr/share/doc/libapt-pkg6.0/copyright`)

- `GPL-2`
- `GPLv2+`

Source:

```console
$ apt-get source -qq --print-uris apt=2.2.4
'http://deb.debian.org/debian/pool/main/a/apt/apt_2.2.4.dsc' apt_2.2.4.dsc 2780 SHA256:750079533300bc3a4f3e10a9c8dbffaa0781b92e3616a12d7e18ab1378ca4466
'http://deb.debian.org/debian/pool/main/a/apt/apt_2.2.4.tar.xz' apt_2.2.4.tar.xz 2197424 SHA256:6eecd04a4979bd2040b22a14571c15d342c4e1802b2023acb5aa19649b1f64ea
```

Other potentially useful URLs:

- https://sources.debian.net/src/apt/2.2.4/ (for browsing the source)
- https://sources.debian.net/src/apt/2.2.4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/apt/2.2.4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `attr=1:2.4.48-6`

Binary Packages:

- `libattr1:amd64=1:2.4.48-6`

Licenses: (parsed from: `/usr/share/doc/libattr1/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2+`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris attr=1:2.4.48-6
'http://deb.debian.org/debian/pool/main/a/attr/attr_2.4.48-6.dsc' attr_2.4.48-6.dsc 2433 SHA256:d55d1ba40517146e9a43f9ed1c5dbd82cfe079cd1fdb852323717a953515cfa4
'http://deb.debian.org/debian/pool/main/a/attr/attr_2.4.48.orig.tar.gz' attr_2.4.48.orig.tar.gz 467840 SHA256:5ead72b358ec709ed00bbf7a9eaef1654baad937c001c044fe8b74c57f5324e7
'http://deb.debian.org/debian/pool/main/a/attr/attr_2.4.48.orig.tar.gz.asc' attr_2.4.48.orig.tar.gz.asc 833 SHA256:5d23c2c83cc13d170f1c209f48d0efa1fc46d16487b790e9996c5206dcfe0395
'http://deb.debian.org/debian/pool/main/a/attr/attr_2.4.48-6.debian.tar.xz' attr_2.4.48-6.debian.tar.xz 27260 SHA256:77f7e03cc8dd039abc3e4a7353f816a3b07fbd0b22d7784f635c5edf7d20b6df
```

Other potentially useful URLs:

- https://sources.debian.net/src/attr/1:2.4.48-6/ (for browsing the source)
- https://sources.debian.net/src/attr/1:2.4.48-6/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/attr/1:2.4.48-6/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `audit=1:3.0-2`

Binary Packages:

- `libaudit-common=1:3.0-2`
- `libaudit1:amd64=1:3.0-2`

Licenses: (parsed from: `/usr/share/doc/libaudit-common/copyright`, `/usr/share/doc/libaudit1/copyright`)

- `GPL-1`
- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris audit=1:3.0-2
'http://deb.debian.org/debian/pool/main/a/audit/audit_3.0-2.dsc' audit_3.0-2.dsc 2397 SHA256:3cb83cc7649bb854c76f9cb6744b34091e667e433a91a57323938fdf3f353227
'http://deb.debian.org/debian/pool/main/a/audit/audit_3.0.orig.tar.gz' audit_3.0.orig.tar.gz 1109442 SHA256:bd31826823b912b6fe271d2d979ed879e9fc393cab1e2f7c4e1af258231765b8
'http://deb.debian.org/debian/pool/main/a/audit/audit_3.0-2.debian.tar.xz' audit_3.0-2.debian.tar.xz 18640 SHA256:10193fa9823eb66dfb1220fb109b8b8e01f3f720c5a1630e9015d92aa7a8ce3a
```

Other potentially useful URLs:

- https://sources.debian.net/src/audit/1:3.0-2/ (for browsing the source)
- https://sources.debian.net/src/audit/1:3.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/audit/1:3.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `base-files=11.1+deb11u11`

Binary Packages:

- `base-files=11.1+deb11u11`

Licenses: (parsed from: `/usr/share/doc/base-files/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris base-files=11.1+deb11u11
'http://deb.debian.org/debian/pool/main/b/base-files/base-files_11.1%2bdeb11u11.dsc' base-files_11.1+deb11u11.dsc 1114 SHA256:81e0a8ba62b8ab557ac9ce0ecf85478bf34e60809b68d47cace2a1d8d6fdf158
'http://deb.debian.org/debian/pool/main/b/base-files/base-files_11.1%2bdeb11u11.tar.xz' base-files_11.1+deb11u11.tar.xz 65684 SHA256:87f49fc1bac03d063d19c580e9a6ec2eb4405c6ab18c06871159e2afdf2f3546
```

Other potentially useful URLs:

- https://sources.debian.net/src/base-files/11.1+deb11u11/ (for browsing the source)
- https://sources.debian.net/src/base-files/11.1+deb11u11/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/base-files/11.1+deb11u11/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `base-passwd=3.5.51`

Binary Packages:

- `base-passwd=3.5.51`

Licenses: (parsed from: `/usr/share/doc/base-passwd/copyright`)

- `GPL-2`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris base-passwd=3.5.51
'http://deb.debian.org/debian/pool/main/b/base-passwd/base-passwd_3.5.51.dsc' base-passwd_3.5.51.dsc 1757 SHA256:5752e4c2e3b9b4d45502f6aa5ce8dfd0136ea60f1b4fbd4524385e4bbd6a1571
'http://deb.debian.org/debian/pool/main/b/base-passwd/base-passwd_3.5.51.tar.xz' base-passwd_3.5.51.tar.xz 53980 SHA256:66c75ce1877759148dbdd2704b138c4a02adab89d7d7591b6ab184f8f614efba
```

Other potentially useful URLs:

- https://sources.debian.net/src/base-passwd/3.5.51/ (for browsing the source)
- https://sources.debian.net/src/base-passwd/3.5.51/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/base-passwd/3.5.51/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `bash=5.1-2+deb11u1`

Binary Packages:

- `bash=5.1-2+deb11u1`

Licenses: (parsed from: `/usr/share/doc/bash/copyright`)

- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris bash=5.1-2+deb11u1
'http://deb.debian.org/debian/pool/main/b/bash/bash_5.1-2%2bdeb11u1.dsc' bash_5.1-2+deb11u1.dsc 2458 SHA256:a475836201a8b2937dd83180c86ede2be07ea57ff41d02dfd639c3e08fa94045
'http://deb.debian.org/debian/pool/main/b/bash/bash_5.1.orig.tar.xz' bash_5.1.orig.tar.xz 5802740 SHA256:d5eeee4f953c09826409d572e2e8996a2140d67eb8f382ce1f3a9d23883ad696
'http://deb.debian.org/debian/pool/main/b/bash/bash_5.1-2%2bdeb11u1.debian.tar.xz' bash_5.1-2+deb11u1.debian.tar.xz 90828 SHA256:2560b99eb87dd0aa3a15b88c31cc801630cbda93d566a936b643da8dff30627b
```

Other potentially useful URLs:

- https://sources.debian.net/src/bash/5.1-2+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/bash/5.1-2+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/bash/5.1-2+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `beautifulsoup4=4.9.3-1`

Binary Packages:

- `python3-bs4=4.9.3-1`

Licenses: (parsed from: `/usr/share/doc/python3-bs4/copyright`)

- `Expat`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris beautifulsoup4=4.9.3-1
'http://deb.debian.org/debian/pool/main/b/beautifulsoup4/beautifulsoup4_4.9.3-1.dsc' beautifulsoup4_4.9.3-1.dsc 1714 SHA256:ba7fc8c4276ae45240e3be7963b6a90d0dc194e3859a3b3f4d5af28bd3f687c4
'http://deb.debian.org/debian/pool/main/b/beautifulsoup4/beautifulsoup4_4.9.3.orig.tar.gz' beautifulsoup4_4.9.3.orig.tar.gz 376031 SHA256:84729e322ad1d5b4d25f805bfa05b902dd96450f43842c4e99067d5e1369eb25
'http://deb.debian.org/debian/pool/main/b/beautifulsoup4/beautifulsoup4_4.9.3-1.debian.tar.xz' beautifulsoup4_4.9.3-1.debian.tar.xz 6464 SHA256:76a0ee6c2475f72e617c19148da17b75263e6ea15347a441542896e33cc78674
```

Other potentially useful URLs:

- https://sources.debian.net/src/beautifulsoup4/4.9.3-1/ (for browsing the source)
- https://sources.debian.net/src/beautifulsoup4/4.9.3-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/beautifulsoup4/4.9.3-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `brotli=1.0.9-2`

Binary Packages:

- `libbrotli1:amd64=1.0.9-2+b2`

Licenses: (parsed from: `/usr/share/doc/libbrotli1/copyright`)

- `MIT`

Source:

```console
$ apt-get source -qq --print-uris brotli=1.0.9-2
'http://deb.debian.org/debian/pool/main/b/brotli/brotli_1.0.9-2.dsc' brotli_1.0.9-2.dsc 2261 SHA256:8c4c86748ec9770e08b60233d658593650444b04a452dc5b607ed5b5537b683e
'http://deb.debian.org/debian/pool/main/b/brotli/brotli_1.0.9.orig.tar.gz' brotli_1.0.9.orig.tar.gz 486984 SHA256:f9e8d81d0405ba66d181529af42a3354f838c939095ff99930da6aa9cdf6fe46
'http://deb.debian.org/debian/pool/main/b/brotli/brotli_1.0.9-2.debian.tar.xz' brotli_1.0.9-2.debian.tar.xz 5552 SHA256:ab81b1db852c8d01e0fa5b0b650bb486f32a232b35336828423af50af6fecca0
```

Other potentially useful URLs:

- https://sources.debian.net/src/brotli/1.0.9-2/ (for browsing the source)
- https://sources.debian.net/src/brotli/1.0.9-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/brotli/1.0.9-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `bzip2=1.0.8-4`

Binary Packages:

- `libbz2-1.0:amd64=1.0.8-4`

Licenses: (parsed from: `/usr/share/doc/libbz2-1.0/copyright`)

- `BSD-variant`
- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris bzip2=1.0.8-4
'http://deb.debian.org/debian/pool/main/b/bzip2/bzip2_1.0.8-4.dsc' bzip2_1.0.8-4.dsc 1603 SHA256:662c5e656a87db884fdc070239f5112cba1e616f20ff260de602876f70415c7b
'http://deb.debian.org/debian/pool/main/b/bzip2/bzip2_1.0.8.orig.tar.gz' bzip2_1.0.8.orig.tar.gz 810029 SHA256:ab5a03176ee106d3f0fa90e381da478ddae405918153cca248e682cd0c4a2269
'http://deb.debian.org/debian/pool/main/b/bzip2/bzip2_1.0.8-4.debian.tar.bz2' bzip2_1.0.8-4.debian.tar.bz2 26515 SHA256:3f3b26d83120260c7b2e69a5c89649bb818a79955b960fb34a5fae106f008a5d
```

Other potentially useful URLs:

- https://sources.debian.net/src/bzip2/1.0.8-4/ (for browsing the source)
- https://sources.debian.net/src/bzip2/1.0.8-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/bzip2/1.0.8-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `c-ares=1.17.1-1+deb11u3`

Binary Packages:

- `libc-ares2:amd64=1.17.1-1+deb11u3`

Licenses: (parsed from: `/usr/share/doc/libc-ares2/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris c-ares=1.17.1-1+deb11u3
'http://deb.debian.org/debian/pool/main/c/c-ares/c-ares_1.17.1-1%2bdeb11u3.dsc' c-ares_1.17.1-1+deb11u3.dsc 1804 SHA256:34bf095afbff0bfa36279a4ac7dafb6cc39e2a50f066334d49366e7ad69d56a3
'http://deb.debian.org/debian/pool/main/c/c-ares/c-ares_1.17.1.orig.tar.gz' c-ares_1.17.1.orig.tar.gz 1518701 SHA256:d73dd0f6de824afd407ce10750ea081af47eba52b8a6cb307d220131ad93fc40
'http://deb.debian.org/debian/pool/main/c/c-ares/c-ares_1.17.1.orig.tar.gz.asc' c-ares_1.17.1.orig.tar.gz.asc 488 SHA256:2dac298ea5c1add08bfcacc65bf879016c7f9e2ab54ca4f92f83c2b5681b4c60
'http://deb.debian.org/debian/pool/main/c/c-ares/c-ares_1.17.1-1%2bdeb11u3.debian.tar.xz' c-ares_1.17.1-1+deb11u3.debian.tar.xz 13912 SHA256:23b0e3ce14ed28918367f2dea872faf3629a440e904b6dd735d8c64490d6bd6c
```

Other potentially useful URLs:

- https://sources.debian.net/src/c-ares/1.17.1-1+deb11u3/ (for browsing the source)
- https://sources.debian.net/src/c-ares/1.17.1-1+deb11u3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/c-ares/1.17.1-1+deb11u3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `ca-certificates=20210119`

Binary Packages:

- `ca-certificates=20210119`

Licenses: (parsed from: `/usr/share/doc/ca-certificates/copyright`)

- `GPL-2`
- `GPL-2+`
- `MPL-2.0`

Source:

```console
$ apt-get source -qq --print-uris ca-certificates=20210119
'http://deb.debian.org/debian/pool/main/c/ca-certificates/ca-certificates_20210119.dsc' ca-certificates_20210119.dsc 1868 SHA256:51e5c099ab976f50f4d2f3c5ea0ad49853024cdb3e630322cbd7e02b05a034f4
'http://deb.debian.org/debian/pool/main/c/ca-certificates/ca-certificates_20210119.tar.xz' ca-certificates_20210119.tar.xz 232964 SHA256:daa3afae563711c30a0586ddae4336e8e3974c2b627faaca404c4e0141b64665
```

Other potentially useful URLs:

- https://sources.debian.net/src/ca-certificates/20210119/ (for browsing the source)
- https://sources.debian.net/src/ca-certificates/20210119/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/ca-certificates/20210119/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `cached-property=1.5.2-1`

Binary Packages:

- `python3-cached-property=1.5.2-1`

Licenses: (parsed from: `/usr/share/doc/python3-cached-property/copyright`)

- `BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris cached-property=1.5.2-1
'http://deb.debian.org/debian/pool/main/c/cached-property/cached-property_1.5.2-1.dsc' cached-property_1.5.2-1.dsc 2166 SHA256:ad29c5125b0130d8eda345be1babb3361270b6420f76f00dc0bb75079df858fc
'http://deb.debian.org/debian/pool/main/c/cached-property/cached-property_1.5.2.orig.tar.gz' cached-property_1.5.2.orig.tar.gz 12244 SHA256:9fa5755838eecbb2d234c3aa390bd80fbd3ac6b6869109bfc1b499f7bd89a130
'http://deb.debian.org/debian/pool/main/c/cached-property/cached-property_1.5.2-1.debian.tar.xz' cached-property_1.5.2-1.debian.tar.xz 3780 SHA256:e16f1f2bbaa740ab7771d5a3c23eac2f07feb475daf5b07a0419be79c524ffd8
```

Other potentially useful URLs:

- https://sources.debian.net/src/cached-property/1.5.2-1/ (for browsing the source)
- https://sources.debian.net/src/cached-property/1.5.2-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/cached-property/1.5.2-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `cairo=1.16.0-5`

Binary Packages:

- `libcairo2:amd64=1.16.0-5`

Licenses: (parsed from: `/usr/share/doc/libcairo2/copyright`)

- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris cairo=1.16.0-5
'http://deb.debian.org/debian/pool/main/c/cairo/cairo_1.16.0-5.dsc' cairo_1.16.0-5.dsc 2939 SHA256:1bcd6dbe5544ad02170d18226ba544b96e2a48bd239407c4ee40c5eb9a441a06
'http://deb.debian.org/debian/pool/main/c/cairo/cairo_1.16.0.orig.tar.xz' cairo_1.16.0.orig.tar.xz 41997432 SHA256:5e7b29b3f113ef870d1e3ecf8adf21f923396401604bda16d44be45e66052331
'http://deb.debian.org/debian/pool/main/c/cairo/cairo_1.16.0-5.debian.tar.xz' cairo_1.16.0-5.debian.tar.xz 33144 SHA256:544726514b4b8cfdd151941714c2f910f995ddd4562e6de464c9487e9331fe9f
```

Other potentially useful URLs:

- https://sources.debian.net/src/cairo/1.16.0-5/ (for browsing the source)
- https://sources.debian.net/src/cairo/1.16.0-5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/cairo/1.16.0-5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `cdebconf=0.260`

Binary Packages:

- `libdebconfclient0:amd64=0.260`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris cdebconf=0.260
'http://deb.debian.org/debian/pool/main/c/cdebconf/cdebconf_0.260.dsc' cdebconf_0.260.dsc 2750 SHA256:0c0a3d76e19685f998e3b85834200255268f36b09eedfa9157fe0213958b7ea5
'http://deb.debian.org/debian/pool/main/c/cdebconf/cdebconf_0.260.tar.xz' cdebconf_0.260.tar.xz 279824 SHA256:ac8a9d7449c76eeaa8ed4ef0bbbf4c16b1b816b9905690c732dea2f341ac079b
```

Other potentially useful URLs:

- https://sources.debian.net/src/cdebconf/0.260/ (for browsing the source)
- https://sources.debian.net/src/cdebconf/0.260/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/cdebconf/0.260/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `chardet=4.0.0-1`

Binary Packages:

- `python3-chardet=4.0.0-1`

Licenses: (parsed from: `/usr/share/doc/python3-chardet/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris chardet=4.0.0-1
'http://deb.debian.org/debian/pool/main/c/chardet/chardet_4.0.0-1.dsc' chardet_4.0.0-1.dsc 2191 SHA256:1e043212ccd9689294fc57151c4f33bee67a406581bc9943d3b51780aeb4d333
'http://deb.debian.org/debian/pool/main/c/chardet/chardet_4.0.0.orig.tar.gz' chardet_4.0.0.orig.tar.gz 1907771 SHA256:0d6f53a15db4120f2b08c94f11e7d93d2c911ee118b6b30a04ec3ee8310179fa
'http://deb.debian.org/debian/pool/main/c/chardet/chardet_4.0.0-1.debian.tar.xz' chardet_4.0.0-1.debian.tar.xz 4868 SHA256:9f5c025839874ab66baa2423d542a9af4520b9c15d7bfa09a5439b1d972058d9
```

Other potentially useful URLs:

- https://sources.debian.net/src/chardet/4.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/chardet/4.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/chardet/4.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `colors.js=1.4.0-1`

Binary Packages:

- `node-colors=1.4.0-1`

Licenses: (parsed from: `/usr/share/doc/node-colors/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris colors.js=1.4.0-1
'http://deb.debian.org/debian/pool/main/c/colors.js/colors.js_1.4.0-1.dsc' colors.js_1.4.0-1.dsc 2020 SHA256:5879161fa230c476ee0b63cd1fb033804bfd4bd16a41dd1bd05528cdcb16cdab
'http://deb.debian.org/debian/pool/main/c/colors.js/colors.js_1.4.0.orig.tar.gz' colors.js_1.4.0.orig.tar.gz 46271 SHA256:efb9e25c033cb639d7a99131f522aee8435fcdc54e2f89b7d0cf26f72d2f5889
'http://deb.debian.org/debian/pool/main/c/colors.js/colors.js_1.4.0-1.debian.tar.xz' colors.js_1.4.0-1.debian.tar.xz 2632 SHA256:d0379b5c028aa95954e64380bec12b86cb7a9dff297f5d9cdd7c2c3423bdd29d
```

Other potentially useful URLs:

- https://sources.debian.net/src/colors.js/1.4.0-1/ (for browsing the source)
- https://sources.debian.net/src/colors.js/1.4.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/colors.js/1.4.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `coreutils=8.32-4`

Binary Packages:

- `coreutils=8.32-4+b1`

Licenses: (parsed from: `/usr/share/doc/coreutils/copyright`)

- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris coreutils=8.32-4
'http://deb.debian.org/debian/pool/main/c/coreutils/coreutils_8.32-4.dsc' coreutils_8.32-4.dsc 2096 SHA256:ea8cafd14b693ec2d8b6e33ee8564c1fa5f102e65574252b0d524aaee04ba7e9
'http://deb.debian.org/debian/pool/main/c/coreutils/coreutils_8.32.orig.tar.xz' coreutils_8.32.orig.tar.xz 5547836 SHA256:4458d8de7849df44ccab15e16b1548b285224dbba5f08fac070c1c0e0bcc4cfa
'http://deb.debian.org/debian/pool/main/c/coreutils/coreutils_8.32.orig.tar.xz.asc' coreutils_8.32.orig.tar.xz.asc 833 SHA256:71b944375b322ba77c9c56b687b48df885c676d4fd7c465b3706713a9b62ce0a
'http://deb.debian.org/debian/pool/main/c/coreutils/coreutils_8.32-4.debian.tar.xz' coreutils_8.32-4.debian.tar.xz 33028 SHA256:2d5337067b675e0b3fa7c88df164e7738ed4715a39e88e1e82dc9185e4e1b951
```

Other potentially useful URLs:

- https://sources.debian.net/src/coreutils/8.32-4/ (for browsing the source)
- https://sources.debian.net/src/coreutils/8.32-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/coreutils/8.32-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `curl=7.74.0-1.3+deb11u13`

Binary Packages:

- `curl=7.74.0-1.3+deb11u13`
- `libcurl4:amd64=7.74.0-1.3+deb11u13`

Licenses: (parsed from: `/usr/share/doc/curl/copyright`, `/usr/share/doc/libcurl4/copyright`)

- `BSD-3-Clause`
- `BSD-4-Clause`
- `ISC`
- `curl`
- `other`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris curl=7.74.0-1.3+deb11u13
'http://deb.debian.org/debian/pool/main/c/curl/curl_7.74.0-1.3%2bdeb11u13.dsc' curl_7.74.0-1.3+deb11u13.dsc 2740 SHA256:c24d188df313ef92753ab4d755cfda396095a1e374e65af70a60983bdc293e82
'http://deb.debian.org/debian/pool/main/c/curl/curl_7.74.0.orig.tar.gz' curl_7.74.0.orig.tar.gz 4043409 SHA256:e56b3921eeb7a2951959c02db0912b5fcd5fdba5aca071da819e1accf338bbd7
'http://deb.debian.org/debian/pool/main/c/curl/curl_7.74.0-1.3%2bdeb11u13.debian.tar.xz' curl_7.74.0-1.3+deb11u13.debian.tar.xz 76768 SHA256:30c92557142bb7d16b3a877e932d125d02142d6f7cc4984d92b0d4a015caea23
```

Other potentially useful URLs:

- https://sources.debian.net/src/curl/7.74.0-1.3+deb11u13/ (for browsing the source)
- https://sources.debian.net/src/curl/7.74.0-1.3+deb11u13/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/curl/7.74.0-1.3+deb11u13/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `cyrus-sasl2=2.1.27+dfsg-2.1+deb11u1`

Binary Packages:

- `libsasl2-2:amd64=2.1.27+dfsg-2.1+deb11u1`
- `libsasl2-modules-db:amd64=2.1.27+dfsg-2.1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libsasl2-2/copyright`, `/usr/share/doc/libsasl2-modules-db/copyright`)

- `BSD-4-clause`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris cyrus-sasl2=2.1.27+dfsg-2.1+deb11u1
'http://deb.debian.org/debian/pool/main/c/cyrus-sasl2/cyrus-sasl2_2.1.27%2bdfsg-2.1%2bdeb11u1.dsc' cyrus-sasl2_2.1.27+dfsg-2.1+deb11u1.dsc 3591 SHA256:4dafa1a5c90f0b3d9d6e9d22e810492edd3b91b9f1d4d9666683d257528445d6
'http://deb.debian.org/debian/pool/main/c/cyrus-sasl2/cyrus-sasl2_2.1.27%2bdfsg.orig.tar.xz' cyrus-sasl2_2.1.27+dfsg.orig.tar.xz 2058596 SHA256:108b0c691c423837264f05abb559ea76c3dfdd91246555e8abe87c129a6e37cd
'http://deb.debian.org/debian/pool/main/c/cyrus-sasl2/cyrus-sasl2_2.1.27%2bdfsg-2.1%2bdeb11u1.debian.tar.xz' cyrus-sasl2_2.1.27+dfsg-2.1+deb11u1.debian.tar.xz 102488 SHA256:70b7a55776febf987363f5bb58322d6f03186215374a2eb0b6203980924f8680
```

Other potentially useful URLs:

- https://sources.debian.net/src/cyrus-sasl2/2.1.27+dfsg-2.1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/cyrus-sasl2/2.1.27+dfsg-2.1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/cyrus-sasl2/2.1.27+dfsg-2.1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `dash=0.5.11+git20200708+dd9ef66-5`

Binary Packages:

- `dash=0.5.11+git20200708+dd9ef66-5`

Licenses: (parsed from: `/usr/share/doc/dash/copyright`)

- `BSD-3-Clause`
- `BSD-3-clause`
- `Expat`
- `FSFUL`
- `FSFULLR`
- `GPL-2`
- `GPL-2+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris dash=0.5.11+git20200708+dd9ef66-5
'http://deb.debian.org/debian/pool/main/d/dash/dash_0.5.11%2bgit20200708%2bdd9ef66-5.dsc' dash_0.5.11+git20200708+dd9ef66-5.dsc 1906 SHA256:b0568c34647dc2aa0b8e2656c5e7449d9a1feb4b89d6857f507173b1f9a42ee7
'http://deb.debian.org/debian/pool/main/d/dash/dash_0.5.11%2bgit20200708%2bdd9ef66.orig.tar.gz' dash_0.5.11+git20200708+dd9ef66.orig.tar.gz 167776 SHA256:ab70b1f165bfedadd1282da546f1c917f1b7ccb2c5c2f898310a963e2ab5520c
'http://deb.debian.org/debian/pool/main/d/dash/dash_0.5.11%2bgit20200708%2bdd9ef66-5.debian.tar.xz' dash_0.5.11+git20200708+dd9ef66-5.debian.tar.xz 43120 SHA256:5da6039e043c953ff91a31c767ed703699870682ff356a1642f4798ce04a2926
```

Other potentially useful URLs:

- https://sources.debian.net/src/dash/0.5.11+git20200708+dd9ef66-5/ (for browsing the source)
- https://sources.debian.net/src/dash/0.5.11+git20200708+dd9ef66-5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/dash/0.5.11+git20200708+dd9ef66-5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `db5.3=5.3.28+dfsg1-0.8`

Binary Packages:

- `libdb5.3:amd64=5.3.28+dfsg1-0.8`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris db5.3=5.3.28+dfsg1-0.8
'http://deb.debian.org/debian/pool/main/d/db5.3/db5.3_5.3.28%2bdfsg1-0.8.dsc' db5.3_5.3.28+dfsg1-0.8.dsc 3113 SHA256:5189bebd157e3b51c075804d1affebc87cdbfb782808c621e131660719c24374
'http://deb.debian.org/debian/pool/main/d/db5.3/db5.3_5.3.28%2bdfsg1.orig.tar.xz' db5.3_5.3.28+dfsg1.orig.tar.xz 19723860 SHA256:b19bf3dd8ce74b95a7b215be9a7c8489e8e8f18da60d64d6340a06e75f497749
'http://deb.debian.org/debian/pool/main/d/db5.3/db5.3_5.3.28%2bdfsg1-0.8.debian.tar.xz' db5.3_5.3.28+dfsg1-0.8.debian.tar.xz 30748 SHA256:073c0c87283bf5e606f3ce6d1814315b40b9685c943601ae3fd81e2da4e612d4
```

Other potentially useful URLs:

- https://sources.debian.net/src/db5.3/5.3.28+dfsg1-0.8/ (for browsing the source)
- https://sources.debian.net/src/db5.3/5.3.28+dfsg1-0.8/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/db5.3/5.3.28+dfsg1-0.8/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `debconf=1.5.77`

Binary Packages:

- `debconf=1.5.77`

Licenses: (parsed from: `/usr/share/doc/debconf/copyright`)

- `BSD-2-clause`

Source:

```console
$ apt-get source -qq --print-uris debconf=1.5.77
'http://deb.debian.org/debian/pool/main/d/debconf/debconf_1.5.77.dsc' debconf_1.5.77.dsc 2082 SHA256:2797e40ac2122a0ca6c1aa27bd63203e9da4342bb60e614efb848452a5696e41
'http://deb.debian.org/debian/pool/main/d/debconf/debconf_1.5.77.tar.xz' debconf_1.5.77.tar.xz 571412 SHA256:03482934c645140dd4cb8cae4970f81f576995b757ac7b89192067e72aa1d067
```

Other potentially useful URLs:

- https://sources.debian.net/src/debconf/1.5.77/ (for browsing the source)
- https://sources.debian.net/src/debconf/1.5.77/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/debconf/1.5.77/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `debian-archive-keyring=2021.1.1+deb11u1`

Binary Packages:

- `debian-archive-keyring=2021.1.1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/debian-archive-keyring/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris debian-archive-keyring=2021.1.1+deb11u1
'http://deb.debian.org/debian/pool/main/d/debian-archive-keyring/debian-archive-keyring_2021.1.1%2bdeb11u1.dsc' debian-archive-keyring_2021.1.1+deb11u1.dsc 1301 SHA256:afde187bdb36b807ab71eb0a5803d35a0a19265ff9ca47cb140f9f26aef2d6dd
'http://deb.debian.org/debian/pool/main/d/debian-archive-keyring/debian-archive-keyring_2021.1.1%2bdeb11u1.tar.xz' debian-archive-keyring_2021.1.1+deb11u1.tar.xz 174768 SHA256:7beff096d7293d019de8007d3425dbbcb18009b5780e6d0e172f57f5b6b300ae
```

Other potentially useful URLs:

- https://sources.debian.net/src/debian-archive-keyring/2021.1.1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/debian-archive-keyring/2021.1.1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/debian-archive-keyring/2021.1.1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `debianutils=4.11.2`

Binary Packages:

- `debianutils=4.11.2`

Licenses: (parsed from: `/usr/share/doc/debianutils/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris debianutils=4.11.2
'http://deb.debian.org/debian/pool/main/d/debianutils/debianutils_4.11.2.dsc' debianutils_4.11.2.dsc 1644 SHA256:b11164a7aa3ca07ae1d758d15d707928defb64f2c35bf96f2e4fd983ee17b310
'http://deb.debian.org/debian/pool/main/d/debianutils/debianutils_4.11.2.tar.xz' debianutils_4.11.2.tar.xz 158132 SHA256:3b680e81709b740387335fac8f8806d71611dcf60874e1a792e862e48a1650de
```

Other potentially useful URLs:

- https://sources.debian.net/src/debianutils/4.11.2/ (for browsing the source)
- https://sources.debian.net/src/debianutils/4.11.2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/debianutils/4.11.2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `defusedxml=0.6.0-2`

Binary Packages:

- `python3-defusedxml=0.6.0-2`

Licenses: (parsed from: `/usr/share/doc/python3-defusedxml/copyright`)

- `Python`

Source:

```console
$ apt-get source -qq --print-uris defusedxml=0.6.0-2
'http://deb.debian.org/debian/pool/main/d/defusedxml/defusedxml_0.6.0-2.dsc' defusedxml_0.6.0-2.dsc 2099 SHA256:ebc06e9f6417a6d72c51fcaa54aba7f038e28ab09610a7fc06da79c6ae8d9ecb
'http://deb.debian.org/debian/pool/main/d/defusedxml/defusedxml_0.6.0.orig.tar.gz' defusedxml_0.6.0.orig.tar.gz 62670 SHA256:f684034d135af4c6cbb949b8a4d2ed61634515257a67299e5f940fbaa34377f5
'http://deb.debian.org/debian/pool/main/d/defusedxml/defusedxml_0.6.0-2.debian.tar.xz' defusedxml_0.6.0-2.debian.tar.xz 8704 SHA256:b495ec628d01bc4fa502e60635786dfbf0a3103d9725db968337442f58a8718f
```

Other potentially useful URLs:

- https://sources.debian.net/src/defusedxml/0.6.0-2/ (for browsing the source)
- https://sources.debian.net/src/defusedxml/0.6.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/defusedxml/0.6.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `diffutils=1:3.7-5`

Binary Packages:

- `diffutils=1:3.7-5`

Licenses: (parsed from: `/usr/share/doc/diffutils/copyright`)

- `GFDL`
- `GPL`

Source:

```console
$ apt-get source -qq --print-uris diffutils=1:3.7-5
'http://deb.debian.org/debian/pool/main/d/diffutils/diffutils_3.7-5.dsc' diffutils_3.7-5.dsc 1714 SHA256:5476ed004e300f291b5f0a356074a8ba8944a8b34514bb0fe95d274455adbf5d
'http://deb.debian.org/debian/pool/main/d/diffutils/diffutils_3.7.orig.tar.xz' diffutils_3.7.orig.tar.xz 1448828 SHA256:b3a7a6221c3dc916085f0d205abf6b8e1ba443d4dd965118da364a1dc1cb3a26
'http://deb.debian.org/debian/pool/main/d/diffutils/diffutils_3.7.orig.tar.xz.asc' diffutils_3.7.orig.tar.xz.asc 833 SHA256:c89b9d60a1d67cf8b2dd108a8b918e4cce34cba6c9e1f67e2ca482c52c0258a7
'http://deb.debian.org/debian/pool/main/d/diffutils/diffutils_3.7-5.debian.tar.xz' diffutils_3.7-5.debian.tar.xz 89004 SHA256:c90fd39d677702226b89d7559c124d7eb0b88195c381853ca1e5c8ca08e90a3a
```

Other potentially useful URLs:

- https://sources.debian.net/src/diffutils/1:3.7-5/ (for browsing the source)
- https://sources.debian.net/src/diffutils/1:3.7-5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/diffutils/1:3.7-5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `docopt=0.6.2-3`

Binary Packages:

- `python3-docopt=0.6.2-3`

Licenses: (parsed from: `/usr/share/doc/python3-docopt/copyright`)

- `GPL-3`
- `MIT/X11`

Source:

```console
$ apt-get source -qq --print-uris docopt=0.6.2-3
'http://deb.debian.org/debian/pool/main/d/docopt/docopt_0.6.2-3.dsc' docopt_0.6.2-3.dsc 1948 SHA256:f54ef5af4a9ba274f7bf16b0406b82ef4407299537b702dc645b98f841dfe7ef
'http://deb.debian.org/debian/pool/main/d/docopt/docopt_0.6.2.orig.tar.gz' docopt_0.6.2.orig.tar.gz 26345 SHA256:2113eed1e7fbbcd43fb7ee6a977fb02d0b482753586c9dc1a8e3b7d541426e99
'http://deb.debian.org/debian/pool/main/d/docopt/docopt_0.6.2-3.debian.tar.xz' docopt_0.6.2-3.debian.tar.xz 3692 SHA256:31fb3a08b6bd1533e58db531125856996ba7df3528e7e5bf1897346b006681f1
```

Other potentially useful URLs:

- https://sources.debian.net/src/docopt/0.6.2-3/ (for browsing the source)
- https://sources.debian.net/src/docopt/0.6.2-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/docopt/0.6.2-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `dpkg=1.20.13`

Binary Packages:

- `dpkg=1.20.13`

Licenses: (parsed from: `/usr/share/doc/dpkg/copyright`)

- `BSD-2-clause`
- `GPL-2`
- `GPL-2+`
- `public-domain-md5`
- `public-domain-s-s-d`

Source:

```console
$ apt-get source -qq --print-uris dpkg=1.20.13
'http://deb.debian.org/debian/pool/main/d/dpkg/dpkg_1.20.13.dsc' dpkg_1.20.13.dsc 2124 SHA256:fa618098428084fc5411f809bbc33922e126e4fefadfa525bfa6a1b0d09c863f
'http://deb.debian.org/debian/pool/main/d/dpkg/dpkg_1.20.13.tar.xz' dpkg_1.20.13.tar.xz 5009848 SHA256:d2aa90535d750b20d1f40827344d74bb552ee5d40d3c24603496fd438f15424d
```

Other potentially useful URLs:

- https://sources.debian.net/src/dpkg/1.20.13/ (for browsing the source)
- https://sources.debian.net/src/dpkg/1.20.13/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/dpkg/1.20.13/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `e2fsprogs=1.46.2-2+deb11u1`

Binary Packages:

- `e2fsprogs=1.46.2-2+deb11u1`
- `libcom-err2:amd64=1.46.2-2+deb11u1`
- `libext2fs2:amd64=1.46.2-2+deb11u1`
- `libss2:amd64=1.46.2-2+deb11u1`
- `logsave=1.46.2-2+deb11u1`

Licenses: (parsed from: `/usr/share/doc/e2fsprogs/copyright`, `/usr/share/doc/libcom-err2/copyright`, `/usr/share/doc/libext2fs2/copyright`, `/usr/share/doc/libss2/copyright`, `/usr/share/doc/logsave/copyright`)

- `GPL-2`
- `LGPL-2`

Source:

```console
$ apt-get source -qq --print-uris e2fsprogs=1.46.2-2+deb11u1
'http://deb.debian.org/debian-security/pool/updates/main/e/e2fsprogs/e2fsprogs_1.46.2-2%2bdeb11u1.dsc' e2fsprogs_1.46.2-2+deb11u1.dsc 3103 SHA256:18f4d571c97a50bf4f5139e707320b49973e1bd2131b38442784bacc8e080fd4
'http://deb.debian.org/debian-security/pool/updates/main/e/e2fsprogs/e2fsprogs_1.46.2.orig.tar.gz' e2fsprogs_1.46.2.orig.tar.gz 9496954 SHA256:f79f26b4f65bdc059fca12e1ec6a3040c3ce1a503fb70eb915bee71903815cd5
'http://deb.debian.org/debian-security/pool/updates/main/e/e2fsprogs/e2fsprogs_1.46.2.orig.tar.gz.asc' e2fsprogs_1.46.2.orig.tar.gz.asc 488 SHA256:948552550f23a9e0223cecb51b5b85258c9d94895a20bce1180fce770628a55f
'http://deb.debian.org/debian-security/pool/updates/main/e/e2fsprogs/e2fsprogs_1.46.2-2%2bdeb11u1.debian.tar.xz' e2fsprogs_1.46.2-2+deb11u1.debian.tar.xz 93408 SHA256:48b50e91479754043fe442c0bdd4ba7cddc8e5b2ff0b93ca001b1a6b05067b80
```

Other potentially useful URLs:

- https://sources.debian.net/src/e2fsprogs/1.46.2-2+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/e2fsprogs/1.46.2-2+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/e2fsprogs/1.46.2-2+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `expat=2.2.10-2+deb11u6`

Binary Packages:

- `libexpat1:amd64=2.2.10-2+deb11u6`

Licenses: (parsed from: `/usr/share/doc/libexpat1/copyright`)

- `MIT`

Source:

```console
$ apt-get source -qq --print-uris expat=2.2.10-2+deb11u6
'http://deb.debian.org/debian-security/pool/updates/main/e/expat/expat_2.2.10-2%2bdeb11u6.dsc' expat_2.2.10-2+deb11u6.dsc 2020 SHA256:7227fe4cce0d7b0d43bab1d5662cf060fbd8fabe9e82a36827a9265a29ee2a5a
'http://deb.debian.org/debian-security/pool/updates/main/e/expat/expat_2.2.10.orig.tar.gz' expat_2.2.10.orig.tar.gz 8276395 SHA256:62e280f5fd29a5b70973f623e20a7412c3e3912c2684cb0e462e2c881be129e1
'http://deb.debian.org/debian-security/pool/updates/main/e/expat/expat_2.2.10-2%2bdeb11u6.debian.tar.xz' expat_2.2.10-2+deb11u6.debian.tar.xz 67904 SHA256:74ea952e8094b333125dde907c29618724946cef660828d1f48d1bfc3bef574d
```

Other potentially useful URLs:

- https://sources.debian.net/src/expat/2.2.10-2+deb11u6/ (for browsing the source)
- https://sources.debian.net/src/expat/2.2.10-2+deb11u6/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/expat/2.2.10-2+deb11u6/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `file=1:5.39-3+deb11u1`

Binary Packages:

- `libmagic-mgc=1:5.39-3+deb11u1`
- `libmagic1:amd64=1:5.39-3+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libmagic-mgc/copyright`, `/usr/share/doc/libmagic1/copyright`)

- `BSD-2-Clause-alike`
- `BSD-2-Clause-netbsd`
- `BSD-2-Clause-regents`
- `MIT-Old-Style-with-legal-disclaimer-2`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris file=1:5.39-3+deb11u1
'http://deb.debian.org/debian/pool/main/f/file/file_5.39-3%2bdeb11u1.dsc' file_5.39-3+deb11u1.dsc 2424 SHA256:b08cfd706099600aa634d3cdcc2a7461908902414ae8cbfd1caddf557983e4e8
'http://deb.debian.org/debian/pool/main/f/file/file_5.39.orig.tar.gz' file_5.39.orig.tar.gz 954266 SHA256:f05d286a76d9556243d0cb05814929c2ecf3a5ba07963f8f70bfaaa70517fad1
'http://deb.debian.org/debian/pool/main/f/file/file_5.39.orig.tar.gz.asc' file_5.39.orig.tar.gz.asc 169 SHA256:409232b54cabe3082f38f1e7ec4c69e7d937f26d039da691f7349d142b48df83
'http://deb.debian.org/debian/pool/main/f/file/file_5.39-3%2bdeb11u1.debian.tar.xz' file_5.39-3+deb11u1.debian.tar.xz 34816 SHA256:c4ef624328d06f6128d808fd0edc14b1d856d6fefe0f29dfcae0ce30b42de0a3
```

Other potentially useful URLs:

- https://sources.debian.net/src/file/1:5.39-3+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/file/1:5.39-3+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/file/1:5.39-3+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `findutils=4.8.0-1`

Binary Packages:

- `findutils=4.8.0-1`

Licenses: (parsed from: `/usr/share/doc/findutils/copyright`)

- `GFDL-1.3`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris findutils=4.8.0-1
'http://deb.debian.org/debian/pool/main/f/findutils/findutils_4.8.0-1.dsc' findutils_4.8.0-1.dsc 2302 SHA256:47f342ec5146f4138f5004dbefe5838656057b502dfe225884b9f56840e29a3b
'http://deb.debian.org/debian/pool/main/f/findutils/findutils_4.8.0.orig.tar.xz' findutils_4.8.0.orig.tar.xz 1983096 SHA256:57127b7e97d91282c6ace556378d5455a9509898297e46e10443016ea1387164
'http://deb.debian.org/debian/pool/main/f/findutils/findutils_4.8.0.orig.tar.xz.asc' findutils_4.8.0.orig.tar.xz.asc 488 SHA256:dc0d5251026532d2b115e447eea70a934d3df6a0efcaf225c9d585eeedeefe62
'http://deb.debian.org/debian/pool/main/f/findutils/findutils_4.8.0-1.debian.tar.xz' findutils_4.8.0-1.debian.tar.xz 27296 SHA256:c99753f13f9e79653f79a398d1aafb15294c8f7953ad86948c7bf4cb0032bb43
```

Other potentially useful URLs:

- https://sources.debian.net/src/findutils/4.8.0-1/ (for browsing the source)
- https://sources.debian.net/src/findutils/4.8.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/findutils/4.8.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `fontconfig=2.13.1-4.2`

Binary Packages:

- `fontconfig=2.13.1-4.2`
- `fontconfig-config=2.13.1-4.2`
- `libfontconfig1:amd64=2.13.1-4.2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris fontconfig=2.13.1-4.2
'http://deb.debian.org/debian/pool/main/f/fontconfig/fontconfig_2.13.1-4.2.dsc' fontconfig_2.13.1-4.2.dsc 2716 SHA256:d22e6441f0aa03b569d886fbb3227330dd2305e7aa10513e177ced28b8b52d63
'http://deb.debian.org/debian/pool/main/f/fontconfig/fontconfig_2.13.1.orig.tar.bz2' fontconfig_2.13.1.orig.tar.bz2 1723639 SHA256:f655dd2a986d7aa97e052261b36aa67b0a64989496361eca8d604e6414006741
'http://deb.debian.org/debian/pool/main/f/fontconfig/fontconfig_2.13.1-4.2.debian.tar.xz' fontconfig_2.13.1-4.2.debian.tar.xz 55124 SHA256:f1ec69a2a0affd86189d3b75ced77b30bbcbc3a6fc0508490e570d4786464b58
```

Other potentially useful URLs:

- https://sources.debian.net/src/fontconfig/2.13.1-4.2/ (for browsing the source)
- https://sources.debian.net/src/fontconfig/2.13.1-4.2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/fontconfig/2.13.1-4.2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `fonts-dejavu=2.37-2`

Binary Packages:

- `fonts-dejavu-core=2.37-2`

Licenses: (parsed from: `/usr/share/doc/fonts-dejavu-core/copyright`)

- `GPL-2`
- `GPL-2+`
- `bitstream-vera`

Source:

```console
$ apt-get source -qq --print-uris fonts-dejavu=2.37-2
'http://deb.debian.org/debian/pool/main/f/fonts-dejavu/fonts-dejavu_2.37-2.dsc' fonts-dejavu_2.37-2.dsc 2387 SHA256:13948768dbf1a9aa3ae9fe592a4c6c904b1dd075acb689a49b85e0ae73b1756c
'http://deb.debian.org/debian/pool/main/f/fonts-dejavu/fonts-dejavu_2.37.orig.tar.bz2' fonts-dejavu_2.37.orig.tar.bz2 12050109 SHA256:4b21c5203f792343d5e90ab1cb0cf07e99887218abe3d83cd9a98cea9085e799
'http://deb.debian.org/debian/pool/main/f/fonts-dejavu/fonts-dejavu_2.37-2.debian.tar.xz' fonts-dejavu_2.37-2.debian.tar.xz 11408 SHA256:428cf37685df891574d2dcb32aa9366e4e95985fda7d87069903313bb03470ab
```

Other potentially useful URLs:

- https://sources.debian.net/src/fonts-dejavu/2.37-2/ (for browsing the source)
- https://sources.debian.net/src/fonts-dejavu/2.37-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/fonts-dejavu/2.37-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `fonts-font-awesome=5.0.10+really4.7.0~dfsg-4.1`

Binary Packages:

- `fonts-font-awesome=5.0.10+really4.7.0~dfsg-4.1`

Licenses: (parsed from: `/usr/share/doc/fonts-font-awesome/copyright`)

- `Expat`
- `GPL-3`
- `GPL-3+`
- `OFL-1.1`

Source:

```console
$ apt-get source -qq --print-uris fonts-font-awesome=5.0.10+really4.7.0~dfsg-4.1
'http://deb.debian.org/debian/pool/main/f/fonts-font-awesome/fonts-font-awesome_5.0.10%2breally4.7.0%7edfsg-4.1.dsc' fonts-font-awesome_5.0.10+really4.7.0~dfsg-4.1.dsc 2322 SHA256:50bcabfd5cb4ae4ff602ceabc358ae0253336bb50eec3a4414c668810457f489
'http://deb.debian.org/debian/pool/main/f/fonts-font-awesome/fonts-font-awesome_5.0.10%2breally4.7.0%7edfsg.orig.tar.gz' fonts-font-awesome_5.0.10+really4.7.0~dfsg.orig.tar.gz 675665 SHA256:9d25735ecb8984dae7b1bf04c6c343f8684ce88e0c81104e4b5f5495df3ded5d
'http://deb.debian.org/debian/pool/main/f/fonts-font-awesome/fonts-font-awesome_5.0.10%2breally4.7.0%7edfsg-4.1.debian.tar.xz' fonts-font-awesome_5.0.10+really4.7.0~dfsg-4.1.debian.tar.xz 11068 SHA256:671cb14ca943a2a7cc07df2dedb639edc95a83dd674bfc84a3df5568bc4b708b
```

Other potentially useful URLs:

- https://sources.debian.net/src/fonts-font-awesome/5.0.10+really4.7.0~dfsg-4.1/ (for browsing the source)
- https://sources.debian.net/src/fonts-font-awesome/5.0.10+really4.7.0~dfsg-4.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/fonts-font-awesome/5.0.10+really4.7.0~dfsg-4.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `fonts-inconsolata=001.010-6`

Binary Packages:

- `fonts-inconsolata=001.010-6`

Licenses: (parsed from: `/usr/share/doc/fonts-inconsolata/copyright`)

- `Open Font License 1.0`
- `The packaging is released under the same license as the Font Software`

Source:

```console
$ apt-get source -qq --print-uris fonts-inconsolata=001.010-6
'http://deb.debian.org/debian/pool/main/f/fonts-inconsolata/fonts-inconsolata_001.010-6.dsc' fonts-inconsolata_001.010-6.dsc 2080 SHA256:4a03e4fdd044f79e1b0b122d31dc92a24339be33434207e37c1b967c100e149d
'http://deb.debian.org/debian/pool/main/f/fonts-inconsolata/fonts-inconsolata_001.010.orig.tar.bz2' fonts-inconsolata_001.010.orig.tar.bz2 146357 SHA256:5b74557113257c6dc8d937c172fad8ff9ed3c34c733c1d94179a01e580f6b6f5
'http://deb.debian.org/debian/pool/main/f/fonts-inconsolata/fonts-inconsolata_001.010-6.debian.tar.xz' fonts-inconsolata_001.010-6.debian.tar.xz 5196 SHA256:7104fbfc3d193602106f606bda83e81bf2a498a3ea87085888689b9fd4430bd5
```

Other potentially useful URLs:

- https://sources.debian.net/src/fonts-inconsolata/001.010-6/ (for browsing the source)
- https://sources.debian.net/src/fonts-inconsolata/001.010-6/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/fonts-inconsolata/001.010-6/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `fonts-noto-cjk=1:20201206-cjk+repack1-1`

Binary Packages:

- `fonts-noto-cjk=1:20201206-cjk+repack1-1`

Licenses: (parsed from: `/usr/share/doc/fonts-noto-cjk/copyright`)

- `GPL-3`
- `GPL-3+`
- `SIL-1.1`

Source:

```console
$ apt-get source -qq --print-uris fonts-noto-cjk=1:20201206-cjk+repack1-1
'http://deb.debian.org/debian/pool/main/f/fonts-noto-cjk/fonts-noto-cjk_20201206-cjk%2brepack1-1.dsc' fonts-noto-cjk_20201206-cjk+repack1-1.dsc 2163 SHA256:0fbfb471ec62a16821f21d59909c634ced4f72b66be28c67879a61b510497172
'http://deb.debian.org/debian/pool/main/f/fonts-noto-cjk/fonts-noto-cjk_20201206-cjk%2brepack1.orig.tar.xz' fonts-noto-cjk_20201206-cjk+repack1.orig.tar.xz 182606672 SHA256:44100e91817be4a8e94b397579bf62c11e3c8d3d6316d1f9468057b1623d2387
'http://deb.debian.org/debian/pool/main/f/fonts-noto-cjk/fonts-noto-cjk_20201206-cjk%2brepack1-1.debian.tar.xz' fonts-noto-cjk_20201206-cjk+repack1-1.debian.tar.xz 5712 SHA256:93b5e900e46ba2e962ac7be2cbbfefa912324ebe9c33e6d66c0776e2ad57d49b
```

Other potentially useful URLs:

- https://sources.debian.net/src/fonts-noto-cjk/1:20201206-cjk+repack1-1/ (for browsing the source)
- https://sources.debian.net/src/fonts-noto-cjk/1:20201206-cjk+repack1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/fonts-noto-cjk/1:20201206-cjk+repack1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `fonts-roboto=2:0~20170802-3`

Binary Packages:

- `fonts-roboto-unhinted=2:0~20170802-3`

Licenses: (parsed from: `/usr/share/doc/fonts-roboto-unhinted/copyright`)

- `Apache-2.0`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris fonts-roboto=2:0~20170802-3
'http://deb.debian.org/debian/pool/main/f/fonts-roboto/fonts-roboto_0%7e20170802-3.dsc' fonts-roboto_0~20170802-3.dsc 2043 SHA256:86f6bda68337b337d6906bacdb8f0293db8d97c9f15a77e3c30f83c1b1104464
'http://deb.debian.org/debian/pool/main/f/fonts-roboto/fonts-roboto_0%7e20170802.orig.tar.xz' fonts-roboto_0~20170802.orig.tar.xz 5960112 SHA256:28729751815fa424282f9e534ac21ce11313969b67bb4ab278268fdcb23967e1
'http://deb.debian.org/debian/pool/main/f/fonts-roboto/fonts-roboto_0%7e20170802-3.debian.tar.xz' fonts-roboto_0~20170802-3.debian.tar.xz 20488 SHA256:33d09403f2e68773e97b40421dfe79d85ed596f7fa8d29aff0549894d2076750
```

Other potentially useful URLs:

- https://sources.debian.net/src/fonts-roboto/2:0~20170802-3/ (for browsing the source)
- https://sources.debian.net/src/fonts-roboto/2:0~20170802-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/fonts-roboto/2:0~20170802-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `fonts-urw-base35=20200910-1`

Binary Packages:

- `fonts-urw-base35=20200910-1`

Licenses: (parsed from: `/usr/share/doc/fonts-urw-base35/copyright`)

- `AGPL-3`
- `AGPL-3 with Font exception`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris fonts-urw-base35=20200910-1
'http://deb.debian.org/debian/pool/main/f/fonts-urw-base35/fonts-urw-base35_20200910-1.dsc' fonts-urw-base35_20200910-1.dsc 2061 SHA256:6654b571e4cba4e7a3ee280bc89fdb7cabcc917021d8166d4b2e99e0fdff2843
'http://deb.debian.org/debian/pool/main/f/fonts-urw-base35/fonts-urw-base35_20200910.orig.tar.gz' fonts-urw-base35_20200910.orig.tar.gz 11190093 SHA256:e0d9b7f11885fdfdc4987f06b2aa0565ad2a4af52b22e5ebf79e1a98abd0ae2f
'http://deb.debian.org/debian/pool/main/f/fonts-urw-base35/fonts-urw-base35_20200910-1.debian.tar.xz' fonts-urw-base35_20200910-1.debian.tar.xz 17772 SHA256:92fff963144e01f86d4b6f380401963dd626e84c64c5ec545933dc138c80a587
```

Other potentially useful URLs:

- https://sources.debian.net/src/fonts-urw-base35/20200910-1/ (for browsing the source)
- https://sources.debian.net/src/fonts-urw-base35/20200910-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/fonts-urw-base35/20200910-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `freetype=2.10.4+dfsg-1+deb11u1`

Binary Packages:

- `libfreetype6:amd64=2.10.4+dfsg-1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libfreetype6/copyright`)

- `Apache-2.0`
- `BSD-3-Clause`
- `FSFAP`
- `FSFUL`
- `FSFULLR`
- `FTL`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `MIT`
- `OFL-1.1`
- `OpenGroup-BSD-like`
- `Permissive`
- `Public-Domain`
- `Zlib`

Source:

```console
$ apt-get source -qq --print-uris freetype=2.10.4+dfsg-1+deb11u1
'http://deb.debian.org/debian/pool/main/f/freetype/freetype_2.10.4%2bdfsg-1%2bdeb11u1.dsc' freetype_2.10.4+dfsg-1+deb11u1.dsc 3762 SHA256:6c93012be153ec146b77bfa4df0bd8b19affe63f5a8bdbfbf3ce6faf4a89e365
'http://deb.debian.org/debian/pool/main/f/freetype/freetype_2.10.4%2bdfsg.orig-ft2demos.tar.xz' freetype_2.10.4+dfsg.orig-ft2demos.tar.xz 236712 SHA256:3f873ebe4fb387da3859149459f9be95320ce1fd56b50f8fdb9d2a8492887083
'http://deb.debian.org/debian/pool/main/f/freetype/freetype_2.10.4%2bdfsg.orig-ft2demos.tar.xz.asc' freetype_2.10.4+dfsg.orig-ft2demos.tar.xz.asc 195 SHA256:38d5b9a5aa11ecf8c6d4c983ef48b3ce2288fdf93d44719df2598b9d415c8061
'http://deb.debian.org/debian/pool/main/f/freetype/freetype_2.10.4%2bdfsg.orig-ft2docs.tar.xz' freetype_2.10.4+dfsg.orig-ft2docs.tar.xz 2079084 SHA256:cca1c19d1efa911bb685d919b5b0fe1279b0699bf8eb6a3d3bf9f02784758212
'http://deb.debian.org/debian/pool/main/f/freetype/freetype_2.10.4%2bdfsg.orig-ft2docs.tar.xz.asc' freetype_2.10.4+dfsg.orig-ft2docs.tar.xz.asc 195 SHA256:29fca9ff0e1cdc57ad5707b17f629eeaa216eb334f6082f1b05fb0fe35e14ff3
'http://deb.debian.org/debian/pool/main/f/freetype/freetype_2.10.4%2bdfsg.orig.tar.xz' freetype_2.10.4+dfsg.orig.tar.xz 2259340 SHA256:db0c0938b3b75cf314775baa75198098e41583b3aaa4804b454f183ce45120a9
'http://deb.debian.org/debian/pool/main/f/freetype/freetype_2.10.4%2bdfsg-1%2bdeb11u1.debian.tar.xz' freetype_2.10.4+dfsg-1+deb11u1.debian.tar.xz 117572 SHA256:f8845df5a24d816934ef30b46b8561072df3f7973ea65654674d69810aab9c3b
```

Other potentially useful URLs:

- https://sources.debian.net/src/freetype/2.10.4+dfsg-1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/freetype/2.10.4+dfsg-1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/freetype/2.10.4+dfsg-1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `freezegun=0.3.15-1`

Binary Packages:

- `python3-freezegun=0.3.15-1`

Licenses: (parsed from: `/usr/share/doc/python3-freezegun/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris freezegun=0.3.15-1
'http://deb.debian.org/debian/pool/main/f/freezegun/freezegun_0.3.15-1.dsc' freezegun_0.3.15-1.dsc 2076 SHA256:e78e144ecbebab51acb2853b4fd89673975b35642b5ff05016ab055fbaacf79a
'http://deb.debian.org/debian/pool/main/f/freezegun/freezegun_0.3.15.orig.tar.gz' freezegun_0.3.15.orig.tar.gz 25530 SHA256:e2062f2c7f95cc276a834c22f1a17179467176b624cc6f936e8bc3be5535ad1b
'http://deb.debian.org/debian/pool/main/f/freezegun/freezegun_0.3.15-1.debian.tar.xz' freezegun_0.3.15-1.debian.tar.xz 2452 SHA256:a6727dc91df5bffb3e715b53d3fde0307276180fc68add73b0e3905415cd1f88
```

Other potentially useful URLs:

- https://sources.debian.net/src/freezegun/0.3.15-1/ (for browsing the source)
- https://sources.debian.net/src/freezegun/0.3.15-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/freezegun/0.3.15-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `fribidi=1.0.8-2+deb11u1`

Binary Packages:

- `libfribidi0:amd64=1.0.8-2+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libfribidi0/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris fribidi=1.0.8-2+deb11u1
'http://deb.debian.org/debian/pool/main/f/fribidi/fribidi_1.0.8-2%2bdeb11u1.dsc' fribidi_1.0.8-2+deb11u1.dsc 2481 SHA256:21c35e9e2e1a9665e0d1fb8f449299085fb471bb8f4ecfd1a1afc388eb1dd2ac
'http://deb.debian.org/debian/pool/main/f/fribidi/fribidi_1.0.8.orig.tar.bz2' fribidi_1.0.8.orig.tar.bz2 2077095 SHA256:94c7b68d86ad2a9613b4dcffe7bbeb03523d63b5b37918bdf2e4ef34195c1e6c
'http://deb.debian.org/debian/pool/main/f/fribidi/fribidi_1.0.8-2%2bdeb11u1.debian.tar.xz' fribidi_1.0.8-2+deb11u1.debian.tar.xz 10360 SHA256:62dc4a73351c71ac903f9428a5ebf5e32c0ff49a1a6a08dc95d9ce03e3f48a21
```

Other potentially useful URLs:

- https://sources.debian.net/src/fribidi/1.0.8-2+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/fribidi/1.0.8-2+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/fribidi/1.0.8-2+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gcc-10=10.2.1-6`

Binary Packages:

- `gcc-10-base:amd64=10.2.1-6`
- `libgcc-s1:amd64=10.2.1-6`
- `libstdc++6:amd64=10.2.1-6`

Licenses: (parsed from: `/usr/share/doc/gcc-10-base/copyright`, `/usr/share/doc/libgcc-s1/copyright`, `/usr/share/doc/libstdc++6/copyright`)

- `Artistic`
- `GFDL-1.2`
- `GPL`
- `GPL-2`
- `GPL-3`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris gcc-10=10.2.1-6
'http://deb.debian.org/debian/pool/main/g/gcc-10/gcc-10_10.2.1-6.dsc' gcc-10_10.2.1-6.dsc 27632 SHA256:24024c1e225ca968f37ce39047ff5f1058219976db9e88a807173c2f07fa6029
'http://deb.debian.org/debian/pool/main/g/gcc-10/gcc-10_10.2.1.orig.tar.xz' gcc-10_10.2.1.orig.tar.xz 84547844 SHA256:ea3c05faa381486e6b859c047dc14977418bf1ccda4567064e016493fd6fffec
'http://deb.debian.org/debian/pool/main/g/gcc-10/gcc-10_10.2.1-6.debian.tar.xz' gcc-10_10.2.1-6.debian.tar.xz 2366560 SHA256:a95d6b9da2be83f9751850b002021281411ff1003d9feb77298b131da47820b3
```

Other potentially useful URLs:

- https://sources.debian.net/src/gcc-10/10.2.1-6/ (for browsing the source)
- https://sources.debian.net/src/gcc-10/10.2.1-6/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gcc-10/10.2.1-6/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gcc-9=9.3.0-22`

Binary Packages:

- `gcc-9-base:amd64=9.3.0-22`

Licenses: (parsed from: `/usr/share/doc/gcc-9-base/copyright`)

- `Artistic`
- `GFDL-1.2`
- `GPL`
- `GPL-2`
- `GPL-3`
- `LGPL`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris gcc-9=9.3.0-22
'http://deb.debian.org/debian/pool/main/g/gcc-9/gcc-9_9.3.0-22.dsc' gcc-9_9.3.0-22.dsc 21926 SHA256:14a0ea03cee0eb5450cc630a3bdf47da157062b3e7622ac45f6ae14a321eae96
'http://deb.debian.org/debian/pool/main/g/gcc-9/gcc-9_9.3.0.orig.tar.gz' gcc-9_9.3.0.orig.tar.gz 88686943 SHA256:824044ffa96eb337bb1c1d4cf6a82691d0290d6f42e1d13362eea855458de060
'http://deb.debian.org/debian/pool/main/g/gcc-9/gcc-9_9.3.0-22.debian.tar.xz' gcc-9_9.3.0-22.debian.tar.xz 904252 SHA256:68d55260456847880c71831b69c19cb81e9d1abf09274ab77ab6c081e177d94d
```

Other potentially useful URLs:

- https://sources.debian.net/src/gcc-9/9.3.0-22/ (for browsing the source)
- https://sources.debian.net/src/gcc-9/9.3.0-22/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gcc-9/9.3.0-22/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gdbm=1.19-2`

Binary Packages:

- `libgdbm-compat4:amd64=1.19-2`
- `libgdbm6:amd64=1.19-2`

Licenses: (parsed from: `/usr/share/doc/libgdbm-compat4/copyright`, `/usr/share/doc/libgdbm6/copyright`)

- `GFDL-NIV-1.3+`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris gdbm=1.19-2
'http://deb.debian.org/debian/pool/main/g/gdbm/gdbm_1.19-2.dsc' gdbm_1.19-2.dsc 2603 SHA256:1f05cd17a44cdf05eb97df79147a77a57fba3346b48f00909abe8ad963bf6220
'http://deb.debian.org/debian/pool/main/g/gdbm/gdbm_1.19.orig.tar.gz' gdbm_1.19.orig.tar.gz 967861 SHA256:37ed12214122b972e18a0d94995039e57748191939ef74115b1d41d8811364bc
'http://deb.debian.org/debian/pool/main/g/gdbm/gdbm_1.19.orig.tar.gz.asc' gdbm_1.19.orig.tar.gz.asc 181 SHA256:8f4e0502073a7a22972f1edc84c70151033257d879402ac85176d3ebc984b2b8
'http://deb.debian.org/debian/pool/main/g/gdbm/gdbm_1.19-2.debian.tar.xz' gdbm_1.19-2.debian.tar.xz 16228 SHA256:c49d2faaa340acc8e94277dab0e0bf4ac10d49d9c374d6841883ac868edb5014
```

Other potentially useful URLs:

- https://sources.debian.net/src/gdbm/1.19-2/ (for browsing the source)
- https://sources.debian.net/src/gdbm/1.19-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gdbm/1.19-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `glib2.0=2.66.8-1+deb11u4`

Binary Packages:

- `libglib2.0-0:amd64=2.66.8-1+deb11u4`

Licenses: (parsed from: `/usr/share/doc/libglib2.0-0/copyright`)

- `Expat`
- `GPL-2+`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris glib2.0=2.66.8-1+deb11u4
'http://deb.debian.org/debian/pool/main/g/glib2.0/glib2.0_2.66.8-1%2bdeb11u4.dsc' glib2.0_2.66.8-1+deb11u4.dsc 3426 SHA256:5bbf022ff4dfed3afd338c6aad05d3eeafb24f3063956dac0bb7176ef399b971
'http://deb.debian.org/debian/pool/main/g/glib2.0/glib2.0_2.66.8.orig.tar.xz' glib2.0_2.66.8.orig.tar.xz 4845548 SHA256:97bc87dd91365589af5cbbfea2574833aea7a1b71840fd365ecd2852c76b9c8b
'http://deb.debian.org/debian/pool/main/g/glib2.0/glib2.0_2.66.8-1%2bdeb11u4.debian.tar.xz' glib2.0_2.66.8-1+deb11u4.debian.tar.xz 188516 SHA256:cfa47700ccca4f73e1ccf26a11051bf3cc4f28e57bfd39fa04cc0c0f2d65e38b
```

Other potentially useful URLs:

- https://sources.debian.net/src/glib2.0/2.66.8-1+deb11u4/ (for browsing the source)
- https://sources.debian.net/src/glib2.0/2.66.8-1+deb11u4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/glib2.0/2.66.8-1+deb11u4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `glibc=2.31-13+deb11u11`

Binary Packages:

- `libc-bin=2.31-13+deb11u11`
- `libc6:amd64=2.31-13+deb11u11`

Licenses: (parsed from: `/usr/share/doc/libc-bin/copyright`, `/usr/share/doc/libc6/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris glibc=2.31-13+deb11u11
'http://deb.debian.org/debian/pool/main/g/glibc/glibc_2.31-13%2bdeb11u11.dsc' glibc_2.31-13+deb11u11.dsc 8351 SHA256:eab21c7c387c0ebc54485974450b7ee0310ae7081f4cdb90b4591d6942e5c694
'http://deb.debian.org/debian/pool/main/g/glibc/glibc_2.31.orig.tar.xz' glibc_2.31.orig.tar.xz 17254692 SHA256:3dc7704b6166839c37d7047626fd199f3d4c09aca0d90e48c51c31c967dce34e
'http://deb.debian.org/debian/pool/main/g/glibc/glibc_2.31-13%2bdeb11u11.debian.tar.xz' glibc_2.31-13+deb11u11.debian.tar.xz 966464 SHA256:ff78277778ddefe1eb44680cb19d2d4dff91891effc3b59da424ae61b0bcd482
```

Other potentially useful URLs:

- https://sources.debian.net/src/glibc/2.31-13+deb11u11/ (for browsing the source)
- https://sources.debian.net/src/glibc/2.31-13+deb11u11/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/glibc/2.31-13+deb11u11/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gmp=2:6.2.1+dfsg-1+deb11u1`

Binary Packages:

- `libgmp10:amd64=2:6.2.1+dfsg-1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libgmp10/copyright`)

- `GPL`
- `GPL-2`
- `GPL-3`
- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris gmp=2:6.2.1+dfsg-1+deb11u1
'http://deb.debian.org/debian/pool/main/g/gmp/gmp_6.2.1%2bdfsg-1%2bdeb11u1.dsc' gmp_6.2.1+dfsg-1+deb11u1.dsc 2181 SHA256:4c09eb0a1c333fc5e67184a18f050af0f46f7f0fdeb533557bebd89df07c137b
'http://deb.debian.org/debian/pool/main/g/gmp/gmp_6.2.1%2bdfsg.orig.tar.xz' gmp_6.2.1+dfsg.orig.tar.xz 1853476 SHA256:c6ba08e3f079260ab90ff44ab8801eae134cd62cd78f4aa56317c0e70daa40cb
'http://deb.debian.org/debian/pool/main/g/gmp/gmp_6.2.1%2bdfsg-1%2bdeb11u1.debian.tar.xz' gmp_6.2.1+dfsg-1+deb11u1.debian.tar.xz 21920 SHA256:3cde187d542f5c095c6db8b76ec5252353e0413b492c57eb2e67ed3c43f40172
```

Other potentially useful URLs:

- https://sources.debian.net/src/gmp/2:6.2.1+dfsg-1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/gmp/2:6.2.1+dfsg-1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gmp/2:6.2.1+dfsg-1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gnupg2=2.2.27-2+deb11u2`

Binary Packages:

- `dirmngr=2.2.27-2+deb11u2`
- `gnupg=2.2.27-2+deb11u2`
- `gnupg-l10n=2.2.27-2+deb11u2`
- `gnupg-utils=2.2.27-2+deb11u2`
- `gpg=2.2.27-2+deb11u2`
- `gpg-agent=2.2.27-2+deb11u2`
- `gpg-wks-client=2.2.27-2+deb11u2`
- `gpg-wks-server=2.2.27-2+deb11u2`
- `gpgconf=2.2.27-2+deb11u2`
- `gpgsm=2.2.27-2+deb11u2`
- `gpgv=2.2.27-2+deb11u2`

Licenses: (parsed from: `/usr/share/doc/dirmngr/copyright`, `/usr/share/doc/gnupg/copyright`, `/usr/share/doc/gnupg-l10n/copyright`, `/usr/share/doc/gnupg-utils/copyright`, `/usr/share/doc/gpg/copyright`, `/usr/share/doc/gpg-agent/copyright`, `/usr/share/doc/gpg-wks-client/copyright`, `/usr/share/doc/gpg-wks-server/copyright`, `/usr/share/doc/gpgconf/copyright`, `/usr/share/doc/gpgsm/copyright`, `/usr/share/doc/gpgv/copyright`)

- `BSD-3-clause`
- `CC0-1.0`
- `Expat`
- `GPL-3`
- `GPL-3+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `LGPL-3`
- `LGPL-3+`
- `RFC-Reference`
- `TinySCHEME`
- `permissive`

Source:

```console
$ apt-get source -qq --print-uris gnupg2=2.2.27-2+deb11u2
'http://deb.debian.org/debian/pool/main/g/gnupg2/gnupg2_2.2.27-2%2bdeb11u2.dsc' gnupg2_2.2.27-2+deb11u2.dsc 3322 SHA256:a334ffaa6c078907e64d990c469873ec883abcbbc2ca3911e4f3072c50d33eb8
'http://deb.debian.org/debian/pool/main/g/gnupg2/gnupg2_2.2.27.orig.tar.bz2' gnupg2_2.2.27.orig.tar.bz2 7191555 SHA256:34e60009014ea16402069136e0a5f63d9b65f90096244975db5cea74b3d02399
'http://deb.debian.org/debian/pool/main/g/gnupg2/gnupg2_2.2.27.orig.tar.bz2.asc' gnupg2_2.2.27.orig.tar.bz2.asc 119 SHA256:2b44fd82da223cb629062b9c8840d92698c003be8531fc393c38f97b28cae2a4
'http://deb.debian.org/debian/pool/main/g/gnupg2/gnupg2_2.2.27-2%2bdeb11u2.debian.tar.xz' gnupg2_2.2.27-2+deb11u2.debian.tar.xz 63960 SHA256:b35c6a717d7f79cfd1a7468436721ca9c9211f70d10216e22523478094670a7b
```

Other potentially useful URLs:

- https://sources.debian.net/src/gnupg2/2.2.27-2+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/gnupg2/2.2.27-2+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gnupg2/2.2.27-2+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gnutls28=3.7.1-5+deb11u6`

Binary Packages:

- `libgnutls30:amd64=3.7.1-5+deb11u6`

Licenses: (parsed from: `/usr/share/doc/libgnutls30/copyright`)

- `Apache-2.0`
- `BSD-3-Clause`
- `CC0 license`
- `Expat`
- `GFDL-1.3`
- `GPL`
- `GPL-3`
- `GPLv3+`
- `LGPL`
- `LGPL-3`
- `LGPLv2.1+`
- `LGPLv3+_or_GPLv2+`
- `The main library is licensed under GNU Lesser`

Source:

```console
$ apt-get source -qq --print-uris gnutls28=3.7.1-5+deb11u6
'http://deb.debian.org/debian-security/pool/updates/main/g/gnutls28/gnutls28_3.7.1-5%2bdeb11u6.dsc' gnutls28_3.7.1-5+deb11u6.dsc 3522 SHA256:39849c7a4973f6b4daf89bdcce49956613b8321140934d288dfdb129bcc2be6a
'http://deb.debian.org/debian-security/pool/updates/main/g/gnutls28/gnutls28_3.7.1.orig.tar.xz' gnutls28_3.7.1.orig.tar.xz 6038388 SHA256:3777d7963eca5e06eb315686163b7b3f5045e2baac5e54e038ace9835e5cac6f
'http://deb.debian.org/debian-security/pool/updates/main/g/gnutls28/gnutls28_3.7.1.orig.tar.xz.asc' gnutls28_3.7.1.orig.tar.xz.asc 854 SHA256:13a683b12602c169a7ad7827ab0e3f35c8fa1f98675d0073cf7d54a8cd635582
'http://deb.debian.org/debian-security/pool/updates/main/g/gnutls28/gnutls28_3.7.1-5%2bdeb11u6.debian.tar.xz' gnutls28_3.7.1-5+deb11u6.debian.tar.xz 109212 SHA256:90bba2ee9e3d6ce7c711bef1a7dded19a3037279df43b1e53633e02845252d73
```

Other potentially useful URLs:

- https://sources.debian.net/src/gnutls28/3.7.1-5+deb11u6/ (for browsing the source)
- https://sources.debian.net/src/gnutls28/3.7.1-5+deb11u6/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gnutls28/3.7.1-5+deb11u6/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `graphite2=1.3.14-1`

Binary Packages:

- `libgraphite2-3:amd64=1.3.14-1`

Licenses: (parsed from: `/usr/share/doc/libgraphite2-3/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`
- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `MPL-1.1`
- `custom-sil-open-font-license`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris graphite2=1.3.14-1
'http://deb.debian.org/debian/pool/main/g/graphite2/graphite2_1.3.14-1.dsc' graphite2_1.3.14-1.dsc 2608 SHA256:3a622b8aa7d693d6d60d3cd29b49a7d9d7873ea6089cb52ce7a223261e605152
'http://deb.debian.org/debian/pool/main/g/graphite2/graphite2_1.3.14.orig.tar.gz' graphite2_1.3.14.orig.tar.gz 6629829 SHA256:7a3b342c5681921ce2e0c2496509d30b5b078399d5a7bd2358f95166d57d91df
'http://deb.debian.org/debian/pool/main/g/graphite2/graphite2_1.3.14-1.debian.tar.xz' graphite2_1.3.14-1.debian.tar.xz 12068 SHA256:94d584e6c748fa7e2f851c3bb39cb2cdb437b4f91d1d636f3d842357724cd9bd
```

Other potentially useful URLs:

- https://sources.debian.net/src/graphite2/1.3.14-1/ (for browsing the source)
- https://sources.debian.net/src/graphite2/1.3.14-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/graphite2/1.3.14-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `graphviz=2.42.2-5+deb11u1`

Binary Packages:

- `graphviz=2.42.2-5+deb11u1`
- `libcdt5:amd64=2.42.2-5+deb11u1`
- `libcgraph6:amd64=2.42.2-5+deb11u1`
- `libgvc6=2.42.2-5+deb11u1`
- `libgvpr2:amd64=2.42.2-5+deb11u1`
- `liblab-gamut1:amd64=2.42.2-5+deb11u1`
- `libpathplan4:amd64=2.42.2-5+deb11u1`

Licenses: (parsed from: `/usr/share/doc/graphviz/copyright`, `/usr/share/doc/libcdt5/copyright`, `/usr/share/doc/libcgraph6/copyright`, `/usr/share/doc/libgvc6/copyright`, `/usr/share/doc/libgvpr2/copyright`, `/usr/share/doc/liblab-gamut1/copyright`, `/usr/share/doc/libpathplan4/copyright`)

- `EPL-1.0`
- `MIT`
- `X/MIT`
- `zlib-style`

Source:

```console
$ apt-get source -qq --print-uris graphviz=2.42.2-5+deb11u1
'http://deb.debian.org/debian/pool/main/g/graphviz/graphviz_2.42.2-5%2bdeb11u1.dsc' graphviz_2.42.2-5+deb11u1.dsc 3232 SHA256:f2af3edb218c3890192a27c3258a52645592ee4c97f7a3ee7b7f7162c958bc3d
'http://deb.debian.org/debian/pool/main/g/graphviz/graphviz_2.42.2.orig.tar.bz2' graphviz_2.42.2.orig.tar.bz2 30740923 SHA256:1daed697d9cdd7fac3b320336fa98dd3518dd211769301dc716869fc3d5409b1
'http://deb.debian.org/debian/pool/main/g/graphviz/graphviz_2.42.2-5%2bdeb11u1.debian.tar.xz' graphviz_2.42.2-5+deb11u1.debian.tar.xz 39564 SHA256:40c7f141068c0721fa7194fe14c3211e9b8523fc1ad9255a96494fe31c2ef679
```

Other potentially useful URLs:

- https://sources.debian.net/src/graphviz/2.42.2-5+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/graphviz/2.42.2-5+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/graphviz/2.42.2-5+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `grep=3.6-1+deb11u1`

Binary Packages:

- `grep=3.6-1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/grep/copyright`)

- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris grep=3.6-1+deb11u1
'http://deb.debian.org/debian/pool/main/g/grep/grep_3.6-1%2bdeb11u1.dsc' grep_3.6-1+deb11u1.dsc 1648 SHA256:420cc5ac729e1f31b8c8c6fff183542aa0627cc142c8c24a90ea6c6ea8c403f7
'http://deb.debian.org/debian/pool/main/g/grep/grep_3.6.orig.tar.xz' grep_3.6.orig.tar.xz 1589412 SHA256:667e15e8afe189e93f9f21a7cd3a7b3f776202f417330b248c2ad4f997d9373e
'http://deb.debian.org/debian/pool/main/g/grep/grep_3.6.orig.tar.xz.asc' grep_3.6.orig.tar.xz.asc 833 SHA256:02b52c0676e0e97762cee638125a345a5300fdcba691c1a5b0725ee6bd28d4a8
'http://deb.debian.org/debian/pool/main/g/grep/grep_3.6-1%2bdeb11u1.debian.tar.xz' grep_3.6-1+deb11u1.debian.tar.xz 18600 SHA256:39c333035364b387e3dc437f6197e5054bb247607a897ed56495a87f169397f4
```

Other potentially useful URLs:

- https://sources.debian.net/src/grep/3.6-1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/grep/3.6-1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/grep/3.6-1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gsfonts=1:8.11+urwcyr1.0.7~pre44-4.5`

Binary Packages:

- `gsfonts=1:8.11+urwcyr1.0.7~pre44-4.5`

Licenses: (parsed from: `/usr/share/doc/gsfonts/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris gsfonts=1:8.11+urwcyr1.0.7~pre44-4.5
'http://deb.debian.org/debian/pool/main/g/gsfonts/gsfonts_8.11%2burwcyr1.0.7%7epre44-4.5.dsc' gsfonts_8.11+urwcyr1.0.7~pre44-4.5.dsc 1986 SHA256:e61dd17d0bb41c71c2b9e385b43a2d27c57382a5cf60835eb970d65274556449
'http://deb.debian.org/debian/pool/main/g/gsfonts/gsfonts_8.11%2burwcyr1.0.7%7epre44.orig.tar.gz' gsfonts_8.11+urwcyr1.0.7~pre44.orig.tar.gz 3390551 SHA256:9f2a598998bf05e023546ac981aa2a857aa1635d2e0e3020a3c3004ad564dc00
'http://deb.debian.org/debian/pool/main/g/gsfonts/gsfonts_8.11%2burwcyr1.0.7%7epre44-4.5.diff.gz' gsfonts_8.11+urwcyr1.0.7~pre44-4.5.diff.gz 7023 SHA256:24ce5f0ce38d68a07cf950a85617b7b8093a5b70793c9120bd9f765e642213ba
```

Other potentially useful URLs:

- https://sources.debian.net/src/gsfonts/1:8.11+urwcyr1.0.7~pre44-4.5/ (for browsing the source)
- https://sources.debian.net/src/gsfonts/1:8.11+urwcyr1.0.7~pre44-4.5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gsfonts/1:8.11+urwcyr1.0.7~pre44-4.5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gts=0.7.6+darcs121130-4`

Binary Packages:

- `libgts-0.7-5:amd64=0.7.6+darcs121130-4+b1`

Licenses: (parsed from: `/usr/share/doc/libgts-0.7-5/copyright`)

- `LGPL-2`
- `LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris gts=0.7.6+darcs121130-4
'http://deb.debian.org/debian/pool/main/g/gts/gts_0.7.6%2bdarcs121130-4.dsc' gts_0.7.6+darcs121130-4.dsc 2170 SHA256:3d7dbf72a2194891a485d03f8a002e8d149dc59a915a7bbf36b42c53408ef733
'http://deb.debian.org/debian/pool/main/g/gts/gts_0.7.6%2bdarcs121130.orig.tar.gz' gts_0.7.6+darcs121130.orig.tar.gz 880569 SHA256:c23f72ab74bbf65599f8c0b599d6336fabe1ec2a09c19b70544eeefdc069b73b
'http://deb.debian.org/debian/pool/main/g/gts/gts_0.7.6%2bdarcs121130-4.debian.tar.bz2' gts_0.7.6+darcs121130-4.debian.tar.bz2 13837 SHA256:1fcf9c79ca0b4fc3662de645ba4e65564ea974566a3ecd730e9908f1adc425cd
```

Other potentially useful URLs:

- https://sources.debian.net/src/gts/0.7.6+darcs121130-4/ (for browsing the source)
- https://sources.debian.net/src/gts/0.7.6+darcs121130-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gts/0.7.6+darcs121130-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gyp=0.1+20200513gitcaa6002-2`

Binary Packages:

- `gyp=0.1+20200513gitcaa6002-2`

Licenses: (parsed from: `/usr/share/doc/gyp/copyright`)

- `BSD-3-clause~Google`

Source:

```console
$ apt-get source -qq --print-uris gyp=0.1+20200513gitcaa6002-2
'http://deb.debian.org/debian/pool/main/g/gyp/gyp_0.1%2b20200513gitcaa6002-2.dsc' gyp_0.1+20200513gitcaa6002-2.dsc 2076 SHA256:342916fb598b48e4cfd33a2d511d8e04f64c1f008f6af9bb3471044c38a7bcc6
'http://deb.debian.org/debian/pool/main/g/gyp/gyp_0.1%2b20200513gitcaa6002.orig.tar.gz' gyp_0.1+20200513gitcaa6002.orig.tar.gz 628268 SHA256:8d531bc7d3302461d76a32367453cec60ed08b455f27a53d8f313d81761713a8
'http://deb.debian.org/debian/pool/main/g/gyp/gyp_0.1%2b20200513gitcaa6002-2.debian.tar.xz' gyp_0.1+20200513gitcaa6002-2.debian.tar.xz 9640 SHA256:6eb11fbc1450873c3c6778a3915ba398b220bb1230e5f59e1632817ebefb83b0
```

Other potentially useful URLs:

- https://sources.debian.net/src/gyp/0.1+20200513gitcaa6002-2/ (for browsing the source)
- https://sources.debian.net/src/gyp/0.1+20200513gitcaa6002-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gyp/0.1+20200513gitcaa6002-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gzip=1.10-4+deb11u1`

Binary Packages:

- `gzip=1.10-4+deb11u1`

Licenses: (parsed from: `/usr/share/doc/gzip/copyright`)

- `FSF-manpages`
- `GFDL-1.3+-no-invariant`
- `GFDL-3`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris gzip=1.10-4+deb11u1
'http://deb.debian.org/debian/pool/main/g/gzip/gzip_1.10-4%2bdeb11u1.dsc' gzip_1.10-4+deb11u1.dsc 1812 SHA256:0bcc813d124297ae741573b30db5faefec038aff92616d6ba014f859703f5acf
'http://deb.debian.org/debian/pool/main/g/gzip/gzip_1.10.orig.tar.gz' gzip_1.10.orig.tar.gz 1201421 SHA256:c91f74430bf7bc20402e1f657d0b252cb80aa66ba333a25704512af346633c68
'http://deb.debian.org/debian/pool/main/g/gzip/gzip_1.10-4%2bdeb11u1.debian.tar.xz' gzip_1.10-4+deb11u1.debian.tar.xz 22952 SHA256:183338e989ad327fca8c3281e8452c571bafed0c3cca0b6cea269a34b8dc19d2
```

Other potentially useful URLs:

- https://sources.debian.net/src/gzip/1.10-4+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/gzip/1.10-4+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gzip/1.10-4+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `harfbuzz=2.7.4-1`

Binary Packages:

- `libharfbuzz0b:amd64=2.7.4-1`

Licenses: (parsed from: `/usr/share/doc/libharfbuzz0b/copyright`)

- `MIT`

Source:

```console
$ apt-get source -qq --print-uris harfbuzz=2.7.4-1
'http://deb.debian.org/debian/pool/main/h/harfbuzz/harfbuzz_2.7.4-1.dsc' harfbuzz_2.7.4-1.dsc 2740 SHA256:d8b7efb43ad01cf6b7377f5c14bc0d0541489315026ed87f5f652f1a1aff59c7
'http://deb.debian.org/debian/pool/main/h/harfbuzz/harfbuzz_2.7.4.orig.tar.xz' harfbuzz_2.7.4.orig.tar.xz 9532468 SHA256:6ad11d653347bd25d8317589df4e431a2de372c0cf9be3543368e07ec23bb8e7
'http://deb.debian.org/debian/pool/main/h/harfbuzz/harfbuzz_2.7.4-1.debian.tar.xz' harfbuzz_2.7.4-1.debian.tar.xz 10508 SHA256:a756f72db035c105209470836df62aa607d2aceacadfee5b17020c634eb4bef0
```

Other potentially useful URLs:

- https://sources.debian.net/src/harfbuzz/2.7.4-1/ (for browsing the source)
- https://sources.debian.net/src/harfbuzz/2.7.4-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/harfbuzz/2.7.4-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `hostname=3.23`

Binary Packages:

- `hostname=3.23`

Licenses: (parsed from: `/usr/share/doc/hostname/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris hostname=3.23
'http://deb.debian.org/debian/pool/main/h/hostname/hostname_3.23.dsc' hostname_3.23.dsc 1402 SHA256:0694c083fad82da1fd33204557a30bfc745a689a64030ba360062daafe03ede0
'http://deb.debian.org/debian/pool/main/h/hostname/hostname_3.23.tar.gz' hostname_3.23.tar.gz 13672 SHA256:bc6d1954b22849869ff8b2a602e39f08b1702f686d4b58dd7927cdeb5b4876ef
```

Other potentially useful URLs:

- https://sources.debian.net/src/hostname/3.23/ (for browsing the source)
- https://sources.debian.net/src/hostname/3.23/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/hostname/3.23/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `icu=67.1-7`

Binary Packages:

- `libicu67:amd64=67.1-7`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris icu=67.1-7
'http://deb.debian.org/debian/pool/main/i/icu/icu_67.1-7.dsc' icu_67.1-7.dsc 2236 SHA256:3213915e2b2b07ab1d5fe81ba4e310d8146c0a799fd65ac1f1dbb0c32f56cff1
'http://deb.debian.org/debian/pool/main/i/icu/icu_67.1.orig.tar.gz' icu_67.1.orig.tar.gz 24518055 SHA256:94a80cd6f251a53bd2a997f6f1b5ac6653fe791dfab66e1eb0227740fb86d5dc
'http://deb.debian.org/debian/pool/main/i/icu/icu_67.1.orig.tar.gz.asc' icu_67.1.orig.tar.gz.asc 833 SHA256:0044119f3df92ff3055dc3609f527fa1290177f6ef1b6650ea136698b245e537
'http://deb.debian.org/debian/pool/main/i/icu/icu_67.1-7.debian.tar.xz' icu_67.1-7.debian.tar.xz 30256 SHA256:9836cbc00bf8da459734c82ccd435d09674e85e268f272decf16dbfa0bda730e
```

Other potentially useful URLs:

- https://sources.debian.net/src/icu/67.1-7/ (for browsing the source)
- https://sources.debian.net/src/icu/67.1-7/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/icu/67.1-7/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `init-system-helpers=1.60`

Binary Packages:

- `init-system-helpers=1.60`

Licenses: (parsed from: `/usr/share/doc/init-system-helpers/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris init-system-helpers=1.60
'http://deb.debian.org/debian/pool/main/i/init-system-helpers/init-system-helpers_1.60.dsc' init-system-helpers_1.60.dsc 1902 SHA256:51dd15cc34daf5e58e40560563785d422fb27ac8a2f6ce4e73350a800cbf3265
'http://deb.debian.org/debian/pool/main/i/init-system-helpers/init-system-helpers_1.60.tar.xz' init-system-helpers_1.60.tar.xz 40584 SHA256:2cf987e5ec2412faab8e99d6f26598b6ae65afe1af2073133575224997082172
```

Other potentially useful URLs:

- https://sources.debian.net/src/init-system-helpers/1.60/ (for browsing the source)
- https://sources.debian.net/src/init-system-helpers/1.60/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/init-system-helpers/1.60/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `isodate=0.6.0-2`

Binary Packages:

- `python3-isodate=0.6.0-2`

Licenses: (parsed from: `/usr/share/doc/python3-isodate/copyright`)

- `BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris isodate=0.6.0-2
'http://deb.debian.org/debian/pool/main/i/isodate/isodate_0.6.0-2.dsc' isodate_0.6.0-2.dsc 2078 SHA256:6ed4cb37997e2f7be789b4089ac97af7a16928dee6975bdeb5f1399ac1a03684
'http://deb.debian.org/debian/pool/main/i/isodate/isodate_0.6.0.orig.tar.gz' isodate_0.6.0.orig.tar.gz 28480 SHA256:2e364a3d5759479cdb2d37cce6b9376ea504db2ff90252a2e5b7cc89cc9ff2d8
'http://deb.debian.org/debian/pool/main/i/isodate/isodate_0.6.0-2.debian.tar.xz' isodate_0.6.0-2.debian.tar.xz 2648 SHA256:f73c0e6f34148d12e8c336627beba3f23d864562e23269a8bc9e8dfd287cb44b
```

Other potentially useful URLs:

- https://sources.debian.net/src/isodate/0.6.0-2/ (for browsing the source)
- https://sources.debian.net/src/isodate/0.6.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/isodate/0.6.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `jbigkit=2.1-3.1`

Binary Packages:

- `libjbig0:amd64=2.1-3.1+b2`

Licenses: (parsed from: `/usr/share/doc/libjbig0/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris jbigkit=2.1-3.1
'http://deb.debian.org/debian/pool/main/j/jbigkit/jbigkit_2.1-3.1.dsc' jbigkit_2.1-3.1.dsc 1299 SHA256:62c8812d508958c5d35f2b1579dc3052fb5bd8d2e77d023fad064c4b48c8c3f8
'http://deb.debian.org/debian/pool/main/j/jbigkit/jbigkit_2.1.orig.tar.gz' jbigkit_2.1.orig.tar.gz 438710 SHA256:de7106b6bfaf495d6865c7dd7ac6ca1381bd12e0d81405ea81e7f2167263d932
'http://deb.debian.org/debian/pool/main/j/jbigkit/jbigkit_2.1-3.1.debian.tar.xz' jbigkit_2.1-3.1.debian.tar.xz 7600 SHA256:ebc3c52deaf37d52baea54d648a713640dc262926abda7bf05cd08e7db5dd1ee
```

Other potentially useful URLs:

- https://sources.debian.net/src/jbigkit/2.1-3.1/ (for browsing the source)
- https://sources.debian.net/src/jbigkit/2.1-3.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/jbigkit/2.1-3.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `jinja2=2.11.3-1`

Binary Packages:

- `python3-jinja2=2.11.3-1`

Licenses: (parsed from: `/usr/share/doc/python3-jinja2/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris jinja2=2.11.3-1
'http://deb.debian.org/debian/pool/main/j/jinja2/jinja2_2.11.3-1.dsc' jinja2_2.11.3-1.dsc 1874 SHA256:93f64311945cb0fd4ebf5b1a196f0de91a3928ae30d40036ba6ecf61d1ceb997
'http://deb.debian.org/debian/pool/main/j/jinja2/jinja2_2.11.3.orig.tar.gz' jinja2_2.11.3.orig.tar.gz 257589 SHA256:a6d58433de0ae800347cab1fa3043cebbabe8baa9d29e668f1c768cb87a333c6
'http://deb.debian.org/debian/pool/main/j/jinja2/jinja2_2.11.3-1.debian.tar.xz' jinja2_2.11.3-1.debian.tar.xz 7800 SHA256:0266862e1f0b4a5ede21c45b1fda3b17fe19e750a18930ef318a65abd68f8631
```

Other potentially useful URLs:

- https://sources.debian.net/src/jinja2/2.11.3-1/ (for browsing the source)
- https://sources.debian.net/src/jinja2/2.11.3-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/jinja2/2.11.3-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `keyutils=1.6.1-2`

Binary Packages:

- `libkeyutils1:amd64=1.6.1-2`

Licenses: (parsed from: `/usr/share/doc/libkeyutils1/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris keyutils=1.6.1-2
'http://deb.debian.org/debian/pool/main/k/keyutils/keyutils_1.6.1-2.dsc' keyutils_1.6.1-2.dsc 2076 SHA256:6dd531f522fb3c5d8cfaaaf726e9277b64f50bff8c05d06269f42a677f65a4a8
'http://deb.debian.org/debian/pool/main/k/keyutils/keyutils_1.6.1.orig.tar.bz2' keyutils_1.6.1.orig.tar.bz2 97232 SHA256:c8b15722ae51d95b9ad76cc6d49a4c2cc19b0c60f72f61fb9bf43eea7cbd64ce
'http://deb.debian.org/debian/pool/main/k/keyutils/keyutils_1.6.1-2.debian.tar.xz' keyutils_1.6.1-2.debian.tar.xz 13412 SHA256:862442538428b514bb33a1c8488d4528c5ea48feca0ea5e60d8d34fd440f2355
```

Other potentially useful URLs:

- https://sources.debian.net/src/keyutils/1.6.1-2/ (for browsing the source)
- https://sources.debian.net/src/keyutils/1.6.1-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/keyutils/1.6.1-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `krb5=1.18.3-6+deb11u5`

Binary Packages:

- `libgssapi-krb5-2:amd64=1.18.3-6+deb11u5`
- `libk5crypto3:amd64=1.18.3-6+deb11u5`
- `libkrb5-3:amd64=1.18.3-6+deb11u5`
- `libkrb5support0:amd64=1.18.3-6+deb11u5`

Licenses: (parsed from: `/usr/share/doc/libgssapi-krb5-2/copyright`, `/usr/share/doc/libk5crypto3/copyright`, `/usr/share/doc/libkrb5-3/copyright`, `/usr/share/doc/libkrb5support0/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris krb5=1.18.3-6+deb11u5
'http://deb.debian.org/debian/pool/main/k/krb5/krb5_1.18.3-6%2bdeb11u5.dsc' krb5_1.18.3-6+deb11u5.dsc 3209 SHA256:36c3edb6deb63df00b02fa00c3352139a0b51f30c9f20da8041f06818f771445
'http://deb.debian.org/debian/pool/main/k/krb5/krb5_1.18.3.orig.tar.gz' krb5_1.18.3.orig.tar.gz 8715312 SHA256:e61783c292b5efd9afb45c555a80dd267ac67eebabca42185362bee6c4fbd719
'http://deb.debian.org/debian/pool/main/k/krb5/krb5_1.18.3.orig.tar.gz.asc' krb5_1.18.3.orig.tar.gz.asc 833 SHA256:ded19808ba7320ad0bb3ddfb5202845b2ff36a50613af7832f78dd3cb4437419
'http://deb.debian.org/debian/pool/main/k/krb5/krb5_1.18.3-6%2bdeb11u5.debian.tar.xz' krb5_1.18.3-6+deb11u5.debian.tar.xz 114964 SHA256:6ba4b7db260cfdefb743a10b0a6a113c2302f1000812095563c5607ba9e0201a
```

Other potentially useful URLs:

- https://sources.debian.net/src/krb5/1.18.3-6+deb11u5/ (for browsing the source)
- https://sources.debian.net/src/krb5/1.18.3-6+deb11u5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/krb5/1.18.3-6+deb11u5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `lcms2=2.12~rc1-2`

Binary Packages:

- `liblcms2-2:amd64=2.12~rc1-2`

Licenses: (parsed from: `/usr/share/doc/liblcms2-2/copyright`)

- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3 (GPL-3 for the fast_float plugin only)`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris lcms2=2.12~rc1-2
'http://deb.debian.org/debian/pool/main/l/lcms2/lcms2_2.12%7erc1-2.dsc' lcms2_2.12~rc1-2.dsc 1988 SHA256:57b0b3cde709d8b7c43b195ba7f628d2d79323ee0db883050f253ee9f9acd48a
'http://deb.debian.org/debian/pool/main/l/lcms2/lcms2_2.12%7erc1.orig.tar.gz' lcms2_2.12~rc1.orig.tar.gz 7417767 SHA256:3300ddd8c51d60ebcc206d20d185b1b19939c4cec1576d1f5b95297b0fbdfe19
'http://deb.debian.org/debian/pool/main/l/lcms2/lcms2_2.12%7erc1-2.debian.tar.xz' lcms2_2.12~rc1-2.debian.tar.xz 10420 SHA256:dddb5b18a42fc7308e732f00643b29ac9f2638cf246569683cb50f13520c2cca
```

Other potentially useful URLs:

- https://sources.debian.net/src/lcms2/2.12~rc1-2/ (for browsing the source)
- https://sources.debian.net/src/lcms2/2.12~rc1-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/lcms2/2.12~rc1-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `less.js=3.13.0+dfsg-5`

Binary Packages:

- `node-less=3.13.0+dfsg-5`

Licenses: (parsed from: `/usr/share/doc/node-less/copyright`)

- `Apache-2.0`
- `Expat`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris less.js=3.13.0+dfsg-5
'http://deb.debian.org/debian/pool/main/l/less.js/less.js_3.13.0%2bdfsg-5.dsc' less.js_3.13.0+dfsg-5.dsc 2688 SHA256:8260f0280fcc973235975aa76f30544736166bdbc4b801e04d8e55745af3519f
'http://deb.debian.org/debian/pool/main/l/less.js/less.js_3.13.0%2bdfsg.orig-image-size.tar.xz' less.js_3.13.0+dfsg.orig-image-size.tar.xz 6580 SHA256:8c060b422ac39b37003b629da43464065c81dd606e7603b8106fe220d4e1e3c3
'http://deb.debian.org/debian/pool/main/l/less.js/less.js_3.13.0%2bdfsg.orig.tar.xz' less.js_3.13.0+dfsg.orig.tar.xz 576576 SHA256:c7cd878006d5eb45602a4f10d2ca58f65ab3049dc4473d46e04d8be2aec0005d
'http://deb.debian.org/debian/pool/main/l/less.js/less.js_3.13.0%2bdfsg-5.debian.tar.xz' less.js_3.13.0+dfsg-5.debian.tar.xz 12120 SHA256:a44c2ae52a4c599714ab00a7efa94e92e31da125f49c9e1c0cde75541763302c
```

Other potentially useful URLs:

- https://sources.debian.net/src/less.js/3.13.0+dfsg-5/ (for browsing the source)
- https://sources.debian.net/src/less.js/3.13.0+dfsg-5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/less.js/3.13.0+dfsg-5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libassuan=2.5.3-7.1`

Binary Packages:

- `libassuan0:amd64=2.5.3-7.1`

Licenses: (parsed from: `/usr/share/doc/libassuan0/copyright`)

- `GAP`
- `GAP~FSF`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with libtool exception`
- `GPL-3`
- `GPL-3+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `LGPL-3`
- `LGPL-3+`

Source:

```console
$ apt-get source -qq --print-uris libassuan=2.5.3-7.1
'http://deb.debian.org/debian/pool/main/liba/libassuan/libassuan_2.5.3-7.1.dsc' libassuan_2.5.3-7.1.dsc 2627 SHA256:9e4cfaef54fee1b6c1fd32fdfe6fc90b2dde78755517ee0ff56859e69251fb07
'http://deb.debian.org/debian/pool/main/liba/libassuan/libassuan_2.5.3.orig.tar.bz2' libassuan_2.5.3.orig.tar.bz2 572348 SHA256:91bcb0403866b4e7c4bc1cc52ed4c364a9b5414b3994f718c70303f7f765e702
'http://deb.debian.org/debian/pool/main/liba/libassuan/libassuan_2.5.3.orig.tar.bz2.asc' libassuan_2.5.3.orig.tar.bz2.asc 952 SHA256:53b16a6619a2690b4f22da645a1d0c14b5664825c87b165ca5bd0de32607888a
'http://deb.debian.org/debian/pool/main/liba/libassuan/libassuan_2.5.3-7.1.debian.tar.xz' libassuan_2.5.3-7.1.debian.tar.xz 13952 SHA256:c6783e12dc1fb65681c083274f52cb3286da18dcf8a5b38a6de10143003e0681
```

Other potentially useful URLs:

- https://sources.debian.net/src/libassuan/2.5.3-7.1/ (for browsing the source)
- https://sources.debian.net/src/libassuan/2.5.3-7.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libassuan/2.5.3-7.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libbsd=0.11.3-1+deb11u1`

Binary Packages:

- `libbsd0:amd64=0.11.3-1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libbsd0/copyright`)

- `BSD-2-clause`
- `BSD-2-clause-NetBSD`
- `BSD-2-clause-author`
- `BSD-2-clause-verbatim`
- `BSD-3-clause`
- `BSD-3-clause-John-Birrell`
- `BSD-3-clause-Regents`
- `BSD-3-clause-author`
- `BSD-4-clause-Christopher-G-Demetriou`
- `BSD-4-clause-Niels-Provos`
- `BSD-5-clause-Peter-Wemm`
- `Beerware`
- `Expat`
- `ISC`
- `ISC-Original`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris libbsd=0.11.3-1+deb11u1
'http://deb.debian.org/debian/pool/main/libb/libbsd/libbsd_0.11.3-1%2bdeb11u1.dsc' libbsd_0.11.3-1+deb11u1.dsc 2324 SHA256:c5c817a1c86a7821c76e6e73d54fd018de8b022a0177da670b90a4f8d8dfbfb0
'http://deb.debian.org/debian/pool/main/libb/libbsd/libbsd_0.11.3.orig.tar.xz' libbsd_0.11.3.orig.tar.xz 399712 SHA256:ff95cf8184151dacae4247832f8d4ea8800fa127dbd15033ecfe839f285b42a1
'http://deb.debian.org/debian/pool/main/libb/libbsd/libbsd_0.11.3.orig.tar.xz.asc' libbsd_0.11.3.orig.tar.xz.asc 833 SHA256:213f30c9537e2a180ebdad6445402ea879f83c3a85907f7509ae7f7304f7ce1b
'http://deb.debian.org/debian/pool/main/libb/libbsd/libbsd_0.11.3-1%2bdeb11u1.debian.tar.xz' libbsd_0.11.3-1+deb11u1.debian.tar.xz 17980 SHA256:9745c6b40e3d719da54ed3da6a266a5e6c58ff823e70ba87244a5cf9c44cb9b9
```

Other potentially useful URLs:

- https://sources.debian.net/src/libbsd/0.11.3-1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/libbsd/0.11.3-1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libbsd/0.11.3-1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libcap-ng=0.7.9-2.2`

Binary Packages:

- `libcap-ng0:amd64=0.7.9-2.2+b1`

Licenses: (parsed from: `/usr/share/doc/libcap-ng0/copyright`)

- `GPL-2`
- `GPL-3`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libcap-ng=0.7.9-2.2
'http://deb.debian.org/debian/pool/main/libc/libcap-ng/libcap-ng_0.7.9-2.2.dsc' libcap-ng_0.7.9-2.2.dsc 2081 SHA256:d573ce59d83d2c117515e7c57dde1c990e9c5a34e0f53ac09f6b4d3e153e9aae
'http://deb.debian.org/debian/pool/main/libc/libcap-ng/libcap-ng_0.7.9.orig.tar.gz' libcap-ng_0.7.9.orig.tar.gz 449038 SHA256:4a1532bcf3731aade40936f6d6a586ed5a66ca4c7455e1338d1f6c3e09221328
'http://deb.debian.org/debian/pool/main/libc/libcap-ng/libcap-ng_0.7.9-2.2.debian.tar.xz' libcap-ng_0.7.9-2.2.debian.tar.xz 6308 SHA256:6d7b5cfcf435fe996e5dc78770a9ab1ab614ced5bee56e3e0ba4e09d8c832a0a
```

Other potentially useful URLs:

- https://sources.debian.net/src/libcap-ng/0.7.9-2.2/ (for browsing the source)
- https://sources.debian.net/src/libcap-ng/0.7.9-2.2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libcap-ng/0.7.9-2.2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libdatrie=0.2.13-1`

Binary Packages:

- `libdatrie1:amd64=0.2.13-1`

Licenses: (parsed from: `/usr/share/doc/libdatrie1/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris libdatrie=0.2.13-1
'http://deb.debian.org/debian/pool/main/libd/libdatrie/libdatrie_0.2.13-1.dsc' libdatrie_0.2.13-1.dsc 2239 SHA256:a775d82ce3131d63c6dddca5df19ea8e72cd8941103239a66ec6902a12350783
'http://deb.debian.org/debian/pool/main/libd/libdatrie/libdatrie_0.2.13.orig.tar.xz' libdatrie_0.2.13.orig.tar.xz 314072 SHA256:12231bb2be2581a7f0fb9904092d24b0ed2a271a16835071ed97bed65267f4be
'http://deb.debian.org/debian/pool/main/libd/libdatrie/libdatrie_0.2.13-1.debian.tar.xz' libdatrie_0.2.13-1.debian.tar.xz 9404 SHA256:b77520311b09756f00bd2c4c1880d16a3ec424ca1454bfcc2da4efaa272df2fc
```

Other potentially useful URLs:

- https://sources.debian.net/src/libdatrie/0.2.13-1/ (for browsing the source)
- https://sources.debian.net/src/libdatrie/0.2.13-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libdatrie/0.2.13-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libdeflate=1.7-1`

Binary Packages:

- `libdeflate0:amd64=1.7-1`

Licenses: (parsed from: `/usr/share/doc/libdeflate0/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris libdeflate=1.7-1
'http://deb.debian.org/debian/pool/main/libd/libdeflate/libdeflate_1.7-1.dsc' libdeflate_1.7-1.dsc 2163 SHA256:9f81571abf95f084dd6ce5c5f2b78ce66e5b1c7e2ec0f86e539f9df572061cd6
'http://deb.debian.org/debian/pool/main/libd/libdeflate/libdeflate_1.7.orig.tar.gz' libdeflate_1.7.orig.tar.gz 144143 SHA256:a5e6a0a9ab69f40f0f59332106532ca76918977a974e7004977a9498e3f11350
'http://deb.debian.org/debian/pool/main/libd/libdeflate/libdeflate_1.7-1.debian.tar.xz' libdeflate_1.7-1.debian.tar.xz 4392 SHA256:42a4f9b2307b0349fb2cd51a9585564284f480b03fa06c3f03ca02987ca66fb2
```

Other potentially useful URLs:

- https://sources.debian.net/src/libdeflate/1.7-1/ (for browsing the source)
- https://sources.debian.net/src/libdeflate/1.7-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libdeflate/1.7-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libev=1:4.33-1`

Binary Packages:

- `libev4:amd64=1:4.33-1`

Licenses: (parsed from: `/usr/share/doc/libev4/copyright`)

- `BSD-2-clause`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris libev=1:4.33-1
'http://deb.debian.org/debian/pool/main/libe/libev/libev_4.33-1.dsc' libev_4.33-1.dsc 1963 SHA256:5193ae6b2c2cd925f43ea1b1431f32a17f2fd94509743e0c8c05bb8d4c269521
'http://deb.debian.org/debian/pool/main/libe/libev/libev_4.33.orig.tar.gz' libev_4.33.orig.tar.gz 569527 SHA256:507eb7b8d1015fbec5b935f34ebed15bf346bed04a11ab82b8eee848c4205aea
'http://deb.debian.org/debian/pool/main/libe/libev/libev_4.33-1.debian.tar.xz' libev_4.33-1.debian.tar.xz 5140 SHA256:3e1ee9d9427b936f46a17e2ff41c60c30f8cb642b5abfe927ee92f9da197c0b0
```

Other potentially useful URLs:

- https://sources.debian.net/src/libev/1:4.33-1/ (for browsing the source)
- https://sources.debian.net/src/libev/1:4.33-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libev/1:4.33-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libffi=3.3-6`

Binary Packages:

- `libffi7:amd64=3.3-6`

Licenses: (parsed from: `/usr/share/doc/libffi7/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris libffi=3.3-6
'http://deb.debian.org/debian/pool/main/libf/libffi/libffi_3.3-6.dsc' libffi_3.3-6.dsc 1934 SHA256:cb5dcd6b54e0c8c7db4cd97deef68ac9e2ede49138ca5db194b60338eae8dd65
'http://deb.debian.org/debian/pool/main/libf/libffi/libffi_3.3.orig.tar.gz' libffi_3.3.orig.tar.gz 1305466 SHA256:72fba7922703ddfa7a028d513ac15a85c8d54c8d67f55fa5a4802885dc652056
'http://deb.debian.org/debian/pool/main/libf/libffi/libffi_3.3-6.debian.tar.xz' libffi_3.3-6.debian.tar.xz 9168 SHA256:d15879289f32acf2afbbcc6ccf6e0c1aa306f6f06abb8b0301bfa41bffea9a55
```

Other potentially useful URLs:

- https://sources.debian.net/src/libffi/3.3-6/ (for browsing the source)
- https://sources.debian.net/src/libffi/3.3-6/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libffi/3.3-6/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libfontenc=1:1.1.4-1`

Binary Packages:

- `libfontenc1:amd64=1:1.1.4-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libfontenc=1:1.1.4-1
'http://deb.debian.org/debian/pool/main/libf/libfontenc/libfontenc_1.1.4-1.dsc' libfontenc_1.1.4-1.dsc 2288 SHA256:bdefcb46e965a85d1861395bda9573b1f7290a166c909a2e7bddd816c9dfa5c3
'http://deb.debian.org/debian/pool/main/libf/libfontenc/libfontenc_1.1.4.orig.tar.gz' libfontenc_1.1.4.orig.tar.gz 389706 SHA256:895ee0986b32fbfcda7f4f25ef6cbacfa760e1690bf59f02085ce0e7d1eebb41
'http://deb.debian.org/debian/pool/main/libf/libfontenc/libfontenc_1.1.4.orig.tar.gz.asc' libfontenc_1.1.4.orig.tar.gz.asc 801 SHA256:a905eb0ca34053e48a14dcdf20f08e05232f1b208adc4250268db0d82e66d48d
'http://deb.debian.org/debian/pool/main/libf/libfontenc/libfontenc_1.1.4-1.diff.gz' libfontenc_1.1.4-1.diff.gz 9105 SHA256:bd72904c30fbdc6fb250305bc3c19c848e261fdd5c10d88d1a33807d7716c8ac
```

Other potentially useful URLs:

- https://sources.debian.net/src/libfontenc/1:1.1.4-1/ (for browsing the source)
- https://sources.debian.net/src/libfontenc/1:1.1.4-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libfontenc/1:1.1.4-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libgcrypt20=1.8.7-6`

Binary Packages:

- `libgcrypt20:amd64=1.8.7-6`

Licenses: (parsed from: `/usr/share/doc/libgcrypt20/copyright`)

- `GPL-2`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris libgcrypt20=1.8.7-6
'http://deb.debian.org/debian/pool/main/libg/libgcrypt20/libgcrypt20_1.8.7-6.dsc' libgcrypt20_1.8.7-6.dsc 2800 SHA256:af433c97fde6172bb51d458e66acd33c66052bdf78ad72f7034f0b1851015959
'http://deb.debian.org/debian/pool/main/libg/libgcrypt20/libgcrypt20_1.8.7.orig.tar.bz2' libgcrypt20_1.8.7.orig.tar.bz2 2985660 SHA256:03b70f028299561b7034b8966d7dd77ef16ed139c43440925fe8782561974748
'http://deb.debian.org/debian/pool/main/libg/libgcrypt20/libgcrypt20_1.8.7.orig.tar.bz2.asc' libgcrypt20_1.8.7.orig.tar.bz2.asc 228 SHA256:eed6bb4174433640a02c1dc8851f34f85ec55b43d76a24bec87d7175784ef614
'http://deb.debian.org/debian/pool/main/libg/libgcrypt20/libgcrypt20_1.8.7-6.debian.tar.xz' libgcrypt20_1.8.7-6.debian.tar.xz 37564 SHA256:3fe8290b67416579fc99648ba025b8de732c4cc541b60b5f96f53d42a38916f5
```

Other potentially useful URLs:

- https://sources.debian.net/src/libgcrypt20/1.8.7-6/ (for browsing the source)
- https://sources.debian.net/src/libgcrypt20/1.8.7-6/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libgcrypt20/1.8.7-6/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libgd2=2.3.0-2`

Binary Packages:

- `libgd3:amd64=2.3.0-2`

Licenses: (parsed from: `/usr/share/doc/libgd3/copyright`)

- `BSD-3-clause`
- `GAP~Makefile.in`
- `GAP~configure`
- `GD`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with Autoconf exception`
- `HPND`
- `MIT`
- `WEBP`
- `XFIG`

Source:

```console
$ apt-get source -qq --print-uris libgd2=2.3.0-2
'http://deb.debian.org/debian/pool/main/libg/libgd2/libgd2_2.3.0-2.dsc' libgd2_2.3.0-2.dsc 2341 SHA256:3b4a75dcf1b8a5c6aed2c1e37aeb542e419dbf567c85deeb1bf3d1375f05a44e
'http://deb.debian.org/debian/pool/main/libg/libgd2/libgd2_2.3.0.orig.tar.gz' libgd2_2.3.0.orig.tar.gz 3102749 SHA256:32590e361a1ea6c93915d2448ab0041792c11bae7b18ee812514fe08b2c6a342
'http://deb.debian.org/debian/pool/main/libg/libgd2/libgd2_2.3.0-2.debian.tar.xz' libgd2_2.3.0-2.debian.tar.xz 33124 SHA256:65559fe745c036d281a706a8dced1212eccf9a7d6170e3b3bf1a7fdb41c00ca3
```

Other potentially useful URLs:

- https://sources.debian.net/src/libgd2/2.3.0-2/ (for browsing the source)
- https://sources.debian.net/src/libgd2/2.3.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libgd2/2.3.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libgpg-error=1.38-2`

Binary Packages:

- `libgpg-error0:amd64=1.38-2`

Licenses: (parsed from: `/usr/share/doc/libgpg-error0/copyright`)

- `BSD-3-clause`
- `GPL-3`
- `GPL-3+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `g10-permissive`

Source:

```console
$ apt-get source -qq --print-uris libgpg-error=1.38-2
'http://deb.debian.org/debian/pool/main/libg/libgpg-error/libgpg-error_1.38-2.dsc' libgpg-error_1.38-2.dsc 2220 SHA256:ab0ea76aa3552afa664210a871abc74637acafd89c068edf8dc03521b8e22d64
'http://deb.debian.org/debian/pool/main/libg/libgpg-error/libgpg-error_1.38.orig.tar.bz2' libgpg-error_1.38.orig.tar.bz2 957637 SHA256:d8988275aa69d7149f931c10442e9e34c0242674249e171592b430ff7b3afd02
'http://deb.debian.org/debian/pool/main/libg/libgpg-error/libgpg-error_1.38.orig.tar.bz2.asc' libgpg-error_1.38.orig.tar.bz2.asc 488 SHA256:d80eb927d85e19e96d8de17552f8f48b517ae7acac7685404e8027475c5b4330
'http://deb.debian.org/debian/pool/main/libg/libgpg-error/libgpg-error_1.38-2.debian.tar.xz' libgpg-error_1.38-2.debian.tar.xz 19544 SHA256:824bcb278ead676c20f174bd551b1cc44a294137fabe6a1d892667882f3b4ba2
```

Other potentially useful URLs:

- https://sources.debian.net/src/libgpg-error/1.38-2/ (for browsing the source)
- https://sources.debian.net/src/libgpg-error/1.38-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libgpg-error/1.38-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libice=2:1.0.10-1`

Binary Packages:

- `libice6:amd64=2:1.0.10-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libice=2:1.0.10-1
'http://deb.debian.org/debian/pool/main/libi/libice/libice_1.0.10-1.dsc' libice_1.0.10-1.dsc 2049 SHA256:adb7b4e250db838a476a44b5a941c8f935ac2b20858186f09228cd3e0696034d
'http://deb.debian.org/debian/pool/main/libi/libice/libice_1.0.10.orig.tar.gz' libice_1.0.10.orig.tar.gz 481960 SHA256:1116bc64c772fd127a0d0c0ffa2833479905e3d3d8197740b3abd5f292f22d2d
'http://deb.debian.org/debian/pool/main/libi/libice/libice_1.0.10-1.diff.gz' libice_1.0.10-1.diff.gz 11349 SHA256:d186b3877416a7e80f1923fe2fc736d576e585a41450bcf4cd5e74f9dd099362
```

Other potentially useful URLs:

- https://sources.debian.net/src/libice/2:1.0.10-1/ (for browsing the source)
- https://sources.debian.net/src/libice/2:1.0.10-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libice/2:1.0.10-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libidn2=2.3.0-5`

Binary Packages:

- `libidn2-0:amd64=2.3.0-5`

Licenses: (parsed from: `/usr/share/doc/libidn2-0/copyright`)

- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `LGPL-3`
- `LGPL-3+`
- `Unicode`

Source:

```console
$ apt-get source -qq --print-uris libidn2=2.3.0-5
'http://deb.debian.org/debian/pool/main/libi/libidn2/libidn2_2.3.0-5.dsc' libidn2_2.3.0-5.dsc 2046 SHA256:f8a787741b2395fe87c2773252e539bcc068fde0a5367316082cbbd2fed2be16
'http://deb.debian.org/debian/pool/main/libi/libidn2/libidn2_2.3.0.orig.tar.gz' libidn2_2.3.0.orig.tar.gz 2164993 SHA256:e1cb1db3d2e249a6a3eb6f0946777c2e892d5c5dc7bd91c74394fc3a01cab8b5
'http://deb.debian.org/debian/pool/main/libi/libidn2/libidn2_2.3.0-5.debian.tar.xz' libidn2_2.3.0-5.debian.tar.xz 11276 SHA256:e061b97d035e374bc6a948a514c26ad7d1bda31c8147cc8db02e604c82865a15
```

Other potentially useful URLs:

- https://sources.debian.net/src/libidn2/2.3.0-5/ (for browsing the source)
- https://sources.debian.net/src/libidn2/2.3.0-5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libidn2/2.3.0-5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libimagequant=2.12.2-1.1`

Binary Packages:

- `libimagequant0:amd64=2.12.2-1.1`

Licenses: (parsed from: `/usr/share/doc/libimagequant0/copyright`)

- `CC0`
- `GPL-3`
- `GPL-3.0+`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris libimagequant=2.12.2-1.1
'http://deb.debian.org/debian/pool/main/libi/libimagequant/libimagequant_2.12.2-1.1.dsc' libimagequant_2.12.2-1.1.dsc 2139 SHA256:5a0a4fbdf96910eb5df9481d67c7cf98906ca31adb228ccc33046e5b6bb7b782
'http://deb.debian.org/debian/pool/main/libi/libimagequant/libimagequant_2.12.2.orig.tar.gz' libimagequant_2.12.2.orig.tar.gz 75611 SHA256:23ccecb4898ec17474914cfd2fbc4684425f7fd249117f2f1e3f3ba0bf8159e6
'http://deb.debian.org/debian/pool/main/libi/libimagequant/libimagequant_2.12.2-1.1.debian.tar.xz' libimagequant_2.12.2-1.1.debian.tar.xz 2712 SHA256:a86d06e81e925255f0d73b3942f8a3fcf3d880cc0a3dc903ed8ffb39a91c2fd6
```

Other potentially useful URLs:

- https://sources.debian.net/src/libimagequant/2.12.2-1.1/ (for browsing the source)
- https://sources.debian.net/src/libimagequant/2.12.2-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libimagequant/2.12.2-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libjpeg-turbo=1:2.0.6-4`

Binary Packages:

- `libjpeg62-turbo:amd64=1:2.0.6-4`

Licenses: (parsed from: `/usr/share/doc/libjpeg62-turbo/copyright`)

- `BSD-3`
- `BSD-BY-LC-NE`
- `Expat`
- `NTP`
- `zlib`

Source:

```console
$ apt-get source -qq --print-uris libjpeg-turbo=1:2.0.6-4
'http://deb.debian.org/debian/pool/main/libj/libjpeg-turbo/libjpeg-turbo_2.0.6-4.dsc' libjpeg-turbo_2.0.6-4.dsc 2580 SHA256:fd357f8d1469236ad1f630c185a8af0f76f68c99cd082360148597a479148866
'http://deb.debian.org/debian/pool/main/libj/libjpeg-turbo/libjpeg-turbo_2.0.6.orig.tar.gz' libjpeg-turbo_2.0.6.orig.tar.gz 2192315 SHA256:d74b92ac33b0e3657123ddcf6728788c90dc84dcb6a52013d758af3c4af481bb
'http://deb.debian.org/debian/pool/main/libj/libjpeg-turbo/libjpeg-turbo_2.0.6.orig.tar.gz.asc' libjpeg-turbo_2.0.6.orig.tar.gz.asc 793 SHA256:ab2d95f62c2f25b39823c2b0ee3d72979786f5c310c19943a74eed8c2abc7b4b
'http://deb.debian.org/debian/pool/main/libj/libjpeg-turbo/libjpeg-turbo_2.0.6-4.debian.tar.xz' libjpeg-turbo_2.0.6-4.debian.tar.xz 100860 SHA256:31765ab6f069c8e1f11c0e43fd984dd903506b8eef8b810c06c3f80c796a144c
```

Other potentially useful URLs:

- https://sources.debian.net/src/libjpeg-turbo/1:2.0.6-4/ (for browsing the source)
- https://sources.debian.net/src/libjpeg-turbo/1:2.0.6-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libjpeg-turbo/1:2.0.6-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libksba=1.5.0-3+deb11u2`

Binary Packages:

- `libksba8:amd64=1.5.0-3+deb11u2`

Licenses: (parsed from: `/usr/share/doc/libksba8/copyright`)

- `FSFUL`
- `GPL-3`
- `LGPL-2.1-or-later`

Source:

```console
$ apt-get source -qq --print-uris libksba=1.5.0-3+deb11u2
'http://deb.debian.org/debian/pool/main/libk/libksba/libksba_1.5.0-3%2bdeb11u2.dsc' libksba_1.5.0-3+deb11u2.dsc 2255 SHA256:acf88e1fab76405a18e0b85753ae1a6d2b68d0634711b9f24f03f7ab77b7263a
'http://deb.debian.org/debian/pool/main/libk/libksba/libksba_1.5.0.orig.tar.bz2' libksba_1.5.0.orig.tar.bz2 656518 SHA256:ae4af129216b2d7fdea0b5bf2a788cd458a79c983bb09a43f4d525cc87aba0ba
'http://deb.debian.org/debian/pool/main/libk/libksba/libksba_1.5.0-3%2bdeb11u2.debian.tar.xz' libksba_1.5.0-3+deb11u2.debian.tar.xz 15672 SHA256:556d4370f91d73a2152c5a1979d792ed8a82de52c37b5c8cc5e5da8464bd6eed
```

Other potentially useful URLs:

- https://sources.debian.net/src/libksba/1.5.0-3+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/libksba/1.5.0-3+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libksba/1.5.0-3+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libmd=1.0.3-3`

Binary Packages:

- `libmd0:amd64=1.0.3-3`

Licenses: (parsed from: `/usr/share/doc/libmd0/copyright`)

- `BSD-2-clause`
- `BSD-2-clause-NetBSD`
- `BSD-3-clause`
- `BSD-3-clause-Aaron-D-Gifford`
- `Beerware`
- `ISC`
- `public-domain-md4`
- `public-domain-md5`
- `public-domain-sha1`

Source:

```console
$ apt-get source -qq --print-uris libmd=1.0.3-3
'http://deb.debian.org/debian/pool/main/libm/libmd/libmd_1.0.3-3.dsc' libmd_1.0.3-3.dsc 2248 SHA256:c3be656dc94c906898358e1d27394e1aec1769a0b5e09e8a4e8cace735ce9967
'http://deb.debian.org/debian/pool/main/libm/libmd/libmd_1.0.3.orig.tar.xz' libmd_1.0.3.orig.tar.xz 258584 SHA256:5a02097f95cc250a3f1001865e4dbba5f1d15554120f95693c0541923c52af4a
'http://deb.debian.org/debian/pool/main/libm/libmd/libmd_1.0.3.orig.tar.xz.asc' libmd_1.0.3.orig.tar.xz.asc 833 SHA256:690c82c27026093e0367b24de5f786b29f6cedacbae67bad3199190689940d3d
'http://deb.debian.org/debian/pool/main/libm/libmd/libmd_1.0.3-3.debian.tar.xz' libmd_1.0.3-3.debian.tar.xz 10104 SHA256:90f09c473c5ff61e3d937c656f12470610cc731cf9061490f651293d04f3c385
```

Other potentially useful URLs:

- https://sources.debian.net/src/libmd/1.0.3-3/ (for browsing the source)
- https://sources.debian.net/src/libmd/1.0.3-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libmd/1.0.3-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libnsl=1.3.0-2`

Binary Packages:

- `libnsl2:amd64=1.3.0-2`

Licenses: (parsed from: `/usr/share/doc/libnsl2/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2+-autoconf-exception`
- `GPL-2+-libtool-exception`
- `GPL-3`
- `GPL-3+-autoconf-exception`
- `LGPL-2.1`
- `LGPL-2.1+`
- `MIT`
- `permissive-autoconf-m4`
- `permissive-autoconf-m4-no-warranty`
- `permissive-configure`
- `permissive-fsf`
- `permissive-makefile-in`

Source:

```console
$ apt-get source -qq --print-uris libnsl=1.3.0-2
'http://deb.debian.org/debian/pool/main/libn/libnsl/libnsl_1.3.0-2.dsc' libnsl_1.3.0-2.dsc 1955 SHA256:1da570eed6693c774cce51f3c33f989d1aa4bf1dcb8660818d8a834a1a3728ef
'http://deb.debian.org/debian/pool/main/libn/libnsl/libnsl_1.3.0.orig.tar.xz' libnsl_1.3.0.orig.tar.xz 321488 SHA256:eac3062957fa302c62eff4aed718a07bacbf9ceb0a058289f12a19bfdda3c8e2
'http://deb.debian.org/debian/pool/main/libn/libnsl/libnsl_1.3.0-2.debian.tar.xz' libnsl_1.3.0-2.debian.tar.xz 4692 SHA256:7f8dccc706931b9e206448ffb475487a4a0abaded27cf611d418f4a34415dca7
```

Other potentially useful URLs:

- https://sources.debian.net/src/libnsl/1.3.0-2/ (for browsing the source)
- https://sources.debian.net/src/libnsl/1.3.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libnsl/1.3.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libpng1.6=1.6.37-3`

Binary Packages:

- `libpng16-16:amd64=1.6.37-3`

Licenses: (parsed from: `/usr/share/doc/libpng16-16/copyright`)

- `Apache-2.0`
- `BSD-3-clause`
- `BSD-like-with-advertising-clause`
- `GPL-2`
- `GPL-2+`
- `expat`
- `libpng`
- `libpng OR Apache-2.0 OR BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris libpng1.6=1.6.37-3
'http://deb.debian.org/debian/pool/main/libp/libpng1.6/libpng1.6_1.6.37-3.dsc' libpng1.6_1.6.37-3.dsc 2225 SHA256:d6fac534b155e680849e700e4d2c87314e0ff20ab1b89fc22f1dfd2c24c1727b
'http://deb.debian.org/debian/pool/main/libp/libpng1.6/libpng1.6_1.6.37.orig.tar.gz' libpng1.6_1.6.37.orig.tar.gz 1508805 SHA256:ca74a0dace179a8422187671aee97dd3892b53e168627145271cad5b5ac81307
'http://deb.debian.org/debian/pool/main/libp/libpng1.6/libpng1.6_1.6.37-3.debian.tar.xz' libpng1.6_1.6.37-3.debian.tar.xz 32272 SHA256:d28b11e41dba39c53d8d87be5f70cc96a246f296307855f55d86db03b24680d4
```

Other potentially useful URLs:

- https://sources.debian.net/src/libpng1.6/1.6.37-3/ (for browsing the source)
- https://sources.debian.net/src/libpng1.6/1.6.37-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libpng1.6/1.6.37-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libpsl=0.21.0-1.2`

Binary Packages:

- `libpsl5:amd64=0.21.0-1.2`

Licenses: (parsed from: `/usr/share/doc/libpsl5/copyright`)

- `Chromium`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris libpsl=0.21.0-1.2
'http://deb.debian.org/debian/pool/main/libp/libpsl/libpsl_0.21.0-1.2.dsc' libpsl_0.21.0-1.2.dsc 2216 SHA256:d46b69dd1cb43dc48375d70c4895d0a0d5964131196a7de4e0ad1ea2912d6df4
'http://deb.debian.org/debian/pool/main/libp/libpsl/libpsl_0.21.0.orig.tar.gz' libpsl_0.21.0.orig.tar.gz 8598583 SHA256:055aa87ec166c7afb985d0816c07ff440e1eb899881a318c51c69a0aeea8e279
'http://deb.debian.org/debian/pool/main/libp/libpsl/libpsl_0.21.0-1.2.debian.tar.xz' libpsl_0.21.0-1.2.debian.tar.xz 12724 SHA256:012d3b6ec5634c59e6a4aa9f854d756ef23f08edf21d70ae5a888c55e95abd5d
```

Other potentially useful URLs:

- https://sources.debian.net/src/libpsl/0.21.0-1.2/ (for browsing the source)
- https://sources.debian.net/src/libpsl/0.21.0-1.2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libpsl/0.21.0-1.2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libsass-python=0.20.1-3`

Binary Packages:

- `python3-libsass=0.20.1-3`

Licenses: (parsed from: `/usr/share/doc/python3-libsass/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris libsass-python=0.20.1-3
'http://deb.debian.org/debian/pool/main/libs/libsass-python/libsass-python_0.20.1-3.dsc' libsass-python_0.20.1-3.dsc 2182 SHA256:7f3aacec214f423fe58a641038b8c14d88ae0ca4c3a9709b76bd2ec43bc27315
'http://deb.debian.org/debian/pool/main/libs/libsass-python/libsass-python_0.20.1.orig.tar.gz' libsass-python_0.20.1.orig.tar.gz 55649 SHA256:00e5fc8d1befd02c687fc1bed43865a813d21d4ef8bf99d14849420b81de2e3e
'http://deb.debian.org/debian/pool/main/libs/libsass-python/libsass-python_0.20.1-3.debian.tar.xz' libsass-python_0.20.1-3.debian.tar.xz 5440 SHA256:61e3137bffdd39df96faa956f6e6001a37763241141edad374f65f4fc36eb150
```

Other potentially useful URLs:

- https://sources.debian.net/src/libsass-python/0.20.1-3/ (for browsing the source)
- https://sources.debian.net/src/libsass-python/0.20.1-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libsass-python/0.20.1-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libsass=3.6.4+20201122-1`

Binary Packages:

- `libsass1:amd64=3.6.4+20201122-1`

Licenses: (parsed from: `/usr/share/doc/libsass1/copyright`)

- `BSL-1.0`
- `Expat`
- `FSFUL~Boost`
- `GPL-2`
- `GPL-2+ with Autoconf exception`
- `GPL-3`
- `GPL-3+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris libsass=3.6.4+20201122-1
'http://deb.debian.org/debian/pool/main/libs/libsass/libsass_3.6.4%2b20201122-1.dsc' libsass_3.6.4+20201122-1.dsc 2111 SHA256:377cb79209f414d7a17f9a9462bb889ef44ef8493a39e267ef64dd17d18d491a
'http://deb.debian.org/debian/pool/main/libs/libsass/libsass_3.6.4%2b20201122.orig.tar.xz' libsass_3.6.4+20201122.orig.tar.xz 264916 SHA256:4bf09fb9da6b5f28ebc8ceaa831c5d87dca69e168d53b14329dee4ce12b961a7
'http://deb.debian.org/debian/pool/main/libs/libsass/libsass_3.6.4%2b20201122-1.debian.tar.xz' libsass_3.6.4+20201122-1.debian.tar.xz 43456 SHA256:6799b607ef83f2d1b8294fd5b4d42710d72aa40e55bb15d502cd3a403deb2ad8
```

Other potentially useful URLs:

- https://sources.debian.net/src/libsass/3.6.4+20201122-1/ (for browsing the source)
- https://sources.debian.net/src/libsass/3.6.4+20201122-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libsass/3.6.4+20201122-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libseccomp=2.5.1-1+deb11u1`

Binary Packages:

- `libseccomp2:amd64=2.5.1-1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libseccomp2/copyright`)

- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libseccomp=2.5.1-1+deb11u1
'http://deb.debian.org/debian/pool/main/libs/libseccomp/libseccomp_2.5.1-1%2bdeb11u1.dsc' libseccomp_2.5.1-1+deb11u1.dsc 2708 SHA256:6a2a00eb5f45e794a2203805348a3990d46f4ded63f8708d3382994ece729436
'http://deb.debian.org/debian/pool/main/libs/libseccomp/libseccomp_2.5.1.orig.tar.gz' libseccomp_2.5.1.orig.tar.gz 638811 SHA256:ee307e383c77aa7995abc5ada544d51c9723ae399768a97667d4cdb3c3a30d55
'http://deb.debian.org/debian/pool/main/libs/libseccomp/libseccomp_2.5.1.orig.tar.gz.asc' libseccomp_2.5.1.orig.tar.gz.asc 833 SHA256:14d45c86e5ceed5ac5511c3ebf70a4dca128b7584b314dc8a551c779ea225d2e
'http://deb.debian.org/debian/pool/main/libs/libseccomp/libseccomp_2.5.1-1%2bdeb11u1.debian.tar.xz' libseccomp_2.5.1-1+deb11u1.debian.tar.xz 19524 SHA256:a09ef7c0b9b6464f426b78a7b978d8566da53667c1a234234ffd2cc600543200
```

Other potentially useful URLs:

- https://sources.debian.net/src/libseccomp/2.5.1-1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/libseccomp/2.5.1-1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libseccomp/2.5.1-1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libselinux=3.1-3`

Binary Packages:

- `libselinux1:amd64=3.1-3`

Licenses: (parsed from: `/usr/share/doc/libselinux1/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libselinux=3.1-3
'http://deb.debian.org/debian/pool/main/libs/libselinux/libselinux_3.1-3.dsc' libselinux_3.1-3.dsc 2300 SHA256:42810484f3776af09a2e0ab726e3be877fc8a54d6bf51702e46c22f945ab5177
'http://deb.debian.org/debian/pool/main/libs/libselinux/libselinux_3.1.orig.tar.gz' libselinux_3.1.orig.tar.gz 204703 SHA256:ea5dcbb4d859e3f999c26a13c630da2f16dff9462e3cc8cb7b458ac157d112e7
'http://deb.debian.org/debian/pool/main/libs/libselinux/libselinux_3.1-3.debian.tar.xz' libselinux_3.1-3.debian.tar.xz 24176 SHA256:7170ab6914f0d2e93de169da312df961f799f5d58cc0a4c552e3f8a7882f3c81
```

Other potentially useful URLs:

- https://sources.debian.net/src/libselinux/3.1-3/ (for browsing the source)
- https://sources.debian.net/src/libselinux/3.1-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libselinux/3.1-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libsemanage=3.1-1`

Binary Packages:

- `libsemanage-common=3.1-1`
- `libsemanage1:amd64=3.1-1+b2`

Licenses: (parsed from: `/usr/share/doc/libsemanage-common/copyright`, `/usr/share/doc/libsemanage1/copyright`)

- `GPL`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris libsemanage=3.1-1
'http://deb.debian.org/debian/pool/main/libs/libsemanage/libsemanage_3.1-1.dsc' libsemanage_3.1-1.dsc 2339 SHA256:d49f9c29d0ad9c8b42145e0926919df962b58823e9fc22002bbb00333276170d
'http://deb.debian.org/debian/pool/main/libs/libsemanage/libsemanage_3.1.orig.tar.gz' libsemanage_3.1.orig.tar.gz 179601 SHA256:22d6c75526e40d1781c30bcf29abf97171bdfe6780923f11c8e1c76a75a21ff8
'http://deb.debian.org/debian/pool/main/libs/libsemanage/libsemanage_3.1-1.debian.tar.xz' libsemanage_3.1-1.debian.tar.xz 17556 SHA256:185b151158faaaf3d8f9ff939f29efd3eb5dbb050d01a87d3fde6cf40e778648
```

Other potentially useful URLs:

- https://sources.debian.net/src/libsemanage/3.1-1/ (for browsing the source)
- https://sources.debian.net/src/libsemanage/3.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libsemanage/3.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libsepol=3.1-1`

Binary Packages:

- `libsepol1:amd64=3.1-1`

Licenses: (parsed from: `/usr/share/doc/libsepol1/copyright`)

- `GPL`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris libsepol=3.1-1
'http://deb.debian.org/debian/pool/main/libs/libsepol/libsepol_3.1-1.dsc' libsepol_3.1-1.dsc 1776 SHA256:37bfb6797af8a96eada6c6ace374292b8a16a6bfb557b1e8ab9fd29e72d5888a
'http://deb.debian.org/debian/pool/main/libs/libsepol/libsepol_3.1.orig.tar.gz' libsepol_3.1.orig.tar.gz 473842 SHA256:ae6778d01443fdd38cd30eeee846494e19f4d407b09872580372f4aa4bf8a3cc
'http://deb.debian.org/debian/pool/main/libs/libsepol/libsepol_3.1-1.debian.tar.xz' libsepol_3.1-1.debian.tar.xz 14584 SHA256:9351a0b6207f6a5da2951292d3ec5655feb89df5aabc9010094766d811156166
```

Other potentially useful URLs:

- https://sources.debian.net/src/libsepol/3.1-1/ (for browsing the source)
- https://sources.debian.net/src/libsepol/3.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libsepol/3.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libsm=2:1.2.3-1`

Binary Packages:

- `libsm6:amd64=2:1.2.3-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libsm=2:1.2.3-1
'http://deb.debian.org/debian/pool/main/libs/libsm/libsm_1.2.3-1.dsc' libsm_1.2.3-1.dsc 2063 SHA256:5488f8de81d53c32cbb5f062b6a6f262cd067283b8082041392dc60f0d04002c
'http://deb.debian.org/debian/pool/main/libs/libsm/libsm_1.2.3.orig.tar.gz' libsm_1.2.3.orig.tar.gz 445362 SHA256:1e92408417cb6c6c477a8a6104291001a40b3bb56a4a60608fdd9cd2c5a0f320
'http://deb.debian.org/debian/pool/main/libs/libsm/libsm_1.2.3-1.diff.gz' libsm_1.2.3-1.diff.gz 8929 SHA256:7eb99ab50b19f26d1470f89e4b46891f6a697cb1794a58ed0d1376cceaf1b6a9
```

Other potentially useful URLs:

- https://sources.debian.net/src/libsm/2:1.2.3-1/ (for browsing the source)
- https://sources.debian.net/src/libsm/2:1.2.3-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libsm/2:1.2.3-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libssh2=1.9.0-2+deb11u1`

Binary Packages:

- `libssh2-1:amd64=1.9.0-2+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libssh2-1/copyright`)

- `BSD3`

Source:

```console
$ apt-get source -qq --print-uris libssh2=1.9.0-2+deb11u1
'http://deb.debian.org/debian/pool/main/libs/libssh2/libssh2_1.9.0-2%2bdeb11u1.dsc' libssh2_1.9.0-2+deb11u1.dsc 2039 SHA256:d1927132489695d986ae2c5e3cda5d325aa2c5ab6b0572ebe2e1f39b5116b16b
'http://deb.debian.org/debian/pool/main/libs/libssh2/libssh2_1.9.0.orig.tar.gz' libssh2_1.9.0.orig.tar.gz 888551 SHA256:d5fb8bd563305fd1074dda90bd053fb2d29fc4bce048d182f96eaa466dfadafd
'http://deb.debian.org/debian/pool/main/libs/libssh2/libssh2_1.9.0-2%2bdeb11u1.debian.tar.xz' libssh2_1.9.0-2+deb11u1.debian.tar.xz 9356 SHA256:094bfb01c5f721ef20718c9e435edefeed98231e19bef848d48ea0b93ba1dc5b
```

Other potentially useful URLs:

- https://sources.debian.net/src/libssh2/1.9.0-2+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/libssh2/1.9.0-2+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libssh2/1.9.0-2+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libtasn1-6=4.16.0-2+deb11u1`

Binary Packages:

- `libtasn1-6:amd64=4.16.0-2+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libtasn1-6/copyright`)

- `GFDL-1.3`
- `GPL-3`
- `LGPL`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libtasn1-6=4.16.0-2+deb11u1
'http://deb.debian.org/debian/pool/main/libt/libtasn1-6/libtasn1-6_4.16.0-2%2bdeb11u1.dsc' libtasn1-6_4.16.0-2+deb11u1.dsc 2618 SHA256:795155e19208ef5cf07534cd0fc0664b6144f94c16eec03d80fdee7a14f838b8
'http://deb.debian.org/debian/pool/main/libt/libtasn1-6/libtasn1-6_4.16.0.orig.tar.gz' libtasn1-6_4.16.0.orig.tar.gz 1812442 SHA256:0e0fb0903839117cb6e3b56e68222771bebf22ad7fc2295a0ed7d576e8d4329d
'http://deb.debian.org/debian/pool/main/libt/libtasn1-6/libtasn1-6_4.16.0.orig.tar.gz.asc' libtasn1-6_4.16.0.orig.tar.gz.asc 488 SHA256:06c201e8c3b43c27465ed79294d4c4ec8dcd3e95e4a6176ecbf273229ee3e2d0
'http://deb.debian.org/debian/pool/main/libt/libtasn1-6/libtasn1-6_4.16.0-2%2bdeb11u1.debian.tar.xz' libtasn1-6_4.16.0-2+deb11u1.debian.tar.xz 18324 SHA256:85198cc8eac7ecf5dc8bf220b0973c4ccd6c039217240fbf45ffe49860aacdd1
```

Other potentially useful URLs:

- https://sources.debian.net/src/libtasn1-6/4.16.0-2+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/libtasn1-6/4.16.0-2+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libtasn1-6/4.16.0-2+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libthai=0.1.28-3`

Binary Packages:

- `libthai-data=0.1.28-3`
- `libthai0:amd64=0.1.28-3`

Licenses: (parsed from: `/usr/share/doc/libthai-data/copyright`, `/usr/share/doc/libthai0/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris libthai=0.1.28-3
'http://deb.debian.org/debian/pool/main/libt/libthai/libthai_0.1.28-3.dsc' libthai_0.1.28-3.dsc 2346 SHA256:a6317b6a8e4ba40cedb10a9a659fc23885bfbe5eb8cf3a8b325a86064b0a542d
'http://deb.debian.org/debian/pool/main/libt/libthai/libthai_0.1.28.orig.tar.xz' libthai_0.1.28.orig.tar.xz 413592 SHA256:ffe0a17b4b5aa11b153c15986800eca19f6c93a4025ffa5cf2cab2dcdf1ae911
'http://deb.debian.org/debian/pool/main/libt/libthai/libthai_0.1.28-3.debian.tar.xz' libthai_0.1.28-3.debian.tar.xz 12128 SHA256:bca48abd9d040e844ebcb1f91a6ab4bcdfad66e36c1143f79d60461e933fddf9
```

Other potentially useful URLs:

- https://sources.debian.net/src/libthai/0.1.28-3/ (for browsing the source)
- https://sources.debian.net/src/libthai/0.1.28-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libthai/0.1.28-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libtirpc=1.3.1-1+deb11u1`

Binary Packages:

- `libtirpc-common=1.3.1-1+deb11u1`
- `libtirpc3:amd64=1.3.1-1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libtirpc-common/copyright`, `/usr/share/doc/libtirpc3/copyright`)

- `BSD-2-Clause`
- `BSD-3-Clause`
- `BSD-4-Clause`
- `GPL-2`
- `LGPL-2.1`
- `LGPL-2.1+`
- `PERMISSIVE`
- `__AUTO_PERMISSIVE__`

Source:

```console
$ apt-get source -qq --print-uris libtirpc=1.3.1-1+deb11u1
'http://deb.debian.org/debian/pool/main/libt/libtirpc/libtirpc_1.3.1-1%2bdeb11u1.dsc' libtirpc_1.3.1-1+deb11u1.dsc 2273 SHA256:f6c9103b9155e084cccc5a991e08678c9faad8a087c502cf8c8c552046c27847
'http://deb.debian.org/debian/pool/main/libt/libtirpc/libtirpc_1.3.1.orig.tar.bz2' libtirpc_1.3.1.orig.tar.bz2 513399 SHA256:245895caf066bec5e3d4375942c8cb4366adad184c29c618d97f724ea309ee17
'http://deb.debian.org/debian/pool/main/libt/libtirpc/libtirpc_1.3.1-1%2bdeb11u1.debian.tar.xz' libtirpc_1.3.1-1+deb11u1.debian.tar.xz 12752 SHA256:a0415b82adeba844372ca104e87376cd4c4bbb47e490925369e46e1c8f8750d4
```

Other potentially useful URLs:

- https://sources.debian.net/src/libtirpc/1.3.1-1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/libtirpc/1.3.1-1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libtirpc/1.3.1-1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libtool=2.4.6-15`

Binary Packages:

- `libltdl7:amd64=2.4.6-15`

Licenses: (parsed from: `/usr/share/doc/libltdl7/copyright`)

- `GFDL`
- `GPL`

Source:

```console
$ apt-get source -qq --print-uris libtool=2.4.6-15
'http://deb.debian.org/debian/pool/main/libt/libtool/libtool_2.4.6-15.dsc' libtool_2.4.6-15.dsc 2502 SHA256:c499bd88103239f5d9743c70fd9e84260b0237e43df47c44980ef4ac9ff5f8e0
'http://deb.debian.org/debian/pool/main/libt/libtool/libtool_2.4.6.orig.tar.xz' libtool_2.4.6.orig.tar.xz 973080 SHA256:7c87a8c2c8c0fc9cd5019e402bed4292462d00a718a7cd5f11218153bf28b26f
'http://deb.debian.org/debian/pool/main/libt/libtool/libtool_2.4.6.orig.tar.xz.asc' libtool_2.4.6.orig.tar.xz.asc 380 SHA256:ab68ebc45d60128a71fc36167cd29dcf3c3d6d639fd28663905ebaf3e2f43d6a
'http://deb.debian.org/debian/pool/main/libt/libtool/libtool_2.4.6-15.debian.tar.xz' libtool_2.4.6-15.debian.tar.xz 53924 SHA256:3955615804746d1440f2880f5cc0cd19e50dbaffe689afbec45dfcaaf5ee0d35
```

Other potentially useful URLs:

- https://sources.debian.net/src/libtool/2.4.6-15/ (for browsing the source)
- https://sources.debian.net/src/libtool/2.4.6-15/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libtool/2.4.6-15/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libunistring=0.9.10-4`

Binary Packages:

- `libunistring2:amd64=0.9.10-4`

Licenses: (parsed from: `/usr/share/doc/libunistring2/copyright`)

- `FreeSoftware`
- `GFDL-1.2`
- `GFDL-1.2+`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with distribution exception`
- `GPL-3`
- `GPL-3+`
- `LGPL-3`
- `LGPL-3+`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris libunistring=0.9.10-4
'http://deb.debian.org/debian/pool/main/libu/libunistring/libunistring_0.9.10-4.dsc' libunistring_0.9.10-4.dsc 2212 SHA256:5c7940807b538d4204506349cbd67e5c677afb9f0e46e94455353e3f746a481e
'http://deb.debian.org/debian/pool/main/libu/libunistring/libunistring_0.9.10.orig.tar.xz' libunistring_0.9.10.orig.tar.xz 2051320 SHA256:eb8fb2c3e4b6e2d336608377050892b54c3c983b646c561836550863003c05d7
'http://deb.debian.org/debian/pool/main/libu/libunistring/libunistring_0.9.10.orig.tar.xz.asc' libunistring_0.9.10.orig.tar.xz.asc 1310 SHA256:e1606f691034fa21b00e08269622743547c16d21cca6c8a64156b4774a49e78e
'http://deb.debian.org/debian/pool/main/libu/libunistring/libunistring_0.9.10-4.debian.tar.xz' libunistring_0.9.10-4.debian.tar.xz 40936 SHA256:6c9554e1a1c6d0a02ca4868a5422d176e57a3131c1a8a21de5503b164997525c
```

Other potentially useful URLs:

- https://sources.debian.net/src/libunistring/0.9.10-4/ (for browsing the source)
- https://sources.debian.net/src/libunistring/0.9.10-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libunistring/0.9.10-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libusb-1.0=2:1.0.24-3`

Binary Packages:

- `libusb-1.0-0:amd64=2:1.0.24-3`

Licenses: (parsed from: `/usr/share/doc/libusb-1.0-0/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libusb-1.0=2:1.0.24-3
'http://deb.debian.org/debian/pool/main/libu/libusb-1.0/libusb-1.0_1.0.24-3.dsc' libusb-1.0_1.0.24-3.dsc 2144 SHA256:c6e5de517ede3e7a909ae52fb16df9f8da07081d99fd9babf3a27fafb5e3f628
'http://deb.debian.org/debian/pool/main/libu/libusb-1.0/libusb-1.0_1.0.24.orig.tar.bz2' libusb-1.0_1.0.24.orig.tar.bz2 606593 SHA256:7efd2685f7b327326dcfb85cee426d9b871fd70e22caa15bb68d595ce2a2b12a
'http://deb.debian.org/debian/pool/main/libu/libusb-1.0/libusb-1.0_1.0.24-3.debian.tar.xz' libusb-1.0_1.0.24-3.debian.tar.xz 14120 SHA256:35bf002c5051d6173c88e38cb749e91bba0b59c9dd350fc71b54980a0f3ea94a
```

Other potentially useful URLs:

- https://sources.debian.net/src/libusb-1.0/2:1.0.24-3/ (for browsing the source)
- https://sources.debian.net/src/libusb-1.0/2:1.0.24-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libusb-1.0/2:1.0.24-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libuv1=1.40.0-2+deb11u1`

Binary Packages:

- `libuv1:amd64=1.40.0-2+deb11u1`
- `libuv1-dev:amd64=1.40.0-2+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libuv1/copyright`, `/usr/share/doc/libuv1-dev/copyright`)

- `BSD-1-clause`
- `BSD-2-clause`
- `BSD-3-clause`
- `CC-BY-4.0`
- `Expat`
- `GPL3+ with autoconf exception`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris libuv1=1.40.0-2+deb11u1
'http://deb.debian.org/debian/pool/main/libu/libuv1/libuv1_1.40.0-2%2bdeb11u1.dsc' libuv1_1.40.0-2+deb11u1.dsc 2029 SHA256:e01789770e96bb8d4e7b3c751d962c4cf6bb937af7d62814f5e57de53b064ab2
'http://deb.debian.org/debian/pool/main/libu/libuv1/libuv1_1.40.0.orig.tar.gz' libuv1_1.40.0.orig.tar.gz 1274644 SHA256:6e249e8d1b47078f43fdddc4274c84aa533879bd503aead7e1e2784815eec0d0
'http://deb.debian.org/debian/pool/main/libu/libuv1/libuv1_1.40.0-2%2bdeb11u1.debian.tar.xz' libuv1_1.40.0-2+deb11u1.debian.tar.xz 24400 SHA256:ab5be8b9b8e36085be9fee20896e88d87da253bf579168615f52045db58e01cd
```

Other potentially useful URLs:

- https://sources.debian.net/src/libuv1/1.40.0-2+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/libuv1/1.40.0-2+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libuv1/1.40.0-2+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libwebp=0.6.1-2.1+deb11u2`

Binary Packages:

- `libwebp6:amd64=0.6.1-2.1+deb11u2`
- `libwebpdemux2:amd64=0.6.1-2.1+deb11u2`
- `libwebpmux3:amd64=0.6.1-2.1+deb11u2`

Licenses: (parsed from: `/usr/share/doc/libwebp6/copyright`, `/usr/share/doc/libwebpdemux2/copyright`, `/usr/share/doc/libwebpmux3/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris libwebp=0.6.1-2.1+deb11u2
'http://deb.debian.org/debian/pool/main/libw/libwebp/libwebp_0.6.1-2.1%2bdeb11u2.dsc' libwebp_0.6.1-2.1+deb11u2.dsc 2086 SHA256:de8a8c64cb1c1fb217b68ca91bc32737af2fa71b6a5ed344262e778cc9f90aa6
'http://deb.debian.org/debian/pool/main/libw/libwebp/libwebp_0.6.1.orig.tar.gz' libwebp_0.6.1.orig.tar.gz 3554290 SHA256:a86045e3ec24704bddbaa369ca30980d6bf4f2625f4cdca03715e91f9c08bbb4
'http://deb.debian.org/debian/pool/main/libw/libwebp/libwebp_0.6.1-2.1%2bdeb11u2.debian.tar.xz' libwebp_0.6.1-2.1+deb11u2.debian.tar.xz 17716 SHA256:81385fbc2b489bc5e0d90f7c2155f64c4adf474b5456f6ccca6a2643e4b870af
```

Other potentially useful URLs:

- https://sources.debian.net/src/libwebp/0.6.1-2.1+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/libwebp/0.6.1-2.1+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libwebp/0.6.1-2.1+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libx11=2:1.7.2-1+deb11u2`

Binary Packages:

- `libx11-6:amd64=2:1.7.2-1+deb11u2`
- `libx11-data=2:1.7.2-1+deb11u2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libx11=2:1.7.2-1+deb11u2
'http://deb.debian.org/debian/pool/main/libx/libx11/libx11_1.7.2-1%2bdeb11u2.dsc' libx11_1.7.2-1+deb11u2.dsc 2600 SHA256:2e7312dd3780fb6bba6479d1a601aaf80a876771dbe15bcf99b3f35d813785eb
'http://deb.debian.org/debian/pool/main/libx/libx11/libx11_1.7.2.orig.tar.gz' libx11_1.7.2.orig.tar.gz 3181228 SHA256:2c26ccd08f43a6214de89110554fbe97c71692eeb7e7d4829f3004ae6fafd2c0
'http://deb.debian.org/debian/pool/main/libx/libx11/libx11_1.7.2.orig.tar.gz.asc' libx11_1.7.2.orig.tar.gz.asc 833 SHA256:509d0ed983ff3aed0dbfb070dabfce82b5787e626f2fd0bfb2a5887918fcd967
'http://deb.debian.org/debian/pool/main/libx/libx11/libx11_1.7.2-1%2bdeb11u2.diff.gz' libx11_1.7.2-1+deb11u2.diff.gz 82069 SHA256:b32103fea010d9a931d7b00f6f8c2fc05acb3da0fb8a5e26f7c4aab12e07f81e
```

Other potentially useful URLs:

- https://sources.debian.net/src/libx11/2:1.7.2-1+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/libx11/2:1.7.2-1+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libx11/2:1.7.2-1+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxau=1:1.0.9-1`

Binary Packages:

- `libxau6:amd64=1:1.0.9-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxau=1:1.0.9-1
'http://deb.debian.org/debian/pool/main/libx/libxau/libxau_1.0.9-1.dsc' libxau_1.0.9-1.dsc 2183 SHA256:e6e059652cda7e5a49b6c9a70667639f32d629c20320487d16c642a06c1ebf85
'http://deb.debian.org/debian/pool/main/libx/libxau/libxau_1.0.9.orig.tar.gz' libxau_1.0.9.orig.tar.gz 394068 SHA256:1f123d8304b082ad63a9e89376400a3b1d4c29e67e3ea07b3f659cccca690eea
'http://deb.debian.org/debian/pool/main/libx/libxau/libxau_1.0.9.orig.tar.gz.asc' libxau_1.0.9.orig.tar.gz.asc 801 SHA256:af6104aaf3c5ede529e381237dd60f49640ec96593a84502fa493b86582b2f04
'http://deb.debian.org/debian/pool/main/libx/libxau/libxau_1.0.9-1.diff.gz' libxau_1.0.9-1.diff.gz 10193 SHA256:7b34899563f172e8f11d061de41b58fe1c32f8683d985e57686677ccb7299a9a
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxau/1:1.0.9-1/ (for browsing the source)
- https://sources.debian.net/src/libxau/1:1.0.9-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxau/1:1.0.9-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxaw=2:1.0.13-1.1`

Binary Packages:

- `libxaw7:amd64=2:1.0.13-1.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxaw=2:1.0.13-1.1
'http://deb.debian.org/debian/pool/main/libx/libxaw/libxaw_1.0.13-1.1.dsc' libxaw_1.0.13-1.1.dsc 2218 SHA256:8f2ba185eabd5912a6cc77ce3ba3b66c4809a73668a5b34361dd629f5d9c25bd
'http://deb.debian.org/debian/pool/main/libx/libxaw/libxaw_1.0.13.orig.tar.gz' libxaw_1.0.13.orig.tar.gz 848997 SHA256:7e74ac3e5f67def549722ff0333d6e6276b8becd9d89615cda011e71238ab694
'http://deb.debian.org/debian/pool/main/libx/libxaw/libxaw_1.0.13-1.1.diff.gz' libxaw_1.0.13-1.1.diff.gz 12695 SHA256:bd97202e4d1920d5c779a79d965d4efcbc8f424617b7c812becf6c33086c3727
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxaw/2:1.0.13-1.1/ (for browsing the source)
- https://sources.debian.net/src/libxaw/2:1.0.13-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxaw/2:1.0.13-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxcb=1.14-3`

Binary Packages:

- `libxcb-render0:amd64=1.14-3`
- `libxcb-shm0:amd64=1.14-3`
- `libxcb1:amd64=1.14-3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxcb=1.14-3
'http://deb.debian.org/debian/pool/main/libx/libxcb/libxcb_1.14-3.dsc' libxcb_1.14-3.dsc 5373 SHA256:25030a957600e3afcfecd095e3c1187885818a8a3fe8346ae965fe62c3a3b2eb
'http://deb.debian.org/debian/pool/main/libx/libxcb/libxcb_1.14.orig.tar.gz' libxcb_1.14.orig.tar.gz 640322 SHA256:2c7fcddd1da34d9b238c9caeda20d3bd7486456fc50b3cc6567185dbd5b0ad02
'http://deb.debian.org/debian/pool/main/libx/libxcb/libxcb_1.14-3.diff.gz' libxcb_1.14-3.diff.gz 26583 SHA256:aed546fff9cf733c52188ad4f0d869a5ee8ffec52b54a6fa8f666a87adda82a3
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxcb/1.14-3/ (for browsing the source)
- https://sources.debian.net/src/libxcb/1.14-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxcb/1.14-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxcrypt=1:4.4.18-4`

Binary Packages:

- `libcrypt1:amd64=1:4.4.18-4`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxcrypt=1:4.4.18-4
'http://deb.debian.org/debian/pool/main/libx/libxcrypt/libxcrypt_4.4.18-4.dsc' libxcrypt_4.4.18-4.dsc 1477 SHA256:5c0ca54ddad5343596f6c0916caf30fbb9b8a144252b49dc74f97502f33cdb7a
'http://deb.debian.org/debian/pool/main/libx/libxcrypt/libxcrypt_4.4.18.orig.tar.xz' libxcrypt_4.4.18.orig.tar.xz 397776 SHA256:4cd2a06e98519d57a5572ee8885b6cc23c70a559d234c161d3f22c487edaa3fa
'http://deb.debian.org/debian/pool/main/libx/libxcrypt/libxcrypt_4.4.18-4.debian.tar.xz' libxcrypt_4.4.18-4.debian.tar.xz 7560 SHA256:6c99b888c57e1411d870fa81d057e30444aa801ed430aa3126d31996e187dd84
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxcrypt/1:4.4.18-4/ (for browsing the source)
- https://sources.debian.net/src/libxcrypt/1:4.4.18-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxcrypt/1:4.4.18-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxdmcp=1:1.1.2-3`

Binary Packages:

- `libxdmcp6:amd64=1:1.1.2-3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxdmcp=1:1.1.2-3
'http://deb.debian.org/debian/pool/main/libx/libxdmcp/libxdmcp_1.1.2-3.dsc' libxdmcp_1.1.2-3.dsc 2145 SHA256:f9697dca6a275aeee9a3eee9fb2d55e0f77485481e8b84efc6950fc9b1988460
'http://deb.debian.org/debian/pool/main/libx/libxdmcp/libxdmcp_1.1.2.orig.tar.gz' libxdmcp_1.1.2.orig.tar.gz 404115 SHA256:6f7c7e491a23035a26284d247779174dedc67e34e93cc3548b648ffdb6fc57c0
'http://deb.debian.org/debian/pool/main/libx/libxdmcp/libxdmcp_1.1.2-3.diff.gz' libxdmcp_1.1.2-3.diff.gz 18017 SHA256:5844df115c17e5ba40ac116f80373304d821c607e763ef6f40562421f5cc0cf3
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxdmcp/1:1.1.2-3/ (for browsing the source)
- https://sources.debian.net/src/libxdmcp/1:1.1.2-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxdmcp/1:1.1.2-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxext=2:1.3.3-1.1`

Binary Packages:

- `libxext6:amd64=2:1.3.3-1.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxext=2:1.3.3-1.1
'http://deb.debian.org/debian/pool/main/libx/libxext/libxext_1.3.3-1.1.dsc' libxext_1.3.3-1.1.dsc 2243 SHA256:ae9f97003e38da180294f43a8217991df709955dd7576c5333e2412f264f8697
'http://deb.debian.org/debian/pool/main/libx/libxext/libxext_1.3.3.orig.tar.gz' libxext_1.3.3.orig.tar.gz 468441 SHA256:eb0b88050491fef4716da4b06a4d92b4fc9e76f880d6310b2157df604342cfe5
'http://deb.debian.org/debian/pool/main/libx/libxext/libxext_1.3.3-1.1.diff.gz' libxext_1.3.3-1.1.diff.gz 20628 SHA256:6a8ce08c667c4631c59bc79c716187dc7ed20bb7d0967701ab21313e6dd6c752
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxext/2:1.3.3-1.1/ (for browsing the source)
- https://sources.debian.net/src/libxext/2:1.3.3-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxext/2:1.3.3-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxml2=2.9.10+dfsg-6.7+deb11u5`

Binary Packages:

- `libxml2:amd64=2.9.10+dfsg-6.7+deb11u5`

Licenses: (parsed from: `/usr/share/doc/libxml2/copyright`)

- `ISC`
- `MIT-1`

Source:

```console
$ apt-get source -qq --print-uris libxml2=2.9.10+dfsg-6.7+deb11u5
'http://deb.debian.org/debian-security/pool/updates/main/libx/libxml2/libxml2_2.9.10%2bdfsg-6.7%2bdeb11u5.dsc' libxml2_2.9.10+dfsg-6.7+deb11u5.dsc 2704 SHA256:77bca4aa4cc6543ca08e1a96a81441ae23ca363b57c82fd5d58341e646d82350
'http://deb.debian.org/debian-security/pool/updates/main/libx/libxml2/libxml2_2.9.10%2bdfsg.orig.tar.xz' libxml2_2.9.10+dfsg.orig.tar.xz 2503560 SHA256:65ee7a2f5e100c64ddf7beb92297c9b2a30b994a76cd1fab67470cf22db6b7d0
'http://deb.debian.org/debian-security/pool/updates/main/libx/libxml2/libxml2_2.9.10%2bdfsg-6.7%2bdeb11u5.debian.tar.xz' libxml2_2.9.10+dfsg-6.7+deb11u5.debian.tar.xz 43140 SHA256:ce3a1e4fa6c173de6638a74a122b28fff367b352a2c4bc26002fead5c0feeca7
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxml2/2.9.10+dfsg-6.7+deb11u5/ (for browsing the source)
- https://sources.debian.net/src/libxml2/2.9.10+dfsg-6.7+deb11u5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxml2/2.9.10+dfsg-6.7+deb11u5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxmu=2:1.1.2-2`

Binary Packages:

- `libxmu6:amd64=2:1.1.2-2+b3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxmu=2:1.1.2-2
'http://deb.debian.org/debian/pool/main/libx/libxmu/libxmu_1.1.2-2.dsc' libxmu_1.1.2-2.dsc 2291 SHA256:5e3333a3fe9dbed9d0df596d964b94aa1d45d56a0475a8b66b3f69d60ab29504
'http://deb.debian.org/debian/pool/main/libx/libxmu/libxmu_1.1.2.orig.tar.gz' libxmu_1.1.2.orig.tar.gz 469019 SHA256:e5fd4bacef068f9509b8226017205040e38d3fba8d2de55037200e7176c13dba
'http://deb.debian.org/debian/pool/main/libx/libxmu/libxmu_1.1.2-2.diff.gz' libxmu_1.1.2-2.diff.gz 6054 SHA256:c01cbd09a15e71c0418d2689a0fd0b946bf4e40d1dbe9f594beb00a4818f0740
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxmu/2:1.1.2-2/ (for browsing the source)
- https://sources.debian.net/src/libxmu/2:1.1.2-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxmu/2:1.1.2-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxpm=1:3.5.12-1.1+deb11u1`

Binary Packages:

- `libxpm4:amd64=1:3.5.12-1.1+deb11u1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxpm=1:3.5.12-1.1+deb11u1
'http://deb.debian.org/debian/pool/main/libx/libxpm/libxpm_3.5.12-1.1%2bdeb11u1.dsc' libxpm_3.5.12-1.1+deb11u1.dsc 2133 SHA256:60b0c50c28421fa96ea6d7eba22c1c6907dee9b27bf3470afb7693561e898fe8
'http://deb.debian.org/debian/pool/main/libx/libxpm/libxpm_3.5.12.orig.tar.gz' libxpm_3.5.12.orig.tar.gz 529302 SHA256:2523acc780eac01db5163267b36f5b94374bfb0de26fc0b5a7bee76649fd8501
'http://deb.debian.org/debian/pool/main/libx/libxpm/libxpm_3.5.12-1.1%2bdeb11u1.diff.gz' libxpm_3.5.12-1.1+deb11u1.diff.gz 22644 SHA256:2fda4c61290da26da7a643f001c9996c8533b2741b62a3d2cd0ee81900d484d4
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxpm/1:3.5.12-1.1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/libxpm/1:3.5.12-1.1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxpm/1:3.5.12-1.1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxrender=1:0.9.10-1`

Binary Packages:

- `libxrender1:amd64=1:0.9.10-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxrender=1:0.9.10-1
'http://deb.debian.org/debian/pool/main/libx/libxrender/libxrender_0.9.10-1.dsc' libxrender_0.9.10-1.dsc 2064 SHA256:95d6471218b44f4e60c48cea60cfb4865bbe861530add23f6c859515bee92dbd
'http://deb.debian.org/debian/pool/main/libx/libxrender/libxrender_0.9.10.orig.tar.gz' libxrender_0.9.10.orig.tar.gz 373717 SHA256:770527cce42500790433df84ec3521e8bf095dfe5079454a92236494ab296adf
'http://deb.debian.org/debian/pool/main/libx/libxrender/libxrender_0.9.10-1.diff.gz' libxrender_0.9.10-1.diff.gz 15399 SHA256:ff56a0a00119383adc5f1731e86155ae5c2de069e1d059a9da1d777917430588
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxrender/1:0.9.10-1/ (for browsing the source)
- https://sources.debian.net/src/libxrender/1:0.9.10-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxrender/1:0.9.10-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxslt=1.1.34-4+deb11u1`

Binary Packages:

- `libxslt1.1:amd64=1.1.34-4+deb11u1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxslt=1.1.34-4+deb11u1
'http://deb.debian.org/debian/pool/main/libx/libxslt/libxslt_1.1.34-4%2bdeb11u1.dsc' libxslt_1.1.34-4+deb11u1.dsc 2562 SHA256:0dec0521f4d7cfc08bd61c4d4aa82866881962c12f1429f730830c79c6678e93
'http://deb.debian.org/debian/pool/main/libx/libxslt/libxslt_1.1.34.orig.tar.gz' libxslt_1.1.34.orig.tar.gz 3552258 SHA256:98b1bd46d6792925ad2dfe9a87452ea2adebf69dcb9919ffd55bf926a7f93f7f
'http://deb.debian.org/debian/pool/main/libx/libxslt/libxslt_1.1.34.orig.tar.gz.asc' libxslt_1.1.34.orig.tar.gz.asc 488 SHA256:673d1477552bdd5b0cc665704e77ca70e6be5d2f257e6a5a341c846719d747cf
'http://deb.debian.org/debian/pool/main/libx/libxslt/libxslt_1.1.34-4%2bdeb11u1.debian.tar.xz' libxslt_1.1.34-4+deb11u1.debian.tar.xz 23152 SHA256:0272cab003bb5fe7105d54f3023c806062c818082df4d791fd45dbf526b801f8
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxslt/1.1.34-4+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/libxslt/1.1.34-4+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxslt/1.1.34-4+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxt=1:1.2.0-1`

Binary Packages:

- `libxt6:amd64=1:1.2.0-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxt=1:1.2.0-1
'http://deb.debian.org/debian/pool/main/libx/libxt/libxt_1.2.0-1.dsc' libxt_1.2.0-1.dsc 2298 SHA256:945650656e7f24f1276a1c100067e7fa728d50d7af93b4fcc149e5a5323df165
'http://deb.debian.org/debian/pool/main/libx/libxt/libxt_1.2.0.orig.tar.gz' libxt_1.2.0.orig.tar.gz 1016961 SHA256:d4bee88898fc5e1dc470e361430c72fbc529b9cdbbb6c0ed3affea3a39f97d8d
'http://deb.debian.org/debian/pool/main/libx/libxt/libxt_1.2.0.orig.tar.gz.asc' libxt_1.2.0.orig.tar.gz.asc 195 SHA256:4c5fe1bceef4aa507d5a95d2636e7ce257ee4f2b5522989ec4a7281cbe860564
'http://deb.debian.org/debian/pool/main/libx/libxt/libxt_1.2.0-1.diff.gz' libxt_1.2.0-1.diff.gz 31129 SHA256:eb723d0651e39c56d1e81fb7519e5093fd7e0177d42fd458d539163512076e52
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxt/1:1.2.0-1/ (for browsing the source)
- https://sources.debian.net/src/libxt/1:1.2.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxt/1:1.2.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libyaml=0.2.2-1`

Binary Packages:

- `libyaml-0-2:amd64=0.2.2-1`

Licenses: (parsed from: `/usr/share/doc/libyaml-0-2/copyright`)

- `Expat`
- `permissive`

Source:

```console
$ apt-get source -qq --print-uris libyaml=0.2.2-1
'http://deb.debian.org/debian/pool/main/liby/libyaml/libyaml_0.2.2-1.dsc' libyaml_0.2.2-1.dsc 1833 SHA256:b4baba985391f52409013a0c9303191e34aaa4c1c9200e4c01c4963df801db09
'http://deb.debian.org/debian/pool/main/liby/libyaml/libyaml_0.2.2.orig.tar.gz' libyaml_0.2.2.orig.tar.gz 602509 SHA256:689ef3ebdecfa81f3789ccd2481acc81fc0f22f3f5c947eed95c4c0802e356b8
'http://deb.debian.org/debian/pool/main/liby/libyaml/libyaml_0.2.2-1.debian.tar.xz' libyaml_0.2.2-1.debian.tar.xz 4112 SHA256:186aad3e4bcd95891a8c59249c59f862f5f71601058fda0bf020a9e9e39320fe
```

Other potentially useful URLs:

- https://sources.debian.net/src/libyaml/0.2.2-1/ (for browsing the source)
- https://sources.debian.net/src/libyaml/0.2.2-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libyaml/0.2.2-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libzstd=1.4.8+dfsg-2.1`

Binary Packages:

- `libzstd1:amd64=1.4.8+dfsg-2.1`

Licenses: (parsed from: `/usr/share/doc/libzstd1/copyright`)

- `BSD-3-clause`
- `Expat`
- `GPL-2`
- `zlib`

Source:

```console
$ apt-get source -qq --print-uris libzstd=1.4.8+dfsg-2.1
'http://deb.debian.org/debian/pool/main/libz/libzstd/libzstd_1.4.8%2bdfsg-2.1.dsc' libzstd_1.4.8+dfsg-2.1.dsc 2274 SHA256:7c656b8cab7a560710358dddbd949b33b1ffcedd7cbef370132e4018b94e2e74
'http://deb.debian.org/debian/pool/main/libz/libzstd/libzstd_1.4.8%2bdfsg.orig.tar.xz' libzstd_1.4.8+dfsg.orig.tar.xz 1331996 SHA256:1e8ce5c4880a6d5bd8d3186e4186607dd19b64fc98a3877fc13aeefd566d67c5
'http://deb.debian.org/debian/pool/main/libz/libzstd/libzstd_1.4.8%2bdfsg-2.1.debian.tar.xz' libzstd_1.4.8+dfsg-2.1.debian.tar.xz 12224 SHA256:cba8544590e59303277e3af2bb260fed32723a1084c9f4928956deca2c80032c
```

Other potentially useful URLs:

- https://sources.debian.net/src/libzstd/1.4.8+dfsg-2.1/ (for browsing the source)
- https://sources.debian.net/src/libzstd/1.4.8+dfsg-2.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libzstd/1.4.8+dfsg-2.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `lsb=11.1.0`

Binary Packages:

- `lsb-base=11.1.0`

Licenses: (parsed from: `/usr/share/doc/lsb-base/copyright`)

- `BSD-3-clause`
- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris lsb=11.1.0
'http://deb.debian.org/debian/pool/main/l/lsb/lsb_11.1.0.dsc' lsb_11.1.0.dsc 1800 SHA256:5cb5679dcc92e30aa878f892f73081d6b4d5299841549f6d53a886d51509feb1
'http://deb.debian.org/debian/pool/main/l/lsb/lsb_11.1.0.tar.xz' lsb_11.1.0.tar.xz 42452 SHA256:c7926d511228862892630070f7708c425db9473ceefc70872868c448b5145b57
```

Other potentially useful URLs:

- https://sources.debian.net/src/lsb/11.1.0/ (for browsing the source)
- https://sources.debian.net/src/lsb/11.1.0/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/lsb/11.1.0/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `lxml=4.6.3+dfsg-0.1+deb11u1`

Binary Packages:

- `python3-lxml:amd64=4.6.3+dfsg-0.1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/python3-lxml/copyright`)

- `GPL`
- `GPL2`
- `later`

Source:

```console
$ apt-get source -qq --print-uris lxml=4.6.3+dfsg-0.1+deb11u1
'http://deb.debian.org/debian/pool/main/l/lxml/lxml_4.6.3%2bdfsg-0.1%2bdeb11u1.dsc' lxml_4.6.3+dfsg-0.1+deb11u1.dsc 2254 SHA256:0d6d208b52a784c0c3a3dc7def582780ecd9cd1675bb586551336717727c3202
'http://deb.debian.org/debian/pool/main/l/lxml/lxml_4.6.3%2bdfsg.orig.tar.gz' lxml_4.6.3+dfsg.orig.tar.gz 940222 SHA256:aa386ddf45ccc40975f33d29e285b6656273254ed797dd87d6283090f5d62036
'http://deb.debian.org/debian/pool/main/l/lxml/lxml_4.6.3%2bdfsg-0.1%2bdeb11u1.debian.tar.xz' lxml_4.6.3+dfsg-0.1+deb11u1.debian.tar.xz 9684 SHA256:ee470d49936d6e5079df87d098ba82d9a99dab2f74e3db0f480c874d12952e3d
```

Other potentially useful URLs:

- https://sources.debian.net/src/lxml/4.6.3+dfsg-0.1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/lxml/4.6.3+dfsg-0.1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/lxml/4.6.3+dfsg-0.1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `lz4=1.9.3-2`

Binary Packages:

- `liblz4-1:amd64=1.9.3-2`

Licenses: (parsed from: `/usr/share/doc/liblz4-1/copyright`)

- `BSD-2-clause`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris lz4=1.9.3-2
'http://deb.debian.org/debian/pool/main/l/lz4/lz4_1.9.3-2.dsc' lz4_1.9.3-2.dsc 1959 SHA256:215e1f0be1bb40e2b89182f3a1bf630463d8acdc0917f1f928ad1bf9ef3e1b0c
'http://deb.debian.org/debian/pool/main/l/lz4/lz4_1.9.3.orig.tar.gz' lz4_1.9.3.orig.tar.gz 320958 SHA256:030644df4611007ff7dc962d981f390361e6c97a34e5cbc393ddfbe019ffe2c1
'http://deb.debian.org/debian/pool/main/l/lz4/lz4_1.9.3-2.debian.tar.xz' lz4_1.9.3-2.debian.tar.xz 13928 SHA256:d7754a7b7b1fa196666d6459705107355e15fef162352e363e43722e012a04e3
```

Other potentially useful URLs:

- https://sources.debian.net/src/lz4/1.9.3-2/ (for browsing the source)
- https://sources.debian.net/src/lz4/1.9.3-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/lz4/1.9.3-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `mailcap=3.69`

Binary Packages:

- `mailcap=3.69`

Licenses: (parsed from: `/usr/share/doc/mailcap/copyright`)

- `Bellcore`
- `ad-hoc`

Source:

```console
$ apt-get source -qq --print-uris mailcap=3.69
'http://deb.debian.org/debian/pool/main/m/mailcap/mailcap_3.69.dsc' mailcap_3.69.dsc 1547 SHA256:dce5adca35e7a81bf53fb856adff796c1926f9690c499b3a06a69f28122d2e05
'http://deb.debian.org/debian/pool/main/m/mailcap/mailcap_3.69.tar.xz' mailcap_3.69.tar.xz 26644 SHA256:969c6e24d861f1c50203d93f8b5ddc680a2e2c3fd84de489b1b65baad92120cb
```

Other potentially useful URLs:

- https://sources.debian.net/src/mailcap/3.69/ (for browsing the source)
- https://sources.debian.net/src/mailcap/3.69/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/mailcap/3.69/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `markupsafe=1.1.1-1`

Binary Packages:

- `python3-markupsafe=1.1.1-1+b3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris markupsafe=1.1.1-1
'http://deb.debian.org/debian/pool/main/m/markupsafe/markupsafe_1.1.1-1.dsc' markupsafe_1.1.1-1.dsc 2336 SHA256:e3ad1a826430f412714c37f06665a93df84edc06b67b4d6a0a034b01a7876ac4
'http://deb.debian.org/debian/pool/main/m/markupsafe/markupsafe_1.1.1.orig.tar.gz' markupsafe_1.1.1.orig.tar.gz 19151 SHA256:29872e92839765e546828bb7754a68c418d927cd064fd4708fab9fe9c8bb116b
'http://deb.debian.org/debian/pool/main/m/markupsafe/markupsafe_1.1.1-1.debian.tar.xz' markupsafe_1.1.1-1.debian.tar.xz 3708 SHA256:ffd7a439e873eaefb14426bbda8e61568acc3f8e12e074ddeb8a86257466742a
```

Other potentially useful URLs:

- https://sources.debian.net/src/markupsafe/1.1.1-1/ (for browsing the source)
- https://sources.debian.net/src/markupsafe/1.1.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/markupsafe/1.1.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `mawk=1.3.4.20200120-2`

Binary Packages:

- `mawk=1.3.4.20200120-2`

Licenses: (parsed from: `/usr/share/doc/mawk/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris mawk=1.3.4.20200120-2
'http://deb.debian.org/debian/pool/main/m/mawk/mawk_1.3.4.20200120-2.dsc' mawk_1.3.4.20200120-2.dsc 1915 SHA256:5069c46872ac74f5221250dfb88b31b1f2dbb8a2617c1e013f8f80cc34638c6d
'http://deb.debian.org/debian/pool/main/m/mawk/mawk_1.3.4.20200120.orig.tar.gz' mawk_1.3.4.20200120.orig.tar.gz 468855 SHA256:7fd4cd1e1fae9290fe089171181bbc6291dfd9bca939ca804f0ddb851c8b8237
'http://deb.debian.org/debian/pool/main/m/mawk/mawk_1.3.4.20200120-2.debian.tar.xz' mawk_1.3.4.20200120-2.debian.tar.xz 7504 SHA256:b772ed2f016b0286980c46cbc1f1f4ae62887ef2aa3dff6ef10cae638f923f26
```

Other potentially useful URLs:

- https://sources.debian.net/src/mawk/1.3.4.20200120-2/ (for browsing the source)
- https://sources.debian.net/src/mawk/1.3.4.20200120-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/mawk/1.3.4.20200120-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `media-types=4.0.0`

Binary Packages:

- `media-types=4.0.0`

Licenses: (parsed from: `/usr/share/doc/media-types/copyright`)

- `ad-hoc`

Source:

```console
$ apt-get source -qq --print-uris media-types=4.0.0
'http://deb.debian.org/debian/pool/main/m/media-types/media-types_4.0.0.dsc' media-types_4.0.0.dsc 1620 SHA256:422edc1275dcc6bf07ac1b30612f501624cba04cfca2331eb87f1ca3af89e701
'http://deb.debian.org/debian/pool/main/m/media-types/media-types_4.0.0.tar.xz' media-types_4.0.0.tar.xz 33988 SHA256:b5eb14fd6addb8f10c1665ebaa113cd0ebfb47f692cf27d9ac47405b13ce4e31
```

Other potentially useful URLs:

- https://sources.debian.net/src/media-types/4.0.0/ (for browsing the source)
- https://sources.debian.net/src/media-types/4.0.0/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/media-types/4.0.0/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `mime-support=3.66`

Binary Packages:

- `mime-support=3.66`

Licenses: (parsed from: `/usr/share/doc/mime-support/copyright`)

- `ad-hoc`

Source:

```console
$ apt-get source -qq --print-uris mime-support=3.66
'http://deb.debian.org/debian/pool/main/m/mime-support/mime-support_3.66.dsc' mime-support_3.66.dsc 1625 SHA256:fd3ffd241c7aa3e3a039d96c4550032a977ddc716ebc460ca6014787db911426
'http://deb.debian.org/debian/pool/main/m/mime-support/mime-support_3.66.tar.xz' mime-support_3.66.tar.xz 9568 SHA256:da605b0fe27e5b3186b0530cd6352c46f98d0c6045b028a0dae7ba3c58cf19c4
```

Other potentially useful URLs:

- https://sources.debian.net/src/mime-support/3.66/ (for browsing the source)
- https://sources.debian.net/src/mime-support/3.66/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/mime-support/3.66/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `mpdecimal=2.5.1-1`

Binary Packages:

- `libmpdec3:amd64=2.5.1-1`

Licenses: (parsed from: `/usr/share/doc/libmpdec3/copyright`)

- `BSD`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris mpdecimal=2.5.1-1
'http://deb.debian.org/debian/pool/main/m/mpdecimal/mpdecimal_2.5.1-1.dsc' mpdecimal_2.5.1-1.dsc 1919 SHA256:5b4e5bc4d714b76af72bc4eaad2ac7feeb08ac5ee9fa5318f91edebe118ab6f9
'http://deb.debian.org/debian/pool/main/m/mpdecimal/mpdecimal_2.5.1.orig.tar.gz' mpdecimal_2.5.1.orig.tar.gz 2584021 SHA256:9f9cd4c041f99b5c49ffb7b59d9f12d95b683d88585608aa56a6307667b2b21f
'http://deb.debian.org/debian/pool/main/m/mpdecimal/mpdecimal_2.5.1-1.debian.tar.xz' mpdecimal_2.5.1-1.debian.tar.xz 6444 SHA256:e46140b8e665aee3058d0b2fb4fa44bde600251c8471de73711fa23ac573ee8a
```

Other potentially useful URLs:

- https://sources.debian.net/src/mpdecimal/2.5.1-1/ (for browsing the source)
- https://sources.debian.net/src/mpdecimal/2.5.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/mpdecimal/2.5.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `ncurses=6.2+20201114-2+deb11u2`

Binary Packages:

- `libncursesw6:amd64=6.2+20201114-2+deb11u2`
- `libtinfo6:amd64=6.2+20201114-2+deb11u2`
- `ncurses-base=6.2+20201114-2+deb11u2`
- `ncurses-bin=6.2+20201114-2+deb11u2`

Licenses: (parsed from: `/usr/share/doc/libncursesw6/copyright`, `/usr/share/doc/libtinfo6/copyright`, `/usr/share/doc/ncurses-base/copyright`, `/usr/share/doc/ncurses-bin/copyright`)

- `BSD-3-clause`
- `MIT/X11`
- `X11`

Source:

```console
$ apt-get source -qq --print-uris ncurses=6.2+20201114-2+deb11u2
'http://deb.debian.org/debian/pool/main/n/ncurses/ncurses_6.2%2b20201114-2%2bdeb11u2.dsc' ncurses_6.2+20201114-2+deb11u2.dsc 4138 SHA256:3ec39ab5dae31895ea40ca68d9f3e1b1c701e092a383fe4e0158f66c60043f49
'http://deb.debian.org/debian/pool/main/n/ncurses/ncurses_6.2%2b20201114.orig.tar.gz' ncurses_6.2+20201114.orig.tar.gz 3539796 SHA256:aa3f8cfaff2a2b78f184274ec43d9da910c864e4b4d80fc47b5b48cba9154cd2
'http://deb.debian.org/debian/pool/main/n/ncurses/ncurses_6.2%2b20201114.orig.tar.gz.asc' ncurses_6.2+20201114.orig.tar.gz.asc 265 SHA256:91615d9d5575f9e974e78c6aca55e1885f42d1b2600cebec407be4471bb7a27d
'http://deb.debian.org/debian/pool/main/n/ncurses/ncurses_6.2%2b20201114-2%2bdeb11u2.debian.tar.xz' ncurses_6.2+20201114-2+deb11u2.debian.tar.xz 54056 SHA256:c0f89212206e4c9dc5e141e2588ba82ea76051a04fccc5dc84075a358b3a6704
```

Other potentially useful URLs:

- https://sources.debian.net/src/ncurses/6.2+20201114-2+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/ncurses/6.2+20201114-2+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/ncurses/6.2+20201114-2+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `netbase=6.3`

Binary Packages:

- `netbase=6.3`

Licenses: (parsed from: `/usr/share/doc/netbase/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris netbase=6.3
'http://deb.debian.org/debian/pool/main/n/netbase/netbase_6.3.dsc' netbase_6.3.dsc 875 SHA256:f16f43e8b51814911d679d91cbfa9e9be4930a7c59c294c70b6af43ae7a1d42f
'http://deb.debian.org/debian/pool/main/n/netbase/netbase_6.3.tar.xz' netbase_6.3.tar.xz 31968 SHA256:7c42a6a1cafa0c64103c71cab6431fc8613179b2449a1a00e55e3584e860d81c
```

Other potentially useful URLs:

- https://sources.debian.net/src/netbase/6.3/ (for browsing the source)
- https://sources.debian.net/src/netbase/6.3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/netbase/6.3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `nettle=3.7.3-1`

Binary Packages:

- `libhogweed6:amd64=3.7.3-1`
- `libnettle8:amd64=3.7.3-1`

Licenses: (parsed from: `/usr/share/doc/libhogweed6/copyright`, `/usr/share/doc/libnettle8/copyright`)

- `Expat`
- `GAP`
- `GPL`
- `GPL-2`
- `GPL-2+`
- `GPL-3+`
- `GPL-3+ with Autoconf exception`
- `LGPL`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-3+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris nettle=3.7.3-1
'http://deb.debian.org/debian/pool/main/n/nettle/nettle_3.7.3-1.dsc' nettle_3.7.3-1.dsc 2033 SHA256:63a1a80f37b6484f479dfa1cbd30152feff3b1a5a2161fdab05b90edde212c1f
'http://deb.debian.org/debian/pool/main/n/nettle/nettle_3.7.3.orig.tar.gz' nettle_3.7.3.orig.tar.gz 2383985 SHA256:661f5eb03f048a3b924c3a8ad2515d4068e40f67e774e8a26827658007e3bcf0
'http://deb.debian.org/debian/pool/main/n/nettle/nettle_3.7.3-1.debian.tar.xz' nettle_3.7.3-1.debian.tar.xz 21956 SHA256:97af0e306aec6f6c5d8e73a7a3ce2856c76bcff9cdcfa7640e932a5a3aee9f24
```

Other potentially useful URLs:

- https://sources.debian.net/src/nettle/3.7.3-1/ (for browsing the source)
- https://sources.debian.net/src/nettle/3.7.3-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/nettle/3.7.3-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `nghttp2=1.43.0-1+deb11u2`

Binary Packages:

- `libnghttp2-14:amd64=1.43.0-1+deb11u2`

Licenses: (parsed from: `/usr/share/doc/libnghttp2-14/copyright`)

- `BSD-2-clause`
- `Expat`
- `GPL-3`
- `GPL-3+ with autoconf exception`
- `MIT`
- `SIL-OFL-1.1`
- `all-permissive`

Source:

```console
$ apt-get source -qq --print-uris nghttp2=1.43.0-1+deb11u2
'http://deb.debian.org/debian-security/pool/updates/main/n/nghttp2/nghttp2_1.43.0-1%2bdeb11u2.dsc' nghttp2_1.43.0-1+deb11u2.dsc 2555 SHA256:13ad116ef14dc9e3da1b3aa3b1f2645e2dcf44e153564a5ec26f5df5d91cd854
'http://deb.debian.org/debian-security/pool/updates/main/n/nghttp2/nghttp2_1.43.0.orig.tar.bz2' nghttp2_1.43.0.orig.tar.bz2 4521786 SHA256:556f24653397c71ebb8270b3c5e5507f0893e6eac2c6eeda6be2ecf6e1f50f62
'http://deb.debian.org/debian-security/pool/updates/main/n/nghttp2/nghttp2_1.43.0-1%2bdeb11u2.debian.tar.xz' nghttp2_1.43.0-1+deb11u2.debian.tar.xz 23484 SHA256:52cd263f1db0a02edf21322251d7a444eb2fce158bbcaf23e26bf25c6051fd83
```

Other potentially useful URLs:

- https://sources.debian.net/src/nghttp2/1.43.0-1+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/nghttp2/1.43.0-1+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/nghttp2/1.43.0-1+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-abbrev=1.1.1-2`

Binary Packages:

- `node-abbrev=1.1.1-2`

Licenses: (parsed from: `/usr/share/doc/node-abbrev/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-abbrev=1.1.1-2
'http://deb.debian.org/debian/pool/main/n/node-abbrev/node-abbrev_1.1.1-2.dsc' node-abbrev_1.1.1-2.dsc 2048 SHA256:e16078d412286e112fedb2ccb9ce91334080967e7069cea51f7af6b08ba494bb
'http://deb.debian.org/debian/pool/main/n/node-abbrev/node-abbrev_1.1.1.orig.tar.gz' node-abbrev_1.1.1.orig.tar.gz 3156 SHA256:a6560444a3572a1d3d8626f16dc0d47fd7125d1635b38ce8ea954edee8ef1a01
'http://deb.debian.org/debian/pool/main/n/node-abbrev/node-abbrev_1.1.1-2.debian.tar.xz' node-abbrev_1.1.1-2.debian.tar.xz 3208 SHA256:669cc0f6af4e43dcf2faf5ec52118c2613ce41abfd8f8b1a501127c6c9bf745f
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-abbrev/1.1.1-2/ (for browsing the source)
- https://sources.debian.net/src/node-abbrev/1.1.1-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-abbrev/1.1.1-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-agent-base=6.0.2-2`

Binary Packages:

- `node-agent-base=6.0.2-2`

Licenses: (parsed from: `/usr/share/doc/node-agent-base/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-agent-base=6.0.2-2
'http://deb.debian.org/debian/pool/main/n/node-agent-base/node-agent-base_6.0.2-2.dsc' node-agent-base_6.0.2-2.dsc 2565 SHA256:1058563f75ae0524f77d31590231769dc7e698c11cf90e81a40b99618371545c
'http://deb.debian.org/debian/pool/main/n/node-agent-base/node-agent-base_6.0.2.orig-async-listen.tar.gz' node-agent-base_6.0.2.orig-async-listen.tar.gz 1649 SHA256:e898a52f761f3f40664441ec5fdda01b8bc2ccd229b28f2d82a0ee4bf6146aa9
'http://deb.debian.org/debian/pool/main/n/node-agent-base/node-agent-base_6.0.2.orig.tar.gz' node-agent-base_6.0.2.orig.tar.gz 13251 SHA256:d9d376fc429a748528c1ad3f633af37832b39849d4419cd8067ed60853020707
'http://deb.debian.org/debian/pool/main/n/node-agent-base/node-agent-base_6.0.2-2.debian.tar.xz' node-agent-base_6.0.2-2.debian.tar.xz 3660 SHA256:847d705a3594890363441e4b2de60c93d5dfea1ff61140fba8b432c960c3021e
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-agent-base/6.0.2-2/ (for browsing the source)
- https://sources.debian.net/src/node-agent-base/6.0.2-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-agent-base/6.0.2-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-ajv=6.12.6-2`

Binary Packages:

- `node-ajv=6.12.6-2`

Licenses: (parsed from: `/usr/share/doc/node-ajv/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-ajv=6.12.6-2
'http://deb.debian.org/debian/pool/main/n/node-ajv/node-ajv_6.12.6-2.dsc' node-ajv_6.12.6-2.dsc 2485 SHA256:301ad63cd196e4613488f9e178906ddc1165c7cc91f09c3d1933edd3bfa27205
'http://deb.debian.org/debian/pool/main/n/node-ajv/node-ajv_6.12.6.orig-fast-json-stable-stringify.tar.gz' node-ajv_6.12.6.orig-fast-json-stable-stringify.tar.gz 6602 SHA256:d25251cadbe541a832b1bb942a36f5e243ac917e61ee3fa0b9d6bfd177d71051
'http://deb.debian.org/debian/pool/main/n/node-ajv/node-ajv_6.12.6.orig.tar.gz' node-ajv_6.12.6.orig.tar.gz 159271 SHA256:5aadfe1aab74e0f5576d841e5eb3b8a59cccfb4bb4d4d43261ab374dbf8b120e
'http://deb.debian.org/debian/pool/main/n/node-ajv/node-ajv_6.12.6-2.debian.tar.xz' node-ajv_6.12.6-2.debian.tar.xz 3968 SHA256:11a8d0ae72d6f4acf6bf6e596306065fa8d2d91fe3ff1188ccebc8f942dc5d5c
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-ajv/6.12.6-2/ (for browsing the source)
- https://sources.debian.net/src/node-ajv/6.12.6-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-ajv/6.12.6-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-ansi-regex=5.0.1-1~deb11u1`

Binary Packages:

- `node-ansi-regex=5.0.1-1~deb11u1`

Licenses: (parsed from: `/usr/share/doc/node-ansi-regex/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-ansi-regex=5.0.1-1~deb11u1
'http://deb.debian.org/debian/pool/main/n/node-ansi-regex/node-ansi-regex_5.0.1-1%7edeb11u1.dsc' node-ansi-regex_5.0.1-1~deb11u1.dsc 2116 SHA256:39e54ad58a431a83311c017fea00f2e48c1075109d84563f5c8231cf59368d31
'http://deb.debian.org/debian/pool/main/n/node-ansi-regex/node-ansi-regex_5.0.1.orig.tar.gz' node-ansi-regex_5.0.1.orig.tar.gz 7638 SHA256:da70013154c6b32f86cc9e875d3c94edc743c39a57f0339d61794b454306b327
'http://deb.debian.org/debian/pool/main/n/node-ansi-regex/node-ansi-regex_5.0.1-1%7edeb11u1.debian.tar.xz' node-ansi-regex_5.0.1-1~deb11u1.debian.tar.xz 3768 SHA256:4e695fb27a8d5c3b780cea2cf523b24dc760bd7005872cdc6cb5bc0655e21611
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-ansi-regex/5.0.1-1~deb11u1/ (for browsing the source)
- https://sources.debian.net/src/node-ansi-regex/5.0.1-1~deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-ansi-regex/5.0.1-1~deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-ansi-styles=4.2.1-1`

Binary Packages:

- `node-ansi-styles=4.2.1-1`

Licenses: (parsed from: `/usr/share/doc/node-ansi-styles/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-ansi-styles=4.2.1-1
'http://deb.debian.org/debian/pool/main/n/node-ansi-styles/node-ansi-styles_4.2.1-1.dsc' node-ansi-styles_4.2.1-1.dsc 2125 SHA256:28c6f00029e5a71f7f9c60785026e85626aa599f51f21cbb92fcc596b670f2bc
'http://deb.debian.org/debian/pool/main/n/node-ansi-styles/node-ansi-styles_4.2.1.orig.tar.gz' node-ansi-styles_4.2.1.orig.tar.gz 8492 SHA256:030c2de5c2564bb470d537540d12f3a0182f086afe07753032389bdcc1a77191
'http://deb.debian.org/debian/pool/main/n/node-ansi-styles/node-ansi-styles_4.2.1-1.debian.tar.xz' node-ansi-styles_4.2.1-1.debian.tar.xz 3920 SHA256:c43c2f17829bb4c7c1289d128f82f99b6875c209cb54cfb04fe216c24726b6f1
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-ansi-styles/4.2.1-1/ (for browsing the source)
- https://sources.debian.net/src/node-ansi-styles/4.2.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-ansi-styles/4.2.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-ansi=0.3.1-1`

Binary Packages:

- `node-ansi=0.3.1-1`

Licenses: (parsed from: `/usr/share/doc/node-ansi/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-ansi=0.3.1-1
'http://deb.debian.org/debian/pool/main/n/node-ansi/node-ansi_0.3.1-1.dsc' node-ansi_0.3.1-1.dsc 1992 SHA256:1d2b200d63089fac029143f0961d983824abb26c11a764b99647ed1beb5aad09
'http://deb.debian.org/debian/pool/main/n/node-ansi/node-ansi_0.3.1.orig.tar.gz' node-ansi_0.3.1.orig.tar.gz 7161 SHA256:4c15b8ab78b1ad9eda5ba3c23a42610c5eddfe7302d65a617694c53f1b345427
'http://deb.debian.org/debian/pool/main/n/node-ansi/node-ansi_0.3.1-1.debian.tar.xz' node-ansi_0.3.1-1.debian.tar.xz 3328 SHA256:dc81cb616981995c78f4ad6431597c9c3eea011d40777cbe61c48624bc135a17
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-ansi/0.3.1-1/ (for browsing the source)
- https://sources.debian.net/src/node-ansi/0.3.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-ansi/0.3.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-ansistyles=0.1.3-2`

Binary Packages:

- `node-ansistyles=0.1.3-2`

Licenses: (parsed from: `/usr/share/doc/node-ansistyles/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-ansistyles=0.1.3-2
'http://deb.debian.org/debian/pool/main/n/node-ansistyles/node-ansistyles_0.1.3-2.dsc' node-ansistyles_0.1.3-2.dsc 2061 SHA256:37a0692e83a4abdf62a717a525ef5607c1b381e8b76ae4b38a6e9bfe612f05fc
'http://deb.debian.org/debian/pool/main/n/node-ansistyles/node-ansistyles_0.1.3.orig.tar.gz' node-ansistyles_0.1.3.orig.tar.gz 2964 SHA256:854d6f5315ae0687570a8243ab3cc1350e05178c78851a539084e5c39472f748
'http://deb.debian.org/debian/pool/main/n/node-ansistyles/node-ansistyles_0.1.3-2.debian.tar.xz' node-ansistyles_0.1.3-2.debian.tar.xz 2452 SHA256:1c885c8c549b031995eb69db96589e815e389dcbeb3c86e81ae92f283207ff33
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-ansistyles/0.1.3-2/ (for browsing the source)
- https://sources.debian.net/src/node-ansistyles/0.1.3-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-ansistyles/0.1.3-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-aproba=2.0.0-1`

Binary Packages:

- `node-aproba=2.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-aproba/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-aproba=2.0.0-1
'http://deb.debian.org/debian/pool/main/n/node-aproba/node-aproba_2.0.0-1.dsc' node-aproba_2.0.0-1.dsc 2029 SHA256:e810245aa4f8a5e18ad496d47b7760c4bf7d559e49dd311b715f9f1d1b1afd85
'http://deb.debian.org/debian/pool/main/n/node-aproba/node-aproba_2.0.0.orig.tar.gz' node-aproba_2.0.0.orig.tar.gz 33506 SHA256:12e12704f9fc2d7d46601fdeb25f8234d77a388115695c7f91110ee0407aa889
'http://deb.debian.org/debian/pool/main/n/node-aproba/node-aproba_2.0.0-1.debian.tar.xz' node-aproba_2.0.0-1.debian.tar.xz 2384 SHA256:910c7f8cc28ddf1f838d04e6a4f179056f1f90218cec758509dc9921fcfb047b
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-aproba/2.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-aproba/2.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-aproba/2.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-archy=1.0.0-3`

Binary Packages:

- `node-archy=1.0.0-3`

Licenses: (parsed from: `/usr/share/doc/node-archy/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-archy=1.0.0-3
'http://deb.debian.org/debian/pool/main/n/node-archy/node-archy_1.0.0-3.dsc' node-archy_1.0.0-3.dsc 2019 SHA256:0726caa6cf6fc8535d8d7b354cc055ae03d82120295cffff876b8b1202fc13d3
'http://deb.debian.org/debian/pool/main/n/node-archy/node-archy_1.0.0.orig.tar.gz' node-archy_1.0.0.orig.tar.gz 2989 SHA256:2ccb1751986471628a55454c52ba749fbc4334ccd4ce02175e71917f7c222c79
'http://deb.debian.org/debian/pool/main/n/node-archy/node-archy_1.0.0-3.debian.tar.xz' node-archy_1.0.0-3.debian.tar.xz 2724 SHA256:60c777b9864a6613aa427d762ec35d6db7cc66d54ac5dcbf878cb3b8ee5fe7a5
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-archy/1.0.0-3/ (for browsing the source)
- https://sources.debian.net/src/node-archy/1.0.0-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-archy/1.0.0-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-are-we-there-yet=1.1.5-1`

Binary Packages:

- `node-are-we-there-yet=1.1.5-1`

Licenses: (parsed from: `/usr/share/doc/node-are-we-there-yet/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-are-we-there-yet=1.1.5-1
'http://deb.debian.org/debian/pool/main/n/node-are-we-there-yet/node-are-we-there-yet_1.1.5-1.dsc' node-are-we-there-yet_1.1.5-1.dsc 2208 SHA256:57457ad5ac83a59c58f050539f3038d18e2cf9d8f5b9ec9b5da05ef126c9d54c
'http://deb.debian.org/debian/pool/main/n/node-are-we-there-yet/node-are-we-there-yet_1.1.5.orig.tar.gz' node-are-we-there-yet_1.1.5.orig.tar.gz 36663 SHA256:b1780bd49bb7609f8fdae0ae3900758a0b96c129ddfb038ea096b6e4921715ba
'http://deb.debian.org/debian/pool/main/n/node-are-we-there-yet/node-are-we-there-yet_1.1.5-1.debian.tar.xz' node-are-we-there-yet_1.1.5-1.debian.tar.xz 2652 SHA256:f7dfd33f625758cca90172beb71b23e492001e6d6ad5d60821976eb81eed0b1a
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-are-we-there-yet/1.1.5-1/ (for browsing the source)
- https://sources.debian.net/src/node-are-we-there-yet/1.1.5-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-are-we-there-yet/1.1.5-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-asap=2.0.6-2`

Binary Packages:

- `node-asap=2.0.6-2`

Licenses: (parsed from: `/usr/share/doc/node-asap/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-asap=2.0.6-2
'http://deb.debian.org/debian/pool/main/n/node-asap/node-asap_2.0.6-2.dsc' node-asap_2.0.6-2.dsc 2001 SHA256:d492d57c4dbb6a0fcf8c133bcbb53a7f0982462ed45e739581c63f635a49eba9
'http://deb.debian.org/debian/pool/main/n/node-asap/node-asap_2.0.6.orig.tar.gz' node-asap_2.0.6.orig.tar.gz 39620 SHA256:cf3b8a7310458bc078688ee6278a8fca567b32641994ff5b1c2b714d5e1eb90c
'http://deb.debian.org/debian/pool/main/n/node-asap/node-asap_2.0.6-2.debian.tar.xz' node-asap_2.0.6-2.debian.tar.xz 2568 SHA256:8bda212b137ffbd806e0f16500c7f9e8fe7dc5508cd85c480fe55988b6876ccb
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-asap/2.0.6-2/ (for browsing the source)
- https://sources.debian.net/src/node-asap/2.0.6-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-asap/2.0.6-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-asn1=0.2.3-2`

Binary Packages:

- `node-asn1=0.2.3-2`

Licenses: (parsed from: `/usr/share/doc/node-asn1/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-asn1=0.2.3-2
'http://deb.debian.org/debian/pool/main/n/node-asn1/node-asn1_0.2.3-2.dsc' node-asn1_0.2.3-2.dsc 1997 SHA256:eebd46aa1af97f3a975f4afa1ed5af9750929db9516588f9c7550b392ec71a37
'http://deb.debian.org/debian/pool/main/n/node-asn1/node-asn1_0.2.3.orig.tar.gz' node-asn1_0.2.3.orig.tar.gz 7931 SHA256:45ab08e7614dfe11caeda2b869602a5cd7fc777a01968ac101f239db0c9ea19c
'http://deb.debian.org/debian/pool/main/n/node-asn1/node-asn1_0.2.3-2.debian.tar.xz' node-asn1_0.2.3-2.debian.tar.xz 2544 SHA256:7ef4ca32c9d8f822aefce76eee063cfd2c76177d85f46c5a2b7e945d925f2c66
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-asn1/0.2.3-2/ (for browsing the source)
- https://sources.debian.net/src/node-asn1/0.2.3-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-asn1/0.2.3-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-assert-plus=1.0.0-2`

Binary Packages:

- `node-assert-plus=1.0.0-2`

Licenses: (parsed from: `/usr/share/doc/node-assert-plus/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-assert-plus=1.0.0-2
'http://deb.debian.org/debian/pool/main/n/node-assert-plus/node-assert-plus_1.0.0-2.dsc' node-assert-plus_1.0.0-2.dsc 2104 SHA256:02c7a2e35da837e721dba9c762e982e9f44cd91c8855dba4c649cbce9847f963
'http://deb.debian.org/debian/pool/main/n/node-assert-plus/node-assert-plus_1.0.0.orig.tar.gz' node-assert-plus_1.0.0.orig.tar.gz 8863 SHA256:d20d505d91a1f131ce88f963ed2e784e6e8451207528406a81ef52ab5a019420
'http://deb.debian.org/debian/pool/main/n/node-assert-plus/node-assert-plus_1.0.0-2.debian.tar.xz' node-assert-plus_1.0.0-2.debian.tar.xz 2708 SHA256:1f666ad59af38f062f28df0776212d721ac8f9041ced1e4ec11719131f1098a2
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-assert-plus/1.0.0-2/ (for browsing the source)
- https://sources.debian.net/src/node-assert-plus/1.0.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-assert-plus/1.0.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-asynckit=0.4.0-3`

Binary Packages:

- `node-asynckit=0.4.0-3`

Licenses: (parsed from: `/usr/share/doc/node-asynckit/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-asynckit=0.4.0-3
'http://deb.debian.org/debian/pool/main/n/node-asynckit/node-asynckit_0.4.0-3.dsc' node-asynckit_0.4.0-3.dsc 2065 SHA256:854f4f64c3f3d52af908ce2b3d3c7953554b984b6d3d5cfbb385dd628d3bb06b
'http://deb.debian.org/debian/pool/main/n/node-asynckit/node-asynckit_0.4.0.orig.tar.gz' node-asynckit_0.4.0.orig.tar.gz 19795 SHA256:7512bb764eb128d4b0043de0630cacb87f48c3fa6f3a25e22fbfb24bc95a59f1
'http://deb.debian.org/debian/pool/main/n/node-asynckit/node-asynckit_0.4.0-3.debian.tar.xz' node-asynckit_0.4.0-3.debian.tar.xz 2724 SHA256:4f49658788ed79b0cc56abe390f2fd93c9acc6c5cdb0f3f9cff5e8648ffa506b
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-asynckit/0.4.0-3/ (for browsing the source)
- https://sources.debian.net/src/node-asynckit/0.4.0-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-asynckit/0.4.0-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-aws-sign2=0.7.1-2`

Binary Packages:

- `node-aws-sign2=0.7.1-2`

Licenses: (parsed from: `/usr/share/doc/node-aws-sign2/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris node-aws-sign2=0.7.1-2
'http://deb.debian.org/debian/pool/main/n/node-aws-sign2/node-aws-sign2_0.7.1-2.dsc' node-aws-sign2_0.7.1-2.dsc 2089 SHA256:6e80f551a57f4a8be83483e061258df20c1e25a885428c99af964bea4e055154
'http://deb.debian.org/debian/pool/main/n/node-aws-sign2/node-aws-sign2_0.7.1.orig.tar.gz' node-aws-sign2_0.7.1.orig.tar.gz 5279 SHA256:5c68c7e66f38a4f7dc0a1a1330c488b68d68bb6e4433d508e2417df394413959
'http://deb.debian.org/debian/pool/main/n/node-aws-sign2/node-aws-sign2_0.7.1-2.debian.tar.xz' node-aws-sign2_0.7.1-2.debian.tar.xz 2292 SHA256:9d9e54e03dd99ed6e0db90a36a7f4143a98b8ad9e36e446f8b803251b04a9a76
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-aws-sign2/0.7.1-2/ (for browsing the source)
- https://sources.debian.net/src/node-aws-sign2/0.7.1-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-aws-sign2/0.7.1-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-aws4=1.11.0-1`

Binary Packages:

- `node-aws4=1.11.0-1`

Licenses: (parsed from: `/usr/share/doc/node-aws4/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-aws4=1.11.0-1
'http://deb.debian.org/debian/pool/main/n/node-aws4/node-aws4_1.11.0-1.dsc' node-aws4_1.11.0-1.dsc 2042 SHA256:f987a5040f8fe5bae4dba74b20da449adea85d88bf9486fe1f3ecf223d7b25c2
'http://deb.debian.org/debian/pool/main/n/node-aws4/node-aws4_1.11.0.orig.tar.gz' node-aws4_1.11.0.orig.tar.gz 40381 SHA256:b72ccab90e9945f564161bd4c085372af6501d7d2721be2f5a619b761e054acb
'http://deb.debian.org/debian/pool/main/n/node-aws4/node-aws4_1.11.0-1.debian.tar.xz' node-aws4_1.11.0-1.debian.tar.xz 2984 SHA256:d74c4f73b5a1771bbf62316cb07c3880130f3ce474a7d0a66c74675742edab20
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-aws4/1.11.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-aws4/1.11.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-aws4/1.11.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-balanced-match=1.0.0-1`

Binary Packages:

- `node-balanced-match=1.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-balanced-match/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-balanced-match=1.0.0-1
'http://deb.debian.org/debian/pool/main/n/node-balanced-match/node-balanced-match_1.0.0-1.dsc' node-balanced-match_1.0.0-1.dsc 2129 SHA256:38574c2b8ca077af94926eec8b842c7c6e87773735954ecfe4512ef0e89eee1c
'http://deb.debian.org/debian/pool/main/n/node-balanced-match/node-balanced-match_1.0.0.orig.tar.gz' node-balanced-match_1.0.0.orig.tar.gz 3770 SHA256:d2a0f9ecc4371d97ce39d9cab188f3afe8e68fe53215e2f89a807b2cad6b1f6b
'http://deb.debian.org/debian/pool/main/n/node-balanced-match/node-balanced-match_1.0.0-1.debian.tar.xz' node-balanced-match_1.0.0-1.debian.tar.xz 2888 SHA256:b66eb328c74b4c5ab5dec3455efc64f520719710a9a58f64fdb047042fe6834c
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-balanced-match/1.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-balanced-match/1.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-balanced-match/1.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-bcrypt-pbkdf=1.0.2-1`

Binary Packages:

- `node-bcrypt-pbkdf=1.0.2-1`

Licenses: (parsed from: `/usr/share/doc/node-bcrypt-pbkdf/copyright`)

- `BSD-3-Clause`
- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-bcrypt-pbkdf=1.0.2-1
'http://deb.debian.org/debian/pool/main/n/node-bcrypt-pbkdf/node-bcrypt-pbkdf_1.0.2-1.dsc' node-bcrypt-pbkdf_1.0.2-1.dsc 2085 SHA256:379d451080866be5aa523083cd18a3e0ba9fae22db66c63323033ebd1ef910be
'http://deb.debian.org/debian/pool/main/n/node-bcrypt-pbkdf/node-bcrypt-pbkdf_1.0.2.orig.tar.gz' node-bcrypt-pbkdf_1.0.2.orig.tar.gz 11109 SHA256:e13e9e9f5d438223a02a906e6b77dfc97985a4ccf469ddb65261012973f07826
'http://deb.debian.org/debian/pool/main/n/node-bcrypt-pbkdf/node-bcrypt-pbkdf_1.0.2-1.debian.tar.xz' node-bcrypt-pbkdf_1.0.2-1.debian.tar.xz 2988 SHA256:baeb3731c154bff334e8f90674baab17ae46cfda283e31261a4782ad17823ad5
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-bcrypt-pbkdf/1.0.2-1/ (for browsing the source)
- https://sources.debian.net/src/node-bcrypt-pbkdf/1.0.2-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-bcrypt-pbkdf/1.0.2-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-brace-expansion=2.0.0-1`

Binary Packages:

- `node-brace-expansion=2.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-brace-expansion/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-brace-expansion=2.0.0-1
'http://deb.debian.org/debian/pool/main/n/node-brace-expansion/node-brace-expansion_2.0.0-1.dsc' node-brace-expansion_2.0.0-1.dsc 2168 SHA256:1340067dc4b3b5d1c492c85cd8822ac862e63573e8a916aed49b223f2cf9c7ef
'http://deb.debian.org/debian/pool/main/n/node-brace-expansion/node-brace-expansion_2.0.0.orig.tar.gz' node-brace-expansion_2.0.0.orig.tar.gz 14715 SHA256:59bf261f72821a85c29a81f9ae0b7732ee0d4159650c2cbf744793a47fa7a4a0
'http://deb.debian.org/debian/pool/main/n/node-brace-expansion/node-brace-expansion_2.0.0-1.debian.tar.xz' node-brace-expansion_2.0.0-1.debian.tar.xz 2852 SHA256:2680ff3bebeb6ca21a0d14a9be896155e31a5c170326e060017221b5eef58308
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-brace-expansion/2.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-brace-expansion/2.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-brace-expansion/2.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-builtins=1.0.3-2`

Binary Packages:

- `node-builtins=1.0.3-2`

Licenses: (parsed from: `/usr/share/doc/node-builtins/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-builtins=1.0.3-2
'http://deb.debian.org/debian/pool/main/n/node-builtins/node-builtins_1.0.3-2.dsc' node-builtins_1.0.3-2.dsc 2032 SHA256:e456d0b17faa6dd1e4b1c6b9048bf1e65b127b25b15629336084b8f7bfbfcf46
'http://deb.debian.org/debian/pool/main/n/node-builtins/node-builtins_1.0.3.orig.tar.gz' node-builtins_1.0.3.orig.tar.gz 1763 SHA256:b529a11b9e884676e0b7c22c10c53f7f5de024bfa3f3a50505beca96c5235c09
'http://deb.debian.org/debian/pool/main/n/node-builtins/node-builtins_1.0.3-2.debian.tar.xz' node-builtins_1.0.3-2.debian.tar.xz 2368 SHA256:502bd413a754766bc86cf12ddc5cdb4b708393985db20cdf42607be01c9d5b00
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-builtins/1.0.3-2/ (for browsing the source)
- https://sources.debian.net/src/node-builtins/1.0.3-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-builtins/1.0.3-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-cacache=15.0.5+~cs13.9.21-1`

Binary Packages:

- `node-cacache=15.0.5+~cs13.9.21-1`

Licenses: (parsed from: `/usr/share/doc/node-cacache/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-cacache=15.0.5+~cs13.9.21-1
'http://deb.debian.org/debian/pool/main/n/node-cacache/node-cacache_15.0.5%2b%7ecs13.9.21-1.dsc' node-cacache_15.0.5+~cs13.9.21-1.dsc 5347 SHA256:81ca7b53892566fc570a970b76b7e01f6d66df0ac78ce4f81d18af9603e2a63a
'http://deb.debian.org/debian/pool/main/n/node-cacache/node-cacache_15.0.5%2b%7ecs13.9.21.orig-figgy-pudding.tar.gz' node-cacache_15.0.5+~cs13.9.21.orig-figgy-pudding.tar.gz 6414 SHA256:997de16d9f14d88a5dcd6e7b0216cb91af7152c771c4bad73819eba8aafee16c
'http://deb.debian.org/debian/pool/main/n/node-cacache/node-cacache_15.0.5%2b%7ecs13.9.21.orig-fs-minipass.tar.gz' node-cacache_15.0.5+~cs13.9.21.orig-fs-minipass.tar.gz 35270 SHA256:83cf7dc113dacdbe3a2d05753edde01c37256cc97167ea5a8086ab85a78f2efd
'http://deb.debian.org/debian/pool/main/n/node-cacache/node-cacache_15.0.5%2b%7ecs13.9.21.orig-infer-owner.tar.gz' node-cacache_15.0.5+~cs13.9.21.orig-infer-owner.tar.gz 24073 SHA256:c7baff0c5b4c3c7af772be0b33087f3c16cf8fcce3459cd82a8481133765c2c2
'http://deb.debian.org/debian/pool/main/n/node-cacache/node-cacache_15.0.5%2b%7ecs13.9.21.orig-minipass-collect.tar.gz' node-cacache_15.0.5+~cs13.9.21.orig-minipass-collect.tar.gz 2057 SHA256:a5af655aa0a27bd67ca376484abcfe80fe97fb45638fe521c91d70aba3c0a0d4
'http://deb.debian.org/debian/pool/main/n/node-cacache/node-cacache_15.0.5%2b%7ecs13.9.21.orig-minipass-flush.tar.gz' node-cacache_15.0.5+~cs13.9.21.orig-minipass-flush.tar.gz 30652 SHA256:90cc5b52e97813d2895847ae25734e4c1bdd0e071e7fd00c4d95b01a24e7d6dc
'http://deb.debian.org/debian/pool/main/n/node-cacache/node-cacache_15.0.5%2b%7ecs13.9.21.orig-minipass-pipeline.tar.gz' node-cacache_15.0.5+~cs13.9.21.orig-minipass-pipeline.tar.gz 3001 SHA256:0b64f23832fd6391b879182615c6d0363371b0df2fa37a7d63e30903b156078f
'http://deb.debian.org/debian/pool/main/n/node-cacache/node-cacache_15.0.5%2b%7ecs13.9.21.orig-minipass.tar.gz' node-cacache_15.0.5+~cs13.9.21.orig-minipass.tar.gz 50240 SHA256:496598d78b824ddb3116c4a4fe0123516b318eab820d0ee80cb892ef3ba0c4c9
'http://deb.debian.org/debian/pool/main/n/node-cacache/node-cacache_15.0.5%2b%7ecs13.9.21.orig-npmcli-move-file.tar.gz' node-cacache_15.0.5+~cs13.9.21.orig-npmcli-move-file.tar.gz 31436 SHA256:717d3315320139b1d968f890825cd28c220e2cb71138ccb2d9dbf8d0202bd018
'http://deb.debian.org/debian/pool/main/n/node-cacache/node-cacache_15.0.5%2b%7ecs13.9.21.orig.tar.gz' node-cacache_15.0.5+~cs13.9.21.orig.tar.gz 121287 SHA256:229dc41f0f2d2f8efa33368ad163b2c499775ee4efab157b31f945cd5ce72104
'http://deb.debian.org/debian/pool/main/n/node-cacache/node-cacache_15.0.5%2b%7ecs13.9.21-1.debian.tar.xz' node-cacache_15.0.5+~cs13.9.21-1.debian.tar.xz 4552 SHA256:fc23903cc57302202f49898d6d54d25a8eee94a4ab6d83710c0f735f874f3cc7
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-cacache/15.0.5+~cs13.9.21-1/ (for browsing the source)
- https://sources.debian.net/src/node-cacache/15.0.5+~cs13.9.21-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-cacache/15.0.5+~cs13.9.21-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-caseless=0.12.1-1`

Binary Packages:

- `node-caseless=0.12.1-1`

Licenses: (parsed from: `/usr/share/doc/node-caseless/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris node-caseless=0.12.1-1
'http://deb.debian.org/debian/pool/main/n/node-caseless/node-caseless_0.12.1-1.dsc' node-caseless_0.12.1-1.dsc 2047 SHA256:1aa2d955bc3f2599a065875121fb9031702215de87b7deb48fc3cb9aebd1f122
'http://deb.debian.org/debian/pool/main/n/node-caseless/node-caseless_0.12.1.orig.tar.gz' node-caseless_0.12.1.orig.tar.gz 5435 SHA256:8ee4b1b25a536cc57a5baa3435bc16737a5bfabdd95a342eb7f760a2710f0dfa
'http://deb.debian.org/debian/pool/main/n/node-caseless/node-caseless_0.12.1-1.debian.tar.xz' node-caseless_0.12.1-1.debian.tar.xz 2208 SHA256:354b1bd138c2de945f3797c0c617fdf51a4e07816a37b105dea4bd760e13d4b1
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-caseless/0.12.1-1/ (for browsing the source)
- https://sources.debian.net/src/node-caseless/0.12.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-caseless/0.12.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-chalk=4.1.0-1`

Binary Packages:

- `node-chalk=4.1.0-1`

Licenses: (parsed from: `/usr/share/doc/node-chalk/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-chalk=4.1.0-1
'http://deb.debian.org/debian/pool/main/n/node-chalk/node-chalk_4.1.0-1.dsc' node-chalk_4.1.0-1.dsc 2247 SHA256:b8431d3fc9610729b1fd5a382a49aa3a11b00458d2f1e4e685a8fe100ee2939c
'http://deb.debian.org/debian/pool/main/n/node-chalk/node-chalk_4.1.0.orig.tar.gz' node-chalk_4.1.0.orig.tar.gz 74821 SHA256:3ce085943ea0bdaa5829c43c85e224004c36dd11f8823f2828a1f869493b5168
'http://deb.debian.org/debian/pool/main/n/node-chalk/node-chalk_4.1.0-1.debian.tar.xz' node-chalk_4.1.0-1.debian.tar.xz 7292 SHA256:a479641517f45a19c48d705df1786e2146c700f532d81a2b54c87bfd57679bf7
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-chalk/4.1.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-chalk/4.1.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-chalk/4.1.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-chownr=1.1.3-5`

Binary Packages:

- `node-chownr=1.1.3-5`

Licenses: (parsed from: `/usr/share/doc/node-chownr/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-chownr=1.1.3-5
'http://deb.debian.org/debian/pool/main/n/node-chownr/node-chownr_1.1.3-5.dsc' node-chownr_1.1.3-5.dsc 2084 SHA256:18a9fc7cdf60a775d3958f223fe9257c3955e2187e074f0459a5946fa4743bd0
'http://deb.debian.org/debian/pool/main/n/node-chownr/node-chownr_1.1.3.orig.tar.gz' node-chownr_1.1.3.orig.tar.gz 19425 SHA256:770877d49862189da451efd001471a9382f6ff9a02db00721a39d8b5b8f5a8a5
'http://deb.debian.org/debian/pool/main/n/node-chownr/node-chownr_1.1.3-5.debian.tar.xz' node-chownr_1.1.3-5.debian.tar.xz 3160 SHA256:ae8c3b7a27d7e9a347a3518430f377e40b0815307cd9251f21923f1d77fef31e
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-chownr/1.1.3-5/ (for browsing the source)
- https://sources.debian.net/src/node-chownr/1.1.3-5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-chownr/1.1.3-5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-clone=2.1.2-2`

Binary Packages:

- `node-clone=2.1.2-2`

Licenses: (parsed from: `/usr/share/doc/node-clone/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-clone=2.1.2-2
'http://deb.debian.org/debian/pool/main/n/node-clone/node-clone_2.1.2-2.dsc' node-clone_2.1.2-2.dsc 2018 SHA256:e516b5d8a8ed4cb14b3dce22f2058bb3f09eb22e1484ebd650f6817721dccd09
'http://deb.debian.org/debian/pool/main/n/node-clone/node-clone_2.1.2.orig.tar.gz' node-clone_2.1.2.orig.tar.gz 10348 SHA256:b085c427e4647b3eb688b9669ad9baabad4cbd216921bc0324b2d9bab16bec87
'http://deb.debian.org/debian/pool/main/n/node-clone/node-clone_2.1.2-2.debian.tar.xz' node-clone_2.1.2-2.debian.tar.xz 2448 SHA256:944856a87538dc9b6142ec1f2ff0682022245dcc0fcaa5cbc7044e5bdfdff310
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-clone/2.1.2-2/ (for browsing the source)
- https://sources.debian.net/src/node-clone/2.1.2-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-clone/2.1.2-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-color-convert=1.9.3-1`

Binary Packages:

- `node-color-convert=1.9.3-1`

Licenses: (parsed from: `/usr/share/doc/node-color-convert/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-color-convert=1.9.3-1
'http://deb.debian.org/debian/pool/main/n/node-color-convert/node-color-convert_1.9.3-1.dsc' node-color-convert_1.9.3-1.dsc 2177 SHA256:8864de2428807b716b610eccf3a72a79b5cbd3eec66584b54f4c3254524040d5
'http://deb.debian.org/debian/pool/main/n/node-color-convert/node-color-convert_1.9.3.orig.tar.gz' node-color-convert_1.9.3.orig.tar.gz 11708 SHA256:a60cd2a9d3bf3ccadc1b7675e9f8a4e96c218f4a59ecc4835847a9e1fd3aefc2
'http://deb.debian.org/debian/pool/main/n/node-color-convert/node-color-convert_1.9.3-1.debian.tar.xz' node-color-convert_1.9.3-1.debian.tar.xz 2208 SHA256:811048e63c0dac8c87a5d528460233487043bdded46096f48377d1e98548c97a
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-color-convert/1.9.3-1/ (for browsing the source)
- https://sources.debian.net/src/node-color-convert/1.9.3-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-color-convert/1.9.3-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-color-name=1.1.4+~1.1.1-1`

Binary Packages:

- `node-color-name=1.1.4+~1.1.1-1`

Licenses: (parsed from: `/usr/share/doc/node-color-name/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-color-name=1.1.4+~1.1.1-1
'http://deb.debian.org/debian/pool/main/n/node-color-name/node-color-name_1.1.4%2b%7e1.1.1-1.dsc' node-color-name_1.1.4+~1.1.1-1.dsc 2425 SHA256:da88a5d56087fc7f06877432d89e56545b98e07e1ac0d5259e466a91038ffb0b
'http://deb.debian.org/debian/pool/main/n/node-color-name/node-color-name_1.1.4%2b%7e1.1.1.orig-types-color-name.tar.gz' node-color-name_1.1.4+~1.1.1.orig-types-color-name.tar.gz 2296 SHA256:e4354b0e6737e6154ae0910f39f4a7cbe6d13c52b74617da66ac116ef3acc161
'http://deb.debian.org/debian/pool/main/n/node-color-name/node-color-name_1.1.4%2b%7e1.1.1.orig.tar.gz' node-color-name_1.1.4+~1.1.1.orig.tar.gz 4137 SHA256:cddf05f67ddc8d112ae0e60f4b52fa7e049d288635324b5fa5e385b7ade94fc7
'http://deb.debian.org/debian/pool/main/n/node-color-name/node-color-name_1.1.4%2b%7e1.1.1-1.debian.tar.xz' node-color-name_1.1.4+~1.1.1-1.debian.tar.xz 2828 SHA256:2ae20f67f205efa74a75baa96f7c3ee5d5779eac83072dd5ffac38ccefe3d25b
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-color-name/1.1.4+~1.1.1-1/ (for browsing the source)
- https://sources.debian.net/src/node-color-name/1.1.4+~1.1.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-color-name/1.1.4+~1.1.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-columnify=1.5.4-3`

Binary Packages:

- `node-columnify=1.5.4-3`

Licenses: (parsed from: `/usr/share/doc/node-columnify/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-columnify=1.5.4-3
'http://deb.debian.org/debian/pool/main/n/node-columnify/node-columnify_1.5.4-3.dsc' node-columnify_1.5.4-3.dsc 2143 SHA256:52f78ec29f908c4ffea51df685717c33eae7ec6e84c4d87ce76024b96d5ef158
'http://deb.debian.org/debian/pool/main/n/node-columnify/node-columnify_1.5.4.orig.tar.gz' node-columnify_1.5.4.orig.tar.gz 6140513 SHA256:d626e9b48c1c06a503cfbd6a1c11488cc104806fd84690a6033851de436d6409
'http://deb.debian.org/debian/pool/main/n/node-columnify/node-columnify_1.5.4-3.debian.tar.xz' node-columnify_1.5.4-3.debian.tar.xz 3312 SHA256:ce22889ea555f05329dc5b7fec7f2b7e8474889c007be03c4060c670c19f7c64
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-columnify/1.5.4-3/ (for browsing the source)
- https://sources.debian.net/src/node-columnify/1.5.4-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-columnify/1.5.4-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-combined-stream=1.0.8-1`

Binary Packages:

- `node-combined-stream=1.0.8-1`

Licenses: (parsed from: `/usr/share/doc/node-combined-stream/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-combined-stream=1.0.8-1
'http://deb.debian.org/debian/pool/main/n/node-combined-stream/node-combined-stream_1.0.8-1.dsc' node-combined-stream_1.0.8-1.dsc 2148 SHA256:45e6b727f1b7ee6467517d25146db071143c36e0270c6933c99dac896e4b6c9a
'http://deb.debian.org/debian/pool/main/n/node-combined-stream/node-combined-stream_1.0.8.orig.tar.gz' node-combined-stream_1.0.8.orig.tar.gz 6908 SHA256:398ed7e18797cf73d040d5199aea50cf3850bc3e1cd83e930d76f497d8120dd8
'http://deb.debian.org/debian/pool/main/n/node-combined-stream/node-combined-stream_1.0.8-1.debian.tar.xz' node-combined-stream_1.0.8-1.debian.tar.xz 2668 SHA256:872889f9df5472e6cb8107f9cb29e1ef45bbe2c8076a6e8e1413971f0aeec6b6
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-combined-stream/1.0.8-1/ (for browsing the source)
- https://sources.debian.net/src/node-combined-stream/1.0.8-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-combined-stream/1.0.8-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-concat-map=0.0.1-2`

Binary Packages:

- `node-concat-map=0.0.1-2`

Licenses: (parsed from: `/usr/share/doc/node-concat-map/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-concat-map=0.0.1-2
'http://deb.debian.org/debian/pool/main/n/node-concat-map/node-concat-map_0.0.1-2.dsc' node-concat-map_0.0.1-2.dsc 2082 SHA256:591212fa44b07eee33d60340cf39cf4e9ced1951f7b91ac303f276c354838269
'http://deb.debian.org/debian/pool/main/n/node-concat-map/node-concat-map_0.0.1.orig.tar.gz' node-concat-map_0.0.1.orig.tar.gz 2415 SHA256:936680ef8ac6b47aafce69c309091bbfdc8680ecf265c67dea25b725751b256f
'http://deb.debian.org/debian/pool/main/n/node-concat-map/node-concat-map_0.0.1-2.debian.tar.xz' node-concat-map_0.0.1-2.debian.tar.xz 2740 SHA256:18a1cd53f19a7f5e0c830d17a807d8600fa1f8ac00f2ec78723783a96beb0941
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-concat-map/0.0.1-2/ (for browsing the source)
- https://sources.debian.net/src/node-concat-map/0.0.1-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-concat-map/0.0.1-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-console-control-strings=1.1.0-2`

Binary Packages:

- `node-console-control-strings=1.1.0-2`

Licenses: (parsed from: `/usr/share/doc/node-console-control-strings/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-console-control-strings=1.1.0-2
'http://deb.debian.org/debian/pool/main/n/node-console-control-strings/node-console-control-strings_1.1.0-2.dsc' node-console-control-strings_1.1.0-2.dsc 2220 SHA256:e47e1bceadc8415cbc7ea2370a280b52cbd9275386b075212c68ff4221a2ce3b
'http://deb.debian.org/debian/pool/main/n/node-console-control-strings/node-console-control-strings_1.1.0.orig.tar.gz' node-console-control-strings_1.1.0.orig.tar.gz 4885 SHA256:241325a85f5a3057fb622bd113b310af5ebad8163929b2e42f9b6f6fa31c27cd
'http://deb.debian.org/debian/pool/main/n/node-console-control-strings/node-console-control-strings_1.1.0-2.debian.tar.xz' node-console-control-strings_1.1.0-2.debian.tar.xz 2364 SHA256:a76046708327edab44305d4f11f279ac60ed2a374be4d0b1807ccd56b67fc8f5
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-console-control-strings/1.1.0-2/ (for browsing the source)
- https://sources.debian.net/src/node-console-control-strings/1.1.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-console-control-strings/1.1.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-copy-concurrently=1.0.5-7`

Binary Packages:

- `node-copy-concurrently=1.0.5-7`

Licenses: (parsed from: `/usr/share/doc/node-copy-concurrently/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-copy-concurrently=1.0.5-7
'http://deb.debian.org/debian/pool/main/n/node-copy-concurrently/node-copy-concurrently_1.0.5-7.dsc' node-copy-concurrently_1.0.5-7.dsc 2277 SHA256:7a4f92cdd82f9e224a06fe209eddfae7d8d6d1e41a5d1149992b313af55bfd82
'http://deb.debian.org/debian/pool/main/n/node-copy-concurrently/node-copy-concurrently_1.0.5.orig.tar.gz' node-copy-concurrently_1.0.5.orig.tar.gz 7636 SHA256:03eae27bed0b6e09a904e5867323f2bb2ec7242f6a84af9e98fc5a4179495558
'http://deb.debian.org/debian/pool/main/n/node-copy-concurrently/node-copy-concurrently_1.0.5-7.debian.tar.xz' node-copy-concurrently_1.0.5-7.debian.tar.xz 3008 SHA256:fa603fcb89fe95a328ded02d09307d64fc20fb96446f145b99adc638a8f7a915
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-copy-concurrently/1.0.5-7/ (for browsing the source)
- https://sources.debian.net/src/node-copy-concurrently/1.0.5-7/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-copy-concurrently/1.0.5-7/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-core-util-is=1.0.2-2`

Binary Packages:

- `node-core-util-is=1.0.2-2`

Licenses: (parsed from: `/usr/share/doc/node-core-util-is/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-core-util-is=1.0.2-2
'http://deb.debian.org/debian/pool/main/n/node-core-util-is/node-core-util-is_1.0.2-2.dsc' node-core-util-is_1.0.2-2.dsc 2084 SHA256:221b29c1dcc98947c875e424b5b6815e1944b9826f2579bac34757ea8bf6f235
'http://deb.debian.org/debian/pool/main/n/node-core-util-is/node-core-util-is_1.0.2.orig.tar.gz' node-core-util-is_1.0.2.orig.tar.gz 7186 SHA256:c855798fa15c14571ee371a9e2b949c398b3d8e1699776ed71d46769ddd6d3ea
'http://deb.debian.org/debian/pool/main/n/node-core-util-is/node-core-util-is_1.0.2-2.debian.tar.xz' node-core-util-is_1.0.2-2.debian.tar.xz 3044 SHA256:8e6411a06902fa6c88f57c9e56de47b07f648df1b537329343f9be636c5da3e1
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-core-util-is/1.0.2-2/ (for browsing the source)
- https://sources.debian.net/src/node-core-util-is/1.0.2-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-core-util-is/1.0.2-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-dashdash=2.0.0-1`

Binary Packages:

- `node-dashdash=2.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-dashdash/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-dashdash=2.0.0-1
'http://deb.debian.org/debian/pool/main/n/node-dashdash/node-dashdash_2.0.0-1.dsc' node-dashdash_2.0.0-1.dsc 2080 SHA256:3d5c7994554687606a7e43888c434c5c9d5d0fa729219103a8e1382b324b07a9
'http://deb.debian.org/debian/pool/main/n/node-dashdash/node-dashdash_2.0.0.orig.tar.gz' node-dashdash_2.0.0.orig.tar.gz 69857 SHA256:f669a42fd997fb6106faa7e38769ef430df2c585a7cdbc3ea3d298108b20e265
'http://deb.debian.org/debian/pool/main/n/node-dashdash/node-dashdash_2.0.0-1.debian.tar.xz' node-dashdash_2.0.0-1.debian.tar.xz 2736 SHA256:f2baf71b19ca86d3b220d9270e8ca0ef2de22745747197a7417f978764c165d9
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-dashdash/2.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-dashdash/2.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-dashdash/2.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-debug=4.3.1+~cs4.1.5-1`

Binary Packages:

- `node-debug=4.3.1+~cs4.1.5-1`

Licenses: (parsed from: `/usr/share/doc/node-debug/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-debug=4.3.1+~cs4.1.5-1
'http://deb.debian.org/debian/pool/main/n/node-debug/node-debug_4.3.1%2b%7ecs4.1.5-1.dsc' node-debug_4.3.1+~cs4.1.5-1.dsc 2550 SHA256:fbdbd8ce9ac4f1081bb6a8cb88c91f88f07884288f1211d464dc92aace2b5d79
'http://deb.debian.org/debian/pool/main/n/node-debug/node-debug_4.3.1%2b%7ecs4.1.5.orig-typesdebug.tar.gz' node-debug_4.3.1+~cs4.1.5.orig-typesdebug.tar.gz 1960 SHA256:0e297ffcbe469f1c1607545011deda79e1db4d394a6e77c33ea939d4e3d78d87
'http://deb.debian.org/debian/pool/main/n/node-debug/node-debug_4.3.1%2b%7ecs4.1.5.orig.tar.gz' node-debug_4.3.1+~cs4.1.5.orig.tar.gz 14984 SHA256:d65db17f99b855ce6e3a25f515ed7dd9f863f6c093fe050491e826257a0bdc43
'http://deb.debian.org/debian/pool/main/n/node-debug/node-debug_4.3.1%2b%7ecs4.1.5-1.debian.tar.xz' node-debug_4.3.1+~cs4.1.5-1.debian.tar.xz 4440 SHA256:b82eb44452c1dcab12774f39690739ab68ffd9196464fd7f994068869e49014f
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-debug/4.3.1+~cs4.1.5-1/ (for browsing the source)
- https://sources.debian.net/src/node-debug/4.3.1+~cs4.1.5-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-debug/4.3.1+~cs4.1.5-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-defaults=1.0.3-2`

Binary Packages:

- `node-defaults=1.0.3-2`

Licenses: (parsed from: `/usr/share/doc/node-defaults/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-defaults=1.0.3-2
'http://deb.debian.org/debian/pool/main/n/node-defaults/node-defaults_1.0.3-2.dsc' node-defaults_1.0.3-2.dsc 2067 SHA256:bec6cd89e57f5cd3df21a2fe1f48330bda5b19eebb308c7442f7e28d232665fb
'http://deb.debian.org/debian/pool/main/n/node-defaults/node-defaults_1.0.3.orig.tar.gz' node-defaults_1.0.3.orig.tar.gz 2129 SHA256:7b24f7dc187c1b777852b9dcecf449c8a1a8dceeaa51717e4cc86344a881c1fc
'http://deb.debian.org/debian/pool/main/n/node-defaults/node-defaults_1.0.3-2.debian.tar.xz' node-defaults_1.0.3-2.debian.tar.xz 2544 SHA256:1221e231a208c63352970de1bbc74d33abc91e50b23d7cd808e76aa10e240fa0
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-defaults/1.0.3-2/ (for browsing the source)
- https://sources.debian.net/src/node-defaults/1.0.3-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-defaults/1.0.3-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-delayed-stream=1.0.0-4`

Binary Packages:

- `node-delayed-stream=1.0.0-4`

Licenses: (parsed from: `/usr/share/doc/node-delayed-stream/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-delayed-stream=1.0.0-4
'http://deb.debian.org/debian/pool/main/n/node-delayed-stream/node-delayed-stream_1.0.0-4.dsc' node-delayed-stream_1.0.0-4.dsc 2107 SHA256:fb3d9a98f59cc7c0c94543d42dba0293d460cec512190f44020551b9caae13c3
'http://deb.debian.org/debian/pool/main/n/node-delayed-stream/node-delayed-stream_1.0.0.orig.tar.gz' node-delayed-stream_1.0.0.orig.tar.gz 5088 SHA256:2357c6c908976d95c505d6c35ec251fc0fdf7aed294c5fc91b1e5ee222421adf
'http://deb.debian.org/debian/pool/main/n/node-delayed-stream/node-delayed-stream_1.0.0-4.debian.tar.xz' node-delayed-stream_1.0.0-4.debian.tar.xz 11648 SHA256:9465b133cdea2411bb801548f101ef01d35da4a72083114ed2f8e69dd60b8d73
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-delayed-stream/1.0.0-4/ (for browsing the source)
- https://sources.debian.net/src/node-delayed-stream/1.0.0-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-delayed-stream/1.0.0-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-delegates=1.0.0-2`

Binary Packages:

- `node-delegates=1.0.0-2`

Licenses: (parsed from: `/usr/share/doc/node-delegates/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-delegates=1.0.0-2
'http://deb.debian.org/debian/pool/main/n/node-delegates/node-delegates_1.0.0-2.dsc' node-delegates_1.0.0-2.dsc 2093 SHA256:ad7e6e2d33ea914dc38410b255a71ea4a4c6d1899ba98710bba70be916e8f96b
'http://deb.debian.org/debian/pool/main/n/node-delegates/node-delegates_1.0.0.orig.tar.gz' node-delegates_1.0.0.orig.tar.gz 2986 SHA256:0b21bd5fd489658c090e3b58160aec8a8537286fe0c739e90645dbd8558770e0
'http://deb.debian.org/debian/pool/main/n/node-delegates/node-delegates_1.0.0-2.debian.tar.xz' node-delegates_1.0.0-2.debian.tar.xz 3032 SHA256:d1a0671b06785e15e249ebf3cb6ae157465d124df500b0c81b93143bb695fc56
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-delegates/1.0.0-2/ (for browsing the source)
- https://sources.debian.net/src/node-delegates/1.0.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-delegates/1.0.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-depd=2.0.0-1`

Binary Packages:

- `node-depd=2.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-depd/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-depd=2.0.0-1
'http://deb.debian.org/debian/pool/main/n/node-depd/node-depd_2.0.0-1.dsc' node-depd_2.0.0-1.dsc 2086 SHA256:e730c04b24333a391240d560b48f688a51b2dbd7c61d6a18e28e9b51a3b88aa0
'http://deb.debian.org/debian/pool/main/n/node-depd/node-depd_2.0.0.orig.tar.gz' node-depd_2.0.0.orig.tar.gz 18669 SHA256:165bf0d97508cabad3c313d5099b00e2a6f71710198b26f32c369106b274bd32
'http://deb.debian.org/debian/pool/main/n/node-depd/node-depd_2.0.0-1.debian.tar.xz' node-depd_2.0.0-1.debian.tar.xz 2852 SHA256:24bcc1a4b0e6b106e8ff2dfbd56bf72231a9a6033af111b7361ac52be35eb7c0
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-depd/2.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-depd/2.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-depd/2.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-ecc-jsbn=0.2.0-2`

Binary Packages:

- `node-ecc-jsbn=0.2.0-2`

Licenses: (parsed from: `/usr/share/doc/node-ecc-jsbn/copyright`)

- `Expat`
- `Expat-mixed`

Source:

```console
$ apt-get source -qq --print-uris node-ecc-jsbn=0.2.0-2
'http://deb.debian.org/debian/pool/main/n/node-ecc-jsbn/node-ecc-jsbn_0.2.0-2.dsc' node-ecc-jsbn_0.2.0-2.dsc 2054 SHA256:65c78f3d52b70814412f2a7d32aeedb946dfeddb2742358bfe06c641c9336aec
'http://deb.debian.org/debian/pool/main/n/node-ecc-jsbn/node-ecc-jsbn_0.2.0.orig.tar.gz' node-ecc-jsbn_0.2.0.orig.tar.gz 8443 SHA256:c66088734f7a831f33f622b2786cb6e734aed094c60f07066adc4ddd0b45acdb
'http://deb.debian.org/debian/pool/main/n/node-ecc-jsbn/node-ecc-jsbn_0.2.0-2.debian.tar.xz' node-ecc-jsbn_0.2.0-2.debian.tar.xz 2892 SHA256:991a0f028b05ecdaeb68a8b43ceaeee5d8380cad2794292b2aa993645a5989a6
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-ecc-jsbn/0.2.0-2/ (for browsing the source)
- https://sources.debian.net/src/node-ecc-jsbn/0.2.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-ecc-jsbn/0.2.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-encoding=0.1.13-1`

Binary Packages:

- `node-encoding=0.1.13-1`

Licenses: (parsed from: `/usr/share/doc/node-encoding/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-encoding=0.1.13-1
'http://deb.debian.org/debian/pool/main/n/node-encoding/node-encoding_0.1.13-1.dsc' node-encoding_0.1.13-1.dsc 2105 SHA256:e7bac193a3f7c6eb781c82d33aacacbf77da4bcee73bdad323ad172f64123acd
'http://deb.debian.org/debian/pool/main/n/node-encoding/node-encoding_0.1.13.orig.tar.gz' node-encoding_0.1.13.orig.tar.gz 24239 SHA256:e77a675243aa707690be0b513eaf089d8f3044a07fc0b43727308f28087eb1e8
'http://deb.debian.org/debian/pool/main/n/node-encoding/node-encoding_0.1.13-1.debian.tar.xz' node-encoding_0.1.13-1.debian.tar.xz 2632 SHA256:ca985f86dade4f8708ad602f28fe816315f444a2a60c03c0dba6afa1ece2fd8d
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-encoding/0.1.13-1/ (for browsing the source)
- https://sources.debian.net/src/node-encoding/0.1.13-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-encoding/0.1.13-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-err-code=2.0.3+dfsg-1`

Binary Packages:

- `node-err-code=2.0.3+dfsg-1`

Licenses: (parsed from: `/usr/share/doc/node-err-code/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-err-code=2.0.3+dfsg-1
'http://deb.debian.org/debian/pool/main/n/node-err-code/node-err-code_2.0.3%2bdfsg-1.dsc' node-err-code_2.0.3+dfsg-1.dsc 2128 SHA256:5b2b0fdfaabebaf73ec4ccd4deaf8e1dc378a07b416504c0b3adcc25d17b4d2f
'http://deb.debian.org/debian/pool/main/n/node-err-code/node-err-code_2.0.3%2bdfsg.orig.tar.xz' node-err-code_2.0.3+dfsg.orig.tar.xz 31692 SHA256:5857fa74a97558fb279679a56583d91f431075bd06e4d99774f7581dd3b2598d
'http://deb.debian.org/debian/pool/main/n/node-err-code/node-err-code_2.0.3%2bdfsg-1.debian.tar.xz' node-err-code_2.0.3+dfsg-1.debian.tar.xz 2556 SHA256:8565b3e40a7c397a035f00ebed253a2df2906b06518ed99a906848bcf08db557
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-err-code/2.0.3+dfsg-1/ (for browsing the source)
- https://sources.debian.net/src/node-err-code/2.0.3+dfsg-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-err-code/2.0.3+dfsg-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-escape-string-regexp=4.0.0-1`

Binary Packages:

- `node-escape-string-regexp=4.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-escape-string-regexp/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-escape-string-regexp=4.0.0-1
'http://deb.debian.org/debian/pool/main/n/node-escape-string-regexp/node-escape-string-regexp_4.0.0-1.dsc' node-escape-string-regexp_4.0.0-1.dsc 2201 SHA256:2d7ace652d893c4e45a10f910e416cec4ae1fad3055e8944cf6bf05811b5c250
'http://deb.debian.org/debian/pool/main/n/node-escape-string-regexp/node-escape-string-regexp_4.0.0.orig.tar.gz' node-escape-string-regexp_4.0.0.orig.tar.gz 2982 SHA256:0e09412ccbfd5b35c849e23d1ba938dd22e09c1601b480bb39382b43250bf7df
'http://deb.debian.org/debian/pool/main/n/node-escape-string-regexp/node-escape-string-regexp_4.0.0-1.debian.tar.xz' node-escape-string-regexp_4.0.0-1.debian.tar.xz 3244 SHA256:1ce23b255483c5a0b8dca0329a4781d542d21d45a2d27b35f86811680431c638
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-escape-string-regexp/4.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-escape-string-regexp/4.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-escape-string-regexp/4.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-extend=3.0.2-1`

Binary Packages:

- `node-extend=3.0.2-1`

Licenses: (parsed from: `/usr/share/doc/node-extend/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-extend=3.0.2-1
'http://deb.debian.org/debian/pool/main/n/node-extend/node-extend_3.0.2-1.dsc' node-extend_3.0.2-1.dsc 2033 SHA256:e011a0708444aaced14d8c2b8def8912fc1f6cc2130604334add7f2326e122fc
'http://deb.debian.org/debian/pool/main/n/node-extend/node-extend_3.0.2.orig.tar.gz' node-extend_3.0.2.orig.tar.gz 9731 SHA256:1c23faab848ca8015d67fd84427e3126f8b3371c8e23df7e47750670bed3ad86
'http://deb.debian.org/debian/pool/main/n/node-extend/node-extend_3.0.2-1.debian.tar.xz' node-extend_3.0.2-1.debian.tar.xz 2892 SHA256:6ca7d44b92392224c631a14ccee0ae62f814337ee7e9fbf0a3b7e981dbafed6f
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-extend/3.0.2-1/ (for browsing the source)
- https://sources.debian.net/src/node-extend/3.0.2-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-extend/3.0.2-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-extsprintf=1.4.0-1`

Binary Packages:

- `node-extsprintf=1.4.0-1`

Licenses: (parsed from: `/usr/share/doc/node-extsprintf/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-extsprintf=1.4.0-1
'http://deb.debian.org/debian/pool/main/n/node-extsprintf/node-extsprintf_1.4.0-1.dsc' node-extsprintf_1.4.0-1.dsc 2391 SHA256:f1340d84e372603f62046f9127309307c8ed881be9374ff07ad65d8f576f1f7b
'http://deb.debian.org/debian/pool/main/n/node-extsprintf/node-extsprintf_1.4.0.orig-types-extsprintf.tar.gz' node-extsprintf_1.4.0.orig-types-extsprintf.tar.gz 1553 SHA256:f928d75d46d75e43470ef04e306b147f2282afe1cf22daaedc23ef2abaa813cf
'http://deb.debian.org/debian/pool/main/n/node-extsprintf/node-extsprintf_1.4.0.orig.tar.gz' node-extsprintf_1.4.0.orig.tar.gz 11414 SHA256:97352f94d09d004a9a2d80ab9c54bb38b4a2aa0f91377d9d6a9b1d664f179c6d
'http://deb.debian.org/debian/pool/main/n/node-extsprintf/node-extsprintf_1.4.0-1.debian.tar.xz' node-extsprintf_1.4.0-1.debian.tar.xz 2860 SHA256:02cede0b6e98735ad09c116cbf95fd92adcb3c4f1e7702596a5cc8e05baea813
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-extsprintf/1.4.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-extsprintf/1.4.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-extsprintf/1.4.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-fast-deep-equal=3.1.3-1`

Binary Packages:

- `node-fast-deep-equal=3.1.3-1`

Licenses: (parsed from: `/usr/share/doc/node-fast-deep-equal/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-fast-deep-equal=3.1.3-1
'http://deb.debian.org/debian/pool/main/n/node-fast-deep-equal/node-fast-deep-equal_3.1.3-1.dsc' node-fast-deep-equal_3.1.3-1.dsc 2186 SHA256:c666c1919fca4f703bb287d99afeba92b9737dba733dbb128ac974307ed55de0
'http://deb.debian.org/debian/pool/main/n/node-fast-deep-equal/node-fast-deep-equal_3.1.3.orig.tar.gz' node-fast-deep-equal_3.1.3.orig.tar.gz 8979 SHA256:4804a51311fc6e537247723a4ddffc208da94abfe9296e9246f0d86e5afc2394
'http://deb.debian.org/debian/pool/main/n/node-fast-deep-equal/node-fast-deep-equal_3.1.3-1.debian.tar.xz' node-fast-deep-equal_3.1.3-1.debian.tar.xz 2728 SHA256:4f5c92e85766f094a0c6a8b296c49bcc176002d465230eb4789a56f8c585c9cc
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-fast-deep-equal/3.1.3-1/ (for browsing the source)
- https://sources.debian.net/src/node-fast-deep-equal/3.1.3-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-fast-deep-equal/3.1.3-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-forever-agent=0.6.1-2`

Binary Packages:

- `node-forever-agent=0.6.1-2`

Licenses: (parsed from: `/usr/share/doc/node-forever-agent/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris node-forever-agent=0.6.1-2
'http://deb.debian.org/debian/pool/main/n/node-forever-agent/node-forever-agent_0.6.1-2.dsc' node-forever-agent_0.6.1-2.dsc 2086 SHA256:99c7ae0e7082dcd22d10a32b3c4544316305bddb04a7aba94dcdd8b808f79475
'http://deb.debian.org/debian/pool/main/n/node-forever-agent/node-forever-agent_0.6.1.orig.tar.gz' node-forever-agent_0.6.1.orig.tar.gz 5151 SHA256:996c8a6ffcf9a7e360d98513f1f35dc10e888086cbd43690efd873d8ae6d8881
'http://deb.debian.org/debian/pool/main/n/node-forever-agent/node-forever-agent_0.6.1-2.debian.tar.xz' node-forever-agent_0.6.1-2.debian.tar.xz 2272 SHA256:a6138e6b01b6c77f9f3b6c06504acb95d21f56526fe73b63bbe4dc423142db86
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-forever-agent/0.6.1-2/ (for browsing the source)
- https://sources.debian.net/src/node-forever-agent/0.6.1-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-forever-agent/0.6.1-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-form-data=3.0.0-2`

Binary Packages:

- `node-form-data=3.0.0-2`

Licenses: (parsed from: `/usr/share/doc/node-form-data/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-form-data=3.0.0-2
'http://deb.debian.org/debian/pool/main/n/node-form-data/node-form-data_3.0.0-2.dsc' node-form-data_3.0.0-2.dsc 2197 SHA256:9a2c538b541366d7db209b5e922dba7d6bc6249feeba4fa448659fd1e3e509d8
'http://deb.debian.org/debian/pool/main/n/node-form-data/node-form-data_3.0.0.orig.tar.gz' node-form-data_3.0.0.orig.tar.gz 45949 SHA256:bef37a9bfefa290114c77a2ac03a924785df4f3bef5680686ca756656f72e216
'http://deb.debian.org/debian/pool/main/n/node-form-data/node-form-data_3.0.0-2.debian.tar.xz' node-form-data_3.0.0-2.debian.tar.xz 9036 SHA256:d7015e82b1de27b696470fd63ab2777551fa9c1a5416bcb4822e01a8cbf2e471
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-form-data/3.0.0-2/ (for browsing the source)
- https://sources.debian.net/src/node-form-data/3.0.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-form-data/3.0.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-fs-write-stream-atomic=1.0.10-4`

Binary Packages:

- `node-fs-write-stream-atomic=1.0.10-4`

Licenses: (parsed from: `/usr/share/doc/node-fs-write-stream-atomic/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-fs-write-stream-atomic=1.0.10-4
'http://deb.debian.org/debian/pool/main/n/node-fs-write-stream-atomic/node-fs-write-stream-atomic_1.0.10-4.dsc' node-fs-write-stream-atomic_1.0.10-4.dsc 2406 SHA256:6a386a82acd18f023910ef6abcee8ecf07b84a3d9ec77d87bcc15d60dc8be8da
'http://deb.debian.org/debian/pool/main/n/node-fs-write-stream-atomic/node-fs-write-stream-atomic_1.0.10.orig.tar.gz' node-fs-write-stream-atomic_1.0.10.orig.tar.gz 5770 SHA256:8f6b1777d32e058be2e53ccb5ff4699f47ebb0d796a61551e94c809e34ebcead
'http://deb.debian.org/debian/pool/main/n/node-fs-write-stream-atomic/node-fs-write-stream-atomic_1.0.10-4.debian.tar.xz' node-fs-write-stream-atomic_1.0.10-4.debian.tar.xz 2584 SHA256:4b857be828bf9d2bc36a00c1cd0c1e8bd181f5ee4b8bd5251816ccecedbbf7ed
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-fs-write-stream-atomic/1.0.10-4/ (for browsing the source)
- https://sources.debian.net/src/node-fs-write-stream-atomic/1.0.10-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-fs-write-stream-atomic/1.0.10-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-fs.realpath=1.0.0-1.1`

Binary Packages:

- `node-fs.realpath=1.0.0-1.1`

Licenses: (parsed from: `/usr/share/doc/node-fs.realpath/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-fs.realpath=1.0.0-1.1
'http://deb.debian.org/debian/pool/main/n/node-fs.realpath/node-fs.realpath_1.0.0-1.1.dsc' node-fs.realpath_1.0.0-1.1.dsc 2119 SHA256:656aa54919a002ee48f850f125052254d9b617748f8666066c0d532799a841cc
'http://deb.debian.org/debian/pool/main/n/node-fs.realpath/node-fs.realpath_1.0.0.orig.tar.gz' node-fs.realpath_1.0.0.orig.tar.gz 5149 SHA256:6216afeb56b7098cb0717cba38028d58dbefdc157348d12fe72cd45e13d6cb9b
'http://deb.debian.org/debian/pool/main/n/node-fs.realpath/node-fs.realpath_1.0.0-1.1.debian.tar.xz' node-fs.realpath_1.0.0-1.1.debian.tar.xz 2424 SHA256:415645df22b6aedea723c50b47394341b379ea2cf1e327501cf67efd2f9af126
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-fs.realpath/1.0.0-1.1/ (for browsing the source)
- https://sources.debian.net/src/node-fs.realpath/1.0.0-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-fs.realpath/1.0.0-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-function-bind=1.1.1+repack-1`

Binary Packages:

- `node-function-bind=1.1.1+repack-1`

Licenses: (parsed from: `/usr/share/doc/node-function-bind/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-function-bind=1.1.1+repack-1
'http://deb.debian.org/debian/pool/main/n/node-function-bind/node-function-bind_1.1.1%2brepack-1.dsc' node-function-bind_1.1.1+repack-1.dsc 2482 SHA256:419bbae827981861f23a9e3b12f6a469a46b50790a897ae58191f8a1d9ac5f9c
'http://deb.debian.org/debian/pool/main/n/node-function-bind/node-function-bind_1.1.1%2brepack.orig-has.tar.gz' node-function-bind_1.1.1+repack.orig-has.tar.gz 1948 SHA256:05b239542a4d331d5f2cfa465990573bb028aa260f4151424ad9e2436ed042d0
'http://deb.debian.org/debian/pool/main/n/node-function-bind/node-function-bind_1.1.1%2brepack.orig.tar.gz' node-function-bind_1.1.1+repack.orig.tar.gz 6306 SHA256:6c1b05a39b5e75d8461d0f15e8678d2150435e76b1bcb60122a48a3f25157b6c
'http://deb.debian.org/debian/pool/main/n/node-function-bind/node-function-bind_1.1.1%2brepack-1.debian.tar.xz' node-function-bind_1.1.1+repack-1.debian.tar.xz 3052 SHA256:1dafdcd9fe9698e5916fe1cdd14ed6ca7d1a8087c6f320d2ff15eb11ed4f7988
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-function-bind/1.1.1+repack-1/ (for browsing the source)
- https://sources.debian.net/src/node-function-bind/1.1.1+repack-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-function-bind/1.1.1+repack-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-gauge=2.7.4-1.1`

Binary Packages:

- `node-gauge=2.7.4-1.1`

Licenses: (parsed from: `/usr/share/doc/node-gauge/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-gauge=2.7.4-1.1
'http://deb.debian.org/debian/pool/main/n/node-gauge/node-gauge_2.7.4-1.1.dsc' node-gauge_2.7.4-1.1.dsc 2007 SHA256:527126330a2a10759027d27cf829fa702d821784f3f20fc2990794e23d1d3c61
'http://deb.debian.org/debian/pool/main/n/node-gauge/node-gauge_2.7.4.orig.tar.gz' node-gauge_2.7.4.orig.tar.gz 226137 SHA256:8777571c04373d5c6c1c86b2cd26969f6dfcd947f3ad2f83ba4213d320ae64df
'http://deb.debian.org/debian/pool/main/n/node-gauge/node-gauge_2.7.4-1.1.debian.tar.xz' node-gauge_2.7.4-1.1.debian.tar.xz 2388 SHA256:8991bd05b2e241a55a6720b231ca227612b66652fea6c15be8865bc2c3f0c3f2
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-gauge/2.7.4-1.1/ (for browsing the source)
- https://sources.debian.net/src/node-gauge/2.7.4-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-gauge/2.7.4-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-getpass=0.1.7-1.1`

Binary Packages:

- `node-getpass=0.1.7-1.1`

Licenses: (parsed from: `/usr/share/doc/node-getpass/copyright`)

- `Expat`
- `MPL-2.0`

Source:

```console
$ apt-get source -qq --print-uris node-getpass=0.1.7-1.1
'http://deb.debian.org/debian/pool/main/n/node-getpass/node-getpass_0.1.7-1.1.dsc' node-getpass_0.1.7-1.1.dsc 2061 SHA256:e32c9078cc4e3811945a8d301892bad8a9f2c36ce9b626390ba3fc20c290445e
'http://deb.debian.org/debian/pool/main/n/node-getpass/node-getpass_0.1.7.orig.tar.gz' node-getpass_0.1.7.orig.tar.gz 16348 SHA256:df42ac9ec7b22065fa15e69f1fe58b1c34d166ea6ee130a07163fe9c8cef4778
'http://deb.debian.org/debian/pool/main/n/node-getpass/node-getpass_0.1.7-1.1.debian.tar.xz' node-getpass_0.1.7-1.1.debian.tar.xz 2856 SHA256:ac75faf8ea4a4a7bb9e9c7c96936670b83c35fdd04dd98e333d991fb4fae00be
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-getpass/0.1.7-1.1/ (for browsing the source)
- https://sources.debian.net/src/node-getpass/0.1.7-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-getpass/0.1.7-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-glob=7.1.6+~7.1.3-1`

Binary Packages:

- `node-glob=7.1.6+~7.1.3-1`

Licenses: (parsed from: `/usr/share/doc/node-glob/copyright`)

- `CC-BY-SA-4.0`
- `Expat`
- `GPL-2`
- `GPL-2+`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-glob=7.1.6+~7.1.3-1
'http://deb.debian.org/debian/pool/main/n/node-glob/node-glob_7.1.6%2b%7e7.1.3-1.dsc' node-glob_7.1.6+~7.1.3-1.dsc 2637 SHA256:a01fd242a8c58bc5e63d89e499de102fcad4c44aa7fa9eded3aa66fb909b7e3e
'http://deb.debian.org/debian/pool/main/n/node-glob/node-glob_7.1.6%2b%7e7.1.3.orig-types-glob.tar.gz' node-glob_7.1.6+~7.1.3.orig-types-glob.tar.gz 2312 SHA256:fb8041194273fde85c003c6318fdcfdd7f448d042e9c5af1452aa2fbe6353881
'http://deb.debian.org/debian/pool/main/n/node-glob/node-glob_7.1.6%2b%7e7.1.3.orig.tar.gz' node-glob_7.1.6+~7.1.3.orig.tar.gz 944970 SHA256:a02a3f300f8586e999a37c578fdf37be2750f8bd14532bd4d927cb107a839d40
'http://deb.debian.org/debian/pool/main/n/node-glob/node-glob_7.1.6%2b%7e7.1.3-1.debian.tar.xz' node-glob_7.1.6+~7.1.3-1.debian.tar.xz 10756 SHA256:fd0b5570345c5990f44d0df3e89bd550ceb438c2fd853bc1fe9dd9f7b8b66db1
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-glob/7.1.6+~7.1.3-1/ (for browsing the source)
- https://sources.debian.net/src/node-glob/7.1.6+~7.1.3-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-glob/7.1.6+~7.1.3-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-graceful-fs=4.2.4+repack-1`

Binary Packages:

- `node-graceful-fs=4.2.4+repack-1`

Licenses: (parsed from: `/usr/share/doc/node-graceful-fs/copyright`)

- `BSD-2-clause`
- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-graceful-fs=4.2.4+repack-1
'http://deb.debian.org/debian/pool/main/n/node-graceful-fs/node-graceful-fs_4.2.4%2brepack-1.dsc' node-graceful-fs_4.2.4+repack-1.dsc 2505 SHA256:cf86800d7e9cec7281a7408c38bcb57fa40191b757f8cac47d2e99679ad84dbb
'http://deb.debian.org/debian/pool/main/n/node-graceful-fs/node-graceful-fs_4.2.4%2brepack.orig-types-graceful-fs.tar.gz' node-graceful-fs_4.2.4+repack.orig-types-graceful-fs.tar.gz 1832 SHA256:ebbb45a3819f0b6c7d200df882befa57c28574f29ff4a021f0c28a893668e5ca
'http://deb.debian.org/debian/pool/main/n/node-graceful-fs/node-graceful-fs_4.2.4%2brepack.orig.tar.gz' node-graceful-fs_4.2.4+repack.orig.tar.gz 35345 SHA256:0fa0855f75355935b66a5e5515b10871f6996bdcf517461e52b1eaa96b1876bb
'http://deb.debian.org/debian/pool/main/n/node-graceful-fs/node-graceful-fs_4.2.4%2brepack-1.debian.tar.xz' node-graceful-fs_4.2.4+repack-1.debian.tar.xz 4348 SHA256:7326099abdb39bd7bd71155c497e17148c1eb8051fb6a7d1e48954059b3ea922
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-graceful-fs/4.2.4+repack-1/ (for browsing the source)
- https://sources.debian.net/src/node-graceful-fs/4.2.4+repack-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-graceful-fs/4.2.4+repack-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-gyp=7.1.2-4`

Binary Packages:

- `node-gyp=7.1.2-4`

Licenses: (parsed from: `/usr/share/doc/node-gyp/copyright`)

- `BSD-3-clause~Google`
- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-gyp=7.1.2-4
'http://deb.debian.org/debian/pool/main/n/node-gyp/node-gyp_7.1.2-4.dsc' node-gyp_7.1.2-4.dsc 2075 SHA256:5936b410ba5b5485b826beee96b797af5cd48a69bf03bdcbedcbc301770b0a1f
'http://deb.debian.org/debian/pool/main/n/node-gyp/node-gyp_7.1.2.orig.tar.gz' node-gyp_7.1.2.orig.tar.gz 439880 SHA256:e9a42f7afa3e5386c1dee094b8751f6924e75d6921166d1cad6ebafc19c54957
'http://deb.debian.org/debian/pool/main/n/node-gyp/node-gyp_7.1.2-4.debian.tar.xz' node-gyp_7.1.2-4.debian.tar.xz 9776 SHA256:e2006b88e662ffbc18d95036adeb347acef5c9d36dda82162a3d89d1dc9c3f8e
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-gyp/7.1.2-4/ (for browsing the source)
- https://sources.debian.net/src/node-gyp/7.1.2-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-gyp/7.1.2-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-har-schema=2.0.0-4`

Binary Packages:

- `node-har-schema=2.0.0-4`

Licenses: (parsed from: `/usr/share/doc/node-har-schema/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-har-schema=2.0.0-4
'http://deb.debian.org/debian/pool/main/n/node-har-schema/node-har-schema_2.0.0-4.dsc' node-har-schema_2.0.0-4.dsc 2079 SHA256:c2a5918e781c244d4d3a3f2d2a52846c371efb9d489c9f06037109760a21b9ca
'http://deb.debian.org/debian/pool/main/n/node-har-schema/node-har-schema_2.0.0.orig.tar.gz' node-har-schema_2.0.0.orig.tar.gz 4493 SHA256:b39b9efedfe542e840066ef30599cc1f3c8348e52ad8ba7ead4062f44b111d09
'http://deb.debian.org/debian/pool/main/n/node-har-schema/node-har-schema_2.0.0-4.debian.tar.xz' node-har-schema_2.0.0-4.debian.tar.xz 2856 SHA256:d048527669986deb9cb21376d5737450dc25e10c4de629a0ad593620d8be0912
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-har-schema/2.0.0-4/ (for browsing the source)
- https://sources.debian.net/src/node-har-schema/2.0.0-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-har-schema/2.0.0-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-har-validator=5.1.5-1`

Binary Packages:

- `node-har-validator=5.1.5-1`

Licenses: (parsed from: `/usr/share/doc/node-har-validator/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-har-validator=5.1.5-1
'http://deb.debian.org/debian/pool/main/n/node-har-validator/node-har-validator_5.1.5-1.dsc' node-har-validator_5.1.5-1.dsc 2172 SHA256:d2c25aa1336541a0ee7940f67e82215b4215225d4788fde45e7f5e027abdc7e2
'http://deb.debian.org/debian/pool/main/n/node-har-validator/node-har-validator_5.1.5.orig.tar.gz' node-har-validator_5.1.5.orig.tar.gz 36307 SHA256:5d5703fb541b418e3962aebb174b96ddb88be761e86cda33fe73ada9416af6fb
'http://deb.debian.org/debian/pool/main/n/node-har-validator/node-har-validator_5.1.5-1.debian.tar.xz' node-har-validator_5.1.5-1.debian.tar.xz 2996 SHA256:a08d0cb8e7751fe343bbbe477474d2daf2dc324e6395e4dc4c5805085971faeb
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-har-validator/5.1.5-1/ (for browsing the source)
- https://sources.debian.net/src/node-har-validator/5.1.5-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-har-validator/5.1.5-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-has-flag=4.0.0-1`

Binary Packages:

- `node-has-flag=4.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-has-flag/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-has-flag=4.0.0-1
'http://deb.debian.org/debian/pool/main/n/node-has-flag/node-has-flag_4.0.0-1.dsc' node-has-flag_4.0.0-1.dsc 2060 SHA256:689776c64294402f4901470aaeb2ed4b399039d71a8cb4ce27d95cb91df6605d
'http://deb.debian.org/debian/pool/main/n/node-has-flag/node-has-flag_4.0.0.orig.tar.gz' node-has-flag_4.0.0.orig.tar.gz 2921 SHA256:ffdabbbfcc87e9e363c4a93df49dbec1a0cbff2a69ff22d0d435bdeaf0e78731
'http://deb.debian.org/debian/pool/main/n/node-has-flag/node-has-flag_4.0.0-1.debian.tar.xz' node-has-flag_4.0.0-1.debian.tar.xz 2748 SHA256:11a78fe532c9a96501eb2bf1d310a6812ceb66a6ff40d93814a4c4304a4c7217
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-has-flag/4.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-has-flag/4.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-has-flag/4.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-has-unicode=2.0.1-2`

Binary Packages:

- `node-has-unicode=2.0.1-2`

Licenses: (parsed from: `/usr/share/doc/node-has-unicode/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-has-unicode=2.0.1-2
'http://deb.debian.org/debian/pool/main/n/node-has-unicode/node-has-unicode_2.0.1-2.dsc' node-has-unicode_2.0.1-2.dsc 2078 SHA256:e0bd3af0ce7355bec56c8ef17a1d4ba521d200efd7bb3061513cfe182ac5a3ce
'http://deb.debian.org/debian/pool/main/n/node-has-unicode/node-has-unicode_2.0.1.orig.tar.gz' node-has-unicode_2.0.1.orig.tar.gz 2967 SHA256:e73c692073f7d96c1a0dee57be37b2219398a822fc153f5941480842cd2f7d22
'http://deb.debian.org/debian/pool/main/n/node-has-unicode/node-has-unicode_2.0.1-2.debian.tar.xz' node-has-unicode_2.0.1-2.debian.tar.xz 1924 SHA256:9d42138c6b5bbac5b25ee65bc8631f3765f00e92181186fd8dbbce73eecf21c6
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-has-unicode/2.0.1-2/ (for browsing the source)
- https://sources.debian.net/src/node-has-unicode/2.0.1-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-has-unicode/2.0.1-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-hosted-git-info=3.0.8-1`

Binary Packages:

- `node-hosted-git-info=3.0.8-1`

Licenses: (parsed from: `/usr/share/doc/node-hosted-git-info/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-hosted-git-info=3.0.8-1
'http://deb.debian.org/debian/pool/main/n/node-hosted-git-info/node-hosted-git-info_3.0.8-1.dsc' node-hosted-git-info_3.0.8-1.dsc 2190 SHA256:7842522e859af0329db583002ce64629bf7e77b0669a519ec5961da61489c135
'http://deb.debian.org/debian/pool/main/n/node-hosted-git-info/node-hosted-git-info_3.0.8.orig.tar.gz' node-hosted-git-info_3.0.8.orig.tar.gz 57265 SHA256:801858bfe28f538409e528a2f71b36f83e15579cd1cc11c6e2e8383fcfb11d1f
'http://deb.debian.org/debian/pool/main/n/node-hosted-git-info/node-hosted-git-info_3.0.8-1.debian.tar.xz' node-hosted-git-info_3.0.8-1.debian.tar.xz 2432 SHA256:55ff045bd9038c7fcfe089795f50af56edd28a0c12147ea9cf31d172aabd9803
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-hosted-git-info/3.0.8-1/ (for browsing the source)
- https://sources.debian.net/src/node-hosted-git-info/3.0.8-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-hosted-git-info/3.0.8-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-http-signature=1.3.5-1`

Binary Packages:

- `node-http-signature=1.3.5-1`

Licenses: (parsed from: `/usr/share/doc/node-http-signature/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-http-signature=1.3.5-1
'http://deb.debian.org/debian/pool/main/n/node-http-signature/node-http-signature_1.3.5-1.dsc' node-http-signature_1.3.5-1.dsc 2167 SHA256:49d04758bfdc746ae0515aa5d2587cc79246d9b8d6cbfc8f111b81c15c72e113
'http://deb.debian.org/debian/pool/main/n/node-http-signature/node-http-signature_1.3.5.orig.tar.gz' node-http-signature_1.3.5.orig.tar.gz 40451 SHA256:ea2d19b1c7980804296e4fcb972dd48e9086fa65d5c7ddb20becf490d2a595f6
'http://deb.debian.org/debian/pool/main/n/node-http-signature/node-http-signature_1.3.5-1.debian.tar.xz' node-http-signature_1.3.5-1.debian.tar.xz 3268 SHA256:1f926d6001240962c85273c7aca24f8e2b938047808e7c75906ab0e3b3e2a03a
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-http-signature/1.3.5-1/ (for browsing the source)
- https://sources.debian.net/src/node-http-signature/1.3.5-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-http-signature/1.3.5-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-https-proxy-agent=5.0.0-3`

Binary Packages:

- `node-https-proxy-agent=5.0.0-3`

Licenses: (parsed from: `/usr/share/doc/node-https-proxy-agent/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-https-proxy-agent=5.0.0-3
'http://deb.debian.org/debian/pool/main/n/node-https-proxy-agent/node-https-proxy-agent_5.0.0-3.dsc' node-https-proxy-agent_5.0.0-3.dsc 2312 SHA256:fed3c075fd45b1fcbefeb9ee15b1e2f9a05f7f1b77c7ebce8cec81583b65b8dc
'http://deb.debian.org/debian/pool/main/n/node-https-proxy-agent/node-https-proxy-agent_5.0.0.orig.tar.gz' node-https-proxy-agent_5.0.0.orig.tar.gz 11010 SHA256:2dbd9b7d861c4798234ecccb7a535a2817b6c6a94a3b2767ecc382989c872a4f
'http://deb.debian.org/debian/pool/main/n/node-https-proxy-agent/node-https-proxy-agent_5.0.0-3.debian.tar.xz' node-https-proxy-agent_5.0.0-3.debian.tar.xz 2640 SHA256:67d91452b2efbbdd3c600a5e1178eac5c655d603cc33de45da876037cd80e28d
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-https-proxy-agent/5.0.0-3/ (for browsing the source)
- https://sources.debian.net/src/node-https-proxy-agent/5.0.0-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-https-proxy-agent/5.0.0-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-iconv-lite=0.5.1-3`

Binary Packages:

- `node-iconv-lite=0.5.1-3`

Licenses: (parsed from: `/usr/share/doc/node-iconv-lite/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-iconv-lite=0.5.1-3
'http://deb.debian.org/debian/pool/main/n/node-iconv-lite/node-iconv-lite_0.5.1-3.dsc' node-iconv-lite_0.5.1-3.dsc 2451 SHA256:3b25c7029dbfb8868a6eded56df266e1482921238139d38b5da0e8087bd3d5b6
'http://deb.debian.org/debian/pool/main/n/node-iconv-lite/node-iconv-lite_0.5.1.orig-safer-buffer.tar.gz' node-iconv-lite_0.5.1.orig-safer-buffer.tar.gz 12381 SHA256:6e86876b3b0b1663779281a287db819020aca707e037f79ef44833018de82e68
'http://deb.debian.org/debian/pool/main/n/node-iconv-lite/node-iconv-lite_0.5.1.orig.tar.gz' node-iconv-lite_0.5.1.orig.tar.gz 229088 SHA256:caa72eae2599b5b2f3032fbb8963ceb22c0d2eb6dd9099852c214ca5664c1375
'http://deb.debian.org/debian/pool/main/n/node-iconv-lite/node-iconv-lite_0.5.1-3.debian.tar.xz' node-iconv-lite_0.5.1-3.debian.tar.xz 3696 SHA256:bed9e27b93d5a214bd736acbef4efc71c38f518842ffb7e8fac163ab1aa57ccc
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-iconv-lite/0.5.1-3/ (for browsing the source)
- https://sources.debian.net/src/node-iconv-lite/0.5.1-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-iconv-lite/0.5.1-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-iferr=1.0.2-1`

Binary Packages:

- `node-iferr=1.0.2-1`

Licenses: (parsed from: `/usr/share/doc/node-iferr/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-iferr=1.0.2-1
'http://deb.debian.org/debian/pool/main/n/node-iferr/node-iferr_1.0.2-1.dsc' node-iferr_1.0.2-1.dsc 2080 SHA256:d51d138182e9de66d1d1d5e130b07474415b52a7badd4a30db00ad8beb16e0bc
'http://deb.debian.org/debian/pool/main/n/node-iferr/node-iferr_1.0.2.orig.tar.gz' node-iferr_1.0.2.orig.tar.gz 4407 SHA256:855e07c8187484f54d38fcc1d77535dc02d5c7e0c589155b8eae147a44cefe9e
'http://deb.debian.org/debian/pool/main/n/node-iferr/node-iferr_1.0.2-1.debian.tar.xz' node-iferr_1.0.2-1.debian.tar.xz 2792 SHA256:7953460356a0a20af905c7e28134ab2ba30ad952d152afac7bfbcae3b515e421
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-iferr/1.0.2-1/ (for browsing the source)
- https://sources.debian.net/src/node-iferr/1.0.2-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-iferr/1.0.2-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-imurmurhash=0.1.4-1.1`

Binary Packages:

- `node-imurmurhash=0.1.4-1.1`

Licenses: (parsed from: `/usr/share/doc/node-imurmurhash/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-imurmurhash=0.1.4-1.1
'http://deb.debian.org/debian/pool/main/n/node-imurmurhash/node-imurmurhash_0.1.4-1.1.dsc' node-imurmurhash_0.1.4-1.1.dsc 2087 SHA256:56415448d553bdbbf5d2ed8db64c3b6707fcf9e7f08167a0c8789137cdeef01d
'http://deb.debian.org/debian/pool/main/n/node-imurmurhash/node-imurmurhash_0.1.4.orig.tar.gz' node-imurmurhash_0.1.4.orig.tar.gz 5219 SHA256:b3bf032b8729aea24ad5e60ef97bc66a3d51c8921035a2fff613d3bda2b597f8
'http://deb.debian.org/debian/pool/main/n/node-imurmurhash/node-imurmurhash_0.1.4-1.1.debian.tar.xz' node-imurmurhash_0.1.4-1.1.debian.tar.xz 2340 SHA256:804df1800a439b996d64d26f08013ee2392f822b4318ee1d247cff4b62737e0c
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-imurmurhash/0.1.4-1.1/ (for browsing the source)
- https://sources.debian.net/src/node-imurmurhash/0.1.4-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-imurmurhash/0.1.4-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-indent-string=4.0.0-1`

Binary Packages:

- `node-indent-string=4.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-indent-string/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-indent-string=4.0.0-1
'http://deb.debian.org/debian/pool/main/n/node-indent-string/node-indent-string_4.0.0-1.dsc' node-indent-string_4.0.0-1.dsc 2106 SHA256:7258704b578e7b284cd318b99f1b79ced6a8bbe012805f46c7b2f5d65baaa762
'http://deb.debian.org/debian/pool/main/n/node-indent-string/node-indent-string_4.0.0.orig.tar.gz' node-indent-string_4.0.0.orig.tar.gz 2966 SHA256:76ec882fd3d5541c120058199004f9c902af0443feb692fbe3e12d273ad4ce0a
'http://deb.debian.org/debian/pool/main/n/node-indent-string/node-indent-string_4.0.0-1.debian.tar.xz' node-indent-string_4.0.0-1.debian.tar.xz 3212 SHA256:7f95df27d054f0dc69807ceb77193f0bd045168428387a83069ee1b77cba4658
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-indent-string/4.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-indent-string/4.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-indent-string/4.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-inflight=1.0.6-1.1`

Binary Packages:

- `node-inflight=1.0.6-1.1`

Licenses: (parsed from: `/usr/share/doc/node-inflight/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-inflight=1.0.6-1.1
'http://deb.debian.org/debian/pool/main/n/node-inflight/node-inflight_1.0.6-1.1.dsc' node-inflight_1.0.6-1.1.dsc 2038 SHA256:87ae8ed77b85e14d664936ed583849cb7ee3c1c999ed35ca191e8017deebbb17
'http://deb.debian.org/debian/pool/main/n/node-inflight/node-inflight_1.0.6.orig.tar.gz' node-inflight_1.0.6.orig.tar.gz 3019 SHA256:6d1dac68fa3720752cb3c17c25fd96bd3d131c2ee1c3246c00afbec91fe77113
'http://deb.debian.org/debian/pool/main/n/node-inflight/node-inflight_1.0.6-1.1.debian.tar.xz' node-inflight_1.0.6-1.1.debian.tar.xz 1956 SHA256:801a9df028b277c647e2bf27e24a8995cf6fdcaa81b4dbee8b0a80511913875d
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-inflight/1.0.6-1.1/ (for browsing the source)
- https://sources.debian.net/src/node-inflight/1.0.6-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-inflight/1.0.6-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-inherits=2.0.4-1`

Binary Packages:

- `libjs-inherits=2.0.4-1`
- `node-inherits=2.0.4-1`

Licenses: (parsed from: `/usr/share/doc/libjs-inherits/copyright`, `/usr/share/doc/node-inherits/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-inherits=2.0.4-1
'http://deb.debian.org/debian/pool/main/n/node-inherits/node-inherits_2.0.4-1.dsc' node-inherits_2.0.4-1.dsc 2192 SHA256:25784435e0fe6fd82e0caf32dc5e484e22679853b1fa530c5184bdf93ff1a8c7
'http://deb.debian.org/debian/pool/main/n/node-inherits/node-inherits_2.0.4.orig.tar.gz' node-inherits_2.0.4.orig.tar.gz 31453 SHA256:a6c794ebc263c3ab833a4efeeec91347cafe10c737a9147151265185c9a27161
'http://deb.debian.org/debian/pool/main/n/node-inherits/node-inherits_2.0.4-1.debian.tar.xz' node-inherits_2.0.4-1.debian.tar.xz 2872 SHA256:21753586824ae7a3e94fe340cdc8fe69531fb3b4939b977df1423de322142f97
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-inherits/2.0.4-1/ (for browsing the source)
- https://sources.debian.net/src/node-inherits/2.0.4-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-inherits/2.0.4-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-ini=2.0.0-1`

Binary Packages:

- `node-ini=2.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-ini/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-ini=2.0.0-1
'http://deb.debian.org/debian/pool/main/n/node-ini/node-ini_2.0.0-1.dsc' node-ini_2.0.0-1.dsc 1986 SHA256:357b0f9ab337bd7c697f94c3e98d63c0f9859e64883e62bef0fafd8910256ed7
'http://deb.debian.org/debian/pool/main/n/node-ini/node-ini_2.0.0.orig.tar.gz' node-ini_2.0.0.orig.tar.gz 109383 SHA256:c01dfc6d190c6f1d770cfb84490461415c9d67ac6e77b5335cbe17184cf5f891
'http://deb.debian.org/debian/pool/main/n/node-ini/node-ini_2.0.0-1.debian.tar.xz' node-ini_2.0.0-1.debian.tar.xz 2708 SHA256:9d65e1936e2846cab2944840dd895b8b33eb30938c625abd200b2d4529c2b77e
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-ini/2.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-ini/2.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-ini/2.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-ip-regex=4.3.0-1`

Binary Packages:

- `node-ip-regex=4.3.0-1`

Licenses: (parsed from: `/usr/share/doc/node-ip-regex/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-ip-regex=4.3.0-1
'http://deb.debian.org/debian/pool/main/n/node-ip-regex/node-ip-regex_4.3.0-1.dsc' node-ip-regex_4.3.0-1.dsc 2064 SHA256:2d50e15d4cefd669e2fbafb8c18fbac15fa9e35b42a4caaf51d78bf59ad7a622
'http://deb.debian.org/debian/pool/main/n/node-ip-regex/node-ip-regex_4.3.0.orig.tar.gz' node-ip-regex_4.3.0.orig.tar.gz 5429 SHA256:113249fb295487f8af3520c905365992ed435b4afbd1071da31f64e360297a8c
'http://deb.debian.org/debian/pool/main/n/node-ip-regex/node-ip-regex_4.3.0-1.debian.tar.xz' node-ip-regex_4.3.0-1.debian.tar.xz 3044 SHA256:158ff78509f05d6b55870e0385878c6546682d4cbf42763bbec18882f275a038
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-ip-regex/4.3.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-ip-regex/4.3.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-ip-regex/4.3.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-ip=1.1.5-5`

Binary Packages:

- `node-ip=1.1.5-5`

Licenses: (parsed from: `/usr/share/doc/node-ip/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-ip=1.1.5-5
'http://deb.debian.org/debian/pool/main/n/node-ip/node-ip_1.1.5-5.dsc' node-ip_1.1.5-5.dsc 1963 SHA256:84c8b00dd3020f4957bd9dec9437e7689d4753a1f148db75e34cb11cdaf8a060
'http://deb.debian.org/debian/pool/main/n/node-ip/node-ip_1.1.5.orig.tar.gz' node-ip_1.1.5.orig.tar.gz 9149 SHA256:6789c330645f5ba11f938ae9e3aada98de5abc04a3c3cb7dd102b8e2565b1e49
'http://deb.debian.org/debian/pool/main/n/node-ip/node-ip_1.1.5-5.debian.tar.xz' node-ip_1.1.5-5.debian.tar.xz 4308 SHA256:9d905896738bf7894bc6f9bf7420ac852c1c2ef4b6eaac32f5f2ce0f96ef9767
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-ip/1.1.5-5/ (for browsing the source)
- https://sources.debian.net/src/node-ip/1.1.5-5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-ip/1.1.5-5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-is-typedarray=1.0.0-3`

Binary Packages:

- `libjs-is-typedarray=1.0.0-3`
- `node-is-typedarray=1.0.0-3`

Licenses: (parsed from: `/usr/share/doc/libjs-is-typedarray/copyright`, `/usr/share/doc/node-is-typedarray/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-is-typedarray=1.0.0-3
'http://deb.debian.org/debian/pool/main/n/node-is-typedarray/node-is-typedarray_1.0.0-3.dsc' node-is-typedarray_1.0.0-3.dsc 2186 SHA256:3a7505647e29327703df735a8a1cb92d79e4fb7de9c7477ff286e0a56e6f901f
'http://deb.debian.org/debian/pool/main/n/node-is-typedarray/node-is-typedarray_1.0.0.orig.tar.gz' node-is-typedarray_1.0.0.orig.tar.gz 2019 SHA256:153e3c02d6386c9caec67aa0c4200e107234fcc3ff457cf83aa8da677ccaa3a6
'http://deb.debian.org/debian/pool/main/n/node-is-typedarray/node-is-typedarray_1.0.0-3.debian.tar.xz' node-is-typedarray_1.0.0-3.debian.tar.xz 3248 SHA256:fb41280bc4f3ee54615e01bdcdc339fd6e4d6bf53ac5f9e62683e1e9b597e55d
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-is-typedarray/1.0.0-3/ (for browsing the source)
- https://sources.debian.net/src/node-is-typedarray/1.0.0-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-is-typedarray/1.0.0-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-isarray=2.0.5-1`

Binary Packages:

- `node-isarray=2.0.5-1`

Licenses: (parsed from: `/usr/share/doc/node-isarray/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-isarray=2.0.5-1
'http://deb.debian.org/debian/pool/main/n/node-isarray/node-isarray_2.0.5-1.dsc' node-isarray_2.0.5-1.dsc 2093 SHA256:a248a8de41920c120b75be31288afb8bd9a22886cf975ffe476d51c47282ad8c
'http://deb.debian.org/debian/pool/main/n/node-isarray/node-isarray_2.0.5.orig.tar.gz' node-isarray_2.0.5.orig.tar.gz 3366 SHA256:0603442bb5b174f69f16d672719bddc56d22810b28259666bc1887aab52273e3
'http://deb.debian.org/debian/pool/main/n/node-isarray/node-isarray_2.0.5-1.debian.tar.xz' node-isarray_2.0.5-1.debian.tar.xz 2580 SHA256:6c29ec9b3a22ab26a8a4093b89d3ac1c73ee126f38596421e55bd1dcd60ddb53
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-isarray/2.0.5-1/ (for browsing the source)
- https://sources.debian.net/src/node-isarray/2.0.5-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-isarray/2.0.5-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-isexe=2.0.0-5`

Binary Packages:

- `node-isexe=2.0.0-5`

Licenses: (parsed from: `/usr/share/doc/node-isexe/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-isexe=2.0.0-5
'http://deb.debian.org/debian/pool/main/n/node-isexe/node-isexe_2.0.0-5.dsc' node-isexe_2.0.0-5.dsc 2152 SHA256:29fb5f451ccbf06a3da631dcde5ff94509e7634f059ff103f5b24e432362f0f2
'http://deb.debian.org/debian/pool/main/n/node-isexe/node-isexe_2.0.0.orig.tar.gz' node-isexe_2.0.0.orig.tar.gz 3862 SHA256:6af33f8cce57076339328c571c5597efd71f74a0f2271824dd580e6250a4003f
'http://deb.debian.org/debian/pool/main/n/node-isexe/node-isexe_2.0.0-5.debian.tar.xz' node-isexe_2.0.0-5.debian.tar.xz 3140 SHA256:1ea6c8ca995466f20d77969ff4fb323726e35d1b9a802c59f8c7cf33749f312c
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-isexe/2.0.0-5/ (for browsing the source)
- https://sources.debian.net/src/node-isexe/2.0.0-5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-isexe/2.0.0-5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-isstream=0.1.2+dfsg-1.1`

Binary Packages:

- `node-isstream=0.1.2+dfsg-1.1`

Licenses: (parsed from: `/usr/share/doc/node-isstream/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-isstream=0.1.2+dfsg-1.1
'http://deb.debian.org/debian/pool/main/n/node-isstream/node-isstream_0.1.2%2bdfsg-1.1.dsc' node-isstream_0.1.2+dfsg-1.1.dsc 2063 SHA256:8504f7fda6a8ab16c9b42733b9f115428b727dc84ac252fff1beb1e664d0d6be
'http://deb.debian.org/debian/pool/main/n/node-isstream/node-isstream_0.1.2%2bdfsg.orig.tar.gz' node-isstream_0.1.2+dfsg.orig.tar.gz 3753 SHA256:5111638802d630a7f3a97fb94873fa40cb62f217a7d22a87216b98a5c09cff62
'http://deb.debian.org/debian/pool/main/n/node-isstream/node-isstream_0.1.2%2bdfsg-1.1.debian.tar.xz' node-isstream_0.1.2+dfsg-1.1.debian.tar.xz 2984 SHA256:247f0589ed02c7deb5654c5bd568f2fa02c5da3ac11b291c61bef8336b58cec3
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-isstream/0.1.2+dfsg-1.1/ (for browsing the source)
- https://sources.debian.net/src/node-isstream/0.1.2+dfsg-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-isstream/0.1.2+dfsg-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-jquery=3.5.1+dfsg+~3.5.5-7`

Binary Packages:

- `libjs-jquery=3.5.1+dfsg+~3.5.5-7`

Licenses: (parsed from: `/usr/share/doc/libjs-jquery/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-jquery=3.5.1+dfsg+~3.5.5-7
'http://deb.debian.org/debian/pool/main/n/node-jquery/node-jquery_3.5.1%2bdfsg%2b%7e3.5.5-7.dsc' node-jquery_3.5.1+dfsg+~3.5.5-7.dsc 2689 SHA256:22c458e319113812588ce546d186410d5bd3beb1b590dc358af7dfcd01d39b52
'http://deb.debian.org/debian/pool/main/n/node-jquery/node-jquery_3.5.1%2bdfsg%2b%7e3.5.5.orig-types-jquery.tar.xz' node-jquery_3.5.1+dfsg+~3.5.5.orig-types-jquery.tar.xz 84264 SHA256:f5c10141ac3cc265ac2880260b32e2cb2607111fa34f64ea687058ecc3b54711
'http://deb.debian.org/debian/pool/main/n/node-jquery/node-jquery_3.5.1%2bdfsg%2b%7e3.5.5.orig.tar.xz' node-jquery_3.5.1+dfsg+~3.5.5.orig.tar.xz 296824 SHA256:0c066150df631d21299aea17ab64ac55a83dccd60e5ae083b2074d4941c37e7a
'http://deb.debian.org/debian/pool/main/n/node-jquery/node-jquery_3.5.1%2bdfsg%2b%7e3.5.5-7.debian.tar.xz' node-jquery_3.5.1+dfsg+~3.5.5-7.debian.tar.xz 5828 SHA256:1842cd21f08e72eeb6153fe81cfbf6ac042507caffe70f9ebdf88ca4a5e9b43b
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-jquery/3.5.1+dfsg+~3.5.5-7/ (for browsing the source)
- https://sources.debian.net/src/node-jquery/3.5.1+dfsg+~3.5.5-7/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-jquery/3.5.1+dfsg+~3.5.5-7/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-jsbn=1.1.0-1.1`

Binary Packages:

- `node-jsbn=1.1.0-1.1`

Licenses: (parsed from: `/usr/share/doc/node-jsbn/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-jsbn=1.1.0-1.1
'http://deb.debian.org/debian/pool/main/n/node-jsbn/node-jsbn_1.1.0-1.1.dsc' node-jsbn_1.1.0-1.1.dsc 2006 SHA256:623e09eb7874954f6ef79103ca148a2c44d3ef87341cacbb79ad6511071128fa
'http://deb.debian.org/debian/pool/main/n/node-jsbn/node-jsbn_1.1.0.orig.tar.gz' node-jsbn_1.1.0.orig.tar.gz 13839 SHA256:95abc8bb938a357e6ba4f0dfd3778e73e45c973ba9de6befb596c175c1c14948
'http://deb.debian.org/debian/pool/main/n/node-jsbn/node-jsbn_1.1.0-1.1.debian.tar.xz' node-jsbn_1.1.0-1.1.debian.tar.xz 2144 SHA256:348cca65459e98072cb190bdcf642faad045efd0ccb8eaa1a6b9b0f5e1dd5eed
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-jsbn/1.1.0-1.1/ (for browsing the source)
- https://sources.debian.net/src/node-jsbn/1.1.0-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-jsbn/1.1.0-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-json-parse-better-errors=1.0.2+~2.3.1-1`

Binary Packages:

- `node-json-parse-better-errors=1.0.2+~2.3.1-1`

Licenses: (parsed from: `/usr/share/doc/node-json-parse-better-errors/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-json-parse-better-errors=1.0.2+~2.3.1-1
'http://deb.debian.org/debian/pool/main/n/node-json-parse-better-errors/node-json-parse-better-errors_1.0.2%2b%7e2.3.1-1.dsc' node-json-parse-better-errors_1.0.2+~2.3.1-1.dsc 2704 SHA256:0ae1c43a70db37103ae109d6bba1d0705173e0d7f824c0207b11b3881766b283
'http://deb.debian.org/debian/pool/main/n/node-json-parse-better-errors/node-json-parse-better-errors_1.0.2%2b%7e2.3.1.orig-json-parse-even-better-errors.tar.gz' node-json-parse-better-errors_1.0.2+~2.3.1.orig-json-parse-even-better-errors.tar.gz 34553 SHA256:71034e9af548723889a9b08d8a0cbbfe21a137671a2892b7afc80e87a289ac8a
'http://deb.debian.org/debian/pool/main/n/node-json-parse-better-errors/node-json-parse-better-errors_1.0.2%2b%7e2.3.1.orig.tar.gz' node-json-parse-better-errors_1.0.2+~2.3.1.orig.tar.gz 38360 SHA256:3d0ce38e922ccc98c87f75b0934b43b5e7da13fe31b5ae29fed98944ac9f9e0a
'http://deb.debian.org/debian/pool/main/n/node-json-parse-better-errors/node-json-parse-better-errors_1.0.2%2b%7e2.3.1-1.debian.tar.xz' node-json-parse-better-errors_1.0.2+~2.3.1-1.debian.tar.xz 2988 SHA256:55fa3152b540ec9476e5e7f02c0f0e7403a8c08ef26af41e7c54f87d3c849fe0
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-json-parse-better-errors/1.0.2+~2.3.1-1/ (for browsing the source)
- https://sources.debian.net/src/node-json-parse-better-errors/1.0.2+~2.3.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-json-parse-better-errors/1.0.2+~2.3.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-json-schema-traverse=1.0.0-2`

Binary Packages:

- `node-json-schema-traverse=1.0.0-2`

Licenses: (parsed from: `/usr/share/doc/node-json-schema-traverse/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-json-schema-traverse=1.0.0-2
'http://deb.debian.org/debian/pool/main/n/node-json-schema-traverse/node-json-schema-traverse_1.0.0-2.dsc' node-json-schema-traverse_1.0.0-2.dsc 2186 SHA256:62d2751074123dd730dae26e986e0232d9c0de57ac2726dfe2214ece88eaf109
'http://deb.debian.org/debian/pool/main/n/node-json-schema-traverse/node-json-schema-traverse_1.0.0.orig.tar.gz' node-json-schema-traverse_1.0.0.orig.tar.gz 6791 SHA256:c17b3d81f69f3509e4a680abee5c320d1b0e2d1f150691fb441a4845c7316912
'http://deb.debian.org/debian/pool/main/n/node-json-schema-traverse/node-json-schema-traverse_1.0.0-2.debian.tar.xz' node-json-schema-traverse_1.0.0-2.debian.tar.xz 2596 SHA256:857bc777662f6d776ac68965bd31d78ef143dfec981c6187eb5561794bf8d1cf
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-json-schema-traverse/1.0.0-2/ (for browsing the source)
- https://sources.debian.net/src/node-json-schema-traverse/1.0.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-json-schema-traverse/1.0.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-json-schema=0.3.0+~7.0.6-1+deb11u1`

Binary Packages:

- `node-json-schema=0.3.0+~7.0.6-1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/node-json-schema/copyright`)

- `BSD-3-clause~Dojo`
- `Expat`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris node-json-schema=0.3.0+~7.0.6-1+deb11u1
'http://deb.debian.org/debian/pool/main/n/node-json-schema/node-json-schema_0.3.0%2b%7e7.0.6-1%2bdeb11u1.dsc' node-json-schema_0.3.0+~7.0.6-1+deb11u1.dsc 2504 SHA256:7dde2adfd402d36834365d47426a6e733ad0cae1a7d7cb473185d9b937afa827
'http://deb.debian.org/debian/pool/main/n/node-json-schema/node-json-schema_0.3.0%2b%7e7.0.6.orig-Xtypes.tar.gz' node-json-schema_0.3.0+~7.0.6.orig-Xtypes.tar.gz 6121 SHA256:42752da08b762ed42f4969899777b9a440b67fbc300f0c5709268c71e346c6b7
'http://deb.debian.org/debian/pool/main/n/node-json-schema/node-json-schema_0.3.0%2b%7e7.0.6.orig.tar.gz' node-json-schema_0.3.0+~7.0.6.orig.tar.gz 37655 SHA256:fb496401c7e6fe75cbe22132a1a1624e2d8f257d8c5cb417296125ceef287ca9
'http://deb.debian.org/debian/pool/main/n/node-json-schema/node-json-schema_0.3.0%2b%7e7.0.6-1%2bdeb11u1.debian.tar.xz' node-json-schema_0.3.0+~7.0.6-1+deb11u1.debian.tar.xz 6644 SHA256:5cb1aef4c8cdcb3bc59031158e8b8655afa5854cbbdb8bbe36bb6bdd6e8c1def
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-json-schema/0.3.0+~7.0.6-1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/node-json-schema/0.3.0+~7.0.6-1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-json-schema/0.3.0+~7.0.6-1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-json-stable-stringify=1.0.1+~cs5.1.32-1`

Binary Packages:

- `node-json-stable-stringify=1.0.1+~cs5.1.32-1`

Licenses: (parsed from: `/usr/share/doc/node-json-stable-stringify/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-json-stable-stringify=1.0.1+~cs5.1.32-1
'http://deb.debian.org/debian/pool/main/n/node-json-stable-stringify/node-json-stable-stringify_1.0.1%2b%7ecs5.1.32-1.dsc' node-json-stable-stringify_1.0.1+~cs5.1.32-1.dsc 3570 SHA256:031dea8c51448ba728274f3755c05b02f7d878c5a61745a49ebb5def7e3a3564
'http://deb.debian.org/debian/pool/main/n/node-json-stable-stringify/node-json-stable-stringify_1.0.1%2b%7ecs5.1.32.orig-fast-json-stable-stringify.tar.gz' node-json-stable-stringify_1.0.1+~cs5.1.32.orig-fast-json-stable-stringify.tar.gz 6602 SHA256:d25251cadbe541a832b1bb942a36f5e243ac917e61ee3fa0b9d6bfd177d71051
'http://deb.debian.org/debian/pool/main/n/node-json-stable-stringify/node-json-stable-stringify_1.0.1%2b%7ecs5.1.32.orig-types-fast-json-stable-stringify.tar.gz' node-json-stable-stringify_1.0.1+~cs5.1.32.orig-types-fast-json-stable-stringify.tar.gz 1609 SHA256:f175e1794377af97711f0f3a2674bff80280e006092f98b0f32b07beab1a9adc
'http://deb.debian.org/debian/pool/main/n/node-json-stable-stringify/node-json-stable-stringify_1.0.1%2b%7ecs5.1.32.orig-types-json-stable-stringify.tar.gz' node-json-stable-stringify_1.0.1+~cs5.1.32.orig-types-json-stable-stringify.tar.gz 1619 SHA256:11bb8223e0bd5a40e3a1602230c1a08d957f5bb7a336d82ceba275d9834d0de9
'http://deb.debian.org/debian/pool/main/n/node-json-stable-stringify/node-json-stable-stringify_1.0.1%2b%7ecs5.1.32.orig.tar.gz' node-json-stable-stringify_1.0.1+~cs5.1.32.orig.tar.gz 4662 SHA256:2aa0aedd6dff0755d1c2025f82e4b3dd5bb91236b8665bd9633f28567b162d3e
'http://deb.debian.org/debian/pool/main/n/node-json-stable-stringify/node-json-stable-stringify_1.0.1%2b%7ecs5.1.32-1.debian.tar.xz' node-json-stable-stringify_1.0.1+~cs5.1.32-1.debian.tar.xz 3340 SHA256:5481d81d5d7eb1764ee582118a37f4bfa4a8541e205ed69fc25a2a30e087706e
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-json-stable-stringify/1.0.1+~cs5.1.32-1/ (for browsing the source)
- https://sources.debian.net/src/node-json-stable-stringify/1.0.1+~cs5.1.32-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-json-stable-stringify/1.0.1+~cs5.1.32-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-json-stringify-safe=5.0.1+repack-3`

Binary Packages:

- `node-json-stringify-safe=5.0.1+repack-3`

Licenses: (parsed from: `/usr/share/doc/node-json-stringify-safe/copyright`)

- `AGPL-3`
- `BSD-2-clause`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-json-stringify-safe=5.0.1+repack-3
'http://deb.debian.org/debian/pool/main/n/node-json-stringify-safe/node-json-stringify-safe_5.0.1%2brepack-3.dsc' node-json-stringify-safe_5.0.1+repack-3.dsc 3615 SHA256:ae9a3b897dd5d3f0dc92cb01788be247a3039fbb7d0807203e68fa6de88d8acd
'http://deb.debian.org/debian/pool/main/n/node-json-stringify-safe/node-json-stringify-safe_5.0.1%2brepack.orig-egal.tar.gz' node-json-stringify-safe_5.0.1+repack.orig-egal.tar.gz 9048 SHA256:fb3830efef24d46c1c51e4f9a828ea1d611d19722f934201ed46afbfbd127035
'http://deb.debian.org/debian/pool/main/n/node-json-stringify-safe/node-json-stringify-safe_5.0.1%2brepack.orig-kindof.tar.gz' node-json-stringify-safe_5.0.1+repack.orig-kindof.tar.gz 5717 SHA256:7dfd502aeb52da37c66b499d0e6af822501e5cc589d8e5d488be60ceef47444c
'http://deb.debian.org/debian/pool/main/n/node-json-stringify-safe/node-json-stringify-safe_5.0.1%2brepack.orig-must.tar.gz' node-json-stringify-safe_5.0.1+repack.orig-must.tar.gz 42624 SHA256:dc47685d7d924d723ba24c96bcc4673ecf260a2754825c2811924f247948e11b
'http://deb.debian.org/debian/pool/main/n/node-json-stringify-safe/node-json-stringify-safe_5.0.1%2brepack.orig-oolong.tar.gz' node-json-stringify-safe_5.0.1+repack.orig-oolong.tar.gz 16672 SHA256:86b6848c8109b1c3fb01fe0246c3659b91eb3e76b8a7053d5ec566d597751a36
'http://deb.debian.org/debian/pool/main/n/node-json-stringify-safe/node-json-stringify-safe_5.0.1%2brepack.orig.tar.gz' node-json-stringify-safe_5.0.1+repack.orig.tar.gz 4207 SHA256:8256d7654e42896ed2cec995250489d589dbec47c0f0ea4a851ff093b6a1a7eb
'http://deb.debian.org/debian/pool/main/n/node-json-stringify-safe/node-json-stringify-safe_5.0.1%2brepack-3.debian.tar.xz' node-json-stringify-safe_5.0.1+repack-3.debian.tar.xz 5424 SHA256:1ca7c896e0ae96c3eceac43c12a5a856a6254ea9eccdefced39219863efb5b41
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-json-stringify-safe/5.0.1+repack-3/ (for browsing the source)
- https://sources.debian.net/src/node-json-stringify-safe/5.0.1+repack-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-json-stringify-safe/5.0.1+repack-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-jsonify=0.0.0-1.1`

Binary Packages:

- `node-jsonify=0.0.0-1.1`

Licenses: (parsed from: `/usr/share/doc/node-jsonify/copyright`)

- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris node-jsonify=0.0.0-1.1
'http://deb.debian.org/debian/pool/main/n/node-jsonify/node-jsonify_0.0.0-1.1.dsc' node-jsonify_0.0.0-1.1.dsc 2028 SHA256:d7b55758cdd9ea98fc8aa751afdc40062845ace159f32240050e182b9e2971a1
'http://deb.debian.org/debian/pool/main/n/node-jsonify/node-jsonify_0.0.0.orig.tar.gz' node-jsonify_0.0.0.orig.tar.gz 4376 SHA256:030f926cb3d18933c9bce7fe3d1dddbde73b91532dc4cada98214337e811c89c
'http://deb.debian.org/debian/pool/main/n/node-jsonify/node-jsonify_0.0.0-1.1.debian.tar.xz' node-jsonify_0.0.0-1.1.debian.tar.xz 1644 SHA256:890f77cd589fecc56d20ecc8c791256cb82adfb14208a642e775f1b8135568a0
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-jsonify/0.0.0-1.1/ (for browsing the source)
- https://sources.debian.net/src/node-jsonify/0.0.0-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-jsonify/0.0.0-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-jsonparse=1.3.1-7`

Binary Packages:

- `node-jsonparse=1.3.1-7`

Licenses: (parsed from: `/usr/share/doc/node-jsonparse/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-jsonparse=1.3.1-7
'http://deb.debian.org/debian/pool/main/n/node-jsonparse/node-jsonparse_1.3.1-7.dsc' node-jsonparse_1.3.1-7.dsc 2172 SHA256:fe42f637ff8201922f9933c05633297545f82391967a701ac5a9b6bf28f345cd
'http://deb.debian.org/debian/pool/main/n/node-jsonparse/node-jsonparse_1.3.1.orig.tar.gz' node-jsonparse_1.3.1.orig.tar.gz 8721 SHA256:e5946340dae9207d41c4473d885a23e1dfdfe0e344bc7eab900dfeccd28b4c46
'http://deb.debian.org/debian/pool/main/n/node-jsonparse/node-jsonparse_1.3.1-7.debian.tar.xz' node-jsonparse_1.3.1-7.debian.tar.xz 4848 SHA256:23926d251b766b0394819630e4210116cadbf9dc776004ec119f03b03c6daaeb
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-jsonparse/1.3.1-7/ (for browsing the source)
- https://sources.debian.net/src/node-jsonparse/1.3.1-7/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-jsonparse/1.3.1-7/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-jsonstream=1.3.5-1`

Binary Packages:

- `node-jsonstream=1.3.5-1`

Licenses: (parsed from: `/usr/share/doc/node-jsonstream/copyright`)

- `Apache-2.0`
- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-jsonstream=1.3.5-1
'http://deb.debian.org/debian/pool/main/n/node-jsonstream/node-jsonstream_1.3.5-1.dsc' node-jsonstream_1.3.5-1.dsc 2129 SHA256:eb7c9c8c19b0d074f4fd01a135c233d80b628ca9aaa33315350324b1ed014f68
'http://deb.debian.org/debian/pool/main/n/node-jsonstream/node-jsonstream_1.3.5.orig.tar.gz' node-jsonstream_1.3.5.orig.tar.gz 139427 SHA256:ef3be72c45c76fbb688e2cb3078a7905b413ec9c8eb2d889cd0481f38c712488
'http://deb.debian.org/debian/pool/main/n/node-jsonstream/node-jsonstream_1.3.5-1.debian.tar.xz' node-jsonstream_1.3.5-1.debian.tar.xz 3492 SHA256:fd280f2ed3893ec40977611c01a59320155bf4fc86d76b654278688dbfb84de9
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-jsonstream/1.3.5-1/ (for browsing the source)
- https://sources.debian.net/src/node-jsonstream/1.3.5-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-jsonstream/1.3.5-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-jsprim=2.0.0-1`

Binary Packages:

- `node-jsprim=2.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-jsprim/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-jsprim=2.0.0-1
'http://deb.debian.org/debian/pool/main/n/node-jsprim/node-jsprim_2.0.0-1.dsc' node-jsprim_2.0.0-1.dsc 2072 SHA256:11f92bd50b6dde6e68747c1c201a15a4eb1e1edf03c0f3992b8b091806422893
'http://deb.debian.org/debian/pool/main/n/node-jsprim/node-jsprim_2.0.0.orig.tar.gz' node-jsprim_2.0.0.orig.tar.gz 26324 SHA256:fe37701322cfb6fe560b86fdf41309d8610468201acad16efe925a655c4b116a
'http://deb.debian.org/debian/pool/main/n/node-jsprim/node-jsprim_2.0.0-1.debian.tar.xz' node-jsprim_2.0.0-1.debian.tar.xz 3032 SHA256:581d2174ca42e8170de2c98150ce6b0d4d2b6a44f8f9626dff97c1d6457a27b5
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-jsprim/2.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-jsprim/2.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-jsprim/2.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-leven=3.1.0+~cs1.1.1-1`

Binary Packages:

- `node-leven=3.1.0+~cs1.1.1-1`

Licenses: (parsed from: `/usr/share/doc/node-leven/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-leven=3.1.0+~cs1.1.1-1
'http://deb.debian.org/debian/pool/main/n/node-leven/node-leven_3.1.0%2b%7ecs1.1.1-1.dsc' node-leven_3.1.0+~cs1.1.1-1.dsc 2473 SHA256:381fdb4f79ae494caa5754f68278172fe0db0a13a5aca747371a5da143b8de7a
'http://deb.debian.org/debian/pool/main/n/node-leven/node-leven_3.1.0%2b%7ecs1.1.1.orig-levenary.tar.gz' node-leven_3.1.0+~cs1.1.1.orig-levenary.tar.gz 2394 SHA256:764662278dd98958b8242e521ae78e860d272db3cea04860278428f8d2290c9b
'http://deb.debian.org/debian/pool/main/n/node-leven/node-leven_3.1.0%2b%7ecs1.1.1.orig.tar.gz' node-leven_3.1.0+~cs1.1.1.orig.tar.gz 3906 SHA256:386685b6e04f9d0e4cddfc951ec8c30970e3b8ab36886a8e208e2f9b8f90ead4
'http://deb.debian.org/debian/pool/main/n/node-leven/node-leven_3.1.0%2b%7ecs1.1.1-1.debian.tar.xz' node-leven_3.1.0+~cs1.1.1-1.debian.tar.xz 3936 SHA256:5c1231307a0af3e31f83ed9534ae55b829ff163ac80dfe59b4ea9e001c0a457d
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-leven/3.1.0+~cs1.1.1-1/ (for browsing the source)
- https://sources.debian.net/src/node-leven/3.1.0+~cs1.1.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-leven/3.1.0+~cs1.1.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-lockfile=1.0.4-3`

Binary Packages:

- `node-lockfile=1.0.4-3`

Licenses: (parsed from: `/usr/share/doc/node-lockfile/copyright`)

- `BSD-2-clause`
- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-lockfile=1.0.4-3
'http://deb.debian.org/debian/pool/main/n/node-lockfile/node-lockfile_1.0.4-3.dsc' node-lockfile_1.0.4-3.dsc 2091 SHA256:703458ec6a94ddb26dd750faf1902a06bdee602f796764b20a9153f0c318bd63
'http://deb.debian.org/debian/pool/main/n/node-lockfile/node-lockfile_1.0.4.orig.tar.gz' node-lockfile_1.0.4.orig.tar.gz 25366 SHA256:99d1fb9ab6c1497dfa839df86da073b435b7d9815b516253876a77b2d3f6e05b
'http://deb.debian.org/debian/pool/main/n/node-lockfile/node-lockfile_1.0.4-3.debian.tar.xz' node-lockfile_1.0.4-3.debian.tar.xz 5060 SHA256:b6a28b095c1868e0eb06309ad756679cdbafc98f389b05dac204d52909fd953a
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-lockfile/1.0.4-3/ (for browsing the source)
- https://sources.debian.net/src/node-lockfile/1.0.4-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-lockfile/1.0.4-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-lru-cache=5.1.1-5`

Binary Packages:

- `node-lru-cache=5.1.1-5`

Licenses: (parsed from: `/usr/share/doc/node-lru-cache/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-lru-cache=5.1.1-5
'http://deb.debian.org/debian/pool/main/n/node-lru-cache/node-lru-cache_5.1.1-5.dsc' node-lru-cache_5.1.1-5.dsc 2098 SHA256:7e33281be61886bf87f2218b536a8c526e6d181bc3743f8a6113e098abfc5908
'http://deb.debian.org/debian/pool/main/n/node-lru-cache/node-lru-cache_5.1.1.orig.tar.gz' node-lru-cache_5.1.1.orig.tar.gz 26915 SHA256:4c531d97fb6e76bc9a3e7de9ff06ac5183811d7f2e86e2c9a77d94223e07bef0
'http://deb.debian.org/debian/pool/main/n/node-lru-cache/node-lru-cache_5.1.1-5.debian.tar.xz' node-lru-cache_5.1.1-5.debian.tar.xz 3588 SHA256:1477450014b4c9ac36b852bcfb259b3876019306d773c48d5ca5b8407c66a30f
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-lru-cache/5.1.1-5/ (for browsing the source)
- https://sources.debian.net/src/node-lru-cache/5.1.1-5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-lru-cache/5.1.1-5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-mime-types=2.1.28-1`

Binary Packages:

- `node-mime-types=2.1.28-1`

Licenses: (parsed from: `/usr/share/doc/node-mime-types/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-mime-types=2.1.28-1
'http://deb.debian.org/debian/pool/main/n/node-mime-types/node-mime-types_2.1.28-1.dsc' node-mime-types_2.1.28-1.dsc 2464 SHA256:6d86e601c802bd6f081bf6c44ae05f7ce6bbf5e6c22631e83cb70fe0b85af03f
'http://deb.debian.org/debian/pool/main/n/node-mime-types/node-mime-types_2.1.28.orig-types-mime-types.tar.gz' node-mime-types_2.1.28.orig-types-mime-types.tar.gz 1545 SHA256:499adefb1d0afd4d1d03d268f4727e6e8c972b55c84e394907f7abb2e6ffb104
'http://deb.debian.org/debian/pool/main/n/node-mime-types/node-mime-types_2.1.28.orig.tar.gz' node-mime-types_2.1.28.orig.tar.gz 7991 SHA256:5b565d1dd5ca108e943ec606d7c91c50cd779d0929e709d690c5446965da7189
'http://deb.debian.org/debian/pool/main/n/node-mime-types/node-mime-types_2.1.28-1.debian.tar.xz' node-mime-types_2.1.28-1.debian.tar.xz 3696 SHA256:f3520f2f3a98a8b046a3d29af6340965a413e29b47b59a86916172482cc05d1a
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-mime-types/2.1.28-1/ (for browsing the source)
- https://sources.debian.net/src/node-mime-types/2.1.28-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-mime-types/2.1.28-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-mime=2.5.0+dfsg+~cs3.90.0-1`

Binary Packages:

- `node-mime=2.5.0+dfsg+~cs3.90.0-1`

Licenses: (parsed from: `/usr/share/doc/node-mime/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-mime=2.5.0+dfsg+~cs3.90.0-1
'http://deb.debian.org/debian/pool/main/n/node-mime/node-mime_2.5.0%2bdfsg%2b%7ecs3.90.0-1.dsc' node-mime_2.5.0+dfsg+~cs3.90.0-1.dsc 3177 SHA256:5eb72169eb870a3ef7f2b73092b49aa311aa79a76f930b94b102efd6d5d24720
'http://deb.debian.org/debian/pool/main/n/node-mime/node-mime_2.5.0%2bdfsg%2b%7ecs3.90.0.orig-mime-db.tar.xz' node-mime_2.5.0+dfsg+~cs3.90.0.orig-mime-db.tar.xz 59136 SHA256:e4b2d594c538a3a8650ca4f3508e20d8758c8dbc954734d53d189bceaa237bbb
'http://deb.debian.org/debian/pool/main/n/node-mime/node-mime_2.5.0%2bdfsg%2b%7ecs3.90.0.orig-mime-score.tar.xz' node-mime_2.5.0+dfsg+~cs3.90.0.orig-mime-score.tar.xz 2352 SHA256:9fec797aca61310538b78f735d4b76fa0e1bb1fd6bbea92a6c5cc12914d82577
'http://deb.debian.org/debian/pool/main/n/node-mime/node-mime_2.5.0%2bdfsg%2b%7ecs3.90.0.orig-types-mime-db.tar.xz' node-mime_2.5.0+dfsg+~cs3.90.0.orig-types-mime-db.tar.xz 1992 SHA256:8403f35c5dc93020c04258b3e2ff764e61722e76b77e46cd2954ca0e9330c35f
'http://deb.debian.org/debian/pool/main/n/node-mime/node-mime_2.5.0%2bdfsg%2b%7ecs3.90.0.orig.tar.xz' node-mime_2.5.0+dfsg+~cs3.90.0.orig.tar.xz 43280 SHA256:365bdc209c24c24cb237de23a5426d77e6c6b09a225bf10e89b54ba0bff52aca
'http://deb.debian.org/debian/pool/main/n/node-mime/node-mime_2.5.0%2bdfsg%2b%7ecs3.90.0-1.debian.tar.xz' node-mime_2.5.0+dfsg+~cs3.90.0-1.debian.tar.xz 4600 SHA256:7e95135adac290253a808d68fdb8844a0775fac954d295a213d971b891be31bd
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-mime/2.5.0+dfsg+~cs3.90.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-mime/2.5.0+dfsg+~cs3.90.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-mime/2.5.0+dfsg+~cs3.90.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-minimatch=3.0.4+~3.0.3-1+deb11u2`

Binary Packages:

- `node-minimatch=3.0.4+~3.0.3-1+deb11u2`

Licenses: (parsed from: `/usr/share/doc/node-minimatch/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-minimatch=3.0.4+~3.0.3-1+deb11u2
'http://deb.debian.org/debian/pool/main/n/node-minimatch/node-minimatch_3.0.4%2b%7e3.0.3-1%2bdeb11u2.dsc' node-minimatch_3.0.4+~3.0.3-1+deb11u2.dsc 2492 SHA256:1a1ab2fbbd74b3d9c35a2fa40cc54ec30969fe3b4aaa43a1054630f42c2939c6
'http://deb.debian.org/debian/pool/main/n/node-minimatch/node-minimatch_3.0.4%2b%7e3.0.3.orig-types-minimatch.tar.gz' node-minimatch_3.0.4+~3.0.3.orig-types-minimatch.tar.gz 2918 SHA256:71d7512873c41dda650f0be23fba8fe000d8abe948d8937fe4b040c0e6c61677
'http://deb.debian.org/debian/pool/main/n/node-minimatch/node-minimatch_3.0.4%2b%7e3.0.3.orig.tar.gz' node-minimatch_3.0.4+~3.0.3.orig.tar.gz 17303 SHA256:4d2b5945d821a8c097232e899561f9fe26a45057eab9d04bb7a5549b171b8a72
'http://deb.debian.org/debian/pool/main/n/node-minimatch/node-minimatch_3.0.4%2b%7e3.0.3-1%2bdeb11u2.debian.tar.xz' node-minimatch_3.0.4+~3.0.3-1+deb11u2.debian.tar.xz 7464 SHA256:6d2d5225c1c61e60179be620051c54440bc4840d5be520c2c9c2defba5adf50d
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-minimatch/3.0.4+~3.0.3-1+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/node-minimatch/3.0.4+~3.0.3-1+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-minimatch/3.0.4+~3.0.3-1+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-mkdirp=1.0.4+~1.0.1-1`

Binary Packages:

- `node-mkdirp=1.0.4+~1.0.1-1`

Licenses: (parsed from: `/usr/share/doc/node-mkdirp/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-mkdirp=1.0.4+~1.0.1-1
'http://deb.debian.org/debian/pool/main/n/node-mkdirp/node-mkdirp_1.0.4%2b%7e1.0.1-1.dsc' node-mkdirp_1.0.4+~1.0.1-1.dsc 2453 SHA256:b528b59df485dc7185bbdf8a9b1be8b3f77ef3d02695c3dedaf237aa1dabb6aa
'http://deb.debian.org/debian/pool/main/n/node-mkdirp/node-mkdirp_1.0.4%2b%7e1.0.1.orig-types-mkdirp.tar.gz' node-mkdirp_1.0.4+~1.0.1.orig-types-mkdirp.tar.gz 2505 SHA256:6d0f8c158c20adf4260d9f5488ffde3f0c51ca1cb7f7fdf22f1572d003edfcb5
'http://deb.debian.org/debian/pool/main/n/node-mkdirp/node-mkdirp_1.0.4%2b%7e1.0.1.orig.tar.gz' node-mkdirp_1.0.4+~1.0.1.orig.tar.gz 38981 SHA256:89852401f7b604e6137aa5a5357fcd4dbb153389569ca9a62fd3062a2fc124bc
'http://deb.debian.org/debian/pool/main/n/node-mkdirp/node-mkdirp_1.0.4%2b%7e1.0.1-1.debian.tar.xz' node-mkdirp_1.0.4+~1.0.1-1.debian.tar.xz 4576 SHA256:2aa73c1837437d20b11eb10b4d285d97403e2d66edae6325d3d90fd4c2858bdb
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-mkdirp/1.0.4+~1.0.1-1/ (for browsing the source)
- https://sources.debian.net/src/node-mkdirp/1.0.4+~1.0.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-mkdirp/1.0.4+~1.0.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-move-concurrently=1.0.1-2`

Binary Packages:

- `node-move-concurrently=1.0.1-2`

Licenses: (parsed from: `/usr/share/doc/node-move-concurrently/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-move-concurrently=1.0.1-2
'http://deb.debian.org/debian/pool/main/n/node-move-concurrently/node-move-concurrently_1.0.1-2.dsc' node-move-concurrently_1.0.1-2.dsc 2439 SHA256:878e60b54488d94f7fd44284cc3886a676cb5b56ed75ffbd60dcba6a5b49f538
'http://deb.debian.org/debian/pool/main/n/node-move-concurrently/node-move-concurrently_1.0.1.orig.tar.gz' node-move-concurrently_1.0.1.orig.tar.gz 4843 SHA256:e28f1a1435eef2ff80bff5281b5629f1a62675677ff0b606ea59ba8f82581153
'http://deb.debian.org/debian/pool/main/n/node-move-concurrently/node-move-concurrently_1.0.1-2.debian.tar.xz' node-move-concurrently_1.0.1-2.debian.tar.xz 2328 SHA256:78672cb4a931452d660641bb839f2c23ca5404a1b4d0a97a6a63faddb7d52b9b
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-move-concurrently/1.0.1-2/ (for browsing the source)
- https://sources.debian.net/src/node-move-concurrently/1.0.1-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-move-concurrently/1.0.1-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-ms=2.1.3+~cs0.7.31-1`

Binary Packages:

- `node-ms=2.1.3+~cs0.7.31-1`

Licenses: (parsed from: `/usr/share/doc/node-ms/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-ms=2.1.3+~cs0.7.31-1
'http://deb.debian.org/debian/pool/main/n/node-ms/node-ms_2.1.3%2b%7ecs0.7.31-1.dsc' node-ms_2.1.3+~cs0.7.31-1.dsc 2378 SHA256:afaa1639d3b8a25552d9c02f3c3bb411c36b9105d88f8d4676fe3db3d062c820
'http://deb.debian.org/debian/pool/main/n/node-ms/node-ms_2.1.3%2b%7ecs0.7.31.orig-typesms.tar.gz' node-ms_2.1.3+~cs0.7.31.orig-typesms.tar.gz 1612 SHA256:43c1f797421d639562755b038e9d4a6da1bd6de0ced4df16fcd3b293626d5836
'http://deb.debian.org/debian/pool/main/n/node-ms/node-ms_2.1.3%2b%7ecs0.7.31.orig.tar.gz' node-ms_2.1.3+~cs0.7.31.orig.tar.gz 20310 SHA256:272d3244fbe595576551031a5bcbc3683729ba3b77f9679f9b5b5e4ccb23ae1c
'http://deb.debian.org/debian/pool/main/n/node-ms/node-ms_2.1.3%2b%7ecs0.7.31-1.debian.tar.xz' node-ms_2.1.3+~cs0.7.31-1.debian.tar.xz 2936 SHA256:bcc4a25d682fe280fd14032aac85889fb65dbe64a2e2bbe7df90f3d18a01e8b5
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-ms/2.1.3+~cs0.7.31-1/ (for browsing the source)
- https://sources.debian.net/src/node-ms/2.1.3+~cs0.7.31-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-ms/2.1.3+~cs0.7.31-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-mute-stream=0.0.8-2`

Binary Packages:

- `node-mute-stream=0.0.8-2`

Licenses: (parsed from: `/usr/share/doc/node-mute-stream/copyright`)

- `GPL-3`
- `GPL-3.0+`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-mute-stream=0.0.8-2
'http://deb.debian.org/debian/pool/main/n/node-mute-stream/node-mute-stream_0.0.8-2.dsc' node-mute-stream_0.0.8-2.dsc 2086 SHA256:b6a04298a604c970eecdcd5f817e7ad59a159b1cba272ff3965308a7fceb10a7
'http://deb.debian.org/debian/pool/main/n/node-mute-stream/node-mute-stream_0.0.8.orig.tar.gz' node-mute-stream_0.0.8.orig.tar.gz 20686 SHA256:c1eaf69b53a9d2a42a1d9278e18adc4e2208e62510634356043d7e820be83ebc
'http://deb.debian.org/debian/pool/main/n/node-mute-stream/node-mute-stream_0.0.8-2.debian.tar.xz' node-mute-stream_0.0.8-2.debian.tar.xz 2836 SHA256:2710487ef669031c81da578621970f62bcaeccb119b30ca8ad48c52a414cca1a
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-mute-stream/0.0.8-2/ (for browsing the source)
- https://sources.debian.net/src/node-mute-stream/0.0.8-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-mute-stream/0.0.8-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-nopt=5.0.0-1`

Binary Packages:

- `node-nopt=5.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-nopt/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-nopt=5.0.0-1
'http://deb.debian.org/debian/pool/main/n/node-nopt/node-nopt_5.0.0-1.dsc' node-nopt_5.0.0-1.dsc 1997 SHA256:3b3908f2ee2accdc740d089b635eabc9cdfd6bc9f3bd12f6ae7b9f5ccbbe541c
'http://deb.debian.org/debian/pool/main/n/node-nopt/node-nopt_5.0.0.orig.tar.gz' node-nopt_5.0.0.orig.tar.gz 51293 SHA256:51f227f7f5e7abe84db82944bd5a83cdf52159a185b29b9b90d8ce4e8cf5b217
'http://deb.debian.org/debian/pool/main/n/node-nopt/node-nopt_5.0.0-1.debian.tar.xz' node-nopt_5.0.0-1.debian.tar.xz 2856 SHA256:28b71fd7192cde7056e943cf48b77e962901327a29f47fcfcacd40ef709c3f1a
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-nopt/5.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-nopt/5.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-nopt/5.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-normalize-package-data=3.0.0+~2.4.0-1`

Binary Packages:

- `node-normalize-package-data=3.0.0+~2.4.0-1`

Licenses: (parsed from: `/usr/share/doc/node-normalize-package-data/copyright`)

- `BSD-2-clause`
- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-normalize-package-data=3.0.0+~2.4.0-1
'http://deb.debian.org/debian/pool/main/n/node-normalize-package-data/node-normalize-package-data_3.0.0%2b%7e2.4.0-1.dsc' node-normalize-package-data_3.0.0+~2.4.0-1.dsc 2861 SHA256:9a992a958c153710cfa6ccd365d922cf5dd758579c127aa2c56c1ca1213b9876
'http://deb.debian.org/debian/pool/main/n/node-normalize-package-data/node-normalize-package-data_3.0.0%2b%7e2.4.0.orig-types-normalize-package-data.tar.gz' node-normalize-package-data_3.0.0+~2.4.0.orig-types-normalize-package-data.tar.gz 1786 SHA256:90a8066b88f7cf71e43fe79143bce45d8fd9245a9f11f3ca49ac494019a46a59
'http://deb.debian.org/debian/pool/main/n/node-normalize-package-data/node-normalize-package-data_3.0.0%2b%7e2.4.0.orig.tar.gz' node-normalize-package-data_3.0.0+~2.4.0.orig.tar.gz 90270 SHA256:3f87023d062f8840ed1a7c93eb519b0bfdafd5289bf206877844a74364757d6e
'http://deb.debian.org/debian/pool/main/n/node-normalize-package-data/node-normalize-package-data_3.0.0%2b%7e2.4.0-1.debian.tar.xz' node-normalize-package-data_3.0.0+~2.4.0-1.debian.tar.xz 3700 SHA256:58f8ad5542211095c47592f14764e29bab1bd17e3ac81571ff13791d404aee42
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-normalize-package-data/3.0.0+~2.4.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-normalize-package-data/3.0.0+~2.4.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-normalize-package-data/3.0.0+~2.4.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-npm-bundled=1.1.1-1`

Binary Packages:

- `node-npm-bundled=1.1.1-1`

Licenses: (parsed from: `/usr/share/doc/node-npm-bundled/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-npm-bundled=1.1.1-1
'http://deb.debian.org/debian/pool/main/n/node-npm-bundled/node-npm-bundled_1.1.1-1.dsc' node-npm-bundled_1.1.1-1.dsc 2449 SHA256:fd3173e6c4cb081e5adb32871db02a6e2e86b5b29a22bbf093188d7f83b99f20
'http://deb.debian.org/debian/pool/main/n/node-npm-bundled/node-npm-bundled_1.1.1.orig-npm-normalize-package-bin.tar.gz' node-npm-bundled_1.1.1.orig-npm-normalize-package-bin.tar.gz 30704 SHA256:1bf53c51fdc321df892f25d134b3e902330ea572f1bc3d27b1b17a5c2ecefd5a
'http://deb.debian.org/debian/pool/main/n/node-npm-bundled/node-npm-bundled_1.1.1.orig.tar.gz' node-npm-bundled_1.1.1.orig.tar.gz 21768 SHA256:15cc625b2cd44484c9ed05bc59252c8c00d321a00938a31de9ca9e13bcbdca00
'http://deb.debian.org/debian/pool/main/n/node-npm-bundled/node-npm-bundled_1.1.1-1.debian.tar.xz' node-npm-bundled_1.1.1-1.debian.tar.xz 2248 SHA256:19828143727b816a0c651e9cfde8e41e100c7a2559676b1e4cc8b22c3ff9963a
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-npm-bundled/1.1.1-1/ (for browsing the source)
- https://sources.debian.net/src/node-npm-bundled/1.1.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-npm-bundled/1.1.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-npm-package-arg=8.1.0-1`

Binary Packages:

- `node-npm-package-arg=8.1.0-1`

Licenses: (parsed from: `/usr/share/doc/node-npm-package-arg/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-npm-package-arg=8.1.0-1
'http://deb.debian.org/debian/pool/main/n/node-npm-package-arg/node-npm-package-arg_8.1.0-1.dsc' node-npm-package-arg_8.1.0-1.dsc 2284 SHA256:cf16153cd802d25aa65fe0aa115e55b543b5bc4a127c05e3b8cbf585c7d5eb6c
'http://deb.debian.org/debian/pool/main/n/node-npm-package-arg/node-npm-package-arg_8.1.0.orig.tar.gz' node-npm-package-arg_8.1.0.orig.tar.gz 90465 SHA256:98ce14c50ed3381c1a7f648fabf4c3aec575b84a87f4ef0c7f24c19ca7432852
'http://deb.debian.org/debian/pool/main/n/node-npm-package-arg/node-npm-package-arg_8.1.0-1.debian.tar.xz' node-npm-package-arg_8.1.0-1.debian.tar.xz 2468 SHA256:0b0ed571e072572b29323d1b698097df459802522cbffecaa375f23ac571610e
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-npm-package-arg/8.1.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-npm-package-arg/8.1.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-npm-package-arg/8.1.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-npmlog=4.1.2-2`

Binary Packages:

- `node-npmlog=4.1.2-2`

Licenses: (parsed from: `/usr/share/doc/node-npmlog/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-npmlog=4.1.2-2
'http://deb.debian.org/debian/pool/main/n/node-npmlog/node-npmlog_4.1.2-2.dsc' node-npmlog_4.1.2-2.dsc 2151 SHA256:bc8f861f1444132a5683d55c4d8bb234131edca31a57c942515cacc94131e0fe
'http://deb.debian.org/debian/pool/main/n/node-npmlog/node-npmlog_4.1.2.orig.tar.gz' node-npmlog_4.1.2.orig.tar.gz 32953 SHA256:62e351ae7f09f967bb18451e7c50b6782f0fc9fca812ebb0c88318067d32b6a5
'http://deb.debian.org/debian/pool/main/n/node-npmlog/node-npmlog_4.1.2-2.debian.tar.xz' node-npmlog_4.1.2-2.debian.tar.xz 2336 SHA256:5ef27f6618d77dbbd7b55415ce89aecef1d3e03614f0bb54652a428ed0888752
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-npmlog/4.1.2-2/ (for browsing the source)
- https://sources.debian.net/src/node-npmlog/4.1.2-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-npmlog/4.1.2-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-number-is-nan=2.0.0-1`

Binary Packages:

- `node-number-is-nan=2.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-number-is-nan/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-number-is-nan=2.0.0-1
'http://deb.debian.org/debian/pool/main/n/node-number-is-nan/node-number-is-nan_2.0.0-1.dsc' node-number-is-nan_2.0.0-1.dsc 2116 SHA256:5fadc74237000d34446b0d90b0e4322132d38acff2d26fda3880ab177c2f180e
'http://deb.debian.org/debian/pool/main/n/node-number-is-nan/node-number-is-nan_2.0.0.orig.tar.gz' node-number-is-nan_2.0.0.orig.tar.gz 2439 SHA256:491a0c9b434dc19a2d1ad6e6db5f1f2fc64f2cafd4a4293d0eac26e2550ff014
'http://deb.debian.org/debian/pool/main/n/node-number-is-nan/node-number-is-nan_2.0.0-1.debian.tar.xz' node-number-is-nan_2.0.0-1.debian.tar.xz 2624 SHA256:288a1c80a186ccc87458687a71ab3648f46dd3d3d94462bb28b30534ec8df729
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-number-is-nan/2.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-number-is-nan/2.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-number-is-nan/2.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-oauth-sign=0.9.0-2`

Binary Packages:

- `node-oauth-sign=0.9.0-2`

Licenses: (parsed from: `/usr/share/doc/node-oauth-sign/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris node-oauth-sign=0.9.0-2
'http://deb.debian.org/debian/pool/main/n/node-oauth-sign/node-oauth-sign_0.9.0-2.dsc' node-oauth-sign_0.9.0-2.dsc 2050 SHA256:d9f08825a7cbcd2f6067328d621222032ee66ee2dc33846e8a9614591e0ba0d6
'http://deb.debian.org/debian/pool/main/n/node-oauth-sign/node-oauth-sign_0.9.0.orig.tar.gz' node-oauth-sign_0.9.0.orig.tar.gz 7032 SHA256:f8e2a58b21677963f5895c774dde9207d0f96a2a2300e8430589acafd4876730
'http://deb.debian.org/debian/pool/main/n/node-oauth-sign/node-oauth-sign_0.9.0-2.debian.tar.xz' node-oauth-sign_0.9.0-2.debian.tar.xz 2276 SHA256:ec2133ae94e3d25be247ea2a570845780e41029b66102485398a9c0870f36e58
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-oauth-sign/0.9.0-2/ (for browsing the source)
- https://sources.debian.net/src/node-oauth-sign/0.9.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-oauth-sign/0.9.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-object-assign=4.1.1-3`

Binary Packages:

- `node-object-assign=4.1.1-3`

Licenses: (parsed from: `/usr/share/doc/node-object-assign/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-object-assign=4.1.1-3
'http://deb.debian.org/debian/pool/main/n/node-object-assign/node-object-assign_4.1.1-3.dsc' node-object-assign_4.1.1-3.dsc 2129 SHA256:63b7d6366c5e1e72a61248d2fd8c35cbb6bef1dc43de808560006164c4fb9781
'http://deb.debian.org/debian/pool/main/n/node-object-assign/node-object-assign_4.1.1.orig.tar.gz' node-object-assign_4.1.1.orig.tar.gz 4122 SHA256:16fd04bb99fb67bd485bb6b2af033892a07f8020012499bb4275fec4745aeeb5
'http://deb.debian.org/debian/pool/main/n/node-object-assign/node-object-assign_4.1.1-3.debian.tar.xz' node-object-assign_4.1.1-3.debian.tar.xz 3284 SHA256:a617f406dbbcc2ea19e376080fd92732d21054838dc743b57746a5cdab97fa8d
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-object-assign/4.1.1-3/ (for browsing the source)
- https://sources.debian.net/src/node-object-assign/4.1.1-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-object-assign/4.1.1-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-once=1.4.0-3`

Binary Packages:

- `node-once=1.4.0-3`

Licenses: (parsed from: `/usr/share/doc/node-once/copyright`)

- `BSD-2-clause`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-once=1.4.0-3
'http://deb.debian.org/debian/pool/main/n/node-once/node-once_1.4.0-3.dsc' node-once_1.4.0-3.dsc 2075 SHA256:59868398b1a842a68c2ae02367369f677c3a91f2e1fedfe7ad48d5258797d491
'http://deb.debian.org/debian/pool/main/n/node-once/node-once_1.4.0.orig.tar.gz' node-once_1.4.0.orig.tar.gz 2629 SHA256:51cd65d1759460a1e06288a71ef7152bb26da16233bd50324fa42971321babb5
'http://deb.debian.org/debian/pool/main/n/node-once/node-once_1.4.0-3.debian.tar.xz' node-once_1.4.0-3.debian.tar.xz 2860 SHA256:670607bf5c45369c9ac1b55a6310914e6eeec7c52dad1a9172bf14b38bc530bd
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-once/1.4.0-3/ (for browsing the source)
- https://sources.debian.net/src/node-once/1.4.0-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-once/1.4.0-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-opener=1.5.2-1`

Binary Packages:

- `node-opener=1.5.2-1`

Licenses: (parsed from: `/usr/share/doc/node-opener/copyright`)

- `Expat`
- `WTFPL`

Source:

```console
$ apt-get source -qq --print-uris node-opener=1.5.2-1
'http://deb.debian.org/debian/pool/main/n/node-opener/node-opener_1.5.2-1.dsc' node-opener_1.5.2-1.dsc 2002 SHA256:760daf3d7e004f41f3ea2e36cd73644043beebb299caa5714e438db82d9b1a7b
'http://deb.debian.org/debian/pool/main/n/node-opener/node-opener_1.5.2.orig.tar.gz' node-opener_1.5.2.orig.tar.gz 16235 SHA256:c2fa3cbe57906f693a0e01efc0d19a949b5549cd16e86f158fa560c9343cd28b
'http://deb.debian.org/debian/pool/main/n/node-opener/node-opener_1.5.2-1.debian.tar.xz' node-opener_1.5.2-1.debian.tar.xz 2832 SHA256:5ae95e4c63650ecdc3a4f18c7a56795f12d619ac4135f31b810d3498f7c4aed3
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-opener/1.5.2-1/ (for browsing the source)
- https://sources.debian.net/src/node-opener/1.5.2-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-opener/1.5.2-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-osenv=0.1.5-1`

Binary Packages:

- `node-osenv=0.1.5-1`

Licenses: (parsed from: `/usr/share/doc/node-osenv/copyright`)

- `BSD-2-clause`

Source:

```console
$ apt-get source -qq --print-uris node-osenv=0.1.5-1
'http://deb.debian.org/debian/pool/main/n/node-osenv/node-osenv_0.1.5-1.dsc' node-osenv_0.1.5-1.dsc 2008 SHA256:a9741eb47bbe0b34187fecbbcd188b28263f580113b3144e14b4be4be96cd263
'http://deb.debian.org/debian/pool/main/n/node-osenv/node-osenv_0.1.5.orig.tar.gz' node-osenv_0.1.5.orig.tar.gz 17594 SHA256:68ba39e60f120d850c6c52d3cc383dae8299632065660fd985501bfcd82bcbab
'http://deb.debian.org/debian/pool/main/n/node-osenv/node-osenv_0.1.5-1.debian.tar.xz' node-osenv_0.1.5-1.debian.tar.xz 2732 SHA256:3ac0442807352d5d3829ea306ef8733670d0bdf1dbdfa54e85ca39821c184274
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-osenv/0.1.5-1/ (for browsing the source)
- https://sources.debian.net/src/node-osenv/0.1.5-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-osenv/0.1.5-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-p-map=4.0.0-1`

Binary Packages:

- `node-p-map=4.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-p-map/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-p-map=4.0.0-1
'http://deb.debian.org/debian/pool/main/n/node-p-map/node-p-map_4.0.0-1.dsc' node-p-map_4.0.0-1.dsc 2662 SHA256:91ae09eee038cbe5e197c65458404f86a6ee806eb450631ce65280cfc08e3ad1
'http://deb.debian.org/debian/pool/main/n/node-p-map/node-p-map_4.0.0.orig-aggregate-error.tar.gz' node-p-map_4.0.0.orig-aggregate-error.tar.gz 3758 SHA256:03dcbeabdaa1b14c5b847c99e89ac759ee94299cd71ade4ed38e4f4bdb71360c
'http://deb.debian.org/debian/pool/main/n/node-p-map/node-p-map_4.0.0.orig-clean-stack.tar.gz' node-p-map_4.0.0.orig-clean-stack.tar.gz 4282 SHA256:49dfd42ba2aa047f9dd2e380efd6cc98bf3741e09a48d2a7106ee0dcc439abdd
'http://deb.debian.org/debian/pool/main/n/node-p-map/node-p-map_4.0.0.orig.tar.gz' node-p-map_4.0.0.orig.tar.gz 5208 SHA256:d61f9167a876080f2180200053d371f0f9842e135c3e18b791b65e9400d19969
'http://deb.debian.org/debian/pool/main/n/node-p-map/node-p-map_4.0.0-1.debian.tar.xz' node-p-map_4.0.0-1.debian.tar.xz 7772 SHA256:b1314f478a156ff80ca20378dcc9190acf9f865422767b6bde95bd11f1132c42
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-p-map/4.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-p-map/4.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-p-map/4.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-path-is-absolute=2.0.0-1`

Binary Packages:

- `node-path-is-absolute=2.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-path-is-absolute/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-path-is-absolute=2.0.0-1
'http://deb.debian.org/debian/pool/main/n/node-path-is-absolute/node-path-is-absolute_2.0.0-1.dsc' node-path-is-absolute_2.0.0-1.dsc 2130 SHA256:03751e7090987faee7c9e230be505b034bd229a34dba9ba62f0c43158ce30457
'http://deb.debian.org/debian/pool/main/n/node-path-is-absolute/node-path-is-absolute_2.0.0.orig.tar.gz' node-path-is-absolute_2.0.0.orig.tar.gz 2589 SHA256:50367a36c421181e4a41f5966c15837673e3e98f0c3634761beabe58d986c73e
'http://deb.debian.org/debian/pool/main/n/node-path-is-absolute/node-path-is-absolute_2.0.0-1.debian.tar.xz' node-path-is-absolute_2.0.0-1.debian.tar.xz 2520 SHA256:f7eb641acfa57428677cfa94825204315df08fc86f599a77bc7345bfd7e156f1
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-path-is-absolute/2.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-path-is-absolute/2.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-path-is-absolute/2.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-performance-now=2.1.0+debian-1.1`

Binary Packages:

- `node-performance-now=2.1.0+debian-1.1`

Licenses: (parsed from: `/usr/share/doc/node-performance-now/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-performance-now=2.1.0+debian-1.1
'http://deb.debian.org/debian/pool/main/n/node-performance-now/node-performance-now_2.1.0%2bdebian-1.1.dsc' node-performance-now_2.1.0+debian-1.1.dsc 2188 SHA256:dc69c88c7d3c7b05b7c5cd96ae3461c19b50b311f1b379fd38cc7b47d9993536
'http://deb.debian.org/debian/pool/main/n/node-performance-now/node-performance-now_2.1.0%2bdebian.orig.tar.xz' node-performance-now_2.1.0+debian.orig.tar.xz 3804 SHA256:3e818ca59780dea131bbd5f1282387c162be1f7525dea527aaa4aee6ee7852da
'http://deb.debian.org/debian/pool/main/n/node-performance-now/node-performance-now_2.1.0%2bdebian-1.1.debian.tar.xz' node-performance-now_2.1.0+debian-1.1.debian.tar.xz 2528 SHA256:3b2fe0be8a45b3351feb5a9d8a3ea71ac57d260a9a78dab2cd11ecf9c0bb6e56
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-performance-now/2.1.0+debian-1.1/ (for browsing the source)
- https://sources.debian.net/src/node-performance-now/2.1.0+debian-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-performance-now/2.1.0+debian-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-process-nextick-args=2.0.0-1`

Binary Packages:

- `node-process-nextick-args=2.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-process-nextick-args/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-process-nextick-args=2.0.0-1
'http://deb.debian.org/debian/pool/main/n/node-process-nextick-args/node-process-nextick-args_2.0.0-1.dsc' node-process-nextick-args_2.0.0-1.dsc 2270 SHA256:56e4dec12dd31697f70ddbc9291336f9a1f8ebe5a8ac6097745f7c1fce0e1881
'http://deb.debian.org/debian/pool/main/n/node-process-nextick-args/node-process-nextick-args_2.0.0.orig.tar.gz' node-process-nextick-args_2.0.0.orig.tar.gz 2163 SHA256:ebf99cad8e69f077c9a54125663a8c766499275fff80a778976c1087f1c384e0
'http://deb.debian.org/debian/pool/main/n/node-process-nextick-args/node-process-nextick-args_2.0.0-1.debian.tar.xz' node-process-nextick-args_2.0.0-1.debian.tar.xz 2932 SHA256:b837e892f40f490128efdc0dc42aee9fd38b5d4a3ac99e2bf87339d6f504cbe1
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-process-nextick-args/2.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-process-nextick-args/2.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-process-nextick-args/2.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-promise-inflight=1.0.1-1.1`

Binary Packages:

- `node-promise-inflight=1.0.1-1.1`

Licenses: (parsed from: `/usr/share/doc/node-promise-inflight/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-promise-inflight=1.0.1-1.1
'http://deb.debian.org/debian/pool/main/n/node-promise-inflight/node-promise-inflight_1.0.1-1.1.dsc' node-promise-inflight_1.0.1-1.1.dsc 2135 SHA256:e581fc21e0c5d086e92bae53e7cdf3cfc8531c99a57513f60e127973d6f56b7d
'http://deb.debian.org/debian/pool/main/n/node-promise-inflight/node-promise-inflight_1.0.1.orig.tar.gz' node-promise-inflight_1.0.1.orig.tar.gz 1830 SHA256:76d071ffdb62a55bc36d25b464e652dd7b7fdfc1ce3250d7351124ef62c67748
'http://deb.debian.org/debian/pool/main/n/node-promise-inflight/node-promise-inflight_1.0.1-1.1.debian.tar.xz' node-promise-inflight_1.0.1-1.1.debian.tar.xz 2052 SHA256:ef2a6a4294c6a9958e3e0df03e96eecab0fd8480ffa29535a21fce1699f49441
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-promise-inflight/1.0.1-1.1/ (for browsing the source)
- https://sources.debian.net/src/node-promise-inflight/1.0.1-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-promise-inflight/1.0.1-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-promise-retry=2.0.1-1`

Binary Packages:

- `node-promise-retry=2.0.1-1`

Licenses: (parsed from: `/usr/share/doc/node-promise-retry/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-promise-retry=2.0.1-1
'http://deb.debian.org/debian/pool/main/n/node-promise-retry/node-promise-retry_2.0.1-1.dsc' node-promise-retry_2.0.1-1.dsc 2227 SHA256:1e038bd4c47b909fd6811383e9999d6c52ee17e2f2db11e243aa662d2feeab4d
'http://deb.debian.org/debian/pool/main/n/node-promise-retry/node-promise-retry_2.0.1.orig.tar.gz' node-promise-retry_2.0.1.orig.tar.gz 16029 SHA256:4ff9576d6d6e961dd7cd92ee67145978ba922fbe0a35ba8c1d0cd088886b2c28
'http://deb.debian.org/debian/pool/main/n/node-promise-retry/node-promise-retry_2.0.1-1.debian.tar.xz' node-promise-retry_2.0.1-1.debian.tar.xz 3292 SHA256:c36de1692e1dd97de0d404fd76fbfd30e4388264b63052d0f476600a6d3c8175
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-promise-retry/2.0.1-1/ (for browsing the source)
- https://sources.debian.net/src/node-promise-retry/2.0.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-promise-retry/2.0.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-promzard=0.3.0-1.1`

Binary Packages:

- `node-promzard=0.3.0-1.1`

Licenses: (parsed from: `/usr/share/doc/node-promzard/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-promzard=0.3.0-1.1
'http://deb.debian.org/debian/pool/main/n/node-promzard/node-promzard_0.3.0-1.1.dsc' node-promzard_0.3.0-1.1.dsc 2051 SHA256:3c6bc1fa965b84463fe9089b4857e57b7eb5c31c7d8a4b2715fb9accb0665dd3
'http://deb.debian.org/debian/pool/main/n/node-promzard/node-promzard_0.3.0.orig.tar.gz' node-promzard_0.3.0.orig.tar.gz 9245 SHA256:21ad33fc4d12d1ae82664d7920e9a6875ca7d77b4857efbd2342b910f6c47dd1
'http://deb.debian.org/debian/pool/main/n/node-promzard/node-promzard_0.3.0-1.1.debian.tar.xz' node-promzard_0.3.0-1.1.debian.tar.xz 2196 SHA256:02d5fef95613ad53587aa292e6b68c1046cff05b9949ec27fbb649c9bd37b75a
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-promzard/0.3.0-1.1/ (for browsing the source)
- https://sources.debian.net/src/node-promzard/0.3.0-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-promzard/0.3.0-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-puka=1.0.1+dfsg-2`

Binary Packages:

- `node-puka=1.0.1+dfsg-2`

Licenses: (parsed from: `/usr/share/doc/node-puka/copyright`)

- `Expat`
- `GPL-3`
- `GPL-3.0+`

Source:

```console
$ apt-get source -qq --print-uris node-puka=1.0.1+dfsg-2
'http://deb.debian.org/debian/pool/main/n/node-puka/node-puka_1.0.1%2bdfsg-2.dsc' node-puka_1.0.1+dfsg-2.dsc 2070 SHA256:db32fd0be2b221a38c8590cbc41db489b615291744153b1b7699fdd622c7ca1b
'http://deb.debian.org/debian/pool/main/n/node-puka/node-puka_1.0.1%2bdfsg.orig.tar.xz' node-puka_1.0.1+dfsg.orig.tar.xz 155984 SHA256:451aa2ab3755400e9755d1481ef3d9ecbd1e241777e119860b0fca8717a58a36
'http://deb.debian.org/debian/pool/main/n/node-puka/node-puka_1.0.1%2bdfsg-2.debian.tar.xz' node-puka_1.0.1+dfsg-2.debian.tar.xz 3652 SHA256:a4a0340be4ec5e4a8aab5b6223dede9dbaf8d13ed3043946172b95fe22f486e4
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-puka/1.0.1+dfsg-2/ (for browsing the source)
- https://sources.debian.net/src/node-puka/1.0.1+dfsg-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-puka/1.0.1+dfsg-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-punycode=2.1.1-3`

Binary Packages:

- `node-punycode=2.1.1-3`

Licenses: (parsed from: `/usr/share/doc/node-punycode/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-punycode=2.1.1-3
'http://deb.debian.org/debian/pool/main/n/node-punycode/node-punycode_2.1.1-3.dsc' node-punycode_2.1.1-3.dsc 2140 SHA256:656ef8bac52ec545d5ac033823dde817516fcbe78dba4a96791e5b5fcd424b0c
'http://deb.debian.org/debian/pool/main/n/node-punycode/node-punycode_2.1.1.orig.tar.gz' node-punycode_2.1.1.orig.tar.gz 10814 SHA256:3411a21276d5dfe72d858b0eebb44dc7b8f932ef05c79e4db246ac966206e16e
'http://deb.debian.org/debian/pool/main/n/node-punycode/node-punycode_2.1.1-3.debian.tar.xz' node-punycode_2.1.1-3.debian.tar.xz 3104 SHA256:6d20a53edf4536e3a8b94580057f6a1d0318917cd2929cd878f90503e43c3d89
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-punycode/2.1.1-3/ (for browsing the source)
- https://sources.debian.net/src/node-punycode/2.1.1-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-punycode/2.1.1-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-qs=6.9.4+ds-1+deb11u1`

Binary Packages:

- `node-qs=6.9.4+ds-1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/node-qs/copyright`)

- `BSD-3-clause`
- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-qs=6.9.4+ds-1+deb11u1
'http://deb.debian.org/debian/pool/main/n/node-qs/node-qs_6.9.4%2bds-1%2bdeb11u1.dsc' node-qs_6.9.4+ds-1+deb11u1.dsc 2133 SHA256:982945005b6a6c64269634997c3985128b73b0d23506e84a6e5a31611d90bac0
'http://deb.debian.org/debian/pool/main/n/node-qs/node-qs_6.9.4%2bds.orig.tar.xz' node-qs_6.9.4+ds.orig.tar.xz 27104 SHA256:176a4a2cbb996a9fc0aee8a02c7958c9c20c99ee7ad26ffd2a0a69b3355bb8ef
'http://deb.debian.org/debian/pool/main/n/node-qs/node-qs_6.9.4%2bds-1%2bdeb11u1.debian.tar.xz' node-qs_6.9.4+ds-1+deb11u1.debian.tar.xz 8708 SHA256:a8492100ac6598dbaa32c92b0f8d484ab39412560a971ca3d939cb397c4f8b0e
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-qs/6.9.4+ds-1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/node-qs/6.9.4+ds-1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-qs/6.9.4+ds-1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-read-package-json=3.0.0-1`

Binary Packages:

- `node-read-package-json=3.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-read-package-json/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-read-package-json=3.0.0-1
'http://deb.debian.org/debian/pool/main/n/node-read-package-json/node-read-package-json_3.0.0-1.dsc' node-read-package-json_3.0.0-1.dsc 2609 SHA256:eef5cb9ceb980b3632625d909b14d0ec85fd1a7811c7fb8925461ea6ac1e06fc
'http://deb.debian.org/debian/pool/main/n/node-read-package-json/node-read-package-json_3.0.0.orig-npm-normalize-package-bin.tar.gz' node-read-package-json_3.0.0.orig-npm-normalize-package-bin.tar.gz 31250 SHA256:e8983f7c59e45907f04d2d337b3ff2fe08ab16b4b18d9f5f14795ce9c97930b1
'http://deb.debian.org/debian/pool/main/n/node-read-package-json/node-read-package-json_3.0.0.orig.tar.gz' node-read-package-json_3.0.0.orig.tar.gz 127227 SHA256:36a58edee8bada51cd2fdeec8027aa861c5e015bfad4981bc1ce2330c2e1a954
'http://deb.debian.org/debian/pool/main/n/node-read-package-json/node-read-package-json_3.0.0-1.debian.tar.xz' node-read-package-json_3.0.0-1.debian.tar.xz 3252 SHA256:1fd1433ccae309f75270e17766ffc5dc175690348e587b62597ae66f148ff720
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-read-package-json/3.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-read-package-json/3.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-read-package-json/3.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-read=1.0.7-2`

Binary Packages:

- `node-read=1.0.7-2`

Licenses: (parsed from: `/usr/share/doc/node-read/copyright`)

- `GPL-3`
- `GPL-3.0+`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-read=1.0.7-2
'http://deb.debian.org/debian/pool/main/n/node-read/node-read_1.0.7-2.dsc' node-read_1.0.7-2.dsc 2006 SHA256:41317c6e3e70b30b073bbb43843423423727d05cdf450cec9a25e41098c00a2e
'http://deb.debian.org/debian/pool/main/n/node-read/node-read_1.0.7.orig.tar.gz' node-read_1.0.7.orig.tar.gz 4246 SHA256:be34449731a07f57d2d69f961473d17648783e9077d47aa69d87f5121511cb5a
'http://deb.debian.org/debian/pool/main/n/node-read/node-read_1.0.7-2.debian.tar.xz' node-read_1.0.7-2.debian.tar.xz 2744 SHA256:2c730cf9859e4b17f55e6ee718b2216a4be9b2eebd1864c492915a774dc5f137
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-read/1.0.7-2/ (for browsing the source)
- https://sources.debian.net/src/node-read/1.0.7-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-read/1.0.7-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-readable-stream=3.6.0-2`

Binary Packages:

- `node-readable-stream=3.6.0-2`

Licenses: (parsed from: `/usr/share/doc/node-readable-stream/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-readable-stream=3.6.0-2
'http://deb.debian.org/debian/pool/main/n/node-readable-stream/node-readable-stream_3.6.0-2.dsc' node-readable-stream_3.6.0-2.dsc 2781 SHA256:43f602df062c6ba2d29f85e93ed6f19dfabed1a3f000cc94caa801b24161a7b8
'http://deb.debian.org/debian/pool/main/n/node-readable-stream/node-readable-stream_3.6.0.orig.tar.gz' node-readable-stream_3.6.0.orig.tar.gz 158296 SHA256:2174fce03850b5bb5694d8e983f3dc927382edaf0a800baa4fba475d01899322
'http://deb.debian.org/debian/pool/main/n/node-readable-stream/node-readable-stream_3.6.0-2.debian.tar.xz' node-readable-stream_3.6.0-2.debian.tar.xz 16404 SHA256:03b301791325400d6a964382d408df48317c92e33f623d1fb366af97679987ab
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-readable-stream/3.6.0-2/ (for browsing the source)
- https://sources.debian.net/src/node-readable-stream/3.6.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-readable-stream/3.6.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-resolve-from=5.0.0+~3.1.0+~3.3.0+~2.0.0-1`

Binary Packages:

- `node-resolve-from=5.0.0+~3.1.0+~3.3.0+~2.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-resolve-from/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-resolve-from=5.0.0+~3.1.0+~3.3.0+~2.0.0-1
'http://deb.debian.org/debian/pool/main/n/node-resolve-from/node-resolve-from_5.0.0%2b%7e3.1.0%2b%7e3.3.0%2b%7e2.0.0-1.dsc' node-resolve-from_5.0.0+~3.1.0+~3.3.0+~2.0.0-1.dsc 3371 SHA256:ae19102c58cd9630443b24b33cb782bbc278900c7eaf592869afe889832849df
'http://deb.debian.org/debian/pool/main/n/node-resolve-from/node-resolve-from_5.0.0%2b%7e3.1.0%2b%7e3.3.0%2b%7e2.0.0.orig-Xcall.tar.gz' node-resolve-from_5.0.0+~3.1.0+~3.3.0+~2.0.0.orig-Xcall.tar.gz 3090 SHA256:1885d6a24977d854177b87568690f053831707c5fb07bb4cedfd6120c888bd5e
'http://deb.debian.org/debian/pool/main/n/node-resolve-from/node-resolve-from_5.0.0%2b%7e3.1.0%2b%7e3.3.0%2b%7e2.0.0.orig-Xfresh.tar.gz' node-resolve-from_5.0.0+~3.1.0+~3.3.0+~2.0.0.orig-Xfresh.tar.gz 3943 SHA256:0777e30d8a575249e8a96f387074b7b48e7fb4b9746629df4dba23221580795f
'http://deb.debian.org/debian/pool/main/n/node-resolve-from/node-resolve-from_5.0.0%2b%7e3.1.0%2b%7e3.3.0%2b%7e2.0.0.orig-Xparent.tar.gz' node-resolve-from_5.0.0+~3.1.0+~3.3.0+~2.0.0.orig-Xparent.tar.gz 3128 SHA256:1208e7b33c3467d439f32b2ba987d629679f3197b1e5e7168b2f445f52aea49d
'http://deb.debian.org/debian/pool/main/n/node-resolve-from/node-resolve-from_5.0.0%2b%7e3.1.0%2b%7e3.3.0%2b%7e2.0.0.orig.tar.gz' node-resolve-from_5.0.0+~3.1.0+~3.3.0+~2.0.0.orig.tar.gz 3444 SHA256:7863a3fcfc14e5187f3111aa0d2ebbb420241955dd9ac456f74bd37300c1cbfa
'http://deb.debian.org/debian/pool/main/n/node-resolve-from/node-resolve-from_5.0.0%2b%7e3.1.0%2b%7e3.3.0%2b%7e2.0.0-1.debian.tar.xz' node-resolve-from_5.0.0+~3.1.0+~3.3.0+~2.0.0-1.debian.tar.xz 5136 SHA256:b5ce042d947b5242906961d113dfd0d8faf3bd375e0e490b810e93bbe5040a95
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-resolve-from/5.0.0+~3.1.0+~3.3.0+~2.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-resolve-from/5.0.0+~3.1.0+~3.3.0+~2.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-resolve-from/5.0.0+~3.1.0+~3.3.0+~2.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-resolve=1.19.0+~cs5.20.8-2`

Binary Packages:

- `node-resolve=1.19.0+~cs5.20.8-2`

Licenses: (parsed from: `/usr/share/doc/node-resolve/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-resolve=1.19.0+~cs5.20.8-2
'http://deb.debian.org/debian/pool/main/n/node-resolve/node-resolve_1.19.0%2b%7ecs5.20.8-2.dsc' node-resolve_1.19.0+~cs5.20.8-2.dsc 3438 SHA256:f1fdb6b73924575b35f13181b67a02e643cb14b1a70b3f6deaf235b7db74ee3b
'http://deb.debian.org/debian/pool/main/n/node-resolve/node-resolve_1.19.0%2b%7ecs5.20.8.orig-is-core-module.tar.gz' node-resolve_1.19.0+~cs5.20.8.orig-is-core-module.tar.gz 7946 SHA256:5fede0930de9fbb715ae3bca51613f02312eb12256c72b267a71e4d057643a9e
'http://deb.debian.org/debian/pool/main/n/node-resolve/node-resolve_1.19.0%2b%7ecs5.20.8.orig-object-keys.tar.gz' node-resolve_1.19.0+~cs5.20.8.orig-object-keys.tar.gz 9968 SHA256:906cf19a85aaeff60b0319e59dd0fa1cb1a71749923f3792f2849418bf7e9945
'http://deb.debian.org/debian/pool/main/n/node-resolve/node-resolve_1.19.0%2b%7ecs5.20.8.orig-path-parse.tar.gz' node-resolve_1.19.0+~cs5.20.8.orig-path-parse.tar.gz 3231 SHA256:a4a932d61bf4bd3f7b7a8020434e71101195862a86d0ce1e147e7a92cfe6a11f
'http://deb.debian.org/debian/pool/main/n/node-resolve/node-resolve_1.19.0%2b%7ecs5.20.8.orig-types-resolve.tar.gz' node-resolve_1.19.0+~cs5.20.8.orig-types-resolve.tar.gz 2929 SHA256:51a8fc8770053b39898ee96d13a55d4724de1ed7275e6a1ae3c8bf367057a3f4
'http://deb.debian.org/debian/pool/main/n/node-resolve/node-resolve_1.19.0%2b%7ecs5.20.8.orig.tar.gz' node-resolve_1.19.0+~cs5.20.8.orig.tar.gz 25669 SHA256:e75bd814f103f3903eb85b50bd1b64e86a2f457b1135edba1d6617a8df2a4357
'http://deb.debian.org/debian/pool/main/n/node-resolve/node-resolve_1.19.0%2b%7ecs5.20.8-2.debian.tar.xz' node-resolve_1.19.0+~cs5.20.8-2.debian.tar.xz 4672 SHA256:674a125f79861c73eb9d437b5b3fa401bf8a4ad98c92f70c6e099bf789f445f3
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-resolve/1.19.0+~cs5.20.8-2/ (for browsing the source)
- https://sources.debian.net/src/node-resolve/1.19.0+~cs5.20.8-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-resolve/1.19.0+~cs5.20.8-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-retry=0.12.0-1`

Binary Packages:

- `node-retry=0.12.0-1`

Licenses: (parsed from: `/usr/share/doc/node-retry/copyright`)

- `Expat`
- `GPL-3`
- `GPL-3.0+`

Source:

```console
$ apt-get source -qq --print-uris node-retry=0.12.0-1
'http://deb.debian.org/debian/pool/main/n/node-retry/node-retry_0.12.0-1.dsc' node-retry_0.12.0-1.dsc 2045 SHA256:20b00288c158fe6f30d1ff7897cb44472ea4d6d79b90eef8a0bf8f1b01b1bd69
'http://deb.debian.org/debian/pool/main/n/node-retry/node-retry_0.12.0.orig.tar.gz' node-retry_0.12.0.orig.tar.gz 10529 SHA256:cef8f2ce6d82ce72d1178bff877d2b4fdeb2e71785bfec1d1e92275d7ef6abc3
'http://deb.debian.org/debian/pool/main/n/node-retry/node-retry_0.12.0-1.debian.tar.xz' node-retry_0.12.0-1.debian.tar.xz 3676 SHA256:69c36eb4419bc9122de78d0f1f1dc12c2a7cbe5d5fbe9be0e47dff27477b96df
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-retry/0.12.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-retry/0.12.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-retry/0.12.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-rimraf=3.0.2-1`

Binary Packages:

- `node-rimraf=3.0.2-1`

Licenses: (parsed from: `/usr/share/doc/node-rimraf/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-rimraf=3.0.2-1
'http://deb.debian.org/debian/pool/main/n/node-rimraf/node-rimraf_3.0.2-1.dsc' node-rimraf_3.0.2-1.dsc 2318 SHA256:c8e081f30e4750f43147b5155d77af51fa85f9a197e1326a6f154bdfdd64746f
'http://deb.debian.org/debian/pool/main/n/node-rimraf/node-rimraf_3.0.2.orig-types-rimraf.tar.gz' node-rimraf_3.0.2.orig-types-rimraf.tar.gz 2183 SHA256:07f91757909a215d5fdd7fdd0c978ec9d47799b7a584ee596697d3d543facb63
'http://deb.debian.org/debian/pool/main/n/node-rimraf/node-rimraf_3.0.2.orig.tar.gz' node-rimraf_3.0.2.orig.tar.gz 26331 SHA256:f15579fdbf1a49c1e435e3163f7ba8119ddb7cab5eddb3300b3c6facd0726fe7
'http://deb.debian.org/debian/pool/main/n/node-rimraf/node-rimraf_3.0.2-1.debian.tar.xz' node-rimraf_3.0.2-1.debian.tar.xz 4100 SHA256:441cdb381155e24056eb6fdb02c3a9fbc7e357458f0e74f206d91f026b2ab46b
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-rimraf/3.0.2-1/ (for browsing the source)
- https://sources.debian.net/src/node-rimraf/3.0.2-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-rimraf/3.0.2-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-run-queue=2.0.0-1`

Binary Packages:

- `node-run-queue=2.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-run-queue/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-run-queue=2.0.0-1
'http://deb.debian.org/debian/pool/main/n/node-run-queue/node-run-queue_2.0.0-1.dsc' node-run-queue_2.0.0-1.dsc 2080 SHA256:532c0a0c177f967387f74c0c0ab625291c351856c94290815ffd64b132a2d3b9
'http://deb.debian.org/debian/pool/main/n/node-run-queue/node-run-queue_2.0.0.orig.tar.gz' node-run-queue_2.0.0.orig.tar.gz 4039 SHA256:5e3cdedcce6e6aeb49c1b2e406f0b6861507364358a2ad7ea944cd35f40fe894
'http://deb.debian.org/debian/pool/main/n/node-run-queue/node-run-queue_2.0.0-1.debian.tar.xz' node-run-queue_2.0.0-1.debian.tar.xz 2548 SHA256:f87bcfc79778bec5834827d54b2fe044994849ae1085ee739bb313128aea3124
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-run-queue/2.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-run-queue/2.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-run-queue/2.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-safe-buffer=5.2.1+~cs2.1.2-1`

Binary Packages:

- `node-safe-buffer=5.2.1+~cs2.1.2-1`

Licenses: (parsed from: `/usr/share/doc/node-safe-buffer/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-safe-buffer=5.2.1+~cs2.1.2-1
'http://deb.debian.org/debian/pool/main/n/node-safe-buffer/node-safe-buffer_5.2.1%2b%7ecs2.1.2-1.dsc' node-safe-buffer_5.2.1+~cs2.1.2-1.dsc 2516 SHA256:56861ee4550378e84ebcd7fbb42b8e863635e4a8e5ec3f1a9ca7a761b5241028
'http://deb.debian.org/debian/pool/main/n/node-safe-buffer/node-safe-buffer_5.2.1%2b%7ecs2.1.2.orig-safer-buffer.tar.gz' node-safe-buffer_5.2.1+~cs2.1.2.orig-safer-buffer.tar.gz 12452 SHA256:b6ee19114b7a665572165b4b68fec98ecb09124c2869bb79b0a4a4e004e59e07
'http://deb.debian.org/debian/pool/main/n/node-safe-buffer/node-safe-buffer_5.2.1%2b%7ecs2.1.2.orig.tar.gz' node-safe-buffer_5.2.1+~cs2.1.2.orig.tar.gz 10701 SHA256:51bc669006b75bb99751a6cd4ff33c45d60f0573296f545abee5b8e379f0dc1d
'http://deb.debian.org/debian/pool/main/n/node-safe-buffer/node-safe-buffer_5.2.1%2b%7ecs2.1.2-1.debian.tar.xz' node-safe-buffer_5.2.1+~cs2.1.2-1.debian.tar.xz 3612 SHA256:21c3946ed91767a11c8f4e19accb477a4c832b0b916bd1c104ec03ee25a1111d
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-safe-buffer/5.2.1+~cs2.1.2-1/ (for browsing the source)
- https://sources.debian.net/src/node-safe-buffer/5.2.1+~cs2.1.2-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-safe-buffer/5.2.1+~cs2.1.2-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-semver=7.3.4-1`

Binary Packages:

- `node-semver=7.3.4-1`

Licenses: (parsed from: `/usr/share/doc/node-semver/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-semver=7.3.4-1
'http://deb.debian.org/debian/pool/main/n/node-semver/node-semver_7.3.4-1.dsc' node-semver_7.3.4-1.dsc 2384 SHA256:81341a43d8f1fae1ac49454fae4a22dc641e9bd65f2fda92c32009621fbd62e5
'http://deb.debian.org/debian/pool/main/n/node-semver/node-semver_7.3.4.orig-types-semver.tar.gz' node-semver_7.3.4.orig-types-semver.tar.gz 6432 SHA256:9fb235e7fbb96e418cfd81d22a6e1eb71d3794f72d35a5448543950f93dca880
'http://deb.debian.org/debian/pool/main/n/node-semver/node-semver_7.3.4.orig.tar.gz' node-semver_7.3.4.orig.tar.gz 117338 SHA256:c66f420af84d9bcca7c1634e7691525a94d7d16551f67724d727ecb088549a05
'http://deb.debian.org/debian/pool/main/n/node-semver/node-semver_7.3.4-1.debian.tar.xz' node-semver_7.3.4-1.debian.tar.xz 4512 SHA256:d693d06d3612f0004c1ac95aaa10718916e4abd942f0ce41084a92986e39086e
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-semver/7.3.4-1/ (for browsing the source)
- https://sources.debian.net/src/node-semver/7.3.4-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-semver/7.3.4-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-set-blocking=2.0.0-1.1`

Binary Packages:

- `node-set-blocking=2.0.0-1.1`

Licenses: (parsed from: `/usr/share/doc/node-set-blocking/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-set-blocking=2.0.0-1.1
'http://deb.debian.org/debian/pool/main/n/node-set-blocking/node-set-blocking_2.0.0-1.1.dsc' node-set-blocking_2.0.0-1.1.dsc 2137 SHA256:518d408cbd2617eaf5fa39927b9e959a241abf99db96e3139de8fa89a16946e9
'http://deb.debian.org/debian/pool/main/n/node-set-blocking/node-set-blocking_2.0.0.orig.tar.gz' node-set-blocking_2.0.0.orig.tar.gz 2994 SHA256:ba6f4968bf76843c1db8637aec34b80d619ea7a851353d92ca65b75f59384190
'http://deb.debian.org/debian/pool/main/n/node-set-blocking/node-set-blocking_2.0.0-1.1.debian.tar.xz' node-set-blocking_2.0.0-1.1.debian.tar.xz 2176 SHA256:c242dfb177bfe64ae6f9360c17fbf563e2d41377cc5d54d508c464eb032ef666
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-set-blocking/2.0.0-1.1/ (for browsing the source)
- https://sources.debian.net/src/node-set-blocking/2.0.0-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-set-blocking/2.0.0-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-signal-exit=3.0.3-1`

Binary Packages:

- `node-signal-exit=3.0.3-1`

Licenses: (parsed from: `/usr/share/doc/node-signal-exit/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-signal-exit=3.0.3-1
'http://deb.debian.org/debian/pool/main/n/node-signal-exit/node-signal-exit_3.0.3-1.dsc' node-signal-exit_3.0.3-1.dsc 2066 SHA256:fa94e1def32d92692147ba4cd22e1e853baafd6d586c31e7111e19001335d2a1
'http://deb.debian.org/debian/pool/main/n/node-signal-exit/node-signal-exit_3.0.3.orig.tar.gz' node-signal-exit_3.0.3.orig.tar.gz 73482 SHA256:26595fc094be851cf2040d768230266bdbfe63c8e54cf27001407f9eddc650fd
'http://deb.debian.org/debian/pool/main/n/node-signal-exit/node-signal-exit_3.0.3-1.debian.tar.xz' node-signal-exit_3.0.3-1.debian.tar.xz 2276 SHA256:cbc3d30f26454cd802141a31d7af41c6e5d3eac0b1b5dff03e3d7d049ced33f5
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-signal-exit/3.0.3-1/ (for browsing the source)
- https://sources.debian.net/src/node-signal-exit/3.0.3-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-signal-exit/3.0.3-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-slash=3.0.0-1`

Binary Packages:

- `node-slash=3.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-slash/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-slash=3.0.0-1
'http://deb.debian.org/debian/pool/main/n/node-slash/node-slash_3.0.0-1.dsc' node-slash_3.0.0-1.dsc 2021 SHA256:bf61bc5e4be5f06a8125afe6f4d26b654e8ebf313c78fa3e67610c7b08906b95
'http://deb.debian.org/debian/pool/main/n/node-slash/node-slash_3.0.0.orig.tar.gz' node-slash_3.0.0.orig.tar.gz 2529 SHA256:162ae4434c40358597d62bdc553d15d9c0bc9e731120990f6290c2d68792f174
'http://deb.debian.org/debian/pool/main/n/node-slash/node-slash_3.0.0-1.debian.tar.xz' node-slash_3.0.0-1.debian.tar.xz 2760 SHA256:bb652f6690e286deabf79907edc6a03461bf505adaefa971ad4ea03bf5141aa4
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-slash/3.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-slash/3.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-slash/3.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-spdx-correct=3.1.1-1`

Binary Packages:

- `node-spdx-correct=3.1.1-1`

Licenses: (parsed from: `/usr/share/doc/node-spdx-correct/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris node-spdx-correct=3.1.1-1
'http://deb.debian.org/debian/pool/main/n/node-spdx-correct/node-spdx-correct_3.1.1-1.dsc' node-spdx-correct_3.1.1-1.dsc 2200 SHA256:9c32fba5b24acd961586001fe174f9bf2a132012edaec9374be53a17c010d406
'http://deb.debian.org/debian/pool/main/n/node-spdx-correct/node-spdx-correct_3.1.1.orig.tar.gz' node-spdx-correct_3.1.1.orig.tar.gz 9724 SHA256:4a41c0ea4b2eb6d044f669c13b3f9cadca14336ad15556b1f24db92b1e1d1612
'http://deb.debian.org/debian/pool/main/n/node-spdx-correct/node-spdx-correct_3.1.1-1.debian.tar.xz' node-spdx-correct_3.1.1-1.debian.tar.xz 2228 SHA256:eb1bebac79db8ee1421a3ea723230c177944a087932b91e81e0dc558fd8dfe1e
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-spdx-correct/3.1.1-1/ (for browsing the source)
- https://sources.debian.net/src/node-spdx-correct/3.1.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-spdx-correct/3.1.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-spdx-exceptions=2.3.0-1`

Binary Packages:

- `node-spdx-exceptions=2.3.0-1`

Licenses: (parsed from: `/usr/share/doc/node-spdx-exceptions/copyright`)

- `CC-BY-3.0`

Source:

```console
$ apt-get source -qq --print-uris node-spdx-exceptions=2.3.0-1
'http://deb.debian.org/debian/pool/main/n/node-spdx-exceptions/node-spdx-exceptions_2.3.0-1.dsc' node-spdx-exceptions_2.3.0-1.dsc 2122 SHA256:a68ba8cca0a1a244ce89f93dbe6ccd8b8117ed35be2e116b725d0f4ad0062611
'http://deb.debian.org/debian/pool/main/n/node-spdx-exceptions/node-spdx-exceptions_2.3.0.orig.tar.gz' node-spdx-exceptions_2.3.0.orig.tar.gz 1930 SHA256:74e502d0ff866bbba7c05d2a82cb27e0b0da6b70d67f20d012a20f16e33ba1be
'http://deb.debian.org/debian/pool/main/n/node-spdx-exceptions/node-spdx-exceptions_2.3.0-1.debian.tar.xz' node-spdx-exceptions_2.3.0-1.debian.tar.xz 2304 SHA256:4b454ece29e1f0be14c055990d09250097a0b669154d1cc109ce905e2cddbbbe
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-spdx-exceptions/2.3.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-spdx-exceptions/2.3.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-spdx-exceptions/2.3.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-spdx-expression-parse=3.0.1-1`

Binary Packages:

- `node-spdx-expression-parse=3.0.1-1`

Licenses: (parsed from: `/usr/share/doc/node-spdx-expression-parse/copyright`)

- `CC-BY-3.0`
- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-spdx-expression-parse=3.0.1-1
'http://deb.debian.org/debian/pool/main/n/node-spdx-expression-parse/node-spdx-expression-parse_3.0.1-1.dsc' node-spdx-expression-parse_3.0.1-1.dsc 2298 SHA256:afb8f72bc11a68fa506420839e99bf55d5d2dd2d5aec17ebaca2a160076d1a94
'http://deb.debian.org/debian/pool/main/n/node-spdx-expression-parse/node-spdx-expression-parse_3.0.1.orig.tar.gz' node-spdx-expression-parse_3.0.1.orig.tar.gz 5510 SHA256:b4b74af731522cc02335bcf178cc8ab47471ee1927795649ff5c98da7b2b2b5c
'http://deb.debian.org/debian/pool/main/n/node-spdx-expression-parse/node-spdx-expression-parse_3.0.1-1.debian.tar.xz' node-spdx-expression-parse_3.0.1-1.debian.tar.xz 3712 SHA256:d79a0ad971ffe13f166a0504672051adb25841d9c104cbddff2a1b93102cbf01
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-spdx-expression-parse/3.0.1-1/ (for browsing the source)
- https://sources.debian.net/src/node-spdx-expression-parse/3.0.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-spdx-expression-parse/3.0.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-spdx-license-ids=3.0.7-1`

Binary Packages:

- `node-spdx-license-ids=3.0.7-1`

Licenses: (parsed from: `/usr/share/doc/node-spdx-license-ids/copyright`)

- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris node-spdx-license-ids=3.0.7-1
'http://deb.debian.org/debian/pool/main/n/node-spdx-license-ids/node-spdx-license-ids_3.0.7-1.dsc' node-spdx-license-ids_3.0.7-1.dsc 2485 SHA256:309e25bf03a1bb752cb6a741d8524010c91cee385123cc29d90483752c39638b
'http://deb.debian.org/debian/pool/main/n/node-spdx-license-ids/node-spdx-license-ids_3.0.7.orig-get-spdx-license-ids.tar.gz' node-spdx-license-ids_3.0.7.orig-get-spdx-license-ids.tar.gz 21186 SHA256:0656a34e769fa5d09bdbe6b67ba37494a7fface6831f16196ab251dfd3a0334d
'http://deb.debian.org/debian/pool/main/n/node-spdx-license-ids/node-spdx-license-ids_3.0.7.orig.tar.gz' node-spdx-license-ids_3.0.7.orig.tar.gz 21529 SHA256:75db7d3e1da9cf2cfa931e29adf97f24f86492a52b87619905cdc9ebd28db34d
'http://deb.debian.org/debian/pool/main/n/node-spdx-license-ids/node-spdx-license-ids_3.0.7-1.debian.tar.xz' node-spdx-license-ids_3.0.7-1.debian.tar.xz 3100 SHA256:2b14463c83e6f49131296bd8039663f0c59c633e37630c09ce0e8ef84aec9b86
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-spdx-license-ids/3.0.7-1/ (for browsing the source)
- https://sources.debian.net/src/node-spdx-license-ids/3.0.7-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-spdx-license-ids/3.0.7-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-sshpk=1.16.1+dfsg-2`

Binary Packages:

- `node-sshpk=1.16.1+dfsg-2`

Licenses: (parsed from: `/usr/share/doc/node-sshpk/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-sshpk=1.16.1+dfsg-2
'http://deb.debian.org/debian/pool/main/n/node-sshpk/node-sshpk_1.16.1%2bdfsg-2.dsc' node-sshpk_1.16.1+dfsg-2.dsc 2678 SHA256:7e2145f95dcc8dd61b8a32afea4fd38edc6acdd24e7ab2fa00b8d99c7a3de6d3
'http://deb.debian.org/debian/pool/main/n/node-sshpk/node-sshpk_1.16.1%2bdfsg.orig-safer-buffer.tar.xz' node-sshpk_1.16.1+dfsg.orig-safer-buffer.tar.xz 11684 SHA256:581394f0cedd897d072566a121d37e4fca5c0c43582b19f69d830b56b4779cc2
'http://deb.debian.org/debian/pool/main/n/node-sshpk/node-sshpk_1.16.1%2bdfsg.orig.tar.xz' node-sshpk_1.16.1+dfsg.orig.tar.xz 104048 SHA256:5bfc8abb17699900379f1cffe7cbe30c58e92e14754711f40268f6f02ecad00f
'http://deb.debian.org/debian/pool/main/n/node-sshpk/node-sshpk_1.16.1%2bdfsg-2.debian.tar.xz' node-sshpk_1.16.1+dfsg-2.debian.tar.xz 4156 SHA256:d21bdea8ae5d30520a6af46dea8f34cbfbddca923fe1fdf7eb1f190949f0d9fc
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-sshpk/1.16.1+dfsg-2/ (for browsing the source)
- https://sources.debian.net/src/node-sshpk/1.16.1+dfsg-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-sshpk/1.16.1+dfsg-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-ssri=8.0.1-2`

Binary Packages:

- `node-ssri=8.0.1-2`

Licenses: (parsed from: `/usr/share/doc/node-ssri/copyright`)

- `CC0-1.0`
- `ISC`
- `ISC `

Source:

```console
$ apt-get source -qq --print-uris node-ssri=8.0.1-2
'http://deb.debian.org/debian/pool/main/n/node-ssri/node-ssri_8.0.1-2.dsc' node-ssri_8.0.1-2.dsc 2654 SHA256:38af038c5cd7fb411b56ad939456bc2b552ce50555b791ad8c5c37cc0690ca8e
'http://deb.debian.org/debian/pool/main/n/node-ssri/node-ssri_8.0.1.orig-figgy-pudding.tar.gz' node-ssri_8.0.1.orig-figgy-pudding.tar.gz 52503 SHA256:6c7fd98f49444c2d20c4cd377c9e26d9a8cdd194d016f86e23763b969ece0ad4
'http://deb.debian.org/debian/pool/main/n/node-ssri/node-ssri_8.0.1.orig-minipass.tar.gz' node-ssri_8.0.1.orig-minipass.tar.gz 50240 SHA256:496598d78b824ddb3116c4a4fe0123516b318eab820d0ee80cb892ef3ba0c4c9
'http://deb.debian.org/debian/pool/main/n/node-ssri/node-ssri_8.0.1.orig.tar.gz' node-ssri_8.0.1.orig.tar.gz 162365 SHA256:b9eacfc8c94378ae0bd4602590e50da8dffaa6e3b09e56632d168c3df816c2e7
'http://deb.debian.org/debian/pool/main/n/node-ssri/node-ssri_8.0.1-2.debian.tar.xz' node-ssri_8.0.1-2.debian.tar.xz 3536 SHA256:8945faa5945f7836a3992573ccb6213876288f89a94a6d6b7a6adf7b622c906c
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-ssri/8.0.1-2/ (for browsing the source)
- https://sources.debian.net/src/node-ssri/8.0.1-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-ssri/8.0.1-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-string-decoder=1.3.0-2`

Binary Packages:

- `node-string-decoder=1.3.0-2`

Licenses: (parsed from: `/usr/share/doc/node-string-decoder/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-string-decoder=1.3.0-2
'http://deb.debian.org/debian/pool/main/n/node-string-decoder/node-string-decoder_1.3.0-2.dsc' node-string-decoder_1.3.0-2.dsc 2312 SHA256:c528b2f12397290b02ed252160b305cf1a80c80c1138d061e4f47aa9b28ab4c5
'http://deb.debian.org/debian/pool/main/n/node-string-decoder/node-string-decoder_1.3.0.orig.tar.gz' node-string-decoder_1.3.0.orig.tar.gz 35409 SHA256:05f9c09bf0cf5d107d84dbc6eab0b3f4fdb00fbb97ec6ea6c1239900ad5eab70
'http://deb.debian.org/debian/pool/main/n/node-string-decoder/node-string-decoder_1.3.0-2.debian.tar.xz' node-string-decoder_1.3.0-2.debian.tar.xz 4964 SHA256:c1fecfb3c5a83887853542f85c3b24a474894a4c42db5f83097390a6525e1c70
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-string-decoder/1.3.0-2/ (for browsing the source)
- https://sources.debian.net/src/node-string-decoder/1.3.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-string-decoder/1.3.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-string-width=4.2.0-1`

Binary Packages:

- `node-string-width=4.2.0-1`

Licenses: (parsed from: `/usr/share/doc/node-string-width/copyright`)

- `Expat`
- `GPL-3`
- `GPL-3.0+`

Source:

```console
$ apt-get source -qq --print-uris node-string-width=4.2.0-1
'http://deb.debian.org/debian/pool/main/n/node-string-width/node-string-width_4.2.0-1.dsc' node-string-width_4.2.0-1.dsc 2812 SHA256:b86ab49724a70178fdb920eac129681383feb4148504ee0c6d3de09e227ecef5
'http://deb.debian.org/debian/pool/main/n/node-string-width/node-string-width_4.2.0.orig-emoji-regex.tar.gz' node-string-width_4.2.0.orig-emoji-regex.tar.gz 9289 SHA256:bac047401232f56674a892e6d17fe8f7ac6166851b0a7d9f3abc319ddf9e9ce8
'http://deb.debian.org/debian/pool/main/n/node-string-width/node-string-width_4.2.0.orig-is-fullwidth-code-point.tar.gz' node-string-width_4.2.0.orig-is-fullwidth-code-point.tar.gz 2765 SHA256:842102324bd1da62c1659c421fe5e14739a5c6d7aa1d09c371017331bacbefc2
'http://deb.debian.org/debian/pool/main/n/node-string-width/node-string-width_4.2.0.orig.tar.gz' node-string-width_4.2.0.orig.tar.gz 3685 SHA256:ed442beb06ff8beb24235a38af520b971befdfb68fba6ae7130cf7f402efc6d8
'http://deb.debian.org/debian/pool/main/n/node-string-width/node-string-width_4.2.0-1.debian.tar.xz' node-string-width_4.2.0-1.debian.tar.xz 3872 SHA256:07fd1a9aacc64ac409f3dba5131c7d188bee074ef7fa657f9bbfa0578e71b058
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-string-width/4.2.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-string-width/4.2.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-string-width/4.2.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-strip-ansi=6.0.0-2`

Binary Packages:

- `node-strip-ansi=6.0.0-2`

Licenses: (parsed from: `/usr/share/doc/node-strip-ansi/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-strip-ansi=6.0.0-2
'http://deb.debian.org/debian/pool/main/n/node-strip-ansi/node-strip-ansi_6.0.0-2.dsc' node-strip-ansi_6.0.0-2.dsc 2130 SHA256:ea9a1050162bb5a96012e49bdbf36c6f28bf36dfe5aff0eeafe22bbde7d89bb2
'http://deb.debian.org/debian/pool/main/n/node-strip-ansi/node-strip-ansi_6.0.0.orig.tar.gz' node-strip-ansi_6.0.0.orig.tar.gz 3027 SHA256:4ec0debe7b2d9935a0a6933ae6db8d3d9efc51e576abdd8b23857aa616e9ebeb
'http://deb.debian.org/debian/pool/main/n/node-strip-ansi/node-strip-ansi_6.0.0-2.debian.tar.xz' node-strip-ansi_6.0.0-2.debian.tar.xz 3000 SHA256:557bd52bd764928c8c609a4ce79f4867667797801c7b144fd294cd774fbe2fc2
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-strip-ansi/6.0.0-2/ (for browsing the source)
- https://sources.debian.net/src/node-strip-ansi/6.0.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-strip-ansi/6.0.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-supports-color=8.1.0+~7.2.0-1`

Binary Packages:

- `node-supports-color=8.1.0+~7.2.0-1`

Licenses: (parsed from: `/usr/share/doc/node-supports-color/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-supports-color=8.1.0+~7.2.0-1
'http://deb.debian.org/debian/pool/main/n/node-supports-color/node-supports-color_8.1.0%2b%7e7.2.0-1.dsc' node-supports-color_8.1.0+~7.2.0-1.dsc 2571 SHA256:5a0ca204f6db106230059d54a57db4a304e62a357ed363d4ea1df3bd1290cda2
'http://deb.debian.org/debian/pool/main/n/node-supports-color/node-supports-color_8.1.0%2b%7e7.2.0.orig-types-supports-color.tar.gz' node-supports-color_8.1.0+~7.2.0.orig-types-supports-color.tar.gz 1681 SHA256:d3bd83e7408cc3fc042700eca1f3b8eca0a3c0ee8fbfbadeaa33800b9136d916
'http://deb.debian.org/debian/pool/main/n/node-supports-color/node-supports-color_8.1.0%2b%7e7.2.0.orig.tar.gz' node-supports-color_8.1.0+~7.2.0.orig.tar.gz 6004 SHA256:af2facc869a27ba93e6dc504962c8b8e9e7b17f322df526c81f02891dfd5cfcf
'http://deb.debian.org/debian/pool/main/n/node-supports-color/node-supports-color_8.1.0%2b%7e7.2.0-1.debian.tar.xz' node-supports-color_8.1.0+~7.2.0-1.debian.tar.xz 3216 SHA256:661fdf1e886de22c231406260937ebc3a0ffa566ea3f239bc7943e82a2f21191
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-supports-color/8.1.0+~7.2.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-supports-color/8.1.0+~7.2.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-supports-color/8.1.0+~7.2.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-tar=6.0.5+ds1+~cs11.3.9-1+deb11u2`

Binary Packages:

- `node-tar=6.0.5+ds1+~cs11.3.9-1+deb11u2`

Licenses: (parsed from: `/usr/share/doc/node-tar/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-tar=6.0.5+ds1+~cs11.3.9-1+deb11u2
'http://deb.debian.org/debian/pool/main/n/node-tar/node-tar_6.0.5%2bds1%2b%7ecs11.3.9-1%2bdeb11u2.dsc' node-tar_6.0.5+ds1+~cs11.3.9-1+deb11u2.dsc 3602 SHA256:13a20e64cdabf864fba437341d13d05ffb51358c1a345a0053c34a7e6543634e
'http://deb.debian.org/debian/pool/main/n/node-tar/node-tar_6.0.5%2bds1%2b%7ecs11.3.9.orig-fs-minipass.tar.gz' node-tar_6.0.5+ds1+~cs11.3.9.orig-fs-minipass.tar.gz 35270 SHA256:83cf7dc113dacdbe3a2d05753edde01c37256cc97167ea5a8086ab85a78f2efd
'http://deb.debian.org/debian/pool/main/n/node-tar/node-tar_6.0.5%2bds1%2b%7ecs11.3.9.orig-minipass.tar.gz' node-tar_6.0.5+ds1+~cs11.3.9.orig-minipass.tar.gz 50240 SHA256:496598d78b824ddb3116c4a4fe0123516b318eab820d0ee80cb892ef3ba0c4c9
'http://deb.debian.org/debian/pool/main/n/node-tar/node-tar_6.0.5%2bds1%2b%7ecs11.3.9.orig-minizlib.tar.gz' node-tar_6.0.5+ds1+~cs11.3.9.orig-minizlib.tar.gz 186712 SHA256:296f5e559312e7a4dd871e1cdad27d50d9d0518a548ae870dffb678ff2ecae7e
'http://deb.debian.org/debian/pool/main/n/node-tar/node-tar_6.0.5%2bds1%2b%7ecs11.3.9.orig-types-tar.tar.gz' node-tar_6.0.5+ds1+~cs11.3.9.orig-types-tar.tar.gz 6436 SHA256:e59a412960136fd1b0a303a7284d849eec4de7658627083058c9caf1ebb28d03
'http://deb.debian.org/debian/pool/main/n/node-tar/node-tar_6.0.5%2bds1%2b%7ecs11.3.9.orig.tar.gz' node-tar_6.0.5+ds1+~cs11.3.9.orig.tar.gz 190376 SHA256:042ca18da6d5dfc2c41aa0169abac8ae70497fb5b340c8fe5b71aa47705606d9
'http://deb.debian.org/debian/pool/main/n/node-tar/node-tar_6.0.5%2bds1%2b%7ecs11.3.9-1%2bdeb11u2.debian.tar.xz' node-tar_6.0.5+ds1+~cs11.3.9-1+deb11u2.debian.tar.xz 16412 SHA256:9c7f680ad11f0162426f28fd194d099da73afda2b5925aa8ca8fc37326811113
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-tar/6.0.5+ds1+~cs11.3.9-1+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/node-tar/6.0.5+ds1+~cs11.3.9-1+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-tar/6.0.5+ds1+~cs11.3.9-1+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-text-table=0.2.0-2`

Binary Packages:

- `node-text-table=0.2.0-2`

Licenses: (parsed from: `/usr/share/doc/node-text-table/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-text-table=0.2.0-2
'http://deb.debian.org/debian/pool/main/n/node-text-table/node-text-table_0.2.0-2.dsc' node-text-table_0.2.0-2.dsc 2057 SHA256:bdc6568013d5a404b0383b601532c0433c90883d510261a5e90bd4512ef81983
'http://deb.debian.org/debian/pool/main/n/node-text-table/node-text-table_0.2.0.orig.tar.gz' node-text-table_0.2.0.orig.tar.gz 3937 SHA256:fb2a941d6e8a2be8098253c5599af57e49007e83c273c7e327701164cdaeed64
'http://deb.debian.org/debian/pool/main/n/node-text-table/node-text-table_0.2.0-2.debian.tar.xz' node-text-table_0.2.0-2.debian.tar.xz 2072 SHA256:b0e9a7acffbeb966079aa07f407ae0634e27f22d0b1e9aface43cdf9739c42cf
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-text-table/0.2.0-2/ (for browsing the source)
- https://sources.debian.net/src/node-text-table/0.2.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-text-table/0.2.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-through=2.3.8+~cs0.0.30-1`

Binary Packages:

- `node-through=2.3.8+~cs0.0.30-1`

Licenses: (parsed from: `/usr/share/doc/node-through/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-through=2.3.8+~cs0.0.30-1
'http://deb.debian.org/debian/pool/main/n/node-through/node-through_2.3.8%2b%7ecs0.0.30-1.dsc' node-through_2.3.8+~cs0.0.30-1.dsc 2432 SHA256:a71de359573f8b7c6291719530565ecf2bca0ce2645ec6c60efc0775ff65853b
'http://deb.debian.org/debian/pool/main/n/node-through/node-through_2.3.8%2b%7ecs0.0.30.orig-types-through.tar.gz' node-through_2.3.8+~cs0.0.30.orig-types-through.tar.gz 1689 SHA256:6843b56aa1424faacb8b763d5e07474250b2ec7851111fb3afc34ca73fd3da58
'http://deb.debian.org/debian/pool/main/n/node-through/node-through_2.3.8%2b%7ecs0.0.30.orig.tar.gz' node-through_2.3.8+~cs0.0.30.orig.tar.gz 4468 SHA256:16b27a8c0fb13e5727356b328d72dbbc5f20bd909252f14d19da344e9354573e
'http://deb.debian.org/debian/pool/main/n/node-through/node-through_2.3.8%2b%7ecs0.0.30-1.debian.tar.xz' node-through_2.3.8+~cs0.0.30-1.debian.tar.xz 7988 SHA256:1782e12e3b1ab25b84730334c33e1a9129c0e2ade2db3664dc5d47f3afefaf03
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-through/2.3.8+~cs0.0.30-1/ (for browsing the source)
- https://sources.debian.net/src/node-through/2.3.8+~cs0.0.30-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-through/2.3.8+~cs0.0.30-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-tslib=2.1.0-2`

Binary Packages:

- `node-tslib=2.1.0-2`

Licenses: (parsed from: `/usr/share/doc/node-tslib/copyright`)

- `Apache-2.0`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-tslib=2.1.0-2
'http://deb.debian.org/debian/pool/main/n/node-tslib/node-tslib_2.1.0-2.dsc' node-tslib_2.1.0-2.dsc 2026 SHA256:7597183a2d47fb505ba7bec3031618a80c5cf2c271017156b75fbfd0d9bb2a52
'http://deb.debian.org/debian/pool/main/n/node-tslib/node-tslib_2.1.0.orig.tar.gz' node-tslib_2.1.0.orig.tar.gz 16515 SHA256:973e83c9ac9cf1e50fee2f73a80b59fefe12e2c0506638b0829917044d83d30f
'http://deb.debian.org/debian/pool/main/n/node-tslib/node-tslib_2.1.0-2.debian.tar.xz' node-tslib_2.1.0-2.debian.tar.xz 2896 SHA256:b2defffeb017371a8f3f8e0c0dfc1f20ddc4a7e0f5abf77f4a6bb10b5da6ecbd
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-tslib/2.1.0-2/ (for browsing the source)
- https://sources.debian.net/src/node-tslib/2.1.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-tslib/2.1.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-tunnel-agent=0.6.1-2`

Binary Packages:

- `node-tunnel-agent=0.6.1-2`

Licenses: (parsed from: `/usr/share/doc/node-tunnel-agent/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris node-tunnel-agent=0.6.1-2
'http://deb.debian.org/debian/pool/main/n/node-tunnel-agent/node-tunnel-agent_0.6.1-2.dsc' node-tunnel-agent_0.6.1-2.dsc 2092 SHA256:b2a95af60b53a16c3305fa560bcd9c643da6fae664ebd3e9db6d3cc401760a34
'http://deb.debian.org/debian/pool/main/n/node-tunnel-agent/node-tunnel-agent_0.6.1.orig.tar.gz' node-tunnel-agent_0.6.1.orig.tar.gz 6037 SHA256:a013072a495cab682a5a4105f02bd66acef729d9e282ff23bfa995542649f469
'http://deb.debian.org/debian/pool/main/n/node-tunnel-agent/node-tunnel-agent_0.6.1-2.debian.tar.xz' node-tunnel-agent_0.6.1-2.debian.tar.xz 2252 SHA256:10a750307956e8b5c96f6307dd41b2f12d179e1205c0025f40ce01c92876416d
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-tunnel-agent/0.6.1-2/ (for browsing the source)
- https://sources.debian.net/src/node-tunnel-agent/0.6.1-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-tunnel-agent/0.6.1-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-tweetnacl=1.0.3+dfsg-1`

Binary Packages:

- `node-tweetnacl=1.0.3+dfsg-1`

Licenses: (parsed from: `/usr/share/doc/node-tweetnacl/copyright`)

- `public-domain`
- `public-domain `

Source:

```console
$ apt-get source -qq --print-uris node-tweetnacl=1.0.3+dfsg-1
'http://deb.debian.org/debian/pool/main/n/node-tweetnacl/node-tweetnacl_1.0.3%2bdfsg-1.dsc' node-tweetnacl_1.0.3+dfsg-1.dsc 2137 SHA256:343f792aff84c98a949ab0cb676dfc33a4ab2ae4777514e2502f98cba394ff01
'http://deb.debian.org/debian/pool/main/n/node-tweetnacl/node-tweetnacl_1.0.3%2bdfsg.orig.tar.xz' node-tweetnacl_1.0.3+dfsg.orig.tar.xz 2223148 SHA256:51afb89b86674d13d6f6460d760553ebb00f98025ad90974c6b0d6579b8fbc68
'http://deb.debian.org/debian/pool/main/n/node-tweetnacl/node-tweetnacl_1.0.3%2bdfsg-1.debian.tar.xz' node-tweetnacl_1.0.3+dfsg-1.debian.tar.xz 5064 SHA256:ccf918950e7fe1343d827ca80b41e67abc87b1053b3d146c02a5d5e6898e5338
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-tweetnacl/1.0.3+dfsg-1/ (for browsing the source)
- https://sources.debian.net/src/node-tweetnacl/1.0.3+dfsg-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-tweetnacl/1.0.3+dfsg-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-typedarray-to-buffer=4.0.0-1`

Binary Packages:

- `libjs-typedarray-to-buffer=4.0.0-1`
- `node-typedarray-to-buffer=4.0.0-1`

Licenses: (parsed from: `/usr/share/doc/libjs-typedarray-to-buffer/copyright`, `/usr/share/doc/node-typedarray-to-buffer/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-typedarray-to-buffer=4.0.0-1
'http://deb.debian.org/debian/pool/main/n/node-typedarray-to-buffer/node-typedarray-to-buffer_4.0.0-1.dsc' node-typedarray-to-buffer_4.0.0-1.dsc 2294 SHA256:20d5af1b9d6e2568a7c207c8d18871be4c8b5d2cbd14636af6259fcc3d40f74b
'http://deb.debian.org/debian/pool/main/n/node-typedarray-to-buffer/node-typedarray-to-buffer_4.0.0.orig.tar.gz' node-typedarray-to-buffer_4.0.0.orig.tar.gz 3817 SHA256:f799da7a4da102df57d147fb36ff8312cbb63451aa0958501017dc516d8a6280
'http://deb.debian.org/debian/pool/main/n/node-typedarray-to-buffer/node-typedarray-to-buffer_4.0.0-1.debian.tar.xz' node-typedarray-to-buffer_4.0.0-1.debian.tar.xz 3176 SHA256:d78766784dc630f0f9b516bd3cd08bb6a0c493a50f4d0b2815c5dae300c70658
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-typedarray-to-buffer/4.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-typedarray-to-buffer/4.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-typedarray-to-buffer/4.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-unique-filename=1.1.1+ds-1`

Binary Packages:

- `node-unique-filename=1.1.1+ds-1`

Licenses: (parsed from: `/usr/share/doc/node-unique-filename/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-unique-filename=1.1.1+ds-1
'http://deb.debian.org/debian/pool/main/n/node-unique-filename/node-unique-filename_1.1.1%2bds-1.dsc' node-unique-filename_1.1.1+ds-1.dsc 2500 SHA256:f60330ad177eb8c70bd095268bfa5eab1aa4cc256d455082558be2f4841672ab
'http://deb.debian.org/debian/pool/main/n/node-unique-filename/node-unique-filename_1.1.1%2bds.orig-unique-slug.tar.xz' node-unique-filename_1.1.1+ds.orig-unique-slug.tar.xz 30716 SHA256:85b3187e5dc6a2a30c13ac1b3c7a9be7eb76155b34c36ef635feb6b862d7a9d0
'http://deb.debian.org/debian/pool/main/n/node-unique-filename/node-unique-filename_1.1.1%2bds.orig.tar.xz' node-unique-filename_1.1.1+ds.orig.tar.xz 2116 SHA256:2f7dcae5c652e6f1dd98e7c13dc4b7353227b43fcf85663ae3606112e9a1210f
'http://deb.debian.org/debian/pool/main/n/node-unique-filename/node-unique-filename_1.1.1%2bds-1.debian.tar.xz' node-unique-filename_1.1.1+ds-1.debian.tar.xz 2428 SHA256:c467adbdf7dea6b8214514cbd251c05a20b5b0befcf162719ed5bbc1a19beba0
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-unique-filename/1.1.1+ds-1/ (for browsing the source)
- https://sources.debian.net/src/node-unique-filename/1.1.1+ds-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-unique-filename/1.1.1+ds-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-uri-js=4.4.0+dfsg-5`

Binary Packages:

- `node-uri-js=4.4.0+dfsg-5`

Licenses: (parsed from: `/usr/share/doc/node-uri-js/copyright`)

- `BSD-2-clause`
- `Expat`
- `GPL`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris node-uri-js=4.4.0+dfsg-5
'http://deb.debian.org/debian/pool/main/n/node-uri-js/node-uri-js_4.4.0%2bdfsg-5.dsc' node-uri-js_4.4.0+dfsg-5.dsc 2300 SHA256:9c868c1f309f0f998be8673f1cfbfde79678f029ea16305634c2445cb1caa3ec
'http://deb.debian.org/debian/pool/main/n/node-uri-js/node-uri-js_4.4.0%2bdfsg.orig.tar.xz' node-uri-js_4.4.0+dfsg.orig.tar.xz 42176 SHA256:21d427ab6507f6d0fc261d9958c9fab30f48b40ef3d8eab0cb52644fc6acf92a
'http://deb.debian.org/debian/pool/main/n/node-uri-js/node-uri-js_4.4.0%2bdfsg-5.debian.tar.xz' node-uri-js_4.4.0+dfsg-5.debian.tar.xz 24268 SHA256:05f28ff9047d608d24412ffed697244ded468d951a249eba14c40374af19008f
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-uri-js/4.4.0+dfsg-5/ (for browsing the source)
- https://sources.debian.net/src/node-uri-js/4.4.0+dfsg-5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-uri-js/4.4.0+dfsg-5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-util-deprecate=1.0.2-1`

Binary Packages:

- `node-util-deprecate=1.0.2-1`

Licenses: (parsed from: `/usr/share/doc/node-util-deprecate/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-util-deprecate=1.0.2-1
'http://deb.debian.org/debian/pool/main/n/node-util-deprecate/node-util-deprecate_1.0.2-1.dsc' node-util-deprecate_1.0.2-1.dsc 2084 SHA256:332ca4f2d14e577aeaf8869ef49e8f40a92c78331f7d7ba149733db4f0d1f6c6
'http://deb.debian.org/debian/pool/main/n/node-util-deprecate/node-util-deprecate_1.0.2.orig.tar.gz' node-util-deprecate_1.0.2.orig.tar.gz 2391 SHA256:780cc3dbb8839acba26ab757162b45f5a10249dd7c905dd5060ab2a0483e1a0e
'http://deb.debian.org/debian/pool/main/n/node-util-deprecate/node-util-deprecate_1.0.2-1.debian.tar.xz' node-util-deprecate_1.0.2-1.debian.tar.xz 2460 SHA256:fcdda18ad681221d4e205f93c5111cee9fb37ed76196457d9514ddbfb8beb904
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-util-deprecate/1.0.2-1/ (for browsing the source)
- https://sources.debian.net/src/node-util-deprecate/1.0.2-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-util-deprecate/1.0.2-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-uuid=8.3.2+~8.3.0-4`

Binary Packages:

- `node-uuid=8.3.2+~8.3.0-4`

Licenses: (parsed from: `/usr/share/doc/node-uuid/copyright`)

- `Expat`
- `GPL-3`
- `GPL-3+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris node-uuid=8.3.2+~8.3.0-4
'http://deb.debian.org/debian/pool/main/n/node-uuid/node-uuid_8.3.2%2b%7e8.3.0-4.dsc' node-uuid_8.3.2+~8.3.0-4.dsc 2538 SHA256:46faf06c5f438e41e4cf87c1a619ada9a9eb38a0940f83451af50619b53206de
'http://deb.debian.org/debian/pool/main/n/node-uuid/node-uuid_8.3.2%2b%7e8.3.0.orig-Xtypes.tar.gz' node-uuid_8.3.2+~8.3.0.orig-Xtypes.tar.gz 2212 SHA256:4160631edd60db0db8c7cbe5ae904a1ffa1b621ba604c28cab00bdf320bc4f01
'http://deb.debian.org/debian/pool/main/n/node-uuid/node-uuid_8.3.2%2b%7e8.3.0.orig.tar.gz' node-uuid_8.3.2+~8.3.0.orig.tar.gz 208965 SHA256:a3f419bfca2f937935ef039cf62b01a28e96d99129038f7a1fa4a5427cdc372d
'http://deb.debian.org/debian/pool/main/n/node-uuid/node-uuid_8.3.2%2b%7e8.3.0-4.debian.tar.xz' node-uuid_8.3.2+~8.3.0-4.debian.tar.xz 14912 SHA256:8ef2b70bd3ca1298a77f4225a77b558d8f7f20d6d44d44b633b71f35150e4148
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-uuid/8.3.2+~8.3.0-4/ (for browsing the source)
- https://sources.debian.net/src/node-uuid/8.3.2+~8.3.0-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-uuid/8.3.2+~8.3.0-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-validate-npm-package-license=3.0.4-1`

Binary Packages:

- `node-validate-npm-package-license=3.0.4-1`

Licenses: (parsed from: `/usr/share/doc/node-validate-npm-package-license/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris node-validate-npm-package-license=3.0.4-1
'http://deb.debian.org/debian/pool/main/n/node-validate-npm-package-license/node-validate-npm-package-license_3.0.4-1.dsc' node-validate-npm-package-license_3.0.4-1.dsc 2344 SHA256:bece4179a72ee7383cf54f24ddb0a57486565d4751459807d01d1dcda6055fc2
'http://deb.debian.org/debian/pool/main/n/node-validate-npm-package-license/node-validate-npm-package-license_3.0.4.orig.tar.gz' node-validate-npm-package-license_3.0.4.orig.tar.gz 7045 SHA256:96c7b266b57b797fa5c44f0a2a666b2e1e56188f3ec56c69b0f6f9c91baf1def
'http://deb.debian.org/debian/pool/main/n/node-validate-npm-package-license/node-validate-npm-package-license_3.0.4-1.debian.tar.xz' node-validate-npm-package-license_3.0.4-1.debian.tar.xz 2284 SHA256:77dfd54a8e827c287c5846e00b47e47ae3bcb16b76cffe78391d9e5ab27e17f8
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-validate-npm-package-license/3.0.4-1/ (for browsing the source)
- https://sources.debian.net/src/node-validate-npm-package-license/3.0.4-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-validate-npm-package-license/3.0.4-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-validate-npm-package-name=3.0.0-1.1`

Binary Packages:

- `node-validate-npm-package-name=3.0.0-1.1`

Licenses: (parsed from: `/usr/share/doc/node-validate-npm-package-name/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-validate-npm-package-name=3.0.0-1.1
'http://deb.debian.org/debian/pool/main/n/node-validate-npm-package-name/node-validate-npm-package-name_3.0.0-1.1.dsc' node-validate-npm-package-name_3.0.0-1.1.dsc 2310 SHA256:a39fa7eb9299110f7da58eaf9b6fea7d8fb3de748a0fee19ed9ccf7b97b8d6f9
'http://deb.debian.org/debian/pool/main/n/node-validate-npm-package-name/node-validate-npm-package-name_3.0.0.orig.tar.gz' node-validate-npm-package-name_3.0.0.orig.tar.gz 3795 SHA256:4d73602412fb7281160fa5d4a6999aaaeb05f8b68884264c88e686b2991ae54d
'http://deb.debian.org/debian/pool/main/n/node-validate-npm-package-name/node-validate-npm-package-name_3.0.0-1.1.debian.tar.xz' node-validate-npm-package-name_3.0.0-1.1.debian.tar.xz 2052 SHA256:e40de8aa7fb436e909fb4df30923111fb4e51ef1d091598d2f50f81c0b54e057
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-validate-npm-package-name/3.0.0-1.1/ (for browsing the source)
- https://sources.debian.net/src/node-validate-npm-package-name/3.0.0-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-validate-npm-package-name/3.0.0-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-verror=1.10.0-1.1`

Binary Packages:

- `node-verror=1.10.0-1.1`

Licenses: (parsed from: `/usr/share/doc/node-verror/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-verror=1.10.0-1.1
'http://deb.debian.org/debian/pool/main/n/node-verror/node-verror_1.10.0-1.1.dsc' node-verror_1.10.0-1.1.dsc 2034 SHA256:fa34d10faef93703e1f986621b449c96cb9baf689195dc4e0594321e80915443
'http://deb.debian.org/debian/pool/main/n/node-verror/node-verror_1.10.0.orig.tar.gz' node-verror_1.10.0.orig.tar.gz 25220 SHA256:71e8759f05e98653b14bb3cd0b128a91a12972a0e96dfef141214b2c9ead8471
'http://deb.debian.org/debian/pool/main/n/node-verror/node-verror_1.10.0-1.1.debian.tar.xz' node-verror_1.10.0-1.1.debian.tar.xz 2428 SHA256:5d8c38654a8bc1f1c808ab1d6cb73e8e66218ab434c732dd85391dadc7195671
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-verror/1.10.0-1.1/ (for browsing the source)
- https://sources.debian.net/src/node-verror/1.10.0-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-verror/1.10.0-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-wcwidth.js=1.0.0-1.1`

Binary Packages:

- `node-wcwidth.js=1.0.0-1.1`

Licenses: (parsed from: `/usr/share/doc/node-wcwidth.js/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris node-wcwidth.js=1.0.0-1.1
'http://deb.debian.org/debian/pool/main/n/node-wcwidth.js/node-wcwidth.js_1.0.0-1.1.dsc' node-wcwidth.js_1.0.0-1.1.dsc 2052 SHA256:54e83466b455edb309cc74e9779ebb5474af9906170f27c5b6a53cb706e5d8fb
'http://deb.debian.org/debian/pool/main/n/node-wcwidth.js/node-wcwidth.js_1.0.0.orig.tar.gz' node-wcwidth.js_1.0.0.orig.tar.gz 7737 SHA256:1cb07e3eed952004782178c73f3bf5334e821d2c0b0fedc8dac12d9e894dcdd2
'http://deb.debian.org/debian/pool/main/n/node-wcwidth.js/node-wcwidth.js_1.0.0-1.1.debian.tar.xz' node-wcwidth.js_1.0.0-1.1.debian.tar.xz 2388 SHA256:db2848d3d103eee6fd2619e964b4f3227ddc9d63ac8e7ccc6d74e16a264114e7
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-wcwidth.js/1.0.0-1.1/ (for browsing the source)
- https://sources.debian.net/src/node-wcwidth.js/1.0.0-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-wcwidth.js/1.0.0-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-which=2.0.2+~cs1.3.2-1`

Binary Packages:

- `node-which=2.0.2+~cs1.3.2-1`

Licenses: (parsed from: `/usr/share/doc/node-which/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-which=2.0.2+~cs1.3.2-1
'http://deb.debian.org/debian/pool/main/n/node-which/node-which_2.0.2%2b%7ecs1.3.2-1.dsc' node-which_2.0.2+~cs1.3.2-1.dsc 2488 SHA256:17533d562eb30829b2a34bafa99365665ec0171ade92c6671fb2f178c7d5dc9f
'http://deb.debian.org/debian/pool/main/n/node-which/node-which_2.0.2%2b%7ecs1.3.2.orig-types-which.tar.gz' node-which_2.0.2+~cs1.3.2.orig-types-which.tar.gz 2099 SHA256:20c508a1956436e4c3564abdff7d62ec3d255c03a096ee589a66722b240ada75
'http://deb.debian.org/debian/pool/main/n/node-which/node-which_2.0.2%2b%7ecs1.3.2.orig.tar.gz' node-which_2.0.2+~cs1.3.2.orig.tar.gz 35404 SHA256:1481ccbca51ce09fa06451fd02986a3a0b028d100ffc48e5cc92201b1018abfe
'http://deb.debian.org/debian/pool/main/n/node-which/node-which_2.0.2%2b%7ecs1.3.2-1.debian.tar.xz' node-which_2.0.2+~cs1.3.2-1.debian.tar.xz 3716 SHA256:6cb058e483aa8e3b5fb25f406e6a510d599fd45e3f4f81f27f6f0f92df989615
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-which/2.0.2+~cs1.3.2-1/ (for browsing the source)
- https://sources.debian.net/src/node-which/2.0.2+~cs1.3.2-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-which/2.0.2+~cs1.3.2-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-wide-align=1.1.3-1`

Binary Packages:

- `node-wide-align=1.1.3-1`

Licenses: (parsed from: `/usr/share/doc/node-wide-align/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-wide-align=1.1.3-1
'http://deb.debian.org/debian/pool/main/n/node-wide-align/node-wide-align_1.1.3-1.dsc' node-wide-align_1.1.3-1.dsc 2119 SHA256:9736ae766caee2ccc8784ef5f04dc9e4f23704d89e1966b74e81dc4826d89286
'http://deb.debian.org/debian/pool/main/n/node-wide-align/node-wide-align_1.1.3.orig.tar.gz' node-wide-align_1.1.3.orig.tar.gz 18294 SHA256:a57cc79298053950730cc7dde7952b7ebba2479985ea2ca984ab41cf4726175b
'http://deb.debian.org/debian/pool/main/n/node-wide-align/node-wide-align_1.1.3-1.debian.tar.xz' node-wide-align_1.1.3-1.debian.tar.xz 2304 SHA256:ba8d40b7a0c970eba8052669eb55f89e5ea5117aea812e082af8230ae40ed28b
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-wide-align/1.1.3-1/ (for browsing the source)
- https://sources.debian.net/src/node-wide-align/1.1.3-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-wide-align/1.1.3-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-wrappy=1.0.2-1.1`

Binary Packages:

- `node-wrappy=1.0.2-1.1`

Licenses: (parsed from: `/usr/share/doc/node-wrappy/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-wrappy=1.0.2-1.1
'http://deb.debian.org/debian/pool/main/n/node-wrappy/node-wrappy_1.0.2-1.1.dsc' node-wrappy_1.0.2-1.1.dsc 2009 SHA256:1d7479502f6c40d5872d1ebc05ce493e93e98f924019a0c618124cb194c9c3ef
'http://deb.debian.org/debian/pool/main/n/node-wrappy/node-wrappy_1.0.2.orig.tar.gz' node-wrappy_1.0.2.orig.tar.gz 2338 SHA256:b81382832bbc862775b0772ab65e1e0932ccbd23016f013b6ff31b626b05cc0c
'http://deb.debian.org/debian/pool/main/n/node-wrappy/node-wrappy_1.0.2-1.1.debian.tar.xz' node-wrappy_1.0.2-1.1.debian.tar.xz 2064 SHA256:3f94ceac0bf117405da5cecaf2e954430f0a0585c10ceabb8650cedcd1d89817
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-wrappy/1.0.2-1.1/ (for browsing the source)
- https://sources.debian.net/src/node-wrappy/1.0.2-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-wrappy/1.0.2-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-write-file-atomic=3.0.3+~3.0.1-1`

Binary Packages:

- `node-write-file-atomic=3.0.3+~3.0.1-1`

Licenses: (parsed from: `/usr/share/doc/node-write-file-atomic/copyright`)

- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-write-file-atomic=3.0.3+~3.0.1-1
'http://deb.debian.org/debian/pool/main/n/node-write-file-atomic/node-write-file-atomic_3.0.3%2b%7e3.0.1-1.dsc' node-write-file-atomic_3.0.3+~3.0.1-1.dsc 2782 SHA256:e9b8ced955544f1c867d4060377f117eaf0b9c9ae262fbd0ba4d46f1842b1dda
'http://deb.debian.org/debian/pool/main/n/node-write-file-atomic/node-write-file-atomic_3.0.3%2b%7e3.0.1.orig-types-write-file-atomic.tar.gz' node-write-file-atomic_3.0.3+~3.0.1.orig-types-write-file-atomic.tar.gz 1854 SHA256:30e01aa472457248b5597eb51d192d5e2d8a5746a7e016c77f71ab686e23da27
'http://deb.debian.org/debian/pool/main/n/node-write-file-atomic/node-write-file-atomic_3.0.3%2b%7e3.0.1.orig.tar.gz' node-write-file-atomic_3.0.3+~3.0.1.orig.tar.gz 50641 SHA256:bc4cccda8dcceb606f32db5789371c2285b36722931c1f49696ad7ef8bd260cb
'http://deb.debian.org/debian/pool/main/n/node-write-file-atomic/node-write-file-atomic_3.0.3%2b%7e3.0.1-1.debian.tar.xz' node-write-file-atomic_3.0.3+~3.0.1-1.debian.tar.xz 3200 SHA256:8d8d0d69ccafe956ad3f7925957ece4db5f3acb026da860145588eef28b8255d
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-write-file-atomic/3.0.3+~3.0.1-1/ (for browsing the source)
- https://sources.debian.net/src/node-write-file-atomic/3.0.3+~3.0.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-write-file-atomic/3.0.3+~3.0.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `node-yallist=4.0.0-1`

Binary Packages:

- `node-yallist=4.0.0-1`

Licenses: (parsed from: `/usr/share/doc/node-yallist/copyright`)

- `ISC`

Source:

```console
$ apt-get source -qq --print-uris node-yallist=4.0.0-1
'http://deb.debian.org/debian/pool/main/n/node-yallist/node-yallist_4.0.0-1.dsc' node-yallist_4.0.0-1.dsc 2063 SHA256:0e75a864f614badb791a8f5d719ac36169b9c5cccb39a043e607f0e97d668cf8
'http://deb.debian.org/debian/pool/main/n/node-yallist/node-yallist_4.0.0.orig.tar.gz' node-yallist_4.0.0.orig.tar.gz 22636 SHA256:677bf22005c7600f7b4453b8e4848f27e8e3245e686f47dc3607998a41b06dad
'http://deb.debian.org/debian/pool/main/n/node-yallist/node-yallist_4.0.0-1.debian.tar.xz' node-yallist_4.0.0-1.debian.tar.xz 2492 SHA256:558e5cf026240bbe68781c5bae1603bfe8701a890639929e838af8e37dcf59be
```

Other potentially useful URLs:

- https://sources.debian.net/src/node-yallist/4.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/node-yallist/4.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/node-yallist/4.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `nodejs=12.22.12~dfsg-1~deb11u5`

Binary Packages:

- `libnode-dev=12.22.12~dfsg-1~deb11u5`
- `libnode72:amd64=12.22.12~dfsg-1~deb11u5`
- `nodejs=12.22.12~dfsg-1~deb11u5`

Licenses: (parsed from: `/usr/share/doc/libnode-dev/copyright`, `/usr/share/doc/libnode72/copyright`, `/usr/share/doc/nodejs/copyright`)

- `Apache-2.0`
- `BSD-1-clause`
- `BSD-2-clause~author`
- `BSD-2-clause~holders`
- `BSD-3-clause~Google`
- `BSD-3-clause~Intel`
- `BSD-3-clause~Sun`
- `BSD-3-clause~author`
- `BSD-3-clause~contributors`
- `BSD-3-clause~holders`
- `BSD-4-clause~author`
- `CC0`
- `CC0-1.0`
- `Expat`
- `Expat~Wu`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `ISC`
- `ISC-no-disclaim`
- `MIT/X11`
- `MIT~Prototype`
- `MPL-2.0`
- `NTP~MIT`
- `OpenSSL`
- `Python`
- `SSLeay`
- `W3C-Test-Suite`
- `curl`
- `zlib`

Source:

```console
$ apt-get source -qq --print-uris nodejs=12.22.12~dfsg-1~deb11u5
'http://deb.debian.org/debian-security/pool/updates/main/n/nodejs/nodejs_12.22.12%7edfsg-1%7edeb11u5.dsc' nodejs_12.22.12~dfsg-1~deb11u5.dsc 3505 SHA256:72b805f0043fb356dc8c942f91eb5d0ea295ecaa25e8d0d691ee1ca9facf08ca
'http://deb.debian.org/debian-security/pool/updates/main/n/nodejs/nodejs_12.22.12%7edfsg.orig-types-node.tar.xz' nodejs_12.22.12~dfsg.orig-types-node.tar.xz 87112 SHA256:e640dd32d922eed23cd5dabf56600cfd335ea5ce3c756dc96024adebf94555f8
'http://deb.debian.org/debian-security/pool/updates/main/n/nodejs/nodejs_12.22.12%7edfsg.orig.tar.xz' nodejs_12.22.12~dfsg.orig.tar.xz 19005908 SHA256:06f8eb29e52d5eb720c4ae2316b3c1b71efb12aa73bf27138f1cc776a7315aff
'http://deb.debian.org/debian-security/pool/updates/main/n/nodejs/nodejs_12.22.12%7edfsg-1%7edeb11u5.debian.tar.xz' nodejs_12.22.12~dfsg-1~deb11u5.debian.tar.xz 172576 SHA256:156fe3906209e30c6fe144bb09a6c3d7ba6275b9b224cf88aca4b2c3de0de39e
```

Other potentially useful URLs:

- https://sources.debian.net/src/nodejs/12.22.12~dfsg-1~deb11u5/ (for browsing the source)
- https://sources.debian.net/src/nodejs/12.22.12~dfsg-1~deb11u5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/nodejs/12.22.12~dfsg-1~deb11u5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `npm=7.5.2+ds-2`

Binary Packages:

- `npm=7.5.2+ds-2`

Licenses: (parsed from: `/usr/share/doc/npm/copyright`)

- `Apache-2.0`
- `Artistic-2.0`
- `BSD-2-Clause`
- `Expat`
- `ISC`

Source:

```console
$ apt-get source -qq --print-uris npm=7.5.2+ds-2
'http://deb.debian.org/debian/pool/main/n/npm/npm_7.5.2%2bds-2.dsc' npm_7.5.2+ds-2.dsc 4817 SHA256:9993f7f88ba6ef1d88ced8bb7729f174a79b105ab4fedadfc47fbe51301202d0
'http://deb.debian.org/debian/pool/main/n/npm/npm_7.5.2%2bds.orig.tar.xz' npm_7.5.2+ds.orig.tar.xz 1055356 SHA256:a24843844e734b338ac7c14c38f33d1d45fa3bc21ec384f2a915112395d8ee85
'http://deb.debian.org/debian/pool/main/n/npm/npm_7.5.2%2bds-2.debian.tar.xz' npm_7.5.2+ds-2.debian.tar.xz 26048 SHA256:4f2dcb093f3db2edf22ba7fe72a6959aef75a549894ff45af7b8a6bccfd95da3
```

Other potentially useful URLs:

- https://sources.debian.net/src/npm/7.5.2+ds-2/ (for browsing the source)
- https://sources.debian.net/src/npm/7.5.2+ds-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/npm/7.5.2+ds-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `npth=1.6-3`

Binary Packages:

- `libnpth0:amd64=1.6-3`

Licenses: (parsed from: `/usr/share/doc/libnpth0/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris npth=1.6-3
'http://deb.debian.org/debian/pool/main/n/npth/npth_1.6-3.dsc' npth_1.6-3.dsc 1931 SHA256:002c2a7936d1499ebb5d72dbb9c7ca3e00ed5fe3b0aa48f20b7279fc90aa9e90
'http://deb.debian.org/debian/pool/main/n/npth/npth_1.6.orig.tar.bz2' npth_1.6.orig.tar.bz2 300486 SHA256:1393abd9adcf0762d34798dc34fdcf4d0d22a8410721e76f1e3afcd1daa4e2d1
'http://deb.debian.org/debian/pool/main/n/npth/npth_1.6-3.debian.tar.xz' npth_1.6-3.debian.tar.xz 10712 SHA256:efa188104de503add9c49c17bec7bec0df814f7d1db9fdc2017574a0af98155c
```

Other potentially useful URLs:

- https://sources.debian.net/src/npth/1.6-3/ (for browsing the source)
- https://sources.debian.net/src/npth/1.6-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/npth/1.6-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `odoo=16.0.20241029`

Binary Packages:

- `odoo=16.0.20241029`

Licenses: (parsed from: `/usr/share/doc/odoo/copyright`)

- `Apache-2.0`
- `BSD-2`
- `BSD-3`
- `DWTFYW`
- `LGPL-3`
- `LGPL-3+`
- `MIT`
- `OFL-1.1`
- `PSF`
- `SIL-Open-Font-License`
- `SIL-Open-Font-License `

**WARNING:** unable to find source (`apt-get source` failed or returned no results)!  
This is *usually* due to a new package version being released and the old version being removed.


### `dpkg` source package: `openldap=2.4.57+dfsg-3+deb11u1`

Binary Packages:

- `libldap-2.4-2:amd64=2.4.57+dfsg-3+deb11u1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris openldap=2.4.57+dfsg-3+deb11u1
'http://deb.debian.org/debian/pool/main/o/openldap/openldap_2.4.57%2bdfsg-3%2bdeb11u1.dsc' openldap_2.4.57+dfsg-3+deb11u1.dsc 3227 SHA256:835471a38dd93cfc2c0cb6f3726a022e0a5ed47dc2759dbd811cec6df5c9e0d4
'http://deb.debian.org/debian/pool/main/o/openldap/openldap_2.4.57%2bdfsg.orig.tar.gz' openldap_2.4.57+dfsg.orig.tar.gz 5054318 SHA256:009cc88733eaf41a21607e073a19bce53d7d6ed90a5c280e80880978c4e91db7
'http://deb.debian.org/debian/pool/main/o/openldap/openldap_2.4.57%2bdfsg-3%2bdeb11u1.debian.tar.xz' openldap_2.4.57+dfsg-3+deb11u1.debian.tar.xz 170324 SHA256:2c1cbc8431c570ece2b8e6e0e13936c2f65a270e6473ecf5374ae5ba67147835
```

Other potentially useful URLs:

- https://sources.debian.net/src/openldap/2.4.57+dfsg-3+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/openldap/2.4.57+dfsg-3+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/openldap/2.4.57+dfsg-3+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `openssl=1.1.1w-0+deb11u1`

Binary Packages:

- `libssl-dev:amd64=1.1.1w-0+deb11u1`
- `libssl1.1:amd64=1.1.1w-0+deb11u1`
- `openssl=1.1.1w-0+deb11u1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris openssl=1.1.1w-0+deb11u1
'http://deb.debian.org/debian/pool/main/o/openssl/openssl_1.1.1w-0%2bdeb11u1.dsc' openssl_1.1.1w-0+deb11u1.dsc 2652 SHA256:afbce4ea965ee02879ded4aec01030b2bd195014200e96c389e05f7e57c5bcbe
'http://deb.debian.org/debian/pool/main/o/openssl/openssl_1.1.1w.orig.tar.gz' openssl_1.1.1w.orig.tar.gz 9893384 SHA256:cf3098950cb4d853ad95c0841f1f9c6d3dc102dccfcacd521d93925208b76ac8
'http://deb.debian.org/debian/pool/main/o/openssl/openssl_1.1.1w.orig.tar.gz.asc' openssl_1.1.1w.orig.tar.gz.asc 833 SHA256:5e5c3694cda755231c0438ac3c96af00d7510abd7b916d79c51bb979567040db
'http://deb.debian.org/debian/pool/main/o/openssl/openssl_1.1.1w-0%2bdeb11u1.debian.tar.xz' openssl_1.1.1w-0+deb11u1.debian.tar.xz 84088 SHA256:022636c62f183b6157b1a1c65a1365690b6e3db5b0db38a5258ec8f097a05998
```

Other potentially useful URLs:

- https://sources.debian.net/src/openssl/1.1.1w-0+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/openssl/1.1.1w-0+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/openssl/1.1.1w-0+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `p11-kit=0.23.22-1`

Binary Packages:

- `libp11-kit0:amd64=0.23.22-1`

Licenses: (parsed from: `/usr/share/doc/libp11-kit0/copyright`)

- `BSD-3-Clause`
- `ISC`
- `ISC+IBM`
- `permissive-like-automake-output`
- `same-as-rest-of-p11kit`

Source:

```console
$ apt-get source -qq --print-uris p11-kit=0.23.22-1
'http://deb.debian.org/debian/pool/main/p/p11-kit/p11-kit_0.23.22-1.dsc' p11-kit_0.23.22-1.dsc 2417 SHA256:b5f7a7908a7da082fa74c2a35667f4f4dd1324eaf43ff4b4a0ffa7e2763774a6
'http://deb.debian.org/debian/pool/main/p/p11-kit/p11-kit_0.23.22.orig.tar.xz' p11-kit_0.23.22.orig.tar.xz 830016 SHA256:8a8f40153dd5a3f8e7c03e641f8db400133fb2a6a9ab2aee1b6d0cb0495ec6b6
'http://deb.debian.org/debian/pool/main/p/p11-kit/p11-kit_0.23.22.orig.tar.xz.asc' p11-kit_0.23.22.orig.tar.xz.asc 854 SHA256:52d36bd38ed84dcc394b97da18ff4b4e220f0b13c5e7922f5b908312678b0b02
'http://deb.debian.org/debian/pool/main/p/p11-kit/p11-kit_0.23.22-1.debian.tar.xz' p11-kit_0.23.22-1.debian.tar.xz 22256 SHA256:05a157dbeb054dd14c19c0c4f72c50e57fb69c4cfa4b5d34bc7ecdb5d12e7265
```

Other potentially useful URLs:

- https://sources.debian.net/src/p11-kit/0.23.22-1/ (for browsing the source)
- https://sources.debian.net/src/p11-kit/0.23.22-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/p11-kit/0.23.22-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pam=1.4.0-9+deb11u1`

Binary Packages:

- `libpam-modules:amd64=1.4.0-9+deb11u1`
- `libpam-modules-bin=1.4.0-9+deb11u1`
- `libpam-runtime=1.4.0-9+deb11u1`
- `libpam0g:amd64=1.4.0-9+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libpam-modules/copyright`, `/usr/share/doc/libpam-modules-bin/copyright`, `/usr/share/doc/libpam-runtime/copyright`, `/usr/share/doc/libpam0g/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris pam=1.4.0-9+deb11u1
'http://deb.debian.org/debian/pool/main/p/pam/pam_1.4.0-9%2bdeb11u1.dsc' pam_1.4.0-9+deb11u1.dsc 1941 SHA256:190b705cc9daeee1febb84e8ac6f31219065f08ff41c8d38fbbb424b545d5ca4
'http://deb.debian.org/debian/pool/main/p/pam/pam_1.4.0.orig.tar.xz' pam_1.4.0.orig.tar.xz 988908 SHA256:cd6d928c51e64139be3bdb38692c68183a509b83d4f2c221024ccd4bcddfd034
'http://deb.debian.org/debian/pool/main/p/pam/pam_1.4.0-9%2bdeb11u1.debian.tar.xz' pam_1.4.0-9+deb11u1.debian.tar.xz 120148 SHA256:bcaaad9423c3ab32c5c4f9e363595a84fe3c535aa9568e42e560028a4e33dfcf
```

Other potentially useful URLs:

- https://sources.debian.net/src/pam/1.4.0-9+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/pam/1.4.0-9+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pam/1.4.0-9+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pango1.0=1.46.2-3`

Binary Packages:

- `libpango-1.0-0:amd64=1.46.2-3`
- `libpangocairo-1.0-0:amd64=1.46.2-3`
- `libpangoft2-1.0-0:amd64=1.46.2-3`

Licenses: (parsed from: `/usr/share/doc/libpango-1.0-0/copyright`, `/usr/share/doc/libpangocairo-1.0-0/copyright`, `/usr/share/doc/libpangoft2-1.0-0/copyright`)

- `Chromium-BSD-style`
- `Example`
- `ICU`
- `LGPL-2`
- `LGPL-2+`
- `TCL`
- `Unicode`

Source:

```console
$ apt-get source -qq --print-uris pango1.0=1.46.2-3
'http://deb.debian.org/debian/pool/main/p/pango1.0/pango1.0_1.46.2-3.dsc' pango1.0_1.46.2-3.dsc 3542 SHA256:bfa040cfe6ac73d4452902b682dead39e6bd057da73b5432912bb50a5336ba8a
'http://deb.debian.org/debian/pool/main/p/pango1.0/pango1.0_1.46.2.orig.tar.xz' pango1.0_1.46.2.orig.tar.xz 535108 SHA256:d89fab5f26767261b493279b65cfb9eb0955cd44c07c5628d36094609fc51841
'http://deb.debian.org/debian/pool/main/p/pango1.0/pango1.0_1.46.2-3.debian.tar.xz' pango1.0_1.46.2-3.debian.tar.xz 38956 SHA256:34e19749e45cba527a0c7f7faf5f118606a6bd85121ef58fe66d87e0e6c9a312
```

Other potentially useful URLs:

- https://sources.debian.net/src/pango1.0/1.46.2-3/ (for browsing the source)
- https://sources.debian.net/src/pango1.0/1.46.2-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pango1.0/1.46.2-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pcre2=10.36-2+deb11u1`

Binary Packages:

- `libpcre2-8-0:amd64=10.36-2+deb11u1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris pcre2=10.36-2+deb11u1
'http://deb.debian.org/debian/pool/main/p/pcre2/pcre2_10.36-2%2bdeb11u1.dsc' pcre2_10.36-2+deb11u1.dsc 2329 SHA256:9a1b7f2d20d539f4be97d07c92a980e339ae36087ca1cd51177345b37a2ec3a9
'http://deb.debian.org/debian/pool/main/p/pcre2/pcre2_10.36.orig.tar.gz' pcre2_10.36.orig.tar.gz 2290719 SHA256:b95ddb9414f91a967a887d69617059fb672b914f56fa3d613812c1ee8e8a1a37
'http://deb.debian.org/debian/pool/main/p/pcre2/pcre2_10.36-2%2bdeb11u1.diff.gz' pcre2_10.36-2+deb11u1.diff.gz 10596 SHA256:1172d8b80fa7c13c3eb571a1163babe5052f6b4586329e817ccba9759046da01
```

Other potentially useful URLs:

- https://sources.debian.net/src/pcre2/10.36-2+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/pcre2/10.36-2+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pcre2/10.36-2+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pcre3=2:8.39-13`

Binary Packages:

- `libpcre3:amd64=2:8.39-13`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris pcre3=2:8.39-13
'http://deb.debian.org/debian/pool/main/p/pcre3/pcre3_8.39-13.dsc' pcre3_8.39-13.dsc 2226 SHA256:c3a2eb4f02de5b2e00787ed2a35eb82f04ee4b5e99b8ff279bae3c6453aad93b
'http://deb.debian.org/debian/pool/main/p/pcre3/pcre3_8.39.orig.tar.bz2' pcre3_8.39.orig.tar.bz2 1560758 SHA256:b858099f82483031ee02092711689e7245586ada49e534a06e678b8ea9549e8b
'http://deb.debian.org/debian/pool/main/p/pcre3/pcre3_8.39-13.debian.tar.gz' pcre3_8.39-13.debian.tar.gz 27002 SHA256:a2143d7358d69b61955a4f977980050447f8891c0e6737080f2b14b920fbde87
```

Other potentially useful URLs:

- https://sources.debian.net/src/pcre3/2:8.39-13/ (for browsing the source)
- https://sources.debian.net/src/pcre3/2:8.39-13/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pcre3/2:8.39-13/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pdfminer=20200726-1`

Binary Packages:

- `python3-pdfminer=20200726-1`

Licenses: (parsed from: `/usr/share/doc/python3-pdfminer/copyright`)

- `BSD-Adobe`
- `Expat`
- `other-1`
- `other-2`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris pdfminer=20200726-1
'http://deb.debian.org/debian/pool/main/p/pdfminer/pdfminer_20200726-1.dsc' pdfminer_20200726-1.dsc 2359 SHA256:20174daf4a559d5f107af3c1d05f782d35152d390808aaba923e541464fbdb1e
'http://deb.debian.org/debian/pool/main/p/pdfminer/pdfminer_20200726.orig.tar.xz' pdfminer_20200726.orig.tar.xz 5132764 SHA256:970e7b06215c9a9d770af1dba9378f7ffffee7dd386e2926d0eee07a4114a6f1
'http://deb.debian.org/debian/pool/main/p/pdfminer/pdfminer_20200726-1.debian.tar.xz' pdfminer_20200726-1.debian.tar.xz 11344 SHA256:fa568310b097a57f654d18023bf78a84970fa5c4f0807c45dac78f77c43aed6b
```

Other potentially useful URLs:

- https://sources.debian.net/src/pdfminer/20200726-1/ (for browsing the source)
- https://sources.debian.net/src/pdfminer/20200726-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pdfminer/20200726-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `perl=5.32.1-4+deb11u4`

Binary Packages:

- `libperl5.32:amd64=5.32.1-4+deb11u4`
- `perl=5.32.1-4+deb11u4`
- `perl-base=5.32.1-4+deb11u4`
- `perl-modules-5.32=5.32.1-4+deb11u4`

Licenses: (parsed from: `/usr/share/doc/libperl5.32/copyright`, `/usr/share/doc/perl/copyright`, `/usr/share/doc/perl-base/copyright`, `/usr/share/doc/perl-modules-5.32/copyright`)

- `Artistic`
- `Artistic,`
- `Artistic-2`
- `Artistic-dist`
- `BSD-3-clause`
- `BSD-3-clause-GENERIC`
- `BSD-3-clause-with-weird-numbering`
- `BSD-4-clause-POWERDOG`
- `BZIP`
- `CC0-1.0`
- `DONT-CHANGE-THE-GPL`
- `Expat`
- `GPL-1`
- `GPL-1+`
- `GPL-2`
- `GPL-2+`
- `GPL-3+-WITH-BISON-EXCEPTION`
- `HSIEH-BSD`
- `HSIEH-DERIVATIVE`
- `LGPL-2.1`
- `REGCOMP`
- `REGCOMP,`
- `RRA-KEEP-THIS-NOTICE`
- `SDBM-PUBLIC-DOMAIN`
- `TEXT-TABS`
- `Unicode`
- `ZLIB`

Source:

```console
$ apt-get source -qq --print-uris perl=5.32.1-4+deb11u4
'http://deb.debian.org/debian-security/pool/updates/main/p/perl/perl_5.32.1-4%2bdeb11u4.dsc' perl_5.32.1-4+deb11u4.dsc 2893 SHA256:57ac45e316fd4a82e476883c3326f9df7f27ed6ff07cc4541a0600b503742695
'http://deb.debian.org/debian-security/pool/updates/main/p/perl/perl_5.32.1.orig-regen-configure.tar.gz' perl_5.32.1.orig-regen-configure.tar.gz 871331 SHA256:1d179b41283f12ad83f9758430f6ddc49bdf20db5c396aeae7e51ebb4e4afd29
'http://deb.debian.org/debian-security/pool/updates/main/p/perl/perl_5.32.1.orig.tar.xz' perl_5.32.1.orig.tar.xz 12610988 SHA256:57cc47c735c8300a8ce2fa0643507b44c4ae59012bfdad0121313db639e02309
'http://deb.debian.org/debian-security/pool/updates/main/p/perl/perl_5.32.1-4%2bdeb11u4.debian.tar.xz' perl_5.32.1-4+deb11u4.debian.tar.xz 170428 SHA256:3fd8c90c0b5a8d4efeb2f2cb03d4c83d9fff90e223d3d1d385754a44cf59f597
```

Other potentially useful URLs:

- https://sources.debian.net/src/perl/5.32.1-4+deb11u4/ (for browsing the source)
- https://sources.debian.net/src/perl/5.32.1-4+deb11u4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/perl/5.32.1-4+deb11u4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pillow=8.1.2+dfsg-0.3+deb11u2`

Binary Packages:

- `python3-pil:amd64=8.1.2+dfsg-0.3+deb11u2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris pillow=8.1.2+dfsg-0.3+deb11u2
'http://deb.debian.org/debian/pool/main/p/pillow/pillow_8.1.2%2bdfsg-0.3%2bdeb11u2.dsc' pillow_8.1.2+dfsg-0.3+deb11u2.dsc 2509 SHA256:33e08d51702a266a4e187da8d0085a4104628bf11c51aad517b297dfc22d1bce
'http://deb.debian.org/debian/pool/main/p/pillow/pillow_8.1.2%2bdfsg.orig.tar.xz' pillow_8.1.2+dfsg.orig.tar.xz 37523796 SHA256:7fb9b5e9306bfc30990322314cd92b6befd8e6ab9af6ef5bbccca18f938e4e49
'http://deb.debian.org/debian/pool/main/p/pillow/pillow_8.1.2%2bdfsg-0.3%2bdeb11u2.debian.tar.xz' pillow_8.1.2+dfsg-0.3+deb11u2.debian.tar.xz 26000 SHA256:9e9cc4f93fb7a669524047a694f686c2777b86a8bc8c7f98a5590b26b4b9a28b
```

Other potentially useful URLs:

- https://sources.debian.net/src/pillow/8.1.2+dfsg-0.3+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/pillow/8.1.2+dfsg-0.3+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pillow/8.1.2+dfsg-0.3+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pinentry=1.1.0-4`

Binary Packages:

- `pinentry-curses=1.1.0-4`

Licenses: (parsed from: `/usr/share/doc/pinentry-curses/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-3`
- `LGPL-3+`
- `X11`

Source:

```console
$ apt-get source -qq --print-uris pinentry=1.1.0-4
'http://deb.debian.org/debian/pool/main/p/pinentry/pinentry_1.1.0-4.dsc' pinentry_1.1.0-4.dsc 2216 SHA256:81af8caf54fb2ddc6ac27d768999b3aa5d3bbeec7f2edac839b2c6792a3cf787
'http://deb.debian.org/debian/pool/main/p/pinentry/pinentry_1.1.0.orig.tar.bz2' pinentry_1.1.0.orig.tar.bz2 467702 SHA256:68076686fa724a290ea49cdf0d1c0c1500907d1b759a3bcbfbec0293e8f56570
'http://deb.debian.org/debian/pool/main/p/pinentry/pinentry_1.1.0.orig.tar.bz2.asc' pinentry_1.1.0.orig.tar.bz2.asc 488 SHA256:2e9ee3454f9e0be2f6cbc0e289fa5e0620d765e537286ff2c5c28b382f96106a
'http://deb.debian.org/debian/pool/main/p/pinentry/pinentry_1.1.0-4.debian.tar.xz' pinentry_1.1.0-4.debian.tar.xz 17240 SHA256:b3e36d239219ab35f824c5f9b3dd0c335a4394c59b7628e845831794335b8a8e
```

Other potentially useful URLs:

- https://sources.debian.net/src/pinentry/1.1.0-4/ (for browsing the source)
- https://sources.debian.net/src/pinentry/1.1.0-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pinentry/1.1.0-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pixman=0.40.0-1.1~deb11u1`

Binary Packages:

- `libpixman-1-0:amd64=0.40.0-1.1~deb11u1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris pixman=0.40.0-1.1~deb11u1
'http://deb.debian.org/debian/pool/main/p/pixman/pixman_0.40.0-1.1%7edeb11u1.dsc' pixman_0.40.0-1.1~deb11u1.dsc 2216 SHA256:f7a628fbfcb5dae5178daab6e0225be55dbf6ffd8efa60429d1d3dd59584d334
'http://deb.debian.org/debian/pool/main/p/pixman/pixman_0.40.0.orig.tar.gz' pixman_0.40.0.orig.tar.gz 913976 SHA256:6d200dec3740d9ec4ec8d1180e25779c00bc749f94278c8b9021f5534db223fc
'http://deb.debian.org/debian/pool/main/p/pixman/pixman_0.40.0-1.1%7edeb11u1.diff.gz' pixman_0.40.0-1.1~deb11u1.diff.gz 320106 SHA256:11dad4be11db34aab221a324b78a5f7a88ac96596f5ac39d4fe3b634325b00b7
```

Other potentially useful URLs:

- https://sources.debian.net/src/pixman/0.40.0-1.1~deb11u1/ (for browsing the source)
- https://sources.debian.net/src/pixman/0.40.0-1.1~deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pixman/0.40.0-1.1~deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `polib=1.1.0-7`

Binary Packages:

- `python3-polib=1.1.0-7`

Licenses: (parsed from: `/usr/share/doc/python3-polib/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris polib=1.1.0-7
'http://deb.debian.org/debian/pool/main/p/polib/polib_1.1.0-7.dsc' polib_1.1.0-7.dsc 2043 SHA256:126d9cce43a5df41cd46ab2dd5a7b585e9524f921b97b64374a466286ef019b0
'http://deb.debian.org/debian/pool/main/p/polib/polib_1.1.0.orig.tar.gz' polib_1.1.0.orig.tar.gz 158484 SHA256:fad87d13696127ffb27ea0882d6182f1a9cf8a5e2b37a587751166c51e5a332a
'http://deb.debian.org/debian/pool/main/p/polib/polib_1.1.0-7.debian.tar.xz' polib_1.1.0-7.debian.tar.xz 4528 SHA256:9105ca61d2924914eb20aa124eaf81b810e8ccf6de551cd3475b999060183b8c
```

Other potentially useful URLs:

- https://sources.debian.net/src/polib/1.1.0-7/ (for browsing the source)
- https://sources.debian.net/src/polib/1.1.0-7/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/polib/1.1.0-7/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `postgresql-17=17.0-1.pgdg110+1`

Binary Packages:

- `libpq5:amd64=17.0-1.pgdg110+1`
- `postgresql-client-17=17.0-1.pgdg110+1`

Licenses: (parsed from: `/usr/share/doc/libpq5/copyright`, `/usr/share/doc/postgresql-client-17/copyright`)

- `Artistic`
- `BSD-2-clause`
- `BSD-3-Clause`
- `BSD-3-clause`
- `Custom-Unicode`
- `Custom-pg_dump`
- `Custom-regex`
- `GPL-1`
- `PostgreSQL`
- `Tcl`
- `double-metaphone`
- `nagaysau-ishii`

**WARNING:** unable to find source (`apt-get source` failed or returned no results)!  
This is *usually* due to a new package version being released and the old version being removed.


### `dpkg` source package: `postgresql-common=264.pgdg110+1`

Binary Packages:

- `postgresql-client=17+264.pgdg110+1`
- `postgresql-client-common=264.pgdg110+1`

Licenses: (parsed from: `/usr/share/doc/postgresql-client/copyright`, `/usr/share/doc/postgresql-client-common/copyright`)

- `GPL-2`
- `GPL-2+`

**WARNING:** unable to find source (`apt-get source` failed or returned no results)!  
This is *usually* due to a new package version being released and the old version being removed.


### `dpkg` source package: `psl.js=1.8.0+ds-4`

Binary Packages:

- `libjs-psl=1.8.0+ds-4`
- `node-psl=1.8.0+ds-4`

Licenses: (parsed from: `/usr/share/doc/libjs-psl/copyright`, `/usr/share/doc/node-psl/copyright`)

- `CC0`
- `CC0-1.0`
- `Expat`

Source:

```console
$ apt-get source -qq --print-uris psl.js=1.8.0+ds-4
'http://deb.debian.org/debian/pool/main/p/psl.js/psl.js_1.8.0%2bds-4.dsc' psl.js_1.8.0+ds-4.dsc 2370 SHA256:3d777946bb06bbe54dfba77917d10a75d063e75d198fbf1fe334f6097f1e525d
'http://deb.debian.org/debian/pool/main/p/psl.js/psl.js_1.8.0%2bds.orig.tar.xz' psl.js_1.8.0+ds.orig.tar.xz 88332 SHA256:4aee8038a9a853bd9520004364e0eb745718b8c3621e20063b1f7c80e76a0937
'http://deb.debian.org/debian/pool/main/p/psl.js/psl.js_1.8.0%2bds-4.debian.tar.xz' psl.js_1.8.0+ds-4.debian.tar.xz 4324 SHA256:a5e34249f5e5efee661dd749f25f41a827abc042a508a9bb07da8caaca2f51e8
```

Other potentially useful URLs:

- https://sources.debian.net/src/psl.js/1.8.0+ds-4/ (for browsing the source)
- https://sources.debian.net/src/psl.js/1.8.0+ds-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/psl.js/1.8.0+ds-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `psycopg2=2.8.6-2`

Binary Packages:

- `python3-psycopg2=2.8.6-2`

Licenses: (parsed from: `/usr/share/doc/python3-psycopg2/copyright`)

- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris psycopg2=2.8.6-2
'http://deb.debian.org/debian/pool/main/p/psycopg2/psycopg2_2.8.6-2.dsc' psycopg2_2.8.6-2.dsc 2647 SHA256:ec098a74fa7f2af70ea96be36b21beadec61e91c37840a1a19087035dc756b84
'http://deb.debian.org/debian/pool/main/p/psycopg2/psycopg2_2.8.6.orig.tar.gz' psycopg2_2.8.6.orig.tar.gz 383797 SHA256:fb23f6c71107c37fd667cb4ea363ddeb936b348bbd6449278eb92c189699f543
'http://deb.debian.org/debian/pool/main/p/psycopg2/psycopg2_2.8.6.orig.tar.gz.asc' psycopg2_2.8.6.orig.tar.gz.asc 488 SHA256:564854ebd2ba4b34bd6f6329d2de8c50cf281d3dc78a8d2d23394325237f9190
'http://deb.debian.org/debian/pool/main/p/psycopg2/psycopg2_2.8.6-2.debian.tar.xz' psycopg2_2.8.6-2.debian.tar.xz 17916 SHA256:0c6b729d40d0d7b289936682d296b717343401d9f1ae465d0833dcc07975e3f7
```

Other potentially useful URLs:

- https://sources.debian.net/src/psycopg2/2.8.6-2/ (for browsing the source)
- https://sources.debian.net/src/psycopg2/2.8.6-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/psycopg2/2.8.6-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pyasn1=0.4.8-1`

Binary Packages:

- `python3-pyasn1=0.4.8-1`

Licenses: (parsed from: `/usr/share/doc/python3-pyasn1/copyright`)

- `BSD-2-clause`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris pyasn1=0.4.8-1
'http://deb.debian.org/debian/pool/main/p/pyasn1/pyasn1_0.4.8-1.dsc' pyasn1_0.4.8-1.dsc 2120 SHA256:e8193da16e0f5c7a7ba3a0746bd61bee4eb9a6c166845692c8e2f617dc18f789
'http://deb.debian.org/debian/pool/main/p/pyasn1/pyasn1_0.4.8.orig.tar.gz' pyasn1_0.4.8.orig.tar.gz 146820 SHA256:aef77c9fb94a3ac588e87841208bdec464471d9871bd5050a287cc9a475cd0ba
'http://deb.debian.org/debian/pool/main/p/pyasn1/pyasn1_0.4.8-1.debian.tar.xz' pyasn1_0.4.8-1.debian.tar.xz 5380 SHA256:00c1059ac9b30babcf3dafc430891a0af887fcf615b04c00ae05bba7b8ed4a07
```

Other potentially useful URLs:

- https://sources.debian.net/src/pyasn1/0.4.8-1/ (for browsing the source)
- https://sources.debian.net/src/pyasn1/0.4.8-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pyasn1/0.4.8-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pydot=1.4.2-1`

Binary Packages:

- `python3-pydot=1.4.2-1`

Licenses: (parsed from: `/usr/share/doc/python3-pydot/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris pydot=1.4.2-1
'http://deb.debian.org/debian/pool/main/p/pydot/pydot_1.4.2-1.dsc' pydot_1.4.2-1.dsc 2018 SHA256:6525a3ad8e7f645f9c68d7cbc4dfbcf1cfafe5472f526b6df77fa8ca86f550a0
'http://deb.debian.org/debian/pool/main/p/pydot/pydot_1.4.2.orig.tar.xz' pydot_1.4.2.orig.tar.xz 231120 SHA256:6697466ff578060978334699c6b869e9244c04127079bb9e141f591e8a742242
'http://deb.debian.org/debian/pool/main/p/pydot/pydot_1.4.2-1.debian.tar.xz' pydot_1.4.2-1.debian.tar.xz 4524 SHA256:049557de8ad4aca1a0b9b07cd5d40193e9d6ef0973fd83f9753c0c0053310e69
```

Other potentially useful URLs:

- https://sources.debian.net/src/pydot/1.4.2-1/ (for browsing the source)
- https://sources.debian.net/src/pydot/1.4.2-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pydot/1.4.2-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pyopenssl=20.0.1-1`

Binary Packages:

- `python3-openssl=20.0.1-1`

Licenses: (parsed from: `/usr/share/doc/python3-openssl/copyright`)

- `Apache-2.0`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris pyopenssl=20.0.1-1
'http://deb.debian.org/debian/pool/main/p/pyopenssl/pyopenssl_20.0.1-1.dsc' pyopenssl_20.0.1-1.dsc 2236 SHA256:86d8649ec9e296293b7446b880c7723e9a321273e45a3353c239b6963e0faa53
'http://deb.debian.org/debian/pool/main/p/pyopenssl/pyopenssl_20.0.1.orig.tar.xz' pyopenssl_20.0.1.orig.tar.xz 141460 SHA256:6a9be4dc45c5353ff39e53975a6ffe1c6729e3c527854b7d1620ff891d1dc5f6
'http://deb.debian.org/debian/pool/main/p/pyopenssl/pyopenssl_20.0.1-1.debian.tar.xz' pyopenssl_20.0.1-1.debian.tar.xz 9308 SHA256:bc12291fdb06111fd44fbca4f1a4b8c7c8a05c0676360e5aeb06c4bc4e1ea2a5
```

Other potentially useful URLs:

- https://sources.debian.net/src/pyopenssl/20.0.1-1/ (for browsing the source)
- https://sources.debian.net/src/pyopenssl/20.0.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pyopenssl/20.0.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pyparsing=2.4.7-1`

Binary Packages:

- `python3-pyparsing=2.4.7-1`

Licenses: (parsed from: `/usr/share/doc/python3-pyparsing/copyright`)

- `BSD-2-clause`
- `BSD-3-clause`
- `Expat`
- `GPL-2`
- `GPL-3`
- `ellis-and-grant`
- `salvolainen`

Source:

```console
$ apt-get source -qq --print-uris pyparsing=2.4.7-1
'http://deb.debian.org/debian/pool/main/p/pyparsing/pyparsing_2.4.7-1.dsc' pyparsing_2.4.7-1.dsc 2340 SHA256:bcbbd1024882d358b3ac8c77f74b29675eefa2db8874939c82a93ce28268b85a
'http://deb.debian.org/debian/pool/main/p/pyparsing/pyparsing_2.4.7.orig.tar.gz' pyparsing_2.4.7.orig.tar.gz 649718 SHA256:c203ec8783bf771a155b207279b9bccb8dea02d8f0c9e5f8ead507bc3246ecc1
'http://deb.debian.org/debian/pool/main/p/pyparsing/pyparsing_2.4.7-1.debian.tar.xz' pyparsing_2.4.7-1.debian.tar.xz 7764 SHA256:4d7d65dd5013893304581a5d3d1209cc1481814ce70a8c7de66349a2aac7c917
```

Other potentially useful URLs:

- https://sources.debian.net/src/pyparsing/2.4.7-1/ (for browsing the source)
- https://sources.debian.net/src/pyparsing/2.4.7-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pyparsing/2.4.7-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pypdf2=1.26.0-4+deb11u1`

Binary Packages:

- `python3-pypdf2=1.26.0-4+deb11u1`

Licenses: (parsed from: `/usr/share/doc/python3-pypdf2/copyright`)

- `BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris pypdf2=1.26.0-4+deb11u1
'http://deb.debian.org/debian/pool/main/p/pypdf2/pypdf2_1.26.0-4%2bdeb11u1.dsc' pypdf2_1.26.0-4+deb11u1.dsc 1782 SHA256:67db7ed0e68119817209f2879f30a7a430c390e02df7f35665760b5955b4ca35
'http://deb.debian.org/debian/pool/main/p/pypdf2/pypdf2_1.26.0.orig.tar.gz' pypdf2_1.26.0.orig.tar.gz 199539 SHA256:140b1fed792f487f2fd814eb0e832a5b6ef5ae362da302c1fc5a9786d5acb469
'http://deb.debian.org/debian/pool/main/p/pypdf2/pypdf2_1.26.0-4%2bdeb11u1.debian.tar.xz' pypdf2_1.26.0-4+deb11u1.debian.tar.xz 5184 SHA256:02a281dc7c72b3f5c0c08d330fcc76b8d3bbe025bd2bb399f5550933044486c5
```

Other potentially useful URLs:

- https://sources.debian.net/src/pypdf2/1.26.0-4+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/pypdf2/1.26.0-4+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pypdf2/1.26.0-4+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pyserial=3.5~b0-1`

Binary Packages:

- `python3-serial=3.5~b0-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris pyserial=3.5~b0-1
'http://deb.debian.org/debian/pool/main/p/pyserial/pyserial_3.5%7eb0-1.dsc' pyserial_3.5~b0-1.dsc 1810 SHA256:3018ec9ededd9af8a0befcabea87824cb81b62740eda2497714cc9ffde2063f7
'http://deb.debian.org/debian/pool/main/p/pyserial/pyserial_3.5%7eb0.orig.tar.gz' pyserial_3.5~b0.orig.tar.gz 158549 SHA256:f7da4709c36b9ab5594216426d4c82a9f3d9629138120dbe7befbdd1a1dd1d44
'http://deb.debian.org/debian/pool/main/p/pyserial/pyserial_3.5%7eb0-1.debian.tar.xz' pyserial_3.5~b0-1.debian.tar.xz 4004 SHA256:85150be69042b5182d4e526f7707e4fe79f562e58519f339c836a51e98581375
```

Other potentially useful URLs:

- https://sources.debian.net/src/pyserial/3.5~b0-1/ (for browsing the source)
- https://sources.debian.net/src/pyserial/3.5~b0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pyserial/3.5~b0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-argh=0.26.2-1.1`

Binary Packages:

- `python3-argh=0.26.2-1.1`

Licenses: (parsed from: `/usr/share/doc/python3-argh/copyright`)

- `LGPL-3`
- `LGPL-3.0+`

Source:

```console
$ apt-get source -qq --print-uris python-argh=0.26.2-1.1
'http://deb.debian.org/debian/pool/main/p/python-argh/python-argh_0.26.2-1.1.dsc' python-argh_0.26.2-1.1.dsc 1978 SHA256:b2ffeae4336cbfa88066b756df088d165a6d8345e7b79ca262e769ee9180ec63
'http://deb.debian.org/debian/pool/main/p/python-argh/python-argh_0.26.2.orig.tar.gz' python-argh_0.26.2.orig.tar.gz 32913 SHA256:e9535b8c84dc9571a48999094fda7f33e63c3f1b74f3e5f3ac0105a58405bb65
'http://deb.debian.org/debian/pool/main/p/python-argh/python-argh_0.26.2-1.1.debian.tar.xz' python-argh_0.26.2-1.1.debian.tar.xz 3664 SHA256:9f03cbe904071e4200cae6a3efb86e1b994f9e8a632f866aab4e32990136686d
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-argh/0.26.2-1.1/ (for browsing the source)
- https://sources.debian.net/src/python-argh/0.26.2-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-argh/0.26.2-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-attrs=20.3.0-1`

Binary Packages:

- `python3-attr=20.3.0-1`

Licenses: (parsed from: `/usr/share/doc/python3-attr/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris python-attrs=20.3.0-1
'http://deb.debian.org/debian/pool/main/p/python-attrs/python-attrs_20.3.0-1.dsc' python-attrs_20.3.0-1.dsc 2130 SHA256:959ac0c2cbd669c56e70ee7c6870a52bccd70495ca3c65ce3b12929ca3a42ca7
'http://deb.debian.org/debian/pool/main/p/python-attrs/python-attrs_20.3.0.orig.tar.gz' python-attrs_20.3.0.orig.tar.gz 157041 SHA256:c7d2ef493768bfea33cd5d8cbd2a6c2ddf229d5e8c3a79aefa67d1daf1e9d96d
'http://deb.debian.org/debian/pool/main/p/python-attrs/python-attrs_20.3.0-1.debian.tar.xz' python-attrs_20.3.0-1.debian.tar.xz 5016 SHA256:8c5d9ba58ee92e51a32479f19fa06f943e0faaa80599873b454ec0eb57f808b2
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-attrs/20.3.0-1/ (for browsing the source)
- https://sources.debian.net/src/python-attrs/20.3.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-attrs/20.3.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-babel=2.8.0+dfsg.1-7`

Binary Packages:

- `python-babel-localedata=2.8.0+dfsg.1-7`
- `python3-babel=2.8.0+dfsg.1-7`

Licenses: (parsed from: `/usr/share/doc/python-babel-localedata/copyright`, `/usr/share/doc/python3-babel/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2+`
- `Unicode`

Source:

```console
$ apt-get source -qq --print-uris python-babel=2.8.0+dfsg.1-7
'http://deb.debian.org/debian/pool/main/p/python-babel/python-babel_2.8.0%2bdfsg.1-7.dsc' python-babel_2.8.0+dfsg.1-7.dsc 2343 SHA256:a88c1f9bee68819f2677f8e5864811d3aca558dc1edbf94a5f3308449f60bc16
'http://deb.debian.org/debian/pool/main/p/python-babel/python-babel_2.8.0%2bdfsg.1.orig.tar.xz' python-babel_2.8.0+dfsg.1.orig.tar.xz 14029964 SHA256:099ee52ffe5d386321d0108b2de0f93aa8cd5a56149dbb55b7c77e3b9637e4e4
'http://deb.debian.org/debian/pool/main/p/python-babel/python-babel_2.8.0%2bdfsg.1-7.debian.tar.xz' python-babel_2.8.0+dfsg.1-7.debian.tar.xz 13700 SHA256:5a429cf185cc77af648204459cd7e7a0f41f15189a6c639b35af1baece9e129b
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-babel/2.8.0+dfsg.1-7/ (for browsing the source)
- https://sources.debian.net/src/python-babel/2.8.0+dfsg.1-7/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-babel/2.8.0+dfsg.1-7/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-certifi=2020.6.20-1`

Binary Packages:

- `python3-certifi=2020.6.20-1`

Licenses: (parsed from: `/usr/share/doc/python3-certifi/copyright`)

- `GPL-2`
- `MPL-2`

Source:

```console
$ apt-get source -qq --print-uris python-certifi=2020.6.20-1
'http://deb.debian.org/debian/pool/main/p/python-certifi/python-certifi_2020.6.20-1.dsc' python-certifi_2020.6.20-1.dsc 1627 SHA256:8877bea77efed2f16733d49603f45168869acf0fe628d48893863b592395748c
'http://deb.debian.org/debian/pool/main/p/python-certifi/python-certifi_2020.6.20.orig.tar.xz' python-certifi_2020.6.20.orig.tar.xz 144184 SHA256:ddbe29ec8fca0018d49b6beb189082b0957a2c076ce38d77005388777936aa33
'http://deb.debian.org/debian/pool/main/p/python-certifi/python-certifi_2020.6.20-1.debian.tar.xz' python-certifi_2020.6.20-1.debian.tar.xz 8104 SHA256:dc34c084680290d6fd5227cba3d1f41e840ce8ed1ed9b28bac5f3947440ead3b
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-certifi/2020.6.20-1/ (for browsing the source)
- https://sources.debian.net/src/python-certifi/2020.6.20-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-certifi/2020.6.20-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-cffi=1.14.5-1`

Binary Packages:

- `python3-cffi-backend:amd64=1.14.5-1`

Licenses: (parsed from: `/usr/share/doc/python3-cffi-backend/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris python-cffi=1.14.5-1
'http://deb.debian.org/debian/pool/main/p/python-cffi/python-cffi_1.14.5-1.dsc' python-cffi_1.14.5-1.dsc 1871 SHA256:2df871cc959dc99b490720427ae7e29778eb0ed3f9b57721d274dfc52779169c
'http://deb.debian.org/debian/pool/main/p/python-cffi/python-cffi_1.14.5.orig.tar.gz' python-cffi_1.14.5.orig.tar.gz 475055 SHA256:fd78e5fee591709f32ef6edb9a015b4aa1a5022598e36227500c8f4e02328d9c
'http://deb.debian.org/debian/pool/main/p/python-cffi/python-cffi_1.14.5-1.debian.tar.xz' python-cffi_1.14.5-1.debian.tar.xz 6880 SHA256:f63edaa6b42d79dd8c3ddcca080b3f3b4daf809b594c445a7d83f93988e4a79e
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-cffi/1.14.5-1/ (for browsing the source)
- https://sources.debian.net/src/python-cffi/1.14.5-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-cffi/1.14.5-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-cryptography=3.3.2-1+deb11u1`

Binary Packages:

- `python3-cryptography=3.3.2-1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/python3-cryptography/copyright`)

- `Apache`
- `Apache-2.0`
- `Expat`

Source:

```console
$ apt-get source -qq --print-uris python-cryptography=3.3.2-1+deb11u1
'http://deb.debian.org/debian-security/pool/updates/main/p/python-cryptography/python-cryptography_3.3.2-1%2bdeb11u1.dsc' python-cryptography_3.3.2-1+deb11u1.dsc 3260 SHA256:8361021fdb98e0bf788e8f108105d6d3c44eb55ebcd7b00a35bd214d5afce702
'http://deb.debian.org/debian-security/pool/updates/main/p/python-cryptography/python-cryptography_3.3.2.orig.tar.gz' python-cryptography_3.3.2.orig.tar.gz 539883 SHA256:5a60d3780149e13b7a6ff7ad6526b38846354d11a15e21068e57073e29e19bed
'http://deb.debian.org/debian-security/pool/updates/main/p/python-cryptography/python-cryptography_3.3.2.orig.tar.gz.asc' python-cryptography_3.3.2.orig.tar.gz.asc 488 SHA256:4e662a721607429b6d233c140d0884e367b7d9de6867de92e90ded52f9267930
'http://deb.debian.org/debian-security/pool/updates/main/p/python-cryptography/python-cryptography_3.3.2-1%2bdeb11u1.debian.tar.xz' python-cryptography_3.3.2-1+deb11u1.debian.tar.xz 13252 SHA256:fc96b30a5cf0e619018ccce21fcd14d4992ea24b040560dc5fea5a5a2f60a09c
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-cryptography/3.3.2-1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/python-cryptography/3.3.2-1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-cryptography/3.3.2-1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-dateutil=2.8.1-6`

Binary Packages:

- `python3-dateutil=2.8.1-6`

Licenses: (parsed from: `/usr/share/doc/python3-dateutil/copyright`)

- `BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris python-dateutil=2.8.1-6
'http://deb.debian.org/debian/pool/main/p/python-dateutil/python-dateutil_2.8.1-6.dsc' python-dateutil_2.8.1-6.dsc 2129 SHA256:7c414ca09e0e9799c426d7e9649e61c5f6877536cbda9a2b333d725a0f704bf5
'http://deb.debian.org/debian/pool/main/p/python-dateutil/python-dateutil_2.8.1.orig.tar.gz' python-dateutil_2.8.1.orig.tar.gz 331745 SHA256:73ebfe9dbf22e832286dafa60473e4cd239f8592f699aa5adaf10050e6e1823c
'http://deb.debian.org/debian/pool/main/p/python-dateutil/python-dateutil_2.8.1-6.debian.tar.xz' python-dateutil_2.8.1-6.debian.tar.xz 11508 SHA256:fdd65bc5b71ab46e0478864d366dd7db447f7e2588c8b42c61ef979c47d092db
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-dateutil/2.8.1-6/ (for browsing the source)
- https://sources.debian.net/src/python-dateutil/2.8.1-6/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-dateutil/2.8.1-6/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-decorator=4.4.2-2`

Binary Packages:

- `python3-decorator=4.4.2-2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris python-decorator=4.4.2-2
'http://deb.debian.org/debian/pool/main/p/python-decorator/python-decorator_4.4.2-2.dsc' python-decorator_4.4.2-2.dsc 2070 SHA256:f49e148f5dcf02c2eb1607d2ef6b2b3616ed24eb137cb0742c12e90d9d35f6b0
'http://deb.debian.org/debian/pool/main/p/python-decorator/python-decorator_4.4.2.orig.tar.gz' python-decorator_4.4.2.orig.tar.gz 33629 SHA256:e3a62f0520172440ca0dcc823749319382e377f37f140a0b99ef45fecb84bfe7
'http://deb.debian.org/debian/pool/main/p/python-decorator/python-decorator_4.4.2-2.debian.tar.xz' python-decorator_4.4.2-2.debian.tar.xz 3840 SHA256:e25d0c993f8361171112e9b477939827919e1967c2381f8bc41aa81982cac82b
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-decorator/4.4.2-2/ (for browsing the source)
- https://sources.debian.net/src/python-decorator/4.4.2-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-decorator/4.4.2-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-docutils=0.16+dfsg-4`

Binary Packages:

- `docutils-common=0.16+dfsg-4`
- `python3-docutils=0.16+dfsg-4`

Licenses: (parsed from: `/usr/share/doc/docutils-common/copyright`, `/usr/share/doc/python3-docutils/copyright`)

- `BSD-2-clause`
- `BSD-3-clause`
- `GPL-3`
- `GPL-3+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `Python-2.1.1`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris python-docutils=0.16+dfsg-4
'http://deb.debian.org/debian/pool/main/p/python-docutils/python-docutils_0.16%2bdfsg-4.dsc' python-docutils_0.16+dfsg-4.dsc 2385 SHA256:e5269fc695a0b4ab43d1997b15a5eee77dbfbcebcf234fd085ec8f1a2cf478f2
'http://deb.debian.org/debian/pool/main/p/python-docutils/python-docutils_0.16%2bdfsg.orig.tar.xz' python-docutils_0.16+dfsg.orig.tar.xz 1347300 SHA256:eee46a039937dd648a03a534647cdbb2370b288076e12d9e330a3fe8ef66781e
'http://deb.debian.org/debian/pool/main/p/python-docutils/python-docutils_0.16%2bdfsg-4.debian.tar.xz' python-docutils_0.16+dfsg-4.debian.tar.xz 31036 SHA256:9ce198ac913d41e7b8f2dc1b41a57b3213c42fa3e6b4e8265d5478e2406054d7
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-docutils/0.16+dfsg-4/ (for browsing the source)
- https://sources.debian.net/src/python-docutils/0.16+dfsg-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-docutils/0.16+dfsg-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-gevent=20.9.0-2`

Binary Packages:

- `python3-gevent=20.9.0-2`

Licenses: (parsed from: `/usr/share/doc/python3-gevent/copyright`)

- `Apache-2.0`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris python-gevent=20.9.0-2
'http://deb.debian.org/debian/pool/main/p/python-gevent/python-gevent_20.9.0-2.dsc' python-gevent_20.9.0-2.dsc 2247 SHA256:c72384546a62b62c1506263a67c85ca2c8f84849c2d1ab27ef7a2040fb39375a
'http://deb.debian.org/debian/pool/main/p/python-gevent/python-gevent_20.9.0.orig.tar.gz' python-gevent_20.9.0.orig.tar.gz 4237730 SHA256:a43d6b8335eae4d1ebb3f9585bcb78c397c6f1f141eb2449838167cbb4a40ee3
'http://deb.debian.org/debian/pool/main/p/python-gevent/python-gevent_20.9.0-2.debian.tar.xz' python-gevent_20.9.0-2.debian.tar.xz 72076 SHA256:e6f761cf971e6ecf3ff5ac2b2d988ed86ec903887f21d5a76a704e42da6e203a
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-gevent/20.9.0-2/ (for browsing the source)
- https://sources.debian.net/src/python-gevent/20.9.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-gevent/20.9.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-greenlet=0.4.17-1`

Binary Packages:

- `python3-greenlet=0.4.17-1+b1`

Licenses: (parsed from: `/usr/share/doc/python3-greenlet/copyright`)

- `GPL-3`
- `MIT`
- `PSFL-2`

Source:

```console
$ apt-get source -qq --print-uris python-greenlet=0.4.17-1
'http://deb.debian.org/debian/pool/main/p/python-greenlet/python-greenlet_0.4.17-1.dsc' python-greenlet_0.4.17-1.dsc 2091 SHA256:0a64a8f8ef2918ac1eacfc0c297969887398fdccc354301de02ae0e03465a2c6
'http://deb.debian.org/debian/pool/main/p/python-greenlet/python-greenlet_0.4.17.orig.tar.gz' python-greenlet_0.4.17.orig.tar.gz 59443 SHA256:c63c8258eef589a86c266a05385b1ed105cf2a7fc48f47c89bb0c1de48d90c00
'http://deb.debian.org/debian/pool/main/p/python-greenlet/python-greenlet_0.4.17-1.debian.tar.xz' python-greenlet_0.4.17-1.debian.tar.xz 6664 SHA256:7358cd37aef8701267a3b3b5bdb972a142347908c64b69d9d8dbf9149f0a1d61
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-greenlet/0.4.17-1/ (for browsing the source)
- https://sources.debian.net/src/python-greenlet/0.4.17-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-greenlet/0.4.17-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-idna=2.10-1+deb11u1`

Binary Packages:

- `python3-idna=2.10-1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/python3-idna/copyright`)

- `BSD-3-clause`
- `PSF-2`
- `Unicode`

Source:

```console
$ apt-get source -qq --print-uris python-idna=2.10-1+deb11u1
'http://deb.debian.org/debian/pool/main/p/python-idna/python-idna_2.10-1%2bdeb11u1.dsc' python-idna_2.10-1+deb11u1.dsc 2116 SHA256:b8316aa6f8500e7d6bd1c0dd0ec3cf02f90e5ad3fc56f3475c8e471f65e8fb76
'http://deb.debian.org/debian/pool/main/p/python-idna/python-idna_2.10.orig.tar.gz' python-idna_2.10.orig.tar.gz 175616 SHA256:b307872f855b18632ce0c21c5e45be78c0ea7ae4c15c828c20788b26921eb3f6
'http://deb.debian.org/debian/pool/main/p/python-idna/python-idna_2.10-1%2bdeb11u1.debian.tar.xz' python-idna_2.10-1+deb11u1.debian.tar.xz 8552 SHA256:65fe25d1abe8edfa9bbe8aa84117c013a4734c5ae3c012f1a8b89d59ac231e33
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-idna/2.10-1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/python-idna/2.10-1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-idna/2.10-1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-ldap=3.2.0-4`

Binary Packages:

- `python3-ldap:amd64=3.2.0-4+b3`
- `python3-pyldap:amd64=3.2.0-4+b3`

Licenses: (parsed from: `/usr/share/doc/python3-ldap/copyright`, `/usr/share/doc/python3-pyldap/copyright`)

- `GPL-2`
- `GPL-2+`
- `Python`

Source:

```console
$ apt-get source -qq --print-uris python-ldap=3.2.0-4
'http://deb.debian.org/debian/pool/main/p/python-ldap/python-ldap_3.2.0-4.dsc' python-ldap_3.2.0-4.dsc 2247 SHA256:30680f0a1ee4234d0e3310eaf111508a37bfd363839f60250fb52bfa1977ad76
'http://deb.debian.org/debian/pool/main/p/python-ldap/python-ldap_3.2.0.orig.tar.gz' python-ldap_3.2.0.orig.tar.gz 367645 SHA256:7d1c4b15375a533564aad3d3deade789221e450052b21ebb9720fb822eccdb8e
'http://deb.debian.org/debian/pool/main/p/python-ldap/python-ldap_3.2.0-4.debian.tar.xz' python-ldap_3.2.0-4.debian.tar.xz 8128 SHA256:692b78628383f9d78f2ba94492a71f4b3b9346279736cef0613de6354d6366bf
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-ldap/3.2.0-4/ (for browsing the source)
- https://sources.debian.net/src/python-ldap/3.2.0-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-ldap/3.2.0-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-magic=2:0.4.20-3`

Binary Packages:

- `python3-magic=2:0.4.20-3`

Licenses: (parsed from: `/usr/share/doc/python3-magic/copyright`)

- `BSD-2-Clause-alike`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris python-magic=2:0.4.20-3
'http://deb.debian.org/debian/pool/main/p/python-magic/python-magic_0.4.20-3.dsc' python-magic_0.4.20-3.dsc 2005 SHA256:ec88ccdbd3bb9d500db14b16bc9befbf0664c2d9aea60479283c403c49a78d6f
'http://deb.debian.org/debian/pool/main/p/python-magic/python-magic_0.4.20.orig.tar.gz' python-magic_0.4.20.orig.tar.gz 863539 SHA256:9822826e6629305da894278c595d561bff3f6b87bd7542e4d3d081159406b229
'http://deb.debian.org/debian/pool/main/p/python-magic/python-magic_0.4.20-3.debian.tar.xz' python-magic_0.4.20-3.debian.tar.xz 3444 SHA256:4dc53ac610aad2458a137a76ad6f60a4cb8e9cde6c6cd734b89f1fc9206e1d5e
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-magic/2:0.4.20-3/ (for browsing the source)
- https://sources.debian.net/src/python-magic/2:0.4.20-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-magic/2:0.4.20-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-num2words=0.5.9-1`

Binary Packages:

- `python3-num2words=0.5.9-1`

Licenses: (parsed from: `/usr/share/doc/python3-num2words/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris python-num2words=0.5.9-1
'http://deb.debian.org/debian/pool/main/p/python-num2words/python-num2words_0.5.9-1.dsc' python-num2words_0.5.9-1.dsc 1799 SHA256:1b78c8afae0291cf778640ee5f774e83d1275438b4e0d6e21c9c2e016c061247
'http://deb.debian.org/debian/pool/main/p/python-num2words/python-num2words_0.5.9.orig.tar.gz' python-num2words_0.5.9.orig.tar.gz 106780 SHA256:812cc8d3f270ec84bab6c95e900a922e324236b7ad687bf6d262224cfb6ed028
'http://deb.debian.org/debian/pool/main/p/python-num2words/python-num2words_0.5.9-1.debian.tar.xz' python-num2words_0.5.9-1.debian.tar.xz 3492 SHA256:e4cf4e4774a0972b98427fb2e73226bb14409568eb08b38e6ad0c869e8f95452
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-num2words/0.5.9-1/ (for browsing the source)
- https://sources.debian.net/src/python-num2words/0.5.9-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-num2words/0.5.9-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-odf=1.4.1-1`

Binary Packages:

- `python3-odf=1.4.1-1`

Licenses: (parsed from: `/usr/share/doc/python3-odf/copyright`)

- `Apache-2`
- `Apache-2.0`
- `CC-BY-SA-3.0`
- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris python-odf=1.4.1-1
'http://deb.debian.org/debian/pool/main/p/python-odf/python-odf_1.4.1-1.dsc' python-odf_1.4.1-1.dsc 2248 SHA256:6fd9cd497e309f25c1037c815373fa54be43a0f16fc810953d9f70204d2543b3
'http://deb.debian.org/debian/pool/main/p/python-odf/python-odf_1.4.1.orig.tar.gz' python-odf_1.4.1.orig.tar.gz 10064589 SHA256:9f97e4c808f656ce22739eec43a7c1741f645b7decef37d4fb048edb33e8caad
'http://deb.debian.org/debian/pool/main/p/python-odf/python-odf_1.4.1-1.debian.tar.xz' python-odf_1.4.1-1.debian.tar.xz 15476 SHA256:5dc844815254e418ba7cc08f7acb812b68c82c7f89b089d51808e2ef9c5c8399
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-odf/1.4.1-1/ (for browsing the source)
- https://sources.debian.net/src/python-odf/1.4.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-odf/1.4.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-ofxparse=0.19-2`

Binary Packages:

- `python3-ofxparse=0.19-2`

Licenses: (parsed from: `/usr/share/doc/python3-ofxparse/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris python-ofxparse=0.19-2
'http://deb.debian.org/debian/pool/main/p/python-ofxparse/python-ofxparse_0.19-2.dsc' python-ofxparse_0.19-2.dsc 1977 SHA256:3cd9339e0d0ef69a1a4b21b738e0159b6caf6d7c9e9be14fc4a52b7c05b5842a
'http://deb.debian.org/debian/pool/main/p/python-ofxparse/python-ofxparse_0.19.orig.tar.gz' python-ofxparse_0.19.orig.tar.gz 54140 SHA256:d8c81fd5089332106da1a2e8919c412c7c677f08af04d557ca767701a04e0918
'http://deb.debian.org/debian/pool/main/p/python-ofxparse/python-ofxparse_0.19-2.debian.tar.xz' python-ofxparse_0.19-2.debian.tar.xz 2468 SHA256:5535e22f7384d5f41445125ec0af93bb32f163edaeba6394f44219d4bff723f7
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-ofxparse/0.19-2/ (for browsing the source)
- https://sources.debian.net/src/python-ofxparse/0.19-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-ofxparse/0.19-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-passlib=1.7.4-1`

Binary Packages:

- `python3-passlib=1.7.4-1`

Licenses: (parsed from: `/usr/share/doc/python3-passlib/copyright`)

- `Aki-Yoshida`
- `BEER-WARE`
- `BSD-3-Clause`
- `Damien-Miller`

Source:

```console
$ apt-get source -qq --print-uris python-passlib=1.7.4-1
'http://deb.debian.org/debian/pool/main/p/python-passlib/python-passlib_1.7.4-1.dsc' python-passlib_1.7.4-1.dsc 2031 SHA256:f7fccde35109f02a1c33b218ba1406a7a5a57a9c16860043ef5bbd0d0bf36a5f
'http://deb.debian.org/debian/pool/main/p/python-passlib/python-passlib_1.7.4.orig.tar.xz' python-passlib_1.7.4.orig.tar.xz 532384 SHA256:83e253fa2925b4247c92d0c7632a069777d16136c7664d0e022f77ce9bda7ef5
'http://deb.debian.org/debian/pool/main/p/python-passlib/python-passlib_1.7.4-1.debian.tar.xz' python-passlib_1.7.4-1.debian.tar.xz 13888 SHA256:e9fc93954f178e317dfa15deb0ee9c38e1a1bdc8c4927f183eb4b2e084066640
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-passlib/1.7.4-1/ (for browsing the source)
- https://sources.debian.net/src/python-passlib/1.7.4-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-passlib/1.7.4-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-phonenumbers=8.12.1-1`

Binary Packages:

- `python3-phonenumbers=8.12.1-1`

Licenses: (parsed from: `/usr/share/doc/python3-phonenumbers/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris python-phonenumbers=8.12.1-1
'http://deb.debian.org/debian/pool/main/p/python-phonenumbers/python-phonenumbers_8.12.1-1.dsc' python-phonenumbers_8.12.1-1.dsc 1959 SHA256:fc5cd88f2cedf745e68acf4750f407359faa4c0eb2b049253ee9a489583138fd
'http://deb.debian.org/debian/pool/main/p/python-phonenumbers/python-phonenumbers_8.12.1.orig.tar.gz' python-phonenumbers_8.12.1.orig.tar.gz 4864316 SHA256:6e0beda75e3ec4ff86d78ebe7cd5ecc4abd9fb3cc68a74405d2eae1f805cd3b0
'http://deb.debian.org/debian/pool/main/p/python-phonenumbers/python-phonenumbers_8.12.1-1.debian.tar.xz' python-phonenumbers_8.12.1-1.debian.tar.xz 2224 SHA256:0170b3aba199ae62dfb6396810aec80bd279e4ae687ab77551c64d2bce3def21
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-phonenumbers/8.12.1-1/ (for browsing the source)
- https://sources.debian.net/src/python-phonenumbers/8.12.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-phonenumbers/8.12.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-pip=20.3.4-4+deb11u1`

Binary Packages:

- `python-pip-whl=20.3.4-4+deb11u1`
- `python3-pip=20.3.4-4+deb11u1`

Licenses: (parsed from: `/usr/share/doc/python-pip-whl/copyright`, `/usr/share/doc/python3-pip/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris python-pip=20.3.4-4+deb11u1
'http://deb.debian.org/debian/pool/main/p/python-pip/python-pip_20.3.4-4%2bdeb11u1.dsc' python-pip_20.3.4-4+deb11u1.dsc 2438 SHA256:b115ed01a38fccdbcfd950c48e03ab3b7aff43c9093dc55c89313f3f7181b7b5
'http://deb.debian.org/debian/pool/main/p/python-pip/python-pip_20.3.4.orig.tar.gz' python-pip_20.3.4.orig.tar.gz 1530646 SHA256:6773934e5f5fc3eaa8c5a44949b5b924fc122daa0a8aa9f80c835b4ca2a543fc
'http://deb.debian.org/debian/pool/main/p/python-pip/python-pip_20.3.4-4%2bdeb11u1.debian.tar.xz' python-pip_20.3.4-4+deb11u1.debian.tar.xz 22680 SHA256:acfe53ee6f3e9b7a6bce5c5a86811ee8f2ee42b42afd17c02f10c8fccd3d8158
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-pip/20.3.4-4+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/python-pip/20.3.4-4+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-pip/20.3.4-4+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-psutil=5.8.0-1`

Binary Packages:

- `python3-psutil=5.8.0-1`

Licenses: (parsed from: `/usr/share/doc/python3-psutil/copyright`)

- `BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris python-psutil=5.8.0-1
'http://deb.debian.org/debian/pool/main/p/python-psutil/python-psutil_5.8.0-1.dsc' python-psutil_5.8.0-1.dsc 2275 SHA256:9595ad2ec22a28ead2ed8d12b34134aeda5efde034fa83f3e96af6dede12a168
'http://deb.debian.org/debian/pool/main/p/python-psutil/python-psutil_5.8.0.orig.tar.xz' python-psutil_5.8.0.orig.tar.xz 328816 SHA256:25476783a3dc3382238744d11ff2f16dd8a77c8679c6ad8e95a9dc3056c234ac
'http://deb.debian.org/debian/pool/main/p/python-psutil/python-psutil_5.8.0-1.debian.tar.xz' python-psutil_5.8.0-1.debian.tar.xz 6352 SHA256:d14ff91d07d6614e6b0a565550d9e8be6fcfccc88043d323fc9515a4df833e5e
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-psutil/5.8.0-1/ (for browsing the source)
- https://sources.debian.net/src/python-psutil/5.8.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-psutil/5.8.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-pyasn1-modules=0.2.1-1`

Binary Packages:

- `python3-pyasn1-modules=0.2.1-1`

Licenses: (parsed from: `/usr/share/doc/python3-pyasn1-modules/copyright`)

- `BSD-2-Clause`
- `BSD-3-Clause`

Source:

```console
$ apt-get source -qq --print-uris python-pyasn1-modules=0.2.1-1
'http://deb.debian.org/debian/pool/main/p/python-pyasn1-modules/python-pyasn1-modules_0.2.1-1.dsc' python-pyasn1-modules_0.2.1-1.dsc 2140 SHA256:8b41d7804ffa5f10f028191a36688546b45f2f778c14373f9f0f9523e279ae29
'http://deb.debian.org/debian/pool/main/p/python-pyasn1-modules/python-pyasn1-modules_0.2.1.orig.tar.gz' python-pyasn1-modules_0.2.1.orig.tar.gz 65808 SHA256:af00ea8f2022b6287dc375b2c70f31ab5af83989fc6fe9eacd4976ce26cd7ccc
'http://deb.debian.org/debian/pool/main/p/python-pyasn1-modules/python-pyasn1-modules_0.2.1-1.debian.tar.xz' python-pyasn1-modules_0.2.1-1.debian.tar.xz 2336 SHA256:125f24b843190c9dabbeb8b024b430580e06b631ae033762b3bc0d286c16d04b
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-pyasn1-modules/0.2.1-1/ (for browsing the source)
- https://sources.debian.net/src/python-pyasn1-modules/0.2.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-pyasn1-modules/0.2.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-qrcode=6.1-2`

Binary Packages:

- `python3-qrcode=6.1-2`

Licenses: (parsed from: `/usr/share/doc/python3-qrcode/copyright`)

- `BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris python-qrcode=6.1-2
'http://deb.debian.org/debian/pool/main/p/python-qrcode/python-qrcode_6.1-2.dsc' python-qrcode_6.1-2.dsc 2152 SHA256:d7905aa9e670a77be48cf4385585b7bd373c30ae65068a6eb7a4efdcbc84e85e
'http://deb.debian.org/debian/pool/main/p/python-qrcode/python-qrcode_6.1.orig.tar.gz' python-qrcode_6.1.orig.tar.gz 29363 SHA256:505253854f607f2abf4d16092c61d4e9d511a3b4392e60bff957a68592b04369
'http://deb.debian.org/debian/pool/main/p/python-qrcode/python-qrcode_6.1-2.debian.tar.xz' python-qrcode_6.1-2.debian.tar.xz 6216 SHA256:a132284cb5026fc5c607c810c5bc5c9b05b38d8ed92cd7b0cbab841753e22e03
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-qrcode/6.1-2/ (for browsing the source)
- https://sources.debian.net/src/python-qrcode/6.1-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-qrcode/6.1-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-reportlab=3.5.59-2+deb11u1`

Binary Packages:

- `python3-renderpm:amd64=3.5.59-2+deb11u1`
- `python3-reportlab=3.5.59-2+deb11u1`
- `python3-reportlab-accel:amd64=3.5.59-2+deb11u1`

Licenses: (parsed from: `/usr/share/doc/python3-renderpm/copyright`, `/usr/share/doc/python3-reportlab/copyright`, `/usr/share/doc/python3-reportlab-accel/copyright`)

- `GPL`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris python-reportlab=3.5.59-2+deb11u1
'http://deb.debian.org/debian-security/pool/updates/main/p/python-reportlab/python-reportlab_3.5.59-2%2bdeb11u1.dsc' python-reportlab_3.5.59-2+deb11u1.dsc 2374 SHA256:767be70276153a3e3435d6101f9d5e6d6655853505b020065de2a1dbc1b01a45
'http://deb.debian.org/debian-security/pool/updates/main/p/python-reportlab/python-reportlab_3.5.59.orig.tar.gz' python-reportlab_3.5.59.orig.tar.gz 2904089 SHA256:a755cca2dcf023130b03bb671670301a992157d5c3151d838c0b68ef89894536
'http://deb.debian.org/debian-security/pool/updates/main/p/python-reportlab/python-reportlab_3.5.59-2%2bdeb11u1.debian.tar.xz' python-reportlab_3.5.59-2+deb11u1.debian.tar.xz 17728 SHA256:8b9b6cd3e0420b8e347001bff2fef31dd5e9d5b1064fb10f1e43baae2cbfe1fe
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-reportlab/3.5.59-2+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/python-reportlab/3.5.59-2+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-reportlab/3.5.59-2+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-requests-toolbelt=0.9.1-1`

Binary Packages:

- `python3-requests-toolbelt=0.9.1-1`

Licenses: (parsed from: `/usr/share/doc/python3-requests-toolbelt/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris python-requests-toolbelt=0.9.1-1
'http://deb.debian.org/debian/pool/main/p/python-requests-toolbelt/python-requests-toolbelt_0.9.1-1.dsc' python-requests-toolbelt_0.9.1-1.dsc 2384 SHA256:325f3208c79e905cc12b0266cb2ed76e525fecb29d4228714ce24823eab5a27d
'http://deb.debian.org/debian/pool/main/p/python-requests-toolbelt/python-requests-toolbelt_0.9.1.orig.tar.gz' python-requests-toolbelt_0.9.1.orig.tar.gz 207286 SHA256:968089d4584ad4ad7c171454f0a5c6dac23971e9472521ea3b6d49d610aa6fc0
'http://deb.debian.org/debian/pool/main/p/python-requests-toolbelt/python-requests-toolbelt_0.9.1-1.debian.tar.xz' python-requests-toolbelt_0.9.1-1.debian.tar.xz 3412 SHA256:e0c1545d21d38d75147286b26fd55dabcb514a4d77a47d4a207b2caff7062fa1
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-requests-toolbelt/0.9.1-1/ (for browsing the source)
- https://sources.debian.net/src/python-requests-toolbelt/0.9.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-requests-toolbelt/0.9.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-roman=2.0.0-5`

Binary Packages:

- `python3-roman=2.0.0-5`

Licenses: (parsed from: `/usr/share/doc/python3-roman/copyright`)

- `Python-2.1.1`
- `ZPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris python-roman=2.0.0-5
'http://deb.debian.org/debian/pool/main/p/python-roman/python-roman_2.0.0-5.dsc' python-roman_2.0.0-5.dsc 2109 SHA256:e2cc82ff4a358fe4733a51d0c9084387786a7fb7bd72451c08cd3b56ce085645
'http://deb.debian.org/debian/pool/main/p/python-roman/python-roman_2.0.0.orig.tar.gz' python-roman_2.0.0.orig.tar.gz 4968 SHA256:98f2c0fb3cdcfba465d12c85b3b7139fc4cd2177f1325f1bacfe00878c8fa7b9
'http://deb.debian.org/debian/pool/main/p/python-roman/python-roman_2.0.0-5.debian.tar.xz' python-roman_2.0.0-5.debian.tar.xz 8616 SHA256:8369b1ae2c7b65c5093f9a29f4069b235760bd69ceffb6e85ed602612e93872a
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-roman/2.0.0-5/ (for browsing the source)
- https://sources.debian.net/src/python-roman/2.0.0-5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-roman/2.0.0-5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-slugify=4.0.0-1`

Binary Packages:

- `python3-slugify=4.0.0-1`

Licenses: (parsed from: `/usr/share/doc/python3-slugify/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris python-slugify=4.0.0-1
'http://deb.debian.org/debian/pool/main/p/python-slugify/python-slugify_4.0.0-1.dsc' python-slugify_4.0.0-1.dsc 2000 SHA256:d2fa8a065a965473ea0f65f5a5f0b66bb4004615c6caa798293784f7e87b4be4
'http://deb.debian.org/debian/pool/main/p/python-slugify/python-slugify_4.0.0.orig.tar.gz' python-slugify_4.0.0.orig.tar.gz 9260 SHA256:2deffc0cb1d291ac657bad71bc46aaadb24bd4e8fbe8e200af98be235d89595c
'http://deb.debian.org/debian/pool/main/p/python-slugify/python-slugify_4.0.0-1.debian.tar.xz' python-slugify_4.0.0-1.debian.tar.xz 3284 SHA256:0766becffa3e21bba0603a30d9829c7ff959e80343883f5520d434954cae0b9f
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-slugify/4.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/python-slugify/4.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-slugify/4.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-stdnum=1.16-1+deb11u1`

Binary Packages:

- `python3-stdnum=1.16-1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/python3-stdnum/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris python-stdnum=1.16-1+deb11u1
'http://deb.debian.org/debian/pool/main/p/python-stdnum/python-stdnum_1.16-1%2bdeb11u1.dsc' python-stdnum_1.16-1+deb11u1.dsc 2103 SHA256:110d2bbe08c83108f79de127d749baea45080e18914edea1ad7ff11369ca3aa1
'http://deb.debian.org/debian/pool/main/p/python-stdnum/python-stdnum_1.16.orig.tar.gz' python-stdnum_1.16.orig.tar.gz 1039599 SHA256:4248d898042a801fc4eff96fbfe4bf63a43324854efe3b5534718c1c195c6f43
'http://deb.debian.org/debian/pool/main/p/python-stdnum/python-stdnum_1.16.orig.tar.gz.asc' python-stdnum_1.16.orig.tar.gz.asc 866 SHA256:a4ae9163f9610f85012c28bc99472c40394cff478b57e641bafb737f1fb18afd
'http://deb.debian.org/debian/pool/main/p/python-stdnum/python-stdnum_1.16-1%2bdeb11u1.debian.tar.xz' python-stdnum_1.16-1+deb11u1.debian.tar.xz 22472 SHA256:35fc76c0f89e2ffc28a1c5bdb8f8a6ddf03d16ee6f5bb8b08e626bb55bd38d70
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-stdnum/1.16-1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/python-stdnum/1.16-1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-stdnum/1.16-1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-tz=2021.1-1`

Binary Packages:

- `python3-tz=2021.1-1`

Licenses: (parsed from: `/usr/share/doc/python3-tz/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris python-tz=2021.1-1
'http://deb.debian.org/debian/pool/main/p/python-tz/python-tz_2021.1-1.dsc' python-tz_2021.1-1.dsc 2160 SHA256:58a7f063cc5489692651335684ffd4de69e2b56b7989181fb1d957f7ca5cfbfc
'http://deb.debian.org/debian/pool/main/p/python-tz/python-tz_2021.1.orig.tar.xz' python-tz_2021.1.orig.tar.xz 139604 SHA256:451fa7968d56950bb70a41809ae62395495e13b7ee94453dad1b9998193bf6f5
'http://deb.debian.org/debian/pool/main/p/python-tz/python-tz_2021.1-1.debian.tar.xz' python-tz_2021.1-1.debian.tar.xz 5820 SHA256:dac26180612948121039820cc5c2a915c4bd157d50c931c53b7aecea661d9243
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-tz/2021.1-1/ (for browsing the source)
- https://sources.debian.net/src/python-tz/2021.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-tz/2021.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-urllib3=1.26.5-1~exp1`

Binary Packages:

- `python3-urllib3=1.26.5-1~exp1`

Licenses: (parsed from: `/usr/share/doc/python3-urllib3/copyright`)

- `Expat`
- `PSF-2`

Source:

```console
$ apt-get source -qq --print-uris python-urllib3=1.26.5-1~exp1
'http://deb.debian.org/debian/pool/main/p/python-urllib3/python-urllib3_1.26.5-1%7eexp1.dsc' python-urllib3_1.26.5-1~exp1.dsc 2243 SHA256:39abf0f987b0addc16146995dffde5073af9c878018f0cad23a43f0eb74a0671
'http://deb.debian.org/debian/pool/main/p/python-urllib3/python-urllib3_1.26.5.orig.tar.gz' python-urllib3_1.26.5.orig.tar.gz 292865 SHA256:a7acd0977125325f516bda9735fa7142b909a8d01e8b2e4c8108d0984e6e0098
'http://deb.debian.org/debian/pool/main/p/python-urllib3/python-urllib3_1.26.5-1%7eexp1.debian.tar.xz' python-urllib3_1.26.5-1~exp1.debian.tar.xz 12164 SHA256:b986919e426bc0a2266345aecd30eb7eb209a709abaff0fc21b27a0338aaf360
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-urllib3/1.26.5-1~exp1/ (for browsing the source)
- https://sources.debian.net/src/python-urllib3/1.26.5-1~exp1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-urllib3/1.26.5-1~exp1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-vobject=0.9.6.1-0.2`

Binary Packages:

- `python3-vobject=0.9.6.1-0.2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris python-vobject=0.9.6.1-0.2
'http://deb.debian.org/debian/pool/main/p/python-vobject/python-vobject_0.9.6.1-0.2.dsc' python-vobject_0.9.6.1-0.2.dsc 2146 SHA256:c827897504e94dd908c89b5f408e234e234430c9570685eabc3c48ea31defe98
'http://deb.debian.org/debian/pool/main/p/python-vobject/python-vobject_0.9.6.1.orig.tar.gz' python-vobject_0.9.6.1.orig.tar.gz 216565 SHA256:5da057f292fe03065ac58ca0a0d4ca51ff719068a6a0e018bb539c285b13bd87
'http://deb.debian.org/debian/pool/main/p/python-vobject/python-vobject_0.9.6.1-0.2.debian.tar.xz' python-vobject_0.9.6.1-0.2.debian.tar.xz 6020 SHA256:c2f79fe6e41af42d12d7dc39e8d108d58c79074702fcbd35848e6b5e95123ea2
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-vobject/0.9.6.1-0.2/ (for browsing the source)
- https://sources.debian.net/src/python-vobject/0.9.6.1-0.2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-vobject/0.9.6.1-0.2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-watchdog=1.0.2-2`

Binary Packages:

- `python3-watchdog=1.0.2-2`

Licenses: (parsed from: `/usr/share/doc/python3-watchdog/copyright`)

- `Apache-2`
- `Apache-2.0`
- `BSD-3`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris python-watchdog=1.0.2-2
'http://deb.debian.org/debian/pool/main/p/python-watchdog/python-watchdog_1.0.2-2.dsc' python-watchdog_1.0.2-2.dsc 2275 SHA256:00bf4967092563ebd99aac3e45ce70b891ce0ac536ab66b10c28cd60dd781996
'http://deb.debian.org/debian/pool/main/p/python-watchdog/python-watchdog_1.0.2.orig.tar.gz' python-watchdog_1.0.2.orig.tar.gz 98483 SHA256:376cbc2a35c0392b0fe7ff16fbc1b303fd99d4dd9911ab5581ee9d69adc88982
'http://deb.debian.org/debian/pool/main/p/python-watchdog/python-watchdog_1.0.2-2.debian.tar.xz' python-watchdog_1.0.2-2.debian.tar.xz 4808 SHA256:b95f8d6491e9217dfc77b4499db04ee30a4ad9c943875a472b5644216dd46616
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-watchdog/1.0.2-2/ (for browsing the source)
- https://sources.debian.net/src/python-watchdog/1.0.2-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-watchdog/1.0.2-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-werkzeug=1.0.1+dfsg1-2+deb11u1`

Binary Packages:

- `python3-werkzeug=1.0.1+dfsg1-2+deb11u1`

Licenses: (parsed from: `/usr/share/doc/python3-werkzeug/copyright`)

- `BSD-3-clause`
- `GAP`

Source:

```console
$ apt-get source -qq --print-uris python-werkzeug=1.0.1+dfsg1-2+deb11u1
'http://deb.debian.org/debian/pool/main/p/python-werkzeug/python-werkzeug_1.0.1%2bdfsg1-2%2bdeb11u1.dsc' python-werkzeug_1.0.1+dfsg1-2+deb11u1.dsc 2632 SHA256:f37c7dceab0b6505e103cf57ce1b04539db4ede1f35484e0ad5d5bff7a699d09
'http://deb.debian.org/debian/pool/main/p/python-werkzeug/python-werkzeug_1.0.1%2bdfsg1.orig.tar.xz' python-werkzeug_1.0.1+dfsg1.orig.tar.xz 730032 SHA256:12432f3bd8abf78aa8d8f144d3088acdf6612c6984ad8ae812b34c2391f9bffa
'http://deb.debian.org/debian/pool/main/p/python-werkzeug/python-werkzeug_1.0.1%2bdfsg1-2%2bdeb11u1.debian.tar.xz' python-werkzeug_1.0.1+dfsg1-2+deb11u1.debian.tar.xz 10296 SHA256:e3e7e4c1b8eccc1c0da5381f2f9eeb5d978478220ae68a640b99d39c11b5c4c9
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-werkzeug/1.0.1+dfsg1-2+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/python-werkzeug/1.0.1+dfsg1-2+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-werkzeug/1.0.1+dfsg1-2+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-xlrd=1.2.0-2`

Binary Packages:

- `python3-xlrd=1.2.0-2`

Licenses: (parsed from: `/usr/share/doc/python3-xlrd/copyright`)

- `BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris python-xlrd=1.2.0-2
'http://deb.debian.org/debian/pool/main/p/python-xlrd/python-xlrd_1.2.0-2.dsc' python-xlrd_1.2.0-2.dsc 2143 SHA256:cb3489a6697cac03d919d20c6ad304ac31959aeab9413bccad95de21e70525e1
'http://deb.debian.org/debian/pool/main/p/python-xlrd/python-xlrd_1.2.0.orig.tar.gz' python-xlrd_1.2.0.orig.tar.gz 554079 SHA256:546eb36cee8db40c3eaa46c351e67ffee6eeb5fa2650b71bc4c758a29a1b29b2
'http://deb.debian.org/debian/pool/main/p/python-xlrd/python-xlrd_1.2.0-2.debian.tar.xz' python-xlrd_1.2.0-2.debian.tar.xz 7420 SHA256:4cce60cea03c274015235102930f216bd4f5c3952ece983647c167880f78efda
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-xlrd/1.2.0-2/ (for browsing the source)
- https://sources.debian.net/src/python-xlrd/1.2.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-xlrd/1.2.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python-zeep=4.0.0-1`

Binary Packages:

- `python3-zeep=4.0.0-1`

Licenses: (parsed from: `/usr/share/doc/python3-zeep/copyright`)

- `Apache`
- `BSD-3-clause`
- `Expat`
- `W3C`

Source:

```console
$ apt-get source -qq --print-uris python-zeep=4.0.0-1
'http://deb.debian.org/debian/pool/main/p/python-zeep/python-zeep_4.0.0-1.dsc' python-zeep_4.0.0-1.dsc 2760 SHA256:0a2ffc19cab8b7a1a5fdd95a3cac9ea866bf3bed7b1a088df4b4cc12df39ae85
'http://deb.debian.org/debian/pool/main/p/python-zeep/python-zeep_4.0.0.orig.tar.gz' python-zeep_4.0.0.orig.tar.gz 163646 SHA256:98158e43db33739d41502a1a7e3629dcb62dfd0864ea28c9d43f560a091cfe3f
'http://deb.debian.org/debian/pool/main/p/python-zeep/python-zeep_4.0.0.orig.tar.gz.asc' python-zeep_4.0.0.orig.tar.gz.asc 833 SHA256:2fe66cb1e4f62979ea06ace61d997c0cdd28afcd71ee1fb6095c06c562f5e3b9
'http://deb.debian.org/debian/pool/main/p/python-zeep/python-zeep_4.0.0-1.debian.tar.xz' python-zeep_4.0.0-1.debian.tar.xz 11764 SHA256:f8526802c204604d52878fc17c8274603003634fc3f3c6f874de534355d28a19
```

Other potentially useful URLs:

- https://sources.debian.net/src/python-zeep/4.0.0-1/ (for browsing the source)
- https://sources.debian.net/src/python-zeep/4.0.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python-zeep/4.0.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python3-defaults=3.9.2-3`

Binary Packages:

- `libpython3-stdlib:amd64=3.9.2-3`
- `python3=3.9.2-3`
- `python3-minimal=3.9.2-3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris python3-defaults=3.9.2-3
'http://deb.debian.org/debian/pool/main/p/python3-defaults/python3-defaults_3.9.2-3.dsc' python3-defaults_3.9.2-3.dsc 2879 SHA256:625d69b163c4ba751d717ccd4e4202f6c3132a4734f0d083ae11dea465cc7760
'http://deb.debian.org/debian/pool/main/p/python3-defaults/python3-defaults_3.9.2-3.tar.gz' python3-defaults_3.9.2-3.tar.gz 140929 SHA256:64a82311e46c734a897e408cad11d17e5631ec3ec889ae90948111150e8f18ce
```

Other potentially useful URLs:

- https://sources.debian.net/src/python3-defaults/3.9.2-3/ (for browsing the source)
- https://sources.debian.net/src/python3-defaults/3.9.2-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python3-defaults/3.9.2-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python3-stdlib-extensions=3.9.2-1`

Binary Packages:

- `python3-distutils=3.9.2-1`
- `python3-lib2to3=3.9.2-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris python3-stdlib-extensions=3.9.2-1
'http://deb.debian.org/debian/pool/main/p/python3-stdlib-extensions/python3-stdlib-extensions_3.9.2-1.dsc' python3-stdlib-extensions_3.9.2-1.dsc 2450 SHA256:bc55bb6577ada0315f267035d658b8aeeb78f6089987418a75156f7e10ebf8c8
'http://deb.debian.org/debian/pool/main/p/python3-stdlib-extensions/python3-stdlib-extensions_3.9.2.orig.tar.xz' python3-stdlib-extensions_3.9.2.orig.tar.xz 1103424 SHA256:4c77b2e3f2d9518767f2bf0b58bfafd7560fdd4aebc162a642d7a7af748f9d07
'http://deb.debian.org/debian/pool/main/p/python3-stdlib-extensions/python3-stdlib-extensions_3.9.2-1.debian.tar.xz' python3-stdlib-extensions_3.9.2-1.debian.tar.xz 18832 SHA256:46c8a5f71adde687b71a0aa39177d74cc355255f40121e64a30a7dc30c4e3ce5
```

Other potentially useful URLs:

- https://sources.debian.net/src/python3-stdlib-extensions/3.9.2-1/ (for browsing the source)
- https://sources.debian.net/src/python3-stdlib-extensions/3.9.2-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python3-stdlib-extensions/3.9.2-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python3.9=3.9.2-1`

Binary Packages:

- `libpython3.9-minimal:amd64=3.9.2-1`
- `libpython3.9-stdlib:amd64=3.9.2-1`
- `python3.9=3.9.2-1`
- `python3.9-minimal=3.9.2-1`

Licenses: (parsed from: `/usr/share/doc/libpython3.9-minimal/copyright`, `/usr/share/doc/libpython3.9-stdlib/copyright`, `/usr/share/doc/python3.9/copyright`, `/usr/share/doc/python3.9-minimal/copyright`)

- `* Permission to use this software in any way is granted without`
- `By obtaining, using, and/or copying this software and/or its`
- `GPL-2`
- `Permission  is  hereby granted,  free  of charge,  to  any person`
- `Permission is hereby granted, free of charge, to any person obtaining`
- `Permission to use, copy, modify,`
- `Redistribution`
- `This software is provided 'as-is', without any express`
- `This software is provided as-is, without express`
- `binary forms, with`
- `distribute this software`
- `distribute this software and`
- `distribute this software for any`
- `implied`
- `its`
- `use in source`
- `without`

Source:

```console
$ apt-get source -qq --print-uris python3.9=3.9.2-1
'http://deb.debian.org/debian/pool/main/p/python3.9/python3.9_3.9.2-1.dsc' python3.9_3.9.2-1.dsc 3493 SHA256:63bc63b864067e7f993be8bc9bf2a08363fde05895bea86961fc5d781e42b68b
'http://deb.debian.org/debian/pool/main/p/python3.9/python3.9_3.9.2.orig.tar.xz' python3.9_3.9.2.orig.tar.xz 18889164 SHA256:3c2034c54f811448f516668dce09d24008a0716c3a794dd8639b5388cbde247d
'http://deb.debian.org/debian/pool/main/p/python3.9/python3.9_3.9.2-1.debian.tar.xz' python3.9_3.9.2-1.debian.tar.xz 211484 SHA256:b8b9e1710ca5dc5b0f0d9734494024ea11f560e36c34eb9191ccb0605798a490
```

Other potentially useful URLs:

- https://sources.debian.net/src/python3.9/3.9.2-1/ (for browsing the source)
- https://sources.debian.net/src/python3.9/3.9.2-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python3.9/3.9.2-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pyusb=1.0.2-2`

Binary Packages:

- `python3-usb=1.0.2-2`

Licenses: (parsed from: `/usr/share/doc/python3-usb/copyright`)

- `BSD-3`

Source:

```console
$ apt-get source -qq --print-uris pyusb=1.0.2-2
'http://deb.debian.org/debian/pool/main/p/pyusb/pyusb_1.0.2-2.dsc' pyusb_1.0.2-2.dsc 1955 SHA256:913f9d7a5ba947cd65a1a0f285b85f3421bdacfbdcc3e524e6327bd4fad24d61
'http://deb.debian.org/debian/pool/main/p/pyusb/pyusb_1.0.2.orig.tar.gz' pyusb_1.0.2.orig.tar.gz 68690 SHA256:c9fb4572059e4af0580c4bbc406f98fd4428f6b47ecc714314080811c35d9d98
'http://deb.debian.org/debian/pool/main/p/pyusb/pyusb_1.0.2-2.debian.tar.xz' pyusb_1.0.2-2.debian.tar.xz 4876 SHA256:4071860ff464be25889a798f405f5a11ed5cfe898086eb93ebb56b6798e9c749
```

Other potentially useful URLs:

- https://sources.debian.net/src/pyusb/1.0.2-2/ (for browsing the source)
- https://sources.debian.net/src/pyusb/1.0.2-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pyusb/1.0.2-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pyyaml=5.3.1-5`

Binary Packages:

- `python3-yaml=5.3.1-5`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris pyyaml=5.3.1-5
'http://deb.debian.org/debian/pool/main/p/pyyaml/pyyaml_5.3.1-5.dsc' pyyaml_5.3.1-5.dsc 1542 SHA256:bc99bf2138e594faca3a28d2602077fb0fbc3d159a69ce4dbb61fe370baeb662
'http://deb.debian.org/debian/pool/main/p/pyyaml/pyyaml_5.3.1.orig.tar.gz' pyyaml_5.3.1.orig.tar.gz 269377 SHA256:b8eac752c5e14d3eca0e6dd9199cd627518cb5ec06add0de9d32baeee6fe645d
'http://deb.debian.org/debian/pool/main/p/pyyaml/pyyaml_5.3.1-5.debian.tar.xz' pyyaml_5.3.1-5.debian.tar.xz 8012 SHA256:25e4599c3a178310b1badca84442cf388178ce3cc5b53228b2fe62645c829e07
```

Other potentially useful URLs:

- https://sources.debian.net/src/pyyaml/5.3.1-5/ (for browsing the source)
- https://sources.debian.net/src/pyyaml/5.3.1-5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pyyaml/5.3.1-5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `readline=8.1-1`

Binary Packages:

- `libreadline8:amd64=8.1-1`
- `readline-common=8.1-1`

Licenses: (parsed from: `/usr/share/doc/libreadline8/copyright`, `/usr/share/doc/readline-common/copyright`)

- `GFDL`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris readline=8.1-1
'http://deb.debian.org/debian/pool/main/r/readline/readline_8.1-1.dsc' readline_8.1-1.dsc 2418 SHA256:53356fdf2ee122ab75c7b535d292385311f7dea425ccc42143d2b9a2accfc657
'http://deb.debian.org/debian/pool/main/r/readline/readline_8.1.orig.tar.gz' readline_8.1.orig.tar.gz 2993288 SHA256:f8ceb4ee131e3232226a17f51b164afc46cd0b9e6cef344be87c65962cb82b02
'http://deb.debian.org/debian/pool/main/r/readline/readline_8.1-1.debian.tar.xz' readline_8.1-1.debian.tar.xz 29220 SHA256:852267a95aeec23b267c838469fee346e83a29e7a08071178dc87682591cffbf
```

Other potentially useful URLs:

- https://sources.debian.net/src/readline/8.1-1/ (for browsing the source)
- https://sources.debian.net/src/readline/8.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/readline/8.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `requests-file=1.5.1-1`

Binary Packages:

- `python3-requests-file=1.5.1-1`

Licenses: (parsed from: `/usr/share/doc/python3-requests-file/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris requests-file=1.5.1-1
'http://deb.debian.org/debian/pool/main/r/requests-file/requests-file_1.5.1-1.dsc' requests-file_1.5.1-1.dsc 1636 SHA256:5a83e8cfc5845e40b2480edde8895a4229fa40207574518e0eb80d33b07dde9d
'http://deb.debian.org/debian/pool/main/r/requests-file/requests-file_1.5.1.orig.tar.gz' requests-file_1.5.1.orig.tar.gz 5994 SHA256:a9b0a80675727f320cd5c71d6eb70cc3969b468dc27896a893148c0f6b424446
'http://deb.debian.org/debian/pool/main/r/requests-file/requests-file_1.5.1-1.debian.tar.xz' requests-file_1.5.1-1.debian.tar.xz 3648 SHA256:a71fb419d4fb1580e1f4f9ed351aaec3a6256a0ec77121980e26e475dac87470
```

Other potentially useful URLs:

- https://sources.debian.net/src/requests-file/1.5.1-1/ (for browsing the source)
- https://sources.debian.net/src/requests-file/1.5.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/requests-file/1.5.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `requests=2.25.1+dfsg-2`

Binary Packages:

- `python3-requests=2.25.1+dfsg-2`

Licenses: (parsed from: `/usr/share/doc/python3-requests/copyright`)

- `Apache`
- `Apache-2.0`
- `other`

Source:

```console
$ apt-get source -qq --print-uris requests=2.25.1+dfsg-2
'http://deb.debian.org/debian/pool/main/r/requests/requests_2.25.1%2bdfsg-2.dsc' requests_2.25.1+dfsg-2.dsc 2256 SHA256:79dae78aa9824bdbd54eca1109e660117b75142cda0f677a9f701e842bc60367
'http://deb.debian.org/debian/pool/main/r/requests/requests_2.25.1%2bdfsg.orig.tar.xz' requests_2.25.1+dfsg.orig.tar.xz 127452 SHA256:73a9988731018065ba04524c71f49d4604ae1a61b90d93bf610315329938cc98
'http://deb.debian.org/debian/pool/main/r/requests/requests_2.25.1%2bdfsg-2.debian.tar.xz' requests_2.25.1+dfsg-2.debian.tar.xz 10840 SHA256:1a467eb5a90f8acc25225f796bf022e2c0c6c0da4df3af3d82afed8a441aad39
```

Other potentially useful URLs:

- https://sources.debian.net/src/requests/2.25.1+dfsg-2/ (for browsing the source)
- https://sources.debian.net/src/requests/2.25.1+dfsg-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/requests/2.25.1+dfsg-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `rtmpdump=2.4+20151223.gitfa8646d.1-2`

Binary Packages:

- `librtmp1:amd64=2.4+20151223.gitfa8646d.1-2+b2`

Licenses: (parsed from: `/usr/share/doc/librtmp1/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris rtmpdump=2.4+20151223.gitfa8646d.1-2
'http://deb.debian.org/debian/pool/main/r/rtmpdump/rtmpdump_2.4%2b20151223.gitfa8646d.1-2.dsc' rtmpdump_2.4+20151223.gitfa8646d.1-2.dsc 2299 SHA256:a296819cd2ab5880b67ad963ef0867cb10e462f4403e52565aa863eb05bb1370
'http://deb.debian.org/debian/pool/main/r/rtmpdump/rtmpdump_2.4%2b20151223.gitfa8646d.1.orig.tar.gz' rtmpdump_2.4+20151223.gitfa8646d.1.orig.tar.gz 142213 SHA256:5c032f5c8cc2937eb55a81a94effdfed3b0a0304b6376147b86f951e225e3ab5
'http://deb.debian.org/debian/pool/main/r/rtmpdump/rtmpdump_2.4%2b20151223.gitfa8646d.1-2.debian.tar.xz' rtmpdump_2.4+20151223.gitfa8646d.1-2.debian.tar.xz 8096 SHA256:26d47de07d16285e4ca55b0828cbbf1ba35e671f9b3500a87e301fe755d26882
```

Other potentially useful URLs:

- https://sources.debian.net/src/rtmpdump/2.4+20151223.gitfa8646d.1-2/ (for browsing the source)
- https://sources.debian.net/src/rtmpdump/2.4+20151223.gitfa8646d.1-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/rtmpdump/2.4+20151223.gitfa8646d.1-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `sed=4.7-1`

Binary Packages:

- `sed=4.7-1`

Licenses: (parsed from: `/usr/share/doc/sed/copyright`)

- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris sed=4.7-1
'http://deb.debian.org/debian/pool/main/s/sed/sed_4.7-1.dsc' sed_4.7-1.dsc 1880 SHA256:dd0e8daed987929920f7729771f9c7a5b48d094923aaf686efd2ab19db776108
'http://deb.debian.org/debian/pool/main/s/sed/sed_4.7.orig.tar.xz' sed_4.7.orig.tar.xz 1298316 SHA256:2885768cd0a29ff8d58a6280a270ff161f6a3deb5690b2be6c49f46d4c67bd6a
'http://deb.debian.org/debian/pool/main/s/sed/sed_4.7-1.debian.tar.xz' sed_4.7-1.debian.tar.xz 59824 SHA256:a2ab8d50807fd2242f86d6c6257399e790445ab6f8932f7f487d34361b4fc483
```

Other potentially useful URLs:

- https://sources.debian.net/src/sed/4.7-1/ (for browsing the source)
- https://sources.debian.net/src/sed/4.7-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/sed/4.7-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `sensible-utils=0.0.14`

Binary Packages:

- `sensible-utils=0.0.14`

Licenses: (parsed from: `/usr/share/doc/sensible-utils/copyright`)

- `All-permissive`
- `GPL-2`
- `GPL-2+`
- `configure`
- `installsh`

Source:

```console
$ apt-get source -qq --print-uris sensible-utils=0.0.14
'http://deb.debian.org/debian/pool/main/s/sensible-utils/sensible-utils_0.0.14.dsc' sensible-utils_0.0.14.dsc 1702 SHA256:002f637ca92db8bab28048cbab10d6509508508806e2005f4dc6ba3ca505a6d8
'http://deb.debian.org/debian/pool/main/s/sensible-utils/sensible-utils_0.0.14.tar.xz' sensible-utils_0.0.14.tar.xz 64448 SHA256:a6ee528bf4122d77acacdb97f20cd0434a12ad3ecd119186a5fcee066844c644
```

Other potentially useful URLs:

- https://sources.debian.net/src/sensible-utils/0.0.14/ (for browsing the source)
- https://sources.debian.net/src/sensible-utils/0.0.14/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/sensible-utils/0.0.14/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `setuptools=52.0.0-4+deb11u1`

Binary Packages:

- `python3-pkg-resources=52.0.0-4+deb11u1`
- `python3-setuptools=52.0.0-4+deb11u1`

Licenses: (parsed from: `/usr/share/doc/python3-pkg-resources/copyright`, `/usr/share/doc/python3-setuptools/copyright`)

- `Apache-2.0`
- `BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris setuptools=52.0.0-4+deb11u1
'http://deb.debian.org/debian-security/pool/updates/main/s/setuptools/setuptools_52.0.0-4%2bdeb11u1.dsc' setuptools_52.0.0-4+deb11u1.dsc 2085 SHA256:0d22bab041b1aa9b0ffd60a3133c9e6dd5996e42c9c7c111da6141f71b4f7a88
'http://deb.debian.org/debian-security/pool/updates/main/s/setuptools/setuptools_52.0.0.orig.tar.gz' setuptools_52.0.0.orig.tar.gz 2051850 SHA256:fb3a1ee622509550dbf1d419f241296169d7f09cb1eb5b1736f2f10965932b96
'http://deb.debian.org/debian-security/pool/updates/main/s/setuptools/setuptools_52.0.0-4%2bdeb11u1.debian.tar.xz' setuptools_52.0.0-4+deb11u1.debian.tar.xz 16820 SHA256:b462793147855ad0bb3ee62b853c8d8c21305f8b576d0edd83ac6c621fcccfda
```

Other potentially useful URLs:

- https://sources.debian.net/src/setuptools/52.0.0-4+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/setuptools/52.0.0-4+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/setuptools/52.0.0-4+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `sgml-base=1.30`

Binary Packages:

- `sgml-base=1.30`

Licenses: (parsed from: `/usr/share/doc/sgml-base/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris sgml-base=1.30
'http://deb.debian.org/debian/pool/main/s/sgml-base/sgml-base_1.30.dsc' sgml-base_1.30.dsc 1541 SHA256:4bb8cb33a49a14ad50642f93930f26f8aef039350a847640487cb9a596b1e103
'http://deb.debian.org/debian/pool/main/s/sgml-base/sgml-base_1.30.tar.xz' sgml-base_1.30.tar.xz 12536 SHA256:a125fadaeac4c15580ff278e24b807e8cbae4c5d220aed9568518cc1f115d082
```

Other potentially useful URLs:

- https://sources.debian.net/src/sgml-base/1.30/ (for browsing the source)
- https://sources.debian.net/src/sgml-base/1.30/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/sgml-base/1.30/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `shadow=1:4.8.1-1`

Binary Packages:

- `login=1:4.8.1-1`
- `passwd=1:4.8.1-1`

Licenses: (parsed from: `/usr/share/doc/login/copyright`, `/usr/share/doc/passwd/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris shadow=1:4.8.1-1
'http://deb.debian.org/debian/pool/main/s/shadow/shadow_4.8.1-1.dsc' shadow_4.8.1-1.dsc 2215 SHA256:5c9568dc183781ba654b7daeba6d5d6768d4e0417cc8d8b6f2e534dae6fcdaa6
'http://deb.debian.org/debian/pool/main/s/shadow/shadow_4.8.1.orig.tar.xz' shadow_4.8.1.orig.tar.xz 1611196 SHA256:a3ad4630bdc41372f02a647278a8c3514844295d36eefe68ece6c3a641c1ae62
'http://deb.debian.org/debian/pool/main/s/shadow/shadow_4.8.1-1.debian.tar.xz' shadow_4.8.1-1.debian.tar.xz 74752 SHA256:fdbccadc28fcca744f365e0529f3828d0c82bc3513b28976dca7308b40ea4773
```

Other potentially useful URLs:

- https://sources.debian.net/src/shadow/1:4.8.1-1/ (for browsing the source)
- https://sources.debian.net/src/shadow/1:4.8.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/shadow/1:4.8.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `six=1.16.0-2`

Binary Packages:

- `python3-six=1.16.0-2`

Licenses: (parsed from: `/usr/share/doc/python3-six/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris six=1.16.0-2
'http://deb.debian.org/debian/pool/main/s/six/six_1.16.0-2.dsc' six_1.16.0-2.dsc 1643 SHA256:15ad773fabd86cce617daaf6ccb0f9c31d9eaac62411ec5198c1d9c9dbfbd693
'http://deb.debian.org/debian/pool/main/s/six/six_1.16.0.orig.tar.gz' six_1.16.0.orig.tar.gz 34041 SHA256:1e61c37477a1626458e36f7b1d82aa5c9b094fa4802892072e49de9c60c4c926
'http://deb.debian.org/debian/pool/main/s/six/six_1.16.0-2.debian.tar.xz' six_1.16.0-2.debian.tar.xz 4892 SHA256:35c7fe199852a2be2575d04d787adabeeb157a72a473ce0295bc7f40df6f26a6
```

Other potentially useful URLs:

- https://sources.debian.net/src/six/1.16.0-2/ (for browsing the source)
- https://sources.debian.net/src/six/1.16.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/six/1.16.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `sortedcontainers=2.1.0-2`

Binary Packages:

- `python3-sortedcontainers=2.1.0-2`

Licenses: (parsed from: `/usr/share/doc/python3-sortedcontainers/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris sortedcontainers=2.1.0-2
'http://deb.debian.org/debian/pool/main/s/sortedcontainers/sortedcontainers_2.1.0-2.dsc' sortedcontainers_2.1.0-2.dsc 2260 SHA256:cd5642a45ae73f72b8c40716aade7f07e9779ed6a6db4019ef14cb5daff54f9d
'http://deb.debian.org/debian/pool/main/s/sortedcontainers/sortedcontainers_2.1.0.orig.tar.gz' sortedcontainers_2.1.0.orig.tar.gz 9220860 SHA256:ecd1ed41968d61d49e2ee2d1a852b452535c2edadaac78147fee815610bc845d
'http://deb.debian.org/debian/pool/main/s/sortedcontainers/sortedcontainers_2.1.0-2.debian.tar.xz' sortedcontainers_2.1.0-2.debian.tar.xz 3052 SHA256:3a0d53f3c6fb3f071cade1f91afa8901a0089cbbb5bd3ee21fa5263a024583fd
```

Other potentially useful URLs:

- https://sources.debian.net/src/sortedcontainers/2.1.0-2/ (for browsing the source)
- https://sources.debian.net/src/sortedcontainers/2.1.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/sortedcontainers/2.1.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `soupsieve=2.2.1-1`

Binary Packages:

- `python3-soupsieve=2.2.1-1`

Licenses: (parsed from: `/usr/share/doc/python3-soupsieve/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris soupsieve=2.2.1-1
'http://deb.debian.org/debian/pool/main/s/soupsieve/soupsieve_2.2.1-1.dsc' soupsieve_2.2.1-1.dsc 1620 SHA256:b6235610ac47501be3873234441f3c4538ab6e0c994a14de46cdc605e023dd08
'http://deb.debian.org/debian/pool/main/s/soupsieve/soupsieve_2.2.1.orig.tar.gz' soupsieve_2.2.1.orig.tar.gz 102949 SHA256:052774848f448cf19c7e959adf5566904d525f33a3f8b6ba6f6f8f26ec7de0cc
'http://deb.debian.org/debian/pool/main/s/soupsieve/soupsieve_2.2.1-1.debian.tar.xz' soupsieve_2.2.1-1.debian.tar.xz 3404 SHA256:2d1dc2e547f0233a23a5895939183d5347faf6a1a95098055fdc752c9a14c453
```

Other potentially useful URLs:

- https://sources.debian.net/src/soupsieve/2.2.1-1/ (for browsing the source)
- https://sources.debian.net/src/soupsieve/2.2.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/soupsieve/2.2.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `sphinx=3.4.3-2`

Binary Packages:

- `libjs-sphinxdoc=3.4.3-2`

Licenses: (parsed from: `/usr/share/doc/libjs-sphinxdoc/copyright`)

- `BSD-2-clause`
- `BSD-3-clause`
- `Expat`
- `PSF-2`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris sphinx=3.4.3-2
'http://deb.debian.org/debian/pool/main/s/sphinx/sphinx_3.4.3-2.dsc' sphinx_3.4.3-2.dsc 3482 SHA256:70f2bfc88c35a8bd204ea917ddfda7099e21e026fb1e196d92fdd46a6690f2aa
'http://deb.debian.org/debian/pool/main/s/sphinx/sphinx_3.4.3.orig.tar.gz' sphinx_3.4.3.orig.tar.gz 5997116 SHA256:41cad293f954f7d37f803d97eb184158cfd90f51195131e94875bc07cd08b93c
'http://deb.debian.org/debian/pool/main/s/sphinx/sphinx_3.4.3.orig.tar.gz.asc' sphinx_3.4.3.orig.tar.gz.asc 833 SHA256:d3719d5d7569fcf953234e18e93bc27041826902b6842052974b7879894cd350
'http://deb.debian.org/debian/pool/main/s/sphinx/sphinx_3.4.3-2.debian.tar.xz' sphinx_3.4.3-2.debian.tar.xz 39232 SHA256:54e43530ac9789ff82707213147b00023f8a493bb1a93244ea218bd077c59585
```

Other potentially useful URLs:

- https://sources.debian.net/src/sphinx/3.4.3-2/ (for browsing the source)
- https://sources.debian.net/src/sphinx/3.4.3-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/sphinx/3.4.3-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `sqlite3=3.34.1-3+deb11u1`

Binary Packages:

- `libsqlite3-0:amd64=3.34.1-3+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libsqlite3-0/copyright`)

- `GPL-2`
- `GPL-2+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris sqlite3=3.34.1-3+deb11u1
'http://deb.debian.org/debian-security/pool/updates/main/s/sqlite3/sqlite3_3.34.1-3%2bdeb11u1.dsc' sqlite3_3.34.1-3+deb11u1.dsc 2442 SHA256:e1e3a81f4734ee81063f0aae38f405ad874b8080778386402eb95e385d877b23
'http://deb.debian.org/debian-security/pool/updates/main/s/sqlite3/sqlite3_3.34.1.orig-www.tar.xz' sqlite3_3.34.1.orig-www.tar.xz 5581512 SHA256:c63647f3fb6c4b0620d6587e2a744021401df92c307b55e236a7eb28c5000fa7
'http://deb.debian.org/debian-security/pool/updates/main/s/sqlite3/sqlite3_3.34.1.orig.tar.xz' sqlite3_3.34.1.orig.tar.xz 7343284 SHA256:082f583440c662cb484ae1c124ffe285b587bbb7837e095e693026e6df50334d
'http://deb.debian.org/debian-security/pool/updates/main/s/sqlite3/sqlite3_3.34.1-3%2bdeb11u1.debian.tar.xz' sqlite3_3.34.1-3+deb11u1.debian.tar.xz 24196 SHA256:51498b4e13d90fc26ad290fe41e8f83cb7e792900e354fddd6941a684c0d983a
```

Other potentially useful URLs:

- https://sources.debian.net/src/sqlite3/3.34.1-3+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/sqlite3/3.34.1-3+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/sqlite3/3.34.1-3+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `systemd=247.3-7+deb11u6`

Binary Packages:

- `libsystemd0:amd64=247.3-7+deb11u6`
- `libudev1:amd64=247.3-7+deb11u6`

Licenses: (parsed from: `/usr/share/doc/libsystemd0/copyright`, `/usr/share/doc/libudev1/copyright`)

- `CC0-1.0`
- `Expat`
- `GPL-2`
- `GPL-2 with Linux-syscall-note exception`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris systemd=247.3-7+deb11u6
'http://deb.debian.org/debian-security/pool/updates/main/s/systemd/systemd_247.3-7%2bdeb11u6.dsc' systemd_247.3-7+deb11u6.dsc 5199 SHA256:2a42912fd6641d80851ecba3231fa912e1ae73b684c89d39ab54ef454b2bf5a9
'http://deb.debian.org/debian-security/pool/updates/main/s/systemd/systemd_247.3.orig.tar.gz' systemd_247.3.orig.tar.gz 9895385 SHA256:2869986e219a8dfc96cc0dffac66e0c13bb70a89e16b85a3948876c146cfa3e0
'http://deb.debian.org/debian-security/pool/updates/main/s/systemd/systemd_247.3-7%2bdeb11u6.debian.tar.xz' systemd_247.3-7+deb11u6.debian.tar.xz 200308 SHA256:c9de4ff5649076c430ae1eb655b5d3ccd74a295431ca8fcf416e91b453fa37f9
```

Other potentially useful URLs:

- https://sources.debian.net/src/systemd/247.3-7+deb11u6/ (for browsing the source)
- https://sources.debian.net/src/systemd/247.3-7+deb11u6/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/systemd/247.3-7+deb11u6/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `sysvinit=2.96-7+deb11u1`

Binary Packages:

- `sysvinit-utils=2.96-7+deb11u1`

Licenses: (parsed from: `/usr/share/doc/sysvinit-utils/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris sysvinit=2.96-7+deb11u1
'http://deb.debian.org/debian/pool/main/s/sysvinit/sysvinit_2.96-7%2bdeb11u1.dsc' sysvinit_2.96-7+deb11u1.dsc 2374 SHA256:1ef8a8b224aabecbd27ebef68b389bc3149970ef348877cec3ac7351a04c13a7
'http://deb.debian.org/debian/pool/main/s/sysvinit/sysvinit_2.96.orig.tar.gz' sysvinit_2.96.orig.tar.gz 147834 SHA256:1275620f767c85bb2d7e5b9542579ae097f3eb542065ff30a70efc95b6e84c64
'http://deb.debian.org/debian/pool/main/s/sysvinit/sysvinit_2.96-7%2bdeb11u1.debian.tar.xz' sysvinit_2.96-7+deb11u1.debian.tar.xz 129936 SHA256:5ce9a0b9735a66c536c77c65e17d4190338e0c0416ba235c26c9cf12d3cfbeb3
```

Other potentially useful URLs:

- https://sources.debian.net/src/sysvinit/2.96-7+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/sysvinit/2.96-7+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/sysvinit/2.96-7+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `tar=1.34+dfsg-1+deb11u1`

Binary Packages:

- `tar=1.34+dfsg-1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/tar/copyright`)

- `GPL-2`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris tar=1.34+dfsg-1+deb11u1
'http://deb.debian.org/debian/pool/main/t/tar/tar_1.34%2bdfsg-1%2bdeb11u1.dsc' tar_1.34+dfsg-1+deb11u1.dsc 2177 SHA256:9df5361d93936b77e7a51383ed369ad709cb12c6a4615ce9252360fb431804bc
'http://deb.debian.org/debian/pool/main/t/tar/tar_1.34%2bdfsg.orig.tar.xz' tar_1.34+dfsg.orig.tar.xz 1981736 SHA256:7d57029540cb928394defb3b377b3531237c947e795b51aa8acac0c5ba0e4844
'http://deb.debian.org/debian/pool/main/t/tar/tar_1.34%2bdfsg-1%2bdeb11u1.debian.tar.xz' tar_1.34+dfsg-1+deb11u1.debian.tar.xz 20276 SHA256:61ff8974dadd7dba4e6a09e6db193a77f0a0a17b681b4d188d4f1569bcf48449
```

Other potentially useful URLs:

- https://sources.debian.net/src/tar/1.34+dfsg-1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/tar/1.34+dfsg-1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/tar/1.34+dfsg-1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `tiff=4.2.0-1+deb11u5`

Binary Packages:

- `libtiff5:amd64=4.2.0-1+deb11u5`

Licenses: (parsed from: `/usr/share/doc/libtiff5/copyright`)

- `Hylafax`

Source:

```console
$ apt-get source -qq --print-uris tiff=4.2.0-1+deb11u5
'http://deb.debian.org/debian/pool/main/t/tiff/tiff_4.2.0-1%2bdeb11u5.dsc' tiff_4.2.0-1+deb11u5.dsc 2116 SHA256:eeb72e3449968ab5d39fdf7f999b787580837fcf7751f30e16750659919fd3d4
'http://deb.debian.org/debian/pool/main/t/tiff/tiff_4.2.0.orig.tar.gz' tiff_4.2.0.orig.tar.gz 2809373 SHA256:eb0484e568ead8fa23b513e9b0041df7e327f4ee2d22db5a533929dfc19633cb
'http://deb.debian.org/debian/pool/main/t/tiff/tiff_4.2.0.orig.tar.gz.asc' tiff_4.2.0.orig.tar.gz.asc 228 SHA256:119bb62934603ff4d3cd81c739d11904b28812a860773b9b2268cc96a339b14f
'http://deb.debian.org/debian/pool/main/t/tiff/tiff_4.2.0-1%2bdeb11u5.debian.tar.xz' tiff_4.2.0-1+deb11u5.debian.tar.xz 41268 SHA256:472770be431abb4f9fdaf2f0e2306b8980a47b1a55a3c10a2224f2c8833fa6a0
```

Other potentially useful URLs:

- https://sources.debian.net/src/tiff/4.2.0-1+deb11u5/ (for browsing the source)
- https://sources.debian.net/src/tiff/4.2.0-1+deb11u5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/tiff/4.2.0-1+deb11u5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `tzdata=2024a-0+deb11u1`

Binary Packages:

- `tzdata=2024a-0+deb11u1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris tzdata=2024a-0+deb11u1
'http://deb.debian.org/debian/pool/main/t/tzdata/tzdata_2024a-0%2bdeb11u1.dsc' tzdata_2024a-0+deb11u1.dsc 2269 SHA256:63dcd00127b57f0fbb804f234430bac966be622b774d45f69eab21a35e596025
'http://deb.debian.org/debian/pool/main/t/tzdata/tzdata_2024a.orig.tar.gz' tzdata_2024a.orig.tar.gz 451270 SHA256:0d0434459acbd2059a7a8da1f3304a84a86591f6ed69c6248fffa502b6edffe3
'http://deb.debian.org/debian/pool/main/t/tzdata/tzdata_2024a.orig.tar.gz.asc' tzdata_2024a.orig.tar.gz.asc 833 SHA256:f64725f9f65419e7b009e3b95b75ea9516382d0be64aef63d78654d9c569ed0d
'http://deb.debian.org/debian/pool/main/t/tzdata/tzdata_2024a-0%2bdeb11u1.debian.tar.xz' tzdata_2024a-0+deb11u1.debian.tar.xz 106548 SHA256:0455dfbbee01c416518d73de11d14835afebd1ca32cfe6cea7b3ed74f0f20afc
```

Other potentially useful URLs:

- https://sources.debian.net/src/tzdata/2024a-0+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/tzdata/2024a-0+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/tzdata/2024a-0+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `ucf=3.0043`

Binary Packages:

- `ucf=3.0043`

Licenses: (parsed from: `/usr/share/doc/ucf/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris ucf=3.0043
'http://deb.debian.org/debian/pool/main/u/ucf/ucf_3.0043.dsc' ucf_3.0043.dsc 1423 SHA256:5954508238ff1b8e2c61e1f533268911ba06709e821c02de014fd15d2ead81fd
'http://deb.debian.org/debian/pool/main/u/ucf/ucf_3.0043.tar.xz' ucf_3.0043.tar.xz 70560 SHA256:0294cc11a6cf032ea99ca5064f73a4ede5b28bc2d4ad0a12e8493c7520c7a2a4
```

Other potentially useful URLs:

- https://sources.debian.net/src/ucf/3.0043/ (for browsing the source)
- https://sources.debian.net/src/ucf/3.0043/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/ucf/3.0043/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `underscore=1.9.1~dfsg-3`

Binary Packages:

- `libjs-underscore=1.9.1~dfsg-3`

Licenses: (parsed from: `/usr/share/doc/libjs-underscore/copyright`)

- `BSD-3-clause`
- `Expat`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris underscore=1.9.1~dfsg-3
'http://deb.debian.org/debian/pool/main/u/underscore/underscore_1.9.1%7edfsg-3.dsc' underscore_1.9.1~dfsg-3.dsc 2120 SHA256:9809d94a08a96822bf673691640ef4ddaf4164e8dd1a28b5320ff1a880d201bd
'http://deb.debian.org/debian/pool/main/u/underscore/underscore_1.9.1%7edfsg.orig.tar.xz' underscore_1.9.1~dfsg.orig.tar.xz 138080 SHA256:26832038e5282c0bde14d5cbe511a42053b5f440e1670f99ba67224a4fd45702
'http://deb.debian.org/debian/pool/main/u/underscore/underscore_1.9.1%7edfsg-3.debian.tar.xz' underscore_1.9.1~dfsg-3.debian.tar.xz 9272 SHA256:46c46607d26bab1fd4b4149e1ebbcc136924ad35e4eaf2c7cffedc43aed485bc
```

Other potentially useful URLs:

- https://sources.debian.net/src/underscore/1.9.1~dfsg-3/ (for browsing the source)
- https://sources.debian.net/src/underscore/1.9.1~dfsg-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/underscore/1.9.1~dfsg-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `unidecode=1.2.0-1`

Binary Packages:

- `python3-unidecode=1.2.0-1`

Licenses: (parsed from: `/usr/share/doc/python3-unidecode/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris unidecode=1.2.0-1
'http://deb.debian.org/debian/pool/main/u/unidecode/unidecode_1.2.0-1.dsc' unidecode_1.2.0-1.dsc 1451 SHA256:630d537de9d2bdd8c568d8da461eee31d3a623a4f5a632452dc07b119521bd6f
'http://deb.debian.org/debian/pool/main/u/unidecode/unidecode_1.2.0.orig.tar.gz' unidecode_1.2.0.orig.tar.gz 216042 SHA256:8d73a97d387a956922344f6b74243c2c6771594659778744b2dbdaad8f6b727d
'http://deb.debian.org/debian/pool/main/u/unidecode/unidecode_1.2.0-1.debian.tar.xz' unidecode_1.2.0-1.debian.tar.xz 3756 SHA256:09c51e77b4ed4f9d1e6c6c0e4e8849dffde3abe890f7f9bb87724bc8e08ad12c
```

Other potentially useful URLs:

- https://sources.debian.net/src/unidecode/1.2.0-1/ (for browsing the source)
- https://sources.debian.net/src/unidecode/1.2.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/unidecode/1.2.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `util-linux=2.36.1-8+deb11u2`

Binary Packages:

- `bsdutils=1:2.36.1-8+deb11u2`
- `libblkid1:amd64=2.36.1-8+deb11u2`
- `libmount1:amd64=2.36.1-8+deb11u2`
- `libsmartcols1:amd64=2.36.1-8+deb11u2`
- `libuuid1:amd64=2.36.1-8+deb11u2`
- `mount=2.36.1-8+deb11u2`
- `util-linux=2.36.1-8+deb11u2`

Licenses: (parsed from: `/usr/share/doc/bsdutils/copyright`, `/usr/share/doc/libblkid1/copyright`, `/usr/share/doc/libmount1/copyright`, `/usr/share/doc/libsmartcols1/copyright`, `/usr/share/doc/libuuid1/copyright`, `/usr/share/doc/mount/copyright`, `/usr/share/doc/util-linux/copyright`)

- `BSD-2-clause`
- `BSD-3-clause`
- `BSD-4-clause`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `LGPL`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `LGPL-3`
- `LGPL-3+`
- `MIT`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris util-linux=2.36.1-8+deb11u2
'http://deb.debian.org/debian/pool/main/u/util-linux/util-linux_2.36.1-8%2bdeb11u2.dsc' util-linux_2.36.1-8+deb11u2.dsc 4306 SHA256:16cfb1bc4d0a52f5edf2c78b5e022bb1fc180f03b93a5094b5c420a0d8d4431a
'http://deb.debian.org/debian/pool/main/u/util-linux/util-linux_2.36.1.orig.tar.xz' util-linux_2.36.1.orig.tar.xz 5231880 SHA256:09fac242172cd8ec27f0739d8d192402c69417617091d8c6e974841568f37eed
'http://deb.debian.org/debian/pool/main/u/util-linux/util-linux_2.36.1-8%2bdeb11u2.debian.tar.xz' util-linux_2.36.1-8+deb11u2.debian.tar.xz 106524 SHA256:0b07fbb79e1dab3be2568295664af950a7c3e589ce7821febf2ab0a3ccbe4862
```

Other potentially useful URLs:

- https://sources.debian.net/src/util-linux/2.36.1-8+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/util-linux/2.36.1-8+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/util-linux/2.36.1-8+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `wheel=0.34.2-1`

Binary Packages:

- `python3-wheel=0.34.2-1`

Licenses: (parsed from: `/usr/share/doc/python3-wheel/copyright`)

- `Expat/MIT`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris wheel=0.34.2-1
'http://deb.debian.org/debian/pool/main/w/wheel/wheel_0.34.2-1.dsc' wheel_0.34.2-1.dsc 2142 SHA256:89483134398ce4711e22c0a20ecc8e980ff612bc55d2f84a0bc18eb708856721
'http://deb.debian.org/debian/pool/main/w/wheel/wheel_0.34.2.orig.tar.gz' wheel_0.34.2.orig.tar.gz 58330 SHA256:8788e9155fe14f54164c1b9eb0a319d98ef02c160725587ad60f14ddc57b6f96
'http://deb.debian.org/debian/pool/main/w/wheel/wheel_0.34.2-1.debian.tar.xz' wheel_0.34.2-1.debian.tar.xz 9676 SHA256:46b4341fed49af49943c37ac15d0dd34fd669b639653bb94ba56320633d32293
```

Other potentially useful URLs:

- https://sources.debian.net/src/wheel/0.34.2-1/ (for browsing the source)
- https://sources.debian.net/src/wheel/0.34.2-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/wheel/0.34.2-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `wkhtmltox=1:0.12.6.1-3.bullseye`

Binary Packages:

- `wkhtmltox=1:0.12.6.1-3.bullseye`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


**WARNING:** unable to find source (`apt-get source` failed or returned no results)!  
This is *usually* due to a new package version being released and the old version being removed.


### `dpkg` source package: `xdg-utils=1.1.3-4.1`

Binary Packages:

- `xdg-utils=1.1.3-4.1`

Licenses: (parsed from: `/usr/share/doc/xdg-utils/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris xdg-utils=1.1.3-4.1
'http://deb.debian.org/debian/pool/main/x/xdg-utils/xdg-utils_1.1.3-4.1.dsc' xdg-utils_1.1.3-4.1.dsc 1756 SHA256:c54ae65034c4c3e9f2208a44990111d34fc5ed1e689efd3907a2a8e5e965ccac
'http://deb.debian.org/debian/pool/main/x/xdg-utils/xdg-utils_1.1.3.orig.tar.gz' xdg-utils_1.1.3.orig.tar.gz 297170 SHA256:d798b08af8a8e2063ddde6c9fa3398ca81484f27dec642c5627ffcaa0d4051d9
'http://deb.debian.org/debian/pool/main/x/xdg-utils/xdg-utils_1.1.3-4.1.debian.tar.xz' xdg-utils_1.1.3-4.1.debian.tar.xz 15660 SHA256:0ea0b550719ab75f9a0fe58ed907673c5bcfc2bd87537845534694c502740aed
```

Other potentially useful URLs:

- https://sources.debian.net/src/xdg-utils/1.1.3-4.1/ (for browsing the source)
- https://sources.debian.net/src/xdg-utils/1.1.3-4.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/xdg-utils/1.1.3-4.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `xfonts-75dpi=1:1.0.4+nmu1.1`

Binary Packages:

- `xfonts-75dpi=1:1.0.4+nmu1.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris xfonts-75dpi=1:1.0.4+nmu1.1
'http://deb.debian.org/debian/pool/main/x/xfonts-75dpi/xfonts-75dpi_1.0.4%2bnmu1.1.dsc' xfonts-75dpi_1.0.4+nmu1.1.dsc 1712 SHA256:ea57317137fbb8782f7c5cecb348dd83c61713692595381bf44d210dac6cf6a9
'http://deb.debian.org/debian/pool/main/x/xfonts-75dpi/xfonts-75dpi_1.0.4%2bnmu1.1.tar.gz' xfonts-75dpi_1.0.4+nmu1.1.tar.gz 2909174 SHA256:58a71262fe7e9847c771617c5f492b11edf3d954b28b856adf4f373239f20916
```

Other potentially useful URLs:

- https://sources.debian.net/src/xfonts-75dpi/1:1.0.4+nmu1.1/ (for browsing the source)
- https://sources.debian.net/src/xfonts-75dpi/1:1.0.4+nmu1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/xfonts-75dpi/1:1.0.4+nmu1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `xfonts-base=1:1.0.5`

Binary Packages:

- `xfonts-base=1:1.0.5`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris xfonts-base=1:1.0.5
'http://deb.debian.org/debian/pool/main/x/xfonts-base/xfonts-base_1.0.5.dsc' xfonts-base_1.0.5.dsc 1667 SHA256:e4cbfdfdf8abcfe08444b86ae8a70743e7afd5872f83693921c7502d2b5d773d
'http://deb.debian.org/debian/pool/main/x/xfonts-base/xfonts-base_1.0.5.tar.gz' xfonts-base_1.0.5.tar.gz 6540582 SHA256:c2aef282be91aa1d2ccc8193400d073603c5670cecd9f3522f94f15ac2dca881
```

Other potentially useful URLs:

- https://sources.debian.net/src/xfonts-base/1:1.0.5/ (for browsing the source)
- https://sources.debian.net/src/xfonts-base/1:1.0.5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/xfonts-base/1:1.0.5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `xfonts-encodings=1:1.0.4-2.1`

Binary Packages:

- `xfonts-encodings=1:1.0.4-2.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris xfonts-encodings=1:1.0.4-2.1
'http://deb.debian.org/debian/pool/main/x/xfonts-encodings/xfonts-encodings_1.0.4-2.1.dsc' xfonts-encodings_1.0.4-2.1.dsc 1984 SHA256:9d15cc1a9d4f6d42e594b0079e9c40b264fa79f0756fd6044a642fa19f240b8a
'http://deb.debian.org/debian/pool/main/x/xfonts-encodings/xfonts-encodings_1.0.4.orig.tar.gz' xfonts-encodings_1.0.4.orig.tar.gz 768589 SHA256:55861d9cf456bd717a3d30a3193402c02174ed3c0dcee828798165fe307ee324
'http://deb.debian.org/debian/pool/main/x/xfonts-encodings/xfonts-encodings_1.0.4-2.1.diff.gz' xfonts-encodings_1.0.4-2.1.diff.gz 13966 SHA256:10220786b56fac988e37bd1f2ab2816675892f0957b2e05c8d392f29d261bcb2
```

Other potentially useful URLs:

- https://sources.debian.net/src/xfonts-encodings/1:1.0.4-2.1/ (for browsing the source)
- https://sources.debian.net/src/xfonts-encodings/1:1.0.4-2.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/xfonts-encodings/1:1.0.4-2.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `xfonts-utils=1:7.7+6`

Binary Packages:

- `xfonts-utils=1:7.7+6`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris xfonts-utils=1:7.7+6
'http://deb.debian.org/debian/pool/main/x/xfonts-utils/xfonts-utils_7.7%2b6.dsc' xfonts-utils_7.7+6.dsc 1724 SHA256:dbd85878cb09fa49370f2ab3a556807ab634108af53609f9481989db0fd53f5e
'http://deb.debian.org/debian/pool/main/x/xfonts-utils/xfonts-utils_7.7%2b6.tar.gz' xfonts-utils_7.7+6.tar.gz 834315 SHA256:b6f55f94091d5de37e4e2f36b54e230d414817815e58d31bdf02fdf04ef92d1c
```

Other potentially useful URLs:

- https://sources.debian.net/src/xfonts-utils/1:7.7+6/ (for browsing the source)
- https://sources.debian.net/src/xfonts-utils/1:7.7+6/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/xfonts-utils/1:7.7+6/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `xlsxwriter=1.1.2-0.2`

Binary Packages:

- `python3-xlsxwriter=1.1.2-0.2`

Licenses: (parsed from: `/usr/share/doc/python3-xlsxwriter/copyright`)

- `BSD-2-clause`
- `GPL-3`
- `LGPL`
- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris xlsxwriter=1.1.2-0.2
'http://deb.debian.org/debian/pool/main/x/xlsxwriter/xlsxwriter_1.1.2-0.2.dsc' xlsxwriter_1.1.2-0.2.dsc 1983 SHA256:905ac7fe3f6ae0b3cfc64bd1192d896c4f68164437729cca250457bb496bd252
'http://deb.debian.org/debian/pool/main/x/xlsxwriter/xlsxwriter_1.1.2.orig.tar.gz' xlsxwriter_1.1.2.orig.tar.gz 248469 SHA256:ae22658a0fc5b9e875fa97c213d1ffd617d86dc49bf08be99ebdac814db7bf36
'http://deb.debian.org/debian/pool/main/x/xlsxwriter/xlsxwriter_1.1.2-0.2.debian.tar.xz' xlsxwriter_1.1.2-0.2.debian.tar.xz 3760 SHA256:43a80e75851926fc19d977258724958e803be2677e4222be8884601bd1557195
```

Other potentially useful URLs:

- https://sources.debian.net/src/xlsxwriter/1.1.2-0.2/ (for browsing the source)
- https://sources.debian.net/src/xlsxwriter/1.1.2-0.2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/xlsxwriter/1.1.2-0.2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `xlwt=1.3.0-3`

Binary Packages:

- `python3-xlwt=1.3.0-3`

Licenses: (parsed from: `/usr/share/doc/python3-xlwt/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris xlwt=1.3.0-3
'http://deb.debian.org/debian/pool/main/x/xlwt/xlwt_1.3.0-3.dsc' xlwt_1.3.0-3.dsc 2124 SHA256:5e6b30790d7cd4f1bd62d6452e3cb05c73cb704348e18b3bfe22306448f9c6c2
'http://deb.debian.org/debian/pool/main/x/xlwt/xlwt_1.3.0.orig.tar.gz' xlwt_1.3.0.orig.tar.gz 153929 SHA256:c59912717a9b28f1a3c2a98fd60741014b06b043936dcecbc113eaaada156c88
'http://deb.debian.org/debian/pool/main/x/xlwt/xlwt_1.3.0-3.debian.tar.xz' xlwt_1.3.0-3.debian.tar.xz 6744 SHA256:cd4d32c3c12b13ca7a080bd545561e1527d68b334f55f8945099cebed197d56d
```

Other potentially useful URLs:

- https://sources.debian.net/src/xlwt/1.3.0-3/ (for browsing the source)
- https://sources.debian.net/src/xlwt/1.3.0-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/xlwt/1.3.0-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `xml-core=0.18+nmu1`

Binary Packages:

- `xml-core=0.18+nmu1`

Licenses: (parsed from: `/usr/share/doc/xml-core/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris xml-core=0.18+nmu1
'http://deb.debian.org/debian/pool/main/x/xml-core/xml-core_0.18%2bnmu1.dsc' xml-core_0.18+nmu1.dsc 1632 SHA256:3b4bc034193f99750141611ae1c836c6b742c88ed0af1420051f3fcae30bf5ae
'http://deb.debian.org/debian/pool/main/x/xml-core/xml-core_0.18%2bnmu1.tar.xz' xml-core_0.18+nmu1.tar.xz 21312 SHA256:3e07592404b8ac38924fb650227cf5c9dcfc9933bd632eb4430635cd54898471
```

Other potentially useful URLs:

- https://sources.debian.net/src/xml-core/0.18+nmu1/ (for browsing the source)
- https://sources.debian.net/src/xml-core/0.18+nmu1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/xml-core/0.18+nmu1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `xorg=1:7.7+22`

Binary Packages:

- `x11-common=1:7.7+22`

Licenses: (parsed from: `/usr/share/doc/x11-common/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris xorg=1:7.7+22
'http://deb.debian.org/debian/pool/main/x/xorg/xorg_7.7%2b22.dsc' xorg_7.7+22.dsc 1975 SHA256:5b273e9b4ece8f4525e73721cc1f14ea0772007035c24b5e35269bcdca45b69a
'http://deb.debian.org/debian/pool/main/x/xorg/xorg_7.7%2b22.tar.gz' xorg_7.7+22.tar.gz 287402 SHA256:4e39d07914480826f02f8ba293dc07e5595a2789c53ee47d92cc5ee992ef2ed5
```

Other potentially useful URLs:

- https://sources.debian.net/src/xorg/1:7.7+22/ (for browsing the source)
- https://sources.debian.net/src/xorg/1:7.7+22/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/xorg/1:7.7+22/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `xxhash=0.8.0-2`

Binary Packages:

- `libxxhash0:amd64=0.8.0-2`

Licenses: (parsed from: `/usr/share/doc/libxxhash0/copyright`)

- `BSD-2-clause`
- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris xxhash=0.8.0-2
'http://deb.debian.org/debian/pool/main/x/xxhash/xxhash_0.8.0-2.dsc' xxhash_0.8.0-2.dsc 1601 SHA256:91c696b5371558ebb12c323b0bd4e15eece0a439ef49c6aa5a6d0c1cf6c7762a
'http://deb.debian.org/debian/pool/main/x/xxhash/xxhash_0.8.0.orig.tar.gz' xxhash_0.8.0.orig.tar.gz 145909 SHA256:7054c3ebd169c97b64a92d7b994ab63c70dd53a06974f1f630ab782c28db0f4f
'http://deb.debian.org/debian/pool/main/x/xxhash/xxhash_0.8.0-2.debian.tar.xz' xxhash_0.8.0-2.debian.tar.xz 4160 SHA256:5c427c2c08019a945412afac02326a24c72b65a83bff59447009db303233aecd
```

Other potentially useful URLs:

- https://sources.debian.net/src/xxhash/0.8.0-2/ (for browsing the source)
- https://sources.debian.net/src/xxhash/0.8.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/xxhash/0.8.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `xz-utils=5.2.5-2.1~deb11u1`

Binary Packages:

- `liblzma5:amd64=5.2.5-2.1~deb11u1`
- `xz-utils=5.2.5-2.1~deb11u1`

Licenses: (parsed from: `/usr/share/doc/liblzma5/copyright`, `/usr/share/doc/xz-utils/copyright`)

- `Autoconf`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `LGPL-2`
- `LGPL-2.1`
- `LGPL-2.1+`
- `PD`
- `PD-debian`
- `config-h`
- `noderivs`
- `none`
- `permissive-fsf`
- `permissive-nowarranty`
- `probably-PD`

Source:

```console
$ apt-get source -qq --print-uris xz-utils=5.2.5-2.1~deb11u1
'http://deb.debian.org/debian/pool/main/x/xz-utils/xz-utils_5.2.5-2.1%7edeb11u1.dsc' xz-utils_5.2.5-2.1~deb11u1.dsc 2681 SHA256:68a2702d252ab75789130fc9d2f48b9b38fc0181990c42a947b0d923d9d1922a
'http://deb.debian.org/debian/pool/main/x/xz-utils/xz-utils_5.2.5.orig.tar.xz' xz-utils_5.2.5.orig.tar.xz 1148824 SHA256:3e1e518ffc912f86608a8cb35e4bd41ad1aec210df2a47aaa1f95e7f5576ef56
'http://deb.debian.org/debian/pool/main/x/xz-utils/xz-utils_5.2.5.orig.tar.xz.asc' xz-utils_5.2.5.orig.tar.xz.asc 833 SHA256:6efc0075a58912e640119d2b52ef7d1518b260d8720fadc73df21ab7fc727624
'http://deb.debian.org/debian/pool/main/x/xz-utils/xz-utils_5.2.5-2.1%7edeb11u1.debian.tar.xz' xz-utils_5.2.5-2.1~deb11u1.debian.tar.xz 34948 SHA256:07627e4c7a50ef91d64c177626507afd6107f44e27f4aacb5e41151d1399ff4f
```

Other potentially useful URLs:

- https://sources.debian.net/src/xz-utils/5.2.5-2.1~deb11u1/ (for browsing the source)
- https://sources.debian.net/src/xz-utils/5.2.5-2.1~deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/xz-utils/5.2.5-2.1~deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `zlib=1:1.2.11.dfsg-2+deb11u2`

Binary Packages:

- `zlib1g:amd64=1:1.2.11.dfsg-2+deb11u2`

Licenses: (parsed from: `/usr/share/doc/zlib1g/copyright`)

- `Zlib`

Source:

```console
$ apt-get source -qq --print-uris zlib=1:1.2.11.dfsg-2+deb11u2
'http://deb.debian.org/debian/pool/main/z/zlib/zlib_1.2.11.dfsg-2%2bdeb11u2.dsc' zlib_1.2.11.dfsg-2+deb11u2.dsc 2905 SHA256:ec2ee2fc4dfd1f799dfa6a95133ebccbd7531886de38b0a8e3e58b66706a6dc7
'http://deb.debian.org/debian/pool/main/z/zlib/zlib_1.2.11.dfsg.orig.tar.gz' zlib_1.2.11.dfsg.orig.tar.gz 370248 SHA256:80c481411a4fe8463aeb8270149a0e80bb9eaf7da44132b6e16f2b5af01bc899
'http://deb.debian.org/debian/pool/main/z/zlib/zlib_1.2.11.dfsg-2%2bdeb11u2.debian.tar.xz' zlib_1.2.11.dfsg-2+deb11u2.debian.tar.xz 23984 SHA256:c19794df214f0c2571b19f7dea853c066410232abe9f0ddad77231fabccde0da
```

Other potentially useful URLs:

- https://sources.debian.net/src/zlib/1:1.2.11.dfsg-2+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/zlib/1:1.2.11.dfsg-2+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/zlib/1:1.2.11.dfsg-2+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `zope.event=4.4-3`

Binary Packages:

- `python3-zope.event=4.4-3`

Licenses: (parsed from: `/usr/share/doc/python3-zope.event/copyright`)

- `Zope-2.1`

Source:

```console
$ apt-get source -qq --print-uris zope.event=4.4-3
'http://deb.debian.org/debian/pool/main/z/zope.event/zope.event_4.4-3.dsc' zope.event_4.4-3.dsc 1937 SHA256:b48880761a9706735ea8ed8bba7a387edb25dc81d059ef05909347a759ac966e
'http://deb.debian.org/debian/pool/main/z/zope.event/zope.event_4.4.orig.tar.gz' zope.event_4.4.orig.tar.gz 18818 SHA256:69c27debad9bdacd9ce9b735dad382142281ac770c4a432b533d6d65c4614bcf
'http://deb.debian.org/debian/pool/main/z/zope.event/zope.event_4.4-3.debian.tar.xz' zope.event_4.4-3.debian.tar.xz 4264 SHA256:c8b660609de9c0d8e1e62ab47f2ee71abfbd92194e55f8c2a818eb071760f893
```

Other potentially useful URLs:

- https://sources.debian.net/src/zope.event/4.4-3/ (for browsing the source)
- https://sources.debian.net/src/zope.event/4.4-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/zope.event/4.4-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `zope.interface=5.2.0-1`

Binary Packages:

- `python3-zope.interface=5.2.0-1`

Licenses: (parsed from: `/usr/share/doc/python3-zope.interface/copyright`)

- `Zope-2.1`

Source:

```console
$ apt-get source -qq --print-uris zope.interface=5.2.0-1
'http://deb.debian.org/debian/pool/main/z/zope.interface/zope.interface_5.2.0-1.dsc' zope.interface_5.2.0-1.dsc 2363 SHA256:a407263b1eb8e2a13d9fdb0f26000ef081c38b9975ba57b7dfcabffc9dfeda22
'http://deb.debian.org/debian/pool/main/z/zope.interface/zope.interface_5.2.0.orig.tar.gz' zope.interface_5.2.0.orig.tar.gz 227058 SHA256:8251f06a77985a2729a8bdbefbae79ee78567dddc3acbd499b87e705ca59fe24
'http://deb.debian.org/debian/pool/main/z/zope.interface/zope.interface_5.2.0-1.debian.tar.xz' zope.interface_5.2.0-1.debian.tar.xz 6624 SHA256:ff54469ccce3e9842efc1fac47990d6e1a131bf762585270c4c51bad5997e8f8
```

Other potentially useful URLs:

- https://sources.debian.net/src/zope.interface/5.2.0-1/ (for browsing the source)
- https://sources.debian.net/src/zope.interface/5.2.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/zope.interface/5.2.0-1/ (for access to the source package after it no longer exists in the archive)
