## `mongo:7-windowsservercore`

```console
$ docker pull mongo@sha256:552b0a3f4b9540c6b49201d8cc35b0461f2c569ff2e9ab9d6a9f893a481e06e8
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.list.v2+json`
-	Platforms: 2
	-	windows version 10.0.20348.2762; amd64
	-	windows version 10.0.17763.6414; amd64

### `mongo:7-windowsservercore` - windows version 10.0.20348.2762; amd64

```console
$ docker pull mongo@sha256:17c88f8e8fe52e58e24d93fab047bb5cf324d8d82ba1e8b007e699e6b07453c8
```

-	Docker Version: 26.1.3
-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **2.4 GB (2410894266 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:8e40775a1dd6d5f02c6ee8f522b42d90a24fe8cfd0622a8fe75a84ae85f2c87d`
-	Default Command: `["mongod","--bind_ip_all"]`
-	`SHELL`: `["powershell","-Command","$ErrorActionPreference = 'Stop';"]`

```dockerfile
# Fri, 06 Sep 2024 00:01:38 GMT
RUN Apply image 10.0.20348.2700
# Sun, 06 Oct 2024 04:56:48 GMT
RUN Install update 10.0.20348.2762
# Fri, 25 Oct 2024 23:57:23 GMT
SHELL [powershell -Command $ErrorActionPreference = 'Stop';]
# Fri, 25 Oct 2024 23:57:23 GMT
ENV MONGO_VERSION=7.0.15
# Fri, 25 Oct 2024 23:57:24 GMT
ENV MONGO_DOWNLOAD_URL=https://fastdl.mongodb.org/windows/mongodb-windows-x86_64-7.0.15-signed.msi
# Fri, 25 Oct 2024 23:57:25 GMT
ENV MONGO_DOWNLOAD_SHA256=db61d1e382ab03ee98dcef1a65c4065efc4eb9eba2733852828670cfce23db3e
# Sat, 26 Oct 2024 00:00:19 GMT
RUN Write-Host ('Downloading {0} ...' -f $env:MONGO_DOWNLOAD_URL); 	[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; 	(New-Object System.Net.WebClient).DownloadFile($env:MONGO_DOWNLOAD_URL, 'mongo.msi'); 		if ($env:MONGO_DOWNLOAD_SHA256) { 		Write-Host ('Verifying sha256 ({0}) ...' -f $env:MONGO_DOWNLOAD_SHA256); 		if ((Get-FileHash mongo.msi -Algorithm sha256).Hash -ne $env:MONGO_DOWNLOAD_SHA256) { 			Write-Host 'FAILED!'; 			exit 1; 		}; 	}; 		Write-Host 'Installing ...'; 	Start-Process msiexec -Wait 		-ArgumentList @( 			'/i', 			'mongo.msi', 			'/quiet', 			'/qn', 			'/l*v', 'install.log', 			'INSTALLLOCATION=C:\mongodb', 			'ADDLOCAL=MiscellaneousTools,Router,ServerNoService' 		); 	if (-Not (Test-Path C:\mongodb\bin\mongod.exe -PathType Leaf)) { 		Write-Host 'Installer failed!'; 		Get-Content install.log; 		exit 1; 	}; 	Remove-Item install.log; 		$env:PATH = 'C:\mongodb\bin;' + $env:PATH; 	[Environment]::SetEnvironmentVariable('PATH', $env:PATH, [EnvironmentVariableTarget]::Machine); 		Write-Host 'Verifying install ...'; 	Write-Host '  mongod --version'; mongod --version; 		Write-Host 'Removing ...'; 	Remove-Item C:\windows\installer\*.msi -Force; 	Remove-Item mongo.msi -Force; 		Write-Host 'Complete.';
# Sat, 26 Oct 2024 00:00:20 GMT
VOLUME [C:\data\db C:\data\configdb]
# Sat, 26 Oct 2024 00:00:21 GMT
EXPOSE 27017
# Sat, 26 Oct 2024 00:00:22 GMT
CMD ["mongod" "--bind_ip_all"]
```

-	Layers:
	-	`sha256:2534953f34d35976fc44cd67bfdd39fdcd9e2eaae57ada0be53d5fb936cd3a0b`  
		Last Modified: Tue, 10 Sep 2024 17:49:01 GMT  
		Size: 1.5 GB (1462192413 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:3445b497121718058765c341117a0c1522c51cd65bec8c517981a745ff91f0bf`  
		Last Modified: Tue, 08 Oct 2024 17:56:28 GMT  
		Size: 337.1 MB (337149137 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:b46714dd69a6f02f88bc3db5973209a943225f949258f4851b645bdd53bb5513`  
		Last Modified: Sat, 26 Oct 2024 00:00:26 GMT  
		Size: 1.3 KB (1287 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:b24fe5a0311dd018fde305be78143e7c22cfe475322c90e67bcc2ebf4f4d5d92`  
		Last Modified: Sat, 26 Oct 2024 00:00:26 GMT  
		Size: 1.4 KB (1366 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:d1c3056a2d3a0584bc64812c783e62e0783c6ea357a52cb9461f8f7ef93fc6dd`  
		Last Modified: Sat, 26 Oct 2024 00:00:26 GMT  
		Size: 1.4 KB (1384 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:eee99c0e82f169a1526db7b07a246900bebf740dec34e18d5f119b3af264a88f`  
		Last Modified: Sat, 26 Oct 2024 00:00:25 GMT  
		Size: 1.4 KB (1351 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:6e40c408a2ed5d34be18a4315c19bc7d0d644151a5e7d2f8a3f971093f69e231`  
		Last Modified: Sat, 26 Oct 2024 00:01:12 GMT  
		Size: 611.5 MB (611543446 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:e84698b6ebc540897c6c6dcd98be546fc413452e038d6150dcf28ddba2f945d3`  
		Last Modified: Sat, 26 Oct 2024 00:00:25 GMT  
		Size: 1.3 KB (1308 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:1e5b62e93d6b9a5c16ae98bc316e8a08a5ce5aa73e32b90b2ba63a50602c60fd`  
		Last Modified: Sat, 26 Oct 2024 00:00:25 GMT  
		Size: 1.3 KB (1290 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:646505fe6d6f20072df2db4b6e8b02bc16d7c28e0c1c4b3ed86001a12b80012d`  
		Last Modified: Sat, 26 Oct 2024 00:00:25 GMT  
		Size: 1.3 KB (1284 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip

### `mongo:7-windowsservercore` - windows version 10.0.17763.6414; amd64

```console
$ docker pull mongo@sha256:83350c6d383bd00af1d7a72545c76906139ef0e4ad59cd4ce9e45444fb3395e7
```

-	Docker Version: 26.1.3
-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **2.5 GB (2513418695 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:8acb8f848422513ae0cb9ead9ff5fe468ab6b4ea21c5d537c8707f8fd67ead4f`
-	Default Command: `["mongod","--bind_ip_all"]`
-	`SHELL`: `["powershell","-Command","$ErrorActionPreference = 'Stop';"]`

```dockerfile
# Fri, 06 Sep 2024 01:15:31 GMT
RUN Apply image 10.0.17763.6293
# Fri, 04 Oct 2024 21:48:44 GMT
RUN Install update 10.0.17763.6414
# Fri, 25 Oct 2024 23:57:17 GMT
SHELL [powershell -Command $ErrorActionPreference = 'Stop';]
# Fri, 25 Oct 2024 23:57:19 GMT
ENV MONGO_VERSION=7.0.15
# Fri, 25 Oct 2024 23:57:20 GMT
ENV MONGO_DOWNLOAD_URL=https://fastdl.mongodb.org/windows/mongodb-windows-x86_64-7.0.15-signed.msi
# Fri, 25 Oct 2024 23:57:20 GMT
ENV MONGO_DOWNLOAD_SHA256=db61d1e382ab03ee98dcef1a65c4065efc4eb9eba2733852828670cfce23db3e
# Sat, 26 Oct 2024 00:00:48 GMT
RUN Write-Host ('Downloading {0} ...' -f $env:MONGO_DOWNLOAD_URL); 	[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; 	(New-Object System.Net.WebClient).DownloadFile($env:MONGO_DOWNLOAD_URL, 'mongo.msi'); 		if ($env:MONGO_DOWNLOAD_SHA256) { 		Write-Host ('Verifying sha256 ({0}) ...' -f $env:MONGO_DOWNLOAD_SHA256); 		if ((Get-FileHash mongo.msi -Algorithm sha256).Hash -ne $env:MONGO_DOWNLOAD_SHA256) { 			Write-Host 'FAILED!'; 			exit 1; 		}; 	}; 		Write-Host 'Installing ...'; 	Start-Process msiexec -Wait 		-ArgumentList @( 			'/i', 			'mongo.msi', 			'/quiet', 			'/qn', 			'/l*v', 'install.log', 			'INSTALLLOCATION=C:\mongodb', 			'ADDLOCAL=MiscellaneousTools,Router,ServerNoService' 		); 	if (-Not (Test-Path C:\mongodb\bin\mongod.exe -PathType Leaf)) { 		Write-Host 'Installer failed!'; 		Get-Content install.log; 		exit 1; 	}; 	Remove-Item install.log; 		$env:PATH = 'C:\mongodb\bin;' + $env:PATH; 	[Environment]::SetEnvironmentVariable('PATH', $env:PATH, [EnvironmentVariableTarget]::Machine); 		Write-Host 'Verifying install ...'; 	Write-Host '  mongod --version'; mongod --version; 		Write-Host 'Removing ...'; 	Remove-Item C:\windows\installer\*.msi -Force; 	Remove-Item mongo.msi -Force; 		Write-Host 'Complete.';
# Sat, 26 Oct 2024 00:00:49 GMT
VOLUME [C:\data\db C:\data\configdb]
# Sat, 26 Oct 2024 00:00:49 GMT
EXPOSE 27017
# Sat, 26 Oct 2024 00:00:50 GMT
CMD ["mongod" "--bind_ip_all"]
```

-	Layers:
	-	`sha256:803f4a9590cb9c635813cbd0ee89190f92d5fe4c7589711cf468879e42ce02ba`  
		Last Modified: Tue, 10 Sep 2024 17:55:31 GMT  
		Size: 1.7 GB (1720268357 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:eec1ab8e4a3936959c2381d3aaa9aaf9caf01f82fb701f2b4c3cc3dbf6d035dd`  
		Last Modified: Tue, 08 Oct 2024 17:36:07 GMT  
		Size: 181.6 MB (181556913 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:cc5b0ec16b3f1b54bc7aa00454db788c9b86591d6661f576639b13cb7174c6a2`  
		Last Modified: Sat, 26 Oct 2024 00:00:54 GMT  
		Size: 1.3 KB (1299 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:9336b4fb3b5eac48895c8526c6267b84ea241de1bff23a91f66d6a58861806b1`  
		Last Modified: Sat, 26 Oct 2024 00:00:54 GMT  
		Size: 1.3 KB (1293 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:375b24d07b09ac6c082164b7e8aa6da60cf7cf356619c96812bf56b80567eb70`  
		Last Modified: Sat, 26 Oct 2024 00:00:54 GMT  
		Size: 1.3 KB (1300 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:daa4f8e9ca02a6319670b10f10a75175507abbd0afb54540b168bc68eb28ad18`  
		Last Modified: Sat, 26 Oct 2024 00:00:53 GMT  
		Size: 1.3 KB (1297 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:5a6ebf27cdbb69609004e8a3a8ad9524524027bee4e39ad796a51ac415bf0548`  
		Last Modified: Sat, 26 Oct 2024 00:01:39 GMT  
		Size: 611.6 MB (611584342 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:ac300f7ff0ba41f3a5bf32ff0ba2abf3f19c91e076955c9f166d3937a92f7676`  
		Last Modified: Sat, 26 Oct 2024 00:00:53 GMT  
		Size: 1.3 KB (1295 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:ecc1bf7db78fdea03db2cdce8efac62829b0b36e77094d819f0898ede479b604`  
		Last Modified: Sat, 26 Oct 2024 00:00:53 GMT  
		Size: 1.3 KB (1299 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:fd3ddf9dcc1af135be636758b629e2072fc7d9ebfa22cbb285a2891a6f903bc5`  
		Last Modified: Sat, 26 Oct 2024 00:00:53 GMT  
		Size: 1.3 KB (1300 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
