## `mongo:5-windowsservercore`

```console
$ docker pull mongo@sha256:17d35b7d5b66be3ed40d9b35274921c57f404db05d5407dd08aaa3a92702876c
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.list.v2+json`
-	Platforms: 2
	-	windows version 10.0.20348.2762; amd64
	-	windows version 10.0.17763.6414; amd64

### `mongo:5-windowsservercore` - windows version 10.0.20348.2762; amd64

```console
$ docker pull mongo@sha256:22d64649814f57a369c76ec67b947cce0086f59ab63a39315ad36759c5278935
```

-	Docker Version: 26.1.3
-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **2.1 GB (2112868106 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:a6884d9b658edf2463f6bfda270fae9effbe0225050f0b230c9f4d3fc4aec7c9`
-	Default Command: `["mongod","--bind_ip_all"]`
-	`SHELL`: `["powershell","-Command","$ErrorActionPreference = 'Stop';"]`

```dockerfile
# Fri, 06 Sep 2024 00:01:38 GMT
RUN Apply image 10.0.20348.2700
# Sun, 06 Oct 2024 04:56:48 GMT
RUN Install update 10.0.20348.2762
# Fri, 25 Oct 2024 23:57:08 GMT
SHELL [powershell -Command $ErrorActionPreference = 'Stop';]
# Fri, 25 Oct 2024 23:57:09 GMT
ENV MONGO_VERSION=5.0.30
# Fri, 25 Oct 2024 23:57:10 GMT
ENV MONGO_DOWNLOAD_URL=https://fastdl.mongodb.org/windows/mongodb-windows-x86_64-5.0.30-signed.msi
# Fri, 25 Oct 2024 23:57:11 GMT
ENV MONGO_DOWNLOAD_SHA256=acabc07cba2e1b4a8bc2a852715a21ca29cae0f08a0dc157d54c1049f586fe45
# Fri, 25 Oct 2024 23:58:09 GMT
RUN Write-Host ('Downloading {0} ...' -f $env:MONGO_DOWNLOAD_URL); 	[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; 	(New-Object System.Net.WebClient).DownloadFile($env:MONGO_DOWNLOAD_URL, 'mongo.msi'); 		if ($env:MONGO_DOWNLOAD_SHA256) { 		Write-Host ('Verifying sha256 ({0}) ...' -f $env:MONGO_DOWNLOAD_SHA256); 		if ((Get-FileHash mongo.msi -Algorithm sha256).Hash -ne $env:MONGO_DOWNLOAD_SHA256) { 			Write-Host 'FAILED!'; 			exit 1; 		}; 	}; 		Write-Host 'Installing ...'; 	Start-Process msiexec -Wait 		-ArgumentList @( 			'/i', 			'mongo.msi', 			'/quiet', 			'/qn', 			'/l*v', 'install.log', 			'INSTALLLOCATION=C:\mongodb', 			'ADDLOCAL=Client,MiscellaneousTools,Router,ServerNoService' 		); 	if (-Not (Test-Path C:\mongodb\bin\mongod.exe -PathType Leaf)) { 		Write-Host 'Installer failed!'; 		Get-Content install.log; 		exit 1; 	}; 	Remove-Item install.log; 		$env:PATH = 'C:\mongodb\bin;' + $env:PATH; 	[Environment]::SetEnvironmentVariable('PATH', $env:PATH, [EnvironmentVariableTarget]::Machine); 		Write-Host 'Verifying install ...'; 	Write-Host '  mongo --version'; mongo --version; 	Write-Host '  mongod --version'; mongod --version; 		Write-Host 'Removing ...'; 	Remove-Item C:\windows\installer\*.msi -Force; 	Remove-Item mongo.msi -Force; 		Write-Host 'Complete.';
# Fri, 25 Oct 2024 23:58:10 GMT
VOLUME [C:\data\db C:\data\configdb]
# Fri, 25 Oct 2024 23:58:11 GMT
EXPOSE 27017
# Fri, 25 Oct 2024 23:58:12 GMT
CMD ["mongod" "--bind_ip_all"]
```

-	Layers:
	-	`sha256:2534953f34d35976fc44cd67bfdd39fdcd9e2eaae57ada0be53d5fb936cd3a0b`  
		Last Modified: Tue, 10 Sep 2024 17:49:01 GMT  
		Size: 1.5 GB (1462192413 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:3445b497121718058765c341117a0c1522c51cd65bec8c517981a745ff91f0bf`  
		Last Modified: Tue, 08 Oct 2024 17:56:28 GMT  
		Size: 337.1 MB (337149137 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:3c4d65be000c868485b137f8e870b2cfb21729bfb6d1e244807ca6d8bd64b5e6`  
		Last Modified: Fri, 25 Oct 2024 23:58:18 GMT  
		Size: 1.3 KB (1288 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:cbc3e78325a2ce0bee655f7fd84f5a9cd18af52d5995181f57377fa9b72ba0e7`  
		Last Modified: Fri, 25 Oct 2024 23:58:18 GMT  
		Size: 1.3 KB (1280 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:2f9006c2a11bfd3d5a2ca8a6d9959e1390b86ea67b83ca0fa6dd133d1e3c6afd`  
		Last Modified: Fri, 25 Oct 2024 23:58:17 GMT  
		Size: 1.3 KB (1279 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:41779c4c0cdef969daa3db5bea57c6f189f5c52e6cbd7e29b1c46eaebe488540`  
		Last Modified: Fri, 25 Oct 2024 23:58:16 GMT  
		Size: 1.3 KB (1281 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:833e2d09309df3b4d4a0e84110ddc1244c2cf3049b64727eaee42848f31d957e`  
		Last Modified: Fri, 25 Oct 2024 23:58:45 GMT  
		Size: 313.5 MB (313517579 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:4b117b9f5f20b2dbc3702a1ea121e807b0b0888149a11e5ae6b8f9f0780b2618`  
		Last Modified: Fri, 25 Oct 2024 23:58:16 GMT  
		Size: 1.3 KB (1283 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:a163917bdbdf7fb2d2a8ddff540a7a8b00c43fa58ae3c8872b809e6f9f97961b`  
		Last Modified: Fri, 25 Oct 2024 23:58:16 GMT  
		Size: 1.3 KB (1281 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:10dd4c041259ae4a8142b312a5a03849b06ee892f7352a2b0445a7b9790849a1`  
		Last Modified: Fri, 25 Oct 2024 23:58:16 GMT  
		Size: 1.3 KB (1285 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip

### `mongo:5-windowsservercore` - windows version 10.0.17763.6414; amd64

```console
$ docker pull mongo@sha256:2d3d1687438a61316704cb7713334551718a2136bb0f32d56696d813e50120c7
```

-	Docker Version: 26.1.3
-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **2.2 GB (2215368927 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:ee898891e16726acfed574db2babadaa8cda43577d31e345ec20124c7b8ba669`
-	Default Command: `["mongod","--bind_ip_all"]`
-	`SHELL`: `["powershell","-Command","$ErrorActionPreference = 'Stop';"]`

```dockerfile
# Fri, 06 Sep 2024 01:15:31 GMT
RUN Apply image 10.0.17763.6293
# Fri, 04 Oct 2024 21:48:44 GMT
RUN Install update 10.0.17763.6414
# Fri, 25 Oct 2024 23:57:33 GMT
SHELL [powershell -Command $ErrorActionPreference = 'Stop';]
# Fri, 25 Oct 2024 23:57:36 GMT
ENV MONGO_VERSION=5.0.30
# Fri, 25 Oct 2024 23:57:36 GMT
ENV MONGO_DOWNLOAD_URL=https://fastdl.mongodb.org/windows/mongodb-windows-x86_64-5.0.30-signed.msi
# Fri, 25 Oct 2024 23:57:37 GMT
ENV MONGO_DOWNLOAD_SHA256=acabc07cba2e1b4a8bc2a852715a21ca29cae0f08a0dc157d54c1049f586fe45
# Sat, 26 Oct 2024 00:01:47 GMT
RUN Write-Host ('Downloading {0} ...' -f $env:MONGO_DOWNLOAD_URL); 	[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; 	(New-Object System.Net.WebClient).DownloadFile($env:MONGO_DOWNLOAD_URL, 'mongo.msi'); 		if ($env:MONGO_DOWNLOAD_SHA256) { 		Write-Host ('Verifying sha256 ({0}) ...' -f $env:MONGO_DOWNLOAD_SHA256); 		if ((Get-FileHash mongo.msi -Algorithm sha256).Hash -ne $env:MONGO_DOWNLOAD_SHA256) { 			Write-Host 'FAILED!'; 			exit 1; 		}; 	}; 		Write-Host 'Installing ...'; 	Start-Process msiexec -Wait 		-ArgumentList @( 			'/i', 			'mongo.msi', 			'/quiet', 			'/qn', 			'/l*v', 'install.log', 			'INSTALLLOCATION=C:\mongodb', 			'ADDLOCAL=Client,MiscellaneousTools,Router,ServerNoService' 		); 	if (-Not (Test-Path C:\mongodb\bin\mongod.exe -PathType Leaf)) { 		Write-Host 'Installer failed!'; 		Get-Content install.log; 		exit 1; 	}; 	Remove-Item install.log; 		$env:PATH = 'C:\mongodb\bin;' + $env:PATH; 	[Environment]::SetEnvironmentVariable('PATH', $env:PATH, [EnvironmentVariableTarget]::Machine); 		Write-Host 'Verifying install ...'; 	Write-Host '  mongo --version'; mongo --version; 	Write-Host '  mongod --version'; mongod --version; 		Write-Host 'Removing ...'; 	Remove-Item C:\windows\installer\*.msi -Force; 	Remove-Item mongo.msi -Force; 		Write-Host 'Complete.';
# Sat, 26 Oct 2024 00:01:49 GMT
VOLUME [C:\data\db C:\data\configdb]
# Sat, 26 Oct 2024 00:01:50 GMT
EXPOSE 27017
# Sat, 26 Oct 2024 00:01:50 GMT
CMD ["mongod" "--bind_ip_all"]
```

-	Layers:
	-	`sha256:803f4a9590cb9c635813cbd0ee89190f92d5fe4c7589711cf468879e42ce02ba`  
		Last Modified: Tue, 10 Sep 2024 17:55:31 GMT  
		Size: 1.7 GB (1720268357 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:eec1ab8e4a3936959c2381d3aaa9aaf9caf01f82fb701f2b4c3cc3dbf6d035dd`  
		Last Modified: Tue, 08 Oct 2024 17:36:07 GMT  
		Size: 181.6 MB (181556913 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:0e876557926374c8533496b12f56120728257f88ca4d67acdcc1c463b04d76d9`  
		Last Modified: Sat, 26 Oct 2024 00:01:54 GMT  
		Size: 1.3 KB (1291 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:caf12bbf44da747a68331cf25f190ae2d78a1f7ac96f7a3303124201d6734e79`  
		Last Modified: Sat, 26 Oct 2024 00:01:54 GMT  
		Size: 1.4 KB (1370 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:28969065992a8a8f8ae35bc585a19fa700c26501b4dd385654a2eff2bd4c4c9e`  
		Last Modified: Sat, 26 Oct 2024 00:01:54 GMT  
		Size: 1.3 KB (1295 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:f7066117f046227fd5bf4023ad366518bd5e94ff04737baea28ef1ae97cee3e2`  
		Last Modified: Sat, 26 Oct 2024 00:01:53 GMT  
		Size: 1.4 KB (1353 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:04d040241c182c110c3b9269055370c7750a364dccb0f73f9cb5c2c29612ebd3`  
		Last Modified: Sat, 26 Oct 2024 00:02:22 GMT  
		Size: 313.5 MB (313534440 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:d087048ebbd0c70b3a2192de13bdd727fb0acc3bca23eba7d74927f89b112f9e`  
		Last Modified: Sat, 26 Oct 2024 00:01:53 GMT  
		Size: 1.3 KB (1304 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:672bb33a915c18b5593e038ef90036deb7a7cf22571bf023faac5fd5725c92e5`  
		Last Modified: Sat, 26 Oct 2024 00:01:53 GMT  
		Size: 1.3 KB (1304 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:0613a9c55337d82e0f904047e710e428de2ab65962084b5b2498ae165528e75f`  
		Last Modified: Sat, 26 Oct 2024 00:01:53 GMT  
		Size: 1.3 KB (1300 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
