## `mariadb:11.5`

```console
$ docker pull mariadb@sha256:4a1de8fa2a929944373d7421105500ff6f889ce90dcb883fbb2fdb070e4d427e
```

-	Manifest MIME: `application/vnd.oci.image.index.v1+json`
-	Platforms: 8
	-	linux; amd64
	-	unknown; unknown
	-	linux; arm64 variant v8
	-	unknown; unknown
	-	linux; ppc64le
	-	unknown; unknown
	-	linux; s390x
	-	unknown; unknown

### `mariadb:11.5` - linux; amd64

```console
$ docker pull mariadb@sha256:ffa476c95395cd3b4eb869267744494a9d0926308102070c8bd1367cefbb1842
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **122.6 MB (122604886 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:4b8711c6c639fa9166e6a617c421e2fc43296c8add9a846fe8237b8ac9184d51`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mariadbd"]`

```dockerfile
# Tue, 03 Sep 2024 02:32:52 GMT
ARG RELEASE
# Tue, 03 Sep 2024 02:32:52 GMT
ARG LAUNCHPAD_BUILD_ARCH
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL org.opencontainers.image.ref.name=ubuntu
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL org.opencontainers.image.version=24.04
# Tue, 03 Sep 2024 02:32:52 GMT
ADD file:34dc4f3ab7a694ecde47ff7a610be18591834c45f1d7251813267798412604e5 in / 
# Tue, 03 Sep 2024 02:32:52 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:32:52 GMT
RUN groupadd -r mysql && useradd -r -g mysql mysql --home-dir /var/lib/mysql && userdel --remove ubuntu # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:32:52 GMT
ARG GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN set -eux; 	apt-get update; 	DEBIAN_FRONTEND=noninteractive apt-get install -y --no-install-recommends 		ca-certificates 		gpg 		gpgv 		libjemalloc2 		pwgen 		tzdata 		xz-utils 		zstd ; 	savedAptMark="$(apt-mark showmanual)"; 	apt-get install -y --no-install-recommends 		dirmngr 		gpg-agent 		wget; 	rm -rf /var/lib/apt/lists/*; 	dpkgArch="$(dpkg --print-architecture | awk -F- '{ print $NF }')"; 	wget -q -O /usr/local/bin/gosu "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch"; 	wget -q -O /usr/local/bin/gosu.asc "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch.asc"; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	for key in $GPG_KEYS; do 		gpg --batch --keyserver keyserver.ubuntu.com --recv-keys "$key"; 	done; 	gpg --batch --export "$GPG_KEYS" > /etc/apt/trusted.gpg.d/mariadb.gpg; 	if command -v gpgconf >/dev/null; then 		gpgconf --kill all; 	fi; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	apt-mark auto '.*' > /dev/null; 	[ -z "$savedAptMark" ] ||	apt-mark manual $savedAptMark >/dev/null; 	apt-get purge -y --auto-remove -o APT::AutoRemove::RecommendsImportant=false; 	chmod +x /usr/local/bin/gosu; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
ENV LANG=C.UTF-8
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/library/ubuntu:noble org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=11.5.2 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:32:52 GMT
ARG MARIADB_VERSION=1:11.5.2+maria~ubu2404
# Tue, 03 Sep 2024 02:32:52 GMT
ENV MARIADB_VERSION=1:11.5.2+maria~ubu2404
# Tue, 03 Sep 2024 02:32:52 GMT
ARG REPOSITORY=http://archive.mariadb.org/mariadb-11.5.2/repo/ubuntu/ noble main main/debug
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:11.5.2+maria~ubu2404 REPOSITORY=http://archive.mariadb.org/mariadb-11.5.2/repo/ubuntu/ noble main main/debug
RUN set -e;	echo "deb ${REPOSITORY}" > /etc/apt/sources.list.d/mariadb.list; 	{ 		echo 'Package: *'; 		echo 'Pin: release o=MariaDB'; 		echo 'Pin-Priority: 999'; 	} > /etc/apt/preferences.d/mariadb # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:11.5.2+maria~ubu2404 REPOSITORY=http://archive.mariadb.org/mariadb-11.5.2/repo/ubuntu/ noble main main/debug
RUN set -ex; 	{ 		echo "mariadb-server" mysql-server/root_password password 'unused'; 		echo "mariadb-server" mysql-server/root_password_again password 'unused'; 	} | debconf-set-selections; 	apt-get update; 	mkdir -p /var/lib/mysql/mysql ; touch /var/lib/mysql/mysql/user.frm ; 	apt-get install -y --no-install-recommends mariadb-server="$MARIADB_VERSION" mariadb-backup socat 	; 	rm -rf /var/lib/apt/lists/*; 	rm -rf /var/lib/mysql; 	mkdir -p /var/lib/mysql /run/mysqld; 	chown -R mysql:mysql /var/lib/mysql /run/mysqld; 	chmod 1777 /run/mysqld; 	find /etc/mysql/ -name '*.cnf' -print0 		| xargs -0 grep -lZE '^(bind-address|log|user\s)' 		| xargs -rt -0 sed -Ei 's/^(bind-address|log|user\s)/#&/'; 	printf "[mariadb]\nhost-cache-size=0\nskip-name-resolve\n" > /etc/mysql/mariadb.conf.d/05-skipcache.cnf; 	if [ -L /etc/mysql/my.cnf ]; then 		sed -i -e '/includedir/ {N;s/\(.*\)\n\(.*\)/\n\2\n\1/}' /etc/mysql/mariadb.cnf; 	fi # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:32:52 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:32:52 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:32:52 GMT
CMD ["mariadbd"]
```

-	Layers:
	-	`sha256:ff65ddf9395be21bfe1f320b7705e539ee44c1053034f801b1a3cbbf2d0f4056`  
		Last Modified: Fri, 11 Oct 2024 05:07:18 GMT  
		Size: 29.8 MB (29750363 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:60bf5e4921ebf40cdeb9808d25882e73722afca373a3b3f38ecf24f105d817ea`  
		Last Modified: Wed, 16 Oct 2024 16:13:53 GMT  
		Size: 1.3 KB (1341 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:d4d47b8d6ea097dcf6c6d64ef12fa26e71fd141d72991e8fd24229b45c708c6b`  
		Last Modified: Wed, 16 Oct 2024 16:13:54 GMT  
		Size: 5.4 MB (5350058 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:e38fc7e50f91c37a0d822eeee9b8edc4a8fc386ca6db4709ec73ffdc15b1f52e`  
		Last Modified: Wed, 16 Oct 2024 16:13:54 GMT  
		Size: 116.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:725acd03a3bc5090a20483353b8e4cd62df0a69d49d852ee5201a85b8622a092`  
		Last Modified: Wed, 16 Oct 2024 16:13:54 GMT  
		Size: 329.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:db106334738c626481137264559382cb5bd33a57bd8ae1a08abc4190af7719fb`  
		Last Modified: Wed, 16 Oct 2024 16:13:55 GMT  
		Size: 87.5 MB (87490280 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:234171a3de7d7b4a5b3db938740204e157ec3d0d0ab13db1a9f7037f150d62d3`  
		Last Modified: Wed, 16 Oct 2024 16:13:54 GMT  
		Size: 4.0 KB (3977 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:25efdea61d9c3a2a5455155d0ccf1fea3169802cae37cfa5bb07cb5708716961`  
		Last Modified: Wed, 16 Oct 2024 16:13:54 GMT  
		Size: 8.4 KB (8422 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:11.5` - unknown; unknown

```console
$ docker pull mariadb@sha256:0c3c4577a5337b2c040366cd982381b8e548a60db18b96919e5d986e7043b051
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.1 MB (4094249 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:f886e9c1f8bdb7a565d152e264d617b485c821b8c5df970125d719ed45ce476f`

```dockerfile
```

-	Layers:
	-	`sha256:25b45a7303110fa1f8b3d06f2a9d34f679ba6094afbe7d769e358003a3e20e07`  
		Last Modified: Wed, 16 Oct 2024 16:13:54 GMT  
		Size: 4.1 MB (4063237 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:0c97256e9bd18692b00ba9ba8cc309f268010740e1762e2ae3fd73786b217081`  
		Last Modified: Wed, 16 Oct 2024 16:13:54 GMT  
		Size: 31.0 KB (31012 bytes)  
		MIME: application/vnd.in-toto+json

### `mariadb:11.5` - linux; arm64 variant v8

```console
$ docker pull mariadb@sha256:7192e92c5a05ddfe510408478e93817270094ff870dd13191da3042058b96595
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **120.6 MB (120591261 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:85b6807bea6596cc1317c2e8f339b445d6b76238a59364c684a5a3f2ecb7aeb0`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mariadbd"]`

```dockerfile
# Tue, 03 Sep 2024 02:32:52 GMT
ARG RELEASE
# Tue, 03 Sep 2024 02:32:52 GMT
ARG LAUNCHPAD_BUILD_ARCH
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL org.opencontainers.image.ref.name=ubuntu
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL org.opencontainers.image.version=24.04
# Tue, 03 Sep 2024 02:32:52 GMT
ADD file:b14427a5ec8028ba993a0ff27f9e398456229f9113c9c39f3cc7a0f96c15943b in / 
# Tue, 03 Sep 2024 02:32:52 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:32:52 GMT
RUN groupadd -r mysql && useradd -r -g mysql mysql --home-dir /var/lib/mysql && userdel --remove ubuntu # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:32:52 GMT
ARG GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN set -eux; 	apt-get update; 	DEBIAN_FRONTEND=noninteractive apt-get install -y --no-install-recommends 		ca-certificates 		gpg 		gpgv 		libjemalloc2 		pwgen 		tzdata 		xz-utils 		zstd ; 	savedAptMark="$(apt-mark showmanual)"; 	apt-get install -y --no-install-recommends 		dirmngr 		gpg-agent 		wget; 	rm -rf /var/lib/apt/lists/*; 	dpkgArch="$(dpkg --print-architecture | awk -F- '{ print $NF }')"; 	wget -q -O /usr/local/bin/gosu "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch"; 	wget -q -O /usr/local/bin/gosu.asc "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch.asc"; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	for key in $GPG_KEYS; do 		gpg --batch --keyserver keyserver.ubuntu.com --recv-keys "$key"; 	done; 	gpg --batch --export "$GPG_KEYS" > /etc/apt/trusted.gpg.d/mariadb.gpg; 	if command -v gpgconf >/dev/null; then 		gpgconf --kill all; 	fi; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	apt-mark auto '.*' > /dev/null; 	[ -z "$savedAptMark" ] ||	apt-mark manual $savedAptMark >/dev/null; 	apt-get purge -y --auto-remove -o APT::AutoRemove::RecommendsImportant=false; 	chmod +x /usr/local/bin/gosu; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
ENV LANG=C.UTF-8
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/library/ubuntu:noble org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=11.5.2 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:32:52 GMT
ARG MARIADB_VERSION=1:11.5.2+maria~ubu2404
# Tue, 03 Sep 2024 02:32:52 GMT
ENV MARIADB_VERSION=1:11.5.2+maria~ubu2404
# Tue, 03 Sep 2024 02:32:52 GMT
ARG REPOSITORY=http://archive.mariadb.org/mariadb-11.5.2/repo/ubuntu/ noble main main/debug
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:11.5.2+maria~ubu2404 REPOSITORY=http://archive.mariadb.org/mariadb-11.5.2/repo/ubuntu/ noble main main/debug
RUN set -e;	echo "deb ${REPOSITORY}" > /etc/apt/sources.list.d/mariadb.list; 	{ 		echo 'Package: *'; 		echo 'Pin: release o=MariaDB'; 		echo 'Pin-Priority: 999'; 	} > /etc/apt/preferences.d/mariadb # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:11.5.2+maria~ubu2404 REPOSITORY=http://archive.mariadb.org/mariadb-11.5.2/repo/ubuntu/ noble main main/debug
RUN set -ex; 	{ 		echo "mariadb-server" mysql-server/root_password password 'unused'; 		echo "mariadb-server" mysql-server/root_password_again password 'unused'; 	} | debconf-set-selections; 	apt-get update; 	mkdir -p /var/lib/mysql/mysql ; touch /var/lib/mysql/mysql/user.frm ; 	apt-get install -y --no-install-recommends mariadb-server="$MARIADB_VERSION" mariadb-backup socat 	; 	rm -rf /var/lib/apt/lists/*; 	rm -rf /var/lib/mysql; 	mkdir -p /var/lib/mysql /run/mysqld; 	chown -R mysql:mysql /var/lib/mysql /run/mysqld; 	chmod 1777 /run/mysqld; 	find /etc/mysql/ -name '*.cnf' -print0 		| xargs -0 grep -lZE '^(bind-address|log|user\s)' 		| xargs -rt -0 sed -Ei 's/^(bind-address|log|user\s)/#&/'; 	printf "[mariadb]\nhost-cache-size=0\nskip-name-resolve\n" > /etc/mysql/mariadb.conf.d/05-skipcache.cnf; 	if [ -L /etc/mysql/my.cnf ]; then 		sed -i -e '/includedir/ {N;s/\(.*\)\n\(.*\)/\n\2\n\1/}' /etc/mysql/mariadb.cnf; 	fi # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:32:52 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:32:52 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:32:52 GMT
CMD ["mariadbd"]
```

-	Layers:
	-	`sha256:1f630473117188fe348ebdcf0da5e93138275af14007f15baf79967a365e647a`  
		Last Modified: Fri, 11 Oct 2024 05:07:24 GMT  
		Size: 28.9 MB (28885845 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:d0a18beac8bf04f087d717d716e2b59d2f6a5a23c6b7285576b6aa7fcecdff23`  
		Last Modified: Wed, 16 Oct 2024 03:39:45 GMT  
		Size: 1.3 KB (1341 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:aca8a8e17e98bff1e99be4bd03184869c60d78c333ee9ece9e6fef6bcadfa5a1`  
		Last Modified: Wed, 16 Oct 2024 03:39:45 GMT  
		Size: 5.1 MB (5130756 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:9ffe471e6e02052443b2ce488c7efd321827b265cbf6a86f8f5e909aa0bff39f`  
		Last Modified: Wed, 16 Oct 2024 03:39:45 GMT  
		Size: 116.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:53eca382844fb406cd552868cbb949dc14709d4173a26a61ae3cf00904143045`  
		Last Modified: Wed, 16 Oct 2024 03:40:34 GMT  
		Size: 332.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:a287069788e579bee59a38b93f90c702f9cf990306041adcb7513def2b043366`  
		Last Modified: Wed, 16 Oct 2024 03:40:37 GMT  
		Size: 86.6 MB (86560475 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:2575bdc3586efb488445cd88a33b2b83fc8e37203d54e58719029994618478e3`  
		Last Modified: Wed, 16 Oct 2024 03:40:34 GMT  
		Size: 4.0 KB (3974 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:6ab219cecbc8403e1d74266abcd2b891856fd0c75a802310fd3f92e48bc5beb2`  
		Last Modified: Wed, 16 Oct 2024 03:40:35 GMT  
		Size: 8.4 KB (8422 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:11.5` - unknown; unknown

```console
$ docker pull mariadb@sha256:efac3259f0d8c087abb7f56431f586fd32fa2451eff5947c83228b7406f34ae5
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.1 MB (4101734 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:21dc72bcb1cd687a5141723ff0120b8f46953ff96ccf26e537e6e157f7d422e5`

```dockerfile
```

-	Layers:
	-	`sha256:9f851bb280cc80f2363fb328c5d63052cbd466e3e558a5acd687947b43d412a8`  
		Last Modified: Wed, 16 Oct 2024 03:40:35 GMT  
		Size: 4.1 MB (4070516 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:084bc5ce34b3ca42f0c72a2486f7da98fe2d9b7eb75d4768271df986b4041bed`  
		Last Modified: Wed, 16 Oct 2024 03:40:34 GMT  
		Size: 31.2 KB (31218 bytes)  
		MIME: application/vnd.in-toto+json

### `mariadb:11.5` - linux; ppc64le

```console
$ docker pull mariadb@sha256:e4fc534bc748f3e8f7902db45587e58af179697386936d475be5ed263f40d87d
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **133.3 MB (133267114 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:66a76a4d60b5521f8f11711218aebeb331164d53552131ef6e643c2b8e16f5e2`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mariadbd"]`

```dockerfile
# Tue, 03 Sep 2024 02:32:52 GMT
ARG RELEASE
# Tue, 03 Sep 2024 02:32:52 GMT
ARG LAUNCHPAD_BUILD_ARCH
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL org.opencontainers.image.ref.name=ubuntu
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL org.opencontainers.image.version=24.04
# Tue, 03 Sep 2024 02:32:52 GMT
ADD file:536f7d2a284525103973196c539c45f59251ee1d6bbd34f1d92ff9d6187da127 in / 
# Tue, 03 Sep 2024 02:32:52 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:32:52 GMT
RUN groupadd -r mysql && useradd -r -g mysql mysql --home-dir /var/lib/mysql && userdel --remove ubuntu # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:32:52 GMT
ARG GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN set -eux; 	apt-get update; 	DEBIAN_FRONTEND=noninteractive apt-get install -y --no-install-recommends 		ca-certificates 		gpg 		gpgv 		libjemalloc2 		pwgen 		tzdata 		xz-utils 		zstd ; 	savedAptMark="$(apt-mark showmanual)"; 	apt-get install -y --no-install-recommends 		dirmngr 		gpg-agent 		wget; 	rm -rf /var/lib/apt/lists/*; 	dpkgArch="$(dpkg --print-architecture | awk -F- '{ print $NF }')"; 	wget -q -O /usr/local/bin/gosu "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch"; 	wget -q -O /usr/local/bin/gosu.asc "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch.asc"; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	for key in $GPG_KEYS; do 		gpg --batch --keyserver keyserver.ubuntu.com --recv-keys "$key"; 	done; 	gpg --batch --export "$GPG_KEYS" > /etc/apt/trusted.gpg.d/mariadb.gpg; 	if command -v gpgconf >/dev/null; then 		gpgconf --kill all; 	fi; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	apt-mark auto '.*' > /dev/null; 	[ -z "$savedAptMark" ] ||	apt-mark manual $savedAptMark >/dev/null; 	apt-get purge -y --auto-remove -o APT::AutoRemove::RecommendsImportant=false; 	chmod +x /usr/local/bin/gosu; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
ENV LANG=C.UTF-8
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/library/ubuntu:noble org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=11.5.2 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:32:52 GMT
ARG MARIADB_VERSION=1:11.5.2+maria~ubu2404
# Tue, 03 Sep 2024 02:32:52 GMT
ENV MARIADB_VERSION=1:11.5.2+maria~ubu2404
# Tue, 03 Sep 2024 02:32:52 GMT
ARG REPOSITORY=http://archive.mariadb.org/mariadb-11.5.2/repo/ubuntu/ noble main main/debug
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:11.5.2+maria~ubu2404 REPOSITORY=http://archive.mariadb.org/mariadb-11.5.2/repo/ubuntu/ noble main main/debug
RUN set -e;	echo "deb ${REPOSITORY}" > /etc/apt/sources.list.d/mariadb.list; 	{ 		echo 'Package: *'; 		echo 'Pin: release o=MariaDB'; 		echo 'Pin-Priority: 999'; 	} > /etc/apt/preferences.d/mariadb # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:11.5.2+maria~ubu2404 REPOSITORY=http://archive.mariadb.org/mariadb-11.5.2/repo/ubuntu/ noble main main/debug
RUN set -ex; 	{ 		echo "mariadb-server" mysql-server/root_password password 'unused'; 		echo "mariadb-server" mysql-server/root_password_again password 'unused'; 	} | debconf-set-selections; 	apt-get update; 	mkdir -p /var/lib/mysql/mysql ; touch /var/lib/mysql/mysql/user.frm ; 	apt-get install -y --no-install-recommends mariadb-server="$MARIADB_VERSION" mariadb-backup socat 	; 	rm -rf /var/lib/apt/lists/*; 	rm -rf /var/lib/mysql; 	mkdir -p /var/lib/mysql /run/mysqld; 	chown -R mysql:mysql /var/lib/mysql /run/mysqld; 	chmod 1777 /run/mysqld; 	find /etc/mysql/ -name '*.cnf' -print0 		| xargs -0 grep -lZE '^(bind-address|log|user\s)' 		| xargs -rt -0 sed -Ei 's/^(bind-address|log|user\s)/#&/'; 	printf "[mariadb]\nhost-cache-size=0\nskip-name-resolve\n" > /etc/mysql/mariadb.conf.d/05-skipcache.cnf; 	if [ -L /etc/mysql/my.cnf ]; then 		sed -i -e '/includedir/ {N;s/\(.*\)\n\(.*\)/\n\2\n\1/}' /etc/mysql/mariadb.cnf; 	fi # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:32:52 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:32:52 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:32:52 GMT
CMD ["mariadbd"]
```

-	Layers:
	-	`sha256:5f3161c1c329da2d67fc0650c9fd31e151f03956f8a0cb901012dc9bf6029cbc`  
		Last Modified: Fri, 11 Oct 2024 05:07:35 GMT  
		Size: 34.4 MB (34388969 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:5a71e43a077872aaaffaee71fcc32712258ee8efcd4b8a604e1f4163269c57fd`  
		Last Modified: Wed, 16 Oct 2024 02:11:28 GMT  
		Size: 1.3 KB (1347 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:027be017afa797ddf9d3e310843ae5b9c55c649868be4c3668f7dc1a8b72fa43`  
		Last Modified: Wed, 16 Oct 2024 02:11:29 GMT  
		Size: 5.9 MB (5937342 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:9606d82ab3b9bd6a6b59efaae885c79c055817363b9bca698af2a8ca3e72042f`  
		Last Modified: Wed, 16 Oct 2024 02:11:28 GMT  
		Size: 116.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:cc2386ddc09e083fc40825e0fbb92f26bd8010349b14cb7e211d5d644fe8be09`  
		Last Modified: Wed, 16 Oct 2024 02:12:42 GMT  
		Size: 332.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:9d6d7f6b77a0f799a23176a553547b40f5f9601c044e9e70e563601208778f29`  
		Last Modified: Wed, 16 Oct 2024 02:12:45 GMT  
		Size: 92.9 MB (92926609 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:04b8b757fb966cce2f3625a0f540496fa937abaea48d55c07f5518aa66a28a10`  
		Last Modified: Wed, 16 Oct 2024 02:12:42 GMT  
		Size: 4.0 KB (3977 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:460198408783e86de804dfce74bcb9cd187ca7c2598912c0be2240c6d99bf063`  
		Last Modified: Wed, 16 Oct 2024 02:12:42 GMT  
		Size: 8.4 KB (8422 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:11.5` - unknown; unknown

```console
$ docker pull mariadb@sha256:691295c967df42012aa9e95db677a0c6bdebe8b6cc946b035185f8082ecdc509
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.1 MB (4102067 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:b471ca76cd2f012327252dfcd981405ec70b2e2d9f7c7ea6acd6b7f8a7b410b6`

```dockerfile
```

-	Layers:
	-	`sha256:f3210baaa4ba4de15ac7408846f9992dd5d5cc7d241ac155441bfffecc54f46c`  
		Last Modified: Wed, 16 Oct 2024 02:12:42 GMT  
		Size: 4.1 MB (4070985 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:2865533745f07a7ae918ba5e2bd2d7fb85bf84c0e4b13db63147665e1f8f52ae`  
		Last Modified: Wed, 16 Oct 2024 02:12:42 GMT  
		Size: 31.1 KB (31082 bytes)  
		MIME: application/vnd.in-toto+json

### `mariadb:11.5` - linux; s390x

```console
$ docker pull mariadb@sha256:610b9086daa36faada6a0bdf913b930e57aa3ebdbbe5efbb722818ee73971082
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **129.4 MB (129402205 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:73d94d01a8248f8a5e43b112da8d6e46d6134efc9cf4b34faf6f9c117688f123`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mariadbd"]`

```dockerfile
# Tue, 03 Sep 2024 02:32:52 GMT
ARG RELEASE
# Tue, 03 Sep 2024 02:32:52 GMT
ARG LAUNCHPAD_BUILD_ARCH
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL org.opencontainers.image.ref.name=ubuntu
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL org.opencontainers.image.version=24.04
# Tue, 03 Sep 2024 02:32:52 GMT
ADD file:77ba16e2cf3c210906ec7587ab14314afc15cb73af4337fde69ac35187fdb263 in / 
# Tue, 03 Sep 2024 02:32:52 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:32:52 GMT
RUN groupadd -r mysql && useradd -r -g mysql mysql --home-dir /var/lib/mysql && userdel --remove ubuntu # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:32:52 GMT
ARG GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN set -eux; 	apt-get update; 	DEBIAN_FRONTEND=noninteractive apt-get install -y --no-install-recommends 		ca-certificates 		gpg 		gpgv 		libjemalloc2 		pwgen 		tzdata 		xz-utils 		zstd ; 	savedAptMark="$(apt-mark showmanual)"; 	apt-get install -y --no-install-recommends 		dirmngr 		gpg-agent 		wget; 	rm -rf /var/lib/apt/lists/*; 	dpkgArch="$(dpkg --print-architecture | awk -F- '{ print $NF }')"; 	wget -q -O /usr/local/bin/gosu "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch"; 	wget -q -O /usr/local/bin/gosu.asc "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch.asc"; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	for key in $GPG_KEYS; do 		gpg --batch --keyserver keyserver.ubuntu.com --recv-keys "$key"; 	done; 	gpg --batch --export "$GPG_KEYS" > /etc/apt/trusted.gpg.d/mariadb.gpg; 	if command -v gpgconf >/dev/null; then 		gpgconf --kill all; 	fi; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	apt-mark auto '.*' > /dev/null; 	[ -z "$savedAptMark" ] ||	apt-mark manual $savedAptMark >/dev/null; 	apt-get purge -y --auto-remove -o APT::AutoRemove::RecommendsImportant=false; 	chmod +x /usr/local/bin/gosu; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
ENV LANG=C.UTF-8
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/library/ubuntu:noble org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=11.5.2 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:32:52 GMT
ARG MARIADB_VERSION=1:11.5.2+maria~ubu2404
# Tue, 03 Sep 2024 02:32:52 GMT
ENV MARIADB_VERSION=1:11.5.2+maria~ubu2404
# Tue, 03 Sep 2024 02:32:52 GMT
ARG REPOSITORY=http://archive.mariadb.org/mariadb-11.5.2/repo/ubuntu/ noble main main/debug
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:11.5.2+maria~ubu2404 REPOSITORY=http://archive.mariadb.org/mariadb-11.5.2/repo/ubuntu/ noble main main/debug
RUN set -e;	echo "deb ${REPOSITORY}" > /etc/apt/sources.list.d/mariadb.list; 	{ 		echo 'Package: *'; 		echo 'Pin: release o=MariaDB'; 		echo 'Pin-Priority: 999'; 	} > /etc/apt/preferences.d/mariadb # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:11.5.2+maria~ubu2404 REPOSITORY=http://archive.mariadb.org/mariadb-11.5.2/repo/ubuntu/ noble main main/debug
RUN set -ex; 	{ 		echo "mariadb-server" mysql-server/root_password password 'unused'; 		echo "mariadb-server" mysql-server/root_password_again password 'unused'; 	} | debconf-set-selections; 	apt-get update; 	mkdir -p /var/lib/mysql/mysql ; touch /var/lib/mysql/mysql/user.frm ; 	apt-get install -y --no-install-recommends mariadb-server="$MARIADB_VERSION" mariadb-backup socat 	; 	rm -rf /var/lib/apt/lists/*; 	rm -rf /var/lib/mysql; 	mkdir -p /var/lib/mysql /run/mysqld; 	chown -R mysql:mysql /var/lib/mysql /run/mysqld; 	chmod 1777 /run/mysqld; 	find /etc/mysql/ -name '*.cnf' -print0 		| xargs -0 grep -lZE '^(bind-address|log|user\s)' 		| xargs -rt -0 sed -Ei 's/^(bind-address|log|user\s)/#&/'; 	printf "[mariadb]\nhost-cache-size=0\nskip-name-resolve\n" > /etc/mysql/mariadb.conf.d/05-skipcache.cnf; 	if [ -L /etc/mysql/my.cnf ]; then 		sed -i -e '/includedir/ {N;s/\(.*\)\n\(.*\)/\n\2\n\1/}' /etc/mysql/mariadb.cnf; 	fi # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:32:52 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:32:52 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:32:52 GMT
CMD ["mariadbd"]
```

-	Layers:
	-	`sha256:3d2abe11fb3bab133e95a31c3eeb04ba27eaed096cd5d4d3baeb8f12c3473633`  
		Last Modified: Fri, 11 Oct 2024 05:07:47 GMT  
		Size: 30.0 MB (30019614 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:3628b8c285e870f492cc7c126d57f76d57e89d8df7eda14af00fa149d6942159`  
		Last Modified: Wed, 16 Oct 2024 02:07:24 GMT  
		Size: 1.3 KB (1339 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:fe643d3e464e30161f4ee4c8edec5752deaee08f7b715a3c37f93aa07cc19dd5`  
		Last Modified: Wed, 16 Oct 2024 02:07:25 GMT  
		Size: 5.5 MB (5507066 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:46394f9e79dc2188ee722ca549af147869a2cf4c78a1b7f7ecb0c2a4a85d7136`  
		Last Modified: Wed, 16 Oct 2024 02:07:24 GMT  
		Size: 116.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:bff1f0ec76360d59674f76801a6c767f42a1335914e8b6aff3d18827f0dde7c9`  
		Last Modified: Wed, 16 Oct 2024 02:08:38 GMT  
		Size: 333.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:ba940fd169176f4b0815f392f6316fc697e71f6a737ad638ffe34e8c9edaa57f`  
		Last Modified: Wed, 16 Oct 2024 02:08:39 GMT  
		Size: 93.9 MB (93861329 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:174729dcb34b28a3914e144aefeaa1a0cb1c472e3ede5646fe6be7781ca34142`  
		Last Modified: Wed, 16 Oct 2024 02:08:38 GMT  
		Size: 4.0 KB (3980 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:2ffab26fa7cd38a115d09ff7df78f843b4e1af5e4d1d4e3cfc81cf03874e0547`  
		Last Modified: Wed, 16 Oct 2024 02:08:38 GMT  
		Size: 8.4 KB (8428 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:11.5` - unknown; unknown

```console
$ docker pull mariadb@sha256:b03ef7147767952e2fb465c733d71e9fbe46b71eb906330e6749b66db2ca35e9
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.1 MB (4095977 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:905f5bd739b7cb76e6022ce5b22f818b3f4dfb17b8ca880800d26de0b60561ab`

```dockerfile
```

-	Layers:
	-	`sha256:651b8a2473334f29a97cc9e1357f6d9f2a13fcec9a717f468b7b6046fc49bbbd`  
		Last Modified: Wed, 16 Oct 2024 02:08:38 GMT  
		Size: 4.1 MB (4064965 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:3a16a56724d3fb6b758999dc43527dfa97ccb9b436e8c28d360ecf3c8bb1692e`  
		Last Modified: Wed, 16 Oct 2024 02:08:37 GMT  
		Size: 31.0 KB (31012 bytes)  
		MIME: application/vnd.in-toto+json
