## `mariadb:11.2.5-jammy`

```console
$ docker pull mariadb@sha256:1363d4688aed0a0c3ddacb6e1b0a93dcfd765e557cb05e207b46bc8c60e376af
```

-	Manifest MIME: `application/vnd.oci.image.index.v1+json`
-	Platforms: 8
	-	linux; amd64
	-	unknown; unknown
	-	linux; arm64 variant v8
	-	unknown; unknown
	-	linux; ppc64le
	-	unknown; unknown
	-	linux; s390x
	-	unknown; unknown

### `mariadb:11.2.5-jammy` - linux; amd64

```console
$ docker pull mariadb@sha256:5fb69566cd0aea60f1b50d1a5ed2b11dc63404dee5e9b6f3a482acb1d313130e
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **122.9 MB (122937673 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:5c43f1b54a33f4859df8597e7850da47a720b99d45d5f60a4af780217fe61c2d`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mariadbd"]`

```dockerfile
# Tue, 03 Sep 2024 02:17:54 GMT
ARG RELEASE
# Tue, 03 Sep 2024 02:17:54 GMT
ARG LAUNCHPAD_BUILD_ARCH
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.ref.name=ubuntu
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.version=22.04
# Tue, 03 Sep 2024 02:17:54 GMT
ADD file:ebe009f86035c175ba244badd298a2582914415cf62783d510eab3a311a5d4e1 in / 
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:17:54 GMT
RUN groupadd -r mysql && useradd -r -g mysql mysql --home-dir /var/lib/mysql # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:17:54 GMT
ARG GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN set -eux; 	apt-get update; 	DEBIAN_FRONTEND=noninteractive apt-get install -y --no-install-recommends 		ca-certificates 		gpg 		gpgv 		libjemalloc2 		pwgen 		tzdata 		xz-utils 		zstd ; 	savedAptMark="$(apt-mark showmanual)"; 	apt-get install -y --no-install-recommends 		dirmngr 		gpg-agent 		wget; 	rm -rf /var/lib/apt/lists/*; 	dpkgArch="$(dpkg --print-architecture | awk -F- '{ print $NF }')"; 	wget -q -O /usr/local/bin/gosu "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch"; 	wget -q -O /usr/local/bin/gosu.asc "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch.asc"; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	for key in $GPG_KEYS; do 		gpg --batch --keyserver keyserver.ubuntu.com --recv-keys "$key"; 	done; 	gpg --batch --export "$GPG_KEYS" > /etc/apt/trusted.gpg.d/mariadb.gpg; 	if command -v gpgconf >/dev/null; then 		gpgconf --kill all; 	fi; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	apt-mark auto '.*' > /dev/null; 	[ -z "$savedAptMark" ] ||	apt-mark manual $savedAptMark >/dev/null; 	apt-get purge -y --auto-remove -o APT::AutoRemove::RecommendsImportant=false; 	chmod +x /usr/local/bin/gosu; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV LANG=C.UTF-8
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/library/ubuntu:jammy org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=11.2.5 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_VERSION=1:11.2.5+maria~ubu2204
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_VERSION=1:11.2.5+maria~ubu2204
# Tue, 03 Sep 2024 02:17:54 GMT
ARG REPOSITORY=http://archive.mariadb.org/mariadb-11.2.5/repo/ubuntu/ jammy main main/debug
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:11.2.5+maria~ubu2204 REPOSITORY=http://archive.mariadb.org/mariadb-11.2.5/repo/ubuntu/ jammy main main/debug
RUN set -e;	echo "deb ${REPOSITORY}" > /etc/apt/sources.list.d/mariadb.list; 	{ 		echo 'Package: *'; 		echo 'Pin: release o=MariaDB'; 		echo 'Pin-Priority: 999'; 	} > /etc/apt/preferences.d/mariadb # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:11.2.5+maria~ubu2204 REPOSITORY=http://archive.mariadb.org/mariadb-11.2.5/repo/ubuntu/ jammy main main/debug
RUN set -ex; 	{ 		echo "mariadb-server" mysql-server/root_password password 'unused'; 		echo "mariadb-server" mysql-server/root_password_again password 'unused'; 	} | debconf-set-selections; 	apt-get update; 	mkdir -p /var/lib/mysql/mysql ; touch /var/lib/mysql/mysql/user.frm ; 	apt-get install -y --no-install-recommends mariadb-server="$MARIADB_VERSION" mariadb-backup socat 	; 	rm -rf /var/lib/apt/lists/*; 	rm -rf /var/lib/mysql; 	mkdir -p /var/lib/mysql /run/mysqld; 	chown -R mysql:mysql /var/lib/mysql /run/mysqld; 	chmod 1777 /run/mysqld; 	find /etc/mysql/ -name '*.cnf' -print0 		| xargs -0 grep -lZE '^(bind-address|log|user\s)' 		| xargs -rt -0 sed -Ei 's/^(bind-address|log|user\s)/#&/'; 	printf "[mariadb]\nhost-cache-size=0\nskip-name-resolve\n" > /etc/mysql/mariadb.conf.d/05-skipcache.cnf; 	if [ -L /etc/mysql/my.cnf ]; then 		sed -i -e '/includedir/ {N;s/\(.*\)\n\(.*\)/\n\2\n\1/}' /etc/mysql/mariadb.cnf; 	fi # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:17:54 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:17:54 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["mariadbd"]
```

-	Layers:
	-	`sha256:6414378b647780fee8fd903ddb9541d134a1947ce092d08bdeb23a54cb3684ac`  
		Last Modified: Wed, 11 Sep 2024 17:24:41 GMT  
		Size: 29.5 MB (29535688 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:337a64c8ad4fd36104464fcb94ab7ac4f3d660e9057e17ae361ab7b4fb5a8208`  
		Last Modified: Tue, 17 Sep 2024 00:59:26 GMT  
		Size: 1.7 KB (1723 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:dea746d53de5d9f82274721cc668a8b5688cd7c7e3ff6983301c10d9b7d42050`  
		Last Modified: Tue, 17 Sep 2024 00:59:27 GMT  
		Size: 5.6 MB (5647936 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:e093b2f3a650549515bb7cc6ca79dff1168b5e29406381d16b15ab39040f1e38`  
		Last Modified: Tue, 17 Sep 2024 00:59:26 GMT  
		Size: 116.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:4d1641b7f6ede74e93172d942d6b38e342106042d1249d86a644c84642cd564f`  
		Last Modified: Tue, 17 Sep 2024 00:59:27 GMT  
		Size: 334.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:31dd1b220c0e01d8765f3c840a23a7f693755c4747b51fee6d0288ef5c38513e`  
		Last Modified: Tue, 17 Sep 2024 00:59:30 GMT  
		Size: 87.7 MB (87739531 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:55aede418915a587a453c34bc01f8617e0d3ae9c612a622a461e39336be52a8b`  
		Last Modified: Tue, 17 Sep 2024 00:59:27 GMT  
		Size: 4.0 KB (3957 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:1aeb9324ef9d024c99b804ec343221d08054fd235adbfa4ed9d3dfb7d6335a1c`  
		Last Modified: Tue, 17 Sep 2024 00:59:28 GMT  
		Size: 8.4 KB (8388 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:11.2.5-jammy` - unknown; unknown

```console
$ docker pull mariadb@sha256:78e3f776d86cbd318a5e1f4e061b9fc523d4639fef27b58c9b1b2d05953cf778
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.6 MB (4618975 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:d242b11accf8e9864ddcd830df9cf455d01593f908ebd6000d174a14c413e424`

```dockerfile
```

-	Layers:
	-	`sha256:7831639343cf9b95fe50e368fc258e204c3f54f5ce787b267e07a0638185d303`  
		Last Modified: Tue, 17 Sep 2024 00:59:27 GMT  
		Size: 4.6 MB (4589268 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:f6921d3d97c86f3ac03ecad0c5672649974eed56a4439a15b05746dcc8e34d40`  
		Last Modified: Tue, 17 Sep 2024 00:59:27 GMT  
		Size: 29.7 KB (29707 bytes)  
		MIME: application/vnd.in-toto+json

### `mariadb:11.2.5-jammy` - linux; arm64 variant v8

```console
$ docker pull mariadb@sha256:7fa290ef6c2b1f9d47ce61c925a9012c7184cfde5e983a9598665bd4a08873b5
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **117.3 MB (117313503 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:e99690deb2258333a199e198969c65eea18eb9db254d7a77de66bfdab69a9c88`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mariadbd"]`

```dockerfile
# Tue, 03 Sep 2024 02:17:54 GMT
ARG RELEASE
# Tue, 03 Sep 2024 02:17:54 GMT
ARG LAUNCHPAD_BUILD_ARCH
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.ref.name=ubuntu
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.version=22.04
# Tue, 03 Sep 2024 02:17:54 GMT
ADD file:53ce73ebbd6d87a234a33414686f12909aaaf28b7238593f746a327c7d004ce7 in / 
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:17:54 GMT
RUN groupadd -r mysql && useradd -r -g mysql mysql --home-dir /var/lib/mysql # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:17:54 GMT
ARG GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN set -eux; 	apt-get update; 	DEBIAN_FRONTEND=noninteractive apt-get install -y --no-install-recommends 		ca-certificates 		gpg 		gpgv 		libjemalloc2 		pwgen 		tzdata 		xz-utils 		zstd ; 	savedAptMark="$(apt-mark showmanual)"; 	apt-get install -y --no-install-recommends 		dirmngr 		gpg-agent 		wget; 	rm -rf /var/lib/apt/lists/*; 	dpkgArch="$(dpkg --print-architecture | awk -F- '{ print $NF }')"; 	wget -q -O /usr/local/bin/gosu "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch"; 	wget -q -O /usr/local/bin/gosu.asc "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch.asc"; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	for key in $GPG_KEYS; do 		gpg --batch --keyserver keyserver.ubuntu.com --recv-keys "$key"; 	done; 	gpg --batch --export "$GPG_KEYS" > /etc/apt/trusted.gpg.d/mariadb.gpg; 	if command -v gpgconf >/dev/null; then 		gpgconf --kill all; 	fi; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	apt-mark auto '.*' > /dev/null; 	[ -z "$savedAptMark" ] ||	apt-mark manual $savedAptMark >/dev/null; 	apt-get purge -y --auto-remove -o APT::AutoRemove::RecommendsImportant=false; 	chmod +x /usr/local/bin/gosu; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV LANG=C.UTF-8
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/library/ubuntu:jammy org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=11.2.5 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_VERSION=1:11.2.5+maria~ubu2204
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_VERSION=1:11.2.5+maria~ubu2204
# Tue, 03 Sep 2024 02:17:54 GMT
ARG REPOSITORY=http://archive.mariadb.org/mariadb-11.2.5/repo/ubuntu/ jammy main main/debug
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:11.2.5+maria~ubu2204 REPOSITORY=http://archive.mariadb.org/mariadb-11.2.5/repo/ubuntu/ jammy main main/debug
RUN set -e;	echo "deb ${REPOSITORY}" > /etc/apt/sources.list.d/mariadb.list; 	{ 		echo 'Package: *'; 		echo 'Pin: release o=MariaDB'; 		echo 'Pin-Priority: 999'; 	} > /etc/apt/preferences.d/mariadb # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:11.2.5+maria~ubu2204 REPOSITORY=http://archive.mariadb.org/mariadb-11.2.5/repo/ubuntu/ jammy main main/debug
RUN set -ex; 	{ 		echo "mariadb-server" mysql-server/root_password password 'unused'; 		echo "mariadb-server" mysql-server/root_password_again password 'unused'; 	} | debconf-set-selections; 	apt-get update; 	mkdir -p /var/lib/mysql/mysql ; touch /var/lib/mysql/mysql/user.frm ; 	apt-get install -y --no-install-recommends mariadb-server="$MARIADB_VERSION" mariadb-backup socat 	; 	rm -rf /var/lib/apt/lists/*; 	rm -rf /var/lib/mysql; 	mkdir -p /var/lib/mysql /run/mysqld; 	chown -R mysql:mysql /var/lib/mysql /run/mysqld; 	chmod 1777 /run/mysqld; 	find /etc/mysql/ -name '*.cnf' -print0 		| xargs -0 grep -lZE '^(bind-address|log|user\s)' 		| xargs -rt -0 sed -Ei 's/^(bind-address|log|user\s)/#&/'; 	printf "[mariadb]\nhost-cache-size=0\nskip-name-resolve\n" > /etc/mysql/mariadb.conf.d/05-skipcache.cnf; 	if [ -L /etc/mysql/my.cnf ]; then 		sed -i -e '/includedir/ {N;s/\(.*\)\n\(.*\)/\n\2\n\1/}' /etc/mysql/mariadb.cnf; 	fi # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:17:54 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:17:54 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["mariadbd"]
```

-	Layers:
	-	`sha256:a186900671ab62e1dea364788f4e84c156e1825939914cfb5a6770be2b58b4da`  
		Last Modified: Wed, 11 Sep 2024 17:24:47 GMT  
		Size: 27.4 MB (27358329 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:6b63ab2d2913a834901115a7d4dc7355de38dab1cebee6e614ad27522940b940`  
		Last Modified: Tue, 17 Sep 2024 02:27:53 GMT  
		Size: 1.7 KB (1723 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:64d62bd3ce499228055c47cdf0a95ed8952ddfe20f7dd66733a05400a0956c19`  
		Last Modified: Tue, 17 Sep 2024 02:27:53 GMT  
		Size: 5.5 MB (5461422 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:92ac870fb59b14b3d42dd38f32edb264836fe9d7cd473d8e63e2dd921da2de90`  
		Last Modified: Tue, 17 Sep 2024 02:27:53 GMT  
		Size: 114.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:84bcb8333c06a5450cbf91d8401a1ae2a1b44eec6d9e332701dfee55c9a164f9`  
		Last Modified: Tue, 17 Sep 2024 02:27:53 GMT  
		Size: 329.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:3190fbdb0e3e433a73e4f54ab451b3c27fcd386f744f6b139ace498c5c0395e6`  
		Last Modified: Tue, 17 Sep 2024 02:27:56 GMT  
		Size: 84.5 MB (84479241 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:12bf3f2be4359a35efef8bb0aa0403e33912a6e673c609cd370ab0c8e1b3d125`  
		Last Modified: Tue, 17 Sep 2024 02:27:53 GMT  
		Size: 4.0 KB (3957 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:466cae6a9e02a9db6378fbfb403303408195b389fa6e2041c665ebef06dd5a01`  
		Last Modified: Tue, 17 Sep 2024 02:27:54 GMT  
		Size: 8.4 KB (8388 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:11.2.5-jammy` - unknown; unknown

```console
$ docker pull mariadb@sha256:77869a135adbd85022bf844463577a7e7df6313f6dd14d9aaae607e04525c8d6
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.6 MB (4625692 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:4826c55b9898f9585640d39be5dbe5955c05e7f10c19a00fc97a4a6df7374d78`

```dockerfile
```

-	Layers:
	-	`sha256:0164736a559697bd786922c6193a327f96fe02a3b8a507620945fc5abf66dacb`  
		Last Modified: Tue, 17 Sep 2024 02:27:53 GMT  
		Size: 4.6 MB (4595685 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:950437c7ef893beed5656746d61e012d70c6ae05b523703a43f2613eb2420724`  
		Last Modified: Tue, 17 Sep 2024 02:27:53 GMT  
		Size: 30.0 KB (30007 bytes)  
		MIME: application/vnd.in-toto+json

### `mariadb:11.2.5-jammy` - linux; ppc64le

```console
$ docker pull mariadb@sha256:b6685e5f165f7df1e20ea22403eada4a4c871f87b6e8b65f8417c3795e5ad41f
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **131.0 MB (130989193 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:3d00166b98901d694a2fb3b99f7b5bc940cba1b394fa0f41addef1e93688aeb4`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mariadbd"]`

```dockerfile
# Tue, 03 Sep 2024 02:17:54 GMT
ARG RELEASE
# Tue, 03 Sep 2024 02:17:54 GMT
ARG LAUNCHPAD_BUILD_ARCH
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.ref.name=ubuntu
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.version=22.04
# Tue, 03 Sep 2024 02:17:54 GMT
ADD file:8b71bf5e48ac3a761ff94511892207fd277c013e3c67b735b87f7338e62bb1f3 in / 
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:17:54 GMT
RUN groupadd -r mysql && useradd -r -g mysql mysql --home-dir /var/lib/mysql # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:17:54 GMT
ARG GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN set -eux; 	apt-get update; 	DEBIAN_FRONTEND=noninteractive apt-get install -y --no-install-recommends 		ca-certificates 		gpg 		gpgv 		libjemalloc2 		pwgen 		tzdata 		xz-utils 		zstd ; 	savedAptMark="$(apt-mark showmanual)"; 	apt-get install -y --no-install-recommends 		dirmngr 		gpg-agent 		wget; 	rm -rf /var/lib/apt/lists/*; 	dpkgArch="$(dpkg --print-architecture | awk -F- '{ print $NF }')"; 	wget -q -O /usr/local/bin/gosu "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch"; 	wget -q -O /usr/local/bin/gosu.asc "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch.asc"; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	for key in $GPG_KEYS; do 		gpg --batch --keyserver keyserver.ubuntu.com --recv-keys "$key"; 	done; 	gpg --batch --export "$GPG_KEYS" > /etc/apt/trusted.gpg.d/mariadb.gpg; 	if command -v gpgconf >/dev/null; then 		gpgconf --kill all; 	fi; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	apt-mark auto '.*' > /dev/null; 	[ -z "$savedAptMark" ] ||	apt-mark manual $savedAptMark >/dev/null; 	apt-get purge -y --auto-remove -o APT::AutoRemove::RecommendsImportant=false; 	chmod +x /usr/local/bin/gosu; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV LANG=C.UTF-8
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/library/ubuntu:jammy org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=11.2.5 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_VERSION=1:11.2.5+maria~ubu2204
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_VERSION=1:11.2.5+maria~ubu2204
# Tue, 03 Sep 2024 02:17:54 GMT
ARG REPOSITORY=http://archive.mariadb.org/mariadb-11.2.5/repo/ubuntu/ jammy main main/debug
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:11.2.5+maria~ubu2204 REPOSITORY=http://archive.mariadb.org/mariadb-11.2.5/repo/ubuntu/ jammy main main/debug
RUN set -e;	echo "deb ${REPOSITORY}" > /etc/apt/sources.list.d/mariadb.list; 	{ 		echo 'Package: *'; 		echo 'Pin: release o=MariaDB'; 		echo 'Pin-Priority: 999'; 	} > /etc/apt/preferences.d/mariadb # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:11.2.5+maria~ubu2204 REPOSITORY=http://archive.mariadb.org/mariadb-11.2.5/repo/ubuntu/ jammy main main/debug
RUN set -ex; 	{ 		echo "mariadb-server" mysql-server/root_password password 'unused'; 		echo "mariadb-server" mysql-server/root_password_again password 'unused'; 	} | debconf-set-selections; 	apt-get update; 	mkdir -p /var/lib/mysql/mysql ; touch /var/lib/mysql/mysql/user.frm ; 	apt-get install -y --no-install-recommends mariadb-server="$MARIADB_VERSION" mariadb-backup socat 	; 	rm -rf /var/lib/apt/lists/*; 	rm -rf /var/lib/mysql; 	mkdir -p /var/lib/mysql /run/mysqld; 	chown -R mysql:mysql /var/lib/mysql /run/mysqld; 	chmod 1777 /run/mysqld; 	find /etc/mysql/ -name '*.cnf' -print0 		| xargs -0 grep -lZE '^(bind-address|log|user\s)' 		| xargs -rt -0 sed -Ei 's/^(bind-address|log|user\s)/#&/'; 	printf "[mariadb]\nhost-cache-size=0\nskip-name-resolve\n" > /etc/mysql/mariadb.conf.d/05-skipcache.cnf; 	if [ -L /etc/mysql/my.cnf ]; then 		sed -i -e '/includedir/ {N;s/\(.*\)\n\(.*\)/\n\2\n\1/}' /etc/mysql/mariadb.cnf; 	fi # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:17:54 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:17:54 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["mariadbd"]
```

-	Layers:
	-	`sha256:bd389594e541fc722f244791a495e1a62a526cb95daeea3d2304d9be4e2f0e2a`  
		Last Modified: Wed, 11 Sep 2024 17:24:59 GMT  
		Size: 34.4 MB (34448242 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:07b436ad9804874480e1457c00e1f5a9c03eeb1cb532a6bf32241f09232c82aa`  
		Last Modified: Tue, 17 Sep 2024 01:41:52 GMT  
		Size: 1.7 KB (1721 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:41db9dcfe75d89b266330aada2a2861129a772102cd399f984a8c478b19ac1d1`  
		Last Modified: Tue, 17 Sep 2024 01:41:53 GMT  
		Size: 6.1 MB (6079737 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:83f7f271dc28602e7ca510684b95ba879f55e65ec4e9f126edf76a5cd08307e4`  
		Last Modified: Tue, 17 Sep 2024 01:41:52 GMT  
		Size: 116.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:eb35e39c4efbbf8993f6c68bf0fcae7894caf94608c6d284adab38e0c0b7b9bf`  
		Last Modified: Tue, 17 Sep 2024 01:41:53 GMT  
		Size: 332.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:0fa9b173e9108abad102fe89f432114113c58194aecb6f1a484fb306787c39a6`  
		Last Modified: Tue, 17 Sep 2024 01:41:56 GMT  
		Size: 90.4 MB (90446698 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:ea5b0e8ba14b20ba1cf5d3c8b884bb50a0cb5563666745748f51640f929eaa3f`  
		Last Modified: Tue, 17 Sep 2024 01:41:53 GMT  
		Size: 4.0 KB (3957 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:9183faf832752354e8d326facd1dbaa822b311eb5415b24919f50aa88e48e0dd`  
		Last Modified: Tue, 17 Sep 2024 01:41:54 GMT  
		Size: 8.4 KB (8390 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:11.2.5-jammy` - unknown; unknown

```console
$ docker pull mariadb@sha256:c0d22470fc1bf7bbf1ea66b98291e9bb8dd03f52fc567516bcec3e77bce5a9bf
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.6 MB (4626640 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:28f0895fbfa5eefb2a1c11b5677e13b05d87e0509802d1781172f79a883043ab`

```dockerfile
```

-	Layers:
	-	`sha256:f80d57572d2a3698734b4dc8002899250ddb213b0a584a7ff41ceb45ce0d598d`  
		Last Modified: Tue, 17 Sep 2024 01:41:53 GMT  
		Size: 4.6 MB (4596887 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:58406e37d2e61ded5bf0e6251e285d23efe115532850ca616ca309a21ab6f00b`  
		Last Modified: Tue, 17 Sep 2024 01:41:52 GMT  
		Size: 29.8 KB (29753 bytes)  
		MIME: application/vnd.in-toto+json

### `mariadb:11.2.5-jammy` - linux; s390x

```console
$ docker pull mariadb@sha256:4ff0830511665caf5b2941ced5b44c0c71a4755b359aed5a8eed50ed184e140c
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **121.9 MB (121872402 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:0fb414e32b41dbe2ed4b15059a80ba883c4f9d3d0e7b6eb45d5702328ac02406`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mariadbd"]`

```dockerfile
# Tue, 03 Sep 2024 02:17:54 GMT
ARG RELEASE
# Tue, 03 Sep 2024 02:17:54 GMT
ARG LAUNCHPAD_BUILD_ARCH
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.ref.name=ubuntu
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.version=22.04
# Tue, 03 Sep 2024 02:17:54 GMT
ADD file:6dc78f1eec678e679ed1d9f92297dbcf99806da788dde329389d5d786006603f in / 
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:17:54 GMT
RUN groupadd -r mysql && useradd -r -g mysql mysql --home-dir /var/lib/mysql # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:17:54 GMT
ARG GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN set -eux; 	apt-get update; 	DEBIAN_FRONTEND=noninteractive apt-get install -y --no-install-recommends 		ca-certificates 		gpg 		gpgv 		libjemalloc2 		pwgen 		tzdata 		xz-utils 		zstd ; 	savedAptMark="$(apt-mark showmanual)"; 	apt-get install -y --no-install-recommends 		dirmngr 		gpg-agent 		wget; 	rm -rf /var/lib/apt/lists/*; 	dpkgArch="$(dpkg --print-architecture | awk -F- '{ print $NF }')"; 	wget -q -O /usr/local/bin/gosu "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch"; 	wget -q -O /usr/local/bin/gosu.asc "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch.asc"; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	for key in $GPG_KEYS; do 		gpg --batch --keyserver keyserver.ubuntu.com --recv-keys "$key"; 	done; 	gpg --batch --export "$GPG_KEYS" > /etc/apt/trusted.gpg.d/mariadb.gpg; 	if command -v gpgconf >/dev/null; then 		gpgconf --kill all; 	fi; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	apt-mark auto '.*' > /dev/null; 	[ -z "$savedAptMark" ] ||	apt-mark manual $savedAptMark >/dev/null; 	apt-get purge -y --auto-remove -o APT::AutoRemove::RecommendsImportant=false; 	chmod +x /usr/local/bin/gosu; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV LANG=C.UTF-8
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/library/ubuntu:jammy org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=11.2.5 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_VERSION=1:11.2.5+maria~ubu2204
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_VERSION=1:11.2.5+maria~ubu2204
# Tue, 03 Sep 2024 02:17:54 GMT
ARG REPOSITORY=http://archive.mariadb.org/mariadb-11.2.5/repo/ubuntu/ jammy main main/debug
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:11.2.5+maria~ubu2204 REPOSITORY=http://archive.mariadb.org/mariadb-11.2.5/repo/ubuntu/ jammy main main/debug
RUN set -e;	echo "deb ${REPOSITORY}" > /etc/apt/sources.list.d/mariadb.list; 	{ 		echo 'Package: *'; 		echo 'Pin: release o=MariaDB'; 		echo 'Pin-Priority: 999'; 	} > /etc/apt/preferences.d/mariadb # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:11.2.5+maria~ubu2204 REPOSITORY=http://archive.mariadb.org/mariadb-11.2.5/repo/ubuntu/ jammy main main/debug
RUN set -ex; 	{ 		echo "mariadb-server" mysql-server/root_password password 'unused'; 		echo "mariadb-server" mysql-server/root_password_again password 'unused'; 	} | debconf-set-selections; 	apt-get update; 	mkdir -p /var/lib/mysql/mysql ; touch /var/lib/mysql/mysql/user.frm ; 	apt-get install -y --no-install-recommends mariadb-server="$MARIADB_VERSION" mariadb-backup socat 	; 	rm -rf /var/lib/apt/lists/*; 	rm -rf /var/lib/mysql; 	mkdir -p /var/lib/mysql /run/mysqld; 	chown -R mysql:mysql /var/lib/mysql /run/mysqld; 	chmod 1777 /run/mysqld; 	find /etc/mysql/ -name '*.cnf' -print0 		| xargs -0 grep -lZE '^(bind-address|log|user\s)' 		| xargs -rt -0 sed -Ei 's/^(bind-address|log|user\s)/#&/'; 	printf "[mariadb]\nhost-cache-size=0\nskip-name-resolve\n" > /etc/mysql/mariadb.conf.d/05-skipcache.cnf; 	if [ -L /etc/mysql/my.cnf ]; then 		sed -i -e '/includedir/ {N;s/\(.*\)\n\(.*\)/\n\2\n\1/}' /etc/mysql/mariadb.cnf; 	fi # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:17:54 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:17:54 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["mariadbd"]
```

-	Layers:
	-	`sha256:41e9fbd89079d8e47609ae158236d59896fd2503db1ebdfef058864054170e01`  
		Last Modified: Wed, 11 Sep 2024 17:25:11 GMT  
		Size: 28.0 MB (28001475 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:e8674d17fc3eece5cc84a9f62a40844d764b4a720c71884e48479c160f6f3fb1`  
		Last Modified: Tue, 17 Sep 2024 02:20:55 GMT  
		Size: 1.7 KB (1725 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:157bb5a5a6a20fc98395d90ae1a6cf352888024b2b6b9291422edc64b027b95f`  
		Last Modified: Tue, 17 Sep 2024 02:20:55 GMT  
		Size: 5.5 MB (5532632 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:28d4d8b62a365d96c575b6523d77697d14647fe3ce47190ec6896509efd1677f`  
		Last Modified: Tue, 17 Sep 2024 02:20:55 GMT  
		Size: 116.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:9dd7a69365163bd0bf35992446752397794d3fc30bdad027b0d6ed77ad468652`  
		Last Modified: Tue, 17 Sep 2024 02:20:55 GMT  
		Size: 334.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:ae01026a3b45c3c8a643516d07abac8b7afe03e3e49fd84c8da37e130f1d299c`  
		Last Modified: Tue, 17 Sep 2024 02:20:58 GMT  
		Size: 88.3 MB (88323774 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:423cf85c98dcffe2ac913eed14120b386526d45c7991f6645836df4c28cdfda7`  
		Last Modified: Tue, 17 Sep 2024 02:20:56 GMT  
		Size: 4.0 KB (3957 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:066257839b3f4830fdfd45f42e3ed83a79632005c8ec91698875c07f692488cd`  
		Last Modified: Tue, 17 Sep 2024 02:20:56 GMT  
		Size: 8.4 KB (8389 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:11.2.5-jammy` - unknown; unknown

```console
$ docker pull mariadb@sha256:43591ccd3fd934b5460f46458a3007eb576fa1a3eccd061248fc02b87ad5fa1b
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.6 MB (4619302 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:c6f0b2706ae9a069b592ecdf5ac8fd29945427e4e98bb1a253755ae12b11c8f3`

```dockerfile
```

-	Layers:
	-	`sha256:3ab861f647226516b13017be8603365938bf20a1d639849d2fdaf1203ed85ef1`  
		Last Modified: Tue, 17 Sep 2024 02:20:56 GMT  
		Size: 4.6 MB (4589596 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:d378d49424d3de243bd324521508ed2b3ba0e75d4a11902bdd943f6b3551bfd7`  
		Last Modified: Tue, 17 Sep 2024 02:20:55 GMT  
		Size: 29.7 KB (29706 bytes)  
		MIME: application/vnd.in-toto+json
