## `mariadb:11-ubi`

```console
$ docker pull mariadb@sha256:a127f4c6c2df1feeed84ba9e9b7313a5761570c7a2767038bc821bfcfded691c
```

-	Manifest MIME: `application/vnd.oci.image.index.v1+json`
-	Platforms: 8
	-	linux; amd64
	-	unknown; unknown
	-	linux; arm64 variant v8
	-	unknown; unknown
	-	linux; ppc64le
	-	unknown; unknown
	-	linux; s390x
	-	unknown; unknown

### `mariadb:11-ubi` - linux; amd64

```console
$ docker pull mariadb@sha256:fbb59fc17d2ace13661c9bc2992dde70e033c71d882733c1fae8ff9215d105bd
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **146.4 MB (146386513 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:e594bca1cddc2618c6050ba8c1ea27339d8ec6ab5328e13e8310d82188135dc0`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mariadbd"]`

```dockerfile
# Tue, 03 Sep 2024 02:32:52 GMT
ADD file:f7962bcea8426558f5511299e708fc6b7f7c85bd2c87cf668f4ad792bf3679df in / 
# Tue, 03 Sep 2024 02:32:52 GMT
RUN mv -f /etc/yum.repos.d/ubi.repo /tmp || :
# Tue, 03 Sep 2024 02:32:52 GMT
ADD file:5b1f650e1376d79fa3a65df4a154ea5166def95154b52c1c1097dfd8fc7d58eb in /tmp/tls-ca-bundle.pem 
# Tue, 03 Sep 2024 02:32:52 GMT
ADD multi:d851b7f6b461892ebd008971ee8858113becab621ea011cd6ca3834693892de0 in /etc/yum.repos.d/ 
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL maintainer="Red Hat, Inc."
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL com.redhat.component="ubi9-minimal-container"       name="ubi9-minimal"       version="9.4"
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL com.redhat.license_terms="https://www.redhat.com/en/about/red-hat-end-user-license-agreements#UBI"
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL summary="Provides the latest release of the minimal Red Hat Universal Base Image 9."
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL description="The Universal Base Image Minimal is a stripped down image that uses microdnf as a package manager. This base image is freely redistributable, but Red Hat only supports Red Hat technologies through subscriptions for Red Hat products. This image is maintained by Red Hat and updated regularly."
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL io.k8s.display-name="Red Hat Universal Base Image 9 Minimal"
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL io.openshift.expose-services=""
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL io.openshift.tags="minimal rhel9"
# Tue, 03 Sep 2024 02:32:52 GMT
ENV container oci
# Tue, 03 Sep 2024 02:32:52 GMT
ENV PATH /usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin
# Tue, 03 Sep 2024 02:32:52 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:32:52 GMT
RUN rm -rf /var/log/*
# Tue, 03 Sep 2024 02:32:52 GMT
ADD file:b61dc232d84be84b398c4a9d319ce263c1e698a1f3e41122b4989b26ae411742 in /root/buildinfo/content_manifests/ubi9-minimal-container-9.4-1227.1726694542.json 
# Tue, 03 Sep 2024 02:32:52 GMT
ADD file:3763314761ee75f4c50d08cca38184a1368ca6d78d98ed9b3df4d4a28ce9a60f in /root/buildinfo/Dockerfile-ubi9-minimal-9.4-1227.1726694542 
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL "release"="1227.1726694542" "distribution-scope"="public" "vendor"="Red Hat, Inc." "build-date"="2024-09-18T21:23:26" "architecture"="x86_64" "vcs-type"="git" "vcs-ref"="94baa7760359088a42ad33dc22d329a5ee2c7209" "io.k8s.description"="The Universal Base Image Minimal is a stripped down image that uses microdnf as a package manager. This base image is freely redistributable, but Red Hat only supports Red Hat technologies through subscriptions for Red Hat products. This image is maintained by Red Hat and updated regularly." "url"="https://access.redhat.com/containers/#/registry.access.redhat.com/ubi9-minimal/images/9.4-1227.1726694542"
# Tue, 03 Sep 2024 02:32:52 GMT
RUN rm -f '/etc/yum.repos.d/odcs-3496922-3d51b.repo' '/etc/yum.repos.d/rhel-9.4-compose-34ae9.repo'
# Tue, 03 Sep 2024 02:32:52 GMT
RUN rm -f /tmp/tls-ca-bundle.pem
# Tue, 03 Sep 2024 02:32:52 GMT
RUN mv -fZ /tmp/ubi.repo /etc/yum.repos.d/ubi.repo || :
# Tue, 03 Sep 2024 02:32:52 GMT
RUN groupadd --gid 999 -r mysql && 	useradd -r -g mysql mysql --home-dir /var/lib/mysql --uid 999 # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:32:52 GMT
RUN set -eux; 	rpmArch="$(rpm --query --queryformat='%{ARCH}' rpm)"; 	case "$rpmArch" in 		aarch64) dpkgArch='arm64' ;; 		armv7*) dpkgArch='armhf' ;; 		i686) dpkgArch='i386' ;; 		ppc64le) dpkgArch='ppc64el' ;; 		s390x|riscv64) dpkgArch=$rpmArch ;; 		x86_64) dpkgArch='amd64' ;; 		*) echo >&2 "error: unknown/unsupported architecture '$rpmArch'"; exit 1 ;; 	esac; 	curl --fail --location --output /usr/local/bin/gosu https://github.com/tianon/gosu/releases/download/${GOSU_VERSION}/gosu-${dpkgArch} ; 	curl --fail --location --output /usr/local/bin/gosu.asc https://github.com/tianon/gosu/releases/download/${GOSU_VERSION}/gosu-${dpkgArch}.asc; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	chmod a+x /usr/local/bin/gosu; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
COPY --chmod=0644 docker.cnf /etc/my.cnf.d/ # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
COPY MariaDB.repo /etc/yum.repos.d/ # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL name=MariaDB Server vendor=MariaDB Community version=11.5.2 release=Refer to Annotations org.opencontainers.image.{revision,source} summary=MariaDB Database description=MariaDB Database for relational SQL
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/redhat/ubi9-minimal org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=11.5.2 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:32:52 GMT
ARG MARIADB_VERSION=11.5.2
# Tue, 03 Sep 2024 02:32:52 GMT
ENV MARIADB_VERSION=11.5.2
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: MARIADB_VERSION=11.5.2
RUN set -eux ; 	curl --fail https://pagure.io/fedora-web/websites/raw/master/f/sites/getfedora.org/static/keys/FF8AD1344597106ECE813B918A3872BF3228467C.txt --output /tmp/epelkey.txt ; 	GNUPGHOME="$(mktemp -d)"; export GNUPGHOME ; 	gpg --batch --import /tmp/epelkey.txt ; 	gpg --batch --armor --export FF8AD1344597106ECE813B918A3872BF3228467C > /tmp/epelkey.txt ; 	rpmkeys --import /tmp/epelkey.txt ; 	curl --fail https://dl.fedoraproject.org/pub/epel/epel-release-latest-9.noarch.rpm --output /tmp/epel-release-latest-9.noarch.rpm ; 	rpm -K /tmp/epel-release-latest-9.noarch.rpm ; 	rpm -ivh /tmp/epel-release-latest-9.noarch.rpm ; 	rm /tmp/epelkey.txt /tmp/epel-release-latest-9.noarch.rpm ; 	curl --fail https://supplychain.mariadb.com/MariaDB-Server-GPG-KEY --output /tmp/MariaDB-Server-GPG-KEY ; 	gpg --batch --import /tmp/MariaDB-Server-GPG-KEY; 	gpg --batch --armor --export 177F4010FE56CA3336300305F1656F24C74CD1D8 > /tmp/MariaDB-Server-GPG-KEY ; 	rpmkeys --import /tmp/MariaDB-Server-GPG-KEY ; 	rm -rf "$GNUPGHOME" /tmp/MariaDB-Server-GPG-KEY ; 	unset GNUPGHOME ; 	microdnf update -y ; 	microdnf reinstall -y tzdata ; 	microdnf install -y procps-ng zstd xz jemalloc pwgen pv ; 	mkdir -p /etc/mysql/conf.d /etc/mysql/mariadb.conf.d/ /var/lib/mysql/mysql /run/mariadb /usr/lib64/galera ; 	chmod ugo+rwx,o+t /run/mariadb ; 	microdnf install -y MariaDB-backup-${MARIADB_VERSION}  MariaDB-server-${MARIADB_VERSION} ; 	ln -s /usr/lib64/galera-4/libgalera_smm.so /usr/lib/libgalera_smm.so ; 	ln -s /usr/lib64/galera-4/libgalera_smm.so /usr/lib64/galera/libgalera_smm.so ; 	microdnf clean all ; 	rmdir /var/lib/mysql/mysql ; 	chown -R mysql:mysql /var/lib/mysql /run/mariadb ; 	mkdir /licenses ; 	ln -s /usr/share/doc/MariaDB-server-${MARIADB_VERSION}/COPYING /licenses/GPL-2 ; 	ln -s /usr/share/licenses /licenses/package-licenses ; 	ln -s Apache-2.0-license /licenses/gosu # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: MARIADB_VERSION=11.5.2
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:32:52 GMT
USER mysql
# Tue, 03 Sep 2024 02:32:52 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:32:52 GMT
CMD ["mariadbd"]
```

-	Layers:
	-	`sha256:4d5d1cbd7ece41ce278c26338e01e2b82e1861b820ca052da9f3e0b16815358f`  
		Last Modified: Fri, 20 Sep 2024 03:47:53 GMT  
		Size: 39.1 MB (39101700 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:bb081552904905c0c46994b3dec25220ffe668dd0ce76ba9e02b9e2e6717b8e6`  
		Last Modified: Tue, 24 Sep 2024 01:00:33 GMT  
		Size: 879.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:71190b5362b115b715b473346e8342a34a3ab0fed115b9f875c2a82702a74082`  
		Last Modified: Tue, 24 Sep 2024 01:00:33 GMT  
		Size: 983.5 KB (983467 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:012446cdff3f2f242805ee02684bb69246fdb913e7c852b505d90fd502a12584`  
		Last Modified: Tue, 24 Sep 2024 01:00:33 GMT  
		Size: 317.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:f9e11aabf160522ad903b849c9811716b3ece2f0480d3b6e34172628176d9619`  
		Last Modified: Tue, 24 Sep 2024 01:00:33 GMT  
		Size: 314.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:b824dee79e6c6ea31f3a7a0a109e7ccb6787f85f7927f685a57a7175395c3da1`  
		Last Modified: Tue, 24 Sep 2024 01:00:36 GMT  
		Size: 106.3 MB (106287318 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:4603c1216dea4d4c2e193a1ba972b04aa75944f44ead456c01eb78f7910ee370`  
		Last Modified: Tue, 24 Sep 2024 01:00:34 GMT  
		Size: 116.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:fe21eb4362ef42dfbaa56e8d522f330b0c168fec34a17ab27561805d08d1f50a`  
		Last Modified: Tue, 24 Sep 2024 01:00:34 GMT  
		Size: 4.0 KB (3977 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:3932e14ebd08f5073ac31c70f087732b166ec1827ce697bf104573a008c77575`  
		Last Modified: Tue, 24 Sep 2024 01:00:34 GMT  
		Size: 8.4 KB (8425 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:11-ubi` - unknown; unknown

```console
$ docker pull mariadb@sha256:bbea687e8f239365c6f9a31889766baf288681cc57a3fe8a57d0b4077244d0d6
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **29.9 KB (29933 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:b0be778f088ec5e9127950bee13361ba0970e9a50bdc2f8a3e8ba748c0391d4f`

```dockerfile
```

-	Layers:
	-	`sha256:6cdb2ce76d97d5047835a6a66e9e82ebd378ffb78bdd36fded8089f5a051fd2b`  
		Last Modified: Tue, 24 Sep 2024 01:00:33 GMT  
		Size: 29.9 KB (29933 bytes)  
		MIME: application/vnd.in-toto+json

### `mariadb:11-ubi` - linux; arm64 variant v8

```console
$ docker pull mariadb@sha256:39e02e720613df4254a3e804b1355a35b92f663b20cb44465c473790b62c7285
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **142.8 MB (142832064 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:b2c11b5a9e3676f119ac653468bb8c431078adedaf820c2b42b57e5ddb83f73d`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mariadbd"]`

```dockerfile
# Tue, 03 Sep 2024 02:32:52 GMT
ADD file:b8ad50f3d6859f84ef1f5a65e6525025d882089a4bfbfe1c1a6dcec413b08335 in / 
# Tue, 03 Sep 2024 02:32:52 GMT
RUN mv -f /etc/yum.repos.d/ubi.repo /tmp || :
# Tue, 03 Sep 2024 02:32:52 GMT
ADD file:5b1f650e1376d79fa3a65df4a154ea5166def95154b52c1c1097dfd8fc7d58eb in /tmp/tls-ca-bundle.pem 
# Tue, 03 Sep 2024 02:32:52 GMT
ADD multi:d851b7f6b461892ebd008971ee8858113becab621ea011cd6ca3834693892de0 in /etc/yum.repos.d/ 
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL maintainer="Red Hat, Inc."
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL com.redhat.component="ubi9-minimal-container"       name="ubi9-minimal"       version="9.4"
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL com.redhat.license_terms="https://www.redhat.com/en/about/red-hat-end-user-license-agreements#UBI"
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL summary="Provides the latest release of the minimal Red Hat Universal Base Image 9."
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL description="The Universal Base Image Minimal is a stripped down image that uses microdnf as a package manager. This base image is freely redistributable, but Red Hat only supports Red Hat technologies through subscriptions for Red Hat products. This image is maintained by Red Hat and updated regularly."
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL io.k8s.display-name="Red Hat Universal Base Image 9 Minimal"
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL io.openshift.expose-services=""
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL io.openshift.tags="minimal rhel9"
# Tue, 03 Sep 2024 02:32:52 GMT
ENV container oci
# Tue, 03 Sep 2024 02:32:52 GMT
ENV PATH /usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin
# Tue, 03 Sep 2024 02:32:52 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:32:52 GMT
RUN rm -rf /var/log/*
# Tue, 03 Sep 2024 02:32:52 GMT
ADD file:1b5dd590117e3105bf4bc7bf3d14e32e15284033314e5016a8b6a569d1309f13 in /root/buildinfo/content_manifests/ubi9-minimal-container-9.4-1227.1726694542.json 
# Tue, 03 Sep 2024 02:32:52 GMT
ADD file:7d839fd792e21cdd37858c3a5300c195beb3df94eded547fbd1508ef81f3a0ce in /root/buildinfo/Dockerfile-ubi9-minimal-9.4-1227.1726694542 
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL "release"="1227.1726694542" "distribution-scope"="public" "vendor"="Red Hat, Inc." "build-date"="2024-09-18T21:23:26" "architecture"="aarch64" "vcs-type"="git" "vcs-ref"="94baa7760359088a42ad33dc22d329a5ee2c7209" "io.k8s.description"="The Universal Base Image Minimal is a stripped down image that uses microdnf as a package manager. This base image is freely redistributable, but Red Hat only supports Red Hat technologies through subscriptions for Red Hat products. This image is maintained by Red Hat and updated regularly." "url"="https://access.redhat.com/containers/#/registry.access.redhat.com/ubi9-minimal/images/9.4-1227.1726694542"
# Tue, 03 Sep 2024 02:32:52 GMT
RUN rm -f '/etc/yum.repos.d/odcs-3496922-3d51b.repo' '/etc/yum.repos.d/rhel-9.4-compose-34ae9.repo'
# Tue, 03 Sep 2024 02:32:52 GMT
RUN rm -f /tmp/tls-ca-bundle.pem
# Tue, 03 Sep 2024 02:32:52 GMT
RUN mv -fZ /tmp/ubi.repo /etc/yum.repos.d/ubi.repo || :
# Tue, 03 Sep 2024 02:32:52 GMT
RUN groupadd --gid 999 -r mysql && 	useradd -r -g mysql mysql --home-dir /var/lib/mysql --uid 999 # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:32:52 GMT
RUN set -eux; 	rpmArch="$(rpm --query --queryformat='%{ARCH}' rpm)"; 	case "$rpmArch" in 		aarch64) dpkgArch='arm64' ;; 		armv7*) dpkgArch='armhf' ;; 		i686) dpkgArch='i386' ;; 		ppc64le) dpkgArch='ppc64el' ;; 		s390x|riscv64) dpkgArch=$rpmArch ;; 		x86_64) dpkgArch='amd64' ;; 		*) echo >&2 "error: unknown/unsupported architecture '$rpmArch'"; exit 1 ;; 	esac; 	curl --fail --location --output /usr/local/bin/gosu https://github.com/tianon/gosu/releases/download/${GOSU_VERSION}/gosu-${dpkgArch} ; 	curl --fail --location --output /usr/local/bin/gosu.asc https://github.com/tianon/gosu/releases/download/${GOSU_VERSION}/gosu-${dpkgArch}.asc; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	chmod a+x /usr/local/bin/gosu; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
COPY --chmod=0644 docker.cnf /etc/my.cnf.d/ # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
COPY MariaDB.repo /etc/yum.repos.d/ # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL name=MariaDB Server vendor=MariaDB Community version=11.5.2 release=Refer to Annotations org.opencontainers.image.{revision,source} summary=MariaDB Database description=MariaDB Database for relational SQL
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/redhat/ubi9-minimal org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=11.5.2 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:32:52 GMT
ARG MARIADB_VERSION=11.5.2
# Tue, 03 Sep 2024 02:32:52 GMT
ENV MARIADB_VERSION=11.5.2
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: MARIADB_VERSION=11.5.2
RUN set -eux ; 	curl --fail https://pagure.io/fedora-web/websites/raw/master/f/sites/getfedora.org/static/keys/FF8AD1344597106ECE813B918A3872BF3228467C.txt --output /tmp/epelkey.txt ; 	GNUPGHOME="$(mktemp -d)"; export GNUPGHOME ; 	gpg --batch --import /tmp/epelkey.txt ; 	gpg --batch --armor --export FF8AD1344597106ECE813B918A3872BF3228467C > /tmp/epelkey.txt ; 	rpmkeys --import /tmp/epelkey.txt ; 	curl --fail https://dl.fedoraproject.org/pub/epel/epel-release-latest-9.noarch.rpm --output /tmp/epel-release-latest-9.noarch.rpm ; 	rpm -K /tmp/epel-release-latest-9.noarch.rpm ; 	rpm -ivh /tmp/epel-release-latest-9.noarch.rpm ; 	rm /tmp/epelkey.txt /tmp/epel-release-latest-9.noarch.rpm ; 	curl --fail https://supplychain.mariadb.com/MariaDB-Server-GPG-KEY --output /tmp/MariaDB-Server-GPG-KEY ; 	gpg --batch --import /tmp/MariaDB-Server-GPG-KEY; 	gpg --batch --armor --export 177F4010FE56CA3336300305F1656F24C74CD1D8 > /tmp/MariaDB-Server-GPG-KEY ; 	rpmkeys --import /tmp/MariaDB-Server-GPG-KEY ; 	rm -rf "$GNUPGHOME" /tmp/MariaDB-Server-GPG-KEY ; 	unset GNUPGHOME ; 	microdnf update -y ; 	microdnf reinstall -y tzdata ; 	microdnf install -y procps-ng zstd xz jemalloc pwgen pv ; 	mkdir -p /etc/mysql/conf.d /etc/mysql/mariadb.conf.d/ /var/lib/mysql/mysql /run/mariadb /usr/lib64/galera ; 	chmod ugo+rwx,o+t /run/mariadb ; 	microdnf install -y MariaDB-backup-${MARIADB_VERSION}  MariaDB-server-${MARIADB_VERSION} ; 	ln -s /usr/lib64/galera-4/libgalera_smm.so /usr/lib/libgalera_smm.so ; 	ln -s /usr/lib64/galera-4/libgalera_smm.so /usr/lib64/galera/libgalera_smm.so ; 	microdnf clean all ; 	rmdir /var/lib/mysql/mysql ; 	chown -R mysql:mysql /var/lib/mysql /run/mariadb ; 	mkdir /licenses ; 	ln -s /usr/share/doc/MariaDB-server-${MARIADB_VERSION}/COPYING /licenses/GPL-2 ; 	ln -s /usr/share/licenses /licenses/package-licenses ; 	ln -s Apache-2.0-license /licenses/gosu # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: MARIADB_VERSION=11.5.2
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:32:52 GMT
USER mysql
# Tue, 03 Sep 2024 02:32:52 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:32:52 GMT
CMD ["mariadbd"]
```

-	Layers:
	-	`sha256:b7ea02e7115a7f896de4b38813636b60adf943ded0dc88824bbe396f76e618a0`  
		Last Modified: Fri, 20 Sep 2024 03:47:54 GMT  
		Size: 37.3 MB (37335414 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:ac66a6b2f456ebd5339e0e42a175f892bf5a5415f33dca3cd54bec9f25c67531`  
		Last Modified: Tue, 24 Sep 2024 01:07:03 GMT  
		Size: 877.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:5b7784c6b2312bf92f295ad81c4d4a2701da7abcc2900c8481229122b44ef0b6`  
		Last Modified: Tue, 24 Sep 2024 01:07:03 GMT  
		Size: 913.8 KB (913812 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:335c15b9cf06809bfb0075fc81c9478b8e6a15df2e4ddfeefb0a28701202f45c`  
		Last Modified: Tue, 24 Sep 2024 01:08:22 GMT  
		Size: 314.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:1b0bc0e59fbc191a3e390afb5adc0e725f60e5a8fa11c1d9ad710dab8a1606d6`  
		Last Modified: Tue, 24 Sep 2024 01:08:23 GMT  
		Size: 309.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:0a2535ac52b80bbc2ec225f650ce61626ac604ab4dedbad54b4c468721a8b20f`  
		Last Modified: Tue, 24 Sep 2024 01:08:26 GMT  
		Size: 104.6 MB (104568818 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:4b6bdb3dd4de9efe813780112b4e8bd917182771898a6db8943de6ce061d52a0`  
		Last Modified: Tue, 24 Sep 2024 01:08:23 GMT  
		Size: 116.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:11c1ebf4384e51c2dee7f59796670688a3af60f5e3d78c83485ac0504075d262`  
		Last Modified: Tue, 24 Sep 2024 01:08:23 GMT  
		Size: 4.0 KB (3978 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:a2e3ffc44139bcd87bf3aa886a0cce211200bd5d9e906e60c3accd522f1e9aeb`  
		Last Modified: Tue, 24 Sep 2024 01:08:24 GMT  
		Size: 8.4 KB (8426 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:11-ubi` - unknown; unknown

```console
$ docker pull mariadb@sha256:d9203213ed9476012c5841340f734f6ca06db1fb7a1fd33ae6ec9252360aff1c
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.1 MB (4050313 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:207108a0405ed903de1a88ff3d469eeffc95c346557335146bb4135671851835`

```dockerfile
```

-	Layers:
	-	`sha256:85531e2b2ffac973c651155405bd201280f59a596d2353aa0c491aa4746b557f`  
		Last Modified: Tue, 24 Sep 2024 01:08:23 GMT  
		Size: 4.0 MB (4019829 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:a11197c3657914e16cc6867ca644ca2d28593a2948a1004b1735f65452aa6ab0`  
		Last Modified: Tue, 24 Sep 2024 01:08:22 GMT  
		Size: 30.5 KB (30484 bytes)  
		MIME: application/vnd.in-toto+json

### `mariadb:11-ubi` - linux; ppc64le

```console
$ docker pull mariadb@sha256:dd268c28789b4e0d607b688f883e4de3879c803da59c29ec4405e81b08d31078
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **156.9 MB (156917542 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:1bf5d983bc0bce32303d5d45ad77eb03c15f4c1fe2d7247e52b741266ece0442`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mariadbd"]`

```dockerfile
# Tue, 03 Sep 2024 02:32:52 GMT
ADD file:768947e71543f3d306ccb7844a46e1e32556950241f32410fa419d064856cb19 in / 
# Tue, 03 Sep 2024 02:32:52 GMT
RUN mv -f /etc/yum.repos.d/ubi.repo /tmp || :
# Tue, 03 Sep 2024 02:32:52 GMT
ADD file:5b1f650e1376d79fa3a65df4a154ea5166def95154b52c1c1097dfd8fc7d58eb in /tmp/tls-ca-bundle.pem 
# Tue, 03 Sep 2024 02:32:52 GMT
ADD multi:d851b7f6b461892ebd008971ee8858113becab621ea011cd6ca3834693892de0 in /etc/yum.repos.d/ 
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL maintainer="Red Hat, Inc."
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL com.redhat.component="ubi9-minimal-container"       name="ubi9-minimal"       version="9.4"
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL com.redhat.license_terms="https://www.redhat.com/en/about/red-hat-end-user-license-agreements#UBI"
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL summary="Provides the latest release of the minimal Red Hat Universal Base Image 9."
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL description="The Universal Base Image Minimal is a stripped down image that uses microdnf as a package manager. This base image is freely redistributable, but Red Hat only supports Red Hat technologies through subscriptions for Red Hat products. This image is maintained by Red Hat and updated regularly."
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL io.k8s.display-name="Red Hat Universal Base Image 9 Minimal"
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL io.openshift.expose-services=""
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL io.openshift.tags="minimal rhel9"
# Tue, 03 Sep 2024 02:32:52 GMT
ENV container oci
# Tue, 03 Sep 2024 02:32:52 GMT
ENV PATH /usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin
# Tue, 03 Sep 2024 02:32:52 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:32:52 GMT
RUN rm -rf /var/log/*
# Tue, 03 Sep 2024 02:32:52 GMT
ADD file:b67c0e7a04afadb6a5c642b16810b67dc1863b7bbfbb7821e18e5a4992e865c2 in /root/buildinfo/content_manifests/ubi9-minimal-container-9.4-1227.1726694542.json 
# Tue, 03 Sep 2024 02:32:52 GMT
ADD file:b10d88ff3ef2f9f197c2e406b732bc1a4de03c114efc0060dabb5d8a0ace9e3f in /root/buildinfo/Dockerfile-ubi9-minimal-9.4-1227.1726694542 
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL "release"="1227.1726694542" "distribution-scope"="public" "vendor"="Red Hat, Inc." "build-date"="2024-09-18T21:23:26" "architecture"="ppc64le" "vcs-type"="git" "vcs-ref"="94baa7760359088a42ad33dc22d329a5ee2c7209" "io.k8s.description"="The Universal Base Image Minimal is a stripped down image that uses microdnf as a package manager. This base image is freely redistributable, but Red Hat only supports Red Hat technologies through subscriptions for Red Hat products. This image is maintained by Red Hat and updated regularly." "url"="https://access.redhat.com/containers/#/registry.access.redhat.com/ubi9-minimal/images/9.4-1227.1726694542"
# Tue, 03 Sep 2024 02:32:52 GMT
RUN rm -f '/etc/yum.repos.d/odcs-3496922-3d51b.repo' '/etc/yum.repos.d/rhel-9.4-compose-34ae9.repo'
# Tue, 03 Sep 2024 02:32:52 GMT
RUN rm -f /tmp/tls-ca-bundle.pem
# Tue, 03 Sep 2024 02:32:52 GMT
RUN mv -fZ /tmp/ubi.repo /etc/yum.repos.d/ubi.repo || :
# Tue, 03 Sep 2024 02:32:52 GMT
RUN groupadd --gid 999 -r mysql && 	useradd -r -g mysql mysql --home-dir /var/lib/mysql --uid 999 # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:32:52 GMT
RUN set -eux; 	rpmArch="$(rpm --query --queryformat='%{ARCH}' rpm)"; 	case "$rpmArch" in 		aarch64) dpkgArch='arm64' ;; 		armv7*) dpkgArch='armhf' ;; 		i686) dpkgArch='i386' ;; 		ppc64le) dpkgArch='ppc64el' ;; 		s390x|riscv64) dpkgArch=$rpmArch ;; 		x86_64) dpkgArch='amd64' ;; 		*) echo >&2 "error: unknown/unsupported architecture '$rpmArch'"; exit 1 ;; 	esac; 	curl --fail --location --output /usr/local/bin/gosu https://github.com/tianon/gosu/releases/download/${GOSU_VERSION}/gosu-${dpkgArch} ; 	curl --fail --location --output /usr/local/bin/gosu.asc https://github.com/tianon/gosu/releases/download/${GOSU_VERSION}/gosu-${dpkgArch}.asc; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	chmod a+x /usr/local/bin/gosu; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
COPY --chmod=0644 docker.cnf /etc/my.cnf.d/ # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
COPY MariaDB.repo /etc/yum.repos.d/ # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL name=MariaDB Server vendor=MariaDB Community version=11.5.2 release=Refer to Annotations org.opencontainers.image.{revision,source} summary=MariaDB Database description=MariaDB Database for relational SQL
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/redhat/ubi9-minimal org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=11.5.2 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:32:52 GMT
ARG MARIADB_VERSION=11.5.2
# Tue, 03 Sep 2024 02:32:52 GMT
ENV MARIADB_VERSION=11.5.2
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: MARIADB_VERSION=11.5.2
RUN set -eux ; 	curl --fail https://pagure.io/fedora-web/websites/raw/master/f/sites/getfedora.org/static/keys/FF8AD1344597106ECE813B918A3872BF3228467C.txt --output /tmp/epelkey.txt ; 	GNUPGHOME="$(mktemp -d)"; export GNUPGHOME ; 	gpg --batch --import /tmp/epelkey.txt ; 	gpg --batch --armor --export FF8AD1344597106ECE813B918A3872BF3228467C > /tmp/epelkey.txt ; 	rpmkeys --import /tmp/epelkey.txt ; 	curl --fail https://dl.fedoraproject.org/pub/epel/epel-release-latest-9.noarch.rpm --output /tmp/epel-release-latest-9.noarch.rpm ; 	rpm -K /tmp/epel-release-latest-9.noarch.rpm ; 	rpm -ivh /tmp/epel-release-latest-9.noarch.rpm ; 	rm /tmp/epelkey.txt /tmp/epel-release-latest-9.noarch.rpm ; 	curl --fail https://supplychain.mariadb.com/MariaDB-Server-GPG-KEY --output /tmp/MariaDB-Server-GPG-KEY ; 	gpg --batch --import /tmp/MariaDB-Server-GPG-KEY; 	gpg --batch --armor --export 177F4010FE56CA3336300305F1656F24C74CD1D8 > /tmp/MariaDB-Server-GPG-KEY ; 	rpmkeys --import /tmp/MariaDB-Server-GPG-KEY ; 	rm -rf "$GNUPGHOME" /tmp/MariaDB-Server-GPG-KEY ; 	unset GNUPGHOME ; 	microdnf update -y ; 	microdnf reinstall -y tzdata ; 	microdnf install -y procps-ng zstd xz jemalloc pwgen pv ; 	mkdir -p /etc/mysql/conf.d /etc/mysql/mariadb.conf.d/ /var/lib/mysql/mysql /run/mariadb /usr/lib64/galera ; 	chmod ugo+rwx,o+t /run/mariadb ; 	microdnf install -y MariaDB-backup-${MARIADB_VERSION}  MariaDB-server-${MARIADB_VERSION} ; 	ln -s /usr/lib64/galera-4/libgalera_smm.so /usr/lib/libgalera_smm.so ; 	ln -s /usr/lib64/galera-4/libgalera_smm.so /usr/lib64/galera/libgalera_smm.so ; 	microdnf clean all ; 	rmdir /var/lib/mysql/mysql ; 	chown -R mysql:mysql /var/lib/mysql /run/mariadb ; 	mkdir /licenses ; 	ln -s /usr/share/doc/MariaDB-server-${MARIADB_VERSION}/COPYING /licenses/GPL-2 ; 	ln -s /usr/share/licenses /licenses/package-licenses ; 	ln -s Apache-2.0-license /licenses/gosu # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: MARIADB_VERSION=11.5.2
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:32:52 GMT
USER mysql
# Tue, 03 Sep 2024 02:32:52 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:32:52 GMT
CMD ["mariadbd"]
```

-	Layers:
	-	`sha256:e31ac149cb4a1eda22cb8c0e4ae005a8c53c5e2e4fd29c118b346755b642aeb9`  
		Last Modified: Mon, 23 Sep 2024 18:10:35 GMT  
		Size: 43.6 MB (43591438 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:b7ab1fae09b70fe299c7add8f5d344c53ae046c2b8df185f1ec63a51f6b2f01f`  
		Last Modified: Tue, 24 Sep 2024 01:10:00 GMT  
		Size: 881.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:fee3c26f6263f7a47fdbc58f8940b6418f6e2103bd1de0f9b5b5b38bd0631165`  
		Last Modified: Tue, 24 Sep 2024 01:10:01 GMT  
		Size: 904.3 KB (904305 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:227509668dac88be094b9c148803289664e5781e73513034c33896f79447d31c`  
		Last Modified: Tue, 24 Sep 2024 01:11:53 GMT  
		Size: 316.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:eb0c25de2631bad83715bb492ad243e56973d60e3ef594651303cefc6a6f0f5a`  
		Last Modified: Tue, 24 Sep 2024 01:11:53 GMT  
		Size: 315.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:5e54bcae154d24153978ec5fe5d391eb236b5a7d2b86ac586f28427528af7752`  
		Last Modified: Tue, 24 Sep 2024 01:11:57 GMT  
		Size: 112.4 MB (112407769 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:f0cef2f545af98877fa77eeefff5a305150616bcb2666b274ae86acd815bb230`  
		Last Modified: Tue, 24 Sep 2024 01:11:53 GMT  
		Size: 114.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:63ab1fe54f85089b1f0f4e00fc8ccaa1fc8fed9cb215ead0ed67148e90974338`  
		Last Modified: Tue, 24 Sep 2024 01:11:54 GMT  
		Size: 4.0 KB (3977 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:2e410f15f5469ae10350aa5d413605c4aa9e62cebdc4b22757df91317dbe0d8d`  
		Last Modified: Tue, 24 Sep 2024 01:11:54 GMT  
		Size: 8.4 KB (8427 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:11-ubi` - unknown; unknown

```console
$ docker pull mariadb@sha256:69cb081b206d863390811f837e3907525b86ee2345cbbf298b8acf3933694de9
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.1 MB (4051242 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:6accc73c6af4a842ed9100edd274a9320fda9d3a6be1dd69f81321e28c9ca4f7`

```dockerfile
```

-	Layers:
	-	`sha256:0c314545a3d48321281c513aaf92c7e8ee1a35250200b85deb1a6615b9618ddb`  
		Last Modified: Tue, 24 Sep 2024 01:11:54 GMT  
		Size: 4.0 MB (4021034 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:c6f1e291b79910c83c8cc89b400e7a2c73ddb18d0a067e1cceba8b129f20ef4c`  
		Last Modified: Tue, 24 Sep 2024 01:11:53 GMT  
		Size: 30.2 KB (30208 bytes)  
		MIME: application/vnd.in-toto+json

### `mariadb:11-ubi` - linux; s390x

```console
$ docker pull mariadb@sha256:63623b57f75c8588649c6c2c7ad834dd1bbc217cfd9c91b3afadad62b6838d92
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **145.1 MB (145118152 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:741489cd3642530b20305f76c529e1dd6befcc0854c82066b1005be3b618ada0`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mariadbd"]`

```dockerfile
# Tue, 03 Sep 2024 02:32:52 GMT
ADD file:21b7ed3b2258da5b5d030b86d62b0787dcd37b89f90dcc66430117025bb05f28 in / 
# Tue, 03 Sep 2024 02:32:52 GMT
RUN mv -f /etc/yum.repos.d/ubi.repo /tmp || :
# Tue, 03 Sep 2024 02:32:52 GMT
ADD file:5b1f650e1376d79fa3a65df4a154ea5166def95154b52c1c1097dfd8fc7d58eb in /tmp/tls-ca-bundle.pem 
# Tue, 03 Sep 2024 02:32:52 GMT
ADD multi:d851b7f6b461892ebd008971ee8858113becab621ea011cd6ca3834693892de0 in /etc/yum.repos.d/ 
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL maintainer="Red Hat, Inc."
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL com.redhat.component="ubi9-minimal-container"       name="ubi9-minimal"       version="9.4"
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL com.redhat.license_terms="https://www.redhat.com/en/about/red-hat-end-user-license-agreements#UBI"
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL summary="Provides the latest release of the minimal Red Hat Universal Base Image 9."
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL description="The Universal Base Image Minimal is a stripped down image that uses microdnf as a package manager. This base image is freely redistributable, but Red Hat only supports Red Hat technologies through subscriptions for Red Hat products. This image is maintained by Red Hat and updated regularly."
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL io.k8s.display-name="Red Hat Universal Base Image 9 Minimal"
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL io.openshift.expose-services=""
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL io.openshift.tags="minimal rhel9"
# Tue, 03 Sep 2024 02:32:52 GMT
ENV container oci
# Tue, 03 Sep 2024 02:32:52 GMT
ENV PATH /usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin
# Tue, 03 Sep 2024 02:32:52 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:32:52 GMT
RUN rm -rf /var/log/*
# Tue, 03 Sep 2024 02:32:52 GMT
ADD file:ce3abbd79cb8c99cd1c0e2f5562e76837cd37c2684866f11810f889122c06843 in /root/buildinfo/content_manifests/ubi9-minimal-container-9.4-1227.1726694542.json 
# Tue, 03 Sep 2024 02:32:52 GMT
ADD file:ac24882cff4e990075d0c05821308e37e323ed349a4be0a2192cde67bcc09b3f in /root/buildinfo/Dockerfile-ubi9-minimal-9.4-1227.1726694542 
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL "release"="1227.1726694542" "distribution-scope"="public" "vendor"="Red Hat, Inc." "build-date"="2024-09-18T21:23:26" "architecture"="s390x" "vcs-type"="git" "vcs-ref"="94baa7760359088a42ad33dc22d329a5ee2c7209" "io.k8s.description"="The Universal Base Image Minimal is a stripped down image that uses microdnf as a package manager. This base image is freely redistributable, but Red Hat only supports Red Hat technologies through subscriptions for Red Hat products. This image is maintained by Red Hat and updated regularly." "url"="https://access.redhat.com/containers/#/registry.access.redhat.com/ubi9-minimal/images/9.4-1227.1726694542"
# Tue, 03 Sep 2024 02:32:52 GMT
RUN rm -f '/etc/yum.repos.d/odcs-3496922-3d51b.repo' '/etc/yum.repos.d/rhel-9.4-compose-34ae9.repo'
# Tue, 03 Sep 2024 02:32:52 GMT
RUN rm -f /tmp/tls-ca-bundle.pem
# Tue, 03 Sep 2024 02:32:52 GMT
RUN mv -fZ /tmp/ubi.repo /etc/yum.repos.d/ubi.repo || :
# Tue, 03 Sep 2024 02:32:52 GMT
RUN groupadd --gid 999 -r mysql && 	useradd -r -g mysql mysql --home-dir /var/lib/mysql --uid 999 # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:32:52 GMT
RUN set -eux; 	rpmArch="$(rpm --query --queryformat='%{ARCH}' rpm)"; 	case "$rpmArch" in 		aarch64) dpkgArch='arm64' ;; 		armv7*) dpkgArch='armhf' ;; 		i686) dpkgArch='i386' ;; 		ppc64le) dpkgArch='ppc64el' ;; 		s390x|riscv64) dpkgArch=$rpmArch ;; 		x86_64) dpkgArch='amd64' ;; 		*) echo >&2 "error: unknown/unsupported architecture '$rpmArch'"; exit 1 ;; 	esac; 	curl --fail --location --output /usr/local/bin/gosu https://github.com/tianon/gosu/releases/download/${GOSU_VERSION}/gosu-${dpkgArch} ; 	curl --fail --location --output /usr/local/bin/gosu.asc https://github.com/tianon/gosu/releases/download/${GOSU_VERSION}/gosu-${dpkgArch}.asc; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	chmod a+x /usr/local/bin/gosu; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
COPY --chmod=0644 docker.cnf /etc/my.cnf.d/ # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
COPY MariaDB.repo /etc/yum.repos.d/ # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL name=MariaDB Server vendor=MariaDB Community version=11.5.2 release=Refer to Annotations org.opencontainers.image.{revision,source} summary=MariaDB Database description=MariaDB Database for relational SQL
# Tue, 03 Sep 2024 02:32:52 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/redhat/ubi9-minimal org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=11.5.2 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:32:52 GMT
ARG MARIADB_VERSION=11.5.2
# Tue, 03 Sep 2024 02:32:52 GMT
ENV MARIADB_VERSION=11.5.2
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: MARIADB_VERSION=11.5.2
RUN set -eux ; 	curl --fail https://pagure.io/fedora-web/websites/raw/master/f/sites/getfedora.org/static/keys/FF8AD1344597106ECE813B918A3872BF3228467C.txt --output /tmp/epelkey.txt ; 	GNUPGHOME="$(mktemp -d)"; export GNUPGHOME ; 	gpg --batch --import /tmp/epelkey.txt ; 	gpg --batch --armor --export FF8AD1344597106ECE813B918A3872BF3228467C > /tmp/epelkey.txt ; 	rpmkeys --import /tmp/epelkey.txt ; 	curl --fail https://dl.fedoraproject.org/pub/epel/epel-release-latest-9.noarch.rpm --output /tmp/epel-release-latest-9.noarch.rpm ; 	rpm -K /tmp/epel-release-latest-9.noarch.rpm ; 	rpm -ivh /tmp/epel-release-latest-9.noarch.rpm ; 	rm /tmp/epelkey.txt /tmp/epel-release-latest-9.noarch.rpm ; 	curl --fail https://supplychain.mariadb.com/MariaDB-Server-GPG-KEY --output /tmp/MariaDB-Server-GPG-KEY ; 	gpg --batch --import /tmp/MariaDB-Server-GPG-KEY; 	gpg --batch --armor --export 177F4010FE56CA3336300305F1656F24C74CD1D8 > /tmp/MariaDB-Server-GPG-KEY ; 	rpmkeys --import /tmp/MariaDB-Server-GPG-KEY ; 	rm -rf "$GNUPGHOME" /tmp/MariaDB-Server-GPG-KEY ; 	unset GNUPGHOME ; 	microdnf update -y ; 	microdnf reinstall -y tzdata ; 	microdnf install -y procps-ng zstd xz jemalloc pwgen pv ; 	mkdir -p /etc/mysql/conf.d /etc/mysql/mariadb.conf.d/ /var/lib/mysql/mysql /run/mariadb /usr/lib64/galera ; 	chmod ugo+rwx,o+t /run/mariadb ; 	microdnf install -y MariaDB-backup-${MARIADB_VERSION}  MariaDB-server-${MARIADB_VERSION} ; 	ln -s /usr/lib64/galera-4/libgalera_smm.so /usr/lib/libgalera_smm.so ; 	ln -s /usr/lib64/galera-4/libgalera_smm.so /usr/lib64/galera/libgalera_smm.so ; 	microdnf clean all ; 	rmdir /var/lib/mysql/mysql ; 	chown -R mysql:mysql /var/lib/mysql /run/mariadb ; 	mkdir /licenses ; 	ln -s /usr/share/doc/MariaDB-server-${MARIADB_VERSION}/COPYING /licenses/GPL-2 ; 	ln -s /usr/share/licenses /licenses/package-licenses ; 	ln -s Apache-2.0-license /licenses/gosu # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:32:52 GMT
# ARGS: MARIADB_VERSION=11.5.2
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:32:52 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:32:52 GMT
USER mysql
# Tue, 03 Sep 2024 02:32:52 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:32:52 GMT
CMD ["mariadbd"]
```

-	Layers:
	-	`sha256:9d38740decc88f04976b3123db64216586005286cafbf52d64706fa02375bde9`  
		Last Modified: Mon, 23 Sep 2024 18:10:42 GMT  
		Size: 37.4 MB (37364487 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:9c5857c8d38d69e562e0a0baa41584eb253f623761bed2effe5ecf22ce922f69`  
		Last Modified: Tue, 24 Sep 2024 01:16:07 GMT  
		Size: 879.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:687ae40a214375910ccc090b011ba70d346b479fbee3d1033e49e3f25c002760`  
		Last Modified: Tue, 24 Sep 2024 01:16:07 GMT  
		Size: 948.1 KB (948121 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:2ff7b3b830011636800d6bdb3bae5f36e557d9eff77dcf2ca822f5c7b409df0f`  
		Last Modified: Tue, 24 Sep 2024 01:17:45 GMT  
		Size: 317.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:3d8e12e83870e8c8a784cc9b2acd79cdc2f1d529b406c5f90aaf4c414e6c6bf6`  
		Last Modified: Tue, 24 Sep 2024 01:17:45 GMT  
		Size: 313.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:e64bd42b80777326efd773170b010bf359a91119d6193d23722786175c2a7512`  
		Last Modified: Tue, 24 Sep 2024 01:17:47 GMT  
		Size: 106.8 MB (106791512 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:ff2669d7b46c258298ecada2996a05009a88f2a74203a2a50ad5aebd7471701f`  
		Last Modified: Tue, 24 Sep 2024 01:17:46 GMT  
		Size: 116.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:7233b764b7f8d8690b8b81b5918a169518fddc3beda1b96125a8c0f62b38f344`  
		Last Modified: Tue, 24 Sep 2024 01:17:46 GMT  
		Size: 4.0 KB (3979 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:e366a02268b6bd8d20ff32ceda2640d2b10f64868f125a35a9e066f51c422e2e`  
		Last Modified: Tue, 24 Sep 2024 01:17:46 GMT  
		Size: 8.4 KB (8428 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:11-ubi` - unknown; unknown

```console
$ docker pull mariadb@sha256:174e70fda261486af3ed104c7fb4299a3a092bbc1f48553c160c6a305cbc5696
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.1 MB (4051171 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:b32104a16d385c2a0369bd65551f27b7757af17287bf52d8084290e78ac0bc7e`

```dockerfile
```

-	Layers:
	-	`sha256:d9cdba501ff406c1aea05aa2efd2e43ee3143c83dd38e3996e7113b6a91bf071`  
		Last Modified: Tue, 24 Sep 2024 01:17:45 GMT  
		Size: 4.0 MB (4021019 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:0865743552e78fefd0834add0decf48f2c97c5779c426544e22709b58ea66190`  
		Last Modified: Tue, 24 Sep 2024 01:17:45 GMT  
		Size: 30.2 KB (30152 bytes)  
		MIME: application/vnd.in-toto+json
