## `mariadb:10.6`

```console
$ docker pull mariadb@sha256:aaf44ec55c0513da24d0a893b79821095d1cf41de9d3dfb60257846d7f20da5c
```

-	Manifest MIME: `application/vnd.oci.image.index.v1+json`
-	Platforms: 8
	-	linux; amd64
	-	unknown; unknown
	-	linux; arm64 variant v8
	-	unknown; unknown
	-	linux; ppc64le
	-	unknown; unknown
	-	linux; s390x
	-	unknown; unknown

### `mariadb:10.6` - linux; amd64

```console
$ docker pull mariadb@sha256:dfc3273c65d43677180a2ce67ac8e941b1c5cfbea4027a2fc78842cfc8cde0b7
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **121.1 MB (121133834 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:17085c4029162a7cbcda86a8c83760bdda7462ef2626240bf4cd123f2a3258de`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mariadbd"]`

```dockerfile
# Tue, 03 Sep 2024 02:17:54 GMT
ARG RELEASE
# Tue, 03 Sep 2024 02:17:54 GMT
ARG LAUNCHPAD_BUILD_ARCH
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.ref.name=ubuntu
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.version=20.04
# Tue, 03 Sep 2024 02:17:54 GMT
ADD file:7486147a645d8835a5181c79f00a3606c6b714c83bcbfcd8862221eb14690f9e in / 
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:17:54 GMT
RUN groupadd -r mysql && useradd -r -g mysql mysql --home-dir /var/lib/mysql # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:17:54 GMT
ARG GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN set -eux; 	apt-get update; 	DEBIAN_FRONTEND=noninteractive apt-get install -y --no-install-recommends 		ca-certificates 		gpg 		gpgv 		libjemalloc2 		pwgen 		tzdata 		xz-utils 		zstd ; 	savedAptMark="$(apt-mark showmanual)"; 	apt-get install -y --no-install-recommends 		dirmngr 		gpg-agent 		wget; 	rm -rf /var/lib/apt/lists/*; 	dpkgArch="$(dpkg --print-architecture | awk -F- '{ print $NF }')"; 	wget -q -O /usr/local/bin/gosu "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch"; 	wget -q -O /usr/local/bin/gosu.asc "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch.asc"; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	for key in $GPG_KEYS; do 		gpg --batch --keyserver keyserver.ubuntu.com --recv-keys "$key"; 	done; 	gpg --batch --export "$GPG_KEYS" > /etc/apt/trusted.gpg.d/mariadb.gpg; 	if command -v gpgconf >/dev/null; then 		gpgconf --kill all; 	fi; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	apt-mark auto '.*' > /dev/null; 	[ -z "$savedAptMark" ] ||	apt-mark manual $savedAptMark >/dev/null; 	apt-get purge -y --auto-remove -o APT::AutoRemove::RecommendsImportant=false; 	chmod +x /usr/local/bin/gosu; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV LANG=C.UTF-8
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/library/ubuntu:focal org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=10.6.19 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_MAJOR=10.6
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_MAJOR=10.6
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_VERSION=1:10.6.19+maria~ubu2004
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_VERSION=1:10.6.19+maria~ubu2004
# Tue, 03 Sep 2024 02:17:54 GMT
ARG REPOSITORY=http://archive.mariadb.org/mariadb-10.6.19/repo/ubuntu/ focal main main/debug
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_MAJOR=10.6 MARIADB_VERSION=1:10.6.19+maria~ubu2004 REPOSITORY=http://archive.mariadb.org/mariadb-10.6.19/repo/ubuntu/ focal main main/debug
RUN set -e;	echo "deb ${REPOSITORY}" > /etc/apt/sources.list.d/mariadb.list; 	{ 		echo 'Package: *'; 		echo 'Pin: release o=MariaDB'; 		echo 'Pin-Priority: 999'; 	} > /etc/apt/preferences.d/mariadb # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_MAJOR=10.6 MARIADB_VERSION=1:10.6.19+maria~ubu2004 REPOSITORY=http://archive.mariadb.org/mariadb-10.6.19/repo/ubuntu/ focal main main/debug
RUN set -ex; 	{ 		echo "mariadb-server-$MARIADB_MAJOR" mysql-server/root_password password 'unused'; 		echo "mariadb-server-$MARIADB_MAJOR" mysql-server/root_password_again password 'unused'; 	} | debconf-set-selections; 	apt-get update; 	mkdir -p /var/lib/mysql/mysql ; touch /var/lib/mysql/mysql/user.frm ; 	apt-get install -y --no-install-recommends mariadb-server="$MARIADB_VERSION" mariadb-backup socat 	; 	rm -rf /var/lib/apt/lists/*; 	rm -rf /var/lib/mysql /etc/mysql/mariadb.conf.d/50-mysqld_safe.cnf; 	mkdir -p /var/lib/mysql /run/mysqld; 	chown -R mysql:mysql /var/lib/mysql /run/mysqld; 	chmod 1777 /run/mysqld; 	find /etc/mysql/ -name '*.cnf' -print0 		| xargs -0 grep -lZE '^(bind-address|log|user\s)' 		| xargs -rt -0 sed -Ei 's/^(bind-address|log|user\s)/#&/'; 	printf "[mariadb]\nhost-cache-size=0\nskip-name-resolve\n" > /etc/mysql/mariadb.conf.d/05-skipcache.cnf; 	if [ -L /etc/mysql/my.cnf ]; then 		sed -i -e '/includedir/ {N;s/\(.*\)\n\(.*\)/\n\2\n\1/}' /etc/mysql/mariadb.cnf; 	fi # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:17:54 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:17:54 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["mariadbd"]
```

-	Layers:
	-	`sha256:d9802f032d6798e2086607424bfe88cb8ec1d6f116e11cd99592dcaf261e9cd2`  
		Last Modified: Fri, 11 Oct 2024 04:41:25 GMT  
		Size: 27.5 MB (27511060 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:c5a65b879ae23973eb9f12748bd8c40114fe3c99c7c310109672fdaff9fe5b0c`  
		Last Modified: Wed, 16 Oct 2024 16:14:01 GMT  
		Size: 1.7 KB (1717 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:7907d0087b0012e4453e85dae5395cb69943f37a56dc98b81469f29a5b33f809`  
		Last Modified: Wed, 16 Oct 2024 16:14:01 GMT  
		Size: 7.2 MB (7192911 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:ebf3425cfcb3087819a9d2461c64ace7db9d5b64f5d866aa1c0662d38f655756`  
		Last Modified: Wed, 16 Oct 2024 16:14:01 GMT  
		Size: 116.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:ca046fd35212238de1ece34d4a7f763840627305c9da40e2eaa46aecf14105ca`  
		Last Modified: Wed, 16 Oct 2024 16:14:01 GMT  
		Size: 333.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:7167d5a9dbcd38d8cb5d9bde10b868d01f430beb18166c003d30bd810bda6ab9`  
		Last Modified: Wed, 16 Oct 2024 16:14:03 GMT  
		Size: 86.4 MB (86415491 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:211ee8020ea4c99ece8ee0d8e25961b59f1907012e0eba30d0ffd02827cdda53`  
		Last Modified: Wed, 16 Oct 2024 16:14:02 GMT  
		Size: 4.0 KB (3956 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:850797b444621c20b3bf0c62076520fdf01ccf970f9151e4bf6c9148e36b018b`  
		Last Modified: Wed, 16 Oct 2024 16:14:02 GMT  
		Size: 8.2 KB (8250 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:10.6` - unknown; unknown

```console
$ docker pull mariadb@sha256:1112a94868046229bb82e52215d78232c48fbf6f39926a623b7dc389911f2926
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.5 MB (4486532 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:723fea97ed2546c9e6b5fcc19ebfc2737ccafd929a50458ad8baead167698930`

```dockerfile
```

-	Layers:
	-	`sha256:081a2df91a25fa96caeb4fa13066d7e34f979a5fed2990d2fcbacea779ed0b55`  
		Last Modified: Wed, 16 Oct 2024 16:14:01 GMT  
		Size: 4.5 MB (4456486 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:d2e4dc81dd874e99e5d32f6c75ecb18a753fddead3846f862545c1c491879301`  
		Last Modified: Wed, 16 Oct 2024 16:14:01 GMT  
		Size: 30.0 KB (30046 bytes)  
		MIME: application/vnd.in-toto+json

### `mariadb:10.6` - linux; arm64 variant v8

```console
$ docker pull mariadb@sha256:02662a1b77ce0031ebbba3a0eb4059eaa745060bb363a16ab6d4b2e351502444
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **118.2 MB (118244718 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:15394fdabc998df2c368bbec03a6f44e01fdd5b8cbd680fd08621ba68883adba`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mariadbd"]`

```dockerfile
# Tue, 03 Sep 2024 02:17:54 GMT
ARG RELEASE
# Tue, 03 Sep 2024 02:17:54 GMT
ARG LAUNCHPAD_BUILD_ARCH
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.ref.name=ubuntu
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.version=20.04
# Tue, 03 Sep 2024 02:17:54 GMT
ADD file:8537b4db344382b39d669af27cd94ec0f870ceafe58c67ee54e3f9b38fb8d671 in / 
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:17:54 GMT
RUN groupadd -r mysql && useradd -r -g mysql mysql --home-dir /var/lib/mysql # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:17:54 GMT
ARG GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN set -eux; 	apt-get update; 	DEBIAN_FRONTEND=noninteractive apt-get install -y --no-install-recommends 		ca-certificates 		gpg 		gpgv 		libjemalloc2 		pwgen 		tzdata 		xz-utils 		zstd ; 	savedAptMark="$(apt-mark showmanual)"; 	apt-get install -y --no-install-recommends 		dirmngr 		gpg-agent 		wget; 	rm -rf /var/lib/apt/lists/*; 	dpkgArch="$(dpkg --print-architecture | awk -F- '{ print $NF }')"; 	wget -q -O /usr/local/bin/gosu "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch"; 	wget -q -O /usr/local/bin/gosu.asc "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch.asc"; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	for key in $GPG_KEYS; do 		gpg --batch --keyserver keyserver.ubuntu.com --recv-keys "$key"; 	done; 	gpg --batch --export "$GPG_KEYS" > /etc/apt/trusted.gpg.d/mariadb.gpg; 	if command -v gpgconf >/dev/null; then 		gpgconf --kill all; 	fi; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	apt-mark auto '.*' > /dev/null; 	[ -z "$savedAptMark" ] ||	apt-mark manual $savedAptMark >/dev/null; 	apt-get purge -y --auto-remove -o APT::AutoRemove::RecommendsImportant=false; 	chmod +x /usr/local/bin/gosu; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV LANG=C.UTF-8
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/library/ubuntu:focal org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=10.6.19 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_MAJOR=10.6
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_MAJOR=10.6
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_VERSION=1:10.6.19+maria~ubu2004
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_VERSION=1:10.6.19+maria~ubu2004
# Tue, 03 Sep 2024 02:17:54 GMT
ARG REPOSITORY=http://archive.mariadb.org/mariadb-10.6.19/repo/ubuntu/ focal main main/debug
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_MAJOR=10.6 MARIADB_VERSION=1:10.6.19+maria~ubu2004 REPOSITORY=http://archive.mariadb.org/mariadb-10.6.19/repo/ubuntu/ focal main main/debug
RUN set -e;	echo "deb ${REPOSITORY}" > /etc/apt/sources.list.d/mariadb.list; 	{ 		echo 'Package: *'; 		echo 'Pin: release o=MariaDB'; 		echo 'Pin-Priority: 999'; 	} > /etc/apt/preferences.d/mariadb # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_MAJOR=10.6 MARIADB_VERSION=1:10.6.19+maria~ubu2004 REPOSITORY=http://archive.mariadb.org/mariadb-10.6.19/repo/ubuntu/ focal main main/debug
RUN set -ex; 	{ 		echo "mariadb-server-$MARIADB_MAJOR" mysql-server/root_password password 'unused'; 		echo "mariadb-server-$MARIADB_MAJOR" mysql-server/root_password_again password 'unused'; 	} | debconf-set-selections; 	apt-get update; 	mkdir -p /var/lib/mysql/mysql ; touch /var/lib/mysql/mysql/user.frm ; 	apt-get install -y --no-install-recommends mariadb-server="$MARIADB_VERSION" mariadb-backup socat 	; 	rm -rf /var/lib/apt/lists/*; 	rm -rf /var/lib/mysql /etc/mysql/mariadb.conf.d/50-mysqld_safe.cnf; 	mkdir -p /var/lib/mysql /run/mysqld; 	chown -R mysql:mysql /var/lib/mysql /run/mysqld; 	chmod 1777 /run/mysqld; 	find /etc/mysql/ -name '*.cnf' -print0 		| xargs -0 grep -lZE '^(bind-address|log|user\s)' 		| xargs -rt -0 sed -Ei 's/^(bind-address|log|user\s)/#&/'; 	printf "[mariadb]\nhost-cache-size=0\nskip-name-resolve\n" > /etc/mysql/mariadb.conf.d/05-skipcache.cnf; 	if [ -L /etc/mysql/my.cnf ]; then 		sed -i -e '/includedir/ {N;s/\(.*\)\n\(.*\)/\n\2\n\1/}' /etc/mysql/mariadb.cnf; 	fi # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:17:54 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:17:54 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["mariadbd"]
```

-	Layers:
	-	`sha256:1b9f3c55f9d4aa5c52eb67a4cb7d0f4726ab85a413b50e3e3fe788befce3d297`  
		Last Modified: Fri, 11 Oct 2024 04:41:30 GMT  
		Size: 26.0 MB (25973828 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:85e6fc4d1431180a6ac68cb917d07ac474c380d6c6427f2c6876515bdc5fbb0d`  
		Last Modified: Wed, 16 Oct 2024 03:43:00 GMT  
		Size: 1.7 KB (1724 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:222659d6d32721cd1a050cdbba4b3021ae5f4c4d180e4b4be2459cfbf92bde66`  
		Last Modified: Wed, 16 Oct 2024 03:43:00 GMT  
		Size: 6.9 MB (6923179 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:184781552495db7f15e9e552bda8e4581d9f518031fe71ed1a0a8c0b27ec15fa`  
		Last Modified: Wed, 16 Oct 2024 03:43:00 GMT  
		Size: 116.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:25edab4e4198e15db358b8d1c278cf0b7714a8a040fd3c68682b1b409598d1f2`  
		Last Modified: Wed, 16 Oct 2024 03:43:00 GMT  
		Size: 332.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:190b76ca89b417c2f6121999bacc5d1f761f8b30c61b0a75e6e53bef17166ba9`  
		Last Modified: Wed, 16 Oct 2024 03:43:03 GMT  
		Size: 85.3 MB (85333337 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:96095486eb8cf42ffed664c53139b620186757588c29b043dc12ce2aaa6fc232`  
		Last Modified: Wed, 16 Oct 2024 03:43:01 GMT  
		Size: 4.0 KB (3953 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:576c825e4c7dcbbaa1dc63a91e19823ca79907882c63aadfefb0504ecfee7f9f`  
		Last Modified: Wed, 16 Oct 2024 03:43:01 GMT  
		Size: 8.2 KB (8249 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:10.6` - unknown; unknown

```console
$ docker pull mariadb@sha256:0648943516a018e9f7d23e72b93f775d91ba00b67ed3d495d99effa0a1263d58
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.5 MB (4493062 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:f6f1cdc4b691bfe26686425fe83f08cc7b1469f78d7360ca33e2ffa64513998d`

```dockerfile
```

-	Layers:
	-	`sha256:26b041ac1e1f2181efaaa30ff2b246da81b8339d713a13445956f94a9c502409`  
		Last Modified: Wed, 16 Oct 2024 03:43:00 GMT  
		Size: 4.5 MB (4462858 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:6c2efa4bc316a0ae4ed3ebab0192eba6da3f28ff44a65448e1cc062ebf6e5c97`  
		Last Modified: Wed, 16 Oct 2024 03:43:00 GMT  
		Size: 30.2 KB (30204 bytes)  
		MIME: application/vnd.in-toto+json

### `mariadb:10.6` - linux; ppc64le

```console
$ docker pull mariadb@sha256:8cc62ffaf53d76b356317ed05b41b44f6a288c232f101e5f2e5a30f08e721578
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **130.8 MB (130752692 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:5995f9f7cbc4f10fd4739d9e3bec04acb3fef44e4f0c96edc60f66554ff84845`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mariadbd"]`

```dockerfile
# Tue, 03 Sep 2024 02:17:54 GMT
ARG RELEASE
# Tue, 03 Sep 2024 02:17:54 GMT
ARG LAUNCHPAD_BUILD_ARCH
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.ref.name=ubuntu
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.version=20.04
# Tue, 03 Sep 2024 02:17:54 GMT
ADD file:869a92a1e06a4985a0281417502ee0c0d8ba6cc4e0b72062dd8e4eb87833bae7 in / 
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:17:54 GMT
RUN groupadd -r mysql && useradd -r -g mysql mysql --home-dir /var/lib/mysql # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:17:54 GMT
ARG GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN set -eux; 	apt-get update; 	DEBIAN_FRONTEND=noninteractive apt-get install -y --no-install-recommends 		ca-certificates 		gpg 		gpgv 		libjemalloc2 		pwgen 		tzdata 		xz-utils 		zstd ; 	savedAptMark="$(apt-mark showmanual)"; 	apt-get install -y --no-install-recommends 		dirmngr 		gpg-agent 		wget; 	rm -rf /var/lib/apt/lists/*; 	dpkgArch="$(dpkg --print-architecture | awk -F- '{ print $NF }')"; 	wget -q -O /usr/local/bin/gosu "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch"; 	wget -q -O /usr/local/bin/gosu.asc "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch.asc"; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	for key in $GPG_KEYS; do 		gpg --batch --keyserver keyserver.ubuntu.com --recv-keys "$key"; 	done; 	gpg --batch --export "$GPG_KEYS" > /etc/apt/trusted.gpg.d/mariadb.gpg; 	if command -v gpgconf >/dev/null; then 		gpgconf --kill all; 	fi; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	apt-mark auto '.*' > /dev/null; 	[ -z "$savedAptMark" ] ||	apt-mark manual $savedAptMark >/dev/null; 	apt-get purge -y --auto-remove -o APT::AutoRemove::RecommendsImportant=false; 	chmod +x /usr/local/bin/gosu; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV LANG=C.UTF-8
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/library/ubuntu:focal org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=10.6.19 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_MAJOR=10.6
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_MAJOR=10.6
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_VERSION=1:10.6.19+maria~ubu2004
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_VERSION=1:10.6.19+maria~ubu2004
# Tue, 03 Sep 2024 02:17:54 GMT
ARG REPOSITORY=http://archive.mariadb.org/mariadb-10.6.19/repo/ubuntu/ focal main main/debug
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_MAJOR=10.6 MARIADB_VERSION=1:10.6.19+maria~ubu2004 REPOSITORY=http://archive.mariadb.org/mariadb-10.6.19/repo/ubuntu/ focal main main/debug
RUN set -e;	echo "deb ${REPOSITORY}" > /etc/apt/sources.list.d/mariadb.list; 	{ 		echo 'Package: *'; 		echo 'Pin: release o=MariaDB'; 		echo 'Pin-Priority: 999'; 	} > /etc/apt/preferences.d/mariadb # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_MAJOR=10.6 MARIADB_VERSION=1:10.6.19+maria~ubu2004 REPOSITORY=http://archive.mariadb.org/mariadb-10.6.19/repo/ubuntu/ focal main main/debug
RUN set -ex; 	{ 		echo "mariadb-server-$MARIADB_MAJOR" mysql-server/root_password password 'unused'; 		echo "mariadb-server-$MARIADB_MAJOR" mysql-server/root_password_again password 'unused'; 	} | debconf-set-selections; 	apt-get update; 	mkdir -p /var/lib/mysql/mysql ; touch /var/lib/mysql/mysql/user.frm ; 	apt-get install -y --no-install-recommends mariadb-server="$MARIADB_VERSION" mariadb-backup socat 	; 	rm -rf /var/lib/apt/lists/*; 	rm -rf /var/lib/mysql /etc/mysql/mariadb.conf.d/50-mysqld_safe.cnf; 	mkdir -p /var/lib/mysql /run/mysqld; 	chown -R mysql:mysql /var/lib/mysql /run/mysqld; 	chmod 1777 /run/mysqld; 	find /etc/mysql/ -name '*.cnf' -print0 		| xargs -0 grep -lZE '^(bind-address|log|user\s)' 		| xargs -rt -0 sed -Ei 's/^(bind-address|log|user\s)/#&/'; 	printf "[mariadb]\nhost-cache-size=0\nskip-name-resolve\n" > /etc/mysql/mariadb.conf.d/05-skipcache.cnf; 	if [ -L /etc/mysql/my.cnf ]; then 		sed -i -e '/includedir/ {N;s/\(.*\)\n\(.*\)/\n\2\n\1/}' /etc/mysql/mariadb.cnf; 	fi # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:17:54 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:17:54 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["mariadbd"]
```

-	Layers:
	-	`sha256:cd720328ce8da41e08a7dd5922261b0c1980c2565df21b810488c55260400f68`  
		Last Modified: Fri, 11 Oct 2024 04:41:42 GMT  
		Size: 32.1 MB (32076506 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:5916ab1c58127c6915e3d4cc5d6c7b45c5a4b7c5c83773aaff9c7af303ec5456`  
		Last Modified: Wed, 16 Oct 2024 02:15:49 GMT  
		Size: 1.7 KB (1723 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:cf77fdc98d512939f668b56546e1611ee1c03f5ee8cc1031f23b9d52d6075b96`  
		Last Modified: Wed, 16 Oct 2024 02:15:50 GMT  
		Size: 7.9 MB (7920500 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:34bcf28b8d6a32d95bd48c35ca95c061dfac0791ac6ae9b90b18cb1655e68995`  
		Last Modified: Wed, 16 Oct 2024 02:15:49 GMT  
		Size: 116.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:0389d6b3ffdcc08d2906d86eb9c499ca3af4a041b6a6f5f7747f65176bd34d59`  
		Last Modified: Wed, 16 Oct 2024 02:15:50 GMT  
		Size: 334.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:0ecf8141a8a3e5da669bd341b38f50da0057a7c28bfa8f8166ddecc1cdbb098b`  
		Last Modified: Wed, 16 Oct 2024 02:15:54 GMT  
		Size: 90.7 MB (90741303 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:80edc71548414218ae729b95567b0660f90d6abd03d2489c13716e45951d9c4d`  
		Last Modified: Wed, 16 Oct 2024 02:15:51 GMT  
		Size: 4.0 KB (3956 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:023ba2115fcd0bec708992efedaaa7b69acd07e0c43bd2df18a6443f15ce6a6f`  
		Last Modified: Wed, 16 Oct 2024 02:15:51 GMT  
		Size: 8.3 KB (8254 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:10.6` - unknown; unknown

```console
$ docker pull mariadb@sha256:0740ed34f470b6cd30d8de2b8085663ddff0e0a33e9b7984de7054a606c98342
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.5 MB (4493982 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:735e79ec6b810a6ef84608086d0d76ad5ccd02e225ba11bc67b52fd716700f06`

```dockerfile
```

-	Layers:
	-	`sha256:a4072f6c89c607922c3a01fdc958eb874a6e916f2366311b55812de232090f3f`  
		Last Modified: Wed, 16 Oct 2024 02:15:50 GMT  
		Size: 4.5 MB (4463890 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:ef4f01e5fa9db39a1b13143d59904d1899955804e0c32c1bae2fb4455b16b380`  
		Last Modified: Wed, 16 Oct 2024 02:15:49 GMT  
		Size: 30.1 KB (30092 bytes)  
		MIME: application/vnd.in-toto+json

### `mariadb:10.6` - linux; s390x

```console
$ docker pull mariadb@sha256:4317ea721224d9dfa7f6d019f0e0b6ea3090298a30fa26e5e0c3b1f45e8bed0d
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **119.4 MB (119384937 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:e6d052da3cd36b8c9a36dee12e965758b079f0782189e8cea74242baac5e4f2f`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mariadbd"]`

```dockerfile
# Tue, 03 Sep 2024 02:17:54 GMT
ARG RELEASE
# Tue, 03 Sep 2024 02:17:54 GMT
ARG LAUNCHPAD_BUILD_ARCH
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.ref.name=ubuntu
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.version=20.04
# Tue, 03 Sep 2024 02:17:54 GMT
ADD file:e3e9bad1c3576edf8ddea2dd7af2ed8ecac1ad0b15d714dd9c51f679d44d13b6 in / 
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:17:54 GMT
RUN groupadd -r mysql && useradd -r -g mysql mysql --home-dir /var/lib/mysql # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:17:54 GMT
ARG GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN set -eux; 	apt-get update; 	DEBIAN_FRONTEND=noninteractive apt-get install -y --no-install-recommends 		ca-certificates 		gpg 		gpgv 		libjemalloc2 		pwgen 		tzdata 		xz-utils 		zstd ; 	savedAptMark="$(apt-mark showmanual)"; 	apt-get install -y --no-install-recommends 		dirmngr 		gpg-agent 		wget; 	rm -rf /var/lib/apt/lists/*; 	dpkgArch="$(dpkg --print-architecture | awk -F- '{ print $NF }')"; 	wget -q -O /usr/local/bin/gosu "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch"; 	wget -q -O /usr/local/bin/gosu.asc "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch.asc"; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	for key in $GPG_KEYS; do 		gpg --batch --keyserver keyserver.ubuntu.com --recv-keys "$key"; 	done; 	gpg --batch --export "$GPG_KEYS" > /etc/apt/trusted.gpg.d/mariadb.gpg; 	if command -v gpgconf >/dev/null; then 		gpgconf --kill all; 	fi; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	apt-mark auto '.*' > /dev/null; 	[ -z "$savedAptMark" ] ||	apt-mark manual $savedAptMark >/dev/null; 	apt-get purge -y --auto-remove -o APT::AutoRemove::RecommendsImportant=false; 	chmod +x /usr/local/bin/gosu; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV LANG=C.UTF-8
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/library/ubuntu:focal org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=10.6.19 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_MAJOR=10.6
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_MAJOR=10.6
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_VERSION=1:10.6.19+maria~ubu2004
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_VERSION=1:10.6.19+maria~ubu2004
# Tue, 03 Sep 2024 02:17:54 GMT
ARG REPOSITORY=http://archive.mariadb.org/mariadb-10.6.19/repo/ubuntu/ focal main main/debug
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_MAJOR=10.6 MARIADB_VERSION=1:10.6.19+maria~ubu2004 REPOSITORY=http://archive.mariadb.org/mariadb-10.6.19/repo/ubuntu/ focal main main/debug
RUN set -e;	echo "deb ${REPOSITORY}" > /etc/apt/sources.list.d/mariadb.list; 	{ 		echo 'Package: *'; 		echo 'Pin: release o=MariaDB'; 		echo 'Pin-Priority: 999'; 	} > /etc/apt/preferences.d/mariadb # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_MAJOR=10.6 MARIADB_VERSION=1:10.6.19+maria~ubu2004 REPOSITORY=http://archive.mariadb.org/mariadb-10.6.19/repo/ubuntu/ focal main main/debug
RUN set -ex; 	{ 		echo "mariadb-server-$MARIADB_MAJOR" mysql-server/root_password password 'unused'; 		echo "mariadb-server-$MARIADB_MAJOR" mysql-server/root_password_again password 'unused'; 	} | debconf-set-selections; 	apt-get update; 	mkdir -p /var/lib/mysql/mysql ; touch /var/lib/mysql/mysql/user.frm ; 	apt-get install -y --no-install-recommends mariadb-server="$MARIADB_VERSION" mariadb-backup socat 	; 	rm -rf /var/lib/apt/lists/*; 	rm -rf /var/lib/mysql /etc/mysql/mariadb.conf.d/50-mysqld_safe.cnf; 	mkdir -p /var/lib/mysql /run/mysqld; 	chown -R mysql:mysql /var/lib/mysql /run/mysqld; 	chmod 1777 /run/mysqld; 	find /etc/mysql/ -name '*.cnf' -print0 		| xargs -0 grep -lZE '^(bind-address|log|user\s)' 		| xargs -rt -0 sed -Ei 's/^(bind-address|log|user\s)/#&/'; 	printf "[mariadb]\nhost-cache-size=0\nskip-name-resolve\n" > /etc/mysql/mariadb.conf.d/05-skipcache.cnf; 	if [ -L /etc/mysql/my.cnf ]; then 		sed -i -e '/includedir/ {N;s/\(.*\)\n\(.*\)/\n\2\n\1/}' /etc/mysql/mariadb.cnf; 	fi # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:17:54 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:17:54 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["mariadbd"]
```

-	Layers:
	-	`sha256:f6b14778eb4fed5cbb0bd80eea19d48526571f3b2dfa0196faf63f42fdb8c6c2`  
		Last Modified: Fri, 11 Oct 2024 04:41:53 GMT  
		Size: 26.4 MB (26365979 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:1acb90d0f7d096bf2b19e582632496506e7ada4d980a0f1675753105a87c7cb7`  
		Last Modified: Wed, 16 Oct 2024 02:11:41 GMT  
		Size: 1.7 KB (1724 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:385ab910932e2e79799abb20cdeeeced64c278ae6f85266bdb2b79be09eeb72d`  
		Last Modified: Wed, 16 Oct 2024 02:11:41 GMT  
		Size: 6.7 MB (6741231 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:0055c643a81688cc156d19b26ebca060689a6b67d5534ae7e53c8dbdbcfa71a5`  
		Last Modified: Wed, 16 Oct 2024 02:11:41 GMT  
		Size: 116.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:32829e2b44978d1dd0b82205514eadc9d7621799977dc37896744fbf9c0719e1`  
		Last Modified: Wed, 16 Oct 2024 02:11:41 GMT  
		Size: 333.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:24db630b3127b971bf84618c3b20a4a76341350593d10c1cd9d6c6f2eaff849d`  
		Last Modified: Wed, 16 Oct 2024 02:11:43 GMT  
		Size: 86.3 MB (86263346 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:d7123968205e0982cffe6d4eeafac1fb862759ff8d0c4d0d8151fd8518054883`  
		Last Modified: Wed, 16 Oct 2024 02:11:42 GMT  
		Size: 4.0 KB (3956 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:be78bfd3b2acb086b6e90290b5048ff1185a86d4bc99669aa2f80790e97cb3cc`  
		Last Modified: Wed, 16 Oct 2024 02:11:42 GMT  
		Size: 8.3 KB (8252 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:10.6` - unknown; unknown

```console
$ docker pull mariadb@sha256:902dd03ecb78956a6437802ff2f7b33a8c71b8dad63a6869afccd915a574ed8c
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.5 MB (4486085 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:1e2b5e62b6c8d0cfa9cacc16bf9022337ec07bfae0670d6a2d4380e3c74ee032`

```dockerfile
```

-	Layers:
	-	`sha256:b42bcb0a6ecf75604dfb0446dab82a958a3b75c96b0a17a42c2b8f7cb8383b10`  
		Last Modified: Wed, 16 Oct 2024 02:11:41 GMT  
		Size: 4.5 MB (4456039 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:1c7b6c617e0e7e801b37b64d3b2b2154f666679db3e8cd74e16871375ca0f15e`  
		Last Modified: Wed, 16 Oct 2024 02:11:41 GMT  
		Size: 30.0 KB (30046 bytes)  
		MIME: application/vnd.in-toto+json
