## `mariadb:10.5`

```console
$ docker pull mariadb@sha256:575327d46f436430330e363aa151d34e730fa5e94d85e5effa87cc960714d1b7
```

-	Manifest MIME: `application/vnd.oci.image.index.v1+json`
-	Platforms: 8
	-	linux; amd64
	-	unknown; unknown
	-	linux; arm64 variant v8
	-	unknown; unknown
	-	linux; ppc64le
	-	unknown; unknown
	-	linux; s390x
	-	unknown; unknown

### `mariadb:10.5` - linux; amd64

```console
$ docker pull mariadb@sha256:c72da40f740b32465f2833f03ad52312299b4348230463d716a8267425fc90f8
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **120.9 MB (120906735 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:a95afe2b930cfcc0336454f66e7d82366c03931ad0906f0de70736eaa57a1a5e`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mysqld"]`

```dockerfile
# Tue, 03 Sep 2024 02:17:54 GMT
ARG RELEASE
# Tue, 03 Sep 2024 02:17:54 GMT
ARG LAUNCHPAD_BUILD_ARCH
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.ref.name=ubuntu
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.version=20.04
# Tue, 03 Sep 2024 02:17:54 GMT
ADD file:7486147a645d8835a5181c79f00a3606c6b714c83bcbfcd8862221eb14690f9e in / 
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:17:54 GMT
RUN groupadd -r mysql && useradd -r -g mysql mysql --home-dir /var/lib/mysql # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:17:54 GMT
ARG GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN set -eux; 	apt-get update; 	DEBIAN_FRONTEND=noninteractive apt-get install -y --no-install-recommends 		ca-certificates 		gpg 		gpgv 		libjemalloc2 		pwgen 		tzdata 		xz-utils 		zstd ; 	savedAptMark="$(apt-mark showmanual)"; 	apt-get install -y --no-install-recommends 		dirmngr 		gpg-agent 		wget; 	rm -rf /var/lib/apt/lists/*; 	dpkgArch="$(dpkg --print-architecture | awk -F- '{ print $NF }')"; 	wget -q -O /usr/local/bin/gosu "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch"; 	wget -q -O /usr/local/bin/gosu.asc "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch.asc"; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	for key in $GPG_KEYS; do 		gpg --batch --keyserver keyserver.ubuntu.com --recv-keys "$key"; 	done; 	gpg --batch --export "$GPG_KEYS" > /etc/apt/trusted.gpg.d/mariadb.gpg; 	if command -v gpgconf >/dev/null; then 		gpgconf --kill all; 	fi; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	apt-mark auto '.*' > /dev/null; 	[ -z "$savedAptMark" ] ||	apt-mark manual $savedAptMark >/dev/null; 	apt-get purge -y --auto-remove -o APT::AutoRemove::RecommendsImportant=false; 	chmod +x /usr/local/bin/gosu; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV LANG=C.UTF-8
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/library/ubuntu:focal org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=10.5.26 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_MAJOR=10.5
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_MAJOR=10.5
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_VERSION=1:10.5.26+maria~ubu2004
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_VERSION=1:10.5.26+maria~ubu2004
# Tue, 03 Sep 2024 02:17:54 GMT
ARG REPOSITORY=http://archive.mariadb.org/mariadb-10.5.26/repo/ubuntu/ focal main main/debug
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_MAJOR=10.5 MARIADB_VERSION=1:10.5.26+maria~ubu2004 REPOSITORY=http://archive.mariadb.org/mariadb-10.5.26/repo/ubuntu/ focal main main/debug
RUN set -e;	echo "deb ${REPOSITORY}" > /etc/apt/sources.list.d/mariadb.list; 	{ 		echo 'Package: *'; 		echo 'Pin: release o=MariaDB'; 		echo 'Pin-Priority: 999'; 	} > /etc/apt/preferences.d/mariadb # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_MAJOR=10.5 MARIADB_VERSION=1:10.5.26+maria~ubu2004 REPOSITORY=http://archive.mariadb.org/mariadb-10.5.26/repo/ubuntu/ focal main main/debug
RUN set -ex; 	{ 		echo "mariadb-server-$MARIADB_MAJOR" mysql-server/root_password password 'unused'; 		echo "mariadb-server-$MARIADB_MAJOR" mysql-server/root_password_again password 'unused'; 	} | debconf-set-selections; 	apt-get update; 	mkdir -p /var/lib/mysql/mysql ; touch /var/lib/mysql/mysql/user.frm ; 	apt-get install -y --no-install-recommends mariadb-server="$MARIADB_VERSION" mariadb-backup socat 	; 	rm -rf /var/lib/apt/lists/*; 	rm -rf /var/lib/mysql /etc/mysql/mariadb.conf.d/50-mysqld_safe.cnf; 	mkdir -p /var/lib/mysql /run/mysqld; 	chown -R mysql:mysql /var/lib/mysql /run/mysqld; 	chmod 1777 /run/mysqld; 	find /etc/mysql/ -name '*.cnf' -print0 		| xargs -0 grep -lZE '^(bind-address|log|user\s)' 		| xargs -rt -0 sed -Ei 's/^(bind-address|log|user\s)/#&/'; 	printf "[mariadb]\nhost-cache-size=0\nskip-name-resolve\n" > /etc/mysql/mariadb.conf.d/05-skipcache.cnf; 	if [ -L /etc/mysql/my.cnf ]; then 		sed -i -e '/includedir/ {N;s/\(.*\)\n\(.*\)/\n\2\n\1/}' /etc/mysql/mariadb.cnf; 	fi # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:17:54 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:17:54 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["mysqld"]
```

-	Layers:
	-	`sha256:d9802f032d6798e2086607424bfe88cb8ec1d6f116e11cd99592dcaf261e9cd2`  
		Last Modified: Fri, 11 Oct 2024 04:41:25 GMT  
		Size: 27.5 MB (27511060 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:12ccabe35235884eacea756e89aea62461b6b77784f93d3f6d2e55bf487497a2`  
		Last Modified: Wed, 16 Oct 2024 16:14:08 GMT  
		Size: 1.7 KB (1722 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:2d8fc85713ad013bf80de8ca141ea77189fed74965c9d044938fd6f745c4e965`  
		Last Modified: Wed, 16 Oct 2024 16:14:08 GMT  
		Size: 7.2 MB (7192931 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:6e4600666d3ce5ae1d13fce117bf29af139ea3420a3066b4ce66d87cca3f3f69`  
		Last Modified: Wed, 16 Oct 2024 16:14:08 GMT  
		Size: 116.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:ce68462e86bf84e8325238b43edf7f1cbb5b21eac8bbd83819a6cdb490fc48f3`  
		Last Modified: Wed, 16 Oct 2024 16:14:08 GMT  
		Size: 332.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:759cf935bd942be4d83000a104e5b463d3622cebd6064b020a58fb288d41fb5a`  
		Last Modified: Wed, 16 Oct 2024 16:14:10 GMT  
		Size: 86.2 MB (86188399 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:6b2d6df5b8052e46245a4e5f46963f60c0cfbfb3cecc79f3e097cb65d06094d1`  
		Last Modified: Wed, 16 Oct 2024 16:14:08 GMT  
		Size: 4.0 KB (3960 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:b240fcc9dda971444c6d4485894168eee8d04e2f36215fa1899e17c661f1c05d`  
		Last Modified: Wed, 16 Oct 2024 16:14:09 GMT  
		Size: 8.2 KB (8215 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:10.5` - unknown; unknown

```console
$ docker pull mariadb@sha256:62e5e366ee6fa87d8e528a90f98935de5fd6752fc6a2a08a18fe893ebea063ce
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.5 MB (4482558 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:c1d7ec5a9f9575dfb7255ec696670dc1c0f8c925df6f7ecf15a5d682f521065c`

```dockerfile
```

-	Layers:
	-	`sha256:cd63df7054698d7002e31e26ab2cd6d22e1b265b04a1b6bc240f0864dd5796d8`  
		Last Modified: Wed, 16 Oct 2024 16:14:08 GMT  
		Size: 4.5 MB (4452513 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:513a793d07645032a5141643471d387962a71165be0fd244dff5ebfc21d0c5b2`  
		Last Modified: Wed, 16 Oct 2024 16:14:08 GMT  
		Size: 30.0 KB (30045 bytes)  
		MIME: application/vnd.in-toto+json

### `mariadb:10.5` - linux; arm64 variant v8

```console
$ docker pull mariadb@sha256:343417a357f1a6fa84f012bed009a38ae9394a3f864696cc54e521ee3854106f
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **118.2 MB (118156577 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:374103cac17932f54b1dc1b387b6511879a39433cee982d5d29c4d666b9a86ad`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mysqld"]`

```dockerfile
# Tue, 03 Sep 2024 02:17:54 GMT
ARG RELEASE
# Tue, 03 Sep 2024 02:17:54 GMT
ARG LAUNCHPAD_BUILD_ARCH
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.ref.name=ubuntu
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.version=20.04
# Tue, 03 Sep 2024 02:17:54 GMT
ADD file:8537b4db344382b39d669af27cd94ec0f870ceafe58c67ee54e3f9b38fb8d671 in / 
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:17:54 GMT
RUN groupadd -r mysql && useradd -r -g mysql mysql --home-dir /var/lib/mysql # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:17:54 GMT
ARG GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN set -eux; 	apt-get update; 	DEBIAN_FRONTEND=noninteractive apt-get install -y --no-install-recommends 		ca-certificates 		gpg 		gpgv 		libjemalloc2 		pwgen 		tzdata 		xz-utils 		zstd ; 	savedAptMark="$(apt-mark showmanual)"; 	apt-get install -y --no-install-recommends 		dirmngr 		gpg-agent 		wget; 	rm -rf /var/lib/apt/lists/*; 	dpkgArch="$(dpkg --print-architecture | awk -F- '{ print $NF }')"; 	wget -q -O /usr/local/bin/gosu "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch"; 	wget -q -O /usr/local/bin/gosu.asc "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch.asc"; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	for key in $GPG_KEYS; do 		gpg --batch --keyserver keyserver.ubuntu.com --recv-keys "$key"; 	done; 	gpg --batch --export "$GPG_KEYS" > /etc/apt/trusted.gpg.d/mariadb.gpg; 	if command -v gpgconf >/dev/null; then 		gpgconf --kill all; 	fi; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	apt-mark auto '.*' > /dev/null; 	[ -z "$savedAptMark" ] ||	apt-mark manual $savedAptMark >/dev/null; 	apt-get purge -y --auto-remove -o APT::AutoRemove::RecommendsImportant=false; 	chmod +x /usr/local/bin/gosu; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV LANG=C.UTF-8
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/library/ubuntu:focal org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=10.5.26 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_MAJOR=10.5
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_MAJOR=10.5
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_VERSION=1:10.5.26+maria~ubu2004
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_VERSION=1:10.5.26+maria~ubu2004
# Tue, 03 Sep 2024 02:17:54 GMT
ARG REPOSITORY=http://archive.mariadb.org/mariadb-10.5.26/repo/ubuntu/ focal main main/debug
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_MAJOR=10.5 MARIADB_VERSION=1:10.5.26+maria~ubu2004 REPOSITORY=http://archive.mariadb.org/mariadb-10.5.26/repo/ubuntu/ focal main main/debug
RUN set -e;	echo "deb ${REPOSITORY}" > /etc/apt/sources.list.d/mariadb.list; 	{ 		echo 'Package: *'; 		echo 'Pin: release o=MariaDB'; 		echo 'Pin-Priority: 999'; 	} > /etc/apt/preferences.d/mariadb # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_MAJOR=10.5 MARIADB_VERSION=1:10.5.26+maria~ubu2004 REPOSITORY=http://archive.mariadb.org/mariadb-10.5.26/repo/ubuntu/ focal main main/debug
RUN set -ex; 	{ 		echo "mariadb-server-$MARIADB_MAJOR" mysql-server/root_password password 'unused'; 		echo "mariadb-server-$MARIADB_MAJOR" mysql-server/root_password_again password 'unused'; 	} | debconf-set-selections; 	apt-get update; 	mkdir -p /var/lib/mysql/mysql ; touch /var/lib/mysql/mysql/user.frm ; 	apt-get install -y --no-install-recommends mariadb-server="$MARIADB_VERSION" mariadb-backup socat 	; 	rm -rf /var/lib/apt/lists/*; 	rm -rf /var/lib/mysql /etc/mysql/mariadb.conf.d/50-mysqld_safe.cnf; 	mkdir -p /var/lib/mysql /run/mysqld; 	chown -R mysql:mysql /var/lib/mysql /run/mysqld; 	chmod 1777 /run/mysqld; 	find /etc/mysql/ -name '*.cnf' -print0 		| xargs -0 grep -lZE '^(bind-address|log|user\s)' 		| xargs -rt -0 sed -Ei 's/^(bind-address|log|user\s)/#&/'; 	printf "[mariadb]\nhost-cache-size=0\nskip-name-resolve\n" > /etc/mysql/mariadb.conf.d/05-skipcache.cnf; 	if [ -L /etc/mysql/my.cnf ]; then 		sed -i -e '/includedir/ {N;s/\(.*\)\n\(.*\)/\n\2\n\1/}' /etc/mysql/mariadb.cnf; 	fi # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:17:54 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:17:54 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["mysqld"]
```

-	Layers:
	-	`sha256:1b9f3c55f9d4aa5c52eb67a4cb7d0f4726ab85a413b50e3e3fe788befce3d297`  
		Last Modified: Fri, 11 Oct 2024 04:41:30 GMT  
		Size: 26.0 MB (25973828 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:85e6fc4d1431180a6ac68cb917d07ac474c380d6c6427f2c6876515bdc5fbb0d`  
		Last Modified: Wed, 16 Oct 2024 03:43:00 GMT  
		Size: 1.7 KB (1724 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:222659d6d32721cd1a050cdbba4b3021ae5f4c4d180e4b4be2459cfbf92bde66`  
		Last Modified: Wed, 16 Oct 2024 03:43:00 GMT  
		Size: 6.9 MB (6923179 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:184781552495db7f15e9e552bda8e4581d9f518031fe71ed1a0a8c0b27ec15fa`  
		Last Modified: Wed, 16 Oct 2024 03:43:00 GMT  
		Size: 116.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:013fba0cac65578eb8e1956ca28d4b515f9138c5e77a588714af2cb981e09953`  
		Last Modified: Wed, 16 Oct 2024 03:43:50 GMT  
		Size: 335.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:764fc9b30127bc82b554fde0ddd0f55c7bea74bea42e7ef51714f8822ad4dbb7`  
		Last Modified: Wed, 16 Oct 2024 03:43:53 GMT  
		Size: 85.2 MB (85245220 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:43a26579e54f894add0ca2afbf1543dcf296ba36a984a5ff94c997a0da9d9a69`  
		Last Modified: Wed, 16 Oct 2024 03:43:50 GMT  
		Size: 4.0 KB (3958 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:bdfb7e4373a5dfca6bb3eb2ed92abbb385b0d517ddfba50828e90dff37cbcbeb`  
		Last Modified: Wed, 16 Oct 2024 03:43:51 GMT  
		Size: 8.2 KB (8217 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:10.5` - unknown; unknown

```console
$ docker pull mariadb@sha256:788de84f192d91d8ab40bee084fb042b493998622db929bf2bd552c9a8a7b046
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.5 MB (4489088 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:dffd0ead57b87f5b5bc699a2bd83270666d3d25a2cc33a6e1751fa9be07be841`

```dockerfile
```

-	Layers:
	-	`sha256:f09fd6a6f897238694e1efe5ed01731901b0d52011062c8edcbd82c828de37f1`  
		Last Modified: Wed, 16 Oct 2024 03:43:51 GMT  
		Size: 4.5 MB (4458885 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:8144a6503659feb88ecdb7d666e4e99a0e4b61edfa89f0f0daf281d11acd6a3b`  
		Last Modified: Wed, 16 Oct 2024 03:43:50 GMT  
		Size: 30.2 KB (30203 bytes)  
		MIME: application/vnd.in-toto+json

### `mariadb:10.5` - linux; ppc64le

```console
$ docker pull mariadb@sha256:043190e6a82c4b1f01388cc446584fbd1b258963481a6558cecb8cb492d69aba
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **130.6 MB (130649693 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:8952010d08b55ee5de95dee4e44bb3c4d6c6608491d82dd764cb8472de25007f`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mysqld"]`

```dockerfile
# Tue, 03 Sep 2024 02:17:54 GMT
ARG RELEASE
# Tue, 03 Sep 2024 02:17:54 GMT
ARG LAUNCHPAD_BUILD_ARCH
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.ref.name=ubuntu
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.version=20.04
# Tue, 03 Sep 2024 02:17:54 GMT
ADD file:869a92a1e06a4985a0281417502ee0c0d8ba6cc4e0b72062dd8e4eb87833bae7 in / 
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:17:54 GMT
RUN groupadd -r mysql && useradd -r -g mysql mysql --home-dir /var/lib/mysql # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:17:54 GMT
ARG GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN set -eux; 	apt-get update; 	DEBIAN_FRONTEND=noninteractive apt-get install -y --no-install-recommends 		ca-certificates 		gpg 		gpgv 		libjemalloc2 		pwgen 		tzdata 		xz-utils 		zstd ; 	savedAptMark="$(apt-mark showmanual)"; 	apt-get install -y --no-install-recommends 		dirmngr 		gpg-agent 		wget; 	rm -rf /var/lib/apt/lists/*; 	dpkgArch="$(dpkg --print-architecture | awk -F- '{ print $NF }')"; 	wget -q -O /usr/local/bin/gosu "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch"; 	wget -q -O /usr/local/bin/gosu.asc "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch.asc"; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	for key in $GPG_KEYS; do 		gpg --batch --keyserver keyserver.ubuntu.com --recv-keys "$key"; 	done; 	gpg --batch --export "$GPG_KEYS" > /etc/apt/trusted.gpg.d/mariadb.gpg; 	if command -v gpgconf >/dev/null; then 		gpgconf --kill all; 	fi; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	apt-mark auto '.*' > /dev/null; 	[ -z "$savedAptMark" ] ||	apt-mark manual $savedAptMark >/dev/null; 	apt-get purge -y --auto-remove -o APT::AutoRemove::RecommendsImportant=false; 	chmod +x /usr/local/bin/gosu; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV LANG=C.UTF-8
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/library/ubuntu:focal org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=10.5.26 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_MAJOR=10.5
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_MAJOR=10.5
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_VERSION=1:10.5.26+maria~ubu2004
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_VERSION=1:10.5.26+maria~ubu2004
# Tue, 03 Sep 2024 02:17:54 GMT
ARG REPOSITORY=http://archive.mariadb.org/mariadb-10.5.26/repo/ubuntu/ focal main main/debug
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_MAJOR=10.5 MARIADB_VERSION=1:10.5.26+maria~ubu2004 REPOSITORY=http://archive.mariadb.org/mariadb-10.5.26/repo/ubuntu/ focal main main/debug
RUN set -e;	echo "deb ${REPOSITORY}" > /etc/apt/sources.list.d/mariadb.list; 	{ 		echo 'Package: *'; 		echo 'Pin: release o=MariaDB'; 		echo 'Pin-Priority: 999'; 	} > /etc/apt/preferences.d/mariadb # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_MAJOR=10.5 MARIADB_VERSION=1:10.5.26+maria~ubu2004 REPOSITORY=http://archive.mariadb.org/mariadb-10.5.26/repo/ubuntu/ focal main main/debug
RUN set -ex; 	{ 		echo "mariadb-server-$MARIADB_MAJOR" mysql-server/root_password password 'unused'; 		echo "mariadb-server-$MARIADB_MAJOR" mysql-server/root_password_again password 'unused'; 	} | debconf-set-selections; 	apt-get update; 	mkdir -p /var/lib/mysql/mysql ; touch /var/lib/mysql/mysql/user.frm ; 	apt-get install -y --no-install-recommends mariadb-server="$MARIADB_VERSION" mariadb-backup socat 	; 	rm -rf /var/lib/apt/lists/*; 	rm -rf /var/lib/mysql /etc/mysql/mariadb.conf.d/50-mysqld_safe.cnf; 	mkdir -p /var/lib/mysql /run/mysqld; 	chown -R mysql:mysql /var/lib/mysql /run/mysqld; 	chmod 1777 /run/mysqld; 	find /etc/mysql/ -name '*.cnf' -print0 		| xargs -0 grep -lZE '^(bind-address|log|user\s)' 		| xargs -rt -0 sed -Ei 's/^(bind-address|log|user\s)/#&/'; 	printf "[mariadb]\nhost-cache-size=0\nskip-name-resolve\n" > /etc/mysql/mariadb.conf.d/05-skipcache.cnf; 	if [ -L /etc/mysql/my.cnf ]; then 		sed -i -e '/includedir/ {N;s/\(.*\)\n\(.*\)/\n\2\n\1/}' /etc/mysql/mariadb.cnf; 	fi # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:17:54 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:17:54 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["mysqld"]
```

-	Layers:
	-	`sha256:cd720328ce8da41e08a7dd5922261b0c1980c2565df21b810488c55260400f68`  
		Last Modified: Fri, 11 Oct 2024 04:41:42 GMT  
		Size: 32.1 MB (32076506 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:5916ab1c58127c6915e3d4cc5d6c7b45c5a4b7c5c83773aaff9c7af303ec5456`  
		Last Modified: Wed, 16 Oct 2024 02:15:49 GMT  
		Size: 1.7 KB (1723 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:cf77fdc98d512939f668b56546e1611ee1c03f5ee8cc1031f23b9d52d6075b96`  
		Last Modified: Wed, 16 Oct 2024 02:15:50 GMT  
		Size: 7.9 MB (7920500 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:34bcf28b8d6a32d95bd48c35ca95c061dfac0791ac6ae9b90b18cb1655e68995`  
		Last Modified: Wed, 16 Oct 2024 02:15:49 GMT  
		Size: 116.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:2bd129d57dc48462d97deac44a974e37def7dc4b03b3cc9f0031ec21e646e175`  
		Last Modified: Wed, 16 Oct 2024 02:17:08 GMT  
		Size: 334.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:2fc9072d7590180005a5427f46a3d4caef49a35af0963b19703442f536a13d2c`  
		Last Modified: Wed, 16 Oct 2024 02:17:12 GMT  
		Size: 90.6 MB (90638333 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:0ff297dcfbaf9d366b851cb9b84428261da0ed9394705f2cfc2179f863c6a6a0`  
		Last Modified: Wed, 16 Oct 2024 02:17:08 GMT  
		Size: 4.0 KB (3962 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:4dac9a06058e7ed62b38c5e6fa9b3b11d6f925692845a75c9d9e7f5d3ead6b91`  
		Last Modified: Wed, 16 Oct 2024 02:17:08 GMT  
		Size: 8.2 KB (8219 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:10.5` - unknown; unknown

```console
$ docker pull mariadb@sha256:3e0b9db5e0d425bb87bf0860ff7097e791fef5722767be433051b975a024f7fd
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.5 MB (4490009 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:2065ea6ef020b4b34994fd23c65dd445e2bb4caaf6e629d6e61091b5001dbf58`

```dockerfile
```

-	Layers:
	-	`sha256:513a2bc06532060126e83bfebe8c49ef80656a7c4c8e23fc214f312d37480efa`  
		Last Modified: Wed, 16 Oct 2024 02:17:08 GMT  
		Size: 4.5 MB (4459917 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:552a6d76b4e91dc8819a1d313ce56efd5900d67f3a00f2dfb63aa740ab159b76`  
		Last Modified: Wed, 16 Oct 2024 02:17:08 GMT  
		Size: 30.1 KB (30092 bytes)  
		MIME: application/vnd.in-toto+json

### `mariadb:10.5` - linux; s390x

```console
$ docker pull mariadb@sha256:f054d034f76adfae385b85bc872b14184ba9e781779c9fc181693453468abe68
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **119.2 MB (119245236 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:5a918d645c761485e65b15e8025172ffc1cd0c2cb7bb1137d894b73b76dc6079`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mysqld"]`

```dockerfile
# Tue, 03 Sep 2024 02:17:54 GMT
ARG RELEASE
# Tue, 03 Sep 2024 02:17:54 GMT
ARG LAUNCHPAD_BUILD_ARCH
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.ref.name=ubuntu
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.version=20.04
# Tue, 03 Sep 2024 02:17:54 GMT
ADD file:e3e9bad1c3576edf8ddea2dd7af2ed8ecac1ad0b15d714dd9c51f679d44d13b6 in / 
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:17:54 GMT
RUN groupadd -r mysql && useradd -r -g mysql mysql --home-dir /var/lib/mysql # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:17:54 GMT
ARG GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN set -eux; 	apt-get update; 	DEBIAN_FRONTEND=noninteractive apt-get install -y --no-install-recommends 		ca-certificates 		gpg 		gpgv 		libjemalloc2 		pwgen 		tzdata 		xz-utils 		zstd ; 	savedAptMark="$(apt-mark showmanual)"; 	apt-get install -y --no-install-recommends 		dirmngr 		gpg-agent 		wget; 	rm -rf /var/lib/apt/lists/*; 	dpkgArch="$(dpkg --print-architecture | awk -F- '{ print $NF }')"; 	wget -q -O /usr/local/bin/gosu "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch"; 	wget -q -O /usr/local/bin/gosu.asc "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch.asc"; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	for key in $GPG_KEYS; do 		gpg --batch --keyserver keyserver.ubuntu.com --recv-keys "$key"; 	done; 	gpg --batch --export "$GPG_KEYS" > /etc/apt/trusted.gpg.d/mariadb.gpg; 	if command -v gpgconf >/dev/null; then 		gpgconf --kill all; 	fi; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	apt-mark auto '.*' > /dev/null; 	[ -z "$savedAptMark" ] ||	apt-mark manual $savedAptMark >/dev/null; 	apt-get purge -y --auto-remove -o APT::AutoRemove::RecommendsImportant=false; 	chmod +x /usr/local/bin/gosu; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV LANG=C.UTF-8
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/library/ubuntu:focal org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=10.5.26 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_MAJOR=10.5
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_MAJOR=10.5
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_VERSION=1:10.5.26+maria~ubu2004
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_VERSION=1:10.5.26+maria~ubu2004
# Tue, 03 Sep 2024 02:17:54 GMT
ARG REPOSITORY=http://archive.mariadb.org/mariadb-10.5.26/repo/ubuntu/ focal main main/debug
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_MAJOR=10.5 MARIADB_VERSION=1:10.5.26+maria~ubu2004 REPOSITORY=http://archive.mariadb.org/mariadb-10.5.26/repo/ubuntu/ focal main main/debug
RUN set -e;	echo "deb ${REPOSITORY}" > /etc/apt/sources.list.d/mariadb.list; 	{ 		echo 'Package: *'; 		echo 'Pin: release o=MariaDB'; 		echo 'Pin-Priority: 999'; 	} > /etc/apt/preferences.d/mariadb # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_MAJOR=10.5 MARIADB_VERSION=1:10.5.26+maria~ubu2004 REPOSITORY=http://archive.mariadb.org/mariadb-10.5.26/repo/ubuntu/ focal main main/debug
RUN set -ex; 	{ 		echo "mariadb-server-$MARIADB_MAJOR" mysql-server/root_password password 'unused'; 		echo "mariadb-server-$MARIADB_MAJOR" mysql-server/root_password_again password 'unused'; 	} | debconf-set-selections; 	apt-get update; 	mkdir -p /var/lib/mysql/mysql ; touch /var/lib/mysql/mysql/user.frm ; 	apt-get install -y --no-install-recommends mariadb-server="$MARIADB_VERSION" mariadb-backup socat 	; 	rm -rf /var/lib/apt/lists/*; 	rm -rf /var/lib/mysql /etc/mysql/mariadb.conf.d/50-mysqld_safe.cnf; 	mkdir -p /var/lib/mysql /run/mysqld; 	chown -R mysql:mysql /var/lib/mysql /run/mysqld; 	chmod 1777 /run/mysqld; 	find /etc/mysql/ -name '*.cnf' -print0 		| xargs -0 grep -lZE '^(bind-address|log|user\s)' 		| xargs -rt -0 sed -Ei 's/^(bind-address|log|user\s)/#&/'; 	printf "[mariadb]\nhost-cache-size=0\nskip-name-resolve\n" > /etc/mysql/mariadb.conf.d/05-skipcache.cnf; 	if [ -L /etc/mysql/my.cnf ]; then 		sed -i -e '/includedir/ {N;s/\(.*\)\n\(.*\)/\n\2\n\1/}' /etc/mysql/mariadb.cnf; 	fi # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:17:54 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:17:54 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["mysqld"]
```

-	Layers:
	-	`sha256:f6b14778eb4fed5cbb0bd80eea19d48526571f3b2dfa0196faf63f42fdb8c6c2`  
		Last Modified: Fri, 11 Oct 2024 04:41:53 GMT  
		Size: 26.4 MB (26365979 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:1acb90d0f7d096bf2b19e582632496506e7ada4d980a0f1675753105a87c7cb7`  
		Last Modified: Wed, 16 Oct 2024 02:11:41 GMT  
		Size: 1.7 KB (1724 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:385ab910932e2e79799abb20cdeeeced64c278ae6f85266bdb2b79be09eeb72d`  
		Last Modified: Wed, 16 Oct 2024 02:11:41 GMT  
		Size: 6.7 MB (6741231 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:0055c643a81688cc156d19b26ebca060689a6b67d5534ae7e53c8dbdbcfa71a5`  
		Last Modified: Wed, 16 Oct 2024 02:11:41 GMT  
		Size: 116.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:8fda6e32612f38b58f4a9bd66f0d35f8fb6f0d2ebd01264f6cee77e9175731b0`  
		Last Modified: Wed, 16 Oct 2024 02:12:44 GMT  
		Size: 336.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:2d32fc964f1a3f6f3309b92e9c3d82fc64adc56b0e6fff25d81420cf68798e8e`  
		Last Modified: Wed, 16 Oct 2024 02:12:45 GMT  
		Size: 86.1 MB (86123674 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:590eac6cc2f1205ab09ea03ec8554095a29d6d11e99a859e22f2ec686753e6c4`  
		Last Modified: Wed, 16 Oct 2024 02:12:44 GMT  
		Size: 4.0 KB (3958 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:0daeaf7f9ef58c52197fe80335762e03624ed2ec1a8b20712719be7b257cc0d1`  
		Last Modified: Wed, 16 Oct 2024 02:12:44 GMT  
		Size: 8.2 KB (8218 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:10.5` - unknown; unknown

```console
$ docker pull mariadb@sha256:20127bff50f0c924fcfcfee63c781ab1e148810ba1538ba857bb3f2781e3a21a
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.5 MB (4482112 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:e388667865edd30d783b821fc1d339db41e4049b95e0a063922dd7e5a3ff3596`

```dockerfile
```

-	Layers:
	-	`sha256:efb39769ff5c9f28340f46075ccd88762bc6bd40c7caa5e67696c38e5ceca575`  
		Last Modified: Wed, 16 Oct 2024 02:12:44 GMT  
		Size: 4.5 MB (4452066 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:89a3feae351e8956babbffe279972da569de982a91fc2764b44bf29e9c608f00`  
		Last Modified: Wed, 16 Oct 2024 02:12:43 GMT  
		Size: 30.0 KB (30046 bytes)  
		MIME: application/vnd.in-toto+json
