## `mariadb:10-jammy`

```console
$ docker pull mariadb@sha256:5c2a279eacfa00bd4453b10569e36d8ee24331cdc09273df70c4dbd383c277b4
```

-	Manifest MIME: `application/vnd.oci.image.index.v1+json`
-	Platforms: 8
	-	linux; amd64
	-	unknown; unknown
	-	linux; arm64 variant v8
	-	unknown; unknown
	-	linux; ppc64le
	-	unknown; unknown
	-	linux; s390x
	-	unknown; unknown

### `mariadb:10-jammy` - linux; amd64

```console
$ docker pull mariadb@sha256:100717846f551a000e2b16e592643973e63ccf4dc759ce6416732710e1762364
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **122.7 MB (122673748 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:341c6a0bbc97e5bdeda7638ebfcf7094b62ca12d2e971a9a6f5d66aa0f9cf368`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mariadbd"]`

```dockerfile
# Tue, 03 Sep 2024 02:17:54 GMT
ARG RELEASE
# Tue, 03 Sep 2024 02:17:54 GMT
ARG LAUNCHPAD_BUILD_ARCH
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.ref.name=ubuntu
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.version=22.04
# Tue, 03 Sep 2024 02:17:54 GMT
ADD file:ebe009f86035c175ba244badd298a2582914415cf62783d510eab3a311a5d4e1 in / 
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:17:54 GMT
RUN groupadd -r mysql && useradd -r -g mysql mysql --home-dir /var/lib/mysql # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:17:54 GMT
ARG GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN set -eux; 	apt-get update; 	DEBIAN_FRONTEND=noninteractive apt-get install -y --no-install-recommends 		ca-certificates 		gpg 		gpgv 		libjemalloc2 		pwgen 		tzdata 		xz-utils 		zstd ; 	savedAptMark="$(apt-mark showmanual)"; 	apt-get install -y --no-install-recommends 		dirmngr 		gpg-agent 		wget; 	rm -rf /var/lib/apt/lists/*; 	dpkgArch="$(dpkg --print-architecture | awk -F- '{ print $NF }')"; 	wget -q -O /usr/local/bin/gosu "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch"; 	wget -q -O /usr/local/bin/gosu.asc "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch.asc"; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	for key in $GPG_KEYS; do 		gpg --batch --keyserver keyserver.ubuntu.com --recv-keys "$key"; 	done; 	gpg --batch --export "$GPG_KEYS" > /etc/apt/trusted.gpg.d/mariadb.gpg; 	if command -v gpgconf >/dev/null; then 		gpgconf --kill all; 	fi; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	apt-mark auto '.*' > /dev/null; 	[ -z "$savedAptMark" ] ||	apt-mark manual $savedAptMark >/dev/null; 	apt-get purge -y --auto-remove -o APT::AutoRemove::RecommendsImportant=false; 	chmod +x /usr/local/bin/gosu; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV LANG=C.UTF-8
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/library/ubuntu:jammy org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=10.11.9 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_VERSION=1:10.11.9+maria~ubu2204
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_VERSION=1:10.11.9+maria~ubu2204
# Tue, 03 Sep 2024 02:17:54 GMT
ARG REPOSITORY=http://archive.mariadb.org/mariadb-10.11.9/repo/ubuntu/ jammy main main/debug
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:10.11.9+maria~ubu2204 REPOSITORY=http://archive.mariadb.org/mariadb-10.11.9/repo/ubuntu/ jammy main main/debug
RUN set -e;	echo "deb ${REPOSITORY}" > /etc/apt/sources.list.d/mariadb.list; 	{ 		echo 'Package: *'; 		echo 'Pin: release o=MariaDB'; 		echo 'Pin-Priority: 999'; 	} > /etc/apt/preferences.d/mariadb # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:10.11.9+maria~ubu2204 REPOSITORY=http://archive.mariadb.org/mariadb-10.11.9/repo/ubuntu/ jammy main main/debug
RUN set -ex; 	{ 		echo "mariadb-server" mysql-server/root_password password 'unused'; 		echo "mariadb-server" mysql-server/root_password_again password 'unused'; 	} | debconf-set-selections; 	apt-get update; 	mkdir -p /var/lib/mysql/mysql ; touch /var/lib/mysql/mysql/user.frm ; 	apt-get install -y --no-install-recommends mariadb-server="$MARIADB_VERSION" mariadb-backup socat 	; 	rm -rf /var/lib/apt/lists/*; 	rm -rf /var/lib/mysql /etc/mysql/mariadb.conf.d/50-mysqld_safe.cnf; 	mkdir -p /var/lib/mysql /run/mysqld; 	chown -R mysql:mysql /var/lib/mysql /run/mysqld; 	chmod 1777 /run/mysqld; 	find /etc/mysql/ -name '*.cnf' -print0 		| xargs -0 grep -lZE '^(bind-address|log|user\s)' 		| xargs -rt -0 sed -Ei 's/^(bind-address|log|user\s)/#&/'; 	printf "[mariadb]\nhost-cache-size=0\nskip-name-resolve\n" > /etc/mysql/mariadb.conf.d/05-skipcache.cnf; 	if [ -L /etc/mysql/my.cnf ]; then 		sed -i -e '/includedir/ {N;s/\(.*\)\n\(.*\)/\n\2\n\1/}' /etc/mysql/mariadb.cnf; 	fi # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:17:54 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:17:54 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["mariadbd"]
```

-	Layers:
	-	`sha256:6414378b647780fee8fd903ddb9541d134a1947ce092d08bdeb23a54cb3684ac`  
		Last Modified: Wed, 11 Sep 2024 17:24:41 GMT  
		Size: 29.5 MB (29535688 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:30351e0212f7e50e72cf98b4716f254fe4c2d0d5fada6b6012fe87effae29fc9`  
		Last Modified: Tue, 17 Sep 2024 00:59:32 GMT  
		Size: 1.7 KB (1723 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:699d06734e15843e535a62bd765c37bf1042789ada0fab3dd849af938f946ebf`  
		Last Modified: Tue, 17 Sep 2024 00:59:33 GMT  
		Size: 5.6 MB (5648018 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:143f7abbed034a22f96430a89445275ffa5fbce34e4f794b4c360d908e6d40bb`  
		Last Modified: Tue, 17 Sep 2024 00:59:32 GMT  
		Size: 116.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:ec2a3d1eab0e12e460a5172b63850ae594c2966e839fbac7eb2f4a48ceb54b3e`  
		Last Modified: Tue, 17 Sep 2024 00:59:33 GMT  
		Size: 335.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:d5ad4eb74c2b07370f91e6d8fca40a445e3ced3627f418b383f9b06d919e2ff3`  
		Last Modified: Tue, 17 Sep 2024 00:59:36 GMT  
		Size: 87.5 MB (87475524 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:127c25a3c098b7bc2187bf00e73f5213876eee84730a83829eafcbbe41484cbd`  
		Last Modified: Tue, 17 Sep 2024 00:59:34 GMT  
		Size: 4.0 KB (3957 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:372201a210813477ad8a5b1587fa398a1c8c0d70e4656a0f77bc0084ffe17e3b`  
		Last Modified: Tue, 17 Sep 2024 00:59:34 GMT  
		Size: 8.4 KB (8387 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:10-jammy` - unknown; unknown

```console
$ docker pull mariadb@sha256:784996a6cc6df3607f634094ca9f3918f3d690e83cb0e39811ec670f3b754410
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.6 MB (4619378 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:8c65ca92f340b30b594495925f6d760e8c72e203b3ec936124e0375b9b81c251`

```dockerfile
```

-	Layers:
	-	`sha256:72a79dead60df21999a8b0bab657bccaa8de50aa2d2c298ef3b303c55b1daa54`  
		Last Modified: Tue, 17 Sep 2024 00:59:33 GMT  
		Size: 4.6 MB (4588951 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:421167cd973e2deec551449071993f96fa9735c72c35607f74a4e6c78786783c`  
		Last Modified: Tue, 17 Sep 2024 00:59:33 GMT  
		Size: 30.4 KB (30427 bytes)  
		MIME: application/vnd.in-toto+json

### `mariadb:10-jammy` - linux; arm64 variant v8

```console
$ docker pull mariadb@sha256:b720833d4c6eb8e6ee58724cf07e14f070ab479d80bfdaab0ccb6925112e4b32
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **117.1 MB (117088250 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:bb0be4d6ff239ee53bffa993e2b0f7063d717b07ea3718653293595a423450de`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mariadbd"]`

```dockerfile
# Tue, 03 Sep 2024 02:17:54 GMT
ARG RELEASE
# Tue, 03 Sep 2024 02:17:54 GMT
ARG LAUNCHPAD_BUILD_ARCH
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.ref.name=ubuntu
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.version=22.04
# Tue, 03 Sep 2024 02:17:54 GMT
ADD file:53ce73ebbd6d87a234a33414686f12909aaaf28b7238593f746a327c7d004ce7 in / 
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:17:54 GMT
RUN groupadd -r mysql && useradd -r -g mysql mysql --home-dir /var/lib/mysql # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:17:54 GMT
ARG GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN set -eux; 	apt-get update; 	DEBIAN_FRONTEND=noninteractive apt-get install -y --no-install-recommends 		ca-certificates 		gpg 		gpgv 		libjemalloc2 		pwgen 		tzdata 		xz-utils 		zstd ; 	savedAptMark="$(apt-mark showmanual)"; 	apt-get install -y --no-install-recommends 		dirmngr 		gpg-agent 		wget; 	rm -rf /var/lib/apt/lists/*; 	dpkgArch="$(dpkg --print-architecture | awk -F- '{ print $NF }')"; 	wget -q -O /usr/local/bin/gosu "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch"; 	wget -q -O /usr/local/bin/gosu.asc "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch.asc"; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	for key in $GPG_KEYS; do 		gpg --batch --keyserver keyserver.ubuntu.com --recv-keys "$key"; 	done; 	gpg --batch --export "$GPG_KEYS" > /etc/apt/trusted.gpg.d/mariadb.gpg; 	if command -v gpgconf >/dev/null; then 		gpgconf --kill all; 	fi; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	apt-mark auto '.*' > /dev/null; 	[ -z "$savedAptMark" ] ||	apt-mark manual $savedAptMark >/dev/null; 	apt-get purge -y --auto-remove -o APT::AutoRemove::RecommendsImportant=false; 	chmod +x /usr/local/bin/gosu; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV LANG=C.UTF-8
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/library/ubuntu:jammy org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=10.11.9 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_VERSION=1:10.11.9+maria~ubu2204
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_VERSION=1:10.11.9+maria~ubu2204
# Tue, 03 Sep 2024 02:17:54 GMT
ARG REPOSITORY=http://archive.mariadb.org/mariadb-10.11.9/repo/ubuntu/ jammy main main/debug
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:10.11.9+maria~ubu2204 REPOSITORY=http://archive.mariadb.org/mariadb-10.11.9/repo/ubuntu/ jammy main main/debug
RUN set -e;	echo "deb ${REPOSITORY}" > /etc/apt/sources.list.d/mariadb.list; 	{ 		echo 'Package: *'; 		echo 'Pin: release o=MariaDB'; 		echo 'Pin-Priority: 999'; 	} > /etc/apt/preferences.d/mariadb # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:10.11.9+maria~ubu2204 REPOSITORY=http://archive.mariadb.org/mariadb-10.11.9/repo/ubuntu/ jammy main main/debug
RUN set -ex; 	{ 		echo "mariadb-server" mysql-server/root_password password 'unused'; 		echo "mariadb-server" mysql-server/root_password_again password 'unused'; 	} | debconf-set-selections; 	apt-get update; 	mkdir -p /var/lib/mysql/mysql ; touch /var/lib/mysql/mysql/user.frm ; 	apt-get install -y --no-install-recommends mariadb-server="$MARIADB_VERSION" mariadb-backup socat 	; 	rm -rf /var/lib/apt/lists/*; 	rm -rf /var/lib/mysql /etc/mysql/mariadb.conf.d/50-mysqld_safe.cnf; 	mkdir -p /var/lib/mysql /run/mysqld; 	chown -R mysql:mysql /var/lib/mysql /run/mysqld; 	chmod 1777 /run/mysqld; 	find /etc/mysql/ -name '*.cnf' -print0 		| xargs -0 grep -lZE '^(bind-address|log|user\s)' 		| xargs -rt -0 sed -Ei 's/^(bind-address|log|user\s)/#&/'; 	printf "[mariadb]\nhost-cache-size=0\nskip-name-resolve\n" > /etc/mysql/mariadb.conf.d/05-skipcache.cnf; 	if [ -L /etc/mysql/my.cnf ]; then 		sed -i -e '/includedir/ {N;s/\(.*\)\n\(.*\)/\n\2\n\1/}' /etc/mysql/mariadb.cnf; 	fi # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:17:54 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:17:54 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["mariadbd"]
```

-	Layers:
	-	`sha256:a186900671ab62e1dea364788f4e84c156e1825939914cfb5a6770be2b58b4da`  
		Last Modified: Wed, 11 Sep 2024 17:24:47 GMT  
		Size: 27.4 MB (27358329 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:6b63ab2d2913a834901115a7d4dc7355de38dab1cebee6e614ad27522940b940`  
		Last Modified: Tue, 17 Sep 2024 02:27:53 GMT  
		Size: 1.7 KB (1723 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:64d62bd3ce499228055c47cdf0a95ed8952ddfe20f7dd66733a05400a0956c19`  
		Last Modified: Tue, 17 Sep 2024 02:27:53 GMT  
		Size: 5.5 MB (5461422 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:92ac870fb59b14b3d42dd38f32edb264836fe9d7cd473d8e63e2dd921da2de90`  
		Last Modified: Tue, 17 Sep 2024 02:27:53 GMT  
		Size: 114.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:1cdf1dbac30e4e755fc8941fda1a94a521dfedf1433f015d869e054f3c6881f5`  
		Last Modified: Tue, 17 Sep 2024 02:29:49 GMT  
		Size: 335.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:917ed003eab929560cc244c6027d846d2ca3cad027988fa447728d47b8900503`  
		Last Modified: Tue, 17 Sep 2024 02:29:52 GMT  
		Size: 84.3 MB (84253982 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:fc7383346da03327d909ffe50f9d6c99a2e8a5cb0558c669309dbf6212fd2361`  
		Last Modified: Tue, 17 Sep 2024 02:29:49 GMT  
		Size: 4.0 KB (3956 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:ba200ef8b47267f69656a8e2ed14f5eba74e7e279c3911293c7ee9efb2567c2f`  
		Last Modified: Tue, 17 Sep 2024 02:29:49 GMT  
		Size: 8.4 KB (8389 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:10-jammy` - unknown; unknown

```console
$ docker pull mariadb@sha256:176cda18cc2f5b46c5a05f2d83164599514e7eb3573908a8bbc95aa2740dffa0
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.6 MB (4626144 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:43da87342a1ef50e972d36f7c853f0cb3fac5f674dc0eefe7935359e4f8d588d`

```dockerfile
```

-	Layers:
	-	`sha256:0f7199fdd0cf720997b83dc7ea73b215392ad449fa493af032bafa0581293b7e`  
		Last Modified: Tue, 17 Sep 2024 02:29:49 GMT  
		Size: 4.6 MB (4595392 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:379eedf222ee9e43719c8f8359df2e2e38808eef659172becaf6261b70427b0a`  
		Last Modified: Tue, 17 Sep 2024 02:29:49 GMT  
		Size: 30.8 KB (30752 bytes)  
		MIME: application/vnd.in-toto+json

### `mariadb:10-jammy` - linux; ppc64le

```console
$ docker pull mariadb@sha256:8913fdf6908555dafc77b9517905eb53c62665cabfbdda7f5d6626d1cdc70904
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **130.7 MB (130727569 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:caec0bd6b7ca4a90e09525ee1cc035bc6ccf17bffc5f74897326b80d3ba68bd6`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mariadbd"]`

```dockerfile
# Tue, 03 Sep 2024 02:17:54 GMT
ARG RELEASE
# Tue, 03 Sep 2024 02:17:54 GMT
ARG LAUNCHPAD_BUILD_ARCH
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.ref.name=ubuntu
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.version=22.04
# Tue, 03 Sep 2024 02:17:54 GMT
ADD file:8b71bf5e48ac3a761ff94511892207fd277c013e3c67b735b87f7338e62bb1f3 in / 
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:17:54 GMT
RUN groupadd -r mysql && useradd -r -g mysql mysql --home-dir /var/lib/mysql # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:17:54 GMT
ARG GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN set -eux; 	apt-get update; 	DEBIAN_FRONTEND=noninteractive apt-get install -y --no-install-recommends 		ca-certificates 		gpg 		gpgv 		libjemalloc2 		pwgen 		tzdata 		xz-utils 		zstd ; 	savedAptMark="$(apt-mark showmanual)"; 	apt-get install -y --no-install-recommends 		dirmngr 		gpg-agent 		wget; 	rm -rf /var/lib/apt/lists/*; 	dpkgArch="$(dpkg --print-architecture | awk -F- '{ print $NF }')"; 	wget -q -O /usr/local/bin/gosu "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch"; 	wget -q -O /usr/local/bin/gosu.asc "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch.asc"; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	for key in $GPG_KEYS; do 		gpg --batch --keyserver keyserver.ubuntu.com --recv-keys "$key"; 	done; 	gpg --batch --export "$GPG_KEYS" > /etc/apt/trusted.gpg.d/mariadb.gpg; 	if command -v gpgconf >/dev/null; then 		gpgconf --kill all; 	fi; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	apt-mark auto '.*' > /dev/null; 	[ -z "$savedAptMark" ] ||	apt-mark manual $savedAptMark >/dev/null; 	apt-get purge -y --auto-remove -o APT::AutoRemove::RecommendsImportant=false; 	chmod +x /usr/local/bin/gosu; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV LANG=C.UTF-8
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/library/ubuntu:jammy org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=10.11.9 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_VERSION=1:10.11.9+maria~ubu2204
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_VERSION=1:10.11.9+maria~ubu2204
# Tue, 03 Sep 2024 02:17:54 GMT
ARG REPOSITORY=http://archive.mariadb.org/mariadb-10.11.9/repo/ubuntu/ jammy main main/debug
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:10.11.9+maria~ubu2204 REPOSITORY=http://archive.mariadb.org/mariadb-10.11.9/repo/ubuntu/ jammy main main/debug
RUN set -e;	echo "deb ${REPOSITORY}" > /etc/apt/sources.list.d/mariadb.list; 	{ 		echo 'Package: *'; 		echo 'Pin: release o=MariaDB'; 		echo 'Pin-Priority: 999'; 	} > /etc/apt/preferences.d/mariadb # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:10.11.9+maria~ubu2204 REPOSITORY=http://archive.mariadb.org/mariadb-10.11.9/repo/ubuntu/ jammy main main/debug
RUN set -ex; 	{ 		echo "mariadb-server" mysql-server/root_password password 'unused'; 		echo "mariadb-server" mysql-server/root_password_again password 'unused'; 	} | debconf-set-selections; 	apt-get update; 	mkdir -p /var/lib/mysql/mysql ; touch /var/lib/mysql/mysql/user.frm ; 	apt-get install -y --no-install-recommends mariadb-server="$MARIADB_VERSION" mariadb-backup socat 	; 	rm -rf /var/lib/apt/lists/*; 	rm -rf /var/lib/mysql /etc/mysql/mariadb.conf.d/50-mysqld_safe.cnf; 	mkdir -p /var/lib/mysql /run/mysqld; 	chown -R mysql:mysql /var/lib/mysql /run/mysqld; 	chmod 1777 /run/mysqld; 	find /etc/mysql/ -name '*.cnf' -print0 		| xargs -0 grep -lZE '^(bind-address|log|user\s)' 		| xargs -rt -0 sed -Ei 's/^(bind-address|log|user\s)/#&/'; 	printf "[mariadb]\nhost-cache-size=0\nskip-name-resolve\n" > /etc/mysql/mariadb.conf.d/05-skipcache.cnf; 	if [ -L /etc/mysql/my.cnf ]; then 		sed -i -e '/includedir/ {N;s/\(.*\)\n\(.*\)/\n\2\n\1/}' /etc/mysql/mariadb.cnf; 	fi # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:17:54 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:17:54 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["mariadbd"]
```

-	Layers:
	-	`sha256:bd389594e541fc722f244791a495e1a62a526cb95daeea3d2304d9be4e2f0e2a`  
		Last Modified: Wed, 11 Sep 2024 17:24:59 GMT  
		Size: 34.4 MB (34448242 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:07b436ad9804874480e1457c00e1f5a9c03eeb1cb532a6bf32241f09232c82aa`  
		Last Modified: Tue, 17 Sep 2024 01:41:52 GMT  
		Size: 1.7 KB (1721 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:41db9dcfe75d89b266330aada2a2861129a772102cd399f984a8c478b19ac1d1`  
		Last Modified: Tue, 17 Sep 2024 01:41:53 GMT  
		Size: 6.1 MB (6079737 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:83f7f271dc28602e7ca510684b95ba879f55e65ec4e9f126edf76a5cd08307e4`  
		Last Modified: Tue, 17 Sep 2024 01:41:52 GMT  
		Size: 116.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:e6a4edfcb665b0591ec1efcb5cdc2b51cffd21e700f0769885b86d0bded0a49d`  
		Last Modified: Tue, 17 Sep 2024 01:44:44 GMT  
		Size: 335.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:f06714923a1772ddae97d87e7c4126536a67fc8eb2ba617426db6cce1d9a7586`  
		Last Modified: Tue, 17 Sep 2024 01:44:47 GMT  
		Size: 90.2 MB (90185074 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:72b0c4c6c082203ab13ab0f20313553e42a2ff85e3844c6b324ef40d9fe3e8fc`  
		Last Modified: Tue, 17 Sep 2024 01:44:44 GMT  
		Size: 4.0 KB (3953 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:9584bf9ec6417936f0e28d20afa7b6e71ad584a3595a517410e5117bb93857c8`  
		Last Modified: Tue, 17 Sep 2024 01:44:44 GMT  
		Size: 8.4 KB (8391 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:10-jammy` - unknown; unknown

```console
$ docker pull mariadb@sha256:9eed1eead4cd406f46aa68041d3ee3d54b6752ac8057bf1011e16024f2489a0e
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.6 MB (4627067 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:c232e4ac32406761398038375cc138bdd694b617be8ce74602f3556242170b7f`

```dockerfile
```

-	Layers:
	-	`sha256:00322f29b7de160a0496bda7f3da6a47d5b542c6de2c07fe3d26b1cb65af2bd3`  
		Last Modified: Tue, 17 Sep 2024 01:44:44 GMT  
		Size: 4.6 MB (4596582 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:ab22948416c39281665c4f18b01acfd1d690083b5d7fb254ecc3391022cb0f12`  
		Last Modified: Tue, 17 Sep 2024 01:44:44 GMT  
		Size: 30.5 KB (30485 bytes)  
		MIME: application/vnd.in-toto+json

### `mariadb:10-jammy` - linux; s390x

```console
$ docker pull mariadb@sha256:bcde1627d9f49e8b416c14291c975249b88c51634b9dcb4bd43e1566a9fa5575
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **121.6 MB (121619709 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:994d5be684700178b04854021f9ed15e6a4aec7631d70064683996b4cbd86f72`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["mariadbd"]`

```dockerfile
# Tue, 03 Sep 2024 02:17:54 GMT
ARG RELEASE
# Tue, 03 Sep 2024 02:17:54 GMT
ARG LAUNCHPAD_BUILD_ARCH
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.ref.name=ubuntu
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.version=22.04
# Tue, 03 Sep 2024 02:17:54 GMT
ADD file:6dc78f1eec678e679ed1d9f92297dbcf99806da788dde329389d5d786006603f in / 
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["/bin/bash"]
# Tue, 03 Sep 2024 02:17:54 GMT
RUN groupadd -r mysql && useradd -r -g mysql mysql --home-dir /var/lib/mysql # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV GOSU_VERSION=1.17
# Tue, 03 Sep 2024 02:17:54 GMT
ARG GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN set -eux; 	apt-get update; 	DEBIAN_FRONTEND=noninteractive apt-get install -y --no-install-recommends 		ca-certificates 		gpg 		gpgv 		libjemalloc2 		pwgen 		tzdata 		xz-utils 		zstd ; 	savedAptMark="$(apt-mark showmanual)"; 	apt-get install -y --no-install-recommends 		dirmngr 		gpg-agent 		wget; 	rm -rf /var/lib/apt/lists/*; 	dpkgArch="$(dpkg --print-architecture | awk -F- '{ print $NF }')"; 	wget -q -O /usr/local/bin/gosu "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch"; 	wget -q -O /usr/local/bin/gosu.asc "https://github.com/tianon/gosu/releases/download/$GOSU_VERSION/gosu-$dpkgArch.asc"; 	GNUPGHOME="$(mktemp -d)"; 	export GNUPGHOME; 	gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys B42F6819007F00F88E364FD4036A9C25BF357DD4; 	for key in $GPG_KEYS; do 		gpg --batch --keyserver keyserver.ubuntu.com --recv-keys "$key"; 	done; 	gpg --batch --export "$GPG_KEYS" > /etc/apt/trusted.gpg.d/mariadb.gpg; 	if command -v gpgconf >/dev/null; then 		gpgconf --kill all; 	fi; 	gpg --batch --verify /usr/local/bin/gosu.asc /usr/local/bin/gosu; 	gpgconf --kill all; 	rm -rf "$GNUPGHOME" /usr/local/bin/gosu.asc; 	apt-mark auto '.*' > /dev/null; 	[ -z "$savedAptMark" ] ||	apt-mark manual $savedAptMark >/dev/null; 	apt-get purge -y --auto-remove -o APT::AutoRemove::RecommendsImportant=false; 	chmod +x /usr/local/bin/gosu; 	gosu --version; 	gosu nobody true # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8
RUN mkdir /docker-entrypoint-initdb.d # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENV LANG=C.UTF-8
# Tue, 03 Sep 2024 02:17:54 GMT
LABEL org.opencontainers.image.authors=MariaDB Community org.opencontainers.image.title=MariaDB Database org.opencontainers.image.description=MariaDB Database for relational SQL org.opencontainers.image.documentation=https://hub.docker.com/_/mariadb/ org.opencontainers.image.base.name=docker.io/library/ubuntu:jammy org.opencontainers.image.licenses=GPL-2.0 org.opencontainers.image.source=https://github.com/MariaDB/mariadb-docker org.opencontainers.image.vendor=MariaDB Community org.opencontainers.image.version=10.11.9 org.opencontainers.image.url=https://github.com/MariaDB/mariadb-docker
# Tue, 03 Sep 2024 02:17:54 GMT
ARG MARIADB_VERSION=1:10.11.9+maria~ubu2204
# Tue, 03 Sep 2024 02:17:54 GMT
ENV MARIADB_VERSION=1:10.11.9+maria~ubu2204
# Tue, 03 Sep 2024 02:17:54 GMT
ARG REPOSITORY=http://archive.mariadb.org/mariadb-10.11.9/repo/ubuntu/ jammy main main/debug
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:10.11.9+maria~ubu2204 REPOSITORY=http://archive.mariadb.org/mariadb-10.11.9/repo/ubuntu/ jammy main main/debug
RUN set -e;	echo "deb ${REPOSITORY}" > /etc/apt/sources.list.d/mariadb.list; 	{ 		echo 'Package: *'; 		echo 'Pin: release o=MariaDB'; 		echo 'Pin-Priority: 999'; 	} > /etc/apt/preferences.d/mariadb # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
# ARGS: GPG_KEYS=177F4010FE56CA3336300305F1656F24C74CD1D8 MARIADB_VERSION=1:10.11.9+maria~ubu2204 REPOSITORY=http://archive.mariadb.org/mariadb-10.11.9/repo/ubuntu/ jammy main main/debug
RUN set -ex; 	{ 		echo "mariadb-server" mysql-server/root_password password 'unused'; 		echo "mariadb-server" mysql-server/root_password_again password 'unused'; 	} | debconf-set-selections; 	apt-get update; 	mkdir -p /var/lib/mysql/mysql ; touch /var/lib/mysql/mysql/user.frm ; 	apt-get install -y --no-install-recommends mariadb-server="$MARIADB_VERSION" mariadb-backup socat 	; 	rm -rf /var/lib/apt/lists/*; 	rm -rf /var/lib/mysql /etc/mysql/mariadb.conf.d/50-mysqld_safe.cnf; 	mkdir -p /var/lib/mysql /run/mysqld; 	chown -R mysql:mysql /var/lib/mysql /run/mysqld; 	chmod 1777 /run/mysqld; 	find /etc/mysql/ -name '*.cnf' -print0 		| xargs -0 grep -lZE '^(bind-address|log|user\s)' 		| xargs -rt -0 sed -Ei 's/^(bind-address|log|user\s)/#&/'; 	printf "[mariadb]\nhost-cache-size=0\nskip-name-resolve\n" > /etc/mysql/mariadb.conf.d/05-skipcache.cnf; 	if [ -L /etc/mysql/my.cnf ]; then 		sed -i -e '/includedir/ {N;s/\(.*\)\n\(.*\)/\n\2\n\1/}' /etc/mysql/mariadb.cnf; 	fi # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
VOLUME [/var/lib/mysql]
# Tue, 03 Sep 2024 02:17:54 GMT
COPY healthcheck.sh /usr/local/bin/healthcheck.sh # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Tue, 03 Sep 2024 02:17:54 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Tue, 03 Sep 2024 02:17:54 GMT
EXPOSE map[3306/tcp:{}]
# Tue, 03 Sep 2024 02:17:54 GMT
CMD ["mariadbd"]
```

-	Layers:
	-	`sha256:41e9fbd89079d8e47609ae158236d59896fd2503db1ebdfef058864054170e01`  
		Last Modified: Wed, 11 Sep 2024 17:25:11 GMT  
		Size: 28.0 MB (28001475 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:e8674d17fc3eece5cc84a9f62a40844d764b4a720c71884e48479c160f6f3fb1`  
		Last Modified: Tue, 17 Sep 2024 02:20:55 GMT  
		Size: 1.7 KB (1725 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:157bb5a5a6a20fc98395d90ae1a6cf352888024b2b6b9291422edc64b027b95f`  
		Last Modified: Tue, 17 Sep 2024 02:20:55 GMT  
		Size: 5.5 MB (5532632 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:28d4d8b62a365d96c575b6523d77697d14647fe3ce47190ec6896509efd1677f`  
		Last Modified: Tue, 17 Sep 2024 02:20:55 GMT  
		Size: 116.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:4c4fbb0061f3802fc30ca7454e997d4c1be4ac6a37e76332eb9fe82b4cccf544`  
		Last Modified: Tue, 17 Sep 2024 02:23:09 GMT  
		Size: 337.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:1d69ab21fc077b1ef0456226deb82767bfb2a8e4aa482358f3d85fc85a307787`  
		Last Modified: Tue, 17 Sep 2024 02:23:11 GMT  
		Size: 88.1 MB (88071078 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:4f7ba8f40f6c4740e4677e5dc1ad202f6392d88e0600a3fee1088620806b0ce9`  
		Last Modified: Tue, 17 Sep 2024 02:23:09 GMT  
		Size: 4.0 KB (3957 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:16b299ff755cf88228b22e97219611041373376ff378ca97b9c6423dfb612000`  
		Last Modified: Tue, 17 Sep 2024 02:23:09 GMT  
		Size: 8.4 KB (8389 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `mariadb:10-jammy` - unknown; unknown

```console
$ docker pull mariadb@sha256:e307592c525f5f4e0516bc3f98f67718ec41ccd6e5b08a503de9fcd95b2c931b
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **4.6 MB (4619706 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:94886432e579a7ad1785d9bc769c79df0a339fcba0ef05303d7d1735e8d5d393`

```dockerfile
```

-	Layers:
	-	`sha256:1463f47cf14ad97710b3e4921d63d48c3ed8666e3aedd21c4b1f9bd79828d126`  
		Last Modified: Tue, 17 Sep 2024 02:23:09 GMT  
		Size: 4.6 MB (4589279 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:588e0d76193053c6de364397913bca8bbd72d66465a90c774c67dd21f752d5d9`  
		Last Modified: Tue, 17 Sep 2024 02:23:09 GMT  
		Size: 30.4 KB (30427 bytes)  
		MIME: application/vnd.in-toto+json
