## `haxe:4.2-windowsservercore-ltsc2022`

```console
$ docker pull haxe@sha256:dd68471e8c0447a8d4a74e6212983805832d1d7458dc538653ff358425ca4356
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.list.v2+json`
-	Platforms: 1
	-	windows version 10.0.20348.2762; amd64

### `haxe:4.2-windowsservercore-ltsc2022` - windows version 10.0.20348.2762; amd64

```console
$ docker pull haxe@sha256:383eaf7b81c3828103aacb1bd5c0c7a19aaf72b30703e508d0e6ba8b169f886c
```

-	Docker Version: 26.1.3
-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **1.8 GB (1825786532 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:4da07bf7bc1de7088fa902bc7493d77497f544183262edd5ed741fa4c37731a8`
-	Default Command: `["haxe"]`
-	`SHELL`: `["powershell","-Command","$ErrorActionPreference = 'Stop';"]`

```dockerfile
# Fri, 06 Sep 2024 00:01:38 GMT
RUN Apply image 10.0.20348.2700
# Sun, 06 Oct 2024 04:56:48 GMT
RUN Install update 10.0.20348.2762
# Wed, 09 Oct 2024 23:01:36 GMT
SHELL [powershell -Command $ErrorActionPreference = 'Stop';]
# Wed, 09 Oct 2024 23:01:37 GMT
ENV HAXETOOLKIT_PATH=C:\HaxeToolkit
# Wed, 09 Oct 2024 23:01:38 GMT
ENV NEKOPATH=C:\HaxeToolkit\neko
# Wed, 09 Oct 2024 23:01:38 GMT
ENV HAXEPATH=C:\HaxeToolkit\haxe
# Wed, 09 Oct 2024 23:01:39 GMT
ENV HAXE_STD_PATH=C:\HaxeToolkit\haxe\std
# Wed, 09 Oct 2024 23:01:40 GMT
ENV HAXELIB_PATH=C:\HaxeToolkit\haxe\lib
# Wed, 09 Oct 2024 23:01:55 GMT
RUN $newPath = ('{0};{1};{2}' -f $env:HAXEPATH, $env:NEKOPATH, $env:PATH); 	Write-Host ('Updating PATH: {0}' -f $newPath); 	[Environment]::SetEnvironmentVariable('PATH', $newPath, [EnvironmentVariableTarget]::Machine);
# Wed, 09 Oct 2024 23:02:22 GMT
RUN $url = 'https://download.microsoft.com/download/0/5/6/056dcda9-d667-4e27-8001-8a0c6971d6b1/vcredist_x86.exe'; 	Write-Host ('Downloading {0} ...' -f $url); 	[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; 	Invoke-WebRequest -Uri $url -OutFile 'vcredist_x86.exe'; 		Write-Host 'Verifying sha256 (89f4e593ea5541d1c53f983923124f9fd061a1c0c967339109e375c661573c17) ...'; 	if ((Get-FileHash vcredist_x86.exe -Algorithm sha256).Hash -ne '89f4e593ea5541d1c53f983923124f9fd061a1c0c967339109e375c661573c17') { 		Write-Host 'FAILED!'; 		exit 1; 	}; 		Write-Host 'Installing ...'; 	Start-Process -FilePath "vcredist_x86.exe" -ArgumentList "/Q" -Wait; 		Write-Host 'Removing installer...'; 	Remove-Item .\vcredist_x86.exe; 		Write-Host 'Complete.';
# Wed, 09 Oct 2024 23:02:27 GMT
RUN New-Item -ItemType directory -Path $env:HAXETOOLKIT_PATH;
# Wed, 09 Oct 2024 23:02:28 GMT
ENV NEKO_VERSION=2.3.0
# Wed, 09 Oct 2024 23:02:37 GMT
RUN $url = 'https://github.com/HaxeFoundation/neko/releases/download/v2-3-0/neko-2.3.0-win64.zip'; 	Write-Host ('Downloading {0} ...' -f $url); 	[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; 	Invoke-WebRequest -Uri $url -OutFile 'neko.zip'; 		Write-Host 'Verifying sha256 (d09fdf362cd2e3274f6c8528be7211663260c3a5323ce893b7637c2818995f0b) ...'; 	if ((Get-FileHash neko.zip -Algorithm sha256).Hash -ne 'd09fdf362cd2e3274f6c8528be7211663260c3a5323ce893b7637c2818995f0b') { 		Write-Host 'FAILED!'; 		exit 1; 	}; 		Write-Host 'Expanding ...'; 	New-Item -ItemType directory -Path tmp; 	Expand-Archive -Path neko.zip -DestinationPath tmp; 	if (Test-Path tmp\neko.exe) { Move-Item tmp $env:NEKOPATH } 	else { Move-Item (Resolve-Path tmp\neko* | Select -ExpandProperty Path) $env:NEKOPATH }; 		Write-Host 'Removing ...'; 	Remove-Item -Path neko.zip, tmp -Force -Recurse -ErrorAction Ignore; 		Write-Host 'Verifying install ...'; 	Write-Host '  neko -version'; neko -version; 		Write-Host 'Complete.';
# Wed, 09 Oct 2024 23:02:37 GMT
ENV HAXE_VERSION=4.2.5
# Wed, 09 Oct 2024 23:03:28 GMT
RUN $url = 'https://github.com/HaxeFoundation/haxe/releases/download/4.2.5/haxe-4.2.5-win64.zip'; 	Write-Host ('Downloading {0} ...' -f $url); 	[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; 	Invoke-WebRequest -Uri $url -OutFile haxe.zip; 		Write-Host 'Verifying sha256 (9e7913999eb3693d540926219b45107b3dc249feb44204c0378fcdc6a74a9132) ...'; 	if ((Get-FileHash haxe.zip -Algorithm sha256).Hash -ne '9e7913999eb3693d540926219b45107b3dc249feb44204c0378fcdc6a74a9132') { 		Write-Host 'FAILED!'; 		exit 1; 	}; 		Write-Host 'Expanding ...'; 	New-Item -ItemType directory -Path tmp; 	Expand-Archive -Path haxe.zip -DestinationPath tmp; 	if (Test-Path tmp\haxe.exe) { Move-Item tmp $env:HAXEPATH } 	else { Move-Item (Resolve-Path tmp\haxe* | Select -ExpandProperty Path) $env:HAXEPATH }; 		Write-Host 'Removing ...'; 	Remove-Item -Path haxe.zip, tmp -Force -Recurse -ErrorAction Ignore; 		Write-Host 'Verifying install ...'; 	Write-Host '  haxe -version'; haxe -version; 	Write-Host '  haxelib version'; haxelib version; 		Write-Host 'Complete.';
# Wed, 09 Oct 2024 23:03:34 GMT
RUN New-Item -ItemType directory -Path $env:HAXELIB_PATH;
# Wed, 09 Oct 2024 23:03:34 GMT
ENV HOMEDRIVE=C:
# Wed, 09 Oct 2024 23:03:40 GMT
RUN $newPath = ('{0}\Users\{1}' -f $env:HOMEDRIVE, $env:USERNAME); 	Write-Host ('Updating HOMEPATH: {0}' -f $newPath); 	[Environment]::SetEnvironmentVariable('HOMEPATH', $newPath, [EnvironmentVariableTarget]::Machine);
# Wed, 09 Oct 2024 23:03:46 GMT
RUN (New-Object System.Net.WebClient).DownloadString('https://lib.haxe.org/p/hxcpp/4.2.1/download/') >$null
# Wed, 09 Oct 2024 23:03:47 GMT
CMD ["haxe"]
```

-	Layers:
	-	`sha256:2534953f34d35976fc44cd67bfdd39fdcd9e2eaae57ada0be53d5fb936cd3a0b`  
		Last Modified: Tue, 10 Sep 2024 17:49:01 GMT  
		Size: 1.5 GB (1462192413 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:3445b497121718058765c341117a0c1522c51cd65bec8c517981a745ff91f0bf`  
		Last Modified: Tue, 08 Oct 2024 17:56:28 GMT  
		Size: 337.1 MB (337149137 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:57b4786a95a0447da709d9edd3ccb8b249e91af8d5c6541dca484a0e782dfbab`  
		Last Modified: Wed, 09 Oct 2024 23:03:58 GMT  
		Size: 1.3 KB (1286 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:7dbf472d3129d285716873bce1fccded633241ecf4bc0d5e301d90e9c7d83d02`  
		Last Modified: Wed, 09 Oct 2024 23:03:57 GMT  
		Size: 1.3 KB (1283 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:3851cebec6ef43153f2c7ffdd451e9ded0c3b6719b9aace2af0811ac70965575`  
		Last Modified: Wed, 09 Oct 2024 23:03:57 GMT  
		Size: 1.3 KB (1288 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:b964553a054285898a17a5d96f63db52b7cd23dfa04a90f87f4c8988ba28b64d`  
		Last Modified: Wed, 09 Oct 2024 23:03:56 GMT  
		Size: 1.3 KB (1286 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:9bebff5c6d4baf0b64544240ca5ba1bc0aa19bd0d65d6ece1f49efd79c62afd0`  
		Last Modified: Wed, 09 Oct 2024 23:03:56 GMT  
		Size: 1.3 KB (1288 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:48323a95ec1b828c66328850cc1b7a8f82392d7e1aae8d1cdb73738a5cf23bbe`  
		Last Modified: Wed, 09 Oct 2024 23:03:55 GMT  
		Size: 1.3 KB (1286 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:5db63a95b1e6c83eb990df83942b01704b43b6750c649467bee1ed1129930ba9`  
		Last Modified: Wed, 09 Oct 2024 23:03:55 GMT  
		Size: 490.2 KB (490190 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:f27a4db53508f8d58b030f138634c0c64980fa29efa220268b165382d9643902`  
		Last Modified: Wed, 09 Oct 2024 23:03:56 GMT  
		Size: 12.9 MB (12949231 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:046eaaa0fde8f5ace6542c17781c576647422d508337bfa731b10f7a88c6cb9d`  
		Last Modified: Wed, 09 Oct 2024 23:03:53 GMT  
		Size: 378.6 KB (378557 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:a0d6e7d2edf6aacff2e1e9af6ea41d2c6969b75b607fa2882acac563289f4c19`  
		Last Modified: Wed, 09 Oct 2024 23:03:53 GMT  
		Size: 1.3 KB (1286 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:45d050b3ef49263e441252ac8dbf77b00bfa289d5e361c86e111d9c7bdbf8c0f`  
		Last Modified: Wed, 09 Oct 2024 23:03:54 GMT  
		Size: 2.2 MB (2210536 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:e414a468114cd148f5edfa6774973554f76531f1f75a07d9761fed51a25c7345`  
		Last Modified: Wed, 09 Oct 2024 23:03:53 GMT  
		Size: 1.3 KB (1279 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:be72578495803460debdfdfadd346dd55c2f0d9d9fd9679e239d6ff476c8612f`  
		Last Modified: Wed, 09 Oct 2024 23:03:54 GMT  
		Size: 9.2 MB (9231999 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:8b5dcecaa49442d02eab26e119e0d1cd24f471abaea10a55ba7ecb7a7aec55b2`  
		Last Modified: Wed, 09 Oct 2024 23:03:51 GMT  
		Size: 377.8 KB (377807 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:b4461eda421f2047d1d5f6a723058e7a416f0e8c6d38fff9f4cfd3894578eee0`  
		Last Modified: Wed, 09 Oct 2024 23:03:51 GMT  
		Size: 1.3 KB (1279 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:2d84d25ece91be2b318e1644c55c8d2a60aa243e31d187f9021e7efa515bb149`  
		Last Modified: Wed, 09 Oct 2024 23:03:51 GMT  
		Size: 388.2 KB (388195 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:04f9ac39be1dde715d127dc176de2744eb8875408211049fd93a5a4e66ea0239`  
		Last Modified: Wed, 09 Oct 2024 23:03:51 GMT  
		Size: 405.6 KB (405626 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:713acd81e8f54d18c6d7892a8ad3f4c4abb7525f61786c4a3cc99a66cf97f9d0`  
		Last Modified: Wed, 09 Oct 2024 23:03:51 GMT  
		Size: 1.3 KB (1280 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
