## `haxe:4.1.5`

```console
$ docker pull haxe@sha256:439572e4f88a0de24be7478fb7eb30eae059d461a7409c5fc7415a7e7666f596
```

-	Manifest MIME: `application/vnd.oci.image.index.v1+json`
-	Platforms: 8
	-	linux; amd64
	-	unknown; unknown
	-	linux; arm variant v7
	-	unknown; unknown
	-	linux; arm64 variant v8
	-	unknown; unknown
	-	windows version 10.0.20348.2762; amd64
	-	windows version 10.0.17763.6414; amd64

### `haxe:4.1.5` - linux; amd64

```console
$ docker pull haxe@sha256:91af0e62b38c87930d7c04043dac76a5ce3f4cba1fc4efdec422b4e1f40ab81e
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **138.2 MB (138200626 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:c1b635532e394fb1f9a92aaf1d527ff77d4394199ca02ee3bf4e0647993009f7`
-	Default Command: `["haxe"]`

```dockerfile
# Fri, 28 Apr 2023 21:58:08 GMT
ADD file:603894b180221fc8174e291cd1177a2b9c09a07d1d9ba4d5b5aecdf80ad91fbb in / 
# Fri, 28 Apr 2023 21:58:08 GMT
CMD ["bash"]
# Fri, 28 Apr 2023 21:58:08 GMT
RUN set -eux; 	apt-get update; 	apt-get install -y --no-install-recommends 		ca-certificates 		curl 		gnupg 		netbase 		wget 	; 	rm -rf /var/lib/apt/lists/* # buildkit
# Tue, 09 Jan 2024 01:14:25 GMT
RUN set -eux; 	apt-get update; 	apt-get install -y --no-install-recommends 		git 		mercurial 		openssh-client 		subversion 				procps 	; 	rm -rf /var/lib/apt/lists/* # buildkit
# Tue, 01 Oct 2024 06:21:31 GMT
ENV PATH=/usr/local/bin:/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin
# Tue, 01 Oct 2024 06:21:31 GMT
RUN apt-get update && apt-get install -y --no-install-recommends 		libgc1 		zlib1g 		libpcre2-8-0 		libpcre3 		libmariadb3 		libsqlite3-0 		libmbedcrypto3 		libmbedtls12 		libmbedx509-0 	&& rm -rf /var/lib/apt/lists/* # buildkit
# Tue, 01 Oct 2024 06:21:31 GMT
ENV NEKO_VERSION=2.4.0
# Tue, 01 Oct 2024 06:21:31 GMT
RUN set -ex 	&& buildDeps=' 		gcc 		make 		cmake 		libgc-dev 		libssl-dev 		libpcre2-dev 		zlib1g-dev 		apache2-dev 		libmariadb-client-lgpl-dev-compat 		libsqlite3-dev 		libmbedtls-dev 		libgtk-3-dev 	' 	&& apt-get update && apt-get install -y $buildDeps --no-install-recommends && rm -rf /var/lib/apt/lists/* 		&& wget -O neko.tar.gz "https://github.com/HaxeFoundation/neko/archive/v2-4-0/neko-2.4.0.tar.gz" 	&& echo "232d030ce27ce648f3b3dd11e39dca0a609347336b439a4a59e9a5c0a465ce15 *neko.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/neko 	&& tar -xC /usr/src/neko --strip-components=1 -f neko.tar.gz 	&& rm neko.tar.gz 	&& cd /usr/src/neko 	&& cmake -DRELOCATABLE=OFF . 	&& make 	&& make install 		&& apt-get purge -y --auto-remove $buildDeps 	&& rm -rf /usr/src/neko ~/.cache # buildkit
# Tue, 01 Oct 2024 06:21:31 GMT
ENV HAXE_VERSION=4.1.5
# Tue, 01 Oct 2024 06:21:31 GMT
ENV HAXE_STD_PATH=/usr/local/share/haxe/std
# Tue, 01 Oct 2024 06:21:31 GMT
RUN set -ex 	&& buildDeps=' 		make 		ocaml-nox 		ocaml-native-compilers 		camlp4 		ocaml-findlib 		zlib1g-dev 		libpcre3-dev 		libmbedtls-dev 		libxml-light-ocaml-dev 		opam 		mccs 		m4 		unzip 		pkg-config 		libstring-shellquote-perl 		libipc-system-simple-perl 	' 	&& git clone --recursive --depth 1 --branch 4.1.5 "https://github.com/HaxeFoundation/haxe.git" /usr/src/haxe 	&& cd /usr/src/haxe 	&& mkdir -p $HAXE_STD_PATH 	&& cp -r std/* $HAXE_STD_PATH 	&& apt-get update && apt-get install -y $buildDeps --no-install-recommends 		&& opam init --disable-sandboxing 	&& eval `opam env` 		&& opam pin add extlib 1.7.7 --no-action 		&& ( [ -f /usr/src/haxe/opam ] || [ -f /usr/src/haxe/haxe.opam ] && opam install /usr/src/haxe --deps-only --yes || make opam_install ) 	&& make all tools 	&& mkdir -p /usr/local/bin 	&& cp haxe haxelib /usr/local/bin 	&& mkdir -p /haxelib 	&& cd / && haxelib setup /haxelib 		&& eval `opam env --revert` 	&& rm -rf ~/.opam 	&& rm -rf /var/lib/apt/lists/* 	&& apt-get purge -y --auto-remove $buildDeps 	&& rm -rf /usr/src/haxe ~/.cache # buildkit
# Tue, 01 Oct 2024 06:21:31 GMT
CMD ["haxe"]
```

-	Layers:
	-	`sha256:9439c0e98e5f72dba1ea7cf303c3ca61ff9a91b26911886adb4266e2ad40bb58`  
		Last Modified: Thu, 17 Oct 2024 00:24:16 GMT  
		Size: 55.1 MB (55080611 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:99c539c6f53265d7398b56c208ca7cbf4f16d1714d21b9ed251a77bf75966bc2`  
		Last Modified: Sat, 19 Oct 2024 00:54:50 GMT  
		Size: 15.8 MB (15762308 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:d07a20b182d5672c6ec8dca30220175ce5c60e45bf630d6adae50504d92368ad`  
		Last Modified: Sat, 19 Oct 2024 02:06:22 GMT  
		Size: 54.7 MB (54725293 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:6a4d3a459a28573e5111ec5362980bdd348ba0d06dc67fdaf0401eef3a5cdbd7`  
		Last Modified: Sat, 19 Oct 2024 03:00:28 GMT  
		Size: 1.1 MB (1147318 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:99c29284153eb1aa74d05b44616dc31f8aec5f10b8943b1e238af02d53a2eb63`  
		Last Modified: Sat, 19 Oct 2024 03:00:27 GMT  
		Size: 1.5 MB (1461242 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:d8234a3bac73bd8e34136bd1da16532d140fbe407a6567df8010105488528c58`  
		Last Modified: Sat, 19 Oct 2024 03:00:28 GMT  
		Size: 10.0 MB (10023854 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `haxe:4.1.5` - unknown; unknown

```console
$ docker pull haxe@sha256:7d720d9483605b9b31a6936dd49f1f286b5baa43e7c17117821c19580ed01f45
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **19.0 KB (19006 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:064de409990a1b2b0b377aa99df2c9542bba659eb28b43cb13c376fcfc83b65a`

```dockerfile
```

-	Layers:
	-	`sha256:452e46319fb466e5c1ffd6dbef32e551ee9a8dcff95cda6d86d0c3fcfec42427`  
		Last Modified: Sat, 19 Oct 2024 03:00:27 GMT  
		Size: 19.0 KB (19006 bytes)  
		MIME: application/vnd.in-toto+json

### `haxe:4.1.5` - linux; arm variant v7

```console
$ docker pull haxe@sha256:0c1de7e97d9d737e2e62bd43d52f97cf3092a8022228ac83cef8b319622164dd
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **127.8 MB (127813508 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:a80f38dbc48e127a3189928fe33f39df94d9f7168799bff3d50dcee4a2cb31ba`
-	Default Command: `["haxe"]`

```dockerfile
# Fri, 28 Apr 2023 21:58:08 GMT
ADD file:d2ab4547fbd8c2ffd1467397e3bf7357c565dd0ddab7b1fe46a7af555c5a2d58 in / 
# Fri, 28 Apr 2023 21:58:08 GMT
CMD ["bash"]
# Fri, 28 Apr 2023 21:58:08 GMT
RUN set -eux; 	apt-get update; 	apt-get install -y --no-install-recommends 		ca-certificates 		curl 		gnupg 		netbase 		wget 	; 	rm -rf /var/lib/apt/lists/* # buildkit
# Tue, 09 Jan 2024 01:14:25 GMT
RUN set -eux; 	apt-get update; 	apt-get install -y --no-install-recommends 		git 		mercurial 		openssh-client 		subversion 				procps 	; 	rm -rf /var/lib/apt/lists/* # buildkit
# Tue, 01 Oct 2024 06:21:31 GMT
ENV PATH=/usr/local/bin:/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin
# Tue, 01 Oct 2024 06:21:31 GMT
RUN apt-get update && apt-get install -y --no-install-recommends 		libgc1 		zlib1g 		libpcre2-8-0 		libpcre3 		libmariadb3 		libsqlite3-0 		libmbedcrypto3 		libmbedtls12 		libmbedx509-0 	&& rm -rf /var/lib/apt/lists/* # buildkit
# Tue, 01 Oct 2024 06:21:31 GMT
ENV NEKO_VERSION=2.4.0
# Tue, 01 Oct 2024 06:21:31 GMT
RUN set -ex 	&& buildDeps=' 		gcc 		make 		cmake 		libgc-dev 		libssl-dev 		libpcre2-dev 		zlib1g-dev 		apache2-dev 		libmariadb-client-lgpl-dev-compat 		libsqlite3-dev 		libmbedtls-dev 		libgtk-3-dev 	' 	&& apt-get update && apt-get install -y $buildDeps --no-install-recommends && rm -rf /var/lib/apt/lists/* 		&& wget -O neko.tar.gz "https://github.com/HaxeFoundation/neko/archive/v2-4-0/neko-2.4.0.tar.gz" 	&& echo "232d030ce27ce648f3b3dd11e39dca0a609347336b439a4a59e9a5c0a465ce15 *neko.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/neko 	&& tar -xC /usr/src/neko --strip-components=1 -f neko.tar.gz 	&& rm neko.tar.gz 	&& cd /usr/src/neko 	&& cmake -DRELOCATABLE=OFF . 	&& make 	&& make install 		&& apt-get purge -y --auto-remove $buildDeps 	&& rm -rf /usr/src/neko ~/.cache # buildkit
# Tue, 01 Oct 2024 06:21:31 GMT
ENV HAXE_VERSION=4.1.5
# Tue, 01 Oct 2024 06:21:31 GMT
ENV HAXE_STD_PATH=/usr/local/share/haxe/std
# Tue, 01 Oct 2024 06:21:31 GMT
RUN set -ex 	&& buildDeps=' 		make 		ocaml-nox 		ocaml-native-compilers 		camlp4 		ocaml-findlib 		zlib1g-dev 		libpcre3-dev 		libmbedtls-dev 		libxml-light-ocaml-dev 		opam 		mccs 		m4 		unzip 		pkg-config 		libstring-shellquote-perl 		libipc-system-simple-perl 	' 	&& git clone --recursive --depth 1 --branch 4.1.5 "https://github.com/HaxeFoundation/haxe.git" /usr/src/haxe 	&& cd /usr/src/haxe 	&& mkdir -p $HAXE_STD_PATH 	&& cp -r std/* $HAXE_STD_PATH 	&& apt-get update && apt-get install -y $buildDeps --no-install-recommends 		&& opam init --disable-sandboxing 	&& eval `opam env` 		&& opam pin add extlib 1.7.7 --no-action 		&& ( [ -f /usr/src/haxe/opam ] || [ -f /usr/src/haxe/haxe.opam ] && opam install /usr/src/haxe --deps-only --yes || make opam_install ) 	&& make all tools 	&& mkdir -p /usr/local/bin 	&& cp haxe haxelib /usr/local/bin 	&& mkdir -p /haxelib 	&& cd / && haxelib setup /haxelib 		&& eval `opam env --revert` 	&& rm -rf ~/.opam 	&& rm -rf /var/lib/apt/lists/* 	&& apt-get purge -y --auto-remove $buildDeps 	&& rm -rf /usr/src/haxe ~/.cache # buildkit
# Tue, 01 Oct 2024 06:21:31 GMT
CMD ["haxe"]
```

-	Layers:
	-	`sha256:a95f74ee8cb74ceb08cfe11180d99d077de86d07cce20c373d10c20ce9885b49`  
		Last Modified: Thu, 17 Oct 2024 03:07:14 GMT  
		Size: 50.2 MB (50241596 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:9f418fba84fbaf7bab67bcb059341b214f170e38610e4b70f45295fd8324614f`  
		Last Modified: Sat, 19 Oct 2024 00:56:46 GMT  
		Size: 14.9 MB (14877684 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:f27a9032c7c4d1cfb31e96212773919f51ec2f6be760fc0f5c35bafbcdb50249`  
		Last Modified: Sat, 19 Oct 2024 06:37:59 GMT  
		Size: 50.6 MB (50613654 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:8db5522561ebad678c71ca3e0c52856bbfc902ec6a780a72a630c1f8dbb85379`  
		Last Modified: Sat, 19 Oct 2024 09:28:22 GMT  
		Size: 1.1 MB (1060320 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:762f3d3e145326dc7171dcfcf046171ace6e333427dc76e693d37de2f8fc5228`  
		Last Modified: Sat, 19 Oct 2024 09:28:22 GMT  
		Size: 1.4 MB (1401047 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:14048349efdb7f685f3ea9986306a8a6a1e8cadf4e2db1240e0f3269bb053e0a`  
		Last Modified: Sat, 19 Oct 2024 09:32:08 GMT  
		Size: 9.6 MB (9619207 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `haxe:4.1.5` - unknown; unknown

```console
$ docker pull haxe@sha256:b3c848ea210bd5d4873c3117e4c4d1d9c7374428c0020d4e590443df84e7b9cb
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **19.1 KB (19130 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:bf572f72a3d083b3b63e384fee1387fcf489342a94dbb229fe4e33a8d0859a9b`

```dockerfile
```

-	Layers:
	-	`sha256:df5436fe47161ca1bfbde3c7d8cb55e89b971c8731d9d41a74e669b1393ae6ec`  
		Last Modified: Sat, 19 Oct 2024 09:32:08 GMT  
		Size: 19.1 KB (19130 bytes)  
		MIME: application/vnd.in-toto+json

### `haxe:4.1.5` - linux; arm64 variant v8

```console
$ docker pull haxe@sha256:4c758fdd5ca93a762b0fe7f88d0629c3ae5ccae7a50dba91acfb2bbf76dc5f83
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **138.4 MB (138387989 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:386d01a8e8394c5b60c177bfcbf370379f269032383ba325b0a4c5b45be6308c`
-	Default Command: `["haxe"]`

```dockerfile
# Fri, 28 Apr 2023 21:58:08 GMT
ADD file:bfb52ce9788d517977c9e84dad795a6adb46efc0e8eff88853137b783826c104 in / 
# Fri, 28 Apr 2023 21:58:08 GMT
CMD ["bash"]
# Fri, 28 Apr 2023 21:58:08 GMT
RUN set -eux; 	apt-get update; 	apt-get install -y --no-install-recommends 		ca-certificates 		curl 		gnupg 		netbase 		wget 	; 	rm -rf /var/lib/apt/lists/* # buildkit
# Tue, 09 Jan 2024 01:14:25 GMT
RUN set -eux; 	apt-get update; 	apt-get install -y --no-install-recommends 		git 		mercurial 		openssh-client 		subversion 				procps 	; 	rm -rf /var/lib/apt/lists/* # buildkit
# Tue, 01 Oct 2024 06:21:31 GMT
ENV PATH=/usr/local/bin:/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin
# Tue, 01 Oct 2024 06:21:31 GMT
RUN apt-get update && apt-get install -y --no-install-recommends 		libgc1 		zlib1g 		libpcre2-8-0 		libpcre3 		libmariadb3 		libsqlite3-0 		libmbedcrypto3 		libmbedtls12 		libmbedx509-0 	&& rm -rf /var/lib/apt/lists/* # buildkit
# Tue, 01 Oct 2024 06:21:31 GMT
ENV NEKO_VERSION=2.4.0
# Tue, 01 Oct 2024 06:21:31 GMT
RUN set -ex 	&& buildDeps=' 		gcc 		make 		cmake 		libgc-dev 		libssl-dev 		libpcre2-dev 		zlib1g-dev 		apache2-dev 		libmariadb-client-lgpl-dev-compat 		libsqlite3-dev 		libmbedtls-dev 		libgtk-3-dev 	' 	&& apt-get update && apt-get install -y $buildDeps --no-install-recommends && rm -rf /var/lib/apt/lists/* 		&& wget -O neko.tar.gz "https://github.com/HaxeFoundation/neko/archive/v2-4-0/neko-2.4.0.tar.gz" 	&& echo "232d030ce27ce648f3b3dd11e39dca0a609347336b439a4a59e9a5c0a465ce15 *neko.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/neko 	&& tar -xC /usr/src/neko --strip-components=1 -f neko.tar.gz 	&& rm neko.tar.gz 	&& cd /usr/src/neko 	&& cmake -DRELOCATABLE=OFF . 	&& make 	&& make install 		&& apt-get purge -y --auto-remove $buildDeps 	&& rm -rf /usr/src/neko ~/.cache # buildkit
# Tue, 01 Oct 2024 06:21:31 GMT
ENV HAXE_VERSION=4.1.5
# Tue, 01 Oct 2024 06:21:31 GMT
ENV HAXE_STD_PATH=/usr/local/share/haxe/std
# Tue, 01 Oct 2024 06:21:31 GMT
RUN set -ex 	&& buildDeps=' 		make 		ocaml-nox 		ocaml-native-compilers 		camlp4 		ocaml-findlib 		zlib1g-dev 		libpcre3-dev 		libmbedtls-dev 		libxml-light-ocaml-dev 		opam 		mccs 		m4 		unzip 		pkg-config 		libstring-shellquote-perl 		libipc-system-simple-perl 	' 	&& git clone --recursive --depth 1 --branch 4.1.5 "https://github.com/HaxeFoundation/haxe.git" /usr/src/haxe 	&& cd /usr/src/haxe 	&& mkdir -p $HAXE_STD_PATH 	&& cp -r std/* $HAXE_STD_PATH 	&& apt-get update && apt-get install -y $buildDeps --no-install-recommends 		&& opam init --disable-sandboxing 	&& eval `opam env` 		&& opam pin add extlib 1.7.7 --no-action 		&& ( [ -f /usr/src/haxe/opam ] || [ -f /usr/src/haxe/haxe.opam ] && opam install /usr/src/haxe --deps-only --yes || make opam_install ) 	&& make all tools 	&& mkdir -p /usr/local/bin 	&& cp haxe haxelib /usr/local/bin 	&& mkdir -p /haxelib 	&& cd / && haxelib setup /haxelib 		&& eval `opam env --revert` 	&& rm -rf ~/.opam 	&& rm -rf /var/lib/apt/lists/* 	&& apt-get purge -y --auto-remove $buildDeps 	&& rm -rf /usr/src/haxe ~/.cache # buildkit
# Tue, 01 Oct 2024 06:21:31 GMT
CMD ["haxe"]
```

-	Layers:
	-	`sha256:76475c2689e229fac9e8ba4a02e64decb7fd62b2a3e4ad65ba97f8e1a35471f2`  
		Last Modified: Thu, 17 Oct 2024 01:14:55 GMT  
		Size: 53.7 MB (53734895 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:1deb2c2ef23607994f7238c8d97d113f5ebd868b8eb64a0c10d2e0983f036a39`  
		Last Modified: Sat, 19 Oct 2024 01:11:09 GMT  
		Size: 15.7 MB (15747789 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:3fbc6072bf5318ca0f9f250b4fcc6254d92483650689f0b0d77274be187abd96`  
		Last Modified: Sat, 19 Oct 2024 05:18:19 GMT  
		Size: 54.8 MB (54832658 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:a053229ab65ae5ea349dd4c35fec35910ce7cb0c9d958f69e72cf046474e3bc8`  
		Last Modified: Sat, 19 Oct 2024 07:58:48 GMT  
		Size: 1.1 MB (1138149 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:8a436322767a956b6b6fa2222e33ffe73b5c354e3be6cdce6629c209b020630d`  
		Last Modified: Sat, 19 Oct 2024 07:58:49 GMT  
		Size: 1.5 MB (1453024 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:5603fb97f1641e414f6a0e0f32e13ffd5f9bb16db6e77ed9eeb23f393a0b4552`  
		Last Modified: Sat, 19 Oct 2024 07:58:49 GMT  
		Size: 11.5 MB (11481474 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `haxe:4.1.5` - unknown; unknown

```console
$ docker pull haxe@sha256:7fb35d827142762e640225f75ae57d595e971a3ed3e56ce11c6c6c1167510420
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **19.2 KB (19164 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:7a4bde030a2d824a6fb29903016ac455c3e288809333b4cf382a41730ee6bc1c`

```dockerfile
```

-	Layers:
	-	`sha256:a1a3fc16358a3b50c3a398c9999eb88841df8b7a357614ce21c928f3ceba2d91`  
		Last Modified: Sat, 19 Oct 2024 07:58:48 GMT  
		Size: 19.2 KB (19164 bytes)  
		MIME: application/vnd.in-toto+json

### `haxe:4.1.5` - windows version 10.0.20348.2762; amd64

```console
$ docker pull haxe@sha256:3a863f14cc928333f206911b9fb7132e493772b23a8683e5e381ac35da7f7cfe
```

-	Docker Version: 26.1.3
-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **1.8 GB (1824186685 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:d84a0bea3cbd27c8f7c66bf45ed35f3c1f52bae25298a1bc203196660a5d6da6`
-	Default Command: `["haxe"]`
-	`SHELL`: `["powershell","-Command","$ErrorActionPreference = 'Stop';"]`

```dockerfile
# Fri, 06 Sep 2024 00:01:38 GMT
RUN Apply image 10.0.20348.2700
# Sun, 06 Oct 2024 04:56:48 GMT
RUN Install update 10.0.20348.2762
# Wed, 09 Oct 2024 23:07:04 GMT
SHELL [powershell -Command $ErrorActionPreference = 'Stop';]
# Wed, 09 Oct 2024 23:07:05 GMT
ENV HAXETOOLKIT_PATH=C:\HaxeToolkit
# Wed, 09 Oct 2024 23:07:06 GMT
ENV NEKOPATH=C:\HaxeToolkit\neko
# Wed, 09 Oct 2024 23:07:07 GMT
ENV HAXEPATH=C:\HaxeToolkit\haxe
# Wed, 09 Oct 2024 23:07:08 GMT
ENV HAXE_STD_PATH=C:\HaxeToolkit\haxe\std
# Wed, 09 Oct 2024 23:07:09 GMT
ENV HAXELIB_PATH=C:\HaxeToolkit\haxe\lib
# Wed, 09 Oct 2024 23:07:31 GMT
RUN $newPath = ('{0};{1};{2}' -f $env:HAXEPATH, $env:NEKOPATH, $env:PATH); 	Write-Host ('Updating PATH: {0}' -f $newPath); 	[Environment]::SetEnvironmentVariable('PATH', $newPath, [EnvironmentVariableTarget]::Machine);
# Wed, 09 Oct 2024 23:08:04 GMT
RUN $url = 'https://download.microsoft.com/download/0/5/6/056dcda9-d667-4e27-8001-8a0c6971d6b1/vcredist_x86.exe'; 	Write-Host ('Downloading {0} ...' -f $url); 	[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; 	Invoke-WebRequest -Uri $url -OutFile 'vcredist_x86.exe'; 		Write-Host 'Verifying sha256 (89f4e593ea5541d1c53f983923124f9fd061a1c0c967339109e375c661573c17) ...'; 	if ((Get-FileHash vcredist_x86.exe -Algorithm sha256).Hash -ne '89f4e593ea5541d1c53f983923124f9fd061a1c0c967339109e375c661573c17') { 		Write-Host 'FAILED!'; 		exit 1; 	}; 		Write-Host 'Installing ...'; 	Start-Process -FilePath "vcredist_x86.exe" -ArgumentList "/Q" -Wait; 		Write-Host 'Removing installer...'; 	Remove-Item .\vcredist_x86.exe; 		Write-Host 'Complete.';
# Wed, 09 Oct 2024 23:08:11 GMT
RUN New-Item -ItemType directory -Path $env:HAXETOOLKIT_PATH;
# Wed, 09 Oct 2024 23:08:11 GMT
ENV NEKO_VERSION=2.3.0
# Wed, 09 Oct 2024 23:08:22 GMT
RUN $url = 'https://github.com/HaxeFoundation/neko/releases/download/v2-3-0/neko-2.3.0-win64.zip'; 	Write-Host ('Downloading {0} ...' -f $url); 	[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; 	Invoke-WebRequest -Uri $url -OutFile 'neko.zip'; 		Write-Host 'Verifying sha256 (d09fdf362cd2e3274f6c8528be7211663260c3a5323ce893b7637c2818995f0b) ...'; 	if ((Get-FileHash neko.zip -Algorithm sha256).Hash -ne 'd09fdf362cd2e3274f6c8528be7211663260c3a5323ce893b7637c2818995f0b') { 		Write-Host 'FAILED!'; 		exit 1; 	}; 		Write-Host 'Expanding ...'; 	New-Item -ItemType directory -Path tmp; 	Expand-Archive -Path neko.zip -DestinationPath tmp; 	if (Test-Path tmp\neko.exe) { Move-Item tmp $env:NEKOPATH } 	else { Move-Item (Resolve-Path tmp\neko* | Select -ExpandProperty Path) $env:NEKOPATH }; 		Write-Host 'Removing ...'; 	Remove-Item -Path neko.zip, tmp -Force -Recurse -ErrorAction Ignore; 		Write-Host 'Verifying install ...'; 	Write-Host '  neko -version'; neko -version; 		Write-Host 'Complete.';
# Wed, 09 Oct 2024 23:08:24 GMT
ENV HAXE_VERSION=4.1.5
# Wed, 09 Oct 2024 23:09:13 GMT
RUN $url = 'https://github.com/HaxeFoundation/haxe/releases/download/4.1.5/haxe-4.1.5-win64.zip'; 	Write-Host ('Downloading {0} ...' -f $url); 	[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; 	Invoke-WebRequest -Uri $url -OutFile haxe.zip; 		Write-Host 'Verifying sha256 (ce4134cdf49814f8f8694648408d006116bd171b957a37be74c79cf403db9633) ...'; 	if ((Get-FileHash haxe.zip -Algorithm sha256).Hash -ne 'ce4134cdf49814f8f8694648408d006116bd171b957a37be74c79cf403db9633') { 		Write-Host 'FAILED!'; 		exit 1; 	}; 		Write-Host 'Expanding ...'; 	New-Item -ItemType directory -Path tmp; 	Expand-Archive -Path haxe.zip -DestinationPath tmp; 	if (Test-Path tmp\haxe.exe) { Move-Item tmp $env:HAXEPATH } 	else { Move-Item (Resolve-Path tmp\haxe* | Select -ExpandProperty Path) $env:HAXEPATH }; 		Write-Host 'Removing ...'; 	Remove-Item -Path haxe.zip, tmp -Force -Recurse -ErrorAction Ignore; 		Write-Host 'Verifying install ...'; 	Write-Host '  haxe -version'; haxe -version; 	Write-Host '  haxelib version'; haxelib version; 		Write-Host 'Complete.';
# Wed, 09 Oct 2024 23:09:19 GMT
RUN New-Item -ItemType directory -Path $env:HAXELIB_PATH;
# Wed, 09 Oct 2024 23:09:20 GMT
ENV HOMEDRIVE=C:
# Wed, 09 Oct 2024 23:09:26 GMT
RUN $newPath = ('{0}\Users\{1}' -f $env:HOMEDRIVE, $env:USERNAME); 	Write-Host ('Updating HOMEPATH: {0}' -f $newPath); 	[Environment]::SetEnvironmentVariable('HOMEPATH', $newPath, [EnvironmentVariableTarget]::Machine);
# Wed, 09 Oct 2024 23:09:34 GMT
RUN (New-Object System.Net.WebClient).DownloadString('https://lib.haxe.org/p/hxcpp/4.2.1/download/') >$null
# Wed, 09 Oct 2024 23:09:34 GMT
CMD ["haxe"]
```

-	Layers:
	-	`sha256:2534953f34d35976fc44cd67bfdd39fdcd9e2eaae57ada0be53d5fb936cd3a0b`  
		Last Modified: Tue, 10 Sep 2024 17:49:01 GMT  
		Size: 1.5 GB (1462192413 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:3445b497121718058765c341117a0c1522c51cd65bec8c517981a745ff91f0bf`  
		Last Modified: Tue, 08 Oct 2024 17:56:28 GMT  
		Size: 337.1 MB (337149137 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:ef6b087075c613334f6b3675607c48c2a373514cc792a3c1d82f15f3703c0dfd`  
		Last Modified: Wed, 09 Oct 2024 23:09:41 GMT  
		Size: 1.3 KB (1290 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:353cf372f23c9989130d9119e900f0a1e87241f46ea2e352bdec295fa04e8c64`  
		Last Modified: Wed, 09 Oct 2024 23:09:41 GMT  
		Size: 1.3 KB (1278 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:85ec4ef64b9a04e601d519c6b435c2ae7cd672635c8892d20114195edc423f02`  
		Last Modified: Wed, 09 Oct 2024 23:09:41 GMT  
		Size: 1.3 KB (1283 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:c4138ec7234684cdbcf5b590e8f92fd9d9ea44f7217092df20fac69885ca2a7b`  
		Last Modified: Wed, 09 Oct 2024 23:09:41 GMT  
		Size: 1.3 KB (1280 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:550979258044bd54a97adefddb52bd64ab5a5dc049d74e75ee8a58049e8a5aae`  
		Last Modified: Wed, 09 Oct 2024 23:09:40 GMT  
		Size: 1.3 KB (1280 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:699719a8079261927cfa39d9a3817647566f7cf852567e24c3ab2ece17f83bb7`  
		Last Modified: Wed, 09 Oct 2024 23:09:40 GMT  
		Size: 1.3 KB (1289 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:1d82e5d3d8c84b0629a279c7680df01a553063c3160aee59d0eaf24b85381e34`  
		Last Modified: Wed, 09 Oct 2024 23:09:39 GMT  
		Size: 479.2 KB (479182 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:2c6e51c5ad332af250c93dcbb38559f24c55458452a3f08f3e817b31f282bb86`  
		Last Modified: Wed, 09 Oct 2024 23:09:40 GMT  
		Size: 12.9 MB (12938605 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:88d14a30c4da5150ab00d4bc9d8365d5b20ab65ec2631121afa6f714c0c71cf1`  
		Last Modified: Wed, 09 Oct 2024 23:09:39 GMT  
		Size: 369.6 KB (369558 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:5fda060ba10063d0eb66ccb1c80db1225bd31f3c804904318970a3c691638904`  
		Last Modified: Wed, 09 Oct 2024 23:09:38 GMT  
		Size: 1.3 KB (1321 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:8e7e5f55dddac13a735a9430fc1e6ec938d116f8da6843565fad21fa8b9f5c3e`  
		Last Modified: Wed, 09 Oct 2024 23:09:39 GMT  
		Size: 2.2 MB (2203930 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:699dd4d1addf676e991ccf8292f494dd7d369e325134e4b193f23c33f416e071`  
		Last Modified: Wed, 09 Oct 2024 23:09:38 GMT  
		Size: 1.3 KB (1343 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:0668aaf51725a75612b05795b9c3a6035749cb848b2914680b514b253fa7f196`  
		Last Modified: Wed, 09 Oct 2024 23:09:39 GMT  
		Size: 7.7 MB (7686065 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:a79225f58447aadd6d3a777b396406eeb025f542cfd091239dad1fa496bdb248`  
		Last Modified: Wed, 09 Oct 2024 23:09:37 GMT  
		Size: 370.4 KB (370371 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:2ed3a87823c4380f9823378db2567bec2ba101a7e3d8d77fc4d8c275cb6c78b7`  
		Last Modified: Wed, 09 Oct 2024 23:09:37 GMT  
		Size: 1.3 KB (1286 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:91091c236f29893362b0f0f5978cc8612303b762fc3f8ababe126a4ffe38801f`  
		Last Modified: Wed, 09 Oct 2024 23:09:37 GMT  
		Size: 382.7 KB (382723 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:b15c510c644815a12f12560e63c7b961664fd5778a1c1b9a2cfb3a851bdba94a`  
		Last Modified: Wed, 09 Oct 2024 23:09:37 GMT  
		Size: 401.8 KB (401754 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:84d45a5aabcdeb2a9ed9be35388051b908de7096d3e66112eef9fa6968829936`  
		Last Modified: Wed, 09 Oct 2024 23:09:37 GMT  
		Size: 1.3 KB (1297 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip

### `haxe:4.1.5` - windows version 10.0.17763.6414; amd64

```console
$ docker pull haxe@sha256:9d406a03d6d785a144e49711fd145bd315ad09861c36edb1e0bf3de5631f5570
```

-	Docker Version: 26.1.3
-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **1.9 GB (1926431125 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:a27009ed2435e784ea62b73b62077f8b9a912952260681bb5afab6ab9285c33c`
-	Default Command: `["haxe"]`
-	`SHELL`: `["powershell","-Command","$ErrorActionPreference = 'Stop';"]`

```dockerfile
# Fri, 06 Sep 2024 01:15:31 GMT
RUN Apply image 10.0.17763.6293
# Fri, 04 Oct 2024 21:48:44 GMT
RUN Install update 10.0.17763.6414
# Wed, 09 Oct 2024 23:01:54 GMT
SHELL [powershell -Command $ErrorActionPreference = 'Stop';]
# Wed, 09 Oct 2024 23:01:55 GMT
ENV HAXETOOLKIT_PATH=C:\HaxeToolkit
# Wed, 09 Oct 2024 23:01:56 GMT
ENV NEKOPATH=C:\HaxeToolkit\neko
# Wed, 09 Oct 2024 23:01:57 GMT
ENV HAXEPATH=C:\HaxeToolkit\haxe
# Wed, 09 Oct 2024 23:01:57 GMT
ENV HAXE_STD_PATH=C:\HaxeToolkit\haxe\std
# Wed, 09 Oct 2024 23:01:58 GMT
ENV HAXELIB_PATH=C:\HaxeToolkit\haxe\lib
# Wed, 09 Oct 2024 23:02:36 GMT
RUN $newPath = ('{0};{1};{2}' -f $env:HAXEPATH, $env:NEKOPATH, $env:PATH); 	Write-Host ('Updating PATH: {0}' -f $newPath); 	[Environment]::SetEnvironmentVariable('PATH', $newPath, [EnvironmentVariableTarget]::Machine);
# Wed, 09 Oct 2024 23:03:06 GMT
RUN $url = 'https://download.microsoft.com/download/0/5/6/056dcda9-d667-4e27-8001-8a0c6971d6b1/vcredist_x86.exe'; 	Write-Host ('Downloading {0} ...' -f $url); 	[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; 	Invoke-WebRequest -Uri $url -OutFile 'vcredist_x86.exe'; 		Write-Host 'Verifying sha256 (89f4e593ea5541d1c53f983923124f9fd061a1c0c967339109e375c661573c17) ...'; 	if ((Get-FileHash vcredist_x86.exe -Algorithm sha256).Hash -ne '89f4e593ea5541d1c53f983923124f9fd061a1c0c967339109e375c661573c17') { 		Write-Host 'FAILED!'; 		exit 1; 	}; 		Write-Host 'Installing ...'; 	Start-Process -FilePath "vcredist_x86.exe" -ArgumentList "/Q" -Wait; 		Write-Host 'Removing installer...'; 	Remove-Item .\vcredist_x86.exe; 		Write-Host 'Complete.';
# Wed, 09 Oct 2024 23:03:12 GMT
RUN New-Item -ItemType directory -Path $env:HAXETOOLKIT_PATH;
# Wed, 09 Oct 2024 23:03:13 GMT
ENV NEKO_VERSION=2.3.0
# Wed, 09 Oct 2024 23:03:23 GMT
RUN $url = 'https://github.com/HaxeFoundation/neko/releases/download/v2-3-0/neko-2.3.0-win64.zip'; 	Write-Host ('Downloading {0} ...' -f $url); 	[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; 	Invoke-WebRequest -Uri $url -OutFile 'neko.zip'; 		Write-Host 'Verifying sha256 (d09fdf362cd2e3274f6c8528be7211663260c3a5323ce893b7637c2818995f0b) ...'; 	if ((Get-FileHash neko.zip -Algorithm sha256).Hash -ne 'd09fdf362cd2e3274f6c8528be7211663260c3a5323ce893b7637c2818995f0b') { 		Write-Host 'FAILED!'; 		exit 1; 	}; 		Write-Host 'Expanding ...'; 	New-Item -ItemType directory -Path tmp; 	Expand-Archive -Path neko.zip -DestinationPath tmp; 	if (Test-Path tmp\neko.exe) { Move-Item tmp $env:NEKOPATH } 	else { Move-Item (Resolve-Path tmp\neko* | Select -ExpandProperty Path) $env:NEKOPATH }; 		Write-Host 'Removing ...'; 	Remove-Item -Path neko.zip, tmp -Force -Recurse -ErrorAction Ignore; 		Write-Host 'Verifying install ...'; 	Write-Host '  neko -version'; neko -version; 		Write-Host 'Complete.';
# Wed, 09 Oct 2024 23:03:24 GMT
ENV HAXE_VERSION=4.1.5
# Wed, 09 Oct 2024 23:04:12 GMT
RUN $url = 'https://github.com/HaxeFoundation/haxe/releases/download/4.1.5/haxe-4.1.5-win64.zip'; 	Write-Host ('Downloading {0} ...' -f $url); 	[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; 	Invoke-WebRequest -Uri $url -OutFile haxe.zip; 		Write-Host 'Verifying sha256 (ce4134cdf49814f8f8694648408d006116bd171b957a37be74c79cf403db9633) ...'; 	if ((Get-FileHash haxe.zip -Algorithm sha256).Hash -ne 'ce4134cdf49814f8f8694648408d006116bd171b957a37be74c79cf403db9633') { 		Write-Host 'FAILED!'; 		exit 1; 	}; 		Write-Host 'Expanding ...'; 	New-Item -ItemType directory -Path tmp; 	Expand-Archive -Path haxe.zip -DestinationPath tmp; 	if (Test-Path tmp\haxe.exe) { Move-Item tmp $env:HAXEPATH } 	else { Move-Item (Resolve-Path tmp\haxe* | Select -ExpandProperty Path) $env:HAXEPATH }; 		Write-Host 'Removing ...'; 	Remove-Item -Path haxe.zip, tmp -Force -Recurse -ErrorAction Ignore; 		Write-Host 'Verifying install ...'; 	Write-Host '  haxe -version'; haxe -version; 	Write-Host '  haxelib version'; haxelib version; 		Write-Host 'Complete.';
# Wed, 09 Oct 2024 23:04:19 GMT
RUN New-Item -ItemType directory -Path $env:HAXELIB_PATH;
# Wed, 09 Oct 2024 23:04:19 GMT
ENV HOMEDRIVE=C:
# Wed, 09 Oct 2024 23:04:26 GMT
RUN $newPath = ('{0}\Users\{1}' -f $env:HOMEDRIVE, $env:USERNAME); 	Write-Host ('Updating HOMEPATH: {0}' -f $newPath); 	[Environment]::SetEnvironmentVariable('HOMEPATH', $newPath, [EnvironmentVariableTarget]::Machine);
# Wed, 09 Oct 2024 23:04:34 GMT
RUN (New-Object System.Net.WebClient).DownloadString('https://lib.haxe.org/p/hxcpp/4.2.1/download/') >$null
# Wed, 09 Oct 2024 23:04:34 GMT
CMD ["haxe"]
```

-	Layers:
	-	`sha256:803f4a9590cb9c635813cbd0ee89190f92d5fe4c7589711cf468879e42ce02ba`  
		Last Modified: Tue, 10 Sep 2024 17:55:31 GMT  
		Size: 1.7 GB (1720268357 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:eec1ab8e4a3936959c2381d3aaa9aaf9caf01f82fb701f2b4c3cc3dbf6d035dd`  
		Last Modified: Tue, 08 Oct 2024 17:36:07 GMT  
		Size: 181.6 MB (181556913 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:c135a1ca60ee29751c6af1619500007203249e763f12a2f4b561afb2fbc2c776`  
		Last Modified: Wed, 09 Oct 2024 23:04:45 GMT  
		Size: 1.3 KB (1303 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:64c4a604d2fdcedddf3073e15f2a43189b8a58c96b1d703447b156ce5ce649d9`  
		Last Modified: Wed, 09 Oct 2024 23:04:45 GMT  
		Size: 1.3 KB (1296 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:2f94b6f10c3d7a607b10b2ed6b213f9c3795c52ea166a4ef73e5f44e0ac6f557`  
		Last Modified: Wed, 09 Oct 2024 23:04:45 GMT  
		Size: 1.3 KB (1295 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:b51e2b3ce2ffbd1dfcf99ce2de4dd546f2d75d48625031416d29fe33c8235fb8`  
		Last Modified: Wed, 09 Oct 2024 23:04:44 GMT  
		Size: 1.3 KB (1291 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:2fefa3c59c5b07f24d16ef622b43097ad7729d28bad1b28dc0ebd07c7614ac0c`  
		Last Modified: Wed, 09 Oct 2024 23:04:43 GMT  
		Size: 1.3 KB (1301 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:12b4f2af77d1ebe544eae48ca97f78bfdb53a18b0b758ee5ab4d1eb989c125df`  
		Last Modified: Wed, 09 Oct 2024 23:04:43 GMT  
		Size: 1.3 KB (1296 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:5c41db967a3283c525cd1e5e5cd60a736fdb5db76f2a0dee87b19c643ea40239`  
		Last Modified: Wed, 09 Oct 2024 23:04:43 GMT  
		Size: 463.5 KB (463452 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:6a851dd9b45c77906ec016f24ed4b921065844cd3ab804c2f6e83b729cd62c72`  
		Last Modified: Wed, 09 Oct 2024 23:04:43 GMT  
		Size: 12.9 MB (12943926 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:f63ceb66a9ef3d1e0e43311244d7a51b41b27df70f260b39a0ca6adc757b2b45`  
		Last Modified: Wed, 09 Oct 2024 23:04:41 GMT  
		Size: 341.9 KB (341913 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:af8cf32a2fc4a7fc8a9423c0bdb879ad2733e47cbd43595e9e9736014e061fb4`  
		Last Modified: Wed, 09 Oct 2024 23:04:41 GMT  
		Size: 1.3 KB (1290 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:17876a2b081c782a789d0b1b43b26af08ecd28ff6ae39524deda18c1dc00f79e`  
		Last Modified: Wed, 09 Oct 2024 23:04:41 GMT  
		Size: 2.2 MB (2170103 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:e82e5adb3bafe2d7be7ad49dad1f438640ee376754c5c044618534bab825d481`  
		Last Modified: Wed, 09 Oct 2024 23:04:40 GMT  
		Size: 1.3 KB (1293 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:a0cd9f43f56403823b8533b946b2dbf639a2b849b7657683122f692459dd4db4`  
		Last Modified: Wed, 09 Oct 2024 23:04:42 GMT  
		Size: 7.6 MB (7643154 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:152267863748a7c9c5b7a50386daaa349c14a89a0a9af51ca03492bc407fa871`  
		Last Modified: Wed, 09 Oct 2024 23:04:39 GMT  
		Size: 335.3 KB (335305 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:433eb943289a933cfd3146cf1712628b89912779be9bfc5ecd059b13ea78996a`  
		Last Modified: Wed, 09 Oct 2024 23:04:38 GMT  
		Size: 1.3 KB (1297 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:d529963ce93079d35c96361ee1d771992061638edeb14efc5a5a984fe5a5e20f`  
		Last Modified: Wed, 09 Oct 2024 23:04:39 GMT  
		Size: 341.2 KB (341175 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:0fbe3cd64d158afbc0d326608784c973f8faf7535e8ec95c712d3dffa32657fb`  
		Last Modified: Wed, 09 Oct 2024 23:04:39 GMT  
		Size: 353.9 KB (353870 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:a2fd5e662d2e933d4bf433848b57be5727dae1828fd214e434607c6cec25f6d5`  
		Last Modified: Wed, 09 Oct 2024 23:04:38 GMT  
		Size: 1.3 KB (1295 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
