## `haxe:4.1-windowsservercore-1809`

```console
$ docker pull haxe@sha256:6b96db434b149e21cfedd98d7147b6fb8f5be0a1d492dab3ee5644511df15dfe
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.list.v2+json`
-	Platforms: 1
	-	windows version 10.0.17763.6414; amd64

### `haxe:4.1-windowsservercore-1809` - windows version 10.0.17763.6414; amd64

```console
$ docker pull haxe@sha256:9d406a03d6d785a144e49711fd145bd315ad09861c36edb1e0bf3de5631f5570
```

-	Docker Version: 26.1.3
-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **1.9 GB (1926431125 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:a27009ed2435e784ea62b73b62077f8b9a912952260681bb5afab6ab9285c33c`
-	Default Command: `["haxe"]`
-	`SHELL`: `["powershell","-Command","$ErrorActionPreference = 'Stop';"]`

```dockerfile
# Fri, 06 Sep 2024 01:15:31 GMT
RUN Apply image 10.0.17763.6293
# Fri, 04 Oct 2024 21:48:44 GMT
RUN Install update 10.0.17763.6414
# Wed, 09 Oct 2024 23:01:54 GMT
SHELL [powershell -Command $ErrorActionPreference = 'Stop';]
# Wed, 09 Oct 2024 23:01:55 GMT
ENV HAXETOOLKIT_PATH=C:\HaxeToolkit
# Wed, 09 Oct 2024 23:01:56 GMT
ENV NEKOPATH=C:\HaxeToolkit\neko
# Wed, 09 Oct 2024 23:01:57 GMT
ENV HAXEPATH=C:\HaxeToolkit\haxe
# Wed, 09 Oct 2024 23:01:57 GMT
ENV HAXE_STD_PATH=C:\HaxeToolkit\haxe\std
# Wed, 09 Oct 2024 23:01:58 GMT
ENV HAXELIB_PATH=C:\HaxeToolkit\haxe\lib
# Wed, 09 Oct 2024 23:02:36 GMT
RUN $newPath = ('{0};{1};{2}' -f $env:HAXEPATH, $env:NEKOPATH, $env:PATH); 	Write-Host ('Updating PATH: {0}' -f $newPath); 	[Environment]::SetEnvironmentVariable('PATH', $newPath, [EnvironmentVariableTarget]::Machine);
# Wed, 09 Oct 2024 23:03:06 GMT
RUN $url = 'https://download.microsoft.com/download/0/5/6/056dcda9-d667-4e27-8001-8a0c6971d6b1/vcredist_x86.exe'; 	Write-Host ('Downloading {0} ...' -f $url); 	[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; 	Invoke-WebRequest -Uri $url -OutFile 'vcredist_x86.exe'; 		Write-Host 'Verifying sha256 (89f4e593ea5541d1c53f983923124f9fd061a1c0c967339109e375c661573c17) ...'; 	if ((Get-FileHash vcredist_x86.exe -Algorithm sha256).Hash -ne '89f4e593ea5541d1c53f983923124f9fd061a1c0c967339109e375c661573c17') { 		Write-Host 'FAILED!'; 		exit 1; 	}; 		Write-Host 'Installing ...'; 	Start-Process -FilePath "vcredist_x86.exe" -ArgumentList "/Q" -Wait; 		Write-Host 'Removing installer...'; 	Remove-Item .\vcredist_x86.exe; 		Write-Host 'Complete.';
# Wed, 09 Oct 2024 23:03:12 GMT
RUN New-Item -ItemType directory -Path $env:HAXETOOLKIT_PATH;
# Wed, 09 Oct 2024 23:03:13 GMT
ENV NEKO_VERSION=2.3.0
# Wed, 09 Oct 2024 23:03:23 GMT
RUN $url = 'https://github.com/HaxeFoundation/neko/releases/download/v2-3-0/neko-2.3.0-win64.zip'; 	Write-Host ('Downloading {0} ...' -f $url); 	[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; 	Invoke-WebRequest -Uri $url -OutFile 'neko.zip'; 		Write-Host 'Verifying sha256 (d09fdf362cd2e3274f6c8528be7211663260c3a5323ce893b7637c2818995f0b) ...'; 	if ((Get-FileHash neko.zip -Algorithm sha256).Hash -ne 'd09fdf362cd2e3274f6c8528be7211663260c3a5323ce893b7637c2818995f0b') { 		Write-Host 'FAILED!'; 		exit 1; 	}; 		Write-Host 'Expanding ...'; 	New-Item -ItemType directory -Path tmp; 	Expand-Archive -Path neko.zip -DestinationPath tmp; 	if (Test-Path tmp\neko.exe) { Move-Item tmp $env:NEKOPATH } 	else { Move-Item (Resolve-Path tmp\neko* | Select -ExpandProperty Path) $env:NEKOPATH }; 		Write-Host 'Removing ...'; 	Remove-Item -Path neko.zip, tmp -Force -Recurse -ErrorAction Ignore; 		Write-Host 'Verifying install ...'; 	Write-Host '  neko -version'; neko -version; 		Write-Host 'Complete.';
# Wed, 09 Oct 2024 23:03:24 GMT
ENV HAXE_VERSION=4.1.5
# Wed, 09 Oct 2024 23:04:12 GMT
RUN $url = 'https://github.com/HaxeFoundation/haxe/releases/download/4.1.5/haxe-4.1.5-win64.zip'; 	Write-Host ('Downloading {0} ...' -f $url); 	[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; 	Invoke-WebRequest -Uri $url -OutFile haxe.zip; 		Write-Host 'Verifying sha256 (ce4134cdf49814f8f8694648408d006116bd171b957a37be74c79cf403db9633) ...'; 	if ((Get-FileHash haxe.zip -Algorithm sha256).Hash -ne 'ce4134cdf49814f8f8694648408d006116bd171b957a37be74c79cf403db9633') { 		Write-Host 'FAILED!'; 		exit 1; 	}; 		Write-Host 'Expanding ...'; 	New-Item -ItemType directory -Path tmp; 	Expand-Archive -Path haxe.zip -DestinationPath tmp; 	if (Test-Path tmp\haxe.exe) { Move-Item tmp $env:HAXEPATH } 	else { Move-Item (Resolve-Path tmp\haxe* | Select -ExpandProperty Path) $env:HAXEPATH }; 		Write-Host 'Removing ...'; 	Remove-Item -Path haxe.zip, tmp -Force -Recurse -ErrorAction Ignore; 		Write-Host 'Verifying install ...'; 	Write-Host '  haxe -version'; haxe -version; 	Write-Host '  haxelib version'; haxelib version; 		Write-Host 'Complete.';
# Wed, 09 Oct 2024 23:04:19 GMT
RUN New-Item -ItemType directory -Path $env:HAXELIB_PATH;
# Wed, 09 Oct 2024 23:04:19 GMT
ENV HOMEDRIVE=C:
# Wed, 09 Oct 2024 23:04:26 GMT
RUN $newPath = ('{0}\Users\{1}' -f $env:HOMEDRIVE, $env:USERNAME); 	Write-Host ('Updating HOMEPATH: {0}' -f $newPath); 	[Environment]::SetEnvironmentVariable('HOMEPATH', $newPath, [EnvironmentVariableTarget]::Machine);
# Wed, 09 Oct 2024 23:04:34 GMT
RUN (New-Object System.Net.WebClient).DownloadString('https://lib.haxe.org/p/hxcpp/4.2.1/download/') >$null
# Wed, 09 Oct 2024 23:04:34 GMT
CMD ["haxe"]
```

-	Layers:
	-	`sha256:803f4a9590cb9c635813cbd0ee89190f92d5fe4c7589711cf468879e42ce02ba`  
		Last Modified: Tue, 10 Sep 2024 17:55:31 GMT  
		Size: 1.7 GB (1720268357 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:eec1ab8e4a3936959c2381d3aaa9aaf9caf01f82fb701f2b4c3cc3dbf6d035dd`  
		Last Modified: Tue, 08 Oct 2024 17:36:07 GMT  
		Size: 181.6 MB (181556913 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:c135a1ca60ee29751c6af1619500007203249e763f12a2f4b561afb2fbc2c776`  
		Last Modified: Wed, 09 Oct 2024 23:04:45 GMT  
		Size: 1.3 KB (1303 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:64c4a604d2fdcedddf3073e15f2a43189b8a58c96b1d703447b156ce5ce649d9`  
		Last Modified: Wed, 09 Oct 2024 23:04:45 GMT  
		Size: 1.3 KB (1296 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:2f94b6f10c3d7a607b10b2ed6b213f9c3795c52ea166a4ef73e5f44e0ac6f557`  
		Last Modified: Wed, 09 Oct 2024 23:04:45 GMT  
		Size: 1.3 KB (1295 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:b51e2b3ce2ffbd1dfcf99ce2de4dd546f2d75d48625031416d29fe33c8235fb8`  
		Last Modified: Wed, 09 Oct 2024 23:04:44 GMT  
		Size: 1.3 KB (1291 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:2fefa3c59c5b07f24d16ef622b43097ad7729d28bad1b28dc0ebd07c7614ac0c`  
		Last Modified: Wed, 09 Oct 2024 23:04:43 GMT  
		Size: 1.3 KB (1301 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:12b4f2af77d1ebe544eae48ca97f78bfdb53a18b0b758ee5ab4d1eb989c125df`  
		Last Modified: Wed, 09 Oct 2024 23:04:43 GMT  
		Size: 1.3 KB (1296 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:5c41db967a3283c525cd1e5e5cd60a736fdb5db76f2a0dee87b19c643ea40239`  
		Last Modified: Wed, 09 Oct 2024 23:04:43 GMT  
		Size: 463.5 KB (463452 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:6a851dd9b45c77906ec016f24ed4b921065844cd3ab804c2f6e83b729cd62c72`  
		Last Modified: Wed, 09 Oct 2024 23:04:43 GMT  
		Size: 12.9 MB (12943926 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:f63ceb66a9ef3d1e0e43311244d7a51b41b27df70f260b39a0ca6adc757b2b45`  
		Last Modified: Wed, 09 Oct 2024 23:04:41 GMT  
		Size: 341.9 KB (341913 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:af8cf32a2fc4a7fc8a9423c0bdb879ad2733e47cbd43595e9e9736014e061fb4`  
		Last Modified: Wed, 09 Oct 2024 23:04:41 GMT  
		Size: 1.3 KB (1290 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:17876a2b081c782a789d0b1b43b26af08ecd28ff6ae39524deda18c1dc00f79e`  
		Last Modified: Wed, 09 Oct 2024 23:04:41 GMT  
		Size: 2.2 MB (2170103 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:e82e5adb3bafe2d7be7ad49dad1f438640ee376754c5c044618534bab825d481`  
		Last Modified: Wed, 09 Oct 2024 23:04:40 GMT  
		Size: 1.3 KB (1293 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:a0cd9f43f56403823b8533b946b2dbf639a2b849b7657683122f692459dd4db4`  
		Last Modified: Wed, 09 Oct 2024 23:04:42 GMT  
		Size: 7.6 MB (7643154 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:152267863748a7c9c5b7a50386daaa349c14a89a0a9af51ca03492bc407fa871`  
		Last Modified: Wed, 09 Oct 2024 23:04:39 GMT  
		Size: 335.3 KB (335305 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:433eb943289a933cfd3146cf1712628b89912779be9bfc5ecd059b13ea78996a`  
		Last Modified: Wed, 09 Oct 2024 23:04:38 GMT  
		Size: 1.3 KB (1297 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:d529963ce93079d35c96361ee1d771992061638edeb14efc5a5a984fe5a5e20f`  
		Last Modified: Wed, 09 Oct 2024 23:04:39 GMT  
		Size: 341.2 KB (341175 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:0fbe3cd64d158afbc0d326608784c973f8faf7535e8ec95c712d3dffa32657fb`  
		Last Modified: Wed, 09 Oct 2024 23:04:39 GMT  
		Size: 353.9 KB (353870 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:a2fd5e662d2e933d4bf433848b57be5727dae1828fd214e434607c6cec25f6d5`  
		Last Modified: Wed, 09 Oct 2024 23:04:38 GMT  
		Size: 1.3 KB (1295 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
