## `haxe:4.0-windowsservercore-ltsc2022`

```console
$ docker pull haxe@sha256:1fcbdb39b5eaa13259f2ddb52dae023c9c5b1a6f8742d8780ab77299bb308cb5
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.list.v2+json`
-	Platforms: 1
	-	windows version 10.0.20348.2762; amd64

### `haxe:4.0-windowsservercore-ltsc2022` - windows version 10.0.20348.2762; amd64

```console
$ docker pull haxe@sha256:65c5bd413d23cd8dcf5f9f7cd5b57b708ce1e55006193fb3bd07e2bf3be92f4a
```

-	Docker Version: 26.1.3
-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **1.8 GB (1823738270 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:f68f0fb83f4ff9905d40ea582ced16281e899de99f58cb2c19257abf52d01b32`
-	Default Command: `["haxe"]`
-	`SHELL`: `["powershell","-Command","$ErrorActionPreference = 'Stop';"]`

```dockerfile
# Fri, 06 Sep 2024 00:01:38 GMT
RUN Apply image 10.0.20348.2700
# Sun, 06 Oct 2024 04:56:48 GMT
RUN Install update 10.0.20348.2762
# Wed, 09 Oct 2024 23:08:20 GMT
SHELL [powershell -Command $ErrorActionPreference = 'Stop';]
# Wed, 09 Oct 2024 23:08:23 GMT
ENV HAXETOOLKIT_PATH=C:\HaxeToolkit
# Wed, 09 Oct 2024 23:08:24 GMT
ENV NEKOPATH=C:\HaxeToolkit\neko
# Wed, 09 Oct 2024 23:08:24 GMT
ENV HAXEPATH=C:\HaxeToolkit\haxe
# Wed, 09 Oct 2024 23:08:25 GMT
ENV HAXE_STD_PATH=C:\HaxeToolkit\haxe\std
# Wed, 09 Oct 2024 23:08:25 GMT
ENV HAXELIB_PATH=C:\HaxeToolkit\haxe\lib
# Wed, 09 Oct 2024 23:08:43 GMT
RUN $newPath = ('{0};{1};{2}' -f $env:HAXEPATH, $env:NEKOPATH, $env:PATH); 	Write-Host ('Updating PATH: {0}' -f $newPath); 	[Environment]::SetEnvironmentVariable('PATH', $newPath, [EnvironmentVariableTarget]::Machine);
# Wed, 09 Oct 2024 23:09:17 GMT
RUN $url = 'https://download.microsoft.com/download/0/5/6/056dcda9-d667-4e27-8001-8a0c6971d6b1/vcredist_x86.exe'; 	Write-Host ('Downloading {0} ...' -f $url); 	[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; 	Invoke-WebRequest -Uri $url -OutFile 'vcredist_x86.exe'; 		Write-Host 'Verifying sha256 (89f4e593ea5541d1c53f983923124f9fd061a1c0c967339109e375c661573c17) ...'; 	if ((Get-FileHash vcredist_x86.exe -Algorithm sha256).Hash -ne '89f4e593ea5541d1c53f983923124f9fd061a1c0c967339109e375c661573c17') { 		Write-Host 'FAILED!'; 		exit 1; 	}; 		Write-Host 'Installing ...'; 	Start-Process -FilePath "vcredist_x86.exe" -ArgumentList "/Q" -Wait; 		Write-Host 'Removing installer...'; 	Remove-Item .\vcredist_x86.exe; 		Write-Host 'Complete.';
# Wed, 09 Oct 2024 23:09:23 GMT
RUN New-Item -ItemType directory -Path $env:HAXETOOLKIT_PATH;
# Wed, 09 Oct 2024 23:09:23 GMT
ENV NEKO_VERSION=2.3.0
# Wed, 09 Oct 2024 23:09:32 GMT
RUN $url = 'https://github.com/HaxeFoundation/neko/releases/download/v2-3-0/neko-2.3.0-win64.zip'; 	Write-Host ('Downloading {0} ...' -f $url); 	[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; 	Invoke-WebRequest -Uri $url -OutFile 'neko.zip'; 		Write-Host 'Verifying sha256 (d09fdf362cd2e3274f6c8528be7211663260c3a5323ce893b7637c2818995f0b) ...'; 	if ((Get-FileHash neko.zip -Algorithm sha256).Hash -ne 'd09fdf362cd2e3274f6c8528be7211663260c3a5323ce893b7637c2818995f0b') { 		Write-Host 'FAILED!'; 		exit 1; 	}; 		Write-Host 'Expanding ...'; 	New-Item -ItemType directory -Path tmp; 	Expand-Archive -Path neko.zip -DestinationPath tmp; 	if (Test-Path tmp\neko.exe) { Move-Item tmp $env:NEKOPATH } 	else { Move-Item (Resolve-Path tmp\neko* | Select -ExpandProperty Path) $env:NEKOPATH }; 		Write-Host 'Removing ...'; 	Remove-Item -Path neko.zip, tmp -Force -Recurse -ErrorAction Ignore; 		Write-Host 'Verifying install ...'; 	Write-Host '  neko -version'; neko -version; 		Write-Host 'Complete.';
# Wed, 09 Oct 2024 23:09:32 GMT
ENV HAXE_VERSION=4.0.5
# Wed, 09 Oct 2024 23:10:18 GMT
RUN $url = 'https://github.com/HaxeFoundation/haxe/releases/download/4.0.5/haxe-4.0.5-win64.zip'; 	Write-Host ('Downloading {0} ...' -f $url); 	[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; 	Invoke-WebRequest -Uri $url -OutFile haxe.zip; 		Write-Host 'Verifying sha256 (93130ae2b1083efbcd9b8911afe2ba00d5af995f016149fd7ec629fa439c6120) ...'; 	if ((Get-FileHash haxe.zip -Algorithm sha256).Hash -ne '93130ae2b1083efbcd9b8911afe2ba00d5af995f016149fd7ec629fa439c6120') { 		Write-Host 'FAILED!'; 		exit 1; 	}; 		Write-Host 'Expanding ...'; 	New-Item -ItemType directory -Path tmp; 	Expand-Archive -Path haxe.zip -DestinationPath tmp; 	if (Test-Path tmp\haxe.exe) { Move-Item tmp $env:HAXEPATH } 	else { Move-Item (Resolve-Path tmp\haxe* | Select -ExpandProperty Path) $env:HAXEPATH }; 		Write-Host 'Removing ...'; 	Remove-Item -Path haxe.zip, tmp -Force -Recurse -ErrorAction Ignore; 		Write-Host 'Verifying install ...'; 	Write-Host '  haxe -version'; haxe -version; 	Write-Host '  haxelib version'; haxelib version; 		Write-Host 'Complete.';
# Wed, 09 Oct 2024 23:10:24 GMT
RUN New-Item -ItemType directory -Path $env:HAXELIB_PATH;
# Wed, 09 Oct 2024 23:10:24 GMT
ENV HOMEDRIVE=C:
# Wed, 09 Oct 2024 23:10:29 GMT
RUN $newPath = ('{0}\Users\{1}' -f $env:HOMEDRIVE, $env:USERNAME); 	Write-Host ('Updating HOMEPATH: {0}' -f $newPath); 	[Environment]::SetEnvironmentVariable('HOMEPATH', $newPath, [EnvironmentVariableTarget]::Machine);
# Wed, 09 Oct 2024 23:10:35 GMT
RUN (New-Object System.Net.WebClient).DownloadString('https://lib.haxe.org/p/hxcpp/4.2.1/download/') >$null
# Wed, 09 Oct 2024 23:10:36 GMT
CMD ["haxe"]
```

-	Layers:
	-	`sha256:2534953f34d35976fc44cd67bfdd39fdcd9e2eaae57ada0be53d5fb936cd3a0b`  
		Last Modified: Tue, 10 Sep 2024 17:49:01 GMT  
		Size: 1.5 GB (1462192413 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:3445b497121718058765c341117a0c1522c51cd65bec8c517981a745ff91f0bf`  
		Last Modified: Tue, 08 Oct 2024 17:56:28 GMT  
		Size: 337.1 MB (337149137 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:d4a6d08ad3ea99b4712ac55d8eda2e0760ddda42247779460e720a25acf70c2c`  
		Last Modified: Wed, 09 Oct 2024 23:10:41 GMT  
		Size: 1.3 KB (1313 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:adb6536914bc846251c3cccc06b3e0ecf6d94c334c0346361d5997246eae6e61`  
		Last Modified: Wed, 09 Oct 2024 23:10:41 GMT  
		Size: 1.3 KB (1283 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:bdfe874c2222946a0410373e036a528f47e1a0532e84ff1ea54cb62bae29d92a`  
		Last Modified: Wed, 09 Oct 2024 23:10:41 GMT  
		Size: 1.3 KB (1277 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:aef822393b08229d862d9464bd44d32b8c7d0ea0058e99c83bb8fdc57eba3093`  
		Last Modified: Wed, 09 Oct 2024 23:10:41 GMT  
		Size: 1.3 KB (1278 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:0808c036d14df8afb44e02b3b6588aa7e471bbcb079b1bd66f1569991f96fa10`  
		Last Modified: Wed, 09 Oct 2024 23:10:40 GMT  
		Size: 1.3 KB (1282 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:caa142f8f29050279297ba9db1288edb963b835c5b0c65fe3fbfa1b3e5b05856`  
		Last Modified: Wed, 09 Oct 2024 23:10:40 GMT  
		Size: 1.3 KB (1284 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:60487f4ed5daa1326b161a79c77f0f5a51f39fe402b6914cd1924af6909b6967`  
		Last Modified: Wed, 09 Oct 2024 23:10:40 GMT  
		Size: 488.8 KB (488823 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:77e19383e71f65bc55e3d2825e49fb107d13cfb42f99cd59d1a33d4b8d740abc`  
		Last Modified: Wed, 09 Oct 2024 23:10:40 GMT  
		Size: 12.9 MB (12948765 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:1a403cc0a8a48a00187e5d657bc32fce27ac298344fdb93716791a3a5f9b005d`  
		Last Modified: Wed, 09 Oct 2024 23:10:39 GMT  
		Size: 377.1 KB (377067 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:7c40b589f2fe9b23706a846f106bc711cbeb01d2bd594dfcc813e1c1e72ad653`  
		Last Modified: Wed, 09 Oct 2024 23:10:39 GMT  
		Size: 1.3 KB (1282 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:4d94062b707344f150bbd47c12e83c95549876e1b8a943207b818bec18dadfe7`  
		Last Modified: Wed, 09 Oct 2024 23:10:39 GMT  
		Size: 2.2 MB (2210501 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:50700da1b16fc86208872c2e629e933e4aaec8da17ba023c2d1a613d8e275fbf`  
		Last Modified: Wed, 09 Oct 2024 23:10:39 GMT  
		Size: 1.3 KB (1286 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:e76888a8b1a72798fdfe6069f5b0c2193f41abedfc26a16793f8432f101e1765`  
		Last Modified: Wed, 09 Oct 2024 23:10:40 GMT  
		Size: 7.2 MB (7185353 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:96020bce9cab104567aac2a95570406592e92658f72e17cbcac4aaf4592d6fbf`  
		Last Modified: Wed, 09 Oct 2024 23:10:38 GMT  
		Size: 377.8 KB (377792 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:079a74901125e068edddb098c578c87588c34fe225a43ae5b4c800d68db0f37f`  
		Last Modified: Wed, 09 Oct 2024 23:10:38 GMT  
		Size: 1.3 KB (1279 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:fcdf0b344fefce0b7791280bab454823c2a88640dd0f52262c4ae075c599e817`  
		Last Modified: Wed, 09 Oct 2024 23:10:38 GMT  
		Size: 388.4 KB (388362 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:be7f7a6a9d37e5bb04f3971e810e47db5b07d7df7a3c2db6e81d9442aef3b883`  
		Last Modified: Wed, 09 Oct 2024 23:10:38 GMT  
		Size: 407.2 KB (407230 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
	-	`sha256:f501281a1f1e286586e2d5a6380f9d8b7dd08e3de2f4089cac61aac49721b2e3`  
		Last Modified: Wed, 09 Oct 2024 23:10:38 GMT  
		Size: 1.3 KB (1263 bytes)  
		MIME: application/vnd.docker.image.rootfs.diff.tar.gzip
