## `haproxy:2.8-alpine`

```console
$ docker pull haproxy@sha256:8cf0fc11cb6bdcc03f71e26a3a2e6e9736f28ce2934155ff1b38434405c86a36
```

-	Manifest MIME: `application/vnd.oci.image.index.v1+json`
-	Platforms: 16
	-	linux; amd64
	-	unknown; unknown
	-	linux; arm variant v6
	-	unknown; unknown
	-	linux; arm variant v7
	-	unknown; unknown
	-	linux; arm64 variant v8
	-	unknown; unknown
	-	linux; 386
	-	unknown; unknown
	-	linux; ppc64le
	-	unknown; unknown
	-	linux; riscv64
	-	unknown; unknown
	-	linux; s390x
	-	unknown; unknown

### `haproxy:2.8-alpine` - linux; amd64

```console
$ docker pull haproxy@sha256:0a7705156a543d83fe1ddc15075713933e7290c77a773ec1315a7bf90e7624c7
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **12.2 MB (12218610 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:fcc690255bcd5774a355b78fe18e20af55f0e0d083bf853322ba8958ee0741a5`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["haproxy","-f","\/usr\/local\/etc\/haproxy\/haproxy.cfg"]`

```dockerfile
# Fri, 06 Sep 2024 22:20:07 GMT
ADD file:5758b97d8301c84a204a6e516241275d785a7cade40b2fb99f01fe122482e283 in / 
# Fri, 06 Sep 2024 22:20:07 GMT
CMD ["/bin/sh"]
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 	apk add --no-cache 		ca-certificates 	; # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 	addgroup --gid 99 --system haproxy; 	adduser 		--disabled-password 		--home /var/lib/haproxy 		--ingroup haproxy 		--no-create-home 		--system 		--uid 99 		haproxy 	; 	mkdir /var/lib/haproxy; 	chown haproxy:haproxy /var/lib/haproxy # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_VERSION=2.8.11
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_URL=https://www.haproxy.org/download/2.8/src/haproxy-2.8.11.tar.gz
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_SHA256=39de529ae0283416acb5477197ece17ea05b81f467bec5a6ac73cbad7dd536a8
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 		apk add --no-cache --virtual .build-deps 		gcc 		libc-dev 		linux-headers 		lua5.3-dev 		make 		openssl 		openssl-dev 		pcre2-dev 		readline-dev 		tar 	; 		wget -O haproxy.tar.gz "$HAPROXY_URL"; 	echo "$HAPROXY_SHA256 *haproxy.tar.gz" | sha256sum -c; 	mkdir -p /usr/src/haproxy; 	tar -xzf haproxy.tar.gz -C /usr/src/haproxy --strip-components=1; 	rm haproxy.tar.gz; 		makeOpts=' 		TARGET=linux-musl 		USE_GETADDRINFO=1 		USE_LUA=1 LUA_INC=/usr/include/lua5.3 LUA_LIB=/usr/lib/lua5.3 		USE_OPENSSL=1 		USE_PCRE2=1 USE_PCRE2_JIT=1 		USE_PROMEX=1 				EXTRA_OBJS=" 		" 	'; 		nproc="$(getconf _NPROCESSORS_ONLN)"; 	eval "make -C /usr/src/haproxy -j '$nproc' all $makeOpts"; 	eval "make -C /usr/src/haproxy install-bin $makeOpts"; 		mkdir -p /usr/local/etc/haproxy; 	cp -R /usr/src/haproxy/examples/errorfiles /usr/local/etc/haproxy/errors; 	rm -rf /usr/src/haproxy; 		runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)"; 	apk add --no-network --virtual .haproxy-rundeps $runDeps; 	apk del --no-network .build-deps; 		haproxy -v # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
STOPSIGNAL SIGUSR1
# Thu, 19 Sep 2024 17:15:38 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Thu, 19 Sep 2024 17:15:38 GMT
USER haproxy
# Thu, 19 Sep 2024 17:15:38 GMT
WORKDIR /var/lib/haproxy
# Thu, 19 Sep 2024 17:15:38 GMT
CMD ["haproxy" "-f" "/usr/local/etc/haproxy/haproxy.cfg"]
```

-	Layers:
	-	`sha256:43c4264eed91be63b206e17d93e75256a6097070ce643c5e8f0379998b44f170`  
		Last Modified: Fri, 06 Sep 2024 22:20:39 GMT  
		Size: 3.6 MB (3623807 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:2ebbb1ef55f20f04f431f4a7f999b2e36c62eef613744b3f130ff40bc2f638ad`  
		Last Modified: Thu, 19 Sep 2024 18:58:06 GMT  
		Size: 290.9 KB (290894 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:81eebde8edb339100f83d1f0f1703fec4d899dda7245028ffe182690f1cea305`  
		Last Modified: Thu, 19 Sep 2024 18:58:06 GMT  
		Size: 978.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:4cb9430690a52a1049c3e90b67b97564caa357ec6b2e98f017354dc483da524f`  
		Last Modified: Thu, 19 Sep 2024 18:58:06 GMT  
		Size: 8.3 MB (8302453 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:6e10fe399eded4ddc512aa558d6309bb86fa81b42adbd9ffc3eb4ddb5aeb351b`  
		Last Modified: Thu, 19 Sep 2024 18:58:06 GMT  
		Size: 446.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:4f4fb700ef54461cfa02571ae0db9a0dc1e0cdb5577484a6d75e68dc38e8acc1`  
		Last Modified: Tue, 07 Mar 2017 15:01:14 GMT  
		Size: 32.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `haproxy:2.8-alpine` - unknown; unknown

```console
$ docker pull haproxy@sha256:58b0ebf6a4ea65638d3e3c72977da73c91f470b1a85da43c2380589b8cd6d56f
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **21.9 KB (21931 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:6ed98205c9c7bacfe9d3dd071e8b991946376ea404616c6170ce40f61093006e`

```dockerfile
```

-	Layers:
	-	`sha256:4d23d5141fad81e05951358f4826fdf2dfb1ae57e6442f40ed07bb6630f86430`  
		Last Modified: Thu, 19 Sep 2024 18:58:06 GMT  
		Size: 2.3 KB (2303 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:8870196f7e8bcc1d460515ada13df983fdbb29d5d2bb282cec29d42eea5a254d`  
		Last Modified: Thu, 19 Sep 2024 18:58:06 GMT  
		Size: 19.6 KB (19628 bytes)  
		MIME: application/vnd.in-toto+json

### `haproxy:2.8-alpine` - linux; arm variant v6

```console
$ docker pull haproxy@sha256:061c299a05fbcf86aa246b49ef61d7f7c8176b46953e4c5131522c1f83ac290b
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **11.9 MB (11926082 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:af920e23a7e2096435717727705144b196844ed8e77562cc5e12e6215a5408e3`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["haproxy","-f","\/usr\/local\/etc\/haproxy\/haproxy.cfg"]`

```dockerfile
# Fri, 06 Sep 2024 22:49:23 GMT
ADD file:faa3509308d5524875c6afec4d4d1a357118aa1587e5485eca63c2907b37d968 in / 
# Fri, 06 Sep 2024 22:49:24 GMT
CMD ["/bin/sh"]
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 	apk add --no-cache 		ca-certificates 	; # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 	addgroup --gid 99 --system haproxy; 	adduser 		--disabled-password 		--home /var/lib/haproxy 		--ingroup haproxy 		--no-create-home 		--system 		--uid 99 		haproxy 	; 	mkdir /var/lib/haproxy; 	chown haproxy:haproxy /var/lib/haproxy # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_VERSION=2.8.11
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_URL=https://www.haproxy.org/download/2.8/src/haproxy-2.8.11.tar.gz
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_SHA256=39de529ae0283416acb5477197ece17ea05b81f467bec5a6ac73cbad7dd536a8
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 		apk add --no-cache --virtual .build-deps 		gcc 		libc-dev 		linux-headers 		lua5.3-dev 		make 		openssl 		openssl-dev 		pcre2-dev 		readline-dev 		tar 	; 		wget -O haproxy.tar.gz "$HAPROXY_URL"; 	echo "$HAPROXY_SHA256 *haproxy.tar.gz" | sha256sum -c; 	mkdir -p /usr/src/haproxy; 	tar -xzf haproxy.tar.gz -C /usr/src/haproxy --strip-components=1; 	rm haproxy.tar.gz; 		makeOpts=' 		TARGET=linux-musl 		USE_GETADDRINFO=1 		USE_LUA=1 LUA_INC=/usr/include/lua5.3 LUA_LIB=/usr/lib/lua5.3 		USE_OPENSSL=1 		USE_PCRE2=1 USE_PCRE2_JIT=1 		USE_PROMEX=1 				EXTRA_OBJS=" 		" 	'; 		nproc="$(getconf _NPROCESSORS_ONLN)"; 	eval "make -C /usr/src/haproxy -j '$nproc' all $makeOpts"; 	eval "make -C /usr/src/haproxy install-bin $makeOpts"; 		mkdir -p /usr/local/etc/haproxy; 	cp -R /usr/src/haproxy/examples/errorfiles /usr/local/etc/haproxy/errors; 	rm -rf /usr/src/haproxy; 		runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)"; 	apk add --no-network --virtual .haproxy-rundeps $runDeps; 	apk del --no-network .build-deps; 		haproxy -v # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
STOPSIGNAL SIGUSR1
# Thu, 19 Sep 2024 17:15:38 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Thu, 19 Sep 2024 17:15:38 GMT
USER haproxy
# Thu, 19 Sep 2024 17:15:38 GMT
WORKDIR /var/lib/haproxy
# Thu, 19 Sep 2024 17:15:38 GMT
CMD ["haproxy" "-f" "/usr/local/etc/haproxy/haproxy.cfg"]
```

-	Layers:
	-	`sha256:97964a4b92f04f720ed681b3ec62b071ced94b08b57765c612866e77a71ec087`  
		Last Modified: Fri, 06 Sep 2024 22:49:47 GMT  
		Size: 3.4 MB (3366506 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:63be6539ff607f561058227345573d05f1ac17d535fc57da727a82c8d15f5cfa`  
		Last Modified: Sat, 07 Sep 2024 02:33:05 GMT  
		Size: 291.8 KB (291764 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:4640468ae4017a2fbad0ef7da093746f326843fcce4b7b083ed2ff5847382df1`  
		Last Modified: Sat, 07 Sep 2024 02:33:05 GMT  
		Size: 974.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:0bc8c86c30852e434551344633a6343d8df9a3d33e8fc9fbe1532e0299533fd5`  
		Last Modified: Thu, 19 Sep 2024 19:01:01 GMT  
		Size: 8.3 MB (8266364 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:2209f18524428ad052afb12fe7f005a3aa9524a859e21b314452d76c85bac960`  
		Last Modified: Thu, 19 Sep 2024 19:01:00 GMT  
		Size: 442.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:4f4fb700ef54461cfa02571ae0db9a0dc1e0cdb5577484a6d75e68dc38e8acc1`  
		Last Modified: Tue, 07 Mar 2017 15:01:14 GMT  
		Size: 32.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `haproxy:2.8-alpine` - unknown; unknown

```console
$ docker pull haproxy@sha256:76e983d67fdae6b6e7ce304047625d23776d29fa8d43a2918e71e9f2841b44dc
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **19.5 KB (19504 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:b854cdae2df8ae9e052f10dc86208ea618a5279b08934093c3e7be069c6548c8`

```dockerfile
```

-	Layers:
	-	`sha256:80191c8e2a96e441305077e487fbf7446b6f367e7b0642974b5677f0f864a6e5`  
		Last Modified: Thu, 19 Sep 2024 19:01:00 GMT  
		Size: 19.5 KB (19504 bytes)  
		MIME: application/vnd.in-toto+json

### `haproxy:2.8-alpine` - linux; arm variant v7

```console
$ docker pull haproxy@sha256:4775b32c7d7e52056a2ec85847a09c4acc4f5b9b3a067a3ad0a69fbdb908006a
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **11.5 MB (11525054 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:92d41b824c0c6f801763f1e30a3ea8d92dfb5e8a6255602b87247c67cde56491`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["haproxy","-f","\/usr\/local\/etc\/haproxy\/haproxy.cfg"]`

```dockerfile
# Fri, 06 Sep 2024 22:08:00 GMT
ADD file:8096a7e97160f837a432988b8138ffab07ff212be781f530c8baa2067265d071 in / 
# Fri, 06 Sep 2024 22:08:01 GMT
CMD ["/bin/sh"]
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 	apk add --no-cache 		ca-certificates 	; # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 	addgroup --gid 99 --system haproxy; 	adduser 		--disabled-password 		--home /var/lib/haproxy 		--ingroup haproxy 		--no-create-home 		--system 		--uid 99 		haproxy 	; 	mkdir /var/lib/haproxy; 	chown haproxy:haproxy /var/lib/haproxy # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_VERSION=2.8.11
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_URL=https://www.haproxy.org/download/2.8/src/haproxy-2.8.11.tar.gz
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_SHA256=39de529ae0283416acb5477197ece17ea05b81f467bec5a6ac73cbad7dd536a8
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 		apk add --no-cache --virtual .build-deps 		gcc 		libc-dev 		linux-headers 		lua5.3-dev 		make 		openssl 		openssl-dev 		pcre2-dev 		readline-dev 		tar 	; 		wget -O haproxy.tar.gz "$HAPROXY_URL"; 	echo "$HAPROXY_SHA256 *haproxy.tar.gz" | sha256sum -c; 	mkdir -p /usr/src/haproxy; 	tar -xzf haproxy.tar.gz -C /usr/src/haproxy --strip-components=1; 	rm haproxy.tar.gz; 		makeOpts=' 		TARGET=linux-musl 		USE_GETADDRINFO=1 		USE_LUA=1 LUA_INC=/usr/include/lua5.3 LUA_LIB=/usr/lib/lua5.3 		USE_OPENSSL=1 		USE_PCRE2=1 USE_PCRE2_JIT=1 		USE_PROMEX=1 				EXTRA_OBJS=" 		" 	'; 		nproc="$(getconf _NPROCESSORS_ONLN)"; 	eval "make -C /usr/src/haproxy -j '$nproc' all $makeOpts"; 	eval "make -C /usr/src/haproxy install-bin $makeOpts"; 		mkdir -p /usr/local/etc/haproxy; 	cp -R /usr/src/haproxy/examples/errorfiles /usr/local/etc/haproxy/errors; 	rm -rf /usr/src/haproxy; 		runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)"; 	apk add --no-network --virtual .haproxy-rundeps $runDeps; 	apk del --no-network .build-deps; 		haproxy -v # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
STOPSIGNAL SIGUSR1
# Thu, 19 Sep 2024 17:15:38 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Thu, 19 Sep 2024 17:15:38 GMT
USER haproxy
# Thu, 19 Sep 2024 17:15:38 GMT
WORKDIR /var/lib/haproxy
# Thu, 19 Sep 2024 17:15:38 GMT
CMD ["haproxy" "-f" "/usr/local/etc/haproxy/haproxy.cfg"]
```

-	Layers:
	-	`sha256:da2748c71804914f58a58693c998a4885dd24623380daf301f4a1a88185cb4c8`  
		Last Modified: Fri, 06 Sep 2024 22:08:26 GMT  
		Size: 3.1 MB (3095502 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:cac8d6380b7571bdf381f1ba834d2842c0296c2ae63574c4371a79036983f1ab`  
		Last Modified: Sat, 07 Sep 2024 02:47:05 GMT  
		Size: 291.0 KB (290955 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:0c5fe183482a6c2f85cb5f99122305b70ec7f474125fa7358bc50f5cec57a56f`  
		Last Modified: Sat, 07 Sep 2024 02:47:05 GMT  
		Size: 975.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:13c5c10327dd4d9f0da5d0835ae60ed1d7b3550eb51179a77f250d116056c69c`  
		Last Modified: Thu, 19 Sep 2024 19:06:20 GMT  
		Size: 8.1 MB (8137147 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:a02273ee800279026f30145dc601c3b606f3858dbd98ee42dd53bb5ee9b1d61f`  
		Last Modified: Thu, 19 Sep 2024 19:06:19 GMT  
		Size: 443.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:4f4fb700ef54461cfa02571ae0db9a0dc1e0cdb5577484a6d75e68dc38e8acc1`  
		Last Modified: Tue, 07 Mar 2017 15:01:14 GMT  
		Size: 32.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `haproxy:2.8-alpine` - unknown; unknown

```console
$ docker pull haproxy@sha256:e6a28bac085d4fb68dd626ab4b5039f6d9a896de6128afaa54377fc3523a7347
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **198.5 KB (198540 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:77955c21d47035e75594adae681d4671f5357ab5e0209e0576e904fc240393a2`

```dockerfile
```

-	Layers:
	-	`sha256:dba11cd2ae23015f3f24f278c156aa95d95e26c04f02904533b2cc4b88e9d08d`  
		Last Modified: Thu, 19 Sep 2024 19:06:20 GMT  
		Size: 178.8 KB (178816 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:b420f99bded7c1b2266b38c9e23da66283394c60ca5ee79ce3e678afedfd587f`  
		Last Modified: Thu, 19 Sep 2024 19:06:19 GMT  
		Size: 19.7 KB (19724 bytes)  
		MIME: application/vnd.in-toto+json

### `haproxy:2.8-alpine` - linux; arm64 variant v8

```console
$ docker pull haproxy@sha256:293f16777cb86a7771746bc4eefd2a8eb09b8fedeaabf180245a067f67678b98
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **12.6 MB (12634118 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:33d1eaa630200b6b1aecec551a685505eb89da830f68e2bcfc85f734b135c495`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["haproxy","-f","\/usr\/local\/etc\/haproxy\/haproxy.cfg"]`

```dockerfile
# Fri, 06 Sep 2024 22:44:10 GMT
ADD file:ee5bb8409915b11413f44cce4c22fed658aba4fb078a448e08dd4ac9a23581f2 in / 
# Fri, 06 Sep 2024 22:44:11 GMT
CMD ["/bin/sh"]
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 	apk add --no-cache 		ca-certificates 	; # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 	addgroup --gid 99 --system haproxy; 	adduser 		--disabled-password 		--home /var/lib/haproxy 		--ingroup haproxy 		--no-create-home 		--system 		--uid 99 		haproxy 	; 	mkdir /var/lib/haproxy; 	chown haproxy:haproxy /var/lib/haproxy # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_VERSION=2.8.11
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_URL=https://www.haproxy.org/download/2.8/src/haproxy-2.8.11.tar.gz
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_SHA256=39de529ae0283416acb5477197ece17ea05b81f467bec5a6ac73cbad7dd536a8
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 		apk add --no-cache --virtual .build-deps 		gcc 		libc-dev 		linux-headers 		lua5.3-dev 		make 		openssl 		openssl-dev 		pcre2-dev 		readline-dev 		tar 	; 		wget -O haproxy.tar.gz "$HAPROXY_URL"; 	echo "$HAPROXY_SHA256 *haproxy.tar.gz" | sha256sum -c; 	mkdir -p /usr/src/haproxy; 	tar -xzf haproxy.tar.gz -C /usr/src/haproxy --strip-components=1; 	rm haproxy.tar.gz; 		makeOpts=' 		TARGET=linux-musl 		USE_GETADDRINFO=1 		USE_LUA=1 LUA_INC=/usr/include/lua5.3 LUA_LIB=/usr/lib/lua5.3 		USE_OPENSSL=1 		USE_PCRE2=1 USE_PCRE2_JIT=1 		USE_PROMEX=1 				EXTRA_OBJS=" 		" 	'; 		nproc="$(getconf _NPROCESSORS_ONLN)"; 	eval "make -C /usr/src/haproxy -j '$nproc' all $makeOpts"; 	eval "make -C /usr/src/haproxy install-bin $makeOpts"; 		mkdir -p /usr/local/etc/haproxy; 	cp -R /usr/src/haproxy/examples/errorfiles /usr/local/etc/haproxy/errors; 	rm -rf /usr/src/haproxy; 		runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)"; 	apk add --no-network --virtual .haproxy-rundeps $runDeps; 	apk del --no-network .build-deps; 		haproxy -v # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
STOPSIGNAL SIGUSR1
# Thu, 19 Sep 2024 17:15:38 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Thu, 19 Sep 2024 17:15:38 GMT
USER haproxy
# Thu, 19 Sep 2024 17:15:38 GMT
WORKDIR /var/lib/haproxy
# Thu, 19 Sep 2024 17:15:38 GMT
CMD ["haproxy" "-f" "/usr/local/etc/haproxy/haproxy.cfg"]
```

-	Layers:
	-	`sha256:cf04c63912e16506c4413937c7f4579018e4bb25c272d989789cfba77b12f951`  
		Last Modified: Fri, 06 Sep 2024 22:44:39 GMT  
		Size: 4.1 MB (4087646 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:475864bf782bde7d14eb4783aae352be0d696ab31c66715603aea9379002a233`  
		Last Modified: Thu, 19 Sep 2024 18:58:32 GMT  
		Size: 293.5 KB (293514 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:2f7416df3090c26ab24fc03a74054231b5bd030cc32e2b5a42b2df67838109ad`  
		Last Modified: Thu, 19 Sep 2024 18:58:32 GMT  
		Size: 979.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:9ef2c76a39f4c2e4e73fa7b908b5b394436885f5fdef28eb703d58b0f45d7b1d`  
		Last Modified: Thu, 19 Sep 2024 19:03:14 GMT  
		Size: 8.3 MB (8251506 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:083412f8b5a3b4955b0906546ed5e2b18d9ea361deadd73b085600bdd3f07508`  
		Last Modified: Thu, 19 Sep 2024 19:03:13 GMT  
		Size: 441.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:4f4fb700ef54461cfa02571ae0db9a0dc1e0cdb5577484a6d75e68dc38e8acc1`  
		Last Modified: Tue, 07 Mar 2017 15:01:14 GMT  
		Size: 32.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `haproxy:2.8-alpine` - unknown; unknown

```console
$ docker pull haproxy@sha256:63f281a6aeafefd1e87483b22a628949d27daac2bb6c9dadab633af4f2feb89c
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **198.8 KB (198764 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:734a18fdccb1f0185ea202eb4bfa4ba1afd0b17873c562ea22a40bb28b6b3b06`

```dockerfile
```

-	Layers:
	-	`sha256:c5c0cccd007156b6f6f5e9e7b4b19be2b639034ea4769096fad04025755ef410`  
		Last Modified: Thu, 19 Sep 2024 19:03:13 GMT  
		Size: 178.8 KB (178836 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:24f884b539aabe241165b6f677d7df197aea3dc9675f340b395f4c4608a8f567`  
		Last Modified: Thu, 19 Sep 2024 19:03:14 GMT  
		Size: 19.9 KB (19928 bytes)  
		MIME: application/vnd.in-toto+json

### `haproxy:2.8-alpine` - linux; 386

```console
$ docker pull haproxy@sha256:8a4bf20916083545589449d0fb60f87699b039cbab7d5b8722367627c9819d9a
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **11.9 MB (11865127 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:70f35af166ae98e70da535fc6bc72d76f7bc0a2da393659852a9e9c8983e292e`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["haproxy","-f","\/usr\/local\/etc\/haproxy\/haproxy.cfg"]`

```dockerfile
# Fri, 06 Sep 2024 22:41:21 GMT
ADD file:00e6c22c1917031dd97c411814ae384c25a7f2bb91890494a73ea34f3c168453 in / 
# Fri, 06 Sep 2024 22:41:21 GMT
CMD ["/bin/sh"]
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 	apk add --no-cache 		ca-certificates 	; # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 	addgroup --gid 99 --system haproxy; 	adduser 		--disabled-password 		--home /var/lib/haproxy 		--ingroup haproxy 		--no-create-home 		--system 		--uid 99 		haproxy 	; 	mkdir /var/lib/haproxy; 	chown haproxy:haproxy /var/lib/haproxy # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_VERSION=2.8.11
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_URL=https://www.haproxy.org/download/2.8/src/haproxy-2.8.11.tar.gz
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_SHA256=39de529ae0283416acb5477197ece17ea05b81f467bec5a6ac73cbad7dd536a8
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 		apk add --no-cache --virtual .build-deps 		gcc 		libc-dev 		linux-headers 		lua5.3-dev 		make 		openssl 		openssl-dev 		pcre2-dev 		readline-dev 		tar 	; 		wget -O haproxy.tar.gz "$HAPROXY_URL"; 	echo "$HAPROXY_SHA256 *haproxy.tar.gz" | sha256sum -c; 	mkdir -p /usr/src/haproxy; 	tar -xzf haproxy.tar.gz -C /usr/src/haproxy --strip-components=1; 	rm haproxy.tar.gz; 		makeOpts=' 		TARGET=linux-musl 		USE_GETADDRINFO=1 		USE_LUA=1 LUA_INC=/usr/include/lua5.3 LUA_LIB=/usr/lib/lua5.3 		USE_OPENSSL=1 		USE_PCRE2=1 USE_PCRE2_JIT=1 		USE_PROMEX=1 				EXTRA_OBJS=" 		" 	'; 		nproc="$(getconf _NPROCESSORS_ONLN)"; 	eval "make -C /usr/src/haproxy -j '$nproc' all $makeOpts"; 	eval "make -C /usr/src/haproxy install-bin $makeOpts"; 		mkdir -p /usr/local/etc/haproxy; 	cp -R /usr/src/haproxy/examples/errorfiles /usr/local/etc/haproxy/errors; 	rm -rf /usr/src/haproxy; 		runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)"; 	apk add --no-network --virtual .haproxy-rundeps $runDeps; 	apk del --no-network .build-deps; 		haproxy -v # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
STOPSIGNAL SIGUSR1
# Thu, 19 Sep 2024 17:15:38 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Thu, 19 Sep 2024 17:15:38 GMT
USER haproxy
# Thu, 19 Sep 2024 17:15:38 GMT
WORKDIR /var/lib/haproxy
# Thu, 19 Sep 2024 17:15:38 GMT
CMD ["haproxy" "-f" "/usr/local/etc/haproxy/haproxy.cfg"]
```

-	Layers:
	-	`sha256:2689ac6c14fd48d5dbd1df1dd2d317f177e131f689c1a010922edcd778518efd`  
		Last Modified: Fri, 06 Sep 2024 22:41:47 GMT  
		Size: 3.5 MB (3469165 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:dfad7a7b03dc0aada29df128be53cb5805ad7a0ff520f540640d00292a582835`  
		Last Modified: Thu, 19 Sep 2024 18:58:07 GMT  
		Size: 291.4 KB (291356 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:1870ae5a4498b5a92b00a277bde8dc2b23157eebc95ac8d599bc3ed0ade5217b`  
		Last Modified: Thu, 19 Sep 2024 18:58:06 GMT  
		Size: 975.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:88e668a6d8172314aa8eaa0a5c71bc58d75d785408626f741c14f5b15d58e44d`  
		Last Modified: Thu, 19 Sep 2024 18:58:07 GMT  
		Size: 8.1 MB (8103159 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:eff3f6d1fefe7a55fab3b76b32672f270453c5272a0fd26e355edcacda1be2e7`  
		Last Modified: Thu, 19 Sep 2024 18:58:07 GMT  
		Size: 440.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:4f4fb700ef54461cfa02571ae0db9a0dc1e0cdb5577484a6d75e68dc38e8acc1`  
		Last Modified: Tue, 07 Mar 2017 15:01:14 GMT  
		Size: 32.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `haproxy:2.8-alpine` - unknown; unknown

```console
$ docker pull haproxy@sha256:fe95a94b6c390409e26276c101b29ba865d28f0b78951936943ae338efb8a8ea
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **21.9 KB (21875 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:33d415311a27e0bd0723d46e720eb68dce1ce89e5a41fa47bafdf1f6afa5d71b`

```dockerfile
```

-	Layers:
	-	`sha256:1ad0ad97175f794251760a63d615b594e6580bc27027d8208fe5972ff5bdb06b`  
		Last Modified: Thu, 19 Sep 2024 18:58:06 GMT  
		Size: 2.3 KB (2280 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:1561bd1a55d05565a414a4657e6bd4c9aa1bedae1c906a76a86868b9825d94fc`  
		Last Modified: Thu, 19 Sep 2024 18:58:06 GMT  
		Size: 19.6 KB (19595 bytes)  
		MIME: application/vnd.in-toto+json

### `haproxy:2.8-alpine` - linux; ppc64le

```console
$ docker pull haproxy@sha256:b86fd695d4ad0d50a0c126efa27d5e4d2e26eda817655f9a8805210e2e8552d2
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **12.6 MB (12611913 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:fdb6a09a64028e309561931fc21f4dc24c26da807bd4827fa1e319db4fa15ca2`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["haproxy","-f","\/usr\/local\/etc\/haproxy\/haproxy.cfg"]`

```dockerfile
# Fri, 06 Sep 2024 22:26:06 GMT
ADD file:c1f14e23acaff59e2dc7a11f65f8fdfbed8be1350a135493a06b692ecefb26cc in / 
# Fri, 06 Sep 2024 22:26:07 GMT
CMD ["/bin/sh"]
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 	apk add --no-cache 		ca-certificates 	; # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 	addgroup --gid 99 --system haproxy; 	adduser 		--disabled-password 		--home /var/lib/haproxy 		--ingroup haproxy 		--no-create-home 		--system 		--uid 99 		haproxy 	; 	mkdir /var/lib/haproxy; 	chown haproxy:haproxy /var/lib/haproxy # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_VERSION=2.8.11
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_URL=https://www.haproxy.org/download/2.8/src/haproxy-2.8.11.tar.gz
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_SHA256=39de529ae0283416acb5477197ece17ea05b81f467bec5a6ac73cbad7dd536a8
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 		apk add --no-cache --virtual .build-deps 		gcc 		libc-dev 		linux-headers 		lua5.3-dev 		make 		openssl 		openssl-dev 		pcre2-dev 		readline-dev 		tar 	; 		wget -O haproxy.tar.gz "$HAPROXY_URL"; 	echo "$HAPROXY_SHA256 *haproxy.tar.gz" | sha256sum -c; 	mkdir -p /usr/src/haproxy; 	tar -xzf haproxy.tar.gz -C /usr/src/haproxy --strip-components=1; 	rm haproxy.tar.gz; 		makeOpts=' 		TARGET=linux-musl 		USE_GETADDRINFO=1 		USE_LUA=1 LUA_INC=/usr/include/lua5.3 LUA_LIB=/usr/lib/lua5.3 		USE_OPENSSL=1 		USE_PCRE2=1 USE_PCRE2_JIT=1 		USE_PROMEX=1 				EXTRA_OBJS=" 		" 	'; 		nproc="$(getconf _NPROCESSORS_ONLN)"; 	eval "make -C /usr/src/haproxy -j '$nproc' all $makeOpts"; 	eval "make -C /usr/src/haproxy install-bin $makeOpts"; 		mkdir -p /usr/local/etc/haproxy; 	cp -R /usr/src/haproxy/examples/errorfiles /usr/local/etc/haproxy/errors; 	rm -rf /usr/src/haproxy; 		runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)"; 	apk add --no-network --virtual .haproxy-rundeps $runDeps; 	apk del --no-network .build-deps; 		haproxy -v # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
STOPSIGNAL SIGUSR1
# Thu, 19 Sep 2024 17:15:38 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Thu, 19 Sep 2024 17:15:38 GMT
USER haproxy
# Thu, 19 Sep 2024 17:15:38 GMT
WORKDIR /var/lib/haproxy
# Thu, 19 Sep 2024 17:15:38 GMT
CMD ["haproxy" "-f" "/usr/local/etc/haproxy/haproxy.cfg"]
```

-	Layers:
	-	`sha256:b5caf700653f785a3409fb40484075ff91a3a7a84b79ad6a91b165589b35fbc0`  
		Last Modified: Fri, 06 Sep 2024 22:26:38 GMT  
		Size: 3.6 MB (3572419 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:9bb2e8b56632336aa0310ede33c6fd323035c958abd85d5d5e04f5a71003ea97`  
		Last Modified: Thu, 19 Sep 2024 18:59:25 GMT  
		Size: 294.0 KB (294037 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:9303b3dbb55b7c4ae69878d5171343cbcf55be490ec2f722992e88711a125cb9`  
		Last Modified: Thu, 19 Sep 2024 18:59:25 GMT  
		Size: 976.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:954e1491bbadf16a0269a08db12a5893e7b9a5dc4ef6aae7d04addce611d7b4c`  
		Last Modified: Thu, 19 Sep 2024 19:08:00 GMT  
		Size: 8.7 MB (8744001 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:69fee36675d7b0434c85b8372597bb4dddbb3d50bdb5950f3795426b5bf82e32`  
		Last Modified: Thu, 19 Sep 2024 19:08:00 GMT  
		Size: 448.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:4f4fb700ef54461cfa02571ae0db9a0dc1e0cdb5577484a6d75e68dc38e8acc1`  
		Last Modified: Tue, 07 Mar 2017 15:01:14 GMT  
		Size: 32.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `haproxy:2.8-alpine` - unknown; unknown

```console
$ docker pull haproxy@sha256:2a995eeef603951708bbe5da13b5a95d92a20ee07e48d97d853db007fc86c4ef
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **196.5 KB (196530 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:3a2cd4d3d0424c9d4c9075b77218960623d32e47016587aa0b8a823a695537b9`

```dockerfile
```

-	Layers:
	-	`sha256:782ff0fd0953d21bba3d18f082703d8b80e49045829456e8382b8cbfb4d58490`  
		Last Modified: Thu, 19 Sep 2024 19:08:00 GMT  
		Size: 176.9 KB (176860 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:e341cc3912257c99542c487e40908ca965a600cbb92bfb4f5456334e659f503b`  
		Last Modified: Thu, 19 Sep 2024 19:08:00 GMT  
		Size: 19.7 KB (19670 bytes)  
		MIME: application/vnd.in-toto+json

### `haproxy:2.8-alpine` - linux; riscv64

```console
$ docker pull haproxy@sha256:a4072319ebe086c7236803f1d9582886afa3cde03c2b5e49da56401cc09322bc
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **11.6 MB (11641137 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:6eaf7048f658e1c90022b19037da28e768ab3e3c99a75cce5a529b129586acac`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["haproxy","-f","\/usr\/local\/etc\/haproxy\/haproxy.cfg"]`

```dockerfile
# Fri, 06 Sep 2024 22:26:03 GMT
ADD file:1f189f0db01ff094ebe1569a5caf278db6965725f4182176ff85dafa711ad524 in / 
# Fri, 06 Sep 2024 22:26:04 GMT
CMD ["/bin/sh"]
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 	apk add --no-cache 		ca-certificates 	; # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 	addgroup --gid 99 --system haproxy; 	adduser 		--disabled-password 		--home /var/lib/haproxy 		--ingroup haproxy 		--no-create-home 		--system 		--uid 99 		haproxy 	; 	mkdir /var/lib/haproxy; 	chown haproxy:haproxy /var/lib/haproxy # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_VERSION=2.8.11
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_URL=https://www.haproxy.org/download/2.8/src/haproxy-2.8.11.tar.gz
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_SHA256=39de529ae0283416acb5477197ece17ea05b81f467bec5a6ac73cbad7dd536a8
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 		apk add --no-cache --virtual .build-deps 		gcc 		libc-dev 		linux-headers 		lua5.3-dev 		make 		openssl 		openssl-dev 		pcre2-dev 		readline-dev 		tar 	; 		wget -O haproxy.tar.gz "$HAPROXY_URL"; 	echo "$HAPROXY_SHA256 *haproxy.tar.gz" | sha256sum -c; 	mkdir -p /usr/src/haproxy; 	tar -xzf haproxy.tar.gz -C /usr/src/haproxy --strip-components=1; 	rm haproxy.tar.gz; 		makeOpts=' 		TARGET=linux-musl 		USE_GETADDRINFO=1 		USE_LUA=1 LUA_INC=/usr/include/lua5.3 LUA_LIB=/usr/lib/lua5.3 		USE_OPENSSL=1 		USE_PCRE2=1 USE_PCRE2_JIT=1 		USE_PROMEX=1 				EXTRA_OBJS=" 		" 	'; 		nproc="$(getconf _NPROCESSORS_ONLN)"; 	eval "make -C /usr/src/haproxy -j '$nproc' all $makeOpts"; 	eval "make -C /usr/src/haproxy install-bin $makeOpts"; 		mkdir -p /usr/local/etc/haproxy; 	cp -R /usr/src/haproxy/examples/errorfiles /usr/local/etc/haproxy/errors; 	rm -rf /usr/src/haproxy; 		runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)"; 	apk add --no-network --virtual .haproxy-rundeps $runDeps; 	apk del --no-network .build-deps; 		haproxy -v # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
STOPSIGNAL SIGUSR1
# Thu, 19 Sep 2024 17:15:38 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Thu, 19 Sep 2024 17:15:38 GMT
USER haproxy
# Thu, 19 Sep 2024 17:15:38 GMT
WORKDIR /var/lib/haproxy
# Thu, 19 Sep 2024 17:15:38 GMT
CMD ["haproxy" "-f" "/usr/local/etc/haproxy/haproxy.cfg"]
```

-	Layers:
	-	`sha256:8c4a05189a5fd2cf629c25ab8d0831be7156d74b336f129a412933ee78af018c`  
		Last Modified: Fri, 06 Sep 2024 22:26:21 GMT  
		Size: 3.4 MB (3371452 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:912bcc9b9311dac341d2f9998e7f1fbd54b6e8e36f756419b6bbd5e959954759`  
		Last Modified: Sat, 07 Sep 2024 19:05:06 GMT  
		Size: 291.7 KB (291669 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:4f6038f190563add9bb61aef08e82a177b286f8f88aa0fd81e4b22e6ba042a38`  
		Last Modified: Sat, 07 Sep 2024 19:05:06 GMT  
		Size: 978.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:b3199e42db49a2d3a0b74c6e7a919f0e4ab5bcace1897637c6a72b0ac619a19a`  
		Last Modified: Thu, 19 Sep 2024 19:52:41 GMT  
		Size: 8.0 MB (7976553 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:121475a02eb72fe5fa5a48c5e1e25ae622e1b6950df61bd8a9d14449956b292d`  
		Last Modified: Thu, 19 Sep 2024 19:52:40 GMT  
		Size: 453.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:4f4fb700ef54461cfa02571ae0db9a0dc1e0cdb5577484a6d75e68dc38e8acc1`  
		Last Modified: Tue, 07 Mar 2017 15:01:14 GMT  
		Size: 32.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `haproxy:2.8-alpine` - unknown; unknown

```console
$ docker pull haproxy@sha256:32054475b3da6d7293cbb0822c121486900d9e5bf0b13e5ffad3eb6203c5e20b
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **196.5 KB (196526 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:3ca0066fcce0e8c642b5598817f3b13573220f75ebac04feece17dc31a11e9ca`

```dockerfile
```

-	Layers:
	-	`sha256:4715460805d35d63c2499801df601cbdeb5c5b1a8d7374a57189a5ba0263eb69`  
		Last Modified: Thu, 19 Sep 2024 19:52:40 GMT  
		Size: 176.9 KB (176856 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:22d88903aa1ee7e8172851b1987ae8874fe307203103aa74321a374a25c58daa`  
		Last Modified: Thu, 19 Sep 2024 19:52:40 GMT  
		Size: 19.7 KB (19670 bytes)  
		MIME: application/vnd.in-toto+json

### `haproxy:2.8-alpine` - linux; s390x

```console
$ docker pull haproxy@sha256:3a432ef86ec1c6c6724e32905de442914ca4a395c86b5ba57e047ec9e0f6a159
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **12.2 MB (12243527 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:8d433cdb36dafb05bcbb373d7215c380b48e3c0efa38a1be2336256399d1bf2e`
-	Entrypoint: `["docker-entrypoint.sh"]`
-	Default Command: `["haproxy","-f","\/usr\/local\/etc\/haproxy\/haproxy.cfg"]`

```dockerfile
# Fri, 06 Sep 2024 22:48:17 GMT
ADD file:ba2637314e600db5a647501cf1ab287c5f51de1627c13bc1d82aa48925a3dd78 in / 
# Fri, 06 Sep 2024 22:48:17 GMT
CMD ["/bin/sh"]
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 	apk add --no-cache 		ca-certificates 	; # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 	addgroup --gid 99 --system haproxy; 	adduser 		--disabled-password 		--home /var/lib/haproxy 		--ingroup haproxy 		--no-create-home 		--system 		--uid 99 		haproxy 	; 	mkdir /var/lib/haproxy; 	chown haproxy:haproxy /var/lib/haproxy # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_VERSION=2.8.11
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_URL=https://www.haproxy.org/download/2.8/src/haproxy-2.8.11.tar.gz
# Thu, 19 Sep 2024 17:15:38 GMT
ENV HAPROXY_SHA256=39de529ae0283416acb5477197ece17ea05b81f467bec5a6ac73cbad7dd536a8
# Thu, 19 Sep 2024 17:15:38 GMT
RUN set -eux; 		apk add --no-cache --virtual .build-deps 		gcc 		libc-dev 		linux-headers 		lua5.3-dev 		make 		openssl 		openssl-dev 		pcre2-dev 		readline-dev 		tar 	; 		wget -O haproxy.tar.gz "$HAPROXY_URL"; 	echo "$HAPROXY_SHA256 *haproxy.tar.gz" | sha256sum -c; 	mkdir -p /usr/src/haproxy; 	tar -xzf haproxy.tar.gz -C /usr/src/haproxy --strip-components=1; 	rm haproxy.tar.gz; 		makeOpts=' 		TARGET=linux-musl 		USE_GETADDRINFO=1 		USE_LUA=1 LUA_INC=/usr/include/lua5.3 LUA_LIB=/usr/lib/lua5.3 		USE_OPENSSL=1 		USE_PCRE2=1 USE_PCRE2_JIT=1 		USE_PROMEX=1 				EXTRA_OBJS=" 		" 	'; 		nproc="$(getconf _NPROCESSORS_ONLN)"; 	eval "make -C /usr/src/haproxy -j '$nproc' all $makeOpts"; 	eval "make -C /usr/src/haproxy install-bin $makeOpts"; 		mkdir -p /usr/local/etc/haproxy; 	cp -R /usr/src/haproxy/examples/errorfiles /usr/local/etc/haproxy/errors; 	rm -rf /usr/src/haproxy; 		runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)"; 	apk add --no-network --virtual .haproxy-rundeps $runDeps; 	apk del --no-network .build-deps; 		haproxy -v # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
STOPSIGNAL SIGUSR1
# Thu, 19 Sep 2024 17:15:38 GMT
COPY docker-entrypoint.sh /usr/local/bin/ # buildkit
# Thu, 19 Sep 2024 17:15:38 GMT
ENTRYPOINT ["docker-entrypoint.sh"]
# Thu, 19 Sep 2024 17:15:38 GMT
USER haproxy
# Thu, 19 Sep 2024 17:15:38 GMT
WORKDIR /var/lib/haproxy
# Thu, 19 Sep 2024 17:15:38 GMT
CMD ["haproxy" "-f" "/usr/local/etc/haproxy/haproxy.cfg"]
```

-	Layers:
	-	`sha256:df110db6acd600b9ee5ebd7b510779652f96424d3f80321a4e0dcb8a09aa0526`  
		Last Modified: Fri, 06 Sep 2024 22:48:57 GMT  
		Size: 3.5 MB (3461598 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:ec09cecab38a538b00144752b5409154091d2a1c1ee0cc68caec4e9ca682fc59`  
		Last Modified: Thu, 19 Sep 2024 18:59:32 GMT  
		Size: 291.9 KB (291899 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:3b0e9c31ea21575aa8eaa08d8f7a2d3c205b1559169e3a7684a814bb3b34413f`  
		Last Modified: Thu, 19 Sep 2024 18:59:32 GMT  
		Size: 979.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:84ccbc5dcf1a8b8fe8735f417800ccc49cd6dc739acfa227eededb1a39e4923d`  
		Last Modified: Thu, 19 Sep 2024 19:08:12 GMT  
		Size: 8.5 MB (8488577 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:dbb5abfccfc96e28aaa616e1f9d4b78bab888476f26537c3a871fad799620d33`  
		Last Modified: Thu, 19 Sep 2024 19:08:12 GMT  
		Size: 442.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:4f4fb700ef54461cfa02571ae0db9a0dc1e0cdb5577484a6d75e68dc38e8acc1`  
		Last Modified: Tue, 07 Mar 2017 15:01:14 GMT  
		Size: 32.0 B  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `haproxy:2.8-alpine` - unknown; unknown

```console
$ docker pull haproxy@sha256:0cce45a04a6f485826c2b019c8a35c2599781dbac35e0b9c66f082b89f49656a
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **196.5 KB (196453 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:eb0013097c594a037774bc1f277867c0aed70b7b24f75c2ab5078e063b555a84`

```dockerfile
```

-	Layers:
	-	`sha256:4805f2c54851c87ae9aaa979d122c8bf3a598303860d1696aea1d29997f73c68`  
		Last Modified: Thu, 19 Sep 2024 19:08:12 GMT  
		Size: 176.8 KB (176826 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:506130ce78da2f1c7f676ef4834909ac88f284fa85992080143fe7210f35ea90`  
		Last Modified: Thu, 19 Sep 2024 19:08:12 GMT  
		Size: 19.6 KB (19627 bytes)  
		MIME: application/vnd.in-toto+json
