# `erlang:25.3.2.13`

## Docker Metadata

- Image ID: `sha256:41e09d88b46329d2c9c73642d31afa018e2ef46af1440f10aacb26f0d248d88e`
- Created: `2024-08-13T13:58:20Z`
- Virtual Size: ~ 1.47 Gb  
  (total size of all layers on-disk)
- Arch: `linux`/`amd64`
- Command: `["erl"]`
- Environment:
  - `PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin`
  - `OTP_VERSION=25.3.2.13`
  - `REBAR3_VERSION=3.23.0`
  - `REBAR_VERSION=2.6.4`
- Labels:
  - `org.opencontainers.image.version=25.3.2.13`

## `dpkg` (`.deb`-based packages)

### `dpkg` source package: `aalib=1.4p5-48`

Binary Packages:

- `libaa1:amd64=1.4p5-48`

Licenses: (parsed from: `/usr/share/doc/libaa1/copyright`)

- `Abstyles`
- `Custom`
- `LGPL-2`
- `LGPL-2.0+`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris aalib=1.4p5-48
'http://deb.debian.org/debian/pool/main/a/aalib/aalib_1.4p5-48.dsc' aalib_1.4p5-48.dsc 2059 SHA256:a4dce40ce23137a7e176c515e7662c04217be807913af1485c158ca2349e33d8
'http://deb.debian.org/debian/pool/main/a/aalib/aalib_1.4p5.orig.tar.gz' aalib_1.4p5.orig.tar.gz 391028 SHA256:fbddda9230cf6ee2a4f5706b4b11e2190ae45f5eda1f0409dc4f99b35e0a70ee
'http://deb.debian.org/debian/pool/main/a/aalib/aalib_1.4p5-48.debian.tar.xz' aalib_1.4p5-48.debian.tar.xz 16284 SHA256:741db410ecb4c392de7605bcab861812be22b15474fe68061d435a3f0be46862
```

Other potentially useful URLs:

- https://sources.debian.net/src/aalib/1.4p5-48/ (for browsing the source)
- https://sources.debian.net/src/aalib/1.4p5-48/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/aalib/1.4p5-48/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `acl=2.2.53-10`

Binary Packages:

- `libacl1:amd64=2.2.53-10`

Licenses: (parsed from: `/usr/share/doc/libacl1/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2+`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris acl=2.2.53-10
'http://deb.debian.org/debian/pool/main/a/acl/acl_2.2.53-10.dsc' acl_2.2.53-10.dsc 2468 SHA256:09204a89156b17a3603b2ce34b3c7b1a9fd7345086c787962188d95347918c59
'http://deb.debian.org/debian/pool/main/a/acl/acl_2.2.53.orig.tar.gz' acl_2.2.53.orig.tar.gz 524300 SHA256:06be9865c6f418d851ff4494e12406568353b891ffe1f596b34693c387af26c7
'http://deb.debian.org/debian/pool/main/a/acl/acl_2.2.53.orig.tar.gz.asc' acl_2.2.53.orig.tar.gz.asc 833 SHA256:06849bece0b56a6a7269173abe101cff223bb9346d74027a3cd5ff80914abf4b
'http://deb.debian.org/debian/pool/main/a/acl/acl_2.2.53-10.debian.tar.xz' acl_2.2.53-10.debian.tar.xz 25536 SHA256:6b83a626aa383334b64666181642c7c13e44a6fe65486d0aaa34bd8de6d58b20
```

Other potentially useful URLs:

- https://sources.debian.net/src/acl/2.2.53-10/ (for browsing the source)
- https://sources.debian.net/src/acl/2.2.53-10/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/acl/2.2.53-10/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `adduser=3.118+deb11u1`

Binary Packages:

- `adduser=3.118+deb11u1`

Licenses: (parsed from: `/usr/share/doc/adduser/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris adduser=3.118+deb11u1
'http://deb.debian.org/debian/pool/main/a/adduser/adduser_3.118%2bdeb11u1.dsc' adduser_3.118+deb11u1.dsc 1677 SHA256:8e114d444fe24474b51a40931c3778d9cc0e35cbbed802088e390695d8020a0a
'http://deb.debian.org/debian/pool/main/a/adduser/adduser_3.118%2bdeb11u1.tar.xz' adduser_3.118+deb11u1.tar.xz 212260 SHA256:ef0c058ae23857665cea7d527fdf9f270f5cb47b15391f108082dd709d09fa93
```

Other potentially useful URLs:

- https://sources.debian.net/src/adduser/3.118+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/adduser/3.118+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/adduser/3.118+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `adwaita-icon-theme=3.38.0-1`

Binary Packages:

- `adwaita-icon-theme=3.38.0-1`

Licenses: (parsed from: `/usr/share/doc/adwaita-icon-theme/copyright`)

- `CC-BY-3.0-US`
- `CC-BY-SA-2.0-IT`
- `CC-BY-SA-2.0-IT,`
- `CC-BY-SA-3.0`
- `CC-BY-SA-3.0-US`
- `CC-BY-SA-3.0-Unported`
- `CC-BY-SA-4.0`
- `GFDL-1.2`
- `GFDL-1.2+`
- `GPL`
- `GPL-unspecified`
- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris adwaita-icon-theme=3.38.0-1
'http://deb.debian.org/debian/pool/main/a/adwaita-icon-theme/adwaita-icon-theme_3.38.0-1.dsc' adwaita-icon-theme_3.38.0-1.dsc 2188 SHA256:ee65f48faaad861a45fae06e5707ab5c2286aebc6211592775269121c34d08b9
'http://deb.debian.org/debian/pool/main/a/adwaita-icon-theme/adwaita-icon-theme_3.38.0.orig.tar.xz' adwaita-icon-theme_3.38.0.orig.tar.xz 17202144 SHA256:6683a1aaf2430ccd9ea638dd4bfe1002bc92b412050c3dba20e480f979faaf97
'http://deb.debian.org/debian/pool/main/a/adwaita-icon-theme/adwaita-icon-theme_3.38.0-1.debian.tar.xz' adwaita-icon-theme_3.38.0-1.debian.tar.xz 34228 SHA256:48ad9e9897ec56e5357b0b49306157085536be9c5f8b9aaddf18154fe97970fb
```

Other potentially useful URLs:

- https://sources.debian.net/src/adwaita-icon-theme/3.38.0-1/ (for browsing the source)
- https://sources.debian.net/src/adwaita-icon-theme/3.38.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/adwaita-icon-theme/3.38.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `aom=1.0.0.errata1-3+deb11u2`

Binary Packages:

- `libaom0:amd64=1.0.0.errata1-3+deb11u2`

Licenses: (parsed from: `/usr/share/doc/libaom0/copyright`)

- `BSD-2-Clause`
- `BSD-2-clause`
- `BSD-3-clause`
- `Expat`
- `ISC`
- `public-domain-md5`

Source:

```console
$ apt-get source -qq --print-uris aom=1.0.0.errata1-3+deb11u2
'http://deb.debian.org/debian-security/pool/updates/main/a/aom/aom_1.0.0.errata1-3%2bdeb11u2.dsc' aom_1.0.0.errata1-3+deb11u2.dsc 2256 SHA256:d3a9daaace3b4990fdbf81dc13ebe056b21a052338fd2f1e723fdb404784a6a8
'http://deb.debian.org/debian-security/pool/updates/main/a/aom/aom_1.0.0.errata1.orig.tar.xz' aom_1.0.0.errata1.orig.tar.xz 1898808 SHA256:1dd501c622d871acf31fb942bd3b73a00883fc10f7c498fec97b22c858ca415f
'http://deb.debian.org/debian-security/pool/updates/main/a/aom/aom_1.0.0.errata1-3%2bdeb11u2.debian.tar.xz' aom_1.0.0.errata1-3+deb11u2.debian.tar.xz 27692 SHA256:2e58c34c4617544c5c84ec3bdf658c463d03ea4c2a67d0ceadf1772dc3d672dd
```

Other potentially useful URLs:

- https://sources.debian.net/src/aom/1.0.0.errata1-3+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/aom/1.0.0.errata1-3+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/aom/1.0.0.errata1-3+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `apparmor=2.13.6-10`

Binary Packages:

- `libapparmor1:amd64=2.13.6-10`

Licenses: (parsed from: `/usr/share/doc/libapparmor1/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris apparmor=2.13.6-10
'http://deb.debian.org/debian/pool/main/a/apparmor/apparmor_2.13.6-10.dsc' apparmor_2.13.6-10.dsc 3066 SHA256:4e4374de9dbabd7a224c461fe40d4c14f659bb9060e7def96a68b78582ac653e
'http://deb.debian.org/debian/pool/main/a/apparmor/apparmor_2.13.6.orig.tar.gz' apparmor_2.13.6.orig.tar.gz 7399438 SHA256:4426b8b73f368889aea69cbc224ae666d4145b9520a2866cc2a915908e87ba8f
'http://deb.debian.org/debian/pool/main/a/apparmor/apparmor_2.13.6.orig.tar.gz.asc' apparmor_2.13.6.orig.tar.gz.asc 870 SHA256:74f180f2108043842a64671239aa408062eae3681b60602801246d4e6f63eccf
'http://deb.debian.org/debian/pool/main/a/apparmor/apparmor_2.13.6-10.debian.tar.xz' apparmor_2.13.6-10.debian.tar.xz 109296 SHA256:e62ffde6e5aa39d2858a1c730ea4034ad933ee1f00af8a42fb256b0f15f389a8
```

Other potentially useful URLs:

- https://sources.debian.net/src/apparmor/2.13.6-10/ (for browsing the source)
- https://sources.debian.net/src/apparmor/2.13.6-10/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/apparmor/2.13.6-10/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `apr-util=1.6.1-5+deb11u1`

Binary Packages:

- `libaprutil1:amd64=1.6.1-5+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libaprutil1/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris apr-util=1.6.1-5+deb11u1
'http://deb.debian.org/debian/pool/main/a/apr-util/apr-util_1.6.1-5%2bdeb11u1.dsc' apr-util_1.6.1-5+deb11u1.dsc 2691 SHA256:e71909d6c919c795682e51e183f90003f42af301cefe9b81dd5c24d07b693dd3
'http://deb.debian.org/debian/pool/main/a/apr-util/apr-util_1.6.1.orig.tar.bz2' apr-util_1.6.1.orig.tar.bz2 428595 SHA256:d3e12f7b6ad12687572a3a39475545a072608f4ba03a6ce8a3778f607dd0035b
'http://deb.debian.org/debian/pool/main/a/apr-util/apr-util_1.6.1-5%2bdeb11u1.debian.tar.xz' apr-util_1.6.1-5+deb11u1.debian.tar.xz 343692 SHA256:2f3e30a4ba9b762e248dd7368234c4c302ad94f529fdc7e90942a0ee972b6708
```

Other potentially useful URLs:

- https://sources.debian.net/src/apr-util/1.6.1-5+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/apr-util/1.6.1-5+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/apr-util/1.6.1-5+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `apr=1.7.0-6+deb11u2`

Binary Packages:

- `libapr1:amd64=1.7.0-6+deb11u2`

Licenses: (parsed from: `/usr/share/doc/libapr1/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris apr=1.7.0-6+deb11u2
'http://deb.debian.org/debian/pool/main/a/apr/apr_1.7.0-6%2bdeb11u2.dsc' apr_1.7.0-6+deb11u2.dsc 2202 SHA256:9736c0926998f8ca24f96a88c935f323127817400184b4040e52456e483eacb1
'http://deb.debian.org/debian/pool/main/a/apr/apr_1.7.0.orig.tar.bz2' apr_1.7.0.orig.tar.bz2 872238 SHA256:e2e148f0b2e99b8e5c6caa09f6d4fb4dd3e83f744aa72a952f94f5a14436f7ea
'http://deb.debian.org/debian/pool/main/a/apr/apr_1.7.0-6%2bdeb11u2.debian.tar.xz' apr_1.7.0-6+deb11u2.debian.tar.xz 225364 SHA256:b90bcafcb6061f1685473f8c48e26c0916c8a312542eb25dca852c730a4dae64
```

Other potentially useful URLs:

- https://sources.debian.net/src/apr/1.7.0-6+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/apr/1.7.0-6+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/apr/1.7.0-6+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `apt=2.2.4`

Binary Packages:

- `apt=2.2.4`
- `libapt-pkg6.0:amd64=2.2.4`

Licenses: (parsed from: `/usr/share/doc/apt/copyright`, `/usr/share/doc/libapt-pkg6.0/copyright`)

- `GPL-2`
- `GPLv2+`

Source:

```console
$ apt-get source -qq --print-uris apt=2.2.4
'http://deb.debian.org/debian/pool/main/a/apt/apt_2.2.4.dsc' apt_2.2.4.dsc 2780 SHA256:750079533300bc3a4f3e10a9c8dbffaa0781b92e3616a12d7e18ab1378ca4466
'http://deb.debian.org/debian/pool/main/a/apt/apt_2.2.4.tar.xz' apt_2.2.4.tar.xz 2197424 SHA256:6eecd04a4979bd2040b22a14571c15d342c4e1802b2023acb5aa19649b1f64ea
```

Other potentially useful URLs:

- https://sources.debian.net/src/apt/2.2.4/ (for browsing the source)
- https://sources.debian.net/src/apt/2.2.4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/apt/2.2.4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `argon2=0~20171227-0.2`

Binary Packages:

- `libargon2-1:amd64=0~20171227-0.2`

Licenses: (parsed from: `/usr/share/doc/libargon2-1/copyright`)

- `Apache-2.0`
- `CC0`

Source:

```console
$ apt-get source -qq --print-uris argon2=0~20171227-0.2
'http://deb.debian.org/debian/pool/main/a/argon2/argon2_0%7e20171227-0.2.dsc' argon2_0~20171227-0.2.dsc 2108 SHA256:357d1e93318d7dd3bee401ee9cd92bd0f3ecaab3990013580a12306efda4ebf7
'http://deb.debian.org/debian/pool/main/a/argon2/argon2_0%7e20171227.orig.tar.gz' argon2_0~20171227.orig.tar.gz 1503745 SHA256:eaea0172c1f4ee4550d1b6c9ce01aab8d1ab66b4207776aa67991eb5872fdcd8
'http://deb.debian.org/debian/pool/main/a/argon2/argon2_0%7e20171227-0.2.debian.tar.xz' argon2_0~20171227-0.2.debian.tar.xz 6932 SHA256:49e630c0027ebbe0b53e3e692ce99da750e9bdfeddcebf303e595b4af5a2142f
```

Other potentially useful URLs:

- https://sources.debian.net/src/argon2/0~20171227-0.2/ (for browsing the source)
- https://sources.debian.net/src/argon2/0~20171227-0.2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/argon2/0~20171227-0.2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `aspell=0.60.8-3`

Binary Packages:

- `libaspell15:amd64=0.60.8-3`

Licenses: (parsed from: `/usr/share/doc/libaspell15/copyright`)

- `GFDL-1.2`
- `GFDL-1.2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris aspell=0.60.8-3
'http://deb.debian.org/debian/pool/main/a/aspell/aspell_0.60.8-3.dsc' aspell_0.60.8-3.dsc 2120 SHA256:2ae1994e2461c9d3778c8eaac5af0f1fdb6e07368dd7992db67d0aa002cc748c
'http://deb.debian.org/debian/pool/main/a/aspell/aspell_0.60.8.orig.tar.gz' aspell_0.60.8.orig.tar.gz 3486448 SHA256:f9b77e515334a751b2e60daab5db23499e26c9209f5e7b7443b05235ad0226f2
'http://deb.debian.org/debian/pool/main/a/aspell/aspell_0.60.8-3.debian.tar.xz' aspell_0.60.8-3.debian.tar.xz 25816 SHA256:e49727904e3c030fabb895bb60ad2f611542ce633284568105b354216aa7039e
```

Other potentially useful URLs:

- https://sources.debian.net/src/aspell/0.60.8-3/ (for browsing the source)
- https://sources.debian.net/src/aspell/0.60.8-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/aspell/0.60.8-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `at-spi2-atk=2.38.0-1`

Binary Packages:

- `libatk-bridge2.0-0:amd64=2.38.0-1`

Licenses: (parsed from: `/usr/share/doc/libatk-bridge2.0-0/copyright`)

- `GPL-2`
- `LGPL-2`
- `LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris at-spi2-atk=2.38.0-1
'http://deb.debian.org/debian/pool/main/a/at-spi2-atk/at-spi2-atk_2.38.0-1.dsc' at-spi2-atk_2.38.0-1.dsc 2632 SHA256:0a4be468f9070c967caeea6d0c2e87b8e5e57127ed301cfe7e6bfb0b3975ba36
'http://deb.debian.org/debian/pool/main/a/at-spi2-atk/at-spi2-atk_2.38.0.orig.tar.xz' at-spi2-atk_2.38.0.orig.tar.xz 97464 SHA256:cfa008a5af822b36ae6287f18182c40c91dd699c55faa38605881ed175ca464f
'http://deb.debian.org/debian/pool/main/a/at-spi2-atk/at-spi2-atk_2.38.0-1.debian.tar.xz' at-spi2-atk_2.38.0-1.debian.tar.xz 10424 SHA256:44e33d8024c46595a00509ec5dd5d5604ff011816475afaa1b6e13b4e5f5a95b
```

Other potentially useful URLs:

- https://sources.debian.net/src/at-spi2-atk/2.38.0-1/ (for browsing the source)
- https://sources.debian.net/src/at-spi2-atk/2.38.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/at-spi2-atk/2.38.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `at-spi2-core=2.38.0-4+deb11u1`

Binary Packages:

- `libatspi2.0-0:amd64=2.38.0-4+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libatspi2.0-0/copyright`)

- `AFL-2.1`
- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris at-spi2-core=2.38.0-4+deb11u1
'http://deb.debian.org/debian/pool/main/a/at-spi2-core/at-spi2-core_2.38.0-4%2bdeb11u1.dsc' at-spi2-core_2.38.0-4+deb11u1.dsc 2762 SHA256:d75039efecea42b21ff8a1f3a3c267775907cc9c4371164d49c5fb89f26e6b7a
'http://deb.debian.org/debian/pool/main/a/at-spi2-core/at-spi2-core_2.38.0.orig.tar.xz' at-spi2-core_2.38.0.orig.tar.xz 190540 SHA256:84e36c3fe66862133f5fe229772b76aa2526e10de5014a3778f2fa46ce550da5
'http://deb.debian.org/debian/pool/main/a/at-spi2-core/at-spi2-core_2.38.0-4%2bdeb11u1.debian.tar.xz' at-spi2-core_2.38.0-4+deb11u1.debian.tar.xz 11852 SHA256:61027c99f98f4812d72e853a37db14fb0c40bb17f35762c09f9b373697598dea
```

Other potentially useful URLs:

- https://sources.debian.net/src/at-spi2-core/2.38.0-4+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/at-spi2-core/2.38.0-4+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/at-spi2-core/2.38.0-4+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `atk1.0=2.36.0-2`

Binary Packages:

- `libatk1.0-0:amd64=2.36.0-2`
- `libatk1.0-data=2.36.0-2`

Licenses: (parsed from: `/usr/share/doc/libatk1.0-0/copyright`, `/usr/share/doc/libatk1.0-data/copyright`)

- `LGPL-2`

Source:

```console
$ apt-get source -qq --print-uris atk1.0=2.36.0-2
'http://deb.debian.org/debian/pool/main/a/atk1.0/atk1.0_2.36.0-2.dsc' atk1.0_2.36.0-2.dsc 2660 SHA256:03327eada194e9091a0785904632d3999ee308669e8de8362c67324ae23c544c
'http://deb.debian.org/debian/pool/main/a/atk1.0/atk1.0_2.36.0.orig.tar.xz' atk1.0_2.36.0.orig.tar.xz 299100 SHA256:fb76247e369402be23f1f5c65d38a9639c1164d934e40f6a9cf3c9e96b652788
'http://deb.debian.org/debian/pool/main/a/atk1.0/atk1.0_2.36.0-2.debian.tar.xz' atk1.0_2.36.0-2.debian.tar.xz 11860 SHA256:70d0e60ebe591c9e208d1e377fa25530a6e66c7dbeb88bf1b0b9776539c20d49
```

Other potentially useful URLs:

- https://sources.debian.net/src/atk1.0/2.36.0-2/ (for browsing the source)
- https://sources.debian.net/src/atk1.0/2.36.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/atk1.0/2.36.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `attr=1:2.4.48-6`

Binary Packages:

- `libattr1:amd64=1:2.4.48-6`

Licenses: (parsed from: `/usr/share/doc/libattr1/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2+`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris attr=1:2.4.48-6
'http://deb.debian.org/debian/pool/main/a/attr/attr_2.4.48-6.dsc' attr_2.4.48-6.dsc 2433 SHA256:d55d1ba40517146e9a43f9ed1c5dbd82cfe079cd1fdb852323717a953515cfa4
'http://deb.debian.org/debian/pool/main/a/attr/attr_2.4.48.orig.tar.gz' attr_2.4.48.orig.tar.gz 467840 SHA256:5ead72b358ec709ed00bbf7a9eaef1654baad937c001c044fe8b74c57f5324e7
'http://deb.debian.org/debian/pool/main/a/attr/attr_2.4.48.orig.tar.gz.asc' attr_2.4.48.orig.tar.gz.asc 833 SHA256:5d23c2c83cc13d170f1c209f48d0efa1fc46d16487b790e9996c5206dcfe0395
'http://deb.debian.org/debian/pool/main/a/attr/attr_2.4.48-6.debian.tar.xz' attr_2.4.48-6.debian.tar.xz 27260 SHA256:77f7e03cc8dd039abc3e4a7353f816a3b07fbd0b22d7784f635c5edf7d20b6df
```

Other potentially useful URLs:

- https://sources.debian.net/src/attr/1:2.4.48-6/ (for browsing the source)
- https://sources.debian.net/src/attr/1:2.4.48-6/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/attr/1:2.4.48-6/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `audit=1:3.0-2`

Binary Packages:

- `libaudit-common=1:3.0-2`
- `libaudit1:amd64=1:3.0-2`

Licenses: (parsed from: `/usr/share/doc/libaudit-common/copyright`, `/usr/share/doc/libaudit1/copyright`)

- `GPL-1`
- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris audit=1:3.0-2
'http://deb.debian.org/debian/pool/main/a/audit/audit_3.0-2.dsc' audit_3.0-2.dsc 2397 SHA256:3cb83cc7649bb854c76f9cb6744b34091e667e433a91a57323938fdf3f353227
'http://deb.debian.org/debian/pool/main/a/audit/audit_3.0.orig.tar.gz' audit_3.0.orig.tar.gz 1109442 SHA256:bd31826823b912b6fe271d2d979ed879e9fc393cab1e2f7c4e1af258231765b8
'http://deb.debian.org/debian/pool/main/a/audit/audit_3.0-2.debian.tar.xz' audit_3.0-2.debian.tar.xz 18640 SHA256:10193fa9823eb66dfb1220fb109b8b8e01f3f720c5a1630e9015d92aa7a8ce3a
```

Other potentially useful URLs:

- https://sources.debian.net/src/audit/1:3.0-2/ (for browsing the source)
- https://sources.debian.net/src/audit/1:3.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/audit/1:3.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `autoconf=2.69-14`

Binary Packages:

- `autoconf=2.69-14`

Licenses: (parsed from: `/usr/share/doc/autoconf/copyright`)

- `GFDL-1.3`
- `GFDL-1.3+`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with Autoconf exception`
- `GPL-3`
- `GPL-3+`
- `GPL-3+ with Autoconf exception`
- `GPL-3+ with Texinfo exception`
- `MIT-X-Consortium`
- `no-modification`
- `other`
- `permissive`
- `permissive-long-disclaimer`
- `permissive-short-disclaimer`
- `permissive-without-disclaimer`
- `permissive-without-notices-or-disclaimer`

Source:

```console
$ apt-get source -qq --print-uris autoconf=2.69-14
'http://deb.debian.org/debian/pool/main/a/autoconf/autoconf_2.69-14.dsc' autoconf_2.69-14.dsc 1624 SHA256:aa23c53bf119239e302419772f89d988ecbf6ed2ac736db7329bcf71a891dece
'http://deb.debian.org/debian/pool/main/a/autoconf/autoconf_2.69.orig.tar.xz' autoconf_2.69.orig.tar.xz 1214744 SHA256:64ebcec9f8ac5b2487125a86a7760d2591ac9e1d3dbd59489633f9de62a57684
'http://deb.debian.org/debian/pool/main/a/autoconf/autoconf_2.69-14.debian.tar.xz' autoconf_2.69-14.debian.tar.xz 24512 SHA256:156bbeaeeb8a9c5cdd7d482a7d85c05c2050456959656c3b7f5f0b062dbe6f9e
```

Other potentially useful URLs:

- https://sources.debian.net/src/autoconf/2.69-14/ (for browsing the source)
- https://sources.debian.net/src/autoconf/2.69-14/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/autoconf/2.69-14/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `automake-1.16=1:1.16.3-2`

Binary Packages:

- `automake=1:1.16.3-2`

Licenses: (parsed from: `/usr/share/doc/automake/copyright`)

- `GFDL-1.3`
- `GFDL-NIV-1.3+`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `permissive`

Source:

```console
$ apt-get source -qq --print-uris automake-1.16=1:1.16.3-2
'http://deb.debian.org/debian/pool/main/a/automake-1.16/automake-1.16_1.16.3-2.dsc' automake-1.16_1.16.3-2.dsc 2561 SHA256:090b0d54b2050e449d401cca40165d0f3f9c7f017bb1b7179e1291eb7db908b1
'http://deb.debian.org/debian/pool/main/a/automake-1.16/automake-1.16_1.16.3.orig.tar.xz' automake-1.16_1.16.3.orig.tar.xz 1590708 SHA256:ff2bf7656c4d1c6fdda3b8bebb21f09153a736bcba169aaf65eab25fa113bf3a
'http://deb.debian.org/debian/pool/main/a/automake-1.16/automake-1.16_1.16.3.orig.tar.xz.asc' automake-1.16_1.16.3.orig.tar.xz.asc 833 SHA256:fe4e9d6e0cf15448618385cbc055ef0a03c0de63b3771180013029db7fece7e4
'http://deb.debian.org/debian/pool/main/a/automake-1.16/automake-1.16_1.16.3-2.debian.tar.xz' automake-1.16_1.16.3-2.debian.tar.xz 12500 SHA256:8a710818bf9600952b0358b17a0b83c901119fb08128ea16ae55624efc99d837
```

Other potentially useful URLs:

- https://sources.debian.net/src/automake-1.16/1:1.16.3-2/ (for browsing the source)
- https://sources.debian.net/src/automake-1.16/1:1.16.3-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/automake-1.16/1:1.16.3-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `autotools-dev=20180224.1+nmu1`

Binary Packages:

- `autotools-dev=20180224.1+nmu1`

Licenses: (parsed from: `/usr/share/doc/autotools-dev/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris autotools-dev=20180224.1+nmu1
'http://deb.debian.org/debian/pool/main/a/autotools-dev/autotools-dev_20180224.1%2bnmu1.dsc' autotools-dev_20180224.1+nmu1.dsc 1663 SHA256:622d1a0b778f7a6b253d37cecb0855d90feb24f15f100d909a18d247085a318c
'http://deb.debian.org/debian/pool/main/a/autotools-dev/autotools-dev_20180224.1%2bnmu1.tar.xz' autotools-dev_20180224.1+nmu1.tar.xz 68356 SHA256:f2ad12c23d0867b59568f9c7959233446c90556dededc78f588cec7468d04fd5
```

Other potentially useful URLs:

- https://sources.debian.net/src/autotools-dev/20180224.1+nmu1/ (for browsing the source)
- https://sources.debian.net/src/autotools-dev/20180224.1+nmu1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/autotools-dev/20180224.1+nmu1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `avahi=0.8-5+deb11u2`

Binary Packages:

- `libavahi-client3:amd64=0.8-5+deb11u2`
- `libavahi-common-data:amd64=0.8-5+deb11u2`
- `libavahi-common3:amd64=0.8-5+deb11u2`

Licenses: (parsed from: `/usr/share/doc/libavahi-client3/copyright`, `/usr/share/doc/libavahi-common-data/copyright`, `/usr/share/doc/libavahi-common3/copyright`)

- `GPL`
- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris avahi=0.8-5+deb11u2
'http://deb.debian.org/debian/pool/main/a/avahi/avahi_0.8-5%2bdeb11u2.dsc' avahi_0.8-5+deb11u2.dsc 3981 SHA256:528c42b897303f3f8ecb3d287516356e535ff483474fbdbfc00ed7bff9ee5aeb
'http://deb.debian.org/debian/pool/main/a/avahi/avahi_0.8.orig.tar.gz' avahi_0.8.orig.tar.gz 1591458 SHA256:060309d7a333d38d951bc27598c677af1796934dbd98e1024e7ad8de798fedda
'http://deb.debian.org/debian/pool/main/a/avahi/avahi_0.8-5%2bdeb11u2.debian.tar.xz' avahi_0.8-5+deb11u2.debian.tar.xz 37092 SHA256:f3e78ee15b344828821e9c40545f87832731e5d164f9839ddbe6487a1e63d9c6
```

Other potentially useful URLs:

- https://sources.debian.net/src/avahi/0.8-5+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/avahi/0.8-5+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/avahi/0.8-5+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `base-files=11.1+deb11u11`

Binary Packages:

- `base-files=11.1+deb11u11`

Licenses: (parsed from: `/usr/share/doc/base-files/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris base-files=11.1+deb11u11
'http://deb.debian.org/debian/pool/main/b/base-files/base-files_11.1%2bdeb11u11.dsc' base-files_11.1+deb11u11.dsc 1114 SHA256:81e0a8ba62b8ab557ac9ce0ecf85478bf34e60809b68d47cace2a1d8d6fdf158
'http://deb.debian.org/debian/pool/main/b/base-files/base-files_11.1%2bdeb11u11.tar.xz' base-files_11.1+deb11u11.tar.xz 65684 SHA256:87f49fc1bac03d063d19c580e9a6ec2eb4405c6ab18c06871159e2afdf2f3546
```

Other potentially useful URLs:

- https://sources.debian.net/src/base-files/11.1+deb11u11/ (for browsing the source)
- https://sources.debian.net/src/base-files/11.1+deb11u11/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/base-files/11.1+deb11u11/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `base-passwd=3.5.51`

Binary Packages:

- `base-passwd=3.5.51`

Licenses: (parsed from: `/usr/share/doc/base-passwd/copyright`)

- `GPL-2`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris base-passwd=3.5.51
'http://deb.debian.org/debian/pool/main/b/base-passwd/base-passwd_3.5.51.dsc' base-passwd_3.5.51.dsc 1757 SHA256:5752e4c2e3b9b4d45502f6aa5ce8dfd0136ea60f1b4fbd4524385e4bbd6a1571
'http://deb.debian.org/debian/pool/main/b/base-passwd/base-passwd_3.5.51.tar.xz' base-passwd_3.5.51.tar.xz 53980 SHA256:66c75ce1877759148dbdd2704b138c4a02adab89d7d7591b6ab184f8f614efba
```

Other potentially useful URLs:

- https://sources.debian.net/src/base-passwd/3.5.51/ (for browsing the source)
- https://sources.debian.net/src/base-passwd/3.5.51/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/base-passwd/3.5.51/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `bash=5.1-2+deb11u1`

Binary Packages:

- `bash=5.1-2+deb11u1`

Licenses: (parsed from: `/usr/share/doc/bash/copyright`)

- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris bash=5.1-2+deb11u1
'http://deb.debian.org/debian/pool/main/b/bash/bash_5.1-2%2bdeb11u1.dsc' bash_5.1-2+deb11u1.dsc 2458 SHA256:a475836201a8b2937dd83180c86ede2be07ea57ff41d02dfd639c3e08fa94045
'http://deb.debian.org/debian/pool/main/b/bash/bash_5.1.orig.tar.xz' bash_5.1.orig.tar.xz 5802740 SHA256:d5eeee4f953c09826409d572e2e8996a2140d67eb8f382ce1f3a9d23883ad696
'http://deb.debian.org/debian/pool/main/b/bash/bash_5.1-2%2bdeb11u1.debian.tar.xz' bash_5.1-2+deb11u1.debian.tar.xz 90828 SHA256:2560b99eb87dd0aa3a15b88c31cc801630cbda93d566a936b643da8dff30627b
```

Other potentially useful URLs:

- https://sources.debian.net/src/bash/5.1-2+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/bash/5.1-2+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/bash/5.1-2+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `binutils=2.35.2-2`

Binary Packages:

- `binutils=2.35.2-2`
- `binutils-common:amd64=2.35.2-2`
- `binutils-x86-64-linux-gnu=2.35.2-2`
- `libbinutils:amd64=2.35.2-2`
- `libctf-nobfd0:amd64=2.35.2-2`
- `libctf0:amd64=2.35.2-2`

Licenses: (parsed from: `/usr/share/doc/binutils/copyright`, `/usr/share/doc/binutils-common/copyright`, `/usr/share/doc/binutils-x86-64-linux-gnu/copyright`, `/usr/share/doc/libbinutils/copyright`, `/usr/share/doc/libctf-nobfd0/copyright`, `/usr/share/doc/libctf0/copyright`)

- `GFDL`
- `GPL`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris binutils=2.35.2-2
'http://deb.debian.org/debian/pool/main/b/binutils/binutils_2.35.2-2.dsc' binutils_2.35.2-2.dsc 11303 SHA256:6643177e54ce708b0aa347624018c2b9cf725aca6731142a48a655b12013a9d9
'http://deb.debian.org/debian/pool/main/b/binutils/binutils_2.35.2.orig.tar.xz' binutils_2.35.2.orig.tar.xz 23514376 SHA256:2643d99d7aba8557319a4b018f6bcae58677fc9bc853d4c2cd2eb571867b75e7
'http://deb.debian.org/debian/pool/main/b/binutils/binutils_2.35.2-2.debian.tar.xz' binutils_2.35.2-2.debian.tar.xz 101124 SHA256:96f56b4d5259be49ce4a2f27057892356f7b0aed499742cb8a07f9f62b10dcb5
```

Other potentially useful URLs:

- https://sources.debian.net/src/binutils/2.35.2-2/ (for browsing the source)
- https://sources.debian.net/src/binutils/2.35.2-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/binutils/2.35.2-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `brotli=1.0.9-2`

Binary Packages:

- `libbrotli-dev:amd64=1.0.9-2+b2`
- `libbrotli1:amd64=1.0.9-2+b2`

Licenses: (parsed from: `/usr/share/doc/libbrotli-dev/copyright`, `/usr/share/doc/libbrotli1/copyright`)

- `MIT`

Source:

```console
$ apt-get source -qq --print-uris brotli=1.0.9-2
'http://deb.debian.org/debian/pool/main/b/brotli/brotli_1.0.9-2.dsc' brotli_1.0.9-2.dsc 2261 SHA256:8c4c86748ec9770e08b60233d658593650444b04a452dc5b607ed5b5537b683e
'http://deb.debian.org/debian/pool/main/b/brotli/brotli_1.0.9.orig.tar.gz' brotli_1.0.9.orig.tar.gz 486984 SHA256:f9e8d81d0405ba66d181529af42a3354f838c939095ff99930da6aa9cdf6fe46
'http://deb.debian.org/debian/pool/main/b/brotli/brotli_1.0.9-2.debian.tar.xz' brotli_1.0.9-2.debian.tar.xz 5552 SHA256:ab81b1db852c8d01e0fa5b0b650bb486f32a232b35336828423af50af6fecca0
```

Other potentially useful URLs:

- https://sources.debian.net/src/brotli/1.0.9-2/ (for browsing the source)
- https://sources.debian.net/src/brotli/1.0.9-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/brotli/1.0.9-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `bubblewrap=0.4.1-3`

Binary Packages:

- `bubblewrap=0.4.1-3`

Licenses: (parsed from: `/usr/share/doc/bubblewrap/copyright`)

- `GPL-2+ with Autoconf exception`
- `LGPL-2`
- `LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris bubblewrap=0.4.1-3
'http://deb.debian.org/debian/pool/main/b/bubblewrap/bubblewrap_0.4.1-3.dsc' bubblewrap_0.4.1-3.dsc 2278 SHA256:2a90f3872741bc9b335fd07a06d40caf0ca61efc3f424662cc7e1a795db07ded
'http://deb.debian.org/debian/pool/main/b/bubblewrap/bubblewrap_0.4.1.orig.tar.xz' bubblewrap_0.4.1.orig.tar.xz 214496 SHA256:b9c69b9b1c61a608f34325c8e1a495229bacf6e4a07cbb0c80cf7a814d7ccc03
'http://deb.debian.org/debian/pool/main/b/bubblewrap/bubblewrap_0.4.1-3.debian.tar.xz' bubblewrap_0.4.1-3.debian.tar.xz 14108 SHA256:543a7225d1bcb2ee3b28202400e3cc1861c13eaaf48b125c5fa79424dfccec4b
```

Other potentially useful URLs:

- https://sources.debian.net/src/bubblewrap/0.4.1-3/ (for browsing the source)
- https://sources.debian.net/src/bubblewrap/0.4.1-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/bubblewrap/0.4.1-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `bzip2=1.0.8-4`

Binary Packages:

- `bzip2=1.0.8-4`
- `libbz2-1.0:amd64=1.0.8-4`
- `libbz2-dev:amd64=1.0.8-4`

Licenses: (parsed from: `/usr/share/doc/bzip2/copyright`, `/usr/share/doc/libbz2-1.0/copyright`, `/usr/share/doc/libbz2-dev/copyright`)

- `BSD-variant`
- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris bzip2=1.0.8-4
'http://deb.debian.org/debian/pool/main/b/bzip2/bzip2_1.0.8-4.dsc' bzip2_1.0.8-4.dsc 1603 SHA256:662c5e656a87db884fdc070239f5112cba1e616f20ff260de602876f70415c7b
'http://deb.debian.org/debian/pool/main/b/bzip2/bzip2_1.0.8.orig.tar.gz' bzip2_1.0.8.orig.tar.gz 810029 SHA256:ab5a03176ee106d3f0fa90e381da478ddae405918153cca248e682cd0c4a2269
'http://deb.debian.org/debian/pool/main/b/bzip2/bzip2_1.0.8-4.debian.tar.bz2' bzip2_1.0.8-4.debian.tar.bz2 26515 SHA256:3f3b26d83120260c7b2e69a5c89649bb818a79955b960fb34a5fae106f008a5d
```

Other potentially useful URLs:

- https://sources.debian.net/src/bzip2/1.0.8-4/ (for browsing the source)
- https://sources.debian.net/src/bzip2/1.0.8-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/bzip2/1.0.8-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `ca-certificates=20210119`

Binary Packages:

- `ca-certificates=20210119`

Licenses: (parsed from: `/usr/share/doc/ca-certificates/copyright`)

- `GPL-2`
- `GPL-2+`
- `MPL-2.0`

Source:

```console
$ apt-get source -qq --print-uris ca-certificates=20210119
'http://deb.debian.org/debian/pool/main/c/ca-certificates/ca-certificates_20210119.dsc' ca-certificates_20210119.dsc 1868 SHA256:51e5c099ab976f50f4d2f3c5ea0ad49853024cdb3e630322cbd7e02b05a034f4
'http://deb.debian.org/debian/pool/main/c/ca-certificates/ca-certificates_20210119.tar.xz' ca-certificates_20210119.tar.xz 232964 SHA256:daa3afae563711c30a0586ddae4336e8e3974c2b627faaca404c4e0141b64665
```

Other potentially useful URLs:

- https://sources.debian.net/src/ca-certificates/20210119/ (for browsing the source)
- https://sources.debian.net/src/ca-certificates/20210119/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/ca-certificates/20210119/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `cairo=1.16.0-5`

Binary Packages:

- `libcairo-gobject2:amd64=1.16.0-5`
- `libcairo-script-interpreter2:amd64=1.16.0-5`
- `libcairo2:amd64=1.16.0-5`
- `libcairo2-dev:amd64=1.16.0-5`

Licenses: (parsed from: `/usr/share/doc/libcairo-gobject2/copyright`, `/usr/share/doc/libcairo-script-interpreter2/copyright`, `/usr/share/doc/libcairo2/copyright`, `/usr/share/doc/libcairo2-dev/copyright`)

- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris cairo=1.16.0-5
'http://deb.debian.org/debian/pool/main/c/cairo/cairo_1.16.0-5.dsc' cairo_1.16.0-5.dsc 2939 SHA256:1bcd6dbe5544ad02170d18226ba544b96e2a48bd239407c4ee40c5eb9a441a06
'http://deb.debian.org/debian/pool/main/c/cairo/cairo_1.16.0.orig.tar.xz' cairo_1.16.0.orig.tar.xz 41997432 SHA256:5e7b29b3f113ef870d1e3ecf8adf21f923396401604bda16d44be45e66052331
'http://deb.debian.org/debian/pool/main/c/cairo/cairo_1.16.0-5.debian.tar.xz' cairo_1.16.0-5.debian.tar.xz 33144 SHA256:544726514b4b8cfdd151941714c2f910f995ddd4562e6de464c9487e9331fe9f
```

Other potentially useful URLs:

- https://sources.debian.net/src/cairo/1.16.0-5/ (for browsing the source)
- https://sources.debian.net/src/cairo/1.16.0-5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/cairo/1.16.0-5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `cdebconf=0.260`

Binary Packages:

- `libdebconfclient0:amd64=0.260`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris cdebconf=0.260
'http://deb.debian.org/debian/pool/main/c/cdebconf/cdebconf_0.260.dsc' cdebconf_0.260.dsc 2750 SHA256:0c0a3d76e19685f998e3b85834200255268f36b09eedfa9157fe0213958b7ea5
'http://deb.debian.org/debian/pool/main/c/cdebconf/cdebconf_0.260.tar.xz' cdebconf_0.260.tar.xz 279824 SHA256:ac8a9d7449c76eeaa8ed4ef0bbbf4c16b1b816b9905690c732dea2f341ac079b
```

Other potentially useful URLs:

- https://sources.debian.net/src/cdebconf/0.260/ (for browsing the source)
- https://sources.debian.net/src/cdebconf/0.260/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/cdebconf/0.260/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `cdparanoia=3.10.2+debian-13.1`

Binary Packages:

- `libcdparanoia0:amd64=3.10.2+debian-13.1`

Licenses: (parsed from: `/usr/share/doc/libcdparanoia0/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris cdparanoia=3.10.2+debian-13.1
'http://deb.debian.org/debian/pool/main/c/cdparanoia/cdparanoia_3.10.2%2bdebian-13.1.dsc' cdparanoia_3.10.2+debian-13.1.dsc 2203 SHA256:827e412ded15914f618b297115ff9d3473336825693fb951ec44f60c71b395e7
'http://deb.debian.org/debian/pool/main/c/cdparanoia/cdparanoia_3.10.2%2bdebian.orig.tar.gz' cdparanoia_3.10.2+debian.orig.tar.gz 178436 SHA256:402f8b8b4370dbdc276dfd624f768956d212893542a91ecbaa6b4206b2afef03
'http://deb.debian.org/debian/pool/main/c/cdparanoia/cdparanoia_3.10.2%2bdebian-13.1.debian.tar.xz' cdparanoia_3.10.2+debian-13.1.debian.tar.xz 61252 SHA256:c22b3094be6c026eef64091fdd3b33b0d8530fcb2d9fd445a0cadf7624b51a0b
```

Other potentially useful URLs:

- https://sources.debian.net/src/cdparanoia/3.10.2+debian-13.1/ (for browsing the source)
- https://sources.debian.net/src/cdparanoia/3.10.2+debian-13.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/cdparanoia/3.10.2+debian-13.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `colord=1.4.5-3`

Binary Packages:

- `libcolord2:amd64=1.4.5-3`

Licenses: (parsed from: `/usr/share/doc/libcolord2/copyright`)

- `CC0`
- `GFDL-NIV`
- `GPL-2`
- `GPL-2+`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris colord=1.4.5-3
'http://deb.debian.org/debian/pool/main/c/colord/colord_1.4.5-3.dsc' colord_1.4.5-3.dsc 3150 SHA256:5bf14eb1b83a51fa90b7c0b65340e43315e8a50c070b5af0aa650483db0cf675
'http://deb.debian.org/debian/pool/main/c/colord/colord_1.4.5.orig.tar.xz' colord_1.4.5.orig.tar.xz 1869084 SHA256:b774ea443d239f4a2ee1853bd678426e669ddeda413dcb71cea1638c4d6c5e17
'http://deb.debian.org/debian/pool/main/c/colord/colord_1.4.5.orig.tar.xz.asc' colord_1.4.5.orig.tar.xz.asc 488 SHA256:18f81595eb1148dca992c31856e4ab1b4edc5cfa1dcecf72b037cf5f3dd19509
'http://deb.debian.org/debian/pool/main/c/colord/colord_1.4.5-3.debian.tar.xz' colord_1.4.5-3.debian.tar.xz 30496 SHA256:07768fbfa021df60e6074704ea8b0306670233617344985202253181a3e6661b
```

Other potentially useful URLs:

- https://sources.debian.net/src/colord/1.4.5-3/ (for browsing the source)
- https://sources.debian.net/src/colord/1.4.5-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/colord/1.4.5-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `coreutils=8.32-4`

Binary Packages:

- `coreutils=8.32-4+b1`

Licenses: (parsed from: `/usr/share/doc/coreutils/copyright`)

- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris coreutils=8.32-4
'http://deb.debian.org/debian/pool/main/c/coreutils/coreutils_8.32-4.dsc' coreutils_8.32-4.dsc 2096 SHA256:ea8cafd14b693ec2d8b6e33ee8564c1fa5f102e65574252b0d524aaee04ba7e9
'http://deb.debian.org/debian/pool/main/c/coreutils/coreutils_8.32.orig.tar.xz' coreutils_8.32.orig.tar.xz 5547836 SHA256:4458d8de7849df44ccab15e16b1548b285224dbba5f08fac070c1c0e0bcc4cfa
'http://deb.debian.org/debian/pool/main/c/coreutils/coreutils_8.32.orig.tar.xz.asc' coreutils_8.32.orig.tar.xz.asc 833 SHA256:71b944375b322ba77c9c56b687b48df885c676d4fd7c465b3706713a9b62ce0a
'http://deb.debian.org/debian/pool/main/c/coreutils/coreutils_8.32-4.debian.tar.xz' coreutils_8.32-4.debian.tar.xz 33028 SHA256:2d5337067b675e0b3fa7c88df164e7738ed4715a39e88e1e82dc9185e4e1b951
```

Other potentially useful URLs:

- https://sources.debian.net/src/coreutils/8.32-4/ (for browsing the source)
- https://sources.debian.net/src/coreutils/8.32-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/coreutils/8.32-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `cryptsetup=2:2.3.7-1+deb11u1`

Binary Packages:

- `libcryptsetup12:amd64=2:2.3.7-1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libcryptsetup12/copyright`)

- `Apache-2.0`
- `CC0`
- `CC0-1.0`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with OpenSSL exception`
- `LGPL-2.1`
- `LGPL-2.1+`
- `LGPL-2.1+ with OpenSSL exception`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris cryptsetup=2:2.3.7-1+deb11u1
'http://deb.debian.org/debian/pool/main/c/cryptsetup/cryptsetup_2.3.7-1%2bdeb11u1.dsc' cryptsetup_2.3.7-1+deb11u1.dsc 2905 SHA256:b483266b87b57bcd07f670f55b2c8aa89557a97611e7fea4a287f57e32ee21a3
'http://deb.debian.org/debian/pool/main/c/cryptsetup/cryptsetup_2.3.7.orig.tar.xz' cryptsetup_2.3.7.orig.tar.xz 10852556 SHA256:545808e126c84aee06c18a9ebd1ac6ff9ca0ced4632e6bb5d3ee5cf4e048771e
'http://deb.debian.org/debian/pool/main/c/cryptsetup/cryptsetup_2.3.7-1%2bdeb11u1.debian.tar.xz' cryptsetup_2.3.7-1+deb11u1.debian.tar.xz 115516 SHA256:43ee3e3674a7faf92a694299c66bc9245b4936d0d586d6924b00b9f7ecb5e042
```

Other potentially useful URLs:

- https://sources.debian.net/src/cryptsetup/2:2.3.7-1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/cryptsetup/2:2.3.7-1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/cryptsetup/2:2.3.7-1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `cups=2.3.3op2-3+deb11u9`

Binary Packages:

- `libcups2:amd64=2.3.3op2-3+deb11u9`

Licenses: (parsed from: `/usr/share/doc/libcups2/copyright`)

- `Apache-2.0`
- `Apache-2.0-with-GPL2-LGPL2-Exception`
- `BSD-2-Clause`
- `BSD-2-clause`
- `BSD-3-clause`
- `FSFUL`
- `Zlib`

Source:

```console
$ apt-get source -qq --print-uris cups=2.3.3op2-3+deb11u9
'http://deb.debian.org/debian-security/pool/updates/main/c/cups/cups_2.3.3op2-3%2bdeb11u9.dsc' cups_2.3.3op2-3+deb11u9.dsc 3412 SHA256:09a8f0ccbb4892a8d0b06d7c92b8f94461e4c8cad8edbd86f30924c082dacd97
'http://deb.debian.org/debian-security/pool/updates/main/c/cups/cups_2.3.3op2.orig.tar.gz' cups_2.3.3op2.orig.tar.gz 7993205 SHA256:deb3575bbe79c0ae963402787f265bfcf8d804a71fc2c94318a74efec86f96df
'http://deb.debian.org/debian-security/pool/updates/main/c/cups/cups_2.3.3op2.orig.tar.gz.asc' cups_2.3.3op2.orig.tar.gz.asc 833 SHA256:ac9e7e3415d727e9882cf0f65ee38459cbcd602cb49cf392e0a65a172fe3bdaf
'http://deb.debian.org/debian-security/pool/updates/main/c/cups/cups_2.3.3op2-3%2bdeb11u9.debian.tar.xz' cups_2.3.3op2-3+deb11u9.debian.tar.xz 353784 SHA256:98653afef9f252a8c7eea1764f4d29f789866d1aedc14abefc155b544b4fce00
```

Other potentially useful URLs:

- https://sources.debian.net/src/cups/2.3.3op2-3+deb11u9/ (for browsing the source)
- https://sources.debian.net/src/cups/2.3.3op2-3+deb11u9/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/cups/2.3.3op2-3+deb11u9/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `curl=7.74.0-1.3+deb11u13`

Binary Packages:

- `curl=7.74.0-1.3+deb11u13`
- `libcurl3-gnutls:amd64=7.74.0-1.3+deb11u13`
- `libcurl4:amd64=7.74.0-1.3+deb11u13`
- `libcurl4-openssl-dev:amd64=7.74.0-1.3+deb11u13`

Licenses: (parsed from: `/usr/share/doc/curl/copyright`, `/usr/share/doc/libcurl3-gnutls/copyright`, `/usr/share/doc/libcurl4/copyright`, `/usr/share/doc/libcurl4-openssl-dev/copyright`)

- `BSD-3-Clause`
- `BSD-4-Clause`
- `ISC`
- `curl`
- `other`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris curl=7.74.0-1.3+deb11u13
'http://deb.debian.org/debian/pool/main/c/curl/curl_7.74.0-1.3%2bdeb11u13.dsc' curl_7.74.0-1.3+deb11u13.dsc 2740 SHA256:c24d188df313ef92753ab4d755cfda396095a1e374e65af70a60983bdc293e82
'http://deb.debian.org/debian/pool/main/c/curl/curl_7.74.0.orig.tar.gz' curl_7.74.0.orig.tar.gz 4043409 SHA256:e56b3921eeb7a2951959c02db0912b5fcd5fdba5aca071da819e1accf338bbd7
'http://deb.debian.org/debian/pool/main/c/curl/curl_7.74.0-1.3%2bdeb11u13.debian.tar.xz' curl_7.74.0-1.3+deb11u13.debian.tar.xz 76768 SHA256:30c92557142bb7d16b3a877e932d125d02142d6f7cc4984d92b0d4a015caea23
```

Other potentially useful URLs:

- https://sources.debian.net/src/curl/7.74.0-1.3+deb11u13/ (for browsing the source)
- https://sources.debian.net/src/curl/7.74.0-1.3+deb11u13/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/curl/7.74.0-1.3+deb11u13/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `cyrus-sasl2=2.1.27+dfsg-2.1+deb11u1`

Binary Packages:

- `libsasl2-2:amd64=2.1.27+dfsg-2.1+deb11u1`
- `libsasl2-modules-db:amd64=2.1.27+dfsg-2.1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libsasl2-2/copyright`, `/usr/share/doc/libsasl2-modules-db/copyright`)

- `BSD-4-clause`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris cyrus-sasl2=2.1.27+dfsg-2.1+deb11u1
'http://deb.debian.org/debian/pool/main/c/cyrus-sasl2/cyrus-sasl2_2.1.27%2bdfsg-2.1%2bdeb11u1.dsc' cyrus-sasl2_2.1.27+dfsg-2.1+deb11u1.dsc 3591 SHA256:4dafa1a5c90f0b3d9d6e9d22e810492edd3b91b9f1d4d9666683d257528445d6
'http://deb.debian.org/debian/pool/main/c/cyrus-sasl2/cyrus-sasl2_2.1.27%2bdfsg.orig.tar.xz' cyrus-sasl2_2.1.27+dfsg.orig.tar.xz 2058596 SHA256:108b0c691c423837264f05abb559ea76c3dfdd91246555e8abe87c129a6e37cd
'http://deb.debian.org/debian/pool/main/c/cyrus-sasl2/cyrus-sasl2_2.1.27%2bdfsg-2.1%2bdeb11u1.debian.tar.xz' cyrus-sasl2_2.1.27+dfsg-2.1+deb11u1.debian.tar.xz 102488 SHA256:70b7a55776febf987363f5bb58322d6f03186215374a2eb0b6203980924f8680
```

Other potentially useful URLs:

- https://sources.debian.net/src/cyrus-sasl2/2.1.27+dfsg-2.1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/cyrus-sasl2/2.1.27+dfsg-2.1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/cyrus-sasl2/2.1.27+dfsg-2.1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `dash=0.5.11+git20200708+dd9ef66-5`

Binary Packages:

- `dash=0.5.11+git20200708+dd9ef66-5`

Licenses: (parsed from: `/usr/share/doc/dash/copyright`)

- `BSD-3-Clause`
- `BSD-3-clause`
- `Expat`
- `FSFUL`
- `FSFULLR`
- `GPL-2`
- `GPL-2+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris dash=0.5.11+git20200708+dd9ef66-5
'http://deb.debian.org/debian/pool/main/d/dash/dash_0.5.11%2bgit20200708%2bdd9ef66-5.dsc' dash_0.5.11+git20200708+dd9ef66-5.dsc 1906 SHA256:b0568c34647dc2aa0b8e2656c5e7449d9a1feb4b89d6857f507173b1f9a42ee7
'http://deb.debian.org/debian/pool/main/d/dash/dash_0.5.11%2bgit20200708%2bdd9ef66.orig.tar.gz' dash_0.5.11+git20200708+dd9ef66.orig.tar.gz 167776 SHA256:ab70b1f165bfedadd1282da546f1c917f1b7ccb2c5c2f898310a963e2ab5520c
'http://deb.debian.org/debian/pool/main/d/dash/dash_0.5.11%2bgit20200708%2bdd9ef66-5.debian.tar.xz' dash_0.5.11+git20200708+dd9ef66-5.debian.tar.xz 43120 SHA256:5da6039e043c953ff91a31c767ed703699870682ff356a1642f4798ce04a2926
```

Other potentially useful URLs:

- https://sources.debian.net/src/dash/0.5.11+git20200708+dd9ef66-5/ (for browsing the source)
- https://sources.debian.net/src/dash/0.5.11+git20200708+dd9ef66-5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/dash/0.5.11+git20200708+dd9ef66-5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `dav1d=0.7.1-3+deb11u1`

Binary Packages:

- `libdav1d4:amd64=0.7.1-3+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libdav1d4/copyright`)

- `BSD-2-clause`
- `ISC`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris dav1d=0.7.1-3+deb11u1
'http://deb.debian.org/debian/pool/main/d/dav1d/dav1d_0.7.1-3%2bdeb11u1.dsc' dav1d_0.7.1-3+deb11u1.dsc 2339 SHA256:bb60280e92a6032a4c725c7d4c4b216900989f3576ddcdfc8823d374285785bb
'http://deb.debian.org/debian/pool/main/d/dav1d/dav1d_0.7.1.orig.tar.xz' dav1d_0.7.1.orig.tar.xz 549068 SHA256:3334b5d05ec00b0745f94e2c57e23f1874197c4b435a6656cc65af531e73d3c2
'http://deb.debian.org/debian/pool/main/d/dav1d/dav1d_0.7.1.orig.tar.xz.asc' dav1d_0.7.1.orig.tar.xz.asc 195 SHA256:f31a28a99c5c0d8018b8ec46f7c01481d2c8d87a752d257a154860892a8c5f3b
'http://deb.debian.org/debian/pool/main/d/dav1d/dav1d_0.7.1-3%2bdeb11u1.debian.tar.xz' dav1d_0.7.1-3+deb11u1.debian.tar.xz 8684 SHA256:0d52f0f3b1285a0f1a781a7571afd9c0364639f81b779b3ed3b041e90753c1cf
```

Other potentially useful URLs:

- https://sources.debian.net/src/dav1d/0.7.1-3+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/dav1d/0.7.1-3+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/dav1d/0.7.1-3+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `db-defaults=5.3.1+nmu1`

Binary Packages:

- `libdb-dev:amd64=5.3.1+nmu1`

Licenses: (parsed from: `/usr/share/doc/libdb-dev/copyright`)

- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris db-defaults=5.3.1+nmu1
'http://deb.debian.org/debian/pool/main/d/db-defaults/db-defaults_5.3.1%2bnmu1.dsc' db-defaults_5.3.1+nmu1.dsc 1598 SHA256:908f749faf9e8c20638dff514b225c48b163613cad556beb9a54513cb3a249f3
'http://deb.debian.org/debian/pool/main/d/db-defaults/db-defaults_5.3.1%2bnmu1.tar.xz' db-defaults_5.3.1+nmu1.tar.xz 2864 SHA256:e1e6993f7ae1d055624392a8759b220e21ab7e1c96dba622139c6aaa340c1738
```

Other potentially useful URLs:

- https://sources.debian.net/src/db-defaults/5.3.1+nmu1/ (for browsing the source)
- https://sources.debian.net/src/db-defaults/5.3.1+nmu1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/db-defaults/5.3.1+nmu1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `db5.3=5.3.28+dfsg1-0.8`

Binary Packages:

- `libdb5.3:amd64=5.3.28+dfsg1-0.8`
- `libdb5.3-dev=5.3.28+dfsg1-0.8`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris db5.3=5.3.28+dfsg1-0.8
'http://deb.debian.org/debian/pool/main/d/db5.3/db5.3_5.3.28%2bdfsg1-0.8.dsc' db5.3_5.3.28+dfsg1-0.8.dsc 3113 SHA256:5189bebd157e3b51c075804d1affebc87cdbfb782808c621e131660719c24374
'http://deb.debian.org/debian/pool/main/d/db5.3/db5.3_5.3.28%2bdfsg1.orig.tar.xz' db5.3_5.3.28+dfsg1.orig.tar.xz 19723860 SHA256:b19bf3dd8ce74b95a7b215be9a7c8489e8e8f18da60d64d6340a06e75f497749
'http://deb.debian.org/debian/pool/main/d/db5.3/db5.3_5.3.28%2bdfsg1-0.8.debian.tar.xz' db5.3_5.3.28+dfsg1-0.8.debian.tar.xz 30748 SHA256:073c0c87283bf5e606f3ce6d1814315b40b9685c943601ae3fd81e2da4e612d4
```

Other potentially useful URLs:

- https://sources.debian.net/src/db5.3/5.3.28+dfsg1-0.8/ (for browsing the source)
- https://sources.debian.net/src/db5.3/5.3.28+dfsg1-0.8/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/db5.3/5.3.28+dfsg1-0.8/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `dbus=1.12.28-0+deb11u1`

Binary Packages:

- `dbus=1.12.28-0+deb11u1`
- `dbus-user-session=1.12.28-0+deb11u1`
- `libdbus-1-3:amd64=1.12.28-0+deb11u1`

Licenses: (parsed from: `/usr/share/doc/dbus/copyright`, `/usr/share/doc/dbus-user-session/copyright`, `/usr/share/doc/libdbus-1-3/copyright`)

- `AFL-2.1`
- `AFL-2.1,`
- `BSD-3-clause`
- `BSD-3-clause-generic`
- `Expat`
- `GPL-2`
- `GPL-2+`
- `Tcl-BSDish`
- `g10-permissive`

Source:

```console
$ apt-get source -qq --print-uris dbus=1.12.28-0+deb11u1
'http://deb.debian.org/debian/pool/main/d/dbus/dbus_1.12.28-0%2bdeb11u1.dsc' dbus_1.12.28-0+deb11u1.dsc 3578 SHA256:8825b2fde7de4a5b4ac600db7cc3c7fa2c347ad0c41fc115294afa3064c2b84e
'http://deb.debian.org/debian/pool/main/d/dbus/dbus_1.12.28.orig.tar.gz' dbus_1.12.28.orig.tar.gz 2122182 SHA256:9da1e3f2b73f75eec0a9e4509d64be43909d1f2853fe809528a0a53984d76420
'http://deb.debian.org/debian/pool/main/d/dbus/dbus_1.12.28.orig.tar.gz.asc' dbus_1.12.28.orig.tar.gz.asc 833 SHA256:3f6c19d8c063459682d49d4bf74fc0d13290664ae966f612f118f4d4a73ddaab
'http://deb.debian.org/debian/pool/main/d/dbus/dbus_1.12.28-0%2bdeb11u1.debian.tar.xz' dbus_1.12.28-0+deb11u1.debian.tar.xz 58556 SHA256:b07222a653b330e8f81e3642209f2cb7fb1dba3f8207c755b146d657767fbb48
```

Other potentially useful URLs:

- https://sources.debian.net/src/dbus/1.12.28-0+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/dbus/1.12.28-0+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/dbus/1.12.28-0+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `dconf=0.38.0-2`

Binary Packages:

- `dconf-gsettings-backend:amd64=0.38.0-2`
- `dconf-service=0.38.0-2`
- `libdconf1:amd64=0.38.0-2`

Licenses: (parsed from: `/usr/share/doc/dconf-gsettings-backend/copyright`, `/usr/share/doc/dconf-service/copyright`, `/usr/share/doc/libdconf1/copyright`)

- `GPL-3`
- `LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris dconf=0.38.0-2
'http://deb.debian.org/debian/pool/main/d/dconf/dconf_0.38.0-2.dsc' dconf_0.38.0-2.dsc 2740 SHA256:808e980567c6fa53920d89263b7496d7473d8d6a7a6346b2288abcabf897bbba
'http://deb.debian.org/debian/pool/main/d/dconf/dconf_0.38.0.orig.tar.xz' dconf_0.38.0.orig.tar.xz 115876 SHA256:45f60f41330d27715cce1315af123f94f1c2cdedb68b6bed3b309866eec44f58
'http://deb.debian.org/debian/pool/main/d/dconf/dconf_0.38.0-2.debian.tar.xz' dconf_0.38.0-2.debian.tar.xz 10584 SHA256:410e31fa71e5cd14289a5b6d72b5ac3a8ae365257c28fd8662b85601ecfe8819
```

Other potentially useful URLs:

- https://sources.debian.net/src/dconf/0.38.0-2/ (for browsing the source)
- https://sources.debian.net/src/dconf/0.38.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/dconf/0.38.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `debconf=1.5.77`

Binary Packages:

- `debconf=1.5.77`

Licenses: (parsed from: `/usr/share/doc/debconf/copyright`)

- `BSD-2-clause`

Source:

```console
$ apt-get source -qq --print-uris debconf=1.5.77
'http://deb.debian.org/debian/pool/main/d/debconf/debconf_1.5.77.dsc' debconf_1.5.77.dsc 2082 SHA256:2797e40ac2122a0ca6c1aa27bd63203e9da4342bb60e614efb848452a5696e41
'http://deb.debian.org/debian/pool/main/d/debconf/debconf_1.5.77.tar.xz' debconf_1.5.77.tar.xz 571412 SHA256:03482934c645140dd4cb8cae4970f81f576995b757ac7b89192067e72aa1d067
```

Other potentially useful URLs:

- https://sources.debian.net/src/debconf/1.5.77/ (for browsing the source)
- https://sources.debian.net/src/debconf/1.5.77/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/debconf/1.5.77/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `debian-archive-keyring=2021.1.1+deb11u1`

Binary Packages:

- `debian-archive-keyring=2021.1.1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/debian-archive-keyring/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris debian-archive-keyring=2021.1.1+deb11u1
'http://deb.debian.org/debian/pool/main/d/debian-archive-keyring/debian-archive-keyring_2021.1.1%2bdeb11u1.dsc' debian-archive-keyring_2021.1.1+deb11u1.dsc 1301 SHA256:afde187bdb36b807ab71eb0a5803d35a0a19265ff9ca47cb140f9f26aef2d6dd
'http://deb.debian.org/debian/pool/main/d/debian-archive-keyring/debian-archive-keyring_2021.1.1%2bdeb11u1.tar.xz' debian-archive-keyring_2021.1.1+deb11u1.tar.xz 174768 SHA256:7beff096d7293d019de8007d3425dbbcb18009b5780e6d0e172f57f5b6b300ae
```

Other potentially useful URLs:

- https://sources.debian.net/src/debian-archive-keyring/2021.1.1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/debian-archive-keyring/2021.1.1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/debian-archive-keyring/2021.1.1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `debianutils=4.11.2`

Binary Packages:

- `debianutils=4.11.2`

Licenses: (parsed from: `/usr/share/doc/debianutils/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris debianutils=4.11.2
'http://deb.debian.org/debian/pool/main/d/debianutils/debianutils_4.11.2.dsc' debianutils_4.11.2.dsc 1644 SHA256:b11164a7aa3ca07ae1d758d15d707928defb64f2c35bf96f2e4fd983ee17b310
'http://deb.debian.org/debian/pool/main/d/debianutils/debianutils_4.11.2.tar.xz' debianutils_4.11.2.tar.xz 158132 SHA256:3b680e81709b740387335fac8f8806d71611dcf60874e1a792e862e48a1650de
```

Other potentially useful URLs:

- https://sources.debian.net/src/debianutils/4.11.2/ (for browsing the source)
- https://sources.debian.net/src/debianutils/4.11.2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/debianutils/4.11.2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `dictionaries-common=1.28.4`

Binary Packages:

- `dictionaries-common=1.28.4`

Licenses: (parsed from: `/usr/share/doc/dictionaries-common/copyright`)

- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris dictionaries-common=1.28.4
'http://deb.debian.org/debian/pool/main/d/dictionaries-common/dictionaries-common_1.28.4.dsc' dictionaries-common_1.28.4.dsc 1902 SHA256:cf293191d12825be62d6d572143de199ea2ffac1efc22647a4564cfcef7c680d
'http://deb.debian.org/debian/pool/main/d/dictionaries-common/dictionaries-common_1.28.4.tar.xz' dictionaries-common_1.28.4.tar.xz 284224 SHA256:6c5a9cb4b6ad8e61cd856273cbcad0f36343d55cd43fc5c8eba44414744bafb4
```

Other potentially useful URLs:

- https://sources.debian.net/src/dictionaries-common/1.28.4/ (for browsing the source)
- https://sources.debian.net/src/dictionaries-common/1.28.4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/dictionaries-common/1.28.4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `diffutils=1:3.7-5`

Binary Packages:

- `diffutils=1:3.7-5`

Licenses: (parsed from: `/usr/share/doc/diffutils/copyright`)

- `GFDL`
- `GPL`

Source:

```console
$ apt-get source -qq --print-uris diffutils=1:3.7-5
'http://deb.debian.org/debian/pool/main/d/diffutils/diffutils_3.7-5.dsc' diffutils_3.7-5.dsc 1714 SHA256:5476ed004e300f291b5f0a356074a8ba8944a8b34514bb0fe95d274455adbf5d
'http://deb.debian.org/debian/pool/main/d/diffutils/diffutils_3.7.orig.tar.xz' diffutils_3.7.orig.tar.xz 1448828 SHA256:b3a7a6221c3dc916085f0d205abf6b8e1ba443d4dd965118da364a1dc1cb3a26
'http://deb.debian.org/debian/pool/main/d/diffutils/diffutils_3.7.orig.tar.xz.asc' diffutils_3.7.orig.tar.xz.asc 833 SHA256:c89b9d60a1d67cf8b2dd108a8b918e4cce34cba6c9e1f67e2ca482c52c0258a7
'http://deb.debian.org/debian/pool/main/d/diffutils/diffutils_3.7-5.debian.tar.xz' diffutils_3.7-5.debian.tar.xz 89004 SHA256:c90fd39d677702226b89d7559c124d7eb0b88195c381853ca1e5c8ca08e90a3a
```

Other potentially useful URLs:

- https://sources.debian.net/src/diffutils/1:3.7-5/ (for browsing the source)
- https://sources.debian.net/src/diffutils/1:3.7-5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/diffutils/1:3.7-5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `djvulibre=3.5.28-2`

Binary Packages:

- `libdjvulibre-dev:amd64=3.5.28-2`
- `libdjvulibre-text=3.5.28-2`
- `libdjvulibre21:amd64=3.5.28-2`

Licenses: (parsed from: `/usr/share/doc/libdjvulibre-dev/copyright`, `/usr/share/doc/libdjvulibre-text/copyright`, `/usr/share/doc/libdjvulibre21/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris djvulibre=3.5.28-2
'http://deb.debian.org/debian/pool/main/d/djvulibre/djvulibre_3.5.28-2.dsc' djvulibre_3.5.28-2.dsc 2388 SHA256:0b5f31e70a8f81afec47e67e9465dbece7756f0c7f88da643f0dda82bf78a1ba
'http://deb.debian.org/debian/pool/main/d/djvulibre/djvulibre_3.5.28.orig.tar.xz' djvulibre_3.5.28.orig.tar.xz 2959024 SHA256:1223b7bf7c8dfe2e290882f3bfb88ba2468b30495a1bf8dfd54dc7e810987887
'http://deb.debian.org/debian/pool/main/d/djvulibre/djvulibre_3.5.28-2.debian.tar.xz' djvulibre_3.5.28-2.debian.tar.xz 17420 SHA256:6f85dcd7cdb856cc3e4a31fc381e73a6cab717c90e058f474fb4d2ab29635d91
```

Other potentially useful URLs:

- https://sources.debian.net/src/djvulibre/3.5.28-2/ (for browsing the source)
- https://sources.debian.net/src/djvulibre/3.5.28-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/djvulibre/3.5.28-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `dpkg=1.20.13`

Binary Packages:

- `dpkg=1.20.13`
- `dpkg-dev=1.20.13`
- `libdpkg-perl=1.20.13`

Licenses: (parsed from: `/usr/share/doc/dpkg/copyright`, `/usr/share/doc/dpkg-dev/copyright`, `/usr/share/doc/libdpkg-perl/copyright`)

- `BSD-2-clause`
- `GPL-2`
- `GPL-2+`
- `public-domain-md5`
- `public-domain-s-s-d`

Source:

```console
$ apt-get source -qq --print-uris dpkg=1.20.13
'http://deb.debian.org/debian/pool/main/d/dpkg/dpkg_1.20.13.dsc' dpkg_1.20.13.dsc 2124 SHA256:fa618098428084fc5411f809bbc33922e126e4fefadfa525bfa6a1b0d09c863f
'http://deb.debian.org/debian/pool/main/d/dpkg/dpkg_1.20.13.tar.xz' dpkg_1.20.13.tar.xz 5009848 SHA256:d2aa90535d750b20d1f40827344d74bb552ee5d40d3c24603496fd438f15424d
```

Other potentially useful URLs:

- https://sources.debian.net/src/dpkg/1.20.13/ (for browsing the source)
- https://sources.debian.net/src/dpkg/1.20.13/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/dpkg/1.20.13/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `e2fsprogs=1.46.2-2+deb11u1`

Binary Packages:

- `comerr-dev:amd64=2.1-1.46.2-2+deb11u1`
- `e2fsprogs=1.46.2-2+deb11u1`
- `libcom-err2:amd64=1.46.2-2+deb11u1`
- `libext2fs2:amd64=1.46.2-2+deb11u1`
- `libss2:amd64=1.46.2-2+deb11u1`
- `logsave=1.46.2-2+deb11u1`

Licenses: (parsed from: `/usr/share/doc/comerr-dev/copyright`, `/usr/share/doc/e2fsprogs/copyright`, `/usr/share/doc/libcom-err2/copyright`, `/usr/share/doc/libext2fs2/copyright`, `/usr/share/doc/libss2/copyright`, `/usr/share/doc/logsave/copyright`)

- `GPL-2`
- `LGPL-2`

Source:

```console
$ apt-get source -qq --print-uris e2fsprogs=1.46.2-2+deb11u1
'http://deb.debian.org/debian-security/pool/updates/main/e/e2fsprogs/e2fsprogs_1.46.2-2%2bdeb11u1.dsc' e2fsprogs_1.46.2-2+deb11u1.dsc 3103 SHA256:18f4d571c97a50bf4f5139e707320b49973e1bd2131b38442784bacc8e080fd4
'http://deb.debian.org/debian-security/pool/updates/main/e/e2fsprogs/e2fsprogs_1.46.2.orig.tar.gz' e2fsprogs_1.46.2.orig.tar.gz 9496954 SHA256:f79f26b4f65bdc059fca12e1ec6a3040c3ce1a503fb70eb915bee71903815cd5
'http://deb.debian.org/debian-security/pool/updates/main/e/e2fsprogs/e2fsprogs_1.46.2.orig.tar.gz.asc' e2fsprogs_1.46.2.orig.tar.gz.asc 488 SHA256:948552550f23a9e0223cecb51b5b85258c9d94895a20bce1180fce770628a55f
'http://deb.debian.org/debian-security/pool/updates/main/e/e2fsprogs/e2fsprogs_1.46.2-2%2bdeb11u1.debian.tar.xz' e2fsprogs_1.46.2-2+deb11u1.debian.tar.xz 93408 SHA256:48b50e91479754043fe442c0bdd4ba7cddc8e5b2ff0b93ca001b1a6b05067b80
```

Other potentially useful URLs:

- https://sources.debian.net/src/e2fsprogs/1.46.2-2+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/e2fsprogs/1.46.2-2+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/e2fsprogs/1.46.2-2+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `elfutils=0.183-1`

Binary Packages:

- `libdw1:amd64=0.183-1`
- `libelf1:amd64=0.183-1`

Licenses: (parsed from: `/usr/share/doc/libdw1/copyright`, `/usr/share/doc/libelf1/copyright`)

- `GPL-2`
- `GPL-3`
- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris elfutils=0.183-1
'http://deb.debian.org/debian/pool/main/e/elfutils/elfutils_0.183-1.dsc' elfutils_0.183-1.dsc 3036 SHA256:540e9b9c5d25d8567cb8e82444baef433fc4add627b4ce09185a9527a33113af
'http://deb.debian.org/debian/pool/main/e/elfutils/elfutils_0.183.orig.tar.bz2' elfutils_0.183.orig.tar.bz2 9109254 SHA256:c3637c208d309d58714a51e61e63f1958808fead882e9b607506a29e5474f2c5
'http://deb.debian.org/debian/pool/main/e/elfutils/elfutils_0.183-1.debian.tar.xz' elfutils_0.183-1.debian.tar.xz 33396 SHA256:e64d82677a9f12344210f2294f8738ce649fbac0ebec20f2354f39d8bd4698ce
```

Other potentially useful URLs:

- https://sources.debian.net/src/elfutils/0.183-1/ (for browsing the source)
- https://sources.debian.net/src/elfutils/0.183-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/elfutils/0.183-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `emacsen-common=3.0.4`

Binary Packages:

- `emacsen-common=3.0.4`

Licenses: (parsed from: `/usr/share/doc/emacsen-common/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris emacsen-common=3.0.4
'http://deb.debian.org/debian/pool/main/e/emacsen-common/emacsen-common_3.0.4.dsc' emacsen-common_3.0.4.dsc 1463 SHA256:4c8ee0308972bb43213f1efa68bcca1a90766a836b85f394c9e73fef4de9e83d
'http://deb.debian.org/debian/pool/main/e/emacsen-common/emacsen-common_3.0.4.tar.xz' emacsen-common_3.0.4.tar.xz 16292 SHA256:b20c7202b3553bbbe03290a61087ed10afa52edf407334ca8a7787ef0a876600
```

Other potentially useful URLs:

- https://sources.debian.net/src/emacsen-common/3.0.4/ (for browsing the source)
- https://sources.debian.net/src/emacsen-common/3.0.4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/emacsen-common/3.0.4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `enchant-2=2.2.15-1`

Binary Packages:

- `libenchant-2-2:amd64=2.2.15-1`

Licenses: (parsed from: `/usr/share/doc/libenchant-2-2/copyright`)

- `Expat`
- `FSFAP`
- `GPL-2`
- `GPL-2.0+`
- `GPL-3`
- `GPL-3.0+`
- `LGPL-2`
- `LGPL-2.0+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `LGPL-3`
- `LGPL-3.0+`

Source:

```console
$ apt-get source -qq --print-uris enchant-2=2.2.15-1
'http://deb.debian.org/debian/pool/main/e/enchant-2/enchant-2_2.2.15-1.dsc' enchant-2_2.2.15-1.dsc 2324 SHA256:80317351c6c89d5451314a0c359723109492feb606e1e5ea2eabd07fbb7c08be
'http://deb.debian.org/debian/pool/main/e/enchant-2/enchant-2_2.2.15.orig.tar.gz' enchant-2_2.2.15.orig.tar.gz 990693 SHA256:3b0f2215578115f28e2a6aa549b35128600394304bd79d6f28b0d3b3d6f46c03
'http://deb.debian.org/debian/pool/main/e/enchant-2/enchant-2_2.2.15-1.debian.tar.xz' enchant-2_2.2.15-1.debian.tar.xz 9864 SHA256:e48775b1408976c2ee74d21955aeb86fd347893853f15b440da1b5e53028f1a2
```

Other potentially useful URLs:

- https://sources.debian.net/src/enchant-2/2.2.15-1/ (for browsing the source)
- https://sources.debian.net/src/enchant-2/2.2.15-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/enchant-2/2.2.15-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `expat=2.2.10-2+deb11u6`

Binary Packages:

- `libexpat1:amd64=2.2.10-2+deb11u6`
- `libexpat1-dev:amd64=2.2.10-2+deb11u6`

Licenses: (parsed from: `/usr/share/doc/libexpat1/copyright`, `/usr/share/doc/libexpat1-dev/copyright`)

- `MIT`

Source:

```console
$ apt-get source -qq --print-uris expat=2.2.10-2+deb11u6
'http://deb.debian.org/debian-security/pool/updates/main/e/expat/expat_2.2.10-2%2bdeb11u6.dsc' expat_2.2.10-2+deb11u6.dsc 2020 SHA256:7227fe4cce0d7b0d43bab1d5662cf060fbd8fabe9e82a36827a9265a29ee2a5a
'http://deb.debian.org/debian-security/pool/updates/main/e/expat/expat_2.2.10.orig.tar.gz' expat_2.2.10.orig.tar.gz 8276395 SHA256:62e280f5fd29a5b70973f623e20a7412c3e3912c2684cb0e462e2c881be129e1
'http://deb.debian.org/debian-security/pool/updates/main/e/expat/expat_2.2.10-2%2bdeb11u6.debian.tar.xz' expat_2.2.10-2+deb11u6.debian.tar.xz 67904 SHA256:74ea952e8094b333125dde907c29618724946cef660828d1f48d1bfc3bef574d
```

Other potentially useful URLs:

- https://sources.debian.net/src/expat/2.2.10-2+deb11u6/ (for browsing the source)
- https://sources.debian.net/src/expat/2.2.10-2+deb11u6/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/expat/2.2.10-2+deb11u6/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `fftw3=3.3.8-2`

Binary Packages:

- `libfftw3-double3:amd64=3.3.8-2`

Licenses: (parsed from: `/usr/share/doc/libfftw3-double3/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris fftw3=3.3.8-2
'http://deb.debian.org/debian/pool/main/f/fftw3/fftw3_3.3.8-2.dsc' fftw3_3.3.8-2.dsc 2978 SHA256:b4367efbcc2bbbc44b62a9416a1c37764f5214628632553070c35893df786f68
'http://deb.debian.org/debian/pool/main/f/fftw3/fftw3_3.3.8.orig.tar.gz' fftw3_3.3.8.orig.tar.gz 4110137 SHA256:6113262f6e92c5bd474f2875fa1b01054c4ad5040f6b0da7c03c98821d9ae303
'http://deb.debian.org/debian/pool/main/f/fftw3/fftw3_3.3.8-2.debian.tar.xz' fftw3_3.3.8-2.debian.tar.xz 13696 SHA256:684dede6b4124f309033d128dc7bdf1eb394984e6e8dd79e1fd5d73b95b12461
```

Other potentially useful URLs:

- https://sources.debian.net/src/fftw3/3.3.8-2/ (for browsing the source)
- https://sources.debian.net/src/fftw3/3.3.8-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/fftw3/3.3.8-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `file=1:5.39-3+deb11u1`

Binary Packages:

- `file=1:5.39-3+deb11u1`
- `libmagic-mgc=1:5.39-3+deb11u1`
- `libmagic1:amd64=1:5.39-3+deb11u1`

Licenses: (parsed from: `/usr/share/doc/file/copyright`, `/usr/share/doc/libmagic-mgc/copyright`, `/usr/share/doc/libmagic1/copyright`)

- `BSD-2-Clause-alike`
- `BSD-2-Clause-netbsd`
- `BSD-2-Clause-regents`
- `MIT-Old-Style-with-legal-disclaimer-2`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris file=1:5.39-3+deb11u1
'http://deb.debian.org/debian/pool/main/f/file/file_5.39-3%2bdeb11u1.dsc' file_5.39-3+deb11u1.dsc 2424 SHA256:b08cfd706099600aa634d3cdcc2a7461908902414ae8cbfd1caddf557983e4e8
'http://deb.debian.org/debian/pool/main/f/file/file_5.39.orig.tar.gz' file_5.39.orig.tar.gz 954266 SHA256:f05d286a76d9556243d0cb05814929c2ecf3a5ba07963f8f70bfaaa70517fad1
'http://deb.debian.org/debian/pool/main/f/file/file_5.39.orig.tar.gz.asc' file_5.39.orig.tar.gz.asc 169 SHA256:409232b54cabe3082f38f1e7ec4c69e7d937f26d039da691f7349d142b48df83
'http://deb.debian.org/debian/pool/main/f/file/file_5.39-3%2bdeb11u1.debian.tar.xz' file_5.39-3+deb11u1.debian.tar.xz 34816 SHA256:c4ef624328d06f6128d808fd0edc14b1d856d6fefe0f29dfcae0ce30b42de0a3
```

Other potentially useful URLs:

- https://sources.debian.net/src/file/1:5.39-3+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/file/1:5.39-3+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/file/1:5.39-3+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `findutils=4.8.0-1`

Binary Packages:

- `findutils=4.8.0-1`

Licenses: (parsed from: `/usr/share/doc/findutils/copyright`)

- `GFDL-1.3`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris findutils=4.8.0-1
'http://deb.debian.org/debian/pool/main/f/findutils/findutils_4.8.0-1.dsc' findutils_4.8.0-1.dsc 2302 SHA256:47f342ec5146f4138f5004dbefe5838656057b502dfe225884b9f56840e29a3b
'http://deb.debian.org/debian/pool/main/f/findutils/findutils_4.8.0.orig.tar.xz' findutils_4.8.0.orig.tar.xz 1983096 SHA256:57127b7e97d91282c6ace556378d5455a9509898297e46e10443016ea1387164
'http://deb.debian.org/debian/pool/main/f/findutils/findutils_4.8.0.orig.tar.xz.asc' findutils_4.8.0.orig.tar.xz.asc 488 SHA256:dc0d5251026532d2b115e447eea70a934d3df6a0efcaf225c9d585eeedeefe62
'http://deb.debian.org/debian/pool/main/f/findutils/findutils_4.8.0-1.debian.tar.xz' findutils_4.8.0-1.debian.tar.xz 27296 SHA256:c99753f13f9e79653f79a398d1aafb15294c8f7953ad86948c7bf4cb0032bb43
```

Other potentially useful URLs:

- https://sources.debian.net/src/findutils/4.8.0-1/ (for browsing the source)
- https://sources.debian.net/src/findutils/4.8.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/findutils/4.8.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `flac=1.3.3-2+deb11u2`

Binary Packages:

- `libflac8:amd64=1.3.3-2+deb11u2`

Licenses: (parsed from: `/usr/share/doc/libflac8/copyright`)

- `BSD-3-clause`
- `GFDL-1.1+`
- `GFDL-1.2`
- `GPL-2`
- `GPL-2+`
- `ISC`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `Public-domain`

Source:

```console
$ apt-get source -qq --print-uris flac=1.3.3-2+deb11u2
'http://deb.debian.org/debian/pool/main/f/flac/flac_1.3.3-2%2bdeb11u2.dsc' flac_1.3.3-2+deb11u2.dsc 2273 SHA256:127723d2a731d1131d81610a6cbc98e6534b77ef9951468838935f95ab5e5dfb
'http://deb.debian.org/debian/pool/main/f/flac/flac_1.3.3.orig.tar.xz' flac_1.3.3.orig.tar.xz 1044472 SHA256:213e82bd716c9de6db2f98bcadbc4c24c7e2efe8c75939a1a84e28539c4e1748
'http://deb.debian.org/debian/pool/main/f/flac/flac_1.3.3-2%2bdeb11u2.debian.tar.xz' flac_1.3.3-2+deb11u2.debian.tar.xz 19688 SHA256:875938bd49147c0bb9a48dc6da117b8a8835cf9d3585a28254c6f72eaf8c9bac
```

Other potentially useful URLs:

- https://sources.debian.net/src/flac/1.3.3-2+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/flac/1.3.3-2+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/flac/1.3.3-2+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `fontconfig=2.13.1-4.2`

Binary Packages:

- `fontconfig=2.13.1-4.2`
- `fontconfig-config=2.13.1-4.2`
- `libfontconfig-dev:amd64=2.13.1-4.2`
- `libfontconfig1:amd64=2.13.1-4.2`
- `libfontconfig1-dev:amd64=2.13.1-4.2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris fontconfig=2.13.1-4.2
'http://deb.debian.org/debian/pool/main/f/fontconfig/fontconfig_2.13.1-4.2.dsc' fontconfig_2.13.1-4.2.dsc 2716 SHA256:d22e6441f0aa03b569d886fbb3227330dd2305e7aa10513e177ced28b8b52d63
'http://deb.debian.org/debian/pool/main/f/fontconfig/fontconfig_2.13.1.orig.tar.bz2' fontconfig_2.13.1.orig.tar.bz2 1723639 SHA256:f655dd2a986d7aa97e052261b36aa67b0a64989496361eca8d604e6414006741
'http://deb.debian.org/debian/pool/main/f/fontconfig/fontconfig_2.13.1-4.2.debian.tar.xz' fontconfig_2.13.1-4.2.debian.tar.xz 55124 SHA256:f1ec69a2a0affd86189d3b75ced77b30bbcbc3a6fc0508490e570d4786464b58
```

Other potentially useful URLs:

- https://sources.debian.net/src/fontconfig/2.13.1-4.2/ (for browsing the source)
- https://sources.debian.net/src/fontconfig/2.13.1-4.2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/fontconfig/2.13.1-4.2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `fonts-dejavu=2.37-2`

Binary Packages:

- `fonts-dejavu-core=2.37-2`

Licenses: (parsed from: `/usr/share/doc/fonts-dejavu-core/copyright`)

- `GPL-2`
- `GPL-2+`
- `bitstream-vera`

Source:

```console
$ apt-get source -qq --print-uris fonts-dejavu=2.37-2
'http://deb.debian.org/debian/pool/main/f/fonts-dejavu/fonts-dejavu_2.37-2.dsc' fonts-dejavu_2.37-2.dsc 2387 SHA256:13948768dbf1a9aa3ae9fe592a4c6c904b1dd075acb689a49b85e0ae73b1756c
'http://deb.debian.org/debian/pool/main/f/fonts-dejavu/fonts-dejavu_2.37.orig.tar.bz2' fonts-dejavu_2.37.orig.tar.bz2 12050109 SHA256:4b21c5203f792343d5e90ab1cb0cf07e99887218abe3d83cd9a98cea9085e799
'http://deb.debian.org/debian/pool/main/f/fonts-dejavu/fonts-dejavu_2.37-2.debian.tar.xz' fonts-dejavu_2.37-2.debian.tar.xz 11408 SHA256:428cf37685df891574d2dcb32aa9366e4e95985fda7d87069903313bb03470ab
```

Other potentially useful URLs:

- https://sources.debian.net/src/fonts-dejavu/2.37-2/ (for browsing the source)
- https://sources.debian.net/src/fonts-dejavu/2.37-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/fonts-dejavu/2.37-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `freetype=2.10.4+dfsg-1+deb11u1`

Binary Packages:

- `libfreetype-dev:amd64=2.10.4+dfsg-1+deb11u1`
- `libfreetype6:amd64=2.10.4+dfsg-1+deb11u1`
- `libfreetype6-dev:amd64=2.10.4+dfsg-1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libfreetype-dev/copyright`, `/usr/share/doc/libfreetype6/copyright`, `/usr/share/doc/libfreetype6-dev/copyright`)

- `Apache-2.0`
- `BSD-3-Clause`
- `FSFAP`
- `FSFUL`
- `FSFULLR`
- `FTL`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `MIT`
- `OFL-1.1`
- `OpenGroup-BSD-like`
- `Permissive`
- `Public-Domain`
- `Zlib`

Source:

```console
$ apt-get source -qq --print-uris freetype=2.10.4+dfsg-1+deb11u1
'http://deb.debian.org/debian/pool/main/f/freetype/freetype_2.10.4%2bdfsg-1%2bdeb11u1.dsc' freetype_2.10.4+dfsg-1+deb11u1.dsc 3762 SHA256:6c93012be153ec146b77bfa4df0bd8b19affe63f5a8bdbfbf3ce6faf4a89e365
'http://deb.debian.org/debian/pool/main/f/freetype/freetype_2.10.4%2bdfsg.orig-ft2demos.tar.xz' freetype_2.10.4+dfsg.orig-ft2demos.tar.xz 236712 SHA256:3f873ebe4fb387da3859149459f9be95320ce1fd56b50f8fdb9d2a8492887083
'http://deb.debian.org/debian/pool/main/f/freetype/freetype_2.10.4%2bdfsg.orig-ft2demos.tar.xz.asc' freetype_2.10.4+dfsg.orig-ft2demos.tar.xz.asc 195 SHA256:38d5b9a5aa11ecf8c6d4c983ef48b3ce2288fdf93d44719df2598b9d415c8061
'http://deb.debian.org/debian/pool/main/f/freetype/freetype_2.10.4%2bdfsg.orig-ft2docs.tar.xz' freetype_2.10.4+dfsg.orig-ft2docs.tar.xz 2079084 SHA256:cca1c19d1efa911bb685d919b5b0fe1279b0699bf8eb6a3d3bf9f02784758212
'http://deb.debian.org/debian/pool/main/f/freetype/freetype_2.10.4%2bdfsg.orig-ft2docs.tar.xz.asc' freetype_2.10.4+dfsg.orig-ft2docs.tar.xz.asc 195 SHA256:29fca9ff0e1cdc57ad5707b17f629eeaa216eb334f6082f1b05fb0fe35e14ff3
'http://deb.debian.org/debian/pool/main/f/freetype/freetype_2.10.4%2bdfsg.orig.tar.xz' freetype_2.10.4+dfsg.orig.tar.xz 2259340 SHA256:db0c0938b3b75cf314775baa75198098e41583b3aaa4804b454f183ce45120a9
'http://deb.debian.org/debian/pool/main/f/freetype/freetype_2.10.4%2bdfsg-1%2bdeb11u1.debian.tar.xz' freetype_2.10.4+dfsg-1+deb11u1.debian.tar.xz 117572 SHA256:f8845df5a24d816934ef30b46b8561072df3f7973ea65654674d69810aab9c3b
```

Other potentially useful URLs:

- https://sources.debian.net/src/freetype/2.10.4+dfsg-1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/freetype/2.10.4+dfsg-1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/freetype/2.10.4+dfsg-1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `fribidi=1.0.8-2+deb11u1`

Binary Packages:

- `libfribidi0:amd64=1.0.8-2+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libfribidi0/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris fribidi=1.0.8-2+deb11u1
'http://deb.debian.org/debian/pool/main/f/fribidi/fribidi_1.0.8-2%2bdeb11u1.dsc' fribidi_1.0.8-2+deb11u1.dsc 2481 SHA256:21c35e9e2e1a9665e0d1fb8f449299085fb471bb8f4ecfd1a1afc388eb1dd2ac
'http://deb.debian.org/debian/pool/main/f/fribidi/fribidi_1.0.8.orig.tar.bz2' fribidi_1.0.8.orig.tar.bz2 2077095 SHA256:94c7b68d86ad2a9613b4dcffe7bbeb03523d63b5b37918bdf2e4ef34195c1e6c
'http://deb.debian.org/debian/pool/main/f/fribidi/fribidi_1.0.8-2%2bdeb11u1.debian.tar.xz' fribidi_1.0.8-2+deb11u1.debian.tar.xz 10360 SHA256:62dc4a73351c71ac903f9428a5ebf5e32c0ff49a1a6a08dc95d9ce03e3f48a21
```

Other potentially useful URLs:

- https://sources.debian.net/src/fribidi/1.0.8-2+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/fribidi/1.0.8-2+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/fribidi/1.0.8-2+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gcc-10=10.2.1-6`

Binary Packages:

- `cpp-10=10.2.1-6`
- `g++-10=10.2.1-6`
- `gcc-10=10.2.1-6`
- `gcc-10-base:amd64=10.2.1-6`
- `libasan6:amd64=10.2.1-6`
- `libatomic1:amd64=10.2.1-6`
- `libcc1-0:amd64=10.2.1-6`
- `libgcc-10-dev:amd64=10.2.1-6`
- `libgcc-s1:amd64=10.2.1-6`
- `libgomp1:amd64=10.2.1-6`
- `libitm1:amd64=10.2.1-6`
- `liblsan0:amd64=10.2.1-6`
- `libquadmath0:amd64=10.2.1-6`
- `libstdc++-10-dev:amd64=10.2.1-6`
- `libstdc++6:amd64=10.2.1-6`
- `libtsan0:amd64=10.2.1-6`
- `libubsan1:amd64=10.2.1-6`

Licenses: (parsed from: `/usr/share/doc/cpp-10/copyright`, `/usr/share/doc/g++-10/copyright`, `/usr/share/doc/gcc-10/copyright`, `/usr/share/doc/gcc-10-base/copyright`, `/usr/share/doc/libasan6/copyright`, `/usr/share/doc/libatomic1/copyright`, `/usr/share/doc/libcc1-0/copyright`, `/usr/share/doc/libgcc-10-dev/copyright`, `/usr/share/doc/libgcc-s1/copyright`, `/usr/share/doc/libgomp1/copyright`, `/usr/share/doc/libitm1/copyright`, `/usr/share/doc/liblsan0/copyright`, `/usr/share/doc/libquadmath0/copyright`, `/usr/share/doc/libstdc++-10-dev/copyright`, `/usr/share/doc/libstdc++6/copyright`, `/usr/share/doc/libtsan0/copyright`, `/usr/share/doc/libubsan1/copyright`)

- `Artistic`
- `GFDL-1.2`
- `GPL`
- `GPL-2`
- `GPL-3`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris gcc-10=10.2.1-6
'http://deb.debian.org/debian/pool/main/g/gcc-10/gcc-10_10.2.1-6.dsc' gcc-10_10.2.1-6.dsc 27632 SHA256:24024c1e225ca968f37ce39047ff5f1058219976db9e88a807173c2f07fa6029
'http://deb.debian.org/debian/pool/main/g/gcc-10/gcc-10_10.2.1.orig.tar.xz' gcc-10_10.2.1.orig.tar.xz 84547844 SHA256:ea3c05faa381486e6b859c047dc14977418bf1ccda4567064e016493fd6fffec
'http://deb.debian.org/debian/pool/main/g/gcc-10/gcc-10_10.2.1-6.debian.tar.xz' gcc-10_10.2.1-6.debian.tar.xz 2366560 SHA256:a95d6b9da2be83f9751850b002021281411ff1003d9feb77298b131da47820b3
```

Other potentially useful URLs:

- https://sources.debian.net/src/gcc-10/10.2.1-6/ (for browsing the source)
- https://sources.debian.net/src/gcc-10/10.2.1-6/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gcc-10/10.2.1-6/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gcc-9=9.3.0-22`

Binary Packages:

- `gcc-9-base:amd64=9.3.0-22`

Licenses: (parsed from: `/usr/share/doc/gcc-9-base/copyright`)

- `Artistic`
- `GFDL-1.2`
- `GPL`
- `GPL-2`
- `GPL-3`
- `LGPL`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris gcc-9=9.3.0-22
'http://deb.debian.org/debian/pool/main/g/gcc-9/gcc-9_9.3.0-22.dsc' gcc-9_9.3.0-22.dsc 21926 SHA256:14a0ea03cee0eb5450cc630a3bdf47da157062b3e7622ac45f6ae14a321eae96
'http://deb.debian.org/debian/pool/main/g/gcc-9/gcc-9_9.3.0.orig.tar.gz' gcc-9_9.3.0.orig.tar.gz 88686943 SHA256:824044ffa96eb337bb1c1d4cf6a82691d0290d6f42e1d13362eea855458de060
'http://deb.debian.org/debian/pool/main/g/gcc-9/gcc-9_9.3.0-22.debian.tar.xz' gcc-9_9.3.0-22.debian.tar.xz 904252 SHA256:68d55260456847880c71831b69c19cb81e9d1abf09274ab77ab6c081e177d94d
```

Other potentially useful URLs:

- https://sources.debian.net/src/gcc-9/9.3.0-22/ (for browsing the source)
- https://sources.debian.net/src/gcc-9/9.3.0-22/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gcc-9/9.3.0-22/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gcc-defaults=1.190`

Binary Packages:

- `cpp=4:10.2.1-1`
- `g++=4:10.2.1-1`
- `gcc=4:10.2.1-1`

Licenses: (parsed from: `/usr/share/doc/cpp/copyright`, `/usr/share/doc/g++/copyright`, `/usr/share/doc/gcc/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris gcc-defaults=1.190
'http://deb.debian.org/debian/pool/main/g/gcc-defaults/gcc-defaults_1.190.dsc' gcc-defaults_1.190.dsc 12072 SHA256:ad953353a3d948dbbf2055aa2d1a2256e6845e7194eddbd939474387b0006a57
'http://deb.debian.org/debian/pool/main/g/gcc-defaults/gcc-defaults_1.190.tar.xz' gcc-defaults_1.190.tar.xz 45284 SHA256:4ce654e9469a9b2fa2d2168da6dd78ac338f7f86b0b68445e46ec2fbc92ece8f
```

Other potentially useful URLs:

- https://sources.debian.net/src/gcc-defaults/1.190/ (for browsing the source)
- https://sources.debian.net/src/gcc-defaults/1.190/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gcc-defaults/1.190/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gdbm=1.19-2`

Binary Packages:

- `libgdbm-compat4:amd64=1.19-2`
- `libgdbm-dev:amd64=1.19-2`
- `libgdbm6:amd64=1.19-2`

Licenses: (parsed from: `/usr/share/doc/libgdbm-compat4/copyright`, `/usr/share/doc/libgdbm-dev/copyright`, `/usr/share/doc/libgdbm6/copyright`)

- `GFDL-NIV-1.3+`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris gdbm=1.19-2
'http://deb.debian.org/debian/pool/main/g/gdbm/gdbm_1.19-2.dsc' gdbm_1.19-2.dsc 2603 SHA256:1f05cd17a44cdf05eb97df79147a77a57fba3346b48f00909abe8ad963bf6220
'http://deb.debian.org/debian/pool/main/g/gdbm/gdbm_1.19.orig.tar.gz' gdbm_1.19.orig.tar.gz 967861 SHA256:37ed12214122b972e18a0d94995039e57748191939ef74115b1d41d8811364bc
'http://deb.debian.org/debian/pool/main/g/gdbm/gdbm_1.19.orig.tar.gz.asc' gdbm_1.19.orig.tar.gz.asc 181 SHA256:8f4e0502073a7a22972f1edc84c70151033257d879402ac85176d3ebc984b2b8
'http://deb.debian.org/debian/pool/main/g/gdbm/gdbm_1.19-2.debian.tar.xz' gdbm_1.19-2.debian.tar.xz 16228 SHA256:c49d2faaa340acc8e94277dab0e0bf4ac10d49d9c374d6841883ac868edb5014
```

Other potentially useful URLs:

- https://sources.debian.net/src/gdbm/1.19-2/ (for browsing the source)
- https://sources.debian.net/src/gdbm/1.19-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gdbm/1.19-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gdk-pixbuf-xlib=2.40.2-2`

Binary Packages:

- `libgdk-pixbuf-xlib-2.0-0:amd64=2.40.2-2`
- `libgdk-pixbuf2.0-0:amd64=2.40.2-2`

Licenses: (parsed from: `/usr/share/doc/libgdk-pixbuf-xlib-2.0-0/copyright`, `/usr/share/doc/libgdk-pixbuf2.0-0/copyright`)

- `LGPL-2`
- `LGPL-2+`
- `MPL-1.1-or-LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris gdk-pixbuf-xlib=2.40.2-2
'http://deb.debian.org/debian/pool/main/g/gdk-pixbuf-xlib/gdk-pixbuf-xlib_2.40.2-2.dsc' gdk-pixbuf-xlib_2.40.2-2.dsc 2638 SHA256:6e5a0b626b766f43063440be67007f7411e04f82b202bf300568e49d04f167e3
'http://deb.debian.org/debian/pool/main/g/gdk-pixbuf-xlib/gdk-pixbuf-xlib_2.40.2.orig.tar.xz' gdk-pixbuf-xlib_2.40.2.orig.tar.xz 53588 SHA256:8b8e1c270ec16a06f665ea841f8e4e167eaa0118d0cbfeeade43745f09198ff7
'http://deb.debian.org/debian/pool/main/g/gdk-pixbuf-xlib/gdk-pixbuf-xlib_2.40.2-2.debian.tar.xz' gdk-pixbuf-xlib_2.40.2-2.debian.tar.xz 14136 SHA256:1f1546b18d695d0033d738f5cd21c87c6cb707428d9ef150c255859764f1ec35
```

Other potentially useful URLs:

- https://sources.debian.net/src/gdk-pixbuf-xlib/2.40.2-2/ (for browsing the source)
- https://sources.debian.net/src/gdk-pixbuf-xlib/2.40.2-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gdk-pixbuf-xlib/2.40.2-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gdk-pixbuf=2.42.2+dfsg-1+deb11u2`

Binary Packages:

- `gir1.2-gdkpixbuf-2.0:amd64=2.42.2+dfsg-1+deb11u2`
- `libgdk-pixbuf-2.0-0:amd64=2.42.2+dfsg-1+deb11u2`
- `libgdk-pixbuf-2.0-dev:amd64=2.42.2+dfsg-1+deb11u2`
- `libgdk-pixbuf2.0-bin=2.42.2+dfsg-1+deb11u2`
- `libgdk-pixbuf2.0-common=2.42.2+dfsg-1+deb11u2`

Licenses: (parsed from: `/usr/share/doc/gir1.2-gdkpixbuf-2.0/copyright`, `/usr/share/doc/libgdk-pixbuf-2.0-0/copyright`, `/usr/share/doc/libgdk-pixbuf-2.0-dev/copyright`, `/usr/share/doc/libgdk-pixbuf2.0-bin/copyright`, `/usr/share/doc/libgdk-pixbuf2.0-common/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris gdk-pixbuf=2.42.2+dfsg-1+deb11u2
'http://deb.debian.org/debian/pool/main/g/gdk-pixbuf/gdk-pixbuf_2.42.2%2bdfsg-1%2bdeb11u2.dsc' gdk-pixbuf_2.42.2+dfsg-1+deb11u2.dsc 3186 SHA256:75494c6db3917a144438ad1b084300e84a1f6ed7f38c354bee9200b2ce44a1eb
'http://deb.debian.org/debian/pool/main/g/gdk-pixbuf/gdk-pixbuf_2.42.2%2bdfsg.orig.tar.xz' gdk-pixbuf_2.42.2+dfsg.orig.tar.xz 6433920 SHA256:f781dca5af4c6536befb1faaa3b82efb9750c52a350842bc82b2aa08ce129ee9
'http://deb.debian.org/debian/pool/main/g/gdk-pixbuf/gdk-pixbuf_2.42.2%2bdfsg-1%2bdeb11u2.debian.tar.xz' gdk-pixbuf_2.42.2+dfsg-1+deb11u2.debian.tar.xz 37484 SHA256:45a5a344bc44deea1a6daf3131b070c38af6645759f787f9ab87e9e9f318da93
```

Other potentially useful URLs:

- https://sources.debian.net/src/gdk-pixbuf/2.42.2+dfsg-1+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/gdk-pixbuf/2.42.2+dfsg-1+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gdk-pixbuf/2.42.2+dfsg-1+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `git=1:2.30.2-1+deb11u3`

Binary Packages:

- `git=1:2.30.2-1+deb11u3`
- `git-man=1:2.30.2-1+deb11u3`

Licenses: (parsed from: `/usr/share/doc/git/copyright`, `/usr/share/doc/git-man/copyright`)

- `Apache-2.0`
- `Artistic`
- `Artistic-1`
- `Boost`
- `EDL-1.0`
- `Expat`
- `GPL`
- `GPL-1+`
- `GPL-2`
- `GPL-2+`
- `ISC`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `dlmalloc`
- `mingw-runtime`

Source:

```console
$ apt-get source -qq --print-uris git=1:2.30.2-1+deb11u3
'http://deb.debian.org/debian-security/pool/updates/main/g/git/git_2.30.2-1%2bdeb11u3.dsc' git_2.30.2-1+deb11u3.dsc 2907 SHA256:672900e73a5f7ddd1fad2b44db65046c863c3ffa76aecd4a430be370e99a6f5b
'http://deb.debian.org/debian-security/pool/updates/main/g/git/git_2.30.2.orig.tar.xz' git_2.30.2.orig.tar.xz 6329820 SHA256:41f7d90c71f9476cd387673fcb10ce09ccbed67332436a4cc58d7af32c355faa
'http://deb.debian.org/debian-security/pool/updates/main/g/git/git_2.30.2-1%2bdeb11u3.debian.tar.xz' git_2.30.2-1+deb11u3.debian.tar.xz 711960 SHA256:0cfa77116c7174aa5c7cf3ee243132e7d899e5129c791c12b5298e085f3cbe52
```

Other potentially useful URLs:

- https://sources.debian.net/src/git/1:2.30.2-1+deb11u3/ (for browsing the source)
- https://sources.debian.net/src/git/1:2.30.2-1+deb11u3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/git/1:2.30.2-1+deb11u3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `glib-networking=2.66.0-2`

Binary Packages:

- `glib-networking:amd64=2.66.0-2`
- `glib-networking-common=2.66.0-2`
- `glib-networking-services=2.66.0-2`

Licenses: (parsed from: `/usr/share/doc/glib-networking/copyright`, `/usr/share/doc/glib-networking-common/copyright`, `/usr/share/doc/glib-networking-services/copyright`)

- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `OpenSSL`

Source:

```console
$ apt-get source -qq --print-uris glib-networking=2.66.0-2
'http://deb.debian.org/debian/pool/main/g/glib-networking/glib-networking_2.66.0-2.dsc' glib-networking_2.66.0-2.dsc 2586 SHA256:b8f8523372bc0df88a64c58cf649ac27fc744e5cc9fced6d12152f1064a665f3
'http://deb.debian.org/debian/pool/main/g/glib-networking/glib-networking_2.66.0.orig.tar.xz' glib-networking_2.66.0.orig.tar.xz 193920 SHA256:c5d7be2437fdd196eebfb70c4517b96d3ba7ec13bd496318b8f02dea383e0099
'http://deb.debian.org/debian/pool/main/g/glib-networking/glib-networking_2.66.0-2.debian.tar.xz' glib-networking_2.66.0-2.debian.tar.xz 11628 SHA256:ff9dce1bf761569697baf8046d6b7d602f8900d7629148a3a0749eb2147be16e
```

Other potentially useful URLs:

- https://sources.debian.net/src/glib-networking/2.66.0-2/ (for browsing the source)
- https://sources.debian.net/src/glib-networking/2.66.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/glib-networking/2.66.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `glib2.0=2.66.8-1+deb11u4`

Binary Packages:

- `libglib2.0-0:amd64=2.66.8-1+deb11u4`
- `libglib2.0-bin=2.66.8-1+deb11u4`
- `libglib2.0-data=2.66.8-1+deb11u4`
- `libglib2.0-dev:amd64=2.66.8-1+deb11u4`
- `libglib2.0-dev-bin=2.66.8-1+deb11u4`

Licenses: (parsed from: `/usr/share/doc/libglib2.0-0/copyright`, `/usr/share/doc/libglib2.0-bin/copyright`, `/usr/share/doc/libglib2.0-data/copyright`, `/usr/share/doc/libglib2.0-dev/copyright`, `/usr/share/doc/libglib2.0-dev-bin/copyright`)

- `Expat`
- `GPL-2+`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris glib2.0=2.66.8-1+deb11u4
'http://deb.debian.org/debian/pool/main/g/glib2.0/glib2.0_2.66.8-1%2bdeb11u4.dsc' glib2.0_2.66.8-1+deb11u4.dsc 3426 SHA256:5bbf022ff4dfed3afd338c6aad05d3eeafb24f3063956dac0bb7176ef399b971
'http://deb.debian.org/debian/pool/main/g/glib2.0/glib2.0_2.66.8.orig.tar.xz' glib2.0_2.66.8.orig.tar.xz 4845548 SHA256:97bc87dd91365589af5cbbfea2574833aea7a1b71840fd365ecd2852c76b9c8b
'http://deb.debian.org/debian/pool/main/g/glib2.0/glib2.0_2.66.8-1%2bdeb11u4.debian.tar.xz' glib2.0_2.66.8-1+deb11u4.debian.tar.xz 188516 SHA256:cfa47700ccca4f73e1ccf26a11051bf3cc4f28e57bfd39fa04cc0c0f2d65e38b
```

Other potentially useful URLs:

- https://sources.debian.net/src/glib2.0/2.66.8-1+deb11u4/ (for browsing the source)
- https://sources.debian.net/src/glib2.0/2.66.8-1+deb11u4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/glib2.0/2.66.8-1+deb11u4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `glibc=2.31-13+deb11u11`

Binary Packages:

- `libc-bin=2.31-13+deb11u11`
- `libc-dev-bin=2.31-13+deb11u11`
- `libc6:amd64=2.31-13+deb11u11`
- `libc6-dev:amd64=2.31-13+deb11u11`

Licenses: (parsed from: `/usr/share/doc/libc-bin/copyright`, `/usr/share/doc/libc-dev-bin/copyright`, `/usr/share/doc/libc6/copyright`, `/usr/share/doc/libc6-dev/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris glibc=2.31-13+deb11u11
'http://deb.debian.org/debian/pool/main/g/glibc/glibc_2.31-13%2bdeb11u11.dsc' glibc_2.31-13+deb11u11.dsc 8351 SHA256:eab21c7c387c0ebc54485974450b7ee0310ae7081f4cdb90b4591d6942e5c694
'http://deb.debian.org/debian/pool/main/g/glibc/glibc_2.31.orig.tar.xz' glibc_2.31.orig.tar.xz 17254692 SHA256:3dc7704b6166839c37d7047626fd199f3d4c09aca0d90e48c51c31c967dce34e
'http://deb.debian.org/debian/pool/main/g/glibc/glibc_2.31-13%2bdeb11u11.debian.tar.xz' glibc_2.31-13+deb11u11.debian.tar.xz 966464 SHA256:ff78277778ddefe1eb44680cb19d2d4dff91891effc3b59da424ae61b0bcd482
```

Other potentially useful URLs:

- https://sources.debian.net/src/glibc/2.31-13+deb11u11/ (for browsing the source)
- https://sources.debian.net/src/glibc/2.31-13+deb11u11/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/glibc/2.31-13+deb11u11/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gmp=2:6.2.1+dfsg-1+deb11u1`

Binary Packages:

- `libgmp-dev:amd64=2:6.2.1+dfsg-1+deb11u1`
- `libgmp10:amd64=2:6.2.1+dfsg-1+deb11u1`
- `libgmpxx4ldbl:amd64=2:6.2.1+dfsg-1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libgmp-dev/copyright`, `/usr/share/doc/libgmp10/copyright`, `/usr/share/doc/libgmpxx4ldbl/copyright`)

- `GPL`
- `GPL-2`
- `GPL-3`
- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris gmp=2:6.2.1+dfsg-1+deb11u1
'http://deb.debian.org/debian/pool/main/g/gmp/gmp_6.2.1%2bdfsg-1%2bdeb11u1.dsc' gmp_6.2.1+dfsg-1+deb11u1.dsc 2181 SHA256:4c09eb0a1c333fc5e67184a18f050af0f46f7f0fdeb533557bebd89df07c137b
'http://deb.debian.org/debian/pool/main/g/gmp/gmp_6.2.1%2bdfsg.orig.tar.xz' gmp_6.2.1+dfsg.orig.tar.xz 1853476 SHA256:c6ba08e3f079260ab90ff44ab8801eae134cd62cd78f4aa56317c0e70daa40cb
'http://deb.debian.org/debian/pool/main/g/gmp/gmp_6.2.1%2bdfsg-1%2bdeb11u1.debian.tar.xz' gmp_6.2.1+dfsg-1+deb11u1.debian.tar.xz 21920 SHA256:3cde187d542f5c095c6db8b76ec5252353e0413b492c57eb2e67ed3c43f40172
```

Other potentially useful URLs:

- https://sources.debian.net/src/gmp/2:6.2.1+dfsg-1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/gmp/2:6.2.1+dfsg-1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gmp/2:6.2.1+dfsg-1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gnupg2=2.2.27-2+deb11u2`

Binary Packages:

- `dirmngr=2.2.27-2+deb11u2`
- `gnupg=2.2.27-2+deb11u2`
- `gnupg-l10n=2.2.27-2+deb11u2`
- `gnupg-utils=2.2.27-2+deb11u2`
- `gpg=2.2.27-2+deb11u2`
- `gpg-agent=2.2.27-2+deb11u2`
- `gpg-wks-client=2.2.27-2+deb11u2`
- `gpg-wks-server=2.2.27-2+deb11u2`
- `gpgconf=2.2.27-2+deb11u2`
- `gpgsm=2.2.27-2+deb11u2`
- `gpgv=2.2.27-2+deb11u2`

Licenses: (parsed from: `/usr/share/doc/dirmngr/copyright`, `/usr/share/doc/gnupg/copyright`, `/usr/share/doc/gnupg-l10n/copyright`, `/usr/share/doc/gnupg-utils/copyright`, `/usr/share/doc/gpg/copyright`, `/usr/share/doc/gpg-agent/copyright`, `/usr/share/doc/gpg-wks-client/copyright`, `/usr/share/doc/gpg-wks-server/copyright`, `/usr/share/doc/gpgconf/copyright`, `/usr/share/doc/gpgsm/copyright`, `/usr/share/doc/gpgv/copyright`)

- `BSD-3-clause`
- `CC0-1.0`
- `Expat`
- `GPL-3`
- `GPL-3+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `LGPL-3`
- `LGPL-3+`
- `RFC-Reference`
- `TinySCHEME`
- `permissive`

Source:

```console
$ apt-get source -qq --print-uris gnupg2=2.2.27-2+deb11u2
'http://deb.debian.org/debian/pool/main/g/gnupg2/gnupg2_2.2.27-2%2bdeb11u2.dsc' gnupg2_2.2.27-2+deb11u2.dsc 3322 SHA256:a334ffaa6c078907e64d990c469873ec883abcbbc2ca3911e4f3072c50d33eb8
'http://deb.debian.org/debian/pool/main/g/gnupg2/gnupg2_2.2.27.orig.tar.bz2' gnupg2_2.2.27.orig.tar.bz2 7191555 SHA256:34e60009014ea16402069136e0a5f63d9b65f90096244975db5cea74b3d02399
'http://deb.debian.org/debian/pool/main/g/gnupg2/gnupg2_2.2.27.orig.tar.bz2.asc' gnupg2_2.2.27.orig.tar.bz2.asc 119 SHA256:2b44fd82da223cb629062b9c8840d92698c003be8531fc393c38f97b28cae2a4
'http://deb.debian.org/debian/pool/main/g/gnupg2/gnupg2_2.2.27-2%2bdeb11u2.debian.tar.xz' gnupg2_2.2.27-2+deb11u2.debian.tar.xz 63960 SHA256:b35c6a717d7f79cfd1a7468436721ca9c9211f70d10216e22523478094670a7b
```

Other potentially useful URLs:

- https://sources.debian.net/src/gnupg2/2.2.27-2+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/gnupg2/2.2.27-2+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gnupg2/2.2.27-2+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gnutls28=3.7.1-5+deb11u6`

Binary Packages:

- `libgnutls30:amd64=3.7.1-5+deb11u6`

Licenses: (parsed from: `/usr/share/doc/libgnutls30/copyright`)

- `Apache-2.0`
- `BSD-3-Clause`
- `CC0 license`
- `Expat`
- `GFDL-1.3`
- `GPL`
- `GPL-3`
- `GPLv3+`
- `LGPL`
- `LGPL-3`
- `LGPLv2.1+`
- `LGPLv3+_or_GPLv2+`
- `The main library is licensed under GNU Lesser`

Source:

```console
$ apt-get source -qq --print-uris gnutls28=3.7.1-5+deb11u6
'http://deb.debian.org/debian-security/pool/updates/main/g/gnutls28/gnutls28_3.7.1-5%2bdeb11u6.dsc' gnutls28_3.7.1-5+deb11u6.dsc 3522 SHA256:39849c7a4973f6b4daf89bdcce49956613b8321140934d288dfdb129bcc2be6a
'http://deb.debian.org/debian-security/pool/updates/main/g/gnutls28/gnutls28_3.7.1.orig.tar.xz' gnutls28_3.7.1.orig.tar.xz 6038388 SHA256:3777d7963eca5e06eb315686163b7b3f5045e2baac5e54e038ace9835e5cac6f
'http://deb.debian.org/debian-security/pool/updates/main/g/gnutls28/gnutls28_3.7.1.orig.tar.xz.asc' gnutls28_3.7.1.orig.tar.xz.asc 854 SHA256:13a683b12602c169a7ad7827ab0e3f35c8fa1f98675d0073cf7d54a8cd635582
'http://deb.debian.org/debian-security/pool/updates/main/g/gnutls28/gnutls28_3.7.1-5%2bdeb11u6.debian.tar.xz' gnutls28_3.7.1-5+deb11u6.debian.tar.xz 109212 SHA256:90bba2ee9e3d6ce7c711bef1a7dded19a3037279df43b1e53633e02845252d73
```

Other potentially useful URLs:

- https://sources.debian.net/src/gnutls28/3.7.1-5+deb11u6/ (for browsing the source)
- https://sources.debian.net/src/gnutls28/3.7.1-5+deb11u6/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gnutls28/3.7.1-5+deb11u6/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gobject-introspection=1.66.1-1`

Binary Packages:

- `gir1.2-freedesktop:amd64=1.66.1-1+b1`
- `gir1.2-glib-2.0:amd64=1.66.1-1+b1`
- `libgirepository-1.0-1:amd64=1.66.1-1+b1`

Licenses: (parsed from: `/usr/share/doc/gir1.2-freedesktop/copyright`, `/usr/share/doc/gir1.2-glib-2.0/copyright`, `/usr/share/doc/libgirepository-1.0-1/copyright`)

- `BSD-2-clause`
- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2+`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris gobject-introspection=1.66.1-1
'http://deb.debian.org/debian/pool/main/g/gobject-introspection/gobject-introspection_1.66.1-1.dsc' gobject-introspection_1.66.1-1.dsc 3063 SHA256:f8b24b6dcc20f9262dfa50ca0439635555753f16e2d800492743114230a6012d
'http://deb.debian.org/debian/pool/main/g/gobject-introspection/gobject-introspection_1.66.1.orig.tar.xz' gobject-introspection_1.66.1.orig.tar.xz 1012784 SHA256:dd44a55ee5f426ea22b6b89624708f9e8d53f5cc94e5485c15c87cb30e06161d
'http://deb.debian.org/debian/pool/main/g/gobject-introspection/gobject-introspection_1.66.1-1.debian.tar.xz' gobject-introspection_1.66.1-1.debian.tar.xz 23656 SHA256:9962d8a3e3330d53877d37c846cfdae17083302eacaa81fc009ff81c7c0401cf
```

Other potentially useful URLs:

- https://sources.debian.net/src/gobject-introspection/1.66.1-1/ (for browsing the source)
- https://sources.debian.net/src/gobject-introspection/1.66.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gobject-introspection/1.66.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gpm=1.20.7-8`

Binary Packages:

- `libgpm2:amd64=1.20.7-8`

Licenses: (parsed from: `/usr/share/doc/libgpm2/copyright`)

- `GPL-2`
- `GPL-2.0+`
- `GPL-3`
- `GPL-3.0+`

Source:

```console
$ apt-get source -qq --print-uris gpm=1.20.7-8
'http://deb.debian.org/debian/pool/main/g/gpm/gpm_1.20.7-8.dsc' gpm_1.20.7-8.dsc 1991 SHA256:ad44b73b1f30d071361d3dd0b45f4c910f21582922980066b88f2b32b6b2c054
'http://deb.debian.org/debian/pool/main/g/gpm/gpm_1.20.7.orig.tar.gz' gpm_1.20.7.orig.tar.gz 855027 SHA256:c7e4661c24e05ae13547176b649bac8e3a0db2575f7dd57559f9e0b509f90f49
'http://deb.debian.org/debian/pool/main/g/gpm/gpm_1.20.7-8.debian.tar.xz' gpm_1.20.7-8.debian.tar.xz 84016 SHA256:69d4913f543233ad97dd3c6c9def5b0f9ee046075df64cca9bbb8e33574f2062
```

Other potentially useful URLs:

- https://sources.debian.net/src/gpm/1.20.7-8/ (for browsing the source)
- https://sources.debian.net/src/gpm/1.20.7-8/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gpm/1.20.7-8/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `graphite2=1.3.14-1`

Binary Packages:

- `libgraphite2-3:amd64=1.3.14-1`

Licenses: (parsed from: `/usr/share/doc/libgraphite2-3/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`
- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `MPL-1.1`
- `custom-sil-open-font-license`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris graphite2=1.3.14-1
'http://deb.debian.org/debian/pool/main/g/graphite2/graphite2_1.3.14-1.dsc' graphite2_1.3.14-1.dsc 2608 SHA256:3a622b8aa7d693d6d60d3cd29b49a7d9d7873ea6089cb52ce7a223261e605152
'http://deb.debian.org/debian/pool/main/g/graphite2/graphite2_1.3.14.orig.tar.gz' graphite2_1.3.14.orig.tar.gz 6629829 SHA256:7a3b342c5681921ce2e0c2496509d30b5b078399d5a7bd2358f95166d57d91df
'http://deb.debian.org/debian/pool/main/g/graphite2/graphite2_1.3.14-1.debian.tar.xz' graphite2_1.3.14-1.debian.tar.xz 12068 SHA256:94d584e6c748fa7e2f851c3bb39cb2cdb437b4f91d1d636f3d842357724cd9bd
```

Other potentially useful URLs:

- https://sources.debian.net/src/graphite2/1.3.14-1/ (for browsing the source)
- https://sources.debian.net/src/graphite2/1.3.14-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/graphite2/1.3.14-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `grep=3.6-1+deb11u1`

Binary Packages:

- `grep=3.6-1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/grep/copyright`)

- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris grep=3.6-1+deb11u1
'http://deb.debian.org/debian/pool/main/g/grep/grep_3.6-1%2bdeb11u1.dsc' grep_3.6-1+deb11u1.dsc 1648 SHA256:420cc5ac729e1f31b8c8c6fff183542aa0627cc142c8c24a90ea6c6ea8c403f7
'http://deb.debian.org/debian/pool/main/g/grep/grep_3.6.orig.tar.xz' grep_3.6.orig.tar.xz 1589412 SHA256:667e15e8afe189e93f9f21a7cd3a7b3f776202f417330b248c2ad4f997d9373e
'http://deb.debian.org/debian/pool/main/g/grep/grep_3.6.orig.tar.xz.asc' grep_3.6.orig.tar.xz.asc 833 SHA256:02b52c0676e0e97762cee638125a345a5300fdcba691c1a5b0725ee6bd28d4a8
'http://deb.debian.org/debian/pool/main/g/grep/grep_3.6-1%2bdeb11u1.debian.tar.xz' grep_3.6-1+deb11u1.debian.tar.xz 18600 SHA256:39c333035364b387e3dc437f6197e5054bb247607a897ed56495a87f169397f4
```

Other potentially useful URLs:

- https://sources.debian.net/src/grep/3.6-1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/grep/3.6-1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/grep/3.6-1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gsettings-desktop-schemas=3.38.0-2`

Binary Packages:

- `gsettings-desktop-schemas=3.38.0-2`

Licenses: (parsed from: `/usr/share/doc/gsettings-desktop-schemas/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris gsettings-desktop-schemas=3.38.0-2
'http://deb.debian.org/debian/pool/main/g/gsettings-desktop-schemas/gsettings-desktop-schemas_3.38.0-2.dsc' gsettings-desktop-schemas_3.38.0-2.dsc 2631 SHA256:f49183f569c451d4550b5d95a99cc406679ac767a015eb07385dcf52179f9ba5
'http://deb.debian.org/debian/pool/main/g/gsettings-desktop-schemas/gsettings-desktop-schemas_3.38.0.orig.tar.xz' gsettings-desktop-schemas_3.38.0.orig.tar.xz 685868 SHA256:5704c8266004b296036671f223c705dc046aa694a1b1abb87c67e7d2747a8c67
'http://deb.debian.org/debian/pool/main/g/gsettings-desktop-schemas/gsettings-desktop-schemas_3.38.0-2.debian.tar.xz' gsettings-desktop-schemas_3.38.0-2.debian.tar.xz 6588 SHA256:2adb2c3750abfbdfd5458c13e9e28da018938deb9f29c4da16824d63d35eb942
```

Other potentially useful URLs:

- https://sources.debian.net/src/gsettings-desktop-schemas/3.38.0-2/ (for browsing the source)
- https://sources.debian.net/src/gsettings-desktop-schemas/3.38.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gsettings-desktop-schemas/3.38.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gst-plugins-base1.0=1.18.4-2+deb11u2`

Binary Packages:

- `gstreamer1.0-plugins-base:amd64=1.18.4-2+deb11u2`
- `libgstreamer-gl1.0-0:amd64=1.18.4-2+deb11u2`
- `libgstreamer-plugins-base1.0-0:amd64=1.18.4-2+deb11u2`

Licenses: (parsed from: `/usr/share/doc/gstreamer1.0-plugins-base/copyright`, `/usr/share/doc/libgstreamer-gl1.0-0/copyright`, `/usr/share/doc/libgstreamer-plugins-base1.0-0/copyright`)

- `BSD (2 clause)`
- `BSD (3 clause)`
- `GPL-2+`
- `LGPL`
- `LGPL-2+`
- `MIT/X11 (BSD like) LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris gst-plugins-base1.0=1.18.4-2+deb11u2
'http://deb.debian.org/debian/pool/main/g/gst-plugins-base1.0/gst-plugins-base1.0_1.18.4-2%2bdeb11u2.dsc' gst-plugins-base1.0_1.18.4-2+deb11u2.dsc 3868 SHA256:2410b077c8b7aeec57b336a60442bc1d5cad741ce9a69c72c05a23a2f5b39fdb
'http://deb.debian.org/debian/pool/main/g/gst-plugins-base1.0/gst-plugins-base1.0_1.18.4.orig.tar.xz' gst-plugins-base1.0_1.18.4.orig.tar.xz 3169512 SHA256:29e53229a84d01d722f6f6db13087231cdf6113dd85c25746b9b58c3d68e8323
'http://deb.debian.org/debian/pool/main/g/gst-plugins-base1.0/gst-plugins-base1.0_1.18.4-2%2bdeb11u2.debian.tar.xz' gst-plugins-base1.0_1.18.4-2+deb11u2.debian.tar.xz 44168 SHA256:3ed930035e85119bfd05bbb84438a3e09070a0da69419067fba69f58dd0d258e
```

Other potentially useful URLs:

- https://sources.debian.net/src/gst-plugins-base1.0/1.18.4-2+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/gst-plugins-base1.0/1.18.4-2+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gst-plugins-base1.0/1.18.4-2+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gst-plugins-good1.0=1.18.4-2+deb11u2`

Binary Packages:

- `gstreamer1.0-plugins-good:amd64=1.18.4-2+deb11u2`

Licenses: (parsed from: `/usr/share/doc/gstreamer1.0-plugins-good/copyright`)

- `BSD`
- `BSD (3 clause)`
- `GPL-2+`
- `LGPL`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1+`
- `MIT/X11 (BSD like) LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris gst-plugins-good1.0=1.18.4-2+deb11u2
'http://deb.debian.org/debian/pool/main/g/gst-plugins-good1.0/gst-plugins-good1.0_1.18.4-2%2bdeb11u2.dsc' gst-plugins-good1.0_1.18.4-2+deb11u2.dsc 3584 SHA256:c623e5940431fd3287478a1adc982e0f03dbc3eda2ceb5de7d9da47282480523
'http://deb.debian.org/debian/pool/main/g/gst-plugins-good1.0/gst-plugins-good1.0_1.18.4.orig.tar.xz' gst-plugins-good1.0_1.18.4.orig.tar.xz 3277572 SHA256:b6e50e3a9bbcd56ee6ec71c33aa8332cc9c926b0c1fae995aac8b3040ebe39b0
'http://deb.debian.org/debian/pool/main/g/gst-plugins-good1.0/gst-plugins-good1.0_1.18.4-2%2bdeb11u2.debian.tar.xz' gst-plugins-good1.0_1.18.4-2+deb11u2.debian.tar.xz 38048 SHA256:03f7bb398338f3bc4e7479a7928527a8e34bb1e61bd7adf4a699e8b5da3ea9f1
```

Other potentially useful URLs:

- https://sources.debian.net/src/gst-plugins-good1.0/1.18.4-2+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/gst-plugins-good1.0/1.18.4-2+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gst-plugins-good1.0/1.18.4-2+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gstreamer1.0=1.18.4-2.1`

Binary Packages:

- `libgstreamer1.0-0:amd64=1.18.4-2.1`

Licenses: (parsed from: `/usr/share/doc/libgstreamer1.0-0/copyright`)

- `GPL-2+`
- `GPL-3+`
- `LGPL`
- `LGPL-2+`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris gstreamer1.0=1.18.4-2.1
'http://deb.debian.org/debian/pool/main/g/gstreamer1.0/gstreamer1.0_1.18.4-2.1.dsc' gstreamer1.0_1.18.4-2.1.dsc 2886 SHA256:a2c3c641e3ce0398321c424f4b8663ce0759963f0c01da1ac9f83a1d2dd1911a
'http://deb.debian.org/debian/pool/main/g/gstreamer1.0/gstreamer1.0_1.18.4.orig.tar.xz' gstreamer1.0_1.18.4.orig.tar.xz 2703948 SHA256:9aeec99b38e310817012aa2d1d76573b787af47f8a725a65b833880a094dfbc5
'http://deb.debian.org/debian/pool/main/g/gstreamer1.0/gstreamer1.0_1.18.4-2.1.debian.tar.xz' gstreamer1.0_1.18.4-2.1.debian.tar.xz 44160 SHA256:823a003e524e9951d9ed9f0ae6f70b2661f9e5e3fd067902d8d4b40ba41e1176
```

Other potentially useful URLs:

- https://sources.debian.net/src/gstreamer1.0/1.18.4-2.1/ (for browsing the source)
- https://sources.debian.net/src/gstreamer1.0/1.18.4-2.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gstreamer1.0/1.18.4-2.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gtk+3.0=3.24.24-4+deb11u4`

Binary Packages:

- `gtk-update-icon-cache=3.24.24-4+deb11u4`
- `libgtk-3-0:amd64=3.24.24-4+deb11u4`
- `libgtk-3-common=3.24.24-4+deb11u4`

Licenses: (parsed from: `/usr/share/doc/gtk-update-icon-cache/copyright`, `/usr/share/doc/libgtk-3-0/copyright`, `/usr/share/doc/libgtk-3-common/copyright`)

- `Apache-2.0`
- `Expat`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `SWL`
- `X11R5-permissive`
- `check-gdk-cairo-permissive`
- `other`

Source:

```console
$ apt-get source -qq --print-uris gtk+3.0=3.24.24-4+deb11u4
'http://deb.debian.org/debian/pool/main/g/gtk%2b3.0/gtk%2b3.0_3.24.24-4%2bdeb11u4.dsc' gtk+3.0_3.24.24-4+deb11u4.dsc 4145 SHA256:89e9395f1e2c1004830ca7857821e66cd2273991fd28daf43a3a71120b690318
'http://deb.debian.org/debian/pool/main/g/gtk%2b3.0/gtk%2b3.0_3.24.24.orig.tar.xz' gtk+3.0_3.24.24.orig.tar.xz 21341240 SHA256:cc9d4367c55b724832f6b09ab85481738ea456871f0381768a6a99335a98378a
'http://deb.debian.org/debian/pool/main/g/gtk%2b3.0/gtk%2b3.0_3.24.24-4%2bdeb11u4.debian.tar.xz' gtk+3.0_3.24.24-4+deb11u4.debian.tar.xz 173508 SHA256:85b0ad612a49d1ffeecd62344380f23fdff9a5efdca0e1cd82a9335cf4f01ce8
```

Other potentially useful URLs:

- https://sources.debian.net/src/gtk+3.0/3.24.24-4+deb11u4/ (for browsing the source)
- https://sources.debian.net/src/gtk+3.0/3.24.24-4+deb11u4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gtk+3.0/3.24.24-4+deb11u4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `gzip=1.10-4+deb11u1`

Binary Packages:

- `gzip=1.10-4+deb11u1`

Licenses: (parsed from: `/usr/share/doc/gzip/copyright`)

- `FSF-manpages`
- `GFDL-1.3+-no-invariant`
- `GFDL-3`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris gzip=1.10-4+deb11u1
'http://deb.debian.org/debian/pool/main/g/gzip/gzip_1.10-4%2bdeb11u1.dsc' gzip_1.10-4+deb11u1.dsc 1812 SHA256:0bcc813d124297ae741573b30db5faefec038aff92616d6ba014f859703f5acf
'http://deb.debian.org/debian/pool/main/g/gzip/gzip_1.10.orig.tar.gz' gzip_1.10.orig.tar.gz 1201421 SHA256:c91f74430bf7bc20402e1f657d0b252cb80aa66ba333a25704512af346633c68
'http://deb.debian.org/debian/pool/main/g/gzip/gzip_1.10-4%2bdeb11u1.debian.tar.xz' gzip_1.10-4+deb11u1.debian.tar.xz 22952 SHA256:183338e989ad327fca8c3281e8452c571bafed0c3cca0b6cea269a34b8dc19d2
```

Other potentially useful URLs:

- https://sources.debian.net/src/gzip/1.10-4+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/gzip/1.10-4+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/gzip/1.10-4+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `harfbuzz=2.7.4-1`

Binary Packages:

- `libharfbuzz-icu0:amd64=2.7.4-1`
- `libharfbuzz0b:amd64=2.7.4-1`

Licenses: (parsed from: `/usr/share/doc/libharfbuzz-icu0/copyright`, `/usr/share/doc/libharfbuzz0b/copyright`)

- `MIT`

Source:

```console
$ apt-get source -qq --print-uris harfbuzz=2.7.4-1
'http://deb.debian.org/debian/pool/main/h/harfbuzz/harfbuzz_2.7.4-1.dsc' harfbuzz_2.7.4-1.dsc 2740 SHA256:d8b7efb43ad01cf6b7377f5c14bc0d0541489315026ed87f5f652f1a1aff59c7
'http://deb.debian.org/debian/pool/main/h/harfbuzz/harfbuzz_2.7.4.orig.tar.xz' harfbuzz_2.7.4.orig.tar.xz 9532468 SHA256:6ad11d653347bd25d8317589df4e431a2de372c0cf9be3543368e07ec23bb8e7
'http://deb.debian.org/debian/pool/main/h/harfbuzz/harfbuzz_2.7.4-1.debian.tar.xz' harfbuzz_2.7.4-1.debian.tar.xz 10508 SHA256:a756f72db035c105209470836df62aa607d2aceacadfee5b17020c634eb4bef0
```

Other potentially useful URLs:

- https://sources.debian.net/src/harfbuzz/2.7.4-1/ (for browsing the source)
- https://sources.debian.net/src/harfbuzz/2.7.4-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/harfbuzz/2.7.4-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `hicolor-icon-theme=0.17-2`

Binary Packages:

- `hicolor-icon-theme=0.17-2`

Licenses: (parsed from: `/usr/share/doc/hicolor-icon-theme/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris hicolor-icon-theme=0.17-2
'http://deb.debian.org/debian/pool/main/h/hicolor-icon-theme/hicolor-icon-theme_0.17-2.dsc' hicolor-icon-theme_0.17-2.dsc 2053 SHA256:9df02b466f82cd6fa13930bc197d001ed8ddac1abc7f8dde3db45ed1708336bd
'http://deb.debian.org/debian/pool/main/h/hicolor-icon-theme/hicolor-icon-theme_0.17.orig.tar.xz' hicolor-icon-theme_0.17.orig.tar.xz 53016 SHA256:317484352271d18cbbcfac3868eab798d67fff1b8402e740baa6ff41d588a9d8
'http://deb.debian.org/debian/pool/main/h/hicolor-icon-theme/hicolor-icon-theme_0.17-2.debian.tar.xz' hicolor-icon-theme_0.17-2.debian.tar.xz 3536 SHA256:97eec9852a2923b95bd13fc59c30fb1b9063ffd1f8a04748544d4975a84e98f2
```

Other potentially useful URLs:

- https://sources.debian.net/src/hicolor-icon-theme/0.17-2/ (for browsing the source)
- https://sources.debian.net/src/hicolor-icon-theme/0.17-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/hicolor-icon-theme/0.17-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `hostname=3.23`

Binary Packages:

- `hostname=3.23`

Licenses: (parsed from: `/usr/share/doc/hostname/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris hostname=3.23
'http://deb.debian.org/debian/pool/main/h/hostname/hostname_3.23.dsc' hostname_3.23.dsc 1402 SHA256:0694c083fad82da1fd33204557a30bfc745a689a64030ba360062daafe03ede0
'http://deb.debian.org/debian/pool/main/h/hostname/hostname_3.23.tar.gz' hostname_3.23.tar.gz 13672 SHA256:bc6d1954b22849869ff8b2a602e39f08b1702f686d4b58dd7927cdeb5b4876ef
```

Other potentially useful URLs:

- https://sources.debian.net/src/hostname/3.23/ (for browsing the source)
- https://sources.debian.net/src/hostname/3.23/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/hostname/3.23/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `hunspell=1.7.0-3`

Binary Packages:

- `libhunspell-1.7-0:amd64=1.7.0-3`

Licenses: (parsed from: `/usr/share/doc/libhunspell-1.7-0/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris hunspell=1.7.0-3
'http://deb.debian.org/debian/pool/main/h/hunspell/hunspell_1.7.0-3.dsc' hunspell_1.7.0-3.dsc 2232 SHA256:f917955044d866233e0bfa0e01fbff6d605ccb6393c415e818604ba88b88e3df
'http://deb.debian.org/debian/pool/main/h/hunspell/hunspell_1.7.0.orig.tar.gz' hunspell_1.7.0.orig.tar.gz 482156 SHA256:bb27b86eb910a8285407cf3ca33b62643a02798cf2eef468c0a74f6c3ee6bc8a
'http://deb.debian.org/debian/pool/main/h/hunspell/hunspell_1.7.0-3.debian.tar.xz' hunspell_1.7.0-3.debian.tar.xz 21576 SHA256:1bbcadc4880b8af6543b37f42d05d92be1aa8725935974676d3c3af37b21d762
```

Other potentially useful URLs:

- https://sources.debian.net/src/hunspell/1.7.0-3/ (for browsing the source)
- https://sources.debian.net/src/hunspell/1.7.0-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/hunspell/1.7.0-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `hyphen=2.8.8-7`

Binary Packages:

- `libhyphen0:amd64=2.8.8-7`

Licenses: (parsed from: `/usr/share/doc/libhyphen0/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `MPL-1.1+`

Source:

```console
$ apt-get source -qq --print-uris hyphen=2.8.8-7
'http://deb.debian.org/debian/pool/main/h/hyphen/hyphen_2.8.8-7.dsc' hyphen_2.8.8-7.dsc 2086 SHA256:f77f10861124cb0a9ac701cac314d037244d1bc362bac113efdf643573120ffe
'http://deb.debian.org/debian/pool/main/h/hyphen/hyphen_2.8.8.orig.tar.gz' hyphen_2.8.8.orig.tar.gz 638369 SHA256:304636d4eccd81a14b6914d07b84c79ebb815288c76fe027b9ebff6ff24d5705
'http://deb.debian.org/debian/pool/main/h/hyphen/hyphen_2.8.8-7.debian.tar.xz' hyphen_2.8.8-7.debian.tar.xz 12540 SHA256:085a0168906304c9033154923e269ae70b64881dcbe6e52854afd4bd2be60aec
```

Other potentially useful URLs:

- https://sources.debian.net/src/hyphen/2.8.8-7/ (for browsing the source)
- https://sources.debian.net/src/hyphen/2.8.8-7/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/hyphen/2.8.8-7/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `icu=67.1-7`

Binary Packages:

- `icu-devtools=67.1-7`
- `libicu-dev:amd64=67.1-7`
- `libicu67:amd64=67.1-7`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris icu=67.1-7
'http://deb.debian.org/debian/pool/main/i/icu/icu_67.1-7.dsc' icu_67.1-7.dsc 2236 SHA256:3213915e2b2b07ab1d5fe81ba4e310d8146c0a799fd65ac1f1dbb0c32f56cff1
'http://deb.debian.org/debian/pool/main/i/icu/icu_67.1.orig.tar.gz' icu_67.1.orig.tar.gz 24518055 SHA256:94a80cd6f251a53bd2a997f6f1b5ac6653fe791dfab66e1eb0227740fb86d5dc
'http://deb.debian.org/debian/pool/main/i/icu/icu_67.1.orig.tar.gz.asc' icu_67.1.orig.tar.gz.asc 833 SHA256:0044119f3df92ff3055dc3609f527fa1290177f6ef1b6650ea136698b245e537
'http://deb.debian.org/debian/pool/main/i/icu/icu_67.1-7.debian.tar.xz' icu_67.1-7.debian.tar.xz 30256 SHA256:9836cbc00bf8da459734c82ccd435d09674e85e268f272decf16dbfa0bda730e
```

Other potentially useful URLs:

- https://sources.debian.net/src/icu/67.1-7/ (for browsing the source)
- https://sources.debian.net/src/icu/67.1-7/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/icu/67.1-7/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `ilmbase=2.5.4-1`

Binary Packages:

- `libilmbase-dev:amd64=2.5.4-1`
- `libilmbase25:amd64=2.5.4-1`

Licenses: (parsed from: `/usr/share/doc/libilmbase-dev/copyright`, `/usr/share/doc/libilmbase25/copyright`)

- `boost`
- `ilmbase`

Source:

```console
$ apt-get source -qq --print-uris ilmbase=2.5.4-1
'http://deb.debian.org/debian/pool/main/i/ilmbase/ilmbase_2.5.4-1.dsc' ilmbase_2.5.4-1.dsc 2468 SHA256:1825b9fdc3380518a6431c3c6138559cc9e8c790ccff6f9a8053b9a492b9d9f9
'http://deb.debian.org/debian/pool/main/i/ilmbase/ilmbase_2.5.4.orig.tar.gz' ilmbase_2.5.4.orig.tar.gz 27535491 SHA256:dba19e9c6720c6f64fbc8b9d1867eaa75da6438109b941eefdc75ed141b6576d
'http://deb.debian.org/debian/pool/main/i/ilmbase/ilmbase_2.5.4.orig.tar.gz.asc' ilmbase_2.5.4.orig.tar.gz.asc 287 SHA256:a2c4ac5151789903ca8ab3093a2798491463ccf2abfd003a20f96453e505dd5f
'http://deb.debian.org/debian/pool/main/i/ilmbase/ilmbase_2.5.4-1.debian.tar.xz' ilmbase_2.5.4-1.debian.tar.xz 14348 SHA256:a3ebf7d95eb94726db4e0449269b7200c2445176de04349ec62c352ec06c5b30
```

Other potentially useful URLs:

- https://sources.debian.net/src/ilmbase/2.5.4-1/ (for browsing the source)
- https://sources.debian.net/src/ilmbase/2.5.4-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/ilmbase/2.5.4-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `imagemagick=8:6.9.11.60+dfsg-1.3+deb11u4`

Binary Packages:

- `imagemagick=8:6.9.11.60+dfsg-1.3+deb11u4`
- `imagemagick-6-common=8:6.9.11.60+dfsg-1.3+deb11u4`
- `imagemagick-6.q16=8:6.9.11.60+dfsg-1.3+deb11u4`
- `libmagickcore-6-arch-config:amd64=8:6.9.11.60+dfsg-1.3+deb11u4`
- `libmagickcore-6-headers=8:6.9.11.60+dfsg-1.3+deb11u4`
- `libmagickcore-6.q16-6:amd64=8:6.9.11.60+dfsg-1.3+deb11u4`
- `libmagickcore-6.q16-6-extra:amd64=8:6.9.11.60+dfsg-1.3+deb11u4`
- `libmagickcore-6.q16-dev:amd64=8:6.9.11.60+dfsg-1.3+deb11u4`
- `libmagickcore-dev=8:6.9.11.60+dfsg-1.3+deb11u4`
- `libmagickwand-6-headers=8:6.9.11.60+dfsg-1.3+deb11u4`
- `libmagickwand-6.q16-6:amd64=8:6.9.11.60+dfsg-1.3+deb11u4`
- `libmagickwand-6.q16-dev:amd64=8:6.9.11.60+dfsg-1.3+deb11u4`
- `libmagickwand-dev=8:6.9.11.60+dfsg-1.3+deb11u4`

Licenses: (parsed from: `/usr/share/doc/imagemagick/copyright`, `/usr/share/doc/imagemagick-6-common/copyright`, `/usr/share/doc/imagemagick-6.q16/copyright`, `/usr/share/doc/libmagickcore-6-arch-config/copyright`, `/usr/share/doc/libmagickcore-6-headers/copyright`, `/usr/share/doc/libmagickcore-6.q16-6/copyright`, `/usr/share/doc/libmagickcore-6.q16-6-extra/copyright`, `/usr/share/doc/libmagickcore-6.q16-dev/copyright`, `/usr/share/doc/libmagickcore-dev/copyright`, `/usr/share/doc/libmagickwand-6-headers/copyright`, `/usr/share/doc/libmagickwand-6.q16-6/copyright`, `/usr/share/doc/libmagickwand-6.q16-dev/copyright`, `/usr/share/doc/libmagickwand-dev/copyright`)

- `Artistic`
- `BSD-with-FSF-change-public-domain`
- `GNU-All-Permissive-License`
- `GPL-1`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL2+-with-Autoconf-Macros-exception`
- `GPL3+-with-Autoconf-Macros-exception`
- `GPL3+-with-Autoconf-Macros-exception-GNU`
- `ImageMagick`
- `ImageMagickLicensePartEZXML`
- `ImageMagickLicensePartFIG`
- `ImageMagickLicensePartGsview`
- `ImageMagickLicensePartOpenSSH`
- `ImageMagickPartGraphicsMagick`
- `ImageMagickPartlibjpeg`
- `ImageMagickPartlibsquish`
- `Imagemagick`
- `LGPL-3`
- `LGPL-3+`
- `Magick++`
- `Makefile-in`
- `Perllikelicence`
- `TatcherUlrichPublicDomain`
- `aclocal`

Source:

```console
$ apt-get source -qq --print-uris imagemagick=8:6.9.11.60+dfsg-1.3+deb11u4
'http://deb.debian.org/debian/pool/main/i/imagemagick/imagemagick_6.9.11.60%2bdfsg-1.3%2bdeb11u4.dsc' imagemagick_6.9.11.60+dfsg-1.3+deb11u4.dsc 5131 SHA256:fbfc96bd4be1bb88768d6f95d072114387a0ab263b7518e92c31bed3bc758c32
'http://deb.debian.org/debian/pool/main/i/imagemagick/imagemagick_6.9.11.60%2bdfsg.orig.tar.xz' imagemagick_6.9.11.60+dfsg.orig.tar.xz 9395144 SHA256:472fb516df842ee9c819ed80099c188463b9e961303511c36ae24d0eaa8959c4
'http://deb.debian.org/debian/pool/main/i/imagemagick/imagemagick_6.9.11.60%2bdfsg-1.3%2bdeb11u4.debian.tar.xz' imagemagick_6.9.11.60+dfsg-1.3+deb11u4.debian.tar.xz 269472 SHA256:60bbd9013b474df4926663a46d8908b82badbb12e3dcc28aefbcb05f794d43ed
```

Other potentially useful URLs:

- https://sources.debian.net/src/imagemagick/8:6.9.11.60+dfsg-1.3+deb11u4/ (for browsing the source)
- https://sources.debian.net/src/imagemagick/8:6.9.11.60+dfsg-1.3+deb11u4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/imagemagick/8:6.9.11.60+dfsg-1.3+deb11u4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `init-system-helpers=1.60`

Binary Packages:

- `init-system-helpers=1.60`

Licenses: (parsed from: `/usr/share/doc/init-system-helpers/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris init-system-helpers=1.60
'http://deb.debian.org/debian/pool/main/i/init-system-helpers/init-system-helpers_1.60.dsc' init-system-helpers_1.60.dsc 1902 SHA256:51dd15cc34daf5e58e40560563785d422fb27ac8a2f6ce4e73350a800cbf3265
'http://deb.debian.org/debian/pool/main/i/init-system-helpers/init-system-helpers_1.60.tar.xz' init-system-helpers_1.60.tar.xz 40584 SHA256:2cf987e5ec2412faab8e99d6f26598b6ae65afe1af2073133575224997082172
```

Other potentially useful URLs:

- https://sources.debian.net/src/init-system-helpers/1.60/ (for browsing the source)
- https://sources.debian.net/src/init-system-helpers/1.60/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/init-system-helpers/1.60/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `iptables=1.8.7-1`

Binary Packages:

- `libip4tc2:amd64=1.8.7-1`

Licenses: (parsed from: `/usr/share/doc/libip4tc2/copyright`)

- `Artistic`
- `GPL-2`
- `GPL-2+`
- `custom`

Source:

```console
$ apt-get source -qq --print-uris iptables=1.8.7-1
'http://deb.debian.org/debian/pool/main/i/iptables/iptables_1.8.7-1.dsc' iptables_1.8.7-1.dsc 2719 SHA256:994249f1cd6d8056d8eb85082338bf87ae529fff5f4a2b8eab02a0dcf7c0b302
'http://deb.debian.org/debian/pool/main/i/iptables/iptables_1.8.7.orig.tar.bz2' iptables_1.8.7.orig.tar.bz2 717862 SHA256:c109c96bb04998cd44156622d36f8e04b140701ec60531a10668cfdff5e8d8f0
'http://deb.debian.org/debian/pool/main/i/iptables/iptables_1.8.7-1.debian.tar.xz' iptables_1.8.7-1.debian.tar.xz 23744 SHA256:d885495f8d1bf7706c70668adff6891c44527cad5506ece9d1944ce245d1dd69
```

Other potentially useful URLs:

- https://sources.debian.net/src/iptables/1.8.7-1/ (for browsing the source)
- https://sources.debian.net/src/iptables/1.8.7-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/iptables/1.8.7-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `isl=0.23-1`

Binary Packages:

- `libisl23:amd64=0.23-1`

Licenses: (parsed from: `/usr/share/doc/libisl23/copyright`)

- `BSD-2-clause`
- `LGPL-2`
- `LGPL-2.1+`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris isl=0.23-1
'http://deb.debian.org/debian/pool/main/i/isl/isl_0.23-1.dsc' isl_0.23-1.dsc 1832 SHA256:6f5a221a8b33070141ca578078974ab35e963968d777b1d551293fded250ffab
'http://deb.debian.org/debian/pool/main/i/isl/isl_0.23.orig.tar.xz' isl_0.23.orig.tar.xz 1729656 SHA256:5efc53efaef151301f4e7dde3856b66812d8153dede24fab17673f801c8698f2
'http://deb.debian.org/debian/pool/main/i/isl/isl_0.23-1.debian.tar.xz' isl_0.23-1.debian.tar.xz 26044 SHA256:97e9b10aca4b384241335c09b6928cf99f369fb64dfaa46b2a543e72a9d7dbe4
```

Other potentially useful URLs:

- https://sources.debian.net/src/isl/0.23-1/ (for browsing the source)
- https://sources.debian.net/src/isl/0.23-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/isl/0.23-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `iso-codes=4.6.0-1`

Binary Packages:

- `iso-codes=4.6.0-1`

Licenses: (parsed from: `/usr/share/doc/iso-codes/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris iso-codes=4.6.0-1
'http://deb.debian.org/debian/pool/main/i/iso-codes/iso-codes_4.6.0-1.dsc' iso-codes_4.6.0-1.dsc 1950 SHA256:fda03e45a8c1449533d3e4d8eeeec6d3b8364f390bdc81f3ed87997dc014601f
'http://deb.debian.org/debian/pool/main/i/iso-codes/iso-codes_4.6.0.orig.tar.xz' iso-codes_4.6.0.orig.tar.xz 3669536 SHA256:41c672c18554e979e6191f950f454cdf1bfb67a6369fffe2997ff68e34845409
'http://deb.debian.org/debian/pool/main/i/iso-codes/iso-codes_4.6.0-1.debian.tar.xz' iso-codes_4.6.0-1.debian.tar.xz 24008 SHA256:6ada248d2ab8e1474bf1185a84f671b8189e417412838fb16a1691536ca43c71
```

Other potentially useful URLs:

- https://sources.debian.net/src/iso-codes/4.6.0-1/ (for browsing the source)
- https://sources.debian.net/src/iso-codes/4.6.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/iso-codes/4.6.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `jackd2=1.9.17~dfsg-1`

Binary Packages:

- `libjack-jackd2-0:amd64=1.9.17~dfsg-1`

Licenses: (parsed from: `/usr/share/doc/libjack-jackd2-0/copyright`)

- `BSD-3-clause`
- `Expat`
- `Expat~modrequest`
- `GPL-2`
- `GPL-2+`
- `GPL-2~either`
- `GPL-2~jack-audio-connection-kit`
- `GPL-2~jackd2`
- `GPL-2~or`
- `GPL-3`
- `GPL-3+`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `None`
- `public-domain~Kroon`

Source:

```console
$ apt-get source -qq --print-uris jackd2=1.9.17~dfsg-1
'http://deb.debian.org/debian/pool/main/j/jackd2/jackd2_1.9.17%7edfsg-1.dsc' jackd2_1.9.17~dfsg-1.dsc 2477 SHA256:537a39602eb5af657384d0e5963f555e71a432165dccf00ffbce3971bb8aa531
'http://deb.debian.org/debian/pool/main/j/jackd2/jackd2_1.9.17%7edfsg.orig.tar.gz' jackd2_1.9.17~dfsg.orig.tar.gz 964766 SHA256:7436c33a17179eb7ea9facb7a21c0c914a222e871ab56f5bc2cfb378933baf3d
'http://deb.debian.org/debian/pool/main/j/jackd2/jackd2_1.9.17%7edfsg-1.debian.tar.xz' jackd2_1.9.17~dfsg-1.debian.tar.xz 40212 SHA256:c899946edc7debfeb032896989ebb045c9cdaafbec21524ff41edaa59edb2c84
```

Other potentially useful URLs:

- https://sources.debian.net/src/jackd2/1.9.17~dfsg-1/ (for browsing the source)
- https://sources.debian.net/src/jackd2/1.9.17~dfsg-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/jackd2/1.9.17~dfsg-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `jbigkit=2.1-3.1`

Binary Packages:

- `libjbig-dev:amd64=2.1-3.1+b2`
- `libjbig0:amd64=2.1-3.1+b2`

Licenses: (parsed from: `/usr/share/doc/libjbig-dev/copyright`, `/usr/share/doc/libjbig0/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris jbigkit=2.1-3.1
'http://deb.debian.org/debian/pool/main/j/jbigkit/jbigkit_2.1-3.1.dsc' jbigkit_2.1-3.1.dsc 1299 SHA256:62c8812d508958c5d35f2b1579dc3052fb5bd8d2e77d023fad064c4b48c8c3f8
'http://deb.debian.org/debian/pool/main/j/jbigkit/jbigkit_2.1.orig.tar.gz' jbigkit_2.1.orig.tar.gz 438710 SHA256:de7106b6bfaf495d6865c7dd7ac6ca1381bd12e0d81405ea81e7f2167263d932
'http://deb.debian.org/debian/pool/main/j/jbigkit/jbigkit_2.1-3.1.debian.tar.xz' jbigkit_2.1-3.1.debian.tar.xz 7600 SHA256:ebc3c52deaf37d52baea54d648a713640dc262926abda7bf05cd08e7db5dd1ee
```

Other potentially useful URLs:

- https://sources.debian.net/src/jbigkit/2.1-3.1/ (for browsing the source)
- https://sources.debian.net/src/jbigkit/2.1-3.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/jbigkit/2.1-3.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `json-c=0.15-2+deb11u1`

Binary Packages:

- `libjson-c5:amd64=0.15-2+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libjson-c5/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris json-c=0.15-2+deb11u1
'http://deb.debian.org/debian/pool/main/j/json-c/json-c_0.15-2%2bdeb11u1.dsc' json-c_0.15-2+deb11u1.dsc 2116 SHA256:420ea8efc3721bcc8e94e6e70dd3c67a7cc84b44c398ada46a9d22c475f9d7be
'http://deb.debian.org/debian/pool/main/j/json-c/json-c_0.15.orig.tar.gz' json-c_0.15.orig.tar.gz 348261 SHA256:4ba9a090a42cf1e12b84c64e4464bb6fb893666841d5843cc5bef90774028882
'http://deb.debian.org/debian/pool/main/j/json-c/json-c_0.15-2%2bdeb11u1.debian.tar.xz' json-c_0.15-2+deb11u1.debian.tar.xz 11588 SHA256:6510a2f2e8d90e253e6fad4e3dc98da0112224f87179cb4509f1aa68884f7b2b
```

Other potentially useful URLs:

- https://sources.debian.net/src/json-c/0.15-2+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/json-c/0.15-2+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/json-c/0.15-2+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `json-glib=1.6.2-1`

Binary Packages:

- `libjson-glib-1.0-0:amd64=1.6.2-1`
- `libjson-glib-1.0-common=1.6.2-1`

Licenses: (parsed from: `/usr/share/doc/libjson-glib-1.0-0/copyright`, `/usr/share/doc/libjson-glib-1.0-common/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris json-glib=1.6.2-1
'http://deb.debian.org/debian/pool/main/j/json-glib/json-glib_1.6.2-1.dsc' json-glib_1.6.2-1.dsc 2851 SHA256:cd97ca7cb0ce4a618b2ca0e59609f973693643bf90d09573a2f3184f8ed1ea7b
'http://deb.debian.org/debian/pool/main/j/json-glib/json-glib_1.6.2.orig.tar.xz' json-glib_1.6.2.orig.tar.xz 155256 SHA256:dd1e0ca973a9e00951c24499882ccaf653c5fb3bf45f567d140ab62043b35d34
'http://deb.debian.org/debian/pool/main/j/json-glib/json-glib_1.6.2-1.debian.tar.xz' json-glib_1.6.2-1.debian.tar.xz 9020 SHA256:50a69b0c8de7bca7ce71808de3d5288c050f0ed8002ac9b6e382bf87dda76084
```

Other potentially useful URLs:

- https://sources.debian.net/src/json-glib/1.6.2-1/ (for browsing the source)
- https://sources.debian.net/src/json-glib/1.6.2-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/json-glib/1.6.2-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `keyutils=1.6.1-2`

Binary Packages:

- `libkeyutils1:amd64=1.6.1-2`

Licenses: (parsed from: `/usr/share/doc/libkeyutils1/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris keyutils=1.6.1-2
'http://deb.debian.org/debian/pool/main/k/keyutils/keyutils_1.6.1-2.dsc' keyutils_1.6.1-2.dsc 2076 SHA256:6dd531f522fb3c5d8cfaaaf726e9277b64f50bff8c05d06269f42a677f65a4a8
'http://deb.debian.org/debian/pool/main/k/keyutils/keyutils_1.6.1.orig.tar.bz2' keyutils_1.6.1.orig.tar.bz2 97232 SHA256:c8b15722ae51d95b9ad76cc6d49a4c2cc19b0c60f72f61fb9bf43eea7cbd64ce
'http://deb.debian.org/debian/pool/main/k/keyutils/keyutils_1.6.1-2.debian.tar.xz' keyutils_1.6.1-2.debian.tar.xz 13412 SHA256:862442538428b514bb33a1c8488d4528c5ea48feca0ea5e60d8d34fd440f2355
```

Other potentially useful URLs:

- https://sources.debian.net/src/keyutils/1.6.1-2/ (for browsing the source)
- https://sources.debian.net/src/keyutils/1.6.1-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/keyutils/1.6.1-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `kmod=28-1`

Binary Packages:

- `libkmod2:amd64=28-1`

Licenses: (parsed from: `/usr/share/doc/libkmod2/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris kmod=28-1
'http://deb.debian.org/debian/pool/main/k/kmod/kmod_28-1.dsc' kmod_28-1.dsc 1448 SHA256:1d84f7e814104e6c26c38753fef6636e02f50e554531b27dcc1ab5a499f32a3d
'http://deb.debian.org/debian/pool/main/k/kmod/kmod_28.orig.tar.xz' kmod_28.orig.tar.xz 251476 SHA256:02a4368b1d073e382bcfbbc58536dccb894045f670ebf68dd5a763eea3101c9c
'http://deb.debian.org/debian/pool/main/k/kmod/kmod_28-1.debian.tar.xz' kmod_28-1.debian.tar.xz 8512 SHA256:35f77764f4e597ce193bde5645aaa19a1540ae1552b0ccb48cf335e06aeaed4f
```

Other potentially useful URLs:

- https://sources.debian.net/src/kmod/28-1/ (for browsing the source)
- https://sources.debian.net/src/kmod/28-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/kmod/28-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `krb5=1.18.3-6+deb11u5`

Binary Packages:

- `krb5-multidev:amd64=1.18.3-6+deb11u5`
- `libgssapi-krb5-2:amd64=1.18.3-6+deb11u5`
- `libgssrpc4:amd64=1.18.3-6+deb11u5`
- `libk5crypto3:amd64=1.18.3-6+deb11u5`
- `libkadm5clnt-mit12:amd64=1.18.3-6+deb11u5`
- `libkadm5srv-mit12:amd64=1.18.3-6+deb11u5`
- `libkdb5-10:amd64=1.18.3-6+deb11u5`
- `libkrb5-3:amd64=1.18.3-6+deb11u5`
- `libkrb5-dev:amd64=1.18.3-6+deb11u5`
- `libkrb5support0:amd64=1.18.3-6+deb11u5`

Licenses: (parsed from: `/usr/share/doc/krb5-multidev/copyright`, `/usr/share/doc/libgssapi-krb5-2/copyright`, `/usr/share/doc/libgssrpc4/copyright`, `/usr/share/doc/libk5crypto3/copyright`, `/usr/share/doc/libkadm5clnt-mit12/copyright`, `/usr/share/doc/libkadm5srv-mit12/copyright`, `/usr/share/doc/libkdb5-10/copyright`, `/usr/share/doc/libkrb5-3/copyright`, `/usr/share/doc/libkrb5-dev/copyright`, `/usr/share/doc/libkrb5support0/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris krb5=1.18.3-6+deb11u5
'http://deb.debian.org/debian/pool/main/k/krb5/krb5_1.18.3-6%2bdeb11u5.dsc' krb5_1.18.3-6+deb11u5.dsc 3209 SHA256:36c3edb6deb63df00b02fa00c3352139a0b51f30c9f20da8041f06818f771445
'http://deb.debian.org/debian/pool/main/k/krb5/krb5_1.18.3.orig.tar.gz' krb5_1.18.3.orig.tar.gz 8715312 SHA256:e61783c292b5efd9afb45c555a80dd267ac67eebabca42185362bee6c4fbd719
'http://deb.debian.org/debian/pool/main/k/krb5/krb5_1.18.3.orig.tar.gz.asc' krb5_1.18.3.orig.tar.gz.asc 833 SHA256:ded19808ba7320ad0bb3ddfb5202845b2ff36a50613af7832f78dd3cb4437419
'http://deb.debian.org/debian/pool/main/k/krb5/krb5_1.18.3-6%2bdeb11u5.debian.tar.xz' krb5_1.18.3-6+deb11u5.debian.tar.xz 114964 SHA256:6ba4b7db260cfdefb743a10b0a6a113c2302f1000812095563c5607ba9e0201a
```

Other potentially useful URLs:

- https://sources.debian.net/src/krb5/1.18.3-6+deb11u5/ (for browsing the source)
- https://sources.debian.net/src/krb5/1.18.3-6+deb11u5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/krb5/1.18.3-6+deb11u5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `lame=3.100-3`

Binary Packages:

- `libmp3lame0:amd64=3.100-3`

Licenses: (parsed from: `/usr/share/doc/libmp3lame0/copyright`)

- `BSD-3-clause`
- `GPL-1`
- `GPL-1+`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `zlib/libpng`

Source:

```console
$ apt-get source -qq --print-uris lame=3.100-3
'http://deb.debian.org/debian/pool/main/l/lame/lame_3.100-3.dsc' lame_3.100-3.dsc 2143 SHA256:5dec57a62002607b803b8eb659f0ed1079350de4ac9f8f8e52faa3d1e8fca08b
'http://deb.debian.org/debian/pool/main/l/lame/lame_3.100.orig.tar.gz' lame_3.100.orig.tar.gz 1524133 SHA256:ddfe36cab873794038ae2c1210557ad34857a4b6bdc515785d1da9e175b1da1e
'http://deb.debian.org/debian/pool/main/l/lame/lame_3.100-3.debian.tar.xz' lame_3.100-3.debian.tar.xz 12236 SHA256:85b6685d3c3c86a1331fa63e3efbd229acfcee360cd530dbdb6ea42b830d50d3
```

Other potentially useful URLs:

- https://sources.debian.net/src/lame/3.100-3/ (for browsing the source)
- https://sources.debian.net/src/lame/3.100-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/lame/3.100-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `lcms2=2.12~rc1-2`

Binary Packages:

- `liblcms2-2:amd64=2.12~rc1-2`
- `liblcms2-dev:amd64=2.12~rc1-2`

Licenses: (parsed from: `/usr/share/doc/liblcms2-2/copyright`, `/usr/share/doc/liblcms2-dev/copyright`)

- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3 (GPL-3 for the fast_float plugin only)`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris lcms2=2.12~rc1-2
'http://deb.debian.org/debian/pool/main/l/lcms2/lcms2_2.12%7erc1-2.dsc' lcms2_2.12~rc1-2.dsc 1988 SHA256:57b0b3cde709d8b7c43b195ba7f628d2d79323ee0db883050f253ee9f9acd48a
'http://deb.debian.org/debian/pool/main/l/lcms2/lcms2_2.12%7erc1.orig.tar.gz' lcms2_2.12~rc1.orig.tar.gz 7417767 SHA256:3300ddd8c51d60ebcc206d20d185b1b19939c4cec1576d1f5b95297b0fbdfe19
'http://deb.debian.org/debian/pool/main/l/lcms2/lcms2_2.12%7erc1-2.debian.tar.xz' lcms2_2.12~rc1-2.debian.tar.xz 10420 SHA256:dddb5b18a42fc7308e732f00643b29ac9f2638cf246569683cb50f13520c2cca
```

Other potentially useful URLs:

- https://sources.debian.net/src/lcms2/2.12~rc1-2/ (for browsing the source)
- https://sources.debian.net/src/lcms2/2.12~rc1-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/lcms2/2.12~rc1-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libassuan=2.5.3-7.1`

Binary Packages:

- `libassuan0:amd64=2.5.3-7.1`

Licenses: (parsed from: `/usr/share/doc/libassuan0/copyright`)

- `GAP`
- `GAP~FSF`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with libtool exception`
- `GPL-3`
- `GPL-3+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `LGPL-3`
- `LGPL-3+`

Source:

```console
$ apt-get source -qq --print-uris libassuan=2.5.3-7.1
'http://deb.debian.org/debian/pool/main/liba/libassuan/libassuan_2.5.3-7.1.dsc' libassuan_2.5.3-7.1.dsc 2627 SHA256:9e4cfaef54fee1b6c1fd32fdfe6fc90b2dde78755517ee0ff56859e69251fb07
'http://deb.debian.org/debian/pool/main/liba/libassuan/libassuan_2.5.3.orig.tar.bz2' libassuan_2.5.3.orig.tar.bz2 572348 SHA256:91bcb0403866b4e7c4bc1cc52ed4c364a9b5414b3994f718c70303f7f765e702
'http://deb.debian.org/debian/pool/main/liba/libassuan/libassuan_2.5.3.orig.tar.bz2.asc' libassuan_2.5.3.orig.tar.bz2.asc 952 SHA256:53b16a6619a2690b4f22da645a1d0c14b5664825c87b165ca5bd0de32607888a
'http://deb.debian.org/debian/pool/main/liba/libassuan/libassuan_2.5.3-7.1.debian.tar.xz' libassuan_2.5.3-7.1.debian.tar.xz 13952 SHA256:c6783e12dc1fb65681c083274f52cb3286da18dcf8a5b38a6de10143003e0681
```

Other potentially useful URLs:

- https://sources.debian.net/src/libassuan/2.5.3-7.1/ (for browsing the source)
- https://sources.debian.net/src/libassuan/2.5.3-7.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libassuan/2.5.3-7.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libasyncns=0.8-6`

Binary Packages:

- `libasyncns0:amd64=0.8-6+b2`

Licenses: (parsed from: `/usr/share/doc/libasyncns0/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris libasyncns=0.8-6
'http://deb.debian.org/debian/pool/main/liba/libasyncns/libasyncns_0.8-6.dsc' libasyncns_0.8-6.dsc 1921 SHA256:d6a3cccafadceda0bd1542c6325c6238ec34a8ff85276d6f2e5914e282c67dc6
'http://deb.debian.org/debian/pool/main/liba/libasyncns/libasyncns_0.8.orig.tar.gz' libasyncns_0.8.orig.tar.gz 341591 SHA256:4f1a66e746cbe54ff3c2fbada5843df4fbbbe7481d80be003e8d11161935ab74
'http://deb.debian.org/debian/pool/main/liba/libasyncns/libasyncns_0.8-6.debian.tar.xz' libasyncns_0.8-6.debian.tar.xz 4564 SHA256:69b23a155b8a3da3bf68b1e440283e117c55e92bd3b4aa308605fe3f1164485e
```

Other potentially useful URLs:

- https://sources.debian.net/src/libasyncns/0.8-6/ (for browsing the source)
- https://sources.debian.net/src/libasyncns/0.8-6/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libasyncns/0.8-6/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libavc1394=0.5.4-5`

Binary Packages:

- `libavc1394-0:amd64=0.5.4-5`

Licenses: (parsed from: `/usr/share/doc/libavc1394-0/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris libavc1394=0.5.4-5
'http://deb.debian.org/debian/pool/main/liba/libavc1394/libavc1394_0.5.4-5.dsc' libavc1394_0.5.4-5.dsc 2122 SHA256:9faa03aa953eecfa46bc4fc98f7c8c2265a1d8cf0b26f04137e196e68b5f2176
'http://deb.debian.org/debian/pool/main/liba/libavc1394/libavc1394_0.5.4.orig.tar.gz' libavc1394_0.5.4.orig.tar.gz 341679 SHA256:7cb1ff09506ae911ca9860bef4af08c2403f3e131f6c913a2cbd6ddca4215b53
'http://deb.debian.org/debian/pool/main/liba/libavc1394/libavc1394_0.5.4-5.debian.tar.xz' libavc1394_0.5.4-5.debian.tar.xz 6600 SHA256:783dde153ec5287c8ca278e0911163ecf4c568f95ac0a9c49307fdd941659ff1
```

Other potentially useful URLs:

- https://sources.debian.net/src/libavc1394/0.5.4-5/ (for browsing the source)
- https://sources.debian.net/src/libavc1394/0.5.4-5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libavc1394/0.5.4-5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libbsd=0.11.3-1+deb11u1`

Binary Packages:

- `libbsd0:amd64=0.11.3-1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libbsd0/copyright`)

- `BSD-2-clause`
- `BSD-2-clause-NetBSD`
- `BSD-2-clause-author`
- `BSD-2-clause-verbatim`
- `BSD-3-clause`
- `BSD-3-clause-John-Birrell`
- `BSD-3-clause-Regents`
- `BSD-3-clause-author`
- `BSD-4-clause-Christopher-G-Demetriou`
- `BSD-4-clause-Niels-Provos`
- `BSD-5-clause-Peter-Wemm`
- `Beerware`
- `Expat`
- `ISC`
- `ISC-Original`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris libbsd=0.11.3-1+deb11u1
'http://deb.debian.org/debian/pool/main/libb/libbsd/libbsd_0.11.3-1%2bdeb11u1.dsc' libbsd_0.11.3-1+deb11u1.dsc 2324 SHA256:c5c817a1c86a7821c76e6e73d54fd018de8b022a0177da670b90a4f8d8dfbfb0
'http://deb.debian.org/debian/pool/main/libb/libbsd/libbsd_0.11.3.orig.tar.xz' libbsd_0.11.3.orig.tar.xz 399712 SHA256:ff95cf8184151dacae4247832f8d4ea8800fa127dbd15033ecfe839f285b42a1
'http://deb.debian.org/debian/pool/main/libb/libbsd/libbsd_0.11.3.orig.tar.xz.asc' libbsd_0.11.3.orig.tar.xz.asc 833 SHA256:213f30c9537e2a180ebdad6445402ea879f83c3a85907f7509ae7f7304f7ce1b
'http://deb.debian.org/debian/pool/main/libb/libbsd/libbsd_0.11.3-1%2bdeb11u1.debian.tar.xz' libbsd_0.11.3-1+deb11u1.debian.tar.xz 17980 SHA256:9745c6b40e3d719da54ed3da6a266a5e6c58ff823e70ba87244a5cf9c44cb9b9
```

Other potentially useful URLs:

- https://sources.debian.net/src/libbsd/0.11.3-1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/libbsd/0.11.3-1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libbsd/0.11.3-1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libcaca=0.99.beta19-2.2`

Binary Packages:

- `libcaca0:amd64=0.99.beta19-2.2`

Licenses: (parsed from: `/usr/share/doc/libcaca0/copyright`)

- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris libcaca=0.99.beta19-2.2
'http://deb.debian.org/debian/pool/main/libc/libcaca/libcaca_0.99.beta19-2.2.dsc' libcaca_0.99.beta19-2.2.dsc 2379 SHA256:104441468035910d534efea7cfb3f297ebbea634debf5fcb042101d6eb44e2bd
'http://deb.debian.org/debian/pool/main/libc/libcaca/libcaca_0.99.beta19.orig.tar.gz' libcaca_0.99.beta19.orig.tar.gz 1203495 SHA256:128b467c4ed03264c187405172a4e83049342cc8cc2f655f53a2d0ee9d3772f4
'http://deb.debian.org/debian/pool/main/libc/libcaca/libcaca_0.99.beta19-2.2.debian.tar.xz' libcaca_0.99.beta19-2.2.debian.tar.xz 15020 SHA256:98eef7fc803224cbabc226f1e6488b25316f0b6282077db02d8cb490a5a919dc
```

Other potentially useful URLs:

- https://sources.debian.net/src/libcaca/0.99.beta19-2.2/ (for browsing the source)
- https://sources.debian.net/src/libcaca/0.99.beta19-2.2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libcaca/0.99.beta19-2.2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libcap-ng=0.7.9-2.2`

Binary Packages:

- `libcap-ng0:amd64=0.7.9-2.2+b1`

Licenses: (parsed from: `/usr/share/doc/libcap-ng0/copyright`)

- `GPL-2`
- `GPL-3`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libcap-ng=0.7.9-2.2
'http://deb.debian.org/debian/pool/main/libc/libcap-ng/libcap-ng_0.7.9-2.2.dsc' libcap-ng_0.7.9-2.2.dsc 2081 SHA256:d573ce59d83d2c117515e7c57dde1c990e9c5a34e0f53ac09f6b4d3e153e9aae
'http://deb.debian.org/debian/pool/main/libc/libcap-ng/libcap-ng_0.7.9.orig.tar.gz' libcap-ng_0.7.9.orig.tar.gz 449038 SHA256:4a1532bcf3731aade40936f6d6a586ed5a66ca4c7455e1338d1f6c3e09221328
'http://deb.debian.org/debian/pool/main/libc/libcap-ng/libcap-ng_0.7.9-2.2.debian.tar.xz' libcap-ng_0.7.9-2.2.debian.tar.xz 6308 SHA256:6d7b5cfcf435fe996e5dc78770a9ab1ab614ced5bee56e3e0ba4e09d8c832a0a
```

Other potentially useful URLs:

- https://sources.debian.net/src/libcap-ng/0.7.9-2.2/ (for browsing the source)
- https://sources.debian.net/src/libcap-ng/0.7.9-2.2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libcap-ng/0.7.9-2.2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libcap2=1:2.44-1`

Binary Packages:

- `libcap2:amd64=1:2.44-1`
- `libcap2-bin=1:2.44-1`

Licenses: (parsed from: `/usr/share/doc/libcap2/copyright`, `/usr/share/doc/libcap2-bin/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris libcap2=1:2.44-1
'http://deb.debian.org/debian/pool/main/libc/libcap2/libcap2_2.44-1.dsc' libcap2_2.44-1.dsc 2179 SHA256:c356b4239be3c35ef4b7ef5b9f7ea1677da41a68ef9761a8cabc96023076ac83
'http://deb.debian.org/debian/pool/main/libc/libcap2/libcap2_2.44.orig.tar.xz' libcap2_2.44.orig.tar.xz 125568 SHA256:92188359cd5be86e8e5bd3f6483ac6ce582264f912398937ef763def2205c8e1
'http://deb.debian.org/debian/pool/main/libc/libcap2/libcap2_2.44-1.debian.tar.xz' libcap2_2.44-1.debian.tar.xz 21116 SHA256:f612c54d31b44b4f508342a3415f5d51deeffaf939d4b47068909bbb1fd6c0f2
```

Other potentially useful URLs:

- https://sources.debian.net/src/libcap2/1:2.44-1/ (for browsing the source)
- https://sources.debian.net/src/libcap2/1:2.44-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libcap2/1:2.44-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libcbor=0.5.0+dfsg-2`

Binary Packages:

- `libcbor0:amd64=0.5.0+dfsg-2`

Licenses: (parsed from: `/usr/share/doc/libcbor0/copyright`)

- `Apache-2.0`
- `Expat`

Source:

```console
$ apt-get source -qq --print-uris libcbor=0.5.0+dfsg-2
'http://deb.debian.org/debian/pool/main/libc/libcbor/libcbor_0.5.0%2bdfsg-2.dsc' libcbor_0.5.0+dfsg-2.dsc 2057 SHA256:c1ad2786b340b65d55761ecc3d090a9d997b3a0e5218ff1d39f5cd19df900d73
'http://deb.debian.org/debian/pool/main/libc/libcbor/libcbor_0.5.0%2bdfsg.orig.tar.gz' libcbor_0.5.0+dfsg.orig.tar.gz 261201 SHA256:2bd1fb795d121a72fc127ccd0e6ce5f5742d5970d0913759bcdc729c700804fb
'http://deb.debian.org/debian/pool/main/libc/libcbor/libcbor_0.5.0%2bdfsg-2.debian.tar.xz' libcbor_0.5.0+dfsg-2.debian.tar.xz 3944 SHA256:c06d0890b369183142d09fc6a460d68fdaf32bb22f9885ee1cc203d00adc543d
```

Other potentially useful URLs:

- https://sources.debian.net/src/libcbor/0.5.0+dfsg-2/ (for browsing the source)
- https://sources.debian.net/src/libcbor/0.5.0+dfsg-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libcbor/0.5.0+dfsg-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libdatrie=0.2.13-1`

Binary Packages:

- `libdatrie1:amd64=0.2.13-1`

Licenses: (parsed from: `/usr/share/doc/libdatrie1/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris libdatrie=0.2.13-1
'http://deb.debian.org/debian/pool/main/libd/libdatrie/libdatrie_0.2.13-1.dsc' libdatrie_0.2.13-1.dsc 2239 SHA256:a775d82ce3131d63c6dddca5df19ea8e72cd8941103239a66ec6902a12350783
'http://deb.debian.org/debian/pool/main/libd/libdatrie/libdatrie_0.2.13.orig.tar.xz' libdatrie_0.2.13.orig.tar.xz 314072 SHA256:12231bb2be2581a7f0fb9904092d24b0ed2a271a16835071ed97bed65267f4be
'http://deb.debian.org/debian/pool/main/libd/libdatrie/libdatrie_0.2.13-1.debian.tar.xz' libdatrie_0.2.13-1.debian.tar.xz 9404 SHA256:b77520311b09756f00bd2c4c1880d16a3ec424ca1454bfcc2da4efaa272df2fc
```

Other potentially useful URLs:

- https://sources.debian.net/src/libdatrie/0.2.13-1/ (for browsing the source)
- https://sources.debian.net/src/libdatrie/0.2.13-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libdatrie/0.2.13-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libde265=1.0.11-0+deb11u3`

Binary Packages:

- `libde265-0:amd64=1.0.11-0+deb11u3`

Licenses: (parsed from: `/usr/share/doc/libde265-0/copyright`)

- `BSD-4-clause`
- `GPL-3`
- `GPL-3+`
- `LGPL-3`
- `LGPL-3+`
- `other-1`
- `public-domain-1`

Source:

```console
$ apt-get source -qq --print-uris libde265=1.0.11-0+deb11u3
'http://deb.debian.org/debian/pool/main/libd/libde265/libde265_1.0.11-0%2bdeb11u3.dsc' libde265_1.0.11-0+deb11u3.dsc 2417 SHA256:177af83ab7702633fb189e7cb6d3bd57784fb12c7ba1d94f80ee03535fb72e4b
'http://deb.debian.org/debian/pool/main/libd/libde265/libde265_1.0.11.orig.tar.gz' libde265_1.0.11.orig.tar.gz 845996 SHA256:2f8f12cabbdb15e53532b7c1eb964d4e15d444db1be802505e6ac97a25035bab
'http://deb.debian.org/debian/pool/main/libd/libde265/libde265_1.0.11-0%2bdeb11u3.debian.tar.xz' libde265_1.0.11-0+deb11u3.debian.tar.xz 15888 SHA256:cf769aa3b145af3bed5a12912102dcc8442b54b57ab1553b94c38061e6d50f27
```

Other potentially useful URLs:

- https://sources.debian.net/src/libde265/1.0.11-0+deb11u3/ (for browsing the source)
- https://sources.debian.net/src/libde265/1.0.11-0+deb11u3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libde265/1.0.11-0+deb11u3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libdeflate=1.7-1`

Binary Packages:

- `libdeflate-dev:amd64=1.7-1`
- `libdeflate0:amd64=1.7-1`

Licenses: (parsed from: `/usr/share/doc/libdeflate-dev/copyright`, `/usr/share/doc/libdeflate0/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris libdeflate=1.7-1
'http://deb.debian.org/debian/pool/main/libd/libdeflate/libdeflate_1.7-1.dsc' libdeflate_1.7-1.dsc 2163 SHA256:9f81571abf95f084dd6ce5c5f2b78ce66e5b1c7e2ec0f86e539f9df572061cd6
'http://deb.debian.org/debian/pool/main/libd/libdeflate/libdeflate_1.7.orig.tar.gz' libdeflate_1.7.orig.tar.gz 144143 SHA256:a5e6a0a9ab69f40f0f59332106532ca76918977a974e7004977a9498e3f11350
'http://deb.debian.org/debian/pool/main/libd/libdeflate/libdeflate_1.7-1.debian.tar.xz' libdeflate_1.7-1.debian.tar.xz 4392 SHA256:42a4f9b2307b0349fb2cd51a9585564284f480b03fa06c3f03ca02987ca66fb2
```

Other potentially useful URLs:

- https://sources.debian.net/src/libdeflate/1.7-1/ (for browsing the source)
- https://sources.debian.net/src/libdeflate/1.7-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libdeflate/1.7-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libdrm=2.4.104-1`

Binary Packages:

- `libdrm-amdgpu1:amd64=2.4.104-1`
- `libdrm-common=2.4.104-1`
- `libdrm-intel1:amd64=2.4.104-1`
- `libdrm-nouveau2:amd64=2.4.104-1`
- `libdrm-radeon1:amd64=2.4.104-1`
- `libdrm2:amd64=2.4.104-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libdrm=2.4.104-1
'http://deb.debian.org/debian/pool/main/libd/libdrm/libdrm_2.4.104-1.dsc' libdrm_2.4.104-1.dsc 3331 SHA256:bd2f9b302bbba7290e30f880f5c8d04e277b45bc0d4f8cbc9d6ce1a8fbf024e4
'http://deb.debian.org/debian/pool/main/libd/libdrm/libdrm_2.4.104.orig.tar.xz' libdrm_2.4.104.orig.tar.xz 419372 SHA256:d66ad8b5c2441015ac1333e40137bb803c3bde3612ff040286fcc12158ea1bcb
'http://deb.debian.org/debian/pool/main/libd/libdrm/libdrm_2.4.104.orig.tar.xz.asc' libdrm_2.4.104.orig.tar.xz.asc 833 SHA256:6db2f969970c8945bcd24779cba2fbeb8fae78cbf62ffc7882a0fe19ceed8445
'http://deb.debian.org/debian/pool/main/libd/libdrm/libdrm_2.4.104-1.debian.tar.xz' libdrm_2.4.104-1.debian.tar.xz 57368 SHA256:5b51830be1d5b3f4902a4facdb2707a7a8460e8ce19604a0d2c642a67ace0158
```

Other potentially useful URLs:

- https://sources.debian.net/src/libdrm/2.4.104-1/ (for browsing the source)
- https://sources.debian.net/src/libdrm/2.4.104-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libdrm/2.4.104-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libdv=1.0.0-13`

Binary Packages:

- `libdv4:amd64=1.0.0-13`

Licenses: (parsed from: `/usr/share/doc/libdv4/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris libdv=1.0.0-13
'http://deb.debian.org/debian/pool/main/libd/libdv/libdv_1.0.0-13.dsc' libdv_1.0.0-13.dsc 2056 SHA256:e3f69d89f42881a44c9358df0096705a87770b7159d5f311adfe27ca335c602e
'http://deb.debian.org/debian/pool/main/libd/libdv/libdv_1.0.0.orig.tar.gz' libdv_1.0.0.orig.tar.gz 574565 SHA256:a305734033a9c25541a59e8dd1c254409953269ea7c710c39e540bd8853389ba
'http://deb.debian.org/debian/pool/main/libd/libdv/libdv_1.0.0-13.debian.tar.xz' libdv_1.0.0-13.debian.tar.xz 13992 SHA256:46c1540193e4b5b04218a917c91d6175b7b5ed336118099bf102fe008fe3fb1c
```

Other potentially useful URLs:

- https://sources.debian.net/src/libdv/1.0.0-13/ (for browsing the source)
- https://sources.debian.net/src/libdv/1.0.0-13/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libdv/1.0.0-13/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libedit=3.1-20191231-2`

Binary Packages:

- `libedit2:amd64=3.1-20191231-2+b1`

Licenses: (parsed from: `/usr/share/doc/libedit2/copyright`)

- `BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris libedit=3.1-20191231-2
'http://deb.debian.org/debian/pool/main/libe/libedit/libedit_3.1-20191231-2.dsc' libedit_3.1-20191231-2.dsc 2208 SHA256:422c4cab3b047b62142eef4f77995fd1cd0f424c52ffeae953935e241d3aaa81
'http://deb.debian.org/debian/pool/main/libe/libedit/libedit_3.1-20191231.orig.tar.gz' libedit_3.1-20191231.orig.tar.gz 516801 SHA256:dbb82cb7e116a5f8025d35ef5b4f7d4a3cdd0a3909a146a39112095a2d229071
'http://deb.debian.org/debian/pool/main/libe/libedit/libedit_3.1-20191231-2.debian.tar.xz' libedit_3.1-20191231-2.debian.tar.xz 14576 SHA256:afb4656959bfa61817d0bc1982f2628373e84b251a148edb7da3e3c10645366c
```

Other potentially useful URLs:

- https://sources.debian.net/src/libedit/3.1-20191231-2/ (for browsing the source)
- https://sources.debian.net/src/libedit/3.1-20191231-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libedit/3.1-20191231-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libepoxy=1.5.5-1`

Binary Packages:

- `libepoxy0:amd64=1.5.5-1`

Licenses: (parsed from: `/usr/share/doc/libepoxy0/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris libepoxy=1.5.5-1
'http://deb.debian.org/debian/pool/main/libe/libepoxy/libepoxy_1.5.5-1.dsc' libepoxy_1.5.5-1.dsc 2100 SHA256:2c8bf4505bb9b4bd3d429327dcc52756551aebb2c4a6b23bb77b9c683a257efb
'http://deb.debian.org/debian/pool/main/libe/libepoxy/libepoxy_1.5.5.orig.tar.gz' libepoxy_1.5.5.orig.tar.gz 332057 SHA256:5d80a43a6524a1ebdd0c9c5d5105295546a0794681853c636a0c70f8f9c658ce
'http://deb.debian.org/debian/pool/main/libe/libepoxy/libepoxy_1.5.5-1.debian.tar.xz' libepoxy_1.5.5-1.debian.tar.xz 17124 SHA256:4a753fdc6165352384031ac77f61f932f570a7500a20d888d546799e18f7d628
```

Other potentially useful URLs:

- https://sources.debian.net/src/libepoxy/1.5.5-1/ (for browsing the source)
- https://sources.debian.net/src/libepoxy/1.5.5-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libepoxy/1.5.5-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `liberror-perl=0.17029-1`

Binary Packages:

- `liberror-perl=0.17029-1`

Licenses: (parsed from: `/usr/share/doc/liberror-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`
- `MIT/X11`

Source:

```console
$ apt-get source -qq --print-uris liberror-perl=0.17029-1
'http://deb.debian.org/debian/pool/main/libe/liberror-perl/liberror-perl_0.17029-1.dsc' liberror-perl_0.17029-1.dsc 2336 SHA256:0590467fe8c5f81bff9336e991462b2a9994b4876f4b732c8b8b31e927987cd7
'http://deb.debian.org/debian/pool/main/libe/liberror-perl/liberror-perl_0.17029.orig.tar.gz' liberror-perl_0.17029.orig.tar.gz 33304 SHA256:1a23f7913032aed6d4b68321373a3899ca66590f4727391a091ec19c95bf7adc
'http://deb.debian.org/debian/pool/main/libe/liberror-perl/liberror-perl_0.17029-1.debian.tar.xz' liberror-perl_0.17029-1.debian.tar.xz 4552 SHA256:a753b142c4c33ebf9cc98ae5f7a08da13b7c9ca2823ec26e45c96efb9c15c42e
```

Other potentially useful URLs:

- https://sources.debian.net/src/liberror-perl/0.17029-1/ (for browsing the source)
- https://sources.debian.net/src/liberror-perl/0.17029-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/liberror-perl/0.17029-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libevdev=1.11.0+dfsg-1`

Binary Packages:

- `libevdev2:amd64=1.11.0+dfsg-1`

Licenses: (parsed from: `/usr/share/doc/libevdev2/copyright`)

- `Apache-2.0`
- `BSD-3`
- `GPL-2`
- `GPL-2+`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris libevdev=1.11.0+dfsg-1
'http://deb.debian.org/debian/pool/main/libe/libevdev/libevdev_1.11.0%2bdfsg-1.dsc' libevdev_1.11.0+dfsg-1.dsc 2213 SHA256:5813c294b0458a36919a33cd9f99c1ae4c9472fb6d4680d722f4c2f07044b565
'http://deb.debian.org/debian/pool/main/libe/libevdev/libevdev_1.11.0%2bdfsg.orig.tar.xz' libevdev_1.11.0+dfsg.orig.tar.xz 340824 SHA256:2ed42336783bf6ba4dd71a8a6dbbfe8bb60d99170abed46d04d0e37da38d46bf
'http://deb.debian.org/debian/pool/main/libe/libevdev/libevdev_1.11.0%2bdfsg-1.debian.tar.xz' libevdev_1.11.0+dfsg-1.debian.tar.xz 9200 SHA256:afc4677e1361af94a1c8c1ab0c64376eb132fcbd7401036737c59eccae2992e1
```

Other potentially useful URLs:

- https://sources.debian.net/src/libevdev/1.11.0+dfsg-1/ (for browsing the source)
- https://sources.debian.net/src/libevdev/1.11.0+dfsg-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libevdev/1.11.0+dfsg-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libevent=2.1.12-stable-1`

Binary Packages:

- `libevent-2.1-7:amd64=2.1.12-stable-1`
- `libevent-core-2.1-7:amd64=2.1.12-stable-1`
- `libevent-dev=2.1.12-stable-1`
- `libevent-extra-2.1-7:amd64=2.1.12-stable-1`
- `libevent-openssl-2.1-7:amd64=2.1.12-stable-1`
- `libevent-pthreads-2.1-7:amd64=2.1.12-stable-1`

Licenses: (parsed from: `/usr/share/doc/libevent-2.1-7/copyright`, `/usr/share/doc/libevent-core-2.1-7/copyright`, `/usr/share/doc/libevent-dev/copyright`, `/usr/share/doc/libevent-extra-2.1-7/copyright`, `/usr/share/doc/libevent-openssl-2.1-7/copyright`, `/usr/share/doc/libevent-pthreads-2.1-7/copyright`)

- `BSD-2-clause`
- `BSD-3-Clause~Kitware`
- `BSD-3-clause`
- `BSL`
- `Expat`
- `FSFUL`
- `FSFULLR`
- `FSFULLR-No-Warranty`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `ISC`
- `curl`

Source:

```console
$ apt-get source -qq --print-uris libevent=2.1.12-stable-1
'http://deb.debian.org/debian/pool/main/libe/libevent/libevent_2.1.12-stable-1.dsc' libevent_2.1.12-stable-1.dsc 2527 SHA256:e82d9dc2160de05b1827b04894a954079e23ede0d5e2b5a1d9e9b2021e7c4e10
'http://deb.debian.org/debian/pool/main/libe/libevent/libevent_2.1.12-stable.orig.tar.gz' libevent_2.1.12-stable.orig.tar.gz 1100847 SHA256:92e6de1be9ec176428fd2367677e61ceffc2ee1cb119035037a27d346b0403bb
'http://deb.debian.org/debian/pool/main/libe/libevent/libevent_2.1.12-stable.orig.tar.gz.asc' libevent_2.1.12-stable.orig.tar.gz.asc 488 SHA256:3cd3d764777540305813495912cd5f7ea7d16edb456d6c88b331a1aa8974dfc2
'http://deb.debian.org/debian/pool/main/libe/libevent/libevent_2.1.12-stable-1.debian.tar.xz' libevent_2.1.12-stable-1.debian.tar.xz 17764 SHA256:cc608fff85ed5b262dee671fe17444aa6734dbc3be232e0b6ecca41252a62438
```

Other potentially useful URLs:

- https://sources.debian.net/src/libevent/2.1.12-stable-1/ (for browsing the source)
- https://sources.debian.net/src/libevent/2.1.12-stable-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libevent/2.1.12-stable-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libexif=0.6.22-3`

Binary Packages:

- `libexif-dev:amd64=0.6.22-3`
- `libexif12:amd64=0.6.22-3`

Licenses: (parsed from: `/usr/share/doc/libexif-dev/copyright`, `/usr/share/doc/libexif12/copyright`)

- `BSD-2-Clause`
- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `MIT`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris libexif=0.6.22-3
'http://deb.debian.org/debian/pool/main/libe/libexif/libexif_0.6.22-3.dsc' libexif_0.6.22-3.dsc 2079 SHA256:faccc62b4ebbf8af6750c672c4583c88cff23026ce8968ced5ab78f93ede7013
'http://deb.debian.org/debian/pool/main/libe/libexif/libexif_0.6.22.orig.tar.gz' libexif_0.6.22.orig.tar.gz 1109525 SHA256:46498934b7b931526fdee8fd8eb77a1dddedd529d5a6dbce88daf4384baecc54
'http://deb.debian.org/debian/pool/main/libe/libexif/libexif_0.6.22-3.debian.tar.xz' libexif_0.6.22-3.debian.tar.xz 12468 SHA256:30d2110b469ba89d10526520e1e9e68b9a7bfc8cf01ced054a613de8396658ed
```

Other potentially useful URLs:

- https://sources.debian.net/src/libexif/0.6.22-3/ (for browsing the source)
- https://sources.debian.net/src/libexif/0.6.22-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libexif/0.6.22-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libffi=3.3-6`

Binary Packages:

- `libffi-dev:amd64=3.3-6`
- `libffi7:amd64=3.3-6`

Licenses: (parsed from: `/usr/share/doc/libffi-dev/copyright`, `/usr/share/doc/libffi7/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris libffi=3.3-6
'http://deb.debian.org/debian/pool/main/libf/libffi/libffi_3.3-6.dsc' libffi_3.3-6.dsc 1934 SHA256:cb5dcd6b54e0c8c7db4cd97deef68ac9e2ede49138ca5db194b60338eae8dd65
'http://deb.debian.org/debian/pool/main/libf/libffi/libffi_3.3.orig.tar.gz' libffi_3.3.orig.tar.gz 1305466 SHA256:72fba7922703ddfa7a028d513ac15a85c8d54c8d67f55fa5a4802885dc652056
'http://deb.debian.org/debian/pool/main/libf/libffi/libffi_3.3-6.debian.tar.xz' libffi_3.3-6.debian.tar.xz 9168 SHA256:d15879289f32acf2afbbcc6ccf6e0c1aa306f6f06abb8b0301bfa41bffea9a55
```

Other potentially useful URLs:

- https://sources.debian.net/src/libffi/3.3-6/ (for browsing the source)
- https://sources.debian.net/src/libffi/3.3-6/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libffi/3.3-6/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libfido2=1.6.0-2`

Binary Packages:

- `libfido2-1:amd64=1.6.0-2`

Licenses: (parsed from: `/usr/share/doc/libfido2-1/copyright`)

- `BSD-2-clause`
- `ISC`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris libfido2=1.6.0-2
'http://deb.debian.org/debian/pool/main/libf/libfido2/libfido2_1.6.0-2.dsc' libfido2_1.6.0-2.dsc 2565 SHA256:5706f21aa3179124e0e39aeded7519c6536b241ac58457413f36bdbd67cd6cd1
'http://deb.debian.org/debian/pool/main/libf/libfido2/libfido2_1.6.0.orig.tar.gz' libfido2_1.6.0.orig.tar.gz 413904 SHA256:6aed47aafd22be49c38f9281fb88ccd08c98678d9b8c39cdc87d1bb3ea2c63e4
'http://deb.debian.org/debian/pool/main/libf/libfido2/libfido2_1.6.0.orig.tar.gz.asc' libfido2_1.6.0.orig.tar.gz.asc 488 SHA256:3340543e15edc67a38850be6777448db33245b5f9f686903d24563a2c7c0d969
'http://deb.debian.org/debian/pool/main/libf/libfido2/libfido2_1.6.0-2.debian.tar.xz' libfido2_1.6.0-2.debian.tar.xz 72700 SHA256:a08adb41d42e64206c5f70f1f2c1510debb37256fe3b92681a0bdc4a73e6d8d2
```

Other potentially useful URLs:

- https://sources.debian.net/src/libfido2/1.6.0-2/ (for browsing the source)
- https://sources.debian.net/src/libfido2/1.6.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libfido2/1.6.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libgcrypt20=1.8.7-6`

Binary Packages:

- `libgcrypt20:amd64=1.8.7-6`

Licenses: (parsed from: `/usr/share/doc/libgcrypt20/copyright`)

- `GPL-2`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris libgcrypt20=1.8.7-6
'http://deb.debian.org/debian/pool/main/libg/libgcrypt20/libgcrypt20_1.8.7-6.dsc' libgcrypt20_1.8.7-6.dsc 2800 SHA256:af433c97fde6172bb51d458e66acd33c66052bdf78ad72f7034f0b1851015959
'http://deb.debian.org/debian/pool/main/libg/libgcrypt20/libgcrypt20_1.8.7.orig.tar.bz2' libgcrypt20_1.8.7.orig.tar.bz2 2985660 SHA256:03b70f028299561b7034b8966d7dd77ef16ed139c43440925fe8782561974748
'http://deb.debian.org/debian/pool/main/libg/libgcrypt20/libgcrypt20_1.8.7.orig.tar.bz2.asc' libgcrypt20_1.8.7.orig.tar.bz2.asc 228 SHA256:eed6bb4174433640a02c1dc8851f34f85ec55b43d76a24bec87d7175784ef614
'http://deb.debian.org/debian/pool/main/libg/libgcrypt20/libgcrypt20_1.8.7-6.debian.tar.xz' libgcrypt20_1.8.7-6.debian.tar.xz 37564 SHA256:3fe8290b67416579fc99648ba025b8de732c4cc541b60b5f96f53d42a38916f5
```

Other potentially useful URLs:

- https://sources.debian.net/src/libgcrypt20/1.8.7-6/ (for browsing the source)
- https://sources.debian.net/src/libgcrypt20/1.8.7-6/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libgcrypt20/1.8.7-6/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libglu=9.0.1-1`

Binary Packages:

- `libglu1-mesa:amd64=9.0.1-1`
- `libglu1-mesa-dev:amd64=9.0.1-1`

Licenses: (parsed from: `/usr/share/doc/libglu1-mesa/copyright`, `/usr/share/doc/libglu1-mesa-dev/copyright`)

- `GPL-2`
- `LGPL-2`
- `SGI-1.1`
- `SGI-2`

Source:

```console
$ apt-get source -qq --print-uris libglu=9.0.1-1
'http://deb.debian.org/debian/pool/main/libg/libglu/libglu_9.0.1-1.dsc' libglu_9.0.1-1.dsc 1863 SHA256:c6c3e8687f692d1a66589e4fa4d187a2ac23322c83fa4678fdd556288fc500bc
'http://deb.debian.org/debian/pool/main/libg/libglu/libglu_9.0.1.orig.tar.gz' libglu_9.0.1.orig.tar.gz 662600 SHA256:f6f484cfcd51e489afe88031afdea1e173aa652697e4c19ddbcb8260579a10f7
'http://deb.debian.org/debian/pool/main/libg/libglu/libglu_9.0.1-1.diff.gz' libglu_9.0.1-1.diff.gz 14386 SHA256:fa9efc1f61ebe1eaf8ca51753395e019e7a20eb1c42d218badebec4f60a80e61
```

Other potentially useful URLs:

- https://sources.debian.net/src/libglu/9.0.1-1/ (for browsing the source)
- https://sources.debian.net/src/libglu/9.0.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libglu/9.0.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libglvnd=1.3.2-1`

Binary Packages:

- `libegl-dev:amd64=1.3.2-1`
- `libegl1:amd64=1.3.2-1`
- `libgl-dev:amd64=1.3.2-1`
- `libgl1:amd64=1.3.2-1`
- `libgles-dev:amd64=1.3.2-1`
- `libgles1:amd64=1.3.2-1`
- `libgles2:amd64=1.3.2-1`
- `libglvnd-dev:amd64=1.3.2-1`
- `libglvnd0:amd64=1.3.2-1`
- `libglx-dev:amd64=1.3.2-1`
- `libglx0:amd64=1.3.2-1`
- `libopengl-dev:amd64=1.3.2-1`
- `libopengl0:amd64=1.3.2-1`

Licenses: (parsed from: `/usr/share/doc/libegl-dev/copyright`, `/usr/share/doc/libegl1/copyright`, `/usr/share/doc/libgl-dev/copyright`, `/usr/share/doc/libgl1/copyright`, `/usr/share/doc/libgles-dev/copyright`, `/usr/share/doc/libgles1/copyright`, `/usr/share/doc/libgles2/copyright`, `/usr/share/doc/libglvnd-dev/copyright`, `/usr/share/doc/libglvnd0/copyright`, `/usr/share/doc/libglx-dev/copyright`, `/usr/share/doc/libglx0/copyright`, `/usr/share/doc/libopengl-dev/copyright`, `/usr/share/doc/libopengl0/copyright`)

- `Apache-2.0`
- `BSD-1-clause`
- `GPL`
- `GPL-3`
- `GPL-3+`
- `MIT`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris libglvnd=1.3.2-1
'http://deb.debian.org/debian/pool/main/libg/libglvnd/libglvnd_1.3.2-1.dsc' libglvnd_1.3.2-1.dsc 2709 SHA256:7a0435e3b5b7b56a8ab4e1ff3aedce400b139d3a6f2aabbeddae2852f51365fe
'http://deb.debian.org/debian/pool/main/libg/libglvnd/libglvnd_1.3.2.orig.tar.gz' libglvnd_1.3.2.orig.tar.gz 1032413 SHA256:6f41ace909302e6a063fd9dc04760b391a25a670ba5f4b6edf9e30f21410b673
'http://deb.debian.org/debian/pool/main/libg/libglvnd/libglvnd_1.3.2-1.debian.tar.xz' libglvnd_1.3.2-1.debian.tar.xz 21848 SHA256:9946fe273e758c05d01e6f046c43c08e8d7e888fc5980792032e3e4c326b2aa2
```

Other potentially useful URLs:

- https://sources.debian.net/src/libglvnd/1.3.2-1/ (for browsing the source)
- https://sources.debian.net/src/libglvnd/1.3.2-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libglvnd/1.3.2-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libgpg-error=1.38-2`

Binary Packages:

- `libgpg-error0:amd64=1.38-2`

Licenses: (parsed from: `/usr/share/doc/libgpg-error0/copyright`)

- `BSD-3-clause`
- `GPL-3`
- `GPL-3+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `g10-permissive`

Source:

```console
$ apt-get source -qq --print-uris libgpg-error=1.38-2
'http://deb.debian.org/debian/pool/main/libg/libgpg-error/libgpg-error_1.38-2.dsc' libgpg-error_1.38-2.dsc 2220 SHA256:ab0ea76aa3552afa664210a871abc74637acafd89c068edf8dc03521b8e22d64
'http://deb.debian.org/debian/pool/main/libg/libgpg-error/libgpg-error_1.38.orig.tar.bz2' libgpg-error_1.38.orig.tar.bz2 957637 SHA256:d8988275aa69d7149f931c10442e9e34c0242674249e171592b430ff7b3afd02
'http://deb.debian.org/debian/pool/main/libg/libgpg-error/libgpg-error_1.38.orig.tar.bz2.asc' libgpg-error_1.38.orig.tar.bz2.asc 488 SHA256:d80eb927d85e19e96d8de17552f8f48b517ae7acac7685404e8027475c5b4330
'http://deb.debian.org/debian/pool/main/libg/libgpg-error/libgpg-error_1.38-2.debian.tar.xz' libgpg-error_1.38-2.debian.tar.xz 19544 SHA256:824bcb278ead676c20f174bd551b1cc44a294137fabe6a1d892667882f3b4ba2
```

Other potentially useful URLs:

- https://sources.debian.net/src/libgpg-error/1.38-2/ (for browsing the source)
- https://sources.debian.net/src/libgpg-error/1.38-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libgpg-error/1.38-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libgudev=234-1`

Binary Packages:

- `libgudev-1.0-0:amd64=234-1`

Licenses: (parsed from: `/usr/share/doc/libgudev-1.0-0/copyright`)

- `LGPL-2`
- `LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris libgudev=234-1
'http://deb.debian.org/debian/pool/main/libg/libgudev/libgudev_234-1.dsc' libgudev_234-1.dsc 2325 SHA256:59e54d3c5911fd9ff86a15b7ff3f20a9d91747a9828c034ffdc51f51dc00442a
'http://deb.debian.org/debian/pool/main/libg/libgudev/libgudev_234.orig.tar.xz' libgudev_234.orig.tar.xz 273244 SHA256:1baeacacf0db42fa073ad5183d1decce9317857416a2b0f82ce3370d711a2e37
'http://deb.debian.org/debian/pool/main/libg/libgudev/libgudev_234-1.debian.tar.xz' libgudev_234-1.debian.tar.xz 4100 SHA256:9df51f86b3f2521b02411bab26a2de1fb3238d21110a60f5541fece2c57a5401
```

Other potentially useful URLs:

- https://sources.debian.net/src/libgudev/234-1/ (for browsing the source)
- https://sources.debian.net/src/libgudev/234-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libgudev/234-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libheif=1.11.0-1`

Binary Packages:

- `libheif1:amd64=1.11.0-1`

Licenses: (parsed from: `/usr/share/doc/libheif1/copyright`)

- `BOOST-1.0`
- `BSD-3-clause`
- `BSD-4-clause`
- `GPL-3`
- `GPL-3+`
- `LGPL-3`
- `LGPL-3+`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris libheif=1.11.0-1
'http://deb.debian.org/debian/pool/main/libh/libheif/libheif_1.11.0-1.dsc' libheif_1.11.0-1.dsc 2283 SHA256:231abbe32fbbbf2246da933d56ddf815894ee99f6bbd46320f460f0572f0f07a
'http://deb.debian.org/debian/pool/main/libh/libheif/libheif_1.11.0.orig.tar.gz' libheif_1.11.0.orig.tar.gz 1680855 SHA256:c550938f56ff6dac83702251a143f87cb3a6c71a50d8723955290832d9960913
'http://deb.debian.org/debian/pool/main/libh/libheif/libheif_1.11.0-1.debian.tar.xz' libheif_1.11.0-1.debian.tar.xz 6928 SHA256:ff569cd13ef0029e4404fa0204234c4c967b1d96587a7bc9d490f13d5dfbb241
```

Other potentially useful URLs:

- https://sources.debian.net/src/libheif/1.11.0-1/ (for browsing the source)
- https://sources.debian.net/src/libheif/1.11.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libheif/1.11.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libice=2:1.0.10-1`

Binary Packages:

- `libice-dev:amd64=2:1.0.10-1`
- `libice6:amd64=2:1.0.10-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libice=2:1.0.10-1
'http://deb.debian.org/debian/pool/main/libi/libice/libice_1.0.10-1.dsc' libice_1.0.10-1.dsc 2049 SHA256:adb7b4e250db838a476a44b5a941c8f935ac2b20858186f09228cd3e0696034d
'http://deb.debian.org/debian/pool/main/libi/libice/libice_1.0.10.orig.tar.gz' libice_1.0.10.orig.tar.gz 481960 SHA256:1116bc64c772fd127a0d0c0ffa2833479905e3d3d8197740b3abd5f292f22d2d
'http://deb.debian.org/debian/pool/main/libi/libice/libice_1.0.10-1.diff.gz' libice_1.0.10-1.diff.gz 11349 SHA256:d186b3877416a7e80f1923fe2fc736d576e585a41450bcf4cd5e74f9dd099362
```

Other potentially useful URLs:

- https://sources.debian.net/src/libice/2:1.0.10-1/ (for browsing the source)
- https://sources.debian.net/src/libice/2:1.0.10-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libice/2:1.0.10-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libidn2=2.3.0-5`

Binary Packages:

- `libidn2-0:amd64=2.3.0-5`

Licenses: (parsed from: `/usr/share/doc/libidn2-0/copyright`)

- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `LGPL-3`
- `LGPL-3+`
- `Unicode`

Source:

```console
$ apt-get source -qq --print-uris libidn2=2.3.0-5
'http://deb.debian.org/debian/pool/main/libi/libidn2/libidn2_2.3.0-5.dsc' libidn2_2.3.0-5.dsc 2046 SHA256:f8a787741b2395fe87c2773252e539bcc068fde0a5367316082cbbd2fed2be16
'http://deb.debian.org/debian/pool/main/libi/libidn2/libidn2_2.3.0.orig.tar.gz' libidn2_2.3.0.orig.tar.gz 2164993 SHA256:e1cb1db3d2e249a6a3eb6f0946777c2e892d5c5dc7bd91c74394fc3a01cab8b5
'http://deb.debian.org/debian/pool/main/libi/libidn2/libidn2_2.3.0-5.debian.tar.xz' libidn2_2.3.0-5.debian.tar.xz 11276 SHA256:e061b97d035e374bc6a948a514c26ad7d1bda31c8147cc8db02e604c82865a15
```

Other potentially useful URLs:

- https://sources.debian.net/src/libidn2/2.3.0-5/ (for browsing the source)
- https://sources.debian.net/src/libidn2/2.3.0-5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libidn2/2.3.0-5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libiec61883=1.2.0-4`

Binary Packages:

- `libiec61883-0:amd64=1.2.0-4`

Licenses: (parsed from: `/usr/share/doc/libiec61883-0/copyright`)

- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libiec61883=1.2.0-4
'http://deb.debian.org/debian/pool/main/libi/libiec61883/libiec61883_1.2.0-4.dsc' libiec61883_1.2.0-4.dsc 1987 SHA256:c6173a6a6632fae9a122e0156584fec920533eff16388f6343df125788fde545
'http://deb.debian.org/debian/pool/main/libi/libiec61883/libiec61883_1.2.0.orig.tar.gz' libiec61883_1.2.0.orig.tar.gz 339064 SHA256:7c7879c6b9add3148baea697dfbfdcefffbc8ac74e8e6bcf46125ec1d21b373a
'http://deb.debian.org/debian/pool/main/libi/libiec61883/libiec61883_1.2.0-4.debian.tar.xz' libiec61883_1.2.0-4.debian.tar.xz 7588 SHA256:9b3fee1be947b9d884221933bafa8a2270c519f4b08a74f9d3ce3029ad54fe3c
```

Other potentially useful URLs:

- https://sources.debian.net/src/libiec61883/1.2.0-4/ (for browsing the source)
- https://sources.debian.net/src/libiec61883/1.2.0-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libiec61883/1.2.0-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libjpeg-turbo=1:2.0.6-4`

Binary Packages:

- `libjpeg-dev:amd64=1:2.0.6-4`
- `libjpeg62-turbo:amd64=1:2.0.6-4`
- `libjpeg62-turbo-dev:amd64=1:2.0.6-4`

Licenses: (parsed from: `/usr/share/doc/libjpeg-dev/copyright`, `/usr/share/doc/libjpeg62-turbo/copyright`, `/usr/share/doc/libjpeg62-turbo-dev/copyright`)

- `BSD-3`
- `BSD-BY-LC-NE`
- `Expat`
- `NTP`
- `zlib`

Source:

```console
$ apt-get source -qq --print-uris libjpeg-turbo=1:2.0.6-4
'http://deb.debian.org/debian/pool/main/libj/libjpeg-turbo/libjpeg-turbo_2.0.6-4.dsc' libjpeg-turbo_2.0.6-4.dsc 2580 SHA256:fd357f8d1469236ad1f630c185a8af0f76f68c99cd082360148597a479148866
'http://deb.debian.org/debian/pool/main/libj/libjpeg-turbo/libjpeg-turbo_2.0.6.orig.tar.gz' libjpeg-turbo_2.0.6.orig.tar.gz 2192315 SHA256:d74b92ac33b0e3657123ddcf6728788c90dc84dcb6a52013d758af3c4af481bb
'http://deb.debian.org/debian/pool/main/libj/libjpeg-turbo/libjpeg-turbo_2.0.6.orig.tar.gz.asc' libjpeg-turbo_2.0.6.orig.tar.gz.asc 793 SHA256:ab2d95f62c2f25b39823c2b0ee3d72979786f5c310c19943a74eed8c2abc7b4b
'http://deb.debian.org/debian/pool/main/libj/libjpeg-turbo/libjpeg-turbo_2.0.6-4.debian.tar.xz' libjpeg-turbo_2.0.6-4.debian.tar.xz 100860 SHA256:31765ab6f069c8e1f11c0e43fd984dd903506b8eef8b810c06c3f80c796a144c
```

Other potentially useful URLs:

- https://sources.debian.net/src/libjpeg-turbo/1:2.0.6-4/ (for browsing the source)
- https://sources.debian.net/src/libjpeg-turbo/1:2.0.6-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libjpeg-turbo/1:2.0.6-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libksba=1.5.0-3+deb11u2`

Binary Packages:

- `libksba8:amd64=1.5.0-3+deb11u2`

Licenses: (parsed from: `/usr/share/doc/libksba8/copyright`)

- `FSFUL`
- `GPL-3`
- `LGPL-2.1-or-later`

Source:

```console
$ apt-get source -qq --print-uris libksba=1.5.0-3+deb11u2
'http://deb.debian.org/debian/pool/main/libk/libksba/libksba_1.5.0-3%2bdeb11u2.dsc' libksba_1.5.0-3+deb11u2.dsc 2255 SHA256:acf88e1fab76405a18e0b85753ae1a6d2b68d0634711b9f24f03f7ab77b7263a
'http://deb.debian.org/debian/pool/main/libk/libksba/libksba_1.5.0.orig.tar.bz2' libksba_1.5.0.orig.tar.bz2 656518 SHA256:ae4af129216b2d7fdea0b5bf2a788cd458a79c983bb09a43f4d525cc87aba0ba
'http://deb.debian.org/debian/pool/main/libk/libksba/libksba_1.5.0-3%2bdeb11u2.debian.tar.xz' libksba_1.5.0-3+deb11u2.debian.tar.xz 15672 SHA256:556d4370f91d73a2152c5a1979d792ed8a82de52c37b5c8cc5e5da8464bd6eed
```

Other potentially useful URLs:

- https://sources.debian.net/src/libksba/1.5.0-3+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/libksba/1.5.0-3+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libksba/1.5.0-3+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `liblqr=0.4.2-2.1`

Binary Packages:

- `liblqr-1-0:amd64=0.4.2-2.1`
- `liblqr-1-0-dev:amd64=0.4.2-2.1`

Licenses: (parsed from: `/usr/share/doc/liblqr-1-0/copyright`, `/usr/share/doc/liblqr-1-0-dev/copyright`)

- `GPL-3`
- `GPLv3`
- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris liblqr=0.4.2-2.1
'http://deb.debian.org/debian/pool/main/libl/liblqr/liblqr_0.4.2-2.1.dsc' liblqr_0.4.2-2.1.dsc 2095 SHA256:c54c34cd2f7470a29366eeacde2ca4859a97d684a406fb81a918b970c01d617c
'http://deb.debian.org/debian/pool/main/libl/liblqr/liblqr_0.4.2.orig.tar.gz' liblqr_0.4.2.orig.tar.gz 439884 SHA256:d4c22373432cca749e4326cd41fce365e6ff857c0bfd7a5302b8eb34b69f0336
'http://deb.debian.org/debian/pool/main/libl/liblqr/liblqr_0.4.2-2.1.debian.tar.xz' liblqr_0.4.2-2.1.debian.tar.xz 5300 SHA256:284a002f1ecac63ac17b1aafbb230da9ce7bd9efe2d5b94e8cad49b607eb2564
```

Other potentially useful URLs:

- https://sources.debian.net/src/liblqr/0.4.2-2.1/ (for browsing the source)
- https://sources.debian.net/src/liblqr/0.4.2-2.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/liblqr/0.4.2-2.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libmanette=0.2.5-1`

Binary Packages:

- `libmanette-0.2-0:amd64=0.2.5-1`

Licenses: (parsed from: `/usr/share/doc/libmanette-0.2-0/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris libmanette=0.2.5-1
'http://deb.debian.org/debian/pool/main/libm/libmanette/libmanette_0.2.5-1.dsc' libmanette_0.2.5-1.dsc 2351 SHA256:b52a0693b7feaa9b1e24e9be97cde119ea58639481a96752d4af6b9e08e7917e
'http://deb.debian.org/debian/pool/main/libm/libmanette/libmanette_0.2.5.orig.tar.xz' libmanette_0.2.5.orig.tar.xz 38192 SHA256:8006e08480c0cbd4f749ec155827d100447cf23903fad8240a7c4c321aa09a2b
'http://deb.debian.org/debian/pool/main/libm/libmanette/libmanette_0.2.5-1.debian.tar.xz' libmanette_0.2.5-1.debian.tar.xz 3028 SHA256:aa17db543f41cc7e671e419a61643ae40e02db394b3cd357846c4253e5557cf6
```

Other potentially useful URLs:

- https://sources.debian.net/src/libmanette/0.2.5-1/ (for browsing the source)
- https://sources.debian.net/src/libmanette/0.2.5-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libmanette/0.2.5-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libmaxminddb=1.5.2-1`

Binary Packages:

- `libmaxminddb-dev:amd64=1.5.2-1`
- `libmaxminddb0:amd64=1.5.2-1`

Licenses: (parsed from: `/usr/share/doc/libmaxminddb-dev/copyright`, `/usr/share/doc/libmaxminddb0/copyright`)

- `Apache-2.0`
- `BSD-2-clause`
- `BSD-3-clause`
- `BSD-4-clause`
- `CC-BY-SA-3.0`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris libmaxminddb=1.5.2-1
'http://deb.debian.org/debian/pool/main/libm/libmaxminddb/libmaxminddb_1.5.2-1.dsc' libmaxminddb_1.5.2-1.dsc 2322 SHA256:ffffa20e13b85b62961a39edd2caa59ae2fd4ff43abdc08f5a615ae6eab358c1
'http://deb.debian.org/debian/pool/main/libm/libmaxminddb/libmaxminddb_1.5.2.orig.tar.gz' libmaxminddb_1.5.2.orig.tar.gz 249507 SHA256:afbbaa34875a379ed443bfa43b38aae44ed2b547592ac3213c27c2e531f620d5
'http://deb.debian.org/debian/pool/main/libm/libmaxminddb/libmaxminddb_1.5.2-1.debian.tar.xz' libmaxminddb_1.5.2-1.debian.tar.xz 12328 SHA256:4ad8792791f91d7ed9ed8991076fe2abc8220ae80ac9a12bd339e89d71f05bfb
```

Other potentially useful URLs:

- https://sources.debian.net/src/libmaxminddb/1.5.2-1/ (for browsing the source)
- https://sources.debian.net/src/libmaxminddb/1.5.2-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libmaxminddb/1.5.2-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libmd=1.0.3-3`

Binary Packages:

- `libmd0:amd64=1.0.3-3`

Licenses: (parsed from: `/usr/share/doc/libmd0/copyright`)

- `BSD-2-clause`
- `BSD-2-clause-NetBSD`
- `BSD-3-clause`
- `BSD-3-clause-Aaron-D-Gifford`
- `Beerware`
- `ISC`
- `public-domain-md4`
- `public-domain-md5`
- `public-domain-sha1`

Source:

```console
$ apt-get source -qq --print-uris libmd=1.0.3-3
'http://deb.debian.org/debian/pool/main/libm/libmd/libmd_1.0.3-3.dsc' libmd_1.0.3-3.dsc 2248 SHA256:c3be656dc94c906898358e1d27394e1aec1769a0b5e09e8a4e8cace735ce9967
'http://deb.debian.org/debian/pool/main/libm/libmd/libmd_1.0.3.orig.tar.xz' libmd_1.0.3.orig.tar.xz 258584 SHA256:5a02097f95cc250a3f1001865e4dbba5f1d15554120f95693c0541923c52af4a
'http://deb.debian.org/debian/pool/main/libm/libmd/libmd_1.0.3.orig.tar.xz.asc' libmd_1.0.3.orig.tar.xz.asc 833 SHA256:690c82c27026093e0367b24de5f786b29f6cedacbae67bad3199190689940d3d
'http://deb.debian.org/debian/pool/main/libm/libmd/libmd_1.0.3-3.debian.tar.xz' libmd_1.0.3-3.debian.tar.xz 10104 SHA256:90f09c473c5ff61e3d937c656f12470610cc731cf9061490f651293d04f3c385
```

Other potentially useful URLs:

- https://sources.debian.net/src/libmd/1.0.3-3/ (for browsing the source)
- https://sources.debian.net/src/libmd/1.0.3-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libmd/1.0.3-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libnotify=0.7.9-3`

Binary Packages:

- `libnotify4:amd64=0.7.9-3`

Licenses: (parsed from: `/usr/share/doc/libnotify4/copyright`)

- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libnotify=0.7.9-3
'http://deb.debian.org/debian/pool/main/libn/libnotify/libnotify_0.7.9-3.dsc' libnotify_0.7.9-3.dsc 2678 SHA256:28d5c0c19b670fb0d7de4a3e58f7a6ab59ee5800c29472ca7f5a462421316971
'http://deb.debian.org/debian/pool/main/libn/libnotify/libnotify_0.7.9.orig.tar.xz' libnotify_0.7.9.orig.tar.xz 98148 SHA256:66c0517ed16df7af258e83208faaf5069727dfd66995c4bbc51c16954d674761
'http://deb.debian.org/debian/pool/main/libn/libnotify/libnotify_0.7.9-3.debian.tar.xz' libnotify_0.7.9-3.debian.tar.xz 8792 SHA256:8a980967e5ed263a8f77f5e4e3a0106f32aef3763dcf1182020e81c9ad8bb71e
```

Other potentially useful URLs:

- https://sources.debian.net/src/libnotify/0.7.9-3/ (for browsing the source)
- https://sources.debian.net/src/libnotify/0.7.9-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libnotify/0.7.9-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libnsl=1.3.0-2`

Binary Packages:

- `libnsl-dev:amd64=1.3.0-2`
- `libnsl2:amd64=1.3.0-2`

Licenses: (parsed from: `/usr/share/doc/libnsl-dev/copyright`, `/usr/share/doc/libnsl2/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2+-autoconf-exception`
- `GPL-2+-libtool-exception`
- `GPL-3`
- `GPL-3+-autoconf-exception`
- `LGPL-2.1`
- `LGPL-2.1+`
- `MIT`
- `permissive-autoconf-m4`
- `permissive-autoconf-m4-no-warranty`
- `permissive-configure`
- `permissive-fsf`
- `permissive-makefile-in`

Source:

```console
$ apt-get source -qq --print-uris libnsl=1.3.0-2
'http://deb.debian.org/debian/pool/main/libn/libnsl/libnsl_1.3.0-2.dsc' libnsl_1.3.0-2.dsc 1955 SHA256:1da570eed6693c774cce51f3c33f989d1aa4bf1dcb8660818d8a834a1a3728ef
'http://deb.debian.org/debian/pool/main/libn/libnsl/libnsl_1.3.0.orig.tar.xz' libnsl_1.3.0.orig.tar.xz 321488 SHA256:eac3062957fa302c62eff4aed718a07bacbf9ceb0a058289f12a19bfdda3c8e2
'http://deb.debian.org/debian/pool/main/libn/libnsl/libnsl_1.3.0-2.debian.tar.xz' libnsl_1.3.0-2.debian.tar.xz 4692 SHA256:7f8dccc706931b9e206448ffb475487a4a0abaded27cf611d418f4a34415dca7
```

Other potentially useful URLs:

- https://sources.debian.net/src/libnsl/1.3.0-2/ (for browsing the source)
- https://sources.debian.net/src/libnsl/1.3.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libnsl/1.3.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libogg=1.3.4-0.1`

Binary Packages:

- `libogg0:amd64=1.3.4-0.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libogg=1.3.4-0.1
'http://deb.debian.org/debian/pool/main/libo/libogg/libogg_1.3.4-0.1.dsc' libogg_1.3.4-0.1.dsc 1879 SHA256:f4ada902127c718aeba8f2095e89c9615bed48030a17ad2bbff9f12b66b1f2f1
'http://deb.debian.org/debian/pool/main/libo/libogg/libogg_1.3.4.orig.tar.gz' libogg_1.3.4.orig.tar.gz 589570 SHA256:fe5670640bd49e828d64d2879c31cb4dde9758681bb664f9bdbf159a01b0c76e
'http://deb.debian.org/debian/pool/main/libo/libogg/libogg_1.3.4-0.1.diff.gz' libogg_1.3.4-0.1.diff.gz 6988 SHA256:31f2fa8a06ebc4521595666ea1aa023f6698afea80a7ac40dca1fc6c59607080
```

Other potentially useful URLs:

- https://sources.debian.net/src/libogg/1.3.4-0.1/ (for browsing the source)
- https://sources.debian.net/src/libogg/1.3.4-0.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libogg/1.3.4-0.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libpciaccess=0.16-1`

Binary Packages:

- `libpciaccess0:amd64=0.16-1`

Licenses: (parsed from: `/usr/share/doc/libpciaccess0/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris libpciaccess=0.16-1
'http://deb.debian.org/debian/pool/main/libp/libpciaccess/libpciaccess_0.16-1.dsc' libpciaccess_0.16-1.dsc 2291 SHA256:1629fd3a9c09c476d4f78b1416a4d38e5d590aff67d29a9067ed74873e31f39e
'http://deb.debian.org/debian/pool/main/libp/libpciaccess/libpciaccess_0.16.orig.tar.gz' libpciaccess_0.16.orig.tar.gz 470061 SHA256:84413553994aef0070cf420050aa5c0a51b1956b404920e21b81e96db6a61a27
'http://deb.debian.org/debian/pool/main/libp/libpciaccess/libpciaccess_0.16.orig.tar.gz.asc' libpciaccess_0.16.orig.tar.gz.asc 659 SHA256:cda11f9c96ee0ea31c559e6e3d1db9f83f31cb8316b64cdaf6e96ad70a2a48af
'http://deb.debian.org/debian/pool/main/libp/libpciaccess/libpciaccess_0.16-1.diff.gz' libpciaccess_0.16-1.diff.gz 28450 SHA256:93e9f6f66c026e577cd47b79d35619bef7e093da7bd4be4c8af43f57603c79ef
```

Other potentially useful URLs:

- https://sources.debian.net/src/libpciaccess/0.16-1/ (for browsing the source)
- https://sources.debian.net/src/libpciaccess/0.16-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libpciaccess/0.16-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libpng1.6=1.6.37-3`

Binary Packages:

- `libpng-dev:amd64=1.6.37-3`
- `libpng16-16:amd64=1.6.37-3`

Licenses: (parsed from: `/usr/share/doc/libpng-dev/copyright`, `/usr/share/doc/libpng16-16/copyright`)

- `Apache-2.0`
- `BSD-3-clause`
- `BSD-like-with-advertising-clause`
- `GPL-2`
- `GPL-2+`
- `expat`
- `libpng`
- `libpng OR Apache-2.0 OR BSD-3-clause`

Source:

```console
$ apt-get source -qq --print-uris libpng1.6=1.6.37-3
'http://deb.debian.org/debian/pool/main/libp/libpng1.6/libpng1.6_1.6.37-3.dsc' libpng1.6_1.6.37-3.dsc 2225 SHA256:d6fac534b155e680849e700e4d2c87314e0ff20ab1b89fc22f1dfd2c24c1727b
'http://deb.debian.org/debian/pool/main/libp/libpng1.6/libpng1.6_1.6.37.orig.tar.gz' libpng1.6_1.6.37.orig.tar.gz 1508805 SHA256:ca74a0dace179a8422187671aee97dd3892b53e168627145271cad5b5ac81307
'http://deb.debian.org/debian/pool/main/libp/libpng1.6/libpng1.6_1.6.37-3.debian.tar.xz' libpng1.6_1.6.37-3.debian.tar.xz 32272 SHA256:d28b11e41dba39c53d8d87be5f70cc96a246f296307855f55d86db03b24680d4
```

Other potentially useful URLs:

- https://sources.debian.net/src/libpng1.6/1.6.37-3/ (for browsing the source)
- https://sources.debian.net/src/libpng1.6/1.6.37-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libpng1.6/1.6.37-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libproxy=0.4.17-1`

Binary Packages:

- `libproxy1v5:amd64=0.4.17-1`

Licenses: (parsed from: `/usr/share/doc/libproxy1v5/copyright`)

- `GPL`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libproxy=0.4.17-1
'http://deb.debian.org/debian/pool/main/libp/libproxy/libproxy_0.4.17-1.dsc' libproxy_0.4.17-1.dsc 3105 SHA256:5bd51f07e1328d7245eea29d33b6f1d41cd5323e5667fde1df6801f7287337cb
'http://deb.debian.org/debian/pool/main/libp/libproxy/libproxy_0.4.17.orig.tar.gz' libproxy_0.4.17.orig.tar.gz 95542 SHA256:88c624711412665515e2800a7e564aabb5b3ee781b9820eca9168035b0de60a9
'http://deb.debian.org/debian/pool/main/libp/libproxy/libproxy_0.4.17-1.debian.tar.xz' libproxy_0.4.17-1.debian.tar.xz 12920 SHA256:2ffbcf4e8b3ebbdb64313100818c4aded86ea9c73f69d535ca10bbaeb89ce5e7
```

Other potentially useful URLs:

- https://sources.debian.net/src/libproxy/0.4.17-1/ (for browsing the source)
- https://sources.debian.net/src/libproxy/0.4.17-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libproxy/0.4.17-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libpsl=0.21.0-1.2`

Binary Packages:

- `libpsl5:amd64=0.21.0-1.2`

Licenses: (parsed from: `/usr/share/doc/libpsl5/copyright`)

- `Chromium`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris libpsl=0.21.0-1.2
'http://deb.debian.org/debian/pool/main/libp/libpsl/libpsl_0.21.0-1.2.dsc' libpsl_0.21.0-1.2.dsc 2216 SHA256:d46b69dd1cb43dc48375d70c4895d0a0d5964131196a7de4e0ad1ea2912d6df4
'http://deb.debian.org/debian/pool/main/libp/libpsl/libpsl_0.21.0.orig.tar.gz' libpsl_0.21.0.orig.tar.gz 8598583 SHA256:055aa87ec166c7afb985d0816c07ff440e1eb899881a318c51c69a0aeea8e279
'http://deb.debian.org/debian/pool/main/libp/libpsl/libpsl_0.21.0-1.2.debian.tar.xz' libpsl_0.21.0-1.2.debian.tar.xz 12724 SHA256:012d3b6ec5634c59e6a4aa9f854d756ef23f08edf21d70ae5a888c55e95abd5d
```

Other potentially useful URLs:

- https://sources.debian.net/src/libpsl/0.21.0-1.2/ (for browsing the source)
- https://sources.debian.net/src/libpsl/0.21.0-1.2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libpsl/0.21.0-1.2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libpthread-stubs=0.4-1`

Binary Packages:

- `libpthread-stubs0-dev:amd64=0.4-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libpthread-stubs=0.4-1
'http://deb.debian.org/debian/pool/main/libp/libpthread-stubs/libpthread-stubs_0.4-1.dsc' libpthread-stubs_0.4-1.dsc 1927 SHA256:8923683ac365475d2cc515e5f16f4adc8bd8e37453e1a2a6bedeb9246922829f
'http://deb.debian.org/debian/pool/main/libp/libpthread-stubs/libpthread-stubs_0.4.orig.tar.gz' libpthread-stubs_0.4.orig.tar.gz 71252 SHA256:50d5686b79019ccea08bcbd7b02fe5a40634abcfd4146b6e75c6420cc170e9d9
'http://deb.debian.org/debian/pool/main/libp/libpthread-stubs/libpthread-stubs_0.4-1.diff.gz' libpthread-stubs_0.4-1.diff.gz 2346 SHA256:ec435ba2852ad4b0522010943a5b7d39fc7e088067367879778cf10e57f5cc3f
```

Other potentially useful URLs:

- https://sources.debian.net/src/libpthread-stubs/0.4-1/ (for browsing the source)
- https://sources.debian.net/src/libpthread-stubs/0.4-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libpthread-stubs/0.4-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libraw1394=2.1.2-2`

Binary Packages:

- `libraw1394-11:amd64=2.1.2-2`

Licenses: (parsed from: `/usr/share/doc/libraw1394-11/copyright`)

- `GPL`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris libraw1394=2.1.2-2
'http://deb.debian.org/debian/pool/main/libr/libraw1394/libraw1394_2.1.2-2.dsc' libraw1394_2.1.2-2.dsc 1994 SHA256:682c04e351576bb77c6992af4994ed6f20e5ce5b70035a0f8774a1e613654578
'http://deb.debian.org/debian/pool/main/libr/libraw1394/libraw1394_2.1.2.orig.tar.gz' libraw1394_2.1.2.orig.tar.gz 458134 SHA256:ddc4e32721cdfe680d964aaede68ac606a20cd17dd2ba70e2d7e0692086ab57c
'http://deb.debian.org/debian/pool/main/libr/libraw1394/libraw1394_2.1.2-2.debian.tar.xz' libraw1394_2.1.2-2.debian.tar.xz 6740 SHA256:8797ae8f8fd47971ba248e313533006dbb878dba17f239a9b8d42e471d678a77
```

Other potentially useful URLs:

- https://sources.debian.net/src/libraw1394/2.1.2-2/ (for browsing the source)
- https://sources.debian.net/src/libraw1394/2.1.2-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libraw1394/2.1.2-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `librest=0.8.1-1.1`

Binary Packages:

- `librest-0.7-0:amd64=0.8.1-1.1`

Licenses: (parsed from: `/usr/share/doc/librest-0.7-0/copyright`)

- `FSF-INSTALL`
- `FSF-aclocal`
- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `MIT with XConsortium exception `

Source:

```console
$ apt-get source -qq --print-uris librest=0.8.1-1.1
'http://deb.debian.org/debian/pool/main/libr/librest/librest_0.8.1-1.1.dsc' librest_0.8.1-1.1.dsc 2397 SHA256:00af815da5a8c616baa75041a595245d6d9ad349d8768d38c93da15950a4ea36
'http://deb.debian.org/debian/pool/main/libr/librest/librest_0.8.1.orig.tar.bz2' librest_0.8.1.orig.tar.bz2 68249 SHA256:9063b9906c3a4684bef6ccaad9462e8409e1025fe37b7c9596fcf2f5f7507904
'http://deb.debian.org/debian/pool/main/libr/librest/librest_0.8.1-1.1.debian.tar.xz' librest_0.8.1-1.1.debian.tar.xz 6820 SHA256:acd925bc04905d16c11eea736a5438db86c682c822b5479ab04a74cc36362fb3
```

Other potentially useful URLs:

- https://sources.debian.net/src/librest/0.8.1-1.1/ (for browsing the source)
- https://sources.debian.net/src/librest/0.8.1-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/librest/0.8.1-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `librsvg=2.50.3+dfsg-1+deb11u1`

Binary Packages:

- `gir1.2-rsvg-2.0:amd64=2.50.3+dfsg-1+deb11u1`
- `librsvg2-2:amd64=2.50.3+dfsg-1+deb11u1`
- `librsvg2-common:amd64=2.50.3+dfsg-1+deb11u1`
- `librsvg2-dev:amd64=2.50.3+dfsg-1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/gir1.2-rsvg-2.0/copyright`, `/usr/share/doc/librsvg2-2/copyright`, `/usr/share/doc/librsvg2-common/copyright`, `/usr/share/doc/librsvg2-dev/copyright`)

- `0BSD`
- `0BSD,`
- `Apache-2.0`
- `Apache-2.0,`
- `BSD-2-clause`
- `BSD-2-clause,`
- `BSD-3-clause`
- `BSD-3-clause,`
- `Boost-1.0`
- `Boost-1.0,`
- `CC-BY-3.0`
- `Expat`
- `Expat,`
- `LGPL-2`
- `LGPL-2+`
- `MPL-2.0`
- `MPL-2.0,`
- `Sun-permissive`
- `Sun-permissive,`
- `Unlicense`
- `Unlicense,`
- `zlib`

Source:

```console
$ apt-get source -qq --print-uris librsvg=2.50.3+dfsg-1+deb11u1
'http://deb.debian.org/debian/pool/main/libr/librsvg/librsvg_2.50.3%2bdfsg-1%2bdeb11u1.dsc' librsvg_2.50.3+dfsg-1+deb11u1.dsc 3033 SHA256:e53781567bc5b1bbc83c4c212e88315a4eb659790431e24c979269acd7c0b0b2
'http://deb.debian.org/debian/pool/main/libr/librsvg/librsvg_2.50.3%2bdfsg.orig.tar.xz' librsvg_2.50.3+dfsg.orig.tar.xz 16290880 SHA256:6aa4e614292de77c6b5fa1fd05d6c5d658d4bb9857f678b7b57d0865d5e50116
'http://deb.debian.org/debian/pool/main/libr/librsvg/librsvg_2.50.3%2bdfsg-1%2bdeb11u1.debian.tar.xz' librsvg_2.50.3+dfsg-1+deb11u1.debian.tar.xz 33936 SHA256:959b744c95516d8aa90034c3f48fb8c519440e8633649f71fdb0e39306824667
```

Other potentially useful URLs:

- https://sources.debian.net/src/librsvg/2.50.3+dfsg-1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/librsvg/2.50.3+dfsg-1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/librsvg/2.50.3+dfsg-1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libsamplerate=0.2.1+ds0-1`

Binary Packages:

- `libsamplerate0:amd64=0.2.1+ds0-1`

Licenses: (parsed from: `/usr/share/doc/libsamplerate0/copyright`)

- `BSD-2-clause`
- `FSFAP`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris libsamplerate=0.2.1+ds0-1
'http://deb.debian.org/debian/pool/main/libs/libsamplerate/libsamplerate_0.2.1%2bds0-1.dsc' libsamplerate_0.2.1+ds0-1.dsc 2353 SHA256:c85a46a10c3e1c224e38b2461b5c7d690d932c5a1d81f14ea2842a7ac946f3b1
'http://deb.debian.org/debian/pool/main/libs/libsamplerate/libsamplerate_0.2.1%2bds0.orig.tar.xz' libsamplerate_0.2.1+ds0.orig.tar.xz 3074352 SHA256:1358865013ca0ebcc8fcc5d7109572bdf25d42bc2bfa9826b1e88e37c774ade7
'http://deb.debian.org/debian/pool/main/libs/libsamplerate/libsamplerate_0.2.1%2bds0-1.debian.tar.xz' libsamplerate_0.2.1+ds0-1.debian.tar.xz 7212 SHA256:1ff5e1df61278e029dd1e131a29c332700d3d29d4b74e2e821e31cda15bc58cf
```

Other potentially useful URLs:

- https://sources.debian.net/src/libsamplerate/0.2.1+ds0-1/ (for browsing the source)
- https://sources.debian.net/src/libsamplerate/0.2.1+ds0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libsamplerate/0.2.1+ds0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libseccomp=2.5.1-1+deb11u1`

Binary Packages:

- `libseccomp2:amd64=2.5.1-1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libseccomp2/copyright`)

- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libseccomp=2.5.1-1+deb11u1
'http://deb.debian.org/debian/pool/main/libs/libseccomp/libseccomp_2.5.1-1%2bdeb11u1.dsc' libseccomp_2.5.1-1+deb11u1.dsc 2708 SHA256:6a2a00eb5f45e794a2203805348a3990d46f4ded63f8708d3382994ece729436
'http://deb.debian.org/debian/pool/main/libs/libseccomp/libseccomp_2.5.1.orig.tar.gz' libseccomp_2.5.1.orig.tar.gz 638811 SHA256:ee307e383c77aa7995abc5ada544d51c9723ae399768a97667d4cdb3c3a30d55
'http://deb.debian.org/debian/pool/main/libs/libseccomp/libseccomp_2.5.1.orig.tar.gz.asc' libseccomp_2.5.1.orig.tar.gz.asc 833 SHA256:14d45c86e5ceed5ac5511c3ebf70a4dca128b7584b314dc8a551c779ea225d2e
'http://deb.debian.org/debian/pool/main/libs/libseccomp/libseccomp_2.5.1-1%2bdeb11u1.debian.tar.xz' libseccomp_2.5.1-1+deb11u1.debian.tar.xz 19524 SHA256:a09ef7c0b9b6464f426b78a7b978d8566da53667c1a234234ffd2cc600543200
```

Other potentially useful URLs:

- https://sources.debian.net/src/libseccomp/2.5.1-1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/libseccomp/2.5.1-1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libseccomp/2.5.1-1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libsecret=0.20.4-2`

Binary Packages:

- `libsecret-1-0:amd64=0.20.4-2`
- `libsecret-common=0.20.4-2`

Licenses: (parsed from: `/usr/share/doc/libsecret-1-0/copyright`, `/usr/share/doc/libsecret-common/copyright`)

- `Apache-2.0`
- `BSD-3-clause`
- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris libsecret=0.20.4-2
'http://deb.debian.org/debian/pool/main/libs/libsecret/libsecret_0.20.4-2.dsc' libsecret_0.20.4-2.dsc 2814 SHA256:59fc8a6bb7d4c7096edb77c49e4c8acf593b0196abf3af2dcef3f7133fe71d07
'http://deb.debian.org/debian/pool/main/libs/libsecret/libsecret_0.20.4.orig.tar.xz' libsecret_0.20.4.orig.tar.xz 529916 SHA256:325a4c54db320c406711bf2b55e5cb5b6c29823426aa82596a907595abb39d28
'http://deb.debian.org/debian/pool/main/libs/libsecret/libsecret_0.20.4-2.debian.tar.xz' libsecret_0.20.4-2.debian.tar.xz 9740 SHA256:516072eafc59c72b977b3695285591b9316e50c700b8ea31c38788106b087eb5
```

Other potentially useful URLs:

- https://sources.debian.net/src/libsecret/0.20.4-2/ (for browsing the source)
- https://sources.debian.net/src/libsecret/0.20.4-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libsecret/0.20.4-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libselinux=3.1-3`

Binary Packages:

- `libselinux1:amd64=3.1-3`
- `libselinux1-dev:amd64=3.1-3`

Licenses: (parsed from: `/usr/share/doc/libselinux1/copyright`, `/usr/share/doc/libselinux1-dev/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libselinux=3.1-3
'http://deb.debian.org/debian/pool/main/libs/libselinux/libselinux_3.1-3.dsc' libselinux_3.1-3.dsc 2300 SHA256:42810484f3776af09a2e0ab726e3be877fc8a54d6bf51702e46c22f945ab5177
'http://deb.debian.org/debian/pool/main/libs/libselinux/libselinux_3.1.orig.tar.gz' libselinux_3.1.orig.tar.gz 204703 SHA256:ea5dcbb4d859e3f999c26a13c630da2f16dff9462e3cc8cb7b458ac157d112e7
'http://deb.debian.org/debian/pool/main/libs/libselinux/libselinux_3.1-3.debian.tar.xz' libselinux_3.1-3.debian.tar.xz 24176 SHA256:7170ab6914f0d2e93de169da312df961f799f5d58cc0a4c552e3f8a7882f3c81
```

Other potentially useful URLs:

- https://sources.debian.net/src/libselinux/3.1-3/ (for browsing the source)
- https://sources.debian.net/src/libselinux/3.1-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libselinux/3.1-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libsemanage=3.1-1`

Binary Packages:

- `libsemanage-common=3.1-1`
- `libsemanage1:amd64=3.1-1+b2`

Licenses: (parsed from: `/usr/share/doc/libsemanage-common/copyright`, `/usr/share/doc/libsemanage1/copyright`)

- `GPL`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris libsemanage=3.1-1
'http://deb.debian.org/debian/pool/main/libs/libsemanage/libsemanage_3.1-1.dsc' libsemanage_3.1-1.dsc 2339 SHA256:d49f9c29d0ad9c8b42145e0926919df962b58823e9fc22002bbb00333276170d
'http://deb.debian.org/debian/pool/main/libs/libsemanage/libsemanage_3.1.orig.tar.gz' libsemanage_3.1.orig.tar.gz 179601 SHA256:22d6c75526e40d1781c30bcf29abf97171bdfe6780923f11c8e1c76a75a21ff8
'http://deb.debian.org/debian/pool/main/libs/libsemanage/libsemanage_3.1-1.debian.tar.xz' libsemanage_3.1-1.debian.tar.xz 17556 SHA256:185b151158faaaf3d8f9ff939f29efd3eb5dbb050d01a87d3fde6cf40e778648
```

Other potentially useful URLs:

- https://sources.debian.net/src/libsemanage/3.1-1/ (for browsing the source)
- https://sources.debian.net/src/libsemanage/3.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libsemanage/3.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libsepol=3.1-1`

Binary Packages:

- `libsepol1:amd64=3.1-1`
- `libsepol1-dev:amd64=3.1-1`

Licenses: (parsed from: `/usr/share/doc/libsepol1/copyright`, `/usr/share/doc/libsepol1-dev/copyright`)

- `GPL`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris libsepol=3.1-1
'http://deb.debian.org/debian/pool/main/libs/libsepol/libsepol_3.1-1.dsc' libsepol_3.1-1.dsc 1776 SHA256:37bfb6797af8a96eada6c6ace374292b8a16a6bfb557b1e8ab9fd29e72d5888a
'http://deb.debian.org/debian/pool/main/libs/libsepol/libsepol_3.1.orig.tar.gz' libsepol_3.1.orig.tar.gz 473842 SHA256:ae6778d01443fdd38cd30eeee846494e19f4d407b09872580372f4aa4bf8a3cc
'http://deb.debian.org/debian/pool/main/libs/libsepol/libsepol_3.1-1.debian.tar.xz' libsepol_3.1-1.debian.tar.xz 14584 SHA256:9351a0b6207f6a5da2951292d3ec5655feb89df5aabc9010094766d811156166
```

Other potentially useful URLs:

- https://sources.debian.net/src/libsepol/3.1-1/ (for browsing the source)
- https://sources.debian.net/src/libsepol/3.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libsepol/3.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libshout=2.4.5-1`

Binary Packages:

- `libshout3:amd64=2.4.5-1+b1`

Licenses: (parsed from: `/usr/share/doc/libshout3/copyright`)

- `FSFUL`
- `FSFULLR`
- `FSFULLR~Makefile.in`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with Autoconf exception`
- `GPL-2+ with Libtool exception`
- `GPL-3`
- `GPL-3+`
- `GPL-3+~file`
- `GPL-3+~file with Autoconf exception`
- `LGPL-2`
- `LGPL-2+`
- `NTP~Rushing`
- `X11`

Source:

```console
$ apt-get source -qq --print-uris libshout=2.4.5-1
'http://deb.debian.org/debian/pool/main/libs/libshout/libshout_2.4.5-1.dsc' libshout_2.4.5-1.dsc 2283 SHA256:6fb939cd60e9b04cc09b7d63e85e74a71522c17897d1cb7cdd06769b359a4760
'http://deb.debian.org/debian/pool/main/libs/libshout/libshout_2.4.5.orig.tar.gz' libshout_2.4.5.orig.tar.gz 543991 SHA256:d9e568668a673994ebe3f1eb5f2bee06e3236a5db92b8d0c487e1c0f886a6890
'http://deb.debian.org/debian/pool/main/libs/libshout/libshout_2.4.5-1.debian.tar.xz' libshout_2.4.5-1.debian.tar.xz 12264 SHA256:27fc897abb69ea22ee32949329b508f432c75f31d84cade8c1f49106822858ca
```

Other potentially useful URLs:

- https://sources.debian.net/src/libshout/2.4.5-1/ (for browsing the source)
- https://sources.debian.net/src/libshout/2.4.5-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libshout/2.4.5-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libsigsegv=2.13-1`

Binary Packages:

- `libsigsegv2:amd64=2.13-1`

Licenses: (parsed from: `/usr/share/doc/libsigsegv2/copyright`)

- `GPL-2`
- `GPL-2+`
- `GPL-2+ with Autoconf exception`
- `permissive-fsf`
- `permissive-other`

Source:

```console
$ apt-get source -qq --print-uris libsigsegv=2.13-1
'http://deb.debian.org/debian/pool/main/libs/libsigsegv/libsigsegv_2.13-1.dsc' libsigsegv_2.13-1.dsc 2338 SHA256:6e22271eb31721e6b55b401c830aa2459654d3d08bd53688e86037b71fef5170
'http://deb.debian.org/debian/pool/main/libs/libsigsegv/libsigsegv_2.13.orig.tar.gz' libsigsegv_2.13.orig.tar.gz 460736 SHA256:be78ee4176b05f7c75ff03298d84874db90f4b6c9d5503f0da1226b3a3c48119
'http://deb.debian.org/debian/pool/main/libs/libsigsegv/libsigsegv_2.13.orig.tar.gz.asc' libsigsegv_2.13.orig.tar.gz.asc 819 SHA256:f63cbbc68da4a53b685dc373b5c11d0b0cdf467be9391efc89c88c440d74df36
'http://deb.debian.org/debian/pool/main/libs/libsigsegv/libsigsegv_2.13-1.debian.tar.xz' libsigsegv_2.13-1.debian.tar.xz 8572 SHA256:4210f5c3b99fd2521490f52345b4faca591f2fabb09b19a14e5644e8da8ac59a
```

Other potentially useful URLs:

- https://sources.debian.net/src/libsigsegv/2.13-1/ (for browsing the source)
- https://sources.debian.net/src/libsigsegv/2.13-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libsigsegv/2.13-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libsm=2:1.2.3-1`

Binary Packages:

- `libsm-dev:amd64=2:1.2.3-1`
- `libsm6:amd64=2:1.2.3-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libsm=2:1.2.3-1
'http://deb.debian.org/debian/pool/main/libs/libsm/libsm_1.2.3-1.dsc' libsm_1.2.3-1.dsc 2063 SHA256:5488f8de81d53c32cbb5f062b6a6f262cd067283b8082041392dc60f0d04002c
'http://deb.debian.org/debian/pool/main/libs/libsm/libsm_1.2.3.orig.tar.gz' libsm_1.2.3.orig.tar.gz 445362 SHA256:1e92408417cb6c6c477a8a6104291001a40b3bb56a4a60608fdd9cd2c5a0f320
'http://deb.debian.org/debian/pool/main/libs/libsm/libsm_1.2.3-1.diff.gz' libsm_1.2.3-1.diff.gz 8929 SHA256:7eb99ab50b19f26d1470f89e4b46891f6a697cb1794a58ed0d1376cceaf1b6a9
```

Other potentially useful URLs:

- https://sources.debian.net/src/libsm/2:1.2.3-1/ (for browsing the source)
- https://sources.debian.net/src/libsm/2:1.2.3-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libsm/2:1.2.3-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libsndfile=1.0.31-2`

Binary Packages:

- `libsndfile1:amd64=1.0.31-2`

Licenses: (parsed from: `/usr/share/doc/libsndfile1/copyright`)

- `Apache-2.0`
- `BSD-3-clause`
- `FSFAP`
- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `gsm`
- `sun`

Source:

```console
$ apt-get source -qq --print-uris libsndfile=1.0.31-2
'http://deb.debian.org/debian/pool/main/libs/libsndfile/libsndfile_1.0.31-2.dsc' libsndfile_1.0.31-2.dsc 2296 SHA256:325bf30be4857a5a7eac9866d0161d33804cc6d2b4afc33ee025f30e79c295fc
'http://deb.debian.org/debian/pool/main/libs/libsndfile/libsndfile_1.0.31.orig.tar.gz' libsndfile_1.0.31.orig.tar.gz 662584 SHA256:8cdee0acb06bb0a3c1a6ca524575643df8b1f3a55a0893b4dd9f829d08263785
'http://deb.debian.org/debian/pool/main/libs/libsndfile/libsndfile_1.0.31-2.debian.tar.xz' libsndfile_1.0.31-2.debian.tar.xz 14264 SHA256:54eb467c9026753ccd5d9aee2247ccdc512e87542589fff9fe51ca3e3d36e653
```

Other potentially useful URLs:

- https://sources.debian.net/src/libsndfile/1.0.31-2/ (for browsing the source)
- https://sources.debian.net/src/libsndfile/1.0.31-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libsndfile/1.0.31-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libsoup2.4=2.72.0-2`

Binary Packages:

- `libsoup-gnome2.4-1:amd64=2.72.0-2`
- `libsoup2.4-1:amd64=2.72.0-2`

Licenses: (parsed from: `/usr/share/doc/libsoup-gnome2.4-1/copyright`, `/usr/share/doc/libsoup2.4-1/copyright`)

- `Expat`
- `LGPL-2`
- `LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris libsoup2.4=2.72.0-2
'http://deb.debian.org/debian/pool/main/libs/libsoup2.4/libsoup2.4_2.72.0-2.dsc' libsoup2.4_2.72.0-2.dsc 3293 SHA256:178fc20e7c2cccd910d6959b52681c59b18da2de84b7fc7d36fc78fae7f8b7c5
'http://deb.debian.org/debian/pool/main/libs/libsoup2.4/libsoup2.4_2.72.0.orig.tar.xz' libsoup2.4_2.72.0.orig.tar.xz 1477940 SHA256:170c3f8446b0f65f8e4b93603349172b1085fb8917c181d10962f02bb85f5387
'http://deb.debian.org/debian/pool/main/libs/libsoup2.4/libsoup2.4_2.72.0-2.debian.tar.xz' libsoup2.4_2.72.0-2.debian.tar.xz 25556 SHA256:1031865e4500e3c739a75187144c7891c641832c7c41eb32663985f243293f66
```

Other potentially useful URLs:

- https://sources.debian.net/src/libsoup2.4/2.72.0-2/ (for browsing the source)
- https://sources.debian.net/src/libsoup2.4/2.72.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libsoup2.4/2.72.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libssh2=1.9.0-2+deb11u1`

Binary Packages:

- `libssh2-1:amd64=1.9.0-2+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libssh2-1/copyright`)

- `BSD3`

Source:

```console
$ apt-get source -qq --print-uris libssh2=1.9.0-2+deb11u1
'http://deb.debian.org/debian/pool/main/libs/libssh2/libssh2_1.9.0-2%2bdeb11u1.dsc' libssh2_1.9.0-2+deb11u1.dsc 2039 SHA256:d1927132489695d986ae2c5e3cda5d325aa2c5ab6b0572ebe2e1f39b5116b16b
'http://deb.debian.org/debian/pool/main/libs/libssh2/libssh2_1.9.0.orig.tar.gz' libssh2_1.9.0.orig.tar.gz 888551 SHA256:d5fb8bd563305fd1074dda90bd053fb2d29fc4bce048d182f96eaa466dfadafd
'http://deb.debian.org/debian/pool/main/libs/libssh2/libssh2_1.9.0-2%2bdeb11u1.debian.tar.xz' libssh2_1.9.0-2+deb11u1.debian.tar.xz 9356 SHA256:094bfb01c5f721ef20718c9e435edefeed98231e19bef848d48ea0b93ba1dc5b
```

Other potentially useful URLs:

- https://sources.debian.net/src/libssh2/1.9.0-2+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/libssh2/1.9.0-2+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libssh2/1.9.0-2+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libtasn1-6=4.16.0-2+deb11u1`

Binary Packages:

- `libtasn1-6:amd64=4.16.0-2+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libtasn1-6/copyright`)

- `GFDL-1.3`
- `GPL-3`
- `LGPL`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris libtasn1-6=4.16.0-2+deb11u1
'http://deb.debian.org/debian/pool/main/libt/libtasn1-6/libtasn1-6_4.16.0-2%2bdeb11u1.dsc' libtasn1-6_4.16.0-2+deb11u1.dsc 2618 SHA256:795155e19208ef5cf07534cd0fc0664b6144f94c16eec03d80fdee7a14f838b8
'http://deb.debian.org/debian/pool/main/libt/libtasn1-6/libtasn1-6_4.16.0.orig.tar.gz' libtasn1-6_4.16.0.orig.tar.gz 1812442 SHA256:0e0fb0903839117cb6e3b56e68222771bebf22ad7fc2295a0ed7d576e8d4329d
'http://deb.debian.org/debian/pool/main/libt/libtasn1-6/libtasn1-6_4.16.0.orig.tar.gz.asc' libtasn1-6_4.16.0.orig.tar.gz.asc 488 SHA256:06c201e8c3b43c27465ed79294d4c4ec8dcd3e95e4a6176ecbf273229ee3e2d0
'http://deb.debian.org/debian/pool/main/libt/libtasn1-6/libtasn1-6_4.16.0-2%2bdeb11u1.debian.tar.xz' libtasn1-6_4.16.0-2+deb11u1.debian.tar.xz 18324 SHA256:85198cc8eac7ecf5dc8bf220b0973c4ccd6c039217240fbf45ffe49860aacdd1
```

Other potentially useful URLs:

- https://sources.debian.net/src/libtasn1-6/4.16.0-2+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/libtasn1-6/4.16.0-2+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libtasn1-6/4.16.0-2+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libtext-iconv-perl=1.7-7`

Binary Packages:

- `libtext-iconv-perl=1.7-7+b1`

Licenses: (parsed from: `/usr/share/doc/libtext-iconv-perl/copyright`)

- `Artistic`
- `GPL-1`
- `GPL-1+`

Source:

```console
$ apt-get source -qq --print-uris libtext-iconv-perl=1.7-7
'http://deb.debian.org/debian/pool/main/libt/libtext-iconv-perl/libtext-iconv-perl_1.7-7.dsc' libtext-iconv-perl_1.7-7.dsc 2242 SHA256:7fd0b1d78c4d461acbc397469f2f712c3eb2b47f1ba0b7c7369c6b394b61a3df
'http://deb.debian.org/debian/pool/main/libt/libtext-iconv-perl/libtext-iconv-perl_1.7.orig.tar.bz2' libtext-iconv-perl_1.7.orig.tar.bz2 9977 SHA256:815c5169b7afc40bc6f681b4c615ff8fb0e073d87422280c8c759a4666567490
'http://deb.debian.org/debian/pool/main/libt/libtext-iconv-perl/libtext-iconv-perl_1.7-7.debian.tar.xz' libtext-iconv-perl_1.7-7.debian.tar.xz 3388 SHA256:7a190875bc60395d81ae36d73290694cd8f0158abbe6ea6759b038a65d838286
```

Other potentially useful URLs:

- https://sources.debian.net/src/libtext-iconv-perl/1.7-7/ (for browsing the source)
- https://sources.debian.net/src/libtext-iconv-perl/1.7-7/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libtext-iconv-perl/1.7-7/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libthai=0.1.28-3`

Binary Packages:

- `libthai-data=0.1.28-3`
- `libthai0:amd64=0.1.28-3`

Licenses: (parsed from: `/usr/share/doc/libthai-data/copyright`, `/usr/share/doc/libthai0/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris libthai=0.1.28-3
'http://deb.debian.org/debian/pool/main/libt/libthai/libthai_0.1.28-3.dsc' libthai_0.1.28-3.dsc 2346 SHA256:a6317b6a8e4ba40cedb10a9a659fc23885bfbe5eb8cf3a8b325a86064b0a542d
'http://deb.debian.org/debian/pool/main/libt/libthai/libthai_0.1.28.orig.tar.xz' libthai_0.1.28.orig.tar.xz 413592 SHA256:ffe0a17b4b5aa11b153c15986800eca19f6c93a4025ffa5cf2cab2dcdf1ae911
'http://deb.debian.org/debian/pool/main/libt/libthai/libthai_0.1.28-3.debian.tar.xz' libthai_0.1.28-3.debian.tar.xz 12128 SHA256:bca48abd9d040e844ebcb1f91a6ab4bcdfad66e36c1143f79d60461e933fddf9
```

Other potentially useful URLs:

- https://sources.debian.net/src/libthai/0.1.28-3/ (for browsing the source)
- https://sources.debian.net/src/libthai/0.1.28-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libthai/0.1.28-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libtheora=1.1.1+dfsg.1-15`

Binary Packages:

- `libtheora0:amd64=1.1.1+dfsg.1-15`

Licenses: (parsed from: `/usr/share/doc/libtheora0/copyright`)

- `BSD-3-Clause`

Source:

```console
$ apt-get source -qq --print-uris libtheora=1.1.1+dfsg.1-15
'http://deb.debian.org/debian/pool/main/libt/libtheora/libtheora_1.1.1%2bdfsg.1-15.dsc' libtheora_1.1.1+dfsg.1-15.dsc 2603 SHA256:8c6c3a7d5befe0e67eb87e19c8b09046bfa185a57c4f0716ec32b4386cfc51a6
'http://deb.debian.org/debian/pool/main/libt/libtheora/libtheora_1.1.1%2bdfsg.1.orig.tar.gz' libtheora_1.1.1+dfsg.1.orig.tar.gz 2100495 SHA256:c59b0f07a7314dfe2ade15c41bc9f637f8a450fc6b340af61b81760629f28f90
'http://deb.debian.org/debian/pool/main/libt/libtheora/libtheora_1.1.1%2bdfsg.1-15.debian.tar.xz' libtheora_1.1.1+dfsg.1-15.debian.tar.xz 10736 SHA256:ffd09e84ac612b4f6326d4c43b26349688be34f688e09a6ed3c9160fcb99bead
```

Other potentially useful URLs:

- https://sources.debian.net/src/libtheora/1.1.1+dfsg.1-15/ (for browsing the source)
- https://sources.debian.net/src/libtheora/1.1.1+dfsg.1-15/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libtheora/1.1.1+dfsg.1-15/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libtirpc=1.3.1-1+deb11u1`

Binary Packages:

- `libtirpc-common=1.3.1-1+deb11u1`
- `libtirpc-dev:amd64=1.3.1-1+deb11u1`
- `libtirpc3:amd64=1.3.1-1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libtirpc-common/copyright`, `/usr/share/doc/libtirpc-dev/copyright`, `/usr/share/doc/libtirpc3/copyright`)

- `BSD-2-Clause`
- `BSD-3-Clause`
- `BSD-4-Clause`
- `GPL-2`
- `LGPL-2.1`
- `LGPL-2.1+`
- `PERMISSIVE`
- `__AUTO_PERMISSIVE__`

Source:

```console
$ apt-get source -qq --print-uris libtirpc=1.3.1-1+deb11u1
'http://deb.debian.org/debian/pool/main/libt/libtirpc/libtirpc_1.3.1-1%2bdeb11u1.dsc' libtirpc_1.3.1-1+deb11u1.dsc 2273 SHA256:f6c9103b9155e084cccc5a991e08678c9faad8a087c502cf8c8c552046c27847
'http://deb.debian.org/debian/pool/main/libt/libtirpc/libtirpc_1.3.1.orig.tar.bz2' libtirpc_1.3.1.orig.tar.bz2 513399 SHA256:245895caf066bec5e3d4375942c8cb4366adad184c29c618d97f724ea309ee17
'http://deb.debian.org/debian/pool/main/libt/libtirpc/libtirpc_1.3.1-1%2bdeb11u1.debian.tar.xz' libtirpc_1.3.1-1+deb11u1.debian.tar.xz 12752 SHA256:a0415b82adeba844372ca104e87376cd4c4bbb47e490925369e46e1c8f8750d4
```

Other potentially useful URLs:

- https://sources.debian.net/src/libtirpc/1.3.1-1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/libtirpc/1.3.1-1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libtirpc/1.3.1-1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libtool=2.4.6-15`

Binary Packages:

- `libltdl-dev:amd64=2.4.6-15`
- `libltdl7:amd64=2.4.6-15`
- `libtool=2.4.6-15`

Licenses: (parsed from: `/usr/share/doc/libltdl-dev/copyright`, `/usr/share/doc/libltdl7/copyright`, `/usr/share/doc/libtool/copyright`)

- `GFDL`
- `GPL`

Source:

```console
$ apt-get source -qq --print-uris libtool=2.4.6-15
'http://deb.debian.org/debian/pool/main/libt/libtool/libtool_2.4.6-15.dsc' libtool_2.4.6-15.dsc 2502 SHA256:c499bd88103239f5d9743c70fd9e84260b0237e43df47c44980ef4ac9ff5f8e0
'http://deb.debian.org/debian/pool/main/libt/libtool/libtool_2.4.6.orig.tar.xz' libtool_2.4.6.orig.tar.xz 973080 SHA256:7c87a8c2c8c0fc9cd5019e402bed4292462d00a718a7cd5f11218153bf28b26f
'http://deb.debian.org/debian/pool/main/libt/libtool/libtool_2.4.6.orig.tar.xz.asc' libtool_2.4.6.orig.tar.xz.asc 380 SHA256:ab68ebc45d60128a71fc36167cd29dcf3c3d6d639fd28663905ebaf3e2f43d6a
'http://deb.debian.org/debian/pool/main/libt/libtool/libtool_2.4.6-15.debian.tar.xz' libtool_2.4.6-15.debian.tar.xz 53924 SHA256:3955615804746d1440f2880f5cc0cd19e50dbaffe689afbec45dfcaaf5ee0d35
```

Other potentially useful URLs:

- https://sources.debian.net/src/libtool/2.4.6-15/ (for browsing the source)
- https://sources.debian.net/src/libtool/2.4.6-15/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libtool/2.4.6-15/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libunistring=0.9.10-4`

Binary Packages:

- `libunistring2:amd64=0.9.10-4`

Licenses: (parsed from: `/usr/share/doc/libunistring2/copyright`)

- `FreeSoftware`
- `GFDL-1.2`
- `GFDL-1.2+`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with distribution exception`
- `GPL-3`
- `GPL-3+`
- `LGPL-3`
- `LGPL-3+`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris libunistring=0.9.10-4
'http://deb.debian.org/debian/pool/main/libu/libunistring/libunistring_0.9.10-4.dsc' libunistring_0.9.10-4.dsc 2212 SHA256:5c7940807b538d4204506349cbd67e5c677afb9f0e46e94455353e3f746a481e
'http://deb.debian.org/debian/pool/main/libu/libunistring/libunistring_0.9.10.orig.tar.xz' libunistring_0.9.10.orig.tar.xz 2051320 SHA256:eb8fb2c3e4b6e2d336608377050892b54c3c983b646c561836550863003c05d7
'http://deb.debian.org/debian/pool/main/libu/libunistring/libunistring_0.9.10.orig.tar.xz.asc' libunistring_0.9.10.orig.tar.xz.asc 1310 SHA256:e1606f691034fa21b00e08269622743547c16d21cca6c8a64156b4774a49e78e
'http://deb.debian.org/debian/pool/main/libu/libunistring/libunistring_0.9.10-4.debian.tar.xz' libunistring_0.9.10-4.debian.tar.xz 40936 SHA256:6c9554e1a1c6d0a02ca4868a5422d176e57a3131c1a8a21de5503b164997525c
```

Other potentially useful URLs:

- https://sources.debian.net/src/libunistring/0.9.10-4/ (for browsing the source)
- https://sources.debian.net/src/libunistring/0.9.10-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libunistring/0.9.10-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libunwind=1.3.2-2`

Binary Packages:

- `libunwind8:amd64=1.3.2-2`

Licenses: (parsed from: `/usr/share/doc/libunwind8/copyright`)

- `Expat`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris libunwind=1.3.2-2
'http://deb.debian.org/debian/pool/main/libu/libunwind/libunwind_1.3.2-2.dsc' libunwind_1.3.2-2.dsc 2793 SHA256:9a84747321445af8539a8ffba61791f8ecad5e058db5bf9b401067dd05c573ba
'http://deb.debian.org/debian/pool/main/libu/libunwind/libunwind_1.3.2.orig.tar.gz' libunwind_1.3.2.orig.tar.gz 854114 SHA256:0a4b5a78d8c0418dfa610245f75fa03ad45d8e5e4cc091915d2dbed34c01178e
'http://deb.debian.org/debian/pool/main/libu/libunwind/libunwind_1.3.2.orig.tar.gz.asc' libunwind_1.3.2.orig.tar.gz.asc 659 SHA256:5c1ffad1980acc92536a35643afba3f0e395b2a953fb898fda3403dae8fbd6ef
'http://deb.debian.org/debian/pool/main/libu/libunwind/libunwind_1.3.2-2.debian.tar.xz' libunwind_1.3.2-2.debian.tar.xz 19952 SHA256:87c03a5b832f59fa4984f4fb8a2bf02aabc6075b1d7002331e6b19008eac7c95
```

Other potentially useful URLs:

- https://sources.debian.net/src/libunwind/1.3.2-2/ (for browsing the source)
- https://sources.debian.net/src/libunwind/1.3.2-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libunwind/1.3.2-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libvisual=0.4.0-17`

Binary Packages:

- `libvisual-0.4-0:amd64=0.4.0-17`

Licenses: (parsed from: `/usr/share/doc/libvisual-0.4-0/copyright`)

- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris libvisual=0.4.0-17
'http://deb.debian.org/debian/pool/main/libv/libvisual/libvisual_0.4.0-17.dsc' libvisual_0.4.0-17.dsc 1945 SHA256:34f2ae4274167adfb6ad8d2c9bac55ca38f35c911581b50fbda8cbfdb89bebdc
'http://deb.debian.org/debian/pool/main/libv/libvisual/libvisual_0.4.0.orig.tar.gz' libvisual_0.4.0.orig.tar.gz 583386 SHA256:0b4dfdb87125e129567752089e3c8b54cefed601eef169d2533d8659da8dc1d7
'http://deb.debian.org/debian/pool/main/libv/libvisual/libvisual_0.4.0-17.debian.tar.xz' libvisual_0.4.0-17.debian.tar.xz 19984 SHA256:c91628df87d5826586bf9d350a37e4f9ef60ec24571da5749e7260b350d76681
```

Other potentially useful URLs:

- https://sources.debian.net/src/libvisual/0.4.0-17/ (for browsing the source)
- https://sources.debian.net/src/libvisual/0.4.0-17/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libvisual/0.4.0-17/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libvorbis=1.3.7-1`

Binary Packages:

- `libvorbis0a:amd64=1.3.7-1`
- `libvorbisenc2:amd64=1.3.7-1`

Licenses: (parsed from: `/usr/share/doc/libvorbis0a/copyright`, `/usr/share/doc/libvorbisenc2/copyright`)

- `BSD-3-Clause`
- `RFC-special`

Source:

```console
$ apt-get source -qq --print-uris libvorbis=1.3.7-1
'http://deb.debian.org/debian/pool/main/libv/libvorbis/libvorbis_1.3.7-1.dsc' libvorbis_1.3.7-1.dsc 2362 SHA256:b25d27beb9162607c95cf58aa2b764d110bd1a1568d3926a96c523320b49171f
'http://deb.debian.org/debian/pool/main/libv/libvorbis/libvorbis_1.3.7.orig.tar.gz' libvorbis_1.3.7.orig.tar.gz 1658963 SHA256:0e982409a9c3fc82ee06e08205b1355e5c6aa4c36bca58146ef399621b0ce5ab
'http://deb.debian.org/debian/pool/main/libv/libvorbis/libvorbis_1.3.7-1.debian.tar.xz' libvorbis_1.3.7-1.debian.tar.xz 11600 SHA256:c5c40944a3fc1cdd1ce019ef21f580ce5ed3b9f30e0cba7b3d859e8d9fea631f
```

Other potentially useful URLs:

- https://sources.debian.net/src/libvorbis/1.3.7-1/ (for browsing the source)
- https://sources.debian.net/src/libvorbis/1.3.7-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libvorbis/1.3.7-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libvpx=1.9.0-1+deb11u3`

Binary Packages:

- `libvpx6:amd64=1.9.0-1+deb11u3`

Licenses: (parsed from: `/usr/share/doc/libvpx6/copyright`)

- `BSD-3-Clause`
- `ISC`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris libvpx=1.9.0-1+deb11u3
'http://deb.debian.org/debian/pool/main/libv/libvpx/libvpx_1.9.0-1%2bdeb11u3.dsc' libvpx_1.9.0-1+deb11u3.dsc 2279 SHA256:586bd468d573b1b6c0a7c78f9b77fc885fd18c414e3e529505fd2dc5b0b789ee
'http://deb.debian.org/debian/pool/main/libv/libvpx/libvpx_1.9.0.orig.tar.gz' libvpx_1.9.0.orig.tar.gz 5326239 SHA256:d279c10e4b9316bf11a570ba16c3d55791e1ad6faa4404c67422eb631782c80a
'http://deb.debian.org/debian/pool/main/libv/libvpx/libvpx_1.9.0-1%2bdeb11u3.debian.tar.xz' libvpx_1.9.0-1+deb11u3.debian.tar.xz 17268 SHA256:05a3eb95a75ddadcd23b8732dbce90c1e6dbd06452abe043400125983e81cc05
```

Other potentially useful URLs:

- https://sources.debian.net/src/libvpx/1.9.0-1+deb11u3/ (for browsing the source)
- https://sources.debian.net/src/libvpx/1.9.0-1+deb11u3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libvpx/1.9.0-1+deb11u3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libwebp=0.6.1-2.1+deb11u2`

Binary Packages:

- `libwebp-dev:amd64=0.6.1-2.1+deb11u2`
- `libwebp6:amd64=0.6.1-2.1+deb11u2`
- `libwebpdemux2:amd64=0.6.1-2.1+deb11u2`
- `libwebpmux3:amd64=0.6.1-2.1+deb11u2`

Licenses: (parsed from: `/usr/share/doc/libwebp-dev/copyright`, `/usr/share/doc/libwebp6/copyright`, `/usr/share/doc/libwebpdemux2/copyright`, `/usr/share/doc/libwebpmux3/copyright`)

- `Apache-2.0`

Source:

```console
$ apt-get source -qq --print-uris libwebp=0.6.1-2.1+deb11u2
'http://deb.debian.org/debian/pool/main/libw/libwebp/libwebp_0.6.1-2.1%2bdeb11u2.dsc' libwebp_0.6.1-2.1+deb11u2.dsc 2086 SHA256:de8a8c64cb1c1fb217b68ca91bc32737af2fa71b6a5ed344262e778cc9f90aa6
'http://deb.debian.org/debian/pool/main/libw/libwebp/libwebp_0.6.1.orig.tar.gz' libwebp_0.6.1.orig.tar.gz 3554290 SHA256:a86045e3ec24704bddbaa369ca30980d6bf4f2625f4cdca03715e91f9c08bbb4
'http://deb.debian.org/debian/pool/main/libw/libwebp/libwebp_0.6.1-2.1%2bdeb11u2.debian.tar.xz' libwebp_0.6.1-2.1+deb11u2.debian.tar.xz 17716 SHA256:81385fbc2b489bc5e0d90f7c2155f64c4adf474b5456f6ccca6a2643e4b870af
```

Other potentially useful URLs:

- https://sources.debian.net/src/libwebp/0.6.1-2.1+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/libwebp/0.6.1-2.1+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libwebp/0.6.1-2.1+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libwmf=0.2.8.4-17`

Binary Packages:

- `libwmf-dev=0.2.8.4-17`
- `libwmf0.2-7:amd64=0.2.8.4-17`

Licenses: (parsed from: `/usr/share/doc/libwmf-dev/copyright`, `/usr/share/doc/libwmf0.2-7/copyright`)

- `LGPL-2`

Source:

```console
$ apt-get source -qq --print-uris libwmf=0.2.8.4-17
'http://deb.debian.org/debian/pool/main/libw/libwmf/libwmf_0.2.8.4-17.dsc' libwmf_0.2.8.4-17.dsc 2268 SHA256:1d48da0032093725c16f1c389152cc4041e60323a8453c550310286a0cfafa6a
'http://deb.debian.org/debian/pool/main/libw/libwmf/libwmf_0.2.8.4.orig.tar.gz' libwmf_0.2.8.4.orig.tar.gz 2169375 SHA256:5b345c69220545d003ad52bfd035d5d6f4f075e65204114a9e875e84895a7cf8
'http://deb.debian.org/debian/pool/main/libw/libwmf/libwmf_0.2.8.4-17.debian.tar.xz' libwmf_0.2.8.4-17.debian.tar.xz 12900 SHA256:d32d2b4c948abb929911c7b23ef9490863d86e3c6b6302aa3549d25301e0fed1
```

Other potentially useful URLs:

- https://sources.debian.net/src/libwmf/0.2.8.4-17/ (for browsing the source)
- https://sources.debian.net/src/libwmf/0.2.8.4-17/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libwmf/0.2.8.4-17/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libx11=2:1.7.2-1+deb11u2`

Binary Packages:

- `libx11-6:amd64=2:1.7.2-1+deb11u2`
- `libx11-data=2:1.7.2-1+deb11u2`
- `libx11-dev:amd64=2:1.7.2-1+deb11u2`
- `libx11-xcb1:amd64=2:1.7.2-1+deb11u2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libx11=2:1.7.2-1+deb11u2
'http://deb.debian.org/debian/pool/main/libx/libx11/libx11_1.7.2-1%2bdeb11u2.dsc' libx11_1.7.2-1+deb11u2.dsc 2600 SHA256:2e7312dd3780fb6bba6479d1a601aaf80a876771dbe15bcf99b3f35d813785eb
'http://deb.debian.org/debian/pool/main/libx/libx11/libx11_1.7.2.orig.tar.gz' libx11_1.7.2.orig.tar.gz 3181228 SHA256:2c26ccd08f43a6214de89110554fbe97c71692eeb7e7d4829f3004ae6fafd2c0
'http://deb.debian.org/debian/pool/main/libx/libx11/libx11_1.7.2.orig.tar.gz.asc' libx11_1.7.2.orig.tar.gz.asc 833 SHA256:509d0ed983ff3aed0dbfb070dabfce82b5787e626f2fd0bfb2a5887918fcd967
'http://deb.debian.org/debian/pool/main/libx/libx11/libx11_1.7.2-1%2bdeb11u2.diff.gz' libx11_1.7.2-1+deb11u2.diff.gz 82069 SHA256:b32103fea010d9a931d7b00f6f8c2fc05acb3da0fb8a5e26f7c4aab12e07f81e
```

Other potentially useful URLs:

- https://sources.debian.net/src/libx11/2:1.7.2-1+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/libx11/2:1.7.2-1+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libx11/2:1.7.2-1+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxau=1:1.0.9-1`

Binary Packages:

- `libxau-dev:amd64=1:1.0.9-1`
- `libxau6:amd64=1:1.0.9-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxau=1:1.0.9-1
'http://deb.debian.org/debian/pool/main/libx/libxau/libxau_1.0.9-1.dsc' libxau_1.0.9-1.dsc 2183 SHA256:e6e059652cda7e5a49b6c9a70667639f32d629c20320487d16c642a06c1ebf85
'http://deb.debian.org/debian/pool/main/libx/libxau/libxau_1.0.9.orig.tar.gz' libxau_1.0.9.orig.tar.gz 394068 SHA256:1f123d8304b082ad63a9e89376400a3b1d4c29e67e3ea07b3f659cccca690eea
'http://deb.debian.org/debian/pool/main/libx/libxau/libxau_1.0.9.orig.tar.gz.asc' libxau_1.0.9.orig.tar.gz.asc 801 SHA256:af6104aaf3c5ede529e381237dd60f49640ec96593a84502fa493b86582b2f04
'http://deb.debian.org/debian/pool/main/libx/libxau/libxau_1.0.9-1.diff.gz' libxau_1.0.9-1.diff.gz 10193 SHA256:7b34899563f172e8f11d061de41b58fe1c32f8683d985e57686677ccb7299a9a
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxau/1:1.0.9-1/ (for browsing the source)
- https://sources.debian.net/src/libxau/1:1.0.9-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxau/1:1.0.9-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxcb=1.14-3`

Binary Packages:

- `libxcb-dri2-0:amd64=1.14-3`
- `libxcb-dri3-0:amd64=1.14-3`
- `libxcb-glx0:amd64=1.14-3`
- `libxcb-present0:amd64=1.14-3`
- `libxcb-render0:amd64=1.14-3`
- `libxcb-render0-dev:amd64=1.14-3`
- `libxcb-shm0:amd64=1.14-3`
- `libxcb-shm0-dev:amd64=1.14-3`
- `libxcb-sync1:amd64=1.14-3`
- `libxcb-xfixes0:amd64=1.14-3`
- `libxcb1:amd64=1.14-3`
- `libxcb1-dev:amd64=1.14-3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxcb=1.14-3
'http://deb.debian.org/debian/pool/main/libx/libxcb/libxcb_1.14-3.dsc' libxcb_1.14-3.dsc 5373 SHA256:25030a957600e3afcfecd095e3c1187885818a8a3fe8346ae965fe62c3a3b2eb
'http://deb.debian.org/debian/pool/main/libx/libxcb/libxcb_1.14.orig.tar.gz' libxcb_1.14.orig.tar.gz 640322 SHA256:2c7fcddd1da34d9b238c9caeda20d3bd7486456fc50b3cc6567185dbd5b0ad02
'http://deb.debian.org/debian/pool/main/libx/libxcb/libxcb_1.14-3.diff.gz' libxcb_1.14-3.diff.gz 26583 SHA256:aed546fff9cf733c52188ad4f0d869a5ee8ffec52b54a6fa8f666a87adda82a3
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxcb/1.14-3/ (for browsing the source)
- https://sources.debian.net/src/libxcb/1.14-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxcb/1.14-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxcomposite=1:0.4.5-1`

Binary Packages:

- `libxcomposite1:amd64=1:0.4.5-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxcomposite=1:0.4.5-1
'http://deb.debian.org/debian/pool/main/libx/libxcomposite/libxcomposite_0.4.5-1.dsc' libxcomposite_0.4.5-1.dsc 2067 SHA256:41b93952b43dfac6b0acde3ea9b6330d44fd7c96b6a38eba6d82094b88e436e8
'http://deb.debian.org/debian/pool/main/libx/libxcomposite/libxcomposite_0.4.5.orig.tar.gz' libxcomposite_0.4.5.orig.tar.gz 386513 SHA256:581c7fc0f41a99af38b1c36b9be64bc13ef3f60091cd3f01105bbc7c01617d6c
'http://deb.debian.org/debian/pool/main/libx/libxcomposite/libxcomposite_0.4.5-1.diff.gz' libxcomposite_0.4.5-1.diff.gz 7547 SHA256:b5e99d78f5260a7c27ac4c166f981e8c2eab44cff08f9ab64da3ee7150854410
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxcomposite/1:0.4.5-1/ (for browsing the source)
- https://sources.debian.net/src/libxcomposite/1:0.4.5-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxcomposite/1:0.4.5-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxcrypt=1:4.4.18-4`

Binary Packages:

- `libcrypt-dev:amd64=1:4.4.18-4`
- `libcrypt1:amd64=1:4.4.18-4`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxcrypt=1:4.4.18-4
'http://deb.debian.org/debian/pool/main/libx/libxcrypt/libxcrypt_4.4.18-4.dsc' libxcrypt_4.4.18-4.dsc 1477 SHA256:5c0ca54ddad5343596f6c0916caf30fbb9b8a144252b49dc74f97502f33cdb7a
'http://deb.debian.org/debian/pool/main/libx/libxcrypt/libxcrypt_4.4.18.orig.tar.xz' libxcrypt_4.4.18.orig.tar.xz 397776 SHA256:4cd2a06e98519d57a5572ee8885b6cc23c70a559d234c161d3f22c487edaa3fa
'http://deb.debian.org/debian/pool/main/libx/libxcrypt/libxcrypt_4.4.18-4.debian.tar.xz' libxcrypt_4.4.18-4.debian.tar.xz 7560 SHA256:6c99b888c57e1411d870fa81d057e30444aa801ed430aa3126d31996e187dd84
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxcrypt/1:4.4.18-4/ (for browsing the source)
- https://sources.debian.net/src/libxcrypt/1:4.4.18-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxcrypt/1:4.4.18-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxcursor=1:1.2.0-2`

Binary Packages:

- `libxcursor1:amd64=1:1.2.0-2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxcursor=1:1.2.0-2
'http://deb.debian.org/debian/pool/main/libx/libxcursor/libxcursor_1.2.0-2.dsc' libxcursor_1.2.0-2.dsc 2260 SHA256:27a4e948a79d0caf2d5d8bcd2f036c1b14b9abb933fd7c3f12f933885c0124ed
'http://deb.debian.org/debian/pool/main/libx/libxcursor/libxcursor_1.2.0.orig.tar.gz' libxcursor_1.2.0.orig.tar.gz 408135 SHA256:ad5b2574fccaa4c3fa67b9874fbed863d29ad230c784e9a08b20692418f6a1f8
'http://deb.debian.org/debian/pool/main/libx/libxcursor/libxcursor_1.2.0-2.debian.tar.xz' libxcursor_1.2.0-2.debian.tar.xz 8988 SHA256:3fd5d8bf9c47d43e416ec6533b63796616c689eecfdbfb28bb9adefdaa079e51
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxcursor/1:1.2.0-2/ (for browsing the source)
- https://sources.debian.net/src/libxcursor/1:1.2.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxcursor/1:1.2.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxdamage=1:1.1.5-2`

Binary Packages:

- `libxdamage1:amd64=1:1.1.5-2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxdamage=1:1.1.5-2
'http://deb.debian.org/debian/pool/main/libx/libxdamage/libxdamage_1.1.5-2.dsc' libxdamage_1.1.5-2.dsc 2124 SHA256:c2ef651aa7dad2f3f1e57a9ef8e12c72eb5f23c9e507473dccd3996a54ae229a
'http://deb.debian.org/debian/pool/main/libx/libxdamage/libxdamage_1.1.5.orig.tar.gz' libxdamage_1.1.5.orig.tar.gz 370586 SHA256:630ec53abb8c2d6dac5cd9f06c1f73ffb4a3167f8118fdebd77afd639dbc2019
'http://deb.debian.org/debian/pool/main/libx/libxdamage/libxdamage_1.1.5-2.debian.tar.xz' libxdamage_1.1.5-2.debian.tar.xz 5996 SHA256:c6333b68d2e109ea44a6031bc79e23c433b580c7ae69a9cd5cf40729896913fc
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxdamage/1:1.1.5-2/ (for browsing the source)
- https://sources.debian.net/src/libxdamage/1:1.1.5-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxdamage/1:1.1.5-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxdmcp=1:1.1.2-3`

Binary Packages:

- `libxdmcp-dev:amd64=1:1.1.2-3`
- `libxdmcp6:amd64=1:1.1.2-3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxdmcp=1:1.1.2-3
'http://deb.debian.org/debian/pool/main/libx/libxdmcp/libxdmcp_1.1.2-3.dsc' libxdmcp_1.1.2-3.dsc 2145 SHA256:f9697dca6a275aeee9a3eee9fb2d55e0f77485481e8b84efc6950fc9b1988460
'http://deb.debian.org/debian/pool/main/libx/libxdmcp/libxdmcp_1.1.2.orig.tar.gz' libxdmcp_1.1.2.orig.tar.gz 404115 SHA256:6f7c7e491a23035a26284d247779174dedc67e34e93cc3548b648ffdb6fc57c0
'http://deb.debian.org/debian/pool/main/libx/libxdmcp/libxdmcp_1.1.2-3.diff.gz' libxdmcp_1.1.2-3.diff.gz 18017 SHA256:5844df115c17e5ba40ac116f80373304d821c607e763ef6f40562421f5cc0cf3
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxdmcp/1:1.1.2-3/ (for browsing the source)
- https://sources.debian.net/src/libxdmcp/1:1.1.2-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxdmcp/1:1.1.2-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxext=2:1.3.3-1.1`

Binary Packages:

- `libxext-dev:amd64=2:1.3.3-1.1`
- `libxext6:amd64=2:1.3.3-1.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxext=2:1.3.3-1.1
'http://deb.debian.org/debian/pool/main/libx/libxext/libxext_1.3.3-1.1.dsc' libxext_1.3.3-1.1.dsc 2243 SHA256:ae9f97003e38da180294f43a8217991df709955dd7576c5333e2412f264f8697
'http://deb.debian.org/debian/pool/main/libx/libxext/libxext_1.3.3.orig.tar.gz' libxext_1.3.3.orig.tar.gz 468441 SHA256:eb0b88050491fef4716da4b06a4d92b4fc9e76f880d6310b2157df604342cfe5
'http://deb.debian.org/debian/pool/main/libx/libxext/libxext_1.3.3-1.1.diff.gz' libxext_1.3.3-1.1.diff.gz 20628 SHA256:6a8ce08c667c4631c59bc79c716187dc7ed20bb7d0967701ab21313e6dd6c752
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxext/2:1.3.3-1.1/ (for browsing the source)
- https://sources.debian.net/src/libxext/2:1.3.3-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxext/2:1.3.3-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxfixes=1:5.0.3-2`

Binary Packages:

- `libxfixes3:amd64=1:5.0.3-2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxfixes=1:5.0.3-2
'http://deb.debian.org/debian/pool/main/libx/libxfixes/libxfixes_5.0.3-2.dsc' libxfixes_5.0.3-2.dsc 2014 SHA256:f47f131ee1d1ce791daa514fd43fe45e099f3a83462247bc75fc7ba0c8be42a6
'http://deb.debian.org/debian/pool/main/libx/libxfixes/libxfixes_5.0.3.orig.tar.gz' libxfixes_5.0.3.orig.tar.gz 360412 SHA256:9ab6c13590658501ce4bd965a8a5d32ba4d8b3bb39a5a5bc9901edffc5666570
'http://deb.debian.org/debian/pool/main/libx/libxfixes/libxfixes_5.0.3-2.diff.gz' libxfixes_5.0.3-2.diff.gz 14717 SHA256:aeb108219d65550e107d6f81dc2dac11e06363a55306f2505234190f96f1e961
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxfixes/1:5.0.3-2/ (for browsing the source)
- https://sources.debian.net/src/libxfixes/1:5.0.3-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxfixes/1:5.0.3-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxi=2:1.7.10-1`

Binary Packages:

- `libxi6:amd64=2:1.7.10-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxi=2:1.7.10-1
'http://deb.debian.org/debian/pool/main/libx/libxi/libxi_1.7.10-1.dsc' libxi_1.7.10-1.dsc 2445 SHA256:f5882af752d8ceade8f21b6c401736fc9f92a11601d30c505e00e3eedea60355
'http://deb.debian.org/debian/pool/main/libx/libxi/libxi_1.7.10.orig.tar.gz' libxi_1.7.10.orig.tar.gz 606701 SHA256:b51e106c445a49409f3da877aa2f9129839001b24697d75a54e5c60507e9a5e3
'http://deb.debian.org/debian/pool/main/libx/libxi/libxi_1.7.10.orig.tar.gz.asc' libxi_1.7.10.orig.tar.gz.asc 358 SHA256:ff685b2cab766aa06aad7e25cfc1329f085876a02513934f0af7fd691eee0908
'http://deb.debian.org/debian/pool/main/libx/libxi/libxi_1.7.10-1.diff.gz' libxi_1.7.10-1.diff.gz 22726 SHA256:e0395ca77ca23dac8bfd5e0dd712fdd71640d5b14fd40dc841d7fb24677a3b84
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxi/2:1.7.10-1/ (for browsing the source)
- https://sources.debian.net/src/libxi/2:1.7.10-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxi/2:1.7.10-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxinerama=2:1.1.4-2`

Binary Packages:

- `libxinerama1:amd64=2:1.1.4-2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxinerama=2:1.1.4-2
'http://deb.debian.org/debian/pool/main/libx/libxinerama/libxinerama_1.1.4-2.dsc' libxinerama_1.1.4-2.dsc 2100 SHA256:02e4c8406fd1eae8abfe356894d95d610e2e612a761688ef5afe5e7c60d162e9
'http://deb.debian.org/debian/pool/main/libx/libxinerama/libxinerama_1.1.4.orig.tar.gz' libxinerama_1.1.4.orig.tar.gz 380740 SHA256:64de45e18cc76b8e703cb09b3c9d28bd16e3d05d5cd99f2d630de2d62c3acc18
'http://deb.debian.org/debian/pool/main/libx/libxinerama/libxinerama_1.1.4-2.diff.gz' libxinerama_1.1.4-2.diff.gz 8732 SHA256:06ce6602862839ded43d914d7dd5e5bcd7d7a1477c775f5f47a6c20b1c9b52b6
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxinerama/2:1.1.4-2/ (for browsing the source)
- https://sources.debian.net/src/libxinerama/2:1.1.4-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxinerama/2:1.1.4-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxkbcommon=1.0.3-2`

Binary Packages:

- `libxkbcommon0:amd64=1.0.3-2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxkbcommon=1.0.3-2
'http://deb.debian.org/debian/pool/main/libx/libxkbcommon/libxkbcommon_1.0.3-2.dsc' libxkbcommon_1.0.3-2.dsc 2754 SHA256:478a29edcc52dafae5a5df78d783343e451380d993faf13905cc1fd8dbc404ec
'http://deb.debian.org/debian/pool/main/libx/libxkbcommon/libxkbcommon_1.0.3.orig.tar.xz' libxkbcommon_1.0.3.orig.tar.xz 432944 SHA256:a2202f851e072b84e64a395212cbd976ee18a8ee602008b0bad02a13247dbc52
'http://deb.debian.org/debian/pool/main/libx/libxkbcommon/libxkbcommon_1.0.3-2.debian.tar.xz' libxkbcommon_1.0.3-2.debian.tar.xz 7844 SHA256:d007ae250a71dc13102477c0dbf0b02dd8a86cd881cd001d102478a81466d2f1
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxkbcommon/1.0.3-2/ (for browsing the source)
- https://sources.debian.net/src/libxkbcommon/1.0.3-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxkbcommon/1.0.3-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxml2=2.9.10+dfsg-6.7+deb11u5`

Binary Packages:

- `libxml2:amd64=2.9.10+dfsg-6.7+deb11u5`
- `libxml2-dev:amd64=2.9.10+dfsg-6.7+deb11u5`

Licenses: (parsed from: `/usr/share/doc/libxml2/copyright`, `/usr/share/doc/libxml2-dev/copyright`)

- `ISC`
- `MIT-1`

Source:

```console
$ apt-get source -qq --print-uris libxml2=2.9.10+dfsg-6.7+deb11u5
'http://deb.debian.org/debian-security/pool/updates/main/libx/libxml2/libxml2_2.9.10%2bdfsg-6.7%2bdeb11u5.dsc' libxml2_2.9.10+dfsg-6.7+deb11u5.dsc 2704 SHA256:77bca4aa4cc6543ca08e1a96a81441ae23ca363b57c82fd5d58341e646d82350
'http://deb.debian.org/debian-security/pool/updates/main/libx/libxml2/libxml2_2.9.10%2bdfsg.orig.tar.xz' libxml2_2.9.10+dfsg.orig.tar.xz 2503560 SHA256:65ee7a2f5e100c64ddf7beb92297c9b2a30b994a76cd1fab67470cf22db6b7d0
'http://deb.debian.org/debian-security/pool/updates/main/libx/libxml2/libxml2_2.9.10%2bdfsg-6.7%2bdeb11u5.debian.tar.xz' libxml2_2.9.10+dfsg-6.7+deb11u5.debian.tar.xz 43140 SHA256:ce3a1e4fa6c173de6638a74a122b28fff367b352a2c4bc26002fead5c0feeca7
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxml2/2.9.10+dfsg-6.7+deb11u5/ (for browsing the source)
- https://sources.debian.net/src/libxml2/2.9.10+dfsg-6.7+deb11u5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxml2/2.9.10+dfsg-6.7+deb11u5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxrandr=2:1.5.1-1`

Binary Packages:

- `libxrandr2:amd64=2:1.5.1-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxrandr=2:1.5.1-1
'http://deb.debian.org/debian/pool/main/libx/libxrandr/libxrandr_1.5.1-1.dsc' libxrandr_1.5.1-1.dsc 2046 SHA256:0d7102ab75fdfe06534e842d5dcac8430614c61a061ab12794e2285712b0b103
'http://deb.debian.org/debian/pool/main/libx/libxrandr/libxrandr_1.5.1.orig.tar.gz' libxrandr_1.5.1.orig.tar.gz 388607 SHA256:2baa7fb3eca78fe7e11a09b373ba898b717f7eeba4a4bfd68187e04b4789b0d3
'http://deb.debian.org/debian/pool/main/libx/libxrandr/libxrandr_1.5.1-1.diff.gz' libxrandr_1.5.1-1.diff.gz 16386 SHA256:42262cbc2117ea559a4e16a02c6ea6478554aa2128d9fe1e141da07006612a1d
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxrandr/2:1.5.1-1/ (for browsing the source)
- https://sources.debian.net/src/libxrandr/2:1.5.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxrandr/2:1.5.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxrender=1:0.9.10-1`

Binary Packages:

- `libxrender-dev:amd64=1:0.9.10-1`
- `libxrender1:amd64=1:0.9.10-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxrender=1:0.9.10-1
'http://deb.debian.org/debian/pool/main/libx/libxrender/libxrender_0.9.10-1.dsc' libxrender_0.9.10-1.dsc 2064 SHA256:95d6471218b44f4e60c48cea60cfb4865bbe861530add23f6c859515bee92dbd
'http://deb.debian.org/debian/pool/main/libx/libxrender/libxrender_0.9.10.orig.tar.gz' libxrender_0.9.10.orig.tar.gz 373717 SHA256:770527cce42500790433df84ec3521e8bf095dfe5079454a92236494ab296adf
'http://deb.debian.org/debian/pool/main/libx/libxrender/libxrender_0.9.10-1.diff.gz' libxrender_0.9.10-1.diff.gz 15399 SHA256:ff56a0a00119383adc5f1731e86155ae5c2de069e1d059a9da1d777917430588
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxrender/1:0.9.10-1/ (for browsing the source)
- https://sources.debian.net/src/libxrender/1:0.9.10-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxrender/1:0.9.10-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxshmfence=1.3-1`

Binary Packages:

- `libxshmfence1:amd64=1.3-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxshmfence=1.3-1
'http://deb.debian.org/debian/pool/main/libx/libxshmfence/libxshmfence_1.3-1.dsc' libxshmfence_1.3-1.dsc 2096 SHA256:7da3e1195622ab34427bd5d09167b1f44ed1a3e828782fa8e618f1181c56194a
'http://deb.debian.org/debian/pool/main/libx/libxshmfence/libxshmfence_1.3.orig.tar.gz' libxshmfence_1.3.orig.tar.gz 378960 SHA256:7eb3d46ad91bab444f121d475b11b39273142d090f7e9ac43e6a87f4ff5f902c
'http://deb.debian.org/debian/pool/main/libx/libxshmfence/libxshmfence_1.3-1.diff.gz' libxshmfence_1.3-1.diff.gz 17456 SHA256:85422af90300523b8fb27e697b59418f18bd7cd5c849161fd0be64c91ce94698
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxshmfence/1.3-1/ (for browsing the source)
- https://sources.debian.net/src/libxshmfence/1.3-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxshmfence/1.3-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxslt=1.1.34-4+deb11u1`

Binary Packages:

- `libxslt1-dev:amd64=1.1.34-4+deb11u1`
- `libxslt1.1:amd64=1.1.34-4+deb11u1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxslt=1.1.34-4+deb11u1
'http://deb.debian.org/debian/pool/main/libx/libxslt/libxslt_1.1.34-4%2bdeb11u1.dsc' libxslt_1.1.34-4+deb11u1.dsc 2562 SHA256:0dec0521f4d7cfc08bd61c4d4aa82866881962c12f1429f730830c79c6678e93
'http://deb.debian.org/debian/pool/main/libx/libxslt/libxslt_1.1.34.orig.tar.gz' libxslt_1.1.34.orig.tar.gz 3552258 SHA256:98b1bd46d6792925ad2dfe9a87452ea2adebf69dcb9919ffd55bf926a7f93f7f
'http://deb.debian.org/debian/pool/main/libx/libxslt/libxslt_1.1.34.orig.tar.gz.asc' libxslt_1.1.34.orig.tar.gz.asc 488 SHA256:673d1477552bdd5b0cc665704e77ca70e6be5d2f257e6a5a341c846719d747cf
'http://deb.debian.org/debian/pool/main/libx/libxslt/libxslt_1.1.34-4%2bdeb11u1.debian.tar.xz' libxslt_1.1.34-4+deb11u1.debian.tar.xz 23152 SHA256:0272cab003bb5fe7105d54f3023c806062c818082df4d791fd45dbf526b801f8
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxslt/1.1.34-4+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/libxslt/1.1.34-4+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxslt/1.1.34-4+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxt=1:1.2.0-1`

Binary Packages:

- `libxt-dev:amd64=1:1.2.0-1`
- `libxt6:amd64=1:1.2.0-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxt=1:1.2.0-1
'http://deb.debian.org/debian/pool/main/libx/libxt/libxt_1.2.0-1.dsc' libxt_1.2.0-1.dsc 2298 SHA256:945650656e7f24f1276a1c100067e7fa728d50d7af93b4fcc149e5a5323df165
'http://deb.debian.org/debian/pool/main/libx/libxt/libxt_1.2.0.orig.tar.gz' libxt_1.2.0.orig.tar.gz 1016961 SHA256:d4bee88898fc5e1dc470e361430c72fbc529b9cdbbb6c0ed3affea3a39f97d8d
'http://deb.debian.org/debian/pool/main/libx/libxt/libxt_1.2.0.orig.tar.gz.asc' libxt_1.2.0.orig.tar.gz.asc 195 SHA256:4c5fe1bceef4aa507d5a95d2636e7ce257ee4f2b5522989ec4a7281cbe860564
'http://deb.debian.org/debian/pool/main/libx/libxt/libxt_1.2.0-1.diff.gz' libxt_1.2.0-1.diff.gz 31129 SHA256:eb723d0651e39c56d1e81fb7519e5093fd7e0177d42fd458d539163512076e52
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxt/1:1.2.0-1/ (for browsing the source)
- https://sources.debian.net/src/libxt/1:1.2.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxt/1:1.2.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libxxf86vm=1:1.1.4-1`

Binary Packages:

- `libxxf86vm1:amd64=1:1.1.4-1+b2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris libxxf86vm=1:1.1.4-1
'http://deb.debian.org/debian/pool/main/libx/libxxf86vm/libxxf86vm_1.1.4-1.dsc' libxxf86vm_1.1.4-1.dsc 2078 SHA256:5a3aded030a415b0d6c201d2b9d3af36f241dc981f10052fd4c2b56d59597838
'http://deb.debian.org/debian/pool/main/libx/libxxf86vm/libxxf86vm_1.1.4.orig.tar.gz' libxxf86vm_1.1.4.orig.tar.gz 363146 SHA256:5108553c378a25688dcb57dca383664c36e293d60b1505815f67980ba9318a99
'http://deb.debian.org/debian/pool/main/libx/libxxf86vm/libxxf86vm_1.1.4-1.diff.gz' libxxf86vm_1.1.4-1.diff.gz 8040 SHA256:e0f11739d28c7a4475820ebda26e6f29e6cfa80b99a3513c075471132c81725b
```

Other potentially useful URLs:

- https://sources.debian.net/src/libxxf86vm/1:1.1.4-1/ (for browsing the source)
- https://sources.debian.net/src/libxxf86vm/1:1.1.4-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libxxf86vm/1:1.1.4-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libyaml=0.2.2-1`

Binary Packages:

- `libyaml-0-2:amd64=0.2.2-1`
- `libyaml-dev:amd64=0.2.2-1`

Licenses: (parsed from: `/usr/share/doc/libyaml-0-2/copyright`, `/usr/share/doc/libyaml-dev/copyright`)

- `Expat`
- `permissive`

Source:

```console
$ apt-get source -qq --print-uris libyaml=0.2.2-1
'http://deb.debian.org/debian/pool/main/liby/libyaml/libyaml_0.2.2-1.dsc' libyaml_0.2.2-1.dsc 1833 SHA256:b4baba985391f52409013a0c9303191e34aaa4c1c9200e4c01c4963df801db09
'http://deb.debian.org/debian/pool/main/liby/libyaml/libyaml_0.2.2.orig.tar.gz' libyaml_0.2.2.orig.tar.gz 602509 SHA256:689ef3ebdecfa81f3789ccd2481acc81fc0f22f3f5c947eed95c4c0802e356b8
'http://deb.debian.org/debian/pool/main/liby/libyaml/libyaml_0.2.2-1.debian.tar.xz' libyaml_0.2.2-1.debian.tar.xz 4112 SHA256:186aad3e4bcd95891a8c59249c59f862f5f71601058fda0bf020a9e9e39320fe
```

Other potentially useful URLs:

- https://sources.debian.net/src/libyaml/0.2.2-1/ (for browsing the source)
- https://sources.debian.net/src/libyaml/0.2.2-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libyaml/0.2.2-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `libzstd=1.4.8+dfsg-2.1`

Binary Packages:

- `libzstd1:amd64=1.4.8+dfsg-2.1`

Licenses: (parsed from: `/usr/share/doc/libzstd1/copyright`)

- `BSD-3-clause`
- `Expat`
- `GPL-2`
- `zlib`

Source:

```console
$ apt-get source -qq --print-uris libzstd=1.4.8+dfsg-2.1
'http://deb.debian.org/debian/pool/main/libz/libzstd/libzstd_1.4.8%2bdfsg-2.1.dsc' libzstd_1.4.8+dfsg-2.1.dsc 2274 SHA256:7c656b8cab7a560710358dddbd949b33b1ffcedd7cbef370132e4018b94e2e74
'http://deb.debian.org/debian/pool/main/libz/libzstd/libzstd_1.4.8%2bdfsg.orig.tar.xz' libzstd_1.4.8+dfsg.orig.tar.xz 1331996 SHA256:1e8ce5c4880a6d5bd8d3186e4186607dd19b64fc98a3877fc13aeefd566d67c5
'http://deb.debian.org/debian/pool/main/libz/libzstd/libzstd_1.4.8%2bdfsg-2.1.debian.tar.xz' libzstd_1.4.8+dfsg-2.1.debian.tar.xz 12224 SHA256:cba8544590e59303277e3af2bb260fed32723a1084c9f4928956deca2c80032c
```

Other potentially useful URLs:

- https://sources.debian.net/src/libzstd/1.4.8+dfsg-2.1/ (for browsing the source)
- https://sources.debian.net/src/libzstd/1.4.8+dfsg-2.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/libzstd/1.4.8+dfsg-2.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `linux=5.10.226-1`

Binary Packages:

- `linux-libc-dev:amd64=5.10.226-1`

Licenses: (parsed from: `/usr/share/doc/linux-libc-dev/copyright`)

- `BSD-2-clause`
- `CRYPTOGAMS`
- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `Unicode-data`
- `X11`
- `Xen-interface`

Source:

```console
$ apt-get source -qq --print-uris linux=5.10.226-1
'http://deb.debian.org/debian-security/pool/updates/main/l/linux/linux_5.10.226-1.dsc' linux_5.10.226-1.dsc 209423 SHA256:f4c5fb21ff6e3370a0bc082653fecf0754f6de207364ec1952e949b76a03bbdb
'http://deb.debian.org/debian-security/pool/updates/main/l/linux/linux_5.10.226.orig.tar.xz' linux_5.10.226.orig.tar.xz 122010948 SHA256:98f9a880ad3521cfc4c94842dc0b760ed630ce369131b3af7ceb5f4415251b9b
'http://deb.debian.org/debian-security/pool/updates/main/l/linux/linux_5.10.226-1.debian.tar.xz' linux_5.10.226-1.debian.tar.xz 1708652 SHA256:9ea6cfc54485ac70e605965ed360b737c937b714a49b9588e567604d4ffe276f
```

Other potentially useful URLs:

- https://sources.debian.net/src/linux/5.10.226-1/ (for browsing the source)
- https://sources.debian.net/src/linux/5.10.226-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/linux/5.10.226-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `lksctp-tools=1.0.18+dfsg-1`

Binary Packages:

- `libsctp1:amd64=1.0.18+dfsg-1`

Licenses: (parsed from: `/usr/share/doc/libsctp1/copyright`)

- `BSD-3-clause`
- `GPL-2`
- `GPL-2.0+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris lksctp-tools=1.0.18+dfsg-1
'http://deb.debian.org/debian/pool/main/l/lksctp-tools/lksctp-tools_1.0.18%2bdfsg-1.dsc' lksctp-tools_1.0.18+dfsg-1.dsc 2017 SHA256:648c5a77722638056592fa9ba7bc99359ab70fcdf9f37c53e05d8cda96624705
'http://deb.debian.org/debian/pool/main/l/lksctp-tools/lksctp-tools_1.0.18%2bdfsg.orig.tar.gz' lksctp-tools_1.0.18+dfsg.orig.tar.gz 194751 SHA256:ac0f4e499281e1d190b5cc9c7e31570de4b82fade1c2754a21b2c8e215cb3cf5
'http://deb.debian.org/debian/pool/main/l/lksctp-tools/lksctp-tools_1.0.18%2bdfsg-1.debian.tar.xz' lksctp-tools_1.0.18+dfsg-1.debian.tar.xz 10488 SHA256:826130ee1a35bec5a0f73160328e4429f3a64e57a865c6e9b2286d2cc8ff2d30
```

Other potentially useful URLs:

- https://sources.debian.net/src/lksctp-tools/1.0.18+dfsg-1/ (for browsing the source)
- https://sources.debian.net/src/lksctp-tools/1.0.18+dfsg-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/lksctp-tools/1.0.18+dfsg-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `llvm-toolchain-11=1:11.0.1-2`

Binary Packages:

- `libllvm11:amd64=1:11.0.1-2`

Licenses: (parsed from: `/usr/share/doc/libllvm11/copyright`)

- `APACHE-2-LLVM-EXCEPTIONS`
- `Apache-2.0`
- `BSD-3-Clause`
- `BSD-3-clause`
- `MIT`
- `Python`
- `solar-public-domain`

Source:

```console
$ apt-get source -qq --print-uris llvm-toolchain-11=1:11.0.1-2
'http://deb.debian.org/debian/pool/main/l/llvm-toolchain-11/llvm-toolchain-11_11.0.1-2.dsc' llvm-toolchain-11_11.0.1-2.dsc 5975 SHA256:93023002a4fec43a81b8d7fcd53253c29222db367d166fb8c3827a5e0e109c72
'http://deb.debian.org/debian/pool/main/l/llvm-toolchain-11/llvm-toolchain-11_11.0.1.orig.tar.xz' llvm-toolchain-11_11.0.1.orig.tar.xz 78748920 SHA256:39ed2924a4bc0e4db79dfdd97f97bca64a26ff398b9128934c3fc7b3186e4c45
'http://deb.debian.org/debian/pool/main/l/llvm-toolchain-11/llvm-toolchain-11_11.0.1-2.debian.tar.xz' llvm-toolchain-11_11.0.1-2.debian.tar.xz 129556 SHA256:a13c22514f2218b7167bc3e63e9ed212ffd5a212cbe33839502c95d770e98619
```

Other potentially useful URLs:

- https://sources.debian.net/src/llvm-toolchain-11/1:11.0.1-2/ (for browsing the source)
- https://sources.debian.net/src/llvm-toolchain-11/1:11.0.1-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/llvm-toolchain-11/1:11.0.1-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `lm-sensors=1:3.6.0-7`

Binary Packages:

- `libsensors-config=1:3.6.0-7`
- `libsensors5:amd64=1:3.6.0-7`

Licenses: (parsed from: `/usr/share/doc/libsensors-config/copyright`, `/usr/share/doc/libsensors5/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris lm-sensors=1:3.6.0-7
'http://deb.debian.org/debian/pool/main/l/lm-sensors/lm-sensors_3.6.0-7.dsc' lm-sensors_3.6.0-7.dsc 2067 SHA256:088dabfaa672a679327793f89fc771d9ce855de0b60cb1fed9088c92d2b1c05b
'http://deb.debian.org/debian/pool/main/l/lm-sensors/lm-sensors_3.6.0.orig.tar.gz' lm-sensors_3.6.0.orig.tar.gz 273209 SHA256:0591f9fa0339f0d15e75326d0365871c2d4e2ed8aa1ff759b3a55d3734b7d197
'http://deb.debian.org/debian/pool/main/l/lm-sensors/lm-sensors_3.6.0-7.debian.tar.xz' lm-sensors_3.6.0-7.debian.tar.xz 26260 SHA256:3e9b5447eda382f92979201c1d76fb9e486f115ae73f6d4abf24e556b6a75f67
```

Other potentially useful URLs:

- https://sources.debian.net/src/lm-sensors/1:3.6.0-7/ (for browsing the source)
- https://sources.debian.net/src/lm-sensors/1:3.6.0-7/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/lm-sensors/1:3.6.0-7/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `lsb=11.1.0`

Binary Packages:

- `lsb-base=11.1.0`

Licenses: (parsed from: `/usr/share/doc/lsb-base/copyright`)

- `BSD-3-clause`
- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris lsb=11.1.0
'http://deb.debian.org/debian/pool/main/l/lsb/lsb_11.1.0.dsc' lsb_11.1.0.dsc 1800 SHA256:5cb5679dcc92e30aa878f892f73081d6b4d5299841549f6d53a886d51509feb1
'http://deb.debian.org/debian/pool/main/l/lsb/lsb_11.1.0.tar.xz' lsb_11.1.0.tar.xz 42452 SHA256:c7926d511228862892630070f7708c425db9473ceefc70872868c448b5145b57
```

Other potentially useful URLs:

- https://sources.debian.net/src/lsb/11.1.0/ (for browsing the source)
- https://sources.debian.net/src/lsb/11.1.0/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/lsb/11.1.0/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `lvm2=2.03.11-2.1`

Binary Packages:

- `dmsetup=2:1.02.175-2.1`
- `libdevmapper1.02.1:amd64=2:1.02.175-2.1`

Licenses: (parsed from: `/usr/share/doc/dmsetup/copyright`, `/usr/share/doc/libdevmapper1.02.1/copyright`)

- `BSD-2-Clause`
- `GPL-2`
- `GPL-2.0`
- `GPL-2.0+`
- `LGPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris lvm2=2.03.11-2.1
'http://deb.debian.org/debian/pool/main/l/lvm2/lvm2_2.03.11-2.1.dsc' lvm2_2.03.11-2.1.dsc 3077 SHA256:eec3abca0730baa87b256ac69b9d0cc42b4aebd5ed494515cb1575dee1bbf3ab
'http://deb.debian.org/debian/pool/main/l/lvm2/lvm2_2.03.11.orig.tar.xz' lvm2_2.03.11.orig.tar.xz 1699012 SHA256:7ef41edc65c4b807c5667ac7e9c371016d0db2a641812b334571acc0e025d86c
'http://deb.debian.org/debian/pool/main/l/lvm2/lvm2_2.03.11-2.1.debian.tar.xz' lvm2_2.03.11-2.1.debian.tar.xz 32208 SHA256:7b7b8aaffdefdc99a8ae2f25928c2f0bfd0451c639db5c44c42e62f56c089cca
```

Other potentially useful URLs:

- https://sources.debian.net/src/lvm2/2.03.11-2.1/ (for browsing the source)
- https://sources.debian.net/src/lvm2/2.03.11-2.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/lvm2/2.03.11-2.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `lz4=1.9.3-2`

Binary Packages:

- `liblz4-1:amd64=1.9.3-2`

Licenses: (parsed from: `/usr/share/doc/liblz4-1/copyright`)

- `BSD-2-clause`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris lz4=1.9.3-2
'http://deb.debian.org/debian/pool/main/l/lz4/lz4_1.9.3-2.dsc' lz4_1.9.3-2.dsc 1959 SHA256:215e1f0be1bb40e2b89182f3a1bf630463d8acdc0917f1f928ad1bf9ef3e1b0c
'http://deb.debian.org/debian/pool/main/l/lz4/lz4_1.9.3.orig.tar.gz' lz4_1.9.3.orig.tar.gz 320958 SHA256:030644df4611007ff7dc962d981f390361e6c97a34e5cbc393ddfbe019ffe2c1
'http://deb.debian.org/debian/pool/main/l/lz4/lz4_1.9.3-2.debian.tar.xz' lz4_1.9.3-2.debian.tar.xz 13928 SHA256:d7754a7b7b1fa196666d6459705107355e15fef162352e363e43722e012a04e3
```

Other potentially useful URLs:

- https://sources.debian.net/src/lz4/1.9.3-2/ (for browsing the source)
- https://sources.debian.net/src/lz4/1.9.3-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/lz4/1.9.3-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `lzo2=2.10-2`

Binary Packages:

- `liblzo2-2:amd64=2.10-2`

Licenses: (parsed from: `/usr/share/doc/liblzo2-2/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris lzo2=2.10-2
'http://deb.debian.org/debian/pool/main/l/lzo2/lzo2_2.10-2.dsc' lzo2_2.10-2.dsc 1926 SHA256:65a35d9d2511a88f30d4b10313f807c184d1906062e2421833797dafc2682166
'http://deb.debian.org/debian/pool/main/l/lzo2/lzo2_2.10.orig.tar.gz' lzo2_2.10.orig.tar.gz 600622 SHA256:c0f892943208266f9b6543b3ae308fab6284c5c90e627931446fb49b4221a072
'http://deb.debian.org/debian/pool/main/l/lzo2/lzo2_2.10-2.debian.tar.xz' lzo2_2.10-2.debian.tar.xz 6880 SHA256:095b2bf2012138f6892fcf226a0d1eae5d29406d7afe7129d51d64116e61c472
```

Other potentially useful URLs:

- https://sources.debian.net/src/lzo2/2.10-2/ (for browsing the source)
- https://sources.debian.net/src/lzo2/2.10-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/lzo2/2.10-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `m4=1.4.18-5`

Binary Packages:

- `m4=1.4.18-5`

Licenses: (parsed from: `/usr/share/doc/m4/copyright`)

- `GFDL`
- `GPL`

Source:

```console
$ apt-get source -qq --print-uris m4=1.4.18-5
'http://deb.debian.org/debian/pool/main/m/m4/m4_1.4.18-5.dsc' m4_1.4.18-5.dsc 1637 SHA256:ebc66cf67735240e2129cfbf20b8441e5144ef75c9fca0782a81eece8ae0f9d5
'http://deb.debian.org/debian/pool/main/m/m4/m4_1.4.18.orig.tar.xz' m4_1.4.18.orig.tar.xz 1207688 SHA256:f2c1e86ca0a404ff281631bdc8377638992744b175afb806e25871a24a934e07
'http://deb.debian.org/debian/pool/main/m/m4/m4_1.4.18.orig.tar.xz.asc' m4_1.4.18.orig.tar.xz.asc 521 SHA256:a2a9fff657e65ff25a8f3734f484dbd3ede8f8290786af71626de367dcd74267
'http://deb.debian.org/debian/pool/main/m/m4/m4_1.4.18-5.debian.tar.xz' m4_1.4.18-5.debian.tar.xz 17468 SHA256:94861648b7e3bc0e47eb0746d3c5717c879e74e59928be69064fa9968bc8f228
```

Other potentially useful URLs:

- https://sources.debian.net/src/m4/1.4.18-5/ (for browsing the source)
- https://sources.debian.net/src/m4/1.4.18-5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/m4/1.4.18-5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `make-dfsg=4.3-4.1`

Binary Packages:

- `make=4.3-4.1`

Licenses: (parsed from: `/usr/share/doc/make/copyright`)

- `GPL-3`
- `GPL-3+`

Source:

```console
$ apt-get source -qq --print-uris make-dfsg=4.3-4.1
'http://deb.debian.org/debian/pool/main/m/make-dfsg/make-dfsg_4.3-4.1.dsc' make-dfsg_4.3-4.1.dsc 2019 SHA256:d2523d94f4d4198df6801f238d36cf0dea2ab5521f1d19ee76b2e8ee1f1918bb
'http://deb.debian.org/debian/pool/main/m/make-dfsg/make-dfsg_4.3.orig.tar.gz' make-dfsg_4.3.orig.tar.gz 1845906 SHA256:be4c17542578824e745f83bcd2a9ba264206187247cb6a5f5df99b0a9d1f9047
'http://deb.debian.org/debian/pool/main/m/make-dfsg/make-dfsg_4.3-4.1.diff.gz' make-dfsg_4.3-4.1.diff.gz 50940 SHA256:753c254ecaba425ebe2e0a0fb4d299847701e1c3eeb43df563e39975cae56b4c
```

Other potentially useful URLs:

- https://sources.debian.net/src/make-dfsg/4.3-4.1/ (for browsing the source)
- https://sources.debian.net/src/make-dfsg/4.3-4.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/make-dfsg/4.3-4.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `mariadb-10.5=1:10.5.26-0+deb11u2`

Binary Packages:

- `libmariadb-dev=1:10.5.26-0+deb11u2`
- `libmariadb-dev-compat:amd64=1:10.5.26-0+deb11u2`
- `libmariadb3:amd64=1:10.5.26-0+deb11u2`
- `mariadb-common=1:10.5.26-0+deb11u2`

Licenses: (parsed from: `/usr/share/doc/libmariadb-dev/copyright`, `/usr/share/doc/libmariadb-dev-compat/copyright`, `/usr/share/doc/libmariadb3/copyright`, `/usr/share/doc/mariadb-common/copyright`)

- `Artistic`
- `BSD-2-Clause`
- `BSD-2-clause`
- `BSD-3-clause`
- `GPL-2`
- `GPL-2+`
- `GPL-2+-with-bison-exception`
- `GPL-3`
- `GPL-3+`
- `GPL-3+-with-bison-exception`
- `LGPL`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `MIT/X11`
- `SWsoft`
- `public-domain`
- `unlimited-free-doc`
- `zlib/libpng`

Source:

```console
$ apt-get source -qq --print-uris mariadb-10.5=1:10.5.26-0+deb11u2
'http://deb.debian.org/debian-security/pool/updates/main/m/mariadb-10.5/mariadb-10.5_10.5.26-0%2bdeb11u2.dsc' mariadb-10.5_10.5.26-0+deb11u2.dsc 4814 SHA256:3c64b6ab89fa29be72b9fe608a8c2bec27284ee5c2b43d98a21c5febbdc95b95
'http://deb.debian.org/debian-security/pool/updates/main/m/mariadb-10.5/mariadb-10.5_10.5.26.orig.tar.gz' mariadb-10.5_10.5.26.orig.tar.gz 116566259 SHA256:dd5f99a1d30ae47365fc18b1deeff6dc0ab38ac84e7d9fd9c8c04ff6b01961f1
'http://deb.debian.org/debian-security/pool/updates/main/m/mariadb-10.5/mariadb-10.5_10.5.26.orig.tar.gz.asc' mariadb-10.5_10.5.26.orig.tar.gz.asc 833 SHA256:37da13e92ea9ccb6a948eb6d3dc8b226084c21b36397cdbdcf72d9f96c4286fb
'http://deb.debian.org/debian-security/pool/updates/main/m/mariadb-10.5/mariadb-10.5_10.5.26-0%2bdeb11u2.debian.tar.xz' mariadb-10.5_10.5.26-0+deb11u2.debian.tar.xz 230564 SHA256:abfc63f8475718e28a84672fa9be404b60b04e26644b2e20ee777106b9c9e3ae
```

Other potentially useful URLs:

- https://sources.debian.net/src/mariadb-10.5/1:10.5.26-0+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/mariadb-10.5/1:10.5.26-0+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/mariadb-10.5/1:10.5.26-0+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `mawk=1.3.4.20200120-2`

Binary Packages:

- `mawk=1.3.4.20200120-2`

Licenses: (parsed from: `/usr/share/doc/mawk/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris mawk=1.3.4.20200120-2
'http://deb.debian.org/debian/pool/main/m/mawk/mawk_1.3.4.20200120-2.dsc' mawk_1.3.4.20200120-2.dsc 1915 SHA256:5069c46872ac74f5221250dfb88b31b1f2dbb8a2617c1e013f8f80cc34638c6d
'http://deb.debian.org/debian/pool/main/m/mawk/mawk_1.3.4.20200120.orig.tar.gz' mawk_1.3.4.20200120.orig.tar.gz 468855 SHA256:7fd4cd1e1fae9290fe089171181bbc6291dfd9bca939ca804f0ddb851c8b8237
'http://deb.debian.org/debian/pool/main/m/mawk/mawk_1.3.4.20200120-2.debian.tar.xz' mawk_1.3.4.20200120-2.debian.tar.xz 7504 SHA256:b772ed2f016b0286980c46cbc1f1f4ae62887ef2aa3dff6ef10cae638f923f26
```

Other potentially useful URLs:

- https://sources.debian.net/src/mawk/1.3.4.20200120-2/ (for browsing the source)
- https://sources.debian.net/src/mawk/1.3.4.20200120-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/mawk/1.3.4.20200120-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `media-types=4.0.0`

Binary Packages:

- `media-types=4.0.0`

Licenses: (parsed from: `/usr/share/doc/media-types/copyright`)

- `ad-hoc`

Source:

```console
$ apt-get source -qq --print-uris media-types=4.0.0
'http://deb.debian.org/debian/pool/main/m/media-types/media-types_4.0.0.dsc' media-types_4.0.0.dsc 1620 SHA256:422edc1275dcc6bf07ac1b30612f501624cba04cfca2331eb87f1ca3af89e701
'http://deb.debian.org/debian/pool/main/m/media-types/media-types_4.0.0.tar.xz' media-types_4.0.0.tar.xz 33988 SHA256:b5eb14fd6addb8f10c1665ebaa113cd0ebfb47f692cf27d9ac47405b13ce4e31
```

Other potentially useful URLs:

- https://sources.debian.net/src/media-types/4.0.0/ (for browsing the source)
- https://sources.debian.net/src/media-types/4.0.0/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/media-types/4.0.0/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `mercurial=5.6.1-4`

Binary Packages:

- `mercurial=5.6.1-4`
- `mercurial-common=5.6.1-4`

Licenses: (parsed from: `/usr/share/doc/mercurial/copyright`, `/usr/share/doc/mercurial-common/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris mercurial=5.6.1-4
'http://deb.debian.org/debian/pool/main/m/mercurial/mercurial_5.6.1-4.dsc' mercurial_5.6.1-4.dsc 2130 SHA256:d8930b0d0b8a4d1adc2951ef521a6194f07a2a0ef923cdfbf73fe109658a0311
'http://deb.debian.org/debian/pool/main/m/mercurial/mercurial_5.6.1.orig.tar.gz' mercurial_5.6.1.orig.tar.gz 7836342 SHA256:e55c254f4904c45226a106780e57f4279aee03368f6ff6a981d5d2a38243ffad
'http://deb.debian.org/debian/pool/main/m/mercurial/mercurial_5.6.1.orig.tar.gz.asc' mercurial_5.6.1.orig.tar.gz.asc 833 SHA256:bef5ca673b6fe7ab213e07826c2196dd41710df4739f9a49e57dc3d3d38a6d36
'http://deb.debian.org/debian/pool/main/m/mercurial/mercurial_5.6.1-4.debian.tar.xz' mercurial_5.6.1-4.debian.tar.xz 64588 SHA256:020e6bd6dcbccdb0ca5455116750120408225979ed186b84c58bb12cdb72d819
```

Other potentially useful URLs:

- https://sources.debian.net/src/mercurial/5.6.1-4/ (for browsing the source)
- https://sources.debian.net/src/mercurial/5.6.1-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/mercurial/5.6.1-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `mesa=20.3.5-1`

Binary Packages:

- `libegl-mesa0:amd64=20.3.5-1`
- `libgbm1:amd64=20.3.5-1`
- `libgl1-mesa-dev:amd64=20.3.5-1`
- `libgl1-mesa-dri:amd64=20.3.5-1`
- `libglapi-mesa:amd64=20.3.5-1`
- `libglx-mesa0:amd64=20.3.5-1`

Licenses: (parsed from: `/usr/share/doc/libegl-mesa0/copyright`, `/usr/share/doc/libgbm1/copyright`, `/usr/share/doc/libgl1-mesa-dev/copyright`, `/usr/share/doc/libgl1-mesa-dri/copyright`, `/usr/share/doc/libglapi-mesa/copyright`, `/usr/share/doc/libglx-mesa0/copyright`)

- `Apache-2.0`
- `BSD-2-clause`
- `BSD-3-google`
- `BSL`
- `GPL`
- `Khronos`
- `MIT`
- `MLAA`
- `SGI`

Source:

```console
$ apt-get source -qq --print-uris mesa=20.3.5-1
'http://deb.debian.org/debian/pool/main/m/mesa/mesa_20.3.5-1.dsc' mesa_20.3.5-1.dsc 5377 SHA256:4532af1ce8e512626596bc6753f083b1834f2af2d959226a007ccefefe0b5e4a
'http://deb.debian.org/debian/pool/main/m/mesa/mesa_20.3.5.orig.tar.gz' mesa_20.3.5.orig.tar.gz 22086344 SHA256:16586ea4738531f3c931dfb8668cefb7e338689dfd1037843c22cdd41b173fd0
'http://deb.debian.org/debian/pool/main/m/mesa/mesa_20.3.5-1.diff.gz' mesa_20.3.5-1.diff.gz 110704 SHA256:e49e04f7678468e61fdc7d6e47c7ba3338f036d6a71dd31b7dd514c8fce84647
```

Other potentially useful URLs:

- https://sources.debian.net/src/mesa/20.3.5-1/ (for browsing the source)
- https://sources.debian.net/src/mesa/20.3.5-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/mesa/20.3.5-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `mpclib3=1.2.0-1`

Binary Packages:

- `libmpc3:amd64=1.2.0-1`

Licenses: (parsed from: `/usr/share/doc/libmpc3/copyright`)

- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris mpclib3=1.2.0-1
'http://deb.debian.org/debian/pool/main/m/mpclib3/mpclib3_1.2.0-1.dsc' mpclib3_1.2.0-1.dsc 1851 SHA256:a1d1171fa4602a3b133e7d770f3fc12b417f7813125677be2ced102a41b6abce
'http://deb.debian.org/debian/pool/main/m/mpclib3/mpclib3_1.2.0.orig.tar.gz' mpclib3_1.2.0.orig.tar.gz 840711 SHA256:e90f2d99553a9c19911abdb4305bf8217106a957e3994436428572c8dfe8fda6
'http://deb.debian.org/debian/pool/main/m/mpclib3/mpclib3_1.2.0-1.diff.gz' mpclib3_1.2.0-1.diff.gz 4281 SHA256:9c5e1cd47ac7b5470d3a8649511ff9a8a2f528eed49e99fa4c875ba242c61ec4
```

Other potentially useful URLs:

- https://sources.debian.net/src/mpclib3/1.2.0-1/ (for browsing the source)
- https://sources.debian.net/src/mpclib3/1.2.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/mpclib3/1.2.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `mpdecimal=2.5.1-1`

Binary Packages:

- `libmpdec3:amd64=2.5.1-1`

Licenses: (parsed from: `/usr/share/doc/libmpdec3/copyright`)

- `BSD`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris mpdecimal=2.5.1-1
'http://deb.debian.org/debian/pool/main/m/mpdecimal/mpdecimal_2.5.1-1.dsc' mpdecimal_2.5.1-1.dsc 1919 SHA256:5b4e5bc4d714b76af72bc4eaad2ac7feeb08ac5ee9fa5318f91edebe118ab6f9
'http://deb.debian.org/debian/pool/main/m/mpdecimal/mpdecimal_2.5.1.orig.tar.gz' mpdecimal_2.5.1.orig.tar.gz 2584021 SHA256:9f9cd4c041f99b5c49ffb7b59d9f12d95b683d88585608aa56a6307667b2b21f
'http://deb.debian.org/debian/pool/main/m/mpdecimal/mpdecimal_2.5.1-1.debian.tar.xz' mpdecimal_2.5.1-1.debian.tar.xz 6444 SHA256:e46140b8e665aee3058d0b2fb4fa44bde600251c8471de73711fa23ac573ee8a
```

Other potentially useful URLs:

- https://sources.debian.net/src/mpdecimal/2.5.1-1/ (for browsing the source)
- https://sources.debian.net/src/mpdecimal/2.5.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/mpdecimal/2.5.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `mpfr4=4.1.0-3`

Binary Packages:

- `libmpfr6:amd64=4.1.0-3`

Licenses: (parsed from: `/usr/share/doc/libmpfr6/copyright`)

- `GFDL-1.2`
- `LGPL-3`

Source:

```console
$ apt-get source -qq --print-uris mpfr4=4.1.0-3
'http://deb.debian.org/debian/pool/main/m/mpfr4/mpfr4_4.1.0-3.dsc' mpfr4_4.1.0-3.dsc 1959 SHA256:6d2727cf53e788020f671a2cba644ff5dd4e28a2531e66c3ed32d98ce2b5bf4e
'http://deb.debian.org/debian/pool/main/m/mpfr4/mpfr4_4.1.0.orig.tar.xz' mpfr4_4.1.0.orig.tar.xz 1525476 SHA256:0c98a3f1732ff6ca4ea690552079da9c597872d30e96ec28414ee23c95558a7f
'http://deb.debian.org/debian/pool/main/m/mpfr4/mpfr4_4.1.0-3.debian.tar.xz' mpfr4_4.1.0-3.debian.tar.xz 12372 SHA256:b329dd24cba377ed4160c0819a5ec110e029fb52c93e9a141847d5ed2a2068e8
```

Other potentially useful URLs:

- https://sources.debian.net/src/mpfr4/4.1.0-3/ (for browsing the source)
- https://sources.debian.net/src/mpfr4/4.1.0-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/mpfr4/4.1.0-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `mpg123=1.26.4-1`

Binary Packages:

- `libmpg123-0:amd64=1.26.4-1`

Licenses: (parsed from: `/usr/share/doc/libmpg123-0/copyright`)

- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris mpg123=1.26.4-1
'http://deb.debian.org/debian/pool/main/m/mpg123/mpg123_1.26.4-1.dsc' mpg123_1.26.4-1.dsc 2559 SHA256:fd84138a719f27b4fcef8b2f9a0d0ee049c39466e01a495d571675dc20f0ea79
'http://deb.debian.org/debian/pool/main/m/mpg123/mpg123_1.26.4.orig.tar.bz2' mpg123_1.26.4.orig.tar.bz2 1050563 SHA256:081991540df7a666b29049ad870f293cfa28863b36488ab4d58ceaa7b5846454
'http://deb.debian.org/debian/pool/main/m/mpg123/mpg123_1.26.4.orig.tar.bz2.asc' mpg123_1.26.4.orig.tar.bz2.asc 833 SHA256:e4d0bef9aa45533294ab69028a823c25423e491e124ac8086e592e3fec765e6b
'http://deb.debian.org/debian/pool/main/m/mpg123/mpg123_1.26.4-1.debian.tar.xz' mpg123_1.26.4-1.debian.tar.xz 24232 SHA256:7b8e0b6de7f10b2c46a458a815403ec7e5684786f4e8af0dbe3688be5bd7bb33
```

Other potentially useful URLs:

- https://sources.debian.net/src/mpg123/1.26.4-1/ (for browsing the source)
- https://sources.debian.net/src/mpg123/1.26.4-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/mpg123/1.26.4-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `mysql-defaults=1.0.7`

Binary Packages:

- `default-libmysqlclient-dev:amd64=1.0.7`
- `mysql-common=5.8+1.0.7`

Licenses: (parsed from: `/usr/share/doc/default-libmysqlclient-dev/copyright`, `/usr/share/doc/mysql-common/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris mysql-defaults=1.0.7
'http://deb.debian.org/debian/pool/main/m/mysql-defaults/mysql-defaults_1.0.7.dsc' mysql-defaults_1.0.7.dsc 2266 SHA256:969c5682e991967f5b9488c04b784e63148c952fc597f7b7e5483e4204726649
'http://deb.debian.org/debian/pool/main/m/mysql-defaults/mysql-defaults_1.0.7.tar.xz' mysql-defaults_1.0.7.tar.xz 7220 SHA256:e2942479d614756e2e49698a6a3819b6e00b1285802799dab5519e0d2925437b
```

Other potentially useful URLs:

- https://sources.debian.net/src/mysql-defaults/1.0.7/ (for browsing the source)
- https://sources.debian.net/src/mysql-defaults/1.0.7/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/mysql-defaults/1.0.7/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `ncurses=6.2+20201114-2+deb11u2`

Binary Packages:

- `libncurses-dev:amd64=6.2+20201114-2+deb11u2`
- `libncurses5-dev:amd64=6.2+20201114-2+deb11u2`
- `libncurses6:amd64=6.2+20201114-2+deb11u2`
- `libncursesw5-dev:amd64=6.2+20201114-2+deb11u2`
- `libncursesw6:amd64=6.2+20201114-2+deb11u2`
- `libtinfo6:amd64=6.2+20201114-2+deb11u2`
- `ncurses-base=6.2+20201114-2+deb11u2`
- `ncurses-bin=6.2+20201114-2+deb11u2`

Licenses: (parsed from: `/usr/share/doc/libncurses-dev/copyright`, `/usr/share/doc/libncurses5-dev/copyright`, `/usr/share/doc/libncurses6/copyright`, `/usr/share/doc/libncursesw5-dev/copyright`, `/usr/share/doc/libncursesw6/copyright`, `/usr/share/doc/libtinfo6/copyright`, `/usr/share/doc/ncurses-base/copyright`, `/usr/share/doc/ncurses-bin/copyright`)

- `BSD-3-clause`
- `MIT/X11`
- `X11`

Source:

```console
$ apt-get source -qq --print-uris ncurses=6.2+20201114-2+deb11u2
'http://deb.debian.org/debian/pool/main/n/ncurses/ncurses_6.2%2b20201114-2%2bdeb11u2.dsc' ncurses_6.2+20201114-2+deb11u2.dsc 4138 SHA256:3ec39ab5dae31895ea40ca68d9f3e1b1c701e092a383fe4e0158f66c60043f49
'http://deb.debian.org/debian/pool/main/n/ncurses/ncurses_6.2%2b20201114.orig.tar.gz' ncurses_6.2+20201114.orig.tar.gz 3539796 SHA256:aa3f8cfaff2a2b78f184274ec43d9da910c864e4b4d80fc47b5b48cba9154cd2
'http://deb.debian.org/debian/pool/main/n/ncurses/ncurses_6.2%2b20201114.orig.tar.gz.asc' ncurses_6.2+20201114.orig.tar.gz.asc 265 SHA256:91615d9d5575f9e974e78c6aca55e1885f42d1b2600cebec407be4471bb7a27d
'http://deb.debian.org/debian/pool/main/n/ncurses/ncurses_6.2%2b20201114-2%2bdeb11u2.debian.tar.xz' ncurses_6.2+20201114-2+deb11u2.debian.tar.xz 54056 SHA256:c0f89212206e4c9dc5e141e2588ba82ea76051a04fccc5dc84075a358b3a6704
```

Other potentially useful URLs:

- https://sources.debian.net/src/ncurses/6.2+20201114-2+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/ncurses/6.2+20201114-2+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/ncurses/6.2+20201114-2+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `netbase=6.3`

Binary Packages:

- `netbase=6.3`

Licenses: (parsed from: `/usr/share/doc/netbase/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris netbase=6.3
'http://deb.debian.org/debian/pool/main/n/netbase/netbase_6.3.dsc' netbase_6.3.dsc 875 SHA256:f16f43e8b51814911d679d91cbfa9e9be4930a7c59c294c70b6af43ae7a1d42f
'http://deb.debian.org/debian/pool/main/n/netbase/netbase_6.3.tar.xz' netbase_6.3.tar.xz 31968 SHA256:7c42a6a1cafa0c64103c71cab6431fc8613179b2449a1a00e55e3584e860d81c
```

Other potentially useful URLs:

- https://sources.debian.net/src/netbase/6.3/ (for browsing the source)
- https://sources.debian.net/src/netbase/6.3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/netbase/6.3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `nettle=3.7.3-1`

Binary Packages:

- `libhogweed6:amd64=3.7.3-1`
- `libnettle8:amd64=3.7.3-1`

Licenses: (parsed from: `/usr/share/doc/libhogweed6/copyright`, `/usr/share/doc/libnettle8/copyright`)

- `Expat`
- `GAP`
- `GPL`
- `GPL-2`
- `GPL-2+`
- `GPL-3+`
- `GPL-3+ with Autoconf exception`
- `LGPL`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-3+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris nettle=3.7.3-1
'http://deb.debian.org/debian/pool/main/n/nettle/nettle_3.7.3-1.dsc' nettle_3.7.3-1.dsc 2033 SHA256:63a1a80f37b6484f479dfa1cbd30152feff3b1a5a2161fdab05b90edde212c1f
'http://deb.debian.org/debian/pool/main/n/nettle/nettle_3.7.3.orig.tar.gz' nettle_3.7.3.orig.tar.gz 2383985 SHA256:661f5eb03f048a3b924c3a8ad2515d4068e40f67e774e8a26827658007e3bcf0
'http://deb.debian.org/debian/pool/main/n/nettle/nettle_3.7.3-1.debian.tar.xz' nettle_3.7.3-1.debian.tar.xz 21956 SHA256:97af0e306aec6f6c5d8e73a7a3ce2856c76bcff9cdcfa7640e932a5a3aee9f24
```

Other potentially useful URLs:

- https://sources.debian.net/src/nettle/3.7.3-1/ (for browsing the source)
- https://sources.debian.net/src/nettle/3.7.3-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/nettle/3.7.3-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `nghttp2=1.43.0-1+deb11u2`

Binary Packages:

- `libnghttp2-14:amd64=1.43.0-1+deb11u2`

Licenses: (parsed from: `/usr/share/doc/libnghttp2-14/copyright`)

- `BSD-2-clause`
- `Expat`
- `GPL-3`
- `GPL-3+ with autoconf exception`
- `MIT`
- `SIL-OFL-1.1`
- `all-permissive`

Source:

```console
$ apt-get source -qq --print-uris nghttp2=1.43.0-1+deb11u2
'http://deb.debian.org/debian-security/pool/updates/main/n/nghttp2/nghttp2_1.43.0-1%2bdeb11u2.dsc' nghttp2_1.43.0-1+deb11u2.dsc 2555 SHA256:13ad116ef14dc9e3da1b3aa3b1f2645e2dcf44e153564a5ec26f5df5d91cd854
'http://deb.debian.org/debian-security/pool/updates/main/n/nghttp2/nghttp2_1.43.0.orig.tar.bz2' nghttp2_1.43.0.orig.tar.bz2 4521786 SHA256:556f24653397c71ebb8270b3c5e5507f0893e6eac2c6eeda6be2ecf6e1f50f62
'http://deb.debian.org/debian-security/pool/updates/main/n/nghttp2/nghttp2_1.43.0-1%2bdeb11u2.debian.tar.xz' nghttp2_1.43.0-1+deb11u2.debian.tar.xz 23484 SHA256:52cd263f1db0a02edf21322251d7a444eb2fce158bbcaf23e26bf25c6051fd83
```

Other potentially useful URLs:

- https://sources.debian.net/src/nghttp2/1.43.0-1+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/nghttp2/1.43.0-1+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/nghttp2/1.43.0-1+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `npth=1.6-3`

Binary Packages:

- `libnpth0:amd64=1.6-3`

Licenses: (parsed from: `/usr/share/doc/libnpth0/copyright`)

- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris npth=1.6-3
'http://deb.debian.org/debian/pool/main/n/npth/npth_1.6-3.dsc' npth_1.6-3.dsc 1931 SHA256:002c2a7936d1499ebb5d72dbb9c7ca3e00ed5fe3b0aa48f20b7279fc90aa9e90
'http://deb.debian.org/debian/pool/main/n/npth/npth_1.6.orig.tar.bz2' npth_1.6.orig.tar.bz2 300486 SHA256:1393abd9adcf0762d34798dc34fdcf4d0d22a8410721e76f1e3afcd1daa4e2d1
'http://deb.debian.org/debian/pool/main/n/npth/npth_1.6-3.debian.tar.xz' npth_1.6-3.debian.tar.xz 10712 SHA256:efa188104de503add9c49c17bec7bec0df814f7d1db9fdc2017574a0af98155c
```

Other potentially useful URLs:

- https://sources.debian.net/src/npth/1.6-3/ (for browsing the source)
- https://sources.debian.net/src/npth/1.6-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/npth/1.6-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `numactl=2.0.12-1`

Binary Packages:

- `libnuma1:amd64=2.0.12-1+b1`

Licenses: (parsed from: `/usr/share/doc/libnuma1/copyright`)

- `GPL`
- `LGPL`

Source:

```console
$ apt-get source -qq --print-uris numactl=2.0.12-1
'http://deb.debian.org/debian/pool/main/n/numactl/numactl_2.0.12-1.dsc' numactl_2.0.12-1.dsc 2033 SHA256:3b308b110de0728c5524b3135d871e55ebb6e4b93cdc583e93c4222219fe4d08
'http://deb.debian.org/debian/pool/main/n/numactl/numactl_2.0.12.orig.tar.gz' numactl_2.0.12.orig.tar.gz 421425 SHA256:2e67513a62168de4777da20d89cdab66d75bcd3badc4256f6b190a8111cd93f8
'http://deb.debian.org/debian/pool/main/n/numactl/numactl_2.0.12-1.debian.tar.xz' numactl_2.0.12-1.debian.tar.xz 6756 SHA256:966724cac8f309b33959ae9922b3e5ab58ea821e2e802d96425e1eaada639a33
```

Other potentially useful URLs:

- https://sources.debian.net/src/numactl/2.0.12-1/ (for browsing the source)
- https://sources.debian.net/src/numactl/2.0.12-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/numactl/2.0.12-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `openexr=2.5.4-2+deb11u1`

Binary Packages:

- `libopenexr-dev=2.5.4-2+deb11u1`
- `libopenexr25:amd64=2.5.4-2+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libopenexr-dev/copyright`, `/usr/share/doc/libopenexr25/copyright`)

- `BSD-3-clause`
- `openexr`

Source:

```console
$ apt-get source -qq --print-uris openexr=2.5.4-2+deb11u1
'http://deb.debian.org/debian/pool/main/o/openexr/openexr_2.5.4-2%2bdeb11u1.dsc' openexr_2.5.4-2+deb11u1.dsc 2467 SHA256:2807eaffae0d6ffde4e5414bfdf3fb89c2216b46dda5d9e4daefd14236bec3c5
'http://deb.debian.org/debian/pool/main/o/openexr/openexr_2.5.4.orig.tar.gz' openexr_2.5.4.orig.tar.gz 27535491 SHA256:dba19e9c6720c6f64fbc8b9d1867eaa75da6438109b941eefdc75ed141b6576d
'http://deb.debian.org/debian/pool/main/o/openexr/openexr_2.5.4-2%2bdeb11u1.debian.tar.xz' openexr_2.5.4-2+deb11u1.debian.tar.xz 25788 SHA256:83fba965ff63da0ba233b7cf7aca946e25b43ce15b8653b52291f07ce081bc1b
```

Other potentially useful URLs:

- https://sources.debian.net/src/openexr/2.5.4-2+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/openexr/2.5.4-2+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/openexr/2.5.4-2+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `openjpeg2=2.4.0-3`

Binary Packages:

- `libopenjp2-7:amd64=2.4.0-3`
- `libopenjp2-7-dev=2.4.0-3`

Licenses: (parsed from: `/usr/share/doc/libopenjp2-7/copyright`, `/usr/share/doc/libopenjp2-7-dev/copyright`)

- `BSD-2`
- `BSD-3`
- `LIBPNG`
- `LIBTIFF`
- `LIBTIFF-GLARSON`
- `LIBTIFF-PIXAR`
- `MIT`
- `ZLIB`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris openjpeg2=2.4.0-3
'http://deb.debian.org/debian/pool/main/o/openjpeg2/openjpeg2_2.4.0-3.dsc' openjpeg2_2.4.0-3.dsc 2768 SHA256:c2de7ec896d9fccad5a9d58761593446a0271564babf218fd4ab200b6fe92a05
'http://deb.debian.org/debian/pool/main/o/openjpeg2/openjpeg2_2.4.0.orig.tar.xz' openjpeg2_2.4.0.orig.tar.xz 1396964 SHA256:4b89da8abea5ea4e8dd5b214f1633a492554d784b5aebc22cb6495a1e5fe681c
'http://deb.debian.org/debian/pool/main/o/openjpeg2/openjpeg2_2.4.0-3.debian.tar.xz' openjpeg2_2.4.0-3.debian.tar.xz 19712 SHA256:99b94d26c341babae8b5599ca7f8f0e1bb2021eb282ceff5d3c91086d1a3bcfc
```

Other potentially useful URLs:

- https://sources.debian.net/src/openjpeg2/2.4.0-3/ (for browsing the source)
- https://sources.debian.net/src/openjpeg2/2.4.0-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/openjpeg2/2.4.0-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `openldap=2.4.57+dfsg-3+deb11u1`

Binary Packages:

- `libldap-2.4-2:amd64=2.4.57+dfsg-3+deb11u1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris openldap=2.4.57+dfsg-3+deb11u1
'http://deb.debian.org/debian/pool/main/o/openldap/openldap_2.4.57%2bdfsg-3%2bdeb11u1.dsc' openldap_2.4.57+dfsg-3+deb11u1.dsc 3227 SHA256:835471a38dd93cfc2c0cb6f3726a022e0a5ed47dc2759dbd811cec6df5c9e0d4
'http://deb.debian.org/debian/pool/main/o/openldap/openldap_2.4.57%2bdfsg.orig.tar.gz' openldap_2.4.57+dfsg.orig.tar.gz 5054318 SHA256:009cc88733eaf41a21607e073a19bce53d7d6ed90a5c280e80880978c4e91db7
'http://deb.debian.org/debian/pool/main/o/openldap/openldap_2.4.57%2bdfsg-3%2bdeb11u1.debian.tar.xz' openldap_2.4.57+dfsg-3+deb11u1.debian.tar.xz 170324 SHA256:2c1cbc8431c570ece2b8e6e0e13936c2f65a270e6473ecf5374ae5ba67147835
```

Other potentially useful URLs:

- https://sources.debian.net/src/openldap/2.4.57+dfsg-3+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/openldap/2.4.57+dfsg-3+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/openldap/2.4.57+dfsg-3+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `openssh=1:8.4p1-5+deb11u3`

Binary Packages:

- `openssh-client=1:8.4p1-5+deb11u3`

Licenses: (parsed from: `/usr/share/doc/openssh-client/copyright`)

- `BSD-2-clause`
- `BSD-3-clause`
- `Beer-ware`
- `Expat-with-advertising-restriction`
- `Mazieres-BSD-style`
- `OpenSSH`
- `Powell-BSD-style`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris openssh=1:8.4p1-5+deb11u3
'http://deb.debian.org/debian/pool/main/o/openssh/openssh_8.4p1-5%2bdeb11u3.dsc' openssh_8.4p1-5+deb11u3.dsc 3270 SHA256:0f800a412ac707c735afd90b5529511c5c1629b6aef342d824b2f66250565459
'http://deb.debian.org/debian/pool/main/o/openssh/openssh_8.4p1.orig.tar.gz' openssh_8.4p1.orig.tar.gz 1742201 SHA256:5a01d22e407eb1c05ba8a8f7c654d388a13e9f226e4ed33bd38748dafa1d2b24
'http://deb.debian.org/debian/pool/main/o/openssh/openssh_8.4p1.orig.tar.gz.asc' openssh_8.4p1.orig.tar.gz.asc 683 SHA256:ccd9dd484651ce4cc926228f6e1b46afaf0c5ab98a866217fa0ef1074370ea2b
'http://deb.debian.org/debian/pool/main/o/openssh/openssh_8.4p1-5%2bdeb11u3.debian.tar.xz' openssh_8.4p1-5+deb11u3.debian.tar.xz 186600 SHA256:f460cc974def7a03753f6d3e5248265aa01deca7e2ba5e29979677487e89cd41
```

Other potentially useful URLs:

- https://sources.debian.net/src/openssh/1:8.4p1-5+deb11u3/ (for browsing the source)
- https://sources.debian.net/src/openssh/1:8.4p1-5+deb11u3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/openssh/1:8.4p1-5+deb11u3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `openssl=1.1.1w-0+deb11u1`

Binary Packages:

- `libssl-dev:amd64=1.1.1w-0+deb11u1`
- `libssl1.1:amd64=1.1.1w-0+deb11u1`
- `openssl=1.1.1w-0+deb11u1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris openssl=1.1.1w-0+deb11u1
'http://deb.debian.org/debian/pool/main/o/openssl/openssl_1.1.1w-0%2bdeb11u1.dsc' openssl_1.1.1w-0+deb11u1.dsc 2652 SHA256:afbce4ea965ee02879ded4aec01030b2bd195014200e96c389e05f7e57c5bcbe
'http://deb.debian.org/debian/pool/main/o/openssl/openssl_1.1.1w.orig.tar.gz' openssl_1.1.1w.orig.tar.gz 9893384 SHA256:cf3098950cb4d853ad95c0841f1f9c6d3dc102dccfcacd521d93925208b76ac8
'http://deb.debian.org/debian/pool/main/o/openssl/openssl_1.1.1w.orig.tar.gz.asc' openssl_1.1.1w.orig.tar.gz.asc 833 SHA256:5e5c3694cda755231c0438ac3c96af00d7510abd7b916d79c51bb979567040db
'http://deb.debian.org/debian/pool/main/o/openssl/openssl_1.1.1w-0%2bdeb11u1.debian.tar.xz' openssl_1.1.1w-0+deb11u1.debian.tar.xz 84088 SHA256:022636c62f183b6157b1a1c65a1365690b6e3db5b0db38a5258ec8f097a05998
```

Other potentially useful URLs:

- https://sources.debian.net/src/openssl/1.1.1w-0+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/openssl/1.1.1w-0+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/openssl/1.1.1w-0+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `opus=1.3.1-0.1`

Binary Packages:

- `libopus0:amd64=1.3.1-0.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris opus=1.3.1-0.1
'http://deb.debian.org/debian/pool/main/o/opus/opus_1.3.1-0.1.dsc' opus_1.3.1-0.1.dsc 1973 SHA256:b697ec32cc0548e51bcc82296d2072b55fbf521eff40b0163e0d7e334ec5a1fb
'http://deb.debian.org/debian/pool/main/o/opus/opus_1.3.1.orig.tar.gz' opus_1.3.1.orig.tar.gz 1040054 SHA256:65b58e1e25b2a114157014736a3d9dfeaad8d41be1c8179866f144a2fb44ff9d
'http://deb.debian.org/debian/pool/main/o/opus/opus_1.3.1-0.1.diff.gz' opus_1.3.1-0.1.diff.gz 8831 SHA256:40a5229d0b3c9ad1afe7a040f80ec3242f1f6eb855eae43f21fad33ed368f137
```

Other potentially useful URLs:

- https://sources.debian.net/src/opus/1.3.1-0.1/ (for browsing the source)
- https://sources.debian.net/src/opus/1.3.1-0.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/opus/1.3.1-0.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `orc=1:0.4.32-1`

Binary Packages:

- `liborc-0.4-0:amd64=1:0.4.32-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris orc=1:0.4.32-1
'http://deb.debian.org/debian/pool/main/o/orc/orc_0.4.32-1.dsc' orc_0.4.32-1.dsc 2323 SHA256:87cfe7e2b15c979fc3a0cc021211edbc04f94ca667974bc4feae6de957f4e7bd
'http://deb.debian.org/debian/pool/main/o/orc/orc_0.4.32.orig.tar.xz' orc_0.4.32.orig.tar.xz 180340 SHA256:a66e3d8f2b7e65178d786a01ef61f2a0a0b4d0b8370de7ce134ba73da4af18f0
'http://deb.debian.org/debian/pool/main/o/orc/orc_0.4.32-1.debian.tar.xz' orc_0.4.32-1.debian.tar.xz 5644 SHA256:98f2598023364af087d4d6b45ad89ed3caa80ba0589755ee7cc79b22fb7cb440
```

Other potentially useful URLs:

- https://sources.debian.net/src/orc/1:0.4.32-1/ (for browsing the source)
- https://sources.debian.net/src/orc/1:0.4.32-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/orc/1:0.4.32-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `p11-kit=0.23.22-1`

Binary Packages:

- `libp11-kit0:amd64=0.23.22-1`

Licenses: (parsed from: `/usr/share/doc/libp11-kit0/copyright`)

- `BSD-3-Clause`
- `ISC`
- `ISC+IBM`
- `permissive-like-automake-output`
- `same-as-rest-of-p11kit`

Source:

```console
$ apt-get source -qq --print-uris p11-kit=0.23.22-1
'http://deb.debian.org/debian/pool/main/p/p11-kit/p11-kit_0.23.22-1.dsc' p11-kit_0.23.22-1.dsc 2417 SHA256:b5f7a7908a7da082fa74c2a35667f4f4dd1324eaf43ff4b4a0ffa7e2763774a6
'http://deb.debian.org/debian/pool/main/p/p11-kit/p11-kit_0.23.22.orig.tar.xz' p11-kit_0.23.22.orig.tar.xz 830016 SHA256:8a8f40153dd5a3f8e7c03e641f8db400133fb2a6a9ab2aee1b6d0cb0495ec6b6
'http://deb.debian.org/debian/pool/main/p/p11-kit/p11-kit_0.23.22.orig.tar.xz.asc' p11-kit_0.23.22.orig.tar.xz.asc 854 SHA256:52d36bd38ed84dcc394b97da18ff4b4e220f0b13c5e7922f5b908312678b0b02
'http://deb.debian.org/debian/pool/main/p/p11-kit/p11-kit_0.23.22-1.debian.tar.xz' p11-kit_0.23.22-1.debian.tar.xz 22256 SHA256:05a157dbeb054dd14c19c0c4f72c50e57fb69c4cfa4b5d34bc7ecdb5d12e7265
```

Other potentially useful URLs:

- https://sources.debian.net/src/p11-kit/0.23.22-1/ (for browsing the source)
- https://sources.debian.net/src/p11-kit/0.23.22-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/p11-kit/0.23.22-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pam=1.4.0-9+deb11u1`

Binary Packages:

- `libpam-modules:amd64=1.4.0-9+deb11u1`
- `libpam-modules-bin=1.4.0-9+deb11u1`
- `libpam-runtime=1.4.0-9+deb11u1`
- `libpam0g:amd64=1.4.0-9+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libpam-modules/copyright`, `/usr/share/doc/libpam-modules-bin/copyright`, `/usr/share/doc/libpam-runtime/copyright`, `/usr/share/doc/libpam0g/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris pam=1.4.0-9+deb11u1
'http://deb.debian.org/debian/pool/main/p/pam/pam_1.4.0-9%2bdeb11u1.dsc' pam_1.4.0-9+deb11u1.dsc 1941 SHA256:190b705cc9daeee1febb84e8ac6f31219065f08ff41c8d38fbbb424b545d5ca4
'http://deb.debian.org/debian/pool/main/p/pam/pam_1.4.0.orig.tar.xz' pam_1.4.0.orig.tar.xz 988908 SHA256:cd6d928c51e64139be3bdb38692c68183a509b83d4f2c221024ccd4bcddfd034
'http://deb.debian.org/debian/pool/main/p/pam/pam_1.4.0-9%2bdeb11u1.debian.tar.xz' pam_1.4.0-9+deb11u1.debian.tar.xz 120148 SHA256:bcaaad9423c3ab32c5c4f9e363595a84fe3c535aa9568e42e560028a4e33dfcf
```

Other potentially useful URLs:

- https://sources.debian.net/src/pam/1.4.0-9+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/pam/1.4.0-9+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pam/1.4.0-9+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pango1.0=1.46.2-3`

Binary Packages:

- `libpango-1.0-0:amd64=1.46.2-3`
- `libpangocairo-1.0-0:amd64=1.46.2-3`
- `libpangoft2-1.0-0:amd64=1.46.2-3`

Licenses: (parsed from: `/usr/share/doc/libpango-1.0-0/copyright`, `/usr/share/doc/libpangocairo-1.0-0/copyright`, `/usr/share/doc/libpangoft2-1.0-0/copyright`)

- `Chromium-BSD-style`
- `Example`
- `ICU`
- `LGPL-2`
- `LGPL-2+`
- `TCL`
- `Unicode`

Source:

```console
$ apt-get source -qq --print-uris pango1.0=1.46.2-3
'http://deb.debian.org/debian/pool/main/p/pango1.0/pango1.0_1.46.2-3.dsc' pango1.0_1.46.2-3.dsc 3542 SHA256:bfa040cfe6ac73d4452902b682dead39e6bd057da73b5432912bb50a5336ba8a
'http://deb.debian.org/debian/pool/main/p/pango1.0/pango1.0_1.46.2.orig.tar.xz' pango1.0_1.46.2.orig.tar.xz 535108 SHA256:d89fab5f26767261b493279b65cfb9eb0955cd44c07c5628d36094609fc51841
'http://deb.debian.org/debian/pool/main/p/pango1.0/pango1.0_1.46.2-3.debian.tar.xz' pango1.0_1.46.2-3.debian.tar.xz 38956 SHA256:34e19749e45cba527a0c7f7faf5f118606a6bd85121ef58fe66d87e0e6c9a312
```

Other potentially useful URLs:

- https://sources.debian.net/src/pango1.0/1.46.2-3/ (for browsing the source)
- https://sources.debian.net/src/pango1.0/1.46.2-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pango1.0/1.46.2-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `patch=2.7.6-7`

Binary Packages:

- `patch=2.7.6-7`

Licenses: (parsed from: `/usr/share/doc/patch/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris patch=2.7.6-7
'http://deb.debian.org/debian/pool/main/p/patch/patch_2.7.6-7.dsc' patch_2.7.6-7.dsc 1706 SHA256:d954fd576d935ac54b7d44d4976eb52d0da84a57f7bad90c6e5bd5e33595030a
'http://deb.debian.org/debian/pool/main/p/patch/patch_2.7.6.orig.tar.xz' patch_2.7.6.orig.tar.xz 783756 SHA256:ac610bda97abe0d9f6b7c963255a11dcb196c25e337c61f94e4778d632f1d8fd
'http://deb.debian.org/debian/pool/main/p/patch/patch_2.7.6-7.debian.tar.xz' patch_2.7.6-7.debian.tar.xz 15084 SHA256:7725f30b042d8cf63516e480036e93ca2ff0ce5ad3754db4a4e69d33e96a2624
```

Other potentially useful URLs:

- https://sources.debian.net/src/patch/2.7.6-7/ (for browsing the source)
- https://sources.debian.net/src/patch/2.7.6-7/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/patch/2.7.6-7/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pcre2=10.36-2+deb11u1`

Binary Packages:

- `libpcre2-16-0:amd64=10.36-2+deb11u1`
- `libpcre2-32-0:amd64=10.36-2+deb11u1`
- `libpcre2-8-0:amd64=10.36-2+deb11u1`
- `libpcre2-dev:amd64=10.36-2+deb11u1`
- `libpcre2-posix2:amd64=10.36-2+deb11u1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris pcre2=10.36-2+deb11u1
'http://deb.debian.org/debian/pool/main/p/pcre2/pcre2_10.36-2%2bdeb11u1.dsc' pcre2_10.36-2+deb11u1.dsc 2329 SHA256:9a1b7f2d20d539f4be97d07c92a980e339ae36087ca1cd51177345b37a2ec3a9
'http://deb.debian.org/debian/pool/main/p/pcre2/pcre2_10.36.orig.tar.gz' pcre2_10.36.orig.tar.gz 2290719 SHA256:b95ddb9414f91a967a887d69617059fb672b914f56fa3d613812c1ee8e8a1a37
'http://deb.debian.org/debian/pool/main/p/pcre2/pcre2_10.36-2%2bdeb11u1.diff.gz' pcre2_10.36-2+deb11u1.diff.gz 10596 SHA256:1172d8b80fa7c13c3eb571a1163babe5052f6b4586329e817ccba9759046da01
```

Other potentially useful URLs:

- https://sources.debian.net/src/pcre2/10.36-2+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/pcre2/10.36-2+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pcre2/10.36-2+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pcre3=2:8.39-13`

Binary Packages:

- `libpcre16-3:amd64=2:8.39-13`
- `libpcre3:amd64=2:8.39-13`
- `libpcre3-dev:amd64=2:8.39-13`
- `libpcre32-3:amd64=2:8.39-13`
- `libpcrecpp0v5:amd64=2:8.39-13`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris pcre3=2:8.39-13
'http://deb.debian.org/debian/pool/main/p/pcre3/pcre3_8.39-13.dsc' pcre3_8.39-13.dsc 2226 SHA256:c3a2eb4f02de5b2e00787ed2a35eb82f04ee4b5e99b8ff279bae3c6453aad93b
'http://deb.debian.org/debian/pool/main/p/pcre3/pcre3_8.39.orig.tar.bz2' pcre3_8.39.orig.tar.bz2 1560758 SHA256:b858099f82483031ee02092711689e7245586ada49e534a06e678b8ea9549e8b
'http://deb.debian.org/debian/pool/main/p/pcre3/pcre3_8.39-13.debian.tar.gz' pcre3_8.39-13.debian.tar.gz 27002 SHA256:a2143d7358d69b61955a4f977980050447f8891c0e6737080f2b14b920fbde87
```

Other potentially useful URLs:

- https://sources.debian.net/src/pcre3/2:8.39-13/ (for browsing the source)
- https://sources.debian.net/src/pcre3/2:8.39-13/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pcre3/2:8.39-13/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `perl=5.32.1-4+deb11u3`

Binary Packages:

- `libperl5.32:amd64=5.32.1-4+deb11u3`
- `perl=5.32.1-4+deb11u3`
- `perl-base=5.32.1-4+deb11u3`
- `perl-modules-5.32=5.32.1-4+deb11u3`

Licenses: (parsed from: `/usr/share/doc/libperl5.32/copyright`, `/usr/share/doc/perl/copyright`, `/usr/share/doc/perl-base/copyright`, `/usr/share/doc/perl-modules-5.32/copyright`)

- `Artistic`
- `Artistic,`
- `Artistic-2`
- `Artistic-dist`
- `BSD-3-clause`
- `BSD-3-clause-GENERIC`
- `BSD-3-clause-with-weird-numbering`
- `BSD-4-clause-POWERDOG`
- `BZIP`
- `CC0-1.0`
- `DONT-CHANGE-THE-GPL`
- `Expat`
- `GPL-1`
- `GPL-1+`
- `GPL-2`
- `GPL-2+`
- `GPL-3+-WITH-BISON-EXCEPTION`
- `HSIEH-BSD`
- `HSIEH-DERIVATIVE`
- `LGPL-2.1`
- `REGCOMP`
- `REGCOMP,`
- `RRA-KEEP-THIS-NOTICE`
- `SDBM-PUBLIC-DOMAIN`
- `TEXT-TABS`
- `Unicode`
- `ZLIB`

Source:

```console
$ apt-get source -qq --print-uris perl=5.32.1-4+deb11u3
'http://deb.debian.org/debian/pool/main/p/perl/perl_5.32.1-4%2bdeb11u3.dsc' perl_5.32.1-4+deb11u3.dsc 2918 SHA256:75699317b7e2865de39e86fb53f630669fd6e5904c8526699e8a01af98d56e6d
'http://deb.debian.org/debian/pool/main/p/perl/perl_5.32.1.orig-regen-configure.tar.gz' perl_5.32.1.orig-regen-configure.tar.gz 871331 SHA256:1d179b41283f12ad83f9758430f6ddc49bdf20db5c396aeae7e51ebb4e4afd29
'http://deb.debian.org/debian/pool/main/p/perl/perl_5.32.1.orig.tar.xz' perl_5.32.1.orig.tar.xz 12610988 SHA256:57cc47c735c8300a8ce2fa0643507b44c4ae59012bfdad0121313db639e02309
'http://deb.debian.org/debian/pool/main/p/perl/perl_5.32.1-4%2bdeb11u3.debian.tar.xz' perl_5.32.1-4+deb11u3.debian.tar.xz 167388 SHA256:a875b28e158180906d77df06dea08b8e724f91b31249fe7d205fc3f2cb520ddf
```

Other potentially useful URLs:

- https://sources.debian.net/src/perl/5.32.1-4+deb11u3/ (for browsing the source)
- https://sources.debian.net/src/perl/5.32.1-4+deb11u3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/perl/5.32.1-4+deb11u3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pinentry=1.1.0-4`

Binary Packages:

- `pinentry-curses=1.1.0-4`

Licenses: (parsed from: `/usr/share/doc/pinentry-curses/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-3`
- `LGPL-3+`
- `X11`

Source:

```console
$ apt-get source -qq --print-uris pinentry=1.1.0-4
'http://deb.debian.org/debian/pool/main/p/pinentry/pinentry_1.1.0-4.dsc' pinentry_1.1.0-4.dsc 2216 SHA256:81af8caf54fb2ddc6ac27d768999b3aa5d3bbeec7f2edac839b2c6792a3cf787
'http://deb.debian.org/debian/pool/main/p/pinentry/pinentry_1.1.0.orig.tar.bz2' pinentry_1.1.0.orig.tar.bz2 467702 SHA256:68076686fa724a290ea49cdf0d1c0c1500907d1b759a3bcbfbec0293e8f56570
'http://deb.debian.org/debian/pool/main/p/pinentry/pinentry_1.1.0.orig.tar.bz2.asc' pinentry_1.1.0.orig.tar.bz2.asc 488 SHA256:2e9ee3454f9e0be2f6cbc0e289fa5e0620d765e537286ff2c5c28b382f96106a
'http://deb.debian.org/debian/pool/main/p/pinentry/pinentry_1.1.0-4.debian.tar.xz' pinentry_1.1.0-4.debian.tar.xz 17240 SHA256:b3e36d239219ab35f824c5f9b3dd0c335a4394c59b7628e845831794335b8a8e
```

Other potentially useful URLs:

- https://sources.debian.net/src/pinentry/1.1.0-4/ (for browsing the source)
- https://sources.debian.net/src/pinentry/1.1.0-4/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pinentry/1.1.0-4/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pixman=0.40.0-1.1~deb11u1`

Binary Packages:

- `libpixman-1-0:amd64=0.40.0-1.1~deb11u1`
- `libpixman-1-dev:amd64=0.40.0-1.1~deb11u1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris pixman=0.40.0-1.1~deb11u1
'http://deb.debian.org/debian/pool/main/p/pixman/pixman_0.40.0-1.1%7edeb11u1.dsc' pixman_0.40.0-1.1~deb11u1.dsc 2216 SHA256:f7a628fbfcb5dae5178daab6e0225be55dbf6ffd8efa60429d1d3dd59584d334
'http://deb.debian.org/debian/pool/main/p/pixman/pixman_0.40.0.orig.tar.gz' pixman_0.40.0.orig.tar.gz 913976 SHA256:6d200dec3740d9ec4ec8d1180e25779c00bc749f94278c8b9021f5534db223fc
'http://deb.debian.org/debian/pool/main/p/pixman/pixman_0.40.0-1.1%7edeb11u1.diff.gz' pixman_0.40.0-1.1~deb11u1.diff.gz 320106 SHA256:11dad4be11db34aab221a324b78a5f7a88ac96596f5ac39d4fe3b634325b00b7
```

Other potentially useful URLs:

- https://sources.debian.net/src/pixman/0.40.0-1.1~deb11u1/ (for browsing the source)
- https://sources.debian.net/src/pixman/0.40.0-1.1~deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pixman/0.40.0-1.1~deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pkg-config=0.29.2-1`

Binary Packages:

- `pkg-config=0.29.2-1`

Licenses: (parsed from: `/usr/share/doc/pkg-config/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris pkg-config=0.29.2-1
'http://deb.debian.org/debian/pool/main/p/pkg-config/pkg-config_0.29.2-1.dsc' pkg-config_0.29.2-1.dsc 1771 SHA256:e4feeda94c3882e2aca55eab907900508a2e35111f927a79076154870f8fe373
'http://deb.debian.org/debian/pool/main/p/pkg-config/pkg-config_0.29.2.orig.tar.gz' pkg-config_0.29.2.orig.tar.gz 2016830 SHA256:6fc69c01688c9458a57eb9a1664c9aba372ccda420a02bf4429fe610e7e7d591
'http://deb.debian.org/debian/pool/main/p/pkg-config/pkg-config_0.29.2-1.diff.gz' pkg-config_0.29.2-1.diff.gz 9202 SHA256:6ecdd3463718e8922b53fca8d2fd37db4ba178f078b5e3ccd38c1a6efffb94ad
```

Other potentially useful URLs:

- https://sources.debian.net/src/pkg-config/0.29.2-1/ (for browsing the source)
- https://sources.debian.net/src/pkg-config/0.29.2-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pkg-config/0.29.2-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `postgresql-13=13.16-0+deb11u1`

Binary Packages:

- `libpq-dev=13.16-0+deb11u1`
- `libpq5:amd64=13.16-0+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libpq-dev/copyright`, `/usr/share/doc/libpq5/copyright`)

- `Artistic`
- `BSD-2-clause`
- `BSD-3-Clause`
- `BSD-3-clause`
- `Custom-Unicode`
- `Custom-pg_dump`
- `Custom-regex`
- `GPL-1`
- `PostgreSQL`
- `Tcl`
- `blf`
- `double-metaphone`
- `imath`
- `nagaysau-ishii`
- `rijndael`

Source:

```console
$ apt-get source -qq --print-uris postgresql-13=13.16-0+deb11u1
'http://deb.debian.org/debian/pool/main/p/postgresql-13/postgresql-13_13.16-0%2bdeb11u1.dsc' postgresql-13_13.16-0+deb11u1.dsc 3703 SHA256:c1c95c213760880a6b86a38b95c27cc0559fc9db98955579eb95b7176ac9dc2e
'http://deb.debian.org/debian/pool/main/p/postgresql-13/postgresql-13_13.16.orig.tar.bz2' postgresql-13_13.16.orig.tar.bz2 21639411 SHA256:c9cbbb6129f02328204828066bb3785c00a85c8ca8fd329c2a8a53c1f5cd8865
'http://deb.debian.org/debian/pool/main/p/postgresql-13/postgresql-13_13.16-0%2bdeb11u1.debian.tar.xz' postgresql-13_13.16-0+deb11u1.debian.tar.xz 35060 SHA256:8c68c86c19f783c4ea8ade14c56998c5843d4fbde004e4253604652a0d55efdf
```

Other potentially useful URLs:

- https://sources.debian.net/src/postgresql-13/13.16-0+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/postgresql-13/13.16-0+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/postgresql-13/13.16-0+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `procps=2:3.3.17-5`

Binary Packages:

- `libprocps8:amd64=2:3.3.17-5`
- `procps=2:3.3.17-5`

Licenses: (parsed from: `/usr/share/doc/libprocps8/copyright`, `/usr/share/doc/procps/copyright`)

- `GPL-2`
- `GPL-2.0+`
- `LGPL-2`
- `LGPL-2.0+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris procps=2:3.3.17-5
'http://deb.debian.org/debian/pool/main/p/procps/procps_3.3.17-5.dsc' procps_3.3.17-5.dsc 2136 SHA256:3b1d9a3d3bc9ec24360ed20721d4235fcd4b4dbb9a86c1eba6c42899a50ecff8
'http://deb.debian.org/debian/pool/main/p/procps/procps_3.3.17.orig.tar.xz' procps_3.3.17.orig.tar.xz 1008428 SHA256:4518b3e7aafd34ec07d0063d250fd474999b20b200218c3ae56f5d2113f141b4
'http://deb.debian.org/debian/pool/main/p/procps/procps_3.3.17-5.debian.tar.xz' procps_3.3.17-5.debian.tar.xz 28608 SHA256:e6b5f9ef22eca9f03f79dc79b4c389249368216df8702a8cc380e10f29eda8c9
```

Other potentially useful URLs:

- https://sources.debian.net/src/procps/2:3.3.17-5/ (for browsing the source)
- https://sources.debian.net/src/procps/2:3.3.17-5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/procps/2:3.3.17-5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `pulseaudio=14.2-2`

Binary Packages:

- `libpulse0:amd64=14.2-2`

Licenses: (parsed from: `/usr/share/doc/libpulse0/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris pulseaudio=14.2-2
'http://deb.debian.org/debian/pool/main/p/pulseaudio/pulseaudio_14.2-2.dsc' pulseaudio_14.2-2.dsc 3699 SHA256:db63e39989680e10bc65fab4714aa951616059cdc54143ee4a330df6ac7b30e3
'http://deb.debian.org/debian/pool/main/p/pulseaudio/pulseaudio_14.2.orig.tar.xz' pulseaudio_14.2.orig.tar.xz 1951300 SHA256:75d3f7742c1ae449049a4c88900e454b8b350ecaa8c544f3488a2562a9ff66f1
'http://deb.debian.org/debian/pool/main/p/pulseaudio/pulseaudio_14.2-2.debian.tar.xz' pulseaudio_14.2-2.debian.tar.xz 35532 SHA256:f342e3567528929c57f17d17a848c654d645b9e1ca8c211928bff0e8b580c467
```

Other potentially useful URLs:

- https://sources.debian.net/src/pulseaudio/14.2-2/ (for browsing the source)
- https://sources.debian.net/src/pulseaudio/14.2-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/pulseaudio/14.2-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python3-defaults=3.9.2-3`

Binary Packages:

- `libpython3-stdlib:amd64=3.9.2-3`
- `python3=3.9.2-3`
- `python3-minimal=3.9.2-3`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris python3-defaults=3.9.2-3
'http://deb.debian.org/debian/pool/main/p/python3-defaults/python3-defaults_3.9.2-3.dsc' python3-defaults_3.9.2-3.dsc 2879 SHA256:625d69b163c4ba751d717ccd4e4202f6c3132a4734f0d083ae11dea465cc7760
'http://deb.debian.org/debian/pool/main/p/python3-defaults/python3-defaults_3.9.2-3.tar.gz' python3-defaults_3.9.2-3.tar.gz 140929 SHA256:64a82311e46c734a897e408cad11d17e5631ec3ec889ae90948111150e8f18ce
```

Other potentially useful URLs:

- https://sources.debian.net/src/python3-defaults/3.9.2-3/ (for browsing the source)
- https://sources.debian.net/src/python3-defaults/3.9.2-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python3-defaults/3.9.2-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python3-stdlib-extensions=3.9.2-1`

Binary Packages:

- `python3-distutils=3.9.2-1`
- `python3-lib2to3=3.9.2-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris python3-stdlib-extensions=3.9.2-1
'http://deb.debian.org/debian/pool/main/p/python3-stdlib-extensions/python3-stdlib-extensions_3.9.2-1.dsc' python3-stdlib-extensions_3.9.2-1.dsc 2450 SHA256:bc55bb6577ada0315f267035d658b8aeeb78f6089987418a75156f7e10ebf8c8
'http://deb.debian.org/debian/pool/main/p/python3-stdlib-extensions/python3-stdlib-extensions_3.9.2.orig.tar.xz' python3-stdlib-extensions_3.9.2.orig.tar.xz 1103424 SHA256:4c77b2e3f2d9518767f2bf0b58bfafd7560fdd4aebc162a642d7a7af748f9d07
'http://deb.debian.org/debian/pool/main/p/python3-stdlib-extensions/python3-stdlib-extensions_3.9.2-1.debian.tar.xz' python3-stdlib-extensions_3.9.2-1.debian.tar.xz 18832 SHA256:46c8a5f71adde687b71a0aa39177d74cc355255f40121e64a30a7dc30c4e3ce5
```

Other potentially useful URLs:

- https://sources.debian.net/src/python3-stdlib-extensions/3.9.2-1/ (for browsing the source)
- https://sources.debian.net/src/python3-stdlib-extensions/3.9.2-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python3-stdlib-extensions/3.9.2-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `python3.9=3.9.2-1`

Binary Packages:

- `libpython3.9-minimal:amd64=3.9.2-1`
- `libpython3.9-stdlib:amd64=3.9.2-1`
- `python3.9=3.9.2-1`
- `python3.9-minimal=3.9.2-1`

Licenses: (parsed from: `/usr/share/doc/libpython3.9-minimal/copyright`, `/usr/share/doc/libpython3.9-stdlib/copyright`, `/usr/share/doc/python3.9/copyright`, `/usr/share/doc/python3.9-minimal/copyright`)

- `* Permission to use this software in any way is granted without`
- `By obtaining, using, and/or copying this software and/or its`
- `GPL-2`
- `Permission  is  hereby granted,  free  of charge,  to  any person`
- `Permission is hereby granted, free of charge, to any person obtaining`
- `Permission to use, copy, modify,`
- `Redistribution`
- `This software is provided 'as-is', without any express`
- `This software is provided as-is, without express`
- `binary forms, with`
- `distribute this software`
- `distribute this software and`
- `distribute this software for any`
- `implied`
- `its`
- `use in source`
- `without`

Source:

```console
$ apt-get source -qq --print-uris python3.9=3.9.2-1
'http://deb.debian.org/debian/pool/main/p/python3.9/python3.9_3.9.2-1.dsc' python3.9_3.9.2-1.dsc 3493 SHA256:63bc63b864067e7f993be8bc9bf2a08363fde05895bea86961fc5d781e42b68b
'http://deb.debian.org/debian/pool/main/p/python3.9/python3.9_3.9.2.orig.tar.xz' python3.9_3.9.2.orig.tar.xz 18889164 SHA256:3c2034c54f811448f516668dce09d24008a0716c3a794dd8639b5388cbde247d
'http://deb.debian.org/debian/pool/main/p/python3.9/python3.9_3.9.2-1.debian.tar.xz' python3.9_3.9.2-1.debian.tar.xz 211484 SHA256:b8b9e1710ca5dc5b0f0d9734494024ea11f560e36c34eb9191ccb0605798a490
```

Other potentially useful URLs:

- https://sources.debian.net/src/python3.9/3.9.2-1/ (for browsing the source)
- https://sources.debian.net/src/python3.9/3.9.2-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/python3.9/3.9.2-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `readline=8.1-1`

Binary Packages:

- `libreadline-dev:amd64=8.1-1`
- `libreadline8:amd64=8.1-1`
- `readline-common=8.1-1`

Licenses: (parsed from: `/usr/share/doc/libreadline-dev/copyright`, `/usr/share/doc/libreadline8/copyright`, `/usr/share/doc/readline-common/copyright`)

- `GFDL`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris readline=8.1-1
'http://deb.debian.org/debian/pool/main/r/readline/readline_8.1-1.dsc' readline_8.1-1.dsc 2418 SHA256:53356fdf2ee122ab75c7b535d292385311f7dea425ccc42143d2b9a2accfc657
'http://deb.debian.org/debian/pool/main/r/readline/readline_8.1.orig.tar.gz' readline_8.1.orig.tar.gz 2993288 SHA256:f8ceb4ee131e3232226a17f51b164afc46cd0b9e6cef344be87c65962cb82b02
'http://deb.debian.org/debian/pool/main/r/readline/readline_8.1-1.debian.tar.xz' readline_8.1-1.debian.tar.xz 29220 SHA256:852267a95aeec23b267c838469fee346e83a29e7a08071178dc87682591cffbf
```

Other potentially useful URLs:

- https://sources.debian.net/src/readline/8.1-1/ (for browsing the source)
- https://sources.debian.net/src/readline/8.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/readline/8.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `rtmpdump=2.4+20151223.gitfa8646d.1-2`

Binary Packages:

- `librtmp1:amd64=2.4+20151223.gitfa8646d.1-2+b2`

Licenses: (parsed from: `/usr/share/doc/librtmp1/copyright`)

- `GPL-2`
- `LGPL-2.1`

Source:

```console
$ apt-get source -qq --print-uris rtmpdump=2.4+20151223.gitfa8646d.1-2
'http://deb.debian.org/debian/pool/main/r/rtmpdump/rtmpdump_2.4%2b20151223.gitfa8646d.1-2.dsc' rtmpdump_2.4+20151223.gitfa8646d.1-2.dsc 2299 SHA256:a296819cd2ab5880b67ad963ef0867cb10e462f4403e52565aa863eb05bb1370
'http://deb.debian.org/debian/pool/main/r/rtmpdump/rtmpdump_2.4%2b20151223.gitfa8646d.1.orig.tar.gz' rtmpdump_2.4+20151223.gitfa8646d.1.orig.tar.gz 142213 SHA256:5c032f5c8cc2937eb55a81a94effdfed3b0a0304b6376147b86f951e225e3ab5
'http://deb.debian.org/debian/pool/main/r/rtmpdump/rtmpdump_2.4%2b20151223.gitfa8646d.1-2.debian.tar.xz' rtmpdump_2.4+20151223.gitfa8646d.1-2.debian.tar.xz 8096 SHA256:26d47de07d16285e4ca55b0828cbbf1ba35e671f9b3500a87e301fe755d26882
```

Other potentially useful URLs:

- https://sources.debian.net/src/rtmpdump/2.4+20151223.gitfa8646d.1-2/ (for browsing the source)
- https://sources.debian.net/src/rtmpdump/2.4+20151223.gitfa8646d.1-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/rtmpdump/2.4+20151223.gitfa8646d.1-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `scowl=2019.10.06-1`

Binary Packages:

- `hunspell-en-us=1:2019.10.06-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris scowl=2019.10.06-1
'http://deb.debian.org/debian/pool/main/s/scowl/scowl_2019.10.06-1.dsc' scowl_2019.10.06-1.dsc 2935 SHA256:b6bbb8dd84f37ef67ea807300fea135b000dc34826e81e3de6ea7ac0724c8d00
'http://deb.debian.org/debian/pool/main/s/scowl/scowl_2019.10.06.orig.tar.gz' scowl_2019.10.06.orig.tar.gz 2560603 SHA256:a885f2558cfcb91f561f7eeb1c84dcd2ff329dd9e5e39d5fee80b7cb8296a749
'http://deb.debian.org/debian/pool/main/s/scowl/scowl_2019.10.06-1.debian.tar.xz' scowl_2019.10.06-1.debian.tar.xz 16936 SHA256:ab9acad115b6437a0c2c9fbf66cee7b22a5e987b4d6428cd0d138dacff25b314
```

Other potentially useful URLs:

- https://sources.debian.net/src/scowl/2019.10.06-1/ (for browsing the source)
- https://sources.debian.net/src/scowl/2019.10.06-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/scowl/2019.10.06-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `sed=4.7-1`

Binary Packages:

- `sed=4.7-1`

Licenses: (parsed from: `/usr/share/doc/sed/copyright`)

- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris sed=4.7-1
'http://deb.debian.org/debian/pool/main/s/sed/sed_4.7-1.dsc' sed_4.7-1.dsc 1880 SHA256:dd0e8daed987929920f7729771f9c7a5b48d094923aaf686efd2ab19db776108
'http://deb.debian.org/debian/pool/main/s/sed/sed_4.7.orig.tar.xz' sed_4.7.orig.tar.xz 1298316 SHA256:2885768cd0a29ff8d58a6280a270ff161f6a3deb5690b2be6c49f46d4c67bd6a
'http://deb.debian.org/debian/pool/main/s/sed/sed_4.7-1.debian.tar.xz' sed_4.7-1.debian.tar.xz 59824 SHA256:a2ab8d50807fd2242f86d6c6257399e790445ab6f8932f7f487d34361b4fc483
```

Other potentially useful URLs:

- https://sources.debian.net/src/sed/4.7-1/ (for browsing the source)
- https://sources.debian.net/src/sed/4.7-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/sed/4.7-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `sensible-utils=0.0.14`

Binary Packages:

- `sensible-utils=0.0.14`

Licenses: (parsed from: `/usr/share/doc/sensible-utils/copyright`)

- `All-permissive`
- `GPL-2`
- `GPL-2+`
- `configure`
- `installsh`

Source:

```console
$ apt-get source -qq --print-uris sensible-utils=0.0.14
'http://deb.debian.org/debian/pool/main/s/sensible-utils/sensible-utils_0.0.14.dsc' sensible-utils_0.0.14.dsc 1702 SHA256:002f637ca92db8bab28048cbab10d6509508508806e2005f4dc6ba3ca505a6d8
'http://deb.debian.org/debian/pool/main/s/sensible-utils/sensible-utils_0.0.14.tar.xz' sensible-utils_0.0.14.tar.xz 64448 SHA256:a6ee528bf4122d77acacdb97f20cd0434a12ad3ecd119186a5fcee066844c644
```

Other potentially useful URLs:

- https://sources.debian.net/src/sensible-utils/0.0.14/ (for browsing the source)
- https://sources.debian.net/src/sensible-utils/0.0.14/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/sensible-utils/0.0.14/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `serf=1.3.9-10`

Binary Packages:

- `libserf-1-1:amd64=1.3.9-10`

Licenses: (parsed from: `/usr/share/doc/libserf-1-1/copyright`)

- `Apache`
- `Apache-2.0`
- `Zlib`

**WARNING:** unable to find source (`apt-get source` failed or returned no results)!  
This is *usually* due to a new package version being released and the old version being removed.

The source package *may* still be available for download from:

- http://snapshot.debian.org/package/serf/1.3.9-10/


### `dpkg` source package: `shadow=1:4.8.1-1`

Binary Packages:

- `login=1:4.8.1-1`
- `passwd=1:4.8.1-1`

Licenses: (parsed from: `/usr/share/doc/login/copyright`, `/usr/share/doc/passwd/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris shadow=1:4.8.1-1
'http://deb.debian.org/debian/pool/main/s/shadow/shadow_4.8.1-1.dsc' shadow_4.8.1-1.dsc 2215 SHA256:5c9568dc183781ba654b7daeba6d5d6768d4e0417cc8d8b6f2e534dae6fcdaa6
'http://deb.debian.org/debian/pool/main/s/shadow/shadow_4.8.1.orig.tar.xz' shadow_4.8.1.orig.tar.xz 1611196 SHA256:a3ad4630bdc41372f02a647278a8c3514844295d36eefe68ece6c3a641c1ae62
'http://deb.debian.org/debian/pool/main/s/shadow/shadow_4.8.1-1.debian.tar.xz' shadow_4.8.1-1.debian.tar.xz 74752 SHA256:fdbccadc28fcca744f365e0529f3828d0c82bc3513b28976dca7308b40ea4773
```

Other potentially useful URLs:

- https://sources.debian.net/src/shadow/1:4.8.1-1/ (for browsing the source)
- https://sources.debian.net/src/shadow/1:4.8.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/shadow/1:4.8.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `shared-mime-info=2.0-1`

Binary Packages:

- `shared-mime-info=2.0-1`

Licenses: (parsed from: `/usr/share/doc/shared-mime-info/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris shared-mime-info=2.0-1
'http://deb.debian.org/debian/pool/main/s/shared-mime-info/shared-mime-info_2.0-1.dsc' shared-mime-info_2.0-1.dsc 2223 SHA256:59f5546a13eff9c7bf8986abf0752f463a4e513a078cc442884629799c6997c0
'http://deb.debian.org/debian/pool/main/s/shared-mime-info/shared-mime-info_2.0.orig.tar.xz' shared-mime-info_2.0.orig.tar.xz 5015272 SHA256:23c1cb7919f31cf97aeb5225548f75705f706aa5cc7d1c4c503364bcc8681e06
'http://deb.debian.org/debian/pool/main/s/shared-mime-info/shared-mime-info_2.0-1.debian.tar.xz' shared-mime-info_2.0-1.debian.tar.xz 10612 SHA256:3dcdd64cde8d65907230e4f8ae73734775bef987bae0dbcb86c458d551e6c622
```

Other potentially useful URLs:

- https://sources.debian.net/src/shared-mime-info/2.0-1/ (for browsing the source)
- https://sources.debian.net/src/shared-mime-info/2.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/shared-mime-info/2.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `slang2=2.3.2-5`

Binary Packages:

- `libslang2:amd64=2.3.2-5`

Licenses: (parsed from: `/usr/share/doc/libslang2/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris slang2=2.3.2-5
'http://deb.debian.org/debian/pool/main/s/slang2/slang2_2.3.2-5.dsc' slang2_2.3.2-5.dsc 2300 SHA256:770066b3c3ecbfd1a755319a271f3fe05878fe4e16d14d3e41cd02b999f6956e
'http://deb.debian.org/debian/pool/main/s/slang2/slang2_2.3.2.orig.tar.xz' slang2_2.3.2.orig.tar.xz 1309848 SHA256:18c99f4c5ad9710eb0fcd4c82f7c32427f94c9c93a5ba04a88318e521db2cadf
'http://deb.debian.org/debian/pool/main/s/slang2/slang2_2.3.2-5.debian.tar.xz' slang2_2.3.2-5.debian.tar.xz 22100 SHA256:3da6df3f5b9050679b9977655c0cc43f06a07467527357aec62aac26c81cd15a
```

Other potentially useful URLs:

- https://sources.debian.net/src/slang2/2.3.2-5/ (for browsing the source)
- https://sources.debian.net/src/slang2/2.3.2-5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/slang2/2.3.2-5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `speex=1.2~rc1.2-1.1`

Binary Packages:

- `libspeex1:amd64=1.2~rc1.2-1.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris speex=1.2~rc1.2-1.1
'http://deb.debian.org/debian/pool/main/s/speex/speex_1.2%7erc1.2-1.1.dsc' speex_1.2~rc1.2-1.1.dsc 2186 SHA256:7de99b3cb80241fe648390f63105efed70447ac2a93a468fee26a5569792a284
'http://deb.debian.org/debian/pool/main/s/speex/speex_1.2%7erc1.2.orig.tar.gz' speex_1.2~rc1.2.orig.tar.gz 1069339 SHA256:8320fb86a024dfe1b6a78a7d57bc2388e5f8cb7f2fa10c946db2704e1e5d2805
'http://deb.debian.org/debian/pool/main/s/speex/speex_1.2%7erc1.2-1.1.diff.gz' speex_1.2~rc1.2-1.1.diff.gz 9898 SHA256:d5620bf95ced7cb3fdc80a88e36c42a456062c2293c8fa377236ea8b74dd0f58
```

Other potentially useful URLs:

- https://sources.debian.net/src/speex/1.2~rc1.2-1.1/ (for browsing the source)
- https://sources.debian.net/src/speex/1.2~rc1.2-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/speex/1.2~rc1.2-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `sqlite3=3.34.1-3+deb11u1`

Binary Packages:

- `libsqlite3-0:amd64=3.34.1-3+deb11u1`
- `libsqlite3-dev:amd64=3.34.1-3+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libsqlite3-0/copyright`, `/usr/share/doc/libsqlite3-dev/copyright`)

- `GPL-2`
- `GPL-2+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris sqlite3=3.34.1-3+deb11u1
'http://deb.debian.org/debian-security/pool/updates/main/s/sqlite3/sqlite3_3.34.1-3%2bdeb11u1.dsc' sqlite3_3.34.1-3+deb11u1.dsc 2442 SHA256:e1e3a81f4734ee81063f0aae38f405ad874b8080778386402eb95e385d877b23
'http://deb.debian.org/debian-security/pool/updates/main/s/sqlite3/sqlite3_3.34.1.orig-www.tar.xz' sqlite3_3.34.1.orig-www.tar.xz 5581512 SHA256:c63647f3fb6c4b0620d6587e2a744021401df92c307b55e236a7eb28c5000fa7
'http://deb.debian.org/debian-security/pool/updates/main/s/sqlite3/sqlite3_3.34.1.orig.tar.xz' sqlite3_3.34.1.orig.tar.xz 7343284 SHA256:082f583440c662cb484ae1c124ffe285b587bbb7837e095e693026e6df50334d
'http://deb.debian.org/debian-security/pool/updates/main/s/sqlite3/sqlite3_3.34.1-3%2bdeb11u1.debian.tar.xz' sqlite3_3.34.1-3+deb11u1.debian.tar.xz 24196 SHA256:51498b4e13d90fc26ad290fe41e8f83cb7e792900e354fddd6941a684c0d983a
```

Other potentially useful URLs:

- https://sources.debian.net/src/sqlite3/3.34.1-3+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/sqlite3/3.34.1-3+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/sqlite3/3.34.1-3+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `subversion=1.14.1-3+deb11u1`

Binary Packages:

- `libsvn1:amd64=1.14.1-3+deb11u1`
- `subversion=1.14.1-3+deb11u1`

Licenses: (parsed from: `/usr/share/doc/libsvn1/copyright`, `/usr/share/doc/subversion/copyright`)

- `AFL-3`
- `Apache-2.0`
- `BSD-2-clause`
- `BSD-3-clause`
- `BoostAcMacros`
- `Expat`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `Svnwrap`
- `Unicode`
- `Utfwidth`

Source:

```console
$ apt-get source -qq --print-uris subversion=1.14.1-3+deb11u1
'http://deb.debian.org/debian/pool/main/s/subversion/subversion_1.14.1-3%2bdeb11u1.dsc' subversion_1.14.1-3+deb11u1.dsc 3712 SHA256:23a03b5d6da70e29e1b549c52bce92956083e1c75f44ffc15a88b79f7c65aa8e
'http://deb.debian.org/debian/pool/main/s/subversion/subversion_1.14.1.orig.tar.gz' subversion_1.14.1.orig.tar.gz 11534165 SHA256:dee2796abaa1f5351e6cc2a60b1917beb8238af548b20d3e1ec22760ab2f0cad
'http://deb.debian.org/debian/pool/main/s/subversion/subversion_1.14.1.orig.tar.gz.asc' subversion_1.14.1.orig.tar.gz.asc 1288 SHA256:4dafc04642e634f3b75d70d3d707ba8eacc63a4925026402afcb94566f445fa6
'http://deb.debian.org/debian/pool/main/s/subversion/subversion_1.14.1-3%2bdeb11u1.debian.tar.xz' subversion_1.14.1-3+deb11u1.debian.tar.xz 432388 SHA256:eac5960a4eb15b67e421612fcb75bcdb4d2fd633609bbf68435afef3204a2d7c
```

Other potentially useful URLs:

- https://sources.debian.net/src/subversion/1.14.1-3+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/subversion/1.14.1-3+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/subversion/1.14.1-3+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `systemd=247.3-7+deb11u6`

Binary Packages:

- `libpam-systemd:amd64=247.3-7+deb11u6`
- `libsystemd0:amd64=247.3-7+deb11u6`
- `libudev1:amd64=247.3-7+deb11u6`
- `systemd=247.3-7+deb11u6`
- `systemd-sysv=247.3-7+deb11u6`

Licenses: (parsed from: `/usr/share/doc/libpam-systemd/copyright`, `/usr/share/doc/libsystemd0/copyright`, `/usr/share/doc/libudev1/copyright`, `/usr/share/doc/systemd/copyright`, `/usr/share/doc/systemd-sysv/copyright`)

- `CC0-1.0`
- `Expat`
- `GPL-2`
- `GPL-2 with Linux-syscall-note exception`
- `GPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris systemd=247.3-7+deb11u6
'http://deb.debian.org/debian-security/pool/updates/main/s/systemd/systemd_247.3-7%2bdeb11u6.dsc' systemd_247.3-7+deb11u6.dsc 5199 SHA256:2a42912fd6641d80851ecba3231fa912e1ae73b684c89d39ab54ef454b2bf5a9
'http://deb.debian.org/debian-security/pool/updates/main/s/systemd/systemd_247.3.orig.tar.gz' systemd_247.3.orig.tar.gz 9895385 SHA256:2869986e219a8dfc96cc0dffac66e0c13bb70a89e16b85a3948876c146cfa3e0
'http://deb.debian.org/debian-security/pool/updates/main/s/systemd/systemd_247.3-7%2bdeb11u6.debian.tar.xz' systemd_247.3-7+deb11u6.debian.tar.xz 200308 SHA256:c9de4ff5649076c430ae1eb655b5d3ccd74a295431ca8fcf416e91b453fa37f9
```

Other potentially useful URLs:

- https://sources.debian.net/src/systemd/247.3-7+deb11u6/ (for browsing the source)
- https://sources.debian.net/src/systemd/247.3-7+deb11u6/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/systemd/247.3-7+deb11u6/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `sysvinit=2.96-7+deb11u1`

Binary Packages:

- `sysvinit-utils=2.96-7+deb11u1`

Licenses: (parsed from: `/usr/share/doc/sysvinit-utils/copyright`)

- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris sysvinit=2.96-7+deb11u1
'http://deb.debian.org/debian/pool/main/s/sysvinit/sysvinit_2.96-7%2bdeb11u1.dsc' sysvinit_2.96-7+deb11u1.dsc 2374 SHA256:1ef8a8b224aabecbd27ebef68b389bc3149970ef348877cec3ac7351a04c13a7
'http://deb.debian.org/debian/pool/main/s/sysvinit/sysvinit_2.96.orig.tar.gz' sysvinit_2.96.orig.tar.gz 147834 SHA256:1275620f767c85bb2d7e5b9542579ae097f3eb542065ff30a70efc95b6e84c64
'http://deb.debian.org/debian/pool/main/s/sysvinit/sysvinit_2.96-7%2bdeb11u1.debian.tar.xz' sysvinit_2.96-7+deb11u1.debian.tar.xz 129936 SHA256:5ce9a0b9735a66c536c77c65e17d4190338e0c0416ba235c26c9cf12d3cfbeb3
```

Other potentially useful URLs:

- https://sources.debian.net/src/sysvinit/2.96-7+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/sysvinit/2.96-7+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/sysvinit/2.96-7+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `taglib=1.11.1+dfsg.1-3`

Binary Packages:

- `libtag1v5:amd64=1.11.1+dfsg.1-3`
- `libtag1v5-vanilla:amd64=1.11.1+dfsg.1-3`

Licenses: (parsed from: `/usr/share/doc/libtag1v5/copyright`, `/usr/share/doc/libtag1v5-vanilla/copyright`)

- `BSD-2-clause`
- `LGPL-2.1`
- `MPL-1.1`

Source:

```console
$ apt-get source -qq --print-uris taglib=1.11.1+dfsg.1-3
'http://deb.debian.org/debian/pool/main/t/taglib/taglib_1.11.1%2bdfsg.1-3.dsc' taglib_1.11.1+dfsg.1-3.dsc 2354 SHA256:55429338baa3a52418dd55578ec601005fd605497b092b325673836565808603
'http://deb.debian.org/debian/pool/main/t/taglib/taglib_1.11.1%2bdfsg.1.orig.tar.xz' taglib_1.11.1+dfsg.1.orig.tar.xz 868744 SHA256:5bceb7940edf5a0674f0892e5788b119f278c5c246f3f2cf979b27faa70063c8
'http://deb.debian.org/debian/pool/main/t/taglib/taglib_1.11.1%2bdfsg.1-3.debian.tar.xz' taglib_1.11.1+dfsg.1-3.debian.tar.xz 35276 SHA256:eb24ae276e8476da3bfb3adb341397aa49d0e0ea49e10178b6679d01460276df
```

Other potentially useful URLs:

- https://sources.debian.net/src/taglib/1.11.1+dfsg.1-3/ (for browsing the source)
- https://sources.debian.net/src/taglib/1.11.1+dfsg.1-3/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/taglib/1.11.1+dfsg.1-3/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `tar=1.34+dfsg-1+deb11u1`

Binary Packages:

- `tar=1.34+dfsg-1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/tar/copyright`)

- `GPL-2`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris tar=1.34+dfsg-1+deb11u1
'http://deb.debian.org/debian/pool/main/t/tar/tar_1.34%2bdfsg-1%2bdeb11u1.dsc' tar_1.34+dfsg-1+deb11u1.dsc 2177 SHA256:9df5361d93936b77e7a51383ed369ad709cb12c6a4615ce9252360fb431804bc
'http://deb.debian.org/debian/pool/main/t/tar/tar_1.34%2bdfsg.orig.tar.xz' tar_1.34+dfsg.orig.tar.xz 1981736 SHA256:7d57029540cb928394defb3b377b3531237c947e795b51aa8acac0c5ba0e4844
'http://deb.debian.org/debian/pool/main/t/tar/tar_1.34%2bdfsg-1%2bdeb11u1.debian.tar.xz' tar_1.34+dfsg-1+deb11u1.debian.tar.xz 20276 SHA256:61ff8974dadd7dba4e6a09e6db193a77f0a0a17b681b4d188d4f1569bcf48449
```

Other potentially useful URLs:

- https://sources.debian.net/src/tar/1.34+dfsg-1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/tar/1.34+dfsg-1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/tar/1.34+dfsg-1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `tcp-wrappers=7.6.q-31`

Binary Packages:

- `libwrap0:amd64=7.6.q-31`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris tcp-wrappers=7.6.q-31
'http://deb.debian.org/debian/pool/main/t/tcp-wrappers/tcp-wrappers_7.6.q-31.dsc' tcp-wrappers_7.6.q-31.dsc 1331 SHA256:c4e21be3af225a34c2494c6e738cda55eabc5724b7e89b24a7de491f9268add8
'http://deb.debian.org/debian/pool/main/t/tcp-wrappers/tcp-wrappers_7.6.q.orig.tar.gz' tcp-wrappers_7.6.q.orig.tar.gz 99438 SHA256:9543d7adedf78a6de0b221ccbbd1952e08b5138717f4ade814039bb489a4315d
'http://deb.debian.org/debian/pool/main/t/tcp-wrappers/tcp-wrappers_7.6.q-31.debian.tar.xz' tcp-wrappers_7.6.q-31.debian.tar.xz 36256 SHA256:20fec7826bde1262007e6dd43f365b5802bacc283942d93b78385ea634dc594a
```

Other potentially useful URLs:

- https://sources.debian.net/src/tcp-wrappers/7.6.q-31/ (for browsing the source)
- https://sources.debian.net/src/tcp-wrappers/7.6.q-31/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/tcp-wrappers/7.6.q-31/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `tiff=4.2.0-1+deb11u5`

Binary Packages:

- `libtiff-dev:amd64=4.2.0-1+deb11u5`
- `libtiff5:amd64=4.2.0-1+deb11u5`
- `libtiffxx5:amd64=4.2.0-1+deb11u5`

Licenses: (parsed from: `/usr/share/doc/libtiff-dev/copyright`, `/usr/share/doc/libtiff5/copyright`, `/usr/share/doc/libtiffxx5/copyright`)

- `Hylafax`

Source:

```console
$ apt-get source -qq --print-uris tiff=4.2.0-1+deb11u5
'http://deb.debian.org/debian/pool/main/t/tiff/tiff_4.2.0-1%2bdeb11u5.dsc' tiff_4.2.0-1+deb11u5.dsc 2116 SHA256:eeb72e3449968ab5d39fdf7f999b787580837fcf7751f30e16750659919fd3d4
'http://deb.debian.org/debian/pool/main/t/tiff/tiff_4.2.0.orig.tar.gz' tiff_4.2.0.orig.tar.gz 2809373 SHA256:eb0484e568ead8fa23b513e9b0041df7e327f4ee2d22db5a533929dfc19633cb
'http://deb.debian.org/debian/pool/main/t/tiff/tiff_4.2.0.orig.tar.gz.asc' tiff_4.2.0.orig.tar.gz.asc 228 SHA256:119bb62934603ff4d3cd81c739d11904b28812a860773b9b2268cc96a339b14f
'http://deb.debian.org/debian/pool/main/t/tiff/tiff_4.2.0-1%2bdeb11u5.debian.tar.xz' tiff_4.2.0-1+deb11u5.debian.tar.xz 41268 SHA256:472770be431abb4f9fdaf2f0e2306b8980a47b1a55a3c10a2224f2c8833fa6a0
```

Other potentially useful URLs:

- https://sources.debian.net/src/tiff/4.2.0-1+deb11u5/ (for browsing the source)
- https://sources.debian.net/src/tiff/4.2.0-1+deb11u5/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/tiff/4.2.0-1+deb11u5/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `twolame=0.4.0-2`

Binary Packages:

- `libtwolame0:amd64=0.4.0-2`

Licenses: (parsed from: `/usr/share/doc/libtwolame0/copyright`)

- `LGPL-2`
- `LGPL-2+`

Source:

```console
$ apt-get source -qq --print-uris twolame=0.4.0-2
'http://deb.debian.org/debian/pool/main/t/twolame/twolame_0.4.0-2.dsc' twolame_0.4.0-2.dsc 2048 SHA256:b5e662bbb076be28d1de5004ba6325b2df340eb7812d5071ba9d7f5d64faf7cc
'http://deb.debian.org/debian/pool/main/t/twolame/twolame_0.4.0.orig.tar.gz' twolame_0.4.0.orig.tar.gz 890908 SHA256:cc35424f6019a88c6f52570b63e1baf50f62963a3eac52a03a800bb070d7c87d
'http://deb.debian.org/debian/pool/main/t/twolame/twolame_0.4.0-2.debian.tar.xz' twolame_0.4.0-2.debian.tar.xz 4740 SHA256:c11737831db6c13b0346b5d23d39ab40235ad09373d57356dd8b23263499d67a
```

Other potentially useful URLs:

- https://sources.debian.net/src/twolame/0.4.0-2/ (for browsing the source)
- https://sources.debian.net/src/twolame/0.4.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/twolame/0.4.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `tzdata=2024a-0+deb11u1`

Binary Packages:

- `tzdata=2024a-0+deb11u1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris tzdata=2024a-0+deb11u1
'http://deb.debian.org/debian/pool/main/t/tzdata/tzdata_2024a-0%2bdeb11u1.dsc' tzdata_2024a-0+deb11u1.dsc 2269 SHA256:63dcd00127b57f0fbb804f234430bac966be622b774d45f69eab21a35e596025
'http://deb.debian.org/debian/pool/main/t/tzdata/tzdata_2024a.orig.tar.gz' tzdata_2024a.orig.tar.gz 451270 SHA256:0d0434459acbd2059a7a8da1f3304a84a86591f6ed69c6248fffa502b6edffe3
'http://deb.debian.org/debian/pool/main/t/tzdata/tzdata_2024a.orig.tar.gz.asc' tzdata_2024a.orig.tar.gz.asc 833 SHA256:f64725f9f65419e7b009e3b95b75ea9516382d0be64aef63d78654d9c569ed0d
'http://deb.debian.org/debian/pool/main/t/tzdata/tzdata_2024a-0%2bdeb11u1.debian.tar.xz' tzdata_2024a-0+deb11u1.debian.tar.xz 106548 SHA256:0455dfbbee01c416518d73de11d14835afebd1ca32cfe6cea7b3ed74f0f20afc
```

Other potentially useful URLs:

- https://sources.debian.net/src/tzdata/2024a-0+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/tzdata/2024a-0+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/tzdata/2024a-0+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `ucf=3.0043`

Binary Packages:

- `ucf=3.0043`

Licenses: (parsed from: `/usr/share/doc/ucf/copyright`)

- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris ucf=3.0043
'http://deb.debian.org/debian/pool/main/u/ucf/ucf_3.0043.dsc' ucf_3.0043.dsc 1423 SHA256:5954508238ff1b8e2c61e1f533268911ba06709e821c02de014fd15d2ead81fd
'http://deb.debian.org/debian/pool/main/u/ucf/ucf_3.0043.tar.xz' ucf_3.0043.tar.xz 70560 SHA256:0294cc11a6cf032ea99ca5064f73a4ede5b28bc2d4ad0a12e8493c7520c7a2a4
```

Other potentially useful URLs:

- https://sources.debian.net/src/ucf/3.0043/ (for browsing the source)
- https://sources.debian.net/src/ucf/3.0043/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/ucf/3.0043/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `unixodbc=2.3.6-0.1`

Binary Packages:

- `libodbc1:amd64=2.3.6-0.1+b1`

Licenses: (parsed from: `/usr/share/doc/libodbc1/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris unixodbc=2.3.6-0.1
'http://deb.debian.org/debian/pool/main/u/unixodbc/unixodbc_2.3.6-0.1.dsc' unixodbc_2.3.6-0.1.dsc 2002 SHA256:fd2eab8f404d0fff154ded1c7b3608ee2f3a7016a2459ee9a72415018c03423c
'http://deb.debian.org/debian/pool/main/u/unixodbc/unixodbc_2.3.6.orig.tar.gz' unixodbc_2.3.6.orig.tar.gz 2083106 SHA256:c7a1327a756653088f1f2c8566cd25689703eeb904728d1d971c9b31ed1a94db
'http://deb.debian.org/debian/pool/main/u/unixodbc/unixodbc_2.3.6-0.1.debian.tar.xz' unixodbc_2.3.6-0.1.debian.tar.xz 17932 SHA256:eb191a58b750e7ab3a8f0eca353fc90c4f82cdfefd99988623947b4120eda3e5
```

Other potentially useful URLs:

- https://sources.debian.net/src/unixodbc/2.3.6-0.1/ (for browsing the source)
- https://sources.debian.net/src/unixodbc/2.3.6-0.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/unixodbc/2.3.6-0.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `unzip=6.0-26+deb11u1`

Binary Packages:

- `unzip=6.0-26+deb11u1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris unzip=6.0-26+deb11u1
'http://deb.debian.org/debian/pool/main/u/unzip/unzip_6.0-26%2bdeb11u1.dsc' unzip_6.0-26+deb11u1.dsc 1383 SHA256:44f7e29339e16ea91cffc121927ca6a36ce89230fbb1c31c4526ac6cbaa0df8c
'http://deb.debian.org/debian/pool/main/u/unzip/unzip_6.0.orig.tar.gz' unzip_6.0.orig.tar.gz 1376845 SHA256:036d96991646d0449ed0aa952e4fbe21b476ce994abc276e49d30e686708bd37
'http://deb.debian.org/debian/pool/main/u/unzip/unzip_6.0-26%2bdeb11u1.debian.tar.xz' unzip_6.0-26+deb11u1.debian.tar.xz 24996 SHA256:7f15d1a95de7d8198348da54e56c6248863f84ad2a71c6302ddc9c1448639f00
```

Other potentially useful URLs:

- https://sources.debian.net/src/unzip/6.0-26+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/unzip/6.0-26+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/unzip/6.0-26+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `utf8proc=2.5.0-1`

Binary Packages:

- `libutf8proc2:amd64=2.5.0-1`

Licenses: (parsed from: `/usr/share/doc/libutf8proc2/copyright`)

- `Expat`
- `Unicode`

Source:

```console
$ apt-get source -qq --print-uris utf8proc=2.5.0-1
'http://deb.debian.org/debian/pool/main/u/utf8proc/utf8proc_2.5.0-1.dsc' utf8proc_2.5.0-1.dsc 2154 SHA256:2137104a3712875650629305fe7d7ef37d4d99328846c18b087b289c0ddbf27c
'http://deb.debian.org/debian/pool/main/u/utf8proc/utf8proc_2.5.0.orig.tar.gz' utf8proc_2.5.0.orig.tar.gz 155485 SHA256:d4e8dfc898cfd062493cb7f42d95d70ccdd3a4cd4d90bec0c71b47cca688f1be
'http://deb.debian.org/debian/pool/main/u/utf8proc/utf8proc_2.5.0-1.debian.tar.xz' utf8proc_2.5.0-1.debian.tar.xz 5240 SHA256:333496cf4e178b5ccf4972fa52523d07a21a0cabf0cb123133c6c71f98e92eff
```

Other potentially useful URLs:

- https://sources.debian.net/src/utf8proc/2.5.0-1/ (for browsing the source)
- https://sources.debian.net/src/utf8proc/2.5.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/utf8proc/2.5.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `util-linux=2.36.1-8+deb11u2`

Binary Packages:

- `bsdutils=1:2.36.1-8+deb11u2`
- `libblkid-dev:amd64=2.36.1-8+deb11u2`
- `libblkid1:amd64=2.36.1-8+deb11u2`
- `libmount-dev:amd64=2.36.1-8+deb11u2`
- `libmount1:amd64=2.36.1-8+deb11u2`
- `libsmartcols1:amd64=2.36.1-8+deb11u2`
- `libuuid1:amd64=2.36.1-8+deb11u2`
- `mount=2.36.1-8+deb11u2`
- `util-linux=2.36.1-8+deb11u2`
- `uuid-dev:amd64=2.36.1-8+deb11u2`

Licenses: (parsed from: `/usr/share/doc/bsdutils/copyright`, `/usr/share/doc/libblkid-dev/copyright`, `/usr/share/doc/libblkid1/copyright`, `/usr/share/doc/libmount-dev/copyright`, `/usr/share/doc/libmount1/copyright`, `/usr/share/doc/libsmartcols1/copyright`, `/usr/share/doc/libuuid1/copyright`, `/usr/share/doc/mount/copyright`, `/usr/share/doc/util-linux/copyright`, `/usr/share/doc/uuid-dev/copyright`)

- `BSD-2-clause`
- `BSD-3-clause`
- `BSD-4-clause`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `GPL-3+`
- `LGPL`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `LGPL-3`
- `LGPL-3+`
- `MIT`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris util-linux=2.36.1-8+deb11u2
'http://deb.debian.org/debian/pool/main/u/util-linux/util-linux_2.36.1-8%2bdeb11u2.dsc' util-linux_2.36.1-8+deb11u2.dsc 4306 SHA256:16cfb1bc4d0a52f5edf2c78b5e022bb1fc180f03b93a5094b5c420a0d8d4431a
'http://deb.debian.org/debian/pool/main/u/util-linux/util-linux_2.36.1.orig.tar.xz' util-linux_2.36.1.orig.tar.xz 5231880 SHA256:09fac242172cd8ec27f0739d8d192402c69417617091d8c6e974841568f37eed
'http://deb.debian.org/debian/pool/main/u/util-linux/util-linux_2.36.1-8%2bdeb11u2.debian.tar.xz' util-linux_2.36.1-8+deb11u2.debian.tar.xz 106524 SHA256:0b07fbb79e1dab3be2568295664af950a7c3e589ce7821febf2ab0a3ccbe4862
```

Other potentially useful URLs:

- https://sources.debian.net/src/util-linux/2.36.1-8+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/util-linux/2.36.1-8+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/util-linux/2.36.1-8+deb11u2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `v4l-utils=1.20.0-2`

Binary Packages:

- `libv4l-0:amd64=1.20.0-2`
- `libv4lconvert0:amd64=1.20.0-2`

Licenses: (parsed from: `/usr/share/doc/libv4l-0/copyright`, `/usr/share/doc/libv4lconvert0/copyright`)

- `GPL-2`
- `GPL-2+`
- `LGPL`
- `LGPL-2+`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris v4l-utils=1.20.0-2
'http://deb.debian.org/debian/pool/main/v/v4l-utils/v4l-utils_1.20.0-2.dsc' v4l-utils_1.20.0-2.dsc 3129 SHA256:fd1ceb413f5db584449938a75bf0426503c6f631b74fda8e1ca0464dd4aceb6e
'http://deb.debian.org/debian/pool/main/v/v4l-utils/v4l-utils_1.20.0.orig.tar.bz2' v4l-utils_1.20.0.orig.tar.bz2 2030419 SHA256:956118713f7ccb405c55c7088a6a2490c32d54300dd9a30d8d5008c28d3726f7
'http://deb.debian.org/debian/pool/main/v/v4l-utils/v4l-utils_1.20.0.orig.tar.bz2.asc' v4l-utils_1.20.0.orig.tar.bz2.asc 833 SHA256:bbf5feebfce4bf1c21a9f00f2a0531cd5147533088e4f73a4160739c46f11316
'http://deb.debian.org/debian/pool/main/v/v4l-utils/v4l-utils_1.20.0-2.debian.tar.xz' v4l-utils_1.20.0-2.debian.tar.xz 19488 SHA256:5caa403208bccc555e01dec417576b07cf46cfa3483f5d9b0b215fa6353469c3
```

Other potentially useful URLs:

- https://sources.debian.net/src/v4l-utils/1.20.0-2/ (for browsing the source)
- https://sources.debian.net/src/v4l-utils/1.20.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/v4l-utils/1.20.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `vulkan-loader=1.2.162.0-1`

Binary Packages:

- `libvulkan1:amd64=1.2.162.0-1`

Licenses: (parsed from: `/usr/share/doc/libvulkan1/copyright`)

- `Apache-2.0`
- `MIT`

Source:

```console
$ apt-get source -qq --print-uris vulkan-loader=1.2.162.0-1
'http://deb.debian.org/debian/pool/main/v/vulkan-loader/vulkan-loader_1.2.162.0-1.dsc' vulkan-loader_1.2.162.0-1.dsc 2252 SHA256:8191b86693dcb008f01d66bffae19f5b3a69b820ca8d12eb6d2f776e660cdf62
'http://deb.debian.org/debian/pool/main/v/vulkan-loader/vulkan-loader_1.2.162.0.orig.tar.xz' vulkan-loader_1.2.162.0.orig.tar.xz 1848156 SHA256:644384d43aa1e7b39123ed777bb6cba495e9eeed8854308d8f577e351647d91e
'http://deb.debian.org/debian/pool/main/v/vulkan-loader/vulkan-loader_1.2.162.0-1.debian.tar.xz' vulkan-loader_1.2.162.0-1.debian.tar.xz 8400 SHA256:5ab183fe677d1ae44c58e1e86a5edcce13785ee5600792c958f4351ca9de499a
```

Other potentially useful URLs:

- https://sources.debian.net/src/vulkan-loader/1.2.162.0-1/ (for browsing the source)
- https://sources.debian.net/src/vulkan-loader/1.2.162.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/vulkan-loader/1.2.162.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `wavpack=5.4.0-1`

Binary Packages:

- `libwavpack1:amd64=5.4.0-1`

Licenses: (parsed from: `/usr/share/doc/libwavpack1/copyright`)

- `BSD-2-clause`
- `BSD-3-clause`
- `public-domain`

Source:

```console
$ apt-get source -qq --print-uris wavpack=5.4.0-1
'http://deb.debian.org/debian/pool/main/w/wavpack/wavpack_5.4.0-1.dsc' wavpack_5.4.0-1.dsc 2059 SHA256:71b44908b6012865f079c443c4b80f28d115461d7368ab663637c5845292b85b
'http://deb.debian.org/debian/pool/main/w/wavpack/wavpack_5.4.0.orig.tar.bz2' wavpack_5.4.0.orig.tar.bz2 863429 SHA256:0716a6dcf9a72d61005e1b09bbbd61aaf49837cb4e4a351992a6daed16cac034
'http://deb.debian.org/debian/pool/main/w/wavpack/wavpack_5.4.0-1.debian.tar.xz' wavpack_5.4.0-1.debian.tar.xz 6468 SHA256:c19abfa6f3bec2980777c80c46844ad3fc30b94001a5e6b69bf8289819002b4f
```

Other potentially useful URLs:

- https://sources.debian.net/src/wavpack/5.4.0-1/ (for browsing the source)
- https://sources.debian.net/src/wavpack/5.4.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/wavpack/5.4.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `wayland=1.18.0-2~exp1.1`

Binary Packages:

- `libwayland-client0:amd64=1.18.0-2~exp1.1`
- `libwayland-cursor0:amd64=1.18.0-2~exp1.1`
- `libwayland-egl1:amd64=1.18.0-2~exp1.1`
- `libwayland-server0:amd64=1.18.0-2~exp1.1`

Licenses: (parsed from: `/usr/share/doc/libwayland-client0/copyright`, `/usr/share/doc/libwayland-cursor0/copyright`, `/usr/share/doc/libwayland-egl1/copyright`, `/usr/share/doc/libwayland-server0/copyright`)

- `X11`

Source:

```console
$ apt-get source -qq --print-uris wayland=1.18.0-2~exp1.1
'http://deb.debian.org/debian/pool/main/w/wayland/wayland_1.18.0-2%7eexp1.1.dsc' wayland_1.18.0-2~exp1.1.dsc 2629 SHA256:72ade67239aee78630cf2c400b3fc2d4572462d5c5ea3688b2bed743cf8f672c
'http://deb.debian.org/debian/pool/main/w/wayland/wayland_1.18.0.orig.tar.gz' wayland_1.18.0.orig.tar.gz 736301 SHA256:102d5556db1524a7737ab76e358b03e5b92a7718f1ac1520bf9686bfd09c8e4a
'http://deb.debian.org/debian/pool/main/w/wayland/wayland_1.18.0-2%7eexp1.1.diff.gz' wayland_1.18.0-2~exp1.1.diff.gz 16884 SHA256:ad94e458a70fdd5bb39f71648708640b69e12f24b93cb8480086df37fb0b5462
```

Other potentially useful URLs:

- https://sources.debian.net/src/wayland/1.18.0-2~exp1.1/ (for browsing the source)
- https://sources.debian.net/src/wayland/1.18.0-2~exp1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/wayland/1.18.0-2~exp1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `webkit2gtk=2.44.3-1~deb11u1`

Binary Packages:

- `libjavascriptcoregtk-4.0-18:amd64=2.44.3-1~deb11u1`
- `libwebkit2gtk-4.0-37:amd64=2.44.3-1~deb11u1`

Licenses: (parsed from: `/usr/share/doc/libjavascriptcoregtk-4.0-18/copyright`, `/usr/share/doc/libwebkit2gtk-4.0-37/copyright`)

- `AFL-2.0`
- `Apache-2.0`
- `BSD-2-clause`
- `BSD-3-clause-adam-barth`
- `BSD-3-clause-apple`
- `BSD-3-clause-canon`
- `BSD-3-clause-code-aurora`
- `BSD-3-clause-copyright-holder`
- `BSD-3-clause-ericsson`
- `BSD-3-clause-google`
- `BSD-3-clause-jochen-kalmbach`
- `BSD-3-clause-microsoft`
- `BSD-3-clause-motorola`
- `BSD-3-clause-opera`
- `BSD-4-clause-valgrind`
- `BSL-1.0`
- `Expat`
- `GPL-2`
- `GPL-2+`
- `GPL-2+ with Bison exception`
- `GPL-3`
- `GPL-3+`
- `GPL-3+ with Bison exception`
- `ISC`
- `LGPL-2`
- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`
- `MPL-1.1`
- `MPL-2.0`

Source:

```console
$ apt-get source -qq --print-uris webkit2gtk=2.44.3-1~deb11u1
'http://deb.debian.org/debian-security/pool/updates/main/w/webkit2gtk/webkit2gtk_2.44.3-1%7edeb11u1.dsc' webkit2gtk_2.44.3-1~deb11u1.dsc 4000 SHA256:ec8a5422a2deb5c247adf59c31169f745723f01e3727e27de167d7d383061753
'http://deb.debian.org/debian-security/pool/updates/main/w/webkit2gtk/webkit2gtk_2.44.3.orig.tar.xz' webkit2gtk_2.44.3.orig.tar.xz 37250176 SHA256:dc82d042ecaca981a4852357c06e5235743319cf10a94cd36ad41b97883a0b54
'http://deb.debian.org/debian-security/pool/updates/main/w/webkit2gtk/webkit2gtk_2.44.3.orig.tar.xz.asc' webkit2gtk_2.44.3.orig.tar.xz.asc 833 SHA256:b858ad6bf3c92a63da249491c120279ece5ea679f86e793e6535044cb4c0b800
'http://deb.debian.org/debian-security/pool/updates/main/w/webkit2gtk/webkit2gtk_2.44.3-1%7edeb11u1.debian.tar.xz' webkit2gtk_2.44.3-1~deb11u1.debian.tar.xz 89508 SHA256:2297adfdbc5b1ff2262a08817b6698cb4e073c791a39add898ee3a2ec428fc92
```

Other potentially useful URLs:

- https://sources.debian.net/src/webkit2gtk/2.44.3-1~deb11u1/ (for browsing the source)
- https://sources.debian.net/src/webkit2gtk/2.44.3-1~deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/webkit2gtk/2.44.3-1~deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `wget=1.21-1+deb11u1`

Binary Packages:

- `wget=1.21-1+deb11u1`

Licenses: (parsed from: `/usr/share/doc/wget/copyright`)

- `GFDL-1.2`
- `GPL-3`

Source:

```console
$ apt-get source -qq --print-uris wget=1.21-1+deb11u1
'http://deb.debian.org/debian/pool/main/w/wget/wget_1.21-1%2bdeb11u1.dsc' wget_1.21-1+deb11u1.dsc 2208 SHA256:b9b3c2b206a602f4954688dc85c2131c35ad12621405e89560e060c122f029d1
'http://deb.debian.org/debian/pool/main/w/wget/wget_1.21.orig.tar.gz' wget_1.21.orig.tar.gz 4866788 SHA256:b3bc1a9bd0c19836c9709c318d41c19c11215a07514f49f89b40b9d50ab49325
'http://deb.debian.org/debian/pool/main/w/wget/wget_1.21.orig.tar.gz.asc' wget_1.21.orig.tar.gz.asc 854 SHA256:da3a99b8a7bbaf70cc339593a9e0c2942dd673152bc7bfcf8f965ae1c06d50df
'http://deb.debian.org/debian/pool/main/w/wget/wget_1.21-1%2bdeb11u1.debian.tar.xz' wget_1.21-1+deb11u1.debian.tar.xz 60944 SHA256:cfb8edda9e0667e2fba60939674c8a4e5a14fca04c91e27ed5699b345144804e
```

Other potentially useful URLs:

- https://sources.debian.net/src/wget/1.21-1+deb11u1/ (for browsing the source)
- https://sources.debian.net/src/wget/1.21-1+deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/wget/1.21-1+deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `woff2=1.0.2-1`

Binary Packages:

- `libwoff1:amd64=1.0.2-1+b1`

Licenses: (parsed from: `/usr/share/doc/libwoff1/copyright`)

- `Expat`

Source:

```console
$ apt-get source -qq --print-uris woff2=1.0.2-1
'http://deb.debian.org/debian/pool/main/w/woff2/woff2_1.0.2-1.dsc' woff2_1.0.2-1.dsc 1981 SHA256:1e5329d34e55d5e299fcd56d672b11d6081871da49b73d951ab73bb62ed12662
'http://deb.debian.org/debian/pool/main/w/woff2/woff2_1.0.2.orig.tar.gz' woff2_1.0.2.orig.tar.gz 38934 SHA256:add272bb09e6384a4833ffca4896350fdb16e0ca22df68c0384773c67a175594
'http://deb.debian.org/debian/pool/main/w/woff2/woff2_1.0.2-1.debian.tar.xz' woff2_1.0.2-1.debian.tar.xz 3164 SHA256:f3d1a9059b762570a9c20b0ca08d36540a48e182cae13e673b606f575cbeaa7a
```

Other potentially useful URLs:

- https://sources.debian.net/src/woff2/1.0.2-1/ (for browsing the source)
- https://sources.debian.net/src/woff2/1.0.2-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/woff2/1.0.2-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `wxwidgets3.0=3.0.5.1+dfsg-2`

Binary Packages:

- `libwxbase3.0-0v5:amd64=3.0.5.1+dfsg-2`
- `libwxbase3.0-dev:amd64=3.0.5.1+dfsg-2`
- `libwxgtk-webview3.0-gtk3-0v5:amd64=3.0.5.1+dfsg-2`
- `libwxgtk3.0-gtk3-0v5:amd64=3.0.5.1+dfsg-2`
- `libwxgtk3.0-gtk3-dev:amd64=3.0.5.1+dfsg-2`
- `wx-common=3.0.5.1+dfsg-2`
- `wx3.0-headers=3.0.5.1+dfsg-2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris wxwidgets3.0=3.0.5.1+dfsg-2
'http://deb.debian.org/debian/pool/main/w/wxwidgets3.0/wxwidgets3.0_3.0.5.1%2bdfsg-2.dsc' wxwidgets3.0_3.0.5.1+dfsg-2.dsc 3239 SHA256:ee3d368ecae163780ba8ae99a2c503cb2e4e53cabb4c169a7e46dc24cad79685
'http://deb.debian.org/debian/pool/main/w/wxwidgets3.0/wxwidgets3.0_3.0.5.1%2bdfsg.orig.tar.xz' wxwidgets3.0_3.0.5.1+dfsg.orig.tar.xz 12783400 SHA256:fb9c524deff0c3ebdcb2867d565e1d3e2f22fa4ea431aa5970b4de2dd315054d
'http://deb.debian.org/debian/pool/main/w/wxwidgets3.0/wxwidgets3.0_3.0.5.1%2bdfsg-2.debian.tar.xz' wxwidgets3.0_3.0.5.1+dfsg-2.debian.tar.xz 40908 SHA256:0ce202617e19aee5e63b1d01f29206d8a0fcee6d9c088b64e0b5d0fd292a610a
```

Other potentially useful URLs:

- https://sources.debian.net/src/wxwidgets3.0/3.0.5.1+dfsg-2/ (for browsing the source)
- https://sources.debian.net/src/wxwidgets3.0/3.0.5.1+dfsg-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/wxwidgets3.0/3.0.5.1+dfsg-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `x265=3.4-2`

Binary Packages:

- `libx265-192:amd64=3.4-2`

Licenses: (parsed from: `/usr/share/doc/libx265-192/copyright`)

- `Expat`
- `GPL-2`
- `GPL-2+`
- `ISC`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris x265=3.4-2
'http://deb.debian.org/debian/pool/main/x/x265/x265_3.4-2.dsc' x265_3.4-2.dsc 2229 SHA256:23d691eb0efd6f12f059e776b99e0c03c1fb323b847858d4f2731cf7e869be3a
'http://deb.debian.org/debian/pool/main/x/x265/x265_3.4.orig.tar.gz' x265_3.4.orig.tar.gz 1469365 SHA256:c2047f23a6b729e5c70280d23223cb61b57bfe4ad4e8f1471eeee2a61d148672
'http://deb.debian.org/debian/pool/main/x/x265/x265_3.4-2.debian.tar.xz' x265_3.4-2.debian.tar.xz 13076 SHA256:34ac10ef2d9a9ad237a25101b97a61dfb228f9fbeb3fefc61a5fd22f3b488ed3
```

Other potentially useful URLs:

- https://sources.debian.net/src/x265/3.4-2/ (for browsing the source)
- https://sources.debian.net/src/x265/3.4-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/x265/3.4-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `xdg-dbus-proxy=0.1.2-2`

Binary Packages:

- `xdg-dbus-proxy=0.1.2-2`

Licenses: (parsed from: `/usr/share/doc/xdg-dbus-proxy/copyright`)

- `LGPL-2+`
- `LGPL-2.1`
- `LGPL-2.1+`

Source:

```console
$ apt-get source -qq --print-uris xdg-dbus-proxy=0.1.2-2
'http://deb.debian.org/debian/pool/main/x/xdg-dbus-proxy/xdg-dbus-proxy_0.1.2-2.dsc' xdg-dbus-proxy_0.1.2-2.dsc 2323 SHA256:022b00dd9e9aa9df9e73700b46a0bed4dcdcb1374e98681d830d81d300afbed5
'http://deb.debian.org/debian/pool/main/x/xdg-dbus-proxy/xdg-dbus-proxy_0.1.2.orig.tar.xz' xdg-dbus-proxy_0.1.2.orig.tar.xz 119264 SHA256:1749d6f9f46dcc9edc87725641cf56cf91dcad1b01707891ea0850c1000c520f
'http://deb.debian.org/debian/pool/main/x/xdg-dbus-proxy/xdg-dbus-proxy_0.1.2-2.debian.tar.xz' xdg-dbus-proxy_0.1.2-2.debian.tar.xz 3432 SHA256:30bb33f04925fd498bdb8f70cb8c2c5a826b2107f8fee557c110113d086f9339
```

Other potentially useful URLs:

- https://sources.debian.net/src/xdg-dbus-proxy/0.1.2-2/ (for browsing the source)
- https://sources.debian.net/src/xdg-dbus-proxy/0.1.2-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/xdg-dbus-proxy/0.1.2-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `xkeyboard-config=2.29-2`

Binary Packages:

- `xkb-data=2.29-2`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris xkeyboard-config=2.29-2
'http://deb.debian.org/debian/pool/main/x/xkeyboard-config/xkeyboard-config_2.29-2.dsc' xkeyboard-config_2.29-2.dsc 2367 SHA256:dca40afb9a196907a2f1c80b147d574329f126f01b8834f7886fbe8448162971
'http://deb.debian.org/debian/pool/main/x/xkeyboard-config/xkeyboard-config_2.29.orig.tar.gz' xkeyboard-config_2.29.orig.tar.gz 2701654 SHA256:d8034c8b771b51140409039f8e3351e90a0092238b81af04239794e8d3dc0813
'http://deb.debian.org/debian/pool/main/x/xkeyboard-config/xkeyboard-config_2.29.orig.tar.gz.asc' xkeyboard-config_2.29.orig.tar.gz.asc 488 SHA256:30b9b0fd406caf048a74627f29dca01868b87a6c6d722003a6c0a8834165c08d
'http://deb.debian.org/debian/pool/main/x/xkeyboard-config/xkeyboard-config_2.29-2.diff.gz' xkeyboard-config_2.29-2.diff.gz 987137 SHA256:8dc241399c899e7c4d2ae41e442ec310b45e70b7935aaffec66c2d1d0c065bf4
```

Other potentially useful URLs:

- https://sources.debian.net/src/xkeyboard-config/2.29-2/ (for browsing the source)
- https://sources.debian.net/src/xkeyboard-config/2.29-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/xkeyboard-config/2.29-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `xorg-sgml-doctools=1:1.11-1.1`

Binary Packages:

- `xorg-sgml-doctools=1:1.11-1.1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris xorg-sgml-doctools=1:1.11-1.1
'http://deb.debian.org/debian/pool/main/x/xorg-sgml-doctools/xorg-sgml-doctools_1.11-1.1.dsc' xorg-sgml-doctools_1.11-1.1.dsc 1987 SHA256:6aac68e597386c10b02646d2026a833d301749a938701f4ca8efd4d19ad34295
'http://deb.debian.org/debian/pool/main/x/xorg-sgml-doctools/xorg-sgml-doctools_1.11.orig.tar.gz' xorg-sgml-doctools_1.11.orig.tar.gz 150367 SHA256:986326d7b4dd2ad298f61d8d41fe3929ac6191c6000d6d7e47a8ffc0c34e7426
'http://deb.debian.org/debian/pool/main/x/xorg-sgml-doctools/xorg-sgml-doctools_1.11-1.1.diff.gz' xorg-sgml-doctools_1.11-1.1.diff.gz 3296 SHA256:0c11e15d4f9aaacd38452a6a37d064f1a07058dcead7ab1e2aca223ec0a94d11
```

Other potentially useful URLs:

- https://sources.debian.net/src/xorg-sgml-doctools/1:1.11-1.1/ (for browsing the source)
- https://sources.debian.net/src/xorg-sgml-doctools/1:1.11-1.1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/xorg-sgml-doctools/1:1.11-1.1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `xorg=1:7.7+22`

Binary Packages:

- `x11-common=1:7.7+22`

Licenses: (parsed from: `/usr/share/doc/x11-common/copyright`)

- `GPL`

Source:

```console
$ apt-get source -qq --print-uris xorg=1:7.7+22
'http://deb.debian.org/debian/pool/main/x/xorg/xorg_7.7%2b22.dsc' xorg_7.7+22.dsc 1975 SHA256:5b273e9b4ece8f4525e73721cc1f14ea0772007035c24b5e35269bcdca45b69a
'http://deb.debian.org/debian/pool/main/x/xorg/xorg_7.7%2b22.tar.gz' xorg_7.7+22.tar.gz 287402 SHA256:4e39d07914480826f02f8ba293dc07e5595a2789c53ee47d92cc5ee992ef2ed5
```

Other potentially useful URLs:

- https://sources.debian.net/src/xorg/1:7.7+22/ (for browsing the source)
- https://sources.debian.net/src/xorg/1:7.7+22/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/xorg/1:7.7+22/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `xorgproto=2020.1-1`

Binary Packages:

- `x11proto-dev=2020.1-1`
- `x11proto-xext-dev=2020.1-1`

Licenses: (parsed from: `/usr/share/doc/x11proto-dev/copyright`, `/usr/share/doc/x11proto-xext-dev/copyright`)

- `MIT`
- `SGI`

Source:

```console
$ apt-get source -qq --print-uris xorgproto=2020.1-1
'http://deb.debian.org/debian/pool/main/x/xorgproto/xorgproto_2020.1-1.dsc' xorgproto_2020.1-1.dsc 3410 SHA256:227dba0e174e781c68502d33af10527d5d19d692ad969442a75c422a3cbaae6a
'http://deb.debian.org/debian/pool/main/x/xorgproto/xorgproto_2020.1.orig.tar.gz' xorgproto_2020.1.orig.tar.gz 1081369 SHA256:6265b11b125df2f4853eec4895b14067d5621f813553fa077bebef20d7542418
'http://deb.debian.org/debian/pool/main/x/xorgproto/xorgproto_2020.1.orig.tar.gz.asc' xorgproto_2020.1.orig.tar.gz.asc 659 SHA256:00af3777b1b00b5553d0838356202c920f94b3088502aca9c4c37abd704bf39d
'http://deb.debian.org/debian/pool/main/x/xorgproto/xorgproto_2020.1-1.diff.gz' xorgproto_2020.1-1.diff.gz 20627 SHA256:b96eb973c1effc4fb5a8545f81983d1acf7a6f01231da230b5911daa4eca35be
```

Other potentially useful URLs:

- https://sources.debian.net/src/xorgproto/2020.1-1/ (for browsing the source)
- https://sources.debian.net/src/xorgproto/2020.1-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/xorgproto/2020.1-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `xtrans=1.4.0-1`

Binary Packages:

- `xtrans-dev=1.4.0-1`

**WARNING:** unable to detect licenses! (package likely not compliant with DEP-5)  
If source is available (seen below), check the contents of `debian/copyright` within it.


Source:

```console
$ apt-get source -qq --print-uris xtrans=1.4.0-1
'http://deb.debian.org/debian/pool/main/x/xtrans/xtrans_1.4.0-1.dsc' xtrans_1.4.0-1.dsc 1919 SHA256:dd74ab9199e8f45215b566a9317cac7953bf063ce6893c185eccaf0fb4d84d8f
'http://deb.debian.org/debian/pool/main/x/xtrans/xtrans_1.4.0.orig.tar.gz' xtrans_1.4.0.orig.tar.gz 225941 SHA256:48ed850ce772fef1b44ca23639b0a57e38884045ed2cbb18ab137ef33ec713f9
'http://deb.debian.org/debian/pool/main/x/xtrans/xtrans_1.4.0-1.diff.gz' xtrans_1.4.0-1.diff.gz 9522 SHA256:0dac18165654d79e0796b80fab4c1104998d29e6d0b098af0426a1d72399521e
```

Other potentially useful URLs:

- https://sources.debian.net/src/xtrans/1.4.0-1/ (for browsing the source)
- https://sources.debian.net/src/xtrans/1.4.0-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/xtrans/1.4.0-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `xxhash=0.8.0-2`

Binary Packages:

- `libxxhash0:amd64=0.8.0-2`

Licenses: (parsed from: `/usr/share/doc/libxxhash0/copyright`)

- `BSD-2-clause`
- `GPL-2`

Source:

```console
$ apt-get source -qq --print-uris xxhash=0.8.0-2
'http://deb.debian.org/debian/pool/main/x/xxhash/xxhash_0.8.0-2.dsc' xxhash_0.8.0-2.dsc 1601 SHA256:91c696b5371558ebb12c323b0bd4e15eece0a439ef49c6aa5a6d0c1cf6c7762a
'http://deb.debian.org/debian/pool/main/x/xxhash/xxhash_0.8.0.orig.tar.gz' xxhash_0.8.0.orig.tar.gz 145909 SHA256:7054c3ebd169c97b64a92d7b994ab63c70dd53a06974f1f630ab782c28db0f4f
'http://deb.debian.org/debian/pool/main/x/xxhash/xxhash_0.8.0-2.debian.tar.xz' xxhash_0.8.0-2.debian.tar.xz 4160 SHA256:5c427c2c08019a945412afac02326a24c72b65a83bff59447009db303233aecd
```

Other potentially useful URLs:

- https://sources.debian.net/src/xxhash/0.8.0-2/ (for browsing the source)
- https://sources.debian.net/src/xxhash/0.8.0-2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/xxhash/0.8.0-2/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `xz-utils=5.2.5-2.1~deb11u1`

Binary Packages:

- `liblzma-dev:amd64=5.2.5-2.1~deb11u1`
- `liblzma5:amd64=5.2.5-2.1~deb11u1`
- `xz-utils=5.2.5-2.1~deb11u1`

Licenses: (parsed from: `/usr/share/doc/liblzma-dev/copyright`, `/usr/share/doc/liblzma5/copyright`, `/usr/share/doc/xz-utils/copyright`)

- `Autoconf`
- `GPL-2`
- `GPL-2+`
- `GPL-3`
- `LGPL-2`
- `LGPL-2.1`
- `LGPL-2.1+`
- `PD`
- `PD-debian`
- `config-h`
- `noderivs`
- `none`
- `permissive-fsf`
- `permissive-nowarranty`
- `probably-PD`

Source:

```console
$ apt-get source -qq --print-uris xz-utils=5.2.5-2.1~deb11u1
'http://deb.debian.org/debian/pool/main/x/xz-utils/xz-utils_5.2.5-2.1%7edeb11u1.dsc' xz-utils_5.2.5-2.1~deb11u1.dsc 2681 SHA256:68a2702d252ab75789130fc9d2f48b9b38fc0181990c42a947b0d923d9d1922a
'http://deb.debian.org/debian/pool/main/x/xz-utils/xz-utils_5.2.5.orig.tar.xz' xz-utils_5.2.5.orig.tar.xz 1148824 SHA256:3e1e518ffc912f86608a8cb35e4bd41ad1aec210df2a47aaa1f95e7f5576ef56
'http://deb.debian.org/debian/pool/main/x/xz-utils/xz-utils_5.2.5.orig.tar.xz.asc' xz-utils_5.2.5.orig.tar.xz.asc 833 SHA256:6efc0075a58912e640119d2b52ef7d1518b260d8720fadc73df21ab7fc727624
'http://deb.debian.org/debian/pool/main/x/xz-utils/xz-utils_5.2.5-2.1%7edeb11u1.debian.tar.xz' xz-utils_5.2.5-2.1~deb11u1.debian.tar.xz 34948 SHA256:07627e4c7a50ef91d64c177626507afd6107f44e27f4aacb5e41151d1399ff4f
```

Other potentially useful URLs:

- https://sources.debian.net/src/xz-utils/5.2.5-2.1~deb11u1/ (for browsing the source)
- https://sources.debian.net/src/xz-utils/5.2.5-2.1~deb11u1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/xz-utils/5.2.5-2.1~deb11u1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `z3=4.8.10-1`

Binary Packages:

- `libz3-4:amd64=4.8.10-1`

Licenses: (parsed from: `/usr/share/doc/libz3-4/copyright`)

- `Expat`
- `GPL-2`
- `GPL-2+`

Source:

```console
$ apt-get source -qq --print-uris z3=4.8.10-1
'http://deb.debian.org/debian/pool/main/z/z3/z3_4.8.10-1.dsc' z3_4.8.10-1.dsc 2645 SHA256:79154abf69a30e25007dcbc708cc669a9acfadc9c0b6e48c5f5b0c2ee383dc31
'http://deb.debian.org/debian/pool/main/z/z3/z3_4.8.10.orig.tar.gz' z3_4.8.10.orig.tar.gz 4731869 SHA256:12cce6392b613d3133909ce7f93985d2470f0d00138837de06cf7eb2992886b4
'http://deb.debian.org/debian/pool/main/z/z3/z3_4.8.10-1.debian.tar.xz' z3_4.8.10-1.debian.tar.xz 10112 SHA256:1276e44bdc3d3c873b27487aea0ca9882bf010bcf94a7c1cd1a9cd76eb89f234
```

Other potentially useful URLs:

- https://sources.debian.net/src/z3/4.8.10-1/ (for browsing the source)
- https://sources.debian.net/src/z3/4.8.10-1/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/z3/4.8.10-1/ (for access to the source package after it no longer exists in the archive)

### `dpkg` source package: `zlib=1:1.2.11.dfsg-2+deb11u2`

Binary Packages:

- `zlib1g:amd64=1:1.2.11.dfsg-2+deb11u2`
- `zlib1g-dev:amd64=1:1.2.11.dfsg-2+deb11u2`

Licenses: (parsed from: `/usr/share/doc/zlib1g/copyright`, `/usr/share/doc/zlib1g-dev/copyright`)

- `Zlib`

Source:

```console
$ apt-get source -qq --print-uris zlib=1:1.2.11.dfsg-2+deb11u2
'http://deb.debian.org/debian/pool/main/z/zlib/zlib_1.2.11.dfsg-2%2bdeb11u2.dsc' zlib_1.2.11.dfsg-2+deb11u2.dsc 2905 SHA256:ec2ee2fc4dfd1f799dfa6a95133ebccbd7531886de38b0a8e3e58b66706a6dc7
'http://deb.debian.org/debian/pool/main/z/zlib/zlib_1.2.11.dfsg.orig.tar.gz' zlib_1.2.11.dfsg.orig.tar.gz 370248 SHA256:80c481411a4fe8463aeb8270149a0e80bb9eaf7da44132b6e16f2b5af01bc899
'http://deb.debian.org/debian/pool/main/z/zlib/zlib_1.2.11.dfsg-2%2bdeb11u2.debian.tar.xz' zlib_1.2.11.dfsg-2+deb11u2.debian.tar.xz 23984 SHA256:c19794df214f0c2571b19f7dea853c066410232abe9f0ddad77231fabccde0da
```

Other potentially useful URLs:

- https://sources.debian.net/src/zlib/1:1.2.11.dfsg-2+deb11u2/ (for browsing the source)
- https://sources.debian.net/src/zlib/1:1.2.11.dfsg-2+deb11u2/debian/copyright/ (for direct copyright/license information)
- http://snapshot.debian.org/package/zlib/1:1.2.11.dfsg-2+deb11u2/ (for access to the source package after it no longer exists in the archive)
