## `elixir:1.16-alpine`

```console
$ docker pull elixir@sha256:3faedbeacacb58faa738a37009faed354b989bd08cbfec9343c923b66ef59d21
```

-	Manifest MIME: `application/vnd.oci.image.index.v1+json`
-	Platforms: 12
	-	linux; amd64
	-	unknown; unknown
	-	linux; arm variant v7
	-	unknown; unknown
	-	linux; arm64 variant v8
	-	unknown; unknown
	-	linux; 386
	-	unknown; unknown
	-	linux; ppc64le
	-	unknown; unknown
	-	linux; s390x
	-	unknown; unknown

### `elixir:1.16-alpine` - linux; amd64

```console
$ docker pull elixir@sha256:d230107ac797b9a10321b1d2ff87c1960fe8b61782aabc90e813193064b17612
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **56.0 MB (56038359 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:afcf02dbf9ad57d065c515371307e755df112e5bbe513f9bd1d0a3da7262553a`
-	Default Command: `["iex"]`

```dockerfile
# Sun, 26 May 2024 04:39:18 GMT
ADD file:9e193d6fff4bce11c0ee715ad87def9ef40e9608d4be84cf73391edd45b2810e in / 
# Sun, 26 May 2024 04:39:18 GMT
CMD ["/bin/sh"]
# Sun, 26 May 2024 04:39:18 GMT
ENV OTP_VERSION=26.2.5.2 REBAR3_VERSION=3.23.0
# Sun, 26 May 2024 04:39:18 GMT
LABEL org.opencontainers.image.version=26.2.5.2
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="8e537e2d984770796cc7f0c7c079a9e5fbc67b8c368e0dcd9aa2ceaeb2844da2" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["erl"]
# Sun, 26 May 2024 04:39:18 GMT
ENV ELIXIR_VERSION=v1.16.3 LANG=C.UTF-8
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="a163128e618e5205ea749f8effafa5b540008fd0bed863e75e2e09663a00ec45" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:94c7366c1c3058fbc60a5ea04b6d13199a592a67939a043c41c051c4bfcd117a`  
		Last Modified: Fri, 06 Sep 2024 22:20:51 GMT  
		Size: 3.4 MB (3419706 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:32db2bb61fc4d09afaf3f7a6bd5ca70e67a8417c6e66e627a9b8e3c23a3085de`  
		Last Modified: Fri, 06 Sep 2024 23:26:06 GMT  
		Size: 45.9 MB (45852345 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:3e36c77e2e92cf0e67c738335b9d957ddb7309a26076bd88582bfb37e4802322`  
		Last Modified: Sat, 07 Sep 2024 00:11:10 GMT  
		Size: 6.8 MB (6766308 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.16-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:0e2d8a4b334e79f039898b371f8aa4205fc59bbd3e7fc5d78767f4422532c166
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **288.5 KB (288490 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:6a5512251e667924a76b30b2fe3d8d340d9710fb093778d700dc3fe8a2fd8466`

```dockerfile
```

-	Layers:
	-	`sha256:ebba40ce5c7f094a1be491de7817526642703a41a34871b39e58a594d252de17`  
		Last Modified: Sat, 07 Sep 2024 00:11:10 GMT  
		Size: 278.7 KB (278702 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:d88404d1e493cf5b7d16225665ca70027093f50a09ddae844f036e1ca425c322`  
		Last Modified: Sat, 07 Sep 2024 00:11:10 GMT  
		Size: 9.8 KB (9788 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.16-alpine` - linux; arm variant v7

```console
$ docker pull elixir@sha256:9256920fb798927f65daec8456023e88b61b77eafe8d9f1bcfedc411877c38be
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **53.3 MB (53254501 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:237119992c38b62053374de99e857515917bc289d8a01d26ef89a2925bfc3328`
-	Default Command: `["iex"]`

```dockerfile
# Sun, 26 May 2024 04:39:18 GMT
ADD file:a0a04eec8c7b34f27431bfd6edc27b4c05f2174daf93e40c263717d2469dcebd in / 
# Sun, 26 May 2024 04:39:18 GMT
CMD ["/bin/sh"]
# Sun, 26 May 2024 04:39:18 GMT
ENV OTP_VERSION=26.2.5.2 REBAR3_VERSION=3.23.0
# Sun, 26 May 2024 04:39:18 GMT
LABEL org.opencontainers.image.version=26.2.5.2
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="8e537e2d984770796cc7f0c7c079a9e5fbc67b8c368e0dcd9aa2ceaeb2844da2" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["erl"]
# Sun, 26 May 2024 04:39:18 GMT
ENV ELIXIR_VERSION=v1.16.3 LANG=C.UTF-8
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="a163128e618e5205ea749f8effafa5b540008fd0bed863e75e2e09663a00ec45" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:426a5537ab470cede64a1b269dbc9f485fa674bec59555cdaa5a1c96e6675b0d`  
		Last Modified: Fri, 06 Sep 2024 22:08:37 GMT  
		Size: 2.9 MB (2927664 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:2de9b2e33b197cc41d963ae1e0aed045c4c1cfc44f8a402e53fa81a4f51079ef`  
		Last Modified: Sat, 07 Sep 2024 02:32:34 GMT  
		Size: 43.6 MB (43560781 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:157350a6481fd24ccca51d8e9b003b39113a694bb443a43475abf5d0ed59f8da`  
		Last Modified: Sat, 07 Sep 2024 13:57:12 GMT  
		Size: 6.8 MB (6766056 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.16-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:76753ed628958aa77a89479e64a81220908b1531b657e5e1ec7f63dad5177ce7
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **284.5 KB (284542 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:fb7dee4b8469236c8b78a9fa10af639d85970301fae16dc6494c42a85d866cd0`

```dockerfile
```

-	Layers:
	-	`sha256:7982432fb89bfad3f22673b1d716309105e0c9b42d0f18cc56f2d1b51307b1b8`  
		Last Modified: Sat, 07 Sep 2024 13:57:11 GMT  
		Size: 274.7 KB (274666 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:a57c66898253b265e9a7b6741a5d5d2cd65e50d33bea066f29ad48f1edddf666`  
		Last Modified: Sat, 07 Sep 2024 13:57:11 GMT  
		Size: 9.9 KB (9876 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.16-alpine` - linux; arm64 variant v8

```console
$ docker pull elixir@sha256:2881d6141c0f29be6fafa9877cb8fcfc654f93446340f931f9748262876fabc8
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **55.8 MB (55771822 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:9a50ec48a918aa6a8b3767b55d3da2e0c5e463c63c399d4e1f334f0e057508ad`
-	Default Command: `["iex"]`

```dockerfile
# Sun, 26 May 2024 04:39:18 GMT
ADD file:9865d69f45511580cc2a05d8a9573251b6eb5a84520efe2e8295532e3ccd6321 in / 
# Sun, 26 May 2024 04:39:18 GMT
CMD ["/bin/sh"]
# Sun, 26 May 2024 04:39:18 GMT
ENV OTP_VERSION=26.2.5.2 REBAR3_VERSION=3.23.0
# Sun, 26 May 2024 04:39:18 GMT
LABEL org.opencontainers.image.version=26.2.5.2
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="8e537e2d984770796cc7f0c7c079a9e5fbc67b8c368e0dcd9aa2ceaeb2844da2" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["erl"]
# Sun, 26 May 2024 04:39:18 GMT
ENV ELIXIR_VERSION=v1.16.3 LANG=C.UTF-8
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="a163128e618e5205ea749f8effafa5b540008fd0bed863e75e2e09663a00ec45" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:188a7166e45935ced07634efdc8e63c13f5f7673b60b051b353475ee00e28fe0`  
		Last Modified: Fri, 06 Sep 2024 22:44:50 GMT  
		Size: 3.4 MB (3359103 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:32c65f7c488c0dd14acc4f73a67e53adb5056811a55dd6983d73f028db97fa76`  
		Last Modified: Sat, 07 Sep 2024 05:07:53 GMT  
		Size: 45.6 MB (45646357 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:e167d46f1f6fbf3aa47f2072e2658a6a102776d7549ca88008794c390faf49cb`  
		Last Modified: Sat, 07 Sep 2024 13:38:32 GMT  
		Size: 6.8 MB (6766362 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.16-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:d81e53133ef44f722d75ebbc9f215f56681df3ec2ca67cbad206725509b128dc
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **289.6 KB (289574 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:c9d82a6d55bbbb43f94d3d2432c8a47d2f33efac105bcc52c73e7bac59ca0fac`

```dockerfile
```

-	Layers:
	-	`sha256:ae8c44d1d68c065f17231595622bd2953db4255d1277e2d0488b10ff2c9188fd`  
		Last Modified: Sat, 07 Sep 2024 13:38:32 GMT  
		Size: 279.4 KB (279389 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:02ce05a91f768f55dc1cfe1bf223909387bb37dff68b8b676c36087526be1b6b`  
		Last Modified: Sat, 07 Sep 2024 13:38:32 GMT  
		Size: 10.2 KB (10185 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.16-alpine` - linux; 386

```console
$ docker pull elixir@sha256:ba26bb256ead45e702411c79eb0018bdffddbc46a762b5b8d30a066a3d699650
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **54.5 MB (54507805 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:f74bdf4090ee7ace37cf12c944d3080ec972e8a3f3b507a05a49ec196b205ae3`
-	Default Command: `["iex"]`

```dockerfile
# Sun, 26 May 2024 04:39:18 GMT
ADD file:19a9ac542bad192441d76d7dbe5496866d50d90786aa582a9a470a6f5c620f42 in / 
# Sun, 26 May 2024 04:39:18 GMT
CMD ["/bin/sh"]
# Sun, 26 May 2024 04:39:18 GMT
ENV OTP_VERSION=26.2.5.2 REBAR3_VERSION=3.23.0
# Sun, 26 May 2024 04:39:18 GMT
LABEL org.opencontainers.image.version=26.2.5.2
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="8e537e2d984770796cc7f0c7c079a9e5fbc67b8c368e0dcd9aa2ceaeb2844da2" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["erl"]
# Sun, 26 May 2024 04:39:18 GMT
ENV ELIXIR_VERSION=v1.16.3 LANG=C.UTF-8
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="a163128e618e5205ea749f8effafa5b540008fd0bed863e75e2e09663a00ec45" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:f8365d87ce9a9886c88284fcf1fc48ad082e1d5ba8d0d788aeb9e49923921970`  
		Last Modified: Fri, 06 Sep 2024 22:41:58 GMT  
		Size: 3.3 MB (3253605 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:720ec63191a7a9af02d97d7fec87250278b0a9f12f4ea2c2d920589ce3945f47`  
		Last Modified: Fri, 06 Sep 2024 23:27:17 GMT  
		Size: 44.5 MB (44488106 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:5c7e482e0e3318afe2690efe01ea7d66c806c787d716b929142a30951c8572da`  
		Last Modified: Sat, 07 Sep 2024 00:11:59 GMT  
		Size: 6.8 MB (6766094 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.16-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:992d4786de7aaa9b7b8f17e3928b2ad7d144006ded8f6ca4ca7240ed38c11ba6
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **283.7 KB (283729 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:370e135843991c71297274751dff2ec74ecf0c98d2fd0eb1956609c73b105ff4`

```dockerfile
```

-	Layers:
	-	`sha256:dea8d28a663f9d72e9c05a1f1fd44f3db6dc39b7355228733df2f8fc77e393a0`  
		Last Modified: Sat, 07 Sep 2024 00:11:59 GMT  
		Size: 274.0 KB (273974 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:c3b218bea9ffdb6dac615d0f0588a973f9af0a0d18061e677d4b330f0aeda9fd`  
		Last Modified: Sat, 07 Sep 2024 00:11:58 GMT  
		Size: 9.8 KB (9755 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.16-alpine` - linux; ppc64le

```console
$ docker pull elixir@sha256:c243e599bc0c5c3a870c907ccceefb1ff4058a19cb09551e1667dfaf888a3124
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **54.6 MB (54632252 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:de0e25dcde8665c2c22064b55d36d1363ec02e654bdb208ee2b3ecdc4826e8d3`
-	Default Command: `["iex"]`

```dockerfile
# Sun, 26 May 2024 04:39:18 GMT
ADD file:2b460e2f1af1fd81bcf839fbca42c282e18754a310086d2d55772cfcaff3154e in / 
# Sun, 26 May 2024 04:39:18 GMT
CMD ["/bin/sh"]
# Sun, 26 May 2024 04:39:18 GMT
ENV OTP_VERSION=26.2.5.2 REBAR3_VERSION=3.23.0
# Sun, 26 May 2024 04:39:18 GMT
LABEL org.opencontainers.image.version=26.2.5.2
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="8e537e2d984770796cc7f0c7c079a9e5fbc67b8c368e0dcd9aa2ceaeb2844da2" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["erl"]
# Sun, 26 May 2024 04:39:18 GMT
ENV ELIXIR_VERSION=v1.16.3 LANG=C.UTF-8
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="a163128e618e5205ea749f8effafa5b540008fd0bed863e75e2e09663a00ec45" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:1274ef399099f48829c82f23090a3c36444839648f7cf9fbf44c7518257fcdd2`  
		Last Modified: Fri, 06 Sep 2024 22:26:51 GMT  
		Size: 3.4 MB (3364467 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:5cd8c3ec3d03a6bb017273401203cf75c78f39536eff1ab08771d2c66ea673cf`  
		Last Modified: Sat, 07 Sep 2024 06:41:01 GMT  
		Size: 44.5 MB (44501702 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:6b61da594fe51fabbbd0d93ce19935ff198fb468423b64abae86fd8f09ac0ce3`  
		Last Modified: Sat, 07 Sep 2024 13:33:27 GMT  
		Size: 6.8 MB (6766083 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.16-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:7ac967564c9b710d679f7352dba8a55c22b1a426c5c7ba7975b08aa4ecde0849
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **282.6 KB (282554 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:063cd529e5dda188f08465d0e1069a0aee5b139b1a38d764714c5b882653ece3`

```dockerfile
```

-	Layers:
	-	`sha256:0310bf18305ed43724d03411a2350b96090d5b307b1b38233590145df27c61f6`  
		Last Modified: Sat, 07 Sep 2024 13:33:26 GMT  
		Size: 272.7 KB (272710 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:5f25cdc3141a8ee79e68eb175fd1865683b239bddb99eab6e1fb8c4553b8e1ce`  
		Last Modified: Sat, 07 Sep 2024 13:33:26 GMT  
		Size: 9.8 KB (9844 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.16-alpine` - linux; s390x

```console
$ docker pull elixir@sha256:c0d7d81b85b6fe37738ec71510aac83f3f5e2bb231a063f48efec9642e49d270
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **54.2 MB (54219365 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:89cbae351ec0e439ef84f225c29704ebeffb4a826217575a331bee436f09fafa`
-	Default Command: `["iex"]`

```dockerfile
# Sun, 26 May 2024 04:39:18 GMT
ADD file:accee20143ffbe803d23675898d25fedbb25c04fcc9f4ddaa1ba5f066c5ae260 in / 
# Sun, 26 May 2024 04:39:18 GMT
CMD ["/bin/sh"]
# Sun, 26 May 2024 04:39:18 GMT
ENV OTP_VERSION=26.2.5.2 REBAR3_VERSION=3.23.0
# Sun, 26 May 2024 04:39:18 GMT
LABEL org.opencontainers.image.version=26.2.5.2
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="8e537e2d984770796cc7f0c7c079a9e5fbc67b8c368e0dcd9aa2ceaeb2844da2" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["erl"]
# Sun, 26 May 2024 04:39:18 GMT
ENV ELIXIR_VERSION=v1.16.3 LANG=C.UTF-8
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="a163128e618e5205ea749f8effafa5b540008fd0bed863e75e2e09663a00ec45" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:dbf93dbda29c680e293e8229956c663ae9d4e8435d70335c363568788915cac5`  
		Last Modified: Fri, 06 Sep 2024 22:49:04 GMT  
		Size: 3.3 MB (3253357 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:2ef458bae4f566ea087150ba9664fd270b6ab2410ad9927d43983f949e3cfbbe`  
		Last Modified: Sat, 07 Sep 2024 02:24:32 GMT  
		Size: 44.2 MB (44200033 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:c1a0276d316d100b476ea537dba08e0d90d3271723d06494e83d09f852e730a2`  
		Last Modified: Sat, 07 Sep 2024 11:34:28 GMT  
		Size: 6.8 MB (6765975 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.16-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:38c927c9d3d5c8c3c8f00ea04b7595dfee607096a277105d1b87c19ee89defed
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **282.5 KB (282476 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:d1d6d7e68a24d7a199a1f8e60dee759c9a198e8f40fce430df153d67b4ba2fac`

```dockerfile
```

-	Layers:
	-	`sha256:f8ccb30a52398dd9c15cf4ee7476f20a685acbde579036046df20145e82203ae`  
		Last Modified: Sat, 07 Sep 2024 11:34:28 GMT  
		Size: 272.7 KB (272676 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:722857b604aa8218c6a156497b6a3b39bbd542e061610b5a5694b6f342982971`  
		Last Modified: Sat, 07 Sep 2024 11:34:28 GMT  
		Size: 9.8 KB (9800 bytes)  
		MIME: application/vnd.in-toto+json
