## `elixir:1.15-otp-26-alpine`

```console
$ docker pull elixir@sha256:bd61b0cfc2f7e48482aea8eee74464cf46c9003d30cd17e8b405f1db8fba4817
```

-	Manifest MIME: `application/vnd.oci.image.index.v1+json`
-	Platforms: 12
	-	linux; amd64
	-	unknown; unknown
	-	linux; arm variant v7
	-	unknown; unknown
	-	linux; arm64 variant v8
	-	unknown; unknown
	-	linux; 386
	-	unknown; unknown
	-	linux; ppc64le
	-	unknown; unknown
	-	linux; s390x
	-	unknown; unknown

### `elixir:1.15-otp-26-alpine` - linux; amd64

```console
$ docker pull elixir@sha256:7ec7c5c2bd2790122d42244a14eca83ac41c1a8f0b01ecdb5e170d7536d96ccd
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **55.6 MB (55631154 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:dce5b32f1e7c6f10ddc5cfd2e11ae5c5756934cb7792600f55b7843c314963a0`
-	Default Command: `["iex"]`

```dockerfile
# Sun, 26 May 2024 04:39:18 GMT
ADD file:9e193d6fff4bce11c0ee715ad87def9ef40e9608d4be84cf73391edd45b2810e in / 
# Sun, 26 May 2024 04:39:18 GMT
CMD ["/bin/sh"]
# Sun, 26 May 2024 04:39:18 GMT
ENV OTP_VERSION=26.2.5.2 REBAR3_VERSION=3.23.0
# Sun, 26 May 2024 04:39:18 GMT
LABEL org.opencontainers.image.version=26.2.5.2
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="8e537e2d984770796cc7f0c7c079a9e5fbc67b8c368e0dcd9aa2ceaeb2844da2" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["erl"]
# Sun, 26 May 2024 04:39:18 GMT
ENV ELIXIR_VERSION=v1.15.8 LANG=C.UTF-8
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="09e697ab13fc60f27adaba9b71f8793105acd4320a89b16be0ceb4a13426d779" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:94c7366c1c3058fbc60a5ea04b6d13199a592a67939a043c41c051c4bfcd117a`  
		Last Modified: Fri, 06 Sep 2024 22:20:51 GMT  
		Size: 3.4 MB (3419706 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:32db2bb61fc4d09afaf3f7a6bd5ca70e67a8417c6e66e627a9b8e3c23a3085de`  
		Last Modified: Fri, 06 Sep 2024 23:26:06 GMT  
		Size: 45.9 MB (45852345 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:e4842a0a5a01a12caf7f8f1e36579fee992edb6117963bd774603e0b8f9d343f`  
		Last Modified: Sat, 07 Sep 2024 00:11:09 GMT  
		Size: 6.4 MB (6359103 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.15-otp-26-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:8b5981feeb3e6f0077aa429e1b1026888dd43c592054b6d7cc9c9694905d956b
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **288.5 KB (288490 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:dee6a6d948c9bd54ace1a39d2bb1b225a13963bc280b5243d18f8ee4d07342b1`

```dockerfile
```

-	Layers:
	-	`sha256:59c6dc24a20588f7200d331d43a2dbbff158eb3dc8d3a9f5223bf6d12c8a9a82`  
		Last Modified: Sat, 07 Sep 2024 00:11:09 GMT  
		Size: 278.7 KB (278702 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:6a7daf6e85cafd61ebdb9a6c68bd9a1d24137ec6822a8e372b019d9fbfed6238`  
		Last Modified: Sat, 07 Sep 2024 00:11:09 GMT  
		Size: 9.8 KB (9788 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.15-otp-26-alpine` - linux; arm variant v7

```console
$ docker pull elixir@sha256:076688d0584be245914dca3489b36f4cca02459416436b9a2bce4d86e7b79cd6
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **52.8 MB (52847085 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:d565e94d9ecfeda6af2a95060dc276b08b3f2d32cea66f47740ec12c28a029dd`
-	Default Command: `["iex"]`

```dockerfile
# Sun, 26 May 2024 04:39:18 GMT
ADD file:a0a04eec8c7b34f27431bfd6edc27b4c05f2174daf93e40c263717d2469dcebd in / 
# Sun, 26 May 2024 04:39:18 GMT
CMD ["/bin/sh"]
# Sun, 26 May 2024 04:39:18 GMT
ENV OTP_VERSION=26.2.5.2 REBAR3_VERSION=3.23.0
# Sun, 26 May 2024 04:39:18 GMT
LABEL org.opencontainers.image.version=26.2.5.2
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="8e537e2d984770796cc7f0c7c079a9e5fbc67b8c368e0dcd9aa2ceaeb2844da2" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["erl"]
# Sun, 26 May 2024 04:39:18 GMT
ENV ELIXIR_VERSION=v1.15.8 LANG=C.UTF-8
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="09e697ab13fc60f27adaba9b71f8793105acd4320a89b16be0ceb4a13426d779" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:426a5537ab470cede64a1b269dbc9f485fa674bec59555cdaa5a1c96e6675b0d`  
		Last Modified: Fri, 06 Sep 2024 22:08:37 GMT  
		Size: 2.9 MB (2927664 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:2de9b2e33b197cc41d963ae1e0aed045c4c1cfc44f8a402e53fa81a4f51079ef`  
		Last Modified: Sat, 07 Sep 2024 02:32:34 GMT  
		Size: 43.6 MB (43560781 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:da0d8260d4fad6a79cdfb676f80f7463f89cf0c2d51a4299ebc162c0b08bb4f6`  
		Last Modified: Sat, 07 Sep 2024 14:00:54 GMT  
		Size: 6.4 MB (6358640 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.15-otp-26-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:396f913f3aab33e11ba52c6ea138bf0cca87295ebc36e69e4077742ab8cbc6f9
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **284.5 KB (284542 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:c998964f255a651491ffe0db3a65ac3a51a8d91e7c59e5ea2713daa080417d05`

```dockerfile
```

-	Layers:
	-	`sha256:c7279a3a9d20e7c7bb9c08019a5828eb628256db3bec9bc10bda7922eb413c87`  
		Last Modified: Sat, 07 Sep 2024 14:00:54 GMT  
		Size: 274.7 KB (274666 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:a59ff0640dc4598903e39e46bf409edee0a9caf823b801720680baa36817d6fa`  
		Last Modified: Sat, 07 Sep 2024 14:00:53 GMT  
		Size: 9.9 KB (9876 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.15-otp-26-alpine` - linux; arm64 variant v8

```console
$ docker pull elixir@sha256:bc9cb743f2f9de1e11e16ca22b7f1142aa6c01d7e9e9b38027ba122a2caf3511
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **55.4 MB (55364550 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:288c17c8e5a55249ce34d6f84b919953ab03824130f74350af0f1171148bfd88`
-	Default Command: `["iex"]`

```dockerfile
# Sun, 26 May 2024 04:39:18 GMT
ADD file:9865d69f45511580cc2a05d8a9573251b6eb5a84520efe2e8295532e3ccd6321 in / 
# Sun, 26 May 2024 04:39:18 GMT
CMD ["/bin/sh"]
# Sun, 26 May 2024 04:39:18 GMT
ENV OTP_VERSION=26.2.5.2 REBAR3_VERSION=3.23.0
# Sun, 26 May 2024 04:39:18 GMT
LABEL org.opencontainers.image.version=26.2.5.2
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="8e537e2d984770796cc7f0c7c079a9e5fbc67b8c368e0dcd9aa2ceaeb2844da2" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["erl"]
# Sun, 26 May 2024 04:39:18 GMT
ENV ELIXIR_VERSION=v1.15.8 LANG=C.UTF-8
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="09e697ab13fc60f27adaba9b71f8793105acd4320a89b16be0ceb4a13426d779" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:188a7166e45935ced07634efdc8e63c13f5f7673b60b051b353475ee00e28fe0`  
		Last Modified: Fri, 06 Sep 2024 22:44:50 GMT  
		Size: 3.4 MB (3359103 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:32c65f7c488c0dd14acc4f73a67e53adb5056811a55dd6983d73f028db97fa76`  
		Last Modified: Sat, 07 Sep 2024 05:07:53 GMT  
		Size: 45.6 MB (45646357 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:26e97923e587bde94b68026a7a4f16c220848b5ff562249182191d3df6130d0b`  
		Last Modified: Sat, 07 Sep 2024 13:41:12 GMT  
		Size: 6.4 MB (6359090 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.15-otp-26-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:3e4f498b658d65decdc11262145e1120b1fd0267685aa2ce02aff8e10ce3d143
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **289.6 KB (289574 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:8cfcad09712d02349efa8e564bec714ebe4faabaaa07155674a1bf3571c42323`

```dockerfile
```

-	Layers:
	-	`sha256:98b23e0ff05b6d2cbe370210627771569777c7aba63facc80692361ca9714af6`  
		Last Modified: Sat, 07 Sep 2024 13:41:11 GMT  
		Size: 279.4 KB (279389 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:623bc7d3fd748bca127ef4ae6df03653643ae87356d121a06ad33958c994d251`  
		Last Modified: Sat, 07 Sep 2024 13:41:11 GMT  
		Size: 10.2 KB (10185 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.15-otp-26-alpine` - linux; 386

```console
$ docker pull elixir@sha256:2516da842c582189e965efc2bc72672b6b333b686afd21dd8490671fee661903
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **54.1 MB (54100171 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:04b3fd7b7b022b7766d77c897823d11f763c0df1bc3a1b93fe8d15a4e1cccfe6`
-	Default Command: `["iex"]`

```dockerfile
# Sun, 26 May 2024 04:39:18 GMT
ADD file:19a9ac542bad192441d76d7dbe5496866d50d90786aa582a9a470a6f5c620f42 in / 
# Sun, 26 May 2024 04:39:18 GMT
CMD ["/bin/sh"]
# Sun, 26 May 2024 04:39:18 GMT
ENV OTP_VERSION=26.2.5.2 REBAR3_VERSION=3.23.0
# Sun, 26 May 2024 04:39:18 GMT
LABEL org.opencontainers.image.version=26.2.5.2
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="8e537e2d984770796cc7f0c7c079a9e5fbc67b8c368e0dcd9aa2ceaeb2844da2" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["erl"]
# Sun, 26 May 2024 04:39:18 GMT
ENV ELIXIR_VERSION=v1.15.8 LANG=C.UTF-8
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="09e697ab13fc60f27adaba9b71f8793105acd4320a89b16be0ceb4a13426d779" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:f8365d87ce9a9886c88284fcf1fc48ad082e1d5ba8d0d788aeb9e49923921970`  
		Last Modified: Fri, 06 Sep 2024 22:41:58 GMT  
		Size: 3.3 MB (3253605 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:720ec63191a7a9af02d97d7fec87250278b0a9f12f4ea2c2d920589ce3945f47`  
		Last Modified: Fri, 06 Sep 2024 23:27:17 GMT  
		Size: 44.5 MB (44488106 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:e5ee8fbc4137c40c51ae6333147ad9a71341f1e10feabe8f988446c4b4e57cd0`  
		Last Modified: Sat, 07 Sep 2024 00:11:49 GMT  
		Size: 6.4 MB (6358460 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.15-otp-26-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:c679c83df08a302c0b23e7dc369952a8bd104cdcdca6c7514ecc47375a4363f9
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **283.7 KB (283730 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:a2cbade56b7036343f952735d55c52b38f5ebbe8a2b9d7cb95ed7b69c6f6f890`

```dockerfile
```

-	Layers:
	-	`sha256:d7eeba689e2bbbd353828a2fd8a30233d2232aa302efe239880a978c4a3205ea`  
		Last Modified: Sat, 07 Sep 2024 00:11:49 GMT  
		Size: 274.0 KB (273974 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:764b0388d2a1b42777400be36566330d5e163fbfca8a3693fffba49183d4f99d`  
		Last Modified: Sat, 07 Sep 2024 00:11:49 GMT  
		Size: 9.8 KB (9756 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.15-otp-26-alpine` - linux; ppc64le

```console
$ docker pull elixir@sha256:6f8c476bdac0a064860645a4e9ae7de9eab38779a7dee365db63ab373c71cbb4
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **54.2 MB (54224828 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:8173167228d1f2c4e564e6575d9fe4d69676ab614ce71af25ddb51bc57c08a03`
-	Default Command: `["iex"]`

```dockerfile
# Sun, 26 May 2024 04:39:18 GMT
ADD file:2b460e2f1af1fd81bcf839fbca42c282e18754a310086d2d55772cfcaff3154e in / 
# Sun, 26 May 2024 04:39:18 GMT
CMD ["/bin/sh"]
# Sun, 26 May 2024 04:39:18 GMT
ENV OTP_VERSION=26.2.5.2 REBAR3_VERSION=3.23.0
# Sun, 26 May 2024 04:39:18 GMT
LABEL org.opencontainers.image.version=26.2.5.2
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="8e537e2d984770796cc7f0c7c079a9e5fbc67b8c368e0dcd9aa2ceaeb2844da2" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["erl"]
# Sun, 26 May 2024 04:39:18 GMT
ENV ELIXIR_VERSION=v1.15.8 LANG=C.UTF-8
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="09e697ab13fc60f27adaba9b71f8793105acd4320a89b16be0ceb4a13426d779" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:1274ef399099f48829c82f23090a3c36444839648f7cf9fbf44c7518257fcdd2`  
		Last Modified: Fri, 06 Sep 2024 22:26:51 GMT  
		Size: 3.4 MB (3364467 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:5cd8c3ec3d03a6bb017273401203cf75c78f39536eff1ab08771d2c66ea673cf`  
		Last Modified: Sat, 07 Sep 2024 06:41:01 GMT  
		Size: 44.5 MB (44501702 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:fa4a556576e0a7327e0fb8c178965b091fb0e7d2f340e56c7b7e90bd80c67a6e`  
		Last Modified: Sat, 07 Sep 2024 13:39:06 GMT  
		Size: 6.4 MB (6358659 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.15-otp-26-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:7c85e25ddf086c91d4f015899bf9c0b277bbf89b46a13daca1e709e0cf28fbc9
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **282.6 KB (282554 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:01fa690c5cb66a14a49191167dc0b2632d76d708c6d615d4a220a2b94c73619d`

```dockerfile
```

-	Layers:
	-	`sha256:f244ba940e5168746ef324da1e9422e3e299417782945d878d7b15356675fc07`  
		Last Modified: Sat, 07 Sep 2024 13:39:06 GMT  
		Size: 272.7 KB (272710 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:d49db851822e4c2182759499d111c178d34317906158651b442191730d7c9290`  
		Last Modified: Sat, 07 Sep 2024 13:39:05 GMT  
		Size: 9.8 KB (9844 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.15-otp-26-alpine` - linux; s390x

```console
$ docker pull elixir@sha256:34a796f59052a545c33f8f5d0a243c5b303ad3e48e9a2c201f5b1833cb537eca
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **53.8 MB (53811916 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:80f8564afb44322544e79fa42f4aaa9a06c6dc8d5f6ffc96c4b374c88387bda5`
-	Default Command: `["iex"]`

```dockerfile
# Sun, 26 May 2024 04:39:18 GMT
ADD file:accee20143ffbe803d23675898d25fedbb25c04fcc9f4ddaa1ba5f066c5ae260 in / 
# Sun, 26 May 2024 04:39:18 GMT
CMD ["/bin/sh"]
# Sun, 26 May 2024 04:39:18 GMT
ENV OTP_VERSION=26.2.5.2 REBAR3_VERSION=3.23.0
# Sun, 26 May 2024 04:39:18 GMT
LABEL org.opencontainers.image.version=26.2.5.2
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="8e537e2d984770796cc7f0c7c079a9e5fbc67b8c368e0dcd9aa2ceaeb2844da2" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["erl"]
# Sun, 26 May 2024 04:39:18 GMT
ENV ELIXIR_VERSION=v1.15.8 LANG=C.UTF-8
# Sun, 26 May 2024 04:39:18 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="09e697ab13fc60f27adaba9b71f8793105acd4320a89b16be0ceb4a13426d779" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Sun, 26 May 2024 04:39:18 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:dbf93dbda29c680e293e8229956c663ae9d4e8435d70335c363568788915cac5`  
		Last Modified: Fri, 06 Sep 2024 22:49:04 GMT  
		Size: 3.3 MB (3253357 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:2ef458bae4f566ea087150ba9664fd270b6ab2410ad9927d43983f949e3cfbbe`  
		Last Modified: Sat, 07 Sep 2024 02:24:32 GMT  
		Size: 44.2 MB (44200033 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:13fb222f06d3b9ef908d3c688ba951175d6dedf57cb01a7324cdbe954989b1a4`  
		Last Modified: Sat, 07 Sep 2024 11:38:04 GMT  
		Size: 6.4 MB (6358526 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.15-otp-26-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:4a3828a3dc673125e0f78eedf1e11d82c1983c1764aca2139afbe75f9c46b850
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **282.5 KB (282475 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:bde4058e9624b8d19c4dd201bd7c61a78ca5954347219cef3e4f7787d4a0b788`

```dockerfile
```

-	Layers:
	-	`sha256:facd81254e2ef0c73ee04481089b76f2723075fc1040be33f8cbfdf9d148c0ff`  
		Last Modified: Sat, 07 Sep 2024 11:38:04 GMT  
		Size: 272.7 KB (272676 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:94cfcfd99a9c02b8fef1b79364b197198964643eea281af72887bf37ba23d2d6`  
		Last Modified: Sat, 07 Sep 2024 11:38:04 GMT  
		Size: 9.8 KB (9799 bytes)  
		MIME: application/vnd.in-toto+json
