## `elixir:1.14-otp-25-alpine`

```console
$ docker pull elixir@sha256:56332de0493e7db8b2d5e36e75257694bd9a1fdd16bdb09ea8dda5d2a195f46e
```

-	Manifest MIME: `application/vnd.oci.image.index.v1+json`
-	Platforms: 12
	-	linux; amd64
	-	unknown; unknown
	-	linux; arm variant v7
	-	unknown; unknown
	-	linux; arm64 variant v8
	-	unknown; unknown
	-	linux; 386
	-	unknown; unknown
	-	linux; ppc64le
	-	unknown; unknown
	-	linux; s390x
	-	unknown; unknown

### `elixir:1.14-otp-25-alpine` - linux; amd64

```console
$ docker pull elixir@sha256:7c327f041bf7ded307e9d5e3ab0a439c46ce97a481adbb7318e747d378b66697
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **54.5 MB (54486646 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:697ff301c24fcbcae92731af1c2774a847bc9d25c565f1bdeb0bee86ac7e6572`
-	Default Command: `["iex"]`

```dockerfile
# Wed, 24 May 2023 12:00:24 GMT
ADD file:5dd525c57625a3a84d57d435b3c255f417ad1722250faaf006c66b9090207f66 in / 
# Wed, 24 May 2023 12:00:24 GMT
CMD ["/bin/sh"]
# Wed, 24 May 2023 12:00:24 GMT
ENV OTP_VERSION=25.3.2.13 REBAR3_VERSION=3.23.0
# Wed, 24 May 2023 12:00:24 GMT
LABEL org.opencontainers.image.version=25.3.2.13
# Wed, 24 May 2023 12:00:24 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="ef56f754f14ba89356284145c8a0dd95e11f00ec6142b4dd9a9431570d6ff5ea" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Wed, 24 May 2023 12:00:24 GMT
CMD ["erl"]
# Wed, 24 May 2023 12:00:24 GMT
ENV ELIXIR_VERSION=v1.14.5 LANG=C.UTF-8
# Wed, 24 May 2023 12:00:24 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="2ea249566c67e57f8365ecdcd0efd9b6c375f57609b3ac2de326488ac37c8ebd" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Wed, 24 May 2023 12:00:24 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:1cc3d825d8b2468ef662a8b631220516f492e24232477209fe863836d2d2ed44`  
		Last Modified: Fri, 06 Sep 2024 22:20:59 GMT  
		Size: 3.4 MB (3416313 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:ca4d98d30af08d5f78266d65c681b4a9c5349de4eb0cdcfbbc900567eb85834c`  
		Last Modified: Fri, 06 Sep 2024 23:25:28 GMT  
		Size: 44.8 MB (44842585 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:08ab7370bec5322449073639aa7f766894c32302619080c95fe2c371c253c057`  
		Last Modified: Sat, 07 Sep 2024 00:11:17 GMT  
		Size: 6.2 MB (6227748 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.14-otp-25-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:3b91f316eaa20beb066b376770bb423c718ecaf742293cc53faf204991e84d0d
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **287.5 KB (287499 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:b2db51fee45f029bcf1009810484b519d1d1b2ee70e09c3414a3a3c52fdc6d35`

```dockerfile
```

-	Layers:
	-	`sha256:695b5c7b4afc167d1e1c9a77041438048f68124b7451604bbf23b166a67d35ae`  
		Last Modified: Sat, 07 Sep 2024 00:11:16 GMT  
		Size: 278.3 KB (278317 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:09daca6110f65b31369bd4fb4bd40fe354365aa5b2253e975ae7be1ed151f823`  
		Last Modified: Sat, 07 Sep 2024 00:11:16 GMT  
		Size: 9.2 KB (9182 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.14-otp-25-alpine` - linux; arm variant v7

```console
$ docker pull elixir@sha256:bb9a4fc073918c4b1007444c4158210ae96ad6c16ce77ca532fe170eca74a9e2
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **51.9 MB (51924435 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:9ec93419a6674d0493e068dc7201413d1619e559fadb8f581a9b6e12bfe5c624`
-	Default Command: `["iex"]`

```dockerfile
# Wed, 24 May 2023 12:00:24 GMT
ADD file:6a6f0b0819f0c6585d2f9ef4edf9dc22a3f7ee9cba3de0b83dffb8f2a14dc3f3 in / 
# Wed, 24 May 2023 12:00:24 GMT
CMD ["/bin/sh"]
# Wed, 24 May 2023 12:00:24 GMT
ENV OTP_VERSION=25.3.2.13 REBAR3_VERSION=3.23.0
# Wed, 24 May 2023 12:00:24 GMT
LABEL org.opencontainers.image.version=25.3.2.13
# Wed, 24 May 2023 12:00:24 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="ef56f754f14ba89356284145c8a0dd95e11f00ec6142b4dd9a9431570d6ff5ea" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Wed, 24 May 2023 12:00:24 GMT
CMD ["erl"]
# Wed, 24 May 2023 12:00:24 GMT
ENV ELIXIR_VERSION=v1.14.5 LANG=C.UTF-8
# Wed, 24 May 2023 12:00:24 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="2ea249566c67e57f8365ecdcd0efd9b6c375f57609b3ac2de326488ac37c8ebd" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Wed, 24 May 2023 12:00:24 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:9747154b8e1c5a1d049032763040bd9a6319da995da6517c17ab2d18257f0aff`  
		Last Modified: Fri, 06 Sep 2024 22:08:45 GMT  
		Size: 2.9 MB (2911364 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:baecaab19ccb6742244952fb4d1615d0c75cc33d4b9c5ea06f528ec3646d64c9`  
		Last Modified: Sat, 07 Sep 2024 02:37:50 GMT  
		Size: 42.8 MB (42785952 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:49bb09789c406cb145a18e6597a3e991f6a7518e7300b27aa594e8632151553c`  
		Last Modified: Sat, 07 Sep 2024 14:06:31 GMT  
		Size: 6.2 MB (6227119 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.14-otp-25-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:91035c9933c05e6db2b9325d403f501fed4ea64a580f5d548926f65a7cb8b591
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **283.5 KB (283515 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:4787afa428a3d97f34cd39e02031869cce0756e641d887fdedf83d357f97a7f0`

```dockerfile
```

-	Layers:
	-	`sha256:9326a1a653169ccb76d45242d6d0f4459aa7ed3e22819f83670f729366578cda`  
		Last Modified: Sat, 07 Sep 2024 14:06:30 GMT  
		Size: 274.3 KB (274260 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:162eebdb87eccdb2d8299e3709155283148b748a3d0c65d94d346da88605d44c`  
		Last Modified: Sat, 07 Sep 2024 14:06:30 GMT  
		Size: 9.3 KB (9255 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.14-otp-25-alpine` - linux; arm64 variant v8

```console
$ docker pull elixir@sha256:5a9b6d90e304918b36bb77480154421aa00c655e1aee15c9e01078b5f998956e
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **54.2 MB (54213636 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:5d4f37e01a175d8605b5d8d3f0070f5050c2bb98d1ad678415c929bd058ab231`
-	Default Command: `["iex"]`

```dockerfile
# Wed, 24 May 2023 12:00:24 GMT
ADD file:c2dbff469fced00345f9627d1efd892f94d53dbb31a6485fa9411b2fb1b4840f in / 
# Wed, 24 May 2023 12:00:24 GMT
CMD ["/bin/sh"]
# Wed, 24 May 2023 12:00:24 GMT
ENV OTP_VERSION=25.3.2.13 REBAR3_VERSION=3.23.0
# Wed, 24 May 2023 12:00:24 GMT
LABEL org.opencontainers.image.version=25.3.2.13
# Wed, 24 May 2023 12:00:24 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="ef56f754f14ba89356284145c8a0dd95e11f00ec6142b4dd9a9431570d6ff5ea" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Wed, 24 May 2023 12:00:24 GMT
CMD ["erl"]
# Wed, 24 May 2023 12:00:24 GMT
ENV ELIXIR_VERSION=v1.14.5 LANG=C.UTF-8
# Wed, 24 May 2023 12:00:24 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="2ea249566c67e57f8365ecdcd0efd9b6c375f57609b3ac2de326488ac37c8ebd" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Wed, 24 May 2023 12:00:24 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:720f3032cd1105e6311c8adee3ee0f3b6827bec2c48f1cfff486a347ad22f05c`  
		Last Modified: Fri, 06 Sep 2024 22:44:58 GMT  
		Size: 3.3 MB (3340347 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:2d39a848718d1389c63b6ca712bd2cdf6f56efbe7e94545699ba0c6e4706939b`  
		Last Modified: Sat, 07 Sep 2024 05:11:23 GMT  
		Size: 44.6 MB (44645587 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:719328d4fc5eb204c89bc852c530602ec0ac66b4cc640de2ce85b0936c783a7f`  
		Last Modified: Sat, 07 Sep 2024 13:45:24 GMT  
		Size: 6.2 MB (6227702 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.14-otp-25-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:fc88d524f946dad7ec6c194ccad907e6e5c42c33394ff6ec1e2a700c0ff3472f
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **288.5 KB (288537 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:a232a1dfcbc871920f0e39a82e777334b4e4d0b9a97ee20a405e869407d0b99f`

```dockerfile
```

-	Layers:
	-	`sha256:ef4a524c561cd596a084a117b20b9fe20e600d10449b8d6665115d0b282e4219`  
		Last Modified: Sat, 07 Sep 2024 13:45:24 GMT  
		Size: 279.0 KB (278981 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:c1109a93df32d4ab20f362ddef9deee76df717f273e225d875401b8028e64c45`  
		Last Modified: Sat, 07 Sep 2024 13:45:24 GMT  
		Size: 9.6 KB (9556 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.14-otp-25-alpine` - linux; 386

```console
$ docker pull elixir@sha256:8a2e0caf84359ef6f13a8cc1ccb1e1e6194557de064ab749c240dd0900c6fa2d
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **53.1 MB (53107975 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:8e547eebdd9a7c89798008f0f52650ee7ed320a0db21bee702d79065c7d4f756`
-	Default Command: `["iex"]`

```dockerfile
# Wed, 24 May 2023 12:00:24 GMT
ADD file:3f9375bc94d18fade7e783bc4d3373e87c738a044bd90802cada5ca164406383 in / 
# Wed, 24 May 2023 12:00:24 GMT
CMD ["/bin/sh"]
# Wed, 24 May 2023 12:00:24 GMT
ENV OTP_VERSION=25.3.2.13 REBAR3_VERSION=3.23.0
# Wed, 24 May 2023 12:00:24 GMT
LABEL org.opencontainers.image.version=25.3.2.13
# Wed, 24 May 2023 12:00:24 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="ef56f754f14ba89356284145c8a0dd95e11f00ec6142b4dd9a9431570d6ff5ea" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Wed, 24 May 2023 12:00:24 GMT
CMD ["erl"]
# Wed, 24 May 2023 12:00:24 GMT
ENV ELIXIR_VERSION=v1.14.5 LANG=C.UTF-8
# Wed, 24 May 2023 12:00:24 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="2ea249566c67e57f8365ecdcd0efd9b6c375f57609b3ac2de326488ac37c8ebd" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Wed, 24 May 2023 12:00:24 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:174906c4031bcf6ff94e454d6ab4eb615c17d7526cb059d51b364fb429bfc6a7`  
		Last Modified: Fri, 06 Sep 2024 22:42:07 GMT  
		Size: 3.3 MB (3250469 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:8b2e2ffd89d8060090a0af13f0155658c06db6c47971dda29bad7136b57dd41f`  
		Last Modified: Fri, 06 Sep 2024 23:26:01 GMT  
		Size: 43.6 MB (43630391 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:70abe882ff87fbe0c1e03982a313b8e174e60bf54c89bf6442e66e40d4e7ee20`  
		Last Modified: Sat, 07 Sep 2024 00:11:35 GMT  
		Size: 6.2 MB (6227115 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.14-otp-25-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:ceaeb2a08e8aa40788b37a76e3bb82337e0e0cb79752182f038f9e6bd0db44ce
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **282.8 KB (282753 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:5dee47405d46ccd7c4c7ebbb4d9570b6e0ff2b4061b7cff9207dc21e3a0f5a7e`

```dockerfile
```

-	Layers:
	-	`sha256:2e708f21e1ef011cd4d8d3a30ff3fdf96a07a7effcfaefa95e5b0521b1ff2d41`  
		Last Modified: Sat, 07 Sep 2024 00:11:35 GMT  
		Size: 273.6 KB (273593 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:a480237cfaa791db51589f0dc2dd91dea2c179486ff522c9ca11fc6ee3b12a34`  
		Last Modified: Sat, 07 Sep 2024 00:11:35 GMT  
		Size: 9.2 KB (9160 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.14-otp-25-alpine` - linux; ppc64le

```console
$ docker pull elixir@sha256:0209f2e32464e543078a91740e6dde988383ef97bf8c4562eeab9468133144f6
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **53.3 MB (53322219 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:fec129899f2aa1db0b675ba5147a03d71e0f1c0f8f9451c78327831729df2805`
-	Default Command: `["iex"]`

```dockerfile
# Wed, 24 May 2023 12:00:24 GMT
ADD file:2b1a723fec64c757d924d7e1e007f92ef7f3d7e7c91198b52ccf7c47d5a4d10a in / 
# Wed, 24 May 2023 12:00:24 GMT
CMD ["/bin/sh"]
# Wed, 24 May 2023 12:00:24 GMT
ENV OTP_VERSION=25.3.2.13 REBAR3_VERSION=3.23.0
# Wed, 24 May 2023 12:00:24 GMT
LABEL org.opencontainers.image.version=25.3.2.13
# Wed, 24 May 2023 12:00:24 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="ef56f754f14ba89356284145c8a0dd95e11f00ec6142b4dd9a9431570d6ff5ea" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Wed, 24 May 2023 12:00:24 GMT
CMD ["erl"]
# Wed, 24 May 2023 12:00:24 GMT
ENV ELIXIR_VERSION=v1.14.5 LANG=C.UTF-8
# Wed, 24 May 2023 12:00:24 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="2ea249566c67e57f8365ecdcd0efd9b6c375f57609b3ac2de326488ac37c8ebd" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Wed, 24 May 2023 12:00:24 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:09f69d5d2e4b62e458d29b2e4d2542a265853dd015a23f55217326820e81d7d9`  
		Last Modified: Fri, 06 Sep 2024 22:26:59 GMT  
		Size: 3.4 MB (3358817 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:bdf619d1ef8c0c6ffc8e44862331f280a039fee4cd776ea3d6d74d2cd3b958f1`  
		Last Modified: Sat, 07 Sep 2024 06:46:11 GMT  
		Size: 43.7 MB (43736312 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:152bd47a325afa4d35bef957f369d5418d88259cd044234ff515178a341129f0`  
		Last Modified: Sat, 07 Sep 2024 13:47:53 GMT  
		Size: 6.2 MB (6227090 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.14-otp-25-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:e226e6bb61c3fbba4d829fb2102929e7871a9bddedad893adad9a89b07863058
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **281.5 KB (281535 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:fd20b44cde68be8fa33643bf8ca30058b631a840a8bfafa4f738ef65362aa3e8`

```dockerfile
```

-	Layers:
	-	`sha256:9fd328f6a49c3782231fad76de26d2c512856ca7ca7b64416d65064264385119`  
		Last Modified: Sat, 07 Sep 2024 13:47:53 GMT  
		Size: 272.3 KB (272308 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:80fce8a1f1b35dea4a74df3f6d0968b62c13471c9efae7ba326c86fbd9620646`  
		Last Modified: Sat, 07 Sep 2024 13:47:52 GMT  
		Size: 9.2 KB (9227 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.14-otp-25-alpine` - linux; s390x

```console
$ docker pull elixir@sha256:9ca4fff19348f742667bd05e6615c5a1283aabada43a5af97b422a75d689b3de
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **52.6 MB (52590635 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:a5cbafd9f3a7115b3d03074fef09633b217c1faa92384cd58aa869a2800c9fe5`
-	Default Command: `["iex"]`

```dockerfile
# Wed, 24 May 2023 12:00:24 GMT
ADD file:915212fdde86cc10e2c0038779562c7f4c2d80f238c5807ab3e6bf15c3f207ae in / 
# Wed, 24 May 2023 12:00:24 GMT
CMD ["/bin/sh"]
# Wed, 24 May 2023 12:00:24 GMT
ENV OTP_VERSION=25.3.2.13 REBAR3_VERSION=3.23.0
# Wed, 24 May 2023 12:00:24 GMT
LABEL org.opencontainers.image.version=25.3.2.13
# Wed, 24 May 2023 12:00:24 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="ef56f754f14ba89356284145c8a0dd95e11f00ec6142b4dd9a9431570d6ff5ea" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Wed, 24 May 2023 12:00:24 GMT
CMD ["erl"]
# Wed, 24 May 2023 12:00:24 GMT
ENV ELIXIR_VERSION=v1.14.5 LANG=C.UTF-8
# Wed, 24 May 2023 12:00:24 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="2ea249566c67e57f8365ecdcd0efd9b6c375f57609b3ac2de326488ac37c8ebd" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Wed, 24 May 2023 12:00:24 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:e1969bec132c5668fa6607cfae829c75ec87bce5e800a6cb6454687412d3c2db`  
		Last Modified: Fri, 06 Sep 2024 22:49:09 GMT  
		Size: 3.2 MB (3230415 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:24a7d723af7915223a56d053c90b35cbe3289d0173f329d25b7cc7e8e5630f32`  
		Last Modified: Sat, 07 Sep 2024 02:29:29 GMT  
		Size: 43.1 MB (43133187 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:5218b9a39bf295cece953a507af1f1e5fb07408180ebc1abd9187c191f9ffed7`  
		Last Modified: Sat, 07 Sep 2024 11:44:08 GMT  
		Size: 6.2 MB (6227033 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.14-otp-25-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:97c615a27c2e70ad8c065801542a78e2402eb0f206763b62096093dcc7d4d78c
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **281.5 KB (281481 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:e0db840c371f83a6716df13693ceb5c3bb2c7de6dbee0d1da6352112ab4c7a6b`

```dockerfile
```

-	Layers:
	-	`sha256:90e3c877ec6f35e052be00d55820e315291bed612bafb497204110e03f074d26`  
		Last Modified: Sat, 07 Sep 2024 11:44:08 GMT  
		Size: 272.3 KB (272286 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:5d3068514b2c06fddaf09beff9071c8498b9181f6576f20de0050712c9e9aa52`  
		Last Modified: Sat, 07 Sep 2024 11:44:08 GMT  
		Size: 9.2 KB (9195 bytes)  
		MIME: application/vnd.in-toto+json
