## `elixir:1.13-otp-25-alpine`

```console
$ docker pull elixir@sha256:dd256d3111cc74a8400c47fffe12ae044f39bd10a12a089f37bbd33961152c0d
```

-	Manifest MIME: `application/vnd.oci.image.index.v1+json`
-	Platforms: 12
	-	linux; amd64
	-	unknown; unknown
	-	linux; arm variant v7
	-	unknown; unknown
	-	linux; arm64 variant v8
	-	unknown; unknown
	-	linux; 386
	-	unknown; unknown
	-	linux; ppc64le
	-	unknown; unknown
	-	linux; s390x
	-	unknown; unknown

### `elixir:1.13-otp-25-alpine` - linux; amd64

```console
$ docker pull elixir@sha256:d0f1d812b1d1c305a9ff1e8b9823e5ca5a040e7b30c40aac70b1181d5d051d1a
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **54.2 MB (54239672 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:2d524a39e756702475da9a5dd5d0ef662dd983cde86a0e90e49cdedbb1543020`
-	Default Command: `["iex"]`

```dockerfile
# Mon, 30 May 2022 16:47:05 GMT
ADD file:5dd525c57625a3a84d57d435b3c255f417ad1722250faaf006c66b9090207f66 in / 
# Mon, 30 May 2022 16:47:05 GMT
CMD ["/bin/sh"]
# Mon, 30 May 2022 16:47:05 GMT
ENV OTP_VERSION=25.3.2.13 REBAR3_VERSION=3.23.0
# Mon, 30 May 2022 16:47:05 GMT
LABEL org.opencontainers.image.version=25.3.2.13
# Mon, 30 May 2022 16:47:05 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="ef56f754f14ba89356284145c8a0dd95e11f00ec6142b4dd9a9431570d6ff5ea" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Mon, 30 May 2022 16:47:05 GMT
CMD ["erl"]
# Mon, 30 May 2022 16:47:05 GMT
ENV ELIXIR_VERSION=v1.13.4 LANG=C.UTF-8
# Mon, 30 May 2022 16:47:05 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="95daf2dd3052e6ca7d4d849457eaaba09de52d65ca38d6933c65bc1cdf6b8579" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Mon, 30 May 2022 16:47:05 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:1cc3d825d8b2468ef662a8b631220516f492e24232477209fe863836d2d2ed44`  
		Last Modified: Fri, 06 Sep 2024 22:20:59 GMT  
		Size: 3.4 MB (3416313 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:ca4d98d30af08d5f78266d65c681b4a9c5349de4eb0cdcfbbc900567eb85834c`  
		Last Modified: Fri, 06 Sep 2024 23:25:28 GMT  
		Size: 44.8 MB (44842585 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:2386b27450c03125e3d0bcf1b70cc6bb3a6a531b76389a793246447e95bbd179`  
		Last Modified: Sat, 07 Sep 2024 00:11:09 GMT  
		Size: 6.0 MB (5980774 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.13-otp-25-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:f31b08a60aed1945805725471bed758a74db18f5ccb0db2b8891780d04538e15
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **287.5 KB (287499 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:2a9878d9b51b9e61256541a7a7de416f8d07976377682581f6bcfa4a582ef620`

```dockerfile
```

-	Layers:
	-	`sha256:295aed21c133be0b8a6119f16b0a99714955f56afaa51a437c7df4eee0f02705`  
		Last Modified: Sat, 07 Sep 2024 00:11:09 GMT  
		Size: 278.3 KB (278317 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:25206a2fa2ec5653735d938ae731a5a94886def4cf7302351e1b26dd20858761`  
		Last Modified: Sat, 07 Sep 2024 00:11:09 GMT  
		Size: 9.2 KB (9182 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.13-otp-25-alpine` - linux; arm variant v7

```console
$ docker pull elixir@sha256:c831b2609824b89e6b3e6e23f521f6be8d42a1d664c05556ccc63857b34acb56
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **51.7 MB (51677431 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:3e3144896bbeb12f247d8ae79ef03e09ca4a2f1b2f938185bf3eab7ab604242d`
-	Default Command: `["iex"]`

```dockerfile
# Mon, 30 May 2022 16:47:05 GMT
ADD file:6a6f0b0819f0c6585d2f9ef4edf9dc22a3f7ee9cba3de0b83dffb8f2a14dc3f3 in / 
# Mon, 30 May 2022 16:47:05 GMT
CMD ["/bin/sh"]
# Mon, 30 May 2022 16:47:05 GMT
ENV OTP_VERSION=25.3.2.13 REBAR3_VERSION=3.23.0
# Mon, 30 May 2022 16:47:05 GMT
LABEL org.opencontainers.image.version=25.3.2.13
# Mon, 30 May 2022 16:47:05 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="ef56f754f14ba89356284145c8a0dd95e11f00ec6142b4dd9a9431570d6ff5ea" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Mon, 30 May 2022 16:47:05 GMT
CMD ["erl"]
# Mon, 30 May 2022 16:47:05 GMT
ENV ELIXIR_VERSION=v1.13.4 LANG=C.UTF-8
# Mon, 30 May 2022 16:47:05 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="95daf2dd3052e6ca7d4d849457eaaba09de52d65ca38d6933c65bc1cdf6b8579" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Mon, 30 May 2022 16:47:05 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:9747154b8e1c5a1d049032763040bd9a6319da995da6517c17ab2d18257f0aff`  
		Last Modified: Fri, 06 Sep 2024 22:08:45 GMT  
		Size: 2.9 MB (2911364 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:baecaab19ccb6742244952fb4d1615d0c75cc33d4b9c5ea06f528ec3646d64c9`  
		Last Modified: Sat, 07 Sep 2024 02:37:50 GMT  
		Size: 42.8 MB (42785952 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:4ffc171f4b9fde339183d12975d7d739a7af770897b8e548d1768900a322c727`  
		Last Modified: Sat, 07 Sep 2024 14:08:50 GMT  
		Size: 6.0 MB (5980115 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.13-otp-25-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:abb51fef8b86d230e272d6f2dc39e40ce30bf673562e306588e046242ee4717d
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **283.5 KB (283515 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:337aa82940ee2359614b403225fe9b2e82dfe239b7da2d05ba3ff97fb73e4c34`

```dockerfile
```

-	Layers:
	-	`sha256:ea573e2fafdc0c4ca1fdd9d9af2846cd14303463bd919141cf13ebcbef371854`  
		Last Modified: Sat, 07 Sep 2024 14:08:50 GMT  
		Size: 274.3 KB (274260 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:2cb61a7d25b10e8bfec649295c4223a63fff9aa0a99538619e1af476b4d66461`  
		Last Modified: Sat, 07 Sep 2024 14:08:50 GMT  
		Size: 9.3 KB (9255 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.13-otp-25-alpine` - linux; arm64 variant v8

```console
$ docker pull elixir@sha256:2749f0c4536136eb3f090ea62bb5969833196391cd63f52fede61fc428ae8f5a
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **54.0 MB (53966707 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:c92565d941f1f69aa8274113a066431d21ac013991052479cb753456434c432c`
-	Default Command: `["iex"]`

```dockerfile
# Mon, 30 May 2022 16:47:05 GMT
ADD file:c2dbff469fced00345f9627d1efd892f94d53dbb31a6485fa9411b2fb1b4840f in / 
# Mon, 30 May 2022 16:47:05 GMT
CMD ["/bin/sh"]
# Mon, 30 May 2022 16:47:05 GMT
ENV OTP_VERSION=25.3.2.13 REBAR3_VERSION=3.23.0
# Mon, 30 May 2022 16:47:05 GMT
LABEL org.opencontainers.image.version=25.3.2.13
# Mon, 30 May 2022 16:47:05 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="ef56f754f14ba89356284145c8a0dd95e11f00ec6142b4dd9a9431570d6ff5ea" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Mon, 30 May 2022 16:47:05 GMT
CMD ["erl"]
# Mon, 30 May 2022 16:47:05 GMT
ENV ELIXIR_VERSION=v1.13.4 LANG=C.UTF-8
# Mon, 30 May 2022 16:47:05 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="95daf2dd3052e6ca7d4d849457eaaba09de52d65ca38d6933c65bc1cdf6b8579" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Mon, 30 May 2022 16:47:05 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:720f3032cd1105e6311c8adee3ee0f3b6827bec2c48f1cfff486a347ad22f05c`  
		Last Modified: Fri, 06 Sep 2024 22:44:58 GMT  
		Size: 3.3 MB (3340347 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:2d39a848718d1389c63b6ca712bd2cdf6f56efbe7e94545699ba0c6e4706939b`  
		Last Modified: Sat, 07 Sep 2024 05:11:23 GMT  
		Size: 44.6 MB (44645587 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:4d019ebd3c54a970a6a99f5c9f6696f7c32f6aebc6cce4248f71f327e37f240e`  
		Last Modified: Sat, 07 Sep 2024 13:47:11 GMT  
		Size: 6.0 MB (5980773 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.13-otp-25-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:6880e75f90438d7ed6edd19162dca7f07025f49bf968177c65c95fb17cf7e194
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **288.5 KB (288536 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:a347d14be2382f2cfbdf946a5ded74613469e8323e5dff1bdd596f8e4786c736`

```dockerfile
```

-	Layers:
	-	`sha256:ecc18bc2bda2b54f4f420e93609da125f1e17376e839c246531365657b77e592`  
		Last Modified: Sat, 07 Sep 2024 13:47:10 GMT  
		Size: 279.0 KB (278981 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:761f1e052820f3d428a76b0f2ebc25aa4b7d91cf1c051b9014eb913e9190b638`  
		Last Modified: Sat, 07 Sep 2024 13:47:10 GMT  
		Size: 9.6 KB (9555 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.13-otp-25-alpine` - linux; 386

```console
$ docker pull elixir@sha256:54f404308615d28c0e936d1e6a0e81d891e26b70442987663996e08470920fa0
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **52.9 MB (52860962 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:61ec2e901bb4136201efe48abb4d2782474adedfbd3ce1aaa99c595dc7541e0d`
-	Default Command: `["iex"]`

```dockerfile
# Mon, 30 May 2022 16:47:05 GMT
ADD file:3f9375bc94d18fade7e783bc4d3373e87c738a044bd90802cada5ca164406383 in / 
# Mon, 30 May 2022 16:47:05 GMT
CMD ["/bin/sh"]
# Mon, 30 May 2022 16:47:05 GMT
ENV OTP_VERSION=25.3.2.13 REBAR3_VERSION=3.23.0
# Mon, 30 May 2022 16:47:05 GMT
LABEL org.opencontainers.image.version=25.3.2.13
# Mon, 30 May 2022 16:47:05 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="ef56f754f14ba89356284145c8a0dd95e11f00ec6142b4dd9a9431570d6ff5ea" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Mon, 30 May 2022 16:47:05 GMT
CMD ["erl"]
# Mon, 30 May 2022 16:47:05 GMT
ENV ELIXIR_VERSION=v1.13.4 LANG=C.UTF-8
# Mon, 30 May 2022 16:47:05 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="95daf2dd3052e6ca7d4d849457eaaba09de52d65ca38d6933c65bc1cdf6b8579" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Mon, 30 May 2022 16:47:05 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:174906c4031bcf6ff94e454d6ab4eb615c17d7526cb059d51b364fb429bfc6a7`  
		Last Modified: Fri, 06 Sep 2024 22:42:07 GMT  
		Size: 3.3 MB (3250469 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:8b2e2ffd89d8060090a0af13f0155658c06db6c47971dda29bad7136b57dd41f`  
		Last Modified: Fri, 06 Sep 2024 23:26:01 GMT  
		Size: 43.6 MB (43630391 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:e5835430ab66dcab2f2366f3493f94451472534fba1b52e00773347acf5eb402`  
		Last Modified: Sat, 07 Sep 2024 00:11:49 GMT  
		Size: 6.0 MB (5980102 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.13-otp-25-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:1e9ea43f49c5dca0f6ec3ee7c942247a75bf90d7a79e4751719da7ea2a30e0f0
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **282.8 KB (282754 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:fd36f69b66d93db7119efdc38bf82eff4c67e25a6259f2b09c983e0ea652c6f9`

```dockerfile
```

-	Layers:
	-	`sha256:b00e92fa9ba9d5750a7cf267ed6a970157c721aa45df5e131c88b28236985b38`  
		Last Modified: Sat, 07 Sep 2024 00:11:49 GMT  
		Size: 273.6 KB (273593 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:a7c7bd4ab132e7e6ca3fe0656849d02442235274cc51361645b9da2cb895fae9`  
		Last Modified: Sat, 07 Sep 2024 00:11:49 GMT  
		Size: 9.2 KB (9161 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.13-otp-25-alpine` - linux; ppc64le

```console
$ docker pull elixir@sha256:3fd7283f796d9b71205317c18a67978287120e044c73cc2a72c5642db615a892
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **53.1 MB (53075271 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:27833a2fb3d4bf5d4202730d390c3240ca6b4157e97461090b72aaa9908cab34`
-	Default Command: `["iex"]`

```dockerfile
# Mon, 30 May 2022 16:47:05 GMT
ADD file:2b1a723fec64c757d924d7e1e007f92ef7f3d7e7c91198b52ccf7c47d5a4d10a in / 
# Mon, 30 May 2022 16:47:05 GMT
CMD ["/bin/sh"]
# Mon, 30 May 2022 16:47:05 GMT
ENV OTP_VERSION=25.3.2.13 REBAR3_VERSION=3.23.0
# Mon, 30 May 2022 16:47:05 GMT
LABEL org.opencontainers.image.version=25.3.2.13
# Mon, 30 May 2022 16:47:05 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="ef56f754f14ba89356284145c8a0dd95e11f00ec6142b4dd9a9431570d6ff5ea" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Mon, 30 May 2022 16:47:05 GMT
CMD ["erl"]
# Mon, 30 May 2022 16:47:05 GMT
ENV ELIXIR_VERSION=v1.13.4 LANG=C.UTF-8
# Mon, 30 May 2022 16:47:05 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="95daf2dd3052e6ca7d4d849457eaaba09de52d65ca38d6933c65bc1cdf6b8579" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Mon, 30 May 2022 16:47:05 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:09f69d5d2e4b62e458d29b2e4d2542a265853dd015a23f55217326820e81d7d9`  
		Last Modified: Fri, 06 Sep 2024 22:26:59 GMT  
		Size: 3.4 MB (3358817 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:bdf619d1ef8c0c6ffc8e44862331f280a039fee4cd776ea3d6d74d2cd3b958f1`  
		Last Modified: Sat, 07 Sep 2024 06:46:11 GMT  
		Size: 43.7 MB (43736312 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:4fe0950e01853c5062b733ecfa0597971b0cd9ce2f1938ff7d0b33e9217b6e4e`  
		Last Modified: Sat, 07 Sep 2024 13:51:33 GMT  
		Size: 6.0 MB (5980142 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.13-otp-25-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:2a9df83a34ad60a8dc82be31d9df0b1d8ecb197ae14fd45b06982885f51d5877
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **281.5 KB (281535 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:dd71dcfb14a2eedda556ef3afffc92ec8e582cc1d8d24799f281adbfac20a54b`

```dockerfile
```

-	Layers:
	-	`sha256:bf4c2b1da2b5e3cd4012c2876b824da7e4962d0e290015afb00520b83c884d51`  
		Last Modified: Sat, 07 Sep 2024 13:51:33 GMT  
		Size: 272.3 KB (272308 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:303d8bada061d57daa33df7874f3574109d0e4613f2da81cdac988998c01b774`  
		Last Modified: Sat, 07 Sep 2024 13:51:33 GMT  
		Size: 9.2 KB (9227 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.13-otp-25-alpine` - linux; s390x

```console
$ docker pull elixir@sha256:3bcc691b97bf9322e408de72361e0d700eb241d765be7cd85c6c0540ca4ca1ed
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **52.3 MB (52343831 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:a8667bbdcc86280ceb28adcef6a8fc41a11506f1123ce0176fa67d0b5ac5dfc4`
-	Default Command: `["iex"]`

```dockerfile
# Mon, 30 May 2022 16:47:05 GMT
ADD file:915212fdde86cc10e2c0038779562c7f4c2d80f238c5807ab3e6bf15c3f207ae in / 
# Mon, 30 May 2022 16:47:05 GMT
CMD ["/bin/sh"]
# Mon, 30 May 2022 16:47:05 GMT
ENV OTP_VERSION=25.3.2.13 REBAR3_VERSION=3.23.0
# Mon, 30 May 2022 16:47:05 GMT
LABEL org.opencontainers.image.version=25.3.2.13
# Mon, 30 May 2022 16:47:05 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="ef56f754f14ba89356284145c8a0dd95e11f00ec6142b4dd9a9431570d6ff5ea" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Mon, 30 May 2022 16:47:05 GMT
CMD ["erl"]
# Mon, 30 May 2022 16:47:05 GMT
ENV ELIXIR_VERSION=v1.13.4 LANG=C.UTF-8
# Mon, 30 May 2022 16:47:05 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="95daf2dd3052e6ca7d4d849457eaaba09de52d65ca38d6933c65bc1cdf6b8579" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Mon, 30 May 2022 16:47:05 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:e1969bec132c5668fa6607cfae829c75ec87bce5e800a6cb6454687412d3c2db`  
		Last Modified: Fri, 06 Sep 2024 22:49:09 GMT  
		Size: 3.2 MB (3230415 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:24a7d723af7915223a56d053c90b35cbe3289d0173f329d25b7cc7e8e5630f32`  
		Last Modified: Sat, 07 Sep 2024 02:29:29 GMT  
		Size: 43.1 MB (43133187 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:abc35934ed938adefc36a1cf5ba214dbbbe247bb079540d223b62957016ae853`  
		Last Modified: Sat, 07 Sep 2024 11:46:31 GMT  
		Size: 6.0 MB (5980229 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.13-otp-25-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:cad9fd9f17b0edadb08cf8f3ddf0dca8aa1961b36a991c59797f7dab084d87cd
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **281.5 KB (281481 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:6a397a047ab0fb345eedea9baa7d33bf382dc5c79905d58509702484ee8dd4f3`

```dockerfile
```

-	Layers:
	-	`sha256:846f997d16cb83068794e5aca48249e2df4b824b67a470dcd9e6aa2c66229141`  
		Last Modified: Sat, 07 Sep 2024 11:46:31 GMT  
		Size: 272.3 KB (272286 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:33b630ef6929dc91e8948ff7c672cc7bb919065cda7d1cea867dadf7e4077d20`  
		Last Modified: Sat, 07 Sep 2024 11:46:31 GMT  
		Size: 9.2 KB (9195 bytes)  
		MIME: application/vnd.in-toto+json
