## `elixir:1.13-otp-24-alpine`

```console
$ docker pull elixir@sha256:8e660ddb91c5e75a868b79390f1b1b3bb848e338c88b35c3723db1c5f111c1c1
```

-	Manifest MIME: `application/vnd.oci.image.index.v1+json`
-	Platforms: 12
	-	linux; amd64
	-	unknown; unknown
	-	linux; arm variant v7
	-	unknown; unknown
	-	linux; arm64 variant v8
	-	unknown; unknown
	-	linux; 386
	-	unknown; unknown
	-	linux; ppc64le
	-	unknown; unknown
	-	linux; s390x
	-	unknown; unknown

### `elixir:1.13-otp-24-alpine` - linux; amd64

```console
$ docker pull elixir@sha256:7d9fe2057c022c037420ac3a21ebaf58e064fc271aab330c0b6789442840d593
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **55.0 MB (55029121 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:aa7b9a45ea5c5b92c3b6035eebca24590a556f067f6e59465f1fb243b5830248`
-	Default Command: `["iex"]`

```dockerfile
# Wed, 13 Apr 2022 15:24:18 GMT
ADD file:8bf458f5fbed9f27c897506538c02fb5810b70aba850bb883d2120985fa15bac in / 
# Wed, 13 Apr 2022 15:24:18 GMT
CMD ["/bin/sh"]
# Wed, 13 Apr 2022 15:24:18 GMT
ENV OTP_VERSION=24.3.4.17 REBAR3_VERSION=3.23.0
# Wed, 13 Apr 2022 15:24:18 GMT
LABEL org.opencontainers.image.version=24.3.4.17
# Wed, 13 Apr 2022 15:24:18 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="35f88a3af4d4885c5c17bcb8611da2d19f0626faa277392cd39c445254c015a2" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Wed, 13 Apr 2022 15:24:18 GMT
CMD ["erl"]
# Wed, 13 Apr 2022 15:24:18 GMT
ENV ELIXIR_VERSION=v1.13.4 LANG=C.UTF-8
# Wed, 13 Apr 2022 15:24:18 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="95daf2dd3052e6ca7d4d849457eaaba09de52d65ca38d6933c65bc1cdf6b8579" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Wed, 13 Apr 2022 15:24:18 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:a0f4cbe03b6df9e61ce02b3c41bbc05481842858bd48d9687614abe719303b47`  
		Last Modified: Fri, 06 Sep 2024 22:21:07 GMT  
		Size: 3.4 MB (3392194 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:877ef79c8b6ebbcc280c4b3037ed2d0c46e22d4e5ee9df5473c1378c2d59609c`  
		Last Modified: Fri, 06 Sep 2024 23:25:43 GMT  
		Size: 45.7 MB (45675109 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:18eac46cdc919e4f45f39f467dd220c910bd751ba7e67c759882e272893c5315`  
		Last Modified: Sat, 07 Sep 2024 00:11:08 GMT  
		Size: 6.0 MB (5961818 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.13-otp-24-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:533f82c9f48e1577f6ae67d55babb8c140bcbc1967f416e9658e44e788cb88ca
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **290.4 KB (290391 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:126af9fe1bb151a359b8a93abef9631c406d224b767eee9e9db09ca3b84f886c`

```dockerfile
```

-	Layers:
	-	`sha256:5352cea44997e174835f3985ab44bff3a98a4982002f8a3be7b8bdb852c0360d`  
		Last Modified: Sat, 07 Sep 2024 00:11:08 GMT  
		Size: 280.6 KB (280602 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:b9282721b395b288e0ba67e29f0247bd7a9f03ae605e5c128662fced2cf76b4a`  
		Last Modified: Sat, 07 Sep 2024 00:11:08 GMT  
		Size: 9.8 KB (9789 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.13-otp-24-alpine` - linux; arm variant v7

```console
$ docker pull elixir@sha256:7a6d1d7359241207ed9a87661070428f4d9d0f7ad4840067162c2c13492d9c1b
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **52.5 MB (52491070 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:a34c02464cfbdf256f1a9c1f8dd8a3b06a342d8c9612d70483b41581416467d9`
-	Default Command: `["iex"]`

```dockerfile
# Wed, 13 Apr 2022 15:24:18 GMT
ADD file:014b71b310731c8d9c3e2d83e0f2dca75d9a967f6b57ebf8f0b1f2e4c191bac6 in / 
# Wed, 13 Apr 2022 15:24:18 GMT
CMD ["/bin/sh"]
# Wed, 13 Apr 2022 15:24:18 GMT
ENV OTP_VERSION=24.3.4.17 REBAR3_VERSION=3.23.0
# Wed, 13 Apr 2022 15:24:18 GMT
LABEL org.opencontainers.image.version=24.3.4.17
# Wed, 13 Apr 2022 15:24:18 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="35f88a3af4d4885c5c17bcb8611da2d19f0626faa277392cd39c445254c015a2" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Wed, 13 Apr 2022 15:24:18 GMT
CMD ["erl"]
# Wed, 13 Apr 2022 15:24:18 GMT
ENV ELIXIR_VERSION=v1.13.4 LANG=C.UTF-8
# Wed, 13 Apr 2022 15:24:18 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="95daf2dd3052e6ca7d4d849457eaaba09de52d65ca38d6933c65bc1cdf6b8579" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Wed, 13 Apr 2022 15:24:18 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:d3db245ecf824e043961daa651b032eaec8dce179b09df9d66696c5b8fb05275`  
		Last Modified: Fri, 06 Sep 2024 22:08:56 GMT  
		Size: 2.9 MB (2880445 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:e96a04c701bb96ae45b95c7ada674a863dc710657718483c77661efc6eace6b2`  
		Last Modified: Sat, 07 Sep 2024 02:42:23 GMT  
		Size: 43.6 MB (43649093 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:1472ce3ff05f6e9099a84466be9b68aa2b127af133e366efbf3ad0934e22ed2d`  
		Last Modified: Sat, 07 Sep 2024 14:07:39 GMT  
		Size: 6.0 MB (5961532 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.13-otp-24-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:053f7cbe85997b10b65ded05c90e087212f742e76e48c321eb976d68c18a8f46
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **286.4 KB (286444 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:1fe385b7b719be3250aa37796ee02ee2b961bec11cd2e62a7c7cf2049dc96d30`

```dockerfile
```

-	Layers:
	-	`sha256:cbd75432d591668d6bcd030f288c15ebeeb2d071517ca14ea68063d0860441c4`  
		Last Modified: Sat, 07 Sep 2024 14:07:38 GMT  
		Size: 276.6 KB (276567 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:3b62e01c82b81683525de4f4042951ca3660b29974dbf270a7c17784fb052239`  
		Last Modified: Sat, 07 Sep 2024 14:07:38 GMT  
		Size: 9.9 KB (9877 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.13-otp-24-alpine` - linux; arm64 variant v8

```console
$ docker pull elixir@sha256:92ddb720bd8154e7d493c9bec6b8e6d59c1e52741ec97c390382fd457d4c8ba0
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **53.6 MB (53574901 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:4c1313f302c6fd8297b20053768e4da6ef8134ccbf483d2b4891b67020a2f137`
-	Default Command: `["iex"]`

```dockerfile
# Wed, 13 Apr 2022 15:24:18 GMT
ADD file:e3f989df31d7e2d820078058c5d0ed7d98695c5b86bd172276270ebb59d75ee6 in / 
# Wed, 13 Apr 2022 15:24:18 GMT
CMD ["/bin/sh"]
# Wed, 13 Apr 2022 15:24:18 GMT
ENV OTP_VERSION=24.3.4.17 REBAR3_VERSION=3.23.0
# Wed, 13 Apr 2022 15:24:18 GMT
LABEL org.opencontainers.image.version=24.3.4.17
# Wed, 13 Apr 2022 15:24:18 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="35f88a3af4d4885c5c17bcb8611da2d19f0626faa277392cd39c445254c015a2" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Wed, 13 Apr 2022 15:24:18 GMT
CMD ["erl"]
# Wed, 13 Apr 2022 15:24:18 GMT
ENV ELIXIR_VERSION=v1.13.4 LANG=C.UTF-8
# Wed, 13 Apr 2022 15:24:18 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="95daf2dd3052e6ca7d4d849457eaaba09de52d65ca38d6933c65bc1cdf6b8579" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Wed, 13 Apr 2022 15:24:18 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:4a3d188841b4b0359cda0d73dc5f89f8bc569f3bcb178cfd0507b4ead0db7bf4`  
		Last Modified: Fri, 06 Sep 2024 22:45:06 GMT  
		Size: 3.3 MB (3275072 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:8084f4a75c1336c069e26d28b3a4d775281bcd18abebe94ab3ad1dfa98dc7f77`  
		Last Modified: Sat, 07 Sep 2024 05:14:41 GMT  
		Size: 44.3 MB (44338268 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:b4a70c28befa820c103452e5dd532c1e837157a1adb041a6b839513cdf305350`  
		Last Modified: Sat, 07 Sep 2024 13:46:21 GMT  
		Size: 6.0 MB (5961561 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.13-otp-24-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:81eadc867dbf366698c0f57469a7448a06dd6cbafa6495aeff3ed3a17a61eb37
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **286.8 KB (286773 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:0d9bf8a65046fa223bd53404de3a79c8038ec6cd2ed360e50302cf8cff44e341`

```dockerfile
```

-	Layers:
	-	`sha256:bff1c11b86b312be8c2ae4900925c7e64baa48cbc8c31098e5da1c136ad82648`  
		Last Modified: Sat, 07 Sep 2024 13:46:21 GMT  
		Size: 276.6 KB (276587 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:953fa07de49fe57660973d6fbf81802ad5c4960848d8505b29a9c03714e6d961`  
		Last Modified: Sat, 07 Sep 2024 13:46:21 GMT  
		Size: 10.2 KB (10186 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.13-otp-24-alpine` - linux; 386

```console
$ docker pull elixir@sha256:2888c222d65ca8c10ec6f30129f23cd1a6bf11e515eafb6b36364c224ce4f7a9
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **53.9 MB (53910932 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:9f3865a92f6a3cd3a1a1d408cb630eead3b4467c119ddf97bd2fe7bddae67ead`
-	Default Command: `["iex"]`

```dockerfile
# Wed, 13 Apr 2022 15:24:18 GMT
ADD file:feac7e958e372a2dca23a553e40742be1b2996af7cd9232c8340e9ae54967805 in / 
# Wed, 13 Apr 2022 15:24:18 GMT
CMD ["/bin/sh"]
# Wed, 13 Apr 2022 15:24:18 GMT
ENV OTP_VERSION=24.3.4.17 REBAR3_VERSION=3.23.0
# Wed, 13 Apr 2022 15:24:18 GMT
LABEL org.opencontainers.image.version=24.3.4.17
# Wed, 13 Apr 2022 15:24:18 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="35f88a3af4d4885c5c17bcb8611da2d19f0626faa277392cd39c445254c015a2" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Wed, 13 Apr 2022 15:24:18 GMT
CMD ["erl"]
# Wed, 13 Apr 2022 15:24:18 GMT
ENV ELIXIR_VERSION=v1.13.4 LANG=C.UTF-8
# Wed, 13 Apr 2022 15:24:18 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="95daf2dd3052e6ca7d4d849457eaaba09de52d65ca38d6933c65bc1cdf6b8579" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Wed, 13 Apr 2022 15:24:18 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:839f67384288aa01620e781de32c456baada9f9c0f96cdd5f5a36e68c84d772c`  
		Last Modified: Fri, 06 Sep 2024 22:42:15 GMT  
		Size: 3.4 MB (3426442 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:b3c77c6696e3c7a68ee2a752d991a6b31640e979d7114b95feb8dcb8d28be5c1`  
		Last Modified: Fri, 06 Sep 2024 23:25:54 GMT  
		Size: 44.5 MB (44522891 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:4f35332cdd742f8b8faa6b68ddf1e1301babca1a8d33487fc088a30d3e17c458`  
		Last Modified: Sat, 07 Sep 2024 00:11:34 GMT  
		Size: 6.0 MB (5961599 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.13-otp-24-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:8c6112a9aabda1c3ffc7b9ab3b7fe527337720ce3f1dc795ec0de1619cd4f4f4
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **285.6 KB (285630 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:30f87be2e6bb65384802c57b46f50b9a9638410d8cd7e90106d8c4cf629194d5`

```dockerfile
```

-	Layers:
	-	`sha256:39b1c14d33768c97527cd926ac29c483666b71ce96ce59605e3193bb0cba4b58`  
		Last Modified: Sat, 07 Sep 2024 00:11:34 GMT  
		Size: 275.9 KB (275874 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:f090367369fe63013728640afcd4e24ae42f696f4a52e9d6310de41b794ad2d9`  
		Last Modified: Sat, 07 Sep 2024 00:11:34 GMT  
		Size: 9.8 KB (9756 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.13-otp-24-alpine` - linux; ppc64le

```console
$ docker pull elixir@sha256:efeea4c0253cd15e8cc71e5046faabacd91b4eb8c7ce23889a6932dd66cc69d9
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **53.9 MB (53933885 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:3827a296636c3160b69cb3b314018147f2afca88a8673f6d7046660c05480792`
-	Default Command: `["iex"]`

```dockerfile
# Wed, 13 Apr 2022 15:24:18 GMT
ADD file:8e93ade46c1e2ad1fbc7efcd43adf6e1c006958a20176ae01e3f1fd71cec7068 in / 
# Wed, 13 Apr 2022 15:24:18 GMT
CMD ["/bin/sh"]
# Wed, 13 Apr 2022 15:24:18 GMT
ENV OTP_VERSION=24.3.4.17 REBAR3_VERSION=3.23.0
# Wed, 13 Apr 2022 15:24:18 GMT
LABEL org.opencontainers.image.version=24.3.4.17
# Wed, 13 Apr 2022 15:24:18 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="35f88a3af4d4885c5c17bcb8611da2d19f0626faa277392cd39c445254c015a2" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Wed, 13 Apr 2022 15:24:18 GMT
CMD ["erl"]
# Wed, 13 Apr 2022 15:24:18 GMT
ENV ELIXIR_VERSION=v1.13.4 LANG=C.UTF-8
# Wed, 13 Apr 2022 15:24:18 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="95daf2dd3052e6ca7d4d849457eaaba09de52d65ca38d6933c65bc1cdf6b8579" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Wed, 13 Apr 2022 15:24:18 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:28694696b581828747353f19fe23a3b907a04f4253df6689f2d7974008500895`  
		Last Modified: Fri, 06 Sep 2024 22:27:08 GMT  
		Size: 3.4 MB (3403863 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:97a913648de7a4438392d5486c945e8eef6f18ae7ceda47692b2f2bc56a6b465`  
		Last Modified: Sat, 07 Sep 2024 06:51:11 GMT  
		Size: 44.6 MB (44568355 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:08c001c9078cd80f4d8b977ab48ecb723c94ceeb83771cb119ffab17086c7fe2`  
		Last Modified: Sat, 07 Sep 2024 13:49:43 GMT  
		Size: 6.0 MB (5961667 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.13-otp-24-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:a6d3769b70133f206598a0455f31c52f3c4a883aba6abd560373f8b6efb8e7c8
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **284.5 KB (284455 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:e5f07092ae6bf993e91e89f1a9d3afaccf7e8312d3019537103509c27db9ae0b`

```dockerfile
```

-	Layers:
	-	`sha256:a420395e24288c6ce101161642a235339a58dbd18bebd1f86519f65975e7bb21`  
		Last Modified: Sat, 07 Sep 2024 13:49:43 GMT  
		Size: 274.6 KB (274611 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:f5b665999f41b3b21138a225b5d23574692f2e9950ab3b11fddabc967f535b33`  
		Last Modified: Sat, 07 Sep 2024 13:49:43 GMT  
		Size: 9.8 KB (9844 bytes)  
		MIME: application/vnd.in-toto+json

### `elixir:1.13-otp-24-alpine` - linux; s390x

```console
$ docker pull elixir@sha256:f578d711f49293d540c7fd273af67428aed03c08d563193d173c3a0e63b4629a
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **53.0 MB (53015043 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:f3913bad8cf2b3ced030ac17f1eef9b0f11668f22c76cf981dca9e3603f2ecca`
-	Default Command: `["iex"]`

```dockerfile
# Wed, 13 Apr 2022 15:24:18 GMT
ADD file:0ca442b357bdecba3d8ffec7a25ce8efd1d3f8093408739f37e8f946f8937512 in / 
# Wed, 13 Apr 2022 15:24:18 GMT
CMD ["/bin/sh"]
# Wed, 13 Apr 2022 15:24:18 GMT
ENV OTP_VERSION=24.3.4.17 REBAR3_VERSION=3.23.0
# Wed, 13 Apr 2022 15:24:18 GMT
LABEL org.opencontainers.image.version=24.3.4.17
# Wed, 13 Apr 2022 15:24:18 GMT
RUN set -xe 	&& OTP_DOWNLOAD_URL="https://github.com/erlang/otp/archive/OTP-${OTP_VERSION}.tar.gz" 	&& OTP_DOWNLOAD_SHA256="35f88a3af4d4885c5c17bcb8611da2d19f0626faa277392cd39c445254c015a2" 	&& REBAR3_DOWNLOAD_SHA256="00646b692762ffd340560e8f16486dbda840e1546749ee5a7f58feeb77e7b516" 	&& apk add --no-cache --virtual .fetch-deps 		curl 		ca-certificates 	&& curl -fSL -o otp-src.tar.gz "$OTP_DOWNLOAD_URL" 	&& echo "$OTP_DOWNLOAD_SHA256  otp-src.tar.gz" | sha256sum -c - 	&& apk add --no-cache --virtual .build-deps 		dpkg-dev dpkg 		gcc 		g++ 		libc-dev 		linux-headers 		make 		autoconf 		ncurses-dev 		openssl-dev 		unixodbc-dev 		lksctp-tools-dev 		tar 	&& export ERL_TOP="/usr/src/otp_src_${OTP_VERSION%%@*}" 	&& mkdir -vp $ERL_TOP 	&& tar -xzf otp-src.tar.gz -C $ERL_TOP --strip-components=1 	&& rm otp-src.tar.gz 	&& ( cd $ERL_TOP 	  && ./otp_build autoconf 	  && gnuArch="$(dpkg-architecture --query DEB_HOST_GNU_TYPE)" 	  && ./configure --build="$gnuArch" 	  && make -j$(getconf _NPROCESSORS_ONLN) 	  && make install ) 	&& rm -rf $ERL_TOP 	&& find /usr/local -regex '/usr/local/lib/erlang/\(lib/\|erts-\).*/\(man\|doc\|obj\|c_src\|emacs\|info\|examples\)' | xargs rm -rf 	&& find /usr/local -name src | xargs -r find | grep -v '\.hrl$' | xargs rm -v || true 	&& find /usr/local -name src | xargs -r find | xargs rmdir -vp || true 	&& scanelf --nobanner -E ET_EXEC -BF '%F' --recursive /usr/local | xargs -r strip --strip-all 	&& scanelf --nobanner -E ET_DYN -BF '%F' --recursive /usr/local | xargs -r strip --strip-unneeded 	&& runDeps="$( 		scanelf --needed --nobanner --format '%n#p' --recursive /usr/local 			| tr ',' '\n' 			| sort -u 			| awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' 	)" 	&& REBAR3_DOWNLOAD_URL="https://github.com/erlang/rebar3/archive/${REBAR3_VERSION}.tar.gz" 	&& curl -fSL -o rebar3-src.tar.gz "$REBAR3_DOWNLOAD_URL" 	&& echo "${REBAR3_DOWNLOAD_SHA256}  rebar3-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/src/rebar3-src 	&& tar -xzf rebar3-src.tar.gz -C /usr/src/rebar3-src --strip-components=1 	&& rm rebar3-src.tar.gz 	&& cd /usr/src/rebar3-src 	&& HOME=$PWD ./bootstrap 	&& install -v ./rebar3 /usr/local/bin/ 	&& rm -rf /usr/src/rebar3-src 	&& apk add --virtual .erlang-rundeps 		$runDeps 		lksctp-tools 		ca-certificates 	&& apk del .fetch-deps .build-deps # buildkit
# Wed, 13 Apr 2022 15:24:18 GMT
CMD ["erl"]
# Wed, 13 Apr 2022 15:24:18 GMT
ENV ELIXIR_VERSION=v1.13.4 LANG=C.UTF-8
# Wed, 13 Apr 2022 15:24:18 GMT
RUN set -xe 	&& ELIXIR_DOWNLOAD_URL="https://github.com/elixir-lang/elixir/archive/${ELIXIR_VERSION}.tar.gz" 	&& ELIXIR_DOWNLOAD_SHA256="95daf2dd3052e6ca7d4d849457eaaba09de52d65ca38d6933c65bc1cdf6b8579" 	&& buildDeps=' 		ca-certificates 		curl 		make 	' 	&& apk add --no-cache --virtual .build-deps $buildDeps 	&& curl -fSL -o elixir-src.tar.gz $ELIXIR_DOWNLOAD_URL 	&& echo "$ELIXIR_DOWNLOAD_SHA256  elixir-src.tar.gz" | sha256sum -c - 	&& mkdir -p /usr/local/src/elixir 	&& tar -xzC /usr/local/src/elixir --strip-components=1 -f elixir-src.tar.gz 	&& rm elixir-src.tar.gz 	&& cd /usr/local/src/elixir 	&& make install clean 	&& find /usr/local/src/elixir/ -type f -not -regex "/usr/local/src/elixir/lib/[^\/]*/lib.*" -exec rm -rf {} + 	&& find /usr/local/src/elixir/ -type d -depth -empty -delete 	&& apk del .build-deps # buildkit
# Wed, 13 Apr 2022 15:24:18 GMT
CMD ["iex"]
```

-	Layers:
	-	`sha256:e322a7994ac3ad46dc8b59d3c5f1c3bbb349c9bf7eea68fd02ca525b756b05d7`  
		Last Modified: Fri, 06 Sep 2024 22:49:15 GMT  
		Size: 3.2 MB (3185185 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:5dc93aef0e3649f73c094a8c8f331024ca7729aeaee20f04cf6c4f8979358f0c`  
		Last Modified: Sat, 07 Sep 2024 02:35:59 GMT  
		Size: 43.9 MB (43868274 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip
	-	`sha256:fdb20fe79b79c6d8e8edbfc615a83a743111c6e61be365a9d0e1eef446ca9443`  
		Last Modified: Sat, 07 Sep 2024 11:45:20 GMT  
		Size: 6.0 MB (5961584 bytes)  
		MIME: application/vnd.oci.image.layer.v1.tar+gzip

### `elixir:1.13-otp-24-alpine` - unknown; unknown

```console
$ docker pull elixir@sha256:ee97e2bcab8ceb58e1927e9547b328355b2339db47c924215f83f576d2a750c8
```

-	Manifest MIME: `application/vnd.docker.distribution.manifest.v2+json`
-	Total Size: **284.4 KB (284378 bytes)**  
	(compressed transfer size, not on-disk size)
-	Image ID: `sha256:265fbb610afdc1f05bdf133d1b2e4ba9c79ad15cf196c77721ef706b275557af`

```dockerfile
```

-	Layers:
	-	`sha256:4e8d7cebb6735ca051f8f073471c283762f04b5f567be14bda680107bd6d995b`  
		Last Modified: Sat, 07 Sep 2024 11:45:20 GMT  
		Size: 274.6 KB (274577 bytes)  
		MIME: application/vnd.in-toto+json
	-	`sha256:26a2ca855fbf8c79e5d1728fddda8a633469caa9cfe932eed82819d2eb4e312b`  
		Last Modified: Sat, 07 Sep 2024 11:45:20 GMT  
		Size: 9.8 KB (9801 bytes)  
		MIME: application/vnd.in-toto+json
