# `crate:5.8.5`

## Docker Metadata

- Image ID: `sha256:8890d0038b570b29ff7603b2554386c90a1cc8a0cce46257a644118501fe9154`
- Created: `2024-10-28T13:54:06Z`
- Virtual Size: ~ 499.40 Mb  
  (total size of all layers on-disk)
- Arch: `linux`/`amd64`
- Entrypoint: `["/docker-entrypoint.sh"]`
- Command: `["crate"]`
- Environment:
  - `PATH=/crate/bin:/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin`
  - `CRATE_HEAP_SIZE=512M`
- Labels:
  - `maintainer=Crate.io <office@crate.io>`
  - `org.opencontainers.image.created=2024-10-28T13:54:06.325139`
  - `org.opencontainers.image.description=CrateDB is a distributed SQL database that handles massive amounts of machine data in real-time.`
  - `org.opencontainers.image.source=https://github.com/crate/docker-crate`
  - `org.opencontainers.image.title=crate`
  - `org.opencontainers.image.url=https://crate.io/products/cratedb/`
  - `org.opencontainers.image.vendor=Crate.io`
  - `org.opencontainers.image.version=5.8.5`

## `rpm` (`.rpm`-based packages)

### `rpm` package: `acl-2.3.1-4.el9.x86_64`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url acl-2.3.1-4.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/acl-2.3.1-4.el9.src.rpm
```

### `rpm` package: `almalinux-gpg-keys-9.4-1.el9.x86_64`

Licenses (from `rpm --query`): GPLv2

Source:

```console
$ dnf --quiet download --source --url almalinux-gpg-keys-9.4-1.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/almalinux-release-9.4-1.el9.src.rpm
```

### `rpm` package: `almalinux-release-9.4-1.el9.x86_64`

Licenses (from `rpm --query`): GPLv2

Source:

```console
$ dnf --quiet download --source --url almalinux-release-9.4-1.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/almalinux-release-9.4-1.el9.src.rpm
```

### `rpm` package: `almalinux-repos-9.4-1.el9.x86_64`

Licenses (from `rpm --query`): GPLv2

Source:

```console
$ dnf --quiet download --source --url almalinux-repos-9.4-1.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/almalinux-release-9.4-1.el9.src.rpm
```

### `rpm` package: `alternatives-1.24-1.el9.x86_64`

Licenses (from `rpm --query`): GPL-2.0-only

Source:

```console
$ dnf --quiet download --source --url alternatives-1.24-1.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/chkconfig-1.24-1.el9.src.rpm
```

### `rpm` package: `audit-libs-3.1.2-2.el9.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url audit-libs-3.1.2-2.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/audit-3.1.2-2.el9.src.rpm
```

### `rpm` package: `basesystem-11-13.el9.noarch`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url basesystem-11-13.el9.noarch
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/basesystem-11-13.el9.src.rpm
```

### `rpm` package: `bash-5.1.8-9.el9.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url bash-5.1.8-9.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/bash-5.1.8-9.el9.src.rpm
```

### `rpm` package: `binutils-2.35.2-43.el9.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url binutils-2.35.2-43.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/binutils-2.35.2-43.el9.src.rpm
```

### `rpm` package: `binutils-gold-2.35.2-43.el9.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url binutils-gold-2.35.2-43.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/binutils-2.35.2-43.el9.src.rpm
```

### `rpm` package: `bzip2-libs-1.0.8-8.el9.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url bzip2-libs-1.0.8-8.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/bzip2-1.0.8-8.el9.src.rpm
```

### `rpm` package: `ca-certificates-2024.2.69_v8.0.303-91.4.el9_4.noarch`

Licenses (from `rpm --query`): MIT AND GPL-2.0-or-later

Source:

```console
$ dnf --quiet download --source --url ca-certificates-2024.2.69_v8.0.303-91.4.el9_4.noarch
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/ca-certificates-2024.2.69_v8.0.303-91.4.el9_4.src.rpm
```

### `rpm` package: `coreutils-single-8.32-35.el9.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url coreutils-single-8.32-35.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/coreutils-8.32-35.el9.src.rpm
```

### `rpm` package: `cracklib-2.9.6-27.el9.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url cracklib-2.9.6-27.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/cracklib-2.9.6-27.el9.src.rpm
```

### `rpm` package: `cracklib-dicts-2.9.6-27.el9.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url cracklib-dicts-2.9.6-27.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/cracklib-2.9.6-27.el9.src.rpm
```

### `rpm` package: `crypto-policies-20240202-1.git283706d.el9.noarch`

Licenses (from `rpm --query`): LGPL-2.1-or-later

Source:

```console
$ dnf --quiet download --source --url crypto-policies-20240202-1.git283706d.el9.noarch
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/crypto-policies-20240202-1.git283706d.el9.src.rpm
```

### `rpm` package: `crypto-policies-scripts-20240202-1.git283706d.el9.noarch`

Licenses (from `rpm --query`): LGPL-2.1-or-later

Source:

```console
$ dnf --quiet download --source --url crypto-policies-scripts-20240202-1.git283706d.el9.noarch
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/crypto-policies-20240202-1.git283706d.el9.src.rpm
```

### `rpm` package: `curl-minimal-7.76.1-29.el9_4.1.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url curl-minimal-7.76.1-29.el9_4.1
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/curl-7.76.1-29.el9_4.1.src.rpm
```

### `rpm` package: `cyrus-sasl-lib-2.1.27-21.el9.x86_64`

Licenses (from `rpm --query`): BSD with advertising

Source:

```console
$ dnf --quiet download --source --url cyrus-sasl-lib-2.1.27-21.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/cyrus-sasl-2.1.27-21.el9.src.rpm
```

### `rpm` package: `dbus-1.12.20-8.el9.x86_64`

Licenses (from `rpm --query`): (GPLv2+ or AFL) and GPLv2+

Source:

```console
$ dnf --quiet download --source --url dbus-1.12.20-8.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/dbus-1.12.20-8.el9.src.rpm
```

### `rpm` package: `dbus-broker-28-7.el9.x86_64`

Licenses (from `rpm --query`): ASL 2.0

Source:

```console
$ dnf --quiet download --source --url dbus-broker-28-7.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/dbus-broker-28-7.el9.src.rpm
```

### `rpm` package: `dbus-common-1.12.20-8.el9.noarch`

Licenses (from `rpm --query`): (GPLv2+ or AFL) and GPLv2+

Source:

```console
$ dnf --quiet download --source --url dbus-common-1.12.20-8.el9.noarch
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/dbus-1.12.20-8.el9.src.rpm
```

### `rpm` package: `diffutils-3.7-12.el9.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url diffutils-3.7-12.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/diffutils-3.7-12.el9.src.rpm
```

### `rpm` package: `dnf-4.14.0-9.el9.alma.1.noarch`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url dnf-4.14.0-9.el9.alma.1.noarch
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/dnf-4.14.0-9.el9.alma.1.src.rpm
```

### `rpm` package: `dnf-data-4.14.0-9.el9.alma.1.noarch`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url dnf-data-4.14.0-9.el9.alma.1.noarch
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/dnf-4.14.0-9.el9.alma.1.src.rpm
```

### `rpm` package: `elfutils-debuginfod-client-0.190-2.el9.x86_64`

Licenses (from `rpm --query`): GPLv3+ and (GPLv2+ or LGPLv3+)

Source:

```console
$ dnf --quiet download --source --url elfutils-debuginfod-client-0.190-2.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/elfutils-0.190-2.el9.src.rpm
```

### `rpm` package: `elfutils-default-yama-scope-0.190-2.el9.noarch`

Licenses (from `rpm --query`): GPLv2+ or LGPLv3+

Source:

```console
$ dnf --quiet download --source --url elfutils-default-yama-scope-0.190-2.el9.noarch
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/elfutils-0.190-2.el9.src.rpm
```

### `rpm` package: `elfutils-libelf-0.190-2.el9.x86_64`

Licenses (from `rpm --query`): GPLv2+ or LGPLv3+

Source:

```console
$ dnf --quiet download --source --url elfutils-libelf-0.190-2.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/elfutils-0.190-2.el9.src.rpm
```

### `rpm` package: `elfutils-libs-0.190-2.el9.x86_64`

Licenses (from `rpm --query`): GPLv2+ or LGPLv3+

Source:

```console
$ dnf --quiet download --source --url elfutils-libs-0.190-2.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/elfutils-0.190-2.el9.src.rpm
```

### `rpm` package: `expat-2.5.0-2.el9_4.1.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url expat-2.5.0-2.el9_4.1
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/expat-2.5.0-2.el9_4.1.src.rpm
```

### `rpm` package: `file-libs-5.39-16.el9.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url file-libs-5.39-16.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/file-5.39-16.el9.src.rpm
```

### `rpm` package: `filesystem-3.16-2.el9.x86_64`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url filesystem-3.16-2.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/filesystem-3.16-2.el9.src.rpm
```

### `rpm` package: `findutils-4.8.0-6.el9.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url findutils-4.8.0-6.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/findutils-4.8.0-6.el9.src.rpm
```

### `rpm` package: `gawk-5.1.0-6.el9.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GPLv2+ and LGPLv2+ and BSD

Source:

```console
$ dnf --quiet download --source --url gawk-5.1.0-6.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/gawk-5.1.0-6.el9.src.rpm
```

### `rpm` package: `gdbm-libs-1.19-4.el9.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url gdbm-libs-1.19-4.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/gdbm-1.19-4.el9.src.rpm
```

### `rpm` package: `glib2-2.68.4-14.el9_4.1.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url glib2-2.68.4-14.el9_4.1
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/glib2-2.68.4-14.el9_4.1.src.rpm
```

### `rpm` package: `glibc-2.34-100.el9_4.3.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL

Source:

```console
$ dnf --quiet download --source --url glibc-2.34-100.el9_4.3
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/glibc-2.34-100.el9_4.3.src.rpm
```

### `rpm` package: `glibc-common-2.34-100.el9_4.3.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL

Source:

```console
$ dnf --quiet download --source --url glibc-common-2.34-100.el9_4.3
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/glibc-2.34-100.el9_4.3.src.rpm
```

### `rpm` package: `glibc-minimal-langpack-2.34-100.el9_4.3.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL

Source:

```console
$ dnf --quiet download --source --url glibc-minimal-langpack-2.34-100.el9_4.3
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/glibc-2.34-100.el9_4.3.src.rpm
```

### `rpm` package: `gmp-6.2.0-13.el9.x86_64`

Licenses (from `rpm --query`): LGPLv3+ or GPLv2+

Source:

```console
$ dnf --quiet download --source --url gmp-6.2.0-13.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/gmp-6.2.0-13.el9.src.rpm
```

### `rpm` package: `gnupg2-2.3.3-4.el9.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url gnupg2-2.3.3-4.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/gnupg2-2.3.3-4.el9.src.rpm
```

### `rpm` package: `gnutls-3.8.3-4.el9_4.x86_64`

Licenses (from `rpm --query`): GPLv3+ and LGPLv2+

Source:

```console
$ dnf --quiet download --source --url gnutls-3.8.3-4.el9_4
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/gnutls-3.8.3-4.el9_4.src.rpm
```

### `rpm` package: `gpg-pubkey-b86b3716-61e69f29`

Licenses (from `rpm --query`): pubkey

**WARNING:** unable to find source (`dnf download` failed or returned no results)!

### `rpm` package: `gpgme-1.15.1-6.el9.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and GPLv3+

Source:

```console
$ dnf --quiet download --source --url gpgme-1.15.1-6.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/gpgme-1.15.1-6.el9.src.rpm
```

### `rpm` package: `grep-3.6-5.el9.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url grep-3.6-5.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/grep-3.6-5.el9.src.rpm
```

### `rpm` package: `gzip-1.12-1.el9.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GFDL

Source:

```console
$ dnf --quiet download --source --url gzip-1.12-1.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/gzip-1.12-1.el9.src.rpm
```

### `rpm` package: `hostname-3.23-6.el9.x86_64`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url hostname-3.23-6.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/hostname-3.23-6.el9.src.rpm
```

### `rpm` package: `ima-evm-utils-1.4-4.el9.x86_64`

Licenses (from `rpm --query`): GPLv2

Source:

```console
$ dnf --quiet download --source --url ima-evm-utils-1.4-4.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/ima-evm-utils-1.4-4.el9.src.rpm
```

### `rpm` package: `iputils-20210202-9.el9.x86_64`

Licenses (from `rpm --query`): BSD and GPLv2+

Source:

```console
$ dnf --quiet download --source --url iputils-20210202-9.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/iputils-20210202-9.el9.src.rpm
```

### `rpm` package: `json-c-0.14-11.el9.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url json-c-0.14-11.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/json-c-0.14-11.el9.src.rpm
```

### `rpm` package: `keyutils-libs-1.6.3-1.el9.x86_64`

Licenses (from `rpm --query`): GPLv2+ and LGPLv2+

Source:

```console
$ dnf --quiet download --source --url keyutils-libs-1.6.3-1.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/keyutils-1.6.3-1.el9.src.rpm
```

### `rpm` package: `kmod-libs-28-9.el9.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url kmod-libs-28-9.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/kmod-28-9.el9.src.rpm
```

### `rpm` package: `krb5-libs-1.21.1-2.el9_4.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url krb5-libs-1.21.1-2.el9_4
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/krb5-1.21.1-2.el9_4.src.rpm
```

### `rpm` package: `less-590-4.el9_4.x86_64`

Licenses (from `rpm --query`): GPLv3+ or BSD

Source:

```console
$ dnf --quiet download --source --url less-590-4.el9_4
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/less-590-4.el9_4.src.rpm
```

### `rpm` package: `libacl-2.3.1-4.el9.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libacl-2.3.1-4.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/acl-2.3.1-4.el9.src.rpm
```

### `rpm` package: `libarchive-3.5.3-4.el9.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url libarchive-3.5.3-4.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libarchive-3.5.3-4.el9.src.rpm
```

### `rpm` package: `libassuan-2.5.5-3.el9.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and GPLv3+

Source:

```console
$ dnf --quiet download --source --url libassuan-2.5.5-3.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libassuan-2.5.5-3.el9.src.rpm
```

### `rpm` package: `libattr-2.5.1-3.el9.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libattr-2.5.1-3.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/attr-2.5.1-3.el9.src.rpm
```

### `rpm` package: `libblkid-2.37.4-18.el9.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libblkid-2.37.4-18.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/util-linux-2.37.4-18.el9.src.rpm
```

### `rpm` package: `libcap-2.48-9.el9_2.x86_64`

Licenses (from `rpm --query`): BSD or GPLv2

Source:

```console
$ dnf --quiet download --source --url libcap-2.48-9.el9_2
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libcap-2.48-9.el9_2.src.rpm
```

### `rpm` package: `libcap-ng-0.8.2-7.el9.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libcap-ng-0.8.2-7.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libcap-ng-0.8.2-7.el9.src.rpm
```

### `rpm` package: `libcom_err-1.46.5-5.el9.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libcom_err-1.46.5-5.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/e2fsprogs-1.46.5-5.el9.src.rpm
```

### `rpm` package: `libcomps-0.1.18-1.el9.x86_64`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url libcomps-0.1.18-1.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libcomps-0.1.18-1.el9.src.rpm
```

### `rpm` package: `libcurl-minimal-7.76.1-29.el9_4.1.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libcurl-minimal-7.76.1-29.el9_4.1
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/curl-7.76.1-29.el9_4.1.src.rpm
```

### `rpm` package: `libdb-5.3.28-53.el9.x86_64`

Licenses (from `rpm --query`): BSD and LGPLv2 and Sleepycat

Source:

```console
$ dnf --quiet download --source --url libdb-5.3.28-53.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libdb-5.3.28-53.el9.src.rpm
```

### `rpm` package: `libdnf-0.69.0-8.el9_4.1.alma.1.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libdnf-0.69.0-8.el9_4.1.alma.1
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libdnf-0.69.0-8.el9_4.1.alma.1.src.rpm
```

### `rpm` package: `libeconf-0.4.1-3.el9_2.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libeconf-0.4.1-3.el9_2
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libeconf-0.4.1-3.el9_2.src.rpm
```

### `rpm` package: `libevent-2.1.12-8.el9_4.x86_64`

Licenses (from `rpm --query`): BSD and ISC

Source:

```console
$ dnf --quiet download --source --url libevent-2.1.12-8.el9_4
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libevent-2.1.12-8.el9_4.src.rpm
```

### `rpm` package: `libfdisk-2.37.4-18.el9.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libfdisk-2.37.4-18.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/util-linux-2.37.4-18.el9.src.rpm
```

### `rpm` package: `libffi-3.4.2-8.el9.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libffi-3.4.2-8.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libffi-3.4.2-8.el9.src.rpm
```

### `rpm` package: `libgcc-11.4.1-3.el9.alma.1.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD

Source:

```console
$ dnf --quiet download --source --url libgcc-11.4.1-3.el9.alma.1
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/gcc-11.4.1-3.el9.alma.1.src.rpm
```

### `rpm` package: `libgcrypt-1.10.0-10.el9_2.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libgcrypt-1.10.0-10.el9_2
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libgcrypt-1.10.0-10.el9_2.src.rpm
```

### `rpm` package: `libgomp-11.4.1-3.el9.alma.1.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD

Source:

```console
$ dnf --quiet download --source --url libgomp-11.4.1-3.el9.alma.1
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/gcc-11.4.1-3.el9.alma.1.src.rpm
```

### `rpm` package: `libgpg-error-1.42-5.el9.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libgpg-error-1.42-5.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libgpg-error-1.42-5.el9.src.rpm
```

### `rpm` package: `libidn2-2.3.0-7.el9.x86_64`

Licenses (from `rpm --query`): (GPLv2+ or LGPLv3+) and GPLv3+

Source:

```console
$ dnf --quiet download --source --url libidn2-2.3.0-7.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libidn2-2.3.0-7.el9.src.rpm
```

### `rpm` package: `libksba-1.5.1-6.el9_1.x86_64`

Licenses (from `rpm --query`): (LGPLv3+ or GPLv2+) and GPLv3+

Source:

```console
$ dnf --quiet download --source --url libksba-1.5.1-6.el9_1
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libksba-1.5.1-6.el9_1.src.rpm
```

### `rpm` package: `libmodulemd-2.13.0-2.el9.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libmodulemd-2.13.0-2.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libmodulemd-2.13.0-2.el9.src.rpm
```

### `rpm` package: `libmount-2.37.4-18.el9.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libmount-2.37.4-18.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/util-linux-2.37.4-18.el9.src.rpm
```

### `rpm` package: `libnghttp2-1.43.0-5.el9_4.3.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libnghttp2-1.43.0-5.el9_4.3
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/nghttp2-1.43.0-5.el9_4.3.src.rpm
```

### `rpm` package: `libpwquality-1.4.4-8.el9.x86_64`

Licenses (from `rpm --query`): BSD or GPLv2+

Source:

```console
$ dnf --quiet download --source --url libpwquality-1.4.4-8.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libpwquality-1.4.4-8.el9.src.rpm
```

### `rpm` package: `librepo-1.14.5-2.el9.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url librepo-1.14.5-2.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/librepo-1.14.5-2.el9.src.rpm
```

### `rpm` package: `libreport-filesystem-2.15.2-6.el9.alma.noarch`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url libreport-filesystem-2.15.2-6.el9.alma.noarch
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libreport-2.15.2-6.el9.alma.src.rpm
```

### `rpm` package: `libseccomp-2.5.2-2.el9.x86_64`

Licenses (from `rpm --query`): LGPLv2

Source:

```console
$ dnf --quiet download --source --url libseccomp-2.5.2-2.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libseccomp-2.5.2-2.el9.src.rpm
```

### `rpm` package: `libselinux-3.6-1.el9.x86_64`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url libselinux-3.6-1.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libselinux-3.6-1.el9.src.rpm
```

### `rpm` package: `libselinux-utils-3.6-1.el9.x86_64`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url libselinux-utils-3.6-1.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libselinux-3.6-1.el9.src.rpm
```

### `rpm` package: `libsemanage-3.6-1.el9.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libsemanage-3.6-1.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libsemanage-3.6-1.el9.src.rpm
```

### `rpm` package: `libsepol-3.6-1.el9.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libsepol-3.6-1.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libsepol-3.6-1.el9.src.rpm
```

### `rpm` package: `libsigsegv-2.13-4.el9.x86_64`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url libsigsegv-2.13-4.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libsigsegv-2.13-4.el9.src.rpm
```

### `rpm` package: `libsmartcols-2.37.4-18.el9.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libsmartcols-2.37.4-18.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/util-linux-2.37.4-18.el9.src.rpm
```

### `rpm` package: `libsolv-0.7.24-2.el9.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url libsolv-0.7.24-2.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libsolv-0.7.24-2.el9.src.rpm
```

### `rpm` package: `libstdc++-11.4.1-3.el9.alma.1.x86_64`

Licenses (from `rpm --query`): GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD

Source:

```console
$ dnf --quiet download --source --url libstdc++-11.4.1-3.el9.alma.1
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/gcc-11.4.1-3.el9.alma.1.src.rpm
```

### `rpm` package: `libtasn1-4.16.0-8.el9_1.x86_64`

Licenses (from `rpm --query`): GPLv3+ and LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libtasn1-4.16.0-8.el9_1
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libtasn1-4.16.0-8.el9_1.src.rpm
```

### `rpm` package: `libunistring-0.9.10-15.el9.x86_64`

Licenses (from `rpm --query`): GPLv2+ or LGPLv3+

Source:

```console
$ dnf --quiet download --source --url libunistring-0.9.10-15.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libunistring-0.9.10-15.el9.src.rpm
```

### `rpm` package: `libutempter-1.2.1-6.el9.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url libutempter-1.2.1-6.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libutempter-1.2.1-6.el9.src.rpm
```

### `rpm` package: `libuuid-2.37.4-18.el9.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url libuuid-2.37.4-18.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/util-linux-2.37.4-18.el9.src.rpm
```

### `rpm` package: `libverto-0.3.2-3.el9.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libverto-0.3.2-3.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libverto-0.3.2-3.el9.src.rpm
```

### `rpm` package: `libxcrypt-4.4.18-3.el9.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and BSD and Public Domain

Source:

```console
$ dnf --quiet download --source --url libxcrypt-4.4.18-3.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libxcrypt-4.4.18-3.el9.src.rpm
```

### `rpm` package: `libxml2-2.9.13-6.el9_4.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libxml2-2.9.13-6.el9_4
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libxml2-2.9.13-6.el9_4.src.rpm
```

### `rpm` package: `libyaml-0.2.5-7.el9.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url libyaml-0.2.5-7.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libyaml-0.2.5-7.el9.src.rpm
```

### `rpm` package: `libzstd-1.5.1-2.el9.x86_64`

Licenses (from `rpm --query`): BSD and GPLv2

Source:

```console
$ dnf --quiet download --source --url libzstd-1.5.1-2.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/zstd-1.5.1-2.el9.src.rpm
```

### `rpm` package: `lua-libs-5.4.4-4.el9.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url lua-libs-5.4.4-4.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/lua-5.4.4-4.el9.src.rpm
```

### `rpm` package: `lz4-libs-1.9.3-5.el9.x86_64`

Licenses (from `rpm --query`): GPLv2+ and BSD

Source:

```console
$ dnf --quiet download --source --url lz4-libs-1.9.3-5.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/lz4-1.9.3-5.el9.src.rpm
```

### `rpm` package: `mpfr-4.1.0-7.el9.x86_64`

Licenses (from `rpm --query`): LGPLv3+

Source:

```console
$ dnf --quiet download --source --url mpfr-4.1.0-7.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/mpfr-4.1.0-7.el9.src.rpm
```

### `rpm` package: `ncurses-base-6.2-10.20210508.el9.noarch`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url ncurses-base-6.2-10.20210508.el9.noarch
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/ncurses-6.2-10.20210508.el9.src.rpm
```

### `rpm` package: `ncurses-libs-6.2-10.20210508.el9.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url ncurses-libs-6.2-10.20210508.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/ncurses-6.2-10.20210508.el9.src.rpm
```

### `rpm` package: `nettle-3.9.1-1.el9.x86_64`

Licenses (from `rpm --query`): LGPLv3+ or GPLv2+

Source:

```console
$ dnf --quiet download --source --url nettle-3.9.1-1.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/nettle-3.9.1-1.el9.src.rpm
```

### `rpm` package: `npth-1.6-8.el9.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url npth-1.6-8.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/npth-1.6-8.el9.src.rpm
```

### `rpm` package: `openldap-2.6.6-3.el9.x86_64`

Licenses (from `rpm --query`): OLDAP-2.8

Source:

```console
$ dnf --quiet download --source --url openldap-2.6.6-3.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/openldap-2.6.6-3.el9.src.rpm
```

### `rpm` package: `openssl-3.0.7-28.el9_4.x86_64`

Licenses (from `rpm --query`): ASL 2.0

Source:

```console
$ dnf --quiet download --source --url openssl-3.0.7-28.el9_4
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/openssl-3.0.7-28.el9_4.src.rpm
```

### `rpm` package: `openssl-libs-3.0.7-28.el9_4.x86_64`

Licenses (from `rpm --query`): ASL 2.0

Source:

```console
$ dnf --quiet download --source --url openssl-libs-3.0.7-28.el9_4
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/openssl-3.0.7-28.el9_4.src.rpm
```

### `rpm` package: `p11-kit-0.25.3-2.el9.x86_64`

Licenses (from `rpm --query`): BSD-3-Clause

Source:

```console
$ dnf --quiet download --source --url p11-kit-0.25.3-2.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/p11-kit-0.25.3-2.el9.src.rpm
```

### `rpm` package: `p11-kit-trust-0.25.3-2.el9.x86_64`

Licenses (from `rpm --query`): BSD-3-Clause

Source:

```console
$ dnf --quiet download --source --url p11-kit-trust-0.25.3-2.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/p11-kit-0.25.3-2.el9.src.rpm
```

### `rpm` package: `pam-1.5.1-19.el9.x86_64`

Licenses (from `rpm --query`): BSD and GPLv2+

Source:

```console
$ dnf --quiet download --source --url pam-1.5.1-19.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/pam-1.5.1-19.el9.src.rpm
```

### `rpm` package: `pcre-8.44-3.el9.3.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url pcre-8.44-3.el9.3
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/pcre-8.44-3.el9.3.src.rpm
```

### `rpm` package: `pcre2-10.40-5.el9.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url pcre2-10.40-5.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/pcre2-10.40-5.el9.src.rpm
```

### `rpm` package: `pcre2-syntax-10.40-5.el9.noarch`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url pcre2-syntax-10.40-5.el9.noarch
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/pcre2-10.40-5.el9.src.rpm
```

### `rpm` package: `policycoreutils-3.6-2.1.el9.x86_64`

Licenses (from `rpm --query`): GPL-2.0-or-later

Source:

```console
$ dnf --quiet download --source --url policycoreutils-3.6-2.1.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/policycoreutils-3.6-2.1.el9.src.rpm
```

### `rpm` package: `popt-1.18-8.el9.x86_64`

Licenses (from `rpm --query`): MIT

Source:

```console
$ dnf --quiet download --source --url popt-1.18-8.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/popt-1.18-8.el9.src.rpm
```

### `rpm` package: `python3-3.9.18-3.el9_4.6.x86_64`

Licenses (from `rpm --query`): Python

Source:

```console
$ dnf --quiet download --source --url python3-3.9.18-3.el9_4.6
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/python3.9-3.9.18-3.el9_4.6.src.rpm
```

### `rpm` package: `python3-dnf-4.14.0-9.el9.alma.1.noarch`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url python3-dnf-4.14.0-9.el9.alma.1.noarch
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/dnf-4.14.0-9.el9.alma.1.src.rpm
```

### `rpm` package: `python3-gpg-1.15.1-6.el9.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and GPLv3+

Source:

```console
$ dnf --quiet download --source --url python3-gpg-1.15.1-6.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/gpgme-1.15.1-6.el9.src.rpm
```

### `rpm` package: `python3-hawkey-0.69.0-8.el9_4.1.alma.1.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url python3-hawkey-0.69.0-8.el9_4.1.alma.1
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libdnf-0.69.0-8.el9_4.1.alma.1.src.rpm
```

### `rpm` package: `python3-libcomps-0.1.18-1.el9.x86_64`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url python3-libcomps-0.1.18-1.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libcomps-0.1.18-1.el9.src.rpm
```

### `rpm` package: `python3-libdnf-0.69.0-8.el9_4.1.alma.1.x86_64`

Licenses (from `rpm --query`): LGPLv2+

Source:

```console
$ dnf --quiet download --source --url python3-libdnf-0.69.0-8.el9_4.1.alma.1
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/libdnf-0.69.0-8.el9_4.1.alma.1.src.rpm
```

### `rpm` package: `python3-libs-3.9.18-3.el9_4.6.x86_64`

Licenses (from `rpm --query`): Python

Source:

```console
$ dnf --quiet download --source --url python3-libs-3.9.18-3.el9_4.6
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/python3.9-3.9.18-3.el9_4.6.src.rpm
```

### `rpm` package: `python3-pip-wheel-21.2.3-8.el9.noarch`

Licenses (from `rpm --query`): MIT and Python and ASL 2.0 and BSD and ISC and LGPLv2 and MPLv2.0 and (ASL 2.0 or BSD)

Source:

```console
$ dnf --quiet download --source --url python3-pip-wheel-21.2.3-8.el9.noarch
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/python-pip-21.2.3-8.el9.src.rpm
```

### `rpm` package: `python3-rpm-4.16.1.3-29.el9.x86_64`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url python3-rpm-4.16.1.3-29.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/rpm-4.16.1.3-29.el9.src.rpm
```

### `rpm` package: `python3-setuptools-wheel-53.0.0-12.el9_4.1.noarch`

Licenses (from `rpm --query`): MIT and (BSD or ASL 2.0)

Source:

```console
$ dnf --quiet download --source --url python3-setuptools-wheel-53.0.0-12.el9_4.1.noarch
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/python-setuptools-53.0.0-12.el9_4.1.src.rpm
```

### `rpm` package: `readline-8.1-4.el9.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url readline-8.1-4.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/readline-8.1-4.el9.src.rpm
```

### `rpm` package: `rootfiles-8.1-31.el9.noarch`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url rootfiles-8.1-31.el9.noarch
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/rootfiles-8.1-31.el9.src.rpm
```

### `rpm` package: `rpm-4.16.1.3-29.el9.x86_64`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url rpm-4.16.1.3-29.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/rpm-4.16.1.3-29.el9.src.rpm
```

### `rpm` package: `rpm-build-libs-4.16.1.3-29.el9.x86_64`

Licenses (from `rpm --query`): GPLv2+ and LGPLv2+ with exceptions

Source:

```console
$ dnf --quiet download --source --url rpm-build-libs-4.16.1.3-29.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/rpm-4.16.1.3-29.el9.src.rpm
```

### `rpm` package: `rpm-libs-4.16.1.3-29.el9.x86_64`

Licenses (from `rpm --query`): GPLv2+ and LGPLv2+ with exceptions

Source:

```console
$ dnf --quiet download --source --url rpm-libs-4.16.1.3-29.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/rpm-4.16.1.3-29.el9.src.rpm
```

### `rpm` package: `rpm-sign-libs-4.16.1.3-29.el9.x86_64`

Licenses (from `rpm --query`): GPLv2+ and LGPLv2+ with exceptions

Source:

```console
$ dnf --quiet download --source --url rpm-sign-libs-4.16.1.3-29.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/rpm-4.16.1.3-29.el9.src.rpm
```

### `rpm` package: `sed-4.8-9.el9.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url sed-4.8-9.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/sed-4.8-9.el9.src.rpm
```

### `rpm` package: `setup-2.13.7-10.el9.noarch`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url setup-2.13.7-10.el9.noarch
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/setup-2.13.7-10.el9.src.rpm
```

### `rpm` package: `shadow-utils-4.9-8.el9.x86_64`

Licenses (from `rpm --query`): BSD and GPLv2+

Source:

```console
$ dnf --quiet download --source --url shadow-utils-4.9-8.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/shadow-utils-4.9-8.el9.src.rpm
```

### `rpm` package: `sqlite-libs-3.34.1-7.el9_3.x86_64`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url sqlite-libs-3.34.1-7.el9_3
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/sqlite-3.34.1-7.el9_3.src.rpm
```

### `rpm` package: `systemd-252-32.el9_4.7.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and MIT and GPLv2+

Source:

```console
$ dnf --quiet download --source --url systemd-252-32.el9_4.7
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/systemd-252-32.el9_4.7.src.rpm
```

### `rpm` package: `systemd-libs-252-32.el9_4.7.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and MIT

Source:

```console
$ dnf --quiet download --source --url systemd-libs-252-32.el9_4.7
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/systemd-252-32.el9_4.7.src.rpm
```

### `rpm` package: `systemd-pam-252-32.el9_4.7.x86_64`

Licenses (from `rpm --query`): LGPLv2+ and MIT and GPLv2+

Source:

```console
$ dnf --quiet download --source --url systemd-pam-252-32.el9_4.7
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/systemd-252-32.el9_4.7.src.rpm
```

### `rpm` package: `systemd-rpm-macros-252-32.el9_4.7.noarch`

Licenses (from `rpm --query`): LGPLv2+ and MIT and GPLv2+

Source:

```console
$ dnf --quiet download --source --url systemd-rpm-macros-252-32.el9_4.7.noarch
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/systemd-252-32.el9_4.7.src.rpm
```

### `rpm` package: `tar-1.34-6.el9_4.1.x86_64`

Licenses (from `rpm --query`): GPLv3+

Source:

```console
$ dnf --quiet download --source --url tar-1.34-6.el9_4.1
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/tar-1.34-6.el9_4.1.src.rpm
```

### `rpm` package: `tpm2-tss-3.2.2-2.el9.x86_64`

Licenses (from `rpm --query`): BSD

Source:

```console
$ dnf --quiet download --source --url tpm2-tss-3.2.2-2.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/tpm2-tss-3.2.2-2.el9.src.rpm
```

### `rpm` package: `tzdata-2024a-1.el9.noarch`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url tzdata-2024a-1.el9.noarch
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/tzdata-2024a-1.el9.src.rpm
```

### `rpm` package: `util-linux-2.37.4-18.el9.x86_64`

Licenses (from `rpm --query`): GPLv2 and GPLv2+ and LGPLv2+ and BSD with advertising and Public Domain

Source:

```console
$ dnf --quiet download --source --url util-linux-2.37.4-18.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/util-linux-2.37.4-18.el9.src.rpm
```

### `rpm` package: `util-linux-core-2.37.4-18.el9.x86_64`

Licenses (from `rpm --query`): GPLv2 and GPLv2+ and LGPLv2+ and BSD with advertising and Public Domain

Source:

```console
$ dnf --quiet download --source --url util-linux-core-2.37.4-18.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/util-linux-2.37.4-18.el9.src.rpm
```

### `rpm` package: `vim-minimal-8.2.2637-20.el9_1.x86_64`

Licenses (from `rpm --query`): Vim and MIT

Source:

```console
$ dnf --quiet download --source --url vim-minimal-8.2.2637-20.el9_1
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/vim-8.2.2637-20.el9_1.src.rpm
```

### `rpm` package: `xz-5.2.5-8.el9_0.x86_64`

Licenses (from `rpm --query`): GPLv2+ and Public Domain

Source:

```console
$ dnf --quiet download --source --url xz-5.2.5-8.el9_0
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/xz-5.2.5-8.el9_0.src.rpm
```

### `rpm` package: `xz-libs-5.2.5-8.el9_0.x86_64`

Licenses (from `rpm --query`): Public Domain

Source:

```console
$ dnf --quiet download --source --url xz-libs-5.2.5-8.el9_0
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/xz-5.2.5-8.el9_0.src.rpm
```

### `rpm` package: `yum-4.14.0-9.el9.alma.1.noarch`

Licenses (from `rpm --query`): GPLv2+

Source:

```console
$ dnf --quiet download --source --url yum-4.14.0-9.el9.alma.1.noarch
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/dnf-4.14.0-9.el9.alma.1.src.rpm
```

### `rpm` package: `zlib-1.2.11-40.el9.x86_64`

Licenses (from `rpm --query`): zlib and Boost

Source:

```console
$ dnf --quiet download --source --url zlib-1.2.11-40.el9
http://vault.almalinux.org/9.4/BaseOS/Source/Packages/zlib-1.2.11-40.el9.src.rpm
```
