﻿// Copyright Dirk Lemstra https://github.com/dlemstra/Magick.NET.
// Licensed under the Apache License, Version 2.0.

using ImageMagick;
using Xunit;

namespace Magick.NET.Core.Tests;

public partial class ThresholdTests
{
    public class TheEqualsMethod
    {
        [Fact]
        public void ShouldReturnFalseWhenInstanceIsNull()
        {
            var point = new Threshold(50.0);

            Assert.False(point.Equals(null));
        }

        [Fact]
        public void ShouldReturnTrueWhenInstanceIsEqual()
        {
            var first = new Threshold(50.0);
            var second = new Threshold(50);

            Assert.True(first.Equals(second));
        }

        [Fact]
        public void ShouldReturnTrueWhenObjectIsEqual()
        {
            var first = new Threshold(50.0);
            var second = new Threshold(50);

            Assert.True(first.Equals((object)second));
        }

        [Fact]
        public void ShouldReturnFalseWhenInstanceIsNotEqual()
        {
            var first = new Threshold(50);
            var second = new Threshold(42);

            Assert.False(first.Equals(second));
        }

        [Fact]
        public void ShouldReturnFalseWhenObjectIsNotEqual()
        {
            var first = new Threshold(50);
            var second = new Threshold(42);

            Assert.False(first.Equals((object)second));
        }
    }
}
