﻿// Copyright Dirk Lemstra https://github.com/dlemstra/Magick.NET.
// Licensed under the Apache License, Version 2.0.

namespace ImageMagick;

internal static class ExifTags
{
    public static ExifParts GetPart(ExifTag tag)
        => (ExifTagValue)(ushort)tag switch
        {
            ExifTagValue.SubfileType or
            ExifTagValue.OldSubfileType or
            ExifTagValue.ImageWidth or
            ExifTagValue.ImageLength or
            ExifTagValue.BitsPerSample or
            ExifTagValue.Compression or
            ExifTagValue.PhotometricInterpretation or
            ExifTagValue.Thresholding or
            ExifTagValue.CellWidth or
            ExifTagValue.CellLength or
            ExifTagValue.FillOrder or
            ExifTagValue.DocumentName or
            ExifTagValue.ImageDescription or
            ExifTagValue.Make or
            ExifTagValue.Model or
            ExifTagValue.StripOffsets or
            ExifTagValue.Orientation or
            ExifTagValue.SamplesPerPixel or
            ExifTagValue.RowsPerStrip or
            ExifTagValue.StripByteCounts or
            ExifTagValue.MinSampleValue or
            ExifTagValue.MaxSampleValue or
            ExifTagValue.XResolution or
            ExifTagValue.YResolution or
            ExifTagValue.PlanarConfiguration or
            ExifTagValue.PageName or
            ExifTagValue.XPosition or
            ExifTagValue.YPosition or
            ExifTagValue.FreeOffsets or
            ExifTagValue.FreeByteCounts or
            ExifTagValue.GrayResponseUnit or
            ExifTagValue.GrayResponseCurve or
            ExifTagValue.T4Options or
            ExifTagValue.T6Options or
            ExifTagValue.ResolutionUnit or
            ExifTagValue.PageNumber or
            ExifTagValue.ColorResponseUnit or
            ExifTagValue.TransferFunction or
            ExifTagValue.Software or
            ExifTagValue.DateTime or
            ExifTagValue.Artist or
            ExifTagValue.HostComputer or
            ExifTagValue.Predictor or
            ExifTagValue.WhitePoint or
            ExifTagValue.PrimaryChromaticities or
            ExifTagValue.ColorMap or
            ExifTagValue.HalftoneHints or
            ExifTagValue.TileWidth or
            ExifTagValue.TileLength or
            ExifTagValue.TileOffsets or
            ExifTagValue.TileByteCounts or
            ExifTagValue.BadFaxLines or
            ExifTagValue.CleanFaxData or
            ExifTagValue.ConsecutiveBadFaxLines or
            ExifTagValue.InkSet or
            ExifTagValue.InkNames or
            ExifTagValue.NumberOfInks or
            ExifTagValue.DotRange or
            ExifTagValue.TargetPrinter or
            ExifTagValue.ExtraSamples or
            ExifTagValue.SampleFormat or
            ExifTagValue.SMinSampleValue or
            ExifTagValue.SMaxSampleValue or
            ExifTagValue.TransferRange or
            ExifTagValue.ClipPath or
            ExifTagValue.XClipPathUnits or
            ExifTagValue.YClipPathUnits or
            ExifTagValue.Indexed or
            ExifTagValue.JPEGTables or
            ExifTagValue.OPIProxy or
            ExifTagValue.ProfileType or
            ExifTagValue.FaxProfile or
            ExifTagValue.CodingMethods or
            ExifTagValue.VersionYear or
            ExifTagValue.ModeNumber or
            ExifTagValue.Decode or
            ExifTagValue.DefaultImageColor or
            ExifTagValue.T82ptions or
            ExifTagValue.JPEGProc or
            ExifTagValue.JPEGInterchangeFormat or
            ExifTagValue.JPEGInterchangeFormatLength or
            ExifTagValue.JPEGRestartInterval or
            ExifTagValue.JPEGLosslessPredictors or
            ExifTagValue.JPEGPointTransforms or
            ExifTagValue.JPEGQTables or
            ExifTagValue.JPEGDCTables or
            ExifTagValue.JPEGACTables or
            ExifTagValue.YCbCrCoefficients or
            ExifTagValue.YCbCrPositioning or
            ExifTagValue.YCbCrSubsampling or
            ExifTagValue.ReferenceBlackWhite or
            ExifTagValue.StripRowCounts or
            ExifTagValue.XMP or
            ExifTagValue.Rating or
            ExifTagValue.RatingPercent or
            ExifTagValue.ImageID or
            ExifTagValue.CFARepeatPatternDim or
            ExifTagValue.CFAPattern2 or
            ExifTagValue.BatteryLevel or
            ExifTagValue.Copyright or
            ExifTagValue.MDFileTag or
            ExifTagValue.MDScalePixel or
            ExifTagValue.MDLabName or
            ExifTagValue.MDSampleInfo or
            ExifTagValue.MDPrepDate or
            ExifTagValue.MDPrepTime or
            ExifTagValue.MDFileUnits or
            ExifTagValue.PixelScale or
            ExifTagValue.IntergraphPacketData or
            ExifTagValue.IntergraphRegisters or
            ExifTagValue.IntergraphMatrix or
            ExifTagValue.ModelTiePoint or
            ExifTagValue.SEMInfo or
            ExifTagValue.ModelTransform or
            ExifTagValue.ImageLayer or
            ExifTagValue.FaxRecvParams or
            ExifTagValue.FaxSubaddress or
            ExifTagValue.FaxRecvTime or
            ExifTagValue.ImageSourceData or
            ExifTagValue.XPTitle or
            ExifTagValue.XPComment or
            ExifTagValue.XPAuthor or
            ExifTagValue.XPKeywords or
            ExifTagValue.XPSubject or
            ExifTagValue.GDALMetadata or
            ExifTagValue.GDALNoData => ExifParts.IfdTags,

            ExifTagValue.ExposureTime or
            ExifTagValue.FNumber or
            ExifTagValue.ExposureProgram or
            ExifTagValue.SpectralSensitivity or
            ExifTagValue.ISOSpeedRatings or
            ExifTagValue.OECF or
            ExifTagValue.Interlace or
            ExifTagValue.TimeZoneOffset or
            ExifTagValue.SelfTimerMode or
            ExifTagValue.SensitivityType or
            ExifTagValue.StandardOutputSensitivity or
            ExifTagValue.RecommendedExposureIndex or
            ExifTagValue.ISOSpeed or
            ExifTagValue.ISOSpeedLatitudeyyy or
            ExifTagValue.ISOSpeedLatitudezzz or
            ExifTagValue.ExifVersion or
            ExifTagValue.DateTimeOriginal or
            ExifTagValue.DateTimeDigitized or
            ExifTagValue.OffsetTime or
            ExifTagValue.OffsetTimeOriginal or
            ExifTagValue.OffsetTimeDigitized or
            ExifTagValue.ComponentsConfiguration or
            ExifTagValue.CompressedBitsPerPixel or
            ExifTagValue.ShutterSpeedValue or
            ExifTagValue.ApertureValue or
            ExifTagValue.BrightnessValue or
            ExifTagValue.ExposureBiasValue or
            ExifTagValue.MaxApertureValue or
            ExifTagValue.SubjectDistance or
            ExifTagValue.MeteringMode or
            ExifTagValue.LightSource or
            ExifTagValue.Flash or
            ExifTagValue.FocalLength or
            ExifTagValue.FlashEnergy2 or
            ExifTagValue.SpatialFrequencyResponse2 or
            ExifTagValue.Noise or
            ExifTagValue.FocalPlaneXResolution2 or
            ExifTagValue.FocalPlaneYResolution2 or
            ExifTagValue.FocalPlaneResolutionUnit2 or
            ExifTagValue.ImageNumber or
            ExifTagValue.SecurityClassification or
            ExifTagValue.ImageHistory or
            ExifTagValue.SubjectArea or
            ExifTagValue.ExposureIndex2 or
            ExifTagValue.TIFFEPStandardID or
            ExifTagValue.SensingMethod2 or
            ExifTagValue.MakerNote or
            ExifTagValue.UserComment or
            ExifTagValue.SubsecTime or
            ExifTagValue.SubsecTimeOriginal or
            ExifTagValue.SubsecTimeDigitized or
            ExifTagValue.AmbientTemperature or
            ExifTagValue.Humidity or
            ExifTagValue.Pressure or
            ExifTagValue.WaterDepth or
            ExifTagValue.Acceleration or
            ExifTagValue.CameraElevationAngle or
            ExifTagValue.FlashpixVersion or
            ExifTagValue.ColorSpace or
            ExifTagValue.PixelXDimension or
            ExifTagValue.PixelYDimension or
            ExifTagValue.RelatedSoundFile or
            ExifTagValue.FlashEnergy or
            ExifTagValue.SpatialFrequencyResponse or
            ExifTagValue.FocalPlaneXResolution or
            ExifTagValue.FocalPlaneYResolution or
            ExifTagValue.FocalPlaneResolutionUnit or
            ExifTagValue.SubjectLocation or
            ExifTagValue.ExposureIndex or
            ExifTagValue.SensingMethod or
            ExifTagValue.FileSource or
            ExifTagValue.SceneType or
            ExifTagValue.CFAPattern or
            ExifTagValue.CustomRendered or
            ExifTagValue.ExposureMode or
            ExifTagValue.WhiteBalance or
            ExifTagValue.DigitalZoomRatio or
            ExifTagValue.FocalLengthIn35mmFilm or
            ExifTagValue.SceneCaptureType or
            ExifTagValue.GainControl or
            ExifTagValue.Contrast or
            ExifTagValue.Saturation or
            ExifTagValue.Sharpness or
            ExifTagValue.DeviceSettingDescription or
            ExifTagValue.SubjectDistanceRange or
            ExifTagValue.ImageUniqueID or
            ExifTagValue.OwnerName or
            ExifTagValue.SerialNumber or
            ExifTagValue.LensInfo or
            ExifTagValue.LensMake or
            ExifTagValue.LensModel or
            ExifTagValue.LensSerialNumber => ExifParts.ExifTags,

            ExifTagValue.GPSVersionID or
            ExifTagValue.GPSLatitudeRef or
            ExifTagValue.GPSLatitude or
            ExifTagValue.GPSLongitudeRef or
            ExifTagValue.GPSLongitude or
            ExifTagValue.GPSAltitudeRef or
            ExifTagValue.GPSAltitude or
            ExifTagValue.GPSTimestamp or
            ExifTagValue.GPSSatellites or
            ExifTagValue.GPSStatus or
            ExifTagValue.GPSMeasureMode or
            ExifTagValue.GPSDOP or
            ExifTagValue.GPSSpeedRef or
            ExifTagValue.GPSSpeed or
            ExifTagValue.GPSTrackRef or
            ExifTagValue.GPSTrack or
            ExifTagValue.GPSImgDirectionRef or
            ExifTagValue.GPSImgDirection or
            ExifTagValue.GPSMapDatum or
            ExifTagValue.GPSDestLatitudeRef or
            ExifTagValue.GPSDestLatitude or
            ExifTagValue.GPSDestLongitudeRef or
            ExifTagValue.GPSDestLongitude or
            ExifTagValue.GPSDestBearingRef or
            ExifTagValue.GPSDestBearing or
            ExifTagValue.GPSDestDistanceRef or
            ExifTagValue.GPSDestDistance or
            ExifTagValue.GPSProcessingMethod or
            ExifTagValue.GPSAreaInformation or
            ExifTagValue.GPSDateStamp or
            ExifTagValue.GPSDifferential => ExifParts.GpsTags,

            _ => ExifParts.None,
        };
}
