﻿// Copyright Dirk Lemstra https://github.com/dlemstra/Magick.NET.
// Licensed under the Apache License, Version 2.0.

namespace ImageMagick;

/// <summary>
/// Specifies exif data types.
/// </summary>
public enum ExifDataType
{
    /// <summary>
    /// Unknown.
    /// </summary>
    Unknown,

    /// <summary>
    /// Byte.
    /// </summary>
    Byte,

    /// <summary>
    /// String.
    /// </summary>
    String,

    /// <summary>
    /// Short.
    /// </summary>
    Short,

    /// <summary>
    /// Long.
    /// </summary>
    Long,

    /// <summary>
    /// Rational.
    /// </summary>
    Rational,

    /// <summary>
    /// SignedByte.
    /// </summary>
    SignedByte,

    /// <summary>
    /// Undefined.
    /// </summary>
    Undefined,

    /// <summary>
    /// SignedShort.
    /// </summary>
    SignedShort,

    /// <summary>
    /// SignedLong.
    /// </summary>
    SignedLong,

    /// <summary>
    /// SignedRational.
    /// </summary>
    SignedRational,

    /// <summary>
    /// Float.
    /// </summary>
    Float,

    /// <summary>
    /// Double.
    /// </summary>
    Double,
}
