﻿// Copyright Dirk Lemstra https://github.com/dlemstra/Magick.NET.
// Licensed under the Apache License, Version 2.0.

namespace ImageMagick;

/// <summary>
/// Specifies the pixel storage types.
/// </summary>
public enum StorageType
{
    /// <summary>
    /// Undefined.
    /// </summary>
    Undefined,

    /// <summary>
    /// Char.
    /// </summary>
    Char,

    /// <summary>
    /// Double.
    /// </summary>
    Double,

    /// <summary>
    /// Float.
    /// </summary>
    Float,

    /// <summary>
    /// Int32.
    /// </summary>
    Int32,

    /// <summary>
    /// Int64.
    /// </summary>
    Int64,

    /// <summary>
    /// Quantum.
    /// </summary>
    Quantum,

    /// <summary>
    /// Short.
    /// </summary>
    Short,
}
