﻿// Copyright Dirk Lemstra https://github.com/dlemstra/Magick.NET.
// Licensed under the Apache License, Version 2.0.

namespace ImageMagick;

/// <summary>
/// Specifies the statistic types.
/// </summary>
public enum StatisticType
{
    /// <summary>
    /// Undefined.
    /// </summary>
    Undefined,

    /// <summary>
    /// Gradient.
    /// </summary>
    Gradient,

    /// <summary>
    /// Maximum.
    /// </summary>
    Maximum,

    /// <summary>
    /// Mean.
    /// </summary>
    Mean,

    /// <summary>
    /// Median.
    /// </summary>
    Median,

    /// <summary>
    /// Minimum.
    /// </summary>
    Minimum,

    /// <summary>
    /// Mode.
    /// </summary>
    Mode,

    /// <summary>
    /// Nonpeak.
    /// </summary>
    Nonpeak,

    /// <summary>
    /// RootMeanSquare.
    /// </summary>
    RootMeanSquare,

    /// <summary>
    /// StandardDeviation.
    /// </summary>
    StandardDeviation,
}
