﻿// Copyright Dirk Lemstra https://github.com/dlemstra/Magick.NET.
// Licensed under the Apache License, Version 2.0.

namespace ImageMagick;

/// <summary>
/// An enumeration for pixel mapping mode.
/// </summary>
public enum PixelMapping
{
    /// <summary>
    /// ABGR.
    /// </summary>
    ABGR,

    /// <summary>
    /// ARGB.
    /// </summary>
    ARGB,

    /// <summary>
    /// CMYK.
    /// </summary>
    CMYK,

    /// <summary>
    /// CMYKA.
    /// </summary>
    CMYKA,

    /// <summary>
    /// BGR.
    /// </summary>
    BGR,

    /// <summary>
    /// BGRA.
    /// </summary>
    BGRA,

    /// <summary>
    /// RGB.
    /// </summary>
    RGB,

    /// <summary>
    /// RGBA.
    /// </summary>
    RGBA,
}
