﻿// Copyright Dirk Lemstra https://github.com/dlemstra/Magick.NET.
// Licensed under the Apache License, Version 2.0.

namespace ImageMagick;

/// <summary>
/// Specifies font weight.
/// </summary>
public enum FontWeight
{
    /// <summary>
    /// Undefined.
    /// </summary>
    Undefined = 0,

    /// <summary>
    /// Thin (100).
    /// </summary>
    Thin = 100,

    /// <summary>
    /// Extra light (200).
    /// </summary>
    ExtraLight = 200,

    /// <summary>
    /// Ultra light (200).
    /// </summary>
    UltraLight = ExtraLight,

    /// <summary>
    /// Light (300).
    /// </summary>
    Light = 300,

    /// <summary>
    /// Normal (400).
    /// </summary>
    Normal = 400,

    /// <summary>
    /// Regular (400).
    /// </summary>
    Regular = Normal,

    /// <summary>
    /// Medium (500).
    /// </summary>
    Medium = 500,

    /// <summary>
    /// Demi bold (600).
    /// </summary>
    DemiBold = 600,

    /// <summary>
    /// Semi bold (600).
    /// </summary>
    SemiBold = DemiBold,

    /// <summary>
    /// Bold (700).
    /// </summary>
    Bold = 700,

    /// <summary>
    /// Extra bold (800).
    /// </summary>
    ExtraBold = 800,

    /// <summary>
    /// Ultra bold (800).
    /// </summary>
    UltraBold = ExtraBold,

    /// <summary>
    /// Heavy (900).
    /// </summary>
    Heavy = 900,

    /// <summary>
    /// Black (900).
    /// </summary>
    Black = Heavy,
}
