﻿// Copyright Dirk Lemstra https://github.com/dlemstra/Magick.NET.
// Licensed under the Apache License, Version 2.0.

namespace ImageMagick;

/// <summary>
/// Specifies font stretch type.
/// </summary>
public enum FontStretch
{
    /// <summary>
    /// Undefined.
    /// </summary>
    Undefined,

    /// <summary>
    /// Normal.
    /// </summary>
    Normal,

    /// <summary>
    /// UltraCondensed.
    /// </summary>
    UltraCondensed,

    /// <summary>
    /// ExtraCondensed.
    /// </summary>
    ExtraCondensed,

    /// <summary>
    /// Condensed.
    /// </summary>
    Condensed,

    /// <summary>
    /// SemiCondensed.
    /// </summary>
    SemiCondensed,

    /// <summary>
    /// SemiExpanded.
    /// </summary>
    SemiExpanded,

    /// <summary>
    /// Expanded.
    /// </summary>
    Expanded,

    /// <summary>
    /// ExtraExpanded.
    /// </summary>
    ExtraExpanded,

    /// <summary>
    /// UltraExpanded.
    /// </summary>
    UltraExpanded,

    /// <summary>
    /// Any.
    /// </summary>
    Any,
}
